// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__35287 = arguments.length;
switch (G__35287) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__35289 = null;
var G__35289__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__35289__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__35289__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__35289 = function(result,flake){
switch(arguments.length){
case 0:
return G__35289__0.call(this);
case 1:
return G__35289__1.call(this,result);
case 2:
return G__35289__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35289.cljs$core$IFn$_invoke$arity$0 = G__35289__0;
G__35289.cljs$core$IFn$_invoke$arity$1 = G__35289__1;
G__35289.cljs$core$IFn$_invoke$arity$2 = G__35289__2;
return G__35289;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__35290 = null;
var G__35290__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__35290__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__35290__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__35290 = function(result,flakes){
switch(arguments.length){
case 0:
return G__35290__0.call(this);
case 1:
return G__35290__1.call(this,result);
case 2:
return G__35290__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35290.cljs$core$IFn$_invoke$arity$0 = G__35290__0;
G__35290.cljs$core$IFn$_invoke$arity$1 = G__35290__1;
G__35290.cljs$core$IFn$_invoke$arity$2 = G__35290__2;
return G__35290;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__35292 = res;
var G__35292__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__35291_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35291_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__35292):G__35292);
var G__35292__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__35292__$1):G__35292__$1);
var G__35292__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__35292__$2):G__35292__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__35292__$3);
} else {
return G__35292__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__35294 = arguments.length;
switch (G__35294) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35577){
var state_val_35578 = (state_35577[(1)]);
if((state_val_35578 === (65))){
var inst_35462 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35462)){
var statearr_35579_35733 = state_35577__$1;
(statearr_35579_35733[(1)] = (66));

} else {
var statearr_35580_35734 = state_35577__$1;
(statearr_35580_35734[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (70))){
var inst_35478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35479 = [cljs.core.cst$kw$_id];
var inst_35480 = flake.o;
var inst_35481 = [inst_35480];
var inst_35482 = cljs.core.PersistentHashMap.fromArrays(inst_35479,inst_35481);
var inst_35483 = [inst_35482,offset_map];
var inst_35484 = (new cljs.core.PersistentVector(null,2,(5),inst_35478,inst_35483,null));
var state_35577__$1 = state_35577;
var statearr_35581_35735 = state_35577__$1;
(statearr_35581_35735[(2)] = inst_35484);

(statearr_35581_35735[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (62))){
var inst_35324 = (state_35577[(7)]);
var inst_35442 = (state_35577[(2)]);
var inst_35443 = fluree.db.util.async.throw_err(inst_35442);
var inst_35444 = cljs.core._deref(cache);
var inst_35445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35446 = flake.o;
var inst_35447 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_35324);
var inst_35448 = [inst_35446,inst_35447];
var inst_35449 = (new cljs.core.PersistentVector(null,2,(5),inst_35445,inst_35448,null));
var inst_35450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35444,inst_35449,inst_35443);
var inst_35451 = cljs.core._vreset_BANG_(cache,inst_35450);
var state_35577__$1 = (function (){var statearr_35582 = state_35577;
(statearr_35582[(8)] = inst_35451);

return statearr_35582;
})();
var statearr_35583_35736 = state_35577__$1;
(statearr_35583_35736[(2)] = inst_35443);

(statearr_35583_35736[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (74))){
var inst_35475 = (state_35577[(9)]);
var inst_35489 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_35490 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35489,inst_35475);
var state_35577__$1 = state_35577;
var statearr_35584_35737 = state_35577__$1;
(statearr_35584_35737[(2)] = inst_35490);

(statearr_35584_35737[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (7))){
var inst_35305 = (state_35577[(10)]);
var state_35577__$1 = state_35577;
var statearr_35585_35738 = state_35577__$1;
(statearr_35585_35738[(2)] = inst_35305);

(statearr_35585_35738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (59))){
var inst_35435 = (state_35577[(11)]);
var state_35577__$1 = state_35577;
var statearr_35586_35739 = state_35577__$1;
(statearr_35586_35739[(2)] = inst_35435);

(statearr_35586_35739[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (86))){
var inst_35337 = (state_35577[(12)]);
var state_35577__$1 = state_35577;
var statearr_35587_35740 = state_35577__$1;
(statearr_35587_35740[(2)] = inst_35337);

(statearr_35587_35740[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (20))){
var inst_35333 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35588_35741 = state_35577__$1;
(statearr_35588_35741[(2)] = inst_35333);

(statearr_35588_35741[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (72))){
var inst_35506 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35589_35742 = state_35577__$1;
(statearr_35589_35742[(2)] = inst_35506);

(statearr_35589_35742[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (58))){
var inst_35530 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35590_35743 = state_35577__$1;
(statearr_35590_35743[(2)] = inst_35530);

(statearr_35590_35743[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (60))){
var inst_35324 = (state_35577[(7)]);
var inst_35438 = flake.o;
var inst_35439 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_35324);
var inst_35440 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_35438,inst_35439);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(62),inst_35440);
} else {
if((state_val_35578 === (27))){
var inst_35342 = (state_35577[(13)]);
var inst_35356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_35342);
var state_35577__$1 = (function (){var statearr_35591 = state_35577;
(statearr_35591[(14)] = inst_35356);

return statearr_35591;
})();
if(cljs.core.truth_(inst_35357)){
var statearr_35592_35744 = state_35577__$1;
(statearr_35592_35744[(1)] = (30));

} else {
var statearr_35593_35745 = state_35577__$1;
(statearr_35593_35745[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (1))){
var state_35577__$1 = state_35577;
var statearr_35594_35746 = state_35577__$1;
(statearr_35594_35746[(2)] = null);

(statearr_35594_35746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (69))){
var inst_35475 = (state_35577[(9)]);
var inst_35474 = (state_35577[(2)]);
var inst_35475__$1 = fluree.db.util.async.throw_err(inst_35474);
var inst_35476 = cljs.core.empty_QMARK_(inst_35475__$1);
var state_35577__$1 = (function (){var statearr_35595 = state_35577;
(statearr_35595[(9)] = inst_35475__$1);

return statearr_35595;
})();
if(inst_35476){
var statearr_35596_35747 = state_35577__$1;
(statearr_35596_35747[(1)] = (70));

} else {
var statearr_35597_35748 = state_35577__$1;
(statearr_35597_35748[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (24))){
var inst_35342 = (state_35577[(13)]);
var inst_35341 = (state_35577[(15)]);
var inst_35345 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_35341);
var inst_35346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_35342);
var inst_35347 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_35346);
var inst_35348 = ((inst_35345) && (inst_35347));
var state_35577__$1 = state_35577;
var statearr_35598_35749 = state_35577__$1;
(statearr_35598_35749[(2)] = inst_35348);

(statearr_35598_35749[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (55))){
var inst_35419 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(48),inst_35419);
} else {
if((state_val_35578 === (85))){
var inst_35524 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35599_35750 = state_35577__$1;
(statearr_35599_35750[(2)] = inst_35524);

(statearr_35599_35750[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (39))){
var inst_35384 = (state_35577[(16)]);
var inst_35324 = (state_35577[(7)]);
var inst_35384__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = (function (){var statearr_35600 = state_35577;
(statearr_35600[(16)] = inst_35384__$1);

return statearr_35600;
})();
if(cljs.core.truth_(inst_35384__$1)){
var statearr_35601_35751 = state_35577__$1;
(statearr_35601_35751[(1)] = (42));

} else {
var statearr_35602_35752 = state_35577__$1;
(statearr_35602_35752[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (88))){
var inst_35544 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35544)){
var statearr_35603_35753 = state_35577__$1;
(statearr_35603_35753[(1)] = (89));

} else {
var statearr_35604_35754 = state_35577__$1;
(statearr_35604_35754[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (46))){
var inst_35324 = (state_35577[(7)]);
var inst_35426 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35426)){
var statearr_35605_35755 = state_35577__$1;
(statearr_35605_35755[(1)] = (56));

} else {
var statearr_35606_35756 = state_35577__$1;
(statearr_35606_35756[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (4))){
var inst_35295 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35607_35757 = state_35577__$1;
(statearr_35607_35757[(2)] = inst_35295);

(statearr_35607_35757[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (77))){
var inst_35335 = (state_35577[(17)]);
var inst_35342 = (state_35577[(13)]);
var inst_35475 = (state_35577[(9)]);
var inst_35341 = (state_35577[(15)]);
var inst_35493 = (state_35577[(18)]);
var inst_35324 = (state_35577[(7)]);
var inst_35318 = (state_35577[(19)]);
var inst_35340 = (state_35577[(20)]);
var inst_35337 = (state_35577[(12)]);
var inst_35339 = (state_35577[(21)]);
var inst_35336 = (state_35577[(22)]);
var inst_35338 = (state_35577[(23)]);
var inst_35495 = (function (){var p = inst_35342;
var pred_spec__$1 = inst_35318;
var orderBy = inst_35340;
var children = inst_35475;
var multi_QMARK_ = inst_35337;
var limit = inst_35339;
var offset = inst_35341;
var G__35487 = inst_35493;
var k = inst_35335;
var pred_spec_SINGLEQUOTE_ = inst_35324;
var map__35301 = inst_35336;
var ref_QMARK_ = inst_35338;
return (function (n){
var G__35608 = db;
var G__35609 = cache;
var G__35610 = fuel;
var G__35611 = max_fuel;
var G__35612 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__35613 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__35608,G__35609,G__35610,G__35611,G__35612,G__35613) : fluree.db.query.fql.flakes__GT_res.call(null,G__35608,G__35609,G__35610,G__35611,G__35612,G__35613));
});
})();
var inst_35496 = (inst_35495.cljs$core$IFn$_invoke$arity$1 ? inst_35495.cljs$core$IFn$_invoke$arity$1(inst_35493) : inst_35495.call(null,inst_35493));
var state_35577__$1 = state_35577;
var statearr_35614_35758 = state_35577__$1;
(statearr_35614_35758[(2)] = inst_35496);

(statearr_35614_35758[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (95))){
var inst_35538 = (state_35577[(24)]);
var inst_35563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35564 = [acc,inst_35538];
var inst_35565 = (new cljs.core.PersistentVector(null,2,(5),inst_35563,inst_35564,null));
var state_35577__$1 = state_35577;
var statearr_35615_35759 = state_35577__$1;
(statearr_35615_35759[(2)] = inst_35565);

(statearr_35615_35759[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (54))){
var inst_35413 = (state_35577[(25)]);
var state_35577__$1 = state_35577;
var statearr_35616_35760 = state_35577__$1;
(statearr_35616_35760[(2)] = inst_35413);

(statearr_35616_35760[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (92))){
var inst_35335 = (state_35577[(17)]);
var inst_35538 = (state_35577[(24)]);
var inst_35537 = (state_35577[(26)]);
var inst_35557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35558 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_35335,inst_35537);
var inst_35559 = [inst_35558,inst_35538];
var inst_35560 = (new cljs.core.PersistentVector(null,2,(5),inst_35557,inst_35559,null));
var state_35577__$1 = state_35577;
var statearr_35617_35761 = state_35577__$1;
(statearr_35617_35761[(2)] = inst_35560);

(statearr_35617_35761[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (15))){
var inst_35325 = (state_35577[(27)]);
var state_35577__$1 = state_35577;
var statearr_35618_35762 = state_35577__$1;
(statearr_35618_35762[(2)] = inst_35325);

(statearr_35618_35762[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (48))){
var inst_35398 = (state_35577[(28)]);
var inst_35421 = (state_35577[(2)]);
var inst_35422 = fluree.db.util.async.throw_err(inst_35421);
var inst_35423 = [inst_35422,offset_map];
var inst_35424 = (new cljs.core.PersistentVector(null,2,(5),inst_35398,inst_35423,null));
var state_35577__$1 = state_35577;
var statearr_35619_35763 = state_35577__$1;
(statearr_35619_35763[(2)] = inst_35424);

(statearr_35619_35763[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (50))){
var inst_35407 = (state_35577[(29)]);
var inst_35409 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_35410 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35409,inst_35407);
var state_35577__$1 = state_35577;
var statearr_35620_35764 = state_35577__$1;
(statearr_35620_35764[(2)] = inst_35410);

(statearr_35620_35764[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (75))){
var inst_35475 = (state_35577[(9)]);
var state_35577__$1 = state_35577;
var statearr_35621_35765 = state_35577__$1;
(statearr_35621_35765[(2)] = inst_35475);

(statearr_35621_35765[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (21))){
var inst_35341 = (state_35577[(15)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35341)){
var statearr_35622_35766 = state_35577__$1;
(statearr_35622_35766[(1)] = (24));

} else {
var statearr_35623_35767 = state_35577__$1;
(statearr_35623_35767[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (31))){
var inst_35342 = (state_35577[(13)]);
var inst_35341 = (state_35577[(15)]);
var inst_35361 = (inst_35341 - (1));
var inst_35362 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_35342,inst_35361);
var state_35577__$1 = state_35577;
var statearr_35624_35768 = state_35577__$1;
(statearr_35624_35768[(2)] = inst_35362);

(statearr_35624_35768[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (32))){
var inst_35356 = (state_35577[(14)]);
var inst_35364 = (state_35577[(2)]);
var inst_35365 = [null,inst_35364];
var inst_35366 = (new cljs.core.PersistentVector(null,2,(5),inst_35356,inst_35365,null));
var state_35577__$1 = state_35577;
var statearr_35625_35769 = state_35577__$1;
(statearr_35625_35769[(2)] = inst_35366);

(statearr_35625_35769[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (40))){
var state_35577__$1 = state_35577;
var statearr_35626_35770 = state_35577__$1;
(statearr_35626_35770[(2)] = false);

(statearr_35626_35770[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (91))){
var inst_35572 = (state_35577[(2)]);
var _ = (function (){var statearr_35627 = state_35577;
(statearr_35627[(4)] = cljs.core.rest((state_35577[(4)])));

return statearr_35627;
})();
var state_35577__$1 = state_35577;
var statearr_35628_35771 = state_35577__$1;
(statearr_35628_35771[(2)] = inst_35572);

(statearr_35628_35771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (56))){
var inst_35324 = (state_35577[(7)]);
var inst_35435 = (state_35577[(11)]);
var inst_35428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35429 = cljs.core.deref(cache);
var inst_35430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35431 = flake.o;
var inst_35432 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_35324);
var inst_35433 = [inst_35431,inst_35432];
var inst_35434 = (new cljs.core.PersistentVector(null,2,(5),inst_35430,inst_35433,null));
var inst_35435__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35429,inst_35434);
var state_35577__$1 = (function (){var statearr_35629 = state_35577;
(statearr_35629[(30)] = inst_35428);

(statearr_35629[(11)] = inst_35435__$1);

return statearr_35629;
})();
if(cljs.core.truth_(inst_35435__$1)){
var statearr_35630_35772 = state_35577__$1;
(statearr_35630_35772[(1)] = (59));

} else {
var statearr_35631_35773 = state_35577__$1;
(statearr_35631_35773[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (33))){
var inst_35335 = (state_35577[(17)]);
var inst_35340 = (state_35577[(20)]);
var inst_35339 = (state_35577[(21)]);
var inst_35369 = cljs.core.not(inst_35340);
var inst_35370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_35335);
var inst_35371 = cljs.core.count(inst_35370);
var inst_35372 = (inst_35371 >= inst_35339);
var inst_35373 = ((inst_35369) && (inst_35372));
var state_35577__$1 = state_35577;
var statearr_35632_35774 = state_35577__$1;
(statearr_35632_35774[(2)] = inst_35373);

(statearr_35632_35774[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (13))){
var inst_35318 = (state_35577[(19)]);
var inst_35322 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35318,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_35577__$1 = state_35577;
var statearr_35633_35775 = state_35577__$1;
(statearr_35633_35775[(2)] = inst_35322);

(statearr_35633_35775[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (22))){
var inst_35337 = (state_35577[(12)]);
var state_35577__$1 = state_35577;
var statearr_35634_35776 = state_35577__$1;
(statearr_35634_35776[(2)] = inst_35337);

(statearr_35634_35776[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (90))){
var inst_35537 = (state_35577[(26)]);
var inst_35554 = (inst_35537 == null);
var inst_35555 = cljs.core.not(inst_35554);
var state_35577__$1 = state_35577;
if(inst_35555){
var statearr_35635_35777 = state_35577__$1;
(statearr_35635_35777[(1)] = (92));

} else {
var statearr_35636_35778 = state_35577__$1;
(statearr_35636_35778[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (36))){
var inst_35378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35379 = [null,offset_map];
var inst_35380 = (new cljs.core.PersistentVector(null,2,(5),inst_35378,inst_35379,null));
var state_35577__$1 = state_35577;
var statearr_35637_35779 = state_35577__$1;
(statearr_35637_35779[(2)] = inst_35380);

(statearr_35637_35779[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (41))){
var inst_35392 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35392)){
var statearr_35638_35780 = state_35577__$1;
(statearr_35638_35780[(1)] = (45));

} else {
var statearr_35639_35781 = state_35577__$1;
(statearr_35639_35781[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (89))){
var inst_35335 = (state_35577[(17)]);
var inst_35538 = (state_35577[(24)]);
var inst_35537 = (state_35577[(26)]);
var inst_35546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35547 = cljs.core.PersistentVector.EMPTY;
var inst_35548 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_35335,inst_35547);
var inst_35549 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35548,inst_35537);
var inst_35550 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_35335,inst_35549);
var inst_35551 = [inst_35550,inst_35538];
var inst_35552 = (new cljs.core.PersistentVector(null,2,(5),inst_35546,inst_35551,null));
var state_35577__$1 = state_35577;
var statearr_35640_35782 = state_35577__$1;
(statearr_35640_35782[(2)] = inst_35552);

(statearr_35640_35782[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (43))){
var inst_35324 = (state_35577[(7)]);
var inst_35387 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = state_35577;
var statearr_35641_35783 = state_35577__$1;
(statearr_35641_35783[(2)] = inst_35387);

(statearr_35641_35783[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (61))){
var inst_35428 = (state_35577[(30)]);
var inst_35453 = (state_35577[(2)]);
var inst_35454 = [inst_35453,offset_map];
var inst_35455 = (new cljs.core.PersistentVector(null,2,(5),inst_35428,inst_35454,null));
var state_35577__$1 = state_35577;
var statearr_35642_35784 = state_35577__$1;
(statearr_35642_35784[(2)] = inst_35455);

(statearr_35642_35784[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (29))){
var inst_35537 = (state_35577[(26)]);
var inst_35536 = (state_35577[(2)]);
var inst_35537__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35536,(0),null);
var inst_35538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35536,(1),null);
var inst_35539 = (inst_35537__$1 == null);
var inst_35540 = cljs.core.not(inst_35539);
var state_35577__$1 = (function (){var statearr_35643 = state_35577;
(statearr_35643[(24)] = inst_35538);

(statearr_35643[(26)] = inst_35537__$1);

return statearr_35643;
})();
if(inst_35540){
var statearr_35644_35785 = state_35577__$1;
(statearr_35644_35785[(1)] = (86));

} else {
var statearr_35645_35786 = state_35577__$1;
(statearr_35645_35786[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (44))){
var inst_35389 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35646_35787 = state_35577__$1;
(statearr_35646_35787[(2)] = inst_35389);

(statearr_35646_35787[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (93))){
var state_35577__$1 = state_35577;
var statearr_35647_35788 = state_35577__$1;
(statearr_35647_35788[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (6))){
var inst_35307 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_35308 = (inst_35307 == null);
var state_35577__$1 = state_35577;
var statearr_35649_35789 = state_35577__$1;
(statearr_35649_35789[(2)] = inst_35308);

(statearr_35649_35789[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (28))){
var inst_35337 = (state_35577[(12)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35337)){
var statearr_35650_35790 = state_35577__$1;
(statearr_35650_35790[(1)] = (33));

} else {
var statearr_35651_35791 = state_35577__$1;
(statearr_35651_35791[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (64))){
var inst_35457 = (state_35577[(31)]);
var state_35577__$1 = state_35577;
var statearr_35652_35792 = state_35577__$1;
(statearr_35652_35792[(2)] = inst_35457);

(statearr_35652_35792[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (51))){
var inst_35407 = (state_35577[(29)]);
var state_35577__$1 = state_35577;
var statearr_35653_35793 = state_35577__$1;
(statearr_35653_35793[(2)] = inst_35407);

(statearr_35653_35793[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (25))){
var inst_35341 = (state_35577[(15)]);
var state_35577__$1 = state_35577;
var statearr_35654_35794 = state_35577__$1;
(statearr_35654_35794[(2)] = inst_35341);

(statearr_35654_35794[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (34))){
var inst_35337 = (state_35577[(12)]);
var state_35577__$1 = state_35577;
var statearr_35655_35795 = state_35577__$1;
(statearr_35655_35795[(2)] = inst_35337);

(statearr_35655_35795[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (17))){
var inst_35324 = (state_35577[(7)]);
var inst_35337 = (state_35577[(12)]);
var inst_35336 = (state_35577[(22)]);
var inst_35335 = (state_35577[(2)]);
var inst_35336__$1 = cljs.core.__destructure_map(inst_35324);
var inst_35337__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_35338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_35339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$limit);
var inst_35340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$orderBy);
var inst_35341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$offset);
var inst_35342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35336__$1,cljs.core.cst$kw$p);
var state_35577__$1 = (function (){var statearr_35656 = state_35577;
(statearr_35656[(17)] = inst_35335);

(statearr_35656[(13)] = inst_35342);

(statearr_35656[(15)] = inst_35341);

(statearr_35656[(20)] = inst_35340);

(statearr_35656[(12)] = inst_35337__$1);

(statearr_35656[(21)] = inst_35339);

(statearr_35656[(22)] = inst_35336__$1);

(statearr_35656[(23)] = inst_35338);

return statearr_35656;
})();
if(cljs.core.truth_(inst_35337__$1)){
var statearr_35657_35796 = state_35577__$1;
(statearr_35657_35796[(1)] = (21));

} else {
var statearr_35658_35797 = state_35577__$1;
(statearr_35658_35797[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (3))){
var inst_35575 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35577__$1,inst_35575);
} else {
if((state_val_35578 === (12))){
var inst_35318 = (state_35577[(19)]);
var state_35577__$1 = state_35577;
var statearr_35659_35798 = state_35577__$1;
(statearr_35659_35798[(2)] = inst_35318);

(statearr_35659_35798[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (2))){
var inst_35305 = (state_35577[(10)]);
var _ = (function (){var statearr_35660 = state_35577;
(statearr_35660[(4)] = cljs.core.cons((5),(state_35577[(4)])));

return statearr_35660;
})();
var inst_35305__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_35577__$1 = (function (){var statearr_35661 = state_35577;
(statearr_35661[(10)] = inst_35305__$1);

return statearr_35661;
})();
if(cljs.core.truth_(inst_35305__$1)){
var statearr_35662_35799 = state_35577__$1;
(statearr_35662_35799[(1)] = (6));

} else {
var statearr_35663_35800 = state_35577__$1;
(statearr_35663_35800[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (66))){
var inst_35324 = (state_35577[(7)]);
var inst_35464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35465 = flake.o;
var inst_35466 = [inst_35465];
var inst_35467 = (new cljs.core.PersistentVector(null,1,(5),inst_35464,inst_35466,null));
var inst_35468 = [cljs.core.cst$kw$limit];
var inst_35469 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_35324);
var inst_35470 = [inst_35469];
var inst_35471 = cljs.core.PersistentHashMap.fromArrays(inst_35468,inst_35470);
var inst_35472 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35467,inst_35471);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(69),inst_35472);
} else {
if((state_val_35578 === (23))){
var inst_35354 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35354)){
var statearr_35664_35801 = state_35577__$1;
(statearr_35664_35801[(1)] = (27));

} else {
var statearr_35665_35802 = state_35577__$1;
(statearr_35665_35802[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (47))){
var inst_35532 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35666_35803 = state_35577__$1;
(statearr_35666_35803[(2)] = inst_35532);

(statearr_35666_35803[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (35))){
var inst_35376 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35376)){
var statearr_35667_35804 = state_35577__$1;
(statearr_35667_35804[(1)] = (36));

} else {
var statearr_35668_35805 = state_35577__$1;
(statearr_35668_35805[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (82))){
var inst_35526 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35669_35806 = state_35577__$1;
(statearr_35669_35806[(2)] = inst_35526);

(statearr_35669_35806[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (76))){
var inst_35493 = (state_35577[(2)]);
var state_35577__$1 = (function (){var statearr_35670 = state_35577;
(statearr_35670[(18)] = inst_35493);

return statearr_35670;
})();
var statearr_35671_35807 = state_35577__$1;
(statearr_35671_35807[(1)] = (77));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (97))){
var inst_35568 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35673_35808 = state_35577__$1;
(statearr_35673_35808[(2)] = inst_35568);

(statearr_35673_35808[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (19))){
var inst_35324 = (state_35577[(7)]);
var inst_35331 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = state_35577;
var statearr_35674_35809 = state_35577__$1;
(statearr_35674_35809[(2)] = inst_35331);

(statearr_35674_35809[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (57))){
var inst_35457 = (state_35577[(31)]);
var inst_35457__$1 = componentFollow_QMARK_;
var state_35577__$1 = (function (){var statearr_35675 = state_35577;
(statearr_35675[(31)] = inst_35457__$1);

return statearr_35675;
})();
if(cljs.core.truth_(inst_35457__$1)){
var statearr_35676_35810 = state_35577__$1;
(statearr_35676_35810[(1)] = (63));

} else {
var statearr_35677_35811 = state_35577__$1;
(statearr_35677_35811[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (68))){
var inst_35528 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35678_35812 = state_35577__$1;
(statearr_35678_35812[(2)] = inst_35528);

(statearr_35678_35812[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (11))){
var inst_35318 = (state_35577[(19)]);
var inst_35318__$1 = (state_35577[(2)]);
var inst_35319 = cljs.core.contains_QMARK_(inst_35318__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_35577__$1 = (function (){var statearr_35680 = state_35577;
(statearr_35680[(19)] = inst_35318__$1);

return statearr_35680;
})();
if(inst_35319){
var statearr_35681_35813 = state_35577__$1;
(statearr_35681_35813[(1)] = (12));

} else {
var statearr_35682_35814 = state_35577__$1;
(statearr_35682_35814[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (9))){
var inst_35313 = flake.p;
var inst_35314 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_35315 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_35313,inst_35314);
var state_35577__$1 = state_35577;
var statearr_35683_35815 = state_35577__$1;
(statearr_35683_35815[(2)] = inst_35315);

(statearr_35683_35815[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (5))){
var _ = (function (){var statearr_35684 = state_35577;
(statearr_35684[(4)] = cljs.core.rest((state_35577[(4)])));

return statearr_35684;
})();
var state_35577__$1 = state_35577;
var ex35679 = (state_35577__$1[(2)]);
var statearr_35685_35816 = state_35577__$1;
(statearr_35685_35816[(5)] = ex35679);


if((ex35679 instanceof Error)){
var statearr_35686_35817 = state_35577__$1;
(statearr_35686_35817[(1)] = (4));

(statearr_35686_35817[(5)] = null);

} else {
throw ex35679;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (83))){
var inst_35518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35519 = flake.o;
var inst_35520 = [inst_35519,offset_map];
var inst_35521 = (new cljs.core.PersistentVector(null,2,(5),inst_35518,inst_35520,null));
var state_35577__$1 = state_35577;
var statearr_35687_35818 = state_35577__$1;
(statearr_35687_35818[(2)] = inst_35521);

(statearr_35687_35818[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (14))){
var inst_35325 = (state_35577[(27)]);
var inst_35324 = (state_35577[(7)]);
var inst_35324__$1 = (state_35577[(2)]);
var inst_35325__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_35324__$1);
var state_35577__$1 = (function (){var statearr_35688 = state_35577;
(statearr_35688[(27)] = inst_35325__$1);

(statearr_35688[(7)] = inst_35324__$1);

return statearr_35688;
})();
if(cljs.core.truth_(inst_35325__$1)){
var statearr_35689_35819 = state_35577__$1;
(statearr_35689_35819[(1)] = (15));

} else {
var statearr_35690_35820 = state_35577__$1;
(statearr_35690_35820[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (45))){
var inst_35324 = (state_35577[(7)]);
var inst_35394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35395 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_35396 = (new cljs.core.PersistentVector(null,3,(5),inst_35394,inst_35395,null));
var inst_35397 = cljs.core.select_keys(inst_35324,inst_35396);
var inst_35398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35401 = flake.o;
var inst_35402 = [inst_35401];
var inst_35403 = (new cljs.core.PersistentVector(null,1,(5),inst_35400,inst_35402,null));
var inst_35404 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35403);
var state_35577__$1 = (function (){var statearr_35691 = state_35577;
(statearr_35691[(28)] = inst_35398);

(statearr_35691[(32)] = inst_35397);

return statearr_35691;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(49),inst_35404);
} else {
if((state_val_35578 === (53))){
var inst_35335 = (state_35577[(17)]);
var inst_35342 = (state_35577[(13)]);
var inst_35413 = (state_35577[(25)]);
var inst_35341 = (state_35577[(15)]);
var inst_35324 = (state_35577[(7)]);
var inst_35318 = (state_35577[(19)]);
var inst_35340 = (state_35577[(20)]);
var inst_35337 = (state_35577[(12)]);
var inst_35397 = (state_35577[(32)]);
var inst_35339 = (state_35577[(21)]);
var inst_35336 = (state_35577[(22)]);
var inst_35338 = (state_35577[(23)]);
var inst_35415 = (function (){var p = inst_35342;
var pred_spec__$1 = inst_35318;
var orderBy = inst_35340;
var nested_select_spec = inst_35397;
var multi_QMARK_ = inst_35337;
var limit = inst_35339;
var offset = inst_35341;
var G__35399 = inst_35413;
var k = inst_35335;
var pred_spec_SINGLEQUOTE_ = inst_35324;
var map__35301 = inst_35336;
var ref_QMARK_ = inst_35338;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_35416 = (inst_35415.cljs$core$IFn$_invoke$arity$1 ? inst_35415.cljs$core$IFn$_invoke$arity$1(inst_35413) : inst_35415.call(null,inst_35413));
var state_35577__$1 = state_35577;
var statearr_35692_35821 = state_35577__$1;
(statearr_35692_35821[(2)] = inst_35416);

(statearr_35692_35821[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (78))){
var inst_35493 = (state_35577[(18)]);
var state_35577__$1 = state_35577;
var statearr_35693_35822 = state_35577__$1;
(statearr_35693_35822[(2)] = inst_35493);

(statearr_35693_35822[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (26))){
var inst_35351 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35694_35823 = state_35577__$1;
(statearr_35694_35823[(2)] = inst_35351);

(statearr_35694_35823[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (16))){
var inst_35324 = (state_35577[(7)]);
var inst_35328 = (state_35577[(33)]);
var inst_35328__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = (function (){var statearr_35695 = state_35577;
(statearr_35695[(33)] = inst_35328__$1);

return statearr_35695;
})();
if(cljs.core.truth_(inst_35328__$1)){
var statearr_35696_35824 = state_35577__$1;
(statearr_35696_35824[(1)] = (18));

} else {
var statearr_35697_35825 = state_35577__$1;
(statearr_35697_35825[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (81))){
var state_35577__$1 = state_35577;
var statearr_35698_35826 = state_35577__$1;
(statearr_35698_35826[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (79))){
var inst_35499 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(73),inst_35499);
} else {
if((state_val_35578 === (38))){
var inst_35534 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35700_35827 = state_35577__$1;
(statearr_35700_35827[(2)] = inst_35534);

(statearr_35700_35827[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (87))){
var state_35577__$1 = state_35577;
var statearr_35701_35828 = state_35577__$1;
(statearr_35701_35828[(2)] = false);

(statearr_35701_35828[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (30))){
var inst_35342 = (state_35577[(13)]);
var inst_35359 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_35342,cljs.core.dec);
var state_35577__$1 = state_35577;
var statearr_35702_35829 = state_35577__$1;
(statearr_35702_35829[(2)] = inst_35359);

(statearr_35702_35829[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (73))){
var inst_35486 = (state_35577[(34)]);
var inst_35501 = (state_35577[(2)]);
var inst_35502 = fluree.db.util.async.throw_err(inst_35501);
var inst_35503 = [inst_35502,offset_map];
var inst_35504 = (new cljs.core.PersistentVector(null,2,(5),inst_35486,inst_35503,null));
var state_35577__$1 = state_35577;
var statearr_35703_35830 = state_35577__$1;
(statearr_35703_35830[(2)] = inst_35504);

(statearr_35703_35830[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (96))){
var state_35577__$1 = state_35577;
var statearr_35704_35831 = state_35577__$1;
(statearr_35704_35831[(2)] = null);

(statearr_35704_35831[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (10))){
var state_35577__$1 = state_35577;
var statearr_35705_35832 = state_35577__$1;
(statearr_35705_35832[(2)] = pred_spec);

(statearr_35705_35832[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (18))){
var inst_35328 = (state_35577[(33)]);
var state_35577__$1 = state_35577;
var statearr_35706_35833 = state_35577__$1;
(statearr_35706_35833[(2)] = inst_35328);

(statearr_35706_35833[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (52))){
var inst_35413 = (state_35577[(2)]);
var state_35577__$1 = (function (){var statearr_35707 = state_35577;
(statearr_35707[(25)] = inst_35413);

return statearr_35707;
})();
var statearr_35708_35834 = state_35577__$1;
(statearr_35708_35834[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (67))){
var inst_35338 = (state_35577[(23)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35338)){
var statearr_35710_35835 = state_35577__$1;
(statearr_35710_35835[(1)] = (80));

} else {
var statearr_35711_35836 = state_35577__$1;
(statearr_35711_35836[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (71))){
var inst_35486 = cljs.core.PersistentVector.EMPTY_NODE;
var state_35577__$1 = (function (){var statearr_35712 = state_35577;
(statearr_35712[(34)] = inst_35486);

return statearr_35712;
})();
if(cljs.core.truth_(fuel)){
var statearr_35713_35837 = state_35577__$1;
(statearr_35713_35837[(1)] = (74));

} else {
var statearr_35714_35838 = state_35577__$1;
(statearr_35714_35838[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (42))){
var inst_35384 = (state_35577[(16)]);
var state_35577__$1 = state_35577;
var statearr_35715_35839 = state_35577__$1;
(statearr_35715_35839[(2)] = inst_35384);

(statearr_35715_35839[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (80))){
var inst_35509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35510 = [cljs.core.cst$kw$_id];
var inst_35511 = flake.o;
var inst_35512 = [inst_35511];
var inst_35513 = cljs.core.PersistentHashMap.fromArrays(inst_35510,inst_35512);
var inst_35514 = [inst_35513,offset_map];
var inst_35515 = (new cljs.core.PersistentVector(null,2,(5),inst_35509,inst_35514,null));
var state_35577__$1 = state_35577;
var statearr_35716_35840 = state_35577__$1;
(statearr_35716_35840[(2)] = inst_35515);

(statearr_35716_35840[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (37))){
var inst_35382 = cljs.core.not(recur_QMARK_);
var state_35577__$1 = state_35577;
if(inst_35382){
var statearr_35717_35841 = state_35577__$1;
(statearr_35717_35841[(1)] = (39));

} else {
var statearr_35718_35842 = state_35577__$1;
(statearr_35718_35842[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (63))){
var inst_35324 = (state_35577[(7)]);
var inst_35459 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35324);
var state_35577__$1 = state_35577;
var statearr_35719_35843 = state_35577__$1;
(statearr_35719_35843[(2)] = inst_35459);

(statearr_35719_35843[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (94))){
var inst_35570 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35720_35844 = state_35577__$1;
(statearr_35720_35844[(2)] = inst_35570);

(statearr_35720_35844[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (8))){
var inst_35311 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
if(cljs.core.truth_(inst_35311)){
var statearr_35721_35845 = state_35577__$1;
(statearr_35721_35845[(1)] = (9));

} else {
var statearr_35722_35846 = state_35577__$1;
(statearr_35722_35846[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (49))){
var inst_35406 = (state_35577[(2)]);
var inst_35407 = fluree.db.util.async.throw_err(inst_35406);
var state_35577__$1 = (function (){var statearr_35723 = state_35577;
(statearr_35723[(29)] = inst_35407);

return statearr_35723;
})();
if(cljs.core.truth_(fuel)){
var statearr_35724_35847 = state_35577__$1;
(statearr_35724_35847[(1)] = (50));

} else {
var statearr_35725_35848 = state_35577__$1;
(statearr_35725_35848[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (84))){
var state_35577__$1 = state_35577;
var statearr_35726_35849 = state_35577__$1;
(statearr_35726_35849[(2)] = null);

(statearr_35726_35849[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_35727 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35727[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_35727[(1)] = (1));

return statearr_35727;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_35577){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35577);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35728){var ex__13886__auto__ = e35728;
var statearr_35729_35850 = state_35577;
(statearr_35729_35850[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35577[(4)]))){
var statearr_35730_35851 = state_35577;
(statearr_35730_35851[(1)] = cljs.core.first((state_35577[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35852 = state_35577;
state_35577 = G__35852;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_35577){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_35577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35731 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35731[(6)] = c__13957__auto__);

return statearr_35731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36012){
var state_val_36013 = (state_36012[(1)]);
if((state_val_36013 === (7))){
var inst_36007 = (state_36012[(2)]);
var _ = (function (){var statearr_36014 = state_36012;
(statearr_36014[(4)] = cljs.core.rest((state_36012[(4)])));

return statearr_36014;
})();
var state_36012__$1 = state_36012;
var statearr_36015_36097 = state_36012__$1;
(statearr_36015_36097[(2)] = inst_36007);

(statearr_36015_36097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (20))){
var inst_35934 = (state_36012[(7)]);
var state_36012__$1 = state_36012;
var statearr_36016_36098 = state_36012__$1;
(statearr_36016_36098[(2)] = inst_35934);

(statearr_36016_36098[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (27))){
var inst_35889 = (state_36012[(8)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35889)){
var statearr_36017_36099 = state_36012__$1;
(statearr_36017_36099[(1)] = (29));

} else {
var statearr_36018_36100 = state_36012__$1;
(statearr_36018_36100[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (1))){
var state_36012__$1 = state_36012;
var statearr_36019_36101 = state_36012__$1;
(statearr_36019_36101[(2)] = null);

(statearr_36019_36101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (24))){
var inst_35890 = (state_36012[(9)]);
var state_36012__$1 = state_36012;
var statearr_36020_36102 = state_36012__$1;
(statearr_36020_36102[(2)] = inst_35890);

(statearr_36020_36102[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (39))){
var inst_35926 = (state_36012[(10)]);
var state_36012__$1 = state_36012;
var statearr_36021_36103 = state_36012__$1;
(statearr_36021_36103[(2)] = inst_35926);

(statearr_36021_36103[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (46))){
var inst_35891 = (state_36012[(11)]);
var state_36012__$1 = state_36012;
var statearr_36022_36104 = state_36012__$1;
(statearr_36022_36104[(2)] = inst_35891);

(statearr_36022_36104[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (4))){
var inst_35853 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36023_36105 = state_36012__$1;
(statearr_36023_36105[(2)] = inst_35853);

(statearr_36023_36105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (15))){
var inst_35902 = (state_36012[(12)]);
var inst_35908 = cljs.core.count(inst_35902);
var inst_35909 = fluree.db.query.fql.add_fuel(fuel,inst_35908,max_fuel);
var state_36012__$1 = state_36012;
var statearr_36024_36106 = state_36012__$1;
(statearr_36024_36106[(2)] = inst_35909);

(statearr_36024_36106[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (48))){
var inst_35993 = (state_36012[(13)]);
var inst_35871 = (state_36012[(14)]);
var inst_35878 = (state_36012[(15)]);
var inst_36001 = (state_36012[(2)]);
var inst_36002 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35871,inst_36001,inst_35993);
var inst_35870 = inst_35878;
var inst_35871__$1 = inst_36002;
var state_36012__$1 = (function (){var statearr_36025 = state_36012;
(statearr_36025[(16)] = inst_35870);

(statearr_36025[(14)] = inst_35871__$1);

return statearr_36025;
})();
var statearr_36026_36107 = state_36012__$1;
(statearr_36026_36107[(2)] = null);

(statearr_36026_36107[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (50))){
var inst_35893 = (state_36012[(17)]);
var state_36012__$1 = state_36012;
var statearr_36027_36108 = state_36012__$1;
(statearr_36027_36108[(2)] = inst_35893);

(statearr_36027_36108[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (21))){
var inst_35890 = (state_36012[(9)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35890)){
var statearr_36029_36109 = state_36012__$1;
(statearr_36029_36109[(1)] = (23));

} else {
var statearr_36030_36110 = state_36012__$1;
(statearr_36030_36110[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (31))){
var inst_35950 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35950)){
var statearr_36031_36111 = state_36012__$1;
(statearr_36031_36111[(1)] = (32));

} else {
var statearr_36032_36112 = state_36012__$1;
(statearr_36032_36112[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (32))){
var inst_35933 = (state_36012[(18)]);
var inst_35926 = (state_36012[(10)]);
var inst_35925 = (state_36012[(19)]);
var inst_35952 = (inst_35925 + (1));
var tmp36028 = inst_35926;
var inst_35924 = inst_35933;
var inst_35925__$1 = inst_35952;
var inst_35926__$1 = tmp36028;
var state_36012__$1 = (function (){var statearr_36033 = state_36012;
(statearr_36033[(10)] = inst_35926__$1);

(statearr_36033[(19)] = inst_35925__$1);

(statearr_36033[(20)] = inst_35924);

return statearr_36033;
})();
var statearr_36034_36113 = state_36012__$1;
(statearr_36034_36113[(2)] = null);

(statearr_36034_36113[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (40))){
var state_36012__$1 = state_36012;
if(cljs.core.truth_(fuel)){
var statearr_36035_36114 = state_36012__$1;
(statearr_36035_36114[(1)] = (42));

} else {
var statearr_36036_36115 = state_36012__$1;
(statearr_36036_36115[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (33))){
var state_36012__$1 = state_36012;
var statearr_36037_36116 = state_36012__$1;
(statearr_36037_36116[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (13))){
var inst_35902 = (state_36012[(12)]);
var state_36012__$1 = state_36012;
var statearr_36039_36117 = state_36012__$1;
(statearr_36039_36117[(2)] = inst_35902);

(statearr_36039_36117[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (22))){
var inst_35943 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35943)){
var statearr_36040_36118 = state_36012__$1;
(statearr_36040_36118[(1)] = (26));

} else {
var statearr_36041_36119 = state_36012__$1;
(statearr_36041_36119[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (36))){
var state_36012__$1 = state_36012;
var statearr_36042_36120 = state_36012__$1;
(statearr_36042_36120[(2)] = null);

(statearr_36042_36120[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (41))){
var inst_35933 = (state_36012[(18)]);
var inst_35925 = (state_36012[(19)]);
var inst_35982 = (state_36012[(2)]);
var inst_35983 = (inst_35925 + (1));
var inst_35924 = inst_35933;
var inst_35925__$1 = inst_35983;
var inst_35926 = inst_35982;
var state_36012__$1 = (function (){var statearr_36043 = state_36012;
(statearr_36043[(10)] = inst_35926);

(statearr_36043[(19)] = inst_35925__$1);

(statearr_36043[(20)] = inst_35924);

return statearr_36043;
})();
var statearr_36044_36121 = state_36012__$1;
(statearr_36044_36121[(2)] = null);

(statearr_36044_36121[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (43))){
var state_36012__$1 = state_36012;
var statearr_36045_36122 = state_36012__$1;
(statearr_36045_36122[(2)] = null);

(statearr_36045_36122[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (29))){
var inst_35889 = (state_36012[(8)]);
var inst_35925 = (state_36012[(19)]);
var inst_35947 = (inst_35925 < inst_35889);
var state_36012__$1 = state_36012;
var statearr_36046_36123 = state_36012__$1;
(statearr_36046_36123[(2)] = inst_35947);

(statearr_36046_36123[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (44))){
var inst_35966 = (state_36012[(21)]);
var inst_35962 = (state_36012[(22)]);
var inst_35975 = (state_36012[(2)]);
var inst_35976 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_35966,inst_35962) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_35966,inst_35962));
var state_36012__$1 = (function (){var statearr_36047 = state_36012;
(statearr_36047[(23)] = inst_35975);

return statearr_36047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36012__$1,(45),inst_35976);
} else {
if((state_val_36013 === (6))){
var inst_35877 = (state_36012[(24)]);
var inst_35870 = (state_36012[(16)]);
var inst_35876 = cljs.core.seq(inst_35870);
var inst_35877__$1 = cljs.core.first(inst_35876);
var inst_35878 = cljs.core.next(inst_35876);
var inst_35879 = cljs.core.not(inst_35877__$1);
var state_36012__$1 = (function (){var statearr_36048 = state_36012;
(statearr_36048[(24)] = inst_35877__$1);

(statearr_36048[(15)] = inst_35878);

return statearr_36048;
})();
if(inst_35879){
var statearr_36049_36124 = state_36012__$1;
(statearr_36049_36124[(1)] = (8));

} else {
var statearr_36050_36125 = state_36012__$1;
(statearr_36050_36125[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (28))){
var inst_35991 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36051_36126 = state_36012__$1;
(statearr_36051_36126[(2)] = inst_35991);

(statearr_36051_36126[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (51))){
var inst_35999 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36052_36127 = state_36012__$1;
(statearr_36052_36127[(2)] = inst_35999);

(statearr_36052_36127[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (25))){
var inst_35941 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36053_36128 = state_36012__$1;
(statearr_36053_36128[(2)] = inst_35941);

(statearr_36053_36128[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (34))){
var inst_35989 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36054_36129 = state_36012__$1;
(statearr_36054_36129[(2)] = inst_35989);

(statearr_36054_36129[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (17))){
var inst_35902 = (state_36012[(12)]);
var inst_35912 = (state_36012[(2)]);
var inst_35920 = cljs.core.seq(inst_35902);
var inst_35921 = cljs.core.first(inst_35920);
var inst_35922 = cljs.core.next(inst_35920);
var inst_35923 = cljs.core.PersistentVector.EMPTY;
var inst_35924 = inst_35902;
var inst_35925 = (0);
var inst_35926 = inst_35923;
var state_36012__$1 = (function (){var statearr_36055 = state_36012;
(statearr_36055[(25)] = inst_35921);

(statearr_36055[(10)] = inst_35926);

(statearr_36055[(26)] = inst_35912);

(statearr_36055[(27)] = inst_35922);

(statearr_36055[(19)] = inst_35925);

(statearr_36055[(20)] = inst_35924);

return statearr_36055;
})();
var statearr_36056_36130 = state_36012__$1;
(statearr_36056_36130[(2)] = null);

(statearr_36056_36130[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (3))){
var inst_36010 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36012__$1,inst_36010);
} else {
if((state_val_36013 === (12))){
var state_36012__$1 = state_36012;
var statearr_36057_36131 = state_36012__$1;
(statearr_36057_36131[(2)] = fuel);

(statearr_36057_36131[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (2))){
var _ = (function (){var statearr_36058 = state_36012;
(statearr_36058[(4)] = cljs.core.cons((5),(state_36012[(4)])));

return statearr_36058;
})();
var inst_35866 = reverse_refs_specs;
var inst_35867 = cljs.core.seq(inst_35866);
var inst_35868 = cljs.core.first(inst_35867);
var inst_35869 = cljs.core.next(inst_35867);
var inst_35870 = inst_35866;
var inst_35871 = null;
var state_36012__$1 = (function (){var statearr_36059 = state_36012;
(statearr_36059[(28)] = inst_35869);

(statearr_36059[(29)] = inst_35868);

(statearr_36059[(16)] = inst_35870);

(statearr_36059[(14)] = inst_35871);

return statearr_36059;
})();
var statearr_36060_36132 = state_36012__$1;
(statearr_36060_36132[(2)] = null);

(statearr_36060_36132[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (23))){
var inst_35890 = (state_36012[(9)]);
var inst_35925 = (state_36012[(19)]);
var inst_35938 = (inst_35925 >= inst_35890);
var state_36012__$1 = state_36012;
var statearr_36061_36133 = state_36012__$1;
(statearr_36061_36133[(2)] = inst_35938);

(statearr_36061_36133[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (47))){
var inst_35892 = (state_36012[(30)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35892)){
var statearr_36062_36134 = state_36012__$1;
(statearr_36062_36134[(1)] = (49));

} else {
var statearr_36063_36135 = state_36012__$1;
(statearr_36063_36135[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (35))){
var inst_35932 = (state_36012[(31)]);
var inst_35956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35957 = [inst_35932];
var inst_35958 = (new cljs.core.PersistentVector(null,1,(5),inst_35956,inst_35957,null));
var inst_35959 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35958);
var state_36012__$1 = state_36012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36012__$1,(38),inst_35959);
} else {
if((state_val_36013 === (19))){
var inst_35891 = (state_36012[(11)]);
var inst_35993 = (state_36012[(2)]);
var state_36012__$1 = (function (){var statearr_36064 = state_36012;
(statearr_36064[(13)] = inst_35993);

return statearr_36064;
})();
if(cljs.core.truth_(inst_35891)){
var statearr_36065_36136 = state_36012__$1;
(statearr_36065_36136[(1)] = (46));

} else {
var statearr_36066_36137 = state_36012__$1;
(statearr_36066_36137[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (11))){
var inst_35902 = (state_36012[(12)]);
var inst_35899 = (state_36012[(2)]);
var inst_35900 = fluree.db.util.async.throw_err(inst_35899);
var inst_35901 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_35900);
var inst_35902__$1 = cljs.core.not_empty(inst_35901);
var state_36012__$1 = (function (){var statearr_36068 = state_36012;
(statearr_36068[(12)] = inst_35902__$1);

return statearr_36068;
})();
if(cljs.core.truth_(inst_35902__$1)){
var statearr_36069_36138 = state_36012__$1;
(statearr_36069_36138[(1)] = (12));

} else {
var statearr_36070_36139 = state_36012__$1;
(statearr_36070_36139[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (9))){
var inst_35887 = (state_36012[(32)]);
var inst_35877 = (state_36012[(24)]);
var inst_35886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35877,(0),null);
var inst_35887__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35877,(1),null);
var inst_35888 = cljs.core.__destructure_map(inst_35887__$1);
var inst_35889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35888,cljs.core.cst$kw$offset);
var inst_35890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35888,cljs.core.cst$kw$limit);
var inst_35891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35888,cljs.core.cst$kw$as);
var inst_35892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35888,cljs.core.cst$kw$name);
var inst_35893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35888,cljs.core.cst$kw$p);
var inst_35894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35895 = [subject_id,inst_35886];
var inst_35896 = (new cljs.core.PersistentVector(null,2,(5),inst_35894,inst_35895,null));
var inst_35897 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_35896);
var state_36012__$1 = (function (){var statearr_36071 = state_36012;
(statearr_36071[(30)] = inst_35892);

(statearr_36071[(8)] = inst_35889);

(statearr_36071[(11)] = inst_35891);

(statearr_36071[(32)] = inst_35887__$1);

(statearr_36071[(9)] = inst_35890);

(statearr_36071[(17)] = inst_35893);

return statearr_36071;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36012__$1,(11),inst_35897);
} else {
if((state_val_36013 === (5))){
var _ = (function (){var statearr_36072 = state_36012;
(statearr_36072[(4)] = cljs.core.rest((state_36012[(4)])));

return statearr_36072;
})();
var state_36012__$1 = state_36012;
var ex36067 = (state_36012__$1[(2)]);
var statearr_36073_36140 = state_36012__$1;
(statearr_36073_36140[(5)] = ex36067);


if((ex36067 instanceof Error)){
var statearr_36074_36141 = state_36012__$1;
(statearr_36074_36141[(1)] = (4));

(statearr_36074_36141[(5)] = null);

} else {
throw ex36067;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (14))){
var inst_35906 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
if(cljs.core.truth_(inst_35906)){
var statearr_36075_36142 = state_36012__$1;
(statearr_36075_36142[(1)] = (15));

} else {
var statearr_36076_36143 = state_36012__$1;
(statearr_36076_36143[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (45))){
var inst_35926 = (state_36012[(10)]);
var inst_35978 = (state_36012[(2)]);
var inst_35979 = fluree.db.util.async.throw_err(inst_35978);
var inst_35980 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35926,inst_35979);
var state_36012__$1 = state_36012;
var statearr_36077_36144 = state_36012__$1;
(statearr_36077_36144[(2)] = inst_35980);

(statearr_36077_36144[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (26))){
var inst_35926 = (state_36012[(10)]);
var state_36012__$1 = state_36012;
var statearr_36078_36145 = state_36012__$1;
(statearr_36078_36145[(2)] = inst_35926);

(statearr_36078_36145[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (16))){
var state_36012__$1 = state_36012;
var statearr_36079_36146 = state_36012__$1;
(statearr_36079_36146[(2)] = null);

(statearr_36079_36146[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (38))){
var inst_35887 = (state_36012[(32)]);
var inst_35962 = (state_36012[(22)]);
var inst_35961 = (state_36012[(2)]);
var inst_35962__$1 = fluree.db.util.async.throw_err(inst_35961);
var inst_35963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35964 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_35965 = (new cljs.core.PersistentVector(null,4,(5),inst_35963,inst_35964,null));
var inst_35966 = cljs.core.select_keys(inst_35887,inst_35965);
var inst_35967 = cljs.core.empty_QMARK_(inst_35962__$1);
var state_36012__$1 = (function (){var statearr_36080 = state_36012;
(statearr_36080[(21)] = inst_35966);

(statearr_36080[(22)] = inst_35962__$1);

return statearr_36080;
})();
if(inst_35967){
var statearr_36081_36147 = state_36012__$1;
(statearr_36081_36147[(1)] = (39));

} else {
var statearr_36082_36148 = state_36012__$1;
(statearr_36082_36148[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (30))){
var inst_35889 = (state_36012[(8)]);
var state_36012__$1 = state_36012;
var statearr_36083_36149 = state_36012__$1;
(statearr_36083_36149[(2)] = inst_35889);

(statearr_36083_36149[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (10))){
var inst_36005 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36084_36150 = state_36012__$1;
(statearr_36084_36150[(2)] = inst_36005);

(statearr_36084_36150[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (18))){
var inst_35934 = (state_36012[(7)]);
var inst_35932 = (state_36012[(31)]);
var inst_35924 = (state_36012[(20)]);
var inst_35931 = cljs.core.seq(inst_35924);
var inst_35932__$1 = cljs.core.first(inst_35931);
var inst_35933 = cljs.core.next(inst_35931);
var inst_35934__$1 = cljs.core.not(inst_35932__$1);
var state_36012__$1 = (function (){var statearr_36085 = state_36012;
(statearr_36085[(18)] = inst_35933);

(statearr_36085[(7)] = inst_35934__$1);

(statearr_36085[(31)] = inst_35932__$1);

return statearr_36085;
})();
if(inst_35934__$1){
var statearr_36086_36151 = state_36012__$1;
(statearr_36086_36151[(1)] = (20));

} else {
var statearr_36087_36152 = state_36012__$1;
(statearr_36087_36152[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (42))){
var inst_35962 = (state_36012[(22)]);
var inst_35971 = cljs.core.count(inst_35962);
var inst_35972 = fluree.db.query.fql.add_fuel(fuel,inst_35971,max_fuel);
var state_36012__$1 = state_36012;
var statearr_36088_36153 = state_36012__$1;
(statearr_36088_36153[(2)] = inst_35972);

(statearr_36088_36153[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (37))){
var inst_35987 = (state_36012[(2)]);
var state_36012__$1 = state_36012;
var statearr_36089_36154 = state_36012__$1;
(statearr_36089_36154[(2)] = inst_35987);

(statearr_36089_36154[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (8))){
var inst_35871 = (state_36012[(14)]);
var state_36012__$1 = state_36012;
var statearr_36090_36155 = state_36012__$1;
(statearr_36090_36155[(2)] = inst_35871);

(statearr_36090_36155[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36013 === (49))){
var inst_35892 = (state_36012[(30)]);
var state_36012__$1 = state_36012;
var statearr_36091_36156 = state_36012__$1;
(statearr_36091_36156[(2)] = inst_35892);

(statearr_36091_36156[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0 = (function (){
var statearr_36092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36092[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__);

(statearr_36092[(1)] = (1));

return statearr_36092;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1 = (function (state_36012){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36012);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36093){var ex__13886__auto__ = e36093;
var statearr_36094_36157 = state_36012;
(statearr_36094_36157[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36012[(4)]))){
var statearr_36095_36158 = state_36012;
(statearr_36095_36158[(1)] = cljs.core.first((state_36012[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36159 = state_36012;
state_36012 = G__36159;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__ = function(state_36012){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1.call(this,state_36012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36096 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36096[(6)] = c__13957__auto__);

return statearr_36096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__36160 = select_spec;
var map__36160__$1 = cljs.core.__destructure_map(map__36160);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36160__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36160__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36222){
var state_val_36223 = (state_36222[(1)]);
if((state_val_36223 === (7))){
var inst_36186 = (state_36222[(7)]);
var inst_36188 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_36189 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36188,inst_36186);
var state_36222__$1 = state_36222;
var statearr_36224_36263 = state_36222__$1;
(statearr_36224_36263[(2)] = inst_36189);

(statearr_36224_36263[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (20))){
var inst_36192 = (state_36222[(8)]);
var inst_36210 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_36211 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_36210,inst_36192) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_36210,inst_36192));
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36222__$1,(22),inst_36211);
} else {
if((state_val_36223 === (1))){
var state_36222__$1 = state_36222;
var statearr_36225_36264 = state_36222__$1;
(statearr_36225_36264[(2)] = null);

(statearr_36225_36264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (4))){
var inst_36161 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36226_36265 = state_36222__$1;
(statearr_36226_36265[(2)] = inst_36161);

(statearr_36226_36265[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (15))){
var inst_36199 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36227_36266 = state_36222__$1;
(statearr_36227_36266[(2)] = inst_36199);

(statearr_36227_36266[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (21))){
var inst_36217 = (state_36222[(2)]);
var _ = (function (){var statearr_36228 = state_36222;
(statearr_36228[(4)] = cljs.core.rest((state_36222[(4)])));

return statearr_36228;
})();
var state_36222__$1 = state_36222;
var statearr_36229_36267 = state_36222__$1;
(statearr_36229_36267[(2)] = inst_36217);

(statearr_36229_36267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (13))){
var inst_36178 = (state_36222[(9)]);
var state_36222__$1 = state_36222;
var statearr_36230_36268 = state_36222__$1;
(statearr_36230_36268[(2)] = inst_36178);

(statearr_36230_36268[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (22))){
var inst_36207 = (state_36222[(10)]);
var inst_36172 = (state_36222[(11)]);
var inst_36213 = (state_36222[(2)]);
var inst_36214 = fluree.db.util.async.throw_err(inst_36213);
var inst_36215 = (inst_36207.cljs$core$IFn$_invoke$arity$3 ? inst_36207.cljs$core$IFn$_invoke$arity$3(acc,inst_36172,inst_36214) : inst_36207.call(null,acc,inst_36172,inst_36214));
var state_36222__$1 = state_36222;
var statearr_36231_36269 = state_36222__$1;
(statearr_36231_36269[(2)] = inst_36215);

(statearr_36231_36269[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (6))){
var inst_36185 = (state_36222[(2)]);
var inst_36186 = fluree.db.util.async.throw_err(inst_36185);
var state_36222__$1 = (function (){var statearr_36232 = state_36222;
(statearr_36232[(7)] = inst_36186);

return statearr_36232;
})();
if(cljs.core.truth_(fuel)){
var statearr_36233_36270 = state_36222__$1;
(statearr_36233_36270[(1)] = (7));

} else {
var statearr_36234_36271 = state_36222__$1;
(statearr_36234_36271[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (17))){
var inst_36176 = (state_36222[(12)]);
var inst_36173 = (state_36222[(13)]);
var inst_36175 = (state_36222[(14)]);
var inst_36174 = (state_36222[(15)]);
var inst_36177 = (state_36222[(16)]);
var inst_36172 = (state_36222[(11)]);
var inst_36168 = (state_36222[(17)]);
var inst_36171 = (state_36222[(18)]);
var inst_36178 = (state_36222[(9)]);
var inst_36201 = (state_36222[(19)]);
var inst_36192 = (state_36222[(8)]);
var inst_36170 = (state_36222[(20)]);
var inst_36205 = (function (){var recur_seen = inst_36174;
var recur_subject = inst_36168;
var map__36167 = inst_36170;
var sub_flakes = inst_36192;
var seen_QMARK_ = inst_36177;
var multi_QMARK_ = inst_36171;
var limit = inst_36176;
var recur_depth = inst_36175;
var as = inst_36172;
var max_depth_QMARK_ = inst_36178;
var recur = inst_36173;
var stop_QMARK_ = inst_36201;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_36222__$1 = state_36222;
var statearr_36235_36272 = state_36222__$1;
(statearr_36235_36272[(2)] = inst_36205);

(statearr_36235_36272[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (3))){
var inst_36220 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36222__$1,inst_36220);
} else {
if((state_val_36223 === (12))){
var inst_36171 = (state_36222[(18)]);
var inst_36201 = (state_36222[(2)]);
var state_36222__$1 = (function (){var statearr_36236 = state_36222;
(statearr_36236[(19)] = inst_36201);

return statearr_36236;
})();
if(cljs.core.truth_(inst_36171)){
var statearr_36237_36273 = state_36222__$1;
(statearr_36237_36273[(1)] = (16));

} else {
var statearr_36238_36274 = state_36222__$1;
(statearr_36238_36274[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (2))){
var inst_36173 = (state_36222[(13)]);
var inst_36175 = (state_36222[(14)]);
var inst_36174 = (state_36222[(15)]);
var inst_36168 = (state_36222[(17)]);
var inst_36170 = (state_36222[(20)]);
var _ = (function (){var statearr_36239 = state_36222;
(statearr_36239[(4)] = cljs.core.cons((5),(state_36222[(4)])));

return statearr_36239;
})();
var inst_36168__$1 = flake.o;
var inst_36169 = select_spec;
var inst_36170__$1 = cljs.core.__destructure_map(inst_36169);
var inst_36171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_36172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$as);
var inst_36173__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$recur);
var inst_36174__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_36175__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_36176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36170__$1,cljs.core.cst$kw$limit);
var inst_36177 = cljs.core.contains_QMARK_(inst_36174__$1,inst_36168__$1);
var inst_36178 = (inst_36175__$1 > inst_36173__$1);
var inst_36180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36181 = [inst_36168__$1];
var inst_36182 = (new cljs.core.PersistentVector(null,1,(5),inst_36180,inst_36181,null));
var inst_36183 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36182);
var state_36222__$1 = (function (){var statearr_36240 = state_36222;
(statearr_36240[(12)] = inst_36176);

(statearr_36240[(13)] = inst_36173__$1);

(statearr_36240[(14)] = inst_36175__$1);

(statearr_36240[(15)] = inst_36174__$1);

(statearr_36240[(16)] = inst_36177);

(statearr_36240[(11)] = inst_36172);

(statearr_36240[(17)] = inst_36168__$1);

(statearr_36240[(18)] = inst_36171);

(statearr_36240[(9)] = inst_36178);

(statearr_36240[(20)] = inst_36170__$1);

return statearr_36240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36222__$1,(6),inst_36183);
} else {
if((state_val_36223 === (19))){
var state_36222__$1 = state_36222;
var statearr_36241_36275 = state_36222__$1;
(statearr_36241_36275[(2)] = acc);

(statearr_36241_36275[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (11))){
var inst_36178 = (state_36222[(9)]);
var state_36222__$1 = state_36222;
if(cljs.core.truth_(inst_36178)){
var statearr_36243_36276 = state_36222__$1;
(statearr_36243_36276[(1)] = (13));

} else {
var statearr_36244_36277 = state_36222__$1;
(statearr_36244_36277[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (9))){
var inst_36177 = (state_36222[(16)]);
var inst_36192 = (state_36222[(2)]);
var state_36222__$1 = (function (){var statearr_36245 = state_36222;
(statearr_36245[(8)] = inst_36192);

return statearr_36245;
})();
if(cljs.core.truth_(inst_36177)){
var statearr_36246_36278 = state_36222__$1;
(statearr_36246_36278[(1)] = (10));

} else {
var statearr_36247_36279 = state_36222__$1;
(statearr_36247_36279[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (5))){
var _ = (function (){var statearr_36248 = state_36222;
(statearr_36248[(4)] = cljs.core.rest((state_36222[(4)])));

return statearr_36248;
})();
var state_36222__$1 = state_36222;
var ex36242 = (state_36222__$1[(2)]);
var statearr_36249_36280 = state_36222__$1;
(statearr_36249_36280[(5)] = ex36242);


if((ex36242 instanceof Error)){
var statearr_36250_36281 = state_36222__$1;
(statearr_36250_36281[(1)] = (4));

(statearr_36250_36281[(5)] = null);

} else {
throw ex36242;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (14))){
var inst_36192 = (state_36222[(8)]);
var inst_36197 = cljs.core.empty_QMARK_(inst_36192);
var state_36222__$1 = state_36222;
var statearr_36251_36282 = state_36222__$1;
(statearr_36251_36282[(2)] = inst_36197);

(statearr_36251_36282[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (16))){
var inst_36176 = (state_36222[(12)]);
var inst_36173 = (state_36222[(13)]);
var inst_36175 = (state_36222[(14)]);
var inst_36174 = (state_36222[(15)]);
var inst_36177 = (state_36222[(16)]);
var inst_36172 = (state_36222[(11)]);
var inst_36168 = (state_36222[(17)]);
var inst_36171 = (state_36222[(18)]);
var inst_36178 = (state_36222[(9)]);
var inst_36201 = (state_36222[(19)]);
var inst_36192 = (state_36222[(8)]);
var inst_36170 = (state_36222[(20)]);
var inst_36203 = (function (){var recur_seen = inst_36174;
var recur_subject = inst_36168;
var map__36167 = inst_36170;
var sub_flakes = inst_36192;
var seen_QMARK_ = inst_36177;
var multi_QMARK_ = inst_36171;
var limit = inst_36176;
var recur_depth = inst_36175;
var as = inst_36172;
var max_depth_QMARK_ = inst_36178;
var recur = inst_36173;
var stop_QMARK_ = inst_36201;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_36222__$1 = state_36222;
var statearr_36252_36283 = state_36222__$1;
(statearr_36252_36283[(2)] = inst_36203);

(statearr_36252_36283[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (10))){
var inst_36177 = (state_36222[(16)]);
var state_36222__$1 = state_36222;
var statearr_36253_36284 = state_36222__$1;
(statearr_36253_36284[(2)] = inst_36177);

(statearr_36253_36284[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (18))){
var inst_36201 = (state_36222[(19)]);
var inst_36207 = (state_36222[(2)]);
var state_36222__$1 = (function (){var statearr_36254 = state_36222;
(statearr_36254[(10)] = inst_36207);

return statearr_36254;
})();
if(cljs.core.truth_(inst_36201)){
var statearr_36255_36285 = state_36222__$1;
(statearr_36255_36285[(1)] = (19));

} else {
var statearr_36256_36286 = state_36222__$1;
(statearr_36256_36286[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (8))){
var inst_36186 = (state_36222[(7)]);
var state_36222__$1 = state_36222;
var statearr_36257_36287 = state_36222__$1;
(statearr_36257_36287[(2)] = inst_36186);

(statearr_36257_36287[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0 = (function (){
var statearr_36258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36258[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__);

(statearr_36258[(1)] = (1));

return statearr_36258;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1 = (function (state_36222){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36222);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36259){var ex__13886__auto__ = e36259;
var statearr_36260_36288 = state_36222;
(statearr_36260_36288[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36222[(4)]))){
var statearr_36261_36289 = state_36222;
(statearr_36261_36289[(1)] = cljs.core.first((state_36222[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36290 = state_36222;
state_36222 = G__36290;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__ = function(state_36222){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1.call(this,state_36222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36262 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36262[(6)] = c__13957__auto__);

return statearr_36262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36468){
var state_val_36469 = (state_36468[(1)]);
if((state_val_36469 === (7))){
var state_36468__$1 = state_36468;
var statearr_36470_36555 = state_36468__$1;
(statearr_36470_36555[(2)] = null);

(statearr_36470_36555[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (20))){
var inst_36329 = cljs.core.PersistentHashMap.EMPTY;
var state_36468__$1 = state_36468;
var statearr_36471_36556 = state_36468__$1;
(statearr_36471_36556[(2)] = inst_36329);

(statearr_36471_36556[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (27))){
var inst_36347 = (state_36468[(7)]);
var inst_36331 = (state_36468[(8)]);
var inst_36317 = (state_36468[(9)]);
var inst_36311 = (state_36468[(10)]);
var inst_36447 = (state_36468[(2)]);
var inst_36448 = (function (){var top_level_subject = inst_36311;
var select_spec = inst_36317;
var base_acc = inst_36331;
var acc_PLUS_refs = inst_36347;
var result = inst_36447;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4160__auto__ = (function (){var and__4149__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var and__4149__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4149__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_36449 = cljs.core.PersistentVector.EMPTY;
var inst_36450 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_36317);
var inst_36451 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_36450);
var inst_36452 = cljs.core.vals(inst_36451);
var inst_36453 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_36317);
var inst_36454 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_36453);
var inst_36455 = cljs.core.vals(inst_36454);
var inst_36456 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36452,inst_36455);
var inst_36457 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36448,inst_36449,inst_36456);
var inst_36459 = (function (){var top_level_subject = inst_36311;
var select_spec = inst_36317;
var base_acc = inst_36331;
var acc_PLUS_refs = inst_36347;
var result = inst_36447;
var sort_preds = inst_36457;
return (function (acc,p__36458){
var vec__36472 = p__36458;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36472,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36472,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36472,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36472,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_36460 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36459,inst_36447,inst_36457);
var state_36468__$1 = state_36468;
var statearr_36475_36557 = state_36468__$1;
(statearr_36475_36557[(2)] = inst_36460);

(statearr_36475_36557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (1))){
var state_36468__$1 = state_36468;
var statearr_36476_36558 = state_36468__$1;
(statearr_36476_36558[(2)] = null);

(statearr_36476_36558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (24))){
var inst_36347 = (state_36468[(7)]);
var inst_36347__$1 = (state_36468[(2)]);
var inst_36348 = flakes;
var inst_36349 = cljs.core.PersistentHashMap.EMPTY;
var inst_36350 = inst_36348;
var inst_36351 = inst_36347__$1;
var inst_36352 = inst_36349;
var state_36468__$1 = (function (){var statearr_36477 = state_36468;
(statearr_36477[(7)] = inst_36347__$1);

(statearr_36477[(11)] = inst_36352);

(statearr_36477[(12)] = inst_36350);

(statearr_36477[(13)] = inst_36351);

return statearr_36477;
})();
var statearr_36478_36559 = state_36468__$1;
(statearr_36478_36559[(2)] = null);

(statearr_36478_36559[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (39))){
var inst_36360 = (state_36468[(14)]);
var inst_36366 = (state_36468[(15)]);
var inst_36351 = (state_36468[(13)]);
var inst_36317 = (state_36468[(9)]);
var inst_36395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36396 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_36351,inst_36317,inst_36360,inst_36366,false);
var state_36468__$1 = (function (){var statearr_36479 = state_36468;
(statearr_36479[(16)] = inst_36395);

return statearr_36479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(42),inst_36396);
} else {
if((state_val_36469 === (46))){
var inst_36360 = (state_36468[(14)]);
var inst_36352 = (state_36468[(11)]);
var inst_36350 = (state_36468[(12)]);
var inst_36413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36414 = [cljs.core.cst$kw$_id];
var inst_36415 = inst_36360.s;
var inst_36416 = [inst_36415];
var inst_36417 = cljs.core.PersistentHashMap.fromArrays(inst_36414,inst_36416);
var inst_36418 = cljs.core.rest(inst_36350);
var inst_36419 = [inst_36417,inst_36418,inst_36352];
var inst_36420 = (new cljs.core.PersistentVector(null,3,(5),inst_36413,inst_36419,null));
var state_36468__$1 = state_36468;
var statearr_36480_36560 = state_36468__$1;
(statearr_36480_36560[(2)] = inst_36420);

(statearr_36480_36560[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (4))){
var inst_36291 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36481_36561 = state_36468__$1;
(statearr_36481_36561[(2)] = inst_36291);

(statearr_36481_36561[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (15))){
var inst_36318 = (state_36468[(17)]);
var inst_36317 = (state_36468[(9)]);
var inst_36317__$1 = (state_36468[(2)]);
var inst_36318__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36317__$1);
var state_36468__$1 = (function (){var statearr_36482 = state_36468;
(statearr_36482[(17)] = inst_36318__$1);

(statearr_36482[(9)] = inst_36317__$1);

return statearr_36482;
})();
if(cljs.core.truth_(inst_36318__$1)){
var statearr_36483_36562 = state_36468__$1;
(statearr_36483_36562[(1)] = (16));

} else {
var statearr_36484_36563 = state_36468__$1;
(statearr_36484_36563[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (48))){
var inst_36431 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36485_36564 = state_36468__$1;
(statearr_36485_36564[(2)] = inst_36431);

(statearr_36485_36564[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (50))){
var state_36468__$1 = state_36468;
var statearr_36486_36565 = state_36468__$1;
(statearr_36486_36565[(2)] = null);

(statearr_36486_36565[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (21))){
var inst_36317 = (state_36468[(9)]);
var inst_36331 = (state_36468[(2)]);
var inst_36332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36333 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_36334 = (new cljs.core.PersistentVector(null,2,(5),inst_36332,inst_36333,null));
var inst_36335 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_36317,inst_36334);
var state_36468__$1 = (function (){var statearr_36487 = state_36468;
(statearr_36487[(8)] = inst_36331);

return statearr_36487;
})();
if(cljs.core.truth_(inst_36335)){
var statearr_36488_36566 = state_36468__$1;
(statearr_36488_36566[(1)] = (22));

} else {
var statearr_36489_36567 = state_36468__$1;
(statearr_36489_36567[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (31))){
var inst_36360 = (state_36468[(14)]);
var inst_36351 = (state_36468[(13)]);
var inst_36365 = (state_36468[(18)]);
var inst_36369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36370 = fluree.db.query.fql.flake__GT_recur(db,inst_36360,inst_36365,inst_36351,fuel,max_fuel,cache);
var state_36468__$1 = (function (){var statearr_36490 = state_36468;
(statearr_36490[(19)] = inst_36369);

return statearr_36490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(34),inst_36370);
} else {
if((state_val_36469 === (32))){
var inst_36365 = (state_36468[(18)]);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36365)){
var statearr_36491_36568 = state_36468__$1;
(statearr_36491_36568[(1)] = (35));

} else {
var statearr_36492_36569 = state_36468__$1;
(statearr_36492_36569[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (40))){
var inst_36317 = (state_36468[(9)]);
var inst_36405 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_36317);
var inst_36406 = cljs.core.empty_QMARK_(inst_36405);
var state_36468__$1 = state_36468;
if(inst_36406){
var statearr_36493_36570 = state_36468__$1;
(statearr_36493_36570[(1)] = (43));

} else {
var statearr_36494_36571 = state_36468__$1;
(statearr_36494_36571[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (33))){
var inst_36360 = (state_36468[(14)]);
var inst_36437 = (state_36468[(2)]);
var inst_36438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36437,(0),null);
var inst_36439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36437,(1),null);
var inst_36440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36437,(2),null);
var inst_36441 = inst_36360.s;
var inst_36442 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36438,cljs.core.cst$kw$_id,inst_36441);
var inst_36350 = inst_36439;
var inst_36351 = inst_36442;
var inst_36352 = inst_36440;
var state_36468__$1 = (function (){var statearr_36495 = state_36468;
(statearr_36495[(11)] = inst_36352);

(statearr_36495[(12)] = inst_36350);

(statearr_36495[(13)] = inst_36351);

return statearr_36495;
})();
var statearr_36496_36572 = state_36468__$1;
(statearr_36496_36572[(2)] = null);

(statearr_36496_36572[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (13))){
var inst_36311 = (state_36468[(10)]);
var inst_36314 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_36311);
var state_36468__$1 = state_36468;
var statearr_36497_36573 = state_36468__$1;
(statearr_36497_36573[(2)] = inst_36314);

(statearr_36497_36573[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (22))){
var inst_36317 = (state_36468[(9)]);
var inst_36337 = cljs.core.first(flakes);
var inst_36338 = fluree.db.query.fql.s(inst_36337);
var inst_36339 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_36317);
var inst_36340 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_36338,inst_36339);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(25),inst_36340);
} else {
if((state_val_36469 === (36))){
var inst_36317 = (state_36468[(9)]);
var inst_36393 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36317);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36393)){
var statearr_36498_36574 = state_36468__$1;
(statearr_36498_36574[(1)] = (39));

} else {
var statearr_36499_36575 = state_36468__$1;
(statearr_36499_36575[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (41))){
var inst_36433 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36500_36576 = state_36468__$1;
(statearr_36500_36576[(2)] = inst_36433);

(statearr_36500_36576[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (43))){
var inst_36317 = (state_36468[(9)]);
var inst_36408 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36317);
var state_36468__$1 = state_36468;
var statearr_36501_36577 = state_36468__$1;
(statearr_36501_36577[(2)] = inst_36408);

(statearr_36501_36577[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (29))){
var inst_36360 = (state_36468[(14)]);
var inst_36350 = (state_36468[(12)]);
var inst_36365 = (state_36468[(18)]);
var inst_36317 = (state_36468[(9)]);
var inst_36360__$1 = cljs.core.first(inst_36350);
var inst_36361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36362 = inst_36360__$1.p;
var inst_36363 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_36362];
var inst_36364 = (new cljs.core.PersistentVector(null,3,(5),inst_36361,inst_36363,null));
var inst_36365__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_36317,inst_36364);
var inst_36366 = fluree.db.query.fql.component_follow_QMARK_(inst_36365__$1,inst_36317);
var inst_36367 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_36365__$1);
var state_36468__$1 = (function (){var statearr_36502 = state_36468;
(statearr_36502[(14)] = inst_36360__$1);

(statearr_36502[(15)] = inst_36366);

(statearr_36502[(18)] = inst_36365__$1);

return statearr_36502;
})();
if(cljs.core.truth_(inst_36367)){
var statearr_36503_36578 = state_36468__$1;
(statearr_36503_36578[(1)] = (31));

} else {
var statearr_36504_36579 = state_36468__$1;
(statearr_36504_36579[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (44))){
var state_36468__$1 = state_36468;
var statearr_36505_36580 = state_36468__$1;
(statearr_36505_36580[(2)] = false);

(statearr_36505_36580[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (6))){
var state_36468__$1 = state_36468;
var statearr_36506_36581 = state_36468__$1;
(statearr_36506_36581[(2)] = null);

(statearr_36506_36581[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (28))){
var inst_36351 = (state_36468[(13)]);
var state_36468__$1 = state_36468;
var statearr_36507_36582 = state_36468__$1;
(statearr_36507_36582[(2)] = inst_36351);

(statearr_36507_36582[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (51))){
var inst_36429 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36508_36583 = state_36468__$1;
(statearr_36508_36583[(2)] = inst_36429);

(statearr_36508_36583[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (25))){
var inst_36331 = (state_36468[(8)]);
var inst_36342 = (state_36468[(2)]);
var inst_36343 = fluree.db.util.async.throw_err(inst_36342);
var inst_36344 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36331,inst_36343], 0));
var state_36468__$1 = state_36468;
var statearr_36509_36584 = state_36468__$1;
(statearr_36509_36584[(2)] = inst_36344);

(statearr_36509_36584[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (34))){
var inst_36369 = (state_36468[(19)]);
var inst_36352 = (state_36468[(11)]);
var inst_36350 = (state_36468[(12)]);
var inst_36372 = (state_36468[(2)]);
var inst_36373 = fluree.db.util.async.throw_err(inst_36372);
var inst_36374 = cljs.core.rest(inst_36350);
var inst_36375 = [inst_36373,inst_36374,inst_36352];
var inst_36376 = (new cljs.core.PersistentVector(null,3,(5),inst_36369,inst_36375,null));
var state_36468__$1 = state_36468;
var statearr_36510_36585 = state_36468__$1;
(statearr_36510_36585[(2)] = inst_36376);

(statearr_36510_36585[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (17))){
var inst_36317 = (state_36468[(9)]);
var inst_36321 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36317);
var state_36468__$1 = state_36468;
var statearr_36512_36586 = state_36468__$1;
(statearr_36512_36586[(2)] = inst_36321);

(statearr_36512_36586[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (3))){
var inst_36466 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36468__$1,inst_36466);
} else {
if((state_val_36469 === (12))){
var _ = (function (){var statearr_36513 = state_36468;
(statearr_36513[(4)] = cljs.core.rest((state_36468[(4)])));

return statearr_36513;
})();
var state_36468__$1 = state_36468;
var ex36511 = (state_36468__$1[(2)]);
var statearr_36514_36587 = state_36468__$1;
(statearr_36514_36587[(5)] = ex36511);


var statearr_36515_36588 = state_36468__$1;
(statearr_36515_36588[(1)] = (11));

(statearr_36515_36588[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (2))){
var _ = (function (){var statearr_36516 = state_36468;
(statearr_36516[(4)] = cljs.core.cons((5),(state_36468[(4)])));

return statearr_36516;
})();
var inst_36297 = cljs.core.not_empty(flakes);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36297)){
var statearr_36517_36589 = state_36468__$1;
(statearr_36517_36589[(1)] = (6));

} else {
var statearr_36518_36590 = state_36468__$1;
(statearr_36518_36590[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (23))){
var inst_36331 = (state_36468[(8)]);
var state_36468__$1 = state_36468;
var statearr_36519_36591 = state_36468__$1;
(statearr_36519_36591[(2)] = inst_36331);

(statearr_36519_36591[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (47))){
var state_36468__$1 = state_36468;
var statearr_36520_36592 = state_36468__$1;
(statearr_36520_36592[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (35))){
var inst_36360 = (state_36468[(14)]);
var inst_36366 = (state_36468[(15)]);
var inst_36352 = (state_36468[(11)]);
var inst_36351 = (state_36468[(13)]);
var inst_36365 = (state_36468[(18)]);
var inst_36382 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_36351,inst_36365,inst_36360,inst_36366,false,inst_36352);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(38),inst_36382);
} else {
if((state_val_36469 === (19))){
var inst_36311 = (state_36468[(10)]);
var inst_36325 = [cljs.core.cst$kw$_id];
var inst_36326 = [inst_36311];
var inst_36327 = cljs.core.PersistentHashMap.fromArrays(inst_36325,inst_36326);
var state_36468__$1 = state_36468;
var statearr_36522_36593 = state_36468__$1;
(statearr_36522_36593[(2)] = inst_36327);

(statearr_36522_36593[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (11))){
var inst_36299 = (state_36468[(2)]);
var inst_36300 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36299], 0));
var inst_36301 = (function(){throw inst_36299})();
var state_36468__$1 = (function (){var statearr_36524 = state_36468;
(statearr_36524[(20)] = inst_36300);

return statearr_36524;
})();
var statearr_36525_36594 = state_36468__$1;
(statearr_36525_36594[(2)] = inst_36301);

(statearr_36525_36594[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (9))){
var _ = (function (){var statearr_36526 = state_36468;
(statearr_36526[(4)] = cljs.core.cons((12),(state_36468[(4)])));

return statearr_36526;
})();
var inst_36307 = cljs.core.first(flakes);
var inst_36308 = fluree.db.query.fql.s(inst_36307);
var ___$1 = (function (){var statearr_36527 = state_36468;
(statearr_36527[(4)] = cljs.core.rest((state_36468[(4)])));

return statearr_36527;
})();
var state_36468__$1 = state_36468;
var statearr_36528_36595 = state_36468__$1;
(statearr_36528_36595[(2)] = inst_36308);

(statearr_36528_36595[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (5))){
var _ = (function (){var statearr_36529 = state_36468;
(statearr_36529[(4)] = cljs.core.rest((state_36468[(4)])));

return statearr_36529;
})();
var state_36468__$1 = state_36468;
var ex36523 = (state_36468__$1[(2)]);
var statearr_36530_36596 = state_36468__$1;
(statearr_36530_36596[(5)] = ex36523);


if((ex36523 instanceof Error)){
var statearr_36531_36597 = state_36468__$1;
(statearr_36531_36597[(1)] = (4));

(statearr_36531_36597[(5)] = null);

} else {
throw ex36523;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (14))){
var state_36468__$1 = state_36468;
var statearr_36532_36598 = state_36468__$1;
(statearr_36532_36598[(2)] = base_select_spec);

(statearr_36532_36598[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (45))){
var inst_36411 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36411)){
var statearr_36533_36599 = state_36468__$1;
(statearr_36533_36599[(1)] = (46));

} else {
var statearr_36534_36600 = state_36468__$1;
(statearr_36534_36600[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (26))){
var inst_36350 = (state_36468[(12)]);
var inst_36354 = cljs.core.empty_QMARK_(inst_36350);
var state_36468__$1 = state_36468;
if(inst_36354){
var statearr_36535_36601 = state_36468__$1;
(statearr_36535_36601[(1)] = (28));

} else {
var statearr_36536_36602 = state_36468__$1;
(statearr_36536_36602[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (16))){
var inst_36318 = (state_36468[(17)]);
var state_36468__$1 = state_36468;
var statearr_36537_36603 = state_36468__$1;
(statearr_36537_36603[(2)] = inst_36318);

(statearr_36537_36603[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (38))){
var inst_36350 = (state_36468[(12)]);
var inst_36384 = (state_36468[(2)]);
var inst_36385 = fluree.db.util.async.throw_err(inst_36384);
var inst_36386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36385,(0),null);
var inst_36387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36385,(1),null);
var inst_36388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36389 = cljs.core.rest(inst_36350);
var inst_36390 = [inst_36386,inst_36389,inst_36387];
var inst_36391 = (new cljs.core.PersistentVector(null,3,(5),inst_36388,inst_36390,null));
var state_36468__$1 = state_36468;
var statearr_36538_36604 = state_36468__$1;
(statearr_36538_36604[(2)] = inst_36391);

(statearr_36538_36604[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (30))){
var inst_36445 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36539_36605 = state_36468__$1;
(statearr_36539_36605[(2)] = inst_36445);

(statearr_36539_36605[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (10))){
var inst_36311 = (state_36468[(2)]);
var inst_36312 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_36468__$1 = (function (){var statearr_36540 = state_36468;
(statearr_36540[(10)] = inst_36311);

return statearr_36540;
})();
if(cljs.core.truth_(inst_36312)){
var statearr_36541_36606 = state_36468__$1;
(statearr_36541_36606[(1)] = (13));

} else {
var statearr_36542_36607 = state_36468__$1;
(statearr_36542_36607[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (18))){
var inst_36323 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36323)){
var statearr_36543_36608 = state_36468__$1;
(statearr_36543_36608[(1)] = (19));

} else {
var statearr_36544_36609 = state_36468__$1;
(statearr_36544_36609[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (42))){
var inst_36352 = (state_36468[(11)]);
var inst_36395 = (state_36468[(16)]);
var inst_36350 = (state_36468[(12)]);
var inst_36398 = (state_36468[(2)]);
var inst_36399 = fluree.db.util.async.throw_err(inst_36398);
var inst_36400 = cljs.core.first(inst_36399);
var inst_36401 = cljs.core.rest(inst_36350);
var inst_36402 = [inst_36400,inst_36401,inst_36352];
var inst_36403 = (new cljs.core.PersistentVector(null,3,(5),inst_36395,inst_36402,null));
var state_36468__$1 = state_36468;
var statearr_36545_36610 = state_36468__$1;
(statearr_36545_36610[(2)] = inst_36403);

(statearr_36545_36610[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (37))){
var inst_36435 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36546_36611 = state_36468__$1;
(statearr_36546_36611[(2)] = inst_36435);

(statearr_36546_36611[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (8))){
var inst_36463 = (state_36468[(2)]);
var _ = (function (){var statearr_36547 = state_36468;
(statearr_36547[(4)] = cljs.core.rest((state_36468[(4)])));

return statearr_36547;
})();
var state_36468__$1 = state_36468;
var statearr_36548_36612 = state_36468__$1;
(statearr_36548_36612[(2)] = inst_36463);

(statearr_36548_36612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (49))){
var inst_36352 = (state_36468[(11)]);
var inst_36350 = (state_36468[(12)]);
var inst_36351 = (state_36468[(13)]);
var inst_36423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36424 = cljs.core.rest(inst_36350);
var inst_36425 = [inst_36351,inst_36424,inst_36352];
var inst_36426 = (new cljs.core.PersistentVector(null,3,(5),inst_36423,inst_36425,null));
var state_36468__$1 = state_36468;
var statearr_36549_36613 = state_36468__$1;
(statearr_36549_36613[(2)] = inst_36426);

(statearr_36549_36613[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0 = (function (){
var statearr_36550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36550[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__);

(statearr_36550[(1)] = (1));

return statearr_36550;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1 = (function (state_36468){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36468);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36551){var ex__13886__auto__ = e36551;
var statearr_36552_36614 = state_36468;
(statearr_36552_36614[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36468[(4)]))){
var statearr_36553_36615 = state_36468;
(statearr_36553_36615[(1)] = cljs.core.first((state_36468[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36616 = state_36468;
state_36468 = G__36616;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__ = function(state_36468){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1.call(this,state_36468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36554 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36554[(6)] = c__13957__auto__);

return statearr_36554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__36619 = arguments.length;
switch (G__36619) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36661){
var state_val_36662 = (state_36661[(1)]);
if((state_val_36662 === (7))){
var inst_36627 = (state_36661[(7)]);
var state_36661__$1 = state_36661;
var statearr_36663_36693 = state_36661__$1;
(statearr_36663_36693[(2)] = inst_36627);

(statearr_36663_36693[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (1))){
var state_36661__$1 = state_36661;
var statearr_36664_36694 = state_36661__$1;
(statearr_36664_36694[(2)] = null);

(statearr_36664_36694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (4))){
var inst_36620 = (state_36661[(2)]);
var state_36661__$1 = state_36661;
var statearr_36665_36695 = state_36661__$1;
(statearr_36665_36695[(2)] = inst_36620);

(statearr_36665_36695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (15))){
var inst_36655 = (state_36661[(2)]);
var inst_36656 = fluree.db.util.async.throw_err(inst_36655);
var _ = (function (){var statearr_36666 = state_36661;
(statearr_36666[(4)] = cljs.core.rest((state_36661[(4)])));

return statearr_36666;
})();
var state_36661__$1 = state_36661;
var statearr_36667_36696 = state_36661__$1;
(statearr_36667_36696[(2)] = inst_36656);

(statearr_36667_36696[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (13))){
var inst_36639 = (state_36661[(8)]);
var state_36661__$1 = state_36661;
var statearr_36668_36697 = state_36661__$1;
(statearr_36668_36697[(2)] = inst_36639);

(statearr_36668_36697[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (6))){
var inst_36627 = (state_36661[(7)]);
var inst_36629 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_36630 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36627,inst_36629);
var state_36661__$1 = state_36661;
var statearr_36669_36698 = state_36661__$1;
(statearr_36669_36698[(2)] = inst_36630);

(statearr_36669_36698[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (3))){
var inst_36659 = (state_36661[(2)]);
var state_36661__$1 = state_36661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36661__$1,inst_36659);
} else {
if((state_val_36662 === (12))){
var inst_36639 = (state_36661[(8)]);
var inst_36641 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_36642 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36639,inst_36641);
var state_36661__$1 = state_36661;
var statearr_36670_36699 = state_36661__$1;
(statearr_36670_36699[(2)] = inst_36642);

(statearr_36670_36699[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (2))){
var _ = (function (){var statearr_36671 = state_36661;
(statearr_36671[(4)] = cljs.core.cons((5),(state_36661[(4)])));

return statearr_36671;
})();
var inst_36627 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_36661__$1 = (function (){var statearr_36672 = state_36661;
(statearr_36672[(7)] = inst_36627);

return statearr_36672;
})();
if(cljs.core.truth_(fuel)){
var statearr_36673_36700 = state_36661__$1;
(statearr_36673_36700[(1)] = (6));

} else {
var statearr_36674_36701 = state_36661__$1;
(statearr_36674_36701[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (11))){
var inst_36639 = (state_36661[(2)]);
var state_36661__$1 = (function (){var statearr_36676 = state_36661;
(statearr_36676[(8)] = inst_36639);

return statearr_36676;
})();
if(cljs.core.truth_(limit)){
var statearr_36677_36702 = state_36661__$1;
(statearr_36677_36702[(1)] = (12));

} else {
var statearr_36678_36703 = state_36661__$1;
(statearr_36678_36703[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (9))){
var inst_36633 = (state_36661[(9)]);
var inst_36635 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_36636 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36633,inst_36635);
var state_36661__$1 = state_36661;
var statearr_36679_36704 = state_36661__$1;
(statearr_36679_36704[(2)] = inst_36636);

(statearr_36679_36704[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (5))){
var _ = (function (){var statearr_36680 = state_36661;
(statearr_36680[(4)] = cljs.core.rest((state_36661[(4)])));

return statearr_36680;
})();
var state_36661__$1 = state_36661;
var ex36675 = (state_36661__$1[(2)]);
var statearr_36681_36705 = state_36661__$1;
(statearr_36681_36705[(5)] = ex36675);


if((ex36675 instanceof Error)){
var statearr_36682_36706 = state_36661__$1;
(statearr_36682_36706[(1)] = (4));

(statearr_36682_36706[(5)] = null);

} else {
throw ex36675;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (14))){
var inst_36645 = (state_36661[(2)]);
var inst_36646 = (function (){return (function (x){
var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4149__auto__;
}
});
})();
var inst_36647 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_36646);
var inst_36648 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36645,inst_36647);
var inst_36649 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36648,flakes);
var inst_36650 = cljs.core.PersistentVector.EMPTY;
var inst_36651 = (function (){var xf = inst_36648;
var flakes_by_sub = inst_36649;
return (function (p1__36617_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__36617_SHARP_);
});
})();
var inst_36652 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36651,inst_36649);
var inst_36653 = fluree.db.util.async.merge_into_QMARK_(inst_36650,inst_36652);
var state_36661__$1 = state_36661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36661__$1,(15),inst_36653);
} else {
if((state_val_36662 === (10))){
var inst_36633 = (state_36661[(9)]);
var state_36661__$1 = state_36661;
var statearr_36683_36707 = state_36661__$1;
(statearr_36683_36707[(2)] = inst_36633);

(statearr_36683_36707[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36662 === (8))){
var inst_36633 = (state_36661[(2)]);
var state_36661__$1 = (function (){var statearr_36684 = state_36661;
(statearr_36684[(9)] = inst_36633);

return statearr_36684;
})();
if(cljs.core.truth_(offset)){
var statearr_36685_36708 = state_36661__$1;
(statearr_36685_36708[(1)] = (9));

} else {
var statearr_36686_36709 = state_36661__$1;
(statearr_36686_36709[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_36687 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36687[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_36687[(1)] = (1));

return statearr_36687;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_36661){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36661);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36688){var ex__13886__auto__ = e36688;
var statearr_36689_36710 = state_36661;
(statearr_36689_36710[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36661[(4)]))){
var statearr_36690_36711 = state_36661;
(statearr_36690_36711[(1)] = cljs.core.first((state_36661[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36712 = state_36661;
state_36661 = G__36712;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_36661){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_36661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36691 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36691[(6)] = c__13957__auto__);

return statearr_36691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__36714 = arguments.length;
switch (G__36714) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36795){
var state_val_36796 = (state_36795[(1)]);
if((state_val_36796 === (7))){
var inst_36790 = (state_36795[(2)]);
var _ = (function (){var statearr_36798 = state_36795;
(statearr_36798[(4)] = cljs.core.rest((state_36795[(4)])));

return statearr_36798;
})();
var state_36795__$1 = state_36795;
var statearr_36799_36846 = state_36795__$1;
(statearr_36799_36846[(2)] = inst_36790);

(statearr_36799_36846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (20))){
var inst_36734 = (state_36795[(7)]);
var inst_36735 = (state_36795[(8)]);
var inst_36742 = (state_36795[(9)]);
var inst_36763 = (inst_36734 + (1));
var tmp36797 = inst_36735;
var inst_36733 = inst_36742;
var inst_36734__$1 = inst_36763;
var inst_36735__$1 = tmp36797;
var state_36795__$1 = (function (){var statearr_36800 = state_36795;
(statearr_36800[(7)] = inst_36734__$1);

(statearr_36800[(8)] = inst_36735__$1);

(statearr_36800[(10)] = inst_36733);

return statearr_36800;
})();
var statearr_36801_36847 = state_36795__$1;
(statearr_36801_36847[(2)] = null);

(statearr_36801_36847[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (27))){
var inst_36768 = (state_36795[(11)]);
var inst_36774 = (state_36795[(2)]);
var inst_36775 = fluree.db.util.async.throw_err(inst_36774);
var inst_36776 = (inst_36768.cljs$core$IFn$_invoke$arity$1 ? inst_36768.cljs$core$IFn$_invoke$arity$1(inst_36775) : inst_36768.call(null,inst_36775));
var state_36795__$1 = state_36795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36795__$1,(26),inst_36776);
} else {
if((state_val_36796 === (1))){
var state_36795__$1 = state_36795;
var statearr_36802_36848 = state_36795__$1;
(statearr_36802_36848[(2)] = null);

(statearr_36802_36848[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (24))){
var state_36795__$1 = state_36795;
var statearr_36803_36849 = state_36795__$1;
(statearr_36803_36849[(2)] = null);

(statearr_36803_36849[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (4))){
var inst_36715 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36804_36850 = state_36795__$1;
(statearr_36804_36850[(2)] = inst_36715);

(statearr_36804_36850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (15))){
var inst_36756 = (state_36795[(12)]);
var inst_36756__$1 = offset;
var state_36795__$1 = (function (){var statearr_36805 = state_36795;
(statearr_36805[(12)] = inst_36756__$1);

return statearr_36805;
})();
if(cljs.core.truth_(inst_36756__$1)){
var statearr_36806_36851 = state_36795__$1;
(statearr_36806_36851[(1)] = (17));

} else {
var statearr_36807_36852 = state_36795__$1;
(statearr_36807_36852[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (21))){
var state_36795__$1 = state_36795;
var statearr_36808_36853 = state_36795__$1;
(statearr_36808_36853[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (13))){
var inst_36751 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36810_36854 = state_36795__$1;
(statearr_36810_36854[(2)] = inst_36751);

(statearr_36810_36854[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (22))){
var inst_36786 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36811_36855 = state_36795__$1;
(statearr_36811_36855[(2)] = inst_36786);

(statearr_36811_36855[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (6))){
var inst_36741 = (state_36795[(13)]);
var inst_36743 = (state_36795[(14)]);
var inst_36733 = (state_36795[(10)]);
var inst_36740 = cljs.core.seq(inst_36733);
var inst_36741__$1 = cljs.core.first(inst_36740);
var inst_36742 = cljs.core.next(inst_36740);
var inst_36743__$1 = (inst_36741__$1 == null);
var state_36795__$1 = (function (){var statearr_36812 = state_36795;
(statearr_36812[(13)] = inst_36741__$1);

(statearr_36812[(14)] = inst_36743__$1);

(statearr_36812[(9)] = inst_36742);

return statearr_36812;
})();
if(cljs.core.truth_(inst_36743__$1)){
var statearr_36813_36856 = state_36795__$1;
(statearr_36813_36856[(1)] = (8));

} else {
var statearr_36814_36857 = state_36795__$1;
(statearr_36814_36857[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (25))){
var inst_36784 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36815_36858 = state_36795__$1;
(statearr_36815_36858[(2)] = inst_36784);

(statearr_36815_36858[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (17))){
var inst_36734 = (state_36795[(7)]);
var inst_36758 = (inst_36734 < offset);
var state_36795__$1 = state_36795;
var statearr_36816_36859 = state_36795__$1;
(statearr_36816_36859[(2)] = inst_36758);

(statearr_36816_36859[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (3))){
var inst_36793 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36795__$1,inst_36793);
} else {
if((state_val_36796 === (12))){
var inst_36746 = (state_36795[(15)]);
var state_36795__$1 = state_36795;
var statearr_36817_36860 = state_36795__$1;
(statearr_36817_36860[(2)] = inst_36746);

(statearr_36817_36860[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (2))){
var inst_36728 = (state_36795[(16)]);
var _ = (function (){var statearr_36818 = state_36795;
(statearr_36818[(4)] = cljs.core.cons((5),(state_36795[(4)])));

return statearr_36818;
})();
var inst_36728__$1 = subjects;
var inst_36729 = cljs.core.seq(inst_36728__$1);
var inst_36730 = cljs.core.first(inst_36729);
var inst_36731 = cljs.core.next(inst_36729);
var inst_36732 = cljs.core.PersistentVector.EMPTY;
var inst_36733 = inst_36728__$1;
var inst_36734 = (0);
var inst_36735 = inst_36732;
var state_36795__$1 = (function (){var statearr_36819 = state_36795;
(statearr_36819[(17)] = inst_36730);

(statearr_36819[(18)] = inst_36731);

(statearr_36819[(7)] = inst_36734);

(statearr_36819[(8)] = inst_36735);

(statearr_36819[(16)] = inst_36728__$1);

(statearr_36819[(10)] = inst_36733);

return statearr_36819;
})();
var statearr_36820_36861 = state_36795__$1;
(statearr_36820_36861[(2)] = null);

(statearr_36820_36861[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (23))){
var inst_36730 = (state_36795[(17)]);
var inst_36731 = (state_36795[(18)]);
var inst_36741 = (state_36795[(13)]);
var inst_36734 = (state_36795[(7)]);
var inst_36735 = (state_36795[(8)]);
var inst_36728 = (state_36795[(16)]);
var inst_36742 = (state_36795[(9)]);
var inst_36733 = (state_36795[(10)]);
var inst_36767 = (inst_36734 + (1));
var inst_36768 = (function (){var vec__36737 = inst_36733;
var first__36727 = inst_36730;
var seq__36738 = inst_36742;
var vec__36725 = inst_36728;
var G__36724 = inst_36733;
var r = inst_36742;
var first__36739 = inst_36741;
var acc = inst_36735;
var n = inst_36734;
var seq__36726 = inst_36731;
var s = inst_36741;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_36769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36770 = [inst_36741];
var inst_36771 = (new cljs.core.PersistentVector(null,1,(5),inst_36769,inst_36770,null));
var inst_36772 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36771);
var state_36795__$1 = (function (){var statearr_36821 = state_36795;
(statearr_36821[(11)] = inst_36768);

(statearr_36821[(19)] = inst_36767);

return statearr_36821;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36795__$1,(27),inst_36772);
} else {
if((state_val_36796 === (19))){
var inst_36761 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
if(cljs.core.truth_(inst_36761)){
var statearr_36822_36862 = state_36795__$1;
(statearr_36822_36862[(1)] = (20));

} else {
var statearr_36823_36863 = state_36795__$1;
(statearr_36823_36863[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (11))){
var inst_36734 = (state_36795[(7)]);
var inst_36748 = (inst_36734 > limit);
var state_36795__$1 = state_36795;
var statearr_36825_36864 = state_36795__$1;
(statearr_36825_36864[(2)] = inst_36748);

(statearr_36825_36864[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (9))){
var inst_36746 = (state_36795[(15)]);
var inst_36746__$1 = limit;
var state_36795__$1 = (function (){var statearr_36826 = state_36795;
(statearr_36826[(15)] = inst_36746__$1);

return statearr_36826;
})();
if(cljs.core.truth_(inst_36746__$1)){
var statearr_36827_36865 = state_36795__$1;
(statearr_36827_36865[(1)] = (11));

} else {
var statearr_36828_36866 = state_36795__$1;
(statearr_36828_36866[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (5))){
var _ = (function (){var statearr_36829 = state_36795;
(statearr_36829[(4)] = cljs.core.rest((state_36795[(4)])));

return statearr_36829;
})();
var state_36795__$1 = state_36795;
var ex36824 = (state_36795__$1[(2)]);
var statearr_36830_36867 = state_36795__$1;
(statearr_36830_36867[(5)] = ex36824);


if((ex36824 instanceof Error)){
var statearr_36831_36868 = state_36795__$1;
(statearr_36831_36868[(1)] = (4));

(statearr_36831_36868[(5)] = null);

} else {
throw ex36824;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (14))){
var inst_36735 = (state_36795[(8)]);
var state_36795__$1 = state_36795;
var statearr_36832_36869 = state_36795__$1;
(statearr_36832_36869[(2)] = inst_36735);

(statearr_36832_36869[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (26))){
var inst_36735 = (state_36795[(8)]);
var inst_36742 = (state_36795[(9)]);
var inst_36767 = (state_36795[(19)]);
var inst_36778 = (state_36795[(2)]);
var inst_36779 = fluree.db.util.async.throw_err(inst_36778);
var inst_36780 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36735,inst_36779);
var inst_36733 = inst_36742;
var inst_36734 = inst_36767;
var inst_36735__$1 = inst_36780;
var state_36795__$1 = (function (){var statearr_36833 = state_36795;
(statearr_36833[(7)] = inst_36734);

(statearr_36833[(8)] = inst_36735__$1);

(statearr_36833[(10)] = inst_36733);

return statearr_36833;
})();
var statearr_36834_36870 = state_36795__$1;
(statearr_36834_36870[(2)] = null);

(statearr_36834_36870[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (16))){
var inst_36788 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
var statearr_36835_36871 = state_36795__$1;
(statearr_36835_36871[(2)] = inst_36788);

(statearr_36835_36871[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (10))){
var inst_36753 = (state_36795[(2)]);
var state_36795__$1 = state_36795;
if(cljs.core.truth_(inst_36753)){
var statearr_36836_36872 = state_36795__$1;
(statearr_36836_36872[(1)] = (14));

} else {
var statearr_36837_36873 = state_36795__$1;
(statearr_36837_36873[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (18))){
var inst_36756 = (state_36795[(12)]);
var state_36795__$1 = state_36795;
var statearr_36838_36874 = state_36795__$1;
(statearr_36838_36874[(2)] = inst_36756);

(statearr_36838_36874[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36796 === (8))){
var inst_36743 = (state_36795[(14)]);
var state_36795__$1 = state_36795;
var statearr_36839_36875 = state_36795__$1;
(statearr_36839_36875[(2)] = inst_36743);

(statearr_36839_36875[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_36840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36840[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_36840[(1)] = (1));

return statearr_36840;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_36795){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36795);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36841){var ex__13886__auto__ = e36841;
var statearr_36842_36876 = state_36795;
(statearr_36842_36876[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36795[(4)]))){
var statearr_36843_36877 = state_36795;
(statearr_36843_36877[(1)] = cljs.core.first((state_36795[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36878 = state_36795;
state_36795 = G__36878;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_36795){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_36795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36844 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36844[(6)] = c__13957__auto__);

return statearr_36844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4160__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__36880 = arguments.length;
switch (G__36880) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37068){
var state_val_37069 = (state_37068[(1)]);
if((state_val_37069 === (7))){
var state_37068__$1 = state_37068;
var statearr_37070_37141 = state_37068__$1;
(statearr_37070_37141[(2)] = null);

(statearr_37070_37141[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (20))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_36951 = (state_37068[(2)]);
var inst_36952 = fluree.db.util.async.throw_err(inst_36951);
var inst_36953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36954 = [inst_36921];
var inst_36955 = (new cljs.core.PersistentVector(null,1,(5),inst_36953,inst_36954,null));
var inst_36956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36957 = [inst_36921,inst_36923];
var inst_36958 = (new cljs.core.PersistentVector(null,2,(5),inst_36956,inst_36957,null));
var inst_36959 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36955,cljs.core._LT_,inst_36958);
var state_37068__$1 = (function (){var statearr_37071 = state_37068;
(statearr_37071[(9)] = inst_36952);

return statearr_37071;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(21),inst_36959);
} else {
if((state_val_37069 === (27))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_36988 = (inst_36940.cljs$core$IFn$_invoke$arity$2 ? inst_36940.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_36922) : inst_36940.call(null,cljs.core._GT__EQ_,inst_36922));
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36988)){
var statearr_37072_37142 = state_37068__$1;
(statearr_37072_37142[(1)] = (30));

} else {
var statearr_37073_37143 = state_37068__$1;
(statearr_37073_37143[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (1))){
var state_37068__$1 = state_37068;
var statearr_37074_37144 = state_37068__$1;
(statearr_37074_37144[(2)] = null);

(statearr_37074_37144[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (24))){
var inst_37037 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37075_37145 = state_37068__$1;
(statearr_37075_37145[(2)] = inst_37037);

(statearr_37075_37145[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (39))){
var inst_37027 = null;
var state_37068__$1 = state_37068;
var statearr_37076_37146 = state_37068__$1;
(statearr_37076_37146[(2)] = inst_37027);

(statearr_37076_37146[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (46))){
var inst_36914 = (state_37068[(12)]);
var inst_37048 = (state_37068[(13)]);
var inst_36906 = inst_36914;
var inst_36907 = inst_37048;
var state_37068__$1 = (function (){var statearr_37077 = state_37068;
(statearr_37077[(14)] = inst_36906);

(statearr_37077[(15)] = inst_36907);

return statearr_37077;
})();
var statearr_37078_37147 = state_37068__$1;
(statearr_37078_37147[(2)] = null);

(statearr_37078_37147[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (4))){
var inst_36881 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37079_37148 = state_37068__$1;
(statearr_37079_37148[(2)] = inst_36881);

(statearr_37079_37148[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (15))){
var state_37068__$1 = state_37068;
var statearr_37080_37149 = state_37068__$1;
(statearr_37080_37149[(2)] = null);

(statearr_37080_37149[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (21))){
var inst_36952 = (state_37068[(9)]);
var inst_36961 = (state_37068[(2)]);
var inst_36962 = fluree.db.util.async.throw_err(inst_36961);
var inst_36963 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36952,inst_36962);
var state_37068__$1 = state_37068;
var statearr_37081_37150 = state_37068__$1;
(statearr_37081_37150[(2)] = inst_36963);

(statearr_37081_37150[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (31))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_37001 = (inst_36940.cljs$core$IFn$_invoke$arity$2 ? inst_36940.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_36922) : inst_36940.call(null,cljs.core._LT_,inst_36922));
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_37001)){
var statearr_37082_37151 = state_37068__$1;
(statearr_37082_37151[(1)] = (34));

} else {
var statearr_37083_37152 = state_37068__$1;
(statearr_37083_37152[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (32))){
var inst_37033 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37084_37153 = state_37068__$1;
(statearr_37084_37153[(2)] = inst_37033);

(statearr_37084_37153[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (40))){
var inst_37029 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37085_37154 = state_37068__$1;
(statearr_37085_37154[(2)] = inst_37029);

(statearr_37085_37154[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (33))){
var inst_36998 = (state_37068[(2)]);
var inst_36999 = fluree.db.util.async.throw_err(inst_36998);
var state_37068__$1 = state_37068;
var statearr_37086_37155 = state_37068__$1;
(statearr_37086_37155[(2)] = inst_36999);

(statearr_37086_37155[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (13))){
var inst_37058 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37087_37156 = state_37068__$1;
(statearr_37087_37156[(2)] = inst_37058);

(statearr_37087_37156[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (22))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_36967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36968 = [inst_36921,inst_36923];
var inst_36969 = (new cljs.core.PersistentVector(null,2,(5),inst_36967,inst_36968,null));
var inst_36970 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_36969);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(25),inst_36970);
} else {
if((state_val_37069 === (36))){
var inst_37031 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37088_37157 = state_37068__$1;
(statearr_37088_37157[(2)] = inst_37031);

(statearr_37088_37157[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (41))){
var inst_37024 = (state_37068[(2)]);
var inst_37025 = fluree.db.util.async.throw_err(inst_37024);
var state_37068__$1 = state_37068;
var statearr_37089_37158 = state_37068__$1;
(statearr_37089_37158[(2)] = inst_37025);

(statearr_37089_37158[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (43))){
var inst_37040 = (state_37068[(16)]);
var inst_36907 = (state_37068[(15)]);
var inst_37041 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36907,inst_37040);
var state_37068__$1 = state_37068;
var statearr_37090_37159 = state_37068__$1;
(statearr_37090_37159[(2)] = inst_37041);

(statearr_37090_37159[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (29))){
var inst_36985 = (state_37068[(2)]);
var inst_36986 = fluree.db.util.async.throw_err(inst_36985);
var state_37068__$1 = state_37068;
var statearr_37091_37160 = state_37068__$1;
(statearr_37091_37160[(2)] = inst_36986);

(statearr_37091_37160[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (44))){
var inst_37040 = (state_37068[(16)]);
var inst_36907 = (state_37068[(15)]);
var inst_37043 = cljs.core.PersistentHashSet.EMPTY;
var inst_37044 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37043,inst_37040);
var inst_37045 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_36907,inst_37044);
var state_37068__$1 = state_37068;
var statearr_37092_37161 = state_37068__$1;
(statearr_37092_37161[(2)] = inst_37045);

(statearr_37092_37161[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (6))){
var inst_36892 = (state_37068[(17)]);
var inst_36902 = cljs.core.seq(inst_36892);
var inst_36903 = cljs.core.first(inst_36902);
var inst_36904 = cljs.core.next(inst_36902);
var inst_36905 = cljs.core.PersistentHashSet.EMPTY;
var inst_36906 = inst_36892;
var inst_36907 = inst_36905;
var state_37068__$1 = (function (){var statearr_37093 = state_37068;
(statearr_37093[(18)] = inst_36904);

(statearr_37093[(14)] = inst_36906);

(statearr_37093[(15)] = inst_36907);

(statearr_37093[(19)] = inst_36903);

return statearr_37093;
})();
var statearr_37094_37162 = state_37068__$1;
(statearr_37094_37162[(2)] = null);

(statearr_37094_37162[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (28))){
var inst_37035 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37095_37163 = state_37068__$1;
(statearr_37095_37163[(2)] = inst_37035);

(statearr_37095_37163[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (25))){
var inst_36972 = (state_37068[(2)]);
var inst_36973 = fluree.db.util.async.throw_err(inst_36972);
var state_37068__$1 = state_37068;
var statearr_37096_37164 = state_37068__$1;
(statearr_37096_37164[(2)] = inst_36973);

(statearr_37096_37164[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (34))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_37003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37004 = [inst_36921];
var inst_37005 = (new cljs.core.PersistentVector(null,1,(5),inst_37003,inst_37004,null));
var inst_37006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37007 = [inst_36921,inst_36923];
var inst_37008 = (new cljs.core.PersistentVector(null,2,(5),inst_37006,inst_37007,null));
var inst_37009 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_37005,cljs.core._LT_,inst_37008);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(37),inst_37009);
} else {
if((state_val_37069 === (17))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_36943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36944 = [inst_36921,inst_36923];
var inst_36945 = (new cljs.core.PersistentVector(null,2,(5),inst_36943,inst_36944,null));
var inst_36946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36947 = [inst_36921];
var inst_36948 = (new cljs.core.PersistentVector(null,1,(5),inst_36946,inst_36947,null));
var inst_36949 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_36945,cljs.core._LT__EQ_,inst_36948);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(20),inst_36949);
} else {
if((state_val_37069 === (3))){
var inst_37066 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37068__$1,inst_37066);
} else {
if((state_val_37069 === (12))){
var inst_36913 = (state_37068[(20)]);
var inst_36921 = (state_37068[(7)]);
var inst_36921__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36913,(0),null);
var inst_36922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36913,(1),null);
var inst_36923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36913,(2),null);
var inst_36924 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_36921__$1);
var inst_36925 = cljs.core.not(inst_36924);
var state_37068__$1 = (function (){var statearr_37097 = state_37068;
(statearr_37097[(11)] = inst_36922);

(statearr_37097[(7)] = inst_36921__$1);

(statearr_37097[(8)] = inst_36923);

return statearr_37097;
})();
if(inst_36925){
var statearr_37098_37165 = state_37068__$1;
(statearr_37098_37165[(1)] = (14));

} else {
var statearr_37099_37166 = state_37068__$1;
(statearr_37099_37166[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (2))){
var inst_36892 = (state_37068[(17)]);
var _ = (function (){var statearr_37100 = state_37068;
(statearr_37100[(4)] = cljs.core.cons((5),(state_37068[(4)])));

return statearr_37100;
})();
var inst_36890 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_36891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36890,(0),null);
var inst_36892__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36890,(1),null);
var inst_36893 = cljs.core.not_empty(inst_36892__$1);
var state_37068__$1 = (function (){var statearr_37101 = state_37068;
(statearr_37101[(17)] = inst_36892__$1);

(statearr_37101[(21)] = inst_36891);

return statearr_37101;
})();
if(cljs.core.truth_(inst_36893)){
var statearr_37102_37167 = state_37068__$1;
(statearr_37102_37167[(1)] = (6));

} else {
var statearr_37103_37168 = state_37068__$1;
(statearr_37103_37168[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (23))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_36975 = (inst_36940.cljs$core$IFn$_invoke$arity$2 ? inst_36940.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_36922) : inst_36940.call(null,cljs.core._GT_,inst_36922));
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36975)){
var statearr_37104_37169 = state_37068__$1;
(statearr_37104_37169[(1)] = (26));

} else {
var statearr_37105_37170 = state_37068__$1;
(statearr_37105_37170[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (47))){
var inst_37056 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37106_37171 = state_37068__$1;
(statearr_37106_37171[(2)] = inst_37056);

(statearr_37106_37171[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (35))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_37014 = (inst_36940.cljs$core$IFn$_invoke$arity$2 ? inst_36940.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_36922) : inst_36940.call(null,cljs.core._LT__EQ_,inst_36922));
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_37014)){
var statearr_37107_37172 = state_37068__$1;
(statearr_37107_37172[(1)] = (38));

} else {
var statearr_37108_37173 = state_37068__$1;
(statearr_37108_37173[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (19))){
var inst_36891 = (state_37068[(21)]);
var inst_37039 = (state_37068[(2)]);
var inst_37040 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_37039);
var state_37068__$1 = (function (){var statearr_37109 = state_37068;
(statearr_37109[(16)] = inst_37040);

return statearr_37109;
})();
var G__37110_37174 = inst_36891;
var G__37110_37175__$1 = (((G__37110_37174 instanceof cljs.core.Keyword))?G__37110_37174.fqn:null);
switch (G__37110_37175__$1) {
case "or":
var statearr_37111_37177 = state_37068__$1;
(statearr_37111_37177[(1)] = (43));


break;
case "and":
var statearr_37112_37178 = state_37068__$1;
(statearr_37112_37178[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37110_37175__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (11))){
var inst_36907 = (state_37068[(15)]);
var state_37068__$1 = state_37068;
var statearr_37114_37179 = state_37068__$1;
(statearr_37114_37179[(2)] = inst_36907);

(statearr_37114_37179[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (9))){
var inst_36913 = (state_37068[(20)]);
var inst_36906 = (state_37068[(14)]);
var inst_36912 = cljs.core.seq(inst_36906);
var inst_36913__$1 = cljs.core.first(inst_36912);
var inst_36914 = cljs.core.next(inst_36912);
var inst_36915 = cljs.core.not(inst_36913__$1);
var state_37068__$1 = (function (){var statearr_37115 = state_37068;
(statearr_37115[(12)] = inst_36914);

(statearr_37115[(20)] = inst_36913__$1);

return statearr_37115;
})();
if(inst_36915){
var statearr_37116_37180 = state_37068__$1;
(statearr_37116_37180[(1)] = (11));

} else {
var statearr_37117_37181 = state_37068__$1;
(statearr_37117_37181[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (5))){
var _ = (function (){var statearr_37118 = state_37068;
(statearr_37118[(4)] = cljs.core.rest((state_37068[(4)])));

return statearr_37118;
})();
var state_37068__$1 = state_37068;
var ex37113 = (state_37068__$1[(2)]);
var statearr_37119_37182 = state_37068__$1;
(statearr_37119_37182[(5)] = ex37113);


if((ex37113 instanceof Error)){
var statearr_37120_37183 = state_37068__$1;
(statearr_37120_37183[(1)] = (4));

(statearr_37120_37183[(5)] = null);

} else {
throw ex37113;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (14))){
var inst_36921 = (state_37068[(7)]);
var inst_36927 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_36921);
var inst_36928 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36927)].join('');
var inst_36929 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36930 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36931 = cljs.core.PersistentHashMap.fromArrays(inst_36929,inst_36930);
var inst_36932 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36928,inst_36931);
var inst_36933 = (function(){throw inst_36932})();
var state_37068__$1 = state_37068;
var statearr_37121_37184 = state_37068__$1;
(statearr_37121_37184[(2)] = inst_36933);

(statearr_37121_37184[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (45))){
var inst_37048 = (state_37068[(13)]);
var state_37068__$1 = state_37068;
var statearr_37122_37185 = state_37068__$1;
(statearr_37122_37185[(2)] = inst_37048);

(statearr_37122_37185[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (26))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_36977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36978 = [inst_36921,inst_36923];
var inst_36979 = (new cljs.core.PersistentVector(null,2,(5),inst_36977,inst_36978,null));
var inst_36980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36981 = [inst_36921];
var inst_36982 = (new cljs.core.PersistentVector(null,1,(5),inst_36980,inst_36981,null));
var inst_36983 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_36979,cljs.core._LT__EQ_,inst_36982);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(29),inst_36983);
} else {
if((state_val_37069 === (16))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_36936 = (state_37068[(2)]);
var inst_36940__$1 = cljs.core.identical_QMARK_;
var inst_36941 = (inst_36940__$1.cljs$core$IFn$_invoke$arity$2 ? inst_36940__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_36922) : inst_36940__$1.call(null,cljs.core.not_EQ_,inst_36922));
var state_37068__$1 = (function (){var statearr_37123 = state_37068;
(statearr_37123[(22)] = inst_36936);

(statearr_37123[(10)] = inst_36940__$1);

return statearr_37123;
})();
if(cljs.core.truth_(inst_36941)){
var statearr_37124_37186 = state_37068__$1;
(statearr_37124_37186[(1)] = (17));

} else {
var statearr_37125_37187 = state_37068__$1;
(statearr_37125_37187[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (38))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_37016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37017 = [inst_36921];
var inst_37018 = (new cljs.core.PersistentVector(null,1,(5),inst_37016,inst_37017,null));
var inst_37019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37020 = [inst_36921,inst_36923];
var inst_37021 = (new cljs.core.PersistentVector(null,2,(5),inst_37019,inst_37020,null));
var inst_37022 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_37018,cljs.core._LT__EQ_,inst_37021);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(41),inst_37022);
} else {
if((state_val_37069 === (30))){
var inst_36921 = (state_37068[(7)]);
var inst_36923 = (state_37068[(8)]);
var inst_36990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36991 = [inst_36921,inst_36923];
var inst_36992 = (new cljs.core.PersistentVector(null,2,(5),inst_36990,inst_36991,null));
var inst_36993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36994 = [inst_36921];
var inst_36995 = (new cljs.core.PersistentVector(null,1,(5),inst_36993,inst_36994,null));
var inst_36996 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36992,cljs.core._LT__EQ_,inst_36995);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(33),inst_36996);
} else {
if((state_val_37069 === (10))){
var inst_37060 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37126_37188 = state_37068__$1;
(statearr_37126_37188[(2)] = inst_37060);

(statearr_37126_37188[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (18))){
var inst_36940 = (state_37068[(10)]);
var inst_36922 = (state_37068[(11)]);
var inst_36965 = (inst_36940.cljs$core$IFn$_invoke$arity$2 ? inst_36940.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_36922) : inst_36940.call(null,cljs.core._EQ_,inst_36922));
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36965)){
var statearr_37127_37189 = state_37068__$1;
(statearr_37127_37189[(1)] = (22));

} else {
var statearr_37128_37190 = state_37068__$1;
(statearr_37128_37190[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (42))){
var inst_36891 = (state_37068[(21)]);
var inst_37048 = (state_37068[(13)]);
var inst_37048__$1 = (state_37068[(2)]);
var inst_37049 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_36891);
var inst_37050 = cljs.core.empty_QMARK_(inst_37048__$1);
var inst_37051 = ((inst_37049) && (inst_37050));
var state_37068__$1 = (function (){var statearr_37129 = state_37068;
(statearr_37129[(13)] = inst_37048__$1);

return statearr_37129;
})();
if(cljs.core.truth_(inst_37051)){
var statearr_37130_37191 = state_37068__$1;
(statearr_37130_37191[(1)] = (45));

} else {
var statearr_37131_37192 = state_37068__$1;
(statearr_37131_37192[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (37))){
var inst_37011 = (state_37068[(2)]);
var inst_37012 = fluree.db.util.async.throw_err(inst_37011);
var state_37068__$1 = state_37068;
var statearr_37132_37193 = state_37068__$1;
(statearr_37132_37193[(2)] = inst_37012);

(statearr_37132_37193[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (8))){
var inst_37063 = (state_37068[(2)]);
var _ = (function (){var statearr_37133 = state_37068;
(statearr_37133[(4)] = cljs.core.rest((state_37068[(4)])));

return statearr_37133;
})();
var state_37068__$1 = state_37068;
var statearr_37134_37194 = state_37068__$1;
(statearr_37134_37194[(2)] = inst_37063);

(statearr_37134_37194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_37135 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37135[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_37135[(1)] = (1));

return statearr_37135;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_37068){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37068);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37136){var ex__13886__auto__ = e37136;
var statearr_37137_37195 = state_37068;
(statearr_37137_37195[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37068[(4)]))){
var statearr_37138_37196 = state_37068;
(statearr_37138_37196[(1)] = cljs.core.first((state_37068[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37197 = state_37068;
state_37068 = G__37197;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_37068){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_37068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37139 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37139[(6)] = c__13957__auto__);

return statearr_37139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4160__auto__ = cljs.core.every_QMARK_((function (p1__37198_SHARP_){
return ((typeof p1__37198_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__37198_SHARP_)));
}),select_smt);
if(or__4160__auto__){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__37199_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__37199_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__37203 = vars;
var vec__37204 = G__37203;
var seq__37205 = cljs.core.seq(vec__37204);
var first__37206 = cljs.core.first(seq__37205);
var seq__37205__$1 = cljs.core.next(seq__37205);
var var$ = first__37206;
var r = seq__37205__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__37203__$1 = G__37203;
var all_vars__$1 = all_vars;
while(true){
var vec__37211 = G__37203__$1;
var seq__37212 = cljs.core.seq(vec__37211);
var first__37213 = cljs.core.first(seq__37212);
var seq__37212__$1 = cljs.core.next(seq__37212);
var var$__$1 = first__37213;
var r__$1 = seq__37212__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__37214 = cljs.core.set(all_vars__$2);
return (fexpr__37214.cljs$core$IFn$_invoke$arity$1 ? fexpr__37214.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__37214.call(null,var$__$1));
})())){
var G__37215 = r__$1;
var G__37216 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__37203__$1 = G__37215;
all_vars__$1 = G__37216;
continue;
} else {
var G__37217 = r__$1;
var G__37218 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__37203__$1 = G__37217;
all_vars__$1 = G__37218;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37253){
var state_val_37254 = (state_37253[(1)]);
if((state_val_37254 === (1))){
var inst_37226 = functionArray;
var inst_37227 = cljs.core.seq(inst_37226);
var inst_37228 = cljs.core.first(inst_37227);
var inst_37229 = cljs.core.next(inst_37227);
var inst_37230 = cljs.core.PersistentVector.EMPTY;
var inst_37231 = inst_37226;
var inst_37232 = inst_37230;
var state_37253__$1 = (function (){var statearr_37255 = state_37253;
(statearr_37255[(7)] = inst_37232);

(statearr_37255[(8)] = inst_37228);

(statearr_37255[(9)] = inst_37229);

(statearr_37255[(10)] = inst_37231);

return statearr_37255;
})();
var statearr_37256_37269 = state_37253__$1;
(statearr_37256_37269[(2)] = null);

(statearr_37256_37269[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37254 === (2))){
var inst_37238 = (state_37253[(11)]);
var inst_37231 = (state_37253[(10)]);
var inst_37237 = cljs.core.seq(inst_37231);
var inst_37238__$1 = cljs.core.first(inst_37237);
var inst_37239 = cljs.core.next(inst_37237);
var state_37253__$1 = (function (){var statearr_37257 = state_37253;
(statearr_37257[(12)] = inst_37239);

(statearr_37257[(11)] = inst_37238__$1);

return statearr_37257;
})();
if(cljs.core.truth_(inst_37238__$1)){
var statearr_37258_37270 = state_37253__$1;
(statearr_37258_37270[(1)] = (4));

} else {
var statearr_37259_37271 = state_37253__$1;
(statearr_37259_37271[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37254 === (3))){
var inst_37251 = (state_37253[(2)]);
var state_37253__$1 = state_37253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37253__$1,inst_37251);
} else {
if((state_val_37254 === (4))){
var inst_37238 = (state_37253[(11)]);
var inst_37241 = (inst_37238.cljs$core$IFn$_invoke$arity$1 ? inst_37238.cljs$core$IFn$_invoke$arity$1(tuple) : inst_37238.call(null,tuple));
var state_37253__$1 = state_37253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37253__$1,(7),inst_37241);
} else {
if((state_val_37254 === (5))){
var inst_37232 = (state_37253[(7)]);
var state_37253__$1 = state_37253;
var statearr_37260_37272 = state_37253__$1;
(statearr_37260_37272[(2)] = inst_37232);

(statearr_37260_37272[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37254 === (6))){
var inst_37249 = (state_37253[(2)]);
var state_37253__$1 = state_37253;
var statearr_37261_37273 = state_37253__$1;
(statearr_37261_37273[(2)] = inst_37249);

(statearr_37261_37273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37254 === (7))){
var inst_37239 = (state_37253[(12)]);
var inst_37232 = (state_37253[(7)]);
var inst_37243 = (state_37253[(2)]);
var inst_37244 = fluree.db.util.async.throw_err(inst_37243);
var inst_37245 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37232,inst_37244);
var inst_37231 = inst_37239;
var inst_37232__$1 = inst_37245;
var state_37253__$1 = (function (){var statearr_37262 = state_37253;
(statearr_37262[(7)] = inst_37232__$1);

(statearr_37262[(10)] = inst_37231);

return statearr_37262;
})();
var statearr_37263_37274 = state_37253__$1;
(statearr_37263_37274[(2)] = null);

(statearr_37263_37274[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0 = (function (){
var statearr_37264 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37264[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__);

(statearr_37264[(1)] = (1));

return statearr_37264;
});
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1 = (function (state_37253){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37253);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37265){var ex__13886__auto__ = e37265;
var statearr_37266_37275 = state_37253;
(statearr_37266_37275[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37253[(4)]))){
var statearr_37267_37276 = state_37253;
(statearr_37267_37276[(1)] = cljs.core.first((state_37253[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37277 = state_37253;
state_37253 = G__37277;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__ = function(state_37253){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1.call(this,state_37253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37268 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37268[(6)] = c__13957__auto__);

return statearr_37268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__37278){
var vec__37279 = p__37278;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37279,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37279,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37293){
var state_val_37294 = (state_37293[(1)]);
if((state_val_37294 === (1))){
var inst_37282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37283 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_37284 = [query_map,_id,query_opts];
var inst_37285 = cljs.core.PersistentHashMap.fromArrays(inst_37283,inst_37284);
var inst_37286 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_37285) : fluree.db.query.fql.query.call(null,db,inst_37285));
var state_37293__$1 = (function (){var statearr_37295 = state_37293;
(statearr_37295[(7)] = inst_37282);

return statearr_37295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37293__$1,(2),inst_37286);
} else {
if((state_val_37294 === (2))){
var inst_37282 = (state_37293[(7)]);
var inst_37288 = (state_37293[(2)]);
var inst_37289 = fluree.db.util.async.throw_err(inst_37288);
var inst_37290 = [tuple_index,inst_37289];
var inst_37291 = (new cljs.core.PersistentVector(null,2,(5),inst_37282,inst_37290,null));
var state_37293__$1 = state_37293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37293__$1,inst_37291);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0 = (function (){
var statearr_37296 = [null,null,null,null,null,null,null,null];
(statearr_37296[(0)] = fluree$db$query$fql$expand_map_$_state_machine__13883__auto__);

(statearr_37296[(1)] = (1));

return statearr_37296;
});
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1 = (function (state_37293){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37293);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37297){var ex__13886__auto__ = e37297;
var statearr_37298_37301 = state_37293;
(statearr_37298_37301[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37293[(4)]))){
var statearr_37299_37302 = state_37293;
(statearr_37299_37302[(1)] = cljs.core.first((state_37293[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37303 = state_37293;
state_37293 = G__37303;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__ = function(state_37293){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1.call(this,state_37293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37300 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37300[(6)] = c__13957__auto__);

return statearr_37300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__37304 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37304,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37304,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37369){
var state_val_37370 = (state_37369[(1)]);
if((state_val_37370 === (7))){
var inst_37364 = (state_37369[(2)]);
var _ = (function (){var statearr_37371 = state_37369;
(statearr_37371[(4)] = cljs.core.rest((state_37369[(4)])));

return statearr_37371;
})();
var state_37369__$1 = state_37369;
var statearr_37372_37463 = state_37369__$1;
(statearr_37372_37463[(2)] = inst_37364);

(statearr_37372_37463[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (20))){
var inst_37355 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37373_37464 = state_37369__$1;
(statearr_37373_37464[(2)] = inst_37355);

(statearr_37373_37464[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (1))){
var state_37369__$1 = state_37369;
var statearr_37374_37465 = state_37369__$1;
(statearr_37374_37465[(2)] = null);

(statearr_37374_37465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (4))){
var inst_37309 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37375_37466 = state_37369__$1;
(statearr_37375_37466[(2)] = inst_37309);

(statearr_37375_37466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (15))){
var inst_37329 = (state_37369[(7)]);
var inst_37338 = cljs.core._deref(fuel);
var inst_37339 = cljs.core.second(inst_37329);
var inst_37340 = (inst_37338 + inst_37339);
var inst_37341 = cljs.core._vreset_BANG_(fuel,inst_37340);
var inst_37342 = (inst_37341 > max_fuel);
var state_37369__$1 = state_37369;
if(cljs.core.truth_(inst_37342)){
var statearr_37376_37467 = state_37369__$1;
(statearr_37376_37467[(1)] = (18));

} else {
var statearr_37377_37468 = state_37369__$1;
(statearr_37377_37468[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (13))){
var state_37369__$1 = state_37369;
var statearr_37378_37469 = state_37369__$1;
(statearr_37378_37469[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (6))){
var inst_37317 = (state_37369[(8)]);
var state_37369__$1 = state_37369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37369__$1,(8),inst_37317);
} else {
if((state_val_37370 === (17))){
var inst_37358 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37380_37470 = state_37369__$1;
(statearr_37380_37470[(2)] = inst_37358);

(statearr_37380_37470[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (3))){
var inst_37367 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37369__$1,inst_37367);
} else {
if((state_val_37370 === (12))){
var inst_37318 = (state_37369[(9)]);
var inst_37329 = (state_37369[(7)]);
var inst_37335 = (inst_37318.cljs$core$IFn$_invoke$arity$0 ? inst_37318.cljs$core$IFn$_invoke$arity$0() : inst_37318.call(null));
var state_37369__$1 = (function (){var statearr_37381 = state_37369;
(statearr_37381[(10)] = inst_37335);

return statearr_37381;
})();
var statearr_37382_37471 = state_37369__$1;
(statearr_37382_37471[(2)] = inst_37329);

(statearr_37382_37471[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (2))){
var inst_37318 = (state_37369[(9)]);
var inst_37317 = (state_37369[(8)]);
var _ = (function (){var statearr_37383 = state_37369;
(statearr_37383[(4)] = cljs.core.cons((5),(state_37369[(4)])));

return statearr_37383;
})();
var inst_37315 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_37316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_37317__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_37318__$1 = (function (){var expandMaps = inst_37315;
var queue_ch = inst_37316;
var res_ch = inst_37317__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_37319 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_37320 = cljs.core.volatile_BANG_((0));
var inst_37321 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37319,cljs.core.cst$kw$fuel,inst_37320);
var inst_37322 = (function (){var expandMaps = inst_37315;
var queue_ch = inst_37316;
var res_ch = inst_37317__$1;
var stop_BANG_ = inst_37318__$1;
var opts_STAR_ = inst_37321;
return (function (tuple_res,port){
var c__13957__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37416){
var state_val_37417 = (state_37416[(1)]);
if((state_val_37417 === (7))){
var state_37416__$1 = state_37416;
var statearr_37418_37472 = state_37416__$1;
(statearr_37418_37472[(2)] = tuple_res);

(statearr_37418_37472[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (1))){
var state_37416__$1 = state_37416;
var statearr_37419_37473 = state_37416__$1;
(statearr_37419_37473[(2)] = null);

(statearr_37419_37473[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (4))){
var inst_37384 = (state_37416[(2)]);
var inst_37385 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_37384);
var inst_37386 = cljs.core.async.close_BANG_(port);
var state_37416__$1 = (function (){var statearr_37420 = state_37416;
(statearr_37420[(7)] = inst_37385);

return statearr_37420;
})();
var statearr_37421_37474 = state_37416__$1;
(statearr_37421_37474[(2)] = inst_37386);

(statearr_37421_37474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (6))){
var inst_37393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37394 = [tuple_res];
var inst_37395 = (new cljs.core.PersistentVector(null,1,(5),inst_37393,inst_37394,null));
var state_37416__$1 = state_37416;
var statearr_37422_37475 = state_37416__$1;
(statearr_37422_37475[(2)] = inst_37395);

(statearr_37422_37475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (3))){
var inst_37414 = (state_37416[(2)]);
var state_37416__$1 = state_37416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37416__$1,inst_37414);
} else {
if((state_val_37417 === (2))){
var ___$1 = (function (){var statearr_37424 = state_37416;
(statearr_37424[(4)] = cljs.core.cons((5),(state_37416[(4)])));

return statearr_37424;
})();
var state_37416__$1 = state_37416;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_37425_37476 = state_37416__$1;
(statearr_37425_37476[(1)] = (6));

} else {
var statearr_37426_37477 = state_37416__$1;
(statearr_37426_37477[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (9))){
var inst_37398 = (state_37416[(8)]);
var inst_37400 = (state_37416[(9)]);
var inst_37407 = (state_37416[(2)]);
var inst_37408 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_37398,inst_37407);
var inst_37409 = (inst_37400.cljs$core$IFn$_invoke$arity$1 ? inst_37400.cljs$core$IFn$_invoke$arity$1(inst_37408) : inst_37400.call(null,inst_37408));
var inst_37410 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_37409);
var inst_37411 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_37427 = state_37416;
(statearr_37427[(4)] = cljs.core.rest((state_37416[(4)])));

return statearr_37427;
})();
var state_37416__$1 = (function (){var statearr_37428 = state_37416;
(statearr_37428[(10)] = inst_37410);

return statearr_37428;
})();
var statearr_37429_37478 = state_37416__$1;
(statearr_37429_37478[(2)] = inst_37411);

(statearr_37429_37478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (5))){
var ___$1 = (function (){var statearr_37430 = state_37416;
(statearr_37430[(4)] = cljs.core.rest((state_37416[(4)])));

return statearr_37430;
})();
var state_37416__$1 = state_37416;
var ex37423 = (state_37416__$1[(2)]);
var statearr_37431_37479 = state_37416__$1;
(statearr_37431_37479[(5)] = ex37423);


var statearr_37432_37480 = state_37416__$1;
(statearr_37432_37480[(1)] = (4));

(statearr_37432_37480[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37417 === (8))){
var inst_37398 = (state_37416[(8)]);
var inst_37398__$1 = (state_37416[(2)]);
var inst_37399 = cljs.core.volatile_BANG_((0));
var inst_37400 = (function (){var tuple_res_SINGLEQUOTE_ = inst_37398__$1;
var query_fuel = inst_37399;
return (function (p1__37308_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__37308_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37308_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_37401 = cljs.core.PersistentVector.EMPTY;
var inst_37402 = (function (){var tuple_res_SINGLEQUOTE_ = inst_37398__$1;
var query_fuel = inst_37399;
return (function (p1__37307_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__37307_SHARP_);
});
})();
var inst_37403 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_37402,expandMaps);
var inst_37404 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_37403);
var inst_37405 = cljs.core.async.into(inst_37401,inst_37404);
var state_37416__$1 = (function (){var statearr_37433 = state_37416;
(statearr_37433[(8)] = inst_37398__$1);

(statearr_37433[(9)] = inst_37400);

return statearr_37433;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37416__$1,(9),inst_37405);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0 = (function (){
var statearr_37434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37434[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__);

(statearr_37434[(1)] = (1));

return statearr_37434;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1 = (function (state_37416){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37416);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37435){var ex__13886__auto__ = e37435;
var statearr_37436_37481 = state_37416;
(statearr_37436_37481[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37416[(4)]))){
var statearr_37437_37482 = state_37416;
(statearr_37437_37482[(1)] = cljs.core.first((state_37416[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37483 = state_37416;
state_37416 = G__37483;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = function(state_37416){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1.call(this,state_37416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37438 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37438[(6)] = c__13957__auto____$1);

return statearr_37438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto____$1;
});
})();
var inst_37323 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37316,tuples_res);
var inst_37324 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_37317__$1,inst_37322,inst_37316);
var inst_37325 = cljs.core.PersistentVector.EMPTY;
var inst_37326 = inst_37325;
var state_37369__$1 = (function (){var statearr_37439 = state_37369;
(statearr_37439[(9)] = inst_37318__$1);

(statearr_37439[(11)] = inst_37323);

(statearr_37439[(8)] = inst_37317__$1);

(statearr_37439[(12)] = inst_37324);

(statearr_37439[(13)] = inst_37326);

return statearr_37439;
})();
var statearr_37440_37484 = state_37369__$1;
(statearr_37440_37484[(2)] = null);

(statearr_37440_37484[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (19))){
var inst_37326 = (state_37369[(13)]);
var inst_37329 = (state_37369[(7)]);
var inst_37351 = cljs.core.first(inst_37329);
var inst_37352 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37326,inst_37351);
var inst_37326__$1 = inst_37352;
var state_37369__$1 = (function (){var statearr_37441 = state_37369;
(statearr_37441[(13)] = inst_37326__$1);

return statearr_37441;
})();
var statearr_37442_37485 = state_37369__$1;
(statearr_37442_37485[(2)] = null);

(statearr_37442_37485[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (11))){
var inst_37362 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37444_37486 = state_37369__$1;
(statearr_37444_37486[(2)] = inst_37362);

(statearr_37444_37486[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (9))){
var inst_37326 = (state_37369[(13)]);
var state_37369__$1 = state_37369;
var statearr_37445_37487 = state_37369__$1;
(statearr_37445_37487[(2)] = inst_37326);

(statearr_37445_37487[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (5))){
var _ = (function (){var statearr_37446 = state_37369;
(statearr_37446[(4)] = cljs.core.rest((state_37369[(4)])));

return statearr_37446;
})();
var state_37369__$1 = state_37369;
var ex37443 = (state_37369__$1[(2)]);
var statearr_37447_37488 = state_37369__$1;
(statearr_37447_37488[(5)] = ex37443);


if((ex37443 instanceof Error)){
var statearr_37448_37489 = state_37369__$1;
(statearr_37448_37489[(1)] = (4));

(statearr_37448_37489[(5)] = null);

} else {
throw ex37443;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (14))){
var inst_37360 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37449_37490 = state_37369__$1;
(statearr_37449_37490[(2)] = inst_37360);

(statearr_37449_37490[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (16))){
var state_37369__$1 = state_37369;
var statearr_37450_37491 = state_37369__$1;
(statearr_37450_37491[(2)] = null);

(statearr_37450_37491[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (10))){
var inst_37329 = (state_37369[(7)]);
var inst_37333 = fluree.db.util.core.exception_QMARK_(inst_37329);
var state_37369__$1 = state_37369;
if(inst_37333){
var statearr_37451_37492 = state_37369__$1;
(statearr_37451_37492[(1)] = (12));

} else {
var statearr_37452_37493 = state_37369__$1;
(statearr_37452_37493[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (18))){
var inst_37318 = (state_37369[(9)]);
var inst_37344 = (inst_37318.cljs$core$IFn$_invoke$arity$0 ? inst_37318.cljs$core$IFn$_invoke$arity$0() : inst_37318.call(null));
var inst_37345 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_37346 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_37347 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_37348 = cljs.core.PersistentHashMap.fromArrays(inst_37346,inst_37347);
var inst_37349 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37345,inst_37348);
var state_37369__$1 = (function (){var statearr_37453 = state_37369;
(statearr_37453[(14)] = inst_37344);

return statearr_37453;
})();
var statearr_37454_37494 = state_37369__$1;
(statearr_37454_37494[(2)] = inst_37349);

(statearr_37454_37494[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37370 === (8))){
var inst_37329 = (state_37369[(7)]);
var inst_37329__$1 = (state_37369[(2)]);
var inst_37330 = (inst_37329__$1 == null);
var state_37369__$1 = (function (){var statearr_37455 = state_37369;
(statearr_37455[(7)] = inst_37329__$1);

return statearr_37455;
})();
if(cljs.core.truth_(inst_37330)){
var statearr_37456_37495 = state_37369__$1;
(statearr_37456_37495[(1)] = (9));

} else {
var statearr_37457_37496 = state_37369__$1;
(statearr_37457_37496[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0 = (function (){
var statearr_37458 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37458[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__);

(statearr_37458[(1)] = (1));

return statearr_37458;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1 = (function (state_37369){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37369);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37459){var ex__13886__auto__ = e37459;
var statearr_37460_37497 = state_37369;
(statearr_37460_37497[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37369[(4)]))){
var statearr_37461_37498 = state_37369;
(statearr_37461_37498[(1)] = cljs.core.first((state_37369[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37499 = state_37369;
state_37369 = G__37499;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = function(state_37369){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1.call(this,state_37369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37462 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37462[(6)] = c__13957__auto__);

return statearr_37462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__37500 = select;
var map__37500__$1 = cljs.core.__destructure_map(map__37500);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37500__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37500__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37500__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4160__auto__ = as;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__37503 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37503,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37503,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37503,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__37501_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__37501_SHARP_,compare_idx));
}):(function (p1__37502_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__37502_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__37508 = arguments.length;
switch (G__37508) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__37509,p__37510,group_limit,opts){
var map__37511 = p__37509;
var map__37511__$1 = cljs.core.__destructure_map(map__37511);
var res = map__37511__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37511__$1,cljs.core.cst$kw$vars);
var map__37512 = p__37510;
var map__37512__$1 = cljs.core.__destructure_map(map__37512);
var select_spec = map__37512__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37512__$1,cljs.core.cst$kw$groupBy);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37646){
var state_val_37647 = (state_37646[(1)]);
if((state_val_37647 === (7))){
var inst_37519 = (state_37646[(7)]);
var state_37646__$1 = state_37646;
var statearr_37648_37745 = state_37646__$1;
(statearr_37648_37745[(2)] = inst_37519);

(statearr_37648_37745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (20))){
var inst_37555 = (state_37646[(8)]);
var inst_37558 = (state_37646[(9)]);
var inst_37554 = (state_37646[(2)]);
var inst_37555__$1 = cljs.core.__destructure_map(inst_37554);
var inst_37556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37555__$1,cljs.core.cst$kw$headers);
var inst_37557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37555__$1,cljs.core.cst$kw$tuples);
var inst_37558__$1 = offset;
var state_37646__$1 = (function (){var statearr_37649 = state_37646;
(statearr_37649[(8)] = inst_37555__$1);

(statearr_37649[(10)] = inst_37556);

(statearr_37649[(11)] = inst_37557);

(statearr_37649[(9)] = inst_37558__$1);

return statearr_37649;
})();
if(cljs.core.truth_(inst_37558__$1)){
var statearr_37650_37746 = state_37646__$1;
(statearr_37650_37746[(1)] = (21));

} else {
var statearr_37651_37747 = state_37646__$1;
(statearr_37651_37747[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (27))){
var inst_37572 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_37646__$1 = state_37646;
var statearr_37652_37748 = state_37646__$1;
(statearr_37652_37748[(2)] = inst_37572);

(statearr_37652_37748[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (1))){
var state_37646__$1 = state_37646;
var statearr_37653_37749 = state_37646__$1;
(statearr_37653_37749[(2)] = null);

(statearr_37653_37749[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (24))){
var state_37646__$1 = state_37646;
var statearr_37654_37750 = state_37646__$1;
(statearr_37654_37750[(2)] = offset);

(statearr_37654_37750[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (55))){
var inst_37631 = (state_37646[(12)]);
var state_37646__$1 = state_37646;
var statearr_37655_37751 = state_37646__$1;
(statearr_37655_37751[(2)] = inst_37631);

(statearr_37655_37751[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (39))){
var inst_37567 = (state_37646[(13)]);
var inst_37599 = (state_37646[(14)]);
var inst_37601 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_37567);
var inst_37602 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37599,inst_37601);
var state_37646__$1 = state_37646;
var statearr_37656_37752 = state_37646__$1;
(statearr_37656_37752[(2)] = inst_37602);

(statearr_37656_37752[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (46))){
var inst_37611 = (state_37646[(15)]);
var state_37646__$1 = state_37646;
var statearr_37657_37753 = state_37646__$1;
(statearr_37657_37753[(2)] = inst_37611);

(statearr_37657_37753[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (4))){
var inst_37513 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
var statearr_37658_37754 = state_37646__$1;
(statearr_37658_37754[(2)] = inst_37513);

(statearr_37658_37754[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (54))){
var inst_37575 = (state_37646[(16)]);
var inst_37631 = (state_37646[(12)]);
var inst_37570 = (state_37646[(17)]);
var inst_37633 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_37575,inst_37570,db,fuel,max_fuel,opts,(8),inst_37631);
var state_37646__$1 = state_37646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37646__$1,(57),inst_37633);
} else {
if((state_val_37647 === (15))){
var inst_37540 = (state_37646[(18)]);
var inst_37542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37543 = [inst_37540];
var inst_37544 = (new cljs.core.PersistentVector(null,1,(5),inst_37542,inst_37543,null));
var state_37646__$1 = state_37646;
var statearr_37659_37755 = state_37646__$1;
(statearr_37659_37755[(2)] = inst_37544);

(statearr_37659_37755[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (48))){
var inst_37556 = (state_37646[(10)]);
var inst_37557 = (state_37646[(11)]);
var inst_37622 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_37556,orderBy,inst_37557);
var state_37646__$1 = state_37646;
var statearr_37660_37756 = state_37646__$1;
(statearr_37660_37756[(2)] = inst_37622);

(statearr_37660_37756[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (50))){
var inst_37625 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37661 = state_37646;
(statearr_37661[(19)] = inst_37625);

return statearr_37661;
})();
var statearr_37662_37757 = state_37646__$1;
(statearr_37662_37757[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (21))){
var inst_37560 = cljs.core.not(groupBy);
var state_37646__$1 = state_37646;
var statearr_37664_37758 = state_37646__$1;
(statearr_37664_37758[(2)] = inst_37560);

(statearr_37664_37758[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (31))){
var inst_37581 = (state_37646[(20)]);
var state_37646__$1 = state_37646;
var statearr_37665_37759 = state_37646__$1;
(statearr_37665_37759[(2)] = inst_37581);

(statearr_37665_37759[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (32))){
var inst_37587 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37666 = state_37646;
(statearr_37666[(21)] = inst_37587);

return statearr_37666;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37667_37760 = state_37646__$1;
(statearr_37667_37760[(1)] = (33));

} else {
var statearr_37668_37761 = state_37646__$1;
(statearr_37668_37761[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (40))){
var inst_37599 = (state_37646[(14)]);
var state_37646__$1 = state_37646;
var statearr_37669_37762 = state_37646__$1;
(statearr_37669_37762[(2)] = inst_37599);

(statearr_37669_37762[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (56))){
var inst_37639 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
var statearr_37670_37763 = state_37646__$1;
(statearr_37670_37763[(2)] = inst_37639);

(statearr_37670_37763[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (33))){
var inst_37587 = (state_37646[(21)]);
var inst_37589 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_37590 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37587,inst_37589);
var state_37646__$1 = state_37646;
var statearr_37671_37764 = state_37646__$1;
(statearr_37671_37764[(2)] = inst_37590);

(statearr_37671_37764[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (13))){
var inst_37529 = (state_37646[(22)]);
var state_37646__$1 = state_37646;
var statearr_37672_37765 = state_37646__$1;
(statearr_37672_37765[(2)] = inst_37529);

(statearr_37672_37765[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (22))){
var inst_37558 = (state_37646[(9)]);
var state_37646__$1 = state_37646;
var statearr_37673_37766 = state_37646__$1;
(statearr_37673_37766[(2)] = inst_37558);

(statearr_37673_37766[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (36))){
var inst_37593 = (state_37646[(23)]);
var inst_37595 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_37596 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37593,inst_37595);
var state_37646__$1 = state_37646;
var statearr_37674_37767 = state_37646__$1;
(statearr_37674_37767[(2)] = inst_37596);

(statearr_37674_37767[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (41))){
var inst_37605 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37675 = state_37646;
(statearr_37675[(24)] = inst_37605);

return statearr_37675;
})();
if(cljs.core.truth_(group_limit)){
var statearr_37676_37768 = state_37646__$1;
(statearr_37676_37768[(1)] = (42));

} else {
var statearr_37677_37769 = state_37646__$1;
(statearr_37677_37769[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (43))){
var inst_37605 = (state_37646[(24)]);
var state_37646__$1 = state_37646;
var statearr_37678_37770 = state_37646__$1;
(statearr_37678_37770[(2)] = inst_37605);

(statearr_37678_37770[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (29))){
var inst_37556 = (state_37646[(10)]);
var inst_37570 = (state_37646[(17)]);
var inst_37575 = (state_37646[(2)]);
var inst_37577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37578 = fluree.db.query.fql.select_tuples_fn(inst_37556,vars,select);
var inst_37579 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_37578);
var inst_37580 = [inst_37579];
var inst_37581 = (new cljs.core.PersistentVector(null,1,(5),inst_37577,inst_37580,null));
var state_37646__$1 = (function (){var statearr_37679 = state_37646;
(statearr_37679[(16)] = inst_37575);

(statearr_37679[(20)] = inst_37581);

return statearr_37679;
})();
if(cljs.core.truth_(inst_37570)){
var statearr_37680_37771 = state_37646__$1;
(statearr_37680_37771[(1)] = (30));

} else {
var statearr_37681_37772 = state_37646__$1;
(statearr_37681_37772[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (44))){
var inst_37611 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37682 = state_37646;
(statearr_37682[(15)] = inst_37611);

return statearr_37682;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_37683_37773 = state_37646__$1;
(statearr_37683_37773[(1)] = (45));

} else {
var statearr_37684_37774 = state_37646__$1;
(statearr_37684_37774[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (6))){
var inst_37521 = cljs.core.count(select);
var inst_37522 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_37521);
var state_37646__$1 = state_37646;
var statearr_37685_37775 = state_37646__$1;
(statearr_37685_37775[(2)] = inst_37522);

(statearr_37685_37775[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (28))){
var state_37646__$1 = state_37646;
var statearr_37686_37776 = state_37646__$1;
(statearr_37686_37776[(2)] = null);

(statearr_37686_37776[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (51))){
var inst_37625 = (state_37646[(19)]);
var inst_37619 = (state_37646[(25)]);
var inst_37627 = cljs.core.PersistentVector.EMPTY;
var inst_37628 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_37627,inst_37619,inst_37625);
var state_37646__$1 = state_37646;
var statearr_37687_37777 = state_37646__$1;
(statearr_37687_37777[(2)] = inst_37628);

(statearr_37687_37777[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (25))){
var state_37646__$1 = state_37646;
var statearr_37688_37778 = state_37646__$1;
(statearr_37688_37778[(2)] = null);

(statearr_37688_37778[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (34))){
var inst_37587 = (state_37646[(21)]);
var state_37646__$1 = state_37646;
var statearr_37689_37779 = state_37646__$1;
(statearr_37689_37779[(2)] = inst_37587);

(statearr_37689_37779[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (17))){
var inst_37547 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
var statearr_37690_37780 = state_37646__$1;
(statearr_37690_37780[(2)] = inst_37547);

(statearr_37690_37780[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (3))){
var inst_37644 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37646__$1,inst_37644);
} else {
if((state_val_37647 === (12))){
var inst_37529 = (state_37646[(22)]);
var inst_37531 = cljs.core.first(select);
var inst_37532 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37531);
var inst_37533 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37532);
var inst_37534 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_37533,(1));
var inst_37535 = [inst_37534];
var inst_37536 = [inst_37529];
var inst_37537 = cljs.core.PersistentHashMap.fromArrays(inst_37535,inst_37536);
var state_37646__$1 = state_37646;
var statearr_37691_37781 = state_37646__$1;
(statearr_37691_37781[(2)] = inst_37537);

(statearr_37691_37781[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (2))){
var inst_37519 = (state_37646[(7)]);
var _ = (function (){var statearr_37692 = state_37646;
(statearr_37692[(4)] = cljs.core.cons((5),(state_37646[(4)])));

return statearr_37692;
})();
var inst_37519__$1 = aggregates;
var state_37646__$1 = (function (){var statearr_37693 = state_37646;
(statearr_37693[(7)] = inst_37519__$1);

return statearr_37693;
})();
if(cljs.core.truth_(inst_37519__$1)){
var statearr_37694_37782 = state_37646__$1;
(statearr_37694_37782[(1)] = (6));

} else {
var statearr_37695_37783 = state_37646__$1;
(statearr_37695_37783[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (23))){
var inst_37563 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
if(cljs.core.truth_(inst_37563)){
var statearr_37696_37784 = state_37646__$1;
(statearr_37696_37784[(1)] = (24));

} else {
var statearr_37697_37785 = state_37646__$1;
(statearr_37697_37785[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (47))){
var inst_37618 = (state_37646[(2)]);
var inst_37619 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_37618);
var state_37646__$1 = (function (){var statearr_37698 = state_37646;
(statearr_37698[(25)] = inst_37619);

return statearr_37698;
})();
if(cljs.core.truth_(orderBy)){
var statearr_37699_37786 = state_37646__$1;
(statearr_37699_37786[(1)] = (48));

} else {
var statearr_37700_37787 = state_37646__$1;
(statearr_37700_37787[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (35))){
var inst_37593 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37701 = state_37646;
(statearr_37701[(23)] = inst_37593);

return statearr_37701;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37702_37788 = state_37646__$1;
(statearr_37702_37788[(1)] = (36));

} else {
var statearr_37703_37789 = state_37646__$1;
(statearr_37703_37789[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (19))){
var state_37646__$1 = state_37646;
var statearr_37704_37790 = state_37646__$1;
(statearr_37704_37790[(2)] = res);

(statearr_37704_37790[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (57))){
var inst_37635 = (state_37646[(2)]);
var inst_37636 = fluree.db.util.async.throw_err(inst_37635);
var state_37646__$1 = state_37646;
var statearr_37705_37791 = state_37646__$1;
(statearr_37705_37791[(2)] = inst_37636);

(statearr_37705_37791[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (11))){
var inst_37641 = (state_37646[(2)]);
var _ = (function (){var statearr_37707 = state_37646;
(statearr_37707[(4)] = cljs.core.rest((state_37646[(4)])));

return statearr_37707;
})();
var state_37646__$1 = state_37646;
var statearr_37708_37792 = state_37646__$1;
(statearr_37708_37792[(2)] = inst_37641);

(statearr_37708_37792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (9))){
var inst_37527 = cljs.core.first(aggregates);
var inst_37528 = fluree.db.query.analytical.calculate_aggregate(res,inst_37527);
var inst_37529 = cljs.core.second(inst_37528);
var state_37646__$1 = (function (){var statearr_37709 = state_37646;
(statearr_37709[(22)] = inst_37529);

return statearr_37709;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_37710_37793 = state_37646__$1;
(statearr_37710_37793[(1)] = (12));

} else {
var statearr_37711_37794 = state_37646__$1;
(statearr_37711_37794[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (5))){
var _ = (function (){var statearr_37712 = state_37646;
(statearr_37712[(4)] = cljs.core.rest((state_37646[(4)])));

return statearr_37712;
})();
var state_37646__$1 = state_37646;
var ex37706 = (state_37646__$1[(2)]);
var statearr_37713_37795 = state_37646__$1;
(statearr_37713_37795[(5)] = ex37706);


if((ex37706 instanceof Error)){
var statearr_37714_37796 = state_37646__$1;
(statearr_37714_37796[(1)] = (4));

(statearr_37714_37796[(5)] = null);

} else {
throw ex37706;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (14))){
var inst_37540 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37715 = state_37646;
(statearr_37715[(18)] = inst_37540);

return statearr_37715;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_37716_37797 = state_37646__$1;
(statearr_37716_37797[(1)] = (15));

} else {
var statearr_37717_37798 = state_37646__$1;
(statearr_37717_37798[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (45))){
var inst_37555 = (state_37646[(8)]);
var inst_37575 = (state_37646[(16)]);
var inst_37556 = (state_37646[(10)]);
var inst_37557 = (state_37646[(11)]);
var inst_37567 = (state_37646[(13)]);
var inst_37570 = (state_37646[(17)]);
var inst_37611 = (state_37646[(15)]);
var inst_37613 = (function (){var map__37549 = inst_37555;
var headers = inst_37556;
var tuples = inst_37557;
var offset_SINGLEQUOTE_ = inst_37567;
var single_result_QMARK_ = inst_37570;
var pp_keys = inst_37575;
var G__37576 = inst_37611;
return (function (p1__37506_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__37506_SHARP_);
});
})();
var inst_37614 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_37613);
var inst_37615 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37611,inst_37614);
var state_37646__$1 = state_37646;
var statearr_37718_37799 = state_37646__$1;
(statearr_37718_37799[(2)] = inst_37615);

(statearr_37718_37799[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (53))){
var inst_37631 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37719 = state_37646;
(statearr_37719[(12)] = inst_37631);

return statearr_37719;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_37720_37800 = state_37646__$1;
(statearr_37720_37800[(1)] = (54));

} else {
var statearr_37721_37801 = state_37646__$1;
(statearr_37721_37801[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (26))){
var inst_37567 = (state_37646[(2)]);
var inst_37568 = cljs.core.not(prettyPrint);
var inst_37569 = cljs.core.not(inVector_QMARK_);
var inst_37570 = ((inst_37568) && (inst_37569));
var state_37646__$1 = (function (){var statearr_37722 = state_37646;
(statearr_37722[(13)] = inst_37567);

(statearr_37722[(17)] = inst_37570);

return statearr_37722;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_37723_37802 = state_37646__$1;
(statearr_37723_37802[(1)] = (27));

} else {
var statearr_37724_37803 = state_37646__$1;
(statearr_37724_37803[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (16))){
var inst_37540 = (state_37646[(18)]);
var state_37646__$1 = state_37646;
var statearr_37725_37804 = state_37646__$1;
(statearr_37725_37804[(2)] = inst_37540);

(statearr_37725_37804[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (38))){
var inst_37567 = (state_37646[(13)]);
var inst_37599 = (state_37646[(2)]);
var state_37646__$1 = (function (){var statearr_37726 = state_37646;
(statearr_37726[(14)] = inst_37599);

return statearr_37726;
})();
if(cljs.core.truth_(inst_37567)){
var statearr_37727_37805 = state_37646__$1;
(statearr_37727_37805[(1)] = (39));

} else {
var statearr_37728_37806 = state_37646__$1;
(statearr_37728_37806[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (30))){
var inst_37581 = (state_37646[(20)]);
var inst_37583 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_37584 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37581,inst_37583);
var state_37646__$1 = state_37646;
var statearr_37729_37807 = state_37646__$1;
(statearr_37729_37807[(2)] = inst_37584);

(statearr_37729_37807[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (10))){
var state_37646__$1 = state_37646;
if(cljs.core.truth_(aggregates)){
var statearr_37730_37808 = state_37646__$1;
(statearr_37730_37808[(1)] = (18));

} else {
var statearr_37731_37809 = state_37646__$1;
(statearr_37731_37809[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (18))){
var inst_37551 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_37646__$1 = state_37646;
var statearr_37732_37810 = state_37646__$1;
(statearr_37732_37810[(2)] = inst_37551);

(statearr_37732_37810[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (52))){
var inst_37625 = (state_37646[(19)]);
var state_37646__$1 = state_37646;
var statearr_37733_37811 = state_37646__$1;
(statearr_37733_37811[(2)] = inst_37625);

(statearr_37733_37811[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (42))){
var inst_37605 = (state_37646[(24)]);
var inst_37607 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_37608 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37605,inst_37607);
var state_37646__$1 = state_37646;
var statearr_37734_37812 = state_37646__$1;
(statearr_37734_37812[(2)] = inst_37608);

(statearr_37734_37812[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (37))){
var inst_37593 = (state_37646[(23)]);
var state_37646__$1 = state_37646;
var statearr_37735_37813 = state_37646__$1;
(statearr_37735_37813[(2)] = inst_37593);

(statearr_37735_37813[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (8))){
var inst_37525 = (state_37646[(2)]);
var state_37646__$1 = state_37646;
if(cljs.core.truth_(inst_37525)){
var statearr_37736_37814 = state_37646__$1;
(statearr_37736_37814[(1)] = (9));

} else {
var statearr_37737_37815 = state_37646__$1;
(statearr_37737_37815[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37647 === (49))){
var inst_37557 = (state_37646[(11)]);
var state_37646__$1 = state_37646;
var statearr_37738_37816 = state_37646__$1;
(statearr_37738_37816[(2)] = inst_37557);

(statearr_37738_37816[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_37739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37739[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_37739[(1)] = (1));

return statearr_37739;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_37646){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37646);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37740){var ex__13886__auto__ = e37740;
var statearr_37741_37817 = state_37646;
(statearr_37741_37817[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37646[(4)]))){
var statearr_37742_37818 = state_37646;
(statearr_37742_37818[(1)] = cljs.core.first((state_37646[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37819 = state_37646;
state_37646 = G__37819;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_37646){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_37646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37743 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37743[(6)] = c__13957__auto__);

return statearr_37743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__37822,groupBy){
var map__37823 = p__37822;
var map__37823__$1 = cljs.core.__destructure_map(map__37823);
var res = map__37823__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37823__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37823__$1,cljs.core.cst$kw$tuples);
var vec__37824 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37824,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37824,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37820_SHARP_){
return fluree.db.util.core.index_of(headers,p1__37820_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37821_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__37821_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__37827 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37827,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37827,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__37830,p__37831,opts){
var map__37832 = p__37830;
var map__37832__$1 = cljs.core.__destructure_map(map__37832);
var res = map__37832__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37832__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37832__$1,cljs.core.cst$kw$vars);
var map__37833 = p__37831;
var map__37833__$1 = cljs.core.__destructure_map(map__37833);
var select_spec = map__37833__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37833__$1,cljs.core.cst$kw$offset);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38048){
var state_val_38049 = (state_38048[(1)]);
if((state_val_38049 === (65))){
var inst_37912 = (state_38048[(7)]);
var inst_37964 = (state_38048[(8)]);
var inst_37903 = (state_38048[(9)]);
var inst_37994 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37903,inst_37912,inst_37964);
var state_38048__$1 = state_38048;
var statearr_38050_38179 = state_38048__$1;
(statearr_38050_38179[(2)] = inst_37994);

(statearr_38050_38179[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (70))){
var inst_38019 = (state_38048[(10)]);
var inst_38018 = (state_38048[(2)]);
var inst_38019__$1 = fluree.db.util.async.throw_err(inst_38018);
var inst_38020 = cljs.core.coll_QMARK_(inst_38019__$1);
var inst_38021 = (!(inst_38020));
var state_38048__$1 = (function (){var statearr_38051 = state_38048;
(statearr_38051[(10)] = inst_38019__$1);

return statearr_38051;
})();
if(inst_38021){
var statearr_38052_38180 = state_38048__$1;
(statearr_38052_38180[(1)] = (71));

} else {
var statearr_38053_38181 = state_38048__$1;
(statearr_38053_38181[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (62))){
var state_38048__$1 = state_38048;
var statearr_38054_38182 = state_38048__$1;
(statearr_38054_38182[(2)] = null);

(statearr_38054_38182[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (74))){
var inst_38019 = (state_38048[(10)]);
var inst_38024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38025 = [inst_38019];
var inst_38026 = (new cljs.core.PersistentVector(null,1,(5),inst_38024,inst_38025,null));
var state_38048__$1 = state_38048;
var statearr_38055_38183 = state_38048__$1;
(statearr_38055_38183[(2)] = inst_38026);

(statearr_38055_38183[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (7))){
var state_38048__$1 = state_38048;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_38056_38184 = state_38048__$1;
(statearr_38056_38184[(1)] = (67));

} else {
var statearr_38057_38185 = state_38048__$1;
(statearr_38057_38185[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (59))){
var state_38048__$1 = state_38048;
var statearr_38058_38186 = state_38048__$1;
(statearr_38058_38186[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (20))){
var state_38048__$1 = state_38048;
var statearr_38060_38187 = state_38048__$1;
(statearr_38060_38187[(2)] = (0));

(statearr_38060_38187[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (72))){
var state_38048__$1 = state_38048;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_38061_38188 = state_38048__$1;
(statearr_38061_38188[(1)] = (77));

} else {
var statearr_38062_38189 = state_38048__$1;
(statearr_38062_38189[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (58))){
var inst_37902 = (state_38048[(11)]);
var inst_37976 = (inst_37902 - (1));
var state_38048__$1 = state_38048;
var statearr_38063_38190 = state_38048__$1;
(statearr_38063_38190[(2)] = inst_37976);

(statearr_38063_38190[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (60))){
var inst_37986 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38064_38191 = state_38048__$1;
(statearr_38064_38191[(2)] = inst_37986);

(statearr_38064_38191[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (27))){
var inst_37901 = (state_38048[(12)]);
var inst_37925 = (inst_37901 < (1));
var state_38048__$1 = state_38048;
var statearr_38065_38192 = state_38048__$1;
(statearr_38065_38192[(2)] = inst_37925);

(statearr_38065_38192[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (1))){
var state_38048__$1 = state_38048;
var statearr_38066_38193 = state_38048__$1;
(statearr_38066_38193[(2)] = null);

(statearr_38066_38193[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (69))){
var inst_38015 = (state_38048[(2)]);
var inst_38016 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_38015,opts);
var state_38048__$1 = state_38048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38048__$1,(70),inst_38016);
} else {
if((state_val_38049 === (24))){
var inst_37903 = (state_38048[(9)]);
var state_38048__$1 = state_38048;
var statearr_38067_38194 = state_38048__$1;
(statearr_38067_38194[(2)] = inst_37903);

(statearr_38067_38194[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (55))){
var state_38048__$1 = state_38048;
var statearr_38068_38195 = state_38048__$1;
(statearr_38068_38195[(2)] = (0));

(statearr_38068_38195[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (39))){
var inst_37920 = (state_38048[(13)]);
var inst_37943 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_37944 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_37945 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_37920,inst_37943,inst_37944);
var state_38048__$1 = state_38048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38048__$1,(42),inst_37945);
} else {
if((state_val_38049 === (46))){
var inst_37901 = (state_38048[(12)]);
var inst_37956 = ((0) < inst_37901);
var state_38048__$1 = state_38048;
var statearr_38069_38196 = state_38048__$1;
(statearr_38069_38196[(2)] = inst_37956);

(statearr_38069_38196[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (4))){
var inst_37834 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38070_38197 = state_38048__$1;
(statearr_38070_38197[(2)] = inst_37834);

(statearr_38070_38197[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (77))){
var inst_38019 = (state_38048[(10)]);
var inst_38032 = cljs.core.first(inst_38019);
var state_38048__$1 = state_38048;
var statearr_38071_38198 = state_38048__$1;
(statearr_38071_38198[(2)] = inst_38032);

(statearr_38071_38198[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (54))){
var inst_37902 = (state_38048[(11)]);
var inst_37971 = (state_38048[(2)]);
var inst_37972 = (inst_37902 <= (0));
var state_38048__$1 = (function (){var statearr_38072 = state_38048;
(statearr_38072[(14)] = inst_37971);

return statearr_38072;
})();
if(cljs.core.truth_(inst_37972)){
var statearr_38073_38199 = state_38048__$1;
(statearr_38073_38199[(1)] = (55));

} else {
var statearr_38074_38200 = state_38048__$1;
(statearr_38074_38200[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (15))){
var inst_37852 = (state_38048[(15)]);
var inst_37860 = (state_38048[(2)]);
var inst_37861 = fluree.db.util.async.throw_err(inst_37860);
var inst_37862 = [inst_37852];
var inst_37863 = [inst_37861];
var inst_37864 = cljs.core.PersistentHashMap.fromArrays(inst_37862,inst_37863);
var state_38048__$1 = state_38048;
var statearr_38075_38201 = state_38048__$1;
(statearr_38075_38201[(2)] = inst_37864);

(statearr_38075_38201[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (48))){
var inst_37959 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
if(cljs.core.truth_(inst_37959)){
var statearr_38076_38202 = state_38048__$1;
(statearr_38076_38202[(1)] = (49));

} else {
var statearr_38077_38203 = state_38048__$1;
(statearr_38077_38203[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (50))){
var inst_37954 = (state_38048[(16)]);
var state_38048__$1 = state_38048;
var statearr_38078_38204 = state_38048__$1;
(statearr_38078_38204[(2)] = inst_37954);

(statearr_38078_38204[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (75))){
var inst_38019 = (state_38048[(10)]);
var state_38048__$1 = state_38048;
var statearr_38079_38205 = state_38048__$1;
(statearr_38079_38205[(2)] = inst_38019);

(statearr_38079_38205[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (21))){
var inst_37892 = (state_38048[(17)]);
var inst_37880 = (state_38048[(18)]);
var inst_37884 = (state_38048[(19)]);
var inst_37897 = (state_38048[(2)]);
var inst_37898 = cljs.core.PersistentHashMap.EMPTY;
var inst_37899 = inst_37880;
var inst_37900 = inst_37884;
var inst_37901 = inst_37892;
var inst_37902 = inst_37897;
var inst_37903 = inst_37898;
var state_38048__$1 = (function (){var statearr_38080 = state_38048;
(statearr_38080[(20)] = inst_37900);

(statearr_38080[(11)] = inst_37902);

(statearr_38080[(12)] = inst_37901);

(statearr_38080[(21)] = inst_37899);

(statearr_38080[(9)] = inst_37903);

return statearr_38080;
})();
var statearr_38081_38206 = state_38048__$1;
(statearr_38081_38206[(2)] = null);

(statearr_38081_38206[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (31))){
var inst_37902 = (state_38048[(11)]);
var inst_37917 = (state_38048[(22)]);
var inst_37931 = (inst_37902 >= inst_37917);
var state_38048__$1 = state_38048;
if(cljs.core.truth_(inst_37931)){
var statearr_38082_38207 = state_38048__$1;
(statearr_38082_38207[(1)] = (33));

} else {
var statearr_38083_38208 = state_38048__$1;
(statearr_38083_38208[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (32))){
var inst_38004 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38084_38209 = state_38048__$1;
(statearr_38084_38209[(2)] = inst_38004);

(statearr_38084_38209[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (40))){
var state_38048__$1 = state_38048;
var statearr_38085_38210 = state_38048__$1;
(statearr_38085_38210[(2)] = null);

(statearr_38085_38210[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (56))){
var state_38048__$1 = state_38048;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_38086_38211 = state_38048__$1;
(statearr_38086_38211[(1)] = (58));

} else {
var statearr_38087_38212 = state_38048__$1;
(statearr_38087_38212[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (33))){
var state_38048__$1 = state_38048;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_38088_38213 = state_38048__$1;
(statearr_38088_38213[(1)] = (36));

} else {
var statearr_38089_38214 = state_38048__$1;
(statearr_38089_38214[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (13))){
var inst_37880 = (state_38048[(18)]);
var inst_37849 = (state_38048[(23)]);
var inst_37884 = (state_38048[(19)]);
var inst_37880__$1 = cljs.core.keys(inst_37849);
var inst_37881 = cljs.core.seq(inst_37880__$1);
var inst_37882 = cljs.core.first(inst_37881);
var inst_37883 = cljs.core.next(inst_37881);
var inst_37884__$1 = cljs.core.vals(inst_37849);
var inst_37885 = cljs.core.seq(inst_37884__$1);
var inst_37886 = cljs.core.first(inst_37885);
var inst_37887 = cljs.core.next(inst_37885);
var inst_37888 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_38048__$1 = (function (){var statearr_38090 = state_38048;
(statearr_38090[(24)] = inst_37887);

(statearr_38090[(25)] = inst_37886);

(statearr_38090[(26)] = inst_37882);

(statearr_38090[(18)] = inst_37880__$1);

(statearr_38090[(27)] = inst_37883);

(statearr_38090[(19)] = inst_37884__$1);

return statearr_38090;
})();
if(inst_37888){
var statearr_38091_38215 = state_38048__$1;
(statearr_38091_38215[(1)] = (16));

} else {
var statearr_38092_38216 = state_38048__$1;
(statearr_38092_38216[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (22))){
var inst_37900 = (state_38048[(20)]);
var inst_37899 = (state_38048[(21)]);
var inst_37911 = cljs.core.seq(inst_37899);
var inst_37912 = cljs.core.first(inst_37911);
var inst_37913 = cljs.core.next(inst_37911);
var inst_37914 = cljs.core.seq(inst_37900);
var inst_37915 = cljs.core.first(inst_37914);
var inst_37916 = cljs.core.next(inst_37914);
var inst_37917 = cljs.core.count(inst_37915);
var inst_37918 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_37919 = [headers,vars,inst_37915];
var inst_37920 = cljs.core.PersistentHashMap.fromArrays(inst_37918,inst_37919);
var inst_37921 = (inst_37915 == null);
var state_38048__$1 = (function (){var statearr_38093 = state_38048;
(statearr_38093[(7)] = inst_37912);

(statearr_38093[(13)] = inst_37920);

(statearr_38093[(28)] = inst_37913);

(statearr_38093[(29)] = inst_37916);

(statearr_38093[(22)] = inst_37917);

return statearr_38093;
})();
if(cljs.core.truth_(inst_37921)){
var statearr_38094_38217 = state_38048__$1;
(statearr_38094_38217[(1)] = (24));

} else {
var statearr_38095_38218 = state_38048__$1;
(statearr_38095_38218[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (36))){
var inst_37902 = (state_38048[(11)]);
var inst_37934 = (inst_37902 - (1));
var state_38048__$1 = state_38048;
var statearr_38096_38219 = state_38048__$1;
(statearr_38096_38219[(2)] = inst_37934);

(statearr_38096_38219[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (41))){
var inst_38000 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38097_38220 = state_38048__$1;
(statearr_38097_38220[(2)] = inst_38000);

(statearr_38097_38220[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (43))){
var inst_37902 = (state_38048[(11)]);
var inst_37948 = (state_38048[(30)]);
var inst_37951 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_37902,inst_37948);
var state_38048__$1 = state_38048;
var statearr_38098_38221 = state_38048__$1;
(statearr_38098_38221[(2)] = inst_37951);

(statearr_38098_38221[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (61))){
var inst_37964 = (state_38048[(8)]);
var inst_37902 = (state_38048[(11)]);
var inst_37917 = (state_38048[(22)]);
var inst_37979 = cljs.core.count(inst_37964);
var inst_37980 = (inst_37917 - inst_37979);
var inst_37981 = (inst_37902 - inst_37980);
var state_38048__$1 = state_38048;
var statearr_38099_38222 = state_38048__$1;
(statearr_38099_38222[(2)] = inst_37981);

(statearr_38099_38222[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (29))){
var inst_37928 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
if(cljs.core.truth_(inst_37928)){
var statearr_38100_38223 = state_38048__$1;
(statearr_38100_38223[(1)] = (30));

} else {
var statearr_38101_38224 = state_38048__$1;
(statearr_38101_38224[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (44))){
var inst_37948 = (state_38048[(30)]);
var state_38048__$1 = state_38048;
var statearr_38102_38225 = state_38048__$1;
(statearr_38102_38225[(2)] = inst_37948);

(statearr_38102_38225[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (6))){
var inst_37841 = (state_38048[(31)]);
var inst_37841__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_37843 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_38048__$1 = (function (){var statearr_38103 = state_38048;
(statearr_38103[(31)] = inst_37841__$1);

(statearr_38103[(32)] = inst_37843);

return statearr_38103;
})();
if(cljs.core.truth_(inst_37841__$1)){
var statearr_38104_38226 = state_38048__$1;
(statearr_38104_38226[(1)] = (9));

} else {
var statearr_38105_38227 = state_38048__$1;
(statearr_38105_38227[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (28))){
var inst_37901 = (state_38048[(12)]);
var state_38048__$1 = state_38048;
var statearr_38106_38228 = state_38048__$1;
(statearr_38106_38228[(2)] = inst_37901);

(statearr_38106_38228[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (64))){
var inst_37903 = (state_38048[(9)]);
var state_38048__$1 = state_38048;
var statearr_38107_38229 = state_38048__$1;
(statearr_38107_38229[(2)] = inst_37903);

(statearr_38107_38229[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (51))){
var inst_37901 = (state_38048[(12)]);
var inst_37964 = (state_38048[(2)]);
var inst_37965 = (inst_37901 == null);
var state_38048__$1 = (function (){var statearr_38108 = state_38048;
(statearr_38108[(8)] = inst_37964);

return statearr_38108;
})();
if(cljs.core.truth_(inst_37965)){
var statearr_38109_38230 = state_38048__$1;
(statearr_38109_38230[(1)] = (52));

} else {
var statearr_38110_38231 = state_38048__$1;
(statearr_38110_38231[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (25))){
var inst_37901 = (state_38048[(12)]);
var state_38048__$1 = state_38048;
if(cljs.core.truth_(inst_37901)){
var statearr_38111_38232 = state_38048__$1;
(statearr_38111_38232[(1)] = (27));

} else {
var statearr_38112_38233 = state_38048__$1;
(statearr_38112_38233[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (34))){
var state_38048__$1 = state_38048;
var statearr_38113_38234 = state_38048__$1;
(statearr_38113_38234[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (17))){
var state_38048__$1 = state_38048;
var statearr_38115_38235 = state_38048__$1;
(statearr_38115_38235[(2)] = limit);

(statearr_38115_38235[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (3))){
var inst_38046 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38048__$1,inst_38046);
} else {
if((state_val_38049 === (12))){
var inst_37849 = (state_38048[(23)]);
var inst_37851 = cljs.core.keys(inst_37849);
var inst_37852 = cljs.core.first(inst_37851);
var inst_37853 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_37854 = cljs.core.vals(inst_37849);
var inst_37855 = cljs.core.first(inst_37854);
var inst_37856 = [headers,vars,inst_37855];
var inst_37857 = cljs.core.PersistentHashMap.fromArrays(inst_37853,inst_37856);
var inst_37858 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_37857,select_spec,limit,opts);
var state_38048__$1 = (function (){var statearr_38116 = state_38048;
(statearr_38116[(15)] = inst_37852);

return statearr_38116;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38048__$1,(15),inst_37858);
} else {
if((state_val_38049 === (2))){
var _ = (function (){var statearr_38117 = state_38048;
(statearr_38117[(4)] = cljs.core.cons((5),(state_38048[(4)])));

return statearr_38117;
})();
var state_38048__$1 = state_38048;
if(cljs.core.truth_(groupBy)){
var statearr_38118_38236 = state_38048__$1;
(statearr_38118_38236[(1)] = (6));

} else {
var statearr_38119_38237 = state_38048__$1;
(statearr_38119_38237[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (66))){
var inst_37971 = (state_38048[(14)]);
var inst_37988 = (state_38048[(33)]);
var inst_37913 = (state_38048[(28)]);
var inst_37916 = (state_38048[(29)]);
var inst_37996 = (state_38048[(2)]);
var inst_37899 = inst_37913;
var inst_37900 = inst_37916;
var inst_37901 = inst_37971;
var inst_37902 = inst_37988;
var inst_37903 = inst_37996;
var state_38048__$1 = (function (){var statearr_38120 = state_38048;
(statearr_38120[(20)] = inst_37900);

(statearr_38120[(11)] = inst_37902);

(statearr_38120[(12)] = inst_37901);

(statearr_38120[(21)] = inst_37899);

(statearr_38120[(9)] = inst_37903);

return statearr_38120;
})();
var statearr_38121_38238 = state_38048__$1;
(statearr_38121_38238[(2)] = null);

(statearr_38121_38238[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (23))){
var inst_38008 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38122_38239 = state_38048__$1;
(statearr_38122_38239[(2)] = inst_38008);

(statearr_38122_38239[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (47))){
var inst_37901 = (state_38048[(12)]);
var state_38048__$1 = state_38048;
var statearr_38123_38240 = state_38048__$1;
(statearr_38123_38240[(2)] = inst_37901);

(statearr_38123_38240[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (35))){
var inst_38002 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38124_38241 = state_38048__$1;
(statearr_38124_38241[(2)] = inst_38002);

(statearr_38124_38241[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (82))){
var inst_38037 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38125_38242 = state_38048__$1;
(statearr_38125_38242[(2)] = inst_38037);

(statearr_38125_38242[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (76))){
var inst_38029 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38126_38243 = state_38048__$1;
(statearr_38126_38243[(2)] = inst_38029);

(statearr_38126_38243[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (19))){
var inst_37893 = (state_38048[(34)]);
var state_38048__$1 = state_38048;
var statearr_38127_38244 = state_38048__$1;
(statearr_38127_38244[(2)] = inst_37893);

(statearr_38127_38244[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (57))){
var inst_37964 = (state_38048[(8)]);
var inst_37988 = (state_38048[(2)]);
var inst_37989 = (inst_37964 == null);
var inst_37990 = cljs.core.empty_QMARK_(inst_37964);
var inst_37991 = ((inst_37989) || (inst_37990));
var state_38048__$1 = (function (){var statearr_38128 = state_38048;
(statearr_38128[(33)] = inst_37988);

return statearr_38128;
})();
if(cljs.core.truth_(inst_37991)){
var statearr_38129_38245 = state_38048__$1;
(statearr_38129_38245[(1)] = (64));

} else {
var statearr_38130_38246 = state_38048__$1;
(statearr_38130_38246[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (68))){
var state_38048__$1 = state_38048;
var statearr_38131_38247 = state_38048__$1;
(statearr_38131_38247[(2)] = limit);

(statearr_38131_38247[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (11))){
var inst_37849 = (state_38048[(2)]);
var state_38048__$1 = (function (){var statearr_38133 = state_38048;
(statearr_38133[(23)] = inst_37849);

return statearr_38133;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_38134_38248 = state_38048__$1;
(statearr_38134_38248[(1)] = (12));

} else {
var statearr_38135_38249 = state_38048__$1;
(statearr_38135_38249[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (9))){
var inst_37841 = (state_38048[(31)]);
var inst_37843 = (state_38048[(32)]);
var inst_37845 = cljs.core.sorted_map_by(inst_37841);
var inst_37846 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37845,inst_37843);
var state_38048__$1 = state_38048;
var statearr_38136_38250 = state_38048__$1;
(statearr_38136_38250[(2)] = inst_37846);

(statearr_38136_38250[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (5))){
var _ = (function (){var statearr_38137 = state_38048;
(statearr_38137[(4)] = cljs.core.rest((state_38048[(4)])));

return statearr_38137;
})();
var state_38048__$1 = state_38048;
var ex38132 = (state_38048__$1[(2)]);
var statearr_38138_38251 = state_38048__$1;
(statearr_38138_38251[(5)] = ex38132);


if((ex38132 instanceof Error)){
var statearr_38139_38252 = state_38048__$1;
(statearr_38139_38252[(1)] = (4));

(statearr_38139_38252[(5)] = null);

} else {
throw ex38132;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (14))){
var inst_38010 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38140_38253 = state_38048__$1;
(statearr_38140_38253[(2)] = inst_38010);

(statearr_38140_38253[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (45))){
var inst_37901 = (state_38048[(12)]);
var inst_37954 = (state_38048[(2)]);
var state_38048__$1 = (function (){var statearr_38141 = state_38048;
(statearr_38141[(16)] = inst_37954);

return statearr_38141;
})();
if(cljs.core.truth_(inst_37901)){
var statearr_38142_38254 = state_38048__$1;
(statearr_38142_38254[(1)] = (46));

} else {
var statearr_38143_38255 = state_38048__$1;
(statearr_38143_38255[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (53))){
var inst_37964 = (state_38048[(8)]);
var inst_37901 = (state_38048[(12)]);
var inst_37968 = cljs.core.count(inst_37964);
var inst_37969 = (inst_37901 - inst_37968);
var state_38048__$1 = state_38048;
var statearr_38144_38256 = state_38048__$1;
(statearr_38144_38256[(2)] = inst_37969);

(statearr_38144_38256[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (78))){
var state_38048__$1 = state_38048;
var statearr_38145_38257 = state_38048__$1;
(statearr_38145_38257[(1)] = (80));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (26))){
var inst_38006 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38147_38258 = state_38048__$1;
(statearr_38147_38258[(2)] = inst_38006);

(statearr_38147_38258[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (16))){
var state_38048__$1 = state_38048;
var statearr_38148_38259 = state_38048__$1;
(statearr_38148_38259[(2)] = null);

(statearr_38148_38259[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (81))){
var state_38048__$1 = state_38048;
var statearr_38151_38260 = state_38048__$1;
(statearr_38151_38260[(2)] = null);

(statearr_38151_38260[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (79))){
var inst_38039 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38152_38261 = state_38048__$1;
(statearr_38152_38261[(2)] = inst_38039);

(statearr_38152_38261[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (38))){
var inst_37901 = (state_38048[(12)]);
var inst_37903 = (state_38048[(9)]);
var inst_37913 = (state_38048[(28)]);
var inst_37916 = (state_38048[(29)]);
var inst_37938 = (state_38048[(2)]);
var tmp38149 = inst_37901;
var tmp38150 = inst_37903;
var inst_37899 = inst_37913;
var inst_37900 = inst_37916;
var inst_37901__$1 = tmp38149;
var inst_37902 = inst_37938;
var inst_37903__$1 = tmp38150;
var state_38048__$1 = (function (){var statearr_38153 = state_38048;
(statearr_38153[(20)] = inst_37900);

(statearr_38153[(11)] = inst_37902);

(statearr_38153[(12)] = inst_37901__$1);

(statearr_38153[(21)] = inst_37899);

(statearr_38153[(9)] = inst_37903__$1);

return statearr_38153;
})();
var statearr_38154_38262 = state_38048__$1;
(statearr_38154_38262[(2)] = null);

(statearr_38154_38262[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (30))){
var inst_37903 = (state_38048[(9)]);
var state_38048__$1 = state_38048;
var statearr_38155_38263 = state_38048__$1;
(statearr_38155_38263[(2)] = inst_37903);

(statearr_38155_38263[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (73))){
var inst_38041 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38156_38264 = state_38048__$1;
(statearr_38156_38264[(2)] = inst_38041);

(statearr_38156_38264[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (10))){
var inst_37843 = (state_38048[(32)]);
var state_38048__$1 = state_38048;
var statearr_38157_38265 = state_38048__$1;
(statearr_38157_38265[(2)] = inst_37843);

(statearr_38157_38265[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (18))){
var inst_37893 = (state_38048[(34)]);
var inst_37892 = (state_38048[(2)]);
var inst_37893__$1 = offset;
var state_38048__$1 = (function (){var statearr_38158 = state_38048;
(statearr_38158[(17)] = inst_37892);

(statearr_38158[(34)] = inst_37893__$1);

return statearr_38158;
})();
if(cljs.core.truth_(inst_37893__$1)){
var statearr_38159_38266 = state_38048__$1;
(statearr_38159_38266[(1)] = (19));

} else {
var statearr_38160_38267 = state_38048__$1;
(statearr_38160_38267[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (52))){
var state_38048__$1 = state_38048;
var statearr_38161_38268 = state_38048__$1;
(statearr_38161_38268[(2)] = null);

(statearr_38161_38268[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (67))){
var state_38048__$1 = state_38048;
var statearr_38162_38269 = state_38048__$1;
(statearr_38162_38269[(2)] = (1));

(statearr_38162_38269[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (71))){
var state_38048__$1 = state_38048;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_38163_38270 = state_38048__$1;
(statearr_38163_38270[(1)] = (74));

} else {
var statearr_38164_38271 = state_38048__$1;
(statearr_38164_38271[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (42))){
var inst_37902 = (state_38048[(11)]);
var inst_37947 = (state_38048[(2)]);
var inst_37948 = fluree.db.util.async.throw_err(inst_37947);
var inst_37949 = ((0) < inst_37902);
var state_38048__$1 = (function (){var statearr_38165 = state_38048;
(statearr_38165[(30)] = inst_37948);

return statearr_38165;
})();
if(cljs.core.truth_(inst_37949)){
var statearr_38166_38272 = state_38048__$1;
(statearr_38166_38272[(1)] = (43));

} else {
var statearr_38167_38273 = state_38048__$1;
(statearr_38167_38273[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (80))){
var inst_38019 = (state_38048[(10)]);
var state_38048__$1 = state_38048;
var statearr_38168_38274 = state_38048__$1;
(statearr_38168_38274[(2)] = inst_38019);

(statearr_38168_38274[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (37))){
var inst_37902 = (state_38048[(11)]);
var inst_37917 = (state_38048[(22)]);
var inst_37936 = (inst_37902 - inst_37917);
var state_38048__$1 = state_38048;
var statearr_38169_38275 = state_38048__$1;
(statearr_38169_38275[(2)] = inst_37936);

(statearr_38169_38275[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (63))){
var inst_37984 = (state_38048[(2)]);
var state_38048__$1 = state_38048;
var statearr_38170_38276 = state_38048__$1;
(statearr_38170_38276[(2)] = inst_37984);

(statearr_38170_38276[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (8))){
var inst_38043 = (state_38048[(2)]);
var _ = (function (){var statearr_38171 = state_38048;
(statearr_38171[(4)] = cljs.core.rest((state_38048[(4)])));

return statearr_38171;
})();
var state_38048__$1 = state_38048;
var statearr_38172_38277 = state_38048__$1;
(statearr_38172_38277[(2)] = inst_38043);

(statearr_38172_38277[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38049 === (49))){
var inst_37901 = (state_38048[(12)]);
var inst_37954 = (state_38048[(16)]);
var inst_37961 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_37901,inst_37954);
var state_38048__$1 = state_38048;
var statearr_38173_38278 = state_38048__$1;
(statearr_38173_38278[(2)] = inst_37961);

(statearr_38173_38278[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0 = (function (){
var statearr_38174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38174[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__);

(statearr_38174[(1)] = (1));

return statearr_38174;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1 = (function (state_38048){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38048);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38175){var ex__13886__auto__ = e38175;
var statearr_38176_38279 = state_38048;
(statearr_38176_38279[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38048[(4)]))){
var statearr_38177_38280 = state_38048;
(statearr_38177_38280[(1)] = cljs.core.first((state_38048[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38281 = state_38048;
state_38048 = G__38281;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__ = function(state_38048){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1.call(this,state_38048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38178 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38178[(6)] = c__13957__auto__);

return statearr_38178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__38284,opts){
var map__38285 = p__38284;
var map__38285__$1 = cljs.core.__destructure_map(map__38285);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38285__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38285__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38285__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38285__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4160__auto__ = selectOne;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = select;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__38282_SHARP_){
return cljs.core.contains_QMARK_(p1__38282_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__38283_SHARP_){
return cljs.core.contains_QMARK_(p1__38283_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4160__auto__ = typeof orderBy === 'string';
if(or__4160__auto__){
return or__4160__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__38293 = cljs.core.first(orderBy);
var fexpr__38292 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__38292.cljs$core$IFn$_invoke$arity$1 ? fexpr__38292.cljs$core$IFn$_invoke$arity$1(G__38293) : fexpr__38292.call(null,G__38293));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4160__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (100);
}
})(),(function (){var or__4160__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4160__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4160__auto__ = selectDistinct;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__38294,p__38295){
var map__38296 = p__38294;
var map__38296__$1 = cljs.core.__destructure_map(map__38296);
var query_map = map__38296__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38296__$1,cljs.core.cst$kw$construct);
var map__38297 = p__38295;
var map__38297__$1 = cljs.core.__destructure_map(map__38297);
var where_result = map__38297__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38297__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38297__$1,cljs.core.cst$kw$tuples);
var vec__38298 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38298,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38298,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38298,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38331){
var state_val_38332 = (state_38331[(1)]);
if((state_val_38332 === (7))){
var inst_38310 = (state_38331[(7)]);
var state_38331__$1 = state_38331;
var statearr_38333_38356 = state_38331__$1;
(statearr_38333_38356[(2)] = inst_38310);

(statearr_38333_38356[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (1))){
var state_38331__$1 = state_38331;
var statearr_38334_38357 = state_38331__$1;
(statearr_38334_38357[(2)] = null);

(statearr_38334_38357[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (4))){
var inst_38301 = (state_38331[(2)]);
var state_38331__$1 = state_38331;
var statearr_38335_38358 = state_38331__$1;
(statearr_38335_38358[(2)] = inst_38301);

(statearr_38335_38358[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (13))){
var inst_38320 = (state_38331[(2)]);
var inst_38321 = fluree.db.util.async.throw_err(inst_38320);
var state_38331__$1 = state_38331;
var statearr_38336_38359 = state_38331__$1;
(statearr_38336_38359[(2)] = inst_38321);

(statearr_38336_38359[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (6))){
var inst_38310 = (state_38331[(7)]);
var inst_38309 = (state_38331[(2)]);
var inst_38310__$1 = fluree.db.util.async.throw_err(inst_38309);
var inst_38311 = fluree.db.util.core.exception_QMARK_(inst_38310__$1);
var state_38331__$1 = (function (){var statearr_38337 = state_38331;
(statearr_38337[(7)] = inst_38310__$1);

return statearr_38337;
})();
if(inst_38311){
var statearr_38338_38360 = state_38331__$1;
(statearr_38338_38360[(1)] = (7));

} else {
var statearr_38339_38361 = state_38331__$1;
(statearr_38339_38361[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (3))){
var inst_38329 = (state_38331[(2)]);
var state_38331__$1 = state_38331;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38331__$1,inst_38329);
} else {
if((state_val_38332 === (12))){
var inst_38324 = (state_38331[(2)]);
var state_38331__$1 = state_38331;
var statearr_38340_38362 = state_38331__$1;
(statearr_38340_38362[(2)] = inst_38324);

(statearr_38340_38362[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (2))){
var _ = (function (){var statearr_38341 = state_38331;
(statearr_38341[(4)] = cljs.core.cons((5),(state_38331[(4)])));

return statearr_38341;
})();
var inst_38307 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_38331__$1 = state_38331;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38331__$1,(6),inst_38307);
} else {
if((state_val_38332 === (11))){
var state_38331__$1 = state_38331;
var statearr_38343_38363 = state_38331__$1;
(statearr_38343_38363[(2)] = null);

(statearr_38343_38363[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (9))){
var inst_38326 = (state_38331[(2)]);
var _ = (function (){var statearr_38344 = state_38331;
(statearr_38344[(4)] = cljs.core.rest((state_38331[(4)])));

return statearr_38344;
})();
var state_38331__$1 = state_38331;
var statearr_38345_38364 = state_38331__$1;
(statearr_38345_38364[(2)] = inst_38326);

(statearr_38345_38364[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (5))){
var _ = (function (){var statearr_38346 = state_38331;
(statearr_38346[(4)] = cljs.core.rest((state_38331[(4)])));

return statearr_38346;
})();
var state_38331__$1 = state_38331;
var ex38342 = (state_38331__$1[(2)]);
var statearr_38347_38365 = state_38331__$1;
(statearr_38347_38365[(5)] = ex38342);


if((ex38342 instanceof Error)){
var statearr_38348_38366 = state_38331__$1;
(statearr_38348_38366[(1)] = (4));

(statearr_38348_38366[(5)] = null);

} else {
throw ex38342;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38332 === (10))){
var inst_38310 = (state_38331[(7)]);
var inst_38315 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_38310);
var inst_38316 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_38310);
var inst_38317 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_38315,inst_38316,query_map,opts);
var inst_38318 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_38310,inst_38317,opts);
var state_38331__$1 = state_38331;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38331__$1,(13),inst_38318);
} else {
if((state_val_38332 === (8))){
var state_38331__$1 = state_38331;
var statearr_38349_38367 = state_38331__$1;
(statearr_38349_38367[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0 = (function (){
var statearr_38351 = [null,null,null,null,null,null,null,null];
(statearr_38351[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__);

(statearr_38351[(1)] = (1));

return statearr_38351;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1 = (function (state_38331){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38331);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38352){var ex__13886__auto__ = e38352;
var statearr_38353_38368 = state_38331;
(statearr_38353_38368[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38331[(4)]))){
var statearr_38354_38369 = state_38331;
(statearr_38354_38369[(1)] = cljs.core.first((state_38331[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38370 = state_38331;
state_38331 = G__38370;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__ = function(state_38331){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1.call(this,state_38331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38355 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38355[(6)] = c__13957__auto__);

return statearr_38355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__38371 = query_map;
var map__38371__$1 = cljs.core.__destructure_map(map__38371);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38371__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__38372 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4160__auto__ = offset;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38372,cljs.core.cst$kw$limit,(1));
} else {
return G__38372;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4160__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.truth_((function (){var or__4160__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38723){
var state_val_38724 = (state_38723[(1)]);
if((state_val_38724 === (121))){
var inst_38713 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38713)){
var statearr_38725_38904 = state_38723__$1;
(statearr_38725_38904[(1)] = (122));

} else {
var statearr_38726_38905 = state_38723__$1;
(statearr_38726_38905[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (65))){
var inst_38424 = (state_38723[(7)]);
var inst_38426 = (state_38723[(8)]);
var inst_38549 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_38550 = [inst_38424,inst_38426];
var inst_38551 = cljs.core.PersistentHashMap.fromArrays(inst_38549,inst_38550);
var state_38723__$1 = state_38723;
var statearr_38727_38906 = state_38723__$1;
(statearr_38727_38906[(2)] = inst_38551);

(statearr_38727_38906[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (70))){
var inst_38582 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_38723__$1 = state_38723;
if(inst_38582){
var statearr_38728_38907 = state_38723__$1;
(statearr_38728_38907[(1)] = (77));

} else {
var statearr_38729_38908 = state_38723__$1;
(statearr_38729_38908[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (62))){
var inst_38563 = typeof from === 'string';
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38563)){
var statearr_38730_38909 = state_38723__$1;
(statearr_38730_38909[(1)] = (69));

} else {
var statearr_38731_38910 = state_38723__$1;
(statearr_38731_38910[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (74))){
var inst_38572 = (state_38723[(2)]);
var inst_38573 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_38572);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(75),inst_38573);
} else {
if((state_val_38724 === (110))){
var state_38723__$1 = state_38723;
var statearr_38732_38911 = state_38723__$1;
(statearr_38732_38911[(2)] = null);

(statearr_38732_38911[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (7))){
var inst_38404 = (state_38723[(9)]);
var inst_38404__$1 = selectOne;
var state_38723__$1 = (function (){var statearr_38733 = state_38723;
(statearr_38733[(9)] = inst_38404__$1);

return statearr_38733;
})();
if(cljs.core.truth_(inst_38404__$1)){
var statearr_38734_38912 = state_38723__$1;
(statearr_38734_38912[(1)] = (9));

} else {
var statearr_38735_38913 = state_38723__$1;
(statearr_38735_38913[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (59))){
var state_38723__$1 = state_38723;
var statearr_38736_38914 = state_38723__$1;
(statearr_38736_38914[(2)] = false);

(statearr_38736_38914[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (86))){
var state_38723__$1 = state_38723;
var statearr_38737_38915 = state_38723__$1;
(statearr_38737_38915[(2)] = null);

(statearr_38737_38915[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (20))){
var inst_38468 = (state_38723[(2)]);
var inst_38469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38468,(0),null);
var inst_38470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38468,(1),null);
var inst_38471 = typeof where === 'string';
var state_38723__$1 = (function (){var statearr_38738 = state_38723;
(statearr_38738[(10)] = inst_38469);

(statearr_38738[(11)] = inst_38470);

return statearr_38738;
})();
if(cljs.core.truth_(inst_38471)){
var statearr_38739_38916 = state_38723__$1;
(statearr_38739_38916[(1)] = (30));

} else {
var statearr_38740_38917 = state_38723__$1;
(statearr_38740_38917[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (72))){
var inst_38566 = cljs.core.PersistentHashMap.EMPTY;
var state_38723__$1 = state_38723;
var statearr_38741_38918 = state_38723__$1;
(statearr_38741_38918[(2)] = inst_38566);

(statearr_38741_38918[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (58))){
var inst_38538 = ["_tx",null,"_block",null];
var inst_38539 = (new cljs.core.PersistentArrayMap(null,2,inst_38538,null));
var inst_38540 = (new cljs.core.PersistentHashSet(null,inst_38539,null));
var inst_38541 = (inst_38540.cljs$core$IFn$_invoke$arity$1 ? inst_38540.cljs$core$IFn$_invoke$arity$1(from) : inst_38540.call(null,from));
var state_38723__$1 = state_38723;
var statearr_38742_38919 = state_38723__$1;
(statearr_38742_38919[(2)] = inst_38541);

(statearr_38742_38919[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (60))){
var inst_38544 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38544)){
var statearr_38743_38920 = state_38723__$1;
(statearr_38743_38920[(1)] = (61));

} else {
var statearr_38744_38921 = state_38723__$1;
(statearr_38744_38921[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (27))){
var inst_38453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38454 = [null,null];
var inst_38455 = (new cljs.core.PersistentVector(null,2,(5),inst_38453,inst_38454,null));
var state_38723__$1 = state_38723;
var statearr_38745_38922 = state_38723__$1;
(statearr_38745_38922[(2)] = inst_38455);

(statearr_38745_38922[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (1))){
var state_38723__$1 = state_38723;
var statearr_38746_38923 = state_38723__$1;
(statearr_38746_38923[(2)] = null);

(statearr_38746_38923[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (69))){
var inst_38423 = (state_38723[(12)]);
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38423)){
var statearr_38747_38924 = state_38723__$1;
(statearr_38747_38924[(1)] = (72));

} else {
var statearr_38748_38925 = state_38723__$1;
(statearr_38748_38925[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (101))){
var inst_38632 = (state_38723[(13)]);
var inst_38646 = (state_38723[(2)]);
var inst_38647 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_38632,false);
var state_38723__$1 = (function (){var statearr_38749 = state_38723;
(statearr_38749[(14)] = inst_38646);

return statearr_38749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(102),inst_38647);
} else {
if((state_val_38724 === (24))){
var inst_38423 = (state_38723[(12)]);
var inst_38448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38449 = [inst_38423,"ASC"];
var inst_38450 = (new cljs.core.PersistentVector(null,2,(5),inst_38448,inst_38449,null));
var state_38723__$1 = state_38723;
var statearr_38750_38926 = state_38723__$1;
(statearr_38750_38926[(2)] = inst_38450);

(statearr_38750_38926[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (102))){
var inst_38649 = (state_38723[(2)]);
var inst_38650 = fluree.db.util.async.throw_err(inst_38649);
var state_38723__$1 = state_38723;
var statearr_38751_38927 = state_38723__$1;
(statearr_38751_38927[(2)] = inst_38650);

(statearr_38751_38927[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (55))){
var inst_38521 = (state_38723[(2)]);
var inst_38522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38523 = [from];
var inst_38524 = (new cljs.core.PersistentVector(null,1,(5),inst_38522,inst_38523,null));
var inst_38525 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_38524,inst_38521);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(56),inst_38525);
} else {
if((state_val_38724 === (85))){
var inst_38602 = cljs.core._deref(fuel);
var inst_38603 = (inst_38602 + (1));
var inst_38604 = cljs.core._vreset_BANG_(fuel,inst_38603);
var state_38723__$1 = state_38723;
var statearr_38752_38928 = state_38723__$1;
(statearr_38752_38928[(2)] = inst_38604);

(statearr_38752_38928[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (39))){
var inst_38424 = (state_38723[(7)]);
var state_38723__$1 = state_38723;
var statearr_38753_38929 = state_38723__$1;
(statearr_38753_38929[(2)] = inst_38424);

(statearr_38753_38929[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (88))){
var inst_38620 = from;
var inst_38621 = cljs.core.seq(inst_38620);
var inst_38622 = cljs.core.first(inst_38621);
var inst_38623 = cljs.core.next(inst_38621);
var inst_38624 = cljs.core.PersistentVector.EMPTY;
var inst_38625 = inst_38620;
var inst_38626 = inst_38624;
var state_38723__$1 = (function (){var statearr_38754 = state_38723;
(statearr_38754[(15)] = inst_38623);

(statearr_38754[(16)] = inst_38626);

(statearr_38754[(17)] = inst_38625);

(statearr_38754[(18)] = inst_38622);

return statearr_38754;
})();
var statearr_38755_38930 = state_38723__$1;
(statearr_38755_38930[(2)] = null);

(statearr_38755_38930[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (46))){
var inst_38697 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38756_38931 = state_38723__$1;
(statearr_38756_38931[(2)] = inst_38697);

(statearr_38756_38931[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (4))){
var inst_38391 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38757_38932 = state_38723__$1;
(statearr_38757_38932[(2)] = inst_38391);

(statearr_38757_38932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (77))){
var inst_38585 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(80),inst_38585);
} else {
if((state_val_38724 === (106))){
var inst_38675 = (state_38723[(2)]);
var inst_38676 = fluree.db.util.async.throw_err(inst_38675);
var state_38723__$1 = state_38723;
var statearr_38758_38933 = state_38723__$1;
(statearr_38758_38933[(2)] = inst_38676);

(statearr_38758_38933[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (119))){
var inst_38704 = (state_38723[(19)]);
var inst_38707 = cljs.core.coll_QMARK_(inst_38704);
var inst_38708 = fluree.db.util.core.exception_QMARK_(inst_38704);
var inst_38709 = (!(inst_38708));
var inst_38710 = ((inst_38707) && (inst_38709));
var state_38723__$1 = state_38723;
var statearr_38759_38934 = state_38723__$1;
(statearr_38759_38934[(2)] = inst_38710);

(statearr_38759_38934[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (95))){
var inst_38660 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38760_38935 = state_38723__$1;
(statearr_38760_38935[(2)] = inst_38660);

(statearr_38760_38935[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (54))){
var inst_38424 = (state_38723[(7)]);
var inst_38426 = (state_38723[(8)]);
var inst_38517 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_38518 = [inst_38424,inst_38426];
var inst_38519 = cljs.core.PersistentHashMap.fromArrays(inst_38517,inst_38518);
var state_38723__$1 = state_38723;
var statearr_38761_38936 = state_38723__$1;
(statearr_38761_38936[(2)] = inst_38519);

(statearr_38761_38936[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (92))){
var inst_38423 = (state_38723[(12)]);
var inst_38662 = (state_38723[(2)]);
var inst_38663 = cljs.core.PersistentVector.EMPTY;
var inst_38664 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38663,inst_38662);
var state_38723__$1 = (function (){var statearr_38762 = state_38723;
(statearr_38762[(20)] = inst_38664);

return statearr_38762;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38763_38937 = state_38723__$1;
(statearr_38763_38937[(1)] = (107));

} else {
var statearr_38764_38938 = state_38723__$1;
(statearr_38764_38938[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (104))){
var inst_38626 = (state_38723[(16)]);
var state_38723__$1 = state_38723;
var statearr_38765_38939 = state_38723__$1;
(statearr_38765_38939[(2)] = inst_38626);

(statearr_38765_38939[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (15))){
var inst_38427 = (state_38723[(21)]);
var inst_38425 = (state_38723[(22)]);
var inst_38431 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38427,cljs.core.cst$kw$componentFollow_QMARK_,inst_38425);
var state_38723__$1 = state_38723;
var statearr_38766_38940 = state_38723__$1;
(statearr_38766_38940[(2)] = inst_38431);

(statearr_38766_38940[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (48))){
var inst_38501 = (state_38723[(23)]);
var state_38723__$1 = state_38723;
var statearr_38767_38941 = state_38723__$1;
(statearr_38767_38941[(2)] = inst_38501);

(statearr_38767_38941[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (50))){
var inst_38507 = (state_38723[(24)]);
var inst_38509 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_38510 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38507,inst_38509);
var state_38723__$1 = state_38723;
var statearr_38768_38942 = state_38723__$1;
(statearr_38768_38942[(2)] = inst_38510);

(statearr_38768_38942[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (116))){
var inst_38469 = (state_38723[(10)]);
var inst_38699 = (state_38723[(25)]);
var inst_38424 = (state_38723[(7)]);
var inst_38470 = (state_38723[(11)]);
var inst_38426 = (state_38723[(8)]);
var inst_38701 = fluree.db.query.fql.sort_offset_and_limit_res(inst_38469,inst_38470,inst_38426,inst_38424,inst_38699);
var state_38723__$1 = state_38723;
var statearr_38769_38943 = state_38723__$1;
(statearr_38769_38943[(2)] = inst_38701);

(statearr_38769_38943[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (75))){
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38575 = (state_38723[(2)]);
var inst_38576 = fluree.db.util.async.throw_err(inst_38575);
var inst_38577 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_38436,fuel,max_fuel,inst_38434,inst_38576);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(76),inst_38577);
} else {
if((state_val_38724 === (99))){
var inst_38641 = cljs.core._deref(fuel);
var inst_38642 = (inst_38641 + (1));
var inst_38643 = cljs.core._vreset_BANG_(fuel,inst_38642);
var state_38723__$1 = state_38723;
var statearr_38770_38944 = state_38723__$1;
(statearr_38770_38944[(2)] = inst_38643);

(statearr_38770_38944[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (21))){
var inst_38423 = (state_38723[(12)]);
var inst_38440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38441 = cljs.core.second(inst_38423);
var inst_38442 = cljs.core.first(inst_38423);
var inst_38443 = [inst_38441,inst_38442];
var inst_38444 = (new cljs.core.PersistentVector(null,2,(5),inst_38440,inst_38443,null));
var state_38723__$1 = state_38723;
var statearr_38771_38945 = state_38723__$1;
(statearr_38771_38945[(2)] = inst_38444);

(statearr_38771_38945[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (31))){
var inst_38495 = typeof from === 'string';
var inst_38496 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_38497 = clojure.string.includes_QMARK_(inst_38496,"/");
var inst_38498 = ((inst_38495) && (inst_38497));
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38498)){
var statearr_38772_38946 = state_38723__$1;
(statearr_38772_38946[(1)] = (44));

} else {
var statearr_38773_38947 = state_38723__$1;
(statearr_38773_38947[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (113))){
var inst_38679 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_38680 = ["Invalid 'from' in query:",inst_38679].join('');
var inst_38681 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38682 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38683 = cljs.core.PersistentHashMap.fromArrays(inst_38681,inst_38682);
var inst_38684 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38680,inst_38683);
var state_38723__$1 = state_38723;
var statearr_38774_38948 = state_38723__$1;
(statearr_38774_38948[(2)] = inst_38684);

(statearr_38774_38948[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (32))){
var inst_38469 = (state_38723[(10)]);
var inst_38699 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38775 = state_38723;
(statearr_38775[(25)] = inst_38699);

return statearr_38775;
})();
if(cljs.core.truth_(inst_38469)){
var statearr_38776_38949 = state_38723__$1;
(statearr_38776_38949[(1)] = (116));

} else {
var statearr_38777_38950 = state_38723__$1;
(statearr_38777_38950[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (40))){
var inst_38423 = (state_38723[(12)]);
var inst_38485 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38778 = state_38723;
(statearr_38778[(28)] = inst_38485);

return statearr_38778;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38779_38951 = state_38723__$1;
(statearr_38779_38951[(1)] = (41));

} else {
var statearr_38780_38952 = state_38723__$1;
(statearr_38780_38952[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (91))){
var inst_38625 = (state_38723[(17)]);
var inst_38632 = (state_38723[(13)]);
var inst_38631 = cljs.core.seq(inst_38625);
var inst_38632__$1 = cljs.core.first(inst_38631);
var inst_38633 = cljs.core.next(inst_38631);
var inst_38634 = cljs.core.not(inst_38632__$1);
var state_38723__$1 = (function (){var statearr_38781 = state_38723;
(statearr_38781[(13)] = inst_38632__$1);

(statearr_38781[(29)] = inst_38633);

return statearr_38781;
})();
if(inst_38634){
var statearr_38782_38953 = state_38723__$1;
(statearr_38782_38953[(1)] = (93));

} else {
var statearr_38783_38954 = state_38723__$1;
(statearr_38783_38954[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (117))){
var inst_38699 = (state_38723[(25)]);
var state_38723__$1 = state_38723;
var statearr_38784_38955 = state_38723__$1;
(statearr_38784_38955[(2)] = inst_38699);

(statearr_38784_38955[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (108))){
var inst_38424 = (state_38723[(7)]);
var state_38723__$1 = state_38723;
var statearr_38785_38956 = state_38723__$1;
(statearr_38785_38956[(2)] = inst_38424);

(statearr_38785_38956[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (56))){
var inst_38513 = (state_38723[(30)]);
var inst_38424 = (state_38723[(7)]);
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38527 = (state_38723[(2)]);
var inst_38528 = fluree.db.util.async.throw_err(inst_38527);
var inst_38529 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38513,inst_38528);
var inst_38530 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_38436,fuel,max_fuel,inst_38434,inst_38529,inst_38424);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(57),inst_38530);
} else {
if((state_val_38724 === (33))){
var state_38723__$1 = state_38723;
var statearr_38786_38957 = state_38723__$1;
(statearr_38786_38957[(2)] = from);

(statearr_38786_38957[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (13))){
var inst_38410 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38411 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38412 = cljs.core.PersistentHashMap.fromArrays(inst_38410,inst_38411);
var inst_38413 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_38412);
var inst_38414 = (function(){throw inst_38413})();
var state_38723__$1 = state_38723;
var statearr_38787_38958 = state_38723__$1;
(statearr_38787_38958[(2)] = inst_38414);

(statearr_38787_38958[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (22))){
var inst_38423 = (state_38723[(12)]);
var inst_38446 = typeof inst_38423 === 'string';
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38446)){
var statearr_38788_38959 = state_38723__$1;
(statearr_38788_38959[(1)] = (24));

} else {
var statearr_38789_38960 = state_38723__$1;
(statearr_38789_38960[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (90))){
var inst_38689 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38790_38961 = state_38723__$1;
(statearr_38790_38961[(2)] = inst_38689);

(statearr_38790_38961[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (109))){
var inst_38423 = (state_38723[(12)]);
var inst_38668 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38791 = state_38723;
(statearr_38791[(31)] = inst_38668);

return statearr_38791;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38792_38962 = state_38723__$1;
(statearr_38792_38962[(1)] = (110));

} else {
var statearr_38793_38963 = state_38723__$1;
(statearr_38793_38963[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (36))){
var inst_38423 = (state_38723[(12)]);
var inst_38480 = (state_38723[(2)]);
var inst_38481 = fluree.db.util.async.throw_err(inst_38480);
var state_38723__$1 = (function (){var statearr_38794 = state_38723;
(statearr_38794[(32)] = inst_38481);

return statearr_38794;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38795_38964 = state_38723__$1;
(statearr_38795_38964[(1)] = (38));

} else {
var statearr_38796_38965 = state_38723__$1;
(statearr_38796_38965[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (41))){
var state_38723__$1 = state_38723;
var statearr_38797_38966 = state_38723__$1;
(statearr_38797_38966[(2)] = null);

(statearr_38797_38966[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (118))){
var inst_38705 = (state_38723[(33)]);
var inst_38704 = (state_38723[(2)]);
var inst_38705__$1 = selectOne;
var state_38723__$1 = (function (){var statearr_38798 = state_38723;
(statearr_38798[(19)] = inst_38704);

(statearr_38798[(33)] = inst_38705__$1);

return statearr_38798;
})();
if(cljs.core.truth_(inst_38705__$1)){
var statearr_38799_38967 = state_38723__$1;
(statearr_38799_38967[(1)] = (119));

} else {
var statearr_38800_38968 = state_38723__$1;
(statearr_38800_38968[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (89))){
var state_38723__$1 = state_38723;
var statearr_38801_38969 = state_38723__$1;
(statearr_38801_38969[(1)] = (113));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (100))){
var state_38723__$1 = state_38723;
var statearr_38803_38970 = state_38723__$1;
(statearr_38803_38970[(2)] = null);

(statearr_38803_38970[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (122))){
var inst_38704 = (state_38723[(19)]);
var inst_38715 = cljs.core.first(inst_38704);
var state_38723__$1 = state_38723;
var statearr_38804_38971 = state_38723__$1;
(statearr_38804_38971[(2)] = inst_38715);

(statearr_38804_38971[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (43))){
var inst_38481 = (state_38723[(32)]);
var inst_38485 = (state_38723[(28)]);
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38489 = (state_38723[(2)]);
var inst_38490 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_38436,fuel,max_fuel,inst_38434,inst_38481,inst_38485,inst_38489);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(37),inst_38490);
} else {
if((state_val_38724 === (61))){
var inst_38423 = (state_38723[(12)]);
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38423)){
var statearr_38805_38972 = state_38723__$1;
(statearr_38805_38972[(1)] = (64));

} else {
var statearr_38806_38973 = state_38723__$1;
(statearr_38806_38973[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (29))){
var inst_38458 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38807_38974 = state_38723__$1;
(statearr_38807_38974[(2)] = inst_38458);

(statearr_38807_38974[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (44))){
var inst_38501 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38723__$1 = (function (){var statearr_38808 = state_38723;
(statearr_38808[(23)] = inst_38501);

return statearr_38808;
})();
if(cljs.core.truth_(fuel)){
var statearr_38809_38975 = state_38723__$1;
(statearr_38809_38975[(1)] = (47));

} else {
var statearr_38810_38976 = state_38723__$1;
(statearr_38810_38976[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (93))){
var inst_38626 = (state_38723[(16)]);
var state_38723__$1 = state_38723;
var statearr_38811_38977 = state_38723__$1;
(statearr_38811_38977[(2)] = inst_38626);

(statearr_38811_38977[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (6))){
var inst_38401 = (state_38723[(34)]);
var state_38723__$1 = state_38723;
var statearr_38812_38978 = state_38723__$1;
(statearr_38812_38978[(2)] = inst_38401);

(statearr_38812_38978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (111))){
var inst_38426 = (state_38723[(8)]);
var state_38723__$1 = state_38723;
var statearr_38813_38979 = state_38723__$1;
(statearr_38813_38979[(2)] = inst_38426);

(statearr_38813_38979[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (28))){
var state_38723__$1 = state_38723;
var statearr_38814_38980 = state_38723__$1;
(statearr_38814_38980[(2)] = null);

(statearr_38814_38980[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (64))){
var inst_38547 = cljs.core.PersistentHashMap.EMPTY;
var state_38723__$1 = state_38723;
var statearr_38815_38981 = state_38723__$1;
(statearr_38815_38981[(2)] = inst_38547);

(statearr_38815_38981[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (103))){
var inst_38626 = (state_38723[(16)]);
var inst_38652 = (state_38723[(35)]);
var inst_38654 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38626,inst_38652);
var state_38723__$1 = state_38723;
var statearr_38816_38982 = state_38723__$1;
(statearr_38816_38982[(2)] = inst_38654);

(statearr_38816_38982[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (51))){
var inst_38507 = (state_38723[(24)]);
var state_38723__$1 = state_38723;
var statearr_38817_38983 = state_38723__$1;
(statearr_38817_38983[(2)] = inst_38507);

(statearr_38817_38983[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (25))){
var state_38723__$1 = state_38723;
var statearr_38818_38984 = state_38723__$1;
(statearr_38818_38984[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (34))){
var state_38723__$1 = state_38723;
var statearr_38820_38985 = state_38723__$1;
(statearr_38820_38985[(2)] = null);

(statearr_38820_38985[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (17))){
var inst_38423 = (state_38723[(12)]);
var inst_38434 = (state_38723[(2)]);
var inst_38435 = cljs.core.PersistentHashMap.EMPTY;
var inst_38436 = cljs.core.volatile_BANG_(inst_38435);
var state_38723__$1 = (function (){var statearr_38821 = state_38723;
(statearr_38821[(26)] = inst_38434);

(statearr_38821[(27)] = inst_38436);

return statearr_38821;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38822_38986 = state_38723__$1;
(statearr_38822_38986[(1)] = (18));

} else {
var statearr_38823_38987 = state_38723__$1;
(statearr_38823_38987[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (3))){
var inst_38721 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38723__$1,inst_38721);
} else {
if((state_val_38724 === (12))){
var inst_38407 = (state_38723[(36)]);
var state_38723__$1 = state_38723;
var statearr_38824_38988 = state_38723__$1;
(statearr_38824_38988[(2)] = inst_38407);

(statearr_38824_38988[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (2))){
var inst_38401 = (state_38723[(34)]);
var _ = (function (){var statearr_38825 = state_38723;
(statearr_38825[(4)] = cljs.core.cons((5),(state_38723[(4)])));

return statearr_38825;
})();
var inst_38401__$1 = select;
var state_38723__$1 = (function (){var statearr_38826 = state_38723;
(statearr_38826[(34)] = inst_38401__$1);

return statearr_38826;
})();
if(cljs.core.truth_(inst_38401__$1)){
var statearr_38827_38989 = state_38723__$1;
(statearr_38827_38989[(1)] = (6));

} else {
var statearr_38828_38990 = state_38723__$1;
(statearr_38828_38990[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (66))){
var inst_38553 = (state_38723[(2)]);
var inst_38554 = fluree.db.query.range._block_or_tx_collection(db,inst_38553);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(67),inst_38554);
} else {
if((state_val_38724 === (107))){
var state_38723__$1 = state_38723;
var statearr_38829_38991 = state_38723__$1;
(statearr_38829_38991[(2)] = null);

(statearr_38829_38991[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (23))){
var inst_38462 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38830_38992 = state_38723__$1;
(statearr_38830_38992[(2)] = inst_38462);

(statearr_38830_38992[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (47))){
var inst_38501 = (state_38723[(23)]);
var inst_38503 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_38504 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38501,inst_38503);
var state_38723__$1 = state_38723;
var statearr_38831_38993 = state_38723__$1;
(statearr_38831_38993[(2)] = inst_38504);

(statearr_38831_38993[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (35))){
var inst_38477 = (state_38723[(2)]);
var inst_38478 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_38477);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(36),inst_38478);
} else {
if((state_val_38724 === (82))){
var inst_38588 = (state_38723[(37)]);
var inst_38592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38593 = [inst_38588];
var inst_38594 = (new cljs.core.PersistentVector(null,1,(5),inst_38592,inst_38593,null));
var state_38723__$1 = state_38723;
var statearr_38832_38994 = state_38723__$1;
(statearr_38832_38994[(2)] = inst_38594);

(statearr_38832_38994[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (76))){
var inst_38579 = (state_38723[(2)]);
var inst_38580 = fluree.db.util.async.throw_err(inst_38579);
var state_38723__$1 = state_38723;
var statearr_38833_38995 = state_38723__$1;
(statearr_38833_38995[(2)] = inst_38580);

(statearr_38833_38995[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (97))){
var state_38723__$1 = state_38723;
if(cljs.core.truth_(fuel)){
var statearr_38834_38996 = state_38723__$1;
(statearr_38834_38996[(1)] = (99));

} else {
var statearr_38835_38997 = state_38723__$1;
(statearr_38835_38997[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (19))){
var inst_38464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38465 = [null,null];
var inst_38466 = (new cljs.core.PersistentVector(null,2,(5),inst_38464,inst_38465,null));
var state_38723__$1 = state_38723;
var statearr_38836_38998 = state_38723__$1;
(statearr_38836_38998[(2)] = inst_38466);

(statearr_38836_38998[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (57))){
var inst_38532 = (state_38723[(2)]);
var inst_38533 = fluree.db.util.async.throw_err(inst_38532);
var state_38723__$1 = state_38723;
var statearr_38837_38999 = state_38723__$1;
(statearr_38837_38999[(2)] = inst_38533);

(statearr_38837_38999[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (68))){
var inst_38560 = (state_38723[(2)]);
var inst_38561 = fluree.db.util.async.throw_err(inst_38560);
var state_38723__$1 = state_38723;
var statearr_38838_39000 = state_38723__$1;
(statearr_38838_39000[(2)] = inst_38561);

(statearr_38838_39000[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (11))){
var inst_38418 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38839_39001 = state_38723__$1;
(statearr_38839_39001[(2)] = inst_38418);

(statearr_38839_39001[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (115))){
var inst_38687 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38841_39002 = state_38723__$1;
(statearr_38841_39002[(2)] = inst_38687);

(statearr_38841_39002[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (9))){
var inst_38404 = (state_38723[(9)]);
var state_38723__$1 = state_38723;
var statearr_38842_39003 = state_38723__$1;
(statearr_38842_39003[(2)] = inst_38404);

(statearr_38842_39003[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (5))){
var _ = (function (){var statearr_38843 = state_38723;
(statearr_38843[(4)] = cljs.core.rest((state_38723[(4)])));

return statearr_38843;
})();
var state_38723__$1 = state_38723;
var ex38840 = (state_38723__$1[(2)]);
var statearr_38844_39004 = state_38723__$1;
(statearr_38844_39004[(5)] = ex38840);


if((ex38840 instanceof Error)){
var statearr_38845_39005 = state_38723__$1;
(statearr_38845_39005[(1)] = (4));

(statearr_38845_39005[(5)] = null);

} else {
throw ex38840;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (112))){
var inst_38668 = (state_38723[(31)]);
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38664 = (state_38723[(20)]);
var inst_38672 = (state_38723[(2)]);
var inst_38673 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_38436,fuel,max_fuel,inst_38434,inst_38664,inst_38668,inst_38672);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(106),inst_38673);
} else {
if((state_val_38724 === (83))){
var inst_38424 = (state_38723[(7)]);
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38426 = (state_38723[(8)]);
var inst_38596 = (state_38723[(2)]);
var inst_38597 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_38436,fuel,max_fuel,inst_38434,inst_38596,inst_38424,inst_38426);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(84),inst_38597);
} else {
if((state_val_38724 === (14))){
var inst_38416 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38846_39006 = state_38723__$1;
(statearr_38846_39006[(2)] = inst_38416);

(statearr_38846_39006[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (45))){
var inst_38536 = typeof from === 'string';
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38536)){
var statearr_38847_39007 = state_38723__$1;
(statearr_38847_39007[(1)] = (58));

} else {
var statearr_38848_39008 = state_38723__$1;
(statearr_38848_39008[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (53))){
var inst_38515 = cljs.core.PersistentHashMap.EMPTY;
var state_38723__$1 = state_38723;
var statearr_38849_39009 = state_38723__$1;
(statearr_38849_39009[(2)] = inst_38515);

(statearr_38849_39009[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (78))){
var inst_38609 = cljs.core.sequential_QMARK_(from);
var inst_38610 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_38611 = ((inst_38609) && (inst_38610));
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38611)){
var statearr_38850_39010 = state_38723__$1;
(statearr_38850_39010[(1)] = (88));

} else {
var statearr_38851_39011 = state_38723__$1;
(statearr_38851_39011[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (26))){
var inst_38460 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38852_39012 = state_38723__$1;
(statearr_38852_39012[(2)] = inst_38460);

(statearr_38852_39012[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (123))){
var inst_38704 = (state_38723[(19)]);
var state_38723__$1 = state_38723;
var statearr_38853_39013 = state_38723__$1;
(statearr_38853_39013[(2)] = inst_38704);

(statearr_38853_39013[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (16))){
var inst_38427 = (state_38723[(21)]);
var state_38723__$1 = state_38723;
var statearr_38854_39014 = state_38723__$1;
(statearr_38854_39014[(2)] = inst_38427);

(statearr_38854_39014[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (81))){
var state_38723__$1 = state_38723;
var statearr_38855_39015 = state_38723__$1;
(statearr_38855_39015[(2)] = null);

(statearr_38855_39015[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (120))){
var inst_38705 = (state_38723[(33)]);
var state_38723__$1 = state_38723;
var statearr_38856_39016 = state_38723__$1;
(statearr_38856_39016[(2)] = inst_38705);

(statearr_38856_39016[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (79))){
var inst_38691 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38857_39017 = state_38723__$1;
(statearr_38857_39017[(2)] = inst_38691);

(statearr_38857_39017[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (38))){
var state_38723__$1 = state_38723;
var statearr_38858_39018 = state_38723__$1;
(statearr_38858_39018[(2)] = null);

(statearr_38858_39018[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (98))){
var inst_38652 = (state_38723[(35)]);
var inst_38652__$1 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38859 = state_38723;
(statearr_38859[(35)] = inst_38652__$1);

return statearr_38859;
})();
if(cljs.core.truth_(inst_38652__$1)){
var statearr_38860_39019 = state_38723__$1;
(statearr_38860_39019[(1)] = (103));

} else {
var statearr_38861_39020 = state_38723__$1;
(statearr_38861_39020[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (124))){
var inst_38718 = (state_38723[(2)]);
var _ = (function (){var statearr_38862 = state_38723;
(statearr_38862[(4)] = cljs.core.rest((state_38723[(4)])));

return statearr_38862;
})();
var state_38723__$1 = state_38723;
var statearr_38863_39021 = state_38723__$1;
(statearr_38863_39021[(2)] = inst_38718);

(statearr_38863_39021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (87))){
var inst_38600 = (state_38723[(38)]);
var inst_38607 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38864 = state_38723;
(statearr_38864[(39)] = inst_38607);

return statearr_38864;
})();
var statearr_38865_39022 = state_38723__$1;
(statearr_38865_39022[(2)] = inst_38600);

(statearr_38865_39022[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (30))){
var inst_38473 = typeof from === 'string';
var state_38723__$1 = state_38723;
if(cljs.core.truth_(inst_38473)){
var statearr_38866_39023 = state_38723__$1;
(statearr_38866_39023[(1)] = (33));

} else {
var statearr_38867_39024 = state_38723__$1;
(statearr_38867_39024[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (73))){
var inst_38424 = (state_38723[(7)]);
var inst_38426 = (state_38723[(8)]);
var inst_38568 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_38569 = [inst_38424,inst_38426];
var inst_38570 = cljs.core.PersistentHashMap.fromArrays(inst_38568,inst_38569);
var state_38723__$1 = state_38723;
var statearr_38868_39025 = state_38723__$1;
(statearr_38868_39025[(2)] = inst_38570);

(statearr_38868_39025[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (96))){
var inst_38632 = (state_38723[(13)]);
var state_38723__$1 = state_38723;
var statearr_38869_39026 = state_38723__$1;
(statearr_38869_39026[(2)] = inst_38632);

(statearr_38869_39026[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (10))){
var inst_38407 = (state_38723[(36)]);
var inst_38407__$1 = selectDistinct;
var state_38723__$1 = (function (){var statearr_38870 = state_38723;
(statearr_38870[(36)] = inst_38407__$1);

return statearr_38870;
})();
if(cljs.core.truth_(inst_38407__$1)){
var statearr_38871_39027 = state_38723__$1;
(statearr_38871_39027[(1)] = (12));

} else {
var statearr_38872_39028 = state_38723__$1;
(statearr_38872_39028[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (18))){
var inst_38423 = (state_38723[(12)]);
var inst_38438 = cljs.core.vector_QMARK_(inst_38423);
var state_38723__$1 = state_38723;
if(inst_38438){
var statearr_38873_39029 = state_38723__$1;
(statearr_38873_39029[(1)] = (21));

} else {
var statearr_38874_39030 = state_38723__$1;
(statearr_38874_39030[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (105))){
var inst_38633 = (state_38723[(29)]);
var inst_38657 = (state_38723[(2)]);
var inst_38625 = inst_38633;
var inst_38626 = inst_38657;
var state_38723__$1 = (function (){var statearr_38875 = state_38723;
(statearr_38875[(16)] = inst_38626);

(statearr_38875[(17)] = inst_38625);

return statearr_38875;
})();
var statearr_38876_39031 = state_38723__$1;
(statearr_38876_39031[(2)] = null);

(statearr_38876_39031[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (52))){
var inst_38423 = (state_38723[(12)]);
var inst_38513 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38877 = state_38723;
(statearr_38877[(30)] = inst_38513);

return statearr_38877;
})();
if(cljs.core.truth_(inst_38423)){
var statearr_38878_39032 = state_38723__$1;
(statearr_38878_39032[(1)] = (53));

} else {
var statearr_38879_39033 = state_38723__$1;
(statearr_38879_39033[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (114))){
var state_38723__$1 = state_38723;
var statearr_38880_39034 = state_38723__$1;
(statearr_38880_39034[(2)] = null);

(statearr_38880_39034[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (67))){
var inst_38434 = (state_38723[(26)]);
var inst_38436 = (state_38723[(27)]);
var inst_38556 = (state_38723[(2)]);
var inst_38557 = fluree.db.util.async.throw_err(inst_38556);
var inst_38558 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_38436,fuel,max_fuel,inst_38434,inst_38557);
var state_38723__$1 = state_38723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38723__$1,(68),inst_38558);
} else {
if((state_val_38724 === (71))){
var inst_38693 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38881_39035 = state_38723__$1;
(statearr_38881_39035[(2)] = inst_38693);

(statearr_38881_39035[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (42))){
var inst_38426 = (state_38723[(8)]);
var state_38723__$1 = state_38723;
var statearr_38882_39036 = state_38723__$1;
(statearr_38882_39036[(2)] = inst_38426);

(statearr_38882_39036[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (80))){
var inst_38588 = (state_38723[(37)]);
var inst_38587 = (state_38723[(2)]);
var inst_38588__$1 = fluree.db.util.async.throw_err(inst_38587);
var inst_38589 = (inst_38588__$1 == null);
var state_38723__$1 = (function (){var statearr_38883 = state_38723;
(statearr_38883[(37)] = inst_38588__$1);

return statearr_38883;
})();
if(cljs.core.truth_(inst_38589)){
var statearr_38884_39037 = state_38723__$1;
(statearr_38884_39037[(1)] = (81));

} else {
var statearr_38885_39038 = state_38723__$1;
(statearr_38885_39038[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (37))){
var inst_38492 = (state_38723[(2)]);
var inst_38493 = fluree.db.util.async.throw_err(inst_38492);
var state_38723__$1 = state_38723;
var statearr_38886_39039 = state_38723__$1;
(statearr_38886_39039[(2)] = inst_38493);

(statearr_38886_39039[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (63))){
var inst_38695 = (state_38723[(2)]);
var state_38723__$1 = state_38723;
var statearr_38887_39040 = state_38723__$1;
(statearr_38887_39040[(2)] = inst_38695);

(statearr_38887_39040[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (94))){
var inst_38632 = (state_38723[(13)]);
var inst_38637 = cljs.core.int_QMARK_(inst_38632);
var state_38723__$1 = state_38723;
if(inst_38637){
var statearr_38888_39041 = state_38723__$1;
(statearr_38888_39041[(1)] = (96));

} else {
var statearr_38889_39042 = state_38723__$1;
(statearr_38889_39042[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (8))){
var inst_38425 = (state_38723[(22)]);
var inst_38420 = (state_38723[(2)]);
var inst_38421 = opts_SINGLEQUOTE_;
var inst_38422 = cljs.core.__destructure_map(inst_38421);
var inst_38423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38422,cljs.core.cst$kw$orderBy);
var inst_38424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38422,cljs.core.cst$kw$limit);
var inst_38425__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38422,cljs.core.cst$kw$component);
var inst_38426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38422,cljs.core.cst$kw$offset);
var inst_38427 = fluree.db.query.fql_parser.parse_db(db,inst_38420,opts_SINGLEQUOTE_);
var inst_38428 = (inst_38425__$1 == null);
var inst_38429 = cljs.core.not(inst_38428);
var state_38723__$1 = (function (){var statearr_38890 = state_38723;
(statearr_38890[(21)] = inst_38427);

(statearr_38890[(22)] = inst_38425__$1);

(statearr_38890[(7)] = inst_38424);

(statearr_38890[(8)] = inst_38426);

(statearr_38890[(12)] = inst_38423);

return statearr_38890;
})();
if(inst_38429){
var statearr_38891_39043 = state_38723__$1;
(statearr_38891_39043[(1)] = (15));

} else {
var statearr_38892_39044 = state_38723__$1;
(statearr_38892_39044[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (49))){
var inst_38507 = (state_38723[(2)]);
var state_38723__$1 = (function (){var statearr_38893 = state_38723;
(statearr_38893[(24)] = inst_38507);

return statearr_38893;
})();
var statearr_38894_39045 = state_38723__$1;
(statearr_38894_39045[(1)] = (50));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38724 === (84))){
var inst_38599 = (state_38723[(2)]);
var inst_38600 = fluree.db.util.async.throw_err(inst_38599);
var state_38723__$1 = (function (){var statearr_38896 = state_38723;
(statearr_38896[(38)] = inst_38600);

return statearr_38896;
})();
if(cljs.core.truth_(fuel)){
var statearr_38897_39046 = state_38723__$1;
(statearr_38897_39046[(1)] = (85));

} else {
var statearr_38898_39047 = state_38723__$1;
(statearr_38898_39047[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__13883__auto____0 = (function (){
var statearr_38899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38899[(0)] = fluree$db$query$fql$query_$_state_machine__13883__auto__);

(statearr_38899[(1)] = (1));

return statearr_38899;
});
var fluree$db$query$fql$query_$_state_machine__13883__auto____1 = (function (state_38723){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38723);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38900){var ex__13886__auto__ = e38900;
var statearr_38901_39048 = state_38723;
(statearr_38901_39048[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38723[(4)]))){
var statearr_38902_39049 = state_38723;
(statearr_38902_39049[(1)] = cljs.core.first((state_38723[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39050 = state_38723;
state_38723 = G__39050;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__13883__auto__ = function(state_38723){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__13883__auto____1.call(this,state_38723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__13883__auto____0;
fluree$db$query$fql$query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__13883__auto____1;
return fluree$db$query$fql$query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38903 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38903[(6)] = c__13957__auto__);

return statearr_38903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}

});
