// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24782_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24782_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__24786 = coll;
var vec__24787 = G__24786;
var seq__24788 = cljs.core.seq(vec__24787);
var first__24789 = cljs.core.first(seq__24788);
var seq__24788__$1 = cljs.core.next(seq__24788);
var clause = first__24789;
var r = seq__24788__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__24786__$1 = G__24786;
var res__$1 = res;
while(true){
var vec__24793 = G__24786__$1;
var seq__24794 = cljs.core.seq(vec__24793);
var first__24795 = cljs.core.first(seq__24794);
var seq__24794__$1 = cljs.core.next(seq__24794);
var clause__$1 = first__24795;
var r__$1 = seq__24794__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__24796 = r__$1;
var G__24797 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__24786__$1 = G__24796;
res__$1 = G__24797;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__24798){
var map__24799 = p__24798;
var map__24799__$1 = cljs.core.__destructure_map(map__24799);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24799__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__24803 = coll;
var vec__24804 = G__24803;
var seq__24805 = cljs.core.seq(vec__24804);
var first__24806 = cljs.core.first(seq__24805);
var seq__24805__$1 = cljs.core.next(seq__24805);
var clause = first__24806;
var r = seq__24805__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__24803__$1 = G__24803;
var res__$1 = res;
while(true){
var vec__24810 = G__24803__$1;
var seq__24811 = cljs.core.seq(vec__24810);
var first__24812 = cljs.core.first(seq__24811);
var seq__24811__$1 = cljs.core.next(seq__24811);
var clause__$1 = first__24812;
var r__$1 = seq__24811__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__24813 = r__$1;
var G__24814 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__24803__$1 = G__24813;
res__$1 = G__24814;
continue;
} else {
var G__24815 = r__$1;
var G__24816 = res__$2;
G__24803__$1 = G__24815;
res__$1 = G__24816;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__24820 = coll;
var vec__24821 = G__24820;
var seq__24822 = cljs.core.seq(vec__24821);
var first__24823 = cljs.core.first(seq__24822);
var seq__24822__$1 = cljs.core.next(seq__24822);
var clause = first__24823;
var r = seq__24822__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__24820__$1 = G__24820;
var res__$1 = res;
while(true){
var vec__24827 = G__24820__$1;
var seq__24828 = cljs.core.seq(vec__24827);
var first__24829 = cljs.core.first(seq__24828);
var seq__24828__$1 = cljs.core.next(seq__24828);
var clause__$1 = first__24829;
var r__$1 = seq__24828__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__24830 = r__$1;
var G__24831 = res__$2;
G__24820__$1 = G__24830;
res__$1 = G__24831;
continue;
} else {
var G__24832 = r__$1;
var G__24833 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__24820__$1 = G__24832;
res__$1 = G__24833;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__24834 = clause;
var G__24834__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__24834):G__24834);
var G__24834__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__24834__$1)
;
var G__24834__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__24834__$2)
;
var G__24834__$4 = goog.string.format("%s .",G__24834__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__24834__$4);
} else {
return G__24834__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__24838 = opts;
var map__24838__$1 = cljs.core.__destructure_map(map__24838);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24838__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24838__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24838__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24838__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24838__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24835_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24835_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__24836_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__24836_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__24837_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__24837_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4160__auto__ = language;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24852){
var state_val_24853 = (state_24852[(1)]);
if((state_val_24853 === (1))){
var inst_24839 = fluree.db.util.core.url_encode(query);
var inst_24840 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24839)].join('');
var inst_24841 = ["User-Agent","Accept"];
var inst_24842 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_24843 = cljs.core.PersistentHashMap.fromArrays(inst_24841,inst_24842);
var inst_24844 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_24845 = [inst_24843,(30000),cljs.core.cst$kw$wikidata];
var inst_24846 = cljs.core.PersistentHashMap.fromArrays(inst_24844,inst_24845);
var inst_24847 = fluree.db.util.xhttp.get(inst_24840,inst_24846);
var state_24852__$1 = state_24852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24852__$1,(2),inst_24847);
} else {
if((state_val_24853 === (2))){
var inst_24849 = (state_24852[(2)]);
var inst_24850 = fluree.db.util.async.throw_err(inst_24849);
var state_24852__$1 = state_24852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24852__$1,inst_24850);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0 = (function (){
var statearr_24854 = [null,null,null,null,null,null,null];
(statearr_24854[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__);

(statearr_24854[(1)] = (1));

return statearr_24854;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1 = (function (state_24852){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24852);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24855){var ex__13886__auto__ = e24855;
var statearr_24856_24859 = state_24852;
(statearr_24856_24859[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24852[(4)]))){
var statearr_24857_24860 = state_24852;
(statearr_24857_24860[(1)] = cljs.core.first((state_24852[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24861 = state_24852;
state_24852 = G__24861;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__ = function(state_24852){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1.call(this,state_24852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24858 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24858[(6)] = c__13957__auto__);

return statearr_24858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24879){
var state_val_24880 = (state_24879[(1)]);
if((state_val_24880 === (1))){
var inst_24862 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_24879__$1 = state_24879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24879__$1,(2),inst_24862);
} else {
if((state_val_24880 === (2))){
var inst_24865 = (state_24879[(7)]);
var inst_24864 = (state_24879[(2)]);
var inst_24865__$1 = fluree.db.util.async.throw_err(inst_24864);
var inst_24866 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_24865__$1);
var inst_24867 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_24866);
var state_24879__$1 = (function (){var statearr_24881 = state_24879;
(statearr_24881[(7)] = inst_24865__$1);

return statearr_24881;
})();
if(inst_24867){
var statearr_24882_24891 = state_24879__$1;
(statearr_24882_24891[(1)] = (3));

} else {
var statearr_24883_24892 = state_24879__$1;
(statearr_24883_24892[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24880 === (3))){
var inst_24865 = (state_24879[(7)]);
var state_24879__$1 = state_24879;
var statearr_24884_24893 = state_24879__$1;
(statearr_24884_24893[(2)] = inst_24865);

(statearr_24884_24893[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24880 === (4))){
var inst_24865 = (state_24879[(7)]);
var inst_24870 = (function (){var body = inst_24865;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_24871 = cljs.core.second(inst_24865);
var inst_24872 = cljs.core.second(inst_24871);
var inst_24873 = cljs.core.first(inst_24872);
var inst_24874 = cljs.core.second(inst_24873);
var inst_24875 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_24870,inst_24874);
var state_24879__$1 = state_24879;
var statearr_24885_24894 = state_24879__$1;
(statearr_24885_24894[(2)] = inst_24875);

(statearr_24885_24894[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24880 === (5))){
var inst_24877 = (state_24879[(2)]);
var state_24879__$1 = state_24879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24879__$1,inst_24877);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0 = (function (){
var statearr_24886 = [null,null,null,null,null,null,null,null];
(statearr_24886[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__);

(statearr_24886[(1)] = (1));

return statearr_24886;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1 = (function (state_24879){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24879);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24887){var ex__13886__auto__ = e24887;
var statearr_24888_24895 = state_24879;
(statearr_24888_24895[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24879[(4)]))){
var statearr_24889_24896 = state_24879;
(statearr_24889_24896[(1)] = cljs.core.first((state_24879[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24897 = state_24879;
state_24879 = G__24897;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__ = function(state_24879){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1.call(this,state_24879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24890 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24890[(6)] = c__13957__auto__);

return statearr_24890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24898_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24898_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24899_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24899_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24900_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__24900_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__24900_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__24900_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24946){
var state_val_24947 = (state_24946[(1)]);
if((state_val_24947 === (7))){
var inst_24911 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_24946__$1 = state_24946;
var statearr_24948_24976 = state_24946__$1;
(statearr_24948_24976[(2)] = inst_24911);

(statearr_24948_24976[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (1))){
var state_24946__$1 = state_24946;
var statearr_24949_24977 = state_24946__$1;
(statearr_24949_24977[(2)] = null);

(statearr_24949_24977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (4))){
var inst_24901 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
var statearr_24950_24978 = state_24946__$1;
(statearr_24950_24978[(2)] = inst_24901);

(statearr_24950_24978[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (15))){
var inst_24919 = (state_24946[(7)]);
var inst_24920 = (state_24946[(8)]);
var inst_24925 = (state_24946[(9)]);
var inst_24930 = (state_24946[(2)]);
var inst_24931 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_24925,(0),inst_24930);
var inst_24932 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_24933 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_24919);
var inst_24934 = [inst_24920,inst_24933];
var inst_24935 = cljs.core.PersistentHashMap.fromArrays(inst_24932,inst_24934);
var inst_24936 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24931,inst_24935);
var inst_24937 = (function(){throw inst_24936})();
var state_24946__$1 = state_24946;
var statearr_24951_24979 = state_24946__$1;
(statearr_24951_24979[(2)] = inst_24937);

(statearr_24951_24979[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (13))){
var inst_24924 = (state_24946[(10)]);
var state_24946__$1 = state_24946;
var statearr_24952_24980 = state_24946__$1;
(statearr_24952_24980[(2)] = inst_24924);

(statearr_24952_24980[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (6))){
var state_24946__$1 = state_24946;
var statearr_24953_24981 = state_24946__$1;
(statearr_24953_24981[(2)] = null);

(statearr_24953_24981[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (3))){
var inst_24944 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24946__$1,inst_24944);
} else {
if((state_val_24947 === (12))){
var inst_24941 = (state_24946[(2)]);
var _ = (function (){var statearr_24954 = state_24946;
(statearr_24954[(4)] = cljs.core.rest((state_24946[(4)])));

return statearr_24954;
})();
var state_24946__$1 = state_24946;
var statearr_24955_24982 = state_24946__$1;
(statearr_24955_24982[(2)] = inst_24941);

(statearr_24955_24982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (2))){
var _ = (function (){var statearr_24956 = state_24946;
(statearr_24956[(4)] = cljs.core.cons((5),(state_24946[(4)])));

return statearr_24956;
})();
var inst_24908 = cljs.core.empty_QMARK_(matching_vars);
var state_24946__$1 = state_24946;
if(inst_24908){
var statearr_24957_24983 = state_24946__$1;
(statearr_24957_24983[(1)] = (6));

} else {
var statearr_24958_24984 = state_24946__$1;
(statearr_24958_24984[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (11))){
var inst_24919 = (state_24946[(7)]);
var inst_24939 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_24919,all_vars);
var state_24946__$1 = state_24946;
var statearr_24960_24985 = state_24946__$1;
(statearr_24960_24985[(2)] = inst_24939);

(statearr_24960_24985[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (9))){
var inst_24919 = (state_24946[(7)]);
var inst_24920 = (state_24946[(8)]);
var inst_24917 = (state_24946[(2)]);
var inst_24918 = fluree.db.util.async.throw_err(inst_24917);
var inst_24919__$1 = cljs.core.__destructure_map(inst_24918);
var inst_24920__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24919__$1,cljs.core.cst$kw$status);
var inst_24921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24919__$1,cljs.core.cst$kw$message);
var inst_24922 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_24920__$1);
var state_24946__$1 = (function (){var statearr_24961 = state_24946;
(statearr_24961[(7)] = inst_24919__$1);

(statearr_24961[(11)] = inst_24921);

(statearr_24961[(8)] = inst_24920__$1);

return statearr_24961;
})();
if(inst_24922){
var statearr_24962_24986 = state_24946__$1;
(statearr_24962_24986[(1)] = (10));

} else {
var statearr_24963_24987 = state_24946__$1;
(statearr_24963_24987[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (5))){
var _ = (function (){var statearr_24964 = state_24946;
(statearr_24964[(4)] = cljs.core.rest((state_24946[(4)])));

return statearr_24964;
})();
var state_24946__$1 = state_24946;
var ex24959 = (state_24946__$1[(2)]);
var statearr_24965_24988 = state_24946__$1;
(statearr_24965_24988[(5)] = ex24959);


if((ex24959 instanceof Error)){
var statearr_24966_24989 = state_24946__$1;
(statearr_24966_24989[(1)] = (4));

(statearr_24966_24989[(5)] = null);

} else {
throw ex24959;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (14))){
var state_24946__$1 = state_24946;
var statearr_24967_24990 = state_24946__$1;
(statearr_24967_24990[(2)] = (1000));

(statearr_24967_24990[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (10))){
var inst_24919 = (state_24946[(7)]);
var inst_24921 = (state_24946[(11)]);
var inst_24924 = (state_24946[(10)]);
var inst_24924__$1 = cljs.core.count(inst_24921);
var inst_24925 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_24919);
var inst_24926 = (inst_24924__$1 < (1000));
var state_24946__$1 = (function (){var statearr_24968 = state_24946;
(statearr_24968[(10)] = inst_24924__$1);

(statearr_24968[(9)] = inst_24925);

return statearr_24968;
})();
if(cljs.core.truth_(inst_24926)){
var statearr_24969_24991 = state_24946__$1;
(statearr_24969_24991[(1)] = (13));

} else {
var statearr_24970_24992 = state_24946__$1;
(statearr_24970_24992[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24947 === (8))){
var inst_24913 = (state_24946[(2)]);
var inst_24914 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_24913,optional_clauses);
var inst_24915 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_24914);
var state_24946__$1 = state_24946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24946__$1,(9),inst_24915);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_24971 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24971[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__);

(statearr_24971[(1)] = (1));

return statearr_24971;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1 = (function (state_24946){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24946);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24972){var ex__13886__auto__ = e24972;
var statearr_24973_24993 = state_24946;
(statearr_24973_24993[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24946[(4)]))){
var statearr_24974_24994 = state_24946;
(statearr_24974_24994[(1)] = cljs.core.first((state_24946[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24995 = state_24946;
state_24946 = G__24995;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__ = function(state_24946){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1.call(this,state_24946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24975 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24975[(6)] = c__13957__auto__);

return statearr_24975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
