// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k30593,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__30597 = k30593;
var G__30597__$1 = (((G__30597 instanceof cljs.core.Keyword))?G__30597.fqn:null);
switch (G__30597__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30593,else__4418__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__30598){
var vec__30599 = p__30598;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30599,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30599,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30592){
var self__ = this;
var G__30592__$1 = this;
return (new cljs.core.RecordIter((0),G__30592__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__30602 = (function (coll__4412__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__30602(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30594,other30595){
var self__ = this;
var this30594__$1 = this;
return (((!((other30595 == null)))) && ((this30594__$1.constructor === other30595.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30594__$1.index_type,other30595.index_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30594__$1.comparator,other30595.comparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30594__$1.historyComparator,other30595.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30594__$1.__extmap,other30595.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__30592){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__30603 = cljs.core.keyword_identical_QMARK_;
var expr__30604 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__30606 = cljs.core.cst$kw$index_DASH_type;
var G__30607 = expr__30604;
return (pred__30603.cljs$core$IFn$_invoke$arity$2 ? pred__30603.cljs$core$IFn$_invoke$arity$2(G__30606,G__30607) : pred__30603.call(null,G__30606,G__30607));
})())){
return (new fluree.db.index.IndexConfig(G__30592,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30608 = cljs.core.cst$kw$comparator;
var G__30609 = expr__30604;
return (pred__30603.cljs$core$IFn$_invoke$arity$2 ? pred__30603.cljs$core$IFn$_invoke$arity$2(G__30608,G__30609) : pred__30603.call(null,G__30608,G__30609));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__30592,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30610 = cljs.core.cst$kw$historyComparator;
var G__30611 = expr__30604;
return (pred__30603.cljs$core$IFn$_invoke$arity$2 ? pred__30603.cljs$core$IFn$_invoke$arity$2(G__30610,G__30611) : pred__30603.call(null,G__30610,G__30611));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__30592,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__30592),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__30592){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__30592,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__30596){
var extmap__4454__auto__ = (function (){var G__30612 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30596,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__30596)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30612);
} else {
return G__30612;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__30596),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__30596),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__30596),null,cljs.core.not_empty(extmap__4454__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k30615,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__30619 = k30615;
var G__30619__$1 = (((G__30619 instanceof cljs.core.Keyword))?G__30619.fqn:null);
switch (G__30619__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30615,else__4418__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__30620){
var vec__30621 = p__30620;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30621,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30621,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30614){
var self__ = this;
var G__30614__$1 = this;
return (new cljs.core.RecordIter((0),G__30614__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30625){
var state_val_30626 = (state_30625[(1)]);
if((state_val_30626 === (1))){
var state_30625__$1 = state_30625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30625__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_30627 = [null,null,null,null,null,null,null];
(statearr_30627[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_30627[(1)] = (1));

return statearr_30627;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_30625){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30625);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30628){var ex__13886__auto__ = e30628;
var statearr_30629_30740 = state_30625;
(statearr_30629_30740[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30625[(4)]))){
var statearr_30630_30741 = state_30625;
(statearr_30630_30741[(1)] = cljs.core.first((state_30625[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30742 = state_30625;
state_30625 = G__30742;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_30625){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_30625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30631 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30631[(6)] = c__13957__auto__);

return statearr_30631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4160__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4160__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30656){
var state_val_30657 = (state_30656[(1)]);
if((state_val_30657 === (7))){
var inst_30638 = (state_30656[(7)]);
var inst_30642 = fluree.db.dbproto._resolve(inst_30638);
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30656__$1,(10),inst_30642);
} else {
if((state_val_30657 === (1))){
var state_30656__$1 = state_30656;
var statearr_30658_30743 = state_30656__$1;
(statearr_30658_30743[(2)] = null);

(statearr_30658_30743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (4))){
var inst_30632 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30659_30744 = state_30656__$1;
(statearr_30659_30744[(2)] = inst_30632);

(statearr_30659_30744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (6))){
var inst_30638 = (state_30656[(7)]);
var state_30656__$1 = state_30656;
var statearr_30660_30745 = state_30656__$1;
(statearr_30660_30745[(2)] = inst_30638);

(statearr_30660_30745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (3))){
var inst_30654 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30656__$1,inst_30654);
} else {
if((state_val_30657 === (2))){
var inst_30638 = (state_30656[(7)]);
var _ = (function (){var statearr_30662 = state_30656;
(statearr_30662[(4)] = cljs.core.cons((5),(state_30656[(4)])));

return statearr_30662;
})();
var inst_30638__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_30639 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_30638__$1);
var state_30656__$1 = (function (){var statearr_30663 = state_30656;
(statearr_30663[(7)] = inst_30638__$1);

return statearr_30663;
})();
if(cljs.core.truth_(inst_30639)){
var statearr_30664_30746 = state_30656__$1;
(statearr_30664_30746[(1)] = (6));

} else {
var statearr_30665_30747 = state_30656__$1;
(statearr_30665_30747[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (9))){
var inst_30648 = (state_30656[(2)]);
var inst_30649 = fluree.db.util.async.throw_err(inst_30648);
var state_30656__$1 = state_30656;
var statearr_30666_30748 = state_30656__$1;
(statearr_30666_30748[(2)] = inst_30649);

(statearr_30666_30748[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (5))){
var _ = (function (){var statearr_30667 = state_30656;
(statearr_30667[(4)] = cljs.core.rest((state_30656[(4)])));

return statearr_30667;
})();
var state_30656__$1 = state_30656;
var ex30661 = (state_30656__$1[(2)]);
var statearr_30668_30749 = state_30656__$1;
(statearr_30668_30749[(5)] = ex30661);


if((ex30661 instanceof Error)){
var statearr_30669_30750 = state_30656__$1;
(statearr_30669_30750[(1)] = (4));

(statearr_30669_30750[(5)] = null);

} else {
throw ex30661;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30657 === (10))){
var inst_30644 = (state_30656[(2)]);
var inst_30645 = fluree.db.util.async.throw_err(inst_30644);
var inst_30646 = fluree.db.dbproto._lookup_leaf(inst_30645,flake);
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30656__$1,(9),inst_30646);
} else {
if((state_val_30657 === (8))){
var inst_30651 = (state_30656[(2)]);
var _ = (function (){var statearr_30670 = state_30656;
(statearr_30670[(4)] = cljs.core.rest((state_30656[(4)])));

return statearr_30670;
})();
var state_30656__$1 = state_30656;
var statearr_30671_30751 = state_30656__$1;
(statearr_30671_30751[(2)] = inst_30651);

(statearr_30671_30751[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_30672 = [null,null,null,null,null,null,null,null];
(statearr_30672[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_30672[(1)] = (1));

return statearr_30672;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_30656){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30656);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30673){var ex__13886__auto__ = e30673;
var statearr_30674_30752 = state_30656;
(statearr_30674_30752[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30656[(4)]))){
var statearr_30675_30753 = state_30656;
(statearr_30675_30753[(1)] = cljs.core.first((state_30656[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30754 = state_30656;
state_30656 = G__30754;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_30656){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_30656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30676 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30676[(6)] = c__13957__auto__);

return statearr_30676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30701){
var state_val_30702 = (state_30701[(1)]);
if((state_val_30702 === (7))){
var inst_30683 = (state_30701[(7)]);
var inst_30687 = fluree.db.dbproto._resolve(inst_30683);
var state_30701__$1 = state_30701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30701__$1,(10),inst_30687);
} else {
if((state_val_30702 === (1))){
var state_30701__$1 = state_30701;
var statearr_30703_30755 = state_30701__$1;
(statearr_30703_30755[(2)] = null);

(statearr_30703_30755[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (4))){
var inst_30677 = (state_30701[(2)]);
var state_30701__$1 = state_30701;
var statearr_30704_30756 = state_30701__$1;
(statearr_30704_30756[(2)] = inst_30677);

(statearr_30704_30756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (6))){
var inst_30683 = (state_30701[(7)]);
var state_30701__$1 = state_30701;
var statearr_30705_30757 = state_30701__$1;
(statearr_30705_30757[(2)] = inst_30683);

(statearr_30705_30757[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (3))){
var inst_30699 = (state_30701[(2)]);
var state_30701__$1 = state_30701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30701__$1,inst_30699);
} else {
if((state_val_30702 === (2))){
var inst_30683 = (state_30701[(7)]);
var _ = (function (){var statearr_30707 = state_30701;
(statearr_30707[(4)] = cljs.core.cons((5),(state_30701[(4)])));

return statearr_30707;
})();
var inst_30683__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_30684 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_30683__$1);
var state_30701__$1 = (function (){var statearr_30708 = state_30701;
(statearr_30708[(7)] = inst_30683__$1);

return statearr_30708;
})();
if(cljs.core.truth_(inst_30684)){
var statearr_30709_30758 = state_30701__$1;
(statearr_30709_30758[(1)] = (6));

} else {
var statearr_30710_30759 = state_30701__$1;
(statearr_30710_30759[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (9))){
var inst_30693 = (state_30701[(2)]);
var inst_30694 = fluree.db.util.async.throw_err(inst_30693);
var state_30701__$1 = state_30701;
var statearr_30711_30760 = state_30701__$1;
(statearr_30711_30760[(2)] = inst_30694);

(statearr_30711_30760[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (5))){
var _ = (function (){var statearr_30712 = state_30701;
(statearr_30712[(4)] = cljs.core.rest((state_30701[(4)])));

return statearr_30712;
})();
var state_30701__$1 = state_30701;
var ex30706 = (state_30701__$1[(2)]);
var statearr_30713_30761 = state_30701__$1;
(statearr_30713_30761[(5)] = ex30706);


if((ex30706 instanceof Error)){
var statearr_30714_30762 = state_30701__$1;
(statearr_30714_30762[(1)] = (4));

(statearr_30714_30762[(5)] = null);

} else {
throw ex30706;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30702 === (10))){
var inst_30689 = (state_30701[(2)]);
var inst_30690 = fluree.db.util.async.throw_err(inst_30689);
var inst_30691 = fluree.db.dbproto._lookup_leaf_after(inst_30690,flake);
var state_30701__$1 = state_30701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30701__$1,(9),inst_30691);
} else {
if((state_val_30702 === (8))){
var inst_30696 = (state_30701[(2)]);
var _ = (function (){var statearr_30715 = state_30701;
(statearr_30715[(4)] = cljs.core.rest((state_30701[(4)])));

return statearr_30715;
})();
var state_30701__$1 = state_30701;
var statearr_30716_30763 = state_30701__$1;
(statearr_30716_30763[(2)] = inst_30696);

(statearr_30716_30763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_30717 = [null,null,null,null,null,null,null,null];
(statearr_30717[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_30717[(1)] = (1));

return statearr_30717;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_30701){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30701);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30718){var ex__13886__auto__ = e30718;
var statearr_30719_30764 = state_30701;
(statearr_30719_30764[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30701[(4)]))){
var statearr_30720_30765 = state_30701;
(statearr_30720_30765[(1)] = cljs.core.first((state_30701[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30766 = state_30701;
state_30701 = G__30766;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_30701){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_30701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30721 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30721[(6)] = c__13957__auto__);

return statearr_30721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__30722 = (function (coll__4412__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__30722(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30616,other30617){
var self__ = this;
var this30616__$1 = this;
return (((!((other30617 == null)))) && ((this30616__$1.constructor === other30617.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.block,other30617.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.t,other30617.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.rhs,other30617.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.children,other30617.children)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.config,other30617.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.leftmost_QMARK_,other30617.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30616__$1.__extmap,other30617.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__30614){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__30723 = cljs.core.keyword_identical_QMARK_;
var expr__30724 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__30726 = cljs.core.cst$kw$block;
var G__30727 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30726,G__30727) : pred__30723.call(null,G__30726,G__30727));
})())){
return (new fluree.db.index.IndexNode(G__30614,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30728 = cljs.core.cst$kw$t;
var G__30729 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30728,G__30729) : pred__30723.call(null,G__30728,G__30729));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__30614,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30730 = cljs.core.cst$kw$rhs;
var G__30731 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30730,G__30731) : pred__30723.call(null,G__30730,G__30731));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__30614,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30732 = cljs.core.cst$kw$children;
var G__30733 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30732,G__30733) : pred__30723.call(null,G__30732,G__30733));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__30614,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30734 = cljs.core.cst$kw$config;
var G__30735 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30734,G__30735) : pred__30723.call(null,G__30734,G__30735));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__30614,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30736 = cljs.core.cst$kw$leftmost_QMARK_;
var G__30737 = expr__30724;
return (pred__30723.cljs$core$IFn$_invoke$arity$2 ? pred__30723.cljs$core$IFn$_invoke$arity$2(G__30736,G__30737) : pred__30723.call(null,G__30736,G__30737));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__30614,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__30614),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__30614){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__30614,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__30618){
var extmap__4454__auto__ = (function (){var G__30738 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30618,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__30618)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30738);
} else {
return G__30738;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__30618),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__30618),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__30618),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__30618),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__30618),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__30618),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k30768,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__30772 = k30768;
var G__30772__$1 = (((G__30772 instanceof cljs.core.Keyword))?G__30772.fqn:null);
switch (G__30772__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30768,else__4418__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__30773){
var vec__30774 = p__30773;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30774,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30774,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30767){
var self__ = this;
var G__30767__$1 = this;
return (new cljs.core.RecordIter((0),G__30767__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30778){
var state_val_30779 = (state_30778[(1)]);
if((state_val_30779 === (1))){
var state_30778__$1 = state_30778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30778__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_30780 = [null,null,null,null,null,null,null];
(statearr_30780[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_30780[(1)] = (1));

return statearr_30780;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_30778){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30778);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30781){var ex__13886__auto__ = e30781;
var statearr_30782_30813 = state_30778;
(statearr_30782_30813[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30778[(4)]))){
var statearr_30783_30814 = state_30778;
(statearr_30783_30814[(1)] = cljs.core.first((state_30778[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30815 = state_30778;
state_30778 = G__30815;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_30778){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_30778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30784 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30784[(6)] = c__13957__auto__);

return statearr_30784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30790){
var state_val_30791 = (state_30790[(1)]);
if((state_val_30791 === (1))){
var inst_30785 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30786 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_30787 = cljs.core.PersistentHashMap.fromArrays(inst_30785,inst_30786);
var inst_30788 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_30787);
var state_30790__$1 = state_30790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30790__$1,inst_30788);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_30792 = [null,null,null,null,null,null,null];
(statearr_30792[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_30792[(1)] = (1));

return statearr_30792;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_30790){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30790);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30793){var ex__13886__auto__ = e30793;
var statearr_30794_30816 = state_30790;
(statearr_30794_30816[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30790[(4)]))){
var statearr_30795_30817 = state_30790;
(statearr_30795_30817[(1)] = cljs.core.first((state_30790[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30818 = state_30790;
state_30790 = G__30818;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_30790){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_30790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30796 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30796[(6)] = c__13957__auto__);

return statearr_30796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__30797 = (function (coll__4412__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__30797(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30769,other30770){
var self__ = this;
var this30769__$1 = this;
return (((!((other30770 == null)))) && ((this30769__$1.constructor === other30770.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.block,other30770.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.t,other30770.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.flakes,other30770.flakes)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.rhs,other30770.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.config,other30770.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30769__$1.__extmap,other30770.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__30767){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__30798 = cljs.core.keyword_identical_QMARK_;
var expr__30799 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__30801 = cljs.core.cst$kw$block;
var G__30802 = expr__30799;
return (pred__30798.cljs$core$IFn$_invoke$arity$2 ? pred__30798.cljs$core$IFn$_invoke$arity$2(G__30801,G__30802) : pred__30798.call(null,G__30801,G__30802));
})())){
return (new fluree.db.index.DataNode(G__30767,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30803 = cljs.core.cst$kw$t;
var G__30804 = expr__30799;
return (pred__30798.cljs$core$IFn$_invoke$arity$2 ? pred__30798.cljs$core$IFn$_invoke$arity$2(G__30803,G__30804) : pred__30798.call(null,G__30803,G__30804));
})())){
return (new fluree.db.index.DataNode(self__.block,G__30767,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30805 = cljs.core.cst$kw$flakes;
var G__30806 = expr__30799;
return (pred__30798.cljs$core$IFn$_invoke$arity$2 ? pred__30798.cljs$core$IFn$_invoke$arity$2(G__30805,G__30806) : pred__30798.call(null,G__30805,G__30806));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__30767,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30807 = cljs.core.cst$kw$rhs;
var G__30808 = expr__30799;
return (pred__30798.cljs$core$IFn$_invoke$arity$2 ? pred__30798.cljs$core$IFn$_invoke$arity$2(G__30807,G__30808) : pred__30798.call(null,G__30807,G__30808));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__30767,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30809 = cljs.core.cst$kw$config;
var G__30810 = expr__30799;
return (pred__30798.cljs$core$IFn$_invoke$arity$2 ? pred__30798.cljs$core$IFn$_invoke$arity$2(G__30809,G__30810) : pred__30798.call(null,G__30809,G__30810));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__30767,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__30767),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__30767){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__30767,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__30771){
var extmap__4454__auto__ = (function (){var G__30811 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30771,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__30771)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30811);
} else {
return G__30811;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__30771),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__30771),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__30771),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__30771),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__30771),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
