// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__39053 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39053,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39053,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39053,(2),null);
if(cljs.core.truth_((function (){var and__4149__auto__ = network;
if(cljs.core.truth_(and__4149__auto__)){
return maybe_alias;
} else {
return and__4149__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__39056){
var map__39057 = p__39056;
var map__39057__$1 = cljs.core.__destructure_map(map__39057);
var opts = map__39057__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39057__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39114){
var state_val_39115 = (state_39114[(1)]);
if((state_val_39115 === (7))){
var inst_39090 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_39091 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_39092 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_39093 = cljs.core.PersistentHashMap.fromArrays(inst_39091,inst_39092);
var inst_39094 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39090,inst_39093);
var inst_39095 = (function(){throw inst_39094})();
var state_39114__$1 = state_39114;
var statearr_39116_39136 = state_39114__$1;
(statearr_39116_39136[(2)] = inst_39095);

(statearr_39116_39136[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (1))){
var state_39114__$1 = state_39114;
var statearr_39117_39137 = state_39114__$1;
(statearr_39117_39137[(2)] = null);

(statearr_39117_39137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (4))){
var inst_39058 = (state_39114[(2)]);
var state_39114__$1 = state_39114;
var statearr_39118_39138 = state_39114__$1;
(statearr_39118_39138[(2)] = inst_39058);

(statearr_39118_39138[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (6))){
var inst_39078 = (state_39114[(7)]);
var inst_39072 = (state_39114[(8)]);
var inst_39071 = (state_39114[(2)]);
var inst_39072__$1 = fluree.db.util.async.throw_err(inst_39071);
var inst_39073 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_39074 = cljs.core.__destructure_map(inst_39073);
var inst_39075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39074,cljs.core.cst$kw$post);
var inst_39076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39074,cljs.core.cst$kw$size);
var inst_39077 = fluree.db.flake.size_bytes(inst_39072__$1);
var inst_39078__$1 = (inst_39076 + inst_39077);
var inst_39079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39080 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_39081 = (new cljs.core.PersistentVector(null,2,(5),inst_39079,inst_39080,null));
var inst_39082 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_39081);
var inst_39083 = cljs.core.__destructure_map(inst_39082);
var inst_39084 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39083,cljs.core.cst$kw$novelty_DASH_min);
var inst_39085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39083,cljs.core.cst$kw$novelty_DASH_max);
var inst_39086 = (inst_39078__$1 > inst_39085);
var inst_39087 = cljs.core.not(reindex_QMARK_);
var inst_39088 = ((inst_39086) && (inst_39087));
var state_39114__$1 = (function (){var statearr_39119 = state_39114;
(statearr_39119[(9)] = inst_39075);

(statearr_39119[(7)] = inst_39078__$1);

(statearr_39119[(10)] = inst_39084);

(statearr_39119[(8)] = inst_39072__$1);

return statearr_39119;
})();
if(cljs.core.truth_(inst_39088)){
var statearr_39120_39139 = state_39114__$1;
(statearr_39120_39139[(1)] = (7));

} else {
var statearr_39121_39140 = state_39114__$1;
(statearr_39121_39140[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (3))){
var inst_39112 = (state_39114[(2)]);
var state_39114__$1 = state_39114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39114__$1,inst_39112);
} else {
if((state_val_39115 === (2))){
var _ = (function (){var statearr_39123 = state_39114;
(statearr_39123[(4)] = cljs.core.cons((5),(state_39114[(4)])));

return statearr_39123;
})();
var inst_39066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39067 = [pred_id];
var inst_39068 = (new cljs.core.PersistentVector(null,1,(5),inst_39066,inst_39067,null));
var inst_39069 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_39068);
var state_39114__$1 = state_39114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39114__$1,(6),inst_39069);
} else {
if((state_val_39115 === (9))){
var inst_39075 = (state_39114[(9)]);
var inst_39078 = (state_39114[(7)]);
var inst_39072 = (state_39114[(8)]);
var inst_39098 = (state_39114[(2)]);
var inst_39099 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39075,inst_39072);
var inst_39100 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_39101 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_39100,cljs.core.empty);
var inst_39102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39103 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_39104 = (new cljs.core.PersistentVector(null,2,(5),inst_39102,inst_39103,null));
var inst_39105 = cljs.core.assoc_in(db,inst_39104,inst_39099);
var inst_39106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39107 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_39108 = (new cljs.core.PersistentVector(null,2,(5),inst_39106,inst_39107,null));
var inst_39109 = cljs.core.assoc_in(inst_39105,inst_39108,inst_39078);
var _ = (function (){var statearr_39124 = state_39114;
(statearr_39124[(4)] = cljs.core.rest((state_39114[(4)])));

return statearr_39124;
})();
var state_39114__$1 = (function (){var statearr_39125 = state_39114;
(statearr_39125[(11)] = inst_39098);

(statearr_39125[(12)] = inst_39101);

return statearr_39125;
})();
var statearr_39126_39141 = state_39114__$1;
(statearr_39126_39141[(2)] = inst_39109);

(statearr_39126_39141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (5))){
var _ = (function (){var statearr_39127 = state_39114;
(statearr_39127[(4)] = cljs.core.rest((state_39114[(4)])));

return statearr_39127;
})();
var state_39114__$1 = state_39114;
var ex39122 = (state_39114__$1[(2)]);
var statearr_39128_39142 = state_39114__$1;
(statearr_39128_39142[(5)] = ex39122);


if((ex39122 instanceof Error)){
var statearr_39129_39143 = state_39114__$1;
(statearr_39129_39143[(1)] = (4));

(statearr_39129_39143[(5)] = null);

} else {
throw ex39122;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39115 === (8))){
var state_39114__$1 = state_39114;
var statearr_39130_39144 = state_39114__$1;
(statearr_39130_39144[(2)] = null);

(statearr_39130_39144[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0 = (function (){
var statearr_39131 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39131[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__);

(statearr_39131[(1)] = (1));

return statearr_39131;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1 = (function (state_39114){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39114);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39132){var ex__13886__auto__ = e39132;
var statearr_39133_39145 = state_39114;
(statearr_39133_39145[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39114[(4)]))){
var statearr_39134_39146 = state_39114;
(statearr_39134_39146[(1)] = cljs.core.first((state_39114[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39147 = state_39114;
state_39114 = G__39147;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__ = function(state_39114){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1.call(this,state_39114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39135 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39135[(6)] = c__13957__auto__);

return statearr_39135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__39152 = arguments.length;
switch (G__39152) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39348){
var state_val_39349 = (state_39348[(1)]);
if((state_val_39349 === (7))){
var state_39348__$1 = state_39348;
var statearr_39350_39418 = state_39348__$1;
(statearr_39350_39418[(2)] = null);

(statearr_39350_39418[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (20))){
var inst_39270 = (state_39348[(7)]);
var inst_39273 = (state_39348[(8)]);
var inst_39274 = (state_39348[(9)]);
var inst_39241 = (state_39348[(10)]);
var inst_39272 = (state_39348[(11)]);
var inst_39191 = (state_39348[(12)]);
var inst_39271 = (state_39348[(13)]);
var inst_39190 = (state_39348[(14)]);
var inst_39284 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_39285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39286 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_39287 = (new cljs.core.PersistentVector(null,2,(5),inst_39285,inst_39286,null));
var inst_39288 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39241,inst_39287);
var inst_39289 = (inst_39190 + inst_39288);
var inst_39290 = [inst_39270,inst_39271,inst_39272,inst_39273,inst_39289];
var inst_39291 = cljs.core.PersistentHashMap.fromArrays(inst_39284,inst_39290);
var inst_39292 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_39241,cljs.core.cst$kw$ecount,inst_39274,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_39291], 0));
var state_39348__$1 = (function (){var statearr_39351 = state_39348;
(statearr_39351[(15)] = inst_39292);

return statearr_39351;
})();
if(cljs.core.truth_(inst_39191)){
var statearr_39352_39419 = state_39348__$1;
(statearr_39352_39419[(1)] = (23));

} else {
var statearr_39353_39420 = state_39348__$1;
(statearr_39353_39420[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (27))){
var inst_39292 = (state_39348[(15)]);
var state_39348__$1 = state_39348;
var statearr_39354_39421 = state_39348__$1;
(statearr_39354_39421[(2)] = inst_39292);

(statearr_39354_39421[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (1))){
var state_39348__$1 = state_39348;
var statearr_39355_39422 = state_39348__$1;
(statearr_39355_39422[(2)] = null);

(statearr_39355_39422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (24))){
var inst_39292 = (state_39348[(15)]);
var inst_39295 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_39292);
var inst_39296 = (inst_39295 == null);
var state_39348__$1 = state_39348;
var statearr_39356_39423 = state_39348__$1;
(statearr_39356_39423[(2)] = inst_39296);

(statearr_39356_39423[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (39))){
var inst_39281 = (state_39348[(16)]);
var inst_39331 = (state_39348[(17)]);
var inst_39323 = (state_39348[(18)]);
var inst_39324 = (state_39348[(19)]);
var inst_39322 = (state_39348[(20)]);
var inst_39338 = (state_39348[(2)]);
var inst_39269 = inst_39281;
var inst_39270 = inst_39323;
var inst_39271 = inst_39324;
var inst_39272 = inst_39331;
var inst_39273 = inst_39338;
var inst_39274 = inst_39322;
var state_39348__$1 = (function (){var statearr_39357 = state_39348;
(statearr_39357[(7)] = inst_39270);

(statearr_39357[(8)] = inst_39273);

(statearr_39357[(9)] = inst_39274);

(statearr_39357[(11)] = inst_39272);

(statearr_39357[(21)] = inst_39269);

(statearr_39357[(13)] = inst_39271);

return statearr_39357;
})();
var statearr_39358_39424 = state_39348__$1;
(statearr_39358_39424[(2)] = null);

(statearr_39358_39424[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (4))){
var inst_39153 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
var statearr_39359_39425 = state_39348__$1;
(statearr_39359_39425[(2)] = inst_39153);

(statearr_39359_39425[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (15))){
var inst_39213 = (state_39348[(22)]);
var state_39348__$1 = state_39348;
var statearr_39360_39426 = state_39348__$1;
(statearr_39360_39426[(2)] = inst_39213);

(statearr_39360_39426[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (21))){
var inst_39281 = (state_39348[(16)]);
var inst_39192 = (state_39348[(23)]);
var inst_39270 = (state_39348[(7)]);
var inst_39250 = (state_39348[(24)]);
var inst_39273 = (state_39348[(8)]);
var inst_39274 = (state_39348[(9)]);
var inst_39280 = (state_39348[(25)]);
var inst_39185 = (state_39348[(26)]);
var inst_39160 = (state_39348[(27)]);
var inst_39251 = (state_39348[(28)]);
var inst_39194 = (state_39348[(29)]);
var inst_39241 = (state_39348[(10)]);
var inst_39175 = (state_39348[(30)]);
var inst_39189 = (state_39348[(31)]);
var inst_39272 = (state_39348[(11)]);
var inst_39191 = (state_39348[(12)]);
var inst_39177 = (state_39348[(32)]);
var inst_39200 = (state_39348[(33)]);
var inst_39269 = (state_39348[(21)]);
var inst_39271 = (state_39348[(13)]);
var inst_39190 = (state_39348[(14)]);
var inst_39181 = (state_39348[(34)]);
var inst_39319 = inst_39280.s;
var inst_39320 = fluree.db.flake.sid__GT_cid(inst_39319);
var inst_39321 = (function (){var flakes_bytes = inst_39190;
var t = inst_39160;
var G__39245 = inst_39269;
var spot = inst_39270;
var add_flakes = inst_39177;
var root_setting_change_QMARK_ = inst_39192;
var seq__39247 = inst_39251;
var ref_QMARK__map = inst_39189;
var r = inst_39281;
var psot = inst_39271;
var first__39248 = inst_39250;
var add_pred_to_idx_QMARK_ = inst_39200;
var first__39278 = inst_39280;
var _ = inst_39175;
var cid = inst_39320;
var ecount = inst_39274;
var pred_ecount = inst_39194;
var db_STAR_ = inst_39241;
var schema_change_QMARK_ = inst_39191;
var vec__39246 = inst_39177;
var add_preds = inst_39181;
var opst = inst_39273;
var idx_QMARK__map = inst_39185;
var post = inst_39272;
var vec__39276 = inst_39269;
var seq__39277 = inst_39281;
var f = inst_39280;
return (function (p1__39150_SHARP_){
if(cljs.core.truth_(p1__39150_SHARP_)){
var x__4249__auto__ = p1__39150_SHARP_;
var y__4250__auto__ = f.s;
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
} else {
return f.s;
}
});
})();
var inst_39322 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_39274,inst_39320,inst_39321);
var inst_39323 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39270,inst_39280);
var inst_39324 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39271,inst_39280);
var inst_39325 = inst_39280.p;
var inst_39326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39185,inst_39325);
var state_39348__$1 = (function (){var statearr_39361 = state_39348;
(statearr_39361[(18)] = inst_39323);

(statearr_39361[(19)] = inst_39324);

(statearr_39361[(20)] = inst_39322);

return statearr_39361;
})();
if(cljs.core.truth_(inst_39326)){
var statearr_39362_39427 = state_39348__$1;
(statearr_39362_39427[(1)] = (34));

} else {
var statearr_39363_39428 = state_39348__$1;
(statearr_39363_39428[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (31))){
var inst_39307 = (state_39348[(35)]);
var state_39348__$1 = state_39348;
var statearr_39364_39429 = state_39348__$1;
(statearr_39364_39429[(2)] = inst_39307);

(statearr_39364_39429[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (32))){
var inst_39317 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
var statearr_39365_39430 = state_39348__$1;
(statearr_39365_39430[(2)] = inst_39317);

(statearr_39365_39430[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (33))){
var inst_39307 = (state_39348[(35)]);
var inst_39312 = (state_39348[(2)]);
var inst_39313 = fluree.db.util.async.throw_err(inst_39312);
var inst_39314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39307,cljs.core.cst$kw$settings,inst_39313);
var state_39348__$1 = state_39348;
var statearr_39366_39431 = state_39348__$1;
(statearr_39366_39431[(2)] = inst_39314);

(statearr_39366_39431[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (13))){
var inst_39160 = (state_39348[(27)]);
var inst_39241 = (state_39348[(10)]);
var inst_39177 = (state_39348[(32)]);
var inst_39190 = (state_39348[(14)]);
var inst_39231 = (state_39348[(2)]);
var inst_39232 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39231,cljs.core.cst$kw$t,inst_39160);
var inst_39233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39234 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_39235 = (new cljs.core.PersistentVector(null,2,(5),inst_39233,inst_39234,null));
var inst_39236 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_39232,inst_39235,cljs.core._PLUS_,inst_39190);
var inst_39237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39238 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_39239 = (new cljs.core.PersistentVector(null,2,(5),inst_39237,inst_39238,null));
var inst_39240 = cljs.core.count(inst_39177);
var inst_39241__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_39236,inst_39239,cljs.core._PLUS_,inst_39240);
var inst_39249 = cljs.core.seq(inst_39177);
var inst_39250 = cljs.core.first(inst_39249);
var inst_39251 = cljs.core.next(inst_39249);
var inst_39252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39253 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_39254 = (new cljs.core.PersistentVector(null,2,(5),inst_39252,inst_39253,null));
var inst_39255 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39241__$1,inst_39254);
var inst_39256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39257 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_39258 = (new cljs.core.PersistentVector(null,2,(5),inst_39256,inst_39257,null));
var inst_39259 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39241__$1,inst_39258);
var inst_39260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39261 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_39262 = (new cljs.core.PersistentVector(null,2,(5),inst_39260,inst_39261,null));
var inst_39263 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39241__$1,inst_39262);
var inst_39264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39265 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_39266 = (new cljs.core.PersistentVector(null,2,(5),inst_39264,inst_39265,null));
var inst_39267 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39241__$1,inst_39266);
var inst_39268 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_39269 = inst_39177;
var inst_39270 = inst_39255;
var inst_39271 = inst_39259;
var inst_39272 = inst_39263;
var inst_39273 = inst_39267;
var inst_39274 = inst_39268;
var state_39348__$1 = (function (){var statearr_39367 = state_39348;
(statearr_39367[(7)] = inst_39270);

(statearr_39367[(24)] = inst_39250);

(statearr_39367[(8)] = inst_39273);

(statearr_39367[(9)] = inst_39274);

(statearr_39367[(28)] = inst_39251);

(statearr_39367[(10)] = inst_39241__$1);

(statearr_39367[(11)] = inst_39272);

(statearr_39367[(21)] = inst_39269);

(statearr_39367[(13)] = inst_39271);

return statearr_39367;
})();
var statearr_39368_39432 = state_39348__$1;
(statearr_39368_39432[(2)] = null);

(statearr_39368_39432[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (22))){
var inst_39341 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
var statearr_39369_39433 = state_39348__$1;
(statearr_39369_39433[(2)] = inst_39341);

(statearr_39369_39433[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (36))){
var inst_39280 = (state_39348[(25)]);
var inst_39189 = (state_39348[(31)]);
var inst_39331 = (state_39348[(2)]);
var inst_39332 = inst_39280.p;
var inst_39333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39189,inst_39332);
var state_39348__$1 = (function (){var statearr_39370 = state_39348;
(statearr_39370[(17)] = inst_39331);

return statearr_39370;
})();
if(cljs.core.truth_(inst_39333)){
var statearr_39371_39434 = state_39348__$1;
(statearr_39371_39434[(1)] = (37));

} else {
var statearr_39372_39435 = state_39348__$1;
(statearr_39372_39435[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (29))){
var inst_39292 = (state_39348[(15)]);
var inst_39302 = (state_39348[(2)]);
var inst_39303 = fluree.db.util.async.throw_err(inst_39302);
var inst_39304 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39292,cljs.core.cst$kw$schema,inst_39303);
var state_39348__$1 = state_39348;
var statearr_39373_39436 = state_39348__$1;
(statearr_39373_39436[(2)] = inst_39304);

(statearr_39373_39436[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (6))){
var inst_39160 = (state_39348[(27)]);
var inst_39165 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_39166 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_39167 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39165)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39166)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39160),"."].join('');
var inst_39168 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39169 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_39170 = cljs.core.PersistentHashMap.fromArrays(inst_39168,inst_39169);
var inst_39171 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39167,inst_39170);
var inst_39172 = (function(){throw inst_39171})();
var state_39348__$1 = state_39348;
var statearr_39374_39437 = state_39348__$1;
(statearr_39374_39437[(2)] = inst_39172);

(statearr_39374_39437[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (28))){
var inst_39192 = (state_39348[(23)]);
var inst_39307 = (state_39348[(2)]);
var state_39348__$1 = (function (){var statearr_39375 = state_39348;
(statearr_39375[(35)] = inst_39307);

return statearr_39375;
})();
if(cljs.core.truth_(inst_39192)){
var statearr_39376_39438 = state_39348__$1;
(statearr_39376_39438[(1)] = (30));

} else {
var statearr_39377_39439 = state_39348__$1;
(statearr_39377_39439[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (25))){
var inst_39298 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
if(cljs.core.truth_(inst_39298)){
var statearr_39378_39440 = state_39348__$1;
(statearr_39378_39440[(1)] = (26));

} else {
var statearr_39379_39441 = state_39348__$1;
(statearr_39379_39441[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (34))){
var inst_39280 = (state_39348[(25)]);
var inst_39272 = (state_39348[(11)]);
var inst_39328 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39272,inst_39280);
var state_39348__$1 = state_39348;
var statearr_39380_39442 = state_39348__$1;
(statearr_39380_39442[(2)] = inst_39328);

(statearr_39380_39442[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (17))){
var inst_39220 = (state_39348[(36)]);
var inst_39224 = (state_39348[(2)]);
var inst_39225 = fluree.db.util.async.throw_err(inst_39224);
var inst_39212 = inst_39220;
var inst_39213 = inst_39225;
var state_39348__$1 = (function (){var statearr_39381 = state_39348;
(statearr_39381[(37)] = inst_39212);

(statearr_39381[(22)] = inst_39213);

return statearr_39381;
})();
var statearr_39382_39443 = state_39348__$1;
(statearr_39382_39443[(2)] = null);

(statearr_39382_39443[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (3))){
var inst_39346 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39348__$1,inst_39346);
} else {
if((state_val_39349 === (12))){
var inst_39219 = (state_39348[(38)]);
var inst_39212 = (state_39348[(37)]);
var inst_39218 = cljs.core.seq(inst_39212);
var inst_39219__$1 = cljs.core.first(inst_39218);
var inst_39220 = cljs.core.next(inst_39218);
var state_39348__$1 = (function (){var statearr_39383 = state_39348;
(statearr_39383[(36)] = inst_39220);

(statearr_39383[(38)] = inst_39219__$1);

return statearr_39383;
})();
if(cljs.core.truth_(inst_39219__$1)){
var statearr_39384_39444 = state_39348__$1;
(statearr_39384_39444[(1)] = (14));

} else {
var statearr_39385_39445 = state_39348__$1;
(statearr_39385_39445[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (2))){
var inst_39160 = (state_39348[(27)]);
var _ = (function (){var statearr_39386 = state_39348;
(statearr_39386[(4)] = cljs.core.cons((5),(state_39348[(4)])));

return statearr_39386;
})();
var inst_39159 = cljs.core.first(flakes);
var inst_39160__$1 = inst_39159.t;
var inst_39161 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_39162 = (inst_39161 - (1));
var inst_39163 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_39160__$1,inst_39162);
var state_39348__$1 = (function (){var statearr_39387 = state_39348;
(statearr_39387[(27)] = inst_39160__$1);

return statearr_39387;
})();
if(inst_39163){
var statearr_39388_39446 = state_39348__$1;
(statearr_39388_39446[(1)] = (6));

} else {
var statearr_39389_39447 = state_39348__$1;
(statearr_39389_39447[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (23))){
var inst_39191 = (state_39348[(12)]);
var state_39348__$1 = state_39348;
var statearr_39390_39448 = state_39348__$1;
(statearr_39390_39448[(2)] = inst_39191);

(statearr_39390_39448[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (35))){
var inst_39272 = (state_39348[(11)]);
var state_39348__$1 = state_39348;
var statearr_39391_39449 = state_39348__$1;
(statearr_39391_39449[(2)] = inst_39272);

(statearr_39391_39449[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (19))){
var inst_39343 = (state_39348[(2)]);
var _ = (function (){var statearr_39392 = state_39348;
(statearr_39392[(4)] = cljs.core.rest((state_39348[(4)])));

return statearr_39392;
})();
var state_39348__$1 = state_39348;
var statearr_39393_39450 = state_39348__$1;
(statearr_39393_39450[(2)] = inst_39343);

(statearr_39393_39450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (11))){
var inst_39200 = (state_39348[(33)]);
var inst_39200__$1 = (state_39348[(2)]);
var inst_39208 = cljs.core.seq(inst_39200__$1);
var inst_39209 = cljs.core.first(inst_39208);
var inst_39210 = cljs.core.next(inst_39208);
var inst_39211 = db;
var inst_39212 = inst_39200__$1;
var inst_39213 = inst_39211;
var state_39348__$1 = (function (){var statearr_39395 = state_39348;
(statearr_39395[(37)] = inst_39212);

(statearr_39395[(39)] = inst_39209);

(statearr_39395[(22)] = inst_39213);

(statearr_39395[(33)] = inst_39200__$1);

(statearr_39395[(40)] = inst_39210);

return statearr_39395;
})();
var statearr_39396_39451 = state_39348__$1;
(statearr_39396_39451[(2)] = null);

(statearr_39396_39451[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (9))){
var inst_39194 = (state_39348[(29)]);
var inst_39177 = (state_39348[(32)]);
var inst_39196 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_39177,inst_39194);
var state_39348__$1 = state_39348;
var statearr_39397_39452 = state_39348__$1;
(statearr_39397_39452[(2)] = inst_39196);

(statearr_39397_39452[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (5))){
var _ = (function (){var statearr_39398 = state_39348;
(statearr_39398[(4)] = cljs.core.rest((state_39348[(4)])));

return statearr_39398;
})();
var state_39348__$1 = state_39348;
var ex39394 = (state_39348__$1[(2)]);
var statearr_39399_39453 = state_39348__$1;
(statearr_39399_39453[(5)] = ex39394);


if((ex39394 instanceof Error)){
var statearr_39400_39454 = state_39348__$1;
(statearr_39400_39454[(1)] = (4));

(statearr_39400_39454[(5)] = null);

} else {
throw ex39394;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (14))){
var inst_39219 = (state_39348[(38)]);
var inst_39213 = (state_39348[(22)]);
var inst_39222 = fluree.db.graphdb.add_predicate_to_idx(inst_39213,inst_39219,opts);
var state_39348__$1 = state_39348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39348__$1,(17),inst_39222);
} else {
if((state_val_39349 === (26))){
var inst_39292 = (state_39348[(15)]);
var inst_39300 = fluree.db.query.schema.schema_map(inst_39292);
var state_39348__$1 = state_39348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39348__$1,(29),inst_39300);
} else {
if((state_val_39349 === (16))){
var inst_39229 = (state_39348[(2)]);
var state_39348__$1 = state_39348;
var statearr_39401_39455 = state_39348__$1;
(statearr_39401_39455[(2)] = inst_39229);

(statearr_39401_39455[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (38))){
var inst_39273 = (state_39348[(8)]);
var state_39348__$1 = state_39348;
var statearr_39402_39456 = state_39348__$1;
(statearr_39402_39456[(2)] = inst_39273);

(statearr_39402_39456[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (30))){
var inst_39307 = (state_39348[(35)]);
var inst_39310 = fluree.db.query.schema.setting_map(inst_39307);
var state_39348__$1 = state_39348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39348__$1,(33),inst_39310);
} else {
if((state_val_39349 === (10))){
var inst_39198 = cljs.core.PersistentVector.EMPTY;
var state_39348__$1 = state_39348;
var statearr_39403_39457 = state_39348__$1;
(statearr_39403_39457[(2)] = inst_39198);

(statearr_39403_39457[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (18))){
var inst_39280 = (state_39348[(25)]);
var inst_39269 = (state_39348[(21)]);
var inst_39279 = cljs.core.seq(inst_39269);
var inst_39280__$1 = cljs.core.first(inst_39279);
var inst_39281 = cljs.core.next(inst_39279);
var inst_39282 = cljs.core.not(inst_39280__$1);
var state_39348__$1 = (function (){var statearr_39404 = state_39348;
(statearr_39404[(16)] = inst_39281);

(statearr_39404[(25)] = inst_39280__$1);

return statearr_39404;
})();
if(inst_39282){
var statearr_39405_39458 = state_39348__$1;
(statearr_39405_39458[(1)] = (20));

} else {
var statearr_39406_39459 = state_39348__$1;
(statearr_39406_39459[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (37))){
var inst_39273 = (state_39348[(8)]);
var inst_39280 = (state_39348[(25)]);
var inst_39335 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39273,inst_39280);
var state_39348__$1 = state_39348;
var statearr_39407_39460 = state_39348__$1;
(statearr_39407_39460[(2)] = inst_39335);

(statearr_39407_39460[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39349 === (8))){
var inst_39185 = (state_39348[(26)]);
var inst_39160 = (state_39348[(27)]);
var inst_39175 = (state_39348[(30)]);
var inst_39191 = (state_39348[(12)]);
var inst_39177 = (state_39348[(32)]);
var inst_39181 = (state_39348[(34)]);
var inst_39175__$1 = (state_39348[(2)]);
var inst_39176 = (function (){var t = inst_39160;
var _ = inst_39175__$1;
return (function (p1__39148_SHARP_){
return cljs.core.not((function (){var G__39408 = p1__39148_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__39408) : fluree.db.graphdb.exclude_predicates.call(null,G__39408));
})());
});
})();
var inst_39177__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_39176,flakes);
var inst_39178 = cljs.core.PersistentHashSet.EMPTY;
var inst_39179 = (function (){var t = inst_39160;
var _ = inst_39175__$1;
var add_flakes = inst_39177__$1;
return (function (p1__39149_SHARP_){
return p1__39149_SHARP_.p;
});
})();
var inst_39180 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39179,inst_39177__$1);
var inst_39181__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39178,inst_39180);
var inst_39182 = cljs.core.PersistentHashMap.EMPTY;
var inst_39183 = (function (){var t = inst_39160;
var _ = inst_39175__$1;
var add_flakes = inst_39177__$1;
var add_preds = inst_39181__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_39184 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39183,inst_39181__$1);
var inst_39185__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39182,inst_39184);
var inst_39186 = cljs.core.PersistentHashMap.EMPTY;
var inst_39187 = (function (){var t = inst_39160;
var _ = inst_39175__$1;
var add_flakes = inst_39177__$1;
var add_preds = inst_39181__$1;
var idx_QMARK__map = inst_39185__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_39188 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39187,inst_39181__$1);
var inst_39189 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39186,inst_39188);
var inst_39190 = fluree.db.flake.size_bytes(inst_39177__$1);
var inst_39191__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_39177__$1);
var inst_39192 = fluree.db.util.schema.setting_change_QMARK_(inst_39177__$1);
var inst_39193 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_39194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39193,(0));
var state_39348__$1 = (function (){var statearr_39409 = state_39348;
(statearr_39409[(23)] = inst_39192);

(statearr_39409[(26)] = inst_39185__$1);

(statearr_39409[(29)] = inst_39194);

(statearr_39409[(30)] = inst_39175__$1);

(statearr_39409[(31)] = inst_39189);

(statearr_39409[(12)] = inst_39191__$1);

(statearr_39409[(32)] = inst_39177__$1);

(statearr_39409[(14)] = inst_39190);

(statearr_39409[(34)] = inst_39181__$1);

return statearr_39409;
})();
if(cljs.core.truth_(inst_39191__$1)){
var statearr_39410_39461 = state_39348__$1;
(statearr_39410_39461[(1)] = (9));

} else {
var statearr_39411_39462 = state_39348__$1;
(statearr_39411_39462[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39412 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39412[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39412[(1)] = (1));

return statearr_39412;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39348){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39348);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39413){var ex__13886__auto__ = e39413;
var statearr_39414_39463 = state_39348;
(statearr_39414_39463[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39348[(4)]))){
var statearr_39415_39464 = state_39348;
(statearr_39415_39464[(1)] = cljs.core.first((state_39348[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39465 = state_39348;
state_39348 = G__39465;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39348){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39416 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39416[(6)] = c__13957__auto__);

return statearr_39416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__39467 = arguments.length;
switch (G__39467) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___39614 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39563){
var state_val_39564 = (state_39563[(1)]);
if((state_val_39564 === (7))){
var state_39563__$1 = state_39563;
var statearr_39565_39615 = state_39563__$1;
(statearr_39565_39615[(2)] = null);

(statearr_39565_39615[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (20))){
var inst_39512 = (state_39563[(7)]);
var inst_39513 = (state_39563[(8)]);
var inst_39511 = (state_39563[(9)]);
var inst_39532 = (inst_39511 + (1));
var inst_39533 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39513,cljs.core.cst$kw$t,inst_39532);
var inst_39534 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_39533,inst_39512,opts);
var state_39563__$1 = state_39563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39563__$1,(23),inst_39534);
} else {
if((state_val_39564 === (1))){
var state_39563__$1 = state_39563;
var statearr_39566_39616 = state_39563__$1;
(statearr_39566_39616[(2)] = null);

(statearr_39566_39616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (24))){
var inst_39537 = (state_39563[(10)]);
var inst_39540 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39537,cljs.core.cst$kw$block,block);
var state_39563__$1 = state_39563;
var statearr_39567_39617 = state_39563__$1;
(statearr_39567_39617[(2)] = inst_39540);

(statearr_39567_39617[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (4))){
var inst_39468 = (state_39563[(2)]);
var inst_39469 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39468);
var state_39563__$1 = state_39563;
var statearr_39568_39618 = state_39563__$1;
(statearr_39568_39618[(2)] = inst_39469);

(statearr_39568_39618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (15))){
var inst_39519 = (state_39563[(11)]);
var state_39563__$1 = state_39563;
var statearr_39569_39619 = state_39563__$1;
(statearr_39569_39619[(2)] = inst_39519);

(statearr_39569_39619[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (21))){
var state_39563__$1 = state_39563;
var statearr_39570_39620 = state_39563__$1;
(statearr_39570_39620[(2)] = null);

(statearr_39570_39620[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (13))){
var inst_39555 = (state_39563[(2)]);
var inst_39556 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39555);
var state_39563__$1 = state_39563;
var statearr_39571_39621 = state_39563__$1;
(statearr_39571_39621[(2)] = inst_39556);

(statearr_39571_39621[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (22))){
var inst_39551 = (state_39563[(2)]);
var state_39563__$1 = state_39563;
var statearr_39572_39622 = state_39563__$1;
(statearr_39572_39622[(2)] = inst_39551);

(statearr_39572_39622[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (6))){
var inst_39479 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_39480 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_39481 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39479)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39480)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_39482 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39483 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_39484 = cljs.core.PersistentHashMap.fromArrays(inst_39482,inst_39483);
var inst_39485 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39481,inst_39484);
var inst_39486 = (function(){throw inst_39485})();
var state_39563__$1 = state_39563;
var statearr_39575_39623 = state_39563__$1;
(statearr_39575_39623[(2)] = inst_39486);

(statearr_39575_39623[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (25))){
var inst_39520 = (state_39563[(12)]);
var inst_39537 = (state_39563[(10)]);
var inst_39519 = (state_39563[(11)]);
var inst_39542 = inst_39519.t;
var inst_39543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39544 = [inst_39519];
var inst_39545 = (new cljs.core.PersistentVector(null,1,(5),inst_39543,inst_39544,null));
var inst_39510 = inst_39520;
var inst_39511 = inst_39542;
var inst_39512 = inst_39545;
var inst_39513 = inst_39537;
var state_39563__$1 = (function (){var statearr_39576 = state_39563;
(statearr_39576[(13)] = inst_39510);

(statearr_39576[(7)] = inst_39512);

(statearr_39576[(8)] = inst_39513);

(statearr_39576[(9)] = inst_39511);

return statearr_39576;
})();
var statearr_39577_39624 = state_39563__$1;
(statearr_39577_39624[(2)] = null);

(statearr_39577_39624[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (17))){
var inst_39520 = (state_39563[(12)]);
var inst_39519 = (state_39563[(11)]);
var inst_39512 = (state_39563[(7)]);
var inst_39513 = (state_39563[(8)]);
var inst_39511 = (state_39563[(9)]);
var inst_39528 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39512,inst_39519);
var tmp39573 = inst_39513;
var tmp39574 = inst_39511;
var inst_39510 = inst_39520;
var inst_39511__$1 = tmp39574;
var inst_39512__$1 = inst_39528;
var inst_39513__$1 = tmp39573;
var state_39563__$1 = (function (){var statearr_39578 = state_39563;
(statearr_39578[(13)] = inst_39510);

(statearr_39578[(7)] = inst_39512__$1);

(statearr_39578[(8)] = inst_39513__$1);

(statearr_39578[(9)] = inst_39511__$1);

return statearr_39578;
})();
var statearr_39579_39625 = state_39563__$1;
(statearr_39579_39625[(2)] = null);

(statearr_39579_39625[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (3))){
var inst_39561 = (state_39563[(2)]);
var state_39563__$1 = state_39563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39563__$1,inst_39561);
} else {
if((state_val_39564 === (12))){
var inst_39510 = (state_39563[(13)]);
var inst_39519 = (state_39563[(11)]);
var inst_39518 = cljs.core.seq(inst_39510);
var inst_39519__$1 = cljs.core.first(inst_39518);
var inst_39520 = cljs.core.next(inst_39518);
var state_39563__$1 = (function (){var statearr_39580 = state_39563;
(statearr_39580[(12)] = inst_39520);

(statearr_39580[(11)] = inst_39519__$1);

return statearr_39580;
})();
if(cljs.core.truth_(inst_39519__$1)){
var statearr_39581_39626 = state_39563__$1;
(statearr_39581_39626[(1)] = (14));

} else {
var statearr_39582_39627 = state_39563__$1;
(statearr_39582_39627[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (2))){
var _ = (function (){var statearr_39583 = state_39563;
(statearr_39583[(4)] = cljs.core.cons((5),(state_39563[(4)])));

return statearr_39583;
})();
var inst_39475 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_39476 = (inst_39475 + (1));
var inst_39477 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_39476);
var state_39563__$1 = state_39563;
if(inst_39477){
var statearr_39584_39628 = state_39563__$1;
(statearr_39584_39628[(1)] = (6));

} else {
var statearr_39585_39629 = state_39563__$1;
(statearr_39585_39629[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (23))){
var inst_39519 = (state_39563[(11)]);
var inst_39536 = (state_39563[(2)]);
var inst_39537 = fluree.db.util.async.throw_err(inst_39536);
var inst_39538 = (inst_39519 == null);
var state_39563__$1 = (function (){var statearr_39586 = state_39563;
(statearr_39586[(10)] = inst_39537);

return statearr_39586;
})();
if(cljs.core.truth_(inst_39538)){
var statearr_39587_39630 = state_39563__$1;
(statearr_39587_39630[(1)] = (24));

} else {
var statearr_39588_39631 = state_39563__$1;
(statearr_39588_39631[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (19))){
var inst_39553 = (state_39563[(2)]);
var state_39563__$1 = state_39563;
var statearr_39589_39632 = state_39563__$1;
(statearr_39589_39632[(2)] = inst_39553);

(statearr_39589_39632[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (11))){
var inst_39558 = (state_39563[(2)]);
var _ = (function (){var statearr_39591 = state_39563;
(statearr_39591[(4)] = cljs.core.rest((state_39563[(4)])));

return statearr_39591;
})();
var state_39563__$1 = state_39563;
var statearr_39592_39633 = state_39563__$1;
(statearr_39592_39633[(2)] = inst_39558);

(statearr_39592_39633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (9))){
var inst_39492 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_39493 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39492);
var state_39563__$1 = state_39563;
var statearr_39593_39634 = state_39563__$1;
(statearr_39593_39634[(2)] = inst_39493);

(statearr_39593_39634[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (5))){
var _ = (function (){var statearr_39594 = state_39563;
(statearr_39594[(4)] = cljs.core.rest((state_39563[(4)])));

return statearr_39594;
})();
var state_39563__$1 = state_39563;
var ex39590 = (state_39563__$1[(2)]);
var statearr_39595_39635 = state_39563__$1;
(statearr_39595_39635[(5)] = ex39590);


var statearr_39596_39636 = state_39563__$1;
(statearr_39596_39636[(1)] = (4));

(statearr_39596_39636[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (14))){
var inst_39519 = (state_39563[(11)]);
var inst_39511 = (state_39563[(9)]);
var inst_39522 = inst_39519.t;
var inst_39523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39511,inst_39522);
var state_39563__$1 = state_39563;
var statearr_39597_39637 = state_39563__$1;
(statearr_39597_39637[(2)] = inst_39523);

(statearr_39597_39637[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (26))){
var inst_39548 = (state_39563[(2)]);
var state_39563__$1 = state_39563;
var statearr_39598_39638 = state_39563__$1;
(statearr_39598_39638[(2)] = inst_39548);

(statearr_39598_39638[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (16))){
var inst_39526 = (state_39563[(2)]);
var state_39563__$1 = state_39563;
if(cljs.core.truth_(inst_39526)){
var statearr_39599_39639 = state_39563__$1;
(statearr_39599_39639[(1)] = (17));

} else {
var statearr_39600_39640 = state_39563__$1;
(statearr_39600_39640[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (10))){
var inst_39495 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_39503 = cljs.core.seq(inst_39495);
var inst_39504 = cljs.core.first(inst_39503);
var inst_39505 = cljs.core.next(inst_39503);
var inst_39506 = cljs.core.first(inst_39495);
var inst_39507 = inst_39506.t;
var inst_39508 = cljs.core.PersistentVector.EMPTY;
var inst_39509 = db;
var inst_39510 = inst_39495;
var inst_39511 = inst_39507;
var inst_39512 = inst_39508;
var inst_39513 = inst_39509;
var state_39563__$1 = (function (){var statearr_39601 = state_39563;
(statearr_39601[(13)] = inst_39510);

(statearr_39601[(14)] = inst_39505);

(statearr_39601[(15)] = inst_39504);

(statearr_39601[(7)] = inst_39512);

(statearr_39601[(8)] = inst_39513);

(statearr_39601[(9)] = inst_39511);

return statearr_39601;
})();
var statearr_39602_39641 = state_39563__$1;
(statearr_39602_39641[(2)] = null);

(statearr_39602_39641[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (18))){
var state_39563__$1 = state_39563;
var statearr_39603_39642 = state_39563__$1;
(statearr_39603_39642[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39564 === (8))){
var inst_39489 = (state_39563[(2)]);
var inst_39490 = cljs.core.empty_QMARK_(flakes);
var state_39563__$1 = (function (){var statearr_39605 = state_39563;
(statearr_39605[(16)] = inst_39489);

return statearr_39605;
})();
if(inst_39490){
var statearr_39606_39643 = state_39563__$1;
(statearr_39606_39643[(1)] = (9));

} else {
var statearr_39607_39644 = state_39563__$1;
(statearr_39607_39644[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39608[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39608[(1)] = (1));

return statearr_39608;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39563){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39563);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39609){var ex__13886__auto__ = e39609;
var statearr_39610_39645 = state_39563;
(statearr_39610_39645[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39563[(4)]))){
var statearr_39611_39646 = state_39563;
(statearr_39611_39646[(1)] = cljs.core.first((state_39563[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39647 = state_39563;
state_39563 = G__39647;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39563){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39612 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39612[(6)] = c__13957__auto___39614);

return statearr_39612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39703){
var state_val_39704 = (state_39703[(1)]);
if((state_val_39704 === (7))){
var state_39703__$1 = state_39703;
var statearr_39705_39732 = state_39703__$1;
(statearr_39705_39732[(2)] = tt_id);

(statearr_39705_39732[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (1))){
var state_39703__$1 = state_39703;
var statearr_39706_39733 = state_39703__$1;
(statearr_39706_39733[(2)] = null);

(statearr_39706_39733[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (4))){
var inst_39648 = (state_39703[(2)]);
var state_39703__$1 = state_39703;
var statearr_39707_39734 = state_39703__$1;
(statearr_39707_39734[(2)] = inst_39648);

(statearr_39707_39734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (13))){
var inst_39696 = (state_39703[(2)]);
var state_39703__$1 = state_39703;
var statearr_39708_39735 = state_39703__$1;
(statearr_39708_39735[(2)] = inst_39696);

(statearr_39708_39735[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (6))){
var inst_39656 = fluree.db.util.core.random_uuid();
var state_39703__$1 = state_39703;
var statearr_39709_39736 = state_39703__$1;
(statearr_39709_39736[(2)] = inst_39656);

(statearr_39709_39736[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (3))){
var inst_39701 = (state_39703[(2)]);
var state_39703__$1 = state_39703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39703__$1,inst_39701);
} else {
if((state_val_39704 === (12))){
var inst_39679 = (state_39703[(7)]);
var state_39703__$1 = state_39703;
var statearr_39710_39737 = state_39703__$1;
(statearr_39710_39737[(2)] = inst_39679);

(statearr_39710_39737[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (2))){
var _ = (function (){var statearr_39711 = state_39703;
(statearr_39711[(4)] = cljs.core.cons((5),(state_39703[(4)])));

return statearr_39711;
})();
var inst_39654 = (tt_id == null);
var state_39703__$1 = state_39703;
if(cljs.core.truth_(inst_39654)){
var statearr_39712_39738 = state_39703__$1;
(statearr_39712_39738[(1)] = (6));

} else {
var statearr_39713_39739 = state_39703__$1;
(statearr_39713_39739[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (11))){
var inst_39679 = (state_39703[(7)]);
var inst_39686 = (state_39703[(8)]);
var inst_39689 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_39679,inst_39686);
var state_39703__$1 = state_39703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39703__$1,(14),inst_39689);
} else {
if((state_val_39704 === (9))){
var inst_39686 = (state_39703[(8)]);
var inst_39680 = (state_39703[(9)]);
var inst_39685 = cljs.core.seq(inst_39680);
var inst_39686__$1 = cljs.core.first(inst_39685);
var inst_39687 = cljs.core.next(inst_39685);
var state_39703__$1 = (function (){var statearr_39715 = state_39703;
(statearr_39715[(8)] = inst_39686__$1);

(statearr_39715[(10)] = inst_39687);

return statearr_39715;
})();
if(cljs.core.truth_(inst_39686__$1)){
var statearr_39716_39740 = state_39703__$1;
(statearr_39716_39740[(1)] = (11));

} else {
var statearr_39717_39741 = state_39703__$1;
(statearr_39717_39741[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (5))){
var _ = (function (){var statearr_39718 = state_39703;
(statearr_39718[(4)] = cljs.core.rest((state_39703[(4)])));

return statearr_39718;
})();
var state_39703__$1 = state_39703;
var ex39714 = (state_39703__$1[(2)]);
var statearr_39719_39742 = state_39703__$1;
(statearr_39719_39742[(5)] = ex39714);


if((ex39714 instanceof Error)){
var statearr_39720_39743 = state_39703__$1;
(statearr_39720_39743[(1)] = (4));

(statearr_39720_39743[(5)] = null);

} else {
throw ex39714;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (14))){
var inst_39687 = (state_39703[(10)]);
var inst_39691 = (state_39703[(2)]);
var inst_39692 = fluree.db.util.async.throw_err(inst_39691);
var inst_39679 = inst_39692;
var inst_39680 = inst_39687;
var state_39703__$1 = (function (){var statearr_39721 = state_39703;
(statearr_39721[(7)] = inst_39679);

(statearr_39721[(9)] = inst_39680);

return statearr_39721;
})();
var statearr_39722_39744 = state_39703__$1;
(statearr_39722_39744[(2)] = null);

(statearr_39722_39744[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (10))){
var inst_39698 = (state_39703[(2)]);
var _ = (function (){var statearr_39723 = state_39703;
(statearr_39723[(4)] = cljs.core.rest((state_39703[(4)])));

return statearr_39723;
})();
var state_39703__$1 = state_39703;
var statearr_39724_39745 = state_39703__$1;
(statearr_39724_39745[(2)] = inst_39698);

(statearr_39724_39745[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39704 === (8))){
var inst_39659 = (state_39703[(2)]);
var inst_39660 = (function (){var tt_id_SINGLEQUOTE_ = inst_39659;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_39661 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_39659);
var inst_39662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39663 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_39664 = (new cljs.core.PersistentVector(null,4,(5),inst_39662,inst_39663,null));
var inst_39665 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39660,inst_39661,inst_39664);
var inst_39666 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_39667 = cljs.core.reverse(inst_39666);
var inst_39668 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_39667);
var inst_39676 = cljs.core.seq(inst_39668);
var inst_39677 = cljs.core.first(inst_39676);
var inst_39678 = cljs.core.next(inst_39676);
var inst_39679 = inst_39665;
var inst_39680 = inst_39668;
var state_39703__$1 = (function (){var statearr_39725 = state_39703;
(statearr_39725[(7)] = inst_39679);

(statearr_39725[(11)] = inst_39678);

(statearr_39725[(12)] = inst_39677);

(statearr_39725[(9)] = inst_39680);

return statearr_39725;
})();
var statearr_39726_39746 = state_39703__$1;
(statearr_39726_39746[(2)] = null);

(statearr_39726_39746[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0 = (function (){
var statearr_39727 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39727[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__);

(statearr_39727[(1)] = (1));

return statearr_39727;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1 = (function (state_39703){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39703);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39728){var ex__13886__auto__ = e39728;
var statearr_39729_39747 = state_39703;
(statearr_39729_39747[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39703[(4)]))){
var statearr_39730_39748 = state_39703;
(statearr_39730_39748[(1)] = cljs.core.first((state_39703[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39749 = state_39703;
state_39703 = G__39749;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__ = function(state_39703){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1.call(this,state_39703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39731 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39731[(6)] = c__13957__auto__);

return statearr_39731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___39927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39864){
var state_val_39865 = (state_39864[(1)]);
if((state_val_39865 === (7))){
var inst_39777 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_39778 = cljs.core.first(ident);
var inst_39779 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_39778);
var inst_39780 = (inst_39779 == null);
var inst_39781 = ((inst_39777) && (inst_39780));
var state_39864__$1 = state_39864;
if(cljs.core.truth_(inst_39781)){
var statearr_39866_39928 = state_39864__$1;
(statearr_39866_39928[(1)] = (13));

} else {
var statearr_39867_39929 = state_39864__$1;
(statearr_39867_39929[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (20))){
var state_39864__$1 = state_39864;
var statearr_39868_39930 = state_39864__$1;
(statearr_39868_39930[(2)] = null);

(statearr_39868_39930[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (27))){
var state_39864__$1 = state_39864;
var statearr_39869_39931 = state_39864__$1;
(statearr_39869_39931[(2)] = null);

(statearr_39869_39931[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (1))){
var state_39864__$1 = state_39864;
var statearr_39870_39932 = state_39864__$1;
(statearr_39870_39932[(2)] = null);

(statearr_39870_39932[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (24))){
var inst_39810 = (state_39864[(7)]);
var inst_39814 = inst_39810.s;
var state_39864__$1 = state_39864;
var statearr_39871_39933 = state_39864__$1;
(statearr_39871_39933[(2)] = inst_39814);

(statearr_39871_39933[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (39))){
var state_39864__$1 = state_39864;
var statearr_39872_39934 = state_39864__$1;
(statearr_39872_39934[(2)] = null);

(statearr_39872_39934[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (4))){
var inst_39750 = (state_39864[(2)]);
var inst_39751 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_39752 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39753 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_39754 = cljs.core.PersistentHashMap.fromArrays(inst_39752,inst_39753);
var inst_39755 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_39751,inst_39754,inst_39750);
var inst_39756 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39755);
var state_39864__$1 = state_39864;
var statearr_39873_39935 = state_39864__$1;
(statearr_39873_39935[(2)] = inst_39756);

(statearr_39873_39935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (15))){
var inst_39832 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39874_39936 = state_39864__$1;
(statearr_39874_39936[(2)] = inst_39832);

(statearr_39874_39936[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (21))){
var inst_39804 = (state_39864[(8)]);
var inst_39808 = cljs.core.first(inst_39804);
var state_39864__$1 = state_39864;
var statearr_39875_39937 = state_39864__$1;
(statearr_39875_39937[(2)] = inst_39808);

(statearr_39875_39937[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (31))){
var inst_39859 = (state_39864[(2)]);
var _ = (function (){var statearr_39876 = state_39864;
(statearr_39876[(4)] = cljs.core.rest((state_39864[(4)])));

return statearr_39876;
})();
var state_39864__$1 = state_39864;
var statearr_39877_39938 = state_39864__$1;
(statearr_39877_39938[(2)] = inst_39859);

(statearr_39877_39938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (32))){
var state_39864__$1 = state_39864;
var statearr_39878_39939 = state_39864__$1;
(statearr_39878_39939[(2)] = strict_QMARK_);

(statearr_39878_39939[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (40))){
var inst_39855 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39879_39940 = state_39864__$1;
(statearr_39879_39940[(2)] = inst_39855);

(statearr_39879_39940[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (33))){
var state_39864__$1 = state_39864;
var statearr_39880_39941 = state_39864__$1;
(statearr_39880_39941[(2)] = false);

(statearr_39880_39941[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (13))){
var inst_39783 = cljs.core.first(ident);
var inst_39784 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39783], 0));
var inst_39785 = ["Subject ID lookup failed. The predicate ",inst_39784," does not exist."].join('');
var inst_39786 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39787 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_39788 = cljs.core.PersistentHashMap.fromArrays(inst_39786,inst_39787);
var inst_39789 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39785,inst_39788);
var inst_39790 = (function(){throw inst_39789})();
var state_39864__$1 = state_39864;
var statearr_39881_39942 = state_39864__$1;
(statearr_39881_39942[(2)] = inst_39790);

(statearr_39881_39942[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (22))){
var inst_39810 = (state_39864[(7)]);
var inst_39810__$1 = (state_39864[(2)]);
var inst_39811 = (inst_39810__$1 == null);
var state_39864__$1 = (function (){var statearr_39882 = state_39864;
(statearr_39882[(7)] = inst_39810__$1);

return statearr_39882;
})();
if(cljs.core.truth_(inst_39811)){
var statearr_39883_39943 = state_39864__$1;
(statearr_39883_39943[(1)] = (23));

} else {
var statearr_39884_39944 = state_39864__$1;
(statearr_39884_39944[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (36))){
var state_39864__$1 = state_39864;
var statearr_39885_39945 = state_39864__$1;
(statearr_39885_39945[(1)] = (38));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (29))){
var inst_39834 = (state_39864[(9)]);
var inst_39836 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39834);
var state_39864__$1 = state_39864;
var statearr_39887_39946 = state_39864__$1;
(statearr_39887_39946[(2)] = inst_39836);

(statearr_39887_39946[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (6))){
var inst_39764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39765 = [ident];
var inst_39766 = (new cljs.core.PersistentVector(null,1,(5),inst_39764,inst_39765,null));
var inst_39767 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39766);
var state_39864__$1 = state_39864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39864__$1,(9),inst_39767);
} else {
if((state_val_39865 === (28))){
var inst_39828 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39888_39947 = state_39864__$1;
(statearr_39888_39947[(2)] = inst_39828);

(statearr_39888_39947[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (25))){
var inst_39816 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39889_39948 = state_39864__$1;
(statearr_39889_39948[(2)] = inst_39816);

(statearr_39889_39948[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (34))){
var inst_39842 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
if(cljs.core.truth_(inst_39842)){
var statearr_39890_39949 = state_39864__$1;
(statearr_39890_39949[(1)] = (35));

} else {
var statearr_39891_39950 = state_39864__$1;
(statearr_39891_39950[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (17))){
var state_39864__$1 = state_39864;
var statearr_39892_39951 = state_39864__$1;
(statearr_39892_39951[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (3))){
var inst_39862 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39864__$1,inst_39862);
} else {
if((state_val_39865 === (12))){
var inst_39775 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39894_39952 = state_39864__$1;
(statearr_39894_39952[(2)] = inst_39775);

(statearr_39894_39952[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (2))){
var _ = (function (){var statearr_39895 = state_39864;
(statearr_39895[(4)] = cljs.core.cons((5),(state_39864[(4)])));

return statearr_39895;
})();
var inst_39762 = typeof ident === 'number';
var state_39864__$1 = state_39864;
if(cljs.core.truth_(inst_39762)){
var statearr_39896_39953 = state_39864__$1;
(statearr_39896_39953[(1)] = (6));

} else {
var statearr_39897_39954 = state_39864__$1;
(statearr_39897_39954[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (23))){
var state_39864__$1 = state_39864;
var statearr_39898_39955 = state_39864__$1;
(statearr_39898_39955[(2)] = null);

(statearr_39898_39955[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (35))){
var inst_39844 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_39845 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39846 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_39847 = cljs.core.PersistentHashMap.fromArrays(inst_39845,inst_39846);
var inst_39848 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39844,inst_39847);
var inst_39849 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39848);
var state_39864__$1 = state_39864;
var statearr_39899_39956 = state_39864__$1;
(statearr_39899_39956[(2)] = inst_39849);

(statearr_39899_39956[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (19))){
var inst_39804 = (state_39864[(8)]);
var inst_39803 = (state_39864[(2)]);
var inst_39804__$1 = fluree.db.util.async.throw_err(inst_39803);
var inst_39805 = (inst_39804__$1 == null);
var state_39864__$1 = (function (){var statearr_39900 = state_39864;
(statearr_39900[(8)] = inst_39804__$1);

return statearr_39900;
})();
if(cljs.core.truth_(inst_39805)){
var statearr_39901_39957 = state_39864__$1;
(statearr_39901_39957[(1)] = (20));

} else {
var statearr_39902_39958 = state_39864__$1;
(statearr_39902_39958[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (11))){
var state_39864__$1 = state_39864;
var statearr_39904_39959 = state_39864__$1;
(statearr_39904_39959[(2)] = null);

(statearr_39904_39959[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (9))){
var inst_39769 = (state_39864[(2)]);
var inst_39770 = fluree.db.util.async.throw_err(inst_39769);
var inst_39771 = cljs.core.not_empty(inst_39770);
var state_39864__$1 = state_39864;
if(cljs.core.truth_(inst_39771)){
var statearr_39905_39960 = state_39864__$1;
(statearr_39905_39960[(1)] = (10));

} else {
var statearr_39906_39961 = state_39864__$1;
(statearr_39906_39961[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (5))){
var _ = (function (){var statearr_39907 = state_39864;
(statearr_39907[(4)] = cljs.core.rest((state_39864[(4)])));

return statearr_39907;
})();
var state_39864__$1 = state_39864;
var ex39903 = (state_39864__$1[(2)]);
var statearr_39908_39962 = state_39864__$1;
(statearr_39908_39962[(5)] = ex39903);


var statearr_39909_39963 = state_39864__$1;
(statearr_39909_39963[(1)] = (4));

(statearr_39909_39963[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (14))){
var inst_39792 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_39864__$1 = state_39864;
if(inst_39792){
var statearr_39910_39964 = state_39864__$1;
(statearr_39910_39964[(1)] = (16));

} else {
var statearr_39911_39965 = state_39864__$1;
(statearr_39911_39965[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (26))){
var inst_39819 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_39820 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_39819].join('');
var inst_39821 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39822 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_39823 = cljs.core.PersistentHashMap.fromArrays(inst_39821,inst_39822);
var inst_39824 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39820,inst_39823);
var inst_39825 = (function(){throw inst_39824})();
var state_39864__$1 = state_39864;
var statearr_39912_39966 = state_39864__$1;
(statearr_39912_39966[(2)] = inst_39825);

(statearr_39912_39966[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (16))){
var inst_39795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39796 = cljs.core.first(ident);
var inst_39797 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_39796);
var inst_39798 = cljs.core.second(ident);
var inst_39799 = [inst_39797,inst_39798];
var inst_39800 = (new cljs.core.PersistentVector(null,2,(5),inst_39795,inst_39799,null));
var inst_39801 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39800);
var state_39864__$1 = state_39864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39864__$1,(19),inst_39801);
} else {
if((state_val_39865 === (38))){
var inst_39852 = cljs.core.async.close_BANG_(return_chan);
var state_39864__$1 = state_39864;
var statearr_39913_39967 = state_39864__$1;
(statearr_39913_39967[(2)] = inst_39852);

(statearr_39913_39967[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (30))){
var inst_39834 = (state_39864[(9)]);
var inst_39838 = (inst_39834 == null);
var state_39864__$1 = state_39864;
if(cljs.core.truth_(inst_39838)){
var statearr_39914_39968 = state_39864__$1;
(statearr_39914_39968[(1)] = (32));

} else {
var statearr_39915_39969 = state_39864__$1;
(statearr_39915_39969[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (10))){
var state_39864__$1 = state_39864;
var statearr_39916_39970 = state_39864__$1;
(statearr_39916_39970[(2)] = ident);

(statearr_39916_39970[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (18))){
var inst_39830 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39917_39971 = state_39864__$1;
(statearr_39917_39971[(2)] = inst_39830);

(statearr_39917_39971[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (37))){
var inst_39857 = (state_39864[(2)]);
var state_39864__$1 = state_39864;
var statearr_39918_39972 = state_39864__$1;
(statearr_39918_39972[(2)] = inst_39857);

(statearr_39918_39972[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39865 === (8))){
var inst_39834 = (state_39864[(9)]);
var inst_39834__$1 = (state_39864[(2)]);
var state_39864__$1 = (function (){var statearr_39919 = state_39864;
(statearr_39919[(9)] = inst_39834__$1);

return statearr_39919;
})();
if(cljs.core.truth_(inst_39834__$1)){
var statearr_39920_39973 = state_39864__$1;
(statearr_39920_39973[(1)] = (29));

} else {
var statearr_39921_39974 = state_39864__$1;
(statearr_39921_39974[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__13883__auto____0 = (function (){
var statearr_39922 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39922[(0)] = fluree$db$graphdb$subid_$_state_machine__13883__auto__);

(statearr_39922[(1)] = (1));

return statearr_39922;
});
var fluree$db$graphdb$subid_$_state_machine__13883__auto____1 = (function (state_39864){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39864);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39923){var ex__13886__auto__ = e39923;
var statearr_39924_39975 = state_39864;
(statearr_39924_39975[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39864[(4)]))){
var statearr_39925_39976 = state_39864;
(statearr_39925_39976[(1)] = cljs.core.first((state_39864[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39977 = state_39864;
state_39864 = G__39977;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__13883__auto__ = function(state_39864){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__13883__auto____1.call(this,state_39864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__13883__auto____0;
fluree$db$graphdb$subid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__13883__auto____1;
return fluree$db$graphdb$subid_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39926 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39926[(6)] = c__13957__auto___39927);

return statearr_39926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k39979,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__39983 = k39979;
var G__39983__$1 = (((G__39983 instanceof cljs.core.Keyword))?G__39983.fqn:null);
switch (G__39983__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39979,else__4418__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__39984){
var vec__39985 = p__39984;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39985,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39985,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39978){
var self__ = this;
var G__39978__$1 = this;
return (new cljs.core.RecordIter((0),G__39978__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__39988 = (function (coll__4412__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__39988(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39980,other39981){
var self__ = this;
var this39980__$1 = this;
return (((!((other39981 == null)))) && ((this39980__$1.constructor === other39981.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.conn,other39981.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.network,other39981.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.dbid,other39981.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.block,other39981.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.t,other39981.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.tt_id,other39981.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.stats,other39981.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.spot,other39981.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.psot,other39981.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.post,other39981.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.opst,other39981.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.schema,other39981.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.settings,other39981.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.index_configs,other39981.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.schema_cache,other39981.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.novelty,other39981.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.permissions,other39981.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.fork,other39981.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.fork_block,other39981.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.current_db_fn,other39981.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39980__$1.__extmap,other39981.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__39978){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__39989 = cljs.core.keyword_identical_QMARK_;
var expr__39990 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__39992 = cljs.core.cst$kw$conn;
var G__39993 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__39992,G__39993) : pred__39989.call(null,G__39992,G__39993));
})())){
return (new fluree.db.graphdb.GraphDb(G__39978,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39994 = cljs.core.cst$kw$network;
var G__39995 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__39994,G__39995) : pred__39989.call(null,G__39994,G__39995));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__39978,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39996 = cljs.core.cst$kw$dbid;
var G__39997 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__39996,G__39997) : pred__39989.call(null,G__39996,G__39997));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__39978,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39998 = cljs.core.cst$kw$block;
var G__39999 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__39998,G__39999) : pred__39989.call(null,G__39998,G__39999));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__39978,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40000 = cljs.core.cst$kw$t;
var G__40001 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40000,G__40001) : pred__39989.call(null,G__40000,G__40001));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__39978,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40002 = cljs.core.cst$kw$tt_DASH_id;
var G__40003 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40002,G__40003) : pred__39989.call(null,G__40002,G__40003));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__39978,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40004 = cljs.core.cst$kw$stats;
var G__40005 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40004,G__40005) : pred__39989.call(null,G__40004,G__40005));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__39978,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40006 = cljs.core.cst$kw$spot;
var G__40007 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40006,G__40007) : pred__39989.call(null,G__40006,G__40007));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__39978,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40008 = cljs.core.cst$kw$psot;
var G__40009 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40008,G__40009) : pred__39989.call(null,G__40008,G__40009));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__39978,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40010 = cljs.core.cst$kw$post;
var G__40011 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40010,G__40011) : pred__39989.call(null,G__40010,G__40011));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__39978,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40012 = cljs.core.cst$kw$opst;
var G__40013 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40012,G__40013) : pred__39989.call(null,G__40012,G__40013));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__39978,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40014 = cljs.core.cst$kw$schema;
var G__40015 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40014,G__40015) : pred__39989.call(null,G__40014,G__40015));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__39978,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40016 = cljs.core.cst$kw$settings;
var G__40017 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40016,G__40017) : pred__39989.call(null,G__40016,G__40017));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__39978,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40018 = cljs.core.cst$kw$index_DASH_configs;
var G__40019 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40018,G__40019) : pred__39989.call(null,G__40018,G__40019));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__39978,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40020 = cljs.core.cst$kw$schema_DASH_cache;
var G__40021 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40020,G__40021) : pred__39989.call(null,G__40020,G__40021));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__39978,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40022 = cljs.core.cst$kw$novelty;
var G__40023 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40022,G__40023) : pred__39989.call(null,G__40022,G__40023));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__39978,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40024 = cljs.core.cst$kw$permissions;
var G__40025 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40024,G__40025) : pred__39989.call(null,G__40024,G__40025));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__39978,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40026 = cljs.core.cst$kw$fork;
var G__40027 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40026,G__40027) : pred__39989.call(null,G__40026,G__40027));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__39978,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40028 = cljs.core.cst$kw$fork_DASH_block;
var G__40029 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40028,G__40029) : pred__39989.call(null,G__40028,G__40029));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__39978,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40030 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__40031 = expr__39990;
return (pred__39989.cljs$core$IFn$_invoke$arity$2 ? pred__39989.cljs$core$IFn$_invoke$arity$2(G__40030,G__40031) : pred__39989.call(null,G__40030,G__40031));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__39978,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__39978),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__39978){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__39978,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40047){
var state_val_40048 = (state_40047[(1)]);
if((state_val_40048 === (1))){
var state_40047__$1 = state_40047;
var statearr_40049_40315 = state_40047__$1;
(statearr_40049_40315[(2)] = null);

(statearr_40049_40315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40048 === (2))){
var _ = (function (){var statearr_40050 = state_40047;
(statearr_40050[(4)] = cljs.core.cons((5),(state_40047[(4)])));

return statearr_40050;
})();
var inst_40038 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_40047__$1 = state_40047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40047__$1,(6),inst_40038);
} else {
if((state_val_40048 === (3))){
var inst_40045 = (state_40047[(2)]);
var state_40047__$1 = state_40047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40047__$1,inst_40045);
} else {
if((state_val_40048 === (4))){
var inst_40032 = (state_40047[(2)]);
var state_40047__$1 = state_40047;
var statearr_40052_40316 = state_40047__$1;
(statearr_40052_40316[(2)] = inst_40032);

(statearr_40052_40316[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40048 === (5))){
var _ = (function (){var statearr_40053 = state_40047;
(statearr_40053[(4)] = cljs.core.rest((state_40047[(4)])));

return statearr_40053;
})();
var state_40047__$1 = state_40047;
var ex40051 = (state_40047__$1[(2)]);
var statearr_40054_40317 = state_40047__$1;
(statearr_40054_40317[(5)] = ex40051);


if((ex40051 instanceof Error)){
var statearr_40055_40318 = state_40047__$1;
(statearr_40055_40318[(1)] = (4));

(statearr_40055_40318[(5)] = null);

} else {
throw ex40051;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40048 === (6))){
var inst_40040 = (state_40047[(2)]);
var inst_40041 = fluree.db.util.async.throw_err(inst_40040);
var inst_40042 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40041,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_40056 = state_40047;
(statearr_40056[(4)] = cljs.core.rest((state_40047[(4)])));

return statearr_40056;
})();
var state_40047__$1 = state_40047;
var statearr_40057_40319 = state_40047__$1;
(statearr_40057_40319[(2)] = inst_40042);

(statearr_40057_40319[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40058 = [null,null,null,null,null,null,null];
(statearr_40058[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40058[(1)] = (1));

return statearr_40058;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_40047){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40047);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40059){var ex__13886__auto__ = e40059;
var statearr_40060_40320 = state_40047;
(statearr_40060_40320[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40047[(4)]))){
var statearr_40061_40321 = state_40047;
(statearr_40061_40321[(1)] = cljs.core.first((state_40047[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40322 = state_40047;
state_40047 = G__40322;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_40047){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_40047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40062 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40062[(6)] = c__13957__auto__);

return statearr_40062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__40063 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__40063.cljs$core$IFn$_invoke$arity$1 ? fexpr__40063.cljs$core$IFn$_invoke$arity$1(property) : fexpr__40063.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__40064 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__40064.cljs$core$IFn$_invoke$arity$1 ? fexpr__40064.cljs$core$IFn$_invoke$arity$1(property) : fexpr__40064.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__40065 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__40065);
} else {
return G__40065;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40097){
var state_val_40098 = (state_40097[(1)]);
if((state_val_40098 === (7))){
var state_40097__$1 = state_40097;
var statearr_40099_40323 = state_40097__$1;
(statearr_40099_40323[(2)] = null);

(statearr_40099_40323[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (1))){
var state_40097__$1 = state_40097;
var statearr_40100_40324 = state_40097__$1;
(statearr_40100_40324[(2)] = null);

(statearr_40100_40324[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (4))){
var inst_40066 = (state_40097[(2)]);
var state_40097__$1 = state_40097;
var statearr_40101_40325 = state_40097__$1;
(statearr_40101_40325[(2)] = inst_40066);

(statearr_40101_40325[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (6))){
var inst_40080 = (state_40097[(7)]);
var inst_40079 = (state_40097[(2)]);
var inst_40080__$1 = fluree.db.util.async.throw_err(inst_40079);
var inst_40081 = (inst_40080__$1 == null);
var state_40097__$1 = (function (){var statearr_40102 = state_40097;
(statearr_40102[(7)] = inst_40080__$1);

return statearr_40102;
})();
if(cljs.core.truth_(inst_40081)){
var statearr_40103_40326 = state_40097__$1;
(statearr_40103_40326[(1)] = (7));

} else {
var statearr_40104_40327 = state_40097__$1;
(statearr_40104_40327[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (3))){
var inst_40095 = (state_40097[(2)]);
var state_40097__$1 = state_40097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40097__$1,inst_40095);
} else {
if((state_val_40098 === (12))){
var inst_40092 = (state_40097[(2)]);
var _ = (function (){var statearr_40105 = state_40097;
(statearr_40105[(4)] = cljs.core.rest((state_40097[(4)])));

return statearr_40105;
})();
var state_40097__$1 = state_40097;
var statearr_40106_40328 = state_40097__$1;
(statearr_40106_40328[(2)] = inst_40092);

(statearr_40106_40328[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (2))){
var _ = (function (){var statearr_40107 = state_40097;
(statearr_40107[(4)] = cljs.core.cons((5),(state_40097[(4)])));

return statearr_40107;
})();
var inst_40073 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_40074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40075 = [tag_id,(30)];
var inst_40076 = (new cljs.core.PersistentVector(null,2,(5),inst_40074,inst_40075,null));
var inst_40077 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_40073,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_40076);
var state_40097__$1 = state_40097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40097__$1,(6),inst_40077);
} else {
if((state_val_40098 === (11))){
var inst_40086 = (state_40097[(8)]);
var inst_40090 = inst_40086.o;
var state_40097__$1 = state_40097;
var statearr_40109_40329 = state_40097__$1;
(statearr_40109_40329[(2)] = inst_40090);

(statearr_40109_40329[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (9))){
var inst_40086 = (state_40097[(8)]);
var inst_40086__$1 = (state_40097[(2)]);
var inst_40087 = (inst_40086__$1 == null);
var state_40097__$1 = (function (){var statearr_40110 = state_40097;
(statearr_40110[(8)] = inst_40086__$1);

return statearr_40110;
})();
if(cljs.core.truth_(inst_40087)){
var statearr_40111_40330 = state_40097__$1;
(statearr_40111_40330[(1)] = (10));

} else {
var statearr_40112_40331 = state_40097__$1;
(statearr_40112_40331[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (5))){
var _ = (function (){var statearr_40113 = state_40097;
(statearr_40113[(4)] = cljs.core.rest((state_40097[(4)])));

return statearr_40113;
})();
var state_40097__$1 = state_40097;
var ex40108 = (state_40097__$1[(2)]);
var statearr_40114_40332 = state_40097__$1;
(statearr_40114_40332[(5)] = ex40108);


if((ex40108 instanceof Error)){
var statearr_40115_40333 = state_40097__$1;
(statearr_40115_40333[(1)] = (4));

(statearr_40115_40333[(5)] = null);

} else {
throw ex40108;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (10))){
var state_40097__$1 = state_40097;
var statearr_40116_40334 = state_40097__$1;
(statearr_40116_40334[(2)] = null);

(statearr_40116_40334[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40098 === (8))){
var inst_40080 = (state_40097[(7)]);
var inst_40084 = cljs.core.first(inst_40080);
var state_40097__$1 = state_40097;
var statearr_40117_40335 = state_40097__$1;
(statearr_40117_40335[(2)] = inst_40084);

(statearr_40117_40335[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40118 = [null,null,null,null,null,null,null,null,null];
(statearr_40118[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40118[(1)] = (1));

return statearr_40118;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_40097){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40097);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40119){var ex__13886__auto__ = e40119;
var statearr_40120_40336 = state_40097;
(statearr_40120_40336[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40097[(4)]))){
var statearr_40121_40337 = state_40097;
(statearr_40121_40337[(1)] = cljs.core.first((state_40097[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40338 = state_40097;
state_40097 = G__40338;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_40097){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_40097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40122 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40122[(6)] = c__13957__auto__);

return statearr_40122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40158){
var state_val_40159 = (state_40158[(1)]);
if((state_val_40159 === (7))){
var inst_40132 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_40158__$1 = state_40158;
var statearr_40160_40339 = state_40158__$1;
(statearr_40160_40339[(2)] = inst_40132);

(statearr_40160_40339[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (1))){
var state_40158__$1 = state_40158;
var statearr_40161_40340 = state_40158__$1;
(statearr_40161_40340[(2)] = null);

(statearr_40161_40340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (4))){
var inst_40123 = (state_40158[(2)]);
var state_40158__$1 = state_40158;
var statearr_40162_40341 = state_40158__$1;
(statearr_40162_40341[(2)] = inst_40123);

(statearr_40162_40341[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (15))){
var inst_40153 = (state_40158[(2)]);
var _ = (function (){var statearr_40163 = state_40158;
(statearr_40163[(4)] = cljs.core.rest((state_40158[(4)])));

return statearr_40163;
})();
var state_40158__$1 = state_40158;
var statearr_40164_40342 = state_40158__$1;
(statearr_40164_40342[(2)] = inst_40153);

(statearr_40164_40342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (13))){
var inst_40138 = (state_40158[(7)]);
var inst_40144 = clojure.string.includes_QMARK_(inst_40138,":");
var state_40158__$1 = state_40158;
if(inst_40144){
var statearr_40165_40343 = state_40158__$1;
(statearr_40165_40343[(1)] = (16));

} else {
var statearr_40166_40344 = state_40158__$1;
(statearr_40166_40344[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (6))){
var state_40158__$1 = state_40158;
var statearr_40167_40345 = state_40158__$1;
(statearr_40167_40345[(2)] = pred);

(statearr_40167_40345[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (17))){
var inst_40138 = (state_40158[(7)]);
var state_40158__$1 = state_40158;
var statearr_40168_40346 = state_40158__$1;
(statearr_40168_40346[(2)] = inst_40138);

(statearr_40168_40346[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (3))){
var inst_40156 = (state_40158[(2)]);
var state_40158__$1 = state_40158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40158__$1,inst_40156);
} else {
if((state_val_40159 === (12))){
var inst_40142 = (state_40158[(2)]);
var state_40158__$1 = state_40158;
if(cljs.core.truth_(inst_40142)){
var statearr_40169_40347 = state_40158__$1;
(statearr_40169_40347[(1)] = (13));

} else {
var statearr_40170_40348 = state_40158__$1;
(statearr_40170_40348[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (2))){
var _ = (function (){var statearr_40171 = state_40158;
(statearr_40171[(4)] = cljs.core.cons((5),(state_40158[(4)])));

return statearr_40171;
})();
var inst_40129 = typeof pred === 'string';
var state_40158__$1 = state_40158;
if(cljs.core.truth_(inst_40129)){
var statearr_40172_40349 = state_40158__$1;
(statearr_40172_40349[(1)] = (6));

} else {
var statearr_40173_40350 = state_40158__$1;
(statearr_40173_40350[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (11))){
var inst_40134 = (state_40158[(8)]);
var state_40158__$1 = state_40158;
var statearr_40175_40351 = state_40158__$1;
(statearr_40175_40351[(2)] = inst_40134);

(statearr_40175_40351[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (9))){
var inst_40134 = (state_40158[(8)]);
var inst_40137 = (state_40158[(2)]);
var inst_40138 = fluree.db.util.async.throw_err(inst_40137);
var state_40158__$1 = (function (){var statearr_40176 = state_40158;
(statearr_40176[(7)] = inst_40138);

return statearr_40176;
})();
if(cljs.core.truth_(inst_40134)){
var statearr_40177_40352 = state_40158__$1;
(statearr_40177_40352[(1)] = (10));

} else {
var statearr_40178_40353 = state_40158__$1;
(statearr_40178_40353[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (5))){
var _ = (function (){var statearr_40179 = state_40158;
(statearr_40179[(4)] = cljs.core.rest((state_40158[(4)])));

return statearr_40179;
})();
var state_40158__$1 = state_40158;
var ex40174 = (state_40158__$1[(2)]);
var statearr_40180_40354 = state_40158__$1;
(statearr_40180_40354[(5)] = ex40174);


if((ex40174 instanceof Error)){
var statearr_40181_40355 = state_40158__$1;
(statearr_40181_40355[(1)] = (4));

(statearr_40181_40355[(5)] = null);

} else {
throw ex40174;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (14))){
var state_40158__$1 = state_40158;
var statearr_40182_40356 = state_40158__$1;
(statearr_40182_40356[(2)] = null);

(statearr_40182_40356[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (16))){
var inst_40138 = (state_40158[(7)]);
var inst_40146 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_40138,/:/);
var inst_40147 = cljs.core.second(inst_40146);
var state_40158__$1 = state_40158;
var statearr_40183_40357 = state_40158__$1;
(statearr_40183_40357[(2)] = inst_40147);

(statearr_40183_40357[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (10))){
var inst_40138 = (state_40158[(7)]);
var state_40158__$1 = state_40158;
var statearr_40184_40358 = state_40158__$1;
(statearr_40184_40358[(2)] = inst_40138);

(statearr_40184_40358[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (18))){
var inst_40150 = (state_40158[(2)]);
var state_40158__$1 = state_40158;
var statearr_40185_40359 = state_40158__$1;
(statearr_40185_40359[(2)] = inst_40150);

(statearr_40185_40359[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40159 === (8))){
var inst_40134 = (state_40158[(2)]);
var inst_40135 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_40158__$1 = (function (){var statearr_40186 = state_40158;
(statearr_40186[(8)] = inst_40134);

return statearr_40186;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40158__$1,(9),inst_40135);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40187 = [null,null,null,null,null,null,null,null,null];
(statearr_40187[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40187[(1)] = (1));

return statearr_40187;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_40158){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40158);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40188){var ex__13886__auto__ = e40188;
var statearr_40189_40360 = state_40158;
(statearr_40189_40360[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40158[(4)]))){
var statearr_40190_40361 = state_40158;
(statearr_40190_40361[(1)] = cljs.core.first((state_40158[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40362 = state_40158;
state_40158 = G__40362;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_40158){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_40158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40191 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40191[(6)] = c__13957__auto__);

return statearr_40191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40224){
var state_val_40225 = (state_40224[(1)]);
if((state_val_40225 === (7))){
var state_40224__$1 = state_40224;
var statearr_40226_40363 = state_40224__$1;
(statearr_40226_40363[(2)] = null);

(statearr_40226_40363[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (1))){
var state_40224__$1 = state_40224;
var statearr_40227_40364 = state_40224__$1;
(statearr_40227_40364[(2)] = null);

(statearr_40227_40364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (4))){
var inst_40192 = (state_40224[(2)]);
var state_40224__$1 = state_40224;
var statearr_40228_40365 = state_40224__$1;
(statearr_40228_40365[(2)] = inst_40192);

(statearr_40228_40365[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (6))){
var inst_40207 = (state_40224[(7)]);
var inst_40206 = (state_40224[(2)]);
var inst_40207__$1 = fluree.db.util.async.throw_err(inst_40206);
var inst_40208 = (inst_40207__$1 == null);
var state_40224__$1 = (function (){var statearr_40229 = state_40224;
(statearr_40229[(7)] = inst_40207__$1);

return statearr_40229;
})();
if(cljs.core.truth_(inst_40208)){
var statearr_40230_40366 = state_40224__$1;
(statearr_40230_40366[(1)] = (7));

} else {
var statearr_40231_40367 = state_40224__$1;
(statearr_40231_40367[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (3))){
var inst_40222 = (state_40224[(2)]);
var state_40224__$1 = state_40224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40224__$1,inst_40222);
} else {
if((state_val_40225 === (12))){
var inst_40219 = (state_40224[(2)]);
var _ = (function (){var statearr_40232 = state_40224;
(statearr_40232[(4)] = cljs.core.rest((state_40224[(4)])));

return statearr_40232;
})();
var state_40224__$1 = state_40224;
var statearr_40233_40368 = state_40224__$1;
(statearr_40233_40368[(2)] = inst_40219);

(statearr_40233_40368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (2))){
var _ = (function (){var statearr_40234 = state_40224;
(statearr_40234[(4)] = cljs.core.cons((5),(state_40224[(4)])));

return statearr_40234;
})();
var inst_40198 = (30);
var inst_40200 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_40201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40202 = [inst_40198,tag_name];
var inst_40203 = (new cljs.core.PersistentVector(null,2,(5),inst_40201,inst_40202,null));
var inst_40204 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_40200,cljs.core.cst$kw$post,cljs.core._EQ_,inst_40203);
var state_40224__$1 = state_40224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40224__$1,(6),inst_40204);
} else {
if((state_val_40225 === (11))){
var inst_40213 = (state_40224[(8)]);
var inst_40217 = inst_40213.s;
var state_40224__$1 = state_40224;
var statearr_40236_40369 = state_40224__$1;
(statearr_40236_40369[(2)] = inst_40217);

(statearr_40236_40369[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (9))){
var inst_40213 = (state_40224[(8)]);
var inst_40213__$1 = (state_40224[(2)]);
var inst_40214 = (inst_40213__$1 == null);
var state_40224__$1 = (function (){var statearr_40237 = state_40224;
(statearr_40237[(8)] = inst_40213__$1);

return statearr_40237;
})();
if(cljs.core.truth_(inst_40214)){
var statearr_40238_40370 = state_40224__$1;
(statearr_40238_40370[(1)] = (10));

} else {
var statearr_40239_40371 = state_40224__$1;
(statearr_40239_40371[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (5))){
var _ = (function (){var statearr_40240 = state_40224;
(statearr_40240[(4)] = cljs.core.rest((state_40224[(4)])));

return statearr_40240;
})();
var state_40224__$1 = state_40224;
var ex40235 = (state_40224__$1[(2)]);
var statearr_40241_40372 = state_40224__$1;
(statearr_40241_40372[(5)] = ex40235);


if((ex40235 instanceof Error)){
var statearr_40242_40373 = state_40224__$1;
(statearr_40242_40373[(1)] = (4));

(statearr_40242_40373[(5)] = null);

} else {
throw ex40235;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (10))){
var state_40224__$1 = state_40224;
var statearr_40243_40374 = state_40224__$1;
(statearr_40243_40374[(2)] = null);

(statearr_40243_40374[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40225 === (8))){
var inst_40207 = (state_40224[(7)]);
var inst_40211 = cljs.core.first(inst_40207);
var state_40224__$1 = state_40224;
var statearr_40244_40375 = state_40224__$1;
(statearr_40244_40375[(2)] = inst_40211);

(statearr_40244_40375[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40245 = [null,null,null,null,null,null,null,null,null];
(statearr_40245[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40245[(1)] = (1));

return statearr_40245;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_40224){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40224);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40246){var ex__13886__auto__ = e40246;
var statearr_40247_40376 = state_40224;
(statearr_40247_40376[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40224[(4)]))){
var statearr_40248_40377 = state_40224;
(statearr_40248_40377[(1)] = cljs.core.first((state_40224[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40378 = state_40224;
state_40224 = G__40378;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_40224){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_40224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40249 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40249[(6)] = c__13957__auto__);

return statearr_40249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40284){
var state_val_40285 = (state_40284[(1)]);
if((state_val_40285 === (7))){
var inst_40263 = typeof pred === 'string';
var state_40284__$1 = state_40284;
if(cljs.core.truth_(inst_40263)){
var statearr_40286_40379 = state_40284__$1;
(statearr_40286_40379[(1)] = (10));

} else {
var statearr_40287_40380 = state_40284__$1;
(statearr_40287_40380[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (1))){
var state_40284__$1 = state_40284;
var statearr_40288_40381 = state_40284__$1;
(statearr_40288_40381[(2)] = null);

(statearr_40288_40381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (4))){
var inst_40250 = (state_40284[(2)]);
var state_40284__$1 = state_40284;
var statearr_40289_40382 = state_40284__$1;
(statearr_40289_40382[(2)] = inst_40250);

(statearr_40289_40382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (15))){
var inst_40277 = (state_40284[(2)]);
var state_40284__$1 = state_40284;
var statearr_40290_40383 = state_40284__$1;
(statearr_40290_40383[(2)] = inst_40277);

(statearr_40290_40383[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (13))){
var inst_40268 = (state_40284[(7)]);
var inst_40270 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40268),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_40271 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_40270);
var state_40284__$1 = state_40284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40284__$1,(16),inst_40271);
} else {
if((state_val_40285 === (6))){
var inst_40258 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_40284__$1 = state_40284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40284__$1,(9),inst_40258);
} else {
if((state_val_40285 === (3))){
var inst_40282 = (state_40284[(2)]);
var state_40284__$1 = state_40284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40284__$1,inst_40282);
} else {
if((state_val_40285 === (12))){
var inst_40268 = (state_40284[(7)]);
var inst_40268__$1 = (state_40284[(2)]);
var state_40284__$1 = (function (){var statearr_40291 = state_40284;
(statearr_40291[(7)] = inst_40268__$1);

return statearr_40291;
})();
if(cljs.core.truth_(inst_40268__$1)){
var statearr_40292_40384 = state_40284__$1;
(statearr_40292_40384[(1)] = (13));

} else {
var statearr_40293_40385 = state_40284__$1;
(statearr_40293_40385[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (2))){
var _ = (function (){var statearr_40294 = state_40284;
(statearr_40294[(4)] = cljs.core.cons((5),(state_40284[(4)])));

return statearr_40294;
})();
var inst_40256 = clojure.string.includes_QMARK_(tag_name,"/");
var state_40284__$1 = state_40284;
if(inst_40256){
var statearr_40295_40386 = state_40284__$1;
(statearr_40295_40386[(1)] = (6));

} else {
var statearr_40296_40387 = state_40284__$1;
(statearr_40296_40387[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (11))){
var inst_40266 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_40284__$1 = state_40284;
var statearr_40298_40388 = state_40284__$1;
(statearr_40298_40388[(2)] = inst_40266);

(statearr_40298_40388[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (9))){
var inst_40260 = (state_40284[(2)]);
var inst_40261 = fluree.db.util.async.throw_err(inst_40260);
var state_40284__$1 = state_40284;
var statearr_40299_40389 = state_40284__$1;
(statearr_40299_40389[(2)] = inst_40261);

(statearr_40299_40389[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (5))){
var _ = (function (){var statearr_40300 = state_40284;
(statearr_40300[(4)] = cljs.core.rest((state_40284[(4)])));

return statearr_40300;
})();
var state_40284__$1 = state_40284;
var ex40297 = (state_40284__$1[(2)]);
var statearr_40301_40390 = state_40284__$1;
(statearr_40301_40390[(5)] = ex40297);


if((ex40297 instanceof Error)){
var statearr_40302_40391 = state_40284__$1;
(statearr_40302_40391[(1)] = (4));

(statearr_40302_40391[(5)] = null);

} else {
throw ex40297;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (14))){
var state_40284__$1 = state_40284;
var statearr_40303_40392 = state_40284__$1;
(statearr_40303_40392[(2)] = null);

(statearr_40303_40392[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (16))){
var inst_40273 = (state_40284[(2)]);
var inst_40274 = fluree.db.util.async.throw_err(inst_40273);
var state_40284__$1 = state_40284;
var statearr_40304_40393 = state_40284__$1;
(statearr_40304_40393[(2)] = inst_40274);

(statearr_40304_40393[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (10))){
var state_40284__$1 = state_40284;
var statearr_40305_40394 = state_40284__$1;
(statearr_40305_40394[(2)] = pred);

(statearr_40305_40394[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40285 === (8))){
var inst_40279 = (state_40284[(2)]);
var _ = (function (){var statearr_40306 = state_40284;
(statearr_40306[(4)] = cljs.core.rest((state_40284[(4)])));

return statearr_40306;
})();
var state_40284__$1 = state_40284;
var statearr_40307_40395 = state_40284__$1;
(statearr_40307_40395[(2)] = inst_40279);

(statearr_40307_40395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40308 = [null,null,null,null,null,null,null,null];
(statearr_40308[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40308[(1)] = (1));

return statearr_40308;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_40284){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40284);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40309){var ex__13886__auto__ = e40309;
var statearr_40310_40396 = state_40284;
(statearr_40310_40396[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40284[(4)]))){
var statearr_40311_40397 = state_40284;
(statearr_40311_40397[(1)] = cljs.core.first((state_40284[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40398 = state_40284;
state_40284 = G__40398;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_40284){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_40284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40312 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40312[(6)] = c__13957__auto__);

return statearr_40312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__39982){
var extmap__4454__auto__ = (function (){var G__40313 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39982,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__39982)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40313);
} else {
return G__40313;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__39982),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__39982),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
