// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4820__auto___69944 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_69995){
var state_val_69996 = (state_69995[(1)]);
if((state_val_69996 === (7))){
var inst_69990 = (state_69995[(2)]);
var _ = (function (){var statearr_69997 = state_69995;
(statearr_69997[(4)] = cljs.core.rest((state_69995[(4)])));

return statearr_69997;
})();
var state_69995__$1 = state_69995;
var statearr_69998_70025 = state_69995__$1;
(statearr_69998_70025[(2)] = inst_69990);

(statearr_69998_70025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (1))){
var state_69995__$1 = state_69995;
var statearr_69999_70026 = state_69995__$1;
(statearr_69999_70026[(2)] = null);

(statearr_69999_70026[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (4))){
var inst_69945 = (state_69995[(2)]);
var state_69995__$1 = state_69995;
var statearr_70000_70027 = state_69995__$1;
(statearr_70000_70027[(2)] = inst_69945);

(statearr_70000_70027[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (13))){
var inst_69986 = (state_69995[(2)]);
var state_69995__$1 = state_69995;
var statearr_70001_70028 = state_69995__$1;
(statearr_70001_70028[(2)] = inst_69986);

(statearr_70001_70028[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (6))){
var inst_69963 = (state_69995[(7)]);
var inst_69970 = (state_69995[(8)]);
var inst_69969 = cljs.core.seq(inst_69963);
var inst_69970__$1 = cljs.core.first(inst_69969);
var inst_69971 = cljs.core.next(inst_69969);
var inst_69972 = cljs.core.not(inst_69970__$1);
var state_69995__$1 = (function (){var statearr_70002 = state_69995;
(statearr_70002[(8)] = inst_69970__$1);

(statearr_70002[(9)] = inst_69971);

return statearr_70002;
})();
if(inst_69972){
var statearr_70003_70029 = state_69995__$1;
(statearr_70003_70029[(1)] = (8));

} else {
var statearr_70004_70030 = state_69995__$1;
(statearr_70004_70030[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (3))){
var inst_69993 = (state_69995[(2)]);
var state_69995__$1 = state_69995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69995__$1,inst_69993);
} else {
if((state_val_69996 === (12))){
var inst_69970 = (state_69995[(8)]);
var inst_69971 = (state_69995[(9)]);
var inst_69964 = (state_69995[(10)]);
var inst_69983 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69964,inst_69970);
var inst_69963 = inst_69971;
var inst_69964__$1 = inst_69983;
var state_69995__$1 = (function (){var statearr_70005 = state_69995;
(statearr_70005[(7)] = inst_69963);

(statearr_70005[(10)] = inst_69964__$1);

return statearr_70005;
})();
var statearr_70006_70031 = state_69995__$1;
(statearr_70006_70031[(2)] = null);

(statearr_70006_70031[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (2))){
var _ = (function (){var statearr_70007 = state_69995;
(statearr_70007[(4)] = cljs.core.cons((5),(state_69995[(4)])));

return statearr_70007;
})();
var inst_69958 = args;
var inst_69959 = cljs.core.seq(inst_69958);
var inst_69960 = cljs.core.first(inst_69959);
var inst_69961 = cljs.core.next(inst_69959);
var inst_69962 = cljs.core.PersistentVector.EMPTY;
var inst_69963 = inst_69958;
var inst_69964 = inst_69962;
var state_69995__$1 = (function (){var statearr_70008 = state_69995;
(statearr_70008[(11)] = inst_69961);

(statearr_70008[(7)] = inst_69963);

(statearr_70008[(12)] = inst_69960);

(statearr_70008[(10)] = inst_69964);

return statearr_70008;
})();
var statearr_70009_70032 = state_69995__$1;
(statearr_70009_70032[(2)] = null);

(statearr_70009_70032[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (11))){
var inst_69970 = (state_69995[(8)]);
var state_69995__$1 = state_69995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69995__$1,(14),inst_69970);
} else {
if((state_val_69996 === (9))){
var inst_69970 = (state_69995[(8)]);
var inst_69975 = fluree.db.util.async.channel_QMARK_(inst_69970);
var state_69995__$1 = state_69995;
if(inst_69975){
var statearr_70011_70033 = state_69995__$1;
(statearr_70011_70033[(1)] = (11));

} else {
var statearr_70012_70034 = state_69995__$1;
(statearr_70012_70034[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (5))){
var _ = (function (){var statearr_70013 = state_69995;
(statearr_70013[(4)] = cljs.core.rest((state_69995[(4)])));

return statearr_70013;
})();
var state_69995__$1 = state_69995;
var ex70010 = (state_69995__$1[(2)]);
var statearr_70014_70035 = state_69995__$1;
(statearr_70014_70035[(5)] = ex70010);


if((ex70010 instanceof Error)){
var statearr_70015_70036 = state_69995__$1;
(statearr_70015_70036[(1)] = (4));

(statearr_70015_70036[(5)] = null);

} else {
throw ex70010;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (14))){
var inst_69971 = (state_69995[(9)]);
var inst_69964 = (state_69995[(10)]);
var inst_69978 = (state_69995[(2)]);
var inst_69979 = fluree.db.util.async.throw_err(inst_69978);
var inst_69980 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69964,inst_69979);
var inst_69963 = inst_69971;
var inst_69964__$1 = inst_69980;
var state_69995__$1 = (function (){var statearr_70016 = state_69995;
(statearr_70016[(7)] = inst_69963);

(statearr_70016[(10)] = inst_69964__$1);

return statearr_70016;
})();
var statearr_70017_70037 = state_69995__$1;
(statearr_70017_70037[(2)] = null);

(statearr_70017_70037[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (10))){
var inst_69988 = (state_69995[(2)]);
var state_69995__$1 = state_69995;
var statearr_70018_70038 = state_69995__$1;
(statearr_70018_70038[(2)] = inst_69988);

(statearr_70018_70038[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69996 === (8))){
var inst_69964 = (state_69995[(10)]);
var state_69995__$1 = state_69995;
var statearr_70019_70039 = state_69995__$1;
(statearr_70019_70039[(2)] = inst_69964);

(statearr_70019_70039[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0 = (function (){
var statearr_70020 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70020[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__);

(statearr_70020[(1)] = (1));

return statearr_70020;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1 = (function (state_69995){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_69995);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70021){var ex__13886__auto__ = e70021;
var statearr_70022_70040 = state_69995;
(statearr_70022_70040[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_69995[(4)]))){
var statearr_70023_70041 = state_69995;
(statearr_70023_70041[(1)] = cljs.core.first((state_69995[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70042 = state_69995;
state_69995 = G__70042;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__ = function(state_69995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1.call(this,state_69995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70024 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70024[(6)] = c__13957__auto__);

return statearr_70024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__70043 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70043,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70043,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70091){
var state_val_70092 = (state_70091[(1)]);
if((state_val_70092 === (7))){
var state_70091__$1 = state_70091;
var statearr_70093_70122 = state_70091__$1;
(statearr_70093_70122[(2)] = coll);

(statearr_70093_70122[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (1))){
var state_70091__$1 = state_70091;
var statearr_70094_70123 = state_70091__$1;
(statearr_70094_70123[(2)] = null);

(statearr_70094_70123[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (4))){
var inst_70046 = (state_70091[(2)]);
var state_70091__$1 = state_70091;
var statearr_70095_70124 = state_70091__$1;
(statearr_70095_70124[(2)] = inst_70046);

(statearr_70095_70124[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (15))){
var inst_70065 = (state_70091[(7)]);
var inst_70073 = (state_70091[(2)]);
var inst_70074 = fluree.db.dbfunctions.internal.nth(inst_70065,inst_70073);
var inst_70075 = cljs.core.count(inst_70065);
var inst_70076 = ((9) + inst_70075);
var inst_70077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70078 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70080 = [inst_70065,inst_70073];
var inst_70081 = (new cljs.core.PersistentVector(null,2,(5),inst_70079,inst_70080,null));
var inst_70082 = ["nth",inst_70081,inst_70074];
var inst_70083 = cljs.core.PersistentHashMap.fromArrays(inst_70078,inst_70082);
var inst_70084 = [inst_70083,inst_70076];
var inst_70085 = (new cljs.core.PersistentVector(null,2,(5),inst_70077,inst_70084,null));
var inst_70086 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70085);
var _ = (function (){var statearr_70096 = state_70091;
(statearr_70096[(4)] = cljs.core.rest((state_70091[(4)])));

return statearr_70096;
})();
var state_70091__$1 = (function (){var statearr_70097 = state_70091;
(statearr_70097[(8)] = inst_70086);

return statearr_70097;
})();
var statearr_70098_70125 = state_70091__$1;
(statearr_70098_70125[(2)] = inst_70074);

(statearr_70098_70125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (13))){
var state_70091__$1 = state_70091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70091__$1,(16),key);
} else {
if((state_val_70092 === (6))){
var state_70091__$1 = state_70091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70091__$1,(9),coll);
} else {
if((state_val_70092 === (3))){
var inst_70089 = (state_70091[(2)]);
var state_70091__$1 = state_70091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70091__$1,inst_70089);
} else {
if((state_val_70092 === (12))){
var inst_70065 = (state_70091[(2)]);
var inst_70066 = fluree.db.util.async.channel_QMARK_(key);
var state_70091__$1 = (function (){var statearr_70099 = state_70091;
(statearr_70099[(7)] = inst_70065);

return statearr_70099;
})();
if(inst_70066){
var statearr_70100_70126 = state_70091__$1;
(statearr_70100_70126[(1)] = (13));

} else {
var statearr_70101_70127 = state_70091__$1;
(statearr_70101_70127[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (2))){
var _ = (function (){var statearr_70102 = state_70091;
(statearr_70102[(4)] = cljs.core.cons((5),(state_70091[(4)])));

return statearr_70102;
})();
var inst_70052 = fluree.db.util.async.channel_QMARK_(coll);
var state_70091__$1 = state_70091;
if(inst_70052){
var statearr_70103_70128 = state_70091__$1;
(statearr_70103_70128[(1)] = (6));

} else {
var statearr_70104_70129 = state_70091__$1;
(statearr_70104_70129[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (11))){
var inst_70059 = (state_70091[(9)]);
var state_70091__$1 = state_70091;
var statearr_70106_70130 = state_70091__$1;
(statearr_70106_70130[(2)] = inst_70059);

(statearr_70106_70130[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (9))){
var inst_70055 = (state_70091[(2)]);
var inst_70056 = fluree.db.util.async.throw_err(inst_70055);
var state_70091__$1 = state_70091;
var statearr_70107_70131 = state_70091__$1;
(statearr_70107_70131[(2)] = inst_70056);

(statearr_70107_70131[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (5))){
var _ = (function (){var statearr_70108 = state_70091;
(statearr_70108[(4)] = cljs.core.rest((state_70091[(4)])));

return statearr_70108;
})();
var state_70091__$1 = state_70091;
var ex70105 = (state_70091__$1[(2)]);
var statearr_70109_70132 = state_70091__$1;
(statearr_70109_70132[(5)] = ex70105);


if((ex70105 instanceof Error)){
var statearr_70110_70133 = state_70091__$1;
(statearr_70110_70133[(1)] = (4));

(statearr_70110_70133[(5)] = null);

} else {
throw ex70105;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (14))){
var state_70091__$1 = state_70091;
var statearr_70111_70134 = state_70091__$1;
(statearr_70111_70134[(2)] = key);

(statearr_70111_70134[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (16))){
var inst_70069 = (state_70091[(2)]);
var inst_70070 = fluree.db.util.async.throw_err(inst_70069);
var state_70091__$1 = state_70091;
var statearr_70112_70135 = state_70091__$1;
(statearr_70112_70135[(2)] = inst_70070);

(statearr_70112_70135[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (10))){
var inst_70059 = (state_70091[(9)]);
var inst_70062 = cljs.core.vec(inst_70059);
var state_70091__$1 = state_70091;
var statearr_70113_70136 = state_70091__$1;
(statearr_70113_70136[(2)] = inst_70062);

(statearr_70113_70136[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70092 === (8))){
var inst_70059 = (state_70091[(9)]);
var inst_70059__$1 = (state_70091[(2)]);
var inst_70060 = cljs.core.set_QMARK_(inst_70059__$1);
var state_70091__$1 = (function (){var statearr_70114 = state_70091;
(statearr_70114[(9)] = inst_70059__$1);

return statearr_70114;
})();
if(inst_70060){
var statearr_70115_70137 = state_70091__$1;
(statearr_70115_70137[(1)] = (10));

} else {
var statearr_70116_70138 = state_70091__$1;
(statearr_70116_70138[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0 = (function (){
var statearr_70117 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70117[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__);

(statearr_70117[(1)] = (1));

return statearr_70117;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1 = (function (state_70091){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70091);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70118){var ex__13886__auto__ = e70118;
var statearr_70119_70139 = state_70091;
(statearr_70119_70139[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70091[(4)]))){
var statearr_70120_70140 = state_70091;
(statearr_70120_70140[(1)] = cljs.core.first((state_70091[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70141 = state_70091;
state_70091 = G__70141;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__ = function(state_70091){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1.call(this,state_70091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70121 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70121[(6)] = c__13957__auto__);

return statearr_70121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70202){
var state_val_70203 = (state_70202[(1)]);
if((state_val_70203 === (7))){
var state_70202__$1 = state_70202;
var statearr_70204_70238 = state_70202__$1;
(statearr_70204_70238[(2)] = test);

(statearr_70204_70238[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (20))){
var inst_70176 = (state_70202[(2)]);
var inst_70177 = fluree.db.util.async.throw_err(inst_70176);
var state_70202__$1 = state_70202;
var statearr_70205_70239 = state_70202__$1;
(statearr_70205_70239[(2)] = inst_70177);

(statearr_70205_70239[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (1))){
var state_70202__$1 = state_70202;
var statearr_70206_70240 = state_70202__$1;
(statearr_70206_70240[(2)] = null);

(statearr_70206_70240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (4))){
var inst_70142 = (state_70202[(2)]);
var state_70202__$1 = state_70202;
var statearr_70207_70241 = state_70202__$1;
(statearr_70207_70241[(2)] = inst_70142);

(statearr_70207_70241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (15))){
var inst_70160 = (state_70202[(7)]);
var inst_70168 = (state_70202[(2)]);
var inst_70169 = [inst_70168,f];
var inst_70170 = (new cljs.core.PersistentVector(null,2,(5),inst_70160,inst_70169,null));
var state_70202__$1 = state_70202;
var statearr_70208_70242 = state_70202__$1;
(statearr_70208_70242[(2)] = inst_70170);

(statearr_70208_70242[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (13))){
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70202__$1,(16),t);
} else {
if((state_val_70203 === (6))){
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70202__$1,(9),test);
} else {
if((state_val_70203 === (17))){
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70202__$1,(20),f);
} else {
if((state_val_70203 === (3))){
var inst_70200 = (state_70202[(2)]);
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70202__$1,inst_70200);
} else {
if((state_val_70203 === (12))){
var inst_70158 = (state_70202[(8)]);
var inst_70184 = (state_70202[(2)]);
var inst_70185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70184,(0),null);
var inst_70186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70184,(1),null);
var inst_70187 = fluree.db.dbfunctions.internal.if_else(inst_70158,inst_70185,inst_70186);
var inst_70188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70189 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70191 = [inst_70158,inst_70185,inst_70186];
var inst_70192 = (new cljs.core.PersistentVector(null,3,(5),inst_70190,inst_70191,null));
var inst_70193 = ["if-else",inst_70192,inst_70187];
var inst_70194 = cljs.core.PersistentHashMap.fromArrays(inst_70189,inst_70193);
var inst_70195 = [inst_70194,(10)];
var inst_70196 = (new cljs.core.PersistentVector(null,2,(5),inst_70188,inst_70195,null));
var inst_70197 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70196);
var _ = (function (){var statearr_70209 = state_70202;
(statearr_70209[(4)] = cljs.core.rest((state_70202[(4)])));

return statearr_70209;
})();
var state_70202__$1 = (function (){var statearr_70210 = state_70202;
(statearr_70210[(9)] = inst_70197);

return statearr_70210;
})();
var statearr_70211_70243 = state_70202__$1;
(statearr_70211_70243[(2)] = inst_70187);

(statearr_70211_70243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (2))){
var _ = (function (){var statearr_70212 = state_70202;
(statearr_70212[(4)] = cljs.core.cons((5),(state_70202[(4)])));

return statearr_70212;
})();
var inst_70151 = fluree.db.util.async.channel_QMARK_(test);
var state_70202__$1 = state_70202;
if(inst_70151){
var statearr_70213_70244 = state_70202__$1;
(statearr_70213_70244[(1)] = (6));

} else {
var statearr_70214_70245 = state_70202__$1;
(statearr_70214_70245[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (19))){
var inst_70172 = (state_70202[(10)]);
var inst_70180 = (state_70202[(2)]);
var inst_70181 = [f,inst_70180];
var inst_70182 = (new cljs.core.PersistentVector(null,2,(5),inst_70172,inst_70181,null));
var state_70202__$1 = state_70202;
var statearr_70215_70246 = state_70202__$1;
(statearr_70215_70246[(2)] = inst_70182);

(statearr_70215_70246[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (11))){
var inst_70172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70173 = fluree.db.util.async.channel_QMARK_(f);
var state_70202__$1 = (function (){var statearr_70217 = state_70202;
(statearr_70217[(10)] = inst_70172);

return statearr_70217;
})();
if(inst_70173){
var statearr_70218_70247 = state_70202__$1;
(statearr_70218_70247[(1)] = (17));

} else {
var statearr_70219_70248 = state_70202__$1;
(statearr_70219_70248[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (9))){
var inst_70154 = (state_70202[(2)]);
var inst_70155 = fluree.db.util.async.throw_err(inst_70154);
var state_70202__$1 = state_70202;
var statearr_70220_70249 = state_70202__$1;
(statearr_70220_70249[(2)] = inst_70155);

(statearr_70220_70249[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (5))){
var _ = (function (){var statearr_70221 = state_70202;
(statearr_70221[(4)] = cljs.core.rest((state_70202[(4)])));

return statearr_70221;
})();
var state_70202__$1 = state_70202;
var ex70216 = (state_70202__$1[(2)]);
var statearr_70222_70250 = state_70202__$1;
(statearr_70222_70250[(5)] = ex70216);


if((ex70216 instanceof Error)){
var statearr_70223_70251 = state_70202__$1;
(statearr_70223_70251[(1)] = (4));

(statearr_70223_70251[(5)] = null);

} else {
throw ex70216;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (14))){
var state_70202__$1 = state_70202;
var statearr_70224_70252 = state_70202__$1;
(statearr_70224_70252[(2)] = t);

(statearr_70224_70252[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (16))){
var inst_70164 = (state_70202[(2)]);
var inst_70165 = fluree.db.util.async.throw_err(inst_70164);
var state_70202__$1 = state_70202;
var statearr_70225_70253 = state_70202__$1;
(statearr_70225_70253[(2)] = inst_70165);

(statearr_70225_70253[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (10))){
var inst_70160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70161 = fluree.db.util.async.channel_QMARK_(t);
var state_70202__$1 = (function (){var statearr_70226 = state_70202;
(statearr_70226[(7)] = inst_70160);

return statearr_70226;
})();
if(inst_70161){
var statearr_70227_70254 = state_70202__$1;
(statearr_70227_70254[(1)] = (13));

} else {
var statearr_70228_70255 = state_70202__$1;
(statearr_70228_70255[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (18))){
var state_70202__$1 = state_70202;
var statearr_70229_70256 = state_70202__$1;
(statearr_70229_70256[(2)] = f);

(statearr_70229_70256[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70203 === (8))){
var inst_70158 = (state_70202[(8)]);
var inst_70158__$1 = (state_70202[(2)]);
var state_70202__$1 = (function (){var statearr_70230 = state_70202;
(statearr_70230[(8)] = inst_70158__$1);

return statearr_70230;
})();
if(cljs.core.truth_(inst_70158__$1)){
var statearr_70231_70257 = state_70202__$1;
(statearr_70231_70257[(1)] = (10));

} else {
var statearr_70232_70258 = state_70202__$1;
(statearr_70232_70258[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0 = (function (){
var statearr_70233 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70233[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__);

(statearr_70233[(1)] = (1));

return statearr_70233;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1 = (function (state_70202){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70202);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70234){var ex__13886__auto__ = e70234;
var statearr_70235_70259 = state_70202;
(statearr_70235_70259[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70202[(4)]))){
var statearr_70236_70260 = state_70202;
(statearr_70236_70260[(1)] = cljs.core.first((state_70202[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70261 = state_70202;
state_70202 = G__70261;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__ = function(state_70202){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1.call(this,state_70202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70237 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70237[(6)] = c__13957__auto__);

return statearr_70237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70291){
var state_val_70292 = (state_70291[(1)]);
if((state_val_70292 === (7))){
var state_70291__$1 = state_70291;
var statearr_70293_70312 = state_70291__$1;
(statearr_70293_70312[(2)] = arg);

(statearr_70293_70312[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (1))){
var state_70291__$1 = state_70291;
var statearr_70294_70313 = state_70291__$1;
(statearr_70294_70313[(2)] = null);

(statearr_70294_70313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (4))){
var inst_70262 = (state_70291[(2)]);
var state_70291__$1 = state_70291;
var statearr_70295_70314 = state_70291__$1;
(statearr_70295_70314[(2)] = inst_70262);

(statearr_70295_70314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (6))){
var state_70291__$1 = state_70291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70291__$1,(9),arg);
} else {
if((state_val_70292 === (3))){
var inst_70289 = (state_70291[(2)]);
var state_70291__$1 = state_70291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70291__$1,inst_70289);
} else {
if((state_val_70292 === (2))){
var _ = (function (){var statearr_70297 = state_70291;
(statearr_70297[(4)] = cljs.core.cons((5),(state_70291[(4)])));

return statearr_70297;
})();
var inst_70268 = fluree.db.util.async.channel_QMARK_(arg);
var state_70291__$1 = state_70291;
if(inst_70268){
var statearr_70298_70315 = state_70291__$1;
(statearr_70298_70315[(1)] = (6));

} else {
var statearr_70299_70316 = state_70291__$1;
(statearr_70299_70316[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (9))){
var inst_70271 = (state_70291[(2)]);
var inst_70272 = fluree.db.util.async.throw_err(inst_70271);
var state_70291__$1 = state_70291;
var statearr_70300_70317 = state_70291__$1;
(statearr_70300_70317[(2)] = inst_70272);

(statearr_70300_70317[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (5))){
var _ = (function (){var statearr_70301 = state_70291;
(statearr_70301[(4)] = cljs.core.rest((state_70291[(4)])));

return statearr_70301;
})();
var state_70291__$1 = state_70291;
var ex70296 = (state_70291__$1[(2)]);
var statearr_70302_70318 = state_70291__$1;
(statearr_70302_70318[(5)] = ex70296);


if((ex70296 instanceof Error)){
var statearr_70303_70319 = state_70291__$1;
(statearr_70303_70319[(1)] = (4));

(statearr_70303_70319[(5)] = null);

} else {
throw ex70296;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70292 === (8))){
var inst_70275 = (state_70291[(2)]);
var inst_70276 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_70275);
var inst_70277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70278 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70280 = [inst_70275];
var inst_70281 = (new cljs.core.PersistentVector(null,1,(5),inst_70279,inst_70280,null));
var inst_70282 = ["nil?",inst_70281,inst_70276];
var inst_70283 = cljs.core.PersistentHashMap.fromArrays(inst_70278,inst_70282);
var inst_70284 = [inst_70283,(10)];
var inst_70285 = (new cljs.core.PersistentVector(null,2,(5),inst_70277,inst_70284,null));
var inst_70286 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70285);
var _ = (function (){var statearr_70304 = state_70291;
(statearr_70304[(4)] = cljs.core.rest((state_70291[(4)])));

return statearr_70304;
})();
var state_70291__$1 = (function (){var statearr_70305 = state_70291;
(statearr_70305[(7)] = inst_70286);

return statearr_70305;
})();
var statearr_70306_70320 = state_70291__$1;
(statearr_70306_70320[(2)] = inst_70276);

(statearr_70306_70320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_70307 = [null,null,null,null,null,null,null,null];
(statearr_70307[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__);

(statearr_70307[(1)] = (1));

return statearr_70307;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1 = (function (state_70291){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70291);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70308){var ex__13886__auto__ = e70308;
var statearr_70309_70321 = state_70291;
(statearr_70309_70321[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70291[(4)]))){
var statearr_70310_70322 = state_70291;
(statearr_70310_70322[(1)] = cljs.core.first((state_70291[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70323 = state_70291;
state_70291 = G__70323;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__ = function(state_70291){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1.call(this,state_70291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70311 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70311[(6)] = c__13957__auto__);

return statearr_70311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70353){
var state_val_70354 = (state_70353[(1)]);
if((state_val_70354 === (7))){
var state_70353__$1 = state_70353;
var statearr_70355_70374 = state_70353__$1;
(statearr_70355_70374[(2)] = arg);

(statearr_70355_70374[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (1))){
var state_70353__$1 = state_70353;
var statearr_70356_70375 = state_70353__$1;
(statearr_70356_70375[(2)] = null);

(statearr_70356_70375[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (4))){
var inst_70324 = (state_70353[(2)]);
var state_70353__$1 = state_70353;
var statearr_70357_70376 = state_70353__$1;
(statearr_70357_70376[(2)] = inst_70324);

(statearr_70357_70376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (6))){
var state_70353__$1 = state_70353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70353__$1,(9),arg);
} else {
if((state_val_70354 === (3))){
var inst_70351 = (state_70353[(2)]);
var state_70353__$1 = state_70353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70353__$1,inst_70351);
} else {
if((state_val_70354 === (2))){
var _ = (function (){var statearr_70359 = state_70353;
(statearr_70359[(4)] = cljs.core.cons((5),(state_70353[(4)])));

return statearr_70359;
})();
var inst_70330 = fluree.db.util.async.channel_QMARK_(arg);
var state_70353__$1 = state_70353;
if(inst_70330){
var statearr_70360_70377 = state_70353__$1;
(statearr_70360_70377[(1)] = (6));

} else {
var statearr_70361_70378 = state_70353__$1;
(statearr_70361_70378[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (9))){
var inst_70333 = (state_70353[(2)]);
var inst_70334 = fluree.db.util.async.throw_err(inst_70333);
var state_70353__$1 = state_70353;
var statearr_70362_70379 = state_70353__$1;
(statearr_70362_70379[(2)] = inst_70334);

(statearr_70362_70379[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (5))){
var _ = (function (){var statearr_70363 = state_70353;
(statearr_70363[(4)] = cljs.core.rest((state_70353[(4)])));

return statearr_70363;
})();
var state_70353__$1 = state_70353;
var ex70358 = (state_70353__$1[(2)]);
var statearr_70364_70380 = state_70353__$1;
(statearr_70364_70380[(5)] = ex70358);


if((ex70358 instanceof Error)){
var statearr_70365_70381 = state_70353__$1;
(statearr_70365_70381[(1)] = (4));

(statearr_70365_70381[(5)] = null);

} else {
throw ex70358;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70354 === (8))){
var inst_70337 = (state_70353[(2)]);
var inst_70338 = fluree.db.dbfunctions.internal.not(inst_70337);
var inst_70339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70340 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70342 = [inst_70337];
var inst_70343 = (new cljs.core.PersistentVector(null,1,(5),inst_70341,inst_70342,null));
var inst_70344 = ["not?",inst_70343,inst_70338];
var inst_70345 = cljs.core.PersistentHashMap.fromArrays(inst_70340,inst_70344);
var inst_70346 = [inst_70345,(10)];
var inst_70347 = (new cljs.core.PersistentVector(null,2,(5),inst_70339,inst_70346,null));
var inst_70348 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70347);
var _ = (function (){var statearr_70366 = state_70353;
(statearr_70366[(4)] = cljs.core.rest((state_70353[(4)])));

return statearr_70366;
})();
var state_70353__$1 = (function (){var statearr_70367 = state_70353;
(statearr_70367[(7)] = inst_70348);

return statearr_70367;
})();
var statearr_70368_70382 = state_70353__$1;
(statearr_70368_70382[(2)] = inst_70338);

(statearr_70368_70382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0 = (function (){
var statearr_70369 = [null,null,null,null,null,null,null,null];
(statearr_70369[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__);

(statearr_70369[(1)] = (1));

return statearr_70369;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1 = (function (state_70353){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70353);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70370){var ex__13886__auto__ = e70370;
var statearr_70371_70383 = state_70353;
(statearr_70371_70383[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70353[(4)]))){
var statearr_70372_70384 = state_70353;
(statearr_70372_70384[(1)] = cljs.core.first((state_70353[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70385 = state_70353;
state_70353 = G__70385;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__ = function(state_70353){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1.call(this,state_70353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70373 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70373[(6)] = c__13957__auto__);

return statearr_70373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70415){
var state_val_70416 = (state_70415[(1)]);
if((state_val_70416 === (7))){
var state_70415__$1 = state_70415;
var statearr_70417_70436 = state_70415__$1;
(statearr_70417_70436[(2)] = arg);

(statearr_70417_70436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (1))){
var state_70415__$1 = state_70415;
var statearr_70418_70437 = state_70415__$1;
(statearr_70418_70437[(2)] = null);

(statearr_70418_70437[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (4))){
var inst_70386 = (state_70415[(2)]);
var state_70415__$1 = state_70415;
var statearr_70419_70438 = state_70415__$1;
(statearr_70419_70438[(2)] = inst_70386);

(statearr_70419_70438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (6))){
var state_70415__$1 = state_70415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70415__$1,(9),arg);
} else {
if((state_val_70416 === (3))){
var inst_70413 = (state_70415[(2)]);
var state_70415__$1 = state_70415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70415__$1,inst_70413);
} else {
if((state_val_70416 === (2))){
var _ = (function (){var statearr_70421 = state_70415;
(statearr_70421[(4)] = cljs.core.cons((5),(state_70415[(4)])));

return statearr_70421;
})();
var inst_70392 = fluree.db.util.async.channel_QMARK_(arg);
var state_70415__$1 = state_70415;
if(inst_70392){
var statearr_70422_70439 = state_70415__$1;
(statearr_70422_70439[(1)] = (6));

} else {
var statearr_70423_70440 = state_70415__$1;
(statearr_70423_70440[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (9))){
var inst_70395 = (state_70415[(2)]);
var inst_70396 = fluree.db.util.async.throw_err(inst_70395);
var state_70415__$1 = state_70415;
var statearr_70424_70441 = state_70415__$1;
(statearr_70424_70441[(2)] = inst_70396);

(statearr_70424_70441[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (5))){
var _ = (function (){var statearr_70425 = state_70415;
(statearr_70425[(4)] = cljs.core.rest((state_70415[(4)])));

return statearr_70425;
})();
var state_70415__$1 = state_70415;
var ex70420 = (state_70415__$1[(2)]);
var statearr_70426_70442 = state_70415__$1;
(statearr_70426_70442[(5)] = ex70420);


if((ex70420 instanceof Error)){
var statearr_70427_70443 = state_70415__$1;
(statearr_70427_70443[(1)] = (4));

(statearr_70427_70443[(5)] = null);

} else {
throw ex70420;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70416 === (8))){
var inst_70399 = (state_70415[(2)]);
var inst_70400 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_70399);
var inst_70401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70402 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70404 = [inst_70399];
var inst_70405 = (new cljs.core.PersistentVector(null,1,(5),inst_70403,inst_70404,null));
var inst_70406 = ["empty?",inst_70405,inst_70400];
var inst_70407 = cljs.core.PersistentHashMap.fromArrays(inst_70402,inst_70406);
var inst_70408 = [inst_70407,(10)];
var inst_70409 = (new cljs.core.PersistentVector(null,2,(5),inst_70401,inst_70408,null));
var inst_70410 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70409);
var _ = (function (){var statearr_70428 = state_70415;
(statearr_70428[(4)] = cljs.core.rest((state_70415[(4)])));

return statearr_70428;
})();
var state_70415__$1 = (function (){var statearr_70429 = state_70415;
(statearr_70429[(7)] = inst_70410);

return statearr_70429;
})();
var statearr_70430_70444 = state_70415__$1;
(statearr_70430_70444[(2)] = inst_70400);

(statearr_70430_70444[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_70431 = [null,null,null,null,null,null,null,null];
(statearr_70431[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__);

(statearr_70431[(1)] = (1));

return statearr_70431;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1 = (function (state_70415){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70415);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70432){var ex__13886__auto__ = e70432;
var statearr_70433_70445 = state_70415;
(statearr_70433_70445[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70415[(4)]))){
var statearr_70434_70446 = state_70415;
(statearr_70434_70446[(1)] = cljs.core.first((state_70415[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70447 = state_70415;
state_70415 = G__70447;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__ = function(state_70415){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1.call(this,state_70415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70435 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70435[(6)] = c__13957__auto__);

return statearr_70435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70492 = arguments.length;
var i__4772__auto___70493 = (0);
while(true){
if((i__4772__auto___70493 < len__4771__auto___70492)){
args__4777__auto__.push((arguments[i__4772__auto___70493]));

var G__70494 = (i__4772__auto___70493 + (1));
i__4772__auto___70493 = G__70494;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70475){
var state_val_70476 = (state_70475[(1)]);
if((state_val_70476 === (1))){
var state_70475__$1 = state_70475;
var statearr_70477_70495 = state_70475__$1;
(statearr_70477_70495[(2)] = null);

(statearr_70477_70495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70476 === (2))){
var _ = (function (){var statearr_70478 = state_70475;
(statearr_70478[(4)] = cljs.core.cons((5),(state_70475[(4)])));

return statearr_70478;
})();
var inst_70456 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70475__$1 = state_70475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70475__$1,(6),inst_70456);
} else {
if((state_val_70476 === (3))){
var inst_70473 = (state_70475[(2)]);
var state_70475__$1 = state_70475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70475__$1,inst_70473);
} else {
if((state_val_70476 === (4))){
var inst_70450 = (state_70475[(2)]);
var state_70475__$1 = state_70475;
var statearr_70480_70496 = state_70475__$1;
(statearr_70480_70496[(2)] = inst_70450);

(statearr_70480_70496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70476 === (5))){
var _ = (function (){var statearr_70481 = state_70475;
(statearr_70481[(4)] = cljs.core.rest((state_70475[(4)])));

return statearr_70481;
})();
var state_70475__$1 = state_70475;
var ex70479 = (state_70475__$1[(2)]);
var statearr_70482_70497 = state_70475__$1;
(statearr_70482_70497[(5)] = ex70479);


if((ex70479 instanceof Error)){
var statearr_70483_70498 = state_70475__$1;
(statearr_70483_70498[(1)] = (4));

(statearr_70483_70498[(5)] = null);

} else {
throw ex70479;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70476 === (6))){
var inst_70458 = (state_70475[(2)]);
var inst_70459 = fluree.db.util.async.throw_err(inst_70458);
var inst_70460 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_70459);
var inst_70461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70462 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70464 = [inst_70459];
var inst_70465 = (new cljs.core.PersistentVector(null,1,(5),inst_70463,inst_70464,null));
var inst_70466 = ["str",inst_70465,inst_70460];
var inst_70467 = cljs.core.PersistentHashMap.fromArrays(inst_70462,inst_70466);
var inst_70468 = [inst_70467,(10)];
var inst_70469 = (new cljs.core.PersistentVector(null,2,(5),inst_70461,inst_70468,null));
var inst_70470 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70469);
var _ = (function (){var statearr_70484 = state_70475;
(statearr_70484[(4)] = cljs.core.rest((state_70475[(4)])));

return statearr_70484;
})();
var state_70475__$1 = (function (){var statearr_70485 = state_70475;
(statearr_70485[(7)] = inst_70470);

return statearr_70485;
})();
var statearr_70486_70499 = state_70475__$1;
(statearr_70486_70499[(2)] = inst_70460);

(statearr_70486_70499[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70487 = [null,null,null,null,null,null,null,null];
(statearr_70487[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70487[(1)] = (1));

return statearr_70487;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70475){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70475);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70488){var ex__13886__auto__ = e70488;
var statearr_70489_70500 = state_70475;
(statearr_70489_70500[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70475[(4)]))){
var statearr_70490_70501 = state_70475;
(statearr_70490_70501[(1)] = cljs.core.first((state_70475[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70502 = state_70475;
state_70475 = G__70502;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70475){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70491 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70491[(6)] = c__13957__auto__);

return statearr_70491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq70448){
var G__70449 = cljs.core.first(seq70448);
var seq70448__$1 = cljs.core.next(seq70448);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70449,seq70448__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70528){
var state_val_70529 = (state_70528[(1)]);
if((state_val_70529 === (1))){
var state_70528__$1 = state_70528;
var statearr_70530_70545 = state_70528__$1;
(statearr_70530_70545[(2)] = null);

(statearr_70530_70545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70529 === (2))){
var _ = (function (){var statearr_70531 = state_70528;
(statearr_70531[(4)] = cljs.core.cons((5),(state_70528[(4)])));

return statearr_70531;
})();
var inst_70509 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70528__$1 = state_70528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70528__$1,(6),inst_70509);
} else {
if((state_val_70529 === (3))){
var inst_70526 = (state_70528[(2)]);
var state_70528__$1 = state_70528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70528__$1,inst_70526);
} else {
if((state_val_70529 === (4))){
var inst_70503 = (state_70528[(2)]);
var state_70528__$1 = state_70528;
var statearr_70533_70546 = state_70528__$1;
(statearr_70533_70546[(2)] = inst_70503);

(statearr_70533_70546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70529 === (5))){
var _ = (function (){var statearr_70534 = state_70528;
(statearr_70534[(4)] = cljs.core.rest((state_70528[(4)])));

return statearr_70534;
})();
var state_70528__$1 = state_70528;
var ex70532 = (state_70528__$1[(2)]);
var statearr_70535_70547 = state_70528__$1;
(statearr_70535_70547[(5)] = ex70532);


if((ex70532 instanceof Error)){
var statearr_70536_70548 = state_70528__$1;
(statearr_70536_70548[(1)] = (4));

(statearr_70536_70548[(5)] = null);

} else {
throw ex70532;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70529 === (6))){
var inst_70511 = (state_70528[(2)]);
var inst_70512 = fluree.db.util.async.throw_err(inst_70511);
var inst_70513 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_70512);
var inst_70514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70515 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70517 = [inst_70512];
var inst_70518 = (new cljs.core.PersistentVector(null,1,(5),inst_70516,inst_70517,null));
var inst_70519 = ["subs",inst_70518,inst_70513];
var inst_70520 = cljs.core.PersistentHashMap.fromArrays(inst_70515,inst_70519);
var inst_70521 = [inst_70520,(30)];
var inst_70522 = (new cljs.core.PersistentVector(null,2,(5),inst_70514,inst_70521,null));
var inst_70523 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70522);
var _ = (function (){var statearr_70537 = state_70528;
(statearr_70537[(4)] = cljs.core.rest((state_70528[(4)])));

return statearr_70537;
})();
var state_70528__$1 = (function (){var statearr_70538 = state_70528;
(statearr_70538[(7)] = inst_70523);

return statearr_70538;
})();
var statearr_70539_70549 = state_70528__$1;
(statearr_70539_70549[(2)] = inst_70513);

(statearr_70539_70549[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0 = (function (){
var statearr_70540 = [null,null,null,null,null,null,null,null];
(statearr_70540[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__);

(statearr_70540[(1)] = (1));

return statearr_70540;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1 = (function (state_70528){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70528);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70541){var ex__13886__auto__ = e70541;
var statearr_70542_70550 = state_70528;
(statearr_70542_70550[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70528[(4)]))){
var statearr_70543_70551 = state_70528;
(statearr_70543_70551[(1)] = cljs.core.first((state_70528[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70552 = state_70528;
state_70528 = G__70552;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__ = function(state_70528){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1.call(this,state_70528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70544 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70544[(6)] = c__13957__auto__);

return statearr_70544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70582){
var state_val_70583 = (state_70582[(1)]);
if((state_val_70583 === (7))){
var state_70582__$1 = state_70582;
var statearr_70584_70603 = state_70582__$1;
(statearr_70584_70603[(2)] = str);

(statearr_70584_70603[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (1))){
var state_70582__$1 = state_70582;
var statearr_70585_70604 = state_70582__$1;
(statearr_70585_70604[(2)] = null);

(statearr_70585_70604[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (4))){
var inst_70553 = (state_70582[(2)]);
var state_70582__$1 = state_70582;
var statearr_70586_70605 = state_70582__$1;
(statearr_70586_70605[(2)] = inst_70553);

(statearr_70586_70605[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (6))){
var state_70582__$1 = state_70582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70582__$1,(9),str);
} else {
if((state_val_70583 === (3))){
var inst_70580 = (state_70582[(2)]);
var state_70582__$1 = state_70582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70582__$1,inst_70580);
} else {
if((state_val_70583 === (2))){
var _ = (function (){var statearr_70588 = state_70582;
(statearr_70588[(4)] = cljs.core.cons((5),(state_70582[(4)])));

return statearr_70588;
})();
var inst_70559 = fluree.db.util.async.channel_QMARK_(str);
var state_70582__$1 = state_70582;
if(inst_70559){
var statearr_70589_70606 = state_70582__$1;
(statearr_70589_70606[(1)] = (6));

} else {
var statearr_70590_70607 = state_70582__$1;
(statearr_70590_70607[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (9))){
var inst_70562 = (state_70582[(2)]);
var inst_70563 = fluree.db.util.async.throw_err(inst_70562);
var state_70582__$1 = state_70582;
var statearr_70591_70608 = state_70582__$1;
(statearr_70591_70608[(2)] = inst_70563);

(statearr_70591_70608[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (5))){
var _ = (function (){var statearr_70592 = state_70582;
(statearr_70592[(4)] = cljs.core.rest((state_70582[(4)])));

return statearr_70592;
})();
var state_70582__$1 = state_70582;
var ex70587 = (state_70582__$1[(2)]);
var statearr_70593_70609 = state_70582__$1;
(statearr_70593_70609[(5)] = ex70587);


if((ex70587 instanceof Error)){
var statearr_70594_70610 = state_70582__$1;
(statearr_70594_70610[(1)] = (4));

(statearr_70594_70610[(5)] = null);

} else {
throw ex70587;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70583 === (8))){
var inst_70566 = (state_70582[(2)]);
var inst_70567 = fluree.db.dbfunctions.internal.lower_case(inst_70566);
var inst_70568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70569 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70571 = [inst_70566];
var inst_70572 = (new cljs.core.PersistentVector(null,1,(5),inst_70570,inst_70571,null));
var inst_70573 = ["lower-case",inst_70572,inst_70567];
var inst_70574 = cljs.core.PersistentHashMap.fromArrays(inst_70569,inst_70573);
var inst_70575 = [inst_70574,(10)];
var inst_70576 = (new cljs.core.PersistentVector(null,2,(5),inst_70568,inst_70575,null));
var inst_70577 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70576);
var _ = (function (){var statearr_70595 = state_70582;
(statearr_70595[(4)] = cljs.core.rest((state_70582[(4)])));

return statearr_70595;
})();
var state_70582__$1 = (function (){var statearr_70596 = state_70582;
(statearr_70596[(7)] = inst_70577);

return statearr_70596;
})();
var statearr_70597_70611 = state_70582__$1;
(statearr_70597_70611[(2)] = inst_70567);

(statearr_70597_70611[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0 = (function (){
var statearr_70598 = [null,null,null,null,null,null,null,null];
(statearr_70598[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__);

(statearr_70598[(1)] = (1));

return statearr_70598;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1 = (function (state_70582){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70582);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70599){var ex__13886__auto__ = e70599;
var statearr_70600_70612 = state_70582;
(statearr_70600_70612[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70582[(4)]))){
var statearr_70601_70613 = state_70582;
(statearr_70601_70613[(1)] = cljs.core.first((state_70582[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70614 = state_70582;
state_70582 = G__70614;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__ = function(state_70582){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1.call(this,state_70582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70602 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70602[(6)] = c__13957__auto__);

return statearr_70602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70644){
var state_val_70645 = (state_70644[(1)]);
if((state_val_70645 === (7))){
var state_70644__$1 = state_70644;
var statearr_70646_70665 = state_70644__$1;
(statearr_70646_70665[(2)] = str);

(statearr_70646_70665[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (1))){
var state_70644__$1 = state_70644;
var statearr_70647_70666 = state_70644__$1;
(statearr_70647_70666[(2)] = null);

(statearr_70647_70666[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (4))){
var inst_70615 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
var statearr_70648_70667 = state_70644__$1;
(statearr_70648_70667[(2)] = inst_70615);

(statearr_70648_70667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (6))){
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70644__$1,(9),str);
} else {
if((state_val_70645 === (3))){
var inst_70642 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70644__$1,inst_70642);
} else {
if((state_val_70645 === (2))){
var _ = (function (){var statearr_70650 = state_70644;
(statearr_70650[(4)] = cljs.core.cons((5),(state_70644[(4)])));

return statearr_70650;
})();
var inst_70621 = fluree.db.util.async.channel_QMARK_(str);
var state_70644__$1 = state_70644;
if(inst_70621){
var statearr_70651_70668 = state_70644__$1;
(statearr_70651_70668[(1)] = (6));

} else {
var statearr_70652_70669 = state_70644__$1;
(statearr_70652_70669[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (9))){
var inst_70624 = (state_70644[(2)]);
var inst_70625 = fluree.db.util.async.throw_err(inst_70624);
var state_70644__$1 = state_70644;
var statearr_70653_70670 = state_70644__$1;
(statearr_70653_70670[(2)] = inst_70625);

(statearr_70653_70670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (5))){
var _ = (function (){var statearr_70654 = state_70644;
(statearr_70654[(4)] = cljs.core.rest((state_70644[(4)])));

return statearr_70654;
})();
var state_70644__$1 = state_70644;
var ex70649 = (state_70644__$1[(2)]);
var statearr_70655_70671 = state_70644__$1;
(statearr_70655_70671[(5)] = ex70649);


if((ex70649 instanceof Error)){
var statearr_70656_70672 = state_70644__$1;
(statearr_70656_70672[(1)] = (4));

(statearr_70656_70672[(5)] = null);

} else {
throw ex70649;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (8))){
var inst_70628 = (state_70644[(2)]);
var inst_70629 = fluree.db.dbfunctions.internal.upper_case(inst_70628);
var inst_70630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70631 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70633 = [inst_70628];
var inst_70634 = (new cljs.core.PersistentVector(null,1,(5),inst_70632,inst_70633,null));
var inst_70635 = ["upper-case",inst_70634,inst_70629];
var inst_70636 = cljs.core.PersistentHashMap.fromArrays(inst_70631,inst_70635);
var inst_70637 = [inst_70636,(10)];
var inst_70638 = (new cljs.core.PersistentVector(null,2,(5),inst_70630,inst_70637,null));
var inst_70639 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70638);
var _ = (function (){var statearr_70657 = state_70644;
(statearr_70657[(4)] = cljs.core.rest((state_70644[(4)])));

return statearr_70657;
})();
var state_70644__$1 = (function (){var statearr_70658 = state_70644;
(statearr_70658[(7)] = inst_70639);

return statearr_70658;
})();
var statearr_70659_70673 = state_70644__$1;
(statearr_70659_70673[(2)] = inst_70629);

(statearr_70659_70673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0 = (function (){
var statearr_70660 = [null,null,null,null,null,null,null,null];
(statearr_70660[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__);

(statearr_70660[(1)] = (1));

return statearr_70660;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1 = (function (state_70644){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70644);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70661){var ex__13886__auto__ = e70661;
var statearr_70662_70674 = state_70644;
(statearr_70662_70674[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70644[(4)]))){
var statearr_70663_70675 = state_70644;
(statearr_70663_70675[(1)] = cljs.core.first((state_70644[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70676 = state_70644;
state_70644 = G__70676;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__ = function(state_70644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1.call(this,state_70644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70664 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70664[(6)] = c__13957__auto__);

return statearr_70664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4149__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4149__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__70678 = arguments.length;
switch (G__70678) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70706){
var state_val_70707 = (state_70706[(1)]);
if((state_val_70707 === (1))){
var state_70706__$1 = state_70706;
var statearr_70708_70724 = state_70706__$1;
(statearr_70708_70724[(2)] = null);

(statearr_70708_70724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70707 === (2))){
var _ = (function (){var statearr_70709 = state_70706;
(statearr_70709[(4)] = cljs.core.cons((5),(state_70706[(4)])));

return statearr_70709;
})();
var inst_70688 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_70706__$1 = state_70706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70706__$1,(6),inst_70688);
} else {
if((state_val_70707 === (3))){
var inst_70704 = (state_70706[(2)]);
var state_70706__$1 = state_70706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70706__$1,inst_70704);
} else {
if((state_val_70707 === (4))){
var inst_70679 = (state_70706[(2)]);
var state_70706__$1 = state_70706;
var statearr_70711_70725 = state_70706__$1;
(statearr_70711_70725[(2)] = inst_70679);

(statearr_70711_70725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70707 === (5))){
var _ = (function (){var statearr_70712 = state_70706;
(statearr_70712[(4)] = cljs.core.rest((state_70706[(4)])));

return statearr_70712;
})();
var state_70706__$1 = state_70706;
var ex70710 = (state_70706__$1[(2)]);
var statearr_70713_70726 = state_70706__$1;
(statearr_70713_70726[(5)] = ex70710);


if((ex70710 instanceof Error)){
var statearr_70714_70727 = state_70706__$1;
(statearr_70714_70727[(1)] = (4));

(statearr_70714_70727[(5)] = null);

} else {
throw ex70710;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70707 === (6))){
var inst_70690 = (state_70706[(2)]);
var inst_70691 = fluree.db.util.async.throw_err(inst_70690);
var inst_70692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70691,(0),null);
var inst_70693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70691,(1),null);
var inst_70694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70695 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70696 = ["?s","?ctx",inst_70692];
var inst_70697 = cljs.core.PersistentHashMap.fromArrays(inst_70695,inst_70696);
var inst_70698 = ((10) + inst_70693);
var inst_70699 = [inst_70697,inst_70698];
var inst_70700 = (new cljs.core.PersistentVector(null,2,(5),inst_70694,inst_70699,null));
var inst_70701 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70700);
var _ = (function (){var statearr_70715 = state_70706;
(statearr_70715[(4)] = cljs.core.rest((state_70706[(4)])));

return statearr_70715;
})();
var state_70706__$1 = (function (){var statearr_70716 = state_70706;
(statearr_70716[(7)] = inst_70701);

return statearr_70716;
})();
var statearr_70717_70728 = state_70706__$1;
(statearr_70717_70728[(2)] = inst_70692);

(statearr_70717_70728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70718 = [null,null,null,null,null,null,null,null];
(statearr_70718[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70718[(1)] = (1));

return statearr_70718;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70706){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70706);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70719){var ex__13886__auto__ = e70719;
var statearr_70720_70729 = state_70706;
(statearr_70720_70729[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70706[(4)]))){
var statearr_70721_70730 = state_70706;
(statearr_70721_70730[(1)] = cljs.core.first((state_70706[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70731 = state_70706;
state_70706 = G__70731;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70722 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70722[(6)] = c__13957__auto__);

return statearr_70722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__70733 = arguments.length;
switch (G__70733) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70771){
var state_val_70772 = (state_70771[(1)]);
if((state_val_70772 === (7))){
var inst_70764 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_70771__$1 = state_70771;
var statearr_70773_70793 = state_70771__$1;
(statearr_70773_70793[(2)] = inst_70764);

(statearr_70773_70793[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (1))){
var state_70771__$1 = state_70771;
var statearr_70774_70794 = state_70771__$1;
(statearr_70774_70794[(2)] = null);

(statearr_70774_70794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (4))){
var inst_70734 = (state_70771[(2)]);
var state_70771__$1 = state_70771;
var statearr_70775_70795 = state_70771__$1;
(statearr_70775_70795[(2)] = inst_70734);

(statearr_70775_70795[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (6))){
var inst_70745 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_70771__$1 = state_70771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70771__$1,(10),inst_70745);
} else {
if((state_val_70772 === (3))){
var inst_70769 = (state_70771[(2)]);
var state_70771__$1 = state_70771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70771__$1,inst_70769);
} else {
if((state_val_70772 === (2))){
var _ = (function (){var statearr_70777 = state_70771;
(statearr_70777[(4)] = cljs.core.cons((5),(state_70771[(4)])));

return statearr_70777;
})();
var inst_70740 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70771__$1 = state_70771;
if(cljs.core.truth_(inst_70740)){
var statearr_70778_70796 = state_70771__$1;
(statearr_70778_70796[(1)] = (6));

} else {
var statearr_70779_70797 = state_70771__$1;
(statearr_70779_70797[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (9))){
var inst_70751 = (state_70771[(2)]);
var inst_70752 = fluree.db.util.async.throw_err(inst_70751);
var inst_70753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70752,(0),null);
var inst_70754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70752,(1),null);
var inst_70755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70756 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70757 = ["?p","?ctx",inst_70753];
var inst_70758 = cljs.core.PersistentHashMap.fromArrays(inst_70756,inst_70757);
var inst_70759 = ((10) + inst_70754);
var inst_70760 = [inst_70758,inst_70759];
var inst_70761 = (new cljs.core.PersistentVector(null,2,(5),inst_70755,inst_70760,null));
var inst_70762 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70761);
var state_70771__$1 = (function (){var statearr_70780 = state_70771;
(statearr_70780[(7)] = inst_70762);

return statearr_70780;
})();
var statearr_70781_70798 = state_70771__$1;
(statearr_70781_70798[(2)] = inst_70753);

(statearr_70781_70798[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (5))){
var _ = (function (){var statearr_70782 = state_70771;
(statearr_70782[(4)] = cljs.core.rest((state_70771[(4)])));

return statearr_70782;
})();
var state_70771__$1 = state_70771;
var ex70776 = (state_70771__$1[(2)]);
var statearr_70783_70799 = state_70771__$1;
(statearr_70783_70799[(5)] = ex70776);


if((ex70776 instanceof Error)){
var statearr_70784_70800 = state_70771__$1;
(statearr_70784_70800[(1)] = (4));

(statearr_70784_70800[(5)] = null);

} else {
throw ex70776;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70772 === (10))){
var inst_70747 = (state_70771[(2)]);
var inst_70748 = fluree.db.util.async.throw_err(inst_70747);
var inst_70749 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_70748);
var state_70771__$1 = state_70771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70771__$1,(9),inst_70749);
} else {
if((state_val_70772 === (8))){
var inst_70766 = (state_70771[(2)]);
var _ = (function (){var statearr_70785 = state_70771;
(statearr_70785[(4)] = cljs.core.rest((state_70771[(4)])));

return statearr_70785;
})();
var state_70771__$1 = state_70771;
var statearr_70786_70801 = state_70771__$1;
(statearr_70786_70801[(2)] = inst_70766);

(statearr_70786_70801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70787 = [null,null,null,null,null,null,null,null];
(statearr_70787[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70787[(1)] = (1));

return statearr_70787;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70771){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70771);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70788){var ex__13886__auto__ = e70788;
var statearr_70789_70802 = state_70771;
(statearr_70789_70802[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70771[(4)]))){
var statearr_70790_70803 = state_70771;
(statearr_70790_70803[(1)] = cljs.core.first((state_70771[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70804 = state_70771;
state_70771 = G__70804;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70771){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70791 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70791[(6)] = c__13957__auto__);

return statearr_70791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70853 = arguments.length;
var i__4772__auto___70854 = (0);
while(true){
if((i__4772__auto___70854 < len__4771__auto___70853)){
args__4777__auto__.push((arguments[i__4772__auto___70854]));

var G__70855 = (i__4772__auto___70854 + (1));
i__4772__auto___70854 = G__70855;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70836){
var state_val_70837 = (state_70836[(1)]);
if((state_val_70837 === (1))){
var state_70836__$1 = state_70836;
var statearr_70838_70856 = state_70836__$1;
(statearr_70838_70856[(2)] = null);

(statearr_70838_70856[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70837 === (2))){
var _ = (function (){var statearr_70839 = state_70836;
(statearr_70839[(4)] = cljs.core.cons((5),(state_70836[(4)])));

return statearr_70839;
})();
var inst_70813 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70836__$1 = state_70836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70836__$1,(6),inst_70813);
} else {
if((state_val_70837 === (3))){
var inst_70834 = (state_70836[(2)]);
var state_70836__$1 = state_70836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70836__$1,inst_70834);
} else {
if((state_val_70837 === (4))){
var inst_70807 = (state_70836[(2)]);
var state_70836__$1 = state_70836;
var statearr_70841_70857 = state_70836__$1;
(statearr_70841_70857[(2)] = inst_70807);

(statearr_70841_70857[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70837 === (5))){
var _ = (function (){var statearr_70842 = state_70836;
(statearr_70842[(4)] = cljs.core.rest((state_70836[(4)])));

return statearr_70842;
})();
var state_70836__$1 = state_70836;
var ex70840 = (state_70836__$1[(2)]);
var statearr_70843_70858 = state_70836__$1;
(statearr_70843_70858[(5)] = ex70840);


if((ex70840 instanceof Error)){
var statearr_70844_70859 = state_70836__$1;
(statearr_70844_70859[(1)] = (4));

(statearr_70844_70859[(5)] = null);

} else {
throw ex70840;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70837 === (6))){
var inst_70815 = (state_70836[(2)]);
var inst_70816 = fluree.db.util.async.throw_err(inst_70815);
var inst_70817 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_70816);
var inst_70818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70819 = [inst_70816];
var inst_70820 = (new cljs.core.PersistentVector(null,1,(5),inst_70818,inst_70819,null));
var inst_70821 = cljs.core.count(inst_70820);
var inst_70822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70823 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70825 = [inst_70816];
var inst_70826 = (new cljs.core.PersistentVector(null,1,(5),inst_70824,inst_70825,null));
var inst_70827 = ["and",inst_70826,inst_70817];
var inst_70828 = cljs.core.PersistentHashMap.fromArrays(inst_70823,inst_70827);
var inst_70829 = [inst_70828,inst_70821];
var inst_70830 = (new cljs.core.PersistentVector(null,2,(5),inst_70822,inst_70829,null));
var inst_70831 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70830);
var _ = (function (){var statearr_70845 = state_70836;
(statearr_70845[(4)] = cljs.core.rest((state_70836[(4)])));

return statearr_70845;
})();
var state_70836__$1 = (function (){var statearr_70846 = state_70836;
(statearr_70846[(7)] = inst_70831);

return statearr_70846;
})();
var statearr_70847_70860 = state_70836__$1;
(statearr_70847_70860[(2)] = inst_70817);

(statearr_70847_70860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70848 = [null,null,null,null,null,null,null,null];
(statearr_70848[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70848[(1)] = (1));

return statearr_70848;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70836){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70836);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70849){var ex__13886__auto__ = e70849;
var statearr_70850_70861 = state_70836;
(statearr_70850_70861[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70836[(4)]))){
var statearr_70851_70862 = state_70836;
(statearr_70851_70862[(1)] = cljs.core.first((state_70836[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70863 = state_70836;
state_70836 = G__70863;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70836){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70852 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70852[(6)] = c__13957__auto__);

return statearr_70852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq70805){
var G__70806 = cljs.core.first(seq70805);
var seq70805__$1 = cljs.core.next(seq70805);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70806,seq70805__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70912 = arguments.length;
var i__4772__auto___70913 = (0);
while(true){
if((i__4772__auto___70913 < len__4771__auto___70912)){
args__4777__auto__.push((arguments[i__4772__auto___70913]));

var G__70914 = (i__4772__auto___70913 + (1));
i__4772__auto___70913 = G__70914;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70895){
var state_val_70896 = (state_70895[(1)]);
if((state_val_70896 === (1))){
var state_70895__$1 = state_70895;
var statearr_70897_70915 = state_70895__$1;
(statearr_70897_70915[(2)] = null);

(statearr_70897_70915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70896 === (2))){
var _ = (function (){var statearr_70898 = state_70895;
(statearr_70898[(4)] = cljs.core.cons((5),(state_70895[(4)])));

return statearr_70898;
})();
var inst_70872 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(6),inst_70872);
} else {
if((state_val_70896 === (3))){
var inst_70893 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70895__$1,inst_70893);
} else {
if((state_val_70896 === (4))){
var inst_70866 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
var statearr_70900_70916 = state_70895__$1;
(statearr_70900_70916[(2)] = inst_70866);

(statearr_70900_70916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70896 === (5))){
var _ = (function (){var statearr_70901 = state_70895;
(statearr_70901[(4)] = cljs.core.rest((state_70895[(4)])));

return statearr_70901;
})();
var state_70895__$1 = state_70895;
var ex70899 = (state_70895__$1[(2)]);
var statearr_70902_70917 = state_70895__$1;
(statearr_70902_70917[(5)] = ex70899);


if((ex70899 instanceof Error)){
var statearr_70903_70918 = state_70895__$1;
(statearr_70903_70918[(1)] = (4));

(statearr_70903_70918[(5)] = null);

} else {
throw ex70899;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70896 === (6))){
var inst_70874 = (state_70895[(2)]);
var inst_70875 = fluree.db.util.async.throw_err(inst_70874);
var inst_70876 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_70875);
var inst_70877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70878 = [inst_70875];
var inst_70879 = (new cljs.core.PersistentVector(null,1,(5),inst_70877,inst_70878,null));
var inst_70880 = cljs.core.count(inst_70879);
var inst_70881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70882 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70884 = [inst_70875];
var inst_70885 = (new cljs.core.PersistentVector(null,1,(5),inst_70883,inst_70884,null));
var inst_70886 = ["or",inst_70885,inst_70876];
var inst_70887 = cljs.core.PersistentHashMap.fromArrays(inst_70882,inst_70886);
var inst_70888 = [inst_70887,inst_70880];
var inst_70889 = (new cljs.core.PersistentVector(null,2,(5),inst_70881,inst_70888,null));
var inst_70890 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70889);
var _ = (function (){var statearr_70904 = state_70895;
(statearr_70904[(4)] = cljs.core.rest((state_70895[(4)])));

return statearr_70904;
})();
var state_70895__$1 = (function (){var statearr_70905 = state_70895;
(statearr_70905[(7)] = inst_70890);

return statearr_70905;
})();
var statearr_70906_70919 = state_70895__$1;
(statearr_70906_70919[(2)] = inst_70876);

(statearr_70906_70919[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70907 = [null,null,null,null,null,null,null,null];
(statearr_70907[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70907[(1)] = (1));

return statearr_70907;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70895){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70895);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70908){var ex__13886__auto__ = e70908;
var statearr_70909_70920 = state_70895;
(statearr_70909_70920[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70895[(4)]))){
var statearr_70910_70921 = state_70895;
(statearr_70910_70921[(1)] = cljs.core.first((state_70895[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70922 = state_70895;
state_70895 = G__70922;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70895){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70911 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70911[(6)] = c__13957__auto__);

return statearr_70911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq70864){
var G__70865 = cljs.core.first(seq70864);
var seq70864__$1 = cljs.core.next(seq70864);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70865,seq70864__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70960){
var state_val_70961 = (state_70960[(1)]);
if((state_val_70961 === (7))){
var inst_70936 = fluree.db.util.async.channel_QMARK_(coll);
var state_70960__$1 = state_70960;
if(inst_70936){
var statearr_70962_70985 = state_70960__$1;
(statearr_70962_70985[(1)] = (10));

} else {
var statearr_70963_70986 = state_70960__$1;
(statearr_70963_70986[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (1))){
var state_70960__$1 = state_70960;
var statearr_70964_70987 = state_70960__$1;
(statearr_70964_70987[(2)] = null);

(statearr_70964_70987[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (4))){
var inst_70923 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_70965_70988 = state_70960__$1;
(statearr_70965_70988[(2)] = inst_70923);

(statearr_70965_70988[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (13))){
var inst_70939 = (state_70960[(2)]);
var inst_70940 = fluree.db.util.async.throw_err(inst_70939);
var state_70960__$1 = state_70960;
var statearr_70966_70989 = state_70960__$1;
(statearr_70966_70989[(2)] = inst_70940);

(statearr_70966_70989[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (6))){
var inst_70931 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70960__$1,(9),inst_70931);
} else {
if((state_val_70961 === (3))){
var inst_70958 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70960__$1,inst_70958);
} else {
if((state_val_70961 === (12))){
var inst_70943 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_70967_70990 = state_70960__$1;
(statearr_70967_70990[(2)] = inst_70943);

(statearr_70967_70990[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (2))){
var _ = (function (){var statearr_70968 = state_70960;
(statearr_70968[(4)] = cljs.core.cons((5),(state_70960[(4)])));

return statearr_70968;
})();
var inst_70929 = cljs.core.vector_QMARK_(coll);
var state_70960__$1 = state_70960;
if(inst_70929){
var statearr_70969_70991 = state_70960__$1;
(statearr_70969_70991[(1)] = (6));

} else {
var statearr_70970_70992 = state_70960__$1;
(statearr_70970_70992[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (11))){
var state_70960__$1 = state_70960;
var statearr_70972_70993 = state_70960__$1;
(statearr_70972_70993[(2)] = coll);

(statearr_70972_70993[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (9))){
var inst_70933 = (state_70960[(2)]);
var inst_70934 = fluree.db.util.async.throw_err(inst_70933);
var state_70960__$1 = state_70960;
var statearr_70973_70994 = state_70960__$1;
(statearr_70973_70994[(2)] = inst_70934);

(statearr_70973_70994[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (5))){
var _ = (function (){var statearr_70974 = state_70960;
(statearr_70974[(4)] = cljs.core.rest((state_70960[(4)])));

return statearr_70974;
})();
var state_70960__$1 = state_70960;
var ex70971 = (state_70960__$1[(2)]);
var statearr_70975_70995 = state_70960__$1;
(statearr_70975_70995[(5)] = ex70971);


if((ex70971 instanceof Error)){
var statearr_70976_70996 = state_70960__$1;
(statearr_70976_70996[(1)] = (4));

(statearr_70976_70996[(5)] = null);

} else {
throw ex70971;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70961 === (10))){
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70960__$1,(13),coll);
} else {
if((state_val_70961 === (8))){
var inst_70945 = (state_70960[(2)]);
var inst_70946 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_70945);
var inst_70947 = cljs.core.count(inst_70946);
var inst_70948 = ((9) + inst_70947);
var inst_70949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70950 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70951 = ["count",inst_70945,inst_70947];
var inst_70952 = cljs.core.PersistentHashMap.fromArrays(inst_70950,inst_70951);
var inst_70953 = [inst_70952,inst_70948];
var inst_70954 = (new cljs.core.PersistentVector(null,2,(5),inst_70949,inst_70953,null));
var inst_70955 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70954);
var _ = (function (){var statearr_70977 = state_70960;
(statearr_70977[(4)] = cljs.core.rest((state_70960[(4)])));

return statearr_70977;
})();
var state_70960__$1 = (function (){var statearr_70978 = state_70960;
(statearr_70978[(7)] = inst_70955);

return statearr_70978;
})();
var statearr_70979_70997 = state_70960__$1;
(statearr_70979_70997[(2)] = inst_70947);

(statearr_70979_70997[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0 = (function (){
var statearr_70980 = [null,null,null,null,null,null,null,null];
(statearr_70980[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__);

(statearr_70980[(1)] = (1));

return statearr_70980;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1 = (function (state_70960){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70960);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70981){var ex__13886__auto__ = e70981;
var statearr_70982_70998 = state_70960;
(statearr_70982_70998[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70960[(4)]))){
var statearr_70983_70999 = state_70960;
(statearr_70983_70999[(1)] = cljs.core.first((state_70960[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71000 = state_70960;
state_70960 = G__71000;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__ = function(state_70960){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1.call(this,state_70960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70984 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70984[(6)] = c__13957__auto__);

return statearr_70984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71050){
var state_val_71051 = (state_71050[(1)]);
if((state_val_71051 === (7))){
var state_71050__$1 = state_71050;
var statearr_71052_71085 = state_71050__$1;
(statearr_71052_71085[(2)] = subject);

(statearr_71052_71085[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (1))){
var state_71050__$1 = state_71050;
var statearr_71053_71086 = state_71050__$1;
(statearr_71053_71086[(2)] = null);

(statearr_71053_71086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (4))){
var inst_71001 = (state_71050[(2)]);
var state_71050__$1 = state_71050;
var statearr_71054_71087 = state_71050__$1;
(statearr_71054_71087[(2)] = inst_71001);

(statearr_71054_71087[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (15))){
var inst_71014 = (state_71050[(7)]);
var state_71050__$1 = state_71050;
var statearr_71055_71088 = state_71050__$1;
(statearr_71055_71088[(2)] = inst_71014);

(statearr_71055_71088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (13))){
var inst_71018 = (state_71050[(2)]);
var inst_71019 = fluree.db.util.async.throw_err(inst_71018);
var state_71050__$1 = state_71050;
var statearr_71056_71089 = state_71050__$1;
(statearr_71056_71089[(2)] = inst_71019);

(statearr_71056_71089[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (6))){
var state_71050__$1 = state_71050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71050__$1,(9),subject);
} else {
if((state_val_71051 === (17))){
var inst_71014 = (state_71050[(7)]);
var inst_71028 = cljs.core.first(inst_71014);
var state_71050__$1 = state_71050;
var statearr_71057_71090 = state_71050__$1;
(statearr_71057_71090[(2)] = inst_71028);

(statearr_71057_71090[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (3))){
var inst_71048 = (state_71050[(2)]);
var state_71050__$1 = state_71050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71050__$1,inst_71048);
} else {
if((state_val_71051 === (12))){
var inst_71014 = (state_71050[(7)]);
var inst_71022 = (state_71050[(2)]);
var inst_71023 = cljs.core.vector_QMARK_(inst_71014);
var state_71050__$1 = (function (){var statearr_71058 = state_71050;
(statearr_71058[(8)] = inst_71022);

return statearr_71058;
})();
if(inst_71023){
var statearr_71059_71091 = state_71050__$1;
(statearr_71059_71091[(1)] = (14));

} else {
var statearr_71060_71092 = state_71050__$1;
(statearr_71060_71092[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (2))){
var _ = (function (){var statearr_71061 = state_71050;
(statearr_71061[(4)] = cljs.core.cons((5),(state_71050[(4)])));

return statearr_71061;
})();
var inst_71007 = fluree.db.util.async.channel_QMARK_(subject);
var state_71050__$1 = state_71050;
if(inst_71007){
var statearr_71062_71093 = state_71050__$1;
(statearr_71062_71093[(1)] = (6));

} else {
var statearr_71063_71094 = state_71050__$1;
(statearr_71063_71094[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (19))){
var inst_71031 = (state_71050[(2)]);
var state_71050__$1 = state_71050;
var statearr_71064_71095 = state_71050__$1;
(statearr_71064_71095[(2)] = inst_71031);

(statearr_71064_71095[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (11))){
var state_71050__$1 = state_71050;
var statearr_71066_71096 = state_71050__$1;
(statearr_71066_71096[(2)] = pred);

(statearr_71066_71096[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (9))){
var inst_71010 = (state_71050[(2)]);
var inst_71011 = fluree.db.util.async.throw_err(inst_71010);
var state_71050__$1 = state_71050;
var statearr_71067_71097 = state_71050__$1;
(statearr_71067_71097[(2)] = inst_71011);

(statearr_71067_71097[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (5))){
var _ = (function (){var statearr_71068 = state_71050;
(statearr_71068[(4)] = cljs.core.rest((state_71050[(4)])));

return statearr_71068;
})();
var state_71050__$1 = state_71050;
var ex71065 = (state_71050__$1[(2)]);
var statearr_71069_71098 = state_71050__$1;
(statearr_71069_71098[(5)] = ex71065);


if((ex71065 instanceof Error)){
var statearr_71070_71099 = state_71050__$1;
(statearr_71070_71099[(1)] = (4));

(statearr_71070_71099[(5)] = null);

} else {
throw ex71065;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (14))){
var inst_71014 = (state_71050[(7)]);
var inst_71025 = cljs.core.count(inst_71014);
var inst_71026 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71025);
var state_71050__$1 = state_71050;
if(inst_71026){
var statearr_71071_71100 = state_71050__$1;
(statearr_71071_71100[(1)] = (17));

} else {
var statearr_71072_71101 = state_71050__$1;
(statearr_71072_71101[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (16))){
var inst_71022 = (state_71050[(8)]);
var inst_71014 = (state_71050[(7)]);
var inst_71034 = (state_71050[(2)]);
var inst_71035 = fluree.db.dbfunctions.internal.get(inst_71034,inst_71022);
var inst_71036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71037 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71039 = [inst_71014,inst_71022];
var inst_71040 = (new cljs.core.PersistentVector(null,2,(5),inst_71038,inst_71039,null));
var inst_71041 = ["get",inst_71040,inst_71035];
var inst_71042 = cljs.core.PersistentHashMap.fromArrays(inst_71037,inst_71041);
var inst_71043 = [inst_71042,(10)];
var inst_71044 = (new cljs.core.PersistentVector(null,2,(5),inst_71036,inst_71043,null));
var inst_71045 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71044);
var _ = (function (){var statearr_71073 = state_71050;
(statearr_71073[(4)] = cljs.core.rest((state_71050[(4)])));

return statearr_71073;
})();
var state_71050__$1 = (function (){var statearr_71074 = state_71050;
(statearr_71074[(9)] = inst_71045);

return statearr_71074;
})();
var statearr_71075_71102 = state_71050__$1;
(statearr_71075_71102[(2)] = inst_71035);

(statearr_71075_71102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (10))){
var state_71050__$1 = state_71050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71050__$1,(13),pred);
} else {
if((state_val_71051 === (18))){
var inst_71014 = (state_71050[(7)]);
var state_71050__$1 = state_71050;
var statearr_71076_71103 = state_71050__$1;
(statearr_71076_71103[(2)] = inst_71014);

(statearr_71076_71103[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71051 === (8))){
var inst_71014 = (state_71050[(2)]);
var inst_71015 = fluree.db.util.async.channel_QMARK_(pred);
var state_71050__$1 = (function (){var statearr_71077 = state_71050;
(statearr_71077[(7)] = inst_71014);

return statearr_71077;
})();
if(inst_71015){
var statearr_71078_71104 = state_71050__$1;
(statearr_71078_71104[(1)] = (10));

} else {
var statearr_71079_71105 = state_71050__$1;
(statearr_71079_71105[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0 = (function (){
var statearr_71080 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71080[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__);

(statearr_71080[(1)] = (1));

return statearr_71080;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1 = (function (state_71050){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71050);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71081){var ex__13886__auto__ = e71081;
var statearr_71082_71106 = state_71050;
(statearr_71082_71106[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71050[(4)]))){
var statearr_71083_71107 = state_71050;
(statearr_71083_71107[(1)] = cljs.core.first((state_71050[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71108 = state_71050;
state_71050 = G__71108;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__ = function(state_71050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1.call(this,state_71050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71084 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71084[(6)] = c__13957__auto__);

return statearr_71084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71147){
var state_val_71148 = (state_71147[(1)]);
if((state_val_71148 === (7))){
var inst_71115 = (state_71147[(7)]);
var state_71147__$1 = state_71147;
var statearr_71149_71173 = state_71147__$1;
(statearr_71149_71173[(2)] = inst_71115);

(statearr_71149_71173[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (1))){
var state_71147__$1 = state_71147;
var statearr_71150_71174 = state_71147__$1;
(statearr_71150_71174[(2)] = null);

(statearr_71150_71174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (4))){
var inst_71109 = (state_71147[(2)]);
var state_71147__$1 = state_71147;
var statearr_71151_71175 = state_71147__$1;
(statearr_71151_71175[(2)] = inst_71109);

(statearr_71151_71175[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (6))){
var inst_71117 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71147__$1 = state_71147;
var statearr_71152_71176 = state_71147__$1;
(statearr_71152_71176[(2)] = inst_71117);

(statearr_71152_71176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (3))){
var inst_71145 = (state_71147[(2)]);
var state_71147__$1 = state_71147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71147__$1,inst_71145);
} else {
if((state_val_71148 === (12))){
var inst_71127 = (state_71147[(2)]);
var inst_71128 = fluree.db.util.async.throw_err(inst_71127);
var inst_71129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71128,(0),null);
var inst_71130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71128,(1),null);
var inst_71131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71132 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71133 = ["?pO","?ctx",inst_71129];
var inst_71134 = cljs.core.PersistentHashMap.fromArrays(inst_71132,inst_71133);
var inst_71135 = ((10) + inst_71130);
var inst_71136 = [inst_71134,inst_71135];
var inst_71137 = (new cljs.core.PersistentVector(null,2,(5),inst_71131,inst_71136,null));
var inst_71138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71137);
var state_71147__$1 = (function (){var statearr_71153 = state_71147;
(statearr_71153[(8)] = inst_71138);

return statearr_71153;
})();
var statearr_71154_71177 = state_71147__$1;
(statearr_71154_71177[(2)] = inst_71129);

(statearr_71154_71177[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (2))){
var inst_71115 = (state_71147[(7)]);
var _ = (function (){var statearr_71155 = state_71147;
(statearr_71155[(4)] = cljs.core.cons((5),(state_71147[(4)])));

return statearr_71155;
})();
var inst_71115__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71147__$1 = (function (){var statearr_71156 = state_71147;
(statearr_71156[(7)] = inst_71115__$1);

return statearr_71156;
})();
if(cljs.core.truth_(inst_71115__$1)){
var statearr_71157_71178 = state_71147__$1;
(statearr_71157_71178[(1)] = (6));

} else {
var statearr_71158_71179 = state_71147__$1;
(statearr_71158_71179[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (11))){
var inst_71142 = (state_71147[(2)]);
var _ = (function (){var statearr_71160 = state_71147;
(statearr_71160[(4)] = cljs.core.rest((state_71147[(4)])));

return statearr_71160;
})();
var state_71147__$1 = state_71147;
var statearr_71161_71180 = state_71147__$1;
(statearr_71161_71180[(2)] = inst_71142);

(statearr_71161_71180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (9))){
var inst_71125 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_71147__$1 = state_71147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71147__$1,(12),inst_71125);
} else {
if((state_val_71148 === (5))){
var _ = (function (){var statearr_71162 = state_71147;
(statearr_71162[(4)] = cljs.core.rest((state_71147[(4)])));

return statearr_71162;
})();
var state_71147__$1 = state_71147;
var ex71159 = (state_71147__$1[(2)]);
var statearr_71163_71181 = state_71147__$1;
(statearr_71163_71181[(5)] = ex71159);


if((ex71159 instanceof Error)){
var statearr_71164_71182 = state_71147__$1;
(statearr_71164_71182[(1)] = (4));

(statearr_71164_71182[(5)] = null);

} else {
throw ex71159;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (10))){
var inst_71140 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_71147__$1 = state_71147;
var statearr_71165_71183 = state_71147__$1;
(statearr_71165_71183[(2)] = inst_71140);

(statearr_71165_71183[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71148 === (8))){
var inst_71120 = (state_71147[(2)]);
var state_71147__$1 = state_71147;
if(cljs.core.truth_(inst_71120)){
var statearr_71166_71184 = state_71147__$1;
(statearr_71166_71184[(1)] = (9));

} else {
var statearr_71167_71185 = state_71147__$1;
(statearr_71167_71185[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0 = (function (){
var statearr_71168 = [null,null,null,null,null,null,null,null,null];
(statearr_71168[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__);

(statearr_71168[(1)] = (1));

return statearr_71168;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1 = (function (state_71147){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71147);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71169){var ex__13886__auto__ = e71169;
var statearr_71170_71186 = state_71147;
(statearr_71170_71186[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71147[(4)]))){
var statearr_71171_71187 = state_71147;
(statearr_71171_71187[(1)] = cljs.core.first((state_71147[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71188 = state_71147;
state_71147 = G__71188;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__ = function(state_71147){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1.call(this,state_71147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71172 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71172[(6)] = c__13957__auto__);

return statearr_71172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71240){
var state_val_71241 = (state_71240[(1)]);
if((state_val_71241 === (7))){
var state_71240__$1 = state_71240;
var statearr_71242_71275 = state_71240__$1;
(statearr_71242_71275[(2)] = subject);

(statearr_71242_71275[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (1))){
var state_71240__$1 = state_71240;
var statearr_71243_71276 = state_71240__$1;
(statearr_71243_71276[(2)] = null);

(statearr_71243_71276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (4))){
var inst_71189 = (state_71240[(2)]);
var state_71240__$1 = state_71240;
var statearr_71244_71277 = state_71240__$1;
(statearr_71244_71277[(2)] = inst_71189);

(statearr_71244_71277[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (15))){
var inst_71202 = (state_71240[(7)]);
var state_71240__$1 = state_71240;
var statearr_71245_71278 = state_71240__$1;
(statearr_71245_71278[(2)] = inst_71202);

(statearr_71245_71278[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (13))){
var inst_71206 = (state_71240[(2)]);
var inst_71207 = fluree.db.util.async.throw_err(inst_71206);
var state_71240__$1 = state_71240;
var statearr_71246_71279 = state_71240__$1;
(statearr_71246_71279[(2)] = inst_71207);

(statearr_71246_71279[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (6))){
var state_71240__$1 = state_71240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71240__$1,(9),subject);
} else {
if((state_val_71241 === (17))){
var inst_71202 = (state_71240[(7)]);
var inst_71216 = cljs.core.first(inst_71202);
var state_71240__$1 = state_71240;
var statearr_71247_71280 = state_71240__$1;
(statearr_71247_71280[(2)] = inst_71216);

(statearr_71247_71280[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (3))){
var inst_71238 = (state_71240[(2)]);
var state_71240__$1 = state_71240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71240__$1,inst_71238);
} else {
if((state_val_71241 === (12))){
var inst_71202 = (state_71240[(7)]);
var inst_71210 = (state_71240[(2)]);
var inst_71211 = cljs.core.vector_QMARK_(inst_71202);
var state_71240__$1 = (function (){var statearr_71248 = state_71240;
(statearr_71248[(8)] = inst_71210);

return statearr_71248;
})();
if(inst_71211){
var statearr_71249_71281 = state_71240__$1;
(statearr_71249_71281[(1)] = (14));

} else {
var statearr_71250_71282 = state_71240__$1;
(statearr_71250_71282[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (2))){
var _ = (function (){var statearr_71251 = state_71240;
(statearr_71251[(4)] = cljs.core.cons((5),(state_71240[(4)])));

return statearr_71251;
})();
var inst_71195 = fluree.db.util.async.channel_QMARK_(subject);
var state_71240__$1 = state_71240;
if(inst_71195){
var statearr_71252_71283 = state_71240__$1;
(statearr_71252_71283[(1)] = (6));

} else {
var statearr_71253_71284 = state_71240__$1;
(statearr_71253_71284[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (19))){
var inst_71219 = (state_71240[(2)]);
var state_71240__$1 = state_71240;
var statearr_71254_71285 = state_71240__$1;
(statearr_71254_71285[(2)] = inst_71219);

(statearr_71254_71285[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (11))){
var state_71240__$1 = state_71240;
var statearr_71256_71286 = state_71240__$1;
(statearr_71256_71286[(2)] = path);

(statearr_71256_71286[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (9))){
var inst_71198 = (state_71240[(2)]);
var inst_71199 = fluree.db.util.async.throw_err(inst_71198);
var state_71240__$1 = state_71240;
var statearr_71257_71287 = state_71240__$1;
(statearr_71257_71287[(2)] = inst_71199);

(statearr_71257_71287[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (5))){
var _ = (function (){var statearr_71258 = state_71240;
(statearr_71258[(4)] = cljs.core.rest((state_71240[(4)])));

return statearr_71258;
})();
var state_71240__$1 = state_71240;
var ex71255 = (state_71240__$1[(2)]);
var statearr_71259_71288 = state_71240__$1;
(statearr_71259_71288[(5)] = ex71255);


if((ex71255 instanceof Error)){
var statearr_71260_71289 = state_71240__$1;
(statearr_71260_71289[(1)] = (4));

(statearr_71260_71289[(5)] = null);

} else {
throw ex71255;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (14))){
var inst_71202 = (state_71240[(7)]);
var inst_71213 = cljs.core.count(inst_71202);
var inst_71214 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71213);
var state_71240__$1 = state_71240;
if(inst_71214){
var statearr_71261_71290 = state_71240__$1;
(statearr_71261_71290[(1)] = (17));

} else {
var statearr_71262_71291 = state_71240__$1;
(statearr_71262_71291[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (16))){
var inst_71210 = (state_71240[(8)]);
var inst_71202 = (state_71240[(7)]);
var inst_71222 = (state_71240[(2)]);
var inst_71223 = fluree.db.dbfunctions.internal.get_all(inst_71222,inst_71210);
var inst_71224 = cljs.core.count(inst_71210);
var inst_71225 = ((9) + inst_71224);
var inst_71226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71227 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71229 = [inst_71202,inst_71210];
var inst_71230 = (new cljs.core.PersistentVector(null,2,(5),inst_71228,inst_71229,null));
var inst_71231 = ["get-all",inst_71230,inst_71223];
var inst_71232 = cljs.core.PersistentHashMap.fromArrays(inst_71227,inst_71231);
var inst_71233 = [inst_71232,inst_71225];
var inst_71234 = (new cljs.core.PersistentVector(null,2,(5),inst_71226,inst_71233,null));
var inst_71235 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71234);
var _ = (function (){var statearr_71263 = state_71240;
(statearr_71263[(4)] = cljs.core.rest((state_71240[(4)])));

return statearr_71263;
})();
var state_71240__$1 = (function (){var statearr_71264 = state_71240;
(statearr_71264[(9)] = inst_71235);

return statearr_71264;
})();
var statearr_71265_71292 = state_71240__$1;
(statearr_71265_71292[(2)] = inst_71223);

(statearr_71265_71292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (10))){
var state_71240__$1 = state_71240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71240__$1,(13),path);
} else {
if((state_val_71241 === (18))){
var inst_71202 = (state_71240[(7)]);
var state_71240__$1 = state_71240;
var statearr_71266_71293 = state_71240__$1;
(statearr_71266_71293[(2)] = inst_71202);

(statearr_71266_71293[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71241 === (8))){
var inst_71202 = (state_71240[(2)]);
var inst_71203 = fluree.db.util.async.channel_QMARK_(path);
var state_71240__$1 = (function (){var statearr_71267 = state_71240;
(statearr_71267[(7)] = inst_71202);

return statearr_71267;
})();
if(inst_71203){
var statearr_71268_71294 = state_71240__$1;
(statearr_71268_71294[(1)] = (10));

} else {
var statearr_71269_71295 = state_71240__$1;
(statearr_71269_71295[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0 = (function (){
var statearr_71270 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71270[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__);

(statearr_71270[(1)] = (1));

return statearr_71270;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1 = (function (state_71240){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71240);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71271){var ex__13886__auto__ = e71271;
var statearr_71272_71296 = state_71240;
(statearr_71272_71296[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71240[(4)]))){
var statearr_71273_71297 = state_71240;
(statearr_71273_71297[(1)] = cljs.core.first((state_71240[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71298 = state_71240;
state_71240 = G__71298;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__ = function(state_71240){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1.call(this,state_71240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71274 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71274[(6)] = c__13957__auto__);

return statearr_71274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71337){
var state_val_71338 = (state_71337[(1)]);
if((state_val_71338 === (7))){
var state_71337__$1 = state_71337;
var statearr_71339_71363 = state_71337__$1;
(statearr_71339_71363[(2)] = subject);

(statearr_71339_71363[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (1))){
var state_71337__$1 = state_71337;
var statearr_71340_71364 = state_71337__$1;
(statearr_71340_71364[(2)] = null);

(statearr_71340_71364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (4))){
var inst_71299 = (state_71337[(2)]);
var state_71337__$1 = state_71337;
var statearr_71341_71365 = state_71337__$1;
(statearr_71341_71365[(2)] = inst_71299);

(statearr_71341_71365[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (13))){
var inst_71316 = (state_71337[(2)]);
var inst_71317 = fluree.db.util.async.throw_err(inst_71316);
var state_71337__$1 = state_71337;
var statearr_71342_71366 = state_71337__$1;
(statearr_71342_71366[(2)] = inst_71317);

(statearr_71342_71366[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (6))){
var state_71337__$1 = state_71337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71337__$1,(9),subject);
} else {
if((state_val_71338 === (3))){
var inst_71335 = (state_71337[(2)]);
var state_71337__$1 = state_71337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71337__$1,inst_71335);
} else {
if((state_val_71338 === (12))){
var inst_71312 = (state_71337[(7)]);
var inst_71320 = (state_71337[(2)]);
var inst_71321 = fluree.db.dbfunctions.internal.get_in(inst_71312,inst_71320);
var inst_71322 = cljs.core.count(inst_71320);
var inst_71323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71324 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71326 = [inst_71312,inst_71320];
var inst_71327 = (new cljs.core.PersistentVector(null,2,(5),inst_71325,inst_71326,null));
var inst_71328 = ["get-in",inst_71327,inst_71321];
var inst_71329 = cljs.core.PersistentHashMap.fromArrays(inst_71324,inst_71328);
var inst_71330 = [inst_71329,inst_71322];
var inst_71331 = (new cljs.core.PersistentVector(null,2,(5),inst_71323,inst_71330,null));
var inst_71332 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71331);
var _ = (function (){var statearr_71343 = state_71337;
(statearr_71343[(4)] = cljs.core.rest((state_71337[(4)])));

return statearr_71343;
})();
var state_71337__$1 = (function (){var statearr_71344 = state_71337;
(statearr_71344[(8)] = inst_71332);

return statearr_71344;
})();
var statearr_71345_71367 = state_71337__$1;
(statearr_71345_71367[(2)] = inst_71321);

(statearr_71345_71367[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (2))){
var _ = (function (){var statearr_71346 = state_71337;
(statearr_71346[(4)] = cljs.core.cons((5),(state_71337[(4)])));

return statearr_71346;
})();
var inst_71305 = fluree.db.util.async.channel_QMARK_(subject);
var state_71337__$1 = state_71337;
if(inst_71305){
var statearr_71347_71368 = state_71337__$1;
(statearr_71347_71368[(1)] = (6));

} else {
var statearr_71348_71369 = state_71337__$1;
(statearr_71348_71369[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (11))){
var state_71337__$1 = state_71337;
var statearr_71350_71370 = state_71337__$1;
(statearr_71350_71370[(2)] = path);

(statearr_71350_71370[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (9))){
var inst_71308 = (state_71337[(2)]);
var inst_71309 = fluree.db.util.async.throw_err(inst_71308);
var state_71337__$1 = state_71337;
var statearr_71351_71371 = state_71337__$1;
(statearr_71351_71371[(2)] = inst_71309);

(statearr_71351_71371[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (5))){
var _ = (function (){var statearr_71352 = state_71337;
(statearr_71352[(4)] = cljs.core.rest((state_71337[(4)])));

return statearr_71352;
})();
var state_71337__$1 = state_71337;
var ex71349 = (state_71337__$1[(2)]);
var statearr_71353_71372 = state_71337__$1;
(statearr_71353_71372[(5)] = ex71349);


if((ex71349 instanceof Error)){
var statearr_71354_71373 = state_71337__$1;
(statearr_71354_71373[(1)] = (4));

(statearr_71354_71373[(5)] = null);

} else {
throw ex71349;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71338 === (10))){
var state_71337__$1 = state_71337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71337__$1,(13),path);
} else {
if((state_val_71338 === (8))){
var inst_71312 = (state_71337[(2)]);
var inst_71313 = fluree.db.util.async.channel_QMARK_(path);
var state_71337__$1 = (function (){var statearr_71355 = state_71337;
(statearr_71355[(7)] = inst_71312);

return statearr_71355;
})();
if(inst_71313){
var statearr_71356_71374 = state_71337__$1;
(statearr_71356_71374[(1)] = (10));

} else {
var statearr_71357_71375 = state_71337__$1;
(statearr_71357_71375[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0 = (function (){
var statearr_71358 = [null,null,null,null,null,null,null,null,null];
(statearr_71358[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__);

(statearr_71358[(1)] = (1));

return statearr_71358;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1 = (function (state_71337){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71337);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71359){var ex__13886__auto__ = e71359;
var statearr_71360_71376 = state_71337;
(statearr_71360_71376[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71337[(4)]))){
var statearr_71361_71377 = state_71337;
(statearr_71361_71377[(1)] = cljs.core.first((state_71337[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71378 = state_71337;
state_71337 = G__71378;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__ = function(state_71337){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1.call(this,state_71337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71362 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71362[(6)] = c__13957__auto__);

return statearr_71362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71423){
var state_val_71424 = (state_71423[(1)]);
if((state_val_71424 === (7))){
var state_71423__$1 = state_71423;
var statearr_71425_71454 = state_71423__$1;
(statearr_71425_71454[(2)] = coll);

(statearr_71425_71454[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (1))){
var state_71423__$1 = state_71423;
var statearr_71426_71455 = state_71423__$1;
(statearr_71426_71455[(2)] = null);

(statearr_71426_71455[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (4))){
var inst_71379 = (state_71423[(2)]);
var state_71423__$1 = state_71423;
var statearr_71427_71456 = state_71423__$1;
(statearr_71427_71456[(2)] = inst_71379);

(statearr_71427_71456[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (15))){
var inst_71399 = (state_71423[(7)]);
var inst_71407 = (state_71423[(2)]);
var inst_71408 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_71399,inst_71407);
var inst_71409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71410 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71412 = [inst_71399,inst_71407];
var inst_71413 = (new cljs.core.PersistentVector(null,2,(5),inst_71411,inst_71412,null));
var inst_71414 = ["contains?",inst_71413,inst_71408];
var inst_71415 = cljs.core.PersistentHashMap.fromArrays(inst_71410,inst_71414);
var inst_71416 = [inst_71415,(10)];
var inst_71417 = (new cljs.core.PersistentVector(null,2,(5),inst_71409,inst_71416,null));
var inst_71418 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71417);
var _ = (function (){var statearr_71428 = state_71423;
(statearr_71428[(4)] = cljs.core.rest((state_71423[(4)])));

return statearr_71428;
})();
var state_71423__$1 = (function (){var statearr_71429 = state_71423;
(statearr_71429[(8)] = inst_71418);

return statearr_71429;
})();
var statearr_71430_71457 = state_71423__$1;
(statearr_71430_71457[(2)] = inst_71408);

(statearr_71430_71457[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (13))){
var state_71423__$1 = state_71423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71423__$1,(16),key);
} else {
if((state_val_71424 === (6))){
var state_71423__$1 = state_71423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71423__$1,(9),coll);
} else {
if((state_val_71424 === (3))){
var inst_71421 = (state_71423[(2)]);
var state_71423__$1 = state_71423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71423__$1,inst_71421);
} else {
if((state_val_71424 === (12))){
var inst_71399 = (state_71423[(2)]);
var inst_71400 = fluree.db.util.async.channel_QMARK_(key);
var state_71423__$1 = (function (){var statearr_71431 = state_71423;
(statearr_71431[(7)] = inst_71399);

return statearr_71431;
})();
if(inst_71400){
var statearr_71432_71458 = state_71423__$1;
(statearr_71432_71458[(1)] = (13));

} else {
var statearr_71433_71459 = state_71423__$1;
(statearr_71433_71459[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (2))){
var _ = (function (){var statearr_71434 = state_71423;
(statearr_71434[(4)] = cljs.core.cons((5),(state_71423[(4)])));

return statearr_71434;
})();
var inst_71385 = fluree.db.util.async.channel_QMARK_(coll);
var state_71423__$1 = state_71423;
if(inst_71385){
var statearr_71435_71460 = state_71423__$1;
(statearr_71435_71460[(1)] = (6));

} else {
var statearr_71436_71461 = state_71423__$1;
(statearr_71436_71461[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (11))){
var inst_71392 = (state_71423[(9)]);
var inst_71396 = cljs.core.flatten(inst_71392);
var inst_71397 = cljs.core.set(inst_71396);
var state_71423__$1 = state_71423;
var statearr_71438_71462 = state_71423__$1;
(statearr_71438_71462[(2)] = inst_71397);

(statearr_71438_71462[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (9))){
var inst_71388 = (state_71423[(2)]);
var inst_71389 = fluree.db.util.async.throw_err(inst_71388);
var state_71423__$1 = state_71423;
var statearr_71439_71463 = state_71423__$1;
(statearr_71439_71463[(2)] = inst_71389);

(statearr_71439_71463[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (5))){
var _ = (function (){var statearr_71440 = state_71423;
(statearr_71440[(4)] = cljs.core.rest((state_71423[(4)])));

return statearr_71440;
})();
var state_71423__$1 = state_71423;
var ex71437 = (state_71423__$1[(2)]);
var statearr_71441_71464 = state_71423__$1;
(statearr_71441_71464[(5)] = ex71437);


if((ex71437 instanceof Error)){
var statearr_71442_71465 = state_71423__$1;
(statearr_71442_71465[(1)] = (4));

(statearr_71442_71465[(5)] = null);

} else {
throw ex71437;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (14))){
var state_71423__$1 = state_71423;
var statearr_71443_71466 = state_71423__$1;
(statearr_71443_71466[(2)] = key);

(statearr_71443_71466[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (16))){
var inst_71403 = (state_71423[(2)]);
var inst_71404 = fluree.db.util.async.throw_err(inst_71403);
var state_71423__$1 = state_71423;
var statearr_71444_71467 = state_71423__$1;
(statearr_71444_71467[(2)] = inst_71404);

(statearr_71444_71467[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (10))){
var inst_71392 = (state_71423[(9)]);
var state_71423__$1 = state_71423;
var statearr_71445_71468 = state_71423__$1;
(statearr_71445_71468[(2)] = inst_71392);

(statearr_71445_71468[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71424 === (8))){
var inst_71392 = (state_71423[(9)]);
var inst_71392__$1 = (state_71423[(2)]);
var inst_71393 = cljs.core.set_QMARK_(inst_71392__$1);
var state_71423__$1 = (function (){var statearr_71446 = state_71423;
(statearr_71446[(9)] = inst_71392__$1);

return statearr_71446;
})();
if(inst_71393){
var statearr_71447_71469 = state_71423__$1;
(statearr_71447_71469[(1)] = (10));

} else {
var statearr_71448_71470 = state_71423__$1;
(statearr_71448_71470[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_71449 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71449[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__);

(statearr_71449[(1)] = (1));

return statearr_71449;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1 = (function (state_71423){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71423);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71450){var ex__13886__auto__ = e71450;
var statearr_71451_71471 = state_71423;
(statearr_71451_71471[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71423[(4)]))){
var statearr_71452_71472 = state_71423;
(statearr_71452_71472[(1)] = cljs.core.first((state_71423[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71473 = state_71423;
state_71423 = G__71473;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__ = function(state_71423){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1.call(this,state_71423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71453 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71453[(6)] = c__13957__auto__);

return statearr_71453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71538 = arguments.length;
var i__4772__auto___71539 = (0);
while(true){
if((i__4772__auto___71539 < len__4771__auto___71538)){
args__4777__auto__.push((arguments[i__4772__auto___71539]));

var G__71540 = (i__4772__auto___71539 + (1));
i__4772__auto___71539 = G__71540;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71516){
var state_val_71517 = (state_71516[(1)]);
if((state_val_71517 === (7))){
var inst_71485 = (state_71516[(7)]);
var inst_71492 = cljs.core.first(inst_71485);
var state_71516__$1 = state_71516;
var statearr_71518_71541 = state_71516__$1;
(statearr_71518_71541[(2)] = inst_71492);

(statearr_71518_71541[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (1))){
var state_71516__$1 = state_71516;
var statearr_71519_71542 = state_71516__$1;
(statearr_71519_71542[(2)] = null);

(statearr_71519_71542[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (4))){
var inst_71476 = (state_71516[(2)]);
var state_71516__$1 = state_71516;
var statearr_71520_71543 = state_71516__$1;
(statearr_71520_71543[(2)] = inst_71476);

(statearr_71520_71543[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (6))){
var inst_71485 = (state_71516[(7)]);
var inst_71484 = (state_71516[(2)]);
var inst_71485__$1 = fluree.db.util.async.throw_err(inst_71484);
var inst_71486 = cljs.core.count(inst_71485__$1);
var inst_71487 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71486);
var inst_71488 = cljs.core.first(inst_71485__$1);
var inst_71489 = cljs.core.coll_QMARK_(inst_71488);
var inst_71490 = ((inst_71487) && (inst_71489));
var state_71516__$1 = (function (){var statearr_71521 = state_71516;
(statearr_71521[(7)] = inst_71485__$1);

return statearr_71521;
})();
if(cljs.core.truth_(inst_71490)){
var statearr_71522_71544 = state_71516__$1;
(statearr_71522_71544[(1)] = (7));

} else {
var statearr_71523_71545 = state_71516__$1;
(statearr_71523_71545[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (3))){
var inst_71514 = (state_71516[(2)]);
var state_71516__$1 = state_71516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71516__$1,inst_71514);
} else {
if((state_val_71517 === (2))){
var _ = (function (){var statearr_71525 = state_71516;
(statearr_71525[(4)] = cljs.core.cons((5),(state_71516[(4)])));

return statearr_71525;
})();
var inst_71482 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71516__$1 = state_71516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71516__$1,(6),inst_71482);
} else {
if((state_val_71517 === (9))){
var inst_71495 = (state_71516[(2)]);
var inst_71496 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_71495);
var inst_71497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71498 = [inst_71495];
var inst_71499 = (new cljs.core.PersistentVector(null,1,(5),inst_71497,inst_71498,null));
var inst_71500 = cljs.core.count(inst_71499);
var inst_71501 = ((9) + inst_71500);
var inst_71502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71503 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71505 = [inst_71495];
var inst_71506 = (new cljs.core.PersistentVector(null,1,(5),inst_71504,inst_71505,null));
var inst_71507 = ["hash-set",inst_71506,inst_71496];
var inst_71508 = cljs.core.PersistentHashMap.fromArrays(inst_71503,inst_71507);
var inst_71509 = [inst_71508,inst_71501];
var inst_71510 = (new cljs.core.PersistentVector(null,2,(5),inst_71502,inst_71509,null));
var inst_71511 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71510);
var _ = (function (){var statearr_71526 = state_71516;
(statearr_71526[(4)] = cljs.core.rest((state_71516[(4)])));

return statearr_71526;
})();
var state_71516__$1 = (function (){var statearr_71527 = state_71516;
(statearr_71527[(8)] = inst_71511);

return statearr_71527;
})();
var statearr_71528_71546 = state_71516__$1;
(statearr_71528_71546[(2)] = inst_71496);

(statearr_71528_71546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (5))){
var _ = (function (){var statearr_71529 = state_71516;
(statearr_71529[(4)] = cljs.core.rest((state_71516[(4)])));

return statearr_71529;
})();
var state_71516__$1 = state_71516;
var ex71524 = (state_71516__$1[(2)]);
var statearr_71530_71547 = state_71516__$1;
(statearr_71530_71547[(5)] = ex71524);


if((ex71524 instanceof Error)){
var statearr_71531_71548 = state_71516__$1;
(statearr_71531_71548[(1)] = (4));

(statearr_71531_71548[(5)] = null);

} else {
throw ex71524;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71517 === (8))){
var inst_71485 = (state_71516[(7)]);
var state_71516__$1 = state_71516;
var statearr_71532_71549 = state_71516__$1;
(statearr_71532_71549[(2)] = inst_71485);

(statearr_71532_71549[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71533 = [null,null,null,null,null,null,null,null,null];
(statearr_71533[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71533[(1)] = (1));

return statearr_71533;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71516){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71516);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71534){var ex__13886__auto__ = e71534;
var statearr_71535_71550 = state_71516;
(statearr_71535_71550[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71516[(4)]))){
var statearr_71536_71551 = state_71516;
(statearr_71536_71551[(1)] = cljs.core.first((state_71516[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71552 = state_71516;
state_71516 = G__71552;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71516){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71537 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71537[(6)] = c__13957__auto__);

return statearr_71537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq71474){
var G__71475 = cljs.core.first(seq71474);
var seq71474__$1 = cljs.core.next(seq71474);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71475,seq71474__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71602 = arguments.length;
var i__4772__auto___71603 = (0);
while(true){
if((i__4772__auto___71603 < len__4771__auto___71602)){
args__4777__auto__.push((arguments[i__4772__auto___71603]));

var G__71604 = (i__4772__auto___71603 + (1));
i__4772__auto___71603 = G__71604;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71585){
var state_val_71586 = (state_71585[(1)]);
if((state_val_71586 === (1))){
var state_71585__$1 = state_71585;
var statearr_71587_71605 = state_71585__$1;
(statearr_71587_71605[(2)] = null);

(statearr_71587_71605[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71586 === (2))){
var _ = (function (){var statearr_71588 = state_71585;
(statearr_71588[(4)] = cljs.core.cons((5),(state_71585[(4)])));

return statearr_71588;
})();
var inst_71561 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71585__$1 = state_71585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71585__$1,(6),inst_71561);
} else {
if((state_val_71586 === (3))){
var inst_71583 = (state_71585[(2)]);
var state_71585__$1 = state_71585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71585__$1,inst_71583);
} else {
if((state_val_71586 === (4))){
var inst_71555 = (state_71585[(2)]);
var state_71585__$1 = state_71585;
var statearr_71590_71606 = state_71585__$1;
(statearr_71590_71606[(2)] = inst_71555);

(statearr_71590_71606[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71586 === (5))){
var _ = (function (){var statearr_71591 = state_71585;
(statearr_71591[(4)] = cljs.core.rest((state_71585[(4)])));

return statearr_71591;
})();
var state_71585__$1 = state_71585;
var ex71589 = (state_71585__$1[(2)]);
var statearr_71592_71607 = state_71585__$1;
(statearr_71592_71607[(5)] = ex71589);


if((ex71589 instanceof Error)){
var statearr_71593_71608 = state_71585__$1;
(statearr_71593_71608[(1)] = (4));

(statearr_71593_71608[(5)] = null);

} else {
throw ex71589;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71586 === (6))){
var inst_71563 = (state_71585[(2)]);
var inst_71564 = fluree.db.util.async.throw_err(inst_71563);
var inst_71565 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_71564);
var inst_71566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71567 = [inst_71564];
var inst_71568 = (new cljs.core.PersistentVector(null,1,(5),inst_71566,inst_71567,null));
var inst_71569 = cljs.core.count(inst_71568);
var inst_71570 = ((9) + inst_71569);
var inst_71571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71572 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71574 = [inst_71564];
var inst_71575 = (new cljs.core.PersistentVector(null,1,(5),inst_71573,inst_71574,null));
var inst_71576 = ["==",inst_71575,inst_71565];
var inst_71577 = cljs.core.PersistentHashMap.fromArrays(inst_71572,inst_71576);
var inst_71578 = [inst_71577,inst_71570];
var inst_71579 = (new cljs.core.PersistentVector(null,2,(5),inst_71571,inst_71578,null));
var inst_71580 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71579);
var _ = (function (){var statearr_71594 = state_71585;
(statearr_71594[(4)] = cljs.core.rest((state_71585[(4)])));

return statearr_71594;
})();
var state_71585__$1 = (function (){var statearr_71595 = state_71585;
(statearr_71595[(7)] = inst_71580);

return statearr_71595;
})();
var statearr_71596_71609 = state_71585__$1;
(statearr_71596_71609[(2)] = inst_71565);

(statearr_71596_71609[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71597 = [null,null,null,null,null,null,null,null];
(statearr_71597[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71597[(1)] = (1));

return statearr_71597;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71585){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71585);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71598){var ex__13886__auto__ = e71598;
var statearr_71599_71610 = state_71585;
(statearr_71599_71610[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71585[(4)]))){
var statearr_71600_71611 = state_71585;
(statearr_71600_71611[(1)] = cljs.core.first((state_71585[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71612 = state_71585;
state_71585 = G__71612;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71601 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71601[(6)] = c__13957__auto__);

return statearr_71601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq71553){
var G__71554 = cljs.core.first(seq71553);
var seq71553__$1 = cljs.core.next(seq71553);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71554,seq71553__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71662 = arguments.length;
var i__4772__auto___71663 = (0);
while(true){
if((i__4772__auto___71663 < len__4771__auto___71662)){
args__4777__auto__.push((arguments[i__4772__auto___71663]));

var G__71664 = (i__4772__auto___71663 + (1));
i__4772__auto___71663 = G__71664;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71645){
var state_val_71646 = (state_71645[(1)]);
if((state_val_71646 === (1))){
var state_71645__$1 = state_71645;
var statearr_71647_71665 = state_71645__$1;
(statearr_71647_71665[(2)] = null);

(statearr_71647_71665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71646 === (2))){
var _ = (function (){var statearr_71648 = state_71645;
(statearr_71648[(4)] = cljs.core.cons((5),(state_71645[(4)])));

return statearr_71648;
})();
var inst_71621 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71645__$1 = state_71645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71645__$1,(6),inst_71621);
} else {
if((state_val_71646 === (3))){
var inst_71643 = (state_71645[(2)]);
var state_71645__$1 = state_71645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71645__$1,inst_71643);
} else {
if((state_val_71646 === (4))){
var inst_71615 = (state_71645[(2)]);
var state_71645__$1 = state_71645;
var statearr_71650_71666 = state_71645__$1;
(statearr_71650_71666[(2)] = inst_71615);

(statearr_71650_71666[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71646 === (5))){
var _ = (function (){var statearr_71651 = state_71645;
(statearr_71651[(4)] = cljs.core.rest((state_71645[(4)])));

return statearr_71651;
})();
var state_71645__$1 = state_71645;
var ex71649 = (state_71645__$1[(2)]);
var statearr_71652_71667 = state_71645__$1;
(statearr_71652_71667[(5)] = ex71649);


if((ex71649 instanceof Error)){
var statearr_71653_71668 = state_71645__$1;
(statearr_71653_71668[(1)] = (4));

(statearr_71653_71668[(5)] = null);

} else {
throw ex71649;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71646 === (6))){
var inst_71623 = (state_71645[(2)]);
var inst_71624 = fluree.db.util.async.throw_err(inst_71623);
var inst_71625 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_71624);
var inst_71626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71627 = [inst_71624];
var inst_71628 = (new cljs.core.PersistentVector(null,1,(5),inst_71626,inst_71627,null));
var inst_71629 = cljs.core.count(inst_71628);
var inst_71630 = ((9) + inst_71629);
var inst_71631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71632 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71634 = [inst_71624];
var inst_71635 = (new cljs.core.PersistentVector(null,1,(5),inst_71633,inst_71634,null));
var inst_71636 = [">",inst_71635,inst_71625];
var inst_71637 = cljs.core.PersistentHashMap.fromArrays(inst_71632,inst_71636);
var inst_71638 = [inst_71637,inst_71630];
var inst_71639 = (new cljs.core.PersistentVector(null,2,(5),inst_71631,inst_71638,null));
var inst_71640 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71639);
var _ = (function (){var statearr_71654 = state_71645;
(statearr_71654[(4)] = cljs.core.rest((state_71645[(4)])));

return statearr_71654;
})();
var state_71645__$1 = (function (){var statearr_71655 = state_71645;
(statearr_71655[(7)] = inst_71640);

return statearr_71655;
})();
var statearr_71656_71669 = state_71645__$1;
(statearr_71656_71669[(2)] = inst_71625);

(statearr_71656_71669[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71657 = [null,null,null,null,null,null,null,null];
(statearr_71657[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71657[(1)] = (1));

return statearr_71657;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71645){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71645);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71658){var ex__13886__auto__ = e71658;
var statearr_71659_71670 = state_71645;
(statearr_71659_71670[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71645[(4)]))){
var statearr_71660_71671 = state_71645;
(statearr_71660_71671[(1)] = cljs.core.first((state_71645[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71672 = state_71645;
state_71645 = G__71672;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71645){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71661 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71661[(6)] = c__13957__auto__);

return statearr_71661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq71613){
var G__71614 = cljs.core.first(seq71613);
var seq71613__$1 = cljs.core.next(seq71613);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71614,seq71613__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71722 = arguments.length;
var i__4772__auto___71723 = (0);
while(true){
if((i__4772__auto___71723 < len__4771__auto___71722)){
args__4777__auto__.push((arguments[i__4772__auto___71723]));

var G__71724 = (i__4772__auto___71723 + (1));
i__4772__auto___71723 = G__71724;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71705){
var state_val_71706 = (state_71705[(1)]);
if((state_val_71706 === (1))){
var state_71705__$1 = state_71705;
var statearr_71707_71725 = state_71705__$1;
(statearr_71707_71725[(2)] = null);

(statearr_71707_71725[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71706 === (2))){
var _ = (function (){var statearr_71708 = state_71705;
(statearr_71708[(4)] = cljs.core.cons((5),(state_71705[(4)])));

return statearr_71708;
})();
var inst_71681 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71705__$1 = state_71705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71705__$1,(6),inst_71681);
} else {
if((state_val_71706 === (3))){
var inst_71703 = (state_71705[(2)]);
var state_71705__$1 = state_71705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71705__$1,inst_71703);
} else {
if((state_val_71706 === (4))){
var inst_71675 = (state_71705[(2)]);
var state_71705__$1 = state_71705;
var statearr_71710_71726 = state_71705__$1;
(statearr_71710_71726[(2)] = inst_71675);

(statearr_71710_71726[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71706 === (5))){
var _ = (function (){var statearr_71711 = state_71705;
(statearr_71711[(4)] = cljs.core.rest((state_71705[(4)])));

return statearr_71711;
})();
var state_71705__$1 = state_71705;
var ex71709 = (state_71705__$1[(2)]);
var statearr_71712_71727 = state_71705__$1;
(statearr_71712_71727[(5)] = ex71709);


if((ex71709 instanceof Error)){
var statearr_71713_71728 = state_71705__$1;
(statearr_71713_71728[(1)] = (4));

(statearr_71713_71728[(5)] = null);

} else {
throw ex71709;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71706 === (6))){
var inst_71683 = (state_71705[(2)]);
var inst_71684 = fluree.db.util.async.throw_err(inst_71683);
var inst_71685 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_71684);
var inst_71686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71687 = [inst_71684];
var inst_71688 = (new cljs.core.PersistentVector(null,1,(5),inst_71686,inst_71687,null));
var inst_71689 = cljs.core.count(inst_71688);
var inst_71690 = ((9) + inst_71689);
var inst_71691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71692 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71694 = [inst_71684];
var inst_71695 = (new cljs.core.PersistentVector(null,1,(5),inst_71693,inst_71694,null));
var inst_71696 = ["<",inst_71695,inst_71685];
var inst_71697 = cljs.core.PersistentHashMap.fromArrays(inst_71692,inst_71696);
var inst_71698 = [inst_71697,inst_71690];
var inst_71699 = (new cljs.core.PersistentVector(null,2,(5),inst_71691,inst_71698,null));
var inst_71700 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71699);
var _ = (function (){var statearr_71714 = state_71705;
(statearr_71714[(4)] = cljs.core.rest((state_71705[(4)])));

return statearr_71714;
})();
var state_71705__$1 = (function (){var statearr_71715 = state_71705;
(statearr_71715[(7)] = inst_71700);

return statearr_71715;
})();
var statearr_71716_71729 = state_71705__$1;
(statearr_71716_71729[(2)] = inst_71685);

(statearr_71716_71729[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71717 = [null,null,null,null,null,null,null,null];
(statearr_71717[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71717[(1)] = (1));

return statearr_71717;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71705){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71705);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71718){var ex__13886__auto__ = e71718;
var statearr_71719_71730 = state_71705;
(statearr_71719_71730[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71705[(4)]))){
var statearr_71720_71731 = state_71705;
(statearr_71720_71731[(1)] = cljs.core.first((state_71705[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71732 = state_71705;
state_71705 = G__71732;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71705){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71721 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71721[(6)] = c__13957__auto__);

return statearr_71721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq71673){
var G__71674 = cljs.core.first(seq71673);
var seq71673__$1 = cljs.core.next(seq71673);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71674,seq71673__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71782 = arguments.length;
var i__4772__auto___71783 = (0);
while(true){
if((i__4772__auto___71783 < len__4771__auto___71782)){
args__4777__auto__.push((arguments[i__4772__auto___71783]));

var G__71784 = (i__4772__auto___71783 + (1));
i__4772__auto___71783 = G__71784;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71765){
var state_val_71766 = (state_71765[(1)]);
if((state_val_71766 === (1))){
var state_71765__$1 = state_71765;
var statearr_71767_71785 = state_71765__$1;
(statearr_71767_71785[(2)] = null);

(statearr_71767_71785[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71766 === (2))){
var _ = (function (){var statearr_71768 = state_71765;
(statearr_71768[(4)] = cljs.core.cons((5),(state_71765[(4)])));

return statearr_71768;
})();
var inst_71741 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71765__$1 = state_71765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71765__$1,(6),inst_71741);
} else {
if((state_val_71766 === (3))){
var inst_71763 = (state_71765[(2)]);
var state_71765__$1 = state_71765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71765__$1,inst_71763);
} else {
if((state_val_71766 === (4))){
var inst_71735 = (state_71765[(2)]);
var state_71765__$1 = state_71765;
var statearr_71770_71786 = state_71765__$1;
(statearr_71770_71786[(2)] = inst_71735);

(statearr_71770_71786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71766 === (5))){
var _ = (function (){var statearr_71771 = state_71765;
(statearr_71771[(4)] = cljs.core.rest((state_71765[(4)])));

return statearr_71771;
})();
var state_71765__$1 = state_71765;
var ex71769 = (state_71765__$1[(2)]);
var statearr_71772_71787 = state_71765__$1;
(statearr_71772_71787[(5)] = ex71769);


if((ex71769 instanceof Error)){
var statearr_71773_71788 = state_71765__$1;
(statearr_71773_71788[(1)] = (4));

(statearr_71773_71788[(5)] = null);

} else {
throw ex71769;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71766 === (6))){
var inst_71743 = (state_71765[(2)]);
var inst_71744 = fluree.db.util.async.throw_err(inst_71743);
var inst_71745 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_71744);
var inst_71746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71747 = [inst_71744];
var inst_71748 = (new cljs.core.PersistentVector(null,1,(5),inst_71746,inst_71747,null));
var inst_71749 = cljs.core.count(inst_71748);
var inst_71750 = ((9) + inst_71749);
var inst_71751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71752 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71754 = [inst_71744];
var inst_71755 = (new cljs.core.PersistentVector(null,1,(5),inst_71753,inst_71754,null));
var inst_71756 = ["<=",inst_71755,inst_71745];
var inst_71757 = cljs.core.PersistentHashMap.fromArrays(inst_71752,inst_71756);
var inst_71758 = [inst_71757,inst_71750];
var inst_71759 = (new cljs.core.PersistentVector(null,2,(5),inst_71751,inst_71758,null));
var inst_71760 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71759);
var _ = (function (){var statearr_71774 = state_71765;
(statearr_71774[(4)] = cljs.core.rest((state_71765[(4)])));

return statearr_71774;
})();
var state_71765__$1 = (function (){var statearr_71775 = state_71765;
(statearr_71775[(7)] = inst_71760);

return statearr_71775;
})();
var statearr_71776_71789 = state_71765__$1;
(statearr_71776_71789[(2)] = inst_71745);

(statearr_71776_71789[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71777 = [null,null,null,null,null,null,null,null];
(statearr_71777[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71777[(1)] = (1));

return statearr_71777;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71765){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71765);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71778){var ex__13886__auto__ = e71778;
var statearr_71779_71790 = state_71765;
(statearr_71779_71790[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71765[(4)]))){
var statearr_71780_71791 = state_71765;
(statearr_71780_71791[(1)] = cljs.core.first((state_71765[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71792 = state_71765;
state_71765 = G__71792;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71765){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71781 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71781[(6)] = c__13957__auto__);

return statearr_71781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq71733){
var G__71734 = cljs.core.first(seq71733);
var seq71733__$1 = cljs.core.next(seq71733);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71734,seq71733__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71842 = arguments.length;
var i__4772__auto___71843 = (0);
while(true){
if((i__4772__auto___71843 < len__4771__auto___71842)){
args__4777__auto__.push((arguments[i__4772__auto___71843]));

var G__71844 = (i__4772__auto___71843 + (1));
i__4772__auto___71843 = G__71844;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71825){
var state_val_71826 = (state_71825[(1)]);
if((state_val_71826 === (1))){
var state_71825__$1 = state_71825;
var statearr_71827_71845 = state_71825__$1;
(statearr_71827_71845[(2)] = null);

(statearr_71827_71845[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71826 === (2))){
var _ = (function (){var statearr_71828 = state_71825;
(statearr_71828[(4)] = cljs.core.cons((5),(state_71825[(4)])));

return statearr_71828;
})();
var inst_71801 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71825__$1 = state_71825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71825__$1,(6),inst_71801);
} else {
if((state_val_71826 === (3))){
var inst_71823 = (state_71825[(2)]);
var state_71825__$1 = state_71825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71825__$1,inst_71823);
} else {
if((state_val_71826 === (4))){
var inst_71795 = (state_71825[(2)]);
var state_71825__$1 = state_71825;
var statearr_71830_71846 = state_71825__$1;
(statearr_71830_71846[(2)] = inst_71795);

(statearr_71830_71846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71826 === (5))){
var _ = (function (){var statearr_71831 = state_71825;
(statearr_71831[(4)] = cljs.core.rest((state_71825[(4)])));

return statearr_71831;
})();
var state_71825__$1 = state_71825;
var ex71829 = (state_71825__$1[(2)]);
var statearr_71832_71847 = state_71825__$1;
(statearr_71832_71847[(5)] = ex71829);


if((ex71829 instanceof Error)){
var statearr_71833_71848 = state_71825__$1;
(statearr_71833_71848[(1)] = (4));

(statearr_71833_71848[(5)] = null);

} else {
throw ex71829;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71826 === (6))){
var inst_71803 = (state_71825[(2)]);
var inst_71804 = fluree.db.util.async.throw_err(inst_71803);
var inst_71805 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_71804);
var inst_71806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71807 = [inst_71804];
var inst_71808 = (new cljs.core.PersistentVector(null,1,(5),inst_71806,inst_71807,null));
var inst_71809 = cljs.core.count(inst_71808);
var inst_71810 = ((9) + inst_71809);
var inst_71811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71812 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71814 = [inst_71804];
var inst_71815 = (new cljs.core.PersistentVector(null,1,(5),inst_71813,inst_71814,null));
var inst_71816 = [">=",inst_71815,inst_71805];
var inst_71817 = cljs.core.PersistentHashMap.fromArrays(inst_71812,inst_71816);
var inst_71818 = [inst_71817,inst_71810];
var inst_71819 = (new cljs.core.PersistentVector(null,2,(5),inst_71811,inst_71818,null));
var inst_71820 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71819);
var _ = (function (){var statearr_71834 = state_71825;
(statearr_71834[(4)] = cljs.core.rest((state_71825[(4)])));

return statearr_71834;
})();
var state_71825__$1 = (function (){var statearr_71835 = state_71825;
(statearr_71835[(7)] = inst_71820);

return statearr_71835;
})();
var statearr_71836_71849 = state_71825__$1;
(statearr_71836_71849[(2)] = inst_71805);

(statearr_71836_71849[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71837 = [null,null,null,null,null,null,null,null];
(statearr_71837[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71837[(1)] = (1));

return statearr_71837;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71825){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71825);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71838){var ex__13886__auto__ = e71838;
var statearr_71839_71850 = state_71825;
(statearr_71839_71850[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71825[(4)]))){
var statearr_71840_71851 = state_71825;
(statearr_71840_71851[(1)] = cljs.core.first((state_71825[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71852 = state_71825;
state_71825 = G__71852;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71825){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71841 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71841[(6)] = c__13957__auto__);

return statearr_71841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq71793){
var G__71794 = cljs.core.first(seq71793);
var seq71793__$1 = cljs.core.next(seq71793);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71794,seq71793__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71902 = arguments.length;
var i__4772__auto___71903 = (0);
while(true){
if((i__4772__auto___71903 < len__4771__auto___71902)){
args__4777__auto__.push((arguments[i__4772__auto___71903]));

var G__71904 = (i__4772__auto___71903 + (1));
i__4772__auto___71903 = G__71904;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71885){
var state_val_71886 = (state_71885[(1)]);
if((state_val_71886 === (1))){
var state_71885__$1 = state_71885;
var statearr_71887_71905 = state_71885__$1;
(statearr_71887_71905[(2)] = null);

(statearr_71887_71905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71886 === (2))){
var _ = (function (){var statearr_71888 = state_71885;
(statearr_71888[(4)] = cljs.core.cons((5),(state_71885[(4)])));

return statearr_71888;
})();
var inst_71861 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71885__$1 = state_71885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71885__$1,(6),inst_71861);
} else {
if((state_val_71886 === (3))){
var inst_71883 = (state_71885[(2)]);
var state_71885__$1 = state_71885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71885__$1,inst_71883);
} else {
if((state_val_71886 === (4))){
var inst_71855 = (state_71885[(2)]);
var state_71885__$1 = state_71885;
var statearr_71890_71906 = state_71885__$1;
(statearr_71890_71906[(2)] = inst_71855);

(statearr_71890_71906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71886 === (5))){
var _ = (function (){var statearr_71891 = state_71885;
(statearr_71891[(4)] = cljs.core.rest((state_71885[(4)])));

return statearr_71891;
})();
var state_71885__$1 = state_71885;
var ex71889 = (state_71885__$1[(2)]);
var statearr_71892_71907 = state_71885__$1;
(statearr_71892_71907[(5)] = ex71889);


if((ex71889 instanceof Error)){
var statearr_71893_71908 = state_71885__$1;
(statearr_71893_71908[(1)] = (4));

(statearr_71893_71908[(5)] = null);

} else {
throw ex71889;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71886 === (6))){
var inst_71863 = (state_71885[(2)]);
var inst_71864 = fluree.db.util.async.throw_err(inst_71863);
var inst_71865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_71864);
var inst_71866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71867 = [inst_71864];
var inst_71868 = (new cljs.core.PersistentVector(null,1,(5),inst_71866,inst_71867,null));
var inst_71869 = cljs.core.count(inst_71868);
var inst_71870 = ((9) + inst_71869);
var inst_71871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71872 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71874 = [inst_71864];
var inst_71875 = (new cljs.core.PersistentVector(null,1,(5),inst_71873,inst_71874,null));
var inst_71876 = ["not=",inst_71875,inst_71865];
var inst_71877 = cljs.core.PersistentHashMap.fromArrays(inst_71872,inst_71876);
var inst_71878 = [inst_71877,inst_71870];
var inst_71879 = (new cljs.core.PersistentVector(null,2,(5),inst_71871,inst_71878,null));
var inst_71880 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71879);
var _ = (function (){var statearr_71894 = state_71885;
(statearr_71894[(4)] = cljs.core.rest((state_71885[(4)])));

return statearr_71894;
})();
var state_71885__$1 = (function (){var statearr_71895 = state_71885;
(statearr_71895[(7)] = inst_71880);

return statearr_71895;
})();
var statearr_71896_71909 = state_71885__$1;
(statearr_71896_71909[(2)] = inst_71865);

(statearr_71896_71909[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71897 = [null,null,null,null,null,null,null,null];
(statearr_71897[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71897[(1)] = (1));

return statearr_71897;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71885){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71885);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71898){var ex__13886__auto__ = e71898;
var statearr_71899_71910 = state_71885;
(statearr_71899_71910[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71885[(4)]))){
var statearr_71900_71911 = state_71885;
(statearr_71900_71911[(1)] = cljs.core.first((state_71885[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71912 = state_71885;
state_71885 = G__71912;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71885){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71901 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71901[(6)] = c__13957__auto__);

return statearr_71901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq71853){
var G__71854 = cljs.core.first(seq71853);
var seq71853__$1 = cljs.core.next(seq71853);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71854,seq71853__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71962 = arguments.length;
var i__4772__auto___71963 = (0);
while(true){
if((i__4772__auto___71963 < len__4771__auto___71962)){
args__4777__auto__.push((arguments[i__4772__auto___71963]));

var G__71964 = (i__4772__auto___71963 + (1));
i__4772__auto___71963 = G__71964;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71945){
var state_val_71946 = (state_71945[(1)]);
if((state_val_71946 === (1))){
var state_71945__$1 = state_71945;
var statearr_71947_71965 = state_71945__$1;
(statearr_71947_71965[(2)] = null);

(statearr_71947_71965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71946 === (2))){
var _ = (function (){var statearr_71948 = state_71945;
(statearr_71948[(4)] = cljs.core.cons((5),(state_71945[(4)])));

return statearr_71948;
})();
var inst_71921 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71945__$1 = state_71945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71945__$1,(6),inst_71921);
} else {
if((state_val_71946 === (3))){
var inst_71943 = (state_71945[(2)]);
var state_71945__$1 = state_71945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71945__$1,inst_71943);
} else {
if((state_val_71946 === (4))){
var inst_71915 = (state_71945[(2)]);
var state_71945__$1 = state_71945;
var statearr_71950_71966 = state_71945__$1;
(statearr_71950_71966[(2)] = inst_71915);

(statearr_71950_71966[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71946 === (5))){
var _ = (function (){var statearr_71951 = state_71945;
(statearr_71951[(4)] = cljs.core.rest((state_71945[(4)])));

return statearr_71951;
})();
var state_71945__$1 = state_71945;
var ex71949 = (state_71945__$1[(2)]);
var statearr_71952_71967 = state_71945__$1;
(statearr_71952_71967[(5)] = ex71949);


if((ex71949 instanceof Error)){
var statearr_71953_71968 = state_71945__$1;
(statearr_71953_71968[(1)] = (4));

(statearr_71953_71968[(5)] = null);

} else {
throw ex71949;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71946 === (6))){
var inst_71923 = (state_71945[(2)]);
var inst_71924 = fluree.db.util.async.throw_err(inst_71923);
var inst_71925 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_71924);
var inst_71926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71927 = [inst_71924];
var inst_71928 = (new cljs.core.PersistentVector(null,1,(5),inst_71926,inst_71927,null));
var inst_71929 = cljs.core.count(inst_71928);
var inst_71930 = ((9) + inst_71929);
var inst_71931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71932 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71934 = [inst_71924];
var inst_71935 = (new cljs.core.PersistentVector(null,1,(5),inst_71933,inst_71934,null));
var inst_71936 = ["max",inst_71935,inst_71925];
var inst_71937 = cljs.core.PersistentHashMap.fromArrays(inst_71932,inst_71936);
var inst_71938 = [inst_71937,inst_71930];
var inst_71939 = (new cljs.core.PersistentVector(null,2,(5),inst_71931,inst_71938,null));
var inst_71940 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71939);
var _ = (function (){var statearr_71954 = state_71945;
(statearr_71954[(4)] = cljs.core.rest((state_71945[(4)])));

return statearr_71954;
})();
var state_71945__$1 = (function (){var statearr_71955 = state_71945;
(statearr_71955[(7)] = inst_71940);

return statearr_71955;
})();
var statearr_71956_71969 = state_71945__$1;
(statearr_71956_71969[(2)] = inst_71925);

(statearr_71956_71969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71957 = [null,null,null,null,null,null,null,null];
(statearr_71957[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71957[(1)] = (1));

return statearr_71957;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71945){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71945);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71958){var ex__13886__auto__ = e71958;
var statearr_71959_71970 = state_71945;
(statearr_71959_71970[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71945[(4)]))){
var statearr_71960_71971 = state_71945;
(statearr_71960_71971[(1)] = cljs.core.first((state_71945[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71972 = state_71945;
state_71945 = G__71972;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71945){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71961 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71961[(6)] = c__13957__auto__);

return statearr_71961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq71913){
var G__71914 = cljs.core.first(seq71913);
var seq71913__$1 = cljs.core.next(seq71913);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71914,seq71913__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72022 = arguments.length;
var i__4772__auto___72023 = (0);
while(true){
if((i__4772__auto___72023 < len__4771__auto___72022)){
args__4777__auto__.push((arguments[i__4772__auto___72023]));

var G__72024 = (i__4772__auto___72023 + (1));
i__4772__auto___72023 = G__72024;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72005){
var state_val_72006 = (state_72005[(1)]);
if((state_val_72006 === (1))){
var state_72005__$1 = state_72005;
var statearr_72007_72025 = state_72005__$1;
(statearr_72007_72025[(2)] = null);

(statearr_72007_72025[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (2))){
var _ = (function (){var statearr_72008 = state_72005;
(statearr_72008[(4)] = cljs.core.cons((5),(state_72005[(4)])));

return statearr_72008;
})();
var inst_71981 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72005__$1,(6),inst_71981);
} else {
if((state_val_72006 === (3))){
var inst_72003 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72005__$1,inst_72003);
} else {
if((state_val_72006 === (4))){
var inst_71975 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72010_72026 = state_72005__$1;
(statearr_72010_72026[(2)] = inst_71975);

(statearr_72010_72026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (5))){
var _ = (function (){var statearr_72011 = state_72005;
(statearr_72011[(4)] = cljs.core.rest((state_72005[(4)])));

return statearr_72011;
})();
var state_72005__$1 = state_72005;
var ex72009 = (state_72005__$1[(2)]);
var statearr_72012_72027 = state_72005__$1;
(statearr_72012_72027[(5)] = ex72009);


if((ex72009 instanceof Error)){
var statearr_72013_72028 = state_72005__$1;
(statearr_72013_72028[(1)] = (4));

(statearr_72013_72028[(5)] = null);

} else {
throw ex72009;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (6))){
var inst_71983 = (state_72005[(2)]);
var inst_71984 = fluree.db.util.async.throw_err(inst_71983);
var inst_71985 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_71984);
var inst_71986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71987 = [inst_71984];
var inst_71988 = (new cljs.core.PersistentVector(null,1,(5),inst_71986,inst_71987,null));
var inst_71989 = cljs.core.count(inst_71988);
var inst_71990 = ((9) + inst_71989);
var inst_71991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71992 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71994 = [inst_71984];
var inst_71995 = (new cljs.core.PersistentVector(null,1,(5),inst_71993,inst_71994,null));
var inst_71996 = ["min",inst_71995,inst_71985];
var inst_71997 = cljs.core.PersistentHashMap.fromArrays(inst_71992,inst_71996);
var inst_71998 = [inst_71997,inst_71990];
var inst_71999 = (new cljs.core.PersistentVector(null,2,(5),inst_71991,inst_71998,null));
var inst_72000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71999);
var _ = (function (){var statearr_72014 = state_72005;
(statearr_72014[(4)] = cljs.core.rest((state_72005[(4)])));

return statearr_72014;
})();
var state_72005__$1 = (function (){var statearr_72015 = state_72005;
(statearr_72015[(7)] = inst_72000);

return statearr_72015;
})();
var statearr_72016_72029 = state_72005__$1;
(statearr_72016_72029[(2)] = inst_71985);

(statearr_72016_72029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72017 = [null,null,null,null,null,null,null,null];
(statearr_72017[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72017[(1)] = (1));

return statearr_72017;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72005){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72005);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72018){var ex__13886__auto__ = e72018;
var statearr_72019_72030 = state_72005;
(statearr_72019_72030[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72005[(4)]))){
var statearr_72020_72031 = state_72005;
(statearr_72020_72031[(1)] = cljs.core.first((state_72005[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72032 = state_72005;
state_72005 = G__72032;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72021 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72021[(6)] = c__13957__auto__);

return statearr_72021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq71973){
var G__71974 = cljs.core.first(seq71973);
var seq71973__$1 = cljs.core.next(seq71973);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71974,seq71973__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__72034 = arguments.length;
switch (G__72034) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72079){
var state_val_72080 = (state_72079[(1)]);
if((state_val_72080 === (7))){
var state_72079__$1 = state_72079;
var statearr_72081_72218 = state_72079__$1;
(statearr_72081_72218[(2)] = query_map);

(statearr_72081_72218[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (1))){
var state_72079__$1 = state_72079;
var statearr_72082_72219 = state_72079__$1;
(statearr_72082_72219[(2)] = null);

(statearr_72082_72219[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (4))){
var inst_72035 = (state_72079[(2)]);
var state_72079__$1 = state_72079;
var statearr_72083_72220 = state_72079__$1;
(statearr_72083_72220[(2)] = inst_72035);

(statearr_72083_72220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (13))){
var inst_72057 = (state_72079[(7)]);
var inst_72061 = (state_72079[(2)]);
var inst_72062 = fluree.db.util.async.throw_err(inst_72061);
var inst_72063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72062,(0),null);
var inst_72064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72062,(1),null);
var inst_72065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72066 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72068 = [inst_72057];
var inst_72069 = (new cljs.core.PersistentVector(null,1,(5),inst_72067,inst_72068,null));
var inst_72070 = ["query",inst_72069,inst_72063];
var inst_72071 = cljs.core.PersistentHashMap.fromArrays(inst_72066,inst_72070);
var inst_72072 = [inst_72071,inst_72064];
var inst_72073 = (new cljs.core.PersistentVector(null,2,(5),inst_72065,inst_72072,null));
var inst_72074 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72073);
var _ = (function (){var statearr_72084 = state_72079;
(statearr_72084[(4)] = cljs.core.rest((state_72079[(4)])));

return statearr_72084;
})();
var state_72079__$1 = (function (){var statearr_72085 = state_72079;
(statearr_72085[(8)] = inst_72074);

return statearr_72085;
})();
var statearr_72086_72221 = state_72079__$1;
(statearr_72086_72221[(2)] = inst_72063);

(statearr_72086_72221[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (6))){
var state_72079__$1 = state_72079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72079__$1,(9),query_map);
} else {
if((state_val_72080 === (3))){
var inst_72077 = (state_72079[(2)]);
var state_72079__$1 = state_72079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72079__$1,inst_72077);
} else {
if((state_val_72080 === (12))){
var inst_72057 = (state_72079[(7)]);
var inst_72057__$1 = (state_72079[(2)]);
var inst_72058 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72059 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_72058,inst_72057__$1);
var state_72079__$1 = (function (){var statearr_72087 = state_72079;
(statearr_72087[(7)] = inst_72057__$1);

return statearr_72087;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72079__$1,(13),inst_72059);
} else {
if((state_val_72080 === (2))){
var _ = (function (){var statearr_72088 = state_72079;
(statearr_72088[(4)] = cljs.core.cons((5),(state_72079[(4)])));

return statearr_72088;
})();
var inst_72044 = fluree.db.util.async.channel_QMARK_(query_map);
var state_72079__$1 = state_72079;
if(inst_72044){
var statearr_72089_72222 = state_72079__$1;
(statearr_72089_72222[(1)] = (6));

} else {
var statearr_72090_72223 = state_72079__$1;
(statearr_72090_72223[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (11))){
var inst_72051 = (state_72079[(9)]);
var state_72079__$1 = state_72079;
var statearr_72092_72224 = state_72079__$1;
(statearr_72092_72224[(2)] = inst_72051);

(statearr_72092_72224[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (9))){
var inst_72047 = (state_72079[(2)]);
var inst_72048 = fluree.db.util.async.throw_err(inst_72047);
var state_72079__$1 = state_72079;
var statearr_72093_72225 = state_72079__$1;
(statearr_72093_72225[(2)] = inst_72048);

(statearr_72093_72225[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (5))){
var _ = (function (){var statearr_72094 = state_72079;
(statearr_72094[(4)] = cljs.core.rest((state_72079[(4)])));

return statearr_72094;
})();
var state_72079__$1 = state_72079;
var ex72091 = (state_72079__$1[(2)]);
var statearr_72095_72226 = state_72079__$1;
(statearr_72095_72226[(5)] = ex72091);


if((ex72091 instanceof Error)){
var statearr_72096_72227 = state_72079__$1;
(statearr_72096_72227[(1)] = (4));

(statearr_72096_72227[(5)] = null);

} else {
throw ex72091;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (10))){
var inst_72051 = (state_72079[(9)]);
var inst_72054 = fluree.db.util.json.parse(inst_72051);
var state_72079__$1 = state_72079;
var statearr_72097_72228 = state_72079__$1;
(statearr_72097_72228[(2)] = inst_72054);

(statearr_72097_72228[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72080 === (8))){
var inst_72051 = (state_72079[(9)]);
var inst_72051__$1 = (state_72079[(2)]);
var inst_72052 = typeof inst_72051__$1 === 'string';
var state_72079__$1 = (function (){var statearr_72098 = state_72079;
(statearr_72098[(9)] = inst_72051__$1);

return statearr_72098;
})();
if(cljs.core.truth_(inst_72052)){
var statearr_72099_72229 = state_72079__$1;
(statearr_72099_72229[(1)] = (10));

} else {
var statearr_72100_72230 = state_72079__$1;
(statearr_72100_72230[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72101 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72101[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72101[(1)] = (1));

return statearr_72101;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72079){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72079);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72102){var ex__13886__auto__ = e72102;
var statearr_72103_72231 = state_72079;
(statearr_72103_72231[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72079[(4)]))){
var statearr_72104_72232 = state_72079;
(statearr_72104_72232[(1)] = cljs.core.first((state_72079[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72233 = state_72079;
state_72079 = G__72233;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72105 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72105[(6)] = c__13957__auto__);

return statearr_72105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72176){
var state_val_72177 = (state_72176[(1)]);
if((state_val_72177 === (7))){
var state_72176__$1 = state_72176;
var statearr_72178_72234 = state_72176__$1;
(statearr_72178_72234[(2)] = select);

(statearr_72178_72234[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (20))){
var inst_72146 = (state_72176[(2)]);
var inst_72147 = fluree.db.util.async.channel_QMARK_(limit);
var state_72176__$1 = (function (){var statearr_72179 = state_72176;
(statearr_72179[(7)] = inst_72146);

return statearr_72179;
})();
if(inst_72147){
var statearr_72180_72235 = state_72176__$1;
(statearr_72180_72235[(1)] = (22));

} else {
var statearr_72181_72236 = state_72176__$1;
(statearr_72181_72236[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (1))){
var state_72176__$1 = state_72176;
var statearr_72182_72237 = state_72176__$1;
(statearr_72182_72237[(2)] = null);

(statearr_72182_72237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (24))){
var inst_72146 = (state_72176[(7)]);
var inst_72130 = (state_72176[(8)]);
var inst_72138 = (state_72176[(9)]);
var inst_72122 = (state_72176[(10)]);
var inst_72154 = (state_72176[(2)]);
var inst_72155 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72156 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_72155,inst_72122,inst_72130,inst_72138,inst_72146,inst_72154);
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(26),inst_72156);
} else {
if((state_val_72177 === (4))){
var inst_72106 = (state_72176[(2)]);
var state_72176__$1 = state_72176;
var statearr_72183_72238 = state_72176__$1;
(statearr_72183_72238[(2)] = inst_72106);

(statearr_72183_72238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (15))){
var state_72176__$1 = state_72176;
var statearr_72184_72239 = state_72176__$1;
(statearr_72184_72239[(2)] = where);

(statearr_72184_72239[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (21))){
var inst_72142 = (state_72176[(2)]);
var inst_72143 = fluree.db.util.async.throw_err(inst_72142);
var state_72176__$1 = state_72176;
var statearr_72185_72240 = state_72176__$1;
(statearr_72185_72240[(2)] = inst_72143);

(statearr_72185_72240[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (13))){
var inst_72126 = (state_72176[(2)]);
var inst_72127 = fluree.db.util.async.throw_err(inst_72126);
var state_72176__$1 = state_72176;
var statearr_72186_72241 = state_72176__$1;
(statearr_72186_72241[(2)] = inst_72127);

(statearr_72186_72241[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (22))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(25),limit);
} else {
if((state_val_72177 === (6))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(9),select);
} else {
if((state_val_72177 === (25))){
var inst_72150 = (state_72176[(2)]);
var inst_72151 = fluree.db.util.async.throw_err(inst_72150);
var state_72176__$1 = state_72176;
var statearr_72187_72242 = state_72176__$1;
(statearr_72187_72242[(2)] = inst_72151);

(statearr_72187_72242[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (17))){
var inst_72134 = (state_72176[(2)]);
var inst_72135 = fluree.db.util.async.throw_err(inst_72134);
var state_72176__$1 = state_72176;
var statearr_72188_72243 = state_72176__$1;
(statearr_72188_72243[(2)] = inst_72135);

(statearr_72188_72243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (3))){
var inst_72174 = (state_72176[(2)]);
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72176__$1,inst_72174);
} else {
if((state_val_72177 === (12))){
var inst_72130 = (state_72176[(2)]);
var inst_72131 = fluree.db.util.async.channel_QMARK_(where);
var state_72176__$1 = (function (){var statearr_72189 = state_72176;
(statearr_72189[(8)] = inst_72130);

return statearr_72189;
})();
if(inst_72131){
var statearr_72190_72244 = state_72176__$1;
(statearr_72190_72244[(1)] = (14));

} else {
var statearr_72191_72245 = state_72176__$1;
(statearr_72191_72245[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (2))){
var _ = (function (){var statearr_72192 = state_72176;
(statearr_72192[(4)] = cljs.core.cons((5),(state_72176[(4)])));

return statearr_72192;
})();
var inst_72115 = fluree.db.util.async.channel_QMARK_(select);
var state_72176__$1 = state_72176;
if(inst_72115){
var statearr_72193_72246 = state_72176__$1;
(statearr_72193_72246[(1)] = (6));

} else {
var statearr_72194_72247 = state_72176__$1;
(statearr_72194_72247[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (23))){
var state_72176__$1 = state_72176;
var statearr_72195_72248 = state_72176__$1;
(statearr_72195_72248[(2)] = limit);

(statearr_72195_72248[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (19))){
var state_72176__$1 = state_72176;
var statearr_72196_72249 = state_72176__$1;
(statearr_72196_72249[(2)] = block);

(statearr_72196_72249[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (11))){
var state_72176__$1 = state_72176;
var statearr_72198_72250 = state_72176__$1;
(statearr_72198_72250[(2)] = from);

(statearr_72198_72250[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (9))){
var inst_72118 = (state_72176[(2)]);
var inst_72119 = fluree.db.util.async.throw_err(inst_72118);
var state_72176__$1 = state_72176;
var statearr_72199_72251 = state_72176__$1;
(statearr_72199_72251[(2)] = inst_72119);

(statearr_72199_72251[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (5))){
var _ = (function (){var statearr_72200 = state_72176;
(statearr_72200[(4)] = cljs.core.rest((state_72176[(4)])));

return statearr_72200;
})();
var state_72176__$1 = state_72176;
var ex72197 = (state_72176__$1[(2)]);
var statearr_72201_72252 = state_72176__$1;
(statearr_72201_72252[(5)] = ex72197);


if((ex72197 instanceof Error)){
var statearr_72202_72253 = state_72176__$1;
(statearr_72202_72253[(1)] = (4));

(statearr_72202_72253[(5)] = null);

} else {
throw ex72197;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (14))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(17),where);
} else {
if((state_val_72177 === (26))){
var inst_72146 = (state_72176[(7)]);
var inst_72130 = (state_72176[(8)]);
var inst_72138 = (state_72176[(9)]);
var inst_72122 = (state_72176[(10)]);
var inst_72158 = (state_72176[(2)]);
var inst_72159 = fluree.db.util.async.throw_err(inst_72158);
var inst_72160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72159,(0),null);
var inst_72161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72159,(1),null);
var inst_72162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72163 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72165 = [inst_72122,inst_72130,inst_72138,inst_72146];
var inst_72166 = (new cljs.core.PersistentVector(null,4,(5),inst_72164,inst_72165,null));
var inst_72167 = ["query",inst_72166,inst_72160];
var inst_72168 = cljs.core.PersistentHashMap.fromArrays(inst_72163,inst_72167);
var inst_72169 = [inst_72168,inst_72161];
var inst_72170 = (new cljs.core.PersistentVector(null,2,(5),inst_72162,inst_72169,null));
var inst_72171 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72170);
var _ = (function (){var statearr_72203 = state_72176;
(statearr_72203[(4)] = cljs.core.rest((state_72176[(4)])));

return statearr_72203;
})();
var state_72176__$1 = (function (){var statearr_72204 = state_72176;
(statearr_72204[(11)] = inst_72171);

return statearr_72204;
})();
var statearr_72205_72254 = state_72176__$1;
(statearr_72205_72254[(2)] = inst_72160);

(statearr_72205_72254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (16))){
var inst_72138 = (state_72176[(2)]);
var inst_72139 = fluree.db.util.async.channel_QMARK_(block);
var state_72176__$1 = (function (){var statearr_72206 = state_72176;
(statearr_72206[(9)] = inst_72138);

return statearr_72206;
})();
if(inst_72139){
var statearr_72207_72255 = state_72176__$1;
(statearr_72207_72255[(1)] = (18));

} else {
var statearr_72208_72256 = state_72176__$1;
(statearr_72208_72256[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (10))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(13),from);
} else {
if((state_val_72177 === (18))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(21),block);
} else {
if((state_val_72177 === (8))){
var inst_72122 = (state_72176[(2)]);
var inst_72123 = fluree.db.util.async.channel_QMARK_(from);
var state_72176__$1 = (function (){var statearr_72209 = state_72176;
(statearr_72209[(10)] = inst_72122);

return statearr_72209;
})();
if(inst_72123){
var statearr_72210_72257 = state_72176__$1;
(statearr_72210_72257[(1)] = (10));

} else {
var statearr_72211_72258 = state_72176__$1;
(statearr_72211_72258[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72212 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72212[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72212[(1)] = (1));

return statearr_72212;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72176){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72176);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72213){var ex__13886__auto__ = e72213;
var statearr_72214_72259 = state_72176;
(statearr_72214_72259[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72176[(4)]))){
var statearr_72215_72260 = state_72176;
(statearr_72215_72260[(1)] = cljs.core.first((state_72176[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72261 = state_72176;
state_72176 = G__72261;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72176){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72216 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72216[(6)] = c__13957__auto__);

return statearr_72216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72317){
var state_val_72318 = (state_72317[(1)]);
if((state_val_72318 === (7))){
var state_72317__$1 = state_72317;
var statearr_72319_72350 = state_72317__$1;
(statearr_72319_72350[(2)] = startSubject);

(statearr_72319_72350[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (1))){
var state_72317__$1 = state_72317;
var statearr_72320_72351 = state_72317__$1;
(statearr_72320_72351[(2)] = null);

(statearr_72320_72351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (4))){
var inst_72262 = (state_72317[(2)]);
var state_72317__$1 = state_72317;
var statearr_72321_72352 = state_72317__$1;
(statearr_72321_72352[(2)] = inst_72262);

(statearr_72321_72352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (15))){
var inst_72294 = (state_72317[(2)]);
var inst_72295 = fluree.db.util.async.throw_err(inst_72294);
var inst_72296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72295,(0),null);
var inst_72297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72295,(1),null);
var inst_72298 = cljs.core.empty_QMARK_(inst_72296);
var state_72317__$1 = (function (){var statearr_72322 = state_72317;
(statearr_72322[(7)] = inst_72297);

return statearr_72322;
})();
if(inst_72298){
var statearr_72323_72353 = state_72317__$1;
(statearr_72323_72353[(1)] = (16));

} else {
var statearr_72324_72354 = state_72317__$1;
(statearr_72324_72354[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (13))){
var inst_72278 = (state_72317[(8)]);
var inst_72290 = (state_72317[(9)]);
var inst_72282 = (state_72317[(10)]);
var inst_72290__$1 = (state_72317[(2)]);
var inst_72291 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72292 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_72291,inst_72278,inst_72282,inst_72290__$1);
var state_72317__$1 = (function (){var statearr_72325 = state_72317;
(statearr_72325[(9)] = inst_72290__$1);

return statearr_72325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72317__$1,(15),inst_72292);
} else {
if((state_val_72318 === (6))){
var state_72317__$1 = state_72317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72317__$1,(9),startSubject);
} else {
if((state_val_72318 === (17))){
var state_72317__$1 = state_72317;
var statearr_72326_72355 = state_72317__$1;
(statearr_72326_72355[(2)] = true);

(statearr_72326_72355[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (3))){
var inst_72315 = (state_72317[(2)]);
var state_72317__$1 = state_72317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72317__$1,inst_72315);
} else {
if((state_val_72318 === (12))){
var state_72317__$1 = state_72317;
var statearr_72327_72356 = state_72317__$1;
(statearr_72327_72356[(2)] = endSubject);

(statearr_72327_72356[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (2))){
var _ = (function (){var statearr_72328 = state_72317;
(statearr_72328[(4)] = cljs.core.cons((5),(state_72317[(4)])));

return statearr_72328;
})();
var inst_72271 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_72317__$1 = state_72317;
if(inst_72271){
var statearr_72329_72357 = state_72317__$1;
(statearr_72329_72357[(1)] = (6));

} else {
var statearr_72330_72358 = state_72317__$1;
(statearr_72330_72358[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (11))){
var state_72317__$1 = state_72317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72317__$1,(14),endSubject);
} else {
if((state_val_72318 === (9))){
var inst_72274 = (state_72317[(2)]);
var inst_72275 = fluree.db.util.async.throw_err(inst_72274);
var state_72317__$1 = state_72317;
var statearr_72332_72359 = state_72317__$1;
(statearr_72332_72359[(2)] = inst_72275);

(statearr_72332_72359[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (5))){
var _ = (function (){var statearr_72333 = state_72317;
(statearr_72333[(4)] = cljs.core.rest((state_72317[(4)])));

return statearr_72333;
})();
var state_72317__$1 = state_72317;
var ex72331 = (state_72317__$1[(2)]);
var statearr_72334_72360 = state_72317__$1;
(statearr_72334_72360[(5)] = ex72331);


if((ex72331 instanceof Error)){
var statearr_72335_72361 = state_72317__$1;
(statearr_72335_72361[(1)] = (4));

(statearr_72335_72361[(5)] = null);

} else {
throw ex72331;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (14))){
var inst_72286 = (state_72317[(2)]);
var inst_72287 = fluree.db.util.async.throw_err(inst_72286);
var state_72317__$1 = state_72317;
var statearr_72336_72362 = state_72317__$1;
(statearr_72336_72362[(2)] = inst_72287);

(statearr_72336_72362[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (16))){
var state_72317__$1 = state_72317;
var statearr_72337_72363 = state_72317__$1;
(statearr_72337_72363[(2)] = false);

(statearr_72337_72363[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (10))){
var inst_72281 = (state_72317[(2)]);
var inst_72282 = fluree.db.util.async.throw_err(inst_72281);
var inst_72283 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_72317__$1 = (function (){var statearr_72338 = state_72317;
(statearr_72338[(10)] = inst_72282);

return statearr_72338;
})();
if(inst_72283){
var statearr_72339_72364 = state_72317__$1;
(statearr_72339_72364[(1)] = (11));

} else {
var statearr_72340_72365 = state_72317__$1;
(statearr_72340_72365[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (18))){
var inst_72278 = (state_72317[(8)]);
var inst_72290 = (state_72317[(9)]);
var inst_72297 = (state_72317[(7)]);
var inst_72282 = (state_72317[(10)]);
var inst_72302 = (state_72317[(2)]);
var inst_72303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72304 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72306 = [inst_72278,inst_72282,inst_72290];
var inst_72307 = (new cljs.core.PersistentVector(null,3,(5),inst_72305,inst_72306,null));
var inst_72308 = ["relationship?",inst_72307,inst_72302];
var inst_72309 = cljs.core.PersistentHashMap.fromArrays(inst_72304,inst_72308);
var inst_72310 = [inst_72309,inst_72297];
var inst_72311 = (new cljs.core.PersistentVector(null,2,(5),inst_72303,inst_72310,null));
var inst_72312 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72311);
var _ = (function (){var statearr_72341 = state_72317;
(statearr_72341[(4)] = cljs.core.rest((state_72317[(4)])));

return statearr_72341;
})();
var state_72317__$1 = (function (){var statearr_72342 = state_72317;
(statearr_72342[(11)] = inst_72312);

return statearr_72342;
})();
var statearr_72343_72366 = state_72317__$1;
(statearr_72343_72366[(2)] = inst_72302);

(statearr_72343_72366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72318 === (8))){
var inst_72278 = (state_72317[(2)]);
var inst_72279 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_72317__$1 = (function (){var statearr_72344 = state_72317;
(statearr_72344[(8)] = inst_72278);

return statearr_72344;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72317__$1,(10),inst_72279);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_72345 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72345[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__);

(statearr_72345[(1)] = (1));

return statearr_72345;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1 = (function (state_72317){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72317);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72346){var ex__13886__auto__ = e72346;
var statearr_72347_72367 = state_72317;
(statearr_72347_72367[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72317[(4)]))){
var statearr_72348_72368 = state_72317;
(statearr_72348_72368[(1)] = cljs.core.first((state_72317[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72369 = state_72317;
state_72317 = G__72369;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__ = function(state_72317){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1.call(this,state_72317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72349 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72349[(6)] = c__13957__auto__);

return statearr_72349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72406){
var state_val_72407 = (state_72406[(1)]);
if((state_val_72407 === (7))){
var state_72406__$1 = state_72406;
var statearr_72408_72428 = state_72406__$1;
(statearr_72408_72428[(2)] = pred_name);

(statearr_72408_72428[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (1))){
var state_72406__$1 = state_72406;
var statearr_72409_72429 = state_72406__$1;
(statearr_72409_72429[(2)] = null);

(statearr_72409_72429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (4))){
var inst_72370 = (state_72406[(2)]);
var state_72406__$1 = state_72406;
var statearr_72410_72430 = state_72406__$1;
(statearr_72410_72430[(2)] = inst_72370);

(statearr_72410_72430[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (6))){
var state_72406__$1 = state_72406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72406__$1,(9),pred_name);
} else {
if((state_val_72407 === (3))){
var inst_72404 = (state_72406[(2)]);
var state_72406__$1 = state_72406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72406__$1,inst_72404);
} else {
if((state_val_72407 === (2))){
var _ = (function (){var statearr_72412 = state_72406;
(statearr_72412[(4)] = cljs.core.cons((5),(state_72406[(4)])));

return statearr_72412;
})();
var inst_72379 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_72406__$1 = state_72406;
if(inst_72379){
var statearr_72413_72431 = state_72406__$1;
(statearr_72413_72431[(1)] = (6));

} else {
var statearr_72414_72432 = state_72406__$1;
(statearr_72414_72432[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (9))){
var inst_72382 = (state_72406[(2)]);
var inst_72383 = fluree.db.util.async.throw_err(inst_72382);
var state_72406__$1 = state_72406;
var statearr_72415_72433 = state_72406__$1;
(statearr_72415_72433[(2)] = inst_72383);

(statearr_72415_72433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (5))){
var _ = (function (){var statearr_72416 = state_72406;
(statearr_72416[(4)] = cljs.core.rest((state_72406[(4)])));

return statearr_72416;
})();
var state_72406__$1 = state_72406;
var ex72411 = (state_72406__$1[(2)]);
var statearr_72417_72434 = state_72406__$1;
(statearr_72417_72434[(5)] = ex72411);


if((ex72411 instanceof Error)){
var statearr_72418_72435 = state_72406__$1;
(statearr_72418_72435[(1)] = (4));

(statearr_72418_72435[(5)] = null);

} else {
throw ex72411;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (10))){
var inst_72386 = (state_72406[(7)]);
var inst_72390 = (state_72406[(2)]);
var inst_72391 = fluree.db.util.async.throw_err(inst_72390);
var inst_72392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72391,(0),null);
var inst_72393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72391,(1),null);
var inst_72394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72395 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72396 = ["max-pred-val",inst_72386,inst_72392];
var inst_72397 = cljs.core.PersistentHashMap.fromArrays(inst_72395,inst_72396);
var inst_72398 = (inst_72393 + (10));
var inst_72399 = [inst_72397,inst_72398];
var inst_72400 = (new cljs.core.PersistentVector(null,2,(5),inst_72394,inst_72399,null));
var inst_72401 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72400);
var _ = (function (){var statearr_72419 = state_72406;
(statearr_72419[(4)] = cljs.core.rest((state_72406[(4)])));

return statearr_72419;
})();
var state_72406__$1 = (function (){var statearr_72420 = state_72406;
(statearr_72420[(8)] = inst_72401);

return statearr_72420;
})();
var statearr_72421_72436 = state_72406__$1;
(statearr_72421_72436[(2)] = inst_72392);

(statearr_72421_72436[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (8))){
var inst_72386 = (state_72406[(7)]);
var inst_72386__$1 = (state_72406[(2)]);
var inst_72387 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72388 = fluree.db.dbfunctions.internal.max_pred_val(inst_72387,inst_72386__$1,null);
var state_72406__$1 = (function (){var statearr_72422 = state_72406;
(statearr_72422[(7)] = inst_72386__$1);

return statearr_72422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72406__$1,(10),inst_72388);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0 = (function (){
var statearr_72423 = [null,null,null,null,null,null,null,null,null];
(statearr_72423[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__);

(statearr_72423[(1)] = (1));

return statearr_72423;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1 = (function (state_72406){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72406);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72424){var ex__13886__auto__ = e72424;
var statearr_72425_72437 = state_72406;
(statearr_72425_72437[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72406[(4)]))){
var statearr_72426_72438 = state_72406;
(statearr_72426_72438[(1)] = cljs.core.first((state_72406[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72439 = state_72406;
state_72406 = G__72439;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__ = function(state_72406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1.call(this,state_72406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72427 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72427[(6)] = c__13957__auto__);

return statearr_72427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72466){
var state_val_72467 = (state_72466[(1)]);
if((state_val_72467 === (7))){
var state_72466__$1 = state_72466;
var statearr_72468_72487 = state_72466__$1;
(statearr_72468_72487[(2)] = n);

(statearr_72468_72487[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (1))){
var state_72466__$1 = state_72466;
var statearr_72469_72488 = state_72466__$1;
(statearr_72469_72488[(2)] = null);

(statearr_72469_72488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (4))){
var inst_72440 = (state_72466[(2)]);
var state_72466__$1 = state_72466;
var statearr_72470_72489 = state_72466__$1;
(statearr_72470_72489[(2)] = inst_72440);

(statearr_72470_72489[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (6))){
var state_72466__$1 = state_72466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72466__$1,(9),n);
} else {
if((state_val_72467 === (3))){
var inst_72464 = (state_72466[(2)]);
var state_72466__$1 = state_72466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72466__$1,inst_72464);
} else {
if((state_val_72467 === (2))){
var _ = (function (){var statearr_72472 = state_72466;
(statearr_72472[(4)] = cljs.core.cons((5),(state_72466[(4)])));

return statearr_72472;
})();
var inst_72446 = fluree.db.util.async.channel_QMARK_(n);
var state_72466__$1 = state_72466;
if(inst_72446){
var statearr_72473_72490 = state_72466__$1;
(statearr_72473_72490[(1)] = (6));

} else {
var statearr_72474_72491 = state_72466__$1;
(statearr_72474_72491[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (9))){
var inst_72449 = (state_72466[(2)]);
var inst_72450 = fluree.db.util.async.throw_err(inst_72449);
var state_72466__$1 = state_72466;
var statearr_72475_72492 = state_72466__$1;
(statearr_72475_72492[(2)] = inst_72450);

(statearr_72475_72492[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (5))){
var _ = (function (){var statearr_72476 = state_72466;
(statearr_72476[(4)] = cljs.core.rest((state_72466[(4)])));

return statearr_72476;
})();
var state_72466__$1 = state_72466;
var ex72471 = (state_72466__$1[(2)]);
var statearr_72477_72493 = state_72466__$1;
(statearr_72477_72493[(5)] = ex72471);


if((ex72471 instanceof Error)){
var statearr_72478_72494 = state_72466__$1;
(statearr_72478_72494[(1)] = (4));

(statearr_72478_72494[(5)] = null);

} else {
throw ex72471;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72467 === (8))){
var inst_72453 = (state_72466[(2)]);
var inst_72454 = fluree.db.dbfunctions.internal.inc(inst_72453);
var inst_72455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72456 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72457 = ["inc",inst_72453,inst_72454];
var inst_72458 = cljs.core.PersistentHashMap.fromArrays(inst_72456,inst_72457);
var inst_72459 = [inst_72458,(10)];
var inst_72460 = (new cljs.core.PersistentVector(null,2,(5),inst_72455,inst_72459,null));
var inst_72461 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72460);
var _ = (function (){var statearr_72479 = state_72466;
(statearr_72479[(4)] = cljs.core.rest((state_72466[(4)])));

return statearr_72479;
})();
var state_72466__$1 = (function (){var statearr_72480 = state_72466;
(statearr_72480[(7)] = inst_72461);

return statearr_72480;
})();
var statearr_72481_72495 = state_72466__$1;
(statearr_72481_72495[(2)] = inst_72454);

(statearr_72481_72495[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0 = (function (){
var statearr_72482 = [null,null,null,null,null,null,null,null];
(statearr_72482[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__);

(statearr_72482[(1)] = (1));

return statearr_72482;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1 = (function (state_72466){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72466);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72483){var ex__13886__auto__ = e72483;
var statearr_72484_72496 = state_72466;
(statearr_72484_72496[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72466[(4)]))){
var statearr_72485_72497 = state_72466;
(statearr_72485_72497[(1)] = cljs.core.first((state_72466[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72498 = state_72466;
state_72466 = G__72498;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__ = function(state_72466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1.call(this,state_72466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72486 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72486[(6)] = c__13957__auto__);

return statearr_72486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72525){
var state_val_72526 = (state_72525[(1)]);
if((state_val_72526 === (7))){
var state_72525__$1 = state_72525;
var statearr_72527_72546 = state_72525__$1;
(statearr_72527_72546[(2)] = n);

(statearr_72527_72546[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (1))){
var state_72525__$1 = state_72525;
var statearr_72528_72547 = state_72525__$1;
(statearr_72528_72547[(2)] = null);

(statearr_72528_72547[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (4))){
var inst_72499 = (state_72525[(2)]);
var state_72525__$1 = state_72525;
var statearr_72529_72548 = state_72525__$1;
(statearr_72529_72548[(2)] = inst_72499);

(statearr_72529_72548[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (6))){
var state_72525__$1 = state_72525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72525__$1,(9),n);
} else {
if((state_val_72526 === (3))){
var inst_72523 = (state_72525[(2)]);
var state_72525__$1 = state_72525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72525__$1,inst_72523);
} else {
if((state_val_72526 === (2))){
var _ = (function (){var statearr_72531 = state_72525;
(statearr_72531[(4)] = cljs.core.cons((5),(state_72525[(4)])));

return statearr_72531;
})();
var inst_72505 = fluree.db.util.async.channel_QMARK_(n);
var state_72525__$1 = state_72525;
if(inst_72505){
var statearr_72532_72549 = state_72525__$1;
(statearr_72532_72549[(1)] = (6));

} else {
var statearr_72533_72550 = state_72525__$1;
(statearr_72533_72550[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (9))){
var inst_72508 = (state_72525[(2)]);
var inst_72509 = fluree.db.util.async.throw_err(inst_72508);
var state_72525__$1 = state_72525;
var statearr_72534_72551 = state_72525__$1;
(statearr_72534_72551[(2)] = inst_72509);

(statearr_72534_72551[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (5))){
var _ = (function (){var statearr_72535 = state_72525;
(statearr_72535[(4)] = cljs.core.rest((state_72525[(4)])));

return statearr_72535;
})();
var state_72525__$1 = state_72525;
var ex72530 = (state_72525__$1[(2)]);
var statearr_72536_72552 = state_72525__$1;
(statearr_72536_72552[(5)] = ex72530);


if((ex72530 instanceof Error)){
var statearr_72537_72553 = state_72525__$1;
(statearr_72537_72553[(1)] = (4));

(statearr_72537_72553[(5)] = null);

} else {
throw ex72530;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72526 === (8))){
var inst_72512 = (state_72525[(2)]);
var inst_72513 = fluree.db.dbfunctions.internal.dec(inst_72512);
var inst_72514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72515 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72516 = ["dec",inst_72512,inst_72513];
var inst_72517 = cljs.core.PersistentHashMap.fromArrays(inst_72515,inst_72516);
var inst_72518 = [inst_72517,(10)];
var inst_72519 = (new cljs.core.PersistentVector(null,2,(5),inst_72514,inst_72518,null));
var inst_72520 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72519);
var _ = (function (){var statearr_72538 = state_72525;
(statearr_72538[(4)] = cljs.core.rest((state_72525[(4)])));

return statearr_72538;
})();
var state_72525__$1 = (function (){var statearr_72539 = state_72525;
(statearr_72539[(7)] = inst_72520);

return statearr_72539;
})();
var statearr_72540_72554 = state_72525__$1;
(statearr_72540_72554[(2)] = inst_72513);

(statearr_72540_72554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0 = (function (){
var statearr_72541 = [null,null,null,null,null,null,null,null];
(statearr_72541[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__);

(statearr_72541[(1)] = (1));

return statearr_72541;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1 = (function (state_72525){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72525);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72542){var ex__13886__auto__ = e72542;
var statearr_72543_72555 = state_72525;
(statearr_72543_72555[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72525[(4)]))){
var statearr_72544_72556 = state_72525;
(statearr_72544_72556[(1)] = cljs.core.first((state_72525[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72557 = state_72525;
state_72525 = G__72557;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__ = function(state_72525){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1.call(this,state_72525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72545 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72545[(6)] = c__13957__auto__);

return statearr_72545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72607 = arguments.length;
var i__4772__auto___72608 = (0);
while(true){
if((i__4772__auto___72608 < len__4771__auto___72607)){
args__4777__auto__.push((arguments[i__4772__auto___72608]));

var G__72609 = (i__4772__auto___72608 + (1));
i__4772__auto___72608 = G__72609;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72590){
var state_val_72591 = (state_72590[(1)]);
if((state_val_72591 === (1))){
var state_72590__$1 = state_72590;
var statearr_72592_72610 = state_72590__$1;
(statearr_72592_72610[(2)] = null);

(statearr_72592_72610[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72591 === (2))){
var _ = (function (){var statearr_72593 = state_72590;
(statearr_72593[(4)] = cljs.core.cons((5),(state_72590[(4)])));

return statearr_72593;
})();
var inst_72566 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72590__$1 = state_72590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72590__$1,(6),inst_72566);
} else {
if((state_val_72591 === (3))){
var inst_72588 = (state_72590[(2)]);
var state_72590__$1 = state_72590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72590__$1,inst_72588);
} else {
if((state_val_72591 === (4))){
var inst_72560 = (state_72590[(2)]);
var state_72590__$1 = state_72590;
var statearr_72595_72611 = state_72590__$1;
(statearr_72595_72611[(2)] = inst_72560);

(statearr_72595_72611[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72591 === (5))){
var _ = (function (){var statearr_72596 = state_72590;
(statearr_72596[(4)] = cljs.core.rest((state_72590[(4)])));

return statearr_72596;
})();
var state_72590__$1 = state_72590;
var ex72594 = (state_72590__$1[(2)]);
var statearr_72597_72612 = state_72590__$1;
(statearr_72597_72612[(5)] = ex72594);


if((ex72594 instanceof Error)){
var statearr_72598_72613 = state_72590__$1;
(statearr_72598_72613[(1)] = (4));

(statearr_72598_72613[(5)] = null);

} else {
throw ex72594;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72591 === (6))){
var inst_72568 = (state_72590[(2)]);
var inst_72569 = fluree.db.util.async.throw_err(inst_72568);
var inst_72570 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_72569);
var inst_72571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72572 = [inst_72569];
var inst_72573 = (new cljs.core.PersistentVector(null,1,(5),inst_72571,inst_72572,null));
var inst_72574 = cljs.core.count(inst_72573);
var inst_72575 = ((9) + inst_72574);
var inst_72576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72577 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72579 = [inst_72569];
var inst_72580 = (new cljs.core.PersistentVector(null,1,(5),inst_72578,inst_72579,null));
var inst_72581 = ["+",inst_72580,inst_72570];
var inst_72582 = cljs.core.PersistentHashMap.fromArrays(inst_72577,inst_72581);
var inst_72583 = [inst_72582,inst_72575];
var inst_72584 = (new cljs.core.PersistentVector(null,2,(5),inst_72576,inst_72583,null));
var inst_72585 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72584);
var _ = (function (){var statearr_72599 = state_72590;
(statearr_72599[(4)] = cljs.core.rest((state_72590[(4)])));

return statearr_72599;
})();
var state_72590__$1 = (function (){var statearr_72600 = state_72590;
(statearr_72600[(7)] = inst_72585);

return statearr_72600;
})();
var statearr_72601_72614 = state_72590__$1;
(statearr_72601_72614[(2)] = inst_72570);

(statearr_72601_72614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72602 = [null,null,null,null,null,null,null,null];
(statearr_72602[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72602[(1)] = (1));

return statearr_72602;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72590){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72590);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72603){var ex__13886__auto__ = e72603;
var statearr_72604_72615 = state_72590;
(statearr_72604_72615[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72590[(4)]))){
var statearr_72605_72616 = state_72590;
(statearr_72605_72616[(1)] = cljs.core.first((state_72590[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72617 = state_72590;
state_72590 = G__72617;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72590){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72606 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72606[(6)] = c__13957__auto__);

return statearr_72606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq72558){
var G__72559 = cljs.core.first(seq72558);
var seq72558__$1 = cljs.core.next(seq72558);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72559,seq72558__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72667 = arguments.length;
var i__4772__auto___72668 = (0);
while(true){
if((i__4772__auto___72668 < len__4771__auto___72667)){
args__4777__auto__.push((arguments[i__4772__auto___72668]));

var G__72669 = (i__4772__auto___72668 + (1));
i__4772__auto___72668 = G__72669;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72650){
var state_val_72651 = (state_72650[(1)]);
if((state_val_72651 === (1))){
var state_72650__$1 = state_72650;
var statearr_72652_72670 = state_72650__$1;
(statearr_72652_72670[(2)] = null);

(statearr_72652_72670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72651 === (2))){
var _ = (function (){var statearr_72653 = state_72650;
(statearr_72653[(4)] = cljs.core.cons((5),(state_72650[(4)])));

return statearr_72653;
})();
var inst_72626 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72650__$1 = state_72650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72650__$1,(6),inst_72626);
} else {
if((state_val_72651 === (3))){
var inst_72648 = (state_72650[(2)]);
var state_72650__$1 = state_72650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72650__$1,inst_72648);
} else {
if((state_val_72651 === (4))){
var inst_72620 = (state_72650[(2)]);
var state_72650__$1 = state_72650;
var statearr_72655_72671 = state_72650__$1;
(statearr_72655_72671[(2)] = inst_72620);

(statearr_72655_72671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72651 === (5))){
var _ = (function (){var statearr_72656 = state_72650;
(statearr_72656[(4)] = cljs.core.rest((state_72650[(4)])));

return statearr_72656;
})();
var state_72650__$1 = state_72650;
var ex72654 = (state_72650__$1[(2)]);
var statearr_72657_72672 = state_72650__$1;
(statearr_72657_72672[(5)] = ex72654);


if((ex72654 instanceof Error)){
var statearr_72658_72673 = state_72650__$1;
(statearr_72658_72673[(1)] = (4));

(statearr_72658_72673[(5)] = null);

} else {
throw ex72654;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72651 === (6))){
var inst_72628 = (state_72650[(2)]);
var inst_72629 = fluree.db.util.async.throw_err(inst_72628);
var inst_72630 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_72629);
var inst_72631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72632 = [inst_72629];
var inst_72633 = (new cljs.core.PersistentVector(null,1,(5),inst_72631,inst_72632,null));
var inst_72634 = cljs.core.count(inst_72633);
var inst_72635 = ((9) + inst_72634);
var inst_72636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72637 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72639 = [inst_72629];
var inst_72640 = (new cljs.core.PersistentVector(null,1,(5),inst_72638,inst_72639,null));
var inst_72641 = ["-",inst_72640,inst_72630];
var inst_72642 = cljs.core.PersistentHashMap.fromArrays(inst_72637,inst_72641);
var inst_72643 = [inst_72642,inst_72635];
var inst_72644 = (new cljs.core.PersistentVector(null,2,(5),inst_72636,inst_72643,null));
var inst_72645 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72644);
var _ = (function (){var statearr_72659 = state_72650;
(statearr_72659[(4)] = cljs.core.rest((state_72650[(4)])));

return statearr_72659;
})();
var state_72650__$1 = (function (){var statearr_72660 = state_72650;
(statearr_72660[(7)] = inst_72645);

return statearr_72660;
})();
var statearr_72661_72674 = state_72650__$1;
(statearr_72661_72674[(2)] = inst_72630);

(statearr_72661_72674[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72662 = [null,null,null,null,null,null,null,null];
(statearr_72662[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72662[(1)] = (1));

return statearr_72662;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72650){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72650);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72663){var ex__13886__auto__ = e72663;
var statearr_72664_72675 = state_72650;
(statearr_72664_72675[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72650[(4)]))){
var statearr_72665_72676 = state_72650;
(statearr_72665_72676[(1)] = cljs.core.first((state_72650[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72677 = state_72650;
state_72650 = G__72677;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72650){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72666 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72666[(6)] = c__13957__auto__);

return statearr_72666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq72618){
var G__72619 = cljs.core.first(seq72618);
var seq72618__$1 = cljs.core.next(seq72618);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72619,seq72618__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72727 = arguments.length;
var i__4772__auto___72728 = (0);
while(true){
if((i__4772__auto___72728 < len__4771__auto___72727)){
args__4777__auto__.push((arguments[i__4772__auto___72728]));

var G__72729 = (i__4772__auto___72728 + (1));
i__4772__auto___72728 = G__72729;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72710){
var state_val_72711 = (state_72710[(1)]);
if((state_val_72711 === (1))){
var state_72710__$1 = state_72710;
var statearr_72712_72730 = state_72710__$1;
(statearr_72712_72730[(2)] = null);

(statearr_72712_72730[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72711 === (2))){
var _ = (function (){var statearr_72713 = state_72710;
(statearr_72713[(4)] = cljs.core.cons((5),(state_72710[(4)])));

return statearr_72713;
})();
var inst_72686 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72710__$1 = state_72710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72710__$1,(6),inst_72686);
} else {
if((state_val_72711 === (3))){
var inst_72708 = (state_72710[(2)]);
var state_72710__$1 = state_72710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72710__$1,inst_72708);
} else {
if((state_val_72711 === (4))){
var inst_72680 = (state_72710[(2)]);
var state_72710__$1 = state_72710;
var statearr_72715_72731 = state_72710__$1;
(statearr_72715_72731[(2)] = inst_72680);

(statearr_72715_72731[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72711 === (5))){
var _ = (function (){var statearr_72716 = state_72710;
(statearr_72716[(4)] = cljs.core.rest((state_72710[(4)])));

return statearr_72716;
})();
var state_72710__$1 = state_72710;
var ex72714 = (state_72710__$1[(2)]);
var statearr_72717_72732 = state_72710__$1;
(statearr_72717_72732[(5)] = ex72714);


if((ex72714 instanceof Error)){
var statearr_72718_72733 = state_72710__$1;
(statearr_72718_72733[(1)] = (4));

(statearr_72718_72733[(5)] = null);

} else {
throw ex72714;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72711 === (6))){
var inst_72688 = (state_72710[(2)]);
var inst_72689 = fluree.db.util.async.throw_err(inst_72688);
var inst_72690 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_72689);
var inst_72691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72692 = [inst_72689];
var inst_72693 = (new cljs.core.PersistentVector(null,1,(5),inst_72691,inst_72692,null));
var inst_72694 = cljs.core.count(inst_72693);
var inst_72695 = ((9) + inst_72694);
var inst_72696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72697 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72699 = [inst_72689];
var inst_72700 = (new cljs.core.PersistentVector(null,1,(5),inst_72698,inst_72699,null));
var inst_72701 = ["*",inst_72700,inst_72690];
var inst_72702 = cljs.core.PersistentHashMap.fromArrays(inst_72697,inst_72701);
var inst_72703 = [inst_72702,inst_72695];
var inst_72704 = (new cljs.core.PersistentVector(null,2,(5),inst_72696,inst_72703,null));
var inst_72705 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72704);
var _ = (function (){var statearr_72719 = state_72710;
(statearr_72719[(4)] = cljs.core.rest((state_72710[(4)])));

return statearr_72719;
})();
var state_72710__$1 = (function (){var statearr_72720 = state_72710;
(statearr_72720[(7)] = inst_72705);

return statearr_72720;
})();
var statearr_72721_72734 = state_72710__$1;
(statearr_72721_72734[(2)] = inst_72690);

(statearr_72721_72734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72722 = [null,null,null,null,null,null,null,null];
(statearr_72722[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72722[(1)] = (1));

return statearr_72722;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72710){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72710);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72723){var ex__13886__auto__ = e72723;
var statearr_72724_72735 = state_72710;
(statearr_72724_72735[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72710[(4)]))){
var statearr_72725_72736 = state_72710;
(statearr_72725_72736[(1)] = cljs.core.first((state_72710[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72737 = state_72710;
state_72710 = G__72737;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72726 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72726[(6)] = c__13957__auto__);

return statearr_72726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq72678){
var G__72679 = cljs.core.first(seq72678);
var seq72678__$1 = cljs.core.next(seq72678);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72679,seq72678__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72787 = arguments.length;
var i__4772__auto___72788 = (0);
while(true){
if((i__4772__auto___72788 < len__4771__auto___72787)){
args__4777__auto__.push((arguments[i__4772__auto___72788]));

var G__72789 = (i__4772__auto___72788 + (1));
i__4772__auto___72788 = G__72789;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72770){
var state_val_72771 = (state_72770[(1)]);
if((state_val_72771 === (1))){
var state_72770__$1 = state_72770;
var statearr_72772_72790 = state_72770__$1;
(statearr_72772_72790[(2)] = null);

(statearr_72772_72790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72771 === (2))){
var _ = (function (){var statearr_72773 = state_72770;
(statearr_72773[(4)] = cljs.core.cons((5),(state_72770[(4)])));

return statearr_72773;
})();
var inst_72746 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72770__$1 = state_72770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72770__$1,(6),inst_72746);
} else {
if((state_val_72771 === (3))){
var inst_72768 = (state_72770[(2)]);
var state_72770__$1 = state_72770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72770__$1,inst_72768);
} else {
if((state_val_72771 === (4))){
var inst_72740 = (state_72770[(2)]);
var state_72770__$1 = state_72770;
var statearr_72775_72791 = state_72770__$1;
(statearr_72775_72791[(2)] = inst_72740);

(statearr_72775_72791[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72771 === (5))){
var _ = (function (){var statearr_72776 = state_72770;
(statearr_72776[(4)] = cljs.core.rest((state_72770[(4)])));

return statearr_72776;
})();
var state_72770__$1 = state_72770;
var ex72774 = (state_72770__$1[(2)]);
var statearr_72777_72792 = state_72770__$1;
(statearr_72777_72792[(5)] = ex72774);


if((ex72774 instanceof Error)){
var statearr_72778_72793 = state_72770__$1;
(statearr_72778_72793[(1)] = (4));

(statearr_72778_72793[(5)] = null);

} else {
throw ex72774;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72771 === (6))){
var inst_72748 = (state_72770[(2)]);
var inst_72749 = fluree.db.util.async.throw_err(inst_72748);
var inst_72750 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_72749);
var inst_72751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72752 = [inst_72749];
var inst_72753 = (new cljs.core.PersistentVector(null,1,(5),inst_72751,inst_72752,null));
var inst_72754 = cljs.core.count(inst_72753);
var inst_72755 = ((9) + inst_72754);
var inst_72756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72757 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72759 = [inst_72749];
var inst_72760 = (new cljs.core.PersistentVector(null,1,(5),inst_72758,inst_72759,null));
var inst_72761 = ["/",inst_72760,inst_72750];
var inst_72762 = cljs.core.PersistentHashMap.fromArrays(inst_72757,inst_72761);
var inst_72763 = [inst_72762,inst_72755];
var inst_72764 = (new cljs.core.PersistentVector(null,2,(5),inst_72756,inst_72763,null));
var inst_72765 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72764);
var _ = (function (){var statearr_72779 = state_72770;
(statearr_72779[(4)] = cljs.core.rest((state_72770[(4)])));

return statearr_72779;
})();
var state_72770__$1 = (function (){var statearr_72780 = state_72770;
(statearr_72780[(7)] = inst_72765);

return statearr_72780;
})();
var statearr_72781_72794 = state_72770__$1;
(statearr_72781_72794[(2)] = inst_72750);

(statearr_72781_72794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72782 = [null,null,null,null,null,null,null,null];
(statearr_72782[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72782[(1)] = (1));

return statearr_72782;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72770){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72770);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72783){var ex__13886__auto__ = e72783;
var statearr_72784_72795 = state_72770;
(statearr_72784_72795[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72770[(4)]))){
var statearr_72785_72796 = state_72770;
(statearr_72785_72796[(1)] = cljs.core.first((state_72770[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72797 = state_72770;
state_72770 = G__72797;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72770){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72786 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72786[(6)] = c__13957__auto__);

return statearr_72786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq72738){
var G__72739 = cljs.core.first(seq72738);
var seq72738__$1 = cljs.core.next(seq72738);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72739,seq72738__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72835){
var state_val_72836 = (state_72835[(1)]);
if((state_val_72836 === (7))){
var state_72835__$1 = state_72835;
var statearr_72837_72861 = state_72835__$1;
(statearr_72837_72861[(2)] = n);

(statearr_72837_72861[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (1))){
var state_72835__$1 = state_72835;
var statearr_72838_72862 = state_72835__$1;
(statearr_72838_72862[(2)] = null);

(statearr_72838_72862[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (4))){
var inst_72798 = (state_72835[(2)]);
var state_72835__$1 = state_72835;
var statearr_72839_72863 = state_72835__$1;
(statearr_72839_72863[(2)] = inst_72798);

(statearr_72839_72863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (13))){
var inst_72815 = (state_72835[(2)]);
var inst_72816 = fluree.db.util.async.throw_err(inst_72815);
var state_72835__$1 = state_72835;
var statearr_72840_72864 = state_72835__$1;
(statearr_72840_72864[(2)] = inst_72816);

(statearr_72840_72864[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (6))){
var state_72835__$1 = state_72835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72835__$1,(9),n);
} else {
if((state_val_72836 === (3))){
var inst_72833 = (state_72835[(2)]);
var state_72835__$1 = state_72835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72835__$1,inst_72833);
} else {
if((state_val_72836 === (12))){
var inst_72811 = (state_72835[(7)]);
var inst_72819 = (state_72835[(2)]);
var inst_72820 = fluree.db.dbfunctions.internal.quot(inst_72811,inst_72819);
var inst_72821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72822 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72824 = [inst_72811,inst_72819];
var inst_72825 = (new cljs.core.PersistentVector(null,2,(5),inst_72823,inst_72824,null));
var inst_72826 = ["quot",inst_72825,inst_72820];
var inst_72827 = cljs.core.PersistentHashMap.fromArrays(inst_72822,inst_72826);
var inst_72828 = [inst_72827,(2)];
var inst_72829 = (new cljs.core.PersistentVector(null,2,(5),inst_72821,inst_72828,null));
var inst_72830 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72829);
var _ = (function (){var statearr_72841 = state_72835;
(statearr_72841[(4)] = cljs.core.rest((state_72835[(4)])));

return statearr_72841;
})();
var state_72835__$1 = (function (){var statearr_72842 = state_72835;
(statearr_72842[(8)] = inst_72830);

return statearr_72842;
})();
var statearr_72843_72865 = state_72835__$1;
(statearr_72843_72865[(2)] = inst_72820);

(statearr_72843_72865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (2))){
var _ = (function (){var statearr_72844 = state_72835;
(statearr_72844[(4)] = cljs.core.cons((5),(state_72835[(4)])));

return statearr_72844;
})();
var inst_72804 = fluree.db.util.async.channel_QMARK_(n);
var state_72835__$1 = state_72835;
if(inst_72804){
var statearr_72845_72866 = state_72835__$1;
(statearr_72845_72866[(1)] = (6));

} else {
var statearr_72846_72867 = state_72835__$1;
(statearr_72846_72867[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (11))){
var state_72835__$1 = state_72835;
var statearr_72848_72868 = state_72835__$1;
(statearr_72848_72868[(2)] = d);

(statearr_72848_72868[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (9))){
var inst_72807 = (state_72835[(2)]);
var inst_72808 = fluree.db.util.async.throw_err(inst_72807);
var state_72835__$1 = state_72835;
var statearr_72849_72869 = state_72835__$1;
(statearr_72849_72869[(2)] = inst_72808);

(statearr_72849_72869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (5))){
var _ = (function (){var statearr_72850 = state_72835;
(statearr_72850[(4)] = cljs.core.rest((state_72835[(4)])));

return statearr_72850;
})();
var state_72835__$1 = state_72835;
var ex72847 = (state_72835__$1[(2)]);
var statearr_72851_72870 = state_72835__$1;
(statearr_72851_72870[(5)] = ex72847);


if((ex72847 instanceof Error)){
var statearr_72852_72871 = state_72835__$1;
(statearr_72852_72871[(1)] = (4));

(statearr_72852_72871[(5)] = null);

} else {
throw ex72847;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72836 === (10))){
var state_72835__$1 = state_72835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72835__$1,(13),d);
} else {
if((state_val_72836 === (8))){
var inst_72811 = (state_72835[(2)]);
var inst_72812 = fluree.db.util.async.channel_QMARK_(d);
var state_72835__$1 = (function (){var statearr_72853 = state_72835;
(statearr_72853[(7)] = inst_72811);

return statearr_72853;
})();
if(inst_72812){
var statearr_72854_72872 = state_72835__$1;
(statearr_72854_72872[(1)] = (10));

} else {
var statearr_72855_72873 = state_72835__$1;
(statearr_72855_72873[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0 = (function (){
var statearr_72856 = [null,null,null,null,null,null,null,null,null];
(statearr_72856[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__);

(statearr_72856[(1)] = (1));

return statearr_72856;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1 = (function (state_72835){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72835);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72857){var ex__13886__auto__ = e72857;
var statearr_72858_72874 = state_72835;
(statearr_72858_72874[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72835[(4)]))){
var statearr_72859_72875 = state_72835;
(statearr_72859_72875[(1)] = cljs.core.first((state_72835[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72876 = state_72835;
state_72835 = G__72876;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__ = function(state_72835){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1.call(this,state_72835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72860 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72860[(6)] = c__13957__auto__);

return statearr_72860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72914){
var state_val_72915 = (state_72914[(1)]);
if((state_val_72915 === (7))){
var state_72914__$1 = state_72914;
var statearr_72916_72940 = state_72914__$1;
(statearr_72916_72940[(2)] = n);

(statearr_72916_72940[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (1))){
var state_72914__$1 = state_72914;
var statearr_72917_72941 = state_72914__$1;
(statearr_72917_72941[(2)] = null);

(statearr_72917_72941[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (4))){
var inst_72877 = (state_72914[(2)]);
var state_72914__$1 = state_72914;
var statearr_72918_72942 = state_72914__$1;
(statearr_72918_72942[(2)] = inst_72877);

(statearr_72918_72942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (13))){
var inst_72894 = (state_72914[(2)]);
var inst_72895 = fluree.db.util.async.throw_err(inst_72894);
var state_72914__$1 = state_72914;
var statearr_72919_72943 = state_72914__$1;
(statearr_72919_72943[(2)] = inst_72895);

(statearr_72919_72943[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (6))){
var state_72914__$1 = state_72914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72914__$1,(9),n);
} else {
if((state_val_72915 === (3))){
var inst_72912 = (state_72914[(2)]);
var state_72914__$1 = state_72914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72914__$1,inst_72912);
} else {
if((state_val_72915 === (12))){
var inst_72890 = (state_72914[(7)]);
var inst_72898 = (state_72914[(2)]);
var inst_72899 = fluree.db.dbfunctions.internal.mod(inst_72890,inst_72898);
var inst_72900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72901 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72903 = [inst_72890,inst_72898];
var inst_72904 = (new cljs.core.PersistentVector(null,2,(5),inst_72902,inst_72903,null));
var inst_72905 = ["mod",inst_72904,inst_72899];
var inst_72906 = cljs.core.PersistentHashMap.fromArrays(inst_72901,inst_72905);
var inst_72907 = [inst_72906,(2)];
var inst_72908 = (new cljs.core.PersistentVector(null,2,(5),inst_72900,inst_72907,null));
var inst_72909 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72908);
var _ = (function (){var statearr_72920 = state_72914;
(statearr_72920[(4)] = cljs.core.rest((state_72914[(4)])));

return statearr_72920;
})();
var state_72914__$1 = (function (){var statearr_72921 = state_72914;
(statearr_72921[(8)] = inst_72909);

return statearr_72921;
})();
var statearr_72922_72944 = state_72914__$1;
(statearr_72922_72944[(2)] = inst_72899);

(statearr_72922_72944[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (2))){
var _ = (function (){var statearr_72923 = state_72914;
(statearr_72923[(4)] = cljs.core.cons((5),(state_72914[(4)])));

return statearr_72923;
})();
var inst_72883 = fluree.db.util.async.channel_QMARK_(n);
var state_72914__$1 = state_72914;
if(inst_72883){
var statearr_72924_72945 = state_72914__$1;
(statearr_72924_72945[(1)] = (6));

} else {
var statearr_72925_72946 = state_72914__$1;
(statearr_72925_72946[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (11))){
var state_72914__$1 = state_72914;
var statearr_72927_72947 = state_72914__$1;
(statearr_72927_72947[(2)] = d);

(statearr_72927_72947[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (9))){
var inst_72886 = (state_72914[(2)]);
var inst_72887 = fluree.db.util.async.throw_err(inst_72886);
var state_72914__$1 = state_72914;
var statearr_72928_72948 = state_72914__$1;
(statearr_72928_72948[(2)] = inst_72887);

(statearr_72928_72948[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (5))){
var _ = (function (){var statearr_72929 = state_72914;
(statearr_72929[(4)] = cljs.core.rest((state_72914[(4)])));

return statearr_72929;
})();
var state_72914__$1 = state_72914;
var ex72926 = (state_72914__$1[(2)]);
var statearr_72930_72949 = state_72914__$1;
(statearr_72930_72949[(5)] = ex72926);


if((ex72926 instanceof Error)){
var statearr_72931_72950 = state_72914__$1;
(statearr_72931_72950[(1)] = (4));

(statearr_72931_72950[(5)] = null);

} else {
throw ex72926;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72915 === (10))){
var state_72914__$1 = state_72914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72914__$1,(13),d);
} else {
if((state_val_72915 === (8))){
var inst_72890 = (state_72914[(2)]);
var inst_72891 = fluree.db.util.async.channel_QMARK_(d);
var state_72914__$1 = (function (){var statearr_72932 = state_72914;
(statearr_72932[(7)] = inst_72890);

return statearr_72932;
})();
if(inst_72891){
var statearr_72933_72951 = state_72914__$1;
(statearr_72933_72951[(1)] = (10));

} else {
var statearr_72934_72952 = state_72914__$1;
(statearr_72934_72952[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0 = (function (){
var statearr_72935 = [null,null,null,null,null,null,null,null,null];
(statearr_72935[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__);

(statearr_72935[(1)] = (1));

return statearr_72935;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1 = (function (state_72914){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72914);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72936){var ex__13886__auto__ = e72936;
var statearr_72937_72953 = state_72914;
(statearr_72937_72953[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72914[(4)]))){
var statearr_72938_72954 = state_72914;
(statearr_72938_72954[(1)] = cljs.core.first((state_72914[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72955 = state_72914;
state_72914 = G__72955;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__ = function(state_72914){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1.call(this,state_72914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72939 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72939[(6)] = c__13957__auto__);

return statearr_72939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72993){
var state_val_72994 = (state_72993[(1)]);
if((state_val_72994 === (7))){
var state_72993__$1 = state_72993;
var statearr_72995_73019 = state_72993__$1;
(statearr_72995_73019[(2)] = n);

(statearr_72995_73019[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (1))){
var state_72993__$1 = state_72993;
var statearr_72996_73020 = state_72993__$1;
(statearr_72996_73020[(2)] = null);

(statearr_72996_73020[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (4))){
var inst_72956 = (state_72993[(2)]);
var state_72993__$1 = state_72993;
var statearr_72997_73021 = state_72993__$1;
(statearr_72997_73021[(2)] = inst_72956);

(statearr_72997_73021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (13))){
var inst_72973 = (state_72993[(2)]);
var inst_72974 = fluree.db.util.async.throw_err(inst_72973);
var state_72993__$1 = state_72993;
var statearr_72998_73022 = state_72993__$1;
(statearr_72998_73022[(2)] = inst_72974);

(statearr_72998_73022[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (6))){
var state_72993__$1 = state_72993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72993__$1,(9),n);
} else {
if((state_val_72994 === (3))){
var inst_72991 = (state_72993[(2)]);
var state_72993__$1 = state_72993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72993__$1,inst_72991);
} else {
if((state_val_72994 === (12))){
var inst_72969 = (state_72993[(7)]);
var inst_72977 = (state_72993[(2)]);
var inst_72978 = fluree.db.dbfunctions.internal.rem(inst_72969,inst_72977);
var inst_72979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72980 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72982 = [inst_72969,inst_72977];
var inst_72983 = (new cljs.core.PersistentVector(null,2,(5),inst_72981,inst_72982,null));
var inst_72984 = ["rem",inst_72983,inst_72978];
var inst_72985 = cljs.core.PersistentHashMap.fromArrays(inst_72980,inst_72984);
var inst_72986 = [inst_72985,(2)];
var inst_72987 = (new cljs.core.PersistentVector(null,2,(5),inst_72979,inst_72986,null));
var inst_72988 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72987);
var _ = (function (){var statearr_72999 = state_72993;
(statearr_72999[(4)] = cljs.core.rest((state_72993[(4)])));

return statearr_72999;
})();
var state_72993__$1 = (function (){var statearr_73000 = state_72993;
(statearr_73000[(8)] = inst_72988);

return statearr_73000;
})();
var statearr_73001_73023 = state_72993__$1;
(statearr_73001_73023[(2)] = inst_72978);

(statearr_73001_73023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (2))){
var _ = (function (){var statearr_73002 = state_72993;
(statearr_73002[(4)] = cljs.core.cons((5),(state_72993[(4)])));

return statearr_73002;
})();
var inst_72962 = fluree.db.util.async.channel_QMARK_(n);
var state_72993__$1 = state_72993;
if(inst_72962){
var statearr_73003_73024 = state_72993__$1;
(statearr_73003_73024[(1)] = (6));

} else {
var statearr_73004_73025 = state_72993__$1;
(statearr_73004_73025[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (11))){
var state_72993__$1 = state_72993;
var statearr_73006_73026 = state_72993__$1;
(statearr_73006_73026[(2)] = d);

(statearr_73006_73026[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (9))){
var inst_72965 = (state_72993[(2)]);
var inst_72966 = fluree.db.util.async.throw_err(inst_72965);
var state_72993__$1 = state_72993;
var statearr_73007_73027 = state_72993__$1;
(statearr_73007_73027[(2)] = inst_72966);

(statearr_73007_73027[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (5))){
var _ = (function (){var statearr_73008 = state_72993;
(statearr_73008[(4)] = cljs.core.rest((state_72993[(4)])));

return statearr_73008;
})();
var state_72993__$1 = state_72993;
var ex73005 = (state_72993__$1[(2)]);
var statearr_73009_73028 = state_72993__$1;
(statearr_73009_73028[(5)] = ex73005);


if((ex73005 instanceof Error)){
var statearr_73010_73029 = state_72993__$1;
(statearr_73010_73029[(1)] = (4));

(statearr_73010_73029[(5)] = null);

} else {
throw ex73005;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72994 === (10))){
var state_72993__$1 = state_72993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72993__$1,(13),d);
} else {
if((state_val_72994 === (8))){
var inst_72969 = (state_72993[(2)]);
var inst_72970 = fluree.db.util.async.channel_QMARK_(d);
var state_72993__$1 = (function (){var statearr_73011 = state_72993;
(statearr_73011[(7)] = inst_72969);

return statearr_73011;
})();
if(inst_72970){
var statearr_73012_73030 = state_72993__$1;
(statearr_73012_73030[(1)] = (10));

} else {
var statearr_73013_73031 = state_72993__$1;
(statearr_73013_73031[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0 = (function (){
var statearr_73014 = [null,null,null,null,null,null,null,null,null];
(statearr_73014[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__);

(statearr_73014[(1)] = (1));

return statearr_73014;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1 = (function (state_72993){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72993);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73015){var ex__13886__auto__ = e73015;
var statearr_73016_73032 = state_72993;
(statearr_73016_73032[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72993[(4)]))){
var statearr_73017_73033 = state_72993;
(statearr_73017_73033[(1)] = cljs.core.first((state_72993[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73034 = state_72993;
state_72993 = G__73034;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__ = function(state_72993){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1.call(this,state_72993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73018 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73018[(6)] = c__13957__auto__);

return statearr_73018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73061){
var state_val_73062 = (state_73061[(1)]);
if((state_val_73062 === (7))){
var state_73061__$1 = state_73061;
var statearr_73063_73082 = state_73061__$1;
(statearr_73063_73082[(2)] = x);

(statearr_73063_73082[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (1))){
var state_73061__$1 = state_73061;
var statearr_73064_73083 = state_73061__$1;
(statearr_73064_73083[(2)] = null);

(statearr_73064_73083[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (4))){
var inst_73035 = (state_73061[(2)]);
var state_73061__$1 = state_73061;
var statearr_73065_73084 = state_73061__$1;
(statearr_73065_73084[(2)] = inst_73035);

(statearr_73065_73084[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (6))){
var state_73061__$1 = state_73061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73061__$1,(9),x);
} else {
if((state_val_73062 === (3))){
var inst_73059 = (state_73061[(2)]);
var state_73061__$1 = state_73061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73061__$1,inst_73059);
} else {
if((state_val_73062 === (2))){
var _ = (function (){var statearr_73067 = state_73061;
(statearr_73067[(4)] = cljs.core.cons((5),(state_73061[(4)])));

return statearr_73067;
})();
var inst_73041 = fluree.db.util.async.channel_QMARK_(x);
var state_73061__$1 = state_73061;
if(inst_73041){
var statearr_73068_73085 = state_73061__$1;
(statearr_73068_73085[(1)] = (6));

} else {
var statearr_73069_73086 = state_73061__$1;
(statearr_73069_73086[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (9))){
var inst_73044 = (state_73061[(2)]);
var inst_73045 = fluree.db.util.async.throw_err(inst_73044);
var state_73061__$1 = state_73061;
var statearr_73070_73087 = state_73061__$1;
(statearr_73070_73087[(2)] = inst_73045);

(statearr_73070_73087[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (5))){
var _ = (function (){var statearr_73071 = state_73061;
(statearr_73071[(4)] = cljs.core.rest((state_73061[(4)])));

return statearr_73071;
})();
var state_73061__$1 = state_73061;
var ex73066 = (state_73061__$1[(2)]);
var statearr_73072_73088 = state_73061__$1;
(statearr_73072_73088[(5)] = ex73066);


if((ex73066 instanceof Error)){
var statearr_73073_73089 = state_73061__$1;
(statearr_73073_73089[(1)] = (4));

(statearr_73073_73089[(5)] = null);

} else {
throw ex73066;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73062 === (8))){
var inst_73048 = (state_73061[(2)]);
var inst_73049 = fluree.db.dbfunctions.internal.boolean$(inst_73048);
var inst_73050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73051 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73052 = ["boolean",inst_73048,inst_73049];
var inst_73053 = cljs.core.PersistentHashMap.fromArrays(inst_73051,inst_73052);
var inst_73054 = [inst_73053,(10)];
var inst_73055 = (new cljs.core.PersistentVector(null,2,(5),inst_73050,inst_73054,null));
var inst_73056 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73055);
var _ = (function (){var statearr_73074 = state_73061;
(statearr_73074[(4)] = cljs.core.rest((state_73061[(4)])));

return statearr_73074;
})();
var state_73061__$1 = (function (){var statearr_73075 = state_73061;
(statearr_73075[(7)] = inst_73056);

return statearr_73075;
})();
var statearr_73076_73090 = state_73061__$1;
(statearr_73076_73090[(2)] = inst_73049);

(statearr_73076_73090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0 = (function (){
var statearr_73077 = [null,null,null,null,null,null,null,null];
(statearr_73077[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__);

(statearr_73077[(1)] = (1));

return statearr_73077;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1 = (function (state_73061){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73061);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73078){var ex__13886__auto__ = e73078;
var statearr_73079_73091 = state_73061;
(statearr_73079_73091[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73061[(4)]))){
var statearr_73080_73092 = state_73061;
(statearr_73080_73092[(1)] = cljs.core.first((state_73061[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73093 = state_73061;
state_73061 = G__73093;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__ = function(state_73061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1.call(this,state_73061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73081 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73081[(6)] = c__13957__auto__);

return statearr_73081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73131){
var state_val_73132 = (state_73131[(1)]);
if((state_val_73132 === (7))){
var state_73131__$1 = state_73131;
var statearr_73133_73157 = state_73131__$1;
(statearr_73133_73157[(2)] = pattern);

(statearr_73133_73157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (1))){
var state_73131__$1 = state_73131;
var statearr_73134_73158 = state_73131__$1;
(statearr_73134_73158[(2)] = null);

(statearr_73134_73158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (4))){
var inst_73094 = (state_73131[(2)]);
var state_73131__$1 = state_73131;
var statearr_73135_73159 = state_73131__$1;
(statearr_73135_73159[(2)] = inst_73094);

(statearr_73135_73159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (13))){
var inst_73111 = (state_73131[(2)]);
var inst_73112 = fluree.db.util.async.throw_err(inst_73111);
var state_73131__$1 = state_73131;
var statearr_73136_73160 = state_73131__$1;
(statearr_73136_73160[(2)] = inst_73112);

(statearr_73136_73160[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (6))){
var state_73131__$1 = state_73131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73131__$1,(9),pattern);
} else {
if((state_val_73132 === (3))){
var inst_73129 = (state_73131[(2)]);
var state_73131__$1 = state_73131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73131__$1,inst_73129);
} else {
if((state_val_73132 === (12))){
var inst_73107 = (state_73131[(7)]);
var inst_73115 = (state_73131[(2)]);
var inst_73116 = fluree.db.dbfunctions.internal.re_find(inst_73107,inst_73115);
var inst_73117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73118 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73120 = [inst_73107,inst_73115];
var inst_73121 = (new cljs.core.PersistentVector(null,2,(5),inst_73119,inst_73120,null));
var inst_73122 = ["re-find",inst_73121,inst_73116];
var inst_73123 = cljs.core.PersistentHashMap.fromArrays(inst_73118,inst_73122);
var inst_73124 = [inst_73123,(10)];
var inst_73125 = (new cljs.core.PersistentVector(null,2,(5),inst_73117,inst_73124,null));
var inst_73126 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73125);
var _ = (function (){var statearr_73137 = state_73131;
(statearr_73137[(4)] = cljs.core.rest((state_73131[(4)])));

return statearr_73137;
})();
var state_73131__$1 = (function (){var statearr_73138 = state_73131;
(statearr_73138[(8)] = inst_73126);

return statearr_73138;
})();
var statearr_73139_73161 = state_73131__$1;
(statearr_73139_73161[(2)] = inst_73116);

(statearr_73139_73161[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (2))){
var _ = (function (){var statearr_73140 = state_73131;
(statearr_73140[(4)] = cljs.core.cons((5),(state_73131[(4)])));

return statearr_73140;
})();
var inst_73100 = fluree.db.util.async.channel_QMARK_(pattern);
var state_73131__$1 = state_73131;
if(inst_73100){
var statearr_73141_73162 = state_73131__$1;
(statearr_73141_73162[(1)] = (6));

} else {
var statearr_73142_73163 = state_73131__$1;
(statearr_73142_73163[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (11))){
var state_73131__$1 = state_73131;
var statearr_73144_73164 = state_73131__$1;
(statearr_73144_73164[(2)] = string);

(statearr_73144_73164[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (9))){
var inst_73103 = (state_73131[(2)]);
var inst_73104 = fluree.db.util.async.throw_err(inst_73103);
var state_73131__$1 = state_73131;
var statearr_73145_73165 = state_73131__$1;
(statearr_73145_73165[(2)] = inst_73104);

(statearr_73145_73165[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (5))){
var _ = (function (){var statearr_73146 = state_73131;
(statearr_73146[(4)] = cljs.core.rest((state_73131[(4)])));

return statearr_73146;
})();
var state_73131__$1 = state_73131;
var ex73143 = (state_73131__$1[(2)]);
var statearr_73147_73166 = state_73131__$1;
(statearr_73147_73166[(5)] = ex73143);


if((ex73143 instanceof Error)){
var statearr_73148_73167 = state_73131__$1;
(statearr_73148_73167[(1)] = (4));

(statearr_73148_73167[(5)] = null);

} else {
throw ex73143;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73132 === (10))){
var state_73131__$1 = state_73131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73131__$1,(13),string);
} else {
if((state_val_73132 === (8))){
var inst_73107 = (state_73131[(2)]);
var inst_73108 = fluree.db.util.async.channel_QMARK_(string);
var state_73131__$1 = (function (){var statearr_73149 = state_73131;
(statearr_73149[(7)] = inst_73107);

return statearr_73149;
})();
if(inst_73108){
var statearr_73150_73168 = state_73131__$1;
(statearr_73150_73168[(1)] = (10));

} else {
var statearr_73151_73169 = state_73131__$1;
(statearr_73151_73169[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0 = (function (){
var statearr_73152 = [null,null,null,null,null,null,null,null,null];
(statearr_73152[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__);

(statearr_73152[(1)] = (1));

return statearr_73152;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1 = (function (state_73131){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73131);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73153){var ex__13886__auto__ = e73153;
var statearr_73154_73170 = state_73131;
(statearr_73154_73170[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73131[(4)]))){
var statearr_73155_73171 = state_73131;
(statearr_73155_73171[(1)] = cljs.core.first((state_73131[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73172 = state_73131;
state_73131 = G__73172;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__ = function(state_73131){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1.call(this,state_73131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73156 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73156[(6)] = c__13957__auto__);

return statearr_73156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73199){
var state_val_73200 = (state_73199[(1)]);
if((state_val_73200 === (7))){
var state_73199__$1 = state_73199;
var statearr_73201_73220 = state_73199__$1;
(statearr_73201_73220[(2)] = email);

(statearr_73201_73220[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (1))){
var state_73199__$1 = state_73199;
var statearr_73202_73221 = state_73199__$1;
(statearr_73202_73221[(2)] = null);

(statearr_73202_73221[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (4))){
var inst_73173 = (state_73199[(2)]);
var state_73199__$1 = state_73199;
var statearr_73203_73222 = state_73199__$1;
(statearr_73203_73222[(2)] = inst_73173);

(statearr_73203_73222[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (6))){
var state_73199__$1 = state_73199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73199__$1,(9),email);
} else {
if((state_val_73200 === (3))){
var inst_73197 = (state_73199[(2)]);
var state_73199__$1 = state_73199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73199__$1,inst_73197);
} else {
if((state_val_73200 === (2))){
var _ = (function (){var statearr_73205 = state_73199;
(statearr_73205[(4)] = cljs.core.cons((5),(state_73199[(4)])));

return statearr_73205;
})();
var inst_73179 = fluree.db.util.async.channel_QMARK_(email);
var state_73199__$1 = state_73199;
if(inst_73179){
var statearr_73206_73223 = state_73199__$1;
(statearr_73206_73223[(1)] = (6));

} else {
var statearr_73207_73224 = state_73199__$1;
(statearr_73207_73224[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (9))){
var inst_73182 = (state_73199[(2)]);
var inst_73183 = fluree.db.util.async.throw_err(inst_73182);
var state_73199__$1 = state_73199;
var statearr_73208_73225 = state_73199__$1;
(statearr_73208_73225[(2)] = inst_73183);

(statearr_73208_73225[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (5))){
var _ = (function (){var statearr_73209 = state_73199;
(statearr_73209[(4)] = cljs.core.rest((state_73199[(4)])));

return statearr_73209;
})();
var state_73199__$1 = state_73199;
var ex73204 = (state_73199__$1[(2)]);
var statearr_73210_73226 = state_73199__$1;
(statearr_73210_73226[(5)] = ex73204);


if((ex73204 instanceof Error)){
var statearr_73211_73227 = state_73199__$1;
(statearr_73211_73227[(1)] = (4));

(statearr_73211_73227[(5)] = null);

} else {
throw ex73204;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73200 === (8))){
var inst_73186 = (state_73199[(2)]);
var inst_73187 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_73186);
var inst_73188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73189 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73190 = ["re-find",inst_73186,inst_73187];
var inst_73191 = cljs.core.PersistentHashMap.fromArrays(inst_73189,inst_73190);
var inst_73192 = [inst_73191,(10)];
var inst_73193 = (new cljs.core.PersistentVector(null,2,(5),inst_73188,inst_73192,null));
var inst_73194 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73193);
var _ = (function (){var statearr_73212 = state_73199;
(statearr_73212[(4)] = cljs.core.rest((state_73199[(4)])));

return statearr_73212;
})();
var state_73199__$1 = (function (){var statearr_73213 = state_73199;
(statearr_73213[(7)] = inst_73194);

return statearr_73213;
})();
var statearr_73214_73228 = state_73199__$1;
(statearr_73214_73228[(2)] = inst_73187);

(statearr_73214_73228[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_73215 = [null,null,null,null,null,null,null,null];
(statearr_73215[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__);

(statearr_73215[(1)] = (1));

return statearr_73215;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1 = (function (state_73199){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73199);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73216){var ex__13886__auto__ = e73216;
var statearr_73217_73229 = state_73199;
(statearr_73217_73229[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73199[(4)]))){
var statearr_73218_73230 = state_73199;
(statearr_73218_73230[(1)] = cljs.core.first((state_73199[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73231 = state_73199;
state_73199 = G__73231;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__ = function(state_73199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1.call(this,state_73199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73219 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73219[(6)] = c__13957__auto__);

return statearr_73219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73278){
var state_val_73279 = (state_73278[(1)]);
if((state_val_73279 === (7))){
var inst_73248 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73248)){
var statearr_73280_73307 = state_73278__$1;
(statearr_73280_73307[(1)] = (9));

} else {
var statearr_73281_73308 = state_73278__$1;
(statearr_73281_73308[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (1))){
var state_73278__$1 = state_73278;
var statearr_73282_73309 = state_73278__$1;
(statearr_73282_73309[(2)] = null);

(statearr_73282_73309[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (4))){
var inst_73232 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73283_73310 = state_73278__$1;
(statearr_73283_73310[(2)] = inst_73232);

(statearr_73283_73310[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (15))){
var inst_73259 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73284_73311 = state_73278__$1;
(statearr_73284_73311[(2)] = inst_73259);

(statearr_73284_73311[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (13))){
var inst_73256 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_73278__$1 = state_73278;
var statearr_73285_73312 = state_73278__$1;
(statearr_73285_73312[(2)] = inst_73256);

(statearr_73285_73312[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (6))){
var inst_73243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73244 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73245 = [inst_73244,(0)];
var inst_73246 = (new cljs.core.PersistentVector(null,2,(5),inst_73243,inst_73245,null));
var state_73278__$1 = state_73278;
var statearr_73286_73313 = state_73278__$1;
(statearr_73286_73313[(2)] = inst_73246);

(statearr_73286_73313[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (3))){
var inst_73276 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73278__$1,inst_73276);
} else {
if((state_val_73279 === (12))){
var inst_73252 = (state_73278[(2)]);
var inst_73253 = fluree.db.util.async.throw_err(inst_73252);
var state_73278__$1 = state_73278;
var statearr_73287_73314 = state_73278__$1;
(statearr_73287_73314[(2)] = inst_73253);

(statearr_73287_73314[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (2))){
var _ = (function (){var statearr_73288 = state_73278;
(statearr_73288[(4)] = cljs.core.cons((5),(state_73278[(4)])));

return statearr_73288;
})();
var inst_73241 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73241)){
var statearr_73289_73315 = state_73278__$1;
(statearr_73289_73315[(1)] = (6));

} else {
var statearr_73290_73316 = state_73278__$1;
(statearr_73290_73316[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (11))){
var inst_73261 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73292_73317 = state_73278__$1;
(statearr_73292_73317[(2)] = inst_73261);

(statearr_73292_73317[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (9))){
var inst_73250 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_73278__$1 = state_73278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73278__$1,(12),inst_73250);
} else {
if((state_val_73279 === (5))){
var _ = (function (){var statearr_73293 = state_73278;
(statearr_73293[(4)] = cljs.core.rest((state_73278[(4)])));

return statearr_73293;
})();
var state_73278__$1 = state_73278;
var ex73291 = (state_73278__$1[(2)]);
var statearr_73294_73318 = state_73278__$1;
(statearr_73294_73318[(5)] = ex73291);


if((ex73291 instanceof Error)){
var statearr_73295_73319 = state_73278__$1;
(statearr_73295_73319[(1)] = (4));

(statearr_73295_73319[(5)] = null);

} else {
throw ex73291;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (14))){
var state_73278__$1 = state_73278;
var statearr_73296_73320 = state_73278__$1;
(statearr_73296_73320[(2)] = null);

(statearr_73296_73320[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (10))){
var state_73278__$1 = state_73278;
var statearr_73297_73321 = state_73278__$1;
(statearr_73297_73321[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73279 === (8))){
var inst_73263 = (state_73278[(2)]);
var inst_73264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73263,(0),null);
var inst_73265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73263,(1),null);
var inst_73266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73267 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73268 = ["?user_id","?ctx",inst_73264];
var inst_73269 = cljs.core.PersistentHashMap.fromArrays(inst_73267,inst_73268);
var inst_73270 = ((10) + inst_73265);
var inst_73271 = [inst_73269,inst_73270];
var inst_73272 = (new cljs.core.PersistentVector(null,2,(5),inst_73266,inst_73271,null));
var inst_73273 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73272);
var _ = (function (){var statearr_73299 = state_73278;
(statearr_73299[(4)] = cljs.core.rest((state_73278[(4)])));

return statearr_73299;
})();
var state_73278__$1 = (function (){var statearr_73300 = state_73278;
(statearr_73300[(7)] = inst_73273);

return statearr_73300;
})();
var statearr_73301_73322 = state_73278__$1;
(statearr_73301_73322[(2)] = inst_73264);

(statearr_73301_73322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0 = (function (){
var statearr_73302 = [null,null,null,null,null,null,null,null];
(statearr_73302[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__);

(statearr_73302[(1)] = (1));

return statearr_73302;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1 = (function (state_73278){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73278);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73303){var ex__13886__auto__ = e73303;
var statearr_73304_73323 = state_73278;
(statearr_73304_73323[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73278[(4)]))){
var statearr_73305_73324 = state_73278;
(statearr_73305_73324[(1)] = cljs.core.first((state_73278[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73325 = state_73278;
state_73278 = G__73325;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__ = function(state_73278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1.call(this,state_73278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73306 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73306[(6)] = c__13957__auto__);

return statearr_73306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73353){
var state_val_73354 = (state_73353[(1)]);
if((state_val_73354 === (7))){
var inst_73346 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_73353__$1 = state_73353;
var statearr_73355_73374 = state_73353__$1;
(statearr_73355_73374[(2)] = inst_73346);

(statearr_73355_73374[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (1))){
var state_73353__$1 = state_73353;
var statearr_73356_73375 = state_73353__$1;
(statearr_73356_73375[(2)] = null);

(statearr_73356_73375[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (4))){
var inst_73326 = (state_73353[(2)]);
var state_73353__$1 = state_73353;
var statearr_73357_73376 = state_73353__$1;
(statearr_73357_73376[(2)] = inst_73326);

(statearr_73357_73376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (6))){
var inst_73334 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_73353__$1 = state_73353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73353__$1,(9),inst_73334);
} else {
if((state_val_73354 === (3))){
var inst_73351 = (state_73353[(2)]);
var state_73353__$1 = state_73353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73353__$1,inst_73351);
} else {
if((state_val_73354 === (2))){
var _ = (function (){var statearr_73359 = state_73353;
(statearr_73359[(4)] = cljs.core.cons((5),(state_73353[(4)])));

return statearr_73359;
})();
var inst_73332 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73353__$1 = state_73353;
if(cljs.core.truth_(inst_73332)){
var statearr_73360_73377 = state_73353__$1;
(statearr_73360_73377[(1)] = (6));

} else {
var statearr_73361_73378 = state_73353__$1;
(statearr_73361_73378[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (9))){
var inst_73336 = (state_73353[(2)]);
var inst_73337 = fluree.db.util.async.throw_err(inst_73336);
var inst_73338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73339 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73340 = ["?auth_id","?ctx",inst_73337];
var inst_73341 = cljs.core.PersistentHashMap.fromArrays(inst_73339,inst_73340);
var inst_73342 = [inst_73341,(10)];
var inst_73343 = (new cljs.core.PersistentVector(null,2,(5),inst_73338,inst_73342,null));
var inst_73344 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73343);
var state_73353__$1 = (function (){var statearr_73362 = state_73353;
(statearr_73362[(7)] = inst_73344);

return statearr_73362;
})();
var statearr_73363_73379 = state_73353__$1;
(statearr_73363_73379[(2)] = inst_73337);

(statearr_73363_73379[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (5))){
var _ = (function (){var statearr_73364 = state_73353;
(statearr_73364[(4)] = cljs.core.rest((state_73353[(4)])));

return statearr_73364;
})();
var state_73353__$1 = state_73353;
var ex73358 = (state_73353__$1[(2)]);
var statearr_73365_73380 = state_73353__$1;
(statearr_73365_73380[(5)] = ex73358);


if((ex73358 instanceof Error)){
var statearr_73366_73381 = state_73353__$1;
(statearr_73366_73381[(1)] = (4));

(statearr_73366_73381[(5)] = null);

} else {
throw ex73358;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73354 === (8))){
var inst_73348 = (state_73353[(2)]);
var _ = (function (){var statearr_73367 = state_73353;
(statearr_73367[(4)] = cljs.core.rest((state_73353[(4)])));

return statearr_73367;
})();
var state_73353__$1 = state_73353;
var statearr_73368_73382 = state_73353__$1;
(statearr_73368_73382[(2)] = inst_73348);

(statearr_73368_73382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0 = (function (){
var statearr_73369 = [null,null,null,null,null,null,null,null];
(statearr_73369[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__);

(statearr_73369[(1)] = (1));

return statearr_73369;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1 = (function (state_73353){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73353);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73370){var ex__13886__auto__ = e73370;
var statearr_73371_73383 = state_73353;
(statearr_73371_73383[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73353[(4)]))){
var statearr_73372_73384 = state_73353;
(statearr_73372_73384[(1)] = cljs.core.first((state_73353[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73385 = state_73353;
state_73353 = G__73385;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__ = function(state_73353){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1.call(this,state_73353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73373 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73373[(6)] = c__13957__auto__);

return statearr_73373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__73387 = arguments.length;
switch (G__73387) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73429){
var state_val_73430 = (state_73429[(1)]);
if((state_val_73430 === (7))){
var state_73429__$1 = state_73429;
var statearr_73431_73461 = state_73429__$1;
(statearr_73431_73461[(2)] = seed);

(statearr_73431_73461[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (1))){
var state_73429__$1 = state_73429;
var statearr_73432_73462 = state_73429__$1;
(statearr_73432_73462[(2)] = null);

(statearr_73432_73462[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (4))){
var inst_73388 = (state_73429[(2)]);
var state_73429__$1 = state_73429;
var statearr_73433_73463 = state_73429__$1;
(statearr_73433_73463[(2)] = inst_73388);

(statearr_73433_73463[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (15))){
var state_73429__$1 = state_73429;
var statearr_73434_73464 = state_73429__$1;
(statearr_73434_73464[(2)] = (10));

(statearr_73434_73464[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (13))){
var inst_73405 = (state_73429[(2)]);
var inst_73406 = fluree.db.util.async.throw_err(inst_73405);
var state_73429__$1 = state_73429;
var statearr_73435_73465 = state_73429__$1;
(statearr_73435_73465[(2)] = inst_73406);

(statearr_73435_73465[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (6))){
var state_73429__$1 = state_73429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73429__$1,(9),seed);
} else {
if((state_val_73430 === (3))){
var inst_73427 = (state_73429[(2)]);
var state_73429__$1 = state_73429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73429__$1,inst_73427);
} else {
if((state_val_73430 === (12))){
var inst_73409 = (state_73429[(7)]);
var inst_73409__$1 = (state_73429[(2)]);
var state_73429__$1 = (function (){var statearr_73436 = state_73429;
(statearr_73436[(7)] = inst_73409__$1);

return statearr_73436;
})();
if(cljs.core.truth_(inst_73409__$1)){
var statearr_73437_73466 = state_73429__$1;
(statearr_73437_73466[(1)] = (14));

} else {
var statearr_73438_73467 = state_73429__$1;
(statearr_73438_73467[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (2))){
var _ = (function (){var statearr_73439 = state_73429;
(statearr_73439[(4)] = cljs.core.cons((5),(state_73429[(4)])));

return statearr_73439;
})();
var inst_73394 = fluree.db.util.async.channel_QMARK_(seed);
var state_73429__$1 = state_73429;
if(inst_73394){
var statearr_73440_73468 = state_73429__$1;
(statearr_73440_73468[(1)] = (6));

} else {
var statearr_73441_73469 = state_73429__$1;
(statearr_73441_73469[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (11))){
var state_73429__$1 = state_73429;
var statearr_73443_73470 = state_73429__$1;
(statearr_73443_73470[(2)] = max);

(statearr_73443_73470[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (9))){
var inst_73397 = (state_73429[(2)]);
var inst_73398 = fluree.db.util.async.throw_err(inst_73397);
var state_73429__$1 = state_73429;
var statearr_73444_73471 = state_73429__$1;
(statearr_73444_73471[(2)] = inst_73398);

(statearr_73444_73471[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (5))){
var _ = (function (){var statearr_73445 = state_73429;
(statearr_73445[(4)] = cljs.core.rest((state_73429[(4)])));

return statearr_73445;
})();
var state_73429__$1 = state_73429;
var ex73442 = (state_73429__$1[(2)]);
var statearr_73446_73472 = state_73429__$1;
(statearr_73446_73472[(5)] = ex73442);


if((ex73442 instanceof Error)){
var statearr_73447_73473 = state_73429__$1;
(statearr_73447_73473[(1)] = (4));

(statearr_73447_73473[(5)] = null);

} else {
throw ex73442;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (14))){
var inst_73409 = (state_73429[(7)]);
var state_73429__$1 = state_73429;
var statearr_73448_73474 = state_73429__$1;
(statearr_73448_73474[(2)] = inst_73409);

(statearr_73448_73474[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (16))){
var inst_73401 = (state_73429[(8)]);
var inst_73413 = (state_73429[(2)]);
var inst_73414 = fluree.db.dbfunctions.internal.rand(inst_73401,inst_73413);
var inst_73415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73416 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73418 = [max,seed];
var inst_73419 = (new cljs.core.PersistentVector(null,2,(5),inst_73417,inst_73418,null));
var inst_73420 = ["rand",inst_73419,inst_73414];
var inst_73421 = cljs.core.PersistentHashMap.fromArrays(inst_73416,inst_73420);
var inst_73422 = [inst_73421,(10)];
var inst_73423 = (new cljs.core.PersistentVector(null,2,(5),inst_73415,inst_73422,null));
var inst_73424 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73423);
var _ = (function (){var statearr_73449 = state_73429;
(statearr_73449[(4)] = cljs.core.rest((state_73429[(4)])));

return statearr_73449;
})();
var state_73429__$1 = (function (){var statearr_73450 = state_73429;
(statearr_73450[(9)] = inst_73424);

return statearr_73450;
})();
var statearr_73451_73475 = state_73429__$1;
(statearr_73451_73475[(2)] = inst_73414);

(statearr_73451_73475[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73430 === (10))){
var state_73429__$1 = state_73429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73429__$1,(13),max);
} else {
if((state_val_73430 === (8))){
var inst_73401 = (state_73429[(2)]);
var inst_73402 = fluree.db.util.async.channel_QMARK_(max);
var state_73429__$1 = (function (){var statearr_73452 = state_73429;
(statearr_73452[(8)] = inst_73401);

return statearr_73452;
})();
if(inst_73402){
var statearr_73453_73476 = state_73429__$1;
(statearr_73453_73476[(1)] = (10));

} else {
var statearr_73454_73477 = state_73429__$1;
(statearr_73454_73477[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_73455 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73455[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_73455[(1)] = (1));

return statearr_73455;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_73429){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73429);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73456){var ex__13886__auto__ = e73456;
var statearr_73457_73478 = state_73429;
(statearr_73457_73478[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73429[(4)]))){
var statearr_73458_73479 = state_73429;
(statearr_73458_73479[(1)] = cljs.core.first((state_73429[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73480 = state_73429;
state_73429 = G__73480;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_73429){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_73429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73459 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73459[(6)] = c__13957__auto__);

return statearr_73459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73501){
var state_val_73502 = (state_73501[(1)]);
if((state_val_73502 === (1))){
var state_73501__$1 = state_73501;
var statearr_73503_73518 = state_73501__$1;
(statearr_73503_73518[(2)] = null);

(statearr_73503_73518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73502 === (2))){
var _ = (function (){var statearr_73504 = state_73501;
(statearr_73504[(4)] = cljs.core.cons((5),(state_73501[(4)])));

return statearr_73504;
})();
var inst_73487 = fluree.db.util.core.random_uuid();
var inst_73488 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73487);
var inst_73489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73490 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73491 = cljs.core.PersistentVector.EMPTY;
var inst_73492 = ["uuid",inst_73491,inst_73488];
var inst_73493 = cljs.core.PersistentHashMap.fromArrays(inst_73490,inst_73492);
var inst_73494 = [inst_73493,(10)];
var inst_73495 = (new cljs.core.PersistentVector(null,2,(5),inst_73489,inst_73494,null));
var inst_73496 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73495);
var ___$1 = (function (){var statearr_73505 = state_73501;
(statearr_73505[(4)] = cljs.core.rest((state_73501[(4)])));

return statearr_73505;
})();
var state_73501__$1 = (function (){var statearr_73506 = state_73501;
(statearr_73506[(7)] = inst_73496);

return statearr_73506;
})();
var statearr_73507_73519 = state_73501__$1;
(statearr_73507_73519[(2)] = inst_73488);

(statearr_73507_73519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73502 === (3))){
var inst_73499 = (state_73501[(2)]);
var state_73501__$1 = state_73501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73501__$1,inst_73499);
} else {
if((state_val_73502 === (4))){
var inst_73481 = (state_73501[(2)]);
var state_73501__$1 = state_73501;
var statearr_73509_73520 = state_73501__$1;
(statearr_73509_73520[(2)] = inst_73481);

(statearr_73509_73520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73502 === (5))){
var _ = (function (){var statearr_73510 = state_73501;
(statearr_73510[(4)] = cljs.core.rest((state_73501[(4)])));

return statearr_73510;
})();
var state_73501__$1 = state_73501;
var ex73508 = (state_73501__$1[(2)]);
var statearr_73511_73521 = state_73501__$1;
(statearr_73511_73521[(5)] = ex73508);


if((ex73508 instanceof Error)){
var statearr_73512_73522 = state_73501__$1;
(statearr_73512_73522[(1)] = (4));

(statearr_73512_73522[(5)] = null);

} else {
throw ex73508;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0 = (function (){
var statearr_73513 = [null,null,null,null,null,null,null,null];
(statearr_73513[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__);

(statearr_73513[(1)] = (1));

return statearr_73513;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1 = (function (state_73501){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73501);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73514){var ex__13886__auto__ = e73514;
var statearr_73515_73523 = state_73501;
(statearr_73515_73523[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73501[(4)]))){
var statearr_73516_73524 = state_73501;
(statearr_73516_73524[(1)] = cljs.core.first((state_73501[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73525 = state_73501;
state_73501 = G__73525;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__ = function(state_73501){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1.call(this,state_73501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73517 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73517[(6)] = c__13957__auto__);

return statearr_73517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73555){
var state_val_73556 = (state_73555[(1)]);
if((state_val_73556 === (7))){
var state_73555__$1 = state_73555;
var statearr_73557_73576 = state_73555__$1;
(statearr_73557_73576[(2)] = num);

(statearr_73557_73576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (1))){
var state_73555__$1 = state_73555;
var statearr_73558_73577 = state_73555__$1;
(statearr_73558_73577[(2)] = null);

(statearr_73558_73577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (4))){
var inst_73526 = (state_73555[(2)]);
var state_73555__$1 = state_73555;
var statearr_73559_73578 = state_73555__$1;
(statearr_73559_73578[(2)] = inst_73526);

(statearr_73559_73578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (6))){
var state_73555__$1 = state_73555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73555__$1,(9),num);
} else {
if((state_val_73556 === (3))){
var inst_73553 = (state_73555[(2)]);
var state_73555__$1 = state_73555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73555__$1,inst_73553);
} else {
if((state_val_73556 === (2))){
var _ = (function (){var statearr_73561 = state_73555;
(statearr_73561[(4)] = cljs.core.cons((5),(state_73555[(4)])));

return statearr_73561;
})();
var inst_73532 = fluree.db.util.async.channel_QMARK_(num);
var state_73555__$1 = state_73555;
if(inst_73532){
var statearr_73562_73579 = state_73555__$1;
(statearr_73562_73579[(1)] = (6));

} else {
var statearr_73563_73580 = state_73555__$1;
(statearr_73563_73580[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (9))){
var inst_73535 = (state_73555[(2)]);
var inst_73536 = fluree.db.util.async.throw_err(inst_73535);
var state_73555__$1 = state_73555;
var statearr_73564_73581 = state_73555__$1;
(statearr_73564_73581[(2)] = inst_73536);

(statearr_73564_73581[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (5))){
var _ = (function (){var statearr_73565 = state_73555;
(statearr_73565[(4)] = cljs.core.rest((state_73555[(4)])));

return statearr_73565;
})();
var state_73555__$1 = state_73555;
var ex73560 = (state_73555__$1[(2)]);
var statearr_73566_73582 = state_73555__$1;
(statearr_73566_73582[(5)] = ex73560);


if((ex73560 instanceof Error)){
var statearr_73567_73583 = state_73555__$1;
(statearr_73567_73583[(1)] = (4));

(statearr_73567_73583[(5)] = null);

} else {
throw ex73560;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73556 === (8))){
var inst_73539 = (state_73555[(2)]);
var inst_73540 = fluree.db.dbfunctions.internal.ceil(inst_73539);
var inst_73541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73542 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73544 = [fluree.db.dbfunctions.fns.ceil];
var inst_73545 = (new cljs.core.PersistentVector(null,1,(5),inst_73543,inst_73544,null));
var inst_73546 = ["",inst_73545,inst_73540];
var inst_73547 = cljs.core.PersistentHashMap.fromArrays(inst_73542,inst_73546);
var inst_73548 = [inst_73547,(10)];
var inst_73549 = (new cljs.core.PersistentVector(null,2,(5),inst_73541,inst_73548,null));
var inst_73550 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73549);
var _ = (function (){var statearr_73568 = state_73555;
(statearr_73568[(4)] = cljs.core.rest((state_73555[(4)])));

return statearr_73568;
})();
var state_73555__$1 = (function (){var statearr_73569 = state_73555;
(statearr_73569[(7)] = inst_73550);

return statearr_73569;
})();
var statearr_73570_73584 = state_73555__$1;
(statearr_73570_73584[(2)] = inst_73540);

(statearr_73570_73584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0 = (function (){
var statearr_73571 = [null,null,null,null,null,null,null,null];
(statearr_73571[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__);

(statearr_73571[(1)] = (1));

return statearr_73571;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1 = (function (state_73555){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73555);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73572){var ex__13886__auto__ = e73572;
var statearr_73573_73585 = state_73555;
(statearr_73573_73585[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73555[(4)]))){
var statearr_73574_73586 = state_73555;
(statearr_73574_73586[(1)] = cljs.core.first((state_73555[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73587 = state_73555;
state_73555 = G__73587;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__ = function(state_73555){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1.call(this,state_73555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73575 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73575[(6)] = c__13957__auto__);

return statearr_73575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73617){
var state_val_73618 = (state_73617[(1)]);
if((state_val_73618 === (7))){
var state_73617__$1 = state_73617;
var statearr_73619_73638 = state_73617__$1;
(statearr_73619_73638[(2)] = num);

(statearr_73619_73638[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (1))){
var state_73617__$1 = state_73617;
var statearr_73620_73639 = state_73617__$1;
(statearr_73620_73639[(2)] = null);

(statearr_73620_73639[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (4))){
var inst_73588 = (state_73617[(2)]);
var state_73617__$1 = state_73617;
var statearr_73621_73640 = state_73617__$1;
(statearr_73621_73640[(2)] = inst_73588);

(statearr_73621_73640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (6))){
var state_73617__$1 = state_73617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73617__$1,(9),num);
} else {
if((state_val_73618 === (3))){
var inst_73615 = (state_73617[(2)]);
var state_73617__$1 = state_73617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73617__$1,inst_73615);
} else {
if((state_val_73618 === (2))){
var _ = (function (){var statearr_73623 = state_73617;
(statearr_73623[(4)] = cljs.core.cons((5),(state_73617[(4)])));

return statearr_73623;
})();
var inst_73594 = fluree.db.util.async.channel_QMARK_(num);
var state_73617__$1 = state_73617;
if(inst_73594){
var statearr_73624_73641 = state_73617__$1;
(statearr_73624_73641[(1)] = (6));

} else {
var statearr_73625_73642 = state_73617__$1;
(statearr_73625_73642[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (9))){
var inst_73597 = (state_73617[(2)]);
var inst_73598 = fluree.db.util.async.throw_err(inst_73597);
var state_73617__$1 = state_73617;
var statearr_73626_73643 = state_73617__$1;
(statearr_73626_73643[(2)] = inst_73598);

(statearr_73626_73643[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (5))){
var _ = (function (){var statearr_73627 = state_73617;
(statearr_73627[(4)] = cljs.core.rest((state_73617[(4)])));

return statearr_73627;
})();
var state_73617__$1 = state_73617;
var ex73622 = (state_73617__$1[(2)]);
var statearr_73628_73644 = state_73617__$1;
(statearr_73628_73644[(5)] = ex73622);


if((ex73622 instanceof Error)){
var statearr_73629_73645 = state_73617__$1;
(statearr_73629_73645[(1)] = (4));

(statearr_73629_73645[(5)] = null);

} else {
throw ex73622;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73618 === (8))){
var inst_73601 = (state_73617[(2)]);
var inst_73602 = fluree.db.dbfunctions.internal.floor(inst_73601);
var inst_73603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73604 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73606 = [fluree.db.dbfunctions.fns.floor];
var inst_73607 = (new cljs.core.PersistentVector(null,1,(5),inst_73605,inst_73606,null));
var inst_73608 = ["",inst_73607,inst_73602];
var inst_73609 = cljs.core.PersistentHashMap.fromArrays(inst_73604,inst_73608);
var inst_73610 = [inst_73609,(10)];
var inst_73611 = (new cljs.core.PersistentVector(null,2,(5),inst_73603,inst_73610,null));
var inst_73612 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73611);
var _ = (function (){var statearr_73630 = state_73617;
(statearr_73630[(4)] = cljs.core.rest((state_73617[(4)])));

return statearr_73630;
})();
var state_73617__$1 = (function (){var statearr_73631 = state_73617;
(statearr_73631[(7)] = inst_73612);

return statearr_73631;
})();
var statearr_73632_73646 = state_73617__$1;
(statearr_73632_73646[(2)] = inst_73602);

(statearr_73632_73646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0 = (function (){
var statearr_73633 = [null,null,null,null,null,null,null,null];
(statearr_73633[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__);

(statearr_73633[(1)] = (1));

return statearr_73633;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1 = (function (state_73617){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73617);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73634){var ex__13886__auto__ = e73634;
var statearr_73635_73647 = state_73617;
(statearr_73635_73647[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73617[(4)]))){
var statearr_73636_73648 = state_73617;
(statearr_73636_73648[(1)] = cljs.core.first((state_73617[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73649 = state_73617;
state_73617 = G__73649;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__ = function(state_73617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1.call(this,state_73617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73637 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73637[(6)] = c__13957__auto__);

return statearr_73637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73674){
var state_val_73675 = (state_73674[(1)]);
if((state_val_73675 === (1))){
var state_73674__$1 = state_73674;
var statearr_73676_73691 = state_73674__$1;
(statearr_73676_73691[(2)] = null);

(statearr_73676_73691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73675 === (2))){
var _ = (function (){var statearr_73677 = state_73674;
(statearr_73677[(4)] = cljs.core.cons((5),(state_73674[(4)])));

return statearr_73677;
})();
var inst_73656 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_73674__$1 = state_73674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73674__$1,(6),inst_73656);
} else {
if((state_val_73675 === (3))){
var inst_73672 = (state_73674[(2)]);
var state_73674__$1 = state_73674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73674__$1,inst_73672);
} else {
if((state_val_73675 === (4))){
var inst_73650 = (state_73674[(2)]);
var state_73674__$1 = state_73674;
var statearr_73679_73692 = state_73674__$1;
(statearr_73679_73692[(2)] = inst_73650);

(statearr_73679_73692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73675 === (5))){
var _ = (function (){var statearr_73680 = state_73674;
(statearr_73680[(4)] = cljs.core.rest((state_73674[(4)])));

return statearr_73680;
})();
var state_73674__$1 = state_73674;
var ex73678 = (state_73674__$1[(2)]);
var statearr_73681_73693 = state_73674__$1;
(statearr_73681_73693[(5)] = ex73678);


if((ex73678 instanceof Error)){
var statearr_73682_73694 = state_73674__$1;
(statearr_73682_73694[(1)] = (4));

(statearr_73682_73694[(5)] = null);

} else {
throw ex73678;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73675 === (6))){
var inst_73658 = (state_73674[(2)]);
var inst_73659 = fluree.db.util.async.throw_err(inst_73658);
var inst_73660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73661 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73663 = [compare_val,new_val];
var inst_73664 = (new cljs.core.PersistentVector(null,2,(5),inst_73662,inst_73663,null));
var inst_73665 = ["",inst_73664,inst_73659];
var inst_73666 = cljs.core.PersistentHashMap.fromArrays(inst_73661,inst_73665);
var inst_73667 = [inst_73666,(10)];
var inst_73668 = (new cljs.core.PersistentVector(null,2,(5),inst_73660,inst_73667,null));
var inst_73669 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73668);
var _ = (function (){var statearr_73683 = state_73674;
(statearr_73683[(4)] = cljs.core.rest((state_73674[(4)])));

return statearr_73683;
})();
var state_73674__$1 = (function (){var statearr_73684 = state_73674;
(statearr_73684[(7)] = inst_73669);

return statearr_73684;
})();
var statearr_73685_73695 = state_73674__$1;
(statearr_73685_73695[(2)] = inst_73659);

(statearr_73685_73695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0 = (function (){
var statearr_73686 = [null,null,null,null,null,null,null,null];
(statearr_73686[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__);

(statearr_73686[(1)] = (1));

return statearr_73686;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1 = (function (state_73674){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73674);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73687){var ex__13886__auto__ = e73687;
var statearr_73688_73696 = state_73674;
(statearr_73688_73696[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73674[(4)]))){
var statearr_73689_73697 = state_73674;
(statearr_73689_73697[(1)] = cljs.core.first((state_73674[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73698 = state_73674;
state_73674 = G__73698;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__ = function(state_73674){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1.call(this,state_73674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73690 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73690[(6)] = c__13957__auto__);

return statearr_73690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
