// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__74688_74857 = cljs.core.seq(servers);
var chunk__74689_74858 = null;
var count__74690_74859 = (0);
var i__74691_74860 = (0);
while(true){
if((i__74691_74860 < count__74690_74859)){
var server_74861 = chunk__74689_74858.cljs$core$IIndexed$_nth$arity$2(null,i__74691_74860);
var healthcheck_uri_74862 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74861),"/fdb/health"].join('');
var resp_chan_74863 = fluree.db.util.xhttp.post_json(healthcheck_uri_74862,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__13957__auto___74864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861){
return (function (state_74752){
var state_val_74753 = (state_74752[(1)]);
if((state_val_74753 === (1))){
var state_74752__$1 = state_74752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74752__$1,(2),resp_chan_74863);
} else {
if((state_val_74753 === (2))){
var inst_74741 = (state_74752[(7)]);
var inst_74741__$1 = (state_74752[(2)]);
var inst_74742 = fluree.db.util.core.exception_QMARK_(inst_74741__$1);
var state_74752__$1 = (function (){var statearr_74754 = state_74752;
(statearr_74754[(7)] = inst_74741__$1);

return statearr_74754;
})();
if(inst_74742){
var statearr_74755_74865 = state_74752__$1;
(statearr_74755_74865[(1)] = (3));

} else {
var statearr_74756_74866 = state_74752__$1;
(statearr_74756_74866[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74753 === (3))){
var inst_74741 = (state_74752[(7)]);
var inst_74744 = cljs.core.ex_message(inst_74741);
var inst_74745 = cljs.core.ex_data(inst_74741);
var inst_74746 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74744,inst_74745], 0));
var state_74752__$1 = state_74752;
var statearr_74757_74867 = state_74752__$1;
(statearr_74757_74867[(2)] = inst_74746);

(statearr_74757_74867[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74753 === (4))){
var inst_74748 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74861);
var state_74752__$1 = state_74752;
var statearr_74758_74868 = state_74752__$1;
(statearr_74758_74868[(2)] = inst_74748);

(statearr_74758_74868[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74753 === (5))){
var inst_74750 = (state_74752[(2)]);
var state_74752__$1 = state_74752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74752__$1,inst_74750);
} else {
return null;
}
}
}
}
}
});})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861))
;
return ((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,switch__13882__auto__,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74759 = [null,null,null,null,null,null,null,null];
(statearr_74759[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74759[(1)] = (1));

return statearr_74759;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74752){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74752);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74760){var ex__13886__auto__ = e74760;
var statearr_74761_74869 = state_74752;
(statearr_74761_74869[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74752[(4)]))){
var statearr_74762_74870 = state_74752;
(statearr_74762_74870[(1)] = cljs.core.first((state_74752[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74871 = state_74752;
state_74752 = G__74871;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74752){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
;})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,switch__13882__auto__,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861))
})();
var state__13959__auto__ = (function (){var statearr_74763 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74763[(6)] = c__13957__auto___74864);

return statearr_74763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74864,healthcheck_uri_74862,resp_chan_74863,server_74861))
);



var G__74872 = seq__74688_74857;
var G__74873 = chunk__74689_74858;
var G__74874 = count__74690_74859;
var G__74875 = (i__74691_74860 + (1));
seq__74688_74857 = G__74872;
chunk__74689_74858 = G__74873;
count__74690_74859 = G__74874;
i__74691_74860 = G__74875;
continue;
} else {
var temp__5753__auto___74876 = cljs.core.seq(seq__74688_74857);
if(temp__5753__auto___74876){
var seq__74688_74877__$1 = temp__5753__auto___74876;
if(cljs.core.chunked_seq_QMARK_(seq__74688_74877__$1)){
var c__4591__auto___74878 = cljs.core.chunk_first(seq__74688_74877__$1);
var G__74879 = cljs.core.chunk_rest(seq__74688_74877__$1);
var G__74880 = c__4591__auto___74878;
var G__74881 = cljs.core.count(c__4591__auto___74878);
var G__74882 = (0);
seq__74688_74857 = G__74879;
chunk__74689_74858 = G__74880;
count__74690_74859 = G__74881;
i__74691_74860 = G__74882;
continue;
} else {
var server_74883 = cljs.core.first(seq__74688_74877__$1);
var healthcheck_uri_74884 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74883),"/fdb/health"].join('');
var resp_chan_74885 = fluree.db.util.xhttp.post_json(healthcheck_uri_74884,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__13957__auto___74886 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876){
return (function (state_74776){
var state_val_74777 = (state_74776[(1)]);
if((state_val_74777 === (1))){
var state_74776__$1 = state_74776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74776__$1,(2),resp_chan_74885);
} else {
if((state_val_74777 === (2))){
var inst_74765 = (state_74776[(7)]);
var inst_74765__$1 = (state_74776[(2)]);
var inst_74766 = fluree.db.util.core.exception_QMARK_(inst_74765__$1);
var state_74776__$1 = (function (){var statearr_74778 = state_74776;
(statearr_74778[(7)] = inst_74765__$1);

return statearr_74778;
})();
if(inst_74766){
var statearr_74779_74887 = state_74776__$1;
(statearr_74779_74887[(1)] = (3));

} else {
var statearr_74780_74888 = state_74776__$1;
(statearr_74780_74888[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74777 === (3))){
var inst_74765 = (state_74776[(7)]);
var inst_74768 = cljs.core.ex_message(inst_74765);
var inst_74769 = cljs.core.ex_data(inst_74765);
var inst_74770 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74768,inst_74769], 0));
var state_74776__$1 = state_74776;
var statearr_74781_74889 = state_74776__$1;
(statearr_74781_74889[(2)] = inst_74770);

(statearr_74781_74889[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74777 === (4))){
var inst_74772 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74883);
var state_74776__$1 = state_74776;
var statearr_74782_74890 = state_74776__$1;
(statearr_74782_74890[(2)] = inst_74772);

(statearr_74782_74890[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74777 === (5))){
var inst_74774 = (state_74776[(2)]);
var state_74776__$1 = state_74776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74776__$1,inst_74774);
} else {
return null;
}
}
}
}
}
});})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876))
;
return ((function (seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,switch__13882__auto__,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74783 = [null,null,null,null,null,null,null,null];
(statearr_74783[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74783[(1)] = (1));

return statearr_74783;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74776){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74776);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74784){var ex__13886__auto__ = e74784;
var statearr_74785_74891 = state_74776;
(statearr_74785_74891[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74776[(4)]))){
var statearr_74786_74892 = state_74776;
(statearr_74786_74892[(1)] = cljs.core.first((state_74776[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74893 = state_74776;
state_74776 = G__74893;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74776){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
;})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,switch__13882__auto__,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876))
})();
var state__13959__auto__ = (function (){var statearr_74787 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74787[(6)] = c__13957__auto___74886);

return statearr_74787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(seq__74688_74857,chunk__74689_74858,count__74690_74859,i__74691_74860,c__13957__auto___74886,healthcheck_uri_74884,resp_chan_74885,server_74883,seq__74688_74877__$1,temp__5753__auto___74876))
);



var G__74894 = cljs.core.next(seq__74688_74877__$1);
var G__74895 = null;
var G__74896 = (0);
var G__74897 = (0);
seq__74688_74857 = G__74894;
chunk__74689_74858 = G__74895;
count__74690_74859 = G__74896;
i__74691_74860 = G__74897;
continue;
}
} else {
}
}
break;
}

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74831){
var state_val_74832 = (state_74831[(1)]);
if((state_val_74832 === (7))){
var inst_74803 = (state_74831[(7)]);
var inst_74810 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74803,cljs.core.cst$kw$default);
var state_74831__$1 = state_74831;
if(inst_74810){
var statearr_74833_74898 = state_74831__$1;
(statearr_74833_74898[(1)] = (9));

} else {
var statearr_74834_74899 = state_74831__$1;
(statearr_74834_74899[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (1))){
var inst_74795 = (state_74831[(8)]);
var inst_74796 = (state_74831[(9)]);
var inst_74795__$1 = promise_chan;
var inst_74796__$1 = cljs.core.async.timeout((60000));
var inst_74797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74798 = [inst_74795__$1,inst_74796__$1];
var inst_74799 = (new cljs.core.PersistentVector(null,2,(5),inst_74797,inst_74798,null));
var state_74831__$1 = (function (){var statearr_74835 = state_74831;
(statearr_74835[(8)] = inst_74795__$1);

(statearr_74835[(9)] = inst_74796__$1);

return statearr_74835;
})();
return cljs.core.async.ioc_alts_BANG_(state_74831__$1,(2),inst_74799);
} else {
if((state_val_74832 === (4))){
var inst_74796 = (state_74831[(9)]);
var inst_74803 = (state_74831[(7)]);
var inst_74807 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74803,inst_74796);
var state_74831__$1 = state_74831;
if(inst_74807){
var statearr_74836_74900 = state_74831__$1;
(statearr_74836_74900[(1)] = (6));

} else {
var statearr_74837_74901 = state_74831__$1;
(statearr_74837_74901[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (13))){
var state_74831__$1 = state_74831;
var statearr_74838_74902 = state_74831__$1;
(statearr_74838_74902[(2)] = null);

(statearr_74838_74902[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (6))){
var state_74831__$1 = state_74831;
var statearr_74839_74903 = state_74831__$1;
(statearr_74839_74903[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_74839_74903[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (3))){
var state_74831__$1 = state_74831;
var statearr_74840_74904 = state_74831__$1;
(statearr_74840_74904[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_74840_74904[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (12))){
var inst_74821 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_74822 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74823 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_74824 = cljs.core.PersistentHashMap.fromArrays(inst_74822,inst_74823);
var inst_74825 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_74824);
var inst_74826 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_74825);
var state_74831__$1 = (function (){var statearr_74841 = state_74831;
(statearr_74841[(10)] = inst_74821);

return statearr_74841;
})();
var statearr_74842_74905 = state_74831__$1;
(statearr_74842_74905[(2)] = inst_74826);

(statearr_74842_74905[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (2))){
var inst_74795 = (state_74831[(8)]);
var inst_74803 = (state_74831[(7)]);
var inst_74801 = (state_74831[(2)]);
var inst_74802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74801,(0),null);
var inst_74803__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74801,(1),null);
var inst_74804 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74803__$1,inst_74795);
var state_74831__$1 = (function (){var statearr_74843 = state_74831;
(statearr_74843[(7)] = inst_74803__$1);

(statearr_74843[(11)] = inst_74802);

return statearr_74843;
})();
if(inst_74804){
var statearr_74844_74906 = state_74831__$1;
(statearr_74844_74906[(1)] = (3));

} else {
var statearr_74845_74907 = state_74831__$1;
(statearr_74845_74907[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (11))){
var inst_74814 = (state_74831[(2)]);
var state_74831__$1 = state_74831;
var statearr_74846_74908 = state_74831__$1;
(statearr_74846_74908[(2)] = inst_74814);

(statearr_74846_74908[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (9))){
var inst_74802 = (state_74831[(11)]);
var state_74831__$1 = state_74831;
var statearr_74847_74909 = state_74831__$1;
(statearr_74847_74909[(2)] = inst_74802);

(statearr_74847_74909[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (5))){
var inst_74818 = (state_74831[(2)]);
var inst_74819 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_74818);
var state_74831__$1 = state_74831;
if(inst_74819){
var statearr_74848_74910 = state_74831__$1;
(statearr_74848_74910[(1)] = (12));

} else {
var statearr_74849_74911 = state_74831__$1;
(statearr_74849_74911[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (14))){
var inst_74829 = (state_74831[(2)]);
var state_74831__$1 = state_74831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74831__$1,inst_74829);
} else {
if((state_val_74832 === (10))){
var state_74831__$1 = state_74831;
var statearr_74850_74912 = state_74831__$1;
(statearr_74850_74912[(2)] = null);

(statearr_74850_74912[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74832 === (8))){
var inst_74816 = (state_74831[(2)]);
var state_74831__$1 = state_74831;
var statearr_74851_74913 = state_74831__$1;
(statearr_74851_74913[(2)] = inst_74816);

(statearr_74851_74913[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74852 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74852[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74852[(1)] = (1));

return statearr_74852;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74831){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74831);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74853){var ex__13886__auto__ = e74853;
var statearr_74854_74914 = state_74831;
(statearr_74854_74914[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74831[(4)]))){
var statearr_74855_74915 = state_74831;
(statearr_74855_74915[(1)] = cljs.core.first((state_74831[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74916 = state_74831;
state_74831 = G__74916;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74831){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74856 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74856[(6)] = c__13957__auto__);

return statearr_74856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74960){
var state_val_74961 = (state_74960[(1)]);
if((state_val_74961 === (7))){
var state_74960__$1 = state_74960;
var statearr_74962_74988 = state_74960__$1;
(statearr_74962_74988[(2)] = null);

(statearr_74962_74988[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (1))){
var state_74960__$1 = state_74960;
var statearr_74963_74989 = state_74960__$1;
(statearr_74963_74989[(2)] = null);

(statearr_74963_74989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (4))){
var inst_74917 = (state_74960[(2)]);
var state_74960__$1 = state_74960;
var statearr_74964_74990 = state_74960__$1;
(statearr_74964_74990[(2)] = inst_74917);

(statearr_74964_74990[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (6))){
var inst_74939 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_74960__$1 = state_74960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74960__$1,(9),inst_74939);
} else {
if((state_val_74961 === (3))){
var inst_74958 = (state_74960[(2)]);
var state_74960__$1 = state_74960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74960__$1,inst_74958);
} else {
if((state_val_74961 === (12))){
var inst_74952 = (state_74960[(2)]);
var state_74960__$1 = state_74960;
var statearr_74965_74991 = state_74960__$1;
(statearr_74965_74991[(2)] = inst_74952);

(statearr_74965_74991[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (2))){
var inst_74923 = (state_74960[(7)]);
var inst_74928 = (state_74960[(8)]);
var inst_74933 = (state_74960[(9)]);
var _ = (function (){var statearr_74966 = state_74960;
(statearr_74966[(4)] = cljs.core.cons((5),(state_74960[(4)])));

return statearr_74966;
})();
var inst_74923__$1 = fluree.db.util.core.random_uuid();
var inst_74924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74925 = [conn_id,cljs.core.cst$kw$ws];
var inst_74926 = (new cljs.core.PersistentVector(null,2,(5),inst_74924,inst_74925,null));
var inst_74927 = (function (){var lock_id = inst_74923__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_74928__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_74926,inst_74927);
var inst_74929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74930 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_74931 = (new cljs.core.PersistentVector(null,3,(5),inst_74929,inst_74930,null));
var inst_74932 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74928__$1,inst_74931);
var inst_74933__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74923__$1,inst_74932);
var inst_74934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74935 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74936 = (new cljs.core.PersistentVector(null,3,(5),inst_74934,inst_74935,null));
var inst_74937 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74928__$1,inst_74936);
var state_74960__$1 = (function (){var statearr_74967 = state_74960;
(statearr_74967[(7)] = inst_74923__$1);

(statearr_74967[(8)] = inst_74928__$1);

(statearr_74967[(10)] = inst_74937);

(statearr_74967[(9)] = inst_74933__$1);

return statearr_74967;
})();
if(inst_74933__$1){
var statearr_74968_74992 = state_74960__$1;
(statearr_74968_74992[(1)] = (6));

} else {
var statearr_74969_74993 = state_74960__$1;
(statearr_74969_74993[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (11))){
var inst_74943 = (state_74960[(11)]);
var inst_74944 = (state_74960[(12)]);
var inst_74937 = (state_74960[(10)]);
var inst_74950 = fluree.db.util.xhttp.try_socket(inst_74943,sub_chan,pub_chan,inst_74937,(60000),inst_74944);
var state_74960__$1 = state_74960;
var statearr_74971_74994 = state_74960__$1;
(statearr_74971_74994[(2)] = inst_74950);

(statearr_74971_74994[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (9))){
var inst_74943 = (state_74960[(11)]);
var inst_74923 = (state_74960[(7)]);
var inst_74928 = (state_74960[(8)]);
var inst_74941 = (state_74960[(13)]);
var inst_74937 = (state_74960[(10)]);
var inst_74933 = (state_74960[(9)]);
var inst_74941__$1 = (state_74960[(2)]);
var inst_74942 = clojure.string.replace(inst_74941__$1,"http","ws");
var inst_74943__$1 = [inst_74942,"/fdb/ws"].join('');
var inst_74944 = (function (){var lock_id = inst_74923;
var state = inst_74928;
var have_lock_QMARK_ = inst_74933;
var resp_chan = inst_74937;
var healthy_server = inst_74941__$1;
var ws_url = inst_74943__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_74945 = fluree.db.util.core.exception_QMARK_(inst_74941__$1);
var state_74960__$1 = (function (){var statearr_74972 = state_74960;
(statearr_74972[(11)] = inst_74943__$1);

(statearr_74972[(13)] = inst_74941__$1);

(statearr_74972[(12)] = inst_74944);

return statearr_74972;
})();
if(inst_74945){
var statearr_74973_74995 = state_74960__$1;
(statearr_74973_74995[(1)] = (10));

} else {
var statearr_74974_74996 = state_74960__$1;
(statearr_74974_74996[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (5))){
var _ = (function (){var statearr_74975 = state_74960;
(statearr_74975[(4)] = cljs.core.rest((state_74960[(4)])));

return statearr_74975;
})();
var state_74960__$1 = state_74960;
var ex74970 = (state_74960__$1[(2)]);
var statearr_74976_74997 = state_74960__$1;
(statearr_74976_74997[(5)] = ex74970);


if((ex74970 instanceof Error)){
var statearr_74977_74998 = state_74960__$1;
(statearr_74977_74998[(1)] = (4));

(statearr_74977_74998[(5)] = null);

} else {
throw ex74970;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (10))){
var inst_74941 = (state_74960[(13)]);
var inst_74937 = (state_74960[(10)]);
var inst_74947 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_74948 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74937,inst_74941);
var state_74960__$1 = (function (){var statearr_74978 = state_74960;
(statearr_74978[(14)] = inst_74947);

return statearr_74978;
})();
var statearr_74979_74999 = state_74960__$1;
(statearr_74979_74999[(2)] = inst_74948);

(statearr_74979_74999[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (8))){
var inst_74937 = (state_74960[(10)]);
var inst_74955 = (state_74960[(2)]);
var _ = (function (){var statearr_74980 = state_74960;
(statearr_74980[(4)] = cljs.core.rest((state_74960[(4)])));

return statearr_74980;
})();
var state_74960__$1 = (function (){var statearr_74981 = state_74960;
(statearr_74981[(15)] = inst_74955);

return statearr_74981;
})();
var statearr_74982_75000 = state_74960__$1;
(statearr_74982_75000[(2)] = inst_74937);

(statearr_74982_75000[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__13883__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_74983 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74983[(0)] = fluree$db$connection$establish_socket_$_state_machine__13883__auto__);

(statearr_74983[(1)] = (1));

return statearr_74983;
});
var fluree$db$connection$establish_socket_$_state_machine__13883__auto____1 = (function (state_74960){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74960);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74984){var ex__13886__auto__ = e74984;
var statearr_74985_75001 = state_74960;
(statearr_74985_75001[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74960[(4)]))){
var statearr_74986_75002 = state_74960;
(statearr_74986_75002[(1)] = cljs.core.first((state_74960[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75003 = state_74960;
state_74960 = G__75003;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__13883__auto__ = function(state_74960){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__13883__auto____1.call(this,state_74960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__13883__auto____0;
fluree$db$connection$establish_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__13883__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74987 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74987[(6)] = c__13957__auto__);

return statearr_74987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k75005,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__75009 = k75005;
var G__75009__$1 = (((G__75009 instanceof cljs.core.Keyword))?G__75009.fqn:null);
switch (G__75009__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k75005,else__4418__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__75010){
var vec__75011 = p__75010;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75011,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75011,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__75004){
var self__ = this;
var G__75004__$1 = this;
return (new cljs.core.RecordIter((0),G__75004__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__75014 = (function (coll__4412__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__75014(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this75006,other75007){
var self__ = this;
var this75006__$1 = this;
return (((!((other75007 == null)))) && ((this75006__$1.constructor === other75007.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.id,other75007.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.servers,other75007.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.state,other75007.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.req_chan,other75007.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.sub_chan,other75007.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.pub_chan,other75007.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.storage_read,other75007.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.storage_write,other75007.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.object_cache,other75007.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.parallelism,other75007.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.serializer,other75007.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.default_network,other75007.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.transactor_QMARK_,other75007.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.publish,other75007.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.transact_handler,other75007.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.tx_private_key,other75007.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.tx_key_id,other75007.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.meta,other75007.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.add_listener,other75007.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.remove_listener,other75007.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.close,other75007.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75006__$1.__extmap,other75007.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__75004){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__75015 = cljs.core.keyword_identical_QMARK_;
var expr__75016 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__75018 = cljs.core.cst$kw$id;
var G__75019 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75018,G__75019) : pred__75015.call(null,G__75018,G__75019));
})())){
return (new fluree.db.connection.Connection(G__75004,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75020 = cljs.core.cst$kw$servers;
var G__75021 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75020,G__75021) : pred__75015.call(null,G__75020,G__75021));
})())){
return (new fluree.db.connection.Connection(self__.id,G__75004,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75022 = cljs.core.cst$kw$state;
var G__75023 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75022,G__75023) : pred__75015.call(null,G__75022,G__75023));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__75004,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75024 = cljs.core.cst$kw$req_DASH_chan;
var G__75025 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75024,G__75025) : pred__75015.call(null,G__75024,G__75025));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__75004,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75026 = cljs.core.cst$kw$sub_DASH_chan;
var G__75027 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75026,G__75027) : pred__75015.call(null,G__75026,G__75027));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__75004,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75028 = cljs.core.cst$kw$pub_DASH_chan;
var G__75029 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75028,G__75029) : pred__75015.call(null,G__75028,G__75029));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__75004,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75030 = cljs.core.cst$kw$storage_DASH_read;
var G__75031 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75030,G__75031) : pred__75015.call(null,G__75030,G__75031));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__75004,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75032 = cljs.core.cst$kw$storage_DASH_write;
var G__75033 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75032,G__75033) : pred__75015.call(null,G__75032,G__75033));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__75004,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75034 = cljs.core.cst$kw$object_DASH_cache;
var G__75035 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75034,G__75035) : pred__75015.call(null,G__75034,G__75035));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__75004,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75036 = cljs.core.cst$kw$parallelism;
var G__75037 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75036,G__75037) : pred__75015.call(null,G__75036,G__75037));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__75004,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75038 = cljs.core.cst$kw$serializer;
var G__75039 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75038,G__75039) : pred__75015.call(null,G__75038,G__75039));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__75004,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75040 = cljs.core.cst$kw$default_DASH_network;
var G__75041 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75040,G__75041) : pred__75015.call(null,G__75040,G__75041));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__75004,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75042 = cljs.core.cst$kw$transactor_QMARK_;
var G__75043 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75042,G__75043) : pred__75015.call(null,G__75042,G__75043));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__75004,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75044 = cljs.core.cst$kw$publish;
var G__75045 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75044,G__75045) : pred__75015.call(null,G__75044,G__75045));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__75004,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75046 = cljs.core.cst$kw$transact_DASH_handler;
var G__75047 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75046,G__75047) : pred__75015.call(null,G__75046,G__75047));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__75004,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75048 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__75049 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75048,G__75049) : pred__75015.call(null,G__75048,G__75049));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__75004,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75050 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__75051 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75050,G__75051) : pred__75015.call(null,G__75050,G__75051));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__75004,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75052 = cljs.core.cst$kw$meta;
var G__75053 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75052,G__75053) : pred__75015.call(null,G__75052,G__75053));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__75004,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75054 = cljs.core.cst$kw$add_DASH_listener;
var G__75055 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75054,G__75055) : pred__75015.call(null,G__75054,G__75055));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__75004,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75056 = cljs.core.cst$kw$remove_DASH_listener;
var G__75057 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75056,G__75057) : pred__75015.call(null,G__75056,G__75057));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__75004,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__75058 = cljs.core.cst$kw$close;
var G__75059 = expr__75016;
return (pred__75015.cljs$core$IFn$_invoke$arity$2 ? pred__75015.cljs$core$IFn$_invoke$arity$2(G__75058,G__75059) : pred__75015.call(null,G__75058,G__75059));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__75004,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__75004),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__75004){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__75004,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__75008){
var extmap__4454__auto__ = (function (){var G__75060 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__75008,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__75008)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__75060);
} else {
return G__75060;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__75008),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__75008),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__75065 = servers_STAR_;
var vec__75066 = G__75065;
var seq__75067 = cljs.core.seq(vec__75066);
var first__75068 = cljs.core.first(seq__75067);
var seq__75067__$1 = cljs.core.next(seq__75067);
var server = first__75068;
var r = seq__75067__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__75065__$1 = G__75065;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__75072 = G__75065__$1;
var seq__75073 = cljs.core.seq(vec__75072);
var first__75074 = cljs.core.first(seq__75073);
var seq__75073__$1 = cljs.core.next(seq__75073);
var server__$1 = first__75074;
var r__$1 = seq__75073__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4149__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__75075 = r__$1;
var G__75076 = is_https_QMARK_;
var G__75077 = result_STAR_;
G__75065__$1 = G__75075;
https_QMARK___$1 = G__75076;
result__$1 = G__75077;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__75078 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__75078 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__75078);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75107){
var state_val_75108 = (state_75107[(1)]);
if((state_val_75108 === (7))){
var inst_75093 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75094 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75095 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75096 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75097 = fluree.db.connection.establish_socket(inst_75093,inst_75094,inst_75095,inst_75096);
var state_75107__$1 = state_75107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75107__$1,(9),inst_75097);
} else {
if((state_val_75108 === (1))){
var state_75107__$1 = state_75107;
var statearr_75109_75128 = state_75107__$1;
(statearr_75109_75128[(2)] = null);

(statearr_75109_75128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (4))){
var inst_75079 = (state_75107[(2)]);
var state_75107__$1 = state_75107;
var statearr_75110_75129 = state_75107__$1;
(statearr_75110_75129[(2)] = inst_75079);

(statearr_75110_75129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (6))){
var inst_75090 = (state_75107[(7)]);
var state_75107__$1 = state_75107;
var statearr_75111_75130 = state_75107__$1;
(statearr_75111_75130[(2)] = inst_75090);

(statearr_75111_75130[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (3))){
var inst_75105 = (state_75107[(2)]);
var state_75107__$1 = state_75107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75107__$1,inst_75105);
} else {
if((state_val_75108 === (2))){
var inst_75090 = (state_75107[(7)]);
var _ = (function (){var statearr_75113 = state_75107;
(statearr_75113[(4)] = cljs.core.cons((5),(state_75107[(4)])));

return statearr_75113;
})();
var inst_75085 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_75086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75087 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75088 = [inst_75087,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_75089 = (new cljs.core.PersistentVector(null,3,(5),inst_75086,inst_75088,null));
var inst_75090__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_75085,inst_75089);
var state_75107__$1 = (function (){var statearr_75114 = state_75107;
(statearr_75114[(7)] = inst_75090__$1);

return statearr_75114;
})();
if(cljs.core.truth_(inst_75090__$1)){
var statearr_75115_75131 = state_75107__$1;
(statearr_75115_75131[(1)] = (6));

} else {
var statearr_75116_75132 = state_75107__$1;
(statearr_75116_75132[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (9))){
var inst_75099 = (state_75107[(2)]);
var inst_75100 = fluree.db.util.async.throw_err(inst_75099);
var state_75107__$1 = state_75107;
var statearr_75117_75133 = state_75107__$1;
(statearr_75117_75133[(2)] = inst_75100);

(statearr_75117_75133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (5))){
var _ = (function (){var statearr_75118 = state_75107;
(statearr_75118[(4)] = cljs.core.rest((state_75107[(4)])));

return statearr_75118;
})();
var state_75107__$1 = state_75107;
var ex75112 = (state_75107__$1[(2)]);
var statearr_75119_75134 = state_75107__$1;
(statearr_75119_75134[(5)] = ex75112);


if((ex75112 instanceof Error)){
var statearr_75120_75135 = state_75107__$1;
(statearr_75120_75135[(1)] = (4));

(statearr_75120_75135[(5)] = null);

} else {
throw ex75112;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75108 === (8))){
var inst_75102 = (state_75107[(2)]);
var _ = (function (){var statearr_75121 = state_75107;
(statearr_75121[(4)] = cljs.core.rest((state_75107[(4)])));

return statearr_75121;
})();
var state_75107__$1 = state_75107;
var statearr_75122_75136 = state_75107__$1;
(statearr_75122_75136[(2)] = inst_75102);

(statearr_75122_75136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__13883__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_75123 = [null,null,null,null,null,null,null,null];
(statearr_75123[(0)] = fluree$db$connection$get_socket_$_state_machine__13883__auto__);

(statearr_75123[(1)] = (1));

return statearr_75123;
});
var fluree$db$connection$get_socket_$_state_machine__13883__auto____1 = (function (state_75107){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75107);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75124){var ex__13886__auto__ = e75124;
var statearr_75125_75137 = state_75107;
(statearr_75125_75137[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75107[(4)]))){
var statearr_75126_75138 = state_75107;
(statearr_75126_75138[(1)] = cljs.core.first((state_75107[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75139 = state_75107;
state_75107 = G__75139;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__13883__auto__ = function(state_75107){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__13883__auto____1.call(this,state_75107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__13883__auto____0;
fluree$db$connection$get_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__13883__auto____1;
return fluree$db$connection$get_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75127 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75127[(6)] = c__13957__auto__);

return statearr_75127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e75140){var e = e75140;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4160__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75267){
var state_val_75268 = (state_75267[(1)]);
if((state_val_75268 === (7))){
var inst_75263 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75270_75340 = state_75267__$1;
(statearr_75270_75340[(2)] = inst_75263);

(statearr_75270_75340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (20))){
var _ = (function (){var statearr_75271 = state_75267;
(statearr_75271[(4)] = cljs.core.rest((state_75267[(4)])));

return statearr_75271;
})();
var state_75267__$1 = state_75267;
var ex75269 = (state_75267__$1[(2)]);
var statearr_75272_75341 = state_75267__$1;
(statearr_75272_75341[(5)] = ex75269);


var statearr_75273_75342 = state_75267__$1;
(statearr_75273_75342[(1)] = (10));

(statearr_75273_75342[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (27))){
var inst_75255 = (state_75267[(2)]);
var _ = (function (){var statearr_75274 = state_75267;
(statearr_75274[(4)] = cljs.core.rest((state_75267[(4)])));

return statearr_75274;
})();
var state_75267__$1 = state_75267;
var statearr_75275_75343 = state_75267__$1;
(statearr_75275_75343[(2)] = inst_75255);

(statearr_75275_75343[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (1))){
var inst_75142 = (0);
var state_75267__$1 = (function (){var statearr_75276 = state_75267;
(statearr_75276[(7)] = inst_75142);

return statearr_75276;
})();
var statearr_75277_75344 = state_75267__$1;
(statearr_75277_75344[(2)] = null);

(statearr_75277_75344[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (24))){
var inst_75233 = (state_75267[(8)]);
var inst_75233__$1 = (state_75267[(2)]);
var inst_75234 = inst_75233__$1 === true;
var state_75267__$1 = (function (){var statearr_75278 = state_75267;
(statearr_75278[(8)] = inst_75233__$1);

return statearr_75278;
})();
if(cljs.core.truth_(inst_75234)){
var statearr_75279_75345 = state_75267__$1;
(statearr_75279_75345[(1)] = (25));

} else {
var statearr_75280_75346 = state_75267__$1;
(statearr_75280_75346[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (4))){
var inst_75145 = (state_75267[(9)]);
var inst_75145__$1 = (state_75267[(2)]);
var state_75267__$1 = (function (){var statearr_75281 = state_75267;
(statearr_75281[(9)] = inst_75145__$1);

return statearr_75281;
})();
if(cljs.core.truth_(inst_75145__$1)){
var statearr_75282_75347 = state_75267__$1;
(statearr_75282_75347[(1)] = (5));

} else {
var statearr_75283_75348 = state_75267__$1;
(statearr_75283_75348[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (15))){
var inst_75158 = (state_75267[(10)]);
var state_75267__$1 = state_75267;
var statearr_75284_75349 = state_75267__$1;
(statearr_75284_75349[(2)] = inst_75158);

(statearr_75284_75349[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (21))){
var inst_75142 = (state_75267[(7)]);
var inst_75145 = (state_75267[(9)]);
var inst_75184 = (state_75267[(11)]);
var inst_75190 = (state_75267[(12)]);
var inst_75186 = (state_75267[(13)]);
var inst_75182 = (state_75267[(14)]);
var inst_75185 = (state_75267[(15)]);
var inst_75189 = (state_75267[(16)]);
var inst_75183 = (state_75267[(17)]);
var inst_75181 = (state_75267[(18)]);
var inst_75192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75193 = [cljs.core.cst$kw$pending_DASH_req,inst_75189];
var inst_75194 = (new cljs.core.PersistentVector(null,2,(5),inst_75192,inst_75193,null));
var inst_75195 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_75194,inst_75184);
var inst_75222 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75223 = (function (){var resp_chan = inst_75184;
var timeout = inst_75190;
var i = inst_75142;
var data = inst_75183;
var vec__75177 = inst_75145;
var _ = inst_75181;
var req_id = inst_75189;
var operation = inst_75182;
var c__13957__auto____$1 = inst_75222;
var msg = inst_75145;
var map__75180 = inst_75186;
var opts = inst_75185;
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75220){
var state_val_75221 = (state_75220[(1)]);
if((state_val_75221 === (1))){
var inst_75199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75200 = cljs.core.async.timeout(timeout);
var inst_75201 = [resp_chan,inst_75200];
var inst_75202 = (new cljs.core.PersistentVector(null,2,(5),inst_75199,inst_75201,null));
var state_75220__$1 = state_75220;
return cljs.core.async.ioc_alts_BANG_(state_75220__$1,(2),inst_75202);
} else {
if((state_val_75221 === (2))){
var inst_75205 = (state_75220[(7)]);
var inst_75204 = (state_75220[(2)]);
var inst_75205__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75204,(0),null);
var inst_75206 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75204,(1),null);
var inst_75207 = (function (){var vec__75196 = inst_75204;
var resp = inst_75205__$1;
var c = inst_75206;
return (function (p1__75141_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__75141_SHARP_,req_id);
});
})();
var inst_75208 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_75207);
var inst_75209 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75206,resp_chan);
var state_75220__$1 = (function (){var statearr_75285 = state_75220;
(statearr_75285[(7)] = inst_75205__$1);

(statearr_75285[(8)] = inst_75208);

return statearr_75285;
})();
if(inst_75209){
var statearr_75286_75350 = state_75220__$1;
(statearr_75286_75350[(1)] = (3));

} else {
var statearr_75287_75351 = state_75220__$1;
(statearr_75287_75351[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75221 === (3))){
var inst_75205 = (state_75220[(7)]);
var state_75220__$1 = state_75220;
var statearr_75288_75352 = state_75220__$1;
(statearr_75288_75352[(2)] = inst_75205);

(statearr_75288_75352[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75221 === (4))){
var inst_75212 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_75213 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75214 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_75215 = cljs.core.PersistentHashMap.fromArrays(inst_75213,inst_75214);
var inst_75216 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75212,inst_75215);
var state_75220__$1 = state_75220;
var statearr_75289_75353 = state_75220__$1;
(statearr_75289_75353[(2)] = inst_75216);

(statearr_75289_75353[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75221 === (5))){
var inst_75218 = (state_75220[(2)]);
var state_75220__$1 = state_75220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75220__$1,inst_75218);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____0 = (function (){
var statearr_75290 = [null,null,null,null,null,null,null,null,null];
(statearr_75290[(0)] = fluree$db$connection$msg_producer_$_state_machine__13883__auto__);

(statearr_75290[(1)] = (1));

return statearr_75290;
});
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____1 = (function (state_75220){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75220);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75291){var ex__13886__auto__ = e75291;
var statearr_75292_75354 = state_75220;
(statearr_75292_75354[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75220[(4)]))){
var statearr_75293_75355 = state_75220;
(statearr_75293_75355[(1)] = cljs.core.first((state_75220[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75356 = state_75220;
state_75220 = G__75356;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = function(state_75220){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____1.call(this,state_75220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75294 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75294[(6)] = c__13957__auto____$1);

return statearr_75294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});
})();
var inst_75224 = cljs.core.async.impl.dispatch.run(inst_75223);
var state_75267__$1 = (function (){var statearr_75295 = state_75267;
(statearr_75295[(19)] = inst_75224);

(statearr_75295[(20)] = inst_75195);

return statearr_75295;
})();
var statearr_75296_75357 = state_75267__$1;
(statearr_75296_75357[(2)] = inst_75222);

(statearr_75296_75357[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (31))){
var inst_75243 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_75267__$1 = state_75267;
var statearr_75297_75358 = state_75267__$1;
(statearr_75297_75358[(2)] = inst_75243);

(statearr_75297_75358[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (32))){
var state_75267__$1 = state_75267;
var statearr_75298_75359 = state_75267__$1;
(statearr_75298_75359[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (33))){
var inst_75251 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75300_75360 = state_75267__$1;
(statearr_75300_75360[(2)] = inst_75251);

(statearr_75300_75360[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (13))){
var inst_75158 = (state_75267[(10)]);
var inst_75155 = (state_75267[(2)]);
var inst_75156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75155,(0),null);
var inst_75157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75155,(1),null);
var inst_75158__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75155,(2),null);
var state_75267__$1 = (function (){var statearr_75301 = state_75267;
(statearr_75301[(21)] = inst_75156);

(statearr_75301[(10)] = inst_75158__$1);

(statearr_75301[(22)] = inst_75157);

return statearr_75301;
})();
if(cljs.core.truth_(inst_75158__$1)){
var statearr_75302_75361 = state_75267__$1;
(statearr_75302_75361[(1)] = (14));

} else {
var statearr_75303_75362 = state_75267__$1;
(statearr_75303_75362[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (22))){
var state_75267__$1 = state_75267;
var statearr_75304_75363 = state_75267__$1;
(statearr_75304_75363[(2)] = null);

(statearr_75304_75363[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (36))){
var inst_75249 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75305_75364 = state_75267__$1;
(statearr_75305_75364[(2)] = inst_75249);

(statearr_75305_75364[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (29))){
var inst_75233 = (state_75267[(8)]);
var inst_75241 = (inst_75233 == null);
var state_75267__$1 = state_75267;
if(cljs.core.truth_(inst_75241)){
var statearr_75306_75365 = state_75267__$1;
(statearr_75306_75365[(1)] = (31));

} else {
var statearr_75307_75366 = state_75267__$1;
(statearr_75307_75366[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (6))){
var state_75267__$1 = state_75267;
var statearr_75308_75367 = state_75267__$1;
(statearr_75308_75367[(2)] = null);

(statearr_75308_75367[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (28))){
var inst_75233 = (state_75267[(8)]);
var inst_75239 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75233,"Error processing message in producer."], 0));
var state_75267__$1 = state_75267;
var statearr_75309_75368 = state_75267__$1;
(statearr_75309_75368[(2)] = inst_75239);

(statearr_75309_75368[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (25))){
var state_75267__$1 = state_75267;
var statearr_75310_75369 = state_75267__$1;
(statearr_75310_75369[(2)] = null);

(statearr_75310_75369[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (34))){
var inst_75233 = (state_75267[(8)]);
var inst_75246 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_75233], 0));
var state_75267__$1 = state_75267;
var statearr_75311_75370 = state_75267__$1;
(statearr_75311_75370[(2)] = inst_75246);

(statearr_75311_75370[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (17))){
var inst_75147 = (state_75267[(23)]);
var inst_75158 = (state_75267[(10)]);
var inst_75165 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75158,inst_75147);
var state_75267__$1 = state_75267;
var statearr_75312_75371 = state_75267__$1;
(statearr_75312_75371[(2)] = inst_75165);

(statearr_75312_75371[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (3))){
var inst_75265 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75267__$1,inst_75265);
} else {
if((state_val_75268 === (12))){
var state_75267__$1 = state_75267;
var statearr_75313_75372 = state_75267__$1;
(statearr_75313_75372[(2)] = null);

(statearr_75313_75372[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (2))){
var state_75267__$1 = state_75267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75267__$1,(4),req_chan);
} else {
if((state_val_75268 === (23))){
var inst_75182 = (state_75267[(14)]);
var inst_75189 = (state_75267[(16)]);
var inst_75183 = (state_75267[(17)]);
var inst_75227 = (state_75267[(2)]);
var inst_75228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75229 = [inst_75182,inst_75189,inst_75183];
var inst_75230 = (new cljs.core.PersistentVector(null,3,(5),inst_75228,inst_75229,null));
var inst_75231 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_75230) : publish_fn.call(null,conn,inst_75230));
var state_75267__$1 = (function (){var statearr_75314 = state_75267;
(statearr_75314[(24)] = inst_75227);

return statearr_75314;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75267__$1,(24),inst_75231);
} else {
if((state_val_75268 === (35))){
var state_75267__$1 = state_75267;
var statearr_75315_75373 = state_75267__$1;
(statearr_75315_75373[(2)] = null);

(statearr_75315_75373[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (19))){
var inst_75171 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75316_75374 = state_75267__$1;
(statearr_75316_75374[(2)] = inst_75171);

(statearr_75316_75374[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (11))){
var inst_75145 = (state_75267[(9)]);
var state_75267__$1 = state_75267;
var statearr_75317_75375 = state_75267__$1;
(statearr_75317_75375[(2)] = inst_75145);

(statearr_75317_75375[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (9))){
var inst_75142 = (state_75267[(7)]);
var inst_75258 = (state_75267[(2)]);
var inst_75259 = (inst_75142 + (1));
var inst_75142__$1 = inst_75259;
var state_75267__$1 = (function (){var statearr_75318 = state_75267;
(statearr_75318[(7)] = inst_75142__$1);

(statearr_75318[(25)] = inst_75258);

return statearr_75318;
})();
var statearr_75319_75376 = state_75267__$1;
(statearr_75319_75376[(2)] = null);

(statearr_75319_75376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (5))){
var state_75267__$1 = state_75267;
var statearr_75320_75377 = state_75267__$1;
(statearr_75320_75377[(2)] = null);

(statearr_75320_75377[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (14))){
var inst_75158 = (state_75267[(10)]);
var inst_75160 = fluree.db.util.async.channel_QMARK_(inst_75158);
var state_75267__$1 = state_75267;
var statearr_75321_75378 = state_75267__$1;
(statearr_75321_75378[(2)] = inst_75160);

(statearr_75321_75378[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (26))){
var inst_75233 = (state_75267[(8)]);
var inst_75237 = fluree.db.util.core.exception_QMARK_(inst_75233);
var state_75267__$1 = state_75267;
if(inst_75237){
var statearr_75322_75379 = state_75267__$1;
(statearr_75322_75379[(1)] = (28));

} else {
var statearr_75323_75380 = state_75267__$1;
(statearr_75323_75380[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (16))){
var inst_75163 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
if(cljs.core.truth_(inst_75163)){
var statearr_75324_75381 = state_75267__$1;
(statearr_75324_75381[(1)] = (17));

} else {
var statearr_75325_75382 = state_75267__$1;
(statearr_75325_75382[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (30))){
var inst_75253 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75326_75383 = state_75267__$1;
(statearr_75326_75383[(2)] = inst_75253);

(statearr_75326_75383[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (10))){
var inst_75145 = (state_75267[(9)]);
var inst_75147 = (state_75267[(2)]);
var inst_75151 = cljs.core.sequential_QMARK_(inst_75145);
var state_75267__$1 = (function (){var statearr_75327 = state_75267;
(statearr_75327[(23)] = inst_75147);

return statearr_75327;
})();
if(inst_75151){
var statearr_75328_75384 = state_75267__$1;
(statearr_75328_75384[(1)] = (11));

} else {
var statearr_75329_75385 = state_75267__$1;
(statearr_75329_75385[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (18))){
var inst_75147 = (state_75267[(23)]);
var inst_75145 = (state_75267[(9)]);
var inst_75167 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75145], 0));
var inst_75168 = ["Error processing ledger request, no valid return channel: ",inst_75167].join('');
var inst_75169 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75147,inst_75168], 0));
var state_75267__$1 = state_75267;
var statearr_75330_75386 = state_75267__$1;
(statearr_75330_75386[(2)] = inst_75169);

(statearr_75330_75386[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75268 === (8))){
var inst_75145 = (state_75267[(9)]);
var inst_75184 = (state_75267[(11)]);
var inst_75186 = (state_75267[(13)]);
var inst_75185 = (state_75267[(15)]);
var _ = (function (){var statearr_75331 = state_75267;
(statearr_75331[(4)] = cljs.core.cons((20),(state_75267[(4)])));

return statearr_75331;
})();
var inst_75181 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_75145], 0));
var inst_75182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75145,(0),null);
var inst_75183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75145,(1),null);
var inst_75184__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75145,(2),null);
var inst_75185__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75145,(3),null);
var inst_75186__$1 = cljs.core.__destructure_map(inst_75185__$1);
var inst_75187 = fluree.db.util.core.random_uuid();
var inst_75188 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75187);
var inst_75189 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75186__$1,cljs.core.cst$kw$req_DASH_id,inst_75188);
var inst_75190 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75186__$1,cljs.core.cst$kw$timeout,(60000));
var state_75267__$1 = (function (){var statearr_75332 = state_75267;
(statearr_75332[(11)] = inst_75184__$1);

(statearr_75332[(12)] = inst_75190);

(statearr_75332[(13)] = inst_75186__$1);

(statearr_75332[(14)] = inst_75182);

(statearr_75332[(15)] = inst_75185__$1);

(statearr_75332[(16)] = inst_75189);

(statearr_75332[(17)] = inst_75183);

(statearr_75332[(18)] = inst_75181);

return statearr_75332;
})();
if(cljs.core.truth_(inst_75184__$1)){
var statearr_75333_75387 = state_75267__$1;
(statearr_75333_75387[(1)] = (21));

} else {
var statearr_75334_75388 = state_75267__$1;
(statearr_75334_75388[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____0 = (function (){
var statearr_75335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75335[(0)] = fluree$db$connection$msg_producer_$_state_machine__13883__auto__);

(statearr_75335[(1)] = (1));

return statearr_75335;
});
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____1 = (function (state_75267){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75267);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75336){var ex__13886__auto__ = e75336;
var statearr_75337_75389 = state_75267;
(statearr_75337_75389[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75267[(4)]))){
var statearr_75338_75390 = state_75267;
(statearr_75338_75390[(1)] = cljs.core.first((state_75267[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75391 = state_75267;
state_75267 = G__75391;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = function(state_75267){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____1.call(this,state_75267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75339 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75339[(6)] = c__13957__auto__);

return statearr_75339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__75392 = conn;
var map__75392__$1 = cljs.core.__destructure_map(map__75392);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75392__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75474){
var state_val_75475 = (state_75474[(1)]);
if((state_val_75475 === (7))){
var inst_75470 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75476_75527 = state_75474__$1;
(statearr_75476_75527[(2)] = inst_75470);

(statearr_75476_75527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (20))){
var inst_75411 = (state_75474[(7)]);
var inst_75425 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_75426 = [inst_75411];
var inst_75427 = cljs.core.PersistentHashMap.fromArrays(inst_75425,inst_75426);
var inst_75428 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_75427], 0));
var state_75474__$1 = state_75474;
var statearr_75477_75528 = state_75474__$1;
(statearr_75477_75528[(2)] = inst_75428);

(statearr_75477_75528[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (27))){
var state_75474__$1 = state_75474;
var statearr_75478_75529 = state_75474__$1;
(statearr_75478_75529[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (1))){
var inst_75393 = (0);
var state_75474__$1 = (function (){var statearr_75480 = state_75474;
(statearr_75480[(8)] = inst_75393);

return statearr_75480;
})();
var statearr_75481_75530 = state_75474__$1;
(statearr_75481_75530[(2)] = null);

(statearr_75481_75530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (24))){
var inst_75404 = (state_75474[(9)]);
var inst_75453 = fluree.db.util.core.exception_QMARK_(inst_75404);
var state_75474__$1 = state_75474;
if(inst_75453){
var statearr_75482_75531 = state_75474__$1;
(statearr_75482_75531[(1)] = (26));

} else {
var statearr_75483_75532 = state_75474__$1;
(statearr_75483_75532[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (4))){
var inst_75398 = (state_75474[(10)]);
var inst_75403 = (state_75474[(2)]);
var inst_75404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75403,(0),null);
var inst_75405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75403,(1),null);
var inst_75406 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75405,inst_75398);
var state_75474__$1 = (function (){var statearr_75484 = state_75474;
(statearr_75484[(9)] = inst_75404);

return statearr_75484;
})();
if(inst_75406){
var statearr_75485_75533 = state_75474__$1;
(statearr_75485_75533[(1)] = (5));

} else {
var statearr_75486_75534 = state_75474__$1;
(statearr_75486_75534[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (15))){
var inst_75411 = (state_75474[(7)]);
var inst_75420 = typeof inst_75411 === 'string';
var state_75474__$1 = state_75474;
if(cljs.core.truth_(inst_75420)){
var statearr_75487_75535 = state_75474__$1;
(statearr_75487_75535[(1)] = (17));

} else {
var statearr_75488_75536 = state_75474__$1;
(statearr_75488_75536[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (21))){
var state_75474__$1 = state_75474;
var statearr_75489_75537 = state_75474__$1;
(statearr_75489_75537[(2)] = null);

(statearr_75489_75537[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (31))){
var inst_75464 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75490_75538 = state_75474__$1;
(statearr_75490_75538[(2)] = inst_75464);

(statearr_75490_75538[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (13))){
var inst_75437 = (state_75474[(2)]);
var inst_75438 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75439 = fluree.db.connection.close_websocket(inst_75438);
var inst_75440 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75441 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_75440);
var state_75474__$1 = (function (){var statearr_75491 = state_75474;
(statearr_75491[(11)] = inst_75439);

(statearr_75491[(12)] = inst_75437);

return statearr_75491;
})();
var statearr_75492_75539 = state_75474__$1;
(statearr_75492_75539[(2)] = inst_75441);

(statearr_75492_75539[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (22))){
var inst_75431 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75493_75540 = state_75474__$1;
(statearr_75493_75540[(2)] = inst_75431);

(statearr_75493_75540[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (29))){
var inst_75404 = (state_75474[(9)]);
var inst_75459 = fluree.db.util.json.parse(inst_75404);
var inst_75460 = fluree.db.conn_events.process_events(conn,inst_75459);
var inst_75393 = (0);
var state_75474__$1 = (function (){var statearr_75494 = state_75474;
(statearr_75494[(8)] = inst_75393);

(statearr_75494[(13)] = inst_75460);

return statearr_75494;
})();
var statearr_75495_75541 = state_75474__$1;
(statearr_75495_75541[(2)] = null);

(statearr_75495_75541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (6))){
var inst_75404 = (state_75474[(9)]);
var inst_75449 = (inst_75404 == null);
var state_75474__$1 = state_75474;
if(cljs.core.truth_(inst_75449)){
var statearr_75496_75542 = state_75474__$1;
(statearr_75496_75542[(1)] = (23));

} else {
var statearr_75497_75543 = state_75474__$1;
(statearr_75497_75543[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (28))){
var inst_75466 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75498_75544 = state_75474__$1;
(statearr_75498_75544[(2)] = inst_75466);

(statearr_75498_75544[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (25))){
var inst_75468 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75499_75545 = state_75474__$1;
(statearr_75499_75545[(2)] = inst_75468);

(statearr_75499_75545[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (17))){
var inst_75411 = (state_75474[(7)]);
var inst_75422 = cljs.core.eval(inst_75411);
var state_75474__$1 = state_75474;
var statearr_75500_75546 = state_75474__$1;
(statearr_75500_75546[(2)] = inst_75422);

(statearr_75500_75546[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (3))){
var inst_75472 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75474__$1,inst_75472);
} else {
if((state_val_75475 === (12))){
var inst_75411 = (state_75474[(7)]);
var inst_75416 = cljs.core.fn_QMARK_(inst_75411);
var state_75474__$1 = state_75474;
if(inst_75416){
var statearr_75501_75547 = state_75474__$1;
(statearr_75501_75547[(1)] = (14));

} else {
var statearr_75502_75548 = state_75474__$1;
(statearr_75502_75548[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (2))){
var inst_75398 = (state_75474[(10)]);
var inst_75398__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_75399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75400 = [sub_chan,inst_75398__$1];
var inst_75401 = (new cljs.core.PersistentVector(null,2,(5),inst_75399,inst_75400,null));
var state_75474__$1 = (function (){var statearr_75503 = state_75474;
(statearr_75503[(10)] = inst_75398__$1);

return statearr_75503;
})();
return cljs.core.async.ioc_alts_BANG_(state_75474__$1,(4),inst_75401);
} else {
if((state_val_75475 === (23))){
var inst_75451 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_75474__$1 = state_75474;
var statearr_75504_75549 = state_75474__$1;
(statearr_75504_75549[(2)] = inst_75451);

(statearr_75504_75549[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (19))){
var inst_75433 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75505_75550 = state_75474__$1;
(statearr_75505_75550[(2)] = inst_75433);

(statearr_75505_75550[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (11))){
var inst_75414 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_75474__$1 = state_75474;
var statearr_75506_75551 = state_75474__$1;
(statearr_75506_75551[(2)] = inst_75414);

(statearr_75506_75551[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (9))){
var inst_75393 = (state_75474[(8)]);
var inst_75443 = fluree.db.connection.ping_transactor(conn);
var inst_75444 = (inst_75393 + (1));
var inst_75393__$1 = inst_75444;
var state_75474__$1 = (function (){var statearr_75507 = state_75474;
(statearr_75507[(14)] = inst_75443);

(statearr_75507[(8)] = inst_75393__$1);

return statearr_75507;
})();
var statearr_75508_75552 = state_75474__$1;
(statearr_75508_75552[(2)] = null);

(statearr_75508_75552[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (5))){
var inst_75393 = (state_75474[(8)]);
var inst_75408 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_75393);
var state_75474__$1 = state_75474;
if(inst_75408){
var statearr_75509_75553 = state_75474__$1;
(statearr_75509_75553[(1)] = (8));

} else {
var statearr_75510_75554 = state_75474__$1;
(statearr_75510_75554[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (14))){
var inst_75411 = (state_75474[(7)]);
var inst_75418 = (inst_75411.cljs$core$IFn$_invoke$arity$0 ? inst_75411.cljs$core$IFn$_invoke$arity$0() : inst_75411.call(null));
var state_75474__$1 = state_75474;
var statearr_75511_75555 = state_75474__$1;
(statearr_75511_75555[(2)] = inst_75418);

(statearr_75511_75555[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (26))){
var inst_75404 = (state_75474[(9)]);
var inst_75455 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75404], 0));
var inst_75393 = (0);
var state_75474__$1 = (function (){var statearr_75512 = state_75474;
(statearr_75512[(8)] = inst_75393);

(statearr_75512[(15)] = inst_75455);

return statearr_75512;
})();
var statearr_75513_75556 = state_75474__$1;
(statearr_75513_75556[(2)] = null);

(statearr_75513_75556[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (16))){
var inst_75435 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75514_75557 = state_75474__$1;
(statearr_75514_75557[(2)] = inst_75435);

(statearr_75514_75557[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (30))){
var state_75474__$1 = state_75474;
var statearr_75515_75558 = state_75474__$1;
(statearr_75515_75558[(2)] = null);

(statearr_75515_75558[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (10))){
var inst_75447 = (state_75474[(2)]);
var state_75474__$1 = state_75474;
var statearr_75516_75559 = state_75474__$1;
(statearr_75516_75559[(2)] = inst_75447);

(statearr_75516_75559[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (18))){
var state_75474__$1 = state_75474;
var statearr_75517_75560 = state_75474__$1;
(statearr_75517_75560[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75475 === (8))){
var inst_75411 = (state_75474[(7)]);
var inst_75410 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_75411__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75412 = (inst_75411__$1 == null);
var state_75474__$1 = (function (){var statearr_75519 = state_75474;
(statearr_75519[(7)] = inst_75411__$1);

(statearr_75519[(16)] = inst_75410);

return statearr_75519;
})();
if(cljs.core.truth_(inst_75412)){
var statearr_75520_75561 = state_75474__$1;
(statearr_75520_75561[(1)] = (11));

} else {
var statearr_75521_75562 = state_75474__$1;
(statearr_75521_75562[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0 = (function (){
var statearr_75522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75522[(0)] = fluree$db$connection$msg_consumer_$_state_machine__13883__auto__);

(statearr_75522[(1)] = (1));

return statearr_75522;
});
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1 = (function (state_75474){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75474);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75523){var ex__13886__auto__ = e75523;
var statearr_75524_75563 = state_75474;
(statearr_75524_75563[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75474[(4)]))){
var statearr_75525_75564 = state_75474;
(statearr_75525_75564[(1)] = cljs.core.first((state_75474[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75565 = state_75474;
state_75474 = G__75565;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__ = function(state_75474){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1.call(this,state_75474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75526 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75526[(6)] = c__13957__auto__);

return statearr_75526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__75567 = arguments.length;
switch (G__75567) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__75568 = opts;
var map__75568__$1 = cljs.core.__destructure_map(map__75568);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75568__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75568__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75620){
var state_val_75621 = (state_75620[(1)]);
if((state_val_75621 === (7))){
var inst_75578 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_75579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75580 = [conn_id,cljs.core.cst$kw$token];
var inst_75581 = (new cljs.core.PersistentVector(null,2,(5),inst_75579,inst_75580,null));
var inst_75582 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_75578,inst_75581);
var state_75620__$1 = state_75620;
var statearr_75622_75653 = state_75620__$1;
(statearr_75622_75653[(2)] = inst_75582);

(statearr_75622_75653[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (1))){
var state_75620__$1 = state_75620;
var statearr_75623_75654 = state_75620__$1;
(statearr_75623_75654[(2)] = null);

(statearr_75623_75654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (4))){
var inst_75569 = (state_75620[(2)]);
var state_75620__$1 = state_75620;
var statearr_75624_75655 = state_75620__$1;
(statearr_75624_75655[(2)] = inst_75569);

(statearr_75624_75655[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (15))){
var inst_75589 = (state_75620[(7)]);
var inst_75608 = (state_75620[(2)]);
var inst_75609 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_75610 = [(5000),inst_75608,cljs.core.cst$kw$text];
var inst_75611 = cljs.core.PersistentHashMap.fromArrays(inst_75609,inst_75610);
var inst_75612 = fluree.db.util.xhttp.get(inst_75589,inst_75611);
var state_75620__$1 = state_75620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75620__$1,(16),inst_75612);
} else {
if((state_val_75621 === (13))){
var inst_75599 = (state_75620[(8)]);
var inst_75589 = (state_75620[(7)]);
var inst_75601 = [cljs.core.cst$kw$headers];
var inst_75602 = [inst_75599];
var inst_75603 = cljs.core.PersistentHashMap.fromArrays(inst_75601,inst_75602);
var inst_75604 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_75589,inst_75603,private$);
var inst_75605 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_75604);
var state_75620__$1 = state_75620;
var statearr_75625_75656 = state_75620__$1;
(statearr_75625_75656[(2)] = inst_75605);

(statearr_75625_75656[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (6))){
var inst_75575 = (state_75620[(9)]);
var state_75620__$1 = state_75620;
var statearr_75626_75657 = state_75620__$1;
(statearr_75626_75657[(2)] = inst_75575);

(statearr_75626_75657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (3))){
var inst_75618 = (state_75620[(2)]);
var state_75620__$1 = state_75620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75620__$1,inst_75618);
} else {
if((state_val_75621 === (12))){
var inst_75599 = (state_75620[(2)]);
var state_75620__$1 = (function (){var statearr_75627 = state_75620;
(statearr_75627[(8)] = inst_75599);

return statearr_75627;
})();
if(cljs.core.truth_(private$)){
var statearr_75628_75658 = state_75620__$1;
(statearr_75628_75658[(1)] = (13));

} else {
var statearr_75629_75659 = state_75620__$1;
(statearr_75629_75659[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (2))){
var inst_75575 = (state_75620[(9)]);
var _ = (function (){var statearr_75630 = state_75620;
(statearr_75630[(4)] = cljs.core.cons((5),(state_75620[(4)])));

return statearr_75630;
})();
var inst_75575__$1 = jwt;
var state_75620__$1 = (function (){var statearr_75631 = state_75620;
(statearr_75631[(9)] = inst_75575__$1);

return statearr_75631;
})();
if(cljs.core.truth_(inst_75575__$1)){
var statearr_75632_75660 = state_75620__$1;
(statearr_75632_75660[(1)] = (6));

} else {
var statearr_75633_75661 = state_75620__$1;
(statearr_75633_75661[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (11))){
var inst_75593 = (state_75620[(10)]);
var state_75620__$1 = state_75620;
var statearr_75635_75662 = state_75620__$1;
(statearr_75635_75662[(2)] = inst_75593);

(statearr_75635_75662[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (9))){
var inst_75584 = (state_75620[(11)]);
var inst_75585 = (state_75620[(12)]);
var inst_75588 = (state_75620[(2)]);
var inst_75589 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75588),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75585)].join('');
var inst_75591 = ["Accept"];
var inst_75592 = ["application/json"];
var inst_75593 = cljs.core.PersistentHashMap.fromArrays(inst_75591,inst_75592);
var state_75620__$1 = (function (){var statearr_75636 = state_75620;
(statearr_75636[(10)] = inst_75593);

(statearr_75636[(7)] = inst_75589);

return statearr_75636;
})();
if(cljs.core.truth_(inst_75584)){
var statearr_75637_75663 = state_75620__$1;
(statearr_75637_75663[(1)] = (10));

} else {
var statearr_75638_75664 = state_75620__$1;
(statearr_75638_75664[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (5))){
var _ = (function (){var statearr_75639 = state_75620;
(statearr_75639[(4)] = cljs.core.rest((state_75620[(4)])));

return statearr_75639;
})();
var state_75620__$1 = state_75620;
var ex75634 = (state_75620__$1[(2)]);
var statearr_75640_75665 = state_75620__$1;
(statearr_75640_75665[(5)] = ex75634);


if((ex75634 instanceof Error)){
var statearr_75641_75666 = state_75620__$1;
(statearr_75641_75666[(1)] = (4));

(statearr_75641_75666[(5)] = null);

} else {
throw ex75634;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (14))){
var inst_75599 = (state_75620[(8)]);
var state_75620__$1 = state_75620;
var statearr_75642_75667 = state_75620__$1;
(statearr_75642_75667[(2)] = inst_75599);

(statearr_75642_75667[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (16))){
var inst_75614 = (state_75620[(2)]);
var inst_75615 = fluree.db.util.async.throw_err(inst_75614);
var _ = (function (){var statearr_75643 = state_75620;
(statearr_75643[(4)] = cljs.core.rest((state_75620[(4)])));

return statearr_75643;
})();
var state_75620__$1 = state_75620;
var statearr_75644_75668 = state_75620__$1;
(statearr_75644_75668[(2)] = inst_75615);

(statearr_75644_75668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (10))){
var inst_75584 = (state_75620[(11)]);
var inst_75593 = (state_75620[(10)]);
var inst_75595 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75584)].join('');
var inst_75596 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75593,"Authorization",inst_75595);
var state_75620__$1 = state_75620;
var statearr_75645_75669 = state_75620__$1;
(statearr_75645_75669[(2)] = inst_75596);

(statearr_75645_75669[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75621 === (8))){
var inst_75584 = (state_75620[(2)]);
var inst_75585 = clojure.string.replace(k,"_","/");
var inst_75586 = fluree.db.connection.get_server(conn_id,servers);
var state_75620__$1 = (function (){var statearr_75646 = state_75620;
(statearr_75646[(11)] = inst_75584);

(statearr_75646[(12)] = inst_75585);

return statearr_75646;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75620__$1,(9),inst_75586);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__13883__auto__ = null;
var fluree$db$connection$state_machine__13883__auto____0 = (function (){
var statearr_75647 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75647[(0)] = fluree$db$connection$state_machine__13883__auto__);

(statearr_75647[(1)] = (1));

return statearr_75647;
});
var fluree$db$connection$state_machine__13883__auto____1 = (function (state_75620){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75620);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75648){var ex__13886__auto__ = e75648;
var statearr_75649_75670 = state_75620;
(statearr_75649_75670[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75620[(4)]))){
var statearr_75650_75671 = state_75620;
(statearr_75650_75671[(1)] = cljs.core.first((state_75620[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75672 = state_75620;
state_75620 = G__75672;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$state_machine__13883__auto__ = function(state_75620){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__13883__auto____1.call(this,state_75620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__13883__auto____0;
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__13883__auto____1;
return fluree$db$connection$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75651 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75651[(6)] = c__13957__auto__);

return statearr_75651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__75673_SHARP_){
if(cljs.core.truth_(p1__75673_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__75674_SHARP_){
var or__4160__auto__ = p1__75674_SHARP_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return token;
}
}));

return true;
}catch (e75675){var e = e75675;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__75676 = opts;
var map__75676__$1 = cljs.core.__destructure_map(map__75676);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75676__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75676__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4160__auto__ = object_cache;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4160__auto__ = storage_read;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4160__auto__ = storage_exists;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = storage_read;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4149__auto__ = storage_write;
if(cljs.core.truth_(and__4149__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4149__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__75677_75678 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__75677_75678.cljs$core$IFn$_invoke$arity$0 ? fexpr__75677_75678.cljs$core$IFn$_invoke$arity$0() : fexpr__75677_75678.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4777__auto__ = [];
var len__4771__auto___75711 = arguments.length;
var i__4772__auto___75712 = (0);
while(true){
if((i__4772__auto___75712 < len__4771__auto___75711)){
args__4777__auto__.push((arguments[i__4772__auto___75712]));

var G__75713 = (i__4772__auto___75712 + (1));
i__4772__auto___75712 = G__75713;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__75681){
var vec__75682 = p__75681;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75682,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__13957__auto___75714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75699){
var state_val_75700 = (state_75699[(1)]);
if((state_val_75700 === (1))){
var inst_75685 = fluree.db.connection.get_socket(conn);
var state_75699__$1 = state_75699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75699__$1,(2),inst_75685);
} else {
if((state_val_75700 === (2))){
var inst_75687 = (state_75699[(2)]);
var inst_75688 = (inst_75687 == null);
var inst_75689 = fluree.db.util.core.exception_QMARK_(inst_75687);
var inst_75690 = ((inst_75688) || (inst_75689));
var state_75699__$1 = state_75699;
if(cljs.core.truth_(inst_75690)){
var statearr_75701_75715 = state_75699__$1;
(statearr_75701_75715[(1)] = (3));

} else {
var statearr_75702_75716 = state_75699__$1;
(statearr_75702_75716[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75700 === (3))){
var inst_75692 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_75693 = cljs.core.async.close_BANG_(conn);
var state_75699__$1 = (function (){var statearr_75703 = state_75699;
(statearr_75703[(7)] = inst_75692);

return statearr_75703;
})();
var statearr_75704_75717 = state_75699__$1;
(statearr_75704_75717[(2)] = inst_75693);

(statearr_75704_75717[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75700 === (4))){
var inst_75695 = fluree.db.connection.msg_consumer(conn);
var state_75699__$1 = state_75699;
var statearr_75705_75718 = state_75699__$1;
(statearr_75705_75718[(2)] = inst_75695);

(statearr_75705_75718[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75700 === (5))){
var inst_75697 = (state_75699[(2)]);
var state_75699__$1 = state_75699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75699__$1,inst_75697);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__13883__auto__ = null;
var fluree$db$connection$state_machine__13883__auto____0 = (function (){
var statearr_75706 = [null,null,null,null,null,null,null,null];
(statearr_75706[(0)] = fluree$db$connection$state_machine__13883__auto__);

(statearr_75706[(1)] = (1));

return statearr_75706;
});
var fluree$db$connection$state_machine__13883__auto____1 = (function (state_75699){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75699);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75707){var ex__13886__auto__ = e75707;
var statearr_75708_75719 = state_75699;
(statearr_75708_75719[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75699[(4)]))){
var statearr_75709_75720 = state_75699;
(statearr_75709_75720[(1)] = cljs.core.first((state_75699[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75721 = state_75699;
state_75699 = G__75721;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$state_machine__13883__auto__ = function(state_75699){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__13883__auto____1.call(this,state_75699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__13883__auto____0;
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__13883__auto____1;
return fluree$db$connection$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75710 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75710[(6)] = c__13957__auto___75714);

return statearr_75710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq75679){
var G__75680 = cljs.core.first(seq75679);
var seq75679__$1 = cljs.core.next(seq75679);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75680,seq75679__$1);
}));

