// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4654__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4655__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4656__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4657__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__26918 = cljs.core.get_global_hierarchy;
return (fexpr__26918.cljs$core$IFn$_invoke$arity$0 ? fexpr__26918.cljs$core$IFn$_invoke$arity$0() : fexpr__26918.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4658__auto__,method_table__4654__auto__,prefer_table__4655__auto__,method_cache__4656__auto__,cached_hierarchy__4657__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__26919 = cljs.core.seq(callbacks);
var chunk__26920 = null;
var count__26921 = (0);
var i__26922 = (0);
while(true){
if((i__26922 < count__26921)){
var vec__26931 = chunk__26920.cljs$core$IIndexed$_nth$arity$2(null,i__26922);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26931,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26931,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e26934){var e_26939 = e26934;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_26939,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__26940 = seq__26919;
var G__26941 = chunk__26920;
var G__26942 = count__26921;
var G__26943 = (i__26922 + (1));
seq__26919 = G__26940;
chunk__26920 = G__26941;
count__26921 = G__26942;
i__26922 = G__26943;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__26919);
if(temp__5753__auto__){
var seq__26919__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26919__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__26919__$1);
var G__26944 = cljs.core.chunk_rest(seq__26919__$1);
var G__26945 = c__4591__auto__;
var G__26946 = cljs.core.count(c__4591__auto__);
var G__26947 = (0);
seq__26919 = G__26944;
chunk__26920 = G__26945;
count__26921 = G__26946;
i__26922 = G__26947;
continue;
} else {
var vec__26935 = cljs.core.first(seq__26919__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26935,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26935,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e26938){var e_26948 = e26938;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_26948,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__26949 = cljs.core.next(seq__26919__$1);
var G__26950 = null;
var G__26951 = (0);
var G__26952 = (0);
seq__26919 = G__26949;
chunk__26920 = G__26950;
count__26921 = G__26951;
i__26922 = G__26952;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__26955 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26955,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26955,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26955,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26955,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__26958 = conn;
var map__26958__$1 = cljs.core.__destructure_map(map__26958);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26958__$1,cljs.core.cst$kw$state);
var G__26959 = event_type__$1;
var G__26959__$1 = (((G__26959 instanceof cljs.core.Keyword))?G__26959.fqn:null);
switch (G__26959__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,(function (p1__26953_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__26953_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__26960 = error_data;
var map__26960__$1 = cljs.core.__destructure_map(map__26960);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26960__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = message;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e26954){var e = e26954;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
