// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(cljs.core.cst$kw$dbaas_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return cljs.core.cst$kw$open_DASH_api_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 * 
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$jwt_DASH_secret.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn))),cljs.core.cst$kw$hex);
if(fluree.db.connection_js.dbaas_QMARK_(conn)){
return true;
} else {
return fluree.db.token_auth.verify_jwt(secret,jwt);
}
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__137824 = arguments.length;
switch (G__137824) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
});

fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
});

fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_137863){
var state_val_137864 = (state_137863[(1)]);
if((state_val_137864 === (7))){
var inst_137847 = (state_137863[(2)]);
var inst_137848 = [cljs.core.cst$kw$account,cljs.core.cst$kw$user,cljs.core.cst$kw$password,cljs.core.cst$kw$expireSeconds,cljs.core.cst$kw$syncTo];
var inst_137849 = [account,inst_137847,password,expireSeconds,syncTo];
var inst_137850 = cljs.core.PersistentHashMap.fromArrays(inst_137848,inst_137849);
var inst_137851 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$authenticate,inst_137850);
var state_137863__$1 = state_137863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137863__$1,(14),inst_137851);
} else {
if((state_val_137864 === (1))){
var state_137863__$1 = state_137863;
var statearr_137865_137887 = state_137863__$1;
(statearr_137865_137887[(2)] = null);

(statearr_137865_137887[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_137863,(3),cljs.core.cst$kw$default,null,(2));
var inst_137831 = typeof user === 'number';
var state_137863__$1 = state_137863;
if(cljs.core.truth_(inst_137831)){
var statearr_137866_137888 = state_137863__$1;
(statearr_137866_137888[(1)] = (5));

} else {
var statearr_137867_137889 = state_137863__$1;
(statearr_137867_137889[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (13))){
var inst_137843 = (state_137863[(2)]);
var state_137863__$1 = state_137863;
var statearr_137868_137890 = state_137863__$1;
(statearr_137868_137890[(2)] = inst_137843);

(statearr_137868_137890[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (6))){
var inst_137834 = typeof user === 'string';
var state_137863__$1 = state_137863;
if(cljs.core.truth_(inst_137834)){
var statearr_137869_137891 = state_137863__$1;
(statearr_137869_137891[(1)] = (8));

} else {
var statearr_137870_137892 = state_137863__$1;
(statearr_137870_137892[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (3))){
var inst_137825 = (state_137863[(2)]);
var inst_137826 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_137825], 0));
var inst_137827 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_137825) : reject.call(null,inst_137825));
var state_137863__$1 = (function (){var statearr_137871 = state_137863;
(statearr_137871[(7)] = inst_137826);

return statearr_137871;
})();
var statearr_137872_137893 = state_137863__$1;
(statearr_137872_137893[(2)] = inst_137827);


cljs.core.async.impl.ioc_helpers.process_exception(state_137863__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (12))){
var state_137863__$1 = state_137863;
var statearr_137873_137894 = state_137863__$1;
(statearr_137873_137894[(2)] = null);

(statearr_137873_137894[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (2))){
var inst_137861 = (state_137863[(2)]);
var state_137863__$1 = state_137863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137863__$1,inst_137861);
} else {
if((state_val_137864 === (11))){
var state_137863__$1 = state_137863;
var statearr_137874_137895 = state_137863__$1;
(statearr_137874_137895[(2)] = user);

(statearr_137874_137895[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (9))){
var state_137863__$1 = state_137863;
var statearr_137875_137896 = state_137863__$1;
(statearr_137875_137896[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (5))){
var state_137863__$1 = state_137863;
var statearr_137877_137897 = state_137863__$1;
(statearr_137877_137897[(2)] = user);

(statearr_137877_137897[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (14))){
var inst_137853 = (state_137863[(2)]);
var inst_137854 = cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(inst_137853);
var inst_137855 = cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(conn);
var inst_137856 = cljs.core.constantly(inst_137854);
var inst_137857 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_137855,inst_137856);
var inst_137858 = fluree.db.connection.add_token(conn,inst_137854);
var inst_137859 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_137853) : resolve.call(null,inst_137853));
var state_137863__$1 = (function (){var statearr_137878 = state_137863;
(statearr_137878[(8)] = inst_137858);

(statearr_137878[(9)] = inst_137857);

return statearr_137878;
})();
var statearr_137879_137898 = state_137863__$1;
(statearr_137879_137898[(2)] = inst_137859);


cljs.core.async.impl.ioc_helpers.process_exception(state_137863__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (10))){
var inst_137845 = (state_137863[(2)]);
var state_137863__$1 = state_137863;
var statearr_137880_137899 = state_137863__$1;
(statearr_137880_137899[(2)] = inst_137845);

(statearr_137880_137899[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137864 === (8))){
var inst_137836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137837 = ["_user/username",user];
var inst_137838 = (new cljs.core.PersistentVector(null,2,(5),inst_137836,inst_137837,null));
var state_137863__$1 = state_137863;
var statearr_137881_137900 = state_137863__$1;
(statearr_137881_137900[(2)] = inst_137838);

(statearr_137881_137900[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection_js$state_machine__109971__auto__ = null;
var fluree$db$connection_js$state_machine__109971__auto____0 = (function (){
var statearr_137882 = [null,null,null,null,null,null,null,null,null,null];
(statearr_137882[(0)] = fluree$db$connection_js$state_machine__109971__auto__);

(statearr_137882[(1)] = (1));

return statearr_137882;
});
var fluree$db$connection_js$state_machine__109971__auto____1 = (function (state_137863){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_137863);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e137883){if((e137883 instanceof Object)){
var ex__109974__auto__ = e137883;
var statearr_137884_137901 = state_137863;
(statearr_137884_137901[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137863);

return cljs.core.cst$kw$recur;
} else {
throw e137883;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__137902 = state_137863;
state_137863 = G__137902;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__109971__auto__ = function(state_137863){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__109971__auto____1.call(this,state_137863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__109971__auto____0;
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__109971__auto____1;
return fluree$db$connection_js$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_137885 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_137885[(6)] = c__110077__auto__);

return statearr_137885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
})));
});

fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6;

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__137904 = arguments.length;
switch (G__137904) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
});

fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flureedb_DASH_settings], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$token], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,conn,pc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,conn,pc){
return (function (state_137913){
var state_val_137914 = (state_137913[(1)]);
if((state_val_137914 === (1))){
var inst_137905 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_137906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137907 = [cljs.core.cst$kw$settings,null,pc,null];
var inst_137908 = (new cljs.core.PersistentVector(null,4,(5),inst_137906,inst_137907,null));
var inst_137909 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_137905,inst_137908);
var inst_137910 = (function (){return ((function (inst_137905,inst_137906,inst_137907,inst_137908,inst_137909,state_val_137914,c__110077__auto__,conn,pc){
return (function (x){
if((x == null)){
return null;
} else {
var seq__137915 = cljs.core.seq(cljs.core.keys(x));
var chunk__137916 = null;
var count__137917 = (0);
var i__137918 = (0);
while(true){
if((i__137918 < count__137917)){
var k = chunk__137916.cljs$core$IIndexed$_nth$arity$2(null,i__137918);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__137925 = seq__137915;
var G__137926 = chunk__137916;
var G__137927 = count__137917;
var G__137928 = (i__137918 + (1));
seq__137915 = G__137925;
chunk__137916 = G__137926;
count__137917 = G__137927;
i__137918 = G__137928;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__137915);
if(temp__5735__auto__){
var seq__137915__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__137915__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__137915__$1);
var G__137929 = cljs.core.chunk_rest(seq__137915__$1);
var G__137930 = c__4550__auto__;
var G__137931 = cljs.core.count(c__4550__auto__);
var G__137932 = (0);
seq__137915 = G__137929;
chunk__137916 = G__137930;
count__137917 = G__137931;
i__137918 = G__137932;
continue;
} else {
var k = cljs.core.first(seq__137915__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__137933 = cljs.core.next(seq__137915__$1);
var G__137934 = null;
var G__137935 = (0);
var G__137936 = (0);
seq__137915 = G__137933;
chunk__137916 = G__137934;
count__137917 = G__137935;
i__137918 = G__137936;
continue;
}
} else {
return null;
}
}
break;
}
}
});
;})(inst_137905,inst_137906,inst_137907,inst_137908,inst_137909,state_val_137914,c__110077__auto__,conn,pc))
})();
var inst_137911 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_137910);
var state_137913__$1 = (function (){var statearr_137919 = state_137913;
(statearr_137919[(7)] = inst_137909);

return statearr_137919;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_137913__$1,inst_137911);
} else {
return null;
}
});})(c__110077__auto__,conn,pc))
;
return ((function (switch__109970__auto__,c__110077__auto__,conn,pc){
return (function() {
var fluree$db$connection_js$state_machine__109971__auto__ = null;
var fluree$db$connection_js$state_machine__109971__auto____0 = (function (){
var statearr_137920 = [null,null,null,null,null,null,null,null];
(statearr_137920[(0)] = fluree$db$connection_js$state_machine__109971__auto__);

(statearr_137920[(1)] = (1));

return statearr_137920;
});
var fluree$db$connection_js$state_machine__109971__auto____1 = (function (state_137913){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_137913);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e137921){if((e137921 instanceof Object)){
var ex__109974__auto__ = e137921;
var statearr_137922_137937 = state_137913;
(statearr_137922_137937[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137913);

return cljs.core.cst$kw$recur;
} else {
throw e137921;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__137938 = state_137913;
state_137913 = G__137938;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__109971__auto__ = function(state_137913){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__109971__auto____1.call(this,state_137913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__109971__auto____0;
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__109971__auto____1;
return fluree$db$connection_js$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,conn,pc))
})();
var state__110079__auto__ = (function (){var statearr_137923 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_137923[(6)] = c__110077__auto__);

return statearr_137923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,conn,pc))
);

return c__110077__auto__;
})();
return conn;
});

fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2;

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__137940 = arguments.length;
switch (G__137940) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
});

fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_137971){
var state_val_137972 = (state_137971[(1)]);
if((state_val_137972 === (1))){
var state_137971__$1 = state_137971;
var statearr_137973_137987 = state_137971__$1;
(statearr_137973_137987[(2)] = null);

(statearr_137973_137987[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_137972 === (2))){
var inst_137969 = (state_137971[(2)]);
var state_137971__$1 = state_137971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137971__$1,inst_137969);
} else {
if((state_val_137972 === (3))){
var inst_137941 = (state_137971[(2)]);
var inst_137942 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_137941], 0));
var inst_137943 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_137941) : reject.call(null,inst_137941));
var state_137971__$1 = (function (){var statearr_137974 = state_137971;
(statearr_137974[(7)] = inst_137942);

return statearr_137974;
})();
var statearr_137975_137988 = state_137971__$1;
(statearr_137975_137988[(2)] = inst_137943);


cljs.core.async.impl.ioc_helpers.process_exception(state_137971__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_137972 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_137971,(3),cljs.core.cst$kw$default,null,(2));
var inst_137947 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_137948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137949 = [cljs.core.cst$kw$flureedb_DASH_settings];
var inst_137950 = (new cljs.core.PersistentVector(null,1,(5),inst_137948,inst_137949,null));
var inst_137951 = cljs.core.PersistentHashMap.EMPTY;
var inst_137952 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_137951);
var inst_137953 = cljs.core.assoc_in(inst_137947,inst_137950,inst_137952);
var inst_137954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137955 = [cljs.core.cst$kw$jwt];
var inst_137956 = (new cljs.core.PersistentVector(null,1,(5),inst_137954,inst_137955,null));
var inst_137957 = cljs.core.PersistentHashMap.EMPTY;
var inst_137958 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_137957);
var inst_137959 = cljs.core.assoc_in(inst_137953,inst_137956,inst_137958);
var inst_137960 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_137961 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(inst_137959);
var inst_137962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137963 = [cljs.core.cst$kw$settings,null,inst_137960,null];
var inst_137964 = (new cljs.core.PersistentVector(null,4,(5),inst_137962,inst_137963,null));
var inst_137965 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_137961,inst_137964);
var inst_137966 = (function (){var conn = inst_137959;
var pc = inst_137960;
return ((function (conn,pc,_,inst_137947,inst_137948,inst_137949,inst_137950,inst_137951,inst_137952,inst_137953,inst_137954,inst_137955,inst_137956,inst_137957,inst_137958,inst_137959,inst_137960,inst_137961,inst_137962,inst_137963,inst_137964,inst_137965,state_val_137972,c__110077__auto__){
return (function (x){
if((x == null)){
} else {
var seq__137976_137989 = cljs.core.seq(cljs.core.keys(x));
var chunk__137977_137990 = null;
var count__137978_137991 = (0);
var i__137979_137992 = (0);
while(true){
if((i__137979_137992 < count__137978_137991)){
var k_137993 = chunk__137977_137990.cljs$core$IIndexed$_nth$arity$2(null,i__137979_137992);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_137993], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_137993,null));


var G__137994 = seq__137976_137989;
var G__137995 = chunk__137977_137990;
var G__137996 = count__137978_137991;
var G__137997 = (i__137979_137992 + (1));
seq__137976_137989 = G__137994;
chunk__137977_137990 = G__137995;
count__137978_137991 = G__137996;
i__137979_137992 = G__137997;
continue;
} else {
var temp__5735__auto___137998 = cljs.core.seq(seq__137976_137989);
if(temp__5735__auto___137998){
var seq__137976_137999__$1 = temp__5735__auto___137998;
if(cljs.core.chunked_seq_QMARK_(seq__137976_137999__$1)){
var c__4550__auto___138000 = cljs.core.chunk_first(seq__137976_137999__$1);
var G__138001 = cljs.core.chunk_rest(seq__137976_137999__$1);
var G__138002 = c__4550__auto___138000;
var G__138003 = cljs.core.count(c__4550__auto___138000);
var G__138004 = (0);
seq__137976_137989 = G__138001;
chunk__137977_137990 = G__138002;
count__137978_137991 = G__138003;
i__137979_137992 = G__138004;
continue;
} else {
var k_138005 = cljs.core.first(seq__137976_137999__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_138005], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_138005,null));


var G__138006 = cljs.core.next(seq__137976_137999__$1);
var G__138007 = null;
var G__138008 = (0);
var G__138009 = (0);
seq__137976_137989 = G__138006;
chunk__137977_137990 = G__138007;
count__137978_137991 = G__138008;
i__137979_137992 = G__138009;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
;})(conn,pc,_,inst_137947,inst_137948,inst_137949,inst_137950,inst_137951,inst_137952,inst_137953,inst_137954,inst_137955,inst_137956,inst_137957,inst_137958,inst_137959,inst_137960,inst_137961,inst_137962,inst_137963,inst_137964,inst_137965,state_val_137972,c__110077__auto__))
})();
var inst_137967 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_137960,inst_137966);
var state_137971__$1 = (function (){var statearr_137980 = state_137971;
(statearr_137980[(8)] = inst_137965);

return statearr_137980;
})();
var statearr_137981_138010 = state_137971__$1;
(statearr_137981_138010[(2)] = inst_137967);


cljs.core.async.impl.ioc_helpers.process_exception(state_137971__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection_js$state_machine__109971__auto__ = null;
var fluree$db$connection_js$state_machine__109971__auto____0 = (function (){
var statearr_137982 = [null,null,null,null,null,null,null,null,null];
(statearr_137982[(0)] = fluree$db$connection_js$state_machine__109971__auto__);

(statearr_137982[(1)] = (1));

return statearr_137982;
});
var fluree$db$connection_js$state_machine__109971__auto____1 = (function (state_137971){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_137971);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e137983){if((e137983 instanceof Object)){
var ex__109974__auto__ = e137983;
var statearr_137984_138011 = state_137971;
(statearr_137984_138011[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137971);

return cljs.core.cst$kw$recur;
} else {
throw e137983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138012 = state_137971;
state_137971 = G__138012;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__109971__auto__ = function(state_137971){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__109971__auto____1.call(this,state_137971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__109971__auto____0;
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__109971__auto____1;
return fluree$db$connection_js$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_137985 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_137985[(6)] = c__110077__auto__);

return statearr_137985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
})));
});

fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2;

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__138014 = arguments.length;
switch (G__138014) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
});

fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = cljs.core.cst$kw$open_DASH_api_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn)));
var token = cljs.core.cst$kw$jwt.cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4131__auto__ = cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.cst$kw$auth_DASH_id.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
});

fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2;

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__138016 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138016,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138016,(1),null);
var cb_STAR_ = ((function (vec__138016,network,ledger_id){
return (function (header,data){
var G__138019 = cljs.core.clj__GT_js(header);
var G__138020 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__138019,G__138020) : callback.call(null,G__138019,G__138020));
});})(vec__138016,network,ledger_id))
;
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__138021 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138021,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138021,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return cljs.core.cst$kw$password_DASH_enabled_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$flureedb_DASH_settings.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_138071){
var state_val_138072 = (state_138071[(1)]);
if((state_val_138072 === (7))){
var inst_138039 = (state_138071[(2)]);
var state_138071__$1 = (function (){var statearr_138073 = state_138071;
(statearr_138073[(7)] = inst_138039);

return statearr_138073;
})();
if(cljs.core.truth_(ledger)){
var statearr_138074_138098 = state_138071__$1;
(statearr_138074_138098[(1)] = (8));

} else {
var statearr_138075_138099 = state_138071__$1;
(statearr_138075_138099[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (1))){
var state_138071__$1 = state_138071;
var statearr_138076_138100 = state_138071__$1;
(statearr_138076_138100[(2)] = null);

(statearr_138076_138100[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138071,(3),cljs.core.cst$kw$default,null,(2));
var inst_138030 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_138071__$1 = state_138071;
if(cljs.core.truth_(inst_138030)){
var statearr_138077_138101 = state_138071__$1;
(statearr_138077_138101[(1)] = (5));

} else {
var statearr_138078_138102 = state_138071__$1;
(statearr_138078_138102[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (13))){
var inst_138057 = (state_138071[(2)]);
var inst_138058 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,cljs.core.cst$kw$ledger,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$password,password], 0));
var inst_138059 = fluree.db.util.core.without_nils(inst_138058);
var inst_138060 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_138061 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_138062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_138063 = [cljs.core.cst$kw$pw_DASH_generate,inst_138059,inst_138060,null];
var inst_138064 = (new cljs.core.PersistentVector(null,4,(5),inst_138062,inst_138063,null));
var inst_138065 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138061,inst_138064);
var inst_138066 = (function (){var _ = inst_138057;
var data = inst_138059;
var pc = inst_138060;
return ((function (_,data,pc,inst_138057,inst_138058,inst_138059,inst_138060,inst_138061,inst_138062,inst_138063,inst_138064,inst_138065,state_val_138072,c__110077__auto__){
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null))})():null))){
if(cljs.core.truth_(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(result))){
var G__138079 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__138079) : reject.call(null,G__138079));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(function (){var or__4131__auto__ = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (400);
}
})(),cljs.core.cst$kw$message,cljs.core.ex_message(result),cljs.core.cst$kw$error,(function (){var or__4131__auto__ = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$db_SLASH_invalid_DASH_request;
}
})()], null);
var G__138080 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__138080) : reject.call(null,G__138080));
} else {
var G__138081 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__138081) : resolve.call(null,G__138081));

}
}
});
;})(_,data,pc,inst_138057,inst_138058,inst_138059,inst_138060,inst_138061,inst_138062,inst_138063,inst_138064,inst_138065,state_val_138072,c__110077__auto__))
})();
var inst_138067 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138060,inst_138066);
var state_138071__$1 = (function (){var statearr_138082 = state_138071;
(statearr_138082[(8)] = inst_138065);

return statearr_138082;
})();
var statearr_138083_138103 = state_138071__$1;
(statearr_138083_138103[(2)] = inst_138067);


cljs.core.async.impl.ioc_helpers.process_exception(state_138071__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (6))){
var inst_138033 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138034 = [(401),cljs.core.cst$kw$db_SLASH_no_DASH_password_DASH_auth];
var inst_138035 = cljs.core.PersistentHashMap.fromArrays(inst_138033,inst_138034);
var inst_138036 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_138035);
var inst_138037 = (function(){throw inst_138036})();
var state_138071__$1 = state_138071;
var statearr_138084_138104 = state_138071__$1;
(statearr_138084_138104[(2)] = inst_138037);

(statearr_138084_138104[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (3))){
var inst_138024 = (state_138071[(2)]);
var inst_138025 = cljs.core.clj__GT_js(inst_138024);
var inst_138026 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_138025) : reject.call(null,inst_138025));
var state_138071__$1 = state_138071;
var statearr_138085_138105 = state_138071__$1;
(statearr_138085_138105[(2)] = inst_138026);


cljs.core.async.impl.ioc_helpers.process_exception(state_138071__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (12))){
var inst_138051 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138052 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_request];
var inst_138053 = cljs.core.PersistentHashMap.fromArrays(inst_138051,inst_138052);
var inst_138054 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_138053);
var inst_138055 = (function(){throw inst_138054})();
var state_138071__$1 = state_138071;
var statearr_138086_138106 = state_138071__$1;
(statearr_138086_138106[(2)] = inst_138055);

(statearr_138086_138106[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (2))){
var inst_138069 = (state_138071[(2)]);
var state_138071__$1 = state_138071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138071__$1,inst_138069);
} else {
if((state_val_138072 === (11))){
var state_138071__$1 = state_138071;
var statearr_138087_138107 = state_138071__$1;
(statearr_138087_138107[(2)] = null);

(statearr_138087_138107[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (9))){
var inst_138042 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138043 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_request];
var inst_138044 = cljs.core.PersistentHashMap.fromArrays(inst_138042,inst_138043);
var inst_138045 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_138044);
var inst_138046 = (function(){throw inst_138045})();
var state_138071__$1 = state_138071;
var statearr_138088_138108 = state_138071__$1;
(statearr_138088_138108[(2)] = inst_138046);

(statearr_138088_138108[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (5))){
var state_138071__$1 = state_138071;
var statearr_138089_138109 = state_138071__$1;
(statearr_138089_138109[(2)] = null);

(statearr_138089_138109[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (10))){
var inst_138048 = (state_138071[(2)]);
var state_138071__$1 = (function (){var statearr_138090 = state_138071;
(statearr_138090[(9)] = inst_138048);

return statearr_138090;
})();
if(cljs.core.truth_(password)){
var statearr_138091_138110 = state_138071__$1;
(statearr_138091_138110[(1)] = (11));

} else {
var statearr_138092_138111 = state_138071__$1;
(statearr_138092_138111[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138072 === (8))){
var state_138071__$1 = state_138071;
var statearr_138093_138112 = state_138071__$1;
(statearr_138093_138112[(2)] = null);

(statearr_138093_138112[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__109971__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__109971__auto____0 = (function (){
var statearr_138094 = [null,null,null,null,null,null,null,null,null,null];
(statearr_138094[(0)] = fluree$db$connection_js$password_generate_$_state_machine__109971__auto__);

(statearr_138094[(1)] = (1));

return statearr_138094;
});
var fluree$db$connection_js$password_generate_$_state_machine__109971__auto____1 = (function (state_138071){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138071);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138095){if((e138095 instanceof Object)){
var ex__109974__auto__ = e138095;
var statearr_138096_138113 = state_138071;
(statearr_138096_138113[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138071);

return cljs.core.cst$kw$recur;
} else {
throw e138095;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138114 = state_138071;
state_138071 = G__138114;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__109971__auto__ = function(state_138071){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__109971__auto____1.call(this,state_138071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__109971__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__109971__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_138097 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138097[(6)] = c__110077__auto__);

return statearr_138097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__138116 = arguments.length;
switch (G__138116) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
});

fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_138179){
var state_val_138180 = (state_138179[(1)]);
if((state_val_138180 === (7))){
var inst_138132 = (state_138179[(2)]);
var state_138179__$1 = (function (){var statearr_138181 = state_138179;
(statearr_138181[(7)] = inst_138132);

return statearr_138181;
})();
if(cljs.core.truth_(ledger)){
var statearr_138182_138216 = state_138179__$1;
(statearr_138182_138216[(1)] = (8));

} else {
var statearr_138183_138217 = state_138179__$1;
(statearr_138183_138217[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (1))){
var state_138179__$1 = state_138179;
var statearr_138184_138218 = state_138179__$1;
(statearr_138184_138218[(2)] = null);

(statearr_138184_138218[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138179,(3),cljs.core.cst$kw$default,null,(2));
var inst_138123 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_138179__$1 = state_138179;
if(cljs.core.truth_(inst_138123)){
var statearr_138185_138219 = state_138179__$1;
(statearr_138185_138219[(1)] = (5));

} else {
var statearr_138186_138220 = state_138179__$1;
(statearr_138186_138220[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (15))){
var state_138179__$1 = state_138179;
var statearr_138187_138221 = state_138179__$1;
(statearr_138187_138221[(2)] = auth);

(statearr_138187_138221[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (13))){
var inst_138150 = (state_138179[(2)]);
var state_138179__$1 = (function (){var statearr_138188 = state_138179;
(statearr_138188[(8)] = inst_138150);

return statearr_138188;
})();
if(cljs.core.truth_(user)){
var statearr_138189_138222 = state_138179__$1;
(statearr_138189_138222[(1)] = (14));

} else {
var statearr_138190_138223 = state_138179__$1;
(statearr_138190_138223[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (6))){
var inst_138126 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138127 = [(401),cljs.core.cst$kw$db_SLASH_no_DASH_password_DASH_auth];
var inst_138128 = cljs.core.PersistentHashMap.fromArrays(inst_138126,inst_138127);
var inst_138129 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_138128);
var inst_138130 = (function(){throw inst_138129})();
var state_138179__$1 = state_138179;
var statearr_138191_138224 = state_138179__$1;
(statearr_138191_138224[(2)] = inst_138130);

(statearr_138191_138224[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (17))){
var state_138179__$1 = state_138179;
var statearr_138192_138225 = state_138179__$1;
(statearr_138192_138225[(2)] = null);

(statearr_138192_138225[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (3))){
var inst_138117 = (state_138179[(2)]);
var inst_138118 = cljs.core.clj__GT_js(inst_138117);
var inst_138119 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_138118) : reject.call(null,inst_138118));
var state_138179__$1 = state_138179;
var statearr_138193_138226 = state_138179__$1;
(statearr_138193_138226[(2)] = inst_138119);


cljs.core.async.impl.ioc_helpers.process_exception(state_138179__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (12))){
var inst_138144 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138145 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_request];
var inst_138146 = cljs.core.PersistentHashMap.fromArrays(inst_138144,inst_138145);
var inst_138147 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_138146);
var inst_138148 = (function(){throw inst_138147})();
var state_138179__$1 = state_138179;
var statearr_138194_138227 = state_138179__$1;
(statearr_138194_138227[(2)] = inst_138148);

(statearr_138194_138227[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (2))){
var inst_138177 = (state_138179[(2)]);
var state_138179__$1 = state_138179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138179__$1,inst_138177);
} else {
if((state_val_138180 === (19))){
var inst_138163 = (state_138179[(2)]);
var inst_138164 = [cljs.core.cst$kw$ledger,cljs.core.cst$kw$password,cljs.core.cst$kw$user,cljs.core.cst$kw$auth,cljs.core.cst$kw$expire];
var inst_138165 = [ledger,password,user,auth,expire];
var inst_138166 = cljs.core.PersistentHashMap.fromArrays(inst_138164,inst_138165);
var inst_138167 = fluree.db.util.core.without_nils(inst_138166);
var inst_138168 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_138169 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_138170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_138171 = [cljs.core.cst$kw$pw_DASH_login,inst_138167,inst_138168,null];
var inst_138172 = (new cljs.core.PersistentVector(null,4,(5),inst_138170,inst_138171,null));
var inst_138173 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138169,inst_138172);
var inst_138174 = (function (){var _ = inst_138163;
var data = inst_138167;
var pc = inst_138168;
return ((function (_,data,pc,inst_138163,inst_138164,inst_138165,inst_138166,inst_138167,inst_138168,inst_138169,inst_138170,inst_138171,inst_138172,inst_138173,state_val_138180,c__110077__auto__){
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null))})():null))){
if(cljs.core.truth_(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(result))){
var G__138195 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__138195) : reject.call(null,G__138195));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(function (){var or__4131__auto__ = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (400);
}
})(),cljs.core.cst$kw$message,cljs.core.ex_message(result),cljs.core.cst$kw$error,(function (){var or__4131__auto__ = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$db_SLASH_invalid_DASH_request;
}
})()], null);
var G__138196 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__138196) : reject.call(null,G__138196));
} else {
var G__138197 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__138197) : resolve.call(null,G__138197));

}
}
});
;})(_,data,pc,inst_138163,inst_138164,inst_138165,inst_138166,inst_138167,inst_138168,inst_138169,inst_138170,inst_138171,inst_138172,inst_138173,state_val_138180,c__110077__auto__))
})();
var inst_138175 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138168,inst_138174);
var state_138179__$1 = (function (){var statearr_138198 = state_138179;
(statearr_138198[(9)] = inst_138173);

return statearr_138198;
})();
var statearr_138199_138228 = state_138179__$1;
(statearr_138199_138228[(2)] = inst_138175);


cljs.core.async.impl.ioc_helpers.process_exception(state_138179__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (11))){
var state_138179__$1 = state_138179;
var statearr_138200_138229 = state_138179__$1;
(statearr_138200_138229[(2)] = null);

(statearr_138200_138229[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (9))){
var inst_138135 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138136 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_request];
var inst_138137 = cljs.core.PersistentHashMap.fromArrays(inst_138135,inst_138136);
var inst_138138 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_138137);
var inst_138139 = (function(){throw inst_138138})();
var state_138179__$1 = state_138179;
var statearr_138201_138230 = state_138179__$1;
(statearr_138201_138230[(2)] = inst_138139);

(statearr_138201_138230[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (5))){
var state_138179__$1 = state_138179;
var statearr_138202_138231 = state_138179__$1;
(statearr_138202_138231[(2)] = null);

(statearr_138202_138231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (14))){
var state_138179__$1 = state_138179;
var statearr_138203_138232 = state_138179__$1;
(statearr_138203_138232[(2)] = user);

(statearr_138203_138232[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (16))){
var inst_138154 = (state_138179[(2)]);
var state_138179__$1 = state_138179;
if(cljs.core.truth_(inst_138154)){
var statearr_138204_138233 = state_138179__$1;
(statearr_138204_138233[(1)] = (17));

} else {
var statearr_138205_138234 = state_138179__$1;
(statearr_138205_138234[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (10))){
var inst_138141 = (state_138179[(2)]);
var state_138179__$1 = (function (){var statearr_138206 = state_138179;
(statearr_138206[(10)] = inst_138141);

return statearr_138206;
})();
if(cljs.core.truth_(password)){
var statearr_138207_138235 = state_138179__$1;
(statearr_138207_138235[(1)] = (11));

} else {
var statearr_138208_138236 = state_138179__$1;
(statearr_138208_138236[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (18))){
var inst_138157 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138158 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_request];
var inst_138159 = cljs.core.PersistentHashMap.fromArrays(inst_138157,inst_138158);
var inst_138160 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_138159);
var inst_138161 = (function(){throw inst_138160})();
var state_138179__$1 = state_138179;
var statearr_138209_138237 = state_138179__$1;
(statearr_138209_138237[(2)] = inst_138161);

(statearr_138209_138237[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138180 === (8))){
var state_138179__$1 = state_138179;
var statearr_138210_138238 = state_138179__$1;
(statearr_138210_138238[(2)] = null);

(statearr_138210_138238[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection_js$state_machine__109971__auto__ = null;
var fluree$db$connection_js$state_machine__109971__auto____0 = (function (){
var statearr_138211 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_138211[(0)] = fluree$db$connection_js$state_machine__109971__auto__);

(statearr_138211[(1)] = (1));

return statearr_138211;
});
var fluree$db$connection_js$state_machine__109971__auto____1 = (function (state_138179){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138179);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138212){if((e138212 instanceof Object)){
var ex__109974__auto__ = e138212;
var statearr_138213_138239 = state_138179;
(statearr_138213_138239[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138179);

return cljs.core.cst$kw$recur;
} else {
throw e138212;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138240 = state_138179;
state_138179 = G__138240;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__109971__auto__ = function(state_138179){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__109971__auto____1.call(this,state_138179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__109971__auto____0;
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__109971__auto____1;
return fluree$db$connection_js$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_138214 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138214[(6)] = c__110077__auto__);

return statearr_138214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
})));
});

fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6;

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__138242 = arguments.length;
switch (G__138242) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
});

fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_138274){
var state_val_138275 = (state_138274[(1)]);
if((state_val_138275 === (1))){
var state_138274__$1 = state_138274;
var statearr_138276_138291 = state_138274__$1;
(statearr_138276_138291[(2)] = null);

(statearr_138276_138291[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138275 === (2))){
var inst_138272 = (state_138274[(2)]);
var state_138274__$1 = state_138274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138274__$1,inst_138272);
} else {
if((state_val_138275 === (3))){
var inst_138243 = (state_138274[(2)]);
var inst_138244 = cljs.core.clj__GT_js(inst_138243);
var inst_138245 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_138244) : reject.call(null,inst_138244));
var state_138274__$1 = state_138274;
var statearr_138277_138292 = state_138274__$1;
(statearr_138277_138292[(2)] = inst_138245);


cljs.core.async.impl.ioc_helpers.process_exception(state_138274__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138275 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138274,(3),cljs.core.cst$kw$default,null,(2));
var inst_138249 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_138274__$1 = state_138274;
if(cljs.core.truth_(inst_138249)){
var statearr_138278_138293 = state_138274__$1;
(statearr_138278_138293[(1)] = (5));

} else {
var statearr_138279_138294 = state_138274__$1;
(statearr_138279_138294[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138275 === (5))){
var state_138274__$1 = state_138274;
var statearr_138280_138295 = state_138274__$1;
(statearr_138280_138295[(2)] = null);

(statearr_138280_138295[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138275 === (6))){
var inst_138252 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_138253 = [(401),cljs.core.cst$kw$db_SLASH_no_DASH_password_DASH_auth];
var inst_138254 = cljs.core.PersistentHashMap.fromArrays(inst_138252,inst_138253);
var inst_138255 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_138254);
var inst_138256 = (function(){throw inst_138255})();
var state_138274__$1 = state_138274;
var statearr_138281_138296 = state_138274__$1;
(statearr_138281_138296[(2)] = inst_138256);

(statearr_138281_138296[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138275 === (7))){
var inst_138258 = (state_138274[(2)]);
var inst_138259 = [cljs.core.cst$kw$jwt,cljs.core.cst$kw$expire];
var inst_138260 = [jwt,expire];
var inst_138261 = cljs.core.PersistentHashMap.fromArrays(inst_138259,inst_138260);
var inst_138262 = fluree.db.util.core.without_nils(inst_138261);
var inst_138263 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_138264 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_138265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_138266 = [cljs.core.cst$kw$pw_DASH_renew,inst_138262,inst_138263,null];
var inst_138267 = (new cljs.core.PersistentVector(null,4,(5),inst_138265,inst_138266,null));
var inst_138268 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138264,inst_138267);
var inst_138269 = (function (){var _ = inst_138258;
var data = inst_138262;
var pc = inst_138263;
return ((function (_,data,pc,inst_138258,inst_138259,inst_138260,inst_138261,inst_138262,inst_138263,inst_138264,inst_138265,inst_138266,inst_138267,inst_138268,state_val_138275,c__110077__auto__){
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null))})():null))){
if(cljs.core.truth_(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(result))){
var G__138282 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__138282) : reject.call(null,G__138282));
} else {
return null;
}
} else {
var G__138283 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__138283) : resolve.call(null,G__138283));

}
});
;})(_,data,pc,inst_138258,inst_138259,inst_138260,inst_138261,inst_138262,inst_138263,inst_138264,inst_138265,inst_138266,inst_138267,inst_138268,state_val_138275,c__110077__auto__))
})();
var inst_138270 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138263,inst_138269);
var state_138274__$1 = (function (){var statearr_138284 = state_138274;
(statearr_138284[(7)] = inst_138268);

return statearr_138284;
})();
var statearr_138285_138297 = state_138274__$1;
(statearr_138285_138297[(2)] = inst_138270);


cljs.core.async.impl.ioc_helpers.process_exception(state_138274__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection_js$state_machine__109971__auto__ = null;
var fluree$db$connection_js$state_machine__109971__auto____0 = (function (){
var statearr_138286 = [null,null,null,null,null,null,null,null];
(statearr_138286[(0)] = fluree$db$connection_js$state_machine__109971__auto__);

(statearr_138286[(1)] = (1));

return statearr_138286;
});
var fluree$db$connection_js$state_machine__109971__auto____1 = (function (state_138274){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138274);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138287){if((e138287 instanceof Object)){
var ex__109974__auto__ = e138287;
var statearr_138288_138298 = state_138274;
(statearr_138288_138298[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138274);

return cljs.core.cst$kw$recur;
} else {
throw e138287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138299 = state_138274;
state_138274 = G__138299;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__109971__auto__ = function(state_138274){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__109971__auto____1.call(this,state_138274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__109971__auto____0;
fluree$db$connection_js$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__109971__auto____1;
return fluree$db$connection_js$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_138289 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138289[(6)] = c__110077__auto__);

return statearr_138289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
})));
});

fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3;

