// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__29815 = cljs.core._EQ_;
var expr__29816 = e.getLastErrorCode();
if(cljs.core.truth_((pred__29815.cljs$core$IFn$_invoke$arity$2 ? pred__29815.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__29816) : pred__29815.call(null,goog.net.ErrorCode.NO_ERROR,expr__29816)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__29815.cljs$core$IFn$_invoke$arity$2 ? pred__29815.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__29816) : pred__29815.call(null,goog.net.ErrorCode.EXCEPTION,expr__29816)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__29815.cljs$core$IFn$_invoke$arity$2 ? pred__29815.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__29816) : pred__29815.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__29816)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__29815.cljs$core$IFn$_invoke$arity$2 ? pred__29815.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__29816) : pred__29815.call(null,goog.net.ErrorCode.ABORT,expr__29816)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__29815.cljs$core$IFn$_invoke$arity$2 ? pred__29815.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__29816) : pred__29815.call(null,goog.net.ErrorCode.TIMEOUT,expr__29816)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4149__auto__ = status;
if(cljs.core.truth_(and__4149__auto__)){
return (status > (0));
} else {
return and__4149__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__29818 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29818,cljs.core.cst$kw$status,status);
} else {
return G__29818;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__29819 = opts;
var map__29819__$1 = cljs.core.__destructure_map(map__29819);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29819__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29819__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29819__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__29820 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__29820__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__29820,headers], 0)):G__29820);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29820__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__29820__$1;
}
})();
try{var G__29822_29828 = url;
var G__29823_29829 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__29824_29830 = "POST";
var G__29825_29831 = fluree.db.util.json.stringify(message);
var G__29826_29832 = cljs.core.clj__GT_js(headers__$1);
var G__29827_29833 = request_timeout;
goog.net.XhrIo.send(G__29822_29828,G__29823_29829,G__29824_29830,G__29825_29831,G__29826_29832,G__29827_29833);
}catch (e29821){var e_29834 = e29821;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_29834);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__29835 = opts;
var map__29835__$1 = cljs.core.__destructure_map(map__29835);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29835__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29835__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29835__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29835__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29835__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__29836 = cljs.core.PersistentArrayMap.EMPTY;
var G__29836__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__29836,headers], 0)):G__29836);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29836__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__29836__$1;
}
})();
try{var G__29838_29845 = url;
var G__29839_29846 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__29844 = output_format;
var G__29844__$1 = (((G__29844 instanceof cljs.core.Keyword))?G__29844.fqn:null);
switch (G__29844__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__29840_29847 = "GET";
var G__29841_29848 = body;
var G__29842_29849 = cljs.core.clj__GT_js(headers__$1);
var G__29843_29850 = request_timeout;
goog.net.XhrIo.send(G__29838_29845,G__29839_29846,G__29840_29847,G__29841_29848,G__29842_29849,G__29843_29850);
}catch (e29837){var e_29852 = e29837;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_29852);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__29853 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29853,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__29853;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29886){
var state_val_29887 = (state_29886[(1)]);
if((state_val_29887 === (7))){
var inst_29882 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29888_29913 = state_29886__$1;
(statearr_29888_29913[(2)] = inst_29882);

(statearr_29888_29913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (1))){
var state_29886__$1 = state_29886;
var statearr_29889_29914 = state_29886__$1;
(statearr_29889_29914[(2)] = null);

(statearr_29889_29914[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (4))){
var inst_29857 = (state_29886[(7)]);
var inst_29857__$1 = (state_29886[(2)]);
var inst_29858 = (inst_29857__$1 == null);
var state_29886__$1 = (function (){var statearr_29890 = state_29886;
(statearr_29890[(7)] = inst_29857__$1);

return statearr_29890;
})();
if(cljs.core.truth_(inst_29858)){
var statearr_29891_29915 = state_29886__$1;
(statearr_29891_29915[(1)] = (5));

} else {
var statearr_29892_29916 = state_29886__$1;
(statearr_29892_29916[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (6))){
var inst_29857 = (state_29886[(7)]);
var inst_29865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29857,(0),null);
var inst_29866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29857,(1),null);
var state_29886__$1 = (function (){var statearr_29893 = state_29886;
(statearr_29893[(8)] = inst_29866);

(statearr_29893[(9)] = inst_29865);

return statearr_29893;
})();
var statearr_29894_29917 = state_29886__$1;
(statearr_29894_29917[(2)] = null);

(statearr_29894_29917[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (3))){
var inst_29884 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29886__$1,inst_29884);
} else {
if((state_val_29887 === (2))){
var state_29886__$1 = state_29886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29886__$1,(4),pub_chan);
} else {
if((state_val_29887 === (11))){
var _ = (function (){var statearr_29896 = state_29886;
(statearr_29896[(4)] = cljs.core.rest((state_29886[(4)])));

return statearr_29896;
})();
var state_29886__$1 = state_29886;
var ex29895 = (state_29886__$1[(2)]);
var statearr_29897_29918 = state_29886__$1;
(statearr_29897_29918[(5)] = ex29895);


if((ex29895 instanceof Error)){
var statearr_29898_29919 = state_29886__$1;
(statearr_29898_29919[(1)] = (10));

(statearr_29898_29919[(5)] = null);

} else {
throw ex29895;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (9))){
var inst_29879 = (state_29886[(2)]);
var state_29886__$1 = (function (){var statearr_29899 = state_29886;
(statearr_29899[(10)] = inst_29879);

return statearr_29899;
})();
var statearr_29900_29920 = state_29886__$1;
(statearr_29900_29920[(2)] = null);

(statearr_29900_29920[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (5))){
var inst_29860 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_29886__$1 = state_29886;
var statearr_29901_29921 = state_29886__$1;
(statearr_29901_29921[(2)] = inst_29860);

(statearr_29901_29921[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (10))){
var inst_29866 = (state_29886[(8)]);
var inst_29867 = (state_29886[(2)]);
var inst_29868 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29867,"Websocket send message error:",inst_29867], 0));
var inst_29869 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29866,false);
var state_29886__$1 = (function (){var statearr_29902 = state_29886;
(statearr_29902[(11)] = inst_29868);

return statearr_29902;
})();
var statearr_29903_29922 = state_29886__$1;
(statearr_29903_29922[(2)] = inst_29869);

(statearr_29903_29922[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29887 === (8))){
var inst_29866 = (state_29886[(8)]);
var inst_29865 = (state_29886[(9)]);
var _ = (function (){var statearr_29904 = state_29886;
(statearr_29904[(4)] = cljs.core.cons((11),(state_29886[(4)])));

return statearr_29904;
})();
var inst_29875 = ws.send(inst_29865);
var inst_29876 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29866,true);
var ___$1 = (function (){var statearr_29905 = state_29886;
(statearr_29905[(4)] = cljs.core.rest((state_29886[(4)])));

return statearr_29905;
})();
var state_29886__$1 = (function (){var statearr_29906 = state_29886;
(statearr_29906[(12)] = inst_29875);

return statearr_29906;
})();
var statearr_29907_29923 = state_29886__$1;
(statearr_29907_29923[(2)] = inst_29876);

(statearr_29907_29923[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0 = (function (){
var statearr_29908 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29908[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__);

(statearr_29908[(1)] = (1));

return statearr_29908;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1 = (function (state_29886){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29886);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29909){var ex__13886__auto__ = e29909;
var statearr_29910_29924 = state_29886;
(statearr_29910_29924[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29886[(4)]))){
var statearr_29911_29925 = state_29886;
(statearr_29911_29925[(1)] = cljs.core.first((state_29886[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29926 = state_29886;
state_29886 = G__29926;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__ = function(state_29886){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1.call(this,state_29886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29912 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29912[(6)] = c__13957__auto__);

return statearr_29912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__13957__auto___29965 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29952){
var state_val_29953 = (state_29952[(1)]);
if((state_val_29953 === (1))){
var inst_29931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29932 = [open_QMARK_,timeout_chan];
var inst_29933 = (new cljs.core.PersistentVector(null,2,(5),inst_29931,inst_29932,null));
var state_29952__$1 = state_29952;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_29952__$1,(2),inst_29933,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_29953 === (2))){
var inst_29935 = (state_29952[(2)]);
var inst_29936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29935,(0),null);
var inst_29937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29935,(1),null);
var inst_29938 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29937,timeout_chan);
var state_29952__$1 = (function (){var statearr_29954 = state_29952;
(statearr_29954[(7)] = inst_29936);

return statearr_29954;
})();
if(inst_29938){
var statearr_29955_29966 = state_29952__$1;
(statearr_29955_29966[(1)] = (3));

} else {
var statearr_29956_29967 = state_29952__$1;
(statearr_29956_29967[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (3))){
var inst_29940 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_29941 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29942 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_29943 = cljs.core.PersistentHashMap.fromArrays(inst_29941,inst_29942);
var inst_29944 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29940,inst_29943);
var inst_29945 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_29944);
var inst_29946 = fluree.db.util.xhttp.close_websocket(ws);
var state_29952__$1 = (function (){var statearr_29957 = state_29952;
(statearr_29957[(8)] = inst_29945);

return statearr_29957;
})();
var statearr_29958_29968 = state_29952__$1;
(statearr_29958_29968[(2)] = inst_29946);

(statearr_29958_29968[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (4))){
var inst_29948 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_29952__$1 = state_29952;
var statearr_29959_29969 = state_29952__$1;
(statearr_29959_29969[(2)] = inst_29948);

(statearr_29959_29969[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (5))){
var inst_29950 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29952__$1,inst_29950);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_29960 = [null,null,null,null,null,null,null,null,null];
(statearr_29960[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__);

(statearr_29960[(1)] = (1));

return statearr_29960;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1 = (function (state_29952){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29952);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29961){var ex__13886__auto__ = e29961;
var statearr_29962_29970 = state_29952;
(statearr_29962_29970[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29952[(4)]))){
var statearr_29963_29971 = state_29952;
(statearr_29963_29971[(1)] = cljs.core.first((state_29952[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29972 = state_29952;
state_29952 = G__29972;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__ = function(state_29952){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1.call(this,state_29952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29964 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29964[(6)] = c__13957__auto___29965);

return statearr_29964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
