// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4160__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24379){
var state_val_24380 = (state_24379[(1)]);
if((state_val_24380 === (7))){
var inst_24374 = (state_24379[(2)]);
var _ = (function (){var statearr_24381 = state_24379;
(statearr_24381[(4)] = cljs.core.rest((state_24379[(4)])));

return statearr_24381;
})();
var state_24379__$1 = state_24379;
var statearr_24382_24404 = state_24379__$1;
(statearr_24382_24404[(2)] = inst_24374);

(statearr_24382_24404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (1))){
var state_24379__$1 = state_24379;
var statearr_24383_24405 = state_24379__$1;
(statearr_24383_24405[(2)] = null);

(statearr_24383_24405[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (4))){
var inst_24336 = (state_24379[(2)]);
var state_24379__$1 = state_24379;
var statearr_24384_24406 = state_24379__$1;
(statearr_24384_24406[(2)] = inst_24336);

(statearr_24384_24406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (6))){
var inst_24354 = (state_24379[(7)]);
var inst_24361 = (state_24379[(8)]);
var inst_24360 = cljs.core.seq(inst_24354);
var inst_24361__$1 = cljs.core.first(inst_24360);
var inst_24362 = cljs.core.next(inst_24360);
var inst_24363 = cljs.core.not(inst_24361__$1);
var state_24379__$1 = (function (){var statearr_24385 = state_24379;
(statearr_24385[(8)] = inst_24361__$1);

(statearr_24385[(9)] = inst_24362);

return statearr_24385;
})();
if(inst_24363){
var statearr_24386_24407 = state_24379__$1;
(statearr_24386_24407[(1)] = (8));

} else {
var statearr_24387_24408 = state_24379__$1;
(statearr_24387_24408[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (3))){
var inst_24377 = (state_24379[(2)]);
var state_24379__$1 = state_24379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24379__$1,inst_24377);
} else {
if((state_val_24380 === (2))){
var _ = (function (){var statearr_24388 = state_24379;
(statearr_24388[(4)] = cljs.core.cons((5),(state_24379[(4)])));

return statearr_24388;
})();
var inst_24349 = chs;
var inst_24350 = cljs.core.seq(inst_24349);
var inst_24351 = cljs.core.first(inst_24350);
var inst_24352 = cljs.core.next(inst_24350);
var inst_24353 = coll;
var inst_24354 = inst_24349;
var inst_24355 = inst_24353;
var state_24379__$1 = (function (){var statearr_24389 = state_24379;
(statearr_24389[(10)] = inst_24355);

(statearr_24389[(7)] = inst_24354);

(statearr_24389[(11)] = inst_24352);

(statearr_24389[(12)] = inst_24351);

return statearr_24389;
})();
var statearr_24390_24409 = state_24379__$1;
(statearr_24390_24409[(2)] = null);

(statearr_24390_24409[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (11))){
var inst_24355 = (state_24379[(10)]);
var inst_24362 = (state_24379[(9)]);
var inst_24367 = (state_24379[(2)]);
var inst_24368 = fluree.db.util.async.throw_err(inst_24367);
var inst_24369 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24355,inst_24368);
var inst_24354 = inst_24362;
var inst_24355__$1 = inst_24369;
var state_24379__$1 = (function (){var statearr_24392 = state_24379;
(statearr_24392[(10)] = inst_24355__$1);

(statearr_24392[(7)] = inst_24354);

return statearr_24392;
})();
var statearr_24393_24410 = state_24379__$1;
(statearr_24393_24410[(2)] = null);

(statearr_24393_24410[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (9))){
var inst_24361 = (state_24379[(8)]);
var state_24379__$1 = state_24379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24379__$1,(11),inst_24361);
} else {
if((state_val_24380 === (5))){
var _ = (function (){var statearr_24394 = state_24379;
(statearr_24394[(4)] = cljs.core.rest((state_24379[(4)])));

return statearr_24394;
})();
var state_24379__$1 = state_24379;
var ex24391 = (state_24379__$1[(2)]);
var statearr_24395_24411 = state_24379__$1;
(statearr_24395_24411[(5)] = ex24391);


var statearr_24396_24412 = state_24379__$1;
(statearr_24396_24412[(1)] = (4));

(statearr_24396_24412[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (10))){
var inst_24372 = (state_24379[(2)]);
var state_24379__$1 = state_24379;
var statearr_24397_24413 = state_24379__$1;
(statearr_24397_24413[(2)] = inst_24372);

(statearr_24397_24413[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24380 === (8))){
var inst_24355 = (state_24379[(10)]);
var state_24379__$1 = state_24379;
var statearr_24398_24414 = state_24379__$1;
(statearr_24398_24414[(2)] = inst_24355);

(statearr_24398_24414[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_24399 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24399[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__);

(statearr_24399[(1)] = (1));

return statearr_24399;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____1 = (function (state_24379){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24379);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24400){var ex__13886__auto__ = e24400;
var statearr_24401_24415 = state_24379;
(statearr_24401_24415[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24379[(4)]))){
var statearr_24402_24416 = state_24379;
(statearr_24402_24416[(1)] = cljs.core.first((state_24379[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24417 = state_24379;
state_24379 = G__24417;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__ = function(state_24379){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____1.call(this,state_24379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24403 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24403[(6)] = c__13957__auto__);

return statearr_24403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24443){
var state_val_24444 = (state_24443[(1)]);
if((state_val_24444 === (7))){
var inst_24438 = (state_24443[(2)]);
var _ = (function (){var statearr_24445 = state_24443;
(statearr_24445[(4)] = cljs.core.rest((state_24443[(4)])));

return statearr_24445;
})();
var state_24443__$1 = state_24443;
var statearr_24446_24468 = state_24443__$1;
(statearr_24446_24468[(2)] = inst_24438);

(statearr_24446_24468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (1))){
var state_24443__$1 = state_24443;
var statearr_24447_24469 = state_24443__$1;
(statearr_24447_24469[(2)] = null);

(statearr_24447_24469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (4))){
var inst_24418 = (state_24443[(2)]);
var state_24443__$1 = state_24443;
var statearr_24448_24470 = state_24443__$1;
(statearr_24448_24470[(2)] = inst_24418);

(statearr_24448_24470[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (6))){
var state_24443__$1 = state_24443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24443__$1,(8),chan);
} else {
if((state_val_24444 === (3))){
var inst_24441 = (state_24443[(2)]);
var state_24443__$1 = state_24443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24443__$1,inst_24441);
} else {
if((state_val_24444 === (2))){
var _ = (function (){var statearr_24449 = state_24443;
(statearr_24449[(4)] = cljs.core.cons((5),(state_24443[(4)])));

return statearr_24449;
})();
var inst_24424 = coll;
var inst_24425 = inst_24424;
var state_24443__$1 = (function (){var statearr_24450 = state_24443;
(statearr_24450[(7)] = inst_24425);

return statearr_24450;
})();
var statearr_24451_24471 = state_24443__$1;
(statearr_24451_24471[(2)] = null);

(statearr_24451_24471[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (11))){
var inst_24436 = (state_24443[(2)]);
var state_24443__$1 = state_24443;
var statearr_24453_24472 = state_24443__$1;
(statearr_24453_24472[(2)] = inst_24436);

(statearr_24453_24472[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (9))){
var inst_24425 = (state_24443[(7)]);
var state_24443__$1 = state_24443;
var statearr_24454_24473 = state_24443__$1;
(statearr_24454_24473[(2)] = inst_24425);

(statearr_24454_24473[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (5))){
var _ = (function (){var statearr_24455 = state_24443;
(statearr_24455[(4)] = cljs.core.rest((state_24443[(4)])));

return statearr_24455;
})();
var state_24443__$1 = state_24443;
var ex24452 = (state_24443__$1[(2)]);
var statearr_24456_24474 = state_24443__$1;
(statearr_24456_24474[(5)] = ex24452);


var statearr_24457_24475 = state_24443__$1;
(statearr_24457_24475[(1)] = (4));

(statearr_24457_24475[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (10))){
var inst_24425 = (state_24443[(7)]);
var inst_24429 = (state_24443[(8)]);
var inst_24433 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24425,inst_24429);
var inst_24425__$1 = inst_24433;
var state_24443__$1 = (function (){var statearr_24458 = state_24443;
(statearr_24458[(7)] = inst_24425__$1);

return statearr_24458;
})();
var statearr_24459_24476 = state_24443__$1;
(statearr_24459_24476[(2)] = null);

(statearr_24459_24476[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24444 === (8))){
var inst_24429 = (state_24443[(8)]);
var inst_24428 = (state_24443[(2)]);
var inst_24429__$1 = fluree.db.util.async.throw_err(inst_24428);
var inst_24430 = (inst_24429__$1 == null);
var state_24443__$1 = (function (){var statearr_24460 = state_24443;
(statearr_24460[(8)] = inst_24429__$1);

return statearr_24460;
})();
if(cljs.core.truth_(inst_24430)){
var statearr_24461_24477 = state_24443__$1;
(statearr_24461_24477[(1)] = (9));

} else {
var statearr_24462_24478 = state_24443__$1;
(statearr_24462_24478[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_24463 = [null,null,null,null,null,null,null,null,null];
(statearr_24463[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__);

(statearr_24463[(1)] = (1));

return statearr_24463;
});
var fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____1 = (function (state_24443){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24443);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24464){var ex__13886__auto__ = e24464;
var statearr_24465_24479 = state_24443;
(statearr_24465_24479[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24443[(4)]))){
var statearr_24466_24480 = state_24443;
(statearr_24466_24480[(1)] = cljs.core.first((state_24443[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24481 = state_24443;
state_24443 = G__24481;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__ = function(state_24443){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____1.call(this,state_24443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__13883__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24467 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24467[(6)] = c__13957__auto__);

return statearr_24467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
