// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37265){
var state_val_37266 = (state_37265[(1)]);
if((state_val_37266 === (7))){
var inst_37254 = (state_37265[(7)]);
var inst_37256 = fluree.db.storage.core.serde(conn);
var inst_37257 = fluree.db.serde.protocol._deserialize_block(inst_37256,inst_37254);
var state_37265__$1 = state_37265;
var statearr_37267_37286 = state_37265__$1;
(statearr_37267_37286[(2)] = inst_37257);

(statearr_37267_37286[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (1))){
var state_37265__$1 = state_37265;
var statearr_37268_37287 = state_37265__$1;
(statearr_37268_37287[(2)] = null);

(statearr_37268_37287[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (4))){
var inst_37244 = (state_37265[(2)]);
var state_37265__$1 = state_37265;
var statearr_37269_37288 = state_37265__$1;
(statearr_37269_37288[(2)] = inst_37244);

(statearr_37269_37288[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (6))){
var inst_37254 = (state_37265[(7)]);
var inst_37253 = (state_37265[(2)]);
var inst_37254__$1 = fluree.db.util.async.throw_err(inst_37253);
var state_37265__$1 = (function (){var statearr_37270 = state_37265;
(statearr_37270[(7)] = inst_37254__$1);

return statearr_37270;
})();
if(cljs.core.truth_(inst_37254__$1)){
var statearr_37271_37289 = state_37265__$1;
(statearr_37271_37289[(1)] = (7));

} else {
var statearr_37272_37290 = state_37265__$1;
(statearr_37272_37290[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (3))){
var inst_37263 = (state_37265[(2)]);
var state_37265__$1 = state_37265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37265__$1,inst_37263);
} else {
if((state_val_37266 === (2))){
var _ = (function (){var statearr_37274 = state_37265;
(statearr_37274[(4)] = cljs.core.cons((5),(state_37265[(4)])));

return statearr_37274;
})();
var inst_37250 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_37251 = fluree.db.storage.core.storage_read(conn,inst_37250);
var state_37265__$1 = state_37265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37265__$1,(6),inst_37251);
} else {
if((state_val_37266 === (9))){
var inst_37260 = (state_37265[(2)]);
var _ = (function (){var statearr_37275 = state_37265;
(statearr_37275[(4)] = cljs.core.rest((state_37265[(4)])));

return statearr_37275;
})();
var state_37265__$1 = state_37265;
var statearr_37276_37291 = state_37265__$1;
(statearr_37276_37291[(2)] = inst_37260);

(statearr_37276_37291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (5))){
var _ = (function (){var statearr_37277 = state_37265;
(statearr_37277[(4)] = cljs.core.rest((state_37265[(4)])));

return statearr_37277;
})();
var state_37265__$1 = state_37265;
var ex37273 = (state_37265__$1[(2)]);
var statearr_37278_37292 = state_37265__$1;
(statearr_37278_37292[(5)] = ex37273);


if((ex37273 instanceof Error)){
var statearr_37279_37293 = state_37265__$1;
(statearr_37279_37293[(1)] = (4));

(statearr_37279_37293[(5)] = null);

} else {
throw ex37273;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37266 === (8))){
var state_37265__$1 = state_37265;
var statearr_37280_37294 = state_37265__$1;
(statearr_37280_37294[(2)] = null);

(statearr_37280_37294[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__13883__auto____0 = (function (){
var statearr_37281 = [null,null,null,null,null,null,null,null];
(statearr_37281[(0)] = fluree$db$storage$core$read_block_$_state_machine__13883__auto__);

(statearr_37281[(1)] = (1));

return statearr_37281;
});
var fluree$db$storage$core$read_block_$_state_machine__13883__auto____1 = (function (state_37265){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37265);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37282){var ex__13886__auto__ = e37282;
var statearr_37283_37295 = state_37265;
(statearr_37283_37295[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37265[(4)]))){
var statearr_37284_37296 = state_37265;
(statearr_37284_37296[(1)] = cljs.core.first((state_37265[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37297 = state_37265;
state_37265 = G__37297;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__13883__auto__ = function(state_37265){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__13883__auto____1.call(this,state_37265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37285 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37285[(6)] = c__13957__auto__);

return statearr_37285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37320){
var state_val_37321 = (state_37320[(1)]);
if((state_val_37321 === (7))){
var inst_37309 = (state_37320[(7)]);
var inst_37311 = fluree.db.storage.core.serde(conn);
var inst_37312 = fluree.db.serde.protocol._deserialize_block(inst_37311,inst_37309);
var state_37320__$1 = state_37320;
var statearr_37322_37341 = state_37320__$1;
(statearr_37322_37341[(2)] = inst_37312);

(statearr_37322_37341[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (1))){
var state_37320__$1 = state_37320;
var statearr_37323_37342 = state_37320__$1;
(statearr_37323_37342[(2)] = null);

(statearr_37323_37342[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (4))){
var inst_37298 = (state_37320[(2)]);
var state_37320__$1 = state_37320;
var statearr_37324_37343 = state_37320__$1;
(statearr_37324_37343[(2)] = inst_37298);

(statearr_37324_37343[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (6))){
var inst_37309 = (state_37320[(7)]);
var inst_37308 = (state_37320[(2)]);
var inst_37309__$1 = fluree.db.util.async.throw_err(inst_37308);
var state_37320__$1 = (function (){var statearr_37325 = state_37320;
(statearr_37325[(7)] = inst_37309__$1);

return statearr_37325;
})();
if(cljs.core.truth_(inst_37309__$1)){
var statearr_37326_37344 = state_37320__$1;
(statearr_37326_37344[(1)] = (7));

} else {
var statearr_37327_37345 = state_37320__$1;
(statearr_37327_37345[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (3))){
var inst_37318 = (state_37320[(2)]);
var state_37320__$1 = state_37320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37320__$1,inst_37318);
} else {
if((state_val_37321 === (2))){
var _ = (function (){var statearr_37329 = state_37320;
(statearr_37329[(4)] = cljs.core.cons((5),(state_37320[(4)])));

return statearr_37329;
})();
var inst_37304 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_37305 = [inst_37304,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_37306 = fluree.db.storage.core.storage_read(conn,inst_37305);
var state_37320__$1 = state_37320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37320__$1,(6),inst_37306);
} else {
if((state_val_37321 === (9))){
var inst_37315 = (state_37320[(2)]);
var _ = (function (){var statearr_37330 = state_37320;
(statearr_37330[(4)] = cljs.core.rest((state_37320[(4)])));

return statearr_37330;
})();
var state_37320__$1 = state_37320;
var statearr_37331_37346 = state_37320__$1;
(statearr_37331_37346[(2)] = inst_37315);

(statearr_37331_37346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (5))){
var _ = (function (){var statearr_37332 = state_37320;
(statearr_37332[(4)] = cljs.core.rest((state_37320[(4)])));

return statearr_37332;
})();
var state_37320__$1 = state_37320;
var ex37328 = (state_37320__$1[(2)]);
var statearr_37333_37347 = state_37320__$1;
(statearr_37333_37347[(5)] = ex37328);


if((ex37328 instanceof Error)){
var statearr_37334_37348 = state_37320__$1;
(statearr_37334_37348[(1)] = (4));

(statearr_37334_37348[(5)] = null);

} else {
throw ex37328;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37321 === (8))){
var state_37320__$1 = state_37320;
var statearr_37335_37349 = state_37320__$1;
(statearr_37335_37349[(2)] = null);

(statearr_37335_37349[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0 = (function (){
var statearr_37336 = [null,null,null,null,null,null,null,null];
(statearr_37336[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__);

(statearr_37336[(1)] = (1));

return statearr_37336;
});
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1 = (function (state_37320){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37320);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37337){var ex__13886__auto__ = e37337;
var statearr_37338_37350 = state_37320;
(statearr_37338_37350[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37320[(4)]))){
var statearr_37339_37351 = state_37320;
(statearr_37339_37351[(1)] = cljs.core.first((state_37320[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37352 = state_37320;
state_37320 = G__37352;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__ = function(state_37320){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1.call(this,state_37320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37340 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37340[(6)] = c__13957__auto__);

return statearr_37340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37376){
var state_val_37377 = (state_37376[(1)]);
if((state_val_37377 === (1))){
var state_37376__$1 = state_37376;
var statearr_37378_37392 = state_37376__$1;
(statearr_37378_37392[(2)] = null);

(statearr_37378_37392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37377 === (2))){
var _ = (function (){var statearr_37379 = state_37376;
(statearr_37379[(4)] = cljs.core.cons((5),(state_37376[(4)])));

return statearr_37379;
})();
var inst_37359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37360 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_37361 = (new cljs.core.PersistentVector(null,3,(5),inst_37359,inst_37360,null));
var inst_37362 = cljs.core.select_keys(block_data,inst_37361);
var inst_37363 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_37362);
var inst_37364 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_37363);
var inst_37365 = [inst_37364,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_37366 = fluree.db.storage.core.serde(conn);
var inst_37367 = fluree.db.serde.protocol._serialize_block(inst_37366,inst_37362);
var inst_37368 = fluree.db.storage.core.storage_write(conn,inst_37365,inst_37367);
var state_37376__$1 = state_37376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37376__$1,(6),inst_37368);
} else {
if((state_val_37377 === (3))){
var inst_37374 = (state_37376[(2)]);
var state_37376__$1 = state_37376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37376__$1,inst_37374);
} else {
if((state_val_37377 === (4))){
var inst_37353 = (state_37376[(2)]);
var state_37376__$1 = state_37376;
var statearr_37381_37393 = state_37376__$1;
(statearr_37381_37393[(2)] = inst_37353);

(statearr_37381_37393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37377 === (5))){
var _ = (function (){var statearr_37382 = state_37376;
(statearr_37382[(4)] = cljs.core.rest((state_37376[(4)])));

return statearr_37382;
})();
var state_37376__$1 = state_37376;
var ex37380 = (state_37376__$1[(2)]);
var statearr_37383_37394 = state_37376__$1;
(statearr_37383_37394[(5)] = ex37380);


if((ex37380 instanceof Error)){
var statearr_37384_37395 = state_37376__$1;
(statearr_37384_37395[(1)] = (4));

(statearr_37384_37395[(5)] = null);

} else {
throw ex37380;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37377 === (6))){
var inst_37370 = (state_37376[(2)]);
var inst_37371 = fluree.db.util.async.throw_err(inst_37370);
var _ = (function (){var statearr_37385 = state_37376;
(statearr_37385[(4)] = cljs.core.rest((state_37376[(4)])));

return statearr_37385;
})();
var state_37376__$1 = state_37376;
var statearr_37386_37396 = state_37376__$1;
(statearr_37386_37396[(2)] = inst_37371);

(statearr_37386_37396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0 = (function (){
var statearr_37387 = [null,null,null,null,null,null,null];
(statearr_37387[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__);

(statearr_37387[(1)] = (1));

return statearr_37387;
});
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1 = (function (state_37376){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37376);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37388){var ex__13886__auto__ = e37388;
var statearr_37389_37397 = state_37376;
(statearr_37389_37397[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37376[(4)]))){
var statearr_37390_37398 = state_37376;
(statearr_37390_37398[(1)] = cljs.core.first((state_37376[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37399 = state_37376;
state_37376 = G__37399;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__ = function(state_37376){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1.call(this,state_37376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37391 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37391[(6)] = c__13957__auto__);

return statearr_37391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37422){
var state_val_37423 = (state_37422[(1)]);
if((state_val_37423 === (1))){
var state_37422__$1 = state_37422;
var statearr_37424_37438 = state_37422__$1;
(statearr_37424_37438[(2)] = null);

(statearr_37424_37438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37423 === (2))){
var _ = (function (){var statearr_37425 = state_37422;
(statearr_37425[(4)] = cljs.core.cons((5),(state_37422[(4)])));

return statearr_37425;
})();
var inst_37406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37407 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_37408 = (new cljs.core.PersistentVector(null,3,(5),inst_37406,inst_37407,null));
var inst_37409 = cljs.core.select_keys(block_data,inst_37408);
var inst_37410 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_37409);
var inst_37411 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_37410);
var inst_37412 = fluree.db.storage.core.serde(conn);
var inst_37413 = fluree.db.serde.protocol._serialize_block(inst_37412,inst_37409);
var inst_37414 = fluree.db.storage.core.storage_write(conn,inst_37411,inst_37413);
var state_37422__$1 = state_37422;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37422__$1,(6),inst_37414);
} else {
if((state_val_37423 === (3))){
var inst_37420 = (state_37422[(2)]);
var state_37422__$1 = state_37422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37422__$1,inst_37420);
} else {
if((state_val_37423 === (4))){
var inst_37400 = (state_37422[(2)]);
var state_37422__$1 = state_37422;
var statearr_37427_37439 = state_37422__$1;
(statearr_37427_37439[(2)] = inst_37400);

(statearr_37427_37439[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37423 === (5))){
var _ = (function (){var statearr_37428 = state_37422;
(statearr_37428[(4)] = cljs.core.rest((state_37422[(4)])));

return statearr_37428;
})();
var state_37422__$1 = state_37422;
var ex37426 = (state_37422__$1[(2)]);
var statearr_37429_37440 = state_37422__$1;
(statearr_37429_37440[(5)] = ex37426);


if((ex37426 instanceof Error)){
var statearr_37430_37441 = state_37422__$1;
(statearr_37430_37441[(1)] = (4));

(statearr_37430_37441[(5)] = null);

} else {
throw ex37426;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37423 === (6))){
var inst_37416 = (state_37422[(2)]);
var inst_37417 = fluree.db.util.async.throw_err(inst_37416);
var _ = (function (){var statearr_37431 = state_37422;
(statearr_37431[(4)] = cljs.core.rest((state_37422[(4)])));

return statearr_37431;
})();
var state_37422__$1 = state_37422;
var statearr_37432_37442 = state_37422__$1;
(statearr_37432_37442[(2)] = inst_37417);

(statearr_37432_37442[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__13883__auto____0 = (function (){
var statearr_37433 = [null,null,null,null,null,null,null];
(statearr_37433[(0)] = fluree$db$storage$core$write_block_$_state_machine__13883__auto__);

(statearr_37433[(1)] = (1));

return statearr_37433;
});
var fluree$db$storage$core$write_block_$_state_machine__13883__auto____1 = (function (state_37422){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37422);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37434){var ex__13886__auto__ = e37434;
var statearr_37435_37443 = state_37422;
(statearr_37435_37443[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37422[(4)]))){
var statearr_37436_37444 = state_37422;
(statearr_37436_37444[(1)] = cljs.core.first((state_37422[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37445 = state_37422;
state_37422 = G__37445;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__13883__auto__ = function(state_37422){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__13883__auto____1.call(this,state_37422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37437 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37437[(6)] = c__13957__auto__);

return statearr_37437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37465){
var state_val_37466 = (state_37465[(1)]);
if((state_val_37466 === (1))){
var state_37465__$1 = state_37465;
var statearr_37467_37481 = state_37465__$1;
(statearr_37467_37481[(2)] = null);

(statearr_37467_37481[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37466 === (2))){
var _ = (function (){var statearr_37468 = state_37465;
(statearr_37468[(4)] = cljs.core.cons((5),(state_37465[(4)])));

return statearr_37468;
})();
var inst_37452 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_37453 = [history,next_his_key];
var inst_37454 = cljs.core.PersistentHashMap.fromArrays(inst_37452,inst_37453);
var inst_37455 = fluree.db.storage.core.serde(conn);
var inst_37456 = fluree.db.serde.protocol._serialize_leaf(inst_37455,inst_37454);
var inst_37457 = fluree.db.storage.core.storage_write(conn,his_key,inst_37456);
var state_37465__$1 = state_37465;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37465__$1,(6),inst_37457);
} else {
if((state_val_37466 === (3))){
var inst_37463 = (state_37465[(2)]);
var state_37465__$1 = state_37465;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37465__$1,inst_37463);
} else {
if((state_val_37466 === (4))){
var inst_37446 = (state_37465[(2)]);
var state_37465__$1 = state_37465;
var statearr_37470_37482 = state_37465__$1;
(statearr_37470_37482[(2)] = inst_37446);

(statearr_37470_37482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37466 === (5))){
var _ = (function (){var statearr_37471 = state_37465;
(statearr_37471[(4)] = cljs.core.rest((state_37465[(4)])));

return statearr_37471;
})();
var state_37465__$1 = state_37465;
var ex37469 = (state_37465__$1[(2)]);
var statearr_37472_37483 = state_37465__$1;
(statearr_37472_37483[(5)] = ex37469);


if((ex37469 instanceof Error)){
var statearr_37473_37484 = state_37465__$1;
(statearr_37473_37484[(1)] = (4));

(statearr_37473_37484[(5)] = null);

} else {
throw ex37469;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37466 === (6))){
var inst_37459 = (state_37465[(2)]);
var inst_37460 = fluree.db.util.async.throw_err(inst_37459);
var _ = (function (){var statearr_37474 = state_37465;
(statearr_37474[(4)] = cljs.core.rest((state_37465[(4)])));

return statearr_37474;
})();
var state_37465__$1 = state_37465;
var statearr_37475_37485 = state_37465__$1;
(statearr_37475_37485[(2)] = inst_37460);

(statearr_37475_37485[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__13883__auto____0 = (function (){
var statearr_37476 = [null,null,null,null,null,null,null];
(statearr_37476[(0)] = fluree$db$storage$core$write_history_$_state_machine__13883__auto__);

(statearr_37476[(1)] = (1));

return statearr_37476;
});
var fluree$db$storage$core$write_history_$_state_machine__13883__auto____1 = (function (state_37465){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37465);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37477){var ex__13886__auto__ = e37477;
var statearr_37478_37486 = state_37465;
(statearr_37478_37486[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37465[(4)]))){
var statearr_37479_37487 = state_37465;
(statearr_37479_37487[(1)] = cljs.core.first((state_37465[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37488 = state_37465;
state_37465 = G__37488;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__13883__auto__ = function(state_37465){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__13883__auto____1.call(this,state_37465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37480 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37480[(6)] = c__13957__auto__);

return statearr_37480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37514){
var state_val_37515 = (state_37514[(1)]);
if((state_val_37515 === (1))){
var state_37514__$1 = state_37514;
var statearr_37516_37533 = state_37514__$1;
(statearr_37516_37533[(2)] = null);

(statearr_37516_37533[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37515 === (2))){
var inst_37495 = (state_37514[(7)]);
var _ = (function (){var statearr_37517 = state_37514;
(statearr_37517[(4)] = cljs.core.cons((5),(state_37514[(4)])));

return statearr_37517;
})();
var inst_37495__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_37496 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37495__$1),"-his"].join('');
var inst_37497 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_37498 = [flakes,inst_37496];
var inst_37499 = cljs.core.PersistentHashMap.fromArrays(inst_37497,inst_37498);
var inst_37500 = fluree.db.storage.core.serde(conn);
var inst_37501 = fluree.db.serde.protocol._serialize_leaf(inst_37500,inst_37499);
var inst_37502 = fluree.db.storage.core.write_history(conn,history,inst_37496,null);
var inst_37503 = fluree.db.storage.core.storage_write(conn,inst_37495__$1,inst_37501);
var state_37514__$1 = (function (){var statearr_37518 = state_37514;
(statearr_37518[(7)] = inst_37495__$1);

(statearr_37518[(8)] = inst_37503);

return statearr_37518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37514__$1,(6),inst_37502);
} else {
if((state_val_37515 === (3))){
var inst_37512 = (state_37514[(2)]);
var state_37514__$1 = state_37514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37514__$1,inst_37512);
} else {
if((state_val_37515 === (4))){
var inst_37489 = (state_37514[(2)]);
var state_37514__$1 = state_37514;
var statearr_37520_37534 = state_37514__$1;
(statearr_37520_37534[(2)] = inst_37489);

(statearr_37520_37534[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37515 === (5))){
var _ = (function (){var statearr_37521 = state_37514;
(statearr_37521[(4)] = cljs.core.rest((state_37514[(4)])));

return statearr_37521;
})();
var state_37514__$1 = state_37514;
var ex37519 = (state_37514__$1[(2)]);
var statearr_37522_37535 = state_37514__$1;
(statearr_37522_37535[(5)] = ex37519);


if((ex37519 instanceof Error)){
var statearr_37523_37536 = state_37514__$1;
(statearr_37523_37536[(1)] = (4));

(statearr_37523_37536[(5)] = null);

} else {
throw ex37519;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37515 === (6))){
var inst_37503 = (state_37514[(8)]);
var inst_37505 = (state_37514[(2)]);
var inst_37506 = fluree.db.util.async.throw_err(inst_37505);
var state_37514__$1 = (function (){var statearr_37524 = state_37514;
(statearr_37524[(9)] = inst_37506);

return statearr_37524;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37514__$1,(7),inst_37503);
} else {
if((state_val_37515 === (7))){
var inst_37495 = (state_37514[(7)]);
var inst_37508 = (state_37514[(2)]);
var inst_37509 = fluree.db.util.async.throw_err(inst_37508);
var _ = (function (){var statearr_37525 = state_37514;
(statearr_37525[(4)] = cljs.core.rest((state_37514[(4)])));

return statearr_37525;
})();
var state_37514__$1 = (function (){var statearr_37526 = state_37514;
(statearr_37526[(10)] = inst_37509);

return statearr_37526;
})();
var statearr_37527_37537 = state_37514__$1;
(statearr_37527_37537[(2)] = inst_37495);

(statearr_37527_37537[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_37528 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37528[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__);

(statearr_37528[(1)] = (1));

return statearr_37528;
});
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1 = (function (state_37514){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37514);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37529){var ex__13886__auto__ = e37529;
var statearr_37530_37538 = state_37514;
(statearr_37530_37538[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37514[(4)]))){
var statearr_37531_37539 = state_37514;
(statearr_37531_37539[(1)] = cljs.core.first((state_37514[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37540 = state_37514;
state_37514 = G__37540;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__ = function(state_37514){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1.call(this,state_37514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37532 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37532[(6)] = c__13957__auto__);

return statearr_37532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37557){
var state_val_37558 = (state_37557[(1)]);
if((state_val_37558 === (1))){
var state_37557__$1 = state_37557;
var statearr_37559_37574 = state_37557__$1;
(statearr_37559_37574[(2)] = null);

(statearr_37559_37574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37558 === (2))){
var _ = (function (){var statearr_37560 = state_37557;
(statearr_37560[(4)] = cljs.core.cons((5),(state_37557[(4)])));

return statearr_37560;
})();
var inst_37547 = fluree.db.storage.core.serde(conn);
var inst_37548 = fluree.db.serde.protocol._serialize_branch(inst_37547,data);
var inst_37549 = fluree.db.storage.core.storage_write(conn,key,inst_37548);
var state_37557__$1 = state_37557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37557__$1,(6),inst_37549);
} else {
if((state_val_37558 === (3))){
var inst_37555 = (state_37557[(2)]);
var state_37557__$1 = state_37557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37557__$1,inst_37555);
} else {
if((state_val_37558 === (4))){
var inst_37541 = (state_37557[(2)]);
var state_37557__$1 = state_37557;
var statearr_37562_37575 = state_37557__$1;
(statearr_37562_37575[(2)] = inst_37541);

(statearr_37562_37575[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37558 === (5))){
var _ = (function (){var statearr_37563 = state_37557;
(statearr_37563[(4)] = cljs.core.rest((state_37557[(4)])));

return statearr_37563;
})();
var state_37557__$1 = state_37557;
var ex37561 = (state_37557__$1[(2)]);
var statearr_37564_37576 = state_37557__$1;
(statearr_37564_37576[(5)] = ex37561);


if((ex37561 instanceof Error)){
var statearr_37565_37577 = state_37557__$1;
(statearr_37565_37577[(1)] = (4));

(statearr_37565_37577[(5)] = null);

} else {
throw ex37561;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37558 === (6))){
var inst_37551 = (state_37557[(2)]);
var inst_37552 = fluree.db.util.async.throw_err(inst_37551);
var _ = (function (){var statearr_37566 = state_37557;
(statearr_37566[(4)] = cljs.core.rest((state_37557[(4)])));

return statearr_37566;
})();
var state_37557__$1 = (function (){var statearr_37567 = state_37557;
(statearr_37567[(7)] = inst_37552);

return statearr_37567;
})();
var statearr_37568_37578 = state_37557__$1;
(statearr_37568_37578[(2)] = key);

(statearr_37568_37578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0 = (function (){
var statearr_37569 = [null,null,null,null,null,null,null,null];
(statearr_37569[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__);

(statearr_37569[(1)] = (1));

return statearr_37569;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1 = (function (state_37557){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37557);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37570){var ex__13886__auto__ = e37570;
var statearr_37571_37579 = state_37557;
(statearr_37571_37579[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37557[(4)]))){
var statearr_37572_37580 = state_37557;
(statearr_37572_37580[(1)] = cljs.core.first((state_37557[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37581 = state_37557;
state_37557 = G__37581;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__ = function(state_37557){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1.call(this,state_37557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37573 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37573[(6)] = c__13957__auto__);

return statearr_37573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__37582_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__37582_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__37583){
var map__37584 = p__37583;
var map__37584__$1 = cljs.core.__destructure_map(map__37584);
var progress = map__37584__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37584__$1,cljs.core.cst$kw$garbage);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37612){
var state_val_37613 = (state_37612[(1)]);
if((state_val_37613 === (1))){
var state_37612__$1 = state_37612;
var statearr_37614_37630 = state_37612__$1;
(statearr_37614_37630[(2)] = null);

(statearr_37614_37630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37613 === (2))){
var inst_37598 = (state_37612[(7)]);
var _ = (function (){var statearr_37615 = state_37612;
(statearr_37615[(4)] = cljs.core.cons((5),(state_37612[(4)])));

return statearr_37615;
})();
var inst_37592 = db;
var inst_37593 = cljs.core.__destructure_map(inst_37592);
var inst_37594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37593,cljs.core.cst$kw$conn);
var inst_37595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37593,cljs.core.cst$kw$network);
var inst_37596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37593,cljs.core.cst$kw$dbid);
var inst_37597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37593,cljs.core.cst$kw$block);
var inst_37598__$1 = fluree.db.storage.core.ledger_garbage_key(inst_37595,inst_37596,inst_37597);
var inst_37599 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_37600 = [inst_37596,inst_37597,garbage];
var inst_37601 = cljs.core.PersistentHashMap.fromArrays(inst_37599,inst_37600);
var inst_37602 = fluree.db.storage.core.serde(inst_37594);
var inst_37603 = fluree.db.serde.protocol._serialize_garbage(inst_37602,inst_37601);
var inst_37604 = fluree.db.storage.core.storage_write(inst_37594,inst_37598__$1,inst_37603);
var state_37612__$1 = (function (){var statearr_37616 = state_37612;
(statearr_37616[(7)] = inst_37598__$1);

return statearr_37616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37612__$1,(6),inst_37604);
} else {
if((state_val_37613 === (3))){
var inst_37610 = (state_37612[(2)]);
var state_37612__$1 = state_37612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37612__$1,inst_37610);
} else {
if((state_val_37613 === (4))){
var inst_37585 = (state_37612[(2)]);
var state_37612__$1 = state_37612;
var statearr_37618_37631 = state_37612__$1;
(statearr_37618_37631[(2)] = inst_37585);

(statearr_37618_37631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37613 === (5))){
var _ = (function (){var statearr_37619 = state_37612;
(statearr_37619[(4)] = cljs.core.rest((state_37612[(4)])));

return statearr_37619;
})();
var state_37612__$1 = state_37612;
var ex37617 = (state_37612__$1[(2)]);
var statearr_37620_37632 = state_37612__$1;
(statearr_37620_37632[(5)] = ex37617);


if((ex37617 instanceof Error)){
var statearr_37621_37633 = state_37612__$1;
(statearr_37621_37633[(1)] = (4));

(statearr_37621_37633[(5)] = null);

} else {
throw ex37617;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37613 === (6))){
var inst_37598 = (state_37612[(7)]);
var inst_37606 = (state_37612[(2)]);
var inst_37607 = fluree.db.util.async.throw_err(inst_37606);
var _ = (function (){var statearr_37622 = state_37612;
(statearr_37622[(4)] = cljs.core.rest((state_37612[(4)])));

return statearr_37622;
})();
var state_37612__$1 = (function (){var statearr_37623 = state_37612;
(statearr_37623[(8)] = inst_37607);

return statearr_37623;
})();
var statearr_37624_37634 = state_37612__$1;
(statearr_37624_37634[(2)] = inst_37598);

(statearr_37624_37634[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0 = (function (){
var statearr_37625 = [null,null,null,null,null,null,null,null,null];
(statearr_37625[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__);

(statearr_37625[(1)] = (1));

return statearr_37625;
});
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1 = (function (state_37612){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37612);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37626){var ex__13886__auto__ = e37626;
var statearr_37627_37635 = state_37612;
(statearr_37627_37635[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37612[(4)]))){
var statearr_37628_37636 = state_37612;
(statearr_37628_37636[(1)] = cljs.core.first((state_37612[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37637 = state_37612;
state_37612 = G__37637;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__ = function(state_37612){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1.call(this,state_37612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37629 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37629[(6)] = c__13957__auto__);

return statearr_37629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__37639 = arguments.length;
switch (G__37639) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37695){
var state_val_37696 = (state_37695[(1)]);
if((state_val_37696 === (7))){
var state_37695__$1 = state_37695;
var statearr_37697_37723 = state_37695__$1;
(statearr_37697_37723[(2)] = (0));

(statearr_37697_37723[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (1))){
var state_37695__$1 = state_37695;
var statearr_37698_37724 = state_37695__$1;
(statearr_37698_37724[(2)] = null);

(statearr_37698_37724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (4))){
var inst_37640 = (state_37695[(2)]);
var state_37695__$1 = state_37695;
var statearr_37699_37725 = state_37695__$1;
(statearr_37699_37725[(2)] = inst_37640);

(statearr_37699_37725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (6))){
var inst_37665 = (state_37695[(7)]);
var state_37695__$1 = state_37695;
var statearr_37700_37726 = state_37695__$1;
(statearr_37700_37726[(2)] = inst_37665);

(statearr_37700_37726[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (3))){
var inst_37693 = (state_37695[(2)]);
var state_37695__$1 = state_37695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37695__$1,inst_37693);
} else {
if((state_val_37696 === (12))){
var inst_37662 = (state_37695[(8)]);
var inst_37689 = (state_37695[(2)]);
var inst_37690 = fluree.db.util.async.throw_err(inst_37689);
var _ = (function (){var statearr_37701 = state_37695;
(statearr_37701[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37701;
})();
var state_37695__$1 = (function (){var statearr_37702 = state_37695;
(statearr_37702[(9)] = inst_37690);

return statearr_37702;
})();
var statearr_37703_37727 = state_37695__$1;
(statearr_37703_37727[(2)] = inst_37662);

(statearr_37703_37727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (2))){
var inst_37653 = (state_37695[(10)]);
var inst_37657 = (state_37695[(11)]);
var inst_37655 = (state_37695[(12)]);
var inst_37665 = (state_37695[(7)]);
var _ = (function (){var statearr_37704 = state_37695;
(statearr_37704[(4)] = cljs.core.cons((5),(state_37695[(4)])));

return statearr_37704;
})();
var inst_37647 = db;
var inst_37648 = cljs.core.__destructure_map(inst_37647);
var inst_37649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$network);
var inst_37650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$t);
var inst_37651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$fork);
var inst_37652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$spot);
var inst_37653__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$stats);
var inst_37654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$conn);
var inst_37655__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$block);
var inst_37656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$psot);
var inst_37657__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$dbid);
var inst_37658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$ecount);
var inst_37659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$opst);
var inst_37660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$fork_DASH_block);
var inst_37661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648,cljs.core.cst$kw$post);
var inst_37662 = fluree.db.storage.core.ledger_root_key(inst_37649,inst_37657__$1,inst_37655__$1);
var inst_37663 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_37664 = fluree.db.storage.core.child_data(inst_37656);
var inst_37665__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_37653__$1);
var state_37695__$1 = (function (){var statearr_37705 = state_37695;
(statearr_37705[(13)] = inst_37658);

(statearr_37705[(14)] = inst_37654);

(statearr_37705[(15)] = inst_37659);

(statearr_37705[(16)] = inst_37664);

(statearr_37705[(8)] = inst_37662);

(statearr_37705[(17)] = inst_37660);

(statearr_37705[(10)] = inst_37653__$1);

(statearr_37705[(18)] = inst_37650);

(statearr_37705[(19)] = inst_37663);

(statearr_37705[(11)] = inst_37657__$1);

(statearr_37705[(20)] = inst_37661);

(statearr_37705[(21)] = inst_37651);

(statearr_37705[(12)] = inst_37655__$1);

(statearr_37705[(7)] = inst_37665__$1);

(statearr_37705[(22)] = inst_37652);

return statearr_37705;
})();
if(cljs.core.truth_(inst_37665__$1)){
var statearr_37706_37728 = state_37695__$1;
(statearr_37706_37728[(1)] = (6));

} else {
var statearr_37707_37729 = state_37695__$1;
(statearr_37707_37729[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (11))){
var inst_37654 = (state_37695[(14)]);
var inst_37659 = (state_37695[(15)]);
var inst_37664 = (state_37695[(16)]);
var inst_37662 = (state_37695[(8)]);
var inst_37660 = (state_37695[(17)]);
var inst_37653 = (state_37695[(10)]);
var inst_37650 = (state_37695[(18)]);
var inst_37663 = (state_37695[(19)]);
var inst_37657 = (state_37695[(11)]);
var inst_37661 = (state_37695[(20)]);
var inst_37651 = (state_37695[(21)]);
var inst_37669 = (state_37695[(23)]);
var inst_37655 = (state_37695[(12)]);
var inst_37652 = (state_37695[(22)]);
var inst_37674 = (state_37695[(2)]);
var inst_37675 = fluree.db.storage.core.child_data(inst_37659);
var inst_37676 = fluree.db.storage.core.child_data(inst_37661);
var inst_37677 = fluree.db.util.core.current_time_millis();
var inst_37678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37679 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_37680 = (new cljs.core.PersistentVector(null,2,(5),inst_37678,inst_37679,null));
var inst_37681 = cljs.core.select_keys(inst_37653,inst_37680);
var inst_37682 = fluree.db.storage.core.child_data(inst_37652);
var inst_37683 = [inst_37655,inst_37664,inst_37657,inst_37669,inst_37674,inst_37675,inst_37676,inst_37650,inst_37677,inst_37651,inst_37660,inst_37681,inst_37682];
var inst_37684 = cljs.core.PersistentHashMap.fromArrays(inst_37663,inst_37683);
var inst_37685 = fluree.db.storage.core.serde(inst_37654);
var inst_37686 = fluree.db.serde.protocol._serialize_db_root(inst_37685,inst_37684);
var inst_37687 = fluree.db.storage.core.storage_write(inst_37654,inst_37662,inst_37686);
var state_37695__$1 = state_37695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37695__$1,(12),inst_37687);
} else {
if((state_val_37696 === (9))){
var inst_37670 = (state_37695[(24)]);
var state_37695__$1 = state_37695;
var statearr_37709_37730 = state_37695__$1;
(statearr_37709_37730[(2)] = inst_37670);

(statearr_37709_37730[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (5))){
var _ = (function (){var statearr_37710 = state_37695;
(statearr_37710[(4)] = cljs.core.rest((state_37695[(4)])));

return statearr_37710;
})();
var state_37695__$1 = state_37695;
var ex37708 = (state_37695__$1[(2)]);
var statearr_37711_37731 = state_37695__$1;
(statearr_37711_37731[(5)] = ex37708);


if((ex37708 instanceof Error)){
var statearr_37712_37732 = state_37695__$1;
(statearr_37712_37732[(1)] = (4));

(statearr_37712_37732[(5)] = null);

} else {
throw ex37708;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (10))){
var inst_37658 = (state_37695[(13)]);
var state_37695__$1 = state_37695;
var statearr_37713_37733 = state_37695__$1;
(statearr_37713_37733[(2)] = inst_37658);

(statearr_37713_37733[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37696 === (8))){
var inst_37670 = (state_37695[(24)]);
var inst_37669 = (state_37695[(2)]);
var inst_37670__$1 = custom_ecount;
var state_37695__$1 = (function (){var statearr_37714 = state_37695;
(statearr_37714[(24)] = inst_37670__$1);

(statearr_37714[(23)] = inst_37669);

return statearr_37714;
})();
if(cljs.core.truth_(inst_37670__$1)){
var statearr_37715_37734 = state_37695__$1;
(statearr_37715_37734[(1)] = (9));

} else {
var statearr_37716_37735 = state_37695__$1;
(statearr_37716_37735[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__13883__auto__ = null;
var fluree$db$storage$core$state_machine__13883__auto____0 = (function (){
var statearr_37717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37717[(0)] = fluree$db$storage$core$state_machine__13883__auto__);

(statearr_37717[(1)] = (1));

return statearr_37717;
});
var fluree$db$storage$core$state_machine__13883__auto____1 = (function (state_37695){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37695);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37718){var ex__13886__auto__ = e37718;
var statearr_37719_37736 = state_37695;
(statearr_37719_37736[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37695[(4)]))){
var statearr_37720_37737 = state_37695;
(statearr_37720_37737[(1)] = cljs.core.first((state_37695[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37738 = state_37695;
state_37695 = G__37738;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__13883__auto__ = function(state_37695){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__13883__auto____1.call(this,state_37695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__13883__auto____0;
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__13883__auto____1;
return fluree$db$storage$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37721 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37721[(6)] = c__13957__auto__);

return statearr_37721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___37790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37768){
var state_val_37769 = (state_37768[(1)]);
if((state_val_37769 === (7))){
var inst_37755 = cljs.core.async.close_BANG_(return_ch);
var state_37768__$1 = state_37768;
var statearr_37770_37791 = state_37768__$1;
(statearr_37770_37791[(2)] = inst_37755);

(statearr_37770_37791[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (1))){
var state_37768__$1 = state_37768;
var statearr_37771_37792 = state_37768__$1;
(statearr_37771_37792[(2)] = null);

(statearr_37771_37792[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (4))){
var inst_37739 = (state_37768[(2)]);
var inst_37740 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_37741 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_37739);
var inst_37742 = cljs.core.async.close_BANG_(return_ch);
var state_37768__$1 = (function (){var statearr_37772 = state_37768;
(statearr_37772[(7)] = inst_37740);

(statearr_37772[(8)] = inst_37741);

return statearr_37772;
})();
var statearr_37773_37793 = state_37768__$1;
(statearr_37773_37793[(2)] = inst_37742);

(statearr_37773_37793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (6))){
var inst_37750 = (state_37768[(9)]);
var inst_37750__$1 = (state_37768[(2)]);
var inst_37751 = (inst_37750__$1 == null);
var inst_37752 = (inst_37750__$1 instanceof Error);
var inst_37753 = ((inst_37751) || (inst_37752));
var state_37768__$1 = (function (){var statearr_37774 = state_37768;
(statearr_37774[(9)] = inst_37750__$1);

return statearr_37774;
})();
if(cljs.core.truth_(inst_37753)){
var statearr_37775_37794 = state_37768__$1;
(statearr_37775_37794[(1)] = (7));

} else {
var statearr_37776_37795 = state_37768__$1;
(statearr_37776_37795[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (3))){
var inst_37766 = (state_37768[(2)]);
var state_37768__$1 = state_37768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37768__$1,inst_37766);
} else {
if((state_val_37769 === (2))){
var _ = (function (){var statearr_37778 = state_37768;
(statearr_37778[(4)] = cljs.core.cons((5),(state_37768[(4)])));

return statearr_37778;
})();
var inst_37748 = fluree.db.storage.core.storage_read(conn,key);
var state_37768__$1 = state_37768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37768__$1,(6),inst_37748);
} else {
if((state_val_37769 === (9))){
var inst_37763 = (state_37768[(2)]);
var _ = (function (){var statearr_37779 = state_37768;
(statearr_37779[(4)] = cljs.core.rest((state_37768[(4)])));

return statearr_37779;
})();
var state_37768__$1 = state_37768;
var statearr_37780_37796 = state_37768__$1;
(statearr_37780_37796[(2)] = inst_37763);

(statearr_37780_37796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (5))){
var _ = (function (){var statearr_37781 = state_37768;
(statearr_37781[(4)] = cljs.core.rest((state_37768[(4)])));

return statearr_37781;
})();
var state_37768__$1 = state_37768;
var ex37777 = (state_37768__$1[(2)]);
var statearr_37782_37797 = state_37768__$1;
(statearr_37782_37797[(5)] = ex37777);


var statearr_37783_37798 = state_37768__$1;
(statearr_37783_37798[(1)] = (4));

(statearr_37783_37798[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37769 === (8))){
var inst_37750 = (state_37768[(9)]);
var inst_37757 = fluree.db.storage.core.serde(conn);
var inst_37758 = fluree.db.serde.protocol._deserialize_leaf(inst_37757,inst_37750);
var inst_37759 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_37758);
var inst_37760 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_37759);
var inst_37761 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_37760);
var state_37768__$1 = state_37768;
var statearr_37784_37799 = state_37768__$1;
(statearr_37784_37799[(2)] = inst_37761);

(statearr_37784_37799[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0 = (function (){
var statearr_37785 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37785[(0)] = fluree$db$storage$core$reify_history_$_state_machine__13883__auto__);

(statearr_37785[(1)] = (1));

return statearr_37785;
});
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1 = (function (state_37768){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37768);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37786){var ex__13886__auto__ = e37786;
var statearr_37787_37800 = state_37768;
(statearr_37787_37800[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37768[(4)]))){
var statearr_37788_37801 = state_37768;
(statearr_37788_37801[(1)] = cljs.core.first((state_37768[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37802 = state_37768;
state_37768 = G__37802;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__ = function(state_37768){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1.call(this,state_37768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37789 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37789[(6)] = c__13957__auto___37790);

return statearr_37789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__37804 = arguments.length;
switch (G__37804) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4149__auto__ = rhs;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4149__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4149__auto__ = rhs;
if(cljs.core.truth_(and__4149__auto__)){
return leftmost_QMARK_;
} else {
return and__4149__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___37916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37867){
var state_val_37868 = (state_37867[(1)]);
if((state_val_37868 === (7))){
var state_37867__$1 = state_37867;
var statearr_37869_37917 = state_37867__$1;
(statearr_37869_37917[(2)] = cljs.core.cst$kw$novelty);

(statearr_37869_37917[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (20))){
var inst_37846 = cljs.core.PersistentVector.EMPTY;
var state_37867__$1 = state_37867;
var statearr_37870_37918 = state_37867__$1;
(statearr_37870_37918[(2)] = inst_37846);

(statearr_37870_37918[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (1))){
var state_37867__$1 = state_37867;
var statearr_37871_37919 = state_37867__$1;
(statearr_37871_37919[(2)] = null);

(statearr_37871_37919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (24))){
var state_37867__$1 = state_37867;
var statearr_37872_37920 = state_37867__$1;
(statearr_37872_37920[(2)] = null);

(statearr_37872_37920[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (4))){
var inst_37807 = (state_37867[(2)]);
var inst_37808 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_37809 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_37807);
var inst_37810 = cljs.core.async.close_BANG_(result_ch);
var state_37867__$1 = (function (){var statearr_37873 = state_37867;
(statearr_37873[(7)] = inst_37809);

(statearr_37873[(8)] = inst_37808);

return statearr_37873;
})();
var statearr_37874_37921 = state_37867__$1;
(statearr_37874_37921[(2)] = inst_37810);

(statearr_37874_37921[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (15))){
var inst_37832 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
var statearr_37875_37922 = state_37867__$1;
(statearr_37875_37922[(2)] = inst_37832);

(statearr_37875_37922[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (21))){
var inst_37849 = (state_37867[(9)]);
var inst_37819 = (state_37867[(10)]);
var inst_37820 = (state_37867[(11)]);
var inst_37836 = (state_37867[(12)]);
var inst_37821 = (state_37867[(13)]);
var inst_37856 = (state_37867[(2)]);
var inst_37857 = (function (){var base_node = inst_37819;
var first_flake = inst_37820;
var node_t = inst_37821;
var source = inst_37836;
var coll = inst_37849;
var conj_QMARK_ = inst_37856;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__37877 = f.p;
var fexpr__37876 = (function (){var or__4160__auto__ = remove_preds;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__37876.cljs$core$IFn$_invoke$arity$1 ? fexpr__37876.cljs$core$IFn$_invoke$arity$1(G__37877) : fexpr__37876.call(null,G__37877));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_37858 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_37819);
var inst_37859 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37857,inst_37858,inst_37849);
var inst_37860 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_37859);
var inst_37861 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37819,cljs.core.cst$kw$flakes,inst_37860);
var inst_37862 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_37861);
var _ = (function (){var statearr_37878 = state_37867;
(statearr_37878[(4)] = cljs.core.rest((state_37867[(4)])));

return statearr_37878;
})();
var state_37867__$1 = state_37867;
var statearr_37879_37923 = state_37867__$1;
(statearr_37879_37923[(2)] = inst_37862);

(statearr_37879_37923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (13))){
var state_37867__$1 = state_37867;
var statearr_37880_37924 = state_37867__$1;
(statearr_37880_37924[(2)] = cljs.core.cst$kw$none);

(statearr_37880_37924[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (22))){
var inst_37849 = (state_37867[(9)]);
var inst_37819 = (state_37867[(10)]);
var inst_37820 = (state_37867[(11)]);
var inst_37836 = (state_37867[(12)]);
var inst_37821 = (state_37867[(13)]);
var inst_37850 = (function (){var base_node = inst_37819;
var first_flake = inst_37820;
var node_t = inst_37821;
var source = inst_37836;
var coll = inst_37849;
return (function (f){
return f.op === true;
});
})();
var state_37867__$1 = state_37867;
var statearr_37881_37925 = state_37867__$1;
(statearr_37881_37925[(2)] = inst_37850);

(statearr_37881_37925[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (6))){
var inst_37819 = (state_37867[(10)]);
var inst_37821 = (state_37867[(13)]);
var inst_37818 = (state_37867[(2)]);
var inst_37819__$1 = fluree.db.util.async.throw_err(inst_37818);
var inst_37820 = fluree.db.dbproto._first_flake(inst_37819__$1);
var inst_37821__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_37819__$1);
var inst_37822 = (inst_37821__$1 > t);
var state_37867__$1 = (function (){var statearr_37882 = state_37867;
(statearr_37882[(10)] = inst_37819__$1);

(statearr_37882[(11)] = inst_37820);

(statearr_37882[(13)] = inst_37821__$1);

return statearr_37882;
})();
if(cljs.core.truth_(inst_37822)){
var statearr_37883_37926 = state_37867__$1;
(statearr_37883_37926[(1)] = (7));

} else {
var statearr_37884_37927 = state_37867__$1;
(statearr_37884_37927[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (17))){
var inst_37820 = (state_37867[(11)]);
var inst_37837 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_37820,rhs,leftmost_QMARK_,t);
var state_37867__$1 = state_37867;
var statearr_37885_37928 = state_37867__$1;
(statearr_37885_37928[(2)] = inst_37837);

(statearr_37885_37928[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (3))){
var inst_37865 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37867__$1,inst_37865);
} else {
if((state_val_37868 === (12))){
var inst_37834 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
var statearr_37886_37929 = state_37867__$1;
(statearr_37886_37929[(2)] = inst_37834);

(statearr_37886_37929[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (2))){
var _ = (function (){var statearr_37887 = state_37867;
(statearr_37887[(4)] = cljs.core.cons((5),(state_37867[(4)])));

return statearr_37887;
})();
var inst_37816 = fluree.db.dbproto._resolve(node);
var state_37867__$1 = state_37867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37867__$1,(6),inst_37816);
} else {
if((state_val_37868 === (23))){
var inst_37849 = (state_37867[(9)]);
var inst_37819 = (state_37867[(10)]);
var inst_37820 = (state_37867[(11)]);
var inst_37836 = (state_37867[(12)]);
var inst_37821 = (state_37867[(13)]);
var inst_37852 = (function (){var base_node = inst_37819;
var first_flake = inst_37820;
var node_t = inst_37821;
var source = inst_37836;
var coll = inst_37849;
return (function (f){
return f.op === false;
});
})();
var state_37867__$1 = state_37867;
var statearr_37888_37930 = state_37867__$1;
(statearr_37888_37930[(2)] = inst_37852);

(statearr_37888_37930[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (19))){
var inst_37839 = (state_37867[(14)]);
var inst_37842 = (state_37867[(2)]);
var inst_37843 = fluree.db.util.async.throw_err(inst_37842);
var inst_37844 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_37839,inst_37843);
var state_37867__$1 = state_37867;
var statearr_37889_37931 = state_37867__$1;
(statearr_37889_37931[(2)] = inst_37844);

(statearr_37889_37931[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (11))){
var inst_37821 = (state_37867[(13)]);
var inst_37828 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37821,t);
var state_37867__$1 = state_37867;
if(inst_37828){
var statearr_37891_37932 = state_37867__$1;
(statearr_37891_37932[(1)] = (13));

} else {
var statearr_37892_37933 = state_37867__$1;
(statearr_37892_37933[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (9))){
var inst_37836 = (state_37867[(12)]);
var inst_37836__$1 = (state_37867[(2)]);
var state_37867__$1 = (function (){var statearr_37893 = state_37867;
(statearr_37893[(12)] = inst_37836__$1);

return statearr_37893;
})();
var G__37894_37934 = inst_37836__$1;
var G__37894_37935__$1 = (((G__37894_37934 instanceof cljs.core.Keyword))?G__37894_37934.fqn:null);
switch (G__37894_37935__$1) {
case "novelty":
var statearr_37895_37937 = state_37867__$1;
(statearr_37895_37937[(1)] = (17));


break;
case "history":
var statearr_37896_37938 = state_37867__$1;
(statearr_37896_37938[(1)] = (18));


break;
case "none":
var statearr_37897_37939 = state_37867__$1;
(statearr_37897_37939[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37894_37935__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (5))){
var _ = (function (){var statearr_37898 = state_37867;
(statearr_37898[(4)] = cljs.core.rest((state_37867[(4)])));

return statearr_37898;
})();
var state_37867__$1 = state_37867;
var ex37890 = (state_37867__$1[(2)]);
var statearr_37899_37940 = state_37867__$1;
(statearr_37899_37940[(5)] = ex37890);


var statearr_37900_37941 = state_37867__$1;
(statearr_37900_37941[(1)] = (4));

(statearr_37900_37941[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (14))){
var state_37867__$1 = state_37867;
var statearr_37901_37942 = state_37867__$1;
(statearr_37901_37942[(2)] = null);

(statearr_37901_37942[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (16))){
var inst_37836 = (state_37867[(12)]);
var inst_37849 = (state_37867[(2)]);
var state_37867__$1 = (function (){var statearr_37902 = state_37867;
(statearr_37902[(9)] = inst_37849);

return statearr_37902;
})();
var G__37903_37943 = inst_37836;
var G__37903_37944__$1 = (((G__37903_37943 instanceof cljs.core.Keyword))?G__37903_37943.fqn:null);
switch (G__37903_37944__$1) {
case "novelty":
var statearr_37904_37946 = state_37867__$1;
(statearr_37904_37946[(1)] = (22));


break;
case "history":
var statearr_37905_37947 = state_37867__$1;
(statearr_37905_37947[(1)] = (23));


break;
case "none":
var statearr_37906_37948 = state_37867__$1;
(statearr_37906_37948[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37903_37944__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (10))){
var state_37867__$1 = state_37867;
var statearr_37907_37949 = state_37867__$1;
(statearr_37907_37949[(2)] = cljs.core.cst$kw$history);

(statearr_37907_37949[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (18))){
var inst_37819 = (state_37867[(10)]);
var inst_37820 = (state_37867[(11)]);
var inst_37836 = (state_37867[(12)]);
var inst_37821 = (state_37867[(13)]);
var inst_37839 = (function (){var base_node = inst_37819;
var first_flake = inst_37820;
var node_t = inst_37821;
var source = inst_37836;
return (function (p1__37806_SHARP_){
return (p1__37806_SHARP_.t <= t);
});
})();
var inst_37840 = fluree.db.dbproto._resolve_history(node);
var state_37867__$1 = (function (){var statearr_37908 = state_37867;
(statearr_37908[(14)] = inst_37839);

return statearr_37908;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37867__$1,(19),inst_37840);
} else {
if((state_val_37868 === (8))){
var inst_37821 = (state_37867[(13)]);
var inst_37825 = (inst_37821 < t);
var state_37867__$1 = state_37867;
if(cljs.core.truth_(inst_37825)){
var statearr_37909_37950 = state_37867__$1;
(statearr_37909_37950[(1)] = (10));

} else {
var statearr_37910_37951 = state_37867__$1;
(statearr_37910_37951[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0 = (function (){
var statearr_37911 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37911[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__);

(statearr_37911[(1)] = (1));

return statearr_37911;
});
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1 = (function (state_37867){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37867);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37912){var ex__13886__auto__ = e37912;
var statearr_37913_37952 = state_37867;
(statearr_37913_37952[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37867[(4)]))){
var statearr_37914_37953 = state_37867;
(statearr_37914_37953[(1)] = cljs.core.first((state_37867[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37954 = state_37867;
state_37867 = G__37954;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__ = function(state_37867){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1.call(this,state_37867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37915 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37915[(6)] = c__13957__auto___37916);

return statearr_37915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38011){
var state_val_38012 = (state_38011[(1)]);
if((state_val_38012 === (7))){
var state_38011__$1 = state_38011;
var statearr_38013_38049 = state_38011__$1;
(statearr_38013_38049[(2)] = null);

(statearr_38013_38049[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (1))){
var state_38011__$1 = state_38011;
var statearr_38014_38050 = state_38011__$1;
(statearr_38014_38050[(2)] = null);

(statearr_38014_38050[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (4))){
var inst_37957 = (state_38011[(2)]);
var inst_37958 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37957], 0));
var inst_37959 = (function(){throw inst_37957})();
var state_38011__$1 = (function (){var statearr_38015 = state_38011;
(statearr_38015[(7)] = inst_37958);

return statearr_38015;
})();
var statearr_38016_38051 = state_38011__$1;
(statearr_38016_38051[(2)] = inst_37959);

(statearr_38016_38051[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (15))){
var inst_37987 = (state_38011[(2)]);
var state_38011__$1 = state_38011;
var statearr_38017_38052 = state_38011__$1;
(statearr_38017_38052[(2)] = inst_37987);

(statearr_38017_38052[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (13))){
var inst_37965 = (state_38011[(8)]);
var inst_37981 = (state_38011[(9)]);
var inst_37983 = (function (){var node_t = inst_37965;
var G__37970 = inst_37981;
return (function (p1__37956_SHARP_){
return (p1__37956_SHARP_.t <= from_t);
});
})();
var inst_37984 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_37983,inst_37981);
var state_38011__$1 = state_38011;
var statearr_38018_38053 = state_38011__$1;
(statearr_38018_38053[(2)] = inst_37984);

(statearr_38018_38053[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (6))){
var inst_37971 = fluree.db.dbproto._resolve_history(node);
var state_38011__$1 = state_38011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38011__$1,(9),inst_37971);
} else {
if((state_val_38012 === (17))){
var inst_37996 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_37997 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37996)].join('');
var inst_37998 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37999 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_38000 = cljs.core.PersistentHashMap.fromArrays(inst_37998,inst_37999);
var inst_38001 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37997,inst_38000);
var inst_38002 = (function(){throw inst_38001})();
var state_38011__$1 = state_38011;
var statearr_38019_38054 = state_38011__$1;
(statearr_38019_38054[(2)] = inst_38002);

(statearr_38019_38054[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (3))){
var inst_38009 = (state_38011[(2)]);
var state_38011__$1 = state_38011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38011__$1,inst_38009);
} else {
if((state_val_38012 === (12))){
var inst_37981 = (state_38011[(2)]);
var state_38011__$1 = (function (){var statearr_38020 = state_38011;
(statearr_38020[(9)] = inst_37981);

return statearr_38020;
})();
if(cljs.core.truth_(from_t)){
var statearr_38021_38055 = state_38011__$1;
(statearr_38021_38055[(1)] = (13));

} else {
var statearr_38022_38056 = state_38011__$1;
(statearr_38022_38056[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (2))){
var inst_37965 = (state_38011[(8)]);
var _ = (function (){var statearr_38023 = state_38011;
(statearr_38023[(4)] = cljs.core.cons((5),(state_38011[(4)])));

return statearr_38023;
})();
var inst_37965__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_37966 = (from_t == null);
var inst_37967 = (inst_37965__$1 <= from_t);
var inst_37968 = ((inst_37966) || (inst_37967));
var state_38011__$1 = (function (){var statearr_38024 = state_38011;
(statearr_38024[(8)] = inst_37965__$1);

return statearr_38024;
})();
if(cljs.core.truth_(inst_37968)){
var statearr_38025_38057 = state_38011__$1;
(statearr_38025_38057[(1)] = (6));

} else {
var statearr_38026_38058 = state_38011__$1;
(statearr_38026_38058[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (11))){
var inst_37974 = (state_38011[(10)]);
var state_38011__$1 = state_38011;
var statearr_38028_38059 = state_38011__$1;
(statearr_38028_38059[(2)] = inst_37974);

(statearr_38028_38059[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (9))){
var inst_37965 = (state_38011[(8)]);
var inst_37973 = (state_38011[(2)]);
var inst_37974 = fluree.db.util.async.throw_err(inst_37973);
var inst_37975 = (to_t > inst_37965);
var state_38011__$1 = (function (){var statearr_38029 = state_38011;
(statearr_38029[(10)] = inst_37974);

return statearr_38029;
})();
if(cljs.core.truth_(inst_37975)){
var statearr_38030_38060 = state_38011__$1;
(statearr_38030_38060[(1)] = (10));

} else {
var statearr_38031_38061 = state_38011__$1;
(statearr_38031_38061[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (5))){
var _ = (function (){var statearr_38032 = state_38011;
(statearr_38032[(4)] = cljs.core.rest((state_38011[(4)])));

return statearr_38032;
})();
var state_38011__$1 = state_38011;
var ex38027 = (state_38011__$1[(2)]);
var statearr_38033_38062 = state_38011__$1;
(statearr_38033_38062[(5)] = ex38027);


var statearr_38034_38063 = state_38011__$1;
(statearr_38034_38063[(1)] = (4));

(statearr_38034_38063[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (14))){
var inst_37981 = (state_38011[(9)]);
var state_38011__$1 = state_38011;
var statearr_38035_38064 = state_38011__$1;
(statearr_38035_38064[(2)] = inst_37981);

(statearr_38035_38064[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (16))){
var state_38011__$1 = state_38011;
var statearr_38036_38065 = state_38011__$1;
(statearr_38036_38065[(2)] = null);

(statearr_38036_38065[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (10))){
var inst_37965 = (state_38011[(8)]);
var inst_37974 = (state_38011[(10)]);
var inst_37977 = (function (){var node_t = inst_37965;
var G__37970 = inst_37974;
return (function (p1__37955_SHARP_){
return (p1__37955_SHARP_.t < to_t);
});
})();
var inst_37978 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_37977,inst_37974);
var state_38011__$1 = state_38011;
var statearr_38037_38066 = state_38011__$1;
(statearr_38037_38066[(2)] = inst_37978);

(statearr_38037_38066[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (18))){
var inst_37992 = (state_38011[(11)]);
var inst_37991 = (state_38011[(12)]);
var inst_37990 = (state_38011[(13)]);
var inst_38004 = (state_38011[(2)]);
var inst_38005 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_37991,inst_37992,leftmost_QMARK_,to_t);
var inst_38006 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38005,inst_37990);
var _ = (function (){var statearr_38038 = state_38011;
(statearr_38038[(4)] = cljs.core.rest((state_38011[(4)])));

return statearr_38038;
})();
var state_38011__$1 = (function (){var statearr_38039 = state_38011;
(statearr_38039[(14)] = inst_38004);

return statearr_38039;
})();
var statearr_38040_38067 = state_38011__$1;
(statearr_38040_38067[(2)] = inst_38006);

(statearr_38040_38067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38012 === (8))){
var inst_37990 = (state_38011[(2)]);
var inst_37991 = fluree.db.dbproto._first_flake(node);
var inst_37992 = fluree.db.dbproto._rhs(node);
var inst_37993 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_38011__$1 = (function (){var statearr_38041 = state_38011;
(statearr_38041[(11)] = inst_37992);

(statearr_38041[(12)] = inst_37991);

(statearr_38041[(13)] = inst_37990);

return statearr_38041;
})();
if(cljs.core.truth_(inst_37993)){
var statearr_38042_38068 = state_38011__$1;
(statearr_38042_38068[(1)] = (16));

} else {
var statearr_38043_38069 = state_38011__$1;
(statearr_38043_38069[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0 = (function (){
var statearr_38044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38044[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__);

(statearr_38044[(1)] = (1));

return statearr_38044;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1 = (function (state_38011){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38011);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38045){var ex__13886__auto__ = e38045;
var statearr_38046_38070 = state_38011;
(statearr_38046_38070[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38011[(4)]))){
var statearr_38047_38071 = state_38011;
(statearr_38047_38071[(1)] = cljs.core.first((state_38011[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38072 = state_38011;
state_38011 = G__38072;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__ = function(state_38011){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1.call(this,state_38011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38048 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38048[(6)] = c__13957__auto__);

return statearr_38048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4160__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__38073_38083 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__38074_38084 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38073_38083,G__38074_38084) : object_cache.call(null,G__38073_38083,G__38074_38084));

var G__38075 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__38076 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__38077 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__38078 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38077,G__38078) : object_cache.call(null,G__38077,G__38078));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38075,G__38076) : object_cache.call(null,G__38075,G__38076));
} else {
var G__38079 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__38080 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__38081 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__38082 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38081,G__38082) : object_cache.call(null,G__38081,G__38082));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38079,G__38080) : object_cache.call(null,G__38079,G__38080));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38105){
var state_val_38106 = (state_38105[(1)]);
if((state_val_38106 === (7))){
var state_38105__$1 = state_38105;
var statearr_38107_38127 = state_38105__$1;
(statearr_38107_38127[(2)] = null);

(statearr_38107_38127[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (1))){
var state_38105__$1 = state_38105;
var statearr_38108_38128 = state_38105__$1;
(statearr_38108_38128[(2)] = null);

(statearr_38108_38128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (4))){
var inst_38085 = (state_38105[(2)]);
var state_38105__$1 = state_38105;
var statearr_38109_38129 = state_38105__$1;
(statearr_38109_38129[(2)] = inst_38085);

(statearr_38109_38129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (6))){
var inst_38091 = (state_38105[(7)]);
var inst_38093 = fluree.db.storage.core.serde(conn);
var state_38105__$1 = (function (){var statearr_38110 = state_38105;
(statearr_38110[(8)] = inst_38093);

return statearr_38110;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38105__$1,(9),inst_38091);
} else {
if((state_val_38106 === (3))){
var inst_38103 = (state_38105[(2)]);
var state_38105__$1 = state_38105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38105__$1,inst_38103);
} else {
if((state_val_38106 === (2))){
var inst_38091 = (state_38105[(7)]);
var _ = (function (){var statearr_38112 = state_38105;
(statearr_38112[(4)] = cljs.core.cons((5),(state_38105[(4)])));

return statearr_38112;
})();
var inst_38091__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_38105__$1 = (function (){var statearr_38113 = state_38105;
(statearr_38113[(7)] = inst_38091__$1);

return statearr_38113;
})();
if(cljs.core.truth_(inst_38091__$1)){
var statearr_38114_38130 = state_38105__$1;
(statearr_38114_38130[(1)] = (6));

} else {
var statearr_38115_38131 = state_38105__$1;
(statearr_38115_38131[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (9))){
var inst_38093 = (state_38105[(8)]);
var inst_38095 = (state_38105[(2)]);
var inst_38096 = fluree.db.util.async.throw_err(inst_38095);
var inst_38097 = fluree.db.serde.protocol._deserialize_branch(inst_38093,inst_38096);
var state_38105__$1 = state_38105;
var statearr_38116_38132 = state_38105__$1;
(statearr_38116_38132[(2)] = inst_38097);

(statearr_38116_38132[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (5))){
var _ = (function (){var statearr_38117 = state_38105;
(statearr_38117[(4)] = cljs.core.rest((state_38105[(4)])));

return statearr_38117;
})();
var state_38105__$1 = state_38105;
var ex38111 = (state_38105__$1[(2)]);
var statearr_38118_38133 = state_38105__$1;
(statearr_38118_38133[(5)] = ex38111);


if((ex38111 instanceof Error)){
var statearr_38119_38134 = state_38105__$1;
(statearr_38119_38134[(1)] = (4));

(statearr_38119_38134[(5)] = null);

} else {
throw ex38111;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38106 === (8))){
var inst_38100 = (state_38105[(2)]);
var _ = (function (){var statearr_38120 = state_38105;
(statearr_38120[(4)] = cljs.core.rest((state_38105[(4)])));

return statearr_38120;
})();
var state_38105__$1 = state_38105;
var statearr_38121_38135 = state_38105__$1;
(statearr_38121_38135[(2)] = inst_38100);

(statearr_38121_38135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0 = (function (){
var statearr_38122 = [null,null,null,null,null,null,null,null,null];
(statearr_38122[(0)] = fluree$db$storage$core$read_branch_$_state_machine__13883__auto__);

(statearr_38122[(1)] = (1));

return statearr_38122;
});
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1 = (function (state_38105){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38105);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38123){var ex__13886__auto__ = e38123;
var statearr_38124_38136 = state_38105;
(statearr_38124_38136[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38105[(4)]))){
var statearr_38125_38137 = state_38105;
(statearr_38125_38137[(1)] = cljs.core.first((state_38105[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38138 = state_38105;
state_38105 = G__38138;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__ = function(state_38105){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1.call(this,state_38105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38126 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38126[(6)] = c__13957__auto__);

return statearr_38126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___38217 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38189){
var state_val_38190 = (state_38189[(1)]);
if((state_val_38190 === (7))){
var inst_38156 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_38157 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38158 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_38159 = cljs.core.PersistentHashMap.fromArrays(inst_38157,inst_38158);
var inst_38160 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38156,inst_38159);
var inst_38161 = (function(){throw inst_38160})();
var state_38189__$1 = state_38189;
var statearr_38191_38218 = state_38189__$1;
(statearr_38191_38218[(2)] = inst_38161);

(statearr_38191_38218[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (1))){
var state_38189__$1 = state_38189;
var statearr_38192_38219 = state_38189__$1;
(statearr_38192_38219[(2)] = null);

(statearr_38192_38219[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (4))){
var inst_38139 = (state_38189[(2)]);
var inst_38140 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_38141 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_38139);
var inst_38142 = cljs.core.async.close_BANG_(return_ch);
var state_38189__$1 = (function (){var statearr_38193 = state_38189;
(statearr_38193[(7)] = inst_38141);

(statearr_38193[(8)] = inst_38140);

return statearr_38193;
})();
var statearr_38194_38220 = state_38189__$1;
(statearr_38194_38220[(2)] = inst_38142);

(statearr_38194_38220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (6))){
var inst_38153 = (state_38189[(9)]);
var inst_38152 = (state_38189[(2)]);
var inst_38153__$1 = fluree.db.util.async.throw_err(inst_38152);
var inst_38154 = (inst_38153__$1 == null);
var state_38189__$1 = (function (){var statearr_38195 = state_38189;
(statearr_38195[(9)] = inst_38153__$1);

return statearr_38195;
})();
if(cljs.core.truth_(inst_38154)){
var statearr_38196_38221 = state_38189__$1;
(statearr_38196_38221[(1)] = (7));

} else {
var statearr_38197_38222 = state_38189__$1;
(statearr_38197_38222[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (3))){
var inst_38187 = (state_38189[(2)]);
var state_38189__$1 = state_38189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38189__$1,inst_38187);
} else {
if((state_val_38190 === (12))){
var inst_38153 = (state_38189[(9)]);
var inst_38170 = (state_38189[(2)]);
var inst_38171 = cljs.core.__destructure_map(inst_38153);
var inst_38172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38171,cljs.core.cst$kw$children);
var inst_38173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38171,cljs.core.cst$kw$rhs);
var inst_38174 = config;
var inst_38175 = cljs.core.__destructure_map(inst_38174);
var inst_38176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38175,cljs.core.cst$kw$comparator);
var inst_38178 = (function (){var data = inst_38153;
var _ = inst_38170;
var map__38148 = inst_38171;
var children = inst_38172;
var rhs = inst_38173;
var map__38149 = inst_38175;
var comparator = inst_38176;
return (function (idx,p__38177){
var map__38198 = p__38177;
var map__38198__$1 = cljs.core.__destructure_map(map__38198);
var child = map__38198__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38198__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38198__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38198__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38198__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38198__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4149__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return (idx === (0));
} else {
return and__4149__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_38179 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_38178,inst_38172);
var inst_38180 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_38179);
var inst_38181 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_38180,inst_38179);
var inst_38182 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_38176,inst_38181);
var inst_38183 = fluree.db.index.__GT_IndexNode(block,t,inst_38173,inst_38182,config,leftmost_QMARK_);
var inst_38184 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_38183);
var _ = (function (){var statearr_38199 = state_38189;
(statearr_38199[(4)] = cljs.core.rest((state_38189[(4)])));

return statearr_38199;
})();
var state_38189__$1 = state_38189;
var statearr_38200_38223 = state_38189__$1;
(statearr_38200_38223[(2)] = inst_38184);

(statearr_38200_38223[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (2))){
var _ = (function (){var statearr_38201 = state_38189;
(statearr_38201[(4)] = cljs.core.cons((5),(state_38189[(4)])));

return statearr_38201;
})();
var inst_38150 = fluree.db.storage.core.read_branch(conn,key);
var state_38189__$1 = state_38189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38189__$1,(6),inst_38150);
} else {
if((state_val_38190 === (11))){
var state_38189__$1 = state_38189;
var statearr_38203_38224 = state_38189__$1;
(statearr_38203_38224[(2)] = null);

(statearr_38203_38224[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (9))){
var inst_38153 = (state_38189[(9)]);
var inst_38164 = (state_38189[(2)]);
var inst_38165 = fluree.db.util.core.exception_QMARK_(inst_38153);
var state_38189__$1 = (function (){var statearr_38204 = state_38189;
(statearr_38204[(10)] = inst_38164);

return statearr_38204;
})();
if(inst_38165){
var statearr_38205_38225 = state_38189__$1;
(statearr_38205_38225[(1)] = (10));

} else {
var statearr_38206_38226 = state_38189__$1;
(statearr_38206_38226[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (5))){
var _ = (function (){var statearr_38207 = state_38189;
(statearr_38207[(4)] = cljs.core.rest((state_38189[(4)])));

return statearr_38207;
})();
var state_38189__$1 = state_38189;
var ex38202 = (state_38189__$1[(2)]);
var statearr_38208_38227 = state_38189__$1;
(statearr_38208_38227[(5)] = ex38202);


var statearr_38209_38228 = state_38189__$1;
(statearr_38209_38228[(1)] = (4));

(statearr_38209_38228[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (10))){
var inst_38153 = (state_38189[(9)]);
var inst_38167 = (function(){throw inst_38153})();
var state_38189__$1 = state_38189;
var statearr_38210_38229 = state_38189__$1;
(statearr_38210_38229[(2)] = inst_38167);

(statearr_38210_38229[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38190 === (8))){
var state_38189__$1 = state_38189;
var statearr_38211_38230 = state_38189__$1;
(statearr_38211_38230[(2)] = null);

(statearr_38211_38230[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0 = (function (){
var statearr_38212 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38212[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__);

(statearr_38212[(1)] = (1));

return statearr_38212;
});
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1 = (function (state_38189){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38189);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38213){var ex__13886__auto__ = e38213;
var statearr_38214_38231 = state_38189;
(statearr_38214_38231[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38189[(4)]))){
var statearr_38215_38232 = state_38189;
(statearr_38215_38232[(1)] = cljs.core.first((state_38189[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38233 = state_38189;
state_38189 = G__38233;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__ = function(state_38189){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1.call(this,state_38189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38216 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38216[(6)] = c__13957__auto___38217);

return statearr_38216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38254){
var state_val_38255 = (state_38254[(1)]);
if((state_val_38255 === (7))){
var state_38254__$1 = state_38254;
var statearr_38256_38276 = state_38254__$1;
(statearr_38256_38276[(2)] = null);

(statearr_38256_38276[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (1))){
var state_38254__$1 = state_38254;
var statearr_38257_38277 = state_38254__$1;
(statearr_38257_38277[(2)] = null);

(statearr_38257_38277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (4))){
var inst_38234 = (state_38254[(2)]);
var state_38254__$1 = state_38254;
var statearr_38258_38278 = state_38254__$1;
(statearr_38258_38278[(2)] = inst_38234);

(statearr_38258_38278[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (6))){
var inst_38240 = (state_38254[(7)]);
var inst_38242 = fluree.db.storage.core.serde(conn);
var state_38254__$1 = (function (){var statearr_38259 = state_38254;
(statearr_38259[(8)] = inst_38242);

return statearr_38259;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38254__$1,(9),inst_38240);
} else {
if((state_val_38255 === (3))){
var inst_38252 = (state_38254[(2)]);
var state_38254__$1 = state_38254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38254__$1,inst_38252);
} else {
if((state_val_38255 === (2))){
var inst_38240 = (state_38254[(7)]);
var _ = (function (){var statearr_38261 = state_38254;
(statearr_38261[(4)] = cljs.core.cons((5),(state_38254[(4)])));

return statearr_38261;
})();
var inst_38240__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_38254__$1 = (function (){var statearr_38262 = state_38254;
(statearr_38262[(7)] = inst_38240__$1);

return statearr_38262;
})();
if(cljs.core.truth_(inst_38240__$1)){
var statearr_38263_38279 = state_38254__$1;
(statearr_38263_38279[(1)] = (6));

} else {
var statearr_38264_38280 = state_38254__$1;
(statearr_38264_38280[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (9))){
var inst_38242 = (state_38254[(8)]);
var inst_38244 = (state_38254[(2)]);
var inst_38245 = fluree.db.util.async.throw_err(inst_38244);
var inst_38246 = fluree.db.serde.protocol._deserialize_leaf(inst_38242,inst_38245);
var state_38254__$1 = state_38254;
var statearr_38265_38281 = state_38254__$1;
(statearr_38265_38281[(2)] = inst_38246);

(statearr_38265_38281[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (5))){
var _ = (function (){var statearr_38266 = state_38254;
(statearr_38266[(4)] = cljs.core.rest((state_38254[(4)])));

return statearr_38266;
})();
var state_38254__$1 = state_38254;
var ex38260 = (state_38254__$1[(2)]);
var statearr_38267_38282 = state_38254__$1;
(statearr_38267_38282[(5)] = ex38260);


if((ex38260 instanceof Error)){
var statearr_38268_38283 = state_38254__$1;
(statearr_38268_38283[(1)] = (4));

(statearr_38268_38283[(5)] = null);

} else {
throw ex38260;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38255 === (8))){
var inst_38249 = (state_38254[(2)]);
var _ = (function (){var statearr_38269 = state_38254;
(statearr_38269[(4)] = cljs.core.rest((state_38254[(4)])));

return statearr_38269;
})();
var state_38254__$1 = state_38254;
var statearr_38270_38284 = state_38254__$1;
(statearr_38270_38284[(2)] = inst_38249);

(statearr_38270_38284[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_38271 = [null,null,null,null,null,null,null,null,null];
(statearr_38271[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__);

(statearr_38271[(1)] = (1));

return statearr_38271;
});
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1 = (function (state_38254){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38254);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38272){var ex__13886__auto__ = e38272;
var statearr_38273_38285 = state_38254;
(statearr_38273_38285[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38254[(4)]))){
var statearr_38274_38286 = state_38254;
(statearr_38274_38286[(1)] = cljs.core.first((state_38254[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38287 = state_38254;
state_38254 = G__38287;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__ = function(state_38254){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1.call(this,state_38254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38275 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38275[(6)] = c__13957__auto__);

return statearr_38275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___38360 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38332){
var state_val_38333 = (state_38332[(1)]);
if((state_val_38333 === (7))){
var inst_38304 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_38305 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38306 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_38307 = cljs.core.PersistentHashMap.fromArrays(inst_38305,inst_38306);
var inst_38308 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38304,inst_38307);
var inst_38309 = (function(){throw inst_38308})();
var state_38332__$1 = state_38332;
var statearr_38334_38361 = state_38332__$1;
(statearr_38334_38361[(2)] = inst_38309);

(statearr_38334_38361[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (1))){
var state_38332__$1 = state_38332;
var statearr_38335_38362 = state_38332__$1;
(statearr_38335_38362[(2)] = null);

(statearr_38335_38362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (4))){
var inst_38288 = (state_38332[(2)]);
var inst_38289 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_38290 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_38288);
var inst_38291 = cljs.core.async.close_BANG_(return_ch);
var state_38332__$1 = (function (){var statearr_38336 = state_38332;
(statearr_38336[(7)] = inst_38289);

(statearr_38336[(8)] = inst_38290);

return statearr_38336;
})();
var statearr_38337_38363 = state_38332__$1;
(statearr_38337_38363[(2)] = inst_38291);

(statearr_38337_38363[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (6))){
var inst_38301 = (state_38332[(9)]);
var inst_38301__$1 = (state_38332[(2)]);
var inst_38302 = (inst_38301__$1 == null);
var state_38332__$1 = (function (){var statearr_38338 = state_38332;
(statearr_38338[(9)] = inst_38301__$1);

return statearr_38338;
})();
if(cljs.core.truth_(inst_38302)){
var statearr_38339_38364 = state_38332__$1;
(statearr_38339_38364[(1)] = (7));

} else {
var statearr_38340_38365 = state_38332__$1;
(statearr_38340_38365[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (3))){
var inst_38330 = (state_38332[(2)]);
var state_38332__$1 = state_38332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38332__$1,inst_38330);
} else {
if((state_val_38333 === (12))){
var inst_38301 = (state_38332[(9)]);
var inst_38318 = (state_38332[(2)]);
var inst_38319 = cljs.core.__destructure_map(inst_38301);
var inst_38320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38319,cljs.core.cst$kw$flakes);
var inst_38321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38319,cljs.core.cst$kw$his);
var inst_38322 = config;
var inst_38323 = cljs.core.__destructure_map(inst_38322);
var inst_38324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38323,cljs.core.cst$kw$comparator);
var inst_38325 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_38324,inst_38320);
var inst_38326 = fluree.db.index.data_node(block,t,inst_38325,rhs,config);
var inst_38327 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_38326);
var _ = (function (){var statearr_38341 = state_38332;
(statearr_38341[(4)] = cljs.core.rest((state_38332[(4)])));

return statearr_38341;
})();
var state_38332__$1 = (function (){var statearr_38342 = state_38332;
(statearr_38342[(10)] = inst_38318);

(statearr_38342[(11)] = inst_38321);

return statearr_38342;
})();
var statearr_38343_38366 = state_38332__$1;
(statearr_38343_38366[(2)] = inst_38327);

(statearr_38343_38366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (2))){
var _ = (function (){var statearr_38344 = state_38332;
(statearr_38344[(4)] = cljs.core.cons((5),(state_38332[(4)])));

return statearr_38344;
})();
var inst_38299 = fluree.db.storage.core.read_leaf(conn,key);
var state_38332__$1 = state_38332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38332__$1,(6),inst_38299);
} else {
if((state_val_38333 === (11))){
var state_38332__$1 = state_38332;
var statearr_38346_38367 = state_38332__$1;
(statearr_38346_38367[(2)] = null);

(statearr_38346_38367[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (9))){
var inst_38301 = (state_38332[(9)]);
var inst_38312 = (state_38332[(2)]);
var inst_38313 = fluree.db.util.core.exception_QMARK_(inst_38301);
var state_38332__$1 = (function (){var statearr_38347 = state_38332;
(statearr_38347[(12)] = inst_38312);

return statearr_38347;
})();
if(inst_38313){
var statearr_38348_38368 = state_38332__$1;
(statearr_38348_38368[(1)] = (10));

} else {
var statearr_38349_38369 = state_38332__$1;
(statearr_38349_38369[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (5))){
var _ = (function (){var statearr_38350 = state_38332;
(statearr_38350[(4)] = cljs.core.rest((state_38332[(4)])));

return statearr_38350;
})();
var state_38332__$1 = state_38332;
var ex38345 = (state_38332__$1[(2)]);
var statearr_38351_38370 = state_38332__$1;
(statearr_38351_38370[(5)] = ex38345);


var statearr_38352_38371 = state_38332__$1;
(statearr_38352_38371[(1)] = (4));

(statearr_38352_38371[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (10))){
var inst_38301 = (state_38332[(9)]);
var inst_38315 = (function(){throw inst_38301})();
var state_38332__$1 = state_38332;
var statearr_38353_38372 = state_38332__$1;
(statearr_38353_38372[(2)] = inst_38315);

(statearr_38353_38372[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38333 === (8))){
var state_38332__$1 = state_38332;
var statearr_38354_38373 = state_38332__$1;
(statearr_38354_38373[(2)] = null);

(statearr_38354_38373[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_38355 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38355[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__);

(statearr_38355[(1)] = (1));

return statearr_38355;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1 = (function (state_38332){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38332);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38356){var ex__13886__auto__ = e38356;
var statearr_38357_38374 = state_38332;
(statearr_38357_38374[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38332[(4)]))){
var statearr_38358_38375 = state_38332;
(statearr_38358_38375[(1)] = cljs.core.first((state_38332[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38376 = state_38332;
state_38332 = G__38376;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__ = function(state_38332){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1.call(this,state_38332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38359 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38359[(6)] = c__13957__auto___38360);

return statearr_38359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k38378,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__38382 = k38378;
var G__38382__$1 = (((G__38382 instanceof cljs.core.Keyword))?G__38382.fqn:null);
switch (G__38382__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38378,else__4418__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__38383){
var vec__38384 = p__38383;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38384,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38384,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38377){
var self__ = this;
var G__38377__$1 = this;
return (new cljs.core.RecordIter((0),G__38377__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__38387 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__38388 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__38389 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__38390 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38389,G__38390) : object_cache.call(null,G__38389,G__38390));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__38391 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__38392 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38391,G__38392) : object_cache.call(null,G__38391,G__38392));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38387,G__38388) : object_cache.call(null,G__38387,G__38388));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__38393 = history_id;
var G__38394 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__38393,G__38394) : object_cache.call(null,G__38393,G__38394));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__38395 = (function (coll__4412__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__38395(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38379,other38380){
var self__ = this;
var this38379__$1 = this;
return (((!((other38380 == null)))) && ((this38379__$1.constructor === other38380.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.conn,other38380.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.config,other38380.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.network,other38380.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.dbid,other38380.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.id,other38380.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.leaf,other38380.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.first,other38380.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.rhs,other38380.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.size,other38380.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.block,other38380.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.t,other38380.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.tt_id,other38380.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.leftmost_QMARK_,other38380.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.tempid,other38380.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38379__$1.__extmap,other38380.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__38377){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__38396 = cljs.core.keyword_identical_QMARK_;
var expr__38397 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__38399 = cljs.core.cst$kw$conn;
var G__38400 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38399,G__38400) : pred__38396.call(null,G__38399,G__38400));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__38377,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38401 = cljs.core.cst$kw$config;
var G__38402 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38401,G__38402) : pred__38396.call(null,G__38401,G__38402));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__38377,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38403 = cljs.core.cst$kw$network;
var G__38404 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38403,G__38404) : pred__38396.call(null,G__38403,G__38404));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__38377,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38405 = cljs.core.cst$kw$dbid;
var G__38406 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38405,G__38406) : pred__38396.call(null,G__38405,G__38406));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__38377,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38407 = cljs.core.cst$kw$id;
var G__38408 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38407,G__38408) : pred__38396.call(null,G__38407,G__38408));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__38377,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38409 = cljs.core.cst$kw$leaf;
var G__38410 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38409,G__38410) : pred__38396.call(null,G__38409,G__38410));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__38377,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38411 = cljs.core.cst$kw$first;
var G__38412 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38411,G__38412) : pred__38396.call(null,G__38411,G__38412));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__38377,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38413 = cljs.core.cst$kw$rhs;
var G__38414 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38413,G__38414) : pred__38396.call(null,G__38413,G__38414));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__38377,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38415 = cljs.core.cst$kw$size;
var G__38416 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38415,G__38416) : pred__38396.call(null,G__38415,G__38416));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__38377,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38417 = cljs.core.cst$kw$block;
var G__38418 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38417,G__38418) : pred__38396.call(null,G__38417,G__38418));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__38377,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38419 = cljs.core.cst$kw$t;
var G__38420 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38419,G__38420) : pred__38396.call(null,G__38419,G__38420));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__38377,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38421 = cljs.core.cst$kw$tt_DASH_id;
var G__38422 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38421,G__38422) : pred__38396.call(null,G__38421,G__38422));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__38377,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38423 = cljs.core.cst$kw$leftmost_QMARK_;
var G__38424 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38423,G__38424) : pred__38396.call(null,G__38423,G__38424));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__38377,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38425 = cljs.core.cst$kw$tempid;
var G__38426 = expr__38397;
return (pred__38396.cljs$core$IFn$_invoke$arity$2 ? pred__38396.cljs$core$IFn$_invoke$arity$2(G__38425,G__38426) : pred__38396.call(null,G__38425,G__38426));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__38377,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__38377),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__38377){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__38377,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__38381){
var extmap__4454__auto__ = (function (){var G__38427 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38381,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__38381)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38427);
} else {
return G__38427;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__38381),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__38381),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__38429 = blank_db;
var map__38429__$1 = cljs.core.__destructure_map(map__38429);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$index_DASH_configs);
var map__38430 = root_data;
var map__38430__$1 = cljs.core.__destructure_map(map__38430);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38430__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38430__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38430__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38430__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38452){
var state_val_38453 = (state_38452[(1)]);
if((state_val_38453 === (7))){
var state_38452__$1 = state_38452;
var statearr_38454_38474 = state_38452__$1;
(statearr_38454_38474[(2)] = null);

(statearr_38454_38474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (1))){
var state_38452__$1 = state_38452;
var statearr_38455_38475 = state_38452__$1;
(statearr_38455_38475[(2)] = null);

(statearr_38455_38475[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (4))){
var inst_38431 = (state_38452[(2)]);
var state_38452__$1 = state_38452;
var statearr_38456_38476 = state_38452__$1;
(statearr_38456_38476[(2)] = inst_38431);

(statearr_38456_38476[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (6))){
var inst_38438 = (state_38452[(7)]);
var inst_38440 = fluree.db.storage.core.serde(conn);
var state_38452__$1 = (function (){var statearr_38457 = state_38452;
(statearr_38457[(8)] = inst_38440);

return statearr_38457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38452__$1,(9),inst_38438);
} else {
if((state_val_38453 === (3))){
var inst_38450 = (state_38452[(2)]);
var state_38452__$1 = state_38452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38452__$1,inst_38450);
} else {
if((state_val_38453 === (2))){
var inst_38438 = (state_38452[(7)]);
var _ = (function (){var statearr_38459 = state_38452;
(statearr_38459[(4)] = cljs.core.cons((5),(state_38452[(4)])));

return statearr_38459;
})();
var inst_38437 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_38438__$1 = fluree.db.storage.core.storage_read(conn,inst_38437);
var state_38452__$1 = (function (){var statearr_38460 = state_38452;
(statearr_38460[(7)] = inst_38438__$1);

return statearr_38460;
})();
if(cljs.core.truth_(inst_38438__$1)){
var statearr_38461_38477 = state_38452__$1;
(statearr_38461_38477[(1)] = (6));

} else {
var statearr_38462_38478 = state_38452__$1;
(statearr_38462_38478[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (9))){
var inst_38440 = (state_38452[(8)]);
var inst_38442 = (state_38452[(2)]);
var inst_38443 = fluree.db.util.async.throw_err(inst_38442);
var inst_38444 = fluree.db.serde.protocol._deserialize_garbage(inst_38440,inst_38443);
var state_38452__$1 = state_38452;
var statearr_38463_38479 = state_38452__$1;
(statearr_38463_38479[(2)] = inst_38444);

(statearr_38463_38479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (5))){
var _ = (function (){var statearr_38464 = state_38452;
(statearr_38464[(4)] = cljs.core.rest((state_38452[(4)])));

return statearr_38464;
})();
var state_38452__$1 = state_38452;
var ex38458 = (state_38452__$1[(2)]);
var statearr_38465_38480 = state_38452__$1;
(statearr_38465_38480[(5)] = ex38458);


if((ex38458 instanceof Error)){
var statearr_38466_38481 = state_38452__$1;
(statearr_38466_38481[(1)] = (4));

(statearr_38466_38481[(5)] = null);

} else {
throw ex38458;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (8))){
var inst_38447 = (state_38452[(2)]);
var _ = (function (){var statearr_38467 = state_38452;
(statearr_38467[(4)] = cljs.core.rest((state_38452[(4)])));

return statearr_38467;
})();
var state_38452__$1 = state_38452;
var statearr_38468_38482 = state_38452__$1;
(statearr_38468_38482[(2)] = inst_38447);

(statearr_38468_38482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0 = (function (){
var statearr_38469 = [null,null,null,null,null,null,null,null,null];
(statearr_38469[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__);

(statearr_38469[(1)] = (1));

return statearr_38469;
});
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1 = (function (state_38452){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38452);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38470){var ex__13886__auto__ = e38470;
var statearr_38471_38483 = state_38452;
(statearr_38471_38483[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38452[(4)]))){
var statearr_38472_38484 = state_38452;
(statearr_38472_38484[(1)] = cljs.core.first((state_38452[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38485 = state_38452;
state_38452 = G__38485;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__ = function(state_38452){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1.call(this,state_38452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38473 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38473[(6)] = c__13957__auto__);

return statearr_38473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38507){
var state_val_38508 = (state_38507[(1)]);
if((state_val_38508 === (7))){
var state_38507__$1 = state_38507;
var statearr_38509_38529 = state_38507__$1;
(statearr_38509_38529[(2)] = null);

(statearr_38509_38529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (1))){
var state_38507__$1 = state_38507;
var statearr_38510_38530 = state_38507__$1;
(statearr_38510_38530[(2)] = null);

(statearr_38510_38530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (4))){
var inst_38486 = (state_38507[(2)]);
var state_38507__$1 = state_38507;
var statearr_38511_38531 = state_38507__$1;
(statearr_38511_38531[(2)] = inst_38486);

(statearr_38511_38531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (6))){
var inst_38493 = (state_38507[(7)]);
var inst_38495 = fluree.db.storage.core.serde(conn);
var state_38507__$1 = (function (){var statearr_38512 = state_38507;
(statearr_38512[(8)] = inst_38495);

return statearr_38512;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38507__$1,(9),inst_38493);
} else {
if((state_val_38508 === (3))){
var inst_38505 = (state_38507[(2)]);
var state_38507__$1 = state_38507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38507__$1,inst_38505);
} else {
if((state_val_38508 === (2))){
var inst_38493 = (state_38507[(7)]);
var _ = (function (){var statearr_38514 = state_38507;
(statearr_38514[(4)] = cljs.core.cons((5),(state_38507[(4)])));

return statearr_38514;
})();
var inst_38492 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_38493__$1 = fluree.db.storage.core.storage_read(conn,inst_38492);
var state_38507__$1 = (function (){var statearr_38515 = state_38507;
(statearr_38515[(7)] = inst_38493__$1);

return statearr_38515;
})();
if(cljs.core.truth_(inst_38493__$1)){
var statearr_38516_38532 = state_38507__$1;
(statearr_38516_38532[(1)] = (6));

} else {
var statearr_38517_38533 = state_38507__$1;
(statearr_38517_38533[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (9))){
var inst_38495 = (state_38507[(8)]);
var inst_38497 = (state_38507[(2)]);
var inst_38498 = fluree.db.util.async.throw_err(inst_38497);
var inst_38499 = fluree.db.serde.protocol._deserialize_db_root(inst_38495,inst_38498);
var state_38507__$1 = state_38507;
var statearr_38518_38534 = state_38507__$1;
(statearr_38518_38534[(2)] = inst_38499);

(statearr_38518_38534[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (5))){
var _ = (function (){var statearr_38519 = state_38507;
(statearr_38519[(4)] = cljs.core.rest((state_38507[(4)])));

return statearr_38519;
})();
var state_38507__$1 = state_38507;
var ex38513 = (state_38507__$1[(2)]);
var statearr_38520_38535 = state_38507__$1;
(statearr_38520_38535[(5)] = ex38513);


if((ex38513 instanceof Error)){
var statearr_38521_38536 = state_38507__$1;
(statearr_38521_38536[(1)] = (4));

(statearr_38521_38536[(5)] = null);

} else {
throw ex38513;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38508 === (8))){
var inst_38502 = (state_38507[(2)]);
var _ = (function (){var statearr_38522 = state_38507;
(statearr_38522[(4)] = cljs.core.rest((state_38507[(4)])));

return statearr_38522;
})();
var state_38507__$1 = state_38507;
var statearr_38523_38537 = state_38507__$1;
(statearr_38523_38537[(2)] = inst_38502);

(statearr_38523_38537[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0 = (function (){
var statearr_38524 = [null,null,null,null,null,null,null,null,null];
(statearr_38524[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__);

(statearr_38524[(1)] = (1));

return statearr_38524;
});
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1 = (function (state_38507){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38507);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38525){var ex__13886__auto__ = e38525;
var statearr_38526_38538 = state_38507;
(statearr_38526_38538[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38507[(4)]))){
var statearr_38527_38539 = state_38507;
(statearr_38527_38539[(1)] = cljs.core.first((state_38507[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38540 = state_38507;
state_38507 = G__38540;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__ = function(state_38507){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1.call(this,state_38507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38528 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38528[(6)] = c__13957__auto__);

return statearr_38528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38576){
var state_val_38577 = (state_38576[(1)]);
if((state_val_38577 === (7))){
var inst_38550 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_38551 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38552 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_38553 = cljs.core.PersistentHashMap.fromArrays(inst_38551,inst_38552);
var inst_38554 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38550,inst_38553);
var inst_38555 = (function(){throw inst_38554})();
var state_38576__$1 = state_38576;
var statearr_38578_38600 = state_38576__$1;
(statearr_38578_38600[(2)] = inst_38555);

(statearr_38578_38600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (1))){
var state_38576__$1 = state_38576;
var statearr_38579_38601 = state_38576__$1;
(statearr_38579_38601[(2)] = null);

(statearr_38579_38601[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (4))){
var inst_38541 = (state_38576[(2)]);
var state_38576__$1 = state_38576;
var statearr_38580_38602 = state_38576__$1;
(statearr_38580_38602[(2)] = inst_38541);

(statearr_38580_38602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (6))){
var state_38576__$1 = state_38576;
var statearr_38581_38603 = state_38576__$1;
(statearr_38581_38603[(2)] = null);

(statearr_38581_38603[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (3))){
var inst_38574 = (state_38576[(2)]);
var state_38576__$1 = state_38576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38576__$1,inst_38574);
} else {
if((state_val_38577 === (2))){
var inst_38547 = (state_38576[(7)]);
var _ = (function (){var statearr_38582 = state_38576;
(statearr_38582[(4)] = cljs.core.cons((5),(state_38576[(4)])));

return statearr_38582;
})();
var inst_38547__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_38576__$1 = (function (){var statearr_38583 = state_38576;
(statearr_38583[(7)] = inst_38547__$1);

return statearr_38583;
})();
if(cljs.core.truth_(inst_38547__$1)){
var statearr_38584_38604 = state_38576__$1;
(statearr_38584_38604[(1)] = (6));

} else {
var statearr_38585_38605 = state_38576__$1;
(statearr_38585_38605[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (11))){
var inst_38566 = (state_38576[(8)]);
var inst_38569 = (state_38576[(2)]);
var inst_38570 = fluree.db.util.async.throw_err(inst_38569);
var inst_38571 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38566,cljs.core.cst$kw$settings,inst_38570);
var _ = (function (){var statearr_38587 = state_38576;
(statearr_38587[(4)] = cljs.core.rest((state_38576[(4)])));

return statearr_38587;
})();
var state_38576__$1 = state_38576;
var statearr_38588_38606 = state_38576__$1;
(statearr_38588_38606[(2)] = inst_38571);

(statearr_38588_38606[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (9))){
var inst_38561 = (state_38576[(9)]);
var inst_38559 = (state_38576[(2)]);
var inst_38560 = fluree.db.util.async.throw_err(inst_38559);
var inst_38561__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_38560);
var inst_38562 = fluree.db.query.schema.schema_map(inst_38561__$1);
var state_38576__$1 = (function (){var statearr_38589 = state_38576;
(statearr_38589[(9)] = inst_38561__$1);

return statearr_38589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38576__$1,(10),inst_38562);
} else {
if((state_val_38577 === (5))){
var _ = (function (){var statearr_38590 = state_38576;
(statearr_38590[(4)] = cljs.core.rest((state_38576[(4)])));

return statearr_38590;
})();
var state_38576__$1 = state_38576;
var ex38586 = (state_38576__$1[(2)]);
var statearr_38591_38607 = state_38576__$1;
(statearr_38591_38607[(5)] = ex38586);


if((ex38586 instanceof Error)){
var statearr_38592_38608 = state_38576__$1;
(statearr_38592_38608[(1)] = (4));

(statearr_38592_38608[(5)] = null);

} else {
throw ex38586;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38577 === (10))){
var inst_38561 = (state_38576[(9)]);
var inst_38566 = (state_38576[(8)]);
var inst_38564 = (state_38576[(2)]);
var inst_38565 = fluree.db.util.async.throw_err(inst_38564);
var inst_38566__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38561,cljs.core.cst$kw$schema,inst_38565);
var inst_38567 = fluree.db.query.schema.setting_map(inst_38566__$1);
var state_38576__$1 = (function (){var statearr_38593 = state_38576;
(statearr_38593[(8)] = inst_38566__$1);

return statearr_38593;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38576__$1,(11),inst_38567);
} else {
if((state_val_38577 === (8))){
var inst_38547 = (state_38576[(7)]);
var inst_38557 = (state_38576[(2)]);
var state_38576__$1 = (function (){var statearr_38594 = state_38576;
(statearr_38594[(10)] = inst_38557);

return statearr_38594;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38576__$1,(9),inst_38547);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0 = (function (){
var statearr_38595 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38595[(0)] = fluree$db$storage$core$reify_db_$_state_machine__13883__auto__);

(statearr_38595[(1)] = (1));

return statearr_38595;
});
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1 = (function (state_38576){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38576);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38596){var ex__13886__auto__ = e38596;
var statearr_38597_38609 = state_38576;
(statearr_38597_38609[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38576[(4)]))){
var statearr_38598_38610 = state_38576;
(statearr_38598_38610[(1)] = cljs.core.first((state_38576[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38611 = state_38576;
state_38576 = G__38611;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__ = function(state_38576){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1.call(this,state_38576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38599 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38599[(6)] = c__13957__auto__);

return statearr_38599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__38613 = arguments.length;
switch (G__38613) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38663){
var state_val_38664 = (state_38663[(1)]);
if((state_val_38664 === (7))){
var inst_38623 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_38624 = (new Error(inst_38623));
var inst_38625 = (function(){throw inst_38624})();
var state_38663__$1 = state_38663;
var statearr_38665_38701 = state_38663__$1;
(statearr_38665_38701[(2)] = inst_38625);

(statearr_38665_38701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (20))){
var inst_38652 = (state_38663[(2)]);
var state_38663__$1 = state_38663;
var statearr_38666_38702 = state_38663__$1;
(statearr_38666_38702[(2)] = inst_38652);

(statearr_38666_38702[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (1))){
var state_38663__$1 = state_38663;
var statearr_38667_38703 = state_38663__$1;
(statearr_38667_38703[(2)] = null);

(statearr_38667_38703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (4))){
var inst_38614 = (state_38663[(2)]);
var state_38663__$1 = state_38663;
var statearr_38668_38704 = state_38663__$1;
(statearr_38668_38704[(2)] = inst_38614);

(statearr_38668_38704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (15))){
var inst_38632 = (state_38663[(7)]);
var inst_38636 = (state_38663[(8)]);
var inst_38644 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38632,inst_38636);
var state_38663__$1 = state_38663;
var statearr_38669_38705 = state_38663__$1;
(statearr_38669_38705[(2)] = inst_38644);

(statearr_38669_38705[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (13))){
var inst_38631 = (state_38663[(9)]);
var inst_38642 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38631,end);
var state_38663__$1 = state_38663;
if(inst_38642){
var statearr_38670_38706 = state_38663__$1;
(statearr_38670_38706[(1)] = (15));

} else {
var statearr_38671_38707 = state_38663__$1;
(statearr_38671_38707[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (6))){
var state_38663__$1 = state_38663;
var statearr_38672_38708 = state_38663__$1;
(statearr_38672_38708[(2)] = null);

(statearr_38672_38708[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (17))){
var inst_38654 = (state_38663[(2)]);
var state_38663__$1 = state_38663;
var statearr_38673_38709 = state_38663__$1;
(statearr_38673_38709[(2)] = inst_38654);

(statearr_38673_38709[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (3))){
var inst_38661 = (state_38663[(2)]);
var state_38663__$1 = state_38663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38663__$1,inst_38661);
} else {
if((state_val_38664 === (12))){
var inst_38632 = (state_38663[(7)]);
var state_38663__$1 = state_38663;
var statearr_38674_38710 = state_38663__$1;
(statearr_38674_38710[(2)] = inst_38632);

(statearr_38674_38710[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (2))){
var _ = (function (){var statearr_38675 = state_38663;
(statearr_38675[(4)] = cljs.core.cons((5),(state_38663[(4)])));

return statearr_38675;
})();
var inst_38620 = (end >= start);
var state_38663__$1 = state_38663;
if(cljs.core.truth_(inst_38620)){
var statearr_38676_38711 = state_38663__$1;
(statearr_38676_38711[(1)] = (6));

} else {
var statearr_38677_38712 = state_38663__$1;
(statearr_38677_38712[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (19))){
var state_38663__$1 = state_38663;
var statearr_38678_38713 = state_38663__$1;
(statearr_38678_38713[(2)] = null);

(statearr_38678_38713[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (11))){
var inst_38636 = (state_38663[(8)]);
var inst_38636__$1 = (state_38663[(2)]);
var inst_38637 = (inst_38636__$1 == null);
var inst_38638 = (inst_38636__$1 instanceof Error);
var inst_38639 = ((inst_38637) || (inst_38638));
var state_38663__$1 = (function (){var statearr_38680 = state_38663;
(statearr_38680[(8)] = inst_38636__$1);

return statearr_38680;
})();
if(cljs.core.truth_(inst_38639)){
var statearr_38681_38714 = state_38663__$1;
(statearr_38681_38714[(1)] = (12));

} else {
var statearr_38682_38715 = state_38663__$1;
(statearr_38682_38715[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (9))){
var inst_38631 = (state_38663[(9)]);
var inst_38634 = fluree.db.storage.core.read_block(conn,network,dbid,inst_38631);
var state_38663__$1 = state_38663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38663__$1,(11),inst_38634);
} else {
if((state_val_38664 === (5))){
var _ = (function (){var statearr_38683 = state_38663;
(statearr_38683[(4)] = cljs.core.rest((state_38663[(4)])));

return statearr_38683;
})();
var state_38663__$1 = state_38663;
var ex38679 = (state_38663__$1[(2)]);
var statearr_38684_38716 = state_38663__$1;
(statearr_38684_38716[(5)] = ex38679);


if((ex38679 instanceof Error)){
var statearr_38685_38717 = state_38663__$1;
(statearr_38685_38717[(1)] = (4));

(statearr_38685_38717[(5)] = null);

} else {
throw ex38679;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (14))){
var inst_38656 = (state_38663[(2)]);
var state_38663__$1 = state_38663;
var statearr_38686_38718 = state_38663__$1;
(statearr_38686_38718[(2)] = inst_38656);

(statearr_38686_38718[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (16))){
var state_38663__$1 = state_38663;
var statearr_38687_38719 = state_38663__$1;
(statearr_38687_38719[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (10))){
var inst_38658 = (state_38663[(2)]);
var _ = (function (){var statearr_38689 = state_38663;
(statearr_38689[(4)] = cljs.core.rest((state_38663[(4)])));

return statearr_38689;
})();
var state_38663__$1 = state_38663;
var statearr_38690_38720 = state_38663__$1;
(statearr_38690_38720[(2)] = inst_38658);

(statearr_38690_38720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (18))){
var inst_38632 = (state_38663[(7)]);
var inst_38636 = (state_38663[(8)]);
var inst_38631 = (state_38663[(9)]);
var inst_38647 = (inst_38631 + (1));
var inst_38648 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38632,inst_38636);
var inst_38631__$1 = inst_38647;
var inst_38632__$1 = inst_38648;
var state_38663__$1 = (function (){var statearr_38691 = state_38663;
(statearr_38691[(7)] = inst_38632__$1);

(statearr_38691[(9)] = inst_38631__$1);

return statearr_38691;
})();
var statearr_38692_38721 = state_38663__$1;
(statearr_38692_38721[(2)] = null);

(statearr_38692_38721[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38664 === (8))){
var inst_38627 = (state_38663[(2)]);
var inst_38628 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_38629 = start;
var inst_38630 = cljs.core.PersistentVector.EMPTY;
var inst_38631 = inst_38629;
var inst_38632 = inst_38630;
var state_38663__$1 = (function (){var statearr_38693 = state_38663;
(statearr_38693[(10)] = inst_38628);

(statearr_38693[(7)] = inst_38632);

(statearr_38693[(11)] = inst_38627);

(statearr_38693[(9)] = inst_38631);

return statearr_38693;
})();
var statearr_38694_38722 = state_38663__$1;
(statearr_38694_38722[(2)] = null);

(statearr_38694_38722[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__13883__auto__ = null;
var fluree$db$storage$core$state_machine__13883__auto____0 = (function (){
var statearr_38695 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38695[(0)] = fluree$db$storage$core$state_machine__13883__auto__);

(statearr_38695[(1)] = (1));

return statearr_38695;
});
var fluree$db$storage$core$state_machine__13883__auto____1 = (function (state_38663){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38663);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38696){var ex__13886__auto__ = e38696;
var statearr_38697_38723 = state_38663;
(statearr_38697_38723[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38663[(4)]))){
var statearr_38698_38724 = state_38663;
(statearr_38698_38724[(1)] = cljs.core.first((state_38663[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38725 = state_38663;
state_38663 = G__38725;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__13883__auto__ = function(state_38663){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__13883__auto____1.call(this,state_38663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__13883__auto____0;
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__13883__auto____1;
return fluree$db$storage$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38699 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38699[(6)] = c__13957__auto__);

return statearr_38699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38741){
var state_val_38742 = (state_38741[(1)]);
if((state_val_38742 === (1))){
var state_38741__$1 = state_38741;
var statearr_38743_38757 = state_38741__$1;
(statearr_38743_38757[(2)] = null);

(statearr_38743_38757[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38742 === (2))){
var _ = (function (){var statearr_38744 = state_38741;
(statearr_38744[(4)] = cljs.core.cons((5),(state_38741[(4)])));

return statearr_38744;
})();
var inst_38732 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_38741__$1 = state_38741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38741__$1,(6),inst_38732);
} else {
if((state_val_38742 === (3))){
var inst_38739 = (state_38741[(2)]);
var state_38741__$1 = state_38741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38741__$1,inst_38739);
} else {
if((state_val_38742 === (4))){
var inst_38726 = (state_38741[(2)]);
var state_38741__$1 = state_38741;
var statearr_38746_38758 = state_38741__$1;
(statearr_38746_38758[(2)] = inst_38726);

(statearr_38746_38758[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38742 === (5))){
var _ = (function (){var statearr_38747 = state_38741;
(statearr_38747[(4)] = cljs.core.rest((state_38741[(4)])));

return statearr_38747;
})();
var state_38741__$1 = state_38741;
var ex38745 = (state_38741__$1[(2)]);
var statearr_38748_38759 = state_38741__$1;
(statearr_38748_38759[(5)] = ex38745);


if((ex38745 instanceof Error)){
var statearr_38749_38760 = state_38741__$1;
(statearr_38749_38760[(1)] = (4));

(statearr_38749_38760[(5)] = null);

} else {
throw ex38745;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38742 === (6))){
var inst_38734 = (state_38741[(2)]);
var inst_38735 = fluree.db.util.async.throw_err(inst_38734);
var inst_38736 = cljs.core.first(inst_38735);
var _ = (function (){var statearr_38750 = state_38741;
(statearr_38750[(4)] = cljs.core.rest((state_38741[(4)])));

return statearr_38750;
})();
var state_38741__$1 = state_38741;
var statearr_38751_38761 = state_38741__$1;
(statearr_38751_38761[(2)] = inst_38736);

(statearr_38751_38761[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__13883__auto____0 = (function (){
var statearr_38752 = [null,null,null,null,null,null,null];
(statearr_38752[(0)] = fluree$db$storage$core$block_$_state_machine__13883__auto__);

(statearr_38752[(1)] = (1));

return statearr_38752;
});
var fluree$db$storage$core$block_$_state_machine__13883__auto____1 = (function (state_38741){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38741);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38753){var ex__13886__auto__ = e38753;
var statearr_38754_38762 = state_38741;
(statearr_38754_38762[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38741[(4)]))){
var statearr_38755_38763 = state_38741;
(statearr_38755_38763[(1)] = cljs.core.first((state_38741[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38764 = state_38741;
state_38741 = G__38764;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__13883__auto__ = function(state_38741){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__13883__auto____1.call(this,state_38741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__13883__auto____0;
fluree$db$storage$core$block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38756 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38756[(6)] = c__13957__auto__);

return statearr_38756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
