// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k40486,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__40490 = k40486;
var G__40490__$1 = (((G__40490 instanceof cljs.core.Keyword))?G__40490.fqn:null);
switch (G__40490__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40486,else__4418__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__40491){
var vec__40492 = p__40491;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40492,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40492,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40485){
var self__ = this;
var G__40485__$1 = this;
return (new cljs.core.RecordIter((0),G__40485__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__40495 = (function (coll__4412__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__40495(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40487,other40488){
var self__ = this;
var this40487__$1 = this;
return (((!((other40488 == null)))) && ((this40487__$1.constructor === other40488.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.conn,other40488.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.network,other40488.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.dbid,other40488.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.db_name,other40488.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.update_chan,other40488.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.transact_chan,other40488.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.state,other40488.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.schema_cache,other40488.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.blank_db,other40488.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.close,other40488.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.id,other40488.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40487__$1.__extmap,other40488.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__40485){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__40496 = cljs.core.keyword_identical_QMARK_;
var expr__40497 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__40499 = cljs.core.cst$kw$conn;
var G__40500 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40499,G__40500) : pred__40496.call(null,G__40499,G__40500));
})())){
return (new fluree.db.session.DbSession(G__40485,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40501 = cljs.core.cst$kw$network;
var G__40502 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40501,G__40502) : pred__40496.call(null,G__40501,G__40502));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__40485,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40503 = cljs.core.cst$kw$dbid;
var G__40504 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40503,G__40504) : pred__40496.call(null,G__40503,G__40504));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__40485,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40505 = cljs.core.cst$kw$db_DASH_name;
var G__40506 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40505,G__40506) : pred__40496.call(null,G__40505,G__40506));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__40485,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40507 = cljs.core.cst$kw$update_DASH_chan;
var G__40508 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40507,G__40508) : pred__40496.call(null,G__40507,G__40508));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__40485,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40509 = cljs.core.cst$kw$transact_DASH_chan;
var G__40510 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40509,G__40510) : pred__40496.call(null,G__40509,G__40510));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__40485,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40511 = cljs.core.cst$kw$state;
var G__40512 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40511,G__40512) : pred__40496.call(null,G__40511,G__40512));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__40485,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40513 = cljs.core.cst$kw$schema_DASH_cache;
var G__40514 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40513,G__40514) : pred__40496.call(null,G__40513,G__40514));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__40485,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40515 = cljs.core.cst$kw$blank_DASH_db;
var G__40516 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40515,G__40516) : pred__40496.call(null,G__40515,G__40516));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__40485,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40517 = cljs.core.cst$kw$close;
var G__40518 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40517,G__40518) : pred__40496.call(null,G__40517,G__40518));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__40485,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40519 = cljs.core.cst$kw$id;
var G__40520 = expr__40497;
return (pred__40496.cljs$core$IFn$_invoke$arity$2 ? pred__40496.cljs$core$IFn$_invoke$arity$2(G__40519,G__40520) : pred__40496.call(null,G__40519,G__40520));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__40485,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__40485),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__40485){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__40485,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__40489){
var extmap__4454__auto__ = (function (){var G__40521 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40489,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__40489)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40521);
} else {
return G__40521;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__40489),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__40489),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__40523 = session;
var map__40523__$1 = cljs.core.__destructure_map(map__40523);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40523__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40523__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___40675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40627){
var state_val_40628 = (state_40627[(1)]);
if((state_val_40628 === (7))){
var inst_40544 = (state_40627[(7)]);
var inst_40549 = cljs.core.empty_QMARK_(inst_40544);
var state_40627__$1 = state_40627;
if(inst_40549){
var statearr_40629_40676 = state_40627__$1;
(statearr_40629_40676[(1)] = (10));

} else {
var statearr_40630_40677 = state_40627__$1;
(statearr_40630_40677[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (20))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40535 = (state_40627[(10)]);
var inst_40575 = (state_40627[(11)]);
var inst_40580 = fluree.db.storage.core.read_block(inst_40535,inst_40536,inst_40537,inst_40575);
var state_40627__$1 = state_40627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(22),inst_40580);
} else {
if((state_val_40628 === (27))){
var inst_40616 = (state_40627[(12)]);
var inst_40611 = (state_40627[(13)]);
var inst_40614 = (state_40627[(2)]);
var inst_40615 = fluree.db.util.async.throw_err(inst_40614);
var inst_40616__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40611,cljs.core.cst$kw$schema,inst_40615);
var inst_40617 = fluree.db.query.schema.setting_map(inst_40616__$1);
var state_40627__$1 = (function (){var statearr_40631 = state_40627;
(statearr_40631[(12)] = inst_40616__$1);

return statearr_40631;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(28),inst_40617);
} else {
if((state_val_40628 === (1))){
var state_40627__$1 = state_40627;
var statearr_40632_40678 = state_40627__$1;
(statearr_40632_40678[(2)] = null);

(statearr_40632_40678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (24))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40575 = (state_40627[(11)]);
var inst_40597 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40575)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40536),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40537),"."].join('');
var inst_40598 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40599 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_40600 = cljs.core.PersistentHashMap.fromArrays(inst_40598,inst_40599);
var inst_40601 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40597,inst_40600);
var inst_40602 = (function(){throw inst_40601})();
var state_40627__$1 = state_40627;
var statearr_40633_40679 = state_40627__$1;
(statearr_40633_40679[(2)] = inst_40602);

(statearr_40633_40679[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (4))){
var inst_40524 = (state_40627[(2)]);
var inst_40525 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_40524);
var state_40627__$1 = state_40627;
var statearr_40634_40680 = state_40627__$1;
(statearr_40634_40680[(2)] = inst_40525);

(statearr_40634_40680[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (15))){
var state_40627__$1 = state_40627;
var statearr_40635_40681 = state_40627__$1;
(statearr_40635_40681[(2)] = null);

(statearr_40635_40681[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (21))){
var inst_40606 = (state_40627[(2)]);
var state_40627__$1 = state_40627;
var statearr_40636_40682 = state_40627__$1;
(statearr_40636_40682[(2)] = inst_40606);

(statearr_40636_40682[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (13))){
var inst_40544 = (state_40627[(7)]);
var inst_40569 = (state_40627[(14)]);
var inst_40568 = (state_40627[(2)]);
var inst_40569__$1 = fluree.db.util.async.throw_err(inst_40568);
var inst_40570 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40544);
var state_40627__$1 = (function (){var statearr_40637 = state_40627;
(statearr_40637[(15)] = inst_40570);

(statearr_40637[(14)] = inst_40569__$1);

return statearr_40637;
})();
if(cljs.core.truth_(inst_40569__$1)){
var statearr_40638_40683 = state_40627__$1;
(statearr_40638_40683[(1)] = (14));

} else {
var statearr_40639_40684 = state_40627__$1;
(statearr_40639_40684[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (22))){
var inst_40583 = (state_40627[(16)]);
var inst_40582 = (state_40627[(2)]);
var inst_40583__$1 = fluree.db.util.async.throw_err(inst_40582);
var state_40627__$1 = (function (){var statearr_40640 = state_40627;
(statearr_40640[(16)] = inst_40583__$1);

return statearr_40640;
})();
if(cljs.core.truth_(inst_40583__$1)){
var statearr_40641_40685 = state_40627__$1;
(statearr_40641_40685[(1)] = (23));

} else {
var statearr_40642_40686 = state_40627__$1;
(statearr_40642_40686[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (6))){
var inst_40544 = (state_40627[(7)]);
var inst_40543 = (state_40627[(2)]);
var inst_40544__$1 = fluree.db.util.async.throw_err(inst_40543);
var inst_40545 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_40544__$1);
var inst_40546 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_40545);
var inst_40547 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_40546);
var state_40627__$1 = (function (){var statearr_40643 = state_40627;
(statearr_40643[(7)] = inst_40544__$1);

return statearr_40643;
})();
if(inst_40547){
var statearr_40644_40687 = state_40627__$1;
(statearr_40644_40687[(1)] = (7));

} else {
var statearr_40645_40688 = state_40627__$1;
(statearr_40645_40688[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (28))){
var inst_40616 = (state_40627[(12)]);
var inst_40619 = (state_40627[(2)]);
var inst_40620 = fluree.db.util.async.throw_err(inst_40619);
var inst_40621 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40616,cljs.core.cst$kw$settings,inst_40620);
var inst_40622 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_40621);
var _ = (function (){var statearr_40646 = state_40627;
(statearr_40646[(4)] = cljs.core.rest((state_40627[(4)])));

return statearr_40646;
})();
var state_40627__$1 = state_40627;
var statearr_40647_40689 = state_40627__$1;
(statearr_40647_40689[(2)] = inst_40622);

(statearr_40647_40689[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (25))){
var inst_40604 = (state_40627[(2)]);
var state_40627__$1 = state_40627;
var statearr_40648_40690 = state_40627__$1;
(statearr_40648_40690[(2)] = inst_40604);

(statearr_40648_40690[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (17))){
var inst_40570 = (state_40627[(15)]);
var inst_40575 = (state_40627[(11)]);
var inst_40577 = (inst_40575 > inst_40570);
var state_40627__$1 = state_40627;
if(cljs.core.truth_(inst_40577)){
var statearr_40649_40691 = state_40627__$1;
(statearr_40649_40691[(1)] = (19));

} else {
var statearr_40650_40692 = state_40627__$1;
(statearr_40650_40692[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (3))){
var inst_40625 = (state_40627[(2)]);
var state_40627__$1 = state_40627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40627__$1,inst_40625);
} else {
if((state_val_40628 === (12))){
var inst_40556 = (state_40627[(2)]);
var inst_40557 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40558 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_40559 = cljs.core.PersistentHashMap.fromArrays(inst_40557,inst_40558);
var inst_40560 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40556,inst_40559);
var inst_40561 = (function(){throw inst_40560})();
var state_40627__$1 = state_40627;
var statearr_40651_40693 = state_40627__$1;
(statearr_40651_40693[(2)] = inst_40561);

(statearr_40651_40693[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (2))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40535 = (state_40627[(10)]);
var _ = (function (){var statearr_40652 = state_40627;
(statearr_40652[(4)] = cljs.core.cons((5),(state_40627[(4)])));

return statearr_40652;
})();
var inst_40532 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_40533 = session;
var inst_40534 = cljs.core.__destructure_map(inst_40533);
var inst_40535__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40534,cljs.core.cst$kw$conn);
var inst_40536__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40534,cljs.core.cst$kw$network);
var inst_40537__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40534,cljs.core.cst$kw$dbid);
var inst_40538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40539 = [inst_40536__$1,inst_40537__$1];
var inst_40540 = (new cljs.core.PersistentVector(null,2,(5),inst_40538,inst_40539,null));
var inst_40541 = fluree.db.operations.ledger_info_async(inst_40535__$1,inst_40540);
var state_40627__$1 = (function (){var statearr_40653 = state_40627;
(statearr_40653[(8)] = inst_40537__$1);

(statearr_40653[(9)] = inst_40536__$1);

(statearr_40653[(17)] = inst_40532);

(statearr_40653[(10)] = inst_40535__$1);

return statearr_40653;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(6),inst_40541);
} else {
if((state_val_40628 === (23))){
var inst_40583 = (state_40627[(16)]);
var inst_40574 = (state_40627[(18)]);
var inst_40586 = cljs.core.__destructure_map(inst_40583);
var inst_40587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$flakes);
var inst_40588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$block);
var inst_40589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$t);
var inst_40590 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_40574,inst_40588,inst_40587);
var state_40627__$1 = (function (){var statearr_40654 = state_40627;
(statearr_40654[(19)] = inst_40589);

return statearr_40654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(26),inst_40590);
} else {
if((state_val_40628 === (19))){
var inst_40574 = (state_40627[(18)]);
var state_40627__$1 = state_40627;
var statearr_40655_40694 = state_40627__$1;
(statearr_40655_40694[(2)] = inst_40574);

(statearr_40655_40694[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (11))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40544 = (state_40627[(7)]);
var inst_40553 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_40544);
var inst_40554 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40536),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40537)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40553),"."].join('');
var state_40627__$1 = state_40627;
var statearr_40657_40695 = state_40627__$1;
(statearr_40657_40695[(2)] = inst_40554);

(statearr_40657_40695[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (9))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40544 = (state_40627[(7)]);
var inst_40532 = (state_40627[(17)]);
var inst_40535 = (state_40627[(10)]);
var inst_40564 = (state_40627[(2)]);
var inst_40565 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_40544);
var inst_40566 = fluree.db.storage.core.reify_db(inst_40535,inst_40536,inst_40537,inst_40532,inst_40565);
var state_40627__$1 = (function (){var statearr_40658 = state_40627;
(statearr_40658[(20)] = inst_40564);

return statearr_40658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(13),inst_40566);
} else {
if((state_val_40628 === (5))){
var _ = (function (){var statearr_40659 = state_40627;
(statearr_40659[(4)] = cljs.core.rest((state_40627[(4)])));

return statearr_40659;
})();
var state_40627__$1 = state_40627;
var ex40656 = (state_40627__$1[(2)]);
var statearr_40660_40696 = state_40627__$1;
(statearr_40660_40696[(5)] = ex40656);


var statearr_40661_40697 = state_40627__$1;
(statearr_40661_40697[(1)] = (4));

(statearr_40661_40697[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (14))){
var inst_40569 = (state_40627[(14)]);
var inst_40572 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40569);
var inst_40573 = (inst_40572 + (1));
var inst_40574 = inst_40569;
var inst_40575 = inst_40573;
var state_40627__$1 = (function (){var statearr_40662 = state_40627;
(statearr_40662[(18)] = inst_40574);

(statearr_40662[(11)] = inst_40575);

return statearr_40662;
})();
var statearr_40663_40698 = state_40627__$1;
(statearr_40663_40698[(2)] = null);

(statearr_40663_40698[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (26))){
var inst_40575 = (state_40627[(11)]);
var inst_40592 = (state_40627[(2)]);
var inst_40593 = fluree.db.util.async.throw_err(inst_40592);
var inst_40594 = (inst_40575 + (1));
var inst_40574 = inst_40593;
var inst_40575__$1 = inst_40594;
var state_40627__$1 = (function (){var statearr_40664 = state_40627;
(statearr_40664[(18)] = inst_40574);

(statearr_40664[(11)] = inst_40575__$1);

return statearr_40664;
})();
var statearr_40665_40699 = state_40627__$1;
(statearr_40665_40699[(2)] = null);

(statearr_40665_40699[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (16))){
var inst_40611 = (state_40627[(13)]);
var inst_40611__$1 = (state_40627[(2)]);
var inst_40612 = fluree.db.query.schema.schema_map(inst_40611__$1);
var state_40627__$1 = (function (){var statearr_40666 = state_40627;
(statearr_40666[(13)] = inst_40611__$1);

return statearr_40666;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40627__$1,(27),inst_40612);
} else {
if((state_val_40628 === (10))){
var inst_40537 = (state_40627[(8)]);
var inst_40536 = (state_40627[(9)]);
var inst_40551 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40536),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40537)," is not found on this ledger group."].join('');
var state_40627__$1 = state_40627;
var statearr_40667_40700 = state_40627__$1;
(statearr_40667_40700[(2)] = inst_40551);

(statearr_40667_40700[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (18))){
var inst_40608 = (state_40627[(2)]);
var state_40627__$1 = state_40627;
var statearr_40668_40701 = state_40627__$1;
(statearr_40668_40701[(2)] = inst_40608);

(statearr_40668_40701[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40628 === (8))){
var state_40627__$1 = state_40627;
var statearr_40669_40702 = state_40627__$1;
(statearr_40669_40702[(2)] = null);

(statearr_40669_40702[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0 = (function (){
var statearr_40670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40670[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__);

(statearr_40670[(1)] = (1));

return statearr_40670;
});
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1 = (function (state_40627){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40627);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40671){var ex__13886__auto__ = e40671;
var statearr_40672_40703 = state_40627;
(statearr_40672_40703[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40627[(4)]))){
var statearr_40673_40704 = state_40627;
(statearr_40673_40704[(1)] = cljs.core.first((state_40627[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40705 = state_40627;
state_40627 = G__40705;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__ = function(state_40627){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1.call(this,state_40627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40674 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40674[(6)] = c__13957__auto___40675);

return statearr_40674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__40706 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40706,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__40706;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4149__auto__ = network;
if(cljs.core.truth_(and__4149__auto__)){
return maybe_alias;
} else {
return and__4149__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4654__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4655__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4656__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4657__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__40707 = cljs.core.get_global_hierarchy;
return (fexpr__40707.cljs$core$IFn$_invoke$arity$0 ? fexpr__40707.cljs$core$IFn$_invoke$arity$0() : fexpr__40707.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4658__auto__,method_table__4654__auto__,prefer_table__4655__auto__,method_cache__4656__auto__,cached_hierarchy__4657__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40709){
var state_val_40710 = (state_40709[(1)]);
if((state_val_40710 === (1))){
var state_40709__$1 = state_40709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40709__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40711 = [null,null,null,null,null,null,null];
(statearr_40711[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40711[(1)] = (1));

return statearr_40711;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40709){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40709);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40712){var ex__13886__auto__ = e40712;
var statearr_40713_40716 = state_40709;
(statearr_40713_40716[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40709[(4)]))){
var statearr_40714_40717 = state_40709;
(statearr_40714_40717[(1)] = cljs.core.first((state_40709[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40718 = state_40709;
state_40709 = G__40718;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40709){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40715 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40715[(6)] = c__13957__auto__);

return statearr_40715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__40720){
var map__40721 = p__40720;
var map__40721__$1 = cljs.core.__destructure_map(map__40721);
var data = map__40721__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40721__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40721__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40721__$1,cljs.core.cst$kw$flakes);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40780){
var state_val_40781 = (state_40780[(1)]);
if((state_val_40781 === (7))){
var inst_40735 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40736 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40737 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40735),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40736),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_40738 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40737], 0));
var state_40780__$1 = state_40780;
var statearr_40782_40820 = state_40780__$1;
(statearr_40782_40820[(2)] = inst_40738);

(statearr_40782_40820[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (1))){
var state_40780__$1 = state_40780;
var statearr_40783_40821 = state_40780__$1;
(statearr_40783_40821[(2)] = null);

(statearr_40783_40821[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (4))){
var inst_40722 = (state_40780[(2)]);
var state_40780__$1 = state_40780;
var statearr_40784_40822 = state_40780__$1;
(statearr_40784_40822[(2)] = inst_40722);

(statearr_40784_40822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (15))){
var inst_40761 = (state_40780[(2)]);
var state_40780__$1 = state_40780;
var statearr_40785_40823 = state_40780__$1;
(statearr_40785_40823[(2)] = inst_40761);

(statearr_40785_40823[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (13))){
var inst_40752 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_40753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40754 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40755 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40756 = [inst_40754,inst_40755];
var inst_40757 = (new cljs.core.PersistentVector(null,2,(5),inst_40753,inst_40756,null));
var inst_40758 = (function (){var G__40786 = inst_40752;
var G__40787 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__40788 = inst_40757;
var G__40789 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__40786,G__40787,G__40788,G__40789) : fluree.db.conn_events.process_event.call(null,G__40786,G__40787,G__40788,G__40789));
})();
var state_40780__$1 = state_40780;
var statearr_40790_40824 = state_40780__$1;
(statearr_40790_40824[(2)] = inst_40758);

(statearr_40790_40824[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (6))){
var inst_40732 = (state_40780[(7)]);
var inst_40731 = (state_40780[(8)]);
var inst_40730 = (state_40780[(2)]);
var inst_40731__$1 = fluree.db.util.async.throw_err(inst_40730);
var inst_40732__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40731__$1);
var inst_40733 = (block <= inst_40732__$1);
var state_40780__$1 = (function (){var statearr_40791 = state_40780;
(statearr_40791[(7)] = inst_40732__$1);

(statearr_40791[(8)] = inst_40731__$1);

return statearr_40791;
})();
if(cljs.core.truth_(inst_40733)){
var statearr_40792_40825 = state_40780__$1;
(statearr_40792_40825[(1)] = (7));

} else {
var statearr_40793_40826 = state_40780__$1;
(statearr_40793_40826[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (17))){
var state_40780__$1 = state_40780;
var statearr_40794_40827 = state_40780__$1;
(statearr_40794_40827[(2)] = null);

(statearr_40794_40827[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (3))){
var inst_40778 = (state_40780[(2)]);
var state_40780__$1 = state_40780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40780__$1,inst_40778);
} else {
if((state_val_40781 === (12))){
var inst_40773 = (state_40780[(2)]);
var state_40780__$1 = state_40780;
var statearr_40795_40828 = state_40780__$1;
(statearr_40795_40828[(2)] = inst_40773);

(statearr_40795_40828[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (2))){
var inst_40728 = (state_40780[(9)]);
var _ = (function (){var statearr_40796 = state_40780;
(statearr_40796[(4)] = cljs.core.cons((5),(state_40780[(4)])));

return statearr_40796;
})();
var inst_40728__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_40780__$1 = (function (){var statearr_40797 = state_40780;
(statearr_40797[(9)] = inst_40728__$1);

return statearr_40797;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40780__$1,(6),inst_40728__$1);
} else {
if((state_val_40781 === (11))){
var state_40780__$1 = state_40780;
var statearr_40799_40829 = state_40780__$1;
(statearr_40799_40829[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (9))){
var inst_40775 = (state_40780[(2)]);
var _ = (function (){var statearr_40801 = state_40780;
(statearr_40801[(4)] = cljs.core.rest((state_40780[(4)])));

return statearr_40801;
})();
var state_40780__$1 = state_40780;
var statearr_40802_40830 = state_40780__$1;
(statearr_40802_40830[(2)] = inst_40775);

(statearr_40802_40830[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (5))){
var _ = (function (){var statearr_40803 = state_40780;
(statearr_40803[(4)] = cljs.core.rest((state_40780[(4)])));

return statearr_40803;
})();
var state_40780__$1 = state_40780;
var ex40798 = (state_40780__$1[(2)]);
var statearr_40804_40831 = state_40780__$1;
(statearr_40804_40831[(5)] = ex40798);


if((ex40798 instanceof Error)){
var statearr_40805_40832 = state_40780__$1;
(statearr_40805_40832[(1)] = (4));

(statearr_40805_40832[(5)] = null);

} else {
throw ex40798;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (14))){
var state_40780__$1 = state_40780;
var statearr_40806_40833 = state_40780__$1;
(statearr_40806_40833[(2)] = null);

(statearr_40806_40833[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (16))){
var inst_40732 = (state_40780[(7)]);
var inst_40764 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40765 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40766 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40764),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40765),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40732),". Forcing a db reload."].join('');
var inst_40767 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40766], 0));
var inst_40768 = fluree.db.session.reload_db_BANG_(session);
var state_40780__$1 = (function (){var statearr_40807 = state_40780;
(statearr_40807[(10)] = inst_40767);

return statearr_40807;
})();
var statearr_40808_40834 = state_40780__$1;
(statearr_40808_40834[(2)] = inst_40768);

(statearr_40808_40834[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (10))){
var inst_40732 = (state_40780[(7)]);
var inst_40728 = (state_40780[(9)]);
var inst_40731 = (state_40780[(8)]);
var inst_40743 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40744 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40745 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40743),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40744),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_40746 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40745], 0));
var inst_40747 = (function (){var current_db_ch = inst_40728;
var current_db = inst_40731;
var current_block = inst_40732;
return (function (p1__40719_SHARP_){
if((p1__40719_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__40719_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__40719_SHARP_);
}
});
})();
var inst_40748 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40747,flakes);
var inst_40749 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_40731,block,inst_40748);
var inst_40750 = fluree.db.session.cas_db_BANG_(session,inst_40728,inst_40749);
var state_40780__$1 = (function (){var statearr_40809 = state_40780;
(statearr_40809[(11)] = inst_40746);

return statearr_40809;
})();
if(inst_40750){
var statearr_40810_40835 = state_40780__$1;
(statearr_40810_40835[(1)] = (13));

} else {
var statearr_40811_40836 = state_40780__$1;
(statearr_40811_40836[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (18))){
var inst_40771 = (state_40780[(2)]);
var state_40780__$1 = state_40780;
var statearr_40812_40837 = state_40780__$1;
(statearr_40812_40837[(2)] = inst_40771);

(statearr_40812_40837[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40781 === (8))){
var inst_40732 = (state_40780[(7)]);
var inst_40740 = ((1) + inst_40732);
var inst_40741 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_40740);
var state_40780__$1 = state_40780;
if(inst_40741){
var statearr_40813_40838 = state_40780__$1;
(statearr_40813_40838[(1)] = (10));

} else {
var statearr_40814_40839 = state_40780__$1;
(statearr_40814_40839[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40815 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40815[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40815[(1)] = (1));

return statearr_40815;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40780){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40780);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40816){var ex__13886__auto__ = e40816;
var statearr_40817_40840 = state_40780;
(statearr_40817_40840[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40780[(4)]))){
var statearr_40818_40841 = state_40780;
(statearr_40818_40841[(1)] = cljs.core.first((state_40780[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40842 = state_40780;
state_40780 = G__40842;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40780){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40819 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40819[(6)] = c__13957__auto__);

return statearr_40819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40849){
var state_val_40850 = (state_40849[(1)]);
if((state_val_40850 === (1))){
var inst_40843 = fluree.db.session.clear_db_BANG_(session);
var inst_40844 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40845 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40846 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40844),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40845)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_40847 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40846], 0));
var state_40849__$1 = (function (){var statearr_40851 = state_40849;
(statearr_40851[(7)] = inst_40843);

(statearr_40851[(8)] = inst_40847);

return statearr_40851;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40849__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40852 = [null,null,null,null,null,null,null,null,null];
(statearr_40852[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40852[(1)] = (1));

return statearr_40852;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40849){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40849);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40853){var ex__13886__auto__ = e40853;
var statearr_40854_40857 = state_40849;
(statearr_40854_40857[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40849[(4)]))){
var statearr_40855_40858 = state_40849;
(statearr_40855_40858[(1)] = cljs.core.first((state_40849[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40859 = state_40849;
state_40849 = G__40859;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40849){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40856 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40856[(6)] = c__13957__auto__);

return statearr_40856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__40861 = arguments.length;
switch (G__40861) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__40862 = session;
var map__40862__$1 = cljs.core.__destructure_map(map__40862);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40862__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__40863_40866 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40863_40866.cljs$core$IFn$_invoke$arity$3 ? fexpr__40863_40866.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__40863_40866.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__40864_40867 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__40864_40867.cljs$core$IFn$_invoke$arity$0 ? fexpr__40864_40867.cljs$core$IFn$_invoke$arity$0() : fexpr__40864_40867.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40920){
var state_val_40921 = (state_40920[(1)]);
if((state_val_40921 === (7))){
var inst_40916 = (state_40920[(2)]);
var state_40920__$1 = state_40920;
var statearr_40922_40953 = state_40920__$1;
(statearr_40922_40953[(2)] = inst_40916);

(statearr_40922_40953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (1))){
var state_40920__$1 = state_40920;
var statearr_40923_40954 = state_40920__$1;
(statearr_40923_40954[(2)] = null);

(statearr_40923_40954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (4))){
var inst_40871 = (state_40920[(7)]);
var inst_40870 = (state_40920[(2)]);
var inst_40871__$1 = fluree.db.util.async.throw_err(inst_40870);
var inst_40872 = fluree.db.session.from_cache(network,ledger_id);
var inst_40873 = (inst_40871__$1 == null);
var state_40920__$1 = (function (){var statearr_40924 = state_40920;
(statearr_40924[(8)] = inst_40872);

(statearr_40924[(7)] = inst_40871__$1);

return statearr_40924;
})();
if(cljs.core.truth_(inst_40873)){
var statearr_40925_40955 = state_40920__$1;
(statearr_40925_40955[(1)] = (5));

} else {
var statearr_40926_40956 = state_40920__$1;
(statearr_40926_40956[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (15))){
var inst_40908 = (state_40920[(2)]);
var state_40920__$1 = (function (){var statearr_40927 = state_40920;
(statearr_40927[(9)] = inst_40908);

return statearr_40927;
})();
var statearr_40928_40957 = state_40920__$1;
(statearr_40928_40957[(2)] = null);

(statearr_40928_40957[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (13))){
var inst_40912 = (state_40920[(2)]);
var state_40920__$1 = state_40920;
var statearr_40930_40958 = state_40920__$1;
(statearr_40930_40958[(2)] = inst_40912);

(statearr_40930_40958[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (6))){
var inst_40872 = (state_40920[(8)]);
var inst_40878 = (inst_40872 == null);
var state_40920__$1 = state_40920;
if(cljs.core.truth_(inst_40878)){
var statearr_40931_40959 = state_40920__$1;
(statearr_40931_40959[(1)] = (8));

} else {
var statearr_40932_40960 = state_40920__$1;
(statearr_40932_40960[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (17))){
var _ = (function (){var statearr_40933 = state_40920;
(statearr_40933[(4)] = cljs.core.rest((state_40920[(4)])));

return statearr_40933;
})();
var state_40920__$1 = state_40920;
var ex40929 = (state_40920__$1[(2)]);
var statearr_40934_40961 = state_40920__$1;
(statearr_40934_40961[(5)] = ex40929);


var statearr_40935_40962 = state_40920__$1;
(statearr_40935_40962[(1)] = (16));

(statearr_40935_40962[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (3))){
var inst_40918 = (state_40920[(2)]);
var state_40920__$1 = state_40920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40920__$1,inst_40918);
} else {
if((state_val_40921 === (12))){
var state_40920__$1 = state_40920;
var statearr_40936_40963 = state_40920__$1;
(statearr_40936_40963[(2)] = null);

(statearr_40936_40963[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (2))){
var state_40920__$1 = state_40920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40920__$1,(4),update_chan);
} else {
if((state_val_40921 === (11))){
var state_40920__$1 = state_40920;
var statearr_40937_40964 = state_40920__$1;
(statearr_40937_40964[(2)] = null);

(statearr_40937_40964[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (9))){
var state_40920__$1 = state_40920;
var statearr_40938_40965 = state_40920__$1;
(statearr_40938_40965[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (5))){
var inst_40875 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_40876 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40875], 0));
var state_40920__$1 = state_40920;
var statearr_40940_40966 = state_40920__$1;
(statearr_40940_40966[(2)] = inst_40876);

(statearr_40940_40966[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (14))){
var inst_40872 = (state_40920[(8)]);
var inst_40871 = (state_40920[(7)]);
var _ = (function (){var statearr_40941 = state_40920;
(statearr_40941[(4)] = cljs.core.cons((17),(state_40920[(4)])));

return statearr_40941;
})();
var inst_40896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40871,(0),null);
var inst_40897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40871,(1),null);
var inst_40898 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_40899 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40871], 0));
var inst_40900 = fluree.db.util.core.trunc(inst_40899,(200));
var inst_40901 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40898,inst_40900], 0));
var inst_40902 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_40872,inst_40896,inst_40897) : fluree.db.session.process_ledger_update.call(null,inst_40872,inst_40896,inst_40897));
var state_40920__$1 = (function (){var statearr_40942 = state_40920;
(statearr_40942[(10)] = inst_40901);

return statearr_40942;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40920__$1,(18),inst_40902);
} else {
if((state_val_40921 === (16))){
var inst_40871 = (state_40920[(7)]);
var inst_40886 = (state_40920[(2)]);
var inst_40887 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40886,"Exception processing ledger updates for message: ",inst_40871], 0));
var state_40920__$1 = state_40920;
var statearr_40943_40967 = state_40920__$1;
(statearr_40943_40967[(2)] = inst_40887);

(statearr_40943_40967[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (10))){
var inst_40914 = (state_40920[(2)]);
var state_40920__$1 = state_40920;
var statearr_40944_40968 = state_40920__$1;
(statearr_40944_40968[(2)] = inst_40914);

(statearr_40944_40968[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (18))){
var inst_40904 = (state_40920[(2)]);
var inst_40905 = fluree.db.util.async.throw_err(inst_40904);
var _ = (function (){var statearr_40945 = state_40920;
(statearr_40945[(4)] = cljs.core.rest((state_40920[(4)])));

return statearr_40945;
})();
var state_40920__$1 = state_40920;
var statearr_40946_40969 = state_40920__$1;
(statearr_40946_40969[(2)] = inst_40905);

(statearr_40946_40969[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40921 === (8))){
var inst_40871 = (state_40920[(7)]);
var inst_40880 = cljs.core.first(inst_40871);
var inst_40881 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40880], 0));
var inst_40882 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_40881].join('');
var inst_40883 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40882], 0));
var state_40920__$1 = state_40920;
var statearr_40947_40970 = state_40920__$1;
(statearr_40947_40970[(2)] = inst_40883);

(statearr_40947_40970[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0 = (function (){
var statearr_40948 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40948[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__);

(statearr_40948[(1)] = (1));

return statearr_40948;
});
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1 = (function (state_40920){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40920);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40949){var ex__13886__auto__ = e40949;
var statearr_40950_40971 = state_40920;
(statearr_40950_40971[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40920[(4)]))){
var statearr_40951_40972 = state_40920;
(statearr_40951_40972[(1)] = cljs.core.first((state_40920[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40973 = state_40920;
state_40920 = G__40973;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__ = function(state_40920){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1.call(this,state_40920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40952 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40952[(6)] = c__13957__auto__);

return statearr_40952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__40974){
var map__40975 = p__40974;
var map__40975__$1 = cljs.core.__destructure_map(map__40975);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__40979 = block_result;
var map__40979__$1 = cljs.core.__destructure_map(map__40979);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40979__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40979__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40979__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40979__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40979__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__40980 = tx_result;
var map__40980__$1 = cljs.core.__destructure_map(map__40980);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40980__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40980__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__40976_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__40976_SHARP_.t);
}):(function (p1__40977_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40977_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__40978_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__40978_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40978_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__40981 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40981,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40981,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40981,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40981,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = message;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__40985 = arguments.length;
switch (G__40985) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__40986){
var map__40987 = p__40986;
var map__40987__$1 = cljs.core.__destructure_map(map__40987);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40987__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40987__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40987__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40987__$1,cljs.core.cst$kw$jwt);
var vec__40988 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40988,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40988,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40988,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4160__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4160__auto____$1 = state;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__40992_41112 = network;
var G__40993_41113 = ledger_id;
var G__40994_41114 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__40995_41115 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__40996 = cljs.core.seq(tids);
var chunk__40997 = null;
var count__40998 = (0);
var i__40999 = (0);
while(true){
if((i__40999 < count__40998)){
var tid = chunk__40997.cljs$core$IIndexed$_nth$arity$2(null,i__40999);
var temp__5753__auto___41117__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___41117__$1)){
var keyed_callbacks_41118 = temp__5753__auto___41117__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_41119 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__41040_41120 = cljs.core.seq(keyed_callbacks_41118);
var chunk__41041_41121 = null;
var count__41042_41122 = (0);
var i__41043_41123 = (0);
while(true){
if((i__41043_41123 < count__41042_41122)){
var vec__41052_41124 = chunk__41041_41121.cljs$core$IIndexed$_nth$arity$2(null,i__41043_41123);
var k_41125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41052_41124,(0),null);
var f_41126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41052_41124,(1),null);
try{(f_41126.cljs$core$IFn$_invoke$arity$1 ? f_41126.cljs$core$IFn$_invoke$arity$1(tx_response_41119) : f_41126.call(null,tx_response_41119));
}catch (e41055){var e_41127 = e41055;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41127,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41128 = seq__41040_41120;
var G__41129 = chunk__41041_41121;
var G__41130 = count__41042_41122;
var G__41131 = (i__41043_41123 + (1));
seq__41040_41120 = G__41128;
chunk__41041_41121 = G__41129;
count__41042_41122 = G__41130;
i__41043_41123 = G__41131;
continue;
} else {
var temp__5753__auto___41132__$2 = cljs.core.seq(seq__41040_41120);
if(temp__5753__auto___41132__$2){
var seq__41040_41133__$1 = temp__5753__auto___41132__$2;
if(cljs.core.chunked_seq_QMARK_(seq__41040_41133__$1)){
var c__4591__auto___41134 = cljs.core.chunk_first(seq__41040_41133__$1);
var G__41135 = cljs.core.chunk_rest(seq__41040_41133__$1);
var G__41136 = c__4591__auto___41134;
var G__41137 = cljs.core.count(c__4591__auto___41134);
var G__41138 = (0);
seq__41040_41120 = G__41135;
chunk__41041_41121 = G__41136;
count__41042_41122 = G__41137;
i__41043_41123 = G__41138;
continue;
} else {
var vec__41056_41139 = cljs.core.first(seq__41040_41133__$1);
var k_41140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41056_41139,(0),null);
var f_41141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41056_41139,(1),null);
try{(f_41141.cljs$core$IFn$_invoke$arity$1 ? f_41141.cljs$core$IFn$_invoke$arity$1(tx_response_41119) : f_41141.call(null,tx_response_41119));
}catch (e41059){var e_41142 = e41059;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41142,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41143 = cljs.core.next(seq__41040_41133__$1);
var G__41144 = null;
var G__41145 = (0);
var G__41146 = (0);
seq__41040_41120 = G__41143;
chunk__41041_41121 = G__41144;
count__41042_41122 = G__41145;
i__41043_41123 = G__41146;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__41147 = seq__40996;
var G__41148 = chunk__40997;
var G__41149 = count__40998;
var G__41150 = (i__40999 + (1));
seq__40996 = G__41147;
chunk__40997 = G__41148;
count__40998 = G__41149;
i__40999 = G__41150;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__40996);
if(temp__5753__auto____$1){
var seq__40996__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__40996__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__40996__$1);
var G__41151 = cljs.core.chunk_rest(seq__40996__$1);
var G__41152 = c__4591__auto__;
var G__41153 = cljs.core.count(c__4591__auto__);
var G__41154 = (0);
seq__40996 = G__41151;
chunk__40997 = G__41152;
count__40998 = G__41153;
i__40999 = G__41154;
continue;
} else {
var tid = cljs.core.first(seq__40996__$1);
var temp__5753__auto___41155__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___41155__$2)){
var keyed_callbacks_41156 = temp__5753__auto___41155__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_41157 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__41060_41158 = cljs.core.seq(keyed_callbacks_41156);
var chunk__41061_41159 = null;
var count__41062_41160 = (0);
var i__41063_41161 = (0);
while(true){
if((i__41063_41161 < count__41062_41160)){
var vec__41072_41162 = chunk__41061_41159.cljs$core$IIndexed$_nth$arity$2(null,i__41063_41161);
var k_41163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41072_41162,(0),null);
var f_41164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41072_41162,(1),null);
try{(f_41164.cljs$core$IFn$_invoke$arity$1 ? f_41164.cljs$core$IFn$_invoke$arity$1(tx_response_41157) : f_41164.call(null,tx_response_41157));
}catch (e41075){var e_41165 = e41075;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41165,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41166 = seq__41060_41158;
var G__41167 = chunk__41061_41159;
var G__41168 = count__41062_41160;
var G__41169 = (i__41063_41161 + (1));
seq__41060_41158 = G__41166;
chunk__41061_41159 = G__41167;
count__41062_41160 = G__41168;
i__41063_41161 = G__41169;
continue;
} else {
var temp__5753__auto___41170__$3 = cljs.core.seq(seq__41060_41158);
if(temp__5753__auto___41170__$3){
var seq__41060_41171__$1 = temp__5753__auto___41170__$3;
if(cljs.core.chunked_seq_QMARK_(seq__41060_41171__$1)){
var c__4591__auto___41172 = cljs.core.chunk_first(seq__41060_41171__$1);
var G__41173 = cljs.core.chunk_rest(seq__41060_41171__$1);
var G__41174 = c__4591__auto___41172;
var G__41175 = cljs.core.count(c__4591__auto___41172);
var G__41176 = (0);
seq__41060_41158 = G__41173;
chunk__41061_41159 = G__41174;
count__41062_41160 = G__41175;
i__41063_41161 = G__41176;
continue;
} else {
var vec__41076_41177 = cljs.core.first(seq__41060_41171__$1);
var k_41178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41076_41177,(0),null);
var f_41179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41076_41177,(1),null);
try{(f_41179.cljs$core$IFn$_invoke$arity$1 ? f_41179.cljs$core$IFn$_invoke$arity$1(tx_response_41157) : f_41179.call(null,tx_response_41157));
}catch (e41079){var e_41180 = e41079;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41180,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41181 = cljs.core.next(seq__41060_41171__$1);
var G__41182 = null;
var G__41183 = (0);
var G__41184 = (0);
seq__41060_41158 = G__41181;
chunk__41061_41159 = G__41182;
count__41062_41160 = G__41183;
i__41063_41161 = G__41184;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__41185 = cljs.core.next(seq__40996__$1);
var G__41186 = null;
var G__41187 = (0);
var G__41188 = (0);
seq__40996 = G__41185;
chunk__40997 = G__41186;
count__40998 = G__41187;
i__40999 = G__41188;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__40991_41116 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40991_41116.cljs$core$IFn$_invoke$arity$4 ? fexpr__40991_41116.cljs$core$IFn$_invoke$arity$4(G__40992_41112,G__40993_41113,G__40994_41114,G__40995_41115) : fexpr__40991_41116.call(null,G__40992_41112,G__40993_41113,G__40994_41114,G__40995_41115));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_41189 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__13957__auto___41190 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_41096){
var state_val_41097 = (state_41096[(1)]);
if((state_val_41097 === (1))){
var state_41096__$1 = state_41096;
var statearr_41098_41191 = state_41096__$1;
(statearr_41098_41191[(2)] = null);

(statearr_41098_41191[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41097 === (2))){
var inst_41081 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_41096__$1 = state_41096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41096__$1,(4),inst_41081);
} else {
if((state_val_41097 === (3))){
var inst_41094 = (state_41096[(2)]);
var state_41096__$1 = state_41096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41096__$1,inst_41094);
} else {
if((state_val_41097 === (4))){
var inst_41083 = (state_41096[(7)]);
var inst_41083__$1 = (state_41096[(2)]);
var inst_41084 = (inst_41083__$1 == null);
var state_41096__$1 = (function (){var statearr_41099 = state_41096;
(statearr_41099[(7)] = inst_41083__$1);

return statearr_41099;
})();
if(cljs.core.truth_(inst_41084)){
var statearr_41100_41192 = state_41096__$1;
(statearr_41100_41192[(1)] = (5));

} else {
var statearr_41101_41193 = state_41096__$1;
(statearr_41101_41193[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41097 === (5))){
var inst_41086 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_41087 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41086], 0));
var state_41096__$1 = state_41096;
var statearr_41102_41194 = state_41096__$1;
(statearr_41102_41194[(2)] = inst_41087);

(statearr_41102_41194[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41097 === (6))){
var inst_41083 = (state_41096[(7)]);
var inst_41089 = (transact_handler_41189.cljs$core$IFn$_invoke$arity$2 ? transact_handler_41189.cljs$core$IFn$_invoke$arity$2(conn,inst_41083) : transact_handler_41189.call(null,conn,inst_41083));
var state_41096__$1 = (function (){var statearr_41103 = state_41096;
(statearr_41103[(8)] = inst_41089);

return statearr_41103;
})();
var statearr_41104_41195 = state_41096__$1;
(statearr_41104_41195[(2)] = null);

(statearr_41104_41195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41097 === (7))){
var inst_41092 = (state_41096[(2)]);
var state_41096__$1 = state_41096;
var statearr_41105_41196 = state_41096__$1;
(statearr_41105_41196[(2)] = inst_41092);

(statearr_41105_41196[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_41106 = [null,null,null,null,null,null,null,null,null];
(statearr_41106[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_41106[(1)] = (1));

return statearr_41106;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_41096){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_41096);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e41107){var ex__13886__auto__ = e41107;
var statearr_41108_41197 = state_41096;
(statearr_41108_41197[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_41096[(4)]))){
var statearr_41109_41198 = state_41096;
(statearr_41109_41198[(1)] = cljs.core.first((state_41096[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__41199 = state_41096;
state_41096 = G__41199;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_41096){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_41096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_41110 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_41110[(6)] = c__13957__auto___41190);

return statearr_41110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__41200_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__41200_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__41200_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__41201_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__41201_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__41204 = arguments.length;
switch (G__41204) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__41205 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41202_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__41202_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__41205);
} else {
return G__41205;
}
})();
var seq__41206 = cljs.core.seq(sessions);
var chunk__41207 = null;
var count__41208 = (0);
var i__41209 = (0);
while(true){
if((i__41209 < count__41208)){
var session = chunk__41207.cljs$core$IIndexed$_nth$arity$2(null,i__41209);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__41211 = seq__41206;
var G__41212 = chunk__41207;
var G__41213 = count__41208;
var G__41214 = (i__41209 + (1));
seq__41206 = G__41211;
chunk__41207 = G__41212;
count__41208 = G__41213;
i__41209 = G__41214;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__41206);
if(temp__5753__auto__){
var seq__41206__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41206__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__41206__$1);
var G__41215 = cljs.core.chunk_rest(seq__41206__$1);
var G__41216 = c__4591__auto__;
var G__41217 = cljs.core.count(c__4591__auto__);
var G__41218 = (0);
seq__41206 = G__41215;
chunk__41207 = G__41216;
count__41208 = G__41217;
i__41209 = G__41218;
continue;
} else {
var session = cljs.core.first(seq__41206__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__41219 = cljs.core.next(seq__41206__$1);
var G__41220 = null;
var G__41221 = (0);
var G__41222 = (0);
seq__41206 = G__41219;
chunk__41207 = G__41220;
count__41208 = G__41221;
i__41209 = G__41222;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
