// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32004){
var state_val_32005 = (state_32004[(1)]);
if((state_val_32005 === (1))){
var state_32004__$1 = state_32004;
var statearr_32006_32020 = state_32004__$1;
(statearr_32006_32020[(2)] = null);

(statearr_32006_32020[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32005 === (2))){
var _ = (function (){var statearr_32007 = state_32004;
(statearr_32007[(4)] = cljs.core.cons((5),(state_32004[(4)])));

return statearr_32007;
})();
var inst_31995 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_32004__$1 = state_32004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32004__$1,(6),inst_31995);
} else {
if((state_val_32005 === (3))){
var inst_32002 = (state_32004[(2)]);
var state_32004__$1 = state_32004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32004__$1,inst_32002);
} else {
if((state_val_32005 === (4))){
var inst_31989 = (state_32004[(2)]);
var state_32004__$1 = state_32004;
var statearr_32009_32021 = state_32004__$1;
(statearr_32009_32021[(2)] = inst_31989);

(statearr_32009_32021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32005 === (5))){
var _ = (function (){var statearr_32010 = state_32004;
(statearr_32010[(4)] = cljs.core.rest((state_32004[(4)])));

return statearr_32010;
})();
var state_32004__$1 = state_32004;
var ex32008 = (state_32004__$1[(2)]);
var statearr_32011_32022 = state_32004__$1;
(statearr_32011_32022[(5)] = ex32008);


if((ex32008 instanceof Error)){
var statearr_32012_32023 = state_32004__$1;
(statearr_32012_32023[(1)] = (4));

(statearr_32012_32023[(5)] = null);

} else {
throw ex32008;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32005 === (6))){
var inst_31997 = (state_32004[(2)]);
var inst_31998 = fluree.db.util.async.throw_err(inst_31997);
var inst_31999 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31998);
var _ = (function (){var statearr_32013 = state_32004;
(statearr_32013[(4)] = cljs.core.rest((state_32004[(4)])));

return statearr_32013;
})();
var state_32004__$1 = state_32004;
var statearr_32014_32024 = state_32004__$1;
(statearr_32014_32024[(2)] = inst_31999);

(statearr_32014_32024[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0 = (function (){
var statearr_32015 = [null,null,null,null,null,null,null];
(statearr_32015[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__);

(statearr_32015[(1)] = (1));

return statearr_32015;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1 = (function (state_32004){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32004);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32016){var ex__13886__auto__ = e32016;
var statearr_32017_32025 = state_32004;
(statearr_32017_32025[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32004[(4)]))){
var statearr_32018_32026 = state_32004;
(statearr_32018_32026[(1)] = cljs.core.first((state_32004[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32027 = state_32004;
state_32004 = G__32027;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__ = function(state_32004){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1.call(this,state_32004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32019 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32019[(6)] = c__13957__auto__);

return statearr_32019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32059){
var state_val_32060 = (state_32059[(1)]);
if((state_val_32060 === (7))){
var inst_32043 = (state_32059[(7)]);
var inst_32045 = cljs.core.empty_QMARK_(inst_32043);
var inst_32046 = (!(inst_32045));
var state_32059__$1 = state_32059;
var statearr_32061_32085 = state_32059__$1;
(statearr_32061_32085[(2)] = inst_32046);

(statearr_32061_32085[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (1))){
var state_32059__$1 = state_32059;
var statearr_32062_32086 = state_32059__$1;
(statearr_32062_32086[(2)] = null);

(statearr_32062_32086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (4))){
var inst_32029 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
var statearr_32063_32087 = state_32059__$1;
(statearr_32063_32087[(2)] = inst_32029);

(statearr_32063_32087[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (6))){
var inst_32035 = (state_32059[(8)]);
var inst_32043 = (state_32059[(7)]);
var inst_32041 = (state_32059[(2)]);
var inst_32042 = fluree.db.util.async.throw_err(inst_32041);
var inst_32043__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32035,inst_32042);
var state_32059__$1 = (function (){var statearr_32064 = state_32059;
(statearr_32064[(7)] = inst_32043__$1);

return statearr_32064;
})();
if(cljs.core.truth_(inst_32043__$1)){
var statearr_32065_32088 = state_32059__$1;
(statearr_32065_32088[(1)] = (7));

} else {
var statearr_32066_32089 = state_32059__$1;
(statearr_32066_32089[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (3))){
var inst_32057 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32059__$1,inst_32057);
} else {
if((state_val_32060 === (12))){
var inst_32054 = (state_32059[(2)]);
var _ = (function (){var statearr_32067 = state_32059;
(statearr_32067[(4)] = cljs.core.rest((state_32059[(4)])));

return statearr_32067;
})();
var state_32059__$1 = state_32059;
var statearr_32068_32090 = state_32059__$1;
(statearr_32068_32090[(2)] = inst_32054);

(statearr_32068_32090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (2))){
var _ = (function (){var statearr_32069 = state_32059;
(statearr_32069[(4)] = cljs.core.cons((5),(state_32059[(4)])));

return statearr_32069;
})();
var inst_32035 = (function (){return (function (p1__32028_SHARP_){
return p1__32028_SHARP_.o;
});
})();
var inst_32036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32037 = [pred_id];
var inst_32038 = (new cljs.core.PersistentVector(null,1,(5),inst_32036,inst_32037,null));
var inst_32039 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32038);
var state_32059__$1 = (function (){var statearr_32070 = state_32059;
(statearr_32070[(8)] = inst_32035);

return statearr_32070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32059__$1,(6),inst_32039);
} else {
if((state_val_32060 === (11))){
var state_32059__$1 = state_32059;
var statearr_32072_32091 = state_32059__$1;
(statearr_32072_32091[(2)] = true);

(statearr_32072_32091[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (9))){
var inst_32049 = (state_32059[(2)]);
var state_32059__$1 = state_32059;
if(cljs.core.truth_(inst_32049)){
var statearr_32073_32092 = state_32059__$1;
(statearr_32073_32092[(1)] = (10));

} else {
var statearr_32074_32093 = state_32059__$1;
(statearr_32074_32093[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (5))){
var _ = (function (){var statearr_32075 = state_32059;
(statearr_32075[(4)] = cljs.core.rest((state_32059[(4)])));

return statearr_32075;
})();
var state_32059__$1 = state_32059;
var ex32071 = (state_32059__$1[(2)]);
var statearr_32076_32094 = state_32059__$1;
(statearr_32076_32094[(5)] = ex32071);


if((ex32071 instanceof Error)){
var statearr_32077_32095 = state_32059__$1;
(statearr_32077_32095[(1)] = (4));

(statearr_32077_32095[(5)] = null);

} else {
throw ex32071;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (10))){
var inst_32043 = (state_32059[(7)]);
var inst_32051 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_32043);
var state_32059__$1 = state_32059;
var statearr_32078_32096 = state_32059__$1;
(statearr_32078_32096[(2)] = inst_32051);

(statearr_32078_32096[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32060 === (8))){
var inst_32043 = (state_32059[(7)]);
var state_32059__$1 = state_32059;
var statearr_32079_32097 = state_32059__$1;
(statearr_32079_32097[(2)] = inst_32043);

(statearr_32079_32097[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_32080 = [null,null,null,null,null,null,null,null,null];
(statearr_32080[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__);

(statearr_32080[(1)] = (1));

return statearr_32080;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1 = (function (state_32059){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32059);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32081){var ex__13886__auto__ = e32081;
var statearr_32082_32098 = state_32059;
(statearr_32082_32098[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32059[(4)]))){
var statearr_32083_32099 = state_32059;
(statearr_32083_32099[(1)] = cljs.core.first((state_32059[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32100 = state_32059;
state_32059 = G__32100;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__ = function(state_32059){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1.call(this,state_32059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32084 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32084[(6)] = c__13957__auto__);

return statearr_32084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32177){
var state_val_32178 = (state_32177[(1)]);
if((state_val_32178 === (7))){
var inst_32172 = (state_32177[(2)]);
var _ = (function (){var statearr_32179 = state_32177;
(statearr_32179[(4)] = cljs.core.rest((state_32177[(4)])));

return statearr_32179;
})();
var state_32177__$1 = state_32177;
var statearr_32180_32213 = state_32177__$1;
(statearr_32180_32213[(2)] = inst_32172);

(statearr_32180_32213[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (1))){
var state_32177__$1 = state_32177;
var statearr_32181_32214 = state_32177__$1;
(statearr_32181_32214[(2)] = null);

(statearr_32181_32214[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (4))){
var inst_32103 = (state_32177[(2)]);
var state_32177__$1 = state_32177;
var statearr_32182_32215 = state_32177__$1;
(statearr_32182_32215[(2)] = inst_32103);

(statearr_32182_32215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (15))){
var inst_32153 = (state_32177[(7)]);
var inst_32140 = (state_32177[(8)]);
var inst_32127 = (state_32177[(9)]);
var inst_32133 = (state_32177[(10)]);
var inst_32155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32156 = inst_32133.s;
var inst_32157 = [inst_32156,inst_32140,cljs.core.cst$kw$old];
var inst_32158 = (new cljs.core.PersistentVector(null,3,(5),inst_32155,inst_32157,null));
var inst_32159 = cljs.core.assoc_in(inst_32127,inst_32158,inst_32153);
var state_32177__$1 = state_32177;
var statearr_32183_32216 = state_32177__$1;
(statearr_32183_32216[(2)] = inst_32159);

(statearr_32183_32216[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (13))){
var inst_32142 = (state_32177[(11)]);
var inst_32153 = (state_32177[(2)]);
var state_32177__$1 = (function (){var statearr_32184 = state_32177;
(statearr_32184[(7)] = inst_32153);

return statearr_32184;
})();
if(cljs.core.truth_(inst_32142)){
var statearr_32185_32217 = state_32177__$1;
(statearr_32185_32217[(1)] = (15));

} else {
var statearr_32186_32218 = state_32177__$1;
(statearr_32186_32218[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (6))){
var inst_32126 = (state_32177[(12)]);
var inst_32133 = (state_32177[(10)]);
var inst_32132 = cljs.core.seq(inst_32126);
var inst_32133__$1 = cljs.core.first(inst_32132);
var inst_32134 = cljs.core.next(inst_32132);
var inst_32135 = cljs.core.not(inst_32133__$1);
var state_32177__$1 = (function (){var statearr_32187 = state_32177;
(statearr_32187[(13)] = inst_32134);

(statearr_32187[(10)] = inst_32133__$1);

return statearr_32187;
})();
if(inst_32135){
var statearr_32188_32219 = state_32177__$1;
(statearr_32188_32219[(1)] = (8));

} else {
var statearr_32189_32220 = state_32177__$1;
(statearr_32189_32220[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (17))){
var inst_32134 = (state_32177[(13)]);
var inst_32167 = (state_32177[(2)]);
var inst_32126 = inst_32134;
var inst_32127 = inst_32167;
var state_32177__$1 = (function (){var statearr_32190 = state_32177;
(statearr_32190[(9)] = inst_32127);

(statearr_32190[(12)] = inst_32126);

return statearr_32190;
})();
var statearr_32191_32221 = state_32177__$1;
(statearr_32191_32221[(2)] = null);

(statearr_32191_32221[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (3))){
var inst_32175 = (state_32177[(2)]);
var state_32177__$1 = state_32177;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32177__$1,inst_32175);
} else {
if((state_val_32178 === (12))){
var inst_32133 = (state_32177[(10)]);
var inst_32151 = inst_32133.o;
var state_32177__$1 = state_32177;
var statearr_32192_32222 = state_32177__$1;
(statearr_32192_32222[(2)] = inst_32151);

(statearr_32192_32222[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (2))){
var _ = (function (){var statearr_32193 = state_32177;
(statearr_32193[(4)] = cljs.core.cons((5),(state_32177[(4)])));

return statearr_32193;
})();
var inst_32109 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_32110 = cljs.core.PersistentHashSet.EMPTY;
var inst_32111 = cljs.core.vals(tempids);
var inst_32112 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32110,inst_32111);
var inst_32113 = (function (){var pred_flakes = inst_32109;
var is_new_QMARK_ = inst_32112;
return (function (p1__32101_SHARP_,p2__32102_SHARP_){
return cljs.core.assoc_in(p1__32101_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__32102_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__32194 = p2__32102_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32194) : is_new_QMARK_.call(null,G__32194));
})()));
});
})();
var inst_32114 = cljs.core.PersistentHashMap.EMPTY;
var inst_32115 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32113,inst_32114,inst_32109);
var inst_32123 = cljs.core.seq(inst_32109);
var inst_32124 = cljs.core.first(inst_32123);
var inst_32125 = cljs.core.next(inst_32123);
var inst_32126 = inst_32109;
var inst_32127 = inst_32115;
var state_32177__$1 = (function (){var statearr_32195 = state_32177;
(statearr_32195[(9)] = inst_32127);

(statearr_32195[(14)] = inst_32124);

(statearr_32195[(12)] = inst_32126);

(statearr_32195[(15)] = inst_32125);

return statearr_32195;
})();
var statearr_32196_32223 = state_32177__$1;
(statearr_32196_32223[(2)] = null);

(statearr_32196_32223[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (11))){
var inst_32133 = (state_32177[(10)]);
var inst_32145 = inst_32133.o;
var inst_32146 = fluree.db.query.schema.convert_type_to_kw(inst_32145,db);
var state_32177__$1 = state_32177;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32177__$1,(14),inst_32146);
} else {
if((state_val_32178 === (9))){
var inst_32140 = (state_32177[(8)]);
var inst_32133 = (state_32177[(10)]);
var inst_32138 = inst_32133.p;
var inst_32139 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_32138);
var inst_32140__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_32139);
var inst_32141 = inst_32133.op;
var inst_32142 = inst_32141 === false;
var inst_32143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_32140__$1);
var state_32177__$1 = (function (){var statearr_32198 = state_32177;
(statearr_32198[(11)] = inst_32142);

(statearr_32198[(8)] = inst_32140__$1);

return statearr_32198;
})();
if(inst_32143){
var statearr_32199_32224 = state_32177__$1;
(statearr_32199_32224[(1)] = (11));

} else {
var statearr_32200_32225 = state_32177__$1;
(statearr_32200_32225[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (5))){
var _ = (function (){var statearr_32201 = state_32177;
(statearr_32201[(4)] = cljs.core.rest((state_32177[(4)])));

return statearr_32201;
})();
var state_32177__$1 = state_32177;
var ex32197 = (state_32177__$1[(2)]);
var statearr_32202_32226 = state_32177__$1;
(statearr_32202_32226[(5)] = ex32197);


if((ex32197 instanceof Error)){
var statearr_32203_32227 = state_32177__$1;
(statearr_32203_32227[(1)] = (4));

(statearr_32203_32227[(5)] = null);

} else {
throw ex32197;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (14))){
var inst_32148 = (state_32177[(2)]);
var inst_32149 = fluree.db.util.async.throw_err(inst_32148);
var state_32177__$1 = state_32177;
var statearr_32204_32228 = state_32177__$1;
(statearr_32204_32228[(2)] = inst_32149);

(statearr_32204_32228[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (16))){
var inst_32153 = (state_32177[(7)]);
var inst_32140 = (state_32177[(8)]);
var inst_32127 = (state_32177[(9)]);
var inst_32133 = (state_32177[(10)]);
var inst_32161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32162 = inst_32133.s;
var inst_32163 = [inst_32162,inst_32140,cljs.core.cst$kw$new];
var inst_32164 = (new cljs.core.PersistentVector(null,3,(5),inst_32161,inst_32163,null));
var inst_32165 = cljs.core.assoc_in(inst_32127,inst_32164,inst_32153);
var state_32177__$1 = state_32177;
var statearr_32205_32229 = state_32177__$1;
(statearr_32205_32229[(2)] = inst_32165);

(statearr_32205_32229[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (10))){
var inst_32170 = (state_32177[(2)]);
var state_32177__$1 = state_32177;
var statearr_32206_32230 = state_32177__$1;
(statearr_32206_32230[(2)] = inst_32170);

(statearr_32206_32230[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32178 === (8))){
var inst_32127 = (state_32177[(9)]);
var state_32177__$1 = state_32177;
var statearr_32207_32231 = state_32177__$1;
(statearr_32207_32231[(2)] = inst_32127);

(statearr_32207_32231[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0 = (function (){
var statearr_32208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32208[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__);

(statearr_32208[(1)] = (1));

return statearr_32208;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1 = (function (state_32177){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32177);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32209){var ex__13886__auto__ = e32209;
var statearr_32210_32232 = state_32177;
(statearr_32210_32232[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32177[(4)]))){
var statearr_32211_32233 = state_32177;
(statearr_32211_32233[(1)] = cljs.core.first((state_32177[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32234 = state_32177;
state_32177 = G__32234;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__ = function(state_32177){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1.call(this,state_32177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32212 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32212[(6)] = c__13957__auto__);

return statearr_32212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__32236 = arguments.length;
switch (G__32236) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__32239 = arguments.length;
switch (G__32239) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32528){
var state_val_32529 = (state_32528[(1)]);
if((state_val_32529 === (65))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32413 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_32414 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_32413,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,3,inst_32413,null));
var inst_32415 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32414,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32414,null));
var inst_32416 = (inst_32415.cljs$core$IFn$_invoke$arity$1 ? inst_32415.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32415.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32416)){
var statearr_32530_32689 = state_32528__$1;
(statearr_32530_32689[(1)] = (66));

} else {
var statearr_32531_32690 = state_32528__$1;
(statearr_32531_32690[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (70))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32532_32691 = state_32528__$1;
(statearr_32532_32691[(2)] = inst_32378);

(statearr_32532_32691[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (62))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32533_32692 = state_32528__$1;
(statearr_32533_32692[(2)] = inst_32378);

(statearr_32533_32692[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (74))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32534_32693 = state_32528__$1;
(statearr_32534_32693[(2)] = inst_32378);

(statearr_32534_32693[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (7))){
var inst_32523 = (state_32528[(2)]);
var _ = (function (){var statearr_32535 = state_32528;
(statearr_32535[(4)] = cljs.core.rest((state_32528[(4)])));

return statearr_32535;
})();
var state_32528__$1 = state_32528;
var statearr_32536_32694 = state_32528__$1;
(statearr_32536_32694[(2)] = inst_32523);

(statearr_32536_32694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (59))){
var inst_32479 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32537_32695 = state_32528__$1;
(statearr_32537_32695[(2)] = inst_32479);

(statearr_32537_32695[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (86))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32538_32696 = state_32528__$1;
(statearr_32538_32696[(2)] = inst_32378);

(statearr_32538_32696[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (20))){
var inst_32279 = (state_32528[(10)]);
var inst_32304 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32305 = inst_32304 === true;
var inst_32306 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32307 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32306);
var inst_32308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_32307);
var inst_32309 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32310 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32309);
var inst_32311 = inst_32310 === true;
var inst_32312 = ((inst_32305) && (inst_32308) && (inst_32311));
var state_32528__$1 = state_32528;
var statearr_32539_32697 = state_32528__$1;
(statearr_32539_32697[(2)] = inst_32312);

(statearr_32539_32697[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (72))){
var inst_32431 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32540_32698 = state_32528__$1;
(statearr_32540_32698[(2)] = inst_32431);

(statearr_32540_32698[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (58))){
var state_32528__$1 = state_32528;
var statearr_32541_32699 = state_32528__$1;
(statearr_32541_32699[(2)] = null);

(statearr_32541_32699[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (60))){
var inst_32476 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32542_32700 = state_32528__$1;
(statearr_32542_32700[(2)] = inst_32476);

(statearr_32542_32700[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (27))){
var inst_32299 = (state_32528[(11)]);
var state_32528__$1 = state_32528;
var statearr_32543_32701 = state_32528__$1;
(statearr_32543_32701[(2)] = inst_32299);

(statearr_32543_32701[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (1))){
var state_32528__$1 = state_32528;
var statearr_32544_32702 = state_32528__$1;
(statearr_32544_32702[(2)] = null);

(statearr_32544_32702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (69))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32423 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_32424 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_32423,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,3,inst_32423,null));
var inst_32425 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32424,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32424,null));
var inst_32426 = (inst_32425.cljs$core$IFn$_invoke$arity$1 ? inst_32425.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32425.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32426)){
var statearr_32545_32703 = state_32528__$1;
(statearr_32545_32703[(1)] = (70));

} else {
var statearr_32546_32704 = state_32528__$1;
(statearr_32546_32704[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (101))){
var inst_32515 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32547_32705 = state_32528__$1;
(statearr_32547_32705[(2)] = inst_32515);

(statearr_32547_32705[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (24))){
var inst_32299 = (state_32528[(11)]);
var state_32528__$1 = state_32528;
var statearr_32548_32706 = state_32528__$1;
(statearr_32548_32706[(2)] = inst_32299);

(statearr_32548_32706[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (55))){
var state_32528__$1 = state_32528;
var statearr_32549_32707 = state_32528__$1;
(statearr_32549_32707[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (85))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32463 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_32464 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_32463,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,2,inst_32463,null));
var inst_32465 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32464,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32464,null));
var inst_32466 = (inst_32465.cljs$core$IFn$_invoke$arity$1 ? inst_32465.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32465.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32466)){
var statearr_32551_32708 = state_32528__$1;
(statearr_32551_32708[(1)] = (86));

} else {
var statearr_32552_32709 = state_32528__$1;
(statearr_32552_32709[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (39))){
var state_32528__$1 = state_32528;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32553_32710 = state_32528__$1;
(statearr_32553_32710[(1)] = (42));

} else {
var statearr_32554_32711 = state_32528__$1;
(statearr_32554_32711[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (88))){
var inst_32471 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32555_32712 = state_32528__$1;
(statearr_32555_32712[(2)] = inst_32471);

(statearr_32555_32712[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (46))){
var inst_32379 = (state_32528[(12)]);
var state_32528__$1 = state_32528;
var statearr_32556_32713 = state_32528__$1;
(statearr_32556_32713[(2)] = inst_32379);

(statearr_32556_32713[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (4))){
var inst_32240 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32557_32714 = state_32528__$1;
(statearr_32557_32714[(2)] = inst_32240);

(statearr_32557_32714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (77))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32443 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_32444 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_32443,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,5,inst_32443,null));
var inst_32445 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32444,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32444,null));
var inst_32446 = (inst_32445.cljs$core$IFn$_invoke$arity$1 ? inst_32445.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32445.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32446)){
var statearr_32558_32715 = state_32528__$1;
(statearr_32558_32715[(1)] = (78));

} else {
var statearr_32559_32716 = state_32528__$1;
(statearr_32559_32716[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (95))){
var inst_32502 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32560_32717 = state_32528__$1;
(statearr_32560_32717[(2)] = inst_32502);

(statearr_32560_32717[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (54))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32400 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32561_32718 = state_32528__$1;
(statearr_32561_32718[(2)] = inst_32400);

(statearr_32561_32718[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (92))){
var inst_32505 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32505)){
var statearr_32562_32719 = state_32528__$1;
(statearr_32562_32719[(1)] = (96));

} else {
var statearr_32563_32720 = state_32528__$1;
(statearr_32563_32720[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (15))){
var inst_32267 = (state_32528[(13)]);
var state_32528__$1 = state_32528;
var statearr_32564_32721 = state_32528__$1;
(statearr_32564_32721[(2)] = inst_32267);

(statearr_32564_32721[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (48))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32279 = (state_32528[(10)]);
var inst_32388 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32389 = cljs.core.__destructure_map(inst_32388);
var inst_32390__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32389,cljs.core.cst$kw$old);
var inst_32391__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32389,cljs.core.cst$kw$new);
var inst_32392 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32391__$1,inst_32390__$1);
var state_32528__$1 = (function (){var statearr_32565 = state_32528;
(statearr_32565[(7)] = inst_32391__$1);

(statearr_32565[(8)] = inst_32390__$1);

return statearr_32565;
})();
if(inst_32392){
var statearr_32566_32722 = state_32528__$1;
(statearr_32566_32722[(1)] = (51));

} else {
var statearr_32567_32723 = state_32528__$1;
(statearr_32567_32723[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (50))){
var inst_32279 = (state_32528[(10)]);
var inst_32486 = (state_32528[(2)]);
var inst_32487 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32488 = inst_32487 === true;
var state_32528__$1 = (function (){var statearr_32568 = state_32528;
(statearr_32568[(14)] = inst_32486);

return statearr_32568;
})();
if(cljs.core.truth_(inst_32488)){
var statearr_32569_32724 = state_32528__$1;
(statearr_32569_32724[(1)] = (90));

} else {
var statearr_32570_32725 = state_32528__$1;
(statearr_32570_32725[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (75))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32439 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32571_32726 = state_32528__$1;
(statearr_32571_32726[(2)] = inst_32439);

(statearr_32571_32726[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (99))){
var inst_32508 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32509 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32510 = cljs.core.PersistentHashMap.fromArrays(inst_32508,inst_32509);
var inst_32511 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_32510);
var inst_32512 = (function(){throw inst_32511})();
var state_32528__$1 = state_32528;
var statearr_32572_32727 = state_32528__$1;
(statearr_32572_32727[(2)] = inst_32512);

(statearr_32572_32727[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (21))){
var inst_32302 = (state_32528[(15)]);
var state_32528__$1 = state_32528;
var statearr_32573_32728 = state_32528__$1;
(statearr_32573_32728[(2)] = inst_32302);

(statearr_32573_32728[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (31))){
var inst_32342 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32342)){
var statearr_32574_32729 = state_32528__$1;
(statearr_32574_32729[(1)] = (32));

} else {
var statearr_32575_32730 = state_32528__$1;
(statearr_32575_32730[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (32))){
var inst_32331 = (state_32528[(16)]);
var inst_32344 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_32331,"a component","a non-component",throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32576_32731 = state_32528__$1;
(statearr_32576_32731[(2)] = inst_32344);

(statearr_32576_32731[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (40))){
var inst_32347 = (state_32528[(17)]);
var state_32528__$1 = state_32528;
var statearr_32577_32732 = state_32528__$1;
(statearr_32577_32732[(2)] = inst_32347);

(statearr_32577_32732[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (91))){
var state_32528__$1 = state_32528;
var statearr_32578_32733 = state_32528__$1;
(statearr_32578_32733[(2)] = false);

(statearr_32578_32733[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (56))){
var inst_32481 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32579_32734 = state_32528__$1;
(statearr_32579_32734[(2)] = inst_32481);

(statearr_32579_32734[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (33))){
var inst_32331 = (state_32528[(16)]);
var state_32528__$1 = state_32528;
var statearr_32580_32735 = state_32528__$1;
(statearr_32580_32735[(2)] = inst_32331);

(statearr_32580_32735[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (13))){
var inst_32294 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32294)){
var statearr_32581_32736 = state_32528__$1;
(statearr_32581_32736[(1)] = (14));

} else {
var statearr_32582_32737 = state_32528__$1;
(statearr_32582_32737[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (22))){
var inst_32315 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32583_32738 = state_32528__$1;
(statearr_32583_32738[(2)] = inst_32315);

(statearr_32583_32738[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (90))){
var inst_32490 = (state_32528[(18)]);
var inst_32279 = (state_32528[(10)]);
var inst_32490__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32584 = state_32528;
(statearr_32584[(18)] = inst_32490__$1);

return statearr_32584;
})();
if(cljs.core.truth_(inst_32490__$1)){
var statearr_32585_32739 = state_32528__$1;
(statearr_32585_32739[(1)] = (93));

} else {
var statearr_32586_32740 = state_32528__$1;
(statearr_32586_32740[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (36))){
var inst_32348 = (state_32528[(19)]);
var state_32528__$1 = state_32528;
var statearr_32587_32741 = state_32528__$1;
(statearr_32587_32741[(2)] = inst_32348);

(statearr_32587_32741[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (41))){
var inst_32379 = (state_32528[(12)]);
var inst_32279 = (state_32528[(10)]);
var inst_32378 = (state_32528[(2)]);
var inst_32379__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32588 = state_32528;
(statearr_32588[(9)] = inst_32378);

(statearr_32588[(12)] = inst_32379__$1);

return statearr_32588;
})();
if(cljs.core.truth_(inst_32379__$1)){
var statearr_32589_32742 = state_32528__$1;
(statearr_32589_32742[(1)] = (45));

} else {
var statearr_32590_32743 = state_32528__$1;
(statearr_32590_32743[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (89))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32473 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32591_32744 = state_32528__$1;
(statearr_32591_32744[(2)] = inst_32473);

(statearr_32591_32744[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (100))){
var inst_32486 = (state_32528[(14)]);
var state_32528__$1 = state_32528;
var statearr_32592_32745 = state_32528__$1;
(statearr_32592_32745[(2)] = inst_32486);

(statearr_32592_32745[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (43))){
var inst_32347 = (state_32528[(17)]);
var state_32528__$1 = state_32528;
var statearr_32593_32746 = state_32528__$1;
(statearr_32593_32746[(2)] = inst_32347);

(statearr_32593_32746[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (61))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32403 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_32404 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_32403,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,2,inst_32403,null));
var inst_32405 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32404,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32404,null));
var inst_32406 = (inst_32405.cljs$core$IFn$_invoke$arity$1 ? inst_32405.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32405.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32406)){
var statearr_32594_32747 = state_32528__$1;
(statearr_32594_32747[(1)] = (62));

} else {
var statearr_32595_32748 = state_32528__$1;
(statearr_32595_32748[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (29))){
var inst_32279 = (state_32528[(10)]);
var inst_32334 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32335 = cljs.core.not(inst_32334);
var inst_32336 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32337 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32336);
var inst_32338 = inst_32337 === true;
var inst_32339 = ((inst_32335) && (inst_32338));
var state_32528__$1 = state_32528;
var statearr_32596_32749 = state_32528__$1;
(statearr_32596_32749[(2)] = inst_32339);

(statearr_32596_32749[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (44))){
var inst_32375 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32597_32750 = state_32528__$1;
(statearr_32597_32750[(2)] = inst_32375);

(statearr_32597_32750[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (93))){
var inst_32279 = (state_32528[(10)]);
var inst_32492 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32493 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32492);
var inst_32494 = inst_32493 === true;
var inst_32495 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32496 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32495);
var inst_32497 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_32496);
var inst_32498 = (!(inst_32497));
var inst_32499 = ((inst_32494) && (inst_32498));
var state_32528__$1 = state_32528;
var statearr_32598_32751 = state_32528__$1;
(statearr_32598_32751[(2)] = inst_32499);

(statearr_32598_32751[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (6))){
var inst_32266 = (state_32528[(20)]);
var inst_32278 = (state_32528[(21)]);
var inst_32275 = cljs.core.seq(inst_32266);
var inst_32276 = cljs.core.first(inst_32275);
var inst_32277 = cljs.core.next(inst_32275);
var inst_32278__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32276,(0),null);
var inst_32279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32276,(1),null);
var inst_32280 = cljs.core.not(inst_32278__$1);
var state_32528__$1 = (function (){var statearr_32599 = state_32528;
(statearr_32599[(22)] = inst_32277);

(statearr_32599[(21)] = inst_32278__$1);

(statearr_32599[(10)] = inst_32279);

return statearr_32599;
})();
if(inst_32280){
var statearr_32600_32752 = state_32528__$1;
(statearr_32600_32752[(1)] = (8));

} else {
var statearr_32601_32753 = state_32528__$1;
(statearr_32601_32753[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (28))){
var inst_32328 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32602_32754 = state_32528__$1;
(statearr_32602_32754[(2)] = inst_32328);

(statearr_32602_32754[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (64))){
var inst_32411 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32603_32755 = state_32528__$1;
(statearr_32603_32755[(2)] = inst_32411);

(statearr_32603_32755[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (51))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32604_32756 = state_32528__$1;
(statearr_32604_32756[(2)] = inst_32378);

(statearr_32604_32756[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (25))){
var inst_32332 = (state_32528[(23)]);
var inst_32279 = (state_32528[(10)]);
var inst_32331 = (state_32528[(2)]);
var inst_32332__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32605 = state_32528;
(statearr_32605[(16)] = inst_32331);

(statearr_32605[(23)] = inst_32332__$1);

return statearr_32605;
})();
if(cljs.core.truth_(inst_32332__$1)){
var statearr_32606_32757 = state_32528__$1;
(statearr_32606_32757[(1)] = (29));

} else {
var statearr_32607_32758 = state_32528__$1;
(statearr_32607_32758[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (34))){
var inst_32348 = (state_32528[(19)]);
var inst_32279 = (state_32528[(10)]);
var inst_32347 = (state_32528[(2)]);
var inst_32348__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32608 = state_32528;
(statearr_32608[(17)] = inst_32347);

(statearr_32608[(19)] = inst_32348__$1);

return statearr_32608;
})();
if(cljs.core.truth_(inst_32348__$1)){
var statearr_32609_32759 = state_32528__$1;
(statearr_32609_32759[(1)] = (35));

} else {
var statearr_32610_32760 = state_32528__$1;
(statearr_32610_32760[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (17))){
var inst_32302 = (state_32528[(15)]);
var inst_32279 = (state_32528[(10)]);
var inst_32302__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32611 = state_32528;
(statearr_32611[(15)] = inst_32302__$1);

return statearr_32611;
})();
if(cljs.core.truth_(inst_32302__$1)){
var statearr_32612_32761 = state_32528__$1;
(statearr_32612_32761[(1)] = (20));

} else {
var statearr_32613_32762 = state_32528__$1;
(statearr_32613_32762[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (3))){
var inst_32526 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32528__$1,inst_32526);
} else {
if((state_val_32529 === (12))){
var inst_32283 = (state_32528[(24)]);
var state_32528__$1 = state_32528;
var statearr_32614_32763 = state_32528__$1;
(statearr_32614_32763[(2)] = inst_32283);

(statearr_32614_32763[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (2))){
var _ = (function (){var statearr_32615 = state_32528;
(statearr_32615[(4)] = cljs.core.cons((5),(state_32528[(4)])));

return statearr_32615;
})();
var inst_32259 = pred_changes;
var inst_32260 = cljs.core.seq(inst_32259);
var inst_32261 = cljs.core.first(inst_32260);
var inst_32262 = cljs.core.next(inst_32260);
var inst_32263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261,(0),null);
var inst_32264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261,(1),null);
var inst_32265 = db;
var inst_32266 = inst_32259;
var inst_32267 = inst_32265;
var state_32528__$1 = (function (){var statearr_32616 = state_32528;
(statearr_32616[(25)] = inst_32262);

(statearr_32616[(20)] = inst_32266);

(statearr_32616[(26)] = inst_32263);

(statearr_32616[(13)] = inst_32267);

(statearr_32616[(27)] = inst_32264);

return statearr_32616;
})();
var statearr_32617_32764 = state_32528__$1;
(statearr_32617_32764[(2)] = null);

(statearr_32617_32764[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (66))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32618_32765 = state_32528__$1;
(statearr_32618_32765[(2)] = inst_32378);

(statearr_32618_32765[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (23))){
var state_32528__$1 = state_32528;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32619_32766 = state_32528__$1;
(statearr_32619_32766[(1)] = (26));

} else {
var statearr_32620_32767 = state_32528__$1;
(statearr_32620_32767[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (47))){
var inst_32385 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32385)){
var statearr_32621_32768 = state_32528__$1;
(statearr_32621_32768[(1)] = (48));

} else {
var statearr_32622_32769 = state_32528__$1;
(statearr_32622_32769[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (35))){
var inst_32267 = (state_32528[(13)]);
var inst_32278 = (state_32528[(21)]);
var inst_32279 = (state_32528[(10)]);
var inst_32350 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32351 = cljs.core.not(inst_32350);
var inst_32352 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32353 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32352);
var inst_32354 = inst_32353 === true;
var inst_32355 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_32267,inst_32278);
var state_32528__$1 = (function (){var statearr_32623 = state_32528;
(statearr_32623[(28)] = inst_32351);

(statearr_32623[(29)] = inst_32354);

return statearr_32623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32528__$1,(38),inst_32355);
} else {
if((state_val_32529 === (82))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32624_32770 = state_32528__$1;
(statearr_32624_32770[(2)] = inst_32378);

(statearr_32624_32770[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (76))){
var inst_32441 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32625_32771 = state_32528__$1;
(statearr_32625_32771[(2)] = inst_32441);

(statearr_32625_32771[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (97))){
var inst_32486 = (state_32528[(14)]);
var state_32528__$1 = state_32528;
var statearr_32626_32772 = state_32528__$1;
(statearr_32626_32772[(2)] = inst_32486);

(statearr_32626_32772[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (19))){
var inst_32318 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32318)){
var statearr_32627_32773 = state_32528__$1;
(statearr_32627_32773[(1)] = (23));

} else {
var statearr_32628_32774 = state_32528__$1;
(statearr_32628_32774[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (57))){
var inst_32391 = (state_32528[(7)]);
var state_32528__$1 = state_32528;
var G__32629_32775 = inst_32391;
var G__32629_32776__$1 = (((G__32629_32775 instanceof cljs.core.Keyword))?G__32629_32775.fqn:null);
switch (G__32629_32776__$1) {
case "long":
var statearr_32630_32778 = state_32528__$1;
(statearr_32630_32778[(1)] = (61));


break;
case "bigint":
var statearr_32631_32779 = state_32528__$1;
(statearr_32631_32779[(1)] = (65));


break;
case "double":
var statearr_32632_32780 = state_32528__$1;
(statearr_32632_32780[(1)] = (69));


break;
case "float":
var statearr_32633_32781 = state_32528__$1;
(statearr_32633_32781[(1)] = (73));


break;
case "bigdec":
var statearr_32634_32782 = state_32528__$1;
(statearr_32634_32782[(1)] = (77));


break;
case "string":
var statearr_32635_32783 = state_32528__$1;
(statearr_32635_32783[(1)] = (81));


break;
case "instant":
var statearr_32636_32784 = state_32528__$1;
(statearr_32636_32784[(1)] = (85));


break;
default:
var statearr_32637_32785 = state_32528__$1;
(statearr_32637_32785[(1)] = (89));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (68))){
var inst_32421 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32638_32786 = state_32528__$1;
(statearr_32638_32786[(2)] = inst_32421);

(statearr_32638_32786[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (11))){
var inst_32279 = (state_32528[(10)]);
var inst_32285 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32286 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32285);
var inst_32287 = inst_32286 === false;
var inst_32288 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32289 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_32288);
var inst_32290 = inst_32289 === true;
var inst_32291 = ((inst_32287) && (inst_32290));
var state_32528__$1 = state_32528;
var statearr_32640_32787 = state_32528__$1;
(statearr_32640_32787[(2)] = inst_32291);

(statearr_32640_32787[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (9))){
var inst_32283 = (state_32528[(24)]);
var inst_32279 = (state_32528[(10)]);
var inst_32283__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32641 = state_32528;
(statearr_32641[(24)] = inst_32283__$1);

return statearr_32641;
})();
if(cljs.core.truth_(inst_32283__$1)){
var statearr_32642_32788 = state_32528__$1;
(statearr_32642_32788[(1)] = (11));

} else {
var statearr_32643_32789 = state_32528__$1;
(statearr_32643_32789[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (5))){
var _ = (function (){var statearr_32644 = state_32528;
(statearr_32644[(4)] = cljs.core.rest((state_32528[(4)])));

return statearr_32644;
})();
var state_32528__$1 = state_32528;
var ex32639 = (state_32528__$1[(2)]);
var statearr_32645_32790 = state_32528__$1;
(statearr_32645_32790[(5)] = ex32639);


if((ex32639 instanceof Error)){
var statearr_32646_32791 = state_32528__$1;
(statearr_32646_32791[(1)] = (4));

(statearr_32646_32791[(5)] = null);

} else {
throw ex32639;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (83))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32459 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32647_32792 = state_32528__$1;
(statearr_32647_32792[(2)] = inst_32459);

(statearr_32647_32792[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (14))){
var inst_32267 = (state_32528[(13)]);
var inst_32296 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_32267,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32648_32793 = state_32528__$1;
(statearr_32648_32793[(2)] = inst_32296);

(statearr_32648_32793[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (45))){
var inst_32279 = (state_32528[(10)]);
var inst_32381 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_32279);
var inst_32382 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_32381);
var state_32528__$1 = state_32528;
var statearr_32649_32794 = state_32528__$1;
(statearr_32649_32794[(2)] = inst_32382);

(statearr_32649_32794[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (53))){
var inst_32483 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32650_32795 = state_32528__$1;
(statearr_32650_32795[(2)] = inst_32483);

(statearr_32650_32795[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (78))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32651_32796 = state_32528__$1;
(statearr_32651_32796[(2)] = inst_32378);

(statearr_32651_32796[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (26))){
var inst_32321 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32322 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32323 = cljs.core.PersistentHashMap.fromArrays(inst_32321,inst_32322);
var inst_32324 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_32323);
var inst_32325 = (function(){throw inst_32324})();
var state_32528__$1 = state_32528;
var statearr_32652_32797 = state_32528__$1;
(statearr_32652_32797[(2)] = inst_32325);

(statearr_32652_32797[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (16))){
var inst_32300 = (state_32528[(30)]);
var inst_32279 = (state_32528[(10)]);
var inst_32299 = (state_32528[(2)]);
var inst_32300__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_32279);
var state_32528__$1 = (function (){var statearr_32653 = state_32528;
(statearr_32653[(30)] = inst_32300__$1);

(statearr_32653[(11)] = inst_32299);

return statearr_32653;
})();
if(cljs.core.truth_(inst_32300__$1)){
var statearr_32654_32798 = state_32528__$1;
(statearr_32654_32798[(1)] = (17));

} else {
var statearr_32655_32799 = state_32528__$1;
(statearr_32655_32799[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (81))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32453 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_32454 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_32453,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,5,inst_32453,null));
var inst_32455 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32454,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32454,null));
var inst_32456 = (inst_32455.cljs$core$IFn$_invoke$arity$1 ? inst_32455.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32455.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32456)){
var statearr_32656_32800 = state_32528__$1;
(statearr_32656_32800[(1)] = (82));

} else {
var statearr_32657_32801 = state_32528__$1;
(statearr_32657_32801[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (79))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32449 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32658_32802 = state_32528__$1;
(statearr_32658_32802[(2)] = inst_32449);

(statearr_32658_32802[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (38))){
var inst_32351 = (state_32528[(28)]);
var inst_32354 = (state_32528[(29)]);
var inst_32357 = (state_32528[(2)]);
var inst_32358 = fluree.db.util.async.throw_err(inst_32357);
var inst_32359 = cljs.core.not(inst_32358);
var inst_32360 = ((inst_32351) && (inst_32354) && (inst_32359));
var state_32528__$1 = state_32528;
var statearr_32659_32803 = state_32528__$1;
(statearr_32659_32803[(2)] = inst_32360);

(statearr_32659_32803[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (98))){
var inst_32277 = (state_32528[(22)]);
var inst_32518 = (state_32528[(2)]);
var inst_32266 = inst_32277;
var inst_32267 = inst_32518;
var state_32528__$1 = (function (){var statearr_32660 = state_32528;
(statearr_32660[(20)] = inst_32266);

(statearr_32660[(13)] = inst_32267);

return statearr_32660;
})();
var statearr_32661_32804 = state_32528__$1;
(statearr_32661_32804[(2)] = null);

(statearr_32661_32804[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (87))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32469 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32662_32805 = state_32528__$1;
(statearr_32662_32805[(2)] = inst_32469);

(statearr_32662_32805[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (30))){
var inst_32332 = (state_32528[(23)]);
var state_32528__$1 = state_32528;
var statearr_32663_32806 = state_32528__$1;
(statearr_32663_32806[(2)] = inst_32332);

(statearr_32663_32806[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (73))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32433 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_32434 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_32433,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,3,inst_32433,null));
var inst_32435 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32434,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32434,null));
var inst_32436 = (inst_32435.cljs$core$IFn$_invoke$arity$1 ? inst_32435.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32435.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32436)){
var statearr_32664_32807 = state_32528__$1;
(statearr_32664_32807[(1)] = (74));

} else {
var statearr_32665_32808 = state_32528__$1;
(statearr_32665_32808[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (96))){
var state_32528__$1 = state_32528;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32666_32809 = state_32528__$1;
(statearr_32666_32809[(1)] = (99));

} else {
var statearr_32667_32810 = state_32528__$1;
(statearr_32667_32810[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (10))){
var inst_32521 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32668_32811 = state_32528__$1;
(statearr_32668_32811[(2)] = inst_32521);

(statearr_32668_32811[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (18))){
var inst_32300 = (state_32528[(30)]);
var state_32528__$1 = state_32528;
var statearr_32669_32812 = state_32528__$1;
(statearr_32669_32812[(2)] = inst_32300);

(statearr_32669_32812[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (52))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32395 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_32396 = (inst_32391.cljs$core$IFn$_invoke$arity$5 ? inst_32391.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_32395,null) : inst_32391.call(null,cljs.core.PersistentArrayMap,null,3,inst_32395,null));
var inst_32397 = (inst_32391.cljs$core$IFn$_invoke$arity$4 ? inst_32391.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32396,null) : inst_32391.call(null,cljs.core.PersistentHashSet,null,inst_32396,null));
var inst_32398 = (inst_32397.cljs$core$IFn$_invoke$arity$1 ? inst_32397.cljs$core$IFn$_invoke$arity$1(inst_32390) : inst_32397.call(null,inst_32390));
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32398)){
var statearr_32670_32813 = state_32528__$1;
(statearr_32670_32813[(1)] = (54));

} else {
var statearr_32671_32814 = state_32528__$1;
(statearr_32671_32814[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (67))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32419 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32672_32815 = state_32528__$1;
(statearr_32672_32815[(2)] = inst_32419);

(statearr_32672_32815[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (71))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32429 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32673_32816 = state_32528__$1;
(statearr_32673_32816[(2)] = inst_32429);

(statearr_32673_32816[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (42))){
var inst_32267 = (state_32528[(13)]);
var inst_32278 = (state_32528[(21)]);
var inst_32366 = fluree.db.dbproto._p_prop(inst_32267,cljs.core.cst$kw$name,inst_32278);
var inst_32367 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32366)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_32368 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32369 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32370 = cljs.core.PersistentHashMap.fromArrays(inst_32368,inst_32369);
var inst_32371 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32367,inst_32370);
var inst_32372 = (function(){throw inst_32371})();
var state_32528__$1 = state_32528;
var statearr_32674_32817 = state_32528__$1;
(statearr_32674_32817[(2)] = inst_32372);

(statearr_32674_32817[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (80))){
var inst_32451 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32675_32818 = state_32528__$1;
(statearr_32675_32818[(2)] = inst_32451);

(statearr_32675_32818[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (37))){
var inst_32363 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
if(cljs.core.truth_(inst_32363)){
var statearr_32676_32819 = state_32528__$1;
(statearr_32676_32819[(1)] = (39));

} else {
var statearr_32677_32820 = state_32528__$1;
(statearr_32677_32820[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (63))){
var inst_32391 = (state_32528[(7)]);
var inst_32390 = (state_32528[(8)]);
var inst_32409 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_32390,inst_32391,throw_QMARK_);
var state_32528__$1 = state_32528;
var statearr_32678_32821 = state_32528__$1;
(statearr_32678_32821[(2)] = inst_32409);

(statearr_32678_32821[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (94))){
var inst_32490 = (state_32528[(18)]);
var state_32528__$1 = state_32528;
var statearr_32679_32822 = state_32528__$1;
(statearr_32679_32822[(2)] = inst_32490);

(statearr_32679_32822[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (8))){
var inst_32267 = (state_32528[(13)]);
var state_32528__$1 = state_32528;
var statearr_32680_32823 = state_32528__$1;
(statearr_32680_32823[(2)] = inst_32267);

(statearr_32680_32823[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (49))){
var inst_32378 = (state_32528[(9)]);
var state_32528__$1 = state_32528;
var statearr_32681_32824 = state_32528__$1;
(statearr_32681_32824[(2)] = inst_32378);

(statearr_32681_32824[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32529 === (84))){
var inst_32461 = (state_32528[(2)]);
var state_32528__$1 = state_32528;
var statearr_32682_32825 = state_32528__$1;
(statearr_32682_32825[(2)] = inst_32461);

(statearr_32682_32825[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__13883__auto__ = null;
var fluree$db$query$schema$state_machine__13883__auto____0 = (function (){
var statearr_32683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32683[(0)] = fluree$db$query$schema$state_machine__13883__auto__);

(statearr_32683[(1)] = (1));

return statearr_32683;
});
var fluree$db$query$schema$state_machine__13883__auto____1 = (function (state_32528){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32528);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32684){var ex__13886__auto__ = e32684;
var statearr_32685_32826 = state_32528;
(statearr_32685_32826[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32528[(4)]))){
var statearr_32686_32827 = state_32528;
(statearr_32686_32827[(1)] = cljs.core.first((state_32528[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32828 = state_32528;
state_32528 = G__32828;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__13883__auto__ = function(state_32528){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__13883__auto____1.call(this,state_32528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__13883__auto____0;
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__13883__auto____1;
return fluree$db$query$schema$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32687 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32687[(6)] = c__13957__auto__);

return statearr_32687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32852){
var state_val_32853 = (state_32852[(1)]);
if((state_val_32853 === (7))){
var state_32852__$1 = state_32852;
var statearr_32854_32873 = state_32852__$1;
(statearr_32854_32873[(2)] = db);

(statearr_32854_32873[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (1))){
var state_32852__$1 = state_32852;
var statearr_32855_32874 = state_32852__$1;
(statearr_32855_32874[(2)] = null);

(statearr_32855_32874[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (4))){
var inst_32829 = (state_32852[(2)]);
var state_32852__$1 = state_32852;
var statearr_32856_32875 = state_32852__$1;
(statearr_32856_32875[(2)] = inst_32829);

(statearr_32856_32875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (6))){
var inst_32838 = (state_32852[(7)]);
var inst_32837 = (state_32852[(2)]);
var inst_32838__$1 = fluree.db.util.async.throw_err(inst_32837);
var inst_32839 = cljs.core.empty_QMARK_(inst_32838__$1);
var state_32852__$1 = (function (){var statearr_32857 = state_32852;
(statearr_32857[(7)] = inst_32838__$1);

return statearr_32857;
})();
if(inst_32839){
var statearr_32858_32876 = state_32852__$1;
(statearr_32858_32876[(1)] = (7));

} else {
var statearr_32859_32877 = state_32852__$1;
(statearr_32859_32877[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (3))){
var inst_32850 = (state_32852[(2)]);
var state_32852__$1 = state_32852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32852__$1,inst_32850);
} else {
if((state_val_32853 === (2))){
var _ = (function (){var statearr_32861 = state_32852;
(statearr_32861[(4)] = cljs.core.cons((5),(state_32852[(4)])));

return statearr_32861;
})();
var inst_32835 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_32852__$1 = state_32852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32852__$1,(6),inst_32835);
} else {
if((state_val_32853 === (9))){
var inst_32847 = (state_32852[(2)]);
var _ = (function (){var statearr_32862 = state_32852;
(statearr_32862[(4)] = cljs.core.rest((state_32852[(4)])));

return statearr_32862;
})();
var state_32852__$1 = state_32852;
var statearr_32863_32878 = state_32852__$1;
(statearr_32863_32878[(2)] = inst_32847);

(statearr_32863_32878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (5))){
var _ = (function (){var statearr_32864 = state_32852;
(statearr_32864[(4)] = cljs.core.rest((state_32852[(4)])));

return statearr_32864;
})();
var state_32852__$1 = state_32852;
var ex32860 = (state_32852__$1[(2)]);
var statearr_32865_32879 = state_32852__$1;
(statearr_32865_32879[(5)] = ex32860);


if((ex32860 instanceof Error)){
var statearr_32866_32880 = state_32852__$1;
(statearr_32866_32880[(1)] = (4));

(statearr_32866_32880[(5)] = null);

} else {
throw ex32860;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (10))){
var inst_32844 = (state_32852[(2)]);
var inst_32845 = fluree.db.util.async.throw_err(inst_32844);
var state_32852__$1 = state_32852;
var statearr_32867_32881 = state_32852__$1;
(statearr_32867_32881[(2)] = inst_32845);

(statearr_32867_32881[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32853 === (8))){
var inst_32838 = (state_32852[(7)]);
var inst_32842 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_32838,db,true);
var state_32852__$1 = state_32852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32852__$1,(10),inst_32842);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____0 = (function (){
var statearr_32868 = [null,null,null,null,null,null,null,null];
(statearr_32868[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__);

(statearr_32868[(1)] = (1));

return statearr_32868;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____1 = (function (state_32852){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32852);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32869){var ex__13886__auto__ = e32869;
var statearr_32870_32882 = state_32852;
(statearr_32870_32882[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32852[(4)]))){
var statearr_32871_32883 = state_32852;
(statearr_32871_32883[(1)] = cljs.core.first((state_32852[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32884 = state_32852;
state_32852 = G__32884;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__ = function(state_32852){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____1.call(this,state_32852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32872 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32872[(6)] = c__13957__auto__);

return statearr_32872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__32886 = arguments.length;
switch (G__32886) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__32888 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32888,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32888,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32888,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4149__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4149__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__32891_SHARP_,p2__32892_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32891_SHARP_,p2__32892_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32958){
var state_val_32959 = (state_32958[(1)]);
if((state_val_32959 === (1))){
var state_32958__$1 = state_32958;
var statearr_32960_32978 = state_32958__$1;
(statearr_32960_32978[(2)] = null);

(statearr_32960_32978[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32959 === (2))){
var _ = (function (){var statearr_32961 = state_32958;
(statearr_32961[(4)] = cljs.core.cons((5),(state_32958[(4)])));

return statearr_32961;
})();
var inst_32910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32911 = fluree.db.flake.max_subject_id((1));
var inst_32912 = [inst_32911];
var inst_32913 = (new cljs.core.PersistentVector(null,1,(5),inst_32910,inst_32912,null));
var inst_32914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32915 = [(0)];
var inst_32916 = (new cljs.core.PersistentVector(null,1,(5),inst_32914,inst_32915,null));
var inst_32917 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32913,cljs.core._LT__EQ_,inst_32916);
var state_32958__$1 = state_32958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32958__$1,(6),inst_32917);
} else {
if((state_val_32959 === (3))){
var inst_32956 = (state_32958[(2)]);
var state_32958__$1 = state_32958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32958__$1,inst_32956);
} else {
if((state_val_32959 === (4))){
var inst_32898 = (state_32958[(2)]);
var state_32958__$1 = state_32958;
var statearr_32963_32979 = state_32958__$1;
(statearr_32963_32979[(2)] = inst_32898);

(statearr_32963_32979[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32959 === (5))){
var _ = (function (){var statearr_32964 = state_32958;
(statearr_32964[(4)] = cljs.core.rest((state_32958[(4)])));

return statearr_32964;
})();
var state_32958__$1 = state_32958;
var ex32962 = (state_32958__$1[(2)]);
var statearr_32965_32980 = state_32958__$1;
(statearr_32965_32980[(5)] = ex32962);


if((ex32962 instanceof Error)){
var statearr_32966_32981 = state_32958__$1;
(statearr_32966_32981[(1)] = (4));

(statearr_32966_32981[(5)] = null);

} else {
throw ex32962;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32959 === (6))){
var inst_32919 = (state_32958[(2)]);
var inst_32920 = fluree.db.util.async.throw_err(inst_32919);
var inst_32921 = (function (){var schema_flakes = inst_32920;
return (function (p1__32893_SHARP_){
return (p1__32893_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_32922 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32921,inst_32920);
var inst_32923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32922,(0),null);
var inst_32924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32922,(1),null);
var inst_32925 = (function (){var schema_flakes = inst_32920;
var vec__32904 = inst_32922;
var collection_flakes = inst_32923;
var predicate_flakes = inst_32924;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32895_SHARP_,p2__32896_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32895_SHARP_,p2__32896_SHARP_.p,p2__32896_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_32926 = [(-1),"_tx"];
var inst_32927 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_32928 = ["_tx",(-1),(-1)];
var inst_32929 = cljs.core.PersistentHashMap.fromArrays(inst_32927,inst_32928);
var inst_32930 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_32931 = ["_tx",(-1),(-1)];
var inst_32932 = cljs.core.PersistentHashMap.fromArrays(inst_32930,inst_32931);
var inst_32933 = [inst_32929,inst_32932];
var inst_32934 = cljs.core.PersistentHashMap.fromArrays(inst_32926,inst_32933);
var inst_32935 = (function (){var schema_flakes = inst_32920;
var vec__32904 = inst_32922;
var collection_flakes = inst_32923;
var predicate_flakes = inst_32924;
return (function (p1__32894_SHARP_){
return p1__32894_SHARP_.s;
});
})();
var inst_32936 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32935,inst_32923);
var inst_32937 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32925,inst_32934,inst_32936);
var inst_32939 = (function (){var schema_flakes = inst_32920;
var vec__32904 = inst_32922;
var collection_flakes = inst_32923;
var predicate_flakes = inst_32924;
var coll = inst_32937;
return (function (p__32938,pred_flakes){
var vec__32967 = p__32938;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32967,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32967,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__32970 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__32970.cljs$core$IFn$_invoke$arity$1 ? fexpr__32970.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__32970.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4160__auto__ = ref_QMARK_;
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_32940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32941 = cljs.core.PersistentHashMap.EMPTY;
var inst_32942 = cljs.core.PersistentHashSet.EMPTY;
var inst_32943 = [inst_32941,inst_32942];
var inst_32944 = (new cljs.core.PersistentVector(null,2,(5),inst_32940,inst_32943,null));
var inst_32945 = (function (){var schema_flakes = inst_32920;
var vec__32904 = inst_32922;
var collection_flakes = inst_32923;
var predicate_flakes = inst_32924;
var coll = inst_32937;
return (function (p1__32897_SHARP_){
return p1__32897_SHARP_.s;
});
})();
var inst_32946 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32945,inst_32924);
var inst_32947 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32939,inst_32944,inst_32946);
var inst_32948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32947,(0),null);
var inst_32949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32947,(1),null);
var inst_32950 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_32951 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32952 = [inst_32951,inst_32937,inst_32948,inst_32949];
var inst_32953 = cljs.core.PersistentHashMap.fromArrays(inst_32950,inst_32952);
var _ = (function (){var statearr_32971 = state_32958;
(statearr_32971[(4)] = cljs.core.rest((state_32958[(4)])));

return statearr_32971;
})();
var state_32958__$1 = state_32958;
var statearr_32972_32982 = state_32958__$1;
(statearr_32972_32982[(2)] = inst_32953);

(statearr_32972_32982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0 = (function (){
var statearr_32973 = [null,null,null,null,null,null,null];
(statearr_32973[(0)] = fluree$db$query$schema$schema_map_$_state_machine__13883__auto__);

(statearr_32973[(1)] = (1));

return statearr_32973;
});
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1 = (function (state_32958){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32958);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32974){var ex__13886__auto__ = e32974;
var statearr_32975_32983 = state_32958;
(statearr_32975_32983[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32958[(4)]))){
var statearr_32976_32984 = state_32958;
(statearr_32976_32984[(1)] = cljs.core.first((state_32958[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32985 = state_32958;
state_32958 = G__32985;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__ = function(state_32958){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1.call(this,state_32958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32977 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32977[(6)] = c__13957__auto__);

return statearr_32977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33027){
var state_val_33028 = (state_33027[(1)]);
if((state_val_33028 === (7))){
var inst_33010 = (state_33027[(2)]);
var inst_33011 = fluree.db.query.schema.flake__GT_pred_map(inst_33010);
var inst_33012 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_33013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(114));
var inst_33014 = cljs.core.boolean$(inst_33013);
var inst_33015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(110));
var inst_33016 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(117));
var inst_33017 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_33016);
var inst_33018 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(111));
var inst_33019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(115));
var inst_33020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33011,(112));
var inst_33021 = [inst_33014,inst_33015,inst_33017,inst_33018,inst_33019,inst_33020];
var inst_33022 = cljs.core.PersistentHashMap.fromArrays(inst_33012,inst_33021);
var _ = (function (){var statearr_33029 = state_33027;
(statearr_33029[(4)] = cljs.core.rest((state_33027[(4)])));

return statearr_33029;
})();
var state_33027__$1 = state_33027;
var statearr_33030_33053 = state_33027__$1;
(statearr_33030_33053[(2)] = inst_33022);

(statearr_33030_33053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (1))){
var state_33027__$1 = state_33027;
var statearr_33031_33054 = state_33027__$1;
(statearr_33031_33054[(2)] = null);

(statearr_33031_33054[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (4))){
var inst_32986 = (state_33027[(2)]);
var state_33027__$1 = state_33027;
var statearr_33032_33055 = state_33027__$1;
(statearr_33032_33055[(2)] = inst_32986);

(statearr_33032_33055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (6))){
var _ = (function (){var statearr_33033 = state_33027;
(statearr_33033[(4)] = cljs.core.cons((9),(state_33027[(4)])));

return statearr_33033;
})();
var inst_32998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33000 = ["_setting/id","root"];
var inst_33001 = (new cljs.core.PersistentVector(null,2,(5),inst_32999,inst_33000,null));
var inst_33002 = [inst_33001];
var inst_33003 = (new cljs.core.PersistentVector(null,1,(5),inst_32998,inst_33002,null));
var inst_33004 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33003);
var state_33027__$1 = state_33027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33027__$1,(10),inst_33004);
} else {
if((state_val_33028 === (3))){
var inst_33025 = (state_33027[(2)]);
var state_33027__$1 = state_33027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33027__$1,inst_33025);
} else {
if((state_val_33028 === (2))){
var _ = (function (){var statearr_33036 = state_33027;
(statearr_33036[(4)] = cljs.core.cons((5),(state_33027[(4)])));

return statearr_33036;
})();
var state_33027__$1 = state_33027;
var statearr_33037_33056 = state_33027__$1;
(statearr_33037_33056[(2)] = null);

(statearr_33037_33056[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (9))){
var _ = (function (){var statearr_33038 = state_33027;
(statearr_33038[(4)] = cljs.core.rest((state_33027[(4)])));

return statearr_33038;
})();
var state_33027__$1 = state_33027;
var ex33034 = (state_33027__$1[(2)]);
var statearr_33039_33057 = state_33027__$1;
(statearr_33039_33057[(5)] = ex33034);


var statearr_33040_33058 = state_33027__$1;
(statearr_33040_33058[(1)] = (8));

(statearr_33040_33058[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (5))){
var _ = (function (){var statearr_33041 = state_33027;
(statearr_33041[(4)] = cljs.core.rest((state_33027[(4)])));

return statearr_33041;
})();
var state_33027__$1 = state_33027;
var ex33035 = (state_33027__$1[(2)]);
var statearr_33042_33059 = state_33027__$1;
(statearr_33042_33059[(5)] = ex33035);


if((ex33035 instanceof Error)){
var statearr_33043_33060 = state_33027__$1;
(statearr_33043_33060[(1)] = (4));

(statearr_33043_33060[(5)] = null);

} else {
throw ex33035;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (10))){
var inst_33006 = (state_33027[(2)]);
var inst_33007 = fluree.db.util.async.throw_err(inst_33006);
var _ = (function (){var statearr_33044 = state_33027;
(statearr_33044[(4)] = cljs.core.rest((state_33027[(4)])));

return statearr_33044;
})();
var state_33027__$1 = state_33027;
var statearr_33045_33061 = state_33027__$1;
(statearr_33045_33061[(2)] = inst_33007);

(statearr_33045_33061[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33028 === (8))){
var inst_32992 = (state_33027[(2)]);
var state_33027__$1 = (function (){var statearr_33046 = state_33027;
(statearr_33046[(7)] = inst_32992);

return statearr_33046;
})();
var statearr_33047_33062 = state_33027__$1;
(statearr_33047_33062[(2)] = null);

(statearr_33047_33062[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0 = (function (){
var statearr_33048 = [null,null,null,null,null,null,null,null];
(statearr_33048[(0)] = fluree$db$query$schema$setting_map_$_state_machine__13883__auto__);

(statearr_33048[(1)] = (1));

return statearr_33048;
});
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1 = (function (state_33027){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33027);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33049){var ex__13886__auto__ = e33049;
var statearr_33050_33063 = state_33027;
(statearr_33050_33063[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33027[(4)]))){
var statearr_33051_33064 = state_33027;
(statearr_33051_33064[(1)] = cljs.core.first((state_33027[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__33065 = state_33027;
state_33027 = G__33065;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__ = function(state_33027){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1.call(this,state_33027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33052 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33052[(6)] = c__13957__auto__);

return statearr_33052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
