// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4160__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__27126 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27126,(5),null);
var G__27129 = idx;
var G__27129__$1 = (((G__27129 instanceof cljs.core.Keyword))?G__27129.fqn:null);
switch (G__27129__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27129__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__27131 = idx;
var G__27131__$1 = (((G__27131 instanceof cljs.core.Keyword))?G__27131.fqn:null);
switch (G__27131__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27131__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__27133 = idx;
var G__27133__$1 = (((G__27133 instanceof cljs.core.Keyword))?G__27133.fqn:null);
switch (G__27133__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27133__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__27136 = arguments.length;
switch (G__27136) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__27137 = (function (){var pred__27140 = cljs.core.identical_QMARK_;
var expr__27141 = test;
if(cljs.core.truth_((pred__27140.cljs$core$IFn$_invoke$arity$2 ? pred__27140.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__27141) : pred__27140.call(null,cljs.core._EQ_,expr__27141)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27140.cljs$core$IFn$_invoke$arity$2 ? pred__27140.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__27141) : pred__27140.call(null,cljs.core._LT_,expr__27141)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__27140.cljs$core$IFn$_invoke$arity$2 ? pred__27140.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__27141) : pred__27140.call(null,cljs.core._LT__EQ_,expr__27141)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27140.cljs$core$IFn$_invoke$arity$2 ? pred__27140.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__27141) : pred__27140.call(null,cljs.core._GT_,expr__27141)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__27140.cljs$core$IFn$_invoke$arity$2 ? pred__27140.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__27141) : pred__27140.call(null,cljs.core._GT__EQ_,expr__27141)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__27141)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27137,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27137,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27137,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27137,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_27374){
var state_val_27375 = (state_27374[(1)]);
if((state_val_27375 === (65))){
var inst_27295 = (state_27374[(7)]);
var inst_27348 = (state_27374[(8)]);
var inst_27348__$1 = (state_27374[(2)]);
var inst_27349 = cljs.core.count(inst_27348__$1);
var state_27374__$1 = (function (){var statearr_27376 = state_27374;
(statearr_27376[(8)] = inst_27348__$1);

(statearr_27376[(9)] = inst_27349);

return statearr_27376;
})();
if(cljs.core.truth_(inst_27295)){
var statearr_27377_27505 = state_27374__$1;
(statearr_27377_27505[(1)] = (78));

} else {
var statearr_27378_27506 = state_27374__$1;
(statearr_27378_27506[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (70))){
var inst_27344 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27379_27507 = state_27374__$1;
(statearr_27379_27507[(2)] = inst_27344);

(statearr_27379_27507[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (62))){
var inst_27265 = (state_27374[(10)]);
var inst_27279 = (state_27374[(11)]);
var inst_27294 = (state_27374[(2)]);
var inst_27295 = fluree.db.dbproto._rhs(inst_27279);
var state_27374__$1 = (function (){var statearr_27380 = state_27374;
(statearr_27380[(7)] = inst_27295);

(statearr_27380[(12)] = inst_27294);

return statearr_27380;
})();
if(cljs.core.truth_(inst_27265)){
var statearr_27381_27508 = state_27374__$1;
(statearr_27381_27508[(1)] = (63));

} else {
var statearr_27382_27509 = state_27374__$1;
(statearr_27382_27509[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (74))){
var inst_27332 = (state_27374[(2)]);
var inst_27333 = fluree.db.util.async.throw_err(inst_27332);
var state_27374__$1 = state_27374;
if(cljs.core.truth_(inst_27333)){
var statearr_27383_27510 = state_27374__$1;
(statearr_27383_27510[(1)] = (75));

} else {
var statearr_27384_27511 = state_27374__$1;
(statearr_27384_27511[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (7))){
var inst_27156 = (state_27374[(13)]);
var state_27374__$1 = state_27374;
var statearr_27385_27512 = state_27374__$1;
(statearr_27385_27512[(2)] = inst_27156);

(statearr_27385_27512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (59))){
var inst_27241 = (state_27374[(14)]);
var inst_27286 = (state_27374[(15)]);
var inst_27242 = (state_27374[(16)]);
var inst_27285 = (state_27374[(2)]);
var inst_27286__$1 = fluree.db.util.async.throw_err(inst_27285);
var inst_27287 = fluree.db.flake.subrange(inst_27286__$1,start_test,inst_27241,end_test,inst_27242);
var inst_27288 = fluree.db.query.range.value_with_nil_pred(idx,inst_27241,inst_27242);
var state_27374__$1 = (function (){var statearr_27386 = state_27374;
(statearr_27386[(17)] = inst_27287);

(statearr_27386[(15)] = inst_27286__$1);

return statearr_27386;
})();
if(inst_27288){
var statearr_27387_27513 = state_27374__$1;
(statearr_27387_27513[(1)] = (60));

} else {
var statearr_27388_27514 = state_27374__$1;
(statearr_27388_27514[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (20))){
var inst_27157 = (state_27374[(18)]);
var inst_27204 = (state_27374[(2)]);
var inst_27205 = (inst_27157 == null);
var state_27374__$1 = (function (){var statearr_27389 = state_27374;
(statearr_27389[(19)] = inst_27204);

return statearr_27389;
})();
if(cljs.core.truth_(inst_27205)){
var statearr_27390_27515 = state_27374__$1;
(statearr_27390_27515[(1)] = (22));

} else {
var statearr_27391_27516 = state_27374__$1;
(statearr_27391_27516[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (72))){
var inst_27313 = (state_27374[(20)]);
var state_27374__$1 = state_27374;
var statearr_27392_27517 = state_27374__$1;
(statearr_27392_27517[(2)] = inst_27313);

(statearr_27392_27517[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (58))){
var inst_27369 = (state_27374[(2)]);
var _ = (function (){var statearr_27393 = state_27374;
(statearr_27393[(4)] = cljs.core.rest((state_27374[(4)])));

return statearr_27393;
})();
var state_27374__$1 = state_27374;
var statearr_27394_27518 = state_27374__$1;
(statearr_27394_27518[(2)] = inst_27369);

(statearr_27394_27518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (60))){
var inst_27265 = (state_27374[(10)]);
var inst_27167 = (state_27374[(21)]);
var inst_27213 = (state_27374[(22)]);
var inst_27195 = (state_27374[(23)]);
var inst_27274 = (state_27374[(24)]);
var inst_27160 = (state_27374[(25)]);
var inst_27259 = (state_27374[(26)]);
var inst_27155 = (state_27374[(27)]);
var inst_27252 = (state_27374[(28)]);
var inst_27231 = (state_27374[(29)]);
var inst_27258 = (state_27374[(30)]);
var inst_27162 = (state_27374[(31)]);
var inst_27269 = (state_27374[(32)]);
var inst_27241 = (state_27374[(14)]);
var inst_27222 = (state_27374[(33)]);
var inst_27281 = (state_27374[(34)]);
var inst_27287 = (state_27374[(17)]);
var inst_27166 = (state_27374[(35)]);
var inst_27248 = (state_27374[(36)]);
var inst_27159 = (state_27374[(37)]);
var inst_27286 = (state_27374[(15)]);
var inst_27177 = (state_27374[(38)]);
var inst_27242 = (state_27374[(16)]);
var inst_27204 = (state_27374[(19)]);
var inst_27240 = (state_27374[(39)]);
var inst_27186 = (state_27374[(40)]);
var inst_27279 = (state_27374[(11)]);
var inst_27247 = (state_27374[(41)]);
var inst_27280 = (state_27374[(42)]);
var inst_27290 = (function (){var no_filter_QMARK_ = inst_27265;
var next_node = inst_27279;
var flakes = inst_27286;
var s1 = inst_27177;
var o2 = inst_27204;
var t1 = inst_27159;
var i = inst_27280;
var m1 = inst_27231;
var root_node = inst_27274;
var to_t = inst_27259;
var s2 = inst_27186;
var p2 = inst_27222;
var permissions = inst_27248;
var vec__27152 = inst_27162;
var limit = inst_27247;
var start_flake = inst_27241;
var acc = inst_27281;
var t2 = inst_27166;
var op1 = inst_27160;
var o1 = inst_27195;
var end_flake = inst_27242;
var base_result = inst_27287;
var p1 = inst_27213;
var idx_compare = inst_27252;
var op2 = inst_27167;
var from_t = inst_27258;
var m2 = inst_27240;
var vec__27149 = inst_27155;
var novelty = inst_27269;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_27291 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27290,inst_27287,inst_27287);
var state_27374__$1 = state_27374;
var statearr_27395_27519 = state_27374__$1;
(statearr_27395_27519[(2)] = inst_27291);

(statearr_27395_27519[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (27))){
var inst_27164 = (state_27374[(43)]);
var inst_27213 = (state_27374[(2)]);
var inst_27214 = (inst_27164 == null);
var state_27374__$1 = (function (){var statearr_27396 = state_27374;
(statearr_27396[(22)] = inst_27213);

return statearr_27396;
})();
if(cljs.core.truth_(inst_27214)){
var statearr_27397_27520 = state_27374__$1;
(statearr_27397_27520[(1)] = (28));

} else {
var statearr_27398_27521 = state_27374__$1;
(statearr_27398_27521[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (1))){
var state_27374__$1 = state_27374;
var statearr_27399_27522 = state_27374__$1;
(statearr_27399_27522[(2)] = null);

(statearr_27399_27522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (69))){
var inst_27312 = (state_27374[(44)]);
var inst_27327 = (inst_27312 + (1));
var inst_27328 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_27374__$1 = (function (){var statearr_27400 = state_27374;
(statearr_27400[(45)] = inst_27327);

return statearr_27400;
})();
if(cljs.core.truth_(inst_27328)){
var statearr_27401_27523 = state_27374__$1;
(statearr_27401_27523[(1)] = (71));

} else {
var statearr_27402_27524 = state_27374__$1;
(statearr_27402_27524[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (24))){
var inst_27209 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
if(cljs.core.truth_(inst_27209)){
var statearr_27403_27525 = state_27374__$1;
(statearr_27403_27525[(1)] = (25));

} else {
var statearr_27404_27526 = state_27374__$1;
(statearr_27404_27526[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (55))){
var inst_27274 = (state_27374[(24)]);
var inst_27241 = (state_27374[(14)]);
var inst_27273 = (state_27374[(2)]);
var inst_27274__$1 = fluree.db.util.async.throw_err(inst_27273);
var inst_27275 = fluree.db.dbproto._lookup_leaf(inst_27274__$1,inst_27241);
var state_27374__$1 = (function (){var statearr_27405 = state_27374;
(statearr_27405[(24)] = inst_27274__$1);

return statearr_27405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(56),inst_27275);
} else {
if((state_val_27375 === (39))){
var inst_27229 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27406_27527 = state_27374__$1;
(statearr_27406_27527[(2)] = inst_27229);

(statearr_27406_27527[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (46))){
var inst_27243 = (state_27374[(46)]);
var state_27374__$1 = state_27374;
var statearr_27407_27528 = state_27374__$1;
(statearr_27407_27528[(2)] = inst_27243);

(statearr_27407_27528[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (4))){
var inst_27143 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27408_27529 = state_27374__$1;
(statearr_27408_27529[(2)] = inst_27143);

(statearr_27408_27529[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (77))){
var inst_27338 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27409_27530 = state_27374__$1;
(statearr_27409_27530[(2)] = inst_27338);

(statearr_27409_27530[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (54))){
var inst_27265 = (state_27374[(2)]);
var inst_27266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27267 = [cljs.core.cst$kw$novelty,idx];
var inst_27268 = (new cljs.core.PersistentVector(null,2,(5),inst_27266,inst_27267,null));
var inst_27269 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27268);
var inst_27270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_27271 = fluree.db.dbproto._resolve(inst_27270);
var state_27374__$1 = (function (){var statearr_27410 = state_27374;
(statearr_27410[(10)] = inst_27265);

(statearr_27410[(32)] = inst_27269);

return statearr_27410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(55),inst_27271);
} else {
if((state_val_27375 === (15))){
var inst_27158 = (state_27374[(47)]);
var state_27374__$1 = state_27374;
var statearr_27411_27531 = state_27374__$1;
(statearr_27411_27531[(2)] = inst_27158);

(statearr_27411_27531[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (48))){
var inst_27253 = (state_27374[(48)]);
var inst_27247 = (state_27374[(2)]);
var inst_27248 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_27249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27250 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_27251 = (new cljs.core.PersistentVector(null,3,(5),inst_27249,inst_27250,null));
var inst_27252 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27251);
var inst_27253__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_27374__$1 = (function (){var statearr_27412 = state_27374;
(statearr_27412[(48)] = inst_27253__$1);

(statearr_27412[(28)] = inst_27252);

(statearr_27412[(36)] = inst_27248);

(statearr_27412[(41)] = inst_27247);

return statearr_27412;
})();
if(cljs.core.truth_(inst_27253__$1)){
var statearr_27413_27532 = state_27374__$1;
(statearr_27413_27532[(1)] = (49));

} else {
var statearr_27414_27533 = state_27374__$1;
(statearr_27414_27533[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (50))){
var inst_27256 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_27374__$1 = state_27374;
var statearr_27415_27534 = state_27374__$1;
(statearr_27415_27534[(2)] = inst_27256);

(statearr_27415_27534[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (75))){
var inst_27313 = (state_27374[(20)]);
var state_27374__$1 = state_27374;
var statearr_27416_27535 = state_27374__$1;
(statearr_27416_27535[(2)] = inst_27313);

(statearr_27416_27535[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (21))){
var inst_27200 = (state_27374[(2)]);
var inst_27201 = fluree.db.util.async.throw_err(inst_27200);
var state_27374__$1 = state_27374;
var statearr_27417_27536 = state_27374__$1;
(statearr_27417_27536[(2)] = inst_27201);

(statearr_27417_27536[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (31))){
var state_27374__$1 = state_27374;
var statearr_27418_27537 = state_27374__$1;
(statearr_27418_27537[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_27418_27537[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (32))){
var inst_27164 = (state_27374[(43)]);
var state_27374__$1 = state_27374;
var statearr_27419_27538 = state_27374__$1;
(statearr_27419_27538[(2)] = inst_27164);

(statearr_27419_27538[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (40))){
var inst_27168 = (state_27374[(49)]);
var state_27374__$1 = state_27374;
var statearr_27420_27539 = state_27374__$1;
(statearr_27420_27539[(2)] = inst_27168);

(statearr_27420_27539[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (56))){
var inst_27277 = (state_27374[(2)]);
var inst_27278 = fluree.db.util.async.throw_err(inst_27277);
var inst_27279 = inst_27278;
var inst_27280 = (0);
var inst_27281 = null;
var state_27374__$1 = (function (){var statearr_27421 = state_27374;
(statearr_27421[(34)] = inst_27281);

(statearr_27421[(11)] = inst_27279);

(statearr_27421[(42)] = inst_27280);

return statearr_27421;
})();
var statearr_27422_27540 = state_27374__$1;
(statearr_27422_27540[(2)] = null);

(statearr_27422_27540[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (33))){
var inst_27161 = (state_27374[(50)]);
var inst_27222 = (state_27374[(2)]);
var state_27374__$1 = (function (){var statearr_27423 = state_27374;
(statearr_27423[(33)] = inst_27222);

return statearr_27423;
})();
if(cljs.core.truth_(inst_27161)){
var statearr_27424_27541 = state_27374__$1;
(statearr_27424_27541[(1)] = (34));

} else {
var statearr_27425_27542 = state_27374__$1;
(statearr_27425_27542[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (13))){
var inst_27182 = (state_27374[(2)]);
var inst_27183 = fluree.db.util.async.throw_err(inst_27182);
var state_27374__$1 = state_27374;
var statearr_27426_27543 = state_27374__$1;
(statearr_27426_27543[(2)] = inst_27183);

(statearr_27426_27543[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (22))){
var inst_27195 = (state_27374[(23)]);
var state_27374__$1 = state_27374;
var statearr_27427_27544 = state_27374__$1;
(statearr_27427_27544[(2)] = inst_27195);

(statearr_27427_27544[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (36))){
var inst_27168 = (state_27374[(49)]);
var inst_27231 = (state_27374[(2)]);
var state_27374__$1 = (function (){var statearr_27428 = state_27374;
(statearr_27428[(29)] = inst_27231);

return statearr_27428;
})();
if(cljs.core.truth_(inst_27168)){
var statearr_27429_27545 = state_27374__$1;
(statearr_27429_27545[(1)] = (40));

} else {
var statearr_27430_27546 = state_27374__$1;
(statearr_27430_27546[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (41))){
var inst_27234 = (cljs.core._LT__EQ_ === end_test);
var state_27374__$1 = state_27374;
if(cljs.core.truth_(inst_27234)){
var statearr_27431_27547 = state_27374__$1;
(statearr_27431_27547[(1)] = (43));

} else {
var statearr_27432_27548 = state_27374__$1;
(statearr_27432_27548[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (43))){
var state_27374__$1 = state_27374;
var statearr_27433_27549 = state_27374__$1;
(statearr_27433_27549[(2)] = (2147483647));

(statearr_27433_27549[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (61))){
var inst_27287 = (state_27374[(17)]);
var state_27374__$1 = state_27374;
var statearr_27434_27550 = state_27374__$1;
(statearr_27434_27550[(2)] = inst_27287);

(statearr_27434_27550[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (29))){
var state_27374__$1 = state_27374;
var statearr_27435_27551 = state_27374__$1;
(statearr_27435_27551[(2)] = false);

(statearr_27435_27551[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (44))){
var state_27374__$1 = state_27374;
var statearr_27436_27552 = state_27374__$1;
(statearr_27436_27552[(2)] = fluree.db.util.core.min_integer);

(statearr_27436_27552[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (6))){
var inst_27156 = (state_27374[(13)]);
var inst_27171 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27156);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(9),inst_27171);
} else {
if((state_val_27375 === (28))){
var inst_27204 = (state_27374[(19)]);
var state_27374__$1 = state_27374;
var statearr_27437_27553 = state_27374__$1;
(statearr_27437_27553[(2)] = inst_27204);

(statearr_27437_27553[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (64))){
var inst_27294 = (state_27374[(12)]);
var inst_27280 = (state_27374[(42)]);
var inst_27308 = cljs.core.seq(inst_27294);
var inst_27309 = cljs.core.first(inst_27308);
var inst_27310 = cljs.core.next(inst_27308);
var inst_27311 = inst_27294;
var inst_27312 = inst_27280;
var inst_27313 = inst_27294;
var state_27374__$1 = (function (){var statearr_27438 = state_27374;
(statearr_27438[(51)] = inst_27311);

(statearr_27438[(44)] = inst_27312);

(statearr_27438[(20)] = inst_27313);

(statearr_27438[(52)] = inst_27309);

(statearr_27438[(53)] = inst_27310);

return statearr_27438;
})();
var statearr_27439_27554 = state_27374__$1;
(statearr_27439_27554[(2)] = null);

(statearr_27439_27554[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (51))){
var inst_27258 = (state_27374[(2)]);
var inst_27259 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_27260 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_27374__$1 = (function (){var statearr_27440 = state_27374;
(statearr_27440[(26)] = inst_27259);

(statearr_27440[(30)] = inst_27258);

return statearr_27440;
})();
if(cljs.core.truth_(inst_27260)){
var statearr_27441_27555 = state_27374__$1;
(statearr_27441_27555[(1)] = (52));

} else {
var statearr_27442_27556 = state_27374__$1;
(statearr_27442_27556[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (25))){
var state_27374__$1 = state_27374;
var statearr_27443_27557 = state_27374__$1;
(statearr_27443_27557[(2)] = (-1));

(statearr_27443_27557[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (34))){
var inst_27161 = (state_27374[(50)]);
var state_27374__$1 = state_27374;
var statearr_27444_27558 = state_27374__$1;
(statearr_27444_27558[(2)] = inst_27161);

(statearr_27444_27558[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (17))){
var inst_27191 = (state_27374[(2)]);
var inst_27192 = fluree.db.util.async.throw_err(inst_27191);
var state_27374__$1 = state_27374;
var statearr_27445_27559 = state_27374__$1;
(statearr_27445_27559[(2)] = inst_27192);

(statearr_27445_27559[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (3))){
var inst_27372 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27374__$1,inst_27372);
} else {
if((state_val_27375 === (12))){
var inst_27158 = (state_27374[(47)]);
var inst_27186 = (state_27374[(2)]);
var inst_27187 = fluree.db.util.core.pred_ident_QMARK_(inst_27158);
var state_27374__$1 = (function (){var statearr_27446 = state_27374;
(statearr_27446[(40)] = inst_27186);

return statearr_27446;
})();
if(inst_27187){
var statearr_27447_27560 = state_27374__$1;
(statearr_27447_27560[(1)] = (14));

} else {
var statearr_27448_27561 = state_27374__$1;
(statearr_27448_27561[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (2))){
var inst_27155 = (state_27374[(27)]);
var inst_27162 = (state_27374[(31)]);
var inst_27156 = (state_27374[(13)]);
var _ = (function (){var statearr_27449 = state_27374;
(statearr_27449[(4)] = cljs.core.cons((5),(state_27374[(4)])));

return statearr_27449;
})();
var inst_27155__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_27156__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(0),null);
var inst_27157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(1),null);
var inst_27158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(2),null);
var inst_27159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(3),null);
var inst_27160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(4),null);
var inst_27161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27155__$1,(5),null);
var inst_27162__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_27163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(0),null);
var inst_27164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(1),null);
var inst_27165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(2),null);
var inst_27166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(3),null);
var inst_27167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(4),null);
var inst_27168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27162__$1,(5),null);
var inst_27169 = fluree.db.util.core.pred_ident_QMARK_(inst_27156__$1);
var state_27374__$1 = (function (){var statearr_27450 = state_27374;
(statearr_27450[(43)] = inst_27164);

(statearr_27450[(21)] = inst_27167);

(statearr_27450[(25)] = inst_27160);

(statearr_27450[(27)] = inst_27155__$1);

(statearr_27450[(31)] = inst_27162__$1);

(statearr_27450[(54)] = inst_27163);

(statearr_27450[(49)] = inst_27168);

(statearr_27450[(47)] = inst_27158);

(statearr_27450[(35)] = inst_27166);

(statearr_27450[(50)] = inst_27161);

(statearr_27450[(55)] = inst_27165);

(statearr_27450[(37)] = inst_27159);

(statearr_27450[(18)] = inst_27157);

(statearr_27450[(13)] = inst_27156__$1);

return statearr_27450;
})();
if(inst_27169){
var statearr_27451_27562 = state_27374__$1;
(statearr_27451_27562[(1)] = (6));

} else {
var statearr_27452_27563 = state_27374__$1;
(statearr_27452_27563[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (66))){
var inst_27311 = (state_27374[(51)]);
var inst_27319 = (state_27374[(56)]);
var inst_27312 = (state_27374[(44)]);
var inst_27247 = (state_27374[(41)]);
var inst_27318 = cljs.core.seq(inst_27311);
var inst_27319__$1 = cljs.core.first(inst_27318);
var inst_27320 = cljs.core.next(inst_27318);
var inst_27321 = (inst_27319__$1 == null);
var inst_27322 = (inst_27312 > inst_27247);
var inst_27323 = ((inst_27321) || (inst_27322));
var state_27374__$1 = (function (){var statearr_27453 = state_27374;
(statearr_27453[(57)] = inst_27320);

(statearr_27453[(56)] = inst_27319__$1);

return statearr_27453;
})();
if(cljs.core.truth_(inst_27323)){
var statearr_27454_27564 = state_27374__$1;
(statearr_27454_27564[(1)] = (68));

} else {
var statearr_27455_27565 = state_27374__$1;
(statearr_27455_27565[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (23))){
var state_27374__$1 = state_27374;
var statearr_27456_27566 = state_27374__$1;
(statearr_27456_27566[(2)] = false);

(statearr_27456_27566[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (47))){
var state_27374__$1 = state_27374;
var statearr_27457_27567 = state_27374__$1;
(statearr_27457_27567[(2)] = fluree.db.util.core.max_long);

(statearr_27457_27567[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (35))){
var inst_27225 = (cljs.core._GT__EQ_ === start_test);
var state_27374__$1 = state_27374;
if(cljs.core.truth_(inst_27225)){
var statearr_27458_27568 = state_27374__$1;
(statearr_27458_27568[(1)] = (37));

} else {
var statearr_27459_27569 = state_27374__$1;
(statearr_27459_27569[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (82))){
var inst_27295 = (state_27374[(7)]);
var inst_27274 = (state_27374[(24)]);
var inst_27361 = fluree.db.dbproto._lookup_leaf(inst_27274,inst_27295);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(84),inst_27361);
} else {
if((state_val_27375 === (76))){
var inst_27319 = (state_27374[(56)]);
var inst_27313 = (state_27374[(20)]);
var inst_27336 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_27313,inst_27319);
var state_27374__$1 = state_27374;
var statearr_27460_27570 = state_27374__$1;
(statearr_27460_27570[(2)] = inst_27336);

(statearr_27460_27570[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (19))){
var inst_27165 = (state_27374[(55)]);
var state_27374__$1 = state_27374;
var statearr_27461_27571 = state_27374__$1;
(statearr_27461_27571[(2)] = inst_27165);

(statearr_27461_27571[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (57))){
var inst_27259 = (state_27374[(26)]);
var inst_27258 = (state_27374[(30)]);
var inst_27269 = (state_27374[(32)]);
var inst_27279 = (state_27374[(11)]);
var inst_27283 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_27279,inst_27258,inst_27259,inst_27269);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(59),inst_27283);
} else {
if((state_val_27375 === (68))){
var inst_27281 = (state_27374[(34)]);
var inst_27313 = (state_27374[(20)]);
var inst_27325 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27313,inst_27281);
var state_27374__$1 = state_27374;
var statearr_27462_27572 = state_27374__$1;
(statearr_27462_27572[(2)] = inst_27325);

(statearr_27462_27572[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (11))){
var inst_27163 = (state_27374[(54)]);
var state_27374__$1 = state_27374;
var statearr_27464_27573 = state_27374__$1;
(statearr_27464_27573[(2)] = inst_27163);

(statearr_27464_27573[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (9))){
var inst_27173 = (state_27374[(2)]);
var inst_27174 = fluree.db.util.async.throw_err(inst_27173);
var state_27374__$1 = state_27374;
var statearr_27465_27574 = state_27374__$1;
(statearr_27465_27574[(2)] = inst_27174);

(statearr_27465_27574[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (5))){
var _ = (function (){var statearr_27466 = state_27374;
(statearr_27466[(4)] = cljs.core.rest((state_27374[(4)])));

return statearr_27466;
})();
var state_27374__$1 = state_27374;
var ex27463 = (state_27374__$1[(2)]);
var statearr_27467_27575 = state_27374__$1;
(statearr_27467_27575[(5)] = ex27463);


if((ex27463 instanceof Error)){
var statearr_27468_27576 = state_27374__$1;
(statearr_27468_27576[(1)] = (4));

(statearr_27468_27576[(5)] = null);

} else {
throw ex27463;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (83))){
var inst_27367 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27469_27577 = state_27374__$1;
(statearr_27469_27577[(2)] = inst_27367);

(statearr_27469_27577[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (14))){
var inst_27158 = (state_27374[(47)]);
var inst_27189 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27158);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(17),inst_27189);
} else {
if((state_val_27375 === (45))){
var inst_27238 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27470_27578 = state_27374__$1;
(statearr_27470_27578[(2)] = inst_27238);

(statearr_27470_27578[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (53))){
var state_27374__$1 = state_27374;
var statearr_27471_27579 = state_27374__$1;
(statearr_27471_27579[(2)] = true);

(statearr_27471_27579[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (78))){
var inst_27295 = (state_27374[(7)]);
var inst_27252 = (state_27374[(28)]);
var inst_27349 = (state_27374[(9)]);
var inst_27242 = (state_27374[(16)]);
var inst_27247 = (state_27374[(41)]);
var inst_27351 = (inst_27252.cljs$core$IFn$_invoke$arity$2 ? inst_27252.cljs$core$IFn$_invoke$arity$2(inst_27295,inst_27242) : inst_27252.call(null,inst_27295,inst_27242));
var inst_27352 = (inst_27351 < (0));
var inst_27353 = (inst_27349 < inst_27247);
var inst_27354 = ((inst_27352) && (inst_27353));
var state_27374__$1 = state_27374;
var statearr_27472_27580 = state_27374__$1;
(statearr_27472_27580[(2)] = inst_27354);

(statearr_27472_27580[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (26))){
var inst_27157 = (state_27374[(18)]);
var state_27374__$1 = state_27374;
var statearr_27473_27581 = state_27374__$1;
(statearr_27473_27581[(2)] = inst_27157);

(statearr_27473_27581[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (16))){
var inst_27165 = (state_27374[(55)]);
var inst_27195 = (state_27374[(2)]);
var inst_27196 = fluree.db.util.core.pred_ident_QMARK_(inst_27165);
var state_27374__$1 = (function (){var statearr_27474 = state_27374;
(statearr_27474[(23)] = inst_27195);

return statearr_27474;
})();
if(inst_27196){
var statearr_27475_27582 = state_27374__$1;
(statearr_27475_27582[(1)] = (18));

} else {
var statearr_27476_27583 = state_27374__$1;
(statearr_27476_27583[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (81))){
var inst_27348 = (state_27374[(8)]);
var state_27374__$1 = state_27374;
var statearr_27477_27584 = state_27374__$1;
(statearr_27477_27584[(2)] = inst_27348);

(statearr_27477_27584[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (79))){
var inst_27295 = (state_27374[(7)]);
var state_27374__$1 = state_27374;
var statearr_27478_27585 = state_27374__$1;
(statearr_27478_27585[(2)] = inst_27295);

(statearr_27478_27585[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (38))){
var state_27374__$1 = state_27374;
var statearr_27479_27586 = state_27374__$1;
(statearr_27479_27586[(2)] = (2147483647));

(statearr_27479_27586[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (30))){
var inst_27218 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
if(cljs.core.truth_(inst_27218)){
var statearr_27480_27587 = state_27374__$1;
(statearr_27480_27587[(1)] = (31));

} else {
var statearr_27481_27588 = state_27374__$1;
(statearr_27481_27588[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (73))){
var inst_27320 = (state_27374[(57)]);
var inst_27327 = (state_27374[(45)]);
var inst_27341 = (state_27374[(2)]);
var inst_27311 = inst_27320;
var inst_27312 = inst_27327;
var inst_27313 = inst_27341;
var state_27374__$1 = (function (){var statearr_27482 = state_27374;
(statearr_27482[(51)] = inst_27311);

(statearr_27482[(44)] = inst_27312);

(statearr_27482[(20)] = inst_27313);

return statearr_27482;
})();
var statearr_27483_27589 = state_27374__$1;
(statearr_27483_27589[(2)] = null);

(statearr_27483_27589[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (10))){
var inst_27163 = (state_27374[(54)]);
var inst_27180 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27163);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(13),inst_27180);
} else {
if((state_val_27375 === (18))){
var inst_27165 = (state_27374[(55)]);
var inst_27198 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27165);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(21),inst_27198);
} else {
if((state_val_27375 === (52))){
var inst_27213 = (state_27374[(22)]);
var inst_27222 = (state_27374[(33)]);
var inst_27248 = (state_27374[(36)]);
var inst_27177 = (state_27374[(38)]);
var inst_27186 = (state_27374[(40)]);
var inst_27262 = fluree.db.permissions_validate.no_filter_QMARK_(inst_27248,inst_27177,inst_27186,inst_27213,inst_27222);
var state_27374__$1 = state_27374;
var statearr_27484_27590 = state_27374__$1;
(statearr_27484_27590[(2)] = inst_27262);

(statearr_27484_27590[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (67))){
var inst_27346 = (state_27374[(2)]);
var state_27374__$1 = state_27374;
var statearr_27485_27591 = state_27374__$1;
(statearr_27485_27591[(2)] = inst_27346);

(statearr_27485_27591[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (71))){
var inst_27319 = (state_27374[(56)]);
var inst_27330 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_27319);
var state_27374__$1 = state_27374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27374__$1,(74),inst_27330);
} else {
if((state_val_27375 === (42))){
var inst_27167 = (state_27374[(21)]);
var inst_27213 = (state_27374[(22)]);
var inst_27195 = (state_27374[(23)]);
var inst_27160 = (state_27374[(25)]);
var inst_27231 = (state_27374[(29)]);
var inst_27222 = (state_27374[(33)]);
var inst_27243 = (state_27374[(46)]);
var inst_27166 = (state_27374[(35)]);
var inst_27159 = (state_27374[(37)]);
var inst_27177 = (state_27374[(38)]);
var inst_27204 = (state_27374[(19)]);
var inst_27240 = (state_27374[(39)]);
var inst_27186 = (state_27374[(40)]);
var inst_27240__$1 = (state_27374[(2)]);
var inst_27241 = fluree.db.flake.__GT_Flake(inst_27177,inst_27213,inst_27195,inst_27159,inst_27160,inst_27231);
var inst_27242 = fluree.db.flake.__GT_Flake(inst_27186,inst_27222,inst_27204,inst_27166,inst_27167,inst_27240__$1);
var inst_27243__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_27374__$1 = (function (){var statearr_27486 = state_27374;
(statearr_27486[(14)] = inst_27241);

(statearr_27486[(46)] = inst_27243__$1);

(statearr_27486[(16)] = inst_27242);

(statearr_27486[(39)] = inst_27240__$1);

return statearr_27486;
})();
if(cljs.core.truth_(inst_27243__$1)){
var statearr_27487_27592 = state_27374__$1;
(statearr_27487_27592[(1)] = (46));

} else {
var statearr_27488_27593 = state_27374__$1;
(statearr_27488_27593[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (80))){
var inst_27357 = (state_27374[(2)]);
var inst_27358 = cljs.core.not(inst_27357);
var state_27374__$1 = state_27374;
if(inst_27358){
var statearr_27489_27594 = state_27374__$1;
(statearr_27489_27594[(1)] = (81));

} else {
var statearr_27490_27595 = state_27374__$1;
(statearr_27490_27595[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (37))){
var state_27374__$1 = state_27374;
var statearr_27491_27596 = state_27374__$1;
(statearr_27491_27596[(2)] = fluree.db.util.core.min_integer);

(statearr_27491_27596[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (63))){
var inst_27281 = (state_27374[(34)]);
var inst_27294 = (state_27374[(12)]);
var inst_27247 = (state_27374[(41)]);
var inst_27280 = (state_27374[(42)]);
var inst_27297 = (inst_27247 - inst_27280);
var inst_27298 = fluree.db.flake.take(inst_27297,inst_27294);
var inst_27299 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27298,inst_27281);
var state_27374__$1 = state_27374;
var statearr_27492_27597 = state_27374__$1;
(statearr_27492_27597[(2)] = inst_27299);

(statearr_27492_27597[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (8))){
var inst_27163 = (state_27374[(54)]);
var inst_27177 = (state_27374[(2)]);
var inst_27178 = fluree.db.util.core.pred_ident_QMARK_(inst_27163);
var state_27374__$1 = (function (){var statearr_27493 = state_27374;
(statearr_27493[(38)] = inst_27177);

return statearr_27493;
})();
if(inst_27178){
var statearr_27494_27598 = state_27374__$1;
(statearr_27494_27598[(1)] = (10));

} else {
var statearr_27495_27599 = state_27374__$1;
(statearr_27495_27599[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (49))){
var inst_27253 = (state_27374[(48)]);
var state_27374__$1 = state_27374;
var statearr_27496_27600 = state_27374__$1;
(statearr_27496_27600[(2)] = inst_27253);

(statearr_27496_27600[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27375 === (84))){
var inst_27348 = (state_27374[(8)]);
var inst_27349 = (state_27374[(9)]);
var inst_27363 = (state_27374[(2)]);
var inst_27364 = fluree.db.util.async.throw_err(inst_27363);
var inst_27279 = inst_27364;
var inst_27280 = inst_27349;
var inst_27281 = inst_27348;
var state_27374__$1 = (function (){var statearr_27497 = state_27374;
(statearr_27497[(34)] = inst_27281);

(statearr_27497[(11)] = inst_27279);

(statearr_27497[(42)] = inst_27280);

return statearr_27497;
})();
var statearr_27498_27601 = state_27374__$1;
(statearr_27498_27601[(2)] = null);

(statearr_27498_27601[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_27499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27499[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_27499[(1)] = (1));

return statearr_27499;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_27374){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_27374);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e27500){var ex__13886__auto__ = e27500;
var statearr_27501_27602 = state_27374;
(statearr_27501_27602[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_27374[(4)]))){
var statearr_27502_27603 = state_27374;
(statearr_27502_27603[(1)] = cljs.core.first((state_27374[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__27604 = state_27374;
state_27374 = G__27604;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_27374){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_27374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_27503 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_27503[(6)] = c__13957__auto__);

return statearr_27503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_27663){
var state_val_27664 = (state_27663[(1)]);
if((state_val_27664 === (7))){
var inst_27628 = (state_27663[(7)]);
var inst_27641 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_27628);
var state_27663__$1 = state_27663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27663__$1,(10),inst_27641);
} else {
if((state_val_27664 === (1))){
var inst_27612 = subject_groups;
var inst_27613 = cljs.core.seq(inst_27612);
var inst_27614 = cljs.core.first(inst_27613);
var inst_27615 = cljs.core.next(inst_27613);
var inst_27616 = flake_start;
var inst_27617 = subject_start;
var inst_27618 = cljs.core.PersistentVector.EMPTY;
var inst_27619 = inst_27612;
var inst_27620 = inst_27616;
var inst_27621 = inst_27617;
var inst_27622 = inst_27618;
var state_27663__$1 = (function (){var statearr_27665 = state_27663;
(statearr_27665[(8)] = inst_27622);

(statearr_27665[(9)] = inst_27619);

(statearr_27665[(10)] = inst_27620);

(statearr_27665[(11)] = inst_27621);

(statearr_27665[(12)] = inst_27615);

(statearr_27665[(13)] = inst_27614);

return statearr_27665;
})();
var statearr_27666_27688 = state_27663__$1;
(statearr_27666_27688[(2)] = null);

(statearr_27666_27688[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (4))){
var inst_27622 = (state_27663[(8)]);
var inst_27620 = (state_27663[(10)]);
var inst_27621 = (state_27663[(11)]);
var inst_27635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27636 = [inst_27620,inst_27621,inst_27622];
var inst_27637 = (new cljs.core.PersistentVector(null,3,(5),inst_27635,inst_27636,null));
var state_27663__$1 = state_27663;
var statearr_27667_27689 = state_27663__$1;
(statearr_27667_27689[(2)] = inst_27637);

(statearr_27667_27689[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (13))){
var inst_27622 = (state_27663[(8)]);
var inst_27648 = (state_27663[(14)]);
var inst_27620 = (state_27663[(10)]);
var inst_27621 = (state_27663[(11)]);
var inst_27647 = (state_27663[(15)]);
var inst_27629 = (state_27663[(16)]);
var inst_27653 = (state_27663[(2)]);
var inst_27654 = (inst_27620 + inst_27648);
var inst_27655 = (inst_27621 + inst_27653);
var inst_27656 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27622,inst_27647);
var inst_27619 = inst_27629;
var inst_27620__$1 = inst_27654;
var inst_27621__$1 = inst_27655;
var inst_27622__$1 = inst_27656;
var state_27663__$1 = (function (){var statearr_27668 = state_27663;
(statearr_27668[(8)] = inst_27622__$1);

(statearr_27668[(9)] = inst_27619);

(statearr_27668[(10)] = inst_27620__$1);

(statearr_27668[(11)] = inst_27621__$1);

return statearr_27668;
})();
var statearr_27669_27690 = state_27663__$1;
(statearr_27669_27690[(2)] = null);

(statearr_27669_27690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (6))){
var inst_27659 = (state_27663[(2)]);
var state_27663__$1 = state_27663;
var statearr_27670_27691 = state_27663__$1;
(statearr_27670_27691[(2)] = inst_27659);

(statearr_27670_27691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (3))){
var inst_27661 = (state_27663[(2)]);
var state_27663__$1 = state_27663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27663__$1,inst_27661);
} else {
if((state_val_27664 === (12))){
var state_27663__$1 = state_27663;
var statearr_27671_27692 = state_27663__$1;
(statearr_27671_27692[(2)] = (1));

(statearr_27671_27692[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (2))){
var inst_27628 = (state_27663[(7)]);
var inst_27619 = (state_27663[(9)]);
var inst_27620 = (state_27663[(10)]);
var inst_27621 = (state_27663[(11)]);
var inst_27627 = cljs.core.seq(inst_27619);
var inst_27628__$1 = cljs.core.first(inst_27627);
var inst_27629 = cljs.core.next(inst_27627);
var inst_27630 = (inst_27628__$1 == null);
var inst_27631 = (inst_27620 >= flake_limit);
var inst_27632 = (inst_27621 >= subject_limit);
var inst_27633 = ((inst_27630) || (inst_27631) || (inst_27632));
var state_27663__$1 = (function (){var statearr_27672 = state_27663;
(statearr_27672[(7)] = inst_27628__$1);

(statearr_27672[(16)] = inst_27629);

return statearr_27672;
})();
if(cljs.core.truth_(inst_27633)){
var statearr_27673_27693 = state_27663__$1;
(statearr_27673_27693[(1)] = (4));

} else {
var statearr_27674_27694 = state_27663__$1;
(statearr_27674_27694[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (11))){
var state_27663__$1 = state_27663;
var statearr_27675_27695 = state_27663__$1;
(statearr_27675_27695[(2)] = (0));

(statearr_27675_27695[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (9))){
var inst_27648 = (state_27663[(14)]);
var inst_27647 = (state_27663[(15)]);
var inst_27647__$1 = (state_27663[(2)]);
var inst_27648__$1 = cljs.core.count(inst_27647__$1);
var inst_27649 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_27648__$1);
var state_27663__$1 = (function (){var statearr_27676 = state_27663;
(statearr_27676[(14)] = inst_27648__$1);

(statearr_27676[(15)] = inst_27647__$1);

return statearr_27676;
})();
if(inst_27649){
var statearr_27677_27696 = state_27663__$1;
(statearr_27677_27696[(1)] = (11));

} else {
var statearr_27678_27697 = state_27663__$1;
(statearr_27678_27697[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (5))){
var inst_27639 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_27663__$1 = state_27663;
if(cljs.core.truth_(inst_27639)){
var statearr_27679_27698 = state_27663__$1;
(statearr_27679_27698[(1)] = (7));

} else {
var statearr_27680_27699 = state_27663__$1;
(statearr_27680_27699[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (10))){
var inst_27643 = (state_27663[(2)]);
var inst_27644 = fluree.db.util.async.throw_err(inst_27643);
var state_27663__$1 = state_27663;
var statearr_27681_27700 = state_27663__$1;
(statearr_27681_27700[(2)] = inst_27644);

(statearr_27681_27700[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27664 === (8))){
var inst_27628 = (state_27663[(7)]);
var state_27663__$1 = state_27663;
var statearr_27682_27701 = state_27663__$1;
(statearr_27682_27701[(2)] = inst_27628);

(statearr_27682_27701[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0 = (function (){
var statearr_27683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27683[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__);

(statearr_27683[(1)] = (1));

return statearr_27683;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1 = (function (state_27663){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_27663);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e27684){var ex__13886__auto__ = e27684;
var statearr_27685_27702 = state_27663;
(statearr_27685_27702[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_27663[(4)]))){
var statearr_27686_27703 = state_27663;
(statearr_27686_27703[(1)] = cljs.core.first((state_27663[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__27704 = state_27663;
state_27663 = G__27704;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__ = function(state_27663){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1.call(this,state_27663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_27687 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_27687[(6)] = c__13957__auto__);

return statearr_27687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_27750){
var state_val_27751 = (state_27750[(1)]);
if((state_val_27751 === (7))){
var state_27750__$1 = state_27750;
var statearr_27752_27790 = state_27750__$1;
(statearr_27752_27790[(2)] = null);

(statearr_27752_27790[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (20))){
var inst_27736 = (state_27750[(2)]);
var inst_27737 = fluree.db.util.async.throw_err(inst_27736);
var inst_27715 = inst_27737;
var state_27750__$1 = (function (){var statearr_27753 = state_27750;
(statearr_27753[(7)] = inst_27715);

return statearr_27753;
})();
var statearr_27754_27791 = state_27750__$1;
(statearr_27754_27791[(2)] = null);

(statearr_27754_27791[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (1))){
var state_27750__$1 = state_27750;
var statearr_27755_27792 = state_27750__$1;
(statearr_27755_27792[(2)] = null);

(statearr_27755_27792[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (4))){
var inst_27705 = (state_27750[(2)]);
var state_27750__$1 = state_27750;
var statearr_27756_27793 = state_27750__$1;
(statearr_27756_27793[(2)] = inst_27705);

(statearr_27756_27793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (15))){
var inst_27715 = (state_27750[(7)]);
var inst_27732 = (state_27750[(8)]);
var inst_27732__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_27715);
var state_27750__$1 = (function (){var statearr_27757 = state_27750;
(statearr_27757[(8)] = inst_27732__$1);

return statearr_27757;
})();
if(cljs.core.truth_(inst_27732__$1)){
var statearr_27758_27794 = state_27750__$1;
(statearr_27758_27794[(1)] = (17));

} else {
var statearr_27759_27795 = state_27750__$1;
(statearr_27759_27795[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (13))){
var inst_27725 = (state_27750[(2)]);
var inst_27726 = fluree.db.util.async.throw_err(inst_27725);
var _ = (function (){var statearr_27760 = state_27750;
(statearr_27760[(4)] = cljs.core.rest((state_27750[(4)])));

return statearr_27760;
})();
var state_27750__$1 = state_27750;
var statearr_27761_27796 = state_27750__$1;
(statearr_27761_27796[(2)] = inst_27726);

(statearr_27761_27796[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (6))){
var inst_27713 = (state_27750[(2)]);
var inst_27714 = fluree.db.util.async.throw_err(inst_27713);
var inst_27715 = inst_27714;
var state_27750__$1 = (function (){var statearr_27762 = state_27750;
(statearr_27762[(7)] = inst_27715);

return statearr_27762;
})();
var statearr_27763_27797 = state_27750__$1;
(statearr_27763_27797[(2)] = null);

(statearr_27763_27797[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (17))){
var inst_27732 = (state_27750[(8)]);
var inst_27734 = fluree.db.dbproto._lookup_leaf(root_node,inst_27732);
var state_27750__$1 = state_27750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27750__$1,(20),inst_27734);
} else {
if((state_val_27751 === (3))){
var inst_27748 = (state_27750[(2)]);
var state_27750__$1 = state_27750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27750__$1,inst_27748);
} else {
if((state_val_27751 === (12))){
var _ = (function (){var statearr_27765 = state_27750;
(statearr_27765[(4)] = cljs.core.rest((state_27750[(4)])));

return statearr_27765;
})();
var state_27750__$1 = state_27750;
var ex27764 = (state_27750__$1[(2)]);
var statearr_27766_27798 = state_27750__$1;
(statearr_27766_27798[(5)] = ex27764);


var statearr_27767_27799 = state_27750__$1;
(statearr_27767_27799[(1)] = (11));

(statearr_27767_27799[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (2))){
var _ = (function (){var statearr_27768 = state_27750;
(statearr_27768[(4)] = cljs.core.cons((5),(state_27750[(4)])));

return statearr_27768;
})();
var inst_27711 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_27750__$1 = state_27750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27750__$1,(6),inst_27711);
} else {
if((state_val_27751 === (19))){
var inst_27741 = (state_27750[(2)]);
var state_27750__$1 = state_27750;
var statearr_27769_27800 = state_27750__$1;
(statearr_27769_27800[(2)] = inst_27741);

(statearr_27769_27800[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (11))){
var inst_27717 = (state_27750[(2)]);
var state_27750__$1 = (function (){var statearr_27771 = state_27750;
(statearr_27771[(9)] = inst_27717);

return statearr_27771;
})();
var statearr_27772_27801 = state_27750__$1;
(statearr_27772_27801[(2)] = null);

(statearr_27772_27801[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (9))){
var inst_27715 = (state_27750[(7)]);
var _ = (function (){var statearr_27773 = state_27750;
(statearr_27773[(4)] = cljs.core.cons((12),(state_27750[(4)])));

return statearr_27773;
})();
var inst_27723 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_27715,t,novelty,fast_forward_db_QMARK_);
var state_27750__$1 = state_27750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27750__$1,(13),inst_27723);
} else {
if((state_val_27751 === (5))){
var _ = (function (){var statearr_27774 = state_27750;
(statearr_27774[(4)] = cljs.core.rest((state_27750[(4)])));

return statearr_27774;
})();
var state_27750__$1 = state_27750;
var ex27770 = (state_27750__$1[(2)]);
var statearr_27775_27802 = state_27750__$1;
(statearr_27775_27802[(5)] = ex27770);


if((ex27770 instanceof Error)){
var statearr_27776_27803 = state_27750__$1;
(statearr_27776_27803[(1)] = (4));

(statearr_27776_27803[(5)] = null);

} else {
throw ex27770;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (14))){
var inst_27729 = (state_27750[(10)]);
var state_27750__$1 = state_27750;
var statearr_27777_27804 = state_27750__$1;
(statearr_27777_27804[(2)] = inst_27729);

(statearr_27777_27804[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (16))){
var inst_27743 = (state_27750[(2)]);
var state_27750__$1 = state_27750;
var statearr_27778_27805 = state_27750__$1;
(statearr_27778_27805[(2)] = inst_27743);

(statearr_27778_27805[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (10))){
var inst_27729 = (state_27750[(10)]);
var inst_27729__$1 = (state_27750[(2)]);
var state_27750__$1 = (function (){var statearr_27779 = state_27750;
(statearr_27779[(10)] = inst_27729__$1);

return statearr_27779;
})();
if(cljs.core.truth_(inst_27729__$1)){
var statearr_27780_27806 = state_27750__$1;
(statearr_27780_27806[(1)] = (14));

} else {
var statearr_27781_27807 = state_27750__$1;
(statearr_27781_27807[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (18))){
var state_27750__$1 = state_27750;
var statearr_27782_27808 = state_27750__$1;
(statearr_27782_27808[(2)] = null);

(statearr_27782_27808[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27751 === (8))){
var inst_27745 = (state_27750[(2)]);
var _ = (function (){var statearr_27783 = state_27750;
(statearr_27783[(4)] = cljs.core.rest((state_27750[(4)])));

return statearr_27783;
})();
var state_27750__$1 = state_27750;
var statearr_27784_27809 = state_27750__$1;
(statearr_27784_27809[(2)] = inst_27745);

(statearr_27784_27809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0 = (function (){
var statearr_27785 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27785[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__);

(statearr_27785[(1)] = (1));

return statearr_27785;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1 = (function (state_27750){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_27750);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e27786){var ex__13886__auto__ = e27786;
var statearr_27787_27810 = state_27750;
(statearr_27787_27810[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_27750[(4)]))){
var statearr_27788_27811 = state_27750;
(statearr_27788_27811[(1)] = cljs.core.first((state_27750[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__27812 = state_27750;
state_27750 = G__27812;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__ = function(state_27750){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1.call(this,state_27750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_27789 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_27789[(6)] = c__13957__auto__);

return statearr_27789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__27819 = arguments.length;
switch (G__27819) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__27820 = (function (){var pred__27823 = cljs.core.identical_QMARK_;
var expr__27824 = test;
if(cljs.core.truth_((pred__27823.cljs$core$IFn$_invoke$arity$2 ? pred__27823.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__27824) : pred__27823.call(null,cljs.core._EQ_,expr__27824)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27823.cljs$core$IFn$_invoke$arity$2 ? pred__27823.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__27824) : pred__27823.call(null,cljs.core._LT_,expr__27824)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__27823.cljs$core$IFn$_invoke$arity$2 ? pred__27823.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__27824) : pred__27823.call(null,cljs.core._LT__EQ_,expr__27824)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27823.cljs$core$IFn$_invoke$arity$2 ? pred__27823.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__27824) : pred__27823.call(null,cljs.core._GT_,expr__27824)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__27823.cljs$core$IFn$_invoke$arity$2 ? pred__27823.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__27824) : pred__27823.call(null,cljs.core._GT__EQ_,expr__27824)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__27824)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28189){
var state_val_28190 = (state_28189[(1)]);
if((state_val_28190 === (65))){
var inst_28004 = (state_28189[(7)]);
var inst_28010 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28191 = state_28189;
(statearr_28191[(8)] = inst_28010);

return statearr_28191;
})();
if(cljs.core.truth_(inst_28004)){
var statearr_28192_28376 = state_28189__$1;
(statearr_28192_28376[(1)] = (66));

} else {
var statearr_28193_28377 = state_28189__$1;
(statearr_28193_28377[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (70))){
var inst_28181 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28194_28378 = state_28189__$1;
(statearr_28194_28378[(2)] = inst_28181);

(statearr_28194_28378[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (62))){
var inst_28003 = (state_28189[(2)]);
var inst_28004 = fluree.db.util.async.throw_err(inst_28003);
var inst_28005 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28189__$1 = (function (){var statearr_28195 = state_28189;
(statearr_28195[(7)] = inst_28004);

return statearr_28195;
})();
if(cljs.core.truth_(inst_28005)){
var statearr_28196_28379 = state_28189__$1;
(statearr_28196_28379[(1)] = (63));

} else {
var statearr_28197_28380 = state_28189__$1;
(statearr_28197_28380[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (74))){
var inst_27851 = (state_28189[(9)]);
var inst_27989 = (state_28189[(10)]);
var inst_27882 = (state_28189[(11)]);
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27857 = (state_28189[(15)]);
var inst_27974 = (state_28189[(16)]);
var inst_27984 = (state_28189[(17)]);
var inst_27850 = (state_28189[(18)]);
var inst_28017 = (state_28189[(19)]);
var inst_28023 = (state_28189[(20)]);
var inst_28004 = (state_28189[(7)]);
var inst_27858 = (state_28189[(21)]);
var inst_28010 = (state_28189[(8)]);
var inst_27846 = (state_28189[(22)]);
var inst_28015 = (state_28189[(23)]);
var inst_27973 = (state_28189[(24)]);
var inst_27863 = (state_28189[(25)]);
var inst_27990 = (state_28189[(26)]);
var inst_27914 = (state_28189[(27)]);
var inst_28014 = (state_28189[(28)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27853 = (state_28189[(31)]);
var inst_28031 = (state_28189[(32)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27985 = (state_28189[(36)]);
var inst_27936 = (state_28189[(37)]);
var inst_27861 = (state_28189[(38)]);
var inst_27918 = (state_28189[(39)]);
var inst_27977 = (state_28189[(40)]);
var inst_27915 = (state_28189[(41)]);
var inst_28016 = (state_28189[(42)]);
var inst_27862 = (state_28189[(43)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27983 = (state_28189[(46)]);
var inst_28013 = (state_28189[(47)]);
var inst_28033 = (function (){var no_filter_QMARK_ = inst_28010;
var t = inst_27990;
var max_limit_QMARK_ = inst_27984;
var next_node = inst_28013;
var vec__27842 = inst_27915;
var G__28024 = inst_28031;
var vec__27839 = inst_27914;
var fast_forward_db_QMARK_ = inst_27995;
var s1 = inst_27873;
var o2 = inst_27936;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var i = inst_28015;
var m1 = inst_27963;
var root_node = inst_28000;
var s2 = inst_27882;
var p2 = inst_27954;
var permissions = inst_27985;
var limit = inst_27983;
var start_flake = inst_27973;
var flake_limit = inst_27977;
var offset = inst_28014;
var acc = inst_28017;
var map__27845 = inst_27976;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27927;
var end_flake = inst_27974;
var base_result = inst_28023;
var s = inst_28016;
var node_start = inst_28004;
var p1 = inst_27945;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27918;
var idx_compare = inst_27989;
var op2 = inst_27858;
var m2 = inst_27972;
var vec__27835 = inst_27853;
var novelty = inst_27994;
return (function (p1__27814_SHARP_){
var G__28198 = p1__27814_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__28198) : subject_fn.call(null,G__28198));
});
})();
var inst_28034 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28033,inst_28031);
var state_28189__$1 = state_28189;
var statearr_28199_28381 = state_28189__$1;
(statearr_28199_28381[(2)] = inst_28034);

(statearr_28199_28381[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (110))){
var inst_28161 = (state_28189[(48)]);
var inst_28169 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28200 = state_28189;
(statearr_28200[(49)] = inst_28169);

return statearr_28200;
})();
if(cljs.core.truth_(inst_28161)){
var statearr_28201_28382 = state_28189__$1;
(statearr_28201_28382[(1)] = (112));

} else {
var statearr_28202_28383 = state_28189__$1;
(statearr_28202_28383[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (7))){
var inst_27847 = (state_28189[(50)]);
var state_28189__$1 = state_28189;
var statearr_28203_28384 = state_28189__$1;
(statearr_28203_28384[(2)] = inst_27847);

(statearr_28203_28384[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (59))){
var state_28189__$1 = state_28189;
var statearr_28204_28385 = state_28189__$1;
(statearr_28204_28385[(2)] = fluree.db.util.core.max_long);

(statearr_28204_28385[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (86))){
var inst_28010 = (state_28189[(8)]);
var state_28189__$1 = state_28189;
var statearr_28205_28386 = state_28189__$1;
(statearr_28205_28386[(2)] = inst_28010);

(statearr_28205_28386[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (20))){
var state_28189__$1 = state_28189;
var statearr_28206_28387 = state_28189__$1;
(statearr_28206_28387[(2)] = null);

(statearr_28206_28387[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (72))){
var inst_28023 = (state_28189[(20)]);
var state_28189__$1 = state_28189;
var statearr_28207_28388 = state_28189__$1;
(statearr_28207_28388[(2)] = inst_28023);

(statearr_28207_28388[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (58))){
var inst_27978 = (state_28189[(51)]);
var state_28189__$1 = state_28189;
var statearr_28208_28389 = state_28189__$1;
(statearr_28208_28389[(2)] = inst_27978);

(statearr_28208_28389[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (60))){
var inst_27983 = (state_28189[(46)]);
var inst_27983__$1 = (state_28189[(2)]);
var inst_27984 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27983__$1,fluree.db.util.core.max_long);
var inst_27985 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_27986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27987 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_27988 = (new cljs.core.PersistentVector(null,3,(5),inst_27986,inst_27987,null));
var inst_27989 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27988);
var inst_27990 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_27991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27992 = [cljs.core.cst$kw$novelty,idx];
var inst_27993 = (new cljs.core.PersistentVector(null,2,(5),inst_27991,inst_27992,null));
var inst_27994 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27993);
var inst_27995 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_27996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_27997 = fluree.db.dbproto._resolve(inst_27996);
var state_28189__$1 = (function (){var statearr_28209 = state_28189;
(statearr_28209[(10)] = inst_27989);

(statearr_28209[(13)] = inst_27995);

(statearr_28209[(14)] = inst_27994);

(statearr_28209[(17)] = inst_27984);

(statearr_28209[(26)] = inst_27990);

(statearr_28209[(36)] = inst_27985);

(statearr_28209[(46)] = inst_27983__$1);

return statearr_28209;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(61),inst_27997);
} else {
if((state_val_28190 === (27))){
var inst_27916 = (state_28189[(52)]);
var state_28189__$1 = state_28189;
var statearr_28210_28390 = state_28189__$1;
(statearr_28210_28390[(2)] = inst_27916);

(statearr_28210_28390[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (1))){
var state_28189__$1 = state_28189;
var statearr_28211_28391 = state_28189__$1;
(statearr_28211_28391[(2)] = null);

(statearr_28211_28391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (69))){
var inst_27974 = (state_28189[(16)]);
var inst_27973 = (state_28189[(24)]);
var inst_28013 = (state_28189[(47)]);
var inst_28022 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_28013);
var inst_28023 = fluree.db.flake.subrange(inst_28022,start_test,inst_27973,end_test,inst_27974);
var inst_28025 = fluree.db.query.range.value_with_nil_pred(idx,inst_27973,inst_27974);
var state_28189__$1 = (function (){var statearr_28212 = state_28189;
(statearr_28212[(20)] = inst_28023);

return statearr_28212;
})();
if(inst_28025){
var statearr_28213_28392 = state_28189__$1;
(statearr_28213_28392[(1)] = (71));

} else {
var statearr_28214_28393 = state_28189__$1;
(statearr_28214_28393[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (101))){
var inst_28111 = (state_28189[(53)]);
var inst_28110 = (state_28189[(54)]);
var inst_27977 = (state_28189[(40)]);
var inst_28109 = (state_28189[(55)]);
var inst_28114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28115 = (inst_28111 - inst_27977);
var inst_28116 = (inst_28110 - inst_28115);
var inst_28117 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28116,inst_28109);
var inst_28118 = [inst_27977,inst_28117];
var inst_28119 = (new cljs.core.PersistentVector(null,2,(5),inst_28114,inst_28118,null));
var state_28189__$1 = state_28189;
var statearr_28215_28394 = state_28189__$1;
(statearr_28215_28394[(2)] = inst_28119);

(statearr_28215_28394[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (24))){
var inst_27849 = (state_28189[(56)]);
var inst_27851 = (state_28189[(9)]);
var inst_27882 = (state_28189[(11)]);
var inst_27852 = (state_28189[(57)]);
var inst_27864 = (state_28189[(58)]);
var inst_27896 = (state_28189[(59)]);
var inst_27856 = (state_28189[(60)]);
var inst_27857 = (state_28189[(15)]);
var inst_27850 = (state_28189[(18)]);
var inst_27858 = (state_28189[(21)]);
var inst_27846 = (state_28189[(22)]);
var inst_27863 = (state_28189[(25)]);
var inst_27848 = (state_28189[(61)]);
var inst_27853 = (state_28189[(31)]);
var inst_27873 = (state_28189[(34)]);
var inst_27855 = (state_28189[(62)]);
var inst_27861 = (state_28189[(38)]);
var inst_27859 = (state_28189[(63)]);
var inst_27862 = (state_28189[(43)]);
var inst_27906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27908 = [null,null];
var inst_27909 = (new cljs.core.PersistentVector(null,2,(5),inst_27907,inst_27908,null));
var inst_27910 = (function (){var bool = inst_27896;
var s1 = inst_27873;
var o2 = inst_27856;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var m1 = inst_27852;
var s2 = inst_27882;
var p2 = inst_27855;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27849;
var p1 = inst_27848;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27864;
var op2 = inst_27858;
var m2 = inst_27859;
var temp__5755__auto__ = inst_27896;
var vec__27835 = inst_27853;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_27911 = [inst_27909,inst_27910];
var inst_27912 = (new cljs.core.PersistentVector(null,2,(5),inst_27906,inst_27911,null));
var state_28189__$1 = state_28189;
var statearr_28216_28395 = state_28189__$1;
(statearr_28216_28395[(2)] = inst_27912);

(statearr_28216_28395[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (102))){
var inst_28111 = (state_28189[(53)]);
var inst_28109 = (state_28189[(55)]);
var inst_28121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28122 = [inst_28111,inst_28109];
var inst_28123 = (new cljs.core.PersistentVector(null,2,(5),inst_28121,inst_28122,null));
var state_28189__$1 = state_28189;
var statearr_28217_28396 = state_28189__$1;
(statearr_28217_28396[(2)] = inst_28123);

(statearr_28217_28396[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (55))){
var state_28189__$1 = state_28189;
var statearr_28218_28397 = state_28189__$1;
(statearr_28218_28397[(2)] = (2147483647));

(statearr_28218_28397[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (85))){
var inst_28059 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
if(cljs.core.truth_(inst_28059)){
var statearr_28219_28398 = state_28189__$1;
(statearr_28219_28398[(1)] = (89));

} else {
var statearr_28220_28399 = state_28189__$1;
(statearr_28220_28399[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (39))){
var inst_27855 = (state_28189[(62)]);
var inst_27945 = (state_28189[(2)]);
var inst_27946 = (inst_27855 == null);
var state_28189__$1 = (function (){var statearr_28221 = state_28189;
(statearr_28221[(45)] = inst_27945);

return statearr_28221;
})();
if(cljs.core.truth_(inst_27946)){
var statearr_28222_28400 = state_28189__$1;
(statearr_28222_28400[(1)] = (40));

} else {
var statearr_28223_28401 = state_28189__$1;
(statearr_28223_28401[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (88))){
var inst_28056 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28224_28402 = state_28189__$1;
(statearr_28224_28402[(2)] = inst_28056);

(statearr_28224_28402[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (46))){
var inst_27852 = (state_28189[(57)]);
var state_28189__$1 = state_28189;
var statearr_28225_28403 = state_28189__$1;
(statearr_28225_28403[(2)] = inst_27852);

(statearr_28225_28403[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (4))){
var inst_27826 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28226_28404 = state_28189__$1;
(statearr_28226_28404[(2)] = inst_27826);

(statearr_28226_28404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (77))){
var inst_27851 = (state_28189[(9)]);
var inst_27989 = (state_28189[(10)]);
var inst_27882 = (state_28189[(11)]);
var inst_28000 = (state_28189[(12)]);
var inst_28037 = (state_28189[(64)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27857 = (state_28189[(15)]);
var inst_27974 = (state_28189[(16)]);
var inst_27984 = (state_28189[(17)]);
var inst_27850 = (state_28189[(18)]);
var inst_28017 = (state_28189[(19)]);
var inst_28023 = (state_28189[(20)]);
var inst_28004 = (state_28189[(7)]);
var inst_27858 = (state_28189[(21)]);
var inst_28010 = (state_28189[(8)]);
var inst_27846 = (state_28189[(22)]);
var inst_28015 = (state_28189[(23)]);
var inst_27973 = (state_28189[(24)]);
var inst_27863 = (state_28189[(25)]);
var inst_27990 = (state_28189[(26)]);
var inst_27914 = (state_28189[(27)]);
var inst_28014 = (state_28189[(28)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27853 = (state_28189[(31)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27985 = (state_28189[(36)]);
var inst_27936 = (state_28189[(37)]);
var inst_27861 = (state_28189[(38)]);
var inst_27918 = (state_28189[(39)]);
var inst_27977 = (state_28189[(40)]);
var inst_27915 = (state_28189[(41)]);
var inst_28016 = (state_28189[(42)]);
var inst_27862 = (state_28189[(43)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27983 = (state_28189[(46)]);
var inst_28013 = (state_28189[(47)]);
var inst_28039 = (function (){var no_filter_QMARK_ = inst_28010;
var t = inst_27990;
var max_limit_QMARK_ = inst_27984;
var next_node = inst_28013;
var vec__27842 = inst_27915;
var G__28024 = inst_28037;
var vec__27839 = inst_27914;
var fast_forward_db_QMARK_ = inst_27995;
var s1 = inst_27873;
var o2 = inst_27936;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var i = inst_28015;
var m1 = inst_27963;
var root_node = inst_28000;
var s2 = inst_27882;
var p2 = inst_27954;
var permissions = inst_27985;
var limit = inst_27983;
var start_flake = inst_27973;
var flake_limit = inst_27977;
var offset = inst_28014;
var acc = inst_28017;
var map__27845 = inst_27976;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27927;
var end_flake = inst_27974;
var base_result = inst_28023;
var s = inst_28016;
var node_start = inst_28004;
var p1 = inst_27945;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27918;
var idx_compare = inst_27989;
var op2 = inst_27858;
var m2 = inst_27972;
var vec__27835 = inst_27853;
var novelty = inst_27994;
return (function (p1__27815_SHARP_){
var G__28227 = p1__27815_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__28227) : predicate_fn.call(null,G__28227));
});
})();
var inst_28040 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28039,inst_28037);
var state_28189__$1 = state_28189;
var statearr_28228_28405 = state_28189__$1;
(statearr_28228_28405[(2)] = inst_28040);

(statearr_28228_28405[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (106))){
var inst_28050 = (state_28189[(65)]);
var state_28189__$1 = state_28189;
var statearr_28229_28406 = state_28189__$1;
(statearr_28229_28406[(2)] = inst_28050);

(statearr_28229_28406[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (95))){
var inst_28092 = (state_28189[(66)]);
var inst_28093 = (state_28189[(67)]);
var inst_28091 = (state_28189[(68)]);
var inst_28083 = (state_28189[(69)]);
var inst_28016 = (state_28189[(42)]);
var inst_27983 = (state_28189[(46)]);
var inst_28091__$1 = cljs.core.count(inst_28083);
var inst_28092__$1 = (inst_28016 + inst_28091__$1);
var inst_28093__$1 = (inst_28092__$1 - inst_27983);
var inst_28094 = cljs.core.pos_int_QMARK_(inst_28093__$1);
var state_28189__$1 = (function (){var statearr_28230 = state_28189;
(statearr_28230[(66)] = inst_28092__$1);

(statearr_28230[(67)] = inst_28093__$1);

(statearr_28230[(68)] = inst_28091__$1);

return statearr_28230;
})();
if(inst_28094){
var statearr_28231_28407 = state_28189__$1;
(statearr_28231_28407[(1)] = (98));

} else {
var statearr_28232_28408 = state_28189__$1;
(statearr_28232_28408[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (54))){
var inst_27851 = (state_28189[(9)]);
var inst_27882 = (state_28189[(11)]);
var inst_27857 = (state_28189[(15)]);
var inst_27850 = (state_28189[(18)]);
var inst_27858 = (state_28189[(21)]);
var inst_27978 = (state_28189[(51)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27936 = (state_28189[(37)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27972__$1 = (state_28189[(2)]);
var inst_27973 = fluree.db.flake.__GT_Flake(inst_27873,inst_27945,inst_27927,inst_27850,inst_27851,inst_27963);
var inst_27974 = fluree.db.flake.__GT_Flake(inst_27882,inst_27954,inst_27936,inst_27857,inst_27858,inst_27972__$1);
var inst_27975 = opts;
var inst_27976__$1 = cljs.core.__destructure_map(inst_27975);
var inst_27977 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_27976__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_27978__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27976__$1,cljs.core.cst$kw$limit);
var inst_27979 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_27976__$1,cljs.core.cst$kw$offset,(0));
var state_28189__$1 = (function (){var statearr_28233 = state_28189;
(statearr_28233[(16)] = inst_27974);

(statearr_28233[(24)] = inst_27973);

(statearr_28233[(51)] = inst_27978__$1);

(statearr_28233[(30)] = inst_27972__$1);

(statearr_28233[(33)] = inst_27976__$1);

(statearr_28233[(70)] = inst_27979);

(statearr_28233[(40)] = inst_27977);

return statearr_28233;
})();
if(cljs.core.truth_(inst_27978__$1)){
var statearr_28234_28409 = state_28189__$1;
(statearr_28234_28409[(1)] = (58));

} else {
var statearr_28235_28410 = state_28189__$1;
(statearr_28235_28410[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (92))){
var inst_28017 = (state_28189[(19)]);
var inst_28015 = (state_28189[(23)]);
var inst_28014 = (state_28189[(28)]);
var inst_28016 = (state_28189[(42)]);
var inst_28072 = (state_28189[(71)]);
var inst_28075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28076 = (inst_28014 - inst_28072);
var inst_28077 = [inst_28076,inst_28015,inst_28016,inst_28017];
var inst_28078 = (new cljs.core.PersistentVector(null,4,(5),inst_28075,inst_28077,null));
var state_28189__$1 = state_28189;
var statearr_28236_28411 = state_28189__$1;
(statearr_28236_28411[(2)] = inst_28078);

(statearr_28236_28411[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (104))){
var inst_28134 = (state_28189[(2)]);
var inst_28135 = fluree.db.util.async.throw_err(inst_28134);
var state_28189__$1 = state_28189;
var statearr_28237_28412 = state_28189__$1;
(statearr_28237_28412[(2)] = inst_28135);

(statearr_28237_28412[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (15))){
var inst_27856 = (state_28189[(60)]);
var inst_27886 = cljs.core.boolean_QMARK_(inst_27856);
var state_28189__$1 = state_28189;
if(inst_27886){
var statearr_28238_28413 = state_28189__$1;
(statearr_28238_28413[(1)] = (17));

} else {
var statearr_28239_28414 = state_28189__$1;
(statearr_28239_28414[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (48))){
var inst_27859 = (state_28189[(63)]);
var inst_27963 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28240 = state_28189;
(statearr_28240[(44)] = inst_27963);

return statearr_28240;
})();
if(cljs.core.truth_(inst_27859)){
var statearr_28241_28415 = state_28189__$1;
(statearr_28241_28415[(1)] = (52));

} else {
var statearr_28242_28416 = state_28189__$1;
(statearr_28242_28416[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (50))){
var state_28189__$1 = state_28189;
var statearr_28243_28417 = state_28189__$1;
(statearr_28243_28417[(2)] = (2147483647));

(statearr_28243_28417[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (116))){
var inst_28151 = (state_28189[(72)]);
var inst_28150 = (state_28189[(73)]);
var inst_28152 = (state_28189[(74)]);
var inst_28149 = (state_28189[(75)]);
var inst_28169 = (state_28189[(49)]);
var inst_28013 = inst_28169;
var inst_28014 = inst_28149;
var inst_28015 = inst_28150;
var inst_28016 = inst_28151;
var inst_28017 = inst_28152;
var state_28189__$1 = (function (){var statearr_28244 = state_28189;
(statearr_28244[(19)] = inst_28017);

(statearr_28244[(23)] = inst_28015);

(statearr_28244[(28)] = inst_28014);

(statearr_28244[(42)] = inst_28016);

(statearr_28244[(47)] = inst_28013);

return statearr_28244;
})();
var statearr_28245_28418 = state_28189__$1;
(statearr_28245_28418[(2)] = null);

(statearr_28245_28418[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (75))){
var inst_28031 = (state_28189[(32)]);
var state_28189__$1 = state_28189;
var statearr_28246_28419 = state_28189__$1;
(statearr_28246_28419[(2)] = inst_28031);

(statearr_28246_28419[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (99))){
var inst_28092 = (state_28189[(66)]);
var inst_28101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28102 = [inst_28092,inst_28092];
var inst_28103 = (new cljs.core.PersistentVector(null,2,(5),inst_28101,inst_28102,null));
var state_28189__$1 = state_28189;
var statearr_28247_28420 = state_28189__$1;
(statearr_28247_28420[(2)] = inst_28103);

(statearr_28247_28420[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (21))){
var state_28189__$1 = state_28189;
var statearr_28248_28421 = state_28189__$1;
(statearr_28248_28421[(2)] = null);

(statearr_28248_28421[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (31))){
var inst_27917 = (state_28189[(76)]);
var state_28189__$1 = state_28189;
var statearr_28249_28422 = state_28189__$1;
(statearr_28249_28422[(2)] = inst_27917);

(statearr_28249_28422[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (113))){
var inst_28161 = (state_28189[(48)]);
var state_28189__$1 = state_28189;
var statearr_28250_28423 = state_28189__$1;
(statearr_28250_28423[(2)] = inst_28161);

(statearr_28250_28423[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (32))){
var inst_27848 = (state_28189[(61)]);
var inst_27936 = (state_28189[(2)]);
var inst_27937 = (inst_27848 == null);
var state_28189__$1 = (function (){var statearr_28251 = state_28189;
(statearr_28251[(37)] = inst_27936);

return statearr_28251;
})();
if(cljs.core.truth_(inst_27937)){
var statearr_28252_28424 = state_28189__$1;
(statearr_28252_28424[(1)] = (34));

} else {
var statearr_28253_28425 = state_28189__$1;
(statearr_28253_28425[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (40))){
var inst_27936 = (state_28189[(37)]);
var state_28189__$1 = state_28189;
var statearr_28254_28426 = state_28189__$1;
(statearr_28254_28426[(2)] = inst_27936);

(statearr_28254_28426[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (91))){
var inst_28050 = (state_28189[(65)]);
var inst_28148 = (state_28189[(2)]);
var inst_28149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28148,(0),null);
var inst_28150 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28148,(1),null);
var inst_28151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28148,(2),null);
var inst_28152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28148,(3),null);
var state_28189__$1 = (function (){var statearr_28255 = state_28189;
(statearr_28255[(72)] = inst_28151);

(statearr_28255[(73)] = inst_28150);

(statearr_28255[(74)] = inst_28152);

(statearr_28255[(75)] = inst_28149);

return statearr_28255;
})();
if(cljs.core.truth_(inst_28050)){
var statearr_28256_28427 = state_28189__$1;
(statearr_28256_28427[(1)] = (105));

} else {
var statearr_28257_28428 = state_28189__$1;
(statearr_28257_28428[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (117))){
var inst_28179 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28258_28429 = state_28189__$1;
(statearr_28258_28429[(2)] = inst_28179);

(statearr_28258_28429[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (108))){
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27990 = (state_28189[(26)]);
var inst_28050 = (state_28189[(65)]);
var inst_28163 = fluree.db.query.range.find_next_valid_node(inst_28000,inst_28050,inst_27990,inst_27994,inst_27995);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(111),inst_28163);
} else {
if((state_val_28190 === (56))){
var state_28189__$1 = state_28189;
var statearr_28259_28430 = state_28189__$1;
(statearr_28259_28430[(2)] = fluree.db.util.core.min_integer);

(statearr_28259_28430[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (33))){
var inst_27932 = (state_28189[(2)]);
var inst_27933 = fluree.db.util.async.throw_err(inst_27932);
var state_28189__$1 = state_28189;
var statearr_28260_28431 = state_28189__$1;
(statearr_28260_28431[(2)] = inst_27933);

(statearr_28260_28431[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (13))){
var inst_27878 = (state_28189[(2)]);
var inst_27879 = fluree.db.util.async.throw_err(inst_27878);
var state_28189__$1 = state_28189;
var statearr_28261_28432 = state_28189__$1;
(statearr_28261_28432[(2)] = inst_27879);

(statearr_28261_28432[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (22))){
var inst_27892 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28262_28433 = state_28189__$1;
(statearr_28262_28433[(2)] = inst_27892);

(statearr_28262_28433[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (90))){
var inst_27851 = (state_28189[(9)]);
var inst_27989 = (state_28189[(10)]);
var inst_28071 = (state_28189[(77)]);
var inst_27882 = (state_28189[(11)]);
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27857 = (state_28189[(15)]);
var inst_27974 = (state_28189[(16)]);
var inst_27984 = (state_28189[(17)]);
var inst_27850 = (state_28189[(18)]);
var inst_28017 = (state_28189[(19)]);
var inst_28023 = (state_28189[(20)]);
var inst_28004 = (state_28189[(7)]);
var inst_27858 = (state_28189[(21)]);
var inst_28010 = (state_28189[(8)]);
var inst_27846 = (state_28189[(22)]);
var inst_28015 = (state_28189[(23)]);
var inst_27973 = (state_28189[(24)]);
var inst_27863 = (state_28189[(25)]);
var inst_27990 = (state_28189[(26)]);
var inst_27914 = (state_28189[(27)]);
var inst_28014 = (state_28189[(28)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27853 = (state_28189[(31)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27985 = (state_28189[(36)]);
var inst_27936 = (state_28189[(37)]);
var inst_27861 = (state_28189[(38)]);
var inst_27918 = (state_28189[(39)]);
var inst_27977 = (state_28189[(40)]);
var inst_27915 = (state_28189[(41)]);
var inst_28016 = (state_28189[(42)]);
var inst_27862 = (state_28189[(43)]);
var inst_28072 = (state_28189[(71)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27983 = (state_28189[(46)]);
var inst_28013 = (state_28189[(47)]);
var inst_28049 = (state_28189[(78)]);
var inst_28050 = (state_28189[(65)]);
var inst_28070 = (function (){var no_filter_QMARK_ = inst_28010;
var base_result_SINGLEQUOTE_ = inst_28049;
var t = inst_27990;
var max_limit_QMARK_ = inst_27984;
var next_node = inst_28013;
var vec__27842 = inst_27915;
var vec__27839 = inst_27914;
var fast_forward_db_QMARK_ = inst_27995;
var s1 = inst_27873;
var o2 = inst_27936;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var i = inst_28015;
var rhs = inst_28050;
var m1 = inst_27963;
var root_node = inst_28000;
var s2 = inst_27882;
var p2 = inst_27954;
var permissions = inst_27985;
var limit = inst_27983;
var start_flake = inst_27973;
var flake_limit = inst_27977;
var offset = inst_28014;
var acc = inst_28017;
var map__27845 = inst_27976;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27927;
var end_flake = inst_27974;
var base_result = inst_28023;
var s = inst_28016;
var node_start = inst_28004;
var p1 = inst_27945;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27918;
var idx_compare = inst_27989;
var op2 = inst_27858;
var m2 = inst_27972;
var vec__27835 = inst_27853;
var novelty = inst_27994;
return (function (p1__27817_SHARP_){
return p1__27817_SHARP_.s;
});
})();
var inst_28071__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28070,inst_28049);
var inst_28072__$1 = cljs.core.count(inst_28071__$1);
var inst_28073 = (inst_28014 > inst_28072__$1);
var state_28189__$1 = (function (){var statearr_28263 = state_28189;
(statearr_28263[(77)] = inst_28071__$1);

(statearr_28263[(71)] = inst_28072__$1);

return statearr_28263;
})();
if(cljs.core.truth_(inst_28073)){
var statearr_28264_28434 = state_28189__$1;
(statearr_28264_28434[(1)] = (92));

} else {
var statearr_28265_28435 = state_28189__$1;
(statearr_28265_28435[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (109))){
var state_28189__$1 = state_28189;
var statearr_28266_28436 = state_28189__$1;
(statearr_28266_28436[(2)] = null);

(statearr_28266_28436[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (36))){
var inst_27941 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
if(cljs.core.truth_(inst_27941)){
var statearr_28267_28437 = state_28189__$1;
(statearr_28267_28437[(1)] = (37));

} else {
var statearr_28268_28438 = state_28189__$1;
(statearr_28268_28438[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (41))){
var state_28189__$1 = state_28189;
var statearr_28269_28439 = state_28189__$1;
(statearr_28269_28439[(2)] = false);

(statearr_28269_28439[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (89))){
var inst_28017 = (state_28189[(19)]);
var inst_28015 = (state_28189[(23)]);
var inst_27977 = (state_28189[(40)]);
var inst_28016 = (state_28189[(42)]);
var inst_28049 = (state_28189[(78)]);
var inst_28061 = cljs.core.count(inst_28049);
var inst_28062 = (inst_27977 - inst_28015);
var inst_28063 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28062,inst_28049);
var inst_28064 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28017,inst_28063);
var inst_28065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28066 = (inst_28015 + inst_28061);
var inst_28067 = [(0),inst_28066,inst_28016,inst_28064];
var inst_28068 = (new cljs.core.PersistentVector(null,4,(5),inst_28065,inst_28067,null));
var state_28189__$1 = state_28189;
var statearr_28270_28440 = state_28189__$1;
(statearr_28270_28440[(2)] = inst_28068);

(statearr_28270_28440[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (100))){
var inst_28111 = (state_28189[(53)]);
var inst_28110 = (state_28189[(54)]);
var inst_28015 = (state_28189[(23)]);
var inst_27977 = (state_28189[(40)]);
var inst_28083 = (state_28189[(69)]);
var inst_28109 = (state_28189[(55)]);
var inst_28105 = (state_28189[(2)]);
var inst_28106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28105,(0),null);
var inst_28107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28105,(1),null);
var inst_28108 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28107,inst_28083);
var inst_28109__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_28108);
var inst_28110__$1 = cljs.core.count(inst_28109__$1);
var inst_28111__$1 = (inst_28015 + inst_28110__$1);
var inst_28112 = (inst_28111__$1 > inst_27977);
var state_28189__$1 = (function (){var statearr_28271 = state_28189;
(statearr_28271[(53)] = inst_28111__$1);

(statearr_28271[(54)] = inst_28110__$1);

(statearr_28271[(79)] = inst_28106);

(statearr_28271[(55)] = inst_28109__$1);

return statearr_28271;
})();
if(cljs.core.truth_(inst_28112)){
var statearr_28272_28441 = state_28189__$1;
(statearr_28272_28441[(1)] = (101));

} else {
var statearr_28273_28442 = state_28189__$1;
(statearr_28273_28442[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (43))){
var state_28189__$1 = state_28189;
var statearr_28274_28443 = state_28189__$1;
(statearr_28274_28443[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_28274_28443[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (61))){
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27973 = (state_28189[(24)]);
var inst_27990 = (state_28189[(26)]);
var inst_27999 = (state_28189[(2)]);
var inst_28000__$1 = fluree.db.util.async.throw_err(inst_27999);
var inst_28001 = fluree.db.query.range.find_next_valid_node(inst_28000__$1,inst_27973,inst_27990,inst_27994,inst_27995);
var state_28189__$1 = (function (){var statearr_28275 = state_28189;
(statearr_28275[(12)] = inst_28000__$1);

return statearr_28275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(62),inst_28001);
} else {
if((state_val_28190 === (29))){
var inst_27923 = (state_28189[(2)]);
var inst_27924 = fluree.db.util.async.throw_err(inst_27923);
var state_28189__$1 = state_28189;
var statearr_28276_28444 = state_28189__$1;
(statearr_28276_28444[(2)] = inst_27924);

(statearr_28276_28444[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (44))){
var inst_27855 = (state_28189[(62)]);
var state_28189__$1 = state_28189;
var statearr_28277_28445 = state_28189__$1;
(statearr_28277_28445[(2)] = inst_27855);

(statearr_28277_28445[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (93))){
var inst_28071 = (state_28189[(77)]);
var inst_28010 = (state_28189[(8)]);
var inst_28014 = (state_28189[(28)]);
var inst_28083 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_28014,inst_28071);
var state_28189__$1 = (function (){var statearr_28278 = state_28189;
(statearr_28278[(69)] = inst_28083);

return statearr_28278;
})();
if(cljs.core.truth_(inst_28010)){
var statearr_28279_28446 = state_28189__$1;
(statearr_28279_28446[(1)] = (95));

} else {
var statearr_28280_28447 = state_28189__$1;
(statearr_28280_28447[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (6))){
var inst_27847 = (state_28189[(50)]);
var inst_27867 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27847);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(9),inst_27867);
} else {
if((state_val_28190 === (111))){
var inst_28165 = (state_28189[(2)]);
var inst_28166 = fluree.db.util.async.throw_err(inst_28165);
var state_28189__$1 = state_28189;
var statearr_28281_28448 = state_28189__$1;
(statearr_28281_28448[(2)] = inst_28166);

(statearr_28281_28448[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (28))){
var inst_27917 = (state_28189[(76)]);
var inst_27927 = (state_28189[(2)]);
var inst_27928 = fluree.db.util.core.pred_ident_QMARK_(inst_27917);
var state_28189__$1 = (function (){var statearr_28282 = state_28189;
(statearr_28282[(35)] = inst_27927);

return statearr_28282;
})();
if(inst_27928){
var statearr_28283_28449 = state_28189__$1;
(statearr_28283_28449[(1)] = (30));

} else {
var statearr_28284_28450 = state_28189__$1;
(statearr_28284_28450[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (64))){
var state_28189__$1 = state_28189;
var statearr_28285_28451 = state_28189__$1;
(statearr_28285_28451[(2)] = true);

(statearr_28285_28451[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (103))){
var inst_28106 = (state_28189[(79)]);
var inst_28125 = (state_28189[(2)]);
var inst_28126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28125,(0),null);
var inst_28127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28125,(1),null);
var inst_28128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28129 = [inst_28126,inst_28106,inst_28127];
var inst_28130 = (new cljs.core.PersistentVector(null,3,(5),inst_28128,inst_28129,null));
var state_28189__$1 = state_28189;
var statearr_28286_28452 = state_28189__$1;
(statearr_28286_28452[(2)] = inst_28130);

(statearr_28286_28452[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (51))){
var inst_27961 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28287_28453 = state_28189__$1;
(statearr_28287_28453[(2)] = inst_27961);

(statearr_28287_28453[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (25))){
var inst_27914 = (state_28189[(27)]);
var inst_27916 = (state_28189[(52)]);
var inst_27915 = (state_28189[(41)]);
var inst_27914__$1 = (state_28189[(2)]);
var inst_27915__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27914__$1,(0),null);
var inst_27916__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27915__$1,(0),null);
var inst_27917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27915__$1,(1),null);
var inst_27918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27914__$1,(1),null);
var inst_27919 = fluree.db.util.core.pred_ident_QMARK_(inst_27916__$1);
var state_28189__$1 = (function (){var statearr_28288 = state_28189;
(statearr_28288[(76)] = inst_27917);

(statearr_28288[(27)] = inst_27914__$1);

(statearr_28288[(52)] = inst_27916__$1);

(statearr_28288[(39)] = inst_27918);

(statearr_28288[(41)] = inst_27915__$1);

return statearr_28288;
})();
if(inst_27919){
var statearr_28289_28454 = state_28189__$1;
(statearr_28289_28454[(1)] = (26));

} else {
var statearr_28290_28455 = state_28189__$1;
(statearr_28290_28455[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (34))){
var inst_27927 = (state_28189[(35)]);
var state_28189__$1 = state_28189;
var statearr_28291_28456 = state_28189__$1;
(statearr_28291_28456[(2)] = inst_27927);

(statearr_28291_28456[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (17))){
var inst_27856 = (state_28189[(60)]);
var state_28189__$1 = state_28189;
var statearr_28292_28457 = state_28189__$1;
(statearr_28292_28457[(2)] = inst_27856);

(statearr_28292_28457[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (3))){
var inst_28187 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28189__$1,inst_28187);
} else {
if((state_val_28190 === (12))){
var inst_27849 = (state_28189[(56)]);
var inst_27882 = (state_28189[(2)]);
var inst_27883 = cljs.core.boolean_QMARK_(inst_27849);
var state_28189__$1 = (function (){var statearr_28293 = state_28189;
(statearr_28293[(11)] = inst_27882);

return statearr_28293;
})();
if(inst_27883){
var statearr_28294_28458 = state_28189__$1;
(statearr_28294_28458[(1)] = (14));

} else {
var statearr_28295_28459 = state_28189__$1;
(statearr_28295_28459[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (2))){
var inst_27847 = (state_28189[(50)]);
var inst_27846 = (state_28189[(22)]);
var inst_27853 = (state_28189[(31)]);
var inst_27861 = (state_28189[(38)]);
var _ = (function (){var statearr_28296 = state_28189;
(statearr_28296[(4)] = cljs.core.cons((5),(state_28189[(4)])));

return statearr_28296;
})();
var inst_27846__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_27847__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(0),null);
var inst_27848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(1),null);
var inst_27849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(2),null);
var inst_27850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(3),null);
var inst_27851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(4),null);
var inst_27852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27846__$1,(5),null);
var inst_27853__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_27854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(0),null);
var inst_27855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(1),null);
var inst_27856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(2),null);
var inst_27857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(3),null);
var inst_27858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(4),null);
var inst_27859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27853__$1,(5),null);
var inst_27860 = opts;
var inst_27861__$1 = cljs.core.__destructure_map(inst_27860);
var inst_27862 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27861__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_27863 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27861__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_27864 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27861__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_27865 = fluree.db.util.core.pred_ident_QMARK_(inst_27847__$1);
var state_28189__$1 = (function (){var statearr_28297 = state_28189;
(statearr_28297[(56)] = inst_27849);

(statearr_28297[(9)] = inst_27851);

(statearr_28297[(50)] = inst_27847__$1);

(statearr_28297[(57)] = inst_27852);

(statearr_28297[(58)] = inst_27864);

(statearr_28297[(60)] = inst_27856);

(statearr_28297[(15)] = inst_27857);

(statearr_28297[(18)] = inst_27850);

(statearr_28297[(21)] = inst_27858);

(statearr_28297[(22)] = inst_27846__$1);

(statearr_28297[(25)] = inst_27863);

(statearr_28297[(61)] = inst_27848);

(statearr_28297[(31)] = inst_27853__$1);

(statearr_28297[(80)] = inst_27854);

(statearr_28297[(62)] = inst_27855);

(statearr_28297[(38)] = inst_27861__$1);

(statearr_28297[(63)] = inst_27859);

(statearr_28297[(43)] = inst_27862);

return statearr_28297;
})();
if(inst_27865){
var statearr_28298_28460 = state_28189__$1;
(statearr_28298_28460[(1)] = (6));

} else {
var statearr_28299_28461 = state_28189__$1;
(statearr_28299_28461[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (66))){
var inst_28004 = (state_28189[(7)]);
var inst_27979 = (state_28189[(70)]);
var inst_28012 = cljs.core.PersistentVector.EMPTY;
var inst_28013 = inst_28004;
var inst_28014 = inst_27979;
var inst_28015 = (0);
var inst_28016 = (0);
var inst_28017 = inst_28012;
var state_28189__$1 = (function (){var statearr_28300 = state_28189;
(statearr_28300[(19)] = inst_28017);

(statearr_28300[(23)] = inst_28015);

(statearr_28300[(28)] = inst_28014);

(statearr_28300[(42)] = inst_28016);

(statearr_28300[(47)] = inst_28013);

return statearr_28300;
})();
var statearr_28301_28462 = state_28189__$1;
(statearr_28301_28462[(2)] = null);

(statearr_28301_28462[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (107))){
var inst_28161 = (state_28189[(48)]);
var inst_28161__$1 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28302 = state_28189;
(statearr_28302[(48)] = inst_28161__$1);

return statearr_28302;
})();
if(cljs.core.truth_(inst_28161__$1)){
var statearr_28303_28463 = state_28189__$1;
(statearr_28303_28463[(1)] = (108));

} else {
var statearr_28304_28464 = state_28189__$1;
(statearr_28304_28464[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (23))){
var inst_27849 = (state_28189[(56)]);
var inst_27864 = (state_28189[(58)]);
var inst_27856 = (state_28189[(60)]);
var inst_27899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27901 = [inst_27849,inst_27856];
var inst_27902 = (new cljs.core.PersistentVector(null,2,(5),inst_27900,inst_27901,null));
var inst_27903 = [inst_27902,inst_27864];
var inst_27904 = (new cljs.core.PersistentVector(null,2,(5),inst_27899,inst_27903,null));
var state_28189__$1 = state_28189;
var statearr_28305_28465 = state_28189__$1;
(statearr_28305_28465[(2)] = inst_27904);

(statearr_28305_28465[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (47))){
var inst_27957 = (cljs.core._GT__EQ_ === start_test);
var state_28189__$1 = state_28189;
if(cljs.core.truth_(inst_27957)){
var statearr_28306_28466 = state_28189__$1;
(statearr_28306_28466[(1)] = (49));

} else {
var statearr_28307_28467 = state_28189__$1;
(statearr_28307_28467[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (35))){
var state_28189__$1 = state_28189;
var statearr_28308_28468 = state_28189__$1;
(statearr_28308_28468[(2)] = false);

(statearr_28308_28468[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (82))){
var inst_27984 = (state_28189[(17)]);
var inst_28013 = (state_28189[(47)]);
var inst_28049 = (state_28189[(2)]);
var inst_28050 = fluree.db.dbproto._rhs(inst_28013);
var state_28189__$1 = (function (){var statearr_28309 = state_28189;
(statearr_28309[(78)] = inst_28049);

(statearr_28309[(65)] = inst_28050);

return statearr_28309;
})();
if(cljs.core.truth_(inst_27984)){
var statearr_28310_28469 = state_28189__$1;
(statearr_28310_28469[(1)] = (83));

} else {
var statearr_28311_28470 = state_28189__$1;
(statearr_28311_28470[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (76))){
var inst_27863 = (state_28189[(25)]);
var inst_28037 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28312 = state_28189;
(statearr_28312[(64)] = inst_28037);

return statearr_28312;
})();
if(cljs.core.truth_(inst_27863)){
var statearr_28313_28471 = state_28189__$1;
(statearr_28313_28471[(1)] = (77));

} else {
var statearr_28314_28472 = state_28189__$1;
(statearr_28314_28472[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (97))){
var inst_28017 = (state_28189[(19)]);
var inst_28137 = (state_28189[(2)]);
var inst_28138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28137,(0),null);
var inst_28139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28137,(1),null);
var inst_28140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28137,(2),null);
var inst_28141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28142 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28017,inst_28140);
var inst_28143 = [(0),inst_28138,inst_28139,inst_28142];
var inst_28144 = (new cljs.core.PersistentVector(null,4,(5),inst_28141,inst_28143,null));
var state_28189__$1 = state_28189;
var statearr_28315_28473 = state_28189__$1;
(statearr_28315_28473[(2)] = inst_28144);

(statearr_28315_28473[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (19))){
var inst_27894 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28316_28474 = state_28189__$1;
(statearr_28316_28474[(2)] = inst_27894);

(statearr_28316_28474[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (57))){
var inst_27970 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28317_28475 = state_28189__$1;
(statearr_28317_28475[(2)] = inst_27970);

(statearr_28317_28475[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (68))){
var inst_28184 = (state_28189[(2)]);
var _ = (function (){var statearr_28318 = state_28189;
(statearr_28318[(4)] = cljs.core.rest((state_28189[(4)])));

return statearr_28318;
})();
var state_28189__$1 = state_28189;
var statearr_28319_28476 = state_28189__$1;
(statearr_28319_28476[(2)] = inst_28184);

(statearr_28319_28476[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (11))){
var inst_27854 = (state_28189[(80)]);
var state_28189__$1 = state_28189;
var statearr_28320_28477 = state_28189__$1;
(statearr_28320_28477[(2)] = inst_27854);

(statearr_28320_28477[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (115))){
var inst_28152 = (state_28189[(74)]);
var state_28189__$1 = state_28189;
var statearr_28322_28478 = state_28189__$1;
(statearr_28322_28478[(2)] = inst_28152);

(statearr_28322_28478[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (9))){
var inst_27869 = (state_28189[(2)]);
var inst_27870 = fluree.db.util.async.throw_err(inst_27869);
var state_28189__$1 = state_28189;
var statearr_28323_28479 = state_28189__$1;
(statearr_28323_28479[(2)] = inst_27870);

(statearr_28323_28479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (5))){
var _ = (function (){var statearr_28324 = state_28189;
(statearr_28324[(4)] = cljs.core.rest((state_28189[(4)])));

return statearr_28324;
})();
var state_28189__$1 = state_28189;
var ex28321 = (state_28189__$1[(2)]);
var statearr_28325_28480 = state_28189__$1;
(statearr_28325_28480[(5)] = ex28321);


if((ex28321 instanceof Error)){
var statearr_28326_28481 = state_28189__$1;
(statearr_28326_28481[(1)] = (4));

(statearr_28326_28481[(5)] = null);

} else {
throw ex28321;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (112))){
var inst_28169 = (state_28189[(49)]);
var state_28189__$1 = state_28189;
var statearr_28327_28482 = state_28189__$1;
(statearr_28327_28482[(2)] = inst_28169);

(statearr_28327_28482[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (83))){
var inst_28014 = (state_28189[(28)]);
var inst_28052 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_28014);
var state_28189__$1 = state_28189;
if(inst_28052){
var statearr_28328_28483 = state_28189__$1;
(statearr_28328_28483[(1)] = (86));

} else {
var statearr_28329_28484 = state_28189__$1;
(statearr_28329_28484[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (14))){
var inst_27849 = (state_28189[(56)]);
var state_28189__$1 = state_28189;
var statearr_28330_28485 = state_28189__$1;
(statearr_28330_28485[(2)] = inst_27849);

(statearr_28330_28485[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (45))){
var inst_27852 = (state_28189[(57)]);
var inst_27954 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28331 = state_28189;
(statearr_28331[(29)] = inst_27954);

return statearr_28331;
})();
if(cljs.core.truth_(inst_27852)){
var statearr_28332_28486 = state_28189__$1;
(statearr_28332_28486[(1)] = (46));

} else {
var statearr_28333_28487 = state_28189__$1;
(statearr_28333_28487[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (53))){
var inst_27966 = (cljs.core._LT__EQ_ === end_test);
var state_28189__$1 = state_28189;
if(cljs.core.truth_(inst_27966)){
var statearr_28334_28488 = state_28189__$1;
(statearr_28334_28488[(1)] = (55));

} else {
var statearr_28335_28489 = state_28189__$1;
(statearr_28335_28489[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (78))){
var inst_28037 = (state_28189[(64)]);
var state_28189__$1 = state_28189;
var statearr_28336_28490 = state_28189__$1;
(statearr_28336_28490[(2)] = inst_28037);

(statearr_28336_28490[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (26))){
var inst_27916 = (state_28189[(52)]);
var inst_27921 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27916);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(29),inst_27921);
} else {
if((state_val_28190 === (16))){
var inst_27896 = (state_28189[(59)]);
var inst_27896__$1 = (state_28189[(2)]);
var inst_27897 = (inst_27896__$1 == null);
var state_28189__$1 = (function (){var statearr_28337 = state_28189;
(statearr_28337[(59)] = inst_27896__$1);

return statearr_28337;
})();
if(cljs.core.truth_(inst_27897)){
var statearr_28338_28491 = state_28189__$1;
(statearr_28338_28491[(1)] = (23));

} else {
var statearr_28339_28492 = state_28189__$1;
(statearr_28339_28492[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (81))){
var inst_28043 = (state_28189[(81)]);
var state_28189__$1 = state_28189;
var statearr_28340_28493 = state_28189__$1;
(statearr_28340_28493[(2)] = inst_28043);

(statearr_28340_28493[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (79))){
var inst_27918 = (state_28189[(39)]);
var inst_28043 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28341 = state_28189;
(statearr_28341[(81)] = inst_28043);

return statearr_28341;
})();
if(cljs.core.truth_(inst_27918)){
var statearr_28342_28494 = state_28189__$1;
(statearr_28342_28494[(1)] = (80));

} else {
var statearr_28343_28495 = state_28189__$1;
(statearr_28343_28495[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (38))){
var inst_27848 = (state_28189[(61)]);
var state_28189__$1 = state_28189;
var statearr_28344_28496 = state_28189__$1;
(statearr_28344_28496[(2)] = inst_27848);

(statearr_28344_28496[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (98))){
var inst_28093 = (state_28189[(67)]);
var inst_28091 = (state_28189[(68)]);
var inst_27983 = (state_28189[(46)]);
var inst_28096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28097 = (inst_28091 - inst_28093);
var inst_28098 = [inst_27983,inst_28097];
var inst_28099 = (new cljs.core.PersistentVector(null,2,(5),inst_28096,inst_28098,null));
var state_28189__$1 = state_28189;
var statearr_28345_28497 = state_28189__$1;
(statearr_28345_28497[(2)] = inst_28099);

(statearr_28345_28497[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (87))){
var state_28189__$1 = state_28189;
var statearr_28346_28498 = state_28189__$1;
(statearr_28346_28498[(2)] = false);

(statearr_28346_28498[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (30))){
var inst_27917 = (state_28189[(76)]);
var inst_27930 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27917);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(33),inst_27930);
} else {
if((state_val_28190 === (73))){
var inst_27862 = (state_28189[(43)]);
var inst_28031 = (state_28189[(2)]);
var state_28189__$1 = (function (){var statearr_28347 = state_28189;
(statearr_28347[(32)] = inst_28031);

return statearr_28347;
})();
if(cljs.core.truth_(inst_27862)){
var statearr_28348_28499 = state_28189__$1;
(statearr_28348_28499[(1)] = (74));

} else {
var statearr_28349_28500 = state_28189__$1;
(statearr_28349_28500[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (96))){
var inst_28015 = (state_28189[(23)]);
var inst_27977 = (state_28189[(40)]);
var inst_28083 = (state_28189[(69)]);
var inst_28016 = (state_28189[(42)]);
var inst_27983 = (state_28189[(46)]);
var inst_28132 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_28083,inst_28015,inst_28016,inst_27977,inst_27983);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(104),inst_28132);
} else {
if((state_val_28190 === (10))){
var inst_27854 = (state_28189[(80)]);
var inst_27876 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27854);
var state_28189__$1 = state_28189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28189__$1,(13),inst_27876);
} else {
if((state_val_28190 === (18))){
var state_28189__$1 = state_28189;
var statearr_28350_28501 = state_28189__$1;
(statearr_28350_28501[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (105))){
var inst_27989 = (state_28189[(10)]);
var inst_28151 = (state_28189[(72)]);
var inst_28150 = (state_28189[(73)]);
var inst_27974 = (state_28189[(16)]);
var inst_27977 = (state_28189[(40)]);
var inst_27983 = (state_28189[(46)]);
var inst_28050 = (state_28189[(65)]);
var inst_28154 = (inst_27989.cljs$core$IFn$_invoke$arity$2 ? inst_27989.cljs$core$IFn$_invoke$arity$2(inst_28050,inst_27974) : inst_27989.call(null,inst_28050,inst_27974));
var inst_28155 = (inst_28154 < (0));
var inst_28156 = (inst_28150 < inst_27977);
var inst_28157 = (inst_28151 < inst_27983);
var inst_28158 = ((inst_28155) && (inst_28156) && (inst_28157));
var state_28189__$1 = state_28189;
var statearr_28352_28502 = state_28189__$1;
(statearr_28352_28502[(2)] = inst_28158);

(statearr_28352_28502[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (52))){
var inst_27859 = (state_28189[(63)]);
var state_28189__$1 = state_28189;
var statearr_28353_28503 = state_28189__$1;
(statearr_28353_28503[(2)] = inst_27859);

(statearr_28353_28503[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (114))){
var inst_28173 = (state_28189[(2)]);
var inst_28174 = cljs.core.not(inst_28173);
var state_28189__$1 = state_28189;
if(inst_28174){
var statearr_28354_28504 = state_28189__$1;
(statearr_28354_28504[(1)] = (115));

} else {
var statearr_28355_28505 = state_28189__$1;
(statearr_28355_28505[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (67))){
var state_28189__$1 = state_28189;
var statearr_28356_28506 = state_28189__$1;
(statearr_28356_28506[(2)] = null);

(statearr_28356_28506[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (71))){
var inst_27851 = (state_28189[(9)]);
var inst_27989 = (state_28189[(10)]);
var inst_27882 = (state_28189[(11)]);
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_27857 = (state_28189[(15)]);
var inst_27974 = (state_28189[(16)]);
var inst_27984 = (state_28189[(17)]);
var inst_27850 = (state_28189[(18)]);
var inst_28017 = (state_28189[(19)]);
var inst_28023 = (state_28189[(20)]);
var inst_28004 = (state_28189[(7)]);
var inst_27858 = (state_28189[(21)]);
var inst_28010 = (state_28189[(8)]);
var inst_27846 = (state_28189[(22)]);
var inst_28015 = (state_28189[(23)]);
var inst_27973 = (state_28189[(24)]);
var inst_27863 = (state_28189[(25)]);
var inst_27990 = (state_28189[(26)]);
var inst_27914 = (state_28189[(27)]);
var inst_28014 = (state_28189[(28)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27853 = (state_28189[(31)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27985 = (state_28189[(36)]);
var inst_27936 = (state_28189[(37)]);
var inst_27861 = (state_28189[(38)]);
var inst_27918 = (state_28189[(39)]);
var inst_27977 = (state_28189[(40)]);
var inst_27915 = (state_28189[(41)]);
var inst_28016 = (state_28189[(42)]);
var inst_27862 = (state_28189[(43)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27983 = (state_28189[(46)]);
var inst_28013 = (state_28189[(47)]);
var inst_28027 = (function (){var no_filter_QMARK_ = inst_28010;
var t = inst_27990;
var max_limit_QMARK_ = inst_27984;
var next_node = inst_28013;
var vec__27842 = inst_27915;
var G__28024 = inst_28023;
var vec__27839 = inst_27914;
var fast_forward_db_QMARK_ = inst_27995;
var s1 = inst_27873;
var o2 = inst_27936;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var i = inst_28015;
var m1 = inst_27963;
var root_node = inst_28000;
var s2 = inst_27882;
var p2 = inst_27954;
var permissions = inst_27985;
var limit = inst_27983;
var start_flake = inst_27973;
var flake_limit = inst_27977;
var offset = inst_28014;
var acc = inst_28017;
var map__27845 = inst_27976;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27927;
var end_flake = inst_27974;
var base_result = inst_28023;
var s = inst_28016;
var node_start = inst_28004;
var p1 = inst_27945;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27918;
var idx_compare = inst_27989;
var op2 = inst_27858;
var m2 = inst_27972;
var vec__27835 = inst_27853;
var novelty = inst_27994;
return (function (p1__27813_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__27813_SHARP_.o,start_flake.o);
});
})();
var inst_28028 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28027,inst_28023);
var state_28189__$1 = state_28189;
var statearr_28357_28507 = state_28189__$1;
(statearr_28357_28507[(2)] = inst_28028);

(statearr_28357_28507[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (42))){
var inst_27950 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
if(cljs.core.truth_(inst_27950)){
var statearr_28358_28508 = state_28189__$1;
(statearr_28358_28508[(1)] = (43));

} else {
var statearr_28359_28509 = state_28189__$1;
(statearr_28359_28509[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (80))){
var inst_27851 = (state_28189[(9)]);
var inst_27989 = (state_28189[(10)]);
var inst_27882 = (state_28189[(11)]);
var inst_28000 = (state_28189[(12)]);
var inst_27995 = (state_28189[(13)]);
var inst_27994 = (state_28189[(14)]);
var inst_28043 = (state_28189[(81)]);
var inst_27857 = (state_28189[(15)]);
var inst_27974 = (state_28189[(16)]);
var inst_27984 = (state_28189[(17)]);
var inst_27850 = (state_28189[(18)]);
var inst_28017 = (state_28189[(19)]);
var inst_28023 = (state_28189[(20)]);
var inst_28004 = (state_28189[(7)]);
var inst_27858 = (state_28189[(21)]);
var inst_28010 = (state_28189[(8)]);
var inst_27846 = (state_28189[(22)]);
var inst_28015 = (state_28189[(23)]);
var inst_27973 = (state_28189[(24)]);
var inst_27863 = (state_28189[(25)]);
var inst_27990 = (state_28189[(26)]);
var inst_27914 = (state_28189[(27)]);
var inst_28014 = (state_28189[(28)]);
var inst_27954 = (state_28189[(29)]);
var inst_27972 = (state_28189[(30)]);
var inst_27853 = (state_28189[(31)]);
var inst_27976 = (state_28189[(33)]);
var inst_27873 = (state_28189[(34)]);
var inst_27927 = (state_28189[(35)]);
var inst_27985 = (state_28189[(36)]);
var inst_27936 = (state_28189[(37)]);
var inst_27861 = (state_28189[(38)]);
var inst_27918 = (state_28189[(39)]);
var inst_27977 = (state_28189[(40)]);
var inst_27915 = (state_28189[(41)]);
var inst_28016 = (state_28189[(42)]);
var inst_27862 = (state_28189[(43)]);
var inst_27963 = (state_28189[(44)]);
var inst_27945 = (state_28189[(45)]);
var inst_27983 = (state_28189[(46)]);
var inst_28013 = (state_28189[(47)]);
var inst_28045 = (function (){var no_filter_QMARK_ = inst_28010;
var t = inst_27990;
var max_limit_QMARK_ = inst_27984;
var next_node = inst_28013;
var vec__27842 = inst_27915;
var G__28024 = inst_28043;
var vec__27839 = inst_27914;
var fast_forward_db_QMARK_ = inst_27995;
var s1 = inst_27873;
var o2 = inst_27936;
var t1 = inst_27850;
var predicate_fn = inst_27863;
var i = inst_28015;
var m1 = inst_27963;
var root_node = inst_28000;
var s2 = inst_27882;
var p2 = inst_27954;
var permissions = inst_27985;
var limit = inst_27983;
var start_flake = inst_27973;
var flake_limit = inst_27977;
var offset = inst_28014;
var acc = inst_28017;
var map__27845 = inst_27976;
var t2 = inst_27857;
var map__27838 = inst_27861;
var op1 = inst_27851;
var o1 = inst_27927;
var end_flake = inst_27974;
var base_result = inst_28023;
var s = inst_28016;
var node_start = inst_28004;
var p1 = inst_27945;
var subject_fn = inst_27862;
var vec__27832 = inst_27846;
var object_fn = inst_27918;
var idx_compare = inst_27989;
var op2 = inst_27858;
var m2 = inst_27972;
var vec__27835 = inst_27853;
var novelty = inst_27994;
return (function (p1__27816_SHARP_){
var G__28360 = p1__27816_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__28360) : object_fn.call(null,G__28360));
});
})();
var inst_28046 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28045,inst_28043);
var state_28189__$1 = state_28189;
var statearr_28361_28510 = state_28189__$1;
(statearr_28361_28510[(2)] = inst_28046);

(statearr_28361_28510[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (37))){
var state_28189__$1 = state_28189;
var statearr_28362_28511 = state_28189__$1;
(statearr_28362_28511[(2)] = (-1));

(statearr_28362_28511[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (63))){
var inst_27882 = (state_28189[(11)]);
var inst_27954 = (state_28189[(29)]);
var inst_27873 = (state_28189[(34)]);
var inst_27985 = (state_28189[(36)]);
var inst_27945 = (state_28189[(45)]);
var inst_28007 = fluree.db.permissions_validate.no_filter_QMARK_(inst_27985,inst_27873,inst_27882,inst_27945,inst_27954);
var state_28189__$1 = state_28189;
var statearr_28363_28512 = state_28189__$1;
(statearr_28363_28512[(2)] = inst_28007);

(statearr_28363_28512[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (94))){
var inst_28146 = (state_28189[(2)]);
var state_28189__$1 = state_28189;
var statearr_28364_28513 = state_28189__$1;
(statearr_28364_28513[(2)] = inst_28146);

(statearr_28364_28513[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (8))){
var inst_27854 = (state_28189[(80)]);
var inst_27873 = (state_28189[(2)]);
var inst_27874 = fluree.db.util.core.pred_ident_QMARK_(inst_27854);
var state_28189__$1 = (function (){var statearr_28365 = state_28189;
(statearr_28365[(34)] = inst_27873);

return statearr_28365;
})();
if(inst_27874){
var statearr_28366_28514 = state_28189__$1;
(statearr_28366_28514[(1)] = (10));

} else {
var statearr_28367_28515 = state_28189__$1;
(statearr_28367_28515[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (49))){
var state_28189__$1 = state_28189;
var statearr_28368_28516 = state_28189__$1;
(statearr_28368_28516[(2)] = fluree.db.util.core.min_integer);

(statearr_28368_28516[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28190 === (84))){
var inst_27984 = (state_28189[(17)]);
var state_28189__$1 = state_28189;
var statearr_28369_28517 = state_28189__$1;
(statearr_28369_28517[(2)] = inst_27984);

(statearr_28369_28517[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_28370 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28370[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_28370[(1)] = (1));

return statearr_28370;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_28189){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28189);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28371){var ex__13886__auto__ = e28371;
var statearr_28372_28518 = state_28189;
(statearr_28372_28518[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28189[(4)]))){
var statearr_28373_28519 = state_28189;
(statearr_28373_28519[(1)] = cljs.core.first((state_28189[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28520 = state_28189;
state_28189 = G__28520;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_28189){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_28189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28374 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28374[(6)] = c__13957__auto__);

return statearr_28374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28576){
var state_val_28577 = (state_28576[(1)]);
if((state_val_28577 === (7))){
var inst_28550 = (state_28576[(7)]);
var inst_28540 = (state_28576[(8)]);
var inst_28548 = fluree.db.flake.Flake__GT_parts(inst_28540);
var inst_28549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(0),null);
var inst_28550__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(1),null);
var inst_28551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(2),null);
var inst_28552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(3),null);
var inst_28553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(4),null);
var inst_28554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28548,(5),null);
var inst_28555 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_28551,inst_28550__$1);
var state_28576__$1 = (function (){var statearr_28578 = state_28576;
(statearr_28578[(9)] = inst_28554);

(statearr_28578[(10)] = inst_28552);

(statearr_28578[(7)] = inst_28550__$1);

(statearr_28578[(11)] = inst_28549);

(statearr_28578[(12)] = inst_28553);

return statearr_28578;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28576__$1,(10),inst_28555);
} else {
if((state_val_28577 === (1))){
var inst_28528 = flakes;
var inst_28529 = cljs.core.seq(inst_28528);
var inst_28530 = cljs.core.first(inst_28529);
var inst_28531 = cljs.core.next(inst_28529);
var inst_28532 = cljs.core.PersistentVector.EMPTY;
var inst_28533 = inst_28528;
var inst_28534 = inst_28532;
var state_28576__$1 = (function (){var statearr_28579 = state_28576;
(statearr_28579[(13)] = inst_28530);

(statearr_28579[(14)] = inst_28531);

(statearr_28579[(15)] = inst_28534);

(statearr_28579[(16)] = inst_28533);

return statearr_28579;
})();
var statearr_28580_28598 = state_28576__$1;
(statearr_28580_28598[(2)] = null);

(statearr_28580_28598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (4))){
var inst_28540 = (state_28576[(8)]);
var inst_28543 = fluree.db.query.range.is_tag_flake_QMARK_(inst_28540);
var state_28576__$1 = state_28576;
if(inst_28543){
var statearr_28581_28599 = state_28576__$1;
(statearr_28581_28599[(1)] = (7));

} else {
var statearr_28582_28600 = state_28576__$1;
(statearr_28582_28600[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (6))){
var inst_28572 = (state_28576[(2)]);
var state_28576__$1 = state_28576;
var statearr_28583_28601 = state_28576__$1;
(statearr_28583_28601[(2)] = inst_28572);

(statearr_28583_28601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (3))){
var inst_28574 = (state_28576[(2)]);
var state_28576__$1 = state_28576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28576__$1,inst_28574);
} else {
if((state_val_28577 === (2))){
var inst_28540 = (state_28576[(8)]);
var inst_28533 = (state_28576[(16)]);
var inst_28539 = cljs.core.seq(inst_28533);
var inst_28540__$1 = cljs.core.first(inst_28539);
var inst_28541 = cljs.core.next(inst_28539);
var state_28576__$1 = (function (){var statearr_28584 = state_28576;
(statearr_28584[(8)] = inst_28540__$1);

(statearr_28584[(17)] = inst_28541);

return statearr_28584;
})();
if(cljs.core.truth_(inst_28540__$1)){
var statearr_28585_28602 = state_28576__$1;
(statearr_28585_28602[(1)] = (4));

} else {
var statearr_28586_28603 = state_28576__$1;
(statearr_28586_28603[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (9))){
var inst_28569 = (state_28576[(2)]);
var state_28576__$1 = state_28576;
var statearr_28587_28604 = state_28576__$1;
(statearr_28587_28604[(2)] = inst_28569);

(statearr_28587_28604[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (5))){
var inst_28534 = (state_28576[(15)]);
var state_28576__$1 = state_28576;
var statearr_28588_28605 = state_28576__$1;
(statearr_28588_28605[(2)] = inst_28534);

(statearr_28588_28605[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (10))){
var inst_28554 = (state_28576[(9)]);
var inst_28552 = (state_28576[(10)]);
var inst_28550 = (state_28576[(7)]);
var inst_28549 = (state_28576[(11)]);
var inst_28534 = (state_28576[(15)]);
var inst_28553 = (state_28576[(12)]);
var inst_28541 = (state_28576[(17)]);
var inst_28557 = (state_28576[(2)]);
var inst_28558 = fluree.db.util.async.throw_err(inst_28557);
var inst_28559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28560 = [inst_28549,inst_28550,inst_28558,inst_28552,inst_28553,inst_28554];
var inst_28561 = (new cljs.core.PersistentVector(null,6,(5),inst_28559,inst_28560,null));
var inst_28562 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_28561);
var inst_28563 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28534,inst_28562);
var inst_28533 = inst_28541;
var inst_28534__$1 = inst_28563;
var state_28576__$1 = (function (){var statearr_28589 = state_28576;
(statearr_28589[(15)] = inst_28534__$1);

(statearr_28589[(16)] = inst_28533);

return statearr_28589;
})();
var statearr_28590_28606 = state_28576__$1;
(statearr_28590_28606[(2)] = null);

(statearr_28590_28606[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28577 === (8))){
var inst_28540 = (state_28576[(8)]);
var inst_28534 = (state_28576[(15)]);
var inst_28541 = (state_28576[(17)]);
var inst_28566 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28534,inst_28540);
var inst_28533 = inst_28541;
var inst_28534__$1 = inst_28566;
var state_28576__$1 = (function (){var statearr_28591 = state_28576;
(statearr_28591[(15)] = inst_28534__$1);

(statearr_28591[(16)] = inst_28533);

return statearr_28591;
})();
var statearr_28592_28607 = state_28576__$1;
(statearr_28592_28607[(2)] = null);

(statearr_28592_28607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0 = (function (){
var statearr_28593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28593[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__);

(statearr_28593[(1)] = (1));

return statearr_28593;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1 = (function (state_28576){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28576);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28594){var ex__13886__auto__ = e28594;
var statearr_28595_28608 = state_28576;
(statearr_28595_28608[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28576[(4)]))){
var statearr_28596_28609 = state_28576;
(statearr_28596_28609[(1)] = cljs.core.first((state_28576[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28610 = state_28576;
state_28576 = G__28610;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__ = function(state_28576){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1.call(this,state_28576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28597 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28597[(6)] = c__13957__auto__);

return statearr_28597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__28612 = arguments.length;
switch (G__28612) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28763){
var state_val_28764 = (state_28763[(1)]);
if((state_val_28764 === (62))){
var inst_28750 = (state_28763[(7)]);
var state_28763__$1 = state_28763;
var statearr_28765_28854 = state_28763__$1;
(statearr_28765_28854[(2)] = inst_28750);

(statearr_28765_28854[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (7))){
var state_28763__$1 = state_28763;
var statearr_28766_28855 = state_28763__$1;
(statearr_28766_28855[(2)] = false);

(statearr_28766_28855[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (59))){
var inst_28742 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28767_28856 = state_28763__$1;
(statearr_28767_28856[(2)] = inst_28742);

(statearr_28767_28856[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (20))){
var state_28763__$1 = state_28763;
var statearr_28768_28857 = state_28763__$1;
(statearr_28768_28857[(2)] = null);

(statearr_28768_28857[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (58))){
var state_28763__$1 = state_28763;
var statearr_28769_28858 = state_28763__$1;
(statearr_28769_28858[(2)] = null);

(statearr_28769_28858[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (60))){
var inst_28738 = (state_28763[(2)]);
var inst_28739 = fluree.db.util.async.throw_err(inst_28738);
var state_28763__$1 = state_28763;
var statearr_28770_28859 = state_28763__$1;
(statearr_28770_28859[(2)] = inst_28739);

(statearr_28770_28859[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (27))){
var inst_28663 = (state_28763[(8)]);
var inst_28674 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_28663);
var state_28763__$1 = state_28763;
if(inst_28674){
var statearr_28771_28860 = state_28763__$1;
(statearr_28771_28860[(1)] = (30));

} else {
var statearr_28772_28861 = state_28763__$1;
(statearr_28772_28861[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (1))){
var state_28763__$1 = state_28763;
var statearr_28773_28862 = state_28763__$1;
(statearr_28773_28862[(2)] = null);

(statearr_28773_28862[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (24))){
var inst_28624 = (state_28763[(9)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28624)){
var statearr_28774_28863 = state_28763__$1;
(statearr_28774_28863[(1)] = (27));

} else {
var statearr_28775_28864 = state_28763__$1;
(statearr_28775_28864[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (55))){
var inst_28744 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28776_28865 = state_28763__$1;
(statearr_28776_28865[(2)] = inst_28744);

(statearr_28776_28865[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (39))){
var inst_28694 = (state_28763[(2)]);
var inst_28695 = fluree.db.util.async.throw_err(inst_28694);
var state_28763__$1 = state_28763;
var statearr_28777_28866 = state_28763__$1;
(statearr_28777_28866[(2)] = inst_28695);

(statearr_28777_28866[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (46))){
var inst_28707 = (state_28763[(10)]);
var inst_28707__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_28763__$1 = (function (){var statearr_28778 = state_28763;
(statearr_28778[(10)] = inst_28707__$1);

return statearr_28778;
})();
if(cljs.core.truth_(inst_28707__$1)){
var statearr_28779_28867 = state_28763__$1;
(statearr_28779_28867[(1)] = (49));

} else {
var statearr_28780_28868 = state_28763__$1;
(statearr_28780_28868[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (4))){
var inst_28613 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28781_28869 = state_28763__$1;
(statearr_28781_28869[(2)] = inst_28613);

(statearr_28781_28869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (54))){
var inst_28663 = (state_28763[(8)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28663)){
var statearr_28782_28870 = state_28763__$1;
(statearr_28782_28870[(1)] = (57));

} else {
var statearr_28783_28871 = state_28763__$1;
(statearr_28783_28871[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (15))){
var inst_28625 = (state_28763[(11)]);
var inst_28644 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_28625);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(18),inst_28644);
} else {
if((state_val_28764 === (48))){
var inst_28746 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28784_28872 = state_28763__$1;
(statearr_28784_28872[(2)] = inst_28746);

(statearr_28784_28872[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (50))){
var inst_28707 = (state_28763[(10)]);
var inst_28638 = (state_28763[(12)]);
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28627 = (state_28763[(14)]);
var inst_28663 = (state_28763[(8)]);
var inst_28633 = (state_28763[(15)]);
var inst_28623 = (state_28763[(16)]);
var inst_28622 = (state_28763[(17)]);
var inst_28711 = (function (){var t = inst_28626;
var p = inst_28624;
var idx_predicate_QMARK_ = inst_28627;
var o = inst_28663;
var vec__28619 = inst_28622;
var tag_predicate_QMARK_ = inst_28633;
var temp__5751__auto__ = inst_28707;
var s = inst_28623;
var o_coerce_QMARK_ = inst_28638;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_28763__$1 = state_28763;
var statearr_28785_28873 = state_28763__$1;
(statearr_28785_28873[(2)] = inst_28711);

(statearr_28785_28873[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (21))){
var inst_28659 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28786_28874 = state_28763__$1;
(statearr_28786_28874[(2)] = inst_28659);

(statearr_28786_28874[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (31))){
var state_28763__$1 = state_28763;
var statearr_28787_28875 = state_28763__$1;
(statearr_28787_28875[(2)] = false);

(statearr_28787_28875[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (32))){
var inst_28684 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28788_28876 = state_28763__$1;
(statearr_28788_28876[(2)] = inst_28684);

(statearr_28788_28876[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (40))){
var inst_28627 = (state_28763[(14)]);
var inst_28698 = cljs.core.not(inst_28627);
var state_28763__$1 = state_28763;
if(inst_28698){
var statearr_28789_28877 = state_28763__$1;
(statearr_28789_28877[(1)] = (43));

} else {
var statearr_28790_28878 = state_28763__$1;
(statearr_28790_28878[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (56))){
var inst_28729 = (state_28763[(2)]);
var inst_28730 = fluree.db.util.async.throw_err(inst_28729);
var state_28763__$1 = state_28763;
var statearr_28791_28879 = state_28763__$1;
(statearr_28791_28879[(2)] = inst_28730);

(statearr_28791_28879[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (33))){
var inst_28663 = (state_28763[(8)]);
var inst_28677 = cljs.core.fn_QMARK_(inst_28663);
var inst_28678 = (!(inst_28677));
var state_28763__$1 = state_28763;
var statearr_28792_28880 = state_28763__$1;
(statearr_28792_28880[(2)] = inst_28678);

(statearr_28792_28880[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (13))){
var inst_28625 = (state_28763[(11)]);
var inst_28642 = fluree.db.query.range.tag_string_QMARK_(inst_28625);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28642)){
var statearr_28793_28881 = state_28763__$1;
(statearr_28793_28881[(1)] = (15));

} else {
var statearr_28794_28882 = state_28763__$1;
(statearr_28794_28882[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (22))){
var inst_28655 = (state_28763[(2)]);
var inst_28656 = fluree.db.util.async.throw_err(inst_28655);
var state_28763__$1 = state_28763;
var statearr_28795_28883 = state_28763__$1;
(statearr_28795_28883[(2)] = inst_28656);

(statearr_28795_28883[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (36))){
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28663 = (state_28763[(8)]);
var inst_28623 = (state_28763[(16)]);
var inst_28689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28690 = [inst_28624,inst_28663,inst_28623,inst_28626];
var inst_28691 = (new cljs.core.PersistentVector(null,4,(5),inst_28689,inst_28690,null));
var inst_28692 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_28691,opts);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(39),inst_28692);
} else {
if((state_val_28764 === (41))){
var inst_28624 = (state_28763[(9)]);
var state_28763__$1 = state_28763;
var statearr_28796_28884 = state_28763__$1;
(statearr_28796_28884[(2)] = inst_28624);

(statearr_28796_28884[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (43))){
var inst_28663 = (state_28763[(8)]);
var state_28763__$1 = state_28763;
var statearr_28797_28885 = state_28763__$1;
(statearr_28797_28885[(2)] = inst_28663);

(statearr_28797_28885[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (61))){
var inst_28750 = (state_28763[(7)]);
var inst_28752 = fluree.db.query.range.coerce_tag_flakes(db,inst_28750);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(64),inst_28752);
} else {
if((state_val_28764 === (29))){
var inst_28687 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28687)){
var statearr_28798_28886 = state_28763__$1;
(statearr_28798_28886[(1)] = (36));

} else {
var statearr_28799_28887 = state_28763__$1;
(statearr_28799_28887[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (44))){
var state_28763__$1 = state_28763;
var statearr_28800_28888 = state_28763__$1;
(statearr_28800_28888[(2)] = false);

(statearr_28800_28888[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (6))){
var inst_28624 = (state_28763[(9)]);
var inst_28629 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_28624);
var inst_28630 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_28629);
var state_28763__$1 = state_28763;
var statearr_28801_28889 = state_28763__$1;
(statearr_28801_28889[(2)] = inst_28630);

(statearr_28801_28889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (28))){
var inst_28624 = (state_28763[(9)]);
var state_28763__$1 = state_28763;
var statearr_28802_28890 = state_28763__$1;
(statearr_28802_28890[(2)] = inst_28624);

(statearr_28802_28890[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (64))){
var inst_28754 = (state_28763[(2)]);
var inst_28755 = fluree.db.util.async.throw_err(inst_28754);
var state_28763__$1 = state_28763;
var statearr_28803_28891 = state_28763__$1;
(statearr_28803_28891[(2)] = inst_28755);

(statearr_28803_28891[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (51))){
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28623 = (state_28763[(16)]);
var inst_28713 = (state_28763[(2)]);
var inst_28714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28715 = [inst_28624,inst_28623,null,inst_28626];
var inst_28716 = (new cljs.core.PersistentVector(null,4,(5),inst_28714,inst_28715,null));
var inst_28717 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_28713);
var inst_28718 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_28716,inst_28717);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(52),inst_28718);
} else {
if((state_val_28764 === (25))){
var inst_28633 = (state_28763[(15)]);
var inst_28750 = (state_28763[(2)]);
var state_28763__$1 = (function (){var statearr_28804 = state_28763;
(statearr_28804[(7)] = inst_28750);

return statearr_28804;
})();
if(cljs.core.truth_(inst_28633)){
var statearr_28805_28892 = state_28763__$1;
(statearr_28805_28892[(1)] = (61));

} else {
var statearr_28806_28893 = state_28763__$1;
(statearr_28806_28893[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (34))){
var inst_28627 = (state_28763[(14)]);
var state_28763__$1 = state_28763;
var statearr_28807_28894 = state_28763__$1;
(statearr_28807_28894[(2)] = inst_28627);

(statearr_28807_28894[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (17))){
var inst_28661 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28808_28895 = state_28763__$1;
(statearr_28808_28895[(2)] = inst_28661);

(statearr_28808_28895[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (3))){
var inst_28761 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28763__$1,inst_28761);
} else {
if((state_val_28764 === (12))){
var inst_28625 = (state_28763[(11)]);
var state_28763__$1 = state_28763;
var statearr_28809_28896 = state_28763__$1;
(statearr_28809_28896[(2)] = inst_28625);

(statearr_28809_28896[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (2))){
var inst_28624 = (state_28763[(9)]);
var inst_28622 = (state_28763[(17)]);
var _ = (function (){var statearr_28810 = state_28763;
(statearr_28810[(4)] = cljs.core.cons((5),(state_28763[(4)])));

return statearr_28810;
})();
var inst_28622__$1 = fparts;
var inst_28623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28622__$1,(0),null);
var inst_28624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28622__$1,(1),null);
var inst_28625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28622__$1,(2),null);
var inst_28626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28622__$1,(3),null);
var inst_28627 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_28624__$1);
var state_28763__$1 = (function (){var statearr_28811 = state_28763;
(statearr_28811[(13)] = inst_28626);

(statearr_28811[(11)] = inst_28625);

(statearr_28811[(9)] = inst_28624__$1);

(statearr_28811[(14)] = inst_28627);

(statearr_28811[(16)] = inst_28623);

(statearr_28811[(17)] = inst_28622__$1);

return statearr_28811;
})();
if(cljs.core.truth_(inst_28624__$1)){
var statearr_28812_28897 = state_28763__$1;
(statearr_28812_28897[(1)] = (6));

} else {
var statearr_28813_28898 = state_28763__$1;
(statearr_28813_28898[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (23))){
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28663 = (state_28763[(8)]);
var inst_28623 = (state_28763[(16)]);
var inst_28665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28666 = [inst_28623,inst_28624,inst_28663,inst_28626];
var inst_28667 = (new cljs.core.PersistentVector(null,4,(5),inst_28665,inst_28666,null));
var inst_28668 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_28667,opts);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(26),inst_28668);
} else {
if((state_val_28764 === (47))){
var inst_28624 = (state_28763[(9)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28624)){
var statearr_28814_28899 = state_28763__$1;
(statearr_28814_28899[(1)] = (53));

} else {
var statearr_28815_28900 = state_28763__$1;
(statearr_28815_28900[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (35))){
var inst_28681 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28816_28901 = state_28763__$1;
(statearr_28816_28901[(2)] = inst_28681);

(statearr_28816_28901[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (19))){
var inst_28625 = (state_28763[(11)]);
var inst_28624 = (state_28763[(9)]);
var inst_28651 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_28624);
var inst_28652 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28651),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28625)].join('');
var inst_28653 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_28652);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(22),inst_28653);
} else {
if((state_val_28764 === (57))){
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28663 = (state_28763[(8)]);
var inst_28623 = (state_28763[(16)]);
var inst_28733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28734 = [inst_28663,inst_28624,inst_28623,inst_28626];
var inst_28735 = (new cljs.core.PersistentVector(null,4,(5),inst_28733,inst_28734,null));
var inst_28736 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_28735,opts);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(60),inst_28736);
} else {
if((state_val_28764 === (11))){
var inst_28638 = (state_28763[(12)]);
var inst_28638__$1 = (state_28763[(2)]);
var inst_28639 = cljs.core.not(inst_28638__$1);
var state_28763__$1 = (function (){var statearr_28818 = state_28763;
(statearr_28818[(12)] = inst_28638__$1);

return statearr_28818;
})();
if(inst_28639){
var statearr_28819_28902 = state_28763__$1;
(statearr_28819_28902[(1)] = (12));

} else {
var statearr_28820_28903 = state_28763__$1;
(statearr_28820_28903[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (9))){
var inst_28625 = (state_28763[(11)]);
var inst_28635 = typeof inst_28625 === 'string';
var state_28763__$1 = state_28763;
var statearr_28821_28904 = state_28763__$1;
(statearr_28821_28904[(2)] = inst_28635);

(statearr_28821_28904[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (5))){
var _ = (function (){var statearr_28822 = state_28763;
(statearr_28822[(4)] = cljs.core.rest((state_28763[(4)])));

return statearr_28822;
})();
var state_28763__$1 = state_28763;
var ex28817 = (state_28763__$1[(2)]);
var statearr_28823_28905 = state_28763__$1;
(statearr_28823_28905[(5)] = ex28817);


if((ex28817 instanceof Error)){
var statearr_28824_28906 = state_28763__$1;
(statearr_28824_28906[(1)] = (4));

(statearr_28824_28906[(5)] = null);

} else {
throw ex28817;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (14))){
var inst_28623 = (state_28763[(16)]);
var inst_28663 = (state_28763[(2)]);
var state_28763__$1 = (function (){var statearr_28825 = state_28763;
(statearr_28825[(8)] = inst_28663);

return statearr_28825;
})();
if(cljs.core.truth_(inst_28623)){
var statearr_28826_28907 = state_28763__$1;
(statearr_28826_28907[(1)] = (23));

} else {
var statearr_28827_28908 = state_28763__$1;
(statearr_28827_28908[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (45))){
var inst_28702 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28828_28909 = state_28763__$1;
(statearr_28828_28909[(2)] = inst_28702);

(statearr_28828_28909[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (53))){
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28663 = (state_28763[(8)]);
var inst_28623 = (state_28763[(16)]);
var inst_28724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28725 = [inst_28624,inst_28623,inst_28663,inst_28626];
var inst_28726 = (new cljs.core.PersistentVector(null,4,(5),inst_28724,inst_28725,null));
var inst_28727 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_28726,opts);
var state_28763__$1 = state_28763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28763__$1,(56),inst_28727);
} else {
if((state_val_28764 === (26))){
var inst_28670 = (state_28763[(2)]);
var inst_28671 = fluree.db.util.async.throw_err(inst_28670);
var state_28763__$1 = state_28763;
var statearr_28829_28910 = state_28763__$1;
(statearr_28829_28910[(2)] = inst_28671);

(statearr_28829_28910[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (16))){
var inst_28625 = (state_28763[(11)]);
var inst_28649 = typeof inst_28625 === 'string';
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28649)){
var statearr_28830_28911 = state_28763__$1;
(statearr_28830_28911[(1)] = (19));

} else {
var statearr_28831_28912 = state_28763__$1;
(statearr_28831_28912[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (38))){
var inst_28748 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
var statearr_28832_28913 = state_28763__$1;
(statearr_28832_28913[(2)] = inst_28748);

(statearr_28832_28913[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (30))){
var inst_28627 = (state_28763[(14)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28627)){
var statearr_28833_28914 = state_28763__$1;
(statearr_28833_28914[(1)] = (33));

} else {
var statearr_28834_28915 = state_28763__$1;
(statearr_28834_28915[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (10))){
var inst_28633 = (state_28763[(15)]);
var state_28763__$1 = state_28763;
var statearr_28835_28916 = state_28763__$1;
(statearr_28835_28916[(2)] = inst_28633);

(statearr_28835_28916[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (18))){
var inst_28646 = (state_28763[(2)]);
var inst_28647 = fluree.db.util.async.throw_err(inst_28646);
var state_28763__$1 = state_28763;
var statearr_28836_28917 = state_28763__$1;
(statearr_28836_28917[(2)] = inst_28647);

(statearr_28836_28917[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (52))){
var inst_28720 = (state_28763[(2)]);
var inst_28721 = fluree.db.util.async.throw_err(inst_28720);
var state_28763__$1 = state_28763;
var statearr_28837_28918 = state_28763__$1;
(statearr_28837_28918[(2)] = inst_28721);

(statearr_28837_28918[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (42))){
var inst_28705 = (state_28763[(2)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28705)){
var statearr_28838_28919 = state_28763__$1;
(statearr_28838_28919[(1)] = (46));

} else {
var statearr_28839_28920 = state_28763__$1;
(statearr_28839_28920[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (37))){
var inst_28624 = (state_28763[(9)]);
var state_28763__$1 = state_28763;
if(cljs.core.truth_(inst_28624)){
var statearr_28840_28921 = state_28763__$1;
(statearr_28840_28921[(1)] = (40));

} else {
var statearr_28841_28922 = state_28763__$1;
(statearr_28841_28922[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (63))){
var inst_28758 = (state_28763[(2)]);
var _ = (function (){var statearr_28842 = state_28763;
(statearr_28842[(4)] = cljs.core.rest((state_28763[(4)])));

return statearr_28842;
})();
var state_28763__$1 = state_28763;
var statearr_28843_28923 = state_28763__$1;
(statearr_28843_28923[(2)] = inst_28758);

(statearr_28843_28923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (8))){
var inst_28633 = (state_28763[(15)]);
var inst_28633__$1 = (state_28763[(2)]);
var state_28763__$1 = (function (){var statearr_28844 = state_28763;
(statearr_28844[(15)] = inst_28633__$1);

return statearr_28844;
})();
if(cljs.core.truth_(inst_28633__$1)){
var statearr_28845_28924 = state_28763__$1;
(statearr_28845_28924[(1)] = (9));

} else {
var statearr_28846_28925 = state_28763__$1;
(statearr_28846_28925[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28764 === (49))){
var inst_28707 = (state_28763[(10)]);
var inst_28638 = (state_28763[(12)]);
var inst_28626 = (state_28763[(13)]);
var inst_28624 = (state_28763[(9)]);
var inst_28627 = (state_28763[(14)]);
var inst_28663 = (state_28763[(8)]);
var inst_28633 = (state_28763[(15)]);
var inst_28623 = (state_28763[(16)]);
var inst_28622 = (state_28763[(17)]);
var inst_28709 = (function (){var obj_fn = inst_28707;
var t = inst_28626;
var p = inst_28624;
var idx_predicate_QMARK_ = inst_28627;
var o = inst_28663;
var vec__28619 = inst_28622;
var tag_predicate_QMARK_ = inst_28633;
var temp__5751__auto__ = inst_28707;
var s = inst_28623;
var o_coerce_QMARK_ = inst_28638;
return (function (x){
var and__4149__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4149__auto__;
}
});
})();
var state_28763__$1 = state_28763;
var statearr_28847_28926 = state_28763__$1;
(statearr_28847_28926[(2)] = inst_28709);

(statearr_28847_28926[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_28848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28848[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_28848[(1)] = (1));

return statearr_28848;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_28763){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28763);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28849){var ex__13886__auto__ = e28849;
var statearr_28850_28927 = state_28763;
(statearr_28850_28927[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28763[(4)]))){
var statearr_28851_28928 = state_28763;
(statearr_28851_28928[(1)] = cljs.core.first((state_28763[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28929 = state_28763;
state_28763 = G__28929;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_28763){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_28763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28852 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28852[(6)] = c__13957__auto__);

return statearr_28852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__28931 = arguments.length;
switch (G__28931) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28966){
var state_val_28967 = (state_28966[(1)]);
if((state_val_28967 === (7))){
var inst_28953 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_28954 = ["Invalid collection name: ",inst_28953].join('');
var inst_28955 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_28956 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_28957 = cljs.core.PersistentHashMap.fromArrays(inst_28955,inst_28956);
var inst_28958 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28954,inst_28957);
var inst_28959 = (function(){throw inst_28958})();
var state_28966__$1 = state_28966;
var statearr_28968_28988 = state_28966__$1;
(statearr_28968_28988[(2)] = inst_28959);

(statearr_28968_28988[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (1))){
var state_28966__$1 = state_28966;
var statearr_28969_28989 = state_28966__$1;
(statearr_28969_28989[(2)] = null);

(statearr_28969_28989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (4))){
var inst_28932 = (state_28966[(2)]);
var state_28966__$1 = state_28966;
var statearr_28970_28990 = state_28966__$1;
(statearr_28970_28990[(2)] = inst_28932);

(statearr_28970_28990[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (6))){
var inst_28938 = (state_28966[(7)]);
var inst_28940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28941 = fluree.db.flake.max_subject_id(inst_28938);
var inst_28942 = [inst_28941];
var inst_28943 = (new cljs.core.PersistentVector(null,1,(5),inst_28940,inst_28942,null));
var inst_28944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28945 = fluree.db.flake.min_subject_id(inst_28938);
var inst_28946 = [inst_28945];
var inst_28947 = (new cljs.core.PersistentVector(null,1,(5),inst_28944,inst_28946,null));
var inst_28948 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_28943,cljs.core._LT__EQ_,inst_28947,opts);
var state_28966__$1 = state_28966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28966__$1,(9),inst_28948);
} else {
if((state_val_28967 === (3))){
var inst_28964 = (state_28966[(2)]);
var state_28966__$1 = state_28966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28966__$1,inst_28964);
} else {
if((state_val_28967 === (2))){
var inst_28938 = (state_28966[(7)]);
var _ = (function (){var statearr_28972 = state_28966;
(statearr_28972[(4)] = cljs.core.cons((5),(state_28966[(4)])));

return statearr_28972;
})();
var inst_28938__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_28966__$1 = (function (){var statearr_28973 = state_28966;
(statearr_28973[(7)] = inst_28938__$1);

return statearr_28973;
})();
if(cljs.core.truth_(inst_28938__$1)){
var statearr_28974_28991 = state_28966__$1;
(statearr_28974_28991[(1)] = (6));

} else {
var statearr_28975_28992 = state_28966__$1;
(statearr_28975_28992[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (9))){
var inst_28950 = (state_28966[(2)]);
var inst_28951 = fluree.db.util.async.throw_err(inst_28950);
var state_28966__$1 = state_28966;
var statearr_28976_28993 = state_28966__$1;
(statearr_28976_28993[(2)] = inst_28951);

(statearr_28976_28993[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (5))){
var _ = (function (){var statearr_28977 = state_28966;
(statearr_28977[(4)] = cljs.core.rest((state_28966[(4)])));

return statearr_28977;
})();
var state_28966__$1 = state_28966;
var ex28971 = (state_28966__$1[(2)]);
var statearr_28978_28994 = state_28966__$1;
(statearr_28978_28994[(5)] = ex28971);


var statearr_28979_28995 = state_28966__$1;
(statearr_28979_28995[(1)] = (4));

(statearr_28979_28995[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_28967 === (8))){
var inst_28961 = (state_28966[(2)]);
var _ = (function (){var statearr_28980 = state_28966;
(statearr_28980[(4)] = cljs.core.rest((state_28966[(4)])));

return statearr_28980;
})();
var state_28966__$1 = state_28966;
var statearr_28981_28996 = state_28966__$1;
(statearr_28981_28996[(2)] = inst_28961);

(statearr_28981_28996[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_28982 = [null,null,null,null,null,null,null,null];
(statearr_28982[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_28982[(1)] = (1));

return statearr_28982;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_28966){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28966);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28983){var ex__13886__auto__ = e28983;
var statearr_28984_28997 = state_28966;
(statearr_28984_28997[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28966[(4)]))){
var statearr_28985_28998 = state_28966;
(statearr_28985_28998[(1)] = cljs.core.first((state_28966[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28999 = state_28966;
state_28966 = G__28999;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_28966){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_28966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28986 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28986[(6)] = c__13957__auto__);

return statearr_28986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__29003 = flakes;
var vec__29004 = G__29003;
var seq__29005 = cljs.core.seq(vec__29004);
var first__29006 = cljs.core.first(seq__29005);
var seq__29005__$1 = cljs.core.next(seq__29005);
var flake_SINGLEQUOTE_ = first__29006;
var r = seq__29005__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__29003__$1 = G__29003;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__29012 = G__29003__$1;
var seq__29013 = cljs.core.seq(vec__29012);
var first__29014 = cljs.core.first(seq__29013);
var seq__29013__$1 = cljs.core.next(seq__29013);
var flake_SINGLEQUOTE___$1 = first__29014;
var r__$1 = seq__29013__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e29016){var e = e29016;
return null;
}})();
var map__29015 = cmd_map;
var map__29015__$1 = cljs.core.__destructure_map(map__29015);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29015__$1,cljs.core.cst$kw$expire);
var G__29017 = r__$1;
var G__29018 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__29003__$1 = G__29017;
result_STAR___$1 = G__29018;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__29027 = blocks;
var vec__29028 = G__29027;
var seq__29029 = cljs.core.seq(vec__29028);
var first__29030 = cljs.core.first(seq__29029);
var seq__29029__$1 = cljs.core.next(seq__29029);
var block_SINGLEQUOTE_ = first__29030;
var r = seq__29029__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__29027__$1 = G__29027;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__29035 = G__29027__$1;
var seq__29036 = cljs.core.seq(vec__29035);
var first__29037 = cljs.core.first(seq__29036);
var seq__29036__$1 = cljs.core.next(seq__29036);
var block_SINGLEQUOTE___$1 = first__29037;
var r__$1 = seq__29036__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__29038 = block_SINGLEQUOTE___$1;
var map__29038__$1 = cljs.core.__destructure_map(map__29038);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29038__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29038__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29038__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29019_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29019_SHARP_.p,(2))){
return p1__29019_SHARP_.o;
} else {
return null;
}
});})(G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29020_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29020_SHARP_.p,(1))){
return p1__29020_SHARP_.o;
} else {
return null;
}
});})(G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29021_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29021_SHARP_.p,(5))){
return p1__29021_SHARP_.o;
} else {
return null;
}
});})(G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,instant,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29022_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29022_SHARP_.p,(7))){
return p1__29022_SHARP_.o;
} else {
return null;
}
});})(G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,instant,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29023_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29023_SHARP_.p,(106));
});})(G__29027__$1,result_STAR___$1,map__29038,map__29038__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__29035,seq__29036,first__29037,seq__29036__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29027,vec__29028,seq__29029,first__29030,seq__29029__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__29039 = r__$1;
var G__29040 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__29027__$1 = G__29039;
result_STAR___$1 = G__29040;
continue;
}
break;
}
});
