// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29975_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__29975_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__29979 = coll;
var vec__29980 = G__29979;
var seq__29981 = cljs.core.seq(vec__29980);
var first__29982 = cljs.core.first(seq__29981);
var seq__29981__$1 = cljs.core.next(seq__29981);
var clause = first__29982;
var r = seq__29981__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__29979__$1 = G__29979;
var res__$1 = res;
while(true){
var vec__29986 = G__29979__$1;
var seq__29987 = cljs.core.seq(vec__29986);
var first__29988 = cljs.core.first(seq__29987);
var seq__29987__$1 = cljs.core.next(seq__29987);
var clause__$1 = first__29988;
var r__$1 = seq__29987__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__29989 = r__$1;
var G__29990 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__29979__$1 = G__29989;
res__$1 = G__29990;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__29991){
var map__29992 = p__29991;
var map__29992__$1 = cljs.core.__destructure_map(map__29992);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29992__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__29996 = coll;
var vec__29997 = G__29996;
var seq__29998 = cljs.core.seq(vec__29997);
var first__29999 = cljs.core.first(seq__29998);
var seq__29998__$1 = cljs.core.next(seq__29998);
var clause = first__29999;
var r = seq__29998__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__29996__$1 = G__29996;
var res__$1 = res;
while(true){
var vec__30003 = G__29996__$1;
var seq__30004 = cljs.core.seq(vec__30003);
var first__30005 = cljs.core.first(seq__30004);
var seq__30004__$1 = cljs.core.next(seq__30004);
var clause__$1 = first__30005;
var r__$1 = seq__30004__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__30006 = r__$1;
var G__30007 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__29996__$1 = G__30006;
res__$1 = G__30007;
continue;
} else {
var G__30008 = r__$1;
var G__30009 = res__$2;
G__29996__$1 = G__30008;
res__$1 = G__30009;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__30013 = coll;
var vec__30014 = G__30013;
var seq__30015 = cljs.core.seq(vec__30014);
var first__30016 = cljs.core.first(seq__30015);
var seq__30015__$1 = cljs.core.next(seq__30015);
var clause = first__30016;
var r = seq__30015__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30013__$1 = G__30013;
var res__$1 = res;
while(true){
var vec__30020 = G__30013__$1;
var seq__30021 = cljs.core.seq(vec__30020);
var first__30022 = cljs.core.first(seq__30021);
var seq__30021__$1 = cljs.core.next(seq__30021);
var clause__$1 = first__30022;
var r__$1 = seq__30021__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__30023 = r__$1;
var G__30024 = res__$2;
G__30013__$1 = G__30023;
res__$1 = G__30024;
continue;
} else {
var G__30025 = r__$1;
var G__30026 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__30013__$1 = G__30025;
res__$1 = G__30026;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__30027 = clause;
var G__30027__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__30027):G__30027);
var G__30027__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__30027__$1)
;
var G__30027__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__30027__$2)
;
var G__30027__$4 = goog.string.format("%s .",G__30027__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__30027__$4);
} else {
return G__30027__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__30031 = opts;
var map__30031__$1 = cljs.core.__destructure_map(map__30031);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30031__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30031__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30031__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30031__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30031__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30028_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30028_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__30029_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__30029_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__30030_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__30030_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4160__auto__ = language;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30045){
var state_val_30046 = (state_30045[(1)]);
if((state_val_30046 === (1))){
var inst_30032 = fluree.db.util.core.url_encode(query);
var inst_30033 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30032)].join('');
var inst_30034 = ["User-Agent","Accept"];
var inst_30035 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_30036 = cljs.core.PersistentHashMap.fromArrays(inst_30034,inst_30035);
var inst_30037 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_30038 = [inst_30036,(30000),cljs.core.cst$kw$wikidata];
var inst_30039 = cljs.core.PersistentHashMap.fromArrays(inst_30037,inst_30038);
var inst_30040 = fluree.db.util.xhttp.get(inst_30033,inst_30039);
var state_30045__$1 = state_30045;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30045__$1,(2),inst_30040);
} else {
if((state_val_30046 === (2))){
var inst_30042 = (state_30045[(2)]);
var inst_30043 = fluree.db.util.async.throw_err(inst_30042);
var state_30045__$1 = state_30045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30045__$1,inst_30043);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0 = (function (){
var statearr_30047 = [null,null,null,null,null,null,null];
(statearr_30047[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__);

(statearr_30047[(1)] = (1));

return statearr_30047;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1 = (function (state_30045){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30045);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30048){var ex__13886__auto__ = e30048;
var statearr_30049_30052 = state_30045;
(statearr_30049_30052[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30045[(4)]))){
var statearr_30050_30053 = state_30045;
(statearr_30050_30053[(1)] = cljs.core.first((state_30045[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30054 = state_30045;
state_30045 = G__30054;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__ = function(state_30045){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1.call(this,state_30045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30051 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30051[(6)] = c__13957__auto__);

return statearr_30051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30072){
var state_val_30073 = (state_30072[(1)]);
if((state_val_30073 === (1))){
var inst_30055 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_30072__$1 = state_30072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30072__$1,(2),inst_30055);
} else {
if((state_val_30073 === (2))){
var inst_30058 = (state_30072[(7)]);
var inst_30057 = (state_30072[(2)]);
var inst_30058__$1 = fluree.db.util.async.throw_err(inst_30057);
var inst_30059 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_30058__$1);
var inst_30060 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_30059);
var state_30072__$1 = (function (){var statearr_30074 = state_30072;
(statearr_30074[(7)] = inst_30058__$1);

return statearr_30074;
})();
if(inst_30060){
var statearr_30075_30084 = state_30072__$1;
(statearr_30075_30084[(1)] = (3));

} else {
var statearr_30076_30085 = state_30072__$1;
(statearr_30076_30085[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30073 === (3))){
var inst_30058 = (state_30072[(7)]);
var state_30072__$1 = state_30072;
var statearr_30077_30086 = state_30072__$1;
(statearr_30077_30086[(2)] = inst_30058);

(statearr_30077_30086[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30073 === (4))){
var inst_30058 = (state_30072[(7)]);
var inst_30063 = (function (){var body = inst_30058;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_30064 = cljs.core.second(inst_30058);
var inst_30065 = cljs.core.second(inst_30064);
var inst_30066 = cljs.core.first(inst_30065);
var inst_30067 = cljs.core.second(inst_30066);
var inst_30068 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_30063,inst_30067);
var state_30072__$1 = state_30072;
var statearr_30078_30087 = state_30072__$1;
(statearr_30078_30087[(2)] = inst_30068);

(statearr_30078_30087[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30073 === (5))){
var inst_30070 = (state_30072[(2)]);
var state_30072__$1 = state_30072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30072__$1,inst_30070);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0 = (function (){
var statearr_30079 = [null,null,null,null,null,null,null,null];
(statearr_30079[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__);

(statearr_30079[(1)] = (1));

return statearr_30079;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1 = (function (state_30072){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30072);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30080){var ex__13886__auto__ = e30080;
var statearr_30081_30088 = state_30072;
(statearr_30081_30088[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30072[(4)]))){
var statearr_30082_30089 = state_30072;
(statearr_30082_30089[(1)] = cljs.core.first((state_30072[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30090 = state_30072;
state_30072 = G__30090;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__ = function(state_30072){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1.call(this,state_30072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30083 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30083[(6)] = c__13957__auto__);

return statearr_30083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30091_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30091_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30092_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30092_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30093_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__30093_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__30093_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__30093_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30139){
var state_val_30140 = (state_30139[(1)]);
if((state_val_30140 === (7))){
var inst_30104 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_30139__$1 = state_30139;
var statearr_30141_30169 = state_30139__$1;
(statearr_30141_30169[(2)] = inst_30104);

(statearr_30141_30169[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (1))){
var state_30139__$1 = state_30139;
var statearr_30142_30170 = state_30139__$1;
(statearr_30142_30170[(2)] = null);

(statearr_30142_30170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (4))){
var inst_30094 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
var statearr_30143_30171 = state_30139__$1;
(statearr_30143_30171[(2)] = inst_30094);

(statearr_30143_30171[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (15))){
var inst_30113 = (state_30139[(7)]);
var inst_30112 = (state_30139[(8)]);
var inst_30118 = (state_30139[(9)]);
var inst_30123 = (state_30139[(2)]);
var inst_30124 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_30118,(0),inst_30123);
var inst_30125 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30126 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_30112);
var inst_30127 = [inst_30113,inst_30126];
var inst_30128 = cljs.core.PersistentHashMap.fromArrays(inst_30125,inst_30127);
var inst_30129 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30124,inst_30128);
var inst_30130 = (function(){throw inst_30129})();
var state_30139__$1 = state_30139;
var statearr_30144_30172 = state_30139__$1;
(statearr_30144_30172[(2)] = inst_30130);

(statearr_30144_30172[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (13))){
var inst_30117 = (state_30139[(10)]);
var state_30139__$1 = state_30139;
var statearr_30145_30173 = state_30139__$1;
(statearr_30145_30173[(2)] = inst_30117);

(statearr_30145_30173[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (6))){
var state_30139__$1 = state_30139;
var statearr_30146_30174 = state_30139__$1;
(statearr_30146_30174[(2)] = null);

(statearr_30146_30174[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (3))){
var inst_30137 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30139__$1,inst_30137);
} else {
if((state_val_30140 === (12))){
var inst_30134 = (state_30139[(2)]);
var _ = (function (){var statearr_30147 = state_30139;
(statearr_30147[(4)] = cljs.core.rest((state_30139[(4)])));

return statearr_30147;
})();
var state_30139__$1 = state_30139;
var statearr_30148_30175 = state_30139__$1;
(statearr_30148_30175[(2)] = inst_30134);

(statearr_30148_30175[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (2))){
var _ = (function (){var statearr_30149 = state_30139;
(statearr_30149[(4)] = cljs.core.cons((5),(state_30139[(4)])));

return statearr_30149;
})();
var inst_30101 = cljs.core.empty_QMARK_(matching_vars);
var state_30139__$1 = state_30139;
if(inst_30101){
var statearr_30150_30176 = state_30139__$1;
(statearr_30150_30176[(1)] = (6));

} else {
var statearr_30151_30177 = state_30139__$1;
(statearr_30151_30177[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (11))){
var inst_30112 = (state_30139[(8)]);
var inst_30132 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_30112,all_vars);
var state_30139__$1 = state_30139;
var statearr_30153_30178 = state_30139__$1;
(statearr_30153_30178[(2)] = inst_30132);

(statearr_30153_30178[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (9))){
var inst_30113 = (state_30139[(7)]);
var inst_30112 = (state_30139[(8)]);
var inst_30110 = (state_30139[(2)]);
var inst_30111 = fluree.db.util.async.throw_err(inst_30110);
var inst_30112__$1 = cljs.core.__destructure_map(inst_30111);
var inst_30113__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30112__$1,cljs.core.cst$kw$status);
var inst_30114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30112__$1,cljs.core.cst$kw$message);
var inst_30115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_30113__$1);
var state_30139__$1 = (function (){var statearr_30154 = state_30139;
(statearr_30154[(11)] = inst_30114);

(statearr_30154[(7)] = inst_30113__$1);

(statearr_30154[(8)] = inst_30112__$1);

return statearr_30154;
})();
if(inst_30115){
var statearr_30155_30179 = state_30139__$1;
(statearr_30155_30179[(1)] = (10));

} else {
var statearr_30156_30180 = state_30139__$1;
(statearr_30156_30180[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (5))){
var _ = (function (){var statearr_30157 = state_30139;
(statearr_30157[(4)] = cljs.core.rest((state_30139[(4)])));

return statearr_30157;
})();
var state_30139__$1 = state_30139;
var ex30152 = (state_30139__$1[(2)]);
var statearr_30158_30181 = state_30139__$1;
(statearr_30158_30181[(5)] = ex30152);


if((ex30152 instanceof Error)){
var statearr_30159_30182 = state_30139__$1;
(statearr_30159_30182[(1)] = (4));

(statearr_30159_30182[(5)] = null);

} else {
throw ex30152;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (14))){
var state_30139__$1 = state_30139;
var statearr_30160_30183 = state_30139__$1;
(statearr_30160_30183[(2)] = (1000));

(statearr_30160_30183[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (10))){
var inst_30114 = (state_30139[(11)]);
var inst_30117 = (state_30139[(10)]);
var inst_30112 = (state_30139[(8)]);
var inst_30117__$1 = cljs.core.count(inst_30114);
var inst_30118 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_30112);
var inst_30119 = (inst_30117__$1 < (1000));
var state_30139__$1 = (function (){var statearr_30161 = state_30139;
(statearr_30161[(10)] = inst_30117__$1);

(statearr_30161[(9)] = inst_30118);

return statearr_30161;
})();
if(cljs.core.truth_(inst_30119)){
var statearr_30162_30184 = state_30139__$1;
(statearr_30162_30184[(1)] = (13));

} else {
var statearr_30163_30185 = state_30139__$1;
(statearr_30163_30185[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30140 === (8))){
var inst_30106 = (state_30139[(2)]);
var inst_30107 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_30106,optional_clauses);
var inst_30108 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_30107);
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30139__$1,(9),inst_30108);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_30164 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30164[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__);

(statearr_30164[(1)] = (1));

return statearr_30164;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1 = (function (state_30139){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30139);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30165){var ex__13886__auto__ = e30165;
var statearr_30166_30186 = state_30139;
(statearr_30166_30186[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30139[(4)]))){
var statearr_30167_30187 = state_30139;
(statearr_30167_30187[(1)] = cljs.core.first((state_30139[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30188 = state_30139;
state_30139 = G__30188;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__ = function(state_30139){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1.call(this,state_30139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30168 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30168[(6)] = c__13957__auto__);

return statearr_30168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
