// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e30191){var e = e30191;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__30192_SHARP_){
var or__4160__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__30192_SHARP_);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__30192_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__30192_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__30192_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30193_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30193_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30194_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30194_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4149__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4160__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__30199 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30199,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30199,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30195_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30195_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__30202 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30202,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30202,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4160__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30196_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30196_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30197_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30197_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__30198_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30198_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30205_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__30205_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4160__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (add_amount > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = fuel;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4149__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__30206 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__30206) : intersecting_vars.call(null,G__30206));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__30209,optional_QMARK_,fuel,max_fuel){
var map__30210 = p__30209;
var map__30210__$1 = cljs.core.__destructure_map(map__30210);
var res = map__30210__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30210__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30276){
var state_val_30277 = (state_30276[(1)]);
if((state_val_30277 === (7))){
var inst_30265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30266 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_30267 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30266,clause);
var inst_30268 = [null,inst_30267];
var inst_30269 = (new cljs.core.PersistentVector(null,2,(5),inst_30265,inst_30268,null));
var state_30276__$1 = state_30276;
var statearr_30278_30306 = state_30276__$1;
(statearr_30278_30306[(2)] = inst_30269);

(statearr_30278_30306[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (1))){
var state_30276__$1 = state_30276;
var statearr_30279_30307 = state_30276__$1;
(statearr_30279_30307[(2)] = null);

(statearr_30279_30307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (4))){
var inst_30211 = (state_30276[(2)]);
var state_30276__$1 = state_30276;
var statearr_30280_30308 = state_30276__$1;
(statearr_30280_30308[(2)] = inst_30211);

(statearr_30280_30308[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (15))){
var inst_30254 = (state_30276[(2)]);
var inst_30255 = fluree.db.util.async.throw_err(inst_30254);
var inst_30256 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_30255);
var inst_30257 = cljs.core.count(inst_30256);
var inst_30258 = fluree.db.query.analytical.add_fuel(inst_30257,fuel,max_fuel);
var inst_30259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30260 = [inst_30255,r];
var inst_30261 = (new cljs.core.PersistentVector(null,2,(5),inst_30259,inst_30260,null));
var state_30276__$1 = (function (){var statearr_30281 = state_30276;
(statearr_30281[(7)] = inst_30258);

return statearr_30281;
})();
var statearr_30282_30309 = state_30276__$1;
(statearr_30282_30309[(2)] = inst_30261);

(statearr_30282_30309[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (13))){
var inst_30220 = (state_30276[(8)]);
var inst_30233 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30234 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_30233);
var inst_30235 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_30220);
var inst_30236 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30235);
var inst_30237 = cljs.core.set(inst_30236);
var inst_30238 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_30234);
var inst_30239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30238);
var inst_30240 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30237,inst_30239);
var inst_30241 = (function (){var all_wd = inst_30220;
var optional = inst_30234;
var all_wd_vars = inst_30237;
var all_vars = inst_30240;
return (function (p1__30207_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__30207_SHARP_) : all_vars.call(null,p1__30207_SHARP_));
});
})();
var inst_30242 = cljs.core.keys(vars);
var inst_30243 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30241,inst_30242);
var inst_30244 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_30243);
var inst_30245 = cljs.core.set(inst_30244);
var inst_30246 = (function (){var all_wd = inst_30220;
var optional = inst_30234;
var all_wd_vars = inst_30237;
var all_vars = inst_30240;
var intersecting_vars = inst_30245;
return (function (p1__30208_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__30208_SHARP_);
});
})();
var inst_30247 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30246,inst_30220);
var inst_30248 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30247);
var inst_30249 = fluree.db.query.analytical.select_from_tuples(inst_30248,res);
var inst_30250 = fluree.db.query.analytical.replace_vars_wikidata(inst_30220,inst_30245,vars);
var inst_30251 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_30245,inst_30240);
var inst_30252 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_30250,inst_30248,inst_30249,inst_30251,inst_30234);
var state_30276__$1 = state_30276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30276__$1,(15),inst_30252);
} else {
if((state_val_30277 === (6))){
var inst_30221 = (state_30276[(9)]);
var inst_30219 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30220 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_30219);
var inst_30221__$1 = optional_QMARK_;
var state_30276__$1 = (function (){var statearr_30283 = state_30276;
(statearr_30283[(9)] = inst_30221__$1);

(statearr_30283[(8)] = inst_30220);

return statearr_30283;
})();
if(cljs.core.truth_(inst_30221__$1)){
var statearr_30284_30310 = state_30276__$1;
(statearr_30284_30310[(1)] = (9));

} else {
var statearr_30285_30311 = state_30276__$1;
(statearr_30285_30311[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (3))){
var inst_30274 = (state_30276[(2)]);
var state_30276__$1 = state_30276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30276__$1,inst_30274);
} else {
if((state_val_30277 === (12))){
var inst_30229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30230 = [null,r];
var inst_30231 = (new cljs.core.PersistentVector(null,2,(5),inst_30229,inst_30230,null));
var state_30276__$1 = state_30276;
var statearr_30286_30312 = state_30276__$1;
(statearr_30286_30312[(2)] = inst_30231);

(statearr_30286_30312[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (2))){
var _ = (function (){var statearr_30287 = state_30276;
(statearr_30287[(4)] = cljs.core.cons((5),(state_30276[(4)])));

return statearr_30287;
})();
var inst_30217 = (r == null);
var state_30276__$1 = state_30276;
if(cljs.core.truth_(inst_30217)){
var statearr_30288_30313 = state_30276__$1;
(statearr_30288_30313[(1)] = (6));

} else {
var statearr_30289_30314 = state_30276__$1;
(statearr_30289_30314[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (11))){
var inst_30227 = (state_30276[(2)]);
var state_30276__$1 = state_30276;
if(cljs.core.truth_(inst_30227)){
var statearr_30291_30315 = state_30276__$1;
(statearr_30291_30315[(1)] = (12));

} else {
var statearr_30292_30316 = state_30276__$1;
(statearr_30292_30316[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (9))){
var inst_30220 = (state_30276[(8)]);
var inst_30223 = cljs.core.empty_QMARK_(inst_30220);
var inst_30224 = (!(inst_30223));
var state_30276__$1 = state_30276;
var statearr_30293_30317 = state_30276__$1;
(statearr_30293_30317[(2)] = inst_30224);

(statearr_30293_30317[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (5))){
var _ = (function (){var statearr_30294 = state_30276;
(statearr_30294[(4)] = cljs.core.rest((state_30276[(4)])));

return statearr_30294;
})();
var state_30276__$1 = state_30276;
var ex30290 = (state_30276__$1[(2)]);
var statearr_30295_30318 = state_30276__$1;
(statearr_30295_30318[(5)] = ex30290);


if((ex30290 instanceof Error)){
var statearr_30296_30319 = state_30276__$1;
(statearr_30296_30319[(1)] = (4));

(statearr_30296_30319[(5)] = null);

} else {
throw ex30290;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (14))){
var inst_30263 = (state_30276[(2)]);
var state_30276__$1 = state_30276;
var statearr_30297_30320 = state_30276__$1;
(statearr_30297_30320[(2)] = inst_30263);

(statearr_30297_30320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (10))){
var inst_30221 = (state_30276[(9)]);
var state_30276__$1 = state_30276;
var statearr_30298_30321 = state_30276__$1;
(statearr_30298_30321[(2)] = inst_30221);

(statearr_30298_30321[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30277 === (8))){
var inst_30271 = (state_30276[(2)]);
var _ = (function (){var statearr_30299 = state_30276;
(statearr_30299[(4)] = cljs.core.rest((state_30276[(4)])));

return statearr_30299;
})();
var state_30276__$1 = state_30276;
var statearr_30300_30322 = state_30276__$1;
(statearr_30300_30322[(2)] = inst_30271);

(statearr_30300_30322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_30301 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30301[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__);

(statearr_30301[(1)] = (1));

return statearr_30301;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1 = (function (state_30276){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30276);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30302){var ex__13886__auto__ = e30302;
var statearr_30303_30323 = state_30276;
(statearr_30303_30323[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30276[(4)]))){
var statearr_30304_30324 = state_30276;
(statearr_30304_30324[(1)] = cljs.core.first((state_30276[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30325 = state_30276;
state_30276 = G__30325;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__ = function(state_30276){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1.call(this,state_30276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30305 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30305[(6)] = c__13957__auto__);

return statearr_30305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__30327 = arguments.length;
switch (G__30327) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30421){
var state_val_30422 = (state_30421[(1)]);
if((state_val_30422 === (7))){
var inst_30334 = (state_30421[(7)]);
var inst_30344 = clojure.string.starts_with_QMARK_(inst_30334,"$fdb");
var state_30421__$1 = state_30421;
if(inst_30344){
var statearr_30423_30472 = state_30421__$1;
(statearr_30423_30472[(1)] = (9));

} else {
var statearr_30424_30473 = state_30421__$1;
(statearr_30424_30473[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (20))){
var state_30421__$1 = state_30421;
var statearr_30425_30474 = state_30421__$1;
(statearr_30425_30474[(2)] = null);

(statearr_30425_30474[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (27))){
var inst_30384 = (state_30421[(8)]);
var state_30421__$1 = state_30421;
var statearr_30426_30475 = state_30421__$1;
(statearr_30426_30475[(2)] = inst_30384);

(statearr_30426_30475[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (1))){
var state_30421__$1 = state_30421;
var statearr_30427_30476 = state_30421__$1;
(statearr_30427_30476[(2)] = null);

(statearr_30427_30476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (24))){
var inst_30407 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
var statearr_30428_30477 = state_30421__$1;
(statearr_30428_30477[(2)] = inst_30407);

(statearr_30428_30477[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (4))){
var inst_30328 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
var statearr_30429_30478 = state_30421__$1;
(statearr_30429_30478[(2)] = inst_30328);

(statearr_30429_30478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (15))){
var inst_30351 = (state_30421[(9)]);
var inst_30357 = (state_30421[(2)]);
var inst_30358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30359 = cljs.core.PersistentVector.EMPTY;
var inst_30360 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_30361 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30359,inst_30360);
var inst_30362 = [inst_30351,inst_30361];
var inst_30363 = (new cljs.core.PersistentVector(null,2,(5),inst_30358,inst_30362,null));
var state_30421__$1 = (function (){var statearr_30430 = state_30421;
(statearr_30430[(10)] = inst_30357);

return statearr_30430;
})();
var statearr_30431_30479 = state_30421__$1;
(statearr_30431_30479[(2)] = inst_30363);

(statearr_30431_30479[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (21))){
var inst_30410 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
var statearr_30432_30480 = state_30421__$1;
(statearr_30432_30480[(2)] = inst_30410);

(statearr_30432_30480[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (13))){
var inst_30351 = (state_30421[(9)]);
var inst_30354 = (function(){throw inst_30351})();
var state_30421__$1 = state_30421;
var statearr_30433_30481 = state_30421__$1;
(statearr_30433_30481[(2)] = inst_30354);

(statearr_30433_30481[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (22))){
var inst_30375 = (state_30421[(11)]);
var inst_30373 = (state_30421[(12)]);
var inst_30377 = fluree.db.query.analytical.parse_block_from_source(inst_30373);
var inst_30378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30379 = [cljs.core.cst$kw$sources,inst_30375];
var inst_30380 = (new cljs.core.PersistentVector(null,2,(5),inst_30378,inst_30379,null));
var inst_30381 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_30380);
var state_30421__$1 = (function (){var statearr_30434 = state_30421;
(statearr_30434[(13)] = inst_30377);

return statearr_30434;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30421__$1,(25),inst_30381);
} else {
if((state_val_30422 === (29))){
var inst_30388 = (state_30421[(2)]);
var inst_30389 = fluree.db.util.async.throw_err(inst_30388);
var state_30421__$1 = state_30421;
var statearr_30435_30482 = state_30421__$1;
(statearr_30435_30482[(2)] = inst_30389);

(statearr_30435_30482[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (6))){
var inst_30337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30338 = cljs.core.PersistentVector.EMPTY;
var inst_30339 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_30340 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30338,inst_30339);
var inst_30341 = [db,inst_30340];
var inst_30342 = (new cljs.core.PersistentVector(null,2,(5),inst_30337,inst_30341,null));
var state_30421__$1 = state_30421;
var statearr_30436_30483 = state_30421__$1;
(statearr_30436_30483[(2)] = inst_30342);

(statearr_30436_30483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (28))){
var inst_30392 = (state_30421[(2)]);
var inst_30393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30394 = cljs.core.PersistentVector.EMPTY;
var inst_30395 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_30396 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30394,inst_30395);
var inst_30397 = [inst_30392,inst_30396];
var inst_30398 = (new cljs.core.PersistentVector(null,2,(5),inst_30393,inst_30397,null));
var state_30421__$1 = state_30421;
var statearr_30437_30484 = state_30421__$1;
(statearr_30437_30484[(2)] = inst_30398);

(statearr_30437_30484[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (25))){
var inst_30377 = (state_30421[(13)]);
var inst_30383 = (state_30421[(2)]);
var inst_30384 = fluree.db.util.async.throw_err(inst_30383);
var state_30421__$1 = (function (){var statearr_30438 = state_30421;
(statearr_30438[(8)] = inst_30384);

return statearr_30438;
})();
if(cljs.core.truth_(inst_30377)){
var statearr_30439_30485 = state_30421__$1;
(statearr_30439_30485[(1)] = (26));

} else {
var statearr_30440_30486 = state_30421__$1;
(statearr_30440_30486[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (17))){
var state_30421__$1 = state_30421;
var statearr_30441_30487 = state_30421__$1;
(statearr_30441_30487[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (3))){
var inst_30419 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30421__$1,inst_30419);
} else {
if((state_val_30422 === (12))){
var inst_30351 = (state_30421[(9)]);
var inst_30350 = (state_30421[(2)]);
var inst_30351__$1 = fluree.db.util.async.throw_err(inst_30350);
var inst_30352 = fluree.db.util.core.exception_QMARK_(inst_30351__$1);
var state_30421__$1 = (function (){var statearr_30443 = state_30421;
(statearr_30443[(9)] = inst_30351__$1);

return statearr_30443;
})();
if(inst_30352){
var statearr_30444_30488 = state_30421__$1;
(statearr_30444_30488[(1)] = (13));

} else {
var statearr_30445_30489 = state_30421__$1;
(statearr_30445_30489[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (2))){
var inst_30334 = (state_30421[(7)]);
var _ = (function (){var statearr_30446 = state_30421;
(statearr_30446[(4)] = cljs.core.cons((5),(state_30421[(4)])));

return statearr_30446;
})();
var inst_30334__$1 = cljs.core.first(clause);
var inst_30335 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_30334__$1);
var state_30421__$1 = (function (){var statearr_30447 = state_30421;
(statearr_30447[(7)] = inst_30334__$1);

return statearr_30447;
})();
if(inst_30335){
var statearr_30448_30490 = state_30421__$1;
(statearr_30448_30490[(1)] = (6));

} else {
var statearr_30449_30491 = state_30421__$1;
(statearr_30449_30491[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (23))){
var inst_30334 = (state_30421[(7)]);
var inst_30400 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30334)," is not supported in Fluree"].join('');
var inst_30401 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30402 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_30403 = cljs.core.PersistentHashMap.fromArrays(inst_30401,inst_30402);
var inst_30404 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30400,inst_30403);
var inst_30405 = (function(){throw inst_30404})();
var state_30421__$1 = state_30421;
var statearr_30450_30492 = state_30421__$1;
(statearr_30450_30492[(2)] = inst_30405);

(statearr_30450_30492[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (19))){
var inst_30375 = (state_30421[(11)]);
var inst_30334 = (state_30421[(7)]);
var inst_30372 = fluree.db.query.analytical.isolate_source_name(inst_30334);
var inst_30373 = fluree.db.query.analytical.isolate_source_block(inst_30334);
var inst_30374 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_30372);
var inst_30375__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_30374);
var state_30421__$1 = (function (){var statearr_30451 = state_30421;
(statearr_30451[(11)] = inst_30375__$1);

(statearr_30451[(12)] = inst_30373);

return statearr_30451;
})();
if(cljs.core.truth_(inst_30375__$1)){
var statearr_30452_30493 = state_30421__$1;
(statearr_30452_30493[(1)] = (22));

} else {
var statearr_30453_30494 = state_30421__$1;
(statearr_30453_30494[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (11))){
var inst_30414 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
var statearr_30455_30495 = state_30421__$1;
(statearr_30455_30495[(2)] = inst_30414);

(statearr_30455_30495[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (9))){
var inst_30334 = (state_30421[(7)]);
var inst_30346 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_30334,(4));
var inst_30347 = fluree.db.query.analytical.parse_block_from_source(inst_30346);
var inst_30348 = fluree.db.time_travel.as_of_block(db,inst_30347);
var state_30421__$1 = state_30421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30421__$1,(12),inst_30348);
} else {
if((state_val_30422 === (5))){
var _ = (function (){var statearr_30456 = state_30421;
(statearr_30456[(4)] = cljs.core.rest((state_30421[(4)])));

return statearr_30456;
})();
var state_30421__$1 = state_30421;
var ex30454 = (state_30421__$1[(2)]);
var statearr_30457_30496 = state_30421__$1;
(statearr_30457_30496[(5)] = ex30454);


if((ex30454 instanceof Error)){
var statearr_30458_30497 = state_30421__$1;
(statearr_30458_30497[(1)] = (4));

(statearr_30458_30497[(5)] = null);

} else {
throw ex30454;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (14))){
var state_30421__$1 = state_30421;
var statearr_30459_30498 = state_30421__$1;
(statearr_30459_30498[(2)] = null);

(statearr_30459_30498[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (26))){
var inst_30377 = (state_30421[(13)]);
var inst_30384 = (state_30421[(8)]);
var inst_30386 = fluree.db.time_travel.as_of_block(inst_30384,inst_30377);
var state_30421__$1 = state_30421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30421__$1,(29),inst_30386);
} else {
if((state_val_30422 === (16))){
var inst_30367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30368 = ["$wd",clause];
var inst_30369 = (new cljs.core.PersistentVector(null,2,(5),inst_30367,inst_30368,null));
var state_30421__$1 = state_30421;
var statearr_30460_30499 = state_30421__$1;
(statearr_30460_30499[(2)] = inst_30369);

(statearr_30460_30499[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (10))){
var inst_30334 = (state_30421[(7)]);
var inst_30365 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_30334);
var state_30421__$1 = state_30421;
if(inst_30365){
var statearr_30461_30500 = state_30421__$1;
(statearr_30461_30500[(1)] = (16));

} else {
var statearr_30462_30501 = state_30421__$1;
(statearr_30462_30501[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (18))){
var inst_30412 = (state_30421[(2)]);
var state_30421__$1 = state_30421;
var statearr_30463_30502 = state_30421__$1;
(statearr_30463_30502[(2)] = inst_30412);

(statearr_30463_30502[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30422 === (8))){
var inst_30416 = (state_30421[(2)]);
var _ = (function (){var statearr_30464 = state_30421;
(statearr_30464[(4)] = cljs.core.rest((state_30421[(4)])));

return statearr_30464;
})();
var state_30421__$1 = state_30421;
var statearr_30465_30503 = state_30421__$1;
(statearr_30465_30503[(2)] = inst_30416);

(statearr_30465_30503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__13883__auto__ = null;
var fluree$db$query$analytical$state_machine__13883__auto____0 = (function (){
var statearr_30466 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30466[(0)] = fluree$db$query$analytical$state_machine__13883__auto__);

(statearr_30466[(1)] = (1));

return statearr_30466;
});
var fluree$db$query$analytical$state_machine__13883__auto____1 = (function (state_30421){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30421);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30467){var ex__13886__auto__ = e30467;
var statearr_30468_30504 = state_30421;
(statearr_30468_30504[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30421[(4)]))){
var statearr_30469_30505 = state_30421;
(statearr_30469_30505[(1)] = cljs.core.first((state_30421[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30506 = state_30421;
state_30421 = G__30506;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__13883__auto__ = function(state_30421){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__13883__auto____1.call(this,state_30421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__13883__auto____0;
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__13883__auto____1;
return fluree$db$query$analytical$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30470 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30470[(6)] = c__13957__auto__);

return statearr_30470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__30507){
var vec__30508 = p__30507;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30508,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30508,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30511_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__30511_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__30515 = subjects;
var vec__30516 = G__30515;
var seq__30517 = cljs.core.seq(vec__30516);
var first__30518 = cljs.core.first(seq__30517);
var seq__30517__$1 = cljs.core.next(seq__30517);
var subject = first__30518;
var r = seq__30517__$1;
var acc = expanded_map;
var G__30515__$1 = G__30515;
var acc__$1 = acc;
while(true){
var vec__30522 = G__30515__$1;
var seq__30523 = cljs.core.seq(vec__30522);
var first__30524 = cljs.core.first(seq__30523);
var seq__30523__$1 = cljs.core.next(seq__30523);
var subject__$1 = first__30524;
var r__$1 = seq__30523__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__30525 = r__$1;
var G__30526 = acc__$2;
G__30515__$1 = G__30525;
acc__$1 = G__30526;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__30515__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4160__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__30515__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__30515__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__30515__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__30515__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__30515__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__30522,seq__30523,first__30524,seq__30523__$1,subject__$1,r__$1,acc__$2,G__30515,vec__30516,seq__30517,first__30518,seq__30517__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__30527 = r__$1;
var G__30528 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__30515__$1 = G__30527;
acc__$1 = G__30528;
continue;
} else {
var G__30529 = subjects;
var G__30530 = acc_STAR_;
G__30515__$1 = G__30529;
acc__$1 = G__30530;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30531_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__30531_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30622){
var state_val_30623 = (state_30622[(1)]);
if((state_val_30623 === (7))){
var state_30622__$1 = state_30622;
var statearr_30624_30670 = state_30622__$1;
(statearr_30624_30670[(2)] = (100));

(statearr_30624_30670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (20))){
var inst_30571 = (state_30622[(7)]);
var state_30622__$1 = state_30622;
var statearr_30625_30671 = state_30622__$1;
(statearr_30625_30671[(2)] = inst_30571);

(statearr_30625_30671[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (1))){
var state_30622__$1 = state_30622;
var statearr_30626_30672 = state_30622__$1;
(statearr_30626_30672[(2)] = null);

(statearr_30626_30672[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (24))){
var inst_30609 = (state_30622[(8)]);
var inst_30610 = (state_30622[(9)]);
var inst_30608 = (state_30622[(10)]);
var inst_30543 = (state_30622[(11)]);
var inst_30613 = (function (){var max_depth = inst_30543;
var recur_map__$1 = inst_30609;
var subjects = inst_30608;
var tuples = inst_30610;
return (function (p1__30532_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__30532_SHARP_)],null));
});
})();
var inst_30614 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30613,inst_30610);
var inst_30615 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_30614);
var state_30622__$1 = state_30622;
var statearr_30627_30673 = state_30622__$1;
(statearr_30627_30673[(2)] = inst_30615);

(statearr_30627_30673[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (4))){
var inst_30533 = (state_30622[(2)]);
var state_30622__$1 = state_30622;
var statearr_30628_30674 = state_30622__$1;
(statearr_30628_30674[(2)] = inst_30533);

(statearr_30628_30674[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (15))){
var inst_30556 = (state_30622[(12)]);
var inst_30567 = cljs.core.PersistentVector.EMPTY;
var inst_30568 = cljs.core.seq(inst_30556);
var inst_30569 = cljs.core.first(inst_30568);
var inst_30570 = cljs.core.next(inst_30568);
var inst_30571 = inst_30567;
var inst_30572 = inst_30556;
var state_30622__$1 = (function (){var statearr_30629 = state_30622;
(statearr_30629[(13)] = inst_30569);

(statearr_30629[(14)] = inst_30570);

(statearr_30629[(7)] = inst_30571);

(statearr_30629[(15)] = inst_30572);

return statearr_30629;
})();
var statearr_30630_30675 = state_30622__$1;
(statearr_30630_30675[(2)] = null);

(statearr_30630_30675[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (21))){
var inst_30592 = (state_30622[(2)]);
var state_30622__$1 = state_30622;
var statearr_30631_30676 = state_30622__$1;
(statearr_30631_30676[(2)] = inst_30592);

(statearr_30631_30676[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (13))){
var inst_30605 = (state_30622[(2)]);
var state_30622__$1 = state_30622;
var statearr_30632_30677 = state_30622__$1;
(statearr_30632_30677[(2)] = inst_30605);

(statearr_30632_30677[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (22))){
var inst_30579 = (state_30622[(16)]);
var inst_30571 = (state_30622[(7)]);
var inst_30586 = (state_30622[(2)]);
var inst_30587 = fluree.db.util.async.throw_err(inst_30586);
var inst_30588 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30571,inst_30587);
var inst_30571__$1 = inst_30588;
var inst_30572 = inst_30579;
var state_30622__$1 = (function (){var statearr_30633 = state_30622;
(statearr_30633[(7)] = inst_30571__$1);

(statearr_30633[(15)] = inst_30572);

return statearr_30633;
})();
var statearr_30634_30678 = state_30622__$1;
(statearr_30634_30678[(2)] = null);

(statearr_30634_30678[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (6))){
var inst_30539 = (state_30622[(17)]);
var state_30622__$1 = state_30622;
var statearr_30635_30679 = state_30622__$1;
(statearr_30635_30679[(2)] = inst_30539);

(statearr_30635_30679[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (25))){
var inst_30617 = (state_30622[(2)]);
var _ = (function (){var statearr_30636 = state_30622;
(statearr_30636[(4)] = cljs.core.rest((state_30622[(4)])));

return statearr_30636;
})();
var state_30622__$1 = state_30622;
var statearr_30637_30680 = state_30622__$1;
(statearr_30637_30680[(2)] = inst_30617);

(statearr_30637_30680[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (17))){
var inst_30578 = (state_30622[(18)]);
var inst_30572 = (state_30622[(15)]);
var inst_30577 = cljs.core.seq(inst_30572);
var inst_30578__$1 = cljs.core.first(inst_30577);
var inst_30579 = cljs.core.next(inst_30577);
var state_30622__$1 = (function (){var statearr_30638 = state_30622;
(statearr_30638[(18)] = inst_30578__$1);

(statearr_30638[(16)] = inst_30579);

return statearr_30638;
})();
if(cljs.core.truth_(inst_30578__$1)){
var statearr_30639_30681 = state_30622__$1;
(statearr_30639_30681[(1)] = (19));

} else {
var statearr_30640_30682 = state_30622__$1;
(statearr_30640_30682[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (3))){
var inst_30620 = (state_30622[(2)]);
var state_30622__$1 = state_30622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30622__$1,inst_30620);
} else {
if((state_val_30623 === (12))){
var inst_30545 = (state_30622[(19)]);
var inst_30556 = (state_30622[(12)]);
var inst_30551 = cljs.core.vals(inst_30545);
var inst_30552 = cljs.core.flatten(inst_30551);
var inst_30553 = cljs.core.set(inst_30552);
var inst_30554 = cljs.core.keys(inst_30545);
var inst_30555 = cljs.core.set(inst_30554);
var inst_30556__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_30553,inst_30555);
var inst_30557 = cljs.core.empty_QMARK_(inst_30556__$1);
var state_30622__$1 = (function (){var statearr_30641 = state_30622;
(statearr_30641[(12)] = inst_30556__$1);

return statearr_30641;
})();
if(inst_30557){
var statearr_30642_30683 = state_30622__$1;
(statearr_30642_30683[(1)] = (14));

} else {
var statearr_30643_30684 = state_30622__$1;
(statearr_30643_30684[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (2))){
var inst_30539 = (state_30622[(17)]);
var _ = (function (){var statearr_30644 = state_30622;
(statearr_30644[(4)] = cljs.core.cons((5),(state_30622[(4)])));

return statearr_30644;
})();
var inst_30539__$1 = depth;
var state_30622__$1 = (function (){var statearr_30645 = state_30622;
(statearr_30645[(17)] = inst_30539__$1);

return statearr_30645;
})();
if(cljs.core.truth_(inst_30539__$1)){
var statearr_30646_30685 = state_30622__$1;
(statearr_30646_30685[(1)] = (6));

} else {
var statearr_30647_30686 = state_30622__$1;
(statearr_30647_30686[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (23))){
var inst_30610 = (state_30622[(9)]);
var state_30622__$1 = state_30622;
var statearr_30648_30687 = state_30622__$1;
(statearr_30648_30687[(2)] = inst_30610);

(statearr_30648_30687[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (19))){
var inst_30578 = (state_30622[(18)]);
var inst_30581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30582 = [inst_30578,predicate];
var inst_30583 = (new cljs.core.PersistentVector(null,2,(5),inst_30581,inst_30582,null));
var inst_30584 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_30583);
var state_30622__$1 = state_30622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30622__$1,(22),inst_30584);
} else {
if((state_val_30623 === (11))){
var inst_30545 = (state_30622[(19)]);
var state_30622__$1 = state_30622;
var statearr_30650_30688 = state_30622__$1;
(statearr_30650_30688[(2)] = inst_30545);

(statearr_30650_30688[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (9))){
var inst_30546 = (state_30622[(20)]);
var inst_30543 = (state_30622[(11)]);
var inst_30548 = (inst_30546 >= inst_30543);
var state_30622__$1 = state_30622;
if(cljs.core.truth_(inst_30548)){
var statearr_30651_30689 = state_30622__$1;
(statearr_30651_30689[(1)] = (11));

} else {
var statearr_30652_30690 = state_30622__$1;
(statearr_30652_30690[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (5))){
var _ = (function (){var statearr_30653 = state_30622;
(statearr_30653[(4)] = cljs.core.rest((state_30622[(4)])));

return statearr_30653;
})();
var state_30622__$1 = state_30622;
var ex30649 = (state_30622__$1[(2)]);
var statearr_30654_30691 = state_30622__$1;
(statearr_30654_30691[(5)] = ex30649);


if((ex30649 instanceof Error)){
var statearr_30655_30692 = state_30622__$1;
(statearr_30655_30692[(1)] = (4));

(statearr_30655_30692[(5)] = null);

} else {
throw ex30649;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (14))){
var inst_30545 = (state_30622[(19)]);
var state_30622__$1 = state_30622;
var statearr_30656_30693 = state_30622__$1;
(statearr_30656_30693[(2)] = inst_30545);

(statearr_30656_30693[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (16))){
var inst_30603 = (state_30622[(2)]);
var state_30622__$1 = state_30622;
var statearr_30657_30694 = state_30622__$1;
(statearr_30657_30694[(2)] = inst_30603);

(statearr_30657_30694[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (10))){
var inst_30609 = (state_30622[(8)]);
var inst_30608 = (state_30622[(10)]);
var inst_30607 = (state_30622[(2)]);
var inst_30608__$1 = cljs.core.keys(inst_30607);
var inst_30609__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_30608__$1,inst_30607);
var inst_30610 = fluree.db.query.analytical.recur_map__GT_tuples(inst_30608__$1,inst_30609__$1);
var state_30622__$1 = (function (){var statearr_30658 = state_30622;
(statearr_30658[(8)] = inst_30609__$1);

(statearr_30658[(9)] = inst_30610);

(statearr_30658[(10)] = inst_30608__$1);

return statearr_30658;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_30659_30695 = state_30622__$1;
(statearr_30659_30695[(1)] = (23));

} else {
var statearr_30660_30696 = state_30622__$1;
(statearr_30660_30696[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (18))){
var inst_30545 = (state_30622[(19)]);
var inst_30546 = (state_30622[(20)]);
var inst_30594 = (state_30622[(2)]);
var inst_30595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30596 = [(0),(2)];
var inst_30597 = (new cljs.core.PersistentVector(null,2,(5),inst_30595,inst_30596,null));
var inst_30598 = fluree.db.query.analytical.get_ns_arrays(inst_30597,inst_30594);
var inst_30599 = fluree.db.query.analytical.tuples__GT_map(inst_30545,inst_30598);
var inst_30600 = (inst_30546 + (1));
var inst_30545__$1 = inst_30599;
var inst_30546__$1 = inst_30600;
var state_30622__$1 = (function (){var statearr_30661 = state_30622;
(statearr_30661[(19)] = inst_30545__$1);

(statearr_30661[(20)] = inst_30546__$1);

return statearr_30661;
})();
var statearr_30662_30697 = state_30622__$1;
(statearr_30662_30697[(2)] = null);

(statearr_30662_30697[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30623 === (8))){
var inst_30543 = (state_30622[(2)]);
var inst_30544 = recur_map;
var inst_30545 = inst_30544;
var inst_30546 = (1);
var state_30622__$1 = (function (){var statearr_30663 = state_30622;
(statearr_30663[(19)] = inst_30545);

(statearr_30663[(20)] = inst_30546);

(statearr_30663[(11)] = inst_30543);

return statearr_30663;
})();
var statearr_30664_30698 = state_30622__$1;
(statearr_30664_30698[(2)] = null);

(statearr_30664_30698[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0 = (function (){
var statearr_30665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30665[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__);

(statearr_30665[(1)] = (1));

return statearr_30665;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1 = (function (state_30622){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30622);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30666){var ex__13886__auto__ = e30666;
var statearr_30667_30699 = state_30622;
(statearr_30667_30699[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30622[(4)]))){
var statearr_30668_30700 = state_30622;
(statearr_30668_30700[(1)] = cljs.core.first((state_30622[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30701 = state_30622;
state_30622 = G__30701;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__ = function(state_30622){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1.call(this,state_30622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30669 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30669[(6)] = c__13957__auto__);

return statearr_30669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__30702,clause,fuel,max_fuel){
var map__30703 = p__30702;
var map__30703__$1 = cljs.core.__destructure_map(map__30703);
var res = map__30703__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30703__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30703__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30703__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30814){
var state_val_30815 = (state_30814[(1)]);
if((state_val_30815 === (7))){
var inst_30720 = (state_30814[(7)]);
var state_30814__$1 = state_30814;
var statearr_30816_30869 = state_30814__$1;
(statearr_30816_30869[(2)] = inst_30720);

(statearr_30816_30869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (20))){
var inst_30748 = (state_30814[(8)]);
var inst_30779 = typeof inst_30748 === 'number';
var state_30814__$1 = state_30814;
if(cljs.core.truth_(inst_30779)){
var statearr_30817_30870 = state_30814__$1;
(statearr_30817_30870[(1)] = (22));

} else {
var statearr_30818_30871 = state_30814__$1;
(statearr_30818_30871[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (27))){
var inst_30794 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
var statearr_30819_30872 = state_30814__$1;
(statearr_30819_30872[(2)] = inst_30794);

(statearr_30819_30872[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (1))){
var state_30814__$1 = state_30814;
var statearr_30820_30873 = state_30814__$1;
(statearr_30820_30873[(2)] = null);

(statearr_30820_30873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (24))){
var inst_30796 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
var statearr_30821_30874 = state_30814__$1;
(statearr_30821_30874[(2)] = inst_30796);

(statearr_30821_30874[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (4))){
var inst_30704 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
var statearr_30822_30875 = state_30814__$1;
(statearr_30822_30875[(2)] = inst_30704);

(statearr_30822_30875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (15))){
var inst_30762 = (state_30814[(2)]);
var inst_30763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_30764 = fluree.db.query.analytical.variable_QMARK_(inst_30763);
var state_30814__$1 = (function (){var statearr_30823 = state_30814;
(statearr_30823[(9)] = inst_30762);

return statearr_30823;
})();
if(cljs.core.truth_(inst_30764)){
var statearr_30824_30876 = state_30814__$1;
(statearr_30824_30876[(1)] = (16));

} else {
var statearr_30825_30877 = state_30814__$1;
(statearr_30825_30877[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (21))){
var inst_30721 = (state_30814[(10)]);
var inst_30751 = (state_30814[(11)]);
var inst_30750 = (state_30814[(12)]);
var inst_30798 = (state_30814[(2)]);
var inst_30799 = fluree.db.query.analytical.tuples__GT_recur(db,inst_30751,inst_30798,inst_30721,inst_30750);
var state_30814__$1 = state_30814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30814__$1,(28),inst_30799);
} else {
if((state_val_30815 === (13))){
var inst_30730 = (state_30814[(13)]);
var inst_30754 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30730)].join('');
var inst_30755 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30756 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_30757 = cljs.core.PersistentHashMap.fromArrays(inst_30755,inst_30756);
var inst_30758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30754,inst_30757);
var inst_30759 = (function(){throw inst_30758})();
var state_30814__$1 = state_30814;
var statearr_30826_30878 = state_30814__$1;
(statearr_30826_30878[(2)] = inst_30759);

(statearr_30826_30878[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (22))){
var inst_30746 = (state_30814[(14)]);
var inst_30748 = (state_30814[(8)]);
var inst_30781 = cljs.core.PersistentHashMap.EMPTY;
var inst_30782 = cljs.core.flatten(inst_30746);
var inst_30783 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30781,inst_30748,inst_30782);
var state_30814__$1 = state_30814;
var statearr_30827_30879 = state_30814__$1;
(statearr_30827_30879[(2)] = inst_30783);

(statearr_30827_30879[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (6))){
var inst_30732 = (state_30814[(15)]);
var state_30814__$1 = state_30814;
var statearr_30828_30880 = state_30814__$1;
(statearr_30828_30880[(2)] = inst_30732);

(statearr_30828_30880[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (28))){
var inst_30801 = (state_30814[(2)]);
var inst_30802 = fluree.db.util.async.throw_err(inst_30801);
var state_30814__$1 = state_30814;
var statearr_30829_30881 = state_30814__$1;
(statearr_30829_30881[(2)] = inst_30802);

(statearr_30829_30881[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (25))){
var inst_30746 = (state_30814[(14)]);
var inst_30742 = (state_30814[(16)]);
var inst_30787 = cljs.core.PersistentHashMap.EMPTY;
var inst_30788 = cljs.core.first(inst_30742);
var inst_30789 = cljs.core.first(inst_30788);
var inst_30790 = cljs.core.flatten(inst_30746);
var inst_30791 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30787,inst_30789,inst_30790);
var state_30814__$1 = state_30814;
var statearr_30830_30882 = state_30814__$1;
(statearr_30830_30882[(2)] = inst_30791);

(statearr_30830_30882[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (17))){
var inst_30730 = (state_30814[(13)]);
var inst_30767 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30730)].join('');
var inst_30768 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30769 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_30770 = cljs.core.PersistentHashMap.fromArrays(inst_30768,inst_30769);
var inst_30771 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30767,inst_30770);
var inst_30772 = (function(){throw inst_30771})();
var state_30814__$1 = state_30814;
var statearr_30831_30883 = state_30814__$1;
(statearr_30831_30883[(2)] = inst_30772);

(statearr_30831_30883[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (3))){
var inst_30812 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30814__$1,inst_30812);
} else {
if((state_val_30815 === (12))){
var inst_30717 = (state_30814[(17)]);
var inst_30805 = (state_30814[(2)]);
var inst_30806 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_30807 = cljs.core.keys(inst_30717);
var inst_30808 = [inst_30807,vars,inst_30805];
var inst_30809 = cljs.core.PersistentHashMap.fromArrays(inst_30806,inst_30808);
var _ = (function (){var statearr_30832 = state_30814;
(statearr_30832[(4)] = cljs.core.rest((state_30814[(4)])));

return statearr_30832;
})();
var state_30814__$1 = state_30814;
var statearr_30833_30884 = state_30814__$1;
(statearr_30833_30884[(2)] = inst_30809);

(statearr_30833_30884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (2))){
var inst_30717 = (state_30814[(17)]);
var inst_30721 = (state_30814[(10)]);
var inst_30732 = (state_30814[(15)]);
var inst_30720 = (state_30814[(7)]);
var _ = (function (){var statearr_30834 = state_30814;
(statearr_30834[(4)] = cljs.core.cons((5),(state_30814[(4)])));

return statearr_30834;
})();
var inst_30714 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_30715 = cljs.core.__destructure_map(inst_30714);
var inst_30716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30715,cljs.core.cst$kw$search);
var inst_30717__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30715,cljs.core.cst$kw$rel);
var inst_30718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30715,cljs.core.cst$kw$opts);
var inst_30719 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_30720__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_30718);
var inst_30721__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_30718);
var inst_30723 = (function (){var map__30710 = inst_30715;
var search = inst_30716;
var rel = inst_30717__$1;
var opts = inst_30718;
var common_keys = inst_30719;
var object_fn = inst_30720__$1;
var recur_depth = inst_30721__$1;
return (function (p__30722,common_key){
var vec__30835 = p__30722;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30835,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30835,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__30838 = cljs.core._EQ_;
var expr__30839 = idx_of;
if(cljs.core.truth_((pred__30838.cljs$core$IFn$_invoke$arity$2 ? pred__30838.cljs$core$IFn$_invoke$arity$2((0),expr__30839) : pred__30838.call(null,(0),expr__30839)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__30838.cljs$core$IFn$_invoke$arity$2 ? pred__30838.cljs$core$IFn$_invoke$arity$2((1),expr__30839) : pred__30838.call(null,(1),expr__30839)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__30838.cljs$core$IFn$_invoke$arity$2 ? pred__30838.cljs$core$IFn$_invoke$arity$2((2),expr__30839) : pred__30838.call(null,(2),expr__30839)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30839)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4149__auto__ = object_fn;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4149__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_30724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30725 = cljs.core.PersistentHashMap.EMPTY;
var inst_30726 = [inst_30725,inst_30716];
var inst_30727 = (new cljs.core.PersistentVector(null,2,(5),inst_30724,inst_30726,null));
var inst_30728 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30723,inst_30727,inst_30719);
var inst_30729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30728,(0),null);
var inst_30730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30728,(1),null);
var inst_30731 = [cljs.core.cst$kw$object_DASH_fn];
var inst_30732__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_30729);
var state_30814__$1 = (function (){var statearr_30841 = state_30814;
(statearr_30841[(13)] = inst_30730);

(statearr_30841[(17)] = inst_30717__$1);

(statearr_30841[(10)] = inst_30721__$1);

(statearr_30841[(15)] = inst_30732__$1);

(statearr_30841[(18)] = inst_30731);

(statearr_30841[(7)] = inst_30720__$1);

return statearr_30841;
})();
if(cljs.core.truth_(inst_30732__$1)){
var statearr_30842_30885 = state_30814__$1;
(statearr_30842_30885[(1)] = (6));

} else {
var statearr_30843_30886 = state_30814__$1;
(statearr_30843_30886[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (23))){
var inst_30748 = (state_30814[(8)]);
var inst_30785 = cljs.core.coll_QMARK_(inst_30748);
var state_30814__$1 = state_30814;
if(inst_30785){
var statearr_30844_30887 = state_30814__$1;
(statearr_30844_30887[(1)] = (25));

} else {
var statearr_30845_30888 = state_30814__$1;
(statearr_30845_30888[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (19))){
var inst_30746 = (state_30814[(14)]);
var inst_30776 = cljs.core.PersistentHashMap.EMPTY;
var inst_30777 = fluree.db.query.analytical.tuples__GT_map(inst_30776,inst_30746);
var state_30814__$1 = state_30814;
var statearr_30846_30889 = state_30814__$1;
(statearr_30846_30889[(2)] = inst_30777);

(statearr_30846_30889[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (11))){
var inst_30746 = (state_30814[(14)]);
var state_30814__$1 = state_30814;
var statearr_30848_30890 = state_30814__$1;
(statearr_30848_30890[(2)] = inst_30746);

(statearr_30848_30890[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (9))){
var inst_30742 = (state_30814[(16)]);
var inst_30717 = (state_30814[(17)]);
var inst_30721 = (state_30814[(10)]);
var inst_30741 = (state_30814[(2)]);
var inst_30742__$1 = fluree.db.util.async.throw_err(inst_30741);
var inst_30743 = cljs.core.count(inst_30742__$1);
var inst_30744 = fluree.db.query.analytical.add_fuel(inst_30743,fuel,max_fuel);
var inst_30745 = cljs.core.vals(inst_30717);
var inst_30746 = fluree.db.query.analytical.get_ns_arrays(inst_30745,inst_30742__$1);
var state_30814__$1 = (function (){var statearr_30849 = state_30814;
(statearr_30849[(14)] = inst_30746);

(statearr_30849[(16)] = inst_30742__$1);

(statearr_30849[(19)] = inst_30744);

return statearr_30849;
})();
if(cljs.core.truth_(inst_30721)){
var statearr_30850_30891 = state_30814__$1;
(statearr_30850_30891[(1)] = (10));

} else {
var statearr_30851_30892 = state_30814__$1;
(statearr_30851_30892[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (5))){
var _ = (function (){var statearr_30852 = state_30814;
(statearr_30852[(4)] = cljs.core.rest((state_30814[(4)])));

return statearr_30852;
})();
var state_30814__$1 = state_30814;
var ex30847 = (state_30814__$1[(2)]);
var statearr_30853_30893 = state_30814__$1;
(statearr_30853_30893[(5)] = ex30847);


if((ex30847 instanceof Error)){
var statearr_30854_30894 = state_30814__$1;
(statearr_30854_30894[(1)] = (4));

(statearr_30854_30894[(5)] = null);

} else {
throw ex30847;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (14))){
var state_30814__$1 = state_30814;
var statearr_30855_30895 = state_30814__$1;
(statearr_30855_30895[(2)] = null);

(statearr_30855_30895[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (26))){
var state_30814__$1 = state_30814;
var statearr_30856_30896 = state_30814__$1;
(statearr_30856_30896[(2)] = null);

(statearr_30856_30896[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (16))){
var state_30814__$1 = state_30814;
var statearr_30857_30897 = state_30814__$1;
(statearr_30857_30897[(2)] = null);

(statearr_30857_30897[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (10))){
var inst_30730 = (state_30814[(13)]);
var inst_30751 = (state_30814[(11)]);
var inst_30748 = cljs.core.first(inst_30730);
var inst_30749 = cljs.core.first(clause);
var inst_30750 = fluree.db.query.analytical.variable_QMARK_(inst_30749);
var inst_30751__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_30730,(1));
var inst_30752 = fluree.db.query.analytical.variable_QMARK_(inst_30751__$1);
var state_30814__$1 = (function (){var statearr_30858 = state_30814;
(statearr_30858[(8)] = inst_30748);

(statearr_30858[(11)] = inst_30751__$1);

(statearr_30858[(12)] = inst_30750);

return statearr_30858;
})();
if(cljs.core.truth_(inst_30752)){
var statearr_30859_30898 = state_30814__$1;
(statearr_30859_30898[(1)] = (13));

} else {
var statearr_30860_30899 = state_30814__$1;
(statearr_30860_30899[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (18))){
var inst_30750 = (state_30814[(12)]);
var inst_30774 = (state_30814[(2)]);
var state_30814__$1 = (function (){var statearr_30861 = state_30814;
(statearr_30861[(20)] = inst_30774);

return statearr_30861;
})();
if(cljs.core.truth_(inst_30750)){
var statearr_30862_30900 = state_30814__$1;
(statearr_30862_30900[(1)] = (19));

} else {
var statearr_30863_30901 = state_30814__$1;
(statearr_30863_30901[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30815 === (8))){
var inst_30730 = (state_30814[(13)]);
var inst_30731 = (state_30814[(18)]);
var inst_30736 = (state_30814[(2)]);
var inst_30737 = [inst_30736];
var inst_30738 = cljs.core.PersistentHashMap.fromArrays(inst_30731,inst_30737);
var inst_30739 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_30730,inst_30738);
var state_30814__$1 = state_30814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30814__$1,(9),inst_30739);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_30864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30864[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__);

(statearr_30864[(1)] = (1));

return statearr_30864;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1 = (function (state_30814){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30814);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30865){var ex__13886__auto__ = e30865;
var statearr_30866_30902 = state_30814;
(statearr_30866_30902[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30814[(4)]))){
var statearr_30867_30903 = state_30814;
(statearr_30867_30903[(1)] = cljs.core.first((state_30814[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30904 = state_30814;
state_30814 = G__30904;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__ = function(state_30814){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1.call(this,state_30814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30868 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30868[(6)] = c__13957__auto__);

return statearr_30868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__30905,res,clause){
var map__30906 = p__30905;
var map__30906__$1 = cljs.core.__destructure_map(map__30906);
var db = map__30906__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30906__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30906__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30906__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31005){
var state_val_31006 = (state_31005[(1)]);
if((state_val_31006 === (7))){
var inst_30916 = (state_31005[(7)]);
var state_31005__$1 = state_31005;
var statearr_31007_31047 = state_31005__$1;
(statearr_31007_31047[(2)] = inst_30916);

(statearr_31007_31047[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (20))){
var inst_30996 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
var statearr_31008_31048 = state_31005__$1;
(statearr_31008_31048[(2)] = inst_30996);

(statearr_31008_31048[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (1))){
var state_31005__$1 = state_31005;
var statearr_31009_31049 = state_31005__$1;
(statearr_31009_31049[(2)] = null);

(statearr_31009_31049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (24))){
var inst_30975 = (state_31005[(2)]);
var inst_30976 = fluree.db.util.async.throw_err(inst_30975);
var state_31005__$1 = state_31005;
var statearr_31010_31050 = state_31005__$1;
(statearr_31010_31050[(2)] = inst_30976);

(statearr_31010_31050[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (4))){
var inst_30909 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
var statearr_31011_31051 = state_31005__$1;
(statearr_31011_31051[(2)] = inst_30909);

(statearr_31011_31051[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (15))){
var inst_30918 = (state_31005[(8)]);
var inst_30916 = (state_31005[(7)]);
var inst_30937 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30938 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30940 = [inst_30916];
var inst_30941 = (new cljs.core.PersistentVector(null,1,(5),inst_30939,inst_30940,null));
var inst_30942 = (function (){var subject_var = inst_30916;
var object_var = inst_30918;
var min_sid = inst_30937;
var max_sid = (0);
return (function (p1__30907_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__30907_SHARP_);
});
})();
var inst_30943 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_30937,(0));
var inst_30944 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30942,inst_30943);
var inst_30945 = cljs.core.PersistentHashMap.EMPTY;
var inst_30946 = [inst_30941,inst_30944,inst_30945];
var inst_30947 = cljs.core.PersistentHashMap.fromArrays(inst_30938,inst_30946);
var state_31005__$1 = state_31005;
var statearr_31012_31052 = state_31005__$1;
(statearr_31012_31052[(2)] = inst_30947);

(statearr_31012_31052[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (21))){
var inst_30969 = (state_31005[(9)]);
var state_31005__$1 = state_31005;
var statearr_31013_31053 = state_31005__$1;
(statearr_31013_31053[(2)] = inst_30969);

(statearr_31013_31053[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (13))){
var inst_30918 = (state_31005[(8)]);
var state_31005__$1 = state_31005;
if(cljs.core.truth_(inst_30918)){
var statearr_31014_31054 = state_31005__$1;
(statearr_31014_31054[(1)] = (18));

} else {
var statearr_31015_31055 = state_31005__$1;
(statearr_31015_31055[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (22))){
var inst_30969 = (state_31005[(9)]);
var inst_30973 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30969);
var state_31005__$1 = state_31005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31005__$1,(24),inst_30973);
} else {
if((state_val_31006 === (6))){
var inst_30918 = (state_31005[(8)]);
var state_31005__$1 = state_31005;
var statearr_31016_31056 = state_31005__$1;
(statearr_31016_31056[(2)] = inst_30918);

(statearr_31016_31056[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (17))){
var inst_30966 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
var statearr_31017_31057 = state_31005__$1;
(statearr_31017_31057[(2)] = inst_30966);

(statearr_31017_31057[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (3))){
var inst_31003 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31005__$1,inst_31003);
} else {
if((state_val_31006 === (12))){
var inst_30931 = ["_tx",null,"_block",null];
var inst_30932 = (new cljs.core.PersistentArrayMap(null,2,inst_30931,null));
var inst_30933 = (new cljs.core.PersistentHashSet(null,inst_30932,null));
var inst_30934 = cljs.core.last(clause);
var inst_30935 = (inst_30933.cljs$core$IFn$_invoke$arity$1 ? inst_30933.cljs$core$IFn$_invoke$arity$1(inst_30934) : inst_30933.call(null,inst_30934));
var state_31005__$1 = state_31005;
if(cljs.core.truth_(inst_30935)){
var statearr_31018_31058 = state_31005__$1;
(statearr_31018_31058[(1)] = (15));

} else {
var statearr_31019_31059 = state_31005__$1;
(statearr_31019_31059[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (2))){
var inst_30916 = (state_31005[(7)]);
var _ = (function (){var statearr_31020 = state_31005;
(statearr_31020[(4)] = cljs.core.cons((5),(state_31005[(4)])));

return statearr_31020;
})();
var inst_30915 = cljs.core.first(clause);
var inst_30916__$1 = fluree.db.query.analytical.variable_QMARK_(inst_30915);
var inst_30917 = cljs.core.last(clause);
var inst_30918 = fluree.db.query.analytical.variable_QMARK_(inst_30917);
var state_31005__$1 = (function (){var statearr_31021 = state_31005;
(statearr_31021[(8)] = inst_30918);

(statearr_31021[(7)] = inst_30916__$1);

return statearr_31021;
})();
if(cljs.core.truth_(inst_30916__$1)){
var statearr_31022_31060 = state_31005__$1;
(statearr_31022_31060[(1)] = (6));

} else {
var statearr_31023_31061 = state_31005__$1;
(statearr_31023_31061[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (23))){
var inst_30918 = (state_31005[(8)]);
var inst_30978 = (state_31005[(2)]);
var inst_30979 = fluree.db.flake.sid__GT_cid(inst_30978);
var inst_30980 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_30979);
var inst_30981 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30983 = [inst_30918];
var inst_30984 = (new cljs.core.PersistentVector(null,1,(5),inst_30982,inst_30983,null));
var inst_30985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30987 = [inst_30980];
var inst_30988 = (new cljs.core.PersistentVector(null,1,(5),inst_30986,inst_30987,null));
var inst_30989 = [inst_30988];
var inst_30990 = (new cljs.core.PersistentVector(null,1,(5),inst_30985,inst_30989,null));
var inst_30991 = cljs.core.PersistentHashMap.EMPTY;
var inst_30992 = [inst_30984,inst_30990,inst_30991];
var inst_30993 = cljs.core.PersistentHashMap.fromArrays(inst_30981,inst_30992);
var state_31005__$1 = state_31005;
var statearr_31024_31062 = state_31005__$1;
(statearr_31024_31062[(2)] = inst_30993);

(statearr_31024_31062[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (19))){
var state_31005__$1 = state_31005;
var statearr_31025_31063 = state_31005__$1;
(statearr_31025_31063[(2)] = null);

(statearr_31025_31063[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (11))){
var inst_31000 = (state_31005[(2)]);
var _ = (function (){var statearr_31027 = state_31005;
(statearr_31027[(4)] = cljs.core.rest((state_31005[(4)])));

return statearr_31027;
})();
var state_31005__$1 = state_31005;
var statearr_31028_31064 = state_31005__$1;
(statearr_31028_31064[(2)] = inst_31000);

(statearr_31028_31064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (9))){
var inst_30924 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30925 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_30926 = cljs.core.PersistentHashMap.fromArrays(inst_30924,inst_30925);
var inst_30927 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_30926);
var inst_30928 = (function(){throw inst_30927})();
var state_31005__$1 = state_31005;
var statearr_31029_31065 = state_31005__$1;
(statearr_31029_31065[(2)] = inst_30928);

(statearr_31029_31065[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (5))){
var _ = (function (){var statearr_31030 = state_31005;
(statearr_31030[(4)] = cljs.core.rest((state_31005[(4)])));

return statearr_31030;
})();
var state_31005__$1 = state_31005;
var ex31026 = (state_31005__$1[(2)]);
var statearr_31031_31066 = state_31005__$1;
(statearr_31031_31066[(5)] = ex31026);


if((ex31026 instanceof Error)){
var statearr_31032_31067 = state_31005__$1;
(statearr_31032_31067[(1)] = (4));

(statearr_31032_31067[(5)] = null);

} else {
throw ex31026;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (14))){
var inst_30998 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
var statearr_31033_31068 = state_31005__$1;
(statearr_31033_31068[(2)] = inst_30998);

(statearr_31033_31068[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (16))){
var inst_30918 = (state_31005[(8)]);
var inst_30916 = (state_31005[(7)]);
var inst_30949 = cljs.core.last(clause);
var inst_30950 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_30949);
var inst_30951 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_30952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30951,inst_30950);
var inst_30953 = fluree.db.flake.min_subject_id(inst_30950);
var inst_30954 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_30955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30956 = [inst_30916];
var inst_30957 = (new cljs.core.PersistentVector(null,1,(5),inst_30955,inst_30956,null));
var inst_30958 = (function (){var subject_var = inst_30916;
var object_var = inst_30918;
var cid = inst_30950;
var max_sid = inst_30952;
var min_sid = inst_30953;
return (function (p1__30908_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__30908_SHARP_);
});
})();
var inst_30959 = (inst_30952 + (1));
var inst_30960 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_30953,inst_30959);
var inst_30961 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30958,inst_30960);
var inst_30962 = cljs.core.PersistentHashMap.EMPTY;
var inst_30963 = [inst_30957,inst_30961,inst_30962];
var inst_30964 = cljs.core.PersistentHashMap.fromArrays(inst_30954,inst_30963);
var state_31005__$1 = state_31005;
var statearr_31034_31069 = state_31005__$1;
(statearr_31034_31069[(2)] = inst_30964);

(statearr_31034_31069[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (10))){
var inst_30916 = (state_31005[(7)]);
var state_31005__$1 = state_31005;
if(cljs.core.truth_(inst_30916)){
var statearr_31035_31070 = state_31005__$1;
(statearr_31035_31070[(1)] = (12));

} else {
var statearr_31036_31071 = state_31005__$1;
(statearr_31036_31071[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (18))){
var inst_30969 = (state_31005[(9)]);
var inst_30969__$1 = cljs.core.first(clause);
var inst_30970 = typeof inst_30969__$1 === 'number';
var state_31005__$1 = (function (){var statearr_31037 = state_31005;
(statearr_31037[(9)] = inst_30969__$1);

return statearr_31037;
})();
if(cljs.core.truth_(inst_30970)){
var statearr_31038_31072 = state_31005__$1;
(statearr_31038_31072[(1)] = (21));

} else {
var statearr_31039_31073 = state_31005__$1;
(statearr_31039_31073[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31006 === (8))){
var inst_30922 = (state_31005[(2)]);
var state_31005__$1 = state_31005;
if(cljs.core.truth_(inst_30922)){
var statearr_31040_31074 = state_31005__$1;
(statearr_31040_31074[(1)] = (9));

} else {
var statearr_31041_31075 = state_31005__$1;
(statearr_31041_31075[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_31042 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31042[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__);

(statearr_31042[(1)] = (1));

return statearr_31042;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1 = (function (state_31005){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31005);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31043){var ex__13886__auto__ = e31043;
var statearr_31044_31076 = state_31005;
(statearr_31044_31076[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31005[(4)]))){
var statearr_31045_31077 = state_31005;
(statearr_31045_31077[(1)] = cljs.core.first((state_31005[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31078 = state_31005;
state_31005 = G__31078;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__ = function(state_31005){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1.call(this,state_31005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31046 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31046[(6)] = c__13957__auto__);

return statearr_31046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__31085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__31085 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__31085;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4564__auto__ = (function fluree$db$query$analytical$variance_$_iter__31086(s__31087){
return (new cljs.core.LazySeq(null,(function (){
var s__31087__$1 = s__31087;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__31087__$1);
if(temp__5753__auto__){
var s__31087__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31087__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__31087__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__31089 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__31088 = (0);
while(true){
if((i__31088 < size__4563__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__31088);
var delta = (x - mean);
cljs.core.chunk_append(b__31089,(delta * delta));

var G__31091 = (i__31088 + (1));
i__31088 = G__31091;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31089),fluree$db$query$analytical$variance_$_iter__31086(cljs.core.chunk_rest(s__31087__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31089),null);
}
} else {
var x = cljs.core.first(s__31087__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__31086(cljs.core.rest(s__31087__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__31090 = variance(coll);
return Math.sqrt(G__31090);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4249__auto__ = n;
var y__4250__auto__ = (- n);
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
}),(function() {
var G__31092 = null;
var G__31092__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__31092__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31092 = function(n,coll){
switch(arguments.length){
case 1:
return G__31092__1.call(this,n);
case 2:
return G__31092__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31092.cljs$core$IFn$_invoke$arity$1 = G__31092__1;
G__31092.cljs$core$IFn$_invoke$arity$2 = G__31092__2;
return G__31092;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__31093 = null;
var G__31093__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__31093__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31093 = function(n,coll){
switch(arguments.length){
case 1:
return G__31093__1.call(this,n);
case 2:
return G__31093__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31093.cljs$core$IFn$_invoke$arity$1 = G__31093__1;
G__31093.cljs$core$IFn$_invoke$arity$2 = G__31093__2;
return G__31093;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__31094 = null;
var G__31094__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__31094__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__31094 = function(n,coll){
switch(arguments.length){
case 1:
return G__31094__1.call(this,n);
case 2:
return G__31094__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31094.cljs$core$IFn$_invoke$arity$1 = G__31094__1;
G__31094.cljs$core$IFn$_invoke$arity$2 = G__31094__2;
return G__31094;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__31095 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31095,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31095,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31095,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__31098 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__31101 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__31101) : agg_fn.call(null,G__31101));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31098,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31098,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__31102 = agg;
var map__31102__$1 = cljs.core.__destructure_map(map__31102);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31102__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31102__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31102__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__31104 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31104,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31104,(1),null);
var map__31107 = res__$1;
var map__31107__$1 = cljs.core.__destructure_map(map__31107);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31107__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31107__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31103_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__31103_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31108_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__31108_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31109_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__31109_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__31110_SHARP_,p2__31111_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31110_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__31111_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31112_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__31112_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__31115,row,b_tuple){
var vec__31116 = p__31115;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31116,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31116,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31113_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__31113_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = acc;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31114_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__31114_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31119_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__31119_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31120_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__31120_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__31125 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__31127 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__31126 = (function (p1__31121_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__31121_SHARP_);
});
return fexpr__31126(G__31127);
})()),cljs.core.set(b_idxs));
var fexpr__31124 = (function (p1__31122_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__31122_SHARP_);
});
return fexpr__31124(G__31125);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31123_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__31123_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31128_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__31128_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31129_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31129_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__31134 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__31136 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__31135 = (function (p1__31130_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__31130_SHARP_);
});
return fexpr__31135(G__31136);
})()),cljs.core.set(b_idxs));
var fexpr__31133 = (function (p1__31131_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__31131_SHARP_);
});
return fexpr__31133(G__31134);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31132_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31132_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31137_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__31137_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31138_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31138_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__31147 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__31149 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__31148 = (function (p1__31139_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__31139_SHARP_);
});
return fexpr__31148(G__31149);
})()),cljs.core.set(b_idxs));
var fexpr__31146 = (function (p1__31140_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__31140_SHARP_);
});
return fexpr__31146(G__31147);
})();
var vec__31143 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__31150,a_tuple){
var vec__31151 = p__31150;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31151,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31151,(1),null);
var vec__31154 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31154,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31154,(1),null);
var matches__$1 = (function (){var or__4160__auto__ = matches;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31143,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31143,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31141_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31141_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31142_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31142_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__31158 = (function (){var or__4160__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31158,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31158,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__31157_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__31157_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__31163 = (function (){var or__4160__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31163,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31163,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31161_SHARP_){
return fluree.db.util.core.index_of(headers,p1__31161_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__31162_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__31162_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__31166,filters,optional_QMARK_){
var map__31167 = p__31166;
var map__31167__$1 = cljs.core.__destructure_map(map__31167);
var tuple_map = map__31167__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31167__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31167__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31167__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__31168 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31168,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31168,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__31171 = res;
var map__31171__$1 = cljs.core.__destructure_map(map__31171);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31171__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31171__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31227){
var state_val_31228 = (state_31227[(1)]);
if((state_val_31228 === (7))){
var inst_31201 = (state_31227[(7)]);
var inst_31199 = (state_31227[(2)]);
var inst_31200 = fluree.db.util.async.throw_err(inst_31199);
var inst_31201__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31200,(0),null);
var inst_31202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31200,(1),null);
var inst_31203 = (inst_31201__$1 == null);
var state_31227__$1 = (function (){var statearr_31229 = state_31227;
(statearr_31229[(7)] = inst_31201__$1);

(statearr_31229[(8)] = inst_31202);

return statearr_31229;
})();
if(cljs.core.truth_(inst_31203)){
var statearr_31230_31259 = state_31227__$1;
(statearr_31230_31259[(1)] = (8));

} else {
var statearr_31231_31260 = state_31227__$1;
(statearr_31231_31260[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (1))){
var inst_31179 = optional_clauses;
var inst_31180 = cljs.core.seq(inst_31179);
var inst_31181 = cljs.core.first(inst_31180);
var inst_31182 = cljs.core.next(inst_31180);
var inst_31183 = where_tuples;
var inst_31184 = inst_31179;
var inst_31185 = inst_31183;
var state_31227__$1 = (function (){var statearr_31232 = state_31227;
(statearr_31232[(9)] = inst_31181);

(statearr_31232[(10)] = inst_31182);

(statearr_31232[(11)] = inst_31184);

(statearr_31232[(12)] = inst_31185);

return statearr_31232;
})();
var statearr_31233_31261 = state_31227__$1;
(statearr_31233_31261[(2)] = null);

(statearr_31233_31261[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (4))){
var inst_31192 = (state_31227[(13)]);
var inst_31185 = (state_31227[(12)]);
var inst_31191 = (state_31227[(14)]);
var inst_31197 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_31185,inst_31191,inst_31192,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_31185,inst_31191,inst_31192,true,fuel,max_fuel,opts));
var state_31227__$1 = state_31227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31227__$1,(7),inst_31197);
} else {
if((state_val_31228 === (15))){
var state_31227__$1 = state_31227;
var statearr_31234_31262 = state_31227__$1;
(statearr_31234_31262[(2)] = null);

(statearr_31234_31262[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (13))){
var inst_31218 = (state_31227[(2)]);
var state_31227__$1 = state_31227;
var statearr_31235_31263 = state_31227__$1;
(statearr_31235_31263[(2)] = inst_31218);

(statearr_31235_31263[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (6))){
var inst_31223 = (state_31227[(2)]);
var state_31227__$1 = state_31227;
var statearr_31236_31264 = state_31227__$1;
(statearr_31236_31264[(2)] = inst_31223);

(statearr_31236_31264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (3))){
var inst_31225 = (state_31227[(2)]);
var state_31227__$1 = state_31227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31227__$1,inst_31225);
} else {
if((state_val_31228 === (12))){
var state_31227__$1 = state_31227;
var statearr_31237_31265 = state_31227__$1;
(statearr_31237_31265[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (2))){
var inst_31184 = (state_31227[(11)]);
var inst_31191 = (state_31227[(14)]);
var inst_31190 = cljs.core.seq(inst_31184);
var inst_31191__$1 = cljs.core.first(inst_31190);
var inst_31192 = cljs.core.next(inst_31190);
var state_31227__$1 = (function (){var statearr_31239 = state_31227;
(statearr_31239[(13)] = inst_31192);

(statearr_31239[(14)] = inst_31191__$1);

return statearr_31239;
})();
if(cljs.core.truth_(inst_31191__$1)){
var statearr_31240_31266 = state_31227__$1;
(statearr_31240_31266[(1)] = (4));

} else {
var statearr_31241_31267 = state_31227__$1;
(statearr_31241_31267[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (11))){
var inst_31201 = (state_31227[(7)]);
var inst_31202 = (state_31227[(8)]);
var inst_31184 = inst_31202;
var inst_31185 = inst_31201;
var state_31227__$1 = (function (){var statearr_31242 = state_31227;
(statearr_31242[(11)] = inst_31184);

(statearr_31242[(12)] = inst_31185);

return statearr_31242;
})();
var statearr_31243_31268 = state_31227__$1;
(statearr_31243_31268[(2)] = null);

(statearr_31243_31268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (9))){
var inst_31191 = (state_31227[(14)]);
var inst_31207 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_31191);
var state_31227__$1 = state_31227;
if(cljs.core.truth_(inst_31207)){
var statearr_31244_31269 = state_31227__$1;
(statearr_31244_31269[(1)] = (11));

} else {
var statearr_31245_31270 = state_31227__$1;
(statearr_31245_31270[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (5))){
var inst_31185 = (state_31227[(12)]);
var state_31227__$1 = state_31227;
var statearr_31246_31271 = state_31227__$1;
(statearr_31246_31271[(2)] = inst_31185);

(statearr_31246_31271[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (14))){
var inst_31201 = (state_31227[(7)]);
var inst_31185 = (state_31227[(12)]);
var inst_31202 = (state_31227[(8)]);
var inst_31212 = fluree.db.query.analytical.left_outer_join(inst_31185,inst_31201);
var inst_31184 = inst_31202;
var inst_31185__$1 = inst_31212;
var state_31227__$1 = (function (){var statearr_31247 = state_31227;
(statearr_31247[(11)] = inst_31184);

(statearr_31247[(12)] = inst_31185__$1);

return statearr_31247;
})();
var statearr_31248_31272 = state_31227__$1;
(statearr_31248_31272[(2)] = null);

(statearr_31248_31272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (16))){
var inst_31216 = (state_31227[(2)]);
var state_31227__$1 = state_31227;
var statearr_31250_31273 = state_31227__$1;
(statearr_31250_31273[(2)] = inst_31216);

(statearr_31250_31273[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (10))){
var inst_31220 = (state_31227[(2)]);
var state_31227__$1 = state_31227;
var statearr_31251_31274 = state_31227__$1;
(statearr_31251_31274[(2)] = inst_31220);

(statearr_31251_31274[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31228 === (8))){
var inst_31185 = (state_31227[(12)]);
var inst_31202 = (state_31227[(8)]);
var tmp31249 = inst_31185;
var inst_31184 = inst_31202;
var inst_31185__$1 = tmp31249;
var state_31227__$1 = (function (){var statearr_31252 = state_31227;
(statearr_31252[(11)] = inst_31184);

(statearr_31252[(12)] = inst_31185__$1);

return statearr_31252;
})();
var statearr_31253_31275 = state_31227__$1;
(statearr_31253_31275[(2)] = null);

(statearr_31253_31275[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0 = (function (){
var statearr_31254 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31254[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__);

(statearr_31254[(1)] = (1));

return statearr_31254;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1 = (function (state_31227){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31227);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31255){var ex__13886__auto__ = e31255;
var statearr_31256_31276 = state_31227;
(statearr_31256_31276[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31227[(4)]))){
var statearr_31257_31277 = state_31227;
(statearr_31257_31277[(1)] = cljs.core.first((state_31227[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31278 = state_31227;
state_31227 = G__31278;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__ = function(state_31227){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1.call(this,state_31227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31258 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31258[(6)] = c__13957__auto__);

return statearr_31258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__31280){
var vec__31281 = p__31280;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31281,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31281,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31279_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31279_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__31285,p__31286,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__31287 = p__31285;
var map__31287__$1 = cljs.core.__destructure_map(map__31287);
var q_map = map__31287__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31287__$1,cljs.core.cst$kw$prefixes);
var map__31288 = p__31286;
var map__31288__$1 = cljs.core.__destructure_map(map__31288);
var res = map__31288__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31288__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31495){
var state_val_31496 = (state_31495[(1)]);
if((state_val_31496 === (7))){
var inst_31393 = cljs.core.count(clause);
var inst_31394 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_31393);
var inst_31395 = cljs.core.second(clause);
var inst_31396 = clojure.string.starts_with_QMARK_(inst_31395,"fullText:");
var inst_31397 = ((inst_31394) && (inst_31396));
var state_31495__$1 = state_31495;
if(cljs.core.truth_(inst_31397)){
var statearr_31497_31592 = state_31495__$1;
(statearr_31497_31592[(1)] = (31));

} else {
var statearr_31498_31593 = state_31495__$1;
(statearr_31498_31593[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (59))){
var inst_31464 = (state_31495[(7)]);
var inst_31467 = (state_31495[(2)]);
var inst_31468 = fluree.db.util.async.throw_err(inst_31467);
var inst_31469 = [inst_31468,r];
var inst_31470 = (new cljs.core.PersistentVector(null,2,(5),inst_31464,inst_31469,null));
var state_31495__$1 = state_31495;
var statearr_31499_31594 = state_31495__$1;
(statearr_31499_31594[(2)] = inst_31470);

(statearr_31499_31594[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (20))){
var inst_31357 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31500_31595 = state_31495__$1;
(statearr_31500_31595[(2)] = inst_31357);

(statearr_31500_31595[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (58))){
var inst_31473 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31501_31596 = state_31495__$1;
(statearr_31501_31596[(2)] = inst_31473);

(statearr_31501_31596[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (27))){
var inst_31387 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31502_31597 = state_31495__$1;
(statearr_31502_31597[(2)] = inst_31387);

(statearr_31502_31597[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (1))){
var state_31495__$1 = state_31495;
var statearr_31503_31598 = state_31495__$1;
(statearr_31503_31598[(2)] = null);

(statearr_31503_31598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (24))){
var inst_31351 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31504_31599 = state_31495__$1;
(statearr_31504_31599[(2)] = inst_31351);

(statearr_31504_31599[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (55))){
var inst_31475 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31505_31600 = state_31495__$1;
(statearr_31505_31600[(2)] = inst_31475);

(statearr_31505_31600[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (39))){
var inst_31429 = cljs.core.count(clause);
var inst_31430 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_31429);
var state_31495__$1 = state_31495;
if(inst_31430){
var statearr_31506_31601 = state_31495__$1;
(statearr_31506_31601[(1)] = (42));

} else {
var statearr_31507_31602 = state_31495__$1;
(statearr_31507_31602[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (46))){
var state_31495__$1 = state_31495;
var statearr_31508_31603 = state_31495__$1;
(statearr_31508_31603[(2)] = null);

(statearr_31508_31603[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (4))){
var inst_31289 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31509_31604 = state_31495__$1;
(statearr_31509_31604[(2)] = inst_31289);

(statearr_31509_31604[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (54))){
var state_31495__$1 = state_31495;
var statearr_31510_31605 = state_31495__$1;
(statearr_31510_31605[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (15))){
var inst_31389 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31512_31606 = state_31495__$1;
(statearr_31512_31606[(2)] = inst_31389);

(statearr_31512_31606[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (48))){
var inst_31446 = (state_31495[(8)]);
var inst_31444 = (state_31495[(2)]);
var inst_31445 = fluree.db.util.async.throw_err(inst_31444);
var inst_31446__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31445,(0),null);
var inst_31447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31445,(1),null);
var inst_31448 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_31446__$1);
var state_31495__$1 = (function (){var statearr_31513 = state_31495;
(statearr_31513[(8)] = inst_31446__$1);

(statearr_31513[(9)] = inst_31447);

return statearr_31513;
})();
if(inst_31448){
var statearr_31514_31607 = state_31495__$1;
(statearr_31514_31607[(1)] = (49));

} else {
var statearr_31515_31608 = state_31495__$1;
(statearr_31515_31608[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (50))){
var inst_31447 = (state_31495[(9)]);
var inst_31455 = cljs.core.second(inst_31447);
var inst_31456 = clojure.string.starts_with_QMARK_(inst_31455,"fullText:");
var state_31495__$1 = state_31495;
if(inst_31456){
var statearr_31516_31609 = state_31495__$1;
(statearr_31516_31609[(1)] = (53));

} else {
var statearr_31517_31610 = state_31495__$1;
(statearr_31517_31610[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (21))){
var inst_31302 = (state_31495[(10)]);
var inst_31334 = (state_31495[(11)]);
var inst_31323 = (state_31495[(12)]);
var inst_31328 = (state_31495[(13)]);
var inst_31326 = (state_31495[(14)]);
var inst_31325 = (state_31495[(15)]);
var inst_31335 = (state_31495[(16)]);
var inst_31327 = (state_31495[(17)]);
var inst_31298 = (state_31495[(18)]);
var inst_31339 = (state_31495[(2)]);
var inst_31340 = fluree.db.util.async.throw_err(inst_31339);
var inst_31341 = (function (){var new_res = inst_31340;
var rest = inst_31335;
var seq__31321 = inst_31326;
var tuples = inst_31328;
var expr__31300 = inst_31298;
var first__31332 = inst_31334;
var seq__31331 = inst_31335;
var first__31322 = inst_31325;
var vec__31330 = inst_31327;
var pred__31299 = inst_31302;
var G__31319 = inst_31327;
var segment_type = inst_31298;
var vec__31320 = inst_31323;
var clause_group = inst_31334;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_31342 = cljs.core.keys(vars);
var inst_31343 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31341,inst_31340,inst_31342);
var inst_31344 = fluree.db.query.analytical.res_absorb_vars(inst_31343);
var state_31495__$1 = (function (){var statearr_31518 = state_31495;
(statearr_31518[(19)] = inst_31344);

return statearr_31518;
})();
if(cljs.core.truth_(inst_31328)){
var statearr_31519_31611 = state_31495__$1;
(statearr_31519_31611[(1)] = (22));

} else {
var statearr_31520_31612 = state_31495__$1;
(statearr_31520_31612[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (31))){
var inst_31399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31400 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_31401 = [inst_31400,r];
var inst_31402 = (new cljs.core.PersistentVector(null,2,(5),inst_31399,inst_31401,null));
var state_31495__$1 = state_31495;
var statearr_31521_31613 = state_31495__$1;
(statearr_31521_31613[(2)] = inst_31402);

(statearr_31521_31613[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (32))){
var inst_31404 = cljs.core.count(clause);
var inst_31405 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_31404);
var inst_31406 = cljs.core.second(clause);
var inst_31407 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31406,"rdf:type");
var inst_31408 = ((inst_31405) && (inst_31407));
var state_31495__$1 = state_31495;
if(cljs.core.truth_(inst_31408)){
var statearr_31522_31614 = state_31495__$1;
(statearr_31522_31614[(1)] = (34));

} else {
var statearr_31523_31615 = state_31495__$1;
(statearr_31523_31615[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (40))){
var inst_31484 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31524_31616 = state_31495__$1;
(statearr_31524_31616[(2)] = inst_31484);

(statearr_31524_31616[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (56))){
var inst_31446 = (state_31495[(8)]);
var inst_31447 = (state_31495[(9)]);
var inst_31464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31465 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_31446,res,inst_31447,fuel,max_fuel);
var state_31495__$1 = (function (){var statearr_31525 = state_31495;
(statearr_31525[(7)] = inst_31464);

return statearr_31525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(59),inst_31465);
} else {
if((state_val_31496 === (33))){
var inst_31488 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31526_31617 = state_31495__$1;
(statearr_31526_31617[(2)] = inst_31488);

(statearr_31526_31617[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (13))){
var inst_31323 = (state_31495[(12)]);
var inst_31323__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_31324 = cljs.core.seq(inst_31323__$1);
var inst_31325 = cljs.core.first(inst_31324);
var inst_31326 = cljs.core.next(inst_31324);
var inst_31327 = inst_31323__$1;
var inst_31328 = null;
var state_31495__$1 = (function (){var statearr_31527 = state_31495;
(statearr_31527[(12)] = inst_31323__$1);

(statearr_31527[(13)] = inst_31328);

(statearr_31527[(14)] = inst_31326);

(statearr_31527[(15)] = inst_31325);

(statearr_31527[(17)] = inst_31327);

return statearr_31527;
})();
var statearr_31528_31618 = state_31495__$1;
(statearr_31528_31618[(2)] = null);

(statearr_31528_31618[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (22))){
var inst_31328 = (state_31495[(13)]);
var inst_31344 = (state_31495[(19)]);
var inst_31335 = (state_31495[(16)]);
var inst_31346 = fluree.db.query.analytical.outer_union(inst_31328,inst_31344);
var inst_31327 = inst_31335;
var inst_31328__$1 = inst_31346;
var state_31495__$1 = (function (){var statearr_31529 = state_31495;
(statearr_31529[(13)] = inst_31328__$1);

(statearr_31529[(17)] = inst_31327);

return statearr_31529;
})();
var statearr_31530_31619 = state_31495__$1;
(statearr_31530_31619[(2)] = null);

(statearr_31530_31619[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (36))){
var inst_31486 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31531_31620 = state_31495__$1;
(statearr_31531_31620[(2)] = inst_31486);

(statearr_31531_31620[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (41))){
var inst_31421 = (state_31495[(20)]);
var inst_31424 = (state_31495[(2)]);
var inst_31425 = fluree.db.util.async.throw_err(inst_31424);
var inst_31426 = [inst_31425,r];
var inst_31427 = (new cljs.core.PersistentVector(null,2,(5),inst_31421,inst_31426,null));
var state_31495__$1 = state_31495;
var statearr_31532_31621 = state_31495__$1;
(statearr_31532_31621[(2)] = inst_31427);

(statearr_31532_31621[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (43))){
var state_31495__$1 = state_31495;
var statearr_31533_31622 = state_31495__$1;
(statearr_31533_31622[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (29))){
var inst_31298 = (state_31495[(18)]);
var inst_31381 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31298)].join('');
var inst_31382 = (new Error(inst_31381));
var inst_31383 = (function(){throw inst_31382})();
var state_31495__$1 = state_31495;
var statearr_31535_31623 = state_31495__$1;
(statearr_31535_31623[(2)] = inst_31383);

(statearr_31535_31623[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (44))){
var inst_31482 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31536_31624 = state_31495__$1;
(statearr_31536_31624[(2)] = inst_31482);

(statearr_31536_31624[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (6))){
var inst_31302 = (state_31495[(10)]);
var inst_31298 = (state_31495[(18)]);
var inst_31297 = cljs.core.keys(clause);
var inst_31298__$1 = cljs.core.first(inst_31297);
var inst_31302__$1 = cljs.core._EQ_;
var inst_31303 = (function (){var G__31537 = cljs.core.cst$kw$optional;
var G__31538 = inst_31298__$1;
return (inst_31302__$1.cljs$core$IFn$_invoke$arity$2 ? inst_31302__$1.cljs$core$IFn$_invoke$arity$2(G__31537,G__31538) : inst_31302__$1.call(null,G__31537,G__31538));
})();
var state_31495__$1 = (function (){var statearr_31539 = state_31495;
(statearr_31539[(10)] = inst_31302__$1);

(statearr_31539[(18)] = inst_31298__$1);

return statearr_31539;
})();
if(cljs.core.truth_(inst_31303)){
var statearr_31540_31625 = state_31495__$1;
(statearr_31540_31625[(1)] = (9));

} else {
var statearr_31541_31626 = state_31495__$1;
(statearr_31541_31626[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (28))){
var inst_31375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31376 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_31377 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_31376,optional_QMARK_);
var inst_31378 = [inst_31377,r];
var inst_31379 = (new cljs.core.PersistentVector(null,2,(5),inst_31375,inst_31378,null));
var state_31495__$1 = state_31495;
var statearr_31542_31627 = state_31495__$1;
(statearr_31542_31627[(2)] = inst_31379);

(statearr_31542_31627[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (51))){
var inst_31477 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31543_31628 = state_31495__$1;
(statearr_31543_31628[(2)] = inst_31477);

(statearr_31543_31628[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (25))){
var inst_31302 = (state_31495[(10)]);
var inst_31298 = (state_31495[(18)]);
var inst_31363 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_31364 = (function (){var segment_type = inst_31298;
var pred__31299 = inst_31302;
var expr__31300 = inst_31298;
var bindings = inst_31363;
return (function (p1__31284_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__31284_SHARP_);
});
})();
var inst_31365 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31364,inst_31363);
var inst_31366 = cljs.core.PersistentHashMap.EMPTY;
var inst_31367 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31366,inst_31365);
var inst_31368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31369 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_31367);
var inst_31370 = [inst_31369,r];
var inst_31371 = (new cljs.core.PersistentVector(null,2,(5),inst_31368,inst_31370,null));
var state_31495__$1 = state_31495;
var statearr_31544_31629 = state_31495__$1;
(statearr_31544_31629[(2)] = inst_31371);

(statearr_31544_31629[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (34))){
var inst_31410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31411 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_31495__$1 = (function (){var statearr_31545 = state_31495;
(statearr_31545[(21)] = inst_31410);

return statearr_31545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(37),inst_31411);
} else {
if((state_val_31496 === (17))){
var inst_31359 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31546_31630 = state_31495__$1;
(statearr_31546_31630[(2)] = inst_31359);

(statearr_31546_31630[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (3))){
var inst_31493 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31495__$1,inst_31493);
} else {
if((state_val_31496 === (12))){
var inst_31305 = (state_31495[(22)]);
var inst_31309 = (state_31495[(2)]);
var inst_31310 = fluree.db.util.async.throw_err(inst_31309);
var inst_31311 = [inst_31310,r];
var inst_31312 = (new cljs.core.PersistentVector(null,2,(5),inst_31305,inst_31311,null));
var state_31495__$1 = state_31495;
var statearr_31547_31631 = state_31495__$1;
(statearr_31547_31631[(2)] = inst_31312);

(statearr_31547_31631[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (2))){
var _ = (function (){var statearr_31548 = state_31495;
(statearr_31548[(4)] = cljs.core.cons((5),(state_31495[(4)])));

return statearr_31548;
})();
var inst_31295 = cljs.core.map_QMARK_(clause);
var state_31495__$1 = state_31495;
if(inst_31295){
var statearr_31549_31632 = state_31495__$1;
(statearr_31549_31632[(1)] = (6));

} else {
var statearr_31550_31633 = state_31495__$1;
(statearr_31550_31633[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (23))){
var inst_31344 = (state_31495[(19)]);
var inst_31335 = (state_31495[(16)]);
var inst_31327 = inst_31335;
var inst_31328 = inst_31344;
var state_31495__$1 = (function (){var statearr_31551 = state_31495;
(statearr_31551[(13)] = inst_31328);

(statearr_31551[(17)] = inst_31327);

return statearr_31551;
})();
var statearr_31552_31634 = state_31495__$1;
(statearr_31552_31634[(2)] = null);

(statearr_31552_31634[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (47))){
var inst_31480 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31553_31635 = state_31495__$1;
(statearr_31553_31635[(2)] = inst_31480);

(statearr_31553_31635[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (35))){
var inst_31418 = cljs.core.count(clause);
var inst_31419 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_31418);
var state_31495__$1 = state_31495;
if(inst_31419){
var statearr_31554_31636 = state_31495__$1;
(statearr_31554_31636[(1)] = (38));

} else {
var statearr_31555_31637 = state_31495__$1;
(statearr_31555_31637[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (19))){
var inst_31328 = (state_31495[(13)]);
var inst_31353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31354 = [inst_31328,r];
var inst_31355 = (new cljs.core.PersistentVector(null,2,(5),inst_31353,inst_31354,null));
var state_31495__$1 = state_31495;
var statearr_31556_31638 = state_31495__$1;
(statearr_31556_31638[(2)] = inst_31355);

(statearr_31556_31638[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (57))){
var state_31495__$1 = state_31495;
var statearr_31557_31639 = state_31495__$1;
(statearr_31557_31639[(2)] = null);

(statearr_31557_31639[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (11))){
var inst_31391 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31559_31640 = state_31495__$1;
(statearr_31559_31640[(2)] = inst_31391);

(statearr_31559_31640[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (9))){
var inst_31305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31306 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_31307 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_31306,res,fuel,max_fuel,opts);
var state_31495__$1 = (function (){var statearr_31560 = state_31495;
(statearr_31560[(22)] = inst_31305);

return statearr_31560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(12),inst_31307);
} else {
if((state_val_31496 === (5))){
var _ = (function (){var statearr_31561 = state_31495;
(statearr_31561[(4)] = cljs.core.rest((state_31495[(4)])));

return statearr_31561;
})();
var state_31495__$1 = state_31495;
var ex31558 = (state_31495__$1[(2)]);
var statearr_31562_31641 = state_31495__$1;
(statearr_31562_31641[(5)] = ex31558);


if((ex31558 instanceof Error)){
var statearr_31563_31642 = state_31495__$1;
(statearr_31563_31642[(1)] = (4));

(statearr_31563_31642[(5)] = null);

} else {
throw ex31558;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (14))){
var inst_31302 = (state_31495[(10)]);
var inst_31298 = (state_31495[(18)]);
var inst_31361 = (function (){var G__31564 = cljs.core.cst$kw$bind;
var G__31565 = inst_31298;
return (inst_31302.cljs$core$IFn$_invoke$arity$2 ? inst_31302.cljs$core$IFn$_invoke$arity$2(G__31564,G__31565) : inst_31302.call(null,G__31564,G__31565));
})();
var state_31495__$1 = state_31495;
if(cljs.core.truth_(inst_31361)){
var statearr_31566_31643 = state_31495__$1;
(statearr_31566_31643[(1)] = (25));

} else {
var statearr_31567_31644 = state_31495__$1;
(statearr_31567_31644[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (45))){
var inst_31442 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_31495__$1 = state_31495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(48),inst_31442);
} else {
if((state_val_31496 === (53))){
var inst_31446 = (state_31495[(8)]);
var inst_31447 = (state_31495[(9)]);
var inst_31458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31459 = fluree.db.query.analytical.full_text__GT_tuples(inst_31446,res,inst_31447);
var inst_31460 = [inst_31459,r];
var inst_31461 = (new cljs.core.PersistentVector(null,2,(5),inst_31458,inst_31460,null));
var state_31495__$1 = state_31495;
var statearr_31568_31645 = state_31495__$1;
(statearr_31568_31645[(2)] = inst_31461);

(statearr_31568_31645[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (26))){
var inst_31302 = (state_31495[(10)]);
var inst_31298 = (state_31495[(18)]);
var inst_31373 = (function (){var G__31569 = cljs.core.cst$kw$filter;
var G__31570 = inst_31298;
return (inst_31302.cljs$core$IFn$_invoke$arity$2 ? inst_31302.cljs$core$IFn$_invoke$arity$2(G__31569,G__31570) : inst_31302.call(null,G__31569,G__31570));
})();
var state_31495__$1 = state_31495;
if(cljs.core.truth_(inst_31373)){
var statearr_31571_31646 = state_31495__$1;
(statearr_31571_31646[(1)] = (28));

} else {
var statearr_31572_31647 = state_31495__$1;
(statearr_31572_31647[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (16))){
var inst_31334 = (state_31495[(11)]);
var inst_31327 = (state_31495[(17)]);
var inst_31333 = cljs.core.seq(inst_31327);
var inst_31334__$1 = cljs.core.first(inst_31333);
var inst_31335 = cljs.core.next(inst_31333);
var state_31495__$1 = (function (){var statearr_31573 = state_31495;
(statearr_31573[(11)] = inst_31334__$1);

(statearr_31573[(16)] = inst_31335);

return statearr_31573;
})();
if(cljs.core.truth_(inst_31334__$1)){
var statearr_31574_31648 = state_31495__$1;
(statearr_31574_31648[(1)] = (18));

} else {
var statearr_31575_31649 = state_31495__$1;
(statearr_31575_31649[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (38))){
var inst_31421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31422 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_31495__$1 = (function (){var statearr_31576 = state_31495;
(statearr_31576[(20)] = inst_31421);

return statearr_31576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(41),inst_31422);
} else {
if((state_val_31496 === (30))){
var inst_31385 = (state_31495[(2)]);
var state_31495__$1 = state_31495;
var statearr_31577_31650 = state_31495__$1;
(statearr_31577_31650[(2)] = inst_31385);

(statearr_31577_31650[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (10))){
var inst_31302 = (state_31495[(10)]);
var inst_31298 = (state_31495[(18)]);
var inst_31314 = (function (){var G__31578 = cljs.core.cst$kw$union;
var G__31579 = inst_31298;
return (inst_31302.cljs$core$IFn$_invoke$arity$2 ? inst_31302.cljs$core$IFn$_invoke$arity$2(G__31578,G__31579) : inst_31302.call(null,G__31578,G__31579));
})();
var state_31495__$1 = state_31495;
if(cljs.core.truth_(inst_31314)){
var statearr_31580_31651 = state_31495__$1;
(statearr_31580_31651[(1)] = (13));

} else {
var statearr_31581_31652 = state_31495__$1;
(statearr_31581_31652[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (18))){
var inst_31334 = (state_31495[(11)]);
var inst_31337 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_31334,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_31334,q_map,vars,fuel,max_fuel,opts));
var state_31495__$1 = state_31495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(21),inst_31337);
} else {
if((state_val_31496 === (52))){
var inst_31452 = (state_31495[(2)]);
var inst_31453 = fluree.db.util.async.throw_err(inst_31452);
var state_31495__$1 = state_31495;
var statearr_31582_31653 = state_31495__$1;
(statearr_31582_31653[(2)] = inst_31453);

(statearr_31582_31653[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (42))){
var inst_31432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31433 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_31434 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_31433);
var inst_31435 = [inst_31434,r];
var inst_31436 = (new cljs.core.PersistentVector(null,2,(5),inst_31432,inst_31435,null));
var state_31495__$1 = state_31495;
var statearr_31583_31654 = state_31495__$1;
(statearr_31583_31654[(2)] = inst_31436);

(statearr_31583_31654[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (37))){
var inst_31410 = (state_31495[(21)]);
var inst_31413 = (state_31495[(2)]);
var inst_31414 = fluree.db.util.async.throw_err(inst_31413);
var inst_31415 = [inst_31414,r];
var inst_31416 = (new cljs.core.PersistentVector(null,2,(5),inst_31410,inst_31415,null));
var state_31495__$1 = state_31495;
var statearr_31584_31655 = state_31495__$1;
(statearr_31584_31655[(2)] = inst_31416);

(statearr_31584_31655[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (8))){
var inst_31490 = (state_31495[(2)]);
var _ = (function (){var statearr_31585 = state_31495;
(statearr_31585[(4)] = cljs.core.rest((state_31495[(4)])));

return statearr_31585;
})();
var state_31495__$1 = state_31495;
var statearr_31586_31656 = state_31495__$1;
(statearr_31586_31656[(2)] = inst_31490);

(statearr_31586_31656[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31496 === (49))){
var inst_31447 = (state_31495[(9)]);
var inst_31450 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_31447,r,res,optional_QMARK_,fuel,max_fuel);
var state_31495__$1 = state_31495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31495__$1,(52),inst_31450);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_31587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31587[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__);

(statearr_31587[(1)] = (1));

return statearr_31587;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1 = (function (state_31495){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31495);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31588){var ex__13886__auto__ = e31588;
var statearr_31589_31657 = state_31495;
(statearr_31589_31657[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31495[(4)]))){
var statearr_31590_31658 = state_31495;
(statearr_31590_31658[(1)] = cljs.core.first((state_31495[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31659 = state_31495;
state_31495 = G__31659;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__ = function(state_31495){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1.call(this,state_31495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31591 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31591[(6)] = c__13957__auto__);

return statearr_31591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__31661 = arguments.length;
switch (G__31661) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31741){
var state_val_31742 = (state_31741[(1)]);
if((state_val_31742 === (7))){
var inst_31736 = (state_31741[(2)]);
var _ = (function (){var statearr_31743 = state_31741;
(statearr_31743[(4)] = cljs.core.rest((state_31741[(4)])));

return statearr_31743;
})();
var state_31741__$1 = state_31741;
var statearr_31744_31792 = state_31741__$1;
(statearr_31744_31792[(2)] = inst_31736);

(statearr_31744_31792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (20))){
var inst_31701 = (state_31741[(7)]);
var inst_31713 = (state_31741[(2)]);
var inst_31683 = inst_31701;
var inst_31684 = inst_31713;
var state_31741__$1 = (function (){var statearr_31745 = state_31741;
(statearr_31745[(8)] = inst_31684);

(statearr_31745[(9)] = inst_31683);

return statearr_31745;
})();
var statearr_31746_31793 = state_31741__$1;
(statearr_31746_31793[(2)] = null);

(statearr_31746_31793[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (1))){
var state_31741__$1 = state_31741;
var statearr_31747_31794 = state_31741__$1;
(statearr_31747_31794[(2)] = null);

(statearr_31747_31794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (24))){
var inst_31700 = (state_31741[(10)]);
var inst_31684 = (state_31741[(8)]);
var inst_31701 = (state_31741[(7)]);
var inst_31721 = fluree.db.query.analytical.inner_join(inst_31684,inst_31700);
var inst_31683 = inst_31701;
var inst_31684__$1 = inst_31721;
var state_31741__$1 = (function (){var statearr_31748 = state_31741;
(statearr_31748[(8)] = inst_31684__$1);

(statearr_31748[(9)] = inst_31683);

return statearr_31748;
})();
var statearr_31749_31795 = state_31741__$1;
(statearr_31749_31795[(2)] = null);

(statearr_31749_31795[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (4))){
var inst_31662 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31751_31796 = state_31741__$1;
(statearr_31751_31796[(2)] = inst_31662);

(statearr_31751_31796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (15))){
var inst_31700 = (state_31741[(10)]);
var state_31741__$1 = state_31741;
if(cljs.core.truth_(inst_31700)){
var statearr_31752_31797 = state_31741__$1;
(statearr_31752_31797[(1)] = (18));

} else {
var statearr_31753_31798 = state_31741__$1;
(statearr_31753_31798[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (21))){
var inst_31684 = (state_31741[(8)]);
var inst_31701 = (state_31741[(7)]);
var tmp31750 = inst_31684;
var inst_31683 = inst_31701;
var inst_31684__$1 = tmp31750;
var state_31741__$1 = (function (){var statearr_31754 = state_31741;
(statearr_31754[(8)] = inst_31684__$1);

(statearr_31754[(9)] = inst_31683);

return statearr_31754;
})();
var statearr_31755_31799 = state_31741__$1;
(statearr_31755_31799[(2)] = null);

(statearr_31755_31799[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (13))){
var inst_31684 = (state_31741[(8)]);
var inst_31707 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_31684,cljs.core.cst$kw$vars);
var inst_31708 = cljs.core.empty_QMARK_(inst_31707);
var state_31741__$1 = state_31741;
if(inst_31708){
var statearr_31756_31800 = state_31741__$1;
(statearr_31756_31800[(1)] = (15));

} else {
var statearr_31757_31801 = state_31741__$1;
(statearr_31757_31801[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (22))){
var state_31741__$1 = state_31741;
var statearr_31758_31802 = state_31741__$1;
(statearr_31758_31802[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (6))){
var inst_31690 = (state_31741[(11)]);
var inst_31683 = (state_31741[(9)]);
var inst_31689 = cljs.core.seq(inst_31683);
var inst_31690__$1 = cljs.core.first(inst_31689);
var inst_31691 = cljs.core.next(inst_31689);
var state_31741__$1 = (function (){var statearr_31760 = state_31741;
(statearr_31760[(11)] = inst_31690__$1);

(statearr_31760[(12)] = inst_31691);

return statearr_31760;
})();
if(cljs.core.truth_(inst_31690__$1)){
var statearr_31761_31803 = state_31741__$1;
(statearr_31761_31803[(1)] = (8));

} else {
var statearr_31762_31804 = state_31741__$1;
(statearr_31762_31804[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (25))){
var state_31741__$1 = state_31741;
var statearr_31763_31805 = state_31741__$1;
(statearr_31763_31805[(2)] = null);

(statearr_31763_31805[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (17))){
var inst_31729 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31764_31806 = state_31741__$1;
(statearr_31764_31806[(2)] = inst_31729);

(statearr_31764_31806[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (3))){
var inst_31739 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31741__$1,inst_31739);
} else {
if((state_val_31742 === (12))){
var inst_31700 = (state_31741[(10)]);
var inst_31701 = (state_31741[(7)]);
var inst_31683 = inst_31701;
var inst_31684 = inst_31700;
var state_31741__$1 = (function (){var statearr_31765 = state_31741;
(statearr_31765[(8)] = inst_31684);

(statearr_31765[(9)] = inst_31683);

return statearr_31765;
})();
var statearr_31766_31807 = state_31741__$1;
(statearr_31766_31807[(2)] = null);

(statearr_31766_31807[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (2))){
var _ = (function (){var statearr_31767 = state_31741;
(statearr_31767[(4)] = cljs.core.cons((5),(state_31741[(4)])));

return statearr_31767;
})();
var inst_31675 = where;
var inst_31676 = cljs.core.seq(inst_31675);
var inst_31677 = cljs.core.first(inst_31676);
var inst_31678 = cljs.core.next(inst_31676);
var inst_31679 = [cljs.core.cst$kw$vars];
var inst_31680 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_31681 = [inst_31680];
var inst_31682 = cljs.core.PersistentHashMap.fromArrays(inst_31679,inst_31681);
var inst_31683 = inst_31675;
var inst_31684 = inst_31682;
var state_31741__$1 = (function (){var statearr_31768 = state_31741;
(statearr_31768[(13)] = inst_31678);

(statearr_31768[(14)] = inst_31677);

(statearr_31768[(8)] = inst_31684);

(statearr_31768[(9)] = inst_31683);

return statearr_31768;
})();
var statearr_31769_31808 = state_31741__$1;
(statearr_31769_31808[(2)] = null);

(statearr_31769_31808[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (23))){
var inst_31727 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31770_31809 = state_31741__$1;
(statearr_31770_31809[(2)] = inst_31727);

(statearr_31770_31809[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (19))){
var inst_31684 = (state_31741[(8)]);
var state_31741__$1 = state_31741;
var statearr_31771_31810 = state_31741__$1;
(statearr_31771_31810[(2)] = inst_31684);

(statearr_31771_31810[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (11))){
var inst_31690 = (state_31741[(11)]);
var inst_31698 = (state_31741[(2)]);
var inst_31699 = fluree.db.util.async.throw_err(inst_31698);
var inst_31700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31699,(0),null);
var inst_31701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31699,(1),null);
var inst_31702 = cljs.core.count(inst_31690);
var inst_31703 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_31702);
var state_31741__$1 = (function (){var statearr_31773 = state_31741;
(statearr_31773[(10)] = inst_31700);

(statearr_31773[(7)] = inst_31701);

return statearr_31773;
})();
if(inst_31703){
var statearr_31774_31811 = state_31741__$1;
(statearr_31774_31811[(1)] = (12));

} else {
var statearr_31775_31812 = state_31741__$1;
(statearr_31775_31812[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (9))){
var inst_31684 = (state_31741[(8)]);
var state_31741__$1 = state_31741;
var statearr_31776_31813 = state_31741__$1;
(statearr_31776_31813[(2)] = inst_31684);

(statearr_31776_31813[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (5))){
var _ = (function (){var statearr_31777 = state_31741;
(statearr_31777[(4)] = cljs.core.rest((state_31741[(4)])));

return statearr_31777;
})();
var state_31741__$1 = state_31741;
var ex31772 = (state_31741__$1[(2)]);
var statearr_31778_31814 = state_31741__$1;
(statearr_31778_31814[(5)] = ex31772);


if((ex31772 instanceof Error)){
var statearr_31779_31815 = state_31741__$1;
(statearr_31779_31815[(1)] = (4));

(statearr_31779_31815[(5)] = null);

} else {
throw ex31772;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (14))){
var inst_31731 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31780_31816 = state_31741__$1;
(statearr_31780_31816[(2)] = inst_31731);

(statearr_31780_31816[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (26))){
var inst_31725 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31781_31817 = state_31741__$1;
(statearr_31781_31817[(2)] = inst_31725);

(statearr_31781_31817[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (16))){
var inst_31700 = (state_31741[(10)]);
var inst_31716 = (inst_31700 == null);
var state_31741__$1 = state_31741;
if(cljs.core.truth_(inst_31716)){
var statearr_31782_31818 = state_31741__$1;
(statearr_31782_31818[(1)] = (21));

} else {
var statearr_31783_31819 = state_31741__$1;
(statearr_31783_31819[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (10))){
var inst_31734 = (state_31741[(2)]);
var state_31741__$1 = state_31741;
var statearr_31784_31820 = state_31741__$1;
(statearr_31784_31820[(2)] = inst_31734);

(statearr_31784_31820[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (18))){
var inst_31700 = (state_31741[(10)]);
var state_31741__$1 = state_31741;
var statearr_31785_31821 = state_31741__$1;
(statearr_31785_31821[(2)] = inst_31700);

(statearr_31785_31821[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31742 === (8))){
var inst_31690 = (state_31741[(11)]);
var inst_31691 = (state_31741[(12)]);
var inst_31684 = (state_31741[(8)]);
var inst_31696 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_31684,inst_31690,inst_31691,false,fuel,max_fuel,opts);
var state_31741__$1 = state_31741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31741__$1,(11),inst_31696);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__13883__auto__ = null;
var fluree$db$query$analytical$state_machine__13883__auto____0 = (function (){
var statearr_31786 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31786[(0)] = fluree$db$query$analytical$state_machine__13883__auto__);

(statearr_31786[(1)] = (1));

return statearr_31786;
});
var fluree$db$query$analytical$state_machine__13883__auto____1 = (function (state_31741){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31741);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31787){var ex__13886__auto__ = e31787;
var statearr_31788_31822 = state_31741;
(statearr_31788_31822[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31741[(4)]))){
var statearr_31789_31823 = state_31741;
(statearr_31789_31823[(1)] = cljs.core.first((state_31741[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31824 = state_31741;
state_31741 = G__31824;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__13883__auto__ = function(state_31741){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__13883__auto____1.call(this,state_31741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__13883__auto____0;
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__13883__auto____1;
return fluree$db$query$analytical$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31790 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31790[(6)] = c__13957__auto__);

return statearr_31790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31859){
var state_val_31860 = (state_31859[(1)]);
if((state_val_31860 === (7))){
var inst_31836 = (state_31859[(7)]);
var inst_31841 = (state_31859[(8)]);
var inst_31843 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_31836,inst_31841,fuel,max_fuel,opts);
var state_31859__$1 = state_31859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31859__$1,(10),inst_31843);
} else {
if((state_val_31860 === (1))){
var state_31859__$1 = state_31859;
var statearr_31861_31886 = state_31859__$1;
(statearr_31861_31886[(2)] = null);

(statearr_31861_31886[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (4))){
var inst_31825 = (state_31859[(2)]);
var state_31859__$1 = state_31859;
var statearr_31862_31887 = state_31859__$1;
(statearr_31862_31887[(2)] = inst_31825);

(statearr_31862_31887[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (13))){
var inst_31854 = (state_31859[(2)]);
var _ = (function (){var statearr_31863 = state_31859;
(statearr_31863[(4)] = cljs.core.rest((state_31859[(4)])));

return statearr_31863;
})();
var state_31859__$1 = state_31859;
var statearr_31864_31888 = state_31859__$1;
(statearr_31864_31888[(2)] = inst_31854);

(statearr_31864_31888[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (6))){
var inst_31836 = (state_31859[(7)]);
var inst_31840 = (state_31859[(2)]);
var inst_31841 = fluree.db.util.async.throw_err(inst_31840);
var state_31859__$1 = (function (){var statearr_31865 = state_31859;
(statearr_31865[(8)] = inst_31841);

return statearr_31865;
})();
if(cljs.core.truth_(inst_31836)){
var statearr_31866_31889 = state_31859__$1;
(statearr_31866_31889[(1)] = (7));

} else {
var statearr_31867_31890 = state_31859__$1;
(statearr_31867_31890[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (3))){
var inst_31857 = (state_31859[(2)]);
var state_31859__$1 = state_31859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31859__$1,inst_31857);
} else {
if((state_val_31860 === (12))){
var inst_31849 = (state_31859[(9)]);
var state_31859__$1 = state_31859;
var statearr_31868_31891 = state_31859__$1;
(statearr_31868_31891[(2)] = inst_31849);

(statearr_31868_31891[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (2))){
var _ = (function (){var statearr_31869 = state_31859;
(statearr_31869[(4)] = cljs.core.cons((5),(state_31859[(4)])));

return statearr_31869;
})();
var inst_31832 = q_map;
var inst_31833 = cljs.core.__destructure_map(inst_31832);
var inst_31834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31833,cljs.core.cst$kw$vars);
var inst_31835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31833,cljs.core.cst$kw$where);
var inst_31836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31833,cljs.core.cst$kw$optional);
var inst_31837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31833,cljs.core.cst$kw$filter);
var inst_31838 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_31835,q_map,inst_31834,fuel,max_fuel,opts);
var state_31859__$1 = (function (){var statearr_31870 = state_31859;
(statearr_31870[(7)] = inst_31836);

(statearr_31870[(10)] = inst_31837);

return statearr_31870;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31859__$1,(6),inst_31838);
} else {
if((state_val_31860 === (11))){
var inst_31837 = (state_31859[(10)]);
var inst_31849 = (state_31859[(9)]);
var inst_31851 = fluree.db.query.analytical.tuples__GT_filtered(inst_31849,inst_31837,null);
var state_31859__$1 = state_31859;
var statearr_31872_31892 = state_31859__$1;
(statearr_31872_31892[(2)] = inst_31851);

(statearr_31872_31892[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (9))){
var inst_31837 = (state_31859[(10)]);
var inst_31849 = (state_31859[(2)]);
var state_31859__$1 = (function (){var statearr_31873 = state_31859;
(statearr_31873[(9)] = inst_31849);

return statearr_31873;
})();
if(cljs.core.truth_(inst_31837)){
var statearr_31874_31893 = state_31859__$1;
(statearr_31874_31893[(1)] = (11));

} else {
var statearr_31875_31894 = state_31859__$1;
(statearr_31875_31894[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (5))){
var _ = (function (){var statearr_31876 = state_31859;
(statearr_31876[(4)] = cljs.core.rest((state_31859[(4)])));

return statearr_31876;
})();
var state_31859__$1 = state_31859;
var ex31871 = (state_31859__$1[(2)]);
var statearr_31877_31895 = state_31859__$1;
(statearr_31877_31895[(5)] = ex31871);


if((ex31871 instanceof Error)){
var statearr_31878_31896 = state_31859__$1;
(statearr_31878_31896[(1)] = (4));

(statearr_31878_31896[(5)] = null);

} else {
throw ex31871;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (10))){
var inst_31845 = (state_31859[(2)]);
var inst_31846 = fluree.db.util.async.throw_err(inst_31845);
var state_31859__$1 = state_31859;
var statearr_31879_31897 = state_31859__$1;
(statearr_31879_31897[(2)] = inst_31846);

(statearr_31879_31897[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31860 === (8))){
var inst_31841 = (state_31859[(8)]);
var state_31859__$1 = state_31859;
var statearr_31880_31898 = state_31859__$1;
(statearr_31880_31898[(2)] = inst_31841);

(statearr_31880_31898[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__13883__auto____0 = (function (){
var statearr_31881 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31881[(0)] = fluree$db$query$analytical$q_$_state_machine__13883__auto__);

(statearr_31881[(1)] = (1));

return statearr_31881;
});
var fluree$db$query$analytical$q_$_state_machine__13883__auto____1 = (function (state_31859){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31859);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31882){var ex__13886__auto__ = e31882;
var statearr_31883_31899 = state_31859;
(statearr_31883_31899[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31859[(4)]))){
var statearr_31884_31900 = state_31859;
(statearr_31884_31900[(1)] = cljs.core.first((state_31859[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31901 = state_31859;
state_31859 = G__31901;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__13883__auto__ = function(state_31859){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__13883__auto____1.call(this,state_31859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__13883__auto____0;
fluree$db$query$analytical$q_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$q_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31885 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31885[(6)] = c__13957__auto__);

return statearr_31885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
