// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44132 = arguments.length;
var i__4772__auto___44133 = (0);
while(true){
if((i__4772__auto___44133 < len__4771__auto___44132)){
args__4777__auto__.push((arguments[i__4772__auto___44133]));

var G__44134 = (i__4772__auto___44133 + (1));
i__4772__auto___44133 = G__44134;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq44129){
var G__44130 = cljs.core.first(seq44129);
var seq44129__$1 = cljs.core.next(seq44129);
var G__44131 = cljs.core.first(seq44129__$1);
var seq44129__$2 = cljs.core.next(seq44129__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44130,G__44131,seq44129__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e44135){var e = e44135;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e44136){var e = e44136;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e44137){var e = e44137;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e44138){var e = e44138;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e44139){var e = e44139;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44142 = arguments.length;
var i__4772__auto___44143 = (0);
while(true){
if((i__4772__auto___44143 < len__4771__auto___44142)){
args__4777__auto__.push((arguments[i__4772__auto___44143]));

var G__44144 = (i__4772__auto___44143 + (1));
i__4772__auto___44143 = G__44144;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44141){var e = e44141;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq44140){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44140));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44147 = arguments.length;
var i__4772__auto___44148 = (0);
while(true){
if((i__4772__auto___44148 < len__4771__auto___44147)){
args__4777__auto__.push((arguments[i__4772__auto___44148]));

var G__44149 = (i__4772__auto___44148 + (1));
i__4772__auto___44148 = G__44149;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44146){var e = e44146;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq44145){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44145));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e44150){var e = e44150;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44153 = arguments.length;
var i__4772__auto___44154 = (0);
while(true){
if((i__4772__auto___44154 < len__4771__auto___44153)){
args__4777__auto__.push((arguments[i__4772__auto___44154]));

var G__44155 = (i__4772__auto___44154 + (1));
i__4772__auto___44154 = G__44155;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e44152){var e = e44152;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq44151){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44151));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44158 = arguments.length;
var i__4772__auto___44159 = (0);
while(true){
if((i__4772__auto___44159 < len__4771__auto___44158)){
args__4777__auto__.push((arguments[i__4772__auto___44159]));

var G__44160 = (i__4772__auto___44159 + (1));
i__4772__auto___44159 = G__44160;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e44157){var e = e44157;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq44156){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44156));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e44161){var e = e44161;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e44162){var e = e44162;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44165 = arguments.length;
var i__4772__auto___44166 = (0);
while(true){
if((i__4772__auto___44166 < len__4771__auto___44165)){
args__4777__auto__.push((arguments[i__4772__auto___44166]));

var G__44167 = (i__4772__auto___44166 + (1));
i__4772__auto___44166 = G__44167;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44164){var e = e44164;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq44163){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44163));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44170 = arguments.length;
var i__4772__auto___44171 = (0);
while(true){
if((i__4772__auto___44171 < len__4771__auto___44170)){
args__4777__auto__.push((arguments[i__4772__auto___44171]));

var G__44172 = (i__4772__auto___44171 + (1));
i__4772__auto___44171 = G__44172;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44169){var e = e44169;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq44168){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44168));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44175 = arguments.length;
var i__4772__auto___44176 = (0);
while(true){
if((i__4772__auto___44176 < len__4771__auto___44175)){
args__4777__auto__.push((arguments[i__4772__auto___44176]));

var G__44177 = (i__4772__auto___44176 + (1));
i__4772__auto___44176 = G__44177;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e44174){var e = e44174;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq44173){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44173));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44180 = arguments.length;
var i__4772__auto___44181 = (0);
while(true){
if((i__4772__auto___44181 < len__4771__auto___44180)){
args__4777__auto__.push((arguments[i__4772__auto___44181]));

var G__44182 = (i__4772__auto___44181 + (1));
i__4772__auto___44181 = G__44182;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e44179){var e = e44179;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq44178){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44178));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44185 = arguments.length;
var i__4772__auto___44186 = (0);
while(true){
if((i__4772__auto___44186 < len__4771__auto___44185)){
args__4777__auto__.push((arguments[i__4772__auto___44186]));

var G__44187 = (i__4772__auto___44186 + (1));
i__4772__auto___44186 = G__44187;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e44184){var e = e44184;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq44183){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44183));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44190 = arguments.length;
var i__4772__auto___44191 = (0);
while(true){
if((i__4772__auto___44191 < len__4771__auto___44190)){
args__4777__auto__.push((arguments[i__4772__auto___44191]));

var G__44192 = (i__4772__auto___44191 + (1));
i__4772__auto___44191 = G__44192;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e44189){var e = e44189;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq44188){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44188));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44195 = arguments.length;
var i__4772__auto___44196 = (0);
while(true){
if((i__4772__auto___44196 < len__4771__auto___44195)){
args__4777__auto__.push((arguments[i__4772__auto___44196]));

var G__44197 = (i__4772__auto___44196 + (1));
i__4772__auto___44196 = G__44197;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e44194){var e = e44194;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq44193){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44193));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__44199 = arguments.length;
switch (G__44199) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44227){
var state_val_44228 = (state_44227[(1)]);
if((state_val_44228 === (7))){
var inst_44212 = (state_44227[(7)]);
var inst_44215 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44212,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_44227__$1 = state_44227;
var statearr_44229_44315 = state_44227__$1;
(statearr_44229_44315[(2)] = inst_44215);

(statearr_44229_44315[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (1))){
var state_44227__$1 = state_44227;
var statearr_44230_44316 = state_44227__$1;
(statearr_44230_44316[(2)] = null);

(statearr_44230_44316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (4))){
var inst_44200 = (state_44227[(2)]);
var state_44227__$1 = state_44227;
var statearr_44231_44317 = state_44227__$1;
(statearr_44231_44317[(2)] = inst_44200);

(statearr_44231_44317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (6))){
var inst_44212 = (state_44227[(7)]);
var inst_44212__$1 = (state_44227[(2)]);
var inst_44213 = fluree.db.util.core.exception_QMARK_(inst_44212__$1);
var state_44227__$1 = (function (){var statearr_44232 = state_44227;
(statearr_44232[(7)] = inst_44212__$1);

return statearr_44232;
})();
if(inst_44213){
var statearr_44233_44318 = state_44227__$1;
(statearr_44233_44318[(1)] = (7));

} else {
var statearr_44234_44319 = state_44227__$1;
(statearr_44234_44319[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (3))){
var inst_44225 = (state_44227[(2)]);
var state_44227__$1 = state_44227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44227__$1,inst_44225);
} else {
if((state_val_44228 === (2))){
var inst_44206 = (state_44227[(8)]);
var _ = (function (){var statearr_44236 = state_44227;
(statearr_44236[(4)] = cljs.core.cons((5),(state_44227[(4)])));

return statearr_44236;
})();
var inst_44206__$1 = cljs.core.volatile_BANG_((0));
var inst_44207 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_44208 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_44207,cljs.core.cst$kw$fuel,inst_44206__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_44209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_44208);
var inst_44210 = fluree.db.query.fql.query(db,inst_44209);
var state_44227__$1 = (function (){var statearr_44237 = state_44227;
(statearr_44237[(8)] = inst_44206__$1);

return statearr_44237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44227__$1,(6),inst_44210);
} else {
if((state_val_44228 === (9))){
var inst_44222 = (state_44227[(2)]);
var _ = (function (){var statearr_44238 = state_44227;
(statearr_44238[(4)] = cljs.core.rest((state_44227[(4)])));

return statearr_44238;
})();
var state_44227__$1 = state_44227;
var statearr_44239_44320 = state_44227__$1;
(statearr_44239_44320[(2)] = inst_44222);

(statearr_44239_44320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (5))){
var _ = (function (){var statearr_44240 = state_44227;
(statearr_44240[(4)] = cljs.core.rest((state_44227[(4)])));

return statearr_44240;
})();
var state_44227__$1 = state_44227;
var ex44235 = (state_44227__$1[(2)]);
var statearr_44241_44321 = state_44227__$1;
(statearr_44241_44321[(5)] = ex44235);


if((ex44235 instanceof Error)){
var statearr_44242_44322 = state_44227__$1;
(statearr_44242_44322[(1)] = (4));

(statearr_44242_44322[(5)] = null);

} else {
throw ex44235;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (8))){
var inst_44212 = (state_44227[(7)]);
var inst_44206 = (state_44227[(8)]);
var inst_44217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44218 = cljs.core.deref(inst_44206);
var inst_44219 = [inst_44212,inst_44218];
var inst_44220 = (new cljs.core.PersistentVector(null,2,(5),inst_44217,inst_44219,null));
var state_44227__$1 = state_44227;
var statearr_44243_44323 = state_44227__$1;
(statearr_44243_44323[(2)] = inst_44220);

(statearr_44243_44323[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44244 = [null,null,null,null,null,null,null,null,null];
(statearr_44244[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44244[(1)] = (1));

return statearr_44244;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44227){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44227);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44245){var ex__13886__auto__ = e44245;
var statearr_44246_44324 = state_44227;
(statearr_44246_44324[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44227[(4)]))){
var statearr_44247_44325 = state_44227;
(statearr_44247_44325[(1)] = cljs.core.first((state_44227[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44326 = state_44227;
state_44227 = G__44326;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44248 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44248[(6)] = c__13957__auto__);

return statearr_44248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44293){
var state_val_44294 = (state_44293[(1)]);
if((state_val_44294 === (7))){
var inst_44279 = (state_44293[(2)]);
var inst_44280 = fluree.db.query.fql.query(db,inst_44279);
var state_44293__$1 = state_44293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44293__$1,(8),inst_44280);
} else {
if((state_val_44294 === (1))){
var inst_44249 = typeof select === 'string';
var state_44293__$1 = state_44293;
if(cljs.core.truth_(inst_44249)){
var statearr_44295_44327 = state_44293__$1;
(statearr_44295_44327[(1)] = (2));

} else {
var statearr_44296_44328 = state_44293__$1;
(statearr_44296_44328[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (4))){
var inst_44255 = (state_44293[(7)]);
var inst_44262 = (state_44293[(8)]);
var inst_44254 = (state_44293[(2)]);
var inst_44255__$1 = cljs.core.volatile_BANG_((0));
var inst_44256 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_44257 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_44258 = [inst_44255__$1,(100000)];
var inst_44259 = cljs.core.PersistentHashMap.fromArrays(inst_44257,inst_44258);
var inst_44260 = [inst_44254,from,where,block,limit,inst_44259];
var inst_44261 = cljs.core.PersistentHashMap.fromArrays(inst_44256,inst_44260);
var inst_44262__$1 = fluree.db.util.core.without_nils(inst_44261);
var inst_44263 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44262__$1);
var inst_44264 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44262__$1);
var inst_44265 = cljs.core.first(inst_44264);
var inst_44266 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44265], 0));
var inst_44267 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_44266);
var inst_44268 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44262__$1);
var inst_44269 = cljs.core.last(inst_44268);
var inst_44270 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44269], 0));
var inst_44271 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_44270);
var inst_44272 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44263,inst_44267,inst_44271], 0));
var state_44293__$1 = (function (){var statearr_44297 = state_44293;
(statearr_44297[(7)] = inst_44255__$1);

(statearr_44297[(8)] = inst_44262__$1);

return statearr_44297;
})();
if(cljs.core.truth_(inst_44272)){
var statearr_44298_44329 = state_44293__$1;
(statearr_44298_44329[(1)] = (5));

} else {
var statearr_44299_44330 = state_44293__$1;
(statearr_44299_44330[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (6))){
var inst_44262 = (state_44293[(8)]);
var state_44293__$1 = state_44293;
var statearr_44300_44331 = state_44293__$1;
(statearr_44300_44331[(2)] = inst_44262);

(statearr_44300_44331[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (3))){
var state_44293__$1 = state_44293;
var statearr_44301_44332 = state_44293__$1;
(statearr_44301_44332[(2)] = select);

(statearr_44301_44332[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (2))){
var inst_44251 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_44293__$1 = state_44293;
var statearr_44302_44333 = state_44293__$1;
(statearr_44302_44333[(2)] = inst_44251);

(statearr_44302_44333[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (11))){
var inst_44291 = (state_44293[(2)]);
var state_44293__$1 = state_44293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44293__$1,inst_44291);
} else {
if((state_val_44294 === (9))){
var inst_44282 = (state_44293[(9)]);
var state_44293__$1 = state_44293;
var statearr_44303_44334 = state_44293__$1;
(statearr_44303_44334[(2)] = inst_44282);

(statearr_44303_44334[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (5))){
var inst_44262 = (state_44293[(8)]);
var inst_44274 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44262);
var inst_44275 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_44274);
var inst_44276 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44262,cljs.core.cst$kw$where,inst_44275);
var state_44293__$1 = state_44293;
var statearr_44304_44335 = state_44293__$1;
(statearr_44304_44335[(2)] = inst_44276);

(statearr_44304_44335[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (10))){
var inst_44255 = (state_44293[(7)]);
var inst_44282 = (state_44293[(9)]);
var inst_44286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44287 = cljs.core.deref(inst_44255);
var inst_44288 = [inst_44282,inst_44287];
var inst_44289 = (new cljs.core.PersistentVector(null,2,(5),inst_44286,inst_44288,null));
var state_44293__$1 = state_44293;
var statearr_44305_44336 = state_44293__$1;
(statearr_44305_44336[(2)] = inst_44289);

(statearr_44305_44336[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44294 === (8))){
var inst_44282 = (state_44293[(9)]);
var inst_44282__$1 = (state_44293[(2)]);
var inst_44283 = fluree.db.util.core.exception_QMARK_(inst_44282__$1);
var state_44293__$1 = (function (){var statearr_44306 = state_44293;
(statearr_44306[(9)] = inst_44282__$1);

return statearr_44306;
})();
if(inst_44283){
var statearr_44307_44337 = state_44293__$1;
(statearr_44307_44337[(1)] = (9));

} else {
var statearr_44308_44338 = state_44293__$1;
(statearr_44308_44338[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44309 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44309[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44309[(1)] = (1));

return statearr_44309;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44293){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44293);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44310){var ex__13886__auto__ = e44310;
var statearr_44311_44339 = state_44293;
(statearr_44311_44339[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44293[(4)]))){
var statearr_44312_44340 = state_44293;
(statearr_44312_44340[(1)] = cljs.core.first((state_44293[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44341 = state_44293;
state_44293 = G__44341;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44313 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44313[(6)] = c__13957__auto__);

return statearr_44313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__44345 = path;
var vec__44346 = G__44345;
var seq__44347 = cljs.core.seq(vec__44346);
var first__44348 = cljs.core.first(seq__44347);
var seq__44347__$1 = cljs.core.next(seq__44347);
var var$ = first__44348;
var r = seq__44347__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__44345__$1 = G__44345;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__44352 = G__44345__$1;
var seq__44353 = cljs.core.seq(vec__44352);
var first__44354 = cljs.core.first(seq__44353);
var seq__44353__$1 = cljs.core.next(seq__44353);
var var$__$1 = first__44354;
var r__$1 = seq__44353__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__44355 = r__$1;
var G__44356 = n__$2;
var G__44357 = next_clauses;
G__44345__$1 = G__44355;
n__$1 = G__44356;
where_clauses__$1 = G__44357;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__44358 = r__$1;
var G__44359 = next_n;
var G__44360 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__44345__$1 = G__44358;
n__$1 = G__44359;
where_clauses__$1 = G__44360;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44397){
var state_val_44398 = (state_44397[(1)]);
if((state_val_44398 === (7))){
var inst_44370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44371 = [path];
var inst_44372 = (new cljs.core.PersistentVector(null,1,(5),inst_44370,inst_44371,null));
var state_44397__$1 = state_44397;
var statearr_44399_44427 = state_44397__$1;
(statearr_44399_44427[(2)] = inst_44372);

(statearr_44399_44427[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (1))){
var state_44397__$1 = state_44397;
var statearr_44400_44428 = state_44397__$1;
(statearr_44400_44428[(2)] = null);

(statearr_44400_44428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (4))){
var inst_44361 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
var statearr_44401_44429 = state_44397__$1;
(statearr_44401_44429[(2)] = inst_44361);

(statearr_44401_44429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (13))){
var inst_44388 = (state_44397[(2)]);
var inst_44389 = fluree.db.util.async.throw_err(inst_44388);
var _ = (function (){var statearr_44402 = state_44397;
(statearr_44402[(4)] = cljs.core.rest((state_44397[(4)])));

return statearr_44402;
})();
var state_44397__$1 = state_44397;
var statearr_44403_44430 = state_44397__$1;
(statearr_44403_44430[(2)] = inst_44389);

(statearr_44403_44430[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (6))){
var state_44397__$1 = state_44397;
var statearr_44405_44431 = state_44397__$1;
(statearr_44405_44431[(2)] = path);

(statearr_44405_44431[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (3))){
var inst_44395 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44397__$1,inst_44395);
} else {
if((state_val_44398 === (12))){
var _ = (function (){var statearr_44406 = state_44397;
(statearr_44406[(4)] = cljs.core.rest((state_44397[(4)])));

return statearr_44406;
})();
var state_44397__$1 = state_44397;
var ex44404 = (state_44397__$1[(2)]);
var statearr_44407_44432 = state_44397__$1;
(statearr_44407_44432[(5)] = ex44404);


var statearr_44408_44433 = state_44397__$1;
(statearr_44408_44433[(1)] = (11));

(statearr_44408_44433[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (2))){
var _ = (function (){var statearr_44409 = state_44397;
(statearr_44409[(4)] = cljs.core.cons((5),(state_44397[(4)])));

return statearr_44409;
})();
var inst_44367 = cljs.core.vector_QMARK_(path);
var state_44397__$1 = state_44397;
if(inst_44367){
var statearr_44410_44434 = state_44397__$1;
(statearr_44410_44434[(1)] = (6));

} else {
var statearr_44411_44435 = state_44397__$1;
(statearr_44411_44435[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (11))){
var inst_44374 = (state_44397[(7)]);
var inst_44379 = (state_44397[(2)]);
var inst_44380 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44379,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_44374,endSubject], 0));
var state_44397__$1 = state_44397;
var statearr_44413_44436 = state_44397__$1;
(statearr_44413_44436[(2)] = inst_44380);

(statearr_44413_44436[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (9))){
var inst_44378 = (state_44397[(8)]);
var _ = (function (){var statearr_44414 = state_44397;
(statearr_44414[(4)] = cljs.core.cons((12),(state_44397[(4)])));

return statearr_44414;
})();
var inst_44386 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_44378);
var state_44397__$1 = state_44397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44397__$1,(13),inst_44386);
} else {
if((state_val_44398 === (5))){
var _ = (function (){var statearr_44415 = state_44397;
(statearr_44415[(4)] = cljs.core.rest((state_44397[(4)])));

return statearr_44415;
})();
var state_44397__$1 = state_44397;
var ex44412 = (state_44397__$1[(2)]);
var statearr_44416_44437 = state_44397__$1;
(statearr_44416_44437[(5)] = ex44412);


if((ex44412 instanceof Error)){
var statearr_44417_44438 = state_44397__$1;
(statearr_44417_44438[(1)] = (4));

(statearr_44417_44438[(5)] = null);

} else {
throw ex44412;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (10))){
var inst_44392 = (state_44397[(2)]);
var _ = (function (){var statearr_44418 = state_44397;
(statearr_44418[(4)] = cljs.core.rest((state_44397[(4)])));

return statearr_44418;
})();
var state_44397__$1 = state_44397;
var statearr_44419_44439 = state_44397__$1;
(statearr_44419_44439[(2)] = inst_44392);

(statearr_44419_44439[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44398 === (8))){
var inst_44374 = (state_44397[(7)]);
var inst_44374__$1 = (state_44397[(2)]);
var inst_44375 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_44374__$1,endSubject);
var inst_44376 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_44377 = ["?var1",inst_44375];
var inst_44378 = cljs.core.PersistentHashMap.fromArrays(inst_44376,inst_44377);
var state_44397__$1 = (function (){var statearr_44420 = state_44397;
(statearr_44420[(8)] = inst_44378);

(statearr_44420[(7)] = inst_44374__$1);

return statearr_44420;
})();
var statearr_44421_44440 = state_44397__$1;
(statearr_44421_44440[(2)] = null);

(statearr_44421_44440[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_44422 = [null,null,null,null,null,null,null,null,null];
(statearr_44422[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__);

(statearr_44422[(1)] = (1));

return statearr_44422;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1 = (function (state_44397){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44397);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44423){var ex__13886__auto__ = e44423;
var statearr_44424_44441 = state_44397;
(statearr_44424_44441[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44397[(4)]))){
var statearr_44425_44442 = state_44397;
(statearr_44425_44442[(1)] = cljs.core.first((state_44397[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44443 = state_44397;
state_44397 = G__44443;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__ = function(state_44397){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1.call(this,state_44397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44426 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44426[(6)] = c__13957__auto__);

return statearr_44426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e44444){var e = e44444;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e44445){var e = e44445;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e44446){var e = e44446;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e44447){var e = e44447;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44450 = arguments.length;
var i__4772__auto___44451 = (0);
while(true){
if((i__4772__auto___44451 < len__4771__auto___44450)){
args__4777__auto__.push((arguments[i__4772__auto___44451]));

var G__44452 = (i__4772__auto___44451 + (1));
i__4772__auto___44451 = G__44452;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e44449){var e = e44449;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq44448){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44448));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44455 = arguments.length;
var i__4772__auto___44456 = (0);
while(true){
if((i__4772__auto___44456 < len__4771__auto___44455)){
args__4777__auto__.push((arguments[i__4772__auto___44456]));

var G__44457 = (i__4772__auto___44456 + (1));
i__4772__auto___44456 = G__44457;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e44454){var e = e44454;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq44453){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44453));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44460 = arguments.length;
var i__4772__auto___44461 = (0);
while(true){
if((i__4772__auto___44461 < len__4771__auto___44460)){
args__4777__auto__.push((arguments[i__4772__auto___44461]));

var G__44462 = (i__4772__auto___44461 + (1));
i__4772__auto___44461 = G__44462;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4160__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e44459){var e = e44459;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq44458){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44458));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44465 = arguments.length;
var i__4772__auto___44466 = (0);
while(true){
if((i__4772__auto___44466 < len__4771__auto___44465)){
args__4777__auto__.push((arguments[i__4772__auto___44466]));

var G__44467 = (i__4772__auto___44466 + (1));
i__4772__auto___44466 = G__44467;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e44464){var e = e44464;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq44463){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44463));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e44468){var e = e44468;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e44469){var e = e44469;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e44470){var e = e44470;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e44471){var e = e44471;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e44472){var e = e44472;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__44478 = path;
var vec__44479 = G__44478;
var seq__44480 = cljs.core.seq(vec__44479);
var first__44481 = cljs.core.first(seq__44480);
var seq__44480__$1 = cljs.core.next(seq__44480);
var pred = first__44481;
var r = seq__44480__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__44478__$1 = G__44478;
var subjects__$1 = subjects;
while(true){
var vec__44485 = G__44478__$1;
var seq__44486 = cljs.core.seq(vec__44485);
var first__44487 = cljs.core.first(seq__44486);
var seq__44486__$1 = cljs.core.next(seq__44486);
var pred__$1 = first__44487;
var r__$1 = seq__44486__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__44478__$1,subjects__$1,vec__44485,seq__44486,first__44487,seq__44486__$1,pred__$1,r__$1,subjects__$2,G__44478,vec__44479,seq__44480,first__44481,seq__44480__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__44478__$1,subjects__$1,vec__44485,seq__44486,first__44487,seq__44486__$1,pred__$1,r__$1,subjects__$2,G__44478,vec__44479,seq__44480,first__44481,seq__44480__$1,pred,r,subjects){
return (function (p1__44473_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__44473_SHARP_,pred__$1);
});})(G__44478__$1,subjects__$1,vec__44485,seq__44486,first__44487,seq__44486__$1,pred__$1,r__$1,subjects__$2,G__44478,vec__44479,seq__44480,first__44481,seq__44480__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__44478__$1,subjects__$1,vec__44485,seq__44486,first__44487,seq__44486__$1,pred__$1,r__$1,subjects__$2,G__44478,vec__44479,seq__44480,first__44481,seq__44480__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4149__auto__ = r__$1;
if(and__4149__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4149__auto__;
}
})())){
var G__44488 = r__$1;
var G__44489 = next_subjects;
G__44478__$1 = G__44488;
subjects__$1 = G__44489;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e44474){var e = e44474;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e44490){var e = e44490;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e44491){var e = e44491;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44494 = arguments.length;
var i__4772__auto___44495 = (0);
while(true){
if((i__4772__auto___44495 < len__4771__auto___44494)){
args__4777__auto__.push((arguments[i__4772__auto___44495]));

var G__44496 = (i__4772__auto___44495 + (1));
i__4772__auto___44495 = G__44496;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e44493){var e = e44493;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq44492){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44492));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e44497){var e = e44497;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44500 = arguments.length;
var i__4772__auto___44501 = (0);
while(true){
if((i__4772__auto___44501 < len__4771__auto___44500)){
args__4777__auto__.push((arguments[i__4772__auto___44501]));

var G__44502 = (i__4772__auto___44501 + (1));
i__4772__auto___44501 = G__44502;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e44499){var e = e44499;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq44498){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44498));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e44503){var e = e44503;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44558){
var state_val_44559 = (state_44558[(1)]);
if((state_val_44559 === (7))){
var inst_44505 = (state_44558[(2)]);
var state_44558__$1 = state_44558;
var statearr_44560_44593 = state_44558__$1;
(statearr_44560_44593[(2)] = inst_44505);

(statearr_44560_44593[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (1))){
var state_44558__$1 = state_44558;
var statearr_44561_44594 = state_44558__$1;
(statearr_44561_44594[(2)] = null);

(statearr_44561_44594[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (4))){
var inst_44504 = (state_44558[(2)]);
var state_44558__$1 = (function (){var statearr_44562 = state_44558;
(statearr_44562[(7)] = inst_44504);

return statearr_44562;
})();
var statearr_44563_44595 = state_44558__$1;
(statearr_44563_44595[(2)] = null);

(statearr_44563_44595[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (15))){
var inst_44542 = (state_44558[(8)]);
var inst_44546 = inst_44542.o;
var state_44558__$1 = state_44558;
var statearr_44564_44596 = state_44558__$1;
(statearr_44564_44596[(2)] = inst_44546);

(statearr_44564_44596[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (13))){
var inst_44542 = (state_44558[(8)]);
var inst_44538 = (state_44558[(2)]);
var inst_44539 = fluree.db.util.async.throw_err(inst_44538);
var inst_44540 = fluree.db.dbfunctions.internal.count(inst_44539);
var inst_44542__$1 = cljs.core.first(inst_44539);
var inst_44543 = (inst_44542__$1 == null);
var state_44558__$1 = (function (){var statearr_44565 = state_44558;
(statearr_44565[(8)] = inst_44542__$1);

(statearr_44565[(9)] = inst_44540);

return statearr_44565;
})();
if(cljs.core.truth_(inst_44543)){
var statearr_44566_44597 = state_44558__$1;
(statearr_44566_44597[(1)] = (14));

} else {
var statearr_44567_44598 = state_44558__$1;
(statearr_44567_44598[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (6))){
var inst_44514 = (state_44558[(2)]);
var state_44558__$1 = state_44558;
var statearr_44568_44599 = state_44558__$1;
(statearr_44568_44599[(2)] = inst_44514);

(statearr_44568_44599[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (3))){
var inst_44556 = (state_44558[(2)]);
var state_44558__$1 = state_44558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44558__$1,inst_44556);
} else {
if((state_val_44559 === (12))){
var inst_44553 = (state_44558[(2)]);
var _ = (function (){var statearr_44569 = state_44558;
(statearr_44569[(4)] = cljs.core.rest((state_44558[(4)])));

return statearr_44569;
})();
var state_44558__$1 = state_44558;
var statearr_44570_44600 = state_44558__$1;
(statearr_44570_44600[(2)] = inst_44553);

(statearr_44570_44600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (2))){
var _ = (function (){var statearr_44572 = state_44558;
(statearr_44572[(4)] = cljs.core.cons((9),(state_44558[(4)])));

return statearr_44572;
})();
var inst_44520 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44521 = typeof inst_44520 === 'string';
var state_44558__$1 = state_44558;
if(cljs.core.truth_(inst_44521)){
var statearr_44573_44601 = state_44558__$1;
(statearr_44573_44601[(1)] = (10));

} else {
var statearr_44574_44602 = state_44558__$1;
(statearr_44574_44602[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (11))){
var inst_44527 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44528 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_44527);
var inst_44529 = fluree.db.dbfunctions.internal.inc(inst_44528);
var inst_44530 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44527,cljs.core.cst$kw$t,inst_44529);
var inst_44531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44532 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44533 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44534 = [inst_44532,inst_44533];
var inst_44535 = (new cljs.core.PersistentVector(null,2,(5),inst_44531,inst_44534,null));
var inst_44536 = fluree.db.dbproto._search(inst_44530,inst_44535);
var state_44558__$1 = state_44558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44558__$1,(13),inst_44536);
} else {
if((state_val_44559 === (9))){
var _ = (function (){var statearr_44575 = state_44558;
(statearr_44575[(4)] = cljs.core.rest((state_44558[(4)])));

return statearr_44575;
})();
var state_44558__$1 = state_44558;
var ex44571 = (state_44558__$1[(2)]);
var statearr_44576_44603 = state_44558__$1;
(statearr_44576_44603[(5)] = ex44571);


var statearr_44577_44604 = state_44558__$1;
(statearr_44577_44604[(1)] = (4));

(statearr_44577_44604[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (5))){
var inst_44504 = (state_44558[(7)]);
var _ = (function (){var statearr_44578 = state_44558;
(statearr_44578[(4)] = cljs.core.cons((8),(state_44558[(4)])));

return statearr_44578;
})();
var inst_44511 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44504,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_44579 = state_44558;
(statearr_44579[(4)] = cljs.core.rest((state_44558[(4)])));

return statearr_44579;
})();
var state_44558__$1 = state_44558;
var statearr_44580_44605 = state_44558__$1;
(statearr_44580_44605[(2)] = inst_44511);

(statearr_44580_44605[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (14))){
var state_44558__$1 = state_44558;
var statearr_44581_44606 = state_44558__$1;
(statearr_44581_44606[(2)] = null);

(statearr_44581_44606[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (16))){
var inst_44540 = (state_44558[(9)]);
var inst_44548 = (state_44558[(2)]);
var inst_44549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44550 = [inst_44548,inst_44540];
var inst_44551 = (new cljs.core.PersistentVector(null,2,(5),inst_44549,inst_44550,null));
var state_44558__$1 = state_44558;
var statearr_44583_44607 = state_44558__$1;
(statearr_44583_44607[(2)] = inst_44551);

(statearr_44583_44607[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (10))){
var inst_44523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44524 = [null,(0)];
var inst_44525 = (new cljs.core.PersistentVector(null,2,(5),inst_44523,inst_44524,null));
var state_44558__$1 = state_44558;
var statearr_44584_44608 = state_44558__$1;
(statearr_44584_44608[(2)] = inst_44525);

(statearr_44584_44608[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44559 === (8))){
var _ = (function (){var statearr_44585 = state_44558;
(statearr_44585[(4)] = cljs.core.rest((state_44558[(4)])));

return statearr_44585;
})();
var state_44558__$1 = state_44558;
var ex44582 = (state_44558__$1[(2)]);
var statearr_44586_44609 = state_44558__$1;
(statearr_44586_44609[(5)] = ex44582);


var statearr_44587_44610 = state_44558__$1;
(statearr_44587_44610[(1)] = (7));

(statearr_44587_44610[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0 = (function (){
var statearr_44588 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44588[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__);

(statearr_44588[(1)] = (1));

return statearr_44588;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1 = (function (state_44558){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44558);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44589){var ex__13886__auto__ = e44589;
var statearr_44590_44611 = state_44558;
(statearr_44590_44611[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44558[(4)]))){
var statearr_44591_44612 = state_44558;
(statearr_44591_44612[(1)] = cljs.core.first((state_44558[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44613 = state_44558;
state_44558 = G__44613;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__ = function(state_44558){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1.call(this,state_44558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44592 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44592[(6)] = c__13957__auto__);

return statearr_44592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44665){
var state_val_44666 = (state_44665[(1)]);
if((state_val_44666 === (7))){
var inst_44615 = (state_44665[(2)]);
var state_44665__$1 = state_44665;
var statearr_44667_44696 = state_44665__$1;
(statearr_44667_44696[(2)] = inst_44615);

(statearr_44667_44696[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (1))){
var state_44665__$1 = state_44665;
var statearr_44668_44697 = state_44665__$1;
(statearr_44668_44697[(2)] = null);

(statearr_44668_44697[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (4))){
var inst_44614 = (state_44665[(2)]);
var state_44665__$1 = (function (){var statearr_44669 = state_44665;
(statearr_44669[(7)] = inst_44614);

return statearr_44669;
})();
var statearr_44670_44698 = state_44665__$1;
(statearr_44670_44698[(2)] = null);

(statearr_44670_44698[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (13))){
var inst_44660 = (state_44665[(2)]);
var _ = (function (){var statearr_44671 = state_44665;
(statearr_44671[(4)] = cljs.core.rest((state_44665[(4)])));

return statearr_44671;
})();
var state_44665__$1 = state_44665;
var statearr_44672_44699 = state_44665__$1;
(statearr_44672_44699[(2)] = inst_44660);

(statearr_44672_44699[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (6))){
var inst_44624 = (state_44665[(2)]);
var state_44665__$1 = state_44665;
var statearr_44673_44700 = state_44665__$1;
(statearr_44673_44700[(2)] = inst_44624);

(statearr_44673_44700[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (3))){
var inst_44663 = (state_44665[(2)]);
var state_44665__$1 = state_44665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44665__$1,inst_44663);
} else {
if((state_val_44666 === (12))){
var inst_44647 = (state_44665[(8)]);
var inst_44656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44657 = [null,inst_44647];
var inst_44658 = (new cljs.core.PersistentVector(null,2,(5),inst_44656,inst_44657,null));
var state_44665__$1 = state_44665;
var statearr_44674_44701 = state_44665__$1;
(statearr_44674_44701[(2)] = inst_44658);

(statearr_44674_44701[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (2))){
var _ = (function (){var statearr_44676 = state_44665;
(statearr_44676[(4)] = cljs.core.cons((9),(state_44665[(4)])));

return statearr_44676;
})();
var inst_44633 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_44634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44636 = [null,pred_name,"?o"];
var inst_44637 = (new cljs.core.PersistentVector(null,3,(5),inst_44635,inst_44636,null));
var inst_44638 = [inst_44637];
var inst_44639 = (new cljs.core.PersistentVector(null,1,(5),inst_44634,inst_44638,null));
var inst_44640 = ["?o",inst_44639,opts];
var inst_44641 = cljs.core.PersistentHashMap.fromArrays(inst_44633,inst_44640);
var inst_44642 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_44641);
var state_44665__$1 = state_44665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44665__$1,(10),inst_44642);
} else {
if((state_val_44666 === (11))){
var inst_44646 = (state_44665[(9)]);
var inst_44647 = (state_44665[(8)]);
var inst_44651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44652 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_44646);
var inst_44653 = [inst_44652,inst_44647];
var inst_44654 = (new cljs.core.PersistentVector(null,2,(5),inst_44651,inst_44653,null));
var state_44665__$1 = state_44665;
var statearr_44677_44702 = state_44665__$1;
(statearr_44677_44702[(2)] = inst_44654);

(statearr_44677_44702[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (9))){
var _ = (function (){var statearr_44678 = state_44665;
(statearr_44678[(4)] = cljs.core.rest((state_44665[(4)])));

return statearr_44678;
})();
var state_44665__$1 = state_44665;
var ex44675 = (state_44665__$1[(2)]);
var statearr_44679_44703 = state_44665__$1;
(statearr_44679_44703[(5)] = ex44675);


var statearr_44680_44704 = state_44665__$1;
(statearr_44680_44704[(1)] = (4));

(statearr_44680_44704[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (5))){
var inst_44614 = (state_44665[(7)]);
var _ = (function (){var statearr_44682 = state_44665;
(statearr_44682[(4)] = cljs.core.cons((8),(state_44665[(4)])));

return statearr_44682;
})();
var inst_44621 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44614,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_44683 = state_44665;
(statearr_44683[(4)] = cljs.core.rest((state_44665[(4)])));

return statearr_44683;
})();
var state_44665__$1 = state_44665;
var statearr_44684_44705 = state_44665__$1;
(statearr_44684_44705[(2)] = inst_44621);

(statearr_44684_44705[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (10))){
var inst_44646 = (state_44665[(9)]);
var inst_44644 = (state_44665[(2)]);
var inst_44645 = fluree.db.util.async.throw_err(inst_44644);
var inst_44646__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44645,(0),null);
var inst_44647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44645,(1),null);
var inst_44648 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_44646__$1);
var inst_44649 = cljs.core.not(inst_44648);
var state_44665__$1 = (function (){var statearr_44685 = state_44665;
(statearr_44685[(9)] = inst_44646__$1);

(statearr_44685[(8)] = inst_44647);

return statearr_44685;
})();
if(inst_44649){
var statearr_44686_44706 = state_44665__$1;
(statearr_44686_44706[(1)] = (11));

} else {
var statearr_44687_44707 = state_44665__$1;
(statearr_44687_44707[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44666 === (8))){
var _ = (function (){var statearr_44688 = state_44665;
(statearr_44688[(4)] = cljs.core.rest((state_44665[(4)])));

return statearr_44688;
})();
var state_44665__$1 = state_44665;
var ex44681 = (state_44665__$1[(2)]);
var statearr_44689_44708 = state_44665__$1;
(statearr_44689_44708[(5)] = ex44681);


var statearr_44690_44709 = state_44665__$1;
(statearr_44690_44709[(1)] = (7));

(statearr_44690_44709[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0 = (function (){
var statearr_44691 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44691[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__);

(statearr_44691[(1)] = (1));

return statearr_44691;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1 = (function (state_44665){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44665);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44692){var ex__13886__auto__ = e44692;
var statearr_44693_44710 = state_44665;
(statearr_44693_44710[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44665[(4)]))){
var statearr_44694_44711 = state_44665;
(statearr_44694_44711[(1)] = cljs.core.first((state_44665[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44712 = state_44665;
state_44665 = G__44712;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__ = function(state_44665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1.call(this,state_44665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44695 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44695[(6)] = c__13957__auto__);

return statearr_44695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e44713){var e = e44713;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__44715 = arguments.length;
switch (G__44715) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44785){
var state_val_44786 = (state_44785[(1)]);
if((state_val_44786 === (7))){
var inst_44717 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44787_44831 = state_44785__$1;
(statearr_44787_44831[(2)] = inst_44717);

(statearr_44787_44831[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (20))){
var inst_44761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44762 = ["*"];
var inst_44763 = (new cljs.core.PersistentVector(null,1,(5),inst_44761,inst_44762,null));
var state_44785__$1 = state_44785;
var statearr_44788_44832 = state_44785__$1;
(statearr_44788_44832[(2)] = inst_44763);

(statearr_44788_44832[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (1))){
var state_44785__$1 = state_44785;
var statearr_44789_44833 = state_44785__$1;
(statearr_44789_44833[(2)] = null);

(statearr_44789_44833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (4))){
var inst_44716 = (state_44785[(2)]);
var state_44785__$1 = (function (){var statearr_44790 = state_44785;
(statearr_44790[(7)] = inst_44716);

return statearr_44790;
})();
var statearr_44791_44834 = state_44785__$1;
(statearr_44791_44834[(2)] = null);

(statearr_44791_44834[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (15))){
var inst_44780 = (state_44785[(2)]);
var _ = (function (){var statearr_44792 = state_44785;
(statearr_44792[(4)] = cljs.core.rest((state_44785[(4)])));

return statearr_44792;
})();
var state_44785__$1 = state_44785;
var statearr_44793_44835 = state_44785__$1;
(statearr_44793_44835[(2)] = inst_44780);

(statearr_44793_44835[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (21))){
var inst_44744 = (state_44785[(8)]);
var inst_44751 = (state_44785[(9)]);
var inst_44765 = (state_44785[(2)]);
var inst_44766 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44767 = cljs.core.PersistentHashMap.EMPTY;
var inst_44768 = [inst_44765,inst_44751,inst_44767];
var inst_44769 = cljs.core.PersistentHashMap.fromArrays(inst_44766,inst_44768);
var inst_44770 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_44744,inst_44769);
var state_44785__$1 = state_44785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44785__$1,(22),inst_44770);
} else {
if((state_val_44786 === (13))){
var inst_44739 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44785__$1 = state_44785;
var statearr_44794_44836 = state_44785__$1;
(statearr_44794_44836[(2)] = inst_44739);

(statearr_44794_44836[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (22))){
var inst_44772 = (state_44785[(2)]);
var inst_44773 = fluree.db.util.async.throw_err(inst_44772);
var inst_44774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44773,(0),null);
var inst_44775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44773,(1),null);
var inst_44776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44777 = [inst_44774,inst_44775];
var inst_44778 = (new cljs.core.PersistentVector(null,2,(5),inst_44776,inst_44777,null));
var state_44785__$1 = state_44785;
var statearr_44795_44837 = state_44785__$1;
(statearr_44795_44837[(2)] = inst_44778);

(statearr_44795_44837[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (6))){
var inst_44726 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
var statearr_44796_44838 = state_44785__$1;
(statearr_44796_44838[(2)] = inst_44726);

(statearr_44796_44838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (17))){
var inst_44748 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44749 = fluree.db.dbfunctions.internal.get(inst_44748,cljs.core.cst$kw$_id);
var state_44785__$1 = state_44785;
var statearr_44797_44839 = state_44785__$1;
(statearr_44797_44839[(2)] = inst_44749);

(statearr_44797_44839[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (3))){
var inst_44783 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44785__$1,inst_44783);
} else {
if((state_val_44786 === (12))){
var inst_44737 = (state_44785[(2)]);
var state_44785__$1 = state_44785;
if(cljs.core.truth_(inst_44737)){
var statearr_44798_44840 = state_44785__$1;
(statearr_44798_44840[(1)] = (13));

} else {
var statearr_44799_44841 = state_44785__$1;
(statearr_44799_44841[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (2))){
var inst_44732 = (state_44785[(10)]);
var _ = (function (){var statearr_44800 = state_44785;
(statearr_44800[(4)] = cljs.core.cons((9),(state_44785[(4)])));

return statearr_44800;
})();
var inst_44732__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44785__$1 = (function (){var statearr_44801 = state_44785;
(statearr_44801[(10)] = inst_44732__$1);

return statearr_44801;
})();
if(cljs.core.truth_(inst_44732__$1)){
var statearr_44802_44842 = state_44785__$1;
(statearr_44802_44842[(1)] = (10));

} else {
var statearr_44803_44843 = state_44785__$1;
(statearr_44803_44843[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (19))){
var inst_44753 = cljs.core.PersistentVector.EMPTY;
var inst_44754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44755 = ["*"];
var inst_44756 = (new cljs.core.PersistentVector(null,1,(5),inst_44754,inst_44755,null));
var inst_44757 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_44758 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_44756,inst_44757);
var inst_44759 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44753,inst_44758);
var state_44785__$1 = state_44785;
var statearr_44805_44844 = state_44785__$1;
(statearr_44805_44844[(2)] = inst_44759);

(statearr_44805_44844[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (11))){
var inst_44732 = (state_44785[(10)]);
var state_44785__$1 = state_44785;
var statearr_44806_44845 = state_44785__$1;
(statearr_44806_44845[(2)] = inst_44732);

(statearr_44806_44845[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (9))){
var _ = (function (){var statearr_44807 = state_44785;
(statearr_44807[(4)] = cljs.core.rest((state_44785[(4)])));

return statearr_44807;
})();
var state_44785__$1 = state_44785;
var ex44804 = (state_44785__$1[(2)]);
var statearr_44808_44846 = state_44785__$1;
(statearr_44808_44846[(5)] = ex44804);


var statearr_44809_44847 = state_44785__$1;
(statearr_44809_44847[(1)] = (4));

(statearr_44809_44847[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (5))){
var inst_44716 = (state_44785[(7)]);
var _ = (function (){var statearr_44810 = state_44785;
(statearr_44810[(4)] = cljs.core.cons((8),(state_44785[(4)])));

return statearr_44810;
})();
var inst_44723 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44716,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_44811 = state_44785;
(statearr_44811[(4)] = cljs.core.rest((state_44785[(4)])));

return statearr_44811;
})();
var state_44785__$1 = state_44785;
var statearr_44812_44848 = state_44785__$1;
(statearr_44812_44848[(2)] = inst_44723);

(statearr_44812_44848[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (14))){
var inst_44745 = (state_44785[(11)]);
var inst_44744 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44745__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44785__$1 = (function (){var statearr_44813 = state_44785;
(statearr_44813[(8)] = inst_44744);

(statearr_44813[(11)] = inst_44745__$1);

return statearr_44813;
})();
if(cljs.core.truth_(inst_44745__$1)){
var statearr_44814_44849 = state_44785__$1;
(statearr_44814_44849[(1)] = (16));

} else {
var statearr_44815_44850 = state_44785__$1;
(statearr_44815_44850[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (16))){
var inst_44745 = (state_44785[(11)]);
var state_44785__$1 = state_44785;
var statearr_44816_44851 = state_44785__$1;
(statearr_44816_44851[(2)] = inst_44745);

(statearr_44816_44851[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (10))){
var inst_44734 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_44785__$1 = state_44785;
var statearr_44818_44852 = state_44785__$1;
(statearr_44818_44852[(2)] = inst_44734);

(statearr_44818_44852[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (18))){
var inst_44751 = (state_44785[(2)]);
var state_44785__$1 = (function (){var statearr_44819 = state_44785;
(statearr_44819[(9)] = inst_44751);

return statearr_44819;
})();
if(cljs.core.truth_(additional_params)){
var statearr_44820_44853 = state_44785__$1;
(statearr_44820_44853[(1)] = (19));

} else {
var statearr_44821_44854 = state_44785__$1;
(statearr_44821_44854[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44786 === (8))){
var _ = (function (){var statearr_44822 = state_44785;
(statearr_44822[(4)] = cljs.core.rest((state_44785[(4)])));

return statearr_44822;
})();
var state_44785__$1 = state_44785;
var ex44817 = (state_44785__$1[(2)]);
var statearr_44823_44855 = state_44785__$1;
(statearr_44823_44855[(5)] = ex44817);


var statearr_44824_44856 = state_44785__$1;
(statearr_44824_44856[(1)] = (7));

(statearr_44824_44856[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44825 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44825[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44825[(1)] = (1));

return statearr_44825;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44785){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44785);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44826){var ex__13886__auto__ = e44826;
var statearr_44827_44857 = state_44785;
(statearr_44827_44857[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44785[(4)]))){
var statearr_44828_44858 = state_44785;
(statearr_44828_44858[(1)] = cljs.core.first((state_44785[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44859 = state_44785;
state_44785 = G__44859;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44829 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44829[(6)] = c__13957__auto__);

return statearr_44829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__44861 = arguments.length;
switch (G__44861) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44905){
var state_val_44906 = (state_44905[(1)]);
if((state_val_44906 === (7))){
var inst_44883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44884 = ["*"];
var inst_44885 = (new cljs.core.PersistentVector(null,1,(5),inst_44883,inst_44884,null));
var state_44905__$1 = state_44905;
var statearr_44907_44927 = state_44905__$1;
(statearr_44907_44927[(2)] = inst_44885);

(statearr_44907_44927[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (1))){
var state_44905__$1 = state_44905;
var statearr_44908_44928 = state_44905__$1;
(statearr_44908_44928[(2)] = null);

(statearr_44908_44928[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (4))){
var inst_44862 = (state_44905[(2)]);
var inst_44863 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44862,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_44905__$1 = state_44905;
var statearr_44909_44929 = state_44905__$1;
(statearr_44909_44929[(2)] = inst_44863);

(statearr_44909_44929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (6))){
var inst_44875 = cljs.core.PersistentVector.EMPTY;
var inst_44876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44877 = ["*"];
var inst_44878 = (new cljs.core.PersistentVector(null,1,(5),inst_44876,inst_44877,null));
var inst_44879 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_44880 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_44878,inst_44879);
var inst_44881 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44875,inst_44880);
var state_44905__$1 = state_44905;
var statearr_44910_44930 = state_44905__$1;
(statearr_44910_44930[(2)] = inst_44881);

(statearr_44910_44930[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (3))){
var inst_44903 = (state_44905[(2)]);
var state_44905__$1 = state_44905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44905__$1,inst_44903);
} else {
if((state_val_44906 === (2))){
var _ = (function (){var statearr_44912 = state_44905;
(statearr_44912[(4)] = cljs.core.cons((5),(state_44905[(4)])));

return statearr_44912;
})();
var inst_44872 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44873 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44905__$1 = (function (){var statearr_44913 = state_44905;
(statearr_44913[(7)] = inst_44872);

(statearr_44913[(8)] = inst_44873);

return statearr_44913;
})();
if(cljs.core.truth_(additional_params)){
var statearr_44914_44931 = state_44905__$1;
(statearr_44914_44931[(1)] = (6));

} else {
var statearr_44915_44932 = state_44905__$1;
(statearr_44915_44932[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (9))){
var inst_44894 = (state_44905[(2)]);
var inst_44895 = fluree.db.util.async.throw_err(inst_44894);
var inst_44896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44895,(0),null);
var inst_44897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44895,(1),null);
var inst_44898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44899 = [inst_44896,inst_44897];
var inst_44900 = (new cljs.core.PersistentVector(null,2,(5),inst_44898,inst_44899,null));
var _ = (function (){var statearr_44916 = state_44905;
(statearr_44916[(4)] = cljs.core.rest((state_44905[(4)])));

return statearr_44916;
})();
var state_44905__$1 = state_44905;
var statearr_44917_44933 = state_44905__$1;
(statearr_44917_44933[(2)] = inst_44900);

(statearr_44917_44933[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (5))){
var _ = (function (){var statearr_44918 = state_44905;
(statearr_44918[(4)] = cljs.core.rest((state_44905[(4)])));

return statearr_44918;
})();
var state_44905__$1 = state_44905;
var ex44911 = (state_44905__$1[(2)]);
var statearr_44919_44934 = state_44905__$1;
(statearr_44919_44934[(5)] = ex44911);


var statearr_44920_44935 = state_44905__$1;
(statearr_44920_44935[(1)] = (4));

(statearr_44920_44935[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44906 === (8))){
var inst_44872 = (state_44905[(7)]);
var inst_44873 = (state_44905[(8)]);
var inst_44887 = (state_44905[(2)]);
var inst_44888 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44889 = cljs.core.PersistentHashMap.EMPTY;
var inst_44890 = [inst_44887,inst_44873,inst_44889];
var inst_44891 = cljs.core.PersistentHashMap.fromArrays(inst_44888,inst_44890);
var inst_44892 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_44872,inst_44891);
var state_44905__$1 = state_44905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44905__$1,(9),inst_44892);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44921 = [null,null,null,null,null,null,null,null,null];
(statearr_44921[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44921[(1)] = (1));

return statearr_44921;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44905){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44905);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44922){var ex__13886__auto__ = e44922;
var statearr_44923_44936 = state_44905;
(statearr_44923_44936[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44905[(4)]))){
var statearr_44924_44937 = state_44905;
(statearr_44924_44937[(1)] = cljs.core.first((state_44905[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44938 = state_44905;
state_44905 = G__44938;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44905){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44925 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44925[(6)] = c__13957__auto__);

return statearr_44925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44982){
var state_val_44983 = (state_44982[(1)]);
if((state_val_44983 === (1))){
var state_44982__$1 = state_44982;
var statearr_44984_44998 = state_44982__$1;
(statearr_44984_44998[(2)] = null);

(statearr_44984_44998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44983 === (2))){
var _ = (function (){var statearr_44985 = state_44982;
(statearr_44985[(4)] = cljs.core.cons((5),(state_44982[(4)])));

return statearr_44985;
})();
var inst_44949 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44951 = ["_user/_auth"];
var inst_44952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44953 = ["*"];
var inst_44954 = (new cljs.core.PersistentVector(null,1,(5),inst_44952,inst_44953,null));
var inst_44955 = [inst_44954];
var inst_44956 = cljs.core.PersistentHashMap.fromArrays(inst_44951,inst_44955);
var inst_44957 = [inst_44956];
var inst_44958 = (new cljs.core.PersistentVector(null,1,(5),inst_44950,inst_44957,null));
var inst_44959 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44960 = cljs.core.PersistentHashMap.EMPTY;
var inst_44961 = [inst_44958,inst_44959,inst_44960];
var inst_44962 = cljs.core.PersistentHashMap.fromArrays(inst_44949,inst_44961);
var inst_44963 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44964 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_44963,inst_44962);
var state_44982__$1 = state_44982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44982__$1,(6),inst_44964);
} else {
if((state_val_44983 === (3))){
var inst_44980 = (state_44982[(2)]);
var state_44982__$1 = state_44982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44982__$1,inst_44980);
} else {
if((state_val_44983 === (4))){
var inst_44939 = (state_44982[(2)]);
var inst_44940 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44939,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_44982__$1 = state_44982;
var statearr_44987_44999 = state_44982__$1;
(statearr_44987_44999[(2)] = inst_44940);

(statearr_44987_44999[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44983 === (5))){
var _ = (function (){var statearr_44988 = state_44982;
(statearr_44988[(4)] = cljs.core.rest((state_44982[(4)])));

return statearr_44988;
})();
var state_44982__$1 = state_44982;
var ex44986 = (state_44982__$1[(2)]);
var statearr_44989_45000 = state_44982__$1;
(statearr_44989_45000[(5)] = ex44986);


var statearr_44990_45001 = state_44982__$1;
(statearr_44990_45001[(1)] = (4));

(statearr_44990_45001[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44983 === (6))){
var inst_44966 = (state_44982[(2)]);
var inst_44967 = fluree.db.util.async.throw_err(inst_44966);
var inst_44968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44967,(0),null);
var inst_44969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44967,(1),null);
var inst_44970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44971 = ["_user/_auth","_id"];
var inst_44972 = (new cljs.core.PersistentVector(null,2,(5),inst_44970,inst_44971,null));
var inst_44973 = fluree.db.dbfunctions.internal.get_in(inst_44968,inst_44972);
var inst_44974 = cljs.core.first(inst_44973);
var inst_44975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44976 = [inst_44974,inst_44969];
var inst_44977 = (new cljs.core.PersistentVector(null,2,(5),inst_44975,inst_44976,null));
var _ = (function (){var statearr_44991 = state_44982;
(statearr_44991[(4)] = cljs.core.rest((state_44982[(4)])));

return statearr_44991;
})();
var state_44982__$1 = state_44982;
var statearr_44992_45002 = state_44982__$1;
(statearr_44992_45002[(2)] = inst_44977);

(statearr_44992_45002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0 = (function (){
var statearr_44993 = [null,null,null,null,null,null,null];
(statearr_44993[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__);

(statearr_44993[(1)] = (1));

return statearr_44993;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1 = (function (state_44982){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44982);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44994){var ex__13886__auto__ = e44994;
var statearr_44995_45003 = state_44982;
(statearr_44995_45003[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44982[(4)]))){
var statearr_44996_45004 = state_44982;
(statearr_44996_45004[(1)] = cljs.core.first((state_44982[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45005 = state_44982;
state_44982 = G__45005;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__ = function(state_44982){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1.call(this,state_44982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44997 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44997[(6)] = c__13957__auto__);

return statearr_44997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45022){
var state_val_45023 = (state_45022[(1)]);
if((state_val_45023 === (1))){
var state_45022__$1 = state_45022;
var statearr_45024_45038 = state_45022__$1;
(statearr_45024_45038[(2)] = null);

(statearr_45024_45038[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45023 === (2))){
var _ = (function (){var statearr_45025 = state_45022;
(statearr_45025[(4)] = cljs.core.cons((5),(state_45022[(4)])));

return statearr_45025;
})();
var inst_45012 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45013 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45014 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_45013,inst_45012);
var state_45022__$1 = state_45022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45022__$1,(6),inst_45014);
} else {
if((state_val_45023 === (3))){
var inst_45020 = (state_45022[(2)]);
var state_45022__$1 = state_45022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45022__$1,inst_45020);
} else {
if((state_val_45023 === (4))){
var inst_45006 = (state_45022[(2)]);
var state_45022__$1 = state_45022;
var statearr_45027_45039 = state_45022__$1;
(statearr_45027_45039[(2)] = inst_45006);

(statearr_45027_45039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45023 === (5))){
var _ = (function (){var statearr_45028 = state_45022;
(statearr_45028[(4)] = cljs.core.rest((state_45022[(4)])));

return statearr_45028;
})();
var state_45022__$1 = state_45022;
var ex45026 = (state_45022__$1[(2)]);
var statearr_45029_45040 = state_45022__$1;
(statearr_45029_45040[(5)] = ex45026);


if((ex45026 instanceof Error)){
var statearr_45030_45041 = state_45022__$1;
(statearr_45030_45041[(1)] = (4));

(statearr_45030_45041[(5)] = null);

} else {
throw ex45026;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45023 === (6))){
var inst_45016 = (state_45022[(2)]);
var inst_45017 = fluree.db.util.async.throw_err(inst_45016);
var _ = (function (){var statearr_45031 = state_45022;
(statearr_45031[(4)] = cljs.core.rest((state_45022[(4)])));

return statearr_45031;
})();
var state_45022__$1 = state_45022;
var statearr_45032_45042 = state_45022__$1;
(statearr_45032_45042[(2)] = inst_45017);

(statearr_45032_45042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0 = (function (){
var statearr_45033 = [null,null,null,null,null,null,null];
(statearr_45033[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__);

(statearr_45033[(1)] = (1));

return statearr_45033;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1 = (function (state_45022){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45022);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45034){var ex__13886__auto__ = e45034;
var statearr_45035_45043 = state_45022;
(statearr_45035_45043[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45022[(4)]))){
var statearr_45036_45044 = state_45022;
(statearr_45036_45044[(1)] = cljs.core.first((state_45022[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45045 = state_45022;
state_45022 = G__45045;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__ = function(state_45022){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1.call(this,state_45022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45037 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45037[(6)] = c__13957__auto__);

return statearr_45037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__45046_SHARP_){
return p1__45046_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45047_SHARP_){
return p1__45047_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45048){var e = e45048;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__45049_SHARP_){
return p1__45049_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45050_SHARP_){
return p1__45050_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45051){var e = e45051;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__45053 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__45053);
})() | (0));
return num;
}catch (e45052){var e = e45052;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45133){
var state_val_45134 = (state_45133[(1)]);
if((state_val_45134 === (7))){
var inst_45072 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45073 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45074 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45075 = cljs.core.PersistentHashMap.fromArrays(inst_45073,inst_45074);
var inst_45076 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45072,inst_45075);
var inst_45077 = (function(){throw inst_45076})();
var state_45133__$1 = state_45133;
var statearr_45135_45170 = state_45133__$1;
(statearr_45135_45170[(2)] = inst_45077);

(statearr_45135_45170[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (1))){
var state_45133__$1 = state_45133;
var statearr_45136_45171 = state_45133__$1;
(statearr_45136_45171[(2)] = null);

(statearr_45136_45171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (4))){
var inst_45054 = (state_45133[(2)]);
var state_45133__$1 = state_45133;
var statearr_45137_45172 = state_45133__$1;
(statearr_45137_45172[(2)] = inst_45054);

(statearr_45137_45172[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (15))){
var inst_45117 = (state_45133[(7)]);
var inst_45113 = (state_45133[(2)]);
var inst_45114 = fluree.db.util.async.throw_err(inst_45113);
var inst_45115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45114,(0),null);
var inst_45116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45114,(1),null);
var inst_45117__$1 = cljs.core.first(inst_45115);
var inst_45118 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45117__$1,compare_val);
var state_45133__$1 = (function (){var statearr_45138 = state_45133;
(statearr_45138[(7)] = inst_45117__$1);

(statearr_45138[(8)] = inst_45116);

return statearr_45138;
})();
if(inst_45118){
var statearr_45139_45173 = state_45133__$1;
(statearr_45139_45173[(1)] = (16));

} else {
var statearr_45140_45174 = state_45133__$1;
(statearr_45140_45174[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (13))){
var state_45133__$1 = state_45133;
var statearr_45141_45175 = state_45133__$1;
(statearr_45141_45175[(2)] = null);

(statearr_45141_45175[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (6))){
var state_45133__$1 = state_45133;
var statearr_45142_45176 = state_45133__$1;
(statearr_45142_45176[(2)] = null);

(statearr_45142_45176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (17))){
var inst_45117 = (state_45133[(7)]);
var inst_45121 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45117)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_45122 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45123 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45124 = cljs.core.PersistentHashMap.fromArrays(inst_45122,inst_45123);
var inst_45125 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45121,inst_45124);
var inst_45126 = (function(){throw inst_45125})();
var state_45133__$1 = state_45133;
var statearr_45143_45177 = state_45133__$1;
(statearr_45143_45177[(2)] = inst_45126);

(statearr_45143_45177[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (3))){
var inst_45131 = (state_45133[(2)]);
var state_45133__$1 = state_45133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45133__$1,inst_45131);
} else {
if((state_val_45134 === (12))){
var inst_45069 = (state_45133[(9)]);
var inst_45092 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_45069], 0));
var inst_45093 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45094 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45095 = cljs.core.PersistentHashMap.fromArrays(inst_45093,inst_45094);
var inst_45096 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45092,inst_45095);
var inst_45097 = (function(){throw inst_45096})();
var state_45133__$1 = state_45133;
var statearr_45144_45178 = state_45133__$1;
(statearr_45144_45178[(2)] = inst_45097);

(statearr_45144_45178[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (2))){
var inst_45068 = (state_45133[(10)]);
var inst_45067 = (state_45133[(11)]);
var inst_45066 = (state_45133[(12)]);
var _ = (function (){var statearr_45145 = state_45133;
(statearr_45145[(4)] = cljs.core.cons((5),(state_45133[(4)])));

return statearr_45145;
})();
var inst_45064 = _QMARK_ctx;
var inst_45065 = cljs.core.__destructure_map(inst_45064);
var inst_45066__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45065,cljs.core.cst$kw$sid);
var inst_45067__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45065,cljs.core.cst$kw$pid);
var inst_45068__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45065,cljs.core.cst$kw$db);
var inst_45069 = fluree.db.dbproto._p_prop(inst_45068__$1,cljs.core.cst$kw$name,inst_45067__$1);
var state_45133__$1 = (function (){var statearr_45146 = state_45133;
(statearr_45146[(9)] = inst_45069);

(statearr_45146[(10)] = inst_45068__$1);

(statearr_45146[(11)] = inst_45067__$1);

(statearr_45146[(12)] = inst_45066__$1);

return statearr_45146;
})();
if(cljs.core.truth_(inst_45066__$1)){
var statearr_45147_45179 = state_45133__$1;
(statearr_45147_45179[(1)] = (6));

} else {
var statearr_45148_45180 = state_45133__$1;
(statearr_45148_45180[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (11))){
var inst_45068 = (state_45133[(10)]);
var inst_45067 = (state_45133[(11)]);
var inst_45089 = (state_45133[(2)]);
var inst_45090 = fluree.db.dbproto._p_prop(inst_45068,cljs.core.cst$kw$multi,inst_45067);
var state_45133__$1 = (function (){var statearr_45150 = state_45133;
(statearr_45150[(13)] = inst_45089);

return statearr_45150;
})();
if(cljs.core.truth_(inst_45090)){
var statearr_45151_45181 = state_45133__$1;
(statearr_45151_45181[(1)] = (12));

} else {
var statearr_45152_45182 = state_45133__$1;
(statearr_45152_45182[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (9))){
var state_45133__$1 = state_45133;
var statearr_45153_45183 = state_45133__$1;
(statearr_45153_45183[(2)] = null);

(statearr_45153_45183[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (5))){
var _ = (function (){var statearr_45154 = state_45133;
(statearr_45154[(4)] = cljs.core.rest((state_45133[(4)])));

return statearr_45154;
})();
var state_45133__$1 = state_45133;
var ex45149 = (state_45133__$1[(2)]);
var statearr_45155_45184 = state_45133__$1;
(statearr_45155_45184[(5)] = ex45149);


if((ex45149 instanceof Error)){
var statearr_45156_45185 = state_45133__$1;
(statearr_45156_45185[(1)] = (4));

(statearr_45156_45185[(5)] = null);

} else {
throw ex45149;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (14))){
var inst_45069 = (state_45133[(9)]);
var inst_45068 = (state_45133[(10)]);
var inst_45066 = (state_45133[(12)]);
var inst_45100 = (state_45133[(2)]);
var inst_45101 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45104 = [inst_45066,inst_45069,"?current-val"];
var inst_45105 = (new cljs.core.PersistentVector(null,3,(5),inst_45103,inst_45104,null));
var inst_45106 = [inst_45105];
var inst_45107 = (new cljs.core.PersistentVector(null,1,(5),inst_45102,inst_45106,null));
var inst_45108 = cljs.core.PersistentHashMap.EMPTY;
var inst_45109 = ["?current-val",inst_45107,inst_45108];
var inst_45110 = cljs.core.PersistentHashMap.fromArrays(inst_45101,inst_45109);
var inst_45111 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45068,inst_45110);
var state_45133__$1 = (function (){var statearr_45157 = state_45133;
(statearr_45157[(14)] = inst_45100);

return statearr_45157;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45133__$1,(15),inst_45111);
} else {
if((state_val_45134 === (16))){
var state_45133__$1 = state_45133;
var statearr_45158_45186 = state_45133__$1;
(statearr_45158_45186[(2)] = new_val);

(statearr_45158_45186[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (10))){
var inst_45082 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45083 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45084 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45085 = cljs.core.PersistentHashMap.fromArrays(inst_45083,inst_45084);
var inst_45086 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45082,inst_45085);
var inst_45087 = (function(){throw inst_45086})();
var state_45133__$1 = state_45133;
var statearr_45159_45187 = state_45133__$1;
(statearr_45159_45187[(2)] = inst_45087);

(statearr_45159_45187[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (18))){
var inst_45128 = (state_45133[(2)]);
var _ = (function (){var statearr_45160 = state_45133;
(statearr_45160[(4)] = cljs.core.rest((state_45133[(4)])));

return statearr_45160;
})();
var state_45133__$1 = state_45133;
var statearr_45161_45188 = state_45133__$1;
(statearr_45161_45188[(2)] = inst_45128);

(statearr_45161_45188[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45134 === (8))){
var inst_45069 = (state_45133[(9)]);
var inst_45079 = (state_45133[(2)]);
var state_45133__$1 = (function (){var statearr_45162 = state_45133;
(statearr_45162[(15)] = inst_45079);

return statearr_45162;
})();
if(cljs.core.truth_(inst_45069)){
var statearr_45163_45189 = state_45133__$1;
(statearr_45163_45189[(1)] = (9));

} else {
var statearr_45164_45190 = state_45133__$1;
(statearr_45164_45190[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0 = (function (){
var statearr_45165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45165[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__);

(statearr_45165[(1)] = (1));

return statearr_45165;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1 = (function (state_45133){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45133);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45166){var ex__13886__auto__ = e45166;
var statearr_45167_45191 = state_45133;
(statearr_45167_45191[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45133[(4)]))){
var statearr_45168_45192 = state_45133;
(statearr_45168_45192[(1)] = cljs.core.first((state_45133[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45193 = state_45133;
state_45133 = G__45193;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__ = function(state_45133){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1.call(this,state_45133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45169 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45169[(6)] = c__13957__auto__);

return statearr_45169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
