// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4820__auto___69684 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_69735){
var state_val_69736 = (state_69735[(1)]);
if((state_val_69736 === (7))){
var inst_69730 = (state_69735[(2)]);
var _ = (function (){var statearr_69737 = state_69735;
(statearr_69737[(4)] = cljs.core.rest((state_69735[(4)])));

return statearr_69737;
})();
var state_69735__$1 = state_69735;
var statearr_69738_69765 = state_69735__$1;
(statearr_69738_69765[(2)] = inst_69730);

(statearr_69738_69765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (1))){
var state_69735__$1 = state_69735;
var statearr_69739_69766 = state_69735__$1;
(statearr_69739_69766[(2)] = null);

(statearr_69739_69766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (4))){
var inst_69685 = (state_69735[(2)]);
var state_69735__$1 = state_69735;
var statearr_69740_69767 = state_69735__$1;
(statearr_69740_69767[(2)] = inst_69685);

(statearr_69740_69767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (13))){
var inst_69726 = (state_69735[(2)]);
var state_69735__$1 = state_69735;
var statearr_69741_69768 = state_69735__$1;
(statearr_69741_69768[(2)] = inst_69726);

(statearr_69741_69768[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (6))){
var inst_69710 = (state_69735[(7)]);
var inst_69703 = (state_69735[(8)]);
var inst_69709 = cljs.core.seq(inst_69703);
var inst_69710__$1 = cljs.core.first(inst_69709);
var inst_69711 = cljs.core.next(inst_69709);
var inst_69712 = cljs.core.not(inst_69710__$1);
var state_69735__$1 = (function (){var statearr_69742 = state_69735;
(statearr_69742[(7)] = inst_69710__$1);

(statearr_69742[(9)] = inst_69711);

return statearr_69742;
})();
if(inst_69712){
var statearr_69743_69769 = state_69735__$1;
(statearr_69743_69769[(1)] = (8));

} else {
var statearr_69744_69770 = state_69735__$1;
(statearr_69744_69770[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (3))){
var inst_69733 = (state_69735[(2)]);
var state_69735__$1 = state_69735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69735__$1,inst_69733);
} else {
if((state_val_69736 === (12))){
var inst_69710 = (state_69735[(7)]);
var inst_69711 = (state_69735[(9)]);
var inst_69704 = (state_69735[(10)]);
var inst_69723 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69704,inst_69710);
var inst_69703 = inst_69711;
var inst_69704__$1 = inst_69723;
var state_69735__$1 = (function (){var statearr_69745 = state_69735;
(statearr_69745[(8)] = inst_69703);

(statearr_69745[(10)] = inst_69704__$1);

return statearr_69745;
})();
var statearr_69746_69771 = state_69735__$1;
(statearr_69746_69771[(2)] = null);

(statearr_69746_69771[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (2))){
var _ = (function (){var statearr_69747 = state_69735;
(statearr_69747[(4)] = cljs.core.cons((5),(state_69735[(4)])));

return statearr_69747;
})();
var inst_69698 = args;
var inst_69699 = cljs.core.seq(inst_69698);
var inst_69700 = cljs.core.first(inst_69699);
var inst_69701 = cljs.core.next(inst_69699);
var inst_69702 = cljs.core.PersistentVector.EMPTY;
var inst_69703 = inst_69698;
var inst_69704 = inst_69702;
var state_69735__$1 = (function (){var statearr_69748 = state_69735;
(statearr_69748[(11)] = inst_69700);

(statearr_69748[(8)] = inst_69703);

(statearr_69748[(10)] = inst_69704);

(statearr_69748[(12)] = inst_69701);

return statearr_69748;
})();
var statearr_69749_69772 = state_69735__$1;
(statearr_69749_69772[(2)] = null);

(statearr_69749_69772[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (11))){
var inst_69710 = (state_69735[(7)]);
var state_69735__$1 = state_69735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69735__$1,(14),inst_69710);
} else {
if((state_val_69736 === (9))){
var inst_69710 = (state_69735[(7)]);
var inst_69715 = fluree.db.util.async.channel_QMARK_(inst_69710);
var state_69735__$1 = state_69735;
if(inst_69715){
var statearr_69751_69773 = state_69735__$1;
(statearr_69751_69773[(1)] = (11));

} else {
var statearr_69752_69774 = state_69735__$1;
(statearr_69752_69774[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (5))){
var _ = (function (){var statearr_69753 = state_69735;
(statearr_69753[(4)] = cljs.core.rest((state_69735[(4)])));

return statearr_69753;
})();
var state_69735__$1 = state_69735;
var ex69750 = (state_69735__$1[(2)]);
var statearr_69754_69775 = state_69735__$1;
(statearr_69754_69775[(5)] = ex69750);


if((ex69750 instanceof Error)){
var statearr_69755_69776 = state_69735__$1;
(statearr_69755_69776[(1)] = (4));

(statearr_69755_69776[(5)] = null);

} else {
throw ex69750;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (14))){
var inst_69711 = (state_69735[(9)]);
var inst_69704 = (state_69735[(10)]);
var inst_69718 = (state_69735[(2)]);
var inst_69719 = fluree.db.util.async.throw_err(inst_69718);
var inst_69720 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69704,inst_69719);
var inst_69703 = inst_69711;
var inst_69704__$1 = inst_69720;
var state_69735__$1 = (function (){var statearr_69756 = state_69735;
(statearr_69756[(8)] = inst_69703);

(statearr_69756[(10)] = inst_69704__$1);

return statearr_69756;
})();
var statearr_69757_69777 = state_69735__$1;
(statearr_69757_69777[(2)] = null);

(statearr_69757_69777[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (10))){
var inst_69728 = (state_69735[(2)]);
var state_69735__$1 = state_69735;
var statearr_69758_69778 = state_69735__$1;
(statearr_69758_69778[(2)] = inst_69728);

(statearr_69758_69778[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69736 === (8))){
var inst_69704 = (state_69735[(10)]);
var state_69735__$1 = state_69735;
var statearr_69759_69779 = state_69735__$1;
(statearr_69759_69779[(2)] = inst_69704);

(statearr_69759_69779[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0 = (function (){
var statearr_69760 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69760[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__);

(statearr_69760[(1)] = (1));

return statearr_69760;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1 = (function (state_69735){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_69735);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e69761){var ex__13886__auto__ = e69761;
var statearr_69762_69780 = state_69735;
(statearr_69762_69780[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_69735[(4)]))){
var statearr_69763_69781 = state_69735;
(statearr_69763_69781[(1)] = cljs.core.first((state_69735[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__69782 = state_69735;
state_69735 = G__69782;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__ = function(state_69735){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1.call(this,state_69735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_69764 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_69764[(6)] = c__13957__auto__);

return statearr_69764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__69783 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69783,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69783,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_69831){
var state_val_69832 = (state_69831[(1)]);
if((state_val_69832 === (7))){
var state_69831__$1 = state_69831;
var statearr_69833_69862 = state_69831__$1;
(statearr_69833_69862[(2)] = coll);

(statearr_69833_69862[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (1))){
var state_69831__$1 = state_69831;
var statearr_69834_69863 = state_69831__$1;
(statearr_69834_69863[(2)] = null);

(statearr_69834_69863[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (4))){
var inst_69786 = (state_69831[(2)]);
var state_69831__$1 = state_69831;
var statearr_69835_69864 = state_69831__$1;
(statearr_69835_69864[(2)] = inst_69786);

(statearr_69835_69864[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (15))){
var inst_69805 = (state_69831[(7)]);
var inst_69813 = (state_69831[(2)]);
var inst_69814 = fluree.db.dbfunctions.internal.nth(inst_69805,inst_69813);
var inst_69815 = cljs.core.count(inst_69805);
var inst_69816 = ((9) + inst_69815);
var inst_69817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69818 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69820 = [inst_69805,inst_69813];
var inst_69821 = (new cljs.core.PersistentVector(null,2,(5),inst_69819,inst_69820,null));
var inst_69822 = ["nth",inst_69821,inst_69814];
var inst_69823 = cljs.core.PersistentHashMap.fromArrays(inst_69818,inst_69822);
var inst_69824 = [inst_69823,inst_69816];
var inst_69825 = (new cljs.core.PersistentVector(null,2,(5),inst_69817,inst_69824,null));
var inst_69826 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69825);
var _ = (function (){var statearr_69836 = state_69831;
(statearr_69836[(4)] = cljs.core.rest((state_69831[(4)])));

return statearr_69836;
})();
var state_69831__$1 = (function (){var statearr_69837 = state_69831;
(statearr_69837[(8)] = inst_69826);

return statearr_69837;
})();
var statearr_69838_69865 = state_69831__$1;
(statearr_69838_69865[(2)] = inst_69814);

(statearr_69838_69865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (13))){
var state_69831__$1 = state_69831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69831__$1,(16),key);
} else {
if((state_val_69832 === (6))){
var state_69831__$1 = state_69831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69831__$1,(9),coll);
} else {
if((state_val_69832 === (3))){
var inst_69829 = (state_69831[(2)]);
var state_69831__$1 = state_69831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69831__$1,inst_69829);
} else {
if((state_val_69832 === (12))){
var inst_69805 = (state_69831[(2)]);
var inst_69806 = fluree.db.util.async.channel_QMARK_(key);
var state_69831__$1 = (function (){var statearr_69839 = state_69831;
(statearr_69839[(7)] = inst_69805);

return statearr_69839;
})();
if(inst_69806){
var statearr_69840_69866 = state_69831__$1;
(statearr_69840_69866[(1)] = (13));

} else {
var statearr_69841_69867 = state_69831__$1;
(statearr_69841_69867[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (2))){
var _ = (function (){var statearr_69842 = state_69831;
(statearr_69842[(4)] = cljs.core.cons((5),(state_69831[(4)])));

return statearr_69842;
})();
var inst_69792 = fluree.db.util.async.channel_QMARK_(coll);
var state_69831__$1 = state_69831;
if(inst_69792){
var statearr_69843_69868 = state_69831__$1;
(statearr_69843_69868[(1)] = (6));

} else {
var statearr_69844_69869 = state_69831__$1;
(statearr_69844_69869[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (11))){
var inst_69799 = (state_69831[(9)]);
var state_69831__$1 = state_69831;
var statearr_69846_69870 = state_69831__$1;
(statearr_69846_69870[(2)] = inst_69799);

(statearr_69846_69870[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (9))){
var inst_69795 = (state_69831[(2)]);
var inst_69796 = fluree.db.util.async.throw_err(inst_69795);
var state_69831__$1 = state_69831;
var statearr_69847_69871 = state_69831__$1;
(statearr_69847_69871[(2)] = inst_69796);

(statearr_69847_69871[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (5))){
var _ = (function (){var statearr_69848 = state_69831;
(statearr_69848[(4)] = cljs.core.rest((state_69831[(4)])));

return statearr_69848;
})();
var state_69831__$1 = state_69831;
var ex69845 = (state_69831__$1[(2)]);
var statearr_69849_69872 = state_69831__$1;
(statearr_69849_69872[(5)] = ex69845);


if((ex69845 instanceof Error)){
var statearr_69850_69873 = state_69831__$1;
(statearr_69850_69873[(1)] = (4));

(statearr_69850_69873[(5)] = null);

} else {
throw ex69845;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (14))){
var state_69831__$1 = state_69831;
var statearr_69851_69874 = state_69831__$1;
(statearr_69851_69874[(2)] = key);

(statearr_69851_69874[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (16))){
var inst_69809 = (state_69831[(2)]);
var inst_69810 = fluree.db.util.async.throw_err(inst_69809);
var state_69831__$1 = state_69831;
var statearr_69852_69875 = state_69831__$1;
(statearr_69852_69875[(2)] = inst_69810);

(statearr_69852_69875[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (10))){
var inst_69799 = (state_69831[(9)]);
var inst_69802 = cljs.core.vec(inst_69799);
var state_69831__$1 = state_69831;
var statearr_69853_69876 = state_69831__$1;
(statearr_69853_69876[(2)] = inst_69802);

(statearr_69853_69876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69832 === (8))){
var inst_69799 = (state_69831[(9)]);
var inst_69799__$1 = (state_69831[(2)]);
var inst_69800 = cljs.core.set_QMARK_(inst_69799__$1);
var state_69831__$1 = (function (){var statearr_69854 = state_69831;
(statearr_69854[(9)] = inst_69799__$1);

return statearr_69854;
})();
if(inst_69800){
var statearr_69855_69877 = state_69831__$1;
(statearr_69855_69877[(1)] = (10));

} else {
var statearr_69856_69878 = state_69831__$1;
(statearr_69856_69878[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0 = (function (){
var statearr_69857 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69857[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__);

(statearr_69857[(1)] = (1));

return statearr_69857;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1 = (function (state_69831){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_69831);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e69858){var ex__13886__auto__ = e69858;
var statearr_69859_69879 = state_69831;
(statearr_69859_69879[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_69831[(4)]))){
var statearr_69860_69880 = state_69831;
(statearr_69860_69880[(1)] = cljs.core.first((state_69831[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__69881 = state_69831;
state_69831 = G__69881;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__ = function(state_69831){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1.call(this,state_69831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_69861 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_69861[(6)] = c__13957__auto__);

return statearr_69861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_69942){
var state_val_69943 = (state_69942[(1)]);
if((state_val_69943 === (7))){
var state_69942__$1 = state_69942;
var statearr_69944_69978 = state_69942__$1;
(statearr_69944_69978[(2)] = test);

(statearr_69944_69978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (20))){
var inst_69916 = (state_69942[(2)]);
var inst_69917 = fluree.db.util.async.throw_err(inst_69916);
var state_69942__$1 = state_69942;
var statearr_69945_69979 = state_69942__$1;
(statearr_69945_69979[(2)] = inst_69917);

(statearr_69945_69979[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (1))){
var state_69942__$1 = state_69942;
var statearr_69946_69980 = state_69942__$1;
(statearr_69946_69980[(2)] = null);

(statearr_69946_69980[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (4))){
var inst_69882 = (state_69942[(2)]);
var state_69942__$1 = state_69942;
var statearr_69947_69981 = state_69942__$1;
(statearr_69947_69981[(2)] = inst_69882);

(statearr_69947_69981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (15))){
var inst_69900 = (state_69942[(7)]);
var inst_69908 = (state_69942[(2)]);
var inst_69909 = [inst_69908,f];
var inst_69910 = (new cljs.core.PersistentVector(null,2,(5),inst_69900,inst_69909,null));
var state_69942__$1 = state_69942;
var statearr_69948_69982 = state_69942__$1;
(statearr_69948_69982[(2)] = inst_69910);

(statearr_69948_69982[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (13))){
var state_69942__$1 = state_69942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69942__$1,(16),t);
} else {
if((state_val_69943 === (6))){
var state_69942__$1 = state_69942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69942__$1,(9),test);
} else {
if((state_val_69943 === (17))){
var state_69942__$1 = state_69942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69942__$1,(20),f);
} else {
if((state_val_69943 === (3))){
var inst_69940 = (state_69942[(2)]);
var state_69942__$1 = state_69942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69942__$1,inst_69940);
} else {
if((state_val_69943 === (12))){
var inst_69898 = (state_69942[(8)]);
var inst_69924 = (state_69942[(2)]);
var inst_69925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69924,(0),null);
var inst_69926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69924,(1),null);
var inst_69927 = fluree.db.dbfunctions.internal.if_else(inst_69898,inst_69925,inst_69926);
var inst_69928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69929 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69931 = [inst_69898,inst_69925,inst_69926];
var inst_69932 = (new cljs.core.PersistentVector(null,3,(5),inst_69930,inst_69931,null));
var inst_69933 = ["if-else",inst_69932,inst_69927];
var inst_69934 = cljs.core.PersistentHashMap.fromArrays(inst_69929,inst_69933);
var inst_69935 = [inst_69934,(10)];
var inst_69936 = (new cljs.core.PersistentVector(null,2,(5),inst_69928,inst_69935,null));
var inst_69937 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69936);
var _ = (function (){var statearr_69949 = state_69942;
(statearr_69949[(4)] = cljs.core.rest((state_69942[(4)])));

return statearr_69949;
})();
var state_69942__$1 = (function (){var statearr_69950 = state_69942;
(statearr_69950[(9)] = inst_69937);

return statearr_69950;
})();
var statearr_69951_69983 = state_69942__$1;
(statearr_69951_69983[(2)] = inst_69927);

(statearr_69951_69983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (2))){
var _ = (function (){var statearr_69952 = state_69942;
(statearr_69952[(4)] = cljs.core.cons((5),(state_69942[(4)])));

return statearr_69952;
})();
var inst_69891 = fluree.db.util.async.channel_QMARK_(test);
var state_69942__$1 = state_69942;
if(inst_69891){
var statearr_69953_69984 = state_69942__$1;
(statearr_69953_69984[(1)] = (6));

} else {
var statearr_69954_69985 = state_69942__$1;
(statearr_69954_69985[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (19))){
var inst_69912 = (state_69942[(10)]);
var inst_69920 = (state_69942[(2)]);
var inst_69921 = [f,inst_69920];
var inst_69922 = (new cljs.core.PersistentVector(null,2,(5),inst_69912,inst_69921,null));
var state_69942__$1 = state_69942;
var statearr_69955_69986 = state_69942__$1;
(statearr_69955_69986[(2)] = inst_69922);

(statearr_69955_69986[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (11))){
var inst_69912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69913 = fluree.db.util.async.channel_QMARK_(f);
var state_69942__$1 = (function (){var statearr_69957 = state_69942;
(statearr_69957[(10)] = inst_69912);

return statearr_69957;
})();
if(inst_69913){
var statearr_69958_69987 = state_69942__$1;
(statearr_69958_69987[(1)] = (17));

} else {
var statearr_69959_69988 = state_69942__$1;
(statearr_69959_69988[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (9))){
var inst_69894 = (state_69942[(2)]);
var inst_69895 = fluree.db.util.async.throw_err(inst_69894);
var state_69942__$1 = state_69942;
var statearr_69960_69989 = state_69942__$1;
(statearr_69960_69989[(2)] = inst_69895);

(statearr_69960_69989[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (5))){
var _ = (function (){var statearr_69961 = state_69942;
(statearr_69961[(4)] = cljs.core.rest((state_69942[(4)])));

return statearr_69961;
})();
var state_69942__$1 = state_69942;
var ex69956 = (state_69942__$1[(2)]);
var statearr_69962_69990 = state_69942__$1;
(statearr_69962_69990[(5)] = ex69956);


if((ex69956 instanceof Error)){
var statearr_69963_69991 = state_69942__$1;
(statearr_69963_69991[(1)] = (4));

(statearr_69963_69991[(5)] = null);

} else {
throw ex69956;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (14))){
var state_69942__$1 = state_69942;
var statearr_69964_69992 = state_69942__$1;
(statearr_69964_69992[(2)] = t);

(statearr_69964_69992[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (16))){
var inst_69904 = (state_69942[(2)]);
var inst_69905 = fluree.db.util.async.throw_err(inst_69904);
var state_69942__$1 = state_69942;
var statearr_69965_69993 = state_69942__$1;
(statearr_69965_69993[(2)] = inst_69905);

(statearr_69965_69993[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (10))){
var inst_69900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69901 = fluree.db.util.async.channel_QMARK_(t);
var state_69942__$1 = (function (){var statearr_69966 = state_69942;
(statearr_69966[(7)] = inst_69900);

return statearr_69966;
})();
if(inst_69901){
var statearr_69967_69994 = state_69942__$1;
(statearr_69967_69994[(1)] = (13));

} else {
var statearr_69968_69995 = state_69942__$1;
(statearr_69968_69995[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (18))){
var state_69942__$1 = state_69942;
var statearr_69969_69996 = state_69942__$1;
(statearr_69969_69996[(2)] = f);

(statearr_69969_69996[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69943 === (8))){
var inst_69898 = (state_69942[(8)]);
var inst_69898__$1 = (state_69942[(2)]);
var state_69942__$1 = (function (){var statearr_69970 = state_69942;
(statearr_69970[(8)] = inst_69898__$1);

return statearr_69970;
})();
if(cljs.core.truth_(inst_69898__$1)){
var statearr_69971_69997 = state_69942__$1;
(statearr_69971_69997[(1)] = (10));

} else {
var statearr_69972_69998 = state_69942__$1;
(statearr_69972_69998[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0 = (function (){
var statearr_69973 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69973[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__);

(statearr_69973[(1)] = (1));

return statearr_69973;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1 = (function (state_69942){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_69942);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e69974){var ex__13886__auto__ = e69974;
var statearr_69975_69999 = state_69942;
(statearr_69975_69999[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_69942[(4)]))){
var statearr_69976_70000 = state_69942;
(statearr_69976_70000[(1)] = cljs.core.first((state_69942[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70001 = state_69942;
state_69942 = G__70001;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__ = function(state_69942){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1.call(this,state_69942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_69977 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_69977[(6)] = c__13957__auto__);

return statearr_69977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70031){
var state_val_70032 = (state_70031[(1)]);
if((state_val_70032 === (7))){
var state_70031__$1 = state_70031;
var statearr_70033_70052 = state_70031__$1;
(statearr_70033_70052[(2)] = arg);

(statearr_70033_70052[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (1))){
var state_70031__$1 = state_70031;
var statearr_70034_70053 = state_70031__$1;
(statearr_70034_70053[(2)] = null);

(statearr_70034_70053[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (4))){
var inst_70002 = (state_70031[(2)]);
var state_70031__$1 = state_70031;
var statearr_70035_70054 = state_70031__$1;
(statearr_70035_70054[(2)] = inst_70002);

(statearr_70035_70054[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (6))){
var state_70031__$1 = state_70031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70031__$1,(9),arg);
} else {
if((state_val_70032 === (3))){
var inst_70029 = (state_70031[(2)]);
var state_70031__$1 = state_70031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70031__$1,inst_70029);
} else {
if((state_val_70032 === (2))){
var _ = (function (){var statearr_70037 = state_70031;
(statearr_70037[(4)] = cljs.core.cons((5),(state_70031[(4)])));

return statearr_70037;
})();
var inst_70008 = fluree.db.util.async.channel_QMARK_(arg);
var state_70031__$1 = state_70031;
if(inst_70008){
var statearr_70038_70055 = state_70031__$1;
(statearr_70038_70055[(1)] = (6));

} else {
var statearr_70039_70056 = state_70031__$1;
(statearr_70039_70056[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (9))){
var inst_70011 = (state_70031[(2)]);
var inst_70012 = fluree.db.util.async.throw_err(inst_70011);
var state_70031__$1 = state_70031;
var statearr_70040_70057 = state_70031__$1;
(statearr_70040_70057[(2)] = inst_70012);

(statearr_70040_70057[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (5))){
var _ = (function (){var statearr_70041 = state_70031;
(statearr_70041[(4)] = cljs.core.rest((state_70031[(4)])));

return statearr_70041;
})();
var state_70031__$1 = state_70031;
var ex70036 = (state_70031__$1[(2)]);
var statearr_70042_70058 = state_70031__$1;
(statearr_70042_70058[(5)] = ex70036);


if((ex70036 instanceof Error)){
var statearr_70043_70059 = state_70031__$1;
(statearr_70043_70059[(1)] = (4));

(statearr_70043_70059[(5)] = null);

} else {
throw ex70036;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70032 === (8))){
var inst_70015 = (state_70031[(2)]);
var inst_70016 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_70015);
var inst_70017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70018 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70020 = [inst_70015];
var inst_70021 = (new cljs.core.PersistentVector(null,1,(5),inst_70019,inst_70020,null));
var inst_70022 = ["nil?",inst_70021,inst_70016];
var inst_70023 = cljs.core.PersistentHashMap.fromArrays(inst_70018,inst_70022);
var inst_70024 = [inst_70023,(10)];
var inst_70025 = (new cljs.core.PersistentVector(null,2,(5),inst_70017,inst_70024,null));
var inst_70026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70025);
var _ = (function (){var statearr_70044 = state_70031;
(statearr_70044[(4)] = cljs.core.rest((state_70031[(4)])));

return statearr_70044;
})();
var state_70031__$1 = (function (){var statearr_70045 = state_70031;
(statearr_70045[(7)] = inst_70026);

return statearr_70045;
})();
var statearr_70046_70060 = state_70031__$1;
(statearr_70046_70060[(2)] = inst_70016);

(statearr_70046_70060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_70047 = [null,null,null,null,null,null,null,null];
(statearr_70047[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__);

(statearr_70047[(1)] = (1));

return statearr_70047;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1 = (function (state_70031){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70031);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70048){var ex__13886__auto__ = e70048;
var statearr_70049_70061 = state_70031;
(statearr_70049_70061[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70031[(4)]))){
var statearr_70050_70062 = state_70031;
(statearr_70050_70062[(1)] = cljs.core.first((state_70031[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70063 = state_70031;
state_70031 = G__70063;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__ = function(state_70031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1.call(this,state_70031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70051 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70051[(6)] = c__13957__auto__);

return statearr_70051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70093){
var state_val_70094 = (state_70093[(1)]);
if((state_val_70094 === (7))){
var state_70093__$1 = state_70093;
var statearr_70095_70114 = state_70093__$1;
(statearr_70095_70114[(2)] = arg);

(statearr_70095_70114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (1))){
var state_70093__$1 = state_70093;
var statearr_70096_70115 = state_70093__$1;
(statearr_70096_70115[(2)] = null);

(statearr_70096_70115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (4))){
var inst_70064 = (state_70093[(2)]);
var state_70093__$1 = state_70093;
var statearr_70097_70116 = state_70093__$1;
(statearr_70097_70116[(2)] = inst_70064);

(statearr_70097_70116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (6))){
var state_70093__$1 = state_70093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70093__$1,(9),arg);
} else {
if((state_val_70094 === (3))){
var inst_70091 = (state_70093[(2)]);
var state_70093__$1 = state_70093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70093__$1,inst_70091);
} else {
if((state_val_70094 === (2))){
var _ = (function (){var statearr_70099 = state_70093;
(statearr_70099[(4)] = cljs.core.cons((5),(state_70093[(4)])));

return statearr_70099;
})();
var inst_70070 = fluree.db.util.async.channel_QMARK_(arg);
var state_70093__$1 = state_70093;
if(inst_70070){
var statearr_70100_70117 = state_70093__$1;
(statearr_70100_70117[(1)] = (6));

} else {
var statearr_70101_70118 = state_70093__$1;
(statearr_70101_70118[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (9))){
var inst_70073 = (state_70093[(2)]);
var inst_70074 = fluree.db.util.async.throw_err(inst_70073);
var state_70093__$1 = state_70093;
var statearr_70102_70119 = state_70093__$1;
(statearr_70102_70119[(2)] = inst_70074);

(statearr_70102_70119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (5))){
var _ = (function (){var statearr_70103 = state_70093;
(statearr_70103[(4)] = cljs.core.rest((state_70093[(4)])));

return statearr_70103;
})();
var state_70093__$1 = state_70093;
var ex70098 = (state_70093__$1[(2)]);
var statearr_70104_70120 = state_70093__$1;
(statearr_70104_70120[(5)] = ex70098);


if((ex70098 instanceof Error)){
var statearr_70105_70121 = state_70093__$1;
(statearr_70105_70121[(1)] = (4));

(statearr_70105_70121[(5)] = null);

} else {
throw ex70098;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70094 === (8))){
var inst_70077 = (state_70093[(2)]);
var inst_70078 = fluree.db.dbfunctions.internal.not(inst_70077);
var inst_70079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70080 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70082 = [inst_70077];
var inst_70083 = (new cljs.core.PersistentVector(null,1,(5),inst_70081,inst_70082,null));
var inst_70084 = ["not?",inst_70083,inst_70078];
var inst_70085 = cljs.core.PersistentHashMap.fromArrays(inst_70080,inst_70084);
var inst_70086 = [inst_70085,(10)];
var inst_70087 = (new cljs.core.PersistentVector(null,2,(5),inst_70079,inst_70086,null));
var inst_70088 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70087);
var _ = (function (){var statearr_70106 = state_70093;
(statearr_70106[(4)] = cljs.core.rest((state_70093[(4)])));

return statearr_70106;
})();
var state_70093__$1 = (function (){var statearr_70107 = state_70093;
(statearr_70107[(7)] = inst_70088);

return statearr_70107;
})();
var statearr_70108_70122 = state_70093__$1;
(statearr_70108_70122[(2)] = inst_70078);

(statearr_70108_70122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0 = (function (){
var statearr_70109 = [null,null,null,null,null,null,null,null];
(statearr_70109[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__);

(statearr_70109[(1)] = (1));

return statearr_70109;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1 = (function (state_70093){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70093);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70110){var ex__13886__auto__ = e70110;
var statearr_70111_70123 = state_70093;
(statearr_70111_70123[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70093[(4)]))){
var statearr_70112_70124 = state_70093;
(statearr_70112_70124[(1)] = cljs.core.first((state_70093[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70125 = state_70093;
state_70093 = G__70125;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__ = function(state_70093){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1.call(this,state_70093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70113 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70113[(6)] = c__13957__auto__);

return statearr_70113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70155){
var state_val_70156 = (state_70155[(1)]);
if((state_val_70156 === (7))){
var state_70155__$1 = state_70155;
var statearr_70157_70176 = state_70155__$1;
(statearr_70157_70176[(2)] = arg);

(statearr_70157_70176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (1))){
var state_70155__$1 = state_70155;
var statearr_70158_70177 = state_70155__$1;
(statearr_70158_70177[(2)] = null);

(statearr_70158_70177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (4))){
var inst_70126 = (state_70155[(2)]);
var state_70155__$1 = state_70155;
var statearr_70159_70178 = state_70155__$1;
(statearr_70159_70178[(2)] = inst_70126);

(statearr_70159_70178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (6))){
var state_70155__$1 = state_70155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70155__$1,(9),arg);
} else {
if((state_val_70156 === (3))){
var inst_70153 = (state_70155[(2)]);
var state_70155__$1 = state_70155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70155__$1,inst_70153);
} else {
if((state_val_70156 === (2))){
var _ = (function (){var statearr_70161 = state_70155;
(statearr_70161[(4)] = cljs.core.cons((5),(state_70155[(4)])));

return statearr_70161;
})();
var inst_70132 = fluree.db.util.async.channel_QMARK_(arg);
var state_70155__$1 = state_70155;
if(inst_70132){
var statearr_70162_70179 = state_70155__$1;
(statearr_70162_70179[(1)] = (6));

} else {
var statearr_70163_70180 = state_70155__$1;
(statearr_70163_70180[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (9))){
var inst_70135 = (state_70155[(2)]);
var inst_70136 = fluree.db.util.async.throw_err(inst_70135);
var state_70155__$1 = state_70155;
var statearr_70164_70181 = state_70155__$1;
(statearr_70164_70181[(2)] = inst_70136);

(statearr_70164_70181[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (5))){
var _ = (function (){var statearr_70165 = state_70155;
(statearr_70165[(4)] = cljs.core.rest((state_70155[(4)])));

return statearr_70165;
})();
var state_70155__$1 = state_70155;
var ex70160 = (state_70155__$1[(2)]);
var statearr_70166_70182 = state_70155__$1;
(statearr_70166_70182[(5)] = ex70160);


if((ex70160 instanceof Error)){
var statearr_70167_70183 = state_70155__$1;
(statearr_70167_70183[(1)] = (4));

(statearr_70167_70183[(5)] = null);

} else {
throw ex70160;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70156 === (8))){
var inst_70139 = (state_70155[(2)]);
var inst_70140 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_70139);
var inst_70141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70142 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70144 = [inst_70139];
var inst_70145 = (new cljs.core.PersistentVector(null,1,(5),inst_70143,inst_70144,null));
var inst_70146 = ["empty?",inst_70145,inst_70140];
var inst_70147 = cljs.core.PersistentHashMap.fromArrays(inst_70142,inst_70146);
var inst_70148 = [inst_70147,(10)];
var inst_70149 = (new cljs.core.PersistentVector(null,2,(5),inst_70141,inst_70148,null));
var inst_70150 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70149);
var _ = (function (){var statearr_70168 = state_70155;
(statearr_70168[(4)] = cljs.core.rest((state_70155[(4)])));

return statearr_70168;
})();
var state_70155__$1 = (function (){var statearr_70169 = state_70155;
(statearr_70169[(7)] = inst_70150);

return statearr_70169;
})();
var statearr_70170_70184 = state_70155__$1;
(statearr_70170_70184[(2)] = inst_70140);

(statearr_70170_70184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_70171 = [null,null,null,null,null,null,null,null];
(statearr_70171[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__);

(statearr_70171[(1)] = (1));

return statearr_70171;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1 = (function (state_70155){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70155);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70172){var ex__13886__auto__ = e70172;
var statearr_70173_70185 = state_70155;
(statearr_70173_70185[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70155[(4)]))){
var statearr_70174_70186 = state_70155;
(statearr_70174_70186[(1)] = cljs.core.first((state_70155[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70187 = state_70155;
state_70155 = G__70187;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__ = function(state_70155){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1.call(this,state_70155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70175 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70175[(6)] = c__13957__auto__);

return statearr_70175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70232 = arguments.length;
var i__4772__auto___70233 = (0);
while(true){
if((i__4772__auto___70233 < len__4771__auto___70232)){
args__4777__auto__.push((arguments[i__4772__auto___70233]));

var G__70234 = (i__4772__auto___70233 + (1));
i__4772__auto___70233 = G__70234;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70215){
var state_val_70216 = (state_70215[(1)]);
if((state_val_70216 === (1))){
var state_70215__$1 = state_70215;
var statearr_70217_70235 = state_70215__$1;
(statearr_70217_70235[(2)] = null);

(statearr_70217_70235[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70216 === (2))){
var _ = (function (){var statearr_70218 = state_70215;
(statearr_70218[(4)] = cljs.core.cons((5),(state_70215[(4)])));

return statearr_70218;
})();
var inst_70196 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70215__$1 = state_70215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70215__$1,(6),inst_70196);
} else {
if((state_val_70216 === (3))){
var inst_70213 = (state_70215[(2)]);
var state_70215__$1 = state_70215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70215__$1,inst_70213);
} else {
if((state_val_70216 === (4))){
var inst_70190 = (state_70215[(2)]);
var state_70215__$1 = state_70215;
var statearr_70220_70236 = state_70215__$1;
(statearr_70220_70236[(2)] = inst_70190);

(statearr_70220_70236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70216 === (5))){
var _ = (function (){var statearr_70221 = state_70215;
(statearr_70221[(4)] = cljs.core.rest((state_70215[(4)])));

return statearr_70221;
})();
var state_70215__$1 = state_70215;
var ex70219 = (state_70215__$1[(2)]);
var statearr_70222_70237 = state_70215__$1;
(statearr_70222_70237[(5)] = ex70219);


if((ex70219 instanceof Error)){
var statearr_70223_70238 = state_70215__$1;
(statearr_70223_70238[(1)] = (4));

(statearr_70223_70238[(5)] = null);

} else {
throw ex70219;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70216 === (6))){
var inst_70198 = (state_70215[(2)]);
var inst_70199 = fluree.db.util.async.throw_err(inst_70198);
var inst_70200 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_70199);
var inst_70201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70202 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70204 = [inst_70199];
var inst_70205 = (new cljs.core.PersistentVector(null,1,(5),inst_70203,inst_70204,null));
var inst_70206 = ["str",inst_70205,inst_70200];
var inst_70207 = cljs.core.PersistentHashMap.fromArrays(inst_70202,inst_70206);
var inst_70208 = [inst_70207,(10)];
var inst_70209 = (new cljs.core.PersistentVector(null,2,(5),inst_70201,inst_70208,null));
var inst_70210 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70209);
var _ = (function (){var statearr_70224 = state_70215;
(statearr_70224[(4)] = cljs.core.rest((state_70215[(4)])));

return statearr_70224;
})();
var state_70215__$1 = (function (){var statearr_70225 = state_70215;
(statearr_70225[(7)] = inst_70210);

return statearr_70225;
})();
var statearr_70226_70239 = state_70215__$1;
(statearr_70226_70239[(2)] = inst_70200);

(statearr_70226_70239[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70227 = [null,null,null,null,null,null,null,null];
(statearr_70227[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70227[(1)] = (1));

return statearr_70227;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70215){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70215);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70228){var ex__13886__auto__ = e70228;
var statearr_70229_70240 = state_70215;
(statearr_70229_70240[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70215[(4)]))){
var statearr_70230_70241 = state_70215;
(statearr_70230_70241[(1)] = cljs.core.first((state_70215[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70242 = state_70215;
state_70215 = G__70242;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70231 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70231[(6)] = c__13957__auto__);

return statearr_70231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq70188){
var G__70189 = cljs.core.first(seq70188);
var seq70188__$1 = cljs.core.next(seq70188);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70189,seq70188__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70268){
var state_val_70269 = (state_70268[(1)]);
if((state_val_70269 === (1))){
var state_70268__$1 = state_70268;
var statearr_70270_70285 = state_70268__$1;
(statearr_70270_70285[(2)] = null);

(statearr_70270_70285[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70269 === (2))){
var _ = (function (){var statearr_70271 = state_70268;
(statearr_70271[(4)] = cljs.core.cons((5),(state_70268[(4)])));

return statearr_70271;
})();
var inst_70249 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70268__$1 = state_70268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70268__$1,(6),inst_70249);
} else {
if((state_val_70269 === (3))){
var inst_70266 = (state_70268[(2)]);
var state_70268__$1 = state_70268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70268__$1,inst_70266);
} else {
if((state_val_70269 === (4))){
var inst_70243 = (state_70268[(2)]);
var state_70268__$1 = state_70268;
var statearr_70273_70286 = state_70268__$1;
(statearr_70273_70286[(2)] = inst_70243);

(statearr_70273_70286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70269 === (5))){
var _ = (function (){var statearr_70274 = state_70268;
(statearr_70274[(4)] = cljs.core.rest((state_70268[(4)])));

return statearr_70274;
})();
var state_70268__$1 = state_70268;
var ex70272 = (state_70268__$1[(2)]);
var statearr_70275_70287 = state_70268__$1;
(statearr_70275_70287[(5)] = ex70272);


if((ex70272 instanceof Error)){
var statearr_70276_70288 = state_70268__$1;
(statearr_70276_70288[(1)] = (4));

(statearr_70276_70288[(5)] = null);

} else {
throw ex70272;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70269 === (6))){
var inst_70251 = (state_70268[(2)]);
var inst_70252 = fluree.db.util.async.throw_err(inst_70251);
var inst_70253 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_70252);
var inst_70254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70255 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70257 = [inst_70252];
var inst_70258 = (new cljs.core.PersistentVector(null,1,(5),inst_70256,inst_70257,null));
var inst_70259 = ["subs",inst_70258,inst_70253];
var inst_70260 = cljs.core.PersistentHashMap.fromArrays(inst_70255,inst_70259);
var inst_70261 = [inst_70260,(30)];
var inst_70262 = (new cljs.core.PersistentVector(null,2,(5),inst_70254,inst_70261,null));
var inst_70263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70262);
var _ = (function (){var statearr_70277 = state_70268;
(statearr_70277[(4)] = cljs.core.rest((state_70268[(4)])));

return statearr_70277;
})();
var state_70268__$1 = (function (){var statearr_70278 = state_70268;
(statearr_70278[(7)] = inst_70263);

return statearr_70278;
})();
var statearr_70279_70289 = state_70268__$1;
(statearr_70279_70289[(2)] = inst_70253);

(statearr_70279_70289[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0 = (function (){
var statearr_70280 = [null,null,null,null,null,null,null,null];
(statearr_70280[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__);

(statearr_70280[(1)] = (1));

return statearr_70280;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1 = (function (state_70268){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70268);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70281){var ex__13886__auto__ = e70281;
var statearr_70282_70290 = state_70268;
(statearr_70282_70290[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70268[(4)]))){
var statearr_70283_70291 = state_70268;
(statearr_70283_70291[(1)] = cljs.core.first((state_70268[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70292 = state_70268;
state_70268 = G__70292;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__ = function(state_70268){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1.call(this,state_70268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70284 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70284[(6)] = c__13957__auto__);

return statearr_70284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70322){
var state_val_70323 = (state_70322[(1)]);
if((state_val_70323 === (7))){
var state_70322__$1 = state_70322;
var statearr_70324_70343 = state_70322__$1;
(statearr_70324_70343[(2)] = str);

(statearr_70324_70343[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (1))){
var state_70322__$1 = state_70322;
var statearr_70325_70344 = state_70322__$1;
(statearr_70325_70344[(2)] = null);

(statearr_70325_70344[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (4))){
var inst_70293 = (state_70322[(2)]);
var state_70322__$1 = state_70322;
var statearr_70326_70345 = state_70322__$1;
(statearr_70326_70345[(2)] = inst_70293);

(statearr_70326_70345[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (6))){
var state_70322__$1 = state_70322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70322__$1,(9),str);
} else {
if((state_val_70323 === (3))){
var inst_70320 = (state_70322[(2)]);
var state_70322__$1 = state_70322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70322__$1,inst_70320);
} else {
if((state_val_70323 === (2))){
var _ = (function (){var statearr_70328 = state_70322;
(statearr_70328[(4)] = cljs.core.cons((5),(state_70322[(4)])));

return statearr_70328;
})();
var inst_70299 = fluree.db.util.async.channel_QMARK_(str);
var state_70322__$1 = state_70322;
if(inst_70299){
var statearr_70329_70346 = state_70322__$1;
(statearr_70329_70346[(1)] = (6));

} else {
var statearr_70330_70347 = state_70322__$1;
(statearr_70330_70347[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (9))){
var inst_70302 = (state_70322[(2)]);
var inst_70303 = fluree.db.util.async.throw_err(inst_70302);
var state_70322__$1 = state_70322;
var statearr_70331_70348 = state_70322__$1;
(statearr_70331_70348[(2)] = inst_70303);

(statearr_70331_70348[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (5))){
var _ = (function (){var statearr_70332 = state_70322;
(statearr_70332[(4)] = cljs.core.rest((state_70322[(4)])));

return statearr_70332;
})();
var state_70322__$1 = state_70322;
var ex70327 = (state_70322__$1[(2)]);
var statearr_70333_70349 = state_70322__$1;
(statearr_70333_70349[(5)] = ex70327);


if((ex70327 instanceof Error)){
var statearr_70334_70350 = state_70322__$1;
(statearr_70334_70350[(1)] = (4));

(statearr_70334_70350[(5)] = null);

} else {
throw ex70327;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70323 === (8))){
var inst_70306 = (state_70322[(2)]);
var inst_70307 = fluree.db.dbfunctions.internal.lower_case(inst_70306);
var inst_70308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70309 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70311 = [inst_70306];
var inst_70312 = (new cljs.core.PersistentVector(null,1,(5),inst_70310,inst_70311,null));
var inst_70313 = ["lower-case",inst_70312,inst_70307];
var inst_70314 = cljs.core.PersistentHashMap.fromArrays(inst_70309,inst_70313);
var inst_70315 = [inst_70314,(10)];
var inst_70316 = (new cljs.core.PersistentVector(null,2,(5),inst_70308,inst_70315,null));
var inst_70317 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70316);
var _ = (function (){var statearr_70335 = state_70322;
(statearr_70335[(4)] = cljs.core.rest((state_70322[(4)])));

return statearr_70335;
})();
var state_70322__$1 = (function (){var statearr_70336 = state_70322;
(statearr_70336[(7)] = inst_70317);

return statearr_70336;
})();
var statearr_70337_70351 = state_70322__$1;
(statearr_70337_70351[(2)] = inst_70307);

(statearr_70337_70351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0 = (function (){
var statearr_70338 = [null,null,null,null,null,null,null,null];
(statearr_70338[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__);

(statearr_70338[(1)] = (1));

return statearr_70338;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1 = (function (state_70322){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70322);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70339){var ex__13886__auto__ = e70339;
var statearr_70340_70352 = state_70322;
(statearr_70340_70352[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70322[(4)]))){
var statearr_70341_70353 = state_70322;
(statearr_70341_70353[(1)] = cljs.core.first((state_70322[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70354 = state_70322;
state_70322 = G__70354;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__ = function(state_70322){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1.call(this,state_70322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70342 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70342[(6)] = c__13957__auto__);

return statearr_70342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70384){
var state_val_70385 = (state_70384[(1)]);
if((state_val_70385 === (7))){
var state_70384__$1 = state_70384;
var statearr_70386_70405 = state_70384__$1;
(statearr_70386_70405[(2)] = str);

(statearr_70386_70405[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (1))){
var state_70384__$1 = state_70384;
var statearr_70387_70406 = state_70384__$1;
(statearr_70387_70406[(2)] = null);

(statearr_70387_70406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (4))){
var inst_70355 = (state_70384[(2)]);
var state_70384__$1 = state_70384;
var statearr_70388_70407 = state_70384__$1;
(statearr_70388_70407[(2)] = inst_70355);

(statearr_70388_70407[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (6))){
var state_70384__$1 = state_70384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70384__$1,(9),str);
} else {
if((state_val_70385 === (3))){
var inst_70382 = (state_70384[(2)]);
var state_70384__$1 = state_70384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70384__$1,inst_70382);
} else {
if((state_val_70385 === (2))){
var _ = (function (){var statearr_70390 = state_70384;
(statearr_70390[(4)] = cljs.core.cons((5),(state_70384[(4)])));

return statearr_70390;
})();
var inst_70361 = fluree.db.util.async.channel_QMARK_(str);
var state_70384__$1 = state_70384;
if(inst_70361){
var statearr_70391_70408 = state_70384__$1;
(statearr_70391_70408[(1)] = (6));

} else {
var statearr_70392_70409 = state_70384__$1;
(statearr_70392_70409[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (9))){
var inst_70364 = (state_70384[(2)]);
var inst_70365 = fluree.db.util.async.throw_err(inst_70364);
var state_70384__$1 = state_70384;
var statearr_70393_70410 = state_70384__$1;
(statearr_70393_70410[(2)] = inst_70365);

(statearr_70393_70410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (5))){
var _ = (function (){var statearr_70394 = state_70384;
(statearr_70394[(4)] = cljs.core.rest((state_70384[(4)])));

return statearr_70394;
})();
var state_70384__$1 = state_70384;
var ex70389 = (state_70384__$1[(2)]);
var statearr_70395_70411 = state_70384__$1;
(statearr_70395_70411[(5)] = ex70389);


if((ex70389 instanceof Error)){
var statearr_70396_70412 = state_70384__$1;
(statearr_70396_70412[(1)] = (4));

(statearr_70396_70412[(5)] = null);

} else {
throw ex70389;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70385 === (8))){
var inst_70368 = (state_70384[(2)]);
var inst_70369 = fluree.db.dbfunctions.internal.upper_case(inst_70368);
var inst_70370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70371 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70373 = [inst_70368];
var inst_70374 = (new cljs.core.PersistentVector(null,1,(5),inst_70372,inst_70373,null));
var inst_70375 = ["upper-case",inst_70374,inst_70369];
var inst_70376 = cljs.core.PersistentHashMap.fromArrays(inst_70371,inst_70375);
var inst_70377 = [inst_70376,(10)];
var inst_70378 = (new cljs.core.PersistentVector(null,2,(5),inst_70370,inst_70377,null));
var inst_70379 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70378);
var _ = (function (){var statearr_70397 = state_70384;
(statearr_70397[(4)] = cljs.core.rest((state_70384[(4)])));

return statearr_70397;
})();
var state_70384__$1 = (function (){var statearr_70398 = state_70384;
(statearr_70398[(7)] = inst_70379);

return statearr_70398;
})();
var statearr_70399_70413 = state_70384__$1;
(statearr_70399_70413[(2)] = inst_70369);

(statearr_70399_70413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0 = (function (){
var statearr_70400 = [null,null,null,null,null,null,null,null];
(statearr_70400[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__);

(statearr_70400[(1)] = (1));

return statearr_70400;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1 = (function (state_70384){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70384);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70401){var ex__13886__auto__ = e70401;
var statearr_70402_70414 = state_70384;
(statearr_70402_70414[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70384[(4)]))){
var statearr_70403_70415 = state_70384;
(statearr_70403_70415[(1)] = cljs.core.first((state_70384[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70416 = state_70384;
state_70384 = G__70416;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__ = function(state_70384){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1.call(this,state_70384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70404 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70404[(6)] = c__13957__auto__);

return statearr_70404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4149__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4149__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__70418 = arguments.length;
switch (G__70418) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70446){
var state_val_70447 = (state_70446[(1)]);
if((state_val_70447 === (1))){
var state_70446__$1 = state_70446;
var statearr_70448_70464 = state_70446__$1;
(statearr_70448_70464[(2)] = null);

(statearr_70448_70464[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70447 === (2))){
var _ = (function (){var statearr_70449 = state_70446;
(statearr_70449[(4)] = cljs.core.cons((5),(state_70446[(4)])));

return statearr_70449;
})();
var inst_70428 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_70446__$1 = state_70446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70446__$1,(6),inst_70428);
} else {
if((state_val_70447 === (3))){
var inst_70444 = (state_70446[(2)]);
var state_70446__$1 = state_70446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70446__$1,inst_70444);
} else {
if((state_val_70447 === (4))){
var inst_70419 = (state_70446[(2)]);
var state_70446__$1 = state_70446;
var statearr_70451_70465 = state_70446__$1;
(statearr_70451_70465[(2)] = inst_70419);

(statearr_70451_70465[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70447 === (5))){
var _ = (function (){var statearr_70452 = state_70446;
(statearr_70452[(4)] = cljs.core.rest((state_70446[(4)])));

return statearr_70452;
})();
var state_70446__$1 = state_70446;
var ex70450 = (state_70446__$1[(2)]);
var statearr_70453_70466 = state_70446__$1;
(statearr_70453_70466[(5)] = ex70450);


if((ex70450 instanceof Error)){
var statearr_70454_70467 = state_70446__$1;
(statearr_70454_70467[(1)] = (4));

(statearr_70454_70467[(5)] = null);

} else {
throw ex70450;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70447 === (6))){
var inst_70430 = (state_70446[(2)]);
var inst_70431 = fluree.db.util.async.throw_err(inst_70430);
var inst_70432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70431,(0),null);
var inst_70433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70431,(1),null);
var inst_70434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70435 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70436 = ["?s","?ctx",inst_70432];
var inst_70437 = cljs.core.PersistentHashMap.fromArrays(inst_70435,inst_70436);
var inst_70438 = ((10) + inst_70433);
var inst_70439 = [inst_70437,inst_70438];
var inst_70440 = (new cljs.core.PersistentVector(null,2,(5),inst_70434,inst_70439,null));
var inst_70441 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70440);
var _ = (function (){var statearr_70455 = state_70446;
(statearr_70455[(4)] = cljs.core.rest((state_70446[(4)])));

return statearr_70455;
})();
var state_70446__$1 = (function (){var statearr_70456 = state_70446;
(statearr_70456[(7)] = inst_70441);

return statearr_70456;
})();
var statearr_70457_70468 = state_70446__$1;
(statearr_70457_70468[(2)] = inst_70432);

(statearr_70457_70468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70458 = [null,null,null,null,null,null,null,null];
(statearr_70458[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70458[(1)] = (1));

return statearr_70458;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70446){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70446);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70459){var ex__13886__auto__ = e70459;
var statearr_70460_70469 = state_70446;
(statearr_70460_70469[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70446[(4)]))){
var statearr_70461_70470 = state_70446;
(statearr_70461_70470[(1)] = cljs.core.first((state_70446[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70471 = state_70446;
state_70446 = G__70471;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70446){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70462 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70462[(6)] = c__13957__auto__);

return statearr_70462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__70473 = arguments.length;
switch (G__70473) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70511){
var state_val_70512 = (state_70511[(1)]);
if((state_val_70512 === (7))){
var inst_70504 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_70511__$1 = state_70511;
var statearr_70513_70533 = state_70511__$1;
(statearr_70513_70533[(2)] = inst_70504);

(statearr_70513_70533[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (1))){
var state_70511__$1 = state_70511;
var statearr_70514_70534 = state_70511__$1;
(statearr_70514_70534[(2)] = null);

(statearr_70514_70534[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (4))){
var inst_70474 = (state_70511[(2)]);
var state_70511__$1 = state_70511;
var statearr_70515_70535 = state_70511__$1;
(statearr_70515_70535[(2)] = inst_70474);

(statearr_70515_70535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (6))){
var inst_70485 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_70511__$1 = state_70511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70511__$1,(10),inst_70485);
} else {
if((state_val_70512 === (3))){
var inst_70509 = (state_70511[(2)]);
var state_70511__$1 = state_70511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70511__$1,inst_70509);
} else {
if((state_val_70512 === (2))){
var _ = (function (){var statearr_70517 = state_70511;
(statearr_70517[(4)] = cljs.core.cons((5),(state_70511[(4)])));

return statearr_70517;
})();
var inst_70480 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70511__$1 = state_70511;
if(cljs.core.truth_(inst_70480)){
var statearr_70518_70536 = state_70511__$1;
(statearr_70518_70536[(1)] = (6));

} else {
var statearr_70519_70537 = state_70511__$1;
(statearr_70519_70537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (9))){
var inst_70491 = (state_70511[(2)]);
var inst_70492 = fluree.db.util.async.throw_err(inst_70491);
var inst_70493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70492,(0),null);
var inst_70494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70492,(1),null);
var inst_70495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70496 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70497 = ["?p","?ctx",inst_70493];
var inst_70498 = cljs.core.PersistentHashMap.fromArrays(inst_70496,inst_70497);
var inst_70499 = ((10) + inst_70494);
var inst_70500 = [inst_70498,inst_70499];
var inst_70501 = (new cljs.core.PersistentVector(null,2,(5),inst_70495,inst_70500,null));
var inst_70502 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70501);
var state_70511__$1 = (function (){var statearr_70520 = state_70511;
(statearr_70520[(7)] = inst_70502);

return statearr_70520;
})();
var statearr_70521_70538 = state_70511__$1;
(statearr_70521_70538[(2)] = inst_70493);

(statearr_70521_70538[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (5))){
var _ = (function (){var statearr_70522 = state_70511;
(statearr_70522[(4)] = cljs.core.rest((state_70511[(4)])));

return statearr_70522;
})();
var state_70511__$1 = state_70511;
var ex70516 = (state_70511__$1[(2)]);
var statearr_70523_70539 = state_70511__$1;
(statearr_70523_70539[(5)] = ex70516);


if((ex70516 instanceof Error)){
var statearr_70524_70540 = state_70511__$1;
(statearr_70524_70540[(1)] = (4));

(statearr_70524_70540[(5)] = null);

} else {
throw ex70516;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70512 === (10))){
var inst_70487 = (state_70511[(2)]);
var inst_70488 = fluree.db.util.async.throw_err(inst_70487);
var inst_70489 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_70488);
var state_70511__$1 = state_70511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70511__$1,(9),inst_70489);
} else {
if((state_val_70512 === (8))){
var inst_70506 = (state_70511[(2)]);
var _ = (function (){var statearr_70525 = state_70511;
(statearr_70525[(4)] = cljs.core.rest((state_70511[(4)])));

return statearr_70525;
})();
var state_70511__$1 = state_70511;
var statearr_70526_70541 = state_70511__$1;
(statearr_70526_70541[(2)] = inst_70506);

(statearr_70526_70541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70527 = [null,null,null,null,null,null,null,null];
(statearr_70527[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70527[(1)] = (1));

return statearr_70527;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70511){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70511);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70528){var ex__13886__auto__ = e70528;
var statearr_70529_70542 = state_70511;
(statearr_70529_70542[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70511[(4)]))){
var statearr_70530_70543 = state_70511;
(statearr_70530_70543[(1)] = cljs.core.first((state_70511[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70544 = state_70511;
state_70511 = G__70544;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70511){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70531 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70531[(6)] = c__13957__auto__);

return statearr_70531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70593 = arguments.length;
var i__4772__auto___70594 = (0);
while(true){
if((i__4772__auto___70594 < len__4771__auto___70593)){
args__4777__auto__.push((arguments[i__4772__auto___70594]));

var G__70595 = (i__4772__auto___70594 + (1));
i__4772__auto___70594 = G__70595;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70576){
var state_val_70577 = (state_70576[(1)]);
if((state_val_70577 === (1))){
var state_70576__$1 = state_70576;
var statearr_70578_70596 = state_70576__$1;
(statearr_70578_70596[(2)] = null);

(statearr_70578_70596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70577 === (2))){
var _ = (function (){var statearr_70579 = state_70576;
(statearr_70579[(4)] = cljs.core.cons((5),(state_70576[(4)])));

return statearr_70579;
})();
var inst_70553 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70576__$1 = state_70576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70576__$1,(6),inst_70553);
} else {
if((state_val_70577 === (3))){
var inst_70574 = (state_70576[(2)]);
var state_70576__$1 = state_70576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70576__$1,inst_70574);
} else {
if((state_val_70577 === (4))){
var inst_70547 = (state_70576[(2)]);
var state_70576__$1 = state_70576;
var statearr_70581_70597 = state_70576__$1;
(statearr_70581_70597[(2)] = inst_70547);

(statearr_70581_70597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70577 === (5))){
var _ = (function (){var statearr_70582 = state_70576;
(statearr_70582[(4)] = cljs.core.rest((state_70576[(4)])));

return statearr_70582;
})();
var state_70576__$1 = state_70576;
var ex70580 = (state_70576__$1[(2)]);
var statearr_70583_70598 = state_70576__$1;
(statearr_70583_70598[(5)] = ex70580);


if((ex70580 instanceof Error)){
var statearr_70584_70599 = state_70576__$1;
(statearr_70584_70599[(1)] = (4));

(statearr_70584_70599[(5)] = null);

} else {
throw ex70580;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70577 === (6))){
var inst_70555 = (state_70576[(2)]);
var inst_70556 = fluree.db.util.async.throw_err(inst_70555);
var inst_70557 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_70556);
var inst_70558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70559 = [inst_70556];
var inst_70560 = (new cljs.core.PersistentVector(null,1,(5),inst_70558,inst_70559,null));
var inst_70561 = cljs.core.count(inst_70560);
var inst_70562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70563 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70565 = [inst_70556];
var inst_70566 = (new cljs.core.PersistentVector(null,1,(5),inst_70564,inst_70565,null));
var inst_70567 = ["and",inst_70566,inst_70557];
var inst_70568 = cljs.core.PersistentHashMap.fromArrays(inst_70563,inst_70567);
var inst_70569 = [inst_70568,inst_70561];
var inst_70570 = (new cljs.core.PersistentVector(null,2,(5),inst_70562,inst_70569,null));
var inst_70571 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70570);
var _ = (function (){var statearr_70585 = state_70576;
(statearr_70585[(4)] = cljs.core.rest((state_70576[(4)])));

return statearr_70585;
})();
var state_70576__$1 = (function (){var statearr_70586 = state_70576;
(statearr_70586[(7)] = inst_70571);

return statearr_70586;
})();
var statearr_70587_70600 = state_70576__$1;
(statearr_70587_70600[(2)] = inst_70557);

(statearr_70587_70600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70588 = [null,null,null,null,null,null,null,null];
(statearr_70588[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70588[(1)] = (1));

return statearr_70588;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70576){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70576);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70589){var ex__13886__auto__ = e70589;
var statearr_70590_70601 = state_70576;
(statearr_70590_70601[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70576[(4)]))){
var statearr_70591_70602 = state_70576;
(statearr_70591_70602[(1)] = cljs.core.first((state_70576[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70603 = state_70576;
state_70576 = G__70603;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70576){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70592 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70592[(6)] = c__13957__auto__);

return statearr_70592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq70545){
var G__70546 = cljs.core.first(seq70545);
var seq70545__$1 = cljs.core.next(seq70545);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70546,seq70545__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4777__auto__ = [];
var len__4771__auto___70652 = arguments.length;
var i__4772__auto___70653 = (0);
while(true){
if((i__4772__auto___70653 < len__4771__auto___70652)){
args__4777__auto__.push((arguments[i__4772__auto___70653]));

var G__70654 = (i__4772__auto___70653 + (1));
i__4772__auto___70653 = G__70654;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70635){
var state_val_70636 = (state_70635[(1)]);
if((state_val_70636 === (1))){
var state_70635__$1 = state_70635;
var statearr_70637_70655 = state_70635__$1;
(statearr_70637_70655[(2)] = null);

(statearr_70637_70655[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70636 === (2))){
var _ = (function (){var statearr_70638 = state_70635;
(statearr_70638[(4)] = cljs.core.cons((5),(state_70635[(4)])));

return statearr_70638;
})();
var inst_70612 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70635__$1,(6),inst_70612);
} else {
if((state_val_70636 === (3))){
var inst_70633 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70635__$1,inst_70633);
} else {
if((state_val_70636 === (4))){
var inst_70606 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70640_70656 = state_70635__$1;
(statearr_70640_70656[(2)] = inst_70606);

(statearr_70640_70656[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70636 === (5))){
var _ = (function (){var statearr_70641 = state_70635;
(statearr_70641[(4)] = cljs.core.rest((state_70635[(4)])));

return statearr_70641;
})();
var state_70635__$1 = state_70635;
var ex70639 = (state_70635__$1[(2)]);
var statearr_70642_70657 = state_70635__$1;
(statearr_70642_70657[(5)] = ex70639);


if((ex70639 instanceof Error)){
var statearr_70643_70658 = state_70635__$1;
(statearr_70643_70658[(1)] = (4));

(statearr_70643_70658[(5)] = null);

} else {
throw ex70639;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70636 === (6))){
var inst_70614 = (state_70635[(2)]);
var inst_70615 = fluree.db.util.async.throw_err(inst_70614);
var inst_70616 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_70615);
var inst_70617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70618 = [inst_70615];
var inst_70619 = (new cljs.core.PersistentVector(null,1,(5),inst_70617,inst_70618,null));
var inst_70620 = cljs.core.count(inst_70619);
var inst_70621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70622 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70624 = [inst_70615];
var inst_70625 = (new cljs.core.PersistentVector(null,1,(5),inst_70623,inst_70624,null));
var inst_70626 = ["or",inst_70625,inst_70616];
var inst_70627 = cljs.core.PersistentHashMap.fromArrays(inst_70622,inst_70626);
var inst_70628 = [inst_70627,inst_70620];
var inst_70629 = (new cljs.core.PersistentVector(null,2,(5),inst_70621,inst_70628,null));
var inst_70630 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70629);
var _ = (function (){var statearr_70644 = state_70635;
(statearr_70644[(4)] = cljs.core.rest((state_70635[(4)])));

return statearr_70644;
})();
var state_70635__$1 = (function (){var statearr_70645 = state_70635;
(statearr_70645[(7)] = inst_70630);

return statearr_70645;
})();
var statearr_70646_70659 = state_70635__$1;
(statearr_70646_70659[(2)] = inst_70616);

(statearr_70646_70659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_70647 = [null,null,null,null,null,null,null,null];
(statearr_70647[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_70647[(1)] = (1));

return statearr_70647;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_70635){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70635);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70648){var ex__13886__auto__ = e70648;
var statearr_70649_70660 = state_70635;
(statearr_70649_70660[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70635[(4)]))){
var statearr_70650_70661 = state_70635;
(statearr_70650_70661[(1)] = cljs.core.first((state_70635[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70662 = state_70635;
state_70635 = G__70662;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_70635){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_70635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70651 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70651[(6)] = c__13957__auto__);

return statearr_70651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq70604){
var G__70605 = cljs.core.first(seq70604);
var seq70604__$1 = cljs.core.next(seq70604);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70605,seq70604__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70700){
var state_val_70701 = (state_70700[(1)]);
if((state_val_70701 === (7))){
var inst_70676 = fluree.db.util.async.channel_QMARK_(coll);
var state_70700__$1 = state_70700;
if(inst_70676){
var statearr_70702_70725 = state_70700__$1;
(statearr_70702_70725[(1)] = (10));

} else {
var statearr_70703_70726 = state_70700__$1;
(statearr_70703_70726[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (1))){
var state_70700__$1 = state_70700;
var statearr_70704_70727 = state_70700__$1;
(statearr_70704_70727[(2)] = null);

(statearr_70704_70727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (4))){
var inst_70663 = (state_70700[(2)]);
var state_70700__$1 = state_70700;
var statearr_70705_70728 = state_70700__$1;
(statearr_70705_70728[(2)] = inst_70663);

(statearr_70705_70728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (13))){
var inst_70679 = (state_70700[(2)]);
var inst_70680 = fluree.db.util.async.throw_err(inst_70679);
var state_70700__$1 = state_70700;
var statearr_70706_70729 = state_70700__$1;
(statearr_70706_70729[(2)] = inst_70680);

(statearr_70706_70729[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (6))){
var inst_70671 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_70700__$1 = state_70700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70700__$1,(9),inst_70671);
} else {
if((state_val_70701 === (3))){
var inst_70698 = (state_70700[(2)]);
var state_70700__$1 = state_70700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70700__$1,inst_70698);
} else {
if((state_val_70701 === (12))){
var inst_70683 = (state_70700[(2)]);
var state_70700__$1 = state_70700;
var statearr_70707_70730 = state_70700__$1;
(statearr_70707_70730[(2)] = inst_70683);

(statearr_70707_70730[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (2))){
var _ = (function (){var statearr_70708 = state_70700;
(statearr_70708[(4)] = cljs.core.cons((5),(state_70700[(4)])));

return statearr_70708;
})();
var inst_70669 = cljs.core.vector_QMARK_(coll);
var state_70700__$1 = state_70700;
if(inst_70669){
var statearr_70709_70731 = state_70700__$1;
(statearr_70709_70731[(1)] = (6));

} else {
var statearr_70710_70732 = state_70700__$1;
(statearr_70710_70732[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (11))){
var state_70700__$1 = state_70700;
var statearr_70712_70733 = state_70700__$1;
(statearr_70712_70733[(2)] = coll);

(statearr_70712_70733[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (9))){
var inst_70673 = (state_70700[(2)]);
var inst_70674 = fluree.db.util.async.throw_err(inst_70673);
var state_70700__$1 = state_70700;
var statearr_70713_70734 = state_70700__$1;
(statearr_70713_70734[(2)] = inst_70674);

(statearr_70713_70734[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (5))){
var _ = (function (){var statearr_70714 = state_70700;
(statearr_70714[(4)] = cljs.core.rest((state_70700[(4)])));

return statearr_70714;
})();
var state_70700__$1 = state_70700;
var ex70711 = (state_70700__$1[(2)]);
var statearr_70715_70735 = state_70700__$1;
(statearr_70715_70735[(5)] = ex70711);


if((ex70711 instanceof Error)){
var statearr_70716_70736 = state_70700__$1;
(statearr_70716_70736[(1)] = (4));

(statearr_70716_70736[(5)] = null);

} else {
throw ex70711;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70701 === (10))){
var state_70700__$1 = state_70700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70700__$1,(13),coll);
} else {
if((state_val_70701 === (8))){
var inst_70685 = (state_70700[(2)]);
var inst_70686 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_70685);
var inst_70687 = cljs.core.count(inst_70686);
var inst_70688 = ((9) + inst_70687);
var inst_70689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70690 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70691 = ["count",inst_70685,inst_70687];
var inst_70692 = cljs.core.PersistentHashMap.fromArrays(inst_70690,inst_70691);
var inst_70693 = [inst_70692,inst_70688];
var inst_70694 = (new cljs.core.PersistentVector(null,2,(5),inst_70689,inst_70693,null));
var inst_70695 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70694);
var _ = (function (){var statearr_70717 = state_70700;
(statearr_70717[(4)] = cljs.core.rest((state_70700[(4)])));

return statearr_70717;
})();
var state_70700__$1 = (function (){var statearr_70718 = state_70700;
(statearr_70718[(7)] = inst_70695);

return statearr_70718;
})();
var statearr_70719_70737 = state_70700__$1;
(statearr_70719_70737[(2)] = inst_70687);

(statearr_70719_70737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0 = (function (){
var statearr_70720 = [null,null,null,null,null,null,null,null];
(statearr_70720[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__);

(statearr_70720[(1)] = (1));

return statearr_70720;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1 = (function (state_70700){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70700);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70721){var ex__13886__auto__ = e70721;
var statearr_70722_70738 = state_70700;
(statearr_70722_70738[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70700[(4)]))){
var statearr_70723_70739 = state_70700;
(statearr_70723_70739[(1)] = cljs.core.first((state_70700[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70740 = state_70700;
state_70700 = G__70740;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__ = function(state_70700){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1.call(this,state_70700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70724 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70724[(6)] = c__13957__auto__);

return statearr_70724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70790){
var state_val_70791 = (state_70790[(1)]);
if((state_val_70791 === (7))){
var state_70790__$1 = state_70790;
var statearr_70792_70825 = state_70790__$1;
(statearr_70792_70825[(2)] = subject);

(statearr_70792_70825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (1))){
var state_70790__$1 = state_70790;
var statearr_70793_70826 = state_70790__$1;
(statearr_70793_70826[(2)] = null);

(statearr_70793_70826[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (4))){
var inst_70741 = (state_70790[(2)]);
var state_70790__$1 = state_70790;
var statearr_70794_70827 = state_70790__$1;
(statearr_70794_70827[(2)] = inst_70741);

(statearr_70794_70827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (15))){
var inst_70754 = (state_70790[(7)]);
var state_70790__$1 = state_70790;
var statearr_70795_70828 = state_70790__$1;
(statearr_70795_70828[(2)] = inst_70754);

(statearr_70795_70828[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (13))){
var inst_70758 = (state_70790[(2)]);
var inst_70759 = fluree.db.util.async.throw_err(inst_70758);
var state_70790__$1 = state_70790;
var statearr_70796_70829 = state_70790__$1;
(statearr_70796_70829[(2)] = inst_70759);

(statearr_70796_70829[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (6))){
var state_70790__$1 = state_70790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70790__$1,(9),subject);
} else {
if((state_val_70791 === (17))){
var inst_70754 = (state_70790[(7)]);
var inst_70768 = cljs.core.first(inst_70754);
var state_70790__$1 = state_70790;
var statearr_70797_70830 = state_70790__$1;
(statearr_70797_70830[(2)] = inst_70768);

(statearr_70797_70830[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (3))){
var inst_70788 = (state_70790[(2)]);
var state_70790__$1 = state_70790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70790__$1,inst_70788);
} else {
if((state_val_70791 === (12))){
var inst_70754 = (state_70790[(7)]);
var inst_70762 = (state_70790[(2)]);
var inst_70763 = cljs.core.vector_QMARK_(inst_70754);
var state_70790__$1 = (function (){var statearr_70798 = state_70790;
(statearr_70798[(8)] = inst_70762);

return statearr_70798;
})();
if(inst_70763){
var statearr_70799_70831 = state_70790__$1;
(statearr_70799_70831[(1)] = (14));

} else {
var statearr_70800_70832 = state_70790__$1;
(statearr_70800_70832[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (2))){
var _ = (function (){var statearr_70801 = state_70790;
(statearr_70801[(4)] = cljs.core.cons((5),(state_70790[(4)])));

return statearr_70801;
})();
var inst_70747 = fluree.db.util.async.channel_QMARK_(subject);
var state_70790__$1 = state_70790;
if(inst_70747){
var statearr_70802_70833 = state_70790__$1;
(statearr_70802_70833[(1)] = (6));

} else {
var statearr_70803_70834 = state_70790__$1;
(statearr_70803_70834[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (19))){
var inst_70771 = (state_70790[(2)]);
var state_70790__$1 = state_70790;
var statearr_70804_70835 = state_70790__$1;
(statearr_70804_70835[(2)] = inst_70771);

(statearr_70804_70835[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (11))){
var state_70790__$1 = state_70790;
var statearr_70806_70836 = state_70790__$1;
(statearr_70806_70836[(2)] = pred);

(statearr_70806_70836[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (9))){
var inst_70750 = (state_70790[(2)]);
var inst_70751 = fluree.db.util.async.throw_err(inst_70750);
var state_70790__$1 = state_70790;
var statearr_70807_70837 = state_70790__$1;
(statearr_70807_70837[(2)] = inst_70751);

(statearr_70807_70837[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (5))){
var _ = (function (){var statearr_70808 = state_70790;
(statearr_70808[(4)] = cljs.core.rest((state_70790[(4)])));

return statearr_70808;
})();
var state_70790__$1 = state_70790;
var ex70805 = (state_70790__$1[(2)]);
var statearr_70809_70838 = state_70790__$1;
(statearr_70809_70838[(5)] = ex70805);


if((ex70805 instanceof Error)){
var statearr_70810_70839 = state_70790__$1;
(statearr_70810_70839[(1)] = (4));

(statearr_70810_70839[(5)] = null);

} else {
throw ex70805;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (14))){
var inst_70754 = (state_70790[(7)]);
var inst_70765 = cljs.core.count(inst_70754);
var inst_70766 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70765);
var state_70790__$1 = state_70790;
if(inst_70766){
var statearr_70811_70840 = state_70790__$1;
(statearr_70811_70840[(1)] = (17));

} else {
var statearr_70812_70841 = state_70790__$1;
(statearr_70812_70841[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (16))){
var inst_70762 = (state_70790[(8)]);
var inst_70754 = (state_70790[(7)]);
var inst_70774 = (state_70790[(2)]);
var inst_70775 = fluree.db.dbfunctions.internal.get(inst_70774,inst_70762);
var inst_70776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70777 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70779 = [inst_70754,inst_70762];
var inst_70780 = (new cljs.core.PersistentVector(null,2,(5),inst_70778,inst_70779,null));
var inst_70781 = ["get",inst_70780,inst_70775];
var inst_70782 = cljs.core.PersistentHashMap.fromArrays(inst_70777,inst_70781);
var inst_70783 = [inst_70782,(10)];
var inst_70784 = (new cljs.core.PersistentVector(null,2,(5),inst_70776,inst_70783,null));
var inst_70785 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70784);
var _ = (function (){var statearr_70813 = state_70790;
(statearr_70813[(4)] = cljs.core.rest((state_70790[(4)])));

return statearr_70813;
})();
var state_70790__$1 = (function (){var statearr_70814 = state_70790;
(statearr_70814[(9)] = inst_70785);

return statearr_70814;
})();
var statearr_70815_70842 = state_70790__$1;
(statearr_70815_70842[(2)] = inst_70775);

(statearr_70815_70842[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (10))){
var state_70790__$1 = state_70790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70790__$1,(13),pred);
} else {
if((state_val_70791 === (18))){
var inst_70754 = (state_70790[(7)]);
var state_70790__$1 = state_70790;
var statearr_70816_70843 = state_70790__$1;
(statearr_70816_70843[(2)] = inst_70754);

(statearr_70816_70843[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70791 === (8))){
var inst_70754 = (state_70790[(2)]);
var inst_70755 = fluree.db.util.async.channel_QMARK_(pred);
var state_70790__$1 = (function (){var statearr_70817 = state_70790;
(statearr_70817[(7)] = inst_70754);

return statearr_70817;
})();
if(inst_70755){
var statearr_70818_70844 = state_70790__$1;
(statearr_70818_70844[(1)] = (10));

} else {
var statearr_70819_70845 = state_70790__$1;
(statearr_70819_70845[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0 = (function (){
var statearr_70820 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70820[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__);

(statearr_70820[(1)] = (1));

return statearr_70820;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1 = (function (state_70790){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70790);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70821){var ex__13886__auto__ = e70821;
var statearr_70822_70846 = state_70790;
(statearr_70822_70846[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70790[(4)]))){
var statearr_70823_70847 = state_70790;
(statearr_70823_70847[(1)] = cljs.core.first((state_70790[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70848 = state_70790;
state_70790 = G__70848;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__ = function(state_70790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1.call(this,state_70790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70824 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70824[(6)] = c__13957__auto__);

return statearr_70824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70887){
var state_val_70888 = (state_70887[(1)]);
if((state_val_70888 === (7))){
var inst_70855 = (state_70887[(7)]);
var state_70887__$1 = state_70887;
var statearr_70889_70913 = state_70887__$1;
(statearr_70889_70913[(2)] = inst_70855);

(statearr_70889_70913[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (1))){
var state_70887__$1 = state_70887;
var statearr_70890_70914 = state_70887__$1;
(statearr_70890_70914[(2)] = null);

(statearr_70890_70914[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (4))){
var inst_70849 = (state_70887[(2)]);
var state_70887__$1 = state_70887;
var statearr_70891_70915 = state_70887__$1;
(statearr_70891_70915[(2)] = inst_70849);

(statearr_70891_70915[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (6))){
var inst_70857 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70887__$1 = state_70887;
var statearr_70892_70916 = state_70887__$1;
(statearr_70892_70916[(2)] = inst_70857);

(statearr_70892_70916[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (3))){
var inst_70885 = (state_70887[(2)]);
var state_70887__$1 = state_70887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70887__$1,inst_70885);
} else {
if((state_val_70888 === (12))){
var inst_70867 = (state_70887[(2)]);
var inst_70868 = fluree.db.util.async.throw_err(inst_70867);
var inst_70869 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70868,(0),null);
var inst_70870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70868,(1),null);
var inst_70871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70872 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70873 = ["?pO","?ctx",inst_70869];
var inst_70874 = cljs.core.PersistentHashMap.fromArrays(inst_70872,inst_70873);
var inst_70875 = ((10) + inst_70870);
var inst_70876 = [inst_70874,inst_70875];
var inst_70877 = (new cljs.core.PersistentVector(null,2,(5),inst_70871,inst_70876,null));
var inst_70878 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70877);
var state_70887__$1 = (function (){var statearr_70893 = state_70887;
(statearr_70893[(8)] = inst_70878);

return statearr_70893;
})();
var statearr_70894_70917 = state_70887__$1;
(statearr_70894_70917[(2)] = inst_70869);

(statearr_70894_70917[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (2))){
var inst_70855 = (state_70887[(7)]);
var _ = (function (){var statearr_70895 = state_70887;
(statearr_70895[(4)] = cljs.core.cons((5),(state_70887[(4)])));

return statearr_70895;
})();
var inst_70855__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70887__$1 = (function (){var statearr_70896 = state_70887;
(statearr_70896[(7)] = inst_70855__$1);

return statearr_70896;
})();
if(cljs.core.truth_(inst_70855__$1)){
var statearr_70897_70918 = state_70887__$1;
(statearr_70897_70918[(1)] = (6));

} else {
var statearr_70898_70919 = state_70887__$1;
(statearr_70898_70919[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (11))){
var inst_70882 = (state_70887[(2)]);
var _ = (function (){var statearr_70900 = state_70887;
(statearr_70900[(4)] = cljs.core.rest((state_70887[(4)])));

return statearr_70900;
})();
var state_70887__$1 = state_70887;
var statearr_70901_70920 = state_70887__$1;
(statearr_70901_70920[(2)] = inst_70882);

(statearr_70901_70920[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (9))){
var inst_70865 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_70887__$1 = state_70887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70887__$1,(12),inst_70865);
} else {
if((state_val_70888 === (5))){
var _ = (function (){var statearr_70902 = state_70887;
(statearr_70902[(4)] = cljs.core.rest((state_70887[(4)])));

return statearr_70902;
})();
var state_70887__$1 = state_70887;
var ex70899 = (state_70887__$1[(2)]);
var statearr_70903_70921 = state_70887__$1;
(statearr_70903_70921[(5)] = ex70899);


if((ex70899 instanceof Error)){
var statearr_70904_70922 = state_70887__$1;
(statearr_70904_70922[(1)] = (4));

(statearr_70904_70922[(5)] = null);

} else {
throw ex70899;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (10))){
var inst_70880 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_70887__$1 = state_70887;
var statearr_70905_70923 = state_70887__$1;
(statearr_70905_70923[(2)] = inst_70880);

(statearr_70905_70923[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70888 === (8))){
var inst_70860 = (state_70887[(2)]);
var state_70887__$1 = state_70887;
if(cljs.core.truth_(inst_70860)){
var statearr_70906_70924 = state_70887__$1;
(statearr_70906_70924[(1)] = (9));

} else {
var statearr_70907_70925 = state_70887__$1;
(statearr_70907_70925[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0 = (function (){
var statearr_70908 = [null,null,null,null,null,null,null,null,null];
(statearr_70908[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__);

(statearr_70908[(1)] = (1));

return statearr_70908;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1 = (function (state_70887){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70887);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e70909){var ex__13886__auto__ = e70909;
var statearr_70910_70926 = state_70887;
(statearr_70910_70926[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70887[(4)]))){
var statearr_70911_70927 = state_70887;
(statearr_70911_70927[(1)] = cljs.core.first((state_70887[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__70928 = state_70887;
state_70887 = G__70928;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__ = function(state_70887){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1.call(this,state_70887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_70912 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_70912[(6)] = c__13957__auto__);

return statearr_70912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_70980){
var state_val_70981 = (state_70980[(1)]);
if((state_val_70981 === (7))){
var state_70980__$1 = state_70980;
var statearr_70982_71015 = state_70980__$1;
(statearr_70982_71015[(2)] = subject);

(statearr_70982_71015[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (1))){
var state_70980__$1 = state_70980;
var statearr_70983_71016 = state_70980__$1;
(statearr_70983_71016[(2)] = null);

(statearr_70983_71016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (4))){
var inst_70929 = (state_70980[(2)]);
var state_70980__$1 = state_70980;
var statearr_70984_71017 = state_70980__$1;
(statearr_70984_71017[(2)] = inst_70929);

(statearr_70984_71017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (15))){
var inst_70942 = (state_70980[(7)]);
var state_70980__$1 = state_70980;
var statearr_70985_71018 = state_70980__$1;
(statearr_70985_71018[(2)] = inst_70942);

(statearr_70985_71018[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (13))){
var inst_70946 = (state_70980[(2)]);
var inst_70947 = fluree.db.util.async.throw_err(inst_70946);
var state_70980__$1 = state_70980;
var statearr_70986_71019 = state_70980__$1;
(statearr_70986_71019[(2)] = inst_70947);

(statearr_70986_71019[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (6))){
var state_70980__$1 = state_70980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70980__$1,(9),subject);
} else {
if((state_val_70981 === (17))){
var inst_70942 = (state_70980[(7)]);
var inst_70956 = cljs.core.first(inst_70942);
var state_70980__$1 = state_70980;
var statearr_70987_71020 = state_70980__$1;
(statearr_70987_71020[(2)] = inst_70956);

(statearr_70987_71020[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (3))){
var inst_70978 = (state_70980[(2)]);
var state_70980__$1 = state_70980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70980__$1,inst_70978);
} else {
if((state_val_70981 === (12))){
var inst_70942 = (state_70980[(7)]);
var inst_70950 = (state_70980[(2)]);
var inst_70951 = cljs.core.vector_QMARK_(inst_70942);
var state_70980__$1 = (function (){var statearr_70988 = state_70980;
(statearr_70988[(8)] = inst_70950);

return statearr_70988;
})();
if(inst_70951){
var statearr_70989_71021 = state_70980__$1;
(statearr_70989_71021[(1)] = (14));

} else {
var statearr_70990_71022 = state_70980__$1;
(statearr_70990_71022[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (2))){
var _ = (function (){var statearr_70991 = state_70980;
(statearr_70991[(4)] = cljs.core.cons((5),(state_70980[(4)])));

return statearr_70991;
})();
var inst_70935 = fluree.db.util.async.channel_QMARK_(subject);
var state_70980__$1 = state_70980;
if(inst_70935){
var statearr_70992_71023 = state_70980__$1;
(statearr_70992_71023[(1)] = (6));

} else {
var statearr_70993_71024 = state_70980__$1;
(statearr_70993_71024[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (19))){
var inst_70959 = (state_70980[(2)]);
var state_70980__$1 = state_70980;
var statearr_70994_71025 = state_70980__$1;
(statearr_70994_71025[(2)] = inst_70959);

(statearr_70994_71025[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (11))){
var state_70980__$1 = state_70980;
var statearr_70996_71026 = state_70980__$1;
(statearr_70996_71026[(2)] = path);

(statearr_70996_71026[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (9))){
var inst_70938 = (state_70980[(2)]);
var inst_70939 = fluree.db.util.async.throw_err(inst_70938);
var state_70980__$1 = state_70980;
var statearr_70997_71027 = state_70980__$1;
(statearr_70997_71027[(2)] = inst_70939);

(statearr_70997_71027[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (5))){
var _ = (function (){var statearr_70998 = state_70980;
(statearr_70998[(4)] = cljs.core.rest((state_70980[(4)])));

return statearr_70998;
})();
var state_70980__$1 = state_70980;
var ex70995 = (state_70980__$1[(2)]);
var statearr_70999_71028 = state_70980__$1;
(statearr_70999_71028[(5)] = ex70995);


if((ex70995 instanceof Error)){
var statearr_71000_71029 = state_70980__$1;
(statearr_71000_71029[(1)] = (4));

(statearr_71000_71029[(5)] = null);

} else {
throw ex70995;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (14))){
var inst_70942 = (state_70980[(7)]);
var inst_70953 = cljs.core.count(inst_70942);
var inst_70954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70953);
var state_70980__$1 = state_70980;
if(inst_70954){
var statearr_71001_71030 = state_70980__$1;
(statearr_71001_71030[(1)] = (17));

} else {
var statearr_71002_71031 = state_70980__$1;
(statearr_71002_71031[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (16))){
var inst_70942 = (state_70980[(7)]);
var inst_70950 = (state_70980[(8)]);
var inst_70962 = (state_70980[(2)]);
var inst_70963 = fluree.db.dbfunctions.internal.get_all(inst_70962,inst_70950);
var inst_70964 = cljs.core.count(inst_70950);
var inst_70965 = ((9) + inst_70964);
var inst_70966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70967 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70969 = [inst_70942,inst_70950];
var inst_70970 = (new cljs.core.PersistentVector(null,2,(5),inst_70968,inst_70969,null));
var inst_70971 = ["get-all",inst_70970,inst_70963];
var inst_70972 = cljs.core.PersistentHashMap.fromArrays(inst_70967,inst_70971);
var inst_70973 = [inst_70972,inst_70965];
var inst_70974 = (new cljs.core.PersistentVector(null,2,(5),inst_70966,inst_70973,null));
var inst_70975 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70974);
var _ = (function (){var statearr_71003 = state_70980;
(statearr_71003[(4)] = cljs.core.rest((state_70980[(4)])));

return statearr_71003;
})();
var state_70980__$1 = (function (){var statearr_71004 = state_70980;
(statearr_71004[(9)] = inst_70975);

return statearr_71004;
})();
var statearr_71005_71032 = state_70980__$1;
(statearr_71005_71032[(2)] = inst_70963);

(statearr_71005_71032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (10))){
var state_70980__$1 = state_70980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70980__$1,(13),path);
} else {
if((state_val_70981 === (18))){
var inst_70942 = (state_70980[(7)]);
var state_70980__$1 = state_70980;
var statearr_71006_71033 = state_70980__$1;
(statearr_71006_71033[(2)] = inst_70942);

(statearr_71006_71033[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70981 === (8))){
var inst_70942 = (state_70980[(2)]);
var inst_70943 = fluree.db.util.async.channel_QMARK_(path);
var state_70980__$1 = (function (){var statearr_71007 = state_70980;
(statearr_71007[(7)] = inst_70942);

return statearr_71007;
})();
if(inst_70943){
var statearr_71008_71034 = state_70980__$1;
(statearr_71008_71034[(1)] = (10));

} else {
var statearr_71009_71035 = state_70980__$1;
(statearr_71009_71035[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0 = (function (){
var statearr_71010 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71010[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__);

(statearr_71010[(1)] = (1));

return statearr_71010;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1 = (function (state_70980){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_70980);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71011){var ex__13886__auto__ = e71011;
var statearr_71012_71036 = state_70980;
(statearr_71012_71036[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_70980[(4)]))){
var statearr_71013_71037 = state_70980;
(statearr_71013_71037[(1)] = cljs.core.first((state_70980[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71038 = state_70980;
state_70980 = G__71038;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__ = function(state_70980){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1.call(this,state_70980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71014 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71014[(6)] = c__13957__auto__);

return statearr_71014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71077){
var state_val_71078 = (state_71077[(1)]);
if((state_val_71078 === (7))){
var state_71077__$1 = state_71077;
var statearr_71079_71103 = state_71077__$1;
(statearr_71079_71103[(2)] = subject);

(statearr_71079_71103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (1))){
var state_71077__$1 = state_71077;
var statearr_71080_71104 = state_71077__$1;
(statearr_71080_71104[(2)] = null);

(statearr_71080_71104[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (4))){
var inst_71039 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
var statearr_71081_71105 = state_71077__$1;
(statearr_71081_71105[(2)] = inst_71039);

(statearr_71081_71105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (13))){
var inst_71056 = (state_71077[(2)]);
var inst_71057 = fluree.db.util.async.throw_err(inst_71056);
var state_71077__$1 = state_71077;
var statearr_71082_71106 = state_71077__$1;
(statearr_71082_71106[(2)] = inst_71057);

(statearr_71082_71106[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (6))){
var state_71077__$1 = state_71077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71077__$1,(9),subject);
} else {
if((state_val_71078 === (3))){
var inst_71075 = (state_71077[(2)]);
var state_71077__$1 = state_71077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71077__$1,inst_71075);
} else {
if((state_val_71078 === (12))){
var inst_71052 = (state_71077[(7)]);
var inst_71060 = (state_71077[(2)]);
var inst_71061 = fluree.db.dbfunctions.internal.get_in(inst_71052,inst_71060);
var inst_71062 = cljs.core.count(inst_71060);
var inst_71063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71064 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71066 = [inst_71052,inst_71060];
var inst_71067 = (new cljs.core.PersistentVector(null,2,(5),inst_71065,inst_71066,null));
var inst_71068 = ["get-in",inst_71067,inst_71061];
var inst_71069 = cljs.core.PersistentHashMap.fromArrays(inst_71064,inst_71068);
var inst_71070 = [inst_71069,inst_71062];
var inst_71071 = (new cljs.core.PersistentVector(null,2,(5),inst_71063,inst_71070,null));
var inst_71072 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71071);
var _ = (function (){var statearr_71083 = state_71077;
(statearr_71083[(4)] = cljs.core.rest((state_71077[(4)])));

return statearr_71083;
})();
var state_71077__$1 = (function (){var statearr_71084 = state_71077;
(statearr_71084[(8)] = inst_71072);

return statearr_71084;
})();
var statearr_71085_71107 = state_71077__$1;
(statearr_71085_71107[(2)] = inst_71061);

(statearr_71085_71107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (2))){
var _ = (function (){var statearr_71086 = state_71077;
(statearr_71086[(4)] = cljs.core.cons((5),(state_71077[(4)])));

return statearr_71086;
})();
var inst_71045 = fluree.db.util.async.channel_QMARK_(subject);
var state_71077__$1 = state_71077;
if(inst_71045){
var statearr_71087_71108 = state_71077__$1;
(statearr_71087_71108[(1)] = (6));

} else {
var statearr_71088_71109 = state_71077__$1;
(statearr_71088_71109[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (11))){
var state_71077__$1 = state_71077;
var statearr_71090_71110 = state_71077__$1;
(statearr_71090_71110[(2)] = path);

(statearr_71090_71110[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (9))){
var inst_71048 = (state_71077[(2)]);
var inst_71049 = fluree.db.util.async.throw_err(inst_71048);
var state_71077__$1 = state_71077;
var statearr_71091_71111 = state_71077__$1;
(statearr_71091_71111[(2)] = inst_71049);

(statearr_71091_71111[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (5))){
var _ = (function (){var statearr_71092 = state_71077;
(statearr_71092[(4)] = cljs.core.rest((state_71077[(4)])));

return statearr_71092;
})();
var state_71077__$1 = state_71077;
var ex71089 = (state_71077__$1[(2)]);
var statearr_71093_71112 = state_71077__$1;
(statearr_71093_71112[(5)] = ex71089);


if((ex71089 instanceof Error)){
var statearr_71094_71113 = state_71077__$1;
(statearr_71094_71113[(1)] = (4));

(statearr_71094_71113[(5)] = null);

} else {
throw ex71089;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71078 === (10))){
var state_71077__$1 = state_71077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71077__$1,(13),path);
} else {
if((state_val_71078 === (8))){
var inst_71052 = (state_71077[(2)]);
var inst_71053 = fluree.db.util.async.channel_QMARK_(path);
var state_71077__$1 = (function (){var statearr_71095 = state_71077;
(statearr_71095[(7)] = inst_71052);

return statearr_71095;
})();
if(inst_71053){
var statearr_71096_71114 = state_71077__$1;
(statearr_71096_71114[(1)] = (10));

} else {
var statearr_71097_71115 = state_71077__$1;
(statearr_71097_71115[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0 = (function (){
var statearr_71098 = [null,null,null,null,null,null,null,null,null];
(statearr_71098[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__);

(statearr_71098[(1)] = (1));

return statearr_71098;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1 = (function (state_71077){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71077);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71099){var ex__13886__auto__ = e71099;
var statearr_71100_71116 = state_71077;
(statearr_71100_71116[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71077[(4)]))){
var statearr_71101_71117 = state_71077;
(statearr_71101_71117[(1)] = cljs.core.first((state_71077[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71118 = state_71077;
state_71077 = G__71118;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__ = function(state_71077){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1.call(this,state_71077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71102 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71102[(6)] = c__13957__auto__);

return statearr_71102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71163){
var state_val_71164 = (state_71163[(1)]);
if((state_val_71164 === (7))){
var state_71163__$1 = state_71163;
var statearr_71165_71194 = state_71163__$1;
(statearr_71165_71194[(2)] = coll);

(statearr_71165_71194[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (1))){
var state_71163__$1 = state_71163;
var statearr_71166_71195 = state_71163__$1;
(statearr_71166_71195[(2)] = null);

(statearr_71166_71195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (4))){
var inst_71119 = (state_71163[(2)]);
var state_71163__$1 = state_71163;
var statearr_71167_71196 = state_71163__$1;
(statearr_71167_71196[(2)] = inst_71119);

(statearr_71167_71196[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (15))){
var inst_71139 = (state_71163[(7)]);
var inst_71147 = (state_71163[(2)]);
var inst_71148 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_71139,inst_71147);
var inst_71149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71150 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71152 = [inst_71139,inst_71147];
var inst_71153 = (new cljs.core.PersistentVector(null,2,(5),inst_71151,inst_71152,null));
var inst_71154 = ["contains?",inst_71153,inst_71148];
var inst_71155 = cljs.core.PersistentHashMap.fromArrays(inst_71150,inst_71154);
var inst_71156 = [inst_71155,(10)];
var inst_71157 = (new cljs.core.PersistentVector(null,2,(5),inst_71149,inst_71156,null));
var inst_71158 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71157);
var _ = (function (){var statearr_71168 = state_71163;
(statearr_71168[(4)] = cljs.core.rest((state_71163[(4)])));

return statearr_71168;
})();
var state_71163__$1 = (function (){var statearr_71169 = state_71163;
(statearr_71169[(8)] = inst_71158);

return statearr_71169;
})();
var statearr_71170_71197 = state_71163__$1;
(statearr_71170_71197[(2)] = inst_71148);

(statearr_71170_71197[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (13))){
var state_71163__$1 = state_71163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71163__$1,(16),key);
} else {
if((state_val_71164 === (6))){
var state_71163__$1 = state_71163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71163__$1,(9),coll);
} else {
if((state_val_71164 === (3))){
var inst_71161 = (state_71163[(2)]);
var state_71163__$1 = state_71163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71163__$1,inst_71161);
} else {
if((state_val_71164 === (12))){
var inst_71139 = (state_71163[(2)]);
var inst_71140 = fluree.db.util.async.channel_QMARK_(key);
var state_71163__$1 = (function (){var statearr_71171 = state_71163;
(statearr_71171[(7)] = inst_71139);

return statearr_71171;
})();
if(inst_71140){
var statearr_71172_71198 = state_71163__$1;
(statearr_71172_71198[(1)] = (13));

} else {
var statearr_71173_71199 = state_71163__$1;
(statearr_71173_71199[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (2))){
var _ = (function (){var statearr_71174 = state_71163;
(statearr_71174[(4)] = cljs.core.cons((5),(state_71163[(4)])));

return statearr_71174;
})();
var inst_71125 = fluree.db.util.async.channel_QMARK_(coll);
var state_71163__$1 = state_71163;
if(inst_71125){
var statearr_71175_71200 = state_71163__$1;
(statearr_71175_71200[(1)] = (6));

} else {
var statearr_71176_71201 = state_71163__$1;
(statearr_71176_71201[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (11))){
var inst_71132 = (state_71163[(9)]);
var inst_71136 = cljs.core.flatten(inst_71132);
var inst_71137 = cljs.core.set(inst_71136);
var state_71163__$1 = state_71163;
var statearr_71178_71202 = state_71163__$1;
(statearr_71178_71202[(2)] = inst_71137);

(statearr_71178_71202[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (9))){
var inst_71128 = (state_71163[(2)]);
var inst_71129 = fluree.db.util.async.throw_err(inst_71128);
var state_71163__$1 = state_71163;
var statearr_71179_71203 = state_71163__$1;
(statearr_71179_71203[(2)] = inst_71129);

(statearr_71179_71203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (5))){
var _ = (function (){var statearr_71180 = state_71163;
(statearr_71180[(4)] = cljs.core.rest((state_71163[(4)])));

return statearr_71180;
})();
var state_71163__$1 = state_71163;
var ex71177 = (state_71163__$1[(2)]);
var statearr_71181_71204 = state_71163__$1;
(statearr_71181_71204[(5)] = ex71177);


if((ex71177 instanceof Error)){
var statearr_71182_71205 = state_71163__$1;
(statearr_71182_71205[(1)] = (4));

(statearr_71182_71205[(5)] = null);

} else {
throw ex71177;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (14))){
var state_71163__$1 = state_71163;
var statearr_71183_71206 = state_71163__$1;
(statearr_71183_71206[(2)] = key);

(statearr_71183_71206[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (16))){
var inst_71143 = (state_71163[(2)]);
var inst_71144 = fluree.db.util.async.throw_err(inst_71143);
var state_71163__$1 = state_71163;
var statearr_71184_71207 = state_71163__$1;
(statearr_71184_71207[(2)] = inst_71144);

(statearr_71184_71207[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (10))){
var inst_71132 = (state_71163[(9)]);
var state_71163__$1 = state_71163;
var statearr_71185_71208 = state_71163__$1;
(statearr_71185_71208[(2)] = inst_71132);

(statearr_71185_71208[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71164 === (8))){
var inst_71132 = (state_71163[(9)]);
var inst_71132__$1 = (state_71163[(2)]);
var inst_71133 = cljs.core.set_QMARK_(inst_71132__$1);
var state_71163__$1 = (function (){var statearr_71186 = state_71163;
(statearr_71186[(9)] = inst_71132__$1);

return statearr_71186;
})();
if(inst_71133){
var statearr_71187_71209 = state_71163__$1;
(statearr_71187_71209[(1)] = (10));

} else {
var statearr_71188_71210 = state_71163__$1;
(statearr_71188_71210[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_71189 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71189[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__);

(statearr_71189[(1)] = (1));

return statearr_71189;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1 = (function (state_71163){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71163);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71190){var ex__13886__auto__ = e71190;
var statearr_71191_71211 = state_71163;
(statearr_71191_71211[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71163[(4)]))){
var statearr_71192_71212 = state_71163;
(statearr_71192_71212[(1)] = cljs.core.first((state_71163[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71213 = state_71163;
state_71163 = G__71213;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__ = function(state_71163){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1.call(this,state_71163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71193 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71193[(6)] = c__13957__auto__);

return statearr_71193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71278 = arguments.length;
var i__4772__auto___71279 = (0);
while(true){
if((i__4772__auto___71279 < len__4771__auto___71278)){
args__4777__auto__.push((arguments[i__4772__auto___71279]));

var G__71280 = (i__4772__auto___71279 + (1));
i__4772__auto___71279 = G__71280;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71256){
var state_val_71257 = (state_71256[(1)]);
if((state_val_71257 === (7))){
var inst_71225 = (state_71256[(7)]);
var inst_71232 = cljs.core.first(inst_71225);
var state_71256__$1 = state_71256;
var statearr_71258_71281 = state_71256__$1;
(statearr_71258_71281[(2)] = inst_71232);

(statearr_71258_71281[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (1))){
var state_71256__$1 = state_71256;
var statearr_71259_71282 = state_71256__$1;
(statearr_71259_71282[(2)] = null);

(statearr_71259_71282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (4))){
var inst_71216 = (state_71256[(2)]);
var state_71256__$1 = state_71256;
var statearr_71260_71283 = state_71256__$1;
(statearr_71260_71283[(2)] = inst_71216);

(statearr_71260_71283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (6))){
var inst_71225 = (state_71256[(7)]);
var inst_71224 = (state_71256[(2)]);
var inst_71225__$1 = fluree.db.util.async.throw_err(inst_71224);
var inst_71226 = cljs.core.count(inst_71225__$1);
var inst_71227 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71226);
var inst_71228 = cljs.core.first(inst_71225__$1);
var inst_71229 = cljs.core.coll_QMARK_(inst_71228);
var inst_71230 = ((inst_71227) && (inst_71229));
var state_71256__$1 = (function (){var statearr_71261 = state_71256;
(statearr_71261[(7)] = inst_71225__$1);

return statearr_71261;
})();
if(cljs.core.truth_(inst_71230)){
var statearr_71262_71284 = state_71256__$1;
(statearr_71262_71284[(1)] = (7));

} else {
var statearr_71263_71285 = state_71256__$1;
(statearr_71263_71285[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (3))){
var inst_71254 = (state_71256[(2)]);
var state_71256__$1 = state_71256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71256__$1,inst_71254);
} else {
if((state_val_71257 === (2))){
var _ = (function (){var statearr_71265 = state_71256;
(statearr_71265[(4)] = cljs.core.cons((5),(state_71256[(4)])));

return statearr_71265;
})();
var inst_71222 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71256__$1 = state_71256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71256__$1,(6),inst_71222);
} else {
if((state_val_71257 === (9))){
var inst_71235 = (state_71256[(2)]);
var inst_71236 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_71235);
var inst_71237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71238 = [inst_71235];
var inst_71239 = (new cljs.core.PersistentVector(null,1,(5),inst_71237,inst_71238,null));
var inst_71240 = cljs.core.count(inst_71239);
var inst_71241 = ((9) + inst_71240);
var inst_71242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71243 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71245 = [inst_71235];
var inst_71246 = (new cljs.core.PersistentVector(null,1,(5),inst_71244,inst_71245,null));
var inst_71247 = ["hash-set",inst_71246,inst_71236];
var inst_71248 = cljs.core.PersistentHashMap.fromArrays(inst_71243,inst_71247);
var inst_71249 = [inst_71248,inst_71241];
var inst_71250 = (new cljs.core.PersistentVector(null,2,(5),inst_71242,inst_71249,null));
var inst_71251 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71250);
var _ = (function (){var statearr_71266 = state_71256;
(statearr_71266[(4)] = cljs.core.rest((state_71256[(4)])));

return statearr_71266;
})();
var state_71256__$1 = (function (){var statearr_71267 = state_71256;
(statearr_71267[(8)] = inst_71251);

return statearr_71267;
})();
var statearr_71268_71286 = state_71256__$1;
(statearr_71268_71286[(2)] = inst_71236);

(statearr_71268_71286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (5))){
var _ = (function (){var statearr_71269 = state_71256;
(statearr_71269[(4)] = cljs.core.rest((state_71256[(4)])));

return statearr_71269;
})();
var state_71256__$1 = state_71256;
var ex71264 = (state_71256__$1[(2)]);
var statearr_71270_71287 = state_71256__$1;
(statearr_71270_71287[(5)] = ex71264);


if((ex71264 instanceof Error)){
var statearr_71271_71288 = state_71256__$1;
(statearr_71271_71288[(1)] = (4));

(statearr_71271_71288[(5)] = null);

} else {
throw ex71264;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71257 === (8))){
var inst_71225 = (state_71256[(7)]);
var state_71256__$1 = state_71256;
var statearr_71272_71289 = state_71256__$1;
(statearr_71272_71289[(2)] = inst_71225);

(statearr_71272_71289[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71273 = [null,null,null,null,null,null,null,null,null];
(statearr_71273[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71273[(1)] = (1));

return statearr_71273;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71256){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71256);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71274){var ex__13886__auto__ = e71274;
var statearr_71275_71290 = state_71256;
(statearr_71275_71290[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71256[(4)]))){
var statearr_71276_71291 = state_71256;
(statearr_71276_71291[(1)] = cljs.core.first((state_71256[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71292 = state_71256;
state_71256 = G__71292;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71256){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71277 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71277[(6)] = c__13957__auto__);

return statearr_71277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq71214){
var G__71215 = cljs.core.first(seq71214);
var seq71214__$1 = cljs.core.next(seq71214);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71215,seq71214__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71342 = arguments.length;
var i__4772__auto___71343 = (0);
while(true){
if((i__4772__auto___71343 < len__4771__auto___71342)){
args__4777__auto__.push((arguments[i__4772__auto___71343]));

var G__71344 = (i__4772__auto___71343 + (1));
i__4772__auto___71343 = G__71344;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71325){
var state_val_71326 = (state_71325[(1)]);
if((state_val_71326 === (1))){
var state_71325__$1 = state_71325;
var statearr_71327_71345 = state_71325__$1;
(statearr_71327_71345[(2)] = null);

(statearr_71327_71345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71326 === (2))){
var _ = (function (){var statearr_71328 = state_71325;
(statearr_71328[(4)] = cljs.core.cons((5),(state_71325[(4)])));

return statearr_71328;
})();
var inst_71301 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71325__$1 = state_71325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71325__$1,(6),inst_71301);
} else {
if((state_val_71326 === (3))){
var inst_71323 = (state_71325[(2)]);
var state_71325__$1 = state_71325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71325__$1,inst_71323);
} else {
if((state_val_71326 === (4))){
var inst_71295 = (state_71325[(2)]);
var state_71325__$1 = state_71325;
var statearr_71330_71346 = state_71325__$1;
(statearr_71330_71346[(2)] = inst_71295);

(statearr_71330_71346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71326 === (5))){
var _ = (function (){var statearr_71331 = state_71325;
(statearr_71331[(4)] = cljs.core.rest((state_71325[(4)])));

return statearr_71331;
})();
var state_71325__$1 = state_71325;
var ex71329 = (state_71325__$1[(2)]);
var statearr_71332_71347 = state_71325__$1;
(statearr_71332_71347[(5)] = ex71329);


if((ex71329 instanceof Error)){
var statearr_71333_71348 = state_71325__$1;
(statearr_71333_71348[(1)] = (4));

(statearr_71333_71348[(5)] = null);

} else {
throw ex71329;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71326 === (6))){
var inst_71303 = (state_71325[(2)]);
var inst_71304 = fluree.db.util.async.throw_err(inst_71303);
var inst_71305 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_71304);
var inst_71306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71307 = [inst_71304];
var inst_71308 = (new cljs.core.PersistentVector(null,1,(5),inst_71306,inst_71307,null));
var inst_71309 = cljs.core.count(inst_71308);
var inst_71310 = ((9) + inst_71309);
var inst_71311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71312 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71314 = [inst_71304];
var inst_71315 = (new cljs.core.PersistentVector(null,1,(5),inst_71313,inst_71314,null));
var inst_71316 = ["==",inst_71315,inst_71305];
var inst_71317 = cljs.core.PersistentHashMap.fromArrays(inst_71312,inst_71316);
var inst_71318 = [inst_71317,inst_71310];
var inst_71319 = (new cljs.core.PersistentVector(null,2,(5),inst_71311,inst_71318,null));
var inst_71320 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71319);
var _ = (function (){var statearr_71334 = state_71325;
(statearr_71334[(4)] = cljs.core.rest((state_71325[(4)])));

return statearr_71334;
})();
var state_71325__$1 = (function (){var statearr_71335 = state_71325;
(statearr_71335[(7)] = inst_71320);

return statearr_71335;
})();
var statearr_71336_71349 = state_71325__$1;
(statearr_71336_71349[(2)] = inst_71305);

(statearr_71336_71349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71337 = [null,null,null,null,null,null,null,null];
(statearr_71337[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71337[(1)] = (1));

return statearr_71337;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71325){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71325);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71338){var ex__13886__auto__ = e71338;
var statearr_71339_71350 = state_71325;
(statearr_71339_71350[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71325[(4)]))){
var statearr_71340_71351 = state_71325;
(statearr_71340_71351[(1)] = cljs.core.first((state_71325[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71352 = state_71325;
state_71325 = G__71352;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71325){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71341 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71341[(6)] = c__13957__auto__);

return statearr_71341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq71293){
var G__71294 = cljs.core.first(seq71293);
var seq71293__$1 = cljs.core.next(seq71293);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71294,seq71293__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71402 = arguments.length;
var i__4772__auto___71403 = (0);
while(true){
if((i__4772__auto___71403 < len__4771__auto___71402)){
args__4777__auto__.push((arguments[i__4772__auto___71403]));

var G__71404 = (i__4772__auto___71403 + (1));
i__4772__auto___71403 = G__71404;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71385){
var state_val_71386 = (state_71385[(1)]);
if((state_val_71386 === (1))){
var state_71385__$1 = state_71385;
var statearr_71387_71405 = state_71385__$1;
(statearr_71387_71405[(2)] = null);

(statearr_71387_71405[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71386 === (2))){
var _ = (function (){var statearr_71388 = state_71385;
(statearr_71388[(4)] = cljs.core.cons((5),(state_71385[(4)])));

return statearr_71388;
})();
var inst_71361 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71385__$1 = state_71385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71385__$1,(6),inst_71361);
} else {
if((state_val_71386 === (3))){
var inst_71383 = (state_71385[(2)]);
var state_71385__$1 = state_71385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71385__$1,inst_71383);
} else {
if((state_val_71386 === (4))){
var inst_71355 = (state_71385[(2)]);
var state_71385__$1 = state_71385;
var statearr_71390_71406 = state_71385__$1;
(statearr_71390_71406[(2)] = inst_71355);

(statearr_71390_71406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71386 === (5))){
var _ = (function (){var statearr_71391 = state_71385;
(statearr_71391[(4)] = cljs.core.rest((state_71385[(4)])));

return statearr_71391;
})();
var state_71385__$1 = state_71385;
var ex71389 = (state_71385__$1[(2)]);
var statearr_71392_71407 = state_71385__$1;
(statearr_71392_71407[(5)] = ex71389);


if((ex71389 instanceof Error)){
var statearr_71393_71408 = state_71385__$1;
(statearr_71393_71408[(1)] = (4));

(statearr_71393_71408[(5)] = null);

} else {
throw ex71389;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71386 === (6))){
var inst_71363 = (state_71385[(2)]);
var inst_71364 = fluree.db.util.async.throw_err(inst_71363);
var inst_71365 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_71364);
var inst_71366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71367 = [inst_71364];
var inst_71368 = (new cljs.core.PersistentVector(null,1,(5),inst_71366,inst_71367,null));
var inst_71369 = cljs.core.count(inst_71368);
var inst_71370 = ((9) + inst_71369);
var inst_71371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71372 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71374 = [inst_71364];
var inst_71375 = (new cljs.core.PersistentVector(null,1,(5),inst_71373,inst_71374,null));
var inst_71376 = [">",inst_71375,inst_71365];
var inst_71377 = cljs.core.PersistentHashMap.fromArrays(inst_71372,inst_71376);
var inst_71378 = [inst_71377,inst_71370];
var inst_71379 = (new cljs.core.PersistentVector(null,2,(5),inst_71371,inst_71378,null));
var inst_71380 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71379);
var _ = (function (){var statearr_71394 = state_71385;
(statearr_71394[(4)] = cljs.core.rest((state_71385[(4)])));

return statearr_71394;
})();
var state_71385__$1 = (function (){var statearr_71395 = state_71385;
(statearr_71395[(7)] = inst_71380);

return statearr_71395;
})();
var statearr_71396_71409 = state_71385__$1;
(statearr_71396_71409[(2)] = inst_71365);

(statearr_71396_71409[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71397 = [null,null,null,null,null,null,null,null];
(statearr_71397[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71397[(1)] = (1));

return statearr_71397;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71385){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71385);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71398){var ex__13886__auto__ = e71398;
var statearr_71399_71410 = state_71385;
(statearr_71399_71410[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71385[(4)]))){
var statearr_71400_71411 = state_71385;
(statearr_71400_71411[(1)] = cljs.core.first((state_71385[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71412 = state_71385;
state_71385 = G__71412;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71385){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71401 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71401[(6)] = c__13957__auto__);

return statearr_71401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq71353){
var G__71354 = cljs.core.first(seq71353);
var seq71353__$1 = cljs.core.next(seq71353);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71354,seq71353__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71462 = arguments.length;
var i__4772__auto___71463 = (0);
while(true){
if((i__4772__auto___71463 < len__4771__auto___71462)){
args__4777__auto__.push((arguments[i__4772__auto___71463]));

var G__71464 = (i__4772__auto___71463 + (1));
i__4772__auto___71463 = G__71464;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71445){
var state_val_71446 = (state_71445[(1)]);
if((state_val_71446 === (1))){
var state_71445__$1 = state_71445;
var statearr_71447_71465 = state_71445__$1;
(statearr_71447_71465[(2)] = null);

(statearr_71447_71465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71446 === (2))){
var _ = (function (){var statearr_71448 = state_71445;
(statearr_71448[(4)] = cljs.core.cons((5),(state_71445[(4)])));

return statearr_71448;
})();
var inst_71421 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71445__$1 = state_71445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71445__$1,(6),inst_71421);
} else {
if((state_val_71446 === (3))){
var inst_71443 = (state_71445[(2)]);
var state_71445__$1 = state_71445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71445__$1,inst_71443);
} else {
if((state_val_71446 === (4))){
var inst_71415 = (state_71445[(2)]);
var state_71445__$1 = state_71445;
var statearr_71450_71466 = state_71445__$1;
(statearr_71450_71466[(2)] = inst_71415);

(statearr_71450_71466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71446 === (5))){
var _ = (function (){var statearr_71451 = state_71445;
(statearr_71451[(4)] = cljs.core.rest((state_71445[(4)])));

return statearr_71451;
})();
var state_71445__$1 = state_71445;
var ex71449 = (state_71445__$1[(2)]);
var statearr_71452_71467 = state_71445__$1;
(statearr_71452_71467[(5)] = ex71449);


if((ex71449 instanceof Error)){
var statearr_71453_71468 = state_71445__$1;
(statearr_71453_71468[(1)] = (4));

(statearr_71453_71468[(5)] = null);

} else {
throw ex71449;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71446 === (6))){
var inst_71423 = (state_71445[(2)]);
var inst_71424 = fluree.db.util.async.throw_err(inst_71423);
var inst_71425 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_71424);
var inst_71426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71427 = [inst_71424];
var inst_71428 = (new cljs.core.PersistentVector(null,1,(5),inst_71426,inst_71427,null));
var inst_71429 = cljs.core.count(inst_71428);
var inst_71430 = ((9) + inst_71429);
var inst_71431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71432 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71434 = [inst_71424];
var inst_71435 = (new cljs.core.PersistentVector(null,1,(5),inst_71433,inst_71434,null));
var inst_71436 = ["<",inst_71435,inst_71425];
var inst_71437 = cljs.core.PersistentHashMap.fromArrays(inst_71432,inst_71436);
var inst_71438 = [inst_71437,inst_71430];
var inst_71439 = (new cljs.core.PersistentVector(null,2,(5),inst_71431,inst_71438,null));
var inst_71440 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71439);
var _ = (function (){var statearr_71454 = state_71445;
(statearr_71454[(4)] = cljs.core.rest((state_71445[(4)])));

return statearr_71454;
})();
var state_71445__$1 = (function (){var statearr_71455 = state_71445;
(statearr_71455[(7)] = inst_71440);

return statearr_71455;
})();
var statearr_71456_71469 = state_71445__$1;
(statearr_71456_71469[(2)] = inst_71425);

(statearr_71456_71469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71457 = [null,null,null,null,null,null,null,null];
(statearr_71457[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71457[(1)] = (1));

return statearr_71457;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71445){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71445);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71458){var ex__13886__auto__ = e71458;
var statearr_71459_71470 = state_71445;
(statearr_71459_71470[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71445[(4)]))){
var statearr_71460_71471 = state_71445;
(statearr_71460_71471[(1)] = cljs.core.first((state_71445[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71472 = state_71445;
state_71445 = G__71472;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71445){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71461 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71461[(6)] = c__13957__auto__);

return statearr_71461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq71413){
var G__71414 = cljs.core.first(seq71413);
var seq71413__$1 = cljs.core.next(seq71413);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71414,seq71413__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71522 = arguments.length;
var i__4772__auto___71523 = (0);
while(true){
if((i__4772__auto___71523 < len__4771__auto___71522)){
args__4777__auto__.push((arguments[i__4772__auto___71523]));

var G__71524 = (i__4772__auto___71523 + (1));
i__4772__auto___71523 = G__71524;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71505){
var state_val_71506 = (state_71505[(1)]);
if((state_val_71506 === (1))){
var state_71505__$1 = state_71505;
var statearr_71507_71525 = state_71505__$1;
(statearr_71507_71525[(2)] = null);

(statearr_71507_71525[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71506 === (2))){
var _ = (function (){var statearr_71508 = state_71505;
(statearr_71508[(4)] = cljs.core.cons((5),(state_71505[(4)])));

return statearr_71508;
})();
var inst_71481 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71505__$1 = state_71505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71505__$1,(6),inst_71481);
} else {
if((state_val_71506 === (3))){
var inst_71503 = (state_71505[(2)]);
var state_71505__$1 = state_71505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71505__$1,inst_71503);
} else {
if((state_val_71506 === (4))){
var inst_71475 = (state_71505[(2)]);
var state_71505__$1 = state_71505;
var statearr_71510_71526 = state_71505__$1;
(statearr_71510_71526[(2)] = inst_71475);

(statearr_71510_71526[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71506 === (5))){
var _ = (function (){var statearr_71511 = state_71505;
(statearr_71511[(4)] = cljs.core.rest((state_71505[(4)])));

return statearr_71511;
})();
var state_71505__$1 = state_71505;
var ex71509 = (state_71505__$1[(2)]);
var statearr_71512_71527 = state_71505__$1;
(statearr_71512_71527[(5)] = ex71509);


if((ex71509 instanceof Error)){
var statearr_71513_71528 = state_71505__$1;
(statearr_71513_71528[(1)] = (4));

(statearr_71513_71528[(5)] = null);

} else {
throw ex71509;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71506 === (6))){
var inst_71483 = (state_71505[(2)]);
var inst_71484 = fluree.db.util.async.throw_err(inst_71483);
var inst_71485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_71484);
var inst_71486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71487 = [inst_71484];
var inst_71488 = (new cljs.core.PersistentVector(null,1,(5),inst_71486,inst_71487,null));
var inst_71489 = cljs.core.count(inst_71488);
var inst_71490 = ((9) + inst_71489);
var inst_71491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71492 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71494 = [inst_71484];
var inst_71495 = (new cljs.core.PersistentVector(null,1,(5),inst_71493,inst_71494,null));
var inst_71496 = ["<=",inst_71495,inst_71485];
var inst_71497 = cljs.core.PersistentHashMap.fromArrays(inst_71492,inst_71496);
var inst_71498 = [inst_71497,inst_71490];
var inst_71499 = (new cljs.core.PersistentVector(null,2,(5),inst_71491,inst_71498,null));
var inst_71500 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71499);
var _ = (function (){var statearr_71514 = state_71505;
(statearr_71514[(4)] = cljs.core.rest((state_71505[(4)])));

return statearr_71514;
})();
var state_71505__$1 = (function (){var statearr_71515 = state_71505;
(statearr_71515[(7)] = inst_71500);

return statearr_71515;
})();
var statearr_71516_71529 = state_71505__$1;
(statearr_71516_71529[(2)] = inst_71485);

(statearr_71516_71529[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71517 = [null,null,null,null,null,null,null,null];
(statearr_71517[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71517[(1)] = (1));

return statearr_71517;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71505){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71505);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71518){var ex__13886__auto__ = e71518;
var statearr_71519_71530 = state_71505;
(statearr_71519_71530[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71505[(4)]))){
var statearr_71520_71531 = state_71505;
(statearr_71520_71531[(1)] = cljs.core.first((state_71505[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71532 = state_71505;
state_71505 = G__71532;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71505){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71521 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71521[(6)] = c__13957__auto__);

return statearr_71521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq71473){
var G__71474 = cljs.core.first(seq71473);
var seq71473__$1 = cljs.core.next(seq71473);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71474,seq71473__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71582 = arguments.length;
var i__4772__auto___71583 = (0);
while(true){
if((i__4772__auto___71583 < len__4771__auto___71582)){
args__4777__auto__.push((arguments[i__4772__auto___71583]));

var G__71584 = (i__4772__auto___71583 + (1));
i__4772__auto___71583 = G__71584;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71565){
var state_val_71566 = (state_71565[(1)]);
if((state_val_71566 === (1))){
var state_71565__$1 = state_71565;
var statearr_71567_71585 = state_71565__$1;
(statearr_71567_71585[(2)] = null);

(statearr_71567_71585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71566 === (2))){
var _ = (function (){var statearr_71568 = state_71565;
(statearr_71568[(4)] = cljs.core.cons((5),(state_71565[(4)])));

return statearr_71568;
})();
var inst_71541 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71565__$1 = state_71565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71565__$1,(6),inst_71541);
} else {
if((state_val_71566 === (3))){
var inst_71563 = (state_71565[(2)]);
var state_71565__$1 = state_71565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71565__$1,inst_71563);
} else {
if((state_val_71566 === (4))){
var inst_71535 = (state_71565[(2)]);
var state_71565__$1 = state_71565;
var statearr_71570_71586 = state_71565__$1;
(statearr_71570_71586[(2)] = inst_71535);

(statearr_71570_71586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71566 === (5))){
var _ = (function (){var statearr_71571 = state_71565;
(statearr_71571[(4)] = cljs.core.rest((state_71565[(4)])));

return statearr_71571;
})();
var state_71565__$1 = state_71565;
var ex71569 = (state_71565__$1[(2)]);
var statearr_71572_71587 = state_71565__$1;
(statearr_71572_71587[(5)] = ex71569);


if((ex71569 instanceof Error)){
var statearr_71573_71588 = state_71565__$1;
(statearr_71573_71588[(1)] = (4));

(statearr_71573_71588[(5)] = null);

} else {
throw ex71569;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71566 === (6))){
var inst_71543 = (state_71565[(2)]);
var inst_71544 = fluree.db.util.async.throw_err(inst_71543);
var inst_71545 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_71544);
var inst_71546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71547 = [inst_71544];
var inst_71548 = (new cljs.core.PersistentVector(null,1,(5),inst_71546,inst_71547,null));
var inst_71549 = cljs.core.count(inst_71548);
var inst_71550 = ((9) + inst_71549);
var inst_71551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71552 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71554 = [inst_71544];
var inst_71555 = (new cljs.core.PersistentVector(null,1,(5),inst_71553,inst_71554,null));
var inst_71556 = [">=",inst_71555,inst_71545];
var inst_71557 = cljs.core.PersistentHashMap.fromArrays(inst_71552,inst_71556);
var inst_71558 = [inst_71557,inst_71550];
var inst_71559 = (new cljs.core.PersistentVector(null,2,(5),inst_71551,inst_71558,null));
var inst_71560 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71559);
var _ = (function (){var statearr_71574 = state_71565;
(statearr_71574[(4)] = cljs.core.rest((state_71565[(4)])));

return statearr_71574;
})();
var state_71565__$1 = (function (){var statearr_71575 = state_71565;
(statearr_71575[(7)] = inst_71560);

return statearr_71575;
})();
var statearr_71576_71589 = state_71565__$1;
(statearr_71576_71589[(2)] = inst_71545);

(statearr_71576_71589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71577 = [null,null,null,null,null,null,null,null];
(statearr_71577[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71577[(1)] = (1));

return statearr_71577;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71565){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71565);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71578){var ex__13886__auto__ = e71578;
var statearr_71579_71590 = state_71565;
(statearr_71579_71590[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71565[(4)]))){
var statearr_71580_71591 = state_71565;
(statearr_71580_71591[(1)] = cljs.core.first((state_71565[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71592 = state_71565;
state_71565 = G__71592;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71565){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71581 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71581[(6)] = c__13957__auto__);

return statearr_71581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq71533){
var G__71534 = cljs.core.first(seq71533);
var seq71533__$1 = cljs.core.next(seq71533);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71534,seq71533__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71642 = arguments.length;
var i__4772__auto___71643 = (0);
while(true){
if((i__4772__auto___71643 < len__4771__auto___71642)){
args__4777__auto__.push((arguments[i__4772__auto___71643]));

var G__71644 = (i__4772__auto___71643 + (1));
i__4772__auto___71643 = G__71644;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71625){
var state_val_71626 = (state_71625[(1)]);
if((state_val_71626 === (1))){
var state_71625__$1 = state_71625;
var statearr_71627_71645 = state_71625__$1;
(statearr_71627_71645[(2)] = null);

(statearr_71627_71645[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71626 === (2))){
var _ = (function (){var statearr_71628 = state_71625;
(statearr_71628[(4)] = cljs.core.cons((5),(state_71625[(4)])));

return statearr_71628;
})();
var inst_71601 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71625__$1,(6),inst_71601);
} else {
if((state_val_71626 === (3))){
var inst_71623 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71625__$1,inst_71623);
} else {
if((state_val_71626 === (4))){
var inst_71595 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
var statearr_71630_71646 = state_71625__$1;
(statearr_71630_71646[(2)] = inst_71595);

(statearr_71630_71646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71626 === (5))){
var _ = (function (){var statearr_71631 = state_71625;
(statearr_71631[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71631;
})();
var state_71625__$1 = state_71625;
var ex71629 = (state_71625__$1[(2)]);
var statearr_71632_71647 = state_71625__$1;
(statearr_71632_71647[(5)] = ex71629);


if((ex71629 instanceof Error)){
var statearr_71633_71648 = state_71625__$1;
(statearr_71633_71648[(1)] = (4));

(statearr_71633_71648[(5)] = null);

} else {
throw ex71629;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71626 === (6))){
var inst_71603 = (state_71625[(2)]);
var inst_71604 = fluree.db.util.async.throw_err(inst_71603);
var inst_71605 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_71604);
var inst_71606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71607 = [inst_71604];
var inst_71608 = (new cljs.core.PersistentVector(null,1,(5),inst_71606,inst_71607,null));
var inst_71609 = cljs.core.count(inst_71608);
var inst_71610 = ((9) + inst_71609);
var inst_71611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71612 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71614 = [inst_71604];
var inst_71615 = (new cljs.core.PersistentVector(null,1,(5),inst_71613,inst_71614,null));
var inst_71616 = ["not=",inst_71615,inst_71605];
var inst_71617 = cljs.core.PersistentHashMap.fromArrays(inst_71612,inst_71616);
var inst_71618 = [inst_71617,inst_71610];
var inst_71619 = (new cljs.core.PersistentVector(null,2,(5),inst_71611,inst_71618,null));
var inst_71620 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71619);
var _ = (function (){var statearr_71634 = state_71625;
(statearr_71634[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71634;
})();
var state_71625__$1 = (function (){var statearr_71635 = state_71625;
(statearr_71635[(7)] = inst_71620);

return statearr_71635;
})();
var statearr_71636_71649 = state_71625__$1;
(statearr_71636_71649[(2)] = inst_71605);

(statearr_71636_71649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71637 = [null,null,null,null,null,null,null,null];
(statearr_71637[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71637[(1)] = (1));

return statearr_71637;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71625){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71625);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71638){var ex__13886__auto__ = e71638;
var statearr_71639_71650 = state_71625;
(statearr_71639_71650[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71625[(4)]))){
var statearr_71640_71651 = state_71625;
(statearr_71640_71651[(1)] = cljs.core.first((state_71625[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71652 = state_71625;
state_71625 = G__71652;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71625){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71641 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71641[(6)] = c__13957__auto__);

return statearr_71641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq71593){
var G__71594 = cljs.core.first(seq71593);
var seq71593__$1 = cljs.core.next(seq71593);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71594,seq71593__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71702 = arguments.length;
var i__4772__auto___71703 = (0);
while(true){
if((i__4772__auto___71703 < len__4771__auto___71702)){
args__4777__auto__.push((arguments[i__4772__auto___71703]));

var G__71704 = (i__4772__auto___71703 + (1));
i__4772__auto___71703 = G__71704;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71685){
var state_val_71686 = (state_71685[(1)]);
if((state_val_71686 === (1))){
var state_71685__$1 = state_71685;
var statearr_71687_71705 = state_71685__$1;
(statearr_71687_71705[(2)] = null);

(statearr_71687_71705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71686 === (2))){
var _ = (function (){var statearr_71688 = state_71685;
(statearr_71688[(4)] = cljs.core.cons((5),(state_71685[(4)])));

return statearr_71688;
})();
var inst_71661 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71685__$1 = state_71685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71685__$1,(6),inst_71661);
} else {
if((state_val_71686 === (3))){
var inst_71683 = (state_71685[(2)]);
var state_71685__$1 = state_71685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71685__$1,inst_71683);
} else {
if((state_val_71686 === (4))){
var inst_71655 = (state_71685[(2)]);
var state_71685__$1 = state_71685;
var statearr_71690_71706 = state_71685__$1;
(statearr_71690_71706[(2)] = inst_71655);

(statearr_71690_71706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71686 === (5))){
var _ = (function (){var statearr_71691 = state_71685;
(statearr_71691[(4)] = cljs.core.rest((state_71685[(4)])));

return statearr_71691;
})();
var state_71685__$1 = state_71685;
var ex71689 = (state_71685__$1[(2)]);
var statearr_71692_71707 = state_71685__$1;
(statearr_71692_71707[(5)] = ex71689);


if((ex71689 instanceof Error)){
var statearr_71693_71708 = state_71685__$1;
(statearr_71693_71708[(1)] = (4));

(statearr_71693_71708[(5)] = null);

} else {
throw ex71689;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71686 === (6))){
var inst_71663 = (state_71685[(2)]);
var inst_71664 = fluree.db.util.async.throw_err(inst_71663);
var inst_71665 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_71664);
var inst_71666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71667 = [inst_71664];
var inst_71668 = (new cljs.core.PersistentVector(null,1,(5),inst_71666,inst_71667,null));
var inst_71669 = cljs.core.count(inst_71668);
var inst_71670 = ((9) + inst_71669);
var inst_71671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71672 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71674 = [inst_71664];
var inst_71675 = (new cljs.core.PersistentVector(null,1,(5),inst_71673,inst_71674,null));
var inst_71676 = ["max",inst_71675,inst_71665];
var inst_71677 = cljs.core.PersistentHashMap.fromArrays(inst_71672,inst_71676);
var inst_71678 = [inst_71677,inst_71670];
var inst_71679 = (new cljs.core.PersistentVector(null,2,(5),inst_71671,inst_71678,null));
var inst_71680 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71679);
var _ = (function (){var statearr_71694 = state_71685;
(statearr_71694[(4)] = cljs.core.rest((state_71685[(4)])));

return statearr_71694;
})();
var state_71685__$1 = (function (){var statearr_71695 = state_71685;
(statearr_71695[(7)] = inst_71680);

return statearr_71695;
})();
var statearr_71696_71709 = state_71685__$1;
(statearr_71696_71709[(2)] = inst_71665);

(statearr_71696_71709[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71697 = [null,null,null,null,null,null,null,null];
(statearr_71697[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71697[(1)] = (1));

return statearr_71697;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71685){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71685);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71698){var ex__13886__auto__ = e71698;
var statearr_71699_71710 = state_71685;
(statearr_71699_71710[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71685[(4)]))){
var statearr_71700_71711 = state_71685;
(statearr_71700_71711[(1)] = cljs.core.first((state_71685[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71712 = state_71685;
state_71685 = G__71712;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71685){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71701 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71701[(6)] = c__13957__auto__);

return statearr_71701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq71653){
var G__71654 = cljs.core.first(seq71653);
var seq71653__$1 = cljs.core.next(seq71653);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71654,seq71653__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4777__auto__ = [];
var len__4771__auto___71762 = arguments.length;
var i__4772__auto___71763 = (0);
while(true){
if((i__4772__auto___71763 < len__4771__auto___71762)){
args__4777__auto__.push((arguments[i__4772__auto___71763]));

var G__71764 = (i__4772__auto___71763 + (1));
i__4772__auto___71763 = G__71764;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71745){
var state_val_71746 = (state_71745[(1)]);
if((state_val_71746 === (1))){
var state_71745__$1 = state_71745;
var statearr_71747_71765 = state_71745__$1;
(statearr_71747_71765[(2)] = null);

(statearr_71747_71765[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71746 === (2))){
var _ = (function (){var statearr_71748 = state_71745;
(statearr_71748[(4)] = cljs.core.cons((5),(state_71745[(4)])));

return statearr_71748;
})();
var inst_71721 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71745__$1 = state_71745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71745__$1,(6),inst_71721);
} else {
if((state_val_71746 === (3))){
var inst_71743 = (state_71745[(2)]);
var state_71745__$1 = state_71745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71745__$1,inst_71743);
} else {
if((state_val_71746 === (4))){
var inst_71715 = (state_71745[(2)]);
var state_71745__$1 = state_71745;
var statearr_71750_71766 = state_71745__$1;
(statearr_71750_71766[(2)] = inst_71715);

(statearr_71750_71766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71746 === (5))){
var _ = (function (){var statearr_71751 = state_71745;
(statearr_71751[(4)] = cljs.core.rest((state_71745[(4)])));

return statearr_71751;
})();
var state_71745__$1 = state_71745;
var ex71749 = (state_71745__$1[(2)]);
var statearr_71752_71767 = state_71745__$1;
(statearr_71752_71767[(5)] = ex71749);


if((ex71749 instanceof Error)){
var statearr_71753_71768 = state_71745__$1;
(statearr_71753_71768[(1)] = (4));

(statearr_71753_71768[(5)] = null);

} else {
throw ex71749;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71746 === (6))){
var inst_71723 = (state_71745[(2)]);
var inst_71724 = fluree.db.util.async.throw_err(inst_71723);
var inst_71725 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_71724);
var inst_71726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71727 = [inst_71724];
var inst_71728 = (new cljs.core.PersistentVector(null,1,(5),inst_71726,inst_71727,null));
var inst_71729 = cljs.core.count(inst_71728);
var inst_71730 = ((9) + inst_71729);
var inst_71731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71732 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71734 = [inst_71724];
var inst_71735 = (new cljs.core.PersistentVector(null,1,(5),inst_71733,inst_71734,null));
var inst_71736 = ["min",inst_71735,inst_71725];
var inst_71737 = cljs.core.PersistentHashMap.fromArrays(inst_71732,inst_71736);
var inst_71738 = [inst_71737,inst_71730];
var inst_71739 = (new cljs.core.PersistentVector(null,2,(5),inst_71731,inst_71738,null));
var inst_71740 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71739);
var _ = (function (){var statearr_71754 = state_71745;
(statearr_71754[(4)] = cljs.core.rest((state_71745[(4)])));

return statearr_71754;
})();
var state_71745__$1 = (function (){var statearr_71755 = state_71745;
(statearr_71755[(7)] = inst_71740);

return statearr_71755;
})();
var statearr_71756_71769 = state_71745__$1;
(statearr_71756_71769[(2)] = inst_71725);

(statearr_71756_71769[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71757 = [null,null,null,null,null,null,null,null];
(statearr_71757[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71757[(1)] = (1));

return statearr_71757;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71745){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71745);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71758){var ex__13886__auto__ = e71758;
var statearr_71759_71770 = state_71745;
(statearr_71759_71770[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71745[(4)]))){
var statearr_71760_71771 = state_71745;
(statearr_71760_71771[(1)] = cljs.core.first((state_71745[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71772 = state_71745;
state_71745 = G__71772;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71745){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71761 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71761[(6)] = c__13957__auto__);

return statearr_71761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq71713){
var G__71714 = cljs.core.first(seq71713);
var seq71713__$1 = cljs.core.next(seq71713);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71714,seq71713__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__71774 = arguments.length;
switch (G__71774) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71819){
var state_val_71820 = (state_71819[(1)]);
if((state_val_71820 === (7))){
var state_71819__$1 = state_71819;
var statearr_71821_71958 = state_71819__$1;
(statearr_71821_71958[(2)] = query_map);

(statearr_71821_71958[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (1))){
var state_71819__$1 = state_71819;
var statearr_71822_71959 = state_71819__$1;
(statearr_71822_71959[(2)] = null);

(statearr_71822_71959[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (4))){
var inst_71775 = (state_71819[(2)]);
var state_71819__$1 = state_71819;
var statearr_71823_71960 = state_71819__$1;
(statearr_71823_71960[(2)] = inst_71775);

(statearr_71823_71960[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (13))){
var inst_71797 = (state_71819[(7)]);
var inst_71801 = (state_71819[(2)]);
var inst_71802 = fluree.db.util.async.throw_err(inst_71801);
var inst_71803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71802,(0),null);
var inst_71804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71802,(1),null);
var inst_71805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71806 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71808 = [inst_71797];
var inst_71809 = (new cljs.core.PersistentVector(null,1,(5),inst_71807,inst_71808,null));
var inst_71810 = ["query",inst_71809,inst_71803];
var inst_71811 = cljs.core.PersistentHashMap.fromArrays(inst_71806,inst_71810);
var inst_71812 = [inst_71811,inst_71804];
var inst_71813 = (new cljs.core.PersistentVector(null,2,(5),inst_71805,inst_71812,null));
var inst_71814 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71813);
var _ = (function (){var statearr_71824 = state_71819;
(statearr_71824[(4)] = cljs.core.rest((state_71819[(4)])));

return statearr_71824;
})();
var state_71819__$1 = (function (){var statearr_71825 = state_71819;
(statearr_71825[(8)] = inst_71814);

return statearr_71825;
})();
var statearr_71826_71961 = state_71819__$1;
(statearr_71826_71961[(2)] = inst_71803);

(statearr_71826_71961[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (6))){
var state_71819__$1 = state_71819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71819__$1,(9),query_map);
} else {
if((state_val_71820 === (3))){
var inst_71817 = (state_71819[(2)]);
var state_71819__$1 = state_71819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71819__$1,inst_71817);
} else {
if((state_val_71820 === (12))){
var inst_71797 = (state_71819[(7)]);
var inst_71797__$1 = (state_71819[(2)]);
var inst_71798 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71799 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_71798,inst_71797__$1);
var state_71819__$1 = (function (){var statearr_71827 = state_71819;
(statearr_71827[(7)] = inst_71797__$1);

return statearr_71827;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71819__$1,(13),inst_71799);
} else {
if((state_val_71820 === (2))){
var _ = (function (){var statearr_71828 = state_71819;
(statearr_71828[(4)] = cljs.core.cons((5),(state_71819[(4)])));

return statearr_71828;
})();
var inst_71784 = fluree.db.util.async.channel_QMARK_(query_map);
var state_71819__$1 = state_71819;
if(inst_71784){
var statearr_71829_71962 = state_71819__$1;
(statearr_71829_71962[(1)] = (6));

} else {
var statearr_71830_71963 = state_71819__$1;
(statearr_71830_71963[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (11))){
var inst_71791 = (state_71819[(9)]);
var state_71819__$1 = state_71819;
var statearr_71832_71964 = state_71819__$1;
(statearr_71832_71964[(2)] = inst_71791);

(statearr_71832_71964[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (9))){
var inst_71787 = (state_71819[(2)]);
var inst_71788 = fluree.db.util.async.throw_err(inst_71787);
var state_71819__$1 = state_71819;
var statearr_71833_71965 = state_71819__$1;
(statearr_71833_71965[(2)] = inst_71788);

(statearr_71833_71965[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (5))){
var _ = (function (){var statearr_71834 = state_71819;
(statearr_71834[(4)] = cljs.core.rest((state_71819[(4)])));

return statearr_71834;
})();
var state_71819__$1 = state_71819;
var ex71831 = (state_71819__$1[(2)]);
var statearr_71835_71966 = state_71819__$1;
(statearr_71835_71966[(5)] = ex71831);


if((ex71831 instanceof Error)){
var statearr_71836_71967 = state_71819__$1;
(statearr_71836_71967[(1)] = (4));

(statearr_71836_71967[(5)] = null);

} else {
throw ex71831;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (10))){
var inst_71791 = (state_71819[(9)]);
var inst_71794 = fluree.db.util.json.parse(inst_71791);
var state_71819__$1 = state_71819;
var statearr_71837_71968 = state_71819__$1;
(statearr_71837_71968[(2)] = inst_71794);

(statearr_71837_71968[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71820 === (8))){
var inst_71791 = (state_71819[(9)]);
var inst_71791__$1 = (state_71819[(2)]);
var inst_71792 = typeof inst_71791__$1 === 'string';
var state_71819__$1 = (function (){var statearr_71838 = state_71819;
(statearr_71838[(9)] = inst_71791__$1);

return statearr_71838;
})();
if(cljs.core.truth_(inst_71792)){
var statearr_71839_71969 = state_71819__$1;
(statearr_71839_71969[(1)] = (10));

} else {
var statearr_71840_71970 = state_71819__$1;
(statearr_71840_71970[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71841 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71841[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71841[(1)] = (1));

return statearr_71841;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71819){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71819);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71842){var ex__13886__auto__ = e71842;
var statearr_71843_71971 = state_71819;
(statearr_71843_71971[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71819[(4)]))){
var statearr_71844_71972 = state_71819;
(statearr_71844_71972[(1)] = cljs.core.first((state_71819[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__71973 = state_71819;
state_71819 = G__71973;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71819){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71845 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71845[(6)] = c__13957__auto__);

return statearr_71845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_71916){
var state_val_71917 = (state_71916[(1)]);
if((state_val_71917 === (7))){
var state_71916__$1 = state_71916;
var statearr_71918_71974 = state_71916__$1;
(statearr_71918_71974[(2)] = select);

(statearr_71918_71974[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (20))){
var inst_71886 = (state_71916[(2)]);
var inst_71887 = fluree.db.util.async.channel_QMARK_(limit);
var state_71916__$1 = (function (){var statearr_71919 = state_71916;
(statearr_71919[(7)] = inst_71886);

return statearr_71919;
})();
if(inst_71887){
var statearr_71920_71975 = state_71916__$1;
(statearr_71920_71975[(1)] = (22));

} else {
var statearr_71921_71976 = state_71916__$1;
(statearr_71921_71976[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (1))){
var state_71916__$1 = state_71916;
var statearr_71922_71977 = state_71916__$1;
(statearr_71922_71977[(2)] = null);

(statearr_71922_71977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (24))){
var inst_71886 = (state_71916[(7)]);
var inst_71870 = (state_71916[(8)]);
var inst_71862 = (state_71916[(9)]);
var inst_71878 = (state_71916[(10)]);
var inst_71894 = (state_71916[(2)]);
var inst_71895 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71896 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_71895,inst_71862,inst_71870,inst_71878,inst_71886,inst_71894);
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(26),inst_71896);
} else {
if((state_val_71917 === (4))){
var inst_71846 = (state_71916[(2)]);
var state_71916__$1 = state_71916;
var statearr_71923_71978 = state_71916__$1;
(statearr_71923_71978[(2)] = inst_71846);

(statearr_71923_71978[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (15))){
var state_71916__$1 = state_71916;
var statearr_71924_71979 = state_71916__$1;
(statearr_71924_71979[(2)] = where);

(statearr_71924_71979[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (21))){
var inst_71882 = (state_71916[(2)]);
var inst_71883 = fluree.db.util.async.throw_err(inst_71882);
var state_71916__$1 = state_71916;
var statearr_71925_71980 = state_71916__$1;
(statearr_71925_71980[(2)] = inst_71883);

(statearr_71925_71980[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (13))){
var inst_71866 = (state_71916[(2)]);
var inst_71867 = fluree.db.util.async.throw_err(inst_71866);
var state_71916__$1 = state_71916;
var statearr_71926_71981 = state_71916__$1;
(statearr_71926_71981[(2)] = inst_71867);

(statearr_71926_71981[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (22))){
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(25),limit);
} else {
if((state_val_71917 === (6))){
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(9),select);
} else {
if((state_val_71917 === (25))){
var inst_71890 = (state_71916[(2)]);
var inst_71891 = fluree.db.util.async.throw_err(inst_71890);
var state_71916__$1 = state_71916;
var statearr_71927_71982 = state_71916__$1;
(statearr_71927_71982[(2)] = inst_71891);

(statearr_71927_71982[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (17))){
var inst_71874 = (state_71916[(2)]);
var inst_71875 = fluree.db.util.async.throw_err(inst_71874);
var state_71916__$1 = state_71916;
var statearr_71928_71983 = state_71916__$1;
(statearr_71928_71983[(2)] = inst_71875);

(statearr_71928_71983[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (3))){
var inst_71914 = (state_71916[(2)]);
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71916__$1,inst_71914);
} else {
if((state_val_71917 === (12))){
var inst_71870 = (state_71916[(2)]);
var inst_71871 = fluree.db.util.async.channel_QMARK_(where);
var state_71916__$1 = (function (){var statearr_71929 = state_71916;
(statearr_71929[(8)] = inst_71870);

return statearr_71929;
})();
if(inst_71871){
var statearr_71930_71984 = state_71916__$1;
(statearr_71930_71984[(1)] = (14));

} else {
var statearr_71931_71985 = state_71916__$1;
(statearr_71931_71985[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (2))){
var _ = (function (){var statearr_71932 = state_71916;
(statearr_71932[(4)] = cljs.core.cons((5),(state_71916[(4)])));

return statearr_71932;
})();
var inst_71855 = fluree.db.util.async.channel_QMARK_(select);
var state_71916__$1 = state_71916;
if(inst_71855){
var statearr_71933_71986 = state_71916__$1;
(statearr_71933_71986[(1)] = (6));

} else {
var statearr_71934_71987 = state_71916__$1;
(statearr_71934_71987[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (23))){
var state_71916__$1 = state_71916;
var statearr_71935_71988 = state_71916__$1;
(statearr_71935_71988[(2)] = limit);

(statearr_71935_71988[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (19))){
var state_71916__$1 = state_71916;
var statearr_71936_71989 = state_71916__$1;
(statearr_71936_71989[(2)] = block);

(statearr_71936_71989[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (11))){
var state_71916__$1 = state_71916;
var statearr_71938_71990 = state_71916__$1;
(statearr_71938_71990[(2)] = from);

(statearr_71938_71990[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (9))){
var inst_71858 = (state_71916[(2)]);
var inst_71859 = fluree.db.util.async.throw_err(inst_71858);
var state_71916__$1 = state_71916;
var statearr_71939_71991 = state_71916__$1;
(statearr_71939_71991[(2)] = inst_71859);

(statearr_71939_71991[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (5))){
var _ = (function (){var statearr_71940 = state_71916;
(statearr_71940[(4)] = cljs.core.rest((state_71916[(4)])));

return statearr_71940;
})();
var state_71916__$1 = state_71916;
var ex71937 = (state_71916__$1[(2)]);
var statearr_71941_71992 = state_71916__$1;
(statearr_71941_71992[(5)] = ex71937);


if((ex71937 instanceof Error)){
var statearr_71942_71993 = state_71916__$1;
(statearr_71942_71993[(1)] = (4));

(statearr_71942_71993[(5)] = null);

} else {
throw ex71937;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (14))){
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(17),where);
} else {
if((state_val_71917 === (26))){
var inst_71886 = (state_71916[(7)]);
var inst_71870 = (state_71916[(8)]);
var inst_71862 = (state_71916[(9)]);
var inst_71878 = (state_71916[(10)]);
var inst_71898 = (state_71916[(2)]);
var inst_71899 = fluree.db.util.async.throw_err(inst_71898);
var inst_71900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71899,(0),null);
var inst_71901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71899,(1),null);
var inst_71902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71903 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71905 = [inst_71862,inst_71870,inst_71878,inst_71886];
var inst_71906 = (new cljs.core.PersistentVector(null,4,(5),inst_71904,inst_71905,null));
var inst_71907 = ["query",inst_71906,inst_71900];
var inst_71908 = cljs.core.PersistentHashMap.fromArrays(inst_71903,inst_71907);
var inst_71909 = [inst_71908,inst_71901];
var inst_71910 = (new cljs.core.PersistentVector(null,2,(5),inst_71902,inst_71909,null));
var inst_71911 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71910);
var _ = (function (){var statearr_71943 = state_71916;
(statearr_71943[(4)] = cljs.core.rest((state_71916[(4)])));

return statearr_71943;
})();
var state_71916__$1 = (function (){var statearr_71944 = state_71916;
(statearr_71944[(11)] = inst_71911);

return statearr_71944;
})();
var statearr_71945_71994 = state_71916__$1;
(statearr_71945_71994[(2)] = inst_71900);

(statearr_71945_71994[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (16))){
var inst_71878 = (state_71916[(2)]);
var inst_71879 = fluree.db.util.async.channel_QMARK_(block);
var state_71916__$1 = (function (){var statearr_71946 = state_71916;
(statearr_71946[(10)] = inst_71878);

return statearr_71946;
})();
if(inst_71879){
var statearr_71947_71995 = state_71916__$1;
(statearr_71947_71995[(1)] = (18));

} else {
var statearr_71948_71996 = state_71916__$1;
(statearr_71948_71996[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71917 === (10))){
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(13),from);
} else {
if((state_val_71917 === (18))){
var state_71916__$1 = state_71916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71916__$1,(21),block);
} else {
if((state_val_71917 === (8))){
var inst_71862 = (state_71916[(2)]);
var inst_71863 = fluree.db.util.async.channel_QMARK_(from);
var state_71916__$1 = (function (){var statearr_71949 = state_71916;
(statearr_71949[(9)] = inst_71862);

return statearr_71949;
})();
if(inst_71863){
var statearr_71950_71997 = state_71916__$1;
(statearr_71950_71997[(1)] = (10));

} else {
var statearr_71951_71998 = state_71916__$1;
(statearr_71951_71998[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_71952 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71952[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_71952[(1)] = (1));

return statearr_71952;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_71916){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_71916);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e71953){var ex__13886__auto__ = e71953;
var statearr_71954_71999 = state_71916;
(statearr_71954_71999[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_71916[(4)]))){
var statearr_71955_72000 = state_71916;
(statearr_71955_72000[(1)] = cljs.core.first((state_71916[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72001 = state_71916;
state_71916 = G__72001;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_71916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_71916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_71956 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_71956[(6)] = c__13957__auto__);

return statearr_71956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72057){
var state_val_72058 = (state_72057[(1)]);
if((state_val_72058 === (7))){
var state_72057__$1 = state_72057;
var statearr_72059_72090 = state_72057__$1;
(statearr_72059_72090[(2)] = startSubject);

(statearr_72059_72090[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (1))){
var state_72057__$1 = state_72057;
var statearr_72060_72091 = state_72057__$1;
(statearr_72060_72091[(2)] = null);

(statearr_72060_72091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (4))){
var inst_72002 = (state_72057[(2)]);
var state_72057__$1 = state_72057;
var statearr_72061_72092 = state_72057__$1;
(statearr_72061_72092[(2)] = inst_72002);

(statearr_72061_72092[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (15))){
var inst_72034 = (state_72057[(2)]);
var inst_72035 = fluree.db.util.async.throw_err(inst_72034);
var inst_72036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72035,(0),null);
var inst_72037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72035,(1),null);
var inst_72038 = cljs.core.empty_QMARK_(inst_72036);
var state_72057__$1 = (function (){var statearr_72062 = state_72057;
(statearr_72062[(7)] = inst_72037);

return statearr_72062;
})();
if(inst_72038){
var statearr_72063_72093 = state_72057__$1;
(statearr_72063_72093[(1)] = (16));

} else {
var statearr_72064_72094 = state_72057__$1;
(statearr_72064_72094[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (13))){
var inst_72022 = (state_72057[(8)]);
var inst_72018 = (state_72057[(9)]);
var inst_72030 = (state_72057[(10)]);
var inst_72030__$1 = (state_72057[(2)]);
var inst_72031 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72032 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_72031,inst_72018,inst_72022,inst_72030__$1);
var state_72057__$1 = (function (){var statearr_72065 = state_72057;
(statearr_72065[(10)] = inst_72030__$1);

return statearr_72065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72057__$1,(15),inst_72032);
} else {
if((state_val_72058 === (6))){
var state_72057__$1 = state_72057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72057__$1,(9),startSubject);
} else {
if((state_val_72058 === (17))){
var state_72057__$1 = state_72057;
var statearr_72066_72095 = state_72057__$1;
(statearr_72066_72095[(2)] = true);

(statearr_72066_72095[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (3))){
var inst_72055 = (state_72057[(2)]);
var state_72057__$1 = state_72057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72057__$1,inst_72055);
} else {
if((state_val_72058 === (12))){
var state_72057__$1 = state_72057;
var statearr_72067_72096 = state_72057__$1;
(statearr_72067_72096[(2)] = endSubject);

(statearr_72067_72096[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (2))){
var _ = (function (){var statearr_72068 = state_72057;
(statearr_72068[(4)] = cljs.core.cons((5),(state_72057[(4)])));

return statearr_72068;
})();
var inst_72011 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_72057__$1 = state_72057;
if(inst_72011){
var statearr_72069_72097 = state_72057__$1;
(statearr_72069_72097[(1)] = (6));

} else {
var statearr_72070_72098 = state_72057__$1;
(statearr_72070_72098[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (11))){
var state_72057__$1 = state_72057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72057__$1,(14),endSubject);
} else {
if((state_val_72058 === (9))){
var inst_72014 = (state_72057[(2)]);
var inst_72015 = fluree.db.util.async.throw_err(inst_72014);
var state_72057__$1 = state_72057;
var statearr_72072_72099 = state_72057__$1;
(statearr_72072_72099[(2)] = inst_72015);

(statearr_72072_72099[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (5))){
var _ = (function (){var statearr_72073 = state_72057;
(statearr_72073[(4)] = cljs.core.rest((state_72057[(4)])));

return statearr_72073;
})();
var state_72057__$1 = state_72057;
var ex72071 = (state_72057__$1[(2)]);
var statearr_72074_72100 = state_72057__$1;
(statearr_72074_72100[(5)] = ex72071);


if((ex72071 instanceof Error)){
var statearr_72075_72101 = state_72057__$1;
(statearr_72075_72101[(1)] = (4));

(statearr_72075_72101[(5)] = null);

} else {
throw ex72071;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (14))){
var inst_72026 = (state_72057[(2)]);
var inst_72027 = fluree.db.util.async.throw_err(inst_72026);
var state_72057__$1 = state_72057;
var statearr_72076_72102 = state_72057__$1;
(statearr_72076_72102[(2)] = inst_72027);

(statearr_72076_72102[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (16))){
var state_72057__$1 = state_72057;
var statearr_72077_72103 = state_72057__$1;
(statearr_72077_72103[(2)] = false);

(statearr_72077_72103[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (10))){
var inst_72021 = (state_72057[(2)]);
var inst_72022 = fluree.db.util.async.throw_err(inst_72021);
var inst_72023 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_72057__$1 = (function (){var statearr_72078 = state_72057;
(statearr_72078[(8)] = inst_72022);

return statearr_72078;
})();
if(inst_72023){
var statearr_72079_72104 = state_72057__$1;
(statearr_72079_72104[(1)] = (11));

} else {
var statearr_72080_72105 = state_72057__$1;
(statearr_72080_72105[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (18))){
var inst_72022 = (state_72057[(8)]);
var inst_72037 = (state_72057[(7)]);
var inst_72018 = (state_72057[(9)]);
var inst_72030 = (state_72057[(10)]);
var inst_72042 = (state_72057[(2)]);
var inst_72043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72044 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72046 = [inst_72018,inst_72022,inst_72030];
var inst_72047 = (new cljs.core.PersistentVector(null,3,(5),inst_72045,inst_72046,null));
var inst_72048 = ["relationship?",inst_72047,inst_72042];
var inst_72049 = cljs.core.PersistentHashMap.fromArrays(inst_72044,inst_72048);
var inst_72050 = [inst_72049,inst_72037];
var inst_72051 = (new cljs.core.PersistentVector(null,2,(5),inst_72043,inst_72050,null));
var inst_72052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72051);
var _ = (function (){var statearr_72081 = state_72057;
(statearr_72081[(4)] = cljs.core.rest((state_72057[(4)])));

return statearr_72081;
})();
var state_72057__$1 = (function (){var statearr_72082 = state_72057;
(statearr_72082[(11)] = inst_72052);

return statearr_72082;
})();
var statearr_72083_72106 = state_72057__$1;
(statearr_72083_72106[(2)] = inst_72042);

(statearr_72083_72106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72058 === (8))){
var inst_72018 = (state_72057[(2)]);
var inst_72019 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_72057__$1 = (function (){var statearr_72084 = state_72057;
(statearr_72084[(9)] = inst_72018);

return statearr_72084;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72057__$1,(10),inst_72019);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_72085 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72085[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__);

(statearr_72085[(1)] = (1));

return statearr_72085;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1 = (function (state_72057){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72057);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72086){var ex__13886__auto__ = e72086;
var statearr_72087_72107 = state_72057;
(statearr_72087_72107[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72057[(4)]))){
var statearr_72088_72108 = state_72057;
(statearr_72088_72108[(1)] = cljs.core.first((state_72057[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72109 = state_72057;
state_72057 = G__72109;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__ = function(state_72057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1.call(this,state_72057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72089 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72089[(6)] = c__13957__auto__);

return statearr_72089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72146){
var state_val_72147 = (state_72146[(1)]);
if((state_val_72147 === (7))){
var state_72146__$1 = state_72146;
var statearr_72148_72168 = state_72146__$1;
(statearr_72148_72168[(2)] = pred_name);

(statearr_72148_72168[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (1))){
var state_72146__$1 = state_72146;
var statearr_72149_72169 = state_72146__$1;
(statearr_72149_72169[(2)] = null);

(statearr_72149_72169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (4))){
var inst_72110 = (state_72146[(2)]);
var state_72146__$1 = state_72146;
var statearr_72150_72170 = state_72146__$1;
(statearr_72150_72170[(2)] = inst_72110);

(statearr_72150_72170[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (6))){
var state_72146__$1 = state_72146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72146__$1,(9),pred_name);
} else {
if((state_val_72147 === (3))){
var inst_72144 = (state_72146[(2)]);
var state_72146__$1 = state_72146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72146__$1,inst_72144);
} else {
if((state_val_72147 === (2))){
var _ = (function (){var statearr_72152 = state_72146;
(statearr_72152[(4)] = cljs.core.cons((5),(state_72146[(4)])));

return statearr_72152;
})();
var inst_72119 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_72146__$1 = state_72146;
if(inst_72119){
var statearr_72153_72171 = state_72146__$1;
(statearr_72153_72171[(1)] = (6));

} else {
var statearr_72154_72172 = state_72146__$1;
(statearr_72154_72172[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (9))){
var inst_72122 = (state_72146[(2)]);
var inst_72123 = fluree.db.util.async.throw_err(inst_72122);
var state_72146__$1 = state_72146;
var statearr_72155_72173 = state_72146__$1;
(statearr_72155_72173[(2)] = inst_72123);

(statearr_72155_72173[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (5))){
var _ = (function (){var statearr_72156 = state_72146;
(statearr_72156[(4)] = cljs.core.rest((state_72146[(4)])));

return statearr_72156;
})();
var state_72146__$1 = state_72146;
var ex72151 = (state_72146__$1[(2)]);
var statearr_72157_72174 = state_72146__$1;
(statearr_72157_72174[(5)] = ex72151);


if((ex72151 instanceof Error)){
var statearr_72158_72175 = state_72146__$1;
(statearr_72158_72175[(1)] = (4));

(statearr_72158_72175[(5)] = null);

} else {
throw ex72151;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (10))){
var inst_72126 = (state_72146[(7)]);
var inst_72130 = (state_72146[(2)]);
var inst_72131 = fluree.db.util.async.throw_err(inst_72130);
var inst_72132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72131,(0),null);
var inst_72133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72131,(1),null);
var inst_72134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72135 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72136 = ["max-pred-val",inst_72126,inst_72132];
var inst_72137 = cljs.core.PersistentHashMap.fromArrays(inst_72135,inst_72136);
var inst_72138 = (inst_72133 + (10));
var inst_72139 = [inst_72137,inst_72138];
var inst_72140 = (new cljs.core.PersistentVector(null,2,(5),inst_72134,inst_72139,null));
var inst_72141 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72140);
var _ = (function (){var statearr_72159 = state_72146;
(statearr_72159[(4)] = cljs.core.rest((state_72146[(4)])));

return statearr_72159;
})();
var state_72146__$1 = (function (){var statearr_72160 = state_72146;
(statearr_72160[(8)] = inst_72141);

return statearr_72160;
})();
var statearr_72161_72176 = state_72146__$1;
(statearr_72161_72176[(2)] = inst_72132);

(statearr_72161_72176[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (8))){
var inst_72126 = (state_72146[(7)]);
var inst_72126__$1 = (state_72146[(2)]);
var inst_72127 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72128 = fluree.db.dbfunctions.internal.max_pred_val(inst_72127,inst_72126__$1,null);
var state_72146__$1 = (function (){var statearr_72162 = state_72146;
(statearr_72162[(7)] = inst_72126__$1);

return statearr_72162;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72146__$1,(10),inst_72128);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0 = (function (){
var statearr_72163 = [null,null,null,null,null,null,null,null,null];
(statearr_72163[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__);

(statearr_72163[(1)] = (1));

return statearr_72163;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1 = (function (state_72146){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72146);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72164){var ex__13886__auto__ = e72164;
var statearr_72165_72177 = state_72146;
(statearr_72165_72177[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72146[(4)]))){
var statearr_72166_72178 = state_72146;
(statearr_72166_72178[(1)] = cljs.core.first((state_72146[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72179 = state_72146;
state_72146 = G__72179;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__ = function(state_72146){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1.call(this,state_72146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72167 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72167[(6)] = c__13957__auto__);

return statearr_72167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72206){
var state_val_72207 = (state_72206[(1)]);
if((state_val_72207 === (7))){
var state_72206__$1 = state_72206;
var statearr_72208_72227 = state_72206__$1;
(statearr_72208_72227[(2)] = n);

(statearr_72208_72227[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (1))){
var state_72206__$1 = state_72206;
var statearr_72209_72228 = state_72206__$1;
(statearr_72209_72228[(2)] = null);

(statearr_72209_72228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (4))){
var inst_72180 = (state_72206[(2)]);
var state_72206__$1 = state_72206;
var statearr_72210_72229 = state_72206__$1;
(statearr_72210_72229[(2)] = inst_72180);

(statearr_72210_72229[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (6))){
var state_72206__$1 = state_72206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72206__$1,(9),n);
} else {
if((state_val_72207 === (3))){
var inst_72204 = (state_72206[(2)]);
var state_72206__$1 = state_72206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72206__$1,inst_72204);
} else {
if((state_val_72207 === (2))){
var _ = (function (){var statearr_72212 = state_72206;
(statearr_72212[(4)] = cljs.core.cons((5),(state_72206[(4)])));

return statearr_72212;
})();
var inst_72186 = fluree.db.util.async.channel_QMARK_(n);
var state_72206__$1 = state_72206;
if(inst_72186){
var statearr_72213_72230 = state_72206__$1;
(statearr_72213_72230[(1)] = (6));

} else {
var statearr_72214_72231 = state_72206__$1;
(statearr_72214_72231[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (9))){
var inst_72189 = (state_72206[(2)]);
var inst_72190 = fluree.db.util.async.throw_err(inst_72189);
var state_72206__$1 = state_72206;
var statearr_72215_72232 = state_72206__$1;
(statearr_72215_72232[(2)] = inst_72190);

(statearr_72215_72232[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (5))){
var _ = (function (){var statearr_72216 = state_72206;
(statearr_72216[(4)] = cljs.core.rest((state_72206[(4)])));

return statearr_72216;
})();
var state_72206__$1 = state_72206;
var ex72211 = (state_72206__$1[(2)]);
var statearr_72217_72233 = state_72206__$1;
(statearr_72217_72233[(5)] = ex72211);


if((ex72211 instanceof Error)){
var statearr_72218_72234 = state_72206__$1;
(statearr_72218_72234[(1)] = (4));

(statearr_72218_72234[(5)] = null);

} else {
throw ex72211;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72207 === (8))){
var inst_72193 = (state_72206[(2)]);
var inst_72194 = fluree.db.dbfunctions.internal.inc(inst_72193);
var inst_72195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72196 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72197 = ["inc",inst_72193,inst_72194];
var inst_72198 = cljs.core.PersistentHashMap.fromArrays(inst_72196,inst_72197);
var inst_72199 = [inst_72198,(10)];
var inst_72200 = (new cljs.core.PersistentVector(null,2,(5),inst_72195,inst_72199,null));
var inst_72201 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72200);
var _ = (function (){var statearr_72219 = state_72206;
(statearr_72219[(4)] = cljs.core.rest((state_72206[(4)])));

return statearr_72219;
})();
var state_72206__$1 = (function (){var statearr_72220 = state_72206;
(statearr_72220[(7)] = inst_72201);

return statearr_72220;
})();
var statearr_72221_72235 = state_72206__$1;
(statearr_72221_72235[(2)] = inst_72194);

(statearr_72221_72235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0 = (function (){
var statearr_72222 = [null,null,null,null,null,null,null,null];
(statearr_72222[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__);

(statearr_72222[(1)] = (1));

return statearr_72222;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1 = (function (state_72206){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72206);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72223){var ex__13886__auto__ = e72223;
var statearr_72224_72236 = state_72206;
(statearr_72224_72236[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72206[(4)]))){
var statearr_72225_72237 = state_72206;
(statearr_72225_72237[(1)] = cljs.core.first((state_72206[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72238 = state_72206;
state_72206 = G__72238;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__ = function(state_72206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1.call(this,state_72206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72226 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72226[(6)] = c__13957__auto__);

return statearr_72226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72265){
var state_val_72266 = (state_72265[(1)]);
if((state_val_72266 === (7))){
var state_72265__$1 = state_72265;
var statearr_72267_72286 = state_72265__$1;
(statearr_72267_72286[(2)] = n);

(statearr_72267_72286[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (1))){
var state_72265__$1 = state_72265;
var statearr_72268_72287 = state_72265__$1;
(statearr_72268_72287[(2)] = null);

(statearr_72268_72287[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (4))){
var inst_72239 = (state_72265[(2)]);
var state_72265__$1 = state_72265;
var statearr_72269_72288 = state_72265__$1;
(statearr_72269_72288[(2)] = inst_72239);

(statearr_72269_72288[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (6))){
var state_72265__$1 = state_72265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72265__$1,(9),n);
} else {
if((state_val_72266 === (3))){
var inst_72263 = (state_72265[(2)]);
var state_72265__$1 = state_72265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72265__$1,inst_72263);
} else {
if((state_val_72266 === (2))){
var _ = (function (){var statearr_72271 = state_72265;
(statearr_72271[(4)] = cljs.core.cons((5),(state_72265[(4)])));

return statearr_72271;
})();
var inst_72245 = fluree.db.util.async.channel_QMARK_(n);
var state_72265__$1 = state_72265;
if(inst_72245){
var statearr_72272_72289 = state_72265__$1;
(statearr_72272_72289[(1)] = (6));

} else {
var statearr_72273_72290 = state_72265__$1;
(statearr_72273_72290[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (9))){
var inst_72248 = (state_72265[(2)]);
var inst_72249 = fluree.db.util.async.throw_err(inst_72248);
var state_72265__$1 = state_72265;
var statearr_72274_72291 = state_72265__$1;
(statearr_72274_72291[(2)] = inst_72249);

(statearr_72274_72291[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (5))){
var _ = (function (){var statearr_72275 = state_72265;
(statearr_72275[(4)] = cljs.core.rest((state_72265[(4)])));

return statearr_72275;
})();
var state_72265__$1 = state_72265;
var ex72270 = (state_72265__$1[(2)]);
var statearr_72276_72292 = state_72265__$1;
(statearr_72276_72292[(5)] = ex72270);


if((ex72270 instanceof Error)){
var statearr_72277_72293 = state_72265__$1;
(statearr_72277_72293[(1)] = (4));

(statearr_72277_72293[(5)] = null);

} else {
throw ex72270;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72266 === (8))){
var inst_72252 = (state_72265[(2)]);
var inst_72253 = fluree.db.dbfunctions.internal.dec(inst_72252);
var inst_72254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72255 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72256 = ["dec",inst_72252,inst_72253];
var inst_72257 = cljs.core.PersistentHashMap.fromArrays(inst_72255,inst_72256);
var inst_72258 = [inst_72257,(10)];
var inst_72259 = (new cljs.core.PersistentVector(null,2,(5),inst_72254,inst_72258,null));
var inst_72260 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72259);
var _ = (function (){var statearr_72278 = state_72265;
(statearr_72278[(4)] = cljs.core.rest((state_72265[(4)])));

return statearr_72278;
})();
var state_72265__$1 = (function (){var statearr_72279 = state_72265;
(statearr_72279[(7)] = inst_72260);

return statearr_72279;
})();
var statearr_72280_72294 = state_72265__$1;
(statearr_72280_72294[(2)] = inst_72253);

(statearr_72280_72294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0 = (function (){
var statearr_72281 = [null,null,null,null,null,null,null,null];
(statearr_72281[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__);

(statearr_72281[(1)] = (1));

return statearr_72281;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1 = (function (state_72265){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72265);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72282){var ex__13886__auto__ = e72282;
var statearr_72283_72295 = state_72265;
(statearr_72283_72295[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72265[(4)]))){
var statearr_72284_72296 = state_72265;
(statearr_72284_72296[(1)] = cljs.core.first((state_72265[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72297 = state_72265;
state_72265 = G__72297;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__ = function(state_72265){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1.call(this,state_72265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72285 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72285[(6)] = c__13957__auto__);

return statearr_72285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72347 = arguments.length;
var i__4772__auto___72348 = (0);
while(true){
if((i__4772__auto___72348 < len__4771__auto___72347)){
args__4777__auto__.push((arguments[i__4772__auto___72348]));

var G__72349 = (i__4772__auto___72348 + (1));
i__4772__auto___72348 = G__72349;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72330){
var state_val_72331 = (state_72330[(1)]);
if((state_val_72331 === (1))){
var state_72330__$1 = state_72330;
var statearr_72332_72350 = state_72330__$1;
(statearr_72332_72350[(2)] = null);

(statearr_72332_72350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (2))){
var _ = (function (){var statearr_72333 = state_72330;
(statearr_72333[(4)] = cljs.core.cons((5),(state_72330[(4)])));

return statearr_72333;
})();
var inst_72306 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72330__$1 = state_72330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72330__$1,(6),inst_72306);
} else {
if((state_val_72331 === (3))){
var inst_72328 = (state_72330[(2)]);
var state_72330__$1 = state_72330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72330__$1,inst_72328);
} else {
if((state_val_72331 === (4))){
var inst_72300 = (state_72330[(2)]);
var state_72330__$1 = state_72330;
var statearr_72335_72351 = state_72330__$1;
(statearr_72335_72351[(2)] = inst_72300);

(statearr_72335_72351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (5))){
var _ = (function (){var statearr_72336 = state_72330;
(statearr_72336[(4)] = cljs.core.rest((state_72330[(4)])));

return statearr_72336;
})();
var state_72330__$1 = state_72330;
var ex72334 = (state_72330__$1[(2)]);
var statearr_72337_72352 = state_72330__$1;
(statearr_72337_72352[(5)] = ex72334);


if((ex72334 instanceof Error)){
var statearr_72338_72353 = state_72330__$1;
(statearr_72338_72353[(1)] = (4));

(statearr_72338_72353[(5)] = null);

} else {
throw ex72334;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (6))){
var inst_72308 = (state_72330[(2)]);
var inst_72309 = fluree.db.util.async.throw_err(inst_72308);
var inst_72310 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_72309);
var inst_72311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72312 = [inst_72309];
var inst_72313 = (new cljs.core.PersistentVector(null,1,(5),inst_72311,inst_72312,null));
var inst_72314 = cljs.core.count(inst_72313);
var inst_72315 = ((9) + inst_72314);
var inst_72316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72317 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72319 = [inst_72309];
var inst_72320 = (new cljs.core.PersistentVector(null,1,(5),inst_72318,inst_72319,null));
var inst_72321 = ["+",inst_72320,inst_72310];
var inst_72322 = cljs.core.PersistentHashMap.fromArrays(inst_72317,inst_72321);
var inst_72323 = [inst_72322,inst_72315];
var inst_72324 = (new cljs.core.PersistentVector(null,2,(5),inst_72316,inst_72323,null));
var inst_72325 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72324);
var _ = (function (){var statearr_72339 = state_72330;
(statearr_72339[(4)] = cljs.core.rest((state_72330[(4)])));

return statearr_72339;
})();
var state_72330__$1 = (function (){var statearr_72340 = state_72330;
(statearr_72340[(7)] = inst_72325);

return statearr_72340;
})();
var statearr_72341_72354 = state_72330__$1;
(statearr_72341_72354[(2)] = inst_72310);

(statearr_72341_72354[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72342 = [null,null,null,null,null,null,null,null];
(statearr_72342[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72342[(1)] = (1));

return statearr_72342;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72330){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72330);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72343){var ex__13886__auto__ = e72343;
var statearr_72344_72355 = state_72330;
(statearr_72344_72355[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72330[(4)]))){
var statearr_72345_72356 = state_72330;
(statearr_72345_72356[(1)] = cljs.core.first((state_72330[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72357 = state_72330;
state_72330 = G__72357;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72330){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72346 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72346[(6)] = c__13957__auto__);

return statearr_72346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq72298){
var G__72299 = cljs.core.first(seq72298);
var seq72298__$1 = cljs.core.next(seq72298);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72299,seq72298__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72407 = arguments.length;
var i__4772__auto___72408 = (0);
while(true){
if((i__4772__auto___72408 < len__4771__auto___72407)){
args__4777__auto__.push((arguments[i__4772__auto___72408]));

var G__72409 = (i__4772__auto___72408 + (1));
i__4772__auto___72408 = G__72409;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72390){
var state_val_72391 = (state_72390[(1)]);
if((state_val_72391 === (1))){
var state_72390__$1 = state_72390;
var statearr_72392_72410 = state_72390__$1;
(statearr_72392_72410[(2)] = null);

(statearr_72392_72410[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72391 === (2))){
var _ = (function (){var statearr_72393 = state_72390;
(statearr_72393[(4)] = cljs.core.cons((5),(state_72390[(4)])));

return statearr_72393;
})();
var inst_72366 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72390__$1 = state_72390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72390__$1,(6),inst_72366);
} else {
if((state_val_72391 === (3))){
var inst_72388 = (state_72390[(2)]);
var state_72390__$1 = state_72390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72390__$1,inst_72388);
} else {
if((state_val_72391 === (4))){
var inst_72360 = (state_72390[(2)]);
var state_72390__$1 = state_72390;
var statearr_72395_72411 = state_72390__$1;
(statearr_72395_72411[(2)] = inst_72360);

(statearr_72395_72411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72391 === (5))){
var _ = (function (){var statearr_72396 = state_72390;
(statearr_72396[(4)] = cljs.core.rest((state_72390[(4)])));

return statearr_72396;
})();
var state_72390__$1 = state_72390;
var ex72394 = (state_72390__$1[(2)]);
var statearr_72397_72412 = state_72390__$1;
(statearr_72397_72412[(5)] = ex72394);


if((ex72394 instanceof Error)){
var statearr_72398_72413 = state_72390__$1;
(statearr_72398_72413[(1)] = (4));

(statearr_72398_72413[(5)] = null);

} else {
throw ex72394;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72391 === (6))){
var inst_72368 = (state_72390[(2)]);
var inst_72369 = fluree.db.util.async.throw_err(inst_72368);
var inst_72370 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_72369);
var inst_72371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72372 = [inst_72369];
var inst_72373 = (new cljs.core.PersistentVector(null,1,(5),inst_72371,inst_72372,null));
var inst_72374 = cljs.core.count(inst_72373);
var inst_72375 = ((9) + inst_72374);
var inst_72376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72377 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72379 = [inst_72369];
var inst_72380 = (new cljs.core.PersistentVector(null,1,(5),inst_72378,inst_72379,null));
var inst_72381 = ["-",inst_72380,inst_72370];
var inst_72382 = cljs.core.PersistentHashMap.fromArrays(inst_72377,inst_72381);
var inst_72383 = [inst_72382,inst_72375];
var inst_72384 = (new cljs.core.PersistentVector(null,2,(5),inst_72376,inst_72383,null));
var inst_72385 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72384);
var _ = (function (){var statearr_72399 = state_72390;
(statearr_72399[(4)] = cljs.core.rest((state_72390[(4)])));

return statearr_72399;
})();
var state_72390__$1 = (function (){var statearr_72400 = state_72390;
(statearr_72400[(7)] = inst_72385);

return statearr_72400;
})();
var statearr_72401_72414 = state_72390__$1;
(statearr_72401_72414[(2)] = inst_72370);

(statearr_72401_72414[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72402 = [null,null,null,null,null,null,null,null];
(statearr_72402[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72402[(1)] = (1));

return statearr_72402;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72390){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72390);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72403){var ex__13886__auto__ = e72403;
var statearr_72404_72415 = state_72390;
(statearr_72404_72415[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72390[(4)]))){
var statearr_72405_72416 = state_72390;
(statearr_72405_72416[(1)] = cljs.core.first((state_72390[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72417 = state_72390;
state_72390 = G__72417;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72390){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72406 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72406[(6)] = c__13957__auto__);

return statearr_72406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq72358){
var G__72359 = cljs.core.first(seq72358);
var seq72358__$1 = cljs.core.next(seq72358);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72359,seq72358__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72467 = arguments.length;
var i__4772__auto___72468 = (0);
while(true){
if((i__4772__auto___72468 < len__4771__auto___72467)){
args__4777__auto__.push((arguments[i__4772__auto___72468]));

var G__72469 = (i__4772__auto___72468 + (1));
i__4772__auto___72468 = G__72469;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72450){
var state_val_72451 = (state_72450[(1)]);
if((state_val_72451 === (1))){
var state_72450__$1 = state_72450;
var statearr_72452_72470 = state_72450__$1;
(statearr_72452_72470[(2)] = null);

(statearr_72452_72470[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72451 === (2))){
var _ = (function (){var statearr_72453 = state_72450;
(statearr_72453[(4)] = cljs.core.cons((5),(state_72450[(4)])));

return statearr_72453;
})();
var inst_72426 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72450__$1 = state_72450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72450__$1,(6),inst_72426);
} else {
if((state_val_72451 === (3))){
var inst_72448 = (state_72450[(2)]);
var state_72450__$1 = state_72450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72450__$1,inst_72448);
} else {
if((state_val_72451 === (4))){
var inst_72420 = (state_72450[(2)]);
var state_72450__$1 = state_72450;
var statearr_72455_72471 = state_72450__$1;
(statearr_72455_72471[(2)] = inst_72420);

(statearr_72455_72471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72451 === (5))){
var _ = (function (){var statearr_72456 = state_72450;
(statearr_72456[(4)] = cljs.core.rest((state_72450[(4)])));

return statearr_72456;
})();
var state_72450__$1 = state_72450;
var ex72454 = (state_72450__$1[(2)]);
var statearr_72457_72472 = state_72450__$1;
(statearr_72457_72472[(5)] = ex72454);


if((ex72454 instanceof Error)){
var statearr_72458_72473 = state_72450__$1;
(statearr_72458_72473[(1)] = (4));

(statearr_72458_72473[(5)] = null);

} else {
throw ex72454;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72451 === (6))){
var inst_72428 = (state_72450[(2)]);
var inst_72429 = fluree.db.util.async.throw_err(inst_72428);
var inst_72430 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_72429);
var inst_72431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72432 = [inst_72429];
var inst_72433 = (new cljs.core.PersistentVector(null,1,(5),inst_72431,inst_72432,null));
var inst_72434 = cljs.core.count(inst_72433);
var inst_72435 = ((9) + inst_72434);
var inst_72436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72437 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72439 = [inst_72429];
var inst_72440 = (new cljs.core.PersistentVector(null,1,(5),inst_72438,inst_72439,null));
var inst_72441 = ["*",inst_72440,inst_72430];
var inst_72442 = cljs.core.PersistentHashMap.fromArrays(inst_72437,inst_72441);
var inst_72443 = [inst_72442,inst_72435];
var inst_72444 = (new cljs.core.PersistentVector(null,2,(5),inst_72436,inst_72443,null));
var inst_72445 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72444);
var _ = (function (){var statearr_72459 = state_72450;
(statearr_72459[(4)] = cljs.core.rest((state_72450[(4)])));

return statearr_72459;
})();
var state_72450__$1 = (function (){var statearr_72460 = state_72450;
(statearr_72460[(7)] = inst_72445);

return statearr_72460;
})();
var statearr_72461_72474 = state_72450__$1;
(statearr_72461_72474[(2)] = inst_72430);

(statearr_72461_72474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72462 = [null,null,null,null,null,null,null,null];
(statearr_72462[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72462[(1)] = (1));

return statearr_72462;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72450){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72450);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72463){var ex__13886__auto__ = e72463;
var statearr_72464_72475 = state_72450;
(statearr_72464_72475[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72450[(4)]))){
var statearr_72465_72476 = state_72450;
(statearr_72465_72476[(1)] = cljs.core.first((state_72450[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72477 = state_72450;
state_72450 = G__72477;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72466 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72466[(6)] = c__13957__auto__);

return statearr_72466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq72418){
var G__72419 = cljs.core.first(seq72418);
var seq72418__$1 = cljs.core.next(seq72418);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72419,seq72418__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___72527 = arguments.length;
var i__4772__auto___72528 = (0);
while(true){
if((i__4772__auto___72528 < len__4771__auto___72527)){
args__4777__auto__.push((arguments[i__4772__auto___72528]));

var G__72529 = (i__4772__auto___72528 + (1));
i__4772__auto___72528 = G__72529;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72510){
var state_val_72511 = (state_72510[(1)]);
if((state_val_72511 === (1))){
var state_72510__$1 = state_72510;
var statearr_72512_72530 = state_72510__$1;
(statearr_72512_72530[(2)] = null);

(statearr_72512_72530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (2))){
var _ = (function (){var statearr_72513 = state_72510;
(statearr_72513[(4)] = cljs.core.cons((5),(state_72510[(4)])));

return statearr_72513;
})();
var inst_72486 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72510__$1 = state_72510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72510__$1,(6),inst_72486);
} else {
if((state_val_72511 === (3))){
var inst_72508 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72510__$1,inst_72508);
} else {
if((state_val_72511 === (4))){
var inst_72480 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
var statearr_72515_72531 = state_72510__$1;
(statearr_72515_72531[(2)] = inst_72480);

(statearr_72515_72531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (5))){
var _ = (function (){var statearr_72516 = state_72510;
(statearr_72516[(4)] = cljs.core.rest((state_72510[(4)])));

return statearr_72516;
})();
var state_72510__$1 = state_72510;
var ex72514 = (state_72510__$1[(2)]);
var statearr_72517_72532 = state_72510__$1;
(statearr_72517_72532[(5)] = ex72514);


if((ex72514 instanceof Error)){
var statearr_72518_72533 = state_72510__$1;
(statearr_72518_72533[(1)] = (4));

(statearr_72518_72533[(5)] = null);

} else {
throw ex72514;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (6))){
var inst_72488 = (state_72510[(2)]);
var inst_72489 = fluree.db.util.async.throw_err(inst_72488);
var inst_72490 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_72489);
var inst_72491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72492 = [inst_72489];
var inst_72493 = (new cljs.core.PersistentVector(null,1,(5),inst_72491,inst_72492,null));
var inst_72494 = cljs.core.count(inst_72493);
var inst_72495 = ((9) + inst_72494);
var inst_72496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72497 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72499 = [inst_72489];
var inst_72500 = (new cljs.core.PersistentVector(null,1,(5),inst_72498,inst_72499,null));
var inst_72501 = ["/",inst_72500,inst_72490];
var inst_72502 = cljs.core.PersistentHashMap.fromArrays(inst_72497,inst_72501);
var inst_72503 = [inst_72502,inst_72495];
var inst_72504 = (new cljs.core.PersistentVector(null,2,(5),inst_72496,inst_72503,null));
var inst_72505 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72504);
var _ = (function (){var statearr_72519 = state_72510;
(statearr_72519[(4)] = cljs.core.rest((state_72510[(4)])));

return statearr_72519;
})();
var state_72510__$1 = (function (){var statearr_72520 = state_72510;
(statearr_72520[(7)] = inst_72505);

return statearr_72520;
})();
var statearr_72521_72534 = state_72510__$1;
(statearr_72521_72534[(2)] = inst_72490);

(statearr_72521_72534[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_72522 = [null,null,null,null,null,null,null,null];
(statearr_72522[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_72522[(1)] = (1));

return statearr_72522;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_72510){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72510);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72523){var ex__13886__auto__ = e72523;
var statearr_72524_72535 = state_72510;
(statearr_72524_72535[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72510[(4)]))){
var statearr_72525_72536 = state_72510;
(statearr_72525_72536[(1)] = cljs.core.first((state_72510[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72537 = state_72510;
state_72510 = G__72537;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_72510){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_72510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72526 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72526[(6)] = c__13957__auto__);

return statearr_72526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq72478){
var G__72479 = cljs.core.first(seq72478);
var seq72478__$1 = cljs.core.next(seq72478);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72479,seq72478__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72575){
var state_val_72576 = (state_72575[(1)]);
if((state_val_72576 === (7))){
var state_72575__$1 = state_72575;
var statearr_72577_72601 = state_72575__$1;
(statearr_72577_72601[(2)] = n);

(statearr_72577_72601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (1))){
var state_72575__$1 = state_72575;
var statearr_72578_72602 = state_72575__$1;
(statearr_72578_72602[(2)] = null);

(statearr_72578_72602[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (4))){
var inst_72538 = (state_72575[(2)]);
var state_72575__$1 = state_72575;
var statearr_72579_72603 = state_72575__$1;
(statearr_72579_72603[(2)] = inst_72538);

(statearr_72579_72603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (13))){
var inst_72555 = (state_72575[(2)]);
var inst_72556 = fluree.db.util.async.throw_err(inst_72555);
var state_72575__$1 = state_72575;
var statearr_72580_72604 = state_72575__$1;
(statearr_72580_72604[(2)] = inst_72556);

(statearr_72580_72604[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (6))){
var state_72575__$1 = state_72575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72575__$1,(9),n);
} else {
if((state_val_72576 === (3))){
var inst_72573 = (state_72575[(2)]);
var state_72575__$1 = state_72575;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72575__$1,inst_72573);
} else {
if((state_val_72576 === (12))){
var inst_72551 = (state_72575[(7)]);
var inst_72559 = (state_72575[(2)]);
var inst_72560 = fluree.db.dbfunctions.internal.quot(inst_72551,inst_72559);
var inst_72561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72562 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72564 = [inst_72551,inst_72559];
var inst_72565 = (new cljs.core.PersistentVector(null,2,(5),inst_72563,inst_72564,null));
var inst_72566 = ["quot",inst_72565,inst_72560];
var inst_72567 = cljs.core.PersistentHashMap.fromArrays(inst_72562,inst_72566);
var inst_72568 = [inst_72567,(2)];
var inst_72569 = (new cljs.core.PersistentVector(null,2,(5),inst_72561,inst_72568,null));
var inst_72570 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72569);
var _ = (function (){var statearr_72581 = state_72575;
(statearr_72581[(4)] = cljs.core.rest((state_72575[(4)])));

return statearr_72581;
})();
var state_72575__$1 = (function (){var statearr_72582 = state_72575;
(statearr_72582[(8)] = inst_72570);

return statearr_72582;
})();
var statearr_72583_72605 = state_72575__$1;
(statearr_72583_72605[(2)] = inst_72560);

(statearr_72583_72605[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (2))){
var _ = (function (){var statearr_72584 = state_72575;
(statearr_72584[(4)] = cljs.core.cons((5),(state_72575[(4)])));

return statearr_72584;
})();
var inst_72544 = fluree.db.util.async.channel_QMARK_(n);
var state_72575__$1 = state_72575;
if(inst_72544){
var statearr_72585_72606 = state_72575__$1;
(statearr_72585_72606[(1)] = (6));

} else {
var statearr_72586_72607 = state_72575__$1;
(statearr_72586_72607[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (11))){
var state_72575__$1 = state_72575;
var statearr_72588_72608 = state_72575__$1;
(statearr_72588_72608[(2)] = d);

(statearr_72588_72608[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (9))){
var inst_72547 = (state_72575[(2)]);
var inst_72548 = fluree.db.util.async.throw_err(inst_72547);
var state_72575__$1 = state_72575;
var statearr_72589_72609 = state_72575__$1;
(statearr_72589_72609[(2)] = inst_72548);

(statearr_72589_72609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (5))){
var _ = (function (){var statearr_72590 = state_72575;
(statearr_72590[(4)] = cljs.core.rest((state_72575[(4)])));

return statearr_72590;
})();
var state_72575__$1 = state_72575;
var ex72587 = (state_72575__$1[(2)]);
var statearr_72591_72610 = state_72575__$1;
(statearr_72591_72610[(5)] = ex72587);


if((ex72587 instanceof Error)){
var statearr_72592_72611 = state_72575__$1;
(statearr_72592_72611[(1)] = (4));

(statearr_72592_72611[(5)] = null);

} else {
throw ex72587;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72576 === (10))){
var state_72575__$1 = state_72575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72575__$1,(13),d);
} else {
if((state_val_72576 === (8))){
var inst_72551 = (state_72575[(2)]);
var inst_72552 = fluree.db.util.async.channel_QMARK_(d);
var state_72575__$1 = (function (){var statearr_72593 = state_72575;
(statearr_72593[(7)] = inst_72551);

return statearr_72593;
})();
if(inst_72552){
var statearr_72594_72612 = state_72575__$1;
(statearr_72594_72612[(1)] = (10));

} else {
var statearr_72595_72613 = state_72575__$1;
(statearr_72595_72613[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0 = (function (){
var statearr_72596 = [null,null,null,null,null,null,null,null,null];
(statearr_72596[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__);

(statearr_72596[(1)] = (1));

return statearr_72596;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1 = (function (state_72575){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72575);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72597){var ex__13886__auto__ = e72597;
var statearr_72598_72614 = state_72575;
(statearr_72598_72614[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72575[(4)]))){
var statearr_72599_72615 = state_72575;
(statearr_72599_72615[(1)] = cljs.core.first((state_72575[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72616 = state_72575;
state_72575 = G__72616;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__ = function(state_72575){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1.call(this,state_72575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72600 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72600[(6)] = c__13957__auto__);

return statearr_72600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72654){
var state_val_72655 = (state_72654[(1)]);
if((state_val_72655 === (7))){
var state_72654__$1 = state_72654;
var statearr_72656_72680 = state_72654__$1;
(statearr_72656_72680[(2)] = n);

(statearr_72656_72680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (1))){
var state_72654__$1 = state_72654;
var statearr_72657_72681 = state_72654__$1;
(statearr_72657_72681[(2)] = null);

(statearr_72657_72681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (4))){
var inst_72617 = (state_72654[(2)]);
var state_72654__$1 = state_72654;
var statearr_72658_72682 = state_72654__$1;
(statearr_72658_72682[(2)] = inst_72617);

(statearr_72658_72682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (13))){
var inst_72634 = (state_72654[(2)]);
var inst_72635 = fluree.db.util.async.throw_err(inst_72634);
var state_72654__$1 = state_72654;
var statearr_72659_72683 = state_72654__$1;
(statearr_72659_72683[(2)] = inst_72635);

(statearr_72659_72683[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (6))){
var state_72654__$1 = state_72654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72654__$1,(9),n);
} else {
if((state_val_72655 === (3))){
var inst_72652 = (state_72654[(2)]);
var state_72654__$1 = state_72654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72654__$1,inst_72652);
} else {
if((state_val_72655 === (12))){
var inst_72630 = (state_72654[(7)]);
var inst_72638 = (state_72654[(2)]);
var inst_72639 = fluree.db.dbfunctions.internal.mod(inst_72630,inst_72638);
var inst_72640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72641 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72643 = [inst_72630,inst_72638];
var inst_72644 = (new cljs.core.PersistentVector(null,2,(5),inst_72642,inst_72643,null));
var inst_72645 = ["mod",inst_72644,inst_72639];
var inst_72646 = cljs.core.PersistentHashMap.fromArrays(inst_72641,inst_72645);
var inst_72647 = [inst_72646,(2)];
var inst_72648 = (new cljs.core.PersistentVector(null,2,(5),inst_72640,inst_72647,null));
var inst_72649 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72648);
var _ = (function (){var statearr_72660 = state_72654;
(statearr_72660[(4)] = cljs.core.rest((state_72654[(4)])));

return statearr_72660;
})();
var state_72654__$1 = (function (){var statearr_72661 = state_72654;
(statearr_72661[(8)] = inst_72649);

return statearr_72661;
})();
var statearr_72662_72684 = state_72654__$1;
(statearr_72662_72684[(2)] = inst_72639);

(statearr_72662_72684[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (2))){
var _ = (function (){var statearr_72663 = state_72654;
(statearr_72663[(4)] = cljs.core.cons((5),(state_72654[(4)])));

return statearr_72663;
})();
var inst_72623 = fluree.db.util.async.channel_QMARK_(n);
var state_72654__$1 = state_72654;
if(inst_72623){
var statearr_72664_72685 = state_72654__$1;
(statearr_72664_72685[(1)] = (6));

} else {
var statearr_72665_72686 = state_72654__$1;
(statearr_72665_72686[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (11))){
var state_72654__$1 = state_72654;
var statearr_72667_72687 = state_72654__$1;
(statearr_72667_72687[(2)] = d);

(statearr_72667_72687[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (9))){
var inst_72626 = (state_72654[(2)]);
var inst_72627 = fluree.db.util.async.throw_err(inst_72626);
var state_72654__$1 = state_72654;
var statearr_72668_72688 = state_72654__$1;
(statearr_72668_72688[(2)] = inst_72627);

(statearr_72668_72688[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (5))){
var _ = (function (){var statearr_72669 = state_72654;
(statearr_72669[(4)] = cljs.core.rest((state_72654[(4)])));

return statearr_72669;
})();
var state_72654__$1 = state_72654;
var ex72666 = (state_72654__$1[(2)]);
var statearr_72670_72689 = state_72654__$1;
(statearr_72670_72689[(5)] = ex72666);


if((ex72666 instanceof Error)){
var statearr_72671_72690 = state_72654__$1;
(statearr_72671_72690[(1)] = (4));

(statearr_72671_72690[(5)] = null);

} else {
throw ex72666;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72655 === (10))){
var state_72654__$1 = state_72654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72654__$1,(13),d);
} else {
if((state_val_72655 === (8))){
var inst_72630 = (state_72654[(2)]);
var inst_72631 = fluree.db.util.async.channel_QMARK_(d);
var state_72654__$1 = (function (){var statearr_72672 = state_72654;
(statearr_72672[(7)] = inst_72630);

return statearr_72672;
})();
if(inst_72631){
var statearr_72673_72691 = state_72654__$1;
(statearr_72673_72691[(1)] = (10));

} else {
var statearr_72674_72692 = state_72654__$1;
(statearr_72674_72692[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0 = (function (){
var statearr_72675 = [null,null,null,null,null,null,null,null,null];
(statearr_72675[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__);

(statearr_72675[(1)] = (1));

return statearr_72675;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1 = (function (state_72654){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72654);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72676){var ex__13886__auto__ = e72676;
var statearr_72677_72693 = state_72654;
(statearr_72677_72693[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72654[(4)]))){
var statearr_72678_72694 = state_72654;
(statearr_72678_72694[(1)] = cljs.core.first((state_72654[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72695 = state_72654;
state_72654 = G__72695;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__ = function(state_72654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1.call(this,state_72654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72679 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72679[(6)] = c__13957__auto__);

return statearr_72679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72733){
var state_val_72734 = (state_72733[(1)]);
if((state_val_72734 === (7))){
var state_72733__$1 = state_72733;
var statearr_72735_72759 = state_72733__$1;
(statearr_72735_72759[(2)] = n);

(statearr_72735_72759[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (1))){
var state_72733__$1 = state_72733;
var statearr_72736_72760 = state_72733__$1;
(statearr_72736_72760[(2)] = null);

(statearr_72736_72760[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (4))){
var inst_72696 = (state_72733[(2)]);
var state_72733__$1 = state_72733;
var statearr_72737_72761 = state_72733__$1;
(statearr_72737_72761[(2)] = inst_72696);

(statearr_72737_72761[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (13))){
var inst_72713 = (state_72733[(2)]);
var inst_72714 = fluree.db.util.async.throw_err(inst_72713);
var state_72733__$1 = state_72733;
var statearr_72738_72762 = state_72733__$1;
(statearr_72738_72762[(2)] = inst_72714);

(statearr_72738_72762[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (6))){
var state_72733__$1 = state_72733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72733__$1,(9),n);
} else {
if((state_val_72734 === (3))){
var inst_72731 = (state_72733[(2)]);
var state_72733__$1 = state_72733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72733__$1,inst_72731);
} else {
if((state_val_72734 === (12))){
var inst_72709 = (state_72733[(7)]);
var inst_72717 = (state_72733[(2)]);
var inst_72718 = fluree.db.dbfunctions.internal.rem(inst_72709,inst_72717);
var inst_72719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72720 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72722 = [inst_72709,inst_72717];
var inst_72723 = (new cljs.core.PersistentVector(null,2,(5),inst_72721,inst_72722,null));
var inst_72724 = ["rem",inst_72723,inst_72718];
var inst_72725 = cljs.core.PersistentHashMap.fromArrays(inst_72720,inst_72724);
var inst_72726 = [inst_72725,(2)];
var inst_72727 = (new cljs.core.PersistentVector(null,2,(5),inst_72719,inst_72726,null));
var inst_72728 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72727);
var _ = (function (){var statearr_72739 = state_72733;
(statearr_72739[(4)] = cljs.core.rest((state_72733[(4)])));

return statearr_72739;
})();
var state_72733__$1 = (function (){var statearr_72740 = state_72733;
(statearr_72740[(8)] = inst_72728);

return statearr_72740;
})();
var statearr_72741_72763 = state_72733__$1;
(statearr_72741_72763[(2)] = inst_72718);

(statearr_72741_72763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (2))){
var _ = (function (){var statearr_72742 = state_72733;
(statearr_72742[(4)] = cljs.core.cons((5),(state_72733[(4)])));

return statearr_72742;
})();
var inst_72702 = fluree.db.util.async.channel_QMARK_(n);
var state_72733__$1 = state_72733;
if(inst_72702){
var statearr_72743_72764 = state_72733__$1;
(statearr_72743_72764[(1)] = (6));

} else {
var statearr_72744_72765 = state_72733__$1;
(statearr_72744_72765[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (11))){
var state_72733__$1 = state_72733;
var statearr_72746_72766 = state_72733__$1;
(statearr_72746_72766[(2)] = d);

(statearr_72746_72766[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (9))){
var inst_72705 = (state_72733[(2)]);
var inst_72706 = fluree.db.util.async.throw_err(inst_72705);
var state_72733__$1 = state_72733;
var statearr_72747_72767 = state_72733__$1;
(statearr_72747_72767[(2)] = inst_72706);

(statearr_72747_72767[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (5))){
var _ = (function (){var statearr_72748 = state_72733;
(statearr_72748[(4)] = cljs.core.rest((state_72733[(4)])));

return statearr_72748;
})();
var state_72733__$1 = state_72733;
var ex72745 = (state_72733__$1[(2)]);
var statearr_72749_72768 = state_72733__$1;
(statearr_72749_72768[(5)] = ex72745);


if((ex72745 instanceof Error)){
var statearr_72750_72769 = state_72733__$1;
(statearr_72750_72769[(1)] = (4));

(statearr_72750_72769[(5)] = null);

} else {
throw ex72745;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (10))){
var state_72733__$1 = state_72733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72733__$1,(13),d);
} else {
if((state_val_72734 === (8))){
var inst_72709 = (state_72733[(2)]);
var inst_72710 = fluree.db.util.async.channel_QMARK_(d);
var state_72733__$1 = (function (){var statearr_72751 = state_72733;
(statearr_72751[(7)] = inst_72709);

return statearr_72751;
})();
if(inst_72710){
var statearr_72752_72770 = state_72733__$1;
(statearr_72752_72770[(1)] = (10));

} else {
var statearr_72753_72771 = state_72733__$1;
(statearr_72753_72771[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0 = (function (){
var statearr_72754 = [null,null,null,null,null,null,null,null,null];
(statearr_72754[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__);

(statearr_72754[(1)] = (1));

return statearr_72754;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1 = (function (state_72733){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72733);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72755){var ex__13886__auto__ = e72755;
var statearr_72756_72772 = state_72733;
(statearr_72756_72772[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72733[(4)]))){
var statearr_72757_72773 = state_72733;
(statearr_72757_72773[(1)] = cljs.core.first((state_72733[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72774 = state_72733;
state_72733 = G__72774;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__ = function(state_72733){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1.call(this,state_72733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72758 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72758[(6)] = c__13957__auto__);

return statearr_72758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72801){
var state_val_72802 = (state_72801[(1)]);
if((state_val_72802 === (7))){
var state_72801__$1 = state_72801;
var statearr_72803_72822 = state_72801__$1;
(statearr_72803_72822[(2)] = x);

(statearr_72803_72822[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (1))){
var state_72801__$1 = state_72801;
var statearr_72804_72823 = state_72801__$1;
(statearr_72804_72823[(2)] = null);

(statearr_72804_72823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (4))){
var inst_72775 = (state_72801[(2)]);
var state_72801__$1 = state_72801;
var statearr_72805_72824 = state_72801__$1;
(statearr_72805_72824[(2)] = inst_72775);

(statearr_72805_72824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (6))){
var state_72801__$1 = state_72801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72801__$1,(9),x);
} else {
if((state_val_72802 === (3))){
var inst_72799 = (state_72801[(2)]);
var state_72801__$1 = state_72801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72801__$1,inst_72799);
} else {
if((state_val_72802 === (2))){
var _ = (function (){var statearr_72807 = state_72801;
(statearr_72807[(4)] = cljs.core.cons((5),(state_72801[(4)])));

return statearr_72807;
})();
var inst_72781 = fluree.db.util.async.channel_QMARK_(x);
var state_72801__$1 = state_72801;
if(inst_72781){
var statearr_72808_72825 = state_72801__$1;
(statearr_72808_72825[(1)] = (6));

} else {
var statearr_72809_72826 = state_72801__$1;
(statearr_72809_72826[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (9))){
var inst_72784 = (state_72801[(2)]);
var inst_72785 = fluree.db.util.async.throw_err(inst_72784);
var state_72801__$1 = state_72801;
var statearr_72810_72827 = state_72801__$1;
(statearr_72810_72827[(2)] = inst_72785);

(statearr_72810_72827[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (5))){
var _ = (function (){var statearr_72811 = state_72801;
(statearr_72811[(4)] = cljs.core.rest((state_72801[(4)])));

return statearr_72811;
})();
var state_72801__$1 = state_72801;
var ex72806 = (state_72801__$1[(2)]);
var statearr_72812_72828 = state_72801__$1;
(statearr_72812_72828[(5)] = ex72806);


if((ex72806 instanceof Error)){
var statearr_72813_72829 = state_72801__$1;
(statearr_72813_72829[(1)] = (4));

(statearr_72813_72829[(5)] = null);

} else {
throw ex72806;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72802 === (8))){
var inst_72788 = (state_72801[(2)]);
var inst_72789 = fluree.db.dbfunctions.internal.boolean$(inst_72788);
var inst_72790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72791 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72792 = ["boolean",inst_72788,inst_72789];
var inst_72793 = cljs.core.PersistentHashMap.fromArrays(inst_72791,inst_72792);
var inst_72794 = [inst_72793,(10)];
var inst_72795 = (new cljs.core.PersistentVector(null,2,(5),inst_72790,inst_72794,null));
var inst_72796 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72795);
var _ = (function (){var statearr_72814 = state_72801;
(statearr_72814[(4)] = cljs.core.rest((state_72801[(4)])));

return statearr_72814;
})();
var state_72801__$1 = (function (){var statearr_72815 = state_72801;
(statearr_72815[(7)] = inst_72796);

return statearr_72815;
})();
var statearr_72816_72830 = state_72801__$1;
(statearr_72816_72830[(2)] = inst_72789);

(statearr_72816_72830[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0 = (function (){
var statearr_72817 = [null,null,null,null,null,null,null,null];
(statearr_72817[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__);

(statearr_72817[(1)] = (1));

return statearr_72817;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1 = (function (state_72801){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72801);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72818){var ex__13886__auto__ = e72818;
var statearr_72819_72831 = state_72801;
(statearr_72819_72831[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72801[(4)]))){
var statearr_72820_72832 = state_72801;
(statearr_72820_72832[(1)] = cljs.core.first((state_72801[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72833 = state_72801;
state_72801 = G__72833;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__ = function(state_72801){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1.call(this,state_72801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72821 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72821[(6)] = c__13957__auto__);

return statearr_72821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72871){
var state_val_72872 = (state_72871[(1)]);
if((state_val_72872 === (7))){
var state_72871__$1 = state_72871;
var statearr_72873_72897 = state_72871__$1;
(statearr_72873_72897[(2)] = pattern);

(statearr_72873_72897[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (1))){
var state_72871__$1 = state_72871;
var statearr_72874_72898 = state_72871__$1;
(statearr_72874_72898[(2)] = null);

(statearr_72874_72898[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (4))){
var inst_72834 = (state_72871[(2)]);
var state_72871__$1 = state_72871;
var statearr_72875_72899 = state_72871__$1;
(statearr_72875_72899[(2)] = inst_72834);

(statearr_72875_72899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (13))){
var inst_72851 = (state_72871[(2)]);
var inst_72852 = fluree.db.util.async.throw_err(inst_72851);
var state_72871__$1 = state_72871;
var statearr_72876_72900 = state_72871__$1;
(statearr_72876_72900[(2)] = inst_72852);

(statearr_72876_72900[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (6))){
var state_72871__$1 = state_72871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72871__$1,(9),pattern);
} else {
if((state_val_72872 === (3))){
var inst_72869 = (state_72871[(2)]);
var state_72871__$1 = state_72871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72871__$1,inst_72869);
} else {
if((state_val_72872 === (12))){
var inst_72847 = (state_72871[(7)]);
var inst_72855 = (state_72871[(2)]);
var inst_72856 = fluree.db.dbfunctions.internal.re_find(inst_72847,inst_72855);
var inst_72857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72858 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72860 = [inst_72847,inst_72855];
var inst_72861 = (new cljs.core.PersistentVector(null,2,(5),inst_72859,inst_72860,null));
var inst_72862 = ["re-find",inst_72861,inst_72856];
var inst_72863 = cljs.core.PersistentHashMap.fromArrays(inst_72858,inst_72862);
var inst_72864 = [inst_72863,(10)];
var inst_72865 = (new cljs.core.PersistentVector(null,2,(5),inst_72857,inst_72864,null));
var inst_72866 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72865);
var _ = (function (){var statearr_72877 = state_72871;
(statearr_72877[(4)] = cljs.core.rest((state_72871[(4)])));

return statearr_72877;
})();
var state_72871__$1 = (function (){var statearr_72878 = state_72871;
(statearr_72878[(8)] = inst_72866);

return statearr_72878;
})();
var statearr_72879_72901 = state_72871__$1;
(statearr_72879_72901[(2)] = inst_72856);

(statearr_72879_72901[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (2))){
var _ = (function (){var statearr_72880 = state_72871;
(statearr_72880[(4)] = cljs.core.cons((5),(state_72871[(4)])));

return statearr_72880;
})();
var inst_72840 = fluree.db.util.async.channel_QMARK_(pattern);
var state_72871__$1 = state_72871;
if(inst_72840){
var statearr_72881_72902 = state_72871__$1;
(statearr_72881_72902[(1)] = (6));

} else {
var statearr_72882_72903 = state_72871__$1;
(statearr_72882_72903[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (11))){
var state_72871__$1 = state_72871;
var statearr_72884_72904 = state_72871__$1;
(statearr_72884_72904[(2)] = string);

(statearr_72884_72904[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (9))){
var inst_72843 = (state_72871[(2)]);
var inst_72844 = fluree.db.util.async.throw_err(inst_72843);
var state_72871__$1 = state_72871;
var statearr_72885_72905 = state_72871__$1;
(statearr_72885_72905[(2)] = inst_72844);

(statearr_72885_72905[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (5))){
var _ = (function (){var statearr_72886 = state_72871;
(statearr_72886[(4)] = cljs.core.rest((state_72871[(4)])));

return statearr_72886;
})();
var state_72871__$1 = state_72871;
var ex72883 = (state_72871__$1[(2)]);
var statearr_72887_72906 = state_72871__$1;
(statearr_72887_72906[(5)] = ex72883);


if((ex72883 instanceof Error)){
var statearr_72888_72907 = state_72871__$1;
(statearr_72888_72907[(1)] = (4));

(statearr_72888_72907[(5)] = null);

} else {
throw ex72883;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72872 === (10))){
var state_72871__$1 = state_72871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72871__$1,(13),string);
} else {
if((state_val_72872 === (8))){
var inst_72847 = (state_72871[(2)]);
var inst_72848 = fluree.db.util.async.channel_QMARK_(string);
var state_72871__$1 = (function (){var statearr_72889 = state_72871;
(statearr_72889[(7)] = inst_72847);

return statearr_72889;
})();
if(inst_72848){
var statearr_72890_72908 = state_72871__$1;
(statearr_72890_72908[(1)] = (10));

} else {
var statearr_72891_72909 = state_72871__$1;
(statearr_72891_72909[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0 = (function (){
var statearr_72892 = [null,null,null,null,null,null,null,null,null];
(statearr_72892[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__);

(statearr_72892[(1)] = (1));

return statearr_72892;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1 = (function (state_72871){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72871);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72893){var ex__13886__auto__ = e72893;
var statearr_72894_72910 = state_72871;
(statearr_72894_72910[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72871[(4)]))){
var statearr_72895_72911 = state_72871;
(statearr_72895_72911[(1)] = cljs.core.first((state_72871[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72912 = state_72871;
state_72871 = G__72912;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__ = function(state_72871){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1.call(this,state_72871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72896 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72896[(6)] = c__13957__auto__);

return statearr_72896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_72939){
var state_val_72940 = (state_72939[(1)]);
if((state_val_72940 === (7))){
var state_72939__$1 = state_72939;
var statearr_72941_72960 = state_72939__$1;
(statearr_72941_72960[(2)] = email);

(statearr_72941_72960[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (1))){
var state_72939__$1 = state_72939;
var statearr_72942_72961 = state_72939__$1;
(statearr_72942_72961[(2)] = null);

(statearr_72942_72961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (4))){
var inst_72913 = (state_72939[(2)]);
var state_72939__$1 = state_72939;
var statearr_72943_72962 = state_72939__$1;
(statearr_72943_72962[(2)] = inst_72913);

(statearr_72943_72962[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (6))){
var state_72939__$1 = state_72939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72939__$1,(9),email);
} else {
if((state_val_72940 === (3))){
var inst_72937 = (state_72939[(2)]);
var state_72939__$1 = state_72939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72939__$1,inst_72937);
} else {
if((state_val_72940 === (2))){
var _ = (function (){var statearr_72945 = state_72939;
(statearr_72945[(4)] = cljs.core.cons((5),(state_72939[(4)])));

return statearr_72945;
})();
var inst_72919 = fluree.db.util.async.channel_QMARK_(email);
var state_72939__$1 = state_72939;
if(inst_72919){
var statearr_72946_72963 = state_72939__$1;
(statearr_72946_72963[(1)] = (6));

} else {
var statearr_72947_72964 = state_72939__$1;
(statearr_72947_72964[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (9))){
var inst_72922 = (state_72939[(2)]);
var inst_72923 = fluree.db.util.async.throw_err(inst_72922);
var state_72939__$1 = state_72939;
var statearr_72948_72965 = state_72939__$1;
(statearr_72948_72965[(2)] = inst_72923);

(statearr_72948_72965[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (5))){
var _ = (function (){var statearr_72949 = state_72939;
(statearr_72949[(4)] = cljs.core.rest((state_72939[(4)])));

return statearr_72949;
})();
var state_72939__$1 = state_72939;
var ex72944 = (state_72939__$1[(2)]);
var statearr_72950_72966 = state_72939__$1;
(statearr_72950_72966[(5)] = ex72944);


if((ex72944 instanceof Error)){
var statearr_72951_72967 = state_72939__$1;
(statearr_72951_72967[(1)] = (4));

(statearr_72951_72967[(5)] = null);

} else {
throw ex72944;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72940 === (8))){
var inst_72926 = (state_72939[(2)]);
var inst_72927 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_72926);
var inst_72928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72929 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72930 = ["re-find",inst_72926,inst_72927];
var inst_72931 = cljs.core.PersistentHashMap.fromArrays(inst_72929,inst_72930);
var inst_72932 = [inst_72931,(10)];
var inst_72933 = (new cljs.core.PersistentVector(null,2,(5),inst_72928,inst_72932,null));
var inst_72934 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72933);
var _ = (function (){var statearr_72952 = state_72939;
(statearr_72952[(4)] = cljs.core.rest((state_72939[(4)])));

return statearr_72952;
})();
var state_72939__$1 = (function (){var statearr_72953 = state_72939;
(statearr_72953[(7)] = inst_72934);

return statearr_72953;
})();
var statearr_72954_72968 = state_72939__$1;
(statearr_72954_72968[(2)] = inst_72927);

(statearr_72954_72968[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_72955 = [null,null,null,null,null,null,null,null];
(statearr_72955[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__);

(statearr_72955[(1)] = (1));

return statearr_72955;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1 = (function (state_72939){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_72939);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e72956){var ex__13886__auto__ = e72956;
var statearr_72957_72969 = state_72939;
(statearr_72957_72969[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_72939[(4)]))){
var statearr_72958_72970 = state_72939;
(statearr_72958_72970[(1)] = cljs.core.first((state_72939[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__72971 = state_72939;
state_72939 = G__72971;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__ = function(state_72939){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1.call(this,state_72939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_72959 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_72959[(6)] = c__13957__auto__);

return statearr_72959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73018){
var state_val_73019 = (state_73018[(1)]);
if((state_val_73019 === (7))){
var inst_72988 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73018__$1 = state_73018;
if(cljs.core.truth_(inst_72988)){
var statearr_73020_73047 = state_73018__$1;
(statearr_73020_73047[(1)] = (9));

} else {
var statearr_73021_73048 = state_73018__$1;
(statearr_73021_73048[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (1))){
var state_73018__$1 = state_73018;
var statearr_73022_73049 = state_73018__$1;
(statearr_73022_73049[(2)] = null);

(statearr_73022_73049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (4))){
var inst_72972 = (state_73018[(2)]);
var state_73018__$1 = state_73018;
var statearr_73023_73050 = state_73018__$1;
(statearr_73023_73050[(2)] = inst_72972);

(statearr_73023_73050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (15))){
var inst_72999 = (state_73018[(2)]);
var state_73018__$1 = state_73018;
var statearr_73024_73051 = state_73018__$1;
(statearr_73024_73051[(2)] = inst_72999);

(statearr_73024_73051[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (13))){
var inst_72996 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_73018__$1 = state_73018;
var statearr_73025_73052 = state_73018__$1;
(statearr_73025_73052[(2)] = inst_72996);

(statearr_73025_73052[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (6))){
var inst_72983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72984 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72985 = [inst_72984,(0)];
var inst_72986 = (new cljs.core.PersistentVector(null,2,(5),inst_72983,inst_72985,null));
var state_73018__$1 = state_73018;
var statearr_73026_73053 = state_73018__$1;
(statearr_73026_73053[(2)] = inst_72986);

(statearr_73026_73053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (3))){
var inst_73016 = (state_73018[(2)]);
var state_73018__$1 = state_73018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73018__$1,inst_73016);
} else {
if((state_val_73019 === (12))){
var inst_72992 = (state_73018[(2)]);
var inst_72993 = fluree.db.util.async.throw_err(inst_72992);
var state_73018__$1 = state_73018;
var statearr_73027_73054 = state_73018__$1;
(statearr_73027_73054[(2)] = inst_72993);

(statearr_73027_73054[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (2))){
var _ = (function (){var statearr_73028 = state_73018;
(statearr_73028[(4)] = cljs.core.cons((5),(state_73018[(4)])));

return statearr_73028;
})();
var inst_72981 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73018__$1 = state_73018;
if(cljs.core.truth_(inst_72981)){
var statearr_73029_73055 = state_73018__$1;
(statearr_73029_73055[(1)] = (6));

} else {
var statearr_73030_73056 = state_73018__$1;
(statearr_73030_73056[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (11))){
var inst_73001 = (state_73018[(2)]);
var state_73018__$1 = state_73018;
var statearr_73032_73057 = state_73018__$1;
(statearr_73032_73057[(2)] = inst_73001);

(statearr_73032_73057[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (9))){
var inst_72990 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_73018__$1 = state_73018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73018__$1,(12),inst_72990);
} else {
if((state_val_73019 === (5))){
var _ = (function (){var statearr_73033 = state_73018;
(statearr_73033[(4)] = cljs.core.rest((state_73018[(4)])));

return statearr_73033;
})();
var state_73018__$1 = state_73018;
var ex73031 = (state_73018__$1[(2)]);
var statearr_73034_73058 = state_73018__$1;
(statearr_73034_73058[(5)] = ex73031);


if((ex73031 instanceof Error)){
var statearr_73035_73059 = state_73018__$1;
(statearr_73035_73059[(1)] = (4));

(statearr_73035_73059[(5)] = null);

} else {
throw ex73031;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (14))){
var state_73018__$1 = state_73018;
var statearr_73036_73060 = state_73018__$1;
(statearr_73036_73060[(2)] = null);

(statearr_73036_73060[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (10))){
var state_73018__$1 = state_73018;
var statearr_73037_73061 = state_73018__$1;
(statearr_73037_73061[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73019 === (8))){
var inst_73003 = (state_73018[(2)]);
var inst_73004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73003,(0),null);
var inst_73005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73003,(1),null);
var inst_73006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73007 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73008 = ["?user_id","?ctx",inst_73004];
var inst_73009 = cljs.core.PersistentHashMap.fromArrays(inst_73007,inst_73008);
var inst_73010 = ((10) + inst_73005);
var inst_73011 = [inst_73009,inst_73010];
var inst_73012 = (new cljs.core.PersistentVector(null,2,(5),inst_73006,inst_73011,null));
var inst_73013 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73012);
var _ = (function (){var statearr_73039 = state_73018;
(statearr_73039[(4)] = cljs.core.rest((state_73018[(4)])));

return statearr_73039;
})();
var state_73018__$1 = (function (){var statearr_73040 = state_73018;
(statearr_73040[(7)] = inst_73013);

return statearr_73040;
})();
var statearr_73041_73062 = state_73018__$1;
(statearr_73041_73062[(2)] = inst_73004);

(statearr_73041_73062[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0 = (function (){
var statearr_73042 = [null,null,null,null,null,null,null,null];
(statearr_73042[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__);

(statearr_73042[(1)] = (1));

return statearr_73042;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1 = (function (state_73018){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73018);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73043){var ex__13886__auto__ = e73043;
var statearr_73044_73063 = state_73018;
(statearr_73044_73063[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73018[(4)]))){
var statearr_73045_73064 = state_73018;
(statearr_73045_73064[(1)] = cljs.core.first((state_73018[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73065 = state_73018;
state_73018 = G__73065;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__ = function(state_73018){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1.call(this,state_73018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73046 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73046[(6)] = c__13957__auto__);

return statearr_73046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73093){
var state_val_73094 = (state_73093[(1)]);
if((state_val_73094 === (7))){
var inst_73086 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_73093__$1 = state_73093;
var statearr_73095_73114 = state_73093__$1;
(statearr_73095_73114[(2)] = inst_73086);

(statearr_73095_73114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (1))){
var state_73093__$1 = state_73093;
var statearr_73096_73115 = state_73093__$1;
(statearr_73096_73115[(2)] = null);

(statearr_73096_73115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (4))){
var inst_73066 = (state_73093[(2)]);
var state_73093__$1 = state_73093;
var statearr_73097_73116 = state_73093__$1;
(statearr_73097_73116[(2)] = inst_73066);

(statearr_73097_73116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (6))){
var inst_73074 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_73093__$1 = state_73093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73093__$1,(9),inst_73074);
} else {
if((state_val_73094 === (3))){
var inst_73091 = (state_73093[(2)]);
var state_73093__$1 = state_73093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73093__$1,inst_73091);
} else {
if((state_val_73094 === (2))){
var _ = (function (){var statearr_73099 = state_73093;
(statearr_73099[(4)] = cljs.core.cons((5),(state_73093[(4)])));

return statearr_73099;
})();
var inst_73072 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73093__$1 = state_73093;
if(cljs.core.truth_(inst_73072)){
var statearr_73100_73117 = state_73093__$1;
(statearr_73100_73117[(1)] = (6));

} else {
var statearr_73101_73118 = state_73093__$1;
(statearr_73101_73118[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (9))){
var inst_73076 = (state_73093[(2)]);
var inst_73077 = fluree.db.util.async.throw_err(inst_73076);
var inst_73078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73079 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73080 = ["?auth_id","?ctx",inst_73077];
var inst_73081 = cljs.core.PersistentHashMap.fromArrays(inst_73079,inst_73080);
var inst_73082 = [inst_73081,(10)];
var inst_73083 = (new cljs.core.PersistentVector(null,2,(5),inst_73078,inst_73082,null));
var inst_73084 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73083);
var state_73093__$1 = (function (){var statearr_73102 = state_73093;
(statearr_73102[(7)] = inst_73084);

return statearr_73102;
})();
var statearr_73103_73119 = state_73093__$1;
(statearr_73103_73119[(2)] = inst_73077);

(statearr_73103_73119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (5))){
var _ = (function (){var statearr_73104 = state_73093;
(statearr_73104[(4)] = cljs.core.rest((state_73093[(4)])));

return statearr_73104;
})();
var state_73093__$1 = state_73093;
var ex73098 = (state_73093__$1[(2)]);
var statearr_73105_73120 = state_73093__$1;
(statearr_73105_73120[(5)] = ex73098);


if((ex73098 instanceof Error)){
var statearr_73106_73121 = state_73093__$1;
(statearr_73106_73121[(1)] = (4));

(statearr_73106_73121[(5)] = null);

} else {
throw ex73098;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73094 === (8))){
var inst_73088 = (state_73093[(2)]);
var _ = (function (){var statearr_73107 = state_73093;
(statearr_73107[(4)] = cljs.core.rest((state_73093[(4)])));

return statearr_73107;
})();
var state_73093__$1 = state_73093;
var statearr_73108_73122 = state_73093__$1;
(statearr_73108_73122[(2)] = inst_73088);

(statearr_73108_73122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0 = (function (){
var statearr_73109 = [null,null,null,null,null,null,null,null];
(statearr_73109[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__);

(statearr_73109[(1)] = (1));

return statearr_73109;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1 = (function (state_73093){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73093);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73110){var ex__13886__auto__ = e73110;
var statearr_73111_73123 = state_73093;
(statearr_73111_73123[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73093[(4)]))){
var statearr_73112_73124 = state_73093;
(statearr_73112_73124[(1)] = cljs.core.first((state_73093[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73125 = state_73093;
state_73093 = G__73125;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__ = function(state_73093){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1.call(this,state_73093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73113 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73113[(6)] = c__13957__auto__);

return statearr_73113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__73127 = arguments.length;
switch (G__73127) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73169){
var state_val_73170 = (state_73169[(1)]);
if((state_val_73170 === (7))){
var state_73169__$1 = state_73169;
var statearr_73171_73201 = state_73169__$1;
(statearr_73171_73201[(2)] = seed);

(statearr_73171_73201[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (1))){
var state_73169__$1 = state_73169;
var statearr_73172_73202 = state_73169__$1;
(statearr_73172_73202[(2)] = null);

(statearr_73172_73202[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (4))){
var inst_73128 = (state_73169[(2)]);
var state_73169__$1 = state_73169;
var statearr_73173_73203 = state_73169__$1;
(statearr_73173_73203[(2)] = inst_73128);

(statearr_73173_73203[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (15))){
var state_73169__$1 = state_73169;
var statearr_73174_73204 = state_73169__$1;
(statearr_73174_73204[(2)] = (10));

(statearr_73174_73204[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (13))){
var inst_73145 = (state_73169[(2)]);
var inst_73146 = fluree.db.util.async.throw_err(inst_73145);
var state_73169__$1 = state_73169;
var statearr_73175_73205 = state_73169__$1;
(statearr_73175_73205[(2)] = inst_73146);

(statearr_73175_73205[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (6))){
var state_73169__$1 = state_73169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73169__$1,(9),seed);
} else {
if((state_val_73170 === (3))){
var inst_73167 = (state_73169[(2)]);
var state_73169__$1 = state_73169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73169__$1,inst_73167);
} else {
if((state_val_73170 === (12))){
var inst_73149 = (state_73169[(7)]);
var inst_73149__$1 = (state_73169[(2)]);
var state_73169__$1 = (function (){var statearr_73176 = state_73169;
(statearr_73176[(7)] = inst_73149__$1);

return statearr_73176;
})();
if(cljs.core.truth_(inst_73149__$1)){
var statearr_73177_73206 = state_73169__$1;
(statearr_73177_73206[(1)] = (14));

} else {
var statearr_73178_73207 = state_73169__$1;
(statearr_73178_73207[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (2))){
var _ = (function (){var statearr_73179 = state_73169;
(statearr_73179[(4)] = cljs.core.cons((5),(state_73169[(4)])));

return statearr_73179;
})();
var inst_73134 = fluree.db.util.async.channel_QMARK_(seed);
var state_73169__$1 = state_73169;
if(inst_73134){
var statearr_73180_73208 = state_73169__$1;
(statearr_73180_73208[(1)] = (6));

} else {
var statearr_73181_73209 = state_73169__$1;
(statearr_73181_73209[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (11))){
var state_73169__$1 = state_73169;
var statearr_73183_73210 = state_73169__$1;
(statearr_73183_73210[(2)] = max);

(statearr_73183_73210[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (9))){
var inst_73137 = (state_73169[(2)]);
var inst_73138 = fluree.db.util.async.throw_err(inst_73137);
var state_73169__$1 = state_73169;
var statearr_73184_73211 = state_73169__$1;
(statearr_73184_73211[(2)] = inst_73138);

(statearr_73184_73211[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (5))){
var _ = (function (){var statearr_73185 = state_73169;
(statearr_73185[(4)] = cljs.core.rest((state_73169[(4)])));

return statearr_73185;
})();
var state_73169__$1 = state_73169;
var ex73182 = (state_73169__$1[(2)]);
var statearr_73186_73212 = state_73169__$1;
(statearr_73186_73212[(5)] = ex73182);


if((ex73182 instanceof Error)){
var statearr_73187_73213 = state_73169__$1;
(statearr_73187_73213[(1)] = (4));

(statearr_73187_73213[(5)] = null);

} else {
throw ex73182;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (14))){
var inst_73149 = (state_73169[(7)]);
var state_73169__$1 = state_73169;
var statearr_73188_73214 = state_73169__$1;
(statearr_73188_73214[(2)] = inst_73149);

(statearr_73188_73214[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (16))){
var inst_73141 = (state_73169[(8)]);
var inst_73153 = (state_73169[(2)]);
var inst_73154 = fluree.db.dbfunctions.internal.rand(inst_73141,inst_73153);
var inst_73155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73156 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73158 = [max,seed];
var inst_73159 = (new cljs.core.PersistentVector(null,2,(5),inst_73157,inst_73158,null));
var inst_73160 = ["rand",inst_73159,inst_73154];
var inst_73161 = cljs.core.PersistentHashMap.fromArrays(inst_73156,inst_73160);
var inst_73162 = [inst_73161,(10)];
var inst_73163 = (new cljs.core.PersistentVector(null,2,(5),inst_73155,inst_73162,null));
var inst_73164 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73163);
var _ = (function (){var statearr_73189 = state_73169;
(statearr_73189[(4)] = cljs.core.rest((state_73169[(4)])));

return statearr_73189;
})();
var state_73169__$1 = (function (){var statearr_73190 = state_73169;
(statearr_73190[(9)] = inst_73164);

return statearr_73190;
})();
var statearr_73191_73215 = state_73169__$1;
(statearr_73191_73215[(2)] = inst_73154);

(statearr_73191_73215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73170 === (10))){
var state_73169__$1 = state_73169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73169__$1,(13),max);
} else {
if((state_val_73170 === (8))){
var inst_73141 = (state_73169[(2)]);
var inst_73142 = fluree.db.util.async.channel_QMARK_(max);
var state_73169__$1 = (function (){var statearr_73192 = state_73169;
(statearr_73192[(8)] = inst_73141);

return statearr_73192;
})();
if(inst_73142){
var statearr_73193_73216 = state_73169__$1;
(statearr_73193_73216[(1)] = (10));

} else {
var statearr_73194_73217 = state_73169__$1;
(statearr_73194_73217[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__13883__auto____0 = (function (){
var statearr_73195 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73195[(0)] = fluree$db$dbfunctions$fns$state_machine__13883__auto__);

(statearr_73195[(1)] = (1));

return statearr_73195;
});
var fluree$db$dbfunctions$fns$state_machine__13883__auto____1 = (function (state_73169){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73169);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73196){var ex__13886__auto__ = e73196;
var statearr_73197_73218 = state_73169;
(statearr_73197_73218[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73169[(4)]))){
var statearr_73198_73219 = state_73169;
(statearr_73198_73219[(1)] = cljs.core.first((state_73169[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73220 = state_73169;
state_73169 = G__73220;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__13883__auto__ = function(state_73169){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__13883__auto____1.call(this,state_73169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73199 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73199[(6)] = c__13957__auto__);

return statearr_73199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73241){
var state_val_73242 = (state_73241[(1)]);
if((state_val_73242 === (1))){
var state_73241__$1 = state_73241;
var statearr_73243_73258 = state_73241__$1;
(statearr_73243_73258[(2)] = null);

(statearr_73243_73258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73242 === (2))){
var _ = (function (){var statearr_73244 = state_73241;
(statearr_73244[(4)] = cljs.core.cons((5),(state_73241[(4)])));

return statearr_73244;
})();
var inst_73227 = fluree.db.util.core.random_uuid();
var inst_73228 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73227);
var inst_73229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73230 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73231 = cljs.core.PersistentVector.EMPTY;
var inst_73232 = ["uuid",inst_73231,inst_73228];
var inst_73233 = cljs.core.PersistentHashMap.fromArrays(inst_73230,inst_73232);
var inst_73234 = [inst_73233,(10)];
var inst_73235 = (new cljs.core.PersistentVector(null,2,(5),inst_73229,inst_73234,null));
var inst_73236 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73235);
var ___$1 = (function (){var statearr_73245 = state_73241;
(statearr_73245[(4)] = cljs.core.rest((state_73241[(4)])));

return statearr_73245;
})();
var state_73241__$1 = (function (){var statearr_73246 = state_73241;
(statearr_73246[(7)] = inst_73236);

return statearr_73246;
})();
var statearr_73247_73259 = state_73241__$1;
(statearr_73247_73259[(2)] = inst_73228);

(statearr_73247_73259[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73242 === (3))){
var inst_73239 = (state_73241[(2)]);
var state_73241__$1 = state_73241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73241__$1,inst_73239);
} else {
if((state_val_73242 === (4))){
var inst_73221 = (state_73241[(2)]);
var state_73241__$1 = state_73241;
var statearr_73249_73260 = state_73241__$1;
(statearr_73249_73260[(2)] = inst_73221);

(statearr_73249_73260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73242 === (5))){
var _ = (function (){var statearr_73250 = state_73241;
(statearr_73250[(4)] = cljs.core.rest((state_73241[(4)])));

return statearr_73250;
})();
var state_73241__$1 = state_73241;
var ex73248 = (state_73241__$1[(2)]);
var statearr_73251_73261 = state_73241__$1;
(statearr_73251_73261[(5)] = ex73248);


if((ex73248 instanceof Error)){
var statearr_73252_73262 = state_73241__$1;
(statearr_73252_73262[(1)] = (4));

(statearr_73252_73262[(5)] = null);

} else {
throw ex73248;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0 = (function (){
var statearr_73253 = [null,null,null,null,null,null,null,null];
(statearr_73253[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__);

(statearr_73253[(1)] = (1));

return statearr_73253;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1 = (function (state_73241){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73241);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73254){var ex__13886__auto__ = e73254;
var statearr_73255_73263 = state_73241;
(statearr_73255_73263[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73241[(4)]))){
var statearr_73256_73264 = state_73241;
(statearr_73256_73264[(1)] = cljs.core.first((state_73241[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73265 = state_73241;
state_73241 = G__73265;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__ = function(state_73241){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1.call(this,state_73241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73257 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73257[(6)] = c__13957__auto__);

return statearr_73257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73295){
var state_val_73296 = (state_73295[(1)]);
if((state_val_73296 === (7))){
var state_73295__$1 = state_73295;
var statearr_73297_73316 = state_73295__$1;
(statearr_73297_73316[(2)] = num);

(statearr_73297_73316[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (1))){
var state_73295__$1 = state_73295;
var statearr_73298_73317 = state_73295__$1;
(statearr_73298_73317[(2)] = null);

(statearr_73298_73317[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (4))){
var inst_73266 = (state_73295[(2)]);
var state_73295__$1 = state_73295;
var statearr_73299_73318 = state_73295__$1;
(statearr_73299_73318[(2)] = inst_73266);

(statearr_73299_73318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (6))){
var state_73295__$1 = state_73295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73295__$1,(9),num);
} else {
if((state_val_73296 === (3))){
var inst_73293 = (state_73295[(2)]);
var state_73295__$1 = state_73295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73295__$1,inst_73293);
} else {
if((state_val_73296 === (2))){
var _ = (function (){var statearr_73301 = state_73295;
(statearr_73301[(4)] = cljs.core.cons((5),(state_73295[(4)])));

return statearr_73301;
})();
var inst_73272 = fluree.db.util.async.channel_QMARK_(num);
var state_73295__$1 = state_73295;
if(inst_73272){
var statearr_73302_73319 = state_73295__$1;
(statearr_73302_73319[(1)] = (6));

} else {
var statearr_73303_73320 = state_73295__$1;
(statearr_73303_73320[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (9))){
var inst_73275 = (state_73295[(2)]);
var inst_73276 = fluree.db.util.async.throw_err(inst_73275);
var state_73295__$1 = state_73295;
var statearr_73304_73321 = state_73295__$1;
(statearr_73304_73321[(2)] = inst_73276);

(statearr_73304_73321[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (5))){
var _ = (function (){var statearr_73305 = state_73295;
(statearr_73305[(4)] = cljs.core.rest((state_73295[(4)])));

return statearr_73305;
})();
var state_73295__$1 = state_73295;
var ex73300 = (state_73295__$1[(2)]);
var statearr_73306_73322 = state_73295__$1;
(statearr_73306_73322[(5)] = ex73300);


if((ex73300 instanceof Error)){
var statearr_73307_73323 = state_73295__$1;
(statearr_73307_73323[(1)] = (4));

(statearr_73307_73323[(5)] = null);

} else {
throw ex73300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73296 === (8))){
var inst_73279 = (state_73295[(2)]);
var inst_73280 = fluree.db.dbfunctions.internal.ceil(inst_73279);
var inst_73281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73282 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73284 = [fluree.db.dbfunctions.fns.ceil];
var inst_73285 = (new cljs.core.PersistentVector(null,1,(5),inst_73283,inst_73284,null));
var inst_73286 = ["",inst_73285,inst_73280];
var inst_73287 = cljs.core.PersistentHashMap.fromArrays(inst_73282,inst_73286);
var inst_73288 = [inst_73287,(10)];
var inst_73289 = (new cljs.core.PersistentVector(null,2,(5),inst_73281,inst_73288,null));
var inst_73290 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73289);
var _ = (function (){var statearr_73308 = state_73295;
(statearr_73308[(4)] = cljs.core.rest((state_73295[(4)])));

return statearr_73308;
})();
var state_73295__$1 = (function (){var statearr_73309 = state_73295;
(statearr_73309[(7)] = inst_73290);

return statearr_73309;
})();
var statearr_73310_73324 = state_73295__$1;
(statearr_73310_73324[(2)] = inst_73280);

(statearr_73310_73324[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0 = (function (){
var statearr_73311 = [null,null,null,null,null,null,null,null];
(statearr_73311[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__);

(statearr_73311[(1)] = (1));

return statearr_73311;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1 = (function (state_73295){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73295);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73312){var ex__13886__auto__ = e73312;
var statearr_73313_73325 = state_73295;
(statearr_73313_73325[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73295[(4)]))){
var statearr_73314_73326 = state_73295;
(statearr_73314_73326[(1)] = cljs.core.first((state_73295[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73327 = state_73295;
state_73295 = G__73327;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__ = function(state_73295){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1.call(this,state_73295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73315 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73315[(6)] = c__13957__auto__);

return statearr_73315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73357){
var state_val_73358 = (state_73357[(1)]);
if((state_val_73358 === (7))){
var state_73357__$1 = state_73357;
var statearr_73359_73378 = state_73357__$1;
(statearr_73359_73378[(2)] = num);

(statearr_73359_73378[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (1))){
var state_73357__$1 = state_73357;
var statearr_73360_73379 = state_73357__$1;
(statearr_73360_73379[(2)] = null);

(statearr_73360_73379[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (4))){
var inst_73328 = (state_73357[(2)]);
var state_73357__$1 = state_73357;
var statearr_73361_73380 = state_73357__$1;
(statearr_73361_73380[(2)] = inst_73328);

(statearr_73361_73380[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (6))){
var state_73357__$1 = state_73357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73357__$1,(9),num);
} else {
if((state_val_73358 === (3))){
var inst_73355 = (state_73357[(2)]);
var state_73357__$1 = state_73357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73357__$1,inst_73355);
} else {
if((state_val_73358 === (2))){
var _ = (function (){var statearr_73363 = state_73357;
(statearr_73363[(4)] = cljs.core.cons((5),(state_73357[(4)])));

return statearr_73363;
})();
var inst_73334 = fluree.db.util.async.channel_QMARK_(num);
var state_73357__$1 = state_73357;
if(inst_73334){
var statearr_73364_73381 = state_73357__$1;
(statearr_73364_73381[(1)] = (6));

} else {
var statearr_73365_73382 = state_73357__$1;
(statearr_73365_73382[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (9))){
var inst_73337 = (state_73357[(2)]);
var inst_73338 = fluree.db.util.async.throw_err(inst_73337);
var state_73357__$1 = state_73357;
var statearr_73366_73383 = state_73357__$1;
(statearr_73366_73383[(2)] = inst_73338);

(statearr_73366_73383[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (5))){
var _ = (function (){var statearr_73367 = state_73357;
(statearr_73367[(4)] = cljs.core.rest((state_73357[(4)])));

return statearr_73367;
})();
var state_73357__$1 = state_73357;
var ex73362 = (state_73357__$1[(2)]);
var statearr_73368_73384 = state_73357__$1;
(statearr_73368_73384[(5)] = ex73362);


if((ex73362 instanceof Error)){
var statearr_73369_73385 = state_73357__$1;
(statearr_73369_73385[(1)] = (4));

(statearr_73369_73385[(5)] = null);

} else {
throw ex73362;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73358 === (8))){
var inst_73341 = (state_73357[(2)]);
var inst_73342 = fluree.db.dbfunctions.internal.floor(inst_73341);
var inst_73343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73344 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73346 = [fluree.db.dbfunctions.fns.floor];
var inst_73347 = (new cljs.core.PersistentVector(null,1,(5),inst_73345,inst_73346,null));
var inst_73348 = ["",inst_73347,inst_73342];
var inst_73349 = cljs.core.PersistentHashMap.fromArrays(inst_73344,inst_73348);
var inst_73350 = [inst_73349,(10)];
var inst_73351 = (new cljs.core.PersistentVector(null,2,(5),inst_73343,inst_73350,null));
var inst_73352 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73351);
var _ = (function (){var statearr_73370 = state_73357;
(statearr_73370[(4)] = cljs.core.rest((state_73357[(4)])));

return statearr_73370;
})();
var state_73357__$1 = (function (){var statearr_73371 = state_73357;
(statearr_73371[(7)] = inst_73352);

return statearr_73371;
})();
var statearr_73372_73386 = state_73357__$1;
(statearr_73372_73386[(2)] = inst_73342);

(statearr_73372_73386[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0 = (function (){
var statearr_73373 = [null,null,null,null,null,null,null,null];
(statearr_73373[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__);

(statearr_73373[(1)] = (1));

return statearr_73373;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1 = (function (state_73357){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73357);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73374){var ex__13886__auto__ = e73374;
var statearr_73375_73387 = state_73357;
(statearr_73375_73387[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73357[(4)]))){
var statearr_73376_73388 = state_73357;
(statearr_73376_73388[(1)] = cljs.core.first((state_73357[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73389 = state_73357;
state_73357 = G__73389;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__ = function(state_73357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1.call(this,state_73357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73377 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73377[(6)] = c__13957__auto__);

return statearr_73377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73414){
var state_val_73415 = (state_73414[(1)]);
if((state_val_73415 === (1))){
var state_73414__$1 = state_73414;
var statearr_73416_73431 = state_73414__$1;
(statearr_73416_73431[(2)] = null);

(statearr_73416_73431[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73415 === (2))){
var _ = (function (){var statearr_73417 = state_73414;
(statearr_73417[(4)] = cljs.core.cons((5),(state_73414[(4)])));

return statearr_73417;
})();
var inst_73396 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_73414__$1 = state_73414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73414__$1,(6),inst_73396);
} else {
if((state_val_73415 === (3))){
var inst_73412 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73414__$1,inst_73412);
} else {
if((state_val_73415 === (4))){
var inst_73390 = (state_73414[(2)]);
var state_73414__$1 = state_73414;
var statearr_73419_73432 = state_73414__$1;
(statearr_73419_73432[(2)] = inst_73390);

(statearr_73419_73432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73415 === (5))){
var _ = (function (){var statearr_73420 = state_73414;
(statearr_73420[(4)] = cljs.core.rest((state_73414[(4)])));

return statearr_73420;
})();
var state_73414__$1 = state_73414;
var ex73418 = (state_73414__$1[(2)]);
var statearr_73421_73433 = state_73414__$1;
(statearr_73421_73433[(5)] = ex73418);


if((ex73418 instanceof Error)){
var statearr_73422_73434 = state_73414__$1;
(statearr_73422_73434[(1)] = (4));

(statearr_73422_73434[(5)] = null);

} else {
throw ex73418;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73415 === (6))){
var inst_73398 = (state_73414[(2)]);
var inst_73399 = fluree.db.util.async.throw_err(inst_73398);
var inst_73400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73401 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73403 = [compare_val,new_val];
var inst_73404 = (new cljs.core.PersistentVector(null,2,(5),inst_73402,inst_73403,null));
var inst_73405 = ["",inst_73404,inst_73399];
var inst_73406 = cljs.core.PersistentHashMap.fromArrays(inst_73401,inst_73405);
var inst_73407 = [inst_73406,(10)];
var inst_73408 = (new cljs.core.PersistentVector(null,2,(5),inst_73400,inst_73407,null));
var inst_73409 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73408);
var _ = (function (){var statearr_73423 = state_73414;
(statearr_73423[(4)] = cljs.core.rest((state_73414[(4)])));

return statearr_73423;
})();
var state_73414__$1 = (function (){var statearr_73424 = state_73414;
(statearr_73424[(7)] = inst_73409);

return statearr_73424;
})();
var statearr_73425_73435 = state_73414__$1;
(statearr_73425_73435[(2)] = inst_73399);

(statearr_73425_73435[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0 = (function (){
var statearr_73426 = [null,null,null,null,null,null,null,null];
(statearr_73426[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__);

(statearr_73426[(1)] = (1));

return statearr_73426;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1 = (function (state_73414){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73414);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73427){var ex__13886__auto__ = e73427;
var statearr_73428_73436 = state_73414;
(statearr_73428_73436[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73414[(4)]))){
var statearr_73429_73437 = state_73414;
(statearr_73429_73437[(1)] = cljs.core.first((state_73414[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73438 = state_73414;
state_73414 = G__73438;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__ = function(state_73414){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1.call(this,state_73414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73430 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73430[(6)] = c__13957__auto__);

return statearr_73430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
