// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
if(typeof value === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return false;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,811,null,811,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,777,null,777,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,787,null,787,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,799,null,799,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__73442 = cljs.core.meta(f);
var map__73442__$1 = cljs.core.__destructure_map(map__73442);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73442__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73442__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4149__auto__ = (function (){var G__73448 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__73447 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__73447.cljs$core$IFn$_invoke$arity$1 ? fexpr__73447.cljs$core$IFn$_invoke$arity$1(G__73448) : fexpr__73447.call(null,G__73448));
})();
if(cljs.core.truth_(and__4149__auto__)){
var G__73450 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__73449 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__73449.cljs$core$IFn$_invoke$arity$1 ? fexpr__73449.cljs$core$IFn$_invoke$arity$1(G__73450) : fexpr__73449.call(null,G__73450));
} else {
return and__4149__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__73441_SHARP_){
return (cljs.core.count(p1__73441_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73544){
var state_val_73545 = (state_73544[(1)]);
if((state_val_73545 === (7))){
var state_73544__$1 = state_73544;
var statearr_73546_73588 = state_73544__$1;
(statearr_73546_73588[(2)] = null);

(statearr_73546_73588[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (20))){
var inst_73526 = (state_73544[(7)]);
var inst_73529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73530 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_73531 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_73532 = [inst_73530,inst_73531,fn_name];
var inst_73533 = (new cljs.core.PersistentVector(null,3,(5),inst_73529,inst_73532,null));
var inst_73534 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_73533,inst_73526);
var state_73544__$1 = state_73544;
var statearr_73547_73589 = state_73544__$1;
(statearr_73547_73589[(2)] = inst_73534);

(statearr_73547_73589[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (1))){
var state_73544__$1 = state_73544;
var statearr_73548_73590 = state_73544__$1;
(statearr_73548_73590[(2)] = null);

(statearr_73548_73590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (4))){
var inst_73451 = (state_73544[(2)]);
var state_73544__$1 = state_73544;
var statearr_73549_73591 = state_73544__$1;
(statearr_73549_73591[(2)] = inst_73451);

(statearr_73549_73591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (15))){
var inst_73490 = (state_73544[(8)]);
var inst_73489 = (state_73544[(2)]);
var inst_73490__$1 = fluree.db.util.async.throw_err(inst_73489);
var inst_73491 = cljs.core.empty_QMARK_(inst_73490__$1);
var state_73544__$1 = (function (){var statearr_73550 = state_73544;
(statearr_73550[(8)] = inst_73490__$1);

return statearr_73550;
})();
if(inst_73491){
var statearr_73551_73592 = state_73544__$1;
(statearr_73551_73592[(1)] = (16));

} else {
var statearr_73552_73593 = state_73544__$1;
(statearr_73552_73593[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (21))){
var state_73544__$1 = state_73544;
var statearr_73553_73594 = state_73544__$1;
(statearr_73553_73594[(2)] = null);

(statearr_73553_73594[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (13))){
var inst_73486 = (state_73544[(9)]);
var inst_73477 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_73478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73479 = ["_fn/params","_fn/code","_fn/spec"];
var inst_73480 = (new cljs.core.PersistentVector(null,3,(5),inst_73478,inst_73479,null));
var inst_73481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73482 = cljs.core.name(fn_name);
var inst_73483 = ["_fn/name",inst_73482];
var inst_73484 = (new cljs.core.PersistentVector(null,2,(5),inst_73481,inst_73483,null));
var inst_73485 = [inst_73480,inst_73484];
var inst_73486__$1 = cljs.core.PersistentHashMap.fromArrays(inst_73477,inst_73485);
var inst_73487 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_73486__$1);
var state_73544__$1 = (function (){var statearr_73554 = state_73544;
(statearr_73554[(9)] = inst_73486__$1);

return statearr_73554;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73544__$1,(15),inst_73487);
} else {
if((state_val_73545 === (22))){
var inst_73526 = (state_73544[(7)]);
var inst_73537 = (state_73544[(2)]);
var state_73544__$1 = (function (){var statearr_73555 = state_73544;
(statearr_73555[(10)] = inst_73537);

return statearr_73555;
})();
var statearr_73556_73595 = state_73544__$1;
(statearr_73556_73595[(2)] = inst_73526);

(statearr_73556_73595[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (6))){
var inst_73460 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_73461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73462 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_73463 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_73464 = [inst_73462,inst_73463,fn_name];
var inst_73465 = (new cljs.core.PersistentVector(null,3,(5),inst_73461,inst_73464,null));
var inst_73466 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73460,inst_73465);
var state_73544__$1 = state_73544;
var statearr_73557_73596 = state_73544__$1;
(statearr_73557_73596[(2)] = inst_73466);

(statearr_73557_73596[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (17))){
var state_73544__$1 = state_73544;
var statearr_73558_73597 = state_73544__$1;
(statearr_73558_73597[(2)] = null);

(statearr_73558_73597[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (3))){
var inst_73542 = (state_73544[(2)]);
var state_73544__$1 = state_73544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73544__$1,inst_73542);
} else {
if((state_val_73545 === (12))){
var inst_73473 = (state_73544[(11)]);
var inst_73475 = fluree.db.dbfunctions.core.resolve_local_fn(inst_73473);
var state_73544__$1 = state_73544;
var statearr_73559_73598 = state_73544__$1;
(statearr_73559_73598[(2)] = inst_73475);

(statearr_73559_73598[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (2))){
var inst_73457 = (state_73544[(12)]);
var _ = (function (){var statearr_73560 = state_73544;
(statearr_73560[(4)] = cljs.core.cons((5),(state_73544[(4)])));

return statearr_73560;
})();
var inst_73457__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_73458 = cljs.core.not(inst_73457__$1);
var state_73544__$1 = (function (){var statearr_73561 = state_73544;
(statearr_73561[(12)] = inst_73457__$1);

return statearr_73561;
})();
if(inst_73458){
var statearr_73562_73599 = state_73544__$1;
(statearr_73562_73599[(1)] = (6));

} else {
var statearr_73563_73600 = state_73544__$1;
(statearr_73563_73600[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (19))){
var inst_73457 = (state_73544[(12)]);
var inst_73473 = (state_73544[(11)]);
var inst_73490 = (state_73544[(8)]);
var inst_73502 = (state_73544[(13)]);
var inst_73469 = (state_73544[(14)]);
var inst_73504 = (state_73544[(15)]);
var inst_73486 = (state_73544[(9)]);
var inst_73509 = (state_73544[(2)]);
var inst_73510 = fluree.db.util.async.throw_err(inst_73509);
var inst_73511 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73490,"_fn/spec");
var inst_73512 = cljs.core.PersistentVector.EMPTY;
var inst_73513 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73514 = (function (){var res = inst_73490;
var query = inst_73486;
var forward_time_travel_db_QMARK_ = inst_73457;
var _ = inst_73502;
var params = inst_73504;
var temp__5751__auto__ = inst_73473;
var or__4160__auto__ = inst_73469;
var spec = inst_73511;
var code = inst_73510;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_73515 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73514,inst_73504);
var inst_73516 = cljs.core.cons(inst_73513,inst_73515);
var inst_73517 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_73512,inst_73516);
var inst_73518 = fluree.db.dbfunctions.core.build_fn(inst_73517,inst_73510);
var inst_73519 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_73520 = cljs.core.count(inst_73504);
var inst_73521 = [inst_73520];
var inst_73522 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73521);
var inst_73523 = [inst_73518,inst_73504,inst_73522,false,inst_73511,null];
var inst_73524 = cljs.core.PersistentHashMap.fromArrays(inst_73519,inst_73523);
var state_73544__$1 = state_73544;
var statearr_73564_73601 = state_73544__$1;
(statearr_73564_73601[(2)] = inst_73524);

(statearr_73564_73601[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (11))){
var inst_73539 = (state_73544[(2)]);
var _ = (function (){var statearr_73566 = state_73544;
(statearr_73566[(4)] = cljs.core.rest((state_73544[(4)])));

return statearr_73566;
})();
var state_73544__$1 = state_73544;
var statearr_73567_73602 = state_73544__$1;
(statearr_73567_73602[(2)] = inst_73539);

(statearr_73567_73602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (9))){
var inst_73469 = (state_73544[(14)]);
var state_73544__$1 = state_73544;
var statearr_73568_73603 = state_73544__$1;
(statearr_73568_73603[(2)] = inst_73469);

(statearr_73568_73603[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (5))){
var _ = (function (){var statearr_73569 = state_73544;
(statearr_73569[(4)] = cljs.core.rest((state_73544[(4)])));

return statearr_73569;
})();
var state_73544__$1 = state_73544;
var ex73565 = (state_73544__$1[(2)]);
var statearr_73570_73604 = state_73544__$1;
(statearr_73570_73604[(5)] = ex73565);


if((ex73565 instanceof Error)){
var statearr_73571_73605 = state_73544__$1;
(statearr_73571_73605[(1)] = (4));

(statearr_73571_73605[(5)] = null);

} else {
throw ex73565;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (14))){
var inst_73457 = (state_73544[(12)]);
var inst_73526 = (state_73544[(2)]);
var inst_73527 = cljs.core.not(inst_73457);
var state_73544__$1 = (function (){var statearr_73572 = state_73544;
(statearr_73572[(7)] = inst_73526);

return statearr_73572;
})();
if(inst_73527){
var statearr_73573_73606 = state_73544__$1;
(statearr_73573_73606[(1)] = (20));

} else {
var statearr_73574_73607 = state_73544__$1;
(statearr_73574_73607[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (16))){
var inst_73493 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_73494 = ["Unknown function: ",inst_73493].join('');
var inst_73495 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73496 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73497 = cljs.core.PersistentHashMap.fromArrays(inst_73495,inst_73496);
var inst_73498 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73494,inst_73497);
var inst_73499 = (function(){throw inst_73498})();
var state_73544__$1 = state_73544;
var statearr_73575_73608 = state_73544__$1;
(statearr_73575_73608[(2)] = inst_73499);

(statearr_73575_73608[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (10))){
var inst_73473 = (state_73544[(11)]);
var inst_73472 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var inst_73473__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,inst_73472);
var state_73544__$1 = (function (){var statearr_73576 = state_73544;
(statearr_73576[(11)] = inst_73473__$1);

return statearr_73576;
})();
if(cljs.core.truth_(inst_73473__$1)){
var statearr_73577_73609 = state_73544__$1;
(statearr_73577_73609[(1)] = (12));

} else {
var statearr_73578_73610 = state_73544__$1;
(statearr_73578_73610[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73545 === (18))){
var inst_73490 = (state_73544[(8)]);
var inst_73504 = (state_73544[(15)]);
var inst_73502 = (state_73544[(2)]);
var inst_73503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73490,"_fn/params");
var inst_73504__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_73503);
var inst_73505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73490,"_fn/code");
var inst_73506 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_73505);
var inst_73507 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73506,funType,inst_73504__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_73506,funType,inst_73504__$1));
var state_73544__$1 = (function (){var statearr_73579 = state_73544;
(statearr_73579[(13)] = inst_73502);

(statearr_73579[(15)] = inst_73504__$1);

return statearr_73579;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73544__$1,(19),inst_73507);
} else {
if((state_val_73545 === (8))){
var inst_73469 = (state_73544[(14)]);
var inst_73469__$1 = (state_73544[(2)]);
var state_73544__$1 = (function (){var statearr_73580 = state_73544;
(statearr_73580[(14)] = inst_73469__$1);

return statearr_73580;
})();
if(cljs.core.truth_(inst_73469__$1)){
var statearr_73581_73611 = state_73544__$1;
(statearr_73581_73611[(1)] = (9));

} else {
var statearr_73582_73612 = state_73544__$1;
(statearr_73582_73612[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_73583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73583[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__);

(statearr_73583[(1)] = (1));

return statearr_73583;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1 = (function (state_73544){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73544);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73584){var ex__13886__auto__ = e73584;
var statearr_73585_73613 = state_73544;
(statearr_73585_73613[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73544[(4)]))){
var statearr_73586_73614 = state_73544;
(statearr_73586_73614[(1)] = cljs.core.first((state_73544[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73615 = state_73544;
state_73544 = G__73615;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__ = function(state_73544){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1.call(this,state_73544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73587 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73587[(6)] = c__13957__auto__);

return statearr_73587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__73617 = arguments.length;
switch (G__73617) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__73621 = arguments.length;
switch (G__73621) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73744){
var state_val_73745 = (state_73744[(1)]);
if((state_val_73745 === (7))){
var inst_73739 = (state_73744[(2)]);
var _ = (function (){var statearr_73746 = state_73744;
(statearr_73746[(4)] = cljs.core.rest((state_73744[(4)])));

return statearr_73746;
})();
var state_73744__$1 = state_73744;
var statearr_73747_73817 = state_73744__$1;
(statearr_73747_73817[(2)] = inst_73739);

(statearr_73747_73817[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (20))){
var inst_73660 = (state_73744[(7)]);
var state_73744__$1 = state_73744;
var statearr_73748_73818 = state_73744__$1;
(statearr_73748_73818[(2)] = inst_73660);

(statearr_73748_73818[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (27))){
var inst_73647 = (state_73744[(8)]);
var inst_73673 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73674 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73647)," used in function.",inst_73673].join('');
var inst_73675 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73676 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73677 = cljs.core.PersistentHashMap.fromArrays(inst_73675,inst_73676);
var inst_73678 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73674,inst_73677);
var inst_73679 = (function(){throw inst_73678})();
var state_73744__$1 = state_73744;
var statearr_73749_73819 = state_73744__$1;
(statearr_73749_73819[(2)] = inst_73679);

(statearr_73749_73819[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (1))){
var state_73744__$1 = state_73744;
var statearr_73750_73820 = state_73744__$1;
(statearr_73750_73820[(2)] = null);

(statearr_73750_73820[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (24))){
var inst_73670 = (state_73744[(9)]);
var inst_73670__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_73744__$1 = (function (){var statearr_73751 = state_73744;
(statearr_73751[(9)] = inst_73670__$1);

return statearr_73751;
})();
if(inst_73670__$1){
var statearr_73752_73821 = state_73744__$1;
(statearr_73752_73821[(1)] = (26));

} else {
var statearr_73753_73822 = state_73744__$1;
(statearr_73753_73822[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (39))){
var inst_73647 = (state_73744[(8)]);
var inst_73705 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73647,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_73647,funType,params));
var state_73744__$1 = state_73744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73744__$1,(42),inst_73705);
} else {
if((state_val_73745 === (4))){
var inst_73622 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73754_73823 = state_73744__$1;
(statearr_73754_73823[(2)] = inst_73622);

(statearr_73754_73823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (15))){
var inst_73647 = (state_73744[(8)]);
var inst_73658 = (inst_73647 instanceof cljs.core.Symbol);
var state_73744__$1 = state_73744;
if(cljs.core.truth_(inst_73658)){
var statearr_73755_73824 = state_73744__$1;
(statearr_73755_73824[(1)] = (17));

} else {
var statearr_73756_73825 = state_73744__$1;
(statearr_73756_73825[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (21))){
var inst_73641 = (state_73744[(10)]);
var inst_73647 = (state_73744[(8)]);
var inst_73640 = (state_73744[(11)]);
var inst_73638 = (state_73744[(12)]);
var inst_73667 = (state_73744[(13)]);
var inst_73660 = (state_73744[(7)]);
var inst_73648 = (state_73744[(14)]);
var inst_73635 = (state_73744[(15)]);
var inst_73637 = (state_73744[(16)]);
var inst_73663 = [inst_73647];
var inst_73664 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73663);
var inst_73665 = (function (){var x = inst_73647;
var vec__73643 = inst_73640;
var r = inst_73648;
var first__73634 = inst_73637;
var acc = inst_73641;
var G__73631 = inst_73640;
var vec__73632 = inst_73635;
var or__4160__auto__ = inst_73660;
var seq__73644 = inst_73648;
var first__73645 = inst_73647;
var seq__73633 = inst_73638;
return (function (p1__73619_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73619_SHARP_);
});
})();
var inst_73666 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73665,params);
var inst_73667__$1 = cljs.core.some(inst_73664,inst_73666);
var state_73744__$1 = (function (){var statearr_73757 = state_73744;
(statearr_73757[(13)] = inst_73667__$1);

return statearr_73757;
})();
if(cljs.core.truth_(inst_73667__$1)){
var statearr_73758_73826 = state_73744__$1;
(statearr_73758_73826[(1)] = (23));

} else {
var statearr_73759_73827 = state_73744__$1;
(statearr_73759_73827[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (31))){
var inst_73727 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73760_73828 = state_73744__$1;
(statearr_73760_73828[(2)] = inst_73727);

(statearr_73760_73828[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (32))){
var inst_73647 = (state_73744[(8)]);
var inst_73695 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73647,funType,params);
var state_73744__$1 = state_73744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73744__$1,(35),inst_73695);
} else {
if((state_val_73745 === (40))){
var state_73744__$1 = state_73744;
var statearr_73761_73829 = state_73744__$1;
(statearr_73761_73829[(1)] = (43));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (33))){
var inst_73647 = (state_73744[(8)]);
var inst_73700 = (inst_73647 == null);
var state_73744__$1 = state_73744;
if(cljs.core.truth_(inst_73700)){
var statearr_73763_73830 = state_73744__$1;
(statearr_73763_73830[(1)] = (36));

} else {
var statearr_73764_73831 = state_73744__$1;
(statearr_73764_73831[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (13))){
var inst_73641 = (state_73744[(10)]);
var inst_73648 = (state_73744[(14)]);
var inst_73733 = (state_73744[(2)]);
var inst_73734 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73641,inst_73733);
var inst_73640 = inst_73648;
var inst_73641__$1 = inst_73734;
var state_73744__$1 = (function (){var statearr_73765 = state_73744;
(statearr_73765[(10)] = inst_73641__$1);

(statearr_73765[(11)] = inst_73640);

return statearr_73765;
})();
var statearr_73766_73832 = state_73744__$1;
(statearr_73766_73832[(2)] = null);

(statearr_73766_73832[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (22))){
var inst_73685 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73767_73833 = state_73744__$1;
(statearr_73767_73833[(2)] = inst_73685);

(statearr_73767_73833[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (36))){
var inst_73647 = (state_73744[(8)]);
var state_73744__$1 = state_73744;
var statearr_73768_73834 = state_73744__$1;
(statearr_73768_73834[(2)] = inst_73647);

(statearr_73768_73834[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (41))){
var inst_73721 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73769_73835 = state_73744__$1;
(statearr_73769_73835[(2)] = inst_73721);

(statearr_73769_73835[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (43))){
var inst_73647 = (state_73744[(8)]);
var inst_73711 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73647], 0));
var inst_73712 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73713 = ["Illegal element (",inst_73711,") in vector: ",inst_73712,"."].join('');
var inst_73714 = cljs.core.PersistentHashMap.EMPTY;
var inst_73715 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73713,inst_73714);
var inst_73716 = (function(){throw inst_73715})();
var state_73744__$1 = state_73744;
var statearr_73770_73836 = state_73744__$1;
(statearr_73770_73836[(2)] = inst_73716);

(statearr_73770_73836[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (29))){
var inst_73647 = (state_73744[(8)]);
var state_73744__$1 = state_73744;
var statearr_73771_73837 = state_73744__$1;
(statearr_73771_73837[(2)] = inst_73647);

(statearr_73771_73837[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (44))){
var state_73744__$1 = state_73744;
var statearr_73772_73838 = state_73744__$1;
(statearr_73772_73838[(2)] = null);

(statearr_73772_73838[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (6))){
var inst_73647 = (state_73744[(8)]);
var inst_73640 = (state_73744[(11)]);
var inst_73646 = cljs.core.seq(inst_73640);
var inst_73647__$1 = cljs.core.first(inst_73646);
var inst_73648 = cljs.core.next(inst_73646);
var inst_73649 = (inst_73647__$1 == null);
var state_73744__$1 = (function (){var statearr_73773 = state_73744;
(statearr_73773[(8)] = inst_73647__$1);

(statearr_73773[(14)] = inst_73648);

return statearr_73773;
})();
if(cljs.core.truth_(inst_73649)){
var statearr_73774_73839 = state_73744__$1;
(statearr_73774_73839[(1)] = (8));

} else {
var statearr_73775_73840 = state_73744__$1;
(statearr_73775_73840[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (28))){
var inst_73681 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73776_73841 = state_73744__$1;
(statearr_73776_73841[(2)] = inst_73681);

(statearr_73776_73841[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (25))){
var inst_73683 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73777_73842 = state_73744__$1;
(statearr_73777_73842[(2)] = inst_73683);

(statearr_73777_73842[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (34))){
var inst_73725 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73778_73843 = state_73744__$1;
(statearr_73778_73843[(2)] = inst_73725);

(statearr_73778_73843[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (17))){
var inst_73647 = (state_73744[(8)]);
var inst_73660 = (state_73744[(7)]);
var inst_73660__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73647) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73647));
var state_73744__$1 = (function (){var statearr_73779 = state_73744;
(statearr_73779[(7)] = inst_73660__$1);

return statearr_73779;
})();
if(cljs.core.truth_(inst_73660__$1)){
var statearr_73780_73844 = state_73744__$1;
(statearr_73780_73844[(1)] = (20));

} else {
var statearr_73781_73845 = state_73744__$1;
(statearr_73781_73845[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (3))){
var inst_73742 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73744__$1,inst_73742);
} else {
if((state_val_73745 === (12))){
var inst_73647 = (state_73744[(8)]);
var inst_73655 = typeof inst_73647 === 'number';
var state_73744__$1 = state_73744;
if(cljs.core.truth_(inst_73655)){
var statearr_73782_73846 = state_73744__$1;
(statearr_73782_73846[(1)] = (14));

} else {
var statearr_73783_73847 = state_73744__$1;
(statearr_73783_73847[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (2))){
var inst_73635 = (state_73744[(15)]);
var _ = (function (){var statearr_73784 = state_73744;
(statearr_73784[(4)] = cljs.core.cons((5),(state_73744[(4)])));

return statearr_73784;
})();
var inst_73635__$1 = vec;
var inst_73636 = cljs.core.seq(inst_73635__$1);
var inst_73637 = cljs.core.first(inst_73636);
var inst_73638 = cljs.core.next(inst_73636);
var inst_73639 = cljs.core.PersistentVector.EMPTY;
var inst_73640 = inst_73635__$1;
var inst_73641 = inst_73639;
var state_73744__$1 = (function (){var statearr_73785 = state_73744;
(statearr_73785[(10)] = inst_73641);

(statearr_73785[(11)] = inst_73640);

(statearr_73785[(12)] = inst_73638);

(statearr_73785[(15)] = inst_73635__$1);

(statearr_73785[(16)] = inst_73637);

return statearr_73785;
})();
var statearr_73786_73848 = state_73744__$1;
(statearr_73786_73848[(2)] = null);

(statearr_73786_73848[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (23))){
var inst_73667 = (state_73744[(13)]);
var state_73744__$1 = state_73744;
var statearr_73787_73849 = state_73744__$1;
(statearr_73787_73849[(2)] = inst_73667);

(statearr_73787_73849[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (35))){
var inst_73697 = (state_73744[(2)]);
var inst_73698 = fluree.db.util.async.throw_err(inst_73697);
var state_73744__$1 = state_73744;
var statearr_73788_73850 = state_73744__$1;
(statearr_73788_73850[(2)] = inst_73698);

(statearr_73788_73850[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (19))){
var inst_73729 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73789_73851 = state_73744__$1;
(statearr_73789_73851[(2)] = inst_73729);

(statearr_73789_73851[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (11))){
var inst_73647 = (state_73744[(8)]);
var state_73744__$1 = state_73744;
var statearr_73791_73852 = state_73744__$1;
(statearr_73791_73852[(2)] = inst_73647);

(statearr_73791_73852[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (9))){
var inst_73647 = (state_73744[(8)]);
var inst_73652 = typeof inst_73647 === 'string';
var state_73744__$1 = state_73744;
if(cljs.core.truth_(inst_73652)){
var statearr_73792_73853 = state_73744__$1;
(statearr_73792_73853[(1)] = (11));

} else {
var statearr_73793_73854 = state_73744__$1;
(statearr_73793_73854[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (5))){
var _ = (function (){var statearr_73794 = state_73744;
(statearr_73794[(4)] = cljs.core.rest((state_73744[(4)])));

return statearr_73794;
})();
var state_73744__$1 = state_73744;
var ex73790 = (state_73744__$1[(2)]);
var statearr_73795_73855 = state_73744__$1;
(statearr_73795_73855[(5)] = ex73790);


if((ex73790 instanceof Error)){
var statearr_73796_73856 = state_73744__$1;
(statearr_73796_73856[(1)] = (4));

(statearr_73796_73856[(5)] = null);

} else {
throw ex73790;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (14))){
var inst_73647 = (state_73744[(8)]);
var state_73744__$1 = state_73744;
var statearr_73797_73857 = state_73744__$1;
(statearr_73797_73857[(2)] = inst_73647);

(statearr_73797_73857[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (45))){
var inst_73719 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73798_73858 = state_73744__$1;
(statearr_73798_73858[(2)] = inst_73719);

(statearr_73798_73858[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (26))){
var inst_73670 = (state_73744[(9)]);
var state_73744__$1 = state_73744;
var statearr_73799_73859 = state_73744__$1;
(statearr_73799_73859[(2)] = inst_73670);

(statearr_73799_73859[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (16))){
var inst_73731 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73800_73860 = state_73744__$1;
(statearr_73800_73860[(2)] = inst_73731);

(statearr_73800_73860[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (38))){
var inst_73723 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73801_73861 = state_73744__$1;
(statearr_73801_73861[(2)] = inst_73723);

(statearr_73801_73861[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (30))){
var inst_73647 = (state_73744[(8)]);
var inst_73693 = cljs.core.vector_QMARK_(inst_73647);
var state_73744__$1 = state_73744;
if(inst_73693){
var statearr_73802_73862 = state_73744__$1;
(statearr_73802_73862[(1)] = (32));

} else {
var statearr_73803_73863 = state_73744__$1;
(statearr_73803_73863[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (10))){
var inst_73737 = (state_73744[(2)]);
var state_73744__$1 = state_73744;
var statearr_73804_73864 = state_73744__$1;
(statearr_73804_73864[(2)] = inst_73737);

(statearr_73804_73864[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (18))){
var inst_73647 = (state_73744[(8)]);
var inst_73687 = inst_73647 === true;
var inst_73688 = inst_73647 === false;
var inst_73689 = (inst_73647 == null);
var inst_73690 = ((inst_73687) || (inst_73688) || (inst_73689));
var state_73744__$1 = state_73744;
if(cljs.core.truth_(inst_73690)){
var statearr_73805_73865 = state_73744__$1;
(statearr_73805_73865[(1)] = (29));

} else {
var statearr_73806_73866 = state_73744__$1;
(statearr_73806_73866[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (42))){
var inst_73707 = (state_73744[(2)]);
var inst_73708 = fluree.db.util.async.throw_err(inst_73707);
var state_73744__$1 = state_73744;
var statearr_73807_73867 = state_73744__$1;
(statearr_73807_73867[(2)] = inst_73708);

(statearr_73807_73867[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (37))){
var inst_73647 = (state_73744[(8)]);
var inst_73703 = cljs.core.list_QMARK_(inst_73647);
var state_73744__$1 = state_73744;
if(inst_73703){
var statearr_73808_73868 = state_73744__$1;
(statearr_73808_73868[(1)] = (39));

} else {
var statearr_73809_73869 = state_73744__$1;
(statearr_73809_73869[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73745 === (8))){
var inst_73641 = (state_73744[(10)]);
var state_73744__$1 = state_73744;
var statearr_73810_73870 = state_73744__$1;
(statearr_73810_73870[(2)] = inst_73641);

(statearr_73810_73870[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_73811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73811[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_73811[(1)] = (1));

return statearr_73811;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_73744){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73744);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73812){var ex__13886__auto__ = e73812;
var statearr_73813_73871 = state_73744;
(statearr_73813_73871[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73744[(4)]))){
var statearr_73814_73872 = state_73744;
(statearr_73814_73872[(1)] = cljs.core.first((state_73744[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73873 = state_73744;
state_73744 = G__73873;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_73744){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_73744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73815 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73815[(6)] = c__13957__auto__);

return statearr_73815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__73876 = arguments.length;
switch (G__73876) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74033){
var state_val_74034 = (state_74033[(1)]);
if((state_val_74034 === (7))){
var inst_73895 = (state_74033[(7)]);
var state_74033__$1 = state_74033;
var statearr_74035_74120 = state_74033__$1;
(statearr_74035_74120[(2)] = inst_73895);

(statearr_74035_74120[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (20))){
var inst_74023 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74036_74121 = state_74033__$1;
(statearr_74036_74121[(2)] = inst_74023);

(statearr_74036_74121[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (27))){
var inst_74016 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74037_74122 = state_74033__$1;
(statearr_74037_74122[(2)] = inst_74016);

(statearr_74037_74122[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (1))){
var state_74033__$1 = state_74033;
var statearr_74038_74123 = state_74033__$1;
(statearr_74038_74123[(2)] = null);

(statearr_74038_74123[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (24))){
var inst_73940 = (state_74033[(2)]);
var inst_73941 = fluree.db.util.async.throw_err(inst_73940);
var state_74033__$1 = state_74033;
var statearr_74039_74124 = state_74033__$1;
(statearr_74039_74124[(2)] = inst_73941);

(statearr_74039_74124[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (55))){
var inst_74004 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74040_74125 = state_74033__$1;
(statearr_74040_74125[(2)] = inst_74004);

(statearr_74040_74125[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (39))){
var inst_73974 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74041_74126 = state_74033__$1;
(statearr_74041_74126[(2)] = inst_73974);

(statearr_74041_74126[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (46))){
var inst_73928 = (state_74033[(8)]);
var inst_73986 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73928,type,params);
var state_74033__$1 = state_74033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74033__$1,(49),inst_73986);
} else {
if((state_val_74034 === (4))){
var inst_73877 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74042_74127 = state_74033__$1;
(statearr_74042_74127[(2)] = inst_73877);

(statearr_74042_74127[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (54))){
var state_74033__$1 = state_74033;
var statearr_74043_74128 = state_74033__$1;
(statearr_74043_74128[(2)] = null);

(statearr_74043_74128[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (15))){
var inst_73928 = (state_74033[(8)]);
var state_74033__$1 = state_74033;
var statearr_74044_74129 = state_74033__$1;
(statearr_74044_74129[(2)] = inst_73928);

(statearr_74044_74129[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (48))){
var inst_74008 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74045_74130 = state_74033__$1;
(statearr_74045_74130[(2)] = inst_74008);

(statearr_74045_74130[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (50))){
var inst_73928 = (state_74033[(8)]);
var state_74033__$1 = state_74033;
var statearr_74046_74131 = state_74033__$1;
(statearr_74046_74131[(2)] = inst_73928);

(statearr_74046_74131[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (21))){
var inst_73928 = (state_74033[(8)]);
var inst_73938 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73928,type,params);
var state_74033__$1 = state_74033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74033__$1,(24),inst_73938);
} else {
if((state_val_74034 === (31))){
var inst_73928 = (state_74033[(8)]);
var inst_73951 = (state_74033[(9)]);
var inst_73951__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73928) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73928));
var state_74033__$1 = (function (){var statearr_74047 = state_74033;
(statearr_74047[(9)] = inst_73951__$1);

return statearr_74047;
})();
if(cljs.core.truth_(inst_73951__$1)){
var statearr_74048_74132 = state_74033__$1;
(statearr_74048_74132[(1)] = (34));

} else {
var statearr_74049_74133 = state_74033__$1;
(statearr_74049_74133[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (32))){
var inst_73928 = (state_74033[(8)]);
var inst_73978 = inst_73928 === true;
var inst_73979 = inst_73928 === false;
var inst_73980 = (inst_73928 == null);
var inst_73981 = ((inst_73978) || (inst_73979) || (inst_73980));
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73981)){
var statearr_74050_74134 = state_74033__$1;
(statearr_74050_74134[(1)] = (43));

} else {
var statearr_74051_74135 = state_74033__$1;
(statearr_74051_74135[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (40))){
var inst_73961 = (state_74033[(10)]);
var state_74033__$1 = state_74033;
var statearr_74052_74136 = state_74033__$1;
(statearr_74052_74136[(2)] = inst_73961);

(statearr_74052_74136[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (33))){
var inst_74012 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74053_74137 = state_74033__$1;
(statearr_74053_74137[(2)] = inst_74012);

(statearr_74053_74137[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (13))){
var inst_73921 = (state_74033[(11)]);
var inst_73928 = (state_74033[(8)]);
var inst_73927 = cljs.core.seq(inst_73921);
var inst_73928__$1 = cljs.core.first(inst_73927);
var inst_73929 = cljs.core.next(inst_73927);
var state_74033__$1 = (function (){var statearr_74054 = state_74033;
(statearr_74054[(12)] = inst_73929);

(statearr_74054[(8)] = inst_73928__$1);

return statearr_74054;
})();
if(cljs.core.truth_(inst_73928__$1)){
var statearr_74055_74138 = state_74033__$1;
(statearr_74055_74138[(1)] = (15));

} else {
var statearr_74056_74139 = state_74033__$1;
(statearr_74056_74139[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (22))){
var inst_73928 = (state_74033[(8)]);
var inst_73943 = typeof inst_73928 === 'string';
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73943)){
var statearr_74057_74140 = state_74033__$1;
(statearr_74057_74140[(1)] = (25));

} else {
var statearr_74058_74141 = state_74033__$1;
(statearr_74058_74141[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (36))){
var inst_73976 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74059_74142 = state_74033__$1;
(statearr_74059_74142[(2)] = inst_73976);

(statearr_74059_74142[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (41))){
var inst_73928 = (state_74033[(8)]);
var inst_73964 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73965 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73928)," used in function argument: ",inst_73964].join('');
var inst_73966 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73967 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73968 = cljs.core.PersistentHashMap.fromArrays(inst_73966,inst_73967);
var inst_73969 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73965,inst_73968);
var inst_73970 = (function(){throw inst_73969})();
var state_74033__$1 = state_74033;
var statearr_74060_74143 = state_74033__$1;
(statearr_74060_74143[(2)] = inst_73970);

(statearr_74060_74143[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (43))){
var inst_73928 = (state_74033[(8)]);
var state_74033__$1 = state_74033;
var statearr_74061_74144 = state_74033__$1;
(statearr_74061_74144[(2)] = inst_73928);

(statearr_74061_74144[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (29))){
var inst_73928 = (state_74033[(8)]);
var inst_73949 = (inst_73928 instanceof cljs.core.Symbol);
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73949)){
var statearr_74062_74145 = state_74033__$1;
(statearr_74062_74145[(1)] = (31));

} else {
var statearr_74063_74146 = state_74033__$1;
(statearr_74063_74146[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (44))){
var inst_73928 = (state_74033[(8)]);
var inst_73984 = cljs.core.vector_QMARK_(inst_73928);
var state_74033__$1 = state_74033;
if(inst_73984){
var statearr_74064_74147 = state_74033__$1;
(statearr_74064_74147[(1)] = (46));

} else {
var statearr_74065_74148 = state_74033__$1;
(statearr_74065_74148[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (6))){
var inst_73895 = (state_74033[(7)]);
var inst_73891 = (state_74033[(13)]);
var inst_73890 = (state_74033[(14)]);
var inst_73889 = (state_74033[(2)]);
var inst_73890__$1 = fluree.db.util.async.throw_err(inst_73889);
var inst_73891__$1 = cljs.core.__destructure_map(inst_73890__$1);
var inst_73892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73891__$1,cljs.core.cst$kw$f);
var inst_73893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73891__$1,cljs.core.cst$kw$arity);
var inst_73894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73891__$1,cljs.core.cst$kw$arglist);
var inst_73895__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73891__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_74033__$1 = (function (){var statearr_74066 = state_74033;
(statearr_74066[(15)] = inst_73892);

(statearr_74066[(16)] = inst_73893);

(statearr_74066[(7)] = inst_73895__$1);

(statearr_74066[(13)] = inst_73891__$1);

(statearr_74066[(14)] = inst_73890__$1);

(statearr_74066[(17)] = inst_73894);

return statearr_74066;
})();
if(cljs.core.truth_(inst_73895__$1)){
var statearr_74067_74149 = state_74033__$1;
(statearr_74067_74149[(1)] = (7));

} else {
var statearr_74068_74150 = state_74033__$1;
(statearr_74068_74150[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (28))){
var inst_73928 = (state_74033[(8)]);
var state_74033__$1 = state_74033;
var statearr_74069_74151 = state_74033__$1;
(statearr_74069_74151[(2)] = inst_73928);

(statearr_74069_74151[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (51))){
var state_74033__$1 = state_74033;
var statearr_74070_74152 = state_74033__$1;
(statearr_74070_74152[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (25))){
var inst_73928 = (state_74033[(8)]);
var state_74033__$1 = state_74033;
var statearr_74072_74153 = state_74033__$1;
(statearr_74072_74153[(2)] = inst_73928);

(statearr_74072_74153[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (34))){
var inst_73951 = (state_74033[(9)]);
var state_74033__$1 = state_74033;
var statearr_74073_74154 = state_74033__$1;
(statearr_74073_74154[(2)] = inst_73951);

(statearr_74073_74154[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (17))){
var inst_73934 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73934)){
var statearr_74074_74155 = state_74033__$1;
(statearr_74074_74155[(1)] = (18));

} else {
var statearr_74075_74156 = state_74033__$1;
(statearr_74075_74156[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (3))){
var inst_74031 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74033__$1,inst_74031);
} else {
if((state_val_74034 === (12))){
var inst_73885 = (state_74033[(18)]);
var inst_73909 = (state_74033[(2)]);
var inst_73917 = cljs.core.seq(inst_73885);
var inst_73918 = cljs.core.first(inst_73917);
var inst_73919 = cljs.core.next(inst_73917);
var inst_73920 = cljs.core.PersistentVector.EMPTY;
var inst_73921 = inst_73885;
var inst_73922 = inst_73920;
var state_74033__$1 = (function (){var statearr_74076 = state_74033;
(statearr_74076[(11)] = inst_73921);

(statearr_74076[(19)] = inst_73922);

(statearr_74076[(20)] = inst_73919);

(statearr_74076[(21)] = inst_73918);

(statearr_74076[(22)] = inst_73909);

return statearr_74076;
})();
var statearr_74077_74157 = state_74033__$1;
(statearr_74077_74157[(2)] = null);

(statearr_74077_74157[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (2))){
var inst_73885 = (state_74033[(18)]);
var inst_73884 = (state_74033[(23)]);
var _ = (function (){var statearr_74078 = state_74033;
(statearr_74078[(4)] = cljs.core.cons((5),(state_74033[(4)])));

return statearr_74078;
})();
var inst_73884__$1 = cljs.core.first(form);
var inst_73885__$1 = cljs.core.rest(form);
var inst_73886 = cljs.core.count(inst_73885__$1);
var inst_73887 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_73884__$1,type);
var state_74033__$1 = (function (){var statearr_74079 = state_74033;
(statearr_74079[(24)] = inst_73886);

(statearr_74079[(18)] = inst_73885__$1);

(statearr_74079[(23)] = inst_73884__$1);

return statearr_74079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74033__$1,(6),inst_73887);
} else {
if((state_val_74034 === (23))){
var inst_73929 = (state_74033[(12)]);
var inst_73922 = (state_74033[(19)]);
var inst_74018 = (state_74033[(2)]);
var inst_74019 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73922,inst_74018);
var inst_73921 = inst_73929;
var inst_73922__$1 = inst_74019;
var state_74033__$1 = (function (){var statearr_74080 = state_74033;
(statearr_74080[(11)] = inst_73921);

(statearr_74080[(19)] = inst_73922__$1);

return statearr_74080;
})();
var statearr_74081_74158 = state_74033__$1;
(statearr_74081_74158[(2)] = null);

(statearr_74081_74158[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (47))){
var inst_73928 = (state_74033[(8)]);
var inst_73991 = (inst_73928 == null);
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73991)){
var statearr_74082_74159 = state_74033__$1;
(statearr_74082_74159[(1)] = (50));

} else {
var statearr_74083_74160 = state_74033__$1;
(statearr_74083_74160[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (35))){
var inst_73921 = (state_74033[(11)]);
var inst_73892 = (state_74033[(15)]);
var inst_73893 = (state_74033[(16)]);
var inst_73929 = (state_74033[(12)]);
var inst_73895 = (state_74033[(7)]);
var inst_73928 = (state_74033[(8)]);
var inst_73891 = (state_74033[(13)]);
var inst_73886 = (state_74033[(24)]);
var inst_73890 = (state_74033[(14)]);
var inst_73951 = (state_74033[(9)]);
var inst_73922 = (state_74033[(19)]);
var inst_73919 = (state_74033[(20)]);
var inst_73885 = (state_74033[(18)]);
var inst_73918 = (state_74033[(21)]);
var inst_73884 = (state_74033[(23)]);
var inst_73894 = (state_74033[(17)]);
var inst_73958 = (state_74033[(25)]);
var inst_73909 = (state_74033[(22)]);
var inst_73954 = [inst_73928];
var inst_73955 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73954);
var inst_73956 = (function (){var arity = inst_73893;
var args_n = inst_73886;
var fn_map = inst_73890;
var map__73883 = inst_73891;
var seq__73915 = inst_73919;
var args = inst_73885;
var seq__73925 = inst_73929;
var r = inst_73929;
var vec__73914 = inst_73885;
var G__73913 = inst_73921;
var _ = inst_73909;
var acc = inst_73922;
var arglist = inst_73894;
var fn_name = inst_73884;
var first__73926 = inst_73928;
var _AMPERSAND_args_QMARK_ = inst_73895;
var vec__73924 = inst_73921;
var or__4160__auto__ = inst_73951;
var first__73916 = inst_73918;
var arg = inst_73928;
var f = inst_73892;
return (function (p1__73874_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73874_SHARP_);
});
})();
var inst_73957 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73956,params);
var inst_73958__$1 = cljs.core.some(inst_73955,inst_73957);
var state_74033__$1 = (function (){var statearr_74084 = state_74033;
(statearr_74084[(25)] = inst_73958__$1);

return statearr_74084;
})();
if(cljs.core.truth_(inst_73958__$1)){
var statearr_74085_74161 = state_74033__$1;
(statearr_74085_74161[(1)] = (37));

} else {
var statearr_74086_74162 = state_74033__$1;
(statearr_74086_74162[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (19))){
var inst_73922 = (state_74033[(19)]);
var state_74033__$1 = state_74033;
var statearr_74087_74163 = state_74033__$1;
(statearr_74087_74163[(2)] = inst_73922);

(statearr_74087_74163[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (11))){
var state_74033__$1 = state_74033;
var statearr_74089_74164 = state_74033__$1;
(statearr_74089_74164[(2)] = null);

(statearr_74089_74164[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (9))){
var inst_73900 = (state_74033[(2)]);
var inst_73901 = cljs.core.not(inst_73900);
var state_74033__$1 = state_74033;
if(inst_73901){
var statearr_74090_74165 = state_74033__$1;
(statearr_74090_74165[(1)] = (10));

} else {
var statearr_74091_74166 = state_74033__$1;
(statearr_74091_74166[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (5))){
var _ = (function (){var statearr_74092 = state_74033;
(statearr_74092[(4)] = cljs.core.rest((state_74033[(4)])));

return statearr_74092;
})();
var state_74033__$1 = state_74033;
var ex74088 = (state_74033__$1[(2)]);
var statearr_74093_74167 = state_74033__$1;
(statearr_74093_74167[(5)] = ex74088);


if((ex74088 instanceof Error)){
var statearr_74094_74168 = state_74033__$1;
(statearr_74094_74168[(1)] = (4));

(statearr_74094_74168[(5)] = null);

} else {
throw ex74088;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (14))){
var inst_73892 = (state_74033[(15)]);
var inst_74025 = (state_74033[(2)]);
var inst_74026 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74027 = cljs.core.cons(inst_74026,inst_74025);
var inst_74028 = cljs.core.cons(inst_73892,inst_74027);
var _ = (function (){var statearr_74095 = state_74033;
(statearr_74095[(4)] = cljs.core.rest((state_74033[(4)])));

return statearr_74095;
})();
var state_74033__$1 = state_74033;
var statearr_74096_74169 = state_74033__$1;
(statearr_74096_74169[(2)] = inst_74028);

(statearr_74096_74169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (45))){
var inst_74010 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74097_74170 = state_74033__$1;
(statearr_74097_74170[(2)] = inst_74010);

(statearr_74097_74170[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (53))){
var inst_73928 = (state_74033[(8)]);
var inst_73995 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73928], 0));
var inst_73996 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_73928) : type.call(null,inst_73928));
var inst_73997 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73998 = ["Illegal element (",inst_73995,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73996),") in function argument: ",inst_73997,"."].join('');
var inst_73999 = cljs.core.PersistentHashMap.EMPTY;
var inst_74000 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73998,inst_73999);
var inst_74001 = (function(){throw inst_74000})();
var state_74033__$1 = state_74033;
var statearr_74098_74171 = state_74033__$1;
(statearr_74098_74171[(2)] = inst_74001);

(statearr_74098_74171[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (26))){
var inst_73928 = (state_74033[(8)]);
var inst_73946 = typeof inst_73928 === 'number';
var state_74033__$1 = state_74033;
if(cljs.core.truth_(inst_73946)){
var statearr_74099_74172 = state_74033__$1;
(statearr_74099_74172[(1)] = (28));

} else {
var statearr_74100_74173 = state_74033__$1;
(statearr_74100_74173[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (16))){
var inst_73928 = (state_74033[(8)]);
var inst_73932 = inst_73928 === false;
var state_74033__$1 = state_74033;
var statearr_74101_74174 = state_74033__$1;
(statearr_74101_74174[(2)] = inst_73932);

(statearr_74101_74174[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (38))){
var inst_73961 = (state_74033[(10)]);
var inst_73961__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_74033__$1 = (function (){var statearr_74102 = state_74033;
(statearr_74102[(10)] = inst_73961__$1);

return statearr_74102;
})();
if(inst_73961__$1){
var statearr_74103_74175 = state_74033__$1;
(statearr_74103_74175[(1)] = (40));

} else {
var statearr_74104_74176 = state_74033__$1;
(statearr_74104_74176[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (30))){
var inst_74014 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74105_74177 = state_74033__$1;
(statearr_74105_74177[(2)] = inst_74014);

(statearr_74105_74177[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (10))){
var inst_73893 = (state_74033[(16)]);
var inst_73886 = (state_74033[(24)]);
var inst_73884 = (state_74033[(23)]);
var inst_73903 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73884),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73893),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73886),"."].join('');
var inst_73904 = cljs.core.PersistentHashMap.EMPTY;
var inst_73905 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73903,inst_73904);
var inst_73906 = (function(){throw inst_73905})();
var state_74033__$1 = state_74033;
var statearr_74106_74178 = state_74033__$1;
(statearr_74106_74178[(2)] = inst_73906);

(statearr_74106_74178[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (18))){
var inst_73928 = (state_74033[(8)]);
var inst_73936 = cljs.core.list_QMARK_(inst_73928);
var state_74033__$1 = state_74033;
if(inst_73936){
var statearr_74107_74179 = state_74033__$1;
(statearr_74107_74179[(1)] = (21));

} else {
var statearr_74108_74180 = state_74033__$1;
(statearr_74108_74180[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (52))){
var inst_74006 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74109_74181 = state_74033__$1;
(statearr_74109_74181[(2)] = inst_74006);

(statearr_74109_74181[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (42))){
var inst_73972 = (state_74033[(2)]);
var state_74033__$1 = state_74033;
var statearr_74110_74182 = state_74033__$1;
(statearr_74110_74182[(2)] = inst_73972);

(statearr_74110_74182[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (37))){
var inst_73958 = (state_74033[(25)]);
var state_74033__$1 = state_74033;
var statearr_74111_74183 = state_74033__$1;
(statearr_74111_74183[(2)] = inst_73958);

(statearr_74111_74183[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (8))){
var inst_73893 = (state_74033[(16)]);
var inst_73886 = (state_74033[(24)]);
var inst_73898 = (inst_73893.cljs$core$IFn$_invoke$arity$1 ? inst_73893.cljs$core$IFn$_invoke$arity$1(inst_73886) : inst_73893.call(null,inst_73886));
var state_74033__$1 = state_74033;
var statearr_74112_74184 = state_74033__$1;
(statearr_74112_74184[(2)] = inst_73898);

(statearr_74112_74184[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74034 === (49))){
var inst_73988 = (state_74033[(2)]);
var inst_73989 = fluree.db.util.async.throw_err(inst_73988);
var state_74033__$1 = state_74033;
var statearr_74113_74185 = state_74033__$1;
(statearr_74113_74185[(2)] = inst_73989);

(statearr_74113_74185[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_74114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74114[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_74114[(1)] = (1));

return statearr_74114;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_74033){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74033);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74115){var ex__13886__auto__ = e74115;
var statearr_74116_74186 = state_74033;
(statearr_74116_74186[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74033[(4)]))){
var statearr_74117_74187 = state_74033;
(statearr_74117_74187[(1)] = cljs.core.first((state_74033[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74188 = state_74033;
state_74033 = G__74188;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_74033){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_74033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74118 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74118[(6)] = c__13957__auto__);

return statearr_74118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__74190 = arguments.length;
switch (G__74190) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74269){
var state_val_74270 = (state_74269[(1)]);
if((state_val_74270 === (7))){
var state_74269__$1 = state_74269;
var statearr_74271_74314 = state_74269__$1;
(statearr_74271_74314[(2)] = null);

(statearr_74271_74314[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (20))){
var inst_74244 = (state_74269[(7)]);
var state_74269__$1 = state_74269;
var statearr_74272_74315 = state_74269__$1;
(statearr_74272_74315[(2)] = inst_74244);

(statearr_74272_74315[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (1))){
var state_74269__$1 = state_74269;
var statearr_74273_74316 = state_74269__$1;
(statearr_74273_74316[(2)] = null);

(statearr_74273_74316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (4))){
var inst_74191 = (state_74269[(2)]);
var state_74269__$1 = state_74269;
var statearr_74274_74317 = state_74269__$1;
(statearr_74274_74317[(2)] = inst_74191);

(statearr_74274_74317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (15))){
var inst_74226 = (state_74269[(2)]);
var inst_74227 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_74228 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74227,type,params);
var state_74269__$1 = (function (){var statearr_74275 = state_74269;
(statearr_74275[(8)] = inst_74226);

return statearr_74275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74269__$1,(16),inst_74228);
} else {
if((state_val_74270 === (21))){
var inst_74244 = (state_74269[(7)]);
var inst_74253 = cljs.core.eval(inst_74244);
var state_74269__$1 = state_74269;
var statearr_74276_74318 = state_74269__$1;
(statearr_74276_74318[(2)] = inst_74253);

(statearr_74276_74318[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (13))){
var state_74269__$1 = state_74269;
var statearr_74277_74319 = state_74269__$1;
(statearr_74277_74319[(2)] = null);

(statearr_74277_74319[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (22))){
var inst_74255 = (state_74269[(2)]);
var inst_74256 = [cljs.core.cst$kw$fnstr];
var inst_74257 = [fn_str];
var inst_74258 = cljs.core.PersistentHashMap.fromArrays(inst_74256,inst_74257);
var inst_74259 = cljs.core.with_meta(inst_74255,inst_74258);
var _ = (function (){var statearr_74278 = state_74269;
(statearr_74278[(4)] = cljs.core.rest((state_74269[(4)])));

return statearr_74278;
})();
var state_74269__$1 = state_74269;
var statearr_74279_74320 = state_74269__$1;
(statearr_74279_74320[(2)] = inst_74259);

(statearr_74279_74320[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (6))){
var inst_74201 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_74202 = fluree.db.dbfunctions.core.true_or_false = inst_74201;
var state_74269__$1 = state_74269;
var statearr_74280_74321 = state_74269__$1;
(statearr_74280_74321[(2)] = inst_74202);

(statearr_74280_74321[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (17))){
var inst_74247 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_74269__$1 = state_74269;
var statearr_74282_74322 = state_74269__$1;
(statearr_74282_74322[(2)] = inst_74247);

(statearr_74282_74322[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (3))){
var inst_74267 = (state_74269[(2)]);
var state_74269__$1 = state_74269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74269__$1,inst_74267);
} else {
if((state_val_74270 === (12))){
var _ = (function (){var statearr_74283 = state_74269;
(statearr_74283[(4)] = cljs.core.rest((state_74269[(4)])));

return statearr_74283;
})();
var state_74269__$1 = state_74269;
var ex74281 = (state_74269__$1[(2)]);
var statearr_74284_74323 = state_74269__$1;
(statearr_74284_74323[(5)] = ex74281);


var statearr_74285_74324 = state_74269__$1;
(statearr_74285_74324[(1)] = (11));

(statearr_74285_74324[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (2))){
var _ = (function (){var statearr_74286 = state_74269;
(statearr_74286[(4)] = cljs.core.cons((5),(state_74269[(4)])));

return statearr_74286;
})();
var inst_74197 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var inst_74198 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var inst_74199 = ((inst_74197) || (inst_74198));
var state_74269__$1 = state_74269;
if(cljs.core.truth_(inst_74199)){
var statearr_74287_74325 = state_74269__$1;
(statearr_74287_74325[(1)] = (6));

} else {
var statearr_74288_74326 = state_74269__$1;
(statearr_74288_74326[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (19))){
var inst_74250 = (state_74269[(2)]);
var state_74269__$1 = state_74269;
if(cljs.core.truth_(inst_74250)){
var statearr_74289_74327 = state_74269__$1;
(statearr_74289_74327[(1)] = (20));

} else {
var statearr_74290_74328 = state_74269__$1;
(statearr_74290_74328[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (11))){
var inst_74204 = (state_74269[(2)]);
var inst_74205 = (function(){throw inst_74204})();
var inst_74206 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_74207 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74208 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_74209 = cljs.core.PersistentHashMap.fromArrays(inst_74207,inst_74208);
var inst_74210 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74206,inst_74209);
var inst_74211 = (function(){throw inst_74210})();
var state_74269__$1 = (function (){var statearr_74292 = state_74269;
(statearr_74292[(9)] = inst_74205);

return statearr_74292;
})();
var statearr_74293_74329 = state_74269__$1;
(statearr_74293_74329[(2)] = inst_74211);

(statearr_74293_74329[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (9))){
var _ = (function (){var statearr_74294 = state_74269;
(statearr_74294[(4)] = cljs.core.cons((12),(state_74269[(4)])));

return statearr_74294;
})();
var inst_74217 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_74269__$1 = state_74269;
if(cljs.core.truth_(inst_74217)){
var statearr_74295_74330 = state_74269__$1;
(statearr_74295_74330[(1)] = (13));

} else {
var statearr_74296_74331 = state_74269__$1;
(statearr_74296_74331[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (5))){
var _ = (function (){var statearr_74297 = state_74269;
(statearr_74297[(4)] = cljs.core.rest((state_74269[(4)])));

return statearr_74297;
})();
var state_74269__$1 = state_74269;
var ex74291 = (state_74269__$1[(2)]);
var statearr_74298_74332 = state_74269__$1;
(statearr_74298_74332[(5)] = ex74291);


if((ex74291 instanceof Error)){
var statearr_74299_74333 = state_74269__$1;
(statearr_74299_74333[(1)] = (4));

(statearr_74299_74333[(5)] = null);

} else {
throw ex74291;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (14))){
var inst_74220 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74221 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74222 = cljs.core.PersistentHashMap.fromArrays(inst_74220,inst_74221);
var inst_74223 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_74222);
var inst_74224 = (function(){throw inst_74223})();
var state_74269__$1 = state_74269;
var statearr_74300_74334 = state_74269__$1;
(statearr_74300_74334[(2)] = inst_74224);

(statearr_74300_74334[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (16))){
var inst_74245 = (state_74269[(10)]);
var inst_74230 = (state_74269[(2)]);
var inst_74231 = fluree.db.util.async.throw_err(inst_74230);
var inst_74232 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_74233 = (new cljs.core.List(null,inst_74232,null,(1),null));
var inst_74234 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74235 = (new cljs.core.List(null,inst_74234,null,(1),null));
var inst_74236 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_74235);
var inst_74237 = cljs.core.seq(inst_74236);
var inst_74238 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_74237);
var inst_74239 = cljs.core.vec(inst_74238);
var inst_74240 = (new cljs.core.List(null,inst_74239,null,(1),null));
var inst_74241 = (new cljs.core.List(null,inst_74231,null,(1),null));
var inst_74242 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_74233,inst_74240,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74241], 0));
var inst_74243 = cljs.core.seq(inst_74242);
var inst_74244 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_74243);
var inst_74245__$1 = params;
var state_74269__$1 = (function (){var statearr_74301 = state_74269;
(statearr_74301[(7)] = inst_74244);

(statearr_74301[(10)] = inst_74245__$1);

return statearr_74301;
})();
if(cljs.core.truth_(inst_74245__$1)){
var statearr_74302_74335 = state_74269__$1;
(statearr_74302_74335[(1)] = (17));

} else {
var statearr_74303_74336 = state_74269__$1;
(statearr_74303_74336[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (10))){
var inst_74262 = (state_74269[(2)]);
var state_74269__$1 = state_74269;
var statearr_74304_74337 = state_74269__$1;
(statearr_74304_74337[(2)] = inst_74262);

(statearr_74304_74337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (18))){
var inst_74245 = (state_74269[(10)]);
var state_74269__$1 = state_74269;
var statearr_74305_74338 = state_74269__$1;
(statearr_74305_74338[(2)] = inst_74245);

(statearr_74305_74338[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74270 === (8))){
var inst_74264 = (state_74269[(2)]);
var _ = (function (){var statearr_74306 = state_74269;
(statearr_74306[(4)] = cljs.core.rest((state_74269[(4)])));

return statearr_74306;
})();
var state_74269__$1 = state_74269;
var statearr_74307_74339 = state_74269__$1;
(statearr_74307_74339[(2)] = inst_74264);

(statearr_74307_74339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_74308 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74308[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_74308[(1)] = (1));

return statearr_74308;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_74269){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74269);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74309){var ex__13886__auto__ = e74309;
var statearr_74310_74340 = state_74269;
(statearr_74310_74340[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74269[(4)]))){
var statearr_74311_74341 = state_74269;
(statearr_74311_74341[(1)] = cljs.core.first((state_74269[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74342 = state_74269;
state_74269 = G__74342;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_74269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_74269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74312 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74312[(6)] = c__13957__auto__);

return statearr_74312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74370){
var state_val_74371 = (state_74370[(1)]);
if((state_val_74371 === (7))){
var inst_74357 = (state_74370[(7)]);
var state_74370__$1 = state_74370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74370__$1,(10),inst_74357);
} else {
if((state_val_74371 === (1))){
var state_74370__$1 = state_74370;
var statearr_74372_74392 = state_74370__$1;
(statearr_74372_74392[(2)] = null);

(statearr_74372_74392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (4))){
var inst_74343 = (state_74370[(2)]);
var state_74370__$1 = state_74370;
var statearr_74373_74393 = state_74370__$1;
(statearr_74373_74393[(2)] = inst_74343);

(statearr_74373_74393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (6))){
var inst_74357 = (state_74370[(7)]);
var inst_74352 = (state_74370[(8)]);
var inst_74355 = (state_74370[(2)]);
var inst_74356 = fluree.db.util.async.throw_err(inst_74355);
var inst_74357__$1 = (inst_74356.cljs$core$IFn$_invoke$arity$1 ? inst_74356.cljs$core$IFn$_invoke$arity$1(inst_74352) : inst_74356.call(null,inst_74352));
var inst_74358 = fluree.db.util.async.channel_QMARK_(inst_74357__$1);
var state_74370__$1 = (function (){var statearr_74374 = state_74370;
(statearr_74374[(7)] = inst_74357__$1);

return statearr_74374;
})();
if(inst_74358){
var statearr_74375_74394 = state_74370__$1;
(statearr_74375_74394[(1)] = (7));

} else {
var statearr_74376_74395 = state_74370__$1;
(statearr_74376_74395[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (3))){
var inst_74368 = (state_74370[(2)]);
var state_74370__$1 = state_74370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74370__$1,inst_74368);
} else {
if((state_val_74371 === (2))){
var _ = (function (){var statearr_74378 = state_74370;
(statearr_74378[(4)] = cljs.core.cons((5),(state_74370[(4)])));

return statearr_74378;
})();
var inst_74349 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_74350 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_74351 = [db,block_instant,s,p,auth_id,fuel];
var inst_74352 = cljs.core.PersistentHashMap.fromArrays(inst_74350,inst_74351);
var inst_74353 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74349,"txn",null);
var state_74370__$1 = (function (){var statearr_74379 = state_74370;
(statearr_74379[(8)] = inst_74352);

return statearr_74379;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74370__$1,(6),inst_74353);
} else {
if((state_val_74371 === (9))){
var inst_74365 = (state_74370[(2)]);
var _ = (function (){var statearr_74380 = state_74370;
(statearr_74380[(4)] = cljs.core.rest((state_74370[(4)])));

return statearr_74380;
})();
var state_74370__$1 = state_74370;
var statearr_74381_74396 = state_74370__$1;
(statearr_74381_74396[(2)] = inst_74365);

(statearr_74381_74396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (5))){
var _ = (function (){var statearr_74382 = state_74370;
(statearr_74382[(4)] = cljs.core.rest((state_74370[(4)])));

return statearr_74382;
})();
var state_74370__$1 = state_74370;
var ex74377 = (state_74370__$1[(2)]);
var statearr_74383_74397 = state_74370__$1;
(statearr_74383_74397[(5)] = ex74377);


if((ex74377 instanceof Error)){
var statearr_74384_74398 = state_74370__$1;
(statearr_74384_74398[(1)] = (4));

(statearr_74384_74398[(5)] = null);

} else {
throw ex74377;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (10))){
var inst_74361 = (state_74370[(2)]);
var inst_74362 = fluree.db.util.async.throw_err(inst_74361);
var state_74370__$1 = state_74370;
var statearr_74385_74399 = state_74370__$1;
(statearr_74385_74399[(2)] = inst_74362);

(statearr_74385_74399[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74371 === (8))){
var inst_74357 = (state_74370[(7)]);
var state_74370__$1 = state_74370;
var statearr_74386_74400 = state_74370__$1;
(statearr_74386_74400[(2)] = inst_74357);

(statearr_74386_74400[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0 = (function (){
var statearr_74387 = [null,null,null,null,null,null,null,null,null];
(statearr_74387[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__);

(statearr_74387[(1)] = (1));

return statearr_74387;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1 = (function (state_74370){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74370);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74388){var ex__13886__auto__ = e74388;
var statearr_74389_74401 = state_74370;
(statearr_74389_74401[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74370[(4)]))){
var statearr_74390_74402 = state_74370;
(statearr_74390_74402[(1)] = cljs.core.first((state_74370[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74403 = state_74370;
state_74370 = G__74403;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__ = function(state_74370){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1.call(this,state_74370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74391 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74391[(6)] = c__13957__auto__);

return statearr_74391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
