// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.object');
goog.require('fluree.db.connection_js');
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__65190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65190__$1 = (((((!((map__65190 == null))))?(((((map__65190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65190.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65190):map__65190);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65190__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65190__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = goog.object.get(obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__65192 = cljs.core.get_global_hierarchy;
return (fexpr__65192.cljs$core$IFn$_invoke$arity$0 ? fexpr__65192.cljs$core$IFn$_invoke$arity$0() : fexpr__65192.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__65193__delegate = function (conn_id,event,_){
return event;
};
var G__65193 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__65194__i = 0, G__65194__a = new Array(arguments.length -  2);
while (G__65194__i < G__65194__a.length) {G__65194__a[G__65194__i] = arguments[G__65194__i + 2]; ++G__65194__i;}
  _ = new cljs.core.IndexedSeq(G__65194__a,0,null);
} 
return G__65193__delegate.call(this,conn_id,event,_);};
G__65193.cljs$lang$maxFixedArity = 2;
G__65193.cljs$lang$applyTo = (function (arglist__65195){
var conn_id = cljs.core.first(arglist__65195);
arglist__65195 = cljs.core.next(arglist__65195);
var event = cljs.core.first(arglist__65195);
var _ = cljs.core.rest(arglist__65195);
return G__65193__delegate(conn_id,event,_);
});
G__65193.cljs$core$IFn$_invoke$arity$variadic = G__65193__delegate;
return G__65193;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4126__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65213){
var state_val_65214 = (state_65213[(1)]);
if((state_val_65214 === (1))){
var inst_65196 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_65197 = flureeworker.conn_id__GT_db(conn_id,inst_65196);
var inst_65198 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_65199 = fluree.db.api.query.query(inst_65197,inst_65198);
var state_65213__$1 = state_65213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65213__$1,(2),inst_65199);
} else {
if((state_val_65214 === (2))){
var inst_65201 = (state_65213[(7)]);
var inst_65201__$1 = (state_65213[(2)]);
var inst_65202 = fluree.db.util.core.exception_QMARK_(inst_65201__$1);
var state_65213__$1 = (function (){var statearr_65215 = state_65213;
(statearr_65215[(7)] = inst_65201__$1);

return statearr_65215;
})();
if(inst_65202){
var statearr_65216_65229 = state_65213__$1;
(statearr_65216_65229[(1)] = (3));

} else {
var statearr_65217_65230 = state_65213__$1;
(statearr_65217_65230[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65214 === (3))){
var inst_65201 = (state_65213[(7)]);
var inst_65204 = flureeworker.error_return_map(inst_65201);
var state_65213__$1 = state_65213;
var statearr_65218_65231 = state_65213__$1;
(statearr_65218_65231[(2)] = inst_65204);

(statearr_65218_65231[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65214 === (4))){
var inst_65201 = (state_65213[(7)]);
var inst_65206 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65207 = [inst_65201,"loaded"];
var inst_65208 = cljs.core.PersistentHashMap.fromArrays(inst_65206,inst_65207);
var state_65213__$1 = state_65213;
var statearr_65219_65232 = state_65213__$1;
(statearr_65219_65232[(2)] = inst_65208);

(statearr_65219_65232[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65214 === (5))){
var inst_65210 = (state_65213[(2)]);
var inst_65211 = (function (){var G__65220 = conn_id;
var G__65221 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__65222 = id;
var G__65223 = inst_65210;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65220,G__65221,G__65222,G__65223) : flureeworker.worker_action.call(null,G__65220,G__65221,G__65222,G__65223));
})();
var state_65213__$1 = state_65213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65213__$1,inst_65211);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2879__auto__ = null;
var flureeworker$process_query_$_state_machine__2879__auto____0 = (function (){
var statearr_65224 = [null,null,null,null,null,null,null,null];
(statearr_65224[(0)] = flureeworker$process_query_$_state_machine__2879__auto__);

(statearr_65224[(1)] = (1));

return statearr_65224;
});
var flureeworker$process_query_$_state_machine__2879__auto____1 = (function (state_65213){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65213);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65225){var ex__2882__auto__ = e65225;
var statearr_65226_65233 = state_65213;
(statearr_65226_65233[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65213[(4)]))){
var statearr_65227_65234 = state_65213;
(statearr_65227_65234[(1)] = cljs.core.first((state_65213[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65235 = state_65213;
state_65213 = G__65235;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2879__auto__ = function(state_65213){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2879__auto____1.call(this,state_65213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2879__auto____0;
flureeworker$process_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2879__auto____1;
return flureeworker$process_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65228 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65228[(6)] = c__2901__auto__);

return statearr_65228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__65236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65236__$1 = (((((!((map__65236 == null))))?(((((map__65236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65236):map__65236);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65236__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65236__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__65238 = cljs.core.seq(query_ids);
var chunk__65239 = null;
var count__65240 = (0);
var i__65241 = (0);
while(true){
if((i__65241 < count__65240)){
var id = chunk__65239.cljs$core$IIndexed$_nth$arity$2(null,i__65241);
flureeworker.process_query(conn_id,id,opts);


var G__65242 = seq__65238;
var G__65243 = chunk__65239;
var G__65244 = count__65240;
var G__65245 = (i__65241 + (1));
seq__65238 = G__65242;
chunk__65239 = G__65243;
count__65240 = G__65244;
i__65241 = G__65245;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__65238);
if(temp__5735__auto__){
var seq__65238__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__65238__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__65238__$1);
var G__65246 = cljs.core.chunk_rest(seq__65238__$1);
var G__65247 = c__4556__auto__;
var G__65248 = cljs.core.count(c__4556__auto__);
var G__65249 = (0);
seq__65238 = G__65246;
chunk__65239 = G__65247;
count__65240 = G__65248;
i__65241 = G__65249;
continue;
} else {
var id = cljs.core.first(seq__65238__$1);
flureeworker.process_query(conn_id,id,opts);


var G__65250 = cljs.core.next(seq__65238__$1);
var G__65251 = null;
var G__65252 = (0);
var G__65253 = (0);
seq__65238 = G__65250;
chunk__65239 = G__65251;
count__65240 = G__65252;
i__65241 = G__65253;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__65254 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65254,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65254,(1),null);
var cb = (function (header,data){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65262){
var state_val_65263 = (state_65262[(1)]);
if((state_val_65263 === (1))){
var inst_65257 = cljs.core.async.timeout((100));
var state_65262__$1 = state_65262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65262__$1,(2),inst_65257);
} else {
if((state_val_65263 === (2))){
var inst_65259 = (state_65262[(2)]);
var inst_65260 = flureeworker.process_all_queries(conn_id);
var state_65262__$1 = (function (){var statearr_65264 = state_65262;
(statearr_65264[(7)] = inst_65259);

return statearr_65264;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65262__$1,inst_65260);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2879__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2879__auto____0 = (function (){
var statearr_65265 = [null,null,null,null,null,null,null,null];
(statearr_65265[(0)] = flureeworker$ledger_listener_$_state_machine__2879__auto__);

(statearr_65265[(1)] = (1));

return statearr_65265;
});
var flureeworker$ledger_listener_$_state_machine__2879__auto____1 = (function (state_65262){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65262);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65266){var ex__2882__auto__ = e65266;
var statearr_65267_65270 = state_65262;
(statearr_65267_65270[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65262[(4)]))){
var statearr_65268_65271 = state_65262;
(statearr_65268_65271[(1)] = cljs.core.first((state_65262[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65272 = state_65262;
state_65262 = G__65272;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2879__auto__ = function(state_65262){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2879__auto____1.call(this,state_65262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2879__auto____0;
flureeworker$ledger_listener_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2879__auto____1;
return flureeworker$ledger_listener_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65269 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65269[(6)] = c__2901__auto__);

return statearr_65269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__65273 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65273,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65273,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__65276 = config;
var map__65276__$1 = (((((!((map__65276 == null))))?(((((map__65276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65276.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65276):map__65276);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65276__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4126__auto__ = queries;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65278 = conn_data;
var map__65278__$1 = (((((!((map__65278 == null))))?(((((map__65278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65278):map__65278);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65278__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65278__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65278__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__65279 = config;
var map__65279__$1 = (((((!((map__65279 == null))))?(((((map__65279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65279):map__65279);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65279__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65279__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65279__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65279__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65287){
var state_val_65288 = (state_65287[(1)]);
if((state_val_65288 === (1))){
var inst_65282 = cljs.core.async.timeout((100));
var state_65287__$1 = state_65287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65287__$1,(2),inst_65282);
} else {
if((state_val_65288 === (2))){
var inst_65284 = (state_65287[(2)]);
var inst_65285 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_65287__$1 = (function (){var statearr_65289 = state_65287;
(statearr_65289[(7)] = inst_65284);

return statearr_65289;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65287__$1,inst_65285);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2879__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2879__auto____0 = (function (){
var statearr_65290 = [null,null,null,null,null,null,null,null];
(statearr_65290[(0)] = flureeworker$connect_STAR__$_state_machine__2879__auto__);

(statearr_65290[(1)] = (1));

return statearr_65290;
});
var flureeworker$connect_STAR__$_state_machine__2879__auto____1 = (function (state_65287){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65287);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65291){var ex__2882__auto__ = e65291;
var statearr_65292_65303 = state_65287;
(statearr_65292_65303[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65287[(4)]))){
var statearr_65293_65304 = state_65287;
(statearr_65293_65304[(1)] = cljs.core.first((state_65287[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65305 = state_65287;
state_65287 = G__65305;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2879__auto__ = function(state_65287){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2879__auto____1.call(this,state_65287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2879__auto____0;
flureeworker$connect_STAR__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2879__auto____1;
return flureeworker$connect_STAR__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65294 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65294[(6)] = c__2901__auto__);

return statearr_65294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__65295_65306 = conn_id;
var G__65296_65307 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__65297_65308 = ref;
var G__65298_65309 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65295_65306,G__65296_65307,G__65297_65308,G__65298_65309) : flureeworker.worker_action.call(null,G__65295_65306,G__65296_65307,G__65297_65308,G__65298_65309));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__65299 = conn_id;
var G__65300 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__65301 = ref;
var G__65302 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65299,G__65300,G__65301,G__65302) : flureeworker.worker_action.call(null,G__65299,G__65300,G__65301,G__65302));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__65311 = arguments.length;
switch (G__65311) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65312 = conn_data;
var map__65312__$1 = (((((!((map__65312 == null))))?(((((map__65312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65312.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65312):map__65312);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65312__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65312__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65312__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65312__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__65320 = conn_id;
var G__65321 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__65322 = ref;
var G__65323 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65320,G__65321,G__65322,G__65323) : flureeworker.worker_action.call(null,G__65320,G__65321,G__65322,G__65323));
}catch (e65315){var e = e65315;
var msg = (function (){var or__4126__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4126__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__65316 = conn_id;
var G__65317 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__65318 = ref;
var G__65319 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65316,G__65317,G__65318,G__65319) : flureeworker.worker_action.call(null,G__65316,G__65317,G__65318,G__65319));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e65324){var e = e65324;
var msg = (function (){var or__4126__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4126__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__65325 = conn_id;
var G__65326 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__65327 = ref;
var G__65328 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65325,G__65326,G__65327,G__65328) : flureeworker.worker_action.call(null,G__65325,G__65326,G__65327,G__65328));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__65329 = config_STAR_;
var map__65329__$1 = (((((!((map__65329 == null))))?(((((map__65329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65329.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65329):map__65329);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65329__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65329__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65329__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65329__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65336){
var state_val_65337 = (state_65336[(1)]);
if((state_val_65337 === (1))){
var inst_65331 = cljs.core.async.timeout((100));
var state_65336__$1 = state_65336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65336__$1,(2),inst_65331);
} else {
if((state_val_65337 === (2))){
var inst_65333 = (state_65336[(2)]);
var inst_65334 = flureeworker.connect_STAR_(id,ref);
var state_65336__$1 = (function (){var statearr_65338 = state_65336;
(statearr_65338[(7)] = inst_65333);

return statearr_65338;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65336__$1,inst_65334);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2879__auto__ = null;
var flureeworker$connect_p_$_state_machine__2879__auto____0 = (function (){
var statearr_65339 = [null,null,null,null,null,null,null,null];
(statearr_65339[(0)] = flureeworker$connect_p_$_state_machine__2879__auto__);

(statearr_65339[(1)] = (1));

return statearr_65339;
});
var flureeworker$connect_p_$_state_machine__2879__auto____1 = (function (state_65336){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65336);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65340){var ex__2882__auto__ = e65340;
var statearr_65341_65352 = state_65336;
(statearr_65341_65352[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65336[(4)]))){
var statearr_65342_65353 = state_65336;
(statearr_65342_65353[(1)] = cljs.core.first((state_65336[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65354 = state_65336;
state_65336 = G__65354;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2879__auto__ = function(state_65336){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2879__auto____1.call(this,state_65336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2879__auto____0;
flureeworker$connect_p_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2879__auto____1;
return flureeworker$connect_p_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65343 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65343[(6)] = c__2901__auto__);

return statearr_65343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__65344 = id;
var G__65345 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__65346 = ref;
var G__65347 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65344,G__65345,G__65346,G__65347) : flureeworker.worker_action.call(null,G__65344,G__65345,G__65346,G__65347));
})).catch((function (error){
var G__65348 = id;
var G__65349 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__65350 = ref;
var G__65351 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65348,G__65349,G__65350,G__65351) : flureeworker.worker_action.call(null,G__65348,G__65349,G__65350,G__65351));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65423 = arguments.length;
var i__4737__auto___65424 = (0);
while(true){
if((i__4737__auto___65424 < len__4736__auto___65423)){
args__4742__auto__.push((arguments[i__4737__auto___65424]));

var G__65425 = (i__4737__auto___65424 + (1));
i__4737__auto___65424 = G__65425;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((4) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4743__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__65360){
var vec__65361 = p__65360;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65361,(0),null);
var map__65364 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65364__$1 = (((((!((map__65364 == null))))?(((((map__65364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65364.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65364):map__65364);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65364__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65364__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65364__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__65366 = conn_id;
var G__65367 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65368 = ref;
var G__65369 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65366,G__65367,G__65368,G__65369) : flureeworker.worker_action.call(null,G__65366,G__65367,G__65368,G__65369));
})());
var auth = null;
var c__2901__auto___65426 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65390){
var state_val_65391 = (state_65390[(1)]);
if((state_val_65391 === (1))){
var state_65390__$1 = state_65390;
var statearr_65392_65427 = state_65390__$1;
(statearr_65392_65427[(2)] = null);

(statearr_65392_65427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65391 === (2))){
var ___$1 = (function (){var statearr_65393 = state_65390;
(statearr_65393[(4)] = cljs.core.cons((5),(state_65390[(4)])));

return statearr_65393;
})();
var inst_65381 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_65382 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__65394 = conn_id;
var G__65395 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65396 = ref;
var G__65397 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65394,G__65395,G__65396,G__65397) : flureeworker.worker_action.call(null,G__65394,G__65395,G__65396,G__65397));
});
})();
var inst_65383 = inst_65381.then(inst_65382);
var inst_65384 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e65398){var ___$2 = e65398;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__65399 = conn_id;
var G__65400 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65401 = ref;
var G__65402 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65399,G__65400,G__65401,G__65402) : flureeworker.worker_action.call(null,G__65399,G__65400,G__65401,G__65402));
} else {
var G__65403 = conn_id;
var G__65404 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65405 = ref;
var G__65406 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65403,G__65404,G__65405,G__65406) : flureeworker.worker_action.call(null,G__65403,G__65404,G__65405,G__65406));

}
});
})();
var inst_65385 = inst_65383.catch(inst_65384);
var ___$2 = (function (){var statearr_65407 = state_65390;
(statearr_65407[(4)] = cljs.core.rest((state_65390[(4)])));

return statearr_65407;
})();
var state_65390__$1 = state_65390;
var statearr_65408_65428 = state_65390__$1;
(statearr_65408_65428[(2)] = inst_65385);

(statearr_65408_65428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65391 === (3))){
var inst_65388 = (state_65390[(2)]);
var state_65390__$1 = state_65390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65390__$1,inst_65388);
} else {
if((state_val_65391 === (4))){
var inst_65370 = (state_65390[(2)]);
var inst_65371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_65372 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65370);
var inst_65373 = [(400),inst_65372];
var inst_65374 = cljs.core.PersistentHashMap.fromArrays(inst_65371,inst_65373);
var inst_65375 = (function (){var G__65410 = conn_id;
var G__65411 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65412 = ref;
var G__65413 = inst_65374;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65410,G__65411,G__65412,G__65413) : flureeworker.worker_action.call(null,G__65410,G__65411,G__65412,G__65413));
})();
var state_65390__$1 = state_65390;
var statearr_65414_65429 = state_65390__$1;
(statearr_65414_65429[(2)] = inst_65375);

(statearr_65414_65429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65391 === (5))){
var ___$1 = (function (){var statearr_65415 = state_65390;
(statearr_65415[(4)] = cljs.core.rest((state_65390[(4)])));

return statearr_65415;
})();
var state_65390__$1 = state_65390;
var ex65409 = (state_65390__$1[(2)]);
var statearr_65416_65430 = state_65390__$1;
(statearr_65416_65430[(5)] = ex65409);


var statearr_65417_65431 = state_65390__$1;
(statearr_65417_65431[(1)] = (4));

(statearr_65417_65431[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2879__auto__ = null;
var flureeworker$state_machine__2879__auto____0 = (function (){
var statearr_65418 = [null,null,null,null,null,null,null];
(statearr_65418[(0)] = flureeworker$state_machine__2879__auto__);

(statearr_65418[(1)] = (1));

return statearr_65418;
});
var flureeworker$state_machine__2879__auto____1 = (function (state_65390){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65390);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65419){var ex__2882__auto__ = e65419;
var statearr_65420_65432 = state_65390;
(statearr_65420_65432[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65390[(4)]))){
var statearr_65421_65433 = state_65390;
(statearr_65421_65433[(1)] = cljs.core.first((state_65390[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65434 = state_65390;
state_65390 = G__65434;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$state_machine__2879__auto__ = function(state_65390){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$state_machine__2879__auto____1.call(this,state_65390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2879__auto____0;
flureeworker$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2879__auto____1;
return flureeworker$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65422 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65422[(6)] = c__2901__auto___65426);

return statearr_65422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq65355){
var G__65356 = cljs.core.first(seq65355);
var seq65355__$1 = cljs.core.next(seq65355);
var G__65357 = cljs.core.first(seq65355__$1);
var seq65355__$2 = cljs.core.next(seq65355__$1);
var G__65358 = cljs.core.first(seq65355__$2);
var seq65355__$3 = cljs.core.next(seq65355__$2);
var G__65359 = cljs.core.first(seq65355__$3);
var seq65355__$4 = cljs.core.next(seq65355__$3);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65356,G__65357,G__65358,G__65359,seq65355__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__65435 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__65435__$1 = (((((!((map__65435 == null))))?(((((map__65435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65435):map__65435);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65435__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65435__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__65438 = conn_id;
var G__65439 = new cljs.core.Keyword(null,"login","login",55217519);
var G__65440 = ref;
var G__65441 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65438,G__65439,G__65440,G__65441) : flureeworker.worker_action.call(null,G__65438,G__65439,G__65440,G__65441));
})());
var map__65436 = map_data;
var map__65436__$1 = (((((!((map__65436 == null))))?(((((map__65436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65436):map__65436);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65436__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65436__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65436__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2901__auto___65496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65463){
var state_val_65464 = (state_65463[(1)]);
if((state_val_65464 === (1))){
var state_65463__$1 = state_65463;
var statearr_65465_65497 = state_65463__$1;
(statearr_65465_65497[(2)] = null);

(statearr_65465_65497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65464 === (2))){
var ___$1 = (function (){var statearr_65466 = state_65463;
(statearr_65466[(4)] = cljs.core.cons((5),(state_65463[(4)])));

return statearr_65466;
})();
var inst_65454 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_65455 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__65467 = conn_id;
var G__65468 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__65469 = ref;
var G__65470 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65467,G__65468,G__65469,G__65470) : flureeworker.worker_action.call(null,G__65467,G__65468,G__65469,G__65470));
});
})();
var inst_65456 = inst_65454.then(inst_65455);
var inst_65457 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e65471){var ___$2 = e65471;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__65472 = conn_id;
var G__65473 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__65474 = ref;
var G__65475 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65472,G__65473,G__65474,G__65475) : flureeworker.worker_action.call(null,G__65472,G__65473,G__65474,G__65475));
} else {
var G__65476 = conn_id;
var G__65477 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__65478 = ref;
var G__65479 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65476,G__65477,G__65478,G__65479) : flureeworker.worker_action.call(null,G__65476,G__65477,G__65478,G__65479));

}
});
})();
var inst_65458 = inst_65456.catch(inst_65457);
var ___$2 = (function (){var statearr_65480 = state_65463;
(statearr_65480[(4)] = cljs.core.rest((state_65463[(4)])));

return statearr_65480;
})();
var state_65463__$1 = state_65463;
var statearr_65481_65498 = state_65463__$1;
(statearr_65481_65498[(2)] = inst_65458);

(statearr_65481_65498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65464 === (3))){
var inst_65461 = (state_65463[(2)]);
var state_65463__$1 = state_65463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65463__$1,inst_65461);
} else {
if((state_val_65464 === (4))){
var inst_65443 = (state_65463[(2)]);
var inst_65444 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_65445 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65443);
var inst_65446 = [(400),inst_65445];
var inst_65447 = cljs.core.PersistentHashMap.fromArrays(inst_65444,inst_65446);
var inst_65448 = (function (){var G__65483 = conn_id;
var G__65484 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__65485 = ref;
var G__65486 = inst_65447;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__65483,G__65484,G__65485,G__65486) : flureeworker.worker_action.call(null,G__65483,G__65484,G__65485,G__65486));
})();
var state_65463__$1 = state_65463;
var statearr_65487_65499 = state_65463__$1;
(statearr_65487_65499[(2)] = inst_65448);

(statearr_65487_65499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65464 === (5))){
var ___$1 = (function (){var statearr_65488 = state_65463;
(statearr_65488[(4)] = cljs.core.rest((state_65463[(4)])));

return statearr_65488;
})();
var state_65463__$1 = state_65463;
var ex65482 = (state_65463__$1[(2)]);
var statearr_65489_65500 = state_65463__$1;
(statearr_65489_65500[(5)] = ex65482);


var statearr_65490_65501 = state_65463__$1;
(statearr_65490_65501[(1)] = (4));

(statearr_65490_65501[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2879__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2879__auto____0 = (function (){
var statearr_65491 = [null,null,null,null,null,null,null];
(statearr_65491[(0)] = flureeworker$pw_generate_$_state_machine__2879__auto__);

(statearr_65491[(1)] = (1));

return statearr_65491;
});
var flureeworker$pw_generate_$_state_machine__2879__auto____1 = (function (state_65463){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65463);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65492){var ex__2882__auto__ = e65492;
var statearr_65493_65502 = state_65463;
(statearr_65493_65502[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65463[(4)]))){
var statearr_65494_65503 = state_65463;
(statearr_65494_65503[(1)] = cljs.core.first((state_65463[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65504 = state_65463;
state_65463 = G__65504;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2879__auto__ = function(state_65463){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2879__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2879__auto____1.call(this,state_65463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2879__auto____0;
flureeworker$pw_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2879__auto____1;
return flureeworker$pw_generate_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65495 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65495[(6)] = c__2901__auto___65496);

return statearr_65495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65505_SHARP_){
return (js_array[p1__65505_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e65506){var e = e65506;
var data = (event["data"]);
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5735__auto___65507 = cljs.core.not(self.document);
if(temp__5735__auto___65507){
var worker_QMARK__65508 = temp__5735__auto___65507;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__65509_65511 = null;
var G__65510_65512 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__65509_65511,G__65510_65512) : flureeworker.worker_action.call(null,G__65509_65511,G__65510_65512));
