// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e16772){var e = e16772;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__16773_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__16773_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__16773_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__16773_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__16773_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16774_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16774_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16775_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16775_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__16780 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16780,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16780,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16776_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16776_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__16783 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16783,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16783,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16777_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16777_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16778_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16778_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16779_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16779_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16786_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__16786_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__16787 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__16787) : intersecting_vars.call(null,G__16787));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__16790,optional_QMARK_,fuel,max_fuel){
var map__16791 = p__16790;
var map__16791__$1 = (((((!((map__16791 == null))))?(((((map__16791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16791):map__16791);
var res = map__16791__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16791__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16858){
var state_val_16859 = (state_16858[(1)]);
if((state_val_16859 === (7))){
var inst_16847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16848 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_16849 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16848,clause);
var inst_16850 = [null,inst_16849];
var inst_16851 = (new cljs.core.PersistentVector(null,2,(5),inst_16847,inst_16850,null));
var state_16858__$1 = state_16858;
var statearr_16860_16888 = state_16858__$1;
(statearr_16860_16888[(2)] = inst_16851);

(statearr_16860_16888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (1))){
var state_16858__$1 = state_16858;
var statearr_16861_16889 = state_16858__$1;
(statearr_16861_16889[(2)] = null);

(statearr_16861_16889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (4))){
var inst_16793 = (state_16858[(2)]);
var state_16858__$1 = state_16858;
var statearr_16862_16890 = state_16858__$1;
(statearr_16862_16890[(2)] = inst_16793);

(statearr_16862_16890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (15))){
var inst_16836 = (state_16858[(2)]);
var inst_16837 = fluree.db.util.async.throw_err(inst_16836);
var inst_16838 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_16837);
var inst_16839 = cljs.core.count(inst_16838);
var inst_16840 = fluree.db.query.analytical.add_fuel(inst_16839,fuel,max_fuel);
var inst_16841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16842 = [inst_16837,r];
var inst_16843 = (new cljs.core.PersistentVector(null,2,(5),inst_16841,inst_16842,null));
var state_16858__$1 = (function (){var statearr_16863 = state_16858;
(statearr_16863[(7)] = inst_16840);

return statearr_16863;
})();
var statearr_16864_16891 = state_16858__$1;
(statearr_16864_16891[(2)] = inst_16843);

(statearr_16864_16891[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (13))){
var inst_16802 = (state_16858[(8)]);
var inst_16815 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16816 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_16815);
var inst_16817 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_16802);
var inst_16818 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16817);
var inst_16819 = cljs.core.set(inst_16818);
var inst_16820 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_16816);
var inst_16821 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16820);
var inst_16822 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16819,inst_16821);
var inst_16823 = (function (){var all_wd = inst_16802;
var optional = inst_16816;
var all_wd_vars = inst_16819;
var all_vars = inst_16822;
return (function (p1__16788_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__16788_SHARP_) : all_vars.call(null,p1__16788_SHARP_));
});
})();
var inst_16824 = cljs.core.keys(vars);
var inst_16825 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16823,inst_16824);
var inst_16826 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_16825);
var inst_16827 = cljs.core.set(inst_16826);
var inst_16828 = (function (){var all_wd = inst_16802;
var optional = inst_16816;
var all_wd_vars = inst_16819;
var all_vars = inst_16822;
var intersecting_vars = inst_16827;
return (function (p1__16789_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__16789_SHARP_);
});
})();
var inst_16829 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16828,inst_16802);
var inst_16830 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16829);
var inst_16831 = fluree.db.query.analytical.select_from_tuples(inst_16830,res);
var inst_16832 = fluree.db.query.analytical.replace_vars_wikidata(inst_16802,inst_16827,vars);
var inst_16833 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_16827,inst_16822);
var inst_16834 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_16832,inst_16830,inst_16831,inst_16833,inst_16816);
var state_16858__$1 = state_16858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16858__$1,(15),inst_16834);
} else {
if((state_val_16859 === (6))){
var inst_16803 = (state_16858[(9)]);
var inst_16801 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16802 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_16801);
var inst_16803__$1 = optional_QMARK_;
var state_16858__$1 = (function (){var statearr_16865 = state_16858;
(statearr_16865[(9)] = inst_16803__$1);

(statearr_16865[(8)] = inst_16802);

return statearr_16865;
})();
if(cljs.core.truth_(inst_16803__$1)){
var statearr_16866_16892 = state_16858__$1;
(statearr_16866_16892[(1)] = (9));

} else {
var statearr_16867_16893 = state_16858__$1;
(statearr_16867_16893[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (3))){
var inst_16856 = (state_16858[(2)]);
var state_16858__$1 = state_16858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16858__$1,inst_16856);
} else {
if((state_val_16859 === (12))){
var inst_16811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16812 = [null,r];
var inst_16813 = (new cljs.core.PersistentVector(null,2,(5),inst_16811,inst_16812,null));
var state_16858__$1 = state_16858;
var statearr_16868_16894 = state_16858__$1;
(statearr_16868_16894[(2)] = inst_16813);

(statearr_16868_16894[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (2))){
var _ = (function (){var statearr_16869 = state_16858;
(statearr_16869[(4)] = cljs.core.cons((5),(state_16858[(4)])));

return statearr_16869;
})();
var inst_16799 = (r == null);
var state_16858__$1 = state_16858;
if(cljs.core.truth_(inst_16799)){
var statearr_16870_16895 = state_16858__$1;
(statearr_16870_16895[(1)] = (6));

} else {
var statearr_16871_16896 = state_16858__$1;
(statearr_16871_16896[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (11))){
var inst_16809 = (state_16858[(2)]);
var state_16858__$1 = state_16858;
if(cljs.core.truth_(inst_16809)){
var statearr_16873_16897 = state_16858__$1;
(statearr_16873_16897[(1)] = (12));

} else {
var statearr_16874_16898 = state_16858__$1;
(statearr_16874_16898[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (9))){
var inst_16802 = (state_16858[(8)]);
var inst_16805 = cljs.core.empty_QMARK_(inst_16802);
var inst_16806 = (!(inst_16805));
var state_16858__$1 = state_16858;
var statearr_16875_16899 = state_16858__$1;
(statearr_16875_16899[(2)] = inst_16806);

(statearr_16875_16899[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (5))){
var _ = (function (){var statearr_16876 = state_16858;
(statearr_16876[(4)] = cljs.core.rest((state_16858[(4)])));

return statearr_16876;
})();
var state_16858__$1 = state_16858;
var ex16872 = (state_16858__$1[(2)]);
var statearr_16877_16900 = state_16858__$1;
(statearr_16877_16900[(5)] = ex16872);


if((ex16872 instanceof Error)){
var statearr_16878_16901 = state_16858__$1;
(statearr_16878_16901[(1)] = (4));

(statearr_16878_16901[(5)] = null);

} else {
throw ex16872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (14))){
var inst_16845 = (state_16858[(2)]);
var state_16858__$1 = state_16858;
var statearr_16879_16902 = state_16858__$1;
(statearr_16879_16902[(2)] = inst_16845);

(statearr_16879_16902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (10))){
var inst_16803 = (state_16858[(9)]);
var state_16858__$1 = state_16858;
var statearr_16880_16903 = state_16858__$1;
(statearr_16880_16903[(2)] = inst_16803);

(statearr_16880_16903[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16859 === (8))){
var inst_16853 = (state_16858[(2)]);
var _ = (function (){var statearr_16881 = state_16858;
(statearr_16881[(4)] = cljs.core.rest((state_16858[(4)])));

return statearr_16881;
})();
var state_16858__$1 = state_16858;
var statearr_16882_16904 = state_16858__$1;
(statearr_16882_16904[(2)] = inst_16853);

(statearr_16882_16904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_16883 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16883[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__);

(statearr_16883[(1)] = (1));

return statearr_16883;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1 = (function (state_16858){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16858);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16884){var ex__2882__auto__ = e16884;
var statearr_16885_16905 = state_16858;
(statearr_16885_16905[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16858[(4)]))){
var statearr_16886_16906 = state_16858;
(statearr_16886_16906[(1)] = cljs.core.first((state_16858[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16907 = state_16858;
state_16858 = G__16907;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__ = function(state_16858){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1.call(this,state_16858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16887 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16887[(6)] = c__2901__auto__);

return statearr_16887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__16909 = arguments.length;
switch (G__16909) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17003){
var state_val_17004 = (state_17003[(1)]);
if((state_val_17004 === (7))){
var inst_16916 = (state_17003[(7)]);
var inst_16926 = clojure.string.starts_with_QMARK_(inst_16916,"$fdb");
var state_17003__$1 = state_17003;
if(inst_16926){
var statearr_17005_17054 = state_17003__$1;
(statearr_17005_17054[(1)] = (9));

} else {
var statearr_17006_17055 = state_17003__$1;
(statearr_17006_17055[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (20))){
var state_17003__$1 = state_17003;
var statearr_17007_17056 = state_17003__$1;
(statearr_17007_17056[(2)] = null);

(statearr_17007_17056[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (27))){
var inst_16966 = (state_17003[(8)]);
var state_17003__$1 = state_17003;
var statearr_17008_17057 = state_17003__$1;
(statearr_17008_17057[(2)] = inst_16966);

(statearr_17008_17057[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (1))){
var state_17003__$1 = state_17003;
var statearr_17009_17058 = state_17003__$1;
(statearr_17009_17058[(2)] = null);

(statearr_17009_17058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (24))){
var inst_16989 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
var statearr_17010_17059 = state_17003__$1;
(statearr_17010_17059[(2)] = inst_16989);

(statearr_17010_17059[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (4))){
var inst_16910 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
var statearr_17011_17060 = state_17003__$1;
(statearr_17011_17060[(2)] = inst_16910);

(statearr_17011_17060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (15))){
var inst_16933 = (state_17003[(9)]);
var inst_16939 = (state_17003[(2)]);
var inst_16940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16941 = cljs.core.PersistentVector.EMPTY;
var inst_16942 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16943 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16941,inst_16942);
var inst_16944 = [inst_16933,inst_16943];
var inst_16945 = (new cljs.core.PersistentVector(null,2,(5),inst_16940,inst_16944,null));
var state_17003__$1 = (function (){var statearr_17012 = state_17003;
(statearr_17012[(10)] = inst_16939);

return statearr_17012;
})();
var statearr_17013_17061 = state_17003__$1;
(statearr_17013_17061[(2)] = inst_16945);

(statearr_17013_17061[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (21))){
var inst_16992 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
var statearr_17014_17062 = state_17003__$1;
(statearr_17014_17062[(2)] = inst_16992);

(statearr_17014_17062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (13))){
var inst_16933 = (state_17003[(9)]);
var inst_16936 = (function(){throw inst_16933})();
var state_17003__$1 = state_17003;
var statearr_17015_17063 = state_17003__$1;
(statearr_17015_17063[(2)] = inst_16936);

(statearr_17015_17063[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (22))){
var inst_16955 = (state_17003[(11)]);
var inst_16957 = (state_17003[(12)]);
var inst_16959 = fluree.db.query.analytical.parse_block_from_source(inst_16955);
var inst_16960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16961 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_16957];
var inst_16962 = (new cljs.core.PersistentVector(null,2,(5),inst_16960,inst_16961,null));
var inst_16963 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_16962);
var state_17003__$1 = (function (){var statearr_17016 = state_17003;
(statearr_17016[(13)] = inst_16959);

return statearr_17016;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17003__$1,(25),inst_16963);
} else {
if((state_val_17004 === (29))){
var inst_16970 = (state_17003[(2)]);
var inst_16971 = fluree.db.util.async.throw_err(inst_16970);
var state_17003__$1 = state_17003;
var statearr_17017_17064 = state_17003__$1;
(statearr_17017_17064[(2)] = inst_16971);

(statearr_17017_17064[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (6))){
var inst_16919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16920 = cljs.core.PersistentVector.EMPTY;
var inst_16921 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16922 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16920,inst_16921);
var inst_16923 = [db,inst_16922];
var inst_16924 = (new cljs.core.PersistentVector(null,2,(5),inst_16919,inst_16923,null));
var state_17003__$1 = state_17003;
var statearr_17018_17065 = state_17003__$1;
(statearr_17018_17065[(2)] = inst_16924);

(statearr_17018_17065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (28))){
var inst_16974 = (state_17003[(2)]);
var inst_16975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16976 = cljs.core.PersistentVector.EMPTY;
var inst_16977 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16978 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16976,inst_16977);
var inst_16979 = [inst_16974,inst_16978];
var inst_16980 = (new cljs.core.PersistentVector(null,2,(5),inst_16975,inst_16979,null));
var state_17003__$1 = state_17003;
var statearr_17019_17066 = state_17003__$1;
(statearr_17019_17066[(2)] = inst_16980);

(statearr_17019_17066[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (25))){
var inst_16959 = (state_17003[(13)]);
var inst_16965 = (state_17003[(2)]);
var inst_16966 = fluree.db.util.async.throw_err(inst_16965);
var state_17003__$1 = (function (){var statearr_17020 = state_17003;
(statearr_17020[(8)] = inst_16966);

return statearr_17020;
})();
if(cljs.core.truth_(inst_16959)){
var statearr_17021_17067 = state_17003__$1;
(statearr_17021_17067[(1)] = (26));

} else {
var statearr_17022_17068 = state_17003__$1;
(statearr_17022_17068[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (17))){
var state_17003__$1 = state_17003;
var statearr_17023_17069 = state_17003__$1;
(statearr_17023_17069[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (3))){
var inst_17001 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17003__$1,inst_17001);
} else {
if((state_val_17004 === (12))){
var inst_16933 = (state_17003[(9)]);
var inst_16932 = (state_17003[(2)]);
var inst_16933__$1 = fluree.db.util.async.throw_err(inst_16932);
var inst_16934 = fluree.db.util.core.exception_QMARK_(inst_16933__$1);
var state_17003__$1 = (function (){var statearr_17025 = state_17003;
(statearr_17025[(9)] = inst_16933__$1);

return statearr_17025;
})();
if(inst_16934){
var statearr_17026_17070 = state_17003__$1;
(statearr_17026_17070[(1)] = (13));

} else {
var statearr_17027_17071 = state_17003__$1;
(statearr_17027_17071[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (2))){
var inst_16916 = (state_17003[(7)]);
var _ = (function (){var statearr_17028 = state_17003;
(statearr_17028[(4)] = cljs.core.cons((5),(state_17003[(4)])));

return statearr_17028;
})();
var inst_16916__$1 = cljs.core.first(clause);
var inst_16917 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_16916__$1);
var state_17003__$1 = (function (){var statearr_17029 = state_17003;
(statearr_17029[(7)] = inst_16916__$1);

return statearr_17029;
})();
if(inst_16917){
var statearr_17030_17072 = state_17003__$1;
(statearr_17030_17072[(1)] = (6));

} else {
var statearr_17031_17073 = state_17003__$1;
(statearr_17031_17073[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (23))){
var inst_16916 = (state_17003[(7)]);
var inst_16982 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16916)," is not supported in Fluree"].join('');
var inst_16983 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16984 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16985 = cljs.core.PersistentHashMap.fromArrays(inst_16983,inst_16984);
var inst_16986 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16982,inst_16985);
var inst_16987 = (function(){throw inst_16986})();
var state_17003__$1 = state_17003;
var statearr_17032_17074 = state_17003__$1;
(statearr_17032_17074[(2)] = inst_16987);

(statearr_17032_17074[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (19))){
var inst_16916 = (state_17003[(7)]);
var inst_16957 = (state_17003[(12)]);
var inst_16954 = fluree.db.query.analytical.isolate_source_name(inst_16916);
var inst_16955 = fluree.db.query.analytical.isolate_source_block(inst_16916);
var inst_16956 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16954);
var inst_16957__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_16956);
var state_17003__$1 = (function (){var statearr_17033 = state_17003;
(statearr_17033[(11)] = inst_16955);

(statearr_17033[(12)] = inst_16957__$1);

return statearr_17033;
})();
if(cljs.core.truth_(inst_16957__$1)){
var statearr_17034_17075 = state_17003__$1;
(statearr_17034_17075[(1)] = (22));

} else {
var statearr_17035_17076 = state_17003__$1;
(statearr_17035_17076[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (11))){
var inst_16996 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
var statearr_17037_17077 = state_17003__$1;
(statearr_17037_17077[(2)] = inst_16996);

(statearr_17037_17077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (9))){
var inst_16916 = (state_17003[(7)]);
var inst_16928 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_16916,(4));
var inst_16929 = fluree.db.query.analytical.parse_block_from_source(inst_16928);
var inst_16930 = fluree.db.time_travel.as_of_block(db,inst_16929);
var state_17003__$1 = state_17003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17003__$1,(12),inst_16930);
} else {
if((state_val_17004 === (5))){
var _ = (function (){var statearr_17038 = state_17003;
(statearr_17038[(4)] = cljs.core.rest((state_17003[(4)])));

return statearr_17038;
})();
var state_17003__$1 = state_17003;
var ex17036 = (state_17003__$1[(2)]);
var statearr_17039_17078 = state_17003__$1;
(statearr_17039_17078[(5)] = ex17036);


if((ex17036 instanceof Error)){
var statearr_17040_17079 = state_17003__$1;
(statearr_17040_17079[(1)] = (4));

(statearr_17040_17079[(5)] = null);

} else {
throw ex17036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (14))){
var state_17003__$1 = state_17003;
var statearr_17041_17080 = state_17003__$1;
(statearr_17041_17080[(2)] = null);

(statearr_17041_17080[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (26))){
var inst_16966 = (state_17003[(8)]);
var inst_16959 = (state_17003[(13)]);
var inst_16968 = fluree.db.time_travel.as_of_block(inst_16966,inst_16959);
var state_17003__$1 = state_17003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17003__$1,(29),inst_16968);
} else {
if((state_val_17004 === (16))){
var inst_16949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16950 = ["$wd",clause];
var inst_16951 = (new cljs.core.PersistentVector(null,2,(5),inst_16949,inst_16950,null));
var state_17003__$1 = state_17003;
var statearr_17042_17081 = state_17003__$1;
(statearr_17042_17081[(2)] = inst_16951);

(statearr_17042_17081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (10))){
var inst_16916 = (state_17003[(7)]);
var inst_16947 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_16916);
var state_17003__$1 = state_17003;
if(inst_16947){
var statearr_17043_17082 = state_17003__$1;
(statearr_17043_17082[(1)] = (16));

} else {
var statearr_17044_17083 = state_17003__$1;
(statearr_17044_17083[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (18))){
var inst_16994 = (state_17003[(2)]);
var state_17003__$1 = state_17003;
var statearr_17045_17084 = state_17003__$1;
(statearr_17045_17084[(2)] = inst_16994);

(statearr_17045_17084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17004 === (8))){
var inst_16998 = (state_17003[(2)]);
var _ = (function (){var statearr_17046 = state_17003;
(statearr_17046[(4)] = cljs.core.rest((state_17003[(4)])));

return statearr_17046;
})();
var state_17003__$1 = state_17003;
var statearr_17047_17085 = state_17003__$1;
(statearr_17047_17085[(2)] = inst_16998);

(statearr_17047_17085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2879__auto__ = null;
var fluree$db$query$analytical$state_machine__2879__auto____0 = (function (){
var statearr_17048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17048[(0)] = fluree$db$query$analytical$state_machine__2879__auto__);

(statearr_17048[(1)] = (1));

return statearr_17048;
});
var fluree$db$query$analytical$state_machine__2879__auto____1 = (function (state_17003){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_17003);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17049){var ex__2882__auto__ = e17049;
var statearr_17050_17086 = state_17003;
(statearr_17050_17086[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_17003[(4)]))){
var statearr_17051_17087 = state_17003;
(statearr_17051_17087[(1)] = cljs.core.first((state_17003[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17088 = state_17003;
state_17003 = G__17088;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2879__auto__ = function(state_17003){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2879__auto____1.call(this,state_17003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2879__auto____0;
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2879__auto____1;
return fluree$db$query$analytical$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17052 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_17052[(6)] = c__2901__auto__);

return statearr_17052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__17089){
var vec__17090 = p__17089;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17090,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17090,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17093_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__17093_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__17097 = subjects;
var vec__17098 = G__17097;
var seq__17099 = cljs.core.seq(vec__17098);
var first__17100 = cljs.core.first(seq__17099);
var seq__17099__$1 = cljs.core.next(seq__17099);
var subject = first__17100;
var r = seq__17099__$1;
var acc = expanded_map;
var G__17097__$1 = G__17097;
var acc__$1 = acc;
while(true){
var vec__17104 = G__17097__$1;
var seq__17105 = cljs.core.seq(vec__17104);
var first__17106 = cljs.core.first(seq__17105);
var seq__17105__$1 = cljs.core.next(seq__17105);
var subject__$1 = first__17106;
var r__$1 = seq__17105__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__17107 = r__$1;
var G__17108 = acc__$2;
G__17097__$1 = G__17107;
acc__$1 = G__17108;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__17097__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__17097__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__17097__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__17097__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__17097__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__17097__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17104,seq__17105,first__17106,seq__17105__$1,subject__$1,r__$1,acc__$2,G__17097,vec__17098,seq__17099,first__17100,seq__17099__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__17109 = r__$1;
var G__17110 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__17097__$1 = G__17109;
acc__$1 = G__17110;
continue;
} else {
var G__17111 = subjects;
var G__17112 = acc_STAR_;
G__17097__$1 = G__17111;
acc__$1 = G__17112;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17113_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__17113_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17204){
var state_val_17205 = (state_17204[(1)]);
if((state_val_17205 === (7))){
var state_17204__$1 = state_17204;
var statearr_17206_17252 = state_17204__$1;
(statearr_17206_17252[(2)] = (100));

(statearr_17206_17252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (20))){
var inst_17153 = (state_17204[(7)]);
var state_17204__$1 = state_17204;
var statearr_17207_17253 = state_17204__$1;
(statearr_17207_17253[(2)] = inst_17153);

(statearr_17207_17253[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (1))){
var state_17204__$1 = state_17204;
var statearr_17208_17254 = state_17204__$1;
(statearr_17208_17254[(2)] = null);

(statearr_17208_17254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (24))){
var inst_17125 = (state_17204[(8)]);
var inst_17191 = (state_17204[(9)]);
var inst_17192 = (state_17204[(10)]);
var inst_17190 = (state_17204[(11)]);
var inst_17195 = (function (){var max_depth = inst_17125;
var recur_map__$1 = inst_17191;
var subjects = inst_17190;
var tuples = inst_17192;
return (function (p1__17114_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__17114_SHARP_)],null));
});
})();
var inst_17196 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17195,inst_17192);
var inst_17197 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_17196);
var state_17204__$1 = state_17204;
var statearr_17209_17255 = state_17204__$1;
(statearr_17209_17255[(2)] = inst_17197);

(statearr_17209_17255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (4))){
var inst_17115 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17210_17256 = state_17204__$1;
(statearr_17210_17256[(2)] = inst_17115);

(statearr_17210_17256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (15))){
var inst_17138 = (state_17204[(12)]);
var inst_17149 = cljs.core.PersistentVector.EMPTY;
var inst_17150 = cljs.core.seq(inst_17138);
var inst_17151 = cljs.core.first(inst_17150);
var inst_17152 = cljs.core.next(inst_17150);
var inst_17153 = inst_17149;
var inst_17154 = inst_17138;
var state_17204__$1 = (function (){var statearr_17211 = state_17204;
(statearr_17211[(7)] = inst_17153);

(statearr_17211[(13)] = inst_17151);

(statearr_17211[(14)] = inst_17154);

(statearr_17211[(15)] = inst_17152);

return statearr_17211;
})();
var statearr_17212_17257 = state_17204__$1;
(statearr_17212_17257[(2)] = null);

(statearr_17212_17257[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (21))){
var inst_17174 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17213_17258 = state_17204__$1;
(statearr_17213_17258[(2)] = inst_17174);

(statearr_17213_17258[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (13))){
var inst_17187 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17214_17259 = state_17204__$1;
(statearr_17214_17259[(2)] = inst_17187);

(statearr_17214_17259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (22))){
var inst_17153 = (state_17204[(7)]);
var inst_17161 = (state_17204[(16)]);
var inst_17168 = (state_17204[(2)]);
var inst_17169 = fluree.db.util.async.throw_err(inst_17168);
var inst_17170 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_17153,inst_17169);
var inst_17153__$1 = inst_17170;
var inst_17154 = inst_17161;
var state_17204__$1 = (function (){var statearr_17215 = state_17204;
(statearr_17215[(7)] = inst_17153__$1);

(statearr_17215[(14)] = inst_17154);

return statearr_17215;
})();
var statearr_17216_17260 = state_17204__$1;
(statearr_17216_17260[(2)] = null);

(statearr_17216_17260[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (6))){
var inst_17121 = (state_17204[(17)]);
var state_17204__$1 = state_17204;
var statearr_17217_17261 = state_17204__$1;
(statearr_17217_17261[(2)] = inst_17121);

(statearr_17217_17261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (25))){
var inst_17199 = (state_17204[(2)]);
var _ = (function (){var statearr_17218 = state_17204;
(statearr_17218[(4)] = cljs.core.rest((state_17204[(4)])));

return statearr_17218;
})();
var state_17204__$1 = state_17204;
var statearr_17219_17262 = state_17204__$1;
(statearr_17219_17262[(2)] = inst_17199);

(statearr_17219_17262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (17))){
var inst_17154 = (state_17204[(14)]);
var inst_17160 = (state_17204[(18)]);
var inst_17159 = cljs.core.seq(inst_17154);
var inst_17160__$1 = cljs.core.first(inst_17159);
var inst_17161 = cljs.core.next(inst_17159);
var state_17204__$1 = (function (){var statearr_17220 = state_17204;
(statearr_17220[(18)] = inst_17160__$1);

(statearr_17220[(16)] = inst_17161);

return statearr_17220;
})();
if(cljs.core.truth_(inst_17160__$1)){
var statearr_17221_17263 = state_17204__$1;
(statearr_17221_17263[(1)] = (19));

} else {
var statearr_17222_17264 = state_17204__$1;
(statearr_17222_17264[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (3))){
var inst_17202 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17204__$1,inst_17202);
} else {
if((state_val_17205 === (12))){
var inst_17127 = (state_17204[(19)]);
var inst_17138 = (state_17204[(12)]);
var inst_17133 = cljs.core.vals(inst_17127);
var inst_17134 = cljs.core.flatten(inst_17133);
var inst_17135 = cljs.core.set(inst_17134);
var inst_17136 = cljs.core.keys(inst_17127);
var inst_17137 = cljs.core.set(inst_17136);
var inst_17138__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_17135,inst_17137);
var inst_17139 = cljs.core.empty_QMARK_(inst_17138__$1);
var state_17204__$1 = (function (){var statearr_17223 = state_17204;
(statearr_17223[(12)] = inst_17138__$1);

return statearr_17223;
})();
if(inst_17139){
var statearr_17224_17265 = state_17204__$1;
(statearr_17224_17265[(1)] = (14));

} else {
var statearr_17225_17266 = state_17204__$1;
(statearr_17225_17266[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (2))){
var inst_17121 = (state_17204[(17)]);
var _ = (function (){var statearr_17226 = state_17204;
(statearr_17226[(4)] = cljs.core.cons((5),(state_17204[(4)])));

return statearr_17226;
})();
var inst_17121__$1 = depth;
var state_17204__$1 = (function (){var statearr_17227 = state_17204;
(statearr_17227[(17)] = inst_17121__$1);

return statearr_17227;
})();
if(cljs.core.truth_(inst_17121__$1)){
var statearr_17228_17267 = state_17204__$1;
(statearr_17228_17267[(1)] = (6));

} else {
var statearr_17229_17268 = state_17204__$1;
(statearr_17229_17268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (23))){
var inst_17192 = (state_17204[(10)]);
var state_17204__$1 = state_17204;
var statearr_17230_17269 = state_17204__$1;
(statearr_17230_17269[(2)] = inst_17192);

(statearr_17230_17269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (19))){
var inst_17160 = (state_17204[(18)]);
var inst_17163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17164 = [inst_17160,predicate];
var inst_17165 = (new cljs.core.PersistentVector(null,2,(5),inst_17163,inst_17164,null));
var inst_17166 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17165);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17204__$1,(22),inst_17166);
} else {
if((state_val_17205 === (11))){
var inst_17127 = (state_17204[(19)]);
var state_17204__$1 = state_17204;
var statearr_17232_17270 = state_17204__$1;
(statearr_17232_17270[(2)] = inst_17127);

(statearr_17232_17270[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (9))){
var inst_17125 = (state_17204[(8)]);
var inst_17128 = (state_17204[(20)]);
var inst_17130 = (inst_17128 >= inst_17125);
var state_17204__$1 = state_17204;
if(cljs.core.truth_(inst_17130)){
var statearr_17233_17271 = state_17204__$1;
(statearr_17233_17271[(1)] = (11));

} else {
var statearr_17234_17272 = state_17204__$1;
(statearr_17234_17272[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (5))){
var _ = (function (){var statearr_17235 = state_17204;
(statearr_17235[(4)] = cljs.core.rest((state_17204[(4)])));

return statearr_17235;
})();
var state_17204__$1 = state_17204;
var ex17231 = (state_17204__$1[(2)]);
var statearr_17236_17273 = state_17204__$1;
(statearr_17236_17273[(5)] = ex17231);


if((ex17231 instanceof Error)){
var statearr_17237_17274 = state_17204__$1;
(statearr_17237_17274[(1)] = (4));

(statearr_17237_17274[(5)] = null);

} else {
throw ex17231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (14))){
var inst_17127 = (state_17204[(19)]);
var state_17204__$1 = state_17204;
var statearr_17238_17275 = state_17204__$1;
(statearr_17238_17275[(2)] = inst_17127);

(statearr_17238_17275[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (16))){
var inst_17185 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17239_17276 = state_17204__$1;
(statearr_17239_17276[(2)] = inst_17185);

(statearr_17239_17276[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (10))){
var inst_17191 = (state_17204[(9)]);
var inst_17190 = (state_17204[(11)]);
var inst_17189 = (state_17204[(2)]);
var inst_17190__$1 = cljs.core.keys(inst_17189);
var inst_17191__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_17190__$1,inst_17189);
var inst_17192 = fluree.db.query.analytical.recur_map__GT_tuples(inst_17190__$1,inst_17191__$1);
var state_17204__$1 = (function (){var statearr_17240 = state_17204;
(statearr_17240[(9)] = inst_17191__$1);

(statearr_17240[(10)] = inst_17192);

(statearr_17240[(11)] = inst_17190__$1);

return statearr_17240;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_17241_17277 = state_17204__$1;
(statearr_17241_17277[(1)] = (23));

} else {
var statearr_17242_17278 = state_17204__$1;
(statearr_17242_17278[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (18))){
var inst_17128 = (state_17204[(20)]);
var inst_17127 = (state_17204[(19)]);
var inst_17176 = (state_17204[(2)]);
var inst_17177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17178 = [(0),(2)];
var inst_17179 = (new cljs.core.PersistentVector(null,2,(5),inst_17177,inst_17178,null));
var inst_17180 = fluree.db.query.analytical.get_ns_arrays(inst_17179,inst_17176);
var inst_17181 = fluree.db.query.analytical.tuples__GT_map(inst_17127,inst_17180);
var inst_17182 = (inst_17128 + (1));
var inst_17127__$1 = inst_17181;
var inst_17128__$1 = inst_17182;
var state_17204__$1 = (function (){var statearr_17243 = state_17204;
(statearr_17243[(20)] = inst_17128__$1);

(statearr_17243[(19)] = inst_17127__$1);

return statearr_17243;
})();
var statearr_17244_17279 = state_17204__$1;
(statearr_17244_17279[(2)] = null);

(statearr_17244_17279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17205 === (8))){
var inst_17125 = (state_17204[(2)]);
var inst_17126 = recur_map;
var inst_17127 = inst_17126;
var inst_17128 = (1);
var state_17204__$1 = (function (){var statearr_17245 = state_17204;
(statearr_17245[(8)] = inst_17125);

(statearr_17245[(20)] = inst_17128);

(statearr_17245[(19)] = inst_17127);

return statearr_17245;
})();
var statearr_17246_17280 = state_17204__$1;
(statearr_17246_17280[(2)] = null);

(statearr_17246_17280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0 = (function (){
var statearr_17247 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17247[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__);

(statearr_17247[(1)] = (1));

return statearr_17247;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1 = (function (state_17204){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_17204);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17248){var ex__2882__auto__ = e17248;
var statearr_17249_17281 = state_17204;
(statearr_17249_17281[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_17204[(4)]))){
var statearr_17250_17282 = state_17204;
(statearr_17250_17282[(1)] = cljs.core.first((state_17204[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17283 = state_17204;
state_17204 = G__17283;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__ = function(state_17204){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1.call(this,state_17204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17251 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_17251[(6)] = c__2901__auto__);

return statearr_17251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__17284,clause,fuel,max_fuel){
var map__17285 = p__17284;
var map__17285__$1 = (((((!((map__17285 == null))))?(((((map__17285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17285):map__17285);
var res = map__17285__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17285__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17285__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17285__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17417){
var state_val_17418 = (state_17417[(1)]);
if((state_val_17418 === (7))){
var state_17417__$1 = state_17417;
var statearr_17419_17485 = state_17417__$1;
(statearr_17419_17485[(2)] = false);

(statearr_17419_17485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (20))){
var inst_17349 = (state_17417[(7)]);
var state_17417__$1 = state_17417;
var statearr_17420_17486 = state_17417__$1;
(statearr_17420_17486[(2)] = inst_17349);

(statearr_17420_17486[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (27))){
var inst_17353 = (state_17417[(8)]);
var inst_17377 = (state_17417[(2)]);
var state_17417__$1 = (function (){var statearr_17421 = state_17417;
(statearr_17421[(9)] = inst_17377);

return statearr_17421;
})();
if(cljs.core.truth_(inst_17353)){
var statearr_17422_17487 = state_17417__$1;
(statearr_17422_17487[(1)] = (28));

} else {
var statearr_17423_17488 = state_17417__$1;
(statearr_17423_17488[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (1))){
var state_17417__$1 = state_17417;
var statearr_17424_17489 = state_17417__$1;
(statearr_17424_17489[(2)] = null);

(statearr_17424_17489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (24))){
var inst_17365 = (state_17417[(2)]);
var inst_17366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_17367 = fluree.db.query.analytical.variable_QMARK_(inst_17366);
var state_17417__$1 = (function (){var statearr_17425 = state_17417;
(statearr_17425[(10)] = inst_17365);

return statearr_17425;
})();
if(cljs.core.truth_(inst_17367)){
var statearr_17426_17490 = state_17417__$1;
(statearr_17426_17490[(1)] = (25));

} else {
var statearr_17427_17491 = state_17417__$1;
(statearr_17427_17491[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (4))){
var inst_17287 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
var statearr_17428_17492 = state_17417__$1;
(statearr_17428_17492[(2)] = inst_17287);

(statearr_17428_17492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (15))){
var inst_17335 = (state_17417[(11)]);
var state_17417__$1 = state_17417;
var statearr_17429_17493 = state_17417__$1;
(statearr_17429_17493[(2)] = inst_17335);

(statearr_17429_17493[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (21))){
var inst_17320 = (state_17417[(12)]);
var inst_17408 = (state_17417[(2)]);
var inst_17409 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_17410 = cljs.core.keys(inst_17320);
var inst_17411 = [inst_17410,vars,inst_17408];
var inst_17412 = cljs.core.PersistentHashMap.fromArrays(inst_17409,inst_17411);
var _ = (function (){var statearr_17430 = state_17417;
(statearr_17430[(4)] = cljs.core.rest((state_17417[(4)])));

return statearr_17430;
})();
var state_17417__$1 = state_17417;
var statearr_17431_17494 = state_17417__$1;
(statearr_17431_17494[(2)] = inst_17412);

(statearr_17431_17494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (31))){
var inst_17349 = (state_17417[(7)]);
var inst_17351 = (state_17417[(13)]);
var inst_17384 = cljs.core.PersistentHashMap.EMPTY;
var inst_17385 = cljs.core.flatten(inst_17349);
var inst_17386 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17384,inst_17351,inst_17385);
var state_17417__$1 = state_17417;
var statearr_17432_17495 = state_17417__$1;
(statearr_17432_17495[(2)] = inst_17386);

(statearr_17432_17495[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (32))){
var inst_17351 = (state_17417[(13)]);
var inst_17388 = cljs.core.coll_QMARK_(inst_17351);
var state_17417__$1 = state_17417;
if(inst_17388){
var statearr_17433_17496 = state_17417__$1;
(statearr_17433_17496[(1)] = (34));

} else {
var statearr_17434_17497 = state_17417__$1;
(statearr_17434_17497[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (33))){
var inst_17399 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
var statearr_17435_17498 = state_17417__$1;
(statearr_17435_17498[(2)] = inst_17399);

(statearr_17435_17498[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (13))){
var inst_17297 = (state_17417[(14)]);
var state_17417__$1 = state_17417;
var statearr_17436_17499 = state_17417__$1;
(statearr_17436_17499[(2)] = inst_17297);

(statearr_17436_17499[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (22))){
var inst_17333 = (state_17417[(15)]);
var inst_17357 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17333)].join('');
var inst_17358 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17359 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17360 = cljs.core.PersistentHashMap.fromArrays(inst_17358,inst_17359);
var inst_17361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17357,inst_17360);
var inst_17362 = (function(){throw inst_17361})();
var state_17417__$1 = state_17417;
var statearr_17437_17500 = state_17417__$1;
(statearr_17437_17500[(2)] = inst_17362);

(statearr_17437_17500[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (36))){
var inst_17397 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
var statearr_17438_17501 = state_17417__$1;
(statearr_17438_17501[(2)] = inst_17397);

(statearr_17438_17501[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (29))){
var inst_17351 = (state_17417[(13)]);
var inst_17382 = typeof inst_17351 === 'number';
var state_17417__$1 = state_17417;
if(cljs.core.truth_(inst_17382)){
var statearr_17439_17502 = state_17417__$1;
(statearr_17439_17502[(1)] = (31));

} else {
var statearr_17440_17503 = state_17417__$1;
(statearr_17440_17503[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (6))){
var inst_17297 = (state_17417[(14)]);
var inst_17302 = inst_17297.cljs$lang$protocol_mask$partition0$;
var inst_17303 = (inst_17302 & (64));
var inst_17304 = inst_17297.cljs$core$ISeq$;
var inst_17305 = (cljs.core.PROTOCOL_SENTINEL === inst_17304);
var inst_17306 = ((inst_17303) || (inst_17305));
var state_17417__$1 = state_17417;
if(cljs.core.truth_(inst_17306)){
var statearr_17441_17504 = state_17417__$1;
(statearr_17441_17504[(1)] = (9));

} else {
var statearr_17442_17505 = state_17417__$1;
(statearr_17442_17505[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (28))){
var inst_17349 = (state_17417[(7)]);
var inst_17379 = cljs.core.PersistentHashMap.EMPTY;
var inst_17380 = fluree.db.query.analytical.tuples__GT_map(inst_17379,inst_17349);
var state_17417__$1 = state_17417;
var statearr_17443_17506 = state_17417__$1;
(statearr_17443_17506[(2)] = inst_17380);

(statearr_17443_17506[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (25))){
var state_17417__$1 = state_17417;
var statearr_17444_17507 = state_17417__$1;
(statearr_17444_17507[(2)] = null);

(statearr_17444_17507[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (34))){
var inst_17349 = (state_17417[(7)]);
var inst_17345 = (state_17417[(16)]);
var inst_17390 = cljs.core.PersistentHashMap.EMPTY;
var inst_17391 = cljs.core.first(inst_17345);
var inst_17392 = cljs.core.first(inst_17391);
var inst_17393 = cljs.core.flatten(inst_17349);
var inst_17394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17390,inst_17392,inst_17393);
var state_17417__$1 = state_17417;
var statearr_17445_17508 = state_17417__$1;
(statearr_17445_17508[(2)] = inst_17394);

(statearr_17445_17508[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (17))){
var inst_17333 = (state_17417[(15)]);
var inst_17334 = (state_17417[(17)]);
var inst_17339 = (state_17417[(2)]);
var inst_17340 = [inst_17339];
var inst_17341 = cljs.core.PersistentHashMap.fromArrays(inst_17334,inst_17340);
var inst_17342 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_17333,inst_17341);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17417__$1,(18),inst_17342);
} else {
if((state_val_17418 === (3))){
var inst_17415 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17417__$1,inst_17415);
} else {
if((state_val_17418 === (12))){
var inst_17297 = (state_17417[(14)]);
var inst_17315 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17297);
var state_17417__$1 = state_17417;
var statearr_17446_17509 = state_17417__$1;
(statearr_17446_17509[(2)] = inst_17315);

(statearr_17446_17509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (2))){
var inst_17297 = (state_17417[(14)]);
var _ = (function (){var statearr_17447 = state_17417;
(statearr_17447[(4)] = cljs.core.cons((5),(state_17417[(4)])));

return statearr_17447;
})();
var inst_17297__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_17299 = (inst_17297__$1 == null);
var inst_17300 = cljs.core.not(inst_17299);
var state_17417__$1 = (function (){var statearr_17448 = state_17417;
(statearr_17448[(14)] = inst_17297__$1);

return statearr_17448;
})();
if(inst_17300){
var statearr_17449_17510 = state_17417__$1;
(statearr_17449_17510[(1)] = (6));

} else {
var statearr_17450_17511 = state_17417__$1;
(statearr_17450_17511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (23))){
var state_17417__$1 = state_17417;
var statearr_17451_17512 = state_17417__$1;
(statearr_17451_17512[(2)] = null);

(statearr_17451_17512[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (35))){
var state_17417__$1 = state_17417;
var statearr_17452_17513 = state_17417__$1;
(statearr_17452_17513[(2)] = null);

(statearr_17452_17513[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (19))){
var inst_17333 = (state_17417[(15)]);
var inst_17354 = (state_17417[(18)]);
var inst_17351 = cljs.core.first(inst_17333);
var inst_17352 = cljs.core.first(clause);
var inst_17353 = fluree.db.query.analytical.variable_QMARK_(inst_17352);
var inst_17354__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_17333,(1));
var inst_17355 = fluree.db.query.analytical.variable_QMARK_(inst_17354__$1);
var state_17417__$1 = (function (){var statearr_17453 = state_17417;
(statearr_17453[(8)] = inst_17353);

(statearr_17453[(18)] = inst_17354__$1);

(statearr_17453[(13)] = inst_17351);

return statearr_17453;
})();
if(cljs.core.truth_(inst_17355)){
var statearr_17454_17514 = state_17417__$1;
(statearr_17454_17514[(1)] = (22));

} else {
var statearr_17455_17515 = state_17417__$1;
(statearr_17455_17515[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (11))){
var inst_17310 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
var statearr_17457_17516 = state_17417__$1;
(statearr_17457_17516[(2)] = inst_17310);

(statearr_17457_17516[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (9))){
var state_17417__$1 = state_17417;
var statearr_17458_17517 = state_17417__$1;
(statearr_17458_17517[(2)] = true);

(statearr_17458_17517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (5))){
var _ = (function (){var statearr_17459 = state_17417;
(statearr_17459[(4)] = cljs.core.rest((state_17417[(4)])));

return statearr_17459;
})();
var state_17417__$1 = state_17417;
var ex17456 = (state_17417__$1[(2)]);
var statearr_17460_17518 = state_17417__$1;
(statearr_17460_17518[(5)] = ex17456);


if((ex17456 instanceof Error)){
var statearr_17461_17519 = state_17417__$1;
(statearr_17461_17519[(1)] = (4));

(statearr_17461_17519[(5)] = null);

} else {
throw ex17456;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (14))){
var inst_17335 = (state_17417[(11)]);
var inst_17323 = (state_17417[(19)]);
var inst_17324 = (state_17417[(20)]);
var inst_17320 = (state_17417[(12)]);
var inst_17318 = (state_17417[(2)]);
var inst_17319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17318,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_17320__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17318,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_17321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17318,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_17322 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_17323__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17321);
var inst_17324__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_17321);
var inst_17326 = (function (){var map__17293 = inst_17318;
var search = inst_17319;
var rel = inst_17320__$1;
var opts = inst_17321;
var common_keys = inst_17322;
var object_fn = inst_17323__$1;
var recur_depth = inst_17324__$1;
return (function (p__17325,common_key){
var vec__17462 = p__17325;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17462,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17462,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__17465 = cljs.core._EQ_;
var expr__17466 = idx_of;
if(cljs.core.truth_((pred__17465.cljs$core$IFn$_invoke$arity$2 ? pred__17465.cljs$core$IFn$_invoke$arity$2((0),expr__17466) : pred__17465.call(null,(0),expr__17466)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__17465.cljs$core$IFn$_invoke$arity$2 ? pred__17465.cljs$core$IFn$_invoke$arity$2((1),expr__17466) : pred__17465.call(null,(1),expr__17466)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__17465.cljs$core$IFn$_invoke$arity$2 ? pred__17465.cljs$core$IFn$_invoke$arity$2((2),expr__17466) : pred__17465.call(null,(2),expr__17466)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__17466)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_17327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17328 = cljs.core.PersistentHashMap.EMPTY;
var inst_17329 = [inst_17328,inst_17319];
var inst_17330 = (new cljs.core.PersistentVector(null,2,(5),inst_17327,inst_17329,null));
var inst_17331 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17326,inst_17330,inst_17322);
var inst_17332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17331,(0),null);
var inst_17333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17331,(1),null);
var inst_17334 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_17335__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17332);
var state_17417__$1 = (function (){var statearr_17468 = state_17417;
(statearr_17468[(11)] = inst_17335__$1);

(statearr_17468[(19)] = inst_17323__$1);

(statearr_17468[(15)] = inst_17333);

(statearr_17468[(20)] = inst_17324__$1);

(statearr_17468[(17)] = inst_17334);

(statearr_17468[(12)] = inst_17320__$1);

return statearr_17468;
})();
if(cljs.core.truth_(inst_17335__$1)){
var statearr_17469_17520 = state_17417__$1;
(statearr_17469_17520[(1)] = (15));

} else {
var statearr_17470_17521 = state_17417__$1;
(statearr_17470_17521[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (26))){
var inst_17333 = (state_17417[(15)]);
var inst_17370 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17333)].join('');
var inst_17371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17372 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17373 = cljs.core.PersistentHashMap.fromArrays(inst_17371,inst_17372);
var inst_17374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17370,inst_17373);
var inst_17375 = (function(){throw inst_17374})();
var state_17417__$1 = state_17417;
var statearr_17471_17522 = state_17417__$1;
(statearr_17471_17522[(2)] = inst_17375);

(statearr_17471_17522[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (16))){
var inst_17323 = (state_17417[(19)]);
var state_17417__$1 = state_17417;
var statearr_17472_17523 = state_17417__$1;
(statearr_17472_17523[(2)] = inst_17323);

(statearr_17472_17523[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (30))){
var inst_17353 = (state_17417[(8)]);
var inst_17324 = (state_17417[(20)]);
var inst_17354 = (state_17417[(18)]);
var inst_17401 = (state_17417[(2)]);
var inst_17402 = fluree.db.query.analytical.tuples__GT_recur(db,inst_17354,inst_17401,inst_17324,inst_17353);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17417__$1,(37),inst_17402);
} else {
if((state_val_17418 === (10))){
var state_17417__$1 = state_17417;
var statearr_17473_17524 = state_17417__$1;
(statearr_17473_17524[(2)] = false);

(statearr_17473_17524[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (18))){
var inst_17345 = (state_17417[(16)]);
var inst_17324 = (state_17417[(20)]);
var inst_17320 = (state_17417[(12)]);
var inst_17344 = (state_17417[(2)]);
var inst_17345__$1 = fluree.db.util.async.throw_err(inst_17344);
var inst_17346 = cljs.core.count(inst_17345__$1);
var inst_17347 = fluree.db.query.analytical.add_fuel(inst_17346,fuel,max_fuel);
var inst_17348 = cljs.core.vals(inst_17320);
var inst_17349 = fluree.db.query.analytical.get_ns_arrays(inst_17348,inst_17345__$1);
var state_17417__$1 = (function (){var statearr_17474 = state_17417;
(statearr_17474[(7)] = inst_17349);

(statearr_17474[(16)] = inst_17345__$1);

(statearr_17474[(21)] = inst_17347);

return statearr_17474;
})();
if(cljs.core.truth_(inst_17324)){
var statearr_17475_17525 = state_17417__$1;
(statearr_17475_17525[(1)] = (19));

} else {
var statearr_17476_17526 = state_17417__$1;
(statearr_17476_17526[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (37))){
var inst_17404 = (state_17417[(2)]);
var inst_17405 = fluree.db.util.async.throw_err(inst_17404);
var state_17417__$1 = state_17417;
var statearr_17477_17527 = state_17417__$1;
(statearr_17477_17527[(2)] = inst_17405);

(statearr_17477_17527[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (8))){
var inst_17313 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
if(cljs.core.truth_(inst_17313)){
var statearr_17478_17528 = state_17417__$1;
(statearr_17478_17528[(1)] = (12));

} else {
var statearr_17479_17529 = state_17417__$1;
(statearr_17479_17529[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_17480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17480[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__);

(statearr_17480[(1)] = (1));

return statearr_17480;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1 = (function (state_17417){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_17417);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17481){var ex__2882__auto__ = e17481;
var statearr_17482_17530 = state_17417;
(statearr_17482_17530[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_17417[(4)]))){
var statearr_17483_17531 = state_17417;
(statearr_17483_17531[(1)] = cljs.core.first((state_17417[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17532 = state_17417;
state_17417 = G__17532;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__ = function(state_17417){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1.call(this,state_17417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17484 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_17484[(6)] = c__2901__auto__);

return statearr_17484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__17533,res,clause){
var map__17534 = p__17533;
var map__17534__$1 = (((((!((map__17534 == null))))?(((((map__17534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17534):map__17534);
var db = map__17534__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17534__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17534__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17534__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17634){
var state_val_17635 = (state_17634[(1)]);
if((state_val_17635 === (7))){
var inst_17545 = (state_17634[(7)]);
var state_17634__$1 = state_17634;
var statearr_17636_17676 = state_17634__$1;
(statearr_17636_17676[(2)] = inst_17545);

(statearr_17636_17676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (20))){
var inst_17625 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
var statearr_17637_17677 = state_17634__$1;
(statearr_17637_17677[(2)] = inst_17625);

(statearr_17637_17677[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (1))){
var state_17634__$1 = state_17634;
var statearr_17638_17678 = state_17634__$1;
(statearr_17638_17678[(2)] = null);

(statearr_17638_17678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (24))){
var inst_17604 = (state_17634[(2)]);
var inst_17605 = fluree.db.util.async.throw_err(inst_17604);
var state_17634__$1 = state_17634;
var statearr_17639_17679 = state_17634__$1;
(statearr_17639_17679[(2)] = inst_17605);

(statearr_17639_17679[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (4))){
var inst_17538 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
var statearr_17640_17680 = state_17634__$1;
(statearr_17640_17680[(2)] = inst_17538);

(statearr_17640_17680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (15))){
var inst_17545 = (state_17634[(7)]);
var inst_17547 = (state_17634[(8)]);
var inst_17566 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17567 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17569 = [inst_17545];
var inst_17570 = (new cljs.core.PersistentVector(null,1,(5),inst_17568,inst_17569,null));
var inst_17571 = (function (){var subject_var = inst_17545;
var object_var = inst_17547;
var min_sid = inst_17566;
var max_sid = (0);
return (function (p1__17536_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17536_SHARP_);
});
})();
var inst_17572 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_17566,(0));
var inst_17573 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17571,inst_17572);
var inst_17574 = cljs.core.PersistentHashMap.EMPTY;
var inst_17575 = [inst_17570,inst_17573,inst_17574];
var inst_17576 = cljs.core.PersistentHashMap.fromArrays(inst_17567,inst_17575);
var state_17634__$1 = state_17634;
var statearr_17641_17681 = state_17634__$1;
(statearr_17641_17681[(2)] = inst_17576);

(statearr_17641_17681[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (21))){
var inst_17598 = (state_17634[(9)]);
var state_17634__$1 = state_17634;
var statearr_17642_17682 = state_17634__$1;
(statearr_17642_17682[(2)] = inst_17598);

(statearr_17642_17682[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (13))){
var inst_17547 = (state_17634[(8)]);
var state_17634__$1 = state_17634;
if(cljs.core.truth_(inst_17547)){
var statearr_17643_17683 = state_17634__$1;
(statearr_17643_17683[(1)] = (18));

} else {
var statearr_17644_17684 = state_17634__$1;
(statearr_17644_17684[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (22))){
var inst_17598 = (state_17634[(9)]);
var inst_17602 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_17598);
var state_17634__$1 = state_17634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17634__$1,(24),inst_17602);
} else {
if((state_val_17635 === (6))){
var inst_17547 = (state_17634[(8)]);
var state_17634__$1 = state_17634;
var statearr_17645_17685 = state_17634__$1;
(statearr_17645_17685[(2)] = inst_17547);

(statearr_17645_17685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (17))){
var inst_17595 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
var statearr_17646_17686 = state_17634__$1;
(statearr_17646_17686[(2)] = inst_17595);

(statearr_17646_17686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (3))){
var inst_17632 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17634__$1,inst_17632);
} else {
if((state_val_17635 === (12))){
var inst_17560 = ["_tx",null,"_block",null];
var inst_17561 = (new cljs.core.PersistentArrayMap(null,2,inst_17560,null));
var inst_17562 = (new cljs.core.PersistentHashSet(null,inst_17561,null));
var inst_17563 = cljs.core.last(clause);
var inst_17564 = (inst_17562.cljs$core$IFn$_invoke$arity$1 ? inst_17562.cljs$core$IFn$_invoke$arity$1(inst_17563) : inst_17562.call(null,inst_17563));
var state_17634__$1 = state_17634;
if(cljs.core.truth_(inst_17564)){
var statearr_17647_17687 = state_17634__$1;
(statearr_17647_17687[(1)] = (15));

} else {
var statearr_17648_17688 = state_17634__$1;
(statearr_17648_17688[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (2))){
var inst_17545 = (state_17634[(7)]);
var _ = (function (){var statearr_17649 = state_17634;
(statearr_17649[(4)] = cljs.core.cons((5),(state_17634[(4)])));

return statearr_17649;
})();
var inst_17544 = cljs.core.first(clause);
var inst_17545__$1 = fluree.db.query.analytical.variable_QMARK_(inst_17544);
var inst_17546 = cljs.core.last(clause);
var inst_17547 = fluree.db.query.analytical.variable_QMARK_(inst_17546);
var state_17634__$1 = (function (){var statearr_17650 = state_17634;
(statearr_17650[(7)] = inst_17545__$1);

(statearr_17650[(8)] = inst_17547);

return statearr_17650;
})();
if(cljs.core.truth_(inst_17545__$1)){
var statearr_17651_17689 = state_17634__$1;
(statearr_17651_17689[(1)] = (6));

} else {
var statearr_17652_17690 = state_17634__$1;
(statearr_17652_17690[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (23))){
var inst_17547 = (state_17634[(8)]);
var inst_17607 = (state_17634[(2)]);
var inst_17608 = fluree.db.flake.sid__GT_cid(inst_17607);
var inst_17609 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_17608);
var inst_17610 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17612 = [inst_17547];
var inst_17613 = (new cljs.core.PersistentVector(null,1,(5),inst_17611,inst_17612,null));
var inst_17614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17616 = [inst_17609];
var inst_17617 = (new cljs.core.PersistentVector(null,1,(5),inst_17615,inst_17616,null));
var inst_17618 = [inst_17617];
var inst_17619 = (new cljs.core.PersistentVector(null,1,(5),inst_17614,inst_17618,null));
var inst_17620 = cljs.core.PersistentHashMap.EMPTY;
var inst_17621 = [inst_17613,inst_17619,inst_17620];
var inst_17622 = cljs.core.PersistentHashMap.fromArrays(inst_17610,inst_17621);
var state_17634__$1 = state_17634;
var statearr_17653_17691 = state_17634__$1;
(statearr_17653_17691[(2)] = inst_17622);

(statearr_17653_17691[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (19))){
var state_17634__$1 = state_17634;
var statearr_17654_17692 = state_17634__$1;
(statearr_17654_17692[(2)] = null);

(statearr_17654_17692[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (11))){
var inst_17629 = (state_17634[(2)]);
var _ = (function (){var statearr_17656 = state_17634;
(statearr_17656[(4)] = cljs.core.rest((state_17634[(4)])));

return statearr_17656;
})();
var state_17634__$1 = state_17634;
var statearr_17657_17693 = state_17634__$1;
(statearr_17657_17693[(2)] = inst_17629);

(statearr_17657_17693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (9))){
var inst_17553 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17554 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17555 = cljs.core.PersistentHashMap.fromArrays(inst_17553,inst_17554);
var inst_17556 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_17555);
var inst_17557 = (function(){throw inst_17556})();
var state_17634__$1 = state_17634;
var statearr_17658_17694 = state_17634__$1;
(statearr_17658_17694[(2)] = inst_17557);

(statearr_17658_17694[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (5))){
var _ = (function (){var statearr_17659 = state_17634;
(statearr_17659[(4)] = cljs.core.rest((state_17634[(4)])));

return statearr_17659;
})();
var state_17634__$1 = state_17634;
var ex17655 = (state_17634__$1[(2)]);
var statearr_17660_17695 = state_17634__$1;
(statearr_17660_17695[(5)] = ex17655);


if((ex17655 instanceof Error)){
var statearr_17661_17696 = state_17634__$1;
(statearr_17661_17696[(1)] = (4));

(statearr_17661_17696[(5)] = null);

} else {
throw ex17655;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (14))){
var inst_17627 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
var statearr_17662_17697 = state_17634__$1;
(statearr_17662_17697[(2)] = inst_17627);

(statearr_17662_17697[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (16))){
var inst_17545 = (state_17634[(7)]);
var inst_17547 = (state_17634[(8)]);
var inst_17578 = cljs.core.last(clause);
var inst_17579 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_17578);
var inst_17580 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_17581 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17580,inst_17579);
var inst_17582 = fluree.db.flake.min_subject_id(inst_17579);
var inst_17583 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17585 = [inst_17545];
var inst_17586 = (new cljs.core.PersistentVector(null,1,(5),inst_17584,inst_17585,null));
var inst_17587 = (function (){var subject_var = inst_17545;
var object_var = inst_17547;
var cid = inst_17579;
var max_sid = inst_17581;
var min_sid = inst_17582;
return (function (p1__17537_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17537_SHARP_);
});
})();
var inst_17588 = (inst_17581 + (1));
var inst_17589 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_17582,inst_17588);
var inst_17590 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17587,inst_17589);
var inst_17591 = cljs.core.PersistentHashMap.EMPTY;
var inst_17592 = [inst_17586,inst_17590,inst_17591];
var inst_17593 = cljs.core.PersistentHashMap.fromArrays(inst_17583,inst_17592);
var state_17634__$1 = state_17634;
var statearr_17663_17698 = state_17634__$1;
(statearr_17663_17698[(2)] = inst_17593);

(statearr_17663_17698[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (10))){
var inst_17545 = (state_17634[(7)]);
var state_17634__$1 = state_17634;
if(cljs.core.truth_(inst_17545)){
var statearr_17664_17699 = state_17634__$1;
(statearr_17664_17699[(1)] = (12));

} else {
var statearr_17665_17700 = state_17634__$1;
(statearr_17665_17700[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (18))){
var inst_17598 = (state_17634[(9)]);
var inst_17598__$1 = cljs.core.first(clause);
var inst_17599 = typeof inst_17598__$1 === 'number';
var state_17634__$1 = (function (){var statearr_17666 = state_17634;
(statearr_17666[(9)] = inst_17598__$1);

return statearr_17666;
})();
if(cljs.core.truth_(inst_17599)){
var statearr_17667_17701 = state_17634__$1;
(statearr_17667_17701[(1)] = (21));

} else {
var statearr_17668_17702 = state_17634__$1;
(statearr_17668_17702[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17635 === (8))){
var inst_17551 = (state_17634[(2)]);
var state_17634__$1 = state_17634;
if(cljs.core.truth_(inst_17551)){
var statearr_17669_17703 = state_17634__$1;
(statearr_17669_17703[(1)] = (9));

} else {
var statearr_17670_17704 = state_17634__$1;
(statearr_17670_17704[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_17671 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17671[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__);

(statearr_17671[(1)] = (1));

return statearr_17671;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1 = (function (state_17634){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_17634);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17672){var ex__2882__auto__ = e17672;
var statearr_17673_17705 = state_17634;
(statearr_17673_17705[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_17634[(4)]))){
var statearr_17674_17706 = state_17634;
(statearr_17674_17706[(1)] = cljs.core.first((state_17634[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17707 = state_17634;
state_17634 = G__17707;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__ = function(state_17634){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1.call(this,state_17634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17675 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_17675[(6)] = c__2901__auto__);

return statearr_17675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__17714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__17714 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__17714;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__17715(s__17716){
return (new cljs.core.LazySeq(null,(function (){
var s__17716__$1 = s__17716;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__17716__$1);
if(temp__5735__auto__){
var s__17716__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17716__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__17716__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__17718 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__17717 = (0);
while(true){
if((i__17717 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__17717);
var delta = (x - mean);
cljs.core.chunk_append(b__17718,(delta * delta));

var G__17720 = (i__17717 + (1));
i__17717 = G__17720;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17718),fluree$db$query$analytical$variance_$_iter__17715(cljs.core.chunk_rest(s__17716__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17718),null);
}
} else {
var x = cljs.core.first(s__17716__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__17715(cljs.core.rest(s__17716__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__17719 = variance(coll);
return Math.sqrt(G__17719);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__17721 = null;
var G__17721__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17721__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17721 = function(n,coll){
switch(arguments.length){
case 1:
return G__17721__1.call(this,n);
case 2:
return G__17721__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17721.cljs$core$IFn$_invoke$arity$1 = G__17721__1;
G__17721.cljs$core$IFn$_invoke$arity$2 = G__17721__2;
return G__17721;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17722 = null;
var G__17722__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17722__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17722 = function(n,coll){
switch(arguments.length){
case 1:
return G__17722__1.call(this,n);
case 2:
return G__17722__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17722.cljs$core$IFn$_invoke$arity$1 = G__17722__1;
G__17722.cljs$core$IFn$_invoke$arity$2 = G__17722__2;
return G__17722;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17723 = null;
var G__17723__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__17723__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__17723 = function(n,coll){
switch(arguments.length){
case 1:
return G__17723__1.call(this,n);
case 2:
return G__17723__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17723.cljs$core$IFn$_invoke$arity$1 = G__17723__1;
G__17723.cljs$core$IFn$_invoke$arity$2 = G__17723__2;
return G__17723;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__17724 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17724,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17724,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17724,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17727 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__17730 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__17730) : agg_fn.call(null,G__17730));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17727,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17727,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__17731 = agg;
var map__17731__$1 = (((((!((map__17731 == null))))?(((((map__17731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17731.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17731):map__17731);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17731__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17731__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17731__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__17734 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17734,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17734,(1),null);
var map__17737 = res__$1;
var map__17737__$1 = (((((!((map__17737 == null))))?(((((map__17737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17737.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17737):map__17737);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17737__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17737__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17733_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__17733_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17739_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__17739_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17740_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__17740_SHARP_);
}),a_idxs);
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5733__auto__)){
var b_matched = temp__5733__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17741_SHARP_,p2__17742_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17741_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__17742_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17743_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__17743_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__17746,row,b_tuple){
var vec__17747 = p__17746;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17747,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17747,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17744_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17744_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17745_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17745_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17750_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__17750_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17751_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17751_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17756 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17758 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__17757 = (function (p1__17752_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17752_SHARP_);
});
return fexpr__17757(G__17758);
})()),cljs.core.set(b_idxs));
var fexpr__17755 = (function (p1__17753_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17753_SHARP_);
});
return fexpr__17755(G__17756);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17754_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17754_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17759_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17759_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17760_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17760_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17765 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17767 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__17766 = (function (p1__17761_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17761_SHARP_);
});
return fexpr__17766(G__17767);
})()),cljs.core.set(b_idxs));
var fexpr__17764 = (function (p1__17762_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17762_SHARP_);
});
return fexpr__17764(G__17765);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17763_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17763_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17768_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17768_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17769_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17769_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17778 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17780 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__17779 = (function (p1__17770_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17770_SHARP_);
});
return fexpr__17779(G__17780);
})()),cljs.core.set(b_idxs));
var fexpr__17777 = (function (p1__17771_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17771_SHARP_);
});
return fexpr__17777(G__17778);
})();
var vec__17774 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__17781,a_tuple){
var vec__17782 = p__17781;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17782,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17782,(1),null);
var vec__17785 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17785,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17785,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17774,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17774,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17772_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17772_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17773_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17773_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__17789 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17789,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17789,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__17788_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__17788_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__17794 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17794,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17794,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17792_SHARP_){
return fluree.db.util.core.index_of(headers,p1__17792_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__17793_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__17793_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__17797,filters,optional_QMARK_){
var map__17798 = p__17797;
var map__17798__$1 = (((((!((map__17798 == null))))?(((((map__17798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17798):map__17798);
var tuple_map = map__17798__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17798__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17798__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17798__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__17800 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17800,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17800,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__17803 = res;
var map__17803__$1 = (((((!((map__17803 == null))))?(((((map__17803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17803.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17803):map__17803);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17803__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17803__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17860){
var state_val_17861 = (state_17860[(1)]);
if((state_val_17861 === (7))){
var inst_17834 = (state_17860[(7)]);
var inst_17832 = (state_17860[(2)]);
var inst_17833 = fluree.db.util.async.throw_err(inst_17832);
var inst_17834__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17833,(0),null);
var inst_17835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17833,(1),null);
var inst_17836 = (inst_17834__$1 == null);
var state_17860__$1 = (function (){var statearr_17862 = state_17860;
(statearr_17862[(7)] = inst_17834__$1);

(statearr_17862[(8)] = inst_17835);

return statearr_17862;
})();
if(cljs.core.truth_(inst_17836)){
var statearr_17863_17892 = state_17860__$1;
(statearr_17863_17892[(1)] = (8));

} else {
var statearr_17864_17893 = state_17860__$1;
(statearr_17864_17893[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (1))){
var inst_17812 = optional_clauses;
var inst_17813 = cljs.core.seq(inst_17812);
var inst_17814 = cljs.core.first(inst_17813);
var inst_17815 = cljs.core.next(inst_17813);
var inst_17816 = where_tuples;
var inst_17817 = inst_17812;
var inst_17818 = inst_17816;
var state_17860__$1 = (function (){var statearr_17865 = state_17860;
(statearr_17865[(9)] = inst_17817);

(statearr_17865[(10)] = inst_17814);

(statearr_17865[(11)] = inst_17815);

(statearr_17865[(12)] = inst_17818);

return statearr_17865;
})();
var statearr_17866_17894 = state_17860__$1;
(statearr_17866_17894[(2)] = null);

(statearr_17866_17894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (4))){
var inst_17824 = (state_17860[(13)]);
var inst_17825 = (state_17860[(14)]);
var inst_17818 = (state_17860[(12)]);
var inst_17830 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_17818,inst_17824,inst_17825,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_17818,inst_17824,inst_17825,true,fuel,max_fuel,opts));
var state_17860__$1 = state_17860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17860__$1,(7),inst_17830);
} else {
if((state_val_17861 === (15))){
var state_17860__$1 = state_17860;
var statearr_17867_17895 = state_17860__$1;
(statearr_17867_17895[(2)] = null);

(statearr_17867_17895[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (13))){
var inst_17851 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
var statearr_17868_17896 = state_17860__$1;
(statearr_17868_17896[(2)] = inst_17851);

(statearr_17868_17896[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (6))){
var inst_17856 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
var statearr_17869_17897 = state_17860__$1;
(statearr_17869_17897[(2)] = inst_17856);

(statearr_17869_17897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (3))){
var inst_17858 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17860__$1,inst_17858);
} else {
if((state_val_17861 === (12))){
var state_17860__$1 = state_17860;
var statearr_17870_17898 = state_17860__$1;
(statearr_17870_17898[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (2))){
var inst_17824 = (state_17860[(13)]);
var inst_17817 = (state_17860[(9)]);
var inst_17823 = cljs.core.seq(inst_17817);
var inst_17824__$1 = cljs.core.first(inst_17823);
var inst_17825 = cljs.core.next(inst_17823);
var state_17860__$1 = (function (){var statearr_17872 = state_17860;
(statearr_17872[(13)] = inst_17824__$1);

(statearr_17872[(14)] = inst_17825);

return statearr_17872;
})();
if(cljs.core.truth_(inst_17824__$1)){
var statearr_17873_17899 = state_17860__$1;
(statearr_17873_17899[(1)] = (4));

} else {
var statearr_17874_17900 = state_17860__$1;
(statearr_17874_17900[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (11))){
var inst_17834 = (state_17860[(7)]);
var inst_17835 = (state_17860[(8)]);
var inst_17817 = inst_17835;
var inst_17818 = inst_17834;
var state_17860__$1 = (function (){var statearr_17875 = state_17860;
(statearr_17875[(9)] = inst_17817);

(statearr_17875[(12)] = inst_17818);

return statearr_17875;
})();
var statearr_17876_17901 = state_17860__$1;
(statearr_17876_17901[(2)] = null);

(statearr_17876_17901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (9))){
var inst_17824 = (state_17860[(13)]);
var inst_17840 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_17824);
var state_17860__$1 = state_17860;
if(cljs.core.truth_(inst_17840)){
var statearr_17877_17902 = state_17860__$1;
(statearr_17877_17902[(1)] = (11));

} else {
var statearr_17878_17903 = state_17860__$1;
(statearr_17878_17903[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (5))){
var inst_17818 = (state_17860[(12)]);
var state_17860__$1 = state_17860;
var statearr_17879_17904 = state_17860__$1;
(statearr_17879_17904[(2)] = inst_17818);

(statearr_17879_17904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (14))){
var inst_17834 = (state_17860[(7)]);
var inst_17835 = (state_17860[(8)]);
var inst_17818 = (state_17860[(12)]);
var inst_17845 = fluree.db.query.analytical.left_outer_join(inst_17818,inst_17834);
var inst_17817 = inst_17835;
var inst_17818__$1 = inst_17845;
var state_17860__$1 = (function (){var statearr_17880 = state_17860;
(statearr_17880[(9)] = inst_17817);

(statearr_17880[(12)] = inst_17818__$1);

return statearr_17880;
})();
var statearr_17881_17905 = state_17860__$1;
(statearr_17881_17905[(2)] = null);

(statearr_17881_17905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (16))){
var inst_17849 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
var statearr_17883_17906 = state_17860__$1;
(statearr_17883_17906[(2)] = inst_17849);

(statearr_17883_17906[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (10))){
var inst_17853 = (state_17860[(2)]);
var state_17860__$1 = state_17860;
var statearr_17884_17907 = state_17860__$1;
(statearr_17884_17907[(2)] = inst_17853);

(statearr_17884_17907[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17861 === (8))){
var inst_17835 = (state_17860[(8)]);
var inst_17818 = (state_17860[(12)]);
var tmp17882 = inst_17818;
var inst_17817 = inst_17835;
var inst_17818__$1 = tmp17882;
var state_17860__$1 = (function (){var statearr_17885 = state_17860;
(statearr_17885[(9)] = inst_17817);

(statearr_17885[(12)] = inst_17818__$1);

return statearr_17885;
})();
var statearr_17886_17908 = state_17860__$1;
(statearr_17886_17908[(2)] = null);

(statearr_17886_17908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0 = (function (){
var statearr_17887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17887[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__);

(statearr_17887[(1)] = (1));

return statearr_17887;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1 = (function (state_17860){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_17860);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17888){var ex__2882__auto__ = e17888;
var statearr_17889_17909 = state_17860;
(statearr_17889_17909[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_17860[(4)]))){
var statearr_17890_17910 = state_17860;
(statearr_17890_17910[(1)] = cljs.core.first((state_17860[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17911 = state_17860;
state_17860 = G__17911;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__ = function(state_17860){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1.call(this,state_17860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17891 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_17891[(6)] = c__2901__auto__);

return statearr_17891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__17913){
var vec__17914 = p__17913;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17914,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17914,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17912_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17912_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__17918,p__17919,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__17920 = p__17918;
var map__17920__$1 = (((((!((map__17920 == null))))?(((((map__17920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17920.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17920):map__17920);
var q_map = map__17920__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17920__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__17921 = p__17919;
var map__17921__$1 = (((((!((map__17921 == null))))?(((((map__17921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17921):map__17921);
var res = map__17921__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17921__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18130){
var state_val_18131 = (state_18130[(1)]);
if((state_val_18131 === (7))){
var inst_18028 = cljs.core.count(clause);
var inst_18029 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18028);
var inst_18030 = cljs.core.second(clause);
var inst_18031 = clojure.string.starts_with_QMARK_(inst_18030,"fullText:");
var inst_18032 = ((inst_18029) && (inst_18031));
var state_18130__$1 = state_18130;
if(cljs.core.truth_(inst_18032)){
var statearr_18132_18227 = state_18130__$1;
(statearr_18132_18227[(1)] = (31));

} else {
var statearr_18133_18228 = state_18130__$1;
(statearr_18133_18228[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (59))){
var inst_18099 = (state_18130[(7)]);
var inst_18102 = (state_18130[(2)]);
var inst_18103 = fluree.db.util.async.throw_err(inst_18102);
var inst_18104 = [inst_18103,r];
var inst_18105 = (new cljs.core.PersistentVector(null,2,(5),inst_18099,inst_18104,null));
var state_18130__$1 = state_18130;
var statearr_18134_18229 = state_18130__$1;
(statearr_18134_18229[(2)] = inst_18105);

(statearr_18134_18229[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (20))){
var inst_17992 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18135_18230 = state_18130__$1;
(statearr_18135_18230[(2)] = inst_17992);

(statearr_18135_18230[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (58))){
var inst_18108 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18136_18231 = state_18130__$1;
(statearr_18136_18231[(2)] = inst_18108);

(statearr_18136_18231[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (27))){
var inst_18022 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18137_18232 = state_18130__$1;
(statearr_18137_18232[(2)] = inst_18022);

(statearr_18137_18232[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (1))){
var state_18130__$1 = state_18130;
var statearr_18138_18233 = state_18130__$1;
(statearr_18138_18233[(2)] = null);

(statearr_18138_18233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (24))){
var inst_17986 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18139_18234 = state_18130__$1;
(statearr_18139_18234[(2)] = inst_17986);

(statearr_18139_18234[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (55))){
var inst_18110 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18140_18235 = state_18130__$1;
(statearr_18140_18235[(2)] = inst_18110);

(statearr_18140_18235[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (39))){
var inst_18064 = cljs.core.count(clause);
var inst_18065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_18064);
var state_18130__$1 = state_18130;
if(inst_18065){
var statearr_18141_18236 = state_18130__$1;
(statearr_18141_18236[(1)] = (42));

} else {
var statearr_18142_18237 = state_18130__$1;
(statearr_18142_18237[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (46))){
var state_18130__$1 = state_18130;
var statearr_18143_18238 = state_18130__$1;
(statearr_18143_18238[(2)] = null);

(statearr_18143_18238[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (4))){
var inst_17924 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18144_18239 = state_18130__$1;
(statearr_18144_18239[(2)] = inst_17924);

(statearr_18144_18239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (54))){
var state_18130__$1 = state_18130;
var statearr_18145_18240 = state_18130__$1;
(statearr_18145_18240[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (15))){
var inst_18024 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18147_18241 = state_18130__$1;
(statearr_18147_18241[(2)] = inst_18024);

(statearr_18147_18241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (48))){
var inst_18081 = (state_18130[(8)]);
var inst_18079 = (state_18130[(2)]);
var inst_18080 = fluree.db.util.async.throw_err(inst_18079);
var inst_18081__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18080,(0),null);
var inst_18082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18080,(1),null);
var inst_18083 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_18081__$1);
var state_18130__$1 = (function (){var statearr_18148 = state_18130;
(statearr_18148[(8)] = inst_18081__$1);

(statearr_18148[(9)] = inst_18082);

return statearr_18148;
})();
if(inst_18083){
var statearr_18149_18242 = state_18130__$1;
(statearr_18149_18242[(1)] = (49));

} else {
var statearr_18150_18243 = state_18130__$1;
(statearr_18150_18243[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (50))){
var inst_18082 = (state_18130[(9)]);
var inst_18090 = cljs.core.second(inst_18082);
var inst_18091 = clojure.string.starts_with_QMARK_(inst_18090,"fullText:");
var state_18130__$1 = state_18130;
if(inst_18091){
var statearr_18151_18244 = state_18130__$1;
(statearr_18151_18244[(1)] = (53));

} else {
var statearr_18152_18245 = state_18130__$1;
(statearr_18152_18245[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (21))){
var inst_17963 = (state_18130[(10)]);
var inst_17933 = (state_18130[(11)]);
var inst_17958 = (state_18130[(12)]);
var inst_17937 = (state_18130[(13)]);
var inst_17969 = (state_18130[(14)]);
var inst_17961 = (state_18130[(15)]);
var inst_17962 = (state_18130[(16)]);
var inst_17960 = (state_18130[(17)]);
var inst_17970 = (state_18130[(18)]);
var inst_17974 = (state_18130[(2)]);
var inst_17975 = fluree.db.util.async.throw_err(inst_17974);
var inst_17976 = (function (){var new_res = inst_17975;
var first__17967 = inst_17969;
var rest = inst_17970;
var vec__17955 = inst_17958;
var expr__17935 = inst_17933;
var seq__17956 = inst_17961;
var G__17954 = inst_17962;
var tuples = inst_17963;
var pred__17934 = inst_17937;
var seq__17966 = inst_17970;
var first__17957 = inst_17960;
var vec__17965 = inst_17962;
var segment_type = inst_17933;
var clause_group = inst_17969;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_17977 = cljs.core.keys(vars);
var inst_17978 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17976,inst_17975,inst_17977);
var inst_17979 = fluree.db.query.analytical.res_absorb_vars(inst_17978);
var state_18130__$1 = (function (){var statearr_18153 = state_18130;
(statearr_18153[(19)] = inst_17979);

return statearr_18153;
})();
if(cljs.core.truth_(inst_17963)){
var statearr_18154_18246 = state_18130__$1;
(statearr_18154_18246[(1)] = (22));

} else {
var statearr_18155_18247 = state_18130__$1;
(statearr_18155_18247[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (31))){
var inst_18034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18035 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_18036 = [inst_18035,r];
var inst_18037 = (new cljs.core.PersistentVector(null,2,(5),inst_18034,inst_18036,null));
var state_18130__$1 = state_18130;
var statearr_18156_18248 = state_18130__$1;
(statearr_18156_18248[(2)] = inst_18037);

(statearr_18156_18248[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (32))){
var inst_18039 = cljs.core.count(clause);
var inst_18040 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18039);
var inst_18041 = cljs.core.second(clause);
var inst_18042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18041,"rdf:type");
var inst_18043 = ((inst_18040) && (inst_18042));
var state_18130__$1 = state_18130;
if(cljs.core.truth_(inst_18043)){
var statearr_18157_18249 = state_18130__$1;
(statearr_18157_18249[(1)] = (34));

} else {
var statearr_18158_18250 = state_18130__$1;
(statearr_18158_18250[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (40))){
var inst_18119 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18159_18251 = state_18130__$1;
(statearr_18159_18251[(2)] = inst_18119);

(statearr_18159_18251[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (56))){
var inst_18081 = (state_18130[(8)]);
var inst_18082 = (state_18130[(9)]);
var inst_18099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18100 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_18081,res,inst_18082,fuel,max_fuel);
var state_18130__$1 = (function (){var statearr_18160 = state_18130;
(statearr_18160[(7)] = inst_18099);

return statearr_18160;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(59),inst_18100);
} else {
if((state_val_18131 === (33))){
var inst_18123 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18161_18252 = state_18130__$1;
(statearr_18161_18252[(2)] = inst_18123);

(statearr_18161_18252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (13))){
var inst_17958 = (state_18130[(12)]);
var inst_17958__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17959 = cljs.core.seq(inst_17958__$1);
var inst_17960 = cljs.core.first(inst_17959);
var inst_17961 = cljs.core.next(inst_17959);
var inst_17962 = inst_17958__$1;
var inst_17963 = null;
var state_18130__$1 = (function (){var statearr_18162 = state_18130;
(statearr_18162[(10)] = inst_17963);

(statearr_18162[(12)] = inst_17958__$1);

(statearr_18162[(15)] = inst_17961);

(statearr_18162[(16)] = inst_17962);

(statearr_18162[(17)] = inst_17960);

return statearr_18162;
})();
var statearr_18163_18253 = state_18130__$1;
(statearr_18163_18253[(2)] = null);

(statearr_18163_18253[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (22))){
var inst_17963 = (state_18130[(10)]);
var inst_17979 = (state_18130[(19)]);
var inst_17970 = (state_18130[(18)]);
var inst_17981 = fluree.db.query.analytical.outer_union(inst_17963,inst_17979);
var inst_17962 = inst_17970;
var inst_17963__$1 = inst_17981;
var state_18130__$1 = (function (){var statearr_18164 = state_18130;
(statearr_18164[(10)] = inst_17963__$1);

(statearr_18164[(16)] = inst_17962);

return statearr_18164;
})();
var statearr_18165_18254 = state_18130__$1;
(statearr_18165_18254[(2)] = null);

(statearr_18165_18254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (36))){
var inst_18121 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18166_18255 = state_18130__$1;
(statearr_18166_18255[(2)] = inst_18121);

(statearr_18166_18255[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (41))){
var inst_18056 = (state_18130[(20)]);
var inst_18059 = (state_18130[(2)]);
var inst_18060 = fluree.db.util.async.throw_err(inst_18059);
var inst_18061 = [inst_18060,r];
var inst_18062 = (new cljs.core.PersistentVector(null,2,(5),inst_18056,inst_18061,null));
var state_18130__$1 = state_18130;
var statearr_18167_18256 = state_18130__$1;
(statearr_18167_18256[(2)] = inst_18062);

(statearr_18167_18256[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (43))){
var state_18130__$1 = state_18130;
var statearr_18168_18257 = state_18130__$1;
(statearr_18168_18257[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (29))){
var inst_17933 = (state_18130[(11)]);
var inst_18016 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17933)].join('');
var inst_18017 = (new Error(inst_18016));
var inst_18018 = (function(){throw inst_18017})();
var state_18130__$1 = state_18130;
var statearr_18170_18258 = state_18130__$1;
(statearr_18170_18258[(2)] = inst_18018);

(statearr_18170_18258[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (44))){
var inst_18117 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18171_18259 = state_18130__$1;
(statearr_18171_18259[(2)] = inst_18117);

(statearr_18171_18259[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (6))){
var inst_17933 = (state_18130[(11)]);
var inst_17937 = (state_18130[(13)]);
var inst_17932 = cljs.core.keys(clause);
var inst_17933__$1 = cljs.core.first(inst_17932);
var inst_17937__$1 = cljs.core._EQ_;
var inst_17938 = (function (){var G__18172 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__18173 = inst_17933__$1;
return (inst_17937__$1.cljs$core$IFn$_invoke$arity$2 ? inst_17937__$1.cljs$core$IFn$_invoke$arity$2(G__18172,G__18173) : inst_17937__$1.call(null,G__18172,G__18173));
})();
var state_18130__$1 = (function (){var statearr_18174 = state_18130;
(statearr_18174[(11)] = inst_17933__$1);

(statearr_18174[(13)] = inst_17937__$1);

return statearr_18174;
})();
if(cljs.core.truth_(inst_17938)){
var statearr_18175_18260 = state_18130__$1;
(statearr_18175_18260[(1)] = (9));

} else {
var statearr_18176_18261 = state_18130__$1;
(statearr_18176_18261[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (28))){
var inst_18010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18011 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18012 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_18011,optional_QMARK_);
var inst_18013 = [inst_18012,r];
var inst_18014 = (new cljs.core.PersistentVector(null,2,(5),inst_18010,inst_18013,null));
var state_18130__$1 = state_18130;
var statearr_18177_18262 = state_18130__$1;
(statearr_18177_18262[(2)] = inst_18014);

(statearr_18177_18262[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (51))){
var inst_18112 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18178_18263 = state_18130__$1;
(statearr_18178_18263[(2)] = inst_18112);

(statearr_18178_18263[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (25))){
var inst_17933 = (state_18130[(11)]);
var inst_17937 = (state_18130[(13)]);
var inst_17998 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17999 = (function (){var segment_type = inst_17933;
var pred__17934 = inst_17937;
var expr__17935 = inst_17933;
var bindings = inst_17998;
return (function (p1__17917_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__17917_SHARP_);
});
})();
var inst_18000 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17999,inst_17998);
var inst_18001 = cljs.core.PersistentHashMap.EMPTY;
var inst_18002 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18001,inst_18000);
var inst_18003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18004 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18002);
var inst_18005 = [inst_18004,r];
var inst_18006 = (new cljs.core.PersistentVector(null,2,(5),inst_18003,inst_18005,null));
var state_18130__$1 = state_18130;
var statearr_18179_18264 = state_18130__$1;
(statearr_18179_18264[(2)] = inst_18006);

(statearr_18179_18264[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (34))){
var inst_18045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18046 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_18130__$1 = (function (){var statearr_18180 = state_18130;
(statearr_18180[(21)] = inst_18045);

return statearr_18180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(37),inst_18046);
} else {
if((state_val_18131 === (17))){
var inst_17994 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18181_18265 = state_18130__$1;
(statearr_18181_18265[(2)] = inst_17994);

(statearr_18181_18265[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (3))){
var inst_18128 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18130__$1,inst_18128);
} else {
if((state_val_18131 === (12))){
var inst_17940 = (state_18130[(22)]);
var inst_17944 = (state_18130[(2)]);
var inst_17945 = fluree.db.util.async.throw_err(inst_17944);
var inst_17946 = [inst_17945,r];
var inst_17947 = (new cljs.core.PersistentVector(null,2,(5),inst_17940,inst_17946,null));
var state_18130__$1 = state_18130;
var statearr_18182_18266 = state_18130__$1;
(statearr_18182_18266[(2)] = inst_17947);

(statearr_18182_18266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (2))){
var _ = (function (){var statearr_18183 = state_18130;
(statearr_18183[(4)] = cljs.core.cons((5),(state_18130[(4)])));

return statearr_18183;
})();
var inst_17930 = cljs.core.map_QMARK_(clause);
var state_18130__$1 = state_18130;
if(inst_17930){
var statearr_18184_18267 = state_18130__$1;
(statearr_18184_18267[(1)] = (6));

} else {
var statearr_18185_18268 = state_18130__$1;
(statearr_18185_18268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (23))){
var inst_17979 = (state_18130[(19)]);
var inst_17970 = (state_18130[(18)]);
var inst_17962 = inst_17970;
var inst_17963 = inst_17979;
var state_18130__$1 = (function (){var statearr_18186 = state_18130;
(statearr_18186[(10)] = inst_17963);

(statearr_18186[(16)] = inst_17962);

return statearr_18186;
})();
var statearr_18187_18269 = state_18130__$1;
(statearr_18187_18269[(2)] = null);

(statearr_18187_18269[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (47))){
var inst_18115 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18188_18270 = state_18130__$1;
(statearr_18188_18270[(2)] = inst_18115);

(statearr_18188_18270[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (35))){
var inst_18053 = cljs.core.count(clause);
var inst_18054 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18053);
var state_18130__$1 = state_18130;
if(inst_18054){
var statearr_18189_18271 = state_18130__$1;
(statearr_18189_18271[(1)] = (38));

} else {
var statearr_18190_18272 = state_18130__$1;
(statearr_18190_18272[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (19))){
var inst_17963 = (state_18130[(10)]);
var inst_17988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17989 = [inst_17963,r];
var inst_17990 = (new cljs.core.PersistentVector(null,2,(5),inst_17988,inst_17989,null));
var state_18130__$1 = state_18130;
var statearr_18191_18273 = state_18130__$1;
(statearr_18191_18273[(2)] = inst_17990);

(statearr_18191_18273[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (57))){
var state_18130__$1 = state_18130;
var statearr_18192_18274 = state_18130__$1;
(statearr_18192_18274[(2)] = null);

(statearr_18192_18274[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (11))){
var inst_18026 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18194_18275 = state_18130__$1;
(statearr_18194_18275[(2)] = inst_18026);

(statearr_18194_18275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (9))){
var inst_17940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17941 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17942 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_17941,res,fuel,max_fuel,opts);
var state_18130__$1 = (function (){var statearr_18195 = state_18130;
(statearr_18195[(22)] = inst_17940);

return statearr_18195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(12),inst_17942);
} else {
if((state_val_18131 === (5))){
var _ = (function (){var statearr_18196 = state_18130;
(statearr_18196[(4)] = cljs.core.rest((state_18130[(4)])));

return statearr_18196;
})();
var state_18130__$1 = state_18130;
var ex18193 = (state_18130__$1[(2)]);
var statearr_18197_18276 = state_18130__$1;
(statearr_18197_18276[(5)] = ex18193);


if((ex18193 instanceof Error)){
var statearr_18198_18277 = state_18130__$1;
(statearr_18198_18277[(1)] = (4));

(statearr_18198_18277[(5)] = null);

} else {
throw ex18193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (14))){
var inst_17933 = (state_18130[(11)]);
var inst_17937 = (state_18130[(13)]);
var inst_17996 = (function (){var G__18199 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__18200 = inst_17933;
return (inst_17937.cljs$core$IFn$_invoke$arity$2 ? inst_17937.cljs$core$IFn$_invoke$arity$2(G__18199,G__18200) : inst_17937.call(null,G__18199,G__18200));
})();
var state_18130__$1 = state_18130;
if(cljs.core.truth_(inst_17996)){
var statearr_18201_18278 = state_18130__$1;
(statearr_18201_18278[(1)] = (25));

} else {
var statearr_18202_18279 = state_18130__$1;
(statearr_18202_18279[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (45))){
var inst_18077 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_18130__$1 = state_18130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(48),inst_18077);
} else {
if((state_val_18131 === (53))){
var inst_18081 = (state_18130[(8)]);
var inst_18082 = (state_18130[(9)]);
var inst_18093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18094 = fluree.db.query.analytical.full_text__GT_tuples(inst_18081,res,inst_18082);
var inst_18095 = [inst_18094,r];
var inst_18096 = (new cljs.core.PersistentVector(null,2,(5),inst_18093,inst_18095,null));
var state_18130__$1 = state_18130;
var statearr_18203_18280 = state_18130__$1;
(statearr_18203_18280[(2)] = inst_18096);

(statearr_18203_18280[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (26))){
var inst_17933 = (state_18130[(11)]);
var inst_17937 = (state_18130[(13)]);
var inst_18008 = (function (){var G__18204 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__18205 = inst_17933;
return (inst_17937.cljs$core$IFn$_invoke$arity$2 ? inst_17937.cljs$core$IFn$_invoke$arity$2(G__18204,G__18205) : inst_17937.call(null,G__18204,G__18205));
})();
var state_18130__$1 = state_18130;
if(cljs.core.truth_(inst_18008)){
var statearr_18206_18281 = state_18130__$1;
(statearr_18206_18281[(1)] = (28));

} else {
var statearr_18207_18282 = state_18130__$1;
(statearr_18207_18282[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (16))){
var inst_17969 = (state_18130[(14)]);
var inst_17962 = (state_18130[(16)]);
var inst_17968 = cljs.core.seq(inst_17962);
var inst_17969__$1 = cljs.core.first(inst_17968);
var inst_17970 = cljs.core.next(inst_17968);
var state_18130__$1 = (function (){var statearr_18208 = state_18130;
(statearr_18208[(14)] = inst_17969__$1);

(statearr_18208[(18)] = inst_17970);

return statearr_18208;
})();
if(cljs.core.truth_(inst_17969__$1)){
var statearr_18209_18283 = state_18130__$1;
(statearr_18209_18283[(1)] = (18));

} else {
var statearr_18210_18284 = state_18130__$1;
(statearr_18210_18284[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (38))){
var inst_18056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18057 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_18130__$1 = (function (){var statearr_18211 = state_18130;
(statearr_18211[(20)] = inst_18056);

return statearr_18211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(41),inst_18057);
} else {
if((state_val_18131 === (30))){
var inst_18020 = (state_18130[(2)]);
var state_18130__$1 = state_18130;
var statearr_18212_18285 = state_18130__$1;
(statearr_18212_18285[(2)] = inst_18020);

(statearr_18212_18285[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (10))){
var inst_17933 = (state_18130[(11)]);
var inst_17937 = (state_18130[(13)]);
var inst_17949 = (function (){var G__18213 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__18214 = inst_17933;
return (inst_17937.cljs$core$IFn$_invoke$arity$2 ? inst_17937.cljs$core$IFn$_invoke$arity$2(G__18213,G__18214) : inst_17937.call(null,G__18213,G__18214));
})();
var state_18130__$1 = state_18130;
if(cljs.core.truth_(inst_17949)){
var statearr_18215_18286 = state_18130__$1;
(statearr_18215_18286[(1)] = (13));

} else {
var statearr_18216_18287 = state_18130__$1;
(statearr_18216_18287[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (18))){
var inst_17969 = (state_18130[(14)]);
var inst_17972 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_17969,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_17969,q_map,vars,fuel,max_fuel,opts));
var state_18130__$1 = state_18130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(21),inst_17972);
} else {
if((state_val_18131 === (52))){
var inst_18087 = (state_18130[(2)]);
var inst_18088 = fluree.db.util.async.throw_err(inst_18087);
var state_18130__$1 = state_18130;
var statearr_18217_18288 = state_18130__$1;
(statearr_18217_18288[(2)] = inst_18088);

(statearr_18217_18288[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (42))){
var inst_18067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18068 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_18069 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18068);
var inst_18070 = [inst_18069,r];
var inst_18071 = (new cljs.core.PersistentVector(null,2,(5),inst_18067,inst_18070,null));
var state_18130__$1 = state_18130;
var statearr_18218_18289 = state_18130__$1;
(statearr_18218_18289[(2)] = inst_18071);

(statearr_18218_18289[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (37))){
var inst_18045 = (state_18130[(21)]);
var inst_18048 = (state_18130[(2)]);
var inst_18049 = fluree.db.util.async.throw_err(inst_18048);
var inst_18050 = [inst_18049,r];
var inst_18051 = (new cljs.core.PersistentVector(null,2,(5),inst_18045,inst_18050,null));
var state_18130__$1 = state_18130;
var statearr_18219_18290 = state_18130__$1;
(statearr_18219_18290[(2)] = inst_18051);

(statearr_18219_18290[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (8))){
var inst_18125 = (state_18130[(2)]);
var _ = (function (){var statearr_18220 = state_18130;
(statearr_18220[(4)] = cljs.core.rest((state_18130[(4)])));

return statearr_18220;
})();
var state_18130__$1 = state_18130;
var statearr_18221_18291 = state_18130__$1;
(statearr_18221_18291[(2)] = inst_18125);

(statearr_18221_18291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18131 === (49))){
var inst_18082 = (state_18130[(9)]);
var inst_18085 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_18082,r,res,optional_QMARK_,fuel,max_fuel);
var state_18130__$1 = state_18130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18130__$1,(52),inst_18085);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_18222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18222[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__);

(statearr_18222[(1)] = (1));

return statearr_18222;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1 = (function (state_18130){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18130);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18223){var ex__2882__auto__ = e18223;
var statearr_18224_18292 = state_18130;
(statearr_18224_18292[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18130[(4)]))){
var statearr_18225_18293 = state_18130;
(statearr_18225_18293[(1)] = cljs.core.first((state_18130[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18294 = state_18130;
state_18130 = G__18294;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__ = function(state_18130){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1.call(this,state_18130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18226 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18226[(6)] = c__2901__auto__);

return statearr_18226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__18296 = arguments.length;
switch (G__18296) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18376){
var state_val_18377 = (state_18376[(1)]);
if((state_val_18377 === (7))){
var inst_18371 = (state_18376[(2)]);
var _ = (function (){var statearr_18378 = state_18376;
(statearr_18378[(4)] = cljs.core.rest((state_18376[(4)])));

return statearr_18378;
})();
var state_18376__$1 = state_18376;
var statearr_18379_18427 = state_18376__$1;
(statearr_18379_18427[(2)] = inst_18371);

(statearr_18379_18427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (20))){
var inst_18336 = (state_18376[(7)]);
var inst_18348 = (state_18376[(2)]);
var inst_18318 = inst_18336;
var inst_18319 = inst_18348;
var state_18376__$1 = (function (){var statearr_18380 = state_18376;
(statearr_18380[(8)] = inst_18318);

(statearr_18380[(9)] = inst_18319);

return statearr_18380;
})();
var statearr_18381_18428 = state_18376__$1;
(statearr_18381_18428[(2)] = null);

(statearr_18381_18428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (1))){
var state_18376__$1 = state_18376;
var statearr_18382_18429 = state_18376__$1;
(statearr_18382_18429[(2)] = null);

(statearr_18382_18429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (24))){
var inst_18335 = (state_18376[(10)]);
var inst_18336 = (state_18376[(7)]);
var inst_18319 = (state_18376[(9)]);
var inst_18356 = fluree.db.query.analytical.inner_join(inst_18319,inst_18335);
var inst_18318 = inst_18336;
var inst_18319__$1 = inst_18356;
var state_18376__$1 = (function (){var statearr_18383 = state_18376;
(statearr_18383[(8)] = inst_18318);

(statearr_18383[(9)] = inst_18319__$1);

return statearr_18383;
})();
var statearr_18384_18430 = state_18376__$1;
(statearr_18384_18430[(2)] = null);

(statearr_18384_18430[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (4))){
var inst_18297 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18386_18431 = state_18376__$1;
(statearr_18386_18431[(2)] = inst_18297);

(statearr_18386_18431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (15))){
var inst_18335 = (state_18376[(10)]);
var state_18376__$1 = state_18376;
if(cljs.core.truth_(inst_18335)){
var statearr_18387_18432 = state_18376__$1;
(statearr_18387_18432[(1)] = (18));

} else {
var statearr_18388_18433 = state_18376__$1;
(statearr_18388_18433[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (21))){
var inst_18336 = (state_18376[(7)]);
var inst_18319 = (state_18376[(9)]);
var tmp18385 = inst_18319;
var inst_18318 = inst_18336;
var inst_18319__$1 = tmp18385;
var state_18376__$1 = (function (){var statearr_18389 = state_18376;
(statearr_18389[(8)] = inst_18318);

(statearr_18389[(9)] = inst_18319__$1);

return statearr_18389;
})();
var statearr_18390_18434 = state_18376__$1;
(statearr_18390_18434[(2)] = null);

(statearr_18390_18434[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (13))){
var inst_18319 = (state_18376[(9)]);
var inst_18342 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_18319,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18343 = cljs.core.empty_QMARK_(inst_18342);
var state_18376__$1 = state_18376;
if(inst_18343){
var statearr_18391_18435 = state_18376__$1;
(statearr_18391_18435[(1)] = (15));

} else {
var statearr_18392_18436 = state_18376__$1;
(statearr_18392_18436[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (22))){
var state_18376__$1 = state_18376;
var statearr_18393_18437 = state_18376__$1;
(statearr_18393_18437[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (6))){
var inst_18325 = (state_18376[(11)]);
var inst_18318 = (state_18376[(8)]);
var inst_18324 = cljs.core.seq(inst_18318);
var inst_18325__$1 = cljs.core.first(inst_18324);
var inst_18326 = cljs.core.next(inst_18324);
var state_18376__$1 = (function (){var statearr_18395 = state_18376;
(statearr_18395[(11)] = inst_18325__$1);

(statearr_18395[(12)] = inst_18326);

return statearr_18395;
})();
if(cljs.core.truth_(inst_18325__$1)){
var statearr_18396_18438 = state_18376__$1;
(statearr_18396_18438[(1)] = (8));

} else {
var statearr_18397_18439 = state_18376__$1;
(statearr_18397_18439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (25))){
var state_18376__$1 = state_18376;
var statearr_18398_18440 = state_18376__$1;
(statearr_18398_18440[(2)] = null);

(statearr_18398_18440[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (17))){
var inst_18364 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18399_18441 = state_18376__$1;
(statearr_18399_18441[(2)] = inst_18364);

(statearr_18399_18441[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (3))){
var inst_18374 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18376__$1,inst_18374);
} else {
if((state_val_18377 === (12))){
var inst_18335 = (state_18376[(10)]);
var inst_18336 = (state_18376[(7)]);
var inst_18318 = inst_18336;
var inst_18319 = inst_18335;
var state_18376__$1 = (function (){var statearr_18400 = state_18376;
(statearr_18400[(8)] = inst_18318);

(statearr_18400[(9)] = inst_18319);

return statearr_18400;
})();
var statearr_18401_18442 = state_18376__$1;
(statearr_18401_18442[(2)] = null);

(statearr_18401_18442[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (2))){
var _ = (function (){var statearr_18402 = state_18376;
(statearr_18402[(4)] = cljs.core.cons((5),(state_18376[(4)])));

return statearr_18402;
})();
var inst_18310 = where;
var inst_18311 = cljs.core.seq(inst_18310);
var inst_18312 = cljs.core.first(inst_18311);
var inst_18313 = cljs.core.next(inst_18311);
var inst_18314 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18315 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_18316 = [inst_18315];
var inst_18317 = cljs.core.PersistentHashMap.fromArrays(inst_18314,inst_18316);
var inst_18318 = inst_18310;
var inst_18319 = inst_18317;
var state_18376__$1 = (function (){var statearr_18403 = state_18376;
(statearr_18403[(8)] = inst_18318);

(statearr_18403[(13)] = inst_18312);

(statearr_18403[(14)] = inst_18313);

(statearr_18403[(9)] = inst_18319);

return statearr_18403;
})();
var statearr_18404_18443 = state_18376__$1;
(statearr_18404_18443[(2)] = null);

(statearr_18404_18443[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (23))){
var inst_18362 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18405_18444 = state_18376__$1;
(statearr_18405_18444[(2)] = inst_18362);

(statearr_18405_18444[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (19))){
var inst_18319 = (state_18376[(9)]);
var state_18376__$1 = state_18376;
var statearr_18406_18445 = state_18376__$1;
(statearr_18406_18445[(2)] = inst_18319);

(statearr_18406_18445[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (11))){
var inst_18325 = (state_18376[(11)]);
var inst_18333 = (state_18376[(2)]);
var inst_18334 = fluree.db.util.async.throw_err(inst_18333);
var inst_18335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18334,(0),null);
var inst_18336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18334,(1),null);
var inst_18337 = cljs.core.count(inst_18325);
var inst_18338 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_18337);
var state_18376__$1 = (function (){var statearr_18408 = state_18376;
(statearr_18408[(10)] = inst_18335);

(statearr_18408[(7)] = inst_18336);

return statearr_18408;
})();
if(inst_18338){
var statearr_18409_18446 = state_18376__$1;
(statearr_18409_18446[(1)] = (12));

} else {
var statearr_18410_18447 = state_18376__$1;
(statearr_18410_18447[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (9))){
var inst_18319 = (state_18376[(9)]);
var state_18376__$1 = state_18376;
var statearr_18411_18448 = state_18376__$1;
(statearr_18411_18448[(2)] = inst_18319);

(statearr_18411_18448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (5))){
var _ = (function (){var statearr_18412 = state_18376;
(statearr_18412[(4)] = cljs.core.rest((state_18376[(4)])));

return statearr_18412;
})();
var state_18376__$1 = state_18376;
var ex18407 = (state_18376__$1[(2)]);
var statearr_18413_18449 = state_18376__$1;
(statearr_18413_18449[(5)] = ex18407);


if((ex18407 instanceof Error)){
var statearr_18414_18450 = state_18376__$1;
(statearr_18414_18450[(1)] = (4));

(statearr_18414_18450[(5)] = null);

} else {
throw ex18407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (14))){
var inst_18366 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18415_18451 = state_18376__$1;
(statearr_18415_18451[(2)] = inst_18366);

(statearr_18415_18451[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (26))){
var inst_18360 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18416_18452 = state_18376__$1;
(statearr_18416_18452[(2)] = inst_18360);

(statearr_18416_18452[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (16))){
var inst_18335 = (state_18376[(10)]);
var inst_18351 = (inst_18335 == null);
var state_18376__$1 = state_18376;
if(cljs.core.truth_(inst_18351)){
var statearr_18417_18453 = state_18376__$1;
(statearr_18417_18453[(1)] = (21));

} else {
var statearr_18418_18454 = state_18376__$1;
(statearr_18418_18454[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (10))){
var inst_18369 = (state_18376[(2)]);
var state_18376__$1 = state_18376;
var statearr_18419_18455 = state_18376__$1;
(statearr_18419_18455[(2)] = inst_18369);

(statearr_18419_18455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (18))){
var inst_18335 = (state_18376[(10)]);
var state_18376__$1 = state_18376;
var statearr_18420_18456 = state_18376__$1;
(statearr_18420_18456[(2)] = inst_18335);

(statearr_18420_18456[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18377 === (8))){
var inst_18325 = (state_18376[(11)]);
var inst_18326 = (state_18376[(12)]);
var inst_18319 = (state_18376[(9)]);
var inst_18331 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_18319,inst_18325,inst_18326,false,fuel,max_fuel,opts);
var state_18376__$1 = state_18376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18376__$1,(11),inst_18331);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2879__auto__ = null;
var fluree$db$query$analytical$state_machine__2879__auto____0 = (function (){
var statearr_18421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18421[(0)] = fluree$db$query$analytical$state_machine__2879__auto__);

(statearr_18421[(1)] = (1));

return statearr_18421;
});
var fluree$db$query$analytical$state_machine__2879__auto____1 = (function (state_18376){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18376);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18422){var ex__2882__auto__ = e18422;
var statearr_18423_18457 = state_18376;
(statearr_18423_18457[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18376[(4)]))){
var statearr_18424_18458 = state_18376;
(statearr_18424_18458[(1)] = cljs.core.first((state_18376[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18459 = state_18376;
state_18376 = G__18459;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2879__auto__ = function(state_18376){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2879__auto____1.call(this,state_18376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2879__auto____0;
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2879__auto____1;
return fluree$db$query$analytical$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18425 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18425[(6)] = c__2901__auto__);

return statearr_18425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18514){
var state_val_18515 = (state_18514[(1)]);
if((state_val_18515 === (7))){
var state_18514__$1 = state_18514;
var statearr_18516_18554 = state_18514__$1;
(statearr_18516_18554[(2)] = false);

(statearr_18516_18554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (20))){
var inst_18492 = (state_18514[(7)]);
var inst_18504 = (state_18514[(8)]);
var inst_18506 = fluree.db.query.analytical.tuples__GT_filtered(inst_18504,inst_18492,null);
var state_18514__$1 = state_18514;
var statearr_18517_18555 = state_18514__$1;
(statearr_18517_18555[(2)] = inst_18506);

(statearr_18517_18555[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (1))){
var state_18514__$1 = state_18514;
var statearr_18518_18556 = state_18514__$1;
(statearr_18518_18556[(2)] = null);

(statearr_18518_18556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (4))){
var inst_18460 = (state_18514[(2)]);
var state_18514__$1 = state_18514;
var statearr_18519_18557 = state_18514__$1;
(statearr_18519_18557[(2)] = inst_18460);

(statearr_18519_18557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (15))){
var inst_18491 = (state_18514[(9)]);
var inst_18495 = (state_18514[(2)]);
var inst_18496 = fluree.db.util.async.throw_err(inst_18495);
var state_18514__$1 = (function (){var statearr_18520 = state_18514;
(statearr_18520[(10)] = inst_18496);

return statearr_18520;
})();
if(cljs.core.truth_(inst_18491)){
var statearr_18521_18558 = state_18514__$1;
(statearr_18521_18558[(1)] = (16));

} else {
var statearr_18522_18559 = state_18514__$1;
(statearr_18522_18559[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (21))){
var inst_18504 = (state_18514[(8)]);
var state_18514__$1 = state_18514;
var statearr_18523_18560 = state_18514__$1;
(statearr_18523_18560[(2)] = inst_18504);

(statearr_18523_18560[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (13))){
var inst_18467 = (state_18514[(11)]);
var state_18514__$1 = state_18514;
var statearr_18524_18561 = state_18514__$1;
(statearr_18524_18561[(2)] = inst_18467);

(statearr_18524_18561[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (22))){
var inst_18509 = (state_18514[(2)]);
var _ = (function (){var statearr_18525 = state_18514;
(statearr_18525[(4)] = cljs.core.rest((state_18514[(4)])));

return statearr_18525;
})();
var state_18514__$1 = state_18514;
var statearr_18526_18562 = state_18514__$1;
(statearr_18526_18562[(2)] = inst_18509);

(statearr_18526_18562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (6))){
var inst_18467 = (state_18514[(11)]);
var inst_18472 = inst_18467.cljs$lang$protocol_mask$partition0$;
var inst_18473 = (inst_18472 & (64));
var inst_18474 = inst_18467.cljs$core$ISeq$;
var inst_18475 = (cljs.core.PROTOCOL_SENTINEL === inst_18474);
var inst_18476 = ((inst_18473) || (inst_18475));
var state_18514__$1 = state_18514;
if(cljs.core.truth_(inst_18476)){
var statearr_18527_18563 = state_18514__$1;
(statearr_18527_18563[(1)] = (9));

} else {
var statearr_18528_18564 = state_18514__$1;
(statearr_18528_18564[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (17))){
var inst_18496 = (state_18514[(10)]);
var state_18514__$1 = state_18514;
var statearr_18529_18565 = state_18514__$1;
(statearr_18529_18565[(2)] = inst_18496);

(statearr_18529_18565[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (3))){
var inst_18512 = (state_18514[(2)]);
var state_18514__$1 = state_18514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18514__$1,inst_18512);
} else {
if((state_val_18515 === (12))){
var inst_18467 = (state_18514[(11)]);
var inst_18485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18467);
var state_18514__$1 = state_18514;
var statearr_18530_18566 = state_18514__$1;
(statearr_18530_18566[(2)] = inst_18485);

(statearr_18530_18566[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (2))){
var inst_18467 = (state_18514[(11)]);
var _ = (function (){var statearr_18531 = state_18514;
(statearr_18531[(4)] = cljs.core.cons((5),(state_18514[(4)])));

return statearr_18531;
})();
var inst_18467__$1 = q_map;
var inst_18469 = (inst_18467__$1 == null);
var inst_18470 = cljs.core.not(inst_18469);
var state_18514__$1 = (function (){var statearr_18532 = state_18514;
(statearr_18532[(11)] = inst_18467__$1);

return statearr_18532;
})();
if(inst_18470){
var statearr_18533_18567 = state_18514__$1;
(statearr_18533_18567[(1)] = (6));

} else {
var statearr_18534_18568 = state_18514__$1;
(statearr_18534_18568[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (19))){
var inst_18500 = (state_18514[(2)]);
var inst_18501 = fluree.db.util.async.throw_err(inst_18500);
var state_18514__$1 = state_18514;
var statearr_18535_18569 = state_18514__$1;
(statearr_18535_18569[(2)] = inst_18501);

(statearr_18535_18569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (11))){
var inst_18480 = (state_18514[(2)]);
var state_18514__$1 = state_18514;
var statearr_18537_18570 = state_18514__$1;
(statearr_18537_18570[(2)] = inst_18480);

(statearr_18537_18570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (9))){
var state_18514__$1 = state_18514;
var statearr_18538_18571 = state_18514__$1;
(statearr_18538_18571[(2)] = true);

(statearr_18538_18571[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (5))){
var _ = (function (){var statearr_18539 = state_18514;
(statearr_18539[(4)] = cljs.core.rest((state_18514[(4)])));

return statearr_18539;
})();
var state_18514__$1 = state_18514;
var ex18536 = (state_18514__$1[(2)]);
var statearr_18540_18572 = state_18514__$1;
(statearr_18540_18572[(5)] = ex18536);


if((ex18536 instanceof Error)){
var statearr_18541_18573 = state_18514__$1;
(statearr_18541_18573[(1)] = (4));

(statearr_18541_18573[(5)] = null);

} else {
throw ex18536;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (14))){
var inst_18488 = (state_18514[(2)]);
var inst_18489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18488,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18488,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_18491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18488,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_18492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18488,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_18493 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_18490,q_map,inst_18489,fuel,max_fuel,opts);
var state_18514__$1 = (function (){var statearr_18542 = state_18514;
(statearr_18542[(9)] = inst_18491);

(statearr_18542[(7)] = inst_18492);

return statearr_18542;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18514__$1,(15),inst_18493);
} else {
if((state_val_18515 === (16))){
var inst_18491 = (state_18514[(9)]);
var inst_18496 = (state_18514[(10)]);
var inst_18498 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_18491,inst_18496,fuel,max_fuel,opts);
var state_18514__$1 = state_18514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18514__$1,(19),inst_18498);
} else {
if((state_val_18515 === (10))){
var state_18514__$1 = state_18514;
var statearr_18543_18574 = state_18514__$1;
(statearr_18543_18574[(2)] = false);

(statearr_18543_18574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (18))){
var inst_18492 = (state_18514[(7)]);
var inst_18504 = (state_18514[(2)]);
var state_18514__$1 = (function (){var statearr_18544 = state_18514;
(statearr_18544[(8)] = inst_18504);

return statearr_18544;
})();
if(cljs.core.truth_(inst_18492)){
var statearr_18545_18575 = state_18514__$1;
(statearr_18545_18575[(1)] = (20));

} else {
var statearr_18546_18576 = state_18514__$1;
(statearr_18546_18576[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18515 === (8))){
var inst_18483 = (state_18514[(2)]);
var state_18514__$1 = state_18514;
if(cljs.core.truth_(inst_18483)){
var statearr_18547_18577 = state_18514__$1;
(statearr_18547_18577[(1)] = (12));

} else {
var statearr_18548_18578 = state_18514__$1;
(statearr_18548_18578[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2879__auto____0 = (function (){
var statearr_18549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18549[(0)] = fluree$db$query$analytical$q_$_state_machine__2879__auto__);

(statearr_18549[(1)] = (1));

return statearr_18549;
});
var fluree$db$query$analytical$q_$_state_machine__2879__auto____1 = (function (state_18514){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18514);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18550){var ex__2882__auto__ = e18550;
var statearr_18551_18579 = state_18514;
(statearr_18551_18579[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18514[(4)]))){
var statearr_18552_18580 = state_18514;
(statearr_18552_18580[(1)] = cljs.core.first((state_18514[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18581 = state_18514;
state_18514 = G__18581;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2879__auto__ = function(state_18514){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2879__auto____1.call(this,state_18514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2879__auto____0;
fluree$db$query$analytical$q_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18553 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18553[(6)] = c__2901__auto__);

return statearr_18553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
