// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60361 = arguments.length;
switch (G__60361) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___60542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_60468){
var state_val_60469 = (state_60468[(1)]);
if((state_val_60469 === (7))){
var inst_60375 = (state_60468[(7)]);
var inst_60380 = inst_60375.cljs$lang$protocol_mask$partition0$;
var inst_60381 = (inst_60380 & (64));
var inst_60382 = inst_60375.cljs$core$ISeq$;
var inst_60383 = (cljs.core.PROTOCOL_SENTINEL === inst_60382);
var inst_60384 = ((inst_60381) || (inst_60383));
var state_60468__$1 = state_60468;
if(cljs.core.truth_(inst_60384)){
var statearr_60470_60543 = state_60468__$1;
(statearr_60470_60543[(1)] = (10));

} else {
var statearr_60471_60544 = state_60468__$1;
(statearr_60471_60544[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (20))){
var state_60468__$1 = state_60468;
var statearr_60472_60545 = state_60468__$1;
(statearr_60472_60545[(2)] = null);

(statearr_60472_60545[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (27))){
var inst_60423 = (state_60468[(8)]);
var state_60468__$1 = state_60468;
if(cljs.core.truth_(inst_60423)){
var statearr_60473_60546 = state_60468__$1;
(statearr_60473_60546[(1)] = (29));

} else {
var statearr_60474_60547 = state_60468__$1;
(statearr_60474_60547[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (1))){
var state_60468__$1 = state_60468;
var statearr_60475_60548 = state_60468__$1;
(statearr_60475_60548[(2)] = null);

(statearr_60475_60548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (24))){
var inst_60399 = (state_60468[(9)]);
var inst_60413 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60399)," unknown."].join('');
var inst_60414 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60415 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60416 = cljs.core.PersistentHashMap.fromArrays(inst_60414,inst_60415);
var inst_60417 = cljs.core.ex_info.call(null,inst_60413,inst_60416);
var inst_60418 = (function(){throw inst_60417})();
var state_60468__$1 = state_60468;
var statearr_60476_60549 = state_60468__$1;
(statearr_60476_60549[(2)] = inst_60418);

(statearr_60476_60549[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (39))){
var inst_60445 = (state_60468[(2)]);
var inst_60446 = fluree.db.util.async.throw_err.call(null,inst_60445);
var state_60468__$1 = state_60468;
var statearr_60477_60550 = state_60468__$1;
(statearr_60477_60550[(2)] = inst_60446);

(statearr_60477_60550[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (46))){
var inst_60454 = (state_60468[(10)]);
var inst_60457 = (state_60468[(2)]);
var inst_60458 = fluree.db.util.async.throw_err.call(null,inst_60457);
var inst_60459 = cljs.core.assoc.call(null,inst_60454,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60458);
var state_60468__$1 = state_60468;
var statearr_60478_60551 = state_60468__$1;
(statearr_60478_60551[(2)] = inst_60459);

(statearr_60478_60551[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (4))){
var inst_60362 = (state_60468[(2)]);
var inst_60363 = cljs.core.async.put_BANG_.call(null,pc,inst_60362);
var inst_60364 = cljs.core.async.close_BANG_.call(null,pc);
var state_60468__$1 = (function (){var statearr_60479 = state_60468;
(statearr_60479[(11)] = inst_60363);

return statearr_60479;
})();
var statearr_60480_60552 = state_60468__$1;
(statearr_60480_60552[(2)] = inst_60364);

(statearr_60480_60552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (15))){
var inst_60399 = (state_60468[(9)]);
var inst_60396 = (state_60468[(2)]);
var inst_60397 = cljs.core.get.call(null,inst_60396,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60398 = cljs.core.get.call(null,inst_60396,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60399__$1 = cljs.core.get.call(null,inst_60396,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60400 = cljs.core.get.call(null,inst_60396,new cljs.core.Keyword(null,"block","block",664686210));
var state_60468__$1 = (function (){var statearr_60481 = state_60468;
(statearr_60481[(12)] = inst_60398);

(statearr_60481[(13)] = inst_60397);

(statearr_60481[(9)] = inst_60399__$1);

(statearr_60481[(14)] = inst_60400);

return statearr_60481;
})();
if(cljs.core.truth_(inst_60399__$1)){
var statearr_60482_60553 = state_60468__$1;
(statearr_60482_60553[(1)] = (16));

} else {
var statearr_60483_60554 = state_60468__$1;
(statearr_60483_60554[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (21))){
var inst_60397 = (state_60468[(13)]);
var inst_60423 = (state_60468[(2)]);
var state_60468__$1 = (function (){var statearr_60484 = state_60468;
(statearr_60484[(8)] = inst_60423);

return statearr_60484;
})();
if(cljs.core.truth_(inst_60397)){
var statearr_60485_60555 = state_60468__$1;
(statearr_60485_60555[(1)] = (26));

} else {
var statearr_60486_60556 = state_60468__$1;
(statearr_60486_60556[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (31))){
var inst_60433 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
var statearr_60487_60557 = state_60468__$1;
(statearr_60487_60557[(2)] = inst_60433);

(statearr_60487_60557[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (32))){
var inst_60429 = (state_60468[(2)]);
var inst_60430 = fluree.db.util.async.throw_err.call(null,inst_60429);
var state_60468__$1 = state_60468;
var statearr_60488_60558 = state_60468__$1;
(statearr_60488_60558[(2)] = inst_60430);

(statearr_60488_60558[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (40))){
var inst_60449 = (state_60468[(15)]);
var inst_60399 = (state_60468[(9)]);
var inst_60451 = cljs.core.assoc.call(null,inst_60449,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60399);
var state_60468__$1 = state_60468;
var statearr_60489_60559 = state_60468__$1;
(statearr_60489_60559[(2)] = inst_60451);

(statearr_60489_60559[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (33))){
var inst_60374 = (state_60468[(16)]);
var inst_60435 = (state_60468[(17)]);
var inst_60437 = fluree.db.permissions.permission_map.call(null,inst_60374,inst_60435,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60468__$1 = state_60468;
var statearr_60490_60560 = state_60468__$1;
(statearr_60490_60560[(2)] = inst_60437);

(statearr_60490_60560[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (13))){
var inst_60375 = (state_60468[(7)]);
var inst_60393 = cljs.core.apply.call(null,cljs.core.hash_map,inst_60375);
var state_60468__$1 = state_60468;
var statearr_60491_60561 = state_60468__$1;
(statearr_60491_60561[(2)] = inst_60393);

(statearr_60491_60561[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (22))){
var inst_60410 = (state_60468[(18)]);
var inst_60409 = (state_60468[(2)]);
var inst_60410__$1 = fluree.db.util.async.throw_err.call(null,inst_60409);
var state_60468__$1 = (function (){var statearr_60492 = state_60468;
(statearr_60492[(18)] = inst_60410__$1);

return statearr_60492;
})();
if(cljs.core.truth_(inst_60410__$1)){
var statearr_60493_60562 = state_60468__$1;
(statearr_60493_60562[(1)] = (23));

} else {
var statearr_60494_60563 = state_60468__$1;
(statearr_60494_60563[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (36))){
var inst_60374 = (state_60468[(16)]);
var inst_60442 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60443 = fluree.db.time_travel.as_of_block.call(null,inst_60374,inst_60442);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60468__$1,(39),inst_60443);
} else {
if((state_val_60469 === (41))){
var inst_60449 = (state_60468[(15)]);
var state_60468__$1 = state_60468;
var statearr_60495_60564 = state_60468__$1;
(statearr_60495_60564[(2)] = inst_60449);

(statearr_60495_60564[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (43))){
var inst_60440 = (state_60468[(19)]);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60468__$1,(46),inst_60440);
} else {
if((state_val_60469 === (29))){
var inst_60423 = (state_60468[(8)]);
var inst_60374 = (state_60468[(16)]);
var inst_60427 = fluree.db.auth.roles.call(null,inst_60374,inst_60423);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60468__$1,(32),inst_60427);
} else {
if((state_val_60469 === (44))){
var inst_60454 = (state_60468[(10)]);
var state_60468__$1 = state_60468;
var statearr_60496_60565 = state_60468__$1;
(statearr_60496_60565[(2)] = inst_60454);

(statearr_60496_60565[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (6))){
var inst_60375 = (state_60468[(7)]);
var inst_60373 = (state_60468[(2)]);
var inst_60374 = fluree.db.util.async.throw_err.call(null,inst_60373);
var inst_60375__$1 = opts;
var inst_60377 = (inst_60375__$1 == null);
var inst_60378 = cljs.core.not.call(null,inst_60377);
var state_60468__$1 = (function (){var statearr_60497 = state_60468;
(statearr_60497[(7)] = inst_60375__$1);

(statearr_60497[(16)] = inst_60374);

return statearr_60497;
})();
if(inst_60378){
var statearr_60498_60566 = state_60468__$1;
(statearr_60498_60566[(1)] = (7));

} else {
var statearr_60499_60567 = state_60468__$1;
(statearr_60499_60567[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (28))){
var inst_60435 = (state_60468[(17)]);
var inst_60435__$1 = (state_60468[(2)]);
var state_60468__$1 = (function (){var statearr_60500 = state_60468;
(statearr_60500[(17)] = inst_60435__$1);

return statearr_60500;
})();
if(cljs.core.truth_(inst_60435__$1)){
var statearr_60501_60568 = state_60468__$1;
(statearr_60501_60568[(1)] = (33));

} else {
var statearr_60502_60569 = state_60468__$1;
(statearr_60502_60569[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (25))){
var inst_60420 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
var statearr_60503_60570 = state_60468__$1;
(statearr_60503_60570[(2)] = inst_60420);

(statearr_60503_60570[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (34))){
var state_60468__$1 = state_60468;
var statearr_60504_60571 = state_60468__$1;
(statearr_60504_60571[(2)] = null);

(statearr_60504_60571[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (17))){
var inst_60399 = (state_60468[(9)]);
var state_60468__$1 = state_60468;
var statearr_60505_60572 = state_60468__$1;
(statearr_60505_60572[(2)] = inst_60399);

(statearr_60505_60572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (3))){
var inst_60466 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60468__$1,inst_60466);
} else {
if((state_val_60469 === (12))){
var inst_60388 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
var statearr_60506_60573 = state_60468__$1;
(statearr_60506_60573[(2)] = inst_60388);

(statearr_60506_60573[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (2))){
var _ = (function (){var statearr_60507 = state_60468;
(statearr_60507[(4)] = cljs.core.cons.call(null,(5),(state_60468[(4)])));

return statearr_60507;
})();
var inst_60371 = fluree.db.session.db.call(null,conn,ledger,null);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60468__$1,(6),inst_60371);
} else {
if((state_val_60469 === (23))){
var inst_60410 = (state_60468[(18)]);
var state_60468__$1 = state_60468;
var statearr_60508_60574 = state_60468__$1;
(statearr_60508_60574[(2)] = inst_60410);

(statearr_60508_60574[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (35))){
var inst_60400 = (state_60468[(14)]);
var inst_60440 = (state_60468[(2)]);
var state_60468__$1 = (function (){var statearr_60509 = state_60468;
(statearr_60509[(19)] = inst_60440);

return statearr_60509;
})();
if(cljs.core.truth_(inst_60400)){
var statearr_60510_60575 = state_60468__$1;
(statearr_60510_60575[(1)] = (36));

} else {
var statearr_60511_60576 = state_60468__$1;
(statearr_60511_60576[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (19))){
var inst_60374 = (state_60468[(16)]);
var inst_60399 = (state_60468[(9)]);
var inst_60407 = fluree.db.dbproto._subid.call(null,inst_60374,inst_60399);
var state_60468__$1 = state_60468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60468__$1,(22),inst_60407);
} else {
if((state_val_60469 === (11))){
var state_60468__$1 = state_60468;
var statearr_60513_60577 = state_60468__$1;
(statearr_60513_60577[(2)] = false);

(statearr_60513_60577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (9))){
var inst_60391 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
if(cljs.core.truth_(inst_60391)){
var statearr_60514_60578 = state_60468__$1;
(statearr_60514_60578[(1)] = (13));

} else {
var statearr_60515_60579 = state_60468__$1;
(statearr_60515_60579[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (5))){
var _ = (function (){var statearr_60516 = state_60468;
(statearr_60516[(4)] = cljs.core.rest.call(null,(state_60468[(4)])));

return statearr_60516;
})();
var state_60468__$1 = state_60468;
var ex60512 = (state_60468__$1[(2)]);
var statearr_60517_60580 = state_60468__$1;
(statearr_60517_60580[(5)] = ex60512);


var statearr_60518_60581 = state_60468__$1;
(statearr_60518_60581[(1)] = (4));

(statearr_60518_60581[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (14))){
var inst_60375 = (state_60468[(7)]);
var state_60468__$1 = state_60468;
var statearr_60519_60582 = state_60468__$1;
(statearr_60519_60582[(2)] = inst_60375);

(statearr_60519_60582[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (45))){
var inst_60462 = (state_60468[(2)]);
var inst_60463 = cljs.core.async.put_BANG_.call(null,pc,inst_60462);
var _ = (function (){var statearr_60520 = state_60468;
(statearr_60520[(4)] = cljs.core.rest.call(null,(state_60468[(4)])));

return statearr_60520;
})();
var state_60468__$1 = state_60468;
var statearr_60521_60583 = state_60468__$1;
(statearr_60521_60583[(2)] = inst_60463);

(statearr_60521_60583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (26))){
var inst_60397 = (state_60468[(13)]);
var state_60468__$1 = state_60468;
var statearr_60522_60584 = state_60468__$1;
(statearr_60522_60584[(2)] = inst_60397);

(statearr_60522_60584[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (16))){
var inst_60399 = (state_60468[(9)]);
var inst_60402 = cljs.core.not_EQ_.call(null,(0),inst_60399);
var state_60468__$1 = state_60468;
var statearr_60523_60585 = state_60468__$1;
(statearr_60523_60585[(2)] = inst_60402);

(statearr_60523_60585[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (38))){
var inst_60399 = (state_60468[(9)]);
var inst_60449 = (state_60468[(2)]);
var state_60468__$1 = (function (){var statearr_60524 = state_60468;
(statearr_60524[(15)] = inst_60449);

return statearr_60524;
})();
if(cljs.core.truth_(inst_60399)){
var statearr_60525_60586 = state_60468__$1;
(statearr_60525_60586[(1)] = (40));

} else {
var statearr_60526_60587 = state_60468__$1;
(statearr_60526_60587[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (30))){
var state_60468__$1 = state_60468;
var statearr_60527_60588 = state_60468__$1;
(statearr_60527_60588[(2)] = null);

(statearr_60527_60588[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (10))){
var state_60468__$1 = state_60468;
var statearr_60528_60589 = state_60468__$1;
(statearr_60528_60589[(2)] = true);

(statearr_60528_60589[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (18))){
var inst_60405 = (state_60468[(2)]);
var state_60468__$1 = state_60468;
if(cljs.core.truth_(inst_60405)){
var statearr_60529_60590 = state_60468__$1;
(statearr_60529_60590[(1)] = (19));

} else {
var statearr_60530_60591 = state_60468__$1;
(statearr_60530_60591[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (42))){
var inst_60435 = (state_60468[(17)]);
var inst_60454 = (state_60468[(2)]);
var state_60468__$1 = (function (){var statearr_60531 = state_60468;
(statearr_60531[(10)] = inst_60454);

return statearr_60531;
})();
if(cljs.core.truth_(inst_60435)){
var statearr_60532_60592 = state_60468__$1;
(statearr_60532_60592[(1)] = (43));

} else {
var statearr_60533_60593 = state_60468__$1;
(statearr_60533_60593[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (37))){
var inst_60374 = (state_60468[(16)]);
var state_60468__$1 = state_60468;
var statearr_60534_60594 = state_60468__$1;
(statearr_60534_60594[(2)] = inst_60374);

(statearr_60534_60594[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60469 === (8))){
var state_60468__$1 = state_60468;
var statearr_60535_60595 = state_60468__$1;
(statearr_60535_60595[(2)] = false);

(statearr_60535_60595[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2879__auto__ = null;
var fluree$db$api$query$state_machine__2879__auto____0 = (function (){
var statearr_60536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60536[(0)] = fluree$db$api$query$state_machine__2879__auto__);

(statearr_60536[(1)] = (1));

return statearr_60536;
});
var fluree$db$api$query$state_machine__2879__auto____1 = (function (state_60468){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_60468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e60537){var ex__2882__auto__ = e60537;
var statearr_60538_60596 = state_60468;
(statearr_60538_60596[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_60468[(4)]))){
var statearr_60539_60597 = state_60468;
(statearr_60539_60597[(1)] = cljs.core.first.call(null,(state_60468[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60598 = state_60468;
state_60468 = G__60598;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2879__auto__ = function(state_60468){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2879__auto____1.call(this,state_60468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2879__auto____0;
fluree$db$api$query$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2879__auto____1;
return fluree$db$api$query$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_60540 = f__2902__auto__.call(null);
(statearr_60540[(6)] = c__2901__auto___60542);

return statearr_60540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_60736){
var state_val_60737 = (state_60736[(1)]);
if((state_val_60737 === (7))){
var inst_60619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60620 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60621 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60622 = [inst_60620,inst_60621];
var inst_60623 = (new cljs.core.PersistentVector(null,2,(5),inst_60619,inst_60622,null));
var state_60736__$1 = state_60736;
var statearr_60738_60804 = state_60736__$1;
(statearr_60738_60804[(2)] = inst_60623);

(statearr_60738_60804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (20))){
var inst_60649 = (state_60736[(7)]);
var state_60736__$1 = state_60736;
var statearr_60739_60805 = state_60736__$1;
(statearr_60739_60805[(2)] = inst_60649);

(statearr_60739_60805[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (27))){
var state_60736__$1 = state_60736;
var statearr_60740_60806 = state_60736__$1;
(statearr_60740_60806[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (1))){
var state_60736__$1 = state_60736;
var statearr_60742_60807 = state_60736__$1;
(statearr_60742_60807[(2)] = null);

(statearr_60742_60807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (24))){
var inst_60648 = (state_60736[(8)]);
var state_60736__$1 = state_60736;
if(cljs.core.truth_(inst_60648)){
var statearr_60743_60808 = state_60736__$1;
(statearr_60743_60808[(1)] = (26));

} else {
var statearr_60744_60809 = state_60736__$1;
(statearr_60744_60809[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (39))){
var inst_60723 = (state_60736[(9)]);
var state_60736__$1 = state_60736;
var statearr_60745_60810 = state_60736__$1;
(statearr_60745_60810[(2)] = inst_60723);

(statearr_60745_60810[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (4))){
var inst_60599 = (state_60736[(2)]);
var state_60736__$1 = state_60736;
var statearr_60746_60811 = state_60736__$1;
(statearr_60746_60811[(2)] = inst_60599);

(statearr_60746_60811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (15))){
var inst_60633 = (state_60736[(10)]);
var inst_60628 = (state_60736[(11)]);
var inst_60642 = (state_60736[(2)]);
var inst_60643 = [inst_60633,inst_60642];
var inst_60644 = (new cljs.core.PersistentVector(null,2,(5),inst_60628,inst_60643,null));
var state_60736__$1 = state_60736;
var statearr_60747_60812 = state_60736__$1;
(statearr_60747_60812[(2)] = inst_60644);

(statearr_60747_60812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (21))){
var inst_60648 = (state_60736[(8)]);
var state_60736__$1 = state_60736;
var statearr_60748_60813 = state_60736__$1;
(statearr_60748_60813[(2)] = inst_60648);

(statearr_60748_60813[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (31))){
var inst_60689 = (state_60736[(2)]);
var state_60736__$1 = state_60736;
var statearr_60749_60814 = state_60736__$1;
(statearr_60749_60814[(2)] = inst_60689);

(statearr_60749_60814[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (32))){
var inst_60625 = (state_60736[(12)]);
var inst_60701 = cljs.core.pr_str.call(null,inst_60625);
var inst_60702 = ["Invalid block range provided: ",inst_60701].join('');
var inst_60703 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60704 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60705 = cljs.core.PersistentHashMap.fromArrays(inst_60703,inst_60704);
var inst_60706 = cljs.core.ex_info.call(null,inst_60702,inst_60705);
var inst_60707 = (function(){throw inst_60706})();
var state_60736__$1 = state_60736;
var statearr_60750_60815 = state_60736__$1;
(statearr_60750_60815[(2)] = inst_60707);

(statearr_60750_60815[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (40))){
var inst_60722 = (state_60736[(13)]);
var inst_60728 = (state_60736[(2)]);
var inst_60729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60730 = [inst_60722,inst_60728];
var inst_60731 = (new cljs.core.PersistentVector(null,2,(5),inst_60729,inst_60730,null));
var _ = (function (){var statearr_60751 = state_60736;
(statearr_60751[(4)] = cljs.core.rest.call(null,(state_60736[(4)])));

return statearr_60751;
})();
var state_60736__$1 = state_60736;
var statearr_60752_60816 = state_60736__$1;
(statearr_60752_60816[(2)] = inst_60731);

(statearr_60752_60816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (33))){
var state_60736__$1 = state_60736;
var statearr_60753_60817 = state_60736__$1;
(statearr_60753_60817[(2)] = null);

(statearr_60753_60817[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (13))){
var inst_60634 = (state_60736[(14)]);
var inst_60636 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60634);
var state_60736__$1 = state_60736;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60736__$1,(16),inst_60636);
} else {
if((state_val_60737 === (22))){
var inst_60667 = (state_60736[(2)]);
var state_60736__$1 = state_60736;
if(cljs.core.truth_(inst_60667)){
var statearr_60754_60818 = state_60736__$1;
(statearr_60754_60818[(1)] = (23));

} else {
var statearr_60755_60819 = state_60736__$1;
(statearr_60755_60819[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (36))){
var inst_60694 = (state_60736[(15)]);
var inst_60695 = (state_60736[(16)]);
var inst_60717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60718 = [inst_60694,inst_60695];
var inst_60719 = (new cljs.core.PersistentVector(null,2,(5),inst_60717,inst_60718,null));
var state_60736__$1 = state_60736;
var statearr_60756_60820 = state_60736__$1;
(statearr_60756_60820[(2)] = inst_60719);

(statearr_60756_60820[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (29))){
var inst_60625 = (state_60736[(12)]);
var inst_60680 = cljs.core.pr_str.call(null,inst_60625);
var inst_60681 = ["Invalid block range provided: ",inst_60680].join('');
var inst_60682 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60683 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60684 = cljs.core.PersistentHashMap.fromArrays(inst_60682,inst_60683);
var inst_60685 = cljs.core.ex_info.call(null,inst_60681,inst_60684);
var inst_60686 = (function(){throw inst_60685})();
var state_60736__$1 = state_60736;
var statearr_60757_60821 = state_60736__$1;
(statearr_60757_60821[(2)] = inst_60686);

(statearr_60757_60821[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (6))){
var inst_60617 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60736__$1 = state_60736;
var statearr_60758_60822 = state_60736__$1;
(statearr_60758_60822[(2)] = inst_60617);

(statearr_60758_60822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (28))){
var inst_60691 = (state_60736[(2)]);
var state_60736__$1 = state_60736;
var statearr_60759_60823 = state_60736__$1;
(statearr_60759_60823[(2)] = inst_60691);

(statearr_60759_60823[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (25))){
var inst_60694 = (state_60736[(15)]);
var inst_60695 = (state_60736[(16)]);
var inst_60693 = (state_60736[(2)]);
var inst_60694__$1 = cljs.core.nth.call(null,inst_60693,(0),null);
var inst_60695__$1 = cljs.core.nth.call(null,inst_60693,(1),null);
var inst_60696 = cljs.core.pos_int_QMARK_.call(null,inst_60694__$1);
var inst_60697 = cljs.core.pos_int_QMARK_.call(null,inst_60695__$1);
var inst_60698 = ((inst_60696) && (inst_60697));
var inst_60699 = cljs.core.not.call(null,inst_60698);
var state_60736__$1 = (function (){var statearr_60760 = state_60736;
(statearr_60760[(15)] = inst_60694__$1);

(statearr_60760[(16)] = inst_60695__$1);

return statearr_60760;
})();
if(inst_60699){
var statearr_60761_60824 = state_60736__$1;
(statearr_60761_60824[(1)] = (32));

} else {
var statearr_60762_60825 = state_60736__$1;
(statearr_60762_60825[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (34))){
var inst_60694 = (state_60736[(15)]);
var inst_60695 = (state_60736[(16)]);
var inst_60710 = (state_60736[(2)]);
var inst_60711 = (inst_60695 < inst_60694);
var state_60736__$1 = (function (){var statearr_60763 = state_60736;
(statearr_60763[(17)] = inst_60710);

return statearr_60763;
})();
if(cljs.core.truth_(inst_60711)){
var statearr_60764_60826 = state_60736__$1;
(statearr_60764_60826[(1)] = (35));

} else {
var statearr_60765_60827 = state_60736__$1;
(statearr_60765_60827[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (17))){
var inst_60648 = (state_60736[(8)]);
var inst_60650 = (state_60736[(18)]);
var inst_60653 = cljs.core.pr_str.call(null,inst_60648);
var inst_60654 = cljs.core.pr_str.call(null,inst_60650);
var inst_60655 = ["Start block is out of range for this ledger. Start block provided: ",inst_60653,". Database block: ",inst_60654].join('');
var inst_60656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60657 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60658 = cljs.core.PersistentHashMap.fromArrays(inst_60656,inst_60657);
var inst_60659 = cljs.core.ex_info.call(null,inst_60655,inst_60658);
var inst_60660 = (function(){throw inst_60659})();
var state_60736__$1 = state_60736;
var statearr_60766_60828 = state_60736__$1;
(statearr_60766_60828[(2)] = inst_60660);

(statearr_60766_60828[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (3))){
var inst_60734 = (state_60736[(2)]);
var state_60736__$1 = state_60736;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60736__$1,inst_60734);
} else {
if((state_val_60737 === (12))){
var inst_60625 = (state_60736[(12)]);
var inst_60634 = (state_60736[(14)]);
var inst_60632 = (state_60736[(2)]);
var inst_60633 = fluree.db.util.async.throw_err.call(null,inst_60632);
var inst_60634__$1 = cljs.core.second.call(null,inst_60625);
var state_60736__$1 = (function (){var statearr_60767 = state_60736;
(statearr_60767[(10)] = inst_60633);

(statearr_60767[(14)] = inst_60634__$1);

return statearr_60767;
})();
if(cljs.core.truth_(inst_60634__$1)){
var statearr_60768_60829 = state_60736__$1;
(statearr_60768_60829[(1)] = (13));

} else {
var statearr_60769_60830 = state_60736__$1;
(statearr_60769_60830[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (2))){
var _ = (function (){var statearr_60770 = state_60736;
(statearr_60770[(4)] = cljs.core.cons.call(null,(5),(state_60736[(4)])));

return statearr_60770;
})();
var inst_60614 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60615 = cljs.core.sequential_QMARK_.call(null,inst_60614);
var state_60736__$1 = state_60736;
if(inst_60615){
var statearr_60771_60831 = state_60736__$1;
(statearr_60771_60831[(1)] = (6));

} else {
var statearr_60772_60832 = state_60736__$1;
(statearr_60772_60832[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (23))){
var inst_60648 = (state_60736[(8)]);
var inst_60649 = (state_60736[(7)]);
var inst_60669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60670 = [inst_60648,inst_60649];
var inst_60671 = (new cljs.core.PersistentVector(null,2,(5),inst_60669,inst_60670,null));
var state_60736__$1 = state_60736;
var statearr_60773_60833 = state_60736__$1;
(statearr_60773_60833[(2)] = inst_60671);

(statearr_60773_60833[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (35))){
var inst_60694 = (state_60736[(15)]);
var inst_60695 = (state_60736[(16)]);
var inst_60713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60714 = [inst_60695,inst_60694];
var inst_60715 = (new cljs.core.PersistentVector(null,2,(5),inst_60713,inst_60714,null));
var state_60736__$1 = state_60736;
var statearr_60774_60834 = state_60736__$1;
(statearr_60774_60834[(2)] = inst_60715);

(statearr_60774_60834[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (19))){
var inst_60648 = (state_60736[(8)]);
var inst_60663 = (state_60736[(2)]);
var state_60736__$1 = (function (){var statearr_60775 = state_60736;
(statearr_60775[(19)] = inst_60663);

return statearr_60775;
})();
if(cljs.core.truth_(inst_60648)){
var statearr_60776_60835 = state_60736__$1;
(statearr_60776_60835[(1)] = (20));

} else {
var statearr_60777_60836 = state_60736__$1;
(statearr_60777_60836[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (11))){
var inst_60648 = (state_60736[(8)]);
var inst_60650 = (state_60736[(18)]);
var inst_60647 = (state_60736[(2)]);
var inst_60648__$1 = cljs.core.nth.call(null,inst_60647,(0),null);
var inst_60649 = cljs.core.nth.call(null,inst_60647,(1),null);
var inst_60650__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60651 = (inst_60648__$1 > inst_60650__$1);
var state_60736__$1 = (function (){var statearr_60779 = state_60736;
(statearr_60779[(8)] = inst_60648__$1);

(statearr_60779[(7)] = inst_60649);

(statearr_60779[(18)] = inst_60650__$1);

return statearr_60779;
})();
if(cljs.core.truth_(inst_60651)){
var statearr_60780_60837 = state_60736__$1;
(statearr_60780_60837[(1)] = (17));

} else {
var statearr_60781_60838 = state_60736__$1;
(statearr_60781_60838[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (9))){
var inst_60625 = (state_60736[(12)]);
var inst_60628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60629 = cljs.core.first.call(null,inst_60625);
var inst_60630 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60629);
var state_60736__$1 = (function (){var statearr_60782 = state_60736;
(statearr_60782[(11)] = inst_60628);

return statearr_60782;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60736__$1,(12),inst_60630);
} else {
if((state_val_60737 === (5))){
var _ = (function (){var statearr_60783 = state_60736;
(statearr_60783[(4)] = cljs.core.rest.call(null,(state_60736[(4)])));

return statearr_60783;
})();
var state_60736__$1 = state_60736;
var ex60778 = (state_60736__$1[(2)]);
var statearr_60784_60839 = state_60736__$1;
(statearr_60784_60839[(5)] = ex60778);


if((ex60778 instanceof Error)){
var statearr_60785_60840 = state_60736__$1;
(statearr_60785_60840[(1)] = (4));

(statearr_60785_60840[(5)] = null);

} else {
throw ex60778;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (14))){
var state_60736__$1 = state_60736;
var statearr_60786_60841 = state_60736__$1;
(statearr_60786_60841[(2)] = null);

(statearr_60786_60841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (26))){
var inst_60648 = (state_60736[(8)]);
var inst_60674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60675 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60676 = [inst_60648,inst_60675];
var inst_60677 = (new cljs.core.PersistentVector(null,2,(5),inst_60674,inst_60676,null));
var state_60736__$1 = state_60736;
var statearr_60787_60842 = state_60736__$1;
(statearr_60787_60842[(2)] = inst_60677);

(statearr_60787_60842[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (16))){
var inst_60638 = (state_60736[(2)]);
var inst_60639 = fluree.db.util.async.throw_err.call(null,inst_60638);
var state_60736__$1 = state_60736;
var statearr_60788_60843 = state_60736__$1;
(statearr_60788_60843[(2)] = inst_60639);

(statearr_60788_60843[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (38))){
var inst_60650 = (state_60736[(18)]);
var state_60736__$1 = state_60736;
var statearr_60789_60844 = state_60736__$1;
(statearr_60789_60844[(2)] = inst_60650);

(statearr_60789_60844[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (30))){
var state_60736__$1 = state_60736;
var statearr_60790_60845 = state_60736__$1;
(statearr_60790_60845[(2)] = null);

(statearr_60790_60845[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (10))){
var inst_60625 = (state_60736[(12)]);
var state_60736__$1 = state_60736;
var statearr_60791_60846 = state_60736__$1;
(statearr_60791_60846[(2)] = inst_60625);

(statearr_60791_60846[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (18))){
var state_60736__$1 = state_60736;
var statearr_60792_60847 = state_60736__$1;
(statearr_60792_60847[(2)] = null);

(statearr_60792_60847[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (37))){
var inst_60723 = (state_60736[(9)]);
var inst_60650 = (state_60736[(18)]);
var inst_60721 = (state_60736[(2)]);
var inst_60722 = cljs.core.nth.call(null,inst_60721,(0),null);
var inst_60723__$1 = cljs.core.nth.call(null,inst_60721,(1),null);
var inst_60724 = (inst_60723__$1 > inst_60650);
var state_60736__$1 = (function (){var statearr_60793 = state_60736;
(statearr_60793[(9)] = inst_60723__$1);

(statearr_60793[(13)] = inst_60722);

return statearr_60793;
})();
if(cljs.core.truth_(inst_60724)){
var statearr_60794_60848 = state_60736__$1;
(statearr_60794_60848[(1)] = (38));

} else {
var statearr_60795_60849 = state_60736__$1;
(statearr_60795_60849[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60737 === (8))){
var inst_60625 = (state_60736[(12)]);
var inst_60625__$1 = (state_60736[(2)]);
var inst_60626 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_60625__$1);
var state_60736__$1 = (function (){var statearr_60796 = state_60736;
(statearr_60796[(12)] = inst_60625__$1);

return statearr_60796;
})();
if(cljs.core.truth_(inst_60626)){
var statearr_60797_60850 = state_60736__$1;
(statearr_60797_60850[(1)] = (9));

} else {
var statearr_60798_60851 = state_60736__$1;
(statearr_60798_60851[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0 = (function (){
var statearr_60799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60799[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__);

(statearr_60799[(1)] = (1));

return statearr_60799;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1 = (function (state_60736){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_60736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e60800){var ex__2882__auto__ = e60800;
var statearr_60801_60852 = state_60736;
(statearr_60801_60852[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_60736[(4)]))){
var statearr_60802_60853 = state_60736;
(statearr_60802_60853[(1)] = cljs.core.first.call(null,(state_60736[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60854 = state_60736;
state_60736 = G__60854;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__ = function(state_60736){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1.call(this,state_60736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_60803 = f__2902__auto__.call(null);
(statearr_60803[(6)] = c__2901__auto__);

return statearr_60803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61004){
var state_val_61005 = (state_61004[(1)]);
if((state_val_61005 === (7))){
var inst_60916 = (state_61004[(2)]);
var inst_60917 = cljs.core.nth.call(null,inst_60916,(0),null);
var inst_60918 = cljs.core.nth.call(null,inst_60916,(1),null);
var inst_60926 = cljs.core.vals.call(null,inst_60918);
var inst_60927 = cljs.core.seq.call(null,inst_60926);
var inst_60928 = cljs.core.first.call(null,inst_60927);
var inst_60929 = cljs.core.next.call(null,inst_60927);
var inst_60930 = cljs.core.PersistentVector.EMPTY;
var inst_60931 = inst_60926;
var inst_60932 = inst_60930;
var state_61004__$1 = (function (){var statearr_61006 = state_61004;
(statearr_61006[(7)] = inst_60928);

(statearr_61006[(8)] = inst_60931);

(statearr_61006[(9)] = inst_60929);

(statearr_61006[(10)] = inst_60917);

(statearr_61006[(11)] = inst_60932);

return statearr_61006;
})();
var statearr_61007_61060 = state_61004__$1;
(statearr_61007_61060[(2)] = null);

(statearr_61007_61060[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (20))){
var inst_60938 = (state_61004[(12)]);
var inst_60943 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60944 = cljs.core.PersistentHashMap.EMPTY;
var inst_60945 = [true,inst_60944];
var inst_60946 = cljs.core.PersistentHashMap.fromArrays(inst_60943,inst_60945);
var inst_60947 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60946,inst_60938);
var state_61004__$1 = state_61004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61004__$1,(22),inst_60947);
} else {
if((state_val_61005 === (27))){
var inst_60992 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61008_61061 = state_61004__$1;
(statearr_61008_61061[(2)] = inst_60992);

(statearr_61008_61061[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (1))){
var state_61004__$1 = state_61004;
var statearr_61009_61062 = state_61004__$1;
(statearr_61009_61062[(2)] = null);

(statearr_61009_61062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (24))){
var inst_60956 = (state_61004[(13)]);
var inst_60994 = (state_61004[(2)]);
var inst_60995 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60996 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60997 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60998 = [inst_60996,inst_60997,inst_60956,inst_60994];
var inst_60999 = cljs.core.PersistentHashMap.fromArrays(inst_60995,inst_60998);
var _ = (function (){var statearr_61011 = state_61004;
(statearr_61011[(4)] = cljs.core.rest.call(null,(state_61004[(4)])));

return statearr_61011;
})();
var state_61004__$1 = state_61004;
var statearr_61012_61063 = state_61004__$1;
(statearr_61012_61063[(2)] = inst_60999);

(statearr_61012_61063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (4))){
var inst_60857 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61013_61064 = state_61004__$1;
(statearr_61013_61064[(2)] = inst_60857);

(statearr_61013_61064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (15))){
var inst_60879 = (state_61004[(14)]);
var inst_60873 = (state_61004[(15)]);
var inst_60897 = (state_61004[(16)]);
var inst_60876 = (state_61004[(17)]);
var inst_60888 = (state_61004[(18)]);
var inst_60881 = (state_61004[(19)]);
var inst_60902 = (state_61004[(20)]);
var inst_60895 = (state_61004[(21)]);
var inst_60887 = (state_61004[(22)]);
var inst_60880 = (state_61004[(23)]);
var inst_60875 = (state_61004[(24)]);
var inst_60908 = (function (){var vec__60870 = inst_60873;
var subject = inst_60895;
var flake = inst_60887;
var seq__60871 = inst_60876;
var r = inst_60888;
var asserted_subjects = inst_60880;
var G__60869 = inst_60879;
var flake_SINGLEQUOTE_ = inst_60902;
var retracted_subjects = inst_60881;
var first__60885 = inst_60887;
var first__60872 = inst_60875;
var seq__60884 = inst_60888;
var asserted_QMARK_ = inst_60897;
var vec__60883 = inst_60879;
return (function (p1__60856_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60856_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60909 = cljs.core.update.call(null,inst_60881,inst_60895,inst_60908);
var tmp61010 = inst_60880;
var inst_60879__$1 = inst_60888;
var inst_60880__$1 = tmp61010;
var inst_60881__$1 = inst_60909;
var state_61004__$1 = (function (){var statearr_61014 = state_61004;
(statearr_61014[(14)] = inst_60879__$1);

(statearr_61014[(19)] = inst_60881__$1);

(statearr_61014[(23)] = inst_60880__$1);

return statearr_61014;
})();
var statearr_61015_61065 = state_61004__$1;
(statearr_61015_61065[(2)] = null);

(statearr_61015_61065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (21))){
var inst_60954 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61016_61066 = state_61004__$1;
(statearr_61016_61066[(2)] = inst_60954);

(statearr_61016_61066[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (13))){
var inst_60897 = (state_61004[(16)]);
var inst_60902 = (state_61004[(2)]);
var state_61004__$1 = (function (){var statearr_61017 = state_61004;
(statearr_61017[(20)] = inst_60902);

return statearr_61017;
})();
if(cljs.core.truth_(inst_60897)){
var statearr_61018_61067 = state_61004__$1;
(statearr_61018_61067[(1)] = (14));

} else {
var statearr_61019_61068 = state_61004__$1;
(statearr_61019_61068[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (22))){
var inst_60939 = (state_61004[(25)]);
var inst_60932 = (state_61004[(11)]);
var inst_60949 = (state_61004[(2)]);
var inst_60950 = fluree.db.util.async.throw_err.call(null,inst_60949);
var inst_60951 = cljs.core.conj.call(null,inst_60932,inst_60950);
var inst_60931 = inst_60939;
var inst_60932__$1 = inst_60951;
var state_61004__$1 = (function (){var statearr_61020 = state_61004;
(statearr_61020[(8)] = inst_60931);

(statearr_61020[(11)] = inst_60932__$1);

return statearr_61020;
})();
var statearr_61021_61069 = state_61004__$1;
(statearr_61021_61069[(2)] = null);

(statearr_61021_61069[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (6))){
var inst_60879 = (state_61004[(14)]);
var inst_60887 = (state_61004[(22)]);
var inst_60886 = cljs.core.seq.call(null,inst_60879);
var inst_60887__$1 = cljs.core.first.call(null,inst_60886);
var inst_60888 = cljs.core.next.call(null,inst_60886);
var inst_60889 = cljs.core.not.call(null,inst_60887__$1);
var state_61004__$1 = (function (){var statearr_61022 = state_61004;
(statearr_61022[(18)] = inst_60888);

(statearr_61022[(22)] = inst_60887__$1);

return statearr_61022;
})();
if(inst_60889){
var statearr_61023_61070 = state_61004__$1;
(statearr_61023_61070[(1)] = (8));

} else {
var statearr_61024_61071 = state_61004__$1;
(statearr_61024_61071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (28))){
var inst_60970 = (state_61004[(26)]);
var inst_60977 = (state_61004[(27)]);
var inst_60987 = (state_61004[(2)]);
var inst_60988 = fluree.db.util.async.throw_err.call(null,inst_60987);
var inst_60989 = cljs.core.conj.call(null,inst_60970,inst_60988);
var inst_60969 = inst_60977;
var inst_60970__$1 = inst_60989;
var state_61004__$1 = (function (){var statearr_61025 = state_61004;
(statearr_61025[(26)] = inst_60970__$1);

(statearr_61025[(28)] = inst_60969);

return statearr_61025;
})();
var statearr_61026_61072 = state_61004__$1;
(statearr_61026_61072[(2)] = null);

(statearr_61026_61072[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (25))){
var inst_60970 = (state_61004[(26)]);
var state_61004__$1 = state_61004;
var statearr_61027_61073 = state_61004__$1;
(statearr_61027_61073[(2)] = inst_60970);

(statearr_61027_61073[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (17))){
var inst_60938 = (state_61004[(12)]);
var inst_60931 = (state_61004[(8)]);
var inst_60937 = cljs.core.seq.call(null,inst_60931);
var inst_60938__$1 = cljs.core.first.call(null,inst_60937);
var inst_60939 = cljs.core.next.call(null,inst_60937);
var inst_60940 = cljs.core.not.call(null,inst_60938__$1);
var state_61004__$1 = (function (){var statearr_61028 = state_61004;
(statearr_61028[(12)] = inst_60938__$1);

(statearr_61028[(25)] = inst_60939);

return statearr_61028;
})();
if(inst_60940){
var statearr_61029_61074 = state_61004__$1;
(statearr_61029_61074[(1)] = (19));

} else {
var statearr_61030_61075 = state_61004__$1;
(statearr_61030_61075[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (3))){
var inst_61002 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61004__$1,inst_61002);
} else {
if((state_val_61005 === (12))){
var inst_60887 = (state_61004[(22)]);
var inst_60900 = fluree.db.flake.flip_flake.call(null,inst_60887);
var state_61004__$1 = state_61004;
var statearr_61031_61076 = state_61004__$1;
(statearr_61031_61076[(2)] = inst_60900);

(statearr_61031_61076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (2))){
var inst_60873 = (state_61004[(15)]);
var _ = (function (){var statearr_61032 = state_61004;
(statearr_61032[(4)] = cljs.core.cons.call(null,(5),(state_61004[(4)])));

return statearr_61032;
})();
var inst_60873__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60874 = cljs.core.seq.call(null,inst_60873__$1);
var inst_60875 = cljs.core.first.call(null,inst_60874);
var inst_60876 = cljs.core.next.call(null,inst_60874);
var inst_60877 = cljs.core.PersistentHashMap.EMPTY;
var inst_60878 = cljs.core.PersistentHashMap.EMPTY;
var inst_60879 = inst_60873__$1;
var inst_60880 = inst_60877;
var inst_60881 = inst_60878;
var state_61004__$1 = (function (){var statearr_61033 = state_61004;
(statearr_61033[(14)] = inst_60879);

(statearr_61033[(15)] = inst_60873__$1);

(statearr_61033[(17)] = inst_60876);

(statearr_61033[(19)] = inst_60881);

(statearr_61033[(23)] = inst_60880);

(statearr_61033[(24)] = inst_60875);

return statearr_61033;
})();
var statearr_61034_61077 = state_61004__$1;
(statearr_61034_61077[(2)] = null);

(statearr_61034_61077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (23))){
var inst_60969 = (state_61004[(28)]);
var inst_60976 = (state_61004[(29)]);
var inst_60975 = cljs.core.seq.call(null,inst_60969);
var inst_60976__$1 = cljs.core.first.call(null,inst_60975);
var inst_60977 = cljs.core.next.call(null,inst_60975);
var inst_60978 = cljs.core.not.call(null,inst_60976__$1);
var state_61004__$1 = (function (){var statearr_61035 = state_61004;
(statearr_61035[(29)] = inst_60976__$1);

(statearr_61035[(27)] = inst_60977);

return statearr_61035;
})();
if(inst_60978){
var statearr_61036_61078 = state_61004__$1;
(statearr_61036_61078[(1)] = (25));

} else {
var statearr_61037_61079 = state_61004__$1;
(statearr_61037_61079[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (19))){
var inst_60932 = (state_61004[(11)]);
var state_61004__$1 = state_61004;
var statearr_61038_61080 = state_61004__$1;
(statearr_61038_61080[(2)] = inst_60932);

(statearr_61038_61080[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (11))){
var inst_60887 = (state_61004[(22)]);
var state_61004__$1 = state_61004;
var statearr_61040_61081 = state_61004__$1;
(statearr_61040_61081[(2)] = inst_60887);

(statearr_61040_61081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (9))){
var inst_60897 = (state_61004[(16)]);
var inst_60887 = (state_61004[(22)]);
var inst_60895 = inst_60887.s;
var inst_60896 = inst_60887.op;
var inst_60897__$1 = inst_60896 === true;
var state_61004__$1 = (function (){var statearr_61042 = state_61004;
(statearr_61042[(16)] = inst_60897__$1);

(statearr_61042[(21)] = inst_60895);

return statearr_61042;
})();
if(cljs.core.truth_(inst_60897__$1)){
var statearr_61043_61082 = state_61004__$1;
(statearr_61043_61082[(1)] = (11));

} else {
var statearr_61044_61083 = state_61004__$1;
(statearr_61044_61083[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (5))){
var _ = (function (){var statearr_61045 = state_61004;
(statearr_61045[(4)] = cljs.core.rest.call(null,(state_61004[(4)])));

return statearr_61045;
})();
var state_61004__$1 = state_61004;
var ex61039 = (state_61004__$1[(2)]);
var statearr_61046_61084 = state_61004__$1;
(statearr_61046_61084[(5)] = ex61039);


if((ex61039 instanceof Error)){
var statearr_61047_61085 = state_61004__$1;
(statearr_61047_61085[(1)] = (4));

(statearr_61047_61085[(5)] = null);

} else {
throw ex61039;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (14))){
var inst_60879 = (state_61004[(14)]);
var inst_60873 = (state_61004[(15)]);
var inst_60897 = (state_61004[(16)]);
var inst_60876 = (state_61004[(17)]);
var inst_60888 = (state_61004[(18)]);
var inst_60881 = (state_61004[(19)]);
var inst_60902 = (state_61004[(20)]);
var inst_60895 = (state_61004[(21)]);
var inst_60887 = (state_61004[(22)]);
var inst_60880 = (state_61004[(23)]);
var inst_60875 = (state_61004[(24)]);
var inst_60904 = (function (){var vec__60870 = inst_60873;
var subject = inst_60895;
var flake = inst_60887;
var seq__60871 = inst_60876;
var r = inst_60888;
var asserted_subjects = inst_60880;
var G__60869 = inst_60879;
var flake_SINGLEQUOTE_ = inst_60902;
var retracted_subjects = inst_60881;
var first__60885 = inst_60887;
var first__60872 = inst_60875;
var seq__60884 = inst_60888;
var asserted_QMARK_ = inst_60897;
var vec__60883 = inst_60879;
return (function (p1__60855_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60855_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60905 = cljs.core.update.call(null,inst_60880,inst_60895,inst_60904);
var tmp61041 = inst_60881;
var inst_60879__$1 = inst_60888;
var inst_60880__$1 = inst_60905;
var inst_60881__$1 = tmp61041;
var state_61004__$1 = (function (){var statearr_61048 = state_61004;
(statearr_61048[(14)] = inst_60879__$1);

(statearr_61048[(19)] = inst_60881__$1);

(statearr_61048[(23)] = inst_60880__$1);

return statearr_61048;
})();
var statearr_61049_61086 = state_61004__$1;
(statearr_61049_61086[(2)] = null);

(statearr_61049_61086[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (26))){
var inst_60976 = (state_61004[(29)]);
var inst_60981 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60982 = cljs.core.PersistentHashMap.EMPTY;
var inst_60983 = [true,inst_60982];
var inst_60984 = cljs.core.PersistentHashMap.fromArrays(inst_60981,inst_60983);
var inst_60985 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60984,inst_60976);
var state_61004__$1 = state_61004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61004__$1,(28),inst_60985);
} else {
if((state_val_61005 === (16))){
var inst_60912 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61050_61087 = state_61004__$1;
(statearr_61050_61087[(2)] = inst_60912);

(statearr_61050_61087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (10))){
var inst_60914 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61051_61088 = state_61004__$1;
(statearr_61051_61088[(2)] = inst_60914);

(statearr_61051_61088[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (18))){
var inst_60917 = (state_61004[(10)]);
var inst_60956 = (state_61004[(2)]);
var inst_60964 = cljs.core.vals.call(null,inst_60917);
var inst_60965 = cljs.core.seq.call(null,inst_60964);
var inst_60966 = cljs.core.first.call(null,inst_60965);
var inst_60967 = cljs.core.next.call(null,inst_60965);
var inst_60968 = cljs.core.PersistentVector.EMPTY;
var inst_60969 = inst_60964;
var inst_60970 = inst_60968;
var state_61004__$1 = (function (){var statearr_61052 = state_61004;
(statearr_61052[(26)] = inst_60970);

(statearr_61052[(28)] = inst_60969);

(statearr_61052[(30)] = inst_60967);

(statearr_61052[(13)] = inst_60956);

(statearr_61052[(31)] = inst_60966);

return statearr_61052;
})();
var statearr_61053_61089 = state_61004__$1;
(statearr_61053_61089[(2)] = null);

(statearr_61053_61089[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (8))){
var inst_60881 = (state_61004[(19)]);
var inst_60880 = (state_61004[(23)]);
var inst_60891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60892 = [inst_60880,inst_60881];
var inst_60893 = (new cljs.core.PersistentVector(null,2,(5),inst_60891,inst_60892,null));
var state_61004__$1 = state_61004;
var statearr_61054_61090 = state_61004__$1;
(statearr_61054_61090[(2)] = inst_60893);

(statearr_61054_61090[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_61055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61055[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__);

(statearr_61055[(1)] = (1));

return statearr_61055;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1 = (function (state_61004){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61056){var ex__2882__auto__ = e61056;
var statearr_61057_61091 = state_61004;
(statearr_61057_61091[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61004[(4)]))){
var statearr_61058_61092 = state_61004;
(statearr_61058_61092[(1)] = cljs.core.first.call(null,(state_61004[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61093 = state_61004;
state_61004 = G__61093;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__ = function(state_61004){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1.call(this,state_61004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61059 = f__2902__auto__.call(null);
(statearr_61059[(6)] = c__2901__auto__);

return statearr_61059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61125){
var state_val_61126 = (state_61125[(1)]);
if((state_val_61126 === (1))){
var inst_61094 = cljs.core.volatile_BANG_.call(null,(0));
var inst_61095 = cljs.core.PersistentHashMap.EMPTY;
var inst_61096 = cljs.core.volatile_BANG_.call(null,inst_61095);
var inst_61097 = cljs.core.first.call(null,resp);
var inst_61098 = cljs.core.rest.call(null,resp);
var inst_61099 = cljs.core.PersistentVector.EMPTY;
var inst_61100 = inst_61094;
var inst_61101 = inst_61096;
var inst_61102 = inst_61097;
var inst_61103 = inst_61098;
var inst_61104 = inst_61099;
var state_61125__$1 = (function (){var statearr_61127 = state_61125;
(statearr_61127[(7)] = inst_61104);

(statearr_61127[(8)] = inst_61101);

(statearr_61127[(9)] = inst_61103);

(statearr_61127[(10)] = inst_61100);

(statearr_61127[(11)] = inst_61102);

return statearr_61127;
})();
var statearr_61128_61143 = state_61125__$1;
(statearr_61128_61143[(2)] = null);

(statearr_61128_61143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61126 === (2))){
var inst_61101 = (state_61125[(8)]);
var inst_61100 = (state_61125[(10)]);
var inst_61102 = (state_61125[(11)]);
var inst_61106 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_61102,inst_61101,inst_61100);
var state_61125__$1 = state_61125;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61125__$1,(4),inst_61106);
} else {
if((state_val_61126 === (3))){
var inst_61123 = (state_61125[(2)]);
var state_61125__$1 = state_61125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61125__$1,inst_61123);
} else {
if((state_val_61126 === (4))){
var inst_61104 = (state_61125[(7)]);
var inst_61103 = (state_61125[(9)]);
var inst_61108 = (state_61125[(2)]);
var inst_61109 = fluree.db.util.async.throw_err.call(null,inst_61108);
var inst_61110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61111 = [inst_61109];
var inst_61112 = (new cljs.core.PersistentVector(null,1,(5),inst_61110,inst_61111,null));
var inst_61113 = cljs.core.concat.call(null,inst_61104,inst_61112);
var inst_61114 = cljs.core.first.call(null,inst_61103);
var state_61125__$1 = (function (){var statearr_61131 = state_61125;
(statearr_61131[(12)] = inst_61113);

return statearr_61131;
})();
if(cljs.core.truth_(inst_61114)){
var statearr_61132_61144 = state_61125__$1;
(statearr_61132_61144[(1)] = (5));

} else {
var statearr_61133_61145 = state_61125__$1;
(statearr_61133_61145[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61126 === (5))){
var inst_61113 = (state_61125[(12)]);
var inst_61101 = (state_61125[(8)]);
var inst_61103 = (state_61125[(9)]);
var inst_61100 = (state_61125[(10)]);
var inst_61116 = cljs.core.first.call(null,inst_61103);
var inst_61117 = cljs.core.rest.call(null,inst_61103);
var tmp61129 = inst_61101;
var tmp61130 = inst_61100;
var inst_61100__$1 = tmp61130;
var inst_61101__$1 = tmp61129;
var inst_61102 = inst_61116;
var inst_61103__$1 = inst_61117;
var inst_61104 = inst_61113;
var state_61125__$1 = (function (){var statearr_61134 = state_61125;
(statearr_61134[(7)] = inst_61104);

(statearr_61134[(8)] = inst_61101__$1);

(statearr_61134[(9)] = inst_61103__$1);

(statearr_61134[(10)] = inst_61100__$1);

(statearr_61134[(11)] = inst_61102);

return statearr_61134;
})();
var statearr_61135_61146 = state_61125__$1;
(statearr_61135_61146[(2)] = null);

(statearr_61135_61146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61126 === (6))){
var inst_61113 = (state_61125[(12)]);
var state_61125__$1 = state_61125;
var statearr_61136_61147 = state_61125__$1;
(statearr_61136_61147[(2)] = inst_61113);

(statearr_61136_61147[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61126 === (7))){
var inst_61121 = (state_61125[(2)]);
var state_61125__$1 = state_61125;
var statearr_61137_61148 = state_61125__$1;
(statearr_61137_61148[(2)] = inst_61121);

(statearr_61137_61148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_61138 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61138[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__);

(statearr_61138[(1)] = (1));

return statearr_61138;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1 = (function (state_61125){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61139){var ex__2882__auto__ = e61139;
var statearr_61140_61149 = state_61125;
(statearr_61140_61149[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61125[(4)]))){
var statearr_61141_61150 = state_61125;
(statearr_61141_61150[(1)] = cljs.core.first.call(null,(state_61125[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61151 = state_61125;
state_61125 = G__61151;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__ = function(state_61125){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1.call(this,state_61125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61142 = f__2902__auto__.call(null);
(statearr_61142[(6)] = c__2901__auto__);

return statearr_61142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__61154 = arguments.length;
switch (G__61154) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__61156){
var map__61157 = p__61156;
var map__61157__$1 = (((((!((map__61157 == null))))?(((((map__61157.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61157.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61157):map__61157);
var query = map__61157__$1;
var opts = cljs.core.get.call(null,map__61157__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61243){
var state_val_61244 = (state_61243[(1)]);
if((state_val_61244 === (7))){
var inst_61169 = (state_61243[(7)]);
var inst_61173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61174 = ["_auth/id",inst_61169];
var inst_61175 = (new cljs.core.PersistentVector(null,2,(5),inst_61173,inst_61174,null));
var state_61243__$1 = state_61243;
var statearr_61245_61289 = state_61243__$1;
(statearr_61245_61289[(2)] = inst_61175);

(statearr_61245_61289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (20))){
var inst_61223 = (state_61243[(2)]);
var inst_61224 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61243__$1 = (function (){var statearr_61246 = state_61243;
(statearr_61246[(8)] = inst_61223);

return statearr_61246;
})();
if(cljs.core.truth_(inst_61224)){
var statearr_61247_61290 = state_61243__$1;
(statearr_61247_61290[(1)] = (22));

} else {
var statearr_61248_61291 = state_61243__$1;
(statearr_61248_61291[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (27))){
var inst_61170 = (state_61243[(9)]);
var inst_61226 = (state_61243[(10)]);
var inst_61232 = (state_61243[(2)]);
var inst_61233 = fluree.db.api.query.response_time_formatted.call(null,inst_61170);
var inst_61234 = [(200),inst_61232,(100),inst_61233];
var inst_61235 = cljs.core.PersistentHashMap.fromArrays(inst_61226,inst_61234);
var state_61243__$1 = state_61243;
var statearr_61249_61292 = state_61243__$1;
(statearr_61249_61292[(2)] = inst_61235);

(statearr_61249_61292[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (1))){
var state_61243__$1 = state_61243;
var statearr_61250_61293 = state_61243__$1;
(statearr_61250_61293[(2)] = null);

(statearr_61250_61293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (24))){
var inst_61238 = (state_61243[(2)]);
var _ = (function (){var statearr_61251 = state_61243;
(statearr_61251[(4)] = cljs.core.rest.call(null,(state_61243[(4)])));

return statearr_61251;
})();
var state_61243__$1 = state_61243;
var statearr_61252_61294 = state_61243__$1;
(statearr_61252_61294[(2)] = inst_61238);

(statearr_61252_61294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (4))){
var inst_61159 = (state_61243[(2)]);
var state_61243__$1 = state_61243;
var statearr_61253_61295 = state_61243__$1;
(statearr_61253_61295[(2)] = inst_61159);

(statearr_61253_61295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (15))){
var inst_61210 = (state_61243[(11)]);
var state_61243__$1 = state_61243;
var statearr_61254_61296 = state_61243__$1;
(statearr_61254_61296[(2)] = inst_61210);

(statearr_61254_61296[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (21))){
var inst_61219 = (state_61243[(2)]);
var inst_61220 = fluree.db.util.async.throw_err.call(null,inst_61219);
var state_61243__$1 = state_61243;
var statearr_61255_61297 = state_61243__$1;
(statearr_61255_61297[(2)] = inst_61220);

(statearr_61255_61297[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (13))){
var inst_61210 = (state_61243[(11)]);
var inst_61168 = (state_61243[(12)]);
var inst_61209 = (state_61243[(2)]);
var inst_61210__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_61168);
var state_61243__$1 = (function (){var statearr_61256 = state_61243;
(statearr_61256[(11)] = inst_61210__$1);

(statearr_61256[(13)] = inst_61209);

return statearr_61256;
})();
if(cljs.core.truth_(inst_61210__$1)){
var statearr_61257_61298 = state_61243__$1;
(statearr_61257_61298[(1)] = (15));

} else {
var statearr_61258_61299 = state_61243__$1;
(statearr_61258_61299[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (22))){
var inst_61223 = (state_61243[(8)]);
var inst_61226 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61227 = cljs.core.sequential_QMARK_.call(null,inst_61223);
var state_61243__$1 = (function (){var statearr_61259 = state_61243;
(statearr_61259[(10)] = inst_61226);

return statearr_61259;
})();
if(inst_61227){
var statearr_61260_61300 = state_61243__$1;
(statearr_61260_61300[(1)] = (25));

} else {
var statearr_61261_61301 = state_61243__$1;
(statearr_61261_61301[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (6))){
var inst_61184 = (state_61243[(14)]);
var inst_61168 = (state_61243[(12)]);
var inst_61183 = (state_61243[(2)]);
var inst_61184__$1 = fluree.db.util.async.throw_err.call(null,inst_61183);
var inst_61185 = fluree.db.api.query.resolve_block_range.call(null,inst_61184__$1,inst_61168);
var state_61243__$1 = (function (){var statearr_61262 = state_61243;
(statearr_61262[(14)] = inst_61184__$1);

return statearr_61262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61243__$1,(10),inst_61185);
} else {
if((state_val_61244 === (25))){
var inst_61223 = (state_61243[(8)]);
var inst_61229 = cljs.core.doall.call(null,inst_61223);
var state_61243__$1 = state_61243;
var statearr_61263_61302 = state_61243__$1;
(statearr_61263_61302[(2)] = inst_61229);

(statearr_61263_61302[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (17))){
var inst_61215 = (state_61243[(2)]);
var state_61243__$1 = state_61243;
if(cljs.core.truth_(inst_61215)){
var statearr_61264_61303 = state_61243__$1;
(statearr_61264_61303[(1)] = (18));

} else {
var statearr_61265_61304 = state_61243__$1;
(statearr_61265_61304[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (3))){
var inst_61241 = (state_61243[(2)]);
var state_61243__$1 = state_61243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61243__$1,inst_61241);
} else {
if((state_val_61244 === (12))){
var inst_61168 = (state_61243[(12)]);
var inst_61201 = cljs.core.pr_str.call(null,inst_61168);
var inst_61202 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_61201].join('');
var inst_61203 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61204 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61205 = cljs.core.PersistentHashMap.fromArrays(inst_61203,inst_61204);
var inst_61206 = cljs.core.ex_info.call(null,inst_61202,inst_61205);
var inst_61207 = (function(){throw inst_61206})();
var state_61243__$1 = state_61243;
var statearr_61266_61305 = state_61243__$1;
(statearr_61266_61305[(2)] = inst_61207);

(statearr_61266_61305[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (2))){
var inst_61169 = (state_61243[(7)]);
var _ = (function (){var statearr_61267 = state_61243;
(statearr_61267[(4)] = cljs.core.cons.call(null,(5),(state_61243[(4)])));

return statearr_61267;
})();
var inst_61168 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61169__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_61170 = fluree.db.util.core.current_time_millis.call(null);
var inst_61171 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61243__$1 = (function (){var statearr_61268 = state_61243;
(statearr_61268[(9)] = inst_61170);

(statearr_61268[(7)] = inst_61169__$1);

(statearr_61268[(12)] = inst_61168);

(statearr_61268[(15)] = inst_61171);

return statearr_61268;
})();
if(cljs.core.truth_(inst_61169__$1)){
var statearr_61269_61306 = state_61243__$1;
(statearr_61269_61306[(1)] = (7));

} else {
var statearr_61270_61307 = state_61243__$1;
(statearr_61270_61307[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (23))){
var inst_61223 = (state_61243[(8)]);
var state_61243__$1 = state_61243;
var statearr_61271_61308 = state_61243__$1;
(statearr_61271_61308[(2)] = inst_61223);

(statearr_61271_61308[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (19))){
var inst_61209 = (state_61243[(13)]);
var state_61243__$1 = state_61243;
var statearr_61272_61309 = state_61243__$1;
(statearr_61272_61309[(2)] = inst_61209);

(statearr_61272_61309[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (11))){
var inst_61190 = (state_61243[(16)]);
var inst_61184 = (state_61243[(14)]);
var inst_61189 = (state_61243[(17)]);
var inst_61196 = fluree.db.api.query.block_range.call(null,inst_61184,inst_61189,inst_61190,opts);
var state_61243__$1 = state_61243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61243__$1,(14),inst_61196);
} else {
if((state_val_61244 === (9))){
var inst_61171 = (state_61243[(15)]);
var inst_61178 = (state_61243[(2)]);
var inst_61179 = [inst_61178];
var inst_61180 = cljs.core.PersistentHashMap.fromArrays(inst_61171,inst_61179);
var inst_61181 = fluree.db.api.query.db.call(null,conn,ledger,inst_61180);
var state_61243__$1 = state_61243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61243__$1,(6),inst_61181);
} else {
if((state_val_61244 === (5))){
var _ = (function (){var statearr_61274 = state_61243;
(statearr_61274[(4)] = cljs.core.rest.call(null,(state_61243[(4)])));

return statearr_61274;
})();
var state_61243__$1 = state_61243;
var ex61273 = (state_61243__$1[(2)]);
var statearr_61275_61310 = state_61243__$1;
(statearr_61275_61310[(5)] = ex61273);


if((ex61273 instanceof Error)){
var statearr_61276_61311 = state_61243__$1;
(statearr_61276_61311[(1)] = (4));

(statearr_61276_61311[(5)] = null);

} else {
throw ex61273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (14))){
var inst_61198 = (state_61243[(2)]);
var inst_61199 = fluree.db.util.async.throw_err.call(null,inst_61198);
var state_61243__$1 = state_61243;
var statearr_61277_61312 = state_61243__$1;
(statearr_61277_61312[(2)] = inst_61199);

(statearr_61277_61312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (26))){
var inst_61223 = (state_61243[(8)]);
var state_61243__$1 = state_61243;
var statearr_61278_61313 = state_61243__$1;
(statearr_61278_61313[(2)] = inst_61223);

(statearr_61278_61313[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (16))){
var inst_61168 = (state_61243[(12)]);
var inst_61213 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_61168);
var state_61243__$1 = state_61243;
var statearr_61279_61314 = state_61243__$1;
(statearr_61279_61314[(2)] = inst_61213);

(statearr_61279_61314[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (10))){
var inst_61168 = (state_61243[(12)]);
var inst_61187 = (state_61243[(2)]);
var inst_61188 = fluree.db.util.async.throw_err.call(null,inst_61187);
var inst_61189 = cljs.core.nth.call(null,inst_61188,(0),null);
var inst_61190 = cljs.core.nth.call(null,inst_61188,(1),null);
var inst_61191 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_61192 = cljs.core.dissoc.call(null,inst_61168,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61193 = cljs.core.keys.call(null,inst_61192);
var inst_61194 = cljs.core._EQ_.call(null,inst_61191,inst_61193);
var state_61243__$1 = (function (){var statearr_61280 = state_61243;
(statearr_61280[(16)] = inst_61190);

(statearr_61280[(17)] = inst_61189);

return statearr_61280;
})();
if(inst_61194){
var statearr_61281_61315 = state_61243__$1;
(statearr_61281_61315[(1)] = (11));

} else {
var statearr_61282_61316 = state_61243__$1;
(statearr_61282_61316[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (18))){
var inst_61184 = (state_61243[(14)]);
var inst_61209 = (state_61243[(13)]);
var inst_61217 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_61184,inst_61209);
var state_61243__$1 = state_61243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61243__$1,(21),inst_61217);
} else {
if((state_val_61244 === (8))){
var state_61243__$1 = state_61243;
var statearr_61283_61317 = state_61243__$1;
(statearr_61283_61317[(2)] = null);

(statearr_61283_61317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_61284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61284[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2879__auto__);

(statearr_61284[(1)] = (1));

return statearr_61284;
});
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1 = (function (state_61243){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61285){var ex__2882__auto__ = e61285;
var statearr_61286_61318 = state_61243;
(statearr_61286_61318[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61243[(4)]))){
var statearr_61287_61319 = state_61243;
(statearr_61287_61319[(1)] = cljs.core.first.call(null,(state_61243[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61320 = state_61243;
state_61243 = G__61320;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__ = function(state_61243){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1.call(this,state_61243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61288 = f__2902__auto__.call(null);
(statearr_61288[(6)] = c__2901__auto__);

return statearr_61288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61321 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__61321,(0),null);
var p = cljs.core.nth.call(null,vec__61321,(1),null);
var o = cljs.core.nth.call(null,vec__61321,(2),null);
var t = cljs.core.nth.call(null,vec__61321,(3),null);
var vec__61324 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__61324,(0),null);
var idx = cljs.core.nth.call(null,vec__61324,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61327 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__61327,(0),null);
var id = cljs.core.nth.call(null,vec__61327,(1),null);
var or__4126__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61331 = arguments.length;
var i__4737__auto___61332 = (0);
while(true){
if((i__4737__auto___61332 < len__4736__auto___61331)){
args__4742__auto__.push((arguments[i__4737__auto___61332]));

var G__61333 = (i__4737__auto___61332 + (1));
i__4737__auto___61332 = G__61333;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61330){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq61330));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61549){
var state_val_61550 = (state_61549[(1)]);
if((state_val_61550 === (7))){
var inst_61456 = (state_61549[(7)]);
var inst_61449 = (state_61549[(8)]);
var inst_61455 = cljs.core.seq.call(null,inst_61449);
var inst_61456__$1 = cljs.core.first.call(null,inst_61455);
var inst_61457 = cljs.core.next.call(null,inst_61455);
var state_61549__$1 = (function (){var statearr_61551 = state_61549;
(statearr_61551[(9)] = inst_61457);

(statearr_61551[(7)] = inst_61456__$1);

return statearr_61551;
})();
if(cljs.core.truth_(inst_61456__$1)){
var statearr_61552_61665 = state_61549__$1;
(statearr_61552_61665[(1)] = (9));

} else {
var statearr_61553_61666 = state_61549__$1;
(statearr_61553_61666[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (20))){
var inst_61539 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61554_61667 = state_61549__$1;
(statearr_61554_61667[(2)] = inst_61539);

(statearr_61554_61667[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (27))){
var inst_61475 = (state_61549[(10)]);
var inst_61493 = cljs.core.apply.call(null,cljs.core.hash_map,inst_61475);
var state_61549__$1 = state_61549;
var statearr_61555_61668 = state_61549__$1;
(statearr_61555_61668[(2)] = inst_61493);

(statearr_61555_61668[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (1))){
var state_61549__$1 = state_61549;
var statearr_61556_61669 = state_61549__$1;
(statearr_61556_61669[(2)] = null);

(statearr_61556_61669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (24))){
var state_61549__$1 = state_61549;
var statearr_61557_61670 = state_61549__$1;
(statearr_61557_61670[(2)] = true);

(statearr_61557_61670[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (39))){
var inst_61497 = (state_61549[(11)]);
var inst_61523 = (state_61549[(12)]);
var inst_61498 = (state_61549[(13)]);
var inst_61525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61526 = [inst_61497,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61527 = (new cljs.core.PersistentVector(null,2,(5),inst_61525,inst_61526,null));
var inst_61528 = cljs.core.assoc_in.call(null,inst_61523,inst_61527,inst_61498);
var state_61549__$1 = state_61549;
var statearr_61559_61671 = state_61549__$1;
(statearr_61559_61671[(2)] = inst_61528);

(statearr_61559_61671[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (4))){
var inst_61335 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61560_61672 = state_61549__$1;
(statearr_61560_61672[(2)] = inst_61335);

(statearr_61560_61672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (15))){
var inst_61457 = (state_61549[(9)]);
var inst_61450 = (state_61549[(14)]);
var tmp61558 = inst_61450;
var inst_61449 = inst_61457;
var inst_61450__$1 = tmp61558;
var state_61549__$1 = (function (){var statearr_61561 = state_61549;
(statearr_61561[(8)] = inst_61449);

(statearr_61561[(14)] = inst_61450__$1);

return statearr_61561;
})();
var statearr_61562_61673 = state_61549__$1;
(statearr_61562_61673[(2)] = null);

(statearr_61562_61673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (21))){
var inst_61475 = (state_61549[(10)]);
var inst_61480 = inst_61475.cljs$lang$protocol_mask$partition0$;
var inst_61481 = (inst_61480 & (64));
var inst_61482 = inst_61475.cljs$core$ISeq$;
var inst_61483 = (cljs.core.PROTOCOL_SENTINEL === inst_61482);
var inst_61484 = ((inst_61481) || (inst_61483));
var state_61549__$1 = state_61549;
if(cljs.core.truth_(inst_61484)){
var statearr_61563_61674 = state_61549__$1;
(statearr_61563_61674[(1)] = (24));

} else {
var statearr_61564_61675 = state_61549__$1;
(statearr_61564_61675[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (31))){
var inst_61450 = (state_61549[(14)]);
var state_61549__$1 = state_61549;
var statearr_61565_61676 = state_61549__$1;
(statearr_61565_61676[(2)] = inst_61450);

(statearr_61565_61676[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (32))){
var inst_61507 = (state_61549[(2)]);
var state_61549__$1 = (function (){var statearr_61566 = state_61549;
(statearr_61566[(15)] = inst_61507);

return statearr_61566;
})();
var statearr_61567_61677 = state_61549__$1;
(statearr_61567_61677[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (40))){
var inst_61523 = (state_61549[(12)]);
var state_61549__$1 = state_61549;
var statearr_61569_61678 = state_61549__$1;
(statearr_61569_61678[(2)] = inst_61523);

(statearr_61569_61678[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (33))){
var inst_61507 = (state_61549[(15)]);
var inst_61456 = (state_61549[(7)]);
var inst_61497 = (state_61549[(11)]);
var inst_61509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61510 = [inst_61497,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61511 = (new cljs.core.PersistentVector(null,2,(5),inst_61509,inst_61510,null));
var inst_61512 = cljs.core.update_in.call(null,inst_61507,inst_61511,cljs.core.conj,inst_61456);
var state_61549__$1 = state_61549;
var statearr_61570_61679 = state_61549__$1;
(statearr_61570_61679[(2)] = inst_61512);

(statearr_61570_61679[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (13))){
var inst_61459 = (state_61549[(16)]);
var state_61549__$1 = state_61549;
var statearr_61571_61680 = state_61549__$1;
(statearr_61571_61680[(2)] = inst_61459);

(statearr_61571_61680[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (22))){
var state_61549__$1 = state_61549;
var statearr_61572_61681 = state_61549__$1;
(statearr_61572_61681[(2)] = false);

(statearr_61572_61681[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (36))){
var inst_61474 = (state_61549[(17)]);
var inst_61497 = (state_61549[(11)]);
var inst_61515 = (state_61549[(18)]);
var inst_61517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61518 = [inst_61497,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61519 = (new cljs.core.PersistentVector(null,2,(5),inst_61517,inst_61518,null));
var inst_61520 = cljs.core.update_in.call(null,inst_61515,inst_61519,fluree.db.api.query.min_safe,inst_61474);
var state_61549__$1 = state_61549;
var statearr_61573_61682 = state_61549__$1;
(statearr_61573_61682[(2)] = inst_61520);

(statearr_61573_61682[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (41))){
var inst_61457 = (state_61549[(9)]);
var inst_61531 = (state_61549[(2)]);
var inst_61449 = inst_61457;
var inst_61450 = inst_61531;
var state_61549__$1 = (function (){var statearr_61574 = state_61549;
(statearr_61574[(8)] = inst_61449);

(statearr_61574[(14)] = inst_61450);

return statearr_61574;
})();
var statearr_61575_61683 = state_61549__$1;
(statearr_61575_61683[(2)] = null);

(statearr_61575_61683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (43))){
var state_61549__$1 = state_61549;
var statearr_61576_61684 = state_61549__$1;
(statearr_61576_61684[(2)] = null);

(statearr_61576_61684[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (29))){
var inst_61496 = (state_61549[(2)]);
var inst_61497 = cljs.core.get.call(null,inst_61496,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61498 = cljs.core.get.call(null,inst_61496,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61549__$1 = (function (){var statearr_61577 = state_61549;
(statearr_61577[(11)] = inst_61497);

(statearr_61577[(13)] = inst_61498);

return statearr_61577;
})();
var statearr_61578_61685 = state_61549__$1;
(statearr_61578_61685[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (44))){
var inst_61537 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61580_61686 = state_61549__$1;
(statearr_61580_61686[(2)] = inst_61537);

(statearr_61580_61686[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (6))){
var inst_61435 = (state_61549[(2)]);
var inst_61436 = fluree.db.util.async.throw_err.call(null,inst_61435);
var inst_61444 = resp;
var inst_61445 = cljs.core.seq.call(null,inst_61444);
var inst_61446 = cljs.core.first.call(null,inst_61445);
var inst_61447 = cljs.core.next.call(null,inst_61445);
var inst_61448 = cljs.core.PersistentHashMap.EMPTY;
var inst_61449 = inst_61444;
var inst_61450 = inst_61448;
var state_61549__$1 = (function (){var statearr_61581 = state_61549;
(statearr_61581[(19)] = inst_61447);

(statearr_61581[(20)] = inst_61436);

(statearr_61581[(21)] = inst_61446);

(statearr_61581[(8)] = inst_61449);

(statearr_61581[(14)] = inst_61450);

return statearr_61581;
})();
var statearr_61582_61687 = state_61549__$1;
(statearr_61582_61687[(2)] = null);

(statearr_61582_61687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (28))){
var inst_61475 = (state_61549[(10)]);
var state_61549__$1 = state_61549;
var statearr_61583_61688 = state_61549__$1;
(statearr_61583_61688[(2)] = inst_61475);

(statearr_61583_61688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (25))){
var state_61549__$1 = state_61549;
var statearr_61584_61689 = state_61549__$1;
(statearr_61584_61689[(2)] = false);

(statearr_61584_61689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (34))){
var inst_61507 = (state_61549[(15)]);
var state_61549__$1 = state_61549;
var statearr_61585_61690 = state_61549__$1;
(statearr_61585_61690[(2)] = inst_61507);

(statearr_61585_61690[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (17))){
var inst_61541 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61586_61691 = state_61549__$1;
(statearr_61586_61691[(2)] = inst_61541);

(statearr_61586_61691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (3))){
var inst_61547 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61549__$1,inst_61547);
} else {
if((state_val_61550 === (12))){
var inst_61456 = (state_61549[(7)]);
var inst_61436 = (state_61549[(20)]);
var inst_61461 = fluree.db.api.query.auth_match.call(null,auth,inst_61436,inst_61456);
var inst_61462 = cljs.core.not.call(null,inst_61461);
var state_61549__$1 = state_61549;
var statearr_61587_61692 = state_61549__$1;
(statearr_61587_61692[(2)] = inst_61462);

(statearr_61587_61692[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (2))){
var _ = (function (){var statearr_61588 = state_61549;
(statearr_61588[(4)] = cljs.core.cons.call(null,(5),(state_61549[(4)])));

return statearr_61588;
})();
var inst_61341 = (function (){return (function (p1__61334_SHARP_){
return p1__61334_SHARP_.t;
});
})();
var inst_61342 = cljs.core.map.call(null,inst_61341,resp);
var inst_61343 = cljs.core.set.call(null,inst_61342);
var inst_61431 = cljs.core.async.chan.call(null,(1));
var inst_61432 = (function (){var ts = inst_61343;
var c__2901__auto____$1 = inst_61431;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61429){
var state_val_61430 = (state_61429[(1)]);
if((state_val_61430 === (7))){
var inst_61363 = (state_61429[(7)]);
var inst_61357 = (state_61429[(8)]);
var inst_61375 = (state_61429[(9)]);
var inst_61369 = (state_61429[(10)]);
var inst_61368 = (state_61429[(2)]);
var inst_61369__$1 = fluree.db.util.async.throw_err.call(null,inst_61368);
var inst_61371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61372 = [inst_61363,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61373 = (new cljs.core.PersistentVector(null,2,(5),inst_61371,inst_61372,null));
var inst_61374 = cljs.core.assoc_in.call(null,inst_61357,inst_61373,inst_61369__$1);
var inst_61375__$1 = auth;
var state_61429__$1 = (function (){var statearr_61589 = state_61429;
(statearr_61589[(9)] = inst_61375__$1);

(statearr_61589[(10)] = inst_61369__$1);

(statearr_61589[(11)] = inst_61374);

return statearr_61589;
})();
if(cljs.core.truth_(inst_61375__$1)){
var statearr_61590_61693 = state_61429__$1;
(statearr_61590_61693[(1)] = (8));

} else {
var statearr_61591_61694 = state_61429__$1;
(statearr_61591_61694[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (1))){
var inst_61351 = (state_61429[(12)]);
var inst_61351__$1 = ts;
var inst_61352 = cljs.core.seq.call(null,inst_61351__$1);
var inst_61353 = cljs.core.first.call(null,inst_61352);
var inst_61354 = cljs.core.next.call(null,inst_61352);
var inst_61355 = cljs.core.PersistentHashMap.EMPTY;
var inst_61356 = inst_61351__$1;
var inst_61357 = inst_61355;
var state_61429__$1 = (function (){var statearr_61592 = state_61429;
(statearr_61592[(13)] = inst_61356);

(statearr_61592[(14)] = inst_61353);

(statearr_61592[(15)] = inst_61354);

(statearr_61592[(8)] = inst_61357);

(statearr_61592[(12)] = inst_61351__$1);

return statearr_61592;
})();
var statearr_61593_61695 = state_61429__$1;
(statearr_61593_61695[(2)] = null);

(statearr_61593_61695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (4))){
var inst_61363 = (state_61429[(7)]);
var inst_61366 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_61363);
var state_61429__$1 = state_61429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61429__$1,(7),inst_61366);
} else {
if((state_val_61430 === (13))){
var inst_61364 = (state_61429[(16)]);
var inst_61421 = (state_61429[(2)]);
var inst_61356 = inst_61364;
var inst_61357 = inst_61421;
var state_61429__$1 = (function (){var statearr_61594 = state_61429;
(statearr_61594[(13)] = inst_61356);

(statearr_61594[(8)] = inst_61357);

return statearr_61594;
})();
var statearr_61595_61696 = state_61429__$1;
(statearr_61595_61696[(2)] = null);

(statearr_61595_61696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (6))){
var inst_61425 = (state_61429[(2)]);
var state_61429__$1 = state_61429;
var statearr_61596_61697 = state_61429__$1;
(statearr_61596_61697[(2)] = inst_61425);

(statearr_61596_61697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (3))){
var inst_61427 = (state_61429[(2)]);
var state_61429__$1 = state_61429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61429__$1,inst_61427);
} else {
if((state_val_61430 === (12))){
var inst_61374 = (state_61429[(11)]);
var state_61429__$1 = state_61429;
var statearr_61597_61698 = state_61429__$1;
(statearr_61597_61698[(2)] = inst_61374);

(statearr_61597_61698[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (2))){
var inst_61356 = (state_61429[(13)]);
var inst_61363 = (state_61429[(7)]);
var inst_61362 = cljs.core.seq.call(null,inst_61356);
var inst_61363__$1 = cljs.core.first.call(null,inst_61362);
var inst_61364 = cljs.core.next.call(null,inst_61362);
var state_61429__$1 = (function (){var statearr_61598 = state_61429;
(statearr_61598[(7)] = inst_61363__$1);

(statearr_61598[(16)] = inst_61364);

return statearr_61598;
})();
if(cljs.core.truth_(inst_61363__$1)){
var statearr_61599_61699 = state_61429__$1;
(statearr_61599_61699[(1)] = (4));

} else {
var statearr_61600_61700 = state_61429__$1;
(statearr_61600_61700[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (11))){
var inst_61356 = (state_61429[(13)]);
var inst_61353 = (state_61429[(14)]);
var inst_61363 = (state_61429[(7)]);
var inst_61354 = (state_61429[(15)]);
var inst_61364 = (state_61429[(16)]);
var inst_61357 = (state_61429[(8)]);
var inst_61351 = (state_61429[(12)]);
var inst_61369 = (state_61429[(10)]);
var inst_61374 = (state_61429[(11)]);
var inst_61381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61382 = [inst_61363,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61383 = (new cljs.core.PersistentVector(null,2,(5),inst_61381,inst_61382,null));
var inst_61396 = cljs.core.async.chan.call(null,(1));
var inst_61397 = (function (){var t = inst_61363;
var G__61347 = inst_61356;
var block = inst_61369;
var r = inst_61364;
var vec__61359 = inst_61356;
var first__61350 = inst_61353;
var c__2901__auto____$2 = inst_61396;
var seq__61360 = inst_61364;
var first__61361 = inst_61363;
var vec__61348 = inst_61351;
var seq__61349 = inst_61354;
var acc = inst_61357;
var G__61370 = inst_61374;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61394){
var state_val_61395 = (state_61394[(1)]);
if((state_val_61395 === (1))){
var state_61394__$1 = state_61394;
var statearr_61601_61701 = state_61394__$1;
(statearr_61601_61701[(2)] = null);

(statearr_61601_61701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61395 === (2))){
var ___$1 = (function (){var statearr_61602 = state_61394;
(statearr_61602[(4)] = cljs.core.cons.call(null,(5),(state_61394[(4)])));

return statearr_61602;
})();
var ___$2 = (function (){var statearr_61603 = state_61394;
(statearr_61603[(4)] = cljs.core.rest.call(null,(state_61394[(4)])));

return statearr_61603;
})();
var state_61394__$1 = state_61394;
var statearr_61604_61702 = state_61394__$1;
(statearr_61604_61702[(2)] = db);

(statearr_61604_61702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61395 === (3))){
var inst_61392 = (state_61394[(2)]);
var state_61394__$1 = state_61394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61394__$1,inst_61392);
} else {
if((state_val_61395 === (4))){
var inst_61384 = (state_61394[(2)]);
var state_61394__$1 = state_61394;
var statearr_61606_61703 = state_61394__$1;
(statearr_61606_61703[(2)] = inst_61384);

(statearr_61606_61703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61395 === (5))){
var ___$1 = (function (){var statearr_61607 = state_61394;
(statearr_61607[(4)] = cljs.core.rest.call(null,(state_61394[(4)])));

return statearr_61607;
})();
var state_61394__$1 = state_61394;
var ex61605 = (state_61394__$1[(2)]);
var statearr_61608_61704 = state_61394__$1;
(statearr_61608_61704[(5)] = ex61605);


if((ex61605 instanceof Error)){
var statearr_61609_61705 = state_61394__$1;
(statearr_61609_61705[(1)] = (4));

(statearr_61609_61705[(5)] = null);

} else {
throw ex61605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61610 = [null,null,null,null,null,null,null];
(statearr_61610[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61610[(1)] = (1));

return statearr_61610;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61394){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61611){var ex__2882__auto__ = e61611;
var statearr_61612_61706 = state_61394;
(statearr_61612_61706[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61394[(4)]))){
var statearr_61613_61707 = state_61394;
(statearr_61613_61707[(1)] = cljs.core.first.call(null,(state_61394[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61708 = state_61394;
state_61394 = G__61708;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61394){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61614 = f__2902__auto__.call(null);
(statearr_61614[(6)] = c__2901__auto____$2);

return statearr_61614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});
})();
var inst_61398 = cljs.core.async.impl.dispatch.run.call(null,inst_61397);
var inst_61399 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61401 = ["?auth","?id"];
var inst_61402 = (new cljs.core.PersistentVector(null,2,(5),inst_61400,inst_61401,null));
var inst_61403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61405 = [inst_61363,"_tx/auth","?auth"];
var inst_61406 = (new cljs.core.PersistentVector(null,3,(5),inst_61404,inst_61405,null));
var inst_61407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61408 = ["?auth","_auth/id","?id"];
var inst_61409 = (new cljs.core.PersistentVector(null,3,(5),inst_61407,inst_61408,null));
var inst_61410 = [inst_61406,inst_61409];
var inst_61411 = (new cljs.core.PersistentVector(null,2,(5),inst_61403,inst_61410,null));
var inst_61412 = [inst_61402,inst_61411];
var inst_61413 = cljs.core.PersistentHashMap.fromArrays(inst_61399,inst_61412);
var inst_61414 = fluree.db.api.query.query_async.call(null,inst_61396,inst_61413);
var state_61429__$1 = (function (){var statearr_61615 = state_61429;
(statearr_61615[(17)] = inst_61383);

(statearr_61615[(18)] = inst_61398);

return statearr_61615;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61429__$1,(14),inst_61414);
} else {
if((state_val_61430 === (9))){
var state_61429__$1 = state_61429;
var statearr_61616_61709 = state_61429__$1;
(statearr_61616_61709[(2)] = show_auth);

(statearr_61616_61709[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (5))){
var inst_61357 = (state_61429[(8)]);
var state_61429__$1 = state_61429;
var statearr_61617_61710 = state_61429__$1;
(statearr_61617_61710[(2)] = inst_61357);

(statearr_61617_61710[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (14))){
var inst_61383 = (state_61429[(17)]);
var inst_61374 = (state_61429[(11)]);
var inst_61416 = (state_61429[(2)]);
var inst_61417 = fluree.db.util.async.throw_err.call(null,inst_61416);
var inst_61418 = cljs.core.assoc_in.call(null,inst_61374,inst_61383,inst_61417);
var state_61429__$1 = state_61429;
var statearr_61618_61711 = state_61429__$1;
(statearr_61618_61711[(2)] = inst_61418);

(statearr_61618_61711[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (10))){
var inst_61379 = (state_61429[(2)]);
var state_61429__$1 = state_61429;
if(cljs.core.truth_(inst_61379)){
var statearr_61619_61712 = state_61429__$1;
(statearr_61619_61712[(1)] = (11));

} else {
var statearr_61620_61713 = state_61429__$1;
(statearr_61620_61713[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61430 === (8))){
var inst_61375 = (state_61429[(9)]);
var state_61429__$1 = state_61429;
var statearr_61621_61714 = state_61429__$1;
(statearr_61621_61714[(2)] = inst_61375);

(statearr_61621_61714[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61622[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61622[(1)] = (1));

return statearr_61622;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61429){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61623){var ex__2882__auto__ = e61623;
var statearr_61624_61715 = state_61429;
(statearr_61624_61715[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61429[(4)]))){
var statearr_61625_61716 = state_61429;
(statearr_61625_61716[(1)] = cljs.core.first.call(null,(state_61429[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61717 = state_61429;
state_61429 = G__61717;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61429){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61626 = f__2902__auto__.call(null);
(statearr_61626[(6)] = c__2901__auto____$1);

return statearr_61626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});
})();
var inst_61433 = cljs.core.async.impl.dispatch.run.call(null,inst_61432);
var state_61549__$1 = (function (){var statearr_61627 = state_61549;
(statearr_61627[(22)] = inst_61433);

return statearr_61627;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61549__$1,(6),inst_61431);
} else {
if((state_val_61550 === (23))){
var inst_61491 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
if(cljs.core.truth_(inst_61491)){
var statearr_61628_61718 = state_61549__$1;
(statearr_61628_61718[(1)] = (27));

} else {
var statearr_61629_61719 = state_61549__$1;
(statearr_61629_61719[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (35))){
var inst_61515 = (state_61549[(2)]);
var state_61549__$1 = (function (){var statearr_61630 = state_61549;
(statearr_61630[(18)] = inst_61515);

return statearr_61630;
})();
var statearr_61631_61720 = state_61549__$1;
(statearr_61631_61720[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (19))){
var state_61549__$1 = state_61549;
var statearr_61633_61721 = state_61549__$1;
(statearr_61633_61721[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (11))){
var inst_61468 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
if(cljs.core.truth_(inst_61468)){
var statearr_61636_61722 = state_61549__$1;
(statearr_61636_61722[(1)] = (15));

} else {
var statearr_61637_61723 = state_61549__$1;
(statearr_61637_61723[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (9))){
var inst_61459 = (state_61549[(16)]);
var inst_61459__$1 = auth;
var state_61549__$1 = (function (){var statearr_61638 = state_61549;
(statearr_61638[(16)] = inst_61459__$1);

return statearr_61638;
})();
if(cljs.core.truth_(inst_61459__$1)){
var statearr_61639_61724 = state_61549__$1;
(statearr_61639_61724[(1)] = (12));

} else {
var statearr_61640_61725 = state_61549__$1;
(statearr_61640_61725[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (5))){
var _ = (function (){var statearr_61641 = state_61549;
(statearr_61641[(4)] = cljs.core.rest.call(null,(state_61549[(4)])));

return statearr_61641;
})();
var state_61549__$1 = state_61549;
var ex61635 = (state_61549__$1[(2)]);
var statearr_61642_61726 = state_61549__$1;
(statearr_61642_61726[(5)] = ex61635);


if((ex61635 instanceof Error)){
var statearr_61643_61727 = state_61549__$1;
(statearr_61643_61727[(1)] = (4));

(statearr_61643_61727[(5)] = null);

} else {
throw ex61635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (14))){
var inst_61465 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61644_61728 = state_61549__$1;
(statearr_61644_61728[(2)] = inst_61465);

(statearr_61644_61728[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (26))){
var inst_61488 = (state_61549[(2)]);
var state_61549__$1 = state_61549;
var statearr_61645_61729 = state_61549__$1;
(statearr_61645_61729[(2)] = inst_61488);

(statearr_61645_61729[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (16))){
var inst_61456 = (state_61549[(7)]);
var state_61549__$1 = state_61549;
if(cljs.core.truth_(inst_61456)){
var statearr_61646_61730 = state_61549__$1;
(statearr_61646_61730[(1)] = (18));

} else {
var statearr_61647_61731 = state_61549__$1;
(statearr_61647_61731[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (38))){
var inst_61523 = (state_61549[(2)]);
var state_61549__$1 = (function (){var statearr_61648 = state_61549;
(statearr_61648[(12)] = inst_61523);

return statearr_61648;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61649_61732 = state_61549__$1;
(statearr_61649_61732[(1)] = (39));

} else {
var statearr_61650_61733 = state_61549__$1;
(statearr_61650_61733[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (30))){
var inst_61497 = (state_61549[(11)]);
var inst_61450 = (state_61549[(14)]);
var inst_61501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61502 = [inst_61497,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61503 = (new cljs.core.PersistentVector(null,2,(5),inst_61501,inst_61502,null));
var inst_61504 = cljs.core.assoc_in.call(null,inst_61450,inst_61503,inst_61497);
var state_61549__$1 = state_61549;
var statearr_61651_61734 = state_61549__$1;
(statearr_61651_61734[(2)] = inst_61504);

(statearr_61651_61734[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (10))){
var inst_61456 = (state_61549[(7)]);
var state_61549__$1 = state_61549;
var statearr_61652_61735 = state_61549__$1;
(statearr_61652_61735[(2)] = inst_61456);

(statearr_61652_61735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (18))){
var inst_61474 = (state_61549[(17)]);
var inst_61475 = (state_61549[(10)]);
var inst_61456 = (state_61549[(7)]);
var inst_61436 = (state_61549[(20)]);
var inst_61474__$1 = inst_61456.t;
var inst_61475__$1 = cljs.core.get.call(null,inst_61436,inst_61474__$1);
var inst_61477 = (inst_61475__$1 == null);
var inst_61478 = cljs.core.not.call(null,inst_61477);
var state_61549__$1 = (function (){var statearr_61653 = state_61549;
(statearr_61653[(17)] = inst_61474__$1);

(statearr_61653[(10)] = inst_61475__$1);

return statearr_61653;
})();
if(inst_61478){
var statearr_61654_61736 = state_61549__$1;
(statearr_61654_61736[(1)] = (21));

} else {
var statearr_61655_61737 = state_61549__$1;
(statearr_61655_61737[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (42))){
var inst_61450 = (state_61549[(14)]);
var state_61549__$1 = state_61549;
var statearr_61656_61738 = state_61549__$1;
(statearr_61656_61738[(2)] = inst_61450);

(statearr_61656_61738[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (37))){
var inst_61515 = (state_61549[(18)]);
var state_61549__$1 = state_61549;
var statearr_61657_61739 = state_61549__$1;
(statearr_61657_61739[(2)] = inst_61515);

(statearr_61657_61739[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61550 === (8))){
var inst_61543 = (state_61549[(2)]);
var inst_61544 = cljs.core.vals.call(null,inst_61543);
var _ = (function (){var statearr_61658 = state_61549;
(statearr_61658[(4)] = cljs.core.rest.call(null,(state_61549[(4)])));

return statearr_61658;
})();
var state_61549__$1 = state_61549;
var statearr_61659_61740 = state_61549__$1;
(statearr_61659_61740[(2)] = inst_61544);

(statearr_61659_61740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61660 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61660[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61660[(1)] = (1));

return statearr_61660;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61549){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61661){var ex__2882__auto__ = e61661;
var statearr_61662_61741 = state_61549;
(statearr_61662_61741[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61549[(4)]))){
var statearr_61663_61742 = state_61549;
(statearr_61663_61742[(1)] = cljs.core.first.call(null,(state_61549[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61743 = state_61549;
state_61549 = G__61743;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61549){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61664 = f__2902__auto__.call(null);
(statearr_61664[(6)] = c__2901__auto__);

return statearr_61664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61889){
var state_val_61890 = (state_61889[(1)]);
if((state_val_61890 === (7))){
var state_61889__$1 = state_61889;
var statearr_61891_61967 = state_61889__$1;
(statearr_61891_61967[(2)] = false);

(statearr_61891_61967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (20))){
var inst_61795 = (state_61889[(7)]);
var inst_61783 = (state_61889[(8)]);
var inst_61805 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61783);
var state_61889__$1 = (function (){var statearr_61892 = state_61889;
(statearr_61892[(9)] = inst_61805);

return statearr_61892;
})();
if(cljs.core.truth_(inst_61795)){
var statearr_61893_61968 = state_61889__$1;
(statearr_61893_61968[(1)] = (23));

} else {
var statearr_61894_61969 = state_61889__$1;
(statearr_61894_61969[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (27))){
var state_61889__$1 = state_61889;
var statearr_61895_61970 = state_61889__$1;
(statearr_61895_61970[(2)] = (-1));

(statearr_61895_61970[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (1))){
var state_61889__$1 = state_61889;
var statearr_61896_61971 = state_61889__$1;
(statearr_61896_61971[(2)] = null);

(statearr_61896_61971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (24))){
var inst_61795 = (state_61889[(7)]);
var state_61889__$1 = state_61889;
var statearr_61897_61972 = state_61889__$1;
(statearr_61897_61972[(2)] = inst_61795);

(statearr_61897_61972[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (39))){
var inst_61781 = (state_61889[(10)]);
var state_61889__$1 = state_61889;
var statearr_61898_61973 = state_61889__$1;
(statearr_61898_61973[(2)] = inst_61781);

(statearr_61898_61973[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (46))){
var inst_61854 = (state_61889[(11)]);
var state_61889__$1 = state_61889;
var statearr_61899_61974 = state_61889__$1;
(statearr_61899_61974[(2)] = inst_61854);

(statearr_61899_61974[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (4))){
var inst_61744 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
var statearr_61900_61975 = state_61889__$1;
(statearr_61900_61975[(2)] = inst_61744);

(statearr_61900_61975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (15))){
var inst_61776 = (state_61889[(12)]);
var inst_61785 = (state_61889[(2)]);
var inst_61786 = fluree.db.util.async.throw_err.call(null,inst_61785);
var state_61889__$1 = (function (){var statearr_61901 = state_61889;
(statearr_61901[(13)] = inst_61786);

return statearr_61901;
})();
if(cljs.core.truth_(inst_61776)){
var statearr_61902_61976 = state_61889__$1;
(statearr_61902_61976[(1)] = (16));

} else {
var statearr_61903_61977 = state_61889__$1;
(statearr_61903_61977[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (48))){
var inst_61862 = (state_61889[(2)]);
var inst_61863 = fluree.db.util.async.throw_err.call(null,inst_61862);
var state_61889__$1 = state_61889;
var statearr_61904_61978 = state_61889__$1;
(statearr_61904_61978[(2)] = inst_61863);

(statearr_61904_61978[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (50))){
var inst_61866 = (state_61889[(14)]);
var state_61889__$1 = state_61889;
var statearr_61905_61979 = state_61889__$1;
(statearr_61905_61979[(2)] = inst_61866);

(statearr_61905_61979[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (21))){
var inst_61876 = cljs.core.pr_str.call(null,query_map);
var inst_61877 = ["History query not properly formatted. Provided ",inst_61876].join('');
var inst_61878 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61879 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61880 = cljs.core.PersistentHashMap.fromArrays(inst_61878,inst_61879);
var inst_61881 = cljs.core.ex_info.call(null,inst_61877,inst_61880);
var inst_61882 = (function(){throw inst_61881})();
var state_61889__$1 = state_61889;
var statearr_61906_61980 = state_61889__$1;
(statearr_61906_61980[(2)] = inst_61882);

(statearr_61906_61980[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (31))){
var inst_61786 = (state_61889[(13)]);
var inst_61829 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61786);
var state_61889__$1 = state_61889;
var statearr_61907_61981 = state_61889__$1;
(statearr_61907_61981[(2)] = inst_61829);

(statearr_61907_61981[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (32))){
var inst_61821 = (state_61889[(15)]);
var inst_61786 = (state_61889[(13)]);
var inst_61777 = (state_61889[(16)]);
var inst_61831 = (state_61889[(2)]);
var inst_61832 = fluree.db.api.query.get_history_pattern.call(null,inst_61777);
var inst_61833 = cljs.core.nth.call(null,inst_61832,(0),null);
var inst_61834 = cljs.core.nth.call(null,inst_61832,(1),null);
var inst_61835 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61836 = [inst_61821,inst_61831];
var inst_61837 = cljs.core.PersistentHashMap.fromArrays(inst_61835,inst_61836);
var inst_61838 = fluree.db.query.range.time_range.call(null,inst_61786,inst_61834,cljs.core._EQ_,inst_61833,inst_61837);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(34),inst_61838);
} else {
if((state_val_61890 === (40))){
var inst_61780 = (state_61889[(17)]);
var state_61889__$1 = state_61889;
var statearr_61908_61982 = state_61889__$1;
(statearr_61908_61982[(2)] = inst_61780);

(statearr_61908_61982[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (33))){
var inst_61825 = (state_61889[(2)]);
var inst_61826 = fluree.db.util.async.throw_err.call(null,inst_61825);
var inst_61827 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61826);
var state_61889__$1 = state_61889;
var statearr_61909_61983 = state_61889__$1;
(statearr_61909_61983[(2)] = inst_61827);

(statearr_61909_61983[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (13))){
var inst_61754 = (state_61889[(18)]);
var state_61889__$1 = state_61889;
var statearr_61910_61984 = state_61889__$1;
(statearr_61910_61984[(2)] = inst_61754);

(statearr_61910_61984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (22))){
var inst_61884 = (state_61889[(2)]);
var _ = (function (){var statearr_61911 = state_61889;
(statearr_61911[(4)] = cljs.core.rest.call(null,(state_61889[(4)])));

return statearr_61911;
})();
var state_61889__$1 = state_61889;
var statearr_61912_61985 = state_61889__$1;
(statearr_61912_61985[(2)] = inst_61884);

(statearr_61912_61985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (36))){
var state_61889__$1 = state_61889;
var statearr_61913_61986 = state_61889__$1;
(statearr_61913_61986[(2)] = null);

(statearr_61913_61986[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (41))){
var inst_61841 = (state_61889[(19)]);
var inst_61786 = (state_61889[(13)]);
var inst_61846 = (state_61889[(20)]);
var inst_61850 = (state_61889[(2)]);
var inst_61851 = fluree.db.api.query.format_history_resp.call(null,inst_61786,inst_61841,inst_61846,inst_61850);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(38),inst_61851);
} else {
if((state_val_61890 === (43))){
var inst_61778 = (state_61889[(21)]);
var state_61889__$1 = state_61889;
var statearr_61914_61987 = state_61889__$1;
(statearr_61914_61987[(2)] = inst_61778);

(statearr_61914_61987[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (29))){
var inst_61815 = (state_61889[(2)]);
var inst_61816 = fluree.db.util.async.throw_err.call(null,inst_61815);
var inst_61817 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61816);
var inst_61818 = (inst_61817 - (1));
var state_61889__$1 = state_61889;
var statearr_61915_61988 = state_61889__$1;
(statearr_61915_61988[(2)] = inst_61818);

(statearr_61915_61988[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (44))){
var inst_61858 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
if(cljs.core.truth_(inst_61858)){
var statearr_61916_61989 = state_61889__$1;
(statearr_61916_61989[(1)] = (45));

} else {
var statearr_61917_61990 = state_61889__$1;
(statearr_61917_61990[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (6))){
var inst_61754 = (state_61889[(18)]);
var inst_61759 = inst_61754.cljs$lang$protocol_mask$partition0$;
var inst_61760 = (inst_61759 & (64));
var inst_61761 = inst_61754.cljs$core$ISeq$;
var inst_61762 = (cljs.core.PROTOCOL_SENTINEL === inst_61761);
var inst_61763 = ((inst_61760) || (inst_61762));
var state_61889__$1 = state_61889;
if(cljs.core.truth_(inst_61763)){
var statearr_61918_61991 = state_61889__$1;
(statearr_61918_61991[(1)] = (9));

} else {
var statearr_61919_61992 = state_61889__$1;
(statearr_61919_61992[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (28))){
var inst_61796 = (state_61889[(22)]);
var inst_61821 = (state_61889[(2)]);
var state_61889__$1 = (function (){var statearr_61920 = state_61889;
(statearr_61920[(15)] = inst_61821);

return statearr_61920;
})();
if(cljs.core.truth_(inst_61796)){
var statearr_61921_61993 = state_61889__$1;
(statearr_61921_61993[(1)] = (30));

} else {
var statearr_61922_61994 = state_61889__$1;
(statearr_61922_61994[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (51))){
var inst_61874 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
var statearr_61923_61995 = state_61889__$1;
(statearr_61923_61995[(2)] = inst_61874);

(statearr_61923_61995[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (25))){
var inst_61810 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
if(cljs.core.truth_(inst_61810)){
var statearr_61924_61996 = state_61889__$1;
(statearr_61924_61996[(1)] = (26));

} else {
var statearr_61925_61997 = state_61889__$1;
(statearr_61925_61997[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (34))){
var inst_61782 = (state_61889[(23)]);
var inst_61840 = (state_61889[(2)]);
var inst_61841 = fluree.db.util.async.throw_err.call(null,inst_61840);
var state_61889__$1 = (function (){var statearr_61926 = state_61889;
(statearr_61926[(19)] = inst_61841);

return statearr_61926;
})();
if(cljs.core.truth_(inst_61782)){
var statearr_61927_61998 = state_61889__$1;
(statearr_61927_61998[(1)] = (35));

} else {
var statearr_61928_61999 = state_61889__$1;
(statearr_61928_61999[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (17))){
var state_61889__$1 = state_61889;
var statearr_61929_62000 = state_61889__$1;
(statearr_61929_62000[(2)] = null);

(statearr_61929_62000[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (3))){
var inst_61887 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61889__$1,inst_61887);
} else {
if((state_val_61890 === (12))){
var inst_61754 = (state_61889[(18)]);
var inst_61772 = cljs.core.apply.call(null,cljs.core.hash_map,inst_61754);
var state_61889__$1 = state_61889;
var statearr_61930_62001 = state_61889__$1;
(statearr_61930_62001[(2)] = inst_61772);

(statearr_61930_62001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (2))){
var inst_61754 = (state_61889[(18)]);
var _ = (function (){var statearr_61931 = state_61889;
(statearr_61931[(4)] = cljs.core.cons.call(null,(5),(state_61889[(4)])));

return statearr_61931;
})();
var inst_61754__$1 = query_map;
var inst_61756 = (inst_61754__$1 == null);
var inst_61757 = cljs.core.not.call(null,inst_61756);
var state_61889__$1 = (function (){var statearr_61932 = state_61889;
(statearr_61932[(18)] = inst_61754__$1);

return statearr_61932;
})();
if(inst_61757){
var statearr_61933_62002 = state_61889__$1;
(statearr_61933_62002[(1)] = (6));

} else {
var statearr_61934_62003 = state_61889__$1;
(statearr_61934_62003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (23))){
var inst_61795 = (state_61889[(7)]);
var inst_61807 = cljs.core.not_EQ_.call(null,(1),inst_61795);
var state_61889__$1 = state_61889;
var statearr_61935_62004 = state_61889__$1;
(statearr_61935_62004[(2)] = inst_61807);

(statearr_61935_62004[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (47))){
var inst_61805 = (state_61889[(9)]);
var inst_61866 = (state_61889[(2)]);
var state_61889__$1 = (function (){var statearr_61936 = state_61889;
(statearr_61936[(14)] = inst_61866);

return statearr_61936;
})();
if(cljs.core.truth_(inst_61805)){
var statearr_61937_62005 = state_61889__$1;
(statearr_61937_62005[(1)] = (49));

} else {
var statearr_61938_62006 = state_61889__$1;
(statearr_61938_62006[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (35))){
var inst_61782 = (state_61889[(23)]);
var inst_61843 = cljs.core.set.call(null,inst_61782);
var state_61889__$1 = state_61889;
var statearr_61939_62007 = state_61889__$1;
(statearr_61939_62007[(2)] = inst_61843);

(statearr_61939_62007[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (19))){
var inst_61790 = (state_61889[(2)]);
var inst_61791 = fluree.db.util.async.throw_err.call(null,inst_61790);
var state_61889__$1 = state_61889;
var statearr_61940_62008 = state_61889__$1;
(statearr_61940_62008[(2)] = inst_61791);

(statearr_61940_62008[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (11))){
var inst_61767 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
var statearr_61942_62009 = state_61889__$1;
(statearr_61942_62009[(2)] = inst_61767);

(statearr_61942_62009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (9))){
var state_61889__$1 = state_61889;
var statearr_61943_62010 = state_61889__$1;
(statearr_61943_62010[(2)] = true);

(statearr_61943_62010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (5))){
var _ = (function (){var statearr_61944 = state_61889;
(statearr_61944[(4)] = cljs.core.rest.call(null,(state_61889[(4)])));

return statearr_61944;
})();
var state_61889__$1 = state_61889;
var ex61941 = (state_61889__$1[(2)]);
var statearr_61945_62011 = state_61889__$1;
(statearr_61945_62011[(5)] = ex61941);


if((ex61941 instanceof Error)){
var statearr_61946_62012 = state_61889__$1;
(statearr_61946_62012[(1)] = (4));

(statearr_61946_62012[(5)] = null);

} else {
throw ex61941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (14))){
var inst_61775 = (state_61889[(2)]);
var inst_61776 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61777 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61778 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61779 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61780 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61781 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61782 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61783 = cljs.core.get.call(null,inst_61775,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61889__$1 = (function (){var statearr_61947 = state_61889;
(statearr_61947[(8)] = inst_61783);

(statearr_61947[(23)] = inst_61782);

(statearr_61947[(17)] = inst_61780);

(statearr_61947[(10)] = inst_61781);

(statearr_61947[(12)] = inst_61776);

(statearr_61947[(21)] = inst_61778);

(statearr_61947[(24)] = inst_61779);

(statearr_61947[(16)] = inst_61777);

return statearr_61947;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(15),sources);
} else {
if((state_val_61890 === (45))){
var inst_61854 = (state_61889[(11)]);
var inst_61786 = (state_61889[(13)]);
var inst_61860 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_61786,inst_61854);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(48),inst_61860);
} else {
if((state_val_61890 === (26))){
var inst_61795 = (state_61889[(7)]);
var inst_61786 = (state_61889[(13)]);
var inst_61812 = (inst_61795 - (1));
var inst_61813 = fluree.db.time_travel.as_of_block.call(null,inst_61786,inst_61812);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(29),inst_61813);
} else {
if((state_val_61890 === (16))){
var inst_61786 = (state_61889[(13)]);
var inst_61788 = fluree.db.api.query.resolve_block_range.call(null,inst_61786,query_map);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(19),inst_61788);
} else {
if((state_val_61890 === (38))){
var inst_61779 = (state_61889[(24)]);
var inst_61853 = (state_61889[(2)]);
var inst_61854 = fluree.db.util.async.throw_err.call(null,inst_61853);
var state_61889__$1 = (function (){var statearr_61948 = state_61889;
(statearr_61948[(11)] = inst_61854);

return statearr_61948;
})();
if(cljs.core.truth_(inst_61779)){
var statearr_61949_62013 = state_61889__$1;
(statearr_61949_62013[(1)] = (42));

} else {
var statearr_61950_62014 = state_61889__$1;
(statearr_61950_62014[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (30))){
var inst_61786 = (state_61889[(13)]);
var inst_61796 = (state_61889[(22)]);
var inst_61823 = fluree.db.time_travel.as_of_block.call(null,inst_61786,inst_61796);
var state_61889__$1 = state_61889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61889__$1,(33),inst_61823);
} else {
if((state_val_61890 === (10))){
var state_61889__$1 = state_61889;
var statearr_61951_62015 = state_61889__$1;
(statearr_61951_62015[(2)] = false);

(statearr_61951_62015[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (18))){
var inst_61794 = (state_61889[(2)]);
var inst_61795 = cljs.core.nth.call(null,inst_61794,(0),null);
var inst_61796 = cljs.core.nth.call(null,inst_61794,(1),null);
var inst_61797 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61798 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61799 = cljs.core.keys.call(null,inst_61798);
var inst_61800 = cljs.core._EQ_.call(null,inst_61797,inst_61799);
var state_61889__$1 = (function (){var statearr_61952 = state_61889;
(statearr_61952[(7)] = inst_61795);

(statearr_61952[(22)] = inst_61796);

return statearr_61952;
})();
if(inst_61800){
var statearr_61953_62016 = state_61889__$1;
(statearr_61953_62016[(1)] = (20));

} else {
var statearr_61954_62017 = state_61889__$1;
(statearr_61954_62017[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (42))){
var inst_61779 = (state_61889[(24)]);
var state_61889__$1 = state_61889;
var statearr_61955_62018 = state_61889__$1;
(statearr_61955_62018[(2)] = inst_61779);

(statearr_61955_62018[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (37))){
var inst_61781 = (state_61889[(10)]);
var inst_61846 = (state_61889[(2)]);
var state_61889__$1 = (function (){var statearr_61956 = state_61889;
(statearr_61956[(20)] = inst_61846);

return statearr_61956;
})();
if(cljs.core.truth_(inst_61781)){
var statearr_61957_62019 = state_61889__$1;
(statearr_61957_62019[(1)] = (39));

} else {
var statearr_61958_62020 = state_61889__$1;
(statearr_61958_62020[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (8))){
var inst_61770 = (state_61889[(2)]);
var state_61889__$1 = state_61889;
if(cljs.core.truth_(inst_61770)){
var statearr_61959_62021 = state_61889__$1;
(statearr_61959_62021[(1)] = (12));

} else {
var statearr_61960_62022 = state_61889__$1;
(statearr_61960_62022[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61890 === (49))){
var inst_61841 = (state_61889[(19)]);
var inst_61866 = (state_61889[(14)]);
var inst_61868 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61869 = cljs.core.count.call(null,inst_61841);
var inst_61870 = [inst_61866,inst_61869,(200)];
var inst_61871 = cljs.core.PersistentHashMap.fromArrays(inst_61868,inst_61870);
var state_61889__$1 = state_61889;
var statearr_61961_62023 = state_61889__$1;
(statearr_61961_62023[(2)] = inst_61871);

(statearr_61961_62023[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_61962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61962[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2879__auto__);

(statearr_61962[(1)] = (1));

return statearr_61962;
});
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1 = (function (state_61889){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_61889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61963){var ex__2882__auto__ = e61963;
var statearr_61964_62024 = state_61889;
(statearr_61964_62024[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_61889[(4)]))){
var statearr_61965_62025 = state_61889;
(statearr_61965_62025[(1)] = cljs.core.first.call(null,(state_61889[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62026 = state_61889;
state_61889 = G__62026;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__ = function(state_61889){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1.call(this,state_61889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61966 = f__2902__auto__.call(null);
(statearr_61966[(6)] = c__2901__auto__);

return statearr_61966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62179){
var state_val_62180 = (state_62179[(1)]);
if((state_val_62180 === (7))){
var state_62179__$1 = state_62179;
var statearr_62181_62273 = state_62179__$1;
(statearr_62181_62273[(2)] = false);

(statearr_62181_62273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (59))){
var inst_62164 = (state_62179[(7)]);
var state_62179__$1 = state_62179;
var statearr_62182_62274 = state_62179__$1;
(statearr_62182_62274[(2)] = inst_62164);

(statearr_62182_62274[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (20))){
var inst_62061 = (state_62179[(8)]);
var inst_62099 = (state_62179[(2)]);
var state_62179__$1 = (function (){var statearr_62183 = state_62179;
(statearr_62183[(9)] = inst_62099);

return statearr_62183;
})();
if(cljs.core.truth_(inst_62061)){
var statearr_62184_62275 = state_62179__$1;
(statearr_62184_62275[(1)] = (24));

} else {
var statearr_62185_62276 = state_62179__$1;
(statearr_62185_62276[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (58))){
var inst_62164 = (state_62179[(7)]);
var inst_62119 = (state_62179[(10)]);
var inst_62099 = (state_62179[(9)]);
var inst_62159 = (state_62179[(11)]);
var inst_62166 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_62167 = cljs.core.deref.call(null,inst_62119);
var inst_62168 = fluree.db.api.query.response_time_formatted.call(null,inst_62159);
var inst_62169 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_62099);
var inst_62170 = [(200),inst_62164,inst_62167,inst_62168,inst_62169];
var inst_62171 = cljs.core.PersistentHashMap.fromArrays(inst_62166,inst_62170);
var state_62179__$1 = state_62179;
var statearr_62186_62277 = state_62179__$1;
(statearr_62186_62277[(2)] = inst_62171);

(statearr_62186_62277[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (60))){
var inst_62174 = (state_62179[(2)]);
var _ = (function (){var statearr_62187 = state_62179;
(statearr_62187[(4)] = cljs.core.rest.call(null,(state_62179[(4)])));

return statearr_62187;
})();
var state_62179__$1 = state_62179;
var statearr_62188_62278 = state_62179__$1;
(statearr_62188_62278[(2)] = inst_62174);

(statearr_62188_62278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (27))){
var inst_62110 = (state_62179[(12)]);
var state_62179__$1 = state_62179;
var statearr_62189_62279 = state_62179__$1;
(statearr_62189_62279[(2)] = inst_62110);

(statearr_62189_62279[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (1))){
var state_62179__$1 = state_62179;
var statearr_62190_62280 = state_62179__$1;
(statearr_62190_62280[(2)] = null);

(statearr_62190_62280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (24))){
var inst_62061 = (state_62179[(8)]);
var inst_62099 = (state_62179[(9)]);
var inst_62101 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_62099);
var inst_62102 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_62099);
var inst_62103 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_62099);
var inst_62104 = fluree.db.api.query.get_sources.call(null,inst_62101,inst_62102,inst_62103,inst_62061);
var state_62179__$1 = state_62179;
var statearr_62191_62281 = state_62179__$1;
(statearr_62191_62281[(2)] = inst_62104);

(statearr_62191_62281[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (55))){
var inst_62152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62153 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62154 = cljs.core.PersistentHashMap.fromArrays(inst_62152,inst_62153);
var inst_62155 = cljs.core.ex_info.call(null,"Invalid query.",inst_62154);
var inst_62156 = (function(){throw inst_62155})();
var state_62179__$1 = state_62179;
var statearr_62192_62282 = state_62179__$1;
(statearr_62192_62282[(2)] = inst_62156);

(statearr_62192_62282[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (39))){
var inst_62063 = (state_62179[(13)]);
var state_62179__$1 = state_62179;
var statearr_62193_62283 = state_62179__$1;
(statearr_62193_62283[(2)] = inst_62063);

(statearr_62193_62283[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (46))){
var inst_62057 = (state_62179[(14)]);
var state_62179__$1 = state_62179;
var statearr_62194_62284 = state_62179__$1;
(statearr_62194_62284[(2)] = inst_62057);

(statearr_62194_62284[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (4))){
var inst_62028 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62195_62285 = state_62179__$1;
(statearr_62195_62285[(2)] = inst_62028);

(statearr_62195_62285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (54))){
var state_62179__$1 = state_62179;
var statearr_62196_62286 = state_62179__$1;
(statearr_62196_62286[(2)] = null);

(statearr_62196_62286[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (15))){
var state_62179__$1 = state_62179;
var statearr_62197_62287 = state_62179__$1;
(statearr_62197_62287[(2)] = null);

(statearr_62197_62287[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (48))){
var inst_62064 = (state_62179[(15)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62064)){
var statearr_62198_62288 = state_62179__$1;
(statearr_62198_62288[(1)] = (51));

} else {
var statearr_62199_62289 = state_62179__$1;
(statearr_62199_62289[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (50))){
var inst_62149 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62149)){
var statearr_62200_62290 = state_62179__$1;
(statearr_62200_62290[(1)] = (54));

} else {
var statearr_62201_62291 = state_62179__$1;
(statearr_62201_62291[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (21))){
var inst_62092 = (state_62179[(2)]);
var inst_62093 = fluree.db.util.async.throw_err.call(null,inst_62092);
var state_62179__$1 = state_62179;
var statearr_62202_62292 = state_62179__$1;
(statearr_62202_62292[(2)] = inst_62093);

(statearr_62202_62292[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (31))){
var state_62179__$1 = state_62179;
var statearr_62203_62293 = state_62179__$1;
(statearr_62203_62293[(2)] = null);

(statearr_62203_62293[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (32))){
var inst_62120 = (state_62179[(16)]);
var inst_62065 = (state_62179[(17)]);
var inst_62119 = (state_62179[(2)]);
var inst_62120__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62065);
var state_62179__$1 = (function (){var statearr_62204 = state_62179;
(statearr_62204[(16)] = inst_62120__$1);

(statearr_62204[(10)] = inst_62119);

return statearr_62204;
})();
if(cljs.core.truth_(inst_62120__$1)){
var statearr_62205_62294 = state_62179__$1;
(statearr_62205_62294[(1)] = (33));

} else {
var statearr_62206_62295 = state_62179__$1;
(statearr_62206_62295[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (40))){
var inst_62062 = (state_62179[(18)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62062)){
var statearr_62207_62296 = state_62179__$1;
(statearr_62207_62296[(1)] = (42));

} else {
var statearr_62208_62297 = state_62179__$1;
(statearr_62208_62297[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (56))){
var inst_62125 = (state_62179[(19)]);
var inst_62099 = (state_62179[(9)]);
var inst_62158 = (state_62179[(2)]);
var inst_62159 = fluree.db.util.core.current_time_millis.call(null);
var inst_62160 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_62125);
var inst_62161 = fluree.db.query.fql.query.call(null,inst_62099,inst_62160);
var state_62179__$1 = (function (){var statearr_62209 = state_62179;
(statearr_62209[(11)] = inst_62159);

(statearr_62209[(20)] = inst_62158);

return statearr_62209;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62179__$1,(57),inst_62161);
} else {
if((state_val_62180 === (33))){
var inst_62120 = (state_62179[(16)]);
var state_62179__$1 = state_62179;
var statearr_62210_62298 = state_62179__$1;
(statearr_62210_62298[(2)] = inst_62120);

(statearr_62210_62298[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (13))){
var inst_62035 = (state_62179[(21)]);
var state_62179__$1 = state_62179;
var statearr_62211_62299 = state_62179__$1;
(statearr_62211_62299[(2)] = inst_62035);

(statearr_62211_62299[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (22))){
var inst_62059 = (state_62179[(22)]);
var inst_62088 = (state_62179[(2)]);
var inst_62089 = fluree.db.util.async.throw_err.call(null,inst_62088);
var inst_62090 = fluree.db.time_travel.as_of_block.call(null,inst_62089,inst_62059);
var state_62179__$1 = state_62179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62179__$1,(21),inst_62090);
} else {
if((state_val_62180 === (36))){
var inst_62058 = (state_62179[(23)]);
var state_62179__$1 = state_62179;
var statearr_62212_62300 = state_62179__$1;
(statearr_62212_62300[(2)] = inst_62058);

(statearr_62212_62300[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (41))){
var inst_62139 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62213_62301 = state_62179__$1;
(statearr_62213_62301[(2)] = inst_62139);

(statearr_62213_62301[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (43))){
var inst_62066 = (state_62179[(24)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62066)){
var statearr_62214_62302 = state_62179__$1;
(statearr_62214_62302[(1)] = (45));

} else {
var statearr_62215_62303 = state_62179__$1;
(statearr_62215_62303[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (29))){
var inst_62114 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62114)){
var statearr_62216_62304 = state_62179__$1;
(statearr_62216_62304[(1)] = (30));

} else {
var statearr_62217_62305 = state_62179__$1;
(statearr_62217_62305[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (44))){
var inst_62137 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62218_62306 = state_62179__$1;
(statearr_62218_62306[(2)] = inst_62137);

(statearr_62218_62306[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (6))){
var inst_62035 = (state_62179[(21)]);
var inst_62040 = inst_62035.cljs$lang$protocol_mask$partition0$;
var inst_62041 = (inst_62040 & (64));
var inst_62042 = inst_62035.cljs$core$ISeq$;
var inst_62043 = (cljs.core.PROTOCOL_SENTINEL === inst_62042);
var inst_62044 = ((inst_62041) || (inst_62043));
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62044)){
var statearr_62219_62307 = state_62179__$1;
(statearr_62219_62307[(1)] = (9));

} else {
var statearr_62220_62308 = state_62179__$1;
(statearr_62220_62308[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (28))){
var inst_62109 = (state_62179[(25)]);
var state_62179__$1 = state_62179;
var statearr_62221_62309 = state_62179__$1;
(statearr_62221_62309[(2)] = inst_62109);

(statearr_62221_62309[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (51))){
var inst_62064 = (state_62179[(15)]);
var state_62179__$1 = state_62179;
var statearr_62222_62310 = state_62179__$1;
(statearr_62222_62310[(2)] = inst_62064);

(statearr_62222_62310[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (25))){
var inst_62106 = cljs.core.PersistentHashMap.EMPTY;
var state_62179__$1 = state_62179;
var statearr_62223_62311 = state_62179__$1;
(statearr_62223_62311[(2)] = inst_62106);

(statearr_62223_62311[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (34))){
var state_62179__$1 = state_62179;
var statearr_62224_62312 = state_62179__$1;
(statearr_62224_62312[(2)] = (1000000));

(statearr_62224_62312[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (17))){
var inst_62059 = (state_62179[(22)]);
var inst_62084 = (state_62179[(2)]);
var inst_62085 = sources;
var state_62179__$1 = (function (){var statearr_62225 = state_62179;
(statearr_62225[(26)] = inst_62085);

(statearr_62225[(27)] = inst_62084);

return statearr_62225;
})();
if(cljs.core.truth_(inst_62059)){
var statearr_62226_62313 = state_62179__$1;
(statearr_62226_62313[(1)] = (18));

} else {
var statearr_62227_62314 = state_62179__$1;
(statearr_62227_62314[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (3))){
var inst_62177 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62179__$1,inst_62177);
} else {
if((state_val_62180 === (12))){
var inst_62035 = (state_62179[(21)]);
var inst_62053 = cljs.core.apply.call(null,cljs.core.hash_map,inst_62035);
var state_62179__$1 = state_62179;
var statearr_62228_62315 = state_62179__$1;
(statearr_62228_62315[(2)] = inst_62053);

(statearr_62228_62315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (2))){
var inst_62035 = (state_62179[(21)]);
var _ = (function (){var statearr_62229 = state_62179;
(statearr_62229[(4)] = cljs.core.cons.call(null,(5),(state_62179[(4)])));

return statearr_62229;
})();
var inst_62035__$1 = flureeQL;
var inst_62037 = (inst_62035__$1 == null);
var inst_62038 = cljs.core.not.call(null,inst_62037);
var state_62179__$1 = (function (){var statearr_62230 = state_62179;
(statearr_62230[(21)] = inst_62035__$1);

return statearr_62230;
})();
if(inst_62038){
var statearr_62231_62316 = state_62179__$1;
(statearr_62231_62316[(1)] = (6));

} else {
var statearr_62232_62317 = state_62179__$1;
(statearr_62232_62317[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (23))){
var inst_62096 = (state_62179[(2)]);
var inst_62097 = fluree.db.util.async.throw_err.call(null,inst_62096);
var state_62179__$1 = state_62179;
var statearr_62233_62318 = state_62179__$1;
(statearr_62233_62318[(2)] = inst_62097);

(statearr_62233_62318[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (47))){
var inst_62135 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62234_62319 = state_62179__$1;
(statearr_62234_62319[(2)] = inst_62135);

(statearr_62234_62319[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (35))){
var inst_62065 = (state_62179[(17)]);
var inst_62119 = (state_62179[(10)]);
var inst_62108 = (state_62179[(28)]);
var inst_62058 = (state_62179[(23)]);
var inst_62124 = (state_62179[(2)]);
var inst_62125 = cljs.core.assoc.call(null,inst_62065,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_62108,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_62124,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_62119);
var state_62179__$1 = (function (){var statearr_62235 = state_62179;
(statearr_62235[(19)] = inst_62125);

return statearr_62235;
})();
if(cljs.core.truth_(inst_62058)){
var statearr_62236_62320 = state_62179__$1;
(statearr_62236_62320[(1)] = (36));

} else {
var statearr_62237_62321 = state_62179__$1;
(statearr_62237_62321[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (19))){
var inst_62085 = (state_62179[(26)]);
var state_62179__$1 = state_62179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62179__$1,(23),inst_62085);
} else {
if((state_val_62180 === (57))){
var inst_62109 = (state_62179[(25)]);
var inst_62163 = (state_62179[(2)]);
var inst_62164 = fluree.db.util.async.throw_err.call(null,inst_62163);
var state_62179__$1 = (function (){var statearr_62238 = state_62179;
(statearr_62238[(7)] = inst_62164);

return statearr_62238;
})();
if(cljs.core.truth_(inst_62109)){
var statearr_62239_62322 = state_62179__$1;
(statearr_62239_62322[(1)] = (58));

} else {
var statearr_62240_62323 = state_62179__$1;
(statearr_62240_62323[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (11))){
var inst_62048 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62242_62324 = state_62179__$1;
(statearr_62242_62324[(2)] = inst_62048);

(statearr_62242_62324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (9))){
var state_62179__$1 = state_62179;
var statearr_62243_62325 = state_62179__$1;
(statearr_62243_62325[(2)] = true);

(statearr_62243_62325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (5))){
var _ = (function (){var statearr_62244 = state_62179;
(statearr_62244[(4)] = cljs.core.rest.call(null,(state_62179[(4)])));

return statearr_62244;
})();
var state_62179__$1 = state_62179;
var ex62241 = (state_62179__$1[(2)]);
var statearr_62245_62326 = state_62179__$1;
(statearr_62245_62326[(5)] = ex62241);


if((ex62241 instanceof Error)){
var statearr_62246_62327 = state_62179__$1;
(statearr_62246_62327[(1)] = (4));

(statearr_62246_62327[(5)] = null);

} else {
throw ex62241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (14))){
var inst_62065 = (state_62179[(17)]);
var inst_62066 = (state_62179[(24)]);
var inst_62057 = (state_62179[(14)]);
var inst_62061 = (state_62179[(8)]);
var inst_62060 = (state_62179[(29)]);
var inst_62062 = (state_62179[(18)]);
var inst_62064 = (state_62179[(15)]);
var inst_62058 = (state_62179[(23)]);
var inst_62063 = (state_62179[(13)]);
var inst_62059 = (state_62179[(22)]);
var inst_62056 = (state_62179[(2)]);
var inst_62057__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_62058__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_62059__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62060__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_62061__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_62062__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_62063__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_62064__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_62065__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_62066__$1 = cljs.core.get.call(null,inst_62056,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_62067 = (function (){var construct = inst_62057__$1;
var select = inst_62058__$1;
var block = inst_62059__$1;
var where = inst_62060__$1;
var prefixes = inst_62061__$1;
var selectDistinct = inst_62062__$1;
var selectOne = inst_62063__$1;
var from = inst_62064__$1;
var opts = inst_62065__$1;
var selectReduced = inst_62066__$1;
var map__62034 = inst_62056;
return (function (p1__62027_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__62027_SHARP_);
});
})();
var inst_62068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62069 = [inst_62058__$1,inst_62063__$1,inst_62062__$1,inst_62066__$1];
var inst_62070 = (new cljs.core.PersistentVector(null,4,(5),inst_62068,inst_62069,null));
var inst_62071 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_62070);
var inst_62072 = cljs.core.count.call(null,inst_62071);
var inst_62073 = inst_62067.call(null,inst_62072);
var state_62179__$1 = (function (){var statearr_62247 = state_62179;
(statearr_62247[(17)] = inst_62065__$1);

(statearr_62247[(24)] = inst_62066__$1);

(statearr_62247[(14)] = inst_62057__$1);

(statearr_62247[(8)] = inst_62061__$1);

(statearr_62247[(29)] = inst_62060__$1);

(statearr_62247[(18)] = inst_62062__$1);

(statearr_62247[(15)] = inst_62064__$1);

(statearr_62247[(23)] = inst_62058__$1);

(statearr_62247[(13)] = inst_62063__$1);

(statearr_62247[(22)] = inst_62059__$1);

return statearr_62247;
})();
if(cljs.core.truth_(inst_62073)){
var statearr_62248_62328 = state_62179__$1;
(statearr_62248_62328[(1)] = (15));

} else {
var statearr_62249_62329 = state_62179__$1;
(statearr_62249_62329[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (45))){
var inst_62066 = (state_62179[(24)]);
var state_62179__$1 = state_62179;
var statearr_62250_62330 = state_62179__$1;
(statearr_62250_62330[(2)] = inst_62066);

(statearr_62250_62330[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (53))){
var inst_62146 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
var statearr_62251_62331 = state_62179__$1;
(statearr_62251_62331[(2)] = inst_62146);

(statearr_62251_62331[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (26))){
var inst_62065 = (state_62179[(17)]);
var inst_62110 = (state_62179[(12)]);
var inst_62108 = (state_62179[(2)]);
var inst_62109 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_62065);
var inst_62110__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62065);
var state_62179__$1 = (function (){var statearr_62252 = state_62179;
(statearr_62252[(25)] = inst_62109);

(statearr_62252[(28)] = inst_62108);

(statearr_62252[(12)] = inst_62110__$1);

return statearr_62252;
})();
if(cljs.core.truth_(inst_62110__$1)){
var statearr_62253_62332 = state_62179__$1;
(statearr_62253_62332[(1)] = (27));

} else {
var statearr_62254_62333 = state_62179__$1;
(statearr_62254_62333[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (16))){
var inst_62076 = cljs.core.pr_str.call(null,flureeQL);
var inst_62077 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_62076].join('');
var inst_62078 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62079 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62080 = cljs.core.PersistentHashMap.fromArrays(inst_62078,inst_62079);
var inst_62081 = cljs.core.ex_info.call(null,inst_62077,inst_62080);
var inst_62082 = (function(){throw inst_62081})();
var state_62179__$1 = state_62179;
var statearr_62255_62334 = state_62179__$1;
(statearr_62255_62334[(2)] = inst_62082);

(statearr_62255_62334[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (38))){
var inst_62141 = (state_62179[(30)]);
var inst_62141__$1 = (state_62179[(2)]);
var state_62179__$1 = (function (){var statearr_62256 = state_62179;
(statearr_62256[(30)] = inst_62141__$1);

return statearr_62256;
})();
if(cljs.core.truth_(inst_62141__$1)){
var statearr_62257_62335 = state_62179__$1;
(statearr_62257_62335[(1)] = (48));

} else {
var statearr_62258_62336 = state_62179__$1;
(statearr_62258_62336[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (30))){
var inst_62116 = cljs.core.volatile_BANG_.call(null,(0));
var state_62179__$1 = state_62179;
var statearr_62259_62337 = state_62179__$1;
(statearr_62259_62337[(2)] = inst_62116);

(statearr_62259_62337[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (10))){
var state_62179__$1 = state_62179;
var statearr_62260_62338 = state_62179__$1;
(statearr_62260_62338[(2)] = false);

(statearr_62260_62338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (18))){
var inst_62085 = (state_62179[(26)]);
var state_62179__$1 = state_62179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62179__$1,(22),inst_62085);
} else {
if((state_val_62180 === (52))){
var inst_62060 = (state_62179[(29)]);
var state_62179__$1 = state_62179;
var statearr_62261_62339 = state_62179__$1;
(statearr_62261_62339[(2)] = inst_62060);

(statearr_62261_62339[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (42))){
var inst_62062 = (state_62179[(18)]);
var state_62179__$1 = state_62179;
var statearr_62262_62340 = state_62179__$1;
(statearr_62262_62340[(2)] = inst_62062);

(statearr_62262_62340[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (37))){
var inst_62063 = (state_62179[(13)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62063)){
var statearr_62263_62341 = state_62179__$1;
(statearr_62263_62341[(1)] = (39));

} else {
var statearr_62264_62342 = state_62179__$1;
(statearr_62264_62342[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (8))){
var inst_62051 = (state_62179[(2)]);
var state_62179__$1 = state_62179;
if(cljs.core.truth_(inst_62051)){
var statearr_62265_62343 = state_62179__$1;
(statearr_62265_62343[(1)] = (12));

} else {
var statearr_62266_62344 = state_62179__$1;
(statearr_62266_62344[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62180 === (49))){
var inst_62141 = (state_62179[(30)]);
var state_62179__$1 = state_62179;
var statearr_62267_62345 = state_62179__$1;
(statearr_62267_62345[(2)] = inst_62141);

(statearr_62267_62345[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_62268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62268[(0)] = fluree$db$api$query$query_async_$_state_machine__2879__auto__);

(statearr_62268[(1)] = (1));

return statearr_62268;
});
var fluree$db$api$query$query_async_$_state_machine__2879__auto____1 = (function (state_62179){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62269){var ex__2882__auto__ = e62269;
var statearr_62270_62346 = state_62179;
(statearr_62270_62346[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62179[(4)]))){
var statearr_62271_62347 = state_62179;
(statearr_62271_62347[(1)] = cljs.core.first.call(null,(state_62179[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62348 = state_62179;
state_62179 = G__62348;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2879__auto__ = function(state_62179){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2879__auto____1.call(this,state_62179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62272 = f__2902__auto__.call(null);
(statearr_62272[(6)] = c__2901__auto__);

return statearr_62272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62502){
var state_val_62503 = (state_62502[(1)]);
if((state_val_62503 === (7))){
var inst_62497 = (state_62502[(2)]);
var _ = (function (){var statearr_62504 = state_62502;
(statearr_62504[(4)] = cljs.core.rest.call(null,(state_62502[(4)])));

return statearr_62504;
})();
var state_62502__$1 = state_62502;
var statearr_62505_62584 = state_62502__$1;
(statearr_62505_62584[(2)] = inst_62497);

(statearr_62505_62584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (20))){
var inst_62418 = (state_62502[(7)]);
var inst_62436 = cljs.core.apply.call(null,cljs.core.hash_map,inst_62418);
var state_62502__$1 = state_62502;
var statearr_62506_62585 = state_62502__$1;
(statearr_62506_62585[(2)] = inst_62436);

(statearr_62506_62585[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (27))){
var inst_62446 = (state_62502[(8)]);
var state_62502__$1 = state_62502;
var statearr_62507_62586 = state_62502__$1;
(statearr_62507_62586[(2)] = inst_62446);

(statearr_62507_62586[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (1))){
var state_62502__$1 = state_62502;
var statearr_62508_62587 = state_62502__$1;
(statearr_62508_62587[(2)] = null);

(statearr_62508_62587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (24))){
var inst_62443 = (state_62502[(9)]);
var inst_62388 = (state_62502[(10)]);
var inst_62446 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62443);
var inst_62447 = (inst_62388 == null);
var state_62502__$1 = (function (){var statearr_62509 = state_62502;
(statearr_62509[(8)] = inst_62446);

return statearr_62509;
})();
if(cljs.core.truth_(inst_62447)){
var statearr_62510_62588 = state_62502__$1;
(statearr_62510_62588[(1)] = (27));

} else {
var statearr_62511_62589 = state_62502__$1;
(statearr_62511_62589[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (39))){
var inst_62443 = (state_62502[(9)]);
var inst_62389 = (state_62502[(11)]);
var inst_62474 = cljs.core.get.call(null,inst_62443,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62475 = (inst_62389 + inst_62474);
var state_62502__$1 = state_62502;
var statearr_62512_62590 = state_62502__$1;
(statearr_62512_62590[(2)] = inst_62475);

(statearr_62512_62590[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (46))){
var inst_62443 = (state_62502[(9)]);
var state_62502__$1 = state_62502;
var statearr_62513_62591 = state_62502__$1;
(statearr_62513_62591[(2)] = inst_62443);

(statearr_62513_62591[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (4))){
var inst_62349 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62514_62592 = state_62502__$1;
(statearr_62514_62592[(2)] = inst_62349);

(statearr_62514_62592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (15))){
var state_62502__$1 = state_62502;
var statearr_62515_62593 = state_62502__$1;
(statearr_62515_62593[(2)] = false);

(statearr_62515_62593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (21))){
var inst_62418 = (state_62502[(7)]);
var state_62502__$1 = state_62502;
var statearr_62516_62594 = state_62502__$1;
(statearr_62516_62594[(2)] = inst_62418);

(statearr_62516_62594[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (31))){
var inst_62446 = (state_62502[(8)]);
var inst_62388 = (state_62502[(10)]);
var inst_62453 = cljs.core._EQ_.call(null,(200),inst_62446);
var inst_62454 = cljs.core._EQ_.call(null,(200),inst_62388);
var inst_62455 = cljs.core._EQ_.call(null,(207),inst_62388);
var inst_62456 = ((inst_62453) || (inst_62454) || (inst_62455));
var state_62502__$1 = state_62502;
if(cljs.core.truth_(inst_62456)){
var statearr_62517_62595 = state_62502__$1;
(statearr_62517_62595[(1)] = (33));

} else {
var statearr_62518_62596 = state_62502__$1;
(statearr_62518_62596[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (32))){
var inst_62467 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62519_62597 = state_62502__$1;
(statearr_62519_62597[(2)] = inst_62467);

(statearr_62519_62597[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (40))){
var state_62502__$1 = state_62502;
var statearr_62520_62598 = state_62502__$1;
(statearr_62520_62598[(2)] = null);

(statearr_62520_62598[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (33))){
var state_62502__$1 = state_62502;
var statearr_62521_62599 = state_62502__$1;
(statearr_62521_62599[(2)] = (207));

(statearr_62521_62599[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (13))){
var inst_62412 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62522_62600 = state_62502__$1;
(statearr_62522_62600[(2)] = inst_62412);

(statearr_62522_62600[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (22))){
var inst_62402 = (state_62502[(12)]);
var inst_62439 = (state_62502[(2)]);
var inst_62440 = cljs.core.get.call(null,inst_62439,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62441 = cljs.core.get.call(null,inst_62439,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62502__$1 = (function (){var statearr_62523 = state_62502;
(statearr_62523[(13)] = inst_62441);

(statearr_62523[(14)] = inst_62440);

return statearr_62523;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62502__$1,(23),inst_62402);
} else {
if((state_val_62503 === (36))){
var inst_62446 = (state_62502[(8)]);
var inst_62388 = (state_62502[(10)]);
var inst_62460 = ((inst_62446 > inst_62388) ? inst_62446 : inst_62388);
var state_62502__$1 = state_62502;
var statearr_62524_62601 = state_62502__$1;
(statearr_62524_62601[(2)] = inst_62460);

(statearr_62524_62601[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (41))){
var inst_62444 = (state_62502[(15)]);
var inst_62478 = (state_62502[(2)]);
var state_62502__$1 = (function (){var statearr_62525 = state_62502;
(statearr_62525[(16)] = inst_62478);

return statearr_62525;
})();
if(cljs.core.truth_(inst_62444)){
var statearr_62526_62602 = state_62502__$1;
(statearr_62526_62602[(1)] = (42));

} else {
var statearr_62527_62603 = state_62502__$1;
(statearr_62527_62603[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (43))){
var inst_62441 = (state_62502[(13)]);
var state_62502__$1 = state_62502;
if(cljs.core.truth_(inst_62441)){
var statearr_62528_62604 = state_62502__$1;
(statearr_62528_62604[(1)] = (45));

} else {
var statearr_62529_62605 = state_62502__$1;
(statearr_62529_62605[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (29))){
var inst_62469 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62530_62606 = state_62502__$1;
(statearr_62530_62606[(2)] = inst_62469);

(statearr_62530_62606[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (44))){
var inst_62400 = (state_62502[(17)]);
var inst_62478 = (state_62502[(16)]);
var inst_62472 = (state_62502[(18)]);
var inst_62492 = (state_62502[(2)]);
var inst_62387 = inst_62400;
var inst_62388 = inst_62472;
var inst_62389 = inst_62478;
var inst_62390 = inst_62492;
var state_62502__$1 = (function (){var statearr_62531 = state_62502;
(statearr_62531[(19)] = inst_62390);

(statearr_62531[(11)] = inst_62389);

(statearr_62531[(10)] = inst_62388);

(statearr_62531[(20)] = inst_62387);

return statearr_62531;
})();
var statearr_62532_62607 = state_62502__$1;
(statearr_62532_62607[(2)] = null);

(statearr_62532_62607[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (6))){
var inst_62402 = (state_62502[(12)]);
var inst_62387 = (state_62502[(20)]);
var inst_62398 = cljs.core.seq.call(null,inst_62387);
var inst_62399 = cljs.core.first.call(null,inst_62398);
var inst_62400 = cljs.core.next.call(null,inst_62398);
var inst_62401 = cljs.core.nth.call(null,inst_62399,(0),null);
var inst_62402__$1 = cljs.core.nth.call(null,inst_62399,(1),null);
var inst_62403 = (inst_62402__$1 == null);
var state_62502__$1 = (function (){var statearr_62533 = state_62502;
(statearr_62533[(12)] = inst_62402__$1);

(statearr_62533[(17)] = inst_62400);

(statearr_62533[(21)] = inst_62401);

return statearr_62533;
})();
if(cljs.core.truth_(inst_62403)){
var statearr_62534_62608 = state_62502__$1;
(statearr_62534_62608[(1)] = (8));

} else {
var statearr_62535_62609 = state_62502__$1;
(statearr_62535_62609[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (28))){
var inst_62446 = (state_62502[(8)]);
var inst_62388 = (state_62502[(10)]);
var inst_62450 = cljs.core._EQ_.call(null,inst_62388,inst_62446);
var state_62502__$1 = state_62502;
if(inst_62450){
var statearr_62536_62610 = state_62502__$1;
(statearr_62536_62610[(1)] = (30));

} else {
var statearr_62537_62611 = state_62502__$1;
(statearr_62537_62611[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (25))){
var state_62502__$1 = state_62502;
var statearr_62538_62612 = state_62502__$1;
(statearr_62538_62612[(2)] = null);

(statearr_62538_62612[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (34))){
var state_62502__$1 = state_62502;
var statearr_62539_62613 = state_62502__$1;
(statearr_62539_62613[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (17))){
var state_62502__$1 = state_62502;
var statearr_62541_62614 = state_62502__$1;
(statearr_62541_62614[(2)] = true);

(statearr_62541_62614[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (3))){
var inst_62500 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62502__$1,inst_62500);
} else {
if((state_val_62503 === (12))){
var inst_62390 = (state_62502[(19)]);
var state_62502__$1 = state_62502;
var statearr_62542_62615 = state_62502__$1;
(statearr_62542_62615[(2)] = inst_62390);

(statearr_62542_62615[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (2))){
var inst_62359 = (state_62502[(22)]);
var inst_62364 = (state_62502[(23)]);
var inst_62363 = (state_62502[(24)]);
var _ = (function (){var statearr_62543 = state_62502;
(statearr_62543[(4)] = cljs.core.cons.call(null,(5),(state_62502[(4)])));

return statearr_62543;
})();
var inst_62355 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_62356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62357 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_62358 = (new cljs.core.PersistentVector(null,2,(5),inst_62356,inst_62357,null));
var inst_62359__$1 = cljs.core.get_in.call(null,flureeQL,inst_62358);
var inst_62360 = (function (){var global_block = inst_62355;
var global_meta_QMARK_ = inst_62359__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_62361 = cljs.core.PersistentHashMap.EMPTY;
var inst_62362 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_62363__$1 = cljs.core.reduce_kv.call(null,inst_62360,inst_62361,inst_62362);
var inst_62364__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_62366 = (function (){var global_block = inst_62355;
var global_meta_QMARK_ = inst_62359__$1;
var queries = inst_62363__$1;
var start_time = inst_62364__$1;
return (function (p__62365){
var vec__62544 = p__62365;
var alias = cljs.core.nth.call(null,vec__62544,(0),null);
var q = cljs.core.nth.call(null,vec__62544,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_62367 = cljs.core.map.call(null,inst_62366,inst_62363__$1);
var inst_62381 = cljs.core.seq.call(null,inst_62367);
var inst_62382 = cljs.core.first.call(null,inst_62381);
var inst_62383 = cljs.core.next.call(null,inst_62381);
var inst_62384 = cljs.core.nth.call(null,inst_62382,(0),null);
var inst_62385 = cljs.core.nth.call(null,inst_62382,(1),null);
var inst_62386 = cljs.core.PersistentHashMap.EMPTY;
var inst_62387 = inst_62367;
var inst_62388 = null;
var inst_62389 = (0);
var inst_62390 = inst_62386;
var state_62502__$1 = (function (){var statearr_62547 = state_62502;
(statearr_62547[(25)] = inst_62385);

(statearr_62547[(26)] = inst_62383);

(statearr_62547[(19)] = inst_62390);

(statearr_62547[(27)] = inst_62384);

(statearr_62547[(22)] = inst_62359__$1);

(statearr_62547[(11)] = inst_62389);

(statearr_62547[(23)] = inst_62364__$1);

(statearr_62547[(10)] = inst_62388);

(statearr_62547[(20)] = inst_62387);

(statearr_62547[(24)] = inst_62363__$1);

return statearr_62547;
})();
var statearr_62548_62616 = state_62502__$1;
(statearr_62548_62616[(2)] = null);

(statearr_62548_62616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (23))){
var inst_62443 = (state_62502[(9)]);
var inst_62440 = (state_62502[(14)]);
var inst_62443__$1 = (state_62502[(2)]);
var inst_62444 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62443__$1);
var state_62502__$1 = (function (){var statearr_62549 = state_62502;
(statearr_62549[(9)] = inst_62443__$1);

(statearr_62549[(15)] = inst_62444);

return statearr_62549;
})();
if(cljs.core.truth_(inst_62440)){
var statearr_62550_62617 = state_62502__$1;
(statearr_62550_62617[(1)] = (24));

} else {
var statearr_62551_62618 = state_62502__$1;
(statearr_62551_62618[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (47))){
var inst_62390 = (state_62502[(19)]);
var inst_62401 = (state_62502[(21)]);
var inst_62489 = (state_62502[(2)]);
var inst_62490 = cljs.core.assoc.call(null,inst_62390,inst_62401,inst_62489);
var state_62502__$1 = state_62502;
var statearr_62552_62619 = state_62502__$1;
(statearr_62552_62619[(2)] = inst_62490);

(statearr_62552_62619[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (35))){
var inst_62465 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62553_62620 = state_62502__$1;
(statearr_62553_62620[(2)] = inst_62465);

(statearr_62553_62620[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (19))){
var inst_62431 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62554_62621 = state_62502__$1;
(statearr_62554_62621[(2)] = inst_62431);

(statearr_62554_62621[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (11))){
var inst_62390 = (state_62502[(19)]);
var inst_62389 = (state_62502[(11)]);
var inst_62364 = (state_62502[(23)]);
var inst_62388 = (state_62502[(10)]);
var inst_62406 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62407 = fluree.db.api.query.response_time_formatted.call(null,inst_62364);
var inst_62408 = [inst_62390,inst_62389,inst_62388,inst_62407];
var inst_62409 = cljs.core.PersistentHashMap.fromArrays(inst_62406,inst_62408);
var state_62502__$1 = state_62502;
var statearr_62556_62622 = state_62502__$1;
(statearr_62556_62622[(2)] = inst_62409);

(statearr_62556_62622[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (9))){
var inst_62418 = (state_62502[(7)]);
var inst_62401 = (state_62502[(21)]);
var inst_62363 = (state_62502[(24)]);
var inst_62415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62416 = [inst_62401,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62417 = (new cljs.core.PersistentVector(null,2,(5),inst_62415,inst_62416,null));
var inst_62418__$1 = cljs.core.get_in.call(null,inst_62363,inst_62417);
var inst_62420 = (inst_62418__$1 == null);
var inst_62421 = cljs.core.not.call(null,inst_62420);
var state_62502__$1 = (function (){var statearr_62557 = state_62502;
(statearr_62557[(7)] = inst_62418__$1);

return statearr_62557;
})();
if(inst_62421){
var statearr_62558_62623 = state_62502__$1;
(statearr_62558_62623[(1)] = (14));

} else {
var statearr_62559_62624 = state_62502__$1;
(statearr_62559_62624[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (5))){
var _ = (function (){var statearr_62560 = state_62502;
(statearr_62560[(4)] = cljs.core.rest.call(null,(state_62502[(4)])));

return statearr_62560;
})();
var state_62502__$1 = state_62502;
var ex62555 = (state_62502__$1[(2)]);
var statearr_62561_62625 = state_62502__$1;
(statearr_62561_62625[(5)] = ex62555);


var statearr_62562_62626 = state_62502__$1;
(statearr_62562_62626[(1)] = (4));

(statearr_62562_62626[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (14))){
var inst_62418 = (state_62502[(7)]);
var inst_62423 = inst_62418.cljs$lang$protocol_mask$partition0$;
var inst_62424 = (inst_62423 & (64));
var inst_62425 = inst_62418.cljs$core$ISeq$;
var inst_62426 = (cljs.core.PROTOCOL_SENTINEL === inst_62425);
var inst_62427 = ((inst_62424) || (inst_62426));
var state_62502__$1 = state_62502;
if(cljs.core.truth_(inst_62427)){
var statearr_62563_62627 = state_62502__$1;
(statearr_62563_62627[(1)] = (17));

} else {
var statearr_62564_62628 = state_62502__$1;
(statearr_62564_62628[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (45))){
var inst_62443 = (state_62502[(9)]);
var inst_62486 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62443);
var state_62502__$1 = state_62502;
var statearr_62565_62629 = state_62502__$1;
(statearr_62565_62629[(2)] = inst_62486);

(statearr_62565_62629[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (26))){
var inst_62440 = (state_62502[(14)]);
var inst_62472 = (state_62502[(2)]);
var state_62502__$1 = (function (){var statearr_62566 = state_62502;
(statearr_62566[(18)] = inst_62472);

return statearr_62566;
})();
if(cljs.core.truth_(inst_62440)){
var statearr_62567_62630 = state_62502__$1;
(statearr_62567_62630[(1)] = (39));

} else {
var statearr_62568_62631 = state_62502__$1;
(statearr_62568_62631[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (16))){
var inst_62434 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
if(cljs.core.truth_(inst_62434)){
var statearr_62569_62632 = state_62502__$1;
(statearr_62569_62632[(1)] = (20));

} else {
var statearr_62570_62633 = state_62502__$1;
(statearr_62570_62633[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (38))){
var inst_62463 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62571_62634 = state_62502__$1;
(statearr_62571_62634[(2)] = inst_62463);

(statearr_62571_62634[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (30))){
var inst_62446 = (state_62502[(8)]);
var state_62502__$1 = state_62502;
var statearr_62572_62635 = state_62502__$1;
(statearr_62572_62635[(2)] = inst_62446);

(statearr_62572_62635[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (10))){
var inst_62495 = (state_62502[(2)]);
var state_62502__$1 = state_62502;
var statearr_62573_62636 = state_62502__$1;
(statearr_62573_62636[(2)] = inst_62495);

(statearr_62573_62636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (18))){
var state_62502__$1 = state_62502;
var statearr_62574_62637 = state_62502__$1;
(statearr_62574_62637[(2)] = false);

(statearr_62574_62637[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (42))){
var inst_62443 = (state_62502[(9)]);
var inst_62390 = (state_62502[(19)]);
var inst_62401 = (state_62502[(21)]);
var inst_62480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62481 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62401];
var inst_62482 = (new cljs.core.PersistentVector(null,2,(5),inst_62480,inst_62481,null));
var inst_62483 = cljs.core.assoc_in.call(null,inst_62390,inst_62482,inst_62443);
var state_62502__$1 = state_62502;
var statearr_62575_62638 = state_62502__$1;
(statearr_62575_62638[(2)] = inst_62483);

(statearr_62575_62638[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (37))){
var state_62502__$1 = state_62502;
var statearr_62576_62639 = state_62502__$1;
(statearr_62576_62639[(2)] = null);

(statearr_62576_62639[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62503 === (8))){
var inst_62359 = (state_62502[(22)]);
var state_62502__$1 = state_62502;
if(cljs.core.truth_(inst_62359)){
var statearr_62577_62640 = state_62502__$1;
(statearr_62577_62640[(1)] = (11));

} else {
var statearr_62578_62641 = state_62502__$1;
(statearr_62578_62641[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_62579 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62579[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__);

(statearr_62579[(1)] = (1));

return statearr_62579;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1 = (function (state_62502){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62580){var ex__2882__auto__ = e62580;
var statearr_62581_62642 = state_62502;
(statearr_62581_62642[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62502[(4)]))){
var statearr_62582_62643 = state_62502;
(statearr_62582_62643[(1)] = cljs.core.first.call(null,(state_62502[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62644 = state_62502;
state_62502 = G__62644;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__ = function(state_62502){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1.call(this,state_62502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62583 = f__2902__auto__.call(null);
(statearr_62583[(6)] = c__2901__auto__);

return statearr_62583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__62645 = query_type;
var G__62645__$1 = (((G__62645 instanceof cljs.core.Keyword))?G__62645.fqn:null);
switch (G__62645__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62645__$1)].join('')));

}
});
