// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__3017 = arguments.length;
switch (G__3017) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3018 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3018 = (function (f,blockable,meta3019){
this.f = f;
this.blockable = blockable;
this.meta3019 = meta3019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3020,meta3019__$1){
var self__ = this;
var _3020__$1 = this;
return (new cljs.core.async.t_cljs$core$async3018(self__.f,self__.blockable,meta3019__$1));
}));

(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3020){
var self__ = this;
var _3020__$1 = this;
return self__.meta3019;
}));

(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async3018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async3018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta3019","meta3019",-1489713798,null)], null);
}));

(cljs.core.async.t_cljs$core$async3018.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3018");

(cljs.core.async.t_cljs$core$async3018.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3018");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3018.
 */
cljs.core.async.__GT_t_cljs$core$async3018 = (function cljs$core$async$__GT_t_cljs$core$async3018(f__$1,blockable__$1,meta3019){
return (new cljs.core.async.t_cljs$core$async3018(f__$1,blockable__$1,meta3019));
});

}

return (new cljs.core.async.t_cljs$core$async3018(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__3024 = arguments.length;
switch (G__3024) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__3027 = arguments.length;
switch (G__3027) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__3030 = arguments.length;
switch (G__3030) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_3032 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_3032);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_3032);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__3034 = arguments.length;
switch (G__3034) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___3036 = n;
var x_3037 = (0);
while(true){
if((x_3037 < n__4613__auto___3036)){
(a[x_3037] = x_3037);

var G__3038 = (x_3037 + (1));
x_3037 = G__3038;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3039 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3039 = (function (flag,meta3040){
this.flag = flag;
this.meta3040 = meta3040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3041,meta3040__$1){
var self__ = this;
var _3041__$1 = this;
return (new cljs.core.async.t_cljs$core$async3039(self__.flag,meta3040__$1));
}));

(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3041){
var self__ = this;
var _3041__$1 = this;
return self__.meta3040;
}));

(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3039.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async3039.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta3040","meta3040",-508752640,null)], null);
}));

(cljs.core.async.t_cljs$core$async3039.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3039");

(cljs.core.async.t_cljs$core$async3039.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3039");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3039.
 */
cljs.core.async.__GT_t_cljs$core$async3039 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async3039(flag__$1,meta3040){
return (new cljs.core.async.t_cljs$core$async3039(flag__$1,meta3040));
});

}

return (new cljs.core.async.t_cljs$core$async3039(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3042 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3042 = (function (flag,cb,meta3043){
this.flag = flag;
this.cb = cb;
this.meta3043 = meta3043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3044,meta3043__$1){
var self__ = this;
var _3044__$1 = this;
return (new cljs.core.async.t_cljs$core$async3042(self__.flag,self__.cb,meta3043__$1));
}));

(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3044){
var self__ = this;
var _3044__$1 = this;
return self__.meta3043;
}));

(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3042.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async3042.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta3043","meta3043",-938123499,null)], null);
}));

(cljs.core.async.t_cljs$core$async3042.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3042.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3042");

(cljs.core.async.t_cljs$core$async3042.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3042");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3042.
 */
cljs.core.async.__GT_t_cljs$core$async3042 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async3042(flag__$1,cb__$1,meta3043){
return (new cljs.core.async.t_cljs$core$async3042(flag__$1,cb__$1,meta3043));
});

}

return (new cljs.core.async.t_cljs$core$async3042(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3045_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3045_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3046_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3046_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__3047 = (i + (1));
i = G__3047;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3053 = arguments.length;
var i__4737__auto___3054 = (0);
while(true){
if((i__4737__auto___3054 < len__4736__auto___3053)){
args__4742__auto__.push((arguments[i__4737__auto___3054]));

var G__3055 = (i__4737__auto___3054 + (1));
i__4737__auto___3054 = G__3055;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__3050){
var map__3051 = p__3050;
var map__3051__$1 = (((((!((map__3051 == null))))?(((((map__3051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3051):map__3051);
var opts = map__3051__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq3048){
var G__3049 = cljs.core.first.call(null,seq3048);
var seq3048__$1 = cljs.core.next.call(null,seq3048);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3049,seq3048__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__3057 = arguments.length;
switch (G__3057) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__2957__auto___3104 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3081){
var state_val_3082 = (state_3081[(1)]);
if((state_val_3082 === (7))){
var inst_3077 = (state_3081[(2)]);
var state_3081__$1 = state_3081;
var statearr_3083_3105 = state_3081__$1;
(statearr_3083_3105[(2)] = inst_3077);

(statearr_3083_3105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (1))){
var state_3081__$1 = state_3081;
var statearr_3084_3106 = state_3081__$1;
(statearr_3084_3106[(2)] = null);

(statearr_3084_3106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (4))){
var inst_3060 = (state_3081[(7)]);
var inst_3060__$1 = (state_3081[(2)]);
var inst_3061 = (inst_3060__$1 == null);
var state_3081__$1 = (function (){var statearr_3085 = state_3081;
(statearr_3085[(7)] = inst_3060__$1);

return statearr_3085;
})();
if(cljs.core.truth_(inst_3061)){
var statearr_3086_3107 = state_3081__$1;
(statearr_3086_3107[(1)] = (5));

} else {
var statearr_3087_3108 = state_3081__$1;
(statearr_3087_3108[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (13))){
var state_3081__$1 = state_3081;
var statearr_3088_3109 = state_3081__$1;
(statearr_3088_3109[(2)] = null);

(statearr_3088_3109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (6))){
var inst_3060 = (state_3081[(7)]);
var state_3081__$1 = state_3081;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3081__$1,(11),to,inst_3060);
} else {
if((state_val_3082 === (3))){
var inst_3079 = (state_3081[(2)]);
var state_3081__$1 = state_3081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3081__$1,inst_3079);
} else {
if((state_val_3082 === (12))){
var state_3081__$1 = state_3081;
var statearr_3089_3110 = state_3081__$1;
(statearr_3089_3110[(2)] = null);

(statearr_3089_3110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (2))){
var state_3081__$1 = state_3081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3081__$1,(4),from);
} else {
if((state_val_3082 === (11))){
var inst_3070 = (state_3081[(2)]);
var state_3081__$1 = state_3081;
if(cljs.core.truth_(inst_3070)){
var statearr_3090_3111 = state_3081__$1;
(statearr_3090_3111[(1)] = (12));

} else {
var statearr_3091_3112 = state_3081__$1;
(statearr_3091_3112[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (9))){
var state_3081__$1 = state_3081;
var statearr_3092_3113 = state_3081__$1;
(statearr_3092_3113[(2)] = null);

(statearr_3092_3113[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (5))){
var state_3081__$1 = state_3081;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3093_3114 = state_3081__$1;
(statearr_3093_3114[(1)] = (8));

} else {
var statearr_3094_3115 = state_3081__$1;
(statearr_3094_3115[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (14))){
var inst_3075 = (state_3081[(2)]);
var state_3081__$1 = state_3081;
var statearr_3095_3116 = state_3081__$1;
(statearr_3095_3116[(2)] = inst_3075);

(statearr_3095_3116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (10))){
var inst_3067 = (state_3081[(2)]);
var state_3081__$1 = state_3081;
var statearr_3096_3117 = state_3081__$1;
(statearr_3096_3117[(2)] = inst_3067);

(statearr_3096_3117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3082 === (8))){
var inst_3064 = cljs.core.async.close_BANG_.call(null,to);
var state_3081__$1 = state_3081;
var statearr_3097_3118 = state_3081__$1;
(statearr_3097_3118[(2)] = inst_3064);

(statearr_3097_3118[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_3098 = [null,null,null,null,null,null,null,null];
(statearr_3098[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_3098[(1)] = (1));

return statearr_3098;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_3081){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3099){var ex__2887__auto__ = e3099;
var statearr_3100_3119 = state_3081;
(statearr_3100_3119[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3081[(4)]))){
var statearr_3101_3120 = state_3081;
(statearr_3101_3120[(1)] = cljs.core.first.call(null,(state_3081[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3121 = state_3081;
state_3081 = G__3121;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_3081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_3081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3102 = f__2958__auto__.call(null);
(statearr_3102[(6)] = c__2957__auto___3104);

return statearr_3102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__3122){
var vec__3123 = p__3122;
var v = cljs.core.nth.call(null,vec__3123,(0),null);
var p = cljs.core.nth.call(null,vec__3123,(1),null);
var job = vec__3123;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__2957__auto___3299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3130){
var state_val_3131 = (state_3130[(1)]);
if((state_val_3131 === (1))){
var state_3130__$1 = state_3130;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3130__$1,(2),res,v);
} else {
if((state_val_3131 === (2))){
var inst_3127 = (state_3130[(2)]);
var inst_3128 = cljs.core.async.close_BANG_.call(null,res);
var state_3130__$1 = (function (){var statearr_3132 = state_3130;
(statearr_3132[(7)] = inst_3127);

return statearr_3132;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3130__$1,inst_3128);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_3133 = [null,null,null,null,null,null,null,null];
(statearr_3133[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__);

(statearr_3133[(1)] = (1));

return statearr_3133;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1 = (function (state_3130){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3134){var ex__2887__auto__ = e3134;
var statearr_3135_3300 = state_3130;
(statearr_3135_3300[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3130[(4)]))){
var statearr_3136_3301 = state_3130;
(statearr_3136_3301[(1)] = cljs.core.first.call(null,(state_3130[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3302 = state_3130;
state_3130 = G__3302;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = function(state_3130){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1.call(this,state_3130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3137 = f__2958__auto__.call(null);
(statearr_3137[(6)] = c__2957__auto___3299);

return statearr_3137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__3138){
var vec__3139 = p__3138;
var v = cljs.core.nth.call(null,vec__3139,(0),null);
var p = cljs.core.nth.call(null,vec__3139,(1),null);
var job = vec__3139;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___3303 = n;
var __3304 = (0);
while(true){
if((__3304 < n__4613__auto___3303)){
var G__3142_3305 = type;
var G__3142_3306__$1 = (((G__3142_3305 instanceof cljs.core.Keyword))?G__3142_3305.fqn:null);
switch (G__3142_3306__$1) {
case "compute":
var c__2957__auto___3308 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3304,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = ((function (__3304,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function (state_3155){
var state_val_3156 = (state_3155[(1)]);
if((state_val_3156 === (1))){
var state_3155__$1 = state_3155;
var statearr_3157_3309 = state_3155__$1;
(statearr_3157_3309[(2)] = null);

(statearr_3157_3309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3156 === (2))){
var state_3155__$1 = state_3155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3155__$1,(4),jobs);
} else {
if((state_val_3156 === (3))){
var inst_3153 = (state_3155[(2)]);
var state_3155__$1 = state_3155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3155__$1,inst_3153);
} else {
if((state_val_3156 === (4))){
var inst_3145 = (state_3155[(2)]);
var inst_3146 = process.call(null,inst_3145);
var state_3155__$1 = state_3155;
if(cljs.core.truth_(inst_3146)){
var statearr_3158_3310 = state_3155__$1;
(statearr_3158_3310[(1)] = (5));

} else {
var statearr_3159_3311 = state_3155__$1;
(statearr_3159_3311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3156 === (5))){
var state_3155__$1 = state_3155;
var statearr_3160_3312 = state_3155__$1;
(statearr_3160_3312[(2)] = null);

(statearr_3160_3312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3156 === (6))){
var state_3155__$1 = state_3155;
var statearr_3161_3313 = state_3155__$1;
(statearr_3161_3313[(2)] = null);

(statearr_3161_3313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3156 === (7))){
var inst_3151 = (state_3155[(2)]);
var state_3155__$1 = state_3155;
var statearr_3162_3314 = state_3155__$1;
(statearr_3162_3314[(2)] = inst_3151);

(statearr_3162_3314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3304,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
;
return ((function (__3304,switch__2883__auto__,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_3163 = [null,null,null,null,null,null,null];
(statearr_3163[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__);

(statearr_3163[(1)] = (1));

return statearr_3163;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1 = (function (state_3155){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3164){var ex__2887__auto__ = e3164;
var statearr_3165_3315 = state_3155;
(statearr_3165_3315[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3155[(4)]))){
var statearr_3166_3316 = state_3155;
(statearr_3166_3316[(1)] = cljs.core.first.call(null,(state_3155[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3317 = state_3155;
state_3155 = G__3317;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = function(state_3155){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1.call(this,state_3155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__;
})()
;})(__3304,switch__2883__auto__,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
})();
var state__2959__auto__ = (function (){var statearr_3167 = f__2958__auto__.call(null);
(statearr_3167[(6)] = c__2957__auto___3308);

return statearr_3167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
});})(__3304,c__2957__auto___3308,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
);


break;
case "async":
var c__2957__auto___3318 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3304,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = ((function (__3304,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function (state_3180){
var state_val_3181 = (state_3180[(1)]);
if((state_val_3181 === (1))){
var state_3180__$1 = state_3180;
var statearr_3182_3319 = state_3180__$1;
(statearr_3182_3319[(2)] = null);

(statearr_3182_3319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3181 === (2))){
var state_3180__$1 = state_3180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3180__$1,(4),jobs);
} else {
if((state_val_3181 === (3))){
var inst_3178 = (state_3180[(2)]);
var state_3180__$1 = state_3180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3180__$1,inst_3178);
} else {
if((state_val_3181 === (4))){
var inst_3170 = (state_3180[(2)]);
var inst_3171 = async.call(null,inst_3170);
var state_3180__$1 = state_3180;
if(cljs.core.truth_(inst_3171)){
var statearr_3183_3320 = state_3180__$1;
(statearr_3183_3320[(1)] = (5));

} else {
var statearr_3184_3321 = state_3180__$1;
(statearr_3184_3321[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3181 === (5))){
var state_3180__$1 = state_3180;
var statearr_3185_3322 = state_3180__$1;
(statearr_3185_3322[(2)] = null);

(statearr_3185_3322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3181 === (6))){
var state_3180__$1 = state_3180;
var statearr_3186_3323 = state_3180__$1;
(statearr_3186_3323[(2)] = null);

(statearr_3186_3323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3181 === (7))){
var inst_3176 = (state_3180[(2)]);
var state_3180__$1 = state_3180;
var statearr_3187_3324 = state_3180__$1;
(statearr_3187_3324[(2)] = inst_3176);

(statearr_3187_3324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3304,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
;
return ((function (__3304,switch__2883__auto__,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_3188 = [null,null,null,null,null,null,null];
(statearr_3188[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__);

(statearr_3188[(1)] = (1));

return statearr_3188;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1 = (function (state_3180){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3189){var ex__2887__auto__ = e3189;
var statearr_3190_3325 = state_3180;
(statearr_3190_3325[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3180[(4)]))){
var statearr_3191_3326 = state_3180;
(statearr_3191_3326[(1)] = cljs.core.first.call(null,(state_3180[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3327 = state_3180;
state_3180 = G__3327;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = function(state_3180){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1.call(this,state_3180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__;
})()
;})(__3304,switch__2883__auto__,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
})();
var state__2959__auto__ = (function (){var statearr_3192 = f__2958__auto__.call(null);
(statearr_3192[(6)] = c__2957__auto___3318);

return statearr_3192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
});})(__3304,c__2957__auto___3318,G__3142_3305,G__3142_3306__$1,n__4613__auto___3303,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3142_3306__$1)].join('')));

}

var G__3328 = (__3304 + (1));
__3304 = G__3328;
continue;
} else {
}
break;
}

var c__2957__auto___3329 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3214){
var state_val_3215 = (state_3214[(1)]);
if((state_val_3215 === (7))){
var inst_3210 = (state_3214[(2)]);
var state_3214__$1 = state_3214;
var statearr_3216_3330 = state_3214__$1;
(statearr_3216_3330[(2)] = inst_3210);

(statearr_3216_3330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3215 === (1))){
var state_3214__$1 = state_3214;
var statearr_3217_3331 = state_3214__$1;
(statearr_3217_3331[(2)] = null);

(statearr_3217_3331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3215 === (4))){
var inst_3195 = (state_3214[(7)]);
var inst_3195__$1 = (state_3214[(2)]);
var inst_3196 = (inst_3195__$1 == null);
var state_3214__$1 = (function (){var statearr_3218 = state_3214;
(statearr_3218[(7)] = inst_3195__$1);

return statearr_3218;
})();
if(cljs.core.truth_(inst_3196)){
var statearr_3219_3332 = state_3214__$1;
(statearr_3219_3332[(1)] = (5));

} else {
var statearr_3220_3333 = state_3214__$1;
(statearr_3220_3333[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3215 === (6))){
var inst_3200 = (state_3214[(8)]);
var inst_3195 = (state_3214[(7)]);
var inst_3200__$1 = cljs.core.async.chan.call(null,(1));
var inst_3201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_3202 = [inst_3195,inst_3200__$1];
var inst_3203 = (new cljs.core.PersistentVector(null,2,(5),inst_3201,inst_3202,null));
var state_3214__$1 = (function (){var statearr_3221 = state_3214;
(statearr_3221[(8)] = inst_3200__$1);

return statearr_3221;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3214__$1,(8),jobs,inst_3203);
} else {
if((state_val_3215 === (3))){
var inst_3212 = (state_3214[(2)]);
var state_3214__$1 = state_3214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3214__$1,inst_3212);
} else {
if((state_val_3215 === (2))){
var state_3214__$1 = state_3214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3214__$1,(4),from);
} else {
if((state_val_3215 === (9))){
var inst_3207 = (state_3214[(2)]);
var state_3214__$1 = (function (){var statearr_3222 = state_3214;
(statearr_3222[(9)] = inst_3207);

return statearr_3222;
})();
var statearr_3223_3334 = state_3214__$1;
(statearr_3223_3334[(2)] = null);

(statearr_3223_3334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3215 === (5))){
var inst_3198 = cljs.core.async.close_BANG_.call(null,jobs);
var state_3214__$1 = state_3214;
var statearr_3224_3335 = state_3214__$1;
(statearr_3224_3335[(2)] = inst_3198);

(statearr_3224_3335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3215 === (8))){
var inst_3200 = (state_3214[(8)]);
var inst_3205 = (state_3214[(2)]);
var state_3214__$1 = (function (){var statearr_3225 = state_3214;
(statearr_3225[(10)] = inst_3205);

return statearr_3225;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3214__$1,(9),results,inst_3200);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_3226 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3226[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__);

(statearr_3226[(1)] = (1));

return statearr_3226;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1 = (function (state_3214){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3227){var ex__2887__auto__ = e3227;
var statearr_3228_3336 = state_3214;
(statearr_3228_3336[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3214[(4)]))){
var statearr_3229_3337 = state_3214;
(statearr_3229_3337[(1)] = cljs.core.first.call(null,(state_3214[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3338 = state_3214;
state_3214 = G__3338;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = function(state_3214){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1.call(this,state_3214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3230 = f__2958__auto__.call(null);
(statearr_3230[(6)] = c__2957__auto___3329);

return statearr_3230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


var c__2957__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3268){
var state_val_3269 = (state_3268[(1)]);
if((state_val_3269 === (7))){
var inst_3264 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
var statearr_3270_3339 = state_3268__$1;
(statearr_3270_3339[(2)] = inst_3264);

(statearr_3270_3339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (20))){
var state_3268__$1 = state_3268;
var statearr_3271_3340 = state_3268__$1;
(statearr_3271_3340[(2)] = null);

(statearr_3271_3340[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (1))){
var state_3268__$1 = state_3268;
var statearr_3272_3341 = state_3268__$1;
(statearr_3272_3341[(2)] = null);

(statearr_3272_3341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (4))){
var inst_3233 = (state_3268[(7)]);
var inst_3233__$1 = (state_3268[(2)]);
var inst_3234 = (inst_3233__$1 == null);
var state_3268__$1 = (function (){var statearr_3273 = state_3268;
(statearr_3273[(7)] = inst_3233__$1);

return statearr_3273;
})();
if(cljs.core.truth_(inst_3234)){
var statearr_3274_3342 = state_3268__$1;
(statearr_3274_3342[(1)] = (5));

} else {
var statearr_3275_3343 = state_3268__$1;
(statearr_3275_3343[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (15))){
var inst_3246 = (state_3268[(8)]);
var state_3268__$1 = state_3268;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3268__$1,(18),to,inst_3246);
} else {
if((state_val_3269 === (21))){
var inst_3259 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
var statearr_3276_3344 = state_3268__$1;
(statearr_3276_3344[(2)] = inst_3259);

(statearr_3276_3344[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (13))){
var inst_3261 = (state_3268[(2)]);
var state_3268__$1 = (function (){var statearr_3277 = state_3268;
(statearr_3277[(9)] = inst_3261);

return statearr_3277;
})();
var statearr_3278_3345 = state_3268__$1;
(statearr_3278_3345[(2)] = null);

(statearr_3278_3345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (6))){
var inst_3233 = (state_3268[(7)]);
var state_3268__$1 = state_3268;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3268__$1,(11),inst_3233);
} else {
if((state_val_3269 === (17))){
var inst_3254 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
if(cljs.core.truth_(inst_3254)){
var statearr_3279_3346 = state_3268__$1;
(statearr_3279_3346[(1)] = (19));

} else {
var statearr_3280_3347 = state_3268__$1;
(statearr_3280_3347[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (3))){
var inst_3266 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3268__$1,inst_3266);
} else {
if((state_val_3269 === (12))){
var inst_3243 = (state_3268[(10)]);
var state_3268__$1 = state_3268;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3268__$1,(14),inst_3243);
} else {
if((state_val_3269 === (2))){
var state_3268__$1 = state_3268;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3268__$1,(4),results);
} else {
if((state_val_3269 === (19))){
var state_3268__$1 = state_3268;
var statearr_3281_3348 = state_3268__$1;
(statearr_3281_3348[(2)] = null);

(statearr_3281_3348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (11))){
var inst_3243 = (state_3268[(2)]);
var state_3268__$1 = (function (){var statearr_3282 = state_3268;
(statearr_3282[(10)] = inst_3243);

return statearr_3282;
})();
var statearr_3283_3349 = state_3268__$1;
(statearr_3283_3349[(2)] = null);

(statearr_3283_3349[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (9))){
var state_3268__$1 = state_3268;
var statearr_3284_3350 = state_3268__$1;
(statearr_3284_3350[(2)] = null);

(statearr_3284_3350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (5))){
var state_3268__$1 = state_3268;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3285_3351 = state_3268__$1;
(statearr_3285_3351[(1)] = (8));

} else {
var statearr_3286_3352 = state_3268__$1;
(statearr_3286_3352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (14))){
var inst_3246 = (state_3268[(8)]);
var inst_3246__$1 = (state_3268[(2)]);
var inst_3247 = (inst_3246__$1 == null);
var inst_3248 = cljs.core.not.call(null,inst_3247);
var state_3268__$1 = (function (){var statearr_3287 = state_3268;
(statearr_3287[(8)] = inst_3246__$1);

return statearr_3287;
})();
if(inst_3248){
var statearr_3288_3353 = state_3268__$1;
(statearr_3288_3353[(1)] = (15));

} else {
var statearr_3289_3354 = state_3268__$1;
(statearr_3289_3354[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (16))){
var state_3268__$1 = state_3268;
var statearr_3290_3355 = state_3268__$1;
(statearr_3290_3355[(2)] = false);

(statearr_3290_3355[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (10))){
var inst_3240 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
var statearr_3291_3356 = state_3268__$1;
(statearr_3291_3356[(2)] = inst_3240);

(statearr_3291_3356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (18))){
var inst_3251 = (state_3268[(2)]);
var state_3268__$1 = state_3268;
var statearr_3292_3357 = state_3268__$1;
(statearr_3292_3357[(2)] = inst_3251);

(statearr_3292_3357[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3269 === (8))){
var inst_3237 = cljs.core.async.close_BANG_.call(null,to);
var state_3268__$1 = state_3268;
var statearr_3293_3358 = state_3268__$1;
(statearr_3293_3358[(2)] = inst_3237);

(statearr_3293_3358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_3294 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3294[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__);

(statearr_3294[(1)] = (1));

return statearr_3294;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1 = (function (state_3268){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3268);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3295){var ex__2887__auto__ = e3295;
var statearr_3296_3359 = state_3268;
(statearr_3296_3359[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3268[(4)]))){
var statearr_3297_3360 = state_3268;
(statearr_3297_3360[(1)] = cljs.core.first.call(null,(state_3268[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3361 = state_3268;
state_3268 = G__3361;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__ = function(state_3268){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1.call(this,state_3268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3298 = f__2958__auto__.call(null);
(statearr_3298[(6)] = c__2957__auto__);

return statearr_3298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));

return c__2957__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__3363 = arguments.length;
switch (G__3363) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__3366 = arguments.length;
switch (G__3366) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__3369 = arguments.length;
switch (G__3369) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__2957__auto___3419 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3395){
var state_val_3396 = (state_3395[(1)]);
if((state_val_3396 === (7))){
var inst_3391 = (state_3395[(2)]);
var state_3395__$1 = state_3395;
var statearr_3397_3420 = state_3395__$1;
(statearr_3397_3420[(2)] = inst_3391);

(statearr_3397_3420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (1))){
var state_3395__$1 = state_3395;
var statearr_3398_3421 = state_3395__$1;
(statearr_3398_3421[(2)] = null);

(statearr_3398_3421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (4))){
var inst_3372 = (state_3395[(7)]);
var inst_3372__$1 = (state_3395[(2)]);
var inst_3373 = (inst_3372__$1 == null);
var state_3395__$1 = (function (){var statearr_3399 = state_3395;
(statearr_3399[(7)] = inst_3372__$1);

return statearr_3399;
})();
if(cljs.core.truth_(inst_3373)){
var statearr_3400_3422 = state_3395__$1;
(statearr_3400_3422[(1)] = (5));

} else {
var statearr_3401_3423 = state_3395__$1;
(statearr_3401_3423[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (13))){
var state_3395__$1 = state_3395;
var statearr_3402_3424 = state_3395__$1;
(statearr_3402_3424[(2)] = null);

(statearr_3402_3424[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (6))){
var inst_3372 = (state_3395[(7)]);
var inst_3378 = p.call(null,inst_3372);
var state_3395__$1 = state_3395;
if(cljs.core.truth_(inst_3378)){
var statearr_3403_3425 = state_3395__$1;
(statearr_3403_3425[(1)] = (9));

} else {
var statearr_3404_3426 = state_3395__$1;
(statearr_3404_3426[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (3))){
var inst_3393 = (state_3395[(2)]);
var state_3395__$1 = state_3395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3395__$1,inst_3393);
} else {
if((state_val_3396 === (12))){
var state_3395__$1 = state_3395;
var statearr_3405_3427 = state_3395__$1;
(statearr_3405_3427[(2)] = null);

(statearr_3405_3427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (2))){
var state_3395__$1 = state_3395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3395__$1,(4),ch);
} else {
if((state_val_3396 === (11))){
var inst_3372 = (state_3395[(7)]);
var inst_3382 = (state_3395[(2)]);
var state_3395__$1 = state_3395;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3395__$1,(8),inst_3382,inst_3372);
} else {
if((state_val_3396 === (9))){
var state_3395__$1 = state_3395;
var statearr_3406_3428 = state_3395__$1;
(statearr_3406_3428[(2)] = tc);

(statearr_3406_3428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (5))){
var inst_3375 = cljs.core.async.close_BANG_.call(null,tc);
var inst_3376 = cljs.core.async.close_BANG_.call(null,fc);
var state_3395__$1 = (function (){var statearr_3407 = state_3395;
(statearr_3407[(8)] = inst_3375);

return statearr_3407;
})();
var statearr_3408_3429 = state_3395__$1;
(statearr_3408_3429[(2)] = inst_3376);

(statearr_3408_3429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (14))){
var inst_3389 = (state_3395[(2)]);
var state_3395__$1 = state_3395;
var statearr_3409_3430 = state_3395__$1;
(statearr_3409_3430[(2)] = inst_3389);

(statearr_3409_3430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (10))){
var state_3395__$1 = state_3395;
var statearr_3410_3431 = state_3395__$1;
(statearr_3410_3431[(2)] = fc);

(statearr_3410_3431[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3396 === (8))){
var inst_3384 = (state_3395[(2)]);
var state_3395__$1 = state_3395;
if(cljs.core.truth_(inst_3384)){
var statearr_3411_3432 = state_3395__$1;
(statearr_3411_3432[(1)] = (12));

} else {
var statearr_3412_3433 = state_3395__$1;
(statearr_3412_3433[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_3413 = [null,null,null,null,null,null,null,null,null];
(statearr_3413[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_3413[(1)] = (1));

return statearr_3413;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_3395){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3414){var ex__2887__auto__ = e3414;
var statearr_3415_3434 = state_3395;
(statearr_3415_3434[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3395[(4)]))){
var statearr_3416_3435 = state_3395;
(statearr_3416_3435[(1)] = cljs.core.first.call(null,(state_3395[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3436 = state_3395;
state_3395 = G__3436;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_3395){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_3395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3417 = f__2958__auto__.call(null);
(statearr_3417[(6)] = c__2957__auto___3419);

return statearr_3417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__2957__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3458){
var state_val_3459 = (state_3458[(1)]);
if((state_val_3459 === (7))){
var inst_3454 = (state_3458[(2)]);
var state_3458__$1 = state_3458;
var statearr_3460_3479 = state_3458__$1;
(statearr_3460_3479[(2)] = inst_3454);

(statearr_3460_3479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (1))){
var inst_3437 = init;
var inst_3438 = inst_3437;
var state_3458__$1 = (function (){var statearr_3461 = state_3458;
(statearr_3461[(7)] = inst_3438);

return statearr_3461;
})();
var statearr_3462_3480 = state_3458__$1;
(statearr_3462_3480[(2)] = null);

(statearr_3462_3480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (4))){
var inst_3441 = (state_3458[(8)]);
var inst_3441__$1 = (state_3458[(2)]);
var inst_3442 = (inst_3441__$1 == null);
var state_3458__$1 = (function (){var statearr_3463 = state_3458;
(statearr_3463[(8)] = inst_3441__$1);

return statearr_3463;
})();
if(cljs.core.truth_(inst_3442)){
var statearr_3464_3481 = state_3458__$1;
(statearr_3464_3481[(1)] = (5));

} else {
var statearr_3465_3482 = state_3458__$1;
(statearr_3465_3482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (6))){
var inst_3438 = (state_3458[(7)]);
var inst_3445 = (state_3458[(9)]);
var inst_3441 = (state_3458[(8)]);
var inst_3445__$1 = f.call(null,inst_3438,inst_3441);
var inst_3446 = cljs.core.reduced_QMARK_.call(null,inst_3445__$1);
var state_3458__$1 = (function (){var statearr_3466 = state_3458;
(statearr_3466[(9)] = inst_3445__$1);

return statearr_3466;
})();
if(inst_3446){
var statearr_3467_3483 = state_3458__$1;
(statearr_3467_3483[(1)] = (8));

} else {
var statearr_3468_3484 = state_3458__$1;
(statearr_3468_3484[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (3))){
var inst_3456 = (state_3458[(2)]);
var state_3458__$1 = state_3458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3458__$1,inst_3456);
} else {
if((state_val_3459 === (2))){
var state_3458__$1 = state_3458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3458__$1,(4),ch);
} else {
if((state_val_3459 === (9))){
var inst_3445 = (state_3458[(9)]);
var inst_3438 = inst_3445;
var state_3458__$1 = (function (){var statearr_3469 = state_3458;
(statearr_3469[(7)] = inst_3438);

return statearr_3469;
})();
var statearr_3470_3485 = state_3458__$1;
(statearr_3470_3485[(2)] = null);

(statearr_3470_3485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (5))){
var inst_3438 = (state_3458[(7)]);
var state_3458__$1 = state_3458;
var statearr_3471_3486 = state_3458__$1;
(statearr_3471_3486[(2)] = inst_3438);

(statearr_3471_3486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (10))){
var inst_3452 = (state_3458[(2)]);
var state_3458__$1 = state_3458;
var statearr_3472_3487 = state_3458__$1;
(statearr_3472_3487[(2)] = inst_3452);

(statearr_3472_3487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3459 === (8))){
var inst_3445 = (state_3458[(9)]);
var inst_3448 = cljs.core.deref.call(null,inst_3445);
var state_3458__$1 = state_3458;
var statearr_3473_3488 = state_3458__$1;
(statearr_3473_3488[(2)] = inst_3448);

(statearr_3473_3488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__2884__auto__ = null;
var cljs$core$async$reduce_$_state_machine__2884__auto____0 = (function (){
var statearr_3474 = [null,null,null,null,null,null,null,null,null,null];
(statearr_3474[(0)] = cljs$core$async$reduce_$_state_machine__2884__auto__);

(statearr_3474[(1)] = (1));

return statearr_3474;
});
var cljs$core$async$reduce_$_state_machine__2884__auto____1 = (function (state_3458){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3475){var ex__2887__auto__ = e3475;
var statearr_3476_3489 = state_3458;
(statearr_3476_3489[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3458[(4)]))){
var statearr_3477_3490 = state_3458;
(statearr_3477_3490[(1)] = cljs.core.first.call(null,(state_3458[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3491 = state_3458;
state_3458 = G__3491;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__2884__auto__ = function(state_3458){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__2884__auto____1.call(this,state_3458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__2884__auto____0;
cljs$core$async$reduce_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__2884__auto____1;
return cljs$core$async$reduce_$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3478 = f__2958__auto__.call(null);
(statearr_3478[(6)] = c__2957__auto__);

return statearr_3478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));

return c__2957__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__2957__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3497){
var state_val_3498 = (state_3497[(1)]);
if((state_val_3498 === (1))){
var inst_3492 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_3497__$1 = state_3497;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3497__$1,(2),inst_3492);
} else {
if((state_val_3498 === (2))){
var inst_3494 = (state_3497[(2)]);
var inst_3495 = f__$1.call(null,inst_3494);
var state_3497__$1 = state_3497;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3497__$1,inst_3495);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__2884__auto__ = null;
var cljs$core$async$transduce_$_state_machine__2884__auto____0 = (function (){
var statearr_3499 = [null,null,null,null,null,null,null];
(statearr_3499[(0)] = cljs$core$async$transduce_$_state_machine__2884__auto__);

(statearr_3499[(1)] = (1));

return statearr_3499;
});
var cljs$core$async$transduce_$_state_machine__2884__auto____1 = (function (state_3497){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3497);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3500){var ex__2887__auto__ = e3500;
var statearr_3501_3504 = state_3497;
(statearr_3501_3504[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3497[(4)]))){
var statearr_3502_3505 = state_3497;
(statearr_3502_3505[(1)] = cljs.core.first.call(null,(state_3497[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3506 = state_3497;
state_3497 = G__3506;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__2884__auto__ = function(state_3497){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__2884__auto____1.call(this,state_3497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__2884__auto____0;
cljs$core$async$transduce_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__2884__auto____1;
return cljs$core$async$transduce_$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3503 = f__2958__auto__.call(null);
(statearr_3503[(6)] = c__2957__auto__);

return statearr_3503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));

return c__2957__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__3508 = arguments.length;
switch (G__3508) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__2957__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3533){
var state_val_3534 = (state_3533[(1)]);
if((state_val_3534 === (7))){
var inst_3515 = (state_3533[(2)]);
var state_3533__$1 = state_3533;
var statearr_3535_3557 = state_3533__$1;
(statearr_3535_3557[(2)] = inst_3515);

(statearr_3535_3557[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (1))){
var inst_3509 = cljs.core.seq.call(null,coll);
var inst_3510 = inst_3509;
var state_3533__$1 = (function (){var statearr_3536 = state_3533;
(statearr_3536[(7)] = inst_3510);

return statearr_3536;
})();
var statearr_3537_3558 = state_3533__$1;
(statearr_3537_3558[(2)] = null);

(statearr_3537_3558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (4))){
var inst_3510 = (state_3533[(7)]);
var inst_3513 = cljs.core.first.call(null,inst_3510);
var state_3533__$1 = state_3533;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3533__$1,(7),ch,inst_3513);
} else {
if((state_val_3534 === (13))){
var inst_3527 = (state_3533[(2)]);
var state_3533__$1 = state_3533;
var statearr_3538_3559 = state_3533__$1;
(statearr_3538_3559[(2)] = inst_3527);

(statearr_3538_3559[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (6))){
var inst_3518 = (state_3533[(2)]);
var state_3533__$1 = state_3533;
if(cljs.core.truth_(inst_3518)){
var statearr_3539_3560 = state_3533__$1;
(statearr_3539_3560[(1)] = (8));

} else {
var statearr_3540_3561 = state_3533__$1;
(statearr_3540_3561[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (3))){
var inst_3531 = (state_3533[(2)]);
var state_3533__$1 = state_3533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3533__$1,inst_3531);
} else {
if((state_val_3534 === (12))){
var state_3533__$1 = state_3533;
var statearr_3541_3562 = state_3533__$1;
(statearr_3541_3562[(2)] = null);

(statearr_3541_3562[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (2))){
var inst_3510 = (state_3533[(7)]);
var state_3533__$1 = state_3533;
if(cljs.core.truth_(inst_3510)){
var statearr_3542_3563 = state_3533__$1;
(statearr_3542_3563[(1)] = (4));

} else {
var statearr_3543_3564 = state_3533__$1;
(statearr_3543_3564[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (11))){
var inst_3524 = cljs.core.async.close_BANG_.call(null,ch);
var state_3533__$1 = state_3533;
var statearr_3544_3565 = state_3533__$1;
(statearr_3544_3565[(2)] = inst_3524);

(statearr_3544_3565[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (9))){
var state_3533__$1 = state_3533;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3545_3566 = state_3533__$1;
(statearr_3545_3566[(1)] = (11));

} else {
var statearr_3546_3567 = state_3533__$1;
(statearr_3546_3567[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (5))){
var inst_3510 = (state_3533[(7)]);
var state_3533__$1 = state_3533;
var statearr_3547_3568 = state_3533__$1;
(statearr_3547_3568[(2)] = inst_3510);

(statearr_3547_3568[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (10))){
var inst_3529 = (state_3533[(2)]);
var state_3533__$1 = state_3533;
var statearr_3548_3569 = state_3533__$1;
(statearr_3548_3569[(2)] = inst_3529);

(statearr_3548_3569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3534 === (8))){
var inst_3510 = (state_3533[(7)]);
var inst_3520 = cljs.core.next.call(null,inst_3510);
var inst_3510__$1 = inst_3520;
var state_3533__$1 = (function (){var statearr_3549 = state_3533;
(statearr_3549[(7)] = inst_3510__$1);

return statearr_3549;
})();
var statearr_3550_3570 = state_3533__$1;
(statearr_3550_3570[(2)] = null);

(statearr_3550_3570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_3551 = [null,null,null,null,null,null,null,null];
(statearr_3551[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_3551[(1)] = (1));

return statearr_3551;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_3533){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3552){var ex__2887__auto__ = e3552;
var statearr_3553_3571 = state_3533;
(statearr_3553_3571[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3533[(4)]))){
var statearr_3554_3572 = state_3533;
(statearr_3554_3572[(1)] = cljs.core.first.call(null,(state_3533[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3573 = state_3533;
state_3533 = G__3573;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_3533){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_3533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3555 = f__2958__auto__.call(null);
(statearr_3555[(6)] = c__2957__auto__);

return statearr_3555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));

return c__2957__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__3575 = arguments.length;
switch (G__3575) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_3577 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_3577.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_3578 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_3578.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_3579 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_3579.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_3580 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_3580.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3581 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3581 = (function (ch,cs,meta3582){
this.ch = ch;
this.cs = cs;
this.meta3582 = meta3582;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3583,meta3582__$1){
var self__ = this;
var _3583__$1 = this;
return (new cljs.core.async.t_cljs$core$async3581(self__.ch,self__.cs,meta3582__$1));
}));

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3583){
var self__ = this;
var _3583__$1 = this;
return self__.meta3582;
}));

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async3581.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async3581.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta3582","meta3582",1042584891,null)], null);
}));

(cljs.core.async.t_cljs$core$async3581.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3581.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3581");

(cljs.core.async.t_cljs$core$async3581.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3581");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3581.
 */
cljs.core.async.__GT_t_cljs$core$async3581 = (function cljs$core$async$mult_$___GT_t_cljs$core$async3581(ch__$1,cs__$1,meta3582){
return (new cljs.core.async.t_cljs$core$async3581(ch__$1,cs__$1,meta3582));
});

}

return (new cljs.core.async.t_cljs$core$async3581(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__2957__auto___3800 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3716){
var state_val_3717 = (state_3716[(1)]);
if((state_val_3717 === (7))){
var inst_3712 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3718_3801 = state_3716__$1;
(statearr_3718_3801[(2)] = inst_3712);

(statearr_3718_3801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (20))){
var inst_3617 = (state_3716[(7)]);
var inst_3629 = cljs.core.first.call(null,inst_3617);
var inst_3630 = cljs.core.nth.call(null,inst_3629,(0),null);
var inst_3631 = cljs.core.nth.call(null,inst_3629,(1),null);
var state_3716__$1 = (function (){var statearr_3719 = state_3716;
(statearr_3719[(8)] = inst_3630);

return statearr_3719;
})();
if(cljs.core.truth_(inst_3631)){
var statearr_3720_3802 = state_3716__$1;
(statearr_3720_3802[(1)] = (22));

} else {
var statearr_3721_3803 = state_3716__$1;
(statearr_3721_3803[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (27))){
var inst_3586 = (state_3716[(9)]);
var inst_3666 = (state_3716[(10)]);
var inst_3661 = (state_3716[(11)]);
var inst_3659 = (state_3716[(12)]);
var inst_3666__$1 = cljs.core._nth.call(null,inst_3659,inst_3661);
var inst_3667 = cljs.core.async.put_BANG_.call(null,inst_3666__$1,inst_3586,done);
var state_3716__$1 = (function (){var statearr_3722 = state_3716;
(statearr_3722[(10)] = inst_3666__$1);

return statearr_3722;
})();
if(cljs.core.truth_(inst_3667)){
var statearr_3723_3804 = state_3716__$1;
(statearr_3723_3804[(1)] = (30));

} else {
var statearr_3724_3805 = state_3716__$1;
(statearr_3724_3805[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (1))){
var state_3716__$1 = state_3716;
var statearr_3725_3806 = state_3716__$1;
(statearr_3725_3806[(2)] = null);

(statearr_3725_3806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (24))){
var inst_3617 = (state_3716[(7)]);
var inst_3636 = (state_3716[(2)]);
var inst_3637 = cljs.core.next.call(null,inst_3617);
var inst_3595 = inst_3637;
var inst_3596 = null;
var inst_3597 = (0);
var inst_3598 = (0);
var state_3716__$1 = (function (){var statearr_3726 = state_3716;
(statearr_3726[(13)] = inst_3636);

(statearr_3726[(14)] = inst_3596);

(statearr_3726[(15)] = inst_3595);

(statearr_3726[(16)] = inst_3598);

(statearr_3726[(17)] = inst_3597);

return statearr_3726;
})();
var statearr_3727_3807 = state_3716__$1;
(statearr_3727_3807[(2)] = null);

(statearr_3727_3807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (39))){
var state_3716__$1 = state_3716;
var statearr_3731_3808 = state_3716__$1;
(statearr_3731_3808[(2)] = null);

(statearr_3731_3808[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (4))){
var inst_3586 = (state_3716[(9)]);
var inst_3586__$1 = (state_3716[(2)]);
var inst_3587 = (inst_3586__$1 == null);
var state_3716__$1 = (function (){var statearr_3732 = state_3716;
(statearr_3732[(9)] = inst_3586__$1);

return statearr_3732;
})();
if(cljs.core.truth_(inst_3587)){
var statearr_3733_3809 = state_3716__$1;
(statearr_3733_3809[(1)] = (5));

} else {
var statearr_3734_3810 = state_3716__$1;
(statearr_3734_3810[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (15))){
var inst_3596 = (state_3716[(14)]);
var inst_3595 = (state_3716[(15)]);
var inst_3598 = (state_3716[(16)]);
var inst_3597 = (state_3716[(17)]);
var inst_3613 = (state_3716[(2)]);
var inst_3614 = (inst_3598 + (1));
var tmp3728 = inst_3596;
var tmp3729 = inst_3595;
var tmp3730 = inst_3597;
var inst_3595__$1 = tmp3729;
var inst_3596__$1 = tmp3728;
var inst_3597__$1 = tmp3730;
var inst_3598__$1 = inst_3614;
var state_3716__$1 = (function (){var statearr_3735 = state_3716;
(statearr_3735[(14)] = inst_3596__$1);

(statearr_3735[(15)] = inst_3595__$1);

(statearr_3735[(16)] = inst_3598__$1);

(statearr_3735[(17)] = inst_3597__$1);

(statearr_3735[(18)] = inst_3613);

return statearr_3735;
})();
var statearr_3736_3811 = state_3716__$1;
(statearr_3736_3811[(2)] = null);

(statearr_3736_3811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (21))){
var inst_3640 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3740_3812 = state_3716__$1;
(statearr_3740_3812[(2)] = inst_3640);

(statearr_3740_3812[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (31))){
var inst_3666 = (state_3716[(10)]);
var inst_3670 = cljs.core.async.untap_STAR_.call(null,m,inst_3666);
var state_3716__$1 = state_3716;
var statearr_3741_3813 = state_3716__$1;
(statearr_3741_3813[(2)] = inst_3670);

(statearr_3741_3813[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (32))){
var inst_3660 = (state_3716[(19)]);
var inst_3661 = (state_3716[(11)]);
var inst_3658 = (state_3716[(20)]);
var inst_3659 = (state_3716[(12)]);
var inst_3672 = (state_3716[(2)]);
var inst_3673 = (inst_3661 + (1));
var tmp3737 = inst_3660;
var tmp3738 = inst_3658;
var tmp3739 = inst_3659;
var inst_3658__$1 = tmp3738;
var inst_3659__$1 = tmp3739;
var inst_3660__$1 = tmp3737;
var inst_3661__$1 = inst_3673;
var state_3716__$1 = (function (){var statearr_3742 = state_3716;
(statearr_3742[(19)] = inst_3660__$1);

(statearr_3742[(11)] = inst_3661__$1);

(statearr_3742[(20)] = inst_3658__$1);

(statearr_3742[(21)] = inst_3672);

(statearr_3742[(12)] = inst_3659__$1);

return statearr_3742;
})();
var statearr_3743_3814 = state_3716__$1;
(statearr_3743_3814[(2)] = null);

(statearr_3743_3814[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (40))){
var inst_3685 = (state_3716[(22)]);
var inst_3689 = cljs.core.async.untap_STAR_.call(null,m,inst_3685);
var state_3716__$1 = state_3716;
var statearr_3744_3815 = state_3716__$1;
(statearr_3744_3815[(2)] = inst_3689);

(statearr_3744_3815[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (33))){
var inst_3676 = (state_3716[(23)]);
var inst_3678 = cljs.core.chunked_seq_QMARK_.call(null,inst_3676);
var state_3716__$1 = state_3716;
if(inst_3678){
var statearr_3745_3816 = state_3716__$1;
(statearr_3745_3816[(1)] = (36));

} else {
var statearr_3746_3817 = state_3716__$1;
(statearr_3746_3817[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (13))){
var inst_3607 = (state_3716[(24)]);
var inst_3610 = cljs.core.async.close_BANG_.call(null,inst_3607);
var state_3716__$1 = state_3716;
var statearr_3747_3818 = state_3716__$1;
(statearr_3747_3818[(2)] = inst_3610);

(statearr_3747_3818[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (22))){
var inst_3630 = (state_3716[(8)]);
var inst_3633 = cljs.core.async.close_BANG_.call(null,inst_3630);
var state_3716__$1 = state_3716;
var statearr_3748_3819 = state_3716__$1;
(statearr_3748_3819[(2)] = inst_3633);

(statearr_3748_3819[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (36))){
var inst_3676 = (state_3716[(23)]);
var inst_3680 = cljs.core.chunk_first.call(null,inst_3676);
var inst_3681 = cljs.core.chunk_rest.call(null,inst_3676);
var inst_3682 = cljs.core.count.call(null,inst_3680);
var inst_3658 = inst_3681;
var inst_3659 = inst_3680;
var inst_3660 = inst_3682;
var inst_3661 = (0);
var state_3716__$1 = (function (){var statearr_3749 = state_3716;
(statearr_3749[(19)] = inst_3660);

(statearr_3749[(11)] = inst_3661);

(statearr_3749[(20)] = inst_3658);

(statearr_3749[(12)] = inst_3659);

return statearr_3749;
})();
var statearr_3750_3820 = state_3716__$1;
(statearr_3750_3820[(2)] = null);

(statearr_3750_3820[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (41))){
var inst_3676 = (state_3716[(23)]);
var inst_3691 = (state_3716[(2)]);
var inst_3692 = cljs.core.next.call(null,inst_3676);
var inst_3658 = inst_3692;
var inst_3659 = null;
var inst_3660 = (0);
var inst_3661 = (0);
var state_3716__$1 = (function (){var statearr_3751 = state_3716;
(statearr_3751[(19)] = inst_3660);

(statearr_3751[(11)] = inst_3661);

(statearr_3751[(25)] = inst_3691);

(statearr_3751[(20)] = inst_3658);

(statearr_3751[(12)] = inst_3659);

return statearr_3751;
})();
var statearr_3752_3821 = state_3716__$1;
(statearr_3752_3821[(2)] = null);

(statearr_3752_3821[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (43))){
var state_3716__$1 = state_3716;
var statearr_3753_3822 = state_3716__$1;
(statearr_3753_3822[(2)] = null);

(statearr_3753_3822[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (29))){
var inst_3700 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3754_3823 = state_3716__$1;
(statearr_3754_3823[(2)] = inst_3700);

(statearr_3754_3823[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (44))){
var inst_3709 = (state_3716[(2)]);
var state_3716__$1 = (function (){var statearr_3755 = state_3716;
(statearr_3755[(26)] = inst_3709);

return statearr_3755;
})();
var statearr_3756_3824 = state_3716__$1;
(statearr_3756_3824[(2)] = null);

(statearr_3756_3824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (6))){
var inst_3650 = (state_3716[(27)]);
var inst_3649 = cljs.core.deref.call(null,cs);
var inst_3650__$1 = cljs.core.keys.call(null,inst_3649);
var inst_3651 = cljs.core.count.call(null,inst_3650__$1);
var inst_3652 = cljs.core.reset_BANG_.call(null,dctr,inst_3651);
var inst_3657 = cljs.core.seq.call(null,inst_3650__$1);
var inst_3658 = inst_3657;
var inst_3659 = null;
var inst_3660 = (0);
var inst_3661 = (0);
var state_3716__$1 = (function (){var statearr_3757 = state_3716;
(statearr_3757[(19)] = inst_3660);

(statearr_3757[(11)] = inst_3661);

(statearr_3757[(27)] = inst_3650__$1);

(statearr_3757[(20)] = inst_3658);

(statearr_3757[(28)] = inst_3652);

(statearr_3757[(12)] = inst_3659);

return statearr_3757;
})();
var statearr_3758_3825 = state_3716__$1;
(statearr_3758_3825[(2)] = null);

(statearr_3758_3825[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (28))){
var inst_3658 = (state_3716[(20)]);
var inst_3676 = (state_3716[(23)]);
var inst_3676__$1 = cljs.core.seq.call(null,inst_3658);
var state_3716__$1 = (function (){var statearr_3759 = state_3716;
(statearr_3759[(23)] = inst_3676__$1);

return statearr_3759;
})();
if(inst_3676__$1){
var statearr_3760_3826 = state_3716__$1;
(statearr_3760_3826[(1)] = (33));

} else {
var statearr_3761_3827 = state_3716__$1;
(statearr_3761_3827[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (25))){
var inst_3660 = (state_3716[(19)]);
var inst_3661 = (state_3716[(11)]);
var inst_3663 = (inst_3661 < inst_3660);
var inst_3664 = inst_3663;
var state_3716__$1 = state_3716;
if(cljs.core.truth_(inst_3664)){
var statearr_3762_3828 = state_3716__$1;
(statearr_3762_3828[(1)] = (27));

} else {
var statearr_3763_3829 = state_3716__$1;
(statearr_3763_3829[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (34))){
var state_3716__$1 = state_3716;
var statearr_3764_3830 = state_3716__$1;
(statearr_3764_3830[(2)] = null);

(statearr_3764_3830[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (17))){
var state_3716__$1 = state_3716;
var statearr_3765_3831 = state_3716__$1;
(statearr_3765_3831[(2)] = null);

(statearr_3765_3831[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (3))){
var inst_3714 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3716__$1,inst_3714);
} else {
if((state_val_3717 === (12))){
var inst_3645 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3766_3832 = state_3716__$1;
(statearr_3766_3832[(2)] = inst_3645);

(statearr_3766_3832[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (2))){
var state_3716__$1 = state_3716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3716__$1,(4),ch);
} else {
if((state_val_3717 === (23))){
var state_3716__$1 = state_3716;
var statearr_3767_3833 = state_3716__$1;
(statearr_3767_3833[(2)] = null);

(statearr_3767_3833[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (35))){
var inst_3698 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3768_3834 = state_3716__$1;
(statearr_3768_3834[(2)] = inst_3698);

(statearr_3768_3834[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (19))){
var inst_3617 = (state_3716[(7)]);
var inst_3621 = cljs.core.chunk_first.call(null,inst_3617);
var inst_3622 = cljs.core.chunk_rest.call(null,inst_3617);
var inst_3623 = cljs.core.count.call(null,inst_3621);
var inst_3595 = inst_3622;
var inst_3596 = inst_3621;
var inst_3597 = inst_3623;
var inst_3598 = (0);
var state_3716__$1 = (function (){var statearr_3769 = state_3716;
(statearr_3769[(14)] = inst_3596);

(statearr_3769[(15)] = inst_3595);

(statearr_3769[(16)] = inst_3598);

(statearr_3769[(17)] = inst_3597);

return statearr_3769;
})();
var statearr_3770_3835 = state_3716__$1;
(statearr_3770_3835[(2)] = null);

(statearr_3770_3835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (11))){
var inst_3595 = (state_3716[(15)]);
var inst_3617 = (state_3716[(7)]);
var inst_3617__$1 = cljs.core.seq.call(null,inst_3595);
var state_3716__$1 = (function (){var statearr_3771 = state_3716;
(statearr_3771[(7)] = inst_3617__$1);

return statearr_3771;
})();
if(inst_3617__$1){
var statearr_3772_3836 = state_3716__$1;
(statearr_3772_3836[(1)] = (16));

} else {
var statearr_3773_3837 = state_3716__$1;
(statearr_3773_3837[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (9))){
var inst_3647 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3774_3838 = state_3716__$1;
(statearr_3774_3838[(2)] = inst_3647);

(statearr_3774_3838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (5))){
var inst_3593 = cljs.core.deref.call(null,cs);
var inst_3594 = cljs.core.seq.call(null,inst_3593);
var inst_3595 = inst_3594;
var inst_3596 = null;
var inst_3597 = (0);
var inst_3598 = (0);
var state_3716__$1 = (function (){var statearr_3775 = state_3716;
(statearr_3775[(14)] = inst_3596);

(statearr_3775[(15)] = inst_3595);

(statearr_3775[(16)] = inst_3598);

(statearr_3775[(17)] = inst_3597);

return statearr_3775;
})();
var statearr_3776_3839 = state_3716__$1;
(statearr_3776_3839[(2)] = null);

(statearr_3776_3839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (14))){
var state_3716__$1 = state_3716;
var statearr_3777_3840 = state_3716__$1;
(statearr_3777_3840[(2)] = null);

(statearr_3777_3840[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (45))){
var inst_3706 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3778_3841 = state_3716__$1;
(statearr_3778_3841[(2)] = inst_3706);

(statearr_3778_3841[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (26))){
var inst_3650 = (state_3716[(27)]);
var inst_3702 = (state_3716[(2)]);
var inst_3703 = cljs.core.seq.call(null,inst_3650);
var state_3716__$1 = (function (){var statearr_3779 = state_3716;
(statearr_3779[(29)] = inst_3702);

return statearr_3779;
})();
if(inst_3703){
var statearr_3780_3842 = state_3716__$1;
(statearr_3780_3842[(1)] = (42));

} else {
var statearr_3781_3843 = state_3716__$1;
(statearr_3781_3843[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (16))){
var inst_3617 = (state_3716[(7)]);
var inst_3619 = cljs.core.chunked_seq_QMARK_.call(null,inst_3617);
var state_3716__$1 = state_3716;
if(inst_3619){
var statearr_3782_3844 = state_3716__$1;
(statearr_3782_3844[(1)] = (19));

} else {
var statearr_3783_3845 = state_3716__$1;
(statearr_3783_3845[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (38))){
var inst_3695 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3784_3846 = state_3716__$1;
(statearr_3784_3846[(2)] = inst_3695);

(statearr_3784_3846[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (30))){
var state_3716__$1 = state_3716;
var statearr_3785_3847 = state_3716__$1;
(statearr_3785_3847[(2)] = null);

(statearr_3785_3847[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (10))){
var inst_3596 = (state_3716[(14)]);
var inst_3598 = (state_3716[(16)]);
var inst_3606 = cljs.core._nth.call(null,inst_3596,inst_3598);
var inst_3607 = cljs.core.nth.call(null,inst_3606,(0),null);
var inst_3608 = cljs.core.nth.call(null,inst_3606,(1),null);
var state_3716__$1 = (function (){var statearr_3786 = state_3716;
(statearr_3786[(24)] = inst_3607);

return statearr_3786;
})();
if(cljs.core.truth_(inst_3608)){
var statearr_3787_3848 = state_3716__$1;
(statearr_3787_3848[(1)] = (13));

} else {
var statearr_3788_3849 = state_3716__$1;
(statearr_3788_3849[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (18))){
var inst_3643 = (state_3716[(2)]);
var state_3716__$1 = state_3716;
var statearr_3789_3850 = state_3716__$1;
(statearr_3789_3850[(2)] = inst_3643);

(statearr_3789_3850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (42))){
var state_3716__$1 = state_3716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3716__$1,(45),dchan);
} else {
if((state_val_3717 === (37))){
var inst_3586 = (state_3716[(9)]);
var inst_3676 = (state_3716[(23)]);
var inst_3685 = (state_3716[(22)]);
var inst_3685__$1 = cljs.core.first.call(null,inst_3676);
var inst_3686 = cljs.core.async.put_BANG_.call(null,inst_3685__$1,inst_3586,done);
var state_3716__$1 = (function (){var statearr_3790 = state_3716;
(statearr_3790[(22)] = inst_3685__$1);

return statearr_3790;
})();
if(cljs.core.truth_(inst_3686)){
var statearr_3791_3851 = state_3716__$1;
(statearr_3791_3851[(1)] = (39));

} else {
var statearr_3792_3852 = state_3716__$1;
(statearr_3792_3852[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3717 === (8))){
var inst_3598 = (state_3716[(16)]);
var inst_3597 = (state_3716[(17)]);
var inst_3600 = (inst_3598 < inst_3597);
var inst_3601 = inst_3600;
var state_3716__$1 = state_3716;
if(cljs.core.truth_(inst_3601)){
var statearr_3793_3853 = state_3716__$1;
(statearr_3793_3853[(1)] = (10));

} else {
var statearr_3794_3854 = state_3716__$1;
(statearr_3794_3854[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__2884__auto__ = null;
var cljs$core$async$mult_$_state_machine__2884__auto____0 = (function (){
var statearr_3795 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3795[(0)] = cljs$core$async$mult_$_state_machine__2884__auto__);

(statearr_3795[(1)] = (1));

return statearr_3795;
});
var cljs$core$async$mult_$_state_machine__2884__auto____1 = (function (state_3716){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e3796){var ex__2887__auto__ = e3796;
var statearr_3797_3855 = state_3716;
(statearr_3797_3855[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3716[(4)]))){
var statearr_3798_3856 = state_3716;
(statearr_3798_3856[(1)] = cljs.core.first.call(null,(state_3716[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3857 = state_3716;
state_3716 = G__3857;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__2884__auto__ = function(state_3716){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__2884__auto____1.call(this,state_3716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__2884__auto____0;
cljs$core$async$mult_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__2884__auto____1;
return cljs$core$async$mult_$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_3799 = f__2958__auto__.call(null);
(statearr_3799[(6)] = c__2957__auto___3800);

return statearr_3799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__3859 = arguments.length;
switch (G__3859) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_3861 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_3861.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_3862 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_3862.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_3863 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_3863.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_3864 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_3864.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_3865 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_3865.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3876 = arguments.length;
var i__4737__auto___3877 = (0);
while(true){
if((i__4737__auto___3877 < len__4736__auto___3876)){
args__4742__auto__.push((arguments[i__4737__auto___3877]));

var G__3878 = (i__4737__auto___3877 + (1));
i__4737__auto___3877 = G__3878;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__3870){
var map__3871 = p__3870;
var map__3871__$1 = (((((!((map__3871 == null))))?(((((map__3871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3871):map__3871);
var opts = map__3871__$1;
var statearr_3873_3879 = state;
(statearr_3873_3879[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_3874_3880 = state;
(statearr_3874_3880[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_3875_3881 = state;
(statearr_3875_3881[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq3866){
var G__3867 = cljs.core.first.call(null,seq3866);
var seq3866__$1 = cljs.core.next.call(null,seq3866);
var G__3868 = cljs.core.first.call(null,seq3866__$1);
var seq3866__$2 = cljs.core.next.call(null,seq3866__$1);
var G__3869 = cljs.core.first.call(null,seq3866__$2);
var seq3866__$3 = cljs.core.next.call(null,seq3866__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3867,G__3868,G__3869,seq3866__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3882 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3882 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta3883){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta3883 = meta3883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3884,meta3883__$1){
var self__ = this;
var _3884__$1 = this;
return (new cljs.core.async.t_cljs$core$async3882(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta3883__$1));
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3884){
var self__ = this;
var _3884__$1 = this;
return self__.meta3883;
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async3882.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async3882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta3883","meta3883",1462998147,null)], null);
}));

(cljs.core.async.t_cljs$core$async3882.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3882");

(cljs.core.async.t_cljs$core$async3882.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3882");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3882.
 */
cljs.core.async.__GT_t_cljs$core$async3882 = (function cljs$core$async$mix_$___GT_t_cljs$core$async3882(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta3883){
return (new cljs.core.async.t_cljs$core$async3882(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta3883));
});

}

return (new cljs.core.async.t_cljs$core$async3882(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2957__auto___4047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_3986){
var state_val_3987 = (state_3986[(1)]);
if((state_val_3987 === (7))){
var inst_3901 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
var statearr_3988_4048 = state_3986__$1;
(statearr_3988_4048[(2)] = inst_3901);

(statearr_3988_4048[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (20))){
var inst_3913 = (state_3986[(7)]);
var state_3986__$1 = state_3986;
var statearr_3989_4049 = state_3986__$1;
(statearr_3989_4049[(2)] = inst_3913);

(statearr_3989_4049[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (27))){
var state_3986__$1 = state_3986;
var statearr_3990_4050 = state_3986__$1;
(statearr_3990_4050[(2)] = null);

(statearr_3990_4050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (1))){
var inst_3888 = (state_3986[(8)]);
var inst_3888__$1 = calc_state.call(null);
var inst_3890 = (inst_3888__$1 == null);
var inst_3891 = cljs.core.not.call(null,inst_3890);
var state_3986__$1 = (function (){var statearr_3991 = state_3986;
(statearr_3991[(8)] = inst_3888__$1);

return statearr_3991;
})();
if(inst_3891){
var statearr_3992_4051 = state_3986__$1;
(statearr_3992_4051[(1)] = (2));

} else {
var statearr_3993_4052 = state_3986__$1;
(statearr_3993_4052[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (24))){
var inst_3960 = (state_3986[(9)]);
var inst_3937 = (state_3986[(10)]);
var inst_3946 = (state_3986[(11)]);
var inst_3960__$1 = inst_3937.call(null,inst_3946);
var state_3986__$1 = (function (){var statearr_3994 = state_3986;
(statearr_3994[(9)] = inst_3960__$1);

return statearr_3994;
})();
if(cljs.core.truth_(inst_3960__$1)){
var statearr_3995_4053 = state_3986__$1;
(statearr_3995_4053[(1)] = (29));

} else {
var statearr_3996_4054 = state_3986__$1;
(statearr_3996_4054[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (4))){
var inst_3904 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3904)){
var statearr_3997_4055 = state_3986__$1;
(statearr_3997_4055[(1)] = (8));

} else {
var statearr_3998_4056 = state_3986__$1;
(statearr_3998_4056[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (15))){
var inst_3931 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3931)){
var statearr_3999_4057 = state_3986__$1;
(statearr_3999_4057[(1)] = (19));

} else {
var statearr_4000_4058 = state_3986__$1;
(statearr_4000_4058[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (21))){
var inst_3936 = (state_3986[(12)]);
var inst_3936__$1 = (state_3986[(2)]);
var inst_3937 = cljs.core.get.call(null,inst_3936__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_3938 = cljs.core.get.call(null,inst_3936__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_3939 = cljs.core.get.call(null,inst_3936__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_3986__$1 = (function (){var statearr_4001 = state_3986;
(statearr_4001[(13)] = inst_3938);

(statearr_4001[(12)] = inst_3936__$1);

(statearr_4001[(10)] = inst_3937);

return statearr_4001;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_3986__$1,(22),inst_3939);
} else {
if((state_val_3987 === (31))){
var inst_3968 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3968)){
var statearr_4002_4059 = state_3986__$1;
(statearr_4002_4059[(1)] = (32));

} else {
var statearr_4003_4060 = state_3986__$1;
(statearr_4003_4060[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (32))){
var inst_3945 = (state_3986[(14)]);
var state_3986__$1 = state_3986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3986__$1,(35),out,inst_3945);
} else {
if((state_val_3987 === (33))){
var inst_3936 = (state_3986[(12)]);
var inst_3913 = inst_3936;
var state_3986__$1 = (function (){var statearr_4004 = state_3986;
(statearr_4004[(7)] = inst_3913);

return statearr_4004;
})();
var statearr_4005_4061 = state_3986__$1;
(statearr_4005_4061[(2)] = null);

(statearr_4005_4061[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (13))){
var inst_3913 = (state_3986[(7)]);
var inst_3920 = inst_3913.cljs$lang$protocol_mask$partition0$;
var inst_3921 = (inst_3920 & (64));
var inst_3922 = inst_3913.cljs$core$ISeq$;
var inst_3923 = (cljs.core.PROTOCOL_SENTINEL === inst_3922);
var inst_3924 = ((inst_3921) || (inst_3923));
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3924)){
var statearr_4006_4062 = state_3986__$1;
(statearr_4006_4062[(1)] = (16));

} else {
var statearr_4007_4063 = state_3986__$1;
(statearr_4007_4063[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (22))){
var inst_3945 = (state_3986[(14)]);
var inst_3946 = (state_3986[(11)]);
var inst_3944 = (state_3986[(2)]);
var inst_3945__$1 = cljs.core.nth.call(null,inst_3944,(0),null);
var inst_3946__$1 = cljs.core.nth.call(null,inst_3944,(1),null);
var inst_3947 = (inst_3945__$1 == null);
var inst_3948 = cljs.core._EQ_.call(null,inst_3946__$1,change);
var inst_3949 = ((inst_3947) || (inst_3948));
var state_3986__$1 = (function (){var statearr_4008 = state_3986;
(statearr_4008[(14)] = inst_3945__$1);

(statearr_4008[(11)] = inst_3946__$1);

return statearr_4008;
})();
if(cljs.core.truth_(inst_3949)){
var statearr_4009_4064 = state_3986__$1;
(statearr_4009_4064[(1)] = (23));

} else {
var statearr_4010_4065 = state_3986__$1;
(statearr_4010_4065[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (36))){
var inst_3936 = (state_3986[(12)]);
var inst_3913 = inst_3936;
var state_3986__$1 = (function (){var statearr_4011 = state_3986;
(statearr_4011[(7)] = inst_3913);

return statearr_4011;
})();
var statearr_4012_4066 = state_3986__$1;
(statearr_4012_4066[(2)] = null);

(statearr_4012_4066[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (29))){
var inst_3960 = (state_3986[(9)]);
var state_3986__$1 = state_3986;
var statearr_4013_4067 = state_3986__$1;
(statearr_4013_4067[(2)] = inst_3960);

(statearr_4013_4067[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (6))){
var state_3986__$1 = state_3986;
var statearr_4014_4068 = state_3986__$1;
(statearr_4014_4068[(2)] = false);

(statearr_4014_4068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (28))){
var inst_3956 = (state_3986[(2)]);
var inst_3957 = calc_state.call(null);
var inst_3913 = inst_3957;
var state_3986__$1 = (function (){var statearr_4015 = state_3986;
(statearr_4015[(15)] = inst_3956);

(statearr_4015[(7)] = inst_3913);

return statearr_4015;
})();
var statearr_4016_4069 = state_3986__$1;
(statearr_4016_4069[(2)] = null);

(statearr_4016_4069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (25))){
var inst_3982 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
var statearr_4017_4070 = state_3986__$1;
(statearr_4017_4070[(2)] = inst_3982);

(statearr_4017_4070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (34))){
var inst_3980 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
var statearr_4018_4071 = state_3986__$1;
(statearr_4018_4071[(2)] = inst_3980);

(statearr_4018_4071[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (17))){
var state_3986__$1 = state_3986;
var statearr_4019_4072 = state_3986__$1;
(statearr_4019_4072[(2)] = false);

(statearr_4019_4072[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (3))){
var state_3986__$1 = state_3986;
var statearr_4020_4073 = state_3986__$1;
(statearr_4020_4073[(2)] = false);

(statearr_4020_4073[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (12))){
var inst_3984 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3986__$1,inst_3984);
} else {
if((state_val_3987 === (2))){
var inst_3888 = (state_3986[(8)]);
var inst_3893 = inst_3888.cljs$lang$protocol_mask$partition0$;
var inst_3894 = (inst_3893 & (64));
var inst_3895 = inst_3888.cljs$core$ISeq$;
var inst_3896 = (cljs.core.PROTOCOL_SENTINEL === inst_3895);
var inst_3897 = ((inst_3894) || (inst_3896));
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3897)){
var statearr_4021_4074 = state_3986__$1;
(statearr_4021_4074[(1)] = (5));

} else {
var statearr_4022_4075 = state_3986__$1;
(statearr_4022_4075[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (23))){
var inst_3945 = (state_3986[(14)]);
var inst_3951 = (inst_3945 == null);
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3951)){
var statearr_4023_4076 = state_3986__$1;
(statearr_4023_4076[(1)] = (26));

} else {
var statearr_4024_4077 = state_3986__$1;
(statearr_4024_4077[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (35))){
var inst_3971 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
if(cljs.core.truth_(inst_3971)){
var statearr_4025_4078 = state_3986__$1;
(statearr_4025_4078[(1)] = (36));

} else {
var statearr_4026_4079 = state_3986__$1;
(statearr_4026_4079[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (19))){
var inst_3913 = (state_3986[(7)]);
var inst_3933 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3913);
var state_3986__$1 = state_3986;
var statearr_4027_4080 = state_3986__$1;
(statearr_4027_4080[(2)] = inst_3933);

(statearr_4027_4080[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (11))){
var inst_3913 = (state_3986[(7)]);
var inst_3917 = (inst_3913 == null);
var inst_3918 = cljs.core.not.call(null,inst_3917);
var state_3986__$1 = state_3986;
if(inst_3918){
var statearr_4028_4081 = state_3986__$1;
(statearr_4028_4081[(1)] = (13));

} else {
var statearr_4029_4082 = state_3986__$1;
(statearr_4029_4082[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (9))){
var inst_3888 = (state_3986[(8)]);
var state_3986__$1 = state_3986;
var statearr_4030_4083 = state_3986__$1;
(statearr_4030_4083[(2)] = inst_3888);

(statearr_4030_4083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (5))){
var state_3986__$1 = state_3986;
var statearr_4031_4084 = state_3986__$1;
(statearr_4031_4084[(2)] = true);

(statearr_4031_4084[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (14))){
var state_3986__$1 = state_3986;
var statearr_4032_4085 = state_3986__$1;
(statearr_4032_4085[(2)] = false);

(statearr_4032_4085[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (26))){
var inst_3946 = (state_3986[(11)]);
var inst_3953 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_3946);
var state_3986__$1 = state_3986;
var statearr_4033_4086 = state_3986__$1;
(statearr_4033_4086[(2)] = inst_3953);

(statearr_4033_4086[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (16))){
var state_3986__$1 = state_3986;
var statearr_4034_4087 = state_3986__$1;
(statearr_4034_4087[(2)] = true);

(statearr_4034_4087[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (38))){
var inst_3976 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
var statearr_4035_4088 = state_3986__$1;
(statearr_4035_4088[(2)] = inst_3976);

(statearr_4035_4088[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (30))){
var inst_3938 = (state_3986[(13)]);
var inst_3937 = (state_3986[(10)]);
var inst_3946 = (state_3986[(11)]);
var inst_3963 = cljs.core.empty_QMARK_.call(null,inst_3937);
var inst_3964 = inst_3938.call(null,inst_3946);
var inst_3965 = cljs.core.not.call(null,inst_3964);
var inst_3966 = ((inst_3963) && (inst_3965));
var state_3986__$1 = state_3986;
var statearr_4036_4089 = state_3986__$1;
(statearr_4036_4089[(2)] = inst_3966);

(statearr_4036_4089[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (10))){
var inst_3888 = (state_3986[(8)]);
var inst_3909 = (state_3986[(2)]);
var inst_3910 = cljs.core.get.call(null,inst_3909,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_3911 = cljs.core.get.call(null,inst_3909,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_3912 = cljs.core.get.call(null,inst_3909,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_3913 = inst_3888;
var state_3986__$1 = (function (){var statearr_4037 = state_3986;
(statearr_4037[(16)] = inst_3912);

(statearr_4037[(17)] = inst_3911);

(statearr_4037[(7)] = inst_3913);

(statearr_4037[(18)] = inst_3910);

return statearr_4037;
})();
var statearr_4038_4090 = state_3986__$1;
(statearr_4038_4090[(2)] = null);

(statearr_4038_4090[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (18))){
var inst_3928 = (state_3986[(2)]);
var state_3986__$1 = state_3986;
var statearr_4039_4091 = state_3986__$1;
(statearr_4039_4091[(2)] = inst_3928);

(statearr_4039_4091[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (37))){
var state_3986__$1 = state_3986;
var statearr_4040_4092 = state_3986__$1;
(statearr_4040_4092[(2)] = null);

(statearr_4040_4092[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3987 === (8))){
var inst_3888 = (state_3986[(8)]);
var inst_3906 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3888);
var state_3986__$1 = state_3986;
var statearr_4041_4093 = state_3986__$1;
(statearr_4041_4093[(2)] = inst_3906);

(statearr_4041_4093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__2884__auto__ = null;
var cljs$core$async$mix_$_state_machine__2884__auto____0 = (function (){
var statearr_4042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4042[(0)] = cljs$core$async$mix_$_state_machine__2884__auto__);

(statearr_4042[(1)] = (1));

return statearr_4042;
});
var cljs$core$async$mix_$_state_machine__2884__auto____1 = (function (state_3986){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_3986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4043){var ex__2887__auto__ = e4043;
var statearr_4044_4094 = state_3986;
(statearr_4044_4094[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_3986[(4)]))){
var statearr_4045_4095 = state_3986;
(statearr_4045_4095[(1)] = cljs.core.first.call(null,(state_3986[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4096 = state_3986;
state_3986 = G__4096;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__2884__auto__ = function(state_3986){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__2884__auto____1.call(this,state_3986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__2884__auto____0;
cljs$core$async$mix_$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__2884__auto____1;
return cljs$core$async$mix_$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4046 = f__2958__auto__.call(null);
(statearr_4046[(6)] = c__2957__auto___4047);

return statearr_4046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_4099 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_4099.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_4100 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_4100.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_4101 = (function() {
var G__4102 = null;
var G__4102__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__4102__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__4102 = function(p,v){
switch(arguments.length){
case 1:
return G__4102__1.call(this,p);
case 2:
return G__4102__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4102.cljs$core$IFn$_invoke$arity$1 = G__4102__1;
G__4102.cljs$core$IFn$_invoke$arity$2 = G__4102__2;
return G__4102;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__4098 = arguments.length;
switch (G__4098) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_4101.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_4101.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__4106 = arguments.length;
switch (G__4106) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__4104_SHARP_){
if(cljs.core.truth_(p1__4104_SHARP_.call(null,topic))){
return p1__4104_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__4104_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4107 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4107 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta4108){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta4108 = meta4108;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4109,meta4108__$1){
var self__ = this;
var _4109__$1 = this;
return (new cljs.core.async.t_cljs$core$async4107(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta4108__$1));
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4109){
var self__ = this;
var _4109__$1 = this;
return self__.meta4108;
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async4107.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async4107.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta4108","meta4108",-1546977976,null)], null);
}));

(cljs.core.async.t_cljs$core$async4107.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4107.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4107");

(cljs.core.async.t_cljs$core$async4107.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4107");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4107.
 */
cljs.core.async.__GT_t_cljs$core$async4107 = (function cljs$core$async$__GT_t_cljs$core$async4107(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4108){
return (new cljs.core.async.t_cljs$core$async4107(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4108));
});

}

return (new cljs.core.async.t_cljs$core$async4107(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2957__auto___4228 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4181){
var state_val_4182 = (state_4181[(1)]);
if((state_val_4182 === (7))){
var inst_4177 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4183_4229 = state_4181__$1;
(statearr_4183_4229[(2)] = inst_4177);

(statearr_4183_4229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (20))){
var state_4181__$1 = state_4181;
var statearr_4184_4230 = state_4181__$1;
(statearr_4184_4230[(2)] = null);

(statearr_4184_4230[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (1))){
var state_4181__$1 = state_4181;
var statearr_4185_4231 = state_4181__$1;
(statearr_4185_4231[(2)] = null);

(statearr_4185_4231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (24))){
var inst_4160 = (state_4181[(7)]);
var inst_4169 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_4160);
var state_4181__$1 = state_4181;
var statearr_4186_4232 = state_4181__$1;
(statearr_4186_4232[(2)] = inst_4169);

(statearr_4186_4232[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (4))){
var inst_4112 = (state_4181[(8)]);
var inst_4112__$1 = (state_4181[(2)]);
var inst_4113 = (inst_4112__$1 == null);
var state_4181__$1 = (function (){var statearr_4187 = state_4181;
(statearr_4187[(8)] = inst_4112__$1);

return statearr_4187;
})();
if(cljs.core.truth_(inst_4113)){
var statearr_4188_4233 = state_4181__$1;
(statearr_4188_4233[(1)] = (5));

} else {
var statearr_4189_4234 = state_4181__$1;
(statearr_4189_4234[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (15))){
var inst_4154 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4190_4235 = state_4181__$1;
(statearr_4190_4235[(2)] = inst_4154);

(statearr_4190_4235[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (21))){
var inst_4174 = (state_4181[(2)]);
var state_4181__$1 = (function (){var statearr_4191 = state_4181;
(statearr_4191[(9)] = inst_4174);

return statearr_4191;
})();
var statearr_4192_4236 = state_4181__$1;
(statearr_4192_4236[(2)] = null);

(statearr_4192_4236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (13))){
var inst_4136 = (state_4181[(10)]);
var inst_4138 = cljs.core.chunked_seq_QMARK_.call(null,inst_4136);
var state_4181__$1 = state_4181;
if(inst_4138){
var statearr_4193_4237 = state_4181__$1;
(statearr_4193_4237[(1)] = (16));

} else {
var statearr_4194_4238 = state_4181__$1;
(statearr_4194_4238[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (22))){
var inst_4166 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
if(cljs.core.truth_(inst_4166)){
var statearr_4195_4239 = state_4181__$1;
(statearr_4195_4239[(1)] = (23));

} else {
var statearr_4196_4240 = state_4181__$1;
(statearr_4196_4240[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (6))){
var inst_4160 = (state_4181[(7)]);
var inst_4112 = (state_4181[(8)]);
var inst_4162 = (state_4181[(11)]);
var inst_4160__$1 = topic_fn.call(null,inst_4112);
var inst_4161 = cljs.core.deref.call(null,mults);
var inst_4162__$1 = cljs.core.get.call(null,inst_4161,inst_4160__$1);
var state_4181__$1 = (function (){var statearr_4197 = state_4181;
(statearr_4197[(7)] = inst_4160__$1);

(statearr_4197[(11)] = inst_4162__$1);

return statearr_4197;
})();
if(cljs.core.truth_(inst_4162__$1)){
var statearr_4198_4241 = state_4181__$1;
(statearr_4198_4241[(1)] = (19));

} else {
var statearr_4199_4242 = state_4181__$1;
(statearr_4199_4242[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (25))){
var inst_4171 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4200_4243 = state_4181__$1;
(statearr_4200_4243[(2)] = inst_4171);

(statearr_4200_4243[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (17))){
var inst_4136 = (state_4181[(10)]);
var inst_4145 = cljs.core.first.call(null,inst_4136);
var inst_4146 = cljs.core.async.muxch_STAR_.call(null,inst_4145);
var inst_4147 = cljs.core.async.close_BANG_.call(null,inst_4146);
var inst_4148 = cljs.core.next.call(null,inst_4136);
var inst_4122 = inst_4148;
var inst_4123 = null;
var inst_4124 = (0);
var inst_4125 = (0);
var state_4181__$1 = (function (){var statearr_4201 = state_4181;
(statearr_4201[(12)] = inst_4123);

(statearr_4201[(13)] = inst_4147);

(statearr_4201[(14)] = inst_4122);

(statearr_4201[(15)] = inst_4125);

(statearr_4201[(16)] = inst_4124);

return statearr_4201;
})();
var statearr_4202_4244 = state_4181__$1;
(statearr_4202_4244[(2)] = null);

(statearr_4202_4244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (3))){
var inst_4179 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4181__$1,inst_4179);
} else {
if((state_val_4182 === (12))){
var inst_4156 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4203_4245 = state_4181__$1;
(statearr_4203_4245[(2)] = inst_4156);

(statearr_4203_4245[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (2))){
var state_4181__$1 = state_4181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4181__$1,(4),ch);
} else {
if((state_val_4182 === (23))){
var state_4181__$1 = state_4181;
var statearr_4204_4246 = state_4181__$1;
(statearr_4204_4246[(2)] = null);

(statearr_4204_4246[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (19))){
var inst_4112 = (state_4181[(8)]);
var inst_4162 = (state_4181[(11)]);
var inst_4164 = cljs.core.async.muxch_STAR_.call(null,inst_4162);
var state_4181__$1 = state_4181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4181__$1,(22),inst_4164,inst_4112);
} else {
if((state_val_4182 === (11))){
var inst_4136 = (state_4181[(10)]);
var inst_4122 = (state_4181[(14)]);
var inst_4136__$1 = cljs.core.seq.call(null,inst_4122);
var state_4181__$1 = (function (){var statearr_4205 = state_4181;
(statearr_4205[(10)] = inst_4136__$1);

return statearr_4205;
})();
if(inst_4136__$1){
var statearr_4206_4247 = state_4181__$1;
(statearr_4206_4247[(1)] = (13));

} else {
var statearr_4207_4248 = state_4181__$1;
(statearr_4207_4248[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (9))){
var inst_4158 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4208_4249 = state_4181__$1;
(statearr_4208_4249[(2)] = inst_4158);

(statearr_4208_4249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (5))){
var inst_4119 = cljs.core.deref.call(null,mults);
var inst_4120 = cljs.core.vals.call(null,inst_4119);
var inst_4121 = cljs.core.seq.call(null,inst_4120);
var inst_4122 = inst_4121;
var inst_4123 = null;
var inst_4124 = (0);
var inst_4125 = (0);
var state_4181__$1 = (function (){var statearr_4209 = state_4181;
(statearr_4209[(12)] = inst_4123);

(statearr_4209[(14)] = inst_4122);

(statearr_4209[(15)] = inst_4125);

(statearr_4209[(16)] = inst_4124);

return statearr_4209;
})();
var statearr_4210_4250 = state_4181__$1;
(statearr_4210_4250[(2)] = null);

(statearr_4210_4250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (14))){
var state_4181__$1 = state_4181;
var statearr_4214_4251 = state_4181__$1;
(statearr_4214_4251[(2)] = null);

(statearr_4214_4251[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (16))){
var inst_4136 = (state_4181[(10)]);
var inst_4140 = cljs.core.chunk_first.call(null,inst_4136);
var inst_4141 = cljs.core.chunk_rest.call(null,inst_4136);
var inst_4142 = cljs.core.count.call(null,inst_4140);
var inst_4122 = inst_4141;
var inst_4123 = inst_4140;
var inst_4124 = inst_4142;
var inst_4125 = (0);
var state_4181__$1 = (function (){var statearr_4215 = state_4181;
(statearr_4215[(12)] = inst_4123);

(statearr_4215[(14)] = inst_4122);

(statearr_4215[(15)] = inst_4125);

(statearr_4215[(16)] = inst_4124);

return statearr_4215;
})();
var statearr_4216_4252 = state_4181__$1;
(statearr_4216_4252[(2)] = null);

(statearr_4216_4252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (10))){
var inst_4123 = (state_4181[(12)]);
var inst_4122 = (state_4181[(14)]);
var inst_4125 = (state_4181[(15)]);
var inst_4124 = (state_4181[(16)]);
var inst_4130 = cljs.core._nth.call(null,inst_4123,inst_4125);
var inst_4131 = cljs.core.async.muxch_STAR_.call(null,inst_4130);
var inst_4132 = cljs.core.async.close_BANG_.call(null,inst_4131);
var inst_4133 = (inst_4125 + (1));
var tmp4211 = inst_4123;
var tmp4212 = inst_4122;
var tmp4213 = inst_4124;
var inst_4122__$1 = tmp4212;
var inst_4123__$1 = tmp4211;
var inst_4124__$1 = tmp4213;
var inst_4125__$1 = inst_4133;
var state_4181__$1 = (function (){var statearr_4217 = state_4181;
(statearr_4217[(12)] = inst_4123__$1);

(statearr_4217[(14)] = inst_4122__$1);

(statearr_4217[(17)] = inst_4132);

(statearr_4217[(15)] = inst_4125__$1);

(statearr_4217[(16)] = inst_4124__$1);

return statearr_4217;
})();
var statearr_4218_4253 = state_4181__$1;
(statearr_4218_4253[(2)] = null);

(statearr_4218_4253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (18))){
var inst_4151 = (state_4181[(2)]);
var state_4181__$1 = state_4181;
var statearr_4219_4254 = state_4181__$1;
(statearr_4219_4254[(2)] = inst_4151);

(statearr_4219_4254[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4182 === (8))){
var inst_4125 = (state_4181[(15)]);
var inst_4124 = (state_4181[(16)]);
var inst_4127 = (inst_4125 < inst_4124);
var inst_4128 = inst_4127;
var state_4181__$1 = state_4181;
if(cljs.core.truth_(inst_4128)){
var statearr_4220_4255 = state_4181__$1;
(statearr_4220_4255[(1)] = (10));

} else {
var statearr_4221_4256 = state_4181__$1;
(statearr_4221_4256[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4222[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4222[(1)] = (1));

return statearr_4222;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4181){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4223){var ex__2887__auto__ = e4223;
var statearr_4224_4257 = state_4181;
(statearr_4224_4257[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4181[(4)]))){
var statearr_4225_4258 = state_4181;
(statearr_4225_4258[(1)] = cljs.core.first.call(null,(state_4181[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4259 = state_4181;
state_4181 = G__4259;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4226 = f__2958__auto__.call(null);
(statearr_4226[(6)] = c__2957__auto___4228);

return statearr_4226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__4261 = arguments.length;
switch (G__4261) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__4264 = arguments.length;
switch (G__4264) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__4267 = arguments.length;
switch (G__4267) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__2957__auto___4345 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4310){
var state_val_4311 = (state_4310[(1)]);
if((state_val_4311 === (7))){
var state_4310__$1 = state_4310;
var statearr_4312_4346 = state_4310__$1;
(statearr_4312_4346[(2)] = null);

(statearr_4312_4346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (1))){
var state_4310__$1 = state_4310;
var statearr_4313_4347 = state_4310__$1;
(statearr_4313_4347[(2)] = null);

(statearr_4313_4347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (4))){
var inst_4271 = (state_4310[(7)]);
var inst_4270 = (state_4310[(8)]);
var inst_4273 = (inst_4271 < inst_4270);
var state_4310__$1 = state_4310;
if(cljs.core.truth_(inst_4273)){
var statearr_4314_4348 = state_4310__$1;
(statearr_4314_4348[(1)] = (6));

} else {
var statearr_4315_4349 = state_4310__$1;
(statearr_4315_4349[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (15))){
var inst_4296 = (state_4310[(9)]);
var inst_4301 = cljs.core.apply.call(null,f,inst_4296);
var state_4310__$1 = state_4310;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4310__$1,(17),out,inst_4301);
} else {
if((state_val_4311 === (13))){
var inst_4296 = (state_4310[(9)]);
var inst_4296__$1 = (state_4310[(2)]);
var inst_4297 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_4296__$1);
var state_4310__$1 = (function (){var statearr_4316 = state_4310;
(statearr_4316[(9)] = inst_4296__$1);

return statearr_4316;
})();
if(cljs.core.truth_(inst_4297)){
var statearr_4317_4350 = state_4310__$1;
(statearr_4317_4350[(1)] = (14));

} else {
var statearr_4318_4351 = state_4310__$1;
(statearr_4318_4351[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (6))){
var state_4310__$1 = state_4310;
var statearr_4319_4352 = state_4310__$1;
(statearr_4319_4352[(2)] = null);

(statearr_4319_4352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (17))){
var inst_4303 = (state_4310[(2)]);
var state_4310__$1 = (function (){var statearr_4321 = state_4310;
(statearr_4321[(10)] = inst_4303);

return statearr_4321;
})();
var statearr_4322_4353 = state_4310__$1;
(statearr_4322_4353[(2)] = null);

(statearr_4322_4353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (3))){
var inst_4308 = (state_4310[(2)]);
var state_4310__$1 = state_4310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4310__$1,inst_4308);
} else {
if((state_val_4311 === (12))){
var _ = (function (){var statearr_4323 = state_4310;
(statearr_4323[(4)] = cljs.core.rest.call(null,(state_4310[(4)])));

return statearr_4323;
})();
var state_4310__$1 = state_4310;
var ex4320 = (state_4310__$1[(2)]);
var statearr_4324_4354 = state_4310__$1;
(statearr_4324_4354[(5)] = ex4320);


if((ex4320 instanceof Object)){
var statearr_4325_4355 = state_4310__$1;
(statearr_4325_4355[(1)] = (11));

(statearr_4325_4355[(5)] = null);

} else {
throw ex4320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (2))){
var inst_4269 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_4270 = cnt;
var inst_4271 = (0);
var state_4310__$1 = (function (){var statearr_4326 = state_4310;
(statearr_4326[(7)] = inst_4271);

(statearr_4326[(11)] = inst_4269);

(statearr_4326[(8)] = inst_4270);

return statearr_4326;
})();
var statearr_4327_4356 = state_4310__$1;
(statearr_4327_4356[(2)] = null);

(statearr_4327_4356[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (11))){
var inst_4275 = (state_4310[(2)]);
var inst_4276 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_4310__$1 = (function (){var statearr_4328 = state_4310;
(statearr_4328[(12)] = inst_4275);

return statearr_4328;
})();
var statearr_4329_4357 = state_4310__$1;
(statearr_4329_4357[(2)] = inst_4276);

(statearr_4329_4357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (9))){
var inst_4271 = (state_4310[(7)]);
var _ = (function (){var statearr_4330 = state_4310;
(statearr_4330[(4)] = cljs.core.cons.call(null,(12),(state_4310[(4)])));

return statearr_4330;
})();
var inst_4282 = chs__$1.call(null,inst_4271);
var inst_4283 = done.call(null,inst_4271);
var inst_4284 = cljs.core.async.take_BANG_.call(null,inst_4282,inst_4283);
var ___$1 = (function (){var statearr_4331 = state_4310;
(statearr_4331[(4)] = cljs.core.rest.call(null,(state_4310[(4)])));

return statearr_4331;
})();
var state_4310__$1 = state_4310;
var statearr_4332_4358 = state_4310__$1;
(statearr_4332_4358[(2)] = inst_4284);

(statearr_4332_4358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (5))){
var inst_4294 = (state_4310[(2)]);
var state_4310__$1 = (function (){var statearr_4333 = state_4310;
(statearr_4333[(13)] = inst_4294);

return statearr_4333;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4310__$1,(13),dchan);
} else {
if((state_val_4311 === (14))){
var inst_4299 = cljs.core.async.close_BANG_.call(null,out);
var state_4310__$1 = state_4310;
var statearr_4334_4359 = state_4310__$1;
(statearr_4334_4359[(2)] = inst_4299);

(statearr_4334_4359[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (16))){
var inst_4306 = (state_4310[(2)]);
var state_4310__$1 = state_4310;
var statearr_4335_4360 = state_4310__$1;
(statearr_4335_4360[(2)] = inst_4306);

(statearr_4335_4360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (10))){
var inst_4271 = (state_4310[(7)]);
var inst_4287 = (state_4310[(2)]);
var inst_4288 = (inst_4271 + (1));
var inst_4271__$1 = inst_4288;
var state_4310__$1 = (function (){var statearr_4336 = state_4310;
(statearr_4336[(7)] = inst_4271__$1);

(statearr_4336[(14)] = inst_4287);

return statearr_4336;
})();
var statearr_4337_4361 = state_4310__$1;
(statearr_4337_4361[(2)] = null);

(statearr_4337_4361[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4311 === (8))){
var inst_4292 = (state_4310[(2)]);
var state_4310__$1 = state_4310;
var statearr_4338_4362 = state_4310__$1;
(statearr_4338_4362[(2)] = inst_4292);

(statearr_4338_4362[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4339[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4339[(1)] = (1));

return statearr_4339;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4310){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4340){var ex__2887__auto__ = e4340;
var statearr_4341_4363 = state_4310;
(statearr_4341_4363[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4310[(4)]))){
var statearr_4342_4364 = state_4310;
(statearr_4342_4364[(1)] = cljs.core.first.call(null,(state_4310[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4365 = state_4310;
state_4310 = G__4365;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4310){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4343 = f__2958__auto__.call(null);
(statearr_4343[(6)] = c__2957__auto___4345);

return statearr_4343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__4368 = arguments.length;
switch (G__4368) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4423 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4400){
var state_val_4401 = (state_4400[(1)]);
if((state_val_4401 === (7))){
var inst_4379 = (state_4400[(7)]);
var inst_4380 = (state_4400[(8)]);
var inst_4379__$1 = (state_4400[(2)]);
var inst_4380__$1 = cljs.core.nth.call(null,inst_4379__$1,(0),null);
var inst_4381 = cljs.core.nth.call(null,inst_4379__$1,(1),null);
var inst_4382 = (inst_4380__$1 == null);
var state_4400__$1 = (function (){var statearr_4402 = state_4400;
(statearr_4402[(7)] = inst_4379__$1);

(statearr_4402[(9)] = inst_4381);

(statearr_4402[(8)] = inst_4380__$1);

return statearr_4402;
})();
if(cljs.core.truth_(inst_4382)){
var statearr_4403_4424 = state_4400__$1;
(statearr_4403_4424[(1)] = (8));

} else {
var statearr_4404_4425 = state_4400__$1;
(statearr_4404_4425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (1))){
var inst_4369 = cljs.core.vec.call(null,chs);
var inst_4370 = inst_4369;
var state_4400__$1 = (function (){var statearr_4405 = state_4400;
(statearr_4405[(10)] = inst_4370);

return statearr_4405;
})();
var statearr_4406_4426 = state_4400__$1;
(statearr_4406_4426[(2)] = null);

(statearr_4406_4426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (4))){
var inst_4370 = (state_4400[(10)]);
var state_4400__$1 = state_4400;
return cljs.core.async.ioc_alts_BANG_.call(null,state_4400__$1,(7),inst_4370);
} else {
if((state_val_4401 === (6))){
var inst_4396 = (state_4400[(2)]);
var state_4400__$1 = state_4400;
var statearr_4407_4427 = state_4400__$1;
(statearr_4407_4427[(2)] = inst_4396);

(statearr_4407_4427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (3))){
var inst_4398 = (state_4400[(2)]);
var state_4400__$1 = state_4400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4400__$1,inst_4398);
} else {
if((state_val_4401 === (2))){
var inst_4370 = (state_4400[(10)]);
var inst_4372 = cljs.core.count.call(null,inst_4370);
var inst_4373 = (inst_4372 > (0));
var state_4400__$1 = state_4400;
if(cljs.core.truth_(inst_4373)){
var statearr_4409_4428 = state_4400__$1;
(statearr_4409_4428[(1)] = (4));

} else {
var statearr_4410_4429 = state_4400__$1;
(statearr_4410_4429[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (11))){
var inst_4370 = (state_4400[(10)]);
var inst_4389 = (state_4400[(2)]);
var tmp4408 = inst_4370;
var inst_4370__$1 = tmp4408;
var state_4400__$1 = (function (){var statearr_4411 = state_4400;
(statearr_4411[(11)] = inst_4389);

(statearr_4411[(10)] = inst_4370__$1);

return statearr_4411;
})();
var statearr_4412_4430 = state_4400__$1;
(statearr_4412_4430[(2)] = null);

(statearr_4412_4430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (9))){
var inst_4380 = (state_4400[(8)]);
var state_4400__$1 = state_4400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4400__$1,(11),out,inst_4380);
} else {
if((state_val_4401 === (5))){
var inst_4394 = cljs.core.async.close_BANG_.call(null,out);
var state_4400__$1 = state_4400;
var statearr_4413_4431 = state_4400__$1;
(statearr_4413_4431[(2)] = inst_4394);

(statearr_4413_4431[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (10))){
var inst_4392 = (state_4400[(2)]);
var state_4400__$1 = state_4400;
var statearr_4414_4432 = state_4400__$1;
(statearr_4414_4432[(2)] = inst_4392);

(statearr_4414_4432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4401 === (8))){
var inst_4379 = (state_4400[(7)]);
var inst_4381 = (state_4400[(9)]);
var inst_4380 = (state_4400[(8)]);
var inst_4370 = (state_4400[(10)]);
var inst_4384 = (function (){var cs = inst_4370;
var vec__4375 = inst_4379;
var v = inst_4380;
var c = inst_4381;
return (function (p1__4366_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__4366_SHARP_);
});
})();
var inst_4385 = cljs.core.filterv.call(null,inst_4384,inst_4370);
var inst_4370__$1 = inst_4385;
var state_4400__$1 = (function (){var statearr_4415 = state_4400;
(statearr_4415[(10)] = inst_4370__$1);

return statearr_4415;
})();
var statearr_4416_4433 = state_4400__$1;
(statearr_4416_4433[(2)] = null);

(statearr_4416_4433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4417 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4417[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4417[(1)] = (1));

return statearr_4417;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4400){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4418){var ex__2887__auto__ = e4418;
var statearr_4419_4434 = state_4400;
(statearr_4419_4434[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4400[(4)]))){
var statearr_4420_4435 = state_4400;
(statearr_4420_4435[(1)] = cljs.core.first.call(null,(state_4400[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4436 = state_4400;
state_4400 = G__4436;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4421 = f__2958__auto__.call(null);
(statearr_4421[(6)] = c__2957__auto___4423);

return statearr_4421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__4438 = arguments.length;
switch (G__4438) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4484 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4462){
var state_val_4463 = (state_4462[(1)]);
if((state_val_4463 === (7))){
var inst_4444 = (state_4462[(7)]);
var inst_4444__$1 = (state_4462[(2)]);
var inst_4445 = (inst_4444__$1 == null);
var inst_4446 = cljs.core.not.call(null,inst_4445);
var state_4462__$1 = (function (){var statearr_4464 = state_4462;
(statearr_4464[(7)] = inst_4444__$1);

return statearr_4464;
})();
if(inst_4446){
var statearr_4465_4485 = state_4462__$1;
(statearr_4465_4485[(1)] = (8));

} else {
var statearr_4466_4486 = state_4462__$1;
(statearr_4466_4486[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (1))){
var inst_4439 = (0);
var state_4462__$1 = (function (){var statearr_4467 = state_4462;
(statearr_4467[(8)] = inst_4439);

return statearr_4467;
})();
var statearr_4468_4487 = state_4462__$1;
(statearr_4468_4487[(2)] = null);

(statearr_4468_4487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (4))){
var state_4462__$1 = state_4462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4462__$1,(7),ch);
} else {
if((state_val_4463 === (6))){
var inst_4457 = (state_4462[(2)]);
var state_4462__$1 = state_4462;
var statearr_4469_4488 = state_4462__$1;
(statearr_4469_4488[(2)] = inst_4457);

(statearr_4469_4488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (3))){
var inst_4459 = (state_4462[(2)]);
var inst_4460 = cljs.core.async.close_BANG_.call(null,out);
var state_4462__$1 = (function (){var statearr_4470 = state_4462;
(statearr_4470[(9)] = inst_4459);

return statearr_4470;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4462__$1,inst_4460);
} else {
if((state_val_4463 === (2))){
var inst_4439 = (state_4462[(8)]);
var inst_4441 = (inst_4439 < n);
var state_4462__$1 = state_4462;
if(cljs.core.truth_(inst_4441)){
var statearr_4471_4489 = state_4462__$1;
(statearr_4471_4489[(1)] = (4));

} else {
var statearr_4472_4490 = state_4462__$1;
(statearr_4472_4490[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (11))){
var inst_4439 = (state_4462[(8)]);
var inst_4449 = (state_4462[(2)]);
var inst_4450 = (inst_4439 + (1));
var inst_4439__$1 = inst_4450;
var state_4462__$1 = (function (){var statearr_4473 = state_4462;
(statearr_4473[(8)] = inst_4439__$1);

(statearr_4473[(10)] = inst_4449);

return statearr_4473;
})();
var statearr_4474_4491 = state_4462__$1;
(statearr_4474_4491[(2)] = null);

(statearr_4474_4491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (9))){
var state_4462__$1 = state_4462;
var statearr_4475_4492 = state_4462__$1;
(statearr_4475_4492[(2)] = null);

(statearr_4475_4492[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (5))){
var state_4462__$1 = state_4462;
var statearr_4476_4493 = state_4462__$1;
(statearr_4476_4493[(2)] = null);

(statearr_4476_4493[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (10))){
var inst_4454 = (state_4462[(2)]);
var state_4462__$1 = state_4462;
var statearr_4477_4494 = state_4462__$1;
(statearr_4477_4494[(2)] = inst_4454);

(statearr_4477_4494[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4463 === (8))){
var inst_4444 = (state_4462[(7)]);
var state_4462__$1 = state_4462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4462__$1,(11),out,inst_4444);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4478[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4478[(1)] = (1));

return statearr_4478;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4462){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4479){var ex__2887__auto__ = e4479;
var statearr_4480_4495 = state_4462;
(statearr_4480_4495[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4462[(4)]))){
var statearr_4481_4496 = state_4462;
(statearr_4481_4496[(1)] = cljs.core.first.call(null,(state_4462[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4497 = state_4462;
state_4462 = G__4497;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4482 = f__2958__auto__.call(null);
(statearr_4482[(6)] = c__2957__auto___4484);

return statearr_4482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4499 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4499 = (function (f,ch,meta4500){
this.f = f;
this.ch = ch;
this.meta4500 = meta4500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4501,meta4500__$1){
var self__ = this;
var _4501__$1 = this;
return (new cljs.core.async.t_cljs$core$async4499(self__.f,self__.ch,meta4500__$1));
}));

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4501){
var self__ = this;
var _4501__$1 = this;
return self__.meta4500;
}));

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4502 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4502 = (function (f,ch,meta4500,_,fn1,meta4503){
this.f = f;
this.ch = ch;
this.meta4500 = meta4500;
this._ = _;
this.fn1 = fn1;
this.meta4503 = meta4503;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4504,meta4503__$1){
var self__ = this;
var _4504__$1 = this;
return (new cljs.core.async.t_cljs$core$async4502(self__.f,self__.ch,self__.meta4500,self__._,self__.fn1,meta4503__$1));
}));

(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4504){
var self__ = this;
var _4504__$1 = this;
return self__.meta4503;
}));

(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async4502.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__4498_SHARP_){
return f1.call(null,(((p1__4498_SHARP_ == null))?null:self__.f.call(null,p1__4498_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async4502.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4500","meta4500",44349229,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async4499","cljs.core.async/t_cljs$core$async4499",-2082785608,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta4503","meta4503",1974366441,null)], null);
}));

(cljs.core.async.t_cljs$core$async4502.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4502.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4502");

(cljs.core.async.t_cljs$core$async4502.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4502");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4502.
 */
cljs.core.async.__GT_t_cljs$core$async4502 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4502(f__$1,ch__$1,meta4500__$1,___$2,fn1__$1,meta4503){
return (new cljs.core.async.t_cljs$core$async4502(f__$1,ch__$1,meta4500__$1,___$2,fn1__$1,meta4503));
});

}

return (new cljs.core.async.t_cljs$core$async4502(self__.f,self__.ch,self__.meta4500,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4499.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async4499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4500","meta4500",44349229,null)], null);
}));

(cljs.core.async.t_cljs$core$async4499.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4499.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4499");

(cljs.core.async.t_cljs$core$async4499.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4499");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4499.
 */
cljs.core.async.__GT_t_cljs$core$async4499 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4499(f__$1,ch__$1,meta4500){
return (new cljs.core.async.t_cljs$core$async4499(f__$1,ch__$1,meta4500));
});

}

return (new cljs.core.async.t_cljs$core$async4499(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4505 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4505 = (function (f,ch,meta4506){
this.f = f;
this.ch = ch;
this.meta4506 = meta4506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4507,meta4506__$1){
var self__ = this;
var _4507__$1 = this;
return (new cljs.core.async.t_cljs$core$async4505(self__.f,self__.ch,meta4506__$1));
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4507){
var self__ = this;
var _4507__$1 = this;
return self__.meta4506;
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async4505.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4506","meta4506",465705946,null)], null);
}));

(cljs.core.async.t_cljs$core$async4505.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4505");

(cljs.core.async.t_cljs$core$async4505.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4505");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4505.
 */
cljs.core.async.__GT_t_cljs$core$async4505 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async4505(f__$1,ch__$1,meta4506){
return (new cljs.core.async.t_cljs$core$async4505(f__$1,ch__$1,meta4506));
});

}

return (new cljs.core.async.t_cljs$core$async4505(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4508 = (function (p,ch,meta4509){
this.p = p;
this.ch = ch;
this.meta4509 = meta4509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4510,meta4509__$1){
var self__ = this;
var _4510__$1 = this;
return (new cljs.core.async.t_cljs$core$async4508(self__.p,self__.ch,meta4509__$1));
}));

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4510){
var self__ = this;
var _4510__$1 = this;
return self__.meta4509;
}));

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4508.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async4508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4509","meta4509",-32071364,null)], null);
}));

(cljs.core.async.t_cljs$core$async4508.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4508.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4508");

(cljs.core.async.t_cljs$core$async4508.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4508");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4508.
 */
cljs.core.async.__GT_t_cljs$core$async4508 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async4508(p__$1,ch__$1,meta4509){
return (new cljs.core.async.t_cljs$core$async4508(p__$1,ch__$1,meta4509));
});

}

return (new cljs.core.async.t_cljs$core$async4508(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__4512 = arguments.length;
switch (G__4512) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4533){
var state_val_4534 = (state_4533[(1)]);
if((state_val_4534 === (7))){
var inst_4529 = (state_4533[(2)]);
var state_4533__$1 = state_4533;
var statearr_4535_4554 = state_4533__$1;
(statearr_4535_4554[(2)] = inst_4529);

(statearr_4535_4554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (1))){
var state_4533__$1 = state_4533;
var statearr_4536_4555 = state_4533__$1;
(statearr_4536_4555[(2)] = null);

(statearr_4536_4555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (4))){
var inst_4515 = (state_4533[(7)]);
var inst_4515__$1 = (state_4533[(2)]);
var inst_4516 = (inst_4515__$1 == null);
var state_4533__$1 = (function (){var statearr_4537 = state_4533;
(statearr_4537[(7)] = inst_4515__$1);

return statearr_4537;
})();
if(cljs.core.truth_(inst_4516)){
var statearr_4538_4556 = state_4533__$1;
(statearr_4538_4556[(1)] = (5));

} else {
var statearr_4539_4557 = state_4533__$1;
(statearr_4539_4557[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (6))){
var inst_4515 = (state_4533[(7)]);
var inst_4520 = p.call(null,inst_4515);
var state_4533__$1 = state_4533;
if(cljs.core.truth_(inst_4520)){
var statearr_4540_4558 = state_4533__$1;
(statearr_4540_4558[(1)] = (8));

} else {
var statearr_4541_4559 = state_4533__$1;
(statearr_4541_4559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (3))){
var inst_4531 = (state_4533[(2)]);
var state_4533__$1 = state_4533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4533__$1,inst_4531);
} else {
if((state_val_4534 === (2))){
var state_4533__$1 = state_4533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4533__$1,(4),ch);
} else {
if((state_val_4534 === (11))){
var inst_4523 = (state_4533[(2)]);
var state_4533__$1 = state_4533;
var statearr_4542_4560 = state_4533__$1;
(statearr_4542_4560[(2)] = inst_4523);

(statearr_4542_4560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (9))){
var state_4533__$1 = state_4533;
var statearr_4543_4561 = state_4533__$1;
(statearr_4543_4561[(2)] = null);

(statearr_4543_4561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (5))){
var inst_4518 = cljs.core.async.close_BANG_.call(null,out);
var state_4533__$1 = state_4533;
var statearr_4544_4562 = state_4533__$1;
(statearr_4544_4562[(2)] = inst_4518);

(statearr_4544_4562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (10))){
var inst_4526 = (state_4533[(2)]);
var state_4533__$1 = (function (){var statearr_4545 = state_4533;
(statearr_4545[(8)] = inst_4526);

return statearr_4545;
})();
var statearr_4546_4563 = state_4533__$1;
(statearr_4546_4563[(2)] = null);

(statearr_4546_4563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4534 === (8))){
var inst_4515 = (state_4533[(7)]);
var state_4533__$1 = state_4533;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4533__$1,(11),out,inst_4515);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4547 = [null,null,null,null,null,null,null,null,null];
(statearr_4547[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4547[(1)] = (1));

return statearr_4547;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4533){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4548){var ex__2887__auto__ = e4548;
var statearr_4549_4564 = state_4533;
(statearr_4549_4564[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4533[(4)]))){
var statearr_4550_4565 = state_4533;
(statearr_4550_4565[(1)] = cljs.core.first.call(null,(state_4533[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4566 = state_4533;
state_4533 = G__4566;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4533){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4551 = f__2958__auto__.call(null);
(statearr_4551[(6)] = c__2957__auto___4553);

return statearr_4551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__4568 = arguments.length;
switch (G__4568) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__2957__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4631){
var state_val_4632 = (state_4631[(1)]);
if((state_val_4632 === (7))){
var inst_4627 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
var statearr_4633_4672 = state_4631__$1;
(statearr_4633_4672[(2)] = inst_4627);

(statearr_4633_4672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (20))){
var inst_4597 = (state_4631[(7)]);
var inst_4608 = (state_4631[(2)]);
var inst_4609 = cljs.core.next.call(null,inst_4597);
var inst_4583 = inst_4609;
var inst_4584 = null;
var inst_4585 = (0);
var inst_4586 = (0);
var state_4631__$1 = (function (){var statearr_4634 = state_4631;
(statearr_4634[(8)] = inst_4583);

(statearr_4634[(9)] = inst_4586);

(statearr_4634[(10)] = inst_4585);

(statearr_4634[(11)] = inst_4584);

(statearr_4634[(12)] = inst_4608);

return statearr_4634;
})();
var statearr_4635_4673 = state_4631__$1;
(statearr_4635_4673[(2)] = null);

(statearr_4635_4673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (1))){
var state_4631__$1 = state_4631;
var statearr_4636_4674 = state_4631__$1;
(statearr_4636_4674[(2)] = null);

(statearr_4636_4674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (4))){
var inst_4572 = (state_4631[(13)]);
var inst_4572__$1 = (state_4631[(2)]);
var inst_4573 = (inst_4572__$1 == null);
var state_4631__$1 = (function (){var statearr_4637 = state_4631;
(statearr_4637[(13)] = inst_4572__$1);

return statearr_4637;
})();
if(cljs.core.truth_(inst_4573)){
var statearr_4638_4675 = state_4631__$1;
(statearr_4638_4675[(1)] = (5));

} else {
var statearr_4639_4676 = state_4631__$1;
(statearr_4639_4676[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (15))){
var state_4631__$1 = state_4631;
var statearr_4643_4677 = state_4631__$1;
(statearr_4643_4677[(2)] = null);

(statearr_4643_4677[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (21))){
var state_4631__$1 = state_4631;
var statearr_4644_4678 = state_4631__$1;
(statearr_4644_4678[(2)] = null);

(statearr_4644_4678[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (13))){
var inst_4583 = (state_4631[(8)]);
var inst_4586 = (state_4631[(9)]);
var inst_4585 = (state_4631[(10)]);
var inst_4584 = (state_4631[(11)]);
var inst_4593 = (state_4631[(2)]);
var inst_4594 = (inst_4586 + (1));
var tmp4640 = inst_4583;
var tmp4641 = inst_4585;
var tmp4642 = inst_4584;
var inst_4583__$1 = tmp4640;
var inst_4584__$1 = tmp4642;
var inst_4585__$1 = tmp4641;
var inst_4586__$1 = inst_4594;
var state_4631__$1 = (function (){var statearr_4645 = state_4631;
(statearr_4645[(14)] = inst_4593);

(statearr_4645[(8)] = inst_4583__$1);

(statearr_4645[(9)] = inst_4586__$1);

(statearr_4645[(10)] = inst_4585__$1);

(statearr_4645[(11)] = inst_4584__$1);

return statearr_4645;
})();
var statearr_4646_4679 = state_4631__$1;
(statearr_4646_4679[(2)] = null);

(statearr_4646_4679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (22))){
var state_4631__$1 = state_4631;
var statearr_4647_4680 = state_4631__$1;
(statearr_4647_4680[(2)] = null);

(statearr_4647_4680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (6))){
var inst_4572 = (state_4631[(13)]);
var inst_4581 = f.call(null,inst_4572);
var inst_4582 = cljs.core.seq.call(null,inst_4581);
var inst_4583 = inst_4582;
var inst_4584 = null;
var inst_4585 = (0);
var inst_4586 = (0);
var state_4631__$1 = (function (){var statearr_4648 = state_4631;
(statearr_4648[(8)] = inst_4583);

(statearr_4648[(9)] = inst_4586);

(statearr_4648[(10)] = inst_4585);

(statearr_4648[(11)] = inst_4584);

return statearr_4648;
})();
var statearr_4649_4681 = state_4631__$1;
(statearr_4649_4681[(2)] = null);

(statearr_4649_4681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (17))){
var inst_4597 = (state_4631[(7)]);
var inst_4601 = cljs.core.chunk_first.call(null,inst_4597);
var inst_4602 = cljs.core.chunk_rest.call(null,inst_4597);
var inst_4603 = cljs.core.count.call(null,inst_4601);
var inst_4583 = inst_4602;
var inst_4584 = inst_4601;
var inst_4585 = inst_4603;
var inst_4586 = (0);
var state_4631__$1 = (function (){var statearr_4650 = state_4631;
(statearr_4650[(8)] = inst_4583);

(statearr_4650[(9)] = inst_4586);

(statearr_4650[(10)] = inst_4585);

(statearr_4650[(11)] = inst_4584);

return statearr_4650;
})();
var statearr_4651_4682 = state_4631__$1;
(statearr_4651_4682[(2)] = null);

(statearr_4651_4682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (3))){
var inst_4629 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4631__$1,inst_4629);
} else {
if((state_val_4632 === (12))){
var inst_4617 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
var statearr_4652_4683 = state_4631__$1;
(statearr_4652_4683[(2)] = inst_4617);

(statearr_4652_4683[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (2))){
var state_4631__$1 = state_4631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4631__$1,(4),in$);
} else {
if((state_val_4632 === (23))){
var inst_4625 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
var statearr_4653_4684 = state_4631__$1;
(statearr_4653_4684[(2)] = inst_4625);

(statearr_4653_4684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (19))){
var inst_4612 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
var statearr_4654_4685 = state_4631__$1;
(statearr_4654_4685[(2)] = inst_4612);

(statearr_4654_4685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (11))){
var inst_4583 = (state_4631[(8)]);
var inst_4597 = (state_4631[(7)]);
var inst_4597__$1 = cljs.core.seq.call(null,inst_4583);
var state_4631__$1 = (function (){var statearr_4655 = state_4631;
(statearr_4655[(7)] = inst_4597__$1);

return statearr_4655;
})();
if(inst_4597__$1){
var statearr_4656_4686 = state_4631__$1;
(statearr_4656_4686[(1)] = (14));

} else {
var statearr_4657_4687 = state_4631__$1;
(statearr_4657_4687[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (9))){
var inst_4619 = (state_4631[(2)]);
var inst_4620 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_4631__$1 = (function (){var statearr_4658 = state_4631;
(statearr_4658[(15)] = inst_4619);

return statearr_4658;
})();
if(cljs.core.truth_(inst_4620)){
var statearr_4659_4688 = state_4631__$1;
(statearr_4659_4688[(1)] = (21));

} else {
var statearr_4660_4689 = state_4631__$1;
(statearr_4660_4689[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (5))){
var inst_4575 = cljs.core.async.close_BANG_.call(null,out);
var state_4631__$1 = state_4631;
var statearr_4661_4690 = state_4631__$1;
(statearr_4661_4690[(2)] = inst_4575);

(statearr_4661_4690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (14))){
var inst_4597 = (state_4631[(7)]);
var inst_4599 = cljs.core.chunked_seq_QMARK_.call(null,inst_4597);
var state_4631__$1 = state_4631;
if(inst_4599){
var statearr_4662_4691 = state_4631__$1;
(statearr_4662_4691[(1)] = (17));

} else {
var statearr_4663_4692 = state_4631__$1;
(statearr_4663_4692[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (16))){
var inst_4615 = (state_4631[(2)]);
var state_4631__$1 = state_4631;
var statearr_4664_4693 = state_4631__$1;
(statearr_4664_4693[(2)] = inst_4615);

(statearr_4664_4693[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4632 === (10))){
var inst_4586 = (state_4631[(9)]);
var inst_4584 = (state_4631[(11)]);
var inst_4591 = cljs.core._nth.call(null,inst_4584,inst_4586);
var state_4631__$1 = state_4631;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4631__$1,(13),out,inst_4591);
} else {
if((state_val_4632 === (18))){
var inst_4597 = (state_4631[(7)]);
var inst_4606 = cljs.core.first.call(null,inst_4597);
var state_4631__$1 = state_4631;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4631__$1,(20),out,inst_4606);
} else {
if((state_val_4632 === (8))){
var inst_4586 = (state_4631[(9)]);
var inst_4585 = (state_4631[(10)]);
var inst_4588 = (inst_4586 < inst_4585);
var inst_4589 = inst_4588;
var state_4631__$1 = state_4631;
if(cljs.core.truth_(inst_4589)){
var statearr_4665_4694 = state_4631__$1;
(statearr_4665_4694[(1)] = (10));

} else {
var statearr_4666_4695 = state_4631__$1;
(statearr_4666_4695[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____0 = (function (){
var statearr_4667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4667[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__);

(statearr_4667[(1)] = (1));

return statearr_4667;
});
var cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____1 = (function (state_4631){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4668){var ex__2887__auto__ = e4668;
var statearr_4669_4696 = state_4631;
(statearr_4669_4696[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4631[(4)]))){
var statearr_4670_4697 = state_4631;
(statearr_4670_4697[(1)] = cljs.core.first.call(null,(state_4631[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4698 = state_4631;
state_4631 = G__4698;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__ = function(state_4631){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____1.call(this,state_4631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__2884__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4671 = f__2958__auto__.call(null);
(statearr_4671[(6)] = c__2957__auto__);

return statearr_4671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));

return c__2957__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__4700 = arguments.length;
switch (G__4700) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__4703 = arguments.length;
switch (G__4703) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__4706 = arguments.length;
switch (G__4706) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4730){
var state_val_4731 = (state_4730[(1)]);
if((state_val_4731 === (7))){
var inst_4725 = (state_4730[(2)]);
var state_4730__$1 = state_4730;
var statearr_4732_4755 = state_4730__$1;
(statearr_4732_4755[(2)] = inst_4725);

(statearr_4732_4755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (1))){
var inst_4707 = null;
var state_4730__$1 = (function (){var statearr_4733 = state_4730;
(statearr_4733[(7)] = inst_4707);

return statearr_4733;
})();
var statearr_4734_4756 = state_4730__$1;
(statearr_4734_4756[(2)] = null);

(statearr_4734_4756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (4))){
var inst_4710 = (state_4730[(8)]);
var inst_4710__$1 = (state_4730[(2)]);
var inst_4711 = (inst_4710__$1 == null);
var inst_4712 = cljs.core.not.call(null,inst_4711);
var state_4730__$1 = (function (){var statearr_4735 = state_4730;
(statearr_4735[(8)] = inst_4710__$1);

return statearr_4735;
})();
if(inst_4712){
var statearr_4736_4757 = state_4730__$1;
(statearr_4736_4757[(1)] = (5));

} else {
var statearr_4737_4758 = state_4730__$1;
(statearr_4737_4758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (6))){
var state_4730__$1 = state_4730;
var statearr_4738_4759 = state_4730__$1;
(statearr_4738_4759[(2)] = null);

(statearr_4738_4759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (3))){
var inst_4727 = (state_4730[(2)]);
var inst_4728 = cljs.core.async.close_BANG_.call(null,out);
var state_4730__$1 = (function (){var statearr_4739 = state_4730;
(statearr_4739[(9)] = inst_4727);

return statearr_4739;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4730__$1,inst_4728);
} else {
if((state_val_4731 === (2))){
var state_4730__$1 = state_4730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4730__$1,(4),ch);
} else {
if((state_val_4731 === (11))){
var inst_4710 = (state_4730[(8)]);
var inst_4719 = (state_4730[(2)]);
var inst_4707 = inst_4710;
var state_4730__$1 = (function (){var statearr_4740 = state_4730;
(statearr_4740[(7)] = inst_4707);

(statearr_4740[(10)] = inst_4719);

return statearr_4740;
})();
var statearr_4741_4760 = state_4730__$1;
(statearr_4741_4760[(2)] = null);

(statearr_4741_4760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (9))){
var inst_4710 = (state_4730[(8)]);
var state_4730__$1 = state_4730;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4730__$1,(11),out,inst_4710);
} else {
if((state_val_4731 === (5))){
var inst_4707 = (state_4730[(7)]);
var inst_4710 = (state_4730[(8)]);
var inst_4714 = cljs.core._EQ_.call(null,inst_4710,inst_4707);
var state_4730__$1 = state_4730;
if(inst_4714){
var statearr_4743_4761 = state_4730__$1;
(statearr_4743_4761[(1)] = (8));

} else {
var statearr_4744_4762 = state_4730__$1;
(statearr_4744_4762[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (10))){
var inst_4722 = (state_4730[(2)]);
var state_4730__$1 = state_4730;
var statearr_4745_4763 = state_4730__$1;
(statearr_4745_4763[(2)] = inst_4722);

(statearr_4745_4763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4731 === (8))){
var inst_4707 = (state_4730[(7)]);
var tmp4742 = inst_4707;
var inst_4707__$1 = tmp4742;
var state_4730__$1 = (function (){var statearr_4746 = state_4730;
(statearr_4746[(7)] = inst_4707__$1);

return statearr_4746;
})();
var statearr_4747_4764 = state_4730__$1;
(statearr_4747_4764[(2)] = null);

(statearr_4747_4764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4748 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4748[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4748[(1)] = (1));

return statearr_4748;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4730){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4749){var ex__2887__auto__ = e4749;
var statearr_4750_4765 = state_4730;
(statearr_4750_4765[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4730[(4)]))){
var statearr_4751_4766 = state_4730;
(statearr_4751_4766[(1)] = cljs.core.first.call(null,(state_4730[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4767 = state_4730;
state_4730 = G__4767;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4730){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4752 = f__2958__auto__.call(null);
(statearr_4752[(6)] = c__2957__auto___4754);

return statearr_4752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__4769 = arguments.length;
switch (G__4769) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4807){
var state_val_4808 = (state_4807[(1)]);
if((state_val_4808 === (7))){
var inst_4803 = (state_4807[(2)]);
var state_4807__$1 = state_4807;
var statearr_4809_4837 = state_4807__$1;
(statearr_4809_4837[(2)] = inst_4803);

(statearr_4809_4837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (1))){
var inst_4770 = (new Array(n));
var inst_4771 = inst_4770;
var inst_4772 = (0);
var state_4807__$1 = (function (){var statearr_4810 = state_4807;
(statearr_4810[(7)] = inst_4772);

(statearr_4810[(8)] = inst_4771);

return statearr_4810;
})();
var statearr_4811_4838 = state_4807__$1;
(statearr_4811_4838[(2)] = null);

(statearr_4811_4838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (4))){
var inst_4775 = (state_4807[(9)]);
var inst_4775__$1 = (state_4807[(2)]);
var inst_4776 = (inst_4775__$1 == null);
var inst_4777 = cljs.core.not.call(null,inst_4776);
var state_4807__$1 = (function (){var statearr_4812 = state_4807;
(statearr_4812[(9)] = inst_4775__$1);

return statearr_4812;
})();
if(inst_4777){
var statearr_4813_4839 = state_4807__$1;
(statearr_4813_4839[(1)] = (5));

} else {
var statearr_4814_4840 = state_4807__$1;
(statearr_4814_4840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (15))){
var inst_4797 = (state_4807[(2)]);
var state_4807__$1 = state_4807;
var statearr_4815_4841 = state_4807__$1;
(statearr_4815_4841[(2)] = inst_4797);

(statearr_4815_4841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (13))){
var state_4807__$1 = state_4807;
var statearr_4816_4842 = state_4807__$1;
(statearr_4816_4842[(2)] = null);

(statearr_4816_4842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (6))){
var inst_4772 = (state_4807[(7)]);
var inst_4793 = (inst_4772 > (0));
var state_4807__$1 = state_4807;
if(cljs.core.truth_(inst_4793)){
var statearr_4817_4843 = state_4807__$1;
(statearr_4817_4843[(1)] = (12));

} else {
var statearr_4818_4844 = state_4807__$1;
(statearr_4818_4844[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (3))){
var inst_4805 = (state_4807[(2)]);
var state_4807__$1 = state_4807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4807__$1,inst_4805);
} else {
if((state_val_4808 === (12))){
var inst_4771 = (state_4807[(8)]);
var inst_4795 = cljs.core.vec.call(null,inst_4771);
var state_4807__$1 = state_4807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4807__$1,(15),out,inst_4795);
} else {
if((state_val_4808 === (2))){
var state_4807__$1 = state_4807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4807__$1,(4),ch);
} else {
if((state_val_4808 === (11))){
var inst_4787 = (state_4807[(2)]);
var inst_4788 = (new Array(n));
var inst_4771 = inst_4788;
var inst_4772 = (0);
var state_4807__$1 = (function (){var statearr_4819 = state_4807;
(statearr_4819[(7)] = inst_4772);

(statearr_4819[(10)] = inst_4787);

(statearr_4819[(8)] = inst_4771);

return statearr_4819;
})();
var statearr_4820_4845 = state_4807__$1;
(statearr_4820_4845[(2)] = null);

(statearr_4820_4845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (9))){
var inst_4771 = (state_4807[(8)]);
var inst_4785 = cljs.core.vec.call(null,inst_4771);
var state_4807__$1 = state_4807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4807__$1,(11),out,inst_4785);
} else {
if((state_val_4808 === (5))){
var inst_4772 = (state_4807[(7)]);
var inst_4775 = (state_4807[(9)]);
var inst_4780 = (state_4807[(11)]);
var inst_4771 = (state_4807[(8)]);
var inst_4779 = (inst_4771[inst_4772] = inst_4775);
var inst_4780__$1 = (inst_4772 + (1));
var inst_4781 = (inst_4780__$1 < n);
var state_4807__$1 = (function (){var statearr_4821 = state_4807;
(statearr_4821[(12)] = inst_4779);

(statearr_4821[(11)] = inst_4780__$1);

return statearr_4821;
})();
if(cljs.core.truth_(inst_4781)){
var statearr_4822_4846 = state_4807__$1;
(statearr_4822_4846[(1)] = (8));

} else {
var statearr_4823_4847 = state_4807__$1;
(statearr_4823_4847[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (14))){
var inst_4800 = (state_4807[(2)]);
var inst_4801 = cljs.core.async.close_BANG_.call(null,out);
var state_4807__$1 = (function (){var statearr_4825 = state_4807;
(statearr_4825[(13)] = inst_4800);

return statearr_4825;
})();
var statearr_4826_4848 = state_4807__$1;
(statearr_4826_4848[(2)] = inst_4801);

(statearr_4826_4848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (10))){
var inst_4791 = (state_4807[(2)]);
var state_4807__$1 = state_4807;
var statearr_4827_4849 = state_4807__$1;
(statearr_4827_4849[(2)] = inst_4791);

(statearr_4827_4849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4808 === (8))){
var inst_4780 = (state_4807[(11)]);
var inst_4771 = (state_4807[(8)]);
var tmp4824 = inst_4771;
var inst_4771__$1 = tmp4824;
var inst_4772 = inst_4780;
var state_4807__$1 = (function (){var statearr_4828 = state_4807;
(statearr_4828[(7)] = inst_4772);

(statearr_4828[(8)] = inst_4771__$1);

return statearr_4828;
})();
var statearr_4829_4850 = state_4807__$1;
(statearr_4829_4850[(2)] = null);

(statearr_4829_4850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4830[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4830[(1)] = (1));

return statearr_4830;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4807){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4831){var ex__2887__auto__ = e4831;
var statearr_4832_4851 = state_4807;
(statearr_4832_4851[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4807[(4)]))){
var statearr_4833_4852 = state_4807;
(statearr_4833_4852[(1)] = cljs.core.first.call(null,(state_4807[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4853 = state_4807;
state_4807 = G__4853;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4807){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4834 = f__2958__auto__.call(null);
(statearr_4834[(6)] = c__2957__auto___4836);

return statearr_4834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__4855 = arguments.length;
switch (G__4855) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2957__auto___4926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2958__auto__ = (function (){var switch__2883__auto__ = (function (state_4897){
var state_val_4898 = (state_4897[(1)]);
if((state_val_4898 === (7))){
var inst_4893 = (state_4897[(2)]);
var state_4897__$1 = state_4897;
var statearr_4899_4927 = state_4897__$1;
(statearr_4899_4927[(2)] = inst_4893);

(statearr_4899_4927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (1))){
var inst_4856 = [];
var inst_4857 = inst_4856;
var inst_4858 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_4897__$1 = (function (){var statearr_4900 = state_4897;
(statearr_4900[(7)] = inst_4858);

(statearr_4900[(8)] = inst_4857);

return statearr_4900;
})();
var statearr_4901_4928 = state_4897__$1;
(statearr_4901_4928[(2)] = null);

(statearr_4901_4928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (4))){
var inst_4861 = (state_4897[(9)]);
var inst_4861__$1 = (state_4897[(2)]);
var inst_4862 = (inst_4861__$1 == null);
var inst_4863 = cljs.core.not.call(null,inst_4862);
var state_4897__$1 = (function (){var statearr_4902 = state_4897;
(statearr_4902[(9)] = inst_4861__$1);

return statearr_4902;
})();
if(inst_4863){
var statearr_4903_4929 = state_4897__$1;
(statearr_4903_4929[(1)] = (5));

} else {
var statearr_4904_4930 = state_4897__$1;
(statearr_4904_4930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (15))){
var inst_4887 = (state_4897[(2)]);
var state_4897__$1 = state_4897;
var statearr_4905_4931 = state_4897__$1;
(statearr_4905_4931[(2)] = inst_4887);

(statearr_4905_4931[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (13))){
var state_4897__$1 = state_4897;
var statearr_4906_4932 = state_4897__$1;
(statearr_4906_4932[(2)] = null);

(statearr_4906_4932[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (6))){
var inst_4857 = (state_4897[(8)]);
var inst_4882 = inst_4857.length;
var inst_4883 = (inst_4882 > (0));
var state_4897__$1 = state_4897;
if(cljs.core.truth_(inst_4883)){
var statearr_4907_4933 = state_4897__$1;
(statearr_4907_4933[(1)] = (12));

} else {
var statearr_4908_4934 = state_4897__$1;
(statearr_4908_4934[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (3))){
var inst_4895 = (state_4897[(2)]);
var state_4897__$1 = state_4897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4897__$1,inst_4895);
} else {
if((state_val_4898 === (12))){
var inst_4857 = (state_4897[(8)]);
var inst_4885 = cljs.core.vec.call(null,inst_4857);
var state_4897__$1 = state_4897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4897__$1,(15),out,inst_4885);
} else {
if((state_val_4898 === (2))){
var state_4897__$1 = state_4897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4897__$1,(4),ch);
} else {
if((state_val_4898 === (11))){
var inst_4861 = (state_4897[(9)]);
var inst_4865 = (state_4897[(10)]);
var inst_4875 = (state_4897[(2)]);
var inst_4876 = [];
var inst_4877 = inst_4876.push(inst_4861);
var inst_4857 = inst_4876;
var inst_4858 = inst_4865;
var state_4897__$1 = (function (){var statearr_4909 = state_4897;
(statearr_4909[(11)] = inst_4875);

(statearr_4909[(7)] = inst_4858);

(statearr_4909[(12)] = inst_4877);

(statearr_4909[(8)] = inst_4857);

return statearr_4909;
})();
var statearr_4910_4935 = state_4897__$1;
(statearr_4910_4935[(2)] = null);

(statearr_4910_4935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (9))){
var inst_4857 = (state_4897[(8)]);
var inst_4873 = cljs.core.vec.call(null,inst_4857);
var state_4897__$1 = state_4897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4897__$1,(11),out,inst_4873);
} else {
if((state_val_4898 === (5))){
var inst_4861 = (state_4897[(9)]);
var inst_4858 = (state_4897[(7)]);
var inst_4865 = (state_4897[(10)]);
var inst_4865__$1 = f.call(null,inst_4861);
var inst_4866 = cljs.core._EQ_.call(null,inst_4865__$1,inst_4858);
var inst_4867 = cljs.core.keyword_identical_QMARK_.call(null,inst_4858,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_4868 = ((inst_4866) || (inst_4867));
var state_4897__$1 = (function (){var statearr_4911 = state_4897;
(statearr_4911[(10)] = inst_4865__$1);

return statearr_4911;
})();
if(cljs.core.truth_(inst_4868)){
var statearr_4912_4936 = state_4897__$1;
(statearr_4912_4936[(1)] = (8));

} else {
var statearr_4913_4937 = state_4897__$1;
(statearr_4913_4937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (14))){
var inst_4890 = (state_4897[(2)]);
var inst_4891 = cljs.core.async.close_BANG_.call(null,out);
var state_4897__$1 = (function (){var statearr_4915 = state_4897;
(statearr_4915[(13)] = inst_4890);

return statearr_4915;
})();
var statearr_4916_4938 = state_4897__$1;
(statearr_4916_4938[(2)] = inst_4891);

(statearr_4916_4938[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (10))){
var inst_4880 = (state_4897[(2)]);
var state_4897__$1 = state_4897;
var statearr_4917_4939 = state_4897__$1;
(statearr_4917_4939[(2)] = inst_4880);

(statearr_4917_4939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4898 === (8))){
var inst_4861 = (state_4897[(9)]);
var inst_4857 = (state_4897[(8)]);
var inst_4865 = (state_4897[(10)]);
var inst_4870 = inst_4857.push(inst_4861);
var tmp4914 = inst_4857;
var inst_4857__$1 = tmp4914;
var inst_4858 = inst_4865;
var state_4897__$1 = (function (){var statearr_4918 = state_4897;
(statearr_4918[(14)] = inst_4870);

(statearr_4918[(7)] = inst_4858);

(statearr_4918[(8)] = inst_4857__$1);

return statearr_4918;
})();
var statearr_4919_4940 = state_4897__$1;
(statearr_4919_4940[(2)] = null);

(statearr_4919_4940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__2884__auto__ = null;
var cljs$core$async$state_machine__2884__auto____0 = (function (){
var statearr_4920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4920[(0)] = cljs$core$async$state_machine__2884__auto__);

(statearr_4920[(1)] = (1));

return statearr_4920;
});
var cljs$core$async$state_machine__2884__auto____1 = (function (state_4897){
while(true){
var ret_value__2885__auto__ = (function (){try{while(true){
var result__2886__auto__ = switch__2883__auto__.call(null,state_4897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2886__auto__;
}
break;
}
}catch (e4921){var ex__2887__auto__ = e4921;
var statearr_4922_4941 = state_4897;
(statearr_4922_4941[(2)] = ex__2887__auto__);


if(cljs.core.seq.call(null,(state_4897[(4)]))){
var statearr_4923_4942 = state_4897;
(statearr_4923_4942[(1)] = cljs.core.first.call(null,(state_4897[(4)])));

} else {
throw ex__2887__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2885__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4943 = state_4897;
state_4897 = G__4943;
continue;
} else {
return ret_value__2885__auto__;
}
break;
}
});
cljs$core$async$state_machine__2884__auto__ = function(state_4897){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2884__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2884__auto____1.call(this,state_4897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2884__auto____0;
cljs$core$async$state_machine__2884__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2884__auto____1;
return cljs$core$async$state_machine__2884__auto__;
})()
})();
var state__2959__auto__ = (function (){var statearr_4924 = f__2958__auto__.call(null);
(statearr_4924[(6)] = c__2957__auto___4926);

return statearr_4924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2959__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
