// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('alphabase.bytes');
goog.require('cljs.core');
/**
 * Coerces a number to a byte value.
 */
alphabase.bytes.to_byte = (function alphabase$bytes$to_byte(x){
return x;
});
/**
 * Coerces a byte value to a number.
 */
alphabase.bytes.from_byte = (function alphabase$bytes$from_byte(x){
return x;
});
/**
 * Reads a byte value out of an array and coerces it to a number.
 */
alphabase.bytes.get_byte = (function alphabase$bytes$get_byte(array,i){
return alphabase.bytes.from_byte.call(null,(array[i]));
});
/**
 * Sets a byte value in an array after coercing it from a number.
 */
alphabase.bytes.set_byte = (function alphabase$bytes$set_byte(array,i,x){
return (array[i] = alphabase.bytes.to_byte.call(null,x));
});
/**
 * Return a sequence of the bytes in an array, after coercion.
 */
alphabase.bytes.byte_seq = (function alphabase$bytes$byte_seq(array){
if(cljs.core.truth_(array)){
return cljs.core.map.call(null,(function (p1__23683_SHARP_){
return (array[p1__23683_SHARP_]);
}),cljs.core.range.call(null,array.length));
} else {
return null;
}
});
/**
 * True if the argument is a byte array compatible with this library.
 */
alphabase.bytes.bytes_QMARK_ = (function alphabase$bytes$bytes_QMARK_(x){
return (((x instanceof Uint8Array)) || ((((x instanceof Array)) && (((cljs.core.empty_QMARK_.call(null,x)) || (cljs.core.integer_QMARK_.call(null,cljs.core.first.call(null,x))))))));
});
/**
 * Returns true if two byte sequences are the same length and have the same
 *   byte content.
 */
alphabase.bytes.bytes_EQ_ = (function alphabase$bytes$bytes_EQ_(a,b){
if(alphabase.bytes.bytes_QMARK_.call(null,a)){
if(alphabase.bytes.bytes_QMARK_.call(null,b)){
var a__$1 = a;
var b__$1 = b;
if(cljs.core._EQ_.call(null,a__$1.length,b__$1.length)){
var i = (0);
while(true){
if((i < a__$1.length)){
if(cljs.core._EQ_.call(null,alphabase.bytes.get_byte.call(null,a__$1,i),alphabase.bytes.get_byte.call(null,b__$1,i))){
var G__23684 = (i + (1));
i = G__23684;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
} else {
return false;
}
});
/**
 * Creates a new array to hold byte data.
 */
alphabase.bytes.byte_array = (function alphabase$bytes$byte_array(length){
return (new Uint8Array((new ArrayBuffer(length))));
});
/**
 * Copies bytes from one array to another.
 * 
 *   - If only a source is given, returns a full copy of the byte array.
 *   - If a source and a destination with offset are given, copies all of the
 *  bytes from the source into the destination at that offset. Returns the
 *  number of bytes copied.
 *   - If all arguments are given, copies `length` bytes from the source at the
 *  given offset to the destination at its offset. Returns the number of bytes
 *  copied.
 */
alphabase.bytes.copy = (function alphabase$bytes$copy(var_args){
var G__23686 = arguments.length;
switch (G__23686) {
case 1:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1 = (function (src){
var dst = alphabase.bytes.byte_array.call(null,src.length);
alphabase.bytes.copy.call(null,src,dst,(0));

return dst;
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3 = (function (src,dst,dst_offset){
return alphabase.bytes.copy.call(null,src,(0),dst,dst_offset,src.length);
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5 = (function (src,src_offset,dst,dst_offset,length){
var n__4613__auto___23688 = length;
var i_23689 = (0);
while(true){
if((i_23689 < n__4613__auto___23688)){
alphabase.bytes.set_byte.call(null,dst,(i_23689 + dst_offset),alphabase.bytes.get_byte.call(null,src,(i_23689 + src_offset)));

var G__23690 = (i_23689 + (1));
i_23689 = G__23690;
continue;
} else {
}
break;
}

return length;
}));

(alphabase.bytes.copy.cljs$lang$maxFixedArity = 5);

/**
 * Initialize a new array with the given sequence of byte values.
 */
alphabase.bytes.init_bytes = (function alphabase$bytes$init_bytes(values){
var length = cljs.core.count.call(null,values);
var data = alphabase.bytes.byte_array.call(null,length);
var n__4613__auto___23691 = length;
var i_23692 = (0);
while(true){
if((i_23692 < n__4613__auto___23691)){
alphabase.bytes.set_byte.call(null,data,i_23692,cljs.core.nth.call(null,values,i_23692));

var G__23693 = (i_23692 + (1));
i_23692 = G__23693;
continue;
} else {
}
break;
}

return data;
});
/**
 * Returns a byte array `length` bytes long with random content.
 */
alphabase.bytes.random_bytes = (function alphabase$bytes$random_bytes(length){
var data = alphabase.bytes.byte_array.call(null,length);
var n__4613__auto___23694 = length;
var i_23695 = (0);
while(true){
if((i_23695 < n__4613__auto___23694)){
alphabase.bytes.set_byte.call(null,data,i_23695,cljs.core.rand_int.call(null,(256)));

var G__23696 = (i_23695 + (1));
i_23695 = G__23696;
continue;
} else {
}
break;
}

return data;
});
/**
 * Lexicographically compares two byte-arrays for order. Returns a negative
 *   number, zero, or a positive number if `a` is less than, equal to, or greater
 *   than `b`, respectively.
 * 
 *   This ranking compares each byte in the keys in order; the first byte which
 *   differs determines the ordering; if the byte in `a` is less than the byte in
 *   `b`, `a` ranks before `b`, and vice versa.
 * 
 *   If the keys differ in length, and all the bytes in the shorter key match the
 *   longer key, the shorter key ranks first.
 */
alphabase.bytes.compare = (function alphabase$bytes$compare(a,b){
var prefix_len = (function (){var x__4217__auto__ = a.length;
var y__4218__auto__ = b.length;
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})();
var i = (0);
while(true){
if((i < prefix_len)){
var ai = alphabase.bytes.get_byte.call(null,a,i);
var bi = alphabase.bytes.get_byte.call(null,b,i);
if(cljs.core._EQ_.call(null,ai,bi)){
var G__23697 = (i + (1));
i = G__23697;
continue;
} else {
return (ai - bi);
}
} else {
return (a.length - b.length);
}
break;
}
});
/**
 * Copy a slice (defined by offset, length) from a byte array.
 * 
 *   Omitting the slice `len` argument will copy remainder of
 *   `src` array from offset (e.g, `(- (alength src) offset)` bytes).
 */
alphabase.bytes.copy_slice = (function alphabase$bytes$copy_slice(var_args){
var G__23699 = arguments.length;
switch (G__23699) {
case 3:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3 = (function (src,offset,len){
var dst = alphabase.bytes.byte_array.call(null,len);
alphabase.bytes.copy.call(null,src,offset,dst,(0),len);

return dst;
}));

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2 = (function (src,offset){
return alphabase.bytes.copy_slice.call(null,src,offset,(src.length - offset));
}));

(alphabase.bytes.copy_slice.cljs$lang$maxFixedArity = 3);

/**
 * Concatenate bytes arrays into a single new byte array.
 */
alphabase.bytes.concat = (function alphabase$bytes$concat(var_args){
var args__4742__auto__ = [];
var len__4736__auto___23703 = arguments.length;
var i__4737__auto___23704 = (0);
while(true){
if((i__4737__auto___23704 < len__4736__auto___23703)){
args__4742__auto__.push((arguments[i__4737__auto___23704]));

var G__23705 = (i__4737__auto___23704 + (1));
i__4737__auto___23704 = G__23705;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic = (function (arrs){
var arrs__$1 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,arrs);
var total_len = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,(function (p1__23701_SHARP_){
return p1__23701_SHARP_.length;
}),arrs__$1));
var dst = alphabase.bytes.byte_array.call(null,total_len);
var arrs_23706__$2 = arrs__$1;
var offset_23707 = (0);
while(true){
var temp__5735__auto___23708 = cljs.core.first.call(null,arrs_23706__$2);
if(cljs.core.truth_(temp__5735__auto___23708)){
var src_23709 = temp__5735__auto___23708;
alphabase.bytes.copy.call(null,src_23709,(0),dst,offset_23707,src_23709.length);

var G__23710 = cljs.core.rest.call(null,arrs_23706__$2);
var G__23711 = (offset_23707 + src_23709.length);
arrs_23706__$2 = G__23710;
offset_23707 = G__23711;
continue;
} else {
}
break;
}

return dst;
}));

(alphabase.bytes.concat.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(alphabase.bytes.concat.cljs$lang$applyTo = (function (seq23702){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23702));
}));


//# sourceMappingURL=bytes.js.map
