// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20025){
var state_val_20026 = (state_20025[(1)]);
if((state_val_20026 === (7))){
var inst_20014 = (state_20025[(7)]);
var inst_20016 = fluree.db.storage.core.serde(conn);
var inst_20017 = fluree.db.serde.protocol._deserialize_block(inst_20016,inst_20014);
var state_20025__$1 = state_20025;
var statearr_20027_20046 = state_20025__$1;
(statearr_20027_20046[(2)] = inst_20017);

(statearr_20027_20046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (1))){
var state_20025__$1 = state_20025;
var statearr_20028_20047 = state_20025__$1;
(statearr_20028_20047[(2)] = null);

(statearr_20028_20047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (4))){
var inst_20004 = (state_20025[(2)]);
var state_20025__$1 = state_20025;
var statearr_20029_20048 = state_20025__$1;
(statearr_20029_20048[(2)] = inst_20004);

(statearr_20029_20048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (6))){
var inst_20014 = (state_20025[(7)]);
var inst_20013 = (state_20025[(2)]);
var inst_20014__$1 = fluree.db.util.async.throw_err(inst_20013);
var state_20025__$1 = (function (){var statearr_20030 = state_20025;
(statearr_20030[(7)] = inst_20014__$1);

return statearr_20030;
})();
if(cljs.core.truth_(inst_20014__$1)){
var statearr_20031_20049 = state_20025__$1;
(statearr_20031_20049[(1)] = (7));

} else {
var statearr_20032_20050 = state_20025__$1;
(statearr_20032_20050[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (3))){
var inst_20023 = (state_20025[(2)]);
var state_20025__$1 = state_20025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20025__$1,inst_20023);
} else {
if((state_val_20026 === (2))){
var _ = (function (){var statearr_20034 = state_20025;
(statearr_20034[(4)] = cljs.core.cons((5),(state_20025[(4)])));

return statearr_20034;
})();
var inst_20010 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_20011 = fluree.db.storage.core.storage_read(conn,inst_20010);
var state_20025__$1 = state_20025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20025__$1,(6),inst_20011);
} else {
if((state_val_20026 === (9))){
var inst_20020 = (state_20025[(2)]);
var _ = (function (){var statearr_20035 = state_20025;
(statearr_20035[(4)] = cljs.core.rest((state_20025[(4)])));

return statearr_20035;
})();
var state_20025__$1 = state_20025;
var statearr_20036_20051 = state_20025__$1;
(statearr_20036_20051[(2)] = inst_20020);

(statearr_20036_20051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (5))){
var _ = (function (){var statearr_20037 = state_20025;
(statearr_20037[(4)] = cljs.core.rest((state_20025[(4)])));

return statearr_20037;
})();
var state_20025__$1 = state_20025;
var ex20033 = (state_20025__$1[(2)]);
var statearr_20038_20052 = state_20025__$1;
(statearr_20038_20052[(5)] = ex20033);


if((ex20033 instanceof Error)){
var statearr_20039_20053 = state_20025__$1;
(statearr_20039_20053[(1)] = (4));

(statearr_20039_20053[(5)] = null);

} else {
throw ex20033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20026 === (8))){
var state_20025__$1 = state_20025;
var statearr_20040_20054 = state_20025__$1;
(statearr_20040_20054[(2)] = null);

(statearr_20040_20054[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2879__auto____0 = (function (){
var statearr_20041 = [null,null,null,null,null,null,null,null];
(statearr_20041[(0)] = fluree$db$storage$core$read_block_$_state_machine__2879__auto__);

(statearr_20041[(1)] = (1));

return statearr_20041;
});
var fluree$db$storage$core$read_block_$_state_machine__2879__auto____1 = (function (state_20025){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20025);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20042){var ex__2882__auto__ = e20042;
var statearr_20043_20055 = state_20025;
(statearr_20043_20055[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20025[(4)]))){
var statearr_20044_20056 = state_20025;
(statearr_20044_20056[(1)] = cljs.core.first((state_20025[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20057 = state_20025;
state_20025 = G__20057;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2879__auto__ = function(state_20025){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2879__auto____1.call(this,state_20025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20045 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20045[(6)] = c__2901__auto__);

return statearr_20045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20080){
var state_val_20081 = (state_20080[(1)]);
if((state_val_20081 === (7))){
var inst_20069 = (state_20080[(7)]);
var inst_20071 = fluree.db.storage.core.serde(conn);
var inst_20072 = fluree.db.serde.protocol._deserialize_block(inst_20071,inst_20069);
var state_20080__$1 = state_20080;
var statearr_20082_20101 = state_20080__$1;
(statearr_20082_20101[(2)] = inst_20072);

(statearr_20082_20101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (1))){
var state_20080__$1 = state_20080;
var statearr_20083_20102 = state_20080__$1;
(statearr_20083_20102[(2)] = null);

(statearr_20083_20102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (4))){
var inst_20058 = (state_20080[(2)]);
var state_20080__$1 = state_20080;
var statearr_20084_20103 = state_20080__$1;
(statearr_20084_20103[(2)] = inst_20058);

(statearr_20084_20103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (6))){
var inst_20069 = (state_20080[(7)]);
var inst_20068 = (state_20080[(2)]);
var inst_20069__$1 = fluree.db.util.async.throw_err(inst_20068);
var state_20080__$1 = (function (){var statearr_20085 = state_20080;
(statearr_20085[(7)] = inst_20069__$1);

return statearr_20085;
})();
if(cljs.core.truth_(inst_20069__$1)){
var statearr_20086_20104 = state_20080__$1;
(statearr_20086_20104[(1)] = (7));

} else {
var statearr_20087_20105 = state_20080__$1;
(statearr_20087_20105[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (3))){
var inst_20078 = (state_20080[(2)]);
var state_20080__$1 = state_20080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20080__$1,inst_20078);
} else {
if((state_val_20081 === (2))){
var _ = (function (){var statearr_20089 = state_20080;
(statearr_20089[(4)] = cljs.core.cons((5),(state_20080[(4)])));

return statearr_20089;
})();
var inst_20064 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_20065 = [inst_20064,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20066 = fluree.db.storage.core.storage_read(conn,inst_20065);
var state_20080__$1 = state_20080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20080__$1,(6),inst_20066);
} else {
if((state_val_20081 === (9))){
var inst_20075 = (state_20080[(2)]);
var _ = (function (){var statearr_20090 = state_20080;
(statearr_20090[(4)] = cljs.core.rest((state_20080[(4)])));

return statearr_20090;
})();
var state_20080__$1 = state_20080;
var statearr_20091_20106 = state_20080__$1;
(statearr_20091_20106[(2)] = inst_20075);

(statearr_20091_20106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (5))){
var _ = (function (){var statearr_20092 = state_20080;
(statearr_20092[(4)] = cljs.core.rest((state_20080[(4)])));

return statearr_20092;
})();
var state_20080__$1 = state_20080;
var ex20088 = (state_20080__$1[(2)]);
var statearr_20093_20107 = state_20080__$1;
(statearr_20093_20107[(5)] = ex20088);


if((ex20088 instanceof Error)){
var statearr_20094_20108 = state_20080__$1;
(statearr_20094_20108[(1)] = (4));

(statearr_20094_20108[(5)] = null);

} else {
throw ex20088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20081 === (8))){
var state_20080__$1 = state_20080;
var statearr_20095_20109 = state_20080__$1;
(statearr_20095_20109[(2)] = null);

(statearr_20095_20109[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0 = (function (){
var statearr_20096 = [null,null,null,null,null,null,null,null];
(statearr_20096[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__);

(statearr_20096[(1)] = (1));

return statearr_20096;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1 = (function (state_20080){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20080);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20097){var ex__2882__auto__ = e20097;
var statearr_20098_20110 = state_20080;
(statearr_20098_20110[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20080[(4)]))){
var statearr_20099_20111 = state_20080;
(statearr_20099_20111[(1)] = cljs.core.first((state_20080[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20112 = state_20080;
state_20080 = G__20112;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__ = function(state_20080){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1.call(this,state_20080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20100 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20100[(6)] = c__2901__auto__);

return statearr_20100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20136){
var state_val_20137 = (state_20136[(1)]);
if((state_val_20137 === (1))){
var state_20136__$1 = state_20136;
var statearr_20138_20152 = state_20136__$1;
(statearr_20138_20152[(2)] = null);

(statearr_20138_20152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20137 === (2))){
var _ = (function (){var statearr_20139 = state_20136;
(statearr_20139[(4)] = cljs.core.cons((5),(state_20136[(4)])));

return statearr_20139;
})();
var inst_20119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20120 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20121 = (new cljs.core.PersistentVector(null,3,(5),inst_20119,inst_20120,null));
var inst_20122 = cljs.core.select_keys(block_data,inst_20121);
var inst_20123 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20122);
var inst_20124 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_20123);
var inst_20125 = [inst_20124,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20126 = fluree.db.storage.core.serde(conn);
var inst_20127 = fluree.db.serde.protocol._serialize_block(inst_20126,inst_20122);
var inst_20128 = fluree.db.storage.core.storage_write(conn,inst_20125,inst_20127);
var state_20136__$1 = state_20136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20136__$1,(6),inst_20128);
} else {
if((state_val_20137 === (3))){
var inst_20134 = (state_20136[(2)]);
var state_20136__$1 = state_20136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20136__$1,inst_20134);
} else {
if((state_val_20137 === (4))){
var inst_20113 = (state_20136[(2)]);
var state_20136__$1 = state_20136;
var statearr_20141_20153 = state_20136__$1;
(statearr_20141_20153[(2)] = inst_20113);

(statearr_20141_20153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20137 === (5))){
var _ = (function (){var statearr_20142 = state_20136;
(statearr_20142[(4)] = cljs.core.rest((state_20136[(4)])));

return statearr_20142;
})();
var state_20136__$1 = state_20136;
var ex20140 = (state_20136__$1[(2)]);
var statearr_20143_20154 = state_20136__$1;
(statearr_20143_20154[(5)] = ex20140);


if((ex20140 instanceof Error)){
var statearr_20144_20155 = state_20136__$1;
(statearr_20144_20155[(1)] = (4));

(statearr_20144_20155[(5)] = null);

} else {
throw ex20140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20137 === (6))){
var inst_20130 = (state_20136[(2)]);
var inst_20131 = fluree.db.util.async.throw_err(inst_20130);
var _ = (function (){var statearr_20145 = state_20136;
(statearr_20145[(4)] = cljs.core.rest((state_20136[(4)])));

return statearr_20145;
})();
var state_20136__$1 = state_20136;
var statearr_20146_20156 = state_20136__$1;
(statearr_20146_20156[(2)] = inst_20131);

(statearr_20146_20156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0 = (function (){
var statearr_20147 = [null,null,null,null,null,null,null];
(statearr_20147[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__);

(statearr_20147[(1)] = (1));

return statearr_20147;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1 = (function (state_20136){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20136);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20148){var ex__2882__auto__ = e20148;
var statearr_20149_20157 = state_20136;
(statearr_20149_20157[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20136[(4)]))){
var statearr_20150_20158 = state_20136;
(statearr_20150_20158[(1)] = cljs.core.first((state_20136[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20159 = state_20136;
state_20136 = G__20159;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__ = function(state_20136){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1.call(this,state_20136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20151 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20151[(6)] = c__2901__auto__);

return statearr_20151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20182){
var state_val_20183 = (state_20182[(1)]);
if((state_val_20183 === (1))){
var state_20182__$1 = state_20182;
var statearr_20184_20198 = state_20182__$1;
(statearr_20184_20198[(2)] = null);

(statearr_20184_20198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20183 === (2))){
var _ = (function (){var statearr_20185 = state_20182;
(statearr_20185[(4)] = cljs.core.cons((5),(state_20182[(4)])));

return statearr_20185;
})();
var inst_20166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20167 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20168 = (new cljs.core.PersistentVector(null,3,(5),inst_20166,inst_20167,null));
var inst_20169 = cljs.core.select_keys(block_data,inst_20168);
var inst_20170 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20169);
var inst_20171 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_20170);
var inst_20172 = fluree.db.storage.core.serde(conn);
var inst_20173 = fluree.db.serde.protocol._serialize_block(inst_20172,inst_20169);
var inst_20174 = fluree.db.storage.core.storage_write(conn,inst_20171,inst_20173);
var state_20182__$1 = state_20182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20182__$1,(6),inst_20174);
} else {
if((state_val_20183 === (3))){
var inst_20180 = (state_20182[(2)]);
var state_20182__$1 = state_20182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20182__$1,inst_20180);
} else {
if((state_val_20183 === (4))){
var inst_20160 = (state_20182[(2)]);
var state_20182__$1 = state_20182;
var statearr_20187_20199 = state_20182__$1;
(statearr_20187_20199[(2)] = inst_20160);

(statearr_20187_20199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20183 === (5))){
var _ = (function (){var statearr_20188 = state_20182;
(statearr_20188[(4)] = cljs.core.rest((state_20182[(4)])));

return statearr_20188;
})();
var state_20182__$1 = state_20182;
var ex20186 = (state_20182__$1[(2)]);
var statearr_20189_20200 = state_20182__$1;
(statearr_20189_20200[(5)] = ex20186);


if((ex20186 instanceof Error)){
var statearr_20190_20201 = state_20182__$1;
(statearr_20190_20201[(1)] = (4));

(statearr_20190_20201[(5)] = null);

} else {
throw ex20186;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20183 === (6))){
var inst_20176 = (state_20182[(2)]);
var inst_20177 = fluree.db.util.async.throw_err(inst_20176);
var _ = (function (){var statearr_20191 = state_20182;
(statearr_20191[(4)] = cljs.core.rest((state_20182[(4)])));

return statearr_20191;
})();
var state_20182__$1 = state_20182;
var statearr_20192_20202 = state_20182__$1;
(statearr_20192_20202[(2)] = inst_20177);

(statearr_20192_20202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2879__auto____0 = (function (){
var statearr_20193 = [null,null,null,null,null,null,null];
(statearr_20193[(0)] = fluree$db$storage$core$write_block_$_state_machine__2879__auto__);

(statearr_20193[(1)] = (1));

return statearr_20193;
});
var fluree$db$storage$core$write_block_$_state_machine__2879__auto____1 = (function (state_20182){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20182);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20194){var ex__2882__auto__ = e20194;
var statearr_20195_20203 = state_20182;
(statearr_20195_20203[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20182[(4)]))){
var statearr_20196_20204 = state_20182;
(statearr_20196_20204[(1)] = cljs.core.first((state_20182[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20205 = state_20182;
state_20182 = G__20205;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2879__auto__ = function(state_20182){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2879__auto____1.call(this,state_20182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20197 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20197[(6)] = c__2901__auto__);

return statearr_20197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20225){
var state_val_20226 = (state_20225[(1)]);
if((state_val_20226 === (1))){
var state_20225__$1 = state_20225;
var statearr_20227_20241 = state_20225__$1;
(statearr_20227_20241[(2)] = null);

(statearr_20227_20241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20226 === (2))){
var _ = (function (){var statearr_20228 = state_20225;
(statearr_20228[(4)] = cljs.core.cons((5),(state_20225[(4)])));

return statearr_20228;
})();
var inst_20212 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20213 = [history,next_his_key];
var inst_20214 = cljs.core.PersistentHashMap.fromArrays(inst_20212,inst_20213);
var inst_20215 = fluree.db.storage.core.serde(conn);
var inst_20216 = fluree.db.serde.protocol._serialize_leaf(inst_20215,inst_20214);
var inst_20217 = fluree.db.storage.core.storage_write(conn,his_key,inst_20216);
var state_20225__$1 = state_20225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20225__$1,(6),inst_20217);
} else {
if((state_val_20226 === (3))){
var inst_20223 = (state_20225[(2)]);
var state_20225__$1 = state_20225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20225__$1,inst_20223);
} else {
if((state_val_20226 === (4))){
var inst_20206 = (state_20225[(2)]);
var state_20225__$1 = state_20225;
var statearr_20230_20242 = state_20225__$1;
(statearr_20230_20242[(2)] = inst_20206);

(statearr_20230_20242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20226 === (5))){
var _ = (function (){var statearr_20231 = state_20225;
(statearr_20231[(4)] = cljs.core.rest((state_20225[(4)])));

return statearr_20231;
})();
var state_20225__$1 = state_20225;
var ex20229 = (state_20225__$1[(2)]);
var statearr_20232_20243 = state_20225__$1;
(statearr_20232_20243[(5)] = ex20229);


if((ex20229 instanceof Error)){
var statearr_20233_20244 = state_20225__$1;
(statearr_20233_20244[(1)] = (4));

(statearr_20233_20244[(5)] = null);

} else {
throw ex20229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20226 === (6))){
var inst_20219 = (state_20225[(2)]);
var inst_20220 = fluree.db.util.async.throw_err(inst_20219);
var _ = (function (){var statearr_20234 = state_20225;
(statearr_20234[(4)] = cljs.core.rest((state_20225[(4)])));

return statearr_20234;
})();
var state_20225__$1 = state_20225;
var statearr_20235_20245 = state_20225__$1;
(statearr_20235_20245[(2)] = inst_20220);

(statearr_20235_20245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2879__auto____0 = (function (){
var statearr_20236 = [null,null,null,null,null,null,null];
(statearr_20236[(0)] = fluree$db$storage$core$write_history_$_state_machine__2879__auto__);

(statearr_20236[(1)] = (1));

return statearr_20236;
});
var fluree$db$storage$core$write_history_$_state_machine__2879__auto____1 = (function (state_20225){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20225);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20237){var ex__2882__auto__ = e20237;
var statearr_20238_20246 = state_20225;
(statearr_20238_20246[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20225[(4)]))){
var statearr_20239_20247 = state_20225;
(statearr_20239_20247[(1)] = cljs.core.first((state_20225[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20248 = state_20225;
state_20225 = G__20248;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2879__auto__ = function(state_20225){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2879__auto____1.call(this,state_20225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20240 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20240[(6)] = c__2901__auto__);

return statearr_20240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20274){
var state_val_20275 = (state_20274[(1)]);
if((state_val_20275 === (1))){
var state_20274__$1 = state_20274;
var statearr_20276_20293 = state_20274__$1;
(statearr_20276_20293[(2)] = null);

(statearr_20276_20293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20275 === (2))){
var inst_20255 = (state_20274[(7)]);
var _ = (function (){var statearr_20277 = state_20274;
(statearr_20277[(4)] = cljs.core.cons((5),(state_20274[(4)])));

return statearr_20277;
})();
var inst_20255__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_20256 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20255__$1),"-his"].join('');
var inst_20257 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20258 = [flakes,inst_20256];
var inst_20259 = cljs.core.PersistentHashMap.fromArrays(inst_20257,inst_20258);
var inst_20260 = fluree.db.storage.core.serde(conn);
var inst_20261 = fluree.db.serde.protocol._serialize_leaf(inst_20260,inst_20259);
var inst_20262 = fluree.db.storage.core.write_history(conn,history,inst_20256,null);
var inst_20263 = fluree.db.storage.core.storage_write(conn,inst_20255__$1,inst_20261);
var state_20274__$1 = (function (){var statearr_20278 = state_20274;
(statearr_20278[(8)] = inst_20263);

(statearr_20278[(7)] = inst_20255__$1);

return statearr_20278;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20274__$1,(6),inst_20262);
} else {
if((state_val_20275 === (3))){
var inst_20272 = (state_20274[(2)]);
var state_20274__$1 = state_20274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20274__$1,inst_20272);
} else {
if((state_val_20275 === (4))){
var inst_20249 = (state_20274[(2)]);
var state_20274__$1 = state_20274;
var statearr_20280_20294 = state_20274__$1;
(statearr_20280_20294[(2)] = inst_20249);

(statearr_20280_20294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20275 === (5))){
var _ = (function (){var statearr_20281 = state_20274;
(statearr_20281[(4)] = cljs.core.rest((state_20274[(4)])));

return statearr_20281;
})();
var state_20274__$1 = state_20274;
var ex20279 = (state_20274__$1[(2)]);
var statearr_20282_20295 = state_20274__$1;
(statearr_20282_20295[(5)] = ex20279);


if((ex20279 instanceof Error)){
var statearr_20283_20296 = state_20274__$1;
(statearr_20283_20296[(1)] = (4));

(statearr_20283_20296[(5)] = null);

} else {
throw ex20279;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20275 === (6))){
var inst_20263 = (state_20274[(8)]);
var inst_20265 = (state_20274[(2)]);
var inst_20266 = fluree.db.util.async.throw_err(inst_20265);
var state_20274__$1 = (function (){var statearr_20284 = state_20274;
(statearr_20284[(9)] = inst_20266);

return statearr_20284;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20274__$1,(7),inst_20263);
} else {
if((state_val_20275 === (7))){
var inst_20255 = (state_20274[(7)]);
var inst_20268 = (state_20274[(2)]);
var inst_20269 = fluree.db.util.async.throw_err(inst_20268);
var _ = (function (){var statearr_20285 = state_20274;
(statearr_20285[(4)] = cljs.core.rest((state_20274[(4)])));

return statearr_20285;
})();
var state_20274__$1 = (function (){var statearr_20286 = state_20274;
(statearr_20286[(10)] = inst_20269);

return statearr_20286;
})();
var statearr_20287_20297 = state_20274__$1;
(statearr_20287_20297[(2)] = inst_20255);

(statearr_20287_20297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_20288 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20288[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__);

(statearr_20288[(1)] = (1));

return statearr_20288;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1 = (function (state_20274){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20274);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20289){var ex__2882__auto__ = e20289;
var statearr_20290_20298 = state_20274;
(statearr_20290_20298[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20274[(4)]))){
var statearr_20291_20299 = state_20274;
(statearr_20291_20299[(1)] = cljs.core.first((state_20274[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20300 = state_20274;
state_20274 = G__20300;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__ = function(state_20274){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1.call(this,state_20274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20292 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20292[(6)] = c__2901__auto__);

return statearr_20292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20317){
var state_val_20318 = (state_20317[(1)]);
if((state_val_20318 === (1))){
var state_20317__$1 = state_20317;
var statearr_20319_20334 = state_20317__$1;
(statearr_20319_20334[(2)] = null);

(statearr_20319_20334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (2))){
var _ = (function (){var statearr_20320 = state_20317;
(statearr_20320[(4)] = cljs.core.cons((5),(state_20317[(4)])));

return statearr_20320;
})();
var inst_20307 = fluree.db.storage.core.serde(conn);
var inst_20308 = fluree.db.serde.protocol._serialize_branch(inst_20307,data);
var inst_20309 = fluree.db.storage.core.storage_write(conn,key,inst_20308);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20317__$1,(6),inst_20309);
} else {
if((state_val_20318 === (3))){
var inst_20315 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20317__$1,inst_20315);
} else {
if((state_val_20318 === (4))){
var inst_20301 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20322_20335 = state_20317__$1;
(statearr_20322_20335[(2)] = inst_20301);

(statearr_20322_20335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (5))){
var _ = (function (){var statearr_20323 = state_20317;
(statearr_20323[(4)] = cljs.core.rest((state_20317[(4)])));

return statearr_20323;
})();
var state_20317__$1 = state_20317;
var ex20321 = (state_20317__$1[(2)]);
var statearr_20324_20336 = state_20317__$1;
(statearr_20324_20336[(5)] = ex20321);


if((ex20321 instanceof Error)){
var statearr_20325_20337 = state_20317__$1;
(statearr_20325_20337[(1)] = (4));

(statearr_20325_20337[(5)] = null);

} else {
throw ex20321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (6))){
var inst_20311 = (state_20317[(2)]);
var inst_20312 = fluree.db.util.async.throw_err(inst_20311);
var _ = (function (){var statearr_20326 = state_20317;
(statearr_20326[(4)] = cljs.core.rest((state_20317[(4)])));

return statearr_20326;
})();
var state_20317__$1 = (function (){var statearr_20327 = state_20317;
(statearr_20327[(7)] = inst_20312);

return statearr_20327;
})();
var statearr_20328_20338 = state_20317__$1;
(statearr_20328_20338[(2)] = key);

(statearr_20328_20338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0 = (function (){
var statearr_20329 = [null,null,null,null,null,null,null,null];
(statearr_20329[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__);

(statearr_20329[(1)] = (1));

return statearr_20329;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1 = (function (state_20317){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20317);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20330){var ex__2882__auto__ = e20330;
var statearr_20331_20339 = state_20317;
(statearr_20331_20339[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20317[(4)]))){
var statearr_20332_20340 = state_20317;
(statearr_20332_20340[(1)] = cljs.core.first((state_20317[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20341 = state_20317;
state_20317 = G__20341;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__ = function(state_20317){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1.call(this,state_20317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20333 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20333[(6)] = c__2901__auto__);

return statearr_20333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20342_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__20342_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__20343){
var map__20344 = p__20343;
var map__20344__$1 = (((((!((map__20344 == null))))?(((((map__20344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20344):map__20344);
var progress = map__20344__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20344__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20393){
var state_val_20394 = (state_20393[(1)]);
if((state_val_20394 === (7))){
var state_20393__$1 = state_20393;
var statearr_20395_20424 = state_20393__$1;
(statearr_20395_20424[(2)] = false);

(statearr_20395_20424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (1))){
var state_20393__$1 = state_20393;
var statearr_20396_20425 = state_20393__$1;
(statearr_20396_20425[(2)] = null);

(statearr_20396_20425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (4))){
var inst_20346 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
var statearr_20397_20426 = state_20393__$1;
(statearr_20397_20426[(2)] = inst_20346);

(statearr_20397_20426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (15))){
var inst_20379 = (state_20393[(7)]);
var inst_20387 = (state_20393[(2)]);
var inst_20388 = fluree.db.util.async.throw_err(inst_20387);
var _ = (function (){var statearr_20398 = state_20393;
(statearr_20398[(4)] = cljs.core.rest((state_20393[(4)])));

return statearr_20398;
})();
var state_20393__$1 = (function (){var statearr_20399 = state_20393;
(statearr_20399[(8)] = inst_20388);

return statearr_20399;
})();
var statearr_20400_20427 = state_20393__$1;
(statearr_20400_20427[(2)] = inst_20379);

(statearr_20400_20427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (13))){
var inst_20353 = (state_20393[(9)]);
var state_20393__$1 = state_20393;
var statearr_20401_20428 = state_20393__$1;
(statearr_20401_20428[(2)] = inst_20353);

(statearr_20401_20428[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (6))){
var inst_20353 = (state_20393[(9)]);
var inst_20358 = inst_20353.cljs$lang$protocol_mask$partition0$;
var inst_20359 = (inst_20358 & (64));
var inst_20360 = inst_20353.cljs$core$ISeq$;
var inst_20361 = (cljs.core.PROTOCOL_SENTINEL === inst_20360);
var inst_20362 = ((inst_20359) || (inst_20361));
var state_20393__$1 = state_20393;
if(cljs.core.truth_(inst_20362)){
var statearr_20402_20429 = state_20393__$1;
(statearr_20402_20429[(1)] = (9));

} else {
var statearr_20403_20430 = state_20393__$1;
(statearr_20403_20430[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (3))){
var inst_20391 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20393__$1,inst_20391);
} else {
if((state_val_20394 === (12))){
var inst_20353 = (state_20393[(9)]);
var inst_20371 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20353);
var state_20393__$1 = state_20393;
var statearr_20404_20431 = state_20393__$1;
(statearr_20404_20431[(2)] = inst_20371);

(statearr_20404_20431[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (2))){
var inst_20353 = (state_20393[(9)]);
var _ = (function (){var statearr_20405 = state_20393;
(statearr_20405[(4)] = cljs.core.cons((5),(state_20393[(4)])));

return statearr_20405;
})();
var inst_20353__$1 = db;
var inst_20355 = (inst_20353__$1 == null);
var inst_20356 = cljs.core.not(inst_20355);
var state_20393__$1 = (function (){var statearr_20406 = state_20393;
(statearr_20406[(9)] = inst_20353__$1);

return statearr_20406;
})();
if(inst_20356){
var statearr_20407_20432 = state_20393__$1;
(statearr_20407_20432[(1)] = (6));

} else {
var statearr_20408_20433 = state_20393__$1;
(statearr_20408_20433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (11))){
var inst_20366 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
var statearr_20410_20434 = state_20393__$1;
(statearr_20410_20434[(2)] = inst_20366);

(statearr_20410_20434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (9))){
var state_20393__$1 = state_20393;
var statearr_20411_20435 = state_20393__$1;
(statearr_20411_20435[(2)] = true);

(statearr_20411_20435[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (5))){
var _ = (function (){var statearr_20412 = state_20393;
(statearr_20412[(4)] = cljs.core.rest((state_20393[(4)])));

return statearr_20412;
})();
var state_20393__$1 = state_20393;
var ex20409 = (state_20393__$1[(2)]);
var statearr_20413_20436 = state_20393__$1;
(statearr_20413_20436[(5)] = ex20409);


if((ex20409 instanceof Error)){
var statearr_20414_20437 = state_20393__$1;
(statearr_20414_20437[(1)] = (4));

(statearr_20414_20437[(5)] = null);

} else {
throw ex20409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (14))){
var inst_20379 = (state_20393[(7)]);
var inst_20374 = (state_20393[(2)]);
var inst_20375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20374,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20374,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20374,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20374,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20379__$1 = fluree.db.storage.core.ledger_garbage_key(inst_20376,inst_20377,inst_20378);
var inst_20380 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_20381 = [inst_20377,inst_20378,garbage];
var inst_20382 = cljs.core.PersistentHashMap.fromArrays(inst_20380,inst_20381);
var inst_20383 = fluree.db.storage.core.serde(inst_20375);
var inst_20384 = fluree.db.serde.protocol._serialize_garbage(inst_20383,inst_20382);
var inst_20385 = fluree.db.storage.core.storage_write(inst_20375,inst_20379__$1,inst_20384);
var state_20393__$1 = (function (){var statearr_20415 = state_20393;
(statearr_20415[(7)] = inst_20379__$1);

return statearr_20415;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20393__$1,(15),inst_20385);
} else {
if((state_val_20394 === (10))){
var state_20393__$1 = state_20393;
var statearr_20416_20438 = state_20393__$1;
(statearr_20416_20438[(2)] = false);

(statearr_20416_20438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20394 === (8))){
var inst_20369 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
if(cljs.core.truth_(inst_20369)){
var statearr_20417_20439 = state_20393__$1;
(statearr_20417_20439[(1)] = (12));

} else {
var statearr_20418_20440 = state_20393__$1;
(statearr_20418_20440[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0 = (function (){
var statearr_20419 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20419[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__);

(statearr_20419[(1)] = (1));

return statearr_20419;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1 = (function (state_20393){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20393);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20420){var ex__2882__auto__ = e20420;
var statearr_20421_20441 = state_20393;
(statearr_20421_20441[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20393[(4)]))){
var statearr_20422_20442 = state_20393;
(statearr_20422_20442[(1)] = cljs.core.first((state_20393[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20443 = state_20393;
state_20393 = G__20443;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__ = function(state_20393){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1.call(this,state_20393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20423 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20423[(6)] = c__2901__auto__);

return statearr_20423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__20445 = arguments.length;
switch (G__20445) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20521){
var state_val_20522 = (state_20521[(1)]);
if((state_val_20522 === (7))){
var state_20521__$1 = state_20521;
var statearr_20523_20562 = state_20521__$1;
(statearr_20523_20562[(2)] = false);

(statearr_20523_20562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (20))){
var inst_20485 = (state_20521[(7)]);
var inst_20479 = (state_20521[(8)]);
var inst_20483 = (state_20521[(9)]);
var inst_20478 = (state_20521[(10)]);
var inst_20480 = (state_20521[(11)]);
var inst_20487 = (state_20521[(12)]);
var inst_20481 = (state_20521[(13)]);
var inst_20476 = (state_20521[(14)]);
var inst_20488 = (state_20521[(15)]);
var inst_20490 = (state_20521[(16)]);
var inst_20486 = (state_20521[(17)]);
var inst_20495 = (state_20521[(18)]);
var inst_20477 = (state_20521[(19)]);
var inst_20489 = (state_20521[(20)]);
var inst_20500 = (state_20521[(2)]);
var inst_20501 = fluree.db.storage.core.child_data(inst_20485);
var inst_20502 = fluree.db.storage.core.child_data(inst_20487);
var inst_20503 = fluree.db.util.core.current_time_millis();
var inst_20504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20505 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_20506 = (new cljs.core.PersistentVector(null,2,(5),inst_20504,inst_20505,null));
var inst_20507 = cljs.core.select_keys(inst_20479,inst_20506);
var inst_20508 = fluree.db.storage.core.child_data(inst_20478);
var inst_20509 = [inst_20481,inst_20490,inst_20483,inst_20495,inst_20500,inst_20501,inst_20502,inst_20476,inst_20503,inst_20477,inst_20486,inst_20507,inst_20508];
var inst_20510 = cljs.core.PersistentHashMap.fromArrays(inst_20489,inst_20509);
var inst_20511 = fluree.db.storage.core.serde(inst_20480);
var inst_20512 = fluree.db.serde.protocol._serialize_db_root(inst_20511,inst_20510);
var inst_20513 = fluree.db.storage.core.storage_write(inst_20480,inst_20488,inst_20512);
var state_20521__$1 = state_20521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20521__$1,(21),inst_20513);
} else {
if((state_val_20522 === (1))){
var state_20521__$1 = state_20521;
var statearr_20524_20563 = state_20521__$1;
(statearr_20524_20563[(2)] = null);

(statearr_20524_20563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (4))){
var inst_20446 = (state_20521[(2)]);
var state_20521__$1 = state_20521;
var statearr_20525_20564 = state_20521__$1;
(statearr_20525_20564[(2)] = inst_20446);

(statearr_20525_20564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (15))){
var inst_20491 = (state_20521[(21)]);
var state_20521__$1 = state_20521;
var statearr_20526_20565 = state_20521__$1;
(statearr_20526_20565[(2)] = inst_20491);

(statearr_20526_20565[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (21))){
var inst_20488 = (state_20521[(15)]);
var inst_20515 = (state_20521[(2)]);
var inst_20516 = fluree.db.util.async.throw_err(inst_20515);
var _ = (function (){var statearr_20527 = state_20521;
(statearr_20527[(4)] = cljs.core.rest((state_20521[(4)])));

return statearr_20527;
})();
var state_20521__$1 = (function (){var statearr_20528 = state_20521;
(statearr_20528[(22)] = inst_20516);

return statearr_20528;
})();
var statearr_20529_20566 = state_20521__$1;
(statearr_20529_20566[(2)] = inst_20488);

(statearr_20529_20566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (13))){
var inst_20453 = (state_20521[(23)]);
var state_20521__$1 = state_20521;
var statearr_20530_20567 = state_20521__$1;
(statearr_20530_20567[(2)] = inst_20453);

(statearr_20530_20567[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (6))){
var inst_20453 = (state_20521[(23)]);
var inst_20458 = inst_20453.cljs$lang$protocol_mask$partition0$;
var inst_20459 = (inst_20458 & (64));
var inst_20460 = inst_20453.cljs$core$ISeq$;
var inst_20461 = (cljs.core.PROTOCOL_SENTINEL === inst_20460);
var inst_20462 = ((inst_20459) || (inst_20461));
var state_20521__$1 = state_20521;
if(cljs.core.truth_(inst_20462)){
var statearr_20531_20568 = state_20521__$1;
(statearr_20531_20568[(1)] = (9));

} else {
var statearr_20532_20569 = state_20521__$1;
(statearr_20532_20569[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (17))){
var inst_20496 = (state_20521[(24)]);
var inst_20495 = (state_20521[(2)]);
var inst_20496__$1 = custom_ecount;
var state_20521__$1 = (function (){var statearr_20533 = state_20521;
(statearr_20533[(24)] = inst_20496__$1);

(statearr_20533[(18)] = inst_20495);

return statearr_20533;
})();
if(cljs.core.truth_(inst_20496__$1)){
var statearr_20534_20570 = state_20521__$1;
(statearr_20534_20570[(1)] = (18));

} else {
var statearr_20535_20571 = state_20521__$1;
(statearr_20535_20571[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (3))){
var inst_20519 = (state_20521[(2)]);
var state_20521__$1 = state_20521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20521__$1,inst_20519);
} else {
if((state_val_20522 === (12))){
var inst_20453 = (state_20521[(23)]);
var inst_20471 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20453);
var state_20521__$1 = state_20521;
var statearr_20536_20572 = state_20521__$1;
(statearr_20536_20572[(2)] = inst_20471);

(statearr_20536_20572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (2))){
var inst_20453 = (state_20521[(23)]);
var _ = (function (){var statearr_20537 = state_20521;
(statearr_20537[(4)] = cljs.core.cons((5),(state_20521[(4)])));

return statearr_20537;
})();
var inst_20453__$1 = db;
var inst_20455 = (inst_20453__$1 == null);
var inst_20456 = cljs.core.not(inst_20455);
var state_20521__$1 = (function (){var statearr_20538 = state_20521;
(statearr_20538[(23)] = inst_20453__$1);

return statearr_20538;
})();
if(inst_20456){
var statearr_20539_20573 = state_20521__$1;
(statearr_20539_20573[(1)] = (6));

} else {
var statearr_20540_20574 = state_20521__$1;
(statearr_20540_20574[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (19))){
var inst_20484 = (state_20521[(25)]);
var state_20521__$1 = state_20521;
var statearr_20541_20575 = state_20521__$1;
(statearr_20541_20575[(2)] = inst_20484);

(statearr_20541_20575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (11))){
var inst_20466 = (state_20521[(2)]);
var state_20521__$1 = state_20521;
var statearr_20543_20576 = state_20521__$1;
(statearr_20543_20576[(2)] = inst_20466);

(statearr_20543_20576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (9))){
var state_20521__$1 = state_20521;
var statearr_20544_20577 = state_20521__$1;
(statearr_20544_20577[(2)] = true);

(statearr_20544_20577[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (5))){
var _ = (function (){var statearr_20545 = state_20521;
(statearr_20545[(4)] = cljs.core.rest((state_20521[(4)])));

return statearr_20545;
})();
var state_20521__$1 = state_20521;
var ex20542 = (state_20521__$1[(2)]);
var statearr_20546_20578 = state_20521__$1;
(statearr_20546_20578[(5)] = ex20542);


if((ex20542 instanceof Error)){
var statearr_20547_20579 = state_20521__$1;
(statearr_20547_20579[(1)] = (4));

(statearr_20547_20579[(5)] = null);

} else {
throw ex20542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (14))){
var inst_20479 = (state_20521[(8)]);
var inst_20483 = (state_20521[(9)]);
var inst_20491 = (state_20521[(21)]);
var inst_20481 = (state_20521[(13)]);
var inst_20474 = (state_20521[(2)]);
var inst_20475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20476 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_20477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_20478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_20479__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_20480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20481__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_20483__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_20485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_20486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_20487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20474,new cljs.core.Keyword(null,"post","post",269697687));
var inst_20488 = fluree.db.storage.core.ledger_root_key(inst_20475,inst_20483__$1,inst_20481__$1);
var inst_20489 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_20490 = fluree.db.storage.core.child_data(inst_20482);
var inst_20491__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_20479__$1);
var state_20521__$1 = (function (){var statearr_20548 = state_20521;
(statearr_20548[(7)] = inst_20485);

(statearr_20548[(8)] = inst_20479__$1);

(statearr_20548[(9)] = inst_20483__$1);

(statearr_20548[(10)] = inst_20478);

(statearr_20548[(11)] = inst_20480);

(statearr_20548[(21)] = inst_20491__$1);

(statearr_20548[(12)] = inst_20487);

(statearr_20548[(13)] = inst_20481__$1);

(statearr_20548[(14)] = inst_20476);

(statearr_20548[(15)] = inst_20488);

(statearr_20548[(16)] = inst_20490);

(statearr_20548[(25)] = inst_20484);

(statearr_20548[(17)] = inst_20486);

(statearr_20548[(19)] = inst_20477);

(statearr_20548[(20)] = inst_20489);

return statearr_20548;
})();
if(cljs.core.truth_(inst_20491__$1)){
var statearr_20549_20580 = state_20521__$1;
(statearr_20549_20580[(1)] = (15));

} else {
var statearr_20550_20581 = state_20521__$1;
(statearr_20550_20581[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (16))){
var state_20521__$1 = state_20521;
var statearr_20551_20582 = state_20521__$1;
(statearr_20551_20582[(2)] = (0));

(statearr_20551_20582[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (10))){
var state_20521__$1 = state_20521;
var statearr_20552_20583 = state_20521__$1;
(statearr_20552_20583[(2)] = false);

(statearr_20552_20583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (18))){
var inst_20496 = (state_20521[(24)]);
var state_20521__$1 = state_20521;
var statearr_20553_20584 = state_20521__$1;
(statearr_20553_20584[(2)] = inst_20496);

(statearr_20553_20584[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20522 === (8))){
var inst_20469 = (state_20521[(2)]);
var state_20521__$1 = state_20521;
if(cljs.core.truth_(inst_20469)){
var statearr_20554_20585 = state_20521__$1;
(statearr_20554_20585[(1)] = (12));

} else {
var statearr_20555_20586 = state_20521__$1;
(statearr_20555_20586[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2879__auto__ = null;
var fluree$db$storage$core$state_machine__2879__auto____0 = (function (){
var statearr_20556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20556[(0)] = fluree$db$storage$core$state_machine__2879__auto__);

(statearr_20556[(1)] = (1));

return statearr_20556;
});
var fluree$db$storage$core$state_machine__2879__auto____1 = (function (state_20521){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20521);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20557){var ex__2882__auto__ = e20557;
var statearr_20558_20587 = state_20521;
(statearr_20558_20587[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20521[(4)]))){
var statearr_20559_20588 = state_20521;
(statearr_20559_20588[(1)] = cljs.core.first((state_20521[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20589 = state_20521;
state_20521 = G__20589;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2879__auto__ = function(state_20521){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2879__auto____1.call(this,state_20521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2879__auto____0;
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2879__auto____1;
return fluree$db$storage$core$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20560 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20560[(6)] = c__2901__auto__);

return statearr_20560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___20641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20619){
var state_val_20620 = (state_20619[(1)]);
if((state_val_20620 === (7))){
var inst_20606 = cljs.core.async.close_BANG_(return_ch);
var state_20619__$1 = state_20619;
var statearr_20621_20642 = state_20619__$1;
(statearr_20621_20642[(2)] = inst_20606);

(statearr_20621_20642[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (1))){
var state_20619__$1 = state_20619;
var statearr_20622_20643 = state_20619__$1;
(statearr_20622_20643[(2)] = null);

(statearr_20622_20643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (4))){
var inst_20590 = (state_20619[(2)]);
var inst_20591 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20592 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20590);
var inst_20593 = cljs.core.async.close_BANG_(return_ch);
var state_20619__$1 = (function (){var statearr_20623 = state_20619;
(statearr_20623[(7)] = inst_20592);

(statearr_20623[(8)] = inst_20591);

return statearr_20623;
})();
var statearr_20624_20644 = state_20619__$1;
(statearr_20624_20644[(2)] = inst_20593);

(statearr_20624_20644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (6))){
var inst_20601 = (state_20619[(9)]);
var inst_20601__$1 = (state_20619[(2)]);
var inst_20602 = (inst_20601__$1 == null);
var inst_20603 = (inst_20601__$1 instanceof Error);
var inst_20604 = ((inst_20602) || (inst_20603));
var state_20619__$1 = (function (){var statearr_20625 = state_20619;
(statearr_20625[(9)] = inst_20601__$1);

return statearr_20625;
})();
if(cljs.core.truth_(inst_20604)){
var statearr_20626_20645 = state_20619__$1;
(statearr_20626_20645[(1)] = (7));

} else {
var statearr_20627_20646 = state_20619__$1;
(statearr_20627_20646[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (3))){
var inst_20617 = (state_20619[(2)]);
var state_20619__$1 = state_20619;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20619__$1,inst_20617);
} else {
if((state_val_20620 === (2))){
var _ = (function (){var statearr_20629 = state_20619;
(statearr_20629[(4)] = cljs.core.cons((5),(state_20619[(4)])));

return statearr_20629;
})();
var inst_20599 = fluree.db.storage.core.storage_read(conn,key);
var state_20619__$1 = state_20619;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20619__$1,(6),inst_20599);
} else {
if((state_val_20620 === (9))){
var inst_20614 = (state_20619[(2)]);
var _ = (function (){var statearr_20630 = state_20619;
(statearr_20630[(4)] = cljs.core.rest((state_20619[(4)])));

return statearr_20630;
})();
var state_20619__$1 = state_20619;
var statearr_20631_20647 = state_20619__$1;
(statearr_20631_20647[(2)] = inst_20614);

(statearr_20631_20647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (5))){
var _ = (function (){var statearr_20632 = state_20619;
(statearr_20632[(4)] = cljs.core.rest((state_20619[(4)])));

return statearr_20632;
})();
var state_20619__$1 = state_20619;
var ex20628 = (state_20619__$1[(2)]);
var statearr_20633_20648 = state_20619__$1;
(statearr_20633_20648[(5)] = ex20628);


var statearr_20634_20649 = state_20619__$1;
(statearr_20634_20649[(1)] = (4));

(statearr_20634_20649[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (8))){
var inst_20601 = (state_20619[(9)]);
var inst_20608 = fluree.db.storage.core.serde(conn);
var inst_20609 = fluree.db.serde.protocol._deserialize_leaf(inst_20608,inst_20601);
var inst_20610 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20609);
var inst_20611 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_20610);
var inst_20612 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20611);
var state_20619__$1 = state_20619;
var statearr_20635_20650 = state_20619__$1;
(statearr_20635_20650[(2)] = inst_20612);

(statearr_20635_20650[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0 = (function (){
var statearr_20636 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20636[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2879__auto__);

(statearr_20636[(1)] = (1));

return statearr_20636;
});
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1 = (function (state_20619){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20619);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20637){var ex__2882__auto__ = e20637;
var statearr_20638_20651 = state_20619;
(statearr_20638_20651[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20619[(4)]))){
var statearr_20639_20652 = state_20619;
(statearr_20639_20652[(1)] = cljs.core.first((state_20619[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20653 = state_20619;
state_20619 = G__20653;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__ = function(state_20619){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1.call(this,state_20619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20640 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20640[(6)] = c__2901__auto___20641);

return statearr_20640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__20655 = arguments.length;
switch (G__20655) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___20767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20718){
var state_val_20719 = (state_20718[(1)]);
if((state_val_20719 === (7))){
var state_20718__$1 = state_20718;
var statearr_20720_20768 = state_20718__$1;
(statearr_20720_20768[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_20720_20768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (20))){
var inst_20697 = cljs.core.PersistentVector.EMPTY;
var state_20718__$1 = state_20718;
var statearr_20721_20769 = state_20718__$1;
(statearr_20721_20769[(2)] = inst_20697);

(statearr_20721_20769[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (1))){
var state_20718__$1 = state_20718;
var statearr_20722_20770 = state_20718__$1;
(statearr_20722_20770[(2)] = null);

(statearr_20722_20770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (24))){
var state_20718__$1 = state_20718;
var statearr_20723_20771 = state_20718__$1;
(statearr_20723_20771[(2)] = null);

(statearr_20723_20771[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (4))){
var inst_20658 = (state_20718[(2)]);
var inst_20659 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20660 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_20658);
var inst_20661 = cljs.core.async.close_BANG_(result_ch);
var state_20718__$1 = (function (){var statearr_20724 = state_20718;
(statearr_20724[(7)] = inst_20660);

(statearr_20724[(8)] = inst_20659);

return statearr_20724;
})();
var statearr_20725_20772 = state_20718__$1;
(statearr_20725_20772[(2)] = inst_20661);

(statearr_20725_20772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (15))){
var inst_20683 = (state_20718[(2)]);
var state_20718__$1 = state_20718;
var statearr_20726_20773 = state_20718__$1;
(statearr_20726_20773[(2)] = inst_20683);

(statearr_20726_20773[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (21))){
var inst_20670 = (state_20718[(9)]);
var inst_20700 = (state_20718[(10)]);
var inst_20672 = (state_20718[(11)]);
var inst_20687 = (state_20718[(12)]);
var inst_20671 = (state_20718[(13)]);
var inst_20707 = (state_20718[(2)]);
var inst_20708 = (function (){var base_node = inst_20670;
var first_flake = inst_20671;
var node_t = inst_20672;
var source = inst_20687;
var coll = inst_20700;
var conj_QMARK_ = inst_20707;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__20728 = f.p;
var fexpr__20727 = (function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__20727.cljs$core$IFn$_invoke$arity$1 ? fexpr__20727.cljs$core$IFn$_invoke$arity$1(G__20728) : fexpr__20727.call(null,G__20728));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_20709 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20670);
var inst_20710 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20708,inst_20709,inst_20700);
var inst_20711 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_20710);
var inst_20712 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20670,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_20711);
var inst_20713 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_20712);
var _ = (function (){var statearr_20729 = state_20718;
(statearr_20729[(4)] = cljs.core.rest((state_20718[(4)])));

return statearr_20729;
})();
var state_20718__$1 = state_20718;
var statearr_20730_20774 = state_20718__$1;
(statearr_20730_20774[(2)] = inst_20713);

(statearr_20730_20774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (13))){
var state_20718__$1 = state_20718;
var statearr_20731_20775 = state_20718__$1;
(statearr_20731_20775[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_20731_20775[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (22))){
var inst_20670 = (state_20718[(9)]);
var inst_20700 = (state_20718[(10)]);
var inst_20672 = (state_20718[(11)]);
var inst_20687 = (state_20718[(12)]);
var inst_20671 = (state_20718[(13)]);
var inst_20701 = (function (){var base_node = inst_20670;
var first_flake = inst_20671;
var node_t = inst_20672;
var source = inst_20687;
var coll = inst_20700;
return (function (f){
return f.op === true;
});
})();
var state_20718__$1 = state_20718;
var statearr_20732_20776 = state_20718__$1;
(statearr_20732_20776[(2)] = inst_20701);

(statearr_20732_20776[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (6))){
var inst_20670 = (state_20718[(9)]);
var inst_20672 = (state_20718[(11)]);
var inst_20669 = (state_20718[(2)]);
var inst_20670__$1 = fluree.db.util.async.throw_err(inst_20669);
var inst_20671 = fluree.db.dbproto._first_flake(inst_20670__$1);
var inst_20672__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_20670__$1);
var inst_20673 = (inst_20672__$1 > t);
var state_20718__$1 = (function (){var statearr_20733 = state_20718;
(statearr_20733[(9)] = inst_20670__$1);

(statearr_20733[(11)] = inst_20672__$1);

(statearr_20733[(13)] = inst_20671);

return statearr_20733;
})();
if(cljs.core.truth_(inst_20673)){
var statearr_20734_20777 = state_20718__$1;
(statearr_20734_20777[(1)] = (7));

} else {
var statearr_20735_20778 = state_20718__$1;
(statearr_20735_20778[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (17))){
var inst_20671 = (state_20718[(13)]);
var inst_20688 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_20671,rhs,leftmost_QMARK_,t);
var state_20718__$1 = state_20718;
var statearr_20736_20779 = state_20718__$1;
(statearr_20736_20779[(2)] = inst_20688);

(statearr_20736_20779[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (3))){
var inst_20716 = (state_20718[(2)]);
var state_20718__$1 = state_20718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20718__$1,inst_20716);
} else {
if((state_val_20719 === (12))){
var inst_20685 = (state_20718[(2)]);
var state_20718__$1 = state_20718;
var statearr_20737_20780 = state_20718__$1;
(statearr_20737_20780[(2)] = inst_20685);

(statearr_20737_20780[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (2))){
var _ = (function (){var statearr_20738 = state_20718;
(statearr_20738[(4)] = cljs.core.cons((5),(state_20718[(4)])));

return statearr_20738;
})();
var inst_20667 = fluree.db.dbproto._resolve(node);
var state_20718__$1 = state_20718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20718__$1,(6),inst_20667);
} else {
if((state_val_20719 === (23))){
var inst_20670 = (state_20718[(9)]);
var inst_20700 = (state_20718[(10)]);
var inst_20672 = (state_20718[(11)]);
var inst_20687 = (state_20718[(12)]);
var inst_20671 = (state_20718[(13)]);
var inst_20703 = (function (){var base_node = inst_20670;
var first_flake = inst_20671;
var node_t = inst_20672;
var source = inst_20687;
var coll = inst_20700;
return (function (f){
return f.op === false;
});
})();
var state_20718__$1 = state_20718;
var statearr_20739_20781 = state_20718__$1;
(statearr_20739_20781[(2)] = inst_20703);

(statearr_20739_20781[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (19))){
var inst_20690 = (state_20718[(14)]);
var inst_20693 = (state_20718[(2)]);
var inst_20694 = fluree.db.util.async.throw_err(inst_20693);
var inst_20695 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_20690,inst_20694);
var state_20718__$1 = state_20718;
var statearr_20740_20782 = state_20718__$1;
(statearr_20740_20782[(2)] = inst_20695);

(statearr_20740_20782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (11))){
var inst_20672 = (state_20718[(11)]);
var inst_20679 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20672,t);
var state_20718__$1 = state_20718;
if(inst_20679){
var statearr_20742_20783 = state_20718__$1;
(statearr_20742_20783[(1)] = (13));

} else {
var statearr_20743_20784 = state_20718__$1;
(statearr_20743_20784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (9))){
var inst_20687 = (state_20718[(12)]);
var inst_20687__$1 = (state_20718[(2)]);
var state_20718__$1 = (function (){var statearr_20744 = state_20718;
(statearr_20744[(12)] = inst_20687__$1);

return statearr_20744;
})();
var G__20745_20785 = inst_20687__$1;
var G__20745_20786__$1 = (((G__20745_20785 instanceof cljs.core.Keyword))?G__20745_20785.fqn:null);
switch (G__20745_20786__$1) {
case "novelty":
var statearr_20746_20788 = state_20718__$1;
(statearr_20746_20788[(1)] = (17));


break;
case "history":
var statearr_20747_20789 = state_20718__$1;
(statearr_20747_20789[(1)] = (18));


break;
case "none":
var statearr_20748_20790 = state_20718__$1;
(statearr_20748_20790[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20745_20786__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (5))){
var _ = (function (){var statearr_20749 = state_20718;
(statearr_20749[(4)] = cljs.core.rest((state_20718[(4)])));

return statearr_20749;
})();
var state_20718__$1 = state_20718;
var ex20741 = (state_20718__$1[(2)]);
var statearr_20750_20791 = state_20718__$1;
(statearr_20750_20791[(5)] = ex20741);


var statearr_20751_20792 = state_20718__$1;
(statearr_20751_20792[(1)] = (4));

(statearr_20751_20792[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (14))){
var state_20718__$1 = state_20718;
var statearr_20752_20793 = state_20718__$1;
(statearr_20752_20793[(2)] = null);

(statearr_20752_20793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (16))){
var inst_20687 = (state_20718[(12)]);
var inst_20700 = (state_20718[(2)]);
var state_20718__$1 = (function (){var statearr_20753 = state_20718;
(statearr_20753[(10)] = inst_20700);

return statearr_20753;
})();
var G__20754_20794 = inst_20687;
var G__20754_20795__$1 = (((G__20754_20794 instanceof cljs.core.Keyword))?G__20754_20794.fqn:null);
switch (G__20754_20795__$1) {
case "novelty":
var statearr_20755_20797 = state_20718__$1;
(statearr_20755_20797[(1)] = (22));


break;
case "history":
var statearr_20756_20798 = state_20718__$1;
(statearr_20756_20798[(1)] = (23));


break;
case "none":
var statearr_20757_20799 = state_20718__$1;
(statearr_20757_20799[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20754_20795__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (10))){
var state_20718__$1 = state_20718;
var statearr_20758_20800 = state_20718__$1;
(statearr_20758_20800[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_20758_20800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20719 === (18))){
var inst_20670 = (state_20718[(9)]);
var inst_20672 = (state_20718[(11)]);
var inst_20687 = (state_20718[(12)]);
var inst_20671 = (state_20718[(13)]);
var inst_20690 = (function (){var base_node = inst_20670;
var first_flake = inst_20671;
var node_t = inst_20672;
var source = inst_20687;
return (function (p1__20657_SHARP_){
return (p1__20657_SHARP_.t <= t);
});
})();
var inst_20691 = fluree.db.dbproto._resolve_history(node);
var state_20718__$1 = (function (){var statearr_20759 = state_20718;
(statearr_20759[(14)] = inst_20690);

return statearr_20759;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20718__$1,(19),inst_20691);
} else {
if((state_val_20719 === (8))){
var inst_20672 = (state_20718[(11)]);
var inst_20676 = (inst_20672 < t);
var state_20718__$1 = state_20718;
if(cljs.core.truth_(inst_20676)){
var statearr_20760_20801 = state_20718__$1;
(statearr_20760_20801[(1)] = (10));

} else {
var statearr_20761_20802 = state_20718__$1;
(statearr_20761_20802[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0 = (function (){
var statearr_20762 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20762[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__);

(statearr_20762[(1)] = (1));

return statearr_20762;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1 = (function (state_20718){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20718);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20763){var ex__2882__auto__ = e20763;
var statearr_20764_20803 = state_20718;
(statearr_20764_20803[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20718[(4)]))){
var statearr_20765_20804 = state_20718;
(statearr_20765_20804[(1)] = cljs.core.first((state_20718[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20805 = state_20718;
state_20718 = G__20805;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__ = function(state_20718){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1.call(this,state_20718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20766 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20766[(6)] = c__2901__auto___20767);

return statearr_20766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20862){
var state_val_20863 = (state_20862[(1)]);
if((state_val_20863 === (7))){
var state_20862__$1 = state_20862;
var statearr_20864_20900 = state_20862__$1;
(statearr_20864_20900[(2)] = null);

(statearr_20864_20900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (1))){
var state_20862__$1 = state_20862;
var statearr_20865_20901 = state_20862__$1;
(statearr_20865_20901[(2)] = null);

(statearr_20865_20901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (4))){
var inst_20808 = (state_20862[(2)]);
var inst_20809 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20808], 0));
var inst_20810 = (function(){throw inst_20808})();
var state_20862__$1 = (function (){var statearr_20866 = state_20862;
(statearr_20866[(7)] = inst_20809);

return statearr_20866;
})();
var statearr_20867_20902 = state_20862__$1;
(statearr_20867_20902[(2)] = inst_20810);

(statearr_20867_20902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (15))){
var inst_20838 = (state_20862[(2)]);
var state_20862__$1 = state_20862;
var statearr_20868_20903 = state_20862__$1;
(statearr_20868_20903[(2)] = inst_20838);

(statearr_20868_20903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (13))){
var inst_20832 = (state_20862[(8)]);
var inst_20816 = (state_20862[(9)]);
var inst_20834 = (function (){var node_t = inst_20816;
var G__20821 = inst_20832;
return (function (p1__20807_SHARP_){
return (p1__20807_SHARP_.t <= from_t);
});
})();
var inst_20835 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_20834,inst_20832);
var state_20862__$1 = state_20862;
var statearr_20869_20904 = state_20862__$1;
(statearr_20869_20904[(2)] = inst_20835);

(statearr_20869_20904[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (6))){
var inst_20822 = fluree.db.dbproto._resolve_history(node);
var state_20862__$1 = state_20862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20862__$1,(9),inst_20822);
} else {
if((state_val_20863 === (17))){
var inst_20847 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_20848 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20847)].join('');
var inst_20849 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20850 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_20851 = cljs.core.PersistentHashMap.fromArrays(inst_20849,inst_20850);
var inst_20852 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20848,inst_20851);
var inst_20853 = (function(){throw inst_20852})();
var state_20862__$1 = state_20862;
var statearr_20870_20905 = state_20862__$1;
(statearr_20870_20905[(2)] = inst_20853);

(statearr_20870_20905[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (3))){
var inst_20860 = (state_20862[(2)]);
var state_20862__$1 = state_20862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20862__$1,inst_20860);
} else {
if((state_val_20863 === (12))){
var inst_20832 = (state_20862[(2)]);
var state_20862__$1 = (function (){var statearr_20871 = state_20862;
(statearr_20871[(8)] = inst_20832);

return statearr_20871;
})();
if(cljs.core.truth_(from_t)){
var statearr_20872_20906 = state_20862__$1;
(statearr_20872_20906[(1)] = (13));

} else {
var statearr_20873_20907 = state_20862__$1;
(statearr_20873_20907[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (2))){
var inst_20816 = (state_20862[(9)]);
var _ = (function (){var statearr_20874 = state_20862;
(statearr_20874[(4)] = cljs.core.cons((5),(state_20862[(4)])));

return statearr_20874;
})();
var inst_20816__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_20817 = (from_t == null);
var inst_20818 = (inst_20816__$1 <= from_t);
var inst_20819 = ((inst_20817) || (inst_20818));
var state_20862__$1 = (function (){var statearr_20875 = state_20862;
(statearr_20875[(9)] = inst_20816__$1);

return statearr_20875;
})();
if(cljs.core.truth_(inst_20819)){
var statearr_20876_20908 = state_20862__$1;
(statearr_20876_20908[(1)] = (6));

} else {
var statearr_20877_20909 = state_20862__$1;
(statearr_20877_20909[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (11))){
var inst_20825 = (state_20862[(10)]);
var state_20862__$1 = state_20862;
var statearr_20879_20910 = state_20862__$1;
(statearr_20879_20910[(2)] = inst_20825);

(statearr_20879_20910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (9))){
var inst_20816 = (state_20862[(9)]);
var inst_20824 = (state_20862[(2)]);
var inst_20825 = fluree.db.util.async.throw_err(inst_20824);
var inst_20826 = (to_t > inst_20816);
var state_20862__$1 = (function (){var statearr_20880 = state_20862;
(statearr_20880[(10)] = inst_20825);

return statearr_20880;
})();
if(cljs.core.truth_(inst_20826)){
var statearr_20881_20911 = state_20862__$1;
(statearr_20881_20911[(1)] = (10));

} else {
var statearr_20882_20912 = state_20862__$1;
(statearr_20882_20912[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (5))){
var _ = (function (){var statearr_20883 = state_20862;
(statearr_20883[(4)] = cljs.core.rest((state_20862[(4)])));

return statearr_20883;
})();
var state_20862__$1 = state_20862;
var ex20878 = (state_20862__$1[(2)]);
var statearr_20884_20913 = state_20862__$1;
(statearr_20884_20913[(5)] = ex20878);


var statearr_20885_20914 = state_20862__$1;
(statearr_20885_20914[(1)] = (4));

(statearr_20885_20914[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (14))){
var inst_20832 = (state_20862[(8)]);
var state_20862__$1 = state_20862;
var statearr_20886_20915 = state_20862__$1;
(statearr_20886_20915[(2)] = inst_20832);

(statearr_20886_20915[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (16))){
var state_20862__$1 = state_20862;
var statearr_20887_20916 = state_20862__$1;
(statearr_20887_20916[(2)] = null);

(statearr_20887_20916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (10))){
var inst_20825 = (state_20862[(10)]);
var inst_20816 = (state_20862[(9)]);
var inst_20828 = (function (){var node_t = inst_20816;
var G__20821 = inst_20825;
return (function (p1__20806_SHARP_){
return (p1__20806_SHARP_.t < to_t);
});
})();
var inst_20829 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_20828,inst_20825);
var state_20862__$1 = state_20862;
var statearr_20888_20917 = state_20862__$1;
(statearr_20888_20917[(2)] = inst_20829);

(statearr_20888_20917[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (18))){
var inst_20841 = (state_20862[(11)]);
var inst_20843 = (state_20862[(12)]);
var inst_20842 = (state_20862[(13)]);
var inst_20855 = (state_20862[(2)]);
var inst_20856 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_20842,inst_20843,leftmost_QMARK_,to_t);
var inst_20857 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20856,inst_20841);
var _ = (function (){var statearr_20889 = state_20862;
(statearr_20889[(4)] = cljs.core.rest((state_20862[(4)])));

return statearr_20889;
})();
var state_20862__$1 = (function (){var statearr_20890 = state_20862;
(statearr_20890[(14)] = inst_20855);

return statearr_20890;
})();
var statearr_20891_20918 = state_20862__$1;
(statearr_20891_20918[(2)] = inst_20857);

(statearr_20891_20918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20863 === (8))){
var inst_20841 = (state_20862[(2)]);
var inst_20842 = fluree.db.dbproto._first_flake(node);
var inst_20843 = fluree.db.dbproto._rhs(node);
var inst_20844 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_20862__$1 = (function (){var statearr_20892 = state_20862;
(statearr_20892[(11)] = inst_20841);

(statearr_20892[(12)] = inst_20843);

(statearr_20892[(13)] = inst_20842);

return statearr_20892;
})();
if(cljs.core.truth_(inst_20844)){
var statearr_20893_20919 = state_20862__$1;
(statearr_20893_20919[(1)] = (16));

} else {
var statearr_20894_20920 = state_20862__$1;
(statearr_20894_20920[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0 = (function (){
var statearr_20895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20895[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__);

(statearr_20895[(1)] = (1));

return statearr_20895;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1 = (function (state_20862){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20862);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20896){var ex__2882__auto__ = e20896;
var statearr_20897_20921 = state_20862;
(statearr_20897_20921[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20862[(4)]))){
var statearr_20898_20922 = state_20862;
(statearr_20898_20922[(1)] = cljs.core.first((state_20862[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20923 = state_20862;
state_20862 = G__20923;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__ = function(state_20862){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1.call(this,state_20862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20899 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20899[(6)] = c__2901__auto__);

return statearr_20899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__20924_20934 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20925_20935 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20924_20934,G__20925_20935) : object_cache.call(null,G__20924_20934,G__20925_20935));

var G__20926 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20927 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__20928 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20929 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20928,G__20929) : object_cache.call(null,G__20928,G__20929));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20926,G__20927) : object_cache.call(null,G__20926,G__20927));
} else {
var G__20930 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20931 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__20932 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20933 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20932,G__20933) : object_cache.call(null,G__20932,G__20933));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20930,G__20931) : object_cache.call(null,G__20930,G__20931));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20956){
var state_val_20957 = (state_20956[(1)]);
if((state_val_20957 === (7))){
var state_20956__$1 = state_20956;
var statearr_20958_20978 = state_20956__$1;
(statearr_20958_20978[(2)] = null);

(statearr_20958_20978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (1))){
var state_20956__$1 = state_20956;
var statearr_20959_20979 = state_20956__$1;
(statearr_20959_20979[(2)] = null);

(statearr_20959_20979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (4))){
var inst_20936 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20960_20980 = state_20956__$1;
(statearr_20960_20980[(2)] = inst_20936);

(statearr_20960_20980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (6))){
var inst_20942 = (state_20956[(7)]);
var inst_20944 = fluree.db.storage.core.serde(conn);
var state_20956__$1 = (function (){var statearr_20961 = state_20956;
(statearr_20961[(8)] = inst_20944);

return statearr_20961;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20956__$1,(9),inst_20942);
} else {
if((state_val_20957 === (3))){
var inst_20954 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20956__$1,inst_20954);
} else {
if((state_val_20957 === (2))){
var inst_20942 = (state_20956[(7)]);
var _ = (function (){var statearr_20963 = state_20956;
(statearr_20963[(4)] = cljs.core.cons((5),(state_20956[(4)])));

return statearr_20963;
})();
var inst_20942__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_20956__$1 = (function (){var statearr_20964 = state_20956;
(statearr_20964[(7)] = inst_20942__$1);

return statearr_20964;
})();
if(cljs.core.truth_(inst_20942__$1)){
var statearr_20965_20981 = state_20956__$1;
(statearr_20965_20981[(1)] = (6));

} else {
var statearr_20966_20982 = state_20956__$1;
(statearr_20966_20982[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (9))){
var inst_20944 = (state_20956[(8)]);
var inst_20946 = (state_20956[(2)]);
var inst_20947 = fluree.db.util.async.throw_err(inst_20946);
var inst_20948 = fluree.db.serde.protocol._deserialize_branch(inst_20944,inst_20947);
var state_20956__$1 = state_20956;
var statearr_20967_20983 = state_20956__$1;
(statearr_20967_20983[(2)] = inst_20948);

(statearr_20967_20983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (5))){
var _ = (function (){var statearr_20968 = state_20956;
(statearr_20968[(4)] = cljs.core.rest((state_20956[(4)])));

return statearr_20968;
})();
var state_20956__$1 = state_20956;
var ex20962 = (state_20956__$1[(2)]);
var statearr_20969_20984 = state_20956__$1;
(statearr_20969_20984[(5)] = ex20962);


if((ex20962 instanceof Error)){
var statearr_20970_20985 = state_20956__$1;
(statearr_20970_20985[(1)] = (4));

(statearr_20970_20985[(5)] = null);

} else {
throw ex20962;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (8))){
var inst_20951 = (state_20956[(2)]);
var _ = (function (){var statearr_20971 = state_20956;
(statearr_20971[(4)] = cljs.core.rest((state_20956[(4)])));

return statearr_20971;
})();
var state_20956__$1 = state_20956;
var statearr_20972_20986 = state_20956__$1;
(statearr_20972_20986[(2)] = inst_20951);

(statearr_20972_20986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0 = (function (){
var statearr_20973 = [null,null,null,null,null,null,null,null,null];
(statearr_20973[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2879__auto__);

(statearr_20973[(1)] = (1));

return statearr_20973;
});
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1 = (function (state_20956){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_20956);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20974){var ex__2882__auto__ = e20974;
var statearr_20975_20987 = state_20956;
(statearr_20975_20987[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_20956[(4)]))){
var statearr_20976_20988 = state_20956;
(statearr_20976_20988[(1)] = cljs.core.first((state_20956[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20989 = state_20956;
state_20956 = G__20989;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__ = function(state_20956){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1.call(this,state_20956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20977 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_20977[(6)] = c__2901__auto__);

return statearr_20977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___21135 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21080){
var state_val_21081 = (state_21080[(1)]);
if((state_val_21081 === (7))){
var inst_21007 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21008 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21009 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21010 = cljs.core.PersistentHashMap.fromArrays(inst_21008,inst_21009);
var inst_21011 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21007,inst_21010);
var inst_21012 = (function(){throw inst_21011})();
var state_21080__$1 = state_21080;
var statearr_21082_21136 = state_21080__$1;
(statearr_21082_21136[(2)] = inst_21012);

(statearr_21082_21136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (20))){
var inst_21004 = (state_21080[(7)]);
var state_21080__$1 = state_21080;
var statearr_21083_21137 = state_21080__$1;
(statearr_21083_21137[(2)] = inst_21004);

(statearr_21083_21137[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (27))){
var inst_21058 = (state_21080[(2)]);
var state_21080__$1 = state_21080;
var statearr_21084_21138 = state_21080__$1;
(statearr_21084_21138[(2)] = inst_21058);

(statearr_21084_21138[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (1))){
var state_21080__$1 = state_21080;
var statearr_21085_21139 = state_21080__$1;
(statearr_21085_21139[(2)] = null);

(statearr_21085_21139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (24))){
var inst_21061 = (state_21080[(2)]);
var state_21080__$1 = state_21080;
if(cljs.core.truth_(inst_21061)){
var statearr_21086_21140 = state_21080__$1;
(statearr_21086_21140[(1)] = (28));

} else {
var statearr_21087_21141 = state_21080__$1;
(statearr_21087_21141[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (4))){
var inst_20990 = (state_21080[(2)]);
var inst_20991 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20992 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20990);
var inst_20993 = cljs.core.async.close_BANG_(return_ch);
var state_21080__$1 = (function (){var statearr_21088 = state_21080;
(statearr_21088[(8)] = inst_20992);

(statearr_21088[(9)] = inst_20991);

return statearr_21088;
})();
var statearr_21089_21142 = state_21080__$1;
(statearr_21089_21142[(2)] = inst_20993);

(statearr_21089_21142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (15))){
var inst_21037 = (state_21080[(2)]);
var state_21080__$1 = state_21080;
if(cljs.core.truth_(inst_21037)){
var statearr_21090_21143 = state_21080__$1;
(statearr_21090_21143[(1)] = (19));

} else {
var statearr_21091_21144 = state_21080__$1;
(statearr_21091_21144[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (21))){
var inst_21045 = (state_21080[(10)]);
var inst_21042 = (state_21080[(11)]);
var inst_21042__$1 = (state_21080[(2)]);
var inst_21043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21042__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_21044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21042__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_21045__$1 = config;
var inst_21047 = (inst_21045__$1 == null);
var inst_21048 = cljs.core.not(inst_21047);
var state_21080__$1 = (function (){var statearr_21092 = state_21080;
(statearr_21092[(12)] = inst_21043);

(statearr_21092[(13)] = inst_21044);

(statearr_21092[(10)] = inst_21045__$1);

(statearr_21092[(11)] = inst_21042__$1);

return statearr_21092;
})();
if(inst_21048){
var statearr_21093_21145 = state_21080__$1;
(statearr_21093_21145[(1)] = (22));

} else {
var statearr_21094_21146 = state_21080__$1;
(statearr_21094_21146[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (13))){
var inst_21004 = (state_21080[(7)]);
var inst_21026 = inst_21004.cljs$lang$protocol_mask$partition0$;
var inst_21027 = (inst_21026 & (64));
var inst_21028 = inst_21004.cljs$core$ISeq$;
var inst_21029 = (cljs.core.PROTOCOL_SENTINEL === inst_21028);
var inst_21030 = ((inst_21027) || (inst_21029));
var state_21080__$1 = state_21080;
if(cljs.core.truth_(inst_21030)){
var statearr_21095_21147 = state_21080__$1;
(statearr_21095_21147[(1)] = (16));

} else {
var statearr_21096_21148 = state_21080__$1;
(statearr_21096_21148[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (22))){
var inst_21045 = (state_21080[(10)]);
var inst_21050 = inst_21045.cljs$lang$protocol_mask$partition0$;
var inst_21051 = (inst_21050 & (64));
var inst_21052 = inst_21045.cljs$core$ISeq$;
var inst_21053 = (cljs.core.PROTOCOL_SENTINEL === inst_21052);
var inst_21054 = ((inst_21051) || (inst_21053));
var state_21080__$1 = state_21080;
if(cljs.core.truth_(inst_21054)){
var statearr_21097_21149 = state_21080__$1;
(statearr_21097_21149[(1)] = (25));

} else {
var statearr_21098_21150 = state_21080__$1;
(statearr_21098_21150[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (29))){
var inst_21045 = (state_21080[(10)]);
var state_21080__$1 = state_21080;
var statearr_21099_21151 = state_21080__$1;
(statearr_21099_21151[(2)] = inst_21045);

(statearr_21099_21151[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (6))){
var inst_21004 = (state_21080[(7)]);
var inst_21003 = (state_21080[(2)]);
var inst_21004__$1 = fluree.db.util.async.throw_err(inst_21003);
var inst_21005 = (inst_21004__$1 == null);
var state_21080__$1 = (function (){var statearr_21100 = state_21080;
(statearr_21100[(7)] = inst_21004__$1);

return statearr_21100;
})();
if(cljs.core.truth_(inst_21005)){
var statearr_21101_21152 = state_21080__$1;
(statearr_21101_21152[(1)] = (7));

} else {
var statearr_21102_21153 = state_21080__$1;
(statearr_21102_21153[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (28))){
var inst_21045 = (state_21080[(10)]);
var inst_21063 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21045);
var state_21080__$1 = state_21080;
var statearr_21103_21154 = state_21080__$1;
(statearr_21103_21154[(2)] = inst_21063);

(statearr_21103_21154[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (25))){
var state_21080__$1 = state_21080;
var statearr_21104_21155 = state_21080__$1;
(statearr_21104_21155[(2)] = true);

(statearr_21104_21155[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (17))){
var state_21080__$1 = state_21080;
var statearr_21105_21156 = state_21080__$1;
(statearr_21105_21156[(2)] = false);

(statearr_21105_21156[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (3))){
var inst_21078 = (state_21080[(2)]);
var state_21080__$1 = state_21080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21080__$1,inst_21078);
} else {
if((state_val_21081 === (12))){
var inst_21004 = (state_21080[(7)]);
var inst_21021 = (state_21080[(2)]);
var inst_21023 = (inst_21004 == null);
var inst_21024 = cljs.core.not(inst_21023);
var state_21080__$1 = (function (){var statearr_21106 = state_21080;
(statearr_21106[(14)] = inst_21021);

return statearr_21106;
})();
if(inst_21024){
var statearr_21107_21157 = state_21080__$1;
(statearr_21107_21157[(1)] = (13));

} else {
var statearr_21108_21158 = state_21080__$1;
(statearr_21108_21158[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (2))){
var _ = (function (){var statearr_21109 = state_21080;
(statearr_21109[(4)] = cljs.core.cons((5),(state_21080[(4)])));

return statearr_21109;
})();
var inst_21001 = fluree.db.storage.core.read_branch(conn,key);
var state_21080__$1 = state_21080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21080__$1,(6),inst_21001);
} else {
if((state_val_21081 === (23))){
var state_21080__$1 = state_21080;
var statearr_21110_21159 = state_21080__$1;
(statearr_21110_21159[(2)] = false);

(statearr_21110_21159[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (19))){
var inst_21004 = (state_21080[(7)]);
var inst_21039 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21004);
var state_21080__$1 = state_21080;
var statearr_21111_21160 = state_21080__$1;
(statearr_21111_21160[(2)] = inst_21039);

(statearr_21111_21160[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (11))){
var state_21080__$1 = state_21080;
var statearr_21113_21161 = state_21080__$1;
(statearr_21113_21161[(2)] = null);

(statearr_21113_21161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (9))){
var inst_21004 = (state_21080[(7)]);
var inst_21015 = (state_21080[(2)]);
var inst_21016 = fluree.db.util.core.exception_QMARK_(inst_21004);
var state_21080__$1 = (function (){var statearr_21114 = state_21080;
(statearr_21114[(15)] = inst_21015);

return statearr_21114;
})();
if(inst_21016){
var statearr_21115_21162 = state_21080__$1;
(statearr_21115_21162[(1)] = (10));

} else {
var statearr_21116_21163 = state_21080__$1;
(statearr_21116_21163[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (5))){
var _ = (function (){var statearr_21117 = state_21080;
(statearr_21117[(4)] = cljs.core.rest((state_21080[(4)])));

return statearr_21117;
})();
var state_21080__$1 = state_21080;
var ex21112 = (state_21080__$1[(2)]);
var statearr_21118_21164 = state_21080__$1;
(statearr_21118_21164[(5)] = ex21112);


var statearr_21119_21165 = state_21080__$1;
(statearr_21119_21165[(1)] = (4));

(statearr_21119_21165[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (14))){
var state_21080__$1 = state_21080;
var statearr_21120_21166 = state_21080__$1;
(statearr_21120_21166[(2)] = false);

(statearr_21120_21166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (26))){
var state_21080__$1 = state_21080;
var statearr_21121_21167 = state_21080__$1;
(statearr_21121_21167[(2)] = false);

(statearr_21121_21167[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (16))){
var state_21080__$1 = state_21080;
var statearr_21122_21168 = state_21080__$1;
(statearr_21122_21168[(2)] = true);

(statearr_21122_21168[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (30))){
var inst_21021 = (state_21080[(14)]);
var inst_21043 = (state_21080[(12)]);
var inst_21044 = (state_21080[(13)]);
var inst_21004 = (state_21080[(7)]);
var inst_21042 = (state_21080[(11)]);
var inst_21066 = (state_21080[(2)]);
var inst_21067 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21066,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21069 = (function (){var data = inst_21004;
var _ = inst_21021;
var map__20999 = inst_21042;
var children = inst_21043;
var rhs = inst_21044;
var map__21000 = inst_21066;
var comparator = inst_21067;
return (function (idx,p__21068){
var map__21123 = p__21068;
var map__21123__$1 = (((((!((map__21123 == null))))?(((((map__21123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21123.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21123):map__21123);
var child = map__21123__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21123__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21123__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21123__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21123__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21123__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_21070 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_21069,inst_21043);
var inst_21071 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_21070);
var inst_21072 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_21071,inst_21070);
var inst_21073 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_21067,inst_21072);
var inst_21074 = fluree.db.index.__GT_IndexNode(block,t,inst_21044,inst_21073,config,leftmost_QMARK_);
var inst_21075 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21074);
var _ = (function (){var statearr_21125 = state_21080;
(statearr_21125[(4)] = cljs.core.rest((state_21080[(4)])));

return statearr_21125;
})();
var state_21080__$1 = state_21080;
var statearr_21126_21169 = state_21080__$1;
(statearr_21126_21169[(2)] = inst_21075);

(statearr_21126_21169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (10))){
var inst_21004 = (state_21080[(7)]);
var inst_21018 = (function(){throw inst_21004})();
var state_21080__$1 = state_21080;
var statearr_21127_21170 = state_21080__$1;
(statearr_21127_21170[(2)] = inst_21018);

(statearr_21127_21170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (18))){
var inst_21034 = (state_21080[(2)]);
var state_21080__$1 = state_21080;
var statearr_21128_21171 = state_21080__$1;
(statearr_21128_21171[(2)] = inst_21034);

(statearr_21128_21171[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21081 === (8))){
var state_21080__$1 = state_21080;
var statearr_21129_21172 = state_21080__$1;
(statearr_21129_21172[(2)] = null);

(statearr_21129_21172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0 = (function (){
var statearr_21130 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21130[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__);

(statearr_21130[(1)] = (1));

return statearr_21130;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1 = (function (state_21080){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21080);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21131){var ex__2882__auto__ = e21131;
var statearr_21132_21173 = state_21080;
(statearr_21132_21173[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21080[(4)]))){
var statearr_21133_21174 = state_21080;
(statearr_21133_21174[(1)] = cljs.core.first((state_21080[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21175 = state_21080;
state_21080 = G__21175;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__ = function(state_21080){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1.call(this,state_21080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21134 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21134[(6)] = c__2901__auto___21135);

return statearr_21134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21196){
var state_val_21197 = (state_21196[(1)]);
if((state_val_21197 === (7))){
var state_21196__$1 = state_21196;
var statearr_21198_21218 = state_21196__$1;
(statearr_21198_21218[(2)] = null);

(statearr_21198_21218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (1))){
var state_21196__$1 = state_21196;
var statearr_21199_21219 = state_21196__$1;
(statearr_21199_21219[(2)] = null);

(statearr_21199_21219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (4))){
var inst_21176 = (state_21196[(2)]);
var state_21196__$1 = state_21196;
var statearr_21200_21220 = state_21196__$1;
(statearr_21200_21220[(2)] = inst_21176);

(statearr_21200_21220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (6))){
var inst_21182 = (state_21196[(7)]);
var inst_21184 = fluree.db.storage.core.serde(conn);
var state_21196__$1 = (function (){var statearr_21201 = state_21196;
(statearr_21201[(8)] = inst_21184);

return statearr_21201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21196__$1,(9),inst_21182);
} else {
if((state_val_21197 === (3))){
var inst_21194 = (state_21196[(2)]);
var state_21196__$1 = state_21196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21196__$1,inst_21194);
} else {
if((state_val_21197 === (2))){
var inst_21182 = (state_21196[(7)]);
var _ = (function (){var statearr_21203 = state_21196;
(statearr_21203[(4)] = cljs.core.cons((5),(state_21196[(4)])));

return statearr_21203;
})();
var inst_21182__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_21196__$1 = (function (){var statearr_21204 = state_21196;
(statearr_21204[(7)] = inst_21182__$1);

return statearr_21204;
})();
if(cljs.core.truth_(inst_21182__$1)){
var statearr_21205_21221 = state_21196__$1;
(statearr_21205_21221[(1)] = (6));

} else {
var statearr_21206_21222 = state_21196__$1;
(statearr_21206_21222[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (9))){
var inst_21184 = (state_21196[(8)]);
var inst_21186 = (state_21196[(2)]);
var inst_21187 = fluree.db.util.async.throw_err(inst_21186);
var inst_21188 = fluree.db.serde.protocol._deserialize_leaf(inst_21184,inst_21187);
var state_21196__$1 = state_21196;
var statearr_21207_21223 = state_21196__$1;
(statearr_21207_21223[(2)] = inst_21188);

(statearr_21207_21223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (5))){
var _ = (function (){var statearr_21208 = state_21196;
(statearr_21208[(4)] = cljs.core.rest((state_21196[(4)])));

return statearr_21208;
})();
var state_21196__$1 = state_21196;
var ex21202 = (state_21196__$1[(2)]);
var statearr_21209_21224 = state_21196__$1;
(statearr_21209_21224[(5)] = ex21202);


if((ex21202 instanceof Error)){
var statearr_21210_21225 = state_21196__$1;
(statearr_21210_21225[(1)] = (4));

(statearr_21210_21225[(5)] = null);

} else {
throw ex21202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (8))){
var inst_21191 = (state_21196[(2)]);
var _ = (function (){var statearr_21211 = state_21196;
(statearr_21211[(4)] = cljs.core.rest((state_21196[(4)])));

return statearr_21211;
})();
var state_21196__$1 = state_21196;
var statearr_21212_21226 = state_21196__$1;
(statearr_21212_21226[(2)] = inst_21191);

(statearr_21212_21226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_21213 = [null,null,null,null,null,null,null,null,null];
(statearr_21213[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__);

(statearr_21213[(1)] = (1));

return statearr_21213;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1 = (function (state_21196){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21196);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21214){var ex__2882__auto__ = e21214;
var statearr_21215_21227 = state_21196;
(statearr_21215_21227[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21196[(4)]))){
var statearr_21216_21228 = state_21196;
(statearr_21216_21228[(1)] = cljs.core.first((state_21196[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21229 = state_21196;
state_21196 = G__21229;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__ = function(state_21196){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1.call(this,state_21196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21217 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21217[(6)] = c__2901__auto__);

return statearr_21217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___21367 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21314){
var state_val_21315 = (state_21314[(1)]);
if((state_val_21315 === (7))){
var inst_21246 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21248 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21249 = cljs.core.PersistentHashMap.fromArrays(inst_21247,inst_21248);
var inst_21250 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21246,inst_21249);
var inst_21251 = (function(){throw inst_21250})();
var state_21314__$1 = state_21314;
var statearr_21316_21368 = state_21314__$1;
(statearr_21316_21368[(2)] = inst_21251);

(statearr_21316_21368[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (20))){
var inst_21243 = (state_21314[(7)]);
var state_21314__$1 = state_21314;
var statearr_21317_21369 = state_21314__$1;
(statearr_21317_21369[(2)] = inst_21243);

(statearr_21317_21369[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (27))){
var inst_21297 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21318_21370 = state_21314__$1;
(statearr_21318_21370[(2)] = inst_21297);

(statearr_21318_21370[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (1))){
var state_21314__$1 = state_21314;
var statearr_21319_21371 = state_21314__$1;
(statearr_21319_21371[(2)] = null);

(statearr_21319_21371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (24))){
var inst_21300 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
if(cljs.core.truth_(inst_21300)){
var statearr_21320_21372 = state_21314__$1;
(statearr_21320_21372[(1)] = (28));

} else {
var statearr_21321_21373 = state_21314__$1;
(statearr_21321_21373[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (4))){
var inst_21230 = (state_21314[(2)]);
var inst_21231 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_21232 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21230);
var inst_21233 = cljs.core.async.close_BANG_(return_ch);
var state_21314__$1 = (function (){var statearr_21322 = state_21314;
(statearr_21322[(8)] = inst_21232);

(statearr_21322[(9)] = inst_21231);

return statearr_21322;
})();
var statearr_21323_21374 = state_21314__$1;
(statearr_21323_21374[(2)] = inst_21233);

(statearr_21323_21374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (15))){
var inst_21276 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
if(cljs.core.truth_(inst_21276)){
var statearr_21324_21375 = state_21314__$1;
(statearr_21324_21375[(1)] = (19));

} else {
var statearr_21325_21376 = state_21314__$1;
(statearr_21325_21376[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (21))){
var inst_21284 = (state_21314[(10)]);
var inst_21281 = (state_21314[(2)]);
var inst_21282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21281,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_21283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21281,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_21284__$1 = config;
var inst_21286 = (inst_21284__$1 == null);
var inst_21287 = cljs.core.not(inst_21286);
var state_21314__$1 = (function (){var statearr_21326 = state_21314;
(statearr_21326[(11)] = inst_21283);

(statearr_21326[(10)] = inst_21284__$1);

(statearr_21326[(12)] = inst_21282);

return statearr_21326;
})();
if(inst_21287){
var statearr_21327_21377 = state_21314__$1;
(statearr_21327_21377[(1)] = (22));

} else {
var statearr_21328_21378 = state_21314__$1;
(statearr_21328_21378[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (13))){
var inst_21243 = (state_21314[(7)]);
var inst_21265 = inst_21243.cljs$lang$protocol_mask$partition0$;
var inst_21266 = (inst_21265 & (64));
var inst_21267 = inst_21243.cljs$core$ISeq$;
var inst_21268 = (cljs.core.PROTOCOL_SENTINEL === inst_21267);
var inst_21269 = ((inst_21266) || (inst_21268));
var state_21314__$1 = state_21314;
if(cljs.core.truth_(inst_21269)){
var statearr_21329_21379 = state_21314__$1;
(statearr_21329_21379[(1)] = (16));

} else {
var statearr_21330_21380 = state_21314__$1;
(statearr_21330_21380[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (22))){
var inst_21284 = (state_21314[(10)]);
var inst_21289 = inst_21284.cljs$lang$protocol_mask$partition0$;
var inst_21290 = (inst_21289 & (64));
var inst_21291 = inst_21284.cljs$core$ISeq$;
var inst_21292 = (cljs.core.PROTOCOL_SENTINEL === inst_21291);
var inst_21293 = ((inst_21290) || (inst_21292));
var state_21314__$1 = state_21314;
if(cljs.core.truth_(inst_21293)){
var statearr_21331_21381 = state_21314__$1;
(statearr_21331_21381[(1)] = (25));

} else {
var statearr_21332_21382 = state_21314__$1;
(statearr_21332_21382[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (29))){
var inst_21284 = (state_21314[(10)]);
var state_21314__$1 = state_21314;
var statearr_21333_21383 = state_21314__$1;
(statearr_21333_21383[(2)] = inst_21284);

(statearr_21333_21383[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (6))){
var inst_21243 = (state_21314[(7)]);
var inst_21243__$1 = (state_21314[(2)]);
var inst_21244 = (inst_21243__$1 == null);
var state_21314__$1 = (function (){var statearr_21334 = state_21314;
(statearr_21334[(7)] = inst_21243__$1);

return statearr_21334;
})();
if(cljs.core.truth_(inst_21244)){
var statearr_21335_21384 = state_21314__$1;
(statearr_21335_21384[(1)] = (7));

} else {
var statearr_21336_21385 = state_21314__$1;
(statearr_21336_21385[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (28))){
var inst_21284 = (state_21314[(10)]);
var inst_21302 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21284);
var state_21314__$1 = state_21314;
var statearr_21337_21386 = state_21314__$1;
(statearr_21337_21386[(2)] = inst_21302);

(statearr_21337_21386[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (25))){
var state_21314__$1 = state_21314;
var statearr_21338_21387 = state_21314__$1;
(statearr_21338_21387[(2)] = true);

(statearr_21338_21387[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (17))){
var state_21314__$1 = state_21314;
var statearr_21339_21388 = state_21314__$1;
(statearr_21339_21388[(2)] = false);

(statearr_21339_21388[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (3))){
var inst_21312 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21314__$1,inst_21312);
} else {
if((state_val_21315 === (12))){
var inst_21243 = (state_21314[(7)]);
var inst_21260 = (state_21314[(2)]);
var inst_21262 = (inst_21243 == null);
var inst_21263 = cljs.core.not(inst_21262);
var state_21314__$1 = (function (){var statearr_21340 = state_21314;
(statearr_21340[(13)] = inst_21260);

return statearr_21340;
})();
if(inst_21263){
var statearr_21341_21389 = state_21314__$1;
(statearr_21341_21389[(1)] = (13));

} else {
var statearr_21342_21390 = state_21314__$1;
(statearr_21342_21390[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (2))){
var _ = (function (){var statearr_21343 = state_21314;
(statearr_21343[(4)] = cljs.core.cons((5),(state_21314[(4)])));

return statearr_21343;
})();
var inst_21241 = fluree.db.storage.core.read_leaf(conn,key);
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21314__$1,(6),inst_21241);
} else {
if((state_val_21315 === (23))){
var state_21314__$1 = state_21314;
var statearr_21344_21391 = state_21314__$1;
(statearr_21344_21391[(2)] = false);

(statearr_21344_21391[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (19))){
var inst_21243 = (state_21314[(7)]);
var inst_21278 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21243);
var state_21314__$1 = state_21314;
var statearr_21345_21392 = state_21314__$1;
(statearr_21345_21392[(2)] = inst_21278);

(statearr_21345_21392[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (11))){
var state_21314__$1 = state_21314;
var statearr_21347_21393 = state_21314__$1;
(statearr_21347_21393[(2)] = null);

(statearr_21347_21393[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (9))){
var inst_21243 = (state_21314[(7)]);
var inst_21254 = (state_21314[(2)]);
var inst_21255 = fluree.db.util.core.exception_QMARK_(inst_21243);
var state_21314__$1 = (function (){var statearr_21348 = state_21314;
(statearr_21348[(14)] = inst_21254);

return statearr_21348;
})();
if(inst_21255){
var statearr_21349_21394 = state_21314__$1;
(statearr_21349_21394[(1)] = (10));

} else {
var statearr_21350_21395 = state_21314__$1;
(statearr_21350_21395[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (5))){
var _ = (function (){var statearr_21351 = state_21314;
(statearr_21351[(4)] = cljs.core.rest((state_21314[(4)])));

return statearr_21351;
})();
var state_21314__$1 = state_21314;
var ex21346 = (state_21314__$1[(2)]);
var statearr_21352_21396 = state_21314__$1;
(statearr_21352_21396[(5)] = ex21346);


var statearr_21353_21397 = state_21314__$1;
(statearr_21353_21397[(1)] = (4));

(statearr_21353_21397[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (14))){
var state_21314__$1 = state_21314;
var statearr_21354_21398 = state_21314__$1;
(statearr_21354_21398[(2)] = false);

(statearr_21354_21398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (26))){
var state_21314__$1 = state_21314;
var statearr_21355_21399 = state_21314__$1;
(statearr_21355_21399[(2)] = false);

(statearr_21355_21399[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (16))){
var state_21314__$1 = state_21314;
var statearr_21356_21400 = state_21314__$1;
(statearr_21356_21400[(2)] = true);

(statearr_21356_21400[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (30))){
var inst_21282 = (state_21314[(12)]);
var inst_21305 = (state_21314[(2)]);
var inst_21306 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21305,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21307 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_21306,inst_21282);
var inst_21308 = fluree.db.index.data_node(block,t,inst_21307,rhs,config);
var inst_21309 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21308);
var _ = (function (){var statearr_21357 = state_21314;
(statearr_21357[(4)] = cljs.core.rest((state_21314[(4)])));

return statearr_21357;
})();
var state_21314__$1 = state_21314;
var statearr_21358_21401 = state_21314__$1;
(statearr_21358_21401[(2)] = inst_21309);

(statearr_21358_21401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (10))){
var inst_21243 = (state_21314[(7)]);
var inst_21257 = (function(){throw inst_21243})();
var state_21314__$1 = state_21314;
var statearr_21359_21402 = state_21314__$1;
(statearr_21359_21402[(2)] = inst_21257);

(statearr_21359_21402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (18))){
var inst_21273 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21360_21403 = state_21314__$1;
(statearr_21360_21403[(2)] = inst_21273);

(statearr_21360_21403[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (8))){
var state_21314__$1 = state_21314;
var statearr_21361_21404 = state_21314__$1;
(statearr_21361_21404[(2)] = null);

(statearr_21361_21404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_21362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21362[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__);

(statearr_21362[(1)] = (1));

return statearr_21362;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1 = (function (state_21314){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21314);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21363){var ex__2882__auto__ = e21363;
var statearr_21364_21405 = state_21314;
(statearr_21364_21405[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21314[(4)]))){
var statearr_21365_21406 = state_21314;
(statearr_21365_21406[(1)] = cljs.core.first((state_21314[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21407 = state_21314;
state_21314 = G__21407;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__ = function(state_21314){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1.call(this,state_21314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21366 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21366[(6)] = c__2901__auto___21367);

return statearr_21366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k21409,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__21413 = k21409;
var G__21413__$1 = (((G__21413 instanceof cljs.core.Keyword))?G__21413.fqn:null);
switch (G__21413__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k21409,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__21414){
var vec__21415 = p__21414;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21415,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21415,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21408){
var self__ = this;
var G__21408__$1 = this;
return (new cljs.core.RecordIter((0),G__21408__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__21418 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21419 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__21420 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21421 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21420,G__21421) : object_cache.call(null,G__21420,G__21421));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__21422 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21423 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21422,G__21423) : object_cache.call(null,G__21422,G__21423));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21418,G__21419) : object_cache.call(null,G__21418,G__21419));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__21424 = history_id;
var G__21425 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21424,G__21425) : object_cache.call(null,G__21424,G__21425));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__21426 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__21426(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21410,other21411){
var self__ = this;
var this21410__$1 = this;
return (((!((other21411 == null)))) && ((this21410__$1.constructor === other21411.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.conn,other21411.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.config,other21411.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.network,other21411.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.dbid,other21411.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.id,other21411.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.leaf,other21411.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.first,other21411.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.rhs,other21411.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.size,other21411.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.block,other21411.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.t,other21411.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.tt_id,other21411.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.leftmost_QMARK_,other21411.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.tempid,other21411.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21410__$1.__extmap,other21411.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__21408){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__21427 = cljs.core.keyword_identical_QMARK_;
var expr__21428 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__21430 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__21431 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21430,G__21431) : pred__21427.call(null,G__21430,G__21431));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__21408,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21432 = new cljs.core.Keyword(null,"config","config",994861415);
var G__21433 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21432,G__21433) : pred__21427.call(null,G__21432,G__21433));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__21408,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21434 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__21435 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21434,G__21435) : pred__21427.call(null,G__21434,G__21435));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__21408,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21436 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__21437 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21436,G__21437) : pred__21427.call(null,G__21436,G__21437));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__21408,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21438 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__21439 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21438,G__21439) : pred__21427.call(null,G__21438,G__21439));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__21408,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21440 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__21441 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21440,G__21441) : pred__21427.call(null,G__21440,G__21441));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__21408,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21442 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__21443 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21442,G__21443) : pred__21427.call(null,G__21442,G__21443));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__21408,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21444 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__21445 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21444,G__21445) : pred__21427.call(null,G__21444,G__21445));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__21408,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21446 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__21447 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21446,G__21447) : pred__21427.call(null,G__21446,G__21447));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__21408,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21448 = new cljs.core.Keyword(null,"block","block",664686210);
var G__21449 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21448,G__21449) : pred__21427.call(null,G__21448,G__21449));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__21408,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21450 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__21451 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21450,G__21451) : pred__21427.call(null,G__21450,G__21451));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__21408,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21452 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__21453 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21452,G__21453) : pred__21427.call(null,G__21452,G__21453));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__21408,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21454 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__21455 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21454,G__21455) : pred__21427.call(null,G__21454,G__21455));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__21408,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21456 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__21457 = expr__21428;
return (pred__21427.cljs$core$IFn$_invoke$arity$2 ? pred__21427.cljs$core$IFn$_invoke$arity$2(G__21456,G__21457) : pred__21427.call(null,G__21456,G__21457));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__21408,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__21408),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__21408){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__21408,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__21412){
var extmap__4419__auto__ = (function (){var G__21458 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__21412,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__21412)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__21458);
} else {
return G__21458;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__21412),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__21412),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__21460 = blank_db;
var map__21460__$1 = (((((!((map__21460 == null))))?(((((map__21460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21460):map__21460);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21460__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__21461 = root_data;
var map__21461__$1 = (((((!((map__21461 == null))))?(((((map__21461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21461.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21461):map__21461);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21461__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21461__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21461__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21461__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21485){
var state_val_21486 = (state_21485[(1)]);
if((state_val_21486 === (7))){
var state_21485__$1 = state_21485;
var statearr_21487_21507 = state_21485__$1;
(statearr_21487_21507[(2)] = null);

(statearr_21487_21507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (1))){
var state_21485__$1 = state_21485;
var statearr_21488_21508 = state_21485__$1;
(statearr_21488_21508[(2)] = null);

(statearr_21488_21508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (4))){
var inst_21464 = (state_21485[(2)]);
var state_21485__$1 = state_21485;
var statearr_21489_21509 = state_21485__$1;
(statearr_21489_21509[(2)] = inst_21464);

(statearr_21489_21509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (6))){
var inst_21471 = (state_21485[(7)]);
var inst_21473 = fluree.db.storage.core.serde(conn);
var state_21485__$1 = (function (){var statearr_21490 = state_21485;
(statearr_21490[(8)] = inst_21473);

return statearr_21490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21485__$1,(9),inst_21471);
} else {
if((state_val_21486 === (3))){
var inst_21483 = (state_21485[(2)]);
var state_21485__$1 = state_21485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21485__$1,inst_21483);
} else {
if((state_val_21486 === (2))){
var inst_21471 = (state_21485[(7)]);
var _ = (function (){var statearr_21492 = state_21485;
(statearr_21492[(4)] = cljs.core.cons((5),(state_21485[(4)])));

return statearr_21492;
})();
var inst_21470 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_21471__$1 = fluree.db.storage.core.storage_read(conn,inst_21470);
var state_21485__$1 = (function (){var statearr_21493 = state_21485;
(statearr_21493[(7)] = inst_21471__$1);

return statearr_21493;
})();
if(cljs.core.truth_(inst_21471__$1)){
var statearr_21494_21510 = state_21485__$1;
(statearr_21494_21510[(1)] = (6));

} else {
var statearr_21495_21511 = state_21485__$1;
(statearr_21495_21511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (9))){
var inst_21473 = (state_21485[(8)]);
var inst_21475 = (state_21485[(2)]);
var inst_21476 = fluree.db.util.async.throw_err(inst_21475);
var inst_21477 = fluree.db.serde.protocol._deserialize_garbage(inst_21473,inst_21476);
var state_21485__$1 = state_21485;
var statearr_21496_21512 = state_21485__$1;
(statearr_21496_21512[(2)] = inst_21477);

(statearr_21496_21512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (5))){
var _ = (function (){var statearr_21497 = state_21485;
(statearr_21497[(4)] = cljs.core.rest((state_21485[(4)])));

return statearr_21497;
})();
var state_21485__$1 = state_21485;
var ex21491 = (state_21485__$1[(2)]);
var statearr_21498_21513 = state_21485__$1;
(statearr_21498_21513[(5)] = ex21491);


if((ex21491 instanceof Error)){
var statearr_21499_21514 = state_21485__$1;
(statearr_21499_21514[(1)] = (4));

(statearr_21499_21514[(5)] = null);

} else {
throw ex21491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21486 === (8))){
var inst_21480 = (state_21485[(2)]);
var _ = (function (){var statearr_21500 = state_21485;
(statearr_21500[(4)] = cljs.core.rest((state_21485[(4)])));

return statearr_21500;
})();
var state_21485__$1 = state_21485;
var statearr_21501_21515 = state_21485__$1;
(statearr_21501_21515[(2)] = inst_21480);

(statearr_21501_21515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0 = (function (){
var statearr_21502 = [null,null,null,null,null,null,null,null,null];
(statearr_21502[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__);

(statearr_21502[(1)] = (1));

return statearr_21502;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1 = (function (state_21485){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21485);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21503){var ex__2882__auto__ = e21503;
var statearr_21504_21516 = state_21485;
(statearr_21504_21516[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21485[(4)]))){
var statearr_21505_21517 = state_21485;
(statearr_21505_21517[(1)] = cljs.core.first((state_21485[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21518 = state_21485;
state_21485 = G__21518;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__ = function(state_21485){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1.call(this,state_21485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21506 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21506[(6)] = c__2901__auto__);

return statearr_21506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21540){
var state_val_21541 = (state_21540[(1)]);
if((state_val_21541 === (7))){
var state_21540__$1 = state_21540;
var statearr_21542_21562 = state_21540__$1;
(statearr_21542_21562[(2)] = null);

(statearr_21542_21562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (1))){
var state_21540__$1 = state_21540;
var statearr_21543_21563 = state_21540__$1;
(statearr_21543_21563[(2)] = null);

(statearr_21543_21563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (4))){
var inst_21519 = (state_21540[(2)]);
var state_21540__$1 = state_21540;
var statearr_21544_21564 = state_21540__$1;
(statearr_21544_21564[(2)] = inst_21519);

(statearr_21544_21564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (6))){
var inst_21526 = (state_21540[(7)]);
var inst_21528 = fluree.db.storage.core.serde(conn);
var state_21540__$1 = (function (){var statearr_21545 = state_21540;
(statearr_21545[(8)] = inst_21528);

return statearr_21545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21540__$1,(9),inst_21526);
} else {
if((state_val_21541 === (3))){
var inst_21538 = (state_21540[(2)]);
var state_21540__$1 = state_21540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21540__$1,inst_21538);
} else {
if((state_val_21541 === (2))){
var inst_21526 = (state_21540[(7)]);
var _ = (function (){var statearr_21547 = state_21540;
(statearr_21547[(4)] = cljs.core.cons((5),(state_21540[(4)])));

return statearr_21547;
})();
var inst_21525 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_21526__$1 = fluree.db.storage.core.storage_read(conn,inst_21525);
var state_21540__$1 = (function (){var statearr_21548 = state_21540;
(statearr_21548[(7)] = inst_21526__$1);

return statearr_21548;
})();
if(cljs.core.truth_(inst_21526__$1)){
var statearr_21549_21565 = state_21540__$1;
(statearr_21549_21565[(1)] = (6));

} else {
var statearr_21550_21566 = state_21540__$1;
(statearr_21550_21566[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (9))){
var inst_21528 = (state_21540[(8)]);
var inst_21530 = (state_21540[(2)]);
var inst_21531 = fluree.db.util.async.throw_err(inst_21530);
var inst_21532 = fluree.db.serde.protocol._deserialize_db_root(inst_21528,inst_21531);
var state_21540__$1 = state_21540;
var statearr_21551_21567 = state_21540__$1;
(statearr_21551_21567[(2)] = inst_21532);

(statearr_21551_21567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (5))){
var _ = (function (){var statearr_21552 = state_21540;
(statearr_21552[(4)] = cljs.core.rest((state_21540[(4)])));

return statearr_21552;
})();
var state_21540__$1 = state_21540;
var ex21546 = (state_21540__$1[(2)]);
var statearr_21553_21568 = state_21540__$1;
(statearr_21553_21568[(5)] = ex21546);


if((ex21546 instanceof Error)){
var statearr_21554_21569 = state_21540__$1;
(statearr_21554_21569[(1)] = (4));

(statearr_21554_21569[(5)] = null);

} else {
throw ex21546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21541 === (8))){
var inst_21535 = (state_21540[(2)]);
var _ = (function (){var statearr_21555 = state_21540;
(statearr_21555[(4)] = cljs.core.rest((state_21540[(4)])));

return statearr_21555;
})();
var state_21540__$1 = state_21540;
var statearr_21556_21570 = state_21540__$1;
(statearr_21556_21570[(2)] = inst_21535);

(statearr_21556_21570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0 = (function (){
var statearr_21557 = [null,null,null,null,null,null,null,null,null];
(statearr_21557[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__);

(statearr_21557[(1)] = (1));

return statearr_21557;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1 = (function (state_21540){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21540);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21558){var ex__2882__auto__ = e21558;
var statearr_21559_21571 = state_21540;
(statearr_21559_21571[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21540[(4)]))){
var statearr_21560_21572 = state_21540;
(statearr_21560_21572[(1)] = cljs.core.first((state_21540[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21573 = state_21540;
state_21540 = G__21573;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__ = function(state_21540){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1.call(this,state_21540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21561 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21561[(6)] = c__2901__auto__);

return statearr_21561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21609){
var state_val_21610 = (state_21609[(1)]);
if((state_val_21610 === (7))){
var inst_21583 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_21584 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21585 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_21586 = cljs.core.PersistentHashMap.fromArrays(inst_21584,inst_21585);
var inst_21587 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21583,inst_21586);
var inst_21588 = (function(){throw inst_21587})();
var state_21609__$1 = state_21609;
var statearr_21611_21633 = state_21609__$1;
(statearr_21611_21633[(2)] = inst_21588);

(statearr_21611_21633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (1))){
var state_21609__$1 = state_21609;
var statearr_21612_21634 = state_21609__$1;
(statearr_21612_21634[(2)] = null);

(statearr_21612_21634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (4))){
var inst_21574 = (state_21609[(2)]);
var state_21609__$1 = state_21609;
var statearr_21613_21635 = state_21609__$1;
(statearr_21613_21635[(2)] = inst_21574);

(statearr_21613_21635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (6))){
var state_21609__$1 = state_21609;
var statearr_21614_21636 = state_21609__$1;
(statearr_21614_21636[(2)] = null);

(statearr_21614_21636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (3))){
var inst_21607 = (state_21609[(2)]);
var state_21609__$1 = state_21609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21609__$1,inst_21607);
} else {
if((state_val_21610 === (2))){
var inst_21580 = (state_21609[(7)]);
var _ = (function (){var statearr_21615 = state_21609;
(statearr_21615[(4)] = cljs.core.cons((5),(state_21609[(4)])));

return statearr_21615;
})();
var inst_21580__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_21609__$1 = (function (){var statearr_21616 = state_21609;
(statearr_21616[(7)] = inst_21580__$1);

return statearr_21616;
})();
if(cljs.core.truth_(inst_21580__$1)){
var statearr_21617_21637 = state_21609__$1;
(statearr_21617_21637[(1)] = (6));

} else {
var statearr_21618_21638 = state_21609__$1;
(statearr_21618_21638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (11))){
var inst_21599 = (state_21609[(8)]);
var inst_21602 = (state_21609[(2)]);
var inst_21603 = fluree.db.util.async.throw_err(inst_21602);
var inst_21604 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21599,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_21603);
var _ = (function (){var statearr_21620 = state_21609;
(statearr_21620[(4)] = cljs.core.rest((state_21609[(4)])));

return statearr_21620;
})();
var state_21609__$1 = state_21609;
var statearr_21621_21639 = state_21609__$1;
(statearr_21621_21639[(2)] = inst_21604);

(statearr_21621_21639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (9))){
var inst_21594 = (state_21609[(9)]);
var inst_21592 = (state_21609[(2)]);
var inst_21593 = fluree.db.util.async.throw_err(inst_21592);
var inst_21594__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_21593);
var inst_21595 = fluree.db.query.schema.schema_map(inst_21594__$1);
var state_21609__$1 = (function (){var statearr_21622 = state_21609;
(statearr_21622[(9)] = inst_21594__$1);

return statearr_21622;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21609__$1,(10),inst_21595);
} else {
if((state_val_21610 === (5))){
var _ = (function (){var statearr_21623 = state_21609;
(statearr_21623[(4)] = cljs.core.rest((state_21609[(4)])));

return statearr_21623;
})();
var state_21609__$1 = state_21609;
var ex21619 = (state_21609__$1[(2)]);
var statearr_21624_21640 = state_21609__$1;
(statearr_21624_21640[(5)] = ex21619);


if((ex21619 instanceof Error)){
var statearr_21625_21641 = state_21609__$1;
(statearr_21625_21641[(1)] = (4));

(statearr_21625_21641[(5)] = null);

} else {
throw ex21619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21610 === (10))){
var inst_21594 = (state_21609[(9)]);
var inst_21599 = (state_21609[(8)]);
var inst_21597 = (state_21609[(2)]);
var inst_21598 = fluree.db.util.async.throw_err(inst_21597);
var inst_21599__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21594,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_21598);
var inst_21600 = fluree.db.query.schema.setting_map(inst_21599__$1);
var state_21609__$1 = (function (){var statearr_21626 = state_21609;
(statearr_21626[(8)] = inst_21599__$1);

return statearr_21626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21609__$1,(11),inst_21600);
} else {
if((state_val_21610 === (8))){
var inst_21580 = (state_21609[(7)]);
var inst_21590 = (state_21609[(2)]);
var state_21609__$1 = (function (){var statearr_21627 = state_21609;
(statearr_21627[(10)] = inst_21590);

return statearr_21627;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21609__$1,(9),inst_21580);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0 = (function (){
var statearr_21628 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21628[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2879__auto__);

(statearr_21628[(1)] = (1));

return statearr_21628;
});
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1 = (function (state_21609){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21609);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21629){var ex__2882__auto__ = e21629;
var statearr_21630_21642 = state_21609;
(statearr_21630_21642[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21609[(4)]))){
var statearr_21631_21643 = state_21609;
(statearr_21631_21643[(1)] = cljs.core.first((state_21609[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21644 = state_21609;
state_21609 = G__21644;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__ = function(state_21609){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1.call(this,state_21609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21632 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21632[(6)] = c__2901__auto__);

return statearr_21632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__21646 = arguments.length;
switch (G__21646) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21696){
var state_val_21697 = (state_21696[(1)]);
if((state_val_21697 === (7))){
var inst_21656 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_21657 = (new Error(inst_21656));
var inst_21658 = (function(){throw inst_21657})();
var state_21696__$1 = state_21696;
var statearr_21698_21734 = state_21696__$1;
(statearr_21698_21734[(2)] = inst_21658);

(statearr_21698_21734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (20))){
var inst_21685 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21699_21735 = state_21696__$1;
(statearr_21699_21735[(2)] = inst_21685);

(statearr_21699_21735[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (1))){
var state_21696__$1 = state_21696;
var statearr_21700_21736 = state_21696__$1;
(statearr_21700_21736[(2)] = null);

(statearr_21700_21736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (4))){
var inst_21647 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21701_21737 = state_21696__$1;
(statearr_21701_21737[(2)] = inst_21647);

(statearr_21701_21737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (15))){
var inst_21669 = (state_21696[(7)]);
var inst_21665 = (state_21696[(8)]);
var inst_21677 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21665,inst_21669);
var state_21696__$1 = state_21696;
var statearr_21702_21738 = state_21696__$1;
(statearr_21702_21738[(2)] = inst_21677);

(statearr_21702_21738[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (13))){
var inst_21664 = (state_21696[(9)]);
var inst_21675 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21664,end);
var state_21696__$1 = state_21696;
if(inst_21675){
var statearr_21703_21739 = state_21696__$1;
(statearr_21703_21739[(1)] = (15));

} else {
var statearr_21704_21740 = state_21696__$1;
(statearr_21704_21740[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (6))){
var state_21696__$1 = state_21696;
var statearr_21705_21741 = state_21696__$1;
(statearr_21705_21741[(2)] = null);

(statearr_21705_21741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (17))){
var inst_21687 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21706_21742 = state_21696__$1;
(statearr_21706_21742[(2)] = inst_21687);

(statearr_21706_21742[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (3))){
var inst_21694 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21696__$1,inst_21694);
} else {
if((state_val_21697 === (12))){
var inst_21665 = (state_21696[(8)]);
var state_21696__$1 = state_21696;
var statearr_21707_21743 = state_21696__$1;
(statearr_21707_21743[(2)] = inst_21665);

(statearr_21707_21743[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (2))){
var _ = (function (){var statearr_21708 = state_21696;
(statearr_21708[(4)] = cljs.core.cons((5),(state_21696[(4)])));

return statearr_21708;
})();
var inst_21653 = (end >= start);
var state_21696__$1 = state_21696;
if(cljs.core.truth_(inst_21653)){
var statearr_21709_21744 = state_21696__$1;
(statearr_21709_21744[(1)] = (6));

} else {
var statearr_21710_21745 = state_21696__$1;
(statearr_21710_21745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (19))){
var state_21696__$1 = state_21696;
var statearr_21711_21746 = state_21696__$1;
(statearr_21711_21746[(2)] = null);

(statearr_21711_21746[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (11))){
var inst_21669 = (state_21696[(7)]);
var inst_21669__$1 = (state_21696[(2)]);
var inst_21670 = (inst_21669__$1 == null);
var inst_21671 = (inst_21669__$1 instanceof Error);
var inst_21672 = ((inst_21670) || (inst_21671));
var state_21696__$1 = (function (){var statearr_21713 = state_21696;
(statearr_21713[(7)] = inst_21669__$1);

return statearr_21713;
})();
if(cljs.core.truth_(inst_21672)){
var statearr_21714_21747 = state_21696__$1;
(statearr_21714_21747[(1)] = (12));

} else {
var statearr_21715_21748 = state_21696__$1;
(statearr_21715_21748[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (9))){
var inst_21664 = (state_21696[(9)]);
var inst_21667 = fluree.db.storage.core.read_block(conn,network,dbid,inst_21664);
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21696__$1,(11),inst_21667);
} else {
if((state_val_21697 === (5))){
var _ = (function (){var statearr_21716 = state_21696;
(statearr_21716[(4)] = cljs.core.rest((state_21696[(4)])));

return statearr_21716;
})();
var state_21696__$1 = state_21696;
var ex21712 = (state_21696__$1[(2)]);
var statearr_21717_21749 = state_21696__$1;
(statearr_21717_21749[(5)] = ex21712);


if((ex21712 instanceof Error)){
var statearr_21718_21750 = state_21696__$1;
(statearr_21718_21750[(1)] = (4));

(statearr_21718_21750[(5)] = null);

} else {
throw ex21712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (14))){
var inst_21689 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21719_21751 = state_21696__$1;
(statearr_21719_21751[(2)] = inst_21689);

(statearr_21719_21751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (16))){
var state_21696__$1 = state_21696;
var statearr_21720_21752 = state_21696__$1;
(statearr_21720_21752[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (10))){
var inst_21691 = (state_21696[(2)]);
var _ = (function (){var statearr_21722 = state_21696;
(statearr_21722[(4)] = cljs.core.rest((state_21696[(4)])));

return statearr_21722;
})();
var state_21696__$1 = state_21696;
var statearr_21723_21753 = state_21696__$1;
(statearr_21723_21753[(2)] = inst_21691);

(statearr_21723_21753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (18))){
var inst_21664 = (state_21696[(9)]);
var inst_21669 = (state_21696[(7)]);
var inst_21665 = (state_21696[(8)]);
var inst_21680 = (inst_21664 + (1));
var inst_21681 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21665,inst_21669);
var inst_21664__$1 = inst_21680;
var inst_21665__$1 = inst_21681;
var state_21696__$1 = (function (){var statearr_21724 = state_21696;
(statearr_21724[(9)] = inst_21664__$1);

(statearr_21724[(8)] = inst_21665__$1);

return statearr_21724;
})();
var statearr_21725_21754 = state_21696__$1;
(statearr_21725_21754[(2)] = null);

(statearr_21725_21754[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (8))){
var inst_21660 = (state_21696[(2)]);
var inst_21661 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21662 = start;
var inst_21663 = cljs.core.PersistentVector.EMPTY;
var inst_21664 = inst_21662;
var inst_21665 = inst_21663;
var state_21696__$1 = (function (){var statearr_21726 = state_21696;
(statearr_21726[(9)] = inst_21664);

(statearr_21726[(10)] = inst_21660);

(statearr_21726[(8)] = inst_21665);

(statearr_21726[(11)] = inst_21661);

return statearr_21726;
})();
var statearr_21727_21755 = state_21696__$1;
(statearr_21727_21755[(2)] = null);

(statearr_21727_21755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2879__auto__ = null;
var fluree$db$storage$core$state_machine__2879__auto____0 = (function (){
var statearr_21728 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21728[(0)] = fluree$db$storage$core$state_machine__2879__auto__);

(statearr_21728[(1)] = (1));

return statearr_21728;
});
var fluree$db$storage$core$state_machine__2879__auto____1 = (function (state_21696){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21696);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21729){var ex__2882__auto__ = e21729;
var statearr_21730_21756 = state_21696;
(statearr_21730_21756[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21696[(4)]))){
var statearr_21731_21757 = state_21696;
(statearr_21731_21757[(1)] = cljs.core.first((state_21696[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21758 = state_21696;
state_21696 = G__21758;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2879__auto__ = function(state_21696){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2879__auto____1.call(this,state_21696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2879__auto____0;
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2879__auto____1;
return fluree$db$storage$core$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21732 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21732[(6)] = c__2901__auto__);

return statearr_21732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21774){
var state_val_21775 = (state_21774[(1)]);
if((state_val_21775 === (1))){
var state_21774__$1 = state_21774;
var statearr_21776_21790 = state_21774__$1;
(statearr_21776_21790[(2)] = null);

(statearr_21776_21790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (2))){
var _ = (function (){var statearr_21777 = state_21774;
(statearr_21777[(4)] = cljs.core.cons((5),(state_21774[(4)])));

return statearr_21777;
})();
var inst_21765 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_21774__$1 = state_21774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21774__$1,(6),inst_21765);
} else {
if((state_val_21775 === (3))){
var inst_21772 = (state_21774[(2)]);
var state_21774__$1 = state_21774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21774__$1,inst_21772);
} else {
if((state_val_21775 === (4))){
var inst_21759 = (state_21774[(2)]);
var state_21774__$1 = state_21774;
var statearr_21779_21791 = state_21774__$1;
(statearr_21779_21791[(2)] = inst_21759);

(statearr_21779_21791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (5))){
var _ = (function (){var statearr_21780 = state_21774;
(statearr_21780[(4)] = cljs.core.rest((state_21774[(4)])));

return statearr_21780;
})();
var state_21774__$1 = state_21774;
var ex21778 = (state_21774__$1[(2)]);
var statearr_21781_21792 = state_21774__$1;
(statearr_21781_21792[(5)] = ex21778);


if((ex21778 instanceof Error)){
var statearr_21782_21793 = state_21774__$1;
(statearr_21782_21793[(1)] = (4));

(statearr_21782_21793[(5)] = null);

} else {
throw ex21778;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (6))){
var inst_21767 = (state_21774[(2)]);
var inst_21768 = fluree.db.util.async.throw_err(inst_21767);
var inst_21769 = cljs.core.first(inst_21768);
var _ = (function (){var statearr_21783 = state_21774;
(statearr_21783[(4)] = cljs.core.rest((state_21774[(4)])));

return statearr_21783;
})();
var state_21774__$1 = state_21774;
var statearr_21784_21794 = state_21774__$1;
(statearr_21784_21794[(2)] = inst_21769);

(statearr_21784_21794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2879__auto____0 = (function (){
var statearr_21785 = [null,null,null,null,null,null,null];
(statearr_21785[(0)] = fluree$db$storage$core$block_$_state_machine__2879__auto__);

(statearr_21785[(1)] = (1));

return statearr_21785;
});
var fluree$db$storage$core$block_$_state_machine__2879__auto____1 = (function (state_21774){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21774);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21786){var ex__2882__auto__ = e21786;
var statearr_21787_21795 = state_21774;
(statearr_21787_21795[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21774[(4)]))){
var statearr_21788_21796 = state_21774;
(statearr_21788_21796[(1)] = cljs.core.first((state_21774[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21797 = state_21774;
state_21774 = G__21797;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2879__auto__ = function(state_21774){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2879__auto____1.call(this,state_21774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2879__auto____0;
fluree$db$storage$core$block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21789 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21789[(6)] = c__2901__auto__);

return statearr_21789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
