// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27801,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27805 = k27801;
var G__27805__$1 = (((G__27805 instanceof cljs.core.Keyword))?G__27805.fqn:null);
switch (G__27805__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27801,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27806){
var vec__27807 = p__27806;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27807,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27807,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27800){
var self__ = this;
var G__27800__$1 = this;
return (new cljs.core.RecordIter((0),G__27800__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__27810 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__27810(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27802,other27803){
var self__ = this;
var this27802__$1 = this;
return (((!((other27803 == null)))) && ((this27802__$1.constructor === other27803.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.conn,other27803.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.network,other27803.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.dbid,other27803.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.db_name,other27803.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.update_chan,other27803.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.transact_chan,other27803.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.state,other27803.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.schema_cache,other27803.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.blank_db,other27803.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.close,other27803.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.id,other27803.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27802__$1.__extmap,other27803.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27800){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27811 = cljs.core.keyword_identical_QMARK_;
var expr__27812 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__27814 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27815 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27814,G__27815) : pred__27811.call(null,G__27814,G__27815));
})())){
return (new fluree.db.session.DbSession(G__27800,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27816 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27817 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27816,G__27817) : pred__27811.call(null,G__27816,G__27817));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27800,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27818 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27819 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27818,G__27819) : pred__27811.call(null,G__27818,G__27819));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27800,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27820 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27821 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27820,G__27821) : pred__27811.call(null,G__27820,G__27821));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27800,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27822 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27823 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27822,G__27823) : pred__27811.call(null,G__27822,G__27823));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27800,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27824 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27825 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27824,G__27825) : pred__27811.call(null,G__27824,G__27825));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27800,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27826 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27827 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27826,G__27827) : pred__27811.call(null,G__27826,G__27827));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27800,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27828 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27829 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27828,G__27829) : pred__27811.call(null,G__27828,G__27829));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27800,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27830 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27831 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27830,G__27831) : pred__27811.call(null,G__27830,G__27831));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27800,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27832 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27833 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27832,G__27833) : pred__27811.call(null,G__27832,G__27833));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27800,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27834 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27835 = expr__27812;
return (pred__27811.cljs$core$IFn$_invoke$arity$2 ? pred__27811.cljs$core$IFn$_invoke$arity$2(G__27834,G__27835) : pred__27811.call(null,G__27834,G__27835));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27800,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27800),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27800){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27800,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27804){
var extmap__4419__auto__ = (function (){var G__27836 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27804,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27804)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27836);
} else {
return G__27836;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27804),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27804),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27838 = session;
var map__27838__$1 = (((((!((map__27838 == null))))?(((((map__27838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27838):map__27838);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27838__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27838__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___28056 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27983){
var state_val_27984 = (state_27983[(1)]);
if((state_val_27984 === (7))){
var state_27983__$1 = state_27983;
var statearr_27985_28057 = state_27983__$1;
(statearr_27985_28057[(2)] = false);

(statearr_27985_28057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (20))){
var inst_27880 = (state_27983[(7)]);
var inst_27873 = (state_27983[(8)]);
var inst_27872 = (state_27983[(9)]);
var inst_27889 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27880);
var inst_27890 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27872),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27873)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27889),"."].join('');
var state_27983__$1 = state_27983;
var statearr_27986_28058 = state_27983__$1;
(statearr_27986_28058[(2)] = inst_27890);

(statearr_27986_28058[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (27))){
var inst_27964 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
var statearr_27987_28059 = state_27983__$1;
(statearr_27987_28059[(2)] = inst_27964);

(statearr_27987_28059[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (1))){
var state_27983__$1 = state_27983;
var statearr_27988_28060 = state_27983__$1;
(statearr_27988_28060[(2)] = null);

(statearr_27988_28060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (24))){
var state_27983__$1 = state_27983;
var statearr_27989_28061 = state_27983__$1;
(statearr_27989_28061[(2)] = null);

(statearr_27989_28061[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (39))){
var state_27983__$1 = state_27983;
var statearr_27990_28062 = state_27983__$1;
(statearr_27990_28062[(2)] = false);

(statearr_27990_28062[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (46))){
var inst_27972 = (state_27983[(10)]);
var inst_27975 = (state_27983[(2)]);
var inst_27976 = fluree.db.util.async.throw_err(inst_27975);
var inst_27977 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27972,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27976);
var inst_27978 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27977);
var _ = (function (){var statearr_27991 = state_27983;
(statearr_27991[(4)] = cljs.core.rest((state_27983[(4)])));

return statearr_27991;
})();
var state_27983__$1 = state_27983;
var statearr_27992_28063 = state_27983__$1;
(statearr_27992_28063[(2)] = inst_27978);

(statearr_27992_28063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (4))){
var inst_27840 = (state_27983[(2)]);
var inst_27841 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27840);
var state_27983__$1 = state_27983;
var statearr_27993_28064 = state_27983__$1;
(statearr_27993_28064[(2)] = inst_27841);

(statearr_27993_28064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (15))){
var inst_27880 = (state_27983[(7)]);
var inst_27879 = (state_27983[(2)]);
var inst_27880__$1 = fluree.db.util.async.throw_err(inst_27879);
var inst_27881 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27880__$1);
var inst_27882 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27881);
var inst_27883 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27882);
var state_27983__$1 = (function (){var statearr_27994 = state_27983;
(statearr_27994[(7)] = inst_27880__$1);

return statearr_27994;
})();
if(inst_27883){
var statearr_27995_28065 = state_27983__$1;
(statearr_27995_28065[(1)] = (16));

} else {
var statearr_27996_28066 = state_27983__$1;
(statearr_27996_28066[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (21))){
var inst_27892 = (state_27983[(2)]);
var inst_27893 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27894 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27895 = cljs.core.PersistentHashMap.fromArrays(inst_27893,inst_27894);
var inst_27896 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27892,inst_27895);
var inst_27897 = (function(){throw inst_27896})();
var state_27983__$1 = state_27983;
var statearr_27997_28067 = state_27983__$1;
(statearr_27997_28067[(2)] = inst_27897);

(statearr_27997_28067[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (31))){
var inst_27919 = (state_27983[(11)]);
var inst_27918 = (state_27983[(2)]);
var inst_27919__$1 = fluree.db.util.async.throw_err(inst_27918);
var state_27983__$1 = (function (){var statearr_27998 = state_27983;
(statearr_27998[(11)] = inst_27919__$1);

return statearr_27998;
})();
if(cljs.core.truth_(inst_27919__$1)){
var statearr_27999_28068 = state_27983__$1;
(statearr_27999_28068[(1)] = (32));

} else {
var statearr_28000_28069 = state_27983__$1;
(statearr_28000_28069[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (32))){
var inst_27919 = (state_27983[(11)]);
var inst_27923 = (inst_27919 == null);
var inst_27924 = cljs.core.not(inst_27923);
var state_27983__$1 = state_27983;
if(inst_27924){
var statearr_28001_28070 = state_27983__$1;
(statearr_28001_28070[(1)] = (35));

} else {
var statearr_28002_28071 = state_27983__$1;
(statearr_28002_28071[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (40))){
var inst_27934 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
var statearr_28003_28072 = state_27983__$1;
(statearr_28003_28072[(2)] = inst_27934);

(statearr_28003_28072[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (33))){
var inst_27911 = (state_27983[(12)]);
var inst_27873 = (state_27983[(8)]);
var inst_27872 = (state_27983[(9)]);
var inst_27953 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27911)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27872),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27873),"."].join('');
var inst_27954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27955 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27956 = cljs.core.PersistentHashMap.fromArrays(inst_27954,inst_27955);
var inst_27957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27953,inst_27956);
var inst_27958 = (function(){throw inst_27957})();
var state_27983__$1 = state_27983;
var statearr_28004_28073 = state_27983__$1;
(statearr_28004_28073[(2)] = inst_27958);

(statearr_28004_28073[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (13))){
var inst_27849 = (state_27983[(13)]);
var state_27983__$1 = state_27983;
var statearr_28005_28074 = state_27983__$1;
(statearr_28005_28074[(2)] = inst_27849);

(statearr_28005_28074[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (22))){
var inst_27905 = (state_27983[(14)]);
var inst_27880 = (state_27983[(7)]);
var inst_27904 = (state_27983[(2)]);
var inst_27905__$1 = fluree.db.util.async.throw_err(inst_27904);
var inst_27906 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27880);
var state_27983__$1 = (function (){var statearr_28006 = state_27983;
(statearr_28006[(14)] = inst_27905__$1);

(statearr_28006[(15)] = inst_27906);

return statearr_28006;
})();
if(cljs.core.truth_(inst_27905__$1)){
var statearr_28007_28075 = state_27983__$1;
(statearr_28007_28075[(1)] = (23));

} else {
var statearr_28008_28076 = state_27983__$1;
(statearr_28008_28076[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (36))){
var state_27983__$1 = state_27983;
var statearr_28009_28077 = state_27983__$1;
(statearr_28009_28077[(2)] = false);

(statearr_28009_28077[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (41))){
var inst_27919 = (state_27983[(11)]);
var inst_27939 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27919);
var state_27983__$1 = state_27983;
var statearr_28010_28078 = state_27983__$1;
(statearr_28010_28078[(2)] = inst_27939);

(statearr_28010_28078[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (43))){
var inst_27910 = (state_27983[(16)]);
var inst_27942 = (state_27983[(2)]);
var inst_27943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27942,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27942,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27942,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27946 = fluree.db.dbproto._with(inst_27910,inst_27944,inst_27943);
var state_27983__$1 = (function (){var statearr_28011 = state_27983;
(statearr_28011[(17)] = inst_27945);

return statearr_28011;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(44),inst_27946);
} else {
if((state_val_27984 === (29))){
var inst_27911 = (state_27983[(12)]);
var inst_27873 = (state_27983[(8)]);
var inst_27871 = (state_27983[(18)]);
var inst_27872 = (state_27983[(9)]);
var inst_27916 = fluree.db.storage.core.read_block(inst_27871,inst_27872,inst_27873,inst_27911);
var state_27983__$1 = state_27983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(31),inst_27916);
} else {
if((state_val_27984 === (44))){
var inst_27911 = (state_27983[(12)]);
var inst_27948 = (state_27983[(2)]);
var inst_27949 = fluree.db.util.async.throw_err(inst_27948);
var inst_27950 = (inst_27911 + (1));
var inst_27910 = inst_27949;
var inst_27911__$1 = inst_27950;
var state_27983__$1 = (function (){var statearr_28012 = state_27983;
(statearr_28012[(16)] = inst_27910);

(statearr_28012[(12)] = inst_27911__$1);

return statearr_28012;
})();
var statearr_28013_28079 = state_27983__$1;
(statearr_28013_28079[(2)] = null);

(statearr_28013_28079[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (6))){
var inst_27849 = (state_27983[(13)]);
var inst_27854 = inst_27849.cljs$lang$protocol_mask$partition0$;
var inst_27855 = (inst_27854 & (64));
var inst_27856 = inst_27849.cljs$core$ISeq$;
var inst_27857 = (cljs.core.PROTOCOL_SENTINEL === inst_27856);
var inst_27858 = ((inst_27855) || (inst_27857));
var state_27983__$1 = state_27983;
if(cljs.core.truth_(inst_27858)){
var statearr_28014_28080 = state_27983__$1;
(statearr_28014_28080[(1)] = (9));

} else {
var statearr_28015_28081 = state_27983__$1;
(statearr_28015_28081[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (28))){
var inst_27910 = (state_27983[(16)]);
var state_27983__$1 = state_27983;
var statearr_28016_28082 = state_27983__$1;
(statearr_28016_28082[(2)] = inst_27910);

(statearr_28016_28082[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (25))){
var inst_27967 = (state_27983[(19)]);
var inst_27967__$1 = (state_27983[(2)]);
var inst_27968 = fluree.db.query.schema.schema_map(inst_27967__$1);
var state_27983__$1 = (function (){var statearr_28017 = state_27983;
(statearr_28017[(19)] = inst_27967__$1);

return statearr_28017;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(45),inst_27968);
} else {
if((state_val_27984 === (34))){
var inst_27960 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
var statearr_28018_28083 = state_27983__$1;
(statearr_28018_28083[(2)] = inst_27960);

(statearr_28018_28083[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (17))){
var state_27983__$1 = state_27983;
var statearr_28019_28084 = state_27983__$1;
(statearr_28019_28084[(2)] = null);

(statearr_28019_28084[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (3))){
var inst_27981 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27983__$1,inst_27981);
} else {
if((state_val_27984 === (12))){
var inst_27849 = (state_27983[(13)]);
var inst_27867 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27849);
var state_27983__$1 = state_27983;
var statearr_28020_28085 = state_27983__$1;
(statearr_28020_28085[(2)] = inst_27867);

(statearr_28020_28085[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (2))){
var inst_27849 = (state_27983[(13)]);
var _ = (function (){var statearr_28021 = state_27983;
(statearr_28021[(4)] = cljs.core.cons((5),(state_27983[(4)])));

return statearr_28021;
})();
var inst_27848 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27849__$1 = session;
var inst_27851 = (inst_27849__$1 == null);
var inst_27852 = cljs.core.not(inst_27851);
var state_27983__$1 = (function (){var statearr_28022 = state_27983;
(statearr_28022[(13)] = inst_27849__$1);

(statearr_28022[(20)] = inst_27848);

return statearr_28022;
})();
if(inst_27852){
var statearr_28023_28086 = state_27983__$1;
(statearr_28023_28086[(1)] = (6));

} else {
var statearr_28024_28087 = state_27983__$1;
(statearr_28024_28087[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (23))){
var inst_27905 = (state_27983[(14)]);
var inst_27908 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27905);
var inst_27909 = (inst_27908 + (1));
var inst_27910 = inst_27905;
var inst_27911 = inst_27909;
var state_27983__$1 = (function (){var statearr_28025 = state_27983;
(statearr_28025[(16)] = inst_27910);

(statearr_28025[(12)] = inst_27911);

return statearr_28025;
})();
var statearr_28026_28088 = state_27983__$1;
(statearr_28026_28088[(2)] = null);

(statearr_28026_28088[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (35))){
var inst_27919 = (state_27983[(11)]);
var inst_27926 = inst_27919.cljs$lang$protocol_mask$partition0$;
var inst_27927 = (inst_27926 & (64));
var inst_27928 = inst_27919.cljs$core$ISeq$;
var inst_27929 = (cljs.core.PROTOCOL_SENTINEL === inst_27928);
var inst_27930 = ((inst_27927) || (inst_27929));
var state_27983__$1 = state_27983;
if(cljs.core.truth_(inst_27930)){
var statearr_28027_28089 = state_27983__$1;
(statearr_28027_28089[(1)] = (38));

} else {
var statearr_28028_28090 = state_27983__$1;
(statearr_28028_28090[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (19))){
var inst_27873 = (state_27983[(8)]);
var inst_27872 = (state_27983[(9)]);
var inst_27887 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27872),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27873)," is not found on this ledger group."].join('');
var state_27983__$1 = state_27983;
var statearr_28029_28091 = state_27983__$1;
(statearr_28029_28091[(2)] = inst_27887);

(statearr_28029_28091[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (11))){
var inst_27862 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
var statearr_28031_28092 = state_27983__$1;
(statearr_28031_28092[(2)] = inst_27862);

(statearr_28031_28092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (9))){
var state_27983__$1 = state_27983;
var statearr_28032_28093 = state_27983__$1;
(statearr_28032_28093[(2)] = true);

(statearr_28032_28093[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (5))){
var _ = (function (){var statearr_28033 = state_27983;
(statearr_28033[(4)] = cljs.core.rest((state_27983[(4)])));

return statearr_28033;
})();
var state_27983__$1 = state_27983;
var ex28030 = (state_27983__$1[(2)]);
var statearr_28034_28094 = state_27983__$1;
(statearr_28034_28094[(5)] = ex28030);


var statearr_28035_28095 = state_27983__$1;
(statearr_28035_28095[(1)] = (4));

(statearr_28035_28095[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (14))){
var inst_27873 = (state_27983[(8)]);
var inst_27871 = (state_27983[(18)]);
var inst_27872 = (state_27983[(9)]);
var inst_27870 = (state_27983[(2)]);
var inst_27871__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27870,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27872__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27870,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27873__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27870,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27875 = [inst_27872__$1,inst_27873__$1];
var inst_27876 = (new cljs.core.PersistentVector(null,2,(5),inst_27874,inst_27875,null));
var inst_27877 = fluree.db.operations.ledger_info_async(inst_27871__$1,inst_27876);
var state_27983__$1 = (function (){var statearr_28036 = state_27983;
(statearr_28036[(8)] = inst_27873__$1);

(statearr_28036[(18)] = inst_27871__$1);

(statearr_28036[(9)] = inst_27872__$1);

return statearr_28036;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(15),inst_27877);
} else {
if((state_val_27984 === (45))){
var inst_27967 = (state_27983[(19)]);
var inst_27972 = (state_27983[(10)]);
var inst_27970 = (state_27983[(2)]);
var inst_27971 = fluree.db.util.async.throw_err(inst_27970);
var inst_27972__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27967,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27971);
var inst_27973 = fluree.db.query.schema.setting_map(inst_27972__$1);
var state_27983__$1 = (function (){var statearr_28037 = state_27983;
(statearr_28037[(10)] = inst_27972__$1);

return statearr_28037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(46),inst_27973);
} else {
if((state_val_27984 === (26))){
var inst_27911 = (state_27983[(12)]);
var inst_27906 = (state_27983[(15)]);
var inst_27913 = (inst_27911 > inst_27906);
var state_27983__$1 = state_27983;
if(cljs.core.truth_(inst_27913)){
var statearr_28038_28096 = state_27983__$1;
(statearr_28038_28096[(1)] = (28));

} else {
var statearr_28039_28097 = state_27983__$1;
(statearr_28039_28097[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (16))){
var inst_27880 = (state_27983[(7)]);
var inst_27885 = cljs.core.empty_QMARK_(inst_27880);
var state_27983__$1 = state_27983;
if(inst_27885){
var statearr_28040_28098 = state_27983__$1;
(statearr_28040_28098[(1)] = (19));

} else {
var statearr_28041_28099 = state_27983__$1;
(statearr_28041_28099[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (38))){
var state_27983__$1 = state_27983;
var statearr_28042_28100 = state_27983__$1;
(statearr_28042_28100[(2)] = true);

(statearr_28042_28100[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (30))){
var inst_27962 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
var statearr_28043_28101 = state_27983__$1;
(statearr_28043_28101[(2)] = inst_27962);

(statearr_28043_28101[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (10))){
var state_27983__$1 = state_27983;
var statearr_28044_28102 = state_27983__$1;
(statearr_28044_28102[(2)] = false);

(statearr_28044_28102[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (18))){
var inst_27880 = (state_27983[(7)]);
var inst_27848 = (state_27983[(20)]);
var inst_27873 = (state_27983[(8)]);
var inst_27871 = (state_27983[(18)]);
var inst_27872 = (state_27983[(9)]);
var inst_27900 = (state_27983[(2)]);
var inst_27901 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27880);
var inst_27902 = fluree.db.storage.core.reify_db(inst_27871,inst_27872,inst_27873,inst_27848,inst_27901);
var state_27983__$1 = (function (){var statearr_28045 = state_27983;
(statearr_28045[(21)] = inst_27900);

return statearr_28045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27983__$1,(22),inst_27902);
} else {
if((state_val_27984 === (42))){
var inst_27919 = (state_27983[(11)]);
var state_27983__$1 = state_27983;
var statearr_28046_28103 = state_27983__$1;
(statearr_28046_28103[(2)] = inst_27919);

(statearr_28046_28103[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (37))){
var inst_27937 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
if(cljs.core.truth_(inst_27937)){
var statearr_28047_28104 = state_27983__$1;
(statearr_28047_28104[(1)] = (41));

} else {
var statearr_28048_28105 = state_27983__$1;
(statearr_28048_28105[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27984 === (8))){
var inst_27865 = (state_27983[(2)]);
var state_27983__$1 = state_27983;
if(cljs.core.truth_(inst_27865)){
var statearr_28049_28106 = state_27983__$1;
(statearr_28049_28106[(1)] = (12));

} else {
var statearr_28050_28107 = state_27983__$1;
(statearr_28050_28107[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0 = (function (){
var statearr_28051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28051[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__);

(statearr_28051[(1)] = (1));

return statearr_28051;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1 = (function (state_27983){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27983);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28052){var ex__2882__auto__ = e28052;
var statearr_28053_28108 = state_27983;
(statearr_28053_28108[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27983[(4)]))){
var statearr_28054_28109 = state_27983;
(statearr_28054_28109[(1)] = cljs.core.first((state_27983[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28110 = state_27983;
state_27983 = G__28110;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__ = function(state_27983){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1.call(this,state_27983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28055 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28055[(6)] = c__2901__auto___28056);

return statearr_28055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__28111 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28111,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__28111;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__28112 = cljs.core.get_global_hierarchy;
return (fexpr__28112.cljs$core$IFn$_invoke$arity$0 ? fexpr__28112.cljs$core$IFn$_invoke$arity$0() : fexpr__28112.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28114){
var state_val_28115 = (state_28114[(1)]);
if((state_val_28115 === (1))){
var state_28114__$1 = state_28114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28114__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28116 = [null,null,null,null,null,null,null];
(statearr_28116[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28116[(1)] = (1));

return statearr_28116;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28114){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28114);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28117){var ex__2882__auto__ = e28117;
var statearr_28118_28121 = state_28114;
(statearr_28118_28121[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28114[(4)]))){
var statearr_28119_28122 = state_28114;
(statearr_28119_28122[(1)] = cljs.core.first((state_28114[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28123 = state_28114;
state_28114 = G__28123;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28114){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28120 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28120[(6)] = c__2901__auto__);

return statearr_28120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28125){
var map__28126 = p__28125;
var map__28126__$1 = (((((!((map__28126 == null))))?(((((map__28126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28126.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28126):map__28126);
var data = map__28126__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28126__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28126__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28126__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28186){
var state_val_28187 = (state_28186[(1)]);
if((state_val_28187 === (7))){
var inst_28141 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28142 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28143 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28141),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28142),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_28144 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28143], 0));
var state_28186__$1 = state_28186;
var statearr_28188_28226 = state_28186__$1;
(statearr_28188_28226[(2)] = inst_28144);

(statearr_28188_28226[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (1))){
var state_28186__$1 = state_28186;
var statearr_28189_28227 = state_28186__$1;
(statearr_28189_28227[(2)] = null);

(statearr_28189_28227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (4))){
var inst_28128 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
var statearr_28190_28228 = state_28186__$1;
(statearr_28190_28228[(2)] = inst_28128);

(statearr_28190_28228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (15))){
var inst_28167 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
var statearr_28191_28229 = state_28186__$1;
(statearr_28191_28229[(2)] = inst_28167);

(statearr_28191_28229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (13))){
var inst_28158 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28160 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28161 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28162 = [inst_28160,inst_28161];
var inst_28163 = (new cljs.core.PersistentVector(null,2,(5),inst_28159,inst_28162,null));
var inst_28164 = (function (){var G__28192 = inst_28158;
var G__28193 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28194 = inst_28163;
var G__28195 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28192,G__28193,G__28194,G__28195) : fluree.db.conn_events.process_event.call(null,G__28192,G__28193,G__28194,G__28195));
})();
var state_28186__$1 = state_28186;
var statearr_28196_28230 = state_28186__$1;
(statearr_28196_28230[(2)] = inst_28164);

(statearr_28196_28230[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (6))){
var inst_28138 = (state_28186[(7)]);
var inst_28137 = (state_28186[(8)]);
var inst_28136 = (state_28186[(2)]);
var inst_28137__$1 = fluree.db.util.async.throw_err(inst_28136);
var inst_28138__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28137__$1);
var inst_28139 = (block <= inst_28138__$1);
var state_28186__$1 = (function (){var statearr_28197 = state_28186;
(statearr_28197[(7)] = inst_28138__$1);

(statearr_28197[(8)] = inst_28137__$1);

return statearr_28197;
})();
if(cljs.core.truth_(inst_28139)){
var statearr_28198_28231 = state_28186__$1;
(statearr_28198_28231[(1)] = (7));

} else {
var statearr_28199_28232 = state_28186__$1;
(statearr_28199_28232[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (17))){
var state_28186__$1 = state_28186;
var statearr_28200_28233 = state_28186__$1;
(statearr_28200_28233[(2)] = null);

(statearr_28200_28233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (3))){
var inst_28184 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28186__$1,inst_28184);
} else {
if((state_val_28187 === (12))){
var inst_28179 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
var statearr_28201_28234 = state_28186__$1;
(statearr_28201_28234[(2)] = inst_28179);

(statearr_28201_28234[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (2))){
var inst_28134 = (state_28186[(9)]);
var _ = (function (){var statearr_28202 = state_28186;
(statearr_28202[(4)] = cljs.core.cons((5),(state_28186[(4)])));

return statearr_28202;
})();
var inst_28134__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28186__$1 = (function (){var statearr_28203 = state_28186;
(statearr_28203[(9)] = inst_28134__$1);

return statearr_28203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28186__$1,(6),inst_28134__$1);
} else {
if((state_val_28187 === (11))){
var state_28186__$1 = state_28186;
var statearr_28205_28235 = state_28186__$1;
(statearr_28205_28235[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (9))){
var inst_28181 = (state_28186[(2)]);
var _ = (function (){var statearr_28207 = state_28186;
(statearr_28207[(4)] = cljs.core.rest((state_28186[(4)])));

return statearr_28207;
})();
var state_28186__$1 = state_28186;
var statearr_28208_28236 = state_28186__$1;
(statearr_28208_28236[(2)] = inst_28181);

(statearr_28208_28236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (5))){
var _ = (function (){var statearr_28209 = state_28186;
(statearr_28209[(4)] = cljs.core.rest((state_28186[(4)])));

return statearr_28209;
})();
var state_28186__$1 = state_28186;
var ex28204 = (state_28186__$1[(2)]);
var statearr_28210_28237 = state_28186__$1;
(statearr_28210_28237[(5)] = ex28204);


if((ex28204 instanceof Error)){
var statearr_28211_28238 = state_28186__$1;
(statearr_28211_28238[(1)] = (4));

(statearr_28211_28238[(5)] = null);

} else {
throw ex28204;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (14))){
var state_28186__$1 = state_28186;
var statearr_28212_28239 = state_28186__$1;
(statearr_28212_28239[(2)] = null);

(statearr_28212_28239[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (16))){
var inst_28138 = (state_28186[(7)]);
var inst_28170 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28171 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28172 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28170),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28171),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28138),". Forcing a db reload."].join('');
var inst_28173 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28172], 0));
var inst_28174 = fluree.db.session.reload_db_BANG_(session);
var state_28186__$1 = (function (){var statearr_28213 = state_28186;
(statearr_28213[(10)] = inst_28173);

return statearr_28213;
})();
var statearr_28214_28240 = state_28186__$1;
(statearr_28214_28240[(2)] = inst_28174);

(statearr_28214_28240[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (10))){
var inst_28134 = (state_28186[(9)]);
var inst_28138 = (state_28186[(7)]);
var inst_28137 = (state_28186[(8)]);
var inst_28149 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28150 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28151 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28149),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28150),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28152 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28151], 0));
var inst_28153 = (function (){var current_db_ch = inst_28134;
var current_db = inst_28137;
var current_block = inst_28138;
return (function (p1__28124_SHARP_){
if((p1__28124_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28124_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__28124_SHARP_);
}
});
})();
var inst_28154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_28153,flakes);
var inst_28155 = fluree.db.dbproto._with(inst_28137,block,inst_28154);
var inst_28156 = fluree.db.session.cas_db_BANG_(session,inst_28134,inst_28155);
var state_28186__$1 = (function (){var statearr_28215 = state_28186;
(statearr_28215[(11)] = inst_28152);

return statearr_28215;
})();
if(inst_28156){
var statearr_28216_28241 = state_28186__$1;
(statearr_28216_28241[(1)] = (13));

} else {
var statearr_28217_28242 = state_28186__$1;
(statearr_28217_28242[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (18))){
var inst_28177 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
var statearr_28218_28243 = state_28186__$1;
(statearr_28218_28243[(2)] = inst_28177);

(statearr_28218_28243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (8))){
var inst_28138 = (state_28186[(7)]);
var inst_28146 = ((1) + inst_28138);
var inst_28147 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_28146);
var state_28186__$1 = state_28186;
if(inst_28147){
var statearr_28219_28244 = state_28186__$1;
(statearr_28219_28244[(1)] = (10));

} else {
var statearr_28220_28245 = state_28186__$1;
(statearr_28220_28245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28221 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28221[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28221[(1)] = (1));

return statearr_28221;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28186){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28186);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28222){var ex__2882__auto__ = e28222;
var statearr_28223_28246 = state_28186;
(statearr_28223_28246[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28186[(4)]))){
var statearr_28224_28247 = state_28186;
(statearr_28224_28247[(1)] = cljs.core.first((state_28186[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28248 = state_28186;
state_28186 = G__28248;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28186){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28225 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28225[(6)] = c__2901__auto__);

return statearr_28225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28255){
var state_val_28256 = (state_28255[(1)]);
if((state_val_28256 === (1))){
var inst_28249 = fluree.db.session.clear_db_BANG_(session);
var inst_28250 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28251 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28252 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28250),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28251)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28253 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28252], 0));
var state_28255__$1 = (function (){var statearr_28257 = state_28255;
(statearr_28257[(7)] = inst_28253);

(statearr_28257[(8)] = inst_28249);

return statearr_28257;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28255__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28258 = [null,null,null,null,null,null,null,null,null];
(statearr_28258[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28258[(1)] = (1));

return statearr_28258;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28255){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28255);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28259){var ex__2882__auto__ = e28259;
var statearr_28260_28263 = state_28255;
(statearr_28260_28263[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28255[(4)]))){
var statearr_28261_28264 = state_28255;
(statearr_28261_28264[(1)] = cljs.core.first((state_28255[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28265 = state_28255;
state_28255 = G__28265;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28255){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28262 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28262[(6)] = c__2901__auto__);

return statearr_28262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28267 = arguments.length;
switch (G__28267) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__28268 = session;
var map__28268__$1 = (((((!((map__28268 == null))))?(((((map__28268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28268):map__28268);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28268__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28270_28273 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28270_28273.cljs$core$IFn$_invoke$arity$3 ? fexpr__28270_28273.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28270_28273.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28271_28274 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28271_28274.cljs$core$IFn$_invoke$arity$0 ? fexpr__28271_28274.cljs$core$IFn$_invoke$arity$0() : fexpr__28271_28274.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28327){
var state_val_28328 = (state_28327[(1)]);
if((state_val_28328 === (7))){
var inst_28323 = (state_28327[(2)]);
var state_28327__$1 = state_28327;
var statearr_28329_28360 = state_28327__$1;
(statearr_28329_28360[(2)] = inst_28323);

(statearr_28329_28360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (1))){
var state_28327__$1 = state_28327;
var statearr_28330_28361 = state_28327__$1;
(statearr_28330_28361[(2)] = null);

(statearr_28330_28361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (4))){
var inst_28278 = (state_28327[(7)]);
var inst_28277 = (state_28327[(2)]);
var inst_28278__$1 = fluree.db.util.async.throw_err(inst_28277);
var inst_28279 = fluree.db.session.from_cache(network,ledger_id);
var inst_28280 = (inst_28278__$1 == null);
var state_28327__$1 = (function (){var statearr_28331 = state_28327;
(statearr_28331[(8)] = inst_28279);

(statearr_28331[(7)] = inst_28278__$1);

return statearr_28331;
})();
if(cljs.core.truth_(inst_28280)){
var statearr_28332_28362 = state_28327__$1;
(statearr_28332_28362[(1)] = (5));

} else {
var statearr_28333_28363 = state_28327__$1;
(statearr_28333_28363[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (15))){
var inst_28315 = (state_28327[(2)]);
var state_28327__$1 = (function (){var statearr_28334 = state_28327;
(statearr_28334[(9)] = inst_28315);

return statearr_28334;
})();
var statearr_28335_28364 = state_28327__$1;
(statearr_28335_28364[(2)] = null);

(statearr_28335_28364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (13))){
var inst_28319 = (state_28327[(2)]);
var state_28327__$1 = state_28327;
var statearr_28337_28365 = state_28327__$1;
(statearr_28337_28365[(2)] = inst_28319);

(statearr_28337_28365[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (6))){
var inst_28279 = (state_28327[(8)]);
var inst_28285 = (inst_28279 == null);
var state_28327__$1 = state_28327;
if(cljs.core.truth_(inst_28285)){
var statearr_28338_28366 = state_28327__$1;
(statearr_28338_28366[(1)] = (8));

} else {
var statearr_28339_28367 = state_28327__$1;
(statearr_28339_28367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (17))){
var _ = (function (){var statearr_28340 = state_28327;
(statearr_28340[(4)] = cljs.core.rest((state_28327[(4)])));

return statearr_28340;
})();
var state_28327__$1 = state_28327;
var ex28336 = (state_28327__$1[(2)]);
var statearr_28341_28368 = state_28327__$1;
(statearr_28341_28368[(5)] = ex28336);


var statearr_28342_28369 = state_28327__$1;
(statearr_28342_28369[(1)] = (16));

(statearr_28342_28369[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (3))){
var inst_28325 = (state_28327[(2)]);
var state_28327__$1 = state_28327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28327__$1,inst_28325);
} else {
if((state_val_28328 === (12))){
var state_28327__$1 = state_28327;
var statearr_28343_28370 = state_28327__$1;
(statearr_28343_28370[(2)] = null);

(statearr_28343_28370[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (2))){
var state_28327__$1 = state_28327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28327__$1,(4),update_chan);
} else {
if((state_val_28328 === (11))){
var state_28327__$1 = state_28327;
var statearr_28344_28371 = state_28327__$1;
(statearr_28344_28371[(2)] = null);

(statearr_28344_28371[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (9))){
var state_28327__$1 = state_28327;
var statearr_28345_28372 = state_28327__$1;
(statearr_28345_28372[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (5))){
var inst_28282 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28283 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28282], 0));
var state_28327__$1 = state_28327;
var statearr_28347_28373 = state_28327__$1;
(statearr_28347_28373[(2)] = inst_28283);

(statearr_28347_28373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (14))){
var inst_28279 = (state_28327[(8)]);
var inst_28278 = (state_28327[(7)]);
var _ = (function (){var statearr_28348 = state_28327;
(statearr_28348[(4)] = cljs.core.cons((17),(state_28327[(4)])));

return statearr_28348;
})();
var inst_28303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28278,(0),null);
var inst_28304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28278,(1),null);
var inst_28305 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28306 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28278], 0));
var inst_28307 = fluree.db.util.core.trunc(inst_28306,(200));
var inst_28308 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28305,inst_28307], 0));
var inst_28309 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28279,inst_28303,inst_28304) : fluree.db.session.process_ledger_update.call(null,inst_28279,inst_28303,inst_28304));
var state_28327__$1 = (function (){var statearr_28349 = state_28327;
(statearr_28349[(10)] = inst_28308);

return statearr_28349;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28327__$1,(18),inst_28309);
} else {
if((state_val_28328 === (16))){
var inst_28278 = (state_28327[(7)]);
var inst_28293 = (state_28327[(2)]);
var inst_28294 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28293,"Exception processing ledger updates for message: ",inst_28278], 0));
var state_28327__$1 = state_28327;
var statearr_28350_28374 = state_28327__$1;
(statearr_28350_28374[(2)] = inst_28294);

(statearr_28350_28374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (10))){
var inst_28321 = (state_28327[(2)]);
var state_28327__$1 = state_28327;
var statearr_28351_28375 = state_28327__$1;
(statearr_28351_28375[(2)] = inst_28321);

(statearr_28351_28375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (18))){
var inst_28311 = (state_28327[(2)]);
var inst_28312 = fluree.db.util.async.throw_err(inst_28311);
var _ = (function (){var statearr_28352 = state_28327;
(statearr_28352[(4)] = cljs.core.rest((state_28327[(4)])));

return statearr_28352;
})();
var state_28327__$1 = state_28327;
var statearr_28353_28376 = state_28327__$1;
(statearr_28353_28376[(2)] = inst_28312);

(statearr_28353_28376[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28328 === (8))){
var inst_28278 = (state_28327[(7)]);
var inst_28287 = cljs.core.first(inst_28278);
var inst_28288 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28287], 0));
var inst_28289 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28288].join('');
var inst_28290 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28289], 0));
var state_28327__$1 = state_28327;
var statearr_28354_28377 = state_28327__$1;
(statearr_28354_28377[(2)] = inst_28290);

(statearr_28354_28377[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0 = (function (){
var statearr_28355 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28355[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__);

(statearr_28355[(1)] = (1));

return statearr_28355;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1 = (function (state_28327){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28327);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28356){var ex__2882__auto__ = e28356;
var statearr_28357_28378 = state_28327;
(statearr_28357_28378[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28327[(4)]))){
var statearr_28358_28379 = state_28327;
(statearr_28358_28379[(1)] = cljs.core.first((state_28327[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28380 = state_28327;
state_28327 = G__28380;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__ = function(state_28327){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1.call(this,state_28327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28359 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28359[(6)] = c__2901__auto__);

return statearr_28359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28381){
var map__28382 = p__28381;
var map__28382__$1 = (((((!((map__28382 == null))))?(((((map__28382.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28382.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28382):map__28382);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28382__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28387 = block_result;
var map__28387__$1 = (((((!((map__28387 == null))))?(((((map__28387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28387):map__28387);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28387__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28387__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28387__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28387__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28387__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28388 = tx_result;
var map__28388__$1 = (((((!((map__28388 == null))))?(((((map__28388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28388.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28388):map__28388);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28388__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28388__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28384_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28384_SHARP_.t);
}):(function (p1__28385_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28385_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28386_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28386_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28386_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28391 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28391,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28391,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28391,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28391,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28395 = arguments.length;
switch (G__28395) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28396){
var map__28397 = p__28396;
var map__28397__$1 = (((((!((map__28397 == null))))?(((((map__28397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28397.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28397):map__28397);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28397__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28397__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28397__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28397__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28399 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28399,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28399,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28399,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28403_28523 = network;
var G__28404_28524 = ledger_id;
var G__28405_28525 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28406_28526 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28407 = cljs.core.seq(tids);
var chunk__28408 = null;
var count__28409 = (0);
var i__28410 = (0);
while(true){
if((i__28410 < count__28409)){
var tid = chunk__28408.cljs$core$IIndexed$_nth$arity$2(null,i__28410);
var temp__5735__auto___28528__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___28528__$1)){
var keyed_callbacks_28529 = temp__5735__auto___28528__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28530 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28451_28531 = cljs.core.seq(keyed_callbacks_28529);
var chunk__28452_28532 = null;
var count__28453_28533 = (0);
var i__28454_28534 = (0);
while(true){
if((i__28454_28534 < count__28453_28533)){
var vec__28463_28535 = chunk__28452_28532.cljs$core$IIndexed$_nth$arity$2(null,i__28454_28534);
var k_28536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28463_28535,(0),null);
var f_28537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28463_28535,(1),null);
try{(f_28537.cljs$core$IFn$_invoke$arity$1 ? f_28537.cljs$core$IFn$_invoke$arity$1(tx_response_28530) : f_28537.call(null,tx_response_28530));
}catch (e28466){var e_28538 = e28466;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28538,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28539 = seq__28451_28531;
var G__28540 = chunk__28452_28532;
var G__28541 = count__28453_28533;
var G__28542 = (i__28454_28534 + (1));
seq__28451_28531 = G__28539;
chunk__28452_28532 = G__28540;
count__28453_28533 = G__28541;
i__28454_28534 = G__28542;
continue;
} else {
var temp__5735__auto___28543__$2 = cljs.core.seq(seq__28451_28531);
if(temp__5735__auto___28543__$2){
var seq__28451_28544__$1 = temp__5735__auto___28543__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28451_28544__$1)){
var c__4556__auto___28545 = cljs.core.chunk_first(seq__28451_28544__$1);
var G__28546 = cljs.core.chunk_rest(seq__28451_28544__$1);
var G__28547 = c__4556__auto___28545;
var G__28548 = cljs.core.count(c__4556__auto___28545);
var G__28549 = (0);
seq__28451_28531 = G__28546;
chunk__28452_28532 = G__28547;
count__28453_28533 = G__28548;
i__28454_28534 = G__28549;
continue;
} else {
var vec__28467_28550 = cljs.core.first(seq__28451_28544__$1);
var k_28551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28467_28550,(0),null);
var f_28552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28467_28550,(1),null);
try{(f_28552.cljs$core$IFn$_invoke$arity$1 ? f_28552.cljs$core$IFn$_invoke$arity$1(tx_response_28530) : f_28552.call(null,tx_response_28530));
}catch (e28470){var e_28553 = e28470;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28553,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28554 = cljs.core.next(seq__28451_28544__$1);
var G__28555 = null;
var G__28556 = (0);
var G__28557 = (0);
seq__28451_28531 = G__28554;
chunk__28452_28532 = G__28555;
count__28453_28533 = G__28556;
i__28454_28534 = G__28557;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28558 = seq__28407;
var G__28559 = chunk__28408;
var G__28560 = count__28409;
var G__28561 = (i__28410 + (1));
seq__28407 = G__28558;
chunk__28408 = G__28559;
count__28409 = G__28560;
i__28410 = G__28561;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__28407);
if(temp__5735__auto____$1){
var seq__28407__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28407__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28407__$1);
var G__28562 = cljs.core.chunk_rest(seq__28407__$1);
var G__28563 = c__4556__auto__;
var G__28564 = cljs.core.count(c__4556__auto__);
var G__28565 = (0);
seq__28407 = G__28562;
chunk__28408 = G__28563;
count__28409 = G__28564;
i__28410 = G__28565;
continue;
} else {
var tid = cljs.core.first(seq__28407__$1);
var temp__5735__auto___28566__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___28566__$2)){
var keyed_callbacks_28567 = temp__5735__auto___28566__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28568 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28471_28569 = cljs.core.seq(keyed_callbacks_28567);
var chunk__28472_28570 = null;
var count__28473_28571 = (0);
var i__28474_28572 = (0);
while(true){
if((i__28474_28572 < count__28473_28571)){
var vec__28483_28573 = chunk__28472_28570.cljs$core$IIndexed$_nth$arity$2(null,i__28474_28572);
var k_28574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28483_28573,(0),null);
var f_28575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28483_28573,(1),null);
try{(f_28575.cljs$core$IFn$_invoke$arity$1 ? f_28575.cljs$core$IFn$_invoke$arity$1(tx_response_28568) : f_28575.call(null,tx_response_28568));
}catch (e28486){var e_28576 = e28486;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28576,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28577 = seq__28471_28569;
var G__28578 = chunk__28472_28570;
var G__28579 = count__28473_28571;
var G__28580 = (i__28474_28572 + (1));
seq__28471_28569 = G__28577;
chunk__28472_28570 = G__28578;
count__28473_28571 = G__28579;
i__28474_28572 = G__28580;
continue;
} else {
var temp__5735__auto___28581__$3 = cljs.core.seq(seq__28471_28569);
if(temp__5735__auto___28581__$3){
var seq__28471_28582__$1 = temp__5735__auto___28581__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28471_28582__$1)){
var c__4556__auto___28583 = cljs.core.chunk_first(seq__28471_28582__$1);
var G__28584 = cljs.core.chunk_rest(seq__28471_28582__$1);
var G__28585 = c__4556__auto___28583;
var G__28586 = cljs.core.count(c__4556__auto___28583);
var G__28587 = (0);
seq__28471_28569 = G__28584;
chunk__28472_28570 = G__28585;
count__28473_28571 = G__28586;
i__28474_28572 = G__28587;
continue;
} else {
var vec__28487_28588 = cljs.core.first(seq__28471_28582__$1);
var k_28589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28487_28588,(0),null);
var f_28590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28487_28588,(1),null);
try{(f_28590.cljs$core$IFn$_invoke$arity$1 ? f_28590.cljs$core$IFn$_invoke$arity$1(tx_response_28568) : f_28590.call(null,tx_response_28568));
}catch (e28490){var e_28591 = e28490;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28591,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28592 = cljs.core.next(seq__28471_28582__$1);
var G__28593 = null;
var G__28594 = (0);
var G__28595 = (0);
seq__28471_28569 = G__28592;
chunk__28472_28570 = G__28593;
count__28473_28571 = G__28594;
i__28474_28572 = G__28595;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28596 = cljs.core.next(seq__28407__$1);
var G__28597 = null;
var G__28598 = (0);
var G__28599 = (0);
seq__28407 = G__28596;
chunk__28408 = G__28597;
count__28409 = G__28598;
i__28410 = G__28599;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28402_28527 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28402_28527.cljs$core$IFn$_invoke$arity$4 ? fexpr__28402_28527.cljs$core$IFn$_invoke$arity$4(G__28403_28523,G__28404_28524,G__28405_28525,G__28406_28526) : fexpr__28402_28527.call(null,G__28403_28523,G__28404_28524,G__28405_28525,G__28406_28526));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28600 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2901__auto___28601 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28507){
var state_val_28508 = (state_28507[(1)]);
if((state_val_28508 === (1))){
var state_28507__$1 = state_28507;
var statearr_28509_28602 = state_28507__$1;
(statearr_28509_28602[(2)] = null);

(statearr_28509_28602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28508 === (2))){
var inst_28492 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28507__$1 = state_28507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28507__$1,(4),inst_28492);
} else {
if((state_val_28508 === (3))){
var inst_28505 = (state_28507[(2)]);
var state_28507__$1 = state_28507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28507__$1,inst_28505);
} else {
if((state_val_28508 === (4))){
var inst_28494 = (state_28507[(7)]);
var inst_28494__$1 = (state_28507[(2)]);
var inst_28495 = (inst_28494__$1 == null);
var state_28507__$1 = (function (){var statearr_28510 = state_28507;
(statearr_28510[(7)] = inst_28494__$1);

return statearr_28510;
})();
if(cljs.core.truth_(inst_28495)){
var statearr_28511_28603 = state_28507__$1;
(statearr_28511_28603[(1)] = (5));

} else {
var statearr_28512_28604 = state_28507__$1;
(statearr_28512_28604[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28508 === (5))){
var inst_28497 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28498 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28497], 0));
var state_28507__$1 = state_28507;
var statearr_28513_28605 = state_28507__$1;
(statearr_28513_28605[(2)] = inst_28498);

(statearr_28513_28605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28508 === (6))){
var inst_28494 = (state_28507[(7)]);
var inst_28500 = (transact_handler_28600.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28600.cljs$core$IFn$_invoke$arity$2(conn,inst_28494) : transact_handler_28600.call(null,conn,inst_28494));
var state_28507__$1 = (function (){var statearr_28514 = state_28507;
(statearr_28514[(8)] = inst_28500);

return statearr_28514;
})();
var statearr_28515_28606 = state_28507__$1;
(statearr_28515_28606[(2)] = null);

(statearr_28515_28606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28508 === (7))){
var inst_28503 = (state_28507[(2)]);
var state_28507__$1 = state_28507;
var statearr_28516_28607 = state_28507__$1;
(statearr_28516_28607[(2)] = inst_28503);

(statearr_28516_28607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28517 = [null,null,null,null,null,null,null,null,null];
(statearr_28517[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28517[(1)] = (1));

return statearr_28517;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28507){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28507);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28518){var ex__2882__auto__ = e28518;
var statearr_28519_28608 = state_28507;
(statearr_28519_28608[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28507[(4)]))){
var statearr_28520_28609 = state_28507;
(statearr_28520_28609[(1)] = cljs.core.first((state_28507[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28610 = state_28507;
state_28507 = G__28610;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28507){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28521 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28521[(6)] = c__2901__auto___28601);

return statearr_28521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28611_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28611_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28611_SHARP_) + (1))], 0));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28612_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28612_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28615 = arguments.length;
switch (G__28615) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28616 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28613_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28613_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28616);
} else {
return G__28616;
}
})();
var seq__28617 = cljs.core.seq(sessions);
var chunk__28618 = null;
var count__28619 = (0);
var i__28620 = (0);
while(true){
if((i__28620 < count__28619)){
var session = chunk__28618.cljs$core$IIndexed$_nth$arity$2(null,i__28620);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28622 = seq__28617;
var G__28623 = chunk__28618;
var G__28624 = count__28619;
var G__28625 = (i__28620 + (1));
seq__28617 = G__28622;
chunk__28618 = G__28623;
count__28619 = G__28624;
i__28620 = G__28625;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28617);
if(temp__5735__auto__){
var seq__28617__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28617__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28617__$1);
var G__28626 = cljs.core.chunk_rest(seq__28617__$1);
var G__28627 = c__4556__auto__;
var G__28628 = cljs.core.count(c__4556__auto__);
var G__28629 = (0);
seq__28617 = G__28626;
chunk__28618 = G__28627;
count__28619 = G__28628;
i__28620 = G__28629;
continue;
} else {
var session = cljs.core.first(seq__28617__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28630 = cljs.core.next(seq__28617__$1);
var G__28631 = null;
var G__28632 = (0);
var G__28633 = (0);
seq__28617 = G__28630;
chunk__28618 = G__28631;
count__28619 = G__28632;
i__28620 = G__28633;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
