// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__21801 = arguments.length;
switch (G__21801) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__21804 = arguments.length;
switch (G__21804) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___21857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21835){
var state_val_21836 = (state_21835[(1)]);
if((state_val_21836 === (1))){
var state_21835__$1 = state_21835;
var statearr_21837_21858 = state_21835__$1;
(statearr_21837_21858[(2)] = null);

(statearr_21837_21858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (2))){
var _ = (function (){var statearr_21838 = state_21835;
(statearr_21838[(4)] = cljs.core.cons((5),(state_21835[(4)])));

return statearr_21838;
})();
var inst_21812 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_21835__$1 = state_21835;
if(cljs.core.truth_(inst_21812)){
var statearr_21839_21859 = state_21835__$1;
(statearr_21839_21859[(1)] = (6));

} else {
var statearr_21840_21860 = state_21835__$1;
(statearr_21840_21860[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (3))){
var inst_21833 = (state_21835[(2)]);
var state_21835__$1 = state_21835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21835__$1,inst_21833);
} else {
if((state_val_21836 === (4))){
var inst_21805 = (state_21835[(2)]);
var inst_21806 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_21805);
var state_21835__$1 = state_21835;
var statearr_21842_21861 = state_21835__$1;
(statearr_21842_21861[(2)] = inst_21806);

(statearr_21842_21861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (5))){
var _ = (function (){var statearr_21843 = state_21835;
(statearr_21843[(4)] = cljs.core.rest((state_21835[(4)])));

return statearr_21843;
})();
var state_21835__$1 = state_21835;
var ex21841 = (state_21835__$1[(2)]);
var statearr_21844_21862 = state_21835__$1;
(statearr_21844_21862[(5)] = ex21841);


var statearr_21845_21863 = state_21835__$1;
(statearr_21845_21863[(1)] = (4));

(statearr_21845_21863[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (6))){
var inst_21814 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21815 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_21816 = cljs.core.PersistentHashMap.fromArrays(inst_21814,inst_21815);
var inst_21817 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_21816);
var inst_21818 = (function(){throw inst_21817})();
var state_21835__$1 = state_21835;
var statearr_21846_21864 = state_21835__$1;
(statearr_21846_21864[(2)] = inst_21818);

(statearr_21846_21864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (7))){
var inst_21820 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21822 = [operation,data,pc,opts];
var inst_21823 = (new cljs.core.PersistentVector(null,4,(5),inst_21821,inst_21822,null));
var inst_21824 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_21820,inst_21823);
var inst_21825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21826 = [operation,data,pc,opts];
var inst_21827 = (new cljs.core.PersistentVector(null,4,(5),inst_21825,inst_21826,null));
var inst_21828 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_21827], 0));
var state_21835__$1 = (function (){var statearr_21847 = state_21835;
(statearr_21847[(7)] = inst_21824);

return statearr_21847;
})();
var statearr_21848_21865 = state_21835__$1;
(statearr_21848_21865[(2)] = inst_21828);

(statearr_21848_21865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21836 === (8))){
var inst_21830 = (state_21835[(2)]);
var _ = (function (){var statearr_21849 = state_21835;
(statearr_21849[(4)] = cljs.core.rest((state_21835[(4)])));

return statearr_21849;
})();
var state_21835__$1 = state_21835;
var statearr_21850_21866 = state_21835__$1;
(statearr_21850_21866[(2)] = inst_21830);

(statearr_21850_21866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2879__auto__ = null;
var fluree$db$operations$state_machine__2879__auto____0 = (function (){
var statearr_21851 = [null,null,null,null,null,null,null,null];
(statearr_21851[(0)] = fluree$db$operations$state_machine__2879__auto__);

(statearr_21851[(1)] = (1));

return statearr_21851;
});
var fluree$db$operations$state_machine__2879__auto____1 = (function (state_21835){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21835);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21852){var ex__2882__auto__ = e21852;
var statearr_21853_21867 = state_21835;
(statearr_21853_21867[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21835[(4)]))){
var statearr_21854_21868 = state_21835;
(statearr_21854_21868[(1)] = cljs.core.first((state_21835[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21869 = state_21835;
state_21835 = G__21869;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2879__auto__ = function(state_21835){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2879__auto____1.call(this,state_21835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2879__auto____0;
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2879__auto____1;
return fluree$db$operations$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21855 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21855[(6)] = c__2901__auto___21857);

return statearr_21855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__21871 = arguments.length;
switch (G__21871) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__21872){
var map__21873 = p__21872;
var map__21873__$1 = (((((!((map__21873 == null))))?(((((map__21873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21873.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21873):map__21873);
var opts = map__21873__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21873__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__21875 = session;
var map__21875__$1 = (((((!((map__21875 == null))))?(((((map__21875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21875):map__21875);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21875__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21875__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21875__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___21937 = arguments.length;
var i__4737__auto___21938 = (0);
while(true){
if((i__4737__auto___21938 < len__4736__auto___21937)){
args__4742__auto__.push((arguments[i__4737__auto___21938]));

var G__21939 = (i__4737__auto___21938 + (1));
i__4737__auto___21938 = G__21939;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__21880){
var vec__21881 = p__21880;
var map__21884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21881,(0),null);
var map__21884__$1 = (((((!((map__21884 == null))))?(((((map__21884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21884.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21884):map__21884);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21884__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21884__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__21881;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21917){
var state_val_21918 = (state_21917[(1)]);
if((state_val_21918 === (7))){
var inst_21900 = (state_21917[(2)]);
var state_21917__$1 = state_21917;
var statearr_21919_21940 = state_21917__$1;
(statearr_21919_21940[(2)] = inst_21900);

(statearr_21919_21940[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (1))){
var inst_21887 = (state_21917[(7)]);
var inst_21887__$1 = session;
var inst_21889 = (inst_21887__$1 == null);
var inst_21890 = cljs.core.not(inst_21889);
var state_21917__$1 = (function (){var statearr_21920 = state_21917;
(statearr_21920[(7)] = inst_21887__$1);

return statearr_21920;
})();
if(inst_21890){
var statearr_21921_21941 = state_21917__$1;
(statearr_21921_21941[(1)] = (2));

} else {
var statearr_21922_21942 = state_21917__$1;
(statearr_21922_21942[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (4))){
var inst_21903 = (state_21917[(2)]);
var state_21917__$1 = state_21917;
if(cljs.core.truth_(inst_21903)){
var statearr_21923_21943 = state_21917__$1;
(statearr_21923_21943[(1)] = (8));

} else {
var statearr_21924_21944 = state_21917__$1;
(statearr_21924_21944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (6))){
var state_21917__$1 = state_21917;
var statearr_21925_21945 = state_21917__$1;
(statearr_21925_21945[(2)] = false);

(statearr_21925_21945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (3))){
var state_21917__$1 = state_21917;
var statearr_21926_21946 = state_21917__$1;
(statearr_21926_21946[(2)] = false);

(statearr_21926_21946[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (2))){
var inst_21887 = (state_21917[(7)]);
var inst_21892 = inst_21887.cljs$lang$protocol_mask$partition0$;
var inst_21893 = (inst_21892 & (64));
var inst_21894 = inst_21887.cljs$core$ISeq$;
var inst_21895 = (cljs.core.PROTOCOL_SENTINEL === inst_21894);
var inst_21896 = ((inst_21893) || (inst_21895));
var state_21917__$1 = state_21917;
if(cljs.core.truth_(inst_21896)){
var statearr_21927_21947 = state_21917__$1;
(statearr_21927_21947[(1)] = (5));

} else {
var statearr_21928_21948 = state_21917__$1;
(statearr_21928_21948[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (9))){
var inst_21887 = (state_21917[(7)]);
var state_21917__$1 = state_21917;
var statearr_21929_21949 = state_21917__$1;
(statearr_21929_21949[(2)] = inst_21887);

(statearr_21929_21949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (5))){
var state_21917__$1 = state_21917;
var statearr_21930_21950 = state_21917__$1;
(statearr_21930_21950[(2)] = true);

(statearr_21930_21950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21918 === (10))){
var inst_21908 = (state_21917[(2)]);
var inst_21909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21908,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_21910 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21908,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_21911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21908,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_21912 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_21913 = [inst_21909,inst_21910,toBlock,toTime];
var inst_21914 = cljs.core.PersistentHashMap.fromArrays(inst_21912,inst_21913);
var inst_21915 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_21911,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_21914);
var state_21917__$1 = state_21917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21917__$1,inst_21915);
} else {
if((state_val_21918 === (8))){
var inst_21887 = (state_21917[(7)]);
var inst_21905 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21887);
var state_21917__$1 = state_21917;
var statearr_21931_21951 = state_21917__$1;
(statearr_21931_21951[(2)] = inst_21905);

(statearr_21931_21951[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2879__auto__ = null;
var fluree$db$operations$state_machine__2879__auto____0 = (function (){
var statearr_21932 = [null,null,null,null,null,null,null,null];
(statearr_21932[(0)] = fluree$db$operations$state_machine__2879__auto__);

(statearr_21932[(1)] = (1));

return statearr_21932;
});
var fluree$db$operations$state_machine__2879__auto____1 = (function (state_21917){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_21917);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21933){var ex__2882__auto__ = e21933;
var statearr_21934_21952 = state_21917;
(statearr_21934_21952[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_21917[(4)]))){
var statearr_21935_21953 = state_21917;
(statearr_21935_21953[(1)] = cljs.core.first((state_21917[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21954 = state_21917;
state_21917 = G__21954;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2879__auto__ = function(state_21917){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2879__auto____1.call(this,state_21917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2879__auto____0;
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2879__auto____1;
return fluree$db$operations$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21936 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_21936[(6)] = c__2901__auto__);

return statearr_21936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq21878){
var G__21879 = cljs.core.first(seq21878);
var seq21878__$1 = cljs.core.next(seq21878);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21879,seq21878__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__21955 = session;
var map__21955__$1 = (((((!((map__21955 == null))))?(((((map__21955.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21955.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21955):map__21955);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21955__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21955__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21955__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__21958 = arguments.length;
switch (G__21958) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__21959 = opts;
var map__21959__$1 = (((((!((map__21959 == null))))?(((((map__21959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21959.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21959):map__21959);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21959__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21959__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
