// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__16351 = cljs.core._EQ_;
var expr__16352 = e.getLastErrorCode();
if(cljs.core.truth_((pred__16351.cljs$core$IFn$_invoke$arity$2 ? pred__16351.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__16352) : pred__16351.call(null,goog.net.ErrorCode.NO_ERROR,expr__16352)))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_((pred__16351.cljs$core$IFn$_invoke$arity$2 ? pred__16351.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__16352) : pred__16351.call(null,goog.net.ErrorCode.EXCEPTION,expr__16352)))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_((pred__16351.cljs$core$IFn$_invoke$arity$2 ? pred__16351.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__16352) : pred__16351.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__16352)))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_((pred__16351.cljs$core$IFn$_invoke$arity$2 ? pred__16351.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__16352) : pred__16351.call(null,goog.net.ErrorCode.ABORT,expr__16352)))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_((pred__16351.cljs$core$IFn$_invoke$arity$2 ? pred__16351.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__16352) : pred__16351.call(null,goog.net.ErrorCode.TIMEOUT,expr__16352)))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__16354 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16354,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__16354;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__16355 = opts;
var map__16355__$1 = (((((!((map__16355 == null))))?(((((map__16355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16355.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16355):map__16355);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16355__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16355__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16355__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__16357 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__16357__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__16357,headers], 0)):G__16357);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16357__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16357__$1;
}
})();
try{var G__16359_16365 = url;
var G__16360_16366 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__16361_16367 = "POST";
var G__16362_16368 = fluree.db.util.json.stringify(message);
var G__16363_16369 = cljs.core.clj__GT_js(headers__$1);
var G__16364_16370 = request_timeout;
goog.net.XhrIo.send(G__16359_16365,G__16360_16366,G__16361_16367,G__16362_16368,G__16363_16369,G__16364_16370);
}catch (e16358){var e_16371 = e16358;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_16371);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__16372 = opts;
var map__16372__$1 = (((((!((map__16372 == null))))?(((((map__16372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16372):map__16372);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16372__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16372__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16372__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16372__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16372__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__16374 = cljs.core.PersistentArrayMap.EMPTY;
var G__16374__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__16374,headers], 0)):G__16374);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16374__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16374__$1;
}
})();
try{var G__16376_16383 = url;
var G__16377_16384 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__16382 = output_format;
var G__16382__$1 = (((G__16382 instanceof cljs.core.Keyword))?G__16382.fqn:null);
switch (G__16382__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__16378_16385 = "GET";
var G__16379_16386 = body;
var G__16380_16387 = cljs.core.clj__GT_js(headers__$1);
var G__16381_16388 = request_timeout;
goog.net.XhrIo.send(G__16376_16383,G__16377_16384,G__16378_16385,G__16379_16386,G__16380_16387,G__16381_16388);
}catch (e16375){var e_16390 = e16375;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_16390);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__16391 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16391,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__16391;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16424){
var state_val_16425 = (state_16424[(1)]);
if((state_val_16425 === (7))){
var inst_16420 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
var statearr_16426_16451 = state_16424__$1;
(statearr_16426_16451[(2)] = inst_16420);

(statearr_16426_16451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (1))){
var state_16424__$1 = state_16424;
var statearr_16427_16452 = state_16424__$1;
(statearr_16427_16452[(2)] = null);

(statearr_16427_16452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (4))){
var inst_16395 = (state_16424[(7)]);
var inst_16395__$1 = (state_16424[(2)]);
var inst_16396 = (inst_16395__$1 == null);
var state_16424__$1 = (function (){var statearr_16428 = state_16424;
(statearr_16428[(7)] = inst_16395__$1);

return statearr_16428;
})();
if(cljs.core.truth_(inst_16396)){
var statearr_16429_16453 = state_16424__$1;
(statearr_16429_16453[(1)] = (5));

} else {
var statearr_16430_16454 = state_16424__$1;
(statearr_16430_16454[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (6))){
var inst_16395 = (state_16424[(7)]);
var inst_16403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16395,(0),null);
var inst_16404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16395,(1),null);
var state_16424__$1 = (function (){var statearr_16431 = state_16424;
(statearr_16431[(8)] = inst_16403);

(statearr_16431[(9)] = inst_16404);

return statearr_16431;
})();
var statearr_16432_16455 = state_16424__$1;
(statearr_16432_16455[(2)] = null);

(statearr_16432_16455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (3))){
var inst_16422 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16424__$1,inst_16422);
} else {
if((state_val_16425 === (2))){
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16424__$1,(4),pub_chan);
} else {
if((state_val_16425 === (11))){
var _ = (function (){var statearr_16434 = state_16424;
(statearr_16434[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16434;
})();
var state_16424__$1 = state_16424;
var ex16433 = (state_16424__$1[(2)]);
var statearr_16435_16456 = state_16424__$1;
(statearr_16435_16456[(5)] = ex16433);


if((ex16433 instanceof Error)){
var statearr_16436_16457 = state_16424__$1;
(statearr_16436_16457[(1)] = (10));

(statearr_16436_16457[(5)] = null);

} else {
throw ex16433;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (9))){
var inst_16417 = (state_16424[(2)]);
var state_16424__$1 = (function (){var statearr_16437 = state_16424;
(statearr_16437[(10)] = inst_16417);

return statearr_16437;
})();
var statearr_16438_16458 = state_16424__$1;
(statearr_16438_16458[(2)] = null);

(statearr_16438_16458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (5))){
var inst_16398 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_16424__$1 = state_16424;
var statearr_16439_16459 = state_16424__$1;
(statearr_16439_16459[(2)] = inst_16398);

(statearr_16439_16459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (10))){
var inst_16404 = (state_16424[(9)]);
var inst_16405 = (state_16424[(2)]);
var inst_16406 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_16405,"Websocket send message error:",inst_16405], 0));
var inst_16407 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16404,false);
var state_16424__$1 = (function (){var statearr_16440 = state_16424;
(statearr_16440[(11)] = inst_16406);

return statearr_16440;
})();
var statearr_16441_16460 = state_16424__$1;
(statearr_16441_16460[(2)] = inst_16407);

(statearr_16441_16460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (8))){
var inst_16403 = (state_16424[(8)]);
var inst_16404 = (state_16424[(9)]);
var _ = (function (){var statearr_16442 = state_16424;
(statearr_16442[(4)] = cljs.core.cons((11),(state_16424[(4)])));

return statearr_16442;
})();
var inst_16413 = ws.send(inst_16403);
var inst_16414 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16404,true);
var ___$1 = (function (){var statearr_16443 = state_16424;
(statearr_16443[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16443;
})();
var state_16424__$1 = (function (){var statearr_16444 = state_16424;
(statearr_16444[(12)] = inst_16413);

return statearr_16444;
})();
var statearr_16445_16461 = state_16424__$1;
(statearr_16445_16461[(2)] = inst_16414);

(statearr_16445_16461[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0 = (function (){
var statearr_16446 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16446[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__);

(statearr_16446[(1)] = (1));

return statearr_16446;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1 = (function (state_16424){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16424);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16447){var ex__2882__auto__ = e16447;
var statearr_16448_16462 = state_16424;
(statearr_16448_16462[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16424[(4)]))){
var statearr_16449_16463 = state_16424;
(statearr_16449_16463[(1)] = cljs.core.first((state_16424[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16464 = state_16424;
state_16424 = G__16464;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__ = function(state_16424){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1.call(this,state_16424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16450 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16450[(6)] = c__2901__auto__);

return statearr_16450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2901__auto___16503 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16490){
var state_val_16491 = (state_16490[(1)]);
if((state_val_16491 === (1))){
var inst_16469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16470 = [open_QMARK_,timeout_chan];
var inst_16471 = (new cljs.core.PersistentVector(null,2,(5),inst_16469,inst_16470,null));
var state_16490__$1 = state_16490;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_16490__$1,(2),inst_16471,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_16491 === (2))){
var inst_16473 = (state_16490[(2)]);
var inst_16474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16473,(0),null);
var inst_16475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16473,(1),null);
var inst_16476 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16475,timeout_chan);
var state_16490__$1 = (function (){var statearr_16492 = state_16490;
(statearr_16492[(7)] = inst_16474);

return statearr_16492;
})();
if(inst_16476){
var statearr_16493_16504 = state_16490__$1;
(statearr_16493_16504[(1)] = (3));

} else {
var statearr_16494_16505 = state_16490__$1;
(statearr_16494_16505[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16491 === (3))){
var inst_16478 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_16479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16480 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_16481 = cljs.core.PersistentHashMap.fromArrays(inst_16479,inst_16480);
var inst_16482 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16478,inst_16481);
var inst_16483 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_16482);
var inst_16484 = fluree.db.util.xhttp.close_websocket(ws);
var state_16490__$1 = (function (){var statearr_16495 = state_16490;
(statearr_16495[(8)] = inst_16483);

return statearr_16495;
})();
var statearr_16496_16506 = state_16490__$1;
(statearr_16496_16506[(2)] = inst_16484);

(statearr_16496_16506[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16491 === (4))){
var inst_16486 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_16490__$1 = state_16490;
var statearr_16497_16507 = state_16490__$1;
(statearr_16497_16507[(2)] = inst_16486);

(statearr_16497_16507[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16491 === (5))){
var inst_16488 = (state_16490[(2)]);
var state_16490__$1 = state_16490;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16490__$1,inst_16488);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_16498 = [null,null,null,null,null,null,null,null,null];
(statearr_16498[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__);

(statearr_16498[(1)] = (1));

return statearr_16498;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1 = (function (state_16490){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16490);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16499){var ex__2882__auto__ = e16499;
var statearr_16500_16508 = state_16490;
(statearr_16500_16508[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16490[(4)]))){
var statearr_16501_16509 = state_16490;
(statearr_16501_16509[(1)] = cljs.core.first((state_16490[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16510 = state_16490;
state_16490 = G__16510;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__ = function(state_16490){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1.call(this,state_16490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16502 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16502[(6)] = c__2901__auto___16503);

return statearr_16502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
