// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18652){
var state_val_18653 = (state_18652[(1)]);
if((state_val_18653 === (1))){
var state_18652__$1 = state_18652;
var statearr_18654_18668 = state_18652__$1;
(statearr_18654_18668[(2)] = null);

(statearr_18654_18668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18653 === (2))){
var _ = (function (){var statearr_18655 = state_18652;
(statearr_18655[(4)] = cljs.core.cons((5),(state_18652[(4)])));

return statearr_18655;
})();
var inst_18643 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_18652__$1 = state_18652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18652__$1,(6),inst_18643);
} else {
if((state_val_18653 === (3))){
var inst_18650 = (state_18652[(2)]);
var state_18652__$1 = state_18652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18652__$1,inst_18650);
} else {
if((state_val_18653 === (4))){
var inst_18637 = (state_18652[(2)]);
var state_18652__$1 = state_18652;
var statearr_18657_18669 = state_18652__$1;
(statearr_18657_18669[(2)] = inst_18637);

(statearr_18657_18669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18653 === (5))){
var _ = (function (){var statearr_18658 = state_18652;
(statearr_18658[(4)] = cljs.core.rest((state_18652[(4)])));

return statearr_18658;
})();
var state_18652__$1 = state_18652;
var ex18656 = (state_18652__$1[(2)]);
var statearr_18659_18670 = state_18652__$1;
(statearr_18659_18670[(5)] = ex18656);


if((ex18656 instanceof Error)){
var statearr_18660_18671 = state_18652__$1;
(statearr_18660_18671[(1)] = (4));

(statearr_18660_18671[(5)] = null);

} else {
throw ex18656;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18653 === (6))){
var inst_18645 = (state_18652[(2)]);
var inst_18646 = fluree.db.util.async.throw_err(inst_18645);
var inst_18647 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_18646);
var _ = (function (){var statearr_18661 = state_18652;
(statearr_18661[(4)] = cljs.core.rest((state_18652[(4)])));

return statearr_18661;
})();
var state_18652__$1 = state_18652;
var statearr_18662_18672 = state_18652__$1;
(statearr_18662_18672[(2)] = inst_18647);

(statearr_18662_18672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0 = (function (){
var statearr_18663 = [null,null,null,null,null,null,null];
(statearr_18663[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__);

(statearr_18663[(1)] = (1));

return statearr_18663;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1 = (function (state_18652){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18652);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18664){var ex__2882__auto__ = e18664;
var statearr_18665_18673 = state_18652;
(statearr_18665_18673[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18652[(4)]))){
var statearr_18666_18674 = state_18652;
(statearr_18666_18674[(1)] = cljs.core.first((state_18652[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18675 = state_18652;
state_18652 = G__18675;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__ = function(state_18652){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1.call(this,state_18652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18667 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18667[(6)] = c__2901__auto__);

return statearr_18667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18707){
var state_val_18708 = (state_18707[(1)]);
if((state_val_18708 === (7))){
var inst_18691 = (state_18707[(7)]);
var inst_18693 = cljs.core.empty_QMARK_(inst_18691);
var inst_18694 = (!(inst_18693));
var state_18707__$1 = state_18707;
var statearr_18709_18733 = state_18707__$1;
(statearr_18709_18733[(2)] = inst_18694);

(statearr_18709_18733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (1))){
var state_18707__$1 = state_18707;
var statearr_18710_18734 = state_18707__$1;
(statearr_18710_18734[(2)] = null);

(statearr_18710_18734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (4))){
var inst_18677 = (state_18707[(2)]);
var state_18707__$1 = state_18707;
var statearr_18711_18735 = state_18707__$1;
(statearr_18711_18735[(2)] = inst_18677);

(statearr_18711_18735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (6))){
var inst_18683 = (state_18707[(8)]);
var inst_18691 = (state_18707[(7)]);
var inst_18689 = (state_18707[(2)]);
var inst_18690 = fluree.db.util.async.throw_err(inst_18689);
var inst_18691__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18683,inst_18690);
var state_18707__$1 = (function (){var statearr_18712 = state_18707;
(statearr_18712[(7)] = inst_18691__$1);

return statearr_18712;
})();
if(cljs.core.truth_(inst_18691__$1)){
var statearr_18713_18736 = state_18707__$1;
(statearr_18713_18736[(1)] = (7));

} else {
var statearr_18714_18737 = state_18707__$1;
(statearr_18714_18737[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (3))){
var inst_18705 = (state_18707[(2)]);
var state_18707__$1 = state_18707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18707__$1,inst_18705);
} else {
if((state_val_18708 === (12))){
var inst_18702 = (state_18707[(2)]);
var _ = (function (){var statearr_18715 = state_18707;
(statearr_18715[(4)] = cljs.core.rest((state_18707[(4)])));

return statearr_18715;
})();
var state_18707__$1 = state_18707;
var statearr_18716_18738 = state_18707__$1;
(statearr_18716_18738[(2)] = inst_18702);

(statearr_18716_18738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (2))){
var _ = (function (){var statearr_18717 = state_18707;
(statearr_18717[(4)] = cljs.core.cons((5),(state_18707[(4)])));

return statearr_18717;
})();
var inst_18683 = (function (){return (function (p1__18676_SHARP_){
return p1__18676_SHARP_.o;
});
})();
var inst_18684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18685 = [pred_id];
var inst_18686 = (new cljs.core.PersistentVector(null,1,(5),inst_18684,inst_18685,null));
var inst_18687 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_18686);
var state_18707__$1 = (function (){var statearr_18718 = state_18707;
(statearr_18718[(8)] = inst_18683);

return statearr_18718;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18707__$1,(6),inst_18687);
} else {
if((state_val_18708 === (11))){
var state_18707__$1 = state_18707;
var statearr_18720_18739 = state_18707__$1;
(statearr_18720_18739[(2)] = true);

(statearr_18720_18739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (9))){
var inst_18697 = (state_18707[(2)]);
var state_18707__$1 = state_18707;
if(cljs.core.truth_(inst_18697)){
var statearr_18721_18740 = state_18707__$1;
(statearr_18721_18740[(1)] = (10));

} else {
var statearr_18722_18741 = state_18707__$1;
(statearr_18722_18741[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (5))){
var _ = (function (){var statearr_18723 = state_18707;
(statearr_18723[(4)] = cljs.core.rest((state_18707[(4)])));

return statearr_18723;
})();
var state_18707__$1 = state_18707;
var ex18719 = (state_18707__$1[(2)]);
var statearr_18724_18742 = state_18707__$1;
(statearr_18724_18742[(5)] = ex18719);


if((ex18719 instanceof Error)){
var statearr_18725_18743 = state_18707__$1;
(statearr_18725_18743[(1)] = (4));

(statearr_18725_18743[(5)] = null);

} else {
throw ex18719;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (10))){
var inst_18691 = (state_18707[(7)]);
var inst_18699 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_18691);
var state_18707__$1 = state_18707;
var statearr_18726_18744 = state_18707__$1;
(statearr_18726_18744[(2)] = inst_18699);

(statearr_18726_18744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18708 === (8))){
var inst_18691 = (state_18707[(7)]);
var state_18707__$1 = state_18707;
var statearr_18727_18745 = state_18707__$1;
(statearr_18727_18745[(2)] = inst_18691);

(statearr_18727_18745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_18728 = [null,null,null,null,null,null,null,null,null];
(statearr_18728[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__);

(statearr_18728[(1)] = (1));

return statearr_18728;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1 = (function (state_18707){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18707);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18729){var ex__2882__auto__ = e18729;
var statearr_18730_18746 = state_18707;
(statearr_18730_18746[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18707[(4)]))){
var statearr_18731_18747 = state_18707;
(statearr_18731_18747[(1)] = cljs.core.first((state_18707[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18748 = state_18707;
state_18707 = G__18748;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__ = function(state_18707){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1.call(this,state_18707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18732 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18732[(6)] = c__2901__auto__);

return statearr_18732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18825){
var state_val_18826 = (state_18825[(1)]);
if((state_val_18826 === (7))){
var inst_18820 = (state_18825[(2)]);
var _ = (function (){var statearr_18827 = state_18825;
(statearr_18827[(4)] = cljs.core.rest((state_18825[(4)])));

return statearr_18827;
})();
var state_18825__$1 = state_18825;
var statearr_18828_18861 = state_18825__$1;
(statearr_18828_18861[(2)] = inst_18820);

(statearr_18828_18861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (1))){
var state_18825__$1 = state_18825;
var statearr_18829_18862 = state_18825__$1;
(statearr_18829_18862[(2)] = null);

(statearr_18829_18862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (4))){
var inst_18751 = (state_18825[(2)]);
var state_18825__$1 = state_18825;
var statearr_18830_18863 = state_18825__$1;
(statearr_18830_18863[(2)] = inst_18751);

(statearr_18830_18863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (15))){
var inst_18781 = (state_18825[(7)]);
var inst_18788 = (state_18825[(8)]);
var inst_18801 = (state_18825[(9)]);
var inst_18775 = (state_18825[(10)]);
var inst_18803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18804 = inst_18781.s;
var inst_18805 = [inst_18804,inst_18788,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_18806 = (new cljs.core.PersistentVector(null,3,(5),inst_18803,inst_18805,null));
var inst_18807 = cljs.core.assoc_in(inst_18775,inst_18806,inst_18801);
var state_18825__$1 = state_18825;
var statearr_18831_18864 = state_18825__$1;
(statearr_18831_18864[(2)] = inst_18807);

(statearr_18831_18864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (13))){
var inst_18790 = (state_18825[(11)]);
var inst_18801 = (state_18825[(2)]);
var state_18825__$1 = (function (){var statearr_18832 = state_18825;
(statearr_18832[(9)] = inst_18801);

return statearr_18832;
})();
if(cljs.core.truth_(inst_18790)){
var statearr_18833_18865 = state_18825__$1;
(statearr_18833_18865[(1)] = (15));

} else {
var statearr_18834_18866 = state_18825__$1;
(statearr_18834_18866[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (6))){
var inst_18781 = (state_18825[(7)]);
var inst_18774 = (state_18825[(12)]);
var inst_18780 = cljs.core.seq(inst_18774);
var inst_18781__$1 = cljs.core.first(inst_18780);
var inst_18782 = cljs.core.next(inst_18780);
var inst_18783 = cljs.core.not(inst_18781__$1);
var state_18825__$1 = (function (){var statearr_18835 = state_18825;
(statearr_18835[(7)] = inst_18781__$1);

(statearr_18835[(13)] = inst_18782);

return statearr_18835;
})();
if(inst_18783){
var statearr_18836_18867 = state_18825__$1;
(statearr_18836_18867[(1)] = (8));

} else {
var statearr_18837_18868 = state_18825__$1;
(statearr_18837_18868[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (17))){
var inst_18782 = (state_18825[(13)]);
var inst_18815 = (state_18825[(2)]);
var inst_18774 = inst_18782;
var inst_18775 = inst_18815;
var state_18825__$1 = (function (){var statearr_18838 = state_18825;
(statearr_18838[(12)] = inst_18774);

(statearr_18838[(10)] = inst_18775);

return statearr_18838;
})();
var statearr_18839_18869 = state_18825__$1;
(statearr_18839_18869[(2)] = null);

(statearr_18839_18869[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (3))){
var inst_18823 = (state_18825[(2)]);
var state_18825__$1 = state_18825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18825__$1,inst_18823);
} else {
if((state_val_18826 === (12))){
var inst_18781 = (state_18825[(7)]);
var inst_18799 = inst_18781.o;
var state_18825__$1 = state_18825;
var statearr_18840_18870 = state_18825__$1;
(statearr_18840_18870[(2)] = inst_18799);

(statearr_18840_18870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (2))){
var _ = (function (){var statearr_18841 = state_18825;
(statearr_18841[(4)] = cljs.core.cons((5),(state_18825[(4)])));

return statearr_18841;
})();
var inst_18757 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_18758 = cljs.core.PersistentHashSet.EMPTY;
var inst_18759 = cljs.core.vals(tempids);
var inst_18760 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18758,inst_18759);
var inst_18761 = (function (){var pred_flakes = inst_18757;
var is_new_QMARK_ = inst_18760;
return (function (p1__18749_SHARP_,p2__18750_SHARP_){
return cljs.core.assoc_in(p1__18749_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__18750_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__18842 = p2__18750_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__18842) : is_new_QMARK_.call(null,G__18842));
})()));
});
})();
var inst_18762 = cljs.core.PersistentHashMap.EMPTY;
var inst_18763 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18761,inst_18762,inst_18757);
var inst_18771 = cljs.core.seq(inst_18757);
var inst_18772 = cljs.core.first(inst_18771);
var inst_18773 = cljs.core.next(inst_18771);
var inst_18774 = inst_18757;
var inst_18775 = inst_18763;
var state_18825__$1 = (function (){var statearr_18843 = state_18825;
(statearr_18843[(12)] = inst_18774);

(statearr_18843[(14)] = inst_18773);

(statearr_18843[(10)] = inst_18775);

(statearr_18843[(15)] = inst_18772);

return statearr_18843;
})();
var statearr_18844_18871 = state_18825__$1;
(statearr_18844_18871[(2)] = null);

(statearr_18844_18871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (11))){
var inst_18781 = (state_18825[(7)]);
var inst_18793 = inst_18781.o;
var inst_18794 = fluree.db.query.schema.convert_type_to_kw(inst_18793,db);
var state_18825__$1 = state_18825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18825__$1,(14),inst_18794);
} else {
if((state_val_18826 === (9))){
var inst_18781 = (state_18825[(7)]);
var inst_18788 = (state_18825[(8)]);
var inst_18786 = inst_18781.p;
var inst_18787 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18786);
var inst_18788__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_18787);
var inst_18789 = inst_18781.op;
var inst_18790 = inst_18789 === false;
var inst_18791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_18788__$1);
var state_18825__$1 = (function (){var statearr_18846 = state_18825;
(statearr_18846[(8)] = inst_18788__$1);

(statearr_18846[(11)] = inst_18790);

return statearr_18846;
})();
if(inst_18791){
var statearr_18847_18872 = state_18825__$1;
(statearr_18847_18872[(1)] = (11));

} else {
var statearr_18848_18873 = state_18825__$1;
(statearr_18848_18873[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (5))){
var _ = (function (){var statearr_18849 = state_18825;
(statearr_18849[(4)] = cljs.core.rest((state_18825[(4)])));

return statearr_18849;
})();
var state_18825__$1 = state_18825;
var ex18845 = (state_18825__$1[(2)]);
var statearr_18850_18874 = state_18825__$1;
(statearr_18850_18874[(5)] = ex18845);


if((ex18845 instanceof Error)){
var statearr_18851_18875 = state_18825__$1;
(statearr_18851_18875[(1)] = (4));

(statearr_18851_18875[(5)] = null);

} else {
throw ex18845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (14))){
var inst_18796 = (state_18825[(2)]);
var inst_18797 = fluree.db.util.async.throw_err(inst_18796);
var state_18825__$1 = state_18825;
var statearr_18852_18876 = state_18825__$1;
(statearr_18852_18876[(2)] = inst_18797);

(statearr_18852_18876[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (16))){
var inst_18781 = (state_18825[(7)]);
var inst_18788 = (state_18825[(8)]);
var inst_18801 = (state_18825[(9)]);
var inst_18775 = (state_18825[(10)]);
var inst_18809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18810 = inst_18781.s;
var inst_18811 = [inst_18810,inst_18788,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_18812 = (new cljs.core.PersistentVector(null,3,(5),inst_18809,inst_18811,null));
var inst_18813 = cljs.core.assoc_in(inst_18775,inst_18812,inst_18801);
var state_18825__$1 = state_18825;
var statearr_18853_18877 = state_18825__$1;
(statearr_18853_18877[(2)] = inst_18813);

(statearr_18853_18877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (10))){
var inst_18818 = (state_18825[(2)]);
var state_18825__$1 = state_18825;
var statearr_18854_18878 = state_18825__$1;
(statearr_18854_18878[(2)] = inst_18818);

(statearr_18854_18878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (8))){
var inst_18775 = (state_18825[(10)]);
var state_18825__$1 = state_18825;
var statearr_18855_18879 = state_18825__$1;
(statearr_18855_18879[(2)] = inst_18775);

(statearr_18855_18879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0 = (function (){
var statearr_18856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18856[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__);

(statearr_18856[(1)] = (1));

return statearr_18856;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1 = (function (state_18825){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_18825);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18857){var ex__2882__auto__ = e18857;
var statearr_18858_18880 = state_18825;
(statearr_18858_18880[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_18825[(4)]))){
var statearr_18859_18881 = state_18825;
(statearr_18859_18881[(1)] = cljs.core.first((state_18825[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18882 = state_18825;
state_18825 = G__18882;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__ = function(state_18825){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1.call(this,state_18825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18860 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_18860[(6)] = c__2901__auto__);

return statearr_18860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__18884 = arguments.length;
switch (G__18884) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__18887 = arguments.length;
switch (G__18887) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19196){
var state_val_19197 = (state_19196[(1)]);
if((state_val_19197 === (65))){
var inst_19149 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19198_19370 = state_19196__$1;
(statearr_19198_19370[(2)] = inst_19149);

(statearr_19198_19370[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (70))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19071 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19072 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_19071,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,2,inst_19071,null));
var inst_19073 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19072,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19072,null));
var inst_19074 = (inst_19073.cljs$core$IFn$_invoke$arity$1 ? inst_19073.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19073.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19074)){
var statearr_19199_19371 = state_19196__$1;
(statearr_19199_19371[(1)] = (71));

} else {
var statearr_19200_19372 = state_19196__$1;
(statearr_19200_19372[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (62))){
var inst_19151 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19201_19373 = state_19196__$1;
(statearr_19201_19373[(2)] = inst_19151);

(statearr_19201_19373[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (74))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19081 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19082 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19081,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,3,inst_19081,null));
var inst_19083 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19082,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19082,null));
var inst_19084 = (inst_19083.cljs$core$IFn$_invoke$arity$1 ? inst_19083.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19083.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19084)){
var statearr_19202_19374 = state_19196__$1;
(statearr_19202_19374[(1)] = (75));

} else {
var statearr_19203_19375 = state_19196__$1;
(statearr_19203_19375[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (110))){
var inst_19183 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19204_19376 = state_19196__$1;
(statearr_19204_19376[(2)] = inst_19183);

(statearr_19204_19376[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (7))){
var inst_19191 = (state_19196[(2)]);
var _ = (function (){var statearr_19205 = state_19196;
(statearr_19205[(4)] = cljs.core.rest((state_19196[(4)])));

return statearr_19205;
})();
var state_19196__$1 = state_19196;
var statearr_19206_19377 = state_19196__$1;
(statearr_19206_19377[(2)] = inst_19191);

(statearr_19206_19377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (59))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19057 = (state_19196[(2)]);
var inst_19058__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19057,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_19059__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19057,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_19060 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19059__$1,inst_19058__$1);
var state_19196__$1 = (function (){var statearr_19207 = state_19196;
(statearr_19207[(7)] = inst_19058__$1);

(statearr_19207[(8)] = inst_19059__$1);

return statearr_19207;
})();
if(inst_19060){
var statearr_19208_19378 = state_19196__$1;
(statearr_19208_19378[(1)] = (60));

} else {
var statearr_19209_19379 = state_19196__$1;
(statearr_19209_19379[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (86))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19111 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19112 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_19111,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,5,inst_19111,null));
var inst_19113 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19112,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19112,null));
var inst_19114 = (inst_19113.cljs$core$IFn$_invoke$arity$1 ? inst_19113.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19113.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19114)){
var statearr_19210_19380 = state_19196__$1;
(statearr_19210_19380[(1)] = (87));

} else {
var statearr_19211_19381 = state_19196__$1;
(statearr_19211_19381[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (20))){
var inst_18927 = (state_19196[(9)]);
var inst_18952 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18953 = inst_18952 === true;
var inst_18954 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18955 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18954);
var inst_18956 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_18955);
var inst_18957 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18958 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18957);
var inst_18959 = inst_18958 === true;
var inst_18960 = ((inst_18953) && (inst_18956) && (inst_18959));
var state_19196__$1 = state_19196;
var statearr_19212_19382 = state_19196__$1;
(statearr_19212_19382[(2)] = inst_18960);

(statearr_19212_19382[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (72))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19077 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19213_19383 = state_19196__$1;
(statearr_19213_19383[(2)] = inst_19077);

(statearr_19213_19383[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (58))){
var inst_19036 = (state_19196[(10)]);
var state_19196__$1 = state_19196;
var statearr_19214_19384 = state_19196__$1;
(statearr_19214_19384[(2)] = inst_19036);

(statearr_19214_19384[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (60))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19215_19385 = state_19196__$1;
(statearr_19215_19385[(2)] = inst_19026);

(statearr_19215_19385[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (27))){
var inst_18947 = (state_19196[(12)]);
var state_19196__$1 = state_19196;
var statearr_19216_19386 = state_19196__$1;
(statearr_19216_19386[(2)] = inst_18947);

(statearr_19216_19386[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (1))){
var state_19196__$1 = state_19196;
var statearr_19217_19387 = state_19196__$1;
(statearr_19217_19387[(2)] = null);

(statearr_19217_19387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (69))){
var inst_19144 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19218_19388 = state_19196__$1;
(statearr_19218_19388[(2)] = inst_19144);

(statearr_19218_19388[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (101))){
var inst_19173 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19173)){
var statearr_19219_19389 = state_19196__$1;
(statearr_19219_19389[(1)] = (105));

} else {
var statearr_19220_19390 = state_19196__$1;
(statearr_19220_19390[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (24))){
var inst_18947 = (state_19196[(12)]);
var state_19196__$1 = state_19196;
var statearr_19221_19391 = state_19196__$1;
(statearr_19221_19391[(2)] = inst_18947);

(statearr_19221_19391[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (102))){
var inst_18927 = (state_19196[(9)]);
var inst_19160 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19161 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19160);
var inst_19162 = inst_19161 === true;
var inst_19163 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19164 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19163);
var inst_19165 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_19164);
var inst_19166 = (!(inst_19165));
var inst_19167 = ((inst_19162) && (inst_19166));
var state_19196__$1 = state_19196;
var statearr_19222_19392 = state_19196__$1;
(statearr_19222_19392[(2)] = inst_19167);

(statearr_19222_19392[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (55))){
var state_19196__$1 = state_19196;
var statearr_19223_19393 = state_19196__$1;
(statearr_19223_19393[(2)] = false);

(statearr_19223_19393[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (85))){
var inst_19109 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19224_19394 = state_19196__$1;
(statearr_19224_19394[(2)] = inst_19109);

(statearr_19224_19394[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (39))){
var state_19196__$1 = state_19196;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19225_19395 = state_19196__$1;
(statearr_19225_19395[(1)] = (42));

} else {
var statearr_19226_19396 = state_19196__$1;
(statearr_19226_19396[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (88))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19117 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19227_19397 = state_19196__$1;
(statearr_19227_19397[(2)] = inst_19117);

(statearr_19227_19397[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (46))){
var inst_19027 = (state_19196[(13)]);
var state_19196__$1 = state_19196;
var statearr_19228_19398 = state_19196__$1;
(statearr_19228_19398[(2)] = inst_19027);

(statearr_19228_19398[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (4))){
var inst_18888 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19229_19399 = state_19196__$1;
(statearr_19229_19399[(2)] = inst_18888);

(statearr_19229_19399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (77))){
var inst_19089 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19230_19400 = state_19196__$1;
(statearr_19230_19400[(2)] = inst_19089);

(statearr_19230_19400[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (106))){
var inst_19154 = (state_19196[(14)]);
var state_19196__$1 = state_19196;
var statearr_19231_19401 = state_19196__$1;
(statearr_19231_19401[(2)] = inst_19154);

(statearr_19231_19401[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (95))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19232_19402 = state_19196__$1;
(statearr_19232_19402[(2)] = inst_19026);

(statearr_19232_19402[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (54))){
var state_19196__$1 = state_19196;
var statearr_19233_19403 = state_19196__$1;
(statearr_19233_19403[(2)] = true);

(statearr_19233_19403[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (92))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19127 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19234_19404 = state_19196__$1;
(statearr_19234_19404[(2)] = inst_19127);

(statearr_19234_19404[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (104))){
var inst_19170 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19235_19405 = state_19196__$1;
(statearr_19235_19405[(2)] = inst_19170);

(statearr_19235_19405[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (15))){
var inst_18915 = (state_19196[(15)]);
var state_19196__$1 = state_19196;
var statearr_19236_19406 = state_19196__$1;
(statearr_19236_19406[(2)] = inst_18915);

(statearr_19236_19406[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (48))){
var inst_19036 = (state_19196[(10)]);
var inst_18927 = (state_19196[(9)]);
var inst_19036__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19038 = (inst_19036__$1 == null);
var inst_19039 = cljs.core.not(inst_19038);
var state_19196__$1 = (function (){var statearr_19237 = state_19196;
(statearr_19237[(10)] = inst_19036__$1);

return statearr_19237;
})();
if(inst_19039){
var statearr_19238_19407 = state_19196__$1;
(statearr_19238_19407[(1)] = (51));

} else {
var statearr_19239_19408 = state_19196__$1;
(statearr_19239_19408[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (50))){
var inst_18927 = (state_19196[(9)]);
var inst_19154 = (state_19196[(2)]);
var inst_19155 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19156 = inst_19155 === true;
var state_19196__$1 = (function (){var statearr_19240 = state_19196;
(statearr_19240[(14)] = inst_19154);

return statearr_19240;
})();
if(cljs.core.truth_(inst_19156)){
var statearr_19241_19409 = state_19196__$1;
(statearr_19241_19409[(1)] = (99));

} else {
var statearr_19242_19410 = state_19196__$1;
(statearr_19242_19410[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (75))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19243_19411 = state_19196__$1;
(statearr_19243_19411[(2)] = inst_19026);

(statearr_19243_19411[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (99))){
var inst_18927 = (state_19196[(9)]);
var inst_19158 = (state_19196[(16)]);
var inst_19158__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19244 = state_19196;
(statearr_19244[(16)] = inst_19158__$1);

return statearr_19244;
})();
if(cljs.core.truth_(inst_19158__$1)){
var statearr_19245_19412 = state_19196__$1;
(statearr_19245_19412[(1)] = (102));

} else {
var statearr_19246_19413 = state_19196__$1;
(statearr_19246_19413[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (21))){
var inst_18950 = (state_19196[(17)]);
var state_19196__$1 = state_19196;
var statearr_19247_19414 = state_19196__$1;
(statearr_19247_19414[(2)] = inst_18950);

(statearr_19247_19414[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (31))){
var inst_18990 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_18990)){
var statearr_19248_19415 = state_19196__$1;
(statearr_19248_19415[(1)] = (32));

} else {
var statearr_19249_19416 = state_19196__$1;
(statearr_19249_19416[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (32))){
var inst_18979 = (state_19196[(18)]);
var inst_18992 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_18979,"a component","a non-component",throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19250_19417 = state_19196__$1;
(statearr_19250_19417[(2)] = inst_18992);

(statearr_19250_19417[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (40))){
var inst_18995 = (state_19196[(19)]);
var state_19196__$1 = state_19196;
var statearr_19251_19418 = state_19196__$1;
(statearr_19251_19418[(2)] = inst_18995);

(statearr_19251_19418[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (91))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19252_19419 = state_19196__$1;
(statearr_19252_19419[(2)] = inst_19026);

(statearr_19252_19419[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (108))){
var inst_19176 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19177 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19178 = cljs.core.PersistentHashMap.fromArrays(inst_19176,inst_19177);
var inst_19179 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_19178);
var inst_19180 = (function(){throw inst_19179})();
var state_19196__$1 = state_19196;
var statearr_19253_19420 = state_19196__$1;
(statearr_19253_19420[(2)] = inst_19180);

(statearr_19253_19420[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (56))){
var inst_19049 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19254_19421 = state_19196__$1;
(statearr_19254_19421[(2)] = inst_19049);

(statearr_19254_19421[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (33))){
var inst_18979 = (state_19196[(18)]);
var state_19196__$1 = state_19196;
var statearr_19255_19422 = state_19196__$1;
(statearr_19255_19422[(2)] = inst_18979);

(statearr_19255_19422[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (13))){
var inst_18942 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_18942)){
var statearr_19256_19423 = state_19196__$1;
(statearr_19256_19423[(1)] = (14));

} else {
var statearr_19257_19424 = state_19196__$1;
(statearr_19257_19424[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (22))){
var inst_18963 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19258_19425 = state_19196__$1;
(statearr_19258_19425[(2)] = inst_18963);

(statearr_19258_19425[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (90))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19121 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_19122 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_19121,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,5,inst_19121,null));
var inst_19123 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19122,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19122,null));
var inst_19124 = (inst_19123.cljs$core$IFn$_invoke$arity$1 ? inst_19123.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19123.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19124)){
var statearr_19259_19426 = state_19196__$1;
(statearr_19259_19426[(1)] = (91));

} else {
var statearr_19260_19427 = state_19196__$1;
(statearr_19260_19427[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (109))){
var inst_19154 = (state_19196[(14)]);
var state_19196__$1 = state_19196;
var statearr_19261_19428 = state_19196__$1;
(statearr_19261_19428[(2)] = inst_19154);

(statearr_19261_19428[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (36))){
var inst_18996 = (state_19196[(20)]);
var state_19196__$1 = state_19196;
var statearr_19262_19429 = state_19196__$1;
(statearr_19262_19429[(2)] = inst_18996);

(statearr_19262_19429[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (41))){
var inst_18927 = (state_19196[(9)]);
var inst_19027 = (state_19196[(13)]);
var inst_19026 = (state_19196[(2)]);
var inst_19027__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19263 = state_19196;
(statearr_19263[(13)] = inst_19027__$1);

(statearr_19263[(11)] = inst_19026);

return statearr_19263;
})();
if(cljs.core.truth_(inst_19027__$1)){
var statearr_19264_19430 = state_19196__$1;
(statearr_19264_19430[(1)] = (45));

} else {
var statearr_19265_19431 = state_19196__$1;
(statearr_19265_19431[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (89))){
var inst_19119 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19266_19432 = state_19196__$1;
(statearr_19266_19432[(2)] = inst_19119);

(statearr_19266_19432[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (100))){
var state_19196__$1 = state_19196;
var statearr_19267_19433 = state_19196__$1;
(statearr_19267_19433[(2)] = false);

(statearr_19267_19433[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (43))){
var inst_18995 = (state_19196[(19)]);
var state_19196__$1 = state_19196;
var statearr_19268_19434 = state_19196__$1;
(statearr_19268_19434[(2)] = inst_18995);

(statearr_19268_19434[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (61))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19063 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_19064 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19063,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,3,inst_19063,null));
var inst_19065 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19064,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19064,null));
var inst_19066 = (inst_19065.cljs$core$IFn$_invoke$arity$1 ? inst_19065.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19065.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19066)){
var statearr_19269_19435 = state_19196__$1;
(statearr_19269_19435[(1)] = (63));

} else {
var statearr_19270_19436 = state_19196__$1;
(statearr_19270_19436[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (29))){
var inst_18927 = (state_19196[(9)]);
var inst_18982 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18983 = cljs.core.not(inst_18982);
var inst_18984 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18985 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18984);
var inst_18986 = inst_18985 === true;
var inst_18987 = ((inst_18983) && (inst_18986));
var state_19196__$1 = state_19196;
var statearr_19271_19437 = state_19196__$1;
(statearr_19271_19437[(2)] = inst_18987);

(statearr_19271_19437[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (44))){
var inst_19023 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19272_19438 = state_19196__$1;
(statearr_19272_19438[(2)] = inst_19023);

(statearr_19272_19438[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (93))){
var inst_19129 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19273_19439 = state_19196__$1;
(statearr_19273_19439[(2)] = inst_19129);

(statearr_19273_19439[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (6))){
var inst_18914 = (state_19196[(21)]);
var inst_18926 = (state_19196[(22)]);
var inst_18923 = cljs.core.seq(inst_18914);
var inst_18924 = cljs.core.first(inst_18923);
var inst_18925 = cljs.core.next(inst_18923);
var inst_18926__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18924,(0),null);
var inst_18927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18924,(1),null);
var inst_18928 = cljs.core.not(inst_18926__$1);
var state_19196__$1 = (function (){var statearr_19274 = state_19196;
(statearr_19274[(22)] = inst_18926__$1);

(statearr_19274[(23)] = inst_18925);

(statearr_19274[(9)] = inst_18927);

return statearr_19274;
})();
if(inst_18928){
var statearr_19275_19440 = state_19196__$1;
(statearr_19275_19440[(1)] = (8));

} else {
var statearr_19276_19441 = state_19196__$1;
(statearr_19276_19441[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (28))){
var inst_18976 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19277_19442 = state_19196__$1;
(statearr_19277_19442[(2)] = inst_18976);

(statearr_19277_19442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (64))){
var state_19196__$1 = state_19196;
var statearr_19278_19443 = state_19196__$1;
(statearr_19278_19443[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (103))){
var inst_19158 = (state_19196[(16)]);
var state_19196__$1 = state_19196;
var statearr_19280_19444 = state_19196__$1;
(statearr_19280_19444[(2)] = inst_19158);

(statearr_19280_19444[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (51))){
var inst_19036 = (state_19196[(10)]);
var inst_19041 = inst_19036.cljs$lang$protocol_mask$partition0$;
var inst_19042 = (inst_19041 & (64));
var inst_19043 = inst_19036.cljs$core$ISeq$;
var inst_19044 = (cljs.core.PROTOCOL_SENTINEL === inst_19043);
var inst_19045 = ((inst_19042) || (inst_19044));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19045)){
var statearr_19281_19445 = state_19196__$1;
(statearr_19281_19445[(1)] = (54));

} else {
var statearr_19282_19446 = state_19196__$1;
(statearr_19282_19446[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (25))){
var inst_18927 = (state_19196[(9)]);
var inst_18980 = (state_19196[(24)]);
var inst_18979 = (state_19196[(2)]);
var inst_18980__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19283 = state_19196;
(statearr_19283[(24)] = inst_18980__$1);

(statearr_19283[(18)] = inst_18979);

return statearr_19283;
})();
if(cljs.core.truth_(inst_18980__$1)){
var statearr_19284_19447 = state_19196__$1;
(statearr_19284_19447[(1)] = (29));

} else {
var statearr_19285_19448 = state_19196__$1;
(statearr_19285_19448[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (34))){
var inst_18996 = (state_19196[(20)]);
var inst_18927 = (state_19196[(9)]);
var inst_18995 = (state_19196[(2)]);
var inst_18996__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19286 = state_19196;
(statearr_19286[(19)] = inst_18995);

(statearr_19286[(20)] = inst_18996__$1);

return statearr_19286;
})();
if(cljs.core.truth_(inst_18996__$1)){
var statearr_19287_19449 = state_19196__$1;
(statearr_19287_19449[(1)] = (35));

} else {
var statearr_19288_19450 = state_19196__$1;
(statearr_19288_19450[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (17))){
var inst_18950 = (state_19196[(17)]);
var inst_18927 = (state_19196[(9)]);
var inst_18950__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19289 = state_19196;
(statearr_19289[(17)] = inst_18950__$1);

return statearr_19289;
})();
if(cljs.core.truth_(inst_18950__$1)){
var statearr_19290_19451 = state_19196__$1;
(statearr_19290_19451[(1)] = (20));

} else {
var statearr_19291_19452 = state_19196__$1;
(statearr_19291_19452[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (3))){
var inst_19194 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19196__$1,inst_19194);
} else {
if((state_val_19197 === (12))){
var inst_18931 = (state_19196[(25)]);
var state_19196__$1 = state_19196;
var statearr_19292_19453 = state_19196__$1;
(statearr_19292_19453[(2)] = inst_18931);

(statearr_19292_19453[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (2))){
var _ = (function (){var statearr_19293 = state_19196;
(statearr_19293[(4)] = cljs.core.cons((5),(state_19196[(4)])));

return statearr_19293;
})();
var inst_18907 = pred_changes;
var inst_18908 = cljs.core.seq(inst_18907);
var inst_18909 = cljs.core.first(inst_18908);
var inst_18910 = cljs.core.next(inst_18908);
var inst_18911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18909,(0),null);
var inst_18912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18909,(1),null);
var inst_18913 = db;
var inst_18914 = inst_18907;
var inst_18915 = inst_18913;
var state_19196__$1 = (function (){var statearr_19294 = state_19196;
(statearr_19294[(15)] = inst_18915);

(statearr_19294[(21)] = inst_18914);

(statearr_19294[(26)] = inst_18910);

(statearr_19294[(27)] = inst_18912);

(statearr_19294[(28)] = inst_18911);

return statearr_19294;
})();
var statearr_19295_19454 = state_19196__$1;
(statearr_19295_19454[(2)] = null);

(statearr_19295_19454[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (66))){
var inst_19059 = (state_19196[(8)]);
var state_19196__$1 = state_19196;
var G__19296_19455 = inst_19059;
var G__19296_19456__$1 = (((G__19296_19455 instanceof cljs.core.Keyword))?G__19296_19455.fqn:null);
switch (G__19296_19456__$1) {
case "long":
var statearr_19297_19458 = state_19196__$1;
(statearr_19297_19458[(1)] = (70));


break;
case "bigint":
var statearr_19298_19459 = state_19196__$1;
(statearr_19298_19459[(1)] = (74));


break;
case "double":
var statearr_19299_19460 = state_19196__$1;
(statearr_19299_19460[(1)] = (78));


break;
case "float":
var statearr_19300_19461 = state_19196__$1;
(statearr_19300_19461[(1)] = (82));


break;
case "bigdec":
var statearr_19301_19462 = state_19196__$1;
(statearr_19301_19462[(1)] = (86));


break;
case "string":
var statearr_19302_19463 = state_19196__$1;
(statearr_19302_19463[(1)] = (90));


break;
case "instant":
var statearr_19303_19464 = state_19196__$1;
(statearr_19303_19464[(1)] = (94));


break;
default:
var statearr_19304_19465 = state_19196__$1;
(statearr_19304_19465[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (107))){
var inst_18925 = (state_19196[(23)]);
var inst_19186 = (state_19196[(2)]);
var inst_18914 = inst_18925;
var inst_18915 = inst_19186;
var state_19196__$1 = (function (){var statearr_19305 = state_19196;
(statearr_19305[(15)] = inst_18915);

(statearr_19305[(21)] = inst_18914);

return statearr_19305;
})();
var statearr_19306_19466 = state_19196__$1;
(statearr_19306_19466[(2)] = null);

(statearr_19306_19466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (23))){
var state_19196__$1 = state_19196;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19307_19467 = state_19196__$1;
(statearr_19307_19467[(1)] = (26));

} else {
var statearr_19308_19468 = state_19196__$1;
(statearr_19308_19468[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (47))){
var inst_19033 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19033)){
var statearr_19309_19469 = state_19196__$1;
(statearr_19309_19469[(1)] = (48));

} else {
var statearr_19310_19470 = state_19196__$1;
(statearr_19310_19470[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (35))){
var inst_18915 = (state_19196[(15)]);
var inst_18926 = (state_19196[(22)]);
var inst_18927 = (state_19196[(9)]);
var inst_18998 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18999 = cljs.core.not(inst_18998);
var inst_19000 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19001 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19000);
var inst_19002 = inst_19001 === true;
var inst_19003 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_18915,inst_18926);
var state_19196__$1 = (function (){var statearr_19311 = state_19196;
(statearr_19311[(29)] = inst_18999);

(statearr_19311[(30)] = inst_19002);

return statearr_19311;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19196__$1,(38),inst_19003);
} else {
if((state_val_19197 === (82))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19101 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19102 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19101,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,3,inst_19101,null));
var inst_19103 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19102,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19102,null));
var inst_19104 = (inst_19103.cljs$core$IFn$_invoke$arity$1 ? inst_19103.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19103.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19104)){
var statearr_19312_19471 = state_19196__$1;
(statearr_19312_19471[(1)] = (83));

} else {
var statearr_19313_19472 = state_19196__$1;
(statearr_19313_19472[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (76))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19087 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19314_19473 = state_19196__$1;
(statearr_19314_19473[(2)] = inst_19087);

(statearr_19314_19473[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (97))){
var inst_19139 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19315_19474 = state_19196__$1;
(statearr_19315_19474[(2)] = inst_19139);

(statearr_19315_19474[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (19))){
var inst_18966 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_18966)){
var statearr_19316_19475 = state_19196__$1;
(statearr_19316_19475[(1)] = (23));

} else {
var statearr_19317_19476 = state_19196__$1;
(statearr_19317_19476[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (57))){
var inst_19036 = (state_19196[(10)]);
var inst_19054 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19036);
var state_19196__$1 = state_19196;
var statearr_19318_19477 = state_19196__$1;
(statearr_19318_19477[(2)] = inst_19054);

(statearr_19318_19477[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (68))){
var inst_19147 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19319_19478 = state_19196__$1;
(statearr_19319_19478[(2)] = inst_19147);

(statearr_19319_19478[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (11))){
var inst_18927 = (state_19196[(9)]);
var inst_18933 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18934 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18933);
var inst_18935 = inst_18934 === false;
var inst_18936 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_18937 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18936);
var inst_18938 = inst_18937 === true;
var inst_18939 = ((inst_18935) && (inst_18938));
var state_19196__$1 = state_19196;
var statearr_19321_19479 = state_19196__$1;
(statearr_19321_19479[(2)] = inst_18939);

(statearr_19321_19479[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (9))){
var inst_18927 = (state_19196[(9)]);
var inst_18931 = (state_19196[(25)]);
var inst_18931__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19322 = state_19196;
(statearr_19322[(25)] = inst_18931__$1);

return statearr_19322;
})();
if(cljs.core.truth_(inst_18931__$1)){
var statearr_19323_19480 = state_19196__$1;
(statearr_19323_19480[(1)] = (11));

} else {
var statearr_19324_19481 = state_19196__$1;
(statearr_19324_19481[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (5))){
var _ = (function (){var statearr_19325 = state_19196;
(statearr_19325[(4)] = cljs.core.rest((state_19196[(4)])));

return statearr_19325;
})();
var state_19196__$1 = state_19196;
var ex19320 = (state_19196__$1[(2)]);
var statearr_19326_19482 = state_19196__$1;
(statearr_19326_19482[(5)] = ex19320);


if((ex19320 instanceof Error)){
var statearr_19327_19483 = state_19196__$1;
(statearr_19327_19483[(1)] = (4));

(statearr_19327_19483[(5)] = null);

} else {
throw ex19320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (83))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19328_19484 = state_19196__$1;
(statearr_19328_19484[(2)] = inst_19026);

(statearr_19328_19484[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (14))){
var inst_18915 = (state_19196[(15)]);
var inst_18944 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_18915,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19329_19485 = state_19196__$1;
(statearr_19329_19485[(2)] = inst_18944);

(statearr_19329_19485[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (45))){
var inst_18927 = (state_19196[(9)]);
var inst_19029 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18927);
var inst_19030 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_19029);
var state_19196__$1 = state_19196;
var statearr_19330_19486 = state_19196__$1;
(statearr_19330_19486[(2)] = inst_19030);

(statearr_19330_19486[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (53))){
var inst_19052 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19052)){
var statearr_19331_19487 = state_19196__$1;
(statearr_19331_19487[(1)] = (57));

} else {
var statearr_19332_19488 = state_19196__$1;
(statearr_19332_19488[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (78))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19091 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19092 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19091,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,3,inst_19091,null));
var inst_19093 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19092,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19092,null));
var inst_19094 = (inst_19093.cljs$core$IFn$_invoke$arity$1 ? inst_19093.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19093.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19094)){
var statearr_19333_19489 = state_19196__$1;
(statearr_19333_19489[(1)] = (79));

} else {
var statearr_19334_19490 = state_19196__$1;
(statearr_19334_19490[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (26))){
var inst_18969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18970 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18971 = cljs.core.PersistentHashMap.fromArrays(inst_18969,inst_18970);
var inst_18972 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_18971);
var inst_18973 = (function(){throw inst_18972})();
var state_19196__$1 = state_19196;
var statearr_19335_19491 = state_19196__$1;
(statearr_19335_19491[(2)] = inst_18973);

(statearr_19335_19491[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (16))){
var inst_18948 = (state_19196[(31)]);
var inst_18927 = (state_19196[(9)]);
var inst_18947 = (state_19196[(2)]);
var inst_18948__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18927);
var state_19196__$1 = (function (){var statearr_19336 = state_19196;
(statearr_19336[(31)] = inst_18948__$1);

(statearr_19336[(12)] = inst_18947);

return statearr_19336;
})();
if(cljs.core.truth_(inst_18948__$1)){
var statearr_19337_19492 = state_19196__$1;
(statearr_19337_19492[(1)] = (17));

} else {
var statearr_19338_19493 = state_19196__$1;
(statearr_19338_19493[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (81))){
var inst_19099 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19339_19494 = state_19196__$1;
(statearr_19339_19494[(2)] = inst_19099);

(statearr_19339_19494[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (79))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19340_19495 = state_19196__$1;
(statearr_19340_19495[(2)] = inst_19026);

(statearr_19340_19495[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (38))){
var inst_18999 = (state_19196[(29)]);
var inst_19002 = (state_19196[(30)]);
var inst_19005 = (state_19196[(2)]);
var inst_19006 = fluree.db.util.async.throw_err(inst_19005);
var inst_19007 = cljs.core.not(inst_19006);
var inst_19008 = ((inst_18999) && (inst_19002) && (inst_19007));
var state_19196__$1 = state_19196;
var statearr_19341_19496 = state_19196__$1;
(statearr_19341_19496[(2)] = inst_19008);

(statearr_19341_19496[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (98))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19141 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19342_19497 = state_19196__$1;
(statearr_19342_19497[(2)] = inst_19141);

(statearr_19342_19497[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (87))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19343_19498 = state_19196__$1;
(statearr_19343_19498[(2)] = inst_19026);

(statearr_19343_19498[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (30))){
var inst_18980 = (state_19196[(24)]);
var state_19196__$1 = state_19196;
var statearr_19344_19499 = state_19196__$1;
(statearr_19344_19499[(2)] = inst_18980);

(statearr_19344_19499[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (73))){
var inst_19079 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19345_19500 = state_19196__$1;
(statearr_19345_19500[(2)] = inst_19079);

(statearr_19345_19500[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (96))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19137 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19346_19501 = state_19196__$1;
(statearr_19346_19501[(2)] = inst_19137);

(statearr_19346_19501[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (10))){
var inst_19189 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
var statearr_19347_19502 = state_19196__$1;
(statearr_19347_19502[(2)] = inst_19189);

(statearr_19347_19502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (18))){
var inst_18948 = (state_19196[(31)]);
var state_19196__$1 = state_19196;
var statearr_19348_19503 = state_19196__$1;
(statearr_19348_19503[(2)] = inst_18948);

(statearr_19348_19503[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (105))){
var state_19196__$1 = state_19196;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19349_19504 = state_19196__$1;
(statearr_19349_19504[(1)] = (108));

} else {
var statearr_19350_19505 = state_19196__$1;
(statearr_19350_19505[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (52))){
var state_19196__$1 = state_19196;
var statearr_19351_19506 = state_19196__$1;
(statearr_19351_19506[(2)] = false);

(statearr_19351_19506[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (67))){
var state_19196__$1 = state_19196;
var statearr_19352_19507 = state_19196__$1;
(statearr_19352_19507[(2)] = null);

(statearr_19352_19507[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (71))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19353_19508 = state_19196__$1;
(statearr_19353_19508[(2)] = inst_19026);

(statearr_19353_19508[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (42))){
var inst_18915 = (state_19196[(15)]);
var inst_18926 = (state_19196[(22)]);
var inst_19014 = fluree.db.dbproto._p_prop(inst_18915,new cljs.core.Keyword(null,"name","name",1843675177),inst_18926);
var inst_19015 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19014)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_19016 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19017 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19018 = cljs.core.PersistentHashMap.fromArrays(inst_19016,inst_19017);
var inst_19019 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19015,inst_19018);
var inst_19020 = (function(){throw inst_19019})();
var state_19196__$1 = state_19196;
var statearr_19354_19509 = state_19196__$1;
(statearr_19354_19509[(2)] = inst_19020);

(statearr_19354_19509[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (80))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19097 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19355_19510 = state_19196__$1;
(statearr_19355_19510[(2)] = inst_19097);

(statearr_19355_19510[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (37))){
var inst_19011 = (state_19196[(2)]);
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19011)){
var statearr_19356_19511 = state_19196__$1;
(statearr_19356_19511[(1)] = (39));

} else {
var statearr_19357_19512 = state_19196__$1;
(statearr_19357_19512[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (63))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19068 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19358_19513 = state_19196__$1;
(statearr_19358_19513[(2)] = inst_19068);

(statearr_19358_19513[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (94))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19131 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19132 = (inst_19059.cljs$core$IFn$_invoke$arity$5 ? inst_19059.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_19131,null) : inst_19059.call(null,cljs.core.PersistentArrayMap,null,2,inst_19131,null));
var inst_19133 = (inst_19059.cljs$core$IFn$_invoke$arity$4 ? inst_19059.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19132,null) : inst_19059.call(null,cljs.core.PersistentHashSet,null,inst_19132,null));
var inst_19134 = (inst_19133.cljs$core$IFn$_invoke$arity$1 ? inst_19133.cljs$core$IFn$_invoke$arity$1(inst_19058) : inst_19133.call(null,inst_19058));
var state_19196__$1 = state_19196;
if(cljs.core.truth_(inst_19134)){
var statearr_19359_19514 = state_19196__$1;
(statearr_19359_19514[(1)] = (95));

} else {
var statearr_19360_19515 = state_19196__$1;
(statearr_19360_19515[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (8))){
var inst_18915 = (state_19196[(15)]);
var state_19196__$1 = state_19196;
var statearr_19361_19516 = state_19196__$1;
(statearr_19361_19516[(2)] = inst_18915);

(statearr_19361_19516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (49))){
var inst_19026 = (state_19196[(11)]);
var state_19196__$1 = state_19196;
var statearr_19362_19517 = state_19196__$1;
(statearr_19362_19517[(2)] = inst_19026);

(statearr_19362_19517[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19197 === (84))){
var inst_19058 = (state_19196[(7)]);
var inst_19059 = (state_19196[(8)]);
var inst_19107 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19058,inst_19059,throw_QMARK_);
var state_19196__$1 = state_19196;
var statearr_19363_19518 = state_19196__$1;
(statearr_19363_19518[(2)] = inst_19107);

(statearr_19363_19518[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2879__auto__ = null;
var fluree$db$query$schema$state_machine__2879__auto____0 = (function (){
var statearr_19364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19364[(0)] = fluree$db$query$schema$state_machine__2879__auto__);

(statearr_19364[(1)] = (1));

return statearr_19364;
});
var fluree$db$query$schema$state_machine__2879__auto____1 = (function (state_19196){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_19196);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19365){var ex__2882__auto__ = e19365;
var statearr_19366_19519 = state_19196;
(statearr_19366_19519[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_19196[(4)]))){
var statearr_19367_19520 = state_19196;
(statearr_19367_19520[(1)] = cljs.core.first((state_19196[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19521 = state_19196;
state_19196 = G__19521;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2879__auto__ = function(state_19196){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2879__auto____1.call(this,state_19196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2879__auto____0;
fluree$db$query$schema$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2879__auto____1;
return fluree$db$query$schema$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19368 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_19368[(6)] = c__2901__auto__);

return statearr_19368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19545){
var state_val_19546 = (state_19545[(1)]);
if((state_val_19546 === (7))){
var state_19545__$1 = state_19545;
var statearr_19547_19566 = state_19545__$1;
(statearr_19547_19566[(2)] = db);

(statearr_19547_19566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (1))){
var state_19545__$1 = state_19545;
var statearr_19548_19567 = state_19545__$1;
(statearr_19548_19567[(2)] = null);

(statearr_19548_19567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (4))){
var inst_19522 = (state_19545[(2)]);
var state_19545__$1 = state_19545;
var statearr_19549_19568 = state_19545__$1;
(statearr_19549_19568[(2)] = inst_19522);

(statearr_19549_19568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (6))){
var inst_19531 = (state_19545[(7)]);
var inst_19530 = (state_19545[(2)]);
var inst_19531__$1 = fluree.db.util.async.throw_err(inst_19530);
var inst_19532 = cljs.core.empty_QMARK_(inst_19531__$1);
var state_19545__$1 = (function (){var statearr_19550 = state_19545;
(statearr_19550[(7)] = inst_19531__$1);

return statearr_19550;
})();
if(inst_19532){
var statearr_19551_19569 = state_19545__$1;
(statearr_19551_19569[(1)] = (7));

} else {
var statearr_19552_19570 = state_19545__$1;
(statearr_19552_19570[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (3))){
var inst_19543 = (state_19545[(2)]);
var state_19545__$1 = state_19545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19545__$1,inst_19543);
} else {
if((state_val_19546 === (2))){
var _ = (function (){var statearr_19554 = state_19545;
(statearr_19554[(4)] = cljs.core.cons((5),(state_19545[(4)])));

return statearr_19554;
})();
var inst_19528 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_19545__$1 = state_19545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19545__$1,(6),inst_19528);
} else {
if((state_val_19546 === (9))){
var inst_19540 = (state_19545[(2)]);
var _ = (function (){var statearr_19555 = state_19545;
(statearr_19555[(4)] = cljs.core.rest((state_19545[(4)])));

return statearr_19555;
})();
var state_19545__$1 = state_19545;
var statearr_19556_19571 = state_19545__$1;
(statearr_19556_19571[(2)] = inst_19540);

(statearr_19556_19571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (5))){
var _ = (function (){var statearr_19557 = state_19545;
(statearr_19557[(4)] = cljs.core.rest((state_19545[(4)])));

return statearr_19557;
})();
var state_19545__$1 = state_19545;
var ex19553 = (state_19545__$1[(2)]);
var statearr_19558_19572 = state_19545__$1;
(statearr_19558_19572[(5)] = ex19553);


if((ex19553 instanceof Error)){
var statearr_19559_19573 = state_19545__$1;
(statearr_19559_19573[(1)] = (4));

(statearr_19559_19573[(5)] = null);

} else {
throw ex19553;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (10))){
var inst_19537 = (state_19545[(2)]);
var inst_19538 = fluree.db.util.async.throw_err(inst_19537);
var state_19545__$1 = state_19545;
var statearr_19560_19574 = state_19545__$1;
(statearr_19560_19574[(2)] = inst_19538);

(statearr_19560_19574[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19546 === (8))){
var inst_19531 = (state_19545[(7)]);
var inst_19535 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_19531,db,true);
var state_19545__$1 = state_19545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19545__$1,(10),inst_19535);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0 = (function (){
var statearr_19561 = [null,null,null,null,null,null,null,null];
(statearr_19561[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__);

(statearr_19561[(1)] = (1));

return statearr_19561;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1 = (function (state_19545){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_19545);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19562){var ex__2882__auto__ = e19562;
var statearr_19563_19575 = state_19545;
(statearr_19563_19575[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_19545[(4)]))){
var statearr_19564_19576 = state_19545;
(statearr_19564_19576[(1)] = cljs.core.first((state_19545[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19577 = state_19545;
state_19545 = G__19577;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__ = function(state_19545){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1.call(this,state_19545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19565 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_19565[(6)] = c__2901__auto__);

return statearr_19565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__19579 = arguments.length;
switch (G__19579) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__19581 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19581,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19581,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19581,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__19584_SHARP_,p2__19585_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19584_SHARP_,p2__19585_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19651){
var state_val_19652 = (state_19651[(1)]);
if((state_val_19652 === (1))){
var state_19651__$1 = state_19651;
var statearr_19653_19671 = state_19651__$1;
(statearr_19653_19671[(2)] = null);

(statearr_19653_19671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19652 === (2))){
var _ = (function (){var statearr_19654 = state_19651;
(statearr_19654[(4)] = cljs.core.cons((5),(state_19651[(4)])));

return statearr_19654;
})();
var inst_19603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19604 = fluree.db.flake.max_subject_id((1));
var inst_19605 = [inst_19604];
var inst_19606 = (new cljs.core.PersistentVector(null,1,(5),inst_19603,inst_19605,null));
var inst_19607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19608 = [(0)];
var inst_19609 = (new cljs.core.PersistentVector(null,1,(5),inst_19607,inst_19608,null));
var inst_19610 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_19606,cljs.core._LT__EQ_,inst_19609);
var state_19651__$1 = state_19651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19651__$1,(6),inst_19610);
} else {
if((state_val_19652 === (3))){
var inst_19649 = (state_19651[(2)]);
var state_19651__$1 = state_19651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19651__$1,inst_19649);
} else {
if((state_val_19652 === (4))){
var inst_19591 = (state_19651[(2)]);
var state_19651__$1 = state_19651;
var statearr_19656_19672 = state_19651__$1;
(statearr_19656_19672[(2)] = inst_19591);

(statearr_19656_19672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19652 === (5))){
var _ = (function (){var statearr_19657 = state_19651;
(statearr_19657[(4)] = cljs.core.rest((state_19651[(4)])));

return statearr_19657;
})();
var state_19651__$1 = state_19651;
var ex19655 = (state_19651__$1[(2)]);
var statearr_19658_19673 = state_19651__$1;
(statearr_19658_19673[(5)] = ex19655);


if((ex19655 instanceof Error)){
var statearr_19659_19674 = state_19651__$1;
(statearr_19659_19674[(1)] = (4));

(statearr_19659_19674[(5)] = null);

} else {
throw ex19655;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19652 === (6))){
var inst_19612 = (state_19651[(2)]);
var inst_19613 = fluree.db.util.async.throw_err(inst_19612);
var inst_19614 = (function (){var schema_flakes = inst_19613;
return (function (p1__19586_SHARP_){
return (p1__19586_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_19615 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19614,inst_19613);
var inst_19616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19615,(0),null);
var inst_19617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19615,(1),null);
var inst_19618 = (function (){var schema_flakes = inst_19613;
var vec__19597 = inst_19615;
var collection_flakes = inst_19616;
var predicate_flakes = inst_19617;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__19588_SHARP_,p2__19589_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19588_SHARP_,p2__19589_SHARP_.p,p2__19589_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_19619 = [(-1),"_tx"];
var inst_19620 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19621 = ["_tx",(-1),(-1)];
var inst_19622 = cljs.core.PersistentHashMap.fromArrays(inst_19620,inst_19621);
var inst_19623 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19624 = ["_tx",(-1),(-1)];
var inst_19625 = cljs.core.PersistentHashMap.fromArrays(inst_19623,inst_19624);
var inst_19626 = [inst_19622,inst_19625];
var inst_19627 = cljs.core.PersistentHashMap.fromArrays(inst_19619,inst_19626);
var inst_19628 = (function (){var schema_flakes = inst_19613;
var vec__19597 = inst_19615;
var collection_flakes = inst_19616;
var predicate_flakes = inst_19617;
return (function (p1__19587_SHARP_){
return p1__19587_SHARP_.s;
});
})();
var inst_19629 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19628,inst_19616);
var inst_19630 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19618,inst_19627,inst_19629);
var inst_19632 = (function (){var schema_flakes = inst_19613;
var vec__19597 = inst_19615;
var collection_flakes = inst_19616;
var predicate_flakes = inst_19617;
var coll = inst_19630;
return (function (p__19631,pred_flakes){
var vec__19660 = p__19631;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19660,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19660,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__19663 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__19663.cljs$core$IFn$_invoke$arity$1 ? fexpr__19663.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__19663.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_19633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19634 = cljs.core.PersistentHashMap.EMPTY;
var inst_19635 = cljs.core.PersistentHashSet.EMPTY;
var inst_19636 = [inst_19634,inst_19635];
var inst_19637 = (new cljs.core.PersistentVector(null,2,(5),inst_19633,inst_19636,null));
var inst_19638 = (function (){var schema_flakes = inst_19613;
var vec__19597 = inst_19615;
var collection_flakes = inst_19616;
var predicate_flakes = inst_19617;
var coll = inst_19630;
return (function (p1__19590_SHARP_){
return p1__19590_SHARP_.s;
});
})();
var inst_19639 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19638,inst_19617);
var inst_19640 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19632,inst_19637,inst_19639);
var inst_19641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19640,(0),null);
var inst_19642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19640,(1),null);
var inst_19643 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_19644 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_19645 = [inst_19644,inst_19630,inst_19641,inst_19642];
var inst_19646 = cljs.core.PersistentHashMap.fromArrays(inst_19643,inst_19645);
var _ = (function (){var statearr_19664 = state_19651;
(statearr_19664[(4)] = cljs.core.rest((state_19651[(4)])));

return statearr_19664;
})();
var state_19651__$1 = state_19651;
var statearr_19665_19675 = state_19651__$1;
(statearr_19665_19675[(2)] = inst_19646);

(statearr_19665_19675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0 = (function (){
var statearr_19666 = [null,null,null,null,null,null,null];
(statearr_19666[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2879__auto__);

(statearr_19666[(1)] = (1));

return statearr_19666;
});
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1 = (function (state_19651){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_19651);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19667){var ex__2882__auto__ = e19667;
var statearr_19668_19676 = state_19651;
(statearr_19668_19676[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_19651[(4)]))){
var statearr_19669_19677 = state_19651;
(statearr_19669_19677[(1)] = cljs.core.first((state_19651[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19678 = state_19651;
state_19651 = G__19678;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__ = function(state_19651){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1.call(this,state_19651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19670 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_19670[(6)] = c__2901__auto__);

return statearr_19670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19720){
var state_val_19721 = (state_19720[(1)]);
if((state_val_19721 === (7))){
var inst_19703 = (state_19720[(2)]);
var inst_19704 = fluree.db.query.schema.flake__GT_pred_map(inst_19703);
var inst_19705 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_19706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(114));
var inst_19707 = cljs.core.boolean$(inst_19706);
var inst_19708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(110));
var inst_19709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(117));
var inst_19710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_19709);
var inst_19711 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(111));
var inst_19712 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(115));
var inst_19713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19704,(112));
var inst_19714 = [inst_19707,inst_19708,inst_19710,inst_19711,inst_19712,inst_19713];
var inst_19715 = cljs.core.PersistentHashMap.fromArrays(inst_19705,inst_19714);
var _ = (function (){var statearr_19722 = state_19720;
(statearr_19722[(4)] = cljs.core.rest((state_19720[(4)])));

return statearr_19722;
})();
var state_19720__$1 = state_19720;
var statearr_19723_19746 = state_19720__$1;
(statearr_19723_19746[(2)] = inst_19715);

(statearr_19723_19746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (1))){
var state_19720__$1 = state_19720;
var statearr_19724_19747 = state_19720__$1;
(statearr_19724_19747[(2)] = null);

(statearr_19724_19747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (4))){
var inst_19679 = (state_19720[(2)]);
var state_19720__$1 = state_19720;
var statearr_19725_19748 = state_19720__$1;
(statearr_19725_19748[(2)] = inst_19679);

(statearr_19725_19748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (6))){
var _ = (function (){var statearr_19726 = state_19720;
(statearr_19726[(4)] = cljs.core.cons((9),(state_19720[(4)])));

return statearr_19726;
})();
var inst_19691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19693 = ["_setting/id","root"];
var inst_19694 = (new cljs.core.PersistentVector(null,2,(5),inst_19692,inst_19693,null));
var inst_19695 = [inst_19694];
var inst_19696 = (new cljs.core.PersistentVector(null,1,(5),inst_19691,inst_19695,null));
var inst_19697 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19696);
var state_19720__$1 = state_19720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19720__$1,(10),inst_19697);
} else {
if((state_val_19721 === (3))){
var inst_19718 = (state_19720[(2)]);
var state_19720__$1 = state_19720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19720__$1,inst_19718);
} else {
if((state_val_19721 === (2))){
var _ = (function (){var statearr_19729 = state_19720;
(statearr_19729[(4)] = cljs.core.cons((5),(state_19720[(4)])));

return statearr_19729;
})();
var state_19720__$1 = state_19720;
var statearr_19730_19749 = state_19720__$1;
(statearr_19730_19749[(2)] = null);

(statearr_19730_19749[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (9))){
var _ = (function (){var statearr_19731 = state_19720;
(statearr_19731[(4)] = cljs.core.rest((state_19720[(4)])));

return statearr_19731;
})();
var state_19720__$1 = state_19720;
var ex19727 = (state_19720__$1[(2)]);
var statearr_19732_19750 = state_19720__$1;
(statearr_19732_19750[(5)] = ex19727);


var statearr_19733_19751 = state_19720__$1;
(statearr_19733_19751[(1)] = (8));

(statearr_19733_19751[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (5))){
var _ = (function (){var statearr_19734 = state_19720;
(statearr_19734[(4)] = cljs.core.rest((state_19720[(4)])));

return statearr_19734;
})();
var state_19720__$1 = state_19720;
var ex19728 = (state_19720__$1[(2)]);
var statearr_19735_19752 = state_19720__$1;
(statearr_19735_19752[(5)] = ex19728);


if((ex19728 instanceof Error)){
var statearr_19736_19753 = state_19720__$1;
(statearr_19736_19753[(1)] = (4));

(statearr_19736_19753[(5)] = null);

} else {
throw ex19728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (10))){
var inst_19699 = (state_19720[(2)]);
var inst_19700 = fluree.db.util.async.throw_err(inst_19699);
var _ = (function (){var statearr_19737 = state_19720;
(statearr_19737[(4)] = cljs.core.rest((state_19720[(4)])));

return statearr_19737;
})();
var state_19720__$1 = state_19720;
var statearr_19738_19754 = state_19720__$1;
(statearr_19738_19754[(2)] = inst_19700);

(statearr_19738_19754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19721 === (8))){
var inst_19685 = (state_19720[(2)]);
var state_19720__$1 = (function (){var statearr_19739 = state_19720;
(statearr_19739[(7)] = inst_19685);

return statearr_19739;
})();
var statearr_19740_19755 = state_19720__$1;
(statearr_19740_19755[(2)] = null);

(statearr_19740_19755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0 = (function (){
var statearr_19741 = [null,null,null,null,null,null,null,null];
(statearr_19741[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2879__auto__);

(statearr_19741[(1)] = (1));

return statearr_19741;
});
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1 = (function (state_19720){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_19720);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19742){var ex__2882__auto__ = e19742;
var statearr_19743_19756 = state_19720;
(statearr_19743_19756[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_19720[(4)]))){
var statearr_19744_19757 = state_19720;
(statearr_19744_19757[(1)] = cljs.core.first((state_19720[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19758 = state_19720;
state_19720 = G__19758;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__ = function(state_19720){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1.call(this,state_19720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19745 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_19745[(6)] = c__2901__auto__);

return statearr_19745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
