// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26347 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26347,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26347,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26347,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26444){
var state_val_26445 = (state_26444[(1)]);
if((state_val_26445 === (7))){
var inst_26365 = (state_26444[(7)]);
var inst_26370 = inst_26365.cljs$lang$protocol_mask$partition0$;
var inst_26371 = (inst_26370 & (64));
var inst_26372 = inst_26365.cljs$core$ISeq$;
var inst_26373 = (cljs.core.PROTOCOL_SENTINEL === inst_26372);
var inst_26374 = ((inst_26371) || (inst_26373));
var state_26444__$1 = state_26444;
if(cljs.core.truth_(inst_26374)){
var statearr_26446_26492 = state_26444__$1;
(statearr_26446_26492[(1)] = (10));

} else {
var statearr_26447_26493 = state_26444__$1;
(statearr_26447_26493[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (20))){
var state_26444__$1 = state_26444;
var statearr_26448_26494 = state_26444__$1;
(statearr_26448_26494[(2)] = false);

(statearr_26448_26494[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (27))){
var inst_26364 = (state_26444[(8)]);
var inst_26390 = (state_26444[(9)]);
var inst_26387 = (state_26444[(10)]);
var inst_26428 = (state_26444[(2)]);
var inst_26429 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26387,inst_26364);
var inst_26430 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26431 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26430,cljs.core.empty);
var inst_26432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26433 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26434 = (new cljs.core.PersistentVector(null,2,(5),inst_26432,inst_26433,null));
var inst_26435 = cljs.core.assoc_in(db,inst_26434,inst_26429);
var inst_26436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26437 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26438 = (new cljs.core.PersistentVector(null,2,(5),inst_26436,inst_26437,null));
var inst_26439 = cljs.core.assoc_in(inst_26435,inst_26438,inst_26390);
var _ = (function (){var statearr_26449 = state_26444;
(statearr_26449[(4)] = cljs.core.rest((state_26444[(4)])));

return statearr_26449;
})();
var state_26444__$1 = (function (){var statearr_26450 = state_26444;
(statearr_26450[(11)] = inst_26428);

(statearr_26450[(12)] = inst_26431);

return statearr_26450;
})();
var statearr_26451_26495 = state_26444__$1;
(statearr_26451_26495[(2)] = inst_26439);

(statearr_26451_26495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (1))){
var state_26444__$1 = state_26444;
var statearr_26452_26496 = state_26444__$1;
(statearr_26452_26496[(2)] = null);

(statearr_26452_26496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (24))){
var inst_26390 = (state_26444[(9)]);
var inst_26415 = (state_26444[(2)]);
var inst_26416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26415,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26415,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26418 = (inst_26390 > inst_26417);
var state_26444__$1 = (function (){var statearr_26453 = state_26444;
(statearr_26453[(13)] = inst_26416);

return statearr_26453;
})();
if(cljs.core.truth_(inst_26418)){
var statearr_26454_26497 = state_26444__$1;
(statearr_26454_26497[(1)] = (25));

} else {
var statearr_26455_26498 = state_26444__$1;
(statearr_26455_26498[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (4))){
var inst_26350 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26456_26499 = state_26444__$1;
(statearr_26456_26499[(2)] = inst_26350);

(statearr_26456_26499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (15))){
var inst_26364 = (state_26444[(8)]);
var inst_26394 = (state_26444[(14)]);
var inst_26386 = (state_26444[(2)]);
var inst_26387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26386,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26386,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26389 = fluree.db.flake.size_bytes(inst_26364);
var inst_26390 = (inst_26388 + inst_26389);
var inst_26391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26392 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26393 = (new cljs.core.PersistentVector(null,2,(5),inst_26391,inst_26392,null));
var inst_26394__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26393);
var inst_26396 = (inst_26394__$1 == null);
var inst_26397 = cljs.core.not(inst_26396);
var state_26444__$1 = (function (){var statearr_26457 = state_26444;
(statearr_26457[(9)] = inst_26390);

(statearr_26457[(14)] = inst_26394__$1);

(statearr_26457[(10)] = inst_26387);

return statearr_26457;
})();
if(inst_26397){
var statearr_26458_26500 = state_26444__$1;
(statearr_26458_26500[(1)] = (16));

} else {
var statearr_26459_26501 = state_26444__$1;
(statearr_26459_26501[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (21))){
var inst_26407 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26460_26502 = state_26444__$1;
(statearr_26460_26502[(2)] = inst_26407);

(statearr_26460_26502[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (13))){
var inst_26365 = (state_26444[(7)]);
var inst_26383 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26365);
var state_26444__$1 = state_26444;
var statearr_26461_26503 = state_26444__$1;
(statearr_26461_26503[(2)] = inst_26383);

(statearr_26461_26503[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (22))){
var inst_26394 = (state_26444[(14)]);
var inst_26412 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26394);
var state_26444__$1 = state_26444;
var statearr_26462_26504 = state_26444__$1;
(statearr_26462_26504[(2)] = inst_26412);

(statearr_26462_26504[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (6))){
var inst_26365 = (state_26444[(7)]);
var inst_26363 = (state_26444[(2)]);
var inst_26364 = fluree.db.util.async.throw_err(inst_26363);
var inst_26365__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26367 = (inst_26365__$1 == null);
var inst_26368 = cljs.core.not(inst_26367);
var state_26444__$1 = (function (){var statearr_26463 = state_26444;
(statearr_26463[(8)] = inst_26364);

(statearr_26463[(7)] = inst_26365__$1);

return statearr_26463;
})();
if(inst_26368){
var statearr_26464_26505 = state_26444__$1;
(statearr_26464_26505[(1)] = (7));

} else {
var statearr_26465_26506 = state_26444__$1;
(statearr_26465_26506[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (25))){
var inst_26420 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26421 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26422 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26423 = cljs.core.PersistentHashMap.fromArrays(inst_26421,inst_26422);
var inst_26424 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26420,inst_26423);
var inst_26425 = (function(){throw inst_26424})();
var state_26444__$1 = state_26444;
var statearr_26466_26507 = state_26444__$1;
(statearr_26466_26507[(2)] = inst_26425);

(statearr_26466_26507[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (17))){
var state_26444__$1 = state_26444;
var statearr_26467_26508 = state_26444__$1;
(statearr_26467_26508[(2)] = false);

(statearr_26467_26508[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (3))){
var inst_26442 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26444__$1,inst_26442);
} else {
if((state_val_26445 === (12))){
var inst_26378 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
var statearr_26468_26509 = state_26444__$1;
(statearr_26468_26509[(2)] = inst_26378);

(statearr_26468_26509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (2))){
var _ = (function (){var statearr_26469 = state_26444;
(statearr_26469[(4)] = cljs.core.cons((5),(state_26444[(4)])));

return statearr_26469;
})();
var inst_26358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26359 = [pred_id];
var inst_26360 = (new cljs.core.PersistentVector(null,1,(5),inst_26358,inst_26359,null));
var inst_26361 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26360);
var state_26444__$1 = state_26444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26444__$1,(6),inst_26361);
} else {
if((state_val_26445 === (23))){
var inst_26394 = (state_26444[(14)]);
var state_26444__$1 = state_26444;
var statearr_26470_26510 = state_26444__$1;
(statearr_26470_26510[(2)] = inst_26394);

(statearr_26470_26510[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (19))){
var state_26444__$1 = state_26444;
var statearr_26471_26511 = state_26444__$1;
(statearr_26471_26511[(2)] = true);

(statearr_26471_26511[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (11))){
var state_26444__$1 = state_26444;
var statearr_26473_26512 = state_26444__$1;
(statearr_26473_26512[(2)] = false);

(statearr_26473_26512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (9))){
var inst_26381 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
if(cljs.core.truth_(inst_26381)){
var statearr_26474_26513 = state_26444__$1;
(statearr_26474_26513[(1)] = (13));

} else {
var statearr_26475_26514 = state_26444__$1;
(statearr_26475_26514[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (5))){
var _ = (function (){var statearr_26476 = state_26444;
(statearr_26476[(4)] = cljs.core.rest((state_26444[(4)])));

return statearr_26476;
})();
var state_26444__$1 = state_26444;
var ex26472 = (state_26444__$1[(2)]);
var statearr_26477_26515 = state_26444__$1;
(statearr_26477_26515[(5)] = ex26472);


if((ex26472 instanceof Error)){
var statearr_26478_26516 = state_26444__$1;
(statearr_26478_26516[(1)] = (4));

(statearr_26478_26516[(5)] = null);

} else {
throw ex26472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (14))){
var inst_26365 = (state_26444[(7)]);
var state_26444__$1 = state_26444;
var statearr_26479_26517 = state_26444__$1;
(statearr_26479_26517[(2)] = inst_26365);

(statearr_26479_26517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (26))){
var state_26444__$1 = state_26444;
var statearr_26480_26518 = state_26444__$1;
(statearr_26480_26518[(2)] = null);

(statearr_26480_26518[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (16))){
var inst_26394 = (state_26444[(14)]);
var inst_26399 = inst_26394.cljs$lang$protocol_mask$partition0$;
var inst_26400 = (inst_26399 & (64));
var inst_26401 = inst_26394.cljs$core$ISeq$;
var inst_26402 = (cljs.core.PROTOCOL_SENTINEL === inst_26401);
var inst_26403 = ((inst_26400) || (inst_26402));
var state_26444__$1 = state_26444;
if(cljs.core.truth_(inst_26403)){
var statearr_26481_26519 = state_26444__$1;
(statearr_26481_26519[(1)] = (19));

} else {
var statearr_26482_26520 = state_26444__$1;
(statearr_26482_26520[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (10))){
var state_26444__$1 = state_26444;
var statearr_26483_26521 = state_26444__$1;
(statearr_26483_26521[(2)] = true);

(statearr_26483_26521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (18))){
var inst_26410 = (state_26444[(2)]);
var state_26444__$1 = state_26444;
if(cljs.core.truth_(inst_26410)){
var statearr_26484_26522 = state_26444__$1;
(statearr_26484_26522[(1)] = (22));

} else {
var statearr_26485_26523 = state_26444__$1;
(statearr_26485_26523[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26445 === (8))){
var state_26444__$1 = state_26444;
var statearr_26486_26524 = state_26444__$1;
(statearr_26486_26524[(2)] = false);

(statearr_26486_26524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0 = (function (){
var statearr_26487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26487[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__);

(statearr_26487[(1)] = (1));

return statearr_26487;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1 = (function (state_26444){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_26444);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26488){var ex__2882__auto__ = e26488;
var statearr_26489_26525 = state_26444;
(statearr_26489_26525[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_26444[(4)]))){
var statearr_26490_26526 = state_26444;
(statearr_26490_26526[(1)] = cljs.core.first((state_26444[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26527 = state_26444;
state_26444 = G__26527;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__ = function(state_26444){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1.call(this,state_26444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26491 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_26491[(6)] = c__2901__auto__);

return statearr_26491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26726){
var state_val_26727 = (state_26726[(1)]);
if((state_val_26727 === (7))){
var state_26726__$1 = state_26726;
var statearr_26728_26795 = state_26726__$1;
(statearr_26728_26795[(2)] = null);

(statearr_26728_26795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (20))){
var inst_26652 = (state_26726[(7)]);
var inst_26619 = (state_26726[(8)]);
var inst_26651 = (state_26726[(9)]);
var inst_26569 = (state_26726[(10)]);
var inst_26648 = (state_26726[(11)]);
var inst_26650 = (state_26726[(12)]);
var inst_26568 = (state_26726[(13)]);
var inst_26649 = (state_26726[(14)]);
var inst_26662 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26664 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26665 = (new cljs.core.PersistentVector(null,2,(5),inst_26663,inst_26664,null));
var inst_26666 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26619,inst_26665);
var inst_26667 = (inst_26568 + inst_26666);
var inst_26668 = [inst_26648,inst_26649,inst_26650,inst_26651,inst_26667];
var inst_26669 = cljs.core.PersistentHashMap.fromArrays(inst_26662,inst_26668);
var inst_26670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26619,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26652,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26669], 0));
var state_26726__$1 = (function (){var statearr_26729 = state_26726;
(statearr_26729[(15)] = inst_26670);

return statearr_26729;
})();
if(cljs.core.truth_(inst_26569)){
var statearr_26730_26796 = state_26726__$1;
(statearr_26730_26796[(1)] = (23));

} else {
var statearr_26731_26797 = state_26726__$1;
(statearr_26731_26797[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (27))){
var inst_26670 = (state_26726[(15)]);
var state_26726__$1 = state_26726;
var statearr_26732_26798 = state_26726__$1;
(statearr_26732_26798[(2)] = inst_26670);

(statearr_26732_26798[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (1))){
var state_26726__$1 = state_26726;
var statearr_26733_26799 = state_26726__$1;
(statearr_26733_26799[(2)] = null);

(statearr_26733_26799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (24))){
var inst_26670 = (state_26726[(15)]);
var inst_26673 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26670);
var inst_26674 = (inst_26673 == null);
var state_26726__$1 = state_26726;
var statearr_26734_26800 = state_26726__$1;
(statearr_26734_26800[(2)] = inst_26674);

(statearr_26734_26800[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (39))){
var inst_26659 = (state_26726[(16)]);
var inst_26709 = (state_26726[(17)]);
var inst_26701 = (state_26726[(18)]);
var inst_26702 = (state_26726[(19)]);
var inst_26700 = (state_26726[(20)]);
var inst_26716 = (state_26726[(2)]);
var inst_26647 = inst_26659;
var inst_26648 = inst_26701;
var inst_26649 = inst_26702;
var inst_26650 = inst_26709;
var inst_26651 = inst_26716;
var inst_26652 = inst_26700;
var state_26726__$1 = (function (){var statearr_26735 = state_26726;
(statearr_26735[(7)] = inst_26652);

(statearr_26735[(21)] = inst_26647);

(statearr_26735[(9)] = inst_26651);

(statearr_26735[(11)] = inst_26648);

(statearr_26735[(12)] = inst_26650);

(statearr_26735[(14)] = inst_26649);

return statearr_26735;
})();
var statearr_26736_26801 = state_26726__$1;
(statearr_26736_26801[(2)] = null);

(statearr_26736_26801[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (4))){
var inst_26531 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
var statearr_26737_26802 = state_26726__$1;
(statearr_26737_26802[(2)] = inst_26531);

(statearr_26737_26802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (15))){
var inst_26591 = (state_26726[(22)]);
var state_26726__$1 = state_26726;
var statearr_26738_26803 = state_26726__$1;
(statearr_26738_26803[(2)] = inst_26591);

(statearr_26738_26803[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (21))){
var inst_26538 = (state_26726[(23)]);
var inst_26652 = (state_26726[(7)]);
var inst_26619 = (state_26726[(8)]);
var inst_26647 = (state_26726[(21)]);
var inst_26651 = (state_26726[(9)]);
var inst_26569 = (state_26726[(10)]);
var inst_26648 = (state_26726[(11)]);
var inst_26659 = (state_26726[(16)]);
var inst_26563 = (state_26726[(24)]);
var inst_26628 = (state_26726[(25)]);
var inst_26650 = (state_26726[(12)]);
var inst_26567 = (state_26726[(26)]);
var inst_26553 = (state_26726[(27)]);
var inst_26559 = (state_26726[(28)]);
var inst_26629 = (state_26726[(29)]);
var inst_26555 = (state_26726[(30)]);
var inst_26578 = (state_26726[(31)]);
var inst_26568 = (state_26726[(13)]);
var inst_26649 = (state_26726[(14)]);
var inst_26570 = (state_26726[(32)]);
var inst_26658 = (state_26726[(33)]);
var inst_26572 = (state_26726[(34)]);
var inst_26697 = inst_26658.s;
var inst_26698 = fluree.db.flake.sid__GT_cid(inst_26697);
var inst_26699 = (function (){var flakes_bytes = inst_26568;
var t = inst_26538;
var vec__26624 = inst_26555;
var spot = inst_26648;
var add_flakes = inst_26555;
var root_setting_change_QMARK_ = inst_26570;
var first__26626 = inst_26628;
var ref_QMARK__map = inst_26567;
var r = inst_26659;
var psot = inst_26649;
var add_pred_to_idx_QMARK_ = inst_26578;
var vec__26654 = inst_26647;
var _ = inst_26553;
var seq__26625 = inst_26629;
var cid = inst_26698;
var ecount = inst_26652;
var first__26656 = inst_26658;
var seq__26655 = inst_26659;
var pred_ecount = inst_26572;
var G__26623 = inst_26647;
var db_STAR_ = inst_26619;
var schema_change_QMARK_ = inst_26569;
var add_preds = inst_26559;
var opst = inst_26651;
var idx_QMARK__map = inst_26563;
var post = inst_26650;
var f = inst_26658;
return (function (p1__26530_SHARP_){
if(cljs.core.truth_(p1__26530_SHARP_)){
var x__4214__auto__ = p1__26530_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_26700 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26652,inst_26698,inst_26699);
var inst_26701 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26648,inst_26658);
var inst_26702 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26649,inst_26658);
var inst_26703 = inst_26658.p;
var inst_26704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26563,inst_26703);
var state_26726__$1 = (function (){var statearr_26739 = state_26726;
(statearr_26739[(18)] = inst_26701);

(statearr_26739[(19)] = inst_26702);

(statearr_26739[(20)] = inst_26700);

return statearr_26739;
})();
if(cljs.core.truth_(inst_26704)){
var statearr_26740_26804 = state_26726__$1;
(statearr_26740_26804[(1)] = (34));

} else {
var statearr_26741_26805 = state_26726__$1;
(statearr_26741_26805[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (31))){
var inst_26685 = (state_26726[(35)]);
var state_26726__$1 = state_26726;
var statearr_26742_26806 = state_26726__$1;
(statearr_26742_26806[(2)] = inst_26685);

(statearr_26742_26806[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (32))){
var inst_26695 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
var statearr_26743_26807 = state_26726__$1;
(statearr_26743_26807[(2)] = inst_26695);

(statearr_26743_26807[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (33))){
var inst_26685 = (state_26726[(35)]);
var inst_26690 = (state_26726[(2)]);
var inst_26691 = fluree.db.util.async.throw_err(inst_26690);
var inst_26692 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26685,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26691);
var state_26726__$1 = state_26726;
var statearr_26744_26808 = state_26726__$1;
(statearr_26744_26808[(2)] = inst_26692);

(statearr_26744_26808[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (13))){
var inst_26538 = (state_26726[(23)]);
var inst_26619 = (state_26726[(8)]);
var inst_26555 = (state_26726[(30)]);
var inst_26568 = (state_26726[(13)]);
var inst_26609 = (state_26726[(2)]);
var inst_26610 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26609,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26538);
var inst_26611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26612 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26613 = (new cljs.core.PersistentVector(null,2,(5),inst_26611,inst_26612,null));
var inst_26614 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26610,inst_26613,cljs.core._PLUS_,inst_26568);
var inst_26615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26616 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26617 = (new cljs.core.PersistentVector(null,2,(5),inst_26615,inst_26616,null));
var inst_26618 = cljs.core.count(inst_26555);
var inst_26619__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26614,inst_26617,cljs.core._PLUS_,inst_26618);
var inst_26627 = cljs.core.seq(inst_26555);
var inst_26628 = cljs.core.first(inst_26627);
var inst_26629 = cljs.core.next(inst_26627);
var inst_26630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26631 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26632 = (new cljs.core.PersistentVector(null,2,(5),inst_26630,inst_26631,null));
var inst_26633 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26619__$1,inst_26632);
var inst_26634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26635 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26636 = (new cljs.core.PersistentVector(null,2,(5),inst_26634,inst_26635,null));
var inst_26637 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26619__$1,inst_26636);
var inst_26638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26639 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26640 = (new cljs.core.PersistentVector(null,2,(5),inst_26638,inst_26639,null));
var inst_26641 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26619__$1,inst_26640);
var inst_26642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26643 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26644 = (new cljs.core.PersistentVector(null,2,(5),inst_26642,inst_26643,null));
var inst_26645 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26619__$1,inst_26644);
var inst_26646 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26647 = inst_26555;
var inst_26648 = inst_26633;
var inst_26649 = inst_26637;
var inst_26650 = inst_26641;
var inst_26651 = inst_26645;
var inst_26652 = inst_26646;
var state_26726__$1 = (function (){var statearr_26745 = state_26726;
(statearr_26745[(7)] = inst_26652);

(statearr_26745[(8)] = inst_26619__$1);

(statearr_26745[(21)] = inst_26647);

(statearr_26745[(9)] = inst_26651);

(statearr_26745[(11)] = inst_26648);

(statearr_26745[(25)] = inst_26628);

(statearr_26745[(12)] = inst_26650);

(statearr_26745[(29)] = inst_26629);

(statearr_26745[(14)] = inst_26649);

return statearr_26745;
})();
var statearr_26746_26809 = state_26726__$1;
(statearr_26746_26809[(2)] = null);

(statearr_26746_26809[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (22))){
var inst_26719 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
var statearr_26747_26810 = state_26726__$1;
(statearr_26747_26810[(2)] = inst_26719);

(statearr_26747_26810[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (36))){
var inst_26567 = (state_26726[(26)]);
var inst_26658 = (state_26726[(33)]);
var inst_26709 = (state_26726[(2)]);
var inst_26710 = inst_26658.p;
var inst_26711 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26567,inst_26710);
var state_26726__$1 = (function (){var statearr_26748 = state_26726;
(statearr_26748[(17)] = inst_26709);

return statearr_26748;
})();
if(cljs.core.truth_(inst_26711)){
var statearr_26749_26811 = state_26726__$1;
(statearr_26749_26811[(1)] = (37));

} else {
var statearr_26750_26812 = state_26726__$1;
(statearr_26750_26812[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (29))){
var inst_26670 = (state_26726[(15)]);
var inst_26680 = (state_26726[(2)]);
var inst_26681 = fluree.db.util.async.throw_err(inst_26680);
var inst_26682 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26670,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26681);
var state_26726__$1 = state_26726;
var statearr_26751_26813 = state_26726__$1;
(statearr_26751_26813[(2)] = inst_26682);

(statearr_26751_26813[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (6))){
var inst_26538 = (state_26726[(23)]);
var inst_26543 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26544 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26545 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26543)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26544)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26538),"."].join('');
var inst_26546 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26547 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26548 = cljs.core.PersistentHashMap.fromArrays(inst_26546,inst_26547);
var inst_26549 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26545,inst_26548);
var inst_26550 = (function(){throw inst_26549})();
var state_26726__$1 = state_26726;
var statearr_26752_26814 = state_26726__$1;
(statearr_26752_26814[(2)] = inst_26550);

(statearr_26752_26814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (28))){
var inst_26570 = (state_26726[(32)]);
var inst_26685 = (state_26726[(2)]);
var state_26726__$1 = (function (){var statearr_26753 = state_26726;
(statearr_26753[(35)] = inst_26685);

return statearr_26753;
})();
if(cljs.core.truth_(inst_26570)){
var statearr_26754_26815 = state_26726__$1;
(statearr_26754_26815[(1)] = (30));

} else {
var statearr_26755_26816 = state_26726__$1;
(statearr_26755_26816[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (25))){
var inst_26676 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
if(cljs.core.truth_(inst_26676)){
var statearr_26756_26817 = state_26726__$1;
(statearr_26756_26817[(1)] = (26));

} else {
var statearr_26757_26818 = state_26726__$1;
(statearr_26757_26818[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (34))){
var inst_26650 = (state_26726[(12)]);
var inst_26658 = (state_26726[(33)]);
var inst_26706 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26650,inst_26658);
var state_26726__$1 = state_26726;
var statearr_26758_26819 = state_26726__$1;
(statearr_26758_26819[(2)] = inst_26706);

(statearr_26758_26819[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (17))){
var inst_26598 = (state_26726[(36)]);
var inst_26602 = (state_26726[(2)]);
var inst_26603 = fluree.db.util.async.throw_err(inst_26602);
var inst_26590 = inst_26598;
var inst_26591 = inst_26603;
var state_26726__$1 = (function (){var statearr_26759 = state_26726;
(statearr_26759[(37)] = inst_26590);

(statearr_26759[(22)] = inst_26591);

return statearr_26759;
})();
var statearr_26760_26820 = state_26726__$1;
(statearr_26760_26820[(2)] = null);

(statearr_26760_26820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (3))){
var inst_26724 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26726__$1,inst_26724);
} else {
if((state_val_26727 === (12))){
var inst_26590 = (state_26726[(37)]);
var inst_26597 = (state_26726[(38)]);
var inst_26596 = cljs.core.seq(inst_26590);
var inst_26597__$1 = cljs.core.first(inst_26596);
var inst_26598 = cljs.core.next(inst_26596);
var state_26726__$1 = (function (){var statearr_26761 = state_26726;
(statearr_26761[(36)] = inst_26598);

(statearr_26761[(38)] = inst_26597__$1);

return statearr_26761;
})();
if(cljs.core.truth_(inst_26597__$1)){
var statearr_26762_26821 = state_26726__$1;
(statearr_26762_26821[(1)] = (14));

} else {
var statearr_26763_26822 = state_26726__$1;
(statearr_26763_26822[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (2))){
var inst_26538 = (state_26726[(23)]);
var _ = (function (){var statearr_26764 = state_26726;
(statearr_26764[(4)] = cljs.core.cons((5),(state_26726[(4)])));

return statearr_26764;
})();
var inst_26537 = cljs.core.first(flakes);
var inst_26538__$1 = inst_26537.t;
var inst_26539 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26540 = (inst_26539 - (1));
var inst_26541 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26538__$1,inst_26540);
var state_26726__$1 = (function (){var statearr_26765 = state_26726;
(statearr_26765[(23)] = inst_26538__$1);

return statearr_26765;
})();
if(inst_26541){
var statearr_26766_26823 = state_26726__$1;
(statearr_26766_26823[(1)] = (6));

} else {
var statearr_26767_26824 = state_26726__$1;
(statearr_26767_26824[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (23))){
var inst_26569 = (state_26726[(10)]);
var state_26726__$1 = state_26726;
var statearr_26768_26825 = state_26726__$1;
(statearr_26768_26825[(2)] = inst_26569);

(statearr_26768_26825[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (35))){
var inst_26650 = (state_26726[(12)]);
var state_26726__$1 = state_26726;
var statearr_26769_26826 = state_26726__$1;
(statearr_26769_26826[(2)] = inst_26650);

(statearr_26769_26826[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (19))){
var inst_26721 = (state_26726[(2)]);
var _ = (function (){var statearr_26770 = state_26726;
(statearr_26770[(4)] = cljs.core.rest((state_26726[(4)])));

return statearr_26770;
})();
var state_26726__$1 = state_26726;
var statearr_26771_26827 = state_26726__$1;
(statearr_26771_26827[(2)] = inst_26721);

(statearr_26771_26827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (11))){
var inst_26578 = (state_26726[(31)]);
var inst_26578__$1 = (state_26726[(2)]);
var inst_26586 = cljs.core.seq(inst_26578__$1);
var inst_26587 = cljs.core.first(inst_26586);
var inst_26588 = cljs.core.next(inst_26586);
var inst_26589 = db;
var inst_26590 = inst_26578__$1;
var inst_26591 = inst_26589;
var state_26726__$1 = (function (){var statearr_26773 = state_26726;
(statearr_26773[(39)] = inst_26588);

(statearr_26773[(40)] = inst_26587);

(statearr_26773[(37)] = inst_26590);

(statearr_26773[(22)] = inst_26591);

(statearr_26773[(31)] = inst_26578__$1);

return statearr_26773;
})();
var statearr_26774_26828 = state_26726__$1;
(statearr_26774_26828[(2)] = null);

(statearr_26774_26828[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (9))){
var inst_26555 = (state_26726[(30)]);
var inst_26572 = (state_26726[(34)]);
var inst_26574 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26555,inst_26572);
var state_26726__$1 = state_26726;
var statearr_26775_26829 = state_26726__$1;
(statearr_26775_26829[(2)] = inst_26574);

(statearr_26775_26829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (5))){
var _ = (function (){var statearr_26776 = state_26726;
(statearr_26776[(4)] = cljs.core.rest((state_26726[(4)])));

return statearr_26776;
})();
var state_26726__$1 = state_26726;
var ex26772 = (state_26726__$1[(2)]);
var statearr_26777_26830 = state_26726__$1;
(statearr_26777_26830[(5)] = ex26772);


if((ex26772 instanceof Error)){
var statearr_26778_26831 = state_26726__$1;
(statearr_26778_26831[(1)] = (4));

(statearr_26778_26831[(5)] = null);

} else {
throw ex26772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (14))){
var inst_26591 = (state_26726[(22)]);
var inst_26597 = (state_26726[(38)]);
var inst_26600 = fluree.db.graphdb.add_predicate_to_idx(inst_26591,inst_26597);
var state_26726__$1 = state_26726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26726__$1,(17),inst_26600);
} else {
if((state_val_26727 === (26))){
var inst_26670 = (state_26726[(15)]);
var inst_26678 = fluree.db.query.schema.schema_map(inst_26670);
var state_26726__$1 = state_26726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26726__$1,(29),inst_26678);
} else {
if((state_val_26727 === (16))){
var inst_26607 = (state_26726[(2)]);
var state_26726__$1 = state_26726;
var statearr_26779_26832 = state_26726__$1;
(statearr_26779_26832[(2)] = inst_26607);

(statearr_26779_26832[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (38))){
var inst_26651 = (state_26726[(9)]);
var state_26726__$1 = state_26726;
var statearr_26780_26833 = state_26726__$1;
(statearr_26780_26833[(2)] = inst_26651);

(statearr_26780_26833[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (30))){
var inst_26685 = (state_26726[(35)]);
var inst_26688 = fluree.db.query.schema.setting_map(inst_26685);
var state_26726__$1 = state_26726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26726__$1,(33),inst_26688);
} else {
if((state_val_26727 === (10))){
var inst_26576 = cljs.core.PersistentVector.EMPTY;
var state_26726__$1 = state_26726;
var statearr_26781_26834 = state_26726__$1;
(statearr_26781_26834[(2)] = inst_26576);

(statearr_26781_26834[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (18))){
var inst_26647 = (state_26726[(21)]);
var inst_26658 = (state_26726[(33)]);
var inst_26657 = cljs.core.seq(inst_26647);
var inst_26658__$1 = cljs.core.first(inst_26657);
var inst_26659 = cljs.core.next(inst_26657);
var inst_26660 = cljs.core.not(inst_26658__$1);
var state_26726__$1 = (function (){var statearr_26782 = state_26726;
(statearr_26782[(16)] = inst_26659);

(statearr_26782[(33)] = inst_26658__$1);

return statearr_26782;
})();
if(inst_26660){
var statearr_26783_26835 = state_26726__$1;
(statearr_26783_26835[(1)] = (20));

} else {
var statearr_26784_26836 = state_26726__$1;
(statearr_26784_26836[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (37))){
var inst_26651 = (state_26726[(9)]);
var inst_26658 = (state_26726[(33)]);
var inst_26713 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26651,inst_26658);
var state_26726__$1 = state_26726;
var statearr_26785_26837 = state_26726__$1;
(statearr_26785_26837[(2)] = inst_26713);

(statearr_26785_26837[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26727 === (8))){
var inst_26538 = (state_26726[(23)]);
var inst_26569 = (state_26726[(10)]);
var inst_26563 = (state_26726[(24)]);
var inst_26553 = (state_26726[(27)]);
var inst_26559 = (state_26726[(28)]);
var inst_26555 = (state_26726[(30)]);
var inst_26553__$1 = (state_26726[(2)]);
var inst_26554 = (function (){var t = inst_26538;
var _ = inst_26553__$1;
return (function (p1__26528_SHARP_){
return cljs.core.not((function (){var G__26786 = p1__26528_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26786) : fluree.db.graphdb.exclude_predicates.call(null,G__26786));
})());
});
})();
var inst_26555__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26554,flakes);
var inst_26556 = cljs.core.PersistentHashSet.EMPTY;
var inst_26557 = (function (){var t = inst_26538;
var _ = inst_26553__$1;
var add_flakes = inst_26555__$1;
return (function (p1__26529_SHARP_){
return p1__26529_SHARP_.p;
});
})();
var inst_26558 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26557,inst_26555__$1);
var inst_26559__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26556,inst_26558);
var inst_26560 = cljs.core.PersistentHashMap.EMPTY;
var inst_26561 = (function (){var t = inst_26538;
var _ = inst_26553__$1;
var add_flakes = inst_26555__$1;
var add_preds = inst_26559__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26562 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26561,inst_26559__$1);
var inst_26563__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26560,inst_26562);
var inst_26564 = cljs.core.PersistentHashMap.EMPTY;
var inst_26565 = (function (){var t = inst_26538;
var _ = inst_26553__$1;
var add_flakes = inst_26555__$1;
var add_preds = inst_26559__$1;
var idx_QMARK__map = inst_26563__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26566 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26565,inst_26559__$1);
var inst_26567 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26564,inst_26566);
var inst_26568 = fluree.db.flake.size_bytes(inst_26555__$1);
var inst_26569__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26555__$1);
var inst_26570 = fluree.db.util.schema.setting_change_QMARK_(inst_26555__$1);
var inst_26571 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26571,(0));
var state_26726__$1 = (function (){var statearr_26787 = state_26726;
(statearr_26787[(10)] = inst_26569__$1);

(statearr_26787[(24)] = inst_26563__$1);

(statearr_26787[(26)] = inst_26567);

(statearr_26787[(27)] = inst_26553__$1);

(statearr_26787[(28)] = inst_26559__$1);

(statearr_26787[(30)] = inst_26555__$1);

(statearr_26787[(13)] = inst_26568);

(statearr_26787[(32)] = inst_26570);

(statearr_26787[(34)] = inst_26572);

return statearr_26787;
})();
if(cljs.core.truth_(inst_26569__$1)){
var statearr_26788_26838 = state_26726__$1;
(statearr_26788_26838[(1)] = (9));

} else {
var statearr_26789_26839 = state_26726__$1;
(statearr_26789_26839[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2879__auto____0 = (function (){
var statearr_26790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26790[(0)] = fluree$db$graphdb$with_t_$_state_machine__2879__auto__);

(statearr_26790[(1)] = (1));

return statearr_26790;
});
var fluree$db$graphdb$with_t_$_state_machine__2879__auto____1 = (function (state_26726){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_26726);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26791){var ex__2882__auto__ = e26791;
var statearr_26792_26840 = state_26726;
(statearr_26792_26840[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_26726[(4)]))){
var statearr_26793_26841 = state_26726;
(statearr_26793_26841[(1)] = cljs.core.first((state_26726[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26842 = state_26726;
state_26726 = G__26842;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2879__auto__ = function(state_26726){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2879__auto____1.call(this,state_26726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2879__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2879__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26794 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_26794[(6)] = c__2901__auto__);

return statearr_26794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___26988 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26938){
var state_val_26939 = (state_26938[(1)]);
if((state_val_26939 === (7))){
var state_26938__$1 = state_26938;
var statearr_26940_26989 = state_26938__$1;
(statearr_26940_26989[(2)] = null);

(statearr_26940_26989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (20))){
var inst_26887 = (state_26938[(7)]);
var inst_26888 = (state_26938[(8)]);
var inst_26886 = (state_26938[(9)]);
var inst_26907 = (inst_26886 + (1));
var inst_26908 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26888,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26907);
var inst_26909 = fluree.db.graphdb.with_t(inst_26908,inst_26887);
var state_26938__$1 = state_26938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26938__$1,(23),inst_26909);
} else {
if((state_val_26939 === (1))){
var state_26938__$1 = state_26938;
var statearr_26941_26990 = state_26938__$1;
(statearr_26941_26990[(2)] = null);

(statearr_26941_26990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (24))){
var inst_26912 = (state_26938[(10)]);
var inst_26915 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26912,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26938__$1 = state_26938;
var statearr_26942_26991 = state_26938__$1;
(statearr_26942_26991[(2)] = inst_26915);

(statearr_26942_26991[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (4))){
var inst_26843 = (state_26938[(2)]);
var inst_26844 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26843);
var state_26938__$1 = state_26938;
var statearr_26943_26992 = state_26938__$1;
(statearr_26943_26992[(2)] = inst_26844);

(statearr_26943_26992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (15))){
var inst_26894 = (state_26938[(11)]);
var state_26938__$1 = state_26938;
var statearr_26944_26993 = state_26938__$1;
(statearr_26944_26993[(2)] = inst_26894);

(statearr_26944_26993[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (21))){
var state_26938__$1 = state_26938;
var statearr_26945_26994 = state_26938__$1;
(statearr_26945_26994[(2)] = null);

(statearr_26945_26994[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (13))){
var inst_26930 = (state_26938[(2)]);
var inst_26931 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26930);
var state_26938__$1 = state_26938;
var statearr_26946_26995 = state_26938__$1;
(statearr_26946_26995[(2)] = inst_26931);

(statearr_26946_26995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (22))){
var inst_26926 = (state_26938[(2)]);
var state_26938__$1 = state_26938;
var statearr_26947_26996 = state_26938__$1;
(statearr_26947_26996[(2)] = inst_26926);

(statearr_26947_26996[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (6))){
var inst_26854 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26855 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26856 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26854)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26855)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26857 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26858 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26859 = cljs.core.PersistentHashMap.fromArrays(inst_26857,inst_26858);
var inst_26860 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26856,inst_26859);
var inst_26861 = (function(){throw inst_26860})();
var state_26938__$1 = state_26938;
var statearr_26950_26997 = state_26938__$1;
(statearr_26950_26997[(2)] = inst_26861);

(statearr_26950_26997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (25))){
var inst_26912 = (state_26938[(10)]);
var inst_26895 = (state_26938[(12)]);
var inst_26894 = (state_26938[(11)]);
var inst_26917 = inst_26894.t;
var inst_26918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26919 = [inst_26894];
var inst_26920 = (new cljs.core.PersistentVector(null,1,(5),inst_26918,inst_26919,null));
var inst_26885 = inst_26895;
var inst_26886 = inst_26917;
var inst_26887 = inst_26920;
var inst_26888 = inst_26912;
var state_26938__$1 = (function (){var statearr_26951 = state_26938;
(statearr_26951[(7)] = inst_26887);

(statearr_26951[(8)] = inst_26888);

(statearr_26951[(13)] = inst_26885);

(statearr_26951[(9)] = inst_26886);

return statearr_26951;
})();
var statearr_26952_26998 = state_26938__$1;
(statearr_26952_26998[(2)] = null);

(statearr_26952_26998[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (17))){
var inst_26887 = (state_26938[(7)]);
var inst_26888 = (state_26938[(8)]);
var inst_26886 = (state_26938[(9)]);
var inst_26895 = (state_26938[(12)]);
var inst_26894 = (state_26938[(11)]);
var inst_26903 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26887,inst_26894);
var tmp26948 = inst_26888;
var tmp26949 = inst_26886;
var inst_26885 = inst_26895;
var inst_26886__$1 = tmp26949;
var inst_26887__$1 = inst_26903;
var inst_26888__$1 = tmp26948;
var state_26938__$1 = (function (){var statearr_26953 = state_26938;
(statearr_26953[(7)] = inst_26887__$1);

(statearr_26953[(8)] = inst_26888__$1);

(statearr_26953[(13)] = inst_26885);

(statearr_26953[(9)] = inst_26886__$1);

return statearr_26953;
})();
var statearr_26954_26999 = state_26938__$1;
(statearr_26954_26999[(2)] = null);

(statearr_26954_26999[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (3))){
var inst_26936 = (state_26938[(2)]);
var state_26938__$1 = state_26938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26938__$1,inst_26936);
} else {
if((state_val_26939 === (12))){
var inst_26885 = (state_26938[(13)]);
var inst_26894 = (state_26938[(11)]);
var inst_26893 = cljs.core.seq(inst_26885);
var inst_26894__$1 = cljs.core.first(inst_26893);
var inst_26895 = cljs.core.next(inst_26893);
var state_26938__$1 = (function (){var statearr_26955 = state_26938;
(statearr_26955[(12)] = inst_26895);

(statearr_26955[(11)] = inst_26894__$1);

return statearr_26955;
})();
if(cljs.core.truth_(inst_26894__$1)){
var statearr_26956_27000 = state_26938__$1;
(statearr_26956_27000[(1)] = (14));

} else {
var statearr_26957_27001 = state_26938__$1;
(statearr_26957_27001[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (2))){
var _ = (function (){var statearr_26958 = state_26938;
(statearr_26958[(4)] = cljs.core.cons((5),(state_26938[(4)])));

return statearr_26958;
})();
var inst_26850 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26851 = (inst_26850 + (1));
var inst_26852 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26851);
var state_26938__$1 = state_26938;
if(inst_26852){
var statearr_26959_27002 = state_26938__$1;
(statearr_26959_27002[(1)] = (6));

} else {
var statearr_26960_27003 = state_26938__$1;
(statearr_26960_27003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (23))){
var inst_26894 = (state_26938[(11)]);
var inst_26911 = (state_26938[(2)]);
var inst_26912 = fluree.db.util.async.throw_err(inst_26911);
var inst_26913 = (inst_26894 == null);
var state_26938__$1 = (function (){var statearr_26961 = state_26938;
(statearr_26961[(10)] = inst_26912);

return statearr_26961;
})();
if(cljs.core.truth_(inst_26913)){
var statearr_26962_27004 = state_26938__$1;
(statearr_26962_27004[(1)] = (24));

} else {
var statearr_26963_27005 = state_26938__$1;
(statearr_26963_27005[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (19))){
var inst_26928 = (state_26938[(2)]);
var state_26938__$1 = state_26938;
var statearr_26964_27006 = state_26938__$1;
(statearr_26964_27006[(2)] = inst_26928);

(statearr_26964_27006[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (11))){
var inst_26933 = (state_26938[(2)]);
var _ = (function (){var statearr_26966 = state_26938;
(statearr_26966[(4)] = cljs.core.rest((state_26938[(4)])));

return statearr_26966;
})();
var state_26938__$1 = state_26938;
var statearr_26967_27007 = state_26938__$1;
(statearr_26967_27007[(2)] = inst_26933);

(statearr_26967_27007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (9))){
var inst_26867 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26868 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26867);
var state_26938__$1 = state_26938;
var statearr_26968_27008 = state_26938__$1;
(statearr_26968_27008[(2)] = inst_26868);

(statearr_26968_27008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (5))){
var _ = (function (){var statearr_26969 = state_26938;
(statearr_26969[(4)] = cljs.core.rest((state_26938[(4)])));

return statearr_26969;
})();
var state_26938__$1 = state_26938;
var ex26965 = (state_26938__$1[(2)]);
var statearr_26970_27009 = state_26938__$1;
(statearr_26970_27009[(5)] = ex26965);


var statearr_26971_27010 = state_26938__$1;
(statearr_26971_27010[(1)] = (4));

(statearr_26971_27010[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (14))){
var inst_26886 = (state_26938[(9)]);
var inst_26894 = (state_26938[(11)]);
var inst_26897 = inst_26894.t;
var inst_26898 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26886,inst_26897);
var state_26938__$1 = state_26938;
var statearr_26972_27011 = state_26938__$1;
(statearr_26972_27011[(2)] = inst_26898);

(statearr_26972_27011[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (26))){
var inst_26923 = (state_26938[(2)]);
var state_26938__$1 = state_26938;
var statearr_26973_27012 = state_26938__$1;
(statearr_26973_27012[(2)] = inst_26923);

(statearr_26973_27012[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (16))){
var inst_26901 = (state_26938[(2)]);
var state_26938__$1 = state_26938;
if(cljs.core.truth_(inst_26901)){
var statearr_26974_27013 = state_26938__$1;
(statearr_26974_27013[(1)] = (17));

} else {
var statearr_26975_27014 = state_26938__$1;
(statearr_26975_27014[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (10))){
var inst_26870 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26878 = cljs.core.seq(inst_26870);
var inst_26879 = cljs.core.first(inst_26878);
var inst_26880 = cljs.core.next(inst_26878);
var inst_26881 = cljs.core.first(inst_26870);
var inst_26882 = inst_26881.t;
var inst_26883 = cljs.core.PersistentVector.EMPTY;
var inst_26884 = db;
var inst_26885 = inst_26870;
var inst_26886 = inst_26882;
var inst_26887 = inst_26883;
var inst_26888 = inst_26884;
var state_26938__$1 = (function (){var statearr_26976 = state_26938;
(statearr_26976[(7)] = inst_26887);

(statearr_26976[(8)] = inst_26888);

(statearr_26976[(13)] = inst_26885);

(statearr_26976[(9)] = inst_26886);

(statearr_26976[(14)] = inst_26879);

(statearr_26976[(15)] = inst_26880);

return statearr_26976;
})();
var statearr_26977_27015 = state_26938__$1;
(statearr_26977_27015[(2)] = null);

(statearr_26977_27015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (18))){
var state_26938__$1 = state_26938;
var statearr_26978_27016 = state_26938__$1;
(statearr_26978_27016[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26939 === (8))){
var inst_26864 = (state_26938[(2)]);
var inst_26865 = cljs.core.empty_QMARK_(flakes);
var state_26938__$1 = (function (){var statearr_26980 = state_26938;
(statearr_26980[(16)] = inst_26864);

return statearr_26980;
})();
if(inst_26865){
var statearr_26981_27017 = state_26938__$1;
(statearr_26981_27017[(1)] = (9));

} else {
var statearr_26982_27018 = state_26938__$1;
(statearr_26982_27018[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2879__auto____0 = (function (){
var statearr_26983 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26983[(0)] = fluree$db$graphdb$with_$_state_machine__2879__auto__);

(statearr_26983[(1)] = (1));

return statearr_26983;
});
var fluree$db$graphdb$with_$_state_machine__2879__auto____1 = (function (state_26938){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_26938);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26984){var ex__2882__auto__ = e26984;
var statearr_26985_27019 = state_26938;
(statearr_26985_27019[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_26938[(4)]))){
var statearr_26986_27020 = state_26938;
(statearr_26986_27020[(1)] = cljs.core.first((state_26938[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27021 = state_26938;
state_26938 = G__27021;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2879__auto__ = function(state_26938){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2879__auto____1.call(this,state_26938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2879__auto____0;
fluree$db$graphdb$with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2879__auto____1;
return fluree$db$graphdb$with_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26987 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_26987[(6)] = c__2901__auto___26988);

return statearr_26987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27077){
var state_val_27078 = (state_27077[(1)]);
if((state_val_27078 === (7))){
var state_27077__$1 = state_27077;
var statearr_27079_27106 = state_27077__$1;
(statearr_27079_27106[(2)] = tt_id);

(statearr_27079_27106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (1))){
var state_27077__$1 = state_27077;
var statearr_27080_27107 = state_27077__$1;
(statearr_27080_27107[(2)] = null);

(statearr_27080_27107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (4))){
var inst_27022 = (state_27077[(2)]);
var state_27077__$1 = state_27077;
var statearr_27081_27108 = state_27077__$1;
(statearr_27081_27108[(2)] = inst_27022);

(statearr_27081_27108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (13))){
var inst_27070 = (state_27077[(2)]);
var state_27077__$1 = state_27077;
var statearr_27082_27109 = state_27077__$1;
(statearr_27082_27109[(2)] = inst_27070);

(statearr_27082_27109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (6))){
var inst_27030 = fluree.db.util.core.random_uuid();
var state_27077__$1 = state_27077;
var statearr_27083_27110 = state_27077__$1;
(statearr_27083_27110[(2)] = inst_27030);

(statearr_27083_27110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (3))){
var inst_27075 = (state_27077[(2)]);
var state_27077__$1 = state_27077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27077__$1,inst_27075);
} else {
if((state_val_27078 === (12))){
var inst_27053 = (state_27077[(7)]);
var state_27077__$1 = state_27077;
var statearr_27084_27111 = state_27077__$1;
(statearr_27084_27111[(2)] = inst_27053);

(statearr_27084_27111[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (2))){
var _ = (function (){var statearr_27085 = state_27077;
(statearr_27085[(4)] = cljs.core.cons((5),(state_27077[(4)])));

return statearr_27085;
})();
var inst_27028 = (tt_id == null);
var state_27077__$1 = state_27077;
if(cljs.core.truth_(inst_27028)){
var statearr_27086_27112 = state_27077__$1;
(statearr_27086_27112[(1)] = (6));

} else {
var statearr_27087_27113 = state_27077__$1;
(statearr_27087_27113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (11))){
var inst_27060 = (state_27077[(8)]);
var inst_27053 = (state_27077[(7)]);
var inst_27063 = fluree.db.graphdb.with_t(inst_27053,inst_27060);
var state_27077__$1 = state_27077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27077__$1,(14),inst_27063);
} else {
if((state_val_27078 === (9))){
var inst_27060 = (state_27077[(8)]);
var inst_27054 = (state_27077[(9)]);
var inst_27059 = cljs.core.seq(inst_27054);
var inst_27060__$1 = cljs.core.first(inst_27059);
var inst_27061 = cljs.core.next(inst_27059);
var state_27077__$1 = (function (){var statearr_27089 = state_27077;
(statearr_27089[(10)] = inst_27061);

(statearr_27089[(8)] = inst_27060__$1);

return statearr_27089;
})();
if(cljs.core.truth_(inst_27060__$1)){
var statearr_27090_27114 = state_27077__$1;
(statearr_27090_27114[(1)] = (11));

} else {
var statearr_27091_27115 = state_27077__$1;
(statearr_27091_27115[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (5))){
var _ = (function (){var statearr_27092 = state_27077;
(statearr_27092[(4)] = cljs.core.rest((state_27077[(4)])));

return statearr_27092;
})();
var state_27077__$1 = state_27077;
var ex27088 = (state_27077__$1[(2)]);
var statearr_27093_27116 = state_27077__$1;
(statearr_27093_27116[(5)] = ex27088);


if((ex27088 instanceof Error)){
var statearr_27094_27117 = state_27077__$1;
(statearr_27094_27117[(1)] = (4));

(statearr_27094_27117[(5)] = null);

} else {
throw ex27088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (14))){
var inst_27061 = (state_27077[(10)]);
var inst_27065 = (state_27077[(2)]);
var inst_27066 = fluree.db.util.async.throw_err(inst_27065);
var inst_27053 = inst_27066;
var inst_27054 = inst_27061;
var state_27077__$1 = (function (){var statearr_27095 = state_27077;
(statearr_27095[(7)] = inst_27053);

(statearr_27095[(9)] = inst_27054);

return statearr_27095;
})();
var statearr_27096_27118 = state_27077__$1;
(statearr_27096_27118[(2)] = null);

(statearr_27096_27118[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (10))){
var inst_27072 = (state_27077[(2)]);
var _ = (function (){var statearr_27097 = state_27077;
(statearr_27097[(4)] = cljs.core.rest((state_27077[(4)])));

return statearr_27097;
})();
var state_27077__$1 = state_27077;
var statearr_27098_27119 = state_27077__$1;
(statearr_27098_27119[(2)] = inst_27072);

(statearr_27098_27119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27078 === (8))){
var inst_27033 = (state_27077[(2)]);
var inst_27034 = (function (){var tt_id_SINGLEQUOTE_ = inst_27033;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27035 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27033);
var inst_27036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27037 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27038 = (new cljs.core.PersistentVector(null,4,(5),inst_27036,inst_27037,null));
var inst_27039 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27034,inst_27035,inst_27038);
var inst_27040 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27041 = cljs.core.reverse(inst_27040);
var inst_27042 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_27041);
var inst_27050 = cljs.core.seq(inst_27042);
var inst_27051 = cljs.core.first(inst_27050);
var inst_27052 = cljs.core.next(inst_27050);
var inst_27053 = inst_27039;
var inst_27054 = inst_27042;
var state_27077__$1 = (function (){var statearr_27099 = state_27077;
(statearr_27099[(11)] = inst_27052);

(statearr_27099[(7)] = inst_27053);

(statearr_27099[(12)] = inst_27051);

(statearr_27099[(9)] = inst_27054);

return statearr_27099;
})();
var statearr_27100_27120 = state_27077__$1;
(statearr_27100_27120[(2)] = null);

(statearr_27100_27120[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0 = (function (){
var statearr_27101 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27101[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__);

(statearr_27101[(1)] = (1));

return statearr_27101;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1 = (function (state_27077){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27077);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27102){var ex__2882__auto__ = e27102;
var statearr_27103_27121 = state_27077;
(statearr_27103_27121[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27077[(4)]))){
var statearr_27104_27122 = state_27077;
(statearr_27104_27122[(1)] = cljs.core.first((state_27077[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27123 = state_27077;
state_27077 = G__27123;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__ = function(state_27077){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1.call(this,state_27077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27105 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27105[(6)] = c__2901__auto__);

return statearr_27105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___27301 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27238){
var state_val_27239 = (state_27238[(1)]);
if((state_val_27239 === (7))){
var inst_27151 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_27152 = cljs.core.first(ident);
var inst_27153 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27152);
var inst_27154 = (inst_27153 == null);
var inst_27155 = ((inst_27151) && (inst_27154));
var state_27238__$1 = state_27238;
if(cljs.core.truth_(inst_27155)){
var statearr_27240_27302 = state_27238__$1;
(statearr_27240_27302[(1)] = (13));

} else {
var statearr_27241_27303 = state_27238__$1;
(statearr_27241_27303[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (20))){
var state_27238__$1 = state_27238;
var statearr_27242_27304 = state_27238__$1;
(statearr_27242_27304[(2)] = null);

(statearr_27242_27304[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (27))){
var state_27238__$1 = state_27238;
var statearr_27243_27305 = state_27238__$1;
(statearr_27243_27305[(2)] = null);

(statearr_27243_27305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (1))){
var state_27238__$1 = state_27238;
var statearr_27244_27306 = state_27238__$1;
(statearr_27244_27306[(2)] = null);

(statearr_27244_27306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (24))){
var inst_27184 = (state_27238[(7)]);
var inst_27188 = inst_27184.s;
var state_27238__$1 = state_27238;
var statearr_27245_27307 = state_27238__$1;
(statearr_27245_27307[(2)] = inst_27188);

(statearr_27245_27307[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (39))){
var state_27238__$1 = state_27238;
var statearr_27246_27308 = state_27238__$1;
(statearr_27246_27308[(2)] = null);

(statearr_27246_27308[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (4))){
var inst_27124 = (state_27238[(2)]);
var inst_27125 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27126 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27127 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27128 = cljs.core.PersistentHashMap.fromArrays(inst_27126,inst_27127);
var inst_27129 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27125,inst_27128,inst_27124);
var inst_27130 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27129);
var state_27238__$1 = state_27238;
var statearr_27247_27309 = state_27238__$1;
(statearr_27247_27309[(2)] = inst_27130);

(statearr_27247_27309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (15))){
var inst_27206 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27248_27310 = state_27238__$1;
(statearr_27248_27310[(2)] = inst_27206);

(statearr_27248_27310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (21))){
var inst_27178 = (state_27238[(8)]);
var inst_27182 = cljs.core.first(inst_27178);
var state_27238__$1 = state_27238;
var statearr_27249_27311 = state_27238__$1;
(statearr_27249_27311[(2)] = inst_27182);

(statearr_27249_27311[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (31))){
var inst_27233 = (state_27238[(2)]);
var _ = (function (){var statearr_27250 = state_27238;
(statearr_27250[(4)] = cljs.core.rest((state_27238[(4)])));

return statearr_27250;
})();
var state_27238__$1 = state_27238;
var statearr_27251_27312 = state_27238__$1;
(statearr_27251_27312[(2)] = inst_27233);

(statearr_27251_27312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (32))){
var state_27238__$1 = state_27238;
var statearr_27252_27313 = state_27238__$1;
(statearr_27252_27313[(2)] = strict_QMARK_);

(statearr_27252_27313[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (40))){
var inst_27229 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27253_27314 = state_27238__$1;
(statearr_27253_27314[(2)] = inst_27229);

(statearr_27253_27314[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (33))){
var state_27238__$1 = state_27238;
var statearr_27254_27315 = state_27238__$1;
(statearr_27254_27315[(2)] = false);

(statearr_27254_27315[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (13))){
var inst_27157 = cljs.core.first(ident);
var inst_27158 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27157], 0));
var inst_27159 = ["Subject ID lookup failed. The predicate ",inst_27158," does not exist."].join('');
var inst_27160 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27161 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27162 = cljs.core.PersistentHashMap.fromArrays(inst_27160,inst_27161);
var inst_27163 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27159,inst_27162);
var inst_27164 = (function(){throw inst_27163})();
var state_27238__$1 = state_27238;
var statearr_27255_27316 = state_27238__$1;
(statearr_27255_27316[(2)] = inst_27164);

(statearr_27255_27316[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (22))){
var inst_27184 = (state_27238[(7)]);
var inst_27184__$1 = (state_27238[(2)]);
var inst_27185 = (inst_27184__$1 == null);
var state_27238__$1 = (function (){var statearr_27256 = state_27238;
(statearr_27256[(7)] = inst_27184__$1);

return statearr_27256;
})();
if(cljs.core.truth_(inst_27185)){
var statearr_27257_27317 = state_27238__$1;
(statearr_27257_27317[(1)] = (23));

} else {
var statearr_27258_27318 = state_27238__$1;
(statearr_27258_27318[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (36))){
var state_27238__$1 = state_27238;
var statearr_27259_27319 = state_27238__$1;
(statearr_27259_27319[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (29))){
var inst_27208 = (state_27238[(9)]);
var inst_27210 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27208);
var state_27238__$1 = state_27238;
var statearr_27261_27320 = state_27238__$1;
(statearr_27261_27320[(2)] = inst_27210);

(statearr_27261_27320[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (6))){
var inst_27138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27139 = [ident];
var inst_27140 = (new cljs.core.PersistentVector(null,1,(5),inst_27138,inst_27139,null));
var inst_27141 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27140);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27238__$1,(9),inst_27141);
} else {
if((state_val_27239 === (28))){
var inst_27202 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27262_27321 = state_27238__$1;
(statearr_27262_27321[(2)] = inst_27202);

(statearr_27262_27321[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (25))){
var inst_27190 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27263_27322 = state_27238__$1;
(statearr_27263_27322[(2)] = inst_27190);

(statearr_27263_27322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (34))){
var inst_27216 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
if(cljs.core.truth_(inst_27216)){
var statearr_27264_27323 = state_27238__$1;
(statearr_27264_27323[(1)] = (35));

} else {
var statearr_27265_27324 = state_27238__$1;
(statearr_27265_27324[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (17))){
var state_27238__$1 = state_27238;
var statearr_27266_27325 = state_27238__$1;
(statearr_27266_27325[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (3))){
var inst_27236 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27238__$1,inst_27236);
} else {
if((state_val_27239 === (12))){
var inst_27149 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27268_27326 = state_27238__$1;
(statearr_27268_27326[(2)] = inst_27149);

(statearr_27268_27326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (2))){
var _ = (function (){var statearr_27269 = state_27238;
(statearr_27269[(4)] = cljs.core.cons((5),(state_27238[(4)])));

return statearr_27269;
})();
var inst_27136 = typeof ident === 'number';
var state_27238__$1 = state_27238;
if(cljs.core.truth_(inst_27136)){
var statearr_27270_27327 = state_27238__$1;
(statearr_27270_27327[(1)] = (6));

} else {
var statearr_27271_27328 = state_27238__$1;
(statearr_27271_27328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (23))){
var state_27238__$1 = state_27238;
var statearr_27272_27329 = state_27238__$1;
(statearr_27272_27329[(2)] = null);

(statearr_27272_27329[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (35))){
var inst_27218 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27219 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27220 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27221 = cljs.core.PersistentHashMap.fromArrays(inst_27219,inst_27220);
var inst_27222 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27218,inst_27221);
var inst_27223 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27222);
var state_27238__$1 = state_27238;
var statearr_27273_27330 = state_27238__$1;
(statearr_27273_27330[(2)] = inst_27223);

(statearr_27273_27330[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (19))){
var inst_27178 = (state_27238[(8)]);
var inst_27177 = (state_27238[(2)]);
var inst_27178__$1 = fluree.db.util.async.throw_err(inst_27177);
var inst_27179 = (inst_27178__$1 == null);
var state_27238__$1 = (function (){var statearr_27274 = state_27238;
(statearr_27274[(8)] = inst_27178__$1);

return statearr_27274;
})();
if(cljs.core.truth_(inst_27179)){
var statearr_27275_27331 = state_27238__$1;
(statearr_27275_27331[(1)] = (20));

} else {
var statearr_27276_27332 = state_27238__$1;
(statearr_27276_27332[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (11))){
var state_27238__$1 = state_27238;
var statearr_27278_27333 = state_27238__$1;
(statearr_27278_27333[(2)] = null);

(statearr_27278_27333[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (9))){
var inst_27143 = (state_27238[(2)]);
var inst_27144 = fluree.db.util.async.throw_err(inst_27143);
var inst_27145 = cljs.core.not_empty(inst_27144);
var state_27238__$1 = state_27238;
if(cljs.core.truth_(inst_27145)){
var statearr_27279_27334 = state_27238__$1;
(statearr_27279_27334[(1)] = (10));

} else {
var statearr_27280_27335 = state_27238__$1;
(statearr_27280_27335[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (5))){
var _ = (function (){var statearr_27281 = state_27238;
(statearr_27281[(4)] = cljs.core.rest((state_27238[(4)])));

return statearr_27281;
})();
var state_27238__$1 = state_27238;
var ex27277 = (state_27238__$1[(2)]);
var statearr_27282_27336 = state_27238__$1;
(statearr_27282_27336[(5)] = ex27277);


var statearr_27283_27337 = state_27238__$1;
(statearr_27283_27337[(1)] = (4));

(statearr_27283_27337[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (14))){
var inst_27166 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27238__$1 = state_27238;
if(inst_27166){
var statearr_27284_27338 = state_27238__$1;
(statearr_27284_27338[(1)] = (16));

} else {
var statearr_27285_27339 = state_27238__$1;
(statearr_27285_27339[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (26))){
var inst_27193 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27194 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27193].join('');
var inst_27195 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27196 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27197 = cljs.core.PersistentHashMap.fromArrays(inst_27195,inst_27196);
var inst_27198 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27194,inst_27197);
var inst_27199 = (function(){throw inst_27198})();
var state_27238__$1 = state_27238;
var statearr_27286_27340 = state_27238__$1;
(statearr_27286_27340[(2)] = inst_27199);

(statearr_27286_27340[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (16))){
var inst_27169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27170 = cljs.core.first(ident);
var inst_27171 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27170);
var inst_27172 = cljs.core.second(ident);
var inst_27173 = [inst_27171,inst_27172];
var inst_27174 = (new cljs.core.PersistentVector(null,2,(5),inst_27169,inst_27173,null));
var inst_27175 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27174);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27238__$1,(19),inst_27175);
} else {
if((state_val_27239 === (38))){
var inst_27226 = cljs.core.async.close_BANG_(return_chan);
var state_27238__$1 = state_27238;
var statearr_27287_27341 = state_27238__$1;
(statearr_27287_27341[(2)] = inst_27226);

(statearr_27287_27341[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (30))){
var inst_27208 = (state_27238[(9)]);
var inst_27212 = (inst_27208 == null);
var state_27238__$1 = state_27238;
if(cljs.core.truth_(inst_27212)){
var statearr_27288_27342 = state_27238__$1;
(statearr_27288_27342[(1)] = (32));

} else {
var statearr_27289_27343 = state_27238__$1;
(statearr_27289_27343[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (10))){
var state_27238__$1 = state_27238;
var statearr_27290_27344 = state_27238__$1;
(statearr_27290_27344[(2)] = ident);

(statearr_27290_27344[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (18))){
var inst_27204 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27291_27345 = state_27238__$1;
(statearr_27291_27345[(2)] = inst_27204);

(statearr_27291_27345[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (37))){
var inst_27231 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27292_27346 = state_27238__$1;
(statearr_27292_27346[(2)] = inst_27231);

(statearr_27292_27346[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (8))){
var inst_27208 = (state_27238[(9)]);
var inst_27208__$1 = (state_27238[(2)]);
var state_27238__$1 = (function (){var statearr_27293 = state_27238;
(statearr_27293[(9)] = inst_27208__$1);

return statearr_27293;
})();
if(cljs.core.truth_(inst_27208__$1)){
var statearr_27294_27347 = state_27238__$1;
(statearr_27294_27347[(1)] = (29));

} else {
var statearr_27295_27348 = state_27238__$1;
(statearr_27295_27348[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2879__auto____0 = (function (){
var statearr_27296 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27296[(0)] = fluree$db$graphdb$subid_$_state_machine__2879__auto__);

(statearr_27296[(1)] = (1));

return statearr_27296;
});
var fluree$db$graphdb$subid_$_state_machine__2879__auto____1 = (function (state_27238){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27238);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27297){var ex__2882__auto__ = e27297;
var statearr_27298_27349 = state_27238;
(statearr_27298_27349[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27238[(4)]))){
var statearr_27299_27350 = state_27238;
(statearr_27299_27350[(1)] = cljs.core.first((state_27238[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27351 = state_27238;
state_27238 = G__27351;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2879__auto__ = function(state_27238){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2879__auto____1.call(this,state_27238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2879__auto____0;
fluree$db$graphdb$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2879__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27300 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27300[(6)] = c__2901__auto___27301);

return statearr_27300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27353,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27357 = k27353;
var G__27357__$1 = (((G__27357 instanceof cljs.core.Keyword))?G__27357.fqn:null);
switch (G__27357__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27353,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27358){
var vec__27359 = p__27358;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27359,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27359,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27352){
var self__ = this;
var G__27352__$1 = this;
return (new cljs.core.RecordIter((0),G__27352__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__27362 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__27362(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27354,other27355){
var self__ = this;
var this27354__$1 = this;
return (((!((other27355 == null)))) && ((this27354__$1.constructor === other27355.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.conn,other27355.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.network,other27355.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.dbid,other27355.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.block,other27355.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.t,other27355.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.tt_id,other27355.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.stats,other27355.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.spot,other27355.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.psot,other27355.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.post,other27355.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.opst,other27355.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.schema,other27355.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.settings,other27355.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.index_configs,other27355.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.schema_cache,other27355.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.novelty,other27355.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.permissions,other27355.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.fork,other27355.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.fork_block,other27355.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.current_db_fn,other27355.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27354__$1.__extmap,other27355.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27352){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27363 = cljs.core.keyword_identical_QMARK_;
var expr__27364 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__27366 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27367 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27366,G__27367) : pred__27363.call(null,G__27366,G__27367));
})())){
return (new fluree.db.graphdb.GraphDb(G__27352,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27368 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27369 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27368,G__27369) : pred__27363.call(null,G__27368,G__27369));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27352,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27370 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27371 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27370,G__27371) : pred__27363.call(null,G__27370,G__27371));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27352,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27372 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27373 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27372,G__27373) : pred__27363.call(null,G__27372,G__27373));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27352,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27374 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27375 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27374,G__27375) : pred__27363.call(null,G__27374,G__27375));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27352,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27376 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27377 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27376,G__27377) : pred__27363.call(null,G__27376,G__27377));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27352,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27378 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27379 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27378,G__27379) : pred__27363.call(null,G__27378,G__27379));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27352,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27380 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27381 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27380,G__27381) : pred__27363.call(null,G__27380,G__27381));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27352,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27382 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27383 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27382,G__27383) : pred__27363.call(null,G__27382,G__27383));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27352,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27384 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27385 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27384,G__27385) : pred__27363.call(null,G__27384,G__27385));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27352,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27386 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27387 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27386,G__27387) : pred__27363.call(null,G__27386,G__27387));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27352,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27388 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27389 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27388,G__27389) : pred__27363.call(null,G__27388,G__27389));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27352,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27390 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27391 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27390,G__27391) : pred__27363.call(null,G__27390,G__27391));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27352,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27392 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27393 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27392,G__27393) : pred__27363.call(null,G__27392,G__27393));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27352,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27394 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27395 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27394,G__27395) : pred__27363.call(null,G__27394,G__27395));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27352,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27396 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27397 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27396,G__27397) : pred__27363.call(null,G__27396,G__27397));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27352,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27398 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27399 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27398,G__27399) : pred__27363.call(null,G__27398,G__27399));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27352,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27400 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27401 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27400,G__27401) : pred__27363.call(null,G__27400,G__27401));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27352,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27402 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27403 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27402,G__27403) : pred__27363.call(null,G__27402,G__27403));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27352,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27404 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27405 = expr__27364;
return (pred__27363.cljs$core$IFn$_invoke$arity$2 ? pred__27363.cljs$core$IFn$_invoke$arity$2(G__27404,G__27405) : pred__27363.call(null,G__27404,G__27405));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27352,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27352),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27352){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27352,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27421){
var state_val_27422 = (state_27421[(1)]);
if((state_val_27422 === (1))){
var state_27421__$1 = state_27421;
var statearr_27423_27688 = state_27421__$1;
(statearr_27423_27688[(2)] = null);

(statearr_27423_27688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (2))){
var _ = (function (){var statearr_27424 = state_27421;
(statearr_27424[(4)] = cljs.core.cons((5),(state_27421[(4)])));

return statearr_27424;
})();
var inst_27412 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_27421__$1 = state_27421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27421__$1,(6),inst_27412);
} else {
if((state_val_27422 === (3))){
var inst_27419 = (state_27421[(2)]);
var state_27421__$1 = state_27421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27421__$1,inst_27419);
} else {
if((state_val_27422 === (4))){
var inst_27406 = (state_27421[(2)]);
var state_27421__$1 = state_27421;
var statearr_27426_27689 = state_27421__$1;
(statearr_27426_27689[(2)] = inst_27406);

(statearr_27426_27689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (5))){
var _ = (function (){var statearr_27427 = state_27421;
(statearr_27427[(4)] = cljs.core.rest((state_27421[(4)])));

return statearr_27427;
})();
var state_27421__$1 = state_27421;
var ex27425 = (state_27421__$1[(2)]);
var statearr_27428_27690 = state_27421__$1;
(statearr_27428_27690[(5)] = ex27425);


if((ex27425 instanceof Error)){
var statearr_27429_27691 = state_27421__$1;
(statearr_27429_27691[(1)] = (4));

(statearr_27429_27691[(5)] = null);

} else {
throw ex27425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27422 === (6))){
var inst_27414 = (state_27421[(2)]);
var inst_27415 = fluree.db.util.async.throw_err(inst_27414);
var inst_27416 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27415,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27430 = state_27421;
(statearr_27430[(4)] = cljs.core.rest((state_27421[(4)])));

return statearr_27430;
})();
var state_27421__$1 = state_27421;
var statearr_27431_27692 = state_27421__$1;
(statearr_27431_27692[(2)] = inst_27416);

(statearr_27431_27692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27432 = [null,null,null,null,null,null,null];
(statearr_27432[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27432[(1)] = (1));

return statearr_27432;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27421){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27421);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27433){var ex__2882__auto__ = e27433;
var statearr_27434_27693 = state_27421;
(statearr_27434_27693[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27421[(4)]))){
var statearr_27435_27694 = state_27421;
(statearr_27435_27694[(1)] = cljs.core.first((state_27421[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27695 = state_27421;
state_27421 = G__27695;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27421){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27436 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27436[(6)] = c__2901__auto__);

return statearr_27436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27437 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27437.cljs$core$IFn$_invoke$arity$1 ? fexpr__27437.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27437.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27438 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27438.cljs$core$IFn$_invoke$arity$1 ? fexpr__27438.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27438.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__27439 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__27439);
} else {
return G__27439;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27471){
var state_val_27472 = (state_27471[(1)]);
if((state_val_27472 === (7))){
var state_27471__$1 = state_27471;
var statearr_27473_27696 = state_27471__$1;
(statearr_27473_27696[(2)] = null);

(statearr_27473_27696[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (1))){
var state_27471__$1 = state_27471;
var statearr_27474_27697 = state_27471__$1;
(statearr_27474_27697[(2)] = null);

(statearr_27474_27697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (4))){
var inst_27440 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27475_27698 = state_27471__$1;
(statearr_27475_27698[(2)] = inst_27440);

(statearr_27475_27698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (6))){
var inst_27454 = (state_27471[(7)]);
var inst_27453 = (state_27471[(2)]);
var inst_27454__$1 = fluree.db.util.async.throw_err(inst_27453);
var inst_27455 = (inst_27454__$1 == null);
var state_27471__$1 = (function (){var statearr_27476 = state_27471;
(statearr_27476[(7)] = inst_27454__$1);

return statearr_27476;
})();
if(cljs.core.truth_(inst_27455)){
var statearr_27477_27699 = state_27471__$1;
(statearr_27477_27699[(1)] = (7));

} else {
var statearr_27478_27700 = state_27471__$1;
(statearr_27478_27700[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (3))){
var inst_27469 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27471__$1,inst_27469);
} else {
if((state_val_27472 === (12))){
var inst_27466 = (state_27471[(2)]);
var _ = (function (){var statearr_27479 = state_27471;
(statearr_27479[(4)] = cljs.core.rest((state_27471[(4)])));

return statearr_27479;
})();
var state_27471__$1 = state_27471;
var statearr_27480_27701 = state_27471__$1;
(statearr_27480_27701[(2)] = inst_27466);

(statearr_27480_27701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (2))){
var _ = (function (){var statearr_27481 = state_27471;
(statearr_27481[(4)] = cljs.core.cons((5),(state_27471[(4)])));

return statearr_27481;
})();
var inst_27447 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27449 = [tag_id,(30)];
var inst_27450 = (new cljs.core.PersistentVector(null,2,(5),inst_27448,inst_27449,null));
var inst_27451 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27447,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27450);
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27471__$1,(6),inst_27451);
} else {
if((state_val_27472 === (11))){
var inst_27460 = (state_27471[(8)]);
var inst_27464 = inst_27460.o;
var state_27471__$1 = state_27471;
var statearr_27483_27702 = state_27471__$1;
(statearr_27483_27702[(2)] = inst_27464);

(statearr_27483_27702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (9))){
var inst_27460 = (state_27471[(8)]);
var inst_27460__$1 = (state_27471[(2)]);
var inst_27461 = (inst_27460__$1 == null);
var state_27471__$1 = (function (){var statearr_27484 = state_27471;
(statearr_27484[(8)] = inst_27460__$1);

return statearr_27484;
})();
if(cljs.core.truth_(inst_27461)){
var statearr_27485_27703 = state_27471__$1;
(statearr_27485_27703[(1)] = (10));

} else {
var statearr_27486_27704 = state_27471__$1;
(statearr_27486_27704[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (5))){
var _ = (function (){var statearr_27487 = state_27471;
(statearr_27487[(4)] = cljs.core.rest((state_27471[(4)])));

return statearr_27487;
})();
var state_27471__$1 = state_27471;
var ex27482 = (state_27471__$1[(2)]);
var statearr_27488_27705 = state_27471__$1;
(statearr_27488_27705[(5)] = ex27482);


if((ex27482 instanceof Error)){
var statearr_27489_27706 = state_27471__$1;
(statearr_27489_27706[(1)] = (4));

(statearr_27489_27706[(5)] = null);

} else {
throw ex27482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (10))){
var state_27471__$1 = state_27471;
var statearr_27490_27707 = state_27471__$1;
(statearr_27490_27707[(2)] = null);

(statearr_27490_27707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27472 === (8))){
var inst_27454 = (state_27471[(7)]);
var inst_27458 = cljs.core.first(inst_27454);
var state_27471__$1 = state_27471;
var statearr_27491_27708 = state_27471__$1;
(statearr_27491_27708[(2)] = inst_27458);

(statearr_27491_27708[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27492 = [null,null,null,null,null,null,null,null,null];
(statearr_27492[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27492[(1)] = (1));

return statearr_27492;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27471){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27471);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27493){var ex__2882__auto__ = e27493;
var statearr_27494_27709 = state_27471;
(statearr_27494_27709[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27471[(4)]))){
var statearr_27495_27710 = state_27471;
(statearr_27495_27710[(1)] = cljs.core.first((state_27471[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27711 = state_27471;
state_27471 = G__27711;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27471){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27496 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27496[(6)] = c__2901__auto__);

return statearr_27496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27532){
var state_val_27533 = (state_27532[(1)]);
if((state_val_27533 === (7))){
var inst_27506 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27532__$1 = state_27532;
var statearr_27534_27712 = state_27532__$1;
(statearr_27534_27712[(2)] = inst_27506);

(statearr_27534_27712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (1))){
var state_27532__$1 = state_27532;
var statearr_27535_27713 = state_27532__$1;
(statearr_27535_27713[(2)] = null);

(statearr_27535_27713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (4))){
var inst_27497 = (state_27532[(2)]);
var state_27532__$1 = state_27532;
var statearr_27536_27714 = state_27532__$1;
(statearr_27536_27714[(2)] = inst_27497);

(statearr_27536_27714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (15))){
var inst_27527 = (state_27532[(2)]);
var _ = (function (){var statearr_27537 = state_27532;
(statearr_27537[(4)] = cljs.core.rest((state_27532[(4)])));

return statearr_27537;
})();
var state_27532__$1 = state_27532;
var statearr_27538_27715 = state_27532__$1;
(statearr_27538_27715[(2)] = inst_27527);

(statearr_27538_27715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (13))){
var inst_27512 = (state_27532[(7)]);
var inst_27518 = clojure.string.includes_QMARK_(inst_27512,":");
var state_27532__$1 = state_27532;
if(inst_27518){
var statearr_27539_27716 = state_27532__$1;
(statearr_27539_27716[(1)] = (16));

} else {
var statearr_27540_27717 = state_27532__$1;
(statearr_27540_27717[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (6))){
var state_27532__$1 = state_27532;
var statearr_27541_27718 = state_27532__$1;
(statearr_27541_27718[(2)] = pred);

(statearr_27541_27718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (17))){
var inst_27512 = (state_27532[(7)]);
var state_27532__$1 = state_27532;
var statearr_27542_27719 = state_27532__$1;
(statearr_27542_27719[(2)] = inst_27512);

(statearr_27542_27719[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (3))){
var inst_27530 = (state_27532[(2)]);
var state_27532__$1 = state_27532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27532__$1,inst_27530);
} else {
if((state_val_27533 === (12))){
var inst_27516 = (state_27532[(2)]);
var state_27532__$1 = state_27532;
if(cljs.core.truth_(inst_27516)){
var statearr_27543_27720 = state_27532__$1;
(statearr_27543_27720[(1)] = (13));

} else {
var statearr_27544_27721 = state_27532__$1;
(statearr_27544_27721[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (2))){
var _ = (function (){var statearr_27545 = state_27532;
(statearr_27545[(4)] = cljs.core.cons((5),(state_27532[(4)])));

return statearr_27545;
})();
var inst_27503 = typeof pred === 'string';
var state_27532__$1 = state_27532;
if(cljs.core.truth_(inst_27503)){
var statearr_27546_27722 = state_27532__$1;
(statearr_27546_27722[(1)] = (6));

} else {
var statearr_27547_27723 = state_27532__$1;
(statearr_27547_27723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (11))){
var inst_27508 = (state_27532[(8)]);
var state_27532__$1 = state_27532;
var statearr_27549_27724 = state_27532__$1;
(statearr_27549_27724[(2)] = inst_27508);

(statearr_27549_27724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (9))){
var inst_27508 = (state_27532[(8)]);
var inst_27511 = (state_27532[(2)]);
var inst_27512 = fluree.db.util.async.throw_err(inst_27511);
var state_27532__$1 = (function (){var statearr_27550 = state_27532;
(statearr_27550[(7)] = inst_27512);

return statearr_27550;
})();
if(cljs.core.truth_(inst_27508)){
var statearr_27551_27725 = state_27532__$1;
(statearr_27551_27725[(1)] = (10));

} else {
var statearr_27552_27726 = state_27532__$1;
(statearr_27552_27726[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (5))){
var _ = (function (){var statearr_27553 = state_27532;
(statearr_27553[(4)] = cljs.core.rest((state_27532[(4)])));

return statearr_27553;
})();
var state_27532__$1 = state_27532;
var ex27548 = (state_27532__$1[(2)]);
var statearr_27554_27727 = state_27532__$1;
(statearr_27554_27727[(5)] = ex27548);


if((ex27548 instanceof Error)){
var statearr_27555_27728 = state_27532__$1;
(statearr_27555_27728[(1)] = (4));

(statearr_27555_27728[(5)] = null);

} else {
throw ex27548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (14))){
var state_27532__$1 = state_27532;
var statearr_27556_27729 = state_27532__$1;
(statearr_27556_27729[(2)] = null);

(statearr_27556_27729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (16))){
var inst_27512 = (state_27532[(7)]);
var inst_27520 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27512,/:/);
var inst_27521 = cljs.core.second(inst_27520);
var state_27532__$1 = state_27532;
var statearr_27557_27730 = state_27532__$1;
(statearr_27557_27730[(2)] = inst_27521);

(statearr_27557_27730[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (10))){
var inst_27512 = (state_27532[(7)]);
var state_27532__$1 = state_27532;
var statearr_27558_27731 = state_27532__$1;
(statearr_27558_27731[(2)] = inst_27512);

(statearr_27558_27731[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (18))){
var inst_27524 = (state_27532[(2)]);
var state_27532__$1 = state_27532;
var statearr_27559_27732 = state_27532__$1;
(statearr_27559_27732[(2)] = inst_27524);

(statearr_27559_27732[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27533 === (8))){
var inst_27508 = (state_27532[(2)]);
var inst_27509 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_27532__$1 = (function (){var statearr_27560 = state_27532;
(statearr_27560[(8)] = inst_27508);

return statearr_27560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27532__$1,(9),inst_27509);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27561 = [null,null,null,null,null,null,null,null,null];
(statearr_27561[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27561[(1)] = (1));

return statearr_27561;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27532){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27532);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27562){var ex__2882__auto__ = e27562;
var statearr_27563_27733 = state_27532;
(statearr_27563_27733[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27532[(4)]))){
var statearr_27564_27734 = state_27532;
(statearr_27564_27734[(1)] = cljs.core.first((state_27532[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27735 = state_27532;
state_27532 = G__27735;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27532){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27565 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27565[(6)] = c__2901__auto__);

return statearr_27565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27597){
var state_val_27598 = (state_27597[(1)]);
if((state_val_27598 === (7))){
var state_27597__$1 = state_27597;
var statearr_27599_27736 = state_27597__$1;
(statearr_27599_27736[(2)] = null);

(statearr_27599_27736[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (1))){
var state_27597__$1 = state_27597;
var statearr_27600_27737 = state_27597__$1;
(statearr_27600_27737[(2)] = null);

(statearr_27600_27737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (4))){
var inst_27566 = (state_27597[(2)]);
var state_27597__$1 = state_27597;
var statearr_27601_27738 = state_27597__$1;
(statearr_27601_27738[(2)] = inst_27566);

(statearr_27601_27738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (6))){
var inst_27580 = (state_27597[(7)]);
var inst_27579 = (state_27597[(2)]);
var inst_27580__$1 = fluree.db.util.async.throw_err(inst_27579);
var inst_27581 = (inst_27580__$1 == null);
var state_27597__$1 = (function (){var statearr_27602 = state_27597;
(statearr_27602[(7)] = inst_27580__$1);

return statearr_27602;
})();
if(cljs.core.truth_(inst_27581)){
var statearr_27603_27739 = state_27597__$1;
(statearr_27603_27739[(1)] = (7));

} else {
var statearr_27604_27740 = state_27597__$1;
(statearr_27604_27740[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (3))){
var inst_27595 = (state_27597[(2)]);
var state_27597__$1 = state_27597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27597__$1,inst_27595);
} else {
if((state_val_27598 === (12))){
var inst_27592 = (state_27597[(2)]);
var _ = (function (){var statearr_27605 = state_27597;
(statearr_27605[(4)] = cljs.core.rest((state_27597[(4)])));

return statearr_27605;
})();
var state_27597__$1 = state_27597;
var statearr_27606_27741 = state_27597__$1;
(statearr_27606_27741[(2)] = inst_27592);

(statearr_27606_27741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (2))){
var _ = (function (){var statearr_27607 = state_27597;
(statearr_27607[(4)] = cljs.core.cons((5),(state_27597[(4)])));

return statearr_27607;
})();
var inst_27573 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27575 = [(30),tag_name];
var inst_27576 = (new cljs.core.PersistentVector(null,2,(5),inst_27574,inst_27575,null));
var inst_27577 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27573,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27576);
var state_27597__$1 = state_27597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27597__$1,(6),inst_27577);
} else {
if((state_val_27598 === (11))){
var inst_27586 = (state_27597[(8)]);
var inst_27590 = inst_27586.s;
var state_27597__$1 = state_27597;
var statearr_27609_27742 = state_27597__$1;
(statearr_27609_27742[(2)] = inst_27590);

(statearr_27609_27742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (9))){
var inst_27586 = (state_27597[(8)]);
var inst_27586__$1 = (state_27597[(2)]);
var inst_27587 = (inst_27586__$1 == null);
var state_27597__$1 = (function (){var statearr_27610 = state_27597;
(statearr_27610[(8)] = inst_27586__$1);

return statearr_27610;
})();
if(cljs.core.truth_(inst_27587)){
var statearr_27611_27743 = state_27597__$1;
(statearr_27611_27743[(1)] = (10));

} else {
var statearr_27612_27744 = state_27597__$1;
(statearr_27612_27744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (5))){
var _ = (function (){var statearr_27613 = state_27597;
(statearr_27613[(4)] = cljs.core.rest((state_27597[(4)])));

return statearr_27613;
})();
var state_27597__$1 = state_27597;
var ex27608 = (state_27597__$1[(2)]);
var statearr_27614_27745 = state_27597__$1;
(statearr_27614_27745[(5)] = ex27608);


if((ex27608 instanceof Error)){
var statearr_27615_27746 = state_27597__$1;
(statearr_27615_27746[(1)] = (4));

(statearr_27615_27746[(5)] = null);

} else {
throw ex27608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (10))){
var state_27597__$1 = state_27597;
var statearr_27616_27747 = state_27597__$1;
(statearr_27616_27747[(2)] = null);

(statearr_27616_27747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27598 === (8))){
var inst_27580 = (state_27597[(7)]);
var inst_27584 = cljs.core.first(inst_27580);
var state_27597__$1 = state_27597;
var statearr_27617_27748 = state_27597__$1;
(statearr_27617_27748[(2)] = inst_27584);

(statearr_27617_27748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27618 = [null,null,null,null,null,null,null,null,null];
(statearr_27618[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27618[(1)] = (1));

return statearr_27618;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27597){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27597);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27619){var ex__2882__auto__ = e27619;
var statearr_27620_27749 = state_27597;
(statearr_27620_27749[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27597[(4)]))){
var statearr_27621_27750 = state_27597;
(statearr_27621_27750[(1)] = cljs.core.first((state_27597[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27751 = state_27597;
state_27597 = G__27751;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27597){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27622 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27622[(6)] = c__2901__auto__);

return statearr_27622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27657){
var state_val_27658 = (state_27657[(1)]);
if((state_val_27658 === (7))){
var inst_27636 = typeof pred === 'string';
var state_27657__$1 = state_27657;
if(cljs.core.truth_(inst_27636)){
var statearr_27659_27752 = state_27657__$1;
(statearr_27659_27752[(1)] = (10));

} else {
var statearr_27660_27753 = state_27657__$1;
(statearr_27660_27753[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (1))){
var state_27657__$1 = state_27657;
var statearr_27661_27754 = state_27657__$1;
(statearr_27661_27754[(2)] = null);

(statearr_27661_27754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (4))){
var inst_27623 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27662_27755 = state_27657__$1;
(statearr_27662_27755[(2)] = inst_27623);

(statearr_27662_27755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (15))){
var inst_27650 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27663_27756 = state_27657__$1;
(statearr_27663_27756[(2)] = inst_27650);

(statearr_27663_27756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (13))){
var inst_27641 = (state_27657[(7)]);
var inst_27643 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27641),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27644 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_27643);
var state_27657__$1 = state_27657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27657__$1,(16),inst_27644);
} else {
if((state_val_27658 === (6))){
var inst_27631 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_27657__$1 = state_27657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27657__$1,(9),inst_27631);
} else {
if((state_val_27658 === (3))){
var inst_27655 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27657__$1,inst_27655);
} else {
if((state_val_27658 === (12))){
var inst_27641 = (state_27657[(7)]);
var inst_27641__$1 = (state_27657[(2)]);
var state_27657__$1 = (function (){var statearr_27664 = state_27657;
(statearr_27664[(7)] = inst_27641__$1);

return statearr_27664;
})();
if(cljs.core.truth_(inst_27641__$1)){
var statearr_27665_27757 = state_27657__$1;
(statearr_27665_27757[(1)] = (13));

} else {
var statearr_27666_27758 = state_27657__$1;
(statearr_27666_27758[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (2))){
var _ = (function (){var statearr_27667 = state_27657;
(statearr_27667[(4)] = cljs.core.cons((5),(state_27657[(4)])));

return statearr_27667;
})();
var inst_27629 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27657__$1 = state_27657;
if(inst_27629){
var statearr_27668_27759 = state_27657__$1;
(statearr_27668_27759[(1)] = (6));

} else {
var statearr_27669_27760 = state_27657__$1;
(statearr_27669_27760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (11))){
var inst_27639 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27657__$1 = state_27657;
var statearr_27671_27761 = state_27657__$1;
(statearr_27671_27761[(2)] = inst_27639);

(statearr_27671_27761[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (9))){
var inst_27633 = (state_27657[(2)]);
var inst_27634 = fluree.db.util.async.throw_err(inst_27633);
var state_27657__$1 = state_27657;
var statearr_27672_27762 = state_27657__$1;
(statearr_27672_27762[(2)] = inst_27634);

(statearr_27672_27762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (5))){
var _ = (function (){var statearr_27673 = state_27657;
(statearr_27673[(4)] = cljs.core.rest((state_27657[(4)])));

return statearr_27673;
})();
var state_27657__$1 = state_27657;
var ex27670 = (state_27657__$1[(2)]);
var statearr_27674_27763 = state_27657__$1;
(statearr_27674_27763[(5)] = ex27670);


if((ex27670 instanceof Error)){
var statearr_27675_27764 = state_27657__$1;
(statearr_27675_27764[(1)] = (4));

(statearr_27675_27764[(5)] = null);

} else {
throw ex27670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (14))){
var state_27657__$1 = state_27657;
var statearr_27676_27765 = state_27657__$1;
(statearr_27676_27765[(2)] = null);

(statearr_27676_27765[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (16))){
var inst_27646 = (state_27657[(2)]);
var inst_27647 = fluree.db.util.async.throw_err(inst_27646);
var state_27657__$1 = state_27657;
var statearr_27677_27766 = state_27657__$1;
(statearr_27677_27766[(2)] = inst_27647);

(statearr_27677_27766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (10))){
var state_27657__$1 = state_27657;
var statearr_27678_27767 = state_27657__$1;
(statearr_27678_27767[(2)] = pred);

(statearr_27678_27767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (8))){
var inst_27652 = (state_27657[(2)]);
var _ = (function (){var statearr_27679 = state_27657;
(statearr_27679[(4)] = cljs.core.rest((state_27657[(4)])));

return statearr_27679;
})();
var state_27657__$1 = state_27657;
var statearr_27680_27768 = state_27657__$1;
(statearr_27680_27768[(2)] = inst_27652);

(statearr_27680_27768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27681 = [null,null,null,null,null,null,null,null];
(statearr_27681[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27681[(1)] = (1));

return statearr_27681;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27657){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_27657);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27682){var ex__2882__auto__ = e27682;
var statearr_27683_27769 = state_27657;
(statearr_27683_27769[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_27657[(4)]))){
var statearr_27684_27770 = state_27657;
(statearr_27684_27770[(1)] = cljs.core.first((state_27657[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27771 = state_27657;
state_27657 = G__27771;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27657){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27685 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_27685[(6)] = c__2901__auto__);

return statearr_27685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27356){
var extmap__4419__auto__ = (function (){var G__27686 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27356,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27356)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27686);
} else {
return G__27686;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27356),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27356),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
