// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___54576 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54627){
var state_val_54628 = (state_54627[(1)]);
if((state_val_54628 === (7))){
var inst_54622 = (state_54627[(2)]);
var _ = (function (){var statearr_54629 = state_54627;
(statearr_54629[(4)] = cljs.core.rest((state_54627[(4)])));

return statearr_54629;
})();
var state_54627__$1 = state_54627;
var statearr_54630_54657 = state_54627__$1;
(statearr_54630_54657[(2)] = inst_54622);

(statearr_54630_54657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (1))){
var state_54627__$1 = state_54627;
var statearr_54631_54658 = state_54627__$1;
(statearr_54631_54658[(2)] = null);

(statearr_54631_54658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (4))){
var inst_54577 = (state_54627[(2)]);
var state_54627__$1 = state_54627;
var statearr_54632_54659 = state_54627__$1;
(statearr_54632_54659[(2)] = inst_54577);

(statearr_54632_54659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (13))){
var inst_54618 = (state_54627[(2)]);
var state_54627__$1 = state_54627;
var statearr_54633_54660 = state_54627__$1;
(statearr_54633_54660[(2)] = inst_54618);

(statearr_54633_54660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (6))){
var inst_54602 = (state_54627[(7)]);
var inst_54595 = (state_54627[(8)]);
var inst_54601 = cljs.core.seq(inst_54595);
var inst_54602__$1 = cljs.core.first(inst_54601);
var inst_54603 = cljs.core.next(inst_54601);
var inst_54604 = cljs.core.not(inst_54602__$1);
var state_54627__$1 = (function (){var statearr_54634 = state_54627;
(statearr_54634[(9)] = inst_54603);

(statearr_54634[(7)] = inst_54602__$1);

return statearr_54634;
})();
if(inst_54604){
var statearr_54635_54661 = state_54627__$1;
(statearr_54635_54661[(1)] = (8));

} else {
var statearr_54636_54662 = state_54627__$1;
(statearr_54636_54662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (3))){
var inst_54625 = (state_54627[(2)]);
var state_54627__$1 = state_54627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54627__$1,inst_54625);
} else {
if((state_val_54628 === (12))){
var inst_54603 = (state_54627[(9)]);
var inst_54596 = (state_54627[(10)]);
var inst_54602 = (state_54627[(7)]);
var inst_54615 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54596,inst_54602);
var inst_54595 = inst_54603;
var inst_54596__$1 = inst_54615;
var state_54627__$1 = (function (){var statearr_54637 = state_54627;
(statearr_54637[(10)] = inst_54596__$1);

(statearr_54637[(8)] = inst_54595);

return statearr_54637;
})();
var statearr_54638_54663 = state_54627__$1;
(statearr_54638_54663[(2)] = null);

(statearr_54638_54663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (2))){
var _ = (function (){var statearr_54639 = state_54627;
(statearr_54639[(4)] = cljs.core.cons((5),(state_54627[(4)])));

return statearr_54639;
})();
var inst_54590 = args;
var inst_54591 = cljs.core.seq(inst_54590);
var inst_54592 = cljs.core.first(inst_54591);
var inst_54593 = cljs.core.next(inst_54591);
var inst_54594 = cljs.core.PersistentVector.EMPTY;
var inst_54595 = inst_54590;
var inst_54596 = inst_54594;
var state_54627__$1 = (function (){var statearr_54640 = state_54627;
(statearr_54640[(10)] = inst_54596);

(statearr_54640[(11)] = inst_54592);

(statearr_54640[(8)] = inst_54595);

(statearr_54640[(12)] = inst_54593);

return statearr_54640;
})();
var statearr_54641_54664 = state_54627__$1;
(statearr_54641_54664[(2)] = null);

(statearr_54641_54664[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (11))){
var inst_54602 = (state_54627[(7)]);
var state_54627__$1 = state_54627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54627__$1,(14),inst_54602);
} else {
if((state_val_54628 === (9))){
var inst_54602 = (state_54627[(7)]);
var inst_54607 = fluree.db.util.async.channel_QMARK_(inst_54602);
var state_54627__$1 = state_54627;
if(inst_54607){
var statearr_54643_54665 = state_54627__$1;
(statearr_54643_54665[(1)] = (11));

} else {
var statearr_54644_54666 = state_54627__$1;
(statearr_54644_54666[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (5))){
var _ = (function (){var statearr_54645 = state_54627;
(statearr_54645[(4)] = cljs.core.rest((state_54627[(4)])));

return statearr_54645;
})();
var state_54627__$1 = state_54627;
var ex54642 = (state_54627__$1[(2)]);
var statearr_54646_54667 = state_54627__$1;
(statearr_54646_54667[(5)] = ex54642);


if((ex54642 instanceof Error)){
var statearr_54647_54668 = state_54627__$1;
(statearr_54647_54668[(1)] = (4));

(statearr_54647_54668[(5)] = null);

} else {
throw ex54642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (14))){
var inst_54603 = (state_54627[(9)]);
var inst_54596 = (state_54627[(10)]);
var inst_54610 = (state_54627[(2)]);
var inst_54611 = fluree.db.util.async.throw_err(inst_54610);
var inst_54612 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54596,inst_54611);
var inst_54595 = inst_54603;
var inst_54596__$1 = inst_54612;
var state_54627__$1 = (function (){var statearr_54648 = state_54627;
(statearr_54648[(10)] = inst_54596__$1);

(statearr_54648[(8)] = inst_54595);

return statearr_54648;
})();
var statearr_54649_54669 = state_54627__$1;
(statearr_54649_54669[(2)] = null);

(statearr_54649_54669[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (10))){
var inst_54620 = (state_54627[(2)]);
var state_54627__$1 = state_54627;
var statearr_54650_54670 = state_54627__$1;
(statearr_54650_54670[(2)] = inst_54620);

(statearr_54650_54670[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54628 === (8))){
var inst_54596 = (state_54627[(10)]);
var state_54627__$1 = state_54627;
var statearr_54651_54671 = state_54627__$1;
(statearr_54651_54671[(2)] = inst_54596);

(statearr_54651_54671[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0 = (function (){
var statearr_54652 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54652[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__);

(statearr_54652[(1)] = (1));

return statearr_54652;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1 = (function (state_54627){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_54627);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54653){var ex__2882__auto__ = e54653;
var statearr_54654_54672 = state_54627;
(statearr_54654_54672[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_54627[(4)]))){
var statearr_54655_54673 = state_54627;
(statearr_54655_54673[(1)] = cljs.core.first((state_54627[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54674 = state_54627;
state_54627 = G__54674;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__ = function(state_54627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1.call(this,state_54627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54656 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_54656[(6)] = c__2901__auto__);

return statearr_54656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54675 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54675,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54675,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54723){
var state_val_54724 = (state_54723[(1)]);
if((state_val_54724 === (7))){
var state_54723__$1 = state_54723;
var statearr_54725_54754 = state_54723__$1;
(statearr_54725_54754[(2)] = coll);

(statearr_54725_54754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (1))){
var state_54723__$1 = state_54723;
var statearr_54726_54755 = state_54723__$1;
(statearr_54726_54755[(2)] = null);

(statearr_54726_54755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (4))){
var inst_54678 = (state_54723[(2)]);
var state_54723__$1 = state_54723;
var statearr_54727_54756 = state_54723__$1;
(statearr_54727_54756[(2)] = inst_54678);

(statearr_54727_54756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (15))){
var inst_54697 = (state_54723[(7)]);
var inst_54705 = (state_54723[(2)]);
var inst_54706 = fluree.db.dbfunctions.internal.nth(inst_54697,inst_54705);
var inst_54707 = cljs.core.count(inst_54697);
var inst_54708 = ((9) + inst_54707);
var inst_54709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54710 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54712 = [inst_54697,inst_54705];
var inst_54713 = (new cljs.core.PersistentVector(null,2,(5),inst_54711,inst_54712,null));
var inst_54714 = ["nth",inst_54713,inst_54706];
var inst_54715 = cljs.core.PersistentHashMap.fromArrays(inst_54710,inst_54714);
var inst_54716 = [inst_54715,inst_54708];
var inst_54717 = (new cljs.core.PersistentVector(null,2,(5),inst_54709,inst_54716,null));
var inst_54718 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54717);
var _ = (function (){var statearr_54728 = state_54723;
(statearr_54728[(4)] = cljs.core.rest((state_54723[(4)])));

return statearr_54728;
})();
var state_54723__$1 = (function (){var statearr_54729 = state_54723;
(statearr_54729[(8)] = inst_54718);

return statearr_54729;
})();
var statearr_54730_54757 = state_54723__$1;
(statearr_54730_54757[(2)] = inst_54706);

(statearr_54730_54757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (13))){
var state_54723__$1 = state_54723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54723__$1,(16),key);
} else {
if((state_val_54724 === (6))){
var state_54723__$1 = state_54723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54723__$1,(9),coll);
} else {
if((state_val_54724 === (3))){
var inst_54721 = (state_54723[(2)]);
var state_54723__$1 = state_54723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54723__$1,inst_54721);
} else {
if((state_val_54724 === (12))){
var inst_54697 = (state_54723[(2)]);
var inst_54698 = fluree.db.util.async.channel_QMARK_(key);
var state_54723__$1 = (function (){var statearr_54731 = state_54723;
(statearr_54731[(7)] = inst_54697);

return statearr_54731;
})();
if(inst_54698){
var statearr_54732_54758 = state_54723__$1;
(statearr_54732_54758[(1)] = (13));

} else {
var statearr_54733_54759 = state_54723__$1;
(statearr_54733_54759[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (2))){
var _ = (function (){var statearr_54734 = state_54723;
(statearr_54734[(4)] = cljs.core.cons((5),(state_54723[(4)])));

return statearr_54734;
})();
var inst_54684 = fluree.db.util.async.channel_QMARK_(coll);
var state_54723__$1 = state_54723;
if(inst_54684){
var statearr_54735_54760 = state_54723__$1;
(statearr_54735_54760[(1)] = (6));

} else {
var statearr_54736_54761 = state_54723__$1;
(statearr_54736_54761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (11))){
var inst_54691 = (state_54723[(9)]);
var state_54723__$1 = state_54723;
var statearr_54738_54762 = state_54723__$1;
(statearr_54738_54762[(2)] = inst_54691);

(statearr_54738_54762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (9))){
var inst_54687 = (state_54723[(2)]);
var inst_54688 = fluree.db.util.async.throw_err(inst_54687);
var state_54723__$1 = state_54723;
var statearr_54739_54763 = state_54723__$1;
(statearr_54739_54763[(2)] = inst_54688);

(statearr_54739_54763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (5))){
var _ = (function (){var statearr_54740 = state_54723;
(statearr_54740[(4)] = cljs.core.rest((state_54723[(4)])));

return statearr_54740;
})();
var state_54723__$1 = state_54723;
var ex54737 = (state_54723__$1[(2)]);
var statearr_54741_54764 = state_54723__$1;
(statearr_54741_54764[(5)] = ex54737);


if((ex54737 instanceof Error)){
var statearr_54742_54765 = state_54723__$1;
(statearr_54742_54765[(1)] = (4));

(statearr_54742_54765[(5)] = null);

} else {
throw ex54737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (14))){
var state_54723__$1 = state_54723;
var statearr_54743_54766 = state_54723__$1;
(statearr_54743_54766[(2)] = key);

(statearr_54743_54766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (16))){
var inst_54701 = (state_54723[(2)]);
var inst_54702 = fluree.db.util.async.throw_err(inst_54701);
var state_54723__$1 = state_54723;
var statearr_54744_54767 = state_54723__$1;
(statearr_54744_54767[(2)] = inst_54702);

(statearr_54744_54767[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (10))){
var inst_54691 = (state_54723[(9)]);
var inst_54694 = cljs.core.vec(inst_54691);
var state_54723__$1 = state_54723;
var statearr_54745_54768 = state_54723__$1;
(statearr_54745_54768[(2)] = inst_54694);

(statearr_54745_54768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54724 === (8))){
var inst_54691 = (state_54723[(9)]);
var inst_54691__$1 = (state_54723[(2)]);
var inst_54692 = cljs.core.set_QMARK_(inst_54691__$1);
var state_54723__$1 = (function (){var statearr_54746 = state_54723;
(statearr_54746[(9)] = inst_54691__$1);

return statearr_54746;
})();
if(inst_54692){
var statearr_54747_54769 = state_54723__$1;
(statearr_54747_54769[(1)] = (10));

} else {
var statearr_54748_54770 = state_54723__$1;
(statearr_54748_54770[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0 = (function (){
var statearr_54749 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54749[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__);

(statearr_54749[(1)] = (1));

return statearr_54749;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1 = (function (state_54723){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_54723);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54750){var ex__2882__auto__ = e54750;
var statearr_54751_54771 = state_54723;
(statearr_54751_54771[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_54723[(4)]))){
var statearr_54752_54772 = state_54723;
(statearr_54752_54772[(1)] = cljs.core.first((state_54723[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54773 = state_54723;
state_54723 = G__54773;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__ = function(state_54723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1.call(this,state_54723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54753 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_54753[(6)] = c__2901__auto__);

return statearr_54753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54834){
var state_val_54835 = (state_54834[(1)]);
if((state_val_54835 === (7))){
var state_54834__$1 = state_54834;
var statearr_54836_54870 = state_54834__$1;
(statearr_54836_54870[(2)] = test);

(statearr_54836_54870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (20))){
var inst_54808 = (state_54834[(2)]);
var inst_54809 = fluree.db.util.async.throw_err(inst_54808);
var state_54834__$1 = state_54834;
var statearr_54837_54871 = state_54834__$1;
(statearr_54837_54871[(2)] = inst_54809);

(statearr_54837_54871[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (1))){
var state_54834__$1 = state_54834;
var statearr_54838_54872 = state_54834__$1;
(statearr_54838_54872[(2)] = null);

(statearr_54838_54872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (4))){
var inst_54774 = (state_54834[(2)]);
var state_54834__$1 = state_54834;
var statearr_54839_54873 = state_54834__$1;
(statearr_54839_54873[(2)] = inst_54774);

(statearr_54839_54873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (15))){
var inst_54792 = (state_54834[(7)]);
var inst_54800 = (state_54834[(2)]);
var inst_54801 = [inst_54800,f];
var inst_54802 = (new cljs.core.PersistentVector(null,2,(5),inst_54792,inst_54801,null));
var state_54834__$1 = state_54834;
var statearr_54840_54874 = state_54834__$1;
(statearr_54840_54874[(2)] = inst_54802);

(statearr_54840_54874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (13))){
var state_54834__$1 = state_54834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54834__$1,(16),t);
} else {
if((state_val_54835 === (6))){
var state_54834__$1 = state_54834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54834__$1,(9),test);
} else {
if((state_val_54835 === (17))){
var state_54834__$1 = state_54834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54834__$1,(20),f);
} else {
if((state_val_54835 === (3))){
var inst_54832 = (state_54834[(2)]);
var state_54834__$1 = state_54834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54834__$1,inst_54832);
} else {
if((state_val_54835 === (12))){
var inst_54790 = (state_54834[(8)]);
var inst_54816 = (state_54834[(2)]);
var inst_54817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54816,(0),null);
var inst_54818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54816,(1),null);
var inst_54819 = fluree.db.dbfunctions.internal.if_else(inst_54790,inst_54817,inst_54818);
var inst_54820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54821 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54823 = [inst_54790,inst_54817,inst_54818];
var inst_54824 = (new cljs.core.PersistentVector(null,3,(5),inst_54822,inst_54823,null));
var inst_54825 = ["if-else",inst_54824,inst_54819];
var inst_54826 = cljs.core.PersistentHashMap.fromArrays(inst_54821,inst_54825);
var inst_54827 = [inst_54826,(10)];
var inst_54828 = (new cljs.core.PersistentVector(null,2,(5),inst_54820,inst_54827,null));
var inst_54829 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54828);
var _ = (function (){var statearr_54841 = state_54834;
(statearr_54841[(4)] = cljs.core.rest((state_54834[(4)])));

return statearr_54841;
})();
var state_54834__$1 = (function (){var statearr_54842 = state_54834;
(statearr_54842[(9)] = inst_54829);

return statearr_54842;
})();
var statearr_54843_54875 = state_54834__$1;
(statearr_54843_54875[(2)] = inst_54819);

(statearr_54843_54875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (2))){
var _ = (function (){var statearr_54844 = state_54834;
(statearr_54844[(4)] = cljs.core.cons((5),(state_54834[(4)])));

return statearr_54844;
})();
var inst_54783 = fluree.db.util.async.channel_QMARK_(test);
var state_54834__$1 = state_54834;
if(inst_54783){
var statearr_54845_54876 = state_54834__$1;
(statearr_54845_54876[(1)] = (6));

} else {
var statearr_54846_54877 = state_54834__$1;
(statearr_54846_54877[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (19))){
var inst_54804 = (state_54834[(10)]);
var inst_54812 = (state_54834[(2)]);
var inst_54813 = [f,inst_54812];
var inst_54814 = (new cljs.core.PersistentVector(null,2,(5),inst_54804,inst_54813,null));
var state_54834__$1 = state_54834;
var statearr_54847_54878 = state_54834__$1;
(statearr_54847_54878[(2)] = inst_54814);

(statearr_54847_54878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (11))){
var inst_54804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54805 = fluree.db.util.async.channel_QMARK_(f);
var state_54834__$1 = (function (){var statearr_54849 = state_54834;
(statearr_54849[(10)] = inst_54804);

return statearr_54849;
})();
if(inst_54805){
var statearr_54850_54879 = state_54834__$1;
(statearr_54850_54879[(1)] = (17));

} else {
var statearr_54851_54880 = state_54834__$1;
(statearr_54851_54880[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (9))){
var inst_54786 = (state_54834[(2)]);
var inst_54787 = fluree.db.util.async.throw_err(inst_54786);
var state_54834__$1 = state_54834;
var statearr_54852_54881 = state_54834__$1;
(statearr_54852_54881[(2)] = inst_54787);

(statearr_54852_54881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (5))){
var _ = (function (){var statearr_54853 = state_54834;
(statearr_54853[(4)] = cljs.core.rest((state_54834[(4)])));

return statearr_54853;
})();
var state_54834__$1 = state_54834;
var ex54848 = (state_54834__$1[(2)]);
var statearr_54854_54882 = state_54834__$1;
(statearr_54854_54882[(5)] = ex54848);


if((ex54848 instanceof Error)){
var statearr_54855_54883 = state_54834__$1;
(statearr_54855_54883[(1)] = (4));

(statearr_54855_54883[(5)] = null);

} else {
throw ex54848;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (14))){
var state_54834__$1 = state_54834;
var statearr_54856_54884 = state_54834__$1;
(statearr_54856_54884[(2)] = t);

(statearr_54856_54884[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (16))){
var inst_54796 = (state_54834[(2)]);
var inst_54797 = fluree.db.util.async.throw_err(inst_54796);
var state_54834__$1 = state_54834;
var statearr_54857_54885 = state_54834__$1;
(statearr_54857_54885[(2)] = inst_54797);

(statearr_54857_54885[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (10))){
var inst_54792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54793 = fluree.db.util.async.channel_QMARK_(t);
var state_54834__$1 = (function (){var statearr_54858 = state_54834;
(statearr_54858[(7)] = inst_54792);

return statearr_54858;
})();
if(inst_54793){
var statearr_54859_54886 = state_54834__$1;
(statearr_54859_54886[(1)] = (13));

} else {
var statearr_54860_54887 = state_54834__$1;
(statearr_54860_54887[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (18))){
var state_54834__$1 = state_54834;
var statearr_54861_54888 = state_54834__$1;
(statearr_54861_54888[(2)] = f);

(statearr_54861_54888[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54835 === (8))){
var inst_54790 = (state_54834[(8)]);
var inst_54790__$1 = (state_54834[(2)]);
var state_54834__$1 = (function (){var statearr_54862 = state_54834;
(statearr_54862[(8)] = inst_54790__$1);

return statearr_54862;
})();
if(cljs.core.truth_(inst_54790__$1)){
var statearr_54863_54889 = state_54834__$1;
(statearr_54863_54889[(1)] = (10));

} else {
var statearr_54864_54890 = state_54834__$1;
(statearr_54864_54890[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0 = (function (){
var statearr_54865 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54865[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__);

(statearr_54865[(1)] = (1));

return statearr_54865;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1 = (function (state_54834){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_54834);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54866){var ex__2882__auto__ = e54866;
var statearr_54867_54891 = state_54834;
(statearr_54867_54891[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_54834[(4)]))){
var statearr_54868_54892 = state_54834;
(statearr_54868_54892[(1)] = cljs.core.first((state_54834[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54893 = state_54834;
state_54834 = G__54893;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__ = function(state_54834){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1.call(this,state_54834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54869 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_54869[(6)] = c__2901__auto__);

return statearr_54869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54923){
var state_val_54924 = (state_54923[(1)]);
if((state_val_54924 === (7))){
var state_54923__$1 = state_54923;
var statearr_54925_54944 = state_54923__$1;
(statearr_54925_54944[(2)] = arg);

(statearr_54925_54944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (1))){
var state_54923__$1 = state_54923;
var statearr_54926_54945 = state_54923__$1;
(statearr_54926_54945[(2)] = null);

(statearr_54926_54945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (4))){
var inst_54894 = (state_54923[(2)]);
var state_54923__$1 = state_54923;
var statearr_54927_54946 = state_54923__$1;
(statearr_54927_54946[(2)] = inst_54894);

(statearr_54927_54946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (6))){
var state_54923__$1 = state_54923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54923__$1,(9),arg);
} else {
if((state_val_54924 === (3))){
var inst_54921 = (state_54923[(2)]);
var state_54923__$1 = state_54923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54923__$1,inst_54921);
} else {
if((state_val_54924 === (2))){
var _ = (function (){var statearr_54929 = state_54923;
(statearr_54929[(4)] = cljs.core.cons((5),(state_54923[(4)])));

return statearr_54929;
})();
var inst_54900 = fluree.db.util.async.channel_QMARK_(arg);
var state_54923__$1 = state_54923;
if(inst_54900){
var statearr_54930_54947 = state_54923__$1;
(statearr_54930_54947[(1)] = (6));

} else {
var statearr_54931_54948 = state_54923__$1;
(statearr_54931_54948[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (9))){
var inst_54903 = (state_54923[(2)]);
var inst_54904 = fluree.db.util.async.throw_err(inst_54903);
var state_54923__$1 = state_54923;
var statearr_54932_54949 = state_54923__$1;
(statearr_54932_54949[(2)] = inst_54904);

(statearr_54932_54949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (5))){
var _ = (function (){var statearr_54933 = state_54923;
(statearr_54933[(4)] = cljs.core.rest((state_54923[(4)])));

return statearr_54933;
})();
var state_54923__$1 = state_54923;
var ex54928 = (state_54923__$1[(2)]);
var statearr_54934_54950 = state_54923__$1;
(statearr_54934_54950[(5)] = ex54928);


if((ex54928 instanceof Error)){
var statearr_54935_54951 = state_54923__$1;
(statearr_54935_54951[(1)] = (4));

(statearr_54935_54951[(5)] = null);

} else {
throw ex54928;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (8))){
var inst_54907 = (state_54923[(2)]);
var inst_54908 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54907);
var inst_54909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54910 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54912 = [inst_54907];
var inst_54913 = (new cljs.core.PersistentVector(null,1,(5),inst_54911,inst_54912,null));
var inst_54914 = ["nil?",inst_54913,inst_54908];
var inst_54915 = cljs.core.PersistentHashMap.fromArrays(inst_54910,inst_54914);
var inst_54916 = [inst_54915,(10)];
var inst_54917 = (new cljs.core.PersistentVector(null,2,(5),inst_54909,inst_54916,null));
var inst_54918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54917);
var _ = (function (){var statearr_54936 = state_54923;
(statearr_54936[(4)] = cljs.core.rest((state_54923[(4)])));

return statearr_54936;
})();
var state_54923__$1 = (function (){var statearr_54937 = state_54923;
(statearr_54937[(7)] = inst_54918);

return statearr_54937;
})();
var statearr_54938_54952 = state_54923__$1;
(statearr_54938_54952[(2)] = inst_54908);

(statearr_54938_54952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_54939 = [null,null,null,null,null,null,null,null];
(statearr_54939[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__);

(statearr_54939[(1)] = (1));

return statearr_54939;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1 = (function (state_54923){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_54923);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54940){var ex__2882__auto__ = e54940;
var statearr_54941_54953 = state_54923;
(statearr_54941_54953[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_54923[(4)]))){
var statearr_54942_54954 = state_54923;
(statearr_54942_54954[(1)] = cljs.core.first((state_54923[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54955 = state_54923;
state_54923 = G__54955;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__ = function(state_54923){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1.call(this,state_54923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54943 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_54943[(6)] = c__2901__auto__);

return statearr_54943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54985){
var state_val_54986 = (state_54985[(1)]);
if((state_val_54986 === (7))){
var state_54985__$1 = state_54985;
var statearr_54987_55006 = state_54985__$1;
(statearr_54987_55006[(2)] = arg);

(statearr_54987_55006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (1))){
var state_54985__$1 = state_54985;
var statearr_54988_55007 = state_54985__$1;
(statearr_54988_55007[(2)] = null);

(statearr_54988_55007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (4))){
var inst_54956 = (state_54985[(2)]);
var state_54985__$1 = state_54985;
var statearr_54989_55008 = state_54985__$1;
(statearr_54989_55008[(2)] = inst_54956);

(statearr_54989_55008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (6))){
var state_54985__$1 = state_54985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54985__$1,(9),arg);
} else {
if((state_val_54986 === (3))){
var inst_54983 = (state_54985[(2)]);
var state_54985__$1 = state_54985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54985__$1,inst_54983);
} else {
if((state_val_54986 === (2))){
var _ = (function (){var statearr_54991 = state_54985;
(statearr_54991[(4)] = cljs.core.cons((5),(state_54985[(4)])));

return statearr_54991;
})();
var inst_54962 = fluree.db.util.async.channel_QMARK_(arg);
var state_54985__$1 = state_54985;
if(inst_54962){
var statearr_54992_55009 = state_54985__$1;
(statearr_54992_55009[(1)] = (6));

} else {
var statearr_54993_55010 = state_54985__$1;
(statearr_54993_55010[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (9))){
var inst_54965 = (state_54985[(2)]);
var inst_54966 = fluree.db.util.async.throw_err(inst_54965);
var state_54985__$1 = state_54985;
var statearr_54994_55011 = state_54985__$1;
(statearr_54994_55011[(2)] = inst_54966);

(statearr_54994_55011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (5))){
var _ = (function (){var statearr_54995 = state_54985;
(statearr_54995[(4)] = cljs.core.rest((state_54985[(4)])));

return statearr_54995;
})();
var state_54985__$1 = state_54985;
var ex54990 = (state_54985__$1[(2)]);
var statearr_54996_55012 = state_54985__$1;
(statearr_54996_55012[(5)] = ex54990);


if((ex54990 instanceof Error)){
var statearr_54997_55013 = state_54985__$1;
(statearr_54997_55013[(1)] = (4));

(statearr_54997_55013[(5)] = null);

} else {
throw ex54990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54986 === (8))){
var inst_54969 = (state_54985[(2)]);
var inst_54970 = fluree.db.dbfunctions.internal.not(inst_54969);
var inst_54971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54972 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54974 = [inst_54969];
var inst_54975 = (new cljs.core.PersistentVector(null,1,(5),inst_54973,inst_54974,null));
var inst_54976 = ["not?",inst_54975,inst_54970];
var inst_54977 = cljs.core.PersistentHashMap.fromArrays(inst_54972,inst_54976);
var inst_54978 = [inst_54977,(10)];
var inst_54979 = (new cljs.core.PersistentVector(null,2,(5),inst_54971,inst_54978,null));
var inst_54980 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54979);
var _ = (function (){var statearr_54998 = state_54985;
(statearr_54998[(4)] = cljs.core.rest((state_54985[(4)])));

return statearr_54998;
})();
var state_54985__$1 = (function (){var statearr_54999 = state_54985;
(statearr_54999[(7)] = inst_54980);

return statearr_54999;
})();
var statearr_55000_55014 = state_54985__$1;
(statearr_55000_55014[(2)] = inst_54970);

(statearr_55000_55014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0 = (function (){
var statearr_55001 = [null,null,null,null,null,null,null,null];
(statearr_55001[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__);

(statearr_55001[(1)] = (1));

return statearr_55001;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1 = (function (state_54985){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_54985);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55002){var ex__2882__auto__ = e55002;
var statearr_55003_55015 = state_54985;
(statearr_55003_55015[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_54985[(4)]))){
var statearr_55004_55016 = state_54985;
(statearr_55004_55016[(1)] = cljs.core.first((state_54985[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55017 = state_54985;
state_54985 = G__55017;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__ = function(state_54985){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1.call(this,state_54985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55005 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55005[(6)] = c__2901__auto__);

return statearr_55005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55047){
var state_val_55048 = (state_55047[(1)]);
if((state_val_55048 === (7))){
var state_55047__$1 = state_55047;
var statearr_55049_55068 = state_55047__$1;
(statearr_55049_55068[(2)] = arg);

(statearr_55049_55068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (1))){
var state_55047__$1 = state_55047;
var statearr_55050_55069 = state_55047__$1;
(statearr_55050_55069[(2)] = null);

(statearr_55050_55069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (4))){
var inst_55018 = (state_55047[(2)]);
var state_55047__$1 = state_55047;
var statearr_55051_55070 = state_55047__$1;
(statearr_55051_55070[(2)] = inst_55018);

(statearr_55051_55070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (6))){
var state_55047__$1 = state_55047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55047__$1,(9),arg);
} else {
if((state_val_55048 === (3))){
var inst_55045 = (state_55047[(2)]);
var state_55047__$1 = state_55047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55047__$1,inst_55045);
} else {
if((state_val_55048 === (2))){
var _ = (function (){var statearr_55053 = state_55047;
(statearr_55053[(4)] = cljs.core.cons((5),(state_55047[(4)])));

return statearr_55053;
})();
var inst_55024 = fluree.db.util.async.channel_QMARK_(arg);
var state_55047__$1 = state_55047;
if(inst_55024){
var statearr_55054_55071 = state_55047__$1;
(statearr_55054_55071[(1)] = (6));

} else {
var statearr_55055_55072 = state_55047__$1;
(statearr_55055_55072[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (9))){
var inst_55027 = (state_55047[(2)]);
var inst_55028 = fluree.db.util.async.throw_err(inst_55027);
var state_55047__$1 = state_55047;
var statearr_55056_55073 = state_55047__$1;
(statearr_55056_55073[(2)] = inst_55028);

(statearr_55056_55073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (5))){
var _ = (function (){var statearr_55057 = state_55047;
(statearr_55057[(4)] = cljs.core.rest((state_55047[(4)])));

return statearr_55057;
})();
var state_55047__$1 = state_55047;
var ex55052 = (state_55047__$1[(2)]);
var statearr_55058_55074 = state_55047__$1;
(statearr_55058_55074[(5)] = ex55052);


if((ex55052 instanceof Error)){
var statearr_55059_55075 = state_55047__$1;
(statearr_55059_55075[(1)] = (4));

(statearr_55059_55075[(5)] = null);

} else {
throw ex55052;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55048 === (8))){
var inst_55031 = (state_55047[(2)]);
var inst_55032 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_55031);
var inst_55033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55034 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55036 = [inst_55031];
var inst_55037 = (new cljs.core.PersistentVector(null,1,(5),inst_55035,inst_55036,null));
var inst_55038 = ["empty?",inst_55037,inst_55032];
var inst_55039 = cljs.core.PersistentHashMap.fromArrays(inst_55034,inst_55038);
var inst_55040 = [inst_55039,(10)];
var inst_55041 = (new cljs.core.PersistentVector(null,2,(5),inst_55033,inst_55040,null));
var inst_55042 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55041);
var _ = (function (){var statearr_55060 = state_55047;
(statearr_55060[(4)] = cljs.core.rest((state_55047[(4)])));

return statearr_55060;
})();
var state_55047__$1 = (function (){var statearr_55061 = state_55047;
(statearr_55061[(7)] = inst_55042);

return statearr_55061;
})();
var statearr_55062_55076 = state_55047__$1;
(statearr_55062_55076[(2)] = inst_55032);

(statearr_55062_55076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_55063 = [null,null,null,null,null,null,null,null];
(statearr_55063[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__);

(statearr_55063[(1)] = (1));

return statearr_55063;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1 = (function (state_55047){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55047);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55064){var ex__2882__auto__ = e55064;
var statearr_55065_55077 = state_55047;
(statearr_55065_55077[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55047[(4)]))){
var statearr_55066_55078 = state_55047;
(statearr_55066_55078[(1)] = cljs.core.first((state_55047[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55079 = state_55047;
state_55047 = G__55079;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__ = function(state_55047){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1.call(this,state_55047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55067 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55067[(6)] = c__2901__auto__);

return statearr_55067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55124 = arguments.length;
var i__4737__auto___55125 = (0);
while(true){
if((i__4737__auto___55125 < len__4736__auto___55124)){
args__4742__auto__.push((arguments[i__4737__auto___55125]));

var G__55126 = (i__4737__auto___55125 + (1));
i__4737__auto___55125 = G__55126;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55107){
var state_val_55108 = (state_55107[(1)]);
if((state_val_55108 === (1))){
var state_55107__$1 = state_55107;
var statearr_55109_55127 = state_55107__$1;
(statearr_55109_55127[(2)] = null);

(statearr_55109_55127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (2))){
var _ = (function (){var statearr_55110 = state_55107;
(statearr_55110[(4)] = cljs.core.cons((5),(state_55107[(4)])));

return statearr_55110;
})();
var inst_55088 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55107__$1 = state_55107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55107__$1,(6),inst_55088);
} else {
if((state_val_55108 === (3))){
var inst_55105 = (state_55107[(2)]);
var state_55107__$1 = state_55107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55107__$1,inst_55105);
} else {
if((state_val_55108 === (4))){
var inst_55082 = (state_55107[(2)]);
var state_55107__$1 = state_55107;
var statearr_55112_55128 = state_55107__$1;
(statearr_55112_55128[(2)] = inst_55082);

(statearr_55112_55128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (5))){
var _ = (function (){var statearr_55113 = state_55107;
(statearr_55113[(4)] = cljs.core.rest((state_55107[(4)])));

return statearr_55113;
})();
var state_55107__$1 = state_55107;
var ex55111 = (state_55107__$1[(2)]);
var statearr_55114_55129 = state_55107__$1;
(statearr_55114_55129[(5)] = ex55111);


if((ex55111 instanceof Error)){
var statearr_55115_55130 = state_55107__$1;
(statearr_55115_55130[(1)] = (4));

(statearr_55115_55130[(5)] = null);

} else {
throw ex55111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (6))){
var inst_55090 = (state_55107[(2)]);
var inst_55091 = fluree.db.util.async.throw_err(inst_55090);
var inst_55092 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_55091);
var inst_55093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55094 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55096 = [inst_55091];
var inst_55097 = (new cljs.core.PersistentVector(null,1,(5),inst_55095,inst_55096,null));
var inst_55098 = ["str",inst_55097,inst_55092];
var inst_55099 = cljs.core.PersistentHashMap.fromArrays(inst_55094,inst_55098);
var inst_55100 = [inst_55099,(10)];
var inst_55101 = (new cljs.core.PersistentVector(null,2,(5),inst_55093,inst_55100,null));
var inst_55102 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55101);
var _ = (function (){var statearr_55116 = state_55107;
(statearr_55116[(4)] = cljs.core.rest((state_55107[(4)])));

return statearr_55116;
})();
var state_55107__$1 = (function (){var statearr_55117 = state_55107;
(statearr_55117[(7)] = inst_55102);

return statearr_55117;
})();
var statearr_55118_55131 = state_55107__$1;
(statearr_55118_55131[(2)] = inst_55092);

(statearr_55118_55131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55119 = [null,null,null,null,null,null,null,null];
(statearr_55119[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55119[(1)] = (1));

return statearr_55119;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55107){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55107);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55120){var ex__2882__auto__ = e55120;
var statearr_55121_55132 = state_55107;
(statearr_55121_55132[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55107[(4)]))){
var statearr_55122_55133 = state_55107;
(statearr_55122_55133[(1)] = cljs.core.first((state_55107[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55134 = state_55107;
state_55107 = G__55134;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55123 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55123[(6)] = c__2901__auto__);

return statearr_55123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq55080){
var G__55081 = cljs.core.first(seq55080);
var seq55080__$1 = cljs.core.next(seq55080);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55081,seq55080__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55160){
var state_val_55161 = (state_55160[(1)]);
if((state_val_55161 === (1))){
var state_55160__$1 = state_55160;
var statearr_55162_55177 = state_55160__$1;
(statearr_55162_55177[(2)] = null);

(statearr_55162_55177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (2))){
var _ = (function (){var statearr_55163 = state_55160;
(statearr_55163[(4)] = cljs.core.cons((5),(state_55160[(4)])));

return statearr_55163;
})();
var inst_55141 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55160__$1 = state_55160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55160__$1,(6),inst_55141);
} else {
if((state_val_55161 === (3))){
var inst_55158 = (state_55160[(2)]);
var state_55160__$1 = state_55160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55160__$1,inst_55158);
} else {
if((state_val_55161 === (4))){
var inst_55135 = (state_55160[(2)]);
var state_55160__$1 = state_55160;
var statearr_55165_55178 = state_55160__$1;
(statearr_55165_55178[(2)] = inst_55135);

(statearr_55165_55178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (5))){
var _ = (function (){var statearr_55166 = state_55160;
(statearr_55166[(4)] = cljs.core.rest((state_55160[(4)])));

return statearr_55166;
})();
var state_55160__$1 = state_55160;
var ex55164 = (state_55160__$1[(2)]);
var statearr_55167_55179 = state_55160__$1;
(statearr_55167_55179[(5)] = ex55164);


if((ex55164 instanceof Error)){
var statearr_55168_55180 = state_55160__$1;
(statearr_55168_55180[(1)] = (4));

(statearr_55168_55180[(5)] = null);

} else {
throw ex55164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (6))){
var inst_55143 = (state_55160[(2)]);
var inst_55144 = fluree.db.util.async.throw_err(inst_55143);
var inst_55145 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_55144);
var inst_55146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55147 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55149 = [inst_55144];
var inst_55150 = (new cljs.core.PersistentVector(null,1,(5),inst_55148,inst_55149,null));
var inst_55151 = ["subs",inst_55150,inst_55145];
var inst_55152 = cljs.core.PersistentHashMap.fromArrays(inst_55147,inst_55151);
var inst_55153 = [inst_55152,(30)];
var inst_55154 = (new cljs.core.PersistentVector(null,2,(5),inst_55146,inst_55153,null));
var inst_55155 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55154);
var _ = (function (){var statearr_55169 = state_55160;
(statearr_55169[(4)] = cljs.core.rest((state_55160[(4)])));

return statearr_55169;
})();
var state_55160__$1 = (function (){var statearr_55170 = state_55160;
(statearr_55170[(7)] = inst_55155);

return statearr_55170;
})();
var statearr_55171_55181 = state_55160__$1;
(statearr_55171_55181[(2)] = inst_55145);

(statearr_55171_55181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0 = (function (){
var statearr_55172 = [null,null,null,null,null,null,null,null];
(statearr_55172[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__);

(statearr_55172[(1)] = (1));

return statearr_55172;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1 = (function (state_55160){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55160);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55173){var ex__2882__auto__ = e55173;
var statearr_55174_55182 = state_55160;
(statearr_55174_55182[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55160[(4)]))){
var statearr_55175_55183 = state_55160;
(statearr_55175_55183[(1)] = cljs.core.first((state_55160[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55184 = state_55160;
state_55160 = G__55184;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__ = function(state_55160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1.call(this,state_55160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55176 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55176[(6)] = c__2901__auto__);

return statearr_55176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55214){
var state_val_55215 = (state_55214[(1)]);
if((state_val_55215 === (7))){
var state_55214__$1 = state_55214;
var statearr_55216_55235 = state_55214__$1;
(statearr_55216_55235[(2)] = str);

(statearr_55216_55235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (1))){
var state_55214__$1 = state_55214;
var statearr_55217_55236 = state_55214__$1;
(statearr_55217_55236[(2)] = null);

(statearr_55217_55236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (4))){
var inst_55185 = (state_55214[(2)]);
var state_55214__$1 = state_55214;
var statearr_55218_55237 = state_55214__$1;
(statearr_55218_55237[(2)] = inst_55185);

(statearr_55218_55237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (6))){
var state_55214__$1 = state_55214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55214__$1,(9),str);
} else {
if((state_val_55215 === (3))){
var inst_55212 = (state_55214[(2)]);
var state_55214__$1 = state_55214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55214__$1,inst_55212);
} else {
if((state_val_55215 === (2))){
var _ = (function (){var statearr_55220 = state_55214;
(statearr_55220[(4)] = cljs.core.cons((5),(state_55214[(4)])));

return statearr_55220;
})();
var inst_55191 = fluree.db.util.async.channel_QMARK_(str);
var state_55214__$1 = state_55214;
if(inst_55191){
var statearr_55221_55238 = state_55214__$1;
(statearr_55221_55238[(1)] = (6));

} else {
var statearr_55222_55239 = state_55214__$1;
(statearr_55222_55239[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (9))){
var inst_55194 = (state_55214[(2)]);
var inst_55195 = fluree.db.util.async.throw_err(inst_55194);
var state_55214__$1 = state_55214;
var statearr_55223_55240 = state_55214__$1;
(statearr_55223_55240[(2)] = inst_55195);

(statearr_55223_55240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (5))){
var _ = (function (){var statearr_55224 = state_55214;
(statearr_55224[(4)] = cljs.core.rest((state_55214[(4)])));

return statearr_55224;
})();
var state_55214__$1 = state_55214;
var ex55219 = (state_55214__$1[(2)]);
var statearr_55225_55241 = state_55214__$1;
(statearr_55225_55241[(5)] = ex55219);


if((ex55219 instanceof Error)){
var statearr_55226_55242 = state_55214__$1;
(statearr_55226_55242[(1)] = (4));

(statearr_55226_55242[(5)] = null);

} else {
throw ex55219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (8))){
var inst_55198 = (state_55214[(2)]);
var inst_55199 = fluree.db.dbfunctions.internal.lower_case(inst_55198);
var inst_55200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55201 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55203 = [inst_55198];
var inst_55204 = (new cljs.core.PersistentVector(null,1,(5),inst_55202,inst_55203,null));
var inst_55205 = ["lower-case",inst_55204,inst_55199];
var inst_55206 = cljs.core.PersistentHashMap.fromArrays(inst_55201,inst_55205);
var inst_55207 = [inst_55206,(10)];
var inst_55208 = (new cljs.core.PersistentVector(null,2,(5),inst_55200,inst_55207,null));
var inst_55209 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55208);
var _ = (function (){var statearr_55227 = state_55214;
(statearr_55227[(4)] = cljs.core.rest((state_55214[(4)])));

return statearr_55227;
})();
var state_55214__$1 = (function (){var statearr_55228 = state_55214;
(statearr_55228[(7)] = inst_55209);

return statearr_55228;
})();
var statearr_55229_55243 = state_55214__$1;
(statearr_55229_55243[(2)] = inst_55199);

(statearr_55229_55243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0 = (function (){
var statearr_55230 = [null,null,null,null,null,null,null,null];
(statearr_55230[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__);

(statearr_55230[(1)] = (1));

return statearr_55230;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1 = (function (state_55214){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55214);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55231){var ex__2882__auto__ = e55231;
var statearr_55232_55244 = state_55214;
(statearr_55232_55244[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55214[(4)]))){
var statearr_55233_55245 = state_55214;
(statearr_55233_55245[(1)] = cljs.core.first((state_55214[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55246 = state_55214;
state_55214 = G__55246;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__ = function(state_55214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1.call(this,state_55214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55234 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55234[(6)] = c__2901__auto__);

return statearr_55234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55276){
var state_val_55277 = (state_55276[(1)]);
if((state_val_55277 === (7))){
var state_55276__$1 = state_55276;
var statearr_55278_55297 = state_55276__$1;
(statearr_55278_55297[(2)] = str);

(statearr_55278_55297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (1))){
var state_55276__$1 = state_55276;
var statearr_55279_55298 = state_55276__$1;
(statearr_55279_55298[(2)] = null);

(statearr_55279_55298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (4))){
var inst_55247 = (state_55276[(2)]);
var state_55276__$1 = state_55276;
var statearr_55280_55299 = state_55276__$1;
(statearr_55280_55299[(2)] = inst_55247);

(statearr_55280_55299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (6))){
var state_55276__$1 = state_55276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55276__$1,(9),str);
} else {
if((state_val_55277 === (3))){
var inst_55274 = (state_55276[(2)]);
var state_55276__$1 = state_55276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55276__$1,inst_55274);
} else {
if((state_val_55277 === (2))){
var _ = (function (){var statearr_55282 = state_55276;
(statearr_55282[(4)] = cljs.core.cons((5),(state_55276[(4)])));

return statearr_55282;
})();
var inst_55253 = fluree.db.util.async.channel_QMARK_(str);
var state_55276__$1 = state_55276;
if(inst_55253){
var statearr_55283_55300 = state_55276__$1;
(statearr_55283_55300[(1)] = (6));

} else {
var statearr_55284_55301 = state_55276__$1;
(statearr_55284_55301[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (9))){
var inst_55256 = (state_55276[(2)]);
var inst_55257 = fluree.db.util.async.throw_err(inst_55256);
var state_55276__$1 = state_55276;
var statearr_55285_55302 = state_55276__$1;
(statearr_55285_55302[(2)] = inst_55257);

(statearr_55285_55302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (5))){
var _ = (function (){var statearr_55286 = state_55276;
(statearr_55286[(4)] = cljs.core.rest((state_55276[(4)])));

return statearr_55286;
})();
var state_55276__$1 = state_55276;
var ex55281 = (state_55276__$1[(2)]);
var statearr_55287_55303 = state_55276__$1;
(statearr_55287_55303[(5)] = ex55281);


if((ex55281 instanceof Error)){
var statearr_55288_55304 = state_55276__$1;
(statearr_55288_55304[(1)] = (4));

(statearr_55288_55304[(5)] = null);

} else {
throw ex55281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55277 === (8))){
var inst_55260 = (state_55276[(2)]);
var inst_55261 = fluree.db.dbfunctions.internal.upper_case(inst_55260);
var inst_55262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55263 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55265 = [inst_55260];
var inst_55266 = (new cljs.core.PersistentVector(null,1,(5),inst_55264,inst_55265,null));
var inst_55267 = ["upper-case",inst_55266,inst_55261];
var inst_55268 = cljs.core.PersistentHashMap.fromArrays(inst_55263,inst_55267);
var inst_55269 = [inst_55268,(10)];
var inst_55270 = (new cljs.core.PersistentVector(null,2,(5),inst_55262,inst_55269,null));
var inst_55271 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55270);
var _ = (function (){var statearr_55289 = state_55276;
(statearr_55289[(4)] = cljs.core.rest((state_55276[(4)])));

return statearr_55289;
})();
var state_55276__$1 = (function (){var statearr_55290 = state_55276;
(statearr_55290[(7)] = inst_55271);

return statearr_55290;
})();
var statearr_55291_55305 = state_55276__$1;
(statearr_55291_55305[(2)] = inst_55261);

(statearr_55291_55305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0 = (function (){
var statearr_55292 = [null,null,null,null,null,null,null,null];
(statearr_55292[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__);

(statearr_55292[(1)] = (1));

return statearr_55292;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1 = (function (state_55276){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55276);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55293){var ex__2882__auto__ = e55293;
var statearr_55294_55306 = state_55276;
(statearr_55294_55306[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55276[(4)]))){
var statearr_55295_55307 = state_55276;
(statearr_55295_55307[(1)] = cljs.core.first((state_55276[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55308 = state_55276;
state_55276 = G__55308;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__ = function(state_55276){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1.call(this,state_55276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55296 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55296[(6)] = c__2901__auto__);

return statearr_55296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__55310 = arguments.length;
switch (G__55310) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55338){
var state_val_55339 = (state_55338[(1)]);
if((state_val_55339 === (1))){
var state_55338__$1 = state_55338;
var statearr_55340_55356 = state_55338__$1;
(statearr_55340_55356[(2)] = null);

(statearr_55340_55356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55339 === (2))){
var _ = (function (){var statearr_55341 = state_55338;
(statearr_55341[(4)] = cljs.core.cons((5),(state_55338[(4)])));

return statearr_55341;
})();
var inst_55320 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_55338__$1 = state_55338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55338__$1,(6),inst_55320);
} else {
if((state_val_55339 === (3))){
var inst_55336 = (state_55338[(2)]);
var state_55338__$1 = state_55338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55338__$1,inst_55336);
} else {
if((state_val_55339 === (4))){
var inst_55311 = (state_55338[(2)]);
var state_55338__$1 = state_55338;
var statearr_55343_55357 = state_55338__$1;
(statearr_55343_55357[(2)] = inst_55311);

(statearr_55343_55357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55339 === (5))){
var _ = (function (){var statearr_55344 = state_55338;
(statearr_55344[(4)] = cljs.core.rest((state_55338[(4)])));

return statearr_55344;
})();
var state_55338__$1 = state_55338;
var ex55342 = (state_55338__$1[(2)]);
var statearr_55345_55358 = state_55338__$1;
(statearr_55345_55358[(5)] = ex55342);


if((ex55342 instanceof Error)){
var statearr_55346_55359 = state_55338__$1;
(statearr_55346_55359[(1)] = (4));

(statearr_55346_55359[(5)] = null);

} else {
throw ex55342;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55339 === (6))){
var inst_55322 = (state_55338[(2)]);
var inst_55323 = fluree.db.util.async.throw_err(inst_55322);
var inst_55324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55323,(0),null);
var inst_55325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55323,(1),null);
var inst_55326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55328 = ["?s","?ctx",inst_55324];
var inst_55329 = cljs.core.PersistentHashMap.fromArrays(inst_55327,inst_55328);
var inst_55330 = ((10) + inst_55325);
var inst_55331 = [inst_55329,inst_55330];
var inst_55332 = (new cljs.core.PersistentVector(null,2,(5),inst_55326,inst_55331,null));
var inst_55333 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55332);
var _ = (function (){var statearr_55347 = state_55338;
(statearr_55347[(4)] = cljs.core.rest((state_55338[(4)])));

return statearr_55347;
})();
var state_55338__$1 = (function (){var statearr_55348 = state_55338;
(statearr_55348[(7)] = inst_55333);

return statearr_55348;
})();
var statearr_55349_55360 = state_55338__$1;
(statearr_55349_55360[(2)] = inst_55324);

(statearr_55349_55360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55350 = [null,null,null,null,null,null,null,null];
(statearr_55350[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55350[(1)] = (1));

return statearr_55350;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55338){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55338);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55351){var ex__2882__auto__ = e55351;
var statearr_55352_55361 = state_55338;
(statearr_55352_55361[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55338[(4)]))){
var statearr_55353_55362 = state_55338;
(statearr_55353_55362[(1)] = cljs.core.first((state_55338[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55363 = state_55338;
state_55338 = G__55363;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55338){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55354 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55354[(6)] = c__2901__auto__);

return statearr_55354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__55365 = arguments.length;
switch (G__55365) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55403){
var state_val_55404 = (state_55403[(1)]);
if((state_val_55404 === (7))){
var inst_55396 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_55403__$1 = state_55403;
var statearr_55405_55425 = state_55403__$1;
(statearr_55405_55425[(2)] = inst_55396);

(statearr_55405_55425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (1))){
var state_55403__$1 = state_55403;
var statearr_55406_55426 = state_55403__$1;
(statearr_55406_55426[(2)] = null);

(statearr_55406_55426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (4))){
var inst_55366 = (state_55403[(2)]);
var state_55403__$1 = state_55403;
var statearr_55407_55427 = state_55403__$1;
(statearr_55407_55427[(2)] = inst_55366);

(statearr_55407_55427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (6))){
var inst_55377 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55403__$1,(10),inst_55377);
} else {
if((state_val_55404 === (3))){
var inst_55401 = (state_55403[(2)]);
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55403__$1,inst_55401);
} else {
if((state_val_55404 === (2))){
var _ = (function (){var statearr_55409 = state_55403;
(statearr_55409[(4)] = cljs.core.cons((5),(state_55403[(4)])));

return statearr_55409;
})();
var inst_55372 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55403__$1 = state_55403;
if(cljs.core.truth_(inst_55372)){
var statearr_55410_55428 = state_55403__$1;
(statearr_55410_55428[(1)] = (6));

} else {
var statearr_55411_55429 = state_55403__$1;
(statearr_55411_55429[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (9))){
var inst_55383 = (state_55403[(2)]);
var inst_55384 = fluree.db.util.async.throw_err(inst_55383);
var inst_55385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55384,(0),null);
var inst_55386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55384,(1),null);
var inst_55387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55388 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55389 = ["?p","?ctx",inst_55385];
var inst_55390 = cljs.core.PersistentHashMap.fromArrays(inst_55388,inst_55389);
var inst_55391 = ((10) + inst_55386);
var inst_55392 = [inst_55390,inst_55391];
var inst_55393 = (new cljs.core.PersistentVector(null,2,(5),inst_55387,inst_55392,null));
var inst_55394 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55393);
var state_55403__$1 = (function (){var statearr_55412 = state_55403;
(statearr_55412[(7)] = inst_55394);

return statearr_55412;
})();
var statearr_55413_55430 = state_55403__$1;
(statearr_55413_55430[(2)] = inst_55385);

(statearr_55413_55430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (5))){
var _ = (function (){var statearr_55414 = state_55403;
(statearr_55414[(4)] = cljs.core.rest((state_55403[(4)])));

return statearr_55414;
})();
var state_55403__$1 = state_55403;
var ex55408 = (state_55403__$1[(2)]);
var statearr_55415_55431 = state_55403__$1;
(statearr_55415_55431[(5)] = ex55408);


if((ex55408 instanceof Error)){
var statearr_55416_55432 = state_55403__$1;
(statearr_55416_55432[(1)] = (4));

(statearr_55416_55432[(5)] = null);

} else {
throw ex55408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (10))){
var inst_55379 = (state_55403[(2)]);
var inst_55380 = fluree.db.util.async.throw_err(inst_55379);
var inst_55381 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_55380);
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55403__$1,(9),inst_55381);
} else {
if((state_val_55404 === (8))){
var inst_55398 = (state_55403[(2)]);
var _ = (function (){var statearr_55417 = state_55403;
(statearr_55417[(4)] = cljs.core.rest((state_55403[(4)])));

return statearr_55417;
})();
var state_55403__$1 = state_55403;
var statearr_55418_55433 = state_55403__$1;
(statearr_55418_55433[(2)] = inst_55398);

(statearr_55418_55433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55419 = [null,null,null,null,null,null,null,null];
(statearr_55419[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55419[(1)] = (1));

return statearr_55419;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55403){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55403);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55420){var ex__2882__auto__ = e55420;
var statearr_55421_55434 = state_55403;
(statearr_55421_55434[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55403[(4)]))){
var statearr_55422_55435 = state_55403;
(statearr_55422_55435[(1)] = cljs.core.first((state_55403[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55436 = state_55403;
state_55403 = G__55436;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55423 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55423[(6)] = c__2901__auto__);

return statearr_55423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55485 = arguments.length;
var i__4737__auto___55486 = (0);
while(true){
if((i__4737__auto___55486 < len__4736__auto___55485)){
args__4742__auto__.push((arguments[i__4737__auto___55486]));

var G__55487 = (i__4737__auto___55486 + (1));
i__4737__auto___55486 = G__55487;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55468){
var state_val_55469 = (state_55468[(1)]);
if((state_val_55469 === (1))){
var state_55468__$1 = state_55468;
var statearr_55470_55488 = state_55468__$1;
(statearr_55470_55488[(2)] = null);

(statearr_55470_55488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (2))){
var _ = (function (){var statearr_55471 = state_55468;
(statearr_55471[(4)] = cljs.core.cons((5),(state_55468[(4)])));

return statearr_55471;
})();
var inst_55445 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55468__$1,(6),inst_55445);
} else {
if((state_val_55469 === (3))){
var inst_55466 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55468__$1,inst_55466);
} else {
if((state_val_55469 === (4))){
var inst_55439 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
var statearr_55473_55489 = state_55468__$1;
(statearr_55473_55489[(2)] = inst_55439);

(statearr_55473_55489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (5))){
var _ = (function (){var statearr_55474 = state_55468;
(statearr_55474[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55474;
})();
var state_55468__$1 = state_55468;
var ex55472 = (state_55468__$1[(2)]);
var statearr_55475_55490 = state_55468__$1;
(statearr_55475_55490[(5)] = ex55472);


if((ex55472 instanceof Error)){
var statearr_55476_55491 = state_55468__$1;
(statearr_55476_55491[(1)] = (4));

(statearr_55476_55491[(5)] = null);

} else {
throw ex55472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (6))){
var inst_55447 = (state_55468[(2)]);
var inst_55448 = fluree.db.util.async.throw_err(inst_55447);
var inst_55449 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_55448);
var inst_55450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55451 = [inst_55448];
var inst_55452 = (new cljs.core.PersistentVector(null,1,(5),inst_55450,inst_55451,null));
var inst_55453 = cljs.core.count(inst_55452);
var inst_55454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55455 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55457 = [inst_55448];
var inst_55458 = (new cljs.core.PersistentVector(null,1,(5),inst_55456,inst_55457,null));
var inst_55459 = ["and",inst_55458,inst_55449];
var inst_55460 = cljs.core.PersistentHashMap.fromArrays(inst_55455,inst_55459);
var inst_55461 = [inst_55460,inst_55453];
var inst_55462 = (new cljs.core.PersistentVector(null,2,(5),inst_55454,inst_55461,null));
var inst_55463 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55462);
var _ = (function (){var statearr_55477 = state_55468;
(statearr_55477[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55477;
})();
var state_55468__$1 = (function (){var statearr_55478 = state_55468;
(statearr_55478[(7)] = inst_55463);

return statearr_55478;
})();
var statearr_55479_55492 = state_55468__$1;
(statearr_55479_55492[(2)] = inst_55449);

(statearr_55479_55492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55480 = [null,null,null,null,null,null,null,null];
(statearr_55480[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55480[(1)] = (1));

return statearr_55480;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55468){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55468);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55481){var ex__2882__auto__ = e55481;
var statearr_55482_55493 = state_55468;
(statearr_55482_55493[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55468[(4)]))){
var statearr_55483_55494 = state_55468;
(statearr_55483_55494[(1)] = cljs.core.first((state_55468[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55495 = state_55468;
state_55468 = G__55495;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55484 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55484[(6)] = c__2901__auto__);

return statearr_55484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq55437){
var G__55438 = cljs.core.first(seq55437);
var seq55437__$1 = cljs.core.next(seq55437);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55438,seq55437__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55544 = arguments.length;
var i__4737__auto___55545 = (0);
while(true){
if((i__4737__auto___55545 < len__4736__auto___55544)){
args__4742__auto__.push((arguments[i__4737__auto___55545]));

var G__55546 = (i__4737__auto___55545 + (1));
i__4737__auto___55545 = G__55546;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55527){
var state_val_55528 = (state_55527[(1)]);
if((state_val_55528 === (1))){
var state_55527__$1 = state_55527;
var statearr_55529_55547 = state_55527__$1;
(statearr_55529_55547[(2)] = null);

(statearr_55529_55547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55528 === (2))){
var _ = (function (){var statearr_55530 = state_55527;
(statearr_55530[(4)] = cljs.core.cons((5),(state_55527[(4)])));

return statearr_55530;
})();
var inst_55504 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55527__$1 = state_55527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55527__$1,(6),inst_55504);
} else {
if((state_val_55528 === (3))){
var inst_55525 = (state_55527[(2)]);
var state_55527__$1 = state_55527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55527__$1,inst_55525);
} else {
if((state_val_55528 === (4))){
var inst_55498 = (state_55527[(2)]);
var state_55527__$1 = state_55527;
var statearr_55532_55548 = state_55527__$1;
(statearr_55532_55548[(2)] = inst_55498);

(statearr_55532_55548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55528 === (5))){
var _ = (function (){var statearr_55533 = state_55527;
(statearr_55533[(4)] = cljs.core.rest((state_55527[(4)])));

return statearr_55533;
})();
var state_55527__$1 = state_55527;
var ex55531 = (state_55527__$1[(2)]);
var statearr_55534_55549 = state_55527__$1;
(statearr_55534_55549[(5)] = ex55531);


if((ex55531 instanceof Error)){
var statearr_55535_55550 = state_55527__$1;
(statearr_55535_55550[(1)] = (4));

(statearr_55535_55550[(5)] = null);

} else {
throw ex55531;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55528 === (6))){
var inst_55506 = (state_55527[(2)]);
var inst_55507 = fluree.db.util.async.throw_err(inst_55506);
var inst_55508 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55507);
var inst_55509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55510 = [inst_55507];
var inst_55511 = (new cljs.core.PersistentVector(null,1,(5),inst_55509,inst_55510,null));
var inst_55512 = cljs.core.count(inst_55511);
var inst_55513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55514 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55516 = [inst_55507];
var inst_55517 = (new cljs.core.PersistentVector(null,1,(5),inst_55515,inst_55516,null));
var inst_55518 = ["or",inst_55517,inst_55508];
var inst_55519 = cljs.core.PersistentHashMap.fromArrays(inst_55514,inst_55518);
var inst_55520 = [inst_55519,inst_55512];
var inst_55521 = (new cljs.core.PersistentVector(null,2,(5),inst_55513,inst_55520,null));
var inst_55522 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55521);
var _ = (function (){var statearr_55536 = state_55527;
(statearr_55536[(4)] = cljs.core.rest((state_55527[(4)])));

return statearr_55536;
})();
var state_55527__$1 = (function (){var statearr_55537 = state_55527;
(statearr_55537[(7)] = inst_55522);

return statearr_55537;
})();
var statearr_55538_55551 = state_55527__$1;
(statearr_55538_55551[(2)] = inst_55508);

(statearr_55538_55551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55539 = [null,null,null,null,null,null,null,null];
(statearr_55539[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55539[(1)] = (1));

return statearr_55539;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55527){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55527);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55540){var ex__2882__auto__ = e55540;
var statearr_55541_55552 = state_55527;
(statearr_55541_55552[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55527[(4)]))){
var statearr_55542_55553 = state_55527;
(statearr_55542_55553[(1)] = cljs.core.first((state_55527[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55554 = state_55527;
state_55527 = G__55554;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55527){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55543 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55543[(6)] = c__2901__auto__);

return statearr_55543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55496){
var G__55497 = cljs.core.first(seq55496);
var seq55496__$1 = cljs.core.next(seq55496);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55497,seq55496__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55592){
var state_val_55593 = (state_55592[(1)]);
if((state_val_55593 === (7))){
var inst_55568 = fluree.db.util.async.channel_QMARK_(coll);
var state_55592__$1 = state_55592;
if(inst_55568){
var statearr_55594_55617 = state_55592__$1;
(statearr_55594_55617[(1)] = (10));

} else {
var statearr_55595_55618 = state_55592__$1;
(statearr_55595_55618[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (1))){
var state_55592__$1 = state_55592;
var statearr_55596_55619 = state_55592__$1;
(statearr_55596_55619[(2)] = null);

(statearr_55596_55619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (4))){
var inst_55555 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
var statearr_55597_55620 = state_55592__$1;
(statearr_55597_55620[(2)] = inst_55555);

(statearr_55597_55620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (13))){
var inst_55571 = (state_55592[(2)]);
var inst_55572 = fluree.db.util.async.throw_err(inst_55571);
var state_55592__$1 = state_55592;
var statearr_55598_55621 = state_55592__$1;
(statearr_55598_55621[(2)] = inst_55572);

(statearr_55598_55621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (6))){
var inst_55563 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(9),inst_55563);
} else {
if((state_val_55593 === (3))){
var inst_55590 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55592__$1,inst_55590);
} else {
if((state_val_55593 === (12))){
var inst_55575 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
var statearr_55599_55622 = state_55592__$1;
(statearr_55599_55622[(2)] = inst_55575);

(statearr_55599_55622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (2))){
var _ = (function (){var statearr_55600 = state_55592;
(statearr_55600[(4)] = cljs.core.cons((5),(state_55592[(4)])));

return statearr_55600;
})();
var inst_55561 = cljs.core.vector_QMARK_(coll);
var state_55592__$1 = state_55592;
if(inst_55561){
var statearr_55601_55623 = state_55592__$1;
(statearr_55601_55623[(1)] = (6));

} else {
var statearr_55602_55624 = state_55592__$1;
(statearr_55602_55624[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (11))){
var state_55592__$1 = state_55592;
var statearr_55604_55625 = state_55592__$1;
(statearr_55604_55625[(2)] = coll);

(statearr_55604_55625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (9))){
var inst_55565 = (state_55592[(2)]);
var inst_55566 = fluree.db.util.async.throw_err(inst_55565);
var state_55592__$1 = state_55592;
var statearr_55605_55626 = state_55592__$1;
(statearr_55605_55626[(2)] = inst_55566);

(statearr_55605_55626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (5))){
var _ = (function (){var statearr_55606 = state_55592;
(statearr_55606[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55606;
})();
var state_55592__$1 = state_55592;
var ex55603 = (state_55592__$1[(2)]);
var statearr_55607_55627 = state_55592__$1;
(statearr_55607_55627[(5)] = ex55603);


if((ex55603 instanceof Error)){
var statearr_55608_55628 = state_55592__$1;
(statearr_55608_55628[(1)] = (4));

(statearr_55608_55628[(5)] = null);

} else {
throw ex55603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (10))){
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(13),coll);
} else {
if((state_val_55593 === (8))){
var inst_55577 = (state_55592[(2)]);
var inst_55578 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55577);
var inst_55579 = cljs.core.count(inst_55578);
var inst_55580 = ((9) + inst_55579);
var inst_55581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55582 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55583 = ["count",inst_55577,inst_55579];
var inst_55584 = cljs.core.PersistentHashMap.fromArrays(inst_55582,inst_55583);
var inst_55585 = [inst_55584,inst_55580];
var inst_55586 = (new cljs.core.PersistentVector(null,2,(5),inst_55581,inst_55585,null));
var inst_55587 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55586);
var _ = (function (){var statearr_55609 = state_55592;
(statearr_55609[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55609;
})();
var state_55592__$1 = (function (){var statearr_55610 = state_55592;
(statearr_55610[(7)] = inst_55587);

return statearr_55610;
})();
var statearr_55611_55629 = state_55592__$1;
(statearr_55611_55629[(2)] = inst_55579);

(statearr_55611_55629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0 = (function (){
var statearr_55612 = [null,null,null,null,null,null,null,null];
(statearr_55612[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__);

(statearr_55612[(1)] = (1));

return statearr_55612;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1 = (function (state_55592){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55592);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55613){var ex__2882__auto__ = e55613;
var statearr_55614_55630 = state_55592;
(statearr_55614_55630[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55592[(4)]))){
var statearr_55615_55631 = state_55592;
(statearr_55615_55631[(1)] = cljs.core.first((state_55592[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55632 = state_55592;
state_55592 = G__55632;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__ = function(state_55592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1.call(this,state_55592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55616 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55616[(6)] = c__2901__auto__);

return statearr_55616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55682){
var state_val_55683 = (state_55682[(1)]);
if((state_val_55683 === (7))){
var state_55682__$1 = state_55682;
var statearr_55684_55717 = state_55682__$1;
(statearr_55684_55717[(2)] = subject);

(statearr_55684_55717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (1))){
var state_55682__$1 = state_55682;
var statearr_55685_55718 = state_55682__$1;
(statearr_55685_55718[(2)] = null);

(statearr_55685_55718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (4))){
var inst_55633 = (state_55682[(2)]);
var state_55682__$1 = state_55682;
var statearr_55686_55719 = state_55682__$1;
(statearr_55686_55719[(2)] = inst_55633);

(statearr_55686_55719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (15))){
var inst_55646 = (state_55682[(7)]);
var state_55682__$1 = state_55682;
var statearr_55687_55720 = state_55682__$1;
(statearr_55687_55720[(2)] = inst_55646);

(statearr_55687_55720[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (13))){
var inst_55650 = (state_55682[(2)]);
var inst_55651 = fluree.db.util.async.throw_err(inst_55650);
var state_55682__$1 = state_55682;
var statearr_55688_55721 = state_55682__$1;
(statearr_55688_55721[(2)] = inst_55651);

(statearr_55688_55721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (6))){
var state_55682__$1 = state_55682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55682__$1,(9),subject);
} else {
if((state_val_55683 === (17))){
var inst_55646 = (state_55682[(7)]);
var inst_55660 = cljs.core.first(inst_55646);
var state_55682__$1 = state_55682;
var statearr_55689_55722 = state_55682__$1;
(statearr_55689_55722[(2)] = inst_55660);

(statearr_55689_55722[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (3))){
var inst_55680 = (state_55682[(2)]);
var state_55682__$1 = state_55682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55682__$1,inst_55680);
} else {
if((state_val_55683 === (12))){
var inst_55646 = (state_55682[(7)]);
var inst_55654 = (state_55682[(2)]);
var inst_55655 = cljs.core.vector_QMARK_(inst_55646);
var state_55682__$1 = (function (){var statearr_55690 = state_55682;
(statearr_55690[(8)] = inst_55654);

return statearr_55690;
})();
if(inst_55655){
var statearr_55691_55723 = state_55682__$1;
(statearr_55691_55723[(1)] = (14));

} else {
var statearr_55692_55724 = state_55682__$1;
(statearr_55692_55724[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (2))){
var _ = (function (){var statearr_55693 = state_55682;
(statearr_55693[(4)] = cljs.core.cons((5),(state_55682[(4)])));

return statearr_55693;
})();
var inst_55639 = fluree.db.util.async.channel_QMARK_(subject);
var state_55682__$1 = state_55682;
if(inst_55639){
var statearr_55694_55725 = state_55682__$1;
(statearr_55694_55725[(1)] = (6));

} else {
var statearr_55695_55726 = state_55682__$1;
(statearr_55695_55726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (19))){
var inst_55663 = (state_55682[(2)]);
var state_55682__$1 = state_55682;
var statearr_55696_55727 = state_55682__$1;
(statearr_55696_55727[(2)] = inst_55663);

(statearr_55696_55727[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (11))){
var state_55682__$1 = state_55682;
var statearr_55698_55728 = state_55682__$1;
(statearr_55698_55728[(2)] = pred);

(statearr_55698_55728[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (9))){
var inst_55642 = (state_55682[(2)]);
var inst_55643 = fluree.db.util.async.throw_err(inst_55642);
var state_55682__$1 = state_55682;
var statearr_55699_55729 = state_55682__$1;
(statearr_55699_55729[(2)] = inst_55643);

(statearr_55699_55729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (5))){
var _ = (function (){var statearr_55700 = state_55682;
(statearr_55700[(4)] = cljs.core.rest((state_55682[(4)])));

return statearr_55700;
})();
var state_55682__$1 = state_55682;
var ex55697 = (state_55682__$1[(2)]);
var statearr_55701_55730 = state_55682__$1;
(statearr_55701_55730[(5)] = ex55697);


if((ex55697 instanceof Error)){
var statearr_55702_55731 = state_55682__$1;
(statearr_55702_55731[(1)] = (4));

(statearr_55702_55731[(5)] = null);

} else {
throw ex55697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (14))){
var inst_55646 = (state_55682[(7)]);
var inst_55657 = cljs.core.count(inst_55646);
var inst_55658 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55657);
var state_55682__$1 = state_55682;
if(inst_55658){
var statearr_55703_55732 = state_55682__$1;
(statearr_55703_55732[(1)] = (17));

} else {
var statearr_55704_55733 = state_55682__$1;
(statearr_55704_55733[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (16))){
var inst_55654 = (state_55682[(8)]);
var inst_55646 = (state_55682[(7)]);
var inst_55666 = (state_55682[(2)]);
var inst_55667 = fluree.db.dbfunctions.internal.get(inst_55666,inst_55654);
var inst_55668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55669 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55671 = [inst_55646,inst_55654];
var inst_55672 = (new cljs.core.PersistentVector(null,2,(5),inst_55670,inst_55671,null));
var inst_55673 = ["get",inst_55672,inst_55667];
var inst_55674 = cljs.core.PersistentHashMap.fromArrays(inst_55669,inst_55673);
var inst_55675 = [inst_55674,(10)];
var inst_55676 = (new cljs.core.PersistentVector(null,2,(5),inst_55668,inst_55675,null));
var inst_55677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55676);
var _ = (function (){var statearr_55705 = state_55682;
(statearr_55705[(4)] = cljs.core.rest((state_55682[(4)])));

return statearr_55705;
})();
var state_55682__$1 = (function (){var statearr_55706 = state_55682;
(statearr_55706[(9)] = inst_55677);

return statearr_55706;
})();
var statearr_55707_55734 = state_55682__$1;
(statearr_55707_55734[(2)] = inst_55667);

(statearr_55707_55734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (10))){
var state_55682__$1 = state_55682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55682__$1,(13),pred);
} else {
if((state_val_55683 === (18))){
var inst_55646 = (state_55682[(7)]);
var state_55682__$1 = state_55682;
var statearr_55708_55735 = state_55682__$1;
(statearr_55708_55735[(2)] = inst_55646);

(statearr_55708_55735[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55683 === (8))){
var inst_55646 = (state_55682[(2)]);
var inst_55647 = fluree.db.util.async.channel_QMARK_(pred);
var state_55682__$1 = (function (){var statearr_55709 = state_55682;
(statearr_55709[(7)] = inst_55646);

return statearr_55709;
})();
if(inst_55647){
var statearr_55710_55736 = state_55682__$1;
(statearr_55710_55736[(1)] = (10));

} else {
var statearr_55711_55737 = state_55682__$1;
(statearr_55711_55737[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0 = (function (){
var statearr_55712 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55712[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__);

(statearr_55712[(1)] = (1));

return statearr_55712;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1 = (function (state_55682){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55682);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55713){var ex__2882__auto__ = e55713;
var statearr_55714_55738 = state_55682;
(statearr_55714_55738[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55682[(4)]))){
var statearr_55715_55739 = state_55682;
(statearr_55715_55739[(1)] = cljs.core.first((state_55682[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55740 = state_55682;
state_55682 = G__55740;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__ = function(state_55682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1.call(this,state_55682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55716 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55716[(6)] = c__2901__auto__);

return statearr_55716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55779){
var state_val_55780 = (state_55779[(1)]);
if((state_val_55780 === (7))){
var inst_55747 = (state_55779[(7)]);
var state_55779__$1 = state_55779;
var statearr_55781_55805 = state_55779__$1;
(statearr_55781_55805[(2)] = inst_55747);

(statearr_55781_55805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (1))){
var state_55779__$1 = state_55779;
var statearr_55782_55806 = state_55779__$1;
(statearr_55782_55806[(2)] = null);

(statearr_55782_55806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (4))){
var inst_55741 = (state_55779[(2)]);
var state_55779__$1 = state_55779;
var statearr_55783_55807 = state_55779__$1;
(statearr_55783_55807[(2)] = inst_55741);

(statearr_55783_55807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (6))){
var inst_55749 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55779__$1 = state_55779;
var statearr_55784_55808 = state_55779__$1;
(statearr_55784_55808[(2)] = inst_55749);

(statearr_55784_55808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (3))){
var inst_55777 = (state_55779[(2)]);
var state_55779__$1 = state_55779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55779__$1,inst_55777);
} else {
if((state_val_55780 === (12))){
var inst_55759 = (state_55779[(2)]);
var inst_55760 = fluree.db.util.async.throw_err(inst_55759);
var inst_55761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55760,(0),null);
var inst_55762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55760,(1),null);
var inst_55763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55765 = ["?pO","?ctx",inst_55761];
var inst_55766 = cljs.core.PersistentHashMap.fromArrays(inst_55764,inst_55765);
var inst_55767 = ((10) + inst_55762);
var inst_55768 = [inst_55766,inst_55767];
var inst_55769 = (new cljs.core.PersistentVector(null,2,(5),inst_55763,inst_55768,null));
var inst_55770 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55769);
var state_55779__$1 = (function (){var statearr_55785 = state_55779;
(statearr_55785[(8)] = inst_55770);

return statearr_55785;
})();
var statearr_55786_55809 = state_55779__$1;
(statearr_55786_55809[(2)] = inst_55761);

(statearr_55786_55809[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (2))){
var inst_55747 = (state_55779[(7)]);
var _ = (function (){var statearr_55787 = state_55779;
(statearr_55787[(4)] = cljs.core.cons((5),(state_55779[(4)])));

return statearr_55787;
})();
var inst_55747__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55779__$1 = (function (){var statearr_55788 = state_55779;
(statearr_55788[(7)] = inst_55747__$1);

return statearr_55788;
})();
if(cljs.core.truth_(inst_55747__$1)){
var statearr_55789_55810 = state_55779__$1;
(statearr_55789_55810[(1)] = (6));

} else {
var statearr_55790_55811 = state_55779__$1;
(statearr_55790_55811[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (11))){
var inst_55774 = (state_55779[(2)]);
var _ = (function (){var statearr_55792 = state_55779;
(statearr_55792[(4)] = cljs.core.rest((state_55779[(4)])));

return statearr_55792;
})();
var state_55779__$1 = state_55779;
var statearr_55793_55812 = state_55779__$1;
(statearr_55793_55812[(2)] = inst_55774);

(statearr_55793_55812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (9))){
var inst_55757 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55779__$1 = state_55779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55779__$1,(12),inst_55757);
} else {
if((state_val_55780 === (5))){
var _ = (function (){var statearr_55794 = state_55779;
(statearr_55794[(4)] = cljs.core.rest((state_55779[(4)])));

return statearr_55794;
})();
var state_55779__$1 = state_55779;
var ex55791 = (state_55779__$1[(2)]);
var statearr_55795_55813 = state_55779__$1;
(statearr_55795_55813[(5)] = ex55791);


if((ex55791 instanceof Error)){
var statearr_55796_55814 = state_55779__$1;
(statearr_55796_55814[(1)] = (4));

(statearr_55796_55814[(5)] = null);

} else {
throw ex55791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (10))){
var inst_55772 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55779__$1 = state_55779;
var statearr_55797_55815 = state_55779__$1;
(statearr_55797_55815[(2)] = inst_55772);

(statearr_55797_55815[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (8))){
var inst_55752 = (state_55779[(2)]);
var state_55779__$1 = state_55779;
if(cljs.core.truth_(inst_55752)){
var statearr_55798_55816 = state_55779__$1;
(statearr_55798_55816[(1)] = (9));

} else {
var statearr_55799_55817 = state_55779__$1;
(statearr_55799_55817[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0 = (function (){
var statearr_55800 = [null,null,null,null,null,null,null,null,null];
(statearr_55800[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__);

(statearr_55800[(1)] = (1));

return statearr_55800;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1 = (function (state_55779){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55779);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55801){var ex__2882__auto__ = e55801;
var statearr_55802_55818 = state_55779;
(statearr_55802_55818[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55779[(4)]))){
var statearr_55803_55819 = state_55779;
(statearr_55803_55819[(1)] = cljs.core.first((state_55779[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55820 = state_55779;
state_55779 = G__55820;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__ = function(state_55779){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1.call(this,state_55779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55804 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55804[(6)] = c__2901__auto__);

return statearr_55804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55872){
var state_val_55873 = (state_55872[(1)]);
if((state_val_55873 === (7))){
var state_55872__$1 = state_55872;
var statearr_55874_55907 = state_55872__$1;
(statearr_55874_55907[(2)] = subject);

(statearr_55874_55907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (1))){
var state_55872__$1 = state_55872;
var statearr_55875_55908 = state_55872__$1;
(statearr_55875_55908[(2)] = null);

(statearr_55875_55908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (4))){
var inst_55821 = (state_55872[(2)]);
var state_55872__$1 = state_55872;
var statearr_55876_55909 = state_55872__$1;
(statearr_55876_55909[(2)] = inst_55821);

(statearr_55876_55909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (15))){
var inst_55834 = (state_55872[(7)]);
var state_55872__$1 = state_55872;
var statearr_55877_55910 = state_55872__$1;
(statearr_55877_55910[(2)] = inst_55834);

(statearr_55877_55910[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (13))){
var inst_55838 = (state_55872[(2)]);
var inst_55839 = fluree.db.util.async.throw_err(inst_55838);
var state_55872__$1 = state_55872;
var statearr_55878_55911 = state_55872__$1;
(statearr_55878_55911[(2)] = inst_55839);

(statearr_55878_55911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (6))){
var state_55872__$1 = state_55872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55872__$1,(9),subject);
} else {
if((state_val_55873 === (17))){
var inst_55834 = (state_55872[(7)]);
var inst_55848 = cljs.core.first(inst_55834);
var state_55872__$1 = state_55872;
var statearr_55879_55912 = state_55872__$1;
(statearr_55879_55912[(2)] = inst_55848);

(statearr_55879_55912[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (3))){
var inst_55870 = (state_55872[(2)]);
var state_55872__$1 = state_55872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55872__$1,inst_55870);
} else {
if((state_val_55873 === (12))){
var inst_55834 = (state_55872[(7)]);
var inst_55842 = (state_55872[(2)]);
var inst_55843 = cljs.core.vector_QMARK_(inst_55834);
var state_55872__$1 = (function (){var statearr_55880 = state_55872;
(statearr_55880[(8)] = inst_55842);

return statearr_55880;
})();
if(inst_55843){
var statearr_55881_55913 = state_55872__$1;
(statearr_55881_55913[(1)] = (14));

} else {
var statearr_55882_55914 = state_55872__$1;
(statearr_55882_55914[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (2))){
var _ = (function (){var statearr_55883 = state_55872;
(statearr_55883[(4)] = cljs.core.cons((5),(state_55872[(4)])));

return statearr_55883;
})();
var inst_55827 = fluree.db.util.async.channel_QMARK_(subject);
var state_55872__$1 = state_55872;
if(inst_55827){
var statearr_55884_55915 = state_55872__$1;
(statearr_55884_55915[(1)] = (6));

} else {
var statearr_55885_55916 = state_55872__$1;
(statearr_55885_55916[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (19))){
var inst_55851 = (state_55872[(2)]);
var state_55872__$1 = state_55872;
var statearr_55886_55917 = state_55872__$1;
(statearr_55886_55917[(2)] = inst_55851);

(statearr_55886_55917[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (11))){
var state_55872__$1 = state_55872;
var statearr_55888_55918 = state_55872__$1;
(statearr_55888_55918[(2)] = path);

(statearr_55888_55918[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (9))){
var inst_55830 = (state_55872[(2)]);
var inst_55831 = fluree.db.util.async.throw_err(inst_55830);
var state_55872__$1 = state_55872;
var statearr_55889_55919 = state_55872__$1;
(statearr_55889_55919[(2)] = inst_55831);

(statearr_55889_55919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (5))){
var _ = (function (){var statearr_55890 = state_55872;
(statearr_55890[(4)] = cljs.core.rest((state_55872[(4)])));

return statearr_55890;
})();
var state_55872__$1 = state_55872;
var ex55887 = (state_55872__$1[(2)]);
var statearr_55891_55920 = state_55872__$1;
(statearr_55891_55920[(5)] = ex55887);


if((ex55887 instanceof Error)){
var statearr_55892_55921 = state_55872__$1;
(statearr_55892_55921[(1)] = (4));

(statearr_55892_55921[(5)] = null);

} else {
throw ex55887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (14))){
var inst_55834 = (state_55872[(7)]);
var inst_55845 = cljs.core.count(inst_55834);
var inst_55846 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55845);
var state_55872__$1 = state_55872;
if(inst_55846){
var statearr_55893_55922 = state_55872__$1;
(statearr_55893_55922[(1)] = (17));

} else {
var statearr_55894_55923 = state_55872__$1;
(statearr_55894_55923[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (16))){
var inst_55842 = (state_55872[(8)]);
var inst_55834 = (state_55872[(7)]);
var inst_55854 = (state_55872[(2)]);
var inst_55855 = fluree.db.dbfunctions.internal.get_all(inst_55854,inst_55842);
var inst_55856 = cljs.core.count(inst_55842);
var inst_55857 = ((9) + inst_55856);
var inst_55858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55859 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55861 = [inst_55834,inst_55842];
var inst_55862 = (new cljs.core.PersistentVector(null,2,(5),inst_55860,inst_55861,null));
var inst_55863 = ["get-all",inst_55862,inst_55855];
var inst_55864 = cljs.core.PersistentHashMap.fromArrays(inst_55859,inst_55863);
var inst_55865 = [inst_55864,inst_55857];
var inst_55866 = (new cljs.core.PersistentVector(null,2,(5),inst_55858,inst_55865,null));
var inst_55867 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55866);
var _ = (function (){var statearr_55895 = state_55872;
(statearr_55895[(4)] = cljs.core.rest((state_55872[(4)])));

return statearr_55895;
})();
var state_55872__$1 = (function (){var statearr_55896 = state_55872;
(statearr_55896[(9)] = inst_55867);

return statearr_55896;
})();
var statearr_55897_55924 = state_55872__$1;
(statearr_55897_55924[(2)] = inst_55855);

(statearr_55897_55924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (10))){
var state_55872__$1 = state_55872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55872__$1,(13),path);
} else {
if((state_val_55873 === (18))){
var inst_55834 = (state_55872[(7)]);
var state_55872__$1 = state_55872;
var statearr_55898_55925 = state_55872__$1;
(statearr_55898_55925[(2)] = inst_55834);

(statearr_55898_55925[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55873 === (8))){
var inst_55834 = (state_55872[(2)]);
var inst_55835 = fluree.db.util.async.channel_QMARK_(path);
var state_55872__$1 = (function (){var statearr_55899 = state_55872;
(statearr_55899[(7)] = inst_55834);

return statearr_55899;
})();
if(inst_55835){
var statearr_55900_55926 = state_55872__$1;
(statearr_55900_55926[(1)] = (10));

} else {
var statearr_55901_55927 = state_55872__$1;
(statearr_55901_55927[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0 = (function (){
var statearr_55902 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55902[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__);

(statearr_55902[(1)] = (1));

return statearr_55902;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1 = (function (state_55872){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55872);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55903){var ex__2882__auto__ = e55903;
var statearr_55904_55928 = state_55872;
(statearr_55904_55928[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55872[(4)]))){
var statearr_55905_55929 = state_55872;
(statearr_55905_55929[(1)] = cljs.core.first((state_55872[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55930 = state_55872;
state_55872 = G__55930;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__ = function(state_55872){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1.call(this,state_55872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55906 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55906[(6)] = c__2901__auto__);

return statearr_55906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55969){
var state_val_55970 = (state_55969[(1)]);
if((state_val_55970 === (7))){
var state_55969__$1 = state_55969;
var statearr_55971_55995 = state_55969__$1;
(statearr_55971_55995[(2)] = subject);

(statearr_55971_55995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (1))){
var state_55969__$1 = state_55969;
var statearr_55972_55996 = state_55969__$1;
(statearr_55972_55996[(2)] = null);

(statearr_55972_55996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (4))){
var inst_55931 = (state_55969[(2)]);
var state_55969__$1 = state_55969;
var statearr_55973_55997 = state_55969__$1;
(statearr_55973_55997[(2)] = inst_55931);

(statearr_55973_55997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (13))){
var inst_55948 = (state_55969[(2)]);
var inst_55949 = fluree.db.util.async.throw_err(inst_55948);
var state_55969__$1 = state_55969;
var statearr_55974_55998 = state_55969__$1;
(statearr_55974_55998[(2)] = inst_55949);

(statearr_55974_55998[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (6))){
var state_55969__$1 = state_55969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55969__$1,(9),subject);
} else {
if((state_val_55970 === (3))){
var inst_55967 = (state_55969[(2)]);
var state_55969__$1 = state_55969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55969__$1,inst_55967);
} else {
if((state_val_55970 === (12))){
var inst_55944 = (state_55969[(7)]);
var inst_55952 = (state_55969[(2)]);
var inst_55953 = fluree.db.dbfunctions.internal.get_in(inst_55944,inst_55952);
var inst_55954 = cljs.core.count(inst_55952);
var inst_55955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55956 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55958 = [inst_55944,inst_55952];
var inst_55959 = (new cljs.core.PersistentVector(null,2,(5),inst_55957,inst_55958,null));
var inst_55960 = ["get-in",inst_55959,inst_55953];
var inst_55961 = cljs.core.PersistentHashMap.fromArrays(inst_55956,inst_55960);
var inst_55962 = [inst_55961,inst_55954];
var inst_55963 = (new cljs.core.PersistentVector(null,2,(5),inst_55955,inst_55962,null));
var inst_55964 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55963);
var _ = (function (){var statearr_55975 = state_55969;
(statearr_55975[(4)] = cljs.core.rest((state_55969[(4)])));

return statearr_55975;
})();
var state_55969__$1 = (function (){var statearr_55976 = state_55969;
(statearr_55976[(8)] = inst_55964);

return statearr_55976;
})();
var statearr_55977_55999 = state_55969__$1;
(statearr_55977_55999[(2)] = inst_55953);

(statearr_55977_55999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (2))){
var _ = (function (){var statearr_55978 = state_55969;
(statearr_55978[(4)] = cljs.core.cons((5),(state_55969[(4)])));

return statearr_55978;
})();
var inst_55937 = fluree.db.util.async.channel_QMARK_(subject);
var state_55969__$1 = state_55969;
if(inst_55937){
var statearr_55979_56000 = state_55969__$1;
(statearr_55979_56000[(1)] = (6));

} else {
var statearr_55980_56001 = state_55969__$1;
(statearr_55980_56001[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (11))){
var state_55969__$1 = state_55969;
var statearr_55982_56002 = state_55969__$1;
(statearr_55982_56002[(2)] = path);

(statearr_55982_56002[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (9))){
var inst_55940 = (state_55969[(2)]);
var inst_55941 = fluree.db.util.async.throw_err(inst_55940);
var state_55969__$1 = state_55969;
var statearr_55983_56003 = state_55969__$1;
(statearr_55983_56003[(2)] = inst_55941);

(statearr_55983_56003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (5))){
var _ = (function (){var statearr_55984 = state_55969;
(statearr_55984[(4)] = cljs.core.rest((state_55969[(4)])));

return statearr_55984;
})();
var state_55969__$1 = state_55969;
var ex55981 = (state_55969__$1[(2)]);
var statearr_55985_56004 = state_55969__$1;
(statearr_55985_56004[(5)] = ex55981);


if((ex55981 instanceof Error)){
var statearr_55986_56005 = state_55969__$1;
(statearr_55986_56005[(1)] = (4));

(statearr_55986_56005[(5)] = null);

} else {
throw ex55981;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55970 === (10))){
var state_55969__$1 = state_55969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55969__$1,(13),path);
} else {
if((state_val_55970 === (8))){
var inst_55944 = (state_55969[(2)]);
var inst_55945 = fluree.db.util.async.channel_QMARK_(path);
var state_55969__$1 = (function (){var statearr_55987 = state_55969;
(statearr_55987[(7)] = inst_55944);

return statearr_55987;
})();
if(inst_55945){
var statearr_55988_56006 = state_55969__$1;
(statearr_55988_56006[(1)] = (10));

} else {
var statearr_55989_56007 = state_55969__$1;
(statearr_55989_56007[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0 = (function (){
var statearr_55990 = [null,null,null,null,null,null,null,null,null];
(statearr_55990[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__);

(statearr_55990[(1)] = (1));

return statearr_55990;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1 = (function (state_55969){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_55969);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55991){var ex__2882__auto__ = e55991;
var statearr_55992_56008 = state_55969;
(statearr_55992_56008[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_55969[(4)]))){
var statearr_55993_56009 = state_55969;
(statearr_55993_56009[(1)] = cljs.core.first((state_55969[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56010 = state_55969;
state_55969 = G__56010;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__ = function(state_55969){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1.call(this,state_55969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55994 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_55994[(6)] = c__2901__auto__);

return statearr_55994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56055){
var state_val_56056 = (state_56055[(1)]);
if((state_val_56056 === (7))){
var state_56055__$1 = state_56055;
var statearr_56057_56086 = state_56055__$1;
(statearr_56057_56086[(2)] = coll);

(statearr_56057_56086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (1))){
var state_56055__$1 = state_56055;
var statearr_56058_56087 = state_56055__$1;
(statearr_56058_56087[(2)] = null);

(statearr_56058_56087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (4))){
var inst_56011 = (state_56055[(2)]);
var state_56055__$1 = state_56055;
var statearr_56059_56088 = state_56055__$1;
(statearr_56059_56088[(2)] = inst_56011);

(statearr_56059_56088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (15))){
var inst_56031 = (state_56055[(7)]);
var inst_56039 = (state_56055[(2)]);
var inst_56040 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_56031,inst_56039);
var inst_56041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56042 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56044 = [inst_56031,inst_56039];
var inst_56045 = (new cljs.core.PersistentVector(null,2,(5),inst_56043,inst_56044,null));
var inst_56046 = ["contains?",inst_56045,inst_56040];
var inst_56047 = cljs.core.PersistentHashMap.fromArrays(inst_56042,inst_56046);
var inst_56048 = [inst_56047,(10)];
var inst_56049 = (new cljs.core.PersistentVector(null,2,(5),inst_56041,inst_56048,null));
var inst_56050 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56049);
var _ = (function (){var statearr_56060 = state_56055;
(statearr_56060[(4)] = cljs.core.rest((state_56055[(4)])));

return statearr_56060;
})();
var state_56055__$1 = (function (){var statearr_56061 = state_56055;
(statearr_56061[(8)] = inst_56050);

return statearr_56061;
})();
var statearr_56062_56089 = state_56055__$1;
(statearr_56062_56089[(2)] = inst_56040);

(statearr_56062_56089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (13))){
var state_56055__$1 = state_56055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56055__$1,(16),key);
} else {
if((state_val_56056 === (6))){
var state_56055__$1 = state_56055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56055__$1,(9),coll);
} else {
if((state_val_56056 === (3))){
var inst_56053 = (state_56055[(2)]);
var state_56055__$1 = state_56055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56055__$1,inst_56053);
} else {
if((state_val_56056 === (12))){
var inst_56031 = (state_56055[(2)]);
var inst_56032 = fluree.db.util.async.channel_QMARK_(key);
var state_56055__$1 = (function (){var statearr_56063 = state_56055;
(statearr_56063[(7)] = inst_56031);

return statearr_56063;
})();
if(inst_56032){
var statearr_56064_56090 = state_56055__$1;
(statearr_56064_56090[(1)] = (13));

} else {
var statearr_56065_56091 = state_56055__$1;
(statearr_56065_56091[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (2))){
var _ = (function (){var statearr_56066 = state_56055;
(statearr_56066[(4)] = cljs.core.cons((5),(state_56055[(4)])));

return statearr_56066;
})();
var inst_56017 = fluree.db.util.async.channel_QMARK_(coll);
var state_56055__$1 = state_56055;
if(inst_56017){
var statearr_56067_56092 = state_56055__$1;
(statearr_56067_56092[(1)] = (6));

} else {
var statearr_56068_56093 = state_56055__$1;
(statearr_56068_56093[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (11))){
var inst_56024 = (state_56055[(9)]);
var inst_56028 = cljs.core.flatten(inst_56024);
var inst_56029 = cljs.core.set(inst_56028);
var state_56055__$1 = state_56055;
var statearr_56070_56094 = state_56055__$1;
(statearr_56070_56094[(2)] = inst_56029);

(statearr_56070_56094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (9))){
var inst_56020 = (state_56055[(2)]);
var inst_56021 = fluree.db.util.async.throw_err(inst_56020);
var state_56055__$1 = state_56055;
var statearr_56071_56095 = state_56055__$1;
(statearr_56071_56095[(2)] = inst_56021);

(statearr_56071_56095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (5))){
var _ = (function (){var statearr_56072 = state_56055;
(statearr_56072[(4)] = cljs.core.rest((state_56055[(4)])));

return statearr_56072;
})();
var state_56055__$1 = state_56055;
var ex56069 = (state_56055__$1[(2)]);
var statearr_56073_56096 = state_56055__$1;
(statearr_56073_56096[(5)] = ex56069);


if((ex56069 instanceof Error)){
var statearr_56074_56097 = state_56055__$1;
(statearr_56074_56097[(1)] = (4));

(statearr_56074_56097[(5)] = null);

} else {
throw ex56069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (14))){
var state_56055__$1 = state_56055;
var statearr_56075_56098 = state_56055__$1;
(statearr_56075_56098[(2)] = key);

(statearr_56075_56098[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (16))){
var inst_56035 = (state_56055[(2)]);
var inst_56036 = fluree.db.util.async.throw_err(inst_56035);
var state_56055__$1 = state_56055;
var statearr_56076_56099 = state_56055__$1;
(statearr_56076_56099[(2)] = inst_56036);

(statearr_56076_56099[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (10))){
var inst_56024 = (state_56055[(9)]);
var state_56055__$1 = state_56055;
var statearr_56077_56100 = state_56055__$1;
(statearr_56077_56100[(2)] = inst_56024);

(statearr_56077_56100[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56056 === (8))){
var inst_56024 = (state_56055[(9)]);
var inst_56024__$1 = (state_56055[(2)]);
var inst_56025 = cljs.core.set_QMARK_(inst_56024__$1);
var state_56055__$1 = (function (){var statearr_56078 = state_56055;
(statearr_56078[(9)] = inst_56024__$1);

return statearr_56078;
})();
if(inst_56025){
var statearr_56079_56101 = state_56055__$1;
(statearr_56079_56101[(1)] = (10));

} else {
var statearr_56080_56102 = state_56055__$1;
(statearr_56080_56102[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_56081 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56081[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__);

(statearr_56081[(1)] = (1));

return statearr_56081;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1 = (function (state_56055){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56055);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56082){var ex__2882__auto__ = e56082;
var statearr_56083_56103 = state_56055;
(statearr_56083_56103[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56055[(4)]))){
var statearr_56084_56104 = state_56055;
(statearr_56084_56104[(1)] = cljs.core.first((state_56055[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56105 = state_56055;
state_56055 = G__56105;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__ = function(state_56055){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1.call(this,state_56055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56085 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56085[(6)] = c__2901__auto__);

return statearr_56085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56170 = arguments.length;
var i__4737__auto___56171 = (0);
while(true){
if((i__4737__auto___56171 < len__4736__auto___56170)){
args__4742__auto__.push((arguments[i__4737__auto___56171]));

var G__56172 = (i__4737__auto___56171 + (1));
i__4737__auto___56171 = G__56172;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56148){
var state_val_56149 = (state_56148[(1)]);
if((state_val_56149 === (7))){
var inst_56117 = (state_56148[(7)]);
var inst_56124 = cljs.core.first(inst_56117);
var state_56148__$1 = state_56148;
var statearr_56150_56173 = state_56148__$1;
(statearr_56150_56173[(2)] = inst_56124);

(statearr_56150_56173[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (1))){
var state_56148__$1 = state_56148;
var statearr_56151_56174 = state_56148__$1;
(statearr_56151_56174[(2)] = null);

(statearr_56151_56174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (4))){
var inst_56108 = (state_56148[(2)]);
var state_56148__$1 = state_56148;
var statearr_56152_56175 = state_56148__$1;
(statearr_56152_56175[(2)] = inst_56108);

(statearr_56152_56175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (6))){
var inst_56117 = (state_56148[(7)]);
var inst_56116 = (state_56148[(2)]);
var inst_56117__$1 = fluree.db.util.async.throw_err(inst_56116);
var inst_56118 = cljs.core.count(inst_56117__$1);
var inst_56119 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_56118);
var inst_56120 = cljs.core.first(inst_56117__$1);
var inst_56121 = cljs.core.coll_QMARK_(inst_56120);
var inst_56122 = ((inst_56119) && (inst_56121));
var state_56148__$1 = (function (){var statearr_56153 = state_56148;
(statearr_56153[(7)] = inst_56117__$1);

return statearr_56153;
})();
if(cljs.core.truth_(inst_56122)){
var statearr_56154_56176 = state_56148__$1;
(statearr_56154_56176[(1)] = (7));

} else {
var statearr_56155_56177 = state_56148__$1;
(statearr_56155_56177[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (3))){
var inst_56146 = (state_56148[(2)]);
var state_56148__$1 = state_56148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56148__$1,inst_56146);
} else {
if((state_val_56149 === (2))){
var _ = (function (){var statearr_56157 = state_56148;
(statearr_56157[(4)] = cljs.core.cons((5),(state_56148[(4)])));

return statearr_56157;
})();
var inst_56114 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56148__$1 = state_56148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56148__$1,(6),inst_56114);
} else {
if((state_val_56149 === (9))){
var inst_56127 = (state_56148[(2)]);
var inst_56128 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_56127);
var inst_56129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56130 = [inst_56127];
var inst_56131 = (new cljs.core.PersistentVector(null,1,(5),inst_56129,inst_56130,null));
var inst_56132 = cljs.core.count(inst_56131);
var inst_56133 = ((9) + inst_56132);
var inst_56134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56135 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56137 = [inst_56127];
var inst_56138 = (new cljs.core.PersistentVector(null,1,(5),inst_56136,inst_56137,null));
var inst_56139 = ["hash-set",inst_56138,inst_56128];
var inst_56140 = cljs.core.PersistentHashMap.fromArrays(inst_56135,inst_56139);
var inst_56141 = [inst_56140,inst_56133];
var inst_56142 = (new cljs.core.PersistentVector(null,2,(5),inst_56134,inst_56141,null));
var inst_56143 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56142);
var _ = (function (){var statearr_56158 = state_56148;
(statearr_56158[(4)] = cljs.core.rest((state_56148[(4)])));

return statearr_56158;
})();
var state_56148__$1 = (function (){var statearr_56159 = state_56148;
(statearr_56159[(8)] = inst_56143);

return statearr_56159;
})();
var statearr_56160_56178 = state_56148__$1;
(statearr_56160_56178[(2)] = inst_56128);

(statearr_56160_56178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (5))){
var _ = (function (){var statearr_56161 = state_56148;
(statearr_56161[(4)] = cljs.core.rest((state_56148[(4)])));

return statearr_56161;
})();
var state_56148__$1 = state_56148;
var ex56156 = (state_56148__$1[(2)]);
var statearr_56162_56179 = state_56148__$1;
(statearr_56162_56179[(5)] = ex56156);


if((ex56156 instanceof Error)){
var statearr_56163_56180 = state_56148__$1;
(statearr_56163_56180[(1)] = (4));

(statearr_56163_56180[(5)] = null);

} else {
throw ex56156;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (8))){
var inst_56117 = (state_56148[(7)]);
var state_56148__$1 = state_56148;
var statearr_56164_56181 = state_56148__$1;
(statearr_56164_56181[(2)] = inst_56117);

(statearr_56164_56181[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56165 = [null,null,null,null,null,null,null,null,null];
(statearr_56165[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56165[(1)] = (1));

return statearr_56165;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56148){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56148);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56166){var ex__2882__auto__ = e56166;
var statearr_56167_56182 = state_56148;
(statearr_56167_56182[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56148[(4)]))){
var statearr_56168_56183 = state_56148;
(statearr_56168_56183[(1)] = cljs.core.first((state_56148[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56184 = state_56148;
state_56148 = G__56184;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56148){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56169 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56169[(6)] = c__2901__auto__);

return statearr_56169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq56106){
var G__56107 = cljs.core.first(seq56106);
var seq56106__$1 = cljs.core.next(seq56106);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56107,seq56106__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56234 = arguments.length;
var i__4737__auto___56235 = (0);
while(true){
if((i__4737__auto___56235 < len__4736__auto___56234)){
args__4742__auto__.push((arguments[i__4737__auto___56235]));

var G__56236 = (i__4737__auto___56235 + (1));
i__4737__auto___56235 = G__56236;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56217){
var state_val_56218 = (state_56217[(1)]);
if((state_val_56218 === (1))){
var state_56217__$1 = state_56217;
var statearr_56219_56237 = state_56217__$1;
(statearr_56219_56237[(2)] = null);

(statearr_56219_56237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56218 === (2))){
var _ = (function (){var statearr_56220 = state_56217;
(statearr_56220[(4)] = cljs.core.cons((5),(state_56217[(4)])));

return statearr_56220;
})();
var inst_56193 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56217__$1 = state_56217;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56217__$1,(6),inst_56193);
} else {
if((state_val_56218 === (3))){
var inst_56215 = (state_56217[(2)]);
var state_56217__$1 = state_56217;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56217__$1,inst_56215);
} else {
if((state_val_56218 === (4))){
var inst_56187 = (state_56217[(2)]);
var state_56217__$1 = state_56217;
var statearr_56222_56238 = state_56217__$1;
(statearr_56222_56238[(2)] = inst_56187);

(statearr_56222_56238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56218 === (5))){
var _ = (function (){var statearr_56223 = state_56217;
(statearr_56223[(4)] = cljs.core.rest((state_56217[(4)])));

return statearr_56223;
})();
var state_56217__$1 = state_56217;
var ex56221 = (state_56217__$1[(2)]);
var statearr_56224_56239 = state_56217__$1;
(statearr_56224_56239[(5)] = ex56221);


if((ex56221 instanceof Error)){
var statearr_56225_56240 = state_56217__$1;
(statearr_56225_56240[(1)] = (4));

(statearr_56225_56240[(5)] = null);

} else {
throw ex56221;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56218 === (6))){
var inst_56195 = (state_56217[(2)]);
var inst_56196 = fluree.db.util.async.throw_err(inst_56195);
var inst_56197 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_56196);
var inst_56198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56199 = [inst_56196];
var inst_56200 = (new cljs.core.PersistentVector(null,1,(5),inst_56198,inst_56199,null));
var inst_56201 = cljs.core.count(inst_56200);
var inst_56202 = ((9) + inst_56201);
var inst_56203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56204 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56206 = [inst_56196];
var inst_56207 = (new cljs.core.PersistentVector(null,1,(5),inst_56205,inst_56206,null));
var inst_56208 = ["==",inst_56207,inst_56197];
var inst_56209 = cljs.core.PersistentHashMap.fromArrays(inst_56204,inst_56208);
var inst_56210 = [inst_56209,inst_56202];
var inst_56211 = (new cljs.core.PersistentVector(null,2,(5),inst_56203,inst_56210,null));
var inst_56212 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56211);
var _ = (function (){var statearr_56226 = state_56217;
(statearr_56226[(4)] = cljs.core.rest((state_56217[(4)])));

return statearr_56226;
})();
var state_56217__$1 = (function (){var statearr_56227 = state_56217;
(statearr_56227[(7)] = inst_56212);

return statearr_56227;
})();
var statearr_56228_56241 = state_56217__$1;
(statearr_56228_56241[(2)] = inst_56197);

(statearr_56228_56241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56229 = [null,null,null,null,null,null,null,null];
(statearr_56229[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56229[(1)] = (1));

return statearr_56229;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56217){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56217);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56230){var ex__2882__auto__ = e56230;
var statearr_56231_56242 = state_56217;
(statearr_56231_56242[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56217[(4)]))){
var statearr_56232_56243 = state_56217;
(statearr_56232_56243[(1)] = cljs.core.first((state_56217[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56244 = state_56217;
state_56217 = G__56244;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56233 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56233[(6)] = c__2901__auto__);

return statearr_56233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq56185){
var G__56186 = cljs.core.first(seq56185);
var seq56185__$1 = cljs.core.next(seq56185);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56186,seq56185__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56294 = arguments.length;
var i__4737__auto___56295 = (0);
while(true){
if((i__4737__auto___56295 < len__4736__auto___56294)){
args__4742__auto__.push((arguments[i__4737__auto___56295]));

var G__56296 = (i__4737__auto___56295 + (1));
i__4737__auto___56295 = G__56296;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56277){
var state_val_56278 = (state_56277[(1)]);
if((state_val_56278 === (1))){
var state_56277__$1 = state_56277;
var statearr_56279_56297 = state_56277__$1;
(statearr_56279_56297[(2)] = null);

(statearr_56279_56297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56278 === (2))){
var _ = (function (){var statearr_56280 = state_56277;
(statearr_56280[(4)] = cljs.core.cons((5),(state_56277[(4)])));

return statearr_56280;
})();
var inst_56253 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56277__$1 = state_56277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56277__$1,(6),inst_56253);
} else {
if((state_val_56278 === (3))){
var inst_56275 = (state_56277[(2)]);
var state_56277__$1 = state_56277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56277__$1,inst_56275);
} else {
if((state_val_56278 === (4))){
var inst_56247 = (state_56277[(2)]);
var state_56277__$1 = state_56277;
var statearr_56282_56298 = state_56277__$1;
(statearr_56282_56298[(2)] = inst_56247);

(statearr_56282_56298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56278 === (5))){
var _ = (function (){var statearr_56283 = state_56277;
(statearr_56283[(4)] = cljs.core.rest((state_56277[(4)])));

return statearr_56283;
})();
var state_56277__$1 = state_56277;
var ex56281 = (state_56277__$1[(2)]);
var statearr_56284_56299 = state_56277__$1;
(statearr_56284_56299[(5)] = ex56281);


if((ex56281 instanceof Error)){
var statearr_56285_56300 = state_56277__$1;
(statearr_56285_56300[(1)] = (4));

(statearr_56285_56300[(5)] = null);

} else {
throw ex56281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56278 === (6))){
var inst_56255 = (state_56277[(2)]);
var inst_56256 = fluree.db.util.async.throw_err(inst_56255);
var inst_56257 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_56256);
var inst_56258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56259 = [inst_56256];
var inst_56260 = (new cljs.core.PersistentVector(null,1,(5),inst_56258,inst_56259,null));
var inst_56261 = cljs.core.count(inst_56260);
var inst_56262 = ((9) + inst_56261);
var inst_56263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56264 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56266 = [inst_56256];
var inst_56267 = (new cljs.core.PersistentVector(null,1,(5),inst_56265,inst_56266,null));
var inst_56268 = [">",inst_56267,inst_56257];
var inst_56269 = cljs.core.PersistentHashMap.fromArrays(inst_56264,inst_56268);
var inst_56270 = [inst_56269,inst_56262];
var inst_56271 = (new cljs.core.PersistentVector(null,2,(5),inst_56263,inst_56270,null));
var inst_56272 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56271);
var _ = (function (){var statearr_56286 = state_56277;
(statearr_56286[(4)] = cljs.core.rest((state_56277[(4)])));

return statearr_56286;
})();
var state_56277__$1 = (function (){var statearr_56287 = state_56277;
(statearr_56287[(7)] = inst_56272);

return statearr_56287;
})();
var statearr_56288_56301 = state_56277__$1;
(statearr_56288_56301[(2)] = inst_56257);

(statearr_56288_56301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56289 = [null,null,null,null,null,null,null,null];
(statearr_56289[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56289[(1)] = (1));

return statearr_56289;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56277){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56277);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56290){var ex__2882__auto__ = e56290;
var statearr_56291_56302 = state_56277;
(statearr_56291_56302[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56277[(4)]))){
var statearr_56292_56303 = state_56277;
(statearr_56292_56303[(1)] = cljs.core.first((state_56277[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56304 = state_56277;
state_56277 = G__56304;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56293 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56293[(6)] = c__2901__auto__);

return statearr_56293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq56245){
var G__56246 = cljs.core.first(seq56245);
var seq56245__$1 = cljs.core.next(seq56245);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56246,seq56245__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56354 = arguments.length;
var i__4737__auto___56355 = (0);
while(true){
if((i__4737__auto___56355 < len__4736__auto___56354)){
args__4742__auto__.push((arguments[i__4737__auto___56355]));

var G__56356 = (i__4737__auto___56355 + (1));
i__4737__auto___56355 = G__56356;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56337){
var state_val_56338 = (state_56337[(1)]);
if((state_val_56338 === (1))){
var state_56337__$1 = state_56337;
var statearr_56339_56357 = state_56337__$1;
(statearr_56339_56357[(2)] = null);

(statearr_56339_56357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (2))){
var _ = (function (){var statearr_56340 = state_56337;
(statearr_56340[(4)] = cljs.core.cons((5),(state_56337[(4)])));

return statearr_56340;
})();
var inst_56313 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56337__$1 = state_56337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56337__$1,(6),inst_56313);
} else {
if((state_val_56338 === (3))){
var inst_56335 = (state_56337[(2)]);
var state_56337__$1 = state_56337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56337__$1,inst_56335);
} else {
if((state_val_56338 === (4))){
var inst_56307 = (state_56337[(2)]);
var state_56337__$1 = state_56337;
var statearr_56342_56358 = state_56337__$1;
(statearr_56342_56358[(2)] = inst_56307);

(statearr_56342_56358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (5))){
var _ = (function (){var statearr_56343 = state_56337;
(statearr_56343[(4)] = cljs.core.rest((state_56337[(4)])));

return statearr_56343;
})();
var state_56337__$1 = state_56337;
var ex56341 = (state_56337__$1[(2)]);
var statearr_56344_56359 = state_56337__$1;
(statearr_56344_56359[(5)] = ex56341);


if((ex56341 instanceof Error)){
var statearr_56345_56360 = state_56337__$1;
(statearr_56345_56360[(1)] = (4));

(statearr_56345_56360[(5)] = null);

} else {
throw ex56341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (6))){
var inst_56315 = (state_56337[(2)]);
var inst_56316 = fluree.db.util.async.throw_err(inst_56315);
var inst_56317 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_56316);
var inst_56318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56319 = [inst_56316];
var inst_56320 = (new cljs.core.PersistentVector(null,1,(5),inst_56318,inst_56319,null));
var inst_56321 = cljs.core.count(inst_56320);
var inst_56322 = ((9) + inst_56321);
var inst_56323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56324 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56326 = [inst_56316];
var inst_56327 = (new cljs.core.PersistentVector(null,1,(5),inst_56325,inst_56326,null));
var inst_56328 = ["<",inst_56327,inst_56317];
var inst_56329 = cljs.core.PersistentHashMap.fromArrays(inst_56324,inst_56328);
var inst_56330 = [inst_56329,inst_56322];
var inst_56331 = (new cljs.core.PersistentVector(null,2,(5),inst_56323,inst_56330,null));
var inst_56332 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56331);
var _ = (function (){var statearr_56346 = state_56337;
(statearr_56346[(4)] = cljs.core.rest((state_56337[(4)])));

return statearr_56346;
})();
var state_56337__$1 = (function (){var statearr_56347 = state_56337;
(statearr_56347[(7)] = inst_56332);

return statearr_56347;
})();
var statearr_56348_56361 = state_56337__$1;
(statearr_56348_56361[(2)] = inst_56317);

(statearr_56348_56361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56349 = [null,null,null,null,null,null,null,null];
(statearr_56349[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56349[(1)] = (1));

return statearr_56349;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56337){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56337);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56350){var ex__2882__auto__ = e56350;
var statearr_56351_56362 = state_56337;
(statearr_56351_56362[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56337[(4)]))){
var statearr_56352_56363 = state_56337;
(statearr_56352_56363[(1)] = cljs.core.first((state_56337[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56364 = state_56337;
state_56337 = G__56364;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56337){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56353 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56353[(6)] = c__2901__auto__);

return statearr_56353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq56305){
var G__56306 = cljs.core.first(seq56305);
var seq56305__$1 = cljs.core.next(seq56305);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56306,seq56305__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56414 = arguments.length;
var i__4737__auto___56415 = (0);
while(true){
if((i__4737__auto___56415 < len__4736__auto___56414)){
args__4742__auto__.push((arguments[i__4737__auto___56415]));

var G__56416 = (i__4737__auto___56415 + (1));
i__4737__auto___56415 = G__56416;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56397){
var state_val_56398 = (state_56397[(1)]);
if((state_val_56398 === (1))){
var state_56397__$1 = state_56397;
var statearr_56399_56417 = state_56397__$1;
(statearr_56399_56417[(2)] = null);

(statearr_56399_56417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56398 === (2))){
var _ = (function (){var statearr_56400 = state_56397;
(statearr_56400[(4)] = cljs.core.cons((5),(state_56397[(4)])));

return statearr_56400;
})();
var inst_56373 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56397__$1 = state_56397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56397__$1,(6),inst_56373);
} else {
if((state_val_56398 === (3))){
var inst_56395 = (state_56397[(2)]);
var state_56397__$1 = state_56397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56397__$1,inst_56395);
} else {
if((state_val_56398 === (4))){
var inst_56367 = (state_56397[(2)]);
var state_56397__$1 = state_56397;
var statearr_56402_56418 = state_56397__$1;
(statearr_56402_56418[(2)] = inst_56367);

(statearr_56402_56418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56398 === (5))){
var _ = (function (){var statearr_56403 = state_56397;
(statearr_56403[(4)] = cljs.core.rest((state_56397[(4)])));

return statearr_56403;
})();
var state_56397__$1 = state_56397;
var ex56401 = (state_56397__$1[(2)]);
var statearr_56404_56419 = state_56397__$1;
(statearr_56404_56419[(5)] = ex56401);


if((ex56401 instanceof Error)){
var statearr_56405_56420 = state_56397__$1;
(statearr_56405_56420[(1)] = (4));

(statearr_56405_56420[(5)] = null);

} else {
throw ex56401;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56398 === (6))){
var inst_56375 = (state_56397[(2)]);
var inst_56376 = fluree.db.util.async.throw_err(inst_56375);
var inst_56377 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_56376);
var inst_56378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56379 = [inst_56376];
var inst_56380 = (new cljs.core.PersistentVector(null,1,(5),inst_56378,inst_56379,null));
var inst_56381 = cljs.core.count(inst_56380);
var inst_56382 = ((9) + inst_56381);
var inst_56383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56384 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56386 = [inst_56376];
var inst_56387 = (new cljs.core.PersistentVector(null,1,(5),inst_56385,inst_56386,null));
var inst_56388 = ["<=",inst_56387,inst_56377];
var inst_56389 = cljs.core.PersistentHashMap.fromArrays(inst_56384,inst_56388);
var inst_56390 = [inst_56389,inst_56382];
var inst_56391 = (new cljs.core.PersistentVector(null,2,(5),inst_56383,inst_56390,null));
var inst_56392 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56391);
var _ = (function (){var statearr_56406 = state_56397;
(statearr_56406[(4)] = cljs.core.rest((state_56397[(4)])));

return statearr_56406;
})();
var state_56397__$1 = (function (){var statearr_56407 = state_56397;
(statearr_56407[(7)] = inst_56392);

return statearr_56407;
})();
var statearr_56408_56421 = state_56397__$1;
(statearr_56408_56421[(2)] = inst_56377);

(statearr_56408_56421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56409 = [null,null,null,null,null,null,null,null];
(statearr_56409[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56409[(1)] = (1));

return statearr_56409;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56397){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56397);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56410){var ex__2882__auto__ = e56410;
var statearr_56411_56422 = state_56397;
(statearr_56411_56422[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56397[(4)]))){
var statearr_56412_56423 = state_56397;
(statearr_56412_56423[(1)] = cljs.core.first((state_56397[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56424 = state_56397;
state_56397 = G__56424;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56397){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56413 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56413[(6)] = c__2901__auto__);

return statearr_56413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56365){
var G__56366 = cljs.core.first(seq56365);
var seq56365__$1 = cljs.core.next(seq56365);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56366,seq56365__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56474 = arguments.length;
var i__4737__auto___56475 = (0);
while(true){
if((i__4737__auto___56475 < len__4736__auto___56474)){
args__4742__auto__.push((arguments[i__4737__auto___56475]));

var G__56476 = (i__4737__auto___56475 + (1));
i__4737__auto___56475 = G__56476;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56457){
var state_val_56458 = (state_56457[(1)]);
if((state_val_56458 === (1))){
var state_56457__$1 = state_56457;
var statearr_56459_56477 = state_56457__$1;
(statearr_56459_56477[(2)] = null);

(statearr_56459_56477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56458 === (2))){
var _ = (function (){var statearr_56460 = state_56457;
(statearr_56460[(4)] = cljs.core.cons((5),(state_56457[(4)])));

return statearr_56460;
})();
var inst_56433 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56457__$1 = state_56457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56457__$1,(6),inst_56433);
} else {
if((state_val_56458 === (3))){
var inst_56455 = (state_56457[(2)]);
var state_56457__$1 = state_56457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56457__$1,inst_56455);
} else {
if((state_val_56458 === (4))){
var inst_56427 = (state_56457[(2)]);
var state_56457__$1 = state_56457;
var statearr_56462_56478 = state_56457__$1;
(statearr_56462_56478[(2)] = inst_56427);

(statearr_56462_56478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56458 === (5))){
var _ = (function (){var statearr_56463 = state_56457;
(statearr_56463[(4)] = cljs.core.rest((state_56457[(4)])));

return statearr_56463;
})();
var state_56457__$1 = state_56457;
var ex56461 = (state_56457__$1[(2)]);
var statearr_56464_56479 = state_56457__$1;
(statearr_56464_56479[(5)] = ex56461);


if((ex56461 instanceof Error)){
var statearr_56465_56480 = state_56457__$1;
(statearr_56465_56480[(1)] = (4));

(statearr_56465_56480[(5)] = null);

} else {
throw ex56461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56458 === (6))){
var inst_56435 = (state_56457[(2)]);
var inst_56436 = fluree.db.util.async.throw_err(inst_56435);
var inst_56437 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_56436);
var inst_56438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56439 = [inst_56436];
var inst_56440 = (new cljs.core.PersistentVector(null,1,(5),inst_56438,inst_56439,null));
var inst_56441 = cljs.core.count(inst_56440);
var inst_56442 = ((9) + inst_56441);
var inst_56443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56444 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56446 = [inst_56436];
var inst_56447 = (new cljs.core.PersistentVector(null,1,(5),inst_56445,inst_56446,null));
var inst_56448 = [">=",inst_56447,inst_56437];
var inst_56449 = cljs.core.PersistentHashMap.fromArrays(inst_56444,inst_56448);
var inst_56450 = [inst_56449,inst_56442];
var inst_56451 = (new cljs.core.PersistentVector(null,2,(5),inst_56443,inst_56450,null));
var inst_56452 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56451);
var _ = (function (){var statearr_56466 = state_56457;
(statearr_56466[(4)] = cljs.core.rest((state_56457[(4)])));

return statearr_56466;
})();
var state_56457__$1 = (function (){var statearr_56467 = state_56457;
(statearr_56467[(7)] = inst_56452);

return statearr_56467;
})();
var statearr_56468_56481 = state_56457__$1;
(statearr_56468_56481[(2)] = inst_56437);

(statearr_56468_56481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56469 = [null,null,null,null,null,null,null,null];
(statearr_56469[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56469[(1)] = (1));

return statearr_56469;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56457){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56457);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56470){var ex__2882__auto__ = e56470;
var statearr_56471_56482 = state_56457;
(statearr_56471_56482[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56457[(4)]))){
var statearr_56472_56483 = state_56457;
(statearr_56472_56483[(1)] = cljs.core.first((state_56457[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56484 = state_56457;
state_56457 = G__56484;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56457){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56473 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56473[(6)] = c__2901__auto__);

return statearr_56473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56425){
var G__56426 = cljs.core.first(seq56425);
var seq56425__$1 = cljs.core.next(seq56425);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56426,seq56425__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56534 = arguments.length;
var i__4737__auto___56535 = (0);
while(true){
if((i__4737__auto___56535 < len__4736__auto___56534)){
args__4742__auto__.push((arguments[i__4737__auto___56535]));

var G__56536 = (i__4737__auto___56535 + (1));
i__4737__auto___56535 = G__56536;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56517){
var state_val_56518 = (state_56517[(1)]);
if((state_val_56518 === (1))){
var state_56517__$1 = state_56517;
var statearr_56519_56537 = state_56517__$1;
(statearr_56519_56537[(2)] = null);

(statearr_56519_56537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56518 === (2))){
var _ = (function (){var statearr_56520 = state_56517;
(statearr_56520[(4)] = cljs.core.cons((5),(state_56517[(4)])));

return statearr_56520;
})();
var inst_56493 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56517__$1 = state_56517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56517__$1,(6),inst_56493);
} else {
if((state_val_56518 === (3))){
var inst_56515 = (state_56517[(2)]);
var state_56517__$1 = state_56517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56517__$1,inst_56515);
} else {
if((state_val_56518 === (4))){
var inst_56487 = (state_56517[(2)]);
var state_56517__$1 = state_56517;
var statearr_56522_56538 = state_56517__$1;
(statearr_56522_56538[(2)] = inst_56487);

(statearr_56522_56538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56518 === (5))){
var _ = (function (){var statearr_56523 = state_56517;
(statearr_56523[(4)] = cljs.core.rest((state_56517[(4)])));

return statearr_56523;
})();
var state_56517__$1 = state_56517;
var ex56521 = (state_56517__$1[(2)]);
var statearr_56524_56539 = state_56517__$1;
(statearr_56524_56539[(5)] = ex56521);


if((ex56521 instanceof Error)){
var statearr_56525_56540 = state_56517__$1;
(statearr_56525_56540[(1)] = (4));

(statearr_56525_56540[(5)] = null);

} else {
throw ex56521;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56518 === (6))){
var inst_56495 = (state_56517[(2)]);
var inst_56496 = fluree.db.util.async.throw_err(inst_56495);
var inst_56497 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56496);
var inst_56498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56499 = [inst_56496];
var inst_56500 = (new cljs.core.PersistentVector(null,1,(5),inst_56498,inst_56499,null));
var inst_56501 = cljs.core.count(inst_56500);
var inst_56502 = ((9) + inst_56501);
var inst_56503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56504 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56506 = [inst_56496];
var inst_56507 = (new cljs.core.PersistentVector(null,1,(5),inst_56505,inst_56506,null));
var inst_56508 = ["not=",inst_56507,inst_56497];
var inst_56509 = cljs.core.PersistentHashMap.fromArrays(inst_56504,inst_56508);
var inst_56510 = [inst_56509,inst_56502];
var inst_56511 = (new cljs.core.PersistentVector(null,2,(5),inst_56503,inst_56510,null));
var inst_56512 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56511);
var _ = (function (){var statearr_56526 = state_56517;
(statearr_56526[(4)] = cljs.core.rest((state_56517[(4)])));

return statearr_56526;
})();
var state_56517__$1 = (function (){var statearr_56527 = state_56517;
(statearr_56527[(7)] = inst_56512);

return statearr_56527;
})();
var statearr_56528_56541 = state_56517__$1;
(statearr_56528_56541[(2)] = inst_56497);

(statearr_56528_56541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56529 = [null,null,null,null,null,null,null,null];
(statearr_56529[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56529[(1)] = (1));

return statearr_56529;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56517){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56517);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56530){var ex__2882__auto__ = e56530;
var statearr_56531_56542 = state_56517;
(statearr_56531_56542[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56517[(4)]))){
var statearr_56532_56543 = state_56517;
(statearr_56532_56543[(1)] = cljs.core.first((state_56517[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56544 = state_56517;
state_56517 = G__56544;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56517){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56533 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56533[(6)] = c__2901__auto__);

return statearr_56533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56485){
var G__56486 = cljs.core.first(seq56485);
var seq56485__$1 = cljs.core.next(seq56485);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56486,seq56485__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56594 = arguments.length;
var i__4737__auto___56595 = (0);
while(true){
if((i__4737__auto___56595 < len__4736__auto___56594)){
args__4742__auto__.push((arguments[i__4737__auto___56595]));

var G__56596 = (i__4737__auto___56595 + (1));
i__4737__auto___56595 = G__56596;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56577){
var state_val_56578 = (state_56577[(1)]);
if((state_val_56578 === (1))){
var state_56577__$1 = state_56577;
var statearr_56579_56597 = state_56577__$1;
(statearr_56579_56597[(2)] = null);

(statearr_56579_56597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (2))){
var _ = (function (){var statearr_56580 = state_56577;
(statearr_56580[(4)] = cljs.core.cons((5),(state_56577[(4)])));

return statearr_56580;
})();
var inst_56553 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56577__$1 = state_56577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56577__$1,(6),inst_56553);
} else {
if((state_val_56578 === (3))){
var inst_56575 = (state_56577[(2)]);
var state_56577__$1 = state_56577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56577__$1,inst_56575);
} else {
if((state_val_56578 === (4))){
var inst_56547 = (state_56577[(2)]);
var state_56577__$1 = state_56577;
var statearr_56582_56598 = state_56577__$1;
(statearr_56582_56598[(2)] = inst_56547);

(statearr_56582_56598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (5))){
var _ = (function (){var statearr_56583 = state_56577;
(statearr_56583[(4)] = cljs.core.rest((state_56577[(4)])));

return statearr_56583;
})();
var state_56577__$1 = state_56577;
var ex56581 = (state_56577__$1[(2)]);
var statearr_56584_56599 = state_56577__$1;
(statearr_56584_56599[(5)] = ex56581);


if((ex56581 instanceof Error)){
var statearr_56585_56600 = state_56577__$1;
(statearr_56585_56600[(1)] = (4));

(statearr_56585_56600[(5)] = null);

} else {
throw ex56581;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (6))){
var inst_56555 = (state_56577[(2)]);
var inst_56556 = fluree.db.util.async.throw_err(inst_56555);
var inst_56557 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56556);
var inst_56558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56559 = [inst_56556];
var inst_56560 = (new cljs.core.PersistentVector(null,1,(5),inst_56558,inst_56559,null));
var inst_56561 = cljs.core.count(inst_56560);
var inst_56562 = ((9) + inst_56561);
var inst_56563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56564 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56566 = [inst_56556];
var inst_56567 = (new cljs.core.PersistentVector(null,1,(5),inst_56565,inst_56566,null));
var inst_56568 = ["max",inst_56567,inst_56557];
var inst_56569 = cljs.core.PersistentHashMap.fromArrays(inst_56564,inst_56568);
var inst_56570 = [inst_56569,inst_56562];
var inst_56571 = (new cljs.core.PersistentVector(null,2,(5),inst_56563,inst_56570,null));
var inst_56572 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56571);
var _ = (function (){var statearr_56586 = state_56577;
(statearr_56586[(4)] = cljs.core.rest((state_56577[(4)])));

return statearr_56586;
})();
var state_56577__$1 = (function (){var statearr_56587 = state_56577;
(statearr_56587[(7)] = inst_56572);

return statearr_56587;
})();
var statearr_56588_56601 = state_56577__$1;
(statearr_56588_56601[(2)] = inst_56557);

(statearr_56588_56601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56589 = [null,null,null,null,null,null,null,null];
(statearr_56589[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56589[(1)] = (1));

return statearr_56589;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56577){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56577);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56590){var ex__2882__auto__ = e56590;
var statearr_56591_56602 = state_56577;
(statearr_56591_56602[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56577[(4)]))){
var statearr_56592_56603 = state_56577;
(statearr_56592_56603[(1)] = cljs.core.first((state_56577[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56604 = state_56577;
state_56577 = G__56604;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56577){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56593 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56593[(6)] = c__2901__auto__);

return statearr_56593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56545){
var G__56546 = cljs.core.first(seq56545);
var seq56545__$1 = cljs.core.next(seq56545);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56546,seq56545__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56654 = arguments.length;
var i__4737__auto___56655 = (0);
while(true){
if((i__4737__auto___56655 < len__4736__auto___56654)){
args__4742__auto__.push((arguments[i__4737__auto___56655]));

var G__56656 = (i__4737__auto___56655 + (1));
i__4737__auto___56655 = G__56656;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56637){
var state_val_56638 = (state_56637[(1)]);
if((state_val_56638 === (1))){
var state_56637__$1 = state_56637;
var statearr_56639_56657 = state_56637__$1;
(statearr_56639_56657[(2)] = null);

(statearr_56639_56657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56638 === (2))){
var _ = (function (){var statearr_56640 = state_56637;
(statearr_56640[(4)] = cljs.core.cons((5),(state_56637[(4)])));

return statearr_56640;
})();
var inst_56613 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56637__$1 = state_56637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56637__$1,(6),inst_56613);
} else {
if((state_val_56638 === (3))){
var inst_56635 = (state_56637[(2)]);
var state_56637__$1 = state_56637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56637__$1,inst_56635);
} else {
if((state_val_56638 === (4))){
var inst_56607 = (state_56637[(2)]);
var state_56637__$1 = state_56637;
var statearr_56642_56658 = state_56637__$1;
(statearr_56642_56658[(2)] = inst_56607);

(statearr_56642_56658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56638 === (5))){
var _ = (function (){var statearr_56643 = state_56637;
(statearr_56643[(4)] = cljs.core.rest((state_56637[(4)])));

return statearr_56643;
})();
var state_56637__$1 = state_56637;
var ex56641 = (state_56637__$1[(2)]);
var statearr_56644_56659 = state_56637__$1;
(statearr_56644_56659[(5)] = ex56641);


if((ex56641 instanceof Error)){
var statearr_56645_56660 = state_56637__$1;
(statearr_56645_56660[(1)] = (4));

(statearr_56645_56660[(5)] = null);

} else {
throw ex56641;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56638 === (6))){
var inst_56615 = (state_56637[(2)]);
var inst_56616 = fluree.db.util.async.throw_err(inst_56615);
var inst_56617 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56616);
var inst_56618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56619 = [inst_56616];
var inst_56620 = (new cljs.core.PersistentVector(null,1,(5),inst_56618,inst_56619,null));
var inst_56621 = cljs.core.count(inst_56620);
var inst_56622 = ((9) + inst_56621);
var inst_56623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56624 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56626 = [inst_56616];
var inst_56627 = (new cljs.core.PersistentVector(null,1,(5),inst_56625,inst_56626,null));
var inst_56628 = ["min",inst_56627,inst_56617];
var inst_56629 = cljs.core.PersistentHashMap.fromArrays(inst_56624,inst_56628);
var inst_56630 = [inst_56629,inst_56622];
var inst_56631 = (new cljs.core.PersistentVector(null,2,(5),inst_56623,inst_56630,null));
var inst_56632 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56631);
var _ = (function (){var statearr_56646 = state_56637;
(statearr_56646[(4)] = cljs.core.rest((state_56637[(4)])));

return statearr_56646;
})();
var state_56637__$1 = (function (){var statearr_56647 = state_56637;
(statearr_56647[(7)] = inst_56632);

return statearr_56647;
})();
var statearr_56648_56661 = state_56637__$1;
(statearr_56648_56661[(2)] = inst_56617);

(statearr_56648_56661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56649 = [null,null,null,null,null,null,null,null];
(statearr_56649[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56649[(1)] = (1));

return statearr_56649;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56637){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56637);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56650){var ex__2882__auto__ = e56650;
var statearr_56651_56662 = state_56637;
(statearr_56651_56662[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56637[(4)]))){
var statearr_56652_56663 = state_56637;
(statearr_56652_56663[(1)] = cljs.core.first((state_56637[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56664 = state_56637;
state_56637 = G__56664;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56637){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56653 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56653[(6)] = c__2901__auto__);

return statearr_56653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56605){
var G__56606 = cljs.core.first(seq56605);
var seq56605__$1 = cljs.core.next(seq56605);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56606,seq56605__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56666 = arguments.length;
switch (G__56666) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56711){
var state_val_56712 = (state_56711[(1)]);
if((state_val_56712 === (7))){
var state_56711__$1 = state_56711;
var statearr_56713_56850 = state_56711__$1;
(statearr_56713_56850[(2)] = query_map);

(statearr_56713_56850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (1))){
var state_56711__$1 = state_56711;
var statearr_56714_56851 = state_56711__$1;
(statearr_56714_56851[(2)] = null);

(statearr_56714_56851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (4))){
var inst_56667 = (state_56711[(2)]);
var state_56711__$1 = state_56711;
var statearr_56715_56852 = state_56711__$1;
(statearr_56715_56852[(2)] = inst_56667);

(statearr_56715_56852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (13))){
var inst_56689 = (state_56711[(7)]);
var inst_56693 = (state_56711[(2)]);
var inst_56694 = fluree.db.util.async.throw_err(inst_56693);
var inst_56695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56694,(0),null);
var inst_56696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56694,(1),null);
var inst_56697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56698 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56700 = [inst_56689];
var inst_56701 = (new cljs.core.PersistentVector(null,1,(5),inst_56699,inst_56700,null));
var inst_56702 = ["query",inst_56701,inst_56695];
var inst_56703 = cljs.core.PersistentHashMap.fromArrays(inst_56698,inst_56702);
var inst_56704 = [inst_56703,inst_56696];
var inst_56705 = (new cljs.core.PersistentVector(null,2,(5),inst_56697,inst_56704,null));
var inst_56706 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56705);
var _ = (function (){var statearr_56716 = state_56711;
(statearr_56716[(4)] = cljs.core.rest((state_56711[(4)])));

return statearr_56716;
})();
var state_56711__$1 = (function (){var statearr_56717 = state_56711;
(statearr_56717[(8)] = inst_56706);

return statearr_56717;
})();
var statearr_56718_56853 = state_56711__$1;
(statearr_56718_56853[(2)] = inst_56695);

(statearr_56718_56853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (6))){
var state_56711__$1 = state_56711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56711__$1,(9),query_map);
} else {
if((state_val_56712 === (3))){
var inst_56709 = (state_56711[(2)]);
var state_56711__$1 = state_56711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56711__$1,inst_56709);
} else {
if((state_val_56712 === (12))){
var inst_56689 = (state_56711[(7)]);
var inst_56689__$1 = (state_56711[(2)]);
var inst_56690 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56691 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56690,inst_56689__$1);
var state_56711__$1 = (function (){var statearr_56719 = state_56711;
(statearr_56719[(7)] = inst_56689__$1);

return statearr_56719;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56711__$1,(13),inst_56691);
} else {
if((state_val_56712 === (2))){
var _ = (function (){var statearr_56720 = state_56711;
(statearr_56720[(4)] = cljs.core.cons((5),(state_56711[(4)])));

return statearr_56720;
})();
var inst_56676 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56711__$1 = state_56711;
if(inst_56676){
var statearr_56721_56854 = state_56711__$1;
(statearr_56721_56854[(1)] = (6));

} else {
var statearr_56722_56855 = state_56711__$1;
(statearr_56722_56855[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (11))){
var inst_56683 = (state_56711[(9)]);
var state_56711__$1 = state_56711;
var statearr_56724_56856 = state_56711__$1;
(statearr_56724_56856[(2)] = inst_56683);

(statearr_56724_56856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (9))){
var inst_56679 = (state_56711[(2)]);
var inst_56680 = fluree.db.util.async.throw_err(inst_56679);
var state_56711__$1 = state_56711;
var statearr_56725_56857 = state_56711__$1;
(statearr_56725_56857[(2)] = inst_56680);

(statearr_56725_56857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (5))){
var _ = (function (){var statearr_56726 = state_56711;
(statearr_56726[(4)] = cljs.core.rest((state_56711[(4)])));

return statearr_56726;
})();
var state_56711__$1 = state_56711;
var ex56723 = (state_56711__$1[(2)]);
var statearr_56727_56858 = state_56711__$1;
(statearr_56727_56858[(5)] = ex56723);


if((ex56723 instanceof Error)){
var statearr_56728_56859 = state_56711__$1;
(statearr_56728_56859[(1)] = (4));

(statearr_56728_56859[(5)] = null);

} else {
throw ex56723;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (10))){
var inst_56683 = (state_56711[(9)]);
var inst_56686 = fluree.db.util.json.parse(inst_56683);
var state_56711__$1 = state_56711;
var statearr_56729_56860 = state_56711__$1;
(statearr_56729_56860[(2)] = inst_56686);

(statearr_56729_56860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56712 === (8))){
var inst_56683 = (state_56711[(9)]);
var inst_56683__$1 = (state_56711[(2)]);
var inst_56684 = typeof inst_56683__$1 === 'string';
var state_56711__$1 = (function (){var statearr_56730 = state_56711;
(statearr_56730[(9)] = inst_56683__$1);

return statearr_56730;
})();
if(cljs.core.truth_(inst_56684)){
var statearr_56731_56861 = state_56711__$1;
(statearr_56731_56861[(1)] = (10));

} else {
var statearr_56732_56862 = state_56711__$1;
(statearr_56732_56862[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56733 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56733[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56733[(1)] = (1));

return statearr_56733;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56711){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56711);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56734){var ex__2882__auto__ = e56734;
var statearr_56735_56863 = state_56711;
(statearr_56735_56863[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56711[(4)]))){
var statearr_56736_56864 = state_56711;
(statearr_56736_56864[(1)] = cljs.core.first((state_56711[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56865 = state_56711;
state_56711 = G__56865;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56711){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56737 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56737[(6)] = c__2901__auto__);

return statearr_56737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56808){
var state_val_56809 = (state_56808[(1)]);
if((state_val_56809 === (7))){
var state_56808__$1 = state_56808;
var statearr_56810_56866 = state_56808__$1;
(statearr_56810_56866[(2)] = select);

(statearr_56810_56866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (20))){
var inst_56778 = (state_56808[(2)]);
var inst_56779 = fluree.db.util.async.channel_QMARK_(limit);
var state_56808__$1 = (function (){var statearr_56811 = state_56808;
(statearr_56811[(7)] = inst_56778);

return statearr_56811;
})();
if(inst_56779){
var statearr_56812_56867 = state_56808__$1;
(statearr_56812_56867[(1)] = (22));

} else {
var statearr_56813_56868 = state_56808__$1;
(statearr_56813_56868[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (1))){
var state_56808__$1 = state_56808;
var statearr_56814_56869 = state_56808__$1;
(statearr_56814_56869[(2)] = null);

(statearr_56814_56869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (24))){
var inst_56778 = (state_56808[(7)]);
var inst_56770 = (state_56808[(8)]);
var inst_56762 = (state_56808[(9)]);
var inst_56754 = (state_56808[(10)]);
var inst_56786 = (state_56808[(2)]);
var inst_56787 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56788 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56787,inst_56754,inst_56762,inst_56770,inst_56778,inst_56786);
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(26),inst_56788);
} else {
if((state_val_56809 === (4))){
var inst_56738 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
var statearr_56815_56870 = state_56808__$1;
(statearr_56815_56870[(2)] = inst_56738);

(statearr_56815_56870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (15))){
var state_56808__$1 = state_56808;
var statearr_56816_56871 = state_56808__$1;
(statearr_56816_56871[(2)] = where);

(statearr_56816_56871[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (21))){
var inst_56774 = (state_56808[(2)]);
var inst_56775 = fluree.db.util.async.throw_err(inst_56774);
var state_56808__$1 = state_56808;
var statearr_56817_56872 = state_56808__$1;
(statearr_56817_56872[(2)] = inst_56775);

(statearr_56817_56872[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (13))){
var inst_56758 = (state_56808[(2)]);
var inst_56759 = fluree.db.util.async.throw_err(inst_56758);
var state_56808__$1 = state_56808;
var statearr_56818_56873 = state_56808__$1;
(statearr_56818_56873[(2)] = inst_56759);

(statearr_56818_56873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (22))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(25),limit);
} else {
if((state_val_56809 === (6))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(9),select);
} else {
if((state_val_56809 === (25))){
var inst_56782 = (state_56808[(2)]);
var inst_56783 = fluree.db.util.async.throw_err(inst_56782);
var state_56808__$1 = state_56808;
var statearr_56819_56874 = state_56808__$1;
(statearr_56819_56874[(2)] = inst_56783);

(statearr_56819_56874[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (17))){
var inst_56766 = (state_56808[(2)]);
var inst_56767 = fluree.db.util.async.throw_err(inst_56766);
var state_56808__$1 = state_56808;
var statearr_56820_56875 = state_56808__$1;
(statearr_56820_56875[(2)] = inst_56767);

(statearr_56820_56875[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (3))){
var inst_56806 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56808__$1,inst_56806);
} else {
if((state_val_56809 === (12))){
var inst_56762 = (state_56808[(2)]);
var inst_56763 = fluree.db.util.async.channel_QMARK_(where);
var state_56808__$1 = (function (){var statearr_56821 = state_56808;
(statearr_56821[(9)] = inst_56762);

return statearr_56821;
})();
if(inst_56763){
var statearr_56822_56876 = state_56808__$1;
(statearr_56822_56876[(1)] = (14));

} else {
var statearr_56823_56877 = state_56808__$1;
(statearr_56823_56877[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (2))){
var _ = (function (){var statearr_56824 = state_56808;
(statearr_56824[(4)] = cljs.core.cons((5),(state_56808[(4)])));

return statearr_56824;
})();
var inst_56747 = fluree.db.util.async.channel_QMARK_(select);
var state_56808__$1 = state_56808;
if(inst_56747){
var statearr_56825_56878 = state_56808__$1;
(statearr_56825_56878[(1)] = (6));

} else {
var statearr_56826_56879 = state_56808__$1;
(statearr_56826_56879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (23))){
var state_56808__$1 = state_56808;
var statearr_56827_56880 = state_56808__$1;
(statearr_56827_56880[(2)] = limit);

(statearr_56827_56880[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (19))){
var state_56808__$1 = state_56808;
var statearr_56828_56881 = state_56808__$1;
(statearr_56828_56881[(2)] = block);

(statearr_56828_56881[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (11))){
var state_56808__$1 = state_56808;
var statearr_56830_56882 = state_56808__$1;
(statearr_56830_56882[(2)] = from);

(statearr_56830_56882[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (9))){
var inst_56750 = (state_56808[(2)]);
var inst_56751 = fluree.db.util.async.throw_err(inst_56750);
var state_56808__$1 = state_56808;
var statearr_56831_56883 = state_56808__$1;
(statearr_56831_56883[(2)] = inst_56751);

(statearr_56831_56883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (5))){
var _ = (function (){var statearr_56832 = state_56808;
(statearr_56832[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56832;
})();
var state_56808__$1 = state_56808;
var ex56829 = (state_56808__$1[(2)]);
var statearr_56833_56884 = state_56808__$1;
(statearr_56833_56884[(5)] = ex56829);


if((ex56829 instanceof Error)){
var statearr_56834_56885 = state_56808__$1;
(statearr_56834_56885[(1)] = (4));

(statearr_56834_56885[(5)] = null);

} else {
throw ex56829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (14))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(17),where);
} else {
if((state_val_56809 === (26))){
var inst_56778 = (state_56808[(7)]);
var inst_56770 = (state_56808[(8)]);
var inst_56762 = (state_56808[(9)]);
var inst_56754 = (state_56808[(10)]);
var inst_56790 = (state_56808[(2)]);
var inst_56791 = fluree.db.util.async.throw_err(inst_56790);
var inst_56792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56791,(0),null);
var inst_56793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56791,(1),null);
var inst_56794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56797 = [inst_56754,inst_56762,inst_56770,inst_56778];
var inst_56798 = (new cljs.core.PersistentVector(null,4,(5),inst_56796,inst_56797,null));
var inst_56799 = ["query",inst_56798,inst_56792];
var inst_56800 = cljs.core.PersistentHashMap.fromArrays(inst_56795,inst_56799);
var inst_56801 = [inst_56800,inst_56793];
var inst_56802 = (new cljs.core.PersistentVector(null,2,(5),inst_56794,inst_56801,null));
var inst_56803 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56802);
var _ = (function (){var statearr_56835 = state_56808;
(statearr_56835[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56835;
})();
var state_56808__$1 = (function (){var statearr_56836 = state_56808;
(statearr_56836[(11)] = inst_56803);

return statearr_56836;
})();
var statearr_56837_56886 = state_56808__$1;
(statearr_56837_56886[(2)] = inst_56792);

(statearr_56837_56886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (16))){
var inst_56770 = (state_56808[(2)]);
var inst_56771 = fluree.db.util.async.channel_QMARK_(block);
var state_56808__$1 = (function (){var statearr_56838 = state_56808;
(statearr_56838[(8)] = inst_56770);

return statearr_56838;
})();
if(inst_56771){
var statearr_56839_56887 = state_56808__$1;
(statearr_56839_56887[(1)] = (18));

} else {
var statearr_56840_56888 = state_56808__$1;
(statearr_56840_56888[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (10))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(13),from);
} else {
if((state_val_56809 === (18))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(21),block);
} else {
if((state_val_56809 === (8))){
var inst_56754 = (state_56808[(2)]);
var inst_56755 = fluree.db.util.async.channel_QMARK_(from);
var state_56808__$1 = (function (){var statearr_56841 = state_56808;
(statearr_56841[(10)] = inst_56754);

return statearr_56841;
})();
if(inst_56755){
var statearr_56842_56889 = state_56808__$1;
(statearr_56842_56889[(1)] = (10));

} else {
var statearr_56843_56890 = state_56808__$1;
(statearr_56843_56890[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56844 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56844[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56844[(1)] = (1));

return statearr_56844;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56808){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56808);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56845){var ex__2882__auto__ = e56845;
var statearr_56846_56891 = state_56808;
(statearr_56846_56891[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56808[(4)]))){
var statearr_56847_56892 = state_56808;
(statearr_56847_56892[(1)] = cljs.core.first((state_56808[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56893 = state_56808;
state_56808 = G__56893;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56848 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56848[(6)] = c__2901__auto__);

return statearr_56848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56949){
var state_val_56950 = (state_56949[(1)]);
if((state_val_56950 === (7))){
var state_56949__$1 = state_56949;
var statearr_56951_56982 = state_56949__$1;
(statearr_56951_56982[(2)] = startSubject);

(statearr_56951_56982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (1))){
var state_56949__$1 = state_56949;
var statearr_56952_56983 = state_56949__$1;
(statearr_56952_56983[(2)] = null);

(statearr_56952_56983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (4))){
var inst_56894 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
var statearr_56953_56984 = state_56949__$1;
(statearr_56953_56984[(2)] = inst_56894);

(statearr_56953_56984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (15))){
var inst_56926 = (state_56949[(2)]);
var inst_56927 = fluree.db.util.async.throw_err(inst_56926);
var inst_56928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56927,(0),null);
var inst_56929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56927,(1),null);
var inst_56930 = cljs.core.empty_QMARK_(inst_56928);
var state_56949__$1 = (function (){var statearr_56954 = state_56949;
(statearr_56954[(7)] = inst_56929);

return statearr_56954;
})();
if(inst_56930){
var statearr_56955_56985 = state_56949__$1;
(statearr_56955_56985[(1)] = (16));

} else {
var statearr_56956_56986 = state_56949__$1;
(statearr_56956_56986[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (13))){
var inst_56922 = (state_56949[(8)]);
var inst_56910 = (state_56949[(9)]);
var inst_56914 = (state_56949[(10)]);
var inst_56922__$1 = (state_56949[(2)]);
var inst_56923 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56924 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56923,inst_56910,inst_56914,inst_56922__$1);
var state_56949__$1 = (function (){var statearr_56957 = state_56949;
(statearr_56957[(8)] = inst_56922__$1);

return statearr_56957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56949__$1,(15),inst_56924);
} else {
if((state_val_56950 === (6))){
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56949__$1,(9),startSubject);
} else {
if((state_val_56950 === (17))){
var state_56949__$1 = state_56949;
var statearr_56958_56987 = state_56949__$1;
(statearr_56958_56987[(2)] = true);

(statearr_56958_56987[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (3))){
var inst_56947 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56949__$1,inst_56947);
} else {
if((state_val_56950 === (12))){
var state_56949__$1 = state_56949;
var statearr_56959_56988 = state_56949__$1;
(statearr_56959_56988[(2)] = endSubject);

(statearr_56959_56988[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (2))){
var _ = (function (){var statearr_56960 = state_56949;
(statearr_56960[(4)] = cljs.core.cons((5),(state_56949[(4)])));

return statearr_56960;
})();
var inst_56903 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56949__$1 = state_56949;
if(inst_56903){
var statearr_56961_56989 = state_56949__$1;
(statearr_56961_56989[(1)] = (6));

} else {
var statearr_56962_56990 = state_56949__$1;
(statearr_56962_56990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (11))){
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56949__$1,(14),endSubject);
} else {
if((state_val_56950 === (9))){
var inst_56906 = (state_56949[(2)]);
var inst_56907 = fluree.db.util.async.throw_err(inst_56906);
var state_56949__$1 = state_56949;
var statearr_56964_56991 = state_56949__$1;
(statearr_56964_56991[(2)] = inst_56907);

(statearr_56964_56991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (5))){
var _ = (function (){var statearr_56965 = state_56949;
(statearr_56965[(4)] = cljs.core.rest((state_56949[(4)])));

return statearr_56965;
})();
var state_56949__$1 = state_56949;
var ex56963 = (state_56949__$1[(2)]);
var statearr_56966_56992 = state_56949__$1;
(statearr_56966_56992[(5)] = ex56963);


if((ex56963 instanceof Error)){
var statearr_56967_56993 = state_56949__$1;
(statearr_56967_56993[(1)] = (4));

(statearr_56967_56993[(5)] = null);

} else {
throw ex56963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (14))){
var inst_56918 = (state_56949[(2)]);
var inst_56919 = fluree.db.util.async.throw_err(inst_56918);
var state_56949__$1 = state_56949;
var statearr_56968_56994 = state_56949__$1;
(statearr_56968_56994[(2)] = inst_56919);

(statearr_56968_56994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (16))){
var state_56949__$1 = state_56949;
var statearr_56969_56995 = state_56949__$1;
(statearr_56969_56995[(2)] = false);

(statearr_56969_56995[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (10))){
var inst_56913 = (state_56949[(2)]);
var inst_56914 = fluree.db.util.async.throw_err(inst_56913);
var inst_56915 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56949__$1 = (function (){var statearr_56970 = state_56949;
(statearr_56970[(10)] = inst_56914);

return statearr_56970;
})();
if(inst_56915){
var statearr_56971_56996 = state_56949__$1;
(statearr_56971_56996[(1)] = (11));

} else {
var statearr_56972_56997 = state_56949__$1;
(statearr_56972_56997[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (18))){
var inst_56929 = (state_56949[(7)]);
var inst_56922 = (state_56949[(8)]);
var inst_56910 = (state_56949[(9)]);
var inst_56914 = (state_56949[(10)]);
var inst_56934 = (state_56949[(2)]);
var inst_56935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56936 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56938 = [inst_56910,inst_56914,inst_56922];
var inst_56939 = (new cljs.core.PersistentVector(null,3,(5),inst_56937,inst_56938,null));
var inst_56940 = ["relationship?",inst_56939,inst_56934];
var inst_56941 = cljs.core.PersistentHashMap.fromArrays(inst_56936,inst_56940);
var inst_56942 = [inst_56941,inst_56929];
var inst_56943 = (new cljs.core.PersistentVector(null,2,(5),inst_56935,inst_56942,null));
var inst_56944 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56943);
var _ = (function (){var statearr_56973 = state_56949;
(statearr_56973[(4)] = cljs.core.rest((state_56949[(4)])));

return statearr_56973;
})();
var state_56949__$1 = (function (){var statearr_56974 = state_56949;
(statearr_56974[(11)] = inst_56944);

return statearr_56974;
})();
var statearr_56975_56998 = state_56949__$1;
(statearr_56975_56998[(2)] = inst_56934);

(statearr_56975_56998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (8))){
var inst_56910 = (state_56949[(2)]);
var inst_56911 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56949__$1 = (function (){var statearr_56976 = state_56949;
(statearr_56976[(9)] = inst_56910);

return statearr_56976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56949__$1,(10),inst_56911);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_56977 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56977[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__);

(statearr_56977[(1)] = (1));

return statearr_56977;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1 = (function (state_56949){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_56949);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56978){var ex__2882__auto__ = e56978;
var statearr_56979_56999 = state_56949;
(statearr_56979_56999[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_56949[(4)]))){
var statearr_56980_57000 = state_56949;
(statearr_56980_57000[(1)] = cljs.core.first((state_56949[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57001 = state_56949;
state_56949 = G__57001;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__ = function(state_56949){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1.call(this,state_56949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56981 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_56981[(6)] = c__2901__auto__);

return statearr_56981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57038){
var state_val_57039 = (state_57038[(1)]);
if((state_val_57039 === (7))){
var state_57038__$1 = state_57038;
var statearr_57040_57060 = state_57038__$1;
(statearr_57040_57060[(2)] = pred_name);

(statearr_57040_57060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (1))){
var state_57038__$1 = state_57038;
var statearr_57041_57061 = state_57038__$1;
(statearr_57041_57061[(2)] = null);

(statearr_57041_57061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (4))){
var inst_57002 = (state_57038[(2)]);
var state_57038__$1 = state_57038;
var statearr_57042_57062 = state_57038__$1;
(statearr_57042_57062[(2)] = inst_57002);

(statearr_57042_57062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (6))){
var state_57038__$1 = state_57038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57038__$1,(9),pred_name);
} else {
if((state_val_57039 === (3))){
var inst_57036 = (state_57038[(2)]);
var state_57038__$1 = state_57038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57038__$1,inst_57036);
} else {
if((state_val_57039 === (2))){
var _ = (function (){var statearr_57044 = state_57038;
(statearr_57044[(4)] = cljs.core.cons((5),(state_57038[(4)])));

return statearr_57044;
})();
var inst_57011 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_57038__$1 = state_57038;
if(inst_57011){
var statearr_57045_57063 = state_57038__$1;
(statearr_57045_57063[(1)] = (6));

} else {
var statearr_57046_57064 = state_57038__$1;
(statearr_57046_57064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (9))){
var inst_57014 = (state_57038[(2)]);
var inst_57015 = fluree.db.util.async.throw_err(inst_57014);
var state_57038__$1 = state_57038;
var statearr_57047_57065 = state_57038__$1;
(statearr_57047_57065[(2)] = inst_57015);

(statearr_57047_57065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (5))){
var _ = (function (){var statearr_57048 = state_57038;
(statearr_57048[(4)] = cljs.core.rest((state_57038[(4)])));

return statearr_57048;
})();
var state_57038__$1 = state_57038;
var ex57043 = (state_57038__$1[(2)]);
var statearr_57049_57066 = state_57038__$1;
(statearr_57049_57066[(5)] = ex57043);


if((ex57043 instanceof Error)){
var statearr_57050_57067 = state_57038__$1;
(statearr_57050_57067[(1)] = (4));

(statearr_57050_57067[(5)] = null);

} else {
throw ex57043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (10))){
var inst_57018 = (state_57038[(7)]);
var inst_57022 = (state_57038[(2)]);
var inst_57023 = fluree.db.util.async.throw_err(inst_57022);
var inst_57024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57023,(0),null);
var inst_57025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57023,(1),null);
var inst_57026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57027 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57028 = ["max-pred-val",inst_57018,inst_57024];
var inst_57029 = cljs.core.PersistentHashMap.fromArrays(inst_57027,inst_57028);
var inst_57030 = (inst_57025 + (10));
var inst_57031 = [inst_57029,inst_57030];
var inst_57032 = (new cljs.core.PersistentVector(null,2,(5),inst_57026,inst_57031,null));
var inst_57033 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57032);
var _ = (function (){var statearr_57051 = state_57038;
(statearr_57051[(4)] = cljs.core.rest((state_57038[(4)])));

return statearr_57051;
})();
var state_57038__$1 = (function (){var statearr_57052 = state_57038;
(statearr_57052[(8)] = inst_57033);

return statearr_57052;
})();
var statearr_57053_57068 = state_57038__$1;
(statearr_57053_57068[(2)] = inst_57024);

(statearr_57053_57068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57039 === (8))){
var inst_57018 = (state_57038[(7)]);
var inst_57018__$1 = (state_57038[(2)]);
var inst_57019 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57020 = fluree.db.dbfunctions.internal.max_pred_val(inst_57019,inst_57018__$1,null);
var state_57038__$1 = (function (){var statearr_57054 = state_57038;
(statearr_57054[(7)] = inst_57018__$1);

return statearr_57054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57038__$1,(10),inst_57020);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0 = (function (){
var statearr_57055 = [null,null,null,null,null,null,null,null,null];
(statearr_57055[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__);

(statearr_57055[(1)] = (1));

return statearr_57055;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1 = (function (state_57038){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57038);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57056){var ex__2882__auto__ = e57056;
var statearr_57057_57069 = state_57038;
(statearr_57057_57069[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57038[(4)]))){
var statearr_57058_57070 = state_57038;
(statearr_57058_57070[(1)] = cljs.core.first((state_57038[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57071 = state_57038;
state_57038 = G__57071;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__ = function(state_57038){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1.call(this,state_57038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57059 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57059[(6)] = c__2901__auto__);

return statearr_57059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57098){
var state_val_57099 = (state_57098[(1)]);
if((state_val_57099 === (7))){
var state_57098__$1 = state_57098;
var statearr_57100_57119 = state_57098__$1;
(statearr_57100_57119[(2)] = n);

(statearr_57100_57119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (1))){
var state_57098__$1 = state_57098;
var statearr_57101_57120 = state_57098__$1;
(statearr_57101_57120[(2)] = null);

(statearr_57101_57120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (4))){
var inst_57072 = (state_57098[(2)]);
var state_57098__$1 = state_57098;
var statearr_57102_57121 = state_57098__$1;
(statearr_57102_57121[(2)] = inst_57072);

(statearr_57102_57121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (6))){
var state_57098__$1 = state_57098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57098__$1,(9),n);
} else {
if((state_val_57099 === (3))){
var inst_57096 = (state_57098[(2)]);
var state_57098__$1 = state_57098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57098__$1,inst_57096);
} else {
if((state_val_57099 === (2))){
var _ = (function (){var statearr_57104 = state_57098;
(statearr_57104[(4)] = cljs.core.cons((5),(state_57098[(4)])));

return statearr_57104;
})();
var inst_57078 = fluree.db.util.async.channel_QMARK_(n);
var state_57098__$1 = state_57098;
if(inst_57078){
var statearr_57105_57122 = state_57098__$1;
(statearr_57105_57122[(1)] = (6));

} else {
var statearr_57106_57123 = state_57098__$1;
(statearr_57106_57123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (9))){
var inst_57081 = (state_57098[(2)]);
var inst_57082 = fluree.db.util.async.throw_err(inst_57081);
var state_57098__$1 = state_57098;
var statearr_57107_57124 = state_57098__$1;
(statearr_57107_57124[(2)] = inst_57082);

(statearr_57107_57124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (5))){
var _ = (function (){var statearr_57108 = state_57098;
(statearr_57108[(4)] = cljs.core.rest((state_57098[(4)])));

return statearr_57108;
})();
var state_57098__$1 = state_57098;
var ex57103 = (state_57098__$1[(2)]);
var statearr_57109_57125 = state_57098__$1;
(statearr_57109_57125[(5)] = ex57103);


if((ex57103 instanceof Error)){
var statearr_57110_57126 = state_57098__$1;
(statearr_57110_57126[(1)] = (4));

(statearr_57110_57126[(5)] = null);

} else {
throw ex57103;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57099 === (8))){
var inst_57085 = (state_57098[(2)]);
var inst_57086 = fluree.db.dbfunctions.internal.inc(inst_57085);
var inst_57087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57088 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57089 = ["inc",inst_57085,inst_57086];
var inst_57090 = cljs.core.PersistentHashMap.fromArrays(inst_57088,inst_57089);
var inst_57091 = [inst_57090,(10)];
var inst_57092 = (new cljs.core.PersistentVector(null,2,(5),inst_57087,inst_57091,null));
var inst_57093 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57092);
var _ = (function (){var statearr_57111 = state_57098;
(statearr_57111[(4)] = cljs.core.rest((state_57098[(4)])));

return statearr_57111;
})();
var state_57098__$1 = (function (){var statearr_57112 = state_57098;
(statearr_57112[(7)] = inst_57093);

return statearr_57112;
})();
var statearr_57113_57127 = state_57098__$1;
(statearr_57113_57127[(2)] = inst_57086);

(statearr_57113_57127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0 = (function (){
var statearr_57114 = [null,null,null,null,null,null,null,null];
(statearr_57114[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__);

(statearr_57114[(1)] = (1));

return statearr_57114;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1 = (function (state_57098){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57098);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57115){var ex__2882__auto__ = e57115;
var statearr_57116_57128 = state_57098;
(statearr_57116_57128[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57098[(4)]))){
var statearr_57117_57129 = state_57098;
(statearr_57117_57129[(1)] = cljs.core.first((state_57098[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57130 = state_57098;
state_57098 = G__57130;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__ = function(state_57098){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1.call(this,state_57098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57118 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57118[(6)] = c__2901__auto__);

return statearr_57118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57157){
var state_val_57158 = (state_57157[(1)]);
if((state_val_57158 === (7))){
var state_57157__$1 = state_57157;
var statearr_57159_57178 = state_57157__$1;
(statearr_57159_57178[(2)] = n);

(statearr_57159_57178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (1))){
var state_57157__$1 = state_57157;
var statearr_57160_57179 = state_57157__$1;
(statearr_57160_57179[(2)] = null);

(statearr_57160_57179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (4))){
var inst_57131 = (state_57157[(2)]);
var state_57157__$1 = state_57157;
var statearr_57161_57180 = state_57157__$1;
(statearr_57161_57180[(2)] = inst_57131);

(statearr_57161_57180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (6))){
var state_57157__$1 = state_57157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57157__$1,(9),n);
} else {
if((state_val_57158 === (3))){
var inst_57155 = (state_57157[(2)]);
var state_57157__$1 = state_57157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57157__$1,inst_57155);
} else {
if((state_val_57158 === (2))){
var _ = (function (){var statearr_57163 = state_57157;
(statearr_57163[(4)] = cljs.core.cons((5),(state_57157[(4)])));

return statearr_57163;
})();
var inst_57137 = fluree.db.util.async.channel_QMARK_(n);
var state_57157__$1 = state_57157;
if(inst_57137){
var statearr_57164_57181 = state_57157__$1;
(statearr_57164_57181[(1)] = (6));

} else {
var statearr_57165_57182 = state_57157__$1;
(statearr_57165_57182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (9))){
var inst_57140 = (state_57157[(2)]);
var inst_57141 = fluree.db.util.async.throw_err(inst_57140);
var state_57157__$1 = state_57157;
var statearr_57166_57183 = state_57157__$1;
(statearr_57166_57183[(2)] = inst_57141);

(statearr_57166_57183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (5))){
var _ = (function (){var statearr_57167 = state_57157;
(statearr_57167[(4)] = cljs.core.rest((state_57157[(4)])));

return statearr_57167;
})();
var state_57157__$1 = state_57157;
var ex57162 = (state_57157__$1[(2)]);
var statearr_57168_57184 = state_57157__$1;
(statearr_57168_57184[(5)] = ex57162);


if((ex57162 instanceof Error)){
var statearr_57169_57185 = state_57157__$1;
(statearr_57169_57185[(1)] = (4));

(statearr_57169_57185[(5)] = null);

} else {
throw ex57162;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57158 === (8))){
var inst_57144 = (state_57157[(2)]);
var inst_57145 = fluree.db.dbfunctions.internal.dec(inst_57144);
var inst_57146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57147 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57148 = ["dec",inst_57144,inst_57145];
var inst_57149 = cljs.core.PersistentHashMap.fromArrays(inst_57147,inst_57148);
var inst_57150 = [inst_57149,(10)];
var inst_57151 = (new cljs.core.PersistentVector(null,2,(5),inst_57146,inst_57150,null));
var inst_57152 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57151);
var _ = (function (){var statearr_57170 = state_57157;
(statearr_57170[(4)] = cljs.core.rest((state_57157[(4)])));

return statearr_57170;
})();
var state_57157__$1 = (function (){var statearr_57171 = state_57157;
(statearr_57171[(7)] = inst_57152);

return statearr_57171;
})();
var statearr_57172_57186 = state_57157__$1;
(statearr_57172_57186[(2)] = inst_57145);

(statearr_57172_57186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0 = (function (){
var statearr_57173 = [null,null,null,null,null,null,null,null];
(statearr_57173[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__);

(statearr_57173[(1)] = (1));

return statearr_57173;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1 = (function (state_57157){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57157);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57174){var ex__2882__auto__ = e57174;
var statearr_57175_57187 = state_57157;
(statearr_57175_57187[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57157[(4)]))){
var statearr_57176_57188 = state_57157;
(statearr_57176_57188[(1)] = cljs.core.first((state_57157[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57189 = state_57157;
state_57157 = G__57189;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__ = function(state_57157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1.call(this,state_57157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57177 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57177[(6)] = c__2901__auto__);

return statearr_57177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57239 = arguments.length;
var i__4737__auto___57240 = (0);
while(true){
if((i__4737__auto___57240 < len__4736__auto___57239)){
args__4742__auto__.push((arguments[i__4737__auto___57240]));

var G__57241 = (i__4737__auto___57240 + (1));
i__4737__auto___57240 = G__57241;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57222){
var state_val_57223 = (state_57222[(1)]);
if((state_val_57223 === (1))){
var state_57222__$1 = state_57222;
var statearr_57224_57242 = state_57222__$1;
(statearr_57224_57242[(2)] = null);

(statearr_57224_57242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57223 === (2))){
var _ = (function (){var statearr_57225 = state_57222;
(statearr_57225[(4)] = cljs.core.cons((5),(state_57222[(4)])));

return statearr_57225;
})();
var inst_57198 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57222__$1 = state_57222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57222__$1,(6),inst_57198);
} else {
if((state_val_57223 === (3))){
var inst_57220 = (state_57222[(2)]);
var state_57222__$1 = state_57222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57222__$1,inst_57220);
} else {
if((state_val_57223 === (4))){
var inst_57192 = (state_57222[(2)]);
var state_57222__$1 = state_57222;
var statearr_57227_57243 = state_57222__$1;
(statearr_57227_57243[(2)] = inst_57192);

(statearr_57227_57243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57223 === (5))){
var _ = (function (){var statearr_57228 = state_57222;
(statearr_57228[(4)] = cljs.core.rest((state_57222[(4)])));

return statearr_57228;
})();
var state_57222__$1 = state_57222;
var ex57226 = (state_57222__$1[(2)]);
var statearr_57229_57244 = state_57222__$1;
(statearr_57229_57244[(5)] = ex57226);


if((ex57226 instanceof Error)){
var statearr_57230_57245 = state_57222__$1;
(statearr_57230_57245[(1)] = (4));

(statearr_57230_57245[(5)] = null);

} else {
throw ex57226;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57223 === (6))){
var inst_57200 = (state_57222[(2)]);
var inst_57201 = fluree.db.util.async.throw_err(inst_57200);
var inst_57202 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_57201);
var inst_57203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57204 = [inst_57201];
var inst_57205 = (new cljs.core.PersistentVector(null,1,(5),inst_57203,inst_57204,null));
var inst_57206 = cljs.core.count(inst_57205);
var inst_57207 = ((9) + inst_57206);
var inst_57208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57209 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57211 = [inst_57201];
var inst_57212 = (new cljs.core.PersistentVector(null,1,(5),inst_57210,inst_57211,null));
var inst_57213 = ["+",inst_57212,inst_57202];
var inst_57214 = cljs.core.PersistentHashMap.fromArrays(inst_57209,inst_57213);
var inst_57215 = [inst_57214,inst_57207];
var inst_57216 = (new cljs.core.PersistentVector(null,2,(5),inst_57208,inst_57215,null));
var inst_57217 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57216);
var _ = (function (){var statearr_57231 = state_57222;
(statearr_57231[(4)] = cljs.core.rest((state_57222[(4)])));

return statearr_57231;
})();
var state_57222__$1 = (function (){var statearr_57232 = state_57222;
(statearr_57232[(7)] = inst_57217);

return statearr_57232;
})();
var statearr_57233_57246 = state_57222__$1;
(statearr_57233_57246[(2)] = inst_57202);

(statearr_57233_57246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57234 = [null,null,null,null,null,null,null,null];
(statearr_57234[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57234[(1)] = (1));

return statearr_57234;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57222){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57222);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57235){var ex__2882__auto__ = e57235;
var statearr_57236_57247 = state_57222;
(statearr_57236_57247[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57222[(4)]))){
var statearr_57237_57248 = state_57222;
(statearr_57237_57248[(1)] = cljs.core.first((state_57222[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57249 = state_57222;
state_57222 = G__57249;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57222){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57238 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57238[(6)] = c__2901__auto__);

return statearr_57238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq57190){
var G__57191 = cljs.core.first(seq57190);
var seq57190__$1 = cljs.core.next(seq57190);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57191,seq57190__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57299 = arguments.length;
var i__4737__auto___57300 = (0);
while(true){
if((i__4737__auto___57300 < len__4736__auto___57299)){
args__4742__auto__.push((arguments[i__4737__auto___57300]));

var G__57301 = (i__4737__auto___57300 + (1));
i__4737__auto___57300 = G__57301;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57282){
var state_val_57283 = (state_57282[(1)]);
if((state_val_57283 === (1))){
var state_57282__$1 = state_57282;
var statearr_57284_57302 = state_57282__$1;
(statearr_57284_57302[(2)] = null);

(statearr_57284_57302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (2))){
var _ = (function (){var statearr_57285 = state_57282;
(statearr_57285[(4)] = cljs.core.cons((5),(state_57282[(4)])));

return statearr_57285;
})();
var inst_57258 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57282__$1 = state_57282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57282__$1,(6),inst_57258);
} else {
if((state_val_57283 === (3))){
var inst_57280 = (state_57282[(2)]);
var state_57282__$1 = state_57282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57282__$1,inst_57280);
} else {
if((state_val_57283 === (4))){
var inst_57252 = (state_57282[(2)]);
var state_57282__$1 = state_57282;
var statearr_57287_57303 = state_57282__$1;
(statearr_57287_57303[(2)] = inst_57252);

(statearr_57287_57303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (5))){
var _ = (function (){var statearr_57288 = state_57282;
(statearr_57288[(4)] = cljs.core.rest((state_57282[(4)])));

return statearr_57288;
})();
var state_57282__$1 = state_57282;
var ex57286 = (state_57282__$1[(2)]);
var statearr_57289_57304 = state_57282__$1;
(statearr_57289_57304[(5)] = ex57286);


if((ex57286 instanceof Error)){
var statearr_57290_57305 = state_57282__$1;
(statearr_57290_57305[(1)] = (4));

(statearr_57290_57305[(5)] = null);

} else {
throw ex57286;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (6))){
var inst_57260 = (state_57282[(2)]);
var inst_57261 = fluree.db.util.async.throw_err(inst_57260);
var inst_57262 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_57261);
var inst_57263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57264 = [inst_57261];
var inst_57265 = (new cljs.core.PersistentVector(null,1,(5),inst_57263,inst_57264,null));
var inst_57266 = cljs.core.count(inst_57265);
var inst_57267 = ((9) + inst_57266);
var inst_57268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57269 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57271 = [inst_57261];
var inst_57272 = (new cljs.core.PersistentVector(null,1,(5),inst_57270,inst_57271,null));
var inst_57273 = ["-",inst_57272,inst_57262];
var inst_57274 = cljs.core.PersistentHashMap.fromArrays(inst_57269,inst_57273);
var inst_57275 = [inst_57274,inst_57267];
var inst_57276 = (new cljs.core.PersistentVector(null,2,(5),inst_57268,inst_57275,null));
var inst_57277 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57276);
var _ = (function (){var statearr_57291 = state_57282;
(statearr_57291[(4)] = cljs.core.rest((state_57282[(4)])));

return statearr_57291;
})();
var state_57282__$1 = (function (){var statearr_57292 = state_57282;
(statearr_57292[(7)] = inst_57277);

return statearr_57292;
})();
var statearr_57293_57306 = state_57282__$1;
(statearr_57293_57306[(2)] = inst_57262);

(statearr_57293_57306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57294 = [null,null,null,null,null,null,null,null];
(statearr_57294[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57294[(1)] = (1));

return statearr_57294;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57282){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57282);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57295){var ex__2882__auto__ = e57295;
var statearr_57296_57307 = state_57282;
(statearr_57296_57307[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57282[(4)]))){
var statearr_57297_57308 = state_57282;
(statearr_57297_57308[(1)] = cljs.core.first((state_57282[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57309 = state_57282;
state_57282 = G__57309;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57282){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57298 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57298[(6)] = c__2901__auto__);

return statearr_57298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq57250){
var G__57251 = cljs.core.first(seq57250);
var seq57250__$1 = cljs.core.next(seq57250);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57251,seq57250__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57359 = arguments.length;
var i__4737__auto___57360 = (0);
while(true){
if((i__4737__auto___57360 < len__4736__auto___57359)){
args__4742__auto__.push((arguments[i__4737__auto___57360]));

var G__57361 = (i__4737__auto___57360 + (1));
i__4737__auto___57360 = G__57361;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57342){
var state_val_57343 = (state_57342[(1)]);
if((state_val_57343 === (1))){
var state_57342__$1 = state_57342;
var statearr_57344_57362 = state_57342__$1;
(statearr_57344_57362[(2)] = null);

(statearr_57344_57362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (2))){
var _ = (function (){var statearr_57345 = state_57342;
(statearr_57345[(4)] = cljs.core.cons((5),(state_57342[(4)])));

return statearr_57345;
})();
var inst_57318 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57342__$1 = state_57342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57342__$1,(6),inst_57318);
} else {
if((state_val_57343 === (3))){
var inst_57340 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57342__$1,inst_57340);
} else {
if((state_val_57343 === (4))){
var inst_57312 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
var statearr_57347_57363 = state_57342__$1;
(statearr_57347_57363[(2)] = inst_57312);

(statearr_57347_57363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (5))){
var _ = (function (){var statearr_57348 = state_57342;
(statearr_57348[(4)] = cljs.core.rest((state_57342[(4)])));

return statearr_57348;
})();
var state_57342__$1 = state_57342;
var ex57346 = (state_57342__$1[(2)]);
var statearr_57349_57364 = state_57342__$1;
(statearr_57349_57364[(5)] = ex57346);


if((ex57346 instanceof Error)){
var statearr_57350_57365 = state_57342__$1;
(statearr_57350_57365[(1)] = (4));

(statearr_57350_57365[(5)] = null);

} else {
throw ex57346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (6))){
var inst_57320 = (state_57342[(2)]);
var inst_57321 = fluree.db.util.async.throw_err(inst_57320);
var inst_57322 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_57321);
var inst_57323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57324 = [inst_57321];
var inst_57325 = (new cljs.core.PersistentVector(null,1,(5),inst_57323,inst_57324,null));
var inst_57326 = cljs.core.count(inst_57325);
var inst_57327 = ((9) + inst_57326);
var inst_57328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57329 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57331 = [inst_57321];
var inst_57332 = (new cljs.core.PersistentVector(null,1,(5),inst_57330,inst_57331,null));
var inst_57333 = ["*",inst_57332,inst_57322];
var inst_57334 = cljs.core.PersistentHashMap.fromArrays(inst_57329,inst_57333);
var inst_57335 = [inst_57334,inst_57327];
var inst_57336 = (new cljs.core.PersistentVector(null,2,(5),inst_57328,inst_57335,null));
var inst_57337 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57336);
var _ = (function (){var statearr_57351 = state_57342;
(statearr_57351[(4)] = cljs.core.rest((state_57342[(4)])));

return statearr_57351;
})();
var state_57342__$1 = (function (){var statearr_57352 = state_57342;
(statearr_57352[(7)] = inst_57337);

return statearr_57352;
})();
var statearr_57353_57366 = state_57342__$1;
(statearr_57353_57366[(2)] = inst_57322);

(statearr_57353_57366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57354 = [null,null,null,null,null,null,null,null];
(statearr_57354[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57354[(1)] = (1));

return statearr_57354;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57342){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57342);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57355){var ex__2882__auto__ = e57355;
var statearr_57356_57367 = state_57342;
(statearr_57356_57367[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57342[(4)]))){
var statearr_57357_57368 = state_57342;
(statearr_57357_57368[(1)] = cljs.core.first((state_57342[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57369 = state_57342;
state_57342 = G__57369;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57358 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57358[(6)] = c__2901__auto__);

return statearr_57358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq57310){
var G__57311 = cljs.core.first(seq57310);
var seq57310__$1 = cljs.core.next(seq57310);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57311,seq57310__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57419 = arguments.length;
var i__4737__auto___57420 = (0);
while(true){
if((i__4737__auto___57420 < len__4736__auto___57419)){
args__4742__auto__.push((arguments[i__4737__auto___57420]));

var G__57421 = (i__4737__auto___57420 + (1));
i__4737__auto___57420 = G__57421;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57402){
var state_val_57403 = (state_57402[(1)]);
if((state_val_57403 === (1))){
var state_57402__$1 = state_57402;
var statearr_57404_57422 = state_57402__$1;
(statearr_57404_57422[(2)] = null);

(statearr_57404_57422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57403 === (2))){
var _ = (function (){var statearr_57405 = state_57402;
(statearr_57405[(4)] = cljs.core.cons((5),(state_57402[(4)])));

return statearr_57405;
})();
var inst_57378 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57402__$1 = state_57402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57402__$1,(6),inst_57378);
} else {
if((state_val_57403 === (3))){
var inst_57400 = (state_57402[(2)]);
var state_57402__$1 = state_57402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57402__$1,inst_57400);
} else {
if((state_val_57403 === (4))){
var inst_57372 = (state_57402[(2)]);
var state_57402__$1 = state_57402;
var statearr_57407_57423 = state_57402__$1;
(statearr_57407_57423[(2)] = inst_57372);

(statearr_57407_57423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57403 === (5))){
var _ = (function (){var statearr_57408 = state_57402;
(statearr_57408[(4)] = cljs.core.rest((state_57402[(4)])));

return statearr_57408;
})();
var state_57402__$1 = state_57402;
var ex57406 = (state_57402__$1[(2)]);
var statearr_57409_57424 = state_57402__$1;
(statearr_57409_57424[(5)] = ex57406);


if((ex57406 instanceof Error)){
var statearr_57410_57425 = state_57402__$1;
(statearr_57410_57425[(1)] = (4));

(statearr_57410_57425[(5)] = null);

} else {
throw ex57406;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57403 === (6))){
var inst_57380 = (state_57402[(2)]);
var inst_57381 = fluree.db.util.async.throw_err(inst_57380);
var inst_57382 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_57381);
var inst_57383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57384 = [inst_57381];
var inst_57385 = (new cljs.core.PersistentVector(null,1,(5),inst_57383,inst_57384,null));
var inst_57386 = cljs.core.count(inst_57385);
var inst_57387 = ((9) + inst_57386);
var inst_57388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57389 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57391 = [inst_57381];
var inst_57392 = (new cljs.core.PersistentVector(null,1,(5),inst_57390,inst_57391,null));
var inst_57393 = ["/",inst_57392,inst_57382];
var inst_57394 = cljs.core.PersistentHashMap.fromArrays(inst_57389,inst_57393);
var inst_57395 = [inst_57394,inst_57387];
var inst_57396 = (new cljs.core.PersistentVector(null,2,(5),inst_57388,inst_57395,null));
var inst_57397 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57396);
var _ = (function (){var statearr_57411 = state_57402;
(statearr_57411[(4)] = cljs.core.rest((state_57402[(4)])));

return statearr_57411;
})();
var state_57402__$1 = (function (){var statearr_57412 = state_57402;
(statearr_57412[(7)] = inst_57397);

return statearr_57412;
})();
var statearr_57413_57426 = state_57402__$1;
(statearr_57413_57426[(2)] = inst_57382);

(statearr_57413_57426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57414 = [null,null,null,null,null,null,null,null];
(statearr_57414[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57414[(1)] = (1));

return statearr_57414;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57402){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57402);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57415){var ex__2882__auto__ = e57415;
var statearr_57416_57427 = state_57402;
(statearr_57416_57427[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57402[(4)]))){
var statearr_57417_57428 = state_57402;
(statearr_57417_57428[(1)] = cljs.core.first((state_57402[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57429 = state_57402;
state_57402 = G__57429;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57402){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57418 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57418[(6)] = c__2901__auto__);

return statearr_57418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57370){
var G__57371 = cljs.core.first(seq57370);
var seq57370__$1 = cljs.core.next(seq57370);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57371,seq57370__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57467){
var state_val_57468 = (state_57467[(1)]);
if((state_val_57468 === (7))){
var state_57467__$1 = state_57467;
var statearr_57469_57493 = state_57467__$1;
(statearr_57469_57493[(2)] = n);

(statearr_57469_57493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (1))){
var state_57467__$1 = state_57467;
var statearr_57470_57494 = state_57467__$1;
(statearr_57470_57494[(2)] = null);

(statearr_57470_57494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (4))){
var inst_57430 = (state_57467[(2)]);
var state_57467__$1 = state_57467;
var statearr_57471_57495 = state_57467__$1;
(statearr_57471_57495[(2)] = inst_57430);

(statearr_57471_57495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (13))){
var inst_57447 = (state_57467[(2)]);
var inst_57448 = fluree.db.util.async.throw_err(inst_57447);
var state_57467__$1 = state_57467;
var statearr_57472_57496 = state_57467__$1;
(statearr_57472_57496[(2)] = inst_57448);

(statearr_57472_57496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (6))){
var state_57467__$1 = state_57467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57467__$1,(9),n);
} else {
if((state_val_57468 === (3))){
var inst_57465 = (state_57467[(2)]);
var state_57467__$1 = state_57467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57467__$1,inst_57465);
} else {
if((state_val_57468 === (12))){
var inst_57443 = (state_57467[(7)]);
var inst_57451 = (state_57467[(2)]);
var inst_57452 = fluree.db.dbfunctions.internal.quot(inst_57443,inst_57451);
var inst_57453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57454 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57456 = [inst_57443,inst_57451];
var inst_57457 = (new cljs.core.PersistentVector(null,2,(5),inst_57455,inst_57456,null));
var inst_57458 = ["quot",inst_57457,inst_57452];
var inst_57459 = cljs.core.PersistentHashMap.fromArrays(inst_57454,inst_57458);
var inst_57460 = [inst_57459,(2)];
var inst_57461 = (new cljs.core.PersistentVector(null,2,(5),inst_57453,inst_57460,null));
var inst_57462 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57461);
var _ = (function (){var statearr_57473 = state_57467;
(statearr_57473[(4)] = cljs.core.rest((state_57467[(4)])));

return statearr_57473;
})();
var state_57467__$1 = (function (){var statearr_57474 = state_57467;
(statearr_57474[(8)] = inst_57462);

return statearr_57474;
})();
var statearr_57475_57497 = state_57467__$1;
(statearr_57475_57497[(2)] = inst_57452);

(statearr_57475_57497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (2))){
var _ = (function (){var statearr_57476 = state_57467;
(statearr_57476[(4)] = cljs.core.cons((5),(state_57467[(4)])));

return statearr_57476;
})();
var inst_57436 = fluree.db.util.async.channel_QMARK_(n);
var state_57467__$1 = state_57467;
if(inst_57436){
var statearr_57477_57498 = state_57467__$1;
(statearr_57477_57498[(1)] = (6));

} else {
var statearr_57478_57499 = state_57467__$1;
(statearr_57478_57499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (11))){
var state_57467__$1 = state_57467;
var statearr_57480_57500 = state_57467__$1;
(statearr_57480_57500[(2)] = d);

(statearr_57480_57500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (9))){
var inst_57439 = (state_57467[(2)]);
var inst_57440 = fluree.db.util.async.throw_err(inst_57439);
var state_57467__$1 = state_57467;
var statearr_57481_57501 = state_57467__$1;
(statearr_57481_57501[(2)] = inst_57440);

(statearr_57481_57501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (5))){
var _ = (function (){var statearr_57482 = state_57467;
(statearr_57482[(4)] = cljs.core.rest((state_57467[(4)])));

return statearr_57482;
})();
var state_57467__$1 = state_57467;
var ex57479 = (state_57467__$1[(2)]);
var statearr_57483_57502 = state_57467__$1;
(statearr_57483_57502[(5)] = ex57479);


if((ex57479 instanceof Error)){
var statearr_57484_57503 = state_57467__$1;
(statearr_57484_57503[(1)] = (4));

(statearr_57484_57503[(5)] = null);

} else {
throw ex57479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57468 === (10))){
var state_57467__$1 = state_57467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57467__$1,(13),d);
} else {
if((state_val_57468 === (8))){
var inst_57443 = (state_57467[(2)]);
var inst_57444 = fluree.db.util.async.channel_QMARK_(d);
var state_57467__$1 = (function (){var statearr_57485 = state_57467;
(statearr_57485[(7)] = inst_57443);

return statearr_57485;
})();
if(inst_57444){
var statearr_57486_57504 = state_57467__$1;
(statearr_57486_57504[(1)] = (10));

} else {
var statearr_57487_57505 = state_57467__$1;
(statearr_57487_57505[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0 = (function (){
var statearr_57488 = [null,null,null,null,null,null,null,null,null];
(statearr_57488[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__);

(statearr_57488[(1)] = (1));

return statearr_57488;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1 = (function (state_57467){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57467);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57489){var ex__2882__auto__ = e57489;
var statearr_57490_57506 = state_57467;
(statearr_57490_57506[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57467[(4)]))){
var statearr_57491_57507 = state_57467;
(statearr_57491_57507[(1)] = cljs.core.first((state_57467[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57508 = state_57467;
state_57467 = G__57508;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__ = function(state_57467){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1.call(this,state_57467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57492 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57492[(6)] = c__2901__auto__);

return statearr_57492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57546){
var state_val_57547 = (state_57546[(1)]);
if((state_val_57547 === (7))){
var state_57546__$1 = state_57546;
var statearr_57548_57572 = state_57546__$1;
(statearr_57548_57572[(2)] = n);

(statearr_57548_57572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (1))){
var state_57546__$1 = state_57546;
var statearr_57549_57573 = state_57546__$1;
(statearr_57549_57573[(2)] = null);

(statearr_57549_57573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (4))){
var inst_57509 = (state_57546[(2)]);
var state_57546__$1 = state_57546;
var statearr_57550_57574 = state_57546__$1;
(statearr_57550_57574[(2)] = inst_57509);

(statearr_57550_57574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (13))){
var inst_57526 = (state_57546[(2)]);
var inst_57527 = fluree.db.util.async.throw_err(inst_57526);
var state_57546__$1 = state_57546;
var statearr_57551_57575 = state_57546__$1;
(statearr_57551_57575[(2)] = inst_57527);

(statearr_57551_57575[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (6))){
var state_57546__$1 = state_57546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57546__$1,(9),n);
} else {
if((state_val_57547 === (3))){
var inst_57544 = (state_57546[(2)]);
var state_57546__$1 = state_57546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57546__$1,inst_57544);
} else {
if((state_val_57547 === (12))){
var inst_57522 = (state_57546[(7)]);
var inst_57530 = (state_57546[(2)]);
var inst_57531 = fluree.db.dbfunctions.internal.mod(inst_57522,inst_57530);
var inst_57532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57533 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57535 = [inst_57522,inst_57530];
var inst_57536 = (new cljs.core.PersistentVector(null,2,(5),inst_57534,inst_57535,null));
var inst_57537 = ["mod",inst_57536,inst_57531];
var inst_57538 = cljs.core.PersistentHashMap.fromArrays(inst_57533,inst_57537);
var inst_57539 = [inst_57538,(2)];
var inst_57540 = (new cljs.core.PersistentVector(null,2,(5),inst_57532,inst_57539,null));
var inst_57541 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57540);
var _ = (function (){var statearr_57552 = state_57546;
(statearr_57552[(4)] = cljs.core.rest((state_57546[(4)])));

return statearr_57552;
})();
var state_57546__$1 = (function (){var statearr_57553 = state_57546;
(statearr_57553[(8)] = inst_57541);

return statearr_57553;
})();
var statearr_57554_57576 = state_57546__$1;
(statearr_57554_57576[(2)] = inst_57531);

(statearr_57554_57576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (2))){
var _ = (function (){var statearr_57555 = state_57546;
(statearr_57555[(4)] = cljs.core.cons((5),(state_57546[(4)])));

return statearr_57555;
})();
var inst_57515 = fluree.db.util.async.channel_QMARK_(n);
var state_57546__$1 = state_57546;
if(inst_57515){
var statearr_57556_57577 = state_57546__$1;
(statearr_57556_57577[(1)] = (6));

} else {
var statearr_57557_57578 = state_57546__$1;
(statearr_57557_57578[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (11))){
var state_57546__$1 = state_57546;
var statearr_57559_57579 = state_57546__$1;
(statearr_57559_57579[(2)] = d);

(statearr_57559_57579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (9))){
var inst_57518 = (state_57546[(2)]);
var inst_57519 = fluree.db.util.async.throw_err(inst_57518);
var state_57546__$1 = state_57546;
var statearr_57560_57580 = state_57546__$1;
(statearr_57560_57580[(2)] = inst_57519);

(statearr_57560_57580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (5))){
var _ = (function (){var statearr_57561 = state_57546;
(statearr_57561[(4)] = cljs.core.rest((state_57546[(4)])));

return statearr_57561;
})();
var state_57546__$1 = state_57546;
var ex57558 = (state_57546__$1[(2)]);
var statearr_57562_57581 = state_57546__$1;
(statearr_57562_57581[(5)] = ex57558);


if((ex57558 instanceof Error)){
var statearr_57563_57582 = state_57546__$1;
(statearr_57563_57582[(1)] = (4));

(statearr_57563_57582[(5)] = null);

} else {
throw ex57558;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57547 === (10))){
var state_57546__$1 = state_57546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57546__$1,(13),d);
} else {
if((state_val_57547 === (8))){
var inst_57522 = (state_57546[(2)]);
var inst_57523 = fluree.db.util.async.channel_QMARK_(d);
var state_57546__$1 = (function (){var statearr_57564 = state_57546;
(statearr_57564[(7)] = inst_57522);

return statearr_57564;
})();
if(inst_57523){
var statearr_57565_57583 = state_57546__$1;
(statearr_57565_57583[(1)] = (10));

} else {
var statearr_57566_57584 = state_57546__$1;
(statearr_57566_57584[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0 = (function (){
var statearr_57567 = [null,null,null,null,null,null,null,null,null];
(statearr_57567[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__);

(statearr_57567[(1)] = (1));

return statearr_57567;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1 = (function (state_57546){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57546);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57568){var ex__2882__auto__ = e57568;
var statearr_57569_57585 = state_57546;
(statearr_57569_57585[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57546[(4)]))){
var statearr_57570_57586 = state_57546;
(statearr_57570_57586[(1)] = cljs.core.first((state_57546[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57587 = state_57546;
state_57546 = G__57587;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__ = function(state_57546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1.call(this,state_57546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57571 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57571[(6)] = c__2901__auto__);

return statearr_57571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57625){
var state_val_57626 = (state_57625[(1)]);
if((state_val_57626 === (7))){
var state_57625__$1 = state_57625;
var statearr_57627_57651 = state_57625__$1;
(statearr_57627_57651[(2)] = n);

(statearr_57627_57651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (1))){
var state_57625__$1 = state_57625;
var statearr_57628_57652 = state_57625__$1;
(statearr_57628_57652[(2)] = null);

(statearr_57628_57652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (4))){
var inst_57588 = (state_57625[(2)]);
var state_57625__$1 = state_57625;
var statearr_57629_57653 = state_57625__$1;
(statearr_57629_57653[(2)] = inst_57588);

(statearr_57629_57653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (13))){
var inst_57605 = (state_57625[(2)]);
var inst_57606 = fluree.db.util.async.throw_err(inst_57605);
var state_57625__$1 = state_57625;
var statearr_57630_57654 = state_57625__$1;
(statearr_57630_57654[(2)] = inst_57606);

(statearr_57630_57654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (6))){
var state_57625__$1 = state_57625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57625__$1,(9),n);
} else {
if((state_val_57626 === (3))){
var inst_57623 = (state_57625[(2)]);
var state_57625__$1 = state_57625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57625__$1,inst_57623);
} else {
if((state_val_57626 === (12))){
var inst_57601 = (state_57625[(7)]);
var inst_57609 = (state_57625[(2)]);
var inst_57610 = fluree.db.dbfunctions.internal.rem(inst_57601,inst_57609);
var inst_57611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57612 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57614 = [inst_57601,inst_57609];
var inst_57615 = (new cljs.core.PersistentVector(null,2,(5),inst_57613,inst_57614,null));
var inst_57616 = ["rem",inst_57615,inst_57610];
var inst_57617 = cljs.core.PersistentHashMap.fromArrays(inst_57612,inst_57616);
var inst_57618 = [inst_57617,(2)];
var inst_57619 = (new cljs.core.PersistentVector(null,2,(5),inst_57611,inst_57618,null));
var inst_57620 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57619);
var _ = (function (){var statearr_57631 = state_57625;
(statearr_57631[(4)] = cljs.core.rest((state_57625[(4)])));

return statearr_57631;
})();
var state_57625__$1 = (function (){var statearr_57632 = state_57625;
(statearr_57632[(8)] = inst_57620);

return statearr_57632;
})();
var statearr_57633_57655 = state_57625__$1;
(statearr_57633_57655[(2)] = inst_57610);

(statearr_57633_57655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (2))){
var _ = (function (){var statearr_57634 = state_57625;
(statearr_57634[(4)] = cljs.core.cons((5),(state_57625[(4)])));

return statearr_57634;
})();
var inst_57594 = fluree.db.util.async.channel_QMARK_(n);
var state_57625__$1 = state_57625;
if(inst_57594){
var statearr_57635_57656 = state_57625__$1;
(statearr_57635_57656[(1)] = (6));

} else {
var statearr_57636_57657 = state_57625__$1;
(statearr_57636_57657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (11))){
var state_57625__$1 = state_57625;
var statearr_57638_57658 = state_57625__$1;
(statearr_57638_57658[(2)] = d);

(statearr_57638_57658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (9))){
var inst_57597 = (state_57625[(2)]);
var inst_57598 = fluree.db.util.async.throw_err(inst_57597);
var state_57625__$1 = state_57625;
var statearr_57639_57659 = state_57625__$1;
(statearr_57639_57659[(2)] = inst_57598);

(statearr_57639_57659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (5))){
var _ = (function (){var statearr_57640 = state_57625;
(statearr_57640[(4)] = cljs.core.rest((state_57625[(4)])));

return statearr_57640;
})();
var state_57625__$1 = state_57625;
var ex57637 = (state_57625__$1[(2)]);
var statearr_57641_57660 = state_57625__$1;
(statearr_57641_57660[(5)] = ex57637);


if((ex57637 instanceof Error)){
var statearr_57642_57661 = state_57625__$1;
(statearr_57642_57661[(1)] = (4));

(statearr_57642_57661[(5)] = null);

} else {
throw ex57637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57626 === (10))){
var state_57625__$1 = state_57625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57625__$1,(13),d);
} else {
if((state_val_57626 === (8))){
var inst_57601 = (state_57625[(2)]);
var inst_57602 = fluree.db.util.async.channel_QMARK_(d);
var state_57625__$1 = (function (){var statearr_57643 = state_57625;
(statearr_57643[(7)] = inst_57601);

return statearr_57643;
})();
if(inst_57602){
var statearr_57644_57662 = state_57625__$1;
(statearr_57644_57662[(1)] = (10));

} else {
var statearr_57645_57663 = state_57625__$1;
(statearr_57645_57663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0 = (function (){
var statearr_57646 = [null,null,null,null,null,null,null,null,null];
(statearr_57646[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__);

(statearr_57646[(1)] = (1));

return statearr_57646;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1 = (function (state_57625){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57625);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57647){var ex__2882__auto__ = e57647;
var statearr_57648_57664 = state_57625;
(statearr_57648_57664[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57625[(4)]))){
var statearr_57649_57665 = state_57625;
(statearr_57649_57665[(1)] = cljs.core.first((state_57625[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57666 = state_57625;
state_57625 = G__57666;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__ = function(state_57625){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1.call(this,state_57625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57650 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57650[(6)] = c__2901__auto__);

return statearr_57650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57693){
var state_val_57694 = (state_57693[(1)]);
if((state_val_57694 === (7))){
var state_57693__$1 = state_57693;
var statearr_57695_57714 = state_57693__$1;
(statearr_57695_57714[(2)] = x);

(statearr_57695_57714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (1))){
var state_57693__$1 = state_57693;
var statearr_57696_57715 = state_57693__$1;
(statearr_57696_57715[(2)] = null);

(statearr_57696_57715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (4))){
var inst_57667 = (state_57693[(2)]);
var state_57693__$1 = state_57693;
var statearr_57697_57716 = state_57693__$1;
(statearr_57697_57716[(2)] = inst_57667);

(statearr_57697_57716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (6))){
var state_57693__$1 = state_57693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57693__$1,(9),x);
} else {
if((state_val_57694 === (3))){
var inst_57691 = (state_57693[(2)]);
var state_57693__$1 = state_57693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57693__$1,inst_57691);
} else {
if((state_val_57694 === (2))){
var _ = (function (){var statearr_57699 = state_57693;
(statearr_57699[(4)] = cljs.core.cons((5),(state_57693[(4)])));

return statearr_57699;
})();
var inst_57673 = fluree.db.util.async.channel_QMARK_(x);
var state_57693__$1 = state_57693;
if(inst_57673){
var statearr_57700_57717 = state_57693__$1;
(statearr_57700_57717[(1)] = (6));

} else {
var statearr_57701_57718 = state_57693__$1;
(statearr_57701_57718[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (9))){
var inst_57676 = (state_57693[(2)]);
var inst_57677 = fluree.db.util.async.throw_err(inst_57676);
var state_57693__$1 = state_57693;
var statearr_57702_57719 = state_57693__$1;
(statearr_57702_57719[(2)] = inst_57677);

(statearr_57702_57719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (5))){
var _ = (function (){var statearr_57703 = state_57693;
(statearr_57703[(4)] = cljs.core.rest((state_57693[(4)])));

return statearr_57703;
})();
var state_57693__$1 = state_57693;
var ex57698 = (state_57693__$1[(2)]);
var statearr_57704_57720 = state_57693__$1;
(statearr_57704_57720[(5)] = ex57698);


if((ex57698 instanceof Error)){
var statearr_57705_57721 = state_57693__$1;
(statearr_57705_57721[(1)] = (4));

(statearr_57705_57721[(5)] = null);

} else {
throw ex57698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57694 === (8))){
var inst_57680 = (state_57693[(2)]);
var inst_57681 = fluree.db.dbfunctions.internal.boolean$(inst_57680);
var inst_57682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57683 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57684 = ["boolean",inst_57680,inst_57681];
var inst_57685 = cljs.core.PersistentHashMap.fromArrays(inst_57683,inst_57684);
var inst_57686 = [inst_57685,(10)];
var inst_57687 = (new cljs.core.PersistentVector(null,2,(5),inst_57682,inst_57686,null));
var inst_57688 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57687);
var _ = (function (){var statearr_57706 = state_57693;
(statearr_57706[(4)] = cljs.core.rest((state_57693[(4)])));

return statearr_57706;
})();
var state_57693__$1 = (function (){var statearr_57707 = state_57693;
(statearr_57707[(7)] = inst_57688);

return statearr_57707;
})();
var statearr_57708_57722 = state_57693__$1;
(statearr_57708_57722[(2)] = inst_57681);

(statearr_57708_57722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0 = (function (){
var statearr_57709 = [null,null,null,null,null,null,null,null];
(statearr_57709[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__);

(statearr_57709[(1)] = (1));

return statearr_57709;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1 = (function (state_57693){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57693);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57710){var ex__2882__auto__ = e57710;
var statearr_57711_57723 = state_57693;
(statearr_57711_57723[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57693[(4)]))){
var statearr_57712_57724 = state_57693;
(statearr_57712_57724[(1)] = cljs.core.first((state_57693[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57725 = state_57693;
state_57693 = G__57725;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__ = function(state_57693){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1.call(this,state_57693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57713 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57713[(6)] = c__2901__auto__);

return statearr_57713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57763){
var state_val_57764 = (state_57763[(1)]);
if((state_val_57764 === (7))){
var state_57763__$1 = state_57763;
var statearr_57765_57789 = state_57763__$1;
(statearr_57765_57789[(2)] = pattern);

(statearr_57765_57789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (1))){
var state_57763__$1 = state_57763;
var statearr_57766_57790 = state_57763__$1;
(statearr_57766_57790[(2)] = null);

(statearr_57766_57790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (4))){
var inst_57726 = (state_57763[(2)]);
var state_57763__$1 = state_57763;
var statearr_57767_57791 = state_57763__$1;
(statearr_57767_57791[(2)] = inst_57726);

(statearr_57767_57791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (13))){
var inst_57743 = (state_57763[(2)]);
var inst_57744 = fluree.db.util.async.throw_err(inst_57743);
var state_57763__$1 = state_57763;
var statearr_57768_57792 = state_57763__$1;
(statearr_57768_57792[(2)] = inst_57744);

(statearr_57768_57792[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (6))){
var state_57763__$1 = state_57763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57763__$1,(9),pattern);
} else {
if((state_val_57764 === (3))){
var inst_57761 = (state_57763[(2)]);
var state_57763__$1 = state_57763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57763__$1,inst_57761);
} else {
if((state_val_57764 === (12))){
var inst_57739 = (state_57763[(7)]);
var inst_57747 = (state_57763[(2)]);
var inst_57748 = fluree.db.dbfunctions.internal.re_find(inst_57739,inst_57747);
var inst_57749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57750 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57752 = [inst_57739,inst_57747];
var inst_57753 = (new cljs.core.PersistentVector(null,2,(5),inst_57751,inst_57752,null));
var inst_57754 = ["re-find",inst_57753,inst_57748];
var inst_57755 = cljs.core.PersistentHashMap.fromArrays(inst_57750,inst_57754);
var inst_57756 = [inst_57755,(10)];
var inst_57757 = (new cljs.core.PersistentVector(null,2,(5),inst_57749,inst_57756,null));
var inst_57758 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57757);
var _ = (function (){var statearr_57769 = state_57763;
(statearr_57769[(4)] = cljs.core.rest((state_57763[(4)])));

return statearr_57769;
})();
var state_57763__$1 = (function (){var statearr_57770 = state_57763;
(statearr_57770[(8)] = inst_57758);

return statearr_57770;
})();
var statearr_57771_57793 = state_57763__$1;
(statearr_57771_57793[(2)] = inst_57748);

(statearr_57771_57793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (2))){
var _ = (function (){var statearr_57772 = state_57763;
(statearr_57772[(4)] = cljs.core.cons((5),(state_57763[(4)])));

return statearr_57772;
})();
var inst_57732 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57763__$1 = state_57763;
if(inst_57732){
var statearr_57773_57794 = state_57763__$1;
(statearr_57773_57794[(1)] = (6));

} else {
var statearr_57774_57795 = state_57763__$1;
(statearr_57774_57795[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (11))){
var state_57763__$1 = state_57763;
var statearr_57776_57796 = state_57763__$1;
(statearr_57776_57796[(2)] = string);

(statearr_57776_57796[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (9))){
var inst_57735 = (state_57763[(2)]);
var inst_57736 = fluree.db.util.async.throw_err(inst_57735);
var state_57763__$1 = state_57763;
var statearr_57777_57797 = state_57763__$1;
(statearr_57777_57797[(2)] = inst_57736);

(statearr_57777_57797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (5))){
var _ = (function (){var statearr_57778 = state_57763;
(statearr_57778[(4)] = cljs.core.rest((state_57763[(4)])));

return statearr_57778;
})();
var state_57763__$1 = state_57763;
var ex57775 = (state_57763__$1[(2)]);
var statearr_57779_57798 = state_57763__$1;
(statearr_57779_57798[(5)] = ex57775);


if((ex57775 instanceof Error)){
var statearr_57780_57799 = state_57763__$1;
(statearr_57780_57799[(1)] = (4));

(statearr_57780_57799[(5)] = null);

} else {
throw ex57775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57764 === (10))){
var state_57763__$1 = state_57763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57763__$1,(13),string);
} else {
if((state_val_57764 === (8))){
var inst_57739 = (state_57763[(2)]);
var inst_57740 = fluree.db.util.async.channel_QMARK_(string);
var state_57763__$1 = (function (){var statearr_57781 = state_57763;
(statearr_57781[(7)] = inst_57739);

return statearr_57781;
})();
if(inst_57740){
var statearr_57782_57800 = state_57763__$1;
(statearr_57782_57800[(1)] = (10));

} else {
var statearr_57783_57801 = state_57763__$1;
(statearr_57783_57801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0 = (function (){
var statearr_57784 = [null,null,null,null,null,null,null,null,null];
(statearr_57784[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__);

(statearr_57784[(1)] = (1));

return statearr_57784;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1 = (function (state_57763){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57763);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57785){var ex__2882__auto__ = e57785;
var statearr_57786_57802 = state_57763;
(statearr_57786_57802[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57763[(4)]))){
var statearr_57787_57803 = state_57763;
(statearr_57787_57803[(1)] = cljs.core.first((state_57763[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57804 = state_57763;
state_57763 = G__57804;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__ = function(state_57763){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1.call(this,state_57763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57788 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57788[(6)] = c__2901__auto__);

return statearr_57788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57831){
var state_val_57832 = (state_57831[(1)]);
if((state_val_57832 === (7))){
var state_57831__$1 = state_57831;
var statearr_57833_57852 = state_57831__$1;
(statearr_57833_57852[(2)] = email);

(statearr_57833_57852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (1))){
var state_57831__$1 = state_57831;
var statearr_57834_57853 = state_57831__$1;
(statearr_57834_57853[(2)] = null);

(statearr_57834_57853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (4))){
var inst_57805 = (state_57831[(2)]);
var state_57831__$1 = state_57831;
var statearr_57835_57854 = state_57831__$1;
(statearr_57835_57854[(2)] = inst_57805);

(statearr_57835_57854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (6))){
var state_57831__$1 = state_57831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57831__$1,(9),email);
} else {
if((state_val_57832 === (3))){
var inst_57829 = (state_57831[(2)]);
var state_57831__$1 = state_57831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57831__$1,inst_57829);
} else {
if((state_val_57832 === (2))){
var _ = (function (){var statearr_57837 = state_57831;
(statearr_57837[(4)] = cljs.core.cons((5),(state_57831[(4)])));

return statearr_57837;
})();
var inst_57811 = fluree.db.util.async.channel_QMARK_(email);
var state_57831__$1 = state_57831;
if(inst_57811){
var statearr_57838_57855 = state_57831__$1;
(statearr_57838_57855[(1)] = (6));

} else {
var statearr_57839_57856 = state_57831__$1;
(statearr_57839_57856[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (9))){
var inst_57814 = (state_57831[(2)]);
var inst_57815 = fluree.db.util.async.throw_err(inst_57814);
var state_57831__$1 = state_57831;
var statearr_57840_57857 = state_57831__$1;
(statearr_57840_57857[(2)] = inst_57815);

(statearr_57840_57857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (5))){
var _ = (function (){var statearr_57841 = state_57831;
(statearr_57841[(4)] = cljs.core.rest((state_57831[(4)])));

return statearr_57841;
})();
var state_57831__$1 = state_57831;
var ex57836 = (state_57831__$1[(2)]);
var statearr_57842_57858 = state_57831__$1;
(statearr_57842_57858[(5)] = ex57836);


if((ex57836 instanceof Error)){
var statearr_57843_57859 = state_57831__$1;
(statearr_57843_57859[(1)] = (4));

(statearr_57843_57859[(5)] = null);

} else {
throw ex57836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57832 === (8))){
var inst_57818 = (state_57831[(2)]);
var inst_57819 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57818);
var inst_57820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57821 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57822 = ["re-find",inst_57818,inst_57819];
var inst_57823 = cljs.core.PersistentHashMap.fromArrays(inst_57821,inst_57822);
var inst_57824 = [inst_57823,(10)];
var inst_57825 = (new cljs.core.PersistentVector(null,2,(5),inst_57820,inst_57824,null));
var inst_57826 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57825);
var _ = (function (){var statearr_57844 = state_57831;
(statearr_57844[(4)] = cljs.core.rest((state_57831[(4)])));

return statearr_57844;
})();
var state_57831__$1 = (function (){var statearr_57845 = state_57831;
(statearr_57845[(7)] = inst_57826);

return statearr_57845;
})();
var statearr_57846_57860 = state_57831__$1;
(statearr_57846_57860[(2)] = inst_57819);

(statearr_57846_57860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_57847 = [null,null,null,null,null,null,null,null];
(statearr_57847[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__);

(statearr_57847[(1)] = (1));

return statearr_57847;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1 = (function (state_57831){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57831);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57848){var ex__2882__auto__ = e57848;
var statearr_57849_57861 = state_57831;
(statearr_57849_57861[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57831[(4)]))){
var statearr_57850_57862 = state_57831;
(statearr_57850_57862[(1)] = cljs.core.first((state_57831[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57863 = state_57831;
state_57831 = G__57863;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__ = function(state_57831){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1.call(this,state_57831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57851 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57851[(6)] = c__2901__auto__);

return statearr_57851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57910){
var state_val_57911 = (state_57910[(1)]);
if((state_val_57911 === (7))){
var inst_57880 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57910__$1 = state_57910;
if(cljs.core.truth_(inst_57880)){
var statearr_57912_57939 = state_57910__$1;
(statearr_57912_57939[(1)] = (9));

} else {
var statearr_57913_57940 = state_57910__$1;
(statearr_57913_57940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (1))){
var state_57910__$1 = state_57910;
var statearr_57914_57941 = state_57910__$1;
(statearr_57914_57941[(2)] = null);

(statearr_57914_57941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (4))){
var inst_57864 = (state_57910[(2)]);
var state_57910__$1 = state_57910;
var statearr_57915_57942 = state_57910__$1;
(statearr_57915_57942[(2)] = inst_57864);

(statearr_57915_57942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (15))){
var inst_57891 = (state_57910[(2)]);
var state_57910__$1 = state_57910;
var statearr_57916_57943 = state_57910__$1;
(statearr_57916_57943[(2)] = inst_57891);

(statearr_57916_57943[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (13))){
var inst_57888 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57910__$1 = state_57910;
var statearr_57917_57944 = state_57910__$1;
(statearr_57917_57944[(2)] = inst_57888);

(statearr_57917_57944[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (6))){
var inst_57875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57876 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57877 = [inst_57876,(0)];
var inst_57878 = (new cljs.core.PersistentVector(null,2,(5),inst_57875,inst_57877,null));
var state_57910__$1 = state_57910;
var statearr_57918_57945 = state_57910__$1;
(statearr_57918_57945[(2)] = inst_57878);

(statearr_57918_57945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (3))){
var inst_57908 = (state_57910[(2)]);
var state_57910__$1 = state_57910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57910__$1,inst_57908);
} else {
if((state_val_57911 === (12))){
var inst_57884 = (state_57910[(2)]);
var inst_57885 = fluree.db.util.async.throw_err(inst_57884);
var state_57910__$1 = state_57910;
var statearr_57919_57946 = state_57910__$1;
(statearr_57919_57946[(2)] = inst_57885);

(statearr_57919_57946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (2))){
var _ = (function (){var statearr_57920 = state_57910;
(statearr_57920[(4)] = cljs.core.cons((5),(state_57910[(4)])));

return statearr_57920;
})();
var inst_57873 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57910__$1 = state_57910;
if(cljs.core.truth_(inst_57873)){
var statearr_57921_57947 = state_57910__$1;
(statearr_57921_57947[(1)] = (6));

} else {
var statearr_57922_57948 = state_57910__$1;
(statearr_57922_57948[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (11))){
var inst_57893 = (state_57910[(2)]);
var state_57910__$1 = state_57910;
var statearr_57924_57949 = state_57910__$1;
(statearr_57924_57949[(2)] = inst_57893);

(statearr_57924_57949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (9))){
var inst_57882 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57910__$1 = state_57910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57910__$1,(12),inst_57882);
} else {
if((state_val_57911 === (5))){
var _ = (function (){var statearr_57925 = state_57910;
(statearr_57925[(4)] = cljs.core.rest((state_57910[(4)])));

return statearr_57925;
})();
var state_57910__$1 = state_57910;
var ex57923 = (state_57910__$1[(2)]);
var statearr_57926_57950 = state_57910__$1;
(statearr_57926_57950[(5)] = ex57923);


if((ex57923 instanceof Error)){
var statearr_57927_57951 = state_57910__$1;
(statearr_57927_57951[(1)] = (4));

(statearr_57927_57951[(5)] = null);

} else {
throw ex57923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (14))){
var state_57910__$1 = state_57910;
var statearr_57928_57952 = state_57910__$1;
(statearr_57928_57952[(2)] = null);

(statearr_57928_57952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (10))){
var state_57910__$1 = state_57910;
var statearr_57929_57953 = state_57910__$1;
(statearr_57929_57953[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57911 === (8))){
var inst_57895 = (state_57910[(2)]);
var inst_57896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57895,(0),null);
var inst_57897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57895,(1),null);
var inst_57898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57900 = ["?user_id","?ctx",inst_57896];
var inst_57901 = cljs.core.PersistentHashMap.fromArrays(inst_57899,inst_57900);
var inst_57902 = ((10) + inst_57897);
var inst_57903 = [inst_57901,inst_57902];
var inst_57904 = (new cljs.core.PersistentVector(null,2,(5),inst_57898,inst_57903,null));
var inst_57905 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57904);
var _ = (function (){var statearr_57931 = state_57910;
(statearr_57931[(4)] = cljs.core.rest((state_57910[(4)])));

return statearr_57931;
})();
var state_57910__$1 = (function (){var statearr_57932 = state_57910;
(statearr_57932[(7)] = inst_57905);

return statearr_57932;
})();
var statearr_57933_57954 = state_57910__$1;
(statearr_57933_57954[(2)] = inst_57896);

(statearr_57933_57954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0 = (function (){
var statearr_57934 = [null,null,null,null,null,null,null,null];
(statearr_57934[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__);

(statearr_57934[(1)] = (1));

return statearr_57934;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1 = (function (state_57910){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57910);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57935){var ex__2882__auto__ = e57935;
var statearr_57936_57955 = state_57910;
(statearr_57936_57955[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57910[(4)]))){
var statearr_57937_57956 = state_57910;
(statearr_57937_57956[(1)] = cljs.core.first((state_57910[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57957 = state_57910;
state_57910 = G__57957;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__ = function(state_57910){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1.call(this,state_57910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57938 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_57938[(6)] = c__2901__auto__);

return statearr_57938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57985){
var state_val_57986 = (state_57985[(1)]);
if((state_val_57986 === (7))){
var inst_57978 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57985__$1 = state_57985;
var statearr_57987_58006 = state_57985__$1;
(statearr_57987_58006[(2)] = inst_57978);

(statearr_57987_58006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (1))){
var state_57985__$1 = state_57985;
var statearr_57988_58007 = state_57985__$1;
(statearr_57988_58007[(2)] = null);

(statearr_57988_58007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (4))){
var inst_57958 = (state_57985[(2)]);
var state_57985__$1 = state_57985;
var statearr_57989_58008 = state_57985__$1;
(statearr_57989_58008[(2)] = inst_57958);

(statearr_57989_58008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (6))){
var inst_57966 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57985__$1 = state_57985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57985__$1,(9),inst_57966);
} else {
if((state_val_57986 === (3))){
var inst_57983 = (state_57985[(2)]);
var state_57985__$1 = state_57985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57985__$1,inst_57983);
} else {
if((state_val_57986 === (2))){
var _ = (function (){var statearr_57991 = state_57985;
(statearr_57991[(4)] = cljs.core.cons((5),(state_57985[(4)])));

return statearr_57991;
})();
var inst_57964 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57985__$1 = state_57985;
if(cljs.core.truth_(inst_57964)){
var statearr_57992_58009 = state_57985__$1;
(statearr_57992_58009[(1)] = (6));

} else {
var statearr_57993_58010 = state_57985__$1;
(statearr_57993_58010[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (9))){
var inst_57968 = (state_57985[(2)]);
var inst_57969 = fluree.db.util.async.throw_err(inst_57968);
var inst_57970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57971 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57972 = ["?auth_id","?ctx",inst_57969];
var inst_57973 = cljs.core.PersistentHashMap.fromArrays(inst_57971,inst_57972);
var inst_57974 = [inst_57973,(10)];
var inst_57975 = (new cljs.core.PersistentVector(null,2,(5),inst_57970,inst_57974,null));
var inst_57976 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57975);
var state_57985__$1 = (function (){var statearr_57994 = state_57985;
(statearr_57994[(7)] = inst_57976);

return statearr_57994;
})();
var statearr_57995_58011 = state_57985__$1;
(statearr_57995_58011[(2)] = inst_57969);

(statearr_57995_58011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (5))){
var _ = (function (){var statearr_57996 = state_57985;
(statearr_57996[(4)] = cljs.core.rest((state_57985[(4)])));

return statearr_57996;
})();
var state_57985__$1 = state_57985;
var ex57990 = (state_57985__$1[(2)]);
var statearr_57997_58012 = state_57985__$1;
(statearr_57997_58012[(5)] = ex57990);


if((ex57990 instanceof Error)){
var statearr_57998_58013 = state_57985__$1;
(statearr_57998_58013[(1)] = (4));

(statearr_57998_58013[(5)] = null);

} else {
throw ex57990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57986 === (8))){
var inst_57980 = (state_57985[(2)]);
var _ = (function (){var statearr_57999 = state_57985;
(statearr_57999[(4)] = cljs.core.rest((state_57985[(4)])));

return statearr_57999;
})();
var state_57985__$1 = state_57985;
var statearr_58000_58014 = state_57985__$1;
(statearr_58000_58014[(2)] = inst_57980);

(statearr_58000_58014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0 = (function (){
var statearr_58001 = [null,null,null,null,null,null,null,null];
(statearr_58001[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__);

(statearr_58001[(1)] = (1));

return statearr_58001;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1 = (function (state_57985){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_57985);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58002){var ex__2882__auto__ = e58002;
var statearr_58003_58015 = state_57985;
(statearr_58003_58015[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_57985[(4)]))){
var statearr_58004_58016 = state_57985;
(statearr_58004_58016[(1)] = cljs.core.first((state_57985[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58017 = state_57985;
state_57985 = G__58017;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__ = function(state_57985){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1.call(this,state_57985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58005 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58005[(6)] = c__2901__auto__);

return statearr_58005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__58019 = arguments.length;
switch (G__58019) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58061){
var state_val_58062 = (state_58061[(1)]);
if((state_val_58062 === (7))){
var state_58061__$1 = state_58061;
var statearr_58063_58093 = state_58061__$1;
(statearr_58063_58093[(2)] = seed);

(statearr_58063_58093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (1))){
var state_58061__$1 = state_58061;
var statearr_58064_58094 = state_58061__$1;
(statearr_58064_58094[(2)] = null);

(statearr_58064_58094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (4))){
var inst_58020 = (state_58061[(2)]);
var state_58061__$1 = state_58061;
var statearr_58065_58095 = state_58061__$1;
(statearr_58065_58095[(2)] = inst_58020);

(statearr_58065_58095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (15))){
var state_58061__$1 = state_58061;
var statearr_58066_58096 = state_58061__$1;
(statearr_58066_58096[(2)] = (10));

(statearr_58066_58096[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (13))){
var inst_58037 = (state_58061[(2)]);
var inst_58038 = fluree.db.util.async.throw_err(inst_58037);
var state_58061__$1 = state_58061;
var statearr_58067_58097 = state_58061__$1;
(statearr_58067_58097[(2)] = inst_58038);

(statearr_58067_58097[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (6))){
var state_58061__$1 = state_58061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58061__$1,(9),seed);
} else {
if((state_val_58062 === (3))){
var inst_58059 = (state_58061[(2)]);
var state_58061__$1 = state_58061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58061__$1,inst_58059);
} else {
if((state_val_58062 === (12))){
var inst_58041 = (state_58061[(7)]);
var inst_58041__$1 = (state_58061[(2)]);
var state_58061__$1 = (function (){var statearr_58068 = state_58061;
(statearr_58068[(7)] = inst_58041__$1);

return statearr_58068;
})();
if(cljs.core.truth_(inst_58041__$1)){
var statearr_58069_58098 = state_58061__$1;
(statearr_58069_58098[(1)] = (14));

} else {
var statearr_58070_58099 = state_58061__$1;
(statearr_58070_58099[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (2))){
var _ = (function (){var statearr_58071 = state_58061;
(statearr_58071[(4)] = cljs.core.cons((5),(state_58061[(4)])));

return statearr_58071;
})();
var inst_58026 = fluree.db.util.async.channel_QMARK_(seed);
var state_58061__$1 = state_58061;
if(inst_58026){
var statearr_58072_58100 = state_58061__$1;
(statearr_58072_58100[(1)] = (6));

} else {
var statearr_58073_58101 = state_58061__$1;
(statearr_58073_58101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (11))){
var state_58061__$1 = state_58061;
var statearr_58075_58102 = state_58061__$1;
(statearr_58075_58102[(2)] = max);

(statearr_58075_58102[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (9))){
var inst_58029 = (state_58061[(2)]);
var inst_58030 = fluree.db.util.async.throw_err(inst_58029);
var state_58061__$1 = state_58061;
var statearr_58076_58103 = state_58061__$1;
(statearr_58076_58103[(2)] = inst_58030);

(statearr_58076_58103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (5))){
var _ = (function (){var statearr_58077 = state_58061;
(statearr_58077[(4)] = cljs.core.rest((state_58061[(4)])));

return statearr_58077;
})();
var state_58061__$1 = state_58061;
var ex58074 = (state_58061__$1[(2)]);
var statearr_58078_58104 = state_58061__$1;
(statearr_58078_58104[(5)] = ex58074);


if((ex58074 instanceof Error)){
var statearr_58079_58105 = state_58061__$1;
(statearr_58079_58105[(1)] = (4));

(statearr_58079_58105[(5)] = null);

} else {
throw ex58074;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (14))){
var inst_58041 = (state_58061[(7)]);
var state_58061__$1 = state_58061;
var statearr_58080_58106 = state_58061__$1;
(statearr_58080_58106[(2)] = inst_58041);

(statearr_58080_58106[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (16))){
var inst_58033 = (state_58061[(8)]);
var inst_58045 = (state_58061[(2)]);
var inst_58046 = fluree.db.dbfunctions.internal.rand(inst_58033,inst_58045);
var inst_58047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58048 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58050 = [max,seed];
var inst_58051 = (new cljs.core.PersistentVector(null,2,(5),inst_58049,inst_58050,null));
var inst_58052 = ["rand",inst_58051,inst_58046];
var inst_58053 = cljs.core.PersistentHashMap.fromArrays(inst_58048,inst_58052);
var inst_58054 = [inst_58053,(10)];
var inst_58055 = (new cljs.core.PersistentVector(null,2,(5),inst_58047,inst_58054,null));
var inst_58056 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58055);
var _ = (function (){var statearr_58081 = state_58061;
(statearr_58081[(4)] = cljs.core.rest((state_58061[(4)])));

return statearr_58081;
})();
var state_58061__$1 = (function (){var statearr_58082 = state_58061;
(statearr_58082[(9)] = inst_58056);

return statearr_58082;
})();
var statearr_58083_58107 = state_58061__$1;
(statearr_58083_58107[(2)] = inst_58046);

(statearr_58083_58107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58062 === (10))){
var state_58061__$1 = state_58061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58061__$1,(13),max);
} else {
if((state_val_58062 === (8))){
var inst_58033 = (state_58061[(2)]);
var inst_58034 = fluree.db.util.async.channel_QMARK_(max);
var state_58061__$1 = (function (){var statearr_58084 = state_58061;
(statearr_58084[(8)] = inst_58033);

return statearr_58084;
})();
if(inst_58034){
var statearr_58085_58108 = state_58061__$1;
(statearr_58085_58108[(1)] = (10));

} else {
var statearr_58086_58109 = state_58061__$1;
(statearr_58086_58109[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_58087 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58087[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_58087[(1)] = (1));

return statearr_58087;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_58061){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_58061);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58088){var ex__2882__auto__ = e58088;
var statearr_58089_58110 = state_58061;
(statearr_58089_58110[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_58061[(4)]))){
var statearr_58090_58111 = state_58061;
(statearr_58090_58111[(1)] = cljs.core.first((state_58061[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58112 = state_58061;
state_58061 = G__58112;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_58061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_58061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58091 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58091[(6)] = c__2901__auto__);

return statearr_58091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58133){
var state_val_58134 = (state_58133[(1)]);
if((state_val_58134 === (1))){
var state_58133__$1 = state_58133;
var statearr_58135_58150 = state_58133__$1;
(statearr_58135_58150[(2)] = null);

(statearr_58135_58150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58134 === (2))){
var _ = (function (){var statearr_58136 = state_58133;
(statearr_58136[(4)] = cljs.core.cons((5),(state_58133[(4)])));

return statearr_58136;
})();
var inst_58119 = fluree.db.util.core.random_uuid();
var inst_58120 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58119);
var inst_58121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58122 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58123 = cljs.core.PersistentVector.EMPTY;
var inst_58124 = ["uuid",inst_58123,inst_58120];
var inst_58125 = cljs.core.PersistentHashMap.fromArrays(inst_58122,inst_58124);
var inst_58126 = [inst_58125,(10)];
var inst_58127 = (new cljs.core.PersistentVector(null,2,(5),inst_58121,inst_58126,null));
var inst_58128 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58127);
var ___$1 = (function (){var statearr_58137 = state_58133;
(statearr_58137[(4)] = cljs.core.rest((state_58133[(4)])));

return statearr_58137;
})();
var state_58133__$1 = (function (){var statearr_58138 = state_58133;
(statearr_58138[(7)] = inst_58128);

return statearr_58138;
})();
var statearr_58139_58151 = state_58133__$1;
(statearr_58139_58151[(2)] = inst_58120);

(statearr_58139_58151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58134 === (3))){
var inst_58131 = (state_58133[(2)]);
var state_58133__$1 = state_58133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58133__$1,inst_58131);
} else {
if((state_val_58134 === (4))){
var inst_58113 = (state_58133[(2)]);
var state_58133__$1 = state_58133;
var statearr_58141_58152 = state_58133__$1;
(statearr_58141_58152[(2)] = inst_58113);

(statearr_58141_58152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58134 === (5))){
var _ = (function (){var statearr_58142 = state_58133;
(statearr_58142[(4)] = cljs.core.rest((state_58133[(4)])));

return statearr_58142;
})();
var state_58133__$1 = state_58133;
var ex58140 = (state_58133__$1[(2)]);
var statearr_58143_58153 = state_58133__$1;
(statearr_58143_58153[(5)] = ex58140);


if((ex58140 instanceof Error)){
var statearr_58144_58154 = state_58133__$1;
(statearr_58144_58154[(1)] = (4));

(statearr_58144_58154[(5)] = null);

} else {
throw ex58140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0 = (function (){
var statearr_58145 = [null,null,null,null,null,null,null,null];
(statearr_58145[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__);

(statearr_58145[(1)] = (1));

return statearr_58145;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1 = (function (state_58133){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_58133);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58146){var ex__2882__auto__ = e58146;
var statearr_58147_58155 = state_58133;
(statearr_58147_58155[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_58133[(4)]))){
var statearr_58148_58156 = state_58133;
(statearr_58148_58156[(1)] = cljs.core.first((state_58133[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58157 = state_58133;
state_58133 = G__58157;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__ = function(state_58133){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1.call(this,state_58133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58149 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58149[(6)] = c__2901__auto__);

return statearr_58149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58187){
var state_val_58188 = (state_58187[(1)]);
if((state_val_58188 === (7))){
var state_58187__$1 = state_58187;
var statearr_58189_58208 = state_58187__$1;
(statearr_58189_58208[(2)] = num);

(statearr_58189_58208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (1))){
var state_58187__$1 = state_58187;
var statearr_58190_58209 = state_58187__$1;
(statearr_58190_58209[(2)] = null);

(statearr_58190_58209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (4))){
var inst_58158 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58191_58210 = state_58187__$1;
(statearr_58191_58210[(2)] = inst_58158);

(statearr_58191_58210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (6))){
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58187__$1,(9),num);
} else {
if((state_val_58188 === (3))){
var inst_58185 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58187__$1,inst_58185);
} else {
if((state_val_58188 === (2))){
var _ = (function (){var statearr_58193 = state_58187;
(statearr_58193[(4)] = cljs.core.cons((5),(state_58187[(4)])));

return statearr_58193;
})();
var inst_58164 = fluree.db.util.async.channel_QMARK_(num);
var state_58187__$1 = state_58187;
if(inst_58164){
var statearr_58194_58211 = state_58187__$1;
(statearr_58194_58211[(1)] = (6));

} else {
var statearr_58195_58212 = state_58187__$1;
(statearr_58195_58212[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (9))){
var inst_58167 = (state_58187[(2)]);
var inst_58168 = fluree.db.util.async.throw_err(inst_58167);
var state_58187__$1 = state_58187;
var statearr_58196_58213 = state_58187__$1;
(statearr_58196_58213[(2)] = inst_58168);

(statearr_58196_58213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (5))){
var _ = (function (){var statearr_58197 = state_58187;
(statearr_58197[(4)] = cljs.core.rest((state_58187[(4)])));

return statearr_58197;
})();
var state_58187__$1 = state_58187;
var ex58192 = (state_58187__$1[(2)]);
var statearr_58198_58214 = state_58187__$1;
(statearr_58198_58214[(5)] = ex58192);


if((ex58192 instanceof Error)){
var statearr_58199_58215 = state_58187__$1;
(statearr_58199_58215[(1)] = (4));

(statearr_58199_58215[(5)] = null);

} else {
throw ex58192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (8))){
var inst_58171 = (state_58187[(2)]);
var inst_58172 = fluree.db.dbfunctions.internal.ceil(inst_58171);
var inst_58173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58174 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58176 = [fluree.db.dbfunctions.fns.ceil];
var inst_58177 = (new cljs.core.PersistentVector(null,1,(5),inst_58175,inst_58176,null));
var inst_58178 = ["",inst_58177,inst_58172];
var inst_58179 = cljs.core.PersistentHashMap.fromArrays(inst_58174,inst_58178);
var inst_58180 = [inst_58179,(10)];
var inst_58181 = (new cljs.core.PersistentVector(null,2,(5),inst_58173,inst_58180,null));
var inst_58182 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58181);
var _ = (function (){var statearr_58200 = state_58187;
(statearr_58200[(4)] = cljs.core.rest((state_58187[(4)])));

return statearr_58200;
})();
var state_58187__$1 = (function (){var statearr_58201 = state_58187;
(statearr_58201[(7)] = inst_58182);

return statearr_58201;
})();
var statearr_58202_58216 = state_58187__$1;
(statearr_58202_58216[(2)] = inst_58172);

(statearr_58202_58216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0 = (function (){
var statearr_58203 = [null,null,null,null,null,null,null,null];
(statearr_58203[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__);

(statearr_58203[(1)] = (1));

return statearr_58203;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1 = (function (state_58187){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_58187);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58204){var ex__2882__auto__ = e58204;
var statearr_58205_58217 = state_58187;
(statearr_58205_58217[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_58187[(4)]))){
var statearr_58206_58218 = state_58187;
(statearr_58206_58218[(1)] = cljs.core.first((state_58187[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58219 = state_58187;
state_58187 = G__58219;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__ = function(state_58187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1.call(this,state_58187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58207 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58207[(6)] = c__2901__auto__);

return statearr_58207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58249){
var state_val_58250 = (state_58249[(1)]);
if((state_val_58250 === (7))){
var state_58249__$1 = state_58249;
var statearr_58251_58270 = state_58249__$1;
(statearr_58251_58270[(2)] = num);

(statearr_58251_58270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (1))){
var state_58249__$1 = state_58249;
var statearr_58252_58271 = state_58249__$1;
(statearr_58252_58271[(2)] = null);

(statearr_58252_58271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (4))){
var inst_58220 = (state_58249[(2)]);
var state_58249__$1 = state_58249;
var statearr_58253_58272 = state_58249__$1;
(statearr_58253_58272[(2)] = inst_58220);

(statearr_58253_58272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (6))){
var state_58249__$1 = state_58249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58249__$1,(9),num);
} else {
if((state_val_58250 === (3))){
var inst_58247 = (state_58249[(2)]);
var state_58249__$1 = state_58249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58249__$1,inst_58247);
} else {
if((state_val_58250 === (2))){
var _ = (function (){var statearr_58255 = state_58249;
(statearr_58255[(4)] = cljs.core.cons((5),(state_58249[(4)])));

return statearr_58255;
})();
var inst_58226 = fluree.db.util.async.channel_QMARK_(num);
var state_58249__$1 = state_58249;
if(inst_58226){
var statearr_58256_58273 = state_58249__$1;
(statearr_58256_58273[(1)] = (6));

} else {
var statearr_58257_58274 = state_58249__$1;
(statearr_58257_58274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (9))){
var inst_58229 = (state_58249[(2)]);
var inst_58230 = fluree.db.util.async.throw_err(inst_58229);
var state_58249__$1 = state_58249;
var statearr_58258_58275 = state_58249__$1;
(statearr_58258_58275[(2)] = inst_58230);

(statearr_58258_58275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (5))){
var _ = (function (){var statearr_58259 = state_58249;
(statearr_58259[(4)] = cljs.core.rest((state_58249[(4)])));

return statearr_58259;
})();
var state_58249__$1 = state_58249;
var ex58254 = (state_58249__$1[(2)]);
var statearr_58260_58276 = state_58249__$1;
(statearr_58260_58276[(5)] = ex58254);


if((ex58254 instanceof Error)){
var statearr_58261_58277 = state_58249__$1;
(statearr_58261_58277[(1)] = (4));

(statearr_58261_58277[(5)] = null);

} else {
throw ex58254;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58250 === (8))){
var inst_58233 = (state_58249[(2)]);
var inst_58234 = fluree.db.dbfunctions.internal.floor(inst_58233);
var inst_58235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58236 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58238 = [fluree.db.dbfunctions.fns.floor];
var inst_58239 = (new cljs.core.PersistentVector(null,1,(5),inst_58237,inst_58238,null));
var inst_58240 = ["",inst_58239,inst_58234];
var inst_58241 = cljs.core.PersistentHashMap.fromArrays(inst_58236,inst_58240);
var inst_58242 = [inst_58241,(10)];
var inst_58243 = (new cljs.core.PersistentVector(null,2,(5),inst_58235,inst_58242,null));
var inst_58244 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58243);
var _ = (function (){var statearr_58262 = state_58249;
(statearr_58262[(4)] = cljs.core.rest((state_58249[(4)])));

return statearr_58262;
})();
var state_58249__$1 = (function (){var statearr_58263 = state_58249;
(statearr_58263[(7)] = inst_58244);

return statearr_58263;
})();
var statearr_58264_58278 = state_58249__$1;
(statearr_58264_58278[(2)] = inst_58234);

(statearr_58264_58278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0 = (function (){
var statearr_58265 = [null,null,null,null,null,null,null,null];
(statearr_58265[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__);

(statearr_58265[(1)] = (1));

return statearr_58265;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1 = (function (state_58249){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_58249);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58266){var ex__2882__auto__ = e58266;
var statearr_58267_58279 = state_58249;
(statearr_58267_58279[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_58249[(4)]))){
var statearr_58268_58280 = state_58249;
(statearr_58268_58280[(1)] = cljs.core.first((state_58249[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58281 = state_58249;
state_58249 = G__58281;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__ = function(state_58249){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1.call(this,state_58249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58269 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58269[(6)] = c__2901__auto__);

return statearr_58269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58306){
var state_val_58307 = (state_58306[(1)]);
if((state_val_58307 === (1))){
var state_58306__$1 = state_58306;
var statearr_58308_58323 = state_58306__$1;
(statearr_58308_58323[(2)] = null);

(statearr_58308_58323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58307 === (2))){
var _ = (function (){var statearr_58309 = state_58306;
(statearr_58309[(4)] = cljs.core.cons((5),(state_58306[(4)])));

return statearr_58309;
})();
var inst_58288 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_58306__$1 = state_58306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58306__$1,(6),inst_58288);
} else {
if((state_val_58307 === (3))){
var inst_58304 = (state_58306[(2)]);
var state_58306__$1 = state_58306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58306__$1,inst_58304);
} else {
if((state_val_58307 === (4))){
var inst_58282 = (state_58306[(2)]);
var state_58306__$1 = state_58306;
var statearr_58311_58324 = state_58306__$1;
(statearr_58311_58324[(2)] = inst_58282);

(statearr_58311_58324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58307 === (5))){
var _ = (function (){var statearr_58312 = state_58306;
(statearr_58312[(4)] = cljs.core.rest((state_58306[(4)])));

return statearr_58312;
})();
var state_58306__$1 = state_58306;
var ex58310 = (state_58306__$1[(2)]);
var statearr_58313_58325 = state_58306__$1;
(statearr_58313_58325[(5)] = ex58310);


if((ex58310 instanceof Error)){
var statearr_58314_58326 = state_58306__$1;
(statearr_58314_58326[(1)] = (4));

(statearr_58314_58326[(5)] = null);

} else {
throw ex58310;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58307 === (6))){
var inst_58290 = (state_58306[(2)]);
var inst_58291 = fluree.db.util.async.throw_err(inst_58290);
var inst_58292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58293 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58295 = [compare_val,new_val];
var inst_58296 = (new cljs.core.PersistentVector(null,2,(5),inst_58294,inst_58295,null));
var inst_58297 = ["",inst_58296,inst_58291];
var inst_58298 = cljs.core.PersistentHashMap.fromArrays(inst_58293,inst_58297);
var inst_58299 = [inst_58298,(10)];
var inst_58300 = (new cljs.core.PersistentVector(null,2,(5),inst_58292,inst_58299,null));
var inst_58301 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58300);
var _ = (function (){var statearr_58315 = state_58306;
(statearr_58315[(4)] = cljs.core.rest((state_58306[(4)])));

return statearr_58315;
})();
var state_58306__$1 = (function (){var statearr_58316 = state_58306;
(statearr_58316[(7)] = inst_58301);

return statearr_58316;
})();
var statearr_58317_58327 = state_58306__$1;
(statearr_58317_58327[(2)] = inst_58291);

(statearr_58317_58327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0 = (function (){
var statearr_58318 = [null,null,null,null,null,null,null,null];
(statearr_58318[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__);

(statearr_58318[(1)] = (1));

return statearr_58318;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1 = (function (state_58306){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_58306);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58319){var ex__2882__auto__ = e58319;
var statearr_58320_58328 = state_58306;
(statearr_58320_58328[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_58306[(4)]))){
var statearr_58321_58329 = state_58306;
(statearr_58321_58329[(1)] = cljs.core.first((state_58306[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58330 = state_58306;
state_58306 = G__58330;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__ = function(state_58306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1.call(this,state_58306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58322 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_58322[(6)] = c__2901__auto__);

return statearr_58322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
