// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.crypto.scrypt');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('goog.object');
fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl = require('@fluree/sjcl');
/**
 * Returns a random byte array of the specified size.
 *   NOTE: This will only work in the browser, not for node.js
 */
fluree.crypto.scrypt.random_bytes = (function fluree$crypto$scrypt$random_bytes(size){
var seed = (new Uint8Array(size));
window.crypto.getRandomValues(seed);

return seed;
});
/**
 * Encrypts message (bytes) using salt (bytes).
 *   Returns encrypted message in bytes directly.
 * 
 *   Note verification of message will require the identical salt, n, r, p used
 *   by the original encryption.
 */
fluree.crypto.scrypt.encrypt = (function fluree$crypto$scrypt$encrypt(var_args){
var G__61838 = arguments.length;
switch (G__61838) {
case 1:
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$1 = (function (raw){
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$2(raw,fluree.crypto.scrypt.random_bytes((16)));
}));

(fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$2 = (function (raw,salt){
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$3(raw,salt,(32768));
}));

(fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$3 = (function (raw,salt,n){
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$5(raw,salt,n,(8),(1));
}));

(fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$5 = (function (raw,salt,n,r,p){
return fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$6(raw,salt,n,r,p,(32));
}));

(fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$6 = (function (raw,salt,n,r,p,dk_len){
var rawBits = (fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1(raw) : fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.call(null,raw));
var saltBits = (fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1(salt) : fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.call(null,salt));
var length = ((8) * dk_len);
var res = (new fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.crypt.scrypt(rawBits,saltBits,n,r,p,length));
return (fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1(res) : fluree.crypto.scrypt.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.call(null,res));
}));

(fluree.crypto.scrypt.encrypt.cljs$lang$maxFixedArity = 6);

/**
 * Compare raw message (bytes) with previously encrypted (bytes) that was
 *   encrypted with the provided salt, n, r and p.
 *   Returns true or false.
 */
fluree.crypto.scrypt.check = (function fluree$crypto$scrypt$check(var_args){
var G__61841 = arguments.length;
switch (G__61841) {
case 3:
return fluree.crypto.scrypt.check.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 6:
return fluree.crypto.scrypt.check.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.scrypt.check.cljs$core$IFn$_invoke$arity$3 = (function (raw,encrypted,salt){
return fluree.crypto.scrypt.check.cljs$core$IFn$_invoke$arity$6(raw,encrypted,salt,(32768),(8),(1));
}));

(fluree.crypto.scrypt.check.cljs$core$IFn$_invoke$arity$6 = (function (raw,encrypted,salt,n,r,p){
var dk_len = encrypted.length;
var is_valid_QMARK_ = (function (encrypted__$1,test){
return goog.object.equals(encrypted__$1,test);
});
var to_test = fluree.crypto.scrypt.encrypt.cljs$core$IFn$_invoke$arity$6(raw,salt,n,r,p,dk_len);
return is_valid_QMARK_(encrypted,to_test);
}));

(fluree.crypto.scrypt.check.cljs$lang$maxFixedArity = 6);

