// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e16730){var e = e16730;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__16731_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__16731_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__16731_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__16731_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16732_SHARP_){
return cljs.core.conj.call(null,p1__16732_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16733_SHARP_){
return cljs.core.conj.call(null,p1__16733_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__16738 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__16738,(0),null);
var _ = cljs.core.nth.call(null,vec__16738,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16734_SHARP_){
return cljs.core.conj.call(null,p1__16734_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__16741 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__16741,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__16741,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16735_SHARP_){
return cljs.core.conj.call(null,p1__16735_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16736_SHARP_){
return cljs.core.conj.call(null,p1__16736_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16737_SHARP_){
return cljs.core.conj.call(null,p1__16737_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__16744_SHARP_){
return cljs.core.nth.call(null,array,p1__16744_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__16747,optional_QMARK_,fuel,max_fuel){
var map__16748 = p__16747;
var map__16748__$1 = (((((!((map__16748 == null))))?(((((map__16748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16748):map__16748);
var res = map__16748__$1;
var vars = cljs.core.get.call(null,map__16748__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16815){
var state_val_16816 = (state_16815[(1)]);
if((state_val_16816 === (7))){
var inst_16804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16805 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_16806 = cljs.core.conj.call(null,inst_16805,clause);
var inst_16807 = [null,inst_16806];
var inst_16808 = (new cljs.core.PersistentVector(null,2,(5),inst_16804,inst_16807,null));
var state_16815__$1 = state_16815;
var statearr_16817_16845 = state_16815__$1;
(statearr_16817_16845[(2)] = inst_16808);

(statearr_16817_16845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (1))){
var state_16815__$1 = state_16815;
var statearr_16818_16846 = state_16815__$1;
(statearr_16818_16846[(2)] = null);

(statearr_16818_16846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (4))){
var inst_16750 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16819_16847 = state_16815__$1;
(statearr_16819_16847[(2)] = inst_16750);

(statearr_16819_16847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (15))){
var inst_16793 = (state_16815[(2)]);
var inst_16794 = fluree.db.util.async.throw_err.call(null,inst_16793);
var inst_16795 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_16794);
var inst_16796 = cljs.core.count.call(null,inst_16795);
var inst_16797 = fluree.db.query.analytical.add_fuel.call(null,inst_16796,fuel,max_fuel);
var inst_16798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16799 = [inst_16794,r];
var inst_16800 = (new cljs.core.PersistentVector(null,2,(5),inst_16798,inst_16799,null));
var state_16815__$1 = (function (){var statearr_16820 = state_16815;
(statearr_16820[(7)] = inst_16797);

return statearr_16820;
})();
var statearr_16821_16848 = state_16815__$1;
(statearr_16821_16848[(2)] = inst_16800);

(statearr_16821_16848[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (13))){
var inst_16759 = (state_16815[(8)]);
var inst_16772 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16773 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_16772);
var inst_16774 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_16759);
var inst_16775 = cljs.core.apply.call(null,cljs.core.concat,inst_16774);
var inst_16776 = cljs.core.set.call(null,inst_16775);
var inst_16777 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_16773);
var inst_16778 = cljs.core.apply.call(null,cljs.core.concat,inst_16777);
var inst_16779 = cljs.core.into.call(null,inst_16776,inst_16778);
var inst_16780 = (function (){var all_wd = inst_16759;
var optional = inst_16773;
var all_wd_vars = inst_16776;
var all_vars = inst_16779;
return (function (p1__16745_SHARP_){
return all_vars.call(null,p1__16745_SHARP_);
});
})();
var inst_16781 = cljs.core.keys.call(null,vars);
var inst_16782 = cljs.core.map.call(null,inst_16780,inst_16781);
var inst_16783 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_16782);
var inst_16784 = cljs.core.set.call(null,inst_16783);
var inst_16785 = (function (){var all_wd = inst_16759;
var optional = inst_16773;
var all_wd_vars = inst_16776;
var all_vars = inst_16779;
var intersecting_vars = inst_16784;
return (function (p1__16746_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__16746_SHARP_);
});
})();
var inst_16786 = cljs.core.map.call(null,inst_16785,inst_16759);
var inst_16787 = cljs.core.apply.call(null,cljs.core.concat,inst_16786);
var inst_16788 = fluree.db.query.analytical.select_from_tuples.call(null,inst_16787,res);
var inst_16789 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_16759,inst_16784,vars);
var inst_16790 = cljs.core.remove.call(null,inst_16784,inst_16779);
var inst_16791 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_16789,inst_16787,inst_16788,inst_16790,inst_16773);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16815__$1,(15),inst_16791);
} else {
if((state_val_16816 === (6))){
var inst_16760 = (state_16815[(9)]);
var inst_16758 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16759 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_16758);
var inst_16760__$1 = optional_QMARK_;
var state_16815__$1 = (function (){var statearr_16822 = state_16815;
(statearr_16822[(8)] = inst_16759);

(statearr_16822[(9)] = inst_16760__$1);

return statearr_16822;
})();
if(cljs.core.truth_(inst_16760__$1)){
var statearr_16823_16849 = state_16815__$1;
(statearr_16823_16849[(1)] = (9));

} else {
var statearr_16824_16850 = state_16815__$1;
(statearr_16824_16850[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (3))){
var inst_16813 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16815__$1,inst_16813);
} else {
if((state_val_16816 === (12))){
var inst_16768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16769 = [null,r];
var inst_16770 = (new cljs.core.PersistentVector(null,2,(5),inst_16768,inst_16769,null));
var state_16815__$1 = state_16815;
var statearr_16825_16851 = state_16815__$1;
(statearr_16825_16851[(2)] = inst_16770);

(statearr_16825_16851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (2))){
var _ = (function (){var statearr_16826 = state_16815;
(statearr_16826[(4)] = cljs.core.cons.call(null,(5),(state_16815[(4)])));

return statearr_16826;
})();
var inst_16756 = (r == null);
var state_16815__$1 = state_16815;
if(cljs.core.truth_(inst_16756)){
var statearr_16827_16852 = state_16815__$1;
(statearr_16827_16852[(1)] = (6));

} else {
var statearr_16828_16853 = state_16815__$1;
(statearr_16828_16853[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (11))){
var inst_16766 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
if(cljs.core.truth_(inst_16766)){
var statearr_16830_16854 = state_16815__$1;
(statearr_16830_16854[(1)] = (12));

} else {
var statearr_16831_16855 = state_16815__$1;
(statearr_16831_16855[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (9))){
var inst_16759 = (state_16815[(8)]);
var inst_16762 = cljs.core.empty_QMARK_.call(null,inst_16759);
var inst_16763 = (!(inst_16762));
var state_16815__$1 = state_16815;
var statearr_16832_16856 = state_16815__$1;
(statearr_16832_16856[(2)] = inst_16763);

(statearr_16832_16856[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (5))){
var _ = (function (){var statearr_16833 = state_16815;
(statearr_16833[(4)] = cljs.core.rest.call(null,(state_16815[(4)])));

return statearr_16833;
})();
var state_16815__$1 = state_16815;
var ex16829 = (state_16815__$1[(2)]);
var statearr_16834_16857 = state_16815__$1;
(statearr_16834_16857[(5)] = ex16829);


if((ex16829 instanceof Error)){
var statearr_16835_16858 = state_16815__$1;
(statearr_16835_16858[(1)] = (4));

(statearr_16835_16858[(5)] = null);

} else {
throw ex16829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (14))){
var inst_16802 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16836_16859 = state_16815__$1;
(statearr_16836_16859[(2)] = inst_16802);

(statearr_16836_16859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (10))){
var inst_16760 = (state_16815[(9)]);
var state_16815__$1 = state_16815;
var statearr_16837_16860 = state_16815__$1;
(statearr_16837_16860[(2)] = inst_16760);

(statearr_16837_16860[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (8))){
var inst_16810 = (state_16815[(2)]);
var _ = (function (){var statearr_16838 = state_16815;
(statearr_16838[(4)] = cljs.core.rest.call(null,(state_16815[(4)])));

return statearr_16838;
})();
var state_16815__$1 = state_16815;
var statearr_16839_16861 = state_16815__$1;
(statearr_16839_16861[(2)] = inst_16810);

(statearr_16839_16861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_16840 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16840[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__);

(statearr_16840[(1)] = (1));

return statearr_16840;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1 = (function (state_16815){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16841){var ex__2882__auto__ = e16841;
var statearr_16842_16862 = state_16815;
(statearr_16842_16862[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16815[(4)]))){
var statearr_16843_16863 = state_16815;
(statearr_16843_16863[(1)] = cljs.core.first.call(null,(state_16815[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16864 = state_16815;
state_16815 = G__16864;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__ = function(state_16815){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1.call(this,state_16815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16844 = f__2902__auto__.call(null);
(statearr_16844[(6)] = c__2901__auto__);

return statearr_16844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__16866 = arguments.length;
switch (G__16866) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16960){
var state_val_16961 = (state_16960[(1)]);
if((state_val_16961 === (7))){
var inst_16873 = (state_16960[(7)]);
var inst_16883 = clojure.string.starts_with_QMARK_.call(null,inst_16873,"$fdb");
var state_16960__$1 = state_16960;
if(inst_16883){
var statearr_16962_17011 = state_16960__$1;
(statearr_16962_17011[(1)] = (9));

} else {
var statearr_16963_17012 = state_16960__$1;
(statearr_16963_17012[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (20))){
var state_16960__$1 = state_16960;
var statearr_16964_17013 = state_16960__$1;
(statearr_16964_17013[(2)] = null);

(statearr_16964_17013[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (27))){
var inst_16923 = (state_16960[(8)]);
var state_16960__$1 = state_16960;
var statearr_16965_17014 = state_16960__$1;
(statearr_16965_17014[(2)] = inst_16923);

(statearr_16965_17014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (1))){
var state_16960__$1 = state_16960;
var statearr_16966_17015 = state_16960__$1;
(statearr_16966_17015[(2)] = null);

(statearr_16966_17015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (24))){
var inst_16946 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
var statearr_16967_17016 = state_16960__$1;
(statearr_16967_17016[(2)] = inst_16946);

(statearr_16967_17016[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (4))){
var inst_16867 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
var statearr_16968_17017 = state_16960__$1;
(statearr_16968_17017[(2)] = inst_16867);

(statearr_16968_17017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (15))){
var inst_16890 = (state_16960[(9)]);
var inst_16896 = (state_16960[(2)]);
var inst_16897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16898 = cljs.core.PersistentVector.EMPTY;
var inst_16899 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16900 = cljs.core.into.call(null,inst_16898,inst_16899);
var inst_16901 = [inst_16890,inst_16900];
var inst_16902 = (new cljs.core.PersistentVector(null,2,(5),inst_16897,inst_16901,null));
var state_16960__$1 = (function (){var statearr_16969 = state_16960;
(statearr_16969[(10)] = inst_16896);

return statearr_16969;
})();
var statearr_16970_17018 = state_16960__$1;
(statearr_16970_17018[(2)] = inst_16902);

(statearr_16970_17018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (21))){
var inst_16949 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
var statearr_16971_17019 = state_16960__$1;
(statearr_16971_17019[(2)] = inst_16949);

(statearr_16971_17019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (13))){
var inst_16890 = (state_16960[(9)]);
var inst_16893 = (function(){throw inst_16890})();
var state_16960__$1 = state_16960;
var statearr_16972_17020 = state_16960__$1;
(statearr_16972_17020[(2)] = inst_16893);

(statearr_16972_17020[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (22))){
var inst_16912 = (state_16960[(11)]);
var inst_16914 = (state_16960[(12)]);
var inst_16916 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_16912);
var inst_16917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16918 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_16914];
var inst_16919 = (new cljs.core.PersistentVector(null,2,(5),inst_16917,inst_16918,null));
var inst_16920 = cljs.core.get_in.call(null,opts,inst_16919);
var state_16960__$1 = (function (){var statearr_16973 = state_16960;
(statearr_16973[(13)] = inst_16916);

return statearr_16973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16960__$1,(25),inst_16920);
} else {
if((state_val_16961 === (29))){
var inst_16927 = (state_16960[(2)]);
var inst_16928 = fluree.db.util.async.throw_err.call(null,inst_16927);
var state_16960__$1 = state_16960;
var statearr_16974_17021 = state_16960__$1;
(statearr_16974_17021[(2)] = inst_16928);

(statearr_16974_17021[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (6))){
var inst_16876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16877 = cljs.core.PersistentVector.EMPTY;
var inst_16878 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16879 = cljs.core.into.call(null,inst_16877,inst_16878);
var inst_16880 = [db,inst_16879];
var inst_16881 = (new cljs.core.PersistentVector(null,2,(5),inst_16876,inst_16880,null));
var state_16960__$1 = state_16960;
var statearr_16975_17022 = state_16960__$1;
(statearr_16975_17022[(2)] = inst_16881);

(statearr_16975_17022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (28))){
var inst_16931 = (state_16960[(2)]);
var inst_16932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16933 = cljs.core.PersistentVector.EMPTY;
var inst_16934 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16935 = cljs.core.into.call(null,inst_16933,inst_16934);
var inst_16936 = [inst_16931,inst_16935];
var inst_16937 = (new cljs.core.PersistentVector(null,2,(5),inst_16932,inst_16936,null));
var state_16960__$1 = state_16960;
var statearr_16976_17023 = state_16960__$1;
(statearr_16976_17023[(2)] = inst_16937);

(statearr_16976_17023[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (25))){
var inst_16916 = (state_16960[(13)]);
var inst_16922 = (state_16960[(2)]);
var inst_16923 = fluree.db.util.async.throw_err.call(null,inst_16922);
var state_16960__$1 = (function (){var statearr_16977 = state_16960;
(statearr_16977[(8)] = inst_16923);

return statearr_16977;
})();
if(cljs.core.truth_(inst_16916)){
var statearr_16978_17024 = state_16960__$1;
(statearr_16978_17024[(1)] = (26));

} else {
var statearr_16979_17025 = state_16960__$1;
(statearr_16979_17025[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (17))){
var state_16960__$1 = state_16960;
var statearr_16980_17026 = state_16960__$1;
(statearr_16980_17026[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (3))){
var inst_16958 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16960__$1,inst_16958);
} else {
if((state_val_16961 === (12))){
var inst_16890 = (state_16960[(9)]);
var inst_16889 = (state_16960[(2)]);
var inst_16890__$1 = fluree.db.util.async.throw_err.call(null,inst_16889);
var inst_16891 = fluree.db.util.core.exception_QMARK_.call(null,inst_16890__$1);
var state_16960__$1 = (function (){var statearr_16982 = state_16960;
(statearr_16982[(9)] = inst_16890__$1);

return statearr_16982;
})();
if(inst_16891){
var statearr_16983_17027 = state_16960__$1;
(statearr_16983_17027[(1)] = (13));

} else {
var statearr_16984_17028 = state_16960__$1;
(statearr_16984_17028[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (2))){
var inst_16873 = (state_16960[(7)]);
var _ = (function (){var statearr_16985 = state_16960;
(statearr_16985[(4)] = cljs.core.cons.call(null,(5),(state_16960[(4)])));

return statearr_16985;
})();
var inst_16873__$1 = cljs.core.first.call(null,clause);
var inst_16874 = cljs.core._EQ_.call(null,"$fdb",inst_16873__$1);
var state_16960__$1 = (function (){var statearr_16986 = state_16960;
(statearr_16986[(7)] = inst_16873__$1);

return statearr_16986;
})();
if(inst_16874){
var statearr_16987_17029 = state_16960__$1;
(statearr_16987_17029[(1)] = (6));

} else {
var statearr_16988_17030 = state_16960__$1;
(statearr_16988_17030[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (23))){
var inst_16873 = (state_16960[(7)]);
var inst_16939 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16873)," is not supported in Fluree"].join('');
var inst_16940 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16941 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16942 = cljs.core.PersistentHashMap.fromArrays(inst_16940,inst_16941);
var inst_16943 = cljs.core.ex_info.call(null,inst_16939,inst_16942);
var inst_16944 = (function(){throw inst_16943})();
var state_16960__$1 = state_16960;
var statearr_16989_17031 = state_16960__$1;
(statearr_16989_17031[(2)] = inst_16944);

(statearr_16989_17031[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (19))){
var inst_16873 = (state_16960[(7)]);
var inst_16914 = (state_16960[(12)]);
var inst_16911 = fluree.db.query.analytical.isolate_source_name.call(null,inst_16873);
var inst_16912 = fluree.db.query.analytical.isolate_source_block.call(null,inst_16873);
var inst_16913 = cljs.core.keyword.call(null,inst_16911);
var inst_16914__$1 = cljs.core.get.call(null,prefixes,inst_16913);
var state_16960__$1 = (function (){var statearr_16990 = state_16960;
(statearr_16990[(11)] = inst_16912);

(statearr_16990[(12)] = inst_16914__$1);

return statearr_16990;
})();
if(cljs.core.truth_(inst_16914__$1)){
var statearr_16991_17032 = state_16960__$1;
(statearr_16991_17032[(1)] = (22));

} else {
var statearr_16992_17033 = state_16960__$1;
(statearr_16992_17033[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (11))){
var inst_16953 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
var statearr_16994_17034 = state_16960__$1;
(statearr_16994_17034[(2)] = inst_16953);

(statearr_16994_17034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (9))){
var inst_16873 = (state_16960[(7)]);
var inst_16885 = cljs.core.subs.call(null,inst_16873,(4));
var inst_16886 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_16885);
var inst_16887 = fluree.db.time_travel.as_of_block.call(null,db,inst_16886);
var state_16960__$1 = state_16960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16960__$1,(12),inst_16887);
} else {
if((state_val_16961 === (5))){
var _ = (function (){var statearr_16995 = state_16960;
(statearr_16995[(4)] = cljs.core.rest.call(null,(state_16960[(4)])));

return statearr_16995;
})();
var state_16960__$1 = state_16960;
var ex16993 = (state_16960__$1[(2)]);
var statearr_16996_17035 = state_16960__$1;
(statearr_16996_17035[(5)] = ex16993);


if((ex16993 instanceof Error)){
var statearr_16997_17036 = state_16960__$1;
(statearr_16997_17036[(1)] = (4));

(statearr_16997_17036[(5)] = null);

} else {
throw ex16993;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (14))){
var state_16960__$1 = state_16960;
var statearr_16998_17037 = state_16960__$1;
(statearr_16998_17037[(2)] = null);

(statearr_16998_17037[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (26))){
var inst_16916 = (state_16960[(13)]);
var inst_16923 = (state_16960[(8)]);
var inst_16925 = fluree.db.time_travel.as_of_block.call(null,inst_16923,inst_16916);
var state_16960__$1 = state_16960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16960__$1,(29),inst_16925);
} else {
if((state_val_16961 === (16))){
var inst_16906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16907 = ["$wd",clause];
var inst_16908 = (new cljs.core.PersistentVector(null,2,(5),inst_16906,inst_16907,null));
var state_16960__$1 = state_16960;
var statearr_16999_17038 = state_16960__$1;
(statearr_16999_17038[(2)] = inst_16908);

(statearr_16999_17038[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (10))){
var inst_16873 = (state_16960[(7)]);
var inst_16904 = cljs.core._EQ_.call(null,"$wd",inst_16873);
var state_16960__$1 = state_16960;
if(inst_16904){
var statearr_17000_17039 = state_16960__$1;
(statearr_17000_17039[(1)] = (16));

} else {
var statearr_17001_17040 = state_16960__$1;
(statearr_17001_17040[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (18))){
var inst_16951 = (state_16960[(2)]);
var state_16960__$1 = state_16960;
var statearr_17002_17041 = state_16960__$1;
(statearr_17002_17041[(2)] = inst_16951);

(statearr_17002_17041[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16961 === (8))){
var inst_16955 = (state_16960[(2)]);
var _ = (function (){var statearr_17003 = state_16960;
(statearr_17003[(4)] = cljs.core.rest.call(null,(state_16960[(4)])));

return statearr_17003;
})();
var state_16960__$1 = state_16960;
var statearr_17004_17042 = state_16960__$1;
(statearr_17004_17042[(2)] = inst_16955);

(statearr_17004_17042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2879__auto__ = null;
var fluree$db$query$analytical$state_machine__2879__auto____0 = (function (){
var statearr_17005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17005[(0)] = fluree$db$query$analytical$state_machine__2879__auto__);

(statearr_17005[(1)] = (1));

return statearr_17005;
});
var fluree$db$query$analytical$state_machine__2879__auto____1 = (function (state_16960){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17006){var ex__2882__auto__ = e17006;
var statearr_17007_17043 = state_16960;
(statearr_17007_17043[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16960[(4)]))){
var statearr_17008_17044 = state_16960;
(statearr_17008_17044[(1)] = cljs.core.first.call(null,(state_16960[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17045 = state_16960;
state_16960 = G__17045;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2879__auto__ = function(state_16960){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2879__auto____1.call(this,state_16960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2879__auto____0;
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2879__auto____1;
return fluree$db$query$analytical$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17009 = f__2902__auto__.call(null);
(statearr_17009[(6)] = c__2901__auto__);

return statearr_17009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__17046){
var vec__17047 = p__17046;
var sub = cljs.core.nth.call(null,vec__17047,(0),null);
var obj = cljs.core.nth.call(null,vec__17047,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__17050_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__17050_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__17054 = subjects;
var vec__17055 = G__17054;
var seq__17056 = cljs.core.seq.call(null,vec__17055);
var first__17057 = cljs.core.first.call(null,seq__17056);
var seq__17056__$1 = cljs.core.next.call(null,seq__17056);
var subject = first__17057;
var r = seq__17056__$1;
var acc = expanded_map;
var G__17054__$1 = G__17054;
var acc__$1 = acc;
while(true){
var vec__17061 = G__17054__$1;
var seq__17062 = cljs.core.seq.call(null,vec__17061);
var first__17063 = cljs.core.first.call(null,seq__17062);
var seq__17062__$1 = cljs.core.next.call(null,seq__17062);
var subject__$1 = first__17063;
var r__$1 = seq__17062__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__17064 = r__$1;
var G__17065 = acc__$2;
G__17054__$1 = G__17064;
acc__$1 = G__17065;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__17054__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__17054__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__17054__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__17054__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__17054__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__17054__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17061,seq__17062,first__17063,seq__17062__$1,subject__$1,r__$1,acc__$2,G__17054,vec__17055,seq__17056,first__17057,seq__17056__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__17066 = r__$1;
var G__17067 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__17054__$1 = G__17066;
acc__$1 = G__17067;
continue;
} else {
var G__17068 = subjects;
var G__17069 = acc_STAR_;
G__17054__$1 = G__17068;
acc__$1 = G__17069;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__17070_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__17070_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17161){
var state_val_17162 = (state_17161[(1)]);
if((state_val_17162 === (7))){
var state_17161__$1 = state_17161;
var statearr_17163_17209 = state_17161__$1;
(statearr_17163_17209[(2)] = (100));

(statearr_17163_17209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (20))){
var inst_17110 = (state_17161[(7)]);
var state_17161__$1 = state_17161;
var statearr_17164_17210 = state_17161__$1;
(statearr_17164_17210[(2)] = inst_17110);

(statearr_17164_17210[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (1))){
var state_17161__$1 = state_17161;
var statearr_17165_17211 = state_17161__$1;
(statearr_17165_17211[(2)] = null);

(statearr_17165_17211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (24))){
var inst_17147 = (state_17161[(8)]);
var inst_17082 = (state_17161[(9)]);
var inst_17148 = (state_17161[(10)]);
var inst_17149 = (state_17161[(11)]);
var inst_17152 = (function (){var max_depth = inst_17082;
var recur_map__$1 = inst_17148;
var subjects = inst_17147;
var tuples = inst_17149;
return (function (p1__17071_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__17071_SHARP_)],null));
});
})();
var inst_17153 = cljs.core.map.call(null,inst_17152,inst_17149);
var inst_17154 = cljs.core.distinct.call(null,inst_17153);
var state_17161__$1 = state_17161;
var statearr_17166_17212 = state_17161__$1;
(statearr_17166_17212[(2)] = inst_17154);

(statearr_17166_17212[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (4))){
var inst_17072 = (state_17161[(2)]);
var state_17161__$1 = state_17161;
var statearr_17167_17213 = state_17161__$1;
(statearr_17167_17213[(2)] = inst_17072);

(statearr_17167_17213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (15))){
var inst_17095 = (state_17161[(12)]);
var inst_17106 = cljs.core.PersistentVector.EMPTY;
var inst_17107 = cljs.core.seq.call(null,inst_17095);
var inst_17108 = cljs.core.first.call(null,inst_17107);
var inst_17109 = cljs.core.next.call(null,inst_17107);
var inst_17110 = inst_17106;
var inst_17111 = inst_17095;
var state_17161__$1 = (function (){var statearr_17168 = state_17161;
(statearr_17168[(13)] = inst_17111);

(statearr_17168[(7)] = inst_17110);

(statearr_17168[(14)] = inst_17109);

(statearr_17168[(15)] = inst_17108);

return statearr_17168;
})();
var statearr_17169_17214 = state_17161__$1;
(statearr_17169_17214[(2)] = null);

(statearr_17169_17214[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (21))){
var inst_17131 = (state_17161[(2)]);
var state_17161__$1 = state_17161;
var statearr_17170_17215 = state_17161__$1;
(statearr_17170_17215[(2)] = inst_17131);

(statearr_17170_17215[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (13))){
var inst_17144 = (state_17161[(2)]);
var state_17161__$1 = state_17161;
var statearr_17171_17216 = state_17161__$1;
(statearr_17171_17216[(2)] = inst_17144);

(statearr_17171_17216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (22))){
var inst_17110 = (state_17161[(7)]);
var inst_17118 = (state_17161[(16)]);
var inst_17125 = (state_17161[(2)]);
var inst_17126 = fluree.db.util.async.throw_err.call(null,inst_17125);
var inst_17127 = cljs.core.concat.call(null,inst_17110,inst_17126);
var inst_17110__$1 = inst_17127;
var inst_17111 = inst_17118;
var state_17161__$1 = (function (){var statearr_17172 = state_17161;
(statearr_17172[(13)] = inst_17111);

(statearr_17172[(7)] = inst_17110__$1);

return statearr_17172;
})();
var statearr_17173_17217 = state_17161__$1;
(statearr_17173_17217[(2)] = null);

(statearr_17173_17217[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (6))){
var inst_17078 = (state_17161[(17)]);
var state_17161__$1 = state_17161;
var statearr_17174_17218 = state_17161__$1;
(statearr_17174_17218[(2)] = inst_17078);

(statearr_17174_17218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (25))){
var inst_17156 = (state_17161[(2)]);
var _ = (function (){var statearr_17175 = state_17161;
(statearr_17175[(4)] = cljs.core.rest.call(null,(state_17161[(4)])));

return statearr_17175;
})();
var state_17161__$1 = state_17161;
var statearr_17176_17219 = state_17161__$1;
(statearr_17176_17219[(2)] = inst_17156);

(statearr_17176_17219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (17))){
var inst_17111 = (state_17161[(13)]);
var inst_17117 = (state_17161[(18)]);
var inst_17116 = cljs.core.seq.call(null,inst_17111);
var inst_17117__$1 = cljs.core.first.call(null,inst_17116);
var inst_17118 = cljs.core.next.call(null,inst_17116);
var state_17161__$1 = (function (){var statearr_17177 = state_17161;
(statearr_17177[(18)] = inst_17117__$1);

(statearr_17177[(16)] = inst_17118);

return statearr_17177;
})();
if(cljs.core.truth_(inst_17117__$1)){
var statearr_17178_17220 = state_17161__$1;
(statearr_17178_17220[(1)] = (19));

} else {
var statearr_17179_17221 = state_17161__$1;
(statearr_17179_17221[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (3))){
var inst_17159 = (state_17161[(2)]);
var state_17161__$1 = state_17161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17161__$1,inst_17159);
} else {
if((state_val_17162 === (12))){
var inst_17095 = (state_17161[(12)]);
var inst_17084 = (state_17161[(19)]);
var inst_17090 = cljs.core.vals.call(null,inst_17084);
var inst_17091 = cljs.core.flatten.call(null,inst_17090);
var inst_17092 = cljs.core.set.call(null,inst_17091);
var inst_17093 = cljs.core.keys.call(null,inst_17084);
var inst_17094 = cljs.core.set.call(null,inst_17093);
var inst_17095__$1 = clojure.set.difference.call(null,inst_17092,inst_17094);
var inst_17096 = cljs.core.empty_QMARK_.call(null,inst_17095__$1);
var state_17161__$1 = (function (){var statearr_17180 = state_17161;
(statearr_17180[(12)] = inst_17095__$1);

return statearr_17180;
})();
if(inst_17096){
var statearr_17181_17222 = state_17161__$1;
(statearr_17181_17222[(1)] = (14));

} else {
var statearr_17182_17223 = state_17161__$1;
(statearr_17182_17223[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (2))){
var inst_17078 = (state_17161[(17)]);
var _ = (function (){var statearr_17183 = state_17161;
(statearr_17183[(4)] = cljs.core.cons.call(null,(5),(state_17161[(4)])));

return statearr_17183;
})();
var inst_17078__$1 = depth;
var state_17161__$1 = (function (){var statearr_17184 = state_17161;
(statearr_17184[(17)] = inst_17078__$1);

return statearr_17184;
})();
if(cljs.core.truth_(inst_17078__$1)){
var statearr_17185_17224 = state_17161__$1;
(statearr_17185_17224[(1)] = (6));

} else {
var statearr_17186_17225 = state_17161__$1;
(statearr_17186_17225[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (23))){
var inst_17149 = (state_17161[(11)]);
var state_17161__$1 = state_17161;
var statearr_17187_17226 = state_17161__$1;
(statearr_17187_17226[(2)] = inst_17149);

(statearr_17187_17226[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (19))){
var inst_17117 = (state_17161[(18)]);
var inst_17120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17121 = [inst_17117,predicate];
var inst_17122 = (new cljs.core.PersistentVector(null,2,(5),inst_17120,inst_17121,null));
var inst_17123 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17122);
var state_17161__$1 = state_17161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17161__$1,(22),inst_17123);
} else {
if((state_val_17162 === (11))){
var inst_17084 = (state_17161[(19)]);
var state_17161__$1 = state_17161;
var statearr_17189_17227 = state_17161__$1;
(statearr_17189_17227[(2)] = inst_17084);

(statearr_17189_17227[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (9))){
var inst_17082 = (state_17161[(9)]);
var inst_17085 = (state_17161[(20)]);
var inst_17087 = (inst_17085 >= inst_17082);
var state_17161__$1 = state_17161;
if(cljs.core.truth_(inst_17087)){
var statearr_17190_17228 = state_17161__$1;
(statearr_17190_17228[(1)] = (11));

} else {
var statearr_17191_17229 = state_17161__$1;
(statearr_17191_17229[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (5))){
var _ = (function (){var statearr_17192 = state_17161;
(statearr_17192[(4)] = cljs.core.rest.call(null,(state_17161[(4)])));

return statearr_17192;
})();
var state_17161__$1 = state_17161;
var ex17188 = (state_17161__$1[(2)]);
var statearr_17193_17230 = state_17161__$1;
(statearr_17193_17230[(5)] = ex17188);


if((ex17188 instanceof Error)){
var statearr_17194_17231 = state_17161__$1;
(statearr_17194_17231[(1)] = (4));

(statearr_17194_17231[(5)] = null);

} else {
throw ex17188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (14))){
var inst_17084 = (state_17161[(19)]);
var state_17161__$1 = state_17161;
var statearr_17195_17232 = state_17161__$1;
(statearr_17195_17232[(2)] = inst_17084);

(statearr_17195_17232[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (16))){
var inst_17142 = (state_17161[(2)]);
var state_17161__$1 = state_17161;
var statearr_17196_17233 = state_17161__$1;
(statearr_17196_17233[(2)] = inst_17142);

(statearr_17196_17233[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (10))){
var inst_17147 = (state_17161[(8)]);
var inst_17148 = (state_17161[(10)]);
var inst_17146 = (state_17161[(2)]);
var inst_17147__$1 = cljs.core.keys.call(null,inst_17146);
var inst_17148__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_17147__$1,inst_17146);
var inst_17149 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_17147__$1,inst_17148__$1);
var state_17161__$1 = (function (){var statearr_17197 = state_17161;
(statearr_17197[(8)] = inst_17147__$1);

(statearr_17197[(10)] = inst_17148__$1);

(statearr_17197[(11)] = inst_17149);

return statearr_17197;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_17198_17234 = state_17161__$1;
(statearr_17198_17234[(1)] = (23));

} else {
var statearr_17199_17235 = state_17161__$1;
(statearr_17199_17235[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (18))){
var inst_17085 = (state_17161[(20)]);
var inst_17084 = (state_17161[(19)]);
var inst_17133 = (state_17161[(2)]);
var inst_17134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17135 = [(0),(2)];
var inst_17136 = (new cljs.core.PersistentVector(null,2,(5),inst_17134,inst_17135,null));
var inst_17137 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_17136,inst_17133);
var inst_17138 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_17084,inst_17137);
var inst_17139 = (inst_17085 + (1));
var inst_17084__$1 = inst_17138;
var inst_17085__$1 = inst_17139;
var state_17161__$1 = (function (){var statearr_17200 = state_17161;
(statearr_17200[(20)] = inst_17085__$1);

(statearr_17200[(19)] = inst_17084__$1);

return statearr_17200;
})();
var statearr_17201_17236 = state_17161__$1;
(statearr_17201_17236[(2)] = null);

(statearr_17201_17236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17162 === (8))){
var inst_17082 = (state_17161[(2)]);
var inst_17083 = recur_map;
var inst_17084 = inst_17083;
var inst_17085 = (1);
var state_17161__$1 = (function (){var statearr_17202 = state_17161;
(statearr_17202[(9)] = inst_17082);

(statearr_17202[(20)] = inst_17085);

(statearr_17202[(19)] = inst_17084);

return statearr_17202;
})();
var statearr_17203_17237 = state_17161__$1;
(statearr_17203_17237[(2)] = null);

(statearr_17203_17237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0 = (function (){
var statearr_17204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17204[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__);

(statearr_17204[(1)] = (1));

return statearr_17204;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1 = (function (state_17161){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_17161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17205){var ex__2882__auto__ = e17205;
var statearr_17206_17238 = state_17161;
(statearr_17206_17238[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_17161[(4)]))){
var statearr_17207_17239 = state_17161;
(statearr_17207_17239[(1)] = cljs.core.first.call(null,(state_17161[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17240 = state_17161;
state_17161 = G__17240;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__ = function(state_17161){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1.call(this,state_17161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17208 = f__2902__auto__.call(null);
(statearr_17208[(6)] = c__2901__auto__);

return statearr_17208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__17241,clause,fuel,max_fuel){
var map__17242 = p__17241;
var map__17242__$1 = (((((!((map__17242 == null))))?(((((map__17242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17242.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17242):map__17242);
var res = map__17242__$1;
var headers = cljs.core.get.call(null,map__17242__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__17242__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__17242__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17374){
var state_val_17375 = (state_17374[(1)]);
if((state_val_17375 === (7))){
var state_17374__$1 = state_17374;
var statearr_17376_17442 = state_17374__$1;
(statearr_17376_17442[(2)] = false);

(statearr_17376_17442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (20))){
var inst_17306 = (state_17374[(7)]);
var state_17374__$1 = state_17374;
var statearr_17377_17443 = state_17374__$1;
(statearr_17377_17443[(2)] = inst_17306);

(statearr_17377_17443[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (27))){
var inst_17310 = (state_17374[(8)]);
var inst_17334 = (state_17374[(2)]);
var state_17374__$1 = (function (){var statearr_17378 = state_17374;
(statearr_17378[(9)] = inst_17334);

return statearr_17378;
})();
if(cljs.core.truth_(inst_17310)){
var statearr_17379_17444 = state_17374__$1;
(statearr_17379_17444[(1)] = (28));

} else {
var statearr_17380_17445 = state_17374__$1;
(statearr_17380_17445[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (1))){
var state_17374__$1 = state_17374;
var statearr_17381_17446 = state_17374__$1;
(statearr_17381_17446[(2)] = null);

(statearr_17381_17446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (24))){
var inst_17322 = (state_17374[(2)]);
var inst_17323 = cljs.core.nth.call(null,clause,(2));
var inst_17324 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17323);
var state_17374__$1 = (function (){var statearr_17382 = state_17374;
(statearr_17382[(10)] = inst_17322);

return statearr_17382;
})();
if(cljs.core.truth_(inst_17324)){
var statearr_17383_17447 = state_17374__$1;
(statearr_17383_17447[(1)] = (25));

} else {
var statearr_17384_17448 = state_17374__$1;
(statearr_17384_17448[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (4))){
var inst_17244 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17385_17449 = state_17374__$1;
(statearr_17385_17449[(2)] = inst_17244);

(statearr_17385_17449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (15))){
var inst_17292 = (state_17374[(11)]);
var state_17374__$1 = state_17374;
var statearr_17386_17450 = state_17374__$1;
(statearr_17386_17450[(2)] = inst_17292);

(statearr_17386_17450[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (21))){
var inst_17277 = (state_17374[(12)]);
var inst_17365 = (state_17374[(2)]);
var inst_17366 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_17367 = cljs.core.keys.call(null,inst_17277);
var inst_17368 = [inst_17367,vars,inst_17365];
var inst_17369 = cljs.core.PersistentHashMap.fromArrays(inst_17366,inst_17368);
var _ = (function (){var statearr_17387 = state_17374;
(statearr_17387[(4)] = cljs.core.rest.call(null,(state_17374[(4)])));

return statearr_17387;
})();
var state_17374__$1 = state_17374;
var statearr_17388_17451 = state_17374__$1;
(statearr_17388_17451[(2)] = inst_17369);

(statearr_17388_17451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (31))){
var inst_17308 = (state_17374[(13)]);
var inst_17306 = (state_17374[(7)]);
var inst_17341 = cljs.core.PersistentHashMap.EMPTY;
var inst_17342 = cljs.core.flatten.call(null,inst_17306);
var inst_17343 = cljs.core.assoc.call(null,inst_17341,inst_17308,inst_17342);
var state_17374__$1 = state_17374;
var statearr_17389_17452 = state_17374__$1;
(statearr_17389_17452[(2)] = inst_17343);

(statearr_17389_17452[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (32))){
var inst_17308 = (state_17374[(13)]);
var inst_17345 = cljs.core.coll_QMARK_.call(null,inst_17308);
var state_17374__$1 = state_17374;
if(inst_17345){
var statearr_17390_17453 = state_17374__$1;
(statearr_17390_17453[(1)] = (34));

} else {
var statearr_17391_17454 = state_17374__$1;
(statearr_17391_17454[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (33))){
var inst_17356 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17392_17455 = state_17374__$1;
(statearr_17392_17455[(2)] = inst_17356);

(statearr_17392_17455[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (13))){
var inst_17254 = (state_17374[(14)]);
var state_17374__$1 = state_17374;
var statearr_17393_17456 = state_17374__$1;
(statearr_17393_17456[(2)] = inst_17254);

(statearr_17393_17456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (22))){
var inst_17290 = (state_17374[(15)]);
var inst_17314 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17290)].join('');
var inst_17315 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17316 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17317 = cljs.core.PersistentHashMap.fromArrays(inst_17315,inst_17316);
var inst_17318 = cljs.core.ex_info.call(null,inst_17314,inst_17317);
var inst_17319 = (function(){throw inst_17318})();
var state_17374__$1 = state_17374;
var statearr_17394_17457 = state_17374__$1;
(statearr_17394_17457[(2)] = inst_17319);

(statearr_17394_17457[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (36))){
var inst_17354 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17395_17458 = state_17374__$1;
(statearr_17395_17458[(2)] = inst_17354);

(statearr_17395_17458[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (29))){
var inst_17308 = (state_17374[(13)]);
var inst_17339 = typeof inst_17308 === 'number';
var state_17374__$1 = state_17374;
if(cljs.core.truth_(inst_17339)){
var statearr_17396_17459 = state_17374__$1;
(statearr_17396_17459[(1)] = (31));

} else {
var statearr_17397_17460 = state_17374__$1;
(statearr_17397_17460[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (6))){
var inst_17254 = (state_17374[(14)]);
var inst_17259 = inst_17254.cljs$lang$protocol_mask$partition0$;
var inst_17260 = (inst_17259 & (64));
var inst_17261 = inst_17254.cljs$core$ISeq$;
var inst_17262 = (cljs.core.PROTOCOL_SENTINEL === inst_17261);
var inst_17263 = ((inst_17260) || (inst_17262));
var state_17374__$1 = state_17374;
if(cljs.core.truth_(inst_17263)){
var statearr_17398_17461 = state_17374__$1;
(statearr_17398_17461[(1)] = (9));

} else {
var statearr_17399_17462 = state_17374__$1;
(statearr_17399_17462[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (28))){
var inst_17306 = (state_17374[(7)]);
var inst_17336 = cljs.core.PersistentHashMap.EMPTY;
var inst_17337 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_17336,inst_17306);
var state_17374__$1 = state_17374;
var statearr_17400_17463 = state_17374__$1;
(statearr_17400_17463[(2)] = inst_17337);

(statearr_17400_17463[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (25))){
var state_17374__$1 = state_17374;
var statearr_17401_17464 = state_17374__$1;
(statearr_17401_17464[(2)] = null);

(statearr_17401_17464[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (34))){
var inst_17302 = (state_17374[(16)]);
var inst_17306 = (state_17374[(7)]);
var inst_17347 = cljs.core.PersistentHashMap.EMPTY;
var inst_17348 = cljs.core.first.call(null,inst_17302);
var inst_17349 = cljs.core.first.call(null,inst_17348);
var inst_17350 = cljs.core.flatten.call(null,inst_17306);
var inst_17351 = cljs.core.assoc.call(null,inst_17347,inst_17349,inst_17350);
var state_17374__$1 = state_17374;
var statearr_17402_17465 = state_17374__$1;
(statearr_17402_17465[(2)] = inst_17351);

(statearr_17402_17465[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (17))){
var inst_17290 = (state_17374[(15)]);
var inst_17291 = (state_17374[(17)]);
var inst_17296 = (state_17374[(2)]);
var inst_17297 = [inst_17296];
var inst_17298 = cljs.core.PersistentHashMap.fromArrays(inst_17291,inst_17297);
var inst_17299 = fluree.db.query.range.search.call(null,db,inst_17290,inst_17298);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17374__$1,(18),inst_17299);
} else {
if((state_val_17375 === (3))){
var inst_17372 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17374__$1,inst_17372);
} else {
if((state_val_17375 === (12))){
var inst_17254 = (state_17374[(14)]);
var inst_17272 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17254);
var state_17374__$1 = state_17374;
var statearr_17403_17466 = state_17374__$1;
(statearr_17403_17466[(2)] = inst_17272);

(statearr_17403_17466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (2))){
var inst_17254 = (state_17374[(14)]);
var _ = (function (){var statearr_17404 = state_17374;
(statearr_17404[(4)] = cljs.core.cons.call(null,(5),(state_17374[(4)])));

return statearr_17404;
})();
var inst_17254__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_17256 = (inst_17254__$1 == null);
var inst_17257 = cljs.core.not.call(null,inst_17256);
var state_17374__$1 = (function (){var statearr_17405 = state_17374;
(statearr_17405[(14)] = inst_17254__$1);

return statearr_17405;
})();
if(inst_17257){
var statearr_17406_17467 = state_17374__$1;
(statearr_17406_17467[(1)] = (6));

} else {
var statearr_17407_17468 = state_17374__$1;
(statearr_17407_17468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (23))){
var state_17374__$1 = state_17374;
var statearr_17408_17469 = state_17374__$1;
(statearr_17408_17469[(2)] = null);

(statearr_17408_17469[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (35))){
var state_17374__$1 = state_17374;
var statearr_17409_17470 = state_17374__$1;
(statearr_17409_17470[(2)] = null);

(statearr_17409_17470[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (19))){
var inst_17311 = (state_17374[(18)]);
var inst_17290 = (state_17374[(15)]);
var inst_17308 = cljs.core.first.call(null,inst_17290);
var inst_17309 = cljs.core.first.call(null,clause);
var inst_17310 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17309);
var inst_17311__$1 = cljs.core.nth.call(null,inst_17290,(1));
var inst_17312 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17311__$1);
var state_17374__$1 = (function (){var statearr_17410 = state_17374;
(statearr_17410[(13)] = inst_17308);

(statearr_17410[(18)] = inst_17311__$1);

(statearr_17410[(8)] = inst_17310);

return statearr_17410;
})();
if(cljs.core.truth_(inst_17312)){
var statearr_17411_17471 = state_17374__$1;
(statearr_17411_17471[(1)] = (22));

} else {
var statearr_17412_17472 = state_17374__$1;
(statearr_17412_17472[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (11))){
var inst_17267 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17414_17473 = state_17374__$1;
(statearr_17414_17473[(2)] = inst_17267);

(statearr_17414_17473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (9))){
var state_17374__$1 = state_17374;
var statearr_17415_17474 = state_17374__$1;
(statearr_17415_17474[(2)] = true);

(statearr_17415_17474[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (5))){
var _ = (function (){var statearr_17416 = state_17374;
(statearr_17416[(4)] = cljs.core.rest.call(null,(state_17374[(4)])));

return statearr_17416;
})();
var state_17374__$1 = state_17374;
var ex17413 = (state_17374__$1[(2)]);
var statearr_17417_17475 = state_17374__$1;
(statearr_17417_17475[(5)] = ex17413);


if((ex17413 instanceof Error)){
var statearr_17418_17476 = state_17374__$1;
(statearr_17418_17476[(1)] = (4));

(statearr_17418_17476[(5)] = null);

} else {
throw ex17413;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (14))){
var inst_17277 = (state_17374[(12)]);
var inst_17280 = (state_17374[(19)]);
var inst_17281 = (state_17374[(20)]);
var inst_17292 = (state_17374[(11)]);
var inst_17275 = (state_17374[(2)]);
var inst_17276 = cljs.core.get.call(null,inst_17275,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_17277__$1 = cljs.core.get.call(null,inst_17275,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_17278 = cljs.core.get.call(null,inst_17275,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_17279 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_17280__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17278);
var inst_17281__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_17278);
var inst_17283 = (function (){var map__17250 = inst_17275;
var search = inst_17276;
var rel = inst_17277__$1;
var opts = inst_17278;
var common_keys = inst_17279;
var object_fn = inst_17280__$1;
var recur_depth = inst_17281__$1;
return (function (p__17282,common_key){
var vec__17419 = p__17282;
var acc = cljs.core.nth.call(null,vec__17419,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__17419,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__17422 = cljs.core._EQ_;
var expr__17423 = idx_of;
if(cljs.core.truth_(pred__17422.call(null,(0),expr__17423))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__17422.call(null,(1),expr__17423))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__17422.call(null,(2),expr__17423))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__17423)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_17284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17285 = cljs.core.PersistentHashMap.EMPTY;
var inst_17286 = [inst_17285,inst_17276];
var inst_17287 = (new cljs.core.PersistentVector(null,2,(5),inst_17284,inst_17286,null));
var inst_17288 = cljs.core.reduce.call(null,inst_17283,inst_17287,inst_17279);
var inst_17289 = cljs.core.nth.call(null,inst_17288,(0),null);
var inst_17290 = cljs.core.nth.call(null,inst_17288,(1),null);
var inst_17291 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_17292__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17289);
var state_17374__$1 = (function (){var statearr_17425 = state_17374;
(statearr_17425[(12)] = inst_17277__$1);

(statearr_17425[(15)] = inst_17290);

(statearr_17425[(19)] = inst_17280__$1);

(statearr_17425[(20)] = inst_17281__$1);

(statearr_17425[(17)] = inst_17291);

(statearr_17425[(11)] = inst_17292__$1);

return statearr_17425;
})();
if(cljs.core.truth_(inst_17292__$1)){
var statearr_17426_17477 = state_17374__$1;
(statearr_17426_17477[(1)] = (15));

} else {
var statearr_17427_17478 = state_17374__$1;
(statearr_17427_17478[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (26))){
var inst_17290 = (state_17374[(15)]);
var inst_17327 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17290)].join('');
var inst_17328 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17329 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17330 = cljs.core.PersistentHashMap.fromArrays(inst_17328,inst_17329);
var inst_17331 = cljs.core.ex_info.call(null,inst_17327,inst_17330);
var inst_17332 = (function(){throw inst_17331})();
var state_17374__$1 = state_17374;
var statearr_17428_17479 = state_17374__$1;
(statearr_17428_17479[(2)] = inst_17332);

(statearr_17428_17479[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (16))){
var inst_17280 = (state_17374[(19)]);
var state_17374__$1 = state_17374;
var statearr_17429_17480 = state_17374__$1;
(statearr_17429_17480[(2)] = inst_17280);

(statearr_17429_17480[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (30))){
var inst_17311 = (state_17374[(18)]);
var inst_17310 = (state_17374[(8)]);
var inst_17281 = (state_17374[(20)]);
var inst_17358 = (state_17374[(2)]);
var inst_17359 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_17311,inst_17358,inst_17281,inst_17310);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17374__$1,(37),inst_17359);
} else {
if((state_val_17375 === (10))){
var state_17374__$1 = state_17374;
var statearr_17430_17481 = state_17374__$1;
(statearr_17430_17481[(2)] = false);

(statearr_17430_17481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (18))){
var inst_17277 = (state_17374[(12)]);
var inst_17302 = (state_17374[(16)]);
var inst_17281 = (state_17374[(20)]);
var inst_17301 = (state_17374[(2)]);
var inst_17302__$1 = fluree.db.util.async.throw_err.call(null,inst_17301);
var inst_17303 = cljs.core.count.call(null,inst_17302__$1);
var inst_17304 = fluree.db.query.analytical.add_fuel.call(null,inst_17303,fuel,max_fuel);
var inst_17305 = cljs.core.vals.call(null,inst_17277);
var inst_17306 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_17305,inst_17302__$1);
var state_17374__$1 = (function (){var statearr_17431 = state_17374;
(statearr_17431[(16)] = inst_17302__$1);

(statearr_17431[(21)] = inst_17304);

(statearr_17431[(7)] = inst_17306);

return statearr_17431;
})();
if(cljs.core.truth_(inst_17281)){
var statearr_17432_17482 = state_17374__$1;
(statearr_17432_17482[(1)] = (19));

} else {
var statearr_17433_17483 = state_17374__$1;
(statearr_17433_17483[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (37))){
var inst_17361 = (state_17374[(2)]);
var inst_17362 = fluree.db.util.async.throw_err.call(null,inst_17361);
var state_17374__$1 = state_17374;
var statearr_17434_17484 = state_17374__$1;
(statearr_17434_17484[(2)] = inst_17362);

(statearr_17434_17484[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (8))){
var inst_17270 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
if(cljs.core.truth_(inst_17270)){
var statearr_17435_17485 = state_17374__$1;
(statearr_17435_17485[(1)] = (12));

} else {
var statearr_17436_17486 = state_17374__$1;
(statearr_17436_17486[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_17437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17437[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__);

(statearr_17437[(1)] = (1));

return statearr_17437;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1 = (function (state_17374){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_17374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17438){var ex__2882__auto__ = e17438;
var statearr_17439_17487 = state_17374;
(statearr_17439_17487[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_17374[(4)]))){
var statearr_17440_17488 = state_17374;
(statearr_17440_17488[(1)] = cljs.core.first.call(null,(state_17374[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17489 = state_17374;
state_17374 = G__17489;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__ = function(state_17374){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1.call(this,state_17374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17441 = f__2902__auto__.call(null);
(statearr_17441[(6)] = c__2901__auto__);

return statearr_17441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__17490,res,clause){
var map__17491 = p__17490;
var map__17491__$1 = (((((!((map__17491 == null))))?(((((map__17491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17491):map__17491);
var db = map__17491__$1;
var conn = cljs.core.get.call(null,map__17491__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__17491__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__17491__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17591){
var state_val_17592 = (state_17591[(1)]);
if((state_val_17592 === (7))){
var inst_17502 = (state_17591[(7)]);
var state_17591__$1 = state_17591;
var statearr_17593_17633 = state_17591__$1;
(statearr_17593_17633[(2)] = inst_17502);

(statearr_17593_17633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (20))){
var inst_17582 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
var statearr_17594_17634 = state_17591__$1;
(statearr_17594_17634[(2)] = inst_17582);

(statearr_17594_17634[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (1))){
var state_17591__$1 = state_17591;
var statearr_17595_17635 = state_17591__$1;
(statearr_17595_17635[(2)] = null);

(statearr_17595_17635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (24))){
var inst_17561 = (state_17591[(2)]);
var inst_17562 = fluree.db.util.async.throw_err.call(null,inst_17561);
var state_17591__$1 = state_17591;
var statearr_17596_17636 = state_17591__$1;
(statearr_17596_17636[(2)] = inst_17562);

(statearr_17596_17636[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (4))){
var inst_17495 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
var statearr_17597_17637 = state_17591__$1;
(statearr_17597_17637[(2)] = inst_17495);

(statearr_17597_17637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (15))){
var inst_17504 = (state_17591[(8)]);
var inst_17502 = (state_17591[(7)]);
var inst_17523 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17524 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17526 = [inst_17502];
var inst_17527 = (new cljs.core.PersistentVector(null,1,(5),inst_17525,inst_17526,null));
var inst_17528 = (function (){var subject_var = inst_17502;
var object_var = inst_17504;
var min_sid = inst_17523;
var max_sid = (0);
return (function (p1__17493_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17493_SHARP_);
});
})();
var inst_17529 = cljs.core.range.call(null,inst_17523,(0));
var inst_17530 = cljs.core.map.call(null,inst_17528,inst_17529);
var inst_17531 = cljs.core.PersistentHashMap.EMPTY;
var inst_17532 = [inst_17527,inst_17530,inst_17531];
var inst_17533 = cljs.core.PersistentHashMap.fromArrays(inst_17524,inst_17532);
var state_17591__$1 = state_17591;
var statearr_17598_17638 = state_17591__$1;
(statearr_17598_17638[(2)] = inst_17533);

(statearr_17598_17638[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (21))){
var inst_17555 = (state_17591[(9)]);
var state_17591__$1 = state_17591;
var statearr_17599_17639 = state_17591__$1;
(statearr_17599_17639[(2)] = inst_17555);

(statearr_17599_17639[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (13))){
var inst_17504 = (state_17591[(8)]);
var state_17591__$1 = state_17591;
if(cljs.core.truth_(inst_17504)){
var statearr_17600_17640 = state_17591__$1;
(statearr_17600_17640[(1)] = (18));

} else {
var statearr_17601_17641 = state_17591__$1;
(statearr_17601_17641[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (22))){
var inst_17555 = (state_17591[(9)]);
var inst_17559 = fluree.db.dbproto._subid.call(null,db,inst_17555);
var state_17591__$1 = state_17591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17591__$1,(24),inst_17559);
} else {
if((state_val_17592 === (6))){
var inst_17504 = (state_17591[(8)]);
var state_17591__$1 = state_17591;
var statearr_17602_17642 = state_17591__$1;
(statearr_17602_17642[(2)] = inst_17504);

(statearr_17602_17642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (17))){
var inst_17552 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
var statearr_17603_17643 = state_17591__$1;
(statearr_17603_17643[(2)] = inst_17552);

(statearr_17603_17643[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (3))){
var inst_17589 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17591__$1,inst_17589);
} else {
if((state_val_17592 === (12))){
var inst_17517 = ["_tx",null,"_block",null];
var inst_17518 = (new cljs.core.PersistentArrayMap(null,2,inst_17517,null));
var inst_17519 = (new cljs.core.PersistentHashSet(null,inst_17518,null));
var inst_17520 = cljs.core.last.call(null,clause);
var inst_17521 = inst_17519.call(null,inst_17520);
var state_17591__$1 = state_17591;
if(cljs.core.truth_(inst_17521)){
var statearr_17604_17644 = state_17591__$1;
(statearr_17604_17644[(1)] = (15));

} else {
var statearr_17605_17645 = state_17591__$1;
(statearr_17605_17645[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (2))){
var inst_17502 = (state_17591[(7)]);
var _ = (function (){var statearr_17606 = state_17591;
(statearr_17606[(4)] = cljs.core.cons.call(null,(5),(state_17591[(4)])));

return statearr_17606;
})();
var inst_17501 = cljs.core.first.call(null,clause);
var inst_17502__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17501);
var inst_17503 = cljs.core.last.call(null,clause);
var inst_17504 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17503);
var state_17591__$1 = (function (){var statearr_17607 = state_17591;
(statearr_17607[(8)] = inst_17504);

(statearr_17607[(7)] = inst_17502__$1);

return statearr_17607;
})();
if(cljs.core.truth_(inst_17502__$1)){
var statearr_17608_17646 = state_17591__$1;
(statearr_17608_17646[(1)] = (6));

} else {
var statearr_17609_17647 = state_17591__$1;
(statearr_17609_17647[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (23))){
var inst_17504 = (state_17591[(8)]);
var inst_17564 = (state_17591[(2)]);
var inst_17565 = fluree.db.flake.sid__GT_cid.call(null,inst_17564);
var inst_17566 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_17565);
var inst_17567 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17569 = [inst_17504];
var inst_17570 = (new cljs.core.PersistentVector(null,1,(5),inst_17568,inst_17569,null));
var inst_17571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17573 = [inst_17566];
var inst_17574 = (new cljs.core.PersistentVector(null,1,(5),inst_17572,inst_17573,null));
var inst_17575 = [inst_17574];
var inst_17576 = (new cljs.core.PersistentVector(null,1,(5),inst_17571,inst_17575,null));
var inst_17577 = cljs.core.PersistentHashMap.EMPTY;
var inst_17578 = [inst_17570,inst_17576,inst_17577];
var inst_17579 = cljs.core.PersistentHashMap.fromArrays(inst_17567,inst_17578);
var state_17591__$1 = state_17591;
var statearr_17610_17648 = state_17591__$1;
(statearr_17610_17648[(2)] = inst_17579);

(statearr_17610_17648[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (19))){
var state_17591__$1 = state_17591;
var statearr_17611_17649 = state_17591__$1;
(statearr_17611_17649[(2)] = null);

(statearr_17611_17649[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (11))){
var inst_17586 = (state_17591[(2)]);
var _ = (function (){var statearr_17613 = state_17591;
(statearr_17613[(4)] = cljs.core.rest.call(null,(state_17591[(4)])));

return statearr_17613;
})();
var state_17591__$1 = state_17591;
var statearr_17614_17650 = state_17591__$1;
(statearr_17614_17650[(2)] = inst_17586);

(statearr_17614_17650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (9))){
var inst_17510 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17511 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17512 = cljs.core.PersistentHashMap.fromArrays(inst_17510,inst_17511);
var inst_17513 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_17512);
var inst_17514 = (function(){throw inst_17513})();
var state_17591__$1 = state_17591;
var statearr_17615_17651 = state_17591__$1;
(statearr_17615_17651[(2)] = inst_17514);

(statearr_17615_17651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (5))){
var _ = (function (){var statearr_17616 = state_17591;
(statearr_17616[(4)] = cljs.core.rest.call(null,(state_17591[(4)])));

return statearr_17616;
})();
var state_17591__$1 = state_17591;
var ex17612 = (state_17591__$1[(2)]);
var statearr_17617_17652 = state_17591__$1;
(statearr_17617_17652[(5)] = ex17612);


if((ex17612 instanceof Error)){
var statearr_17618_17653 = state_17591__$1;
(statearr_17618_17653[(1)] = (4));

(statearr_17618_17653[(5)] = null);

} else {
throw ex17612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (14))){
var inst_17584 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
var statearr_17619_17654 = state_17591__$1;
(statearr_17619_17654[(2)] = inst_17584);

(statearr_17619_17654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (16))){
var inst_17504 = (state_17591[(8)]);
var inst_17502 = (state_17591[(7)]);
var inst_17535 = cljs.core.last.call(null,clause);
var inst_17536 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_17535);
var inst_17537 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_17538 = cljs.core.get.call(null,inst_17537,inst_17536);
var inst_17539 = fluree.db.flake.min_subject_id.call(null,inst_17536);
var inst_17540 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17542 = [inst_17502];
var inst_17543 = (new cljs.core.PersistentVector(null,1,(5),inst_17541,inst_17542,null));
var inst_17544 = (function (){var subject_var = inst_17502;
var object_var = inst_17504;
var cid = inst_17536;
var max_sid = inst_17538;
var min_sid = inst_17539;
return (function (p1__17494_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17494_SHARP_);
});
})();
var inst_17545 = (inst_17538 + (1));
var inst_17546 = cljs.core.range.call(null,inst_17539,inst_17545);
var inst_17547 = cljs.core.map.call(null,inst_17544,inst_17546);
var inst_17548 = cljs.core.PersistentHashMap.EMPTY;
var inst_17549 = [inst_17543,inst_17547,inst_17548];
var inst_17550 = cljs.core.PersistentHashMap.fromArrays(inst_17540,inst_17549);
var state_17591__$1 = state_17591;
var statearr_17620_17655 = state_17591__$1;
(statearr_17620_17655[(2)] = inst_17550);

(statearr_17620_17655[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (10))){
var inst_17502 = (state_17591[(7)]);
var state_17591__$1 = state_17591;
if(cljs.core.truth_(inst_17502)){
var statearr_17621_17656 = state_17591__$1;
(statearr_17621_17656[(1)] = (12));

} else {
var statearr_17622_17657 = state_17591__$1;
(statearr_17622_17657[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (18))){
var inst_17555 = (state_17591[(9)]);
var inst_17555__$1 = cljs.core.first.call(null,clause);
var inst_17556 = typeof inst_17555__$1 === 'number';
var state_17591__$1 = (function (){var statearr_17623 = state_17591;
(statearr_17623[(9)] = inst_17555__$1);

return statearr_17623;
})();
if(cljs.core.truth_(inst_17556)){
var statearr_17624_17658 = state_17591__$1;
(statearr_17624_17658[(1)] = (21));

} else {
var statearr_17625_17659 = state_17591__$1;
(statearr_17625_17659[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17592 === (8))){
var inst_17508 = (state_17591[(2)]);
var state_17591__$1 = state_17591;
if(cljs.core.truth_(inst_17508)){
var statearr_17626_17660 = state_17591__$1;
(statearr_17626_17660[(1)] = (9));

} else {
var statearr_17627_17661 = state_17591__$1;
(statearr_17627_17661[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_17628 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17628[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__);

(statearr_17628[(1)] = (1));

return statearr_17628;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1 = (function (state_17591){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_17591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17629){var ex__2882__auto__ = e17629;
var statearr_17630_17662 = state_17591;
(statearr_17630_17662[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_17591[(4)]))){
var statearr_17631_17663 = state_17591;
(statearr_17631_17663[(1)] = cljs.core.first.call(null,(state_17591[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17664 = state_17591;
state_17591 = G__17664;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__ = function(state_17591){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1.call(this,state_17591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17632 = f__2902__auto__.call(null);
(statearr_17632[(6)] = c__2901__auto__);

return statearr_17632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__17670 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__17670 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__17670;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__17671(s__17672){
return (new cljs.core.LazySeq(null,(function (){
var s__17672__$1 = s__17672;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__17672__$1);
if(temp__5735__auto__){
var s__17672__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17672__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__17672__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__17674 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__17673 = (0);
while(true){
if((i__17673 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__17673);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__17674,(delta * delta));

var G__17675 = (i__17673 + (1));
i__17673 = G__17675;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17674),fluree$db$query$analytical$variance_$_iter__17671.call(null,cljs.core.chunk_rest.call(null,s__17672__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17674),null);
}
} else {
var x = cljs.core.first.call(null,s__17672__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__17671.call(null,cljs.core.rest.call(null,s__17672__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__17676 = null;
var G__17676__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17676__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17676 = function(n,coll){
switch(arguments.length){
case 1:
return G__17676__1.call(this,n);
case 2:
return G__17676__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17676.cljs$core$IFn$_invoke$arity$1 = G__17676__1;
G__17676.cljs$core$IFn$_invoke$arity$2 = G__17676__2;
return G__17676;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17677 = null;
var G__17677__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17677__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17677 = function(n,coll){
switch(arguments.length){
case 1:
return G__17677__1.call(this,n);
case 2:
return G__17677__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17677.cljs$core$IFn$_invoke$arity$1 = G__17677__1;
G__17677.cljs$core$IFn$_invoke$arity$2 = G__17677__2;
return G__17677;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17678 = null;
var G__17678__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__17678__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__17678 = function(n,coll){
switch(arguments.length){
case 1:
return G__17678__1.call(this,n);
case 2:
return G__17678__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17678.cljs$core$IFn$_invoke$arity$1 = G__17678__1;
G__17678.cljs$core$IFn$_invoke$arity$2 = G__17678__2;
return G__17678;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__17679 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__17679,(0),null);
var arg = cljs.core.nth.call(null,vec__17679,(1),null);
var var$ = cljs.core.nth.call(null,vec__17679,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17682 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__17682,(0),null);
var variable = cljs.core.nth.call(null,vec__17682,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__17685 = agg;
var map__17685__$1 = (((((!((map__17685 == null))))?(((((map__17685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17685):map__17685);
var variable = cljs.core.get.call(null,map__17685__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__17685__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__17685__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__17688 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__17688,(0),null);
var agg_result = cljs.core.nth.call(null,vec__17688,(1),null);
var map__17691 = res__$1;
var map__17691__$1 = (((((!((map__17691 == null))))?(((((map__17691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17691):map__17691);
var headers = cljs.core.get.call(null,map__17691__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__17691__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__17687_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__17687_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__17693_SHARP_){
return cljs.core.nth.call(null,tuple,p1__17693_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__17694_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__17694_SHARP_);
}),a_idxs);
var temp__5733__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5733__auto__)){
var b_matched = temp__5733__auto__;
return cljs.core.reduce.call(null,(function (p1__17695_SHARP_,p2__17696_SHARP_){
return cljs.core.conj.call(null,p1__17695_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__17696_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__17697_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__17697_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__17700,row,b_tuple){
var vec__17701 = p__17700;
var acc = cljs.core.nth.call(null,vec__17701,(0),null);
var b_rows = cljs.core.nth.call(null,vec__17701,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__17698_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17698_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__17699_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17699_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__17704_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__17704_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17705_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17705_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17707_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17707_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17706_SHARP_){
return cljs.core.range.call(null,(0),p1__17706_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__17708_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17708_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__17709_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17709_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17710_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17710_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17712_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17712_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17711_SHARP_){
return cljs.core.range.call(null,(0),p1__17711_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__17713_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17713_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__17714_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17714_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17715_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17715_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17717_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17717_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17716_SHARP_){
return cljs.core.range.call(null,(0),p1__17716_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__17720 = cljs.core.reduce.call(null,(function (p__17723,a_tuple){
var vec__17724 = p__17723;
var c_tuples = cljs.core.nth.call(null,vec__17724,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__17724,(1),null);
var vec__17727 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__17727,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__17727,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,cljs.core.vec.call(null,c_tuples),matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__17720,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__17720,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__17718_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17718_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__17719_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17719_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__17731 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__17731,(0),null);
var _ = cljs.core.nth.call(null,vec__17731,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__17730_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__17730_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__17736 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__17736,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__17736,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__17734_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__17734_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__17735_SHARP_){
return cljs.core.nth.call(null,clause,p1__17735_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__17739,filters,optional_QMARK_){
var map__17740 = p__17739;
var map__17740__$1 = (((((!((map__17740 == null))))?(((((map__17740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17740):map__17740);
var tuple_map = map__17740__$1;
var headers = cljs.core.get.call(null,map__17740__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__17740__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__17740__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__17742 = clause;
var k = cljs.core.nth.call(null,vec__17742,(0),null);
var v = cljs.core.nth.call(null,vec__17742,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__17745 = res;
var map__17745__$1 = (((((!((map__17745 == null))))?(((((map__17745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17745):map__17745);
var headers = cljs.core.get.call(null,map__17745__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__17745__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_17802){
var state_val_17803 = (state_17802[(1)]);
if((state_val_17803 === (7))){
var inst_17776 = (state_17802[(7)]);
var inst_17774 = (state_17802[(2)]);
var inst_17775 = fluree.db.util.async.throw_err.call(null,inst_17774);
var inst_17776__$1 = cljs.core.nth.call(null,inst_17775,(0),null);
var inst_17777 = cljs.core.nth.call(null,inst_17775,(1),null);
var inst_17778 = (inst_17776__$1 == null);
var state_17802__$1 = (function (){var statearr_17804 = state_17802;
(statearr_17804[(8)] = inst_17777);

(statearr_17804[(7)] = inst_17776__$1);

return statearr_17804;
})();
if(cljs.core.truth_(inst_17778)){
var statearr_17805_17834 = state_17802__$1;
(statearr_17805_17834[(1)] = (8));

} else {
var statearr_17806_17835 = state_17802__$1;
(statearr_17806_17835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (1))){
var inst_17754 = optional_clauses;
var inst_17755 = cljs.core.seq.call(null,inst_17754);
var inst_17756 = cljs.core.first.call(null,inst_17755);
var inst_17757 = cljs.core.next.call(null,inst_17755);
var inst_17758 = where_tuples;
var inst_17759 = inst_17754;
var inst_17760 = inst_17758;
var state_17802__$1 = (function (){var statearr_17807 = state_17802;
(statearr_17807[(9)] = inst_17757);

(statearr_17807[(10)] = inst_17756);

(statearr_17807[(11)] = inst_17760);

(statearr_17807[(12)] = inst_17759);

return statearr_17807;
})();
var statearr_17808_17836 = state_17802__$1;
(statearr_17808_17836[(2)] = null);

(statearr_17808_17836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (4))){
var inst_17766 = (state_17802[(13)]);
var inst_17767 = (state_17802[(14)]);
var inst_17760 = (state_17802[(11)]);
var inst_17772 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_17760,inst_17766,inst_17767,true,fuel,max_fuel,opts);
var state_17802__$1 = state_17802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17802__$1,(7),inst_17772);
} else {
if((state_val_17803 === (15))){
var state_17802__$1 = state_17802;
var statearr_17809_17837 = state_17802__$1;
(statearr_17809_17837[(2)] = null);

(statearr_17809_17837[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (13))){
var inst_17793 = (state_17802[(2)]);
var state_17802__$1 = state_17802;
var statearr_17810_17838 = state_17802__$1;
(statearr_17810_17838[(2)] = inst_17793);

(statearr_17810_17838[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (6))){
var inst_17798 = (state_17802[(2)]);
var state_17802__$1 = state_17802;
var statearr_17811_17839 = state_17802__$1;
(statearr_17811_17839[(2)] = inst_17798);

(statearr_17811_17839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (3))){
var inst_17800 = (state_17802[(2)]);
var state_17802__$1 = state_17802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17802__$1,inst_17800);
} else {
if((state_val_17803 === (12))){
var state_17802__$1 = state_17802;
var statearr_17812_17840 = state_17802__$1;
(statearr_17812_17840[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (2))){
var inst_17766 = (state_17802[(13)]);
var inst_17759 = (state_17802[(12)]);
var inst_17765 = cljs.core.seq.call(null,inst_17759);
var inst_17766__$1 = cljs.core.first.call(null,inst_17765);
var inst_17767 = cljs.core.next.call(null,inst_17765);
var state_17802__$1 = (function (){var statearr_17814 = state_17802;
(statearr_17814[(13)] = inst_17766__$1);

(statearr_17814[(14)] = inst_17767);

return statearr_17814;
})();
if(cljs.core.truth_(inst_17766__$1)){
var statearr_17815_17841 = state_17802__$1;
(statearr_17815_17841[(1)] = (4));

} else {
var statearr_17816_17842 = state_17802__$1;
(statearr_17816_17842[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (11))){
var inst_17777 = (state_17802[(8)]);
var inst_17776 = (state_17802[(7)]);
var inst_17759 = inst_17777;
var inst_17760 = inst_17776;
var state_17802__$1 = (function (){var statearr_17817 = state_17802;
(statearr_17817[(11)] = inst_17760);

(statearr_17817[(12)] = inst_17759);

return statearr_17817;
})();
var statearr_17818_17843 = state_17802__$1;
(statearr_17818_17843[(2)] = null);

(statearr_17818_17843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (9))){
var inst_17766 = (state_17802[(13)]);
var inst_17782 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_17766);
var state_17802__$1 = state_17802;
if(cljs.core.truth_(inst_17782)){
var statearr_17819_17844 = state_17802__$1;
(statearr_17819_17844[(1)] = (11));

} else {
var statearr_17820_17845 = state_17802__$1;
(statearr_17820_17845[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (5))){
var inst_17760 = (state_17802[(11)]);
var state_17802__$1 = state_17802;
var statearr_17821_17846 = state_17802__$1;
(statearr_17821_17846[(2)] = inst_17760);

(statearr_17821_17846[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (14))){
var inst_17777 = (state_17802[(8)]);
var inst_17760 = (state_17802[(11)]);
var inst_17776 = (state_17802[(7)]);
var inst_17787 = fluree.db.query.analytical.left_outer_join.call(null,inst_17760,inst_17776);
var inst_17759 = inst_17777;
var inst_17760__$1 = inst_17787;
var state_17802__$1 = (function (){var statearr_17822 = state_17802;
(statearr_17822[(11)] = inst_17760__$1);

(statearr_17822[(12)] = inst_17759);

return statearr_17822;
})();
var statearr_17823_17847 = state_17802__$1;
(statearr_17823_17847[(2)] = null);

(statearr_17823_17847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (16))){
var inst_17791 = (state_17802[(2)]);
var state_17802__$1 = state_17802;
var statearr_17825_17848 = state_17802__$1;
(statearr_17825_17848[(2)] = inst_17791);

(statearr_17825_17848[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (10))){
var inst_17795 = (state_17802[(2)]);
var state_17802__$1 = state_17802;
var statearr_17826_17849 = state_17802__$1;
(statearr_17826_17849[(2)] = inst_17795);

(statearr_17826_17849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17803 === (8))){
var inst_17777 = (state_17802[(8)]);
var inst_17760 = (state_17802[(11)]);
var tmp17824 = inst_17760;
var inst_17759 = inst_17777;
var inst_17760__$1 = tmp17824;
var state_17802__$1 = (function (){var statearr_17827 = state_17802;
(statearr_17827[(11)] = inst_17760__$1);

(statearr_17827[(12)] = inst_17759);

return statearr_17827;
})();
var statearr_17828_17850 = state_17802__$1;
(statearr_17828_17850[(2)] = null);

(statearr_17828_17850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0 = (function (){
var statearr_17829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17829[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__);

(statearr_17829[(1)] = (1));

return statearr_17829;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1 = (function (state_17802){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_17802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e17830){var ex__2882__auto__ = e17830;
var statearr_17831_17851 = state_17802;
(statearr_17831_17851[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_17802[(4)]))){
var statearr_17832_17852 = state_17802;
(statearr_17832_17852[(1)] = cljs.core.first.call(null,(state_17802[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17853 = state_17802;
state_17802 = G__17853;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__ = function(state_17802){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1.call(this,state_17802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_17833 = f__2902__auto__.call(null);
(statearr_17833[(6)] = c__2901__auto__);

return statearr_17833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__17855){
var vec__17856 = p__17855;
var var_name = cljs.core.nth.call(null,vec__17856,(0),null);
var var_val = cljs.core.nth.call(null,vec__17856,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__17854_SHARP_){
return cljs.core.conj.call(null,p1__17854_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__17860,p__17861,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__17862 = p__17860;
var map__17862__$1 = (((((!((map__17862 == null))))?(((((map__17862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17862):map__17862);
var q_map = map__17862__$1;
var prefixes = cljs.core.get.call(null,map__17862__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__17863 = p__17861;
var map__17863__$1 = (((((!((map__17863 == null))))?(((((map__17863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17863):map__17863);
var res = map__17863__$1;
var vars = cljs.core.get.call(null,map__17863__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18072){
var state_val_18073 = (state_18072[(1)]);
if((state_val_18073 === (7))){
var inst_17970 = cljs.core.count.call(null,clause);
var inst_17971 = cljs.core._EQ_.call(null,(3),inst_17970);
var inst_17972 = cljs.core.second.call(null,clause);
var inst_17973 = clojure.string.starts_with_QMARK_.call(null,inst_17972,"fullText:");
var inst_17974 = ((inst_17971) && (inst_17973));
var state_18072__$1 = state_18072;
if(cljs.core.truth_(inst_17974)){
var statearr_18074_18161 = state_18072__$1;
(statearr_18074_18161[(1)] = (31));

} else {
var statearr_18075_18162 = state_18072__$1;
(statearr_18075_18162[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (59))){
var inst_18041 = (state_18072[(7)]);
var inst_18044 = (state_18072[(2)]);
var inst_18045 = fluree.db.util.async.throw_err.call(null,inst_18044);
var inst_18046 = [inst_18045,r];
var inst_18047 = (new cljs.core.PersistentVector(null,2,(5),inst_18041,inst_18046,null));
var state_18072__$1 = state_18072;
var statearr_18076_18163 = state_18072__$1;
(statearr_18076_18163[(2)] = inst_18047);

(statearr_18076_18163[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (20))){
var inst_17934 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18077_18164 = state_18072__$1;
(statearr_18077_18164[(2)] = inst_17934);

(statearr_18077_18164[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (58))){
var inst_18050 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18078_18165 = state_18072__$1;
(statearr_18078_18165[(2)] = inst_18050);

(statearr_18078_18165[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (27))){
var inst_17964 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18079_18166 = state_18072__$1;
(statearr_18079_18166[(2)] = inst_17964);

(statearr_18079_18166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (1))){
var state_18072__$1 = state_18072;
var statearr_18080_18167 = state_18072__$1;
(statearr_18080_18167[(2)] = null);

(statearr_18080_18167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (24))){
var inst_17928 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18081_18168 = state_18072__$1;
(statearr_18081_18168[(2)] = inst_17928);

(statearr_18081_18168[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (55))){
var inst_18052 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18082_18169 = state_18072__$1;
(statearr_18082_18169[(2)] = inst_18052);

(statearr_18082_18169[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (39))){
var inst_18006 = cljs.core.count.call(null,clause);
var inst_18007 = cljs.core._EQ_.call(null,(2),inst_18006);
var state_18072__$1 = state_18072;
if(inst_18007){
var statearr_18083_18170 = state_18072__$1;
(statearr_18083_18170[(1)] = (42));

} else {
var statearr_18084_18171 = state_18072__$1;
(statearr_18084_18171[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (46))){
var state_18072__$1 = state_18072;
var statearr_18085_18172 = state_18072__$1;
(statearr_18085_18172[(2)] = null);

(statearr_18085_18172[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (4))){
var inst_17866 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18086_18173 = state_18072__$1;
(statearr_18086_18173[(2)] = inst_17866);

(statearr_18086_18173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (54))){
var state_18072__$1 = state_18072;
var statearr_18087_18174 = state_18072__$1;
(statearr_18087_18174[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (15))){
var inst_17966 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18089_18175 = state_18072__$1;
(statearr_18089_18175[(2)] = inst_17966);

(statearr_18089_18175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (48))){
var inst_18023 = (state_18072[(8)]);
var inst_18021 = (state_18072[(2)]);
var inst_18022 = fluree.db.util.async.throw_err.call(null,inst_18021);
var inst_18023__$1 = cljs.core.nth.call(null,inst_18022,(0),null);
var inst_18024 = cljs.core.nth.call(null,inst_18022,(1),null);
var inst_18025 = cljs.core._EQ_.call(null,"$wd",inst_18023__$1);
var state_18072__$1 = (function (){var statearr_18090 = state_18072;
(statearr_18090[(8)] = inst_18023__$1);

(statearr_18090[(9)] = inst_18024);

return statearr_18090;
})();
if(inst_18025){
var statearr_18091_18176 = state_18072__$1;
(statearr_18091_18176[(1)] = (49));

} else {
var statearr_18092_18177 = state_18072__$1;
(statearr_18092_18177[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (50))){
var inst_18024 = (state_18072[(9)]);
var inst_18032 = cljs.core.second.call(null,inst_18024);
var inst_18033 = clojure.string.starts_with_QMARK_.call(null,inst_18032,"fullText:");
var state_18072__$1 = state_18072;
if(inst_18033){
var statearr_18093_18178 = state_18072__$1;
(statearr_18093_18178[(1)] = (53));

} else {
var statearr_18094_18179 = state_18072__$1;
(statearr_18094_18179[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (21))){
var inst_17911 = (state_18072[(10)]);
var inst_17879 = (state_18072[(11)]);
var inst_17912 = (state_18072[(12)]);
var inst_17902 = (state_18072[(13)]);
var inst_17900 = (state_18072[(14)]);
var inst_17905 = (state_18072[(15)]);
var inst_17903 = (state_18072[(16)]);
var inst_17875 = (state_18072[(17)]);
var inst_17904 = (state_18072[(18)]);
var inst_17916 = (state_18072[(2)]);
var inst_17917 = fluree.db.util.async.throw_err.call(null,inst_17916);
var inst_17918 = (function (){var vec__17907 = inst_17904;
var new_res = inst_17917;
var first__17909 = inst_17911;
var rest = inst_17912;
var tuples = inst_17905;
var seq__17898 = inst_17903;
var first__17899 = inst_17902;
var G__17896 = inst_17904;
var vec__17897 = inst_17900;
var expr__17877 = inst_17875;
var segment_type = inst_17875;
var clause_group = inst_17911;
var pred__17876 = inst_17879;
var seq__17908 = inst_17912;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_17919 = cljs.core.keys.call(null,vars);
var inst_17920 = cljs.core.reduce.call(null,inst_17918,inst_17917,inst_17919);
var inst_17921 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_17920);
var state_18072__$1 = (function (){var statearr_18095 = state_18072;
(statearr_18095[(19)] = inst_17921);

return statearr_18095;
})();
if(cljs.core.truth_(inst_17905)){
var statearr_18096_18180 = state_18072__$1;
(statearr_18096_18180[(1)] = (22));

} else {
var statearr_18097_18181 = state_18072__$1;
(statearr_18097_18181[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (31))){
var inst_17976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17977 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_17978 = [inst_17977,r];
var inst_17979 = (new cljs.core.PersistentVector(null,2,(5),inst_17976,inst_17978,null));
var state_18072__$1 = state_18072;
var statearr_18098_18182 = state_18072__$1;
(statearr_18098_18182[(2)] = inst_17979);

(statearr_18098_18182[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (32))){
var inst_17981 = cljs.core.count.call(null,clause);
var inst_17982 = cljs.core._EQ_.call(null,(3),inst_17981);
var inst_17983 = cljs.core.second.call(null,clause);
var inst_17984 = cljs.core._EQ_.call(null,inst_17983,"rdf:type");
var inst_17985 = ((inst_17982) && (inst_17984));
var state_18072__$1 = state_18072;
if(cljs.core.truth_(inst_17985)){
var statearr_18099_18183 = state_18072__$1;
(statearr_18099_18183[(1)] = (34));

} else {
var statearr_18100_18184 = state_18072__$1;
(statearr_18100_18184[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (40))){
var inst_18061 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18101_18185 = state_18072__$1;
(statearr_18101_18185[(2)] = inst_18061);

(statearr_18101_18185[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (56))){
var inst_18023 = (state_18072[(8)]);
var inst_18024 = (state_18072[(9)]);
var inst_18041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18042 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_18023,res,inst_18024,fuel,max_fuel);
var state_18072__$1 = (function (){var statearr_18102 = state_18072;
(statearr_18102[(7)] = inst_18041);

return statearr_18102;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(59),inst_18042);
} else {
if((state_val_18073 === (33))){
var inst_18065 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18103_18186 = state_18072__$1;
(statearr_18103_18186[(2)] = inst_18065);

(statearr_18103_18186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (13))){
var inst_17900 = (state_18072[(14)]);
var inst_17900__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17901 = cljs.core.seq.call(null,inst_17900__$1);
var inst_17902 = cljs.core.first.call(null,inst_17901);
var inst_17903 = cljs.core.next.call(null,inst_17901);
var inst_17904 = inst_17900__$1;
var inst_17905 = null;
var state_18072__$1 = (function (){var statearr_18104 = state_18072;
(statearr_18104[(13)] = inst_17902);

(statearr_18104[(14)] = inst_17900__$1);

(statearr_18104[(15)] = inst_17905);

(statearr_18104[(16)] = inst_17903);

(statearr_18104[(18)] = inst_17904);

return statearr_18104;
})();
var statearr_18105_18187 = state_18072__$1;
(statearr_18105_18187[(2)] = null);

(statearr_18105_18187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (22))){
var inst_17912 = (state_18072[(12)]);
var inst_17921 = (state_18072[(19)]);
var inst_17905 = (state_18072[(15)]);
var inst_17923 = fluree.db.query.analytical.outer_union.call(null,inst_17905,inst_17921);
var inst_17904 = inst_17912;
var inst_17905__$1 = inst_17923;
var state_18072__$1 = (function (){var statearr_18106 = state_18072;
(statearr_18106[(15)] = inst_17905__$1);

(statearr_18106[(18)] = inst_17904);

return statearr_18106;
})();
var statearr_18107_18188 = state_18072__$1;
(statearr_18107_18188[(2)] = null);

(statearr_18107_18188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (36))){
var inst_18063 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18108_18189 = state_18072__$1;
(statearr_18108_18189[(2)] = inst_18063);

(statearr_18108_18189[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (41))){
var inst_17998 = (state_18072[(20)]);
var inst_18001 = (state_18072[(2)]);
var inst_18002 = fluree.db.util.async.throw_err.call(null,inst_18001);
var inst_18003 = [inst_18002,r];
var inst_18004 = (new cljs.core.PersistentVector(null,2,(5),inst_17998,inst_18003,null));
var state_18072__$1 = state_18072;
var statearr_18109_18190 = state_18072__$1;
(statearr_18109_18190[(2)] = inst_18004);

(statearr_18109_18190[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (43))){
var state_18072__$1 = state_18072;
var statearr_18110_18191 = state_18072__$1;
(statearr_18110_18191[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (29))){
var inst_17875 = (state_18072[(17)]);
var inst_17958 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17875)].join('');
var inst_17959 = (new Error(inst_17958));
var inst_17960 = (function(){throw inst_17959})();
var state_18072__$1 = state_18072;
var statearr_18112_18192 = state_18072__$1;
(statearr_18112_18192[(2)] = inst_17960);

(statearr_18112_18192[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (44))){
var inst_18059 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18113_18193 = state_18072__$1;
(statearr_18113_18193[(2)] = inst_18059);

(statearr_18113_18193[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (6))){
var inst_17879 = (state_18072[(11)]);
var inst_17875 = (state_18072[(17)]);
var inst_17874 = cljs.core.keys.call(null,clause);
var inst_17875__$1 = cljs.core.first.call(null,inst_17874);
var inst_17879__$1 = cljs.core._EQ_;
var inst_17880 = inst_17879__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_17875__$1);
var state_18072__$1 = (function (){var statearr_18114 = state_18072;
(statearr_18114[(11)] = inst_17879__$1);

(statearr_18114[(17)] = inst_17875__$1);

return statearr_18114;
})();
if(cljs.core.truth_(inst_17880)){
var statearr_18115_18194 = state_18072__$1;
(statearr_18115_18194[(1)] = (9));

} else {
var statearr_18116_18195 = state_18072__$1;
(statearr_18116_18195[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (28))){
var inst_17952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17953 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17954 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_17953,optional_QMARK_);
var inst_17955 = [inst_17954,r];
var inst_17956 = (new cljs.core.PersistentVector(null,2,(5),inst_17952,inst_17955,null));
var state_18072__$1 = state_18072;
var statearr_18117_18196 = state_18072__$1;
(statearr_18117_18196[(2)] = inst_17956);

(statearr_18117_18196[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (51))){
var inst_18054 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18118_18197 = state_18072__$1;
(statearr_18118_18197[(2)] = inst_18054);

(statearr_18118_18197[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (25))){
var inst_17879 = (state_18072[(11)]);
var inst_17875 = (state_18072[(17)]);
var inst_17940 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17941 = (function (){var segment_type = inst_17875;
var pred__17876 = inst_17879;
var expr__17877 = inst_17875;
var bindings = inst_17940;
return (function (p1__17859_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__17859_SHARP_);
});
})();
var inst_17942 = cljs.core.map.call(null,inst_17941,inst_17940);
var inst_17943 = cljs.core.PersistentHashMap.EMPTY;
var inst_17944 = cljs.core.into.call(null,inst_17943,inst_17942);
var inst_17945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17946 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_17944);
var inst_17947 = [inst_17946,r];
var inst_17948 = (new cljs.core.PersistentVector(null,2,(5),inst_17945,inst_17947,null));
var state_18072__$1 = state_18072;
var statearr_18119_18198 = state_18072__$1;
(statearr_18119_18198[(2)] = inst_17948);

(statearr_18119_18198[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (34))){
var inst_17987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17988 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_18072__$1 = (function (){var statearr_18120 = state_18072;
(statearr_18120[(21)] = inst_17987);

return statearr_18120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(37),inst_17988);
} else {
if((state_val_18073 === (17))){
var inst_17936 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18121_18199 = state_18072__$1;
(statearr_18121_18199[(2)] = inst_17936);

(statearr_18121_18199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (3))){
var inst_18070 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18072__$1,inst_18070);
} else {
if((state_val_18073 === (12))){
var inst_17882 = (state_18072[(22)]);
var inst_17886 = (state_18072[(2)]);
var inst_17887 = fluree.db.util.async.throw_err.call(null,inst_17886);
var inst_17888 = [inst_17887,r];
var inst_17889 = (new cljs.core.PersistentVector(null,2,(5),inst_17882,inst_17888,null));
var state_18072__$1 = state_18072;
var statearr_18122_18200 = state_18072__$1;
(statearr_18122_18200[(2)] = inst_17889);

(statearr_18122_18200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (2))){
var _ = (function (){var statearr_18123 = state_18072;
(statearr_18123[(4)] = cljs.core.cons.call(null,(5),(state_18072[(4)])));

return statearr_18123;
})();
var inst_17872 = cljs.core.map_QMARK_.call(null,clause);
var state_18072__$1 = state_18072;
if(inst_17872){
var statearr_18124_18201 = state_18072__$1;
(statearr_18124_18201[(1)] = (6));

} else {
var statearr_18125_18202 = state_18072__$1;
(statearr_18125_18202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (23))){
var inst_17912 = (state_18072[(12)]);
var inst_17921 = (state_18072[(19)]);
var inst_17904 = inst_17912;
var inst_17905 = inst_17921;
var state_18072__$1 = (function (){var statearr_18126 = state_18072;
(statearr_18126[(15)] = inst_17905);

(statearr_18126[(18)] = inst_17904);

return statearr_18126;
})();
var statearr_18127_18203 = state_18072__$1;
(statearr_18127_18203[(2)] = null);

(statearr_18127_18203[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (47))){
var inst_18057 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18128_18204 = state_18072__$1;
(statearr_18128_18204[(2)] = inst_18057);

(statearr_18128_18204[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (35))){
var inst_17995 = cljs.core.count.call(null,clause);
var inst_17996 = cljs.core._EQ_.call(null,(3),inst_17995);
var state_18072__$1 = state_18072;
if(inst_17996){
var statearr_18129_18205 = state_18072__$1;
(statearr_18129_18205[(1)] = (38));

} else {
var statearr_18130_18206 = state_18072__$1;
(statearr_18130_18206[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (19))){
var inst_17905 = (state_18072[(15)]);
var inst_17930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17931 = [inst_17905,r];
var inst_17932 = (new cljs.core.PersistentVector(null,2,(5),inst_17930,inst_17931,null));
var state_18072__$1 = state_18072;
var statearr_18131_18207 = state_18072__$1;
(statearr_18131_18207[(2)] = inst_17932);

(statearr_18131_18207[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (57))){
var state_18072__$1 = state_18072;
var statearr_18132_18208 = state_18072__$1;
(statearr_18132_18208[(2)] = null);

(statearr_18132_18208[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (11))){
var inst_17968 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18134_18209 = state_18072__$1;
(statearr_18134_18209[(2)] = inst_17968);

(statearr_18134_18209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (9))){
var inst_17882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17883 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17884 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_17883,res,fuel,max_fuel,opts);
var state_18072__$1 = (function (){var statearr_18135 = state_18072;
(statearr_18135[(22)] = inst_17882);

return statearr_18135;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(12),inst_17884);
} else {
if((state_val_18073 === (5))){
var _ = (function (){var statearr_18136 = state_18072;
(statearr_18136[(4)] = cljs.core.rest.call(null,(state_18072[(4)])));

return statearr_18136;
})();
var state_18072__$1 = state_18072;
var ex18133 = (state_18072__$1[(2)]);
var statearr_18137_18210 = state_18072__$1;
(statearr_18137_18210[(5)] = ex18133);


if((ex18133 instanceof Error)){
var statearr_18138_18211 = state_18072__$1;
(statearr_18138_18211[(1)] = (4));

(statearr_18138_18211[(5)] = null);

} else {
throw ex18133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (14))){
var inst_17879 = (state_18072[(11)]);
var inst_17875 = (state_18072[(17)]);
var inst_17938 = inst_17879.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_17875);
var state_18072__$1 = state_18072;
if(cljs.core.truth_(inst_17938)){
var statearr_18139_18212 = state_18072__$1;
(statearr_18139_18212[(1)] = (25));

} else {
var statearr_18140_18213 = state_18072__$1;
(statearr_18140_18213[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (45))){
var inst_18019 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(48),inst_18019);
} else {
if((state_val_18073 === (53))){
var inst_18023 = (state_18072[(8)]);
var inst_18024 = (state_18072[(9)]);
var inst_18035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18036 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_18023,res,inst_18024);
var inst_18037 = [inst_18036,r];
var inst_18038 = (new cljs.core.PersistentVector(null,2,(5),inst_18035,inst_18037,null));
var state_18072__$1 = state_18072;
var statearr_18141_18214 = state_18072__$1;
(statearr_18141_18214[(2)] = inst_18038);

(statearr_18141_18214[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (26))){
var inst_17879 = (state_18072[(11)]);
var inst_17875 = (state_18072[(17)]);
var inst_17950 = inst_17879.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_17875);
var state_18072__$1 = state_18072;
if(cljs.core.truth_(inst_17950)){
var statearr_18142_18215 = state_18072__$1;
(statearr_18142_18215[(1)] = (28));

} else {
var statearr_18143_18216 = state_18072__$1;
(statearr_18143_18216[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (16))){
var inst_17911 = (state_18072[(10)]);
var inst_17904 = (state_18072[(18)]);
var inst_17910 = cljs.core.seq.call(null,inst_17904);
var inst_17911__$1 = cljs.core.first.call(null,inst_17910);
var inst_17912 = cljs.core.next.call(null,inst_17910);
var state_18072__$1 = (function (){var statearr_18144 = state_18072;
(statearr_18144[(10)] = inst_17911__$1);

(statearr_18144[(12)] = inst_17912);

return statearr_18144;
})();
if(cljs.core.truth_(inst_17911__$1)){
var statearr_18145_18217 = state_18072__$1;
(statearr_18145_18217[(1)] = (18));

} else {
var statearr_18146_18218 = state_18072__$1;
(statearr_18146_18218[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (38))){
var inst_17998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17999 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_18072__$1 = (function (){var statearr_18147 = state_18072;
(statearr_18147[(20)] = inst_17998);

return statearr_18147;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(41),inst_17999);
} else {
if((state_val_18073 === (30))){
var inst_17962 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18148_18219 = state_18072__$1;
(statearr_18148_18219[(2)] = inst_17962);

(statearr_18148_18219[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (10))){
var inst_17879 = (state_18072[(11)]);
var inst_17875 = (state_18072[(17)]);
var inst_17891 = inst_17879.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_17875);
var state_18072__$1 = state_18072;
if(cljs.core.truth_(inst_17891)){
var statearr_18149_18220 = state_18072__$1;
(statearr_18149_18220[(1)] = (13));

} else {
var statearr_18150_18221 = state_18072__$1;
(statearr_18150_18221[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (18))){
var inst_17911 = (state_18072[(10)]);
var inst_17914 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_17911,q_map,vars,fuel,max_fuel,opts);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(21),inst_17914);
} else {
if((state_val_18073 === (52))){
var inst_18029 = (state_18072[(2)]);
var inst_18030 = fluree.db.util.async.throw_err.call(null,inst_18029);
var state_18072__$1 = state_18072;
var statearr_18151_18222 = state_18072__$1;
(statearr_18151_18222[(2)] = inst_18030);

(statearr_18151_18222[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (42))){
var inst_18009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18010 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_18011 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18010);
var inst_18012 = [inst_18011,r];
var inst_18013 = (new cljs.core.PersistentVector(null,2,(5),inst_18009,inst_18012,null));
var state_18072__$1 = state_18072;
var statearr_18152_18223 = state_18072__$1;
(statearr_18152_18223[(2)] = inst_18013);

(statearr_18152_18223[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (37))){
var inst_17987 = (state_18072[(21)]);
var inst_17990 = (state_18072[(2)]);
var inst_17991 = fluree.db.util.async.throw_err.call(null,inst_17990);
var inst_17992 = [inst_17991,r];
var inst_17993 = (new cljs.core.PersistentVector(null,2,(5),inst_17987,inst_17992,null));
var state_18072__$1 = state_18072;
var statearr_18153_18224 = state_18072__$1;
(statearr_18153_18224[(2)] = inst_17993);

(statearr_18153_18224[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (8))){
var inst_18067 = (state_18072[(2)]);
var _ = (function (){var statearr_18154 = state_18072;
(statearr_18154[(4)] = cljs.core.rest.call(null,(state_18072[(4)])));

return statearr_18154;
})();
var state_18072__$1 = state_18072;
var statearr_18155_18225 = state_18072__$1;
(statearr_18155_18225[(2)] = inst_18067);

(statearr_18155_18225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (49))){
var inst_18024 = (state_18072[(9)]);
var inst_18027 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_18024,r,res,optional_QMARK_,fuel,max_fuel);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18072__$1,(52),inst_18027);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_18156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18156[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__);

(statearr_18156[(1)] = (1));

return statearr_18156;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1 = (function (state_18072){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18157){var ex__2882__auto__ = e18157;
var statearr_18158_18226 = state_18072;
(statearr_18158_18226[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18072[(4)]))){
var statearr_18159_18227 = state_18072;
(statearr_18159_18227[(1)] = cljs.core.first.call(null,(state_18072[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18228 = state_18072;
state_18072 = G__18228;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__ = function(state_18072){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1.call(this,state_18072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18160 = f__2902__auto__.call(null);
(statearr_18160[(6)] = c__2901__auto__);

return statearr_18160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__18230 = arguments.length;
switch (G__18230) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18310){
var state_val_18311 = (state_18310[(1)]);
if((state_val_18311 === (7))){
var inst_18305 = (state_18310[(2)]);
var _ = (function (){var statearr_18312 = state_18310;
(statearr_18312[(4)] = cljs.core.rest.call(null,(state_18310[(4)])));

return statearr_18312;
})();
var state_18310__$1 = state_18310;
var statearr_18313_18361 = state_18310__$1;
(statearr_18313_18361[(2)] = inst_18305);

(statearr_18313_18361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (20))){
var inst_18270 = (state_18310[(7)]);
var inst_18282 = (state_18310[(2)]);
var inst_18252 = inst_18270;
var inst_18253 = inst_18282;
var state_18310__$1 = (function (){var statearr_18314 = state_18310;
(statearr_18314[(8)] = inst_18252);

(statearr_18314[(9)] = inst_18253);

return statearr_18314;
})();
var statearr_18315_18362 = state_18310__$1;
(statearr_18315_18362[(2)] = null);

(statearr_18315_18362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (1))){
var state_18310__$1 = state_18310;
var statearr_18316_18363 = state_18310__$1;
(statearr_18316_18363[(2)] = null);

(statearr_18316_18363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (24))){
var inst_18253 = (state_18310[(9)]);
var inst_18269 = (state_18310[(10)]);
var inst_18270 = (state_18310[(7)]);
var inst_18290 = fluree.db.query.analytical.inner_join.call(null,inst_18253,inst_18269);
var inst_18252 = inst_18270;
var inst_18253__$1 = inst_18290;
var state_18310__$1 = (function (){var statearr_18317 = state_18310;
(statearr_18317[(8)] = inst_18252);

(statearr_18317[(9)] = inst_18253__$1);

return statearr_18317;
})();
var statearr_18318_18364 = state_18310__$1;
(statearr_18318_18364[(2)] = null);

(statearr_18318_18364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (4))){
var inst_18231 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18320_18365 = state_18310__$1;
(statearr_18320_18365[(2)] = inst_18231);

(statearr_18320_18365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (15))){
var inst_18269 = (state_18310[(10)]);
var state_18310__$1 = state_18310;
if(cljs.core.truth_(inst_18269)){
var statearr_18321_18366 = state_18310__$1;
(statearr_18321_18366[(1)] = (18));

} else {
var statearr_18322_18367 = state_18310__$1;
(statearr_18322_18367[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (21))){
var inst_18253 = (state_18310[(9)]);
var inst_18270 = (state_18310[(7)]);
var tmp18319 = inst_18253;
var inst_18252 = inst_18270;
var inst_18253__$1 = tmp18319;
var state_18310__$1 = (function (){var statearr_18323 = state_18310;
(statearr_18323[(8)] = inst_18252);

(statearr_18323[(9)] = inst_18253__$1);

return statearr_18323;
})();
var statearr_18324_18368 = state_18310__$1;
(statearr_18324_18368[(2)] = null);

(statearr_18324_18368[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (13))){
var inst_18253 = (state_18310[(9)]);
var inst_18276 = cljs.core.dissoc.call(null,inst_18253,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18277 = cljs.core.empty_QMARK_.call(null,inst_18276);
var state_18310__$1 = state_18310;
if(inst_18277){
var statearr_18325_18369 = state_18310__$1;
(statearr_18325_18369[(1)] = (15));

} else {
var statearr_18326_18370 = state_18310__$1;
(statearr_18326_18370[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (22))){
var state_18310__$1 = state_18310;
var statearr_18327_18371 = state_18310__$1;
(statearr_18327_18371[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (6))){
var inst_18252 = (state_18310[(8)]);
var inst_18259 = (state_18310[(11)]);
var inst_18258 = cljs.core.seq.call(null,inst_18252);
var inst_18259__$1 = cljs.core.first.call(null,inst_18258);
var inst_18260 = cljs.core.next.call(null,inst_18258);
var state_18310__$1 = (function (){var statearr_18329 = state_18310;
(statearr_18329[(12)] = inst_18260);

(statearr_18329[(11)] = inst_18259__$1);

return statearr_18329;
})();
if(cljs.core.truth_(inst_18259__$1)){
var statearr_18330_18372 = state_18310__$1;
(statearr_18330_18372[(1)] = (8));

} else {
var statearr_18331_18373 = state_18310__$1;
(statearr_18331_18373[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (25))){
var state_18310__$1 = state_18310;
var statearr_18332_18374 = state_18310__$1;
(statearr_18332_18374[(2)] = null);

(statearr_18332_18374[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (17))){
var inst_18298 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18333_18375 = state_18310__$1;
(statearr_18333_18375[(2)] = inst_18298);

(statearr_18333_18375[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (3))){
var inst_18308 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18310__$1,inst_18308);
} else {
if((state_val_18311 === (12))){
var inst_18269 = (state_18310[(10)]);
var inst_18270 = (state_18310[(7)]);
var inst_18252 = inst_18270;
var inst_18253 = inst_18269;
var state_18310__$1 = (function (){var statearr_18334 = state_18310;
(statearr_18334[(8)] = inst_18252);

(statearr_18334[(9)] = inst_18253);

return statearr_18334;
})();
var statearr_18335_18376 = state_18310__$1;
(statearr_18335_18376[(2)] = null);

(statearr_18335_18376[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (2))){
var _ = (function (){var statearr_18336 = state_18310;
(statearr_18336[(4)] = cljs.core.cons.call(null,(5),(state_18310[(4)])));

return statearr_18336;
})();
var inst_18244 = where;
var inst_18245 = cljs.core.seq.call(null,inst_18244);
var inst_18246 = cljs.core.first.call(null,inst_18245);
var inst_18247 = cljs.core.next.call(null,inst_18245);
var inst_18248 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18249 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_18250 = [inst_18249];
var inst_18251 = cljs.core.PersistentHashMap.fromArrays(inst_18248,inst_18250);
var inst_18252 = inst_18244;
var inst_18253 = inst_18251;
var state_18310__$1 = (function (){var statearr_18337 = state_18310;
(statearr_18337[(8)] = inst_18252);

(statearr_18337[(9)] = inst_18253);

(statearr_18337[(13)] = inst_18246);

(statearr_18337[(14)] = inst_18247);

return statearr_18337;
})();
var statearr_18338_18377 = state_18310__$1;
(statearr_18338_18377[(2)] = null);

(statearr_18338_18377[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (23))){
var inst_18296 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18339_18378 = state_18310__$1;
(statearr_18339_18378[(2)] = inst_18296);

(statearr_18339_18378[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (19))){
var inst_18253 = (state_18310[(9)]);
var state_18310__$1 = state_18310;
var statearr_18340_18379 = state_18310__$1;
(statearr_18340_18379[(2)] = inst_18253);

(statearr_18340_18379[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (11))){
var inst_18259 = (state_18310[(11)]);
var inst_18267 = (state_18310[(2)]);
var inst_18268 = fluree.db.util.async.throw_err.call(null,inst_18267);
var inst_18269 = cljs.core.nth.call(null,inst_18268,(0),null);
var inst_18270 = cljs.core.nth.call(null,inst_18268,(1),null);
var inst_18271 = cljs.core.count.call(null,inst_18259);
var inst_18272 = cljs.core._EQ_.call(null,(2),inst_18271);
var state_18310__$1 = (function (){var statearr_18342 = state_18310;
(statearr_18342[(10)] = inst_18269);

(statearr_18342[(7)] = inst_18270);

return statearr_18342;
})();
if(inst_18272){
var statearr_18343_18380 = state_18310__$1;
(statearr_18343_18380[(1)] = (12));

} else {
var statearr_18344_18381 = state_18310__$1;
(statearr_18344_18381[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (9))){
var inst_18253 = (state_18310[(9)]);
var state_18310__$1 = state_18310;
var statearr_18345_18382 = state_18310__$1;
(statearr_18345_18382[(2)] = inst_18253);

(statearr_18345_18382[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (5))){
var _ = (function (){var statearr_18346 = state_18310;
(statearr_18346[(4)] = cljs.core.rest.call(null,(state_18310[(4)])));

return statearr_18346;
})();
var state_18310__$1 = state_18310;
var ex18341 = (state_18310__$1[(2)]);
var statearr_18347_18383 = state_18310__$1;
(statearr_18347_18383[(5)] = ex18341);


if((ex18341 instanceof Error)){
var statearr_18348_18384 = state_18310__$1;
(statearr_18348_18384[(1)] = (4));

(statearr_18348_18384[(5)] = null);

} else {
throw ex18341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (14))){
var inst_18300 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18349_18385 = state_18310__$1;
(statearr_18349_18385[(2)] = inst_18300);

(statearr_18349_18385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (26))){
var inst_18294 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18350_18386 = state_18310__$1;
(statearr_18350_18386[(2)] = inst_18294);

(statearr_18350_18386[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (16))){
var inst_18269 = (state_18310[(10)]);
var inst_18285 = (inst_18269 == null);
var state_18310__$1 = state_18310;
if(cljs.core.truth_(inst_18285)){
var statearr_18351_18387 = state_18310__$1;
(statearr_18351_18387[(1)] = (21));

} else {
var statearr_18352_18388 = state_18310__$1;
(statearr_18352_18388[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (10))){
var inst_18303 = (state_18310[(2)]);
var state_18310__$1 = state_18310;
var statearr_18353_18389 = state_18310__$1;
(statearr_18353_18389[(2)] = inst_18303);

(statearr_18353_18389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (18))){
var inst_18269 = (state_18310[(10)]);
var state_18310__$1 = state_18310;
var statearr_18354_18390 = state_18310__$1;
(statearr_18354_18390[(2)] = inst_18269);

(statearr_18354_18390[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18311 === (8))){
var inst_18253 = (state_18310[(9)]);
var inst_18260 = (state_18310[(12)]);
var inst_18259 = (state_18310[(11)]);
var inst_18265 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_18253,inst_18259,inst_18260,false,fuel,max_fuel,opts);
var state_18310__$1 = state_18310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18310__$1,(11),inst_18265);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2879__auto__ = null;
var fluree$db$query$analytical$state_machine__2879__auto____0 = (function (){
var statearr_18355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18355[(0)] = fluree$db$query$analytical$state_machine__2879__auto__);

(statearr_18355[(1)] = (1));

return statearr_18355;
});
var fluree$db$query$analytical$state_machine__2879__auto____1 = (function (state_18310){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18356){var ex__2882__auto__ = e18356;
var statearr_18357_18391 = state_18310;
(statearr_18357_18391[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18310[(4)]))){
var statearr_18358_18392 = state_18310;
(statearr_18358_18392[(1)] = cljs.core.first.call(null,(state_18310[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18393 = state_18310;
state_18310 = G__18393;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2879__auto__ = function(state_18310){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2879__auto____1.call(this,state_18310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2879__auto____0;
fluree$db$query$analytical$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2879__auto____1;
return fluree$db$query$analytical$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18359 = f__2902__auto__.call(null);
(statearr_18359[(6)] = c__2901__auto__);

return statearr_18359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18448){
var state_val_18449 = (state_18448[(1)]);
if((state_val_18449 === (7))){
var state_18448__$1 = state_18448;
var statearr_18450_18488 = state_18448__$1;
(statearr_18450_18488[(2)] = false);

(statearr_18450_18488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (20))){
var inst_18438 = (state_18448[(7)]);
var inst_18426 = (state_18448[(8)]);
var inst_18440 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_18438,inst_18426,null);
var state_18448__$1 = state_18448;
var statearr_18451_18489 = state_18448__$1;
(statearr_18451_18489[(2)] = inst_18440);

(statearr_18451_18489[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (1))){
var state_18448__$1 = state_18448;
var statearr_18452_18490 = state_18448__$1;
(statearr_18452_18490[(2)] = null);

(statearr_18452_18490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (4))){
var inst_18394 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18453_18491 = state_18448__$1;
(statearr_18453_18491[(2)] = inst_18394);

(statearr_18453_18491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (15))){
var inst_18425 = (state_18448[(9)]);
var inst_18429 = (state_18448[(2)]);
var inst_18430 = fluree.db.util.async.throw_err.call(null,inst_18429);
var state_18448__$1 = (function (){var statearr_18454 = state_18448;
(statearr_18454[(10)] = inst_18430);

return statearr_18454;
})();
if(cljs.core.truth_(inst_18425)){
var statearr_18455_18492 = state_18448__$1;
(statearr_18455_18492[(1)] = (16));

} else {
var statearr_18456_18493 = state_18448__$1;
(statearr_18456_18493[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (21))){
var inst_18438 = (state_18448[(7)]);
var state_18448__$1 = state_18448;
var statearr_18457_18494 = state_18448__$1;
(statearr_18457_18494[(2)] = inst_18438);

(statearr_18457_18494[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (13))){
var inst_18401 = (state_18448[(11)]);
var state_18448__$1 = state_18448;
var statearr_18458_18495 = state_18448__$1;
(statearr_18458_18495[(2)] = inst_18401);

(statearr_18458_18495[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (22))){
var inst_18443 = (state_18448[(2)]);
var _ = (function (){var statearr_18459 = state_18448;
(statearr_18459[(4)] = cljs.core.rest.call(null,(state_18448[(4)])));

return statearr_18459;
})();
var state_18448__$1 = state_18448;
var statearr_18460_18496 = state_18448__$1;
(statearr_18460_18496[(2)] = inst_18443);

(statearr_18460_18496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (6))){
var inst_18401 = (state_18448[(11)]);
var inst_18406 = inst_18401.cljs$lang$protocol_mask$partition0$;
var inst_18407 = (inst_18406 & (64));
var inst_18408 = inst_18401.cljs$core$ISeq$;
var inst_18409 = (cljs.core.PROTOCOL_SENTINEL === inst_18408);
var inst_18410 = ((inst_18407) || (inst_18409));
var state_18448__$1 = state_18448;
if(cljs.core.truth_(inst_18410)){
var statearr_18461_18497 = state_18448__$1;
(statearr_18461_18497[(1)] = (9));

} else {
var statearr_18462_18498 = state_18448__$1;
(statearr_18462_18498[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (17))){
var inst_18430 = (state_18448[(10)]);
var state_18448__$1 = state_18448;
var statearr_18463_18499 = state_18448__$1;
(statearr_18463_18499[(2)] = inst_18430);

(statearr_18463_18499[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (3))){
var inst_18446 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18448__$1,inst_18446);
} else {
if((state_val_18449 === (12))){
var inst_18401 = (state_18448[(11)]);
var inst_18419 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18401);
var state_18448__$1 = state_18448;
var statearr_18464_18500 = state_18448__$1;
(statearr_18464_18500[(2)] = inst_18419);

(statearr_18464_18500[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (2))){
var inst_18401 = (state_18448[(11)]);
var _ = (function (){var statearr_18465 = state_18448;
(statearr_18465[(4)] = cljs.core.cons.call(null,(5),(state_18448[(4)])));

return statearr_18465;
})();
var inst_18401__$1 = q_map;
var inst_18403 = (inst_18401__$1 == null);
var inst_18404 = cljs.core.not.call(null,inst_18403);
var state_18448__$1 = (function (){var statearr_18466 = state_18448;
(statearr_18466[(11)] = inst_18401__$1);

return statearr_18466;
})();
if(inst_18404){
var statearr_18467_18501 = state_18448__$1;
(statearr_18467_18501[(1)] = (6));

} else {
var statearr_18468_18502 = state_18448__$1;
(statearr_18468_18502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (19))){
var inst_18434 = (state_18448[(2)]);
var inst_18435 = fluree.db.util.async.throw_err.call(null,inst_18434);
var state_18448__$1 = state_18448;
var statearr_18469_18503 = state_18448__$1;
(statearr_18469_18503[(2)] = inst_18435);

(statearr_18469_18503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (11))){
var inst_18414 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18471_18504 = state_18448__$1;
(statearr_18471_18504[(2)] = inst_18414);

(statearr_18471_18504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (9))){
var state_18448__$1 = state_18448;
var statearr_18472_18505 = state_18448__$1;
(statearr_18472_18505[(2)] = true);

(statearr_18472_18505[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (5))){
var _ = (function (){var statearr_18473 = state_18448;
(statearr_18473[(4)] = cljs.core.rest.call(null,(state_18448[(4)])));

return statearr_18473;
})();
var state_18448__$1 = state_18448;
var ex18470 = (state_18448__$1[(2)]);
var statearr_18474_18506 = state_18448__$1;
(statearr_18474_18506[(5)] = ex18470);


if((ex18470 instanceof Error)){
var statearr_18475_18507 = state_18448__$1;
(statearr_18475_18507[(1)] = (4));

(statearr_18475_18507[(5)] = null);

} else {
throw ex18470;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (14))){
var inst_18422 = (state_18448[(2)]);
var inst_18423 = cljs.core.get.call(null,inst_18422,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18424 = cljs.core.get.call(null,inst_18422,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_18425 = cljs.core.get.call(null,inst_18422,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_18426 = cljs.core.get.call(null,inst_18422,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_18427 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_18424,q_map,inst_18423,fuel,max_fuel,opts);
var state_18448__$1 = (function (){var statearr_18476 = state_18448;
(statearr_18476[(9)] = inst_18425);

(statearr_18476[(8)] = inst_18426);

return statearr_18476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18448__$1,(15),inst_18427);
} else {
if((state_val_18449 === (16))){
var inst_18425 = (state_18448[(9)]);
var inst_18430 = (state_18448[(10)]);
var inst_18432 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_18425,inst_18430,fuel,max_fuel,opts);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18448__$1,(19),inst_18432);
} else {
if((state_val_18449 === (10))){
var state_18448__$1 = state_18448;
var statearr_18477_18508 = state_18448__$1;
(statearr_18477_18508[(2)] = false);

(statearr_18477_18508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (18))){
var inst_18426 = (state_18448[(8)]);
var inst_18438 = (state_18448[(2)]);
var state_18448__$1 = (function (){var statearr_18478 = state_18448;
(statearr_18478[(7)] = inst_18438);

return statearr_18478;
})();
if(cljs.core.truth_(inst_18426)){
var statearr_18479_18509 = state_18448__$1;
(statearr_18479_18509[(1)] = (20));

} else {
var statearr_18480_18510 = state_18448__$1;
(statearr_18480_18510[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18449 === (8))){
var inst_18417 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
if(cljs.core.truth_(inst_18417)){
var statearr_18481_18511 = state_18448__$1;
(statearr_18481_18511[(1)] = (12));

} else {
var statearr_18482_18512 = state_18448__$1;
(statearr_18482_18512[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2879__auto____0 = (function (){
var statearr_18483 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18483[(0)] = fluree$db$query$analytical$q_$_state_machine__2879__auto__);

(statearr_18483[(1)] = (1));

return statearr_18483;
});
var fluree$db$query$analytical$q_$_state_machine__2879__auto____1 = (function (state_18448){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18484){var ex__2882__auto__ = e18484;
var statearr_18485_18513 = state_18448;
(statearr_18485_18513[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18448[(4)]))){
var statearr_18486_18514 = state_18448;
(statearr_18486_18514[(1)] = cljs.core.first.call(null,(state_18448[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18515 = state_18448;
state_18448 = G__18515;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2879__auto__ = function(state_18448){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2879__auto____1.call(this,state_18448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2879__auto____0;
fluree$db$query$analytical$q_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2879__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18487 = f__2902__auto__.call(null);
(statearr_18487[(6)] = c__2901__auto__);

return statearr_18487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
