// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__21667 = arguments.length;
switch (G__21667) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__21670 = arguments.length;
switch (G__21670) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___21723 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21701){
var state_val_21702 = (state_21701[(1)]);
if((state_val_21702 === (1))){
var state_21701__$1 = state_21701;
var statearr_21703_21724 = state_21701__$1;
(statearr_21703_21724[(2)] = null);

(statearr_21703_21724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (2))){
var _ = (function (){var statearr_21704 = state_21701;
(statearr_21704[(4)] = cljs.core.cons.call(null,(5),(state_21701[(4)])));

return statearr_21704;
})();
var inst_21678 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_21701__$1 = state_21701;
if(cljs.core.truth_(inst_21678)){
var statearr_21705_21725 = state_21701__$1;
(statearr_21705_21725[(1)] = (6));

} else {
var statearr_21706_21726 = state_21701__$1;
(statearr_21706_21726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (3))){
var inst_21699 = (state_21701[(2)]);
var state_21701__$1 = state_21701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21701__$1,inst_21699);
} else {
if((state_val_21702 === (4))){
var inst_21671 = (state_21701[(2)]);
var inst_21672 = cljs.core.async.put_BANG_.call(null,pc,inst_21671);
var state_21701__$1 = state_21701;
var statearr_21708_21727 = state_21701__$1;
(statearr_21708_21727[(2)] = inst_21672);

(statearr_21708_21727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (5))){
var _ = (function (){var statearr_21709 = state_21701;
(statearr_21709[(4)] = cljs.core.rest.call(null,(state_21701[(4)])));

return statearr_21709;
})();
var state_21701__$1 = state_21701;
var ex21707 = (state_21701__$1[(2)]);
var statearr_21710_21728 = state_21701__$1;
(statearr_21710_21728[(5)] = ex21707);


var statearr_21711_21729 = state_21701__$1;
(statearr_21711_21729[(1)] = (4));

(statearr_21711_21729[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (6))){
var inst_21680 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21681 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_21682 = cljs.core.PersistentHashMap.fromArrays(inst_21680,inst_21681);
var inst_21683 = cljs.core.ex_info.call(null,"Connection was closed.",inst_21682);
var inst_21684 = (function(){throw inst_21683})();
var state_21701__$1 = state_21701;
var statearr_21712_21730 = state_21701__$1;
(statearr_21712_21730[(2)] = inst_21684);

(statearr_21712_21730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (7))){
var inst_21686 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21688 = [operation,data,pc,opts];
var inst_21689 = (new cljs.core.PersistentVector(null,4,(5),inst_21687,inst_21688,null));
var inst_21690 = cljs.core.async.put_BANG_.call(null,inst_21686,inst_21689);
var inst_21691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21692 = [operation,data,pc,opts];
var inst_21693 = (new cljs.core.PersistentVector(null,4,(5),inst_21691,inst_21692,null));
var inst_21694 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_21693);
var state_21701__$1 = (function (){var statearr_21713 = state_21701;
(statearr_21713[(7)] = inst_21690);

return statearr_21713;
})();
var statearr_21714_21731 = state_21701__$1;
(statearr_21714_21731[(2)] = inst_21694);

(statearr_21714_21731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21702 === (8))){
var inst_21696 = (state_21701[(2)]);
var _ = (function (){var statearr_21715 = state_21701;
(statearr_21715[(4)] = cljs.core.rest.call(null,(state_21701[(4)])));

return statearr_21715;
})();
var state_21701__$1 = state_21701;
var statearr_21716_21732 = state_21701__$1;
(statearr_21716_21732[(2)] = inst_21696);

(statearr_21716_21732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2879__auto__ = null;
var fluree$db$operations$state_machine__2879__auto____0 = (function (){
var statearr_21717 = [null,null,null,null,null,null,null,null];
(statearr_21717[(0)] = fluree$db$operations$state_machine__2879__auto__);

(statearr_21717[(1)] = (1));

return statearr_21717;
});
var fluree$db$operations$state_machine__2879__auto____1 = (function (state_21701){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21718){var ex__2882__auto__ = e21718;
var statearr_21719_21733 = state_21701;
(statearr_21719_21733[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21701[(4)]))){
var statearr_21720_21734 = state_21701;
(statearr_21720_21734[(1)] = cljs.core.first.call(null,(state_21701[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21735 = state_21701;
state_21701 = G__21735;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2879__auto__ = function(state_21701){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2879__auto____1.call(this,state_21701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2879__auto____0;
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2879__auto____1;
return fluree$db$operations$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21721 = f__2902__auto__.call(null);
(statearr_21721[(6)] = c__2901__auto___21723);

return statearr_21721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__21737 = arguments.length;
switch (G__21737) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__21738){
var map__21739 = p__21738;
var map__21739__$1 = (((((!((map__21739 == null))))?(((((map__21739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21739):map__21739);
var opts = map__21739__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__21739__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__21741 = session;
var map__21741__$1 = (((((!((map__21741 == null))))?(((((map__21741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21741):map__21741);
var dbid = cljs.core.get.call(null,map__21741__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__21741__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__21741__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___21803 = arguments.length;
var i__4737__auto___21804 = (0);
while(true){
if((i__4737__auto___21804 < len__4736__auto___21803)){
args__4742__auto__.push((arguments[i__4737__auto___21804]));

var G__21805 = (i__4737__auto___21804 + (1));
i__4737__auto___21804 = G__21805;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__21746){
var vec__21747 = p__21746;
var map__21750 = cljs.core.nth.call(null,vec__21747,(0),null);
var map__21750__$1 = (((((!((map__21750 == null))))?(((((map__21750.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21750.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21750):map__21750);
var toBlock = cljs.core.get.call(null,map__21750__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__21750__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__21747;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21783){
var state_val_21784 = (state_21783[(1)]);
if((state_val_21784 === (7))){
var inst_21766 = (state_21783[(2)]);
var state_21783__$1 = state_21783;
var statearr_21785_21806 = state_21783__$1;
(statearr_21785_21806[(2)] = inst_21766);

(statearr_21785_21806[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (1))){
var inst_21753 = (state_21783[(7)]);
var inst_21753__$1 = session;
var inst_21755 = (inst_21753__$1 == null);
var inst_21756 = cljs.core.not.call(null,inst_21755);
var state_21783__$1 = (function (){var statearr_21786 = state_21783;
(statearr_21786[(7)] = inst_21753__$1);

return statearr_21786;
})();
if(inst_21756){
var statearr_21787_21807 = state_21783__$1;
(statearr_21787_21807[(1)] = (2));

} else {
var statearr_21788_21808 = state_21783__$1;
(statearr_21788_21808[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (4))){
var inst_21769 = (state_21783[(2)]);
var state_21783__$1 = state_21783;
if(cljs.core.truth_(inst_21769)){
var statearr_21789_21809 = state_21783__$1;
(statearr_21789_21809[(1)] = (8));

} else {
var statearr_21790_21810 = state_21783__$1;
(statearr_21790_21810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (6))){
var state_21783__$1 = state_21783;
var statearr_21791_21811 = state_21783__$1;
(statearr_21791_21811[(2)] = false);

(statearr_21791_21811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (3))){
var state_21783__$1 = state_21783;
var statearr_21792_21812 = state_21783__$1;
(statearr_21792_21812[(2)] = false);

(statearr_21792_21812[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (2))){
var inst_21753 = (state_21783[(7)]);
var inst_21758 = inst_21753.cljs$lang$protocol_mask$partition0$;
var inst_21759 = (inst_21758 & (64));
var inst_21760 = inst_21753.cljs$core$ISeq$;
var inst_21761 = (cljs.core.PROTOCOL_SENTINEL === inst_21760);
var inst_21762 = ((inst_21759) || (inst_21761));
var state_21783__$1 = state_21783;
if(cljs.core.truth_(inst_21762)){
var statearr_21793_21813 = state_21783__$1;
(statearr_21793_21813[(1)] = (5));

} else {
var statearr_21794_21814 = state_21783__$1;
(statearr_21794_21814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (9))){
var inst_21753 = (state_21783[(7)]);
var state_21783__$1 = state_21783;
var statearr_21795_21815 = state_21783__$1;
(statearr_21795_21815[(2)] = inst_21753);

(statearr_21795_21815[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (5))){
var state_21783__$1 = state_21783;
var statearr_21796_21816 = state_21783__$1;
(statearr_21796_21816[(2)] = true);

(statearr_21796_21816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21784 === (10))){
var inst_21774 = (state_21783[(2)]);
var inst_21775 = cljs.core.get.call(null,inst_21774,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_21776 = cljs.core.get.call(null,inst_21774,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_21777 = cljs.core.get.call(null,inst_21774,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_21778 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_21779 = [inst_21775,inst_21776,toBlock,toTime];
var inst_21780 = cljs.core.PersistentHashMap.fromArrays(inst_21778,inst_21779);
var inst_21781 = fluree.db.operations.send_operation.call(null,inst_21777,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_21780);
var state_21783__$1 = state_21783;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21783__$1,inst_21781);
} else {
if((state_val_21784 === (8))){
var inst_21753 = (state_21783[(7)]);
var inst_21771 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21753);
var state_21783__$1 = state_21783;
var statearr_21797_21817 = state_21783__$1;
(statearr_21797_21817[(2)] = inst_21771);

(statearr_21797_21817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2879__auto__ = null;
var fluree$db$operations$state_machine__2879__auto____0 = (function (){
var statearr_21798 = [null,null,null,null,null,null,null,null];
(statearr_21798[(0)] = fluree$db$operations$state_machine__2879__auto__);

(statearr_21798[(1)] = (1));

return statearr_21798;
});
var fluree$db$operations$state_machine__2879__auto____1 = (function (state_21783){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21783);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21799){var ex__2882__auto__ = e21799;
var statearr_21800_21818 = state_21783;
(statearr_21800_21818[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21783[(4)]))){
var statearr_21801_21819 = state_21783;
(statearr_21801_21819[(1)] = cljs.core.first.call(null,(state_21783[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21820 = state_21783;
state_21783 = G__21820;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2879__auto__ = function(state_21783){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2879__auto____1.call(this,state_21783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2879__auto____0;
fluree$db$operations$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2879__auto____1;
return fluree$db$operations$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21802 = f__2902__auto__.call(null);
(statearr_21802[(6)] = c__2901__auto__);

return statearr_21802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq21744){
var G__21745 = cljs.core.first.call(null,seq21744);
var seq21744__$1 = cljs.core.next.call(null,seq21744);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21745,seq21744__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__21821 = session;
var map__21821__$1 = (((((!((map__21821 == null))))?(((((map__21821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21821):map__21821);
var network = cljs.core.get.call(null,map__21821__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21821__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__21821__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__21824 = arguments.length;
switch (G__21824) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__21825 = opts;
var map__21825__$1 = (((((!((map__21825 == null))))?(((((map__21825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21825.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21825):map__21825);
var auth = cljs.core.get.call(null,map__21825__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__21825__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
