// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28388 = arguments.length;
var i__4737__auto___28389 = (0);
while(true){
if((i__4737__auto___28389 < len__4736__auto___28388)){
args__4742__auto__.push((arguments[i__4737__auto___28389]));

var G__28390 = (i__4737__auto___28389 + (1));
i__4737__auto___28389 = G__28390;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28385){
var G__28386 = cljs.core.first.call(null,seq28385);
var seq28385__$1 = cljs.core.next.call(null,seq28385);
var G__28387 = cljs.core.first.call(null,seq28385__$1);
var seq28385__$2 = cljs.core.next.call(null,seq28385__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28386,G__28387,seq28385__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28391){var e = e28391;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28392){var e = e28392;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28393){var e = e28393;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28394){var e = e28394;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28395){var e = e28395;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28398 = arguments.length;
var i__4737__auto___28399 = (0);
while(true){
if((i__4737__auto___28399 < len__4736__auto___28398)){
args__4742__auto__.push((arguments[i__4737__auto___28399]));

var G__28400 = (i__4737__auto___28399 + (1));
i__4737__auto___28399 = G__28400;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28397){var e = e28397;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28396){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28396));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28403 = arguments.length;
var i__4737__auto___28404 = (0);
while(true){
if((i__4737__auto___28404 < len__4736__auto___28403)){
args__4742__auto__.push((arguments[i__4737__auto___28404]));

var G__28405 = (i__4737__auto___28404 + (1));
i__4737__auto___28404 = G__28405;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28402){var e = e28402;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28401){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28401));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28406){var e = e28406;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28409 = arguments.length;
var i__4737__auto___28410 = (0);
while(true){
if((i__4737__auto___28410 < len__4736__auto___28409)){
args__4742__auto__.push((arguments[i__4737__auto___28410]));

var G__28411 = (i__4737__auto___28410 + (1));
i__4737__auto___28410 = G__28411;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28408){var e = e28408;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28407){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28407));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28414 = arguments.length;
var i__4737__auto___28415 = (0);
while(true){
if((i__4737__auto___28415 < len__4736__auto___28414)){
args__4742__auto__.push((arguments[i__4737__auto___28415]));

var G__28416 = (i__4737__auto___28415 + (1));
i__4737__auto___28415 = G__28416;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e28413){var e = e28413;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28412){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28412));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28417){var e = e28417;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28418){var e = e28418;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28421 = arguments.length;
var i__4737__auto___28422 = (0);
while(true){
if((i__4737__auto___28422 < len__4736__auto___28421)){
args__4742__auto__.push((arguments[i__4737__auto___28422]));

var G__28423 = (i__4737__auto___28422 + (1));
i__4737__auto___28422 = G__28423;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28420){var e = e28420;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28419){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28419));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28426 = arguments.length;
var i__4737__auto___28427 = (0);
while(true){
if((i__4737__auto___28427 < len__4736__auto___28426)){
args__4742__auto__.push((arguments[i__4737__auto___28427]));

var G__28428 = (i__4737__auto___28427 + (1));
i__4737__auto___28427 = G__28428;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28425){var e = e28425;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28424){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28424));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28431 = arguments.length;
var i__4737__auto___28432 = (0);
while(true){
if((i__4737__auto___28432 < len__4736__auto___28431)){
args__4742__auto__.push((arguments[i__4737__auto___28432]));

var G__28433 = (i__4737__auto___28432 + (1));
i__4737__auto___28432 = G__28433;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28430){var e = e28430;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28429){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28429));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28436 = arguments.length;
var i__4737__auto___28437 = (0);
while(true){
if((i__4737__auto___28437 < len__4736__auto___28436)){
args__4742__auto__.push((arguments[i__4737__auto___28437]));

var G__28438 = (i__4737__auto___28437 + (1));
i__4737__auto___28437 = G__28438;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28435){var e = e28435;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28434){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28434));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28441 = arguments.length;
var i__4737__auto___28442 = (0);
while(true){
if((i__4737__auto___28442 < len__4736__auto___28441)){
args__4742__auto__.push((arguments[i__4737__auto___28442]));

var G__28443 = (i__4737__auto___28442 + (1));
i__4737__auto___28442 = G__28443;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28440){var e = e28440;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28439){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28439));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28446 = arguments.length;
var i__4737__auto___28447 = (0);
while(true){
if((i__4737__auto___28447 < len__4736__auto___28446)){
args__4742__auto__.push((arguments[i__4737__auto___28447]));

var G__28448 = (i__4737__auto___28447 + (1));
i__4737__auto___28447 = G__28448;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28445){var e = e28445;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28444){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28444));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28451 = arguments.length;
var i__4737__auto___28452 = (0);
while(true){
if((i__4737__auto___28452 < len__4736__auto___28451)){
args__4742__auto__.push((arguments[i__4737__auto___28452]));

var G__28453 = (i__4737__auto___28452 + (1));
i__4737__auto___28452 = G__28453;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28450){var e = e28450;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28449){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28449));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28455 = arguments.length;
switch (G__28455) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28483){
var state_val_28484 = (state_28483[(1)]);
if((state_val_28484 === (7))){
var inst_28468 = (state_28483[(7)]);
var inst_28471 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28468,"query",query_map);
var state_28483__$1 = state_28483;
var statearr_28485_28571 = state_28483__$1;
(statearr_28485_28571[(2)] = inst_28471);

(statearr_28485_28571[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (1))){
var state_28483__$1 = state_28483;
var statearr_28486_28572 = state_28483__$1;
(statearr_28486_28572[(2)] = null);

(statearr_28486_28572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (4))){
var inst_28456 = (state_28483[(2)]);
var state_28483__$1 = state_28483;
var statearr_28487_28573 = state_28483__$1;
(statearr_28487_28573[(2)] = inst_28456);

(statearr_28487_28573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (6))){
var inst_28468 = (state_28483[(7)]);
var inst_28468__$1 = (state_28483[(2)]);
var inst_28469 = fluree.db.util.core.exception_QMARK_.call(null,inst_28468__$1);
var state_28483__$1 = (function (){var statearr_28488 = state_28483;
(statearr_28488[(7)] = inst_28468__$1);

return statearr_28488;
})();
if(inst_28469){
var statearr_28489_28574 = state_28483__$1;
(statearr_28489_28574[(1)] = (7));

} else {
var statearr_28490_28575 = state_28483__$1;
(statearr_28490_28575[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (3))){
var inst_28481 = (state_28483[(2)]);
var state_28483__$1 = state_28483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28483__$1,inst_28481);
} else {
if((state_val_28484 === (2))){
var inst_28462 = (state_28483[(8)]);
var _ = (function (){var statearr_28492 = state_28483;
(statearr_28492[(4)] = cljs.core.cons.call(null,(5),(state_28483[(4)])));

return statearr_28492;
})();
var inst_28462__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28463 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28464 = cljs.core.assoc.call(null,inst_28463,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28462__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28465 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28464);
var inst_28466 = fluree.db.query.fql.query.call(null,db,inst_28465);
var state_28483__$1 = (function (){var statearr_28493 = state_28483;
(statearr_28493[(8)] = inst_28462__$1);

return statearr_28493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28483__$1,(6),inst_28466);
} else {
if((state_val_28484 === (9))){
var inst_28478 = (state_28483[(2)]);
var _ = (function (){var statearr_28494 = state_28483;
(statearr_28494[(4)] = cljs.core.rest.call(null,(state_28483[(4)])));

return statearr_28494;
})();
var state_28483__$1 = state_28483;
var statearr_28495_28576 = state_28483__$1;
(statearr_28495_28576[(2)] = inst_28478);

(statearr_28495_28576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (5))){
var _ = (function (){var statearr_28496 = state_28483;
(statearr_28496[(4)] = cljs.core.rest.call(null,(state_28483[(4)])));

return statearr_28496;
})();
var state_28483__$1 = state_28483;
var ex28491 = (state_28483__$1[(2)]);
var statearr_28497_28577 = state_28483__$1;
(statearr_28497_28577[(5)] = ex28491);


if((ex28491 instanceof Error)){
var statearr_28498_28578 = state_28483__$1;
(statearr_28498_28578[(1)] = (4));

(statearr_28498_28578[(5)] = null);

} else {
throw ex28491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28484 === (8))){
var inst_28462 = (state_28483[(8)]);
var inst_28468 = (state_28483[(7)]);
var inst_28473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28474 = cljs.core.deref.call(null,inst_28462);
var inst_28475 = [inst_28468,inst_28474];
var inst_28476 = (new cljs.core.PersistentVector(null,2,(5),inst_28473,inst_28475,null));
var state_28483__$1 = state_28483;
var statearr_28499_28579 = state_28483__$1;
(statearr_28499_28579[(2)] = inst_28476);

(statearr_28499_28579[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_28500 = [null,null,null,null,null,null,null,null,null];
(statearr_28500[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_28500[(1)] = (1));

return statearr_28500;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_28483){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28501){var ex__2882__auto__ = e28501;
var statearr_28502_28580 = state_28483;
(statearr_28502_28580[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28483[(4)]))){
var statearr_28503_28581 = state_28483;
(statearr_28503_28581[(1)] = cljs.core.first.call(null,(state_28483[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28582 = state_28483;
state_28483 = G__28582;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_28483){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_28483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28504 = f__2902__auto__.call(null);
(statearr_28504[(6)] = c__2901__auto__);

return statearr_28504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28549){
var state_val_28550 = (state_28549[(1)]);
if((state_val_28550 === (7))){
var inst_28535 = (state_28549[(2)]);
var inst_28536 = fluree.db.query.fql.query.call(null,db,inst_28535);
var state_28549__$1 = state_28549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28549__$1,(8),inst_28536);
} else {
if((state_val_28550 === (1))){
var inst_28505 = typeof select === 'string';
var state_28549__$1 = state_28549;
if(cljs.core.truth_(inst_28505)){
var statearr_28551_28583 = state_28549__$1;
(statearr_28551_28583[(1)] = (2));

} else {
var statearr_28552_28584 = state_28549__$1;
(statearr_28552_28584[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (4))){
var inst_28518 = (state_28549[(7)]);
var inst_28511 = (state_28549[(8)]);
var inst_28510 = (state_28549[(2)]);
var inst_28511__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28512 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28513 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28514 = [inst_28511__$1,(100000)];
var inst_28515 = cljs.core.PersistentHashMap.fromArrays(inst_28513,inst_28514);
var inst_28516 = [inst_28510,from,where,block,limit,inst_28515];
var inst_28517 = cljs.core.PersistentHashMap.fromArrays(inst_28512,inst_28516);
var inst_28518__$1 = fluree.db.util.core.without_nils.call(null,inst_28517);
var inst_28519 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28518__$1);
var inst_28520 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28518__$1);
var inst_28521 = cljs.core.first.call(null,inst_28520);
var inst_28522 = fluree.db.dbfunctions.internal.str.call(null,inst_28521);
var inst_28523 = cljs.core._EQ_.call(null,"[",inst_28522);
var inst_28524 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28518__$1);
var inst_28525 = cljs.core.last.call(null,inst_28524);
var inst_28526 = fluree.db.dbfunctions.internal.str.call(null,inst_28525);
var inst_28527 = cljs.core._EQ_.call(null,"]",inst_28526);
var inst_28528 = fluree.db.dbfunctions.internal.and.call(null,inst_28519,inst_28523,inst_28527);
var state_28549__$1 = (function (){var statearr_28553 = state_28549;
(statearr_28553[(7)] = inst_28518__$1);

(statearr_28553[(8)] = inst_28511__$1);

return statearr_28553;
})();
if(cljs.core.truth_(inst_28528)){
var statearr_28554_28585 = state_28549__$1;
(statearr_28554_28585[(1)] = (5));

} else {
var statearr_28555_28586 = state_28549__$1;
(statearr_28555_28586[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (6))){
var inst_28518 = (state_28549[(7)]);
var state_28549__$1 = state_28549;
var statearr_28556_28587 = state_28549__$1;
(statearr_28556_28587[(2)] = inst_28518);

(statearr_28556_28587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (3))){
var state_28549__$1 = state_28549;
var statearr_28557_28588 = state_28549__$1;
(statearr_28557_28588[(2)] = select);

(statearr_28557_28588[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (2))){
var inst_28507 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28549__$1 = state_28549;
var statearr_28558_28589 = state_28549__$1;
(statearr_28558_28589[(2)] = inst_28507);

(statearr_28558_28589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (11))){
var inst_28547 = (state_28549[(2)]);
var state_28549__$1 = state_28549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28549__$1,inst_28547);
} else {
if((state_val_28550 === (9))){
var inst_28538 = (state_28549[(9)]);
var state_28549__$1 = state_28549;
var statearr_28559_28590 = state_28549__$1;
(statearr_28559_28590[(2)] = inst_28538);

(statearr_28559_28590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (5))){
var inst_28518 = (state_28549[(7)]);
var inst_28530 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28518);
var inst_28531 = cljs.reader.read_string.call(null,inst_28530);
var inst_28532 = cljs.core.assoc.call(null,inst_28518,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28531);
var state_28549__$1 = state_28549;
var statearr_28560_28591 = state_28549__$1;
(statearr_28560_28591[(2)] = inst_28532);

(statearr_28560_28591[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (10))){
var inst_28538 = (state_28549[(9)]);
var inst_28511 = (state_28549[(8)]);
var inst_28542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28543 = cljs.core.deref.call(null,inst_28511);
var inst_28544 = [inst_28538,inst_28543];
var inst_28545 = (new cljs.core.PersistentVector(null,2,(5),inst_28542,inst_28544,null));
var state_28549__$1 = state_28549;
var statearr_28561_28592 = state_28549__$1;
(statearr_28561_28592[(2)] = inst_28545);

(statearr_28561_28592[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (8))){
var inst_28538 = (state_28549[(9)]);
var inst_28538__$1 = (state_28549[(2)]);
var inst_28539 = fluree.db.util.core.exception_QMARK_.call(null,inst_28538__$1);
var state_28549__$1 = (function (){var statearr_28562 = state_28549;
(statearr_28562[(9)] = inst_28538__$1);

return statearr_28562;
})();
if(inst_28539){
var statearr_28563_28593 = state_28549__$1;
(statearr_28563_28593[(1)] = (9));

} else {
var statearr_28564_28594 = state_28549__$1;
(statearr_28564_28594[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_28565 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28565[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_28565[(1)] = (1));

return statearr_28565;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_28549){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28566){var ex__2882__auto__ = e28566;
var statearr_28567_28595 = state_28549;
(statearr_28567_28595[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28549[(4)]))){
var statearr_28568_28596 = state_28549;
(statearr_28568_28596[(1)] = cljs.core.first.call(null,(state_28549[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28597 = state_28549;
state_28549 = G__28597;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_28549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_28549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28569 = f__2902__auto__.call(null);
(statearr_28569[(6)] = c__2901__auto__);

return statearr_28569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28601 = path;
var vec__28602 = G__28601;
var seq__28603 = cljs.core.seq.call(null,vec__28602);
var first__28604 = cljs.core.first.call(null,seq__28603);
var seq__28603__$1 = cljs.core.next.call(null,seq__28603);
var var$ = first__28604;
var r = seq__28603__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28601__$1 = G__28601;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28608 = G__28601__$1;
var seq__28609 = cljs.core.seq.call(null,vec__28608);
var first__28610 = cljs.core.first.call(null,seq__28609);
var seq__28609__$1 = cljs.core.next.call(null,seq__28609);
var var$__$1 = first__28610;
var r__$1 = seq__28609__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28611 = r__$1;
var G__28612 = n__$2;
var G__28613 = next_clauses;
G__28601__$1 = G__28611;
n__$1 = G__28612;
where_clauses__$1 = G__28613;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28614 = r__$1;
var G__28615 = next_n;
var G__28616 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28601__$1 = G__28614;
n__$1 = G__28615;
where_clauses__$1 = G__28616;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28653){
var state_val_28654 = (state_28653[(1)]);
if((state_val_28654 === (7))){
var inst_28626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28627 = [path];
var inst_28628 = (new cljs.core.PersistentVector(null,1,(5),inst_28626,inst_28627,null));
var state_28653__$1 = state_28653;
var statearr_28655_28683 = state_28653__$1;
(statearr_28655_28683[(2)] = inst_28628);

(statearr_28655_28683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (1))){
var state_28653__$1 = state_28653;
var statearr_28656_28684 = state_28653__$1;
(statearr_28656_28684[(2)] = null);

(statearr_28656_28684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (4))){
var inst_28617 = (state_28653[(2)]);
var state_28653__$1 = state_28653;
var statearr_28657_28685 = state_28653__$1;
(statearr_28657_28685[(2)] = inst_28617);

(statearr_28657_28685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (13))){
var inst_28644 = (state_28653[(2)]);
var inst_28645 = fluree.db.util.async.throw_err.call(null,inst_28644);
var _ = (function (){var statearr_28658 = state_28653;
(statearr_28658[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28658;
})();
var state_28653__$1 = state_28653;
var statearr_28659_28686 = state_28653__$1;
(statearr_28659_28686[(2)] = inst_28645);

(statearr_28659_28686[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (6))){
var state_28653__$1 = state_28653;
var statearr_28661_28687 = state_28653__$1;
(statearr_28661_28687[(2)] = path);

(statearr_28661_28687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (3))){
var inst_28651 = (state_28653[(2)]);
var state_28653__$1 = state_28653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28653__$1,inst_28651);
} else {
if((state_val_28654 === (12))){
var _ = (function (){var statearr_28662 = state_28653;
(statearr_28662[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28662;
})();
var state_28653__$1 = state_28653;
var ex28660 = (state_28653__$1[(2)]);
var statearr_28663_28688 = state_28653__$1;
(statearr_28663_28688[(5)] = ex28660);


var statearr_28664_28689 = state_28653__$1;
(statearr_28664_28689[(1)] = (11));

(statearr_28664_28689[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (2))){
var _ = (function (){var statearr_28665 = state_28653;
(statearr_28665[(4)] = cljs.core.cons.call(null,(5),(state_28653[(4)])));

return statearr_28665;
})();
var inst_28623 = cljs.core.vector_QMARK_.call(null,path);
var state_28653__$1 = state_28653;
if(inst_28623){
var statearr_28666_28690 = state_28653__$1;
(statearr_28666_28690[(1)] = (6));

} else {
var statearr_28667_28691 = state_28653__$1;
(statearr_28667_28691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (11))){
var inst_28630 = (state_28653[(7)]);
var inst_28635 = (state_28653[(2)]);
var inst_28636 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28635,"relationship?",startSubject,inst_28630,endSubject);
var state_28653__$1 = state_28653;
var statearr_28669_28692 = state_28653__$1;
(statearr_28669_28692[(2)] = inst_28636);

(statearr_28669_28692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (9))){
var inst_28634 = (state_28653[(8)]);
var _ = (function (){var statearr_28670 = state_28653;
(statearr_28670[(4)] = cljs.core.cons.call(null,(12),(state_28653[(4)])));

return statearr_28670;
})();
var inst_28642 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28634);
var state_28653__$1 = state_28653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28653__$1,(13),inst_28642);
} else {
if((state_val_28654 === (5))){
var _ = (function (){var statearr_28671 = state_28653;
(statearr_28671[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28671;
})();
var state_28653__$1 = state_28653;
var ex28668 = (state_28653__$1[(2)]);
var statearr_28672_28693 = state_28653__$1;
(statearr_28672_28693[(5)] = ex28668);


if((ex28668 instanceof Error)){
var statearr_28673_28694 = state_28653__$1;
(statearr_28673_28694[(1)] = (4));

(statearr_28673_28694[(5)] = null);

} else {
throw ex28668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (10))){
var inst_28648 = (state_28653[(2)]);
var _ = (function (){var statearr_28674 = state_28653;
(statearr_28674[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28674;
})();
var state_28653__$1 = state_28653;
var statearr_28675_28695 = state_28653__$1;
(statearr_28675_28695[(2)] = inst_28648);

(statearr_28675_28695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (8))){
var inst_28630 = (state_28653[(7)]);
var inst_28630__$1 = (state_28653[(2)]);
var inst_28631 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28630__$1,endSubject);
var inst_28632 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28633 = ["?var1",inst_28631];
var inst_28634 = cljs.core.PersistentHashMap.fromArrays(inst_28632,inst_28633);
var state_28653__$1 = (function (){var statearr_28676 = state_28653;
(statearr_28676[(7)] = inst_28630__$1);

(statearr_28676[(8)] = inst_28634);

return statearr_28676;
})();
var statearr_28677_28696 = state_28653__$1;
(statearr_28677_28696[(2)] = null);

(statearr_28677_28696[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_28678 = [null,null,null,null,null,null,null,null,null];
(statearr_28678[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__);

(statearr_28678[(1)] = (1));

return statearr_28678;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1 = (function (state_28653){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28679){var ex__2882__auto__ = e28679;
var statearr_28680_28697 = state_28653;
(statearr_28680_28697[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28653[(4)]))){
var statearr_28681_28698 = state_28653;
(statearr_28681_28698[(1)] = cljs.core.first.call(null,(state_28653[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28699 = state_28653;
state_28653 = G__28699;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__ = function(state_28653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1.call(this,state_28653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28682 = f__2902__auto__.call(null);
(statearr_28682[(6)] = c__2901__auto__);

return statearr_28682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28700){var e = e28700;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28701){var e = e28701;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28702){var e = e28702;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28703){var e = e28703;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28706 = arguments.length;
var i__4737__auto___28707 = (0);
while(true){
if((i__4737__auto___28707 < len__4736__auto___28706)){
args__4742__auto__.push((arguments[i__4737__auto___28707]));

var G__28708 = (i__4737__auto___28707 + (1));
i__4737__auto___28707 = G__28708;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28705){var e = e28705;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28704){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28704));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28711 = arguments.length;
var i__4737__auto___28712 = (0);
while(true){
if((i__4737__auto___28712 < len__4736__auto___28711)){
args__4742__auto__.push((arguments[i__4737__auto___28712]));

var G__28713 = (i__4737__auto___28712 + (1));
i__4737__auto___28712 = G__28713;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28710){var e = e28710;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28709){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28709));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28716 = arguments.length;
var i__4737__auto___28717 = (0);
while(true){
if((i__4737__auto___28717 < len__4736__auto___28716)){
args__4742__auto__.push((arguments[i__4737__auto___28717]));

var G__28718 = (i__4737__auto___28717 + (1));
i__4737__auto___28717 = G__28718;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28715){var e = e28715;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28714){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28714));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28721 = arguments.length;
var i__4737__auto___28722 = (0);
while(true){
if((i__4737__auto___28722 < len__4736__auto___28721)){
args__4742__auto__.push((arguments[i__4737__auto___28722]));

var G__28723 = (i__4737__auto___28722 + (1));
i__4737__auto___28722 = G__28723;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28720){var e = e28720;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28719){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28719));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28724){var e = e28724;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28725){var e = e28725;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28726){var e = e28726;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28727){var e = e28727;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28728){var e = e28728;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28734 = path;
var vec__28735 = G__28734;
var seq__28736 = cljs.core.seq.call(null,vec__28735);
var first__28737 = cljs.core.first.call(null,seq__28736);
var seq__28736__$1 = cljs.core.next.call(null,seq__28736);
var pred = first__28737;
var r = seq__28736__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28734__$1 = G__28734;
var subjects__$1 = subjects;
while(true){
var vec__28741 = G__28734__$1;
var seq__28742 = cljs.core.seq.call(null,vec__28741);
var first__28743 = cljs.core.first.call(null,seq__28742);
var seq__28742__$1 = cljs.core.next.call(null,seq__28742);
var pred__$1 = first__28743;
var r__$1 = seq__28742__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28734__$1,subjects__$1,vec__28741,seq__28742,first__28743,seq__28742__$1,pred__$1,r__$1,subjects__$2,G__28734,vec__28735,seq__28736,first__28737,seq__28736__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28734__$1,subjects__$1,vec__28741,seq__28742,first__28743,seq__28742__$1,pred__$1,r__$1,subjects__$2,G__28734,vec__28735,seq__28736,first__28737,seq__28736__$1,pred,r,subjects){
return (function (p1__28729_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28729_SHARP_,pred__$1);
});})(G__28734__$1,subjects__$1,vec__28741,seq__28742,first__28743,seq__28742__$1,pred__$1,r__$1,subjects__$2,G__28734,vec__28735,seq__28736,first__28737,seq__28736__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28734__$1,subjects__$1,vec__28741,seq__28742,first__28743,seq__28742__$1,pred__$1,r__$1,subjects__$2,G__28734,vec__28735,seq__28736,first__28737,seq__28736__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__28744 = r__$1;
var G__28745 = next_subjects;
G__28734__$1 = G__28744;
subjects__$1 = G__28745;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28730){var e = e28730;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28746){var e = e28746;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e28747){var e = e28747;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28750 = arguments.length;
var i__4737__auto___28751 = (0);
while(true){
if((i__4737__auto___28751 < len__4736__auto___28750)){
args__4742__auto__.push((arguments[i__4737__auto___28751]));

var G__28752 = (i__4737__auto___28751 + (1));
i__4737__auto___28751 = G__28752;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28749){var e = e28749;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28748){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28748));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28753){var e = e28753;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28756 = arguments.length;
var i__4737__auto___28757 = (0);
while(true){
if((i__4737__auto___28757 < len__4736__auto___28756)){
args__4742__auto__.push((arguments[i__4737__auto___28757]));

var G__28758 = (i__4737__auto___28757 + (1));
i__4737__auto___28757 = G__28758;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28755){var e = e28755;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28754){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28754));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28759){var e = e28759;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28814){
var state_val_28815 = (state_28814[(1)]);
if((state_val_28815 === (7))){
var inst_28761 = (state_28814[(2)]);
var state_28814__$1 = state_28814;
var statearr_28816_28849 = state_28814__$1;
(statearr_28816_28849[(2)] = inst_28761);

(statearr_28816_28849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (1))){
var state_28814__$1 = state_28814;
var statearr_28817_28850 = state_28814__$1;
(statearr_28817_28850[(2)] = null);

(statearr_28817_28850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (4))){
var inst_28760 = (state_28814[(2)]);
var state_28814__$1 = (function (){var statearr_28818 = state_28814;
(statearr_28818[(7)] = inst_28760);

return statearr_28818;
})();
var statearr_28819_28851 = state_28814__$1;
(statearr_28819_28851[(2)] = null);

(statearr_28819_28851[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (15))){
var inst_28798 = (state_28814[(8)]);
var inst_28802 = inst_28798.o;
var state_28814__$1 = state_28814;
var statearr_28820_28852 = state_28814__$1;
(statearr_28820_28852[(2)] = inst_28802);

(statearr_28820_28852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (13))){
var inst_28798 = (state_28814[(8)]);
var inst_28794 = (state_28814[(2)]);
var inst_28795 = fluree.db.util.async.throw_err.call(null,inst_28794);
var inst_28796 = fluree.db.dbfunctions.internal.count.call(null,inst_28795);
var inst_28798__$1 = cljs.core.first.call(null,inst_28795);
var inst_28799 = (inst_28798__$1 == null);
var state_28814__$1 = (function (){var statearr_28821 = state_28814;
(statearr_28821[(9)] = inst_28796);

(statearr_28821[(8)] = inst_28798__$1);

return statearr_28821;
})();
if(cljs.core.truth_(inst_28799)){
var statearr_28822_28853 = state_28814__$1;
(statearr_28822_28853[(1)] = (14));

} else {
var statearr_28823_28854 = state_28814__$1;
(statearr_28823_28854[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (6))){
var inst_28770 = (state_28814[(2)]);
var state_28814__$1 = state_28814;
var statearr_28824_28855 = state_28814__$1;
(statearr_28824_28855[(2)] = inst_28770);

(statearr_28824_28855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (3))){
var inst_28812 = (state_28814[(2)]);
var state_28814__$1 = state_28814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28814__$1,inst_28812);
} else {
if((state_val_28815 === (12))){
var inst_28809 = (state_28814[(2)]);
var _ = (function (){var statearr_28825 = state_28814;
(statearr_28825[(4)] = cljs.core.rest.call(null,(state_28814[(4)])));

return statearr_28825;
})();
var state_28814__$1 = state_28814;
var statearr_28826_28856 = state_28814__$1;
(statearr_28826_28856[(2)] = inst_28809);

(statearr_28826_28856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (2))){
var _ = (function (){var statearr_28828 = state_28814;
(statearr_28828[(4)] = cljs.core.cons.call(null,(9),(state_28814[(4)])));

return statearr_28828;
})();
var inst_28776 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28777 = typeof inst_28776 === 'string';
var state_28814__$1 = state_28814;
if(cljs.core.truth_(inst_28777)){
var statearr_28829_28857 = state_28814__$1;
(statearr_28829_28857[(1)] = (10));

} else {
var statearr_28830_28858 = state_28814__$1;
(statearr_28830_28858[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (11))){
var inst_28783 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28784 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28783);
var inst_28785 = fluree.db.dbfunctions.internal.inc.call(null,inst_28784);
var inst_28786 = cljs.core.assoc.call(null,inst_28783,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28785);
var inst_28787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28788 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28789 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28790 = [inst_28788,inst_28789];
var inst_28791 = (new cljs.core.PersistentVector(null,2,(5),inst_28787,inst_28790,null));
var inst_28792 = fluree.db.dbproto._search.call(null,inst_28786,inst_28791);
var state_28814__$1 = state_28814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28814__$1,(13),inst_28792);
} else {
if((state_val_28815 === (9))){
var _ = (function (){var statearr_28831 = state_28814;
(statearr_28831[(4)] = cljs.core.rest.call(null,(state_28814[(4)])));

return statearr_28831;
})();
var state_28814__$1 = state_28814;
var ex28827 = (state_28814__$1[(2)]);
var statearr_28832_28859 = state_28814__$1;
(statearr_28832_28859[(5)] = ex28827);


var statearr_28833_28860 = state_28814__$1;
(statearr_28833_28860[(1)] = (4));

(statearr_28833_28860[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (5))){
var inst_28760 = (state_28814[(7)]);
var _ = (function (){var statearr_28834 = state_28814;
(statearr_28834[(4)] = cljs.core.cons.call(null,(8),(state_28814[(4)])));

return statearr_28834;
})();
var inst_28767 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28760,"?pO","Context Object");
var ___$1 = (function (){var statearr_28835 = state_28814;
(statearr_28835[(4)] = cljs.core.rest.call(null,(state_28814[(4)])));

return statearr_28835;
})();
var state_28814__$1 = state_28814;
var statearr_28836_28861 = state_28814__$1;
(statearr_28836_28861[(2)] = inst_28767);

(statearr_28836_28861[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (14))){
var state_28814__$1 = state_28814;
var statearr_28837_28862 = state_28814__$1;
(statearr_28837_28862[(2)] = null);

(statearr_28837_28862[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (16))){
var inst_28796 = (state_28814[(9)]);
var inst_28804 = (state_28814[(2)]);
var inst_28805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28806 = [inst_28804,inst_28796];
var inst_28807 = (new cljs.core.PersistentVector(null,2,(5),inst_28805,inst_28806,null));
var state_28814__$1 = state_28814;
var statearr_28839_28863 = state_28814__$1;
(statearr_28839_28863[(2)] = inst_28807);

(statearr_28839_28863[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (10))){
var inst_28779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28780 = [null,(0)];
var inst_28781 = (new cljs.core.PersistentVector(null,2,(5),inst_28779,inst_28780,null));
var state_28814__$1 = state_28814;
var statearr_28840_28864 = state_28814__$1;
(statearr_28840_28864[(2)] = inst_28781);

(statearr_28840_28864[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28815 === (8))){
var _ = (function (){var statearr_28841 = state_28814;
(statearr_28841[(4)] = cljs.core.rest.call(null,(state_28814[(4)])));

return statearr_28841;
})();
var state_28814__$1 = state_28814;
var ex28838 = (state_28814__$1[(2)]);
var statearr_28842_28865 = state_28814__$1;
(statearr_28842_28865[(5)] = ex28838);


var statearr_28843_28866 = state_28814__$1;
(statearr_28843_28866[(1)] = (7));

(statearr_28843_28866[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0 = (function (){
var statearr_28844 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28844[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__);

(statearr_28844[(1)] = (1));

return statearr_28844;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1 = (function (state_28814){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28845){var ex__2882__auto__ = e28845;
var statearr_28846_28867 = state_28814;
(statearr_28846_28867[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28814[(4)]))){
var statearr_28847_28868 = state_28814;
(statearr_28847_28868[(1)] = cljs.core.first.call(null,(state_28814[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28869 = state_28814;
state_28814 = G__28869;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__ = function(state_28814){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1.call(this,state_28814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28848 = f__2902__auto__.call(null);
(statearr_28848[(6)] = c__2901__auto__);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28921){
var state_val_28922 = (state_28921[(1)]);
if((state_val_28922 === (7))){
var inst_28871 = (state_28921[(2)]);
var state_28921__$1 = state_28921;
var statearr_28923_28952 = state_28921__$1;
(statearr_28923_28952[(2)] = inst_28871);

(statearr_28923_28952[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (1))){
var state_28921__$1 = state_28921;
var statearr_28924_28953 = state_28921__$1;
(statearr_28924_28953[(2)] = null);

(statearr_28924_28953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (4))){
var inst_28870 = (state_28921[(2)]);
var state_28921__$1 = (function (){var statearr_28925 = state_28921;
(statearr_28925[(7)] = inst_28870);

return statearr_28925;
})();
var statearr_28926_28954 = state_28921__$1;
(statearr_28926_28954[(2)] = null);

(statearr_28926_28954[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (13))){
var inst_28916 = (state_28921[(2)]);
var _ = (function (){var statearr_28927 = state_28921;
(statearr_28927[(4)] = cljs.core.rest.call(null,(state_28921[(4)])));

return statearr_28927;
})();
var state_28921__$1 = state_28921;
var statearr_28928_28955 = state_28921__$1;
(statearr_28928_28955[(2)] = inst_28916);

(statearr_28928_28955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (6))){
var inst_28880 = (state_28921[(2)]);
var state_28921__$1 = state_28921;
var statearr_28929_28956 = state_28921__$1;
(statearr_28929_28956[(2)] = inst_28880);

(statearr_28929_28956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (3))){
var inst_28919 = (state_28921[(2)]);
var state_28921__$1 = state_28921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28921__$1,inst_28919);
} else {
if((state_val_28922 === (12))){
var inst_28903 = (state_28921[(8)]);
var inst_28912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28913 = [null,inst_28903];
var inst_28914 = (new cljs.core.PersistentVector(null,2,(5),inst_28912,inst_28913,null));
var state_28921__$1 = state_28921;
var statearr_28930_28957 = state_28921__$1;
(statearr_28930_28957[(2)] = inst_28914);

(statearr_28930_28957[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (2))){
var _ = (function (){var statearr_28932 = state_28921;
(statearr_28932[(4)] = cljs.core.cons.call(null,(9),(state_28921[(4)])));

return statearr_28932;
})();
var inst_28889 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28892 = [null,pred_name,"?o"];
var inst_28893 = (new cljs.core.PersistentVector(null,3,(5),inst_28891,inst_28892,null));
var inst_28894 = [inst_28893];
var inst_28895 = (new cljs.core.PersistentVector(null,1,(5),inst_28890,inst_28894,null));
var inst_28896 = ["?o",inst_28895,opts];
var inst_28897 = cljs.core.PersistentHashMap.fromArrays(inst_28889,inst_28896);
var inst_28898 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28897);
var state_28921__$1 = state_28921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28921__$1,(10),inst_28898);
} else {
if((state_val_28922 === (11))){
var inst_28903 = (state_28921[(8)]);
var inst_28902 = (state_28921[(9)]);
var inst_28907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28908 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_28902);
var inst_28909 = [inst_28908,inst_28903];
var inst_28910 = (new cljs.core.PersistentVector(null,2,(5),inst_28907,inst_28909,null));
var state_28921__$1 = state_28921;
var statearr_28933_28958 = state_28921__$1;
(statearr_28933_28958[(2)] = inst_28910);

(statearr_28933_28958[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (9))){
var _ = (function (){var statearr_28934 = state_28921;
(statearr_28934[(4)] = cljs.core.rest.call(null,(state_28921[(4)])));

return statearr_28934;
})();
var state_28921__$1 = state_28921;
var ex28931 = (state_28921__$1[(2)]);
var statearr_28935_28959 = state_28921__$1;
(statearr_28935_28959[(5)] = ex28931);


var statearr_28936_28960 = state_28921__$1;
(statearr_28936_28960[(1)] = (4));

(statearr_28936_28960[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (5))){
var inst_28870 = (state_28921[(7)]);
var _ = (function (){var statearr_28938 = state_28921;
(statearr_28938[(4)] = cljs.core.cons.call(null,(8),(state_28921[(4)])));

return statearr_28938;
})();
var inst_28877 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28870,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_28939 = state_28921;
(statearr_28939[(4)] = cljs.core.rest.call(null,(state_28921[(4)])));

return statearr_28939;
})();
var state_28921__$1 = state_28921;
var statearr_28940_28961 = state_28921__$1;
(statearr_28940_28961[(2)] = inst_28877);

(statearr_28940_28961[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (10))){
var inst_28902 = (state_28921[(9)]);
var inst_28900 = (state_28921[(2)]);
var inst_28901 = fluree.db.util.async.throw_err.call(null,inst_28900);
var inst_28902__$1 = cljs.core.nth.call(null,inst_28901,(0),null);
var inst_28903 = cljs.core.nth.call(null,inst_28901,(1),null);
var inst_28904 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_28902__$1);
var inst_28905 = cljs.core.not.call(null,inst_28904);
var state_28921__$1 = (function (){var statearr_28941 = state_28921;
(statearr_28941[(8)] = inst_28903);

(statearr_28941[(9)] = inst_28902__$1);

return statearr_28941;
})();
if(inst_28905){
var statearr_28942_28962 = state_28921__$1;
(statearr_28942_28962[(1)] = (11));

} else {
var statearr_28943_28963 = state_28921__$1;
(statearr_28943_28963[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28922 === (8))){
var _ = (function (){var statearr_28944 = state_28921;
(statearr_28944[(4)] = cljs.core.rest.call(null,(state_28921[(4)])));

return statearr_28944;
})();
var state_28921__$1 = state_28921;
var ex28937 = (state_28921__$1[(2)]);
var statearr_28945_28964 = state_28921__$1;
(statearr_28945_28964[(5)] = ex28937);


var statearr_28946_28965 = state_28921__$1;
(statearr_28946_28965[(1)] = (7));

(statearr_28946_28965[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0 = (function (){
var statearr_28947 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28947[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__);

(statearr_28947[(1)] = (1));

return statearr_28947;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1 = (function (state_28921){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28948){var ex__2882__auto__ = e28948;
var statearr_28949_28966 = state_28921;
(statearr_28949_28966[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28921[(4)]))){
var statearr_28950_28967 = state_28921;
(statearr_28950_28967[(1)] = cljs.core.first.call(null,(state_28921[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28968 = state_28921;
state_28921 = G__28968;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__ = function(state_28921){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1.call(this,state_28921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28951 = f__2902__auto__.call(null);
(statearr_28951[(6)] = c__2901__auto__);

return statearr_28951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,((typeof email === 'string')?cljs.core.re_matches.call(null,pattern,email):false));
}catch (e28969){var e = e28969;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28971 = arguments.length;
switch (G__28971) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29041){
var state_val_29042 = (state_29041[(1)]);
if((state_val_29042 === (7))){
var inst_28973 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29043_29087 = state_29041__$1;
(statearr_29043_29087[(2)] = inst_28973);

(statearr_29043_29087[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (20))){
var inst_29017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29018 = ["*"];
var inst_29019 = (new cljs.core.PersistentVector(null,1,(5),inst_29017,inst_29018,null));
var state_29041__$1 = state_29041;
var statearr_29044_29088 = state_29041__$1;
(statearr_29044_29088[(2)] = inst_29019);

(statearr_29044_29088[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (1))){
var state_29041__$1 = state_29041;
var statearr_29045_29089 = state_29041__$1;
(statearr_29045_29089[(2)] = null);

(statearr_29045_29089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (4))){
var inst_28972 = (state_29041[(2)]);
var state_29041__$1 = (function (){var statearr_29046 = state_29041;
(statearr_29046[(7)] = inst_28972);

return statearr_29046;
})();
var statearr_29047_29090 = state_29041__$1;
(statearr_29047_29090[(2)] = null);

(statearr_29047_29090[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (15))){
var inst_29036 = (state_29041[(2)]);
var _ = (function (){var statearr_29048 = state_29041;
(statearr_29048[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29048;
})();
var state_29041__$1 = state_29041;
var statearr_29049_29091 = state_29041__$1;
(statearr_29049_29091[(2)] = inst_29036);

(statearr_29049_29091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (21))){
var inst_29000 = (state_29041[(8)]);
var inst_29007 = (state_29041[(9)]);
var inst_29021 = (state_29041[(2)]);
var inst_29022 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29023 = cljs.core.PersistentHashMap.EMPTY;
var inst_29024 = [inst_29021,inst_29007,inst_29023];
var inst_29025 = cljs.core.PersistentHashMap.fromArrays(inst_29022,inst_29024);
var inst_29026 = fluree.db.dbfunctions.internal.query.call(null,inst_29000,inst_29025);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29041__$1,(22),inst_29026);
} else {
if((state_val_29042 === (13))){
var inst_28995 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29041__$1 = state_29041;
var statearr_29050_29092 = state_29041__$1;
(statearr_29050_29092[(2)] = inst_28995);

(statearr_29050_29092[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (22))){
var inst_29028 = (state_29041[(2)]);
var inst_29029 = fluree.db.util.async.throw_err.call(null,inst_29028);
var inst_29030 = cljs.core.nth.call(null,inst_29029,(0),null);
var inst_29031 = cljs.core.nth.call(null,inst_29029,(1),null);
var inst_29032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29033 = [inst_29030,inst_29031];
var inst_29034 = (new cljs.core.PersistentVector(null,2,(5),inst_29032,inst_29033,null));
var state_29041__$1 = state_29041;
var statearr_29051_29093 = state_29041__$1;
(statearr_29051_29093[(2)] = inst_29034);

(statearr_29051_29093[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (6))){
var inst_28982 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29052_29094 = state_29041__$1;
(statearr_29052_29094[(2)] = inst_28982);

(statearr_29052_29094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (17))){
var inst_29004 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29005 = fluree.db.dbfunctions.internal.get.call(null,inst_29004,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29041__$1 = state_29041;
var statearr_29053_29095 = state_29041__$1;
(statearr_29053_29095[(2)] = inst_29005);

(statearr_29053_29095[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (3))){
var inst_29039 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29041__$1,inst_29039);
} else {
if((state_val_29042 === (12))){
var inst_28993 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_28993)){
var statearr_29054_29096 = state_29041__$1;
(statearr_29054_29096[(1)] = (13));

} else {
var statearr_29055_29097 = state_29041__$1;
(statearr_29055_29097[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (2))){
var inst_28988 = (state_29041[(10)]);
var _ = (function (){var statearr_29056 = state_29041;
(statearr_29056[(4)] = cljs.core.cons.call(null,(9),(state_29041[(4)])));

return statearr_29056;
})();
var inst_28988__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29041__$1 = (function (){var statearr_29057 = state_29041;
(statearr_29057[(10)] = inst_28988__$1);

return statearr_29057;
})();
if(cljs.core.truth_(inst_28988__$1)){
var statearr_29058_29098 = state_29041__$1;
(statearr_29058_29098[(1)] = (10));

} else {
var statearr_29059_29099 = state_29041__$1;
(statearr_29059_29099[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (19))){
var inst_29009 = cljs.core.PersistentVector.EMPTY;
var inst_29010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29011 = ["*"];
var inst_29012 = (new cljs.core.PersistentVector(null,1,(5),inst_29010,inst_29011,null));
var inst_29013 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29014 = cljs.core.concat.call(null,inst_29012,inst_29013);
var inst_29015 = cljs.core.into.call(null,inst_29009,inst_29014);
var state_29041__$1 = state_29041;
var statearr_29061_29100 = state_29041__$1;
(statearr_29061_29100[(2)] = inst_29015);

(statearr_29061_29100[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (11))){
var inst_28988 = (state_29041[(10)]);
var state_29041__$1 = state_29041;
var statearr_29062_29101 = state_29041__$1;
(statearr_29062_29101[(2)] = inst_28988);

(statearr_29062_29101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (9))){
var _ = (function (){var statearr_29063 = state_29041;
(statearr_29063[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29063;
})();
var state_29041__$1 = state_29041;
var ex29060 = (state_29041__$1[(2)]);
var statearr_29064_29102 = state_29041__$1;
(statearr_29064_29102[(5)] = ex29060);


var statearr_29065_29103 = state_29041__$1;
(statearr_29065_29103[(1)] = (4));

(statearr_29065_29103[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (5))){
var inst_28972 = (state_29041[(7)]);
var _ = (function (){var statearr_29066 = state_29041;
(statearr_29066[(4)] = cljs.core.cons.call(null,(8),(state_29041[(4)])));

return statearr_29066;
})();
var inst_28979 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28972,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_29067 = state_29041;
(statearr_29067[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29067;
})();
var state_29041__$1 = state_29041;
var statearr_29068_29104 = state_29041__$1;
(statearr_29068_29104[(2)] = inst_28979);

(statearr_29068_29104[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (14))){
var inst_29001 = (state_29041[(11)]);
var inst_29000 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29001__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29041__$1 = (function (){var statearr_29069 = state_29041;
(statearr_29069[(8)] = inst_29000);

(statearr_29069[(11)] = inst_29001__$1);

return statearr_29069;
})();
if(cljs.core.truth_(inst_29001__$1)){
var statearr_29070_29105 = state_29041__$1;
(statearr_29070_29105[(1)] = (16));

} else {
var statearr_29071_29106 = state_29041__$1;
(statearr_29071_29106[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (16))){
var inst_29001 = (state_29041[(11)]);
var state_29041__$1 = state_29041;
var statearr_29072_29107 = state_29041__$1;
(statearr_29072_29107[(2)] = inst_29001);

(statearr_29072_29107[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (10))){
var inst_28990 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_29041__$1 = state_29041;
var statearr_29074_29108 = state_29041__$1;
(statearr_29074_29108[(2)] = inst_28990);

(statearr_29074_29108[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (18))){
var inst_29007 = (state_29041[(2)]);
var state_29041__$1 = (function (){var statearr_29075 = state_29041;
(statearr_29075[(9)] = inst_29007);

return statearr_29075;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29076_29109 = state_29041__$1;
(statearr_29076_29109[(1)] = (19));

} else {
var statearr_29077_29110 = state_29041__$1;
(statearr_29077_29110[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (8))){
var _ = (function (){var statearr_29078 = state_29041;
(statearr_29078[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29078;
})();
var state_29041__$1 = state_29041;
var ex29073 = (state_29041__$1[(2)]);
var statearr_29079_29111 = state_29041__$1;
(statearr_29079_29111[(5)] = ex29073);


var statearr_29080_29112 = state_29041__$1;
(statearr_29080_29112[(1)] = (7));

(statearr_29080_29112[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_29081 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29081[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_29081[(1)] = (1));

return statearr_29081;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_29041){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_29041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29082){var ex__2882__auto__ = e29082;
var statearr_29083_29113 = state_29041;
(statearr_29083_29113[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_29041[(4)]))){
var statearr_29084_29114 = state_29041;
(statearr_29084_29114[(1)] = cljs.core.first.call(null,(state_29041[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29115 = state_29041;
state_29041 = G__29115;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_29041){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_29041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29085 = f__2902__auto__.call(null);
(statearr_29085[(6)] = c__2901__auto__);

return statearr_29085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29117 = arguments.length;
switch (G__29117) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29161){
var state_val_29162 = (state_29161[(1)]);
if((state_val_29162 === (7))){
var inst_29139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29140 = ["*"];
var inst_29141 = (new cljs.core.PersistentVector(null,1,(5),inst_29139,inst_29140,null));
var state_29161__$1 = state_29161;
var statearr_29163_29183 = state_29161__$1;
(statearr_29163_29183[(2)] = inst_29141);

(statearr_29163_29183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (1))){
var state_29161__$1 = state_29161;
var statearr_29164_29184 = state_29161__$1;
(statearr_29164_29184[(2)] = null);

(statearr_29164_29184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (4))){
var inst_29118 = (state_29161[(2)]);
var inst_29119 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29118,"?p","Context Object",additional_params);
var state_29161__$1 = state_29161;
var statearr_29165_29185 = state_29161__$1;
(statearr_29165_29185[(2)] = inst_29119);

(statearr_29165_29185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (6))){
var inst_29131 = cljs.core.PersistentVector.EMPTY;
var inst_29132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29133 = ["*"];
var inst_29134 = (new cljs.core.PersistentVector(null,1,(5),inst_29132,inst_29133,null));
var inst_29135 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29136 = cljs.core.concat.call(null,inst_29134,inst_29135);
var inst_29137 = cljs.core.into.call(null,inst_29131,inst_29136);
var state_29161__$1 = state_29161;
var statearr_29166_29186 = state_29161__$1;
(statearr_29166_29186[(2)] = inst_29137);

(statearr_29166_29186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (3))){
var inst_29159 = (state_29161[(2)]);
var state_29161__$1 = state_29161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29161__$1,inst_29159);
} else {
if((state_val_29162 === (2))){
var _ = (function (){var statearr_29168 = state_29161;
(statearr_29168[(4)] = cljs.core.cons.call(null,(5),(state_29161[(4)])));

return statearr_29168;
})();
var inst_29128 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29129 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29161__$1 = (function (){var statearr_29169 = state_29161;
(statearr_29169[(7)] = inst_29128);

(statearr_29169[(8)] = inst_29129);

return statearr_29169;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29170_29187 = state_29161__$1;
(statearr_29170_29187[(1)] = (6));

} else {
var statearr_29171_29188 = state_29161__$1;
(statearr_29171_29188[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (9))){
var inst_29150 = (state_29161[(2)]);
var inst_29151 = fluree.db.util.async.throw_err.call(null,inst_29150);
var inst_29152 = cljs.core.nth.call(null,inst_29151,(0),null);
var inst_29153 = cljs.core.nth.call(null,inst_29151,(1),null);
var inst_29154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29155 = [inst_29152,inst_29153];
var inst_29156 = (new cljs.core.PersistentVector(null,2,(5),inst_29154,inst_29155,null));
var _ = (function (){var statearr_29172 = state_29161;
(statearr_29172[(4)] = cljs.core.rest.call(null,(state_29161[(4)])));

return statearr_29172;
})();
var state_29161__$1 = state_29161;
var statearr_29173_29189 = state_29161__$1;
(statearr_29173_29189[(2)] = inst_29156);

(statearr_29173_29189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (5))){
var _ = (function (){var statearr_29174 = state_29161;
(statearr_29174[(4)] = cljs.core.rest.call(null,(state_29161[(4)])));

return statearr_29174;
})();
var state_29161__$1 = state_29161;
var ex29167 = (state_29161__$1[(2)]);
var statearr_29175_29190 = state_29161__$1;
(statearr_29175_29190[(5)] = ex29167);


var statearr_29176_29191 = state_29161__$1;
(statearr_29176_29191[(1)] = (4));

(statearr_29176_29191[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29162 === (8))){
var inst_29128 = (state_29161[(7)]);
var inst_29129 = (state_29161[(8)]);
var inst_29143 = (state_29161[(2)]);
var inst_29144 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29145 = cljs.core.PersistentHashMap.EMPTY;
var inst_29146 = [inst_29143,inst_29129,inst_29145];
var inst_29147 = cljs.core.PersistentHashMap.fromArrays(inst_29144,inst_29146);
var inst_29148 = fluree.db.dbfunctions.internal.query.call(null,inst_29128,inst_29147);
var state_29161__$1 = state_29161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29161__$1,(9),inst_29148);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_29177 = [null,null,null,null,null,null,null,null,null];
(statearr_29177[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_29177[(1)] = (1));

return statearr_29177;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_29161){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_29161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29178){var ex__2882__auto__ = e29178;
var statearr_29179_29192 = state_29161;
(statearr_29179_29192[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_29161[(4)]))){
var statearr_29180_29193 = state_29161;
(statearr_29180_29193[(1)] = cljs.core.first.call(null,(state_29161[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29194 = state_29161;
state_29161 = G__29194;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_29161){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_29161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29181 = f__2902__auto__.call(null);
(statearr_29181[(6)] = c__2901__auto__);

return statearr_29181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29238){
var state_val_29239 = (state_29238[(1)]);
if((state_val_29239 === (1))){
var state_29238__$1 = state_29238;
var statearr_29240_29254 = state_29238__$1;
(statearr_29240_29254[(2)] = null);

(statearr_29240_29254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (2))){
var _ = (function (){var statearr_29241 = state_29238;
(statearr_29241[(4)] = cljs.core.cons.call(null,(5),(state_29238[(4)])));

return statearr_29241;
})();
var inst_29205 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29207 = ["_user/_auth"];
var inst_29208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29209 = ["*"];
var inst_29210 = (new cljs.core.PersistentVector(null,1,(5),inst_29208,inst_29209,null));
var inst_29211 = [inst_29210];
var inst_29212 = cljs.core.PersistentHashMap.fromArrays(inst_29207,inst_29211);
var inst_29213 = [inst_29212];
var inst_29214 = (new cljs.core.PersistentVector(null,1,(5),inst_29206,inst_29213,null));
var inst_29215 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29216 = cljs.core.PersistentHashMap.EMPTY;
var inst_29217 = [inst_29214,inst_29215,inst_29216];
var inst_29218 = cljs.core.PersistentHashMap.fromArrays(inst_29205,inst_29217);
var inst_29219 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29220 = fluree.db.dbfunctions.internal.query.call(null,inst_29219,inst_29218);
var state_29238__$1 = state_29238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29238__$1,(6),inst_29220);
} else {
if((state_val_29239 === (3))){
var inst_29236 = (state_29238[(2)]);
var state_29238__$1 = state_29238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29238__$1,inst_29236);
} else {
if((state_val_29239 === (4))){
var inst_29195 = (state_29238[(2)]);
var inst_29196 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29195,"?user_id-from-auth","Context Object");
var state_29238__$1 = state_29238;
var statearr_29243_29255 = state_29238__$1;
(statearr_29243_29255[(2)] = inst_29196);

(statearr_29243_29255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (5))){
var _ = (function (){var statearr_29244 = state_29238;
(statearr_29244[(4)] = cljs.core.rest.call(null,(state_29238[(4)])));

return statearr_29244;
})();
var state_29238__$1 = state_29238;
var ex29242 = (state_29238__$1[(2)]);
var statearr_29245_29256 = state_29238__$1;
(statearr_29245_29256[(5)] = ex29242);


var statearr_29246_29257 = state_29238__$1;
(statearr_29246_29257[(1)] = (4));

(statearr_29246_29257[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (6))){
var inst_29222 = (state_29238[(2)]);
var inst_29223 = fluree.db.util.async.throw_err.call(null,inst_29222);
var inst_29224 = cljs.core.nth.call(null,inst_29223,(0),null);
var inst_29225 = cljs.core.nth.call(null,inst_29223,(1),null);
var inst_29226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29227 = ["_user/_auth","_id"];
var inst_29228 = (new cljs.core.PersistentVector(null,2,(5),inst_29226,inst_29227,null));
var inst_29229 = fluree.db.dbfunctions.internal.get_in.call(null,inst_29224,inst_29228);
var inst_29230 = cljs.core.first.call(null,inst_29229);
var inst_29231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29232 = [inst_29230,inst_29225];
var inst_29233 = (new cljs.core.PersistentVector(null,2,(5),inst_29231,inst_29232,null));
var _ = (function (){var statearr_29247 = state_29238;
(statearr_29247[(4)] = cljs.core.rest.call(null,(state_29238[(4)])));

return statearr_29247;
})();
var state_29238__$1 = state_29238;
var statearr_29248_29258 = state_29238__$1;
(statearr_29248_29258[(2)] = inst_29233);

(statearr_29248_29258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0 = (function (){
var statearr_29249 = [null,null,null,null,null,null,null];
(statearr_29249[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__);

(statearr_29249[(1)] = (1));

return statearr_29249;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1 = (function (state_29238){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_29238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29250){var ex__2882__auto__ = e29250;
var statearr_29251_29259 = state_29238;
(statearr_29251_29259[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_29238[(4)]))){
var statearr_29252_29260 = state_29238;
(statearr_29252_29260[(1)] = cljs.core.first.call(null,(state_29238[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29261 = state_29238;
state_29238 = G__29261;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__ = function(state_29238){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1.call(this,state_29238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29253 = f__2902__auto__.call(null);
(statearr_29253[(6)] = c__2901__auto__);

return statearr_29253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29278){
var state_val_29279 = (state_29278[(1)]);
if((state_val_29279 === (1))){
var state_29278__$1 = state_29278;
var statearr_29280_29294 = state_29278__$1;
(statearr_29280_29294[(2)] = null);

(statearr_29280_29294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29279 === (2))){
var _ = (function (){var statearr_29281 = state_29278;
(statearr_29281[(4)] = cljs.core.cons.call(null,(5),(state_29278[(4)])));

return statearr_29281;
})();
var inst_29268 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29269 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29270 = fluree.db.dbproto._subid.call(null,inst_29269,inst_29268);
var state_29278__$1 = state_29278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29278__$1,(6),inst_29270);
} else {
if((state_val_29279 === (3))){
var inst_29276 = (state_29278[(2)]);
var state_29278__$1 = state_29278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29278__$1,inst_29276);
} else {
if((state_val_29279 === (4))){
var inst_29262 = (state_29278[(2)]);
var state_29278__$1 = state_29278;
var statearr_29283_29295 = state_29278__$1;
(statearr_29283_29295[(2)] = inst_29262);

(statearr_29283_29295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29279 === (5))){
var _ = (function (){var statearr_29284 = state_29278;
(statearr_29284[(4)] = cljs.core.rest.call(null,(state_29278[(4)])));

return statearr_29284;
})();
var state_29278__$1 = state_29278;
var ex29282 = (state_29278__$1[(2)]);
var statearr_29285_29296 = state_29278__$1;
(statearr_29285_29296[(5)] = ex29282);


if((ex29282 instanceof Error)){
var statearr_29286_29297 = state_29278__$1;
(statearr_29286_29297[(1)] = (4));

(statearr_29286_29297[(5)] = null);

} else {
throw ex29282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29279 === (6))){
var inst_29272 = (state_29278[(2)]);
var inst_29273 = fluree.db.util.async.throw_err.call(null,inst_29272);
var _ = (function (){var statearr_29287 = state_29278;
(statearr_29287[(4)] = cljs.core.rest.call(null,(state_29278[(4)])));

return statearr_29287;
})();
var state_29278__$1 = state_29278;
var statearr_29288_29298 = state_29278__$1;
(statearr_29288_29298[(2)] = inst_29273);

(statearr_29288_29298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0 = (function (){
var statearr_29289 = [null,null,null,null,null,null,null];
(statearr_29289[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__);

(statearr_29289[(1)] = (1));

return statearr_29289;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1 = (function (state_29278){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_29278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29290){var ex__2882__auto__ = e29290;
var statearr_29291_29299 = state_29278;
(statearr_29291_29299[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_29278[(4)]))){
var statearr_29292_29300 = state_29278;
(statearr_29292_29300[(1)] = cljs.core.first.call(null,(state_29278[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29301 = state_29278;
state_29278 = G__29301;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__ = function(state_29278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1.call(this,state_29278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29293 = f__2902__auto__.call(null);
(statearr_29293[(6)] = c__2901__auto__);

return statearr_29293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29302_SHARP_){
return p1__29302_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29303_SHARP_){
return p1__29303_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29304){var e = e29304;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29305_SHARP_){
return p1__29305_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29306_SHARP_){
return p1__29306_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29307){var e = e29307;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29308){var e = e29308;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29408){
var state_val_29409 = (state_29408[(1)]);
if((state_val_29409 === (7))){
var state_29408__$1 = state_29408;
var statearr_29410_29458 = state_29408__$1;
(statearr_29410_29458[(2)] = false);

(statearr_29410_29458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (20))){
var inst_29343 = (state_29408[(7)]);
var inst_29342 = (state_29408[(8)]);
var inst_29364 = (state_29408[(2)]);
var inst_29365 = fluree.db.dbproto._p_prop.call(null,inst_29343,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29342);
var state_29408__$1 = (function (){var statearr_29411 = state_29408;
(statearr_29411[(9)] = inst_29364);

return statearr_29411;
})();
if(cljs.core.truth_(inst_29365)){
var statearr_29412_29459 = state_29408__$1;
(statearr_29412_29459[(1)] = (21));

} else {
var statearr_29413_29460 = state_29408__$1;
(statearr_29413_29460[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (27))){
var inst_29403 = (state_29408[(2)]);
var _ = (function (){var statearr_29414 = state_29408;
(statearr_29414[(4)] = cljs.core.rest.call(null,(state_29408[(4)])));

return statearr_29414;
})();
var state_29408__$1 = state_29408;
var statearr_29415_29461 = state_29408__$1;
(statearr_29415_29461[(2)] = inst_29403);

(statearr_29415_29461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (1))){
var state_29408__$1 = state_29408;
var statearr_29416_29462 = state_29408__$1;
(statearr_29416_29462[(2)] = null);

(statearr_29416_29462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (24))){
var inst_29392 = (state_29408[(10)]);
var inst_29388 = (state_29408[(2)]);
var inst_29389 = fluree.db.util.async.throw_err.call(null,inst_29388);
var inst_29390 = cljs.core.nth.call(null,inst_29389,(0),null);
var inst_29391 = cljs.core.nth.call(null,inst_29389,(1),null);
var inst_29392__$1 = cljs.core.first.call(null,inst_29390);
var inst_29393 = cljs.core._EQ_.call(null,inst_29392__$1,compare_val);
var state_29408__$1 = (function (){var statearr_29417 = state_29408;
(statearr_29417[(11)] = inst_29391);

(statearr_29417[(10)] = inst_29392__$1);

return statearr_29417;
})();
if(inst_29393){
var statearr_29418_29463 = state_29408__$1;
(statearr_29418_29463[(1)] = (25));

} else {
var statearr_29419_29464 = state_29408__$1;
(statearr_29419_29464[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (4))){
var inst_29309 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
var statearr_29420_29465 = state_29408__$1;
(statearr_29420_29465[(2)] = inst_29309);

(statearr_29420_29465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (15))){
var state_29408__$1 = state_29408;
var statearr_29421_29466 = state_29408__$1;
(statearr_29421_29466[(2)] = null);

(statearr_29421_29466[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (21))){
var inst_29344 = (state_29408[(12)]);
var inst_29367 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29344);
var inst_29368 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29369 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29370 = cljs.core.PersistentHashMap.fromArrays(inst_29368,inst_29369);
var inst_29371 = cljs.core.ex_info.call(null,inst_29367,inst_29370);
var inst_29372 = (function(){throw inst_29371})();
var state_29408__$1 = state_29408;
var statearr_29422_29467 = state_29408__$1;
(statearr_29422_29467[(2)] = inst_29372);

(statearr_29422_29467[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (13))){
var inst_29319 = (state_29408[(13)]);
var state_29408__$1 = state_29408;
var statearr_29423_29468 = state_29408__$1;
(statearr_29423_29468[(2)] = inst_29319);

(statearr_29423_29468[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (22))){
var state_29408__$1 = state_29408;
var statearr_29424_29469 = state_29408__$1;
(statearr_29424_29469[(2)] = null);

(statearr_29424_29469[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (6))){
var inst_29319 = (state_29408[(13)]);
var inst_29324 = inst_29319.cljs$lang$protocol_mask$partition0$;
var inst_29325 = (inst_29324 & (64));
var inst_29326 = inst_29319.cljs$core$ISeq$;
var inst_29327 = (cljs.core.PROTOCOL_SENTINEL === inst_29326);
var inst_29328 = ((inst_29325) || (inst_29327));
var state_29408__$1 = state_29408;
if(cljs.core.truth_(inst_29328)){
var statearr_29425_29470 = state_29408__$1;
(statearr_29425_29470[(1)] = (9));

} else {
var statearr_29426_29471 = state_29408__$1;
(statearr_29426_29471[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (25))){
var state_29408__$1 = state_29408;
var statearr_29427_29472 = state_29408__$1;
(statearr_29427_29472[(2)] = new_val);

(statearr_29427_29472[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (17))){
var inst_29344 = (state_29408[(12)]);
var inst_29354 = (state_29408[(2)]);
var state_29408__$1 = (function (){var statearr_29428 = state_29408;
(statearr_29428[(14)] = inst_29354);

return statearr_29428;
})();
if(cljs.core.truth_(inst_29344)){
var statearr_29429_29473 = state_29408__$1;
(statearr_29429_29473[(1)] = (18));

} else {
var statearr_29430_29474 = state_29408__$1;
(statearr_29430_29474[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (3))){
var inst_29406 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29408__$1,inst_29406);
} else {
if((state_val_29409 === (12))){
var inst_29319 = (state_29408[(13)]);
var inst_29337 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29319);
var state_29408__$1 = state_29408;
var statearr_29431_29475 = state_29408__$1;
(statearr_29431_29475[(2)] = inst_29337);

(statearr_29431_29475[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (2))){
var inst_29319 = (state_29408[(13)]);
var _ = (function (){var statearr_29432 = state_29408;
(statearr_29432[(4)] = cljs.core.cons.call(null,(5),(state_29408[(4)])));

return statearr_29432;
})();
var inst_29319__$1 = _QMARK_ctx;
var inst_29321 = (inst_29319__$1 == null);
var inst_29322 = cljs.core.not.call(null,inst_29321);
var state_29408__$1 = (function (){var statearr_29433 = state_29408;
(statearr_29433[(13)] = inst_29319__$1);

return statearr_29433;
})();
if(inst_29322){
var statearr_29434_29476 = state_29408__$1;
(statearr_29434_29476[(1)] = (6));

} else {
var statearr_29435_29477 = state_29408__$1;
(statearr_29435_29477[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (23))){
var inst_29341 = (state_29408[(15)]);
var inst_29344 = (state_29408[(12)]);
var inst_29343 = (state_29408[(7)]);
var inst_29375 = (state_29408[(2)]);
var inst_29376 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29379 = [inst_29341,inst_29344,"?current-val"];
var inst_29380 = (new cljs.core.PersistentVector(null,3,(5),inst_29378,inst_29379,null));
var inst_29381 = [inst_29380];
var inst_29382 = (new cljs.core.PersistentVector(null,1,(5),inst_29377,inst_29381,null));
var inst_29383 = cljs.core.PersistentHashMap.EMPTY;
var inst_29384 = ["?current-val",inst_29382,inst_29383];
var inst_29385 = cljs.core.PersistentHashMap.fromArrays(inst_29376,inst_29384);
var inst_29386 = fluree.db.dbfunctions.internal.query.call(null,inst_29343,inst_29385);
var state_29408__$1 = (function (){var statearr_29436 = state_29408;
(statearr_29436[(16)] = inst_29375);

return statearr_29436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29408__$1,(24),inst_29386);
} else {
if((state_val_29409 === (19))){
var inst_29357 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29358 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29359 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29360 = cljs.core.PersistentHashMap.fromArrays(inst_29358,inst_29359);
var inst_29361 = cljs.core.ex_info.call(null,inst_29357,inst_29360);
var inst_29362 = (function(){throw inst_29361})();
var state_29408__$1 = state_29408;
var statearr_29437_29478 = state_29408__$1;
(statearr_29437_29478[(2)] = inst_29362);

(statearr_29437_29478[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (11))){
var inst_29332 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
var statearr_29439_29479 = state_29408__$1;
(statearr_29439_29479[(2)] = inst_29332);

(statearr_29439_29479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (9))){
var state_29408__$1 = state_29408;
var statearr_29440_29480 = state_29408__$1;
(statearr_29440_29480[(2)] = true);

(statearr_29440_29480[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (5))){
var _ = (function (){var statearr_29441 = state_29408;
(statearr_29441[(4)] = cljs.core.rest.call(null,(state_29408[(4)])));

return statearr_29441;
})();
var state_29408__$1 = state_29408;
var ex29438 = (state_29408__$1[(2)]);
var statearr_29442_29481 = state_29408__$1;
(statearr_29442_29481[(5)] = ex29438);


if((ex29438 instanceof Error)){
var statearr_29443_29482 = state_29408__$1;
(statearr_29443_29482[(1)] = (4));

(statearr_29443_29482[(5)] = null);

} else {
throw ex29438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (14))){
var inst_29341 = (state_29408[(15)]);
var inst_29343 = (state_29408[(7)]);
var inst_29342 = (state_29408[(8)]);
var inst_29340 = (state_29408[(2)]);
var inst_29341__$1 = cljs.core.get.call(null,inst_29340,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29342__$1 = cljs.core.get.call(null,inst_29340,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29343__$1 = cljs.core.get.call(null,inst_29340,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29344 = fluree.db.dbproto._p_prop.call(null,inst_29343__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29342__$1);
var state_29408__$1 = (function (){var statearr_29444 = state_29408;
(statearr_29444[(15)] = inst_29341__$1);

(statearr_29444[(12)] = inst_29344);

(statearr_29444[(7)] = inst_29343__$1);

(statearr_29444[(8)] = inst_29342__$1);

return statearr_29444;
})();
if(cljs.core.truth_(inst_29341__$1)){
var statearr_29445_29483 = state_29408__$1;
(statearr_29445_29483[(1)] = (15));

} else {
var statearr_29446_29484 = state_29408__$1;
(statearr_29446_29484[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (26))){
var inst_29392 = (state_29408[(10)]);
var inst_29396 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29392)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29397 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29398 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29399 = cljs.core.PersistentHashMap.fromArrays(inst_29397,inst_29398);
var inst_29400 = cljs.core.ex_info.call(null,inst_29396,inst_29399);
var inst_29401 = (function(){throw inst_29400})();
var state_29408__$1 = state_29408;
var statearr_29447_29485 = state_29408__$1;
(statearr_29447_29485[(2)] = inst_29401);

(statearr_29447_29485[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (16))){
var inst_29347 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29348 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29349 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29350 = cljs.core.PersistentHashMap.fromArrays(inst_29348,inst_29349);
var inst_29351 = cljs.core.ex_info.call(null,inst_29347,inst_29350);
var inst_29352 = (function(){throw inst_29351})();
var state_29408__$1 = state_29408;
var statearr_29448_29486 = state_29408__$1;
(statearr_29448_29486[(2)] = inst_29352);

(statearr_29448_29486[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (10))){
var state_29408__$1 = state_29408;
var statearr_29449_29487 = state_29408__$1;
(statearr_29449_29487[(2)] = false);

(statearr_29449_29487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (18))){
var state_29408__$1 = state_29408;
var statearr_29450_29488 = state_29408__$1;
(statearr_29450_29488[(2)] = null);

(statearr_29450_29488[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29409 === (8))){
var inst_29335 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
if(cljs.core.truth_(inst_29335)){
var statearr_29451_29489 = state_29408__$1;
(statearr_29451_29489[(1)] = (12));

} else {
var statearr_29452_29490 = state_29408__$1;
(statearr_29452_29490[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0 = (function (){
var statearr_29453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29453[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__);

(statearr_29453[(1)] = (1));

return statearr_29453;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1 = (function (state_29408){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_29408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29454){var ex__2882__auto__ = e29454;
var statearr_29455_29491 = state_29408;
(statearr_29455_29491[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_29408[(4)]))){
var statearr_29456_29492 = state_29408;
(statearr_29456_29492[(1)] = cljs.core.first.call(null,(state_29408[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29493 = state_29408;
state_29408 = G__29493;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__ = function(state_29408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1.call(this,state_29408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29457 = f__2902__auto__.call(null);
(statearr_29457[(6)] = c__2901__auto__);

return statearr_29457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
