// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62693_62862 = cljs.core.seq.call(null,servers);
var chunk__62694_62863 = null;
var count__62695_62864 = (0);
var i__62696_62865 = (0);
while(true){
if((i__62696_62865 < count__62695_62864)){
var server_62866 = cljs.core._nth.call(null,chunk__62694_62863,i__62696_62865);
var healthcheck_uri_62867 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62866),"/fdb/health"].join('');
var resp_chan_62868 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62867,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2901__auto___62869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866){
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = ((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866){
return (function (state_62757){
var state_val_62758 = (state_62757[(1)]);
if((state_val_62758 === (1))){
var state_62757__$1 = state_62757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62757__$1,(2),resp_chan_62868);
} else {
if((state_val_62758 === (2))){
var inst_62746 = (state_62757[(7)]);
var inst_62746__$1 = (state_62757[(2)]);
var inst_62747 = fluree.db.util.core.exception_QMARK_.call(null,inst_62746__$1);
var state_62757__$1 = (function (){var statearr_62759 = state_62757;
(statearr_62759[(7)] = inst_62746__$1);

return statearr_62759;
})();
if(inst_62747){
var statearr_62760_62870 = state_62757__$1;
(statearr_62760_62870[(1)] = (3));

} else {
var statearr_62761_62871 = state_62757__$1;
(statearr_62761_62871[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62758 === (3))){
var inst_62746 = (state_62757[(7)]);
var inst_62749 = cljs.core.ex_message.call(null,inst_62746);
var inst_62750 = cljs.core.ex_data.call(null,inst_62746);
var inst_62751 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62749,inst_62750);
var state_62757__$1 = state_62757;
var statearr_62762_62872 = state_62757__$1;
(statearr_62762_62872[(2)] = inst_62751);

(statearr_62762_62872[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62758 === (4))){
var inst_62753 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62866);
var state_62757__$1 = state_62757;
var statearr_62763_62873 = state_62757__$1;
(statearr_62763_62873[(2)] = inst_62753);

(statearr_62763_62873[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62758 === (5))){
var inst_62755 = (state_62757[(2)]);
var state_62757__$1 = state_62757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62757__$1,inst_62755);
} else {
return null;
}
}
}
}
}
});})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866))
;
return ((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,switch__2878__auto__,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_62764 = [null,null,null,null,null,null,null,null];
(statearr_62764[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_62764[(1)] = (1));

return statearr_62764;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_62757){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62765){var ex__2882__auto__ = e62765;
var statearr_62766_62874 = state_62757;
(statearr_62766_62874[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62757[(4)]))){
var statearr_62767_62875 = state_62757;
(statearr_62767_62875[(1)] = cljs.core.first.call(null,(state_62757[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62876 = state_62757;
state_62757 = G__62876;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_62757){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_62757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
;})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,switch__2878__auto__,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866))
})();
var state__2903__auto__ = (function (){var statearr_62768 = f__2902__auto__.call(null);
(statearr_62768[(6)] = c__2901__auto___62869);

return statearr_62768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62869,healthcheck_uri_62867,resp_chan_62868,server_62866))
);



var G__62877 = seq__62693_62862;
var G__62878 = chunk__62694_62863;
var G__62879 = count__62695_62864;
var G__62880 = (i__62696_62865 + (1));
seq__62693_62862 = G__62877;
chunk__62694_62863 = G__62878;
count__62695_62864 = G__62879;
i__62696_62865 = G__62880;
continue;
} else {
var temp__5735__auto___62881 = cljs.core.seq.call(null,seq__62693_62862);
if(temp__5735__auto___62881){
var seq__62693_62882__$1 = temp__5735__auto___62881;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62693_62882__$1)){
var c__4556__auto___62883 = cljs.core.chunk_first.call(null,seq__62693_62882__$1);
var G__62884 = cljs.core.chunk_rest.call(null,seq__62693_62882__$1);
var G__62885 = c__4556__auto___62883;
var G__62886 = cljs.core.count.call(null,c__4556__auto___62883);
var G__62887 = (0);
seq__62693_62862 = G__62884;
chunk__62694_62863 = G__62885;
count__62695_62864 = G__62886;
i__62696_62865 = G__62887;
continue;
} else {
var server_62888 = cljs.core.first.call(null,seq__62693_62882__$1);
var healthcheck_uri_62889 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62888),"/fdb/health"].join('');
var resp_chan_62890 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62889,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2901__auto___62891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881){
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = ((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881){
return (function (state_62781){
var state_val_62782 = (state_62781[(1)]);
if((state_val_62782 === (1))){
var state_62781__$1 = state_62781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62781__$1,(2),resp_chan_62890);
} else {
if((state_val_62782 === (2))){
var inst_62770 = (state_62781[(7)]);
var inst_62770__$1 = (state_62781[(2)]);
var inst_62771 = fluree.db.util.core.exception_QMARK_.call(null,inst_62770__$1);
var state_62781__$1 = (function (){var statearr_62783 = state_62781;
(statearr_62783[(7)] = inst_62770__$1);

return statearr_62783;
})();
if(inst_62771){
var statearr_62784_62892 = state_62781__$1;
(statearr_62784_62892[(1)] = (3));

} else {
var statearr_62785_62893 = state_62781__$1;
(statearr_62785_62893[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (3))){
var inst_62770 = (state_62781[(7)]);
var inst_62773 = cljs.core.ex_message.call(null,inst_62770);
var inst_62774 = cljs.core.ex_data.call(null,inst_62770);
var inst_62775 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62773,inst_62774);
var state_62781__$1 = state_62781;
var statearr_62786_62894 = state_62781__$1;
(statearr_62786_62894[(2)] = inst_62775);

(statearr_62786_62894[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (4))){
var inst_62777 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62888);
var state_62781__$1 = state_62781;
var statearr_62787_62895 = state_62781__$1;
(statearr_62787_62895[(2)] = inst_62777);

(statearr_62787_62895[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (5))){
var inst_62779 = (state_62781[(2)]);
var state_62781__$1 = state_62781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62781__$1,inst_62779);
} else {
return null;
}
}
}
}
}
});})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881))
;
return ((function (seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,switch__2878__auto__,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_62788 = [null,null,null,null,null,null,null,null];
(statearr_62788[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_62788[(1)] = (1));

return statearr_62788;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_62781){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62789){var ex__2882__auto__ = e62789;
var statearr_62790_62896 = state_62781;
(statearr_62790_62896[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62781[(4)]))){
var statearr_62791_62897 = state_62781;
(statearr_62791_62897[(1)] = cljs.core.first.call(null,(state_62781[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62898 = state_62781;
state_62781 = G__62898;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_62781){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_62781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
;})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,switch__2878__auto__,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881))
})();
var state__2903__auto__ = (function (){var statearr_62792 = f__2902__auto__.call(null);
(statearr_62792[(6)] = c__2901__auto___62891);

return statearr_62792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});})(seq__62693_62862,chunk__62694_62863,count__62695_62864,i__62696_62865,c__2901__auto___62891,healthcheck_uri_62889,resp_chan_62890,server_62888,seq__62693_62882__$1,temp__5735__auto___62881))
);



var G__62899 = cljs.core.next.call(null,seq__62693_62882__$1);
var G__62900 = null;
var G__62901 = (0);
var G__62902 = (0);
seq__62693_62862 = G__62899;
chunk__62694_62863 = G__62900;
count__62695_62864 = G__62901;
i__62696_62865 = G__62902;
continue;
}
} else {
}
}
break;
}

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62836){
var state_val_62837 = (state_62836[(1)]);
if((state_val_62837 === (7))){
var inst_62808 = (state_62836[(7)]);
var inst_62815 = cljs.core._EQ_.call(null,inst_62808,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62836__$1 = state_62836;
if(inst_62815){
var statearr_62838_62903 = state_62836__$1;
(statearr_62838_62903[(1)] = (9));

} else {
var statearr_62839_62904 = state_62836__$1;
(statearr_62839_62904[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (1))){
var inst_62801 = (state_62836[(8)]);
var inst_62800 = (state_62836[(9)]);
var inst_62800__$1 = promise_chan;
var inst_62801__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_62802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62803 = [inst_62800__$1,inst_62801__$1];
var inst_62804 = (new cljs.core.PersistentVector(null,2,(5),inst_62802,inst_62803,null));
var state_62836__$1 = (function (){var statearr_62840 = state_62836;
(statearr_62840[(8)] = inst_62801__$1);

(statearr_62840[(9)] = inst_62800__$1);

return statearr_62840;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62836__$1,(2),inst_62804);
} else {
if((state_val_62837 === (4))){
var inst_62801 = (state_62836[(8)]);
var inst_62808 = (state_62836[(7)]);
var inst_62812 = cljs.core._EQ_.call(null,inst_62808,inst_62801);
var state_62836__$1 = state_62836;
if(inst_62812){
var statearr_62841_62905 = state_62836__$1;
(statearr_62841_62905[(1)] = (6));

} else {
var statearr_62842_62906 = state_62836__$1;
(statearr_62842_62906[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (13))){
var state_62836__$1 = state_62836;
var statearr_62843_62907 = state_62836__$1;
(statearr_62843_62907[(2)] = null);

(statearr_62843_62907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (6))){
var state_62836__$1 = state_62836;
var statearr_62844_62908 = state_62836__$1;
(statearr_62844_62908[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62844_62908[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (3))){
var state_62836__$1 = state_62836;
var statearr_62845_62909 = state_62836__$1;
(statearr_62845_62909[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62845_62909[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (12))){
var inst_62826 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_62827 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62828 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62829 = cljs.core.PersistentHashMap.fromArrays(inst_62827,inst_62828);
var inst_62830 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_62829);
var inst_62831 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_62830);
var state_62836__$1 = (function (){var statearr_62846 = state_62836;
(statearr_62846[(10)] = inst_62826);

return statearr_62846;
})();
var statearr_62847_62910 = state_62836__$1;
(statearr_62847_62910[(2)] = inst_62831);

(statearr_62847_62910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (2))){
var inst_62800 = (state_62836[(9)]);
var inst_62808 = (state_62836[(7)]);
var inst_62806 = (state_62836[(2)]);
var inst_62807 = cljs.core.nth.call(null,inst_62806,(0),null);
var inst_62808__$1 = cljs.core.nth.call(null,inst_62806,(1),null);
var inst_62809 = cljs.core._EQ_.call(null,inst_62808__$1,inst_62800);
var state_62836__$1 = (function (){var statearr_62848 = state_62836;
(statearr_62848[(7)] = inst_62808__$1);

(statearr_62848[(11)] = inst_62807);

return statearr_62848;
})();
if(inst_62809){
var statearr_62849_62911 = state_62836__$1;
(statearr_62849_62911[(1)] = (3));

} else {
var statearr_62850_62912 = state_62836__$1;
(statearr_62850_62912[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (11))){
var inst_62819 = (state_62836[(2)]);
var state_62836__$1 = state_62836;
var statearr_62851_62913 = state_62836__$1;
(statearr_62851_62913[(2)] = inst_62819);

(statearr_62851_62913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (9))){
var inst_62807 = (state_62836[(11)]);
var state_62836__$1 = state_62836;
var statearr_62852_62914 = state_62836__$1;
(statearr_62852_62914[(2)] = inst_62807);

(statearr_62852_62914[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (5))){
var inst_62823 = (state_62836[(2)]);
var inst_62824 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62823);
var state_62836__$1 = state_62836;
if(inst_62824){
var statearr_62853_62915 = state_62836__$1;
(statearr_62853_62915[(1)] = (12));

} else {
var statearr_62854_62916 = state_62836__$1;
(statearr_62854_62916[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (14))){
var inst_62834 = (state_62836[(2)]);
var state_62836__$1 = state_62836;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62836__$1,inst_62834);
} else {
if((state_val_62837 === (10))){
var state_62836__$1 = state_62836;
var statearr_62855_62917 = state_62836__$1;
(statearr_62855_62917[(2)] = null);

(statearr_62855_62917[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62837 === (8))){
var inst_62821 = (state_62836[(2)]);
var state_62836__$1 = state_62836;
var statearr_62856_62918 = state_62836__$1;
(statearr_62856_62918[(2)] = inst_62821);

(statearr_62856_62918[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_62857 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62857[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_62857[(1)] = (1));

return statearr_62857;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_62836){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62858){var ex__2882__auto__ = e62858;
var statearr_62859_62919 = state_62836;
(statearr_62859_62919[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62836[(4)]))){
var statearr_62860_62920 = state_62836;
(statearr_62860_62920[(1)] = cljs.core.first.call(null,(state_62836[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62921 = state_62836;
state_62836 = G__62921;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_62836){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_62836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62861 = f__2902__auto__.call(null);
(statearr_62861[(6)] = c__2901__auto__);

return statearr_62861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62965){
var state_val_62966 = (state_62965[(1)]);
if((state_val_62966 === (7))){
var state_62965__$1 = state_62965;
var statearr_62967_62993 = state_62965__$1;
(statearr_62967_62993[(2)] = null);

(statearr_62967_62993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (1))){
var state_62965__$1 = state_62965;
var statearr_62968_62994 = state_62965__$1;
(statearr_62968_62994[(2)] = null);

(statearr_62968_62994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (4))){
var inst_62922 = (state_62965[(2)]);
var state_62965__$1 = state_62965;
var statearr_62969_62995 = state_62965__$1;
(statearr_62969_62995[(2)] = inst_62922);

(statearr_62969_62995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (6))){
var inst_62944 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_62965__$1 = state_62965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62965__$1,(9),inst_62944);
} else {
if((state_val_62966 === (3))){
var inst_62963 = (state_62965[(2)]);
var state_62965__$1 = state_62965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62965__$1,inst_62963);
} else {
if((state_val_62966 === (12))){
var inst_62957 = (state_62965[(2)]);
var state_62965__$1 = state_62965;
var statearr_62970_62996 = state_62965__$1;
(statearr_62970_62996[(2)] = inst_62957);

(statearr_62970_62996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (2))){
var inst_62928 = (state_62965[(7)]);
var inst_62938 = (state_62965[(8)]);
var inst_62933 = (state_62965[(9)]);
var _ = (function (){var statearr_62971 = state_62965;
(statearr_62971[(4)] = cljs.core.cons.call(null,(5),(state_62965[(4)])));

return statearr_62971;
})();
var inst_62928__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_62929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62930 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62931 = (new cljs.core.PersistentVector(null,2,(5),inst_62929,inst_62930,null));
var inst_62932 = (function (){var lock_id = inst_62928__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_62933__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62931,inst_62932);
var inst_62934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62935 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62936 = (new cljs.core.PersistentVector(null,3,(5),inst_62934,inst_62935,null));
var inst_62937 = cljs.core.get_in.call(null,inst_62933__$1,inst_62936);
var inst_62938__$1 = cljs.core._EQ_.call(null,inst_62928__$1,inst_62937);
var inst_62939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62940 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62941 = (new cljs.core.PersistentVector(null,3,(5),inst_62939,inst_62940,null));
var inst_62942 = cljs.core.get_in.call(null,inst_62933__$1,inst_62941);
var state_62965__$1 = (function (){var statearr_62972 = state_62965;
(statearr_62972[(7)] = inst_62928__$1);

(statearr_62972[(8)] = inst_62938__$1);

(statearr_62972[(10)] = inst_62942);

(statearr_62972[(9)] = inst_62933__$1);

return statearr_62972;
})();
if(inst_62938__$1){
var statearr_62973_62997 = state_62965__$1;
(statearr_62973_62997[(1)] = (6));

} else {
var statearr_62974_62998 = state_62965__$1;
(statearr_62974_62998[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (11))){
var inst_62948 = (state_62965[(11)]);
var inst_62942 = (state_62965[(10)]);
var inst_62949 = (state_62965[(12)]);
var inst_62955 = fluree.db.util.xhttp.try_socket.call(null,inst_62948,sub_chan,pub_chan,inst_62942,(60000),inst_62949);
var state_62965__$1 = state_62965;
var statearr_62976_62999 = state_62965__$1;
(statearr_62976_62999[(2)] = inst_62955);

(statearr_62976_62999[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (9))){
var inst_62948 = (state_62965[(11)]);
var inst_62946 = (state_62965[(13)]);
var inst_62928 = (state_62965[(7)]);
var inst_62938 = (state_62965[(8)]);
var inst_62942 = (state_62965[(10)]);
var inst_62933 = (state_62965[(9)]);
var inst_62946__$1 = (state_62965[(2)]);
var inst_62947 = clojure.string.replace.call(null,inst_62946__$1,"http","ws");
var inst_62948__$1 = [inst_62947,"/fdb/ws"].join('');
var inst_62949 = (function (){var lock_id = inst_62928;
var state = inst_62933;
var have_lock_QMARK_ = inst_62938;
var resp_chan = inst_62942;
var healthy_server = inst_62946__$1;
var ws_url = inst_62948__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_62950 = fluree.db.util.core.exception_QMARK_.call(null,inst_62946__$1);
var state_62965__$1 = (function (){var statearr_62977 = state_62965;
(statearr_62977[(11)] = inst_62948__$1);

(statearr_62977[(13)] = inst_62946__$1);

(statearr_62977[(12)] = inst_62949);

return statearr_62977;
})();
if(inst_62950){
var statearr_62978_63000 = state_62965__$1;
(statearr_62978_63000[(1)] = (10));

} else {
var statearr_62979_63001 = state_62965__$1;
(statearr_62979_63001[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (5))){
var _ = (function (){var statearr_62980 = state_62965;
(statearr_62980[(4)] = cljs.core.rest.call(null,(state_62965[(4)])));

return statearr_62980;
})();
var state_62965__$1 = state_62965;
var ex62975 = (state_62965__$1[(2)]);
var statearr_62981_63002 = state_62965__$1;
(statearr_62981_63002[(5)] = ex62975);


if((ex62975 instanceof Error)){
var statearr_62982_63003 = state_62965__$1;
(statearr_62982_63003[(1)] = (4));

(statearr_62982_63003[(5)] = null);

} else {
throw ex62975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (10))){
var inst_62946 = (state_62965[(13)]);
var inst_62942 = (state_62965[(10)]);
var inst_62952 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_62953 = cljs.core.async.put_BANG_.call(null,inst_62942,inst_62946);
var state_62965__$1 = (function (){var statearr_62983 = state_62965;
(statearr_62983[(14)] = inst_62952);

return statearr_62983;
})();
var statearr_62984_63004 = state_62965__$1;
(statearr_62984_63004[(2)] = inst_62953);

(statearr_62984_63004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62966 === (8))){
var inst_62942 = (state_62965[(10)]);
var inst_62960 = (state_62965[(2)]);
var _ = (function (){var statearr_62985 = state_62965;
(statearr_62985[(4)] = cljs.core.rest.call(null,(state_62965[(4)])));

return statearr_62985;
})();
var state_62965__$1 = (function (){var statearr_62986 = state_62965;
(statearr_62986[(15)] = inst_62960);

return statearr_62986;
})();
var statearr_62987_63005 = state_62965__$1;
(statearr_62987_63005[(2)] = inst_62942);

(statearr_62987_63005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2879__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_62988 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62988[(0)] = fluree$db$connection$establish_socket_$_state_machine__2879__auto__);

(statearr_62988[(1)] = (1));

return statearr_62988;
});
var fluree$db$connection$establish_socket_$_state_machine__2879__auto____1 = (function (state_62965){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_62965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62989){var ex__2882__auto__ = e62989;
var statearr_62990_63006 = state_62965;
(statearr_62990_63006[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_62965[(4)]))){
var statearr_62991_63007 = state_62965;
(statearr_62991_63007[(1)] = cljs.core.first.call(null,(state_62965[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63008 = state_62965;
state_62965 = G__63008;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2879__auto__ = function(state_62965){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2879__auto____1.call(this,state_62965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2879__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2879__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62992 = f__2902__auto__.call(null);
(statearr_62992[(6)] = c__2901__auto__);

return statearr_62992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k63010,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__63014 = k63010;
var G__63014__$1 = (((G__63014 instanceof cljs.core.Keyword))?G__63014.fqn:null);
switch (G__63014__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k63010,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__63015){
var vec__63016 = p__63015;
var k__4403__auto__ = cljs.core.nth.call(null,vec__63016,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__63016,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__63009){
var self__ = this;
var G__63009__$1 = this;
return (new cljs.core.RecordIter((0),G__63009__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this63011,other63012){
var self__ = this;
var this63011__$1 = this;
return (((!((other63012 == null)))) && ((this63011__$1.constructor === other63012.constructor)) && (cljs.core._EQ_.call(null,this63011__$1.id,other63012.id)) && (cljs.core._EQ_.call(null,this63011__$1.servers,other63012.servers)) && (cljs.core._EQ_.call(null,this63011__$1.state,other63012.state)) && (cljs.core._EQ_.call(null,this63011__$1.req_chan,other63012.req_chan)) && (cljs.core._EQ_.call(null,this63011__$1.sub_chan,other63012.sub_chan)) && (cljs.core._EQ_.call(null,this63011__$1.pub_chan,other63012.pub_chan)) && (cljs.core._EQ_.call(null,this63011__$1.storage_read,other63012.storage_read)) && (cljs.core._EQ_.call(null,this63011__$1.storage_write,other63012.storage_write)) && (cljs.core._EQ_.call(null,this63011__$1.object_cache,other63012.object_cache)) && (cljs.core._EQ_.call(null,this63011__$1.parallelism,other63012.parallelism)) && (cljs.core._EQ_.call(null,this63011__$1.serializer,other63012.serializer)) && (cljs.core._EQ_.call(null,this63011__$1.default_network,other63012.default_network)) && (cljs.core._EQ_.call(null,this63011__$1.transactor_QMARK_,other63012.transactor_QMARK_)) && (cljs.core._EQ_.call(null,this63011__$1.publish,other63012.publish)) && (cljs.core._EQ_.call(null,this63011__$1.transact_handler,other63012.transact_handler)) && (cljs.core._EQ_.call(null,this63011__$1.tx_private_key,other63012.tx_private_key)) && (cljs.core._EQ_.call(null,this63011__$1.tx_key_id,other63012.tx_key_id)) && (cljs.core._EQ_.call(null,this63011__$1.meta,other63012.meta)) && (cljs.core._EQ_.call(null,this63011__$1.add_listener,other63012.add_listener)) && (cljs.core._EQ_.call(null,this63011__$1.remove_listener,other63012.remove_listener)) && (cljs.core._EQ_.call(null,this63011__$1.close,other63012.close)) && (cljs.core._EQ_.call(null,this63011__$1.__extmap,other63012.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__63009){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__63019 = cljs.core.keyword_identical_QMARK_;
var expr__63020 = k__4388__auto__;
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__63020))){
return (new fluree.db.connection.Connection(G__63009,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,G__63009,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__63009,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__63009,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__63009,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__63009,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__63009,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__63009,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__63009,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__63009,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__63009,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__63009,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__63009,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__63009,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__63009,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__63009,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__63009,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__63009,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__63009,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__63009,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__63019.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__63020))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__63009,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__63009),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__63009){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__63009,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__63013){
var extmap__4419__auto__ = (function (){var G__63022 = cljs.core.dissoc.call(null,G__63013,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__63013)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__63022);
} else {
return G__63022;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__63013),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__63013),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__63027 = servers_STAR_;
var vec__63028 = G__63027;
var seq__63029 = cljs.core.seq.call(null,vec__63028);
var first__63030 = cljs.core.first.call(null,seq__63029);
var seq__63029__$1 = cljs.core.next.call(null,seq__63029);
var server = first__63030;
var r = seq__63029__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__63027__$1 = G__63027;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__63034 = G__63027__$1;
var seq__63035 = cljs.core.seq.call(null,vec__63034);
var first__63036 = cljs.core.first.call(null,seq__63035);
var seq__63035__$1 = cljs.core.next.call(null,seq__63035);
var server__$1 = first__63036;
var r__$1 = seq__63035__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__63037 = r__$1;
var G__63038 = is_https_QMARK_;
var G__63039 = result_STAR_;
G__63027__$1 = G__63037;
https_QMARK___$1 = G__63038;
result__$1 = G__63039;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__63040 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__63040 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__63040);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63069){
var state_val_63070 = (state_63069[(1)]);
if((state_val_63070 === (7))){
var inst_63055 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63056 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63057 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63058 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63059 = fluree.db.connection.establish_socket.call(null,inst_63055,inst_63056,inst_63057,inst_63058);
var state_63069__$1 = state_63069;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63069__$1,(9),inst_63059);
} else {
if((state_val_63070 === (1))){
var state_63069__$1 = state_63069;
var statearr_63071_63090 = state_63069__$1;
(statearr_63071_63090[(2)] = null);

(statearr_63071_63090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (4))){
var inst_63041 = (state_63069[(2)]);
var state_63069__$1 = state_63069;
var statearr_63072_63091 = state_63069__$1;
(statearr_63072_63091[(2)] = inst_63041);

(statearr_63072_63091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (6))){
var inst_63052 = (state_63069[(7)]);
var state_63069__$1 = state_63069;
var statearr_63073_63092 = state_63069__$1;
(statearr_63073_63092[(2)] = inst_63052);

(statearr_63073_63092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (3))){
var inst_63067 = (state_63069[(2)]);
var state_63069__$1 = state_63069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63069__$1,inst_63067);
} else {
if((state_val_63070 === (2))){
var inst_63052 = (state_63069[(7)]);
var _ = (function (){var statearr_63075 = state_63069;
(statearr_63075[(4)] = cljs.core.cons.call(null,(5),(state_63069[(4)])));

return statearr_63075;
})();
var inst_63047 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_63048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63049 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63050 = [inst_63049,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_63051 = (new cljs.core.PersistentVector(null,3,(5),inst_63048,inst_63050,null));
var inst_63052__$1 = cljs.core.get_in.call(null,inst_63047,inst_63051);
var state_63069__$1 = (function (){var statearr_63076 = state_63069;
(statearr_63076[(7)] = inst_63052__$1);

return statearr_63076;
})();
if(cljs.core.truth_(inst_63052__$1)){
var statearr_63077_63093 = state_63069__$1;
(statearr_63077_63093[(1)] = (6));

} else {
var statearr_63078_63094 = state_63069__$1;
(statearr_63078_63094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (9))){
var inst_63061 = (state_63069[(2)]);
var inst_63062 = fluree.db.util.async.throw_err.call(null,inst_63061);
var state_63069__$1 = state_63069;
var statearr_63079_63095 = state_63069__$1;
(statearr_63079_63095[(2)] = inst_63062);

(statearr_63079_63095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (5))){
var _ = (function (){var statearr_63080 = state_63069;
(statearr_63080[(4)] = cljs.core.rest.call(null,(state_63069[(4)])));

return statearr_63080;
})();
var state_63069__$1 = state_63069;
var ex63074 = (state_63069__$1[(2)]);
var statearr_63081_63096 = state_63069__$1;
(statearr_63081_63096[(5)] = ex63074);


if((ex63074 instanceof Error)){
var statearr_63082_63097 = state_63069__$1;
(statearr_63082_63097[(1)] = (4));

(statearr_63082_63097[(5)] = null);

} else {
throw ex63074;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63070 === (8))){
var inst_63064 = (state_63069[(2)]);
var _ = (function (){var statearr_63083 = state_63069;
(statearr_63083[(4)] = cljs.core.rest.call(null,(state_63069[(4)])));

return statearr_63083;
})();
var state_63069__$1 = state_63069;
var statearr_63084_63098 = state_63069__$1;
(statearr_63084_63098[(2)] = inst_63064);

(statearr_63084_63098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2879__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_63085 = [null,null,null,null,null,null,null,null];
(statearr_63085[(0)] = fluree$db$connection$get_socket_$_state_machine__2879__auto__);

(statearr_63085[(1)] = (1));

return statearr_63085;
});
var fluree$db$connection$get_socket_$_state_machine__2879__auto____1 = (function (state_63069){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63086){var ex__2882__auto__ = e63086;
var statearr_63087_63099 = state_63069;
(statearr_63087_63099[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63069[(4)]))){
var statearr_63088_63100 = state_63069;
(statearr_63088_63100[(1)] = cljs.core.first.call(null,(state_63069[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63101 = state_63069;
state_63069 = G__63101;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2879__auto__ = function(state_63069){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2879__auto____1.call(this,state_63069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2879__auto____0;
fluree$db$connection$get_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2879__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63089 = f__2902__auto__.call(null);
(statearr_63089[(6)] = c__2901__auto__);

return statearr_63089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e63102){var e = e63102;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63249){
var state_val_63250 = (state_63249[(1)]);
if((state_val_63250 === (7))){
var inst_63245 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63252_63335 = state_63249__$1;
(statearr_63252_63335[(2)] = inst_63245);

(statearr_63252_63335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (20))){
var _ = (function (){var statearr_63253 = state_63249;
(statearr_63253[(4)] = cljs.core.rest.call(null,(state_63249[(4)])));

return statearr_63253;
})();
var state_63249__$1 = state_63249;
var ex63251 = (state_63249__$1[(2)]);
var statearr_63254_63336 = state_63249__$1;
(statearr_63254_63336[(5)] = ex63251);


var statearr_63255_63337 = state_63249__$1;
(statearr_63255_63337[(1)] = (10));

(statearr_63255_63337[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (27))){
var inst_63147 = (state_63249[(7)]);
var inst_63165 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63147);
var state_63249__$1 = state_63249;
var statearr_63256_63338 = state_63249__$1;
(statearr_63256_63338[(2)] = inst_63165);

(statearr_63256_63338[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (1))){
var inst_63104 = (0);
var state_63249__$1 = (function (){var statearr_63257 = state_63249;
(statearr_63257[(8)] = inst_63104);

return statearr_63257;
})();
var statearr_63258_63339 = state_63249__$1;
(statearr_63258_63339[(2)] = null);

(statearr_63258_63339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (24))){
var state_63249__$1 = state_63249;
var statearr_63259_63340 = state_63249__$1;
(statearr_63259_63340[(2)] = true);

(statearr_63259_63340[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (39))){
var inst_63235 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63260_63341 = state_63249__$1;
(statearr_63260_63341[(2)] = inst_63235);

(statearr_63260_63341[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (4))){
var inst_63107 = (state_63249[(9)]);
var inst_63107__$1 = (state_63249[(2)]);
var state_63249__$1 = (function (){var statearr_63261 = state_63249;
(statearr_63261[(9)] = inst_63107__$1);

return statearr_63261;
})();
if(cljs.core.truth_(inst_63107__$1)){
var statearr_63262_63342 = state_63249__$1;
(statearr_63262_63342[(1)] = (5));

} else {
var statearr_63263_63343 = state_63249__$1;
(statearr_63263_63343[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (15))){
var inst_63120 = (state_63249[(10)]);
var state_63249__$1 = state_63249;
var statearr_63264_63344 = state_63249__$1;
(statearr_63264_63344[(2)] = inst_63120);

(statearr_63264_63344[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (21))){
var inst_63147 = (state_63249[(7)]);
var inst_63152 = inst_63147.cljs$lang$protocol_mask$partition0$;
var inst_63153 = (inst_63152 & (64));
var inst_63154 = inst_63147.cljs$core$ISeq$;
var inst_63155 = (cljs.core.PROTOCOL_SENTINEL === inst_63154);
var inst_63156 = ((inst_63153) || (inst_63155));
var state_63249__$1 = state_63249;
if(cljs.core.truth_(inst_63156)){
var statearr_63265_63345 = state_63249__$1;
(statearr_63265_63345[(1)] = (24));

} else {
var statearr_63266_63346 = state_63249__$1;
(statearr_63266_63346[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (31))){
var state_63249__$1 = state_63249;
var statearr_63267_63347 = state_63249__$1;
(statearr_63267_63347[(2)] = null);

(statearr_63267_63347[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (32))){
var inst_63144 = (state_63249[(11)]);
var inst_63145 = (state_63249[(12)]);
var inst_63171 = (state_63249[(13)]);
var inst_63209 = (state_63249[(2)]);
var inst_63210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63211 = [inst_63144,inst_63171,inst_63145];
var inst_63212 = (new cljs.core.PersistentVector(null,3,(5),inst_63210,inst_63211,null));
var inst_63213 = publish_fn.call(null,conn,inst_63212);
var state_63249__$1 = (function (){var statearr_63268 = state_63249;
(statearr_63268[(14)] = inst_63209);

return statearr_63268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63249__$1,(33),inst_63213);
} else {
if((state_val_63250 === (40))){
var inst_63225 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_63249__$1 = state_63249;
var statearr_63269_63348 = state_63249__$1;
(statearr_63269_63348[(2)] = inst_63225);

(statearr_63269_63348[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (33))){
var inst_63215 = (state_63249[(15)]);
var inst_63215__$1 = (state_63249[(2)]);
var inst_63216 = inst_63215__$1 === true;
var state_63249__$1 = (function (){var statearr_63270 = state_63249;
(statearr_63270[(15)] = inst_63215__$1);

return statearr_63270;
})();
if(cljs.core.truth_(inst_63216)){
var statearr_63271_63349 = state_63249__$1;
(statearr_63271_63349[(1)] = (34));

} else {
var statearr_63272_63350 = state_63249__$1;
(statearr_63272_63350[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (13))){
var inst_63120 = (state_63249[(10)]);
var inst_63117 = (state_63249[(2)]);
var inst_63118 = cljs.core.nth.call(null,inst_63117,(0),null);
var inst_63119 = cljs.core.nth.call(null,inst_63117,(1),null);
var inst_63120__$1 = cljs.core.nth.call(null,inst_63117,(2),null);
var state_63249__$1 = (function (){var statearr_63273 = state_63249;
(statearr_63273[(16)] = inst_63119);

(statearr_63273[(17)] = inst_63118);

(statearr_63273[(10)] = inst_63120__$1);

return statearr_63273;
})();
if(cljs.core.truth_(inst_63120__$1)){
var statearr_63274_63351 = state_63249__$1;
(statearr_63274_63351[(1)] = (14));

} else {
var statearr_63275_63352 = state_63249__$1;
(statearr_63275_63352[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (22))){
var state_63249__$1 = state_63249;
var statearr_63276_63353 = state_63249__$1;
(statearr_63276_63353[(2)] = false);

(statearr_63276_63353[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (36))){
var inst_63237 = (state_63249[(2)]);
var _ = (function (){var statearr_63277 = state_63249;
(statearr_63277[(4)] = cljs.core.rest.call(null,(state_63249[(4)])));

return statearr_63277;
})();
var state_63249__$1 = state_63249;
var statearr_63278_63354 = state_63249__$1;
(statearr_63278_63354[(2)] = inst_63237);

(statearr_63278_63354[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (41))){
var state_63249__$1 = state_63249;
var statearr_63279_63355 = state_63249__$1;
(statearr_63279_63355[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (43))){
var inst_63215 = (state_63249[(15)]);
var inst_63228 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_63215);
var state_63249__$1 = state_63249;
var statearr_63281_63356 = state_63249__$1;
(statearr_63281_63356[(2)] = inst_63228);

(statearr_63281_63356[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (29))){
var inst_63146 = (state_63249[(18)]);
var inst_63168 = (state_63249[(19)]);
var inst_63168__$1 = (state_63249[(2)]);
var inst_63169 = fluree.db.util.core.random_uuid.call(null);
var inst_63170 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63169);
var inst_63171 = cljs.core.get.call(null,inst_63168__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_63170);
var inst_63172 = cljs.core.get.call(null,inst_63168__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_63249__$1 = (function (){var statearr_63282 = state_63249;
(statearr_63282[(20)] = inst_63172);

(statearr_63282[(19)] = inst_63168__$1);

(statearr_63282[(13)] = inst_63171);

return statearr_63282;
})();
if(cljs.core.truth_(inst_63146)){
var statearr_63283_63357 = state_63249__$1;
(statearr_63283_63357[(1)] = (30));

} else {
var statearr_63284_63358 = state_63249__$1;
(statearr_63284_63358[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (44))){
var state_63249__$1 = state_63249;
var statearr_63285_63359 = state_63249__$1;
(statearr_63285_63359[(2)] = null);

(statearr_63285_63359[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (6))){
var state_63249__$1 = state_63249;
var statearr_63286_63360 = state_63249__$1;
(statearr_63286_63360[(2)] = null);

(statearr_63286_63360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (28))){
var inst_63147 = (state_63249[(7)]);
var state_63249__$1 = state_63249;
var statearr_63287_63361 = state_63249__$1;
(statearr_63287_63361[(2)] = inst_63147);

(statearr_63287_63361[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (25))){
var state_63249__$1 = state_63249;
var statearr_63288_63362 = state_63249__$1;
(statearr_63288_63362[(2)] = false);

(statearr_63288_63362[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (34))){
var state_63249__$1 = state_63249;
var statearr_63289_63363 = state_63249__$1;
(statearr_63289_63363[(2)] = null);

(statearr_63289_63363[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (17))){
var inst_63109 = (state_63249[(21)]);
var inst_63120 = (state_63249[(10)]);
var inst_63127 = cljs.core.async.put_BANG_.call(null,inst_63120,inst_63109);
var state_63249__$1 = state_63249;
var statearr_63290_63364 = state_63249__$1;
(statearr_63290_63364[(2)] = inst_63127);

(statearr_63290_63364[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (3))){
var inst_63247 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63249__$1,inst_63247);
} else {
if((state_val_63250 === (12))){
var state_63249__$1 = state_63249;
var statearr_63291_63365 = state_63249__$1;
(statearr_63291_63365[(2)] = null);

(statearr_63291_63365[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (2))){
var state_63249__$1 = state_63249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63249__$1,(4),req_chan);
} else {
if((state_val_63250 === (23))){
var inst_63163 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
if(cljs.core.truth_(inst_63163)){
var statearr_63292_63366 = state_63249__$1;
(statearr_63292_63366[(1)] = (27));

} else {
var statearr_63293_63367 = state_63249__$1;
(statearr_63293_63367[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (35))){
var inst_63215 = (state_63249[(15)]);
var inst_63219 = fluree.db.util.core.exception_QMARK_.call(null,inst_63215);
var state_63249__$1 = state_63249;
if(inst_63219){
var statearr_63294_63368 = state_63249__$1;
(statearr_63294_63368[(1)] = (37));

} else {
var statearr_63295_63369 = state_63249__$1;
(statearr_63295_63369[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (19))){
var inst_63133 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63296_63370 = state_63249__$1;
(statearr_63296_63370[(2)] = inst_63133);

(statearr_63296_63370[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (11))){
var inst_63107 = (state_63249[(9)]);
var state_63249__$1 = state_63249;
var statearr_63297_63371 = state_63249__$1;
(statearr_63297_63371[(2)] = inst_63107);

(statearr_63297_63371[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (9))){
var inst_63104 = (state_63249[(8)]);
var inst_63240 = (state_63249[(2)]);
var inst_63241 = (inst_63104 + (1));
var inst_63104__$1 = inst_63241;
var state_63249__$1 = (function (){var statearr_63298 = state_63249;
(statearr_63298[(8)] = inst_63104__$1);

(statearr_63298[(22)] = inst_63240);

return statearr_63298;
})();
var statearr_63299_63372 = state_63249__$1;
(statearr_63299_63372[(2)] = null);

(statearr_63299_63372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (5))){
var state_63249__$1 = state_63249;
var statearr_63300_63373 = state_63249__$1;
(statearr_63300_63373[(2)] = null);

(statearr_63300_63373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (14))){
var inst_63120 = (state_63249[(10)]);
var inst_63122 = fluree.db.util.async.channel_QMARK_.call(null,inst_63120);
var state_63249__$1 = state_63249;
var statearr_63301_63374 = state_63249__$1;
(statearr_63301_63374[(2)] = inst_63122);

(statearr_63301_63374[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (45))){
var inst_63231 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63302_63375 = state_63249__$1;
(statearr_63302_63375[(2)] = inst_63231);

(statearr_63302_63375[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (26))){
var inst_63160 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63303_63376 = state_63249__$1;
(statearr_63303_63376[(2)] = inst_63160);

(statearr_63303_63376[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (16))){
var inst_63125 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
if(cljs.core.truth_(inst_63125)){
var statearr_63304_63377 = state_63249__$1;
(statearr_63304_63377[(1)] = (17));

} else {
var statearr_63305_63378 = state_63249__$1;
(statearr_63305_63378[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (38))){
var inst_63215 = (state_63249[(15)]);
var inst_63223 = (inst_63215 == null);
var state_63249__$1 = state_63249;
if(cljs.core.truth_(inst_63223)){
var statearr_63306_63379 = state_63249__$1;
(statearr_63306_63379[(1)] = (40));

} else {
var statearr_63307_63380 = state_63249__$1;
(statearr_63307_63380[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (30))){
var inst_63143 = (state_63249[(23)]);
var inst_63144 = (state_63249[(11)]);
var inst_63147 = (state_63249[(7)]);
var inst_63107 = (state_63249[(9)]);
var inst_63146 = (state_63249[(18)]);
var inst_63172 = (state_63249[(20)]);
var inst_63145 = (state_63249[(12)]);
var inst_63168 = (state_63249[(19)]);
var inst_63171 = (state_63249[(13)]);
var inst_63104 = (state_63249[(8)]);
var inst_63174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63175 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_63171];
var inst_63176 = (new cljs.core.PersistentVector(null,2,(5),inst_63174,inst_63175,null));
var inst_63177 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_63176,inst_63146);
var inst_63204 = cljs.core.async.chan.call(null,(1));
var inst_63205 = (function (){var resp_chan = inst_63146;
var timeout = inst_63172;
var i = inst_63104;
var data = inst_63145;
var vec__63139 = inst_63107;
var map__63142 = inst_63168;
var c__2901__auto____$1 = inst_63204;
var _ = inst_63143;
var req_id = inst_63171;
var operation = inst_63144;
var msg = inst_63107;
var opts = inst_63147;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63202){
var state_val_63203 = (state_63202[(1)]);
if((state_val_63203 === (1))){
var inst_63181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63182 = cljs.core.async.timeout.call(null,timeout);
var inst_63183 = [resp_chan,inst_63182];
var inst_63184 = (new cljs.core.PersistentVector(null,2,(5),inst_63181,inst_63183,null));
var state_63202__$1 = state_63202;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63202__$1,(2),inst_63184);
} else {
if((state_val_63203 === (2))){
var inst_63187 = (state_63202[(7)]);
var inst_63186 = (state_63202[(2)]);
var inst_63187__$1 = cljs.core.nth.call(null,inst_63186,(0),null);
var inst_63188 = cljs.core.nth.call(null,inst_63186,(1),null);
var inst_63189 = (function (){var vec__63178 = inst_63186;
var resp = inst_63187__$1;
var c = inst_63188;
return (function (p1__63103_SHARP_){
return cljs.core.dissoc.call(null,p1__63103_SHARP_,req_id);
});
})();
var inst_63190 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_63189);
var inst_63191 = cljs.core._EQ_.call(null,inst_63188,resp_chan);
var state_63202__$1 = (function (){var statearr_63308 = state_63202;
(statearr_63308[(8)] = inst_63190);

(statearr_63308[(7)] = inst_63187__$1);

return statearr_63308;
})();
if(inst_63191){
var statearr_63309_63381 = state_63202__$1;
(statearr_63309_63381[(1)] = (3));

} else {
var statearr_63310_63382 = state_63202__$1;
(statearr_63310_63382[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (3))){
var inst_63187 = (state_63202[(7)]);
var state_63202__$1 = state_63202;
var statearr_63311_63383 = state_63202__$1;
(statearr_63311_63383[(2)] = inst_63187);

(statearr_63311_63383[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (4))){
var inst_63194 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_63195 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63196 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63197 = cljs.core.PersistentHashMap.fromArrays(inst_63195,inst_63196);
var inst_63198 = cljs.core.ex_info.call(null,inst_63194,inst_63197);
var state_63202__$1 = state_63202;
var statearr_63312_63384 = state_63202__$1;
(statearr_63312_63384[(2)] = inst_63198);

(statearr_63312_63384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (5))){
var inst_63200 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63202__$1,inst_63200);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____0 = (function (){
var statearr_63313 = [null,null,null,null,null,null,null,null,null];
(statearr_63313[(0)] = fluree$db$connection$msg_producer_$_state_machine__2879__auto__);

(statearr_63313[(1)] = (1));

return statearr_63313;
});
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____1 = (function (state_63202){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63314){var ex__2882__auto__ = e63314;
var statearr_63315_63385 = state_63202;
(statearr_63315_63385[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63202[(4)]))){
var statearr_63316_63386 = state_63202;
(statearr_63316_63386[(1)] = cljs.core.first.call(null,(state_63202[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63387 = state_63202;
state_63202 = G__63387;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = function(state_63202){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____1.call(this,state_63202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63317 = f__2902__auto__.call(null);
(statearr_63317[(6)] = c__2901__auto____$1);

return statearr_63317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});
})();
var inst_63206 = cljs.core.async.impl.dispatch.run.call(null,inst_63205);
var state_63249__$1 = (function (){var statearr_63318 = state_63249;
(statearr_63318[(24)] = inst_63177);

(statearr_63318[(25)] = inst_63206);

return statearr_63318;
})();
var statearr_63319_63388 = state_63249__$1;
(statearr_63319_63388[(2)] = inst_63204);

(statearr_63319_63388[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (10))){
var inst_63107 = (state_63249[(9)]);
var inst_63109 = (state_63249[(2)]);
var inst_63113 = cljs.core.sequential_QMARK_.call(null,inst_63107);
var state_63249__$1 = (function (){var statearr_63320 = state_63249;
(statearr_63320[(21)] = inst_63109);

return statearr_63320;
})();
if(inst_63113){
var statearr_63321_63389 = state_63249__$1;
(statearr_63321_63389[(1)] = (11));

} else {
var statearr_63322_63390 = state_63249__$1;
(statearr_63322_63390[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (18))){
var inst_63109 = (state_63249[(21)]);
var inst_63107 = (state_63249[(9)]);
var inst_63129 = cljs.core.pr_str.call(null,inst_63107);
var inst_63130 = ["Error processing ledger request, no valid return channel: ",inst_63129].join('');
var inst_63131 = fluree.db.util.log.error.call(null,inst_63109,inst_63130);
var state_63249__$1 = state_63249;
var statearr_63323_63391 = state_63249__$1;
(statearr_63323_63391[(2)] = inst_63131);

(statearr_63323_63391[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (42))){
var inst_63233 = (state_63249[(2)]);
var state_63249__$1 = state_63249;
var statearr_63324_63392 = state_63249__$1;
(statearr_63324_63392[(2)] = inst_63233);

(statearr_63324_63392[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (37))){
var inst_63215 = (state_63249[(15)]);
var inst_63221 = fluree.db.util.log.error.call(null,inst_63215,"Error processing message in producer.");
var state_63249__$1 = state_63249;
var statearr_63325_63393 = state_63249__$1;
(statearr_63325_63393[(2)] = inst_63221);

(statearr_63325_63393[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63250 === (8))){
var inst_63147 = (state_63249[(7)]);
var inst_63107 = (state_63249[(9)]);
var _ = (function (){var statearr_63326 = state_63249;
(statearr_63326[(4)] = cljs.core.cons.call(null,(20),(state_63249[(4)])));

return statearr_63326;
})();
var inst_63143 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_63107);
var inst_63144 = cljs.core.nth.call(null,inst_63107,(0),null);
var inst_63145 = cljs.core.nth.call(null,inst_63107,(1),null);
var inst_63146 = cljs.core.nth.call(null,inst_63107,(2),null);
var inst_63147__$1 = cljs.core.nth.call(null,inst_63107,(3),null);
var inst_63149 = (inst_63147__$1 == null);
var inst_63150 = cljs.core.not.call(null,inst_63149);
var state_63249__$1 = (function (){var statearr_63327 = state_63249;
(statearr_63327[(23)] = inst_63143);

(statearr_63327[(11)] = inst_63144);

(statearr_63327[(7)] = inst_63147__$1);

(statearr_63327[(18)] = inst_63146);

(statearr_63327[(12)] = inst_63145);

return statearr_63327;
})();
if(inst_63150){
var statearr_63328_63394 = state_63249__$1;
(statearr_63328_63394[(1)] = (21));

} else {
var statearr_63329_63395 = state_63249__$1;
(statearr_63329_63395[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____0 = (function (){
var statearr_63330 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63330[(0)] = fluree$db$connection$msg_producer_$_state_machine__2879__auto__);

(statearr_63330[(1)] = (1));

return statearr_63330;
});
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____1 = (function (state_63249){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63331){var ex__2882__auto__ = e63331;
var statearr_63332_63396 = state_63249;
(statearr_63332_63396[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63249[(4)]))){
var statearr_63333_63397 = state_63249;
(statearr_63333_63397[(1)] = cljs.core.first.call(null,(state_63249[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63398 = state_63249;
state_63249 = G__63398;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = function(state_63249){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____1.call(this,state_63249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63334 = f__2902__auto__.call(null);
(statearr_63334[(6)] = c__2901__auto__);

return statearr_63334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63399 = conn;
var map__63399__$1 = (((((!((map__63399 == null))))?(((((map__63399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63399):map__63399);
var sub_chan = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63482){
var state_val_63483 = (state_63482[(1)]);
if((state_val_63483 === (7))){
var inst_63478 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63484_63535 = state_63482__$1;
(statearr_63484_63535[(2)] = inst_63478);

(statearr_63484_63535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (20))){
var inst_63419 = (state_63482[(7)]);
var inst_63433 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63434 = [inst_63419];
var inst_63435 = cljs.core.PersistentHashMap.fromArrays(inst_63433,inst_63434);
var inst_63436 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_63435);
var state_63482__$1 = state_63482;
var statearr_63485_63536 = state_63482__$1;
(statearr_63485_63536[(2)] = inst_63436);

(statearr_63485_63536[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (27))){
var state_63482__$1 = state_63482;
var statearr_63486_63537 = state_63482__$1;
(statearr_63486_63537[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (1))){
var inst_63401 = (0);
var state_63482__$1 = (function (){var statearr_63488 = state_63482;
(statearr_63488[(8)] = inst_63401);

return statearr_63488;
})();
var statearr_63489_63538 = state_63482__$1;
(statearr_63489_63538[(2)] = null);

(statearr_63489_63538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (24))){
var inst_63412 = (state_63482[(9)]);
var inst_63461 = fluree.db.util.core.exception_QMARK_.call(null,inst_63412);
var state_63482__$1 = state_63482;
if(inst_63461){
var statearr_63490_63539 = state_63482__$1;
(statearr_63490_63539[(1)] = (26));

} else {
var statearr_63491_63540 = state_63482__$1;
(statearr_63491_63540[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (4))){
var inst_63406 = (state_63482[(10)]);
var inst_63411 = (state_63482[(2)]);
var inst_63412 = cljs.core.nth.call(null,inst_63411,(0),null);
var inst_63413 = cljs.core.nth.call(null,inst_63411,(1),null);
var inst_63414 = cljs.core._EQ_.call(null,inst_63413,inst_63406);
var state_63482__$1 = (function (){var statearr_63492 = state_63482;
(statearr_63492[(9)] = inst_63412);

return statearr_63492;
})();
if(inst_63414){
var statearr_63493_63541 = state_63482__$1;
(statearr_63493_63541[(1)] = (5));

} else {
var statearr_63494_63542 = state_63482__$1;
(statearr_63494_63542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (15))){
var inst_63419 = (state_63482[(7)]);
var inst_63428 = typeof inst_63419 === 'string';
var state_63482__$1 = state_63482;
if(cljs.core.truth_(inst_63428)){
var statearr_63495_63543 = state_63482__$1;
(statearr_63495_63543[(1)] = (17));

} else {
var statearr_63496_63544 = state_63482__$1;
(statearr_63496_63544[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (21))){
var state_63482__$1 = state_63482;
var statearr_63497_63545 = state_63482__$1;
(statearr_63497_63545[(2)] = null);

(statearr_63497_63545[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (31))){
var inst_63472 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63498_63546 = state_63482__$1;
(statearr_63498_63546[(2)] = inst_63472);

(statearr_63498_63546[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (13))){
var inst_63445 = (state_63482[(2)]);
var inst_63446 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63447 = fluree.db.connection.close_websocket.call(null,inst_63446);
var inst_63448 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63449 = fluree.db.session.close_all_sessions.call(null,inst_63448);
var state_63482__$1 = (function (){var statearr_63499 = state_63482;
(statearr_63499[(11)] = inst_63445);

(statearr_63499[(12)] = inst_63447);

return statearr_63499;
})();
var statearr_63500_63547 = state_63482__$1;
(statearr_63500_63547[(2)] = inst_63449);

(statearr_63500_63547[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (22))){
var inst_63439 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63501_63548 = state_63482__$1;
(statearr_63501_63548[(2)] = inst_63439);

(statearr_63501_63548[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (29))){
var inst_63412 = (state_63482[(9)]);
var inst_63467 = fluree.db.util.json.parse.call(null,inst_63412);
var inst_63468 = fluree.db.conn_events.process_events.call(null,conn,inst_63467);
var inst_63401 = (0);
var state_63482__$1 = (function (){var statearr_63502 = state_63482;
(statearr_63502[(13)] = inst_63468);

(statearr_63502[(8)] = inst_63401);

return statearr_63502;
})();
var statearr_63503_63549 = state_63482__$1;
(statearr_63503_63549[(2)] = null);

(statearr_63503_63549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (6))){
var inst_63412 = (state_63482[(9)]);
var inst_63457 = (inst_63412 == null);
var state_63482__$1 = state_63482;
if(cljs.core.truth_(inst_63457)){
var statearr_63504_63550 = state_63482__$1;
(statearr_63504_63550[(1)] = (23));

} else {
var statearr_63505_63551 = state_63482__$1;
(statearr_63505_63551[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (28))){
var inst_63474 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63506_63552 = state_63482__$1;
(statearr_63506_63552[(2)] = inst_63474);

(statearr_63506_63552[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (25))){
var inst_63476 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63507_63553 = state_63482__$1;
(statearr_63507_63553[(2)] = inst_63476);

(statearr_63507_63553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (17))){
var inst_63419 = (state_63482[(7)]);
var inst_63430 = cljs.core.eval.call(null,inst_63419);
var state_63482__$1 = state_63482;
var statearr_63508_63554 = state_63482__$1;
(statearr_63508_63554[(2)] = inst_63430);

(statearr_63508_63554[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (3))){
var inst_63480 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63482__$1,inst_63480);
} else {
if((state_val_63483 === (12))){
var inst_63419 = (state_63482[(7)]);
var inst_63424 = cljs.core.fn_QMARK_.call(null,inst_63419);
var state_63482__$1 = state_63482;
if(inst_63424){
var statearr_63509_63555 = state_63482__$1;
(statearr_63509_63555[(1)] = (14));

} else {
var statearr_63510_63556 = state_63482__$1;
(statearr_63510_63556[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (2))){
var inst_63406 = (state_63482[(10)]);
var inst_63406__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_63407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63408 = [sub_chan,inst_63406__$1];
var inst_63409 = (new cljs.core.PersistentVector(null,2,(5),inst_63407,inst_63408,null));
var state_63482__$1 = (function (){var statearr_63511 = state_63482;
(statearr_63511[(10)] = inst_63406__$1);

return statearr_63511;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_63482__$1,(4),inst_63409);
} else {
if((state_val_63483 === (23))){
var inst_63459 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_63482__$1 = state_63482;
var statearr_63512_63557 = state_63482__$1;
(statearr_63512_63557[(2)] = inst_63459);

(statearr_63512_63557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (19))){
var inst_63441 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63513_63558 = state_63482__$1;
(statearr_63513_63558[(2)] = inst_63441);

(statearr_63513_63558[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (11))){
var inst_63422 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_63482__$1 = state_63482;
var statearr_63514_63559 = state_63482__$1;
(statearr_63514_63559[(2)] = inst_63422);

(statearr_63514_63559[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (9))){
var inst_63401 = (state_63482[(8)]);
var inst_63451 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_63452 = (inst_63401 + (1));
var inst_63401__$1 = inst_63452;
var state_63482__$1 = (function (){var statearr_63515 = state_63482;
(statearr_63515[(14)] = inst_63451);

(statearr_63515[(8)] = inst_63401__$1);

return statearr_63515;
})();
var statearr_63516_63560 = state_63482__$1;
(statearr_63516_63560[(2)] = null);

(statearr_63516_63560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (5))){
var inst_63401 = (state_63482[(8)]);
var inst_63416 = cljs.core._EQ_.call(null,(2),inst_63401);
var state_63482__$1 = state_63482;
if(inst_63416){
var statearr_63517_63561 = state_63482__$1;
(statearr_63517_63561[(1)] = (8));

} else {
var statearr_63518_63562 = state_63482__$1;
(statearr_63518_63562[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (14))){
var inst_63419 = (state_63482[(7)]);
var inst_63426 = inst_63419.call(null);
var state_63482__$1 = state_63482;
var statearr_63519_63563 = state_63482__$1;
(statearr_63519_63563[(2)] = inst_63426);

(statearr_63519_63563[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (26))){
var inst_63412 = (state_63482[(9)]);
var inst_63463 = fluree.db.util.log.error.call(null,inst_63412);
var inst_63401 = (0);
var state_63482__$1 = (function (){var statearr_63520 = state_63482;
(statearr_63520[(15)] = inst_63463);

(statearr_63520[(8)] = inst_63401);

return statearr_63520;
})();
var statearr_63521_63564 = state_63482__$1;
(statearr_63521_63564[(2)] = null);

(statearr_63521_63564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (16))){
var inst_63443 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63522_63565 = state_63482__$1;
(statearr_63522_63565[(2)] = inst_63443);

(statearr_63522_63565[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (30))){
var state_63482__$1 = state_63482;
var statearr_63523_63566 = state_63482__$1;
(statearr_63523_63566[(2)] = null);

(statearr_63523_63566[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (10))){
var inst_63455 = (state_63482[(2)]);
var state_63482__$1 = state_63482;
var statearr_63524_63567 = state_63482__$1;
(statearr_63524_63567[(2)] = inst_63455);

(statearr_63524_63567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (18))){
var state_63482__$1 = state_63482;
var statearr_63525_63568 = state_63482__$1;
(statearr_63525_63568[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63483 === (8))){
var inst_63419 = (state_63482[(7)]);
var inst_63418 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_63419__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63420 = (inst_63419__$1 == null);
var state_63482__$1 = (function (){var statearr_63527 = state_63482;
(statearr_63527[(16)] = inst_63418);

(statearr_63527[(7)] = inst_63419__$1);

return statearr_63527;
})();
if(cljs.core.truth_(inst_63420)){
var statearr_63528_63569 = state_63482__$1;
(statearr_63528_63569[(1)] = (11));

} else {
var statearr_63529_63570 = state_63482__$1;
(statearr_63529_63570[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0 = (function (){
var statearr_63530 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63530[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2879__auto__);

(statearr_63530[(1)] = (1));

return statearr_63530;
});
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1 = (function (state_63482){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63531){var ex__2882__auto__ = e63531;
var statearr_63532_63571 = state_63482;
(statearr_63532_63571[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63482[(4)]))){
var statearr_63533_63572 = state_63482;
(statearr_63533_63572[(1)] = cljs.core.first.call(null,(state_63482[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63573 = state_63482;
state_63482 = G__63573;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__ = function(state_63482){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1.call(this,state_63482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63534 = f__2902__auto__.call(null);
(statearr_63534[(6)] = c__2901__auto__);

return statearr_63534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63575 = arguments.length;
switch (G__63575) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63576 = opts;
var map__63576__$1 = (((((!((map__63576 == null))))?(((((map__63576.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63576.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63576):map__63576);
var private$ = cljs.core.get.call(null,map__63576__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__63576__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63639){
var state_val_63640 = (state_63639[(1)]);
if((state_val_63640 === (7))){
var inst_63587 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_63588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63589 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63590 = (new cljs.core.PersistentVector(null,2,(5),inst_63588,inst_63589,null));
var inst_63591 = cljs.core.get_in.call(null,inst_63587,inst_63590);
var state_63639__$1 = state_63639;
var statearr_63641_63682 = state_63639__$1;
(statearr_63641_63682[(2)] = inst_63591);

(statearr_63641_63682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (20))){
var inst_63618 = (state_63639[(7)]);
var state_63639__$1 = state_63639;
var statearr_63642_63683 = state_63639__$1;
(statearr_63642_63683[(2)] = inst_63618);

(statearr_63642_63683[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (1))){
var state_63639__$1 = state_63639;
var statearr_63643_63684 = state_63639__$1;
(statearr_63643_63684[(2)] = null);

(statearr_63643_63684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (4))){
var inst_63578 = (state_63639[(2)]);
var state_63639__$1 = state_63639;
var statearr_63644_63685 = state_63639__$1;
(statearr_63644_63685[(2)] = inst_63578);

(statearr_63644_63685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (15))){
var inst_63593 = (state_63639[(8)]);
var inst_63612 = (state_63639[(2)]);
var state_63639__$1 = (function (){var statearr_63645 = state_63639;
(statearr_63645[(9)] = inst_63612);

return statearr_63645;
})();
if(cljs.core.truth_(inst_63593)){
var statearr_63646_63686 = state_63639__$1;
(statearr_63646_63686[(1)] = (16));

} else {
var statearr_63647_63687 = state_63639__$1;
(statearr_63647_63687[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (21))){
var inst_63598 = (state_63639[(10)]);
var inst_63627 = (state_63639[(2)]);
var inst_63628 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63629 = [(5000),inst_63627,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_63630 = cljs.core.PersistentHashMap.fromArrays(inst_63628,inst_63629);
var inst_63631 = fluree.db.util.xhttp.get.call(null,inst_63598,inst_63630);
var state_63639__$1 = state_63639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63639__$1,(22),inst_63631);
} else {
if((state_val_63640 === (13))){
var inst_63607 = (state_63639[(11)]);
var inst_63593 = (state_63639[(8)]);
var inst_63609 = cljs.core.assoc.call(null,inst_63607,"X-fdb-jwt",inst_63593);
var state_63639__$1 = state_63639;
var statearr_63648_63688 = state_63639__$1;
(statearr_63648_63688[(2)] = inst_63609);

(statearr_63648_63688[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (22))){
var inst_63633 = (state_63639[(2)]);
var inst_63634 = fluree.db.util.async.throw_err.call(null,inst_63633);
var _ = (function (){var statearr_63649 = state_63639;
(statearr_63649[(4)] = cljs.core.rest.call(null,(state_63639[(4)])));

return statearr_63649;
})();
var state_63639__$1 = state_63639;
var statearr_63650_63689 = state_63639__$1;
(statearr_63650_63689[(2)] = inst_63634);

(statearr_63650_63689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (6))){
var inst_63584 = (state_63639[(12)]);
var state_63639__$1 = state_63639;
var statearr_63651_63690 = state_63639__$1;
(statearr_63651_63690[(2)] = inst_63584);

(statearr_63651_63690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (17))){
var inst_63612 = (state_63639[(9)]);
var state_63639__$1 = state_63639;
var statearr_63652_63691 = state_63639__$1;
(statearr_63652_63691[(2)] = inst_63612);

(statearr_63652_63691[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (3))){
var inst_63637 = (state_63639[(2)]);
var state_63639__$1 = state_63639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63639__$1,inst_63637);
} else {
if((state_val_63640 === (12))){
var inst_63593 = (state_63639[(8)]);
var inst_63607 = (state_63639[(2)]);
var state_63639__$1 = (function (){var statearr_63653 = state_63639;
(statearr_63653[(11)] = inst_63607);

return statearr_63653;
})();
if(cljs.core.truth_(inst_63593)){
var statearr_63654_63692 = state_63639__$1;
(statearr_63654_63692[(1)] = (13));

} else {
var statearr_63655_63693 = state_63639__$1;
(statearr_63655_63693[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (2))){
var inst_63584 = (state_63639[(12)]);
var _ = (function (){var statearr_63656 = state_63639;
(statearr_63656[(4)] = cljs.core.cons.call(null,(5),(state_63639[(4)])));

return statearr_63656;
})();
var inst_63584__$1 = jwt;
var state_63639__$1 = (function (){var statearr_63657 = state_63639;
(statearr_63657[(12)] = inst_63584__$1);

return statearr_63657;
})();
if(cljs.core.truth_(inst_63584__$1)){
var statearr_63658_63694 = state_63639__$1;
(statearr_63658_63694[(1)] = (6));

} else {
var statearr_63659_63695 = state_63639__$1;
(statearr_63659_63695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (19))){
var inst_63618 = (state_63639[(7)]);
var inst_63598 = (state_63639[(10)]);
var inst_63620 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63621 = [inst_63618];
var inst_63622 = cljs.core.PersistentHashMap.fromArrays(inst_63620,inst_63621);
var inst_63623 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_63598,inst_63622,private$);
var inst_63624 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63623);
var state_63639__$1 = state_63639;
var statearr_63660_63696 = state_63639__$1;
(statearr_63660_63696[(2)] = inst_63624);

(statearr_63660_63696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (11))){
var inst_63602 = (state_63639[(13)]);
var state_63639__$1 = state_63639;
var statearr_63662_63697 = state_63639__$1;
(statearr_63662_63697[(2)] = inst_63602);

(statearr_63662_63697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (9))){
var inst_63594 = (state_63639[(14)]);
var inst_63597 = (state_63639[(2)]);
var inst_63598 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63597),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63594)].join('');
var inst_63600 = ["Accept"];
var inst_63601 = ["application/json"];
var inst_63602 = cljs.core.PersistentHashMap.fromArrays(inst_63600,inst_63601);
var state_63639__$1 = (function (){var statearr_63663 = state_63639;
(statearr_63663[(10)] = inst_63598);

(statearr_63663[(13)] = inst_63602);

return statearr_63663;
})();
if(cljs.core.truth_(private$)){
var statearr_63664_63698 = state_63639__$1;
(statearr_63664_63698[(1)] = (10));

} else {
var statearr_63665_63699 = state_63639__$1;
(statearr_63665_63699[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (5))){
var _ = (function (){var statearr_63666 = state_63639;
(statearr_63666[(4)] = cljs.core.rest.call(null,(state_63639[(4)])));

return statearr_63666;
})();
var state_63639__$1 = state_63639;
var ex63661 = (state_63639__$1[(2)]);
var statearr_63667_63700 = state_63639__$1;
(statearr_63667_63700[(5)] = ex63661);


if((ex63661 instanceof Error)){
var statearr_63668_63701 = state_63639__$1;
(statearr_63668_63701[(1)] = (4));

(statearr_63668_63701[(5)] = null);

} else {
throw ex63661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (14))){
var inst_63607 = (state_63639[(11)]);
var state_63639__$1 = state_63639;
var statearr_63669_63702 = state_63639__$1;
(statearr_63669_63702[(2)] = inst_63607);

(statearr_63669_63702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (16))){
var inst_63612 = (state_63639[(9)]);
var inst_63593 = (state_63639[(8)]);
var inst_63614 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63593)].join('');
var inst_63615 = cljs.core.assoc.call(null,inst_63612,"Authorization",inst_63614);
var state_63639__$1 = state_63639;
var statearr_63670_63703 = state_63639__$1;
(statearr_63670_63703[(2)] = inst_63615);

(statearr_63670_63703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (10))){
var inst_63602 = (state_63639[(13)]);
var inst_63604 = cljs.core.assoc.call(null,inst_63602,"X-fdb-pri",private$);
var state_63639__$1 = state_63639;
var statearr_63671_63704 = state_63639__$1;
(statearr_63671_63704[(2)] = inst_63604);

(statearr_63671_63704[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (18))){
var inst_63618 = (state_63639[(2)]);
var state_63639__$1 = (function (){var statearr_63672 = state_63639;
(statearr_63672[(7)] = inst_63618);

return statearr_63672;
})();
if(cljs.core.truth_(private$)){
var statearr_63673_63705 = state_63639__$1;
(statearr_63673_63705[(1)] = (19));

} else {
var statearr_63674_63706 = state_63639__$1;
(statearr_63674_63706[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63640 === (8))){
var inst_63593 = (state_63639[(2)]);
var inst_63594 = clojure.string.replace.call(null,k,"_","/");
var inst_63595 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_63639__$1 = (function (){var statearr_63675 = state_63639;
(statearr_63675[(8)] = inst_63593);

(statearr_63675[(14)] = inst_63594);

return statearr_63675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63639__$1,(9),inst_63595);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2879__auto__ = null;
var fluree$db$connection$state_machine__2879__auto____0 = (function (){
var statearr_63676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63676[(0)] = fluree$db$connection$state_machine__2879__auto__);

(statearr_63676[(1)] = (1));

return statearr_63676;
});
var fluree$db$connection$state_machine__2879__auto____1 = (function (state_63639){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63677){var ex__2882__auto__ = e63677;
var statearr_63678_63707 = state_63639;
(statearr_63678_63707[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63639[(4)]))){
var statearr_63679_63708 = state_63639;
(statearr_63679_63708[(1)] = cljs.core.first.call(null,(state_63639[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63709 = state_63639;
state_63639 = G__63709;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2879__auto__ = function(state_63639){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2879__auto____1.call(this,state_63639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2879__auto____0;
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2879__auto____1;
return fluree$db$connection$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63680 = f__2902__auto__.call(null);
(statearr_63680[(6)] = c__2901__auto__);

return statearr_63680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63710_SHARP_){
if(cljs.core.truth_(p1__63710_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63711 = opts;
var map__63711__$1 = (((((!((map__63711 == null))))?(((((map__63711.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63711.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63711):map__63711);
var sub_chan = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__63711__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e63713){var _ = e63713;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___63746 = arguments.length;
var i__4737__auto___63747 = (0);
while(true){
if((i__4737__auto___63747 < len__4736__auto___63746)){
args__4742__auto__.push((arguments[i__4737__auto___63747]));

var G__63748 = (i__4737__auto___63747 + (1));
i__4737__auto___63747 = G__63748;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63716){
var vec__63717 = p__63716;
var opts = cljs.core.nth.call(null,vec__63717,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2901__auto___63749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63734){
var state_val_63735 = (state_63734[(1)]);
if((state_val_63735 === (1))){
var inst_63720 = fluree.db.connection.get_socket.call(null,conn);
var state_63734__$1 = state_63734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63734__$1,(2),inst_63720);
} else {
if((state_val_63735 === (2))){
var inst_63722 = (state_63734[(2)]);
var inst_63723 = (inst_63722 == null);
var inst_63724 = fluree.db.util.core.exception_QMARK_.call(null,inst_63722);
var inst_63725 = ((inst_63723) || (inst_63724));
var state_63734__$1 = state_63734;
if(cljs.core.truth_(inst_63725)){
var statearr_63736_63750 = state_63734__$1;
(statearr_63736_63750[(1)] = (3));

} else {
var statearr_63737_63751 = state_63734__$1;
(statearr_63737_63751[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63735 === (3))){
var inst_63727 = fluree.db.util.log.warn.call(null,"Cannot establish connection to a healthy server, disconnecting.");
var inst_63728 = cljs.core.async.close_BANG_.call(null,conn);
var state_63734__$1 = (function (){var statearr_63738 = state_63734;
(statearr_63738[(7)] = inst_63727);

return statearr_63738;
})();
var statearr_63739_63752 = state_63734__$1;
(statearr_63739_63752[(2)] = inst_63728);

(statearr_63739_63752[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63735 === (4))){
var inst_63730 = fluree.db.connection.msg_consumer.call(null,conn);
var state_63734__$1 = state_63734;
var statearr_63740_63753 = state_63734__$1;
(statearr_63740_63753[(2)] = inst_63730);

(statearr_63740_63753[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63735 === (5))){
var inst_63732 = (state_63734[(2)]);
var state_63734__$1 = state_63734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63734__$1,inst_63732);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2879__auto__ = null;
var fluree$db$connection$state_machine__2879__auto____0 = (function (){
var statearr_63741 = [null,null,null,null,null,null,null,null];
(statearr_63741[(0)] = fluree$db$connection$state_machine__2879__auto__);

(statearr_63741[(1)] = (1));

return statearr_63741;
});
var fluree$db$connection$state_machine__2879__auto____1 = (function (state_63734){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63742){var ex__2882__auto__ = e63742;
var statearr_63743_63754 = state_63734;
(statearr_63743_63754[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63734[(4)]))){
var statearr_63744_63755 = state_63734;
(statearr_63744_63755[(1)] = cljs.core.first.call(null,(state_63734[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63756 = state_63734;
state_63734 = G__63756;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2879__auto__ = function(state_63734){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2879__auto____1.call(this,state_63734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2879__auto____0;
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2879__auto____1;
return fluree$db$connection$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63745 = f__2902__auto__.call(null);
(statearr_63745[(6)] = c__2901__auto___63749);

return statearr_63745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63714){
var G__63715 = cljs.core.first.call(null,seq63714);
var seq63714__$1 = cljs.core.next.call(null,seq63714);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63715,seq63714__$1);
}));

