// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__18535 = cljs.core.seq.call(null,callbacks);
var chunk__18536 = null;
var count__18537 = (0);
var i__18538 = (0);
while(true){
if((i__18538 < count__18537)){
var vec__18547 = cljs.core._nth.call(null,chunk__18536,i__18538);
var k = cljs.core.nth.call(null,vec__18547,(0),null);
var f = cljs.core.nth.call(null,vec__18547,(1),null);
try{f.call(null,event_type,event_data);
}catch (e18550){var e_18555 = e18550;
fluree.db.util.log.error.call(null,e_18555,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__18556 = seq__18535;
var G__18557 = chunk__18536;
var G__18558 = count__18537;
var G__18559 = (i__18538 + (1));
seq__18535 = G__18556;
chunk__18536 = G__18557;
count__18537 = G__18558;
i__18538 = G__18559;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__18535);
if(temp__5735__auto__){
var seq__18535__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18535__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__18535__$1);
var G__18560 = cljs.core.chunk_rest.call(null,seq__18535__$1);
var G__18561 = c__4556__auto__;
var G__18562 = cljs.core.count.call(null,c__4556__auto__);
var G__18563 = (0);
seq__18535 = G__18560;
chunk__18536 = G__18561;
count__18537 = G__18562;
i__18538 = G__18563;
continue;
} else {
var vec__18551 = cljs.core.first.call(null,seq__18535__$1);
var k = cljs.core.nth.call(null,vec__18551,(0),null);
var f = cljs.core.nth.call(null,vec__18551,(1),null);
try{f.call(null,event_type,event_data);
}catch (e18554){var e_18564 = e18554;
fluree.db.util.log.error.call(null,e_18564,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__18565 = cljs.core.next.call(null,seq__18535__$1);
var G__18566 = null;
var G__18567 = (0);
var G__18568 = (0);
seq__18535 = G__18565;
chunk__18536 = G__18566;
count__18537 = G__18567;
i__18538 = G__18568;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__18571 = msg;
var event_type = cljs.core.nth.call(null,vec__18571,(0),null);
var subject = cljs.core.nth.call(null,vec__18571,(1),null);
var event_data = cljs.core.nth.call(null,vec__18571,(2),null);
var error_data = cljs.core.nth.call(null,vec__18571,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__18574 = conn;
var map__18574__$1 = (((((!((map__18574 == null))))?(((((map__18574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18574):map__18574);
var state = cljs.core.get.call(null,map__18574__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__18576 = event_type__$1;
var G__18576__$1 = (((G__18576 instanceof cljs.core.Keyword))?G__18576.fqn:null);
switch (G__18576__$1) {
case "response":
var temp__5735__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5735__auto__)){
var res_chan = temp__5735__auto__;
cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__18569_SHARP_){
return cljs.core.dissoc.call(null,p1__18569_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__18577 = error_data;
var map__18577__$1 = (((((!((map__18577 == null))))?(((((map__18577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18577):map__18577);
var message = cljs.core.get.call(null,map__18577__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e18570){var e = e18570;
return fluree.db.util.log.error.call(null,e);
}});
