// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64407 = arguments.length;
var i__4737__auto___64408 = (0);
while(true){
if((i__4737__auto___64408 < len__4736__auto___64407)){
args__4742__auto__.push((arguments[i__4737__auto___64408]));

var G__64409 = (i__4737__auto___64408 + (1));
i__4737__auto___64408 = G__64409;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__64306){
var vec__64307 = p__64306;
var opts = cljs.core.nth.call(null,vec__64307,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___64410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64371){
var state_val_64372 = (state_64371[(1)]);
if((state_val_64372 === (7))){
var state_64371__$1 = state_64371;
var statearr_64373_64411 = state_64371__$1;
(statearr_64373_64411[(2)] = false);

(statearr_64373_64411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (1))){
var state_64371__$1 = state_64371;
var statearr_64374_64412 = state_64371__$1;
(statearr_64374_64412[(2)] = null);

(statearr_64374_64412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (4))){
var inst_64310 = (state_64371[(2)]);
var inst_64311 = fluree.db.util.log.error.call(null,inst_64310);
var inst_64312 = cljs.core.async.put_BANG_.call(null,pc,inst_64310);
var inst_64313 = cljs.core.async.close_BANG_.call(null,pc);
var state_64371__$1 = (function (){var statearr_64375 = state_64371;
(statearr_64375[(7)] = inst_64312);

(statearr_64375[(8)] = inst_64311);

return statearr_64375;
})();
var statearr_64376_64413 = state_64371__$1;
(statearr_64376_64413[(2)] = inst_64313);

(statearr_64376_64413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (15))){
var inst_64348 = (state_64371[(9)]);
var inst_64351 = (state_64371[(10)]);
var inst_64352 = (state_64371[(11)]);
var inst_64355 = (state_64371[(2)]);
var inst_64356 = fluree.db.util.async.throw_err.call(null,inst_64355);
var inst_64357 = cljs.core.assoc.call(null,inst_64356,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_64351,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_64352);
var state_64371__$1 = (function (){var statearr_64377 = state_64371;
(statearr_64377[(12)] = inst_64357);

return statearr_64377;
})();
if(cljs.core.truth_(inst_64348)){
var statearr_64378_64414 = state_64371__$1;
(statearr_64378_64414[(1)] = (16));

} else {
var statearr_64379_64415 = state_64371__$1;
(statearr_64379_64415[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (13))){
var inst_64323 = (state_64371[(13)]);
var state_64371__$1 = state_64371;
var statearr_64380_64416 = state_64371__$1;
(statearr_64380_64416[(2)] = inst_64323);

(statearr_64380_64416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (6))){
var inst_64323 = (state_64371[(13)]);
var inst_64328 = inst_64323.cljs$lang$protocol_mask$partition0$;
var inst_64329 = (inst_64328 & (64));
var inst_64330 = inst_64323.cljs$core$ISeq$;
var inst_64331 = (cljs.core.PROTOCOL_SENTINEL === inst_64330);
var inst_64332 = ((inst_64329) || (inst_64331));
var state_64371__$1 = state_64371;
if(cljs.core.truth_(inst_64332)){
var statearr_64381_64417 = state_64371__$1;
(statearr_64381_64417[(1)] = (9));

} else {
var statearr_64382_64418 = state_64371__$1;
(statearr_64382_64418[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (17))){
var inst_64357 = (state_64371[(12)]);
var state_64371__$1 = state_64371;
var statearr_64383_64419 = state_64371__$1;
(statearr_64383_64419[(2)] = inst_64357);

(statearr_64383_64419[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (3))){
var inst_64369 = (state_64371[(2)]);
var state_64371__$1 = state_64371;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64371__$1,inst_64369);
} else {
if((state_val_64372 === (12))){
var inst_64323 = (state_64371[(13)]);
var inst_64341 = cljs.core.apply.call(null,cljs.core.hash_map,inst_64323);
var state_64371__$1 = state_64371;
var statearr_64384_64420 = state_64371__$1;
(statearr_64384_64420[(2)] = inst_64341);

(statearr_64384_64420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (2))){
var inst_64323 = (state_64371[(13)]);
var _ = (function (){var statearr_64385 = state_64371;
(statearr_64385[(4)] = cljs.core.cons.call(null,(5),(state_64371[(4)])));

return statearr_64385;
})();
var inst_64323__$1 = opts;
var inst_64325 = (inst_64323__$1 == null);
var inst_64326 = cljs.core.not.call(null,inst_64325);
var state_64371__$1 = (function (){var statearr_64386 = state_64371;
(statearr_64386[(13)] = inst_64323__$1);

return statearr_64386;
})();
if(inst_64326){
var statearr_64387_64421 = state_64371__$1;
(statearr_64387_64421[(1)] = (6));

} else {
var statearr_64388_64422 = state_64371__$1;
(statearr_64388_64422[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (19))){
var inst_64361 = (state_64371[(2)]);
var inst_64362 = fluree.db.util.async.throw_err.call(null,inst_64361);
var state_64371__$1 = state_64371;
var statearr_64389_64423 = state_64371__$1;
(statearr_64389_64423[(2)] = inst_64362);

(statearr_64389_64423[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (11))){
var inst_64336 = (state_64371[(2)]);
var state_64371__$1 = state_64371;
var statearr_64391_64424 = state_64371__$1;
(statearr_64391_64424[(2)] = inst_64336);

(statearr_64391_64424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (9))){
var state_64371__$1 = state_64371;
var statearr_64392_64425 = state_64371__$1;
(statearr_64392_64425[(2)] = true);

(statearr_64392_64425[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (5))){
var _ = (function (){var statearr_64393 = state_64371;
(statearr_64393[(4)] = cljs.core.rest.call(null,(state_64371[(4)])));

return statearr_64393;
})();
var state_64371__$1 = state_64371;
var ex64390 = (state_64371__$1[(2)]);
var statearr_64394_64426 = state_64371__$1;
(statearr_64394_64426[(5)] = ex64390);


var statearr_64395_64427 = state_64371__$1;
(statearr_64395_64427[(1)] = (4));

(statearr_64395_64427[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (14))){
var inst_64344 = (state_64371[(2)]);
var inst_64345 = cljs.core.get.call(null,inst_64344,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_64346 = cljs.core.get.call(null,inst_64344,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_64347 = cljs.core.get.call(null,inst_64344,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64348 = cljs.core.get.call(null,inst_64344,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64349 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_64350 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_64351 = cljs.core.nth.call(null,inst_64350,(0),null);
var inst_64352 = cljs.core.nth.call(null,inst_64350,(1),null);
var inst_64353 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_64371__$1 = (function (){var statearr_64396 = state_64371;
(statearr_64396[(14)] = inst_64347);

(statearr_64396[(9)] = inst_64348);

(statearr_64396[(10)] = inst_64351);

(statearr_64396[(11)] = inst_64352);

(statearr_64396[(15)] = inst_64346);

(statearr_64396[(16)] = inst_64345);

(statearr_64396[(17)] = inst_64349);

return statearr_64396;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64371__$1,(15),inst_64353);
} else {
if((state_val_64372 === (16))){
var inst_64348 = (state_64371[(9)]);
var inst_64357 = (state_64371[(12)]);
var inst_64359 = fluree.db.time_travel.as_of_block.call(null,inst_64357,inst_64348);
var state_64371__$1 = state_64371;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64371__$1,(19),inst_64359);
} else {
if((state_val_64372 === (10))){
var state_64371__$1 = state_64371;
var statearr_64397_64428 = state_64371__$1;
(statearr_64397_64428[(2)] = false);

(statearr_64397_64428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (18))){
var inst_64365 = (state_64371[(2)]);
var inst_64366 = cljs.core.async.put_BANG_.call(null,pc,inst_64365);
var _ = (function (){var statearr_64398 = state_64371;
(statearr_64398[(4)] = cljs.core.rest.call(null,(state_64371[(4)])));

return statearr_64398;
})();
var state_64371__$1 = state_64371;
var statearr_64399_64429 = state_64371__$1;
(statearr_64399_64429[(2)] = inst_64366);

(statearr_64399_64429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64372 === (8))){
var inst_64339 = (state_64371[(2)]);
var state_64371__$1 = state_64371;
if(cljs.core.truth_(inst_64339)){
var statearr_64400_64430 = state_64371__$1;
(statearr_64400_64430[(1)] = (12));

} else {
var statearr_64401_64431 = state_64371__$1;
(statearr_64401_64431[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_64402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64402[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_64402[(1)] = (1));

return statearr_64402;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_64371){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64371);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64403){var ex__2882__auto__ = e64403;
var statearr_64404_64432 = state_64371;
(statearr_64404_64432[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64371[(4)]))){
var statearr_64405_64433 = state_64371;
(statearr_64405_64433[(1)] = cljs.core.first.call(null,(state_64371[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64434 = state_64371;
state_64371 = G__64434;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_64371){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_64371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64406 = f__2902__auto__.call(null);
(statearr_64406[(6)] = c__2901__auto___64410);

return statearr_64406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq64303){
var G__64304 = cljs.core.first.call(null,seq64303);
var seq64303__$1 = cljs.core.next.call(null,seq64303);
var G__64305 = cljs.core.first.call(null,seq64303__$1);
var seq64303__$2 = cljs.core.next.call(null,seq64303__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64304,G__64305,seq64303__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?open_api:false))){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64437 = arguments.length;
switch (G__64437) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64587){
var state_val_64588 = (state_64587[(1)]);
if((state_val_64588 === (7))){
var state_64587__$1 = state_64587;
var statearr_64589_64683 = state_64587__$1;
(statearr_64589_64683[(2)] = false);

(statearr_64589_64683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (59))){
var inst_64576 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64590_64684 = state_64587__$1;
(statearr_64590_64684[(2)] = inst_64576);

(statearr_64590_64684[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (20))){
var inst_64475 = (state_64587[(7)]);
var inst_64491 = (state_64587[(8)]);
var inst_64492 = (state_64587[(9)]);
var inst_64494 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64491);
var inst_64495 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_64492);
var inst_64496 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64491);
var inst_64497 = fluree.db.api_js.get_sources.call(null,inst_64492,inst_64494,inst_64495,inst_64496,inst_64475,db_fn);
var state_64587__$1 = state_64587;
var statearr_64591_64685 = state_64587__$1;
(statearr_64591_64685[(2)] = inst_64497);

(statearr_64591_64685[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (58))){
var state_64587__$1 = state_64587;
var statearr_64592_64686 = state_64587__$1;
(statearr_64592_64686[(2)] = null);

(statearr_64592_64686[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (27))){
var inst_64477 = (state_64587[(10)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64477)){
var statearr_64593_64687 = state_64587__$1;
(statearr_64593_64687[(1)] = (29));

} else {
var statearr_64594_64688 = state_64587__$1;
(statearr_64594_64688[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (1))){
var state_64587__$1 = state_64587;
var statearr_64595_64689 = state_64587__$1;
(statearr_64595_64689[(2)] = null);

(statearr_64595_64689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (24))){
var state_64587__$1 = state_64587;
var statearr_64596_64690 = state_64587__$1;
(statearr_64596_64690[(2)] = (1000000));

(statearr_64596_64690[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (55))){
var inst_64545 = (state_64587[(11)]);
var state_64587__$1 = state_64587;
var statearr_64597_64691 = state_64587__$1;
(statearr_64597_64691[(2)] = inst_64545);

(statearr_64597_64691[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (39))){
var inst_64526 = (state_64587[(12)]);
var state_64587__$1 = state_64587;
var statearr_64598_64692 = state_64587__$1;
(statearr_64598_64692[(2)] = inst_64526);

(statearr_64598_64692[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (46))){
var inst_64582 = (state_64587[(2)]);
var _ = (function (){var statearr_64599 = state_64587;
(statearr_64599[(4)] = cljs.core.rest.call(null,(state_64587[(4)])));

return statearr_64599;
})();
var state_64587__$1 = state_64587;
var statearr_64600_64693 = state_64587__$1;
(statearr_64600_64693[(2)] = inst_64582);

(statearr_64600_64693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (4))){
var inst_64438 = (state_64587[(2)]);
var inst_64439 = fluree.db.util.log.error.call(null,inst_64438);
var inst_64440 = cljs.core.ex_data.call(null,inst_64438);
var inst_64441 = cljs.core.ex_message.call(null,inst_64438);
var inst_64442 = cljs.core.assoc.call(null,inst_64440,new cljs.core.Keyword(null,"message","message",-406056002),inst_64441);
var state_64587__$1 = (function (){var statearr_64601 = state_64587;
(statearr_64601[(13)] = inst_64439);

return statearr_64601;
})();
var statearr_64602_64694 = state_64587__$1;
(statearr_64602_64694[(2)] = inst_64442);

(statearr_64602_64694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (54))){
var inst_64545 = (state_64587[(11)]);
var inst_64559 = cljs.core.doall.call(null,inst_64545);
var state_64587__$1 = state_64587;
var statearr_64603_64695 = state_64587__$1;
(statearr_64603_64695[(2)] = inst_64559);

(statearr_64603_64695[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (15))){
var inst_64473 = (state_64587[(14)]);
var inst_64482 = (state_64587[(2)]);
var inst_64483 = fluree.db.util.async.throw_err.call(null,inst_64482);
var state_64587__$1 = (function (){var statearr_64604 = state_64587;
(statearr_64604[(15)] = inst_64483);

return statearr_64604;
})();
if(cljs.core.truth_(inst_64473)){
var statearr_64605_64696 = state_64587__$1;
(statearr_64605_64696[(1)] = (16));

} else {
var statearr_64606_64697 = state_64587__$1;
(statearr_64606_64697[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (48))){
var inst_64545 = (state_64587[(11)]);
var inst_64548 = cljs.core.ex_data.call(null,inst_64545);
var inst_64549 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64550 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64548);
var inst_64551 = cljs.core.ex_message.call(null,inst_64545);
var inst_64552 = [inst_64550,inst_64551,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64553 = cljs.core.PersistentHashMap.fromArrays(inst_64549,inst_64552);
var state_64587__$1 = state_64587;
var statearr_64607_64698 = state_64587__$1;
(statearr_64607_64698[(2)] = inst_64553);

(statearr_64607_64698[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (50))){
var inst_64580 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64608_64699 = state_64587__$1;
(statearr_64608_64699[(2)] = inst_64580);

(statearr_64608_64699[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (21))){
var inst_64499 = cljs.core.PersistentHashMap.EMPTY;
var state_64587__$1 = state_64587;
var statearr_64609_64700 = state_64587__$1;
(statearr_64609_64700[(2)] = inst_64499);

(statearr_64609_64700[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (31))){
var inst_64524 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64610_64701 = state_64587__$1;
(statearr_64610_64701[(2)] = inst_64524);

(statearr_64610_64701[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (32))){
var inst_64476 = (state_64587[(16)]);
var state_64587__$1 = state_64587;
var statearr_64611_64702 = state_64587__$1;
(statearr_64611_64702[(2)] = inst_64476);

(statearr_64611_64702[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (40))){
var inst_64534 = (state_64587[(17)]);
var inst_64534__$1 = (state_64587[(2)]);
var inst_64535 = cljs.core.not.call(null,inst_64534__$1);
var state_64587__$1 = (function (){var statearr_64612 = state_64587;
(statearr_64612[(17)] = inst_64534__$1);

return statearr_64612;
})();
if(inst_64535){
var statearr_64613_64703 = state_64587__$1;
(statearr_64613_64703[(1)] = (44));

} else {
var statearr_64614_64704 = state_64587__$1;
(statearr_64614_64704[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (56))){
var inst_64470 = (state_64587[(18)]);
var inst_64502 = (state_64587[(19)]);
var inst_64473 = (state_64587[(14)]);
var inst_64534 = (state_64587[(17)]);
var inst_64480 = (state_64587[(20)]);
var inst_64477 = (state_64587[(10)]);
var inst_64475 = (state_64587[(7)]);
var inst_64491 = (state_64587[(8)]);
var inst_64556 = (state_64587[(21)]);
var inst_64474 = (state_64587[(22)]);
var inst_64478 = (state_64587[(23)]);
var inst_64509 = (state_64587[(24)]);
var inst_64508 = (state_64587[(25)]);
var inst_64492 = (state_64587[(9)]);
var inst_64483 = (state_64587[(15)]);
var inst_64507 = (state_64587[(26)]);
var inst_64501 = (state_64587[(27)]);
var inst_64510 = (state_64587[(28)]);
var inst_64545 = (state_64587[(11)]);
var inst_64476 = (state_64587[(16)]);
var inst_64472 = (state_64587[(29)]);
var inst_64471 = (state_64587[(30)]);
var inst_64546 = (state_64587[(31)]);
var inst_64562 = (state_64587[(2)]);
var inst_64563 = cljs.core.deref.call(null,inst_64502);
var inst_64564 = (function (){var error_QMARK_ = inst_64546;
var construct = inst_64471;
var map__64448 = inst_64470;
var valid_query_QMARK_ = inst_64534;
var conn = inst_64492;
var select = inst_64472;
var block = inst_64473;
var where = inst_64474;
var prefixes = inst_64475;
var db = inst_64483;
var meta_QMARK_ = inst_64508;
var source_opts = inst_64501;
var fuel = inst_64502;
var db_STAR_ = inst_64491;
var selectDistinct = inst_64476;
var result = inst_64545;
var start_ms = inst_64509;
var selectOne = inst_64477;
var from = inst_64478;
var max_fuel = inst_64507;
var opts = inst_64510;
var selectReduced = inst_64480;
return (function (p1__64435_SHARP_){
return goog.string.format("%.2fms",p1__64435_SHARP_);
});
})();
var inst_64565 = fluree.db.util.core.current_time_millis.call(null);
var inst_64566 = (inst_64565 - inst_64509);
var inst_64567 = (inst_64566 / (1000000));
var inst_64568 = inst_64564.call(null,inst_64567);
var inst_64569 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64491);
var inst_64570 = [(200),inst_64562,inst_64563,inst_64568,inst_64569];
var inst_64571 = cljs.core.PersistentHashMap.fromArrays(inst_64556,inst_64570);
var state_64587__$1 = state_64587;
var statearr_64615_64705 = state_64587__$1;
(statearr_64615_64705[(2)] = inst_64571);

(statearr_64615_64705[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (33))){
var inst_64480 = (state_64587[(20)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64480)){
var statearr_64616_64706 = state_64587__$1;
(statearr_64616_64706[(1)] = (35));

} else {
var statearr_64617_64707 = state_64587__$1;
(statearr_64617_64707[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (13))){
var inst_64449 = (state_64587[(32)]);
var state_64587__$1 = state_64587;
var statearr_64618_64708 = state_64587__$1;
(statearr_64618_64708[(2)] = inst_64449);

(statearr_64618_64708[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (22))){
var inst_64479 = (state_64587[(33)]);
var inst_64503 = (state_64587[(34)]);
var inst_64501 = (state_64587[(2)]);
var inst_64502 = cljs.core.volatile_BANG_.call(null,(0));
var inst_64503__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64479);
var state_64587__$1 = (function (){var statearr_64619 = state_64587;
(statearr_64619[(19)] = inst_64502);

(statearr_64619[(34)] = inst_64503__$1);

(statearr_64619[(27)] = inst_64501);

return statearr_64619;
})();
if(cljs.core.truth_(inst_64503__$1)){
var statearr_64620_64709 = state_64587__$1;
(statearr_64620_64709[(1)] = (23));

} else {
var statearr_64621_64710 = state_64587__$1;
(statearr_64621_64710[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (36))){
var inst_64471 = (state_64587[(30)]);
var state_64587__$1 = state_64587;
var statearr_64622_64711 = state_64587__$1;
(statearr_64622_64711[(2)] = inst_64471);

(statearr_64622_64711[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (41))){
var inst_64478 = (state_64587[(23)]);
var state_64587__$1 = state_64587;
var statearr_64623_64712 = state_64587__$1;
(statearr_64623_64712[(2)] = inst_64478);

(statearr_64623_64712[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (43))){
var inst_64531 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64624_64713 = state_64587__$1;
(statearr_64624_64713[(2)] = inst_64531);

(statearr_64624_64713[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (29))){
var inst_64477 = (state_64587[(10)]);
var state_64587__$1 = state_64587;
var statearr_64625_64714 = state_64587__$1;
(statearr_64625_64714[(2)] = inst_64477);

(statearr_64625_64714[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (44))){
var inst_64537 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64538 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64539 = cljs.core.PersistentHashMap.fromArrays(inst_64537,inst_64538);
var state_64587__$1 = state_64587;
var statearr_64626_64715 = state_64587__$1;
(statearr_64626_64715[(2)] = inst_64539);

(statearr_64626_64715[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (6))){
var inst_64449 = (state_64587[(32)]);
var inst_64454 = inst_64449.cljs$lang$protocol_mask$partition0$;
var inst_64455 = (inst_64454 & (64));
var inst_64456 = inst_64449.cljs$core$ISeq$;
var inst_64457 = (cljs.core.PROTOCOL_SENTINEL === inst_64456);
var inst_64458 = ((inst_64455) || (inst_64457));
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64458)){
var statearr_64627_64716 = state_64587__$1;
(statearr_64627_64716[(1)] = (9));

} else {
var statearr_64628_64717 = state_64587__$1;
(statearr_64628_64717[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (28))){
var inst_64526 = (state_64587[(12)]);
var inst_64526__$1 = (state_64587[(2)]);
var state_64587__$1 = (function (){var statearr_64629 = state_64587;
(statearr_64629[(12)] = inst_64526__$1);

return statearr_64629;
})();
if(cljs.core.truth_(inst_64526__$1)){
var statearr_64630_64718 = state_64587__$1;
(statearr_64630_64718[(1)] = (38));

} else {
var statearr_64631_64719 = state_64587__$1;
(statearr_64631_64719[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (51))){
var inst_64545 = (state_64587[(11)]);
var inst_64556 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64557 = cljs.core.sequential_QMARK_.call(null,inst_64545);
var state_64587__$1 = (function (){var statearr_64632 = state_64587;
(statearr_64632[(21)] = inst_64556);

return statearr_64632;
})();
if(inst_64557){
var statearr_64633_64720 = state_64587__$1;
(statearr_64633_64720[(1)] = (54));

} else {
var statearr_64634_64721 = state_64587__$1;
(statearr_64634_64721[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (25))){
var inst_64502 = (state_64587[(19)]);
var inst_64479 = (state_64587[(33)]);
var inst_64507 = (state_64587[(26)]);
var inst_64501 = (state_64587[(27)]);
var inst_64472 = (state_64587[(29)]);
var inst_64507__$1 = (state_64587[(2)]);
var inst_64508 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64479);
var inst_64509 = fluree.db.util.core.current_time_millis.call(null);
var inst_64510 = cljs.core.assoc.call(null,inst_64479,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64501,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64507__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64502);
var state_64587__$1 = (function (){var statearr_64635 = state_64587;
(statearr_64635[(24)] = inst_64509);

(statearr_64635[(25)] = inst_64508);

(statearr_64635[(26)] = inst_64507__$1);

(statearr_64635[(28)] = inst_64510);

return statearr_64635;
})();
if(cljs.core.truth_(inst_64472)){
var statearr_64636_64722 = state_64587__$1;
(statearr_64636_64722[(1)] = (26));

} else {
var statearr_64637_64723 = state_64587__$1;
(statearr_64637_64723[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (34))){
var inst_64522 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64638_64724 = state_64587__$1;
(statearr_64638_64724[(2)] = inst_64522);

(statearr_64638_64724[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (17))){
var inst_64483 = (state_64587[(15)]);
var state_64587__$1 = state_64587;
var statearr_64639_64725 = state_64587__$1;
(statearr_64639_64725[(2)] = inst_64483);

(statearr_64639_64725[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (3))){
var inst_64585 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64587__$1,inst_64585);
} else {
if((state_val_64588 === (12))){
var inst_64449 = (state_64587[(32)]);
var inst_64467 = cljs.core.apply.call(null,cljs.core.hash_map,inst_64449);
var state_64587__$1 = state_64587;
var statearr_64640_64726 = state_64587__$1;
(statearr_64640_64726[(2)] = inst_64467);

(statearr_64640_64726[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (2))){
var inst_64449 = (state_64587[(32)]);
var _ = (function (){var statearr_64641 = state_64587;
(statearr_64641[(4)] = cljs.core.cons.call(null,(5),(state_64587[(4)])));

return statearr_64641;
})();
var inst_64449__$1 = query_map;
var inst_64451 = (inst_64449__$1 == null);
var inst_64452 = cljs.core.not.call(null,inst_64451);
var state_64587__$1 = (function (){var statearr_64642 = state_64587;
(statearr_64642[(32)] = inst_64449__$1);

return statearr_64642;
})();
if(inst_64452){
var statearr_64643_64727 = state_64587__$1;
(statearr_64643_64727[(1)] = (6));

} else {
var statearr_64644_64728 = state_64587__$1;
(statearr_64644_64728[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (23))){
var inst_64503 = (state_64587[(34)]);
var state_64587__$1 = state_64587;
var statearr_64645_64729 = state_64587__$1;
(statearr_64645_64729[(2)] = inst_64503);

(statearr_64645_64729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (47))){
var inst_64545 = (state_64587[(11)]);
var inst_64546 = (state_64587[(31)]);
var inst_64544 = (state_64587[(2)]);
var inst_64545__$1 = fluree.db.util.async.throw_err.call(null,inst_64544);
var inst_64546__$1 = (inst_64545__$1 instanceof cljs.core.ExceptionInfo);
var state_64587__$1 = (function (){var statearr_64646 = state_64587;
(statearr_64646[(11)] = inst_64545__$1);

(statearr_64646[(31)] = inst_64546__$1);

return statearr_64646;
})();
if(cljs.core.truth_(inst_64546__$1)){
var statearr_64647_64730 = state_64587__$1;
(statearr_64647_64730[(1)] = (48));

} else {
var statearr_64648_64731 = state_64587__$1;
(statearr_64648_64731[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (35))){
var inst_64480 = (state_64587[(20)]);
var state_64587__$1 = state_64587;
var statearr_64649_64732 = state_64587__$1;
(statearr_64649_64732[(2)] = inst_64480);

(statearr_64649_64732[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (19))){
var inst_64487 = (state_64587[(2)]);
var inst_64488 = fluree.db.util.async.throw_err.call(null,inst_64487);
var state_64587__$1 = state_64587;
var statearr_64650_64733 = state_64587__$1;
(statearr_64650_64733[(2)] = inst_64488);

(statearr_64650_64733[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (57))){
var inst_64545 = (state_64587[(11)]);
var state_64587__$1 = state_64587;
var statearr_64651_64734 = state_64587__$1;
(statearr_64651_64734[(2)] = inst_64545);

(statearr_64651_64734[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (11))){
var inst_64462 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64653_64735 = state_64587__$1;
(statearr_64653_64735[(2)] = inst_64462);

(statearr_64653_64735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (9))){
var state_64587__$1 = state_64587;
var statearr_64654_64736 = state_64587__$1;
(statearr_64654_64736[(2)] = true);

(statearr_64654_64736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (5))){
var _ = (function (){var statearr_64655 = state_64587;
(statearr_64655[(4)] = cljs.core.rest.call(null,(state_64587[(4)])));

return statearr_64655;
})();
var state_64587__$1 = state_64587;
var ex64652 = (state_64587__$1[(2)]);
var statearr_64656_64737 = state_64587__$1;
(statearr_64656_64737[(5)] = ex64652);


var statearr_64657_64738 = state_64587__$1;
(statearr_64657_64738[(1)] = (4));

(statearr_64657_64738[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (14))){
var inst_64470 = (state_64587[(18)]);
var inst_64470__$1 = (state_64587[(2)]);
var inst_64471 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64472 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64473 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64474 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64475 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64476 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64477 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64478 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64479 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64480 = cljs.core.get.call(null,inst_64470__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64587__$1 = (function (){var statearr_64658 = state_64587;
(statearr_64658[(18)] = inst_64470__$1);

(statearr_64658[(14)] = inst_64473);

(statearr_64658[(33)] = inst_64479);

(statearr_64658[(20)] = inst_64480);

(statearr_64658[(10)] = inst_64477);

(statearr_64658[(7)] = inst_64475);

(statearr_64658[(22)] = inst_64474);

(statearr_64658[(23)] = inst_64478);

(statearr_64658[(16)] = inst_64476);

(statearr_64658[(29)] = inst_64472);

(statearr_64658[(30)] = inst_64471);

return statearr_64658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64587__$1,(15),sources);
} else {
if((state_val_64588 === (45))){
var inst_64491 = (state_64587[(8)]);
var inst_64510 = (state_64587[(28)]);
var inst_64541 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64510);
var inst_64542 = fluree.db.query.fql.query.call(null,inst_64491,inst_64541);
var state_64587__$1 = state_64587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64587__$1,(47),inst_64542);
} else {
if((state_val_64588 === (53))){
var inst_64578 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64659_64739 = state_64587__$1;
(statearr_64659_64739[(2)] = inst_64578);

(statearr_64659_64739[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (26))){
var inst_64472 = (state_64587[(29)]);
var state_64587__$1 = state_64587;
var statearr_64660_64740 = state_64587__$1;
(statearr_64660_64740[(2)] = inst_64472);

(statearr_64660_64740[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (16))){
var inst_64473 = (state_64587[(14)]);
var inst_64483 = (state_64587[(15)]);
var inst_64485 = fluree.db.time_travel.as_of_block.call(null,inst_64483,inst_64473);
var state_64587__$1 = state_64587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64587__$1,(19),inst_64485);
} else {
if((state_val_64588 === (38))){
var inst_64478 = (state_64587[(23)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64478)){
var statearr_64661_64741 = state_64587__$1;
(statearr_64661_64741[(1)] = (41));

} else {
var statearr_64662_64742 = state_64587__$1;
(statearr_64662_64742[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (30))){
var inst_64476 = (state_64587[(16)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64476)){
var statearr_64663_64743 = state_64587__$1;
(statearr_64663_64743[(1)] = (32));

} else {
var statearr_64664_64744 = state_64587__$1;
(statearr_64664_64744[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (10))){
var state_64587__$1 = state_64587;
var statearr_64665_64745 = state_64587__$1;
(statearr_64665_64745[(2)] = false);

(statearr_64665_64745[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (18))){
var inst_64475 = (state_64587[(7)]);
var inst_64491 = (state_64587[(8)]);
var inst_64491__$1 = (state_64587[(2)]);
var inst_64492 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64491__$1);
var state_64587__$1 = (function (){var statearr_64666 = state_64587;
(statearr_64666[(8)] = inst_64491__$1);

(statearr_64666[(9)] = inst_64492);

return statearr_64666;
})();
if(cljs.core.truth_(inst_64475)){
var statearr_64667_64746 = state_64587__$1;
(statearr_64667_64746[(1)] = (20));

} else {
var statearr_64668_64747 = state_64587__$1;
(statearr_64668_64747[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (52))){
var state_64587__$1 = state_64587;
var statearr_64669_64748 = state_64587__$1;
(statearr_64669_64748[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (42))){
var inst_64474 = (state_64587[(22)]);
var state_64587__$1 = state_64587;
var statearr_64671_64749 = state_64587__$1;
(statearr_64671_64749[(2)] = inst_64474);

(statearr_64671_64749[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (37))){
var inst_64520 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
var statearr_64672_64750 = state_64587__$1;
(statearr_64672_64750[(2)] = inst_64520);

(statearr_64672_64750[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (8))){
var inst_64465 = (state_64587[(2)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64465)){
var statearr_64673_64751 = state_64587__$1;
(statearr_64673_64751[(1)] = (12));

} else {
var statearr_64674_64752 = state_64587__$1;
(statearr_64674_64752[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64588 === (49))){
var inst_64508 = (state_64587[(25)]);
var state_64587__$1 = state_64587;
if(cljs.core.truth_(inst_64508)){
var statearr_64675_64753 = state_64587__$1;
(statearr_64675_64753[(1)] = (51));

} else {
var statearr_64676_64754 = state_64587__$1;
(statearr_64676_64754[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_64677 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64677[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_64677[(1)] = (1));

return statearr_64677;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_64587){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64678){var ex__2882__auto__ = e64678;
var statearr_64679_64755 = state_64587;
(statearr_64679_64755[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64587[(4)]))){
var statearr_64680_64756 = state_64587;
(statearr_64680_64756[(1)] = cljs.core.first.call(null,(state_64587[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64757 = state_64587;
state_64587 = G__64757;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_64587){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_64587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64681 = f__2902__auto__.call(null);
(statearr_64681[(6)] = c__2901__auto__);

return statearr_64681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__64758_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__64758_SHARP_);
}));

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64780){
var state_val_64781 = (state_64780[(1)]);
if((state_val_64781 === (1))){
var inst_64762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64763 = [resp_chan,timeout_chan];
var inst_64764 = (new cljs.core.PersistentVector(null,2,(5),inst_64762,inst_64763,null));
var state_64780__$1 = state_64780;
return cljs.core.async.ioc_alts_BANG_.call(null,state_64780__$1,(2),inst_64764);
} else {
if((state_val_64781 === (2))){
var inst_64766 = (state_64780[(2)]);
var inst_64767 = cljs.core.nth.call(null,inst_64766,(0),null);
var inst_64768 = cljs.core.nth.call(null,inst_64766,(1),null);
var inst_64769 = cljs.core._EQ_.call(null,timeout_chan,inst_64768);
var state_64780__$1 = (function (){var statearr_64782 = state_64780;
(statearr_64782[(7)] = inst_64767);

return statearr_64782;
})();
if(inst_64769){
var statearr_64783_64793 = state_64780__$1;
(statearr_64783_64793[(1)] = (3));

} else {
var statearr_64784_64794 = state_64780__$1;
(statearr_64784_64794[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (3))){
var inst_64771 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_64772 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64773 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64774 = [tid,(408),inst_64773];
var inst_64775 = cljs.core.PersistentHashMap.fromArrays(inst_64772,inst_64774);
var state_64780__$1 = (function (){var statearr_64785 = state_64780;
(statearr_64785[(8)] = inst_64771);

return statearr_64785;
})();
var statearr_64786_64795 = state_64780__$1;
(statearr_64786_64795[(2)] = inst_64775);

(statearr_64786_64795[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (4))){
var inst_64767 = (state_64780[(7)]);
var state_64780__$1 = state_64780;
var statearr_64787_64796 = state_64780__$1;
(statearr_64787_64796[(2)] = inst_64767);

(statearr_64787_64796[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (5))){
var inst_64778 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64780__$1,inst_64778);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0 = (function (){
var statearr_64788 = [null,null,null,null,null,null,null,null,null];
(statearr_64788[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__);

(statearr_64788[(1)] = (1));

return statearr_64788;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1 = (function (state_64780){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64789){var ex__2882__auto__ = e64789;
var statearr_64790_64797 = state_64780;
(statearr_64790_64797[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64780[(4)]))){
var statearr_64791_64798 = state_64780;
(statearr_64791_64798[(1)] = cljs.core.first.call(null,(state_64780[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64799 = state_64780;
state_64780 = G__64799;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__ = function(state_64780){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1.call(this,state_64780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64792 = f__2902__auto__.call(null);
(statearr_64792[(6)] = c__2901__auto__);

return statearr_64792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64801 = arguments.length;
switch (G__64801) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__64802 = opts;
var map__64802__$1 = (((((!((map__64802 == null))))?(((((map__64802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64802):map__64802);
var auth = cljs.core.get.call(null,map__64802__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__64802__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__64802__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__64802__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__64803 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__64803,(0),null);
var authority = cljs.core.nth.call(null,vec__64803,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64807){var e = e64807;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64810 = arguments.length;
switch (G__64810) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64896){
var state_val_64897 = (state_64896[(1)]);
if((state_val_64897 === (7))){
var state_64896__$1 = state_64896;
var statearr_64898_64947 = state_64896__$1;
(statearr_64898_64947[(2)] = false);

(statearr_64898_64947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (20))){
var inst_64863 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
var statearr_64899_64948 = state_64896__$1;
(statearr_64899_64948[(2)] = inst_64863);

(statearr_64899_64948[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (27))){
var inst_64876 = (state_64896[(7)]);
var inst_64879 = cljs.core.ex_data.call(null,inst_64876);
var inst_64880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64881 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64879);
var inst_64882 = cljs.core.ex_message.call(null,inst_64876);
var inst_64883 = [inst_64881,inst_64882,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64884 = cljs.core.PersistentHashMap.fromArrays(inst_64880,inst_64883);
var state_64896__$1 = state_64896;
var statearr_64900_64949 = state_64896__$1;
(statearr_64900_64949[(2)] = inst_64884);

(statearr_64900_64949[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (1))){
var state_64896__$1 = state_64896;
var statearr_64901_64950 = state_64896__$1;
(statearr_64901_64950[(2)] = null);

(statearr_64901_64950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (24))){
var inst_64846 = (state_64896[(8)]);
var inst_64871 = (state_64896[(9)]);
var inst_64874 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64871,inst_64846);
var state_64896__$1 = state_64896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64896__$1,(26),inst_64874);
} else {
if((state_val_64897 === (4))){
var inst_64811 = (state_64896[(2)]);
var inst_64812 = fluree.db.util.log.error.call(null,inst_64811);
var inst_64813 = cljs.core.ex_data.call(null,inst_64811);
var inst_64814 = cljs.core.ex_message.call(null,inst_64811);
var inst_64815 = cljs.core.assoc.call(null,inst_64813,new cljs.core.Keyword(null,"message","message",-406056002),inst_64814);
var state_64896__$1 = (function (){var statearr_64902 = state_64896;
(statearr_64902[(10)] = inst_64812);

return statearr_64902;
})();
var statearr_64903_64951 = state_64896__$1;
(statearr_64903_64951[(2)] = inst_64815);

(statearr_64903_64951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (15))){
var inst_64845 = (state_64896[(11)]);
var inst_64844 = (state_64896[(12)]);
var inst_64854 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_64844,opts);
var inst_64855 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64854);
var inst_64856 = fluree.db.operations.command_async.call(null,conn,inst_64854);
var state_64896__$1 = (function (){var statearr_64904 = state_64896;
(statearr_64904[(13)] = inst_64856);

(statearr_64904[(14)] = inst_64855);

return statearr_64904;
})();
if(cljs.core.truth_(inst_64845)){
var statearr_64905_64952 = state_64896__$1;
(statearr_64905_64952[(1)] = (18));

} else {
var statearr_64906_64953 = state_64896__$1;
(statearr_64906_64953[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (21))){
var inst_64861 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
var statearr_64907_64954 = state_64896__$1;
(statearr_64907_64954[(2)] = inst_64861);

(statearr_64907_64954[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (13))){
var inst_64822 = (state_64896[(15)]);
var state_64896__$1 = state_64896;
var statearr_64908_64955 = state_64896__$1;
(statearr_64908_64955[(2)] = inst_64822);

(statearr_64908_64955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (22))){
var inst_64845 = (state_64896[(11)]);
var inst_64871 = (state_64896[(2)]);
var state_64896__$1 = (function (){var statearr_64909 = state_64896;
(statearr_64909[(9)] = inst_64871);

return statearr_64909;
})();
if(cljs.core.truth_(inst_64845)){
var statearr_64910_64956 = state_64896__$1;
(statearr_64910_64956[(1)] = (23));

} else {
var statearr_64911_64957 = state_64896__$1;
(statearr_64911_64957[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (29))){
var inst_64887 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
var statearr_64912_64958 = state_64896__$1;
(statearr_64912_64958[(2)] = inst_64887);

(statearr_64912_64958[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (6))){
var inst_64822 = (state_64896[(15)]);
var inst_64827 = inst_64822.cljs$lang$protocol_mask$partition0$;
var inst_64828 = (inst_64827 & (64));
var inst_64829 = inst_64822.cljs$core$ISeq$;
var inst_64830 = (cljs.core.PROTOCOL_SENTINEL === inst_64829);
var inst_64831 = ((inst_64828) || (inst_64830));
var state_64896__$1 = state_64896;
if(cljs.core.truth_(inst_64831)){
var statearr_64913_64959 = state_64896__$1;
(statearr_64913_64959[(1)] = (9));

} else {
var statearr_64914_64960 = state_64896__$1;
(statearr_64914_64960[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (28))){
var inst_64876 = (state_64896[(7)]);
var state_64896__$1 = state_64896;
var statearr_64915_64961 = state_64896__$1;
(statearr_64915_64961[(2)] = inst_64876);

(statearr_64915_64961[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (25))){
var inst_64889 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
var statearr_64916_64962 = state_64896__$1;
(statearr_64916_64962[(2)] = inst_64889);

(statearr_64916_64962[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (17))){
var inst_64891 = (state_64896[(2)]);
var _ = (function (){var statearr_64917 = state_64896;
(statearr_64917[(4)] = cljs.core.rest.call(null,(state_64896[(4)])));

return statearr_64917;
})();
var state_64896__$1 = state_64896;
var statearr_64918_64963 = state_64896__$1;
(statearr_64918_64963[(2)] = inst_64891);

(statearr_64918_64963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (3))){
var inst_64894 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64896__$1,inst_64894);
} else {
if((state_val_64897 === (12))){
var inst_64822 = (state_64896[(15)]);
var inst_64840 = cljs.core.apply.call(null,cljs.core.hash_map,inst_64822);
var state_64896__$1 = state_64896;
var statearr_64919_64964 = state_64896__$1;
(statearr_64919_64964[(2)] = inst_64840);

(statearr_64919_64964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (2))){
var inst_64822 = (state_64896[(15)]);
var _ = (function (){var statearr_64920 = state_64896;
(statearr_64920[(4)] = cljs.core.cons.call(null,(5),(state_64896[(4)])));

return statearr_64920;
})();
var inst_64822__$1 = opts;
var inst_64824 = (inst_64822__$1 == null);
var inst_64825 = cljs.core.not.call(null,inst_64824);
var state_64896__$1 = (function (){var statearr_64921 = state_64896;
(statearr_64921[(15)] = inst_64822__$1);

return statearr_64921;
})();
if(inst_64825){
var statearr_64922_64965 = state_64896__$1;
(statearr_64922_64965[(1)] = (6));

} else {
var statearr_64923_64966 = state_64896__$1;
(statearr_64923_64966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (23))){
var inst_64871 = (state_64896[(9)]);
var state_64896__$1 = state_64896;
var statearr_64924_64967 = state_64896__$1;
(statearr_64924_64967[(2)] = inst_64871);

(statearr_64924_64967[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (19))){
var inst_64846 = (state_64896[(8)]);
var inst_64855 = (state_64896[(14)]);
var inst_64859 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64855,inst_64846);
var state_64896__$1 = state_64896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64896__$1,(21),inst_64859);
} else {
if((state_val_64897 === (11))){
var inst_64835 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
var statearr_64926_64968 = state_64896__$1;
(statearr_64926_64968[(2)] = inst_64835);

(statearr_64926_64968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (9))){
var state_64896__$1 = state_64896;
var statearr_64927_64969 = state_64896__$1;
(statearr_64927_64969[(2)] = true);

(statearr_64927_64969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (5))){
var _ = (function (){var statearr_64928 = state_64896;
(statearr_64928[(4)] = cljs.core.rest.call(null,(state_64896[(4)])));

return statearr_64928;
})();
var state_64896__$1 = state_64896;
var ex64925 = (state_64896__$1[(2)]);
var statearr_64929_64970 = state_64896__$1;
(statearr_64929_64970[(5)] = ex64925);


var statearr_64930_64971 = state_64896__$1;
(statearr_64930_64971[(1)] = (4));

(statearr_64930_64971[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (14))){
var inst_64844 = (state_64896[(12)]);
var inst_64843 = (state_64896[(2)]);
var inst_64844__$1 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64845 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64846 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64847 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64848 = fluree.db.util.core.current_time_millis.call(null);
var inst_64849 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64848);
var inst_64850 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64851 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64852 = cljs.core.get.call(null,inst_64843,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64896__$1 = (function (){var statearr_64931 = state_64896;
(statearr_64931[(16)] = inst_64849);

(statearr_64931[(11)] = inst_64845);

(statearr_64931[(8)] = inst_64846);

(statearr_64931[(12)] = inst_64844__$1);

(statearr_64931[(17)] = inst_64850);

(statearr_64931[(18)] = inst_64847);

(statearr_64931[(19)] = inst_64851);

(statearr_64931[(20)] = inst_64852);

return statearr_64931;
})();
if(cljs.core.truth_(inst_64844__$1)){
var statearr_64932_64972 = state_64896__$1;
(statearr_64932_64972[(1)] = (15));

} else {
var statearr_64933_64973 = state_64896__$1;
(statearr_64933_64973[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (26))){
var inst_64876 = (state_64896[(7)]);
var inst_64876__$1 = (state_64896[(2)]);
var inst_64877 = (inst_64876__$1 instanceof cljs.core.ExceptionInfo);
var state_64896__$1 = (function (){var statearr_64934 = state_64896;
(statearr_64934[(7)] = inst_64876__$1);

return statearr_64934;
})();
if(cljs.core.truth_(inst_64877)){
var statearr_64935_64974 = state_64896__$1;
(statearr_64935_64974[(1)] = (27));

} else {
var statearr_64936_64975 = state_64896__$1;
(statearr_64936_64975[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (16))){
var inst_64849 = (state_64896[(16)]);
var inst_64850 = (state_64896[(17)]);
var inst_64847 = (state_64896[(18)]);
var inst_64851 = (state_64896[(19)]);
var inst_64852 = (state_64896[(20)]);
var inst_64865 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64866 = [ledger,txn,inst_64847,inst_64849,inst_64850,inst_64851,inst_64852];
var inst_64867 = cljs.core.PersistentHashMap.fromArrays(inst_64865,inst_64866);
var inst_64868 = fluree.db.util.core.without_nils.call(null,inst_64867);
var inst_64869 = fluree.db.operations.transact_async.call(null,conn,inst_64868);
var state_64896__$1 = state_64896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64896__$1,(22),inst_64869);
} else {
if((state_val_64897 === (10))){
var state_64896__$1 = state_64896;
var statearr_64937_64976 = state_64896__$1;
(statearr_64937_64976[(2)] = false);

(statearr_64937_64976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (18))){
var inst_64856 = (state_64896[(13)]);
var state_64896__$1 = state_64896;
var statearr_64938_64977 = state_64896__$1;
(statearr_64938_64977[(2)] = inst_64856);

(statearr_64938_64977[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64897 === (8))){
var inst_64838 = (state_64896[(2)]);
var state_64896__$1 = state_64896;
if(cljs.core.truth_(inst_64838)){
var statearr_64939_64978 = state_64896__$1;
(statearr_64939_64978[(1)] = (12));

} else {
var statearr_64940_64979 = state_64896__$1;
(statearr_64940_64979[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_64941 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64941[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_64941[(1)] = (1));

return statearr_64941;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_64896){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64942){var ex__2882__auto__ = e64942;
var statearr_64943_64980 = state_64896;
(statearr_64943_64980[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64896[(4)]))){
var statearr_64944_64981 = state_64896;
(statearr_64944_64981[(1)] = cljs.core.first.call(null,(state_64896[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64982 = state_64896;
state_64896 = G__64982;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_64896){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_64896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64945 = f__2902__auto__.call(null);
(statearr_64945[(6)] = c__2901__auto__);

return statearr_64945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64984 = arguments.length;
var i__4737__auto___64985 = (0);
while(true){
if((i__4737__auto___64985 < len__4736__auto___64984)){
args__4742__auto__.push((arguments[i__4737__auto___64985]));

var G__64986 = (i__4737__auto___64985 + (1));
i__4737__auto___64985 = G__64986;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64983){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq64983));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65017){
var state_val_65018 = (state_65017[(1)]);
if((state_val_65018 === (1))){
var inst_64987 = cljs.core.first.call(null,flakes);
var inst_64988 = cljs.core.rest.call(null,flakes);
var inst_64989 = cljs.core.PersistentVector.EMPTY;
var inst_64990 = inst_64987;
var inst_64991 = inst_64988;
var inst_64992 = inst_64989;
var state_65017__$1 = (function (){var statearr_65019 = state_65017;
(statearr_65019[(7)] = inst_64992);

(statearr_65019[(8)] = inst_64991);

(statearr_65019[(9)] = inst_64990);

return statearr_65019;
})();
var statearr_65020_65033 = state_65017__$1;
(statearr_65020_65033[(2)] = null);

(statearr_65020_65033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65018 === (2))){
var inst_64990 = (state_65017[(9)]);
var inst_64994 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64995 = cljs.core.PersistentHashMap.EMPTY;
var inst_64996 = [true,inst_64995];
var inst_64997 = cljs.core.PersistentHashMap.fromArrays(inst_64994,inst_64996);
var inst_64998 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_64997,inst_64990);
var state_65017__$1 = state_65017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65017__$1,(4),inst_64998);
} else {
if((state_val_65018 === (3))){
var inst_65015 = (state_65017[(2)]);
var state_65017__$1 = state_65017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65017__$1,inst_65015);
} else {
if((state_val_65018 === (4))){
var inst_64992 = (state_65017[(7)]);
var inst_64991 = (state_65017[(8)]);
var inst_65000 = (state_65017[(2)]);
var inst_65001 = fluree.db.util.async.throw_err.call(null,inst_65000);
var inst_65002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65003 = [inst_65001];
var inst_65004 = (new cljs.core.PersistentVector(null,1,(5),inst_65002,inst_65003,null));
var inst_65005 = cljs.core.concat.call(null,inst_64992,inst_65004);
var inst_65006 = cljs.core.first.call(null,inst_64991);
var state_65017__$1 = (function (){var statearr_65021 = state_65017;
(statearr_65021[(10)] = inst_65005);

return statearr_65021;
})();
if(cljs.core.truth_(inst_65006)){
var statearr_65022_65034 = state_65017__$1;
(statearr_65022_65034[(1)] = (5));

} else {
var statearr_65023_65035 = state_65017__$1;
(statearr_65023_65035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65018 === (5))){
var inst_64991 = (state_65017[(8)]);
var inst_65005 = (state_65017[(10)]);
var inst_65008 = cljs.core.first.call(null,inst_64991);
var inst_65009 = cljs.core.rest.call(null,inst_64991);
var inst_64990 = inst_65008;
var inst_64991__$1 = inst_65009;
var inst_64992 = inst_65005;
var state_65017__$1 = (function (){var statearr_65024 = state_65017;
(statearr_65024[(7)] = inst_64992);

(statearr_65024[(8)] = inst_64991__$1);

(statearr_65024[(9)] = inst_64990);

return statearr_65024;
})();
var statearr_65025_65036 = state_65017__$1;
(statearr_65025_65036[(2)] = null);

(statearr_65025_65036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65018 === (6))){
var inst_65005 = (state_65017[(10)]);
var state_65017__$1 = state_65017;
var statearr_65026_65037 = state_65017__$1;
(statearr_65026_65037[(2)] = inst_65005);

(statearr_65026_65037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65018 === (7))){
var inst_65013 = (state_65017[(2)]);
var state_65017__$1 = state_65017;
var statearr_65027_65038 = state_65017__$1;
(statearr_65027_65038[(2)] = inst_65013);

(statearr_65027_65038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_65028 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65028[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__);

(statearr_65028[(1)] = (1));

return statearr_65028;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1 = (function (state_65017){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65029){var ex__2882__auto__ = e65029;
var statearr_65030_65039 = state_65017;
(statearr_65030_65039[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65017[(4)]))){
var statearr_65031_65040 = state_65017;
(statearr_65031_65040[(1)] = cljs.core.first.call(null,(state_65017[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65041 = state_65017;
state_65017 = G__65041;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__ = function(state_65017){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1.call(this,state_65017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65032 = f__2902__auto__.call(null);
(statearr_65032[(6)] = c__2901__auto__);

return statearr_65032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65109){
var state_val_65110 = (state_65109[(1)]);
if((state_val_65110 === (7))){
var inst_65069 = (state_65109[(2)]);
var inst_65070 = fluree.db.util.async.throw_err.call(null,inst_65069);
var state_65109__$1 = state_65109;
var statearr_65111_65137 = state_65109__$1;
(statearr_65111_65137[(2)] = inst_65070);

(statearr_65111_65137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (1))){
var inst_65046 = cljs.core.volatile_BANG_.call(null,(0));
var inst_65047 = cljs.core.PersistentHashMap.EMPTY;
var inst_65048 = cljs.core.volatile_BANG_.call(null,inst_65047);
var inst_65049 = cljs.core.first.call(null,resp);
var inst_65050 = cljs.core.rest.call(null,resp);
var inst_65051 = cljs.core.PersistentVector.EMPTY;
var inst_65052 = inst_65046;
var inst_65053 = inst_65048;
var inst_65054 = inst_65049;
var inst_65055 = inst_65050;
var inst_65056 = inst_65051;
var state_65109__$1 = (function (){var statearr_65112 = state_65109;
(statearr_65112[(7)] = inst_65053);

(statearr_65112[(8)] = inst_65056);

(statearr_65112[(9)] = inst_65054);

(statearr_65112[(10)] = inst_65052);

(statearr_65112[(11)] = inst_65055);

return statearr_65112;
})();
var statearr_65113_65138 = state_65109__$1;
(statearr_65113_65138[(2)] = null);

(statearr_65113_65138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (4))){
var inst_65053 = (state_65109[(7)]);
var inst_65056 = (state_65109[(8)]);
var inst_65060 = (state_65109[(12)]);
var inst_65058 = (state_65109[(13)]);
var inst_65054 = (state_65109[(9)]);
var inst_65052 = (state_65109[(10)]);
var inst_65055 = (state_65109[(11)]);
var inst_65064 = (function (){var fuel = inst_65052;
var cache = inst_65053;
var curr_block = inst_65054;
var rest_blocks = inst_65055;
var acc = inst_65056;
var flakes = inst_65058;
var asserted = inst_65060;
return (function (p1__65043_SHARP_){
return p1__65043_SHARP_.s;
});
})();
var inst_65065 = cljs.core.group_by.call(null,inst_65064,inst_65060);
var inst_65066 = cljs.core.vals.call(null,inst_65065);
var inst_65067 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_65053,inst_65052,inst_65066);
var state_65109__$1 = state_65109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65109__$1,(7),inst_65067);
} else {
if((state_val_65110 === (13))){
var inst_65097 = (state_65109[(14)]);
var state_65109__$1 = state_65109;
var statearr_65114_65139 = state_65109__$1;
(statearr_65114_65139[(2)] = inst_65097);

(statearr_65114_65139[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (6))){
var inst_65053 = (state_65109[(7)]);
var inst_65056 = (state_65109[(8)]);
var inst_65075 = (state_65109[(15)]);
var inst_65060 = (state_65109[(12)]);
var inst_65058 = (state_65109[(13)]);
var inst_65054 = (state_65109[(9)]);
var inst_65073 = (state_65109[(16)]);
var inst_65052 = (state_65109[(10)]);
var inst_65055 = (state_65109[(11)]);
var inst_65073__$1 = (state_65109[(2)]);
var inst_65074 = (function (){var fuel = inst_65052;
var cache = inst_65053;
var curr_block = inst_65054;
var rest_blocks = inst_65055;
var acc = inst_65056;
var flakes = inst_65058;
var asserted = inst_65060;
var asserted_SINGLEQUOTE_ = inst_65073__$1;
return (function (p1__65044_SHARP_){
return p1__65044_SHARP_.op === false;
});
})();
var inst_65075__$1 = cljs.core.filter.call(null,inst_65074,inst_65058);
var inst_65076 = cljs.core.empty_QMARK_.call(null,inst_65075__$1);
var inst_65077 = (!(inst_65076));
var state_65109__$1 = (function (){var statearr_65117 = state_65109;
(statearr_65117[(15)] = inst_65075__$1);

(statearr_65117[(16)] = inst_65073__$1);

return statearr_65117;
})();
if(inst_65077){
var statearr_65118_65140 = state_65109__$1;
(statearr_65118_65140[(1)] = (8));

} else {
var statearr_65119_65141 = state_65109__$1;
(statearr_65119_65141[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (3))){
var inst_65107 = (state_65109[(2)]);
var state_65109__$1 = state_65109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65109__$1,inst_65107);
} else {
if((state_val_65110 === (12))){
var inst_65053 = (state_65109[(7)]);
var inst_65052 = (state_65109[(10)]);
var inst_65055 = (state_65109[(11)]);
var inst_65097 = (state_65109[(14)]);
var inst_65100 = cljs.core.first.call(null,inst_65055);
var inst_65101 = cljs.core.rest.call(null,inst_65055);
var tmp65115 = inst_65053;
var tmp65116 = inst_65052;
var inst_65052__$1 = tmp65116;
var inst_65053__$1 = tmp65115;
var inst_65054 = inst_65100;
var inst_65055__$1 = inst_65101;
var inst_65056 = inst_65097;
var state_65109__$1 = (function (){var statearr_65120 = state_65109;
(statearr_65120[(7)] = inst_65053__$1);

(statearr_65120[(8)] = inst_65056);

(statearr_65120[(9)] = inst_65054);

(statearr_65120[(10)] = inst_65052__$1);

(statearr_65120[(11)] = inst_65055__$1);

return statearr_65120;
})();
var statearr_65121_65142 = state_65109__$1;
(statearr_65121_65142[(2)] = null);

(statearr_65121_65142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (2))){
var inst_65053 = (state_65109[(7)]);
var inst_65056 = (state_65109[(8)]);
var inst_65060 = (state_65109[(12)]);
var inst_65058 = (state_65109[(13)]);
var inst_65054 = (state_65109[(9)]);
var inst_65052 = (state_65109[(10)]);
var inst_65055 = (state_65109[(11)]);
var inst_65058__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_65054);
var inst_65059 = (function (){var fuel = inst_65052;
var cache = inst_65053;
var curr_block = inst_65054;
var rest_blocks = inst_65055;
var acc = inst_65056;
var flakes = inst_65058__$1;
return (function (p1__65042_SHARP_){
return p1__65042_SHARP_.op;
});
})();
var inst_65060__$1 = cljs.core.filter.call(null,inst_65059,inst_65058__$1);
var inst_65061 = cljs.core.empty_QMARK_.call(null,inst_65060__$1);
var inst_65062 = (!(inst_65061));
var state_65109__$1 = (function (){var statearr_65122 = state_65109;
(statearr_65122[(12)] = inst_65060__$1);

(statearr_65122[(13)] = inst_65058__$1);

return statearr_65122;
})();
if(inst_65062){
var statearr_65123_65143 = state_65109__$1;
(statearr_65123_65143[(1)] = (4));

} else {
var statearr_65124_65144 = state_65109__$1;
(statearr_65124_65144[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (11))){
var inst_65085 = (state_65109[(2)]);
var inst_65086 = fluree.db.util.async.throw_err.call(null,inst_65085);
var state_65109__$1 = state_65109;
var statearr_65125_65145 = state_65109__$1;
(statearr_65125_65145[(2)] = inst_65086);

(statearr_65125_65145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (9))){
var state_65109__$1 = state_65109;
var statearr_65126_65146 = state_65109__$1;
(statearr_65126_65146[(2)] = null);

(statearr_65126_65146[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (5))){
var state_65109__$1 = state_65109;
var statearr_65127_65147 = state_65109__$1;
(statearr_65127_65147[(2)] = null);

(statearr_65127_65147[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (14))){
var inst_65105 = (state_65109[(2)]);
var state_65109__$1 = state_65109;
var statearr_65128_65148 = state_65109__$1;
(statearr_65128_65148[(2)] = inst_65105);

(statearr_65128_65148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (10))){
var inst_65056 = (state_65109[(8)]);
var inst_65054 = (state_65109[(9)]);
var inst_65073 = (state_65109[(16)]);
var inst_65055 = (state_65109[(11)]);
var inst_65089 = (state_65109[(2)]);
var inst_65090 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_65091 = [inst_65073,inst_65089];
var inst_65092 = cljs.core.PersistentHashMap.fromArrays(inst_65090,inst_65091);
var inst_65093 = cljs.core.assoc.call(null,inst_65054,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_65092);
var inst_65094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65095 = [inst_65093];
var inst_65096 = (new cljs.core.PersistentVector(null,1,(5),inst_65094,inst_65095,null));
var inst_65097 = cljs.core.concat.call(null,inst_65056,inst_65096);
var inst_65098 = cljs.core.first.call(null,inst_65055);
var state_65109__$1 = (function (){var statearr_65129 = state_65109;
(statearr_65129[(14)] = inst_65097);

return statearr_65129;
})();
if(cljs.core.truth_(inst_65098)){
var statearr_65130_65149 = state_65109__$1;
(statearr_65130_65149[(1)] = (12));

} else {
var statearr_65131_65150 = state_65109__$1;
(statearr_65131_65150[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65110 === (8))){
var inst_65053 = (state_65109[(7)]);
var inst_65056 = (state_65109[(8)]);
var inst_65075 = (state_65109[(15)]);
var inst_65060 = (state_65109[(12)]);
var inst_65058 = (state_65109[(13)]);
var inst_65054 = (state_65109[(9)]);
var inst_65073 = (state_65109[(16)]);
var inst_65052 = (state_65109[(10)]);
var inst_65055 = (state_65109[(11)]);
var inst_65079 = (function (){var flakes = inst_65058;
var rest_blocks = inst_65055;
var curr_block = inst_65054;
var asserted_SINGLEQUOTE_ = inst_65073;
var acc = inst_65056;
var fuel = inst_65052;
var cache = inst_65053;
var retracted = inst_65075;
var asserted = inst_65060;
return (function (p1__65045_SHARP_){
return p1__65045_SHARP_.s;
});
})();
var inst_65080 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_65075);
var inst_65081 = cljs.core.group_by.call(null,inst_65079,inst_65080);
var inst_65082 = cljs.core.vals.call(null,inst_65081);
var inst_65083 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_65053,inst_65052,inst_65082);
var state_65109__$1 = state_65109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65109__$1,(11),inst_65083);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_65132 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65132[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__);

(statearr_65132[(1)] = (1));

return statearr_65132;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1 = (function (state_65109){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65133){var ex__2882__auto__ = e65133;
var statearr_65134_65151 = state_65109;
(statearr_65134_65151[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65109[(4)]))){
var statearr_65135_65152 = state_65109;
(statearr_65135_65152[(1)] = cljs.core.first.call(null,(state_65109[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65153 = state_65109;
state_65109 = G__65153;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__ = function(state_65109){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1.call(this,state_65109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65136 = f__2902__auto__.call(null);
(statearr_65136[(6)] = c__2901__auto__);

return statearr_65136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65253){
var state_val_65254 = (state_65253[(1)]);
if((state_val_65254 === (7))){
var inst_65218 = (state_65253[(7)]);
var inst_65225 = (state_65253[(8)]);
var inst_65224 = cljs.core.seq.call(null,inst_65218);
var inst_65225__$1 = cljs.core.first.call(null,inst_65224);
var inst_65226 = cljs.core.next.call(null,inst_65224);
var state_65253__$1 = (function (){var statearr_65255 = state_65253;
(statearr_65255[(9)] = inst_65226);

(statearr_65255[(8)] = inst_65225__$1);

return statearr_65255;
})();
if(cljs.core.truth_(inst_65225__$1)){
var statearr_65256_65293 = state_65253__$1;
(statearr_65256_65293[(1)] = (9));

} else {
var statearr_65257_65294 = state_65253__$1;
(statearr_65257_65294[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (1))){
var state_65253__$1 = state_65253;
var statearr_65258_65295 = state_65253__$1;
(statearr_65258_65295[(2)] = null);

(statearr_65258_65295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (4))){
var inst_65155 = (state_65253[(2)]);
var state_65253__$1 = state_65253;
var statearr_65259_65296 = state_65253__$1;
(statearr_65259_65296[(2)] = inst_65155);

(statearr_65259_65296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (6))){
var inst_65204 = (state_65253[(2)]);
var inst_65205 = fluree.db.util.async.throw_err.call(null,inst_65204);
var inst_65213 = resp;
var inst_65214 = cljs.core.seq.call(null,inst_65213);
var inst_65215 = cljs.core.first.call(null,inst_65214);
var inst_65216 = cljs.core.next.call(null,inst_65214);
var inst_65217 = cljs.core.PersistentHashMap.EMPTY;
var inst_65218 = inst_65213;
var inst_65219 = inst_65217;
var state_65253__$1 = (function (){var statearr_65260 = state_65253;
(statearr_65260[(7)] = inst_65218);

(statearr_65260[(10)] = inst_65205);

(statearr_65260[(11)] = inst_65216);

(statearr_65260[(12)] = inst_65219);

(statearr_65260[(13)] = inst_65215);

return statearr_65260;
})();
var statearr_65261_65297 = state_65253__$1;
(statearr_65261_65297[(2)] = null);

(statearr_65261_65297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (3))){
var inst_65251 = (state_65253[(2)]);
var state_65253__$1 = state_65253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65253__$1,inst_65251);
} else {
if((state_val_65254 === (2))){
var _ = (function (){var statearr_65262 = state_65253;
(statearr_65262[(4)] = cljs.core.cons.call(null,(5),(state_65253[(4)])));

return statearr_65262;
})();
var inst_65161 = (function (){return (function (p1__65154_SHARP_){
return p1__65154_SHARP_.t;
});
})();
var inst_65162 = cljs.core.map.call(null,inst_65161,resp);
var inst_65163 = cljs.core.set.call(null,inst_65162);
var inst_65200 = cljs.core.async.chan.call(null,(1));
var inst_65201 = (function (){var ts = inst_65163;
var c__2901__auto____$1 = inst_65200;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65198){
var state_val_65199 = (state_65198[(1)]);
if((state_val_65199 === (1))){
var inst_65171 = ts;
var inst_65172 = cljs.core.seq.call(null,inst_65171);
var inst_65173 = cljs.core.first.call(null,inst_65172);
var inst_65174 = cljs.core.next.call(null,inst_65172);
var inst_65175 = cljs.core.PersistentHashMap.EMPTY;
var inst_65176 = inst_65171;
var inst_65177 = inst_65175;
var state_65198__$1 = (function (){var statearr_65263 = state_65198;
(statearr_65263[(7)] = inst_65176);

(statearr_65263[(8)] = inst_65174);

(statearr_65263[(9)] = inst_65177);

(statearr_65263[(10)] = inst_65173);

return statearr_65263;
})();
var statearr_65264_65298 = state_65198__$1;
(statearr_65264_65298[(2)] = null);

(statearr_65264_65298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65199 === (2))){
var inst_65176 = (state_65198[(7)]);
var inst_65183 = (state_65198[(11)]);
var inst_65182 = cljs.core.seq.call(null,inst_65176);
var inst_65183__$1 = cljs.core.first.call(null,inst_65182);
var inst_65184 = cljs.core.next.call(null,inst_65182);
var state_65198__$1 = (function (){var statearr_65265 = state_65198;
(statearr_65265[(12)] = inst_65184);

(statearr_65265[(11)] = inst_65183__$1);

return statearr_65265;
})();
if(cljs.core.truth_(inst_65183__$1)){
var statearr_65266_65299 = state_65198__$1;
(statearr_65266_65299[(1)] = (4));

} else {
var statearr_65267_65300 = state_65198__$1;
(statearr_65267_65300[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65199 === (3))){
var inst_65196 = (state_65198[(2)]);
var state_65198__$1 = state_65198;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65198__$1,inst_65196);
} else {
if((state_val_65199 === (4))){
var inst_65183 = (state_65198[(11)]);
var inst_65186 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_65183);
var state_65198__$1 = state_65198;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65198__$1,(7),inst_65186);
} else {
if((state_val_65199 === (5))){
var inst_65177 = (state_65198[(9)]);
var state_65198__$1 = state_65198;
var statearr_65268_65301 = state_65198__$1;
(statearr_65268_65301[(2)] = inst_65177);

(statearr_65268_65301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65199 === (6))){
var inst_65194 = (state_65198[(2)]);
var state_65198__$1 = state_65198;
var statearr_65269_65302 = state_65198__$1;
(statearr_65269_65302[(2)] = inst_65194);

(statearr_65269_65302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65199 === (7))){
var inst_65184 = (state_65198[(12)]);
var inst_65177 = (state_65198[(9)]);
var inst_65183 = (state_65198[(11)]);
var inst_65188 = (state_65198[(2)]);
var inst_65189 = fluree.db.util.async.throw_err.call(null,inst_65188);
var inst_65190 = cljs.core.assoc.call(null,inst_65177,inst_65183,inst_65189);
var inst_65176 = inst_65184;
var inst_65177__$1 = inst_65190;
var state_65198__$1 = (function (){var statearr_65270 = state_65198;
(statearr_65270[(7)] = inst_65176);

(statearr_65270[(9)] = inst_65177__$1);

return statearr_65270;
})();
var statearr_65271_65303 = state_65198__$1;
(statearr_65271_65303[(2)] = null);

(statearr_65271_65303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_65272 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65272[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__);

(statearr_65272[(1)] = (1));

return statearr_65272;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1 = (function (state_65198){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65273){var ex__2882__auto__ = e65273;
var statearr_65274_65304 = state_65198;
(statearr_65274_65304[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65198[(4)]))){
var statearr_65275_65305 = state_65198;
(statearr_65275_65305[(1)] = cljs.core.first.call(null,(state_65198[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65306 = state_65198;
state_65198 = G__65306;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = function(state_65198){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1.call(this,state_65198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65276 = f__2902__auto__.call(null);
(statearr_65276[(6)] = c__2901__auto____$1);

return statearr_65276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});
})();
var inst_65202 = cljs.core.async.impl.dispatch.run.call(null,inst_65201);
var state_65253__$1 = (function (){var statearr_65277 = state_65253;
(statearr_65277[(14)] = inst_65202);

return statearr_65277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65253__$1,(6),inst_65200);
} else {
if((state_val_65254 === (11))){
var inst_65245 = (state_65253[(2)]);
var state_65253__$1 = state_65253;
var statearr_65279_65307 = state_65253__$1;
(statearr_65279_65307[(2)] = inst_65245);

(statearr_65279_65307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (9))){
var inst_65205 = (state_65253[(10)]);
var inst_65219 = (state_65253[(12)]);
var inst_65226 = (state_65253[(9)]);
var inst_65225 = (state_65253[(8)]);
var inst_65228 = inst_65225.t;
var inst_65229 = cljs.core.get.call(null,inst_65205,inst_65228);
var inst_65230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65231 = [inst_65229,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_65232 = (new cljs.core.PersistentVector(null,2,(5),inst_65230,inst_65231,null));
var inst_65233 = cljs.core.assoc_in.call(null,inst_65219,inst_65232,inst_65229);
var inst_65234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65235 = [inst_65229,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_65236 = (new cljs.core.PersistentVector(null,2,(5),inst_65234,inst_65235,null));
var inst_65237 = cljs.core.update_in.call(null,inst_65233,inst_65236,cljs.core.conj,inst_65225);
var inst_65238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65239 = [inst_65229,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_65240 = (new cljs.core.PersistentVector(null,2,(5),inst_65238,inst_65239,null));
var inst_65241 = cljs.core.update_in.call(null,inst_65237,inst_65240,fluree.db.api_js.min_safe,inst_65228);
var inst_65218 = inst_65226;
var inst_65219__$1 = inst_65241;
var state_65253__$1 = (function (){var statearr_65280 = state_65253;
(statearr_65280[(7)] = inst_65218);

(statearr_65280[(12)] = inst_65219__$1);

return statearr_65280;
})();
var statearr_65281_65308 = state_65253__$1;
(statearr_65281_65308[(2)] = null);

(statearr_65281_65308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (5))){
var _ = (function (){var statearr_65282 = state_65253;
(statearr_65282[(4)] = cljs.core.rest.call(null,(state_65253[(4)])));

return statearr_65282;
})();
var state_65253__$1 = state_65253;
var ex65278 = (state_65253__$1[(2)]);
var statearr_65283_65309 = state_65253__$1;
(statearr_65283_65309[(5)] = ex65278);


if((ex65278 instanceof Error)){
var statearr_65284_65310 = state_65253__$1;
(statearr_65284_65310[(1)] = (4));

(statearr_65284_65310[(5)] = null);

} else {
throw ex65278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (10))){
var inst_65219 = (state_65253[(12)]);
var state_65253__$1 = state_65253;
var statearr_65285_65311 = state_65253__$1;
(statearr_65285_65311[(2)] = inst_65219);

(statearr_65285_65311[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (8))){
var inst_65247 = (state_65253[(2)]);
var inst_65248 = cljs.core.vals.call(null,inst_65247);
var _ = (function (){var statearr_65286 = state_65253;
(statearr_65286[(4)] = cljs.core.rest.call(null,(state_65253[(4)])));

return statearr_65286;
})();
var state_65253__$1 = state_65253;
var statearr_65287_65312 = state_65253__$1;
(statearr_65287_65312[(2)] = inst_65248);

(statearr_65287_65312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_65288 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65288[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__);

(statearr_65288[(1)] = (1));

return statearr_65288;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1 = (function (state_65253){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65289){var ex__2882__auto__ = e65289;
var statearr_65290_65313 = state_65253;
(statearr_65290_65313[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65253[(4)]))){
var statearr_65291_65314 = state_65253;
(statearr_65291_65314[(1)] = cljs.core.first.call(null,(state_65253[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65315 = state_65253;
state_65253 = G__65315;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = function(state_65253){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1.call(this,state_65253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65292 = f__2902__auto__.call(null);
(statearr_65292[(6)] = c__2901__auto__);

return statearr_65292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65457){
var state_val_65458 = (state_65457[(1)]);
if((state_val_65458 === (7))){
var inst_65340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65341 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65342 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65343 = [inst_65341,inst_65342];
var inst_65344 = (new cljs.core.PersistentVector(null,2,(5),inst_65340,inst_65343,null));
var state_65457__$1 = state_65457;
var statearr_65459_65526 = state_65457__$1;
(statearr_65459_65526[(2)] = inst_65344);

(statearr_65459_65526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (20))){
var inst_65370 = (state_65457[(7)]);
var state_65457__$1 = state_65457;
var statearr_65460_65527 = state_65457__$1;
(statearr_65460_65527[(2)] = inst_65370);

(statearr_65460_65527[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (27))){
var state_65457__$1 = state_65457;
var statearr_65461_65528 = state_65457__$1;
(statearr_65461_65528[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (1))){
var state_65457__$1 = state_65457;
var statearr_65463_65529 = state_65457__$1;
(statearr_65463_65529[(2)] = null);

(statearr_65463_65529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (24))){
var inst_65369 = (state_65457[(8)]);
var state_65457__$1 = state_65457;
if(cljs.core.truth_(inst_65369)){
var statearr_65464_65530 = state_65457__$1;
(statearr_65464_65530[(1)] = (26));

} else {
var statearr_65465_65531 = state_65457__$1;
(statearr_65465_65531[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (39))){
var inst_65444 = (state_65457[(9)]);
var state_65457__$1 = state_65457;
var statearr_65466_65532 = state_65457__$1;
(statearr_65466_65532[(2)] = inst_65444);

(statearr_65466_65532[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (4))){
var inst_65316 = (state_65457[(2)]);
var inst_65317 = fluree.db.util.log.error.call(null,inst_65316);
var inst_65318 = cljs.core.ex_data.call(null,inst_65316);
var inst_65319 = cljs.core.ex_message.call(null,inst_65316);
var inst_65320 = cljs.core.assoc.call(null,inst_65318,new cljs.core.Keyword(null,"message","message",-406056002),inst_65319);
var state_65457__$1 = (function (){var statearr_65467 = state_65457;
(statearr_65467[(10)] = inst_65317);

return statearr_65467;
})();
var statearr_65468_65533 = state_65457__$1;
(statearr_65468_65533[(2)] = inst_65320);

(statearr_65468_65533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (15))){
var inst_65354 = (state_65457[(11)]);
var inst_65349 = (state_65457[(12)]);
var inst_65363 = (state_65457[(2)]);
var inst_65364 = [inst_65354,inst_65363];
var inst_65365 = (new cljs.core.PersistentVector(null,2,(5),inst_65349,inst_65364,null));
var state_65457__$1 = state_65457;
var statearr_65469_65534 = state_65457__$1;
(statearr_65469_65534[(2)] = inst_65365);

(statearr_65469_65534[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (21))){
var inst_65369 = (state_65457[(8)]);
var state_65457__$1 = state_65457;
var statearr_65470_65535 = state_65457__$1;
(statearr_65470_65535[(2)] = inst_65369);

(statearr_65470_65535[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (31))){
var inst_65410 = (state_65457[(2)]);
var state_65457__$1 = state_65457;
var statearr_65471_65536 = state_65457__$1;
(statearr_65471_65536[(2)] = inst_65410);

(statearr_65471_65536[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (32))){
var inst_65346 = (state_65457[(13)]);
var inst_65422 = cljs.core.pr_str.call(null,inst_65346);
var inst_65423 = ["Invalid block range provided: ",inst_65422].join('');
var inst_65424 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65425 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65426 = cljs.core.PersistentHashMap.fromArrays(inst_65424,inst_65425);
var inst_65427 = cljs.core.ex_info.call(null,inst_65423,inst_65426);
var inst_65428 = (function(){throw inst_65427})();
var state_65457__$1 = state_65457;
var statearr_65472_65537 = state_65457__$1;
(statearr_65472_65537[(2)] = inst_65428);

(statearr_65472_65537[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (40))){
var inst_65443 = (state_65457[(14)]);
var inst_65449 = (state_65457[(2)]);
var inst_65450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65451 = [inst_65443,inst_65449];
var inst_65452 = (new cljs.core.PersistentVector(null,2,(5),inst_65450,inst_65451,null));
var _ = (function (){var statearr_65473 = state_65457;
(statearr_65473[(4)] = cljs.core.rest.call(null,(state_65457[(4)])));

return statearr_65473;
})();
var state_65457__$1 = state_65457;
var statearr_65474_65538 = state_65457__$1;
(statearr_65474_65538[(2)] = inst_65452);

(statearr_65474_65538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (33))){
var state_65457__$1 = state_65457;
var statearr_65475_65539 = state_65457__$1;
(statearr_65475_65539[(2)] = null);

(statearr_65475_65539[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (13))){
var inst_65355 = (state_65457[(15)]);
var inst_65357 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65355);
var state_65457__$1 = state_65457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65457__$1,(16),inst_65357);
} else {
if((state_val_65458 === (22))){
var inst_65388 = (state_65457[(2)]);
var state_65457__$1 = state_65457;
if(cljs.core.truth_(inst_65388)){
var statearr_65476_65540 = state_65457__$1;
(statearr_65476_65540[(1)] = (23));

} else {
var statearr_65477_65541 = state_65457__$1;
(statearr_65477_65541[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (36))){
var inst_65415 = (state_65457[(16)]);
var inst_65416 = (state_65457[(17)]);
var inst_65438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65439 = [inst_65415,inst_65416];
var inst_65440 = (new cljs.core.PersistentVector(null,2,(5),inst_65438,inst_65439,null));
var state_65457__$1 = state_65457;
var statearr_65478_65542 = state_65457__$1;
(statearr_65478_65542[(2)] = inst_65440);

(statearr_65478_65542[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (29))){
var inst_65346 = (state_65457[(13)]);
var inst_65401 = cljs.core.pr_str.call(null,inst_65346);
var inst_65402 = ["Invalid block range provided: ",inst_65401].join('');
var inst_65403 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65404 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65405 = cljs.core.PersistentHashMap.fromArrays(inst_65403,inst_65404);
var inst_65406 = cljs.core.ex_info.call(null,inst_65402,inst_65405);
var inst_65407 = (function(){throw inst_65406})();
var state_65457__$1 = state_65457;
var statearr_65479_65543 = state_65457__$1;
(statearr_65479_65543[(2)] = inst_65407);

(statearr_65479_65543[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (6))){
var inst_65338 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65457__$1 = state_65457;
var statearr_65480_65544 = state_65457__$1;
(statearr_65480_65544[(2)] = inst_65338);

(statearr_65480_65544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (28))){
var inst_65412 = (state_65457[(2)]);
var state_65457__$1 = state_65457;
var statearr_65481_65545 = state_65457__$1;
(statearr_65481_65545[(2)] = inst_65412);

(statearr_65481_65545[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (25))){
var inst_65415 = (state_65457[(16)]);
var inst_65416 = (state_65457[(17)]);
var inst_65414 = (state_65457[(2)]);
var inst_65415__$1 = cljs.core.nth.call(null,inst_65414,(0),null);
var inst_65416__$1 = cljs.core.nth.call(null,inst_65414,(1),null);
var inst_65417 = cljs.core.pos_int_QMARK_.call(null,inst_65415__$1);
var inst_65418 = cljs.core.pos_int_QMARK_.call(null,inst_65416__$1);
var inst_65419 = ((inst_65417) && (inst_65418));
var inst_65420 = cljs.core.not.call(null,inst_65419);
var state_65457__$1 = (function (){var statearr_65482 = state_65457;
(statearr_65482[(16)] = inst_65415__$1);

(statearr_65482[(17)] = inst_65416__$1);

return statearr_65482;
})();
if(inst_65420){
var statearr_65483_65546 = state_65457__$1;
(statearr_65483_65546[(1)] = (32));

} else {
var statearr_65484_65547 = state_65457__$1;
(statearr_65484_65547[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (34))){
var inst_65415 = (state_65457[(16)]);
var inst_65416 = (state_65457[(17)]);
var inst_65431 = (state_65457[(2)]);
var inst_65432 = (inst_65416 < inst_65415);
var state_65457__$1 = (function (){var statearr_65485 = state_65457;
(statearr_65485[(18)] = inst_65431);

return statearr_65485;
})();
if(cljs.core.truth_(inst_65432)){
var statearr_65486_65548 = state_65457__$1;
(statearr_65486_65548[(1)] = (35));

} else {
var statearr_65487_65549 = state_65457__$1;
(statearr_65487_65549[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (17))){
var inst_65369 = (state_65457[(8)]);
var inst_65371 = (state_65457[(19)]);
var inst_65374 = cljs.core.pr_str.call(null,inst_65369);
var inst_65375 = cljs.core.pr_str.call(null,inst_65371);
var inst_65376 = ["Start block is out of range for this ledger. Start block provided: ",inst_65374,". Database block: ",inst_65375].join('');
var inst_65377 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65378 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65379 = cljs.core.PersistentHashMap.fromArrays(inst_65377,inst_65378);
var inst_65380 = cljs.core.ex_info.call(null,inst_65376,inst_65379);
var inst_65381 = (function(){throw inst_65380})();
var state_65457__$1 = state_65457;
var statearr_65488_65550 = state_65457__$1;
(statearr_65488_65550[(2)] = inst_65381);

(statearr_65488_65550[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (3))){
var inst_65455 = (state_65457[(2)]);
var state_65457__$1 = state_65457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65457__$1,inst_65455);
} else {
if((state_val_65458 === (12))){
var inst_65346 = (state_65457[(13)]);
var inst_65355 = (state_65457[(15)]);
var inst_65353 = (state_65457[(2)]);
var inst_65354 = fluree.db.util.async.throw_err.call(null,inst_65353);
var inst_65355__$1 = cljs.core.second.call(null,inst_65346);
var state_65457__$1 = (function (){var statearr_65489 = state_65457;
(statearr_65489[(11)] = inst_65354);

(statearr_65489[(15)] = inst_65355__$1);

return statearr_65489;
})();
if(cljs.core.truth_(inst_65355__$1)){
var statearr_65490_65551 = state_65457__$1;
(statearr_65490_65551[(1)] = (13));

} else {
var statearr_65491_65552 = state_65457__$1;
(statearr_65491_65552[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (2))){
var _ = (function (){var statearr_65492 = state_65457;
(statearr_65492[(4)] = cljs.core.cons.call(null,(5),(state_65457[(4)])));

return statearr_65492;
})();
var inst_65335 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65336 = cljs.core.sequential_QMARK_.call(null,inst_65335);
var state_65457__$1 = state_65457;
if(inst_65336){
var statearr_65493_65553 = state_65457__$1;
(statearr_65493_65553[(1)] = (6));

} else {
var statearr_65494_65554 = state_65457__$1;
(statearr_65494_65554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (23))){
var inst_65370 = (state_65457[(7)]);
var inst_65369 = (state_65457[(8)]);
var inst_65390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65391 = [inst_65369,inst_65370];
var inst_65392 = (new cljs.core.PersistentVector(null,2,(5),inst_65390,inst_65391,null));
var state_65457__$1 = state_65457;
var statearr_65495_65555 = state_65457__$1;
(statearr_65495_65555[(2)] = inst_65392);

(statearr_65495_65555[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (35))){
var inst_65415 = (state_65457[(16)]);
var inst_65416 = (state_65457[(17)]);
var inst_65434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65435 = [inst_65416,inst_65415];
var inst_65436 = (new cljs.core.PersistentVector(null,2,(5),inst_65434,inst_65435,null));
var state_65457__$1 = state_65457;
var statearr_65496_65556 = state_65457__$1;
(statearr_65496_65556[(2)] = inst_65436);

(statearr_65496_65556[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (19))){
var inst_65369 = (state_65457[(8)]);
var inst_65384 = (state_65457[(2)]);
var state_65457__$1 = (function (){var statearr_65497 = state_65457;
(statearr_65497[(20)] = inst_65384);

return statearr_65497;
})();
if(cljs.core.truth_(inst_65369)){
var statearr_65498_65557 = state_65457__$1;
(statearr_65498_65557[(1)] = (20));

} else {
var statearr_65499_65558 = state_65457__$1;
(statearr_65499_65558[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (11))){
var inst_65369 = (state_65457[(8)]);
var inst_65371 = (state_65457[(19)]);
var inst_65368 = (state_65457[(2)]);
var inst_65369__$1 = cljs.core.nth.call(null,inst_65368,(0),null);
var inst_65370 = cljs.core.nth.call(null,inst_65368,(1),null);
var inst_65371__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65372 = (inst_65369__$1 > inst_65371__$1);
var state_65457__$1 = (function (){var statearr_65501 = state_65457;
(statearr_65501[(7)] = inst_65370);

(statearr_65501[(8)] = inst_65369__$1);

(statearr_65501[(19)] = inst_65371__$1);

return statearr_65501;
})();
if(cljs.core.truth_(inst_65372)){
var statearr_65502_65559 = state_65457__$1;
(statearr_65502_65559[(1)] = (17));

} else {
var statearr_65503_65560 = state_65457__$1;
(statearr_65503_65560[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (9))){
var inst_65346 = (state_65457[(13)]);
var inst_65349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65350 = cljs.core.first.call(null,inst_65346);
var inst_65351 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65350);
var state_65457__$1 = (function (){var statearr_65504 = state_65457;
(statearr_65504[(12)] = inst_65349);

return statearr_65504;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65457__$1,(12),inst_65351);
} else {
if((state_val_65458 === (5))){
var _ = (function (){var statearr_65505 = state_65457;
(statearr_65505[(4)] = cljs.core.rest.call(null,(state_65457[(4)])));

return statearr_65505;
})();
var state_65457__$1 = state_65457;
var ex65500 = (state_65457__$1[(2)]);
var statearr_65506_65561 = state_65457__$1;
(statearr_65506_65561[(5)] = ex65500);


var statearr_65507_65562 = state_65457__$1;
(statearr_65507_65562[(1)] = (4));

(statearr_65507_65562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (14))){
var state_65457__$1 = state_65457;
var statearr_65508_65563 = state_65457__$1;
(statearr_65508_65563[(2)] = null);

(statearr_65508_65563[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (26))){
var inst_65369 = (state_65457[(8)]);
var inst_65395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65396 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65397 = [inst_65369,inst_65396];
var inst_65398 = (new cljs.core.PersistentVector(null,2,(5),inst_65395,inst_65397,null));
var state_65457__$1 = state_65457;
var statearr_65509_65564 = state_65457__$1;
(statearr_65509_65564[(2)] = inst_65398);

(statearr_65509_65564[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (16))){
var inst_65359 = (state_65457[(2)]);
var inst_65360 = fluree.db.util.async.throw_err.call(null,inst_65359);
var state_65457__$1 = state_65457;
var statearr_65510_65565 = state_65457__$1;
(statearr_65510_65565[(2)] = inst_65360);

(statearr_65510_65565[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (38))){
var inst_65371 = (state_65457[(19)]);
var state_65457__$1 = state_65457;
var statearr_65511_65566 = state_65457__$1;
(statearr_65511_65566[(2)] = inst_65371);

(statearr_65511_65566[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (30))){
var state_65457__$1 = state_65457;
var statearr_65512_65567 = state_65457__$1;
(statearr_65512_65567[(2)] = null);

(statearr_65512_65567[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (10))){
var inst_65346 = (state_65457[(13)]);
var state_65457__$1 = state_65457;
var statearr_65513_65568 = state_65457__$1;
(statearr_65513_65568[(2)] = inst_65346);

(statearr_65513_65568[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (18))){
var state_65457__$1 = state_65457;
var statearr_65514_65569 = state_65457__$1;
(statearr_65514_65569[(2)] = null);

(statearr_65514_65569[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (37))){
var inst_65444 = (state_65457[(9)]);
var inst_65371 = (state_65457[(19)]);
var inst_65442 = (state_65457[(2)]);
var inst_65443 = cljs.core.nth.call(null,inst_65442,(0),null);
var inst_65444__$1 = cljs.core.nth.call(null,inst_65442,(1),null);
var inst_65445 = (inst_65444__$1 > inst_65371);
var state_65457__$1 = (function (){var statearr_65515 = state_65457;
(statearr_65515[(9)] = inst_65444__$1);

(statearr_65515[(14)] = inst_65443);

return statearr_65515;
})();
if(cljs.core.truth_(inst_65445)){
var statearr_65516_65570 = state_65457__$1;
(statearr_65516_65570[(1)] = (38));

} else {
var statearr_65517_65571 = state_65457__$1;
(statearr_65517_65571[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65458 === (8))){
var inst_65346 = (state_65457[(13)]);
var inst_65346__$1 = (state_65457[(2)]);
var inst_65347 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_65346__$1);
var state_65457__$1 = (function (){var statearr_65518 = state_65457;
(statearr_65518[(13)] = inst_65346__$1);

return statearr_65518;
})();
if(cljs.core.truth_(inst_65347)){
var statearr_65519_65572 = state_65457__$1;
(statearr_65519_65572[(1)] = (9));

} else {
var statearr_65520_65573 = state_65457__$1;
(statearr_65520_65573[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0 = (function (){
var statearr_65521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65521[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__);

(statearr_65521[(1)] = (1));

return statearr_65521;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1 = (function (state_65457){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65522){var ex__2882__auto__ = e65522;
var statearr_65523_65574 = state_65457;
(statearr_65523_65574[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65457[(4)]))){
var statearr_65524_65575 = state_65457;
(statearr_65524_65575[(1)] = cljs.core.first.call(null,(state_65457[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65576 = state_65457;
state_65457 = G__65576;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__ = function(state_65457){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1.call(this,state_65457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65525 = f__2902__auto__.call(null);
(statearr_65525[(6)] = c__2901__auto__);

return statearr_65525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65579 = arguments.length;
switch (G__65579) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65694){
var state_val_65695 = (state_65694[(1)]);
if((state_val_65695 === (7))){
var state_65694__$1 = state_65694;
var statearr_65696_65760 = state_65694__$1;
(statearr_65696_65760[(2)] = false);

(statearr_65696_65760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (20))){
var state_65694__$1 = state_65694;
var statearr_65697_65761 = state_65694__$1;
(statearr_65697_65761[(2)] = null);

(statearr_65697_65761[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (27))){
var inst_65661 = (state_65694[(2)]);
var inst_65662 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65694__$1 = (function (){var statearr_65698 = state_65694;
(statearr_65698[(7)] = inst_65661);

return statearr_65698;
})();
if(cljs.core.truth_(inst_65662)){
var statearr_65699_65762 = state_65694__$1;
(statearr_65699_65762[(1)] = (29));

} else {
var statearr_65700_65763 = state_65694__$1;
(statearr_65700_65763[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (1))){
var state_65694__$1 = state_65694;
var statearr_65701_65764 = state_65694__$1;
(statearr_65701_65764[(2)] = null);

(statearr_65701_65764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (24))){
var inst_65622 = (state_65694[(8)]);
var inst_65635 = (state_65694[(2)]);
var inst_65636 = cljs.core.ex_info.call(null,inst_65635,inst_65622);
var inst_65637 = (function(){throw inst_65636})();
var state_65694__$1 = state_65694;
var statearr_65702_65765 = state_65694__$1;
(statearr_65702_65765[(2)] = inst_65637);

(statearr_65702_65765[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (4))){
var inst_65580 = (state_65694[(2)]);
var inst_65581 = fluree.db.util.log.error.call(null,inst_65580);
var inst_65582 = cljs.core.ex_data.call(null,inst_65580);
var inst_65583 = cljs.core.ex_message.call(null,inst_65580);
var inst_65584 = cljs.core.assoc.call(null,inst_65582,new cljs.core.Keyword(null,"message","message",-406056002),inst_65583);
var state_65694__$1 = (function (){var statearr_65703 = state_65694;
(statearr_65703[(9)] = inst_65581);

return statearr_65703;
})();
var statearr_65704_65766 = state_65694__$1;
(statearr_65704_65766[(2)] = inst_65584);

(statearr_65704_65766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (15))){
var inst_65622 = (state_65694[(8)]);
var inst_65621 = (state_65694[(2)]);
var inst_65622__$1 = fluree.db.util.async.throw_err.call(null,inst_65621);
var inst_65623 = cljs.core.map_QMARK_.call(null,inst_65622__$1);
var state_65694__$1 = (function (){var statearr_65705 = state_65694;
(statearr_65705[(8)] = inst_65622__$1);

return statearr_65705;
})();
if(inst_65623){
var statearr_65706_65767 = state_65694__$1;
(statearr_65706_65767[(1)] = (16));

} else {
var statearr_65707_65768 = state_65694__$1;
(statearr_65707_65768[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (21))){
var inst_65622 = (state_65694[(8)]);
var inst_65640 = (state_65694[(2)]);
var inst_65641 = cljs.core.nth.call(null,inst_65622,(0),null);
var inst_65642 = cljs.core.nth.call(null,inst_65622,(1),null);
var inst_65643 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65644 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65645 = cljs.core.keys.call(null,inst_65644);
var inst_65646 = cljs.core._EQ_.call(null,inst_65643,inst_65645);
var state_65694__$1 = (function (){var statearr_65708 = state_65694;
(statearr_65708[(10)] = inst_65640);

(statearr_65708[(11)] = inst_65641);

(statearr_65708[(12)] = inst_65642);

return statearr_65708;
})();
if(inst_65646){
var statearr_65709_65769 = state_65694__$1;
(statearr_65709_65769[(1)] = (25));

} else {
var statearr_65710_65770 = state_65694__$1;
(statearr_65710_65770[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (31))){
var inst_65670 = (state_65694[(2)]);
var inst_65671 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65694__$1 = (function (){var statearr_65711 = state_65694;
(statearr_65711[(13)] = inst_65670);

return statearr_65711;
})();
if(cljs.core.truth_(inst_65671)){
var statearr_65712_65771 = state_65694__$1;
(statearr_65712_65771[(1)] = (33));

} else {
var statearr_65713_65772 = state_65694__$1;
(statearr_65713_65772[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (32))){
var inst_65666 = (state_65694[(2)]);
var inst_65667 = fluree.db.util.async.throw_err.call(null,inst_65666);
var state_65694__$1 = state_65694;
var statearr_65714_65773 = state_65694__$1;
(statearr_65714_65773[(2)] = inst_65667);

(statearr_65714_65773[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (33))){
var inst_65670 = (state_65694[(13)]);
var inst_65673 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65674 = cljs.core.sequential_QMARK_.call(null,inst_65670);
var state_65694__$1 = (function (){var statearr_65715 = state_65694;
(statearr_65715[(14)] = inst_65673);

return statearr_65715;
})();
if(inst_65674){
var statearr_65716_65774 = state_65694__$1;
(statearr_65716_65774[(1)] = (36));

} else {
var statearr_65717_65775 = state_65694__$1;
(statearr_65717_65775[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (13))){
var inst_65595 = (state_65694[(15)]);
var state_65694__$1 = state_65694;
var statearr_65718_65776 = state_65694__$1;
(statearr_65718_65776[(2)] = inst_65595);

(statearr_65718_65776[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (22))){
var inst_65630 = (state_65694[(16)]);
var state_65694__$1 = state_65694;
var statearr_65719_65777 = state_65694__$1;
(statearr_65719_65777[(2)] = inst_65630);

(statearr_65719_65777[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (36))){
var inst_65670 = (state_65694[(13)]);
var inst_65676 = cljs.core.doall.call(null,inst_65670);
var state_65694__$1 = state_65694;
var statearr_65720_65778 = state_65694__$1;
(statearr_65720_65778[(2)] = inst_65676);

(statearr_65720_65778[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (29))){
var inst_65661 = (state_65694[(7)]);
var inst_65664 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_65661);
var state_65694__$1 = state_65694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65694__$1,(32),inst_65664);
} else {
if((state_val_65695 === (6))){
var inst_65595 = (state_65694[(15)]);
var inst_65600 = inst_65595.cljs$lang$protocol_mask$partition0$;
var inst_65601 = (inst_65600 & (64));
var inst_65602 = inst_65595.cljs$core$ISeq$;
var inst_65603 = (cljs.core.PROTOCOL_SENTINEL === inst_65602);
var inst_65604 = ((inst_65601) || (inst_65603));
var state_65694__$1 = state_65694;
if(cljs.core.truth_(inst_65604)){
var statearr_65721_65779 = state_65694__$1;
(statearr_65721_65779[(1)] = (9));

} else {
var statearr_65722_65780 = state_65694__$1;
(statearr_65722_65780[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (28))){
var inst_65650 = (state_65694[(2)]);
var inst_65651 = fluree.db.util.async.throw_err.call(null,inst_65650);
var state_65694__$1 = state_65694;
var statearr_65723_65781 = state_65694__$1;
(statearr_65723_65781[(2)] = inst_65651);

(statearr_65723_65781[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (25))){
var inst_65641 = (state_65694[(11)]);
var inst_65642 = (state_65694[(12)]);
var inst_65648 = fluree.db.query.block.block_range.call(null,db,inst_65641,inst_65642,opts);
var state_65694__$1 = state_65694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65694__$1,(28),inst_65648);
} else {
if((state_val_65695 === (34))){
var inst_65670 = (state_65694[(13)]);
var state_65694__$1 = state_65694;
var statearr_65724_65782 = state_65694__$1;
(statearr_65724_65782[(2)] = inst_65670);

(statearr_65724_65782[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (17))){
var state_65694__$1 = state_65694;
var statearr_65725_65783 = state_65694__$1;
(statearr_65725_65783[(2)] = false);

(statearr_65725_65783[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (3))){
var inst_65692 = (state_65694[(2)]);
var state_65694__$1 = state_65694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65694__$1,inst_65692);
} else {
if((state_val_65695 === (12))){
var inst_65595 = (state_65694[(15)]);
var inst_65613 = cljs.core.apply.call(null,cljs.core.hash_map,inst_65595);
var state_65694__$1 = state_65694;
var statearr_65726_65784 = state_65694__$1;
(statearr_65726_65784[(2)] = inst_65613);

(statearr_65726_65784[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (2))){
var inst_65595 = (state_65694[(15)]);
var _ = (function (){var statearr_65727 = state_65694;
(statearr_65727[(4)] = cljs.core.cons.call(null,(5),(state_65694[(4)])));

return statearr_65727;
})();
var inst_65594 = fluree.db.util.core.current_time_millis.call(null);
var inst_65595__$1 = db;
var inst_65597 = (inst_65595__$1 == null);
var inst_65598 = cljs.core.not.call(null,inst_65597);
var state_65694__$1 = (function (){var statearr_65728 = state_65694;
(statearr_65728[(15)] = inst_65595__$1);

(statearr_65728[(17)] = inst_65594);

return statearr_65728;
})();
if(inst_65598){
var statearr_65729_65785 = state_65694__$1;
(statearr_65729_65785[(1)] = (6));

} else {
var statearr_65730_65786 = state_65694__$1;
(statearr_65730_65786[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (23))){
var inst_65617 = (state_65694[(18)]);
var inst_65618 = (state_65694[(19)]);
var inst_65633 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65617),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65618)].join('');
var state_65694__$1 = state_65694;
var statearr_65731_65787 = state_65694__$1;
(statearr_65731_65787[(2)] = inst_65633);

(statearr_65731_65787[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (35))){
var inst_65689 = (state_65694[(2)]);
var _ = (function (){var statearr_65732 = state_65694;
(statearr_65732[(4)] = cljs.core.rest.call(null,(state_65694[(4)])));

return statearr_65732;
})();
var state_65694__$1 = state_65694;
var statearr_65733_65788 = state_65694__$1;
(statearr_65733_65788[(2)] = inst_65689);

(statearr_65733_65788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (19))){
var inst_65630 = (state_65694[(16)]);
var inst_65622 = (state_65694[(8)]);
var inst_65630__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65622);
var state_65694__$1 = (function (){var statearr_65734 = state_65694;
(statearr_65734[(16)] = inst_65630__$1);

return statearr_65734;
})();
if(cljs.core.truth_(inst_65630__$1)){
var statearr_65735_65789 = state_65694__$1;
(statearr_65735_65789[(1)] = (22));

} else {
var statearr_65736_65790 = state_65694__$1;
(statearr_65736_65790[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (11))){
var inst_65608 = (state_65694[(2)]);
var state_65694__$1 = state_65694;
var statearr_65738_65791 = state_65694__$1;
(statearr_65738_65791[(2)] = inst_65608);

(statearr_65738_65791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (9))){
var state_65694__$1 = state_65694;
var statearr_65739_65792 = state_65694__$1;
(statearr_65739_65792[(2)] = true);

(statearr_65739_65792[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (5))){
var _ = (function (){var statearr_65740 = state_65694;
(statearr_65740[(4)] = cljs.core.rest.call(null,(state_65694[(4)])));

return statearr_65740;
})();
var state_65694__$1 = state_65694;
var ex65737 = (state_65694__$1[(2)]);
var statearr_65741_65793 = state_65694__$1;
(statearr_65741_65793[(5)] = ex65737);


var statearr_65742_65794 = state_65694__$1;
(statearr_65742_65794[(1)] = (4));

(statearr_65742_65794[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (14))){
var inst_65616 = (state_65694[(20)]);
var inst_65616__$1 = (state_65694[(2)]);
var inst_65617 = cljs.core.get.call(null,inst_65616__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65618 = cljs.core.get.call(null,inst_65616__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65619 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_65694__$1 = (function (){var statearr_65743 = state_65694;
(statearr_65743[(20)] = inst_65616__$1);

(statearr_65743[(18)] = inst_65617);

(statearr_65743[(19)] = inst_65618);

return statearr_65743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65694__$1,(15),inst_65619);
} else {
if((state_val_65695 === (26))){
var inst_65653 = cljs.core.pr_str.call(null,query_map);
var inst_65654 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65653].join('');
var inst_65655 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65656 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65657 = cljs.core.PersistentHashMap.fromArrays(inst_65655,inst_65656);
var inst_65658 = cljs.core.ex_info.call(null,inst_65654,inst_65657);
var inst_65659 = (function(){throw inst_65658})();
var state_65694__$1 = state_65694;
var statearr_65744_65795 = state_65694__$1;
(statearr_65744_65795[(2)] = inst_65659);

(statearr_65744_65795[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (16))){
var inst_65622 = (state_65694[(8)]);
var inst_65625 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65622);
var state_65694__$1 = state_65694;
var statearr_65745_65796 = state_65694__$1;
(statearr_65745_65796[(2)] = inst_65625);

(statearr_65745_65796[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (38))){
var inst_65661 = (state_65694[(7)]);
var inst_65616 = (state_65694[(20)]);
var inst_65640 = (state_65694[(10)]);
var inst_65670 = (state_65694[(13)]);
var inst_65594 = (state_65694[(17)]);
var inst_65641 = (state_65694[(11)]);
var inst_65673 = (state_65694[(14)]);
var inst_65622 = (state_65694[(8)]);
var inst_65617 = (state_65694[(18)]);
var inst_65642 = (state_65694[(12)]);
var inst_65618 = (state_65694[(19)]);
var inst_65679 = (state_65694[(2)]);
var inst_65680 = (function (){var network = inst_65617;
var block_start = inst_65641;
var vec__65591 = inst_65622;
var block_end = inst_65642;
var range = inst_65622;
var db_id = inst_65618;
var _ = inst_65640;
var start = inst_65594;
var map__65590 = inst_65616;
var result_SINGLEQUOTE_ = inst_65670;
var result = inst_65661;
return (function (p1__65577_SHARP_){
return goog.string.format("%.2fms",p1__65577_SHARP_);
});
})();
var inst_65681 = fluree.db.util.core.current_time_millis.call(null);
var inst_65682 = (inst_65681 - inst_65594);
var inst_65683 = (inst_65682 / (1000000));
var inst_65684 = inst_65680.call(null,inst_65683);
var inst_65685 = [(200),inst_65679,(100),inst_65684];
var inst_65686 = cljs.core.PersistentHashMap.fromArrays(inst_65673,inst_65685);
var state_65694__$1 = state_65694;
var statearr_65746_65797 = state_65694__$1;
(statearr_65746_65797[(2)] = inst_65686);

(statearr_65746_65797[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (30))){
var inst_65661 = (state_65694[(7)]);
var state_65694__$1 = state_65694;
var statearr_65747_65798 = state_65694__$1;
(statearr_65747_65798[(2)] = inst_65661);

(statearr_65747_65798[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (10))){
var state_65694__$1 = state_65694;
var statearr_65748_65799 = state_65694__$1;
(statearr_65748_65799[(2)] = false);

(statearr_65748_65799[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (18))){
var inst_65628 = (state_65694[(2)]);
var state_65694__$1 = state_65694;
if(cljs.core.truth_(inst_65628)){
var statearr_65749_65800 = state_65694__$1;
(statearr_65749_65800[(1)] = (19));

} else {
var statearr_65750_65801 = state_65694__$1;
(statearr_65750_65801[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (37))){
var inst_65670 = (state_65694[(13)]);
var state_65694__$1 = state_65694;
var statearr_65751_65802 = state_65694__$1;
(statearr_65751_65802[(2)] = inst_65670);

(statearr_65751_65802[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65695 === (8))){
var inst_65611 = (state_65694[(2)]);
var state_65694__$1 = state_65694;
if(cljs.core.truth_(inst_65611)){
var statearr_65752_65803 = state_65694__$1;
(statearr_65752_65803[(1)] = (12));

} else {
var statearr_65753_65804 = state_65694__$1;
(statearr_65753_65804[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_65754 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65754[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_65754[(1)] = (1));

return statearr_65754;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_65694){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_65694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65755){var ex__2882__auto__ = e65755;
var statearr_65756_65805 = state_65694;
(statearr_65756_65805[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_65694[(4)]))){
var statearr_65757_65806 = state_65694;
(statearr_65757_65806[(1)] = cljs.core.first.call(null,(state_65694[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65807 = state_65694;
state_65694 = G__65807;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_65694){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_65694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65758 = f__2902__auto__.call(null);
(statearr_65758[(6)] = c__2901__auto__);

return statearr_65758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__65809 = arguments.length;
switch (G__65809) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66010){
var state_val_66011 = (state_66010[(1)]);
if((state_val_66011 === (7))){
var inst_65827 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66012_66096 = state_66010__$1;
(statearr_66012_66096[(2)] = inst_65827);

(statearr_66012_66096[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (59))){
var inst_66008 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66010__$1,inst_66008);
} else {
if((state_val_66011 === (20))){
var state_66010__$1 = state_66010;
var statearr_66013_66097 = state_66010__$1;
(statearr_66013_66097[(2)] = (-1));

(statearr_66013_66097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (58))){
var inst_66000 = (state_66010[(7)]);
var state_66010__$1 = state_66010;
var statearr_66014_66098 = state_66010__$1;
(statearr_66014_66098[(2)] = inst_66000);

(statearr_66014_66098[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (27))){
var inst_65837 = (state_66010[(8)]);
var inst_65887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65888 = [inst_65837];
var inst_65889 = (new cljs.core.PersistentVector(null,1,(5),inst_65887,inst_65888,null));
var state_66010__$1 = state_66010;
var statearr_66015_66099 = state_66010__$1;
(statearr_66015_66099[(2)] = inst_65889);

(statearr_66015_66099[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (1))){
var inst_65814 = (state_66010[(9)]);
var inst_65814__$1 = query_map;
var inst_65816 = (inst_65814__$1 == null);
var inst_65817 = cljs.core.not.call(null,inst_65816);
var state_66010__$1 = (function (){var statearr_66016 = state_66010;
(statearr_66016[(9)] = inst_65814__$1);

return statearr_66016;
})();
if(inst_65817){
var statearr_66017_66100 = state_66010__$1;
(statearr_66017_66100[(1)] = (2));

} else {
var statearr_66018_66101 = state_66010__$1;
(statearr_66018_66101[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (24))){
var inst_65841 = (state_66010[(10)]);
var inst_65882 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65841);
var state_66010__$1 = state_66010;
var statearr_66019_66102 = state_66010__$1;
(statearr_66019_66102[(2)] = inst_65882);

(statearr_66019_66102[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (55))){
var inst_65858 = (state_66010[(11)]);
var inst_66000 = (state_66010[(2)]);
var state_66010__$1 = (function (){var statearr_66020 = state_66010;
(statearr_66020[(7)] = inst_66000);

return statearr_66020;
})();
if(cljs.core.truth_(inst_65858)){
var statearr_66021_66103 = state_66010__$1;
(statearr_66021_66103[(1)] = (57));

} else {
var statearr_66022_66104 = state_66010__$1;
(statearr_66022_66104[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (39))){
var inst_65918 = (state_66010[(12)]);
var inst_65933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65934 = [inst_65918,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65935 = (new cljs.core.PersistentVector(null,2,(5),inst_65933,inst_65934,null));
var state_66010__$1 = state_66010;
var statearr_66023_66105 = state_66010__$1;
(statearr_66023_66105[(2)] = inst_65935);

(statearr_66023_66105[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (46))){
var state_66010__$1 = state_66010;
var statearr_66024_66106 = state_66010__$1;
(statearr_66024_66106[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (4))){
var inst_65830 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
if(cljs.core.truth_(inst_65830)){
var statearr_66026_66107 = state_66010__$1;
(statearr_66026_66107[(1)] = (8));

} else {
var statearr_66027_66108 = state_66010__$1;
(statearr_66027_66108[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (54))){
var inst_65992 = (state_66010[(13)]);
var state_66010__$1 = state_66010;
var statearr_66028_66109 = state_66010__$1;
(statearr_66028_66109[(2)] = inst_65992);

(statearr_66028_66109[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (15))){
var inst_65845 = (state_66010[(2)]);
var inst_65846 = fluree.db.util.async.throw_err.call(null,inst_65845);
var state_66010__$1 = state_66010;
var statearr_66029_66110 = state_66010__$1;
(statearr_66029_66110[(2)] = inst_65846);

(statearr_66029_66110[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (48))){
var inst_65837 = (state_66010[(8)]);
var inst_65965 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65837)].join('');
var inst_65966 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65967 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65968 = cljs.core.PersistentHashMap.fromArrays(inst_65966,inst_65967);
var inst_65969 = cljs.core.ex_info.call(null,inst_65965,inst_65968);
var inst_65970 = (function(){throw inst_65969})();
var state_66010__$1 = state_66010;
var statearr_66030_66111 = state_66010__$1;
(statearr_66030_66111[(2)] = inst_65970);

(statearr_66030_66111[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (50))){
var inst_65973 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66031_66112 = state_66010__$1;
(statearr_66031_66112[(2)] = inst_65973);

(statearr_66031_66112[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (21))){
var inst_65851 = (state_66010[(14)]);
var inst_65874 = (state_66010[(2)]);
var state_66010__$1 = (function (){var statearr_66032 = state_66010;
(statearr_66032[(15)] = inst_65874);

return statearr_66032;
})();
if(cljs.core.truth_(inst_65851)){
var statearr_66033_66113 = state_66010__$1;
(statearr_66033_66113[(1)] = (23));

} else {
var statearr_66034_66114 = state_66010__$1;
(statearr_66034_66114[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (31))){
var state_66010__$1 = state_66010;
var statearr_66035_66115 = state_66010__$1;
(statearr_66035_66115[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (32))){
var inst_65916 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66037_66116 = state_66010__$1;
(statearr_66037_66116[(2)] = inst_65916);

(statearr_66037_66116[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (40))){
var inst_65927 = (state_66010[(16)]);
var inst_65928 = (state_66010[(17)]);
var inst_65926 = (state_66010[(18)]);
var inst_65937 = (inst_65926 == null);
var inst_65938 = (inst_65927 == null);
var inst_65939 = cljs.core.not.call(null,inst_65938);
var inst_65940 = (inst_65928 == null);
var inst_65941 = ((inst_65937) && (inst_65939) && (inst_65940));
var state_66010__$1 = state_66010;
if(cljs.core.truth_(inst_65941)){
var statearr_66038_66117 = state_66010__$1;
(statearr_66038_66117[(1)] = (42));

} else {
var statearr_66039_66118 = state_66010__$1;
(statearr_66039_66118[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (56))){
var inst_65996 = (state_66010[(2)]);
var inst_65997 = fluree.db.util.async.throw_err.call(null,inst_65996);
var state_66010__$1 = state_66010;
var statearr_66040_66119 = state_66010__$1;
(statearr_66040_66119[(2)] = inst_65997);

(statearr_66040_66119[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (33))){
var inst_65837 = (state_66010[(8)]);
var inst_65895 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65837)].join('');
var inst_65896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65897 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65898 = cljs.core.PersistentHashMap.fromArrays(inst_65896,inst_65897);
var inst_65899 = cljs.core.ex_info.call(null,inst_65895,inst_65898);
var inst_65900 = (function(){throw inst_65899})();
var state_66010__$1 = state_66010;
var statearr_66041_66120 = state_66010__$1;
(statearr_66041_66120[(2)] = inst_65900);

(statearr_66041_66120[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (13))){
var state_66010__$1 = state_66010;
var statearr_66042_66121 = state_66010__$1;
(statearr_66042_66121[(2)] = null);

(statearr_66042_66121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (22))){
var inst_65868 = (state_66010[(2)]);
var inst_65869 = fluree.db.util.async.throw_err.call(null,inst_65868);
var inst_65870 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65869);
var inst_65871 = (inst_65870 - (1));
var state_66010__$1 = state_66010;
var statearr_66043_66122 = state_66010__$1;
(statearr_66043_66122[(2)] = inst_65871);

(statearr_66043_66122[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (36))){
var inst_65837 = (state_66010[(8)]);
var inst_65906 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65837)].join('');
var inst_65907 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65908 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65909 = cljs.core.PersistentHashMap.fromArrays(inst_65907,inst_65908);
var inst_65910 = cljs.core.ex_info.call(null,inst_65906,inst_65909);
var inst_65911 = (function(){throw inst_65910})();
var state_66010__$1 = state_66010;
var statearr_66044_66123 = state_66010__$1;
(statearr_66044_66123[(2)] = inst_65911);

(statearr_66044_66123[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (41))){
var inst_65874 = (state_66010[(15)]);
var inst_65884 = (state_66010[(19)]);
var inst_65841 = (state_66010[(10)]);
var inst_65979 = (state_66010[(2)]);
var inst_65980 = cljs.core.nth.call(null,inst_65979,(0),null);
var inst_65981 = cljs.core.nth.call(null,inst_65979,(1),null);
var inst_65982 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65983 = [inst_65874,inst_65884];
var inst_65984 = cljs.core.PersistentHashMap.fromArrays(inst_65982,inst_65983);
var inst_65985 = fluree.db.query.range.time_range.call(null,inst_65841,inst_65981,cljs.core._EQ_,inst_65980,inst_65984);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(51),inst_65985);
} else {
if((state_val_66011 === (43))){
var inst_65927 = (state_66010[(16)]);
var inst_65928 = (state_66010[(17)]);
var inst_65926 = (state_66010[(18)]);
var inst_65950 = (inst_65926 == null);
var inst_65951 = (inst_65927 == null);
var inst_65952 = cljs.core.not.call(null,inst_65951);
var inst_65953 = (inst_65928 == null);
var inst_65954 = cljs.core.not.call(null,inst_65953);
var inst_65955 = ((inst_65950) && (inst_65952) && (inst_65954));
var state_66010__$1 = state_66010;
if(cljs.core.truth_(inst_65955)){
var statearr_66045_66124 = state_66010__$1;
(statearr_66045_66124[(1)] = (45));

} else {
var statearr_66046_66125 = state_66010__$1;
(statearr_66046_66125[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (29))){
var inst_65918 = (state_66010[(12)]);
var inst_65926 = (state_66010[(18)]);
var inst_65918__$1 = (state_66010[(2)]);
var inst_65919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65920 = cljs.core.get.call(null,inst_65918__$1,(0));
var inst_65921 = cljs.core.get.call(null,inst_65918__$1,(1));
var inst_65922 = cljs.core.get.call(null,inst_65918__$1,(2));
var inst_65923 = cljs.core.get.call(null,inst_65918__$1,(3));
var inst_65924 = [inst_65920,inst_65921,inst_65922,inst_65923];
var inst_65925 = (new cljs.core.PersistentVector(null,4,(5),inst_65919,inst_65924,null));
var inst_65926__$1 = cljs.core.nth.call(null,inst_65925,(0),null);
var inst_65927 = cljs.core.nth.call(null,inst_65925,(1),null);
var inst_65928 = cljs.core.nth.call(null,inst_65925,(2),null);
var inst_65929 = cljs.core.nth.call(null,inst_65925,(3),null);
var inst_65930 = (inst_65926__$1 == null);
var inst_65931 = cljs.core.not.call(null,inst_65930);
var state_66010__$1 = (function (){var statearr_66047 = state_66010;
(statearr_66047[(16)] = inst_65927);

(statearr_66047[(12)] = inst_65918__$1);

(statearr_66047[(20)] = inst_65929);

(statearr_66047[(17)] = inst_65928);

(statearr_66047[(18)] = inst_65926__$1);

return statearr_66047;
})();
if(inst_65931){
var statearr_66048_66126 = state_66010__$1;
(statearr_66048_66126[(1)] = (39));

} else {
var statearr_66049_66127 = state_66010__$1;
(statearr_66049_66127[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (44))){
var inst_65977 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66050_66128 = state_66010__$1;
(statearr_66050_66128[(2)] = inst_65977);

(statearr_66050_66128[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (6))){
var state_66010__$1 = state_66010;
var statearr_66051_66129 = state_66010__$1;
(statearr_66051_66129[(2)] = false);

(statearr_66051_66129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (28))){
var inst_65837 = (state_66010[(8)]);
var inst_65891 = cljs.core.sequential_QMARK_.call(null,inst_65837);
var state_66010__$1 = state_66010;
if(inst_65891){
var statearr_66052_66130 = state_66010__$1;
(statearr_66052_66130[(1)] = (30));

} else {
var statearr_66053_66131 = state_66010__$1;
(statearr_66053_66131[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (51))){
var inst_65988 = (state_66010[(21)]);
var inst_65841 = (state_66010[(10)]);
var inst_65987 = (state_66010[(2)]);
var inst_65988__$1 = fluree.db.util.async.throw_err.call(null,inst_65987);
var inst_65989 = fluree.db.api_js.format_history_resp.call(null,inst_65841,inst_65988__$1);
var state_66010__$1 = (function (){var statearr_66054 = state_66010;
(statearr_66054[(21)] = inst_65988__$1);

return statearr_66054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(52),inst_65989);
} else {
if((state_val_66011 === (25))){
var inst_65837 = (state_66010[(8)]);
var inst_65884 = (state_66010[(2)]);
var inst_65885 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_65837);
var state_66010__$1 = (function (){var statearr_66055 = state_66010;
(statearr_66055[(19)] = inst_65884);

return statearr_66055;
})();
if(inst_65885){
var statearr_66056_66132 = state_66010__$1;
(statearr_66056_66132[(1)] = (27));

} else {
var statearr_66057_66133 = state_66010__$1;
(statearr_66057_66133[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (34))){
var inst_65837 = (state_66010[(8)]);
var state_66010__$1 = state_66010;
var statearr_66058_66134 = state_66010__$1;
(statearr_66058_66134[(2)] = inst_65837);

(statearr_66058_66134[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (17))){
var inst_65850 = (state_66010[(22)]);
var state_66010__$1 = state_66010;
var statearr_66059_66135 = state_66010__$1;
(statearr_66059_66135[(2)] = inst_65850);

(statearr_66059_66135[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (3))){
var state_66010__$1 = state_66010;
var statearr_66060_66136 = state_66010__$1;
(statearr_66060_66136[(2)] = false);

(statearr_66060_66136[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (12))){
var inst_65841 = (state_66010[(10)]);
var inst_65843 = fluree.db.api_js.resolve_block_range.call(null,inst_65841,query_map);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(15),inst_65843);
} else {
if((state_val_66011 === (2))){
var inst_65814 = (state_66010[(9)]);
var inst_65819 = inst_65814.cljs$lang$protocol_mask$partition0$;
var inst_65820 = (inst_65819 & (64));
var inst_65821 = inst_65814.cljs$core$ISeq$;
var inst_65822 = (cljs.core.PROTOCOL_SENTINEL === inst_65821);
var inst_65823 = ((inst_65820) || (inst_65822));
var state_66010__$1 = state_66010;
if(cljs.core.truth_(inst_65823)){
var statearr_66061_66137 = state_66010__$1;
(statearr_66061_66137[(1)] = (5));

} else {
var statearr_66062_66138 = state_66010__$1;
(statearr_66062_66138[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (23))){
var inst_65841 = (state_66010[(10)]);
var inst_65851 = (state_66010[(14)]);
var inst_65876 = fluree.db.time_travel.as_of_block.call(null,inst_65841,inst_65851);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(26),inst_65876);
} else {
if((state_val_66011 === (47))){
var inst_65975 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66063_66139 = state_66010__$1;
(statearr_66063_66139[(2)] = inst_65975);

(statearr_66063_66139[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (35))){
var inst_65903 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66064_66140 = state_66010__$1;
(statearr_66064_66140[(2)] = inst_65903);

(statearr_66064_66140[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (19))){
var inst_65850 = (state_66010[(22)]);
var inst_65841 = (state_66010[(10)]);
var inst_65865 = (inst_65850 - (1));
var inst_65866 = fluree.db.time_travel.as_of_block.call(null,inst_65841,inst_65865);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(22),inst_65866);
} else {
if((state_val_66011 === (57))){
var inst_66000 = (state_66010[(7)]);
var inst_65988 = (state_66010[(21)]);
var inst_66002 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_66003 = cljs.core.count.call(null,inst_65988);
var inst_66004 = [inst_66000,inst_66003,(200)];
var inst_66005 = cljs.core.PersistentHashMap.fromArrays(inst_66002,inst_66004);
var state_66010__$1 = state_66010;
var statearr_66065_66141 = state_66010__$1;
(statearr_66065_66141[(2)] = inst_66005);

(statearr_66065_66141[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (11))){
var inst_65836 = (state_66010[(23)]);
var inst_65840 = (state_66010[(2)]);
var inst_65841 = fluree.db.util.async.throw_err.call(null,inst_65840);
var state_66010__$1 = (function (){var statearr_66066 = state_66010;
(statearr_66066[(10)] = inst_65841);

return statearr_66066;
})();
if(cljs.core.truth_(inst_65836)){
var statearr_66067_66142 = state_66010__$1;
(statearr_66067_66142[(1)] = (12));

} else {
var statearr_66068_66143 = state_66010__$1;
(statearr_66068_66143[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (9))){
var inst_65814 = (state_66010[(9)]);
var state_66010__$1 = state_66010;
var statearr_66069_66144 = state_66010__$1;
(statearr_66069_66144[(2)] = inst_65814);

(statearr_66069_66144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (5))){
var state_66010__$1 = state_66010;
var statearr_66070_66145 = state_66010__$1;
(statearr_66070_66145[(2)] = true);

(statearr_66070_66145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (14))){
var inst_65850 = (state_66010[(22)]);
var inst_65849 = (state_66010[(2)]);
var inst_65850__$1 = cljs.core.nth.call(null,inst_65849,(0),null);
var inst_65851 = cljs.core.nth.call(null,inst_65849,(1),null);
var inst_65858 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66010__$1 = (function (){var statearr_66071 = state_66010;
(statearr_66071[(22)] = inst_65850__$1);

(statearr_66071[(11)] = inst_65858);

(statearr_66071[(14)] = inst_65851);

return statearr_66071;
})();
if(cljs.core.truth_(inst_65850__$1)){
var statearr_66072_66146 = state_66010__$1;
(statearr_66072_66146[(1)] = (16));

} else {
var statearr_66073_66147 = state_66010__$1;
(statearr_66073_66147[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (45))){
var inst_65927 = (state_66010[(16)]);
var inst_65929 = (state_66010[(20)]);
var inst_65928 = (state_66010[(17)]);
var inst_65926 = (state_66010[(18)]);
var inst_65957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65959 = [inst_65927,inst_65928,inst_65926,inst_65929];
var inst_65960 = (new cljs.core.PersistentVector(null,4,(5),inst_65958,inst_65959,null));
var inst_65961 = [inst_65960,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65962 = (new cljs.core.PersistentVector(null,2,(5),inst_65957,inst_65961,null));
var state_66010__$1 = state_66010;
var statearr_66074_66148 = state_66010__$1;
(statearr_66074_66148[(2)] = inst_65962);

(statearr_66074_66148[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (53))){
var inst_65841 = (state_66010[(10)]);
var inst_65992 = (state_66010[(13)]);
var inst_65994 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_65841,inst_65992);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(56),inst_65994);
} else {
if((state_val_66011 === (26))){
var inst_65878 = (state_66010[(2)]);
var inst_65879 = fluree.db.util.async.throw_err.call(null,inst_65878);
var inst_65880 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65879);
var state_66010__$1 = state_66010;
var statearr_66075_66149 = state_66010__$1;
(statearr_66075_66149[(2)] = inst_65880);

(statearr_66075_66149[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (16))){
var inst_65850 = (state_66010[(22)]);
var inst_65860 = cljs.core.not_EQ_.call(null,(1),inst_65850);
var state_66010__$1 = state_66010;
var statearr_66076_66150 = state_66010__$1;
(statearr_66076_66150[(2)] = inst_65860);

(statearr_66076_66150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (38))){
var inst_65914 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66077_66151 = state_66010__$1;
(statearr_66077_66151[(2)] = inst_65914);

(statearr_66077_66151[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (30))){
var inst_65837 = (state_66010[(8)]);
var inst_65893 = cljs.core.empty_QMARK_.call(null,inst_65837);
var state_66010__$1 = state_66010;
if(inst_65893){
var statearr_66078_66152 = state_66010__$1;
(statearr_66078_66152[(1)] = (33));

} else {
var statearr_66079_66153 = state_66010__$1;
(statearr_66079_66153[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (10))){
var inst_65835 = (state_66010[(2)]);
var inst_65836 = cljs.core.get.call(null,inst_65835,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65837 = cljs.core.get.call(null,inst_65835,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_65838 = cljs.core.get.call(null,inst_65835,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_66010__$1 = (function (){var statearr_66080 = state_66010;
(statearr_66080[(23)] = inst_65836);

(statearr_66080[(24)] = inst_65838);

(statearr_66080[(8)] = inst_65837);

return statearr_66080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66010__$1,(11),sources);
} else {
if((state_val_66011 === (18))){
var inst_65863 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
if(cljs.core.truth_(inst_65863)){
var statearr_66081_66154 = state_66010__$1;
(statearr_66081_66154[(1)] = (19));

} else {
var statearr_66082_66155 = state_66010__$1;
(statearr_66082_66155[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (52))){
var inst_65838 = (state_66010[(24)]);
var inst_65991 = (state_66010[(2)]);
var inst_65992 = fluree.db.util.async.throw_err.call(null,inst_65991);
var state_66010__$1 = (function (){var statearr_66083 = state_66010;
(statearr_66083[(13)] = inst_65992);

return statearr_66083;
})();
if(cljs.core.truth_(inst_65838)){
var statearr_66084_66156 = state_66010__$1;
(statearr_66084_66156[(1)] = (53));

} else {
var statearr_66085_66157 = state_66010__$1;
(statearr_66085_66157[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (42))){
var inst_65927 = (state_66010[(16)]);
var inst_65929 = (state_66010[(20)]);
var inst_65928 = (state_66010[(17)]);
var inst_65926 = (state_66010[(18)]);
var inst_65943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65945 = [inst_65927,inst_65926,inst_65928,inst_65929];
var inst_65946 = (new cljs.core.PersistentVector(null,4,(5),inst_65944,inst_65945,null));
var inst_65947 = [inst_65946,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65948 = (new cljs.core.PersistentVector(null,2,(5),inst_65943,inst_65947,null));
var state_66010__$1 = state_66010;
var statearr_66086_66158 = state_66010__$1;
(statearr_66086_66158[(2)] = inst_65948);

(statearr_66086_66158[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (37))){
var state_66010__$1 = state_66010;
var statearr_66087_66159 = state_66010__$1;
(statearr_66087_66159[(2)] = null);

(statearr_66087_66159[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (8))){
var inst_65814 = (state_66010[(9)]);
var inst_65832 = cljs.core.apply.call(null,cljs.core.hash_map,inst_65814);
var state_66010__$1 = state_66010;
var statearr_66088_66160 = state_66010__$1;
(statearr_66088_66160[(2)] = inst_65832);

(statearr_66088_66160[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (49))){
var state_66010__$1 = state_66010;
var statearr_66089_66161 = state_66010__$1;
(statearr_66089_66161[(2)] = null);

(statearr_66089_66161[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66090 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66090[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66090[(1)] = (1));

return statearr_66090;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66010){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_66010);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66091){var ex__2882__auto__ = e66091;
var statearr_66092_66162 = state_66010;
(statearr_66092_66162[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_66010[(4)]))){
var statearr_66093_66163 = state_66010;
(statearr_66093_66163[(1)] = cljs.core.first.call(null,(state_66010[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66164 = state_66010;
state_66010 = G__66164;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66010){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66094 = f__2902__auto__.call(null);
(statearr_66094[(6)] = c__2901__auto__);

return statearr_66094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__66172 = arguments.length;
switch (G__66172) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__66165_SHARP_){
return cljs.core.dissoc.call(null,p1__66165_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66261){
var state_val_66262 = (state_66261[(1)]);
if((state_val_66262 === (7))){
var inst_66218 = (state_66261[(7)]);
var inst_66222 = (state_66261[(8)]);
var inst_66212 = (state_66261[(9)]);
var inst_66215 = (state_66261[(10)]);
var inst_66228 = (function (){var responses = inst_66212;
var responses_STAR_ = inst_66215;
var statuses = inst_66218;
var fuel = inst_66222;
return (function (p1__66168_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__66168_SHARP_);
});
})();
var inst_66229 = cljs.core.some.call(null,inst_66228,inst_66218);
var state_66261__$1 = state_66261;
if(cljs.core.truth_(inst_66229)){
var statearr_66263_66311 = state_66261__$1;
(statearr_66263_66311[(1)] = (9));

} else {
var statearr_66264_66312 = state_66261__$1;
(statearr_66264_66312[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (20))){
var inst_66256 = (state_66261[(2)]);
var state_66261__$1 = state_66261;
var statearr_66265_66313 = state_66261__$1;
(statearr_66265_66313[(2)] = inst_66256);

(statearr_66265_66313[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (1))){
var inst_66207 = cljs.core.async.chan.call(null,(1));
var inst_66208 = (function (){var c__2901__auto____$1 = inst_66207;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66205){
var state_val_66206 = (state_66205[(1)]);
if((state_val_66206 === (1))){
var inst_66173 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_66174 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_66175 = cljs.core.assoc.call(null,inst_66174,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_66176 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_66177 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_66178 = cljs.core.PersistentHashMap.EMPTY;
var inst_66179 = inst_66173;
var inst_66180 = inst_66175;
var inst_66181 = inst_66176;
var inst_66182 = inst_66177;
var inst_66183 = inst_66178;
var state_66205__$1 = (function (){var statearr_66266 = state_66205;
(statearr_66266[(7)] = inst_66183);

(statearr_66266[(8)] = inst_66182);

(statearr_66266[(9)] = inst_66179);

(statearr_66266[(10)] = inst_66180);

(statearr_66266[(11)] = inst_66181);

return statearr_66266;
})();
var statearr_66267_66314 = state_66205__$1;
(statearr_66267_66314[(2)] = null);

(statearr_66267_66314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66206 === (2))){
var inst_66180 = (state_66205[(10)]);
var inst_66185 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_66180);
var inst_66186 = cljs.core.merge.call(null,opts,inst_66185);
var inst_66187 = cljs.core.assoc.call(null,inst_66180,new cljs.core.Keyword(null,"opts","opts",155075701),inst_66186);
var inst_66188 = fluree.db.api_js.query_async.call(null,db,inst_66187,db_fn);
var state_66205__$1 = state_66205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66205__$1,(4),inst_66188);
} else {
if((state_val_66206 === (3))){
var inst_66203 = (state_66205[(2)]);
var state_66205__$1 = state_66205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66205__$1,inst_66203);
} else {
if((state_val_66206 === (4))){
var inst_66183 = (state_66205[(7)]);
var inst_66179 = (state_66205[(9)]);
var inst_66181 = (state_66205[(11)]);
var inst_66190 = (state_66205[(2)]);
var inst_66191 = cljs.core.assoc.call(null,inst_66183,inst_66179,inst_66190);
var inst_66192 = cljs.core.first.call(null,inst_66181);
var state_66205__$1 = (function (){var statearr_66268 = state_66205;
(statearr_66268[(12)] = inst_66191);

return statearr_66268;
})();
if(cljs.core.truth_(inst_66192)){
var statearr_66269_66315 = state_66205__$1;
(statearr_66269_66315[(1)] = (5));

} else {
var statearr_66270_66316 = state_66205__$1;
(statearr_66270_66316[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66206 === (5))){
var inst_66191 = (state_66205[(12)]);
var inst_66182 = (state_66205[(8)]);
var inst_66181 = (state_66205[(11)]);
var inst_66194 = cljs.core.first.call(null,inst_66181);
var inst_66195 = cljs.core.first.call(null,inst_66182);
var inst_66196 = cljs.core.rest.call(null,inst_66181);
var inst_66197 = cljs.core.rest.call(null,inst_66182);
var inst_66179 = inst_66194;
var inst_66180 = inst_66195;
var inst_66181__$1 = inst_66196;
var inst_66182__$1 = inst_66197;
var inst_66183 = inst_66191;
var state_66205__$1 = (function (){var statearr_66271 = state_66205;
(statearr_66271[(7)] = inst_66183);

(statearr_66271[(8)] = inst_66182__$1);

(statearr_66271[(9)] = inst_66179);

(statearr_66271[(10)] = inst_66180);

(statearr_66271[(11)] = inst_66181__$1);

return statearr_66271;
})();
var statearr_66272_66317 = state_66205__$1;
(statearr_66272_66317[(2)] = null);

(statearr_66272_66317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66206 === (6))){
var inst_66191 = (state_66205[(12)]);
var state_66205__$1 = state_66205;
var statearr_66273_66318 = state_66205__$1;
(statearr_66273_66318[(2)] = inst_66191);

(statearr_66273_66318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66206 === (7))){
var inst_66201 = (state_66205[(2)]);
var state_66205__$1 = state_66205;
var statearr_66274_66319 = state_66205__$1;
(statearr_66274_66319[(2)] = inst_66201);

(statearr_66274_66319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66275 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66275[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66275[(1)] = (1));

return statearr_66275;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66205){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_66205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66276){var ex__2882__auto__ = e66276;
var statearr_66277_66320 = state_66205;
(statearr_66277_66320[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_66205[(4)]))){
var statearr_66278_66321 = state_66205;
(statearr_66278_66321[(1)] = cljs.core.first.call(null,(state_66205[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66322 = state_66205;
state_66205 = G__66322;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66205){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66279 = f__2902__auto__.call(null);
(statearr_66279[(6)] = c__2901__auto____$1);

return statearr_66279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
});
})();
var inst_66209 = cljs.core.async.impl.dispatch.run.call(null,inst_66208);
var state_66261__$1 = (function (){var statearr_66280 = state_66261;
(statearr_66280[(11)] = inst_66209);

return statearr_66280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66261__$1,(2),inst_66207);
} else {
if((state_val_66262 === (4))){
var inst_66212 = (state_66261[(9)]);
var state_66261__$1 = state_66261;
var statearr_66281_66323 = state_66261__$1;
(statearr_66281_66323[(2)] = inst_66212);

(statearr_66281_66323[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (15))){
var state_66261__$1 = state_66261;
var statearr_66282_66324 = state_66261__$1;
(statearr_66282_66324[(2)] = (400));

(statearr_66282_66324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (13))){
var state_66261__$1 = state_66261;
var statearr_66283_66325 = state_66261__$1;
(statearr_66283_66325[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (6))){
var inst_66218 = (state_66261[(7)]);
var inst_66226 = cljs.core.first.call(null,inst_66218);
var state_66261__$1 = state_66261;
var statearr_66285_66326 = state_66261__$1;
(statearr_66285_66326[(2)] = inst_66226);

(statearr_66285_66326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (17))){
var inst_66239 = (state_66261[(2)]);
var state_66261__$1 = state_66261;
var statearr_66286_66327 = state_66261__$1;
(statearr_66286_66327[(2)] = inst_66239);

(statearr_66286_66327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (3))){
var inst_66218 = (state_66261[(7)]);
var inst_66222 = (state_66261[(8)]);
var inst_66212 = (state_66261[(9)]);
var inst_66215 = (state_66261[(10)]);
var inst_66217 = cljs.core.vals.call(null,inst_66212);
var inst_66218__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_66217);
var inst_66219 = (function (){var responses = inst_66212;
var responses_STAR_ = inst_66215;
var statuses = inst_66218__$1;
return (function (p1__66166_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__66166_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_66220 = cljs.core.vals.call(null,inst_66212);
var inst_66221 = cljs.core.map.call(null,inst_66219,inst_66220);
var inst_66222__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_66221);
var inst_66223 = (function (){var responses = inst_66212;
var responses_STAR_ = inst_66215;
var statuses = inst_66218__$1;
var fuel = inst_66222__$1;
return (function (p1__66167_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__66167_SHARP_);
});
})();
var inst_66224 = cljs.core.every_QMARK_.call(null,inst_66223,inst_66218__$1);
var state_66261__$1 = (function (){var statearr_66287 = state_66261;
(statearr_66287[(7)] = inst_66218__$1);

(statearr_66287[(8)] = inst_66222__$1);

return statearr_66287;
})();
if(inst_66224){
var statearr_66288_66328 = state_66261__$1;
(statearr_66288_66328[(1)] = (6));

} else {
var statearr_66289_66329 = state_66261__$1;
(statearr_66289_66329[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (12))){
var state_66261__$1 = state_66261;
var statearr_66290_66330 = state_66261__$1;
(statearr_66290_66330[(2)] = (500));

(statearr_66290_66330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (2))){
var inst_66212 = (state_66261[(9)]);
var inst_66211 = (state_66261[(2)]);
var inst_66212__$1 = fluree.db.util.async.throw_err.call(null,inst_66211);
var inst_66213 = (function (){var responses = inst_66212__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_66214 = cljs.core.PersistentHashMap.EMPTY;
var inst_66215 = cljs.core.reduce_kv.call(null,inst_66213,inst_66214,inst_66212__$1);
var state_66261__$1 = (function (){var statearr_66291 = state_66261;
(statearr_66291[(9)] = inst_66212__$1);

(statearr_66291[(10)] = inst_66215);

return statearr_66291;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_66292_66331 = state_66261__$1;
(statearr_66292_66331[(1)] = (3));

} else {
var statearr_66293_66332 = state_66261__$1;
(statearr_66293_66332[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (19))){
var inst_66222 = (state_66261[(8)]);
var inst_66245 = (state_66261[(12)]);
var inst_66215 = (state_66261[(10)]);
var inst_66254 = cljs.core.assoc.call(null,inst_66215,new cljs.core.Keyword(null,"status","status",-1997798413),inst_66245,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_66222);
var state_66261__$1 = state_66261;
var statearr_66294_66333 = state_66261__$1;
(statearr_66294_66333[(2)] = inst_66254);

(statearr_66294_66333[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (11))){
var inst_66243 = (state_66261[(2)]);
var state_66261__$1 = state_66261;
var statearr_66295_66334 = state_66261__$1;
(statearr_66295_66334[(2)] = inst_66243);

(statearr_66295_66334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (9))){
var state_66261__$1 = state_66261;
var statearr_66296_66335 = state_66261__$1;
(statearr_66296_66335[(2)] = (207));

(statearr_66296_66335[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (5))){
var inst_66259 = (state_66261[(2)]);
var state_66261__$1 = state_66261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66261__$1,inst_66259);
} else {
if((state_val_66262 === (14))){
var inst_66241 = (state_66261[(2)]);
var state_66261__$1 = state_66261;
var statearr_66297_66336 = state_66261__$1;
(statearr_66297_66336[(2)] = inst_66241);

(statearr_66297_66336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (16))){
var state_66261__$1 = state_66261;
var statearr_66298_66337 = state_66261__$1;
(statearr_66298_66337[(2)] = null);

(statearr_66298_66337[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (10))){
var inst_66218 = (state_66261[(7)]);
var inst_66222 = (state_66261[(8)]);
var inst_66212 = (state_66261[(9)]);
var inst_66215 = (state_66261[(10)]);
var inst_66232 = (function (){var responses = inst_66212;
var responses_STAR_ = inst_66215;
var statuses = inst_66218;
var fuel = inst_66222;
return (function (p1__66169_SHARP_){
return ((499) < p1__66169_SHARP_);
});
})();
var inst_66233 = cljs.core.some.call(null,inst_66232,inst_66218);
var state_66261__$1 = state_66261;
if(cljs.core.truth_(inst_66233)){
var statearr_66299_66338 = state_66261__$1;
(statearr_66299_66338[(1)] = (12));

} else {
var statearr_66300_66339 = state_66261__$1;
(statearr_66300_66339[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (18))){
var inst_66222 = (state_66261[(8)]);
var inst_66250 = (state_66261[(13)]);
var inst_66245 = (state_66261[(12)]);
var inst_66215 = (state_66261[(10)]);
var inst_66252 = cljs.core.assoc.call(null,inst_66215,new cljs.core.Keyword(null,"status","status",-1997798413),inst_66245,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_66222,new cljs.core.Keyword(null,"block","block",664686210),inst_66250);
var state_66261__$1 = state_66261;
var statearr_66301_66340 = state_66261__$1;
(statearr_66301_66340[(2)] = inst_66252);

(statearr_66301_66340[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66262 === (8))){
var inst_66218 = (state_66261[(7)]);
var inst_66222 = (state_66261[(8)]);
var inst_66250 = (state_66261[(13)]);
var inst_66212 = (state_66261[(9)]);
var inst_66245 = (state_66261[(12)]);
var inst_66215 = (state_66261[(10)]);
var inst_66245__$1 = (state_66261[(2)]);
var inst_66246 = (function (){var responses = inst_66212;
var responses_STAR_ = inst_66215;
var statuses = inst_66218;
var fuel = inst_66222;
var status = inst_66245__$1;
return (function (p1__66170_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__66170_SHARP_));
});
})();
var inst_66247 = cljs.core.vals.call(null,inst_66212);
var inst_66248 = cljs.core.filter.call(null,inst_66246,inst_66247);
var inst_66249 = cljs.core.first.call(null,inst_66248);
var inst_66250__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66249);
var state_66261__$1 = (function (){var statearr_66302 = state_66261;
(statearr_66302[(13)] = inst_66250__$1);

(statearr_66302[(12)] = inst_66245__$1);

return statearr_66302;
})();
if(cljs.core.truth_(inst_66250__$1)){
var statearr_66303_66341 = state_66261__$1;
(statearr_66303_66341[(1)] = (18));

} else {
var statearr_66304_66342 = state_66261__$1;
(statearr_66304_66342[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66305[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66305[(1)] = (1));

return statearr_66305;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66261){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_66261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66306){var ex__2882__auto__ = e66306;
var statearr_66307_66343 = state_66261;
(statearr_66307_66343[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_66261[(4)]))){
var statearr_66308_66344 = state_66261;
(statearr_66308_66344[(1)] = cljs.core.first.call(null,(state_66261[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66345 = state_66261;
state_66261 = G__66345;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66261){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66309 = f__2902__auto__.call(null);
(statearr_66309[(6)] = c__2901__auto__);

return statearr_66309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__66347 = arguments.length;
switch (G__66347) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__66348 = opts;
var map__66348__$1 = (((((!((map__66348 == null))))?(((((map__66348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66348):map__66348);
var auth = cljs.core.get.call(null,map__66348__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__66348__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__66348__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__66348__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__66349 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__66349,(0),null);
var authority = cljs.core.nth.call(null,vec__66349,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e66353){var e = e66353;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__66356 = arguments.length;
switch (G__66356) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66387){
var state_val_66388 = (state_66387[(1)]);
if((state_val_66388 === (7))){
var state_66387__$1 = state_66387;
var statearr_66389_66410 = state_66387__$1;
(statearr_66389_66410[(2)] = opts);

(statearr_66389_66410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (1))){
var state_66387__$1 = state_66387;
var statearr_66390_66411 = state_66387__$1;
(statearr_66390_66411[(2)] = null);

(statearr_66390_66411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (4))){
var inst_66357 = (state_66387[(2)]);
var inst_66358 = fluree.db.util.log.error.call(null,inst_66357);
var inst_66359 = cljs.core.ex_data.call(null,inst_66357);
var inst_66360 = cljs.core.ex_message.call(null,inst_66357);
var inst_66361 = cljs.core.assoc.call(null,inst_66359,new cljs.core.Keyword(null,"message","message",-406056002),inst_66360);
var state_66387__$1 = (function (){var statearr_66391 = state_66387;
(statearr_66391[(7)] = inst_66358);

return statearr_66391;
})();
var statearr_66392_66412 = state_66387__$1;
(statearr_66392_66412[(2)] = inst_66361);

(statearr_66392_66412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (6))){
var inst_66371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66372 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66373 = (new cljs.core.PersistentVector(null,1,(5),inst_66371,inst_66372,null));
var inst_66374 = cljs.core.assoc_in.call(null,opts,inst_66373,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66387__$1 = state_66387;
var statearr_66393_66413 = state_66387__$1;
(statearr_66393_66413[(2)] = inst_66374);

(statearr_66393_66413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (3))){
var inst_66385 = (state_66387[(2)]);
var state_66387__$1 = state_66387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66387__$1,inst_66385);
} else {
if((state_val_66388 === (2))){
var _ = (function (){var statearr_66395 = state_66387;
(statearr_66395[(4)] = cljs.core.cons.call(null,(5),(state_66387[(4)])));

return statearr_66395;
})();
var inst_66367 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66368 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66369 = (inst_66368 == null);
var state_66387__$1 = (function (){var statearr_66396 = state_66387;
(statearr_66396[(8)] = inst_66367);

return statearr_66396;
})();
if(cljs.core.truth_(inst_66369)){
var statearr_66397_66414 = state_66387__$1;
(statearr_66397_66414[(1)] = (6));

} else {
var statearr_66398_66415 = state_66387__$1;
(statearr_66398_66415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (9))){
var inst_66381 = (state_66387[(2)]);
var inst_66382 = fluree.db.util.async.throw_err.call(null,inst_66381);
var _ = (function (){var statearr_66399 = state_66387;
(statearr_66399[(4)] = cljs.core.rest.call(null,(state_66387[(4)])));

return statearr_66399;
})();
var state_66387__$1 = state_66387;
var statearr_66400_66416 = state_66387__$1;
(statearr_66400_66416[(2)] = inst_66382);

(statearr_66400_66416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (5))){
var _ = (function (){var statearr_66401 = state_66387;
(statearr_66401[(4)] = cljs.core.rest.call(null,(state_66387[(4)])));

return statearr_66401;
})();
var state_66387__$1 = state_66387;
var ex66394 = (state_66387__$1[(2)]);
var statearr_66402_66417 = state_66387__$1;
(statearr_66402_66417[(5)] = ex66394);


var statearr_66403_66418 = state_66387__$1;
(statearr_66403_66418[(1)] = (4));

(statearr_66403_66418[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66388 === (8))){
var inst_66367 = (state_66387[(8)]);
var inst_66377 = (state_66387[(2)]);
var inst_66378 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_66367,inst_66377);
var inst_66379 = fluree.db.operations.command_async.call(null,conn,inst_66378);
var state_66387__$1 = state_66387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66387__$1,(9),inst_66379);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66404 = [null,null,null,null,null,null,null,null,null];
(statearr_66404[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66404[(1)] = (1));

return statearr_66404;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66387){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_66387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66405){var ex__2882__auto__ = e66405;
var statearr_66406_66419 = state_66387;
(statearr_66406_66419[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_66387[(4)]))){
var statearr_66407_66420 = state_66387;
(statearr_66407_66420[(1)] = cljs.core.first.call(null,(state_66387[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66421 = state_66387;
state_66387 = G__66421;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66387){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66408 = f__2902__auto__.call(null);
(statearr_66408[(6)] = c__2901__auto__);

return statearr_66408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

