// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('goog.string.format');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__67315 = opts_SINGLEQUOTE_;
var map__67315__$1 = (((((!((map__67315 == null))))?(((((map__67315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67315):map__67315);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67315__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__67318 = arguments.length;
switch (G__67318) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__67321 = arguments.length;
switch (G__67321) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__67324 = arguments.length;
switch (G__67324) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__67327 = arguments.length;
switch (G__67327) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__67330 = arguments.length;
switch (G__67330) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__67333 = arguments.length;
switch (G__67333) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67342 = arguments.length;
var i__4737__auto___67343 = (0);
while(true){
if((i__4737__auto___67343 < len__4736__auto___67342)){
args__4742__auto__.push((arguments[i__4737__auto___67343]));

var G__67344 = (i__4737__auto___67343 + (1));
i__4737__auto___67343 = G__67344;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__67338){
var vec__67339 = p__67338;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67339,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq67335){
var G__67336 = cljs.core.first(seq67335);
var seq67335__$1 = cljs.core.next(seq67335);
var G__67337 = cljs.core.first(seq67335__$1);
var seq67335__$2 = cljs.core.next(seq67335__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67336,G__67337,seq67335__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67363){
var state_val_67364 = (state_67363[(1)]);
if((state_val_67364 === (1))){
var state_67363__$1 = state_67363;
var statearr_67365_67380 = state_67363__$1;
(statearr_67365_67380[(2)] = null);

(statearr_67365_67380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67364 === (2))){
var _ = (function (){var statearr_67366 = state_67363;
(statearr_67366[(4)] = cljs.core.cons((5),(state_67363[(4)])));

return statearr_67366;
})();
var state_67363__$1 = state_67363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67363__$1,(6),db);
} else {
if((state_val_67364 === (3))){
var inst_67361 = (state_67363[(2)]);
var state_67363__$1 = state_67363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67363__$1,inst_67361);
} else {
if((state_val_67364 === (4))){
var inst_67345 = (state_67363[(2)]);
var inst_67346 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67345], 0));
var inst_67347 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67345) : reject.call(null,inst_67345));
var state_67363__$1 = (function (){var statearr_67368 = state_67363;
(statearr_67368[(7)] = inst_67346);

return statearr_67368;
})();
var statearr_67369_67381 = state_67363__$1;
(statearr_67369_67381[(2)] = inst_67347);

(statearr_67369_67381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67364 === (5))){
var _ = (function (){var statearr_67370 = state_67363;
(statearr_67370[(4)] = cljs.core.rest((state_67363[(4)])));

return statearr_67370;
})();
var state_67363__$1 = state_67363;
var ex67367 = (state_67363__$1[(2)]);
var statearr_67371_67382 = state_67363__$1;
(statearr_67371_67382[(5)] = ex67367);


var statearr_67372_67383 = state_67363__$1;
(statearr_67372_67383[(1)] = (4));

(statearr_67372_67383[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67364 === (6))){
var inst_67354 = (state_67363[(2)]);
var inst_67355 = fluree.db.util.async.throw_err(inst_67354);
var inst_67356 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_67355);
var inst_67357 = cljs.core.clj__GT_js(inst_67356);
var inst_67358 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67357) : resolve.call(null,inst_67357));
var _ = (function (){var statearr_67373 = state_67363;
(statearr_67373[(4)] = cljs.core.rest((state_67363[(4)])));

return statearr_67373;
})();
var state_67363__$1 = state_67363;
var statearr_67374_67384 = state_67363__$1;
(statearr_67374_67384[(2)] = inst_67358);

(statearr_67374_67384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2879__auto__ = null;
var flureedb$db_schema_$_state_machine__2879__auto____0 = (function (){
var statearr_67375 = [null,null,null,null,null,null,null,null];
(statearr_67375[(0)] = flureedb$db_schema_$_state_machine__2879__auto__);

(statearr_67375[(1)] = (1));

return statearr_67375;
});
var flureedb$db_schema_$_state_machine__2879__auto____1 = (function (state_67363){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67363);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67376){var ex__2882__auto__ = e67376;
var statearr_67377_67385 = state_67363;
(statearr_67377_67385[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67363[(4)]))){
var statearr_67378_67386 = state_67363;
(statearr_67378_67386[(1)] = cljs.core.first((state_67363[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67387 = state_67363;
state_67363 = G__67387;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2879__auto__ = function(state_67363){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2879__auto____1.call(this,state_67363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2879__auto____0;
flureedb$db_schema_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2879__auto____1;
return flureedb$db_schema_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67379 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67379[(6)] = c__2901__auto__);

return statearr_67379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__67389 = arguments.length;
switch (G__67389) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67479){
var state_val_67480 = (state_67479[(1)]);
if((state_val_67480 === (7))){
var inst_67402 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67479__$1 = state_67479;
var statearr_67481_67539 = state_67479__$1;
(statearr_67481_67539[(2)] = inst_67402);

(statearr_67481_67539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (20))){
var inst_67428 = (state_67479[(7)]);
var inst_67435 = (state_67479[(2)]);
var state_67479__$1 = (function (){var statearr_67482 = state_67479;
(statearr_67482[(8)] = inst_67435);

return statearr_67482;
})();
if(cljs.core.truth_(inst_67428)){
var statearr_67483_67540 = state_67479__$1;
(statearr_67483_67540[(1)] = (21));

} else {
var statearr_67484_67541 = state_67479__$1;
(statearr_67484_67541[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (27))){
var inst_67430 = (state_67479[(9)]);
var inst_67449 = (state_67479[(10)]);
var inst_67451 = fluree.crypto.sign_message(inst_67449,inst_67430);
var state_67479__$1 = state_67479;
var statearr_67485_67542 = state_67479__$1;
(statearr_67485_67542[(2)] = inst_67451);

(statearr_67485_67542[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (1))){
var state_67479__$1 = state_67479;
var statearr_67486_67543 = state_67479__$1;
(statearr_67486_67543[(2)] = null);

(statearr_67486_67543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (24))){
var inst_67443 = (state_67479[(11)]);
var inst_67445 = fluree.db.util.core.without_nils(inst_67443);
var inst_67446 = fluree.db.util.json.stringify(inst_67445);
var state_67479__$1 = state_67479;
var statearr_67487_67544 = state_67479__$1;
(statearr_67487_67544[(2)] = inst_67446);

(statearr_67487_67544[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (4))){
var inst_67390 = (state_67479[(2)]);
var inst_67391 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67390], 0));
var inst_67392 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67390) : reject.call(null,inst_67390));
var state_67479__$1 = (function (){var statearr_67488 = state_67479;
(statearr_67488[(12)] = inst_67391);

return statearr_67488;
})();
var statearr_67489_67545 = state_67479__$1;
(statearr_67489_67545[(2)] = inst_67392);

(statearr_67489_67545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (15))){
var inst_67404 = (state_67479[(13)]);
var inst_67423 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67404);
var state_67479__$1 = state_67479;
var statearr_67490_67546 = state_67479__$1;
(statearr_67490_67546[(2)] = inst_67423);

(statearr_67490_67546[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (21))){
var inst_67428 = (state_67479[(7)]);
var state_67479__$1 = state_67479;
var statearr_67491_67547 = state_67479__$1;
(statearr_67491_67547[(2)] = inst_67428);

(statearr_67491_67547[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (31))){
var inst_67443 = (state_67479[(11)]);
var inst_67464 = fluree.db.operations.unsigned_command_async(conn,inst_67443);
var state_67479__$1 = state_67479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67479__$1,(34),inst_67464);
} else {
if((state_val_67480 === (32))){
var inst_67469 = (state_67479[(2)]);
var inst_67470 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67471 = [(200),inst_67469];
var inst_67472 = cljs.core.PersistentHashMap.fromArrays(inst_67470,inst_67471);
var inst_67473 = cljs.core.clj__GT_js(inst_67472);
var inst_67474 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67473) : resolve.call(null,inst_67473));
var _ = (function (){var statearr_67492 = state_67479;
(statearr_67492[(4)] = cljs.core.rest((state_67479[(4)])));

return statearr_67492;
})();
var state_67479__$1 = state_67479;
var statearr_67493_67548 = state_67479__$1;
(statearr_67493_67548[(2)] = inst_67474);

(statearr_67493_67548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (33))){
var inst_67461 = (state_67479[(2)]);
var inst_67462 = fluree.db.util.async.throw_err(inst_67461);
var state_67479__$1 = state_67479;
var statearr_67494_67549 = state_67479__$1;
(statearr_67494_67549[(2)] = inst_67462);

(statearr_67494_67549[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (13))){
var state_67479__$1 = state_67479;
var statearr_67495_67550 = state_67479__$1;
(statearr_67495_67550[(2)] = false);

(statearr_67495_67550[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (22))){
var inst_67431 = (state_67479[(14)]);
var inst_67438 = (inst_67431 + (30000));
var state_67479__$1 = state_67479;
var statearr_67496_67551 = state_67479__$1;
(statearr_67496_67551[(2)] = inst_67438);

(statearr_67496_67551[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (29))){
var inst_67430 = (state_67479[(9)]);
var inst_67454 = (state_67479[(2)]);
var state_67479__$1 = (function (){var statearr_67497 = state_67479;
(statearr_67497[(15)] = inst_67454);

return statearr_67497;
})();
if(cljs.core.truth_(inst_67430)){
var statearr_67498_67552 = state_67479__$1;
(statearr_67498_67552[(1)] = (30));

} else {
var statearr_67499_67553 = state_67479__$1;
(statearr_67499_67553[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (6))){
var state_67479__$1 = state_67479;
var statearr_67500_67554 = state_67479__$1;
(statearr_67500_67554[(2)] = null);

(statearr_67500_67554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (28))){
var state_67479__$1 = state_67479;
var statearr_67501_67555 = state_67479__$1;
(statearr_67501_67555[(2)] = null);

(statearr_67501_67555[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (25))){
var state_67479__$1 = state_67479;
var statearr_67502_67556 = state_67479__$1;
(statearr_67502_67556[(2)] = null);

(statearr_67502_67556[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (34))){
var inst_67466 = (state_67479[(2)]);
var inst_67467 = fluree.db.util.async.throw_err(inst_67466);
var state_67479__$1 = state_67479;
var statearr_67503_67557 = state_67479__$1;
(statearr_67503_67557[(2)] = inst_67467);

(statearr_67503_67557[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (17))){
var inst_67427 = (state_67479[(16)]);
var inst_67426 = (state_67479[(2)]);
var inst_67427__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67426,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_67428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67426,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_67429 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67426,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_67430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67426,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_67431 = fluree.db.util.core.current_time_millis();
var state_67479__$1 = (function (){var statearr_67504 = state_67479;
(statearr_67504[(16)] = inst_67427__$1);

(statearr_67504[(17)] = inst_67429);

(statearr_67504[(9)] = inst_67430);

(statearr_67504[(7)] = inst_67428);

(statearr_67504[(14)] = inst_67431);

return statearr_67504;
})();
if(cljs.core.truth_(inst_67427__$1)){
var statearr_67505_67558 = state_67479__$1;
(statearr_67505_67558[(1)] = (18));

} else {
var statearr_67506_67559 = state_67479__$1;
(statearr_67506_67559[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (3))){
var inst_67477 = (state_67479[(2)]);
var state_67479__$1 = state_67479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67479__$1,inst_67477);
} else {
if((state_val_67480 === (12))){
var state_67479__$1 = state_67479;
var statearr_67507_67560 = state_67479__$1;
(statearr_67507_67560[(2)] = true);

(statearr_67507_67560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (2))){
var _ = (function (){var statearr_67508 = state_67479;
(statearr_67508[(4)] = cljs.core.cons((5),(state_67479[(4)])));

return statearr_67508;
})();
var inst_67399 = (opts == null);
var state_67479__$1 = state_67479;
if(cljs.core.truth_(inst_67399)){
var statearr_67509_67561 = state_67479__$1;
(statearr_67509_67561[(1)] = (6));

} else {
var statearr_67510_67562 = state_67479__$1;
(statearr_67510_67562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (23))){
var inst_67435 = (state_67479[(8)]);
var inst_67430 = (state_67479[(9)]);
var inst_67440 = (state_67479[(2)]);
var inst_67441 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_67442 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_67435,inst_67440];
var inst_67443 = cljs.core.PersistentHashMap.fromArrays(inst_67441,inst_67442);
var state_67479__$1 = (function (){var statearr_67511 = state_67479;
(statearr_67511[(11)] = inst_67443);

return statearr_67511;
})();
if(cljs.core.truth_(inst_67430)){
var statearr_67512_67563 = state_67479__$1;
(statearr_67512_67563[(1)] = (24));

} else {
var statearr_67513_67564 = state_67479__$1;
(statearr_67513_67564[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (19))){
var inst_67431 = (state_67479[(14)]);
var state_67479__$1 = state_67479;
var statearr_67514_67565 = state_67479__$1;
(statearr_67514_67565[(2)] = inst_67431);

(statearr_67514_67565[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (11))){
var inst_67421 = (state_67479[(2)]);
var state_67479__$1 = state_67479;
if(cljs.core.truth_(inst_67421)){
var statearr_67516_67566 = state_67479__$1;
(statearr_67516_67566[(1)] = (15));

} else {
var statearr_67517_67567 = state_67479__$1;
(statearr_67517_67567[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (9))){
var inst_67404 = (state_67479[(13)]);
var inst_67410 = inst_67404.cljs$lang$protocol_mask$partition0$;
var inst_67411 = (inst_67410 & (64));
var inst_67412 = inst_67404.cljs$core$ISeq$;
var inst_67413 = (cljs.core.PROTOCOL_SENTINEL === inst_67412);
var inst_67414 = ((inst_67411) || (inst_67413));
var state_67479__$1 = state_67479;
if(cljs.core.truth_(inst_67414)){
var statearr_67518_67568 = state_67479__$1;
(statearr_67518_67568[(1)] = (12));

} else {
var statearr_67519_67569 = state_67479__$1;
(statearr_67519_67569[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (5))){
var _ = (function (){var statearr_67520 = state_67479;
(statearr_67520[(4)] = cljs.core.rest((state_67479[(4)])));

return statearr_67520;
})();
var state_67479__$1 = state_67479;
var ex67515 = (state_67479__$1[(2)]);
var statearr_67521_67570 = state_67479__$1;
(statearr_67521_67570[(5)] = ex67515);


var statearr_67522_67571 = state_67479__$1;
(statearr_67522_67571[(1)] = (4));

(statearr_67522_67571[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (14))){
var inst_67418 = (state_67479[(2)]);
var state_67479__$1 = state_67479;
var statearr_67523_67572 = state_67479__$1;
(statearr_67523_67572[(2)] = inst_67418);

(statearr_67523_67572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (26))){
var inst_67430 = (state_67479[(9)]);
var inst_67449 = (state_67479[(2)]);
var state_67479__$1 = (function (){var statearr_67524 = state_67479;
(statearr_67524[(10)] = inst_67449);

return statearr_67524;
})();
if(cljs.core.truth_(inst_67430)){
var statearr_67525_67573 = state_67479__$1;
(statearr_67525_67573[(1)] = (27));

} else {
var statearr_67526_67574 = state_67479__$1;
(statearr_67526_67574[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (16))){
var inst_67404 = (state_67479[(13)]);
var state_67479__$1 = state_67479;
var statearr_67527_67575 = state_67479__$1;
(statearr_67527_67575[(2)] = inst_67404);

(statearr_67527_67575[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (30))){
var inst_67454 = (state_67479[(15)]);
var inst_67449 = (state_67479[(10)]);
var inst_67456 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_67457 = [inst_67449,inst_67454];
var inst_67458 = cljs.core.PersistentHashMap.fromArrays(inst_67456,inst_67457);
var inst_67459 = fluree.db.operations.command_async(conn,inst_67458);
var state_67479__$1 = state_67479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67479__$1,(33),inst_67459);
} else {
if((state_val_67480 === (10))){
var state_67479__$1 = state_67479;
var statearr_67528_67576 = state_67479__$1;
(statearr_67528_67576[(2)] = false);

(statearr_67528_67576[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (18))){
var inst_67427 = (state_67479[(16)]);
var state_67479__$1 = state_67479;
var statearr_67529_67577 = state_67479__$1;
(statearr_67529_67577[(2)] = inst_67427);

(statearr_67529_67577[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67480 === (8))){
var inst_67404 = (state_67479[(13)]);
var inst_67404__$1 = (state_67479[(2)]);
var inst_67405 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67404__$1);
var inst_67407 = (inst_67404__$1 == null);
var inst_67408 = cljs.core.not(inst_67407);
var state_67479__$1 = (function (){var statearr_67530 = state_67479;
(statearr_67530[(18)] = inst_67405);

(statearr_67530[(13)] = inst_67404__$1);

return statearr_67530;
})();
if(inst_67408){
var statearr_67531_67578 = state_67479__$1;
(statearr_67531_67578[(1)] = (9));

} else {
var statearr_67532_67579 = state_67479__$1;
(statearr_67532_67579[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_67533 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67533[(0)] = flureedb$state_machine__2879__auto__);

(statearr_67533[(1)] = (1));

return statearr_67533;
});
var flureedb$state_machine__2879__auto____1 = (function (state_67479){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67479);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67534){var ex__2882__auto__ = e67534;
var statearr_67535_67580 = state_67479;
(statearr_67535_67580[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67479[(4)]))){
var statearr_67536_67581 = state_67479;
(statearr_67536_67581[(1)] = cljs.core.first((state_67479[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67582 = state_67479;
state_67479 = G__67582;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_67479){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_67479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67537 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67537[(6)] = c__2901__auto__);

return statearr_67537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67601){
var state_val_67602 = (state_67601[(1)]);
if((state_val_67602 === (1))){
var state_67601__$1 = state_67601;
var statearr_67603_67618 = state_67601__$1;
(statearr_67603_67618[(2)] = null);

(statearr_67603_67618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67602 === (2))){
var _ = (function (){var statearr_67604 = state_67601;
(statearr_67604[(4)] = cljs.core.cons((5),(state_67601[(4)])));

return statearr_67604;
})();
var inst_67591 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_67601__$1 = state_67601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67601__$1,(6),inst_67591);
} else {
if((state_val_67602 === (3))){
var inst_67599 = (state_67601[(2)]);
var state_67601__$1 = state_67601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67601__$1,inst_67599);
} else {
if((state_val_67602 === (4))){
var inst_67583 = (state_67601[(2)]);
var inst_67584 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67583], 0));
var inst_67585 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67583) : reject.call(null,inst_67583));
var state_67601__$1 = (function (){var statearr_67606 = state_67601;
(statearr_67606[(7)] = inst_67584);

return statearr_67606;
})();
var statearr_67607_67619 = state_67601__$1;
(statearr_67607_67619[(2)] = inst_67585);

(statearr_67607_67619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67602 === (5))){
var _ = (function (){var statearr_67608 = state_67601;
(statearr_67608[(4)] = cljs.core.rest((state_67601[(4)])));

return statearr_67608;
})();
var state_67601__$1 = state_67601;
var ex67605 = (state_67601__$1[(2)]);
var statearr_67609_67620 = state_67601__$1;
(statearr_67609_67620[(5)] = ex67605);


var statearr_67610_67621 = state_67601__$1;
(statearr_67610_67621[(1)] = (4));

(statearr_67610_67621[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67602 === (6))){
var inst_67593 = (state_67601[(2)]);
var inst_67594 = fluree.db.util.async.throw_err(inst_67593);
var inst_67595 = cljs.core.clj__GT_js(inst_67594);
var inst_67596 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67595) : resolve.call(null,inst_67595));
var _ = (function (){var statearr_67611 = state_67601;
(statearr_67611[(4)] = cljs.core.rest((state_67601[(4)])));

return statearr_67611;
})();
var state_67601__$1 = state_67601;
var statearr_67612_67622 = state_67601__$1;
(statearr_67612_67622[(2)] = inst_67596);

(statearr_67612_67622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2879__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2879__auto____0 = (function (){
var statearr_67613 = [null,null,null,null,null,null,null,null];
(statearr_67613[(0)] = flureedb$ledger_stats_$_state_machine__2879__auto__);

(statearr_67613[(1)] = (1));

return statearr_67613;
});
var flureedb$ledger_stats_$_state_machine__2879__auto____1 = (function (state_67601){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67601);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67614){var ex__2882__auto__ = e67614;
var statearr_67615_67623 = state_67601;
(statearr_67615_67623[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67601[(4)]))){
var statearr_67616_67624 = state_67601;
(statearr_67616_67624[(1)] = cljs.core.first((state_67601[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67625 = state_67601;
state_67601 = G__67625;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2879__auto__ = function(state_67601){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2879__auto____1.call(this,state_67601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2879__auto____0;
flureedb$ledger_stats_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2879__auto____1;
return flureedb$ledger_stats_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67617 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67617[(6)] = c__2901__auto__);

return statearr_67617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__67627 = arguments.length;
switch (G__67627) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67771){
var state_val_67772 = (state_67771[(1)]);
if((state_val_67772 === (7))){
var inst_67650 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67771__$1 = state_67771;
var statearr_67773_67856 = state_67771__$1;
(statearr_67773_67856[(2)] = inst_67650);

(statearr_67773_67856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (20))){
var inst_67697 = (state_67771[(7)]);
var inst_67690 = (state_67771[(8)]);
var inst_67687 = (state_67771[(9)]);
var inst_67697__$1 = (state_67771[(2)]);
var inst_67698 = fluree.db.graphdb.validate_ledger_name(inst_67697__$1,"ledger");
var inst_67699 = fluree.db.graphdb.validate_ledger_name(inst_67690,"network");
var state_67771__$1 = (function (){var statearr_67774 = state_67771;
(statearr_67774[(7)] = inst_67697__$1);

(statearr_67774[(10)] = inst_67698);

(statearr_67774[(11)] = inst_67699);

return statearr_67774;
})();
if(cljs.core.truth_(inst_67687)){
var statearr_67775_67857 = state_67771__$1;
(statearr_67775_67857[(1)] = (21));

} else {
var statearr_67776_67858 = state_67771__$1;
(statearr_67776_67858[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (27))){
var inst_67706 = (state_67771[(12)]);
var inst_67705 = (state_67771[(13)]);
var inst_67713 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67705),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67706)].join('');
var state_67771__$1 = state_67771;
var statearr_67777_67859 = state_67771__$1;
(statearr_67777_67859[(2)] = inst_67713);

(statearr_67777_67859[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (1))){
var state_67771__$1 = state_67771;
var statearr_67778_67860 = state_67771__$1;
(statearr_67778_67860[(2)] = null);

(statearr_67778_67860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (24))){
var inst_67706 = (state_67771[(12)]);
var inst_67708 = fluree.db.graphdb.validate_ledger_name(inst_67706,"alias");
var state_67771__$1 = state_67771;
var statearr_67779_67861 = state_67771__$1;
(statearr_67779_67861[(2)] = inst_67708);

(statearr_67779_67861[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (39))){
var inst_67735 = (state_67771[(14)]);
var inst_67737 = fluree.db.util.core.without_nils(inst_67735);
var inst_67738 = fluree.db.util.json.stringify(inst_67737);
var state_67771__$1 = state_67771;
var statearr_67780_67862 = state_67771__$1;
(statearr_67780_67862[(2)] = inst_67738);

(statearr_67780_67862[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (46))){
var inst_67735 = (state_67771[(14)]);
var inst_67756 = fluree.db.operations.unsigned_command_async(conn,inst_67735);
var state_67771__$1 = state_67771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67771__$1,(49),inst_67756);
} else {
if((state_val_67772 === (4))){
var inst_67628 = (state_67771[(2)]);
var inst_67629 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67628], 0));
var inst_67630 = cljs.core.ex_data(inst_67628);
var inst_67631 = cljs.core.ex_message(inst_67628);
var inst_67632 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_67630,new cljs.core.Keyword(null,"message","message",-406056002),inst_67631);
var inst_67633 = cljs.core.clj__GT_js(inst_67632);
var inst_67634 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67633) : reject.call(null,inst_67633));
var state_67771__$1 = (function (){var statearr_67781 = state_67771;
(statearr_67781[(15)] = inst_67629);

return statearr_67781;
})();
var statearr_67782_67863 = state_67771__$1;
(statearr_67782_67863[(2)] = inst_67634);

(statearr_67782_67863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (15))){
var inst_67652 = (state_67771[(16)]);
var inst_67671 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67652);
var state_67771__$1 = state_67771;
var statearr_67783_67864 = state_67771__$1;
(statearr_67783_67864[(2)] = inst_67671);

(statearr_67783_67864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (48))){
var inst_67753 = (state_67771[(2)]);
var inst_67754 = fluree.db.util.async.throw_err(inst_67753);
var state_67771__$1 = state_67771;
var statearr_67784_67865 = state_67771__$1;
(statearr_67784_67865[(2)] = inst_67754);

(statearr_67784_67865[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (21))){
var inst_67701 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_67771__$1 = state_67771;
var statearr_67785_67866 = state_67771__$1;
(statearr_67785_67866[(2)] = inst_67701);

(statearr_67785_67866[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (31))){
var inst_67717 = (state_67771[(17)]);
var state_67771__$1 = state_67771;
var statearr_67786_67867 = state_67771__$1;
(statearr_67786_67867[(2)] = inst_67717);

(statearr_67786_67867[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (32))){
var inst_67683 = (state_67771[(18)]);
var inst_67721 = (state_67771[(2)]);
var state_67771__$1 = (function (){var statearr_67787 = state_67771;
(statearr_67787[(19)] = inst_67721);

return statearr_67787;
})();
if(cljs.core.truth_(inst_67683)){
var statearr_67788_67868 = state_67771__$1;
(statearr_67788_67868[(1)] = (33));

} else {
var statearr_67789_67869 = state_67771__$1;
(statearr_67789_67869[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (40))){
var state_67771__$1 = state_67771;
var statearr_67790_67870 = state_67771__$1;
(statearr_67790_67870[(2)] = null);

(statearr_67790_67870[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (33))){
var inst_67683 = (state_67771[(18)]);
var state_67771__$1 = state_67771;
var statearr_67791_67871 = state_67771__$1;
(statearr_67791_67871[(2)] = inst_67683);

(statearr_67791_67871[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (13))){
var state_67771__$1 = state_67771;
var statearr_67792_67872 = state_67771__$1;
(statearr_67792_67872[(2)] = false);

(statearr_67792_67872[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (22))){
var state_67771__$1 = state_67771;
var statearr_67793_67873 = state_67771__$1;
(statearr_67793_67873[(2)] = null);

(statearr_67793_67873[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (36))){
var inst_67685 = (state_67771[(20)]);
var inst_67730 = (state_67771[(21)]);
var inst_67732 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_67730,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_67685);
var state_67771__$1 = state_67771;
var statearr_67794_67874 = state_67771__$1;
(statearr_67794_67874[(2)] = inst_67732);

(statearr_67794_67874[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (41))){
var inst_67679 = (state_67771[(22)]);
var inst_67741 = (state_67771[(2)]);
var state_67771__$1 = (function (){var statearr_67795 = state_67771;
(statearr_67795[(23)] = inst_67741);

return statearr_67795;
})();
if(cljs.core.truth_(inst_67679)){
var statearr_67796_67875 = state_67771__$1;
(statearr_67796_67875[(1)] = (42));

} else {
var statearr_67797_67876 = state_67771__$1;
(statearr_67797_67876[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (43))){
var state_67771__$1 = state_67771;
var statearr_67798_67877 = state_67771__$1;
(statearr_67798_67877[(2)] = null);

(statearr_67798_67877[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (29))){
var inst_67677 = (state_67771[(24)]);
var inst_67716 = (state_67771[(2)]);
var inst_67717 = fluree.db.util.core.current_time_millis();
var state_67771__$1 = (function (){var statearr_67799 = state_67771;
(statearr_67799[(17)] = inst_67717);

(statearr_67799[(25)] = inst_67716);

return statearr_67799;
})();
if(cljs.core.truth_(inst_67677)){
var statearr_67800_67878 = state_67771__$1;
(statearr_67800_67878[(1)] = (30));

} else {
var statearr_67801_67879 = state_67771__$1;
(statearr_67801_67879[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (44))){
var inst_67679 = (state_67771[(22)]);
var inst_67746 = (state_67771[(2)]);
var state_67771__$1 = (function (){var statearr_67802 = state_67771;
(statearr_67802[(26)] = inst_67746);

return statearr_67802;
})();
if(cljs.core.truth_(inst_67679)){
var statearr_67803_67880 = state_67771__$1;
(statearr_67803_67880[(1)] = (45));

} else {
var statearr_67804_67881 = state_67771__$1;
(statearr_67804_67881[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (6))){
var state_67771__$1 = state_67771;
var statearr_67805_67882 = state_67771__$1;
(statearr_67805_67882[(2)] = null);

(statearr_67805_67882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (28))){
var state_67771__$1 = state_67771;
var statearr_67806_67883 = state_67771__$1;
(statearr_67806_67883[(2)] = null);

(statearr_67806_67883[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (25))){
var state_67771__$1 = state_67771;
var statearr_67807_67884 = state_67771__$1;
(statearr_67807_67884[(2)] = null);

(statearr_67807_67884[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (34))){
var inst_67717 = (state_67771[(17)]);
var inst_67724 = (inst_67717 + (30000));
var state_67771__$1 = state_67771;
var statearr_67808_67885 = state_67771__$1;
(statearr_67808_67885[(2)] = inst_67724);

(statearr_67808_67885[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (17))){
var inst_67691 = (state_67771[(27)]);
var inst_67674 = (state_67771[(2)]);
var inst_67675 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67674,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_67676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_67677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_67678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_67679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_67680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_67681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_67682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_67683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_67684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_67686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_67687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_67688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67674,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_67689 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_67690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67689,(0),null);
var inst_67691__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67689,(1),null);
var inst_67692 = clojure.string.starts_with_QMARK_(inst_67691__$1,"$");
var state_67771__$1 = (function (){var statearr_67809 = state_67771;
(statearr_67809[(28)] = inst_67675);

(statearr_67809[(29)] = inst_67681);

(statearr_67809[(8)] = inst_67690);

(statearr_67809[(20)] = inst_67685);

(statearr_67809[(9)] = inst_67687);

(statearr_67809[(22)] = inst_67679);

(statearr_67809[(30)] = inst_67682);

(statearr_67809[(31)] = inst_67680);

(statearr_67809[(32)] = inst_67676);

(statearr_67809[(27)] = inst_67691__$1);

(statearr_67809[(33)] = inst_67686);

(statearr_67809[(24)] = inst_67677);

(statearr_67809[(18)] = inst_67683);

(statearr_67809[(34)] = inst_67688);

(statearr_67809[(35)] = inst_67684);

(statearr_67809[(36)] = inst_67678);

return statearr_67809;
})();
if(inst_67692){
var statearr_67810_67886 = state_67771__$1;
(statearr_67810_67886[(1)] = (18));

} else {
var statearr_67811_67887 = state_67771__$1;
(statearr_67811_67887[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (3))){
var inst_67769 = (state_67771[(2)]);
var state_67771__$1 = state_67771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67771__$1,inst_67769);
} else {
if((state_val_67772 === (12))){
var state_67771__$1 = state_67771;
var statearr_67812_67888 = state_67771__$1;
(statearr_67812_67888[(2)] = true);

(statearr_67812_67888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (2))){
var _ = (function (){var statearr_67813 = state_67771;
(statearr_67813[(4)] = cljs.core.cons((5),(state_67771[(4)])));

return statearr_67813;
})();
var inst_67647 = (opts == null);
var state_67771__$1 = state_67771;
if(cljs.core.truth_(inst_67647)){
var statearr_67814_67889 = state_67771__$1;
(statearr_67814_67889[(1)] = (6));

} else {
var statearr_67815_67890 = state_67771__$1;
(statearr_67815_67890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (23))){
var inst_67687 = (state_67771[(9)]);
var inst_67704 = (state_67771[(2)]);
var inst_67705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67704,(0),null);
var inst_67706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67704,(1),null);
var state_67771__$1 = (function (){var statearr_67816 = state_67771;
(statearr_67816[(12)] = inst_67706);

(statearr_67816[(13)] = inst_67705);

return statearr_67816;
})();
if(cljs.core.truth_(inst_67687)){
var statearr_67817_67891 = state_67771__$1;
(statearr_67817_67891[(1)] = (24));

} else {
var statearr_67818_67892 = state_67771__$1;
(statearr_67818_67892[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (47))){
var inst_67761 = (state_67771[(2)]);
var inst_67762 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67763 = [(200),inst_67761];
var inst_67764 = cljs.core.PersistentHashMap.fromArrays(inst_67762,inst_67763);
var inst_67765 = cljs.core.clj__GT_js(inst_67764);
var inst_67766 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67765) : resolve.call(null,inst_67765));
var _ = (function (){var statearr_67819 = state_67771;
(statearr_67819[(4)] = cljs.core.rest((state_67771[(4)])));

return statearr_67819;
})();
var state_67771__$1 = state_67771;
var statearr_67820_67893 = state_67771__$1;
(statearr_67820_67893[(2)] = inst_67766);

(statearr_67820_67893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (35))){
var inst_67697 = (state_67771[(7)]);
var inst_67681 = (state_67771[(29)]);
var inst_67690 = (state_67771[(8)]);
var inst_67685 = (state_67771[(20)]);
var inst_67721 = (state_67771[(19)]);
var inst_67682 = (state_67771[(30)]);
var inst_67680 = (state_67771[(31)]);
var inst_67676 = (state_67771[(32)]);
var inst_67686 = (state_67771[(33)]);
var inst_67716 = (state_67771[(25)]);
var inst_67688 = (state_67771[(34)]);
var inst_67684 = (state_67771[(35)]);
var inst_67678 = (state_67771[(36)]);
var inst_67726 = (state_67771[(2)]);
var inst_67727 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_67728 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67690),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67697)].join('');
var inst_67729 = [inst_67681,inst_67682,inst_67728,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_67726,inst_67684,inst_67716,inst_67688,inst_67686,inst_67676,inst_67721,inst_67678,inst_67680];
var inst_67730 = cljs.core.PersistentHashMap.fromArrays(inst_67727,inst_67729);
var state_67771__$1 = (function (){var statearr_67821 = state_67771;
(statearr_67821[(21)] = inst_67730);

return statearr_67821;
})();
if(cljs.core.truth_(inst_67685)){
var statearr_67822_67894 = state_67771__$1;
(statearr_67822_67894[(1)] = (36));

} else {
var statearr_67823_67895 = state_67771__$1;
(statearr_67823_67895[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (19))){
var inst_67691 = (state_67771[(27)]);
var state_67771__$1 = state_67771;
var statearr_67824_67896 = state_67771__$1;
(statearr_67824_67896[(2)] = inst_67691);

(statearr_67824_67896[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (11))){
var inst_67669 = (state_67771[(2)]);
var state_67771__$1 = state_67771;
if(cljs.core.truth_(inst_67669)){
var statearr_67826_67897 = state_67771__$1;
(statearr_67826_67897[(1)] = (15));

} else {
var statearr_67827_67898 = state_67771__$1;
(statearr_67827_67898[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (9))){
var inst_67652 = (state_67771[(16)]);
var inst_67658 = inst_67652.cljs$lang$protocol_mask$partition0$;
var inst_67659 = (inst_67658 & (64));
var inst_67660 = inst_67652.cljs$core$ISeq$;
var inst_67661 = (cljs.core.PROTOCOL_SENTINEL === inst_67660);
var inst_67662 = ((inst_67659) || (inst_67661));
var state_67771__$1 = state_67771;
if(cljs.core.truth_(inst_67662)){
var statearr_67828_67899 = state_67771__$1;
(statearr_67828_67899[(1)] = (12));

} else {
var statearr_67829_67900 = state_67771__$1;
(statearr_67829_67900[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (5))){
var _ = (function (){var statearr_67830 = state_67771;
(statearr_67830[(4)] = cljs.core.rest((state_67771[(4)])));

return statearr_67830;
})();
var state_67771__$1 = state_67771;
var ex67825 = (state_67771__$1[(2)]);
var statearr_67831_67901 = state_67771__$1;
(statearr_67831_67901[(5)] = ex67825);


var statearr_67832_67902 = state_67771__$1;
(statearr_67832_67902[(1)] = (4));

(statearr_67832_67902[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (14))){
var inst_67666 = (state_67771[(2)]);
var state_67771__$1 = state_67771;
var statearr_67833_67903 = state_67771__$1;
(statearr_67833_67903[(2)] = inst_67666);

(statearr_67833_67903[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (45))){
var inst_67741 = (state_67771[(23)]);
var inst_67746 = (state_67771[(26)]);
var inst_67748 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_67749 = [inst_67741,inst_67746];
var inst_67750 = cljs.core.PersistentHashMap.fromArrays(inst_67748,inst_67749);
var inst_67751 = fluree.db.operations.command_async(conn,inst_67750);
var state_67771__$1 = state_67771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67771__$1,(48),inst_67751);
} else {
if((state_val_67772 === (26))){
var inst_67687 = (state_67771[(9)]);
var inst_67711 = (state_67771[(2)]);
var state_67771__$1 = (function (){var statearr_67834 = state_67771;
(statearr_67834[(37)] = inst_67711);

return statearr_67834;
})();
if(cljs.core.truth_(inst_67687)){
var statearr_67835_67904 = state_67771__$1;
(statearr_67835_67904[(1)] = (27));

} else {
var statearr_67836_67905 = state_67771__$1;
(statearr_67836_67905[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (16))){
var inst_67652 = (state_67771[(16)]);
var state_67771__$1 = state_67771;
var statearr_67837_67906 = state_67771__$1;
(statearr_67837_67906[(2)] = inst_67652);

(statearr_67837_67906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (38))){
var inst_67679 = (state_67771[(22)]);
var inst_67735 = (state_67771[(2)]);
var state_67771__$1 = (function (){var statearr_67838 = state_67771;
(statearr_67838[(14)] = inst_67735);

return statearr_67838;
})();
if(cljs.core.truth_(inst_67679)){
var statearr_67839_67907 = state_67771__$1;
(statearr_67839_67907[(1)] = (39));

} else {
var statearr_67840_67908 = state_67771__$1;
(statearr_67840_67908[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (30))){
var inst_67677 = (state_67771[(24)]);
var state_67771__$1 = state_67771;
var statearr_67841_67909 = state_67771__$1;
(statearr_67841_67909[(2)] = inst_67677);

(statearr_67841_67909[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (10))){
var state_67771__$1 = state_67771;
var statearr_67842_67910 = state_67771__$1;
(statearr_67842_67910[(2)] = false);

(statearr_67842_67910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (18))){
var inst_67691 = (state_67771[(27)]);
var inst_67694 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_67691,(1));
var state_67771__$1 = state_67771;
var statearr_67843_67911 = state_67771__$1;
(statearr_67843_67911[(2)] = inst_67694);

(statearr_67843_67911[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (42))){
var inst_67679 = (state_67771[(22)]);
var inst_67741 = (state_67771[(23)]);
var inst_67743 = fluree.crypto.sign_message(inst_67741,inst_67679);
var state_67771__$1 = state_67771;
var statearr_67844_67912 = state_67771__$1;
(statearr_67844_67912[(2)] = inst_67743);

(statearr_67844_67912[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (37))){
var inst_67730 = (state_67771[(21)]);
var state_67771__$1 = state_67771;
var statearr_67845_67913 = state_67771__$1;
(statearr_67845_67913[(2)] = inst_67730);

(statearr_67845_67913[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (8))){
var inst_67652 = (state_67771[(16)]);
var inst_67652__$1 = (state_67771[(2)]);
var inst_67653 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67652__$1);
var inst_67655 = (inst_67652__$1 == null);
var inst_67656 = cljs.core.not(inst_67655);
var state_67771__$1 = (function (){var statearr_67846 = state_67771;
(statearr_67846[(16)] = inst_67652__$1);

(statearr_67846[(38)] = inst_67653);

return statearr_67846;
})();
if(inst_67656){
var statearr_67847_67914 = state_67771__$1;
(statearr_67847_67914[(1)] = (9));

} else {
var statearr_67848_67915 = state_67771__$1;
(statearr_67848_67915[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67772 === (49))){
var inst_67758 = (state_67771[(2)]);
var inst_67759 = fluree.db.util.async.throw_err(inst_67758);
var state_67771__$1 = state_67771;
var statearr_67849_67916 = state_67771__$1;
(statearr_67849_67916[(2)] = inst_67759);

(statearr_67849_67916[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_67850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67850[(0)] = flureedb$state_machine__2879__auto__);

(statearr_67850[(1)] = (1));

return statearr_67850;
});
var flureedb$state_machine__2879__auto____1 = (function (state_67771){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67771);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67851){var ex__2882__auto__ = e67851;
var statearr_67852_67917 = state_67771;
(statearr_67852_67917[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67771[(4)]))){
var statearr_67853_67918 = state_67771;
(statearr_67853_67918[(1)] = cljs.core.first((state_67771[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67919 = state_67771;
state_67771 = G__67919;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_67771){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_67771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67854 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67854[(6)] = c__2901__auto__);

return statearr_67854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67939){
var state_val_67940 = (state_67939[(1)]);
if((state_val_67940 === (1))){
var state_67939__$1 = state_67939;
var statearr_67941_67957 = state_67939__$1;
(statearr_67941_67957[(2)] = null);

(statearr_67941_67957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67940 === (2))){
var _ = (function (){var statearr_67942 = state_67939;
(statearr_67942[(4)] = cljs.core.cons((5),(state_67939[(4)])));

return statearr_67942;
})();
var inst_67929 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_67930 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_67939__$1 = (function (){var statearr_67943 = state_67939;
(statearr_67943[(7)] = inst_67929);

return statearr_67943;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67939__$1,(6),inst_67930);
} else {
if((state_val_67940 === (3))){
var inst_67937 = (state_67939[(2)]);
var state_67939__$1 = state_67939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67939__$1,inst_67937);
} else {
if((state_val_67940 === (4))){
var inst_67920 = (state_67939[(2)]);
var inst_67921 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67920], 0));
var inst_67922 = cljs.core.clj__GT_js(inst_67920);
var inst_67923 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67922) : reject.call(null,inst_67922));
var state_67939__$1 = (function (){var statearr_67945 = state_67939;
(statearr_67945[(8)] = inst_67921);

return statearr_67945;
})();
var statearr_67946_67958 = state_67939__$1;
(statearr_67946_67958[(2)] = inst_67923);

(statearr_67946_67958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67940 === (5))){
var _ = (function (){var statearr_67947 = state_67939;
(statearr_67947[(4)] = cljs.core.rest((state_67939[(4)])));

return statearr_67947;
})();
var state_67939__$1 = state_67939;
var ex67944 = (state_67939__$1[(2)]);
var statearr_67948_67959 = state_67939__$1;
(statearr_67948_67959[(5)] = ex67944);


var statearr_67949_67960 = state_67939__$1;
(statearr_67949_67960[(1)] = (4));

(statearr_67949_67960[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67940 === (6))){
var inst_67932 = (state_67939[(2)]);
var inst_67933 = cljs.core.clj__GT_js(inst_67932);
var inst_67934 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67933) : resolve.call(null,inst_67933));
var _ = (function (){var statearr_67950 = state_67939;
(statearr_67950[(4)] = cljs.core.rest((state_67939[(4)])));

return statearr_67950;
})();
var state_67939__$1 = state_67939;
var statearr_67951_67961 = state_67939__$1;
(statearr_67951_67961[(2)] = inst_67934);

(statearr_67951_67961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2879__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2879__auto____0 = (function (){
var statearr_67952 = [null,null,null,null,null,null,null,null,null];
(statearr_67952[(0)] = flureedb$monitor_tx_$_state_machine__2879__auto__);

(statearr_67952[(1)] = (1));

return statearr_67952;
});
var flureedb$monitor_tx_$_state_machine__2879__auto____1 = (function (state_67939){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67939);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67953){var ex__2882__auto__ = e67953;
var statearr_67954_67962 = state_67939;
(statearr_67954_67962[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67939[(4)]))){
var statearr_67955_67963 = state_67939;
(statearr_67955_67963[(1)] = cljs.core.first((state_67939[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67964 = state_67939;
state_67939 = G__67964;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2879__auto__ = function(state_67939){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2879__auto____1.call(this,state_67939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2879__auto____0;
flureedb$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2879__auto____1;
return flureedb$monitor_tx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67956 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67956[(6)] = c__2901__auto__);

return statearr_67956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__67966 = arguments.length;
switch (G__67966) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67992){
var state_val_67993 = (state_67992[(1)]);
if((state_val_67993 === (7))){
var inst_67978 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67992__$1 = state_67992;
var statearr_67994_68015 = state_67992__$1;
(statearr_67994_68015[(2)] = inst_67978);

(statearr_67994_68015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (1))){
var state_67992__$1 = state_67992;
var statearr_67995_68016 = state_67992__$1;
(statearr_67995_68016[(2)] = null);

(statearr_67995_68016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (4))){
var inst_67967 = (state_67992[(2)]);
var inst_67968 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67967], 0));
var inst_67969 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67967) : reject.call(null,inst_67967));
var state_67992__$1 = (function (){var statearr_67996 = state_67992;
(statearr_67996[(7)] = inst_67968);

return statearr_67996;
})();
var statearr_67997_68017 = state_67992__$1;
(statearr_67997_68017[(2)] = inst_67969);

(statearr_67997_68017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (6))){
var state_67992__$1 = state_67992;
var statearr_67998_68018 = state_67992__$1;
(statearr_67998_68018[(2)] = null);

(statearr_67998_68018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (3))){
var inst_67990 = (state_67992[(2)]);
var state_67992__$1 = state_67992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67992__$1,inst_67990);
} else {
if((state_val_67993 === (2))){
var _ = (function (){var statearr_68000 = state_67992;
(statearr_68000[(4)] = cljs.core.cons((5),(state_67992[(4)])));

return statearr_68000;
})();
var inst_67975 = (opts == null);
var state_67992__$1 = state_67992;
if(cljs.core.truth_(inst_67975)){
var statearr_68001_68019 = state_67992__$1;
(statearr_68001_68019[(1)] = (6));

} else {
var statearr_68002_68020 = state_67992__$1;
(statearr_68002_68020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (9))){
var inst_67985 = (state_67992[(2)]);
var inst_67986 = cljs.core.clj__GT_js(inst_67985);
var inst_67987 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67986) : resolve.call(null,inst_67986));
var _ = (function (){var statearr_68003 = state_67992;
(statearr_68003[(4)] = cljs.core.rest((state_67992[(4)])));

return statearr_68003;
})();
var state_67992__$1 = state_67992;
var statearr_68004_68021 = state_67992__$1;
(statearr_68004_68021[(2)] = inst_67987);

(statearr_68004_68021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (5))){
var _ = (function (){var statearr_68005 = state_67992;
(statearr_68005[(4)] = cljs.core.rest((state_67992[(4)])));

return statearr_68005;
})();
var state_67992__$1 = state_67992;
var ex67999 = (state_67992__$1[(2)]);
var statearr_68006_68022 = state_67992__$1;
(statearr_68006_68022[(5)] = ex67999);


var statearr_68007_68023 = state_67992__$1;
(statearr_68007_68023[(1)] = (4));

(statearr_68007_68023[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67993 === (8))){
var inst_67980 = (state_67992[(2)]);
var inst_67981 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67980);
var inst_67982 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67983 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67982,inst_67980);
var state_67992__$1 = (function (){var statearr_68008 = state_67992;
(statearr_68008[(8)] = inst_67981);

return statearr_68008;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67992__$1,(9),inst_67983);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_68009 = [null,null,null,null,null,null,null,null,null];
(statearr_68009[(0)] = flureedb$state_machine__2879__auto__);

(statearr_68009[(1)] = (1));

return statearr_68009;
});
var flureedb$state_machine__2879__auto____1 = (function (state_67992){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67992);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68010){var ex__2882__auto__ = e68010;
var statearr_68011_68024 = state_67992;
(statearr_68011_68024[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67992[(4)]))){
var statearr_68012_68025 = state_67992;
(statearr_68012_68025[(1)] = cljs.core.first((state_67992[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68026 = state_67992;
state_67992 = G__68026;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_67992){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_67992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68013 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68013[(6)] = c__2901__auto__);

return statearr_68013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__68028 = arguments.length;
switch (G__68028) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68057){
var state_val_68058 = (state_68057[(1)]);
if((state_val_68058 === (7))){
var inst_68040 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_68057__$1 = state_68057;
var statearr_68059_68080 = state_68057__$1;
(statearr_68059_68080[(2)] = inst_68040);

(statearr_68059_68080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (1))){
var state_68057__$1 = state_68057;
var statearr_68060_68081 = state_68057__$1;
(statearr_68060_68081[(2)] = null);

(statearr_68060_68081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (4))){
var inst_68029 = (state_68057[(2)]);
var inst_68030 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68029], 0));
var inst_68031 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68029) : reject.call(null,inst_68029));
var state_68057__$1 = (function (){var statearr_68061 = state_68057;
(statearr_68061[(7)] = inst_68030);

return statearr_68061;
})();
var statearr_68062_68082 = state_68057__$1;
(statearr_68062_68082[(2)] = inst_68031);

(statearr_68062_68082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (6))){
var state_68057__$1 = state_68057;
var statearr_68063_68083 = state_68057__$1;
(statearr_68063_68083[(2)] = null);

(statearr_68063_68083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (3))){
var inst_68055 = (state_68057[(2)]);
var state_68057__$1 = state_68057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68057__$1,inst_68055);
} else {
if((state_val_68058 === (2))){
var _ = (function (){var statearr_68065 = state_68057;
(statearr_68065[(4)] = cljs.core.cons((5),(state_68057[(4)])));

return statearr_68065;
})();
var inst_68037 = (opts == null);
var state_68057__$1 = state_68057;
if(cljs.core.truth_(inst_68037)){
var statearr_68066_68084 = state_68057__$1;
(statearr_68066_68084[(1)] = (6));

} else {
var statearr_68067_68085 = state_68057__$1;
(statearr_68067_68085[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (9))){
var inst_68042 = (state_68057[(8)]);
var inst_68045 = (state_68057[(2)]);
var inst_68046 = fluree.db.util.async.throw_err(inst_68045);
var inst_68047 = fluree.db.query.block.block_range(inst_68046,start,end,inst_68042);
var state_68057__$1 = state_68057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68057__$1,(10),inst_68047);
} else {
if((state_val_68058 === (5))){
var _ = (function (){var statearr_68068 = state_68057;
(statearr_68068[(4)] = cljs.core.rest((state_68057[(4)])));

return statearr_68068;
})();
var state_68057__$1 = state_68057;
var ex68064 = (state_68057__$1[(2)]);
var statearr_68069_68086 = state_68057__$1;
(statearr_68069_68086[(5)] = ex68064);


var statearr_68070_68087 = state_68057__$1;
(statearr_68070_68087[(1)] = (4));

(statearr_68070_68087[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (10))){
var inst_68049 = (state_68057[(2)]);
var inst_68050 = fluree.db.util.async.throw_err(inst_68049);
var inst_68051 = cljs.core.clj__GT_js(inst_68050);
var inst_68052 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68051) : resolve.call(null,inst_68051));
var _ = (function (){var statearr_68071 = state_68057;
(statearr_68071[(4)] = cljs.core.rest((state_68057[(4)])));

return statearr_68071;
})();
var state_68057__$1 = state_68057;
var statearr_68072_68088 = state_68057__$1;
(statearr_68072_68088[(2)] = inst_68052);

(statearr_68072_68088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68058 === (8))){
var inst_68042 = (state_68057[(8)]);
var inst_68042__$1 = (state_68057[(2)]);
var inst_68043 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68042__$1], 0));
var state_68057__$1 = (function (){var statearr_68073 = state_68057;
(statearr_68073[(8)] = inst_68042__$1);

return statearr_68073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68057__$1,(9),inst_68043);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_68074 = [null,null,null,null,null,null,null,null,null];
(statearr_68074[(0)] = flureedb$state_machine__2879__auto__);

(statearr_68074[(1)] = (1));

return statearr_68074;
});
var flureedb$state_machine__2879__auto____1 = (function (state_68057){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68057);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68075){var ex__2882__auto__ = e68075;
var statearr_68076_68089 = state_68057;
(statearr_68076_68089[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68057[(4)]))){
var statearr_68077_68090 = state_68057;
(statearr_68077_68090[(1)] = cljs.core.first((state_68057[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68091 = state_68057;
state_68057 = G__68091;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_68057){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_68057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68078 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68078[(6)] = c__2901__auto__);

return statearr_68078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__68093 = arguments.length;
switch (G__68093) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68148){
var state_val_68149 = (state_68148[(1)]);
if((state_val_68149 === (7))){
var inst_68106 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_68148__$1 = state_68148;
var statearr_68150_68184 = state_68148__$1;
(statearr_68150_68184[(2)] = inst_68106);

(statearr_68150_68184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (1))){
var state_68148__$1 = state_68148;
var statearr_68151_68185 = state_68148__$1;
(statearr_68151_68185[(2)] = null);

(statearr_68151_68185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (4))){
var inst_68094 = (state_68148[(2)]);
var inst_68095 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68094], 0));
var inst_68096 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68094) : reject.call(null,inst_68094));
var state_68148__$1 = (function (){var statearr_68152 = state_68148;
(statearr_68152[(7)] = inst_68095);

return statearr_68152;
})();
var statearr_68153_68186 = state_68148__$1;
(statearr_68153_68186[(2)] = inst_68096);

(statearr_68153_68186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (15))){
var inst_68109 = (state_68148[(8)]);
var inst_68127 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_68109);
var state_68148__$1 = state_68148;
var statearr_68154_68187 = state_68148__$1;
(statearr_68154_68187[(2)] = inst_68127);

(statearr_68154_68187[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (13))){
var state_68148__$1 = state_68148;
var statearr_68155_68188 = state_68148__$1;
(statearr_68155_68188[(2)] = false);

(statearr_68155_68188[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (6))){
var state_68148__$1 = state_68148;
var statearr_68156_68189 = state_68148__$1;
(statearr_68156_68189[(2)] = null);

(statearr_68156_68189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (17))){
var inst_68108 = (state_68148[(9)]);
var inst_68130 = (state_68148[(2)]);
var inst_68131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68130,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_68132 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68130,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_68133 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68108], 0));
var state_68148__$1 = (function (){var statearr_68157 = state_68148;
(statearr_68157[(10)] = inst_68131);

(statearr_68157[(11)] = inst_68132);

return statearr_68157;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68148__$1,(18),inst_68133);
} else {
if((state_val_68149 === (3))){
var inst_68146 = (state_68148[(2)]);
var state_68148__$1 = state_68148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68148__$1,inst_68146);
} else {
if((state_val_68149 === (12))){
var state_68148__$1 = state_68148;
var statearr_68158_68190 = state_68148__$1;
(statearr_68158_68190[(2)] = true);

(statearr_68158_68190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (2))){
var _ = (function (){var statearr_68159 = state_68148;
(statearr_68159[(4)] = cljs.core.cons((5),(state_68148[(4)])));

return statearr_68159;
})();
var inst_68103 = (opts == null);
var state_68148__$1 = state_68148;
if(cljs.core.truth_(inst_68103)){
var statearr_68160_68191 = state_68148__$1;
(statearr_68160_68191[(1)] = (6));

} else {
var statearr_68161_68192 = state_68148__$1;
(statearr_68161_68192[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (19))){
var inst_68139 = (state_68148[(2)]);
var inst_68140 = fluree.db.util.async.throw_err(inst_68139);
var inst_68141 = fluree.db.query.range.block_with_tx_data(inst_68140);
var inst_68142 = cljs.core.clj__GT_js(inst_68141);
var inst_68143 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68142) : resolve.call(null,inst_68142));
var _ = (function (){var statearr_68162 = state_68148;
(statearr_68162[(4)] = cljs.core.rest((state_68148[(4)])));

return statearr_68162;
})();
var state_68148__$1 = state_68148;
var statearr_68163_68193 = state_68148__$1;
(statearr_68163_68193[(2)] = inst_68143);

(statearr_68163_68193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (11))){
var inst_68125 = (state_68148[(2)]);
var state_68148__$1 = state_68148;
if(cljs.core.truth_(inst_68125)){
var statearr_68165_68194 = state_68148__$1;
(statearr_68165_68194[(1)] = (15));

} else {
var statearr_68166_68195 = state_68148__$1;
(statearr_68166_68195[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (9))){
var inst_68109 = (state_68148[(8)]);
var inst_68114 = inst_68109.cljs$lang$protocol_mask$partition0$;
var inst_68115 = (inst_68114 & (64));
var inst_68116 = inst_68109.cljs$core$ISeq$;
var inst_68117 = (cljs.core.PROTOCOL_SENTINEL === inst_68116);
var inst_68118 = ((inst_68115) || (inst_68117));
var state_68148__$1 = state_68148;
if(cljs.core.truth_(inst_68118)){
var statearr_68167_68196 = state_68148__$1;
(statearr_68167_68196[(1)] = (12));

} else {
var statearr_68168_68197 = state_68148__$1;
(statearr_68168_68197[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (5))){
var _ = (function (){var statearr_68169 = state_68148;
(statearr_68169[(4)] = cljs.core.rest((state_68148[(4)])));

return statearr_68169;
})();
var state_68148__$1 = state_68148;
var ex68164 = (state_68148__$1[(2)]);
var statearr_68170_68198 = state_68148__$1;
(statearr_68170_68198[(5)] = ex68164);


var statearr_68171_68199 = state_68148__$1;
(statearr_68171_68199[(1)] = (4));

(statearr_68171_68199[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (14))){
var inst_68122 = (state_68148[(2)]);
var state_68148__$1 = state_68148;
var statearr_68172_68200 = state_68148__$1;
(statearr_68172_68200[(2)] = inst_68122);

(statearr_68172_68200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (16))){
var inst_68109 = (state_68148[(8)]);
var state_68148__$1 = state_68148;
var statearr_68173_68201 = state_68148__$1;
(statearr_68173_68201[(2)] = inst_68109);

(statearr_68173_68201[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (10))){
var state_68148__$1 = state_68148;
var statearr_68174_68202 = state_68148__$1;
(statearr_68174_68202[(2)] = false);

(statearr_68174_68202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68149 === (18))){
var inst_68131 = (state_68148[(10)]);
var inst_68108 = (state_68148[(9)]);
var inst_68132 = (state_68148[(11)]);
var inst_68135 = (state_68148[(2)]);
var inst_68136 = fluree.db.util.async.throw_err(inst_68135);
var inst_68137 = fluree.db.query.block.block_range(inst_68136,inst_68131,inst_68132,inst_68108);
var state_68148__$1 = state_68148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68148__$1,(19),inst_68137);
} else {
if((state_val_68149 === (8))){
var inst_68109 = (state_68148[(8)]);
var inst_68108 = (state_68148[(2)]);
var inst_68109__$1 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68111 = (inst_68109__$1 == null);
var inst_68112 = cljs.core.not(inst_68111);
var state_68148__$1 = (function (){var statearr_68175 = state_68148;
(statearr_68175[(8)] = inst_68109__$1);

(statearr_68175[(9)] = inst_68108);

return statearr_68175;
})();
if(inst_68112){
var statearr_68176_68203 = state_68148__$1;
(statearr_68176_68203[(1)] = (9));

} else {
var statearr_68177_68204 = state_68148__$1;
(statearr_68177_68204[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_68178 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68178[(0)] = flureedb$state_machine__2879__auto__);

(statearr_68178[(1)] = (1));

return statearr_68178;
});
var flureedb$state_machine__2879__auto____1 = (function (state_68148){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68148);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68179){var ex__2882__auto__ = e68179;
var statearr_68180_68205 = state_68148;
(statearr_68180_68205[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68148[(4)]))){
var statearr_68181_68206 = state_68148;
(statearr_68181_68206[(1)] = cljs.core.first((state_68148[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68207 = state_68148;
state_68148 = G__68207;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_68148){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_68148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68182 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68182[(6)] = c__2901__auto__);

return statearr_68182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__68209 = arguments.length;
switch (G__68209) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68276){
var state_val_68277 = (state_68276[(1)]);
if((state_val_68277 === (7))){
var inst_68222 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_68276__$1 = state_68276;
var statearr_68278_68319 = state_68276__$1;
(statearr_68278_68319[(2)] = inst_68222);

(statearr_68278_68319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (20))){
var inst_68224 = (state_68276[(7)]);
var inst_68218 = (state_68276[(8)]);
var inst_68260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68261 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_68262 = (new cljs.core.PersistentVector(null,1,(5),inst_68260,inst_68261,null));
var inst_68263 = cljs.core.assoc_in(inst_68224,inst_68262,new cljs.core.Keyword(null,"block","block",664686210));
var inst_68264 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_68218,inst_68263);
var state_68276__$1 = state_68276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68276__$1,(23),inst_68264);
} else {
if((state_val_68277 === (1))){
var state_68276__$1 = state_68276;
var statearr_68279_68320 = state_68276__$1;
(statearr_68279_68320[(2)] = null);

(statearr_68279_68320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (4))){
var inst_68210 = (state_68276[(2)]);
var inst_68211 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68210], 0));
var inst_68212 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68210) : reject.call(null,inst_68210));
var state_68276__$1 = (function (){var statearr_68280 = state_68276;
(statearr_68280[(9)] = inst_68211);

return statearr_68280;
})();
var statearr_68281_68321 = state_68276__$1;
(statearr_68281_68321[(2)] = inst_68212);

(statearr_68281_68321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (15))){
var inst_68248 = (state_68276[(2)]);
var inst_68249 = fluree.db.util.async.throw_err(inst_68248);
var state_68276__$1 = state_68276;
var statearr_68282_68322 = state_68276__$1;
(statearr_68282_68322[(2)] = inst_68249);

(statearr_68282_68322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (21))){
var inst_68269 = (state_68276[(2)]);
var inst_68270 = cljs.core.clj__GT_js(inst_68269);
var inst_68271 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68270) : resolve.call(null,inst_68270));
var _ = (function (){var statearr_68283 = state_68276;
(statearr_68283[(4)] = cljs.core.rest((state_68276[(4)])));

return statearr_68283;
})();
var state_68276__$1 = state_68276;
var statearr_68284_68323 = state_68276__$1;
(statearr_68284_68323[(2)] = inst_68271);

(statearr_68284_68323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (13))){
var state_68276__$1 = state_68276;
var statearr_68285_68324 = state_68276__$1;
(statearr_68285_68324[(2)] = null);

(statearr_68285_68324[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (22))){
var inst_68257 = (state_68276[(2)]);
var inst_68258 = fluree.db.util.async.throw_err(inst_68257);
var state_68276__$1 = state_68276;
var statearr_68286_68325 = state_68276__$1;
(statearr_68286_68325[(2)] = inst_68258);

(statearr_68286_68325[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (6))){
var state_68276__$1 = state_68276;
var statearr_68287_68326 = state_68276__$1;
(statearr_68287_68326[(2)] = null);

(statearr_68287_68326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (17))){
var state_68276__$1 = state_68276;
var statearr_68288_68327 = state_68276__$1;
(statearr_68288_68327[(2)] = null);

(statearr_68288_68327[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (3))){
var inst_68274 = (state_68276[(2)]);
var state_68276__$1 = state_68276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68276__$1,inst_68274);
} else {
if((state_val_68277 === (12))){
var inst_68232 = (state_68276[(10)]);
var inst_68236 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_68276__$1 = (function (){var statearr_68289 = state_68276;
(statearr_68289[(11)] = inst_68236);

return statearr_68289;
})();
if(cljs.core.truth_(inst_68232)){
var statearr_68290_68328 = state_68276__$1;
(statearr_68290_68328[(1)] = (16));

} else {
var statearr_68291_68329 = state_68276__$1;
(statearr_68291_68329[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (2))){
var _ = (function (){var statearr_68292 = state_68276;
(statearr_68292[(4)] = cljs.core.cons((5),(state_68276[(4)])));

return statearr_68292;
})();
var inst_68218 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68219 = (opts == null);
var state_68276__$1 = (function (){var statearr_68293 = state_68276;
(statearr_68293[(8)] = inst_68218);

return statearr_68293;
})();
if(cljs.core.truth_(inst_68219)){
var statearr_68294_68330 = state_68276__$1;
(statearr_68294_68330[(1)] = (6));

} else {
var statearr_68295_68331 = state_68276__$1;
(statearr_68295_68331[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (23))){
var inst_68266 = (state_68276[(2)]);
var inst_68267 = fluree.db.util.async.throw_err(inst_68266);
var state_68276__$1 = state_68276;
var statearr_68296_68332 = state_68276__$1;
(statearr_68296_68332[(2)] = inst_68267);

(statearr_68296_68332[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (19))){
var inst_68252 = (state_68276[(12)]);
var inst_68224 = (state_68276[(7)]);
var inst_68218 = (state_68276[(8)]);
var inst_68255 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_68252,inst_68218,inst_68224);
var state_68276__$1 = state_68276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68276__$1,(22),inst_68255);
} else {
if((state_val_68277 === (11))){
var inst_68224 = (state_68276[(7)]);
var inst_68226 = (state_68276[(13)]);
var inst_68232 = (state_68276[(2)]);
var inst_68233 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_68224);
var inst_68234 = (inst_68226 == null);
var state_68276__$1 = (function (){var statearr_68298 = state_68276;
(statearr_68298[(10)] = inst_68232);

(statearr_68298[(14)] = inst_68233);

return statearr_68298;
})();
if(cljs.core.truth_(inst_68234)){
var statearr_68299_68333 = state_68276__$1;
(statearr_68299_68333[(1)] = (12));

} else {
var statearr_68300_68334 = state_68276__$1;
(statearr_68300_68334[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (9))){
var inst_68227 = (state_68276[(15)]);
var state_68276__$1 = state_68276;
var statearr_68301_68335 = state_68276__$1;
(statearr_68301_68335[(2)] = inst_68227);

(statearr_68301_68335[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (5))){
var _ = (function (){var statearr_68302 = state_68276;
(statearr_68302[(4)] = cljs.core.rest((state_68276[(4)])));

return statearr_68302;
})();
var state_68276__$1 = state_68276;
var ex68297 = (state_68276__$1[(2)]);
var statearr_68303_68336 = state_68276__$1;
(statearr_68303_68336[(5)] = ex68297);


var statearr_68304_68337 = state_68276__$1;
(statearr_68304_68337[(1)] = (4));

(statearr_68304_68337[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (14))){
var inst_68226 = (state_68276[(13)]);
var inst_68252 = (state_68276[(2)]);
var inst_68253 = (inst_68226 == null);
var state_68276__$1 = (function (){var statearr_68305 = state_68276;
(statearr_68305[(12)] = inst_68252);

return statearr_68305;
})();
if(cljs.core.truth_(inst_68253)){
var statearr_68306_68338 = state_68276__$1;
(statearr_68306_68338[(1)] = (19));

} else {
var statearr_68307_68339 = state_68276__$1;
(statearr_68307_68339[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (16))){
var inst_68232 = (state_68276[(10)]);
var inst_68238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68239 = ["_auth/id",inst_68232];
var inst_68240 = (new cljs.core.PersistentVector(null,2,(5),inst_68238,inst_68239,null));
var state_68276__$1 = state_68276;
var statearr_68308_68340 = state_68276__$1;
(statearr_68308_68340[(2)] = inst_68240);

(statearr_68308_68340[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (10))){
var inst_68224 = (state_68276[(7)]);
var inst_68230 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_68224);
var state_68276__$1 = state_68276;
var statearr_68309_68341 = state_68276__$1;
(statearr_68309_68341[(2)] = inst_68230);

(statearr_68309_68341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68277 === (18))){
var inst_68236 = (state_68276[(11)]);
var inst_68233 = (state_68276[(14)]);
var inst_68243 = (state_68276[(2)]);
var inst_68244 = [inst_68243,inst_68233];
var inst_68245 = cljs.core.PersistentHashMap.fromArrays(inst_68236,inst_68244);
var inst_68246 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68245], 0));
var state_68276__$1 = state_68276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68276__$1,(15),inst_68246);
} else {
if((state_val_68277 === (8))){
var inst_68224 = (state_68276[(7)]);
var inst_68227 = (state_68276[(15)]);
var inst_68224__$1 = (state_68276[(2)]);
var inst_68225 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_68224__$1);
var inst_68226 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_68224__$1);
var inst_68227__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_68224__$1);
var state_68276__$1 = (function (){var statearr_68310 = state_68276;
(statearr_68310[(16)] = inst_68225);

(statearr_68310[(7)] = inst_68224__$1);

(statearr_68310[(13)] = inst_68226);

(statearr_68310[(15)] = inst_68227__$1);

return statearr_68310;
})();
if(cljs.core.truth_(inst_68227__$1)){
var statearr_68311_68342 = state_68276__$1;
(statearr_68311_68342[(1)] = (9));

} else {
var statearr_68312_68343 = state_68276__$1;
(statearr_68312_68343[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_68313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68313[(0)] = flureedb$state_machine__2879__auto__);

(statearr_68313[(1)] = (1));

return statearr_68313;
});
var flureedb$state_machine__2879__auto____1 = (function (state_68276){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68276);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68314){var ex__2882__auto__ = e68314;
var statearr_68315_68344 = state_68276;
(statearr_68315_68344[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68276[(4)]))){
var statearr_68316_68345 = state_68276;
(statearr_68316_68345[(1)] = cljs.core.first((state_68276[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68346 = state_68276;
state_68276 = G__68346;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_68276){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_68276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68317 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68317[(6)] = c__2901__auto__);

return statearr_68317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68366){
var state_val_68367 = (state_68366[(1)]);
if((state_val_68367 === (1))){
var state_68366__$1 = state_68366;
var statearr_68368_68383 = state_68366__$1;
(statearr_68368_68383[(2)] = null);

(statearr_68368_68383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68367 === (2))){
var _ = (function (){var statearr_68369 = state_68366;
(statearr_68369[(4)] = cljs.core.cons((5),(state_68366[(4)])));

return statearr_68369;
})();
var inst_68355 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68356 = fluree.db.api.query.history_query_async(sources,inst_68355);
var state_68366__$1 = state_68366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68366__$1,(6),inst_68356);
} else {
if((state_val_68367 === (3))){
var inst_68364 = (state_68366[(2)]);
var state_68366__$1 = state_68366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68366__$1,inst_68364);
} else {
if((state_val_68367 === (4))){
var inst_68347 = (state_68366[(2)]);
var inst_68348 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68347], 0));
var inst_68349 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68347) : reject.call(null,inst_68347));
var state_68366__$1 = (function (){var statearr_68371 = state_68366;
(statearr_68371[(7)] = inst_68348);

return statearr_68371;
})();
var statearr_68372_68384 = state_68366__$1;
(statearr_68372_68384[(2)] = inst_68349);

(statearr_68372_68384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68367 === (5))){
var _ = (function (){var statearr_68373 = state_68366;
(statearr_68373[(4)] = cljs.core.rest((state_68366[(4)])));

return statearr_68373;
})();
var state_68366__$1 = state_68366;
var ex68370 = (state_68366__$1[(2)]);
var statearr_68374_68385 = state_68366__$1;
(statearr_68374_68385[(5)] = ex68370);


var statearr_68375_68386 = state_68366__$1;
(statearr_68375_68386[(1)] = (4));

(statearr_68375_68386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68367 === (6))){
var inst_68358 = (state_68366[(2)]);
var inst_68359 = fluree.db.util.async.throw_err(inst_68358);
var inst_68360 = cljs.core.clj__GT_js(inst_68359);
var inst_68361 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68360) : resolve.call(null,inst_68360));
var _ = (function (){var statearr_68376 = state_68366;
(statearr_68376[(4)] = cljs.core.rest((state_68366[(4)])));

return statearr_68376;
})();
var state_68366__$1 = state_68366;
var statearr_68377_68387 = state_68366__$1;
(statearr_68377_68387[(2)] = inst_68361);

(statearr_68377_68387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2879__auto__ = null;
var flureedb$history_query_$_state_machine__2879__auto____0 = (function (){
var statearr_68378 = [null,null,null,null,null,null,null,null];
(statearr_68378[(0)] = flureedb$history_query_$_state_machine__2879__auto__);

(statearr_68378[(1)] = (1));

return statearr_68378;
});
var flureedb$history_query_$_state_machine__2879__auto____1 = (function (state_68366){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68366);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68379){var ex__2882__auto__ = e68379;
var statearr_68380_68388 = state_68366;
(statearr_68380_68388[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68366[(4)]))){
var statearr_68381_68389 = state_68366;
(statearr_68381_68389[(1)] = cljs.core.first((state_68366[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68390 = state_68366;
state_68366 = G__68390;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2879__auto__ = function(state_68366){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2879__auto____1.call(this,state_68366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2879__auto____0;
flureedb$history_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2879__auto____1;
return flureedb$history_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68382 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68382[(6)] = c__2901__auto__);

return statearr_68382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68410){
var state_val_68411 = (state_68410[(1)]);
if((state_val_68411 === (1))){
var state_68410__$1 = state_68410;
var statearr_68412_68427 = state_68410__$1;
(statearr_68412_68427[(2)] = null);

(statearr_68412_68427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (2))){
var _ = (function (){var statearr_68413 = state_68410;
(statearr_68413[(4)] = cljs.core.cons((5),(state_68410[(4)])));

return statearr_68413;
})();
var inst_68399 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68400 = fluree.db.api.query.multi_query_async(sources,inst_68399);
var state_68410__$1 = state_68410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68410__$1,(6),inst_68400);
} else {
if((state_val_68411 === (3))){
var inst_68408 = (state_68410[(2)]);
var state_68410__$1 = state_68410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68410__$1,inst_68408);
} else {
if((state_val_68411 === (4))){
var inst_68391 = (state_68410[(2)]);
var inst_68392 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68391], 0));
var inst_68393 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68391) : reject.call(null,inst_68391));
var state_68410__$1 = (function (){var statearr_68415 = state_68410;
(statearr_68415[(7)] = inst_68392);

return statearr_68415;
})();
var statearr_68416_68428 = state_68410__$1;
(statearr_68416_68428[(2)] = inst_68393);

(statearr_68416_68428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (5))){
var _ = (function (){var statearr_68417 = state_68410;
(statearr_68417[(4)] = cljs.core.rest((state_68410[(4)])));

return statearr_68417;
})();
var state_68410__$1 = state_68410;
var ex68414 = (state_68410__$1[(2)]);
var statearr_68418_68429 = state_68410__$1;
(statearr_68418_68429[(5)] = ex68414);


var statearr_68419_68430 = state_68410__$1;
(statearr_68419_68430[(1)] = (4));

(statearr_68419_68430[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (6))){
var inst_68402 = (state_68410[(2)]);
var inst_68403 = fluree.db.util.async.throw_err(inst_68402);
var inst_68404 = cljs.core.clj__GT_js(inst_68403);
var inst_68405 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68404) : resolve.call(null,inst_68404));
var _ = (function (){var statearr_68420 = state_68410;
(statearr_68420[(4)] = cljs.core.rest((state_68410[(4)])));

return statearr_68420;
})();
var state_68410__$1 = state_68410;
var statearr_68421_68431 = state_68410__$1;
(statearr_68421_68431[(2)] = inst_68405);

(statearr_68421_68431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2879__auto__ = null;
var flureedb$multi_query_$_state_machine__2879__auto____0 = (function (){
var statearr_68422 = [null,null,null,null,null,null,null,null];
(statearr_68422[(0)] = flureedb$multi_query_$_state_machine__2879__auto__);

(statearr_68422[(1)] = (1));

return statearr_68422;
});
var flureedb$multi_query_$_state_machine__2879__auto____1 = (function (state_68410){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68410);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68423){var ex__2882__auto__ = e68423;
var statearr_68424_68432 = state_68410;
(statearr_68424_68432[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68410[(4)]))){
var statearr_68425_68433 = state_68410;
(statearr_68425_68433[(1)] = cljs.core.first((state_68410[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68434 = state_68410;
state_68410 = G__68434;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2879__auto__ = function(state_68410){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2879__auto____1.call(this,state_68410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2879__auto____0;
flureedb$multi_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2879__auto____1;
return flureedb$multi_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68426 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68426[(6)] = c__2901__auto__);

return statearr_68426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68454){
var state_val_68455 = (state_68454[(1)]);
if((state_val_68455 === (1))){
var state_68454__$1 = state_68454;
var statearr_68456_68471 = state_68454__$1;
(statearr_68456_68471[(2)] = null);

(statearr_68456_68471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68455 === (2))){
var _ = (function (){var statearr_68457 = state_68454;
(statearr_68457[(4)] = cljs.core.cons((5),(state_68454[(4)])));

return statearr_68457;
})();
var inst_68444 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68445 = fluree.db.api.query.query_async(sources,inst_68444);
var state_68454__$1 = state_68454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68454__$1,(6),inst_68445);
} else {
if((state_val_68455 === (3))){
var inst_68452 = (state_68454[(2)]);
var state_68454__$1 = state_68454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68454__$1,inst_68452);
} else {
if((state_val_68455 === (4))){
var inst_68435 = (state_68454[(2)]);
var inst_68436 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68435], 0));
var inst_68437 = cljs.core.clj__GT_js(inst_68435);
var inst_68438 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68437) : reject.call(null,inst_68437));
var state_68454__$1 = (function (){var statearr_68459 = state_68454;
(statearr_68459[(7)] = inst_68436);

return statearr_68459;
})();
var statearr_68460_68472 = state_68454__$1;
(statearr_68460_68472[(2)] = inst_68438);

(statearr_68460_68472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68455 === (5))){
var _ = (function (){var statearr_68461 = state_68454;
(statearr_68461[(4)] = cljs.core.rest((state_68454[(4)])));

return statearr_68461;
})();
var state_68454__$1 = state_68454;
var ex68458 = (state_68454__$1[(2)]);
var statearr_68462_68473 = state_68454__$1;
(statearr_68462_68473[(5)] = ex68458);


var statearr_68463_68474 = state_68454__$1;
(statearr_68463_68474[(1)] = (4));

(statearr_68463_68474[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68455 === (6))){
var inst_68447 = (state_68454[(2)]);
var inst_68448 = cljs.core.clj__GT_js(inst_68447);
var inst_68449 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68448) : resolve.call(null,inst_68448));
var _ = (function (){var statearr_68464 = state_68454;
(statearr_68464[(4)] = cljs.core.rest((state_68454[(4)])));

return statearr_68464;
})();
var state_68454__$1 = state_68454;
var statearr_68465_68475 = state_68454__$1;
(statearr_68465_68475[(2)] = inst_68449);

(statearr_68465_68475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2879__auto__ = null;
var flureedb$query_$_state_machine__2879__auto____0 = (function (){
var statearr_68466 = [null,null,null,null,null,null,null,null];
(statearr_68466[(0)] = flureedb$query_$_state_machine__2879__auto__);

(statearr_68466[(1)] = (1));

return statearr_68466;
});
var flureedb$query_$_state_machine__2879__auto____1 = (function (state_68454){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68454);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68467){var ex__2882__auto__ = e68467;
var statearr_68468_68476 = state_68454;
(statearr_68468_68476[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68454[(4)]))){
var statearr_68469_68477 = state_68454;
(statearr_68469_68477[(1)] = cljs.core.first((state_68454[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68478 = state_68454;
state_68454 = G__68478;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2879__auto__ = function(state_68454){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2879__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2879__auto____1.call(this,state_68454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2879__auto____0;
flureedb$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2879__auto____1;
return flureedb$query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68470 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68470[(6)] = c__2901__auto__);

return statearr_68470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__68480 = arguments.length;
switch (G__68480) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68507){
var state_val_68508 = (state_68507[(1)]);
if((state_val_68508 === (7))){
var inst_68494 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_68507__$1 = state_68507;
var statearr_68509_68530 = state_68507__$1;
(statearr_68509_68530[(2)] = inst_68494);

(statearr_68509_68530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (1))){
var state_68507__$1 = state_68507;
var statearr_68510_68531 = state_68507__$1;
(statearr_68510_68531[(2)] = null);

(statearr_68510_68531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (4))){
var inst_68481 = (state_68507[(2)]);
var inst_68482 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68481], 0));
var inst_68483 = cljs.core.clj__GT_js(inst_68481);
var inst_68484 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68483) : reject.call(null,inst_68483));
var state_68507__$1 = (function (){var statearr_68511 = state_68507;
(statearr_68511[(7)] = inst_68482);

return statearr_68511;
})();
var statearr_68512_68532 = state_68507__$1;
(statearr_68512_68532[(2)] = inst_68484);

(statearr_68512_68532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (6))){
var state_68507__$1 = state_68507;
var statearr_68513_68533 = state_68507__$1;
(statearr_68513_68533[(2)] = null);

(statearr_68513_68533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (3))){
var inst_68505 = (state_68507[(2)]);
var state_68507__$1 = state_68507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68507__$1,inst_68505);
} else {
if((state_val_68508 === (2))){
var _ = (function (){var statearr_68515 = state_68507;
(statearr_68515[(4)] = cljs.core.cons((5),(state_68507[(4)])));

return statearr_68515;
})();
var inst_68490 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_68491 = (opts == null);
var state_68507__$1 = (function (){var statearr_68516 = state_68507;
(statearr_68516[(8)] = inst_68490);

return statearr_68516;
})();
if(cljs.core.truth_(inst_68491)){
var statearr_68517_68534 = state_68507__$1;
(statearr_68517_68534[(1)] = (6));

} else {
var statearr_68518_68535 = state_68507__$1;
(statearr_68518_68535[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (9))){
var inst_68499 = (state_68507[(2)]);
var inst_68500 = fluree.db.util.async.throw_err(inst_68499);
var inst_68501 = cljs.core.clj__GT_js(inst_68500);
var inst_68502 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68501) : resolve.call(null,inst_68501));
var _ = (function (){var statearr_68519 = state_68507;
(statearr_68519[(4)] = cljs.core.rest((state_68507[(4)])));

return statearr_68519;
})();
var state_68507__$1 = state_68507;
var statearr_68520_68536 = state_68507__$1;
(statearr_68520_68536[(2)] = inst_68502);

(statearr_68520_68536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (5))){
var _ = (function (){var statearr_68521 = state_68507;
(statearr_68521[(4)] = cljs.core.rest((state_68507[(4)])));

return statearr_68521;
})();
var state_68507__$1 = state_68507;
var ex68514 = (state_68507__$1[(2)]);
var statearr_68522_68537 = state_68507__$1;
(statearr_68522_68537[(5)] = ex68514);


var statearr_68523_68538 = state_68507__$1;
(statearr_68523_68538[(1)] = (4));

(statearr_68523_68538[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68508 === (8))){
var inst_68490 = (state_68507[(8)]);
var inst_68496 = (state_68507[(2)]);
var inst_68497 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_68490,inst_68496);
var state_68507__$1 = state_68507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68507__$1,(9),inst_68497);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2879__auto__ = null;
var flureedb$state_machine__2879__auto____0 = (function (){
var statearr_68524 = [null,null,null,null,null,null,null,null,null];
(statearr_68524[(0)] = flureedb$state_machine__2879__auto__);

(statearr_68524[(1)] = (1));

return statearr_68524;
});
var flureedb$state_machine__2879__auto____1 = (function (state_68507){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_68507);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68525){var ex__2882__auto__ = e68525;
var statearr_68526_68539 = state_68507;
(statearr_68526_68539[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_68507[(4)]))){
var statearr_68527_68540 = state_68507;
(statearr_68527_68540[(1)] = cljs.core.first((state_68507[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68541 = state_68507;
state_68507 = G__68541;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureedb$state_machine__2879__auto__ = function(state_68507){
switch(arguments.length){
case 0:
return flureedb$state_machine__2879__auto____0.call(this);
case 1:
return flureedb$state_machine__2879__auto____1.call(this,state_68507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2879__auto____0;
flureedb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2879__auto____1;
return flureedb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68528 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_68528[(6)] = c__2901__auto__);

return statearr_68528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
