// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62961_63130 = cljs.core.seq(servers);
var chunk__62962_63131 = null;
var count__62963_63132 = (0);
var i__62964_63133 = (0);
while(true){
if((i__62964_63133 < count__62963_63132)){
var server_63134 = chunk__62962_63131.cljs$core$IIndexed$_nth$arity$2(null,i__62964_63133);
var healthcheck_uri_63135 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_63134),"/fdb/health"].join('');
var resp_chan_63136 = fluree.db.util.xhttp.post_json(healthcheck_uri_63135,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2901__auto___63137 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134){
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = ((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134){
return (function (state_63025){
var state_val_63026 = (state_63025[(1)]);
if((state_val_63026 === (1))){
var state_63025__$1 = state_63025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63025__$1,(2),resp_chan_63136);
} else {
if((state_val_63026 === (2))){
var inst_63014 = (state_63025[(7)]);
var inst_63014__$1 = (state_63025[(2)]);
var inst_63015 = fluree.db.util.core.exception_QMARK_(inst_63014__$1);
var state_63025__$1 = (function (){var statearr_63027 = state_63025;
(statearr_63027[(7)] = inst_63014__$1);

return statearr_63027;
})();
if(inst_63015){
var statearr_63028_63138 = state_63025__$1;
(statearr_63028_63138[(1)] = (3));

} else {
var statearr_63029_63139 = state_63025__$1;
(statearr_63029_63139[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63026 === (3))){
var inst_63014 = (state_63025[(7)]);
var inst_63017 = cljs.core.ex_message(inst_63014);
var inst_63018 = cljs.core.ex_data(inst_63014);
var inst_63019 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_63017,inst_63018], 0));
var state_63025__$1 = state_63025;
var statearr_63030_63140 = state_63025__$1;
(statearr_63030_63140[(2)] = inst_63019);

(statearr_63030_63140[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63026 === (4))){
var inst_63021 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_63134);
var state_63025__$1 = state_63025;
var statearr_63031_63141 = state_63025__$1;
(statearr_63031_63141[(2)] = inst_63021);

(statearr_63031_63141[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63026 === (5))){
var inst_63023 = (state_63025[(2)]);
var state_63025__$1 = state_63025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63025__$1,inst_63023);
} else {
return null;
}
}
}
}
}
});})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134))
;
return ((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,switch__2878__auto__,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_63032 = [null,null,null,null,null,null,null,null];
(statearr_63032[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_63032[(1)] = (1));

return statearr_63032;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_63025){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63025);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63033){var ex__2882__auto__ = e63033;
var statearr_63034_63142 = state_63025;
(statearr_63034_63142[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63025[(4)]))){
var statearr_63035_63143 = state_63025;
(statearr_63035_63143[(1)] = cljs.core.first((state_63025[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63144 = state_63025;
state_63025 = G__63144;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_63025){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_63025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
;})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,switch__2878__auto__,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134))
})();
var state__2903__auto__ = (function (){var statearr_63036 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63036[(6)] = c__2901__auto___63137);

return statearr_63036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63137,healthcheck_uri_63135,resp_chan_63136,server_63134))
);



var G__63145 = seq__62961_63130;
var G__63146 = chunk__62962_63131;
var G__63147 = count__62963_63132;
var G__63148 = (i__62964_63133 + (1));
seq__62961_63130 = G__63145;
chunk__62962_63131 = G__63146;
count__62963_63132 = G__63147;
i__62964_63133 = G__63148;
continue;
} else {
var temp__5735__auto___63149 = cljs.core.seq(seq__62961_63130);
if(temp__5735__auto___63149){
var seq__62961_63150__$1 = temp__5735__auto___63149;
if(cljs.core.chunked_seq_QMARK_(seq__62961_63150__$1)){
var c__4556__auto___63151 = cljs.core.chunk_first(seq__62961_63150__$1);
var G__63152 = cljs.core.chunk_rest(seq__62961_63150__$1);
var G__63153 = c__4556__auto___63151;
var G__63154 = cljs.core.count(c__4556__auto___63151);
var G__63155 = (0);
seq__62961_63130 = G__63152;
chunk__62962_63131 = G__63153;
count__62963_63132 = G__63154;
i__62964_63133 = G__63155;
continue;
} else {
var server_63156 = cljs.core.first(seq__62961_63150__$1);
var healthcheck_uri_63157 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_63156),"/fdb/health"].join('');
var resp_chan_63158 = fluree.db.util.xhttp.post_json(healthcheck_uri_63157,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2901__auto___63159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149){
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = ((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149){
return (function (state_63049){
var state_val_63050 = (state_63049[(1)]);
if((state_val_63050 === (1))){
var state_63049__$1 = state_63049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63049__$1,(2),resp_chan_63158);
} else {
if((state_val_63050 === (2))){
var inst_63038 = (state_63049[(7)]);
var inst_63038__$1 = (state_63049[(2)]);
var inst_63039 = fluree.db.util.core.exception_QMARK_(inst_63038__$1);
var state_63049__$1 = (function (){var statearr_63051 = state_63049;
(statearr_63051[(7)] = inst_63038__$1);

return statearr_63051;
})();
if(inst_63039){
var statearr_63052_63160 = state_63049__$1;
(statearr_63052_63160[(1)] = (3));

} else {
var statearr_63053_63161 = state_63049__$1;
(statearr_63053_63161[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63050 === (3))){
var inst_63038 = (state_63049[(7)]);
var inst_63041 = cljs.core.ex_message(inst_63038);
var inst_63042 = cljs.core.ex_data(inst_63038);
var inst_63043 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_63041,inst_63042], 0));
var state_63049__$1 = state_63049;
var statearr_63054_63162 = state_63049__$1;
(statearr_63054_63162[(2)] = inst_63043);

(statearr_63054_63162[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63050 === (4))){
var inst_63045 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_63156);
var state_63049__$1 = state_63049;
var statearr_63055_63163 = state_63049__$1;
(statearr_63055_63163[(2)] = inst_63045);

(statearr_63055_63163[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63050 === (5))){
var inst_63047 = (state_63049[(2)]);
var state_63049__$1 = state_63049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63049__$1,inst_63047);
} else {
return null;
}
}
}
}
}
});})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149))
;
return ((function (seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,switch__2878__auto__,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_63056 = [null,null,null,null,null,null,null,null];
(statearr_63056[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_63056[(1)] = (1));

return statearr_63056;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_63049){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63049);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63057){var ex__2882__auto__ = e63057;
var statearr_63058_63164 = state_63049;
(statearr_63058_63164[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63049[(4)]))){
var statearr_63059_63165 = state_63049;
(statearr_63059_63165[(1)] = cljs.core.first((state_63049[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63166 = state_63049;
state_63049 = G__63166;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_63049){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_63049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
;})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,switch__2878__auto__,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149))
})();
var state__2903__auto__ = (function (){var statearr_63060 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63060[(6)] = c__2901__auto___63159);

return statearr_63060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});})(seq__62961_63130,chunk__62962_63131,count__62963_63132,i__62964_63133,c__2901__auto___63159,healthcheck_uri_63157,resp_chan_63158,server_63156,seq__62961_63150__$1,temp__5735__auto___63149))
);



var G__63167 = cljs.core.next(seq__62961_63150__$1);
var G__63168 = null;
var G__63169 = (0);
var G__63170 = (0);
seq__62961_63130 = G__63167;
chunk__62962_63131 = G__63168;
count__62963_63132 = G__63169;
i__62964_63133 = G__63170;
continue;
}
} else {
}
}
break;
}

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63104){
var state_val_63105 = (state_63104[(1)]);
if((state_val_63105 === (7))){
var inst_63076 = (state_63104[(7)]);
var inst_63083 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63076,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63104__$1 = state_63104;
if(inst_63083){
var statearr_63106_63171 = state_63104__$1;
(statearr_63106_63171[(1)] = (9));

} else {
var statearr_63107_63172 = state_63104__$1;
(statearr_63107_63172[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (1))){
var inst_63068 = (state_63104[(8)]);
var inst_63069 = (state_63104[(9)]);
var inst_63068__$1 = promise_chan;
var inst_63069__$1 = cljs.core.async.timeout((60000));
var inst_63070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63071 = [inst_63068__$1,inst_63069__$1];
var inst_63072 = (new cljs.core.PersistentVector(null,2,(5),inst_63070,inst_63071,null));
var state_63104__$1 = (function (){var statearr_63108 = state_63104;
(statearr_63108[(8)] = inst_63068__$1);

(statearr_63108[(9)] = inst_63069__$1);

return statearr_63108;
})();
return cljs.core.async.ioc_alts_BANG_(state_63104__$1,(2),inst_63072);
} else {
if((state_val_63105 === (4))){
var inst_63076 = (state_63104[(7)]);
var inst_63069 = (state_63104[(9)]);
var inst_63080 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63076,inst_63069);
var state_63104__$1 = state_63104;
if(inst_63080){
var statearr_63109_63173 = state_63104__$1;
(statearr_63109_63173[(1)] = (6));

} else {
var statearr_63110_63174 = state_63104__$1;
(statearr_63110_63174[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (13))){
var state_63104__$1 = state_63104;
var statearr_63111_63175 = state_63104__$1;
(statearr_63111_63175[(2)] = null);

(statearr_63111_63175[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (6))){
var state_63104__$1 = state_63104;
var statearr_63112_63176 = state_63104__$1;
(statearr_63112_63176[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_63112_63176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (3))){
var state_63104__$1 = state_63104;
var statearr_63113_63177 = state_63104__$1;
(statearr_63113_63177[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_63113_63177[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (12))){
var inst_63094 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_63095 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63096 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_63097 = cljs.core.PersistentHashMap.fromArrays(inst_63095,inst_63096);
var inst_63098 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_63097);
var inst_63099 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_63098);
var state_63104__$1 = (function (){var statearr_63114 = state_63104;
(statearr_63114[(10)] = inst_63094);

return statearr_63114;
})();
var statearr_63115_63178 = state_63104__$1;
(statearr_63115_63178[(2)] = inst_63099);

(statearr_63115_63178[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (2))){
var inst_63068 = (state_63104[(8)]);
var inst_63076 = (state_63104[(7)]);
var inst_63074 = (state_63104[(2)]);
var inst_63075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63074,(0),null);
var inst_63076__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63074,(1),null);
var inst_63077 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63076__$1,inst_63068);
var state_63104__$1 = (function (){var statearr_63116 = state_63104;
(statearr_63116[(11)] = inst_63075);

(statearr_63116[(7)] = inst_63076__$1);

return statearr_63116;
})();
if(inst_63077){
var statearr_63117_63179 = state_63104__$1;
(statearr_63117_63179[(1)] = (3));

} else {
var statearr_63118_63180 = state_63104__$1;
(statearr_63118_63180[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (11))){
var inst_63087 = (state_63104[(2)]);
var state_63104__$1 = state_63104;
var statearr_63119_63181 = state_63104__$1;
(statearr_63119_63181[(2)] = inst_63087);

(statearr_63119_63181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (9))){
var inst_63075 = (state_63104[(11)]);
var state_63104__$1 = state_63104;
var statearr_63120_63182 = state_63104__$1;
(statearr_63120_63182[(2)] = inst_63075);

(statearr_63120_63182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (5))){
var inst_63091 = (state_63104[(2)]);
var inst_63092 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_63091);
var state_63104__$1 = state_63104;
if(inst_63092){
var statearr_63121_63183 = state_63104__$1;
(statearr_63121_63183[(1)] = (12));

} else {
var statearr_63122_63184 = state_63104__$1;
(statearr_63122_63184[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (14))){
var inst_63102 = (state_63104[(2)]);
var state_63104__$1 = state_63104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63104__$1,inst_63102);
} else {
if((state_val_63105 === (10))){
var state_63104__$1 = state_63104;
var statearr_63123_63185 = state_63104__$1;
(statearr_63123_63185[(2)] = null);

(statearr_63123_63185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63105 === (8))){
var inst_63089 = (state_63104[(2)]);
var state_63104__$1 = state_63104;
var statearr_63124_63186 = state_63104__$1;
(statearr_63124_63186[(2)] = inst_63089);

(statearr_63124_63186[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0 = (function (){
var statearr_63125 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63125[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__);

(statearr_63125[(1)] = (1));

return statearr_63125;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1 = (function (state_63104){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63104);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63126){var ex__2882__auto__ = e63126;
var statearr_63127_63187 = state_63104;
(statearr_63127_63187[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63104[(4)]))){
var statearr_63128_63188 = state_63104;
(statearr_63128_63188[(1)] = cljs.core.first((state_63104[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63189 = state_63104;
state_63104 = G__63189;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__ = function(state_63104){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1.call(this,state_63104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63129 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63129[(6)] = c__2901__auto__);

return statearr_63129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63233){
var state_val_63234 = (state_63233[(1)]);
if((state_val_63234 === (7))){
var state_63233__$1 = state_63233;
var statearr_63235_63261 = state_63233__$1;
(statearr_63235_63261[(2)] = null);

(statearr_63235_63261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (1))){
var state_63233__$1 = state_63233;
var statearr_63236_63262 = state_63233__$1;
(statearr_63236_63262[(2)] = null);

(statearr_63236_63262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (4))){
var inst_63190 = (state_63233[(2)]);
var state_63233__$1 = state_63233;
var statearr_63237_63263 = state_63233__$1;
(statearr_63237_63263[(2)] = inst_63190);

(statearr_63237_63263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (6))){
var inst_63212 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_63233__$1 = state_63233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63233__$1,(9),inst_63212);
} else {
if((state_val_63234 === (3))){
var inst_63231 = (state_63233[(2)]);
var state_63233__$1 = state_63233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63233__$1,inst_63231);
} else {
if((state_val_63234 === (12))){
var inst_63225 = (state_63233[(2)]);
var state_63233__$1 = state_63233;
var statearr_63238_63264 = state_63233__$1;
(statearr_63238_63264[(2)] = inst_63225);

(statearr_63238_63264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (2))){
var inst_63201 = (state_63233[(7)]);
var inst_63196 = (state_63233[(8)]);
var inst_63206 = (state_63233[(9)]);
var _ = (function (){var statearr_63239 = state_63233;
(statearr_63239[(4)] = cljs.core.cons((5),(state_63233[(4)])));

return statearr_63239;
})();
var inst_63196__$1 = fluree.db.util.core.random_uuid();
var inst_63197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63198 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_63199 = (new cljs.core.PersistentVector(null,2,(5),inst_63197,inst_63198,null));
var inst_63200 = (function (){var lock_id = inst_63196__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_63201__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_63199,inst_63200);
var inst_63202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63203 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_63204 = (new cljs.core.PersistentVector(null,3,(5),inst_63202,inst_63203,null));
var inst_63205 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63201__$1,inst_63204);
var inst_63206__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63196__$1,inst_63205);
var inst_63207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63208 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_63209 = (new cljs.core.PersistentVector(null,3,(5),inst_63207,inst_63208,null));
var inst_63210 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63201__$1,inst_63209);
var state_63233__$1 = (function (){var statearr_63240 = state_63233;
(statearr_63240[(10)] = inst_63210);

(statearr_63240[(7)] = inst_63201__$1);

(statearr_63240[(8)] = inst_63196__$1);

(statearr_63240[(9)] = inst_63206__$1);

return statearr_63240;
})();
if(inst_63206__$1){
var statearr_63241_63265 = state_63233__$1;
(statearr_63241_63265[(1)] = (6));

} else {
var statearr_63242_63266 = state_63233__$1;
(statearr_63242_63266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (11))){
var inst_63210 = (state_63233[(10)]);
var inst_63217 = (state_63233[(11)]);
var inst_63216 = (state_63233[(12)]);
var inst_63223 = fluree.db.util.xhttp.try_socket(inst_63216,sub_chan,pub_chan,inst_63210,(60000),inst_63217);
var state_63233__$1 = state_63233;
var statearr_63244_63267 = state_63233__$1;
(statearr_63244_63267[(2)] = inst_63223);

(statearr_63244_63267[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (9))){
var inst_63210 = (state_63233[(10)]);
var inst_63214 = (state_63233[(13)]);
var inst_63201 = (state_63233[(7)]);
var inst_63216 = (state_63233[(12)]);
var inst_63196 = (state_63233[(8)]);
var inst_63206 = (state_63233[(9)]);
var inst_63214__$1 = (state_63233[(2)]);
var inst_63215 = clojure.string.replace(inst_63214__$1,"http","ws");
var inst_63216__$1 = [inst_63215,"/fdb/ws"].join('');
var inst_63217 = (function (){var lock_id = inst_63196;
var state = inst_63201;
var have_lock_QMARK_ = inst_63206;
var resp_chan = inst_63210;
var healthy_server = inst_63214__$1;
var ws_url = inst_63216__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_63218 = fluree.db.util.core.exception_QMARK_(inst_63214__$1);
var state_63233__$1 = (function (){var statearr_63245 = state_63233;
(statearr_63245[(13)] = inst_63214__$1);

(statearr_63245[(11)] = inst_63217);

(statearr_63245[(12)] = inst_63216__$1);

return statearr_63245;
})();
if(inst_63218){
var statearr_63246_63268 = state_63233__$1;
(statearr_63246_63268[(1)] = (10));

} else {
var statearr_63247_63269 = state_63233__$1;
(statearr_63247_63269[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (5))){
var _ = (function (){var statearr_63248 = state_63233;
(statearr_63248[(4)] = cljs.core.rest((state_63233[(4)])));

return statearr_63248;
})();
var state_63233__$1 = state_63233;
var ex63243 = (state_63233__$1[(2)]);
var statearr_63249_63270 = state_63233__$1;
(statearr_63249_63270[(5)] = ex63243);


if((ex63243 instanceof Error)){
var statearr_63250_63271 = state_63233__$1;
(statearr_63250_63271[(1)] = (4));

(statearr_63250_63271[(5)] = null);

} else {
throw ex63243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (10))){
var inst_63210 = (state_63233[(10)]);
var inst_63214 = (state_63233[(13)]);
var inst_63220 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_63221 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63210,inst_63214);
var state_63233__$1 = (function (){var statearr_63251 = state_63233;
(statearr_63251[(14)] = inst_63220);

return statearr_63251;
})();
var statearr_63252_63272 = state_63233__$1;
(statearr_63252_63272[(2)] = inst_63221);

(statearr_63252_63272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63234 === (8))){
var inst_63210 = (state_63233[(10)]);
var inst_63228 = (state_63233[(2)]);
var _ = (function (){var statearr_63253 = state_63233;
(statearr_63253[(4)] = cljs.core.rest((state_63233[(4)])));

return statearr_63253;
})();
var state_63233__$1 = (function (){var statearr_63254 = state_63233;
(statearr_63254[(15)] = inst_63228);

return statearr_63254;
})();
var statearr_63255_63273 = state_63233__$1;
(statearr_63255_63273[(2)] = inst_63210);

(statearr_63255_63273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2879__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_63256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63256[(0)] = fluree$db$connection$establish_socket_$_state_machine__2879__auto__);

(statearr_63256[(1)] = (1));

return statearr_63256;
});
var fluree$db$connection$establish_socket_$_state_machine__2879__auto____1 = (function (state_63233){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63233);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63257){var ex__2882__auto__ = e63257;
var statearr_63258_63274 = state_63233;
(statearr_63258_63274[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63233[(4)]))){
var statearr_63259_63275 = state_63233;
(statearr_63259_63275[(1)] = cljs.core.first((state_63233[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63276 = state_63233;
state_63233 = G__63276;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2879__auto__ = function(state_63233){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2879__auto____1.call(this,state_63233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2879__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2879__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63260 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63260[(6)] = c__2901__auto__);

return statearr_63260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k63278,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__63282 = k63278;
var G__63282__$1 = (((G__63282 instanceof cljs.core.Keyword))?G__63282.fqn:null);
switch (G__63282__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k63278,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__63283){
var vec__63284 = p__63283;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63284,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63284,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__63277){
var self__ = this;
var G__63277__$1 = this;
return (new cljs.core.RecordIter((0),G__63277__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__63287 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__63287(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this63279,other63280){
var self__ = this;
var this63279__$1 = this;
return (((!((other63280 == null)))) && ((this63279__$1.constructor === other63280.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.id,other63280.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.servers,other63280.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.state,other63280.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.req_chan,other63280.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.sub_chan,other63280.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.pub_chan,other63280.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.storage_read,other63280.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.storage_write,other63280.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.object_cache,other63280.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.parallelism,other63280.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.serializer,other63280.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.default_network,other63280.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.transactor_QMARK_,other63280.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.publish,other63280.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.transact_handler,other63280.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.tx_private_key,other63280.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.tx_key_id,other63280.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.meta,other63280.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.add_listener,other63280.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.remove_listener,other63280.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.close,other63280.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this63279__$1.__extmap,other63280.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__63277){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__63288 = cljs.core.keyword_identical_QMARK_;
var expr__63289 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__63291 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__63292 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63291,G__63292) : pred__63288.call(null,G__63291,G__63292));
})())){
return (new fluree.db.connection.Connection(G__63277,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63293 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__63294 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63293,G__63294) : pred__63288.call(null,G__63293,G__63294));
})())){
return (new fluree.db.connection.Connection(self__.id,G__63277,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63295 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__63296 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63295,G__63296) : pred__63288.call(null,G__63295,G__63296));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__63277,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63297 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__63298 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63297,G__63298) : pred__63288.call(null,G__63297,G__63298));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__63277,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63299 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__63300 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63299,G__63300) : pred__63288.call(null,G__63299,G__63300));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__63277,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63301 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__63302 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63301,G__63302) : pred__63288.call(null,G__63301,G__63302));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__63277,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63303 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__63304 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63303,G__63304) : pred__63288.call(null,G__63303,G__63304));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__63277,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63305 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__63306 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63305,G__63306) : pred__63288.call(null,G__63305,G__63306));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__63277,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63307 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__63308 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63307,G__63308) : pred__63288.call(null,G__63307,G__63308));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__63277,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63309 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__63310 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63309,G__63310) : pred__63288.call(null,G__63309,G__63310));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__63277,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63311 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__63312 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63311,G__63312) : pred__63288.call(null,G__63311,G__63312));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__63277,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63313 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__63314 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63313,G__63314) : pred__63288.call(null,G__63313,G__63314));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__63277,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63315 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__63316 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63315,G__63316) : pred__63288.call(null,G__63315,G__63316));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__63277,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63317 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__63318 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63317,G__63318) : pred__63288.call(null,G__63317,G__63318));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__63277,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63319 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__63320 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63319,G__63320) : pred__63288.call(null,G__63319,G__63320));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__63277,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63321 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__63322 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63321,G__63322) : pred__63288.call(null,G__63321,G__63322));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__63277,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63323 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__63324 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63323,G__63324) : pred__63288.call(null,G__63323,G__63324));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__63277,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63325 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__63326 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63325,G__63326) : pred__63288.call(null,G__63325,G__63326));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__63277,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63327 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__63328 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63327,G__63328) : pred__63288.call(null,G__63327,G__63328));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__63277,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63329 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__63330 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63329,G__63330) : pred__63288.call(null,G__63329,G__63330));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__63277,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__63331 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__63332 = expr__63289;
return (pred__63288.cljs$core$IFn$_invoke$arity$2 ? pred__63288.cljs$core$IFn$_invoke$arity$2(G__63331,G__63332) : pred__63288.call(null,G__63331,G__63332));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__63277,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__63277),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__63277){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__63277,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__63281){
var extmap__4419__auto__ = (function (){var G__63333 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__63281,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__63281)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__63333);
} else {
return G__63333;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__63281),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__63281),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__63338 = servers_STAR_;
var vec__63339 = G__63338;
var seq__63340 = cljs.core.seq(vec__63339);
var first__63341 = cljs.core.first(seq__63340);
var seq__63340__$1 = cljs.core.next(seq__63340);
var server = first__63341;
var r = seq__63340__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__63338__$1 = G__63338;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__63345 = G__63338__$1;
var seq__63346 = cljs.core.seq(vec__63345);
var first__63347 = cljs.core.first(seq__63346);
var seq__63346__$1 = cljs.core.next(seq__63346);
var server__$1 = first__63347;
var r__$1 = seq__63346__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__63348 = r__$1;
var G__63349 = is_https_QMARK_;
var G__63350 = result_STAR_;
G__63338__$1 = G__63348;
https_QMARK___$1 = G__63349;
result__$1 = G__63350;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__63351 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__63351 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__63351);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63380){
var state_val_63381 = (state_63380[(1)]);
if((state_val_63381 === (7))){
var inst_63366 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63367 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63368 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63369 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63370 = fluree.db.connection.establish_socket(inst_63366,inst_63367,inst_63368,inst_63369);
var state_63380__$1 = state_63380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63380__$1,(9),inst_63370);
} else {
if((state_val_63381 === (1))){
var state_63380__$1 = state_63380;
var statearr_63382_63401 = state_63380__$1;
(statearr_63382_63401[(2)] = null);

(statearr_63382_63401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (4))){
var inst_63352 = (state_63380[(2)]);
var state_63380__$1 = state_63380;
var statearr_63383_63402 = state_63380__$1;
(statearr_63383_63402[(2)] = inst_63352);

(statearr_63383_63402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (6))){
var inst_63363 = (state_63380[(7)]);
var state_63380__$1 = state_63380;
var statearr_63384_63403 = state_63380__$1;
(statearr_63384_63403[(2)] = inst_63363);

(statearr_63384_63403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (3))){
var inst_63378 = (state_63380[(2)]);
var state_63380__$1 = state_63380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63380__$1,inst_63378);
} else {
if((state_val_63381 === (2))){
var inst_63363 = (state_63380[(7)]);
var _ = (function (){var statearr_63386 = state_63380;
(statearr_63386[(4)] = cljs.core.cons((5),(state_63380[(4)])));

return statearr_63386;
})();
var inst_63358 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63360 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63361 = [inst_63360,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_63362 = (new cljs.core.PersistentVector(null,3,(5),inst_63359,inst_63361,null));
var inst_63363__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63358,inst_63362);
var state_63380__$1 = (function (){var statearr_63387 = state_63380;
(statearr_63387[(7)] = inst_63363__$1);

return statearr_63387;
})();
if(cljs.core.truth_(inst_63363__$1)){
var statearr_63388_63404 = state_63380__$1;
(statearr_63388_63404[(1)] = (6));

} else {
var statearr_63389_63405 = state_63380__$1;
(statearr_63389_63405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (9))){
var inst_63372 = (state_63380[(2)]);
var inst_63373 = fluree.db.util.async.throw_err(inst_63372);
var state_63380__$1 = state_63380;
var statearr_63390_63406 = state_63380__$1;
(statearr_63390_63406[(2)] = inst_63373);

(statearr_63390_63406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (5))){
var _ = (function (){var statearr_63391 = state_63380;
(statearr_63391[(4)] = cljs.core.rest((state_63380[(4)])));

return statearr_63391;
})();
var state_63380__$1 = state_63380;
var ex63385 = (state_63380__$1[(2)]);
var statearr_63392_63407 = state_63380__$1;
(statearr_63392_63407[(5)] = ex63385);


if((ex63385 instanceof Error)){
var statearr_63393_63408 = state_63380__$1;
(statearr_63393_63408[(1)] = (4));

(statearr_63393_63408[(5)] = null);

} else {
throw ex63385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63381 === (8))){
var inst_63375 = (state_63380[(2)]);
var _ = (function (){var statearr_63394 = state_63380;
(statearr_63394[(4)] = cljs.core.rest((state_63380[(4)])));

return statearr_63394;
})();
var state_63380__$1 = state_63380;
var statearr_63395_63409 = state_63380__$1;
(statearr_63395_63409[(2)] = inst_63375);

(statearr_63395_63409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2879__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_63396 = [null,null,null,null,null,null,null,null];
(statearr_63396[(0)] = fluree$db$connection$get_socket_$_state_machine__2879__auto__);

(statearr_63396[(1)] = (1));

return statearr_63396;
});
var fluree$db$connection$get_socket_$_state_machine__2879__auto____1 = (function (state_63380){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63380);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63397){var ex__2882__auto__ = e63397;
var statearr_63398_63410 = state_63380;
(statearr_63398_63410[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63380[(4)]))){
var statearr_63399_63411 = state_63380;
(statearr_63399_63411[(1)] = cljs.core.first((state_63380[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63412 = state_63380;
state_63380 = G__63412;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2879__auto__ = function(state_63380){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2879__auto____1.call(this,state_63380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2879__auto____0;
fluree$db$connection$get_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2879__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63400 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63400[(6)] = c__2901__auto__);

return statearr_63400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e63413){var e = e63413;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63560){
var state_val_63561 = (state_63560[(1)]);
if((state_val_63561 === (7))){
var inst_63556 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63563_63646 = state_63560__$1;
(statearr_63563_63646[(2)] = inst_63556);

(statearr_63563_63646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (20))){
var _ = (function (){var statearr_63564 = state_63560;
(statearr_63564[(4)] = cljs.core.rest((state_63560[(4)])));

return statearr_63564;
})();
var state_63560__$1 = state_63560;
var ex63562 = (state_63560__$1[(2)]);
var statearr_63565_63647 = state_63560__$1;
(statearr_63565_63647[(5)] = ex63562);


var statearr_63566_63648 = state_63560__$1;
(statearr_63566_63648[(1)] = (10));

(statearr_63566_63648[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (27))){
var inst_63458 = (state_63560[(7)]);
var inst_63476 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_63458);
var state_63560__$1 = state_63560;
var statearr_63567_63649 = state_63560__$1;
(statearr_63567_63649[(2)] = inst_63476);

(statearr_63567_63649[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (1))){
var inst_63415 = (0);
var state_63560__$1 = (function (){var statearr_63568 = state_63560;
(statearr_63568[(8)] = inst_63415);

return statearr_63568;
})();
var statearr_63569_63650 = state_63560__$1;
(statearr_63569_63650[(2)] = null);

(statearr_63569_63650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (24))){
var state_63560__$1 = state_63560;
var statearr_63570_63651 = state_63560__$1;
(statearr_63570_63651[(2)] = true);

(statearr_63570_63651[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (39))){
var inst_63546 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63571_63652 = state_63560__$1;
(statearr_63571_63652[(2)] = inst_63546);

(statearr_63571_63652[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (4))){
var inst_63418 = (state_63560[(9)]);
var inst_63418__$1 = (state_63560[(2)]);
var state_63560__$1 = (function (){var statearr_63572 = state_63560;
(statearr_63572[(9)] = inst_63418__$1);

return statearr_63572;
})();
if(cljs.core.truth_(inst_63418__$1)){
var statearr_63573_63653 = state_63560__$1;
(statearr_63573_63653[(1)] = (5));

} else {
var statearr_63574_63654 = state_63560__$1;
(statearr_63574_63654[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (15))){
var inst_63431 = (state_63560[(10)]);
var state_63560__$1 = state_63560;
var statearr_63575_63655 = state_63560__$1;
(statearr_63575_63655[(2)] = inst_63431);

(statearr_63575_63655[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (21))){
var inst_63458 = (state_63560[(7)]);
var inst_63463 = inst_63458.cljs$lang$protocol_mask$partition0$;
var inst_63464 = (inst_63463 & (64));
var inst_63465 = inst_63458.cljs$core$ISeq$;
var inst_63466 = (cljs.core.PROTOCOL_SENTINEL === inst_63465);
var inst_63467 = ((inst_63464) || (inst_63466));
var state_63560__$1 = state_63560;
if(cljs.core.truth_(inst_63467)){
var statearr_63576_63656 = state_63560__$1;
(statearr_63576_63656[(1)] = (24));

} else {
var statearr_63577_63657 = state_63560__$1;
(statearr_63577_63657[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (31))){
var state_63560__$1 = state_63560;
var statearr_63578_63658 = state_63560__$1;
(statearr_63578_63658[(2)] = null);

(statearr_63578_63658[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (32))){
var inst_63455 = (state_63560[(11)]);
var inst_63482 = (state_63560[(12)]);
var inst_63456 = (state_63560[(13)]);
var inst_63520 = (state_63560[(2)]);
var inst_63521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63522 = [inst_63455,inst_63482,inst_63456];
var inst_63523 = (new cljs.core.PersistentVector(null,3,(5),inst_63521,inst_63522,null));
var inst_63524 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_63523) : publish_fn.call(null,conn,inst_63523));
var state_63560__$1 = (function (){var statearr_63579 = state_63560;
(statearr_63579[(14)] = inst_63520);

return statearr_63579;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63560__$1,(33),inst_63524);
} else {
if((state_val_63561 === (40))){
var inst_63536 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_63560__$1 = state_63560;
var statearr_63580_63659 = state_63560__$1;
(statearr_63580_63659[(2)] = inst_63536);

(statearr_63580_63659[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (33))){
var inst_63526 = (state_63560[(15)]);
var inst_63526__$1 = (state_63560[(2)]);
var inst_63527 = inst_63526__$1 === true;
var state_63560__$1 = (function (){var statearr_63581 = state_63560;
(statearr_63581[(15)] = inst_63526__$1);

return statearr_63581;
})();
if(cljs.core.truth_(inst_63527)){
var statearr_63582_63660 = state_63560__$1;
(statearr_63582_63660[(1)] = (34));

} else {
var statearr_63583_63661 = state_63560__$1;
(statearr_63583_63661[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (13))){
var inst_63431 = (state_63560[(10)]);
var inst_63428 = (state_63560[(2)]);
var inst_63429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63428,(0),null);
var inst_63430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63428,(1),null);
var inst_63431__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63428,(2),null);
var state_63560__$1 = (function (){var statearr_63584 = state_63560;
(statearr_63584[(16)] = inst_63430);

(statearr_63584[(10)] = inst_63431__$1);

(statearr_63584[(17)] = inst_63429);

return statearr_63584;
})();
if(cljs.core.truth_(inst_63431__$1)){
var statearr_63585_63662 = state_63560__$1;
(statearr_63585_63662[(1)] = (14));

} else {
var statearr_63586_63663 = state_63560__$1;
(statearr_63586_63663[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (22))){
var state_63560__$1 = state_63560;
var statearr_63587_63664 = state_63560__$1;
(statearr_63587_63664[(2)] = false);

(statearr_63587_63664[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (36))){
var inst_63548 = (state_63560[(2)]);
var _ = (function (){var statearr_63588 = state_63560;
(statearr_63588[(4)] = cljs.core.rest((state_63560[(4)])));

return statearr_63588;
})();
var state_63560__$1 = state_63560;
var statearr_63589_63665 = state_63560__$1;
(statearr_63589_63665[(2)] = inst_63548);

(statearr_63589_63665[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (41))){
var state_63560__$1 = state_63560;
var statearr_63590_63666 = state_63560__$1;
(statearr_63590_63666[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (43))){
var inst_63526 = (state_63560[(15)]);
var inst_63539 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_63526], 0));
var state_63560__$1 = state_63560;
var statearr_63592_63667 = state_63560__$1;
(statearr_63592_63667[(2)] = inst_63539);

(statearr_63592_63667[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (29))){
var inst_63479 = (state_63560[(18)]);
var inst_63457 = (state_63560[(19)]);
var inst_63479__$1 = (state_63560[(2)]);
var inst_63480 = fluree.db.util.core.random_uuid();
var inst_63481 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63480);
var inst_63482 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63479__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_63481);
var inst_63483 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63479__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_63560__$1 = (function (){var statearr_63593 = state_63560;
(statearr_63593[(20)] = inst_63483);

(statearr_63593[(18)] = inst_63479__$1);

(statearr_63593[(12)] = inst_63482);

return statearr_63593;
})();
if(cljs.core.truth_(inst_63457)){
var statearr_63594_63668 = state_63560__$1;
(statearr_63594_63668[(1)] = (30));

} else {
var statearr_63595_63669 = state_63560__$1;
(statearr_63595_63669[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (44))){
var state_63560__$1 = state_63560;
var statearr_63596_63670 = state_63560__$1;
(statearr_63596_63670[(2)] = null);

(statearr_63596_63670[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (6))){
var state_63560__$1 = state_63560;
var statearr_63597_63671 = state_63560__$1;
(statearr_63597_63671[(2)] = null);

(statearr_63597_63671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (28))){
var inst_63458 = (state_63560[(7)]);
var state_63560__$1 = state_63560;
var statearr_63598_63672 = state_63560__$1;
(statearr_63598_63672[(2)] = inst_63458);

(statearr_63598_63672[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (25))){
var state_63560__$1 = state_63560;
var statearr_63599_63673 = state_63560__$1;
(statearr_63599_63673[(2)] = false);

(statearr_63599_63673[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (34))){
var state_63560__$1 = state_63560;
var statearr_63600_63674 = state_63560__$1;
(statearr_63600_63674[(2)] = null);

(statearr_63600_63674[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (17))){
var inst_63431 = (state_63560[(10)]);
var inst_63420 = (state_63560[(21)]);
var inst_63438 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63431,inst_63420);
var state_63560__$1 = state_63560;
var statearr_63601_63675 = state_63560__$1;
(statearr_63601_63675[(2)] = inst_63438);

(statearr_63601_63675[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (3))){
var inst_63558 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63560__$1,inst_63558);
} else {
if((state_val_63561 === (12))){
var state_63560__$1 = state_63560;
var statearr_63602_63676 = state_63560__$1;
(statearr_63602_63676[(2)] = null);

(statearr_63602_63676[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (2))){
var state_63560__$1 = state_63560;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63560__$1,(4),req_chan);
} else {
if((state_val_63561 === (23))){
var inst_63474 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
if(cljs.core.truth_(inst_63474)){
var statearr_63603_63677 = state_63560__$1;
(statearr_63603_63677[(1)] = (27));

} else {
var statearr_63604_63678 = state_63560__$1;
(statearr_63604_63678[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (35))){
var inst_63526 = (state_63560[(15)]);
var inst_63530 = fluree.db.util.core.exception_QMARK_(inst_63526);
var state_63560__$1 = state_63560;
if(inst_63530){
var statearr_63605_63679 = state_63560__$1;
(statearr_63605_63679[(1)] = (37));

} else {
var statearr_63606_63680 = state_63560__$1;
(statearr_63606_63680[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (19))){
var inst_63444 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63607_63681 = state_63560__$1;
(statearr_63607_63681[(2)] = inst_63444);

(statearr_63607_63681[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (11))){
var inst_63418 = (state_63560[(9)]);
var state_63560__$1 = state_63560;
var statearr_63608_63682 = state_63560__$1;
(statearr_63608_63682[(2)] = inst_63418);

(statearr_63608_63682[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (9))){
var inst_63415 = (state_63560[(8)]);
var inst_63551 = (state_63560[(2)]);
var inst_63552 = (inst_63415 + (1));
var inst_63415__$1 = inst_63552;
var state_63560__$1 = (function (){var statearr_63609 = state_63560;
(statearr_63609[(8)] = inst_63415__$1);

(statearr_63609[(22)] = inst_63551);

return statearr_63609;
})();
var statearr_63610_63683 = state_63560__$1;
(statearr_63610_63683[(2)] = null);

(statearr_63610_63683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (5))){
var state_63560__$1 = state_63560;
var statearr_63611_63684 = state_63560__$1;
(statearr_63611_63684[(2)] = null);

(statearr_63611_63684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (14))){
var inst_63431 = (state_63560[(10)]);
var inst_63433 = fluree.db.util.async.channel_QMARK_(inst_63431);
var state_63560__$1 = state_63560;
var statearr_63612_63685 = state_63560__$1;
(statearr_63612_63685[(2)] = inst_63433);

(statearr_63612_63685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (45))){
var inst_63542 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63613_63686 = state_63560__$1;
(statearr_63613_63686[(2)] = inst_63542);

(statearr_63613_63686[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (26))){
var inst_63471 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63614_63687 = state_63560__$1;
(statearr_63614_63687[(2)] = inst_63471);

(statearr_63614_63687[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (16))){
var inst_63436 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
if(cljs.core.truth_(inst_63436)){
var statearr_63615_63688 = state_63560__$1;
(statearr_63615_63688[(1)] = (17));

} else {
var statearr_63616_63689 = state_63560__$1;
(statearr_63616_63689[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (38))){
var inst_63526 = (state_63560[(15)]);
var inst_63534 = (inst_63526 == null);
var state_63560__$1 = state_63560;
if(cljs.core.truth_(inst_63534)){
var statearr_63617_63690 = state_63560__$1;
(statearr_63617_63690[(1)] = (40));

} else {
var statearr_63618_63691 = state_63560__$1;
(statearr_63618_63691[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (30))){
var inst_63415 = (state_63560[(8)]);
var inst_63454 = (state_63560[(23)]);
var inst_63483 = (state_63560[(20)]);
var inst_63418 = (state_63560[(9)]);
var inst_63479 = (state_63560[(18)]);
var inst_63458 = (state_63560[(7)]);
var inst_63455 = (state_63560[(11)]);
var inst_63457 = (state_63560[(19)]);
var inst_63482 = (state_63560[(12)]);
var inst_63456 = (state_63560[(13)]);
var inst_63485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63486 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_63482];
var inst_63487 = (new cljs.core.PersistentVector(null,2,(5),inst_63485,inst_63486,null));
var inst_63488 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_63487,inst_63457);
var inst_63515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_63516 = (function (){var resp_chan = inst_63457;
var timeout = inst_63483;
var i = inst_63415;
var data = inst_63456;
var map__63453 = inst_63479;
var c__2901__auto____$1 = inst_63515;
var vec__63450 = inst_63418;
var _ = inst_63454;
var req_id = inst_63482;
var operation = inst_63455;
var msg = inst_63418;
var opts = inst_63458;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63513){
var state_val_63514 = (state_63513[(1)]);
if((state_val_63514 === (1))){
var inst_63492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63493 = cljs.core.async.timeout(timeout);
var inst_63494 = [resp_chan,inst_63493];
var inst_63495 = (new cljs.core.PersistentVector(null,2,(5),inst_63492,inst_63494,null));
var state_63513__$1 = state_63513;
return cljs.core.async.ioc_alts_BANG_(state_63513__$1,(2),inst_63495);
} else {
if((state_val_63514 === (2))){
var inst_63498 = (state_63513[(7)]);
var inst_63497 = (state_63513[(2)]);
var inst_63498__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63497,(0),null);
var inst_63499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63497,(1),null);
var inst_63500 = (function (){var vec__63489 = inst_63497;
var resp = inst_63498__$1;
var c = inst_63499;
return (function (p1__63414_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__63414_SHARP_,req_id);
});
})();
var inst_63501 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_63500);
var inst_63502 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63499,resp_chan);
var state_63513__$1 = (function (){var statearr_63619 = state_63513;
(statearr_63619[(7)] = inst_63498__$1);

(statearr_63619[(8)] = inst_63501);

return statearr_63619;
})();
if(inst_63502){
var statearr_63620_63692 = state_63513__$1;
(statearr_63620_63692[(1)] = (3));

} else {
var statearr_63621_63693 = state_63513__$1;
(statearr_63621_63693[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63514 === (3))){
var inst_63498 = (state_63513[(7)]);
var state_63513__$1 = state_63513;
var statearr_63622_63694 = state_63513__$1;
(statearr_63622_63694[(2)] = inst_63498);

(statearr_63622_63694[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63514 === (4))){
var inst_63505 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_63506 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63507 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63508 = cljs.core.PersistentHashMap.fromArrays(inst_63506,inst_63507);
var inst_63509 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63505,inst_63508);
var state_63513__$1 = state_63513;
var statearr_63623_63695 = state_63513__$1;
(statearr_63623_63695[(2)] = inst_63509);

(statearr_63623_63695[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63514 === (5))){
var inst_63511 = (state_63513[(2)]);
var state_63513__$1 = state_63513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63513__$1,inst_63511);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____0 = (function (){
var statearr_63624 = [null,null,null,null,null,null,null,null,null];
(statearr_63624[(0)] = fluree$db$connection$msg_producer_$_state_machine__2879__auto__);

(statearr_63624[(1)] = (1));

return statearr_63624;
});
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____1 = (function (state_63513){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63513);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63625){var ex__2882__auto__ = e63625;
var statearr_63626_63696 = state_63513;
(statearr_63626_63696[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63513[(4)]))){
var statearr_63627_63697 = state_63513;
(statearr_63627_63697[(1)] = cljs.core.first((state_63513[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63698 = state_63513;
state_63513 = G__63698;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = function(state_63513){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____1.call(this,state_63513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63628 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63628[(6)] = c__2901__auto____$1);

return statearr_63628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});
})();
var inst_63517 = cljs.core.async.impl.dispatch.run(inst_63516);
var state_63560__$1 = (function (){var statearr_63629 = state_63560;
(statearr_63629[(24)] = inst_63488);

(statearr_63629[(25)] = inst_63517);

return statearr_63629;
})();
var statearr_63630_63699 = state_63560__$1;
(statearr_63630_63699[(2)] = inst_63515);

(statearr_63630_63699[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (10))){
var inst_63418 = (state_63560[(9)]);
var inst_63420 = (state_63560[(2)]);
var inst_63424 = cljs.core.sequential_QMARK_(inst_63418);
var state_63560__$1 = (function (){var statearr_63631 = state_63560;
(statearr_63631[(21)] = inst_63420);

return statearr_63631;
})();
if(inst_63424){
var statearr_63632_63700 = state_63560__$1;
(statearr_63632_63700[(1)] = (11));

} else {
var statearr_63633_63701 = state_63560__$1;
(statearr_63633_63701[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (18))){
var inst_63418 = (state_63560[(9)]);
var inst_63420 = (state_63560[(21)]);
var inst_63440 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63418], 0));
var inst_63441 = ["Error processing ledger request, no valid return channel: ",inst_63440].join('');
var inst_63442 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63420,inst_63441], 0));
var state_63560__$1 = state_63560;
var statearr_63634_63702 = state_63560__$1;
(statearr_63634_63702[(2)] = inst_63442);

(statearr_63634_63702[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (42))){
var inst_63544 = (state_63560[(2)]);
var state_63560__$1 = state_63560;
var statearr_63635_63703 = state_63560__$1;
(statearr_63635_63703[(2)] = inst_63544);

(statearr_63635_63703[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (37))){
var inst_63526 = (state_63560[(15)]);
var inst_63532 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63526,"Error processing message in producer."], 0));
var state_63560__$1 = state_63560;
var statearr_63636_63704 = state_63560__$1;
(statearr_63636_63704[(2)] = inst_63532);

(statearr_63636_63704[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63561 === (8))){
var inst_63418 = (state_63560[(9)]);
var inst_63458 = (state_63560[(7)]);
var _ = (function (){var statearr_63637 = state_63560;
(statearr_63637[(4)] = cljs.core.cons((20),(state_63560[(4)])));

return statearr_63637;
})();
var inst_63454 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_63418], 0));
var inst_63455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63418,(0),null);
var inst_63456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63418,(1),null);
var inst_63457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63418,(2),null);
var inst_63458__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63418,(3),null);
var inst_63460 = (inst_63458__$1 == null);
var inst_63461 = cljs.core.not(inst_63460);
var state_63560__$1 = (function (){var statearr_63638 = state_63560;
(statearr_63638[(23)] = inst_63454);

(statearr_63638[(7)] = inst_63458__$1);

(statearr_63638[(11)] = inst_63455);

(statearr_63638[(19)] = inst_63457);

(statearr_63638[(13)] = inst_63456);

return statearr_63638;
})();
if(inst_63461){
var statearr_63639_63705 = state_63560__$1;
(statearr_63639_63705[(1)] = (21));

} else {
var statearr_63640_63706 = state_63560__$1;
(statearr_63640_63706[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____0 = (function (){
var statearr_63641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63641[(0)] = fluree$db$connection$msg_producer_$_state_machine__2879__auto__);

(statearr_63641[(1)] = (1));

return statearr_63641;
});
var fluree$db$connection$msg_producer_$_state_machine__2879__auto____1 = (function (state_63560){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63560);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63642){var ex__2882__auto__ = e63642;
var statearr_63643_63707 = state_63560;
(statearr_63643_63707[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63560[(4)]))){
var statearr_63644_63708 = state_63560;
(statearr_63644_63708[(1)] = cljs.core.first((state_63560[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63709 = state_63560;
state_63560 = G__63709;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2879__auto__ = function(state_63560){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2879__auto____1.call(this,state_63560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63645 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63645[(6)] = c__2901__auto__);

return statearr_63645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63710 = conn;
var map__63710__$1 = (((((!((map__63710 == null))))?(((((map__63710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63710):map__63710);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63710__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63793){
var state_val_63794 = (state_63793[(1)]);
if((state_val_63794 === (7))){
var inst_63789 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63795_63846 = state_63793__$1;
(statearr_63795_63846[(2)] = inst_63789);

(statearr_63795_63846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (20))){
var inst_63730 = (state_63793[(7)]);
var inst_63744 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63745 = [inst_63730];
var inst_63746 = cljs.core.PersistentHashMap.fromArrays(inst_63744,inst_63745);
var inst_63747 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63746], 0));
var state_63793__$1 = state_63793;
var statearr_63796_63847 = state_63793__$1;
(statearr_63796_63847[(2)] = inst_63747);

(statearr_63796_63847[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (27))){
var state_63793__$1 = state_63793;
var statearr_63797_63848 = state_63793__$1;
(statearr_63797_63848[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (1))){
var inst_63712 = (0);
var state_63793__$1 = (function (){var statearr_63799 = state_63793;
(statearr_63799[(8)] = inst_63712);

return statearr_63799;
})();
var statearr_63800_63849 = state_63793__$1;
(statearr_63800_63849[(2)] = null);

(statearr_63800_63849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (24))){
var inst_63723 = (state_63793[(9)]);
var inst_63772 = fluree.db.util.core.exception_QMARK_(inst_63723);
var state_63793__$1 = state_63793;
if(inst_63772){
var statearr_63801_63850 = state_63793__$1;
(statearr_63801_63850[(1)] = (26));

} else {
var statearr_63802_63851 = state_63793__$1;
(statearr_63802_63851[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (4))){
var inst_63717 = (state_63793[(10)]);
var inst_63722 = (state_63793[(2)]);
var inst_63723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63722,(0),null);
var inst_63724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63722,(1),null);
var inst_63725 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63724,inst_63717);
var state_63793__$1 = (function (){var statearr_63803 = state_63793;
(statearr_63803[(9)] = inst_63723);

return statearr_63803;
})();
if(inst_63725){
var statearr_63804_63852 = state_63793__$1;
(statearr_63804_63852[(1)] = (5));

} else {
var statearr_63805_63853 = state_63793__$1;
(statearr_63805_63853[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (15))){
var inst_63730 = (state_63793[(7)]);
var inst_63739 = typeof inst_63730 === 'string';
var state_63793__$1 = state_63793;
if(cljs.core.truth_(inst_63739)){
var statearr_63806_63854 = state_63793__$1;
(statearr_63806_63854[(1)] = (17));

} else {
var statearr_63807_63855 = state_63793__$1;
(statearr_63807_63855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (21))){
var state_63793__$1 = state_63793;
var statearr_63808_63856 = state_63793__$1;
(statearr_63808_63856[(2)] = null);

(statearr_63808_63856[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (31))){
var inst_63783 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63809_63857 = state_63793__$1;
(statearr_63809_63857[(2)] = inst_63783);

(statearr_63809_63857[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (13))){
var inst_63756 = (state_63793[(2)]);
var inst_63757 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63758 = fluree.db.connection.close_websocket(inst_63757);
var inst_63759 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63760 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63759);
var state_63793__$1 = (function (){var statearr_63810 = state_63793;
(statearr_63810[(11)] = inst_63756);

(statearr_63810[(12)] = inst_63758);

return statearr_63810;
})();
var statearr_63811_63858 = state_63793__$1;
(statearr_63811_63858[(2)] = inst_63760);

(statearr_63811_63858[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (22))){
var inst_63750 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63812_63859 = state_63793__$1;
(statearr_63812_63859[(2)] = inst_63750);

(statearr_63812_63859[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (29))){
var inst_63723 = (state_63793[(9)]);
var inst_63778 = fluree.db.util.json.parse(inst_63723);
var inst_63779 = fluree.db.conn_events.process_events(conn,inst_63778);
var inst_63712 = (0);
var state_63793__$1 = (function (){var statearr_63813 = state_63793;
(statearr_63813[(8)] = inst_63712);

(statearr_63813[(13)] = inst_63779);

return statearr_63813;
})();
var statearr_63814_63860 = state_63793__$1;
(statearr_63814_63860[(2)] = null);

(statearr_63814_63860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (6))){
var inst_63723 = (state_63793[(9)]);
var inst_63768 = (inst_63723 == null);
var state_63793__$1 = state_63793;
if(cljs.core.truth_(inst_63768)){
var statearr_63815_63861 = state_63793__$1;
(statearr_63815_63861[(1)] = (23));

} else {
var statearr_63816_63862 = state_63793__$1;
(statearr_63816_63862[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (28))){
var inst_63785 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63817_63863 = state_63793__$1;
(statearr_63817_63863[(2)] = inst_63785);

(statearr_63817_63863[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (25))){
var inst_63787 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63818_63864 = state_63793__$1;
(statearr_63818_63864[(2)] = inst_63787);

(statearr_63818_63864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (17))){
var inst_63730 = (state_63793[(7)]);
var inst_63741 = cljs.core.eval(inst_63730);
var state_63793__$1 = state_63793;
var statearr_63819_63865 = state_63793__$1;
(statearr_63819_63865[(2)] = inst_63741);

(statearr_63819_63865[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (3))){
var inst_63791 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63793__$1,inst_63791);
} else {
if((state_val_63794 === (12))){
var inst_63730 = (state_63793[(7)]);
var inst_63735 = cljs.core.fn_QMARK_(inst_63730);
var state_63793__$1 = state_63793;
if(inst_63735){
var statearr_63820_63866 = state_63793__$1;
(statearr_63820_63866[(1)] = (14));

} else {
var statearr_63821_63867 = state_63793__$1;
(statearr_63821_63867[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (2))){
var inst_63717 = (state_63793[(10)]);
var inst_63717__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63719 = [sub_chan,inst_63717__$1];
var inst_63720 = (new cljs.core.PersistentVector(null,2,(5),inst_63718,inst_63719,null));
var state_63793__$1 = (function (){var statearr_63822 = state_63793;
(statearr_63822[(10)] = inst_63717__$1);

return statearr_63822;
})();
return cljs.core.async.ioc_alts_BANG_(state_63793__$1,(4),inst_63720);
} else {
if((state_val_63794 === (23))){
var inst_63770 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63793__$1 = state_63793;
var statearr_63823_63868 = state_63793__$1;
(statearr_63823_63868[(2)] = inst_63770);

(statearr_63823_63868[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (19))){
var inst_63752 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63824_63869 = state_63793__$1;
(statearr_63824_63869[(2)] = inst_63752);

(statearr_63824_63869[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (11))){
var inst_63733 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63793__$1 = state_63793;
var statearr_63825_63870 = state_63793__$1;
(statearr_63825_63870[(2)] = inst_63733);

(statearr_63825_63870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (9))){
var inst_63712 = (state_63793[(8)]);
var inst_63762 = fluree.db.connection.ping_transactor(conn);
var inst_63763 = (inst_63712 + (1));
var inst_63712__$1 = inst_63763;
var state_63793__$1 = (function (){var statearr_63826 = state_63793;
(statearr_63826[(14)] = inst_63762);

(statearr_63826[(8)] = inst_63712__$1);

return statearr_63826;
})();
var statearr_63827_63871 = state_63793__$1;
(statearr_63827_63871[(2)] = null);

(statearr_63827_63871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (5))){
var inst_63712 = (state_63793[(8)]);
var inst_63727 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63712);
var state_63793__$1 = state_63793;
if(inst_63727){
var statearr_63828_63872 = state_63793__$1;
(statearr_63828_63872[(1)] = (8));

} else {
var statearr_63829_63873 = state_63793__$1;
(statearr_63829_63873[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (14))){
var inst_63730 = (state_63793[(7)]);
var inst_63737 = (inst_63730.cljs$core$IFn$_invoke$arity$0 ? inst_63730.cljs$core$IFn$_invoke$arity$0() : inst_63730.call(null));
var state_63793__$1 = state_63793;
var statearr_63830_63874 = state_63793__$1;
(statearr_63830_63874[(2)] = inst_63737);

(statearr_63830_63874[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (26))){
var inst_63723 = (state_63793[(9)]);
var inst_63774 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63723], 0));
var inst_63712 = (0);
var state_63793__$1 = (function (){var statearr_63831 = state_63793;
(statearr_63831[(8)] = inst_63712);

(statearr_63831[(15)] = inst_63774);

return statearr_63831;
})();
var statearr_63832_63875 = state_63793__$1;
(statearr_63832_63875[(2)] = null);

(statearr_63832_63875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (16))){
var inst_63754 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63833_63876 = state_63793__$1;
(statearr_63833_63876[(2)] = inst_63754);

(statearr_63833_63876[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (30))){
var state_63793__$1 = state_63793;
var statearr_63834_63877 = state_63793__$1;
(statearr_63834_63877[(2)] = null);

(statearr_63834_63877[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (10))){
var inst_63766 = (state_63793[(2)]);
var state_63793__$1 = state_63793;
var statearr_63835_63878 = state_63793__$1;
(statearr_63835_63878[(2)] = inst_63766);

(statearr_63835_63878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (18))){
var state_63793__$1 = state_63793;
var statearr_63836_63879 = state_63793__$1;
(statearr_63836_63879[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63794 === (8))){
var inst_63730 = (state_63793[(7)]);
var inst_63729 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63730__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63731 = (inst_63730__$1 == null);
var state_63793__$1 = (function (){var statearr_63838 = state_63793;
(statearr_63838[(7)] = inst_63730__$1);

(statearr_63838[(16)] = inst_63729);

return statearr_63838;
})();
if(cljs.core.truth_(inst_63731)){
var statearr_63839_63880 = state_63793__$1;
(statearr_63839_63880[(1)] = (11));

} else {
var statearr_63840_63881 = state_63793__$1;
(statearr_63840_63881[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0 = (function (){
var statearr_63841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63841[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2879__auto__);

(statearr_63841[(1)] = (1));

return statearr_63841;
});
var fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1 = (function (state_63793){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63793);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63842){var ex__2882__auto__ = e63842;
var statearr_63843_63882 = state_63793;
(statearr_63843_63882[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63793[(4)]))){
var statearr_63844_63883 = state_63793;
(statearr_63844_63883[(1)] = cljs.core.first((state_63793[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63884 = state_63793;
state_63793 = G__63884;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__ = function(state_63793){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1.call(this,state_63793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2879__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2879__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63845 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63845[(6)] = c__2901__auto__);

return statearr_63845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63886 = arguments.length;
switch (G__63886) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63887 = opts;
var map__63887__$1 = (((((!((map__63887 == null))))?(((((map__63887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63887):map__63887);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63887__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63887__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63950){
var state_val_63951 = (state_63950[(1)]);
if((state_val_63951 === (7))){
var inst_63898 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63900 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63901 = (new cljs.core.PersistentVector(null,2,(5),inst_63899,inst_63900,null));
var inst_63902 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63898,inst_63901);
var state_63950__$1 = state_63950;
var statearr_63952_63993 = state_63950__$1;
(statearr_63952_63993[(2)] = inst_63902);

(statearr_63952_63993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (20))){
var inst_63929 = (state_63950[(7)]);
var state_63950__$1 = state_63950;
var statearr_63953_63994 = state_63950__$1;
(statearr_63953_63994[(2)] = inst_63929);

(statearr_63953_63994[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (1))){
var state_63950__$1 = state_63950;
var statearr_63954_63995 = state_63950__$1;
(statearr_63954_63995[(2)] = null);

(statearr_63954_63995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (4))){
var inst_63889 = (state_63950[(2)]);
var state_63950__$1 = state_63950;
var statearr_63955_63996 = state_63950__$1;
(statearr_63955_63996[(2)] = inst_63889);

(statearr_63955_63996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (15))){
var inst_63904 = (state_63950[(8)]);
var inst_63923 = (state_63950[(2)]);
var state_63950__$1 = (function (){var statearr_63956 = state_63950;
(statearr_63956[(9)] = inst_63923);

return statearr_63956;
})();
if(cljs.core.truth_(inst_63904)){
var statearr_63957_63997 = state_63950__$1;
(statearr_63957_63997[(1)] = (16));

} else {
var statearr_63958_63998 = state_63950__$1;
(statearr_63958_63998[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (21))){
var inst_63909 = (state_63950[(10)]);
var inst_63938 = (state_63950[(2)]);
var inst_63939 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63940 = [(5000),inst_63938,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_63941 = cljs.core.PersistentHashMap.fromArrays(inst_63939,inst_63940);
var inst_63942 = fluree.db.util.xhttp.get(inst_63909,inst_63941);
var state_63950__$1 = state_63950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63950__$1,(22),inst_63942);
} else {
if((state_val_63951 === (13))){
var inst_63904 = (state_63950[(8)]);
var inst_63918 = (state_63950[(11)]);
var inst_63920 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63918,"X-fdb-jwt",inst_63904);
var state_63950__$1 = state_63950;
var statearr_63959_63999 = state_63950__$1;
(statearr_63959_63999[(2)] = inst_63920);

(statearr_63959_63999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (22))){
var inst_63944 = (state_63950[(2)]);
var inst_63945 = fluree.db.util.async.throw_err(inst_63944);
var _ = (function (){var statearr_63960 = state_63950;
(statearr_63960[(4)] = cljs.core.rest((state_63950[(4)])));

return statearr_63960;
})();
var state_63950__$1 = state_63950;
var statearr_63961_64000 = state_63950__$1;
(statearr_63961_64000[(2)] = inst_63945);

(statearr_63961_64000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (6))){
var inst_63895 = (state_63950[(12)]);
var state_63950__$1 = state_63950;
var statearr_63962_64001 = state_63950__$1;
(statearr_63962_64001[(2)] = inst_63895);

(statearr_63962_64001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (17))){
var inst_63923 = (state_63950[(9)]);
var state_63950__$1 = state_63950;
var statearr_63963_64002 = state_63950__$1;
(statearr_63963_64002[(2)] = inst_63923);

(statearr_63963_64002[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (3))){
var inst_63948 = (state_63950[(2)]);
var state_63950__$1 = state_63950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63950__$1,inst_63948);
} else {
if((state_val_63951 === (12))){
var inst_63904 = (state_63950[(8)]);
var inst_63918 = (state_63950[(2)]);
var state_63950__$1 = (function (){var statearr_63964 = state_63950;
(statearr_63964[(11)] = inst_63918);

return statearr_63964;
})();
if(cljs.core.truth_(inst_63904)){
var statearr_63965_64003 = state_63950__$1;
(statearr_63965_64003[(1)] = (13));

} else {
var statearr_63966_64004 = state_63950__$1;
(statearr_63966_64004[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (2))){
var inst_63895 = (state_63950[(12)]);
var _ = (function (){var statearr_63967 = state_63950;
(statearr_63967[(4)] = cljs.core.cons((5),(state_63950[(4)])));

return statearr_63967;
})();
var inst_63895__$1 = jwt;
var state_63950__$1 = (function (){var statearr_63968 = state_63950;
(statearr_63968[(12)] = inst_63895__$1);

return statearr_63968;
})();
if(cljs.core.truth_(inst_63895__$1)){
var statearr_63969_64005 = state_63950__$1;
(statearr_63969_64005[(1)] = (6));

} else {
var statearr_63970_64006 = state_63950__$1;
(statearr_63970_64006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (19))){
var inst_63929 = (state_63950[(7)]);
var inst_63909 = (state_63950[(10)]);
var inst_63931 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63932 = [inst_63929];
var inst_63933 = cljs.core.PersistentHashMap.fromArrays(inst_63931,inst_63932);
var inst_63934 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63909,inst_63933,private$);
var inst_63935 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63934);
var state_63950__$1 = state_63950;
var statearr_63971_64007 = state_63950__$1;
(statearr_63971_64007[(2)] = inst_63935);

(statearr_63971_64007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (11))){
var inst_63913 = (state_63950[(13)]);
var state_63950__$1 = state_63950;
var statearr_63973_64008 = state_63950__$1;
(statearr_63973_64008[(2)] = inst_63913);

(statearr_63973_64008[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (9))){
var inst_63905 = (state_63950[(14)]);
var inst_63908 = (state_63950[(2)]);
var inst_63909 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63908),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63905)].join('');
var inst_63911 = ["Accept"];
var inst_63912 = ["application/json"];
var inst_63913 = cljs.core.PersistentHashMap.fromArrays(inst_63911,inst_63912);
var state_63950__$1 = (function (){var statearr_63974 = state_63950;
(statearr_63974[(13)] = inst_63913);

(statearr_63974[(10)] = inst_63909);

return statearr_63974;
})();
if(cljs.core.truth_(private$)){
var statearr_63975_64009 = state_63950__$1;
(statearr_63975_64009[(1)] = (10));

} else {
var statearr_63976_64010 = state_63950__$1;
(statearr_63976_64010[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (5))){
var _ = (function (){var statearr_63977 = state_63950;
(statearr_63977[(4)] = cljs.core.rest((state_63950[(4)])));

return statearr_63977;
})();
var state_63950__$1 = state_63950;
var ex63972 = (state_63950__$1[(2)]);
var statearr_63978_64011 = state_63950__$1;
(statearr_63978_64011[(5)] = ex63972);


if((ex63972 instanceof Error)){
var statearr_63979_64012 = state_63950__$1;
(statearr_63979_64012[(1)] = (4));

(statearr_63979_64012[(5)] = null);

} else {
throw ex63972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (14))){
var inst_63918 = (state_63950[(11)]);
var state_63950__$1 = state_63950;
var statearr_63980_64013 = state_63950__$1;
(statearr_63980_64013[(2)] = inst_63918);

(statearr_63980_64013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (16))){
var inst_63904 = (state_63950[(8)]);
var inst_63923 = (state_63950[(9)]);
var inst_63925 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63904)].join('');
var inst_63926 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63923,"Authorization",inst_63925);
var state_63950__$1 = state_63950;
var statearr_63981_64014 = state_63950__$1;
(statearr_63981_64014[(2)] = inst_63926);

(statearr_63981_64014[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (10))){
var inst_63913 = (state_63950[(13)]);
var inst_63915 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63913,"X-fdb-pri",private$);
var state_63950__$1 = state_63950;
var statearr_63982_64015 = state_63950__$1;
(statearr_63982_64015[(2)] = inst_63915);

(statearr_63982_64015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (18))){
var inst_63929 = (state_63950[(2)]);
var state_63950__$1 = (function (){var statearr_63983 = state_63950;
(statearr_63983[(7)] = inst_63929);

return statearr_63983;
})();
if(cljs.core.truth_(private$)){
var statearr_63984_64016 = state_63950__$1;
(statearr_63984_64016[(1)] = (19));

} else {
var statearr_63985_64017 = state_63950__$1;
(statearr_63985_64017[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63951 === (8))){
var inst_63904 = (state_63950[(2)]);
var inst_63905 = clojure.string.replace(k,"_","/");
var inst_63906 = fluree.db.connection.get_server(conn_id,servers);
var state_63950__$1 = (function (){var statearr_63986 = state_63950;
(statearr_63986[(14)] = inst_63905);

(statearr_63986[(8)] = inst_63904);

return statearr_63986;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63950__$1,(9),inst_63906);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2879__auto__ = null;
var fluree$db$connection$state_machine__2879__auto____0 = (function (){
var statearr_63987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63987[(0)] = fluree$db$connection$state_machine__2879__auto__);

(statearr_63987[(1)] = (1));

return statearr_63987;
});
var fluree$db$connection$state_machine__2879__auto____1 = (function (state_63950){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_63950);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63988){var ex__2882__auto__ = e63988;
var statearr_63989_64018 = state_63950;
(statearr_63989_64018[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_63950[(4)]))){
var statearr_63990_64019 = state_63950;
(statearr_63990_64019[(1)] = cljs.core.first((state_63950[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64020 = state_63950;
state_63950 = G__64020;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2879__auto__ = function(state_63950){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2879__auto____1.call(this,state_63950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2879__auto____0;
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2879__auto____1;
return fluree$db$connection$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63991 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_63991[(6)] = c__2901__auto__);

return statearr_63991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__64021_SHARP_){
if(cljs.core.truth_(p1__64021_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__64022 = opts;
var map__64022__$1 = (((((!((map__64022 == null))))?(((((map__64022.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64022.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64022):map__64022);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__64022__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64022__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e64024){var _ = e64024;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__64025_64026 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__64025_64026.cljs$core$IFn$_invoke$arity$0 ? fexpr__64025_64026.cljs$core$IFn$_invoke$arity$0() : fexpr__64025_64026.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64059 = arguments.length;
var i__4737__auto___64060 = (0);
while(true){
if((i__4737__auto___64060 < len__4736__auto___64059)){
args__4742__auto__.push((arguments[i__4737__auto___64060]));

var G__64061 = (i__4737__auto___64060 + (1));
i__4737__auto___64060 = G__64061;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__64029){
var vec__64030 = p__64029;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64030,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2901__auto___64062 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64047){
var state_val_64048 = (state_64047[(1)]);
if((state_val_64048 === (1))){
var inst_64033 = fluree.db.connection.get_socket(conn);
var state_64047__$1 = state_64047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64047__$1,(2),inst_64033);
} else {
if((state_val_64048 === (2))){
var inst_64035 = (state_64047[(2)]);
var inst_64036 = (inst_64035 == null);
var inst_64037 = fluree.db.util.core.exception_QMARK_(inst_64035);
var inst_64038 = ((inst_64036) || (inst_64037));
var state_64047__$1 = state_64047;
if(cljs.core.truth_(inst_64038)){
var statearr_64049_64063 = state_64047__$1;
(statearr_64049_64063[(1)] = (3));

} else {
var statearr_64050_64064 = state_64047__$1;
(statearr_64050_64064[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64048 === (3))){
var inst_64040 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_64041 = cljs.core.async.close_BANG_(conn);
var state_64047__$1 = (function (){var statearr_64051 = state_64047;
(statearr_64051[(7)] = inst_64040);

return statearr_64051;
})();
var statearr_64052_64065 = state_64047__$1;
(statearr_64052_64065[(2)] = inst_64041);

(statearr_64052_64065[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64048 === (4))){
var inst_64043 = fluree.db.connection.msg_consumer(conn);
var state_64047__$1 = state_64047;
var statearr_64053_64066 = state_64047__$1;
(statearr_64053_64066[(2)] = inst_64043);

(statearr_64053_64066[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64048 === (5))){
var inst_64045 = (state_64047[(2)]);
var state_64047__$1 = state_64047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64047__$1,inst_64045);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2879__auto__ = null;
var fluree$db$connection$state_machine__2879__auto____0 = (function (){
var statearr_64054 = [null,null,null,null,null,null,null,null];
(statearr_64054[(0)] = fluree$db$connection$state_machine__2879__auto__);

(statearr_64054[(1)] = (1));

return statearr_64054;
});
var fluree$db$connection$state_machine__2879__auto____1 = (function (state_64047){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64047);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64055){var ex__2882__auto__ = e64055;
var statearr_64056_64067 = state_64047;
(statearr_64056_64067[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64047[(4)]))){
var statearr_64057_64068 = state_64047;
(statearr_64057_64068[(1)] = cljs.core.first((state_64047[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64069 = state_64047;
state_64047 = G__64069;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2879__auto__ = function(state_64047){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2879__auto____1.call(this,state_64047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2879__auto____0;
fluree$db$connection$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2879__auto____1;
return fluree$db$connection$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64058 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64058[(6)] = c__2901__auto___64062);

return statearr_64058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq64027){
var G__64028 = cljs.core.first(seq64027);
var seq64027__$1 = cljs.core.next(seq64027);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64028,seq64027__$1);
}));

