// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35856){
var state_val_35857 = (state_35856[(1)]);
if((state_val_35857 === (1))){
var state_35856__$1 = state_35856;
var statearr_35858_35872 = state_35856__$1;
(statearr_35858_35872[(2)] = null);

(statearr_35858_35872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35857 === (2))){
var _ = (function (){var statearr_35859 = state_35856;
(statearr_35859[(4)] = cljs.core.cons((5),(state_35856[(4)])));

return statearr_35859;
})();
var inst_35847 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_35856__$1 = state_35856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35856__$1,(6),inst_35847);
} else {
if((state_val_35857 === (3))){
var inst_35854 = (state_35856[(2)]);
var state_35856__$1 = state_35856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35856__$1,inst_35854);
} else {
if((state_val_35857 === (4))){
var inst_35841 = (state_35856[(2)]);
var state_35856__$1 = state_35856;
var statearr_35861_35873 = state_35856__$1;
(statearr_35861_35873[(2)] = inst_35841);

(statearr_35861_35873[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35857 === (5))){
var _ = (function (){var statearr_35862 = state_35856;
(statearr_35862[(4)] = cljs.core.rest((state_35856[(4)])));

return statearr_35862;
})();
var state_35856__$1 = state_35856;
var ex35860 = (state_35856__$1[(2)]);
var statearr_35863_35874 = state_35856__$1;
(statearr_35863_35874[(5)] = ex35860);


if((ex35860 instanceof Error)){
var statearr_35864_35875 = state_35856__$1;
(statearr_35864_35875[(1)] = (4));

(statearr_35864_35875[(5)] = null);

} else {
throw ex35860;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35857 === (6))){
var inst_35849 = (state_35856[(2)]);
var inst_35850 = fluree.db.util.async.throw_err(inst_35849);
var inst_35851 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_35850);
var _ = (function (){var statearr_35865 = state_35856;
(statearr_35865[(4)] = cljs.core.rest((state_35856[(4)])));

return statearr_35865;
})();
var state_35856__$1 = state_35856;
var statearr_35866_35876 = state_35856__$1;
(statearr_35866_35876[(2)] = inst_35851);

(statearr_35866_35876[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0 = (function (){
var statearr_35867 = [null,null,null,null,null,null,null];
(statearr_35867[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__);

(statearr_35867[(1)] = (1));

return statearr_35867;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1 = (function (state_35856){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35856);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35868){var ex__16304__auto__ = e35868;
var statearr_35869_35877 = state_35856;
(statearr_35869_35877[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35856[(4)]))){
var statearr_35870_35878 = state_35856;
(statearr_35870_35878[(1)] = cljs.core.first((state_35856[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35879 = state_35856;
state_35856 = G__35879;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = function(state_35856){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1.call(this,state_35856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35871 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35871[(6)] = c__16375__auto__);

return statearr_35871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35911){
var state_val_35912 = (state_35911[(1)]);
if((state_val_35912 === (7))){
var inst_35895 = (state_35911[(7)]);
var inst_35897 = cljs.core.empty_QMARK_(inst_35895);
var inst_35898 = (!(inst_35897));
var state_35911__$1 = state_35911;
var statearr_35913_35937 = state_35911__$1;
(statearr_35913_35937[(2)] = inst_35898);

(statearr_35913_35937[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (1))){
var state_35911__$1 = state_35911;
var statearr_35914_35938 = state_35911__$1;
(statearr_35914_35938[(2)] = null);

(statearr_35914_35938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (4))){
var inst_35881 = (state_35911[(2)]);
var state_35911__$1 = state_35911;
var statearr_35915_35939 = state_35911__$1;
(statearr_35915_35939[(2)] = inst_35881);

(statearr_35915_35939[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (6))){
var inst_35895 = (state_35911[(7)]);
var inst_35887 = (state_35911[(8)]);
var inst_35893 = (state_35911[(2)]);
var inst_35894 = fluree.db.util.async.throw_err(inst_35893);
var inst_35895__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35887,inst_35894);
var state_35911__$1 = (function (){var statearr_35916 = state_35911;
(statearr_35916[(7)] = inst_35895__$1);

return statearr_35916;
})();
if(cljs.core.truth_(inst_35895__$1)){
var statearr_35917_35940 = state_35911__$1;
(statearr_35917_35940[(1)] = (7));

} else {
var statearr_35918_35941 = state_35911__$1;
(statearr_35918_35941[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (3))){
var inst_35909 = (state_35911[(2)]);
var state_35911__$1 = state_35911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35911__$1,inst_35909);
} else {
if((state_val_35912 === (12))){
var inst_35906 = (state_35911[(2)]);
var _ = (function (){var statearr_35919 = state_35911;
(statearr_35919[(4)] = cljs.core.rest((state_35911[(4)])));

return statearr_35919;
})();
var state_35911__$1 = state_35911;
var statearr_35920_35942 = state_35911__$1;
(statearr_35920_35942[(2)] = inst_35906);

(statearr_35920_35942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (2))){
var _ = (function (){var statearr_35921 = state_35911;
(statearr_35921[(4)] = cljs.core.cons((5),(state_35911[(4)])));

return statearr_35921;
})();
var inst_35887 = (function (){return (function (p1__35880_SHARP_){
return p1__35880_SHARP_.o;
});
})();
var inst_35888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35889 = [pred_id];
var inst_35890 = (new cljs.core.PersistentVector(null,1,(5),inst_35888,inst_35889,null));
var inst_35891 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_35890);
var state_35911__$1 = (function (){var statearr_35922 = state_35911;
(statearr_35922[(8)] = inst_35887);

return statearr_35922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35911__$1,(6),inst_35891);
} else {
if((state_val_35912 === (11))){
var state_35911__$1 = state_35911;
var statearr_35924_35943 = state_35911__$1;
(statearr_35924_35943[(2)] = true);

(statearr_35924_35943[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (9))){
var inst_35901 = (state_35911[(2)]);
var state_35911__$1 = state_35911;
if(cljs.core.truth_(inst_35901)){
var statearr_35925_35944 = state_35911__$1;
(statearr_35925_35944[(1)] = (10));

} else {
var statearr_35926_35945 = state_35911__$1;
(statearr_35926_35945[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (5))){
var _ = (function (){var statearr_35927 = state_35911;
(statearr_35927[(4)] = cljs.core.rest((state_35911[(4)])));

return statearr_35927;
})();
var state_35911__$1 = state_35911;
var ex35923 = (state_35911__$1[(2)]);
var statearr_35928_35946 = state_35911__$1;
(statearr_35928_35946[(5)] = ex35923);


if((ex35923 instanceof Error)){
var statearr_35929_35947 = state_35911__$1;
(statearr_35929_35947[(1)] = (4));

(statearr_35929_35947[(5)] = null);

} else {
throw ex35923;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (10))){
var inst_35895 = (state_35911[(7)]);
var inst_35903 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_35895);
var state_35911__$1 = state_35911;
var statearr_35930_35948 = state_35911__$1;
(statearr_35930_35948[(2)] = inst_35903);

(statearr_35930_35948[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35912 === (8))){
var inst_35895 = (state_35911[(7)]);
var state_35911__$1 = state_35911;
var statearr_35931_35949 = state_35911__$1;
(statearr_35931_35949[(2)] = inst_35895);

(statearr_35931_35949[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_35932 = [null,null,null,null,null,null,null,null,null];
(statearr_35932[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__);

(statearr_35932[(1)] = (1));

return statearr_35932;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1 = (function (state_35911){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35911);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35933){var ex__16304__auto__ = e35933;
var statearr_35934_35950 = state_35911;
(statearr_35934_35950[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35911[(4)]))){
var statearr_35935_35951 = state_35911;
(statearr_35935_35951[(1)] = cljs.core.first((state_35911[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35952 = state_35911;
state_35911 = G__35952;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = function(state_35911){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1.call(this,state_35911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35936 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35936[(6)] = c__16375__auto__);

return statearr_35936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36029){
var state_val_36030 = (state_36029[(1)]);
if((state_val_36030 === (7))){
var inst_36024 = (state_36029[(2)]);
var _ = (function (){var statearr_36031 = state_36029;
(statearr_36031[(4)] = cljs.core.rest((state_36029[(4)])));

return statearr_36031;
})();
var state_36029__$1 = state_36029;
var statearr_36032_36065 = state_36029__$1;
(statearr_36032_36065[(2)] = inst_36024);

(statearr_36032_36065[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (1))){
var state_36029__$1 = state_36029;
var statearr_36033_36066 = state_36029__$1;
(statearr_36033_36066[(2)] = null);

(statearr_36033_36066[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (4))){
var inst_35955 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36034_36067 = state_36029__$1;
(statearr_36034_36067[(2)] = inst_35955);

(statearr_36034_36067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (15))){
var inst_35992 = (state_36029[(7)]);
var inst_36005 = (state_36029[(8)]);
var inst_35985 = (state_36029[(9)]);
var inst_35979 = (state_36029[(10)]);
var inst_36007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36008 = inst_35985.s;
var inst_36009 = [inst_36008,inst_35992,cljs.core.cst$kw$old];
var inst_36010 = (new cljs.core.PersistentVector(null,3,(5),inst_36007,inst_36009,null));
var inst_36011 = cljs.core.assoc_in(inst_35979,inst_36010,inst_36005);
var state_36029__$1 = state_36029;
var statearr_36035_36068 = state_36029__$1;
(statearr_36035_36068[(2)] = inst_36011);

(statearr_36035_36068[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (13))){
var inst_35994 = (state_36029[(11)]);
var inst_36005 = (state_36029[(2)]);
var state_36029__$1 = (function (){var statearr_36036 = state_36029;
(statearr_36036[(8)] = inst_36005);

return statearr_36036;
})();
if(cljs.core.truth_(inst_35994)){
var statearr_36037_36069 = state_36029__$1;
(statearr_36037_36069[(1)] = (15));

} else {
var statearr_36038_36070 = state_36029__$1;
(statearr_36038_36070[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (6))){
var inst_35978 = (state_36029[(12)]);
var inst_35985 = (state_36029[(9)]);
var inst_35984 = cljs.core.seq(inst_35978);
var inst_35985__$1 = cljs.core.first(inst_35984);
var inst_35986 = cljs.core.next(inst_35984);
var inst_35987 = cljs.core.not(inst_35985__$1);
var state_36029__$1 = (function (){var statearr_36039 = state_36029;
(statearr_36039[(9)] = inst_35985__$1);

(statearr_36039[(13)] = inst_35986);

return statearr_36039;
})();
if(inst_35987){
var statearr_36040_36071 = state_36029__$1;
(statearr_36040_36071[(1)] = (8));

} else {
var statearr_36041_36072 = state_36029__$1;
(statearr_36041_36072[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (17))){
var inst_35986 = (state_36029[(13)]);
var inst_36019 = (state_36029[(2)]);
var inst_35978 = inst_35986;
var inst_35979 = inst_36019;
var state_36029__$1 = (function (){var statearr_36042 = state_36029;
(statearr_36042[(12)] = inst_35978);

(statearr_36042[(10)] = inst_35979);

return statearr_36042;
})();
var statearr_36043_36073 = state_36029__$1;
(statearr_36043_36073[(2)] = null);

(statearr_36043_36073[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (3))){
var inst_36027 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36029__$1,inst_36027);
} else {
if((state_val_36030 === (12))){
var inst_35985 = (state_36029[(9)]);
var inst_36003 = inst_35985.o;
var state_36029__$1 = state_36029;
var statearr_36044_36074 = state_36029__$1;
(statearr_36044_36074[(2)] = inst_36003);

(statearr_36044_36074[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (2))){
var _ = (function (){var statearr_36045 = state_36029;
(statearr_36045[(4)] = cljs.core.cons((5),(state_36029[(4)])));

return statearr_36045;
})();
var inst_35961 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_35962 = cljs.core.PersistentHashSet.EMPTY;
var inst_35963 = cljs.core.vals(tempids);
var inst_35964 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35962,inst_35963);
var inst_35965 = (function (){var pred_flakes = inst_35961;
var is_new_QMARK_ = inst_35964;
return (function (p1__35953_SHARP_,p2__35954_SHARP_){
return cljs.core.assoc_in(p1__35953_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__35954_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__36046 = p2__35954_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__36046) : is_new_QMARK_.call(null,G__36046));
})()));
});
})();
var inst_35966 = cljs.core.PersistentHashMap.EMPTY;
var inst_35967 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35965,inst_35966,inst_35961);
var inst_35975 = cljs.core.seq(inst_35961);
var inst_35976 = cljs.core.first(inst_35975);
var inst_35977 = cljs.core.next(inst_35975);
var inst_35978 = inst_35961;
var inst_35979 = inst_35967;
var state_36029__$1 = (function (){var statearr_36047 = state_36029;
(statearr_36047[(12)] = inst_35978);

(statearr_36047[(14)] = inst_35976);

(statearr_36047[(10)] = inst_35979);

(statearr_36047[(15)] = inst_35977);

return statearr_36047;
})();
var statearr_36048_36075 = state_36029__$1;
(statearr_36048_36075[(2)] = null);

(statearr_36048_36075[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (11))){
var inst_35985 = (state_36029[(9)]);
var inst_35997 = inst_35985.o;
var inst_35998 = fluree.db.query.schema.convert_type_to_kw(inst_35997,db);
var state_36029__$1 = state_36029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36029__$1,(14),inst_35998);
} else {
if((state_val_36030 === (9))){
var inst_35992 = (state_36029[(7)]);
var inst_35985 = (state_36029[(9)]);
var inst_35990 = inst_35985.p;
var inst_35991 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_35990);
var inst_35992__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_35991);
var inst_35993 = inst_35985.op;
var inst_35994 = inst_35993 === false;
var inst_35995 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_35992__$1);
var state_36029__$1 = (function (){var statearr_36050 = state_36029;
(statearr_36050[(7)] = inst_35992__$1);

(statearr_36050[(11)] = inst_35994);

return statearr_36050;
})();
if(inst_35995){
var statearr_36051_36076 = state_36029__$1;
(statearr_36051_36076[(1)] = (11));

} else {
var statearr_36052_36077 = state_36029__$1;
(statearr_36052_36077[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (5))){
var _ = (function (){var statearr_36053 = state_36029;
(statearr_36053[(4)] = cljs.core.rest((state_36029[(4)])));

return statearr_36053;
})();
var state_36029__$1 = state_36029;
var ex36049 = (state_36029__$1[(2)]);
var statearr_36054_36078 = state_36029__$1;
(statearr_36054_36078[(5)] = ex36049);


if((ex36049 instanceof Error)){
var statearr_36055_36079 = state_36029__$1;
(statearr_36055_36079[(1)] = (4));

(statearr_36055_36079[(5)] = null);

} else {
throw ex36049;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (14))){
var inst_36000 = (state_36029[(2)]);
var inst_36001 = fluree.db.util.async.throw_err(inst_36000);
var state_36029__$1 = state_36029;
var statearr_36056_36080 = state_36029__$1;
(statearr_36056_36080[(2)] = inst_36001);

(statearr_36056_36080[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (16))){
var inst_35992 = (state_36029[(7)]);
var inst_36005 = (state_36029[(8)]);
var inst_35985 = (state_36029[(9)]);
var inst_35979 = (state_36029[(10)]);
var inst_36013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36014 = inst_35985.s;
var inst_36015 = [inst_36014,inst_35992,cljs.core.cst$kw$new];
var inst_36016 = (new cljs.core.PersistentVector(null,3,(5),inst_36013,inst_36015,null));
var inst_36017 = cljs.core.assoc_in(inst_35979,inst_36016,inst_36005);
var state_36029__$1 = state_36029;
var statearr_36057_36081 = state_36029__$1;
(statearr_36057_36081[(2)] = inst_36017);

(statearr_36057_36081[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (10))){
var inst_36022 = (state_36029[(2)]);
var state_36029__$1 = state_36029;
var statearr_36058_36082 = state_36029__$1;
(statearr_36058_36082[(2)] = inst_36022);

(statearr_36058_36082[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36030 === (8))){
var inst_35979 = (state_36029[(10)]);
var state_36029__$1 = state_36029;
var statearr_36059_36083 = state_36029__$1;
(statearr_36059_36083[(2)] = inst_35979);

(statearr_36059_36083[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0 = (function (){
var statearr_36060 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36060[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__);

(statearr_36060[(1)] = (1));

return statearr_36060;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1 = (function (state_36029){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36029);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36061){var ex__16304__auto__ = e36061;
var statearr_36062_36084 = state_36029;
(statearr_36062_36084[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36029[(4)]))){
var statearr_36063_36085 = state_36029;
(statearr_36063_36085[(1)] = cljs.core.first((state_36029[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36086 = state_36029;
state_36029 = G__36086;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = function(state_36029){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1.call(this,state_36029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36064 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36064[(6)] = c__16375__auto__);

return statearr_36064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__36088 = arguments.length;
switch (G__36088) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__36091 = arguments.length;
switch (G__36091) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36400){
var state_val_36401 = (state_36400[(1)]);
if((state_val_36401 === (65))){
var inst_36353 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36402_36574 = state_36400__$1;
(statearr_36402_36574[(2)] = inst_36353);

(statearr_36402_36574[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (70))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36275 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36276 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36275,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,2,inst_36275,null));
var inst_36277 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36276,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36276,null));
var inst_36278 = (inst_36277.cljs$core$IFn$_invoke$arity$1 ? inst_36277.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36277.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36278)){
var statearr_36403_36575 = state_36400__$1;
(statearr_36403_36575[(1)] = (71));

} else {
var statearr_36404_36576 = state_36400__$1;
(statearr_36404_36576[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (62))){
var inst_36355 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36405_36577 = state_36400__$1;
(statearr_36405_36577[(2)] = inst_36355);

(statearr_36405_36577[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (74))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36285 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36286 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36285,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,3,inst_36285,null));
var inst_36287 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36286,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36286,null));
var inst_36288 = (inst_36287.cljs$core$IFn$_invoke$arity$1 ? inst_36287.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36287.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36288)){
var statearr_36406_36578 = state_36400__$1;
(statearr_36406_36578[(1)] = (75));

} else {
var statearr_36407_36579 = state_36400__$1;
(statearr_36407_36579[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (110))){
var inst_36387 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36408_36580 = state_36400__$1;
(statearr_36408_36580[(2)] = inst_36387);

(statearr_36408_36580[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (7))){
var inst_36395 = (state_36400[(2)]);
var _ = (function (){var statearr_36409 = state_36400;
(statearr_36409[(4)] = cljs.core.rest((state_36400[(4)])));

return statearr_36409;
})();
var state_36400__$1 = state_36400;
var statearr_36410_36581 = state_36400__$1;
(statearr_36410_36581[(2)] = inst_36395);

(statearr_36410_36581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (59))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36261 = (state_36400[(2)]);
var inst_36262__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36261,cljs.core.cst$kw$old);
var inst_36263__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36261,cljs.core.cst$kw$new);
var inst_36264 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36263__$1,inst_36262__$1);
var state_36400__$1 = (function (){var statearr_36411 = state_36400;
(statearr_36411[(7)] = inst_36263__$1);

(statearr_36411[(8)] = inst_36262__$1);

return statearr_36411;
})();
if(inst_36264){
var statearr_36412_36582 = state_36400__$1;
(statearr_36412_36582[(1)] = (60));

} else {
var statearr_36413_36583 = state_36400__$1;
(statearr_36413_36583[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (86))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36315 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_36316 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36315,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,5,inst_36315,null));
var inst_36317 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36316,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36316,null));
var inst_36318 = (inst_36317.cljs$core$IFn$_invoke$arity$1 ? inst_36317.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36317.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36318)){
var statearr_36414_36584 = state_36400__$1;
(statearr_36414_36584[(1)] = (87));

} else {
var statearr_36415_36585 = state_36400__$1;
(statearr_36415_36585[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (20))){
var inst_36131 = (state_36400[(9)]);
var inst_36156 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36157 = inst_36156 === true;
var inst_36158 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36159 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36158);
var inst_36160 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_36159);
var inst_36161 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36162 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36161);
var inst_36163 = inst_36162 === true;
var inst_36164 = ((inst_36157) && (inst_36160) && (inst_36163));
var state_36400__$1 = state_36400;
var statearr_36416_36586 = state_36400__$1;
(statearr_36416_36586[(2)] = inst_36164);

(statearr_36416_36586[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (72))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36281 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36417_36587 = state_36400__$1;
(statearr_36417_36587[(2)] = inst_36281);

(statearr_36417_36587[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (58))){
var inst_36240 = (state_36400[(10)]);
var state_36400__$1 = state_36400;
var statearr_36418_36588 = state_36400__$1;
(statearr_36418_36588[(2)] = inst_36240);

(statearr_36418_36588[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (60))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36419_36589 = state_36400__$1;
(statearr_36419_36589[(2)] = inst_36230);

(statearr_36419_36589[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (27))){
var inst_36151 = (state_36400[(12)]);
var state_36400__$1 = state_36400;
var statearr_36420_36590 = state_36400__$1;
(statearr_36420_36590[(2)] = inst_36151);

(statearr_36420_36590[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (1))){
var state_36400__$1 = state_36400;
var statearr_36421_36591 = state_36400__$1;
(statearr_36421_36591[(2)] = null);

(statearr_36421_36591[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (69))){
var inst_36348 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36422_36592 = state_36400__$1;
(statearr_36422_36592[(2)] = inst_36348);

(statearr_36422_36592[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (101))){
var inst_36377 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36377)){
var statearr_36423_36593 = state_36400__$1;
(statearr_36423_36593[(1)] = (105));

} else {
var statearr_36424_36594 = state_36400__$1;
(statearr_36424_36594[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (24))){
var inst_36151 = (state_36400[(12)]);
var state_36400__$1 = state_36400;
var statearr_36425_36595 = state_36400__$1;
(statearr_36425_36595[(2)] = inst_36151);

(statearr_36425_36595[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (102))){
var inst_36131 = (state_36400[(9)]);
var inst_36364 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36365 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36364);
var inst_36366 = inst_36365 === true;
var inst_36367 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36368 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36367);
var inst_36369 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_36368);
var inst_36370 = (!(inst_36369));
var inst_36371 = ((inst_36366) && (inst_36370));
var state_36400__$1 = state_36400;
var statearr_36426_36596 = state_36400__$1;
(statearr_36426_36596[(2)] = inst_36371);

(statearr_36426_36596[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (55))){
var state_36400__$1 = state_36400;
var statearr_36427_36597 = state_36400__$1;
(statearr_36427_36597[(2)] = false);

(statearr_36427_36597[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (85))){
var inst_36313 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36428_36598 = state_36400__$1;
(statearr_36428_36598[(2)] = inst_36313);

(statearr_36428_36598[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (39))){
var state_36400__$1 = state_36400;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36429_36599 = state_36400__$1;
(statearr_36429_36599[(1)] = (42));

} else {
var statearr_36430_36600 = state_36400__$1;
(statearr_36430_36600[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (88))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36321 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36431_36601 = state_36400__$1;
(statearr_36431_36601[(2)] = inst_36321);

(statearr_36431_36601[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (46))){
var inst_36231 = (state_36400[(13)]);
var state_36400__$1 = state_36400;
var statearr_36432_36602 = state_36400__$1;
(statearr_36432_36602[(2)] = inst_36231);

(statearr_36432_36602[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (4))){
var inst_36092 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36433_36603 = state_36400__$1;
(statearr_36433_36603[(2)] = inst_36092);

(statearr_36433_36603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (77))){
var inst_36293 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36434_36604 = state_36400__$1;
(statearr_36434_36604[(2)] = inst_36293);

(statearr_36434_36604[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (106))){
var inst_36358 = (state_36400[(14)]);
var state_36400__$1 = state_36400;
var statearr_36435_36605 = state_36400__$1;
(statearr_36435_36605[(2)] = inst_36358);

(statearr_36435_36605[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (95))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36436_36606 = state_36400__$1;
(statearr_36436_36606[(2)] = inst_36230);

(statearr_36436_36606[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (54))){
var state_36400__$1 = state_36400;
var statearr_36437_36607 = state_36400__$1;
(statearr_36437_36607[(2)] = true);

(statearr_36437_36607[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (92))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36331 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36438_36608 = state_36400__$1;
(statearr_36438_36608[(2)] = inst_36331);

(statearr_36438_36608[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (104))){
var inst_36374 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36439_36609 = state_36400__$1;
(statearr_36439_36609[(2)] = inst_36374);

(statearr_36439_36609[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (15))){
var inst_36119 = (state_36400[(15)]);
var state_36400__$1 = state_36400;
var statearr_36440_36610 = state_36400__$1;
(statearr_36440_36610[(2)] = inst_36119);

(statearr_36440_36610[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (48))){
var inst_36240 = (state_36400[(10)]);
var inst_36131 = (state_36400[(9)]);
var inst_36240__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36242 = (inst_36240__$1 == null);
var inst_36243 = cljs.core.not(inst_36242);
var state_36400__$1 = (function (){var statearr_36441 = state_36400;
(statearr_36441[(10)] = inst_36240__$1);

return statearr_36441;
})();
if(inst_36243){
var statearr_36442_36611 = state_36400__$1;
(statearr_36442_36611[(1)] = (51));

} else {
var statearr_36443_36612 = state_36400__$1;
(statearr_36443_36612[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (50))){
var inst_36131 = (state_36400[(9)]);
var inst_36358 = (state_36400[(2)]);
var inst_36359 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36360 = inst_36359 === true;
var state_36400__$1 = (function (){var statearr_36444 = state_36400;
(statearr_36444[(14)] = inst_36358);

return statearr_36444;
})();
if(cljs.core.truth_(inst_36360)){
var statearr_36445_36613 = state_36400__$1;
(statearr_36445_36613[(1)] = (99));

} else {
var statearr_36446_36614 = state_36400__$1;
(statearr_36446_36614[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (75))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36447_36615 = state_36400__$1;
(statearr_36447_36615[(2)] = inst_36230);

(statearr_36447_36615[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (99))){
var inst_36362 = (state_36400[(16)]);
var inst_36131 = (state_36400[(9)]);
var inst_36362__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36448 = state_36400;
(statearr_36448[(16)] = inst_36362__$1);

return statearr_36448;
})();
if(cljs.core.truth_(inst_36362__$1)){
var statearr_36449_36616 = state_36400__$1;
(statearr_36449_36616[(1)] = (102));

} else {
var statearr_36450_36617 = state_36400__$1;
(statearr_36450_36617[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (21))){
var inst_36154 = (state_36400[(17)]);
var state_36400__$1 = state_36400;
var statearr_36451_36618 = state_36400__$1;
(statearr_36451_36618[(2)] = inst_36154);

(statearr_36451_36618[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (31))){
var inst_36194 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36194)){
var statearr_36452_36619 = state_36400__$1;
(statearr_36452_36619[(1)] = (32));

} else {
var statearr_36453_36620 = state_36400__$1;
(statearr_36453_36620[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (32))){
var inst_36183 = (state_36400[(18)]);
var inst_36196 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36183,"a component","a non-component",throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36454_36621 = state_36400__$1;
(statearr_36454_36621[(2)] = inst_36196);

(statearr_36454_36621[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (40))){
var inst_36199 = (state_36400[(19)]);
var state_36400__$1 = state_36400;
var statearr_36455_36622 = state_36400__$1;
(statearr_36455_36622[(2)] = inst_36199);

(statearr_36455_36622[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (91))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36456_36623 = state_36400__$1;
(statearr_36456_36623[(2)] = inst_36230);

(statearr_36456_36623[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (108))){
var inst_36380 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36381 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36382 = cljs.core.PersistentHashMap.fromArrays(inst_36380,inst_36381);
var inst_36383 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_36382);
var inst_36384 = (function(){throw inst_36383})();
var state_36400__$1 = state_36400;
var statearr_36457_36624 = state_36400__$1;
(statearr_36457_36624[(2)] = inst_36384);

(statearr_36457_36624[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (56))){
var inst_36253 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36458_36625 = state_36400__$1;
(statearr_36458_36625[(2)] = inst_36253);

(statearr_36458_36625[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (33))){
var inst_36183 = (state_36400[(18)]);
var state_36400__$1 = state_36400;
var statearr_36459_36626 = state_36400__$1;
(statearr_36459_36626[(2)] = inst_36183);

(statearr_36459_36626[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (13))){
var inst_36146 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36146)){
var statearr_36460_36627 = state_36400__$1;
(statearr_36460_36627[(1)] = (14));

} else {
var statearr_36461_36628 = state_36400__$1;
(statearr_36461_36628[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (22))){
var inst_36167 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36462_36629 = state_36400__$1;
(statearr_36462_36629[(2)] = inst_36167);

(statearr_36462_36629[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (90))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36325 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_36326 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36325,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,5,inst_36325,null));
var inst_36327 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36326,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36326,null));
var inst_36328 = (inst_36327.cljs$core$IFn$_invoke$arity$1 ? inst_36327.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36327.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36328)){
var statearr_36463_36630 = state_36400__$1;
(statearr_36463_36630[(1)] = (91));

} else {
var statearr_36464_36631 = state_36400__$1;
(statearr_36464_36631[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (109))){
var inst_36358 = (state_36400[(14)]);
var state_36400__$1 = state_36400;
var statearr_36465_36632 = state_36400__$1;
(statearr_36465_36632[(2)] = inst_36358);

(statearr_36465_36632[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (36))){
var inst_36200 = (state_36400[(20)]);
var state_36400__$1 = state_36400;
var statearr_36466_36633 = state_36400__$1;
(statearr_36466_36633[(2)] = inst_36200);

(statearr_36466_36633[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (41))){
var inst_36231 = (state_36400[(13)]);
var inst_36131 = (state_36400[(9)]);
var inst_36230 = (state_36400[(2)]);
var inst_36231__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36467 = state_36400;
(statearr_36467[(13)] = inst_36231__$1);

(statearr_36467[(11)] = inst_36230);

return statearr_36467;
})();
if(cljs.core.truth_(inst_36231__$1)){
var statearr_36468_36634 = state_36400__$1;
(statearr_36468_36634[(1)] = (45));

} else {
var statearr_36469_36635 = state_36400__$1;
(statearr_36469_36635[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (89))){
var inst_36323 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36470_36636 = state_36400__$1;
(statearr_36470_36636[(2)] = inst_36323);

(statearr_36470_36636[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (100))){
var state_36400__$1 = state_36400;
var statearr_36471_36637 = state_36400__$1;
(statearr_36471_36637[(2)] = false);

(statearr_36471_36637[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (43))){
var inst_36199 = (state_36400[(19)]);
var state_36400__$1 = state_36400;
var statearr_36472_36638 = state_36400__$1;
(statearr_36472_36638[(2)] = inst_36199);

(statearr_36472_36638[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (61))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36267 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_36268 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36267,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,3,inst_36267,null));
var inst_36269 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36268,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36268,null));
var inst_36270 = (inst_36269.cljs$core$IFn$_invoke$arity$1 ? inst_36269.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36269.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36270)){
var statearr_36473_36639 = state_36400__$1;
(statearr_36473_36639[(1)] = (63));

} else {
var statearr_36474_36640 = state_36400__$1;
(statearr_36474_36640[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (29))){
var inst_36131 = (state_36400[(9)]);
var inst_36186 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36187 = cljs.core.not(inst_36186);
var inst_36188 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36189 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36188);
var inst_36190 = inst_36189 === true;
var inst_36191 = ((inst_36187) && (inst_36190));
var state_36400__$1 = state_36400;
var statearr_36475_36641 = state_36400__$1;
(statearr_36475_36641[(2)] = inst_36191);

(statearr_36475_36641[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (44))){
var inst_36227 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36476_36642 = state_36400__$1;
(statearr_36476_36642[(2)] = inst_36227);

(statearr_36476_36642[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (93))){
var inst_36333 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36477_36643 = state_36400__$1;
(statearr_36477_36643[(2)] = inst_36333);

(statearr_36477_36643[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (6))){
var inst_36130 = (state_36400[(21)]);
var inst_36118 = (state_36400[(22)]);
var inst_36127 = cljs.core.seq(inst_36118);
var inst_36128 = cljs.core.first(inst_36127);
var inst_36129 = cljs.core.next(inst_36127);
var inst_36130__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36128,(0),null);
var inst_36131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36128,(1),null);
var inst_36132 = cljs.core.not(inst_36130__$1);
var state_36400__$1 = (function (){var statearr_36478 = state_36400;
(statearr_36478[(23)] = inst_36129);

(statearr_36478[(21)] = inst_36130__$1);

(statearr_36478[(9)] = inst_36131);

return statearr_36478;
})();
if(inst_36132){
var statearr_36479_36644 = state_36400__$1;
(statearr_36479_36644[(1)] = (8));

} else {
var statearr_36480_36645 = state_36400__$1;
(statearr_36480_36645[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (28))){
var inst_36180 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36481_36646 = state_36400__$1;
(statearr_36481_36646[(2)] = inst_36180);

(statearr_36481_36646[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (64))){
var state_36400__$1 = state_36400;
var statearr_36482_36647 = state_36400__$1;
(statearr_36482_36647[(1)] = (66));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (103))){
var inst_36362 = (state_36400[(16)]);
var state_36400__$1 = state_36400;
var statearr_36484_36648 = state_36400__$1;
(statearr_36484_36648[(2)] = inst_36362);

(statearr_36484_36648[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (51))){
var inst_36240 = (state_36400[(10)]);
var inst_36245 = inst_36240.cljs$lang$protocol_mask$partition0$;
var inst_36246 = (inst_36245 & (64));
var inst_36247 = inst_36240.cljs$core$ISeq$;
var inst_36248 = (cljs.core.PROTOCOL_SENTINEL === inst_36247);
var inst_36249 = ((inst_36246) || (inst_36248));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36249)){
var statearr_36485_36649 = state_36400__$1;
(statearr_36485_36649[(1)] = (54));

} else {
var statearr_36486_36650 = state_36400__$1;
(statearr_36486_36650[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (25))){
var inst_36184 = (state_36400[(24)]);
var inst_36131 = (state_36400[(9)]);
var inst_36183 = (state_36400[(2)]);
var inst_36184__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36487 = state_36400;
(statearr_36487[(24)] = inst_36184__$1);

(statearr_36487[(18)] = inst_36183);

return statearr_36487;
})();
if(cljs.core.truth_(inst_36184__$1)){
var statearr_36488_36651 = state_36400__$1;
(statearr_36488_36651[(1)] = (29));

} else {
var statearr_36489_36652 = state_36400__$1;
(statearr_36489_36652[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (34))){
var inst_36131 = (state_36400[(9)]);
var inst_36200 = (state_36400[(20)]);
var inst_36199 = (state_36400[(2)]);
var inst_36200__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36490 = state_36400;
(statearr_36490[(19)] = inst_36199);

(statearr_36490[(20)] = inst_36200__$1);

return statearr_36490;
})();
if(cljs.core.truth_(inst_36200__$1)){
var statearr_36491_36653 = state_36400__$1;
(statearr_36491_36653[(1)] = (35));

} else {
var statearr_36492_36654 = state_36400__$1;
(statearr_36492_36654[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (17))){
var inst_36131 = (state_36400[(9)]);
var inst_36154 = (state_36400[(17)]);
var inst_36154__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36493 = state_36400;
(statearr_36493[(17)] = inst_36154__$1);

return statearr_36493;
})();
if(cljs.core.truth_(inst_36154__$1)){
var statearr_36494_36655 = state_36400__$1;
(statearr_36494_36655[(1)] = (20));

} else {
var statearr_36495_36656 = state_36400__$1;
(statearr_36495_36656[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (3))){
var inst_36398 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36400__$1,inst_36398);
} else {
if((state_val_36401 === (12))){
var inst_36135 = (state_36400[(25)]);
var state_36400__$1 = state_36400;
var statearr_36496_36657 = state_36400__$1;
(statearr_36496_36657[(2)] = inst_36135);

(statearr_36496_36657[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (2))){
var _ = (function (){var statearr_36497 = state_36400;
(statearr_36497[(4)] = cljs.core.cons((5),(state_36400[(4)])));

return statearr_36497;
})();
var inst_36111 = pred_changes;
var inst_36112 = cljs.core.seq(inst_36111);
var inst_36113 = cljs.core.first(inst_36112);
var inst_36114 = cljs.core.next(inst_36112);
var inst_36115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36113,(0),null);
var inst_36116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36113,(1),null);
var inst_36117 = db;
var inst_36118 = inst_36111;
var inst_36119 = inst_36117;
var state_36400__$1 = (function (){var statearr_36498 = state_36400;
(statearr_36498[(26)] = inst_36114);

(statearr_36498[(27)] = inst_36115);

(statearr_36498[(15)] = inst_36119);

(statearr_36498[(22)] = inst_36118);

(statearr_36498[(28)] = inst_36116);

return statearr_36498;
})();
var statearr_36499_36658 = state_36400__$1;
(statearr_36499_36658[(2)] = null);

(statearr_36499_36658[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (66))){
var inst_36263 = (state_36400[(7)]);
var state_36400__$1 = state_36400;
var G__36500_36659 = inst_36263;
var G__36500_36660__$1 = (((G__36500_36659 instanceof cljs.core.Keyword))?G__36500_36659.fqn:null);
switch (G__36500_36660__$1) {
case "long":
var statearr_36501_36662 = state_36400__$1;
(statearr_36501_36662[(1)] = (70));


break;
case "bigint":
var statearr_36502_36663 = state_36400__$1;
(statearr_36502_36663[(1)] = (74));


break;
case "double":
var statearr_36503_36664 = state_36400__$1;
(statearr_36503_36664[(1)] = (78));


break;
case "float":
var statearr_36504_36665 = state_36400__$1;
(statearr_36504_36665[(1)] = (82));


break;
case "bigdec":
var statearr_36505_36666 = state_36400__$1;
(statearr_36505_36666[(1)] = (86));


break;
case "string":
var statearr_36506_36667 = state_36400__$1;
(statearr_36506_36667[(1)] = (90));


break;
case "instant":
var statearr_36507_36668 = state_36400__$1;
(statearr_36507_36668[(1)] = (94));


break;
default:
var statearr_36508_36669 = state_36400__$1;
(statearr_36508_36669[(1)] = (98));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (107))){
var inst_36129 = (state_36400[(23)]);
var inst_36390 = (state_36400[(2)]);
var inst_36118 = inst_36129;
var inst_36119 = inst_36390;
var state_36400__$1 = (function (){var statearr_36509 = state_36400;
(statearr_36509[(15)] = inst_36119);

(statearr_36509[(22)] = inst_36118);

return statearr_36509;
})();
var statearr_36510_36670 = state_36400__$1;
(statearr_36510_36670[(2)] = null);

(statearr_36510_36670[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (23))){
var state_36400__$1 = state_36400;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36511_36671 = state_36400__$1;
(statearr_36511_36671[(1)] = (26));

} else {
var statearr_36512_36672 = state_36400__$1;
(statearr_36512_36672[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (47))){
var inst_36237 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36237)){
var statearr_36513_36673 = state_36400__$1;
(statearr_36513_36673[(1)] = (48));

} else {
var statearr_36514_36674 = state_36400__$1;
(statearr_36514_36674[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (35))){
var inst_36119 = (state_36400[(15)]);
var inst_36130 = (state_36400[(21)]);
var inst_36131 = (state_36400[(9)]);
var inst_36202 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36203 = cljs.core.not(inst_36202);
var inst_36204 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36205 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36204);
var inst_36206 = inst_36205 === true;
var inst_36207 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_36119,inst_36130);
var state_36400__$1 = (function (){var statearr_36515 = state_36400;
(statearr_36515[(29)] = inst_36206);

(statearr_36515[(30)] = inst_36203);

return statearr_36515;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36400__$1,(38),inst_36207);
} else {
if((state_val_36401 === (82))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36305 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36306 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36305,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,3,inst_36305,null));
var inst_36307 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36306,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36306,null));
var inst_36308 = (inst_36307.cljs$core$IFn$_invoke$arity$1 ? inst_36307.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36307.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36308)){
var statearr_36516_36675 = state_36400__$1;
(statearr_36516_36675[(1)] = (83));

} else {
var statearr_36517_36676 = state_36400__$1;
(statearr_36517_36676[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (76))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36291 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36518_36677 = state_36400__$1;
(statearr_36518_36677[(2)] = inst_36291);

(statearr_36518_36677[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (97))){
var inst_36343 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36519_36678 = state_36400__$1;
(statearr_36519_36678[(2)] = inst_36343);

(statearr_36519_36678[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (19))){
var inst_36170 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36170)){
var statearr_36520_36679 = state_36400__$1;
(statearr_36520_36679[(1)] = (23));

} else {
var statearr_36521_36680 = state_36400__$1;
(statearr_36521_36680[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (57))){
var inst_36240 = (state_36400[(10)]);
var inst_36258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36240);
var state_36400__$1 = state_36400;
var statearr_36522_36681 = state_36400__$1;
(statearr_36522_36681[(2)] = inst_36258);

(statearr_36522_36681[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (68))){
var inst_36351 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36523_36682 = state_36400__$1;
(statearr_36523_36682[(2)] = inst_36351);

(statearr_36523_36682[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (11))){
var inst_36131 = (state_36400[(9)]);
var inst_36137 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36138 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36137);
var inst_36139 = inst_36138 === false;
var inst_36140 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36141 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36140);
var inst_36142 = inst_36141 === true;
var inst_36143 = ((inst_36139) && (inst_36142));
var state_36400__$1 = state_36400;
var statearr_36525_36683 = state_36400__$1;
(statearr_36525_36683[(2)] = inst_36143);

(statearr_36525_36683[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (9))){
var inst_36135 = (state_36400[(25)]);
var inst_36131 = (state_36400[(9)]);
var inst_36135__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36526 = state_36400;
(statearr_36526[(25)] = inst_36135__$1);

return statearr_36526;
})();
if(cljs.core.truth_(inst_36135__$1)){
var statearr_36527_36684 = state_36400__$1;
(statearr_36527_36684[(1)] = (11));

} else {
var statearr_36528_36685 = state_36400__$1;
(statearr_36528_36685[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (5))){
var _ = (function (){var statearr_36529 = state_36400;
(statearr_36529[(4)] = cljs.core.rest((state_36400[(4)])));

return statearr_36529;
})();
var state_36400__$1 = state_36400;
var ex36524 = (state_36400__$1[(2)]);
var statearr_36530_36686 = state_36400__$1;
(statearr_36530_36686[(5)] = ex36524);


if((ex36524 instanceof Error)){
var statearr_36531_36687 = state_36400__$1;
(statearr_36531_36687[(1)] = (4));

(statearr_36531_36687[(5)] = null);

} else {
throw ex36524;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (83))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36532_36688 = state_36400__$1;
(statearr_36532_36688[(2)] = inst_36230);

(statearr_36532_36688[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (14))){
var inst_36119 = (state_36400[(15)]);
var inst_36148 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36119,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36533_36689 = state_36400__$1;
(statearr_36533_36689[(2)] = inst_36148);

(statearr_36533_36689[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (45))){
var inst_36131 = (state_36400[(9)]);
var inst_36233 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_36131);
var inst_36234 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36233);
var state_36400__$1 = state_36400;
var statearr_36534_36690 = state_36400__$1;
(statearr_36534_36690[(2)] = inst_36234);

(statearr_36534_36690[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (53))){
var inst_36256 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36256)){
var statearr_36535_36691 = state_36400__$1;
(statearr_36535_36691[(1)] = (57));

} else {
var statearr_36536_36692 = state_36400__$1;
(statearr_36536_36692[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (78))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36295 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36296 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36295,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,3,inst_36295,null));
var inst_36297 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36296,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36296,null));
var inst_36298 = (inst_36297.cljs$core$IFn$_invoke$arity$1 ? inst_36297.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36297.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36298)){
var statearr_36537_36693 = state_36400__$1;
(statearr_36537_36693[(1)] = (79));

} else {
var statearr_36538_36694 = state_36400__$1;
(statearr_36538_36694[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (26))){
var inst_36173 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36174 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36175 = cljs.core.PersistentHashMap.fromArrays(inst_36173,inst_36174);
var inst_36176 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_36175);
var inst_36177 = (function(){throw inst_36176})();
var state_36400__$1 = state_36400;
var statearr_36539_36695 = state_36400__$1;
(statearr_36539_36695[(2)] = inst_36177);

(statearr_36539_36695[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (16))){
var inst_36152 = (state_36400[(31)]);
var inst_36131 = (state_36400[(9)]);
var inst_36151 = (state_36400[(2)]);
var inst_36152__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_36131);
var state_36400__$1 = (function (){var statearr_36540 = state_36400;
(statearr_36540[(31)] = inst_36152__$1);

(statearr_36540[(12)] = inst_36151);

return statearr_36540;
})();
if(cljs.core.truth_(inst_36152__$1)){
var statearr_36541_36696 = state_36400__$1;
(statearr_36541_36696[(1)] = (17));

} else {
var statearr_36542_36697 = state_36400__$1;
(statearr_36542_36697[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (81))){
var inst_36303 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36543_36698 = state_36400__$1;
(statearr_36543_36698[(2)] = inst_36303);

(statearr_36543_36698[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (79))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36544_36699 = state_36400__$1;
(statearr_36544_36699[(2)] = inst_36230);

(statearr_36544_36699[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (38))){
var inst_36206 = (state_36400[(29)]);
var inst_36203 = (state_36400[(30)]);
var inst_36209 = (state_36400[(2)]);
var inst_36210 = fluree.db.util.async.throw_err(inst_36209);
var inst_36211 = cljs.core.not(inst_36210);
var inst_36212 = ((inst_36203) && (inst_36206) && (inst_36211));
var state_36400__$1 = state_36400;
var statearr_36545_36700 = state_36400__$1;
(statearr_36545_36700[(2)] = inst_36212);

(statearr_36545_36700[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (98))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36345 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36546_36701 = state_36400__$1;
(statearr_36546_36701[(2)] = inst_36345);

(statearr_36546_36701[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (87))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36547_36702 = state_36400__$1;
(statearr_36547_36702[(2)] = inst_36230);

(statearr_36547_36702[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (30))){
var inst_36184 = (state_36400[(24)]);
var state_36400__$1 = state_36400;
var statearr_36548_36703 = state_36400__$1;
(statearr_36548_36703[(2)] = inst_36184);

(statearr_36548_36703[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (73))){
var inst_36283 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36549_36704 = state_36400__$1;
(statearr_36549_36704[(2)] = inst_36283);

(statearr_36549_36704[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (96))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36341 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36550_36705 = state_36400__$1;
(statearr_36550_36705[(2)] = inst_36341);

(statearr_36550_36705[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (10))){
var inst_36393 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
var statearr_36551_36706 = state_36400__$1;
(statearr_36551_36706[(2)] = inst_36393);

(statearr_36551_36706[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (18))){
var inst_36152 = (state_36400[(31)]);
var state_36400__$1 = state_36400;
var statearr_36552_36707 = state_36400__$1;
(statearr_36552_36707[(2)] = inst_36152);

(statearr_36552_36707[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (105))){
var state_36400__$1 = state_36400;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36553_36708 = state_36400__$1;
(statearr_36553_36708[(1)] = (108));

} else {
var statearr_36554_36709 = state_36400__$1;
(statearr_36554_36709[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (52))){
var state_36400__$1 = state_36400;
var statearr_36555_36710 = state_36400__$1;
(statearr_36555_36710[(2)] = false);

(statearr_36555_36710[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (67))){
var state_36400__$1 = state_36400;
var statearr_36556_36711 = state_36400__$1;
(statearr_36556_36711[(2)] = null);

(statearr_36556_36711[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (71))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36557_36712 = state_36400__$1;
(statearr_36557_36712[(2)] = inst_36230);

(statearr_36557_36712[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (42))){
var inst_36119 = (state_36400[(15)]);
var inst_36130 = (state_36400[(21)]);
var inst_36218 = fluree.db.dbproto._p_prop(inst_36119,cljs.core.cst$kw$name,inst_36130);
var inst_36219 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36218)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_36220 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36221 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36222 = cljs.core.PersistentHashMap.fromArrays(inst_36220,inst_36221);
var inst_36223 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36219,inst_36222);
var inst_36224 = (function(){throw inst_36223})();
var state_36400__$1 = state_36400;
var statearr_36558_36713 = state_36400__$1;
(statearr_36558_36713[(2)] = inst_36224);

(statearr_36558_36713[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (80))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36301 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36559_36714 = state_36400__$1;
(statearr_36559_36714[(2)] = inst_36301);

(statearr_36559_36714[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (37))){
var inst_36215 = (state_36400[(2)]);
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36215)){
var statearr_36560_36715 = state_36400__$1;
(statearr_36560_36715[(1)] = (39));

} else {
var statearr_36561_36716 = state_36400__$1;
(statearr_36561_36716[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (63))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36272 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36562_36717 = state_36400__$1;
(statearr_36562_36717[(2)] = inst_36272);

(statearr_36562_36717[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (94))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36335 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_36336 = (inst_36263.cljs$core$IFn$_invoke$arity$5 ? inst_36263.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36335,null) : inst_36263.call(null,cljs.core.PersistentArrayMap,null,2,inst_36335,null));
var inst_36337 = (inst_36263.cljs$core$IFn$_invoke$arity$4 ? inst_36263.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36336,null) : inst_36263.call(null,cljs.core.PersistentHashSet,null,inst_36336,null));
var inst_36338 = (inst_36337.cljs$core$IFn$_invoke$arity$1 ? inst_36337.cljs$core$IFn$_invoke$arity$1(inst_36262) : inst_36337.call(null,inst_36262));
var state_36400__$1 = state_36400;
if(cljs.core.truth_(inst_36338)){
var statearr_36563_36718 = state_36400__$1;
(statearr_36563_36718[(1)] = (95));

} else {
var statearr_36564_36719 = state_36400__$1;
(statearr_36564_36719[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (8))){
var inst_36119 = (state_36400[(15)]);
var state_36400__$1 = state_36400;
var statearr_36565_36720 = state_36400__$1;
(statearr_36565_36720[(2)] = inst_36119);

(statearr_36565_36720[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (49))){
var inst_36230 = (state_36400[(11)]);
var state_36400__$1 = state_36400;
var statearr_36566_36721 = state_36400__$1;
(statearr_36566_36721[(2)] = inst_36230);

(statearr_36566_36721[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36401 === (84))){
var inst_36263 = (state_36400[(7)]);
var inst_36262 = (state_36400[(8)]);
var inst_36311 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36262,inst_36263,throw_QMARK_);
var state_36400__$1 = state_36400;
var statearr_36567_36722 = state_36400__$1;
(statearr_36567_36722[(2)] = inst_36311);

(statearr_36567_36722[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16301__auto__ = null;
var fluree$db$query$schema$state_machine__16301__auto____0 = (function (){
var statearr_36568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36568[(0)] = fluree$db$query$schema$state_machine__16301__auto__);

(statearr_36568[(1)] = (1));

return statearr_36568;
});
var fluree$db$query$schema$state_machine__16301__auto____1 = (function (state_36400){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36400);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36569){var ex__16304__auto__ = e36569;
var statearr_36570_36723 = state_36400;
(statearr_36570_36723[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36400[(4)]))){
var statearr_36571_36724 = state_36400;
(statearr_36571_36724[(1)] = cljs.core.first((state_36400[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36725 = state_36400;
state_36400 = G__36725;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16301__auto__ = function(state_36400){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16301__auto____1.call(this,state_36400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16301__auto____0;
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16301__auto____1;
return fluree$db$query$schema$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36572 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36572[(6)] = c__16375__auto__);

return statearr_36572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36749){
var state_val_36750 = (state_36749[(1)]);
if((state_val_36750 === (7))){
var state_36749__$1 = state_36749;
var statearr_36751_36770 = state_36749__$1;
(statearr_36751_36770[(2)] = db);

(statearr_36751_36770[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (1))){
var state_36749__$1 = state_36749;
var statearr_36752_36771 = state_36749__$1;
(statearr_36752_36771[(2)] = null);

(statearr_36752_36771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (4))){
var inst_36726 = (state_36749[(2)]);
var state_36749__$1 = state_36749;
var statearr_36753_36772 = state_36749__$1;
(statearr_36753_36772[(2)] = inst_36726);

(statearr_36753_36772[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (6))){
var inst_36735 = (state_36749[(7)]);
var inst_36734 = (state_36749[(2)]);
var inst_36735__$1 = fluree.db.util.async.throw_err(inst_36734);
var inst_36736 = cljs.core.empty_QMARK_(inst_36735__$1);
var state_36749__$1 = (function (){var statearr_36754 = state_36749;
(statearr_36754[(7)] = inst_36735__$1);

return statearr_36754;
})();
if(inst_36736){
var statearr_36755_36773 = state_36749__$1;
(statearr_36755_36773[(1)] = (7));

} else {
var statearr_36756_36774 = state_36749__$1;
(statearr_36756_36774[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (3))){
var inst_36747 = (state_36749[(2)]);
var state_36749__$1 = state_36749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36749__$1,inst_36747);
} else {
if((state_val_36750 === (2))){
var _ = (function (){var statearr_36758 = state_36749;
(statearr_36758[(4)] = cljs.core.cons((5),(state_36749[(4)])));

return statearr_36758;
})();
var inst_36732 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_36749__$1 = state_36749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36749__$1,(6),inst_36732);
} else {
if((state_val_36750 === (9))){
var inst_36744 = (state_36749[(2)]);
var _ = (function (){var statearr_36759 = state_36749;
(statearr_36759[(4)] = cljs.core.rest((state_36749[(4)])));

return statearr_36759;
})();
var state_36749__$1 = state_36749;
var statearr_36760_36775 = state_36749__$1;
(statearr_36760_36775[(2)] = inst_36744);

(statearr_36760_36775[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (5))){
var _ = (function (){var statearr_36761 = state_36749;
(statearr_36761[(4)] = cljs.core.rest((state_36749[(4)])));

return statearr_36761;
})();
var state_36749__$1 = state_36749;
var ex36757 = (state_36749__$1[(2)]);
var statearr_36762_36776 = state_36749__$1;
(statearr_36762_36776[(5)] = ex36757);


if((ex36757 instanceof Error)){
var statearr_36763_36777 = state_36749__$1;
(statearr_36763_36777[(1)] = (4));

(statearr_36763_36777[(5)] = null);

} else {
throw ex36757;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (10))){
var inst_36741 = (state_36749[(2)]);
var inst_36742 = fluree.db.util.async.throw_err(inst_36741);
var state_36749__$1 = state_36749;
var statearr_36764_36778 = state_36749__$1;
(statearr_36764_36778[(2)] = inst_36742);

(statearr_36764_36778[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36750 === (8))){
var inst_36735 = (state_36749[(7)]);
var inst_36739 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_36735,db,true);
var state_36749__$1 = state_36749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36749__$1,(10),inst_36739);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0 = (function (){
var statearr_36765 = [null,null,null,null,null,null,null,null];
(statearr_36765[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__);

(statearr_36765[(1)] = (1));

return statearr_36765;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1 = (function (state_36749){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36749);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36766){var ex__16304__auto__ = e36766;
var statearr_36767_36779 = state_36749;
(statearr_36767_36779[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36749[(4)]))){
var statearr_36768_36780 = state_36749;
(statearr_36768_36780[(1)] = cljs.core.first((state_36749[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36781 = state_36749;
state_36749 = G__36781;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = function(state_36749){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1.call(this,state_36749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36769 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36769[(6)] = c__16375__auto__);

return statearr_36769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__36783 = arguments.length;
switch (G__36783) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__36785 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__36788_SHARP_,p2__36789_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36788_SHARP_,p2__36789_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36855){
var state_val_36856 = (state_36855[(1)]);
if((state_val_36856 === (1))){
var state_36855__$1 = state_36855;
var statearr_36857_36875 = state_36855__$1;
(statearr_36857_36875[(2)] = null);

(statearr_36857_36875[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36856 === (2))){
var _ = (function (){var statearr_36858 = state_36855;
(statearr_36858[(4)] = cljs.core.cons((5),(state_36855[(4)])));

return statearr_36858;
})();
var inst_36807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36808 = fluree.db.flake.max_subject_id((1));
var inst_36809 = [inst_36808];
var inst_36810 = (new cljs.core.PersistentVector(null,1,(5),inst_36807,inst_36809,null));
var inst_36811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36812 = [(0)];
var inst_36813 = (new cljs.core.PersistentVector(null,1,(5),inst_36811,inst_36812,null));
var inst_36814 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_36810,cljs.core._LT__EQ_,inst_36813);
var state_36855__$1 = state_36855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36855__$1,(6),inst_36814);
} else {
if((state_val_36856 === (3))){
var inst_36853 = (state_36855[(2)]);
var state_36855__$1 = state_36855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36855__$1,inst_36853);
} else {
if((state_val_36856 === (4))){
var inst_36795 = (state_36855[(2)]);
var state_36855__$1 = state_36855;
var statearr_36860_36876 = state_36855__$1;
(statearr_36860_36876[(2)] = inst_36795);

(statearr_36860_36876[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36856 === (5))){
var _ = (function (){var statearr_36861 = state_36855;
(statearr_36861[(4)] = cljs.core.rest((state_36855[(4)])));

return statearr_36861;
})();
var state_36855__$1 = state_36855;
var ex36859 = (state_36855__$1[(2)]);
var statearr_36862_36877 = state_36855__$1;
(statearr_36862_36877[(5)] = ex36859);


if((ex36859 instanceof Error)){
var statearr_36863_36878 = state_36855__$1;
(statearr_36863_36878[(1)] = (4));

(statearr_36863_36878[(5)] = null);

} else {
throw ex36859;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36856 === (6))){
var inst_36816 = (state_36855[(2)]);
var inst_36817 = fluree.db.util.async.throw_err(inst_36816);
var inst_36818 = (function (){var schema_flakes = inst_36817;
return (function (p1__36790_SHARP_){
return (p1__36790_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_36819 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36818,inst_36817);
var inst_36820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36819,(0),null);
var inst_36821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36819,(1),null);
var inst_36822 = (function (){var schema_flakes = inst_36817;
var vec__36801 = inst_36819;
var collection_flakes = inst_36820;
var predicate_flakes = inst_36821;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36792_SHARP_,p2__36793_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__36792_SHARP_,p2__36793_SHARP_.p,p2__36793_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_36823 = [(-1),"_tx"];
var inst_36824 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36825 = ["_tx",(-1),(-1)];
var inst_36826 = cljs.core.PersistentHashMap.fromArrays(inst_36824,inst_36825);
var inst_36827 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36828 = ["_tx",(-1),(-1)];
var inst_36829 = cljs.core.PersistentHashMap.fromArrays(inst_36827,inst_36828);
var inst_36830 = [inst_36826,inst_36829];
var inst_36831 = cljs.core.PersistentHashMap.fromArrays(inst_36823,inst_36830);
var inst_36832 = (function (){var schema_flakes = inst_36817;
var vec__36801 = inst_36819;
var collection_flakes = inst_36820;
var predicate_flakes = inst_36821;
return (function (p1__36791_SHARP_){
return p1__36791_SHARP_.s;
});
})();
var inst_36833 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36832,inst_36820);
var inst_36834 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36822,inst_36831,inst_36833);
var inst_36836 = (function (){var schema_flakes = inst_36817;
var vec__36801 = inst_36819;
var collection_flakes = inst_36820;
var predicate_flakes = inst_36821;
var coll = inst_36834;
return (function (p__36835,pred_flakes){
var vec__36864 = p__36835;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36864,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36864,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__36867 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__36867.cljs$core$IFn$_invoke$arity$1 ? fexpr__36867.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__36867.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_36837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36838 = cljs.core.PersistentHashMap.EMPTY;
var inst_36839 = cljs.core.PersistentHashSet.EMPTY;
var inst_36840 = [inst_36838,inst_36839];
var inst_36841 = (new cljs.core.PersistentVector(null,2,(5),inst_36837,inst_36840,null));
var inst_36842 = (function (){var schema_flakes = inst_36817;
var vec__36801 = inst_36819;
var collection_flakes = inst_36820;
var predicate_flakes = inst_36821;
var coll = inst_36834;
return (function (p1__36794_SHARP_){
return p1__36794_SHARP_.s;
});
})();
var inst_36843 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36842,inst_36821);
var inst_36844 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36836,inst_36841,inst_36843);
var inst_36845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36844,(0),null);
var inst_36846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36844,(1),null);
var inst_36847 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_36848 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36849 = [inst_36848,inst_36834,inst_36845,inst_36846];
var inst_36850 = cljs.core.PersistentHashMap.fromArrays(inst_36847,inst_36849);
var _ = (function (){var statearr_36868 = state_36855;
(statearr_36868[(4)] = cljs.core.rest((state_36855[(4)])));

return statearr_36868;
})();
var state_36855__$1 = state_36855;
var statearr_36869_36879 = state_36855__$1;
(statearr_36869_36879[(2)] = inst_36850);

(statearr_36869_36879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0 = (function (){
var statearr_36870 = [null,null,null,null,null,null,null];
(statearr_36870[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16301__auto__);

(statearr_36870[(1)] = (1));

return statearr_36870;
});
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1 = (function (state_36855){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36855);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36871){var ex__16304__auto__ = e36871;
var statearr_36872_36880 = state_36855;
(statearr_36872_36880[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36855[(4)]))){
var statearr_36873_36881 = state_36855;
(statearr_36873_36881[(1)] = cljs.core.first((state_36855[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36882 = state_36855;
state_36855 = G__36882;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = function(state_36855){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1.call(this,state_36855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36874 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36874[(6)] = c__16375__auto__);

return statearr_36874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36924){
var state_val_36925 = (state_36924[(1)]);
if((state_val_36925 === (7))){
var inst_36907 = (state_36924[(2)]);
var inst_36908 = fluree.db.query.schema.flake__GT_pred_map(inst_36907);
var inst_36909 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_36910 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(114));
var inst_36911 = cljs.core.boolean$(inst_36910);
var inst_36912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(110));
var inst_36913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(117));
var inst_36914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_36913);
var inst_36915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(111));
var inst_36916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(115));
var inst_36917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36908,(112));
var inst_36918 = [inst_36911,inst_36912,inst_36914,inst_36915,inst_36916,inst_36917];
var inst_36919 = cljs.core.PersistentHashMap.fromArrays(inst_36909,inst_36918);
var _ = (function (){var statearr_36926 = state_36924;
(statearr_36926[(4)] = cljs.core.rest((state_36924[(4)])));

return statearr_36926;
})();
var state_36924__$1 = state_36924;
var statearr_36927_36950 = state_36924__$1;
(statearr_36927_36950[(2)] = inst_36919);

(statearr_36927_36950[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (1))){
var state_36924__$1 = state_36924;
var statearr_36928_36951 = state_36924__$1;
(statearr_36928_36951[(2)] = null);

(statearr_36928_36951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (4))){
var inst_36883 = (state_36924[(2)]);
var state_36924__$1 = state_36924;
var statearr_36929_36952 = state_36924__$1;
(statearr_36929_36952[(2)] = inst_36883);

(statearr_36929_36952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (6))){
var _ = (function (){var statearr_36930 = state_36924;
(statearr_36930[(4)] = cljs.core.cons((9),(state_36924[(4)])));

return statearr_36930;
})();
var inst_36895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36897 = ["_setting/id","root"];
var inst_36898 = (new cljs.core.PersistentVector(null,2,(5),inst_36896,inst_36897,null));
var inst_36899 = [inst_36898];
var inst_36900 = (new cljs.core.PersistentVector(null,1,(5),inst_36895,inst_36899,null));
var inst_36901 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36900);
var state_36924__$1 = state_36924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36924__$1,(10),inst_36901);
} else {
if((state_val_36925 === (3))){
var inst_36922 = (state_36924[(2)]);
var state_36924__$1 = state_36924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36924__$1,inst_36922);
} else {
if((state_val_36925 === (2))){
var _ = (function (){var statearr_36933 = state_36924;
(statearr_36933[(4)] = cljs.core.cons((5),(state_36924[(4)])));

return statearr_36933;
})();
var state_36924__$1 = state_36924;
var statearr_36934_36953 = state_36924__$1;
(statearr_36934_36953[(2)] = null);

(statearr_36934_36953[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (9))){
var _ = (function (){var statearr_36935 = state_36924;
(statearr_36935[(4)] = cljs.core.rest((state_36924[(4)])));

return statearr_36935;
})();
var state_36924__$1 = state_36924;
var ex36931 = (state_36924__$1[(2)]);
var statearr_36936_36954 = state_36924__$1;
(statearr_36936_36954[(5)] = ex36931);


var statearr_36937_36955 = state_36924__$1;
(statearr_36937_36955[(1)] = (8));

(statearr_36937_36955[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (5))){
var _ = (function (){var statearr_36938 = state_36924;
(statearr_36938[(4)] = cljs.core.rest((state_36924[(4)])));

return statearr_36938;
})();
var state_36924__$1 = state_36924;
var ex36932 = (state_36924__$1[(2)]);
var statearr_36939_36956 = state_36924__$1;
(statearr_36939_36956[(5)] = ex36932);


if((ex36932 instanceof Error)){
var statearr_36940_36957 = state_36924__$1;
(statearr_36940_36957[(1)] = (4));

(statearr_36940_36957[(5)] = null);

} else {
throw ex36932;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (10))){
var inst_36903 = (state_36924[(2)]);
var inst_36904 = fluree.db.util.async.throw_err(inst_36903);
var _ = (function (){var statearr_36941 = state_36924;
(statearr_36941[(4)] = cljs.core.rest((state_36924[(4)])));

return statearr_36941;
})();
var state_36924__$1 = state_36924;
var statearr_36942_36958 = state_36924__$1;
(statearr_36942_36958[(2)] = inst_36904);

(statearr_36942_36958[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36925 === (8))){
var inst_36889 = (state_36924[(2)]);
var state_36924__$1 = (function (){var statearr_36943 = state_36924;
(statearr_36943[(7)] = inst_36889);

return statearr_36943;
})();
var statearr_36944_36959 = state_36924__$1;
(statearr_36944_36959[(2)] = null);

(statearr_36944_36959[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0 = (function (){
var statearr_36945 = [null,null,null,null,null,null,null,null];
(statearr_36945[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16301__auto__);

(statearr_36945[(1)] = (1));

return statearr_36945;
});
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1 = (function (state_36924){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36924);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36946){var ex__16304__auto__ = e36946;
var statearr_36947_36960 = state_36924;
(statearr_36947_36960[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36924[(4)]))){
var statearr_36948_36961 = state_36924;
(statearr_36948_36961[(1)] = cljs.core.first((state_36924[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36962 = state_36924;
state_36924 = G__36962;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = function(state_36924){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1.call(this,state_36924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36949 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36949[(6)] = c__16375__auto__);

return statearr_36949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
