// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__11312 = s;
var map__11312__$1 = (((((!((map__11312 == null))))?(((((map__11312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11312.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11312):map__11312);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11312__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11312__$1,cljs.core.cst$kw$info);
var d = (0);
var G__11315 = info;
var map__11316 = G__11315;
var map__11316__$1 = (((((!((map__11316 == null))))?(((((map__11316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11316.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11316):map__11316);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11316__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__11315__$1 = G__11315;
while(true){
var d__$2 = d__$1;
var map__11320 = G__11315__$1;
var map__11320__$1 = (((((!((map__11320 == null))))?(((((map__11320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11320):map__11320);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11320__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__11322 = (d__$2 + (1));
var G__11323 = shadow__$1;
d__$1 = G__11322;
G__11315__$1 = G__11323;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__11324){
var map__11325 = p__11324;
var map__11325__$1 = (((((!((map__11325 == null))))?(((((map__11325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11325.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11325):map__11325);
var name_var = map__11325__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11325__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11325__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__11327 = info;
var map__11327__$1 = (((((!((map__11327 == null))))?(((((map__11327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11327.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11327):map__11327);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11327__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11327__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__11329 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__11329) : cljs.compiler.munge.call(null,G__11329));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__11331 = arguments.length;
switch (G__11331) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__11332 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11501,11501,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__11332.cljs$core$IFn$_invoke$arity$1 ? fexpr__11332.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__11332.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__11334 = cp;
switch (G__11334) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__11336_11340 = cljs.core.seq(s);
var chunk__11337_11341 = null;
var count__11338_11342 = (0);
var i__11339_11343 = (0);
while(true){
if((i__11339_11343 < count__11338_11342)){
var c_11344 = chunk__11337_11341.cljs$core$IIndexed$_nth$arity$2(null,i__11339_11343);
sb.append(cljs.compiler.escape_char(c_11344));


var G__11345 = seq__11336_11340;
var G__11346 = chunk__11337_11341;
var G__11347 = count__11338_11342;
var G__11348 = (i__11339_11343 + (1));
seq__11336_11340 = G__11345;
chunk__11337_11341 = G__11346;
count__11338_11342 = G__11347;
i__11339_11343 = G__11348;
continue;
} else {
var temp__5735__auto___11349 = cljs.core.seq(seq__11336_11340);
if(temp__5735__auto___11349){
var seq__11336_11350__$1 = temp__5735__auto___11349;
if(cljs.core.chunked_seq_QMARK_(seq__11336_11350__$1)){
var c__4556__auto___11351 = cljs.core.chunk_first(seq__11336_11350__$1);
var G__11352 = cljs.core.chunk_rest(seq__11336_11350__$1);
var G__11353 = c__4556__auto___11351;
var G__11354 = cljs.core.count(c__4556__auto___11351);
var G__11355 = (0);
seq__11336_11340 = G__11352;
chunk__11337_11341 = G__11353;
count__11338_11342 = G__11354;
i__11339_11343 = G__11355;
continue;
} else {
var c_11356 = cljs.core.first(seq__11336_11350__$1);
sb.append(cljs.compiler.escape_char(c_11356));


var G__11357 = cljs.core.next(seq__11336_11350__$1);
var G__11358 = null;
var G__11359 = (0);
var G__11360 = (0);
seq__11336_11340 = G__11357;
chunk__11337_11341 = G__11358;
count__11338_11342 = G__11359;
i__11339_11343 = G__11360;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11361 = cljs.core.get_global_hierarchy;
return (fexpr__11361.cljs$core$IFn$_invoke$arity$0 ? fexpr__11361.cljs$core$IFn$_invoke$arity$0() : fexpr__11361.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__11362_11369 = ast;
var map__11362_11370__$1 = (((((!((map__11362_11369 == null))))?(((((map__11362_11369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11362_11369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11362_11369):map__11362_11369);
var env_11371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11362_11370__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_11371))){
var map__11364_11372 = env_11371;
var map__11364_11373__$1 = (((((!((map__11364_11372 == null))))?(((((map__11364_11372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11364_11372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11364_11372):map__11364_11372);
var line_11374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11364_11373__$1,cljs.core.cst$kw$line);
var column_11375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11364_11373__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__11366 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__11368 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__11367 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__11367.cljs$core$IFn$_invoke$arity$1 ? fexpr__11367.cljs$core$IFn$_invoke$arity$1(G__11368) : fexpr__11367.call(null,G__11368));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__11366,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__11366;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_11374 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_11375)?(column_11375 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__11384 = arguments.length;
switch (G__11384) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___11391 = arguments.length;
var i__4737__auto___11392 = (0);
while(true){
if((i__4737__auto___11392 < len__4736__auto___11391)){
args_arr__4757__auto__.push((arguments[i__4737__auto___11392]));

var G__11393 = (i__4737__auto___11392 + (1));
i__4737__auto___11392 = G__11393;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_11394 = (function (){var G__11385 = a;
if((!(typeof a === 'string'))){
return G__11385.toString();
} else {
return G__11385;
}
})();
var temp__5739__auto___11395 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___11395 == null)){
} else {
var sm_data_11396 = temp__5739__auto___11395;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_11396,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__11376_SHARP_){
return (p1__11376_SHARP_ + s_11394.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_11394], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11386 = cljs.core.seq(xs);
var chunk__11387 = null;
var count__11388 = (0);
var i__11389 = (0);
while(true){
if((i__11389 < count__11388)){
var x = chunk__11387.cljs$core$IIndexed$_nth$arity$2(null,i__11389);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11397 = seq__11386;
var G__11398 = chunk__11387;
var G__11399 = count__11388;
var G__11400 = (i__11389 + (1));
seq__11386 = G__11397;
chunk__11387 = G__11398;
count__11388 = G__11399;
i__11389 = G__11400;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__11386);
if(temp__5735__auto__){
var seq__11386__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11386__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__11386__$1);
var G__11401 = cljs.core.chunk_rest(seq__11386__$1);
var G__11402 = c__4556__auto__;
var G__11403 = cljs.core.count(c__4556__auto__);
var G__11404 = (0);
seq__11386 = G__11401;
chunk__11387 = G__11402;
count__11388 = G__11403;
i__11389 = G__11404;
continue;
} else {
var x = cljs.core.first(seq__11386__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11405 = cljs.core.next(seq__11386__$1);
var G__11406 = null;
var G__11407 = (0);
var G__11408 = (0);
seq__11386 = G__11405;
chunk__11387 = G__11406;
count__11388 = G__11407;
i__11389 = G__11408;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq11378){
var G__11379 = cljs.core.first(seq11378);
var seq11378__$1 = cljs.core.next(seq11378);
var G__11380 = cljs.core.first(seq11378__$1);
var seq11378__$2 = cljs.core.next(seq11378__$1);
var G__11381 = cljs.core.first(seq11378__$2);
var seq11378__$3 = cljs.core.next(seq11378__$2);
var G__11382 = cljs.core.first(seq11378__$3);
var seq11378__$4 = cljs.core.next(seq11378__$3);
var G__11383 = cljs.core.first(seq11378__$4);
var seq11378__$5 = cljs.core.next(seq11378__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11379,G__11380,G__11381,G__11382,G__11383,seq11378__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__11409){
var map__11410 = p__11409;
var map__11410__$1 = (((((!((map__11410 == null))))?(((((map__11410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11410):map__11410);
var m = map__11410__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11410__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__11419 = arguments.length;
switch (G__11419) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___11425 = arguments.length;
var i__4737__auto___11426 = (0);
while(true){
if((i__4737__auto___11426 < len__4736__auto___11425)){
args_arr__4757__auto__.push((arguments[i__4737__auto___11426]));

var G__11427 = (i__4737__auto___11426 + (1));
i__4737__auto___11426 = G__11427;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11420_11428 = cljs.core.seq(xs);
var chunk__11421_11429 = null;
var count__11422_11430 = (0);
var i__11423_11431 = (0);
while(true){
if((i__11423_11431 < count__11422_11430)){
var x_11432 = chunk__11421_11429.cljs$core$IIndexed$_nth$arity$2(null,i__11423_11431);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11432);


var G__11433 = seq__11420_11428;
var G__11434 = chunk__11421_11429;
var G__11435 = count__11422_11430;
var G__11436 = (i__11423_11431 + (1));
seq__11420_11428 = G__11433;
chunk__11421_11429 = G__11434;
count__11422_11430 = G__11435;
i__11423_11431 = G__11436;
continue;
} else {
var temp__5735__auto___11437 = cljs.core.seq(seq__11420_11428);
if(temp__5735__auto___11437){
var seq__11420_11438__$1 = temp__5735__auto___11437;
if(cljs.core.chunked_seq_QMARK_(seq__11420_11438__$1)){
var c__4556__auto___11439 = cljs.core.chunk_first(seq__11420_11438__$1);
var G__11440 = cljs.core.chunk_rest(seq__11420_11438__$1);
var G__11441 = c__4556__auto___11439;
var G__11442 = cljs.core.count(c__4556__auto___11439);
var G__11443 = (0);
seq__11420_11428 = G__11440;
chunk__11421_11429 = G__11441;
count__11422_11430 = G__11442;
i__11423_11431 = G__11443;
continue;
} else {
var x_11444 = cljs.core.first(seq__11420_11438__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11444);


var G__11445 = cljs.core.next(seq__11420_11438__$1);
var G__11446 = null;
var G__11447 = (0);
var G__11448 = (0);
seq__11420_11428 = G__11445;
chunk__11421_11429 = G__11446;
count__11422_11430 = G__11447;
i__11423_11431 = G__11448;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq11413){
var G__11414 = cljs.core.first(seq11413);
var seq11413__$1 = cljs.core.next(seq11413);
var G__11415 = cljs.core.first(seq11413__$1);
var seq11413__$2 = cljs.core.next(seq11413__$1);
var G__11416 = cljs.core.first(seq11413__$2);
var seq11413__$3 = cljs.core.next(seq11413__$2);
var G__11417 = cljs.core.first(seq11413__$3);
var seq11413__$4 = cljs.core.next(seq11413__$3);
var G__11418 = cljs.core.first(seq11413__$4);
var seq11413__$5 = cljs.core.next(seq11413__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11414,G__11415,G__11416,G__11417,G__11418,seq11413__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__11449_11453 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__11450_11454 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__11451_11455 = true;
var _STAR_print_fn_STAR__temp_val__11452_11456 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__11451_11455);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__11452_11456);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__11450_11454);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__11449_11453);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11457 = cljs.core.get_global_hierarchy;
return (fexpr__11457.cljs$core$IFn$_invoke$arity$0 ? fexpr__11457.cljs$core$IFn$_invoke$arity$0() : fexpr__11457.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__11458 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11458,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11458,(1),null);
var G__11461 = ns;
var G__11462 = name;
var G__11463 = (function (){
var G__11464 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__11464) : cljs.compiler.emit_constant.call(null,G__11464));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__11461,G__11462,G__11463) : cljs.compiler.emit_record_value.call(null,G__11461,G__11462,G__11463));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__11465 = cljs.core.keys(x);
var G__11466 = cljs.core.vals(x);
var G__11467 = cljs.compiler.emit_constants_comma_sep;
var G__11468 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__11465,G__11466,G__11467,G__11468) : cljs.compiler.emit_map.call(null,G__11465,G__11466,G__11467,G__11468));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__11469 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__11470 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__11469,G__11470) : cljs.compiler.emit_with_meta.call(null,G__11469,G__11470));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__11471 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11471,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11471,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11471,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__11474 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11474) : x.call(null,G__11474));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__11475 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11475) : x.call(null,G__11475));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__11477 = items;
var G__11478 = (function (p1__11476_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__11476_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__11477,G__11478) : cljs.compiler.emit_js_object.call(null,G__11477,G__11478));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__11480){
var map__11481 = p__11480;
var map__11481__$1 = (((((!((map__11481 == null))))?(((((map__11481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11481):map__11481);
var ast = map__11481__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11481__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11481__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11481__$1,cljs.core.cst$kw$form);
var temp__5733__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__11483 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11483__$1 = (((((!((map__11483 == null))))?(((((map__11483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11483.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11483):map__11483);
var cenv = map__11483__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11483__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11485 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = (function (){var G__11488 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__11488) : cljs.compiler.es5_GT__EQ_.call(null,G__11488));
})();
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__11485,cljs.analyzer.es5_allowed);
} else {
return G__11485;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4126__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__11489 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__11489,reserved);
} else {
return G__11489;
}
})();
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__11490_11491 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__11490_11492__$1 = (((G__11490_11491 instanceof cljs.core.Keyword))?G__11490_11491.fqn:null);
switch (G__11490_11492__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__11494){
var map__11495 = p__11494;
var map__11495__$1 = (((((!((map__11495 == null))))?(((((map__11495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11495.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11495):map__11495);
var arg = map__11495__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11495__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11495__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11495__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11495__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11497 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__11497__$1 = (((((!((map__11497 == null))))?(((((map__11497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11497.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11497):map__11497);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11497__$1,cljs.core.cst$kw$name);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__11499){
var map__11500 = p__11499;
var map__11500__$1 = (((((!((map__11500 == null))))?(((((map__11500.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11500.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11500):map__11500);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11500__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11500__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11500__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__11502_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11502_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__11503 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11503) : comma_sep.call(null,G__11503));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__11504 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11504) : comma_sep.call(null,G__11504));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__11505){
var map__11506 = p__11505;
var map__11506__$1 = (((((!((map__11506 == null))))?(((((map__11506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11506):map__11506);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11506__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11506__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11506__$1,cljs.core.cst$kw$vals);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__11508){
var map__11509 = p__11508;
var map__11509__$1 = (((((!((map__11509 == null))))?(((((map__11509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11509):map__11509);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11509__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11509__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__11511_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11511_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__11512 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11512) : comma_sep.call(null,G__11512));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__11513){
var map__11514 = p__11513;
var map__11514__$1 = (((((!((map__11514 == null))))?(((((map__11514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11514):map__11514);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11514__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11514__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___11538 = cljs.core.seq(items);
if(temp__5735__auto___11538){
var items_11539__$1 = temp__5735__auto___11538;
var vec__11516_11540 = items_11539__$1;
var seq__11517_11541 = cljs.core.seq(vec__11516_11540);
var first__11518_11542 = cljs.core.first(seq__11517_11541);
var seq__11517_11543__$1 = cljs.core.next(seq__11517_11541);
var vec__11519_11544 = first__11518_11542;
var k_11545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11519_11544,(0),null);
var v_11546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11519_11544,(1),null);
var r_11547 = seq__11517_11543__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_11545),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11546) : emit_js_object_val.call(null,v_11546)));

var seq__11522_11548 = cljs.core.seq(r_11547);
var chunk__11523_11549 = null;
var count__11524_11550 = (0);
var i__11525_11551 = (0);
while(true){
if((i__11525_11551 < count__11524_11550)){
var vec__11532_11552 = chunk__11523_11549.cljs$core$IIndexed$_nth$arity$2(null,i__11525_11551);
var k_11553__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11532_11552,(0),null);
var v_11554__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11532_11552,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11553__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11554__$1) : emit_js_object_val.call(null,v_11554__$1)));


var G__11555 = seq__11522_11548;
var G__11556 = chunk__11523_11549;
var G__11557 = count__11524_11550;
var G__11558 = (i__11525_11551 + (1));
seq__11522_11548 = G__11555;
chunk__11523_11549 = G__11556;
count__11524_11550 = G__11557;
i__11525_11551 = G__11558;
continue;
} else {
var temp__5735__auto___11559__$1 = cljs.core.seq(seq__11522_11548);
if(temp__5735__auto___11559__$1){
var seq__11522_11560__$1 = temp__5735__auto___11559__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11522_11560__$1)){
var c__4556__auto___11561 = cljs.core.chunk_first(seq__11522_11560__$1);
var G__11562 = cljs.core.chunk_rest(seq__11522_11560__$1);
var G__11563 = c__4556__auto___11561;
var G__11564 = cljs.core.count(c__4556__auto___11561);
var G__11565 = (0);
seq__11522_11548 = G__11562;
chunk__11523_11549 = G__11563;
count__11524_11550 = G__11564;
i__11525_11551 = G__11565;
continue;
} else {
var vec__11535_11566 = cljs.core.first(seq__11522_11560__$1);
var k_11567__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11535_11566,(0),null);
var v_11568__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11535_11566,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11567__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11568__$1) : emit_js_object_val.call(null,v_11568__$1)));


var G__11569 = cljs.core.next(seq__11522_11560__$1);
var G__11570 = null;
var G__11571 = (0);
var G__11572 = (0);
seq__11522_11548 = G__11569;
chunk__11523_11549 = G__11570;
count__11524_11550 = G__11571;
i__11525_11551 = G__11572;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__11573){
var map__11574 = p__11573;
var map__11574__$1 = (((((!((map__11574 == null))))?(((((map__11574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11574):map__11574);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11574__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11574__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11574__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__11576){
var map__11577 = p__11576;
var map__11577__$1 = (((((!((map__11577 == null))))?(((((map__11577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11577):map__11577);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11577__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11577__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__11579){
var map__11580 = p__11579;
var map__11580__$1 = (((((!((map__11580 == null))))?(((((map__11580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11580.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11580):map__11580);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__11582){
var map__11583 = p__11582;
var map__11583__$1 = (((((!((map__11583 == null))))?(((((map__11583.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11583.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11583):map__11583);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11583__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11583__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__11585 = cljs.analyzer.unwrap_quote(expr);
var map__11585__$1 = (((((!((map__11585 == null))))?(((((map__11585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11585):map__11585);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11585__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11585__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11585__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__11587 = cljs.analyzer.unwrap_quote(expr);
var map__11587__$1 = (((((!((map__11587 == null))))?(((((map__11587.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11587.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11587):map__11587);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11587__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11587__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11587__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4126__auto__ = (function (){var fexpr__11590 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__11590.cljs$core$IFn$_invoke$arity$1 ? fexpr__11590.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11590.call(null,tag));
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__11591){
var map__11592 = p__11591;
var map__11592__$1 = (((((!((map__11592 == null))))?(((((map__11592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11592.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11592):map__11592);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11592__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11592__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11592__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11592__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11592__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__11594){
var map__11595 = p__11594;
var map__11595__$1 = (((((!((map__11595 == null))))?(((((map__11595.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11595.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11595):map__11595);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11595__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11595__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11595__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11595__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__11597_11633 = cljs.core.seq(nodes);
var chunk__11598_11634 = null;
var count__11599_11635 = (0);
var i__11600_11636 = (0);
while(true){
if((i__11600_11636 < count__11599_11635)){
var map__11617_11637 = chunk__11598_11634.cljs$core$IIndexed$_nth$arity$2(null,i__11600_11636);
var map__11617_11638__$1 = (((((!((map__11617_11637 == null))))?(((((map__11617_11637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11617_11637.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11617_11637):map__11617_11637);
var ts_11639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11617_11638__$1,cljs.core.cst$kw$tests);
var map__11618_11640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11617_11638__$1,cljs.core.cst$kw$then);
var map__11618_11641__$1 = (((((!((map__11618_11640 == null))))?(((((map__11618_11640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11618_11640.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11618_11640):map__11618_11640);
var then_11642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11618_11641__$1,cljs.core.cst$kw$then);
var seq__11621_11643 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11639));
var chunk__11622_11644 = null;
var count__11623_11645 = (0);
var i__11624_11646 = (0);
while(true){
if((i__11624_11646 < count__11623_11645)){
var test_11647 = chunk__11622_11644.cljs$core$IIndexed$_nth$arity$2(null,i__11624_11646);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11647,":");


var G__11648 = seq__11621_11643;
var G__11649 = chunk__11622_11644;
var G__11650 = count__11623_11645;
var G__11651 = (i__11624_11646 + (1));
seq__11621_11643 = G__11648;
chunk__11622_11644 = G__11649;
count__11623_11645 = G__11650;
i__11624_11646 = G__11651;
continue;
} else {
var temp__5735__auto___11652 = cljs.core.seq(seq__11621_11643);
if(temp__5735__auto___11652){
var seq__11621_11653__$1 = temp__5735__auto___11652;
if(cljs.core.chunked_seq_QMARK_(seq__11621_11653__$1)){
var c__4556__auto___11654 = cljs.core.chunk_first(seq__11621_11653__$1);
var G__11655 = cljs.core.chunk_rest(seq__11621_11653__$1);
var G__11656 = c__4556__auto___11654;
var G__11657 = cljs.core.count(c__4556__auto___11654);
var G__11658 = (0);
seq__11621_11643 = G__11655;
chunk__11622_11644 = G__11656;
count__11623_11645 = G__11657;
i__11624_11646 = G__11658;
continue;
} else {
var test_11659 = cljs.core.first(seq__11621_11653__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11659,":");


var G__11660 = cljs.core.next(seq__11621_11653__$1);
var G__11661 = null;
var G__11662 = (0);
var G__11663 = (0);
seq__11621_11643 = G__11660;
chunk__11622_11644 = G__11661;
count__11623_11645 = G__11662;
i__11624_11646 = G__11663;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11642);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11642);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11664 = seq__11597_11633;
var G__11665 = chunk__11598_11634;
var G__11666 = count__11599_11635;
var G__11667 = (i__11600_11636 + (1));
seq__11597_11633 = G__11664;
chunk__11598_11634 = G__11665;
count__11599_11635 = G__11666;
i__11600_11636 = G__11667;
continue;
} else {
var temp__5735__auto___11668 = cljs.core.seq(seq__11597_11633);
if(temp__5735__auto___11668){
var seq__11597_11669__$1 = temp__5735__auto___11668;
if(cljs.core.chunked_seq_QMARK_(seq__11597_11669__$1)){
var c__4556__auto___11670 = cljs.core.chunk_first(seq__11597_11669__$1);
var G__11671 = cljs.core.chunk_rest(seq__11597_11669__$1);
var G__11672 = c__4556__auto___11670;
var G__11673 = cljs.core.count(c__4556__auto___11670);
var G__11674 = (0);
seq__11597_11633 = G__11671;
chunk__11598_11634 = G__11672;
count__11599_11635 = G__11673;
i__11600_11636 = G__11674;
continue;
} else {
var map__11625_11675 = cljs.core.first(seq__11597_11669__$1);
var map__11625_11676__$1 = (((((!((map__11625_11675 == null))))?(((((map__11625_11675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11625_11675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11625_11675):map__11625_11675);
var ts_11677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11625_11676__$1,cljs.core.cst$kw$tests);
var map__11626_11678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11625_11676__$1,cljs.core.cst$kw$then);
var map__11626_11679__$1 = (((((!((map__11626_11678 == null))))?(((((map__11626_11678.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11626_11678.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11626_11678):map__11626_11678);
var then_11680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11626_11679__$1,cljs.core.cst$kw$then);
var seq__11629_11681 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11677));
var chunk__11630_11682 = null;
var count__11631_11683 = (0);
var i__11632_11684 = (0);
while(true){
if((i__11632_11684 < count__11631_11683)){
var test_11685 = chunk__11630_11682.cljs$core$IIndexed$_nth$arity$2(null,i__11632_11684);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11685,":");


var G__11686 = seq__11629_11681;
var G__11687 = chunk__11630_11682;
var G__11688 = count__11631_11683;
var G__11689 = (i__11632_11684 + (1));
seq__11629_11681 = G__11686;
chunk__11630_11682 = G__11687;
count__11631_11683 = G__11688;
i__11632_11684 = G__11689;
continue;
} else {
var temp__5735__auto___11690__$1 = cljs.core.seq(seq__11629_11681);
if(temp__5735__auto___11690__$1){
var seq__11629_11691__$1 = temp__5735__auto___11690__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11629_11691__$1)){
var c__4556__auto___11692 = cljs.core.chunk_first(seq__11629_11691__$1);
var G__11693 = cljs.core.chunk_rest(seq__11629_11691__$1);
var G__11694 = c__4556__auto___11692;
var G__11695 = cljs.core.count(c__4556__auto___11692);
var G__11696 = (0);
seq__11629_11681 = G__11693;
chunk__11630_11682 = G__11694;
count__11631_11683 = G__11695;
i__11632_11684 = G__11696;
continue;
} else {
var test_11697 = cljs.core.first(seq__11629_11691__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11697,":");


var G__11698 = cljs.core.next(seq__11629_11691__$1);
var G__11699 = null;
var G__11700 = (0);
var G__11701 = (0);
seq__11629_11681 = G__11698;
chunk__11630_11682 = G__11699;
count__11631_11683 = G__11700;
i__11632_11684 = G__11701;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11680);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11680);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11702 = cljs.core.next(seq__11597_11669__$1);
var G__11703 = null;
var G__11704 = (0);
var G__11705 = (0);
seq__11597_11633 = G__11702;
chunk__11598_11634 = G__11703;
count__11599_11635 = G__11704;
i__11600_11636 = G__11705;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__11706){
var map__11707 = p__11706;
var map__11707__$1 = (((((!((map__11707 == null))))?(((((map__11707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11707):map__11707);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11707__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11707__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11712 = env;
var G__11713 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11712,G__11713) : cljs.compiler.resolve_type.call(null,G__11712,G__11713));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__11714 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11714,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11714,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__11709_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__11709_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__11709_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__11717 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__11717,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__11717;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11720 = env;
var G__11721 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11720,G__11721) : cljs.compiler.resolve_type.call(null,G__11720,G__11721));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11722_SHARP_){
return cljs.compiler.resolve_type(env,p1__11722_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__11723 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11724 = cljs.core.seq(vec__11723);
var first__11725 = cljs.core.first(seq__11724);
var seq__11724__$1 = cljs.core.next(seq__11724);
var p = first__11725;
var first__11725__$1 = cljs.core.first(seq__11724__$1);
var seq__11724__$2 = cljs.core.next(seq__11724__$1);
var ts = first__11725__$1;
var first__11725__$2 = cljs.core.first(seq__11724__$2);
var seq__11724__$3 = cljs.core.next(seq__11724__$2);
var n = first__11725__$2;
var xs = seq__11724__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__11726 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11727 = cljs.core.seq(vec__11726);
var first__11728 = cljs.core.first(seq__11727);
var seq__11727__$1 = cljs.core.next(seq__11727);
var p = first__11728;
var first__11728__$1 = cljs.core.first(seq__11727__$1);
var seq__11727__$2 = cljs.core.next(seq__11727__$1);
var ts = first__11728__$1;
var xs = seq__11727__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__11730 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__11729 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__11729.cljs$core$IFn$_invoke$arity$1 ? fexpr__11729.cljs$core$IFn$_invoke$arity$1(G__11730) : fexpr__11729.call(null,G__11730));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__11733 = arguments.length;
switch (G__11733) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__11741 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11731_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__11731_SHARP_);
} else {
return p1__11731_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__11742 = cljs.core.seq(vec__11741);
var first__11743 = cljs.core.first(seq__11742);
var seq__11742__$1 = cljs.core.next(seq__11742);
var x = first__11743;
var ys = seq__11742__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__11744 = cljs.core.seq(ys);
var chunk__11745 = null;
var count__11746 = (0);
var i__11747 = (0);
while(true){
if((i__11747 < count__11746)){
var next_line = chunk__11745.cljs$core$IIndexed$_nth$arity$2(null,i__11747);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11753 = seq__11744;
var G__11754 = chunk__11745;
var G__11755 = count__11746;
var G__11756 = (i__11747 + (1));
seq__11744 = G__11753;
chunk__11745 = G__11754;
count__11746 = G__11755;
i__11747 = G__11756;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__11744);
if(temp__5735__auto__){
var seq__11744__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11744__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__11744__$1);
var G__11757 = cljs.core.chunk_rest(seq__11744__$1);
var G__11758 = c__4556__auto__;
var G__11759 = cljs.core.count(c__4556__auto__);
var G__11760 = (0);
seq__11744 = G__11757;
chunk__11745 = G__11758;
count__11746 = G__11759;
i__11747 = G__11760;
continue;
} else {
var next_line = cljs.core.first(seq__11744__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11761 = cljs.core.next(seq__11744__$1);
var G__11762 = null;
var G__11763 = (0);
var G__11764 = (0);
seq__11744 = G__11761;
chunk__11745 = G__11762;
count__11746 = G__11763;
i__11747 = G__11764;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__11748_11765 = cljs.core.seq(docs__$2);
var chunk__11749_11766 = null;
var count__11750_11767 = (0);
var i__11751_11768 = (0);
while(true){
if((i__11751_11768 < count__11750_11767)){
var e_11769 = chunk__11749_11766.cljs$core$IIndexed$_nth$arity$2(null,i__11751_11768);
if(cljs.core.truth_(e_11769)){
print_comment_lines(e_11769);
} else {
}


var G__11770 = seq__11748_11765;
var G__11771 = chunk__11749_11766;
var G__11772 = count__11750_11767;
var G__11773 = (i__11751_11768 + (1));
seq__11748_11765 = G__11770;
chunk__11749_11766 = G__11771;
count__11750_11767 = G__11772;
i__11751_11768 = G__11773;
continue;
} else {
var temp__5735__auto___11774 = cljs.core.seq(seq__11748_11765);
if(temp__5735__auto___11774){
var seq__11748_11775__$1 = temp__5735__auto___11774;
if(cljs.core.chunked_seq_QMARK_(seq__11748_11775__$1)){
var c__4556__auto___11776 = cljs.core.chunk_first(seq__11748_11775__$1);
var G__11777 = cljs.core.chunk_rest(seq__11748_11775__$1);
var G__11778 = c__4556__auto___11776;
var G__11779 = cljs.core.count(c__4556__auto___11776);
var G__11780 = (0);
seq__11748_11765 = G__11777;
chunk__11749_11766 = G__11778;
count__11750_11767 = G__11779;
i__11751_11768 = G__11780;
continue;
} else {
var e_11781 = cljs.core.first(seq__11748_11775__$1);
if(cljs.core.truth_(e_11781)){
print_comment_lines(e_11781);
} else {
}


var G__11782 = cljs.core.next(seq__11748_11775__$1);
var G__11783 = null;
var G__11784 = (0);
var G__11785 = (0);
seq__11748_11765 = G__11782;
chunk__11749_11766 = G__11783;
count__11750_11767 = G__11784;
i__11751_11768 = G__11785;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4115__auto__ = cljs.core.some((function (p1__11787_SHARP_){
return goog.string.startsWith(p1__11787_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none)){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__11788){
var map__11789 = p__11788;
var map__11789__$1 = (((((!((map__11789 == null))))?(((((map__11789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11789):map__11789);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11789__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__11791){
var map__11792 = p__11791;
var map__11792__$1 = (((((!((map__11792 == null))))?(((((map__11792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11792):map__11792);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11792__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11792__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11792__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__11794_11818 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__11795_11819 = null;
var count__11796_11820 = (0);
var i__11797_11821 = (0);
while(true){
if((i__11797_11821 < count__11796_11820)){
var vec__11804_11822 = chunk__11795_11819.cljs$core$IIndexed$_nth$arity$2(null,i__11797_11821);
var i_11823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11804_11822,(0),null);
var param_11824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11804_11822,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11824);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11825 = seq__11794_11818;
var G__11826 = chunk__11795_11819;
var G__11827 = count__11796_11820;
var G__11828 = (i__11797_11821 + (1));
seq__11794_11818 = G__11825;
chunk__11795_11819 = G__11826;
count__11796_11820 = G__11827;
i__11797_11821 = G__11828;
continue;
} else {
var temp__5735__auto___11829 = cljs.core.seq(seq__11794_11818);
if(temp__5735__auto___11829){
var seq__11794_11830__$1 = temp__5735__auto___11829;
if(cljs.core.chunked_seq_QMARK_(seq__11794_11830__$1)){
var c__4556__auto___11831 = cljs.core.chunk_first(seq__11794_11830__$1);
var G__11832 = cljs.core.chunk_rest(seq__11794_11830__$1);
var G__11833 = c__4556__auto___11831;
var G__11834 = cljs.core.count(c__4556__auto___11831);
var G__11835 = (0);
seq__11794_11818 = G__11832;
chunk__11795_11819 = G__11833;
count__11796_11820 = G__11834;
i__11797_11821 = G__11835;
continue;
} else {
var vec__11807_11836 = cljs.core.first(seq__11794_11830__$1);
var i_11837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11807_11836,(0),null);
var param_11838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11807_11836,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11838);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11839 = cljs.core.next(seq__11794_11830__$1);
var G__11840 = null;
var G__11841 = (0);
var G__11842 = (0);
seq__11794_11818 = G__11839;
chunk__11795_11819 = G__11840;
count__11796_11820 = G__11841;
i__11797_11821 = G__11842;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11810_11843 = cljs.core.seq(params);
var chunk__11811_11844 = null;
var count__11812_11845 = (0);
var i__11813_11846 = (0);
while(true){
if((i__11813_11846 < count__11812_11845)){
var param_11847 = chunk__11811_11844.cljs$core$IIndexed$_nth$arity$2(null,i__11813_11846);
cljs.compiler.emit(param_11847);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11847,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11848 = seq__11810_11843;
var G__11849 = chunk__11811_11844;
var G__11850 = count__11812_11845;
var G__11851 = (i__11813_11846 + (1));
seq__11810_11843 = G__11848;
chunk__11811_11844 = G__11849;
count__11812_11845 = G__11850;
i__11813_11846 = G__11851;
continue;
} else {
var temp__5735__auto___11852 = cljs.core.seq(seq__11810_11843);
if(temp__5735__auto___11852){
var seq__11810_11853__$1 = temp__5735__auto___11852;
if(cljs.core.chunked_seq_QMARK_(seq__11810_11853__$1)){
var c__4556__auto___11854 = cljs.core.chunk_first(seq__11810_11853__$1);
var G__11855 = cljs.core.chunk_rest(seq__11810_11853__$1);
var G__11856 = c__4556__auto___11854;
var G__11857 = cljs.core.count(c__4556__auto___11854);
var G__11858 = (0);
seq__11810_11843 = G__11855;
chunk__11811_11844 = G__11856;
count__11812_11845 = G__11857;
i__11813_11846 = G__11858;
continue;
} else {
var param_11859 = cljs.core.first(seq__11810_11853__$1);
cljs.compiler.emit(param_11859);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11859,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11860 = cljs.core.next(seq__11810_11853__$1);
var G__11861 = null;
var G__11862 = (0);
var G__11863 = (0);
seq__11810_11843 = G__11860;
chunk__11811_11844 = G__11861;
count__11812_11845 = G__11862;
i__11813_11846 = G__11863;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11814_11864 = cljs.core.seq(params);
var chunk__11815_11865 = null;
var count__11816_11866 = (0);
var i__11817_11867 = (0);
while(true){
if((i__11817_11867 < count__11816_11866)){
var param_11868 = chunk__11815_11865.cljs$core$IIndexed$_nth$arity$2(null,i__11817_11867);
cljs.compiler.emit(param_11868);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11868,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11869 = seq__11814_11864;
var G__11870 = chunk__11815_11865;
var G__11871 = count__11816_11866;
var G__11872 = (i__11817_11867 + (1));
seq__11814_11864 = G__11869;
chunk__11815_11865 = G__11870;
count__11816_11866 = G__11871;
i__11817_11867 = G__11872;
continue;
} else {
var temp__5735__auto___11873 = cljs.core.seq(seq__11814_11864);
if(temp__5735__auto___11873){
var seq__11814_11874__$1 = temp__5735__auto___11873;
if(cljs.core.chunked_seq_QMARK_(seq__11814_11874__$1)){
var c__4556__auto___11875 = cljs.core.chunk_first(seq__11814_11874__$1);
var G__11876 = cljs.core.chunk_rest(seq__11814_11874__$1);
var G__11877 = c__4556__auto___11875;
var G__11878 = cljs.core.count(c__4556__auto___11875);
var G__11879 = (0);
seq__11814_11864 = G__11876;
chunk__11815_11865 = G__11877;
count__11816_11866 = G__11878;
i__11817_11867 = G__11879;
continue;
} else {
var param_11880 = cljs.core.first(seq__11814_11874__$1);
cljs.compiler.emit(param_11880);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11880,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11881 = cljs.core.next(seq__11814_11874__$1);
var G__11882 = null;
var G__11883 = (0);
var G__11884 = (0);
seq__11814_11864 = G__11881;
chunk__11815_11865 = G__11882;
count__11816_11866 = G__11883;
i__11817_11867 = G__11884;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__11885 = cljs.core.seq(params);
var chunk__11886 = null;
var count__11887 = (0);
var i__11888 = (0);
while(true){
if((i__11888 < count__11887)){
var param = chunk__11886.cljs$core$IIndexed$_nth$arity$2(null,i__11888);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11889 = seq__11885;
var G__11890 = chunk__11886;
var G__11891 = count__11887;
var G__11892 = (i__11888 + (1));
seq__11885 = G__11889;
chunk__11886 = G__11890;
count__11887 = G__11891;
i__11888 = G__11892;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__11885);
if(temp__5735__auto__){
var seq__11885__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11885__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__11885__$1);
var G__11893 = cljs.core.chunk_rest(seq__11885__$1);
var G__11894 = c__4556__auto__;
var G__11895 = cljs.core.count(c__4556__auto__);
var G__11896 = (0);
seq__11885 = G__11893;
chunk__11886 = G__11894;
count__11887 = G__11895;
i__11888 = G__11896;
continue;
} else {
var param = cljs.core.first(seq__11885__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11897 = cljs.core.next(seq__11885__$1);
var G__11898 = null;
var G__11899 = (0);
var G__11900 = (0);
seq__11885 = G__11897;
chunk__11886 = G__11898;
count__11887 = G__11899;
i__11888 = G__11900;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__11901){
var map__11902 = p__11901;
var map__11902__$1 = (((((!((map__11902 == null))))?(((((map__11902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11902.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11902):map__11902);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11902__$1,cljs.core.cst$kw$recurs);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__11904){
var map__11905 = p__11904;
var map__11905__$1 = (((((!((map__11905 == null))))?(((((map__11905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11905.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11905):map__11905);
var f = map__11905__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11905__$1,cljs.core.cst$kw$recurs);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_11915__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11916 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11915__$1);
var delegate_name_11917 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11916),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_11917," = function (");

var seq__11907_11918 = cljs.core.seq(params);
var chunk__11908_11919 = null;
var count__11909_11920 = (0);
var i__11910_11921 = (0);
while(true){
if((i__11910_11921 < count__11909_11920)){
var param_11922 = chunk__11908_11919.cljs$core$IIndexed$_nth$arity$2(null,i__11910_11921);
cljs.compiler.emit(param_11922);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11922,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11923 = seq__11907_11918;
var G__11924 = chunk__11908_11919;
var G__11925 = count__11909_11920;
var G__11926 = (i__11910_11921 + (1));
seq__11907_11918 = G__11923;
chunk__11908_11919 = G__11924;
count__11909_11920 = G__11925;
i__11910_11921 = G__11926;
continue;
} else {
var temp__5735__auto___11927 = cljs.core.seq(seq__11907_11918);
if(temp__5735__auto___11927){
var seq__11907_11928__$1 = temp__5735__auto___11927;
if(cljs.core.chunked_seq_QMARK_(seq__11907_11928__$1)){
var c__4556__auto___11929 = cljs.core.chunk_first(seq__11907_11928__$1);
var G__11930 = cljs.core.chunk_rest(seq__11907_11928__$1);
var G__11931 = c__4556__auto___11929;
var G__11932 = cljs.core.count(c__4556__auto___11929);
var G__11933 = (0);
seq__11907_11918 = G__11930;
chunk__11908_11919 = G__11931;
count__11909_11920 = G__11932;
i__11910_11921 = G__11933;
continue;
} else {
var param_11934 = cljs.core.first(seq__11907_11928__$1);
cljs.compiler.emit(param_11934);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11934,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11935 = cljs.core.next(seq__11907_11928__$1);
var G__11936 = null;
var G__11937 = (0);
var G__11938 = (0);
seq__11907_11918 = G__11935;
chunk__11908_11919 = G__11936;
count__11909_11920 = G__11937;
i__11910_11921 = G__11938;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_11916," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_11939 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_11939,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_11917,".call(this,");

var seq__11911_11940 = cljs.core.seq(params);
var chunk__11912_11941 = null;
var count__11913_11942 = (0);
var i__11914_11943 = (0);
while(true){
if((i__11914_11943 < count__11913_11942)){
var param_11944 = chunk__11912_11941.cljs$core$IIndexed$_nth$arity$2(null,i__11914_11943);
cljs.compiler.emit(param_11944);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11944,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11945 = seq__11911_11940;
var G__11946 = chunk__11912_11941;
var G__11947 = count__11913_11942;
var G__11948 = (i__11914_11943 + (1));
seq__11911_11940 = G__11945;
chunk__11912_11941 = G__11946;
count__11913_11942 = G__11947;
i__11914_11943 = G__11948;
continue;
} else {
var temp__5735__auto___11949 = cljs.core.seq(seq__11911_11940);
if(temp__5735__auto___11949){
var seq__11911_11950__$1 = temp__5735__auto___11949;
if(cljs.core.chunked_seq_QMARK_(seq__11911_11950__$1)){
var c__4556__auto___11951 = cljs.core.chunk_first(seq__11911_11950__$1);
var G__11952 = cljs.core.chunk_rest(seq__11911_11950__$1);
var G__11953 = c__4556__auto___11951;
var G__11954 = cljs.core.count(c__4556__auto___11951);
var G__11955 = (0);
seq__11911_11940 = G__11952;
chunk__11912_11941 = G__11953;
count__11913_11942 = G__11954;
i__11914_11943 = G__11955;
continue;
} else {
var param_11956 = cljs.core.first(seq__11911_11950__$1);
cljs.compiler.emit(param_11956);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11956,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11957 = cljs.core.next(seq__11911_11950__$1);
var G__11958 = null;
var G__11959 = (0);
var G__11960 = (0);
seq__11911_11940 = G__11957;
chunk__11912_11941 = G__11958;
count__11913_11942 = G__11959;
i__11914_11943 = G__11960;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11916,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_11916,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_11915__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11916,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_11917,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11916,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__11964){
var map__11965 = p__11964;
var map__11965__$1 = (((((!((map__11965 == null))))?(((((map__11965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11965):map__11965);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11965__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11961_SHARP_){
var and__4115__auto__ = p1__11961_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__11961_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_12018__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_12019 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_12018__$1);
var maxparams_12020 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_12021 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12019),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_12022 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__11962_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__11962_SHARP_)));
}),cljs.core.seq(mmap_12021));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_12019," = null;");

var seq__11967_12023 = cljs.core.seq(ms_12022);
var chunk__11968_12024 = null;
var count__11969_12025 = (0);
var i__11970_12026 = (0);
while(true){
if((i__11970_12026 < count__11969_12025)){
var vec__11977_12027 = chunk__11968_12024.cljs$core$IIndexed$_nth$arity$2(null,i__11970_12026);
var n_12028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11977_12027,(0),null);
var meth_12029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11977_12027,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_12028," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12029))){
cljs.compiler.emit_variadic_fn_method(meth_12029);
} else {
cljs.compiler.emit_fn_method(meth_12029);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__12030 = seq__11967_12023;
var G__12031 = chunk__11968_12024;
var G__12032 = count__11969_12025;
var G__12033 = (i__11970_12026 + (1));
seq__11967_12023 = G__12030;
chunk__11968_12024 = G__12031;
count__11969_12025 = G__12032;
i__11970_12026 = G__12033;
continue;
} else {
var temp__5735__auto___12034 = cljs.core.seq(seq__11967_12023);
if(temp__5735__auto___12034){
var seq__11967_12035__$1 = temp__5735__auto___12034;
if(cljs.core.chunked_seq_QMARK_(seq__11967_12035__$1)){
var c__4556__auto___12036 = cljs.core.chunk_first(seq__11967_12035__$1);
var G__12037 = cljs.core.chunk_rest(seq__11967_12035__$1);
var G__12038 = c__4556__auto___12036;
var G__12039 = cljs.core.count(c__4556__auto___12036);
var G__12040 = (0);
seq__11967_12023 = G__12037;
chunk__11968_12024 = G__12038;
count__11969_12025 = G__12039;
i__11970_12026 = G__12040;
continue;
} else {
var vec__11980_12041 = cljs.core.first(seq__11967_12035__$1);
var n_12042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12041,(0),null);
var meth_12043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12041,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_12042," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12043))){
cljs.compiler.emit_variadic_fn_method(meth_12043);
} else {
cljs.compiler.emit_fn_method(meth_12043);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__12044 = cljs.core.next(seq__11967_12035__$1);
var G__12045 = null;
var G__12046 = (0);
var G__12047 = (0);
seq__11967_12023 = G__12044;
chunk__11968_12024 = G__12045;
count__11969_12025 = G__12046;
i__11970_12026 = G__12047;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12019," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_12020),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_12020)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_12020));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__11983_12048 = cljs.core.seq(ms_12022);
var chunk__11984_12049 = null;
var count__11985_12050 = (0);
var i__11986_12051 = (0);
while(true){
if((i__11986_12051 < count__11985_12050)){
var vec__11993_12052 = chunk__11984_12049.cljs$core$IIndexed$_nth$arity$2(null,i__11986_12051);
var n_12053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11993_12052,(0),null);
var meth_12054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11993_12052,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12054))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_12055 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_12055," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_12056 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_12055," = new cljs.core.IndexedSeq(",a_12056,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_12053,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_12020)),(((cljs.core.count(maxparams_12020) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_12055,");"], 0));
} else {
var pcnt_12057 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12054));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_12057,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_12053,".call(this",(((pcnt_12057 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_12057,maxparams_12020)),null,(1),null)),(2),null))),");");
}


var G__12058 = seq__11983_12048;
var G__12059 = chunk__11984_12049;
var G__12060 = count__11985_12050;
var G__12061 = (i__11986_12051 + (1));
seq__11983_12048 = G__12058;
chunk__11984_12049 = G__12059;
count__11985_12050 = G__12060;
i__11986_12051 = G__12061;
continue;
} else {
var temp__5735__auto___12062 = cljs.core.seq(seq__11983_12048);
if(temp__5735__auto___12062){
var seq__11983_12063__$1 = temp__5735__auto___12062;
if(cljs.core.chunked_seq_QMARK_(seq__11983_12063__$1)){
var c__4556__auto___12064 = cljs.core.chunk_first(seq__11983_12063__$1);
var G__12065 = cljs.core.chunk_rest(seq__11983_12063__$1);
var G__12066 = c__4556__auto___12064;
var G__12067 = cljs.core.count(c__4556__auto___12064);
var G__12068 = (0);
seq__11983_12048 = G__12065;
chunk__11984_12049 = G__12066;
count__11985_12050 = G__12067;
i__11986_12051 = G__12068;
continue;
} else {
var vec__11996_12069 = cljs.core.first(seq__11983_12063__$1);
var n_12070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11996_12069,(0),null);
var meth_12071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11996_12069,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12071))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_12072 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_12072," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_12073 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_12072," = new cljs.core.IndexedSeq(",a_12073,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_12070,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_12020)),(((cljs.core.count(maxparams_12020) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_12072,");"], 0));
} else {
var pcnt_12074 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12071));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_12074,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_12070,".call(this",(((pcnt_12074 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_12074,maxparams_12020)),null,(1),null)),(2),null))),");");
}


var G__12075 = cljs.core.next(seq__11983_12063__$1);
var G__12076 = null;
var G__12077 = (0);
var G__12078 = (0);
seq__11983_12048 = G__12075;
chunk__11984_12049 = G__12076;
count__11985_12050 = G__12077;
i__11986_12051 = G__12078;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_12079 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_12022)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_12079,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12019,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12019,".cljs$lang$applyTo = ",cljs.core.some((function (p1__11963_SHARP_){
var vec__11999 = p1__11963_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11999,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11999,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_12022),".cljs$lang$applyTo;");
} else {
}

var seq__12002_12080 = cljs.core.seq(ms_12022);
var chunk__12003_12081 = null;
var count__12004_12082 = (0);
var i__12005_12083 = (0);
while(true){
if((i__12005_12083 < count__12004_12082)){
var vec__12012_12084 = chunk__12003_12081.cljs$core$IIndexed$_nth$arity$2(null,i__12005_12083);
var n_12085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12012_12084,(0),null);
var meth_12086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12012_12084,(1),null);
var c_12087 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12086));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12086))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12019,".cljs$core$IFn$_invoke$arity$variadic = ",n_12085,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_12019,".cljs$core$IFn$_invoke$arity$",c_12087," = ",n_12085,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__12088 = seq__12002_12080;
var G__12089 = chunk__12003_12081;
var G__12090 = count__12004_12082;
var G__12091 = (i__12005_12083 + (1));
seq__12002_12080 = G__12088;
chunk__12003_12081 = G__12089;
count__12004_12082 = G__12090;
i__12005_12083 = G__12091;
continue;
} else {
var temp__5735__auto___12092 = cljs.core.seq(seq__12002_12080);
if(temp__5735__auto___12092){
var seq__12002_12093__$1 = temp__5735__auto___12092;
if(cljs.core.chunked_seq_QMARK_(seq__12002_12093__$1)){
var c__4556__auto___12094 = cljs.core.chunk_first(seq__12002_12093__$1);
var G__12095 = cljs.core.chunk_rest(seq__12002_12093__$1);
var G__12096 = c__4556__auto___12094;
var G__12097 = cljs.core.count(c__4556__auto___12094);
var G__12098 = (0);
seq__12002_12080 = G__12095;
chunk__12003_12081 = G__12096;
count__12004_12082 = G__12097;
i__12005_12083 = G__12098;
continue;
} else {
var vec__12015_12099 = cljs.core.first(seq__12002_12093__$1);
var n_12100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12015_12099,(0),null);
var meth_12101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12015_12099,(1),null);
var c_12102 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12101));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12101))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12019,".cljs$core$IFn$_invoke$arity$variadic = ",n_12100,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_12019,".cljs$core$IFn$_invoke$arity$",c_12102," = ",n_12100,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__12103 = cljs.core.next(seq__12002_12093__$1);
var G__12104 = null;
var G__12105 = (0);
var G__12106 = (0);
seq__12002_12080 = G__12103;
chunk__12003_12081 = G__12104;
count__12004_12082 = G__12105;
i__12005_12083 = G__12106;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_12019,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__12107){
var map__12108 = p__12107;
var map__12108__$1 = (((((!((map__12108 == null))))?(((((map__12108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12108):map__12108);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12108__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12108__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12108__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12110_12114 = cljs.core.seq(statements);
var chunk__12111_12115 = null;
var count__12112_12116 = (0);
var i__12113_12117 = (0);
while(true){
if((i__12113_12117 < count__12112_12116)){
var s_12118 = chunk__12111_12115.cljs$core$IIndexed$_nth$arity$2(null,i__12113_12117);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12118);


var G__12119 = seq__12110_12114;
var G__12120 = chunk__12111_12115;
var G__12121 = count__12112_12116;
var G__12122 = (i__12113_12117 + (1));
seq__12110_12114 = G__12119;
chunk__12111_12115 = G__12120;
count__12112_12116 = G__12121;
i__12113_12117 = G__12122;
continue;
} else {
var temp__5735__auto___12123 = cljs.core.seq(seq__12110_12114);
if(temp__5735__auto___12123){
var seq__12110_12124__$1 = temp__5735__auto___12123;
if(cljs.core.chunked_seq_QMARK_(seq__12110_12124__$1)){
var c__4556__auto___12125 = cljs.core.chunk_first(seq__12110_12124__$1);
var G__12126 = cljs.core.chunk_rest(seq__12110_12124__$1);
var G__12127 = c__4556__auto___12125;
var G__12128 = cljs.core.count(c__4556__auto___12125);
var G__12129 = (0);
seq__12110_12114 = G__12126;
chunk__12111_12115 = G__12127;
count__12112_12116 = G__12128;
i__12113_12117 = G__12129;
continue;
} else {
var s_12130 = cljs.core.first(seq__12110_12124__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12130);


var G__12131 = cljs.core.next(seq__12110_12124__$1);
var G__12132 = null;
var G__12133 = (0);
var G__12134 = (0);
seq__12110_12114 = G__12131;
chunk__12111_12115 = G__12132;
count__12112_12116 = G__12133;
i__12113_12117 = G__12134;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__12135){
var map__12136 = p__12135;
var map__12136__$1 = (((((!((map__12136 == null))))?(((((map__12136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12136.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12136):map__12136);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__12138,is_loop){
var map__12139 = p__12138;
var map__12139__$1 = (((((!((map__12139 == null))))?(((((map__12139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12139):map__12139);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12139__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12139__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12139__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__12141_12155 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__12142_12156 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__12142_12156);

try{var seq__12143_12157 = cljs.core.seq(bindings);
var chunk__12144_12158 = null;
var count__12145_12159 = (0);
var i__12146_12160 = (0);
while(true){
if((i__12146_12160 < count__12145_12159)){
var map__12151_12161 = chunk__12144_12158.cljs$core$IIndexed$_nth$arity$2(null,i__12146_12160);
var map__12151_12162__$1 = (((((!((map__12151_12161 == null))))?(((((map__12151_12161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12151_12161.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12151_12161):map__12151_12161);
var binding_12163 = map__12151_12162__$1;
var init_12164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12151_12162__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12163);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12164,";");


var G__12165 = seq__12143_12157;
var G__12166 = chunk__12144_12158;
var G__12167 = count__12145_12159;
var G__12168 = (i__12146_12160 + (1));
seq__12143_12157 = G__12165;
chunk__12144_12158 = G__12166;
count__12145_12159 = G__12167;
i__12146_12160 = G__12168;
continue;
} else {
var temp__5735__auto___12169 = cljs.core.seq(seq__12143_12157);
if(temp__5735__auto___12169){
var seq__12143_12170__$1 = temp__5735__auto___12169;
if(cljs.core.chunked_seq_QMARK_(seq__12143_12170__$1)){
var c__4556__auto___12171 = cljs.core.chunk_first(seq__12143_12170__$1);
var G__12172 = cljs.core.chunk_rest(seq__12143_12170__$1);
var G__12173 = c__4556__auto___12171;
var G__12174 = cljs.core.count(c__4556__auto___12171);
var G__12175 = (0);
seq__12143_12157 = G__12172;
chunk__12144_12158 = G__12173;
count__12145_12159 = G__12174;
i__12146_12160 = G__12175;
continue;
} else {
var map__12153_12176 = cljs.core.first(seq__12143_12170__$1);
var map__12153_12177__$1 = (((((!((map__12153_12176 == null))))?(((((map__12153_12176.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12153_12176.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12153_12176):map__12153_12176);
var binding_12178 = map__12153_12177__$1;
var init_12179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12153_12177__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12178);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12179,";");


var G__12180 = cljs.core.next(seq__12143_12170__$1);
var G__12181 = null;
var G__12182 = (0);
var G__12183 = (0);
seq__12143_12157 = G__12180;
chunk__12144_12158 = G__12181;
count__12145_12159 = G__12182;
i__12146_12160 = G__12183;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__12141_12155);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__12184){
var map__12185 = p__12184;
var map__12185__$1 = (((((!((map__12185 == null))))?(((((map__12185.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12185.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12185):map__12185);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12185__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12185__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12185__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___12187 = cljs.core.count(exprs);
var i_12188 = (0);
while(true){
if((i_12188 < n__4613__auto___12187)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12188) : temps.call(null,i_12188))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_12188) : exprs.call(null,i_12188)),";");

var G__12189 = (i_12188 + (1));
i_12188 = G__12189;
continue;
} else {
}
break;
}

var n__4613__auto___12190 = cljs.core.count(exprs);
var i_12191 = (0);
while(true){
if((i_12191 < n__4613__auto___12190)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_12191) : params.call(null,i_12191)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12191) : temps.call(null,i_12191)),";");

var G__12192 = (i_12191 + (1));
i_12191 = G__12192;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__12193){
var map__12194 = p__12193;
var map__12194__$1 = (((((!((map__12194 == null))))?(((((map__12194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12194.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12194):map__12194);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12194__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12194__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12194__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12196_12208 = cljs.core.seq(bindings);
var chunk__12197_12209 = null;
var count__12198_12210 = (0);
var i__12199_12211 = (0);
while(true){
if((i__12199_12211 < count__12198_12210)){
var map__12204_12212 = chunk__12197_12209.cljs$core$IIndexed$_nth$arity$2(null,i__12199_12211);
var map__12204_12213__$1 = (((((!((map__12204_12212 == null))))?(((((map__12204_12212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12204_12212.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12204_12212):map__12204_12212);
var binding_12214 = map__12204_12213__$1;
var init_12215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12204_12213__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12214)," = ",init_12215,";");


var G__12216 = seq__12196_12208;
var G__12217 = chunk__12197_12209;
var G__12218 = count__12198_12210;
var G__12219 = (i__12199_12211 + (1));
seq__12196_12208 = G__12216;
chunk__12197_12209 = G__12217;
count__12198_12210 = G__12218;
i__12199_12211 = G__12219;
continue;
} else {
var temp__5735__auto___12220 = cljs.core.seq(seq__12196_12208);
if(temp__5735__auto___12220){
var seq__12196_12221__$1 = temp__5735__auto___12220;
if(cljs.core.chunked_seq_QMARK_(seq__12196_12221__$1)){
var c__4556__auto___12222 = cljs.core.chunk_first(seq__12196_12221__$1);
var G__12223 = cljs.core.chunk_rest(seq__12196_12221__$1);
var G__12224 = c__4556__auto___12222;
var G__12225 = cljs.core.count(c__4556__auto___12222);
var G__12226 = (0);
seq__12196_12208 = G__12223;
chunk__12197_12209 = G__12224;
count__12198_12210 = G__12225;
i__12199_12211 = G__12226;
continue;
} else {
var map__12206_12227 = cljs.core.first(seq__12196_12221__$1);
var map__12206_12228__$1 = (((((!((map__12206_12227 == null))))?(((((map__12206_12227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12206_12227.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12206_12227):map__12206_12227);
var binding_12229 = map__12206_12228__$1;
var init_12230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12206_12228__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12229)," = ",init_12230,";");


var G__12231 = cljs.core.next(seq__12196_12221__$1);
var G__12232 = null;
var G__12233 = (0);
var G__12234 = (0);
seq__12196_12208 = G__12231;
chunk__12197_12209 = G__12232;
count__12198_12210 = G__12233;
i__12199_12211 = G__12234;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__12237){
var map__12238 = p__12237;
var map__12238__$1 = (((((!((map__12238 == null))))?(((((map__12238.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12238.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12238):map__12238);
var expr = map__12238__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12238__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12238__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12238__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info))){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__12250 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__12250.cljs$core$IFn$_invoke$arity$1 ? fexpr__12250.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__12250.call(null,tag));
})())){
var temp__5735__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__12252 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__12252.cljs$core$IFn$_invoke$arity$1 ? fexpr__12252.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__12252.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__12240 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12235_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12235_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12236_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12236_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12240,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12240,(1),null);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_12255 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_12255,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_12256 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_12256,args)),(((mfa_12256 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_12256,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
var G__12254 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__12253 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__12253.cljs$core$IFn$_invoke$arity$1 ? fexpr__12253.cljs$core$IFn$_invoke$arity$1(G__12254) : fexpr__12253.call(null,G__12254));
} else {
return and__4115__auto__;
}
})())){
var fprop_12257 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12257," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12257,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12257," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12257,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__12258){
var map__12259 = p__12258;
var map__12259__$1 = (((((!((map__12259 == null))))?(((((map__12259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12259):map__12259);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12259__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12259__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12259__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__12261){
var map__12262 = p__12261;
var map__12262__$1 = (((((!((map__12262 == null))))?(((((map__12262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12262):map__12262);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12262__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12262__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12262__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__12264 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__12264__$1 = (((((!((map__12264 == null))))?(((((map__12264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12264):map__12264);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12264__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12264__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__12265 = options;
var map__12265__$1 = (((((!((map__12265 == null))))?(((((map__12265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12265):map__12265);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__12266 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__12271 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__12271__$1 = (((((!((map__12271 == null))))?(((((map__12271.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12271.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12271):map__12271);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12271__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12271__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12266,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12266,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__12273_12293 = cljs.core.seq(libs_to_load);
var chunk__12274_12294 = null;
var count__12275_12295 = (0);
var i__12276_12296 = (0);
while(true){
if((i__12276_12296 < count__12275_12295)){
var lib_12297 = chunk__12274_12294.cljs$core$IIndexed$_nth$arity$2(null,i__12276_12296);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12297)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12297),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12297),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12297),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12297),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12297,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12297),"');");
}

}
}
}


var G__12298 = seq__12273_12293;
var G__12299 = chunk__12274_12294;
var G__12300 = count__12275_12295;
var G__12301 = (i__12276_12296 + (1));
seq__12273_12293 = G__12298;
chunk__12274_12294 = G__12299;
count__12275_12295 = G__12300;
i__12276_12296 = G__12301;
continue;
} else {
var temp__5735__auto___12302 = cljs.core.seq(seq__12273_12293);
if(temp__5735__auto___12302){
var seq__12273_12303__$1 = temp__5735__auto___12302;
if(cljs.core.chunked_seq_QMARK_(seq__12273_12303__$1)){
var c__4556__auto___12304 = cljs.core.chunk_first(seq__12273_12303__$1);
var G__12305 = cljs.core.chunk_rest(seq__12273_12303__$1);
var G__12306 = c__4556__auto___12304;
var G__12307 = cljs.core.count(c__4556__auto___12304);
var G__12308 = (0);
seq__12273_12293 = G__12305;
chunk__12274_12294 = G__12306;
count__12275_12295 = G__12307;
i__12276_12296 = G__12308;
continue;
} else {
var lib_12309 = cljs.core.first(seq__12273_12303__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12309)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12309),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12309),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12309),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12309),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12309,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12309),"');");
}

}
}
}


var G__12310 = cljs.core.next(seq__12273_12303__$1);
var G__12311 = null;
var G__12312 = (0);
var G__12313 = (0);
seq__12273_12293 = G__12310;
chunk__12274_12294 = G__12311;
count__12275_12295 = G__12312;
i__12276_12296 = G__12313;
continue;
}
} else {
}
}
break;
}

var seq__12277_12314 = cljs.core.seq(node_libs);
var chunk__12278_12315 = null;
var count__12279_12316 = (0);
var i__12280_12317 = (0);
while(true){
if((i__12280_12317 < count__12279_12316)){
var lib_12318 = chunk__12278_12315.cljs$core$IIndexed$_nth$arity$2(null,i__12280_12317);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12318)," = require('",lib_12318,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__12319 = seq__12277_12314;
var G__12320 = chunk__12278_12315;
var G__12321 = count__12279_12316;
var G__12322 = (i__12280_12317 + (1));
seq__12277_12314 = G__12319;
chunk__12278_12315 = G__12320;
count__12279_12316 = G__12321;
i__12280_12317 = G__12322;
continue;
} else {
var temp__5735__auto___12323 = cljs.core.seq(seq__12277_12314);
if(temp__5735__auto___12323){
var seq__12277_12324__$1 = temp__5735__auto___12323;
if(cljs.core.chunked_seq_QMARK_(seq__12277_12324__$1)){
var c__4556__auto___12325 = cljs.core.chunk_first(seq__12277_12324__$1);
var G__12326 = cljs.core.chunk_rest(seq__12277_12324__$1);
var G__12327 = c__4556__auto___12325;
var G__12328 = cljs.core.count(c__4556__auto___12325);
var G__12329 = (0);
seq__12277_12314 = G__12326;
chunk__12278_12315 = G__12327;
count__12279_12316 = G__12328;
i__12280_12317 = G__12329;
continue;
} else {
var lib_12330 = cljs.core.first(seq__12277_12324__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12330)," = require('",lib_12330,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__12331 = cljs.core.next(seq__12277_12324__$1);
var G__12332 = null;
var G__12333 = (0);
var G__12334 = (0);
seq__12277_12314 = G__12331;
chunk__12278_12315 = G__12332;
count__12279_12316 = G__12333;
i__12280_12317 = G__12334;
continue;
}
} else {
}
}
break;
}

var seq__12281_12335 = cljs.core.seq(global_exports_libs);
var chunk__12282_12336 = null;
var count__12283_12337 = (0);
var i__12284_12338 = (0);
while(true){
if((i__12284_12338 < count__12283_12337)){
var lib_12339 = chunk__12282_12336.cljs$core$IIndexed$_nth$arity$2(null,i__12284_12338);
var map__12289_12340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_12339));
var map__12289_12341__$1 = (((((!((map__12289_12340 == null))))?(((((map__12289_12340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12289_12340.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12289_12340):map__12289_12340);
var global_exports_12342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12289_12341__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12342,lib_12339);


var G__12343 = seq__12281_12335;
var G__12344 = chunk__12282_12336;
var G__12345 = count__12283_12337;
var G__12346 = (i__12284_12338 + (1));
seq__12281_12335 = G__12343;
chunk__12282_12336 = G__12344;
count__12283_12337 = G__12345;
i__12284_12338 = G__12346;
continue;
} else {
var temp__5735__auto___12347 = cljs.core.seq(seq__12281_12335);
if(temp__5735__auto___12347){
var seq__12281_12348__$1 = temp__5735__auto___12347;
if(cljs.core.chunked_seq_QMARK_(seq__12281_12348__$1)){
var c__4556__auto___12349 = cljs.core.chunk_first(seq__12281_12348__$1);
var G__12350 = cljs.core.chunk_rest(seq__12281_12348__$1);
var G__12351 = c__4556__auto___12349;
var G__12352 = cljs.core.count(c__4556__auto___12349);
var G__12353 = (0);
seq__12281_12335 = G__12350;
chunk__12282_12336 = G__12351;
count__12283_12337 = G__12352;
i__12284_12338 = G__12353;
continue;
} else {
var lib_12354 = cljs.core.first(seq__12281_12348__$1);
var map__12291_12355 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_12354));
var map__12291_12356__$1 = (((((!((map__12291_12355 == null))))?(((((map__12291_12355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12291_12355.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12291_12355):map__12291_12355);
var global_exports_12357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12291_12356__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12357,lib_12354);


var G__12358 = cljs.core.next(seq__12281_12348__$1);
var G__12359 = null;
var G__12360 = (0);
var G__12361 = (0);
seq__12281_12335 = G__12358;
chunk__12282_12336 = G__12359;
count__12283_12337 = G__12360;
i__12284_12338 = G__12361;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__12362){
var map__12363 = p__12362;
var map__12363__$1 = (((((!((map__12363 == null))))?(((((map__12363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12363):map__12363);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__12365){
var map__12366 = p__12365;
var map__12366__$1 = (((((!((map__12366 == null))))?(((((map__12366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12366):map__12366);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12366__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__12368){
var map__12369 = p__12368;
var map__12369__$1 = (((((!((map__12369 == null))))?(((((map__12369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12369):map__12369);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12369__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12369__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12369__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12369__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12369__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12371_12395 = cljs.core.seq(protocols);
var chunk__12372_12396 = null;
var count__12373_12397 = (0);
var i__12374_12398 = (0);
while(true){
if((i__12374_12398 < count__12373_12397)){
var protocol_12399 = chunk__12372_12396.cljs$core$IIndexed$_nth$arity$2(null,i__12374_12398);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12399)),"}");


var G__12400 = seq__12371_12395;
var G__12401 = chunk__12372_12396;
var G__12402 = count__12373_12397;
var G__12403 = (i__12374_12398 + (1));
seq__12371_12395 = G__12400;
chunk__12372_12396 = G__12401;
count__12373_12397 = G__12402;
i__12374_12398 = G__12403;
continue;
} else {
var temp__5735__auto___12404 = cljs.core.seq(seq__12371_12395);
if(temp__5735__auto___12404){
var seq__12371_12405__$1 = temp__5735__auto___12404;
if(cljs.core.chunked_seq_QMARK_(seq__12371_12405__$1)){
var c__4556__auto___12406 = cljs.core.chunk_first(seq__12371_12405__$1);
var G__12407 = cljs.core.chunk_rest(seq__12371_12405__$1);
var G__12408 = c__4556__auto___12406;
var G__12409 = cljs.core.count(c__4556__auto___12406);
var G__12410 = (0);
seq__12371_12395 = G__12407;
chunk__12372_12396 = G__12408;
count__12373_12397 = G__12409;
i__12374_12398 = G__12410;
continue;
} else {
var protocol_12411 = cljs.core.first(seq__12371_12405__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12411)),"}");


var G__12412 = cljs.core.next(seq__12371_12405__$1);
var G__12413 = null;
var G__12414 = (0);
var G__12415 = (0);
seq__12371_12395 = G__12412;
chunk__12372_12396 = G__12413;
count__12373_12397 = G__12414;
i__12374_12398 = G__12415;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12375_12416 = cljs.core.seq(fields__$1);
var chunk__12376_12417 = null;
var count__12377_12418 = (0);
var i__12378_12419 = (0);
while(true){
if((i__12378_12419 < count__12377_12418)){
var fld_12420 = chunk__12376_12417.cljs$core$IIndexed$_nth$arity$2(null,i__12378_12419);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12420," = ",fld_12420,";");


var G__12421 = seq__12375_12416;
var G__12422 = chunk__12376_12417;
var G__12423 = count__12377_12418;
var G__12424 = (i__12378_12419 + (1));
seq__12375_12416 = G__12421;
chunk__12376_12417 = G__12422;
count__12377_12418 = G__12423;
i__12378_12419 = G__12424;
continue;
} else {
var temp__5735__auto___12425 = cljs.core.seq(seq__12375_12416);
if(temp__5735__auto___12425){
var seq__12375_12426__$1 = temp__5735__auto___12425;
if(cljs.core.chunked_seq_QMARK_(seq__12375_12426__$1)){
var c__4556__auto___12427 = cljs.core.chunk_first(seq__12375_12426__$1);
var G__12428 = cljs.core.chunk_rest(seq__12375_12426__$1);
var G__12429 = c__4556__auto___12427;
var G__12430 = cljs.core.count(c__4556__auto___12427);
var G__12431 = (0);
seq__12375_12416 = G__12428;
chunk__12376_12417 = G__12429;
count__12377_12418 = G__12430;
i__12378_12419 = G__12431;
continue;
} else {
var fld_12432 = cljs.core.first(seq__12375_12426__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12432," = ",fld_12432,";");


var G__12433 = cljs.core.next(seq__12375_12426__$1);
var G__12434 = null;
var G__12435 = (0);
var G__12436 = (0);
seq__12375_12416 = G__12433;
chunk__12376_12417 = G__12434;
count__12377_12418 = G__12435;
i__12378_12419 = G__12436;
continue;
}
} else {
}
}
break;
}

var seq__12379_12437 = cljs.core.seq(pmasks);
var chunk__12380_12438 = null;
var count__12381_12439 = (0);
var i__12382_12440 = (0);
while(true){
if((i__12382_12440 < count__12381_12439)){
var vec__12389_12441 = chunk__12380_12438.cljs$core$IIndexed$_nth$arity$2(null,i__12382_12440);
var pno_12442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389_12441,(0),null);
var pmask_12443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389_12441,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12442,"$ = ",pmask_12443,";");


var G__12444 = seq__12379_12437;
var G__12445 = chunk__12380_12438;
var G__12446 = count__12381_12439;
var G__12447 = (i__12382_12440 + (1));
seq__12379_12437 = G__12444;
chunk__12380_12438 = G__12445;
count__12381_12439 = G__12446;
i__12382_12440 = G__12447;
continue;
} else {
var temp__5735__auto___12448 = cljs.core.seq(seq__12379_12437);
if(temp__5735__auto___12448){
var seq__12379_12449__$1 = temp__5735__auto___12448;
if(cljs.core.chunked_seq_QMARK_(seq__12379_12449__$1)){
var c__4556__auto___12450 = cljs.core.chunk_first(seq__12379_12449__$1);
var G__12451 = cljs.core.chunk_rest(seq__12379_12449__$1);
var G__12452 = c__4556__auto___12450;
var G__12453 = cljs.core.count(c__4556__auto___12450);
var G__12454 = (0);
seq__12379_12437 = G__12451;
chunk__12380_12438 = G__12452;
count__12381_12439 = G__12453;
i__12382_12440 = G__12454;
continue;
} else {
var vec__12392_12455 = cljs.core.first(seq__12379_12449__$1);
var pno_12456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12392_12455,(0),null);
var pmask_12457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12392_12455,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12456,"$ = ",pmask_12457,";");


var G__12458 = cljs.core.next(seq__12379_12449__$1);
var G__12459 = null;
var G__12460 = (0);
var G__12461 = (0);
seq__12379_12437 = G__12458;
chunk__12380_12438 = G__12459;
count__12381_12439 = G__12460;
i__12382_12440 = G__12461;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__12462){
var map__12463 = p__12462;
var map__12463__$1 = (((((!((map__12463 == null))))?(((((map__12463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12463.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12463):map__12463);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12463__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12463__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12463__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12463__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12463__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12465_12489 = cljs.core.seq(protocols);
var chunk__12466_12490 = null;
var count__12467_12491 = (0);
var i__12468_12492 = (0);
while(true){
if((i__12468_12492 < count__12467_12491)){
var protocol_12493 = chunk__12466_12490.cljs$core$IIndexed$_nth$arity$2(null,i__12468_12492);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12493)),"}");


var G__12494 = seq__12465_12489;
var G__12495 = chunk__12466_12490;
var G__12496 = count__12467_12491;
var G__12497 = (i__12468_12492 + (1));
seq__12465_12489 = G__12494;
chunk__12466_12490 = G__12495;
count__12467_12491 = G__12496;
i__12468_12492 = G__12497;
continue;
} else {
var temp__5735__auto___12498 = cljs.core.seq(seq__12465_12489);
if(temp__5735__auto___12498){
var seq__12465_12499__$1 = temp__5735__auto___12498;
if(cljs.core.chunked_seq_QMARK_(seq__12465_12499__$1)){
var c__4556__auto___12500 = cljs.core.chunk_first(seq__12465_12499__$1);
var G__12501 = cljs.core.chunk_rest(seq__12465_12499__$1);
var G__12502 = c__4556__auto___12500;
var G__12503 = cljs.core.count(c__4556__auto___12500);
var G__12504 = (0);
seq__12465_12489 = G__12501;
chunk__12466_12490 = G__12502;
count__12467_12491 = G__12503;
i__12468_12492 = G__12504;
continue;
} else {
var protocol_12505 = cljs.core.first(seq__12465_12499__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12505)),"}");


var G__12506 = cljs.core.next(seq__12465_12499__$1);
var G__12507 = null;
var G__12508 = (0);
var G__12509 = (0);
seq__12465_12489 = G__12506;
chunk__12466_12490 = G__12507;
count__12467_12491 = G__12508;
i__12468_12492 = G__12509;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12469_12510 = cljs.core.seq(fields__$1);
var chunk__12470_12511 = null;
var count__12471_12512 = (0);
var i__12472_12513 = (0);
while(true){
if((i__12472_12513 < count__12471_12512)){
var fld_12514 = chunk__12470_12511.cljs$core$IIndexed$_nth$arity$2(null,i__12472_12513);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12514," = ",fld_12514,";");


var G__12515 = seq__12469_12510;
var G__12516 = chunk__12470_12511;
var G__12517 = count__12471_12512;
var G__12518 = (i__12472_12513 + (1));
seq__12469_12510 = G__12515;
chunk__12470_12511 = G__12516;
count__12471_12512 = G__12517;
i__12472_12513 = G__12518;
continue;
} else {
var temp__5735__auto___12519 = cljs.core.seq(seq__12469_12510);
if(temp__5735__auto___12519){
var seq__12469_12520__$1 = temp__5735__auto___12519;
if(cljs.core.chunked_seq_QMARK_(seq__12469_12520__$1)){
var c__4556__auto___12521 = cljs.core.chunk_first(seq__12469_12520__$1);
var G__12522 = cljs.core.chunk_rest(seq__12469_12520__$1);
var G__12523 = c__4556__auto___12521;
var G__12524 = cljs.core.count(c__4556__auto___12521);
var G__12525 = (0);
seq__12469_12510 = G__12522;
chunk__12470_12511 = G__12523;
count__12471_12512 = G__12524;
i__12472_12513 = G__12525;
continue;
} else {
var fld_12526 = cljs.core.first(seq__12469_12520__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12526," = ",fld_12526,";");


var G__12527 = cljs.core.next(seq__12469_12520__$1);
var G__12528 = null;
var G__12529 = (0);
var G__12530 = (0);
seq__12469_12510 = G__12527;
chunk__12470_12511 = G__12528;
count__12471_12512 = G__12529;
i__12472_12513 = G__12530;
continue;
}
} else {
}
}
break;
}

var seq__12473_12531 = cljs.core.seq(pmasks);
var chunk__12474_12532 = null;
var count__12475_12533 = (0);
var i__12476_12534 = (0);
while(true){
if((i__12476_12534 < count__12475_12533)){
var vec__12483_12535 = chunk__12474_12532.cljs$core$IIndexed$_nth$arity$2(null,i__12476_12534);
var pno_12536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12483_12535,(0),null);
var pmask_12537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12483_12535,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12536,"$ = ",pmask_12537,";");


var G__12538 = seq__12473_12531;
var G__12539 = chunk__12474_12532;
var G__12540 = count__12475_12533;
var G__12541 = (i__12476_12534 + (1));
seq__12473_12531 = G__12538;
chunk__12474_12532 = G__12539;
count__12475_12533 = G__12540;
i__12476_12534 = G__12541;
continue;
} else {
var temp__5735__auto___12542 = cljs.core.seq(seq__12473_12531);
if(temp__5735__auto___12542){
var seq__12473_12543__$1 = temp__5735__auto___12542;
if(cljs.core.chunked_seq_QMARK_(seq__12473_12543__$1)){
var c__4556__auto___12544 = cljs.core.chunk_first(seq__12473_12543__$1);
var G__12545 = cljs.core.chunk_rest(seq__12473_12543__$1);
var G__12546 = c__4556__auto___12544;
var G__12547 = cljs.core.count(c__4556__auto___12544);
var G__12548 = (0);
seq__12473_12531 = G__12545;
chunk__12474_12532 = G__12546;
count__12475_12533 = G__12547;
i__12476_12534 = G__12548;
continue;
} else {
var vec__12486_12549 = cljs.core.first(seq__12473_12543__$1);
var pno_12550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12486_12549,(0),null);
var pmask_12551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12486_12549,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12550,"$ = ",pmask_12551,";");


var G__12552 = cljs.core.next(seq__12473_12543__$1);
var G__12553 = null;
var G__12554 = (0);
var G__12555 = (0);
seq__12473_12531 = G__12552;
chunk__12474_12532 = G__12553;
count__12475_12533 = G__12554;
i__12476_12534 = G__12555;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__12556){
var map__12557 = p__12556;
var map__12557__$1 = (((((!((map__12557 == null))))?(((((map__12557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12557):map__12557);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12557__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12557__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12557__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12557__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12557__$1,cljs.core.cst$kw$env);
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__12559){
var map__12560 = p__12559;
var map__12560__$1 = (((((!((map__12560 == null))))?(((((map__12560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12560):map__12560);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12560__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12560__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12560__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12560__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12560__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__11304__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11304__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__12566 = cljs.core.seq(table);
var chunk__12567 = null;
var count__12568 = (0);
var i__12569 = (0);
while(true){
if((i__12569 < count__12568)){
var vec__12576 = chunk__12567.cljs$core$IIndexed$_nth$arity$2(null,i__12569);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12576,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12576,(1),null);
var ns_12582 = cljs.core.namespace(sym);
var name_12583 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12584 = seq__12566;
var G__12585 = chunk__12567;
var G__12586 = count__12568;
var G__12587 = (i__12569 + (1));
seq__12566 = G__12584;
chunk__12567 = G__12585;
count__12568 = G__12586;
i__12569 = G__12587;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12566);
if(temp__5735__auto__){
var seq__12566__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12566__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12566__$1);
var G__12588 = cljs.core.chunk_rest(seq__12566__$1);
var G__12589 = c__4556__auto__;
var G__12590 = cljs.core.count(c__4556__auto__);
var G__12591 = (0);
seq__12566 = G__12588;
chunk__12567 = G__12589;
count__12568 = G__12590;
i__12569 = G__12591;
continue;
} else {
var vec__12579 = cljs.core.first(seq__12566__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12579,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12579,(1),null);
var ns_12592 = cljs.core.namespace(sym);
var name_12593 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12594 = cljs.core.next(seq__12566__$1);
var G__12595 = null;
var G__12596 = (0);
var G__12597 = (0);
seq__12566 = G__12594;
chunk__12567 = G__12595;
count__12568 = G__12596;
i__12569 = G__12597;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12599 = arguments.length;
switch (G__12599) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_12604 = cljs.core.first(ks);
var vec__12600_12605 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_12604);
var top_12606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12600_12605,(0),null);
var prefix_SINGLEQUOTE__12607 = vec__12600_12605;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_12604)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__12607) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_12606)) || (cljs.core.contains_QMARK_(known_externs,top_12606)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12607)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_12606);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12607)),";");
}
} else {
}

var m_12608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_12604);
if(cljs.core.empty_QMARK_(m_12608)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__12607,m_12608,top_level,known_externs);
}

var G__12609 = cljs.core.next(ks);
ks = G__12609;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

