// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__30882 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30882,(5),null);
var G__30885 = idx;
var G__30885__$1 = (((G__30885 instanceof cljs.core.Keyword))?G__30885.fqn:null);
switch (G__30885__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30885__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__30887 = idx;
var G__30887__$1 = (((G__30887 instanceof cljs.core.Keyword))?G__30887.fqn:null);
switch (G__30887__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30887__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__30889 = idx;
var G__30889__$1 = (((G__30889 instanceof cljs.core.Keyword))?G__30889.fqn:null);
switch (G__30889__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30889__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__30892 = arguments.length;
switch (G__30892) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__30893 = (function (){var pred__30896 = cljs.core.identical_QMARK_;
var expr__30897 = test;
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__30897) : pred__30896.call(null,cljs.core._EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__30897) : pred__30896.call(null,cljs.core._LT_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__30897) : pred__30896.call(null,cljs.core._LT__EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__30897) : pred__30896.call(null,cljs.core._GT_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__30896.cljs$core$IFn$_invoke$arity$2 ? pred__30896.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__30897) : pred__30896.call(null,cljs.core._GT__EQ_,expr__30897)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30897)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30893,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31110){
var state_val_31111 = (state_31110[(1)]);
if((state_val_31111 === (65))){
var inst_31031 = (state_31110[(7)]);
var inst_31063 = (state_31110[(8)]);
var inst_31075 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31063,inst_31031);
var state_31110__$1 = state_31110;
var statearr_31112_31228 = state_31110__$1;
(statearr_31112_31228[(2)] = inst_31075);

(statearr_31112_31228[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (70))){
var inst_31093 = (state_31110[(2)]);
var inst_31094 = cljs.core.not(inst_31093);
var state_31110__$1 = state_31110;
if(inst_31094){
var statearr_31113_31229 = state_31110__$1;
(statearr_31113_31229[(1)] = (71));

} else {
var statearr_31114_31230 = state_31110__$1;
(statearr_31114_31230[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (62))){
var inst_31045 = (state_31110[(9)]);
var inst_31084 = (state_31110[(10)]);
var inst_31084__$1 = (state_31110[(2)]);
var inst_31085 = cljs.core.count(inst_31084__$1);
var state_31110__$1 = (function (){var statearr_31115 = state_31110;
(statearr_31115[(10)] = inst_31084__$1);

(statearr_31115[(11)] = inst_31085);

return statearr_31115;
})();
if(cljs.core.truth_(inst_31045)){
var statearr_31116_31231 = state_31110__$1;
(statearr_31116_31231[(1)] = (68));

} else {
var statearr_31117_31232 = state_31110__$1;
(statearr_31117_31232[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (74))){
var inst_31084 = (state_31110[(10)]);
var inst_31085 = (state_31110[(11)]);
var inst_31099 = (state_31110[(2)]);
var inst_31100 = fluree.db.util.async.throw_err(inst_31099);
var inst_31029 = inst_31100;
var inst_31030 = inst_31085;
var inst_31031 = inst_31084;
var state_31110__$1 = (function (){var statearr_31118 = state_31110;
(statearr_31118[(12)] = inst_31030);

(statearr_31118[(7)] = inst_31031);

(statearr_31118[(13)] = inst_31029);

return statearr_31118;
})();
var statearr_31119_31233 = state_31110__$1;
(statearr_31119_31233[(2)] = null);

(statearr_31119_31233[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (7))){
var inst_30912 = (state_31110[(14)]);
var state_31110__$1 = state_31110;
var statearr_31120_31234 = state_31110__$1;
(statearr_31120_31234[(2)] = inst_30912);

(statearr_31120_31234[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (59))){
var inst_31029 = (state_31110[(13)]);
var inst_31044 = (state_31110[(2)]);
var inst_31045 = fluree.db.dbproto._rhs(inst_31029);
var state_31110__$1 = (function (){var statearr_31121 = state_31110;
(statearr_31121[(15)] = inst_31044);

(statearr_31121[(9)] = inst_31045);

return statearr_31121;
})();
var statearr_31122_31235 = state_31110__$1;
(statearr_31122_31235[(1)] = (60));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (20))){
var inst_30913 = (state_31110[(16)]);
var inst_30960 = (state_31110[(2)]);
var inst_30961 = (inst_30913 == null);
var state_31110__$1 = (function (){var statearr_31124 = state_31110;
(statearr_31124[(17)] = inst_30960);

return statearr_31124;
})();
if(cljs.core.truth_(inst_30961)){
var statearr_31125_31236 = state_31110__$1;
(statearr_31125_31236[(1)] = (22));

} else {
var statearr_31126_31237 = state_31110__$1;
(statearr_31126_31237[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (72))){
var inst_31045 = (state_31110[(9)]);
var inst_31024 = (state_31110[(18)]);
var inst_31097 = fluree.db.dbproto._lookup_leaf(inst_31024,inst_31045);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(74),inst_31097);
} else {
if((state_val_31111 === (58))){
var inst_31037 = (state_31110[(19)]);
var state_31110__$1 = state_31110;
var statearr_31127_31238 = state_31110__$1;
(statearr_31127_31238[(2)] = inst_31037);

(statearr_31127_31238[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (60))){
var inst_31044 = (state_31110[(15)]);
var inst_31030 = (state_31110[(12)]);
var inst_31031 = (state_31110[(7)]);
var inst_31003 = (state_31110[(20)]);
var inst_31047 = (inst_31003 - inst_31030);
var inst_31048 = fluree.db.flake.take(inst_31047,inst_31044);
var inst_31049 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31048,inst_31031);
var state_31110__$1 = state_31110;
var statearr_31128_31239 = state_31110__$1;
(statearr_31128_31239[(2)] = inst_31049);

(statearr_31128_31239[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (27))){
var inst_30920 = (state_31110[(21)]);
var inst_30969 = (state_31110[(2)]);
var inst_30970 = (inst_30920 == null);
var state_31110__$1 = (function (){var statearr_31129 = state_31110;
(statearr_31129[(22)] = inst_30969);

return statearr_31129;
})();
if(cljs.core.truth_(inst_30970)){
var statearr_31130_31240 = state_31110__$1;
(statearr_31130_31240[(1)] = (28));

} else {
var statearr_31131_31241 = state_31110__$1;
(statearr_31131_31241[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (1))){
var state_31110__$1 = state_31110;
var statearr_31132_31242 = state_31110__$1;
(statearr_31132_31242[(2)] = null);

(statearr_31132_31242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (69))){
var inst_31045 = (state_31110[(9)]);
var state_31110__$1 = state_31110;
var statearr_31133_31243 = state_31110__$1;
(statearr_31133_31243[(2)] = inst_31045);

(statearr_31133_31243[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (24))){
var inst_30965 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30965)){
var statearr_31134_31244 = state_31110__$1;
(statearr_31134_31244[(1)] = (25));

} else {
var statearr_31135_31245 = state_31110__$1;
(statearr_31135_31245[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (55))){
var inst_31105 = (state_31110[(2)]);
var _ = (function (){var statearr_31136 = state_31110;
(statearr_31136[(4)] = cljs.core.rest((state_31110[(4)])));

return statearr_31136;
})();
var state_31110__$1 = state_31110;
var statearr_31137_31246 = state_31110__$1;
(statearr_31137_31246[(2)] = inst_31105);

(statearr_31137_31246[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (39))){
var inst_30985 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31138_31247 = state_31110__$1;
(statearr_31138_31247[(2)] = inst_30985);

(statearr_31138_31247[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (46))){
var inst_30999 = (state_31110[(23)]);
var state_31110__$1 = state_31110;
var statearr_31139_31248 = state_31110__$1;
(statearr_31139_31248[(2)] = inst_30999);

(statearr_31139_31248[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (4))){
var inst_30899 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31140_31249 = state_31110__$1;
(statearr_31140_31249[(2)] = inst_30899);

(statearr_31140_31249[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (54))){
var inst_31014 = (state_31110[(24)]);
var inst_31015 = (state_31110[(25)]);
var inst_31029 = (state_31110[(13)]);
var inst_31019 = (state_31110[(26)]);
var inst_31033 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_31029,inst_31014,inst_31015,inst_31019);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(56),inst_31033);
} else {
if((state_val_31111 === (15))){
var inst_30914 = (state_31110[(27)]);
var state_31110__$1 = state_31110;
var statearr_31141_31250 = state_31110__$1;
(statearr_31141_31250[(2)] = inst_30914);

(statearr_31141_31250[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (48))){
var inst_31009 = (state_31110[(28)]);
var inst_31003 = (state_31110[(2)]);
var inst_31004 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_31005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31006 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_31007 = (new cljs.core.PersistentVector(null,3,(5),inst_31005,inst_31006,null));
var inst_31008 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31007);
var inst_31009__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_31110__$1 = (function (){var statearr_31142 = state_31110;
(statearr_31142[(29)] = inst_31004);

(statearr_31142[(30)] = inst_31008);

(statearr_31142[(20)] = inst_31003);

(statearr_31142[(28)] = inst_31009__$1);

return statearr_31142;
})();
if(cljs.core.truth_(inst_31009__$1)){
var statearr_31143_31251 = state_31110__$1;
(statearr_31143_31251[(1)] = (49));

} else {
var statearr_31144_31252 = state_31110__$1;
(statearr_31144_31252[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (50))){
var inst_31012 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_31110__$1 = state_31110;
var statearr_31145_31253 = state_31110__$1;
(statearr_31145_31253[(2)] = inst_31012);

(statearr_31145_31253[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (21))){
var inst_30956 = (state_31110[(2)]);
var inst_30957 = fluree.db.util.async.throw_err(inst_30956);
var state_31110__$1 = state_31110;
var statearr_31146_31254 = state_31110__$1;
(statearr_31146_31254[(2)] = inst_30957);

(statearr_31146_31254[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (31))){
var state_31110__$1 = state_31110;
var statearr_31147_31255 = state_31110__$1;
(statearr_31147_31255[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_31147_31255[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (32))){
var inst_30920 = (state_31110[(21)]);
var state_31110__$1 = state_31110;
var statearr_31148_31256 = state_31110__$1;
(statearr_31148_31256[(2)] = inst_30920);

(statearr_31148_31256[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (40))){
var inst_30924 = (state_31110[(31)]);
var state_31110__$1 = state_31110;
var statearr_31149_31257 = state_31110__$1;
(statearr_31149_31257[(2)] = inst_30924);

(statearr_31149_31257[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (56))){
var inst_30997 = (state_31110[(32)]);
var inst_31036 = (state_31110[(33)]);
var inst_30998 = (state_31110[(34)]);
var inst_31035 = (state_31110[(2)]);
var inst_31036__$1 = fluree.db.util.async.throw_err(inst_31035);
var inst_31037 = fluree.db.flake.subrange(inst_31036__$1,start_test,inst_30997,end_test,inst_30998);
var inst_31038 = fluree.db.query.range.value_with_nil_pred(idx,inst_30997,inst_30998);
var state_31110__$1 = (function (){var statearr_31150 = state_31110;
(statearr_31150[(33)] = inst_31036__$1);

(statearr_31150[(19)] = inst_31037);

return statearr_31150;
})();
if(inst_31038){
var statearr_31151_31258 = state_31110__$1;
(statearr_31151_31258[(1)] = (57));

} else {
var statearr_31152_31259 = state_31110__$1;
(statearr_31152_31259[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (33))){
var inst_30917 = (state_31110[(35)]);
var inst_30978 = (state_31110[(2)]);
var state_31110__$1 = (function (){var statearr_31153 = state_31110;
(statearr_31153[(36)] = inst_30978);

return statearr_31153;
})();
if(cljs.core.truth_(inst_30917)){
var statearr_31154_31260 = state_31110__$1;
(statearr_31154_31260[(1)] = (34));

} else {
var statearr_31155_31261 = state_31110__$1;
(statearr_31155_31261[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (13))){
var inst_30938 = (state_31110[(2)]);
var inst_30939 = fluree.db.util.async.throw_err(inst_30938);
var state_31110__$1 = state_31110;
var statearr_31156_31262 = state_31110__$1;
(statearr_31156_31262[(2)] = inst_30939);

(statearr_31156_31262[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (22))){
var inst_30951 = (state_31110[(37)]);
var state_31110__$1 = state_31110;
var statearr_31157_31263 = state_31110__$1;
(statearr_31157_31263[(2)] = inst_30951);

(statearr_31157_31263[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (36))){
var inst_30924 = (state_31110[(31)]);
var inst_30987 = (state_31110[(2)]);
var state_31110__$1 = (function (){var statearr_31158 = state_31110;
(statearr_31158[(38)] = inst_30987);

return statearr_31158;
})();
if(cljs.core.truth_(inst_30924)){
var statearr_31159_31264 = state_31110__$1;
(statearr_31159_31264[(1)] = (40));

} else {
var statearr_31160_31265 = state_31110__$1;
(statearr_31160_31265[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (41))){
var inst_30990 = (cljs.core._LT__EQ_ === end_test);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30990)){
var statearr_31161_31266 = state_31110__$1;
(statearr_31161_31266[(1)] = (43));

} else {
var statearr_31162_31267 = state_31110__$1;
(statearr_31162_31267[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (43))){
var state_31110__$1 = state_31110;
var statearr_31163_31268 = state_31110__$1;
(statearr_31163_31268[(2)] = (2147483647));

(statearr_31163_31268[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (61))){
var inst_31044 = (state_31110[(15)]);
var inst_31030 = (state_31110[(12)]);
var inst_31058 = cljs.core.seq(inst_31044);
var inst_31059 = cljs.core.first(inst_31058);
var inst_31060 = cljs.core.next(inst_31058);
var inst_31061 = inst_31044;
var inst_31062 = inst_31030;
var inst_31063 = inst_31044;
var state_31110__$1 = (function (){var statearr_31164 = state_31110;
(statearr_31164[(39)] = inst_31060);

(statearr_31164[(40)] = inst_31061);

(statearr_31164[(41)] = inst_31059);

(statearr_31164[(42)] = inst_31062);

(statearr_31164[(8)] = inst_31063);

return statearr_31164;
})();
var statearr_31165_31269 = state_31110__$1;
(statearr_31165_31269[(2)] = null);

(statearr_31165_31269[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (29))){
var state_31110__$1 = state_31110;
var statearr_31166_31270 = state_31110__$1;
(statearr_31166_31270[(2)] = false);

(statearr_31166_31270[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (44))){
var state_31110__$1 = state_31110;
var statearr_31167_31271 = state_31110__$1;
(statearr_31167_31271[(2)] = fluree.db.util.core.min_integer);

(statearr_31167_31271[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (6))){
var inst_30912 = (state_31110[(14)]);
var inst_30927 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30912);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(9),inst_30927);
} else {
if((state_val_31111 === (28))){
var inst_30960 = (state_31110[(17)]);
var state_31110__$1 = state_31110;
var statearr_31168_31272 = state_31110__$1;
(statearr_31168_31272[(2)] = inst_30960);

(statearr_31168_31272[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (64))){
var inst_31082 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31169_31273 = state_31110__$1;
(statearr_31169_31273[(2)] = inst_31082);

(statearr_31169_31273[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (51))){
var inst_31014 = (state_31110[(2)]);
var inst_31015 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_31016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31017 = [cljs.core.cst$kw$novelty,idx];
var inst_31018 = (new cljs.core.PersistentVector(null,2,(5),inst_31016,inst_31017,null));
var inst_31019 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31018);
var inst_31020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31021 = fluree.db.dbproto._resolve(inst_31020);
var state_31110__$1 = (function (){var statearr_31170 = state_31110;
(statearr_31170[(24)] = inst_31014);

(statearr_31170[(25)] = inst_31015);

(statearr_31170[(26)] = inst_31019);

return statearr_31170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(52),inst_31021);
} else {
if((state_val_31111 === (25))){
var state_31110__$1 = state_31110;
var statearr_31171_31274 = state_31110__$1;
(statearr_31171_31274[(2)] = (-1));

(statearr_31171_31274[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (34))){
var inst_30917 = (state_31110[(35)]);
var state_31110__$1 = state_31110;
var statearr_31172_31275 = state_31110__$1;
(statearr_31172_31275[(2)] = inst_30917);

(statearr_31172_31275[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (17))){
var inst_30947 = (state_31110[(2)]);
var inst_30948 = fluree.db.util.async.throw_err(inst_30947);
var state_31110__$1 = state_31110;
var statearr_31173_31276 = state_31110__$1;
(statearr_31173_31276[(2)] = inst_30948);

(statearr_31173_31276[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (3))){
var inst_31108 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31110__$1,inst_31108);
} else {
if((state_val_31111 === (12))){
var inst_30914 = (state_31110[(27)]);
var inst_30942 = (state_31110[(2)]);
var inst_30943 = fluree.db.util.core.pred_ident_QMARK_(inst_30914);
var state_31110__$1 = (function (){var statearr_31175 = state_31110;
(statearr_31175[(43)] = inst_30942);

return statearr_31175;
})();
if(inst_30943){
var statearr_31176_31277 = state_31110__$1;
(statearr_31176_31277[(1)] = (14));

} else {
var statearr_31177_31278 = state_31110__$1;
(statearr_31177_31278[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (2))){
var inst_30911 = (state_31110[(44)]);
var inst_30912 = (state_31110[(14)]);
var inst_30918 = (state_31110[(45)]);
var _ = (function (){var statearr_31178 = state_31110;
(statearr_31178[(4)] = cljs.core.cons((5),(state_31110[(4)])));

return statearr_31178;
})();
var inst_30911__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_30912__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(0),null);
var inst_30913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(1),null);
var inst_30914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(2),null);
var inst_30915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(3),null);
var inst_30916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(4),null);
var inst_30917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30911__$1,(5),null);
var inst_30918__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_30919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(0),null);
var inst_30920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(1),null);
var inst_30921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(2),null);
var inst_30922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(3),null);
var inst_30923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(4),null);
var inst_30924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30918__$1,(5),null);
var inst_30925 = fluree.db.util.core.pred_ident_QMARK_(inst_30912__$1);
var state_31110__$1 = (function (){var statearr_31179 = state_31110;
(statearr_31179[(46)] = inst_30915);

(statearr_31179[(27)] = inst_30914);

(statearr_31179[(21)] = inst_30920);

(statearr_31179[(47)] = inst_30921);

(statearr_31179[(48)] = inst_30922);

(statearr_31179[(44)] = inst_30911__$1);

(statearr_31179[(31)] = inst_30924);

(statearr_31179[(49)] = inst_30919);

(statearr_31179[(14)] = inst_30912__$1);

(statearr_31179[(45)] = inst_30918__$1);

(statearr_31179[(16)] = inst_30913);

(statearr_31179[(35)] = inst_30917);

(statearr_31179[(50)] = inst_30923);

(statearr_31179[(51)] = inst_30916);

return statearr_31179;
})();
if(inst_30925){
var statearr_31180_31279 = state_31110__$1;
(statearr_31180_31279[(1)] = (6));

} else {
var statearr_31181_31280 = state_31110__$1;
(statearr_31181_31280[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (66))){
var inst_31062 = (state_31110[(42)]);
var inst_31070 = (state_31110[(52)]);
var inst_31063 = (state_31110[(8)]);
var inst_31077 = (inst_31062 + (1));
var tmp31174 = inst_31063;
var inst_31061 = inst_31070;
var inst_31062__$1 = inst_31077;
var inst_31063__$1 = tmp31174;
var state_31110__$1 = (function (){var statearr_31182 = state_31110;
(statearr_31182[(40)] = inst_31061);

(statearr_31182[(42)] = inst_31062__$1);

(statearr_31182[(8)] = inst_31063__$1);

return statearr_31182;
})();
var statearr_31183_31281 = state_31110__$1;
(statearr_31183_31281[(2)] = null);

(statearr_31183_31281[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (23))){
var state_31110__$1 = state_31110;
var statearr_31184_31282 = state_31110__$1;
(statearr_31184_31282[(2)] = false);

(statearr_31184_31282[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (47))){
var state_31110__$1 = state_31110;
var statearr_31185_31283 = state_31110__$1;
(statearr_31185_31283[(2)] = fluree.db.util.core.max_long);

(statearr_31185_31283[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (35))){
var inst_30981 = (cljs.core._GT__EQ_ === start_test);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30981)){
var statearr_31186_31284 = state_31110__$1;
(statearr_31186_31284[(1)] = (37));

} else {
var statearr_31187_31285 = state_31110__$1;
(statearr_31187_31285[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (19))){
var inst_30921 = (state_31110[(47)]);
var state_31110__$1 = state_31110;
var statearr_31188_31286 = state_31110__$1;
(statearr_31188_31286[(2)] = inst_30921);

(statearr_31188_31286[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (57))){
var inst_30915 = (state_31110[(46)]);
var inst_30978 = (state_31110[(36)]);
var inst_31004 = (state_31110[(29)]);
var inst_30922 = (state_31110[(48)]);
var inst_30911 = (state_31110[(44)]);
var inst_30997 = (state_31110[(32)]);
var inst_30933 = (state_31110[(53)]);
var inst_30996 = (state_31110[(54)]);
var inst_31030 = (state_31110[(12)]);
var inst_31036 = (state_31110[(33)]);
var inst_31024 = (state_31110[(18)]);
var inst_30951 = (state_31110[(37)]);
var inst_31014 = (state_31110[(24)]);
var inst_30918 = (state_31110[(45)]);
var inst_31031 = (state_31110[(7)]);
var inst_30987 = (state_31110[(38)]);
var inst_31015 = (state_31110[(25)]);
var inst_31029 = (state_31110[(13)]);
var inst_30942 = (state_31110[(43)]);
var inst_31037 = (state_31110[(19)]);
var inst_30969 = (state_31110[(22)]);
var inst_30998 = (state_31110[(34)]);
var inst_30923 = (state_31110[(50)]);
var inst_31008 = (state_31110[(30)]);
var inst_30916 = (state_31110[(51)]);
var inst_30960 = (state_31110[(17)]);
var inst_31003 = (state_31110[(20)]);
var inst_31019 = (state_31110[(26)]);
var inst_31040 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_31029;
var flakes = inst_31036;
var s1 = inst_30933;
var o2 = inst_30960;
var t1 = inst_30915;
var i = inst_31030;
var m1 = inst_30987;
var root_node = inst_31024;
var to_t = inst_31015;
var s2 = inst_30942;
var p2 = inst_30978;
var permissions = inst_31004;
var limit = inst_31003;
var start_flake = inst_30997;
var acc = inst_31031;
var vec__30905 = inst_30911;
var t2 = inst_30922;
var op1 = inst_30916;
var o1 = inst_30951;
var end_flake = inst_30998;
var base_result = inst_31037;
var p1 = inst_30969;
var vec__30908 = inst_30918;
var idx_compare = inst_31008;
var op2 = inst_30923;
var from_t = inst_31014;
var m2 = inst_30996;
var novelty = inst_31019;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_31041 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31040,inst_31037,inst_31037);
var state_31110__$1 = state_31110;
var statearr_31189_31287 = state_31110__$1;
(statearr_31189_31287[(2)] = inst_31041);

(statearr_31189_31287[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (68))){
var inst_31045 = (state_31110[(9)]);
var inst_31085 = (state_31110[(11)]);
var inst_30998 = (state_31110[(34)]);
var inst_31008 = (state_31110[(30)]);
var inst_31003 = (state_31110[(20)]);
var inst_31087 = (inst_31008.cljs$core$IFn$_invoke$arity$2 ? inst_31008.cljs$core$IFn$_invoke$arity$2(inst_31045,inst_30998) : inst_31008.call(null,inst_31045,inst_30998));
var inst_31088 = (inst_31087 < (0));
var inst_31089 = (inst_31085 < inst_31003);
var inst_31090 = ((inst_31088) && (inst_31089));
var state_31110__$1 = state_31110;
var statearr_31190_31288 = state_31110__$1;
(statearr_31190_31288[(2)] = inst_31090);

(statearr_31190_31288[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (11))){
var inst_30919 = (state_31110[(49)]);
var state_31110__$1 = state_31110;
var statearr_31192_31289 = state_31110__$1;
(statearr_31192_31289[(2)] = inst_30919);

(statearr_31192_31289[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (9))){
var inst_30929 = (state_31110[(2)]);
var inst_30930 = fluree.db.util.async.throw_err(inst_30929);
var state_31110__$1 = state_31110;
var statearr_31193_31290 = state_31110__$1;
(statearr_31193_31290[(2)] = inst_30930);

(statearr_31193_31290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (5))){
var _ = (function (){var statearr_31194 = state_31110;
(statearr_31194[(4)] = cljs.core.rest((state_31110[(4)])));

return statearr_31194;
})();
var state_31110__$1 = state_31110;
var ex31191 = (state_31110__$1[(2)]);
var statearr_31195_31291 = state_31110__$1;
(statearr_31195_31291[(5)] = ex31191);


if((ex31191 instanceof Error)){
var statearr_31196_31292 = state_31110__$1;
(statearr_31196_31292[(1)] = (4));

(statearr_31196_31292[(5)] = null);

} else {
throw ex31191;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (14))){
var inst_30914 = (state_31110[(27)]);
var inst_30945 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30914);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(17),inst_30945);
} else {
if((state_val_31111 === (45))){
var inst_30994 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31197_31293 = state_31110__$1;
(statearr_31197_31293[(2)] = inst_30994);

(statearr_31197_31293[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (53))){
var inst_31027 = (state_31110[(2)]);
var inst_31028 = fluree.db.util.async.throw_err(inst_31027);
var inst_31029 = inst_31028;
var inst_31030 = (0);
var inst_31031 = null;
var state_31110__$1 = (function (){var statearr_31198 = state_31110;
(statearr_31198[(12)] = inst_31030);

(statearr_31198[(7)] = inst_31031);

(statearr_31198[(13)] = inst_31029);

return statearr_31198;
})();
var statearr_31199_31294 = state_31110__$1;
(statearr_31199_31294[(2)] = null);

(statearr_31199_31294[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (26))){
var inst_30913 = (state_31110[(16)]);
var state_31110__$1 = state_31110;
var statearr_31200_31295 = state_31110__$1;
(statearr_31200_31295[(2)] = inst_30913);

(statearr_31200_31295[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (16))){
var inst_30921 = (state_31110[(47)]);
var inst_30951 = (state_31110[(2)]);
var inst_30952 = fluree.db.util.core.pred_ident_QMARK_(inst_30921);
var state_31110__$1 = (function (){var statearr_31201 = state_31110;
(statearr_31201[(37)] = inst_30951);

return statearr_31201;
})();
if(inst_30952){
var statearr_31202_31296 = state_31110__$1;
(statearr_31202_31296[(1)] = (18));

} else {
var statearr_31203_31297 = state_31110__$1;
(statearr_31203_31297[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (38))){
var state_31110__$1 = state_31110;
var statearr_31204_31298 = state_31110__$1;
(statearr_31204_31298[(2)] = (2147483647));

(statearr_31204_31298[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (30))){
var inst_30974 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_30974)){
var statearr_31205_31299 = state_31110__$1;
(statearr_31205_31299[(1)] = (31));

} else {
var statearr_31206_31300 = state_31110__$1;
(statearr_31206_31300[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (73))){
var inst_31103 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31207_31301 = state_31110__$1;
(statearr_31207_31301[(2)] = inst_31103);

(statearr_31207_31301[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (10))){
var inst_30919 = (state_31110[(49)]);
var inst_30936 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30919);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(13),inst_30936);
} else {
if((state_val_31111 === (18))){
var inst_30921 = (state_31110[(47)]);
var inst_30954 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30921);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(21),inst_30954);
} else {
if((state_val_31111 === (52))){
var inst_30997 = (state_31110[(32)]);
var inst_31024 = (state_31110[(18)]);
var inst_31023 = (state_31110[(2)]);
var inst_31024__$1 = fluree.db.util.async.throw_err(inst_31023);
var inst_31025 = fluree.db.dbproto._lookup_leaf(inst_31024__$1,inst_30997);
var state_31110__$1 = (function (){var statearr_31208 = state_31110;
(statearr_31208[(18)] = inst_31024__$1);

return statearr_31208;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31110__$1,(53),inst_31025);
} else {
if((state_val_31111 === (67))){
var inst_31080 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31209_31302 = state_31110__$1;
(statearr_31209_31302[(2)] = inst_31080);

(statearr_31209_31302[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (71))){
var inst_31084 = (state_31110[(10)]);
var state_31110__$1 = state_31110;
var statearr_31210_31303 = state_31110__$1;
(statearr_31210_31303[(2)] = inst_31084);

(statearr_31210_31303[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (42))){
var inst_30915 = (state_31110[(46)]);
var inst_30978 = (state_31110[(36)]);
var inst_30922 = (state_31110[(48)]);
var inst_30933 = (state_31110[(53)]);
var inst_30996 = (state_31110[(54)]);
var inst_30951 = (state_31110[(37)]);
var inst_30987 = (state_31110[(38)]);
var inst_30942 = (state_31110[(43)]);
var inst_30969 = (state_31110[(22)]);
var inst_30923 = (state_31110[(50)]);
var inst_30916 = (state_31110[(51)]);
var inst_30960 = (state_31110[(17)]);
var inst_30999 = (state_31110[(23)]);
var inst_30996__$1 = (state_31110[(2)]);
var inst_30997 = fluree.db.flake.__GT_Flake(inst_30933,inst_30969,inst_30951,inst_30915,inst_30916,inst_30987);
var inst_30998 = fluree.db.flake.__GT_Flake(inst_30942,inst_30978,inst_30960,inst_30922,inst_30923,inst_30996__$1);
var inst_30999__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_31110__$1 = (function (){var statearr_31211 = state_31110;
(statearr_31211[(32)] = inst_30997);

(statearr_31211[(54)] = inst_30996__$1);

(statearr_31211[(34)] = inst_30998);

(statearr_31211[(23)] = inst_30999__$1);

return statearr_31211;
})();
if(cljs.core.truth_(inst_30999__$1)){
var statearr_31212_31304 = state_31110__$1;
(statearr_31212_31304[(1)] = (46));

} else {
var statearr_31213_31305 = state_31110__$1;
(statearr_31213_31305[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (37))){
var state_31110__$1 = state_31110;
var statearr_31214_31306 = state_31110__$1;
(statearr_31214_31306[(2)] = fluree.db.util.core.min_integer);

(statearr_31214_31306[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (63))){
var inst_31061 = (state_31110[(40)]);
var inst_31062 = (state_31110[(42)]);
var inst_31003 = (state_31110[(20)]);
var inst_31068 = cljs.core.seq(inst_31061);
var inst_31069 = cljs.core.first(inst_31068);
var inst_31070 = cljs.core.next(inst_31068);
var inst_31071 = (inst_31069 == null);
var inst_31072 = (inst_31062 > inst_31003);
var inst_31073 = ((inst_31071) || (inst_31072));
var state_31110__$1 = (function (){var statearr_31215 = state_31110;
(statearr_31215[(52)] = inst_31070);

return statearr_31215;
})();
if(cljs.core.truth_(inst_31073)){
var statearr_31216_31307 = state_31110__$1;
(statearr_31216_31307[(1)] = (65));

} else {
var statearr_31217_31308 = state_31110__$1;
(statearr_31217_31308[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (8))){
var inst_30919 = (state_31110[(49)]);
var inst_30933 = (state_31110[(2)]);
var inst_30934 = fluree.db.util.core.pred_ident_QMARK_(inst_30919);
var state_31110__$1 = (function (){var statearr_31218 = state_31110;
(statearr_31218[(53)] = inst_30933);

return statearr_31218;
})();
if(inst_30934){
var statearr_31219_31309 = state_31110__$1;
(statearr_31219_31309[(1)] = (10));

} else {
var statearr_31220_31310 = state_31110__$1;
(statearr_31220_31310[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31111 === (49))){
var inst_31009 = (state_31110[(28)]);
var state_31110__$1 = state_31110;
var statearr_31221_31311 = state_31110__$1;
(statearr_31221_31311[(2)] = inst_31009);

(statearr_31221_31311[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31222[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31222[(1)] = (1));

return statearr_31222;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31110){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31110);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31223){var ex__16304__auto__ = e31223;
var statearr_31224_31312 = state_31110;
(statearr_31224_31312[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31110[(4)]))){
var statearr_31225_31313 = state_31110;
(statearr_31225_31313[(1)] = cljs.core.first((state_31110[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31314 = state_31110;
state_31110 = G__31314;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31110){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31226 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31226[(6)] = c__16375__auto__);

return statearr_31226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31364){
var state_val_31365 = (state_31364[(1)]);
if((state_val_31365 === (7))){
var state_31364__$1 = state_31364;
var statearr_31366_31385 = state_31364__$1;
(statearr_31366_31385[(2)] = (0));

(statearr_31366_31385[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (1))){
var inst_31322 = subject_groups;
var inst_31323 = cljs.core.seq(inst_31322);
var inst_31324 = cljs.core.first(inst_31323);
var inst_31325 = cljs.core.next(inst_31323);
var inst_31326 = flake_start;
var inst_31327 = subject_start;
var inst_31328 = cljs.core.PersistentVector.EMPTY;
var inst_31329 = inst_31322;
var inst_31330 = inst_31326;
var inst_31331 = inst_31327;
var inst_31332 = inst_31328;
var state_31364__$1 = (function (){var statearr_31367 = state_31364;
(statearr_31367[(7)] = inst_31330);

(statearr_31367[(8)] = inst_31325);

(statearr_31367[(9)] = inst_31331);

(statearr_31367[(10)] = inst_31324);

(statearr_31367[(11)] = inst_31332);

(statearr_31367[(12)] = inst_31329);

return statearr_31367;
})();
var statearr_31368_31386 = state_31364__$1;
(statearr_31368_31386[(2)] = null);

(statearr_31368_31386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (4))){
var inst_31330 = (state_31364[(7)]);
var inst_31331 = (state_31364[(9)]);
var inst_31332 = (state_31364[(11)]);
var inst_31345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31346 = [inst_31330,inst_31331,inst_31332];
var inst_31347 = (new cljs.core.PersistentVector(null,3,(5),inst_31345,inst_31346,null));
var state_31364__$1 = state_31364;
var statearr_31369_31387 = state_31364__$1;
(statearr_31369_31387[(2)] = inst_31347);

(statearr_31369_31387[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (6))){
var inst_31360 = (state_31364[(2)]);
var state_31364__$1 = state_31364;
var statearr_31370_31388 = state_31364__$1;
(statearr_31370_31388[(2)] = inst_31360);

(statearr_31370_31388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (3))){
var inst_31362 = (state_31364[(2)]);
var state_31364__$1 = state_31364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31364__$1,inst_31362);
} else {
if((state_val_31365 === (2))){
var inst_31330 = (state_31364[(7)]);
var inst_31338 = (state_31364[(13)]);
var inst_31331 = (state_31364[(9)]);
var inst_31329 = (state_31364[(12)]);
var inst_31337 = cljs.core.seq(inst_31329);
var inst_31338__$1 = cljs.core.first(inst_31337);
var inst_31339 = cljs.core.next(inst_31337);
var inst_31340 = (inst_31338__$1 == null);
var inst_31341 = (inst_31330 >= flake_limit);
var inst_31342 = (inst_31331 >= subject_limit);
var inst_31343 = ((inst_31340) || (inst_31341) || (inst_31342));
var state_31364__$1 = (function (){var statearr_31371 = state_31364;
(statearr_31371[(13)] = inst_31338__$1);

(statearr_31371[(14)] = inst_31339);

return statearr_31371;
})();
if(cljs.core.truth_(inst_31343)){
var statearr_31372_31389 = state_31364__$1;
(statearr_31372_31389[(1)] = (4));

} else {
var statearr_31373_31390 = state_31364__$1;
(statearr_31373_31390[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (9))){
var inst_31330 = (state_31364[(7)]);
var inst_31338 = (state_31364[(13)]);
var inst_31339 = (state_31364[(14)]);
var inst_31349 = (state_31364[(15)]);
var inst_31331 = (state_31364[(9)]);
var inst_31332 = (state_31364[(11)]);
var inst_31354 = (state_31364[(2)]);
var inst_31355 = (inst_31330 + inst_31349);
var inst_31356 = (inst_31331 + inst_31354);
var inst_31357 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31332,inst_31338);
var inst_31329 = inst_31339;
var inst_31330__$1 = inst_31355;
var inst_31331__$1 = inst_31356;
var inst_31332__$1 = inst_31357;
var state_31364__$1 = (function (){var statearr_31374 = state_31364;
(statearr_31374[(7)] = inst_31330__$1);

(statearr_31374[(9)] = inst_31331__$1);

(statearr_31374[(11)] = inst_31332__$1);

(statearr_31374[(12)] = inst_31329);

return statearr_31374;
})();
var statearr_31375_31391 = state_31364__$1;
(statearr_31375_31391[(2)] = null);

(statearr_31375_31391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (5))){
var inst_31338 = (state_31364[(13)]);
var inst_31349 = (state_31364[(15)]);
var inst_31349__$1 = cljs.core.count(inst_31338);
var inst_31350 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31349__$1);
var state_31364__$1 = (function (){var statearr_31376 = state_31364;
(statearr_31376[(15)] = inst_31349__$1);

return statearr_31376;
})();
if(inst_31350){
var statearr_31377_31392 = state_31364__$1;
(statearr_31377_31392[(1)] = (7));

} else {
var statearr_31378_31393 = state_31364__$1;
(statearr_31378_31393[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31365 === (8))){
var state_31364__$1 = state_31364;
var statearr_31379_31394 = state_31364__$1;
(statearr_31379_31394[(2)] = (1));

(statearr_31379_31394[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0 = (function (){
var statearr_31380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31380[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__);

(statearr_31380[(1)] = (1));

return statearr_31380;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1 = (function (state_31364){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31364);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31381){var ex__16304__auto__ = e31381;
var statearr_31382_31395 = state_31364;
(statearr_31382_31395[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31364[(4)]))){
var statearr_31383_31396 = state_31364;
(statearr_31383_31396[(1)] = cljs.core.first((state_31364[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31397 = state_31364;
state_31364 = G__31397;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__ = function(state_31364){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1.call(this,state_31364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31384 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31384[(6)] = c__16375__auto__);

return statearr_31384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31443){
var state_val_31444 = (state_31443[(1)]);
if((state_val_31444 === (7))){
var state_31443__$1 = state_31443;
var statearr_31445_31483 = state_31443__$1;
(statearr_31445_31483[(2)] = null);

(statearr_31445_31483[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (20))){
var inst_31429 = (state_31443[(2)]);
var inst_31430 = fluree.db.util.async.throw_err(inst_31429);
var inst_31408 = inst_31430;
var state_31443__$1 = (function (){var statearr_31446 = state_31443;
(statearr_31446[(7)] = inst_31408);

return statearr_31446;
})();
var statearr_31447_31484 = state_31443__$1;
(statearr_31447_31484[(2)] = null);

(statearr_31447_31484[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (1))){
var state_31443__$1 = state_31443;
var statearr_31448_31485 = state_31443__$1;
(statearr_31448_31485[(2)] = null);

(statearr_31448_31485[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (4))){
var inst_31398 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31449_31486 = state_31443__$1;
(statearr_31449_31486[(2)] = inst_31398);

(statearr_31449_31486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (15))){
var inst_31408 = (state_31443[(7)]);
var inst_31425 = (state_31443[(8)]);
var inst_31425__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_31408);
var state_31443__$1 = (function (){var statearr_31450 = state_31443;
(statearr_31450[(8)] = inst_31425__$1);

return statearr_31450;
})();
if(cljs.core.truth_(inst_31425__$1)){
var statearr_31451_31487 = state_31443__$1;
(statearr_31451_31487[(1)] = (17));

} else {
var statearr_31452_31488 = state_31443__$1;
(statearr_31452_31488[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (13))){
var inst_31418 = (state_31443[(2)]);
var inst_31419 = fluree.db.util.async.throw_err(inst_31418);
var _ = (function (){var statearr_31453 = state_31443;
(statearr_31453[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31453;
})();
var state_31443__$1 = state_31443;
var statearr_31454_31489 = state_31443__$1;
(statearr_31454_31489[(2)] = inst_31419);

(statearr_31454_31489[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (6))){
var inst_31406 = (state_31443[(2)]);
var inst_31407 = fluree.db.util.async.throw_err(inst_31406);
var inst_31408 = inst_31407;
var state_31443__$1 = (function (){var statearr_31455 = state_31443;
(statearr_31455[(7)] = inst_31408);

return statearr_31455;
})();
var statearr_31456_31490 = state_31443__$1;
(statearr_31456_31490[(2)] = null);

(statearr_31456_31490[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (17))){
var inst_31425 = (state_31443[(8)]);
var inst_31427 = fluree.db.dbproto._lookup_leaf(root_node,inst_31425);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(20),inst_31427);
} else {
if((state_val_31444 === (3))){
var inst_31441 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31443__$1,inst_31441);
} else {
if((state_val_31444 === (12))){
var _ = (function (){var statearr_31458 = state_31443;
(statearr_31458[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31458;
})();
var state_31443__$1 = state_31443;
var ex31457 = (state_31443__$1[(2)]);
var statearr_31459_31491 = state_31443__$1;
(statearr_31459_31491[(5)] = ex31457);


var statearr_31460_31492 = state_31443__$1;
(statearr_31460_31492[(1)] = (11));

(statearr_31460_31492[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (2))){
var _ = (function (){var statearr_31461 = state_31443;
(statearr_31461[(4)] = cljs.core.cons((5),(state_31443[(4)])));

return statearr_31461;
})();
var inst_31404 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(6),inst_31404);
} else {
if((state_val_31444 === (19))){
var inst_31434 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31462_31493 = state_31443__$1;
(statearr_31462_31493[(2)] = inst_31434);

(statearr_31462_31493[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (11))){
var inst_31410 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31464 = state_31443;
(statearr_31464[(9)] = inst_31410);

return statearr_31464;
})();
var statearr_31465_31494 = state_31443__$1;
(statearr_31465_31494[(2)] = null);

(statearr_31465_31494[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (9))){
var inst_31408 = (state_31443[(7)]);
var _ = (function (){var statearr_31466 = state_31443;
(statearr_31466[(4)] = cljs.core.cons((12),(state_31443[(4)])));

return statearr_31466;
})();
var inst_31416 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_31408,t,novelty,fast_forward_db_QMARK_);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31443__$1,(13),inst_31416);
} else {
if((state_val_31444 === (5))){
var _ = (function (){var statearr_31467 = state_31443;
(statearr_31467[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31467;
})();
var state_31443__$1 = state_31443;
var ex31463 = (state_31443__$1[(2)]);
var statearr_31468_31495 = state_31443__$1;
(statearr_31468_31495[(5)] = ex31463);


if((ex31463 instanceof Error)){
var statearr_31469_31496 = state_31443__$1;
(statearr_31469_31496[(1)] = (4));

(statearr_31469_31496[(5)] = null);

} else {
throw ex31463;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (14))){
var inst_31422 = (state_31443[(10)]);
var state_31443__$1 = state_31443;
var statearr_31470_31497 = state_31443__$1;
(statearr_31470_31497[(2)] = inst_31422);

(statearr_31470_31497[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (16))){
var inst_31436 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31471_31498 = state_31443__$1;
(statearr_31471_31498[(2)] = inst_31436);

(statearr_31471_31498[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (10))){
var inst_31422 = (state_31443[(10)]);
var inst_31422__$1 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31472 = state_31443;
(statearr_31472[(10)] = inst_31422__$1);

return statearr_31472;
})();
if(cljs.core.truth_(inst_31422__$1)){
var statearr_31473_31499 = state_31443__$1;
(statearr_31473_31499[(1)] = (14));

} else {
var statearr_31474_31500 = state_31443__$1;
(statearr_31474_31500[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (18))){
var state_31443__$1 = state_31443;
var statearr_31475_31501 = state_31443__$1;
(statearr_31475_31501[(2)] = null);

(statearr_31475_31501[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31444 === (8))){
var inst_31438 = (state_31443[(2)]);
var _ = (function (){var statearr_31476 = state_31443;
(statearr_31476[(4)] = cljs.core.rest((state_31443[(4)])));

return statearr_31476;
})();
var state_31443__$1 = state_31443;
var statearr_31477_31502 = state_31443__$1;
(statearr_31477_31502[(2)] = inst_31438);

(statearr_31477_31502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0 = (function (){
var statearr_31478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31478[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__);

(statearr_31478[(1)] = (1));

return statearr_31478;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1 = (function (state_31443){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31443);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31479){var ex__16304__auto__ = e31479;
var statearr_31480_31503 = state_31443;
(statearr_31480_31503[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31443[(4)]))){
var statearr_31481_31504 = state_31443;
(statearr_31481_31504[(1)] = cljs.core.first((state_31443[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31505 = state_31443;
state_31443 = G__31505;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__ = function(state_31443){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1.call(this,state_31443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31482 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31482[(6)] = c__16375__auto__);

return statearr_31482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__31512 = arguments.length;
switch (G__31512) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31513 = (function (){var pred__31516 = cljs.core.identical_QMARK_;
var expr__31517 = test;
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__31517) : pred__31516.call(null,cljs.core._EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__31517) : pred__31516.call(null,cljs.core._LT_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__31517) : pred__31516.call(null,cljs.core._LT__EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__31517) : pred__31516.call(null,cljs.core._GT_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__31516.cljs$core$IFn$_invoke$arity$2 ? pred__31516.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__31517) : pred__31516.call(null,cljs.core._GT__EQ_,expr__31517)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31517)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31513,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31916){
var state_val_31917 = (state_31916[(1)]);
if((state_val_31917 === (121))){
var inst_31777 = (state_31916[(7)]);
var state_31916__$1 = state_31916;
var statearr_31918_32124 = state_31916__$1;
(statearr_31918_32124[(2)] = inst_31777);

(statearr_31918_32124[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (65))){
var state_31916__$1 = state_31916;
var statearr_31919_32125 = state_31916__$1;
(statearr_31919_32125[(2)] = fluree.db.util.core.min_integer);

(statearr_31919_32125[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (70))){
var state_31916__$1 = state_31916;
var statearr_31920_32126 = state_31916__$1;
(statearr_31920_32126[(2)] = true);

(statearr_31920_32126[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (62))){
var inst_31679 = (cljs.core._LT__EQ_ === end_test);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31679)){
var statearr_31921_32127 = state_31916__$1;
(statearr_31921_32127[(1)] = (64));

} else {
var statearr_31922_32128 = state_31916__$1;
(statearr_31922_32128[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (74))){
var inst_31688 = (state_31916[(8)]);
var state_31916__$1 = state_31916;
var statearr_31923_32129 = state_31916__$1;
(statearr_31923_32129[(2)] = inst_31688);

(statearr_31923_32129[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (110))){
var inst_31810 = (state_31916[(9)]);
var inst_31820 = (state_31916[(10)]);
var inst_31818 = (state_31916[(11)]);
var inst_31716 = (state_31916[(12)]);
var inst_31819 = (state_31916[(13)]);
var inst_31743 = (state_31916[(14)]);
var inst_31818__$1 = cljs.core.count(inst_31810);
var inst_31819__$1 = (inst_31743 + inst_31818__$1);
var inst_31820__$1 = (inst_31819__$1 - inst_31716);
var inst_31821 = cljs.core.pos_int_QMARK_(inst_31820__$1);
var state_31916__$1 = (function (){var statearr_31924 = state_31916;
(statearr_31924[(10)] = inst_31820__$1);

(statearr_31924[(11)] = inst_31818__$1);

(statearr_31924[(13)] = inst_31819__$1);

return statearr_31924;
})();
if(inst_31821){
var statearr_31925_32130 = state_31916__$1;
(statearr_31925_32130[(1)] = (113));

} else {
var statearr_31926_32131 = state_31916__$1;
(statearr_31926_32131[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (130))){
var inst_31879 = (state_31916[(15)]);
var state_31916__$1 = state_31916;
var statearr_31927_32132 = state_31916__$1;
(statearr_31927_32132[(2)] = inst_31879);

(statearr_31927_32132[(1)] = (132));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (128))){
var inst_31888 = (state_31916[(16)]);
var state_31916__$1 = state_31916;
var statearr_31928_32133 = state_31916__$1;
(statearr_31928_32133[(2)] = inst_31888);

(statearr_31928_32133[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (7))){
var state_31916__$1 = state_31916;
var statearr_31929_32134 = state_31916__$1;
(statearr_31929_32134[(2)] = false);

(statearr_31929_32134[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (59))){
var state_31916__$1 = state_31916;
var statearr_31930_32135 = state_31916__$1;
(statearr_31930_32135[(2)] = (2147483647));

(statearr_31930_32135[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (86))){
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31733 = (state_31916[(19)]);
var inst_31631 = (state_31916[(20)]);
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31737 = (state_31916[(23)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31723 = (state_31916[(27)]);
var inst_31543 = (state_31916[(28)]);
var inst_31575 = (state_31916[(29)]);
var inst_31628 = (state_31916[(30)]);
var inst_31546 = (state_31916[(31)]);
var inst_31658 = (state_31916[(32)]);
var inst_31741 = (state_31916[(33)]);
var inst_31595 = (state_31916[(34)]);
var inst_31687 = (state_31916[(35)]);
var inst_31709 = (state_31916[(36)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31717 = (state_31916[(38)]);
var inst_31550 = (state_31916[(39)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31744 = (state_31916[(42)]);
var inst_31627 = (state_31916[(43)]);
var inst_31727 = (state_31916[(44)]);
var inst_31718 = (state_31916[(45)]);
var inst_31750 = (state_31916[(46)]);
var inst_31640 = (state_31916[(47)]);
var inst_31728 = (state_31916[(48)]);
var inst_31539 = (state_31916[(49)]);
var inst_31743 = (state_31916[(14)]);
var inst_31544 = (state_31916[(50)]);
var inst_31686 = (state_31916[(51)]);
var inst_31574 = (state_31916[(52)]);
var inst_31740 = (state_31916[(53)]);
var inst_31754 = (function (){var no_filter_QMARK_ = true;
var t = inst_31723;
var max_limit_QMARK_ = inst_31717;
var next_node = inst_31740;
var fast_forward_db_QMARK_ = inst_31728;
var G__31751 = inst_31750;
var s1 = inst_31586;
var o2 = inst_31649;
var t1 = inst_31543;
var map__31538 = inst_31709;
var predicate_fn = inst_31576;
var i = inst_31742;
var m1 = inst_31676;
var root_node = inst_31733;
var s2 = inst_31595;
var vec__31532 = inst_31627;
var p2 = inst_31667;
var permissions = inst_31718;
var limit = inst_31716;
var start_flake = inst_31686;
var map__31531 = inst_31574;
var flake_limit = inst_31710;
var offset = inst_31741;
var acc = inst_31744;
var vec__31528 = inst_31546;
var vec__31535 = inst_31628;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31640;
var end_flake = inst_31687;
var base_result = inst_31750;
var s = inst_31743;
var node_start = inst_31737;
var p1 = inst_31658;
var subject_fn = inst_31575;
var object_fn = inst_31631;
var vec__31525 = inst_31539;
var idx_compare = inst_31722;
var op2 = inst_31551;
var m2 = inst_31685;
var novelty = inst_31727;
return (function (p1__31506_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31506_SHARP_.o,start_flake.o);
});
})();
var inst_31755 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31754,inst_31750);
var state_31916__$1 = state_31916;
var statearr_31931_32136 = state_31916__$1;
(statearr_31931_32136[(2)] = inst_31755);

(statearr_31931_32136[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (20))){
var inst_31547 = (state_31916[(54)]);
var state_31916__$1 = state_31916;
var statearr_31932_32137 = state_31916__$1;
(statearr_31932_32137[(2)] = inst_31547);

(statearr_31932_32137[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (72))){
var inst_31701 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31933_32138 = state_31916__$1;
(statearr_31933_32138[(2)] = inst_31701);

(statearr_31933_32138[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (58))){
var state_31916__$1 = state_31916;
var statearr_31934_32139 = state_31916__$1;
(statearr_31934_32139[(2)] = fluree.db.util.core.min_integer);

(statearr_31934_32139[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (60))){
var inst_31674 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31935_32140 = state_31916__$1;
(statearr_31935_32140[(2)] = inst_31674);

(statearr_31935_32140[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (27))){
var state_31916__$1 = state_31916;
var statearr_31936_32141 = state_31916__$1;
(statearr_31936_32141[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (1))){
var state_31916__$1 = state_31916;
var statearr_31938_32142 = state_31916__$1;
(statearr_31938_32142[(2)] = null);

(statearr_31938_32142[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (69))){
var inst_31704 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31704)){
var statearr_31939_32143 = state_31916__$1;
(statearr_31939_32143[(1)] = (73));

} else {
var statearr_31940_32144 = state_31916__$1;
(statearr_31940_32144[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (101))){
var state_31916__$1 = state_31916;
var statearr_31941_32145 = state_31916__$1;
(statearr_31941_32145[(2)] = true);

(statearr_31941_32145[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (24))){
var inst_31549 = (state_31916[(55)]);
var inst_31599 = cljs.core.boolean_QMARK_(inst_31549);
var state_31916__$1 = state_31916;
if(inst_31599){
var statearr_31942_32146 = state_31916__$1;
(statearr_31942_32146[(1)] = (26));

} else {
var statearr_31943_32147 = state_31916__$1;
(statearr_31943_32147[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (102))){
var state_31916__$1 = state_31916;
var statearr_31944_32148 = state_31916__$1;
(statearr_31944_32148[(2)] = false);

(statearr_31944_32148[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (55))){
var inst_31545 = (state_31916[(56)]);
var state_31916__$1 = state_31916;
var statearr_31945_32149 = state_31916__$1;
(statearr_31945_32149[(2)] = inst_31545);

(statearr_31945_32149[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (85))){
var inst_31908 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31946_32150 = state_31916__$1;
(statearr_31946_32150[(2)] = inst_31908);

(statearr_31946_32150[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (39))){
var inst_31630 = (state_31916[(57)]);
var inst_31643 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31630);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(42),inst_31643);
} else {
if((state_val_31917 === (88))){
var inst_31575 = (state_31916[(29)]);
var inst_31758 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_31947 = state_31916;
(statearr_31947[(58)] = inst_31758);

return statearr_31947;
})();
if(cljs.core.truth_(inst_31575)){
var statearr_31948_32151 = state_31916__$1;
(statearr_31948_32151[(1)] = (89));

} else {
var statearr_31949_32152 = state_31916__$1;
(statearr_31949_32152[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (46))){
var state_31916__$1 = state_31916;
var statearr_31950_32153 = state_31916__$1;
(statearr_31950_32153[(2)] = (-1));

(statearr_31950_32153[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (4))){
var inst_31519 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31951_32154 = state_31916__$1;
(statearr_31951_32154[(2)] = inst_31519);

(statearr_31951_32154[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (77))){
var state_31916__$1 = state_31916;
var statearr_31952_32155 = state_31916__$1;
(statearr_31952_32155[(2)] = fluree.db.util.core.max_long);

(statearr_31952_32155[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (106))){
var inst_31777 = (state_31916[(7)]);
var inst_31875 = (state_31916[(2)]);
var inst_31876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31875,(0),null);
var inst_31877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31875,(1),null);
var inst_31878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31875,(2),null);
var inst_31879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31875,(3),null);
var state_31916__$1 = (function (){var statearr_31953 = state_31916;
(statearr_31953[(15)] = inst_31879);

(statearr_31953[(59)] = inst_31878);

(statearr_31953[(60)] = inst_31877);

(statearr_31953[(61)] = inst_31876);

return statearr_31953;
})();
if(cljs.core.truth_(inst_31777)){
var statearr_31954_32156 = state_31916__$1;
(statearr_31954_32156[(1)] = (120));

} else {
var statearr_31955_32157 = state_31916__$1;
(statearr_31955_32157[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (119))){
var inst_31861 = (state_31916[(2)]);
var inst_31862 = fluree.db.util.async.throw_err(inst_31861);
var state_31916__$1 = state_31916;
var statearr_31956_32158 = state_31916__$1;
(statearr_31956_32158[(2)] = inst_31862);

(statearr_31956_32158[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (95))){
var inst_31770 = (state_31916[(62)]);
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31733 = (state_31916[(19)]);
var inst_31631 = (state_31916[(20)]);
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31737 = (state_31916[(23)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31723 = (state_31916[(27)]);
var inst_31543 = (state_31916[(28)]);
var inst_31575 = (state_31916[(29)]);
var inst_31628 = (state_31916[(30)]);
var inst_31546 = (state_31916[(31)]);
var inst_31658 = (state_31916[(32)]);
var inst_31741 = (state_31916[(33)]);
var inst_31595 = (state_31916[(34)]);
var inst_31687 = (state_31916[(35)]);
var inst_31709 = (state_31916[(36)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31717 = (state_31916[(38)]);
var inst_31550 = (state_31916[(39)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31744 = (state_31916[(42)]);
var inst_31627 = (state_31916[(43)]);
var inst_31727 = (state_31916[(44)]);
var inst_31718 = (state_31916[(45)]);
var inst_31750 = (state_31916[(46)]);
var inst_31640 = (state_31916[(47)]);
var inst_31728 = (state_31916[(48)]);
var inst_31539 = (state_31916[(49)]);
var inst_31743 = (state_31916[(14)]);
var inst_31544 = (state_31916[(50)]);
var inst_31686 = (state_31916[(51)]);
var inst_31574 = (state_31916[(52)]);
var inst_31740 = (state_31916[(53)]);
var inst_31772 = (function (){var no_filter_QMARK_ = true;
var t = inst_31723;
var max_limit_QMARK_ = inst_31717;
var next_node = inst_31740;
var fast_forward_db_QMARK_ = inst_31728;
var G__31751 = inst_31770;
var s1 = inst_31586;
var o2 = inst_31649;
var t1 = inst_31543;
var map__31538 = inst_31709;
var predicate_fn = inst_31576;
var i = inst_31742;
var m1 = inst_31676;
var root_node = inst_31733;
var s2 = inst_31595;
var vec__31532 = inst_31627;
var p2 = inst_31667;
var permissions = inst_31718;
var limit = inst_31716;
var start_flake = inst_31686;
var map__31531 = inst_31574;
var flake_limit = inst_31710;
var offset = inst_31741;
var acc = inst_31744;
var vec__31528 = inst_31546;
var vec__31535 = inst_31628;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31640;
var end_flake = inst_31687;
var base_result = inst_31750;
var s = inst_31743;
var node_start = inst_31737;
var p1 = inst_31658;
var subject_fn = inst_31575;
var object_fn = inst_31631;
var vec__31525 = inst_31539;
var idx_compare = inst_31722;
var op2 = inst_31551;
var m2 = inst_31685;
var novelty = inst_31727;
return (function (p1__31509_SHARP_){
var G__31957 = p1__31509_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__31957) : object_fn.call(null,G__31957));
});
})();
var inst_31773 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31772,inst_31770);
var state_31916__$1 = state_31916;
var statearr_31958_32159 = state_31916__$1;
(statearr_31958_32159[(2)] = inst_31773);

(statearr_31958_32159[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (54))){
var inst_31545 = (state_31916[(56)]);
var inst_31667 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_31959 = state_31916;
(statearr_31959[(24)] = inst_31667);

return statearr_31959;
})();
if(cljs.core.truth_(inst_31545)){
var statearr_31960_32160 = state_31916__$1;
(statearr_31960_32160[(1)] = (55));

} else {
var statearr_31961_32161 = state_31916__$1;
(statearr_31961_32161[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (92))){
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31733 = (state_31916[(19)]);
var inst_31631 = (state_31916[(20)]);
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31737 = (state_31916[(23)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31723 = (state_31916[(27)]);
var inst_31543 = (state_31916[(28)]);
var inst_31764 = (state_31916[(63)]);
var inst_31575 = (state_31916[(29)]);
var inst_31628 = (state_31916[(30)]);
var inst_31546 = (state_31916[(31)]);
var inst_31658 = (state_31916[(32)]);
var inst_31741 = (state_31916[(33)]);
var inst_31595 = (state_31916[(34)]);
var inst_31687 = (state_31916[(35)]);
var inst_31709 = (state_31916[(36)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31717 = (state_31916[(38)]);
var inst_31550 = (state_31916[(39)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31744 = (state_31916[(42)]);
var inst_31627 = (state_31916[(43)]);
var inst_31727 = (state_31916[(44)]);
var inst_31718 = (state_31916[(45)]);
var inst_31750 = (state_31916[(46)]);
var inst_31640 = (state_31916[(47)]);
var inst_31728 = (state_31916[(48)]);
var inst_31539 = (state_31916[(49)]);
var inst_31743 = (state_31916[(14)]);
var inst_31544 = (state_31916[(50)]);
var inst_31686 = (state_31916[(51)]);
var inst_31574 = (state_31916[(52)]);
var inst_31740 = (state_31916[(53)]);
var inst_31766 = (function (){var no_filter_QMARK_ = true;
var t = inst_31723;
var max_limit_QMARK_ = inst_31717;
var next_node = inst_31740;
var fast_forward_db_QMARK_ = inst_31728;
var G__31751 = inst_31764;
var s1 = inst_31586;
var o2 = inst_31649;
var t1 = inst_31543;
var map__31538 = inst_31709;
var predicate_fn = inst_31576;
var i = inst_31742;
var m1 = inst_31676;
var root_node = inst_31733;
var s2 = inst_31595;
var vec__31532 = inst_31627;
var p2 = inst_31667;
var permissions = inst_31718;
var limit = inst_31716;
var start_flake = inst_31686;
var map__31531 = inst_31574;
var flake_limit = inst_31710;
var offset = inst_31741;
var acc = inst_31744;
var vec__31528 = inst_31546;
var vec__31535 = inst_31628;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31640;
var end_flake = inst_31687;
var base_result = inst_31750;
var s = inst_31743;
var node_start = inst_31737;
var p1 = inst_31658;
var subject_fn = inst_31575;
var object_fn = inst_31631;
var vec__31525 = inst_31539;
var idx_compare = inst_31722;
var op2 = inst_31551;
var m2 = inst_31685;
var novelty = inst_31727;
return (function (p1__31508_SHARP_){
var G__31962 = p1__31508_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__31962) : predicate_fn.call(null,G__31962));
});
})();
var inst_31767 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31766,inst_31764);
var state_31916__$1 = state_31916;
var statearr_31963_32162 = state_31916__$1;
(statearr_31963_32162[(2)] = inst_31767);

(statearr_31963_32162[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (104))){
var inst_31710 = (state_31916[(21)]);
var inst_31742 = (state_31916[(37)]);
var inst_31744 = (state_31916[(42)]);
var inst_31776 = (state_31916[(64)]);
var inst_31743 = (state_31916[(14)]);
var inst_31788 = cljs.core.count(inst_31776);
var inst_31789 = (inst_31710 - inst_31742);
var inst_31790 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31789,inst_31776);
var inst_31791 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31744,inst_31790);
var inst_31792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31793 = (inst_31742 + inst_31788);
var inst_31794 = [(0),inst_31793,inst_31743,inst_31791];
var inst_31795 = (new cljs.core.PersistentVector(null,4,(5),inst_31792,inst_31794,null));
var state_31916__$1 = state_31916;
var statearr_31964_32163 = state_31916__$1;
(statearr_31964_32163[(2)] = inst_31795);

(statearr_31964_32163[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (15))){
var inst_31540 = (state_31916[(65)]);
var inst_31580 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31540);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(18),inst_31580);
} else {
if((state_val_31917 === (48))){
var inst_31548 = (state_31916[(66)]);
var inst_31658 = (state_31916[(2)]);
var inst_31659 = (inst_31548 == null);
var state_31916__$1 = (function (){var statearr_31965 = state_31916;
(statearr_31965[(32)] = inst_31658);

return statearr_31965;
})();
if(cljs.core.truth_(inst_31659)){
var statearr_31966_32164 = state_31916__$1;
(statearr_31966_32164[(1)] = (49));

} else {
var statearr_31967_32165 = state_31916__$1;
(statearr_31967_32165[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (50))){
var state_31916__$1 = state_31916;
var statearr_31968_32166 = state_31916__$1;
(statearr_31968_32166[(2)] = false);

(statearr_31968_32166[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (116))){
var inst_31710 = (state_31916[(21)]);
var inst_31838 = (state_31916[(67)]);
var inst_31836 = (state_31916[(68)]);
var inst_31837 = (state_31916[(69)]);
var inst_31841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31842 = (inst_31838 - inst_31710);
var inst_31843 = (inst_31837 - inst_31842);
var inst_31844 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31843,inst_31836);
var inst_31845 = [inst_31710,inst_31844];
var inst_31846 = (new cljs.core.PersistentVector(null,2,(5),inst_31841,inst_31845,null));
var state_31916__$1 = state_31916;
var statearr_31969_32167 = state_31916__$1;
(statearr_31969_32167[(2)] = inst_31846);

(statearr_31969_32167[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (75))){
var inst_31709 = (state_31916[(36)]);
var inst_31711 = (state_31916[(70)]);
var inst_31709__$1 = (state_31916[(2)]);
var inst_31710 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_31709__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_31711__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31709__$1,cljs.core.cst$kw$limit);
var inst_31712 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_31709__$1,cljs.core.cst$kw$offset,(0));
var state_31916__$1 = (function (){var statearr_31970 = state_31916;
(statearr_31970[(21)] = inst_31710);

(statearr_31970[(36)] = inst_31709__$1);

(statearr_31970[(71)] = inst_31712);

(statearr_31970[(70)] = inst_31711__$1);

return statearr_31970;
})();
if(cljs.core.truth_(inst_31711__$1)){
var statearr_31971_32168 = state_31916__$1;
(statearr_31971_32168[(1)] = (76));

} else {
var statearr_31972_32169 = state_31916__$1;
(statearr_31972_32169[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (99))){
var inst_31717 = (state_31916[(38)]);
var state_31916__$1 = state_31916;
var statearr_31973_32170 = state_31916__$1;
(statearr_31973_32170[(2)] = inst_31717);

(statearr_31973_32170[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (21))){
var inst_31542 = (state_31916[(72)]);
var inst_31595 = (state_31916[(2)]);
var inst_31596 = cljs.core.boolean_QMARK_(inst_31542);
var state_31916__$1 = (function (){var statearr_31974 = state_31916;
(statearr_31974[(34)] = inst_31595);

return statearr_31974;
})();
if(inst_31596){
var statearr_31975_32171 = state_31916__$1;
(statearr_31975_32171[(1)] = (23));

} else {
var statearr_31976_32172 = state_31916__$1;
(statearr_31976_32172[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (31))){
var inst_31605 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31977_32173 = state_31916__$1;
(statearr_31977_32173[(2)] = inst_31605);

(statearr_31977_32173[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (113))){
var inst_31820 = (state_31916[(10)]);
var inst_31818 = (state_31916[(11)]);
var inst_31716 = (state_31916[(12)]);
var inst_31823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31824 = (inst_31818 - inst_31820);
var inst_31825 = [inst_31716,inst_31824];
var inst_31826 = (new cljs.core.PersistentVector(null,2,(5),inst_31823,inst_31825,null));
var state_31916__$1 = state_31916;
var statearr_31978_32174 = state_31916__$1;
(statearr_31978_32174[(2)] = inst_31826);

(statearr_31978_32174[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (32))){
var inst_31577 = (state_31916[(73)]);
var inst_31549 = (state_31916[(55)]);
var inst_31542 = (state_31916[(72)]);
var inst_31612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31614 = [inst_31542,inst_31549];
var inst_31615 = (new cljs.core.PersistentVector(null,2,(5),inst_31613,inst_31614,null));
var inst_31616 = [inst_31615,inst_31577];
var inst_31617 = (new cljs.core.PersistentVector(null,2,(5),inst_31612,inst_31616,null));
var state_31916__$1 = state_31916;
var statearr_31979_32175 = state_31916__$1;
(statearr_31979_32175[(2)] = inst_31617);

(statearr_31979_32175[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (40))){
var inst_31630 = (state_31916[(57)]);
var state_31916__$1 = state_31916;
var statearr_31980_32176 = state_31916__$1;
(statearr_31980_32176[(2)] = inst_31630);

(statearr_31980_32176[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (129))){
var inst_31900 = (state_31916[(2)]);
var inst_31901 = cljs.core.not(inst_31900);
var state_31916__$1 = state_31916;
if(inst_31901){
var statearr_31981_32177 = state_31916__$1;
(statearr_31981_32177[(1)] = (130));

} else {
var statearr_31982_32178 = state_31916__$1;
(statearr_31982_32178[(1)] = (131));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (91))){
var inst_31576 = (state_31916[(18)]);
var inst_31764 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_31983 = state_31916;
(statearr_31983[(63)] = inst_31764);

return statearr_31983;
})();
if(cljs.core.truth_(inst_31576)){
var statearr_31984_32179 = state_31916__$1;
(statearr_31984_32179[(1)] = (92));

} else {
var statearr_31985_32180 = state_31916__$1;
(statearr_31985_32180[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (117))){
var inst_31838 = (state_31916[(67)]);
var inst_31836 = (state_31916[(68)]);
var inst_31848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31849 = [inst_31838,inst_31836];
var inst_31850 = (new cljs.core.PersistentVector(null,2,(5),inst_31848,inst_31849,null));
var state_31916__$1 = state_31916;
var statearr_31986_32181 = state_31916__$1;
(statearr_31986_32181[(2)] = inst_31850);

(statearr_31986_32181[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (108))){
var inst_31741 = (state_31916[(33)]);
var inst_31798 = (state_31916[(74)]);
var inst_31810 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_31741,inst_31798);
var state_31916__$1 = (function (){var statearr_31987 = state_31916;
(statearr_31987[(9)] = inst_31810);

return statearr_31987;
})();
var statearr_31988_32182 = state_31916__$1;
(statearr_31988_32182[(1)] = (110));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (56))){
var inst_31670 = (cljs.core._GT__EQ_ === start_test);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31670)){
var statearr_31990_32183 = state_31916__$1;
(statearr_31990_32183[(1)] = (58));

} else {
var statearr_31991_32184 = state_31916__$1;
(statearr_31991_32184[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (33))){
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31552 = (state_31916[(75)]);
var inst_31577 = (state_31916[(73)]);
var inst_31586 = (state_31916[(26)]);
var inst_31545 = (state_31916[(56)]);
var inst_31549 = (state_31916[(55)]);
var inst_31543 = (state_31916[(28)]);
var inst_31575 = (state_31916[(29)]);
var inst_31546 = (state_31916[(31)]);
var inst_31541 = (state_31916[(76)]);
var inst_31595 = (state_31916[(34)]);
var inst_31548 = (state_31916[(66)]);
var inst_31550 = (state_31916[(39)]);
var inst_31609 = (state_31916[(77)]);
var inst_31539 = (state_31916[(49)]);
var inst_31542 = (state_31916[(72)]);
var inst_31544 = (state_31916[(50)]);
var inst_31574 = (state_31916[(52)]);
var inst_31619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31621 = [null,null];
var inst_31622 = (new cljs.core.PersistentVector(null,2,(5),inst_31620,inst_31621,null));
var inst_31623 = (function (){var bool = inst_31609;
var s1 = inst_31586;
var o2 = inst_31549;
var t1 = inst_31543;
var predicate_fn = inst_31576;
var m1 = inst_31545;
var s2 = inst_31595;
var p2 = inst_31548;
var temp__5737__auto__ = inst_31609;
var map__31531 = inst_31574;
var vec__31528 = inst_31546;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31542;
var p1 = inst_31541;
var subject_fn = inst_31575;
var object_fn = inst_31577;
var vec__31525 = inst_31539;
var op2 = inst_31551;
var m2 = inst_31552;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_31624 = [inst_31622,inst_31623];
var inst_31625 = (new cljs.core.PersistentVector(null,2,(5),inst_31619,inst_31624,null));
var state_31916__$1 = state_31916;
var statearr_31992_32185 = state_31916__$1;
(statearr_31992_32185[(2)] = inst_31625);

(statearr_31992_32185[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (13))){
var inst_31553 = (state_31916[(78)]);
var state_31916__$1 = state_31916;
var statearr_31993_32186 = state_31916__$1;
(statearr_31993_32186[(2)] = inst_31553);

(statearr_31993_32186[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (22))){
var inst_31591 = (state_31916[(2)]);
var inst_31592 = fluree.db.util.async.throw_err(inst_31591);
var state_31916__$1 = state_31916;
var statearr_31994_32187 = state_31916__$1;
(statearr_31994_32187[(2)] = inst_31592);

(statearr_31994_32187[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (90))){
var inst_31758 = (state_31916[(58)]);
var state_31916__$1 = state_31916;
var statearr_31995_32188 = state_31916__$1;
(statearr_31995_32188[(2)] = inst_31758);

(statearr_31995_32188[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (109))){
var inst_31873 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31996_32189 = state_31916__$1;
(statearr_31996_32189[(2)] = inst_31873);

(statearr_31996_32189[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (36))){
var inst_31629 = (state_31916[(79)]);
var state_31916__$1 = state_31916;
var statearr_31997_32190 = state_31916__$1;
(statearr_31997_32190[(2)] = inst_31629);

(statearr_31997_32190[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (41))){
var inst_31541 = (state_31916[(76)]);
var inst_31649 = (state_31916[(2)]);
var inst_31650 = (inst_31541 == null);
var state_31916__$1 = (function (){var statearr_31998 = state_31916;
(statearr_31998[(25)] = inst_31649);

return statearr_31998;
})();
if(cljs.core.truth_(inst_31650)){
var statearr_31999_32191 = state_31916__$1;
(statearr_31999_32191[(1)] = (43));

} else {
var statearr_32000_32192 = state_31916__$1;
(statearr_32000_32192[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (118))){
var inst_31833 = (state_31916[(80)]);
var inst_31852 = (state_31916[(2)]);
var inst_31853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31852,(0),null);
var inst_31854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31852,(1),null);
var inst_31855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31856 = [inst_31853,inst_31833,inst_31854];
var inst_31857 = (new cljs.core.PersistentVector(null,3,(5),inst_31855,inst_31856,null));
var state_31916__$1 = state_31916;
var statearr_32001_32193 = state_31916__$1;
(statearr_32001_32193[(2)] = inst_31857);

(statearr_32001_32193[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (89))){
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31733 = (state_31916[(19)]);
var inst_31631 = (state_31916[(20)]);
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31737 = (state_31916[(23)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31723 = (state_31916[(27)]);
var inst_31758 = (state_31916[(58)]);
var inst_31543 = (state_31916[(28)]);
var inst_31575 = (state_31916[(29)]);
var inst_31628 = (state_31916[(30)]);
var inst_31546 = (state_31916[(31)]);
var inst_31658 = (state_31916[(32)]);
var inst_31741 = (state_31916[(33)]);
var inst_31595 = (state_31916[(34)]);
var inst_31687 = (state_31916[(35)]);
var inst_31709 = (state_31916[(36)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31717 = (state_31916[(38)]);
var inst_31550 = (state_31916[(39)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31744 = (state_31916[(42)]);
var inst_31627 = (state_31916[(43)]);
var inst_31727 = (state_31916[(44)]);
var inst_31718 = (state_31916[(45)]);
var inst_31750 = (state_31916[(46)]);
var inst_31640 = (state_31916[(47)]);
var inst_31728 = (state_31916[(48)]);
var inst_31539 = (state_31916[(49)]);
var inst_31743 = (state_31916[(14)]);
var inst_31544 = (state_31916[(50)]);
var inst_31686 = (state_31916[(51)]);
var inst_31574 = (state_31916[(52)]);
var inst_31740 = (state_31916[(53)]);
var inst_31760 = (function (){var no_filter_QMARK_ = true;
var t = inst_31723;
var max_limit_QMARK_ = inst_31717;
var next_node = inst_31740;
var fast_forward_db_QMARK_ = inst_31728;
var G__31751 = inst_31758;
var s1 = inst_31586;
var o2 = inst_31649;
var t1 = inst_31543;
var map__31538 = inst_31709;
var predicate_fn = inst_31576;
var i = inst_31742;
var m1 = inst_31676;
var root_node = inst_31733;
var s2 = inst_31595;
var vec__31532 = inst_31627;
var p2 = inst_31667;
var permissions = inst_31718;
var limit = inst_31716;
var start_flake = inst_31686;
var map__31531 = inst_31574;
var flake_limit = inst_31710;
var offset = inst_31741;
var acc = inst_31744;
var vec__31528 = inst_31546;
var vec__31535 = inst_31628;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31640;
var end_flake = inst_31687;
var base_result = inst_31750;
var s = inst_31743;
var node_start = inst_31737;
var p1 = inst_31658;
var subject_fn = inst_31575;
var object_fn = inst_31631;
var vec__31525 = inst_31539;
var idx_compare = inst_31722;
var op2 = inst_31551;
var m2 = inst_31685;
var novelty = inst_31727;
return (function (p1__31507_SHARP_){
var G__32002 = p1__31507_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__32002) : subject_fn.call(null,G__32002));
});
})();
var inst_31761 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31760,inst_31758);
var state_31916__$1 = state_31916;
var statearr_32003_32194 = state_31916__$1;
(statearr_32003_32194[(2)] = inst_31761);

(statearr_32003_32194[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (100))){
var inst_31786 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31786)){
var statearr_32004_32195 = state_31916__$1;
(statearr_32004_32195[(1)] = (104));

} else {
var statearr_32005_32196 = state_31916__$1;
(statearr_32005_32196[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (131))){
var inst_31879 = (state_31916[(15)]);
var inst_31878 = (state_31916[(59)]);
var inst_31877 = (state_31916[(60)]);
var inst_31876 = (state_31916[(61)]);
var inst_31896 = (state_31916[(81)]);
var inst_31740 = inst_31896;
var inst_31741 = inst_31876;
var inst_31742 = inst_31877;
var inst_31743 = inst_31878;
var inst_31744 = inst_31879;
var state_31916__$1 = (function (){var statearr_32006 = state_31916;
(statearr_32006[(33)] = inst_31741);

(statearr_32006[(37)] = inst_31742);

(statearr_32006[(42)] = inst_31744);

(statearr_32006[(14)] = inst_31743);

(statearr_32006[(53)] = inst_31740);

return statearr_32006;
})();
var statearr_32007_32197 = state_31916__$1;
(statearr_32007_32197[(2)] = null);

(statearr_32007_32197[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (122))){
var inst_31888 = (state_31916[(16)]);
var inst_31888__$1 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_32008 = state_31916;
(statearr_32008[(16)] = inst_31888__$1);

return statearr_32008;
})();
if(cljs.core.truth_(inst_31888__$1)){
var statearr_32009_32198 = state_31916__$1;
(statearr_32009_32198[(1)] = (123));

} else {
var statearr_32010_32199 = state_31916__$1;
(statearr_32010_32199[(1)] = (124));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (43))){
var inst_31640 = (state_31916[(47)]);
var state_31916__$1 = state_31916;
var statearr_32011_32200 = state_31916__$1;
(statearr_32011_32200[(2)] = inst_31640);

(statearr_32011_32200[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (61))){
var inst_31552 = (state_31916[(75)]);
var state_31916__$1 = state_31916;
var statearr_32012_32201 = state_31916__$1;
(statearr_32012_32201[(2)] = inst_31552);

(statearr_32012_32201[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (29))){
var state_31916__$1 = state_31916;
var statearr_32013_32202 = state_31916__$1;
(statearr_32013_32202[(2)] = null);

(statearr_32013_32202[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (44))){
var state_31916__$1 = state_31916;
var statearr_32014_32203 = state_31916__$1;
(statearr_32014_32203[(2)] = false);

(statearr_32014_32203[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (93))){
var inst_31764 = (state_31916[(63)]);
var state_31916__$1 = state_31916;
var statearr_32015_32204 = state_31916__$1;
(statearr_32015_32204[(2)] = inst_31764);

(statearr_32015_32204[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (6))){
var inst_31553 = (state_31916[(78)]);
var inst_31558 = inst_31553.cljs$lang$protocol_mask$partition0$;
var inst_31559 = (inst_31558 & (64));
var inst_31560 = inst_31553.cljs$core$ISeq$;
var inst_31561 = (cljs.core.PROTOCOL_SENTINEL === inst_31560);
var inst_31562 = ((inst_31559) || (inst_31561));
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31562)){
var statearr_32016_32205 = state_31916__$1;
(statearr_32016_32205[(1)] = (9));

} else {
var statearr_32017_32206 = state_31916__$1;
(statearr_32017_32206[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (111))){
var inst_31710 = (state_31916[(21)]);
var inst_31810 = (state_31916[(9)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31743 = (state_31916[(14)]);
var inst_31859 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_31810,inst_31742,inst_31743,inst_31710,inst_31716);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(119),inst_31859);
} else {
if((state_val_31917 === (28))){
var inst_31607 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_32018_32207 = state_31916__$1;
(statearr_32018_32207[(2)] = inst_31607);

(statearr_32018_32207[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (64))){
var state_31916__$1 = state_31916;
var statearr_32019_32208 = state_31916__$1;
(statearr_32019_32208[(2)] = (2147483647));

(statearr_32019_32208[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (103))){
var inst_31783 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_32020_32209 = state_31916__$1;
(statearr_32020_32209[(2)] = inst_31783);

(statearr_32020_32209[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (51))){
var inst_31663 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31663)){
var statearr_32021_32210 = state_31916__$1;
(statearr_32021_32210[(1)] = (52));

} else {
var statearr_32022_32211 = state_31916__$1;
(statearr_32022_32211[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (25))){
var inst_31609 = (state_31916[(77)]);
var inst_31609__$1 = (state_31916[(2)]);
var inst_31610 = (inst_31609__$1 == null);
var state_31916__$1 = (function (){var statearr_32023 = state_31916;
(statearr_32023[(77)] = inst_31609__$1);

return statearr_32023;
})();
if(cljs.core.truth_(inst_31610)){
var statearr_32024_32212 = state_31916__$1;
(statearr_32024_32212[(1)] = (32));

} else {
var statearr_32025_32213 = state_31916__$1;
(statearr_32025_32213[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (34))){
var inst_31628 = (state_31916[(30)]);
var inst_31627 = (state_31916[(43)]);
var inst_31629 = (state_31916[(79)]);
var inst_31627__$1 = (state_31916[(2)]);
var inst_31628__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31627__$1,(0),null);
var inst_31629__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31628__$1,(0),null);
var inst_31630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31628__$1,(1),null);
var inst_31631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31627__$1,(1),null);
var inst_31632 = fluree.db.util.core.pred_ident_QMARK_(inst_31629__$1);
var state_31916__$1 = (function (){var statearr_32026 = state_31916;
(statearr_32026[(20)] = inst_31631);

(statearr_32026[(30)] = inst_31628__$1);

(statearr_32026[(43)] = inst_31627__$1);

(statearr_32026[(57)] = inst_31630);

(statearr_32026[(79)] = inst_31629__$1);

return statearr_32026;
})();
if(inst_31632){
var statearr_32027_32214 = state_31916__$1;
(statearr_32027_32214[(1)] = (35));

} else {
var statearr_32028_32215 = state_31916__$1;
(statearr_32028_32215[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (125))){
var inst_31888 = (state_31916[(16)]);
var inst_31896 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_32029 = state_31916;
(statearr_32029[(81)] = inst_31896);

return statearr_32029;
})();
if(cljs.core.truth_(inst_31888)){
var statearr_32030_32216 = state_31916__$1;
(statearr_32030_32216[(1)] = (127));

} else {
var statearr_32031_32217 = state_31916__$1;
(statearr_32031_32217[(1)] = (128));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (17))){
var inst_31547 = (state_31916[(54)]);
var inst_31586 = (state_31916[(2)]);
var inst_31587 = fluree.db.util.core.pred_ident_QMARK_(inst_31547);
var state_31916__$1 = (function (){var statearr_32032 = state_31916;
(statearr_32032[(26)] = inst_31586);

return statearr_32032;
})();
if(inst_31587){
var statearr_32033_32218 = state_31916__$1;
(statearr_32033_32218[(1)] = (19));

} else {
var statearr_32034_32219 = state_31916__$1;
(statearr_32034_32219[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (3))){
var inst_31914 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31916__$1,inst_31914);
} else {
if((state_val_31917 === (12))){
var inst_31553 = (state_31916[(78)]);
var inst_31571 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31553);
var state_31916__$1 = state_31916;
var statearr_32035_32220 = state_31916__$1;
(statearr_32035_32220[(2)] = inst_31571);

(statearr_32035_32220[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (2))){
var inst_31553 = (state_31916[(78)]);
var inst_31546 = (state_31916[(31)]);
var inst_31539 = (state_31916[(49)]);
var _ = (function (){var statearr_32036 = state_31916;
(statearr_32036[(4)] = cljs.core.cons((5),(state_31916[(4)])));

return statearr_32036;
})();
var inst_31539__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_31540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(0),null);
var inst_31541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(1),null);
var inst_31542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(2),null);
var inst_31543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(3),null);
var inst_31544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(4),null);
var inst_31545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,(5),null);
var inst_31546__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_31547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(0),null);
var inst_31548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(1),null);
var inst_31549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(2),null);
var inst_31550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(3),null);
var inst_31551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(4),null);
var inst_31552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31546__$1,(5),null);
var inst_31553__$1 = opts;
var inst_31555 = (inst_31553__$1 == null);
var inst_31556 = cljs.core.not(inst_31555);
var state_31916__$1 = (function (){var statearr_32037 = state_31916;
(statearr_32037[(17)] = inst_31551);

(statearr_32037[(75)] = inst_31552);

(statearr_32037[(65)] = inst_31540);

(statearr_32037[(78)] = inst_31553__$1);

(statearr_32037[(56)] = inst_31545);

(statearr_32037[(55)] = inst_31549);

(statearr_32037[(28)] = inst_31543);

(statearr_32037[(31)] = inst_31546__$1);

(statearr_32037[(54)] = inst_31547);

(statearr_32037[(76)] = inst_31541);

(statearr_32037[(66)] = inst_31548);

(statearr_32037[(39)] = inst_31550);

(statearr_32037[(49)] = inst_31539__$1);

(statearr_32037[(72)] = inst_31542);

(statearr_32037[(50)] = inst_31544);

return statearr_32037;
})();
if(inst_31556){
var statearr_32038_32221 = state_31916__$1;
(statearr_32038_32221[(1)] = (6));

} else {
var statearr_32039_32222 = state_31916__$1;
(statearr_32039_32222[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (66))){
var inst_31683 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_32040_32223 = state_31916__$1;
(statearr_32040_32223[(2)] = inst_31683);

(statearr_32040_32223[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (107))){
var inst_31741 = (state_31916[(33)]);
var inst_31742 = (state_31916[(37)]);
var inst_31744 = (state_31916[(42)]);
var inst_31799 = (state_31916[(82)]);
var inst_31743 = (state_31916[(14)]);
var inst_31802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31803 = (inst_31741 - inst_31799);
var inst_31804 = [inst_31803,inst_31742,inst_31743,inst_31744];
var inst_31805 = (new cljs.core.PersistentVector(null,4,(5),inst_31802,inst_31804,null));
var state_31916__$1 = state_31916;
var statearr_32041_32224 = state_31916__$1;
(statearr_32041_32224[(2)] = inst_31805);

(statearr_32041_32224[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (23))){
var inst_31542 = (state_31916[(72)]);
var state_31916__$1 = state_31916;
var statearr_32042_32225 = state_31916__$1;
(statearr_32042_32225[(2)] = inst_31542);

(statearr_32042_32225[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (47))){
var inst_31541 = (state_31916[(76)]);
var state_31916__$1 = state_31916;
var statearr_32043_32226 = state_31916__$1;
(statearr_32043_32226[(2)] = inst_31541);

(statearr_32043_32226[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (35))){
var inst_31629 = (state_31916[(79)]);
var inst_31634 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31629);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(38),inst_31634);
} else {
if((state_val_31917 === (127))){
var inst_31896 = (state_31916[(81)]);
var state_31916__$1 = state_31916;
var statearr_32044_32227 = state_31916__$1;
(statearr_32044_32227[(2)] = inst_31896);

(statearr_32044_32227[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (82))){
var state_31916__$1 = state_31916;
var statearr_32045_32228 = state_31916__$1;
(statearr_32045_32228[(2)] = null);

(statearr_32045_32228[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (76))){
var inst_31711 = (state_31916[(70)]);
var state_31916__$1 = state_31916;
var statearr_32046_32229 = state_31916__$1;
(statearr_32046_32229[(2)] = inst_31711);

(statearr_32046_32229[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (97))){
var inst_31717 = (state_31916[(38)]);
var inst_31740 = (state_31916[(53)]);
var inst_31776 = (state_31916[(2)]);
var inst_31777 = fluree.db.dbproto._rhs(inst_31740);
var state_31916__$1 = (function (){var statearr_32047 = state_31916;
(statearr_32047[(7)] = inst_31777);

(statearr_32047[(64)] = inst_31776);

return statearr_32047;
})();
if(cljs.core.truth_(inst_31717)){
var statearr_32048_32230 = state_31916__$1;
(statearr_32048_32230[(1)] = (98));

} else {
var statearr_32049_32231 = state_31916__$1;
(statearr_32049_32231[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (19))){
var inst_31547 = (state_31916[(54)]);
var inst_31589 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31547);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(22),inst_31589);
} else {
if((state_val_31917 === (57))){
var inst_31552 = (state_31916[(75)]);
var inst_31676 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_32050 = state_31916;
(statearr_32050[(40)] = inst_31676);

return statearr_32050;
})();
if(cljs.core.truth_(inst_31552)){
var statearr_32051_32232 = state_31916__$1;
(statearr_32051_32232[(1)] = (61));

} else {
var statearr_32052_32233 = state_31916__$1;
(statearr_32052_32233[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (68))){
var state_31916__$1 = state_31916;
var statearr_32053_32234 = state_31916__$1;
(statearr_32053_32234[(2)] = false);

(statearr_32053_32234[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (11))){
var inst_31566 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_32054_32235 = state_31916__$1;
(statearr_32054_32235[(2)] = inst_31566);

(statearr_32054_32235[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (115))){
var inst_31710 = (state_31916[(21)]);
var inst_31810 = (state_31916[(9)]);
var inst_31838 = (state_31916[(67)]);
var inst_31742 = (state_31916[(37)]);
var inst_31836 = (state_31916[(68)]);
var inst_31837 = (state_31916[(69)]);
var inst_31832 = (state_31916[(2)]);
var inst_31833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31832,(0),null);
var inst_31834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31832,(1),null);
var inst_31835 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_31834,inst_31810);
var inst_31836__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31835);
var inst_31837__$1 = cljs.core.count(inst_31836__$1);
var inst_31838__$1 = (inst_31742 + inst_31837__$1);
var inst_31839 = (inst_31838__$1 > inst_31710);
var state_31916__$1 = (function (){var statearr_32056 = state_31916;
(statearr_32056[(67)] = inst_31838__$1);

(statearr_32056[(80)] = inst_31833);

(statearr_32056[(68)] = inst_31836__$1);

(statearr_32056[(69)] = inst_31837__$1);

return statearr_32056;
})();
if(cljs.core.truth_(inst_31839)){
var statearr_32057_32236 = state_31916__$1;
(statearr_32057_32236[(1)] = (116));

} else {
var statearr_32058_32237 = state_31916__$1;
(statearr_32058_32237[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (9))){
var state_31916__$1 = state_31916;
var statearr_32059_32238 = state_31916__$1;
(statearr_32059_32238[(2)] = true);

(statearr_32059_32238[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (5))){
var _ = (function (){var statearr_32060 = state_31916;
(statearr_32060[(4)] = cljs.core.rest((state_31916[(4)])));

return statearr_32060;
})();
var state_31916__$1 = state_31916;
var ex32055 = (state_31916__$1[(2)]);
var statearr_32061_32239 = state_31916__$1;
(statearr_32061_32239[(5)] = ex32055);


if((ex32055 instanceof Error)){
var statearr_32062_32240 = state_31916__$1;
(statearr_32062_32240[(1)] = (4));

(statearr_32062_32240[(5)] = null);

} else {
throw ex32055;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (112))){
var inst_31744 = (state_31916[(42)]);
var inst_31864 = (state_31916[(2)]);
var inst_31865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31864,(0),null);
var inst_31866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31864,(1),null);
var inst_31867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31864,(2),null);
var inst_31868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31869 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31744,inst_31867);
var inst_31870 = [(0),inst_31865,inst_31866,inst_31869];
var inst_31871 = (new cljs.core.PersistentVector(null,4,(5),inst_31868,inst_31870,null));
var state_31916__$1 = state_31916;
var statearr_32063_32241 = state_31916__$1;
(statearr_32063_32241[(2)] = inst_31871);

(statearr_32063_32241[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (83))){
var inst_31911 = (state_31916[(2)]);
var _ = (function (){var statearr_32064 = state_31916;
(statearr_32064[(4)] = cljs.core.rest((state_31916[(4)])));

return statearr_32064;
})();
var state_31916__$1 = state_31916;
var statearr_32065_32242 = state_31916__$1;
(statearr_32065_32242[(2)] = inst_31911);

(statearr_32065_32242[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (14))){
var inst_31540 = (state_31916[(65)]);
var inst_31574 = (state_31916[(52)]);
var inst_31574__$1 = (state_31916[(2)]);
var inst_31575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_31576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_31577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31574__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_31578 = fluree.db.util.core.pred_ident_QMARK_(inst_31540);
var state_31916__$1 = (function (){var statearr_32066 = state_31916;
(statearr_32066[(18)] = inst_31576);

(statearr_32066[(73)] = inst_31577);

(statearr_32066[(29)] = inst_31575);

(statearr_32066[(52)] = inst_31574__$1);

return statearr_32066;
})();
if(inst_31578){
var statearr_32067_32243 = state_31916__$1;
(statearr_32067_32243[(1)] = (15));

} else {
var statearr_32068_32244 = state_31916__$1;
(statearr_32068_32244[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (45))){
var inst_31654 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31654)){
var statearr_32069_32245 = state_31916__$1;
(statearr_32069_32245[(1)] = (46));

} else {
var statearr_32070_32246 = state_31916__$1;
(statearr_32070_32246[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (53))){
var inst_31548 = (state_31916[(66)]);
var state_31916__$1 = state_31916;
var statearr_32071_32247 = state_31916__$1;
(statearr_32071_32247[(2)] = inst_31548);

(statearr_32071_32247[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (78))){
var inst_31716 = (state_31916[(12)]);
var inst_31716__$1 = (state_31916[(2)]);
var inst_31717 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31716__$1,fluree.db.util.core.max_long);
var inst_31718 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_31719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31720 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_31721 = (new cljs.core.PersistentVector(null,3,(5),inst_31719,inst_31720,null));
var inst_31722 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31721);
var inst_31723 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_31724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31725 = [cljs.core.cst$kw$novelty,idx];
var inst_31726 = (new cljs.core.PersistentVector(null,2,(5),inst_31724,inst_31725,null));
var inst_31727 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31726);
var inst_31728 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_31729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31730 = fluree.db.dbproto._resolve(inst_31729);
var state_31916__$1 = (function (){var statearr_32072 = state_31916;
(statearr_32072[(22)] = inst_31722);

(statearr_32072[(27)] = inst_31723);

(statearr_32072[(12)] = inst_31716__$1);

(statearr_32072[(38)] = inst_31717);

(statearr_32072[(44)] = inst_31727);

(statearr_32072[(45)] = inst_31718);

(statearr_32072[(48)] = inst_31728);

return statearr_32072;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(79),inst_31730);
} else {
if((state_val_31917 === (132))){
var inst_31906 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_32073_32248 = state_31916__$1;
(statearr_32073_32248[(2)] = inst_31906);

(statearr_32073_32248[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (26))){
var inst_31549 = (state_31916[(55)]);
var state_31916__$1 = state_31916;
var statearr_32074_32249 = state_31916__$1;
(statearr_32074_32249[(2)] = inst_31549);

(statearr_32074_32249[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (123))){
var inst_31733 = (state_31916[(19)]);
var inst_31723 = (state_31916[(27)]);
var inst_31777 = (state_31916[(7)]);
var inst_31727 = (state_31916[(44)]);
var inst_31728 = (state_31916[(48)]);
var inst_31890 = fluree.db.query.range.find_next_valid_node(inst_31733,inst_31777,inst_31723,inst_31727,inst_31728);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(126),inst_31890);
} else {
if((state_val_31917 === (16))){
var inst_31540 = (state_31916[(65)]);
var state_31916__$1 = state_31916;
var statearr_32075_32250 = state_31916__$1;
(statearr_32075_32250[(2)] = inst_31540);

(statearr_32075_32250[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (81))){
var inst_31737 = (state_31916[(23)]);
var inst_31712 = (state_31916[(71)]);
var inst_31739 = cljs.core.PersistentVector.EMPTY;
var inst_31740 = inst_31737;
var inst_31741 = inst_31712;
var inst_31742 = (0);
var inst_31743 = (0);
var inst_31744 = inst_31739;
var state_31916__$1 = (function (){var statearr_32076 = state_31916;
(statearr_32076[(33)] = inst_31741);

(statearr_32076[(37)] = inst_31742);

(statearr_32076[(42)] = inst_31744);

(statearr_32076[(14)] = inst_31743);

(statearr_32076[(53)] = inst_31740);

return statearr_32076;
})();
var statearr_32077_32251 = state_31916__$1;
(statearr_32077_32251[(2)] = null);

(statearr_32077_32251[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (120))){
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31878 = (state_31916[(59)]);
var inst_31687 = (state_31916[(35)]);
var inst_31716 = (state_31916[(12)]);
var inst_31777 = (state_31916[(7)]);
var inst_31877 = (state_31916[(60)]);
var inst_31881 = (inst_31722.cljs$core$IFn$_invoke$arity$2 ? inst_31722.cljs$core$IFn$_invoke$arity$2(inst_31777,inst_31687) : inst_31722.call(null,inst_31777,inst_31687));
var inst_31882 = (inst_31881 < (0));
var inst_31883 = (inst_31877 < inst_31710);
var inst_31884 = (inst_31878 < inst_31716);
var inst_31885 = ((inst_31882) && (inst_31883) && (inst_31884));
var state_31916__$1 = state_31916;
var statearr_32078_32252 = state_31916__$1;
(statearr_32078_32252[(2)] = inst_31885);

(statearr_32078_32252[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (79))){
var inst_31733 = (state_31916[(19)]);
var inst_31723 = (state_31916[(27)]);
var inst_31727 = (state_31916[(44)]);
var inst_31728 = (state_31916[(48)]);
var inst_31686 = (state_31916[(51)]);
var inst_31732 = (state_31916[(2)]);
var inst_31733__$1 = fluree.db.util.async.throw_err(inst_31732);
var inst_31734 = fluree.db.query.range.find_next_valid_node(inst_31733__$1,inst_31686,inst_31723,inst_31727,inst_31728);
var state_31916__$1 = (function (){var statearr_32079 = state_31916;
(statearr_32079[(19)] = inst_31733__$1);

return statearr_32079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(80),inst_31734);
} else {
if((state_val_31917 === (38))){
var inst_31636 = (state_31916[(2)]);
var inst_31637 = fluree.db.util.async.throw_err(inst_31636);
var state_31916__$1 = state_31916;
var statearr_32080_32253 = state_31916__$1;
(statearr_32080_32253[(2)] = inst_31637);

(statearr_32080_32253[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (126))){
var inst_31892 = (state_31916[(2)]);
var inst_31893 = fluree.db.util.async.throw_err(inst_31892);
var state_31916__$1 = state_31916;
var statearr_32081_32254 = state_31916__$1;
(statearr_32081_32254[(2)] = inst_31893);

(statearr_32081_32254[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (98))){
var inst_31741 = (state_31916[(33)]);
var inst_31779 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_31741);
var state_31916__$1 = state_31916;
if(inst_31779){
var statearr_32082_32255 = state_31916__$1;
(statearr_32082_32255[(1)] = (101));

} else {
var statearr_32083_32256 = state_31916__$1;
(statearr_32083_32256[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (124))){
var state_31916__$1 = state_31916;
var statearr_32084_32257 = state_31916__$1;
(statearr_32084_32257[(2)] = null);

(statearr_32084_32257[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (87))){
var inst_31750 = (state_31916[(46)]);
var state_31916__$1 = state_31916;
var statearr_32085_32258 = state_31916__$1;
(statearr_32085_32258[(2)] = inst_31750);

(statearr_32085_32258[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (30))){
var state_31916__$1 = state_31916;
var statearr_32086_32259 = state_31916__$1;
(statearr_32086_32259[(2)] = null);

(statearr_32086_32259[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (73))){
var inst_31688 = (state_31916[(8)]);
var inst_31706 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31688);
var state_31916__$1 = state_31916;
var statearr_32087_32260 = state_31916__$1;
(statearr_32087_32260[(2)] = inst_31706);

(statearr_32087_32260[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (96))){
var inst_31770 = (state_31916[(62)]);
var state_31916__$1 = state_31916;
var statearr_32088_32261 = state_31916__$1;
(statearr_32088_32261[(2)] = inst_31770);

(statearr_32088_32261[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (10))){
var state_31916__$1 = state_31916;
var statearr_32089_32262 = state_31916__$1;
(statearr_32089_32262[(2)] = false);

(statearr_32089_32262[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (18))){
var inst_31582 = (state_31916[(2)]);
var inst_31583 = fluree.db.util.async.throw_err(inst_31582);
var state_31916__$1 = state_31916;
var statearr_32090_32263 = state_31916__$1;
(statearr_32090_32263[(2)] = inst_31583);

(statearr_32090_32263[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (105))){
var inst_31551 = (state_31916[(17)]);
var inst_31576 = (state_31916[(18)]);
var inst_31733 = (state_31916[(19)]);
var inst_31631 = (state_31916[(20)]);
var inst_31710 = (state_31916[(21)]);
var inst_31722 = (state_31916[(22)]);
var inst_31737 = (state_31916[(23)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31723 = (state_31916[(27)]);
var inst_31543 = (state_31916[(28)]);
var inst_31575 = (state_31916[(29)]);
var inst_31628 = (state_31916[(30)]);
var inst_31546 = (state_31916[(31)]);
var inst_31658 = (state_31916[(32)]);
var inst_31741 = (state_31916[(33)]);
var inst_31595 = (state_31916[(34)]);
var inst_31687 = (state_31916[(35)]);
var inst_31709 = (state_31916[(36)]);
var inst_31716 = (state_31916[(12)]);
var inst_31742 = (state_31916[(37)]);
var inst_31777 = (state_31916[(7)]);
var inst_31717 = (state_31916[(38)]);
var inst_31550 = (state_31916[(39)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31744 = (state_31916[(42)]);
var inst_31798 = (state_31916[(74)]);
var inst_31627 = (state_31916[(43)]);
var inst_31727 = (state_31916[(44)]);
var inst_31718 = (state_31916[(45)]);
var inst_31750 = (state_31916[(46)]);
var inst_31640 = (state_31916[(47)]);
var inst_31776 = (state_31916[(64)]);
var inst_31799 = (state_31916[(82)]);
var inst_31728 = (state_31916[(48)]);
var inst_31539 = (state_31916[(49)]);
var inst_31743 = (state_31916[(14)]);
var inst_31544 = (state_31916[(50)]);
var inst_31686 = (state_31916[(51)]);
var inst_31574 = (state_31916[(52)]);
var inst_31740 = (state_31916[(53)]);
var inst_31797 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_31776;
var t = inst_31723;
var max_limit_QMARK_ = inst_31717;
var next_node = inst_31740;
var fast_forward_db_QMARK_ = inst_31728;
var s1 = inst_31586;
var o2 = inst_31649;
var t1 = inst_31543;
var map__31538 = inst_31709;
var predicate_fn = inst_31576;
var i = inst_31742;
var rhs = inst_31777;
var m1 = inst_31676;
var root_node = inst_31733;
var s2 = inst_31595;
var vec__31532 = inst_31627;
var p2 = inst_31667;
var permissions = inst_31718;
var limit = inst_31716;
var start_flake = inst_31686;
var map__31531 = inst_31574;
var flake_limit = inst_31710;
var offset = inst_31741;
var acc = inst_31744;
var vec__31528 = inst_31546;
var vec__31535 = inst_31628;
var t2 = inst_31550;
var op1 = inst_31544;
var o1 = inst_31640;
var end_flake = inst_31687;
var base_result = inst_31750;
var s = inst_31743;
var node_start = inst_31737;
var p1 = inst_31658;
var subject_fn = inst_31575;
var object_fn = inst_31631;
var vec__31525 = inst_31539;
var idx_compare = inst_31722;
var op2 = inst_31551;
var m2 = inst_31685;
var novelty = inst_31727;
return (function (p1__31510_SHARP_){
return p1__31510_SHARP_.s;
});
})();
var inst_31798__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_31797,inst_31776);
var inst_31799__$1 = cljs.core.count(inst_31798__$1);
var inst_31800 = (inst_31741 > inst_31799__$1);
var state_31916__$1 = (function (){var statearr_32091 = state_31916;
(statearr_32091[(74)] = inst_31798__$1);

(statearr_32091[(82)] = inst_31799__$1);

return statearr_32091;
})();
if(cljs.core.truth_(inst_31800)){
var statearr_32092_32264 = state_31916__$1;
(statearr_32092_32264[(1)] = (107));

} else {
var statearr_32093_32265 = state_31916__$1;
(statearr_32093_32265[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (52))){
var state_31916__$1 = state_31916;
var statearr_32094_32266 = state_31916__$1;
(statearr_32094_32266[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_32094_32266[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (114))){
var inst_31819 = (state_31916[(13)]);
var inst_31828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31829 = [inst_31819,inst_31819];
var inst_31830 = (new cljs.core.PersistentVector(null,2,(5),inst_31828,inst_31829,null));
var state_31916__$1 = state_31916;
var statearr_32095_32267 = state_31916__$1;
(statearr_32095_32267[(2)] = inst_31830);

(statearr_32095_32267[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (67))){
var inst_31688 = (state_31916[(8)]);
var inst_31693 = inst_31688.cljs$lang$protocol_mask$partition0$;
var inst_31694 = (inst_31693 & (64));
var inst_31695 = inst_31688.cljs$core$ISeq$;
var inst_31696 = (cljs.core.PROTOCOL_SENTINEL === inst_31695);
var inst_31697 = ((inst_31694) || (inst_31696));
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31697)){
var statearr_32096_32268 = state_31916__$1;
(statearr_32096_32268[(1)] = (70));

} else {
var statearr_32097_32269 = state_31916__$1;
(statearr_32097_32269[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (71))){
var state_31916__$1 = state_31916;
var statearr_32098_32270 = state_31916__$1;
(statearr_32098_32270[(2)] = false);

(statearr_32098_32270[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (42))){
var inst_31645 = (state_31916[(2)]);
var inst_31646 = fluree.db.util.async.throw_err(inst_31645);
var state_31916__$1 = state_31916;
var statearr_32099_32271 = state_31916__$1;
(statearr_32099_32271[(2)] = inst_31646);

(statearr_32099_32271[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (80))){
var inst_31737 = (state_31916[(23)]);
var inst_31736 = (state_31916[(2)]);
var inst_31737__$1 = fluree.db.util.async.throw_err(inst_31736);
var state_31916__$1 = (function (){var statearr_32100 = state_31916;
(statearr_32100[(23)] = inst_31737__$1);

return statearr_32100;
})();
if(cljs.core.truth_(inst_31737__$1)){
var statearr_32101_32272 = state_31916__$1;
(statearr_32101_32272[(1)] = (81));

} else {
var statearr_32102_32273 = state_31916__$1;
(statearr_32102_32273[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (37))){
var inst_31630 = (state_31916[(57)]);
var inst_31640 = (state_31916[(2)]);
var inst_31641 = fluree.db.util.core.pred_ident_QMARK_(inst_31630);
var state_31916__$1 = (function (){var statearr_32103 = state_31916;
(statearr_32103[(47)] = inst_31640);

return statearr_32103;
})();
if(inst_31641){
var statearr_32104_32274 = state_31916__$1;
(statearr_32104_32274[(1)] = (39));

} else {
var statearr_32105_32275 = state_31916__$1;
(statearr_32105_32275[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (63))){
var inst_31551 = (state_31916[(17)]);
var inst_31667 = (state_31916[(24)]);
var inst_31649 = (state_31916[(25)]);
var inst_31586 = (state_31916[(26)]);
var inst_31543 = (state_31916[(28)]);
var inst_31658 = (state_31916[(32)]);
var inst_31595 = (state_31916[(34)]);
var inst_31550 = (state_31916[(39)]);
var inst_31688 = (state_31916[(8)]);
var inst_31676 = (state_31916[(40)]);
var inst_31685 = (state_31916[(41)]);
var inst_31640 = (state_31916[(47)]);
var inst_31544 = (state_31916[(50)]);
var inst_31685__$1 = (state_31916[(2)]);
var inst_31686 = fluree.db.flake.__GT_Flake(inst_31586,inst_31658,inst_31640,inst_31543,inst_31544,inst_31676);
var inst_31687 = fluree.db.flake.__GT_Flake(inst_31595,inst_31667,inst_31649,inst_31550,inst_31551,inst_31685__$1);
var inst_31688__$1 = opts;
var inst_31690 = (inst_31688__$1 == null);
var inst_31691 = cljs.core.not(inst_31690);
var state_31916__$1 = (function (){var statearr_32106 = state_31916;
(statearr_32106[(35)] = inst_31687);

(statearr_32106[(8)] = inst_31688__$1);

(statearr_32106[(41)] = inst_31685__$1);

(statearr_32106[(51)] = inst_31686);

return statearr_32106;
})();
if(inst_31691){
var statearr_32107_32276 = state_31916__$1;
(statearr_32107_32276[(1)] = (67));

} else {
var statearr_32108_32277 = state_31916__$1;
(statearr_32108_32277[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (94))){
var inst_31631 = (state_31916[(20)]);
var inst_31770 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_32109 = state_31916;
(statearr_32109[(62)] = inst_31770);

return statearr_32109;
})();
if(cljs.core.truth_(inst_31631)){
var statearr_32110_32278 = state_31916__$1;
(statearr_32110_32278[(1)] = (95));

} else {
var statearr_32111_32279 = state_31916__$1;
(statearr_32111_32279[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (8))){
var inst_31569 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
if(cljs.core.truth_(inst_31569)){
var statearr_32112_32280 = state_31916__$1;
(statearr_32112_32280[(1)] = (12));

} else {
var statearr_32113_32281 = state_31916__$1;
(statearr_32113_32281[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (49))){
var inst_31649 = (state_31916[(25)]);
var state_31916__$1 = state_31916;
var statearr_32114_32282 = state_31916__$1;
(statearr_32114_32282[(2)] = inst_31649);

(statearr_32114_32282[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (84))){
var inst_31687 = (state_31916[(35)]);
var inst_31686 = (state_31916[(51)]);
var inst_31740 = (state_31916[(53)]);
var inst_31749 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_31740);
var inst_31750 = fluree.db.flake.subrange(inst_31749,start_test,inst_31686,end_test,inst_31687);
var inst_31752 = fluree.db.query.range.value_with_nil_pred(idx,inst_31686,inst_31687);
var state_31916__$1 = (function (){var statearr_32115 = state_31916;
(statearr_32115[(46)] = inst_31750);

return statearr_32115;
})();
if(inst_31752){
var statearr_32116_32283 = state_31916__$1;
(statearr_32116_32283[(1)] = (86));

} else {
var statearr_32117_32284 = state_31916__$1;
(statearr_32117_32284[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32118[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32118[(1)] = (1));

return statearr_32118;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31916){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31916);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32119){var ex__16304__auto__ = e32119;
var statearr_32120_32285 = state_31916;
(statearr_32120_32285[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31916[(4)]))){
var statearr_32121_32286 = state_31916;
(statearr_32121_32286[(1)] = cljs.core.first((state_31916[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32287 = state_31916;
state_31916 = G__32287;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31916){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32122 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32122[(6)] = c__16375__auto__);

return statearr_32122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32343){
var state_val_32344 = (state_32343[(1)]);
if((state_val_32344 === (7))){
var inst_32317 = (state_32343[(7)]);
var inst_32307 = (state_32343[(8)]);
var inst_32315 = fluree.db.flake.Flake__GT_parts(inst_32307);
var inst_32316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(0),null);
var inst_32317__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(1),null);
var inst_32318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(2),null);
var inst_32319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(3),null);
var inst_32320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(4),null);
var inst_32321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32315,(5),null);
var inst_32322 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_32318,inst_32317__$1);
var state_32343__$1 = (function (){var statearr_32345 = state_32343;
(statearr_32345[(7)] = inst_32317__$1);

(statearr_32345[(9)] = inst_32320);

(statearr_32345[(10)] = inst_32319);

(statearr_32345[(11)] = inst_32316);

(statearr_32345[(12)] = inst_32321);

return statearr_32345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32343__$1,(10),inst_32322);
} else {
if((state_val_32344 === (1))){
var inst_32295 = flakes;
var inst_32296 = cljs.core.seq(inst_32295);
var inst_32297 = cljs.core.first(inst_32296);
var inst_32298 = cljs.core.next(inst_32296);
var inst_32299 = cljs.core.PersistentVector.EMPTY;
var inst_32300 = inst_32295;
var inst_32301 = inst_32299;
var state_32343__$1 = (function (){var statearr_32346 = state_32343;
(statearr_32346[(13)] = inst_32297);

(statearr_32346[(14)] = inst_32298);

(statearr_32346[(15)] = inst_32300);

(statearr_32346[(16)] = inst_32301);

return statearr_32346;
})();
var statearr_32347_32365 = state_32343__$1;
(statearr_32347_32365[(2)] = null);

(statearr_32347_32365[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (4))){
var inst_32307 = (state_32343[(8)]);
var inst_32310 = fluree.db.query.range.is_tag_flake_QMARK_(inst_32307);
var state_32343__$1 = state_32343;
if(inst_32310){
var statearr_32348_32366 = state_32343__$1;
(statearr_32348_32366[(1)] = (7));

} else {
var statearr_32349_32367 = state_32343__$1;
(statearr_32349_32367[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (6))){
var inst_32339 = (state_32343[(2)]);
var state_32343__$1 = state_32343;
var statearr_32350_32368 = state_32343__$1;
(statearr_32350_32368[(2)] = inst_32339);

(statearr_32350_32368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (3))){
var inst_32341 = (state_32343[(2)]);
var state_32343__$1 = state_32343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32343__$1,inst_32341);
} else {
if((state_val_32344 === (2))){
var inst_32300 = (state_32343[(15)]);
var inst_32307 = (state_32343[(8)]);
var inst_32306 = cljs.core.seq(inst_32300);
var inst_32307__$1 = cljs.core.first(inst_32306);
var inst_32308 = cljs.core.next(inst_32306);
var state_32343__$1 = (function (){var statearr_32351 = state_32343;
(statearr_32351[(17)] = inst_32308);

(statearr_32351[(8)] = inst_32307__$1);

return statearr_32351;
})();
if(cljs.core.truth_(inst_32307__$1)){
var statearr_32352_32369 = state_32343__$1;
(statearr_32352_32369[(1)] = (4));

} else {
var statearr_32353_32370 = state_32343__$1;
(statearr_32353_32370[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (9))){
var inst_32336 = (state_32343[(2)]);
var state_32343__$1 = state_32343;
var statearr_32354_32371 = state_32343__$1;
(statearr_32354_32371[(2)] = inst_32336);

(statearr_32354_32371[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (5))){
var inst_32301 = (state_32343[(16)]);
var state_32343__$1 = state_32343;
var statearr_32355_32372 = state_32343__$1;
(statearr_32355_32372[(2)] = inst_32301);

(statearr_32355_32372[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (10))){
var inst_32317 = (state_32343[(7)]);
var inst_32320 = (state_32343[(9)]);
var inst_32319 = (state_32343[(10)]);
var inst_32308 = (state_32343[(17)]);
var inst_32316 = (state_32343[(11)]);
var inst_32301 = (state_32343[(16)]);
var inst_32321 = (state_32343[(12)]);
var inst_32324 = (state_32343[(2)]);
var inst_32325 = fluree.db.util.async.throw_err(inst_32324);
var inst_32326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32327 = [inst_32316,inst_32317,inst_32325,inst_32319,inst_32320,inst_32321];
var inst_32328 = (new cljs.core.PersistentVector(null,6,(5),inst_32326,inst_32327,null));
var inst_32329 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_32328);
var inst_32330 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32301,inst_32329);
var inst_32300 = inst_32308;
var inst_32301__$1 = inst_32330;
var state_32343__$1 = (function (){var statearr_32356 = state_32343;
(statearr_32356[(15)] = inst_32300);

(statearr_32356[(16)] = inst_32301__$1);

return statearr_32356;
})();
var statearr_32357_32373 = state_32343__$1;
(statearr_32357_32373[(2)] = null);

(statearr_32357_32373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32344 === (8))){
var inst_32308 = (state_32343[(17)]);
var inst_32307 = (state_32343[(8)]);
var inst_32301 = (state_32343[(16)]);
var inst_32333 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32301,inst_32307);
var inst_32300 = inst_32308;
var inst_32301__$1 = inst_32333;
var state_32343__$1 = (function (){var statearr_32358 = state_32343;
(statearr_32358[(15)] = inst_32300);

(statearr_32358[(16)] = inst_32301__$1);

return statearr_32358;
})();
var statearr_32359_32374 = state_32343__$1;
(statearr_32359_32374[(2)] = null);

(statearr_32359_32374[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0 = (function (){
var statearr_32360 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32360[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__);

(statearr_32360[(1)] = (1));

return statearr_32360;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1 = (function (state_32343){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32343);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32361){var ex__16304__auto__ = e32361;
var statearr_32362_32375 = state_32343;
(statearr_32362_32375[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32343[(4)]))){
var statearr_32363_32376 = state_32343;
(statearr_32363_32376[(1)] = cljs.core.first((state_32343[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32377 = state_32343;
state_32343 = G__32377;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = function(state_32343){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1.call(this,state_32343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32364 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32364[(6)] = c__16375__auto__);

return statearr_32364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__32379 = arguments.length;
switch (G__32379) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32530){
var state_val_32531 = (state_32530[(1)]);
if((state_val_32531 === (62))){
var inst_32517 = (state_32530[(7)]);
var state_32530__$1 = state_32530;
var statearr_32532_32621 = state_32530__$1;
(statearr_32532_32621[(2)] = inst_32517);

(statearr_32532_32621[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (7))){
var state_32530__$1 = state_32530;
var statearr_32533_32622 = state_32530__$1;
(statearr_32533_32622[(2)] = false);

(statearr_32533_32622[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (59))){
var inst_32509 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32534_32623 = state_32530__$1;
(statearr_32534_32623[(2)] = inst_32509);

(statearr_32534_32623[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (20))){
var state_32530__$1 = state_32530;
var statearr_32535_32624 = state_32530__$1;
(statearr_32535_32624[(2)] = null);

(statearr_32535_32624[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (58))){
var state_32530__$1 = state_32530;
var statearr_32536_32625 = state_32530__$1;
(statearr_32536_32625[(2)] = null);

(statearr_32536_32625[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (60))){
var inst_32505 = (state_32530[(2)]);
var inst_32506 = fluree.db.util.async.throw_err(inst_32505);
var state_32530__$1 = state_32530;
var statearr_32537_32626 = state_32530__$1;
(statearr_32537_32626[(2)] = inst_32506);

(statearr_32537_32626[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (27))){
var inst_32430 = (state_32530[(8)]);
var inst_32441 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_32430);
var state_32530__$1 = state_32530;
if(inst_32441){
var statearr_32538_32627 = state_32530__$1;
(statearr_32538_32627[(1)] = (30));

} else {
var statearr_32539_32628 = state_32530__$1;
(statearr_32539_32628[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (1))){
var state_32530__$1 = state_32530;
var statearr_32540_32629 = state_32530__$1;
(statearr_32540_32629[(2)] = null);

(statearr_32540_32629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (24))){
var inst_32391 = (state_32530[(9)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32391)){
var statearr_32541_32630 = state_32530__$1;
(statearr_32541_32630[(1)] = (27));

} else {
var statearr_32542_32631 = state_32530__$1;
(statearr_32542_32631[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (55))){
var inst_32511 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32543_32632 = state_32530__$1;
(statearr_32543_32632[(2)] = inst_32511);

(statearr_32543_32632[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (39))){
var inst_32461 = (state_32530[(2)]);
var inst_32462 = fluree.db.util.async.throw_err(inst_32461);
var state_32530__$1 = state_32530;
var statearr_32544_32633 = state_32530__$1;
(statearr_32544_32633[(2)] = inst_32462);

(statearr_32544_32633[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (46))){
var inst_32474 = (state_32530[(10)]);
var inst_32474__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_32530__$1 = (function (){var statearr_32545 = state_32530;
(statearr_32545[(10)] = inst_32474__$1);

return statearr_32545;
})();
if(cljs.core.truth_(inst_32474__$1)){
var statearr_32546_32634 = state_32530__$1;
(statearr_32546_32634[(1)] = (49));

} else {
var statearr_32547_32635 = state_32530__$1;
(statearr_32547_32635[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (4))){
var inst_32380 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32548_32636 = state_32530__$1;
(statearr_32548_32636[(2)] = inst_32380);

(statearr_32548_32636[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (54))){
var inst_32430 = (state_32530[(8)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32430)){
var statearr_32549_32637 = state_32530__$1;
(statearr_32549_32637[(1)] = (57));

} else {
var statearr_32550_32638 = state_32530__$1;
(statearr_32550_32638[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (15))){
var inst_32392 = (state_32530[(11)]);
var inst_32411 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32392);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(18),inst_32411);
} else {
if((state_val_32531 === (48))){
var inst_32513 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32551_32639 = state_32530__$1;
(statearr_32551_32639[(2)] = inst_32513);

(statearr_32551_32639[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (50))){
var inst_32474 = (state_32530[(10)]);
var inst_32400 = (state_32530[(12)]);
var inst_32394 = (state_32530[(13)]);
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32405 = (state_32530[(16)]);
var inst_32389 = (state_32530[(17)]);
var inst_32478 = (function (){var t = inst_32393;
var temp__5733__auto__ = inst_32474;
var p = inst_32391;
var idx_predicate_QMARK_ = inst_32394;
var o = inst_32430;
var tag_predicate_QMARK_ = inst_32400;
var s = inst_32390;
var o_coerce_QMARK_ = inst_32405;
var vec__32386 = inst_32389;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_32530__$1 = state_32530;
var statearr_32552_32640 = state_32530__$1;
(statearr_32552_32640[(2)] = inst_32478);

(statearr_32552_32640[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (21))){
var inst_32426 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32553_32641 = state_32530__$1;
(statearr_32553_32641[(2)] = inst_32426);

(statearr_32553_32641[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (31))){
var state_32530__$1 = state_32530;
var statearr_32554_32642 = state_32530__$1;
(statearr_32554_32642[(2)] = false);

(statearr_32554_32642[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (32))){
var inst_32451 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32555_32643 = state_32530__$1;
(statearr_32555_32643[(2)] = inst_32451);

(statearr_32555_32643[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (40))){
var inst_32394 = (state_32530[(13)]);
var inst_32465 = cljs.core.not(inst_32394);
var state_32530__$1 = state_32530;
if(inst_32465){
var statearr_32556_32644 = state_32530__$1;
(statearr_32556_32644[(1)] = (43));

} else {
var statearr_32557_32645 = state_32530__$1;
(statearr_32557_32645[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (56))){
var inst_32496 = (state_32530[(2)]);
var inst_32497 = fluree.db.util.async.throw_err(inst_32496);
var state_32530__$1 = state_32530;
var statearr_32558_32646 = state_32530__$1;
(statearr_32558_32646[(2)] = inst_32497);

(statearr_32558_32646[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (33))){
var inst_32430 = (state_32530[(8)]);
var inst_32444 = cljs.core.fn_QMARK_(inst_32430);
var inst_32445 = (!(inst_32444));
var state_32530__$1 = state_32530;
var statearr_32559_32647 = state_32530__$1;
(statearr_32559_32647[(2)] = inst_32445);

(statearr_32559_32647[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (13))){
var inst_32392 = (state_32530[(11)]);
var inst_32409 = fluree.db.query.range.tag_string_QMARK_(inst_32392);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32409)){
var statearr_32560_32648 = state_32530__$1;
(statearr_32560_32648[(1)] = (15));

} else {
var statearr_32561_32649 = state_32530__$1;
(statearr_32561_32649[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (22))){
var inst_32422 = (state_32530[(2)]);
var inst_32423 = fluree.db.util.async.throw_err(inst_32422);
var state_32530__$1 = state_32530;
var statearr_32562_32650 = state_32530__$1;
(statearr_32562_32650[(2)] = inst_32423);

(statearr_32562_32650[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (36))){
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32457 = [inst_32391,inst_32430,inst_32390,inst_32393];
var inst_32458 = (new cljs.core.PersistentVector(null,4,(5),inst_32456,inst_32457,null));
var inst_32459 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_32458,opts);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(39),inst_32459);
} else {
if((state_val_32531 === (41))){
var inst_32391 = (state_32530[(9)]);
var state_32530__$1 = state_32530;
var statearr_32563_32651 = state_32530__$1;
(statearr_32563_32651[(2)] = inst_32391);

(statearr_32563_32651[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (43))){
var inst_32430 = (state_32530[(8)]);
var state_32530__$1 = state_32530;
var statearr_32564_32652 = state_32530__$1;
(statearr_32564_32652[(2)] = inst_32430);

(statearr_32564_32652[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (61))){
var inst_32517 = (state_32530[(7)]);
var inst_32519 = fluree.db.query.range.coerce_tag_flakes(db,inst_32517);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(64),inst_32519);
} else {
if((state_val_32531 === (29))){
var inst_32454 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32454)){
var statearr_32565_32653 = state_32530__$1;
(statearr_32565_32653[(1)] = (36));

} else {
var statearr_32566_32654 = state_32530__$1;
(statearr_32566_32654[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (44))){
var state_32530__$1 = state_32530;
var statearr_32567_32655 = state_32530__$1;
(statearr_32567_32655[(2)] = false);

(statearr_32567_32655[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (6))){
var inst_32391 = (state_32530[(9)]);
var inst_32396 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_32391);
var inst_32397 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_32396);
var state_32530__$1 = state_32530;
var statearr_32568_32656 = state_32530__$1;
(statearr_32568_32656[(2)] = inst_32397);

(statearr_32568_32656[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (28))){
var inst_32391 = (state_32530[(9)]);
var state_32530__$1 = state_32530;
var statearr_32569_32657 = state_32530__$1;
(statearr_32569_32657[(2)] = inst_32391);

(statearr_32569_32657[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (64))){
var inst_32521 = (state_32530[(2)]);
var inst_32522 = fluree.db.util.async.throw_err(inst_32521);
var state_32530__$1 = state_32530;
var statearr_32570_32658 = state_32530__$1;
(statearr_32570_32658[(2)] = inst_32522);

(statearr_32570_32658[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (51))){
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32480 = (state_32530[(2)]);
var inst_32481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32482 = [inst_32391,inst_32390,null,inst_32393];
var inst_32483 = (new cljs.core.PersistentVector(null,4,(5),inst_32481,inst_32482,null));
var inst_32484 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_32480);
var inst_32485 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32483,inst_32484);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(52),inst_32485);
} else {
if((state_val_32531 === (25))){
var inst_32400 = (state_32530[(12)]);
var inst_32517 = (state_32530[(2)]);
var state_32530__$1 = (function (){var statearr_32571 = state_32530;
(statearr_32571[(7)] = inst_32517);

return statearr_32571;
})();
if(cljs.core.truth_(inst_32400)){
var statearr_32572_32659 = state_32530__$1;
(statearr_32572_32659[(1)] = (61));

} else {
var statearr_32573_32660 = state_32530__$1;
(statearr_32573_32660[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (34))){
var inst_32394 = (state_32530[(13)]);
var state_32530__$1 = state_32530;
var statearr_32574_32661 = state_32530__$1;
(statearr_32574_32661[(2)] = inst_32394);

(statearr_32574_32661[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (17))){
var inst_32428 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32575_32662 = state_32530__$1;
(statearr_32575_32662[(2)] = inst_32428);

(statearr_32575_32662[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (3))){
var inst_32528 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32530__$1,inst_32528);
} else {
if((state_val_32531 === (12))){
var inst_32392 = (state_32530[(11)]);
var state_32530__$1 = state_32530;
var statearr_32576_32663 = state_32530__$1;
(statearr_32576_32663[(2)] = inst_32392);

(statearr_32576_32663[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (2))){
var inst_32391 = (state_32530[(9)]);
var inst_32389 = (state_32530[(17)]);
var _ = (function (){var statearr_32577 = state_32530;
(statearr_32577[(4)] = cljs.core.cons((5),(state_32530[(4)])));

return statearr_32577;
})();
var inst_32389__$1 = fparts;
var inst_32390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32389__$1,(0),null);
var inst_32391__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32389__$1,(1),null);
var inst_32392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32389__$1,(2),null);
var inst_32393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32389__$1,(3),null);
var inst_32394 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_32391__$1);
var state_32530__$1 = (function (){var statearr_32578 = state_32530;
(statearr_32578[(13)] = inst_32394);

(statearr_32578[(14)] = inst_32393);

(statearr_32578[(9)] = inst_32391__$1);

(statearr_32578[(15)] = inst_32390);

(statearr_32578[(11)] = inst_32392);

(statearr_32578[(17)] = inst_32389__$1);

return statearr_32578;
})();
if(cljs.core.truth_(inst_32391__$1)){
var statearr_32579_32664 = state_32530__$1;
(statearr_32579_32664[(1)] = (6));

} else {
var statearr_32580_32665 = state_32530__$1;
(statearr_32580_32665[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (23))){
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32433 = [inst_32390,inst_32391,inst_32430,inst_32393];
var inst_32434 = (new cljs.core.PersistentVector(null,4,(5),inst_32432,inst_32433,null));
var inst_32435 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32434,opts);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(26),inst_32435);
} else {
if((state_val_32531 === (47))){
var inst_32391 = (state_32530[(9)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32391)){
var statearr_32581_32666 = state_32530__$1;
(statearr_32581_32666[(1)] = (53));

} else {
var statearr_32582_32667 = state_32530__$1;
(statearr_32582_32667[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (35))){
var inst_32448 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32583_32668 = state_32530__$1;
(statearr_32583_32668[(2)] = inst_32448);

(statearr_32583_32668[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (19))){
var inst_32391 = (state_32530[(9)]);
var inst_32392 = (state_32530[(11)]);
var inst_32418 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_32391);
var inst_32419 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32418),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32392)].join('');
var inst_32420 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32419);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(22),inst_32420);
} else {
if((state_val_32531 === (57))){
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32501 = [inst_32430,inst_32391,inst_32390,inst_32393];
var inst_32502 = (new cljs.core.PersistentVector(null,4,(5),inst_32500,inst_32501,null));
var inst_32503 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_32502,opts);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(60),inst_32503);
} else {
if((state_val_32531 === (11))){
var inst_32405 = (state_32530[(16)]);
var inst_32405__$1 = (state_32530[(2)]);
var inst_32406 = cljs.core.not(inst_32405__$1);
var state_32530__$1 = (function (){var statearr_32585 = state_32530;
(statearr_32585[(16)] = inst_32405__$1);

return statearr_32585;
})();
if(inst_32406){
var statearr_32586_32669 = state_32530__$1;
(statearr_32586_32669[(1)] = (12));

} else {
var statearr_32587_32670 = state_32530__$1;
(statearr_32587_32670[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (9))){
var inst_32392 = (state_32530[(11)]);
var inst_32402 = typeof inst_32392 === 'string';
var state_32530__$1 = state_32530;
var statearr_32588_32671 = state_32530__$1;
(statearr_32588_32671[(2)] = inst_32402);

(statearr_32588_32671[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (5))){
var _ = (function (){var statearr_32589 = state_32530;
(statearr_32589[(4)] = cljs.core.rest((state_32530[(4)])));

return statearr_32589;
})();
var state_32530__$1 = state_32530;
var ex32584 = (state_32530__$1[(2)]);
var statearr_32590_32672 = state_32530__$1;
(statearr_32590_32672[(5)] = ex32584);


if((ex32584 instanceof Error)){
var statearr_32591_32673 = state_32530__$1;
(statearr_32591_32673[(1)] = (4));

(statearr_32591_32673[(5)] = null);

} else {
throw ex32584;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (14))){
var inst_32390 = (state_32530[(15)]);
var inst_32430 = (state_32530[(2)]);
var state_32530__$1 = (function (){var statearr_32592 = state_32530;
(statearr_32592[(8)] = inst_32430);

return statearr_32592;
})();
if(cljs.core.truth_(inst_32390)){
var statearr_32593_32674 = state_32530__$1;
(statearr_32593_32674[(1)] = (23));

} else {
var statearr_32594_32675 = state_32530__$1;
(statearr_32594_32675[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (45))){
var inst_32469 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32595_32676 = state_32530__$1;
(statearr_32595_32676[(2)] = inst_32469);

(statearr_32595_32676[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (53))){
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32492 = [inst_32391,inst_32390,inst_32430,inst_32393];
var inst_32493 = (new cljs.core.PersistentVector(null,4,(5),inst_32491,inst_32492,null));
var inst_32494 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32493,opts);
var state_32530__$1 = state_32530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32530__$1,(56),inst_32494);
} else {
if((state_val_32531 === (26))){
var inst_32437 = (state_32530[(2)]);
var inst_32438 = fluree.db.util.async.throw_err(inst_32437);
var state_32530__$1 = state_32530;
var statearr_32596_32677 = state_32530__$1;
(statearr_32596_32677[(2)] = inst_32438);

(statearr_32596_32677[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (16))){
var inst_32392 = (state_32530[(11)]);
var inst_32416 = typeof inst_32392 === 'string';
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32416)){
var statearr_32597_32678 = state_32530__$1;
(statearr_32597_32678[(1)] = (19));

} else {
var statearr_32598_32679 = state_32530__$1;
(statearr_32598_32679[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (38))){
var inst_32515 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
var statearr_32599_32680 = state_32530__$1;
(statearr_32599_32680[(2)] = inst_32515);

(statearr_32599_32680[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (30))){
var inst_32394 = (state_32530[(13)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32394)){
var statearr_32600_32681 = state_32530__$1;
(statearr_32600_32681[(1)] = (33));

} else {
var statearr_32601_32682 = state_32530__$1;
(statearr_32601_32682[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (10))){
var inst_32400 = (state_32530[(12)]);
var state_32530__$1 = state_32530;
var statearr_32602_32683 = state_32530__$1;
(statearr_32602_32683[(2)] = inst_32400);

(statearr_32602_32683[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (18))){
var inst_32413 = (state_32530[(2)]);
var inst_32414 = fluree.db.util.async.throw_err(inst_32413);
var state_32530__$1 = state_32530;
var statearr_32603_32684 = state_32530__$1;
(statearr_32603_32684[(2)] = inst_32414);

(statearr_32603_32684[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (52))){
var inst_32487 = (state_32530[(2)]);
var inst_32488 = fluree.db.util.async.throw_err(inst_32487);
var state_32530__$1 = state_32530;
var statearr_32604_32685 = state_32530__$1;
(statearr_32604_32685[(2)] = inst_32488);

(statearr_32604_32685[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (42))){
var inst_32472 = (state_32530[(2)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32472)){
var statearr_32605_32686 = state_32530__$1;
(statearr_32605_32686[(1)] = (46));

} else {
var statearr_32606_32687 = state_32530__$1;
(statearr_32606_32687[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (37))){
var inst_32391 = (state_32530[(9)]);
var state_32530__$1 = state_32530;
if(cljs.core.truth_(inst_32391)){
var statearr_32607_32688 = state_32530__$1;
(statearr_32607_32688[(1)] = (40));

} else {
var statearr_32608_32689 = state_32530__$1;
(statearr_32608_32689[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (63))){
var inst_32525 = (state_32530[(2)]);
var _ = (function (){var statearr_32609 = state_32530;
(statearr_32609[(4)] = cljs.core.rest((state_32530[(4)])));

return statearr_32609;
})();
var state_32530__$1 = state_32530;
var statearr_32610_32690 = state_32530__$1;
(statearr_32610_32690[(2)] = inst_32525);

(statearr_32610_32690[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (8))){
var inst_32400 = (state_32530[(12)]);
var inst_32400__$1 = (state_32530[(2)]);
var state_32530__$1 = (function (){var statearr_32611 = state_32530;
(statearr_32611[(12)] = inst_32400__$1);

return statearr_32611;
})();
if(cljs.core.truth_(inst_32400__$1)){
var statearr_32612_32691 = state_32530__$1;
(statearr_32612_32691[(1)] = (9));

} else {
var statearr_32613_32692 = state_32530__$1;
(statearr_32613_32692[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32531 === (49))){
var inst_32474 = (state_32530[(10)]);
var inst_32400 = (state_32530[(12)]);
var inst_32394 = (state_32530[(13)]);
var inst_32430 = (state_32530[(8)]);
var inst_32393 = (state_32530[(14)]);
var inst_32391 = (state_32530[(9)]);
var inst_32390 = (state_32530[(15)]);
var inst_32405 = (state_32530[(16)]);
var inst_32389 = (state_32530[(17)]);
var inst_32476 = (function (){var obj_fn = inst_32474;
var t = inst_32393;
var temp__5733__auto__ = inst_32474;
var p = inst_32391;
var idx_predicate_QMARK_ = inst_32394;
var o = inst_32430;
var tag_predicate_QMARK_ = inst_32400;
var s = inst_32390;
var o_coerce_QMARK_ = inst_32405;
var vec__32386 = inst_32389;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_32530__$1 = state_32530;
var statearr_32614_32693 = state_32530__$1;
(statearr_32614_32693[(2)] = inst_32476);

(statearr_32614_32693[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32615[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32615[(1)] = (1));

return statearr_32615;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_32530){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32530);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32616){var ex__16304__auto__ = e32616;
var statearr_32617_32694 = state_32530;
(statearr_32617_32694[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32530[(4)]))){
var statearr_32618_32695 = state_32530;
(statearr_32618_32695[(1)] = cljs.core.first((state_32530[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32696 = state_32530;
state_32530 = G__32696;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_32530){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_32530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32619 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32619[(6)] = c__16375__auto__);

return statearr_32619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__32698 = arguments.length;
switch (G__32698) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32733){
var state_val_32734 = (state_32733[(1)]);
if((state_val_32734 === (7))){
var inst_32720 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_32721 = ["Invalid collection name: ",inst_32720].join('');
var inst_32722 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32723 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_32724 = cljs.core.PersistentHashMap.fromArrays(inst_32722,inst_32723);
var inst_32725 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32721,inst_32724);
var inst_32726 = (function(){throw inst_32725})();
var state_32733__$1 = state_32733;
var statearr_32735_32755 = state_32733__$1;
(statearr_32735_32755[(2)] = inst_32726);

(statearr_32735_32755[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (1))){
var state_32733__$1 = state_32733;
var statearr_32736_32756 = state_32733__$1;
(statearr_32736_32756[(2)] = null);

(statearr_32736_32756[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (4))){
var inst_32699 = (state_32733[(2)]);
var state_32733__$1 = state_32733;
var statearr_32737_32757 = state_32733__$1;
(statearr_32737_32757[(2)] = inst_32699);

(statearr_32737_32757[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (6))){
var inst_32705 = (state_32733[(7)]);
var inst_32707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32708 = fluree.db.flake.max_subject_id(inst_32705);
var inst_32709 = [inst_32708];
var inst_32710 = (new cljs.core.PersistentVector(null,1,(5),inst_32707,inst_32709,null));
var inst_32711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32712 = fluree.db.flake.min_subject_id(inst_32705);
var inst_32713 = [inst_32712];
var inst_32714 = (new cljs.core.PersistentVector(null,1,(5),inst_32711,inst_32713,null));
var inst_32715 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32710,cljs.core._LT__EQ_,inst_32714,opts);
var state_32733__$1 = state_32733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32733__$1,(9),inst_32715);
} else {
if((state_val_32734 === (3))){
var inst_32731 = (state_32733[(2)]);
var state_32733__$1 = state_32733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32733__$1,inst_32731);
} else {
if((state_val_32734 === (2))){
var inst_32705 = (state_32733[(7)]);
var _ = (function (){var statearr_32739 = state_32733;
(statearr_32739[(4)] = cljs.core.cons((5),(state_32733[(4)])));

return statearr_32739;
})();
var inst_32705__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_32733__$1 = (function (){var statearr_32740 = state_32733;
(statearr_32740[(7)] = inst_32705__$1);

return statearr_32740;
})();
if(cljs.core.truth_(inst_32705__$1)){
var statearr_32741_32758 = state_32733__$1;
(statearr_32741_32758[(1)] = (6));

} else {
var statearr_32742_32759 = state_32733__$1;
(statearr_32742_32759[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (9))){
var inst_32717 = (state_32733[(2)]);
var inst_32718 = fluree.db.util.async.throw_err(inst_32717);
var state_32733__$1 = state_32733;
var statearr_32743_32760 = state_32733__$1;
(statearr_32743_32760[(2)] = inst_32718);

(statearr_32743_32760[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (5))){
var _ = (function (){var statearr_32744 = state_32733;
(statearr_32744[(4)] = cljs.core.rest((state_32733[(4)])));

return statearr_32744;
})();
var state_32733__$1 = state_32733;
var ex32738 = (state_32733__$1[(2)]);
var statearr_32745_32761 = state_32733__$1;
(statearr_32745_32761[(5)] = ex32738);


var statearr_32746_32762 = state_32733__$1;
(statearr_32746_32762[(1)] = (4));

(statearr_32746_32762[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32734 === (8))){
var inst_32728 = (state_32733[(2)]);
var _ = (function (){var statearr_32747 = state_32733;
(statearr_32747[(4)] = cljs.core.rest((state_32733[(4)])));

return statearr_32747;
})();
var state_32733__$1 = state_32733;
var statearr_32748_32763 = state_32733__$1;
(statearr_32748_32763[(2)] = inst_32728);

(statearr_32748_32763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_32749 = [null,null,null,null,null,null,null,null];
(statearr_32749[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_32749[(1)] = (1));

return statearr_32749;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_32733){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32733);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32750){var ex__16304__auto__ = e32750;
var statearr_32751_32764 = state_32733;
(statearr_32751_32764[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32733[(4)]))){
var statearr_32752_32765 = state_32733;
(statearr_32752_32765[(1)] = cljs.core.first((state_32733[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32766 = state_32733;
state_32733 = G__32766;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_32733){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_32733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32753 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32753[(6)] = c__16375__auto__);

return statearr_32753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__32770 = flakes;
var vec__32771 = G__32770;
var seq__32772 = cljs.core.seq(vec__32771);
var first__32773 = cljs.core.first(seq__32772);
var seq__32772__$1 = cljs.core.next(seq__32772);
var flake_SINGLEQUOTE_ = first__32773;
var r = seq__32772__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32770__$1 = G__32770;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32780 = G__32770__$1;
var seq__32781 = cljs.core.seq(vec__32780);
var first__32782 = cljs.core.first(seq__32781);
var seq__32781__$1 = cljs.core.next(seq__32781);
var flake_SINGLEQUOTE___$1 = first__32782;
var r__$1 = seq__32781__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e32784){var e = e32784;
return null;
}})();
var map__32783 = cmd_map;
var map__32783__$1 = (((((!((map__32783 == null))))?(((((map__32783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32783.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32783):map__32783);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32783__$1,cljs.core.cst$kw$expire);
var G__32786 = r__$1;
var G__32787 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__32770__$1 = G__32786;
result_STAR___$1 = G__32787;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__32796 = blocks;
var vec__32797 = G__32796;
var seq__32798 = cljs.core.seq(vec__32797);
var first__32799 = cljs.core.first(seq__32798);
var seq__32798__$1 = cljs.core.next(seq__32798);
var block_SINGLEQUOTE_ = first__32799;
var r = seq__32798__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32796__$1 = G__32796;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32805 = G__32796__$1;
var seq__32806 = cljs.core.seq(vec__32805);
var first__32807 = cljs.core.first(seq__32806);
var seq__32806__$1 = cljs.core.next(seq__32806);
var block_SINGLEQUOTE___$1 = first__32807;
var r__$1 = seq__32806__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__32808 = block_SINGLEQUOTE___$1;
var map__32808__$1 = (((((!((map__32808 == null))))?(((((map__32808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32808):map__32808);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32808__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32808__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32808__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32788_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32788_SHARP_.p,(2))){
return p1__32788_SHARP_.o;
} else {
return null;
}
});})(G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32789_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32789_SHARP_.p,(1))){
return p1__32789_SHARP_.o;
} else {
return null;
}
});})(G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32790_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32790_SHARP_.p,(5))){
return p1__32790_SHARP_.o;
} else {
return null;
}
});})(G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,instant,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32791_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32791_SHARP_.p,(7))){
return p1__32791_SHARP_.o;
} else {
return null;
}
});})(G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,instant,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32792_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32792_SHARP_.p,(106));
});})(G__32796__$1,result_STAR___$1,map__32808,map__32808__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32805,seq__32806,first__32807,seq__32806__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32796,vec__32797,seq__32798,first__32799,seq__32798__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__32810 = r__$1;
var G__32811 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__32796__$1 = G__32810;
result_STAR___$1 = G__32811;
continue;
}
break;
}
});
