// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33748_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33748_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__33752 = coll;
var vec__33753 = G__33752;
var seq__33754 = cljs.core.seq(vec__33753);
var first__33755 = cljs.core.first(seq__33754);
var seq__33754__$1 = cljs.core.next(seq__33754);
var clause = first__33755;
var r = seq__33754__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33752__$1 = G__33752;
var res__$1 = res;
while(true){
var vec__33759 = G__33752__$1;
var seq__33760 = cljs.core.seq(vec__33759);
var first__33761 = cljs.core.first(seq__33760);
var seq__33760__$1 = cljs.core.next(seq__33760);
var clause__$1 = first__33761;
var r__$1 = seq__33760__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33762 = r__$1;
var G__33763 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33752__$1 = G__33762;
res__$1 = G__33763;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__33767 = coll;
var vec__33768 = G__33767;
var seq__33769 = cljs.core.seq(vec__33768);
var first__33770 = cljs.core.first(seq__33769);
var seq__33769__$1 = cljs.core.next(seq__33769);
var clause = first__33770;
var r = seq__33769__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33767__$1 = G__33767;
var res__$1 = res;
while(true){
var vec__33774 = G__33767__$1;
var seq__33775 = cljs.core.seq(vec__33774);
var first__33776 = cljs.core.first(seq__33775);
var seq__33775__$1 = cljs.core.next(seq__33775);
var clause__$1 = first__33776;
var r__$1 = seq__33775__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33777 = r__$1;
var G__33778 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__33767__$1 = G__33777;
res__$1 = G__33778;
continue;
} else {
var G__33779 = r__$1;
var G__33780 = res__$2;
G__33767__$1 = G__33779;
res__$1 = G__33780;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__33784 = coll;
var vec__33785 = G__33784;
var seq__33786 = cljs.core.seq(vec__33785);
var first__33787 = cljs.core.first(seq__33786);
var seq__33786__$1 = cljs.core.next(seq__33786);
var clause = first__33787;
var r = seq__33786__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33784__$1 = G__33784;
var res__$1 = res;
while(true){
var vec__33791 = G__33784__$1;
var seq__33792 = cljs.core.seq(vec__33791);
var first__33793 = cljs.core.first(seq__33792);
var seq__33792__$1 = cljs.core.next(seq__33792);
var clause__$1 = first__33793;
var r__$1 = seq__33792__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33794 = r__$1;
var G__33795 = res__$2;
G__33784__$1 = G__33794;
res__$1 = G__33795;
continue;
} else {
var G__33796 = r__$1;
var G__33797 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33784__$1 = G__33796;
res__$1 = G__33797;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__33801 = opts;
var map__33801__$1 = (((((!((map__33801 == null))))?(((((map__33801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33801):map__33801);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33801__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33801__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33801__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33801__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33801__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33798_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33798_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33799_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33799_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33800_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33800_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33816){
var state_val_33817 = (state_33816[(1)]);
if((state_val_33817 === (1))){
var inst_33803 = fluree.db.util.core.url_encode(query);
var inst_33804 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33803)].join('');
var inst_33805 = ["User-Agent","Accept"];
var inst_33806 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_33807 = cljs.core.PersistentHashMap.fromArrays(inst_33805,inst_33806);
var inst_33808 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_33809 = [inst_33807,(30000),cljs.core.cst$kw$wikidata];
var inst_33810 = cljs.core.PersistentHashMap.fromArrays(inst_33808,inst_33809);
var inst_33811 = fluree.db.util.xhttp.get(inst_33804,inst_33810);
var state_33816__$1 = state_33816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33816__$1,(2),inst_33811);
} else {
if((state_val_33817 === (2))){
var inst_33813 = (state_33816[(2)]);
var inst_33814 = fluree.db.util.async.throw_err(inst_33813);
var state_33816__$1 = state_33816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33816__$1,inst_33814);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_33818 = [null,null,null,null,null,null,null];
(statearr_33818[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__);

(statearr_33818[(1)] = (1));

return statearr_33818;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1 = (function (state_33816){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33816);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33819){var ex__16304__auto__ = e33819;
var statearr_33820_33823 = state_33816;
(statearr_33820_33823[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33816[(4)]))){
var statearr_33821_33824 = state_33816;
(statearr_33821_33824[(1)] = cljs.core.first((state_33816[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33825 = state_33816;
state_33816 = G__33825;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = function(state_33816){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1.call(this,state_33816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33822 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33822[(6)] = c__16375__auto__);

return statearr_33822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33843){
var state_val_33844 = (state_33843[(1)]);
if((state_val_33844 === (1))){
var inst_33826 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_33843__$1 = state_33843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33843__$1,(2),inst_33826);
} else {
if((state_val_33844 === (2))){
var inst_33829 = (state_33843[(7)]);
var inst_33828 = (state_33843[(2)]);
var inst_33829__$1 = fluree.db.util.async.throw_err(inst_33828);
var inst_33830 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33829__$1);
var inst_33831 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_33830);
var state_33843__$1 = (function (){var statearr_33845 = state_33843;
(statearr_33845[(7)] = inst_33829__$1);

return statearr_33845;
})();
if(inst_33831){
var statearr_33846_33855 = state_33843__$1;
(statearr_33846_33855[(1)] = (3));

} else {
var statearr_33847_33856 = state_33843__$1;
(statearr_33847_33856[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33844 === (3))){
var inst_33829 = (state_33843[(7)]);
var state_33843__$1 = state_33843;
var statearr_33848_33857 = state_33843__$1;
(statearr_33848_33857[(2)] = inst_33829);

(statearr_33848_33857[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33844 === (4))){
var inst_33829 = (state_33843[(7)]);
var inst_33834 = (function (){var body = inst_33829;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_33835 = cljs.core.second(inst_33829);
var inst_33836 = cljs.core.second(inst_33835);
var inst_33837 = cljs.core.first(inst_33836);
var inst_33838 = cljs.core.second(inst_33837);
var inst_33839 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_33834,inst_33838);
var state_33843__$1 = state_33843;
var statearr_33849_33858 = state_33843__$1;
(statearr_33849_33858[(2)] = inst_33839);

(statearr_33849_33858[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33844 === (5))){
var inst_33841 = (state_33843[(2)]);
var state_33843__$1 = state_33843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33843__$1,inst_33841);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_33850 = [null,null,null,null,null,null,null,null];
(statearr_33850[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__);

(statearr_33850[(1)] = (1));

return statearr_33850;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1 = (function (state_33843){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33843);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33851){var ex__16304__auto__ = e33851;
var statearr_33852_33859 = state_33843;
(statearr_33852_33859[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33843[(4)]))){
var statearr_33853_33860 = state_33843;
(statearr_33853_33860[(1)] = cljs.core.first((state_33843[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33861 = state_33843;
state_33843 = G__33861;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = function(state_33843){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1.call(this,state_33843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33854 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33854[(6)] = c__16375__auto__);

return statearr_33854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33862_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33862_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33863_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33863_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33864_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__33864_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33864_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__33864_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33930){
var state_val_33931 = (state_33930[(1)]);
if((state_val_33931 === (7))){
var inst_33875 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_33930__$1 = state_33930;
var statearr_33932_33973 = state_33930__$1;
(statearr_33932_33973[(2)] = inst_33875);

(statearr_33932_33973[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (20))){
var inst_33903 = (state_33930[(7)]);
var inst_33923 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_33903,all_vars);
var state_33930__$1 = state_33930;
var statearr_33933_33974 = state_33930__$1;
(statearr_33933_33974[(2)] = inst_33923);

(statearr_33933_33974[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (1))){
var state_33930__$1 = state_33930;
var statearr_33934_33975 = state_33930__$1;
(statearr_33934_33975[(2)] = null);

(statearr_33934_33975[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (24))){
var inst_33909 = (state_33930[(8)]);
var inst_33904 = (state_33930[(9)]);
var inst_33903 = (state_33930[(7)]);
var inst_33914 = (state_33930[(2)]);
var inst_33915 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_33909,(0),inst_33914);
var inst_33916 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33917 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_33903);
var inst_33918 = [inst_33904,inst_33917];
var inst_33919 = cljs.core.PersistentHashMap.fromArrays(inst_33916,inst_33918);
var inst_33920 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33915,inst_33919);
var inst_33921 = (function(){throw inst_33920})();
var state_33930__$1 = state_33930;
var statearr_33935_33976 = state_33930__$1;
(statearr_33935_33976[(2)] = inst_33921);

(statearr_33935_33976[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (4))){
var inst_33865 = (state_33930[(2)]);
var state_33930__$1 = state_33930;
var statearr_33936_33977 = state_33930__$1;
(statearr_33936_33977[(2)] = inst_33865);

(statearr_33936_33977[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (15))){
var inst_33895 = (state_33930[(2)]);
var state_33930__$1 = state_33930;
var statearr_33937_33978 = state_33930__$1;
(statearr_33937_33978[(2)] = inst_33895);

(statearr_33937_33978[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (21))){
var inst_33925 = (state_33930[(2)]);
var _ = (function (){var statearr_33938 = state_33930;
(statearr_33938[(4)] = cljs.core.rest((state_33930[(4)])));

return statearr_33938;
})();
var state_33930__$1 = state_33930;
var statearr_33939_33979 = state_33930__$1;
(statearr_33939_33979[(2)] = inst_33925);

(statearr_33939_33979[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (13))){
var state_33930__$1 = state_33930;
var statearr_33940_33980 = state_33930__$1;
(statearr_33940_33980[(2)] = true);

(statearr_33940_33980[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (22))){
var inst_33908 = (state_33930[(10)]);
var state_33930__$1 = state_33930;
var statearr_33941_33981 = state_33930__$1;
(statearr_33941_33981[(2)] = inst_33908);

(statearr_33941_33981[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (6))){
var state_33930__$1 = state_33930;
var statearr_33942_33982 = state_33930__$1;
(statearr_33942_33982[(2)] = null);

(statearr_33942_33982[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (17))){
var inst_33882 = (state_33930[(11)]);
var state_33930__$1 = state_33930;
var statearr_33943_33983 = state_33930__$1;
(statearr_33943_33983[(2)] = inst_33882);

(statearr_33943_33983[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (3))){
var inst_33928 = (state_33930[(2)]);
var state_33930__$1 = state_33930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33930__$1,inst_33928);
} else {
if((state_val_33931 === (12))){
var inst_33898 = (state_33930[(2)]);
var state_33930__$1 = state_33930;
if(cljs.core.truth_(inst_33898)){
var statearr_33944_33984 = state_33930__$1;
(statearr_33944_33984[(1)] = (16));

} else {
var statearr_33945_33985 = state_33930__$1;
(statearr_33945_33985[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (2))){
var _ = (function (){var statearr_33946 = state_33930;
(statearr_33946[(4)] = cljs.core.cons((5),(state_33930[(4)])));

return statearr_33946;
})();
var inst_33872 = cljs.core.empty_QMARK_(matching_vars);
var state_33930__$1 = state_33930;
if(inst_33872){
var statearr_33947_33986 = state_33930__$1;
(statearr_33947_33986[(1)] = (6));

} else {
var statearr_33948_33987 = state_33930__$1;
(statearr_33948_33987[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (23))){
var state_33930__$1 = state_33930;
var statearr_33949_33988 = state_33930__$1;
(statearr_33949_33988[(2)] = (1000));

(statearr_33949_33988[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (19))){
var inst_33908 = (state_33930[(10)]);
var inst_33905 = (state_33930[(12)]);
var inst_33903 = (state_33930[(7)]);
var inst_33908__$1 = cljs.core.count(inst_33905);
var inst_33909 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_33903);
var inst_33910 = (inst_33908__$1 < (1000));
var state_33930__$1 = (function (){var statearr_33950 = state_33930;
(statearr_33950[(8)] = inst_33909);

(statearr_33950[(10)] = inst_33908__$1);

return statearr_33950;
})();
if(cljs.core.truth_(inst_33910)){
var statearr_33951_33989 = state_33930__$1;
(statearr_33951_33989[(1)] = (22));

} else {
var statearr_33952_33990 = state_33930__$1;
(statearr_33952_33990[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (11))){
var state_33930__$1 = state_33930;
var statearr_33954_33991 = state_33930__$1;
(statearr_33954_33991[(2)] = false);

(statearr_33954_33991[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (9))){
var inst_33882 = (state_33930[(11)]);
var inst_33881 = (state_33930[(2)]);
var inst_33882__$1 = fluree.db.util.async.throw_err(inst_33881);
var inst_33884 = (inst_33882__$1 == null);
var inst_33885 = cljs.core.not(inst_33884);
var state_33930__$1 = (function (){var statearr_33955 = state_33930;
(statearr_33955[(11)] = inst_33882__$1);

return statearr_33955;
})();
if(inst_33885){
var statearr_33956_33992 = state_33930__$1;
(statearr_33956_33992[(1)] = (10));

} else {
var statearr_33957_33993 = state_33930__$1;
(statearr_33957_33993[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (5))){
var _ = (function (){var statearr_33958 = state_33930;
(statearr_33958[(4)] = cljs.core.rest((state_33930[(4)])));

return statearr_33958;
})();
var state_33930__$1 = state_33930;
var ex33953 = (state_33930__$1[(2)]);
var statearr_33959_33994 = state_33930__$1;
(statearr_33959_33994[(5)] = ex33953);


if((ex33953 instanceof Error)){
var statearr_33960_33995 = state_33930__$1;
(statearr_33960_33995[(1)] = (4));

(statearr_33960_33995[(5)] = null);

} else {
throw ex33953;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (14))){
var state_33930__$1 = state_33930;
var statearr_33961_33996 = state_33930__$1;
(statearr_33961_33996[(2)] = false);

(statearr_33961_33996[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (16))){
var inst_33882 = (state_33930[(11)]);
var inst_33900 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33882);
var state_33930__$1 = state_33930;
var statearr_33962_33997 = state_33930__$1;
(statearr_33962_33997[(2)] = inst_33900);

(statearr_33962_33997[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (10))){
var inst_33882 = (state_33930[(11)]);
var inst_33887 = inst_33882.cljs$lang$protocol_mask$partition0$;
var inst_33888 = (inst_33887 & (64));
var inst_33889 = inst_33882.cljs$core$ISeq$;
var inst_33890 = (cljs.core.PROTOCOL_SENTINEL === inst_33889);
var inst_33891 = ((inst_33888) || (inst_33890));
var state_33930__$1 = state_33930;
if(cljs.core.truth_(inst_33891)){
var statearr_33963_33998 = state_33930__$1;
(statearr_33963_33998[(1)] = (13));

} else {
var statearr_33964_33999 = state_33930__$1;
(statearr_33964_33999[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (18))){
var inst_33904 = (state_33930[(9)]);
var inst_33903 = (state_33930[(7)]);
var inst_33903__$1 = (state_33930[(2)]);
var inst_33904__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33903__$1,cljs.core.cst$kw$status);
var inst_33905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33903__$1,cljs.core.cst$kw$message);
var inst_33906 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_33904__$1);
var state_33930__$1 = (function (){var statearr_33965 = state_33930;
(statearr_33965[(9)] = inst_33904__$1);

(statearr_33965[(12)] = inst_33905);

(statearr_33965[(7)] = inst_33903__$1);

return statearr_33965;
})();
if(inst_33906){
var statearr_33966_34000 = state_33930__$1;
(statearr_33966_34000[(1)] = (19));

} else {
var statearr_33967_34001 = state_33930__$1;
(statearr_33967_34001[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33931 === (8))){
var inst_33877 = (state_33930[(2)]);
var inst_33878 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_33877,optional_clauses);
var inst_33879 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_33878);
var state_33930__$1 = state_33930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33930__$1,(9),inst_33879);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33968 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33968[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__);

(statearr_33968[(1)] = (1));

return statearr_33968;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1 = (function (state_33930){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33930);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33969){var ex__16304__auto__ = e33969;
var statearr_33970_34002 = state_33930;
(statearr_33970_34002[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33930[(4)]))){
var statearr_33971_34003 = state_33930;
(statearr_33971_34003[(1)] = cljs.core.first((state_33930[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34004 = state_33930;
state_33930 = G__34004;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = function(state_33930){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1.call(this,state_33930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33972 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33972[(6)] = c__16375__auto__);

return statearr_33972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
