// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19537){
var state_val_19538 = (state_19537[(1)]);
if((state_val_19538 === (7))){
var inst_19526 = (state_19537[(7)]);
var inst_19528 = fluree.db.storage.core.serde(conn);
var inst_19529 = fluree.db.serde.protocol._deserialize_block(inst_19528,inst_19526);
var state_19537__$1 = state_19537;
var statearr_19539_19558 = state_19537__$1;
(statearr_19539_19558[(2)] = inst_19529);

(statearr_19539_19558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (1))){
var state_19537__$1 = state_19537;
var statearr_19540_19559 = state_19537__$1;
(statearr_19540_19559[(2)] = null);

(statearr_19540_19559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (4))){
var inst_19516 = (state_19537[(2)]);
var state_19537__$1 = state_19537;
var statearr_19541_19560 = state_19537__$1;
(statearr_19541_19560[(2)] = inst_19516);

(statearr_19541_19560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (6))){
var inst_19526 = (state_19537[(7)]);
var inst_19525 = (state_19537[(2)]);
var inst_19526__$1 = fluree.db.util.async.throw_err(inst_19525);
var state_19537__$1 = (function (){var statearr_19542 = state_19537;
(statearr_19542[(7)] = inst_19526__$1);

return statearr_19542;
})();
if(cljs.core.truth_(inst_19526__$1)){
var statearr_19543_19561 = state_19537__$1;
(statearr_19543_19561[(1)] = (7));

} else {
var statearr_19544_19562 = state_19537__$1;
(statearr_19544_19562[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (3))){
var inst_19535 = (state_19537[(2)]);
var state_19537__$1 = state_19537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19537__$1,inst_19535);
} else {
if((state_val_19538 === (2))){
var _ = (function (){var statearr_19546 = state_19537;
(statearr_19546[(4)] = cljs.core.cons((5),(state_19537[(4)])));

return statearr_19546;
})();
var inst_19522 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_19523 = fluree.db.storage.core.storage_read(conn,inst_19522);
var state_19537__$1 = state_19537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19537__$1,(6),inst_19523);
} else {
if((state_val_19538 === (9))){
var inst_19532 = (state_19537[(2)]);
var _ = (function (){var statearr_19547 = state_19537;
(statearr_19547[(4)] = cljs.core.rest((state_19537[(4)])));

return statearr_19547;
})();
var state_19537__$1 = state_19537;
var statearr_19548_19563 = state_19537__$1;
(statearr_19548_19563[(2)] = inst_19532);

(statearr_19548_19563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (5))){
var _ = (function (){var statearr_19549 = state_19537;
(statearr_19549[(4)] = cljs.core.rest((state_19537[(4)])));

return statearr_19549;
})();
var state_19537__$1 = state_19537;
var ex19545 = (state_19537__$1[(2)]);
var statearr_19550_19564 = state_19537__$1;
(statearr_19550_19564[(5)] = ex19545);


if((ex19545 instanceof Error)){
var statearr_19551_19565 = state_19537__$1;
(statearr_19551_19565[(1)] = (4));

(statearr_19551_19565[(5)] = null);

} else {
throw ex19545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19538 === (8))){
var state_19537__$1 = state_19537;
var statearr_19552_19566 = state_19537__$1;
(statearr_19552_19566[(2)] = null);

(statearr_19552_19566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2414__auto____0 = (function (){
var statearr_19553 = [null,null,null,null,null,null,null,null];
(statearr_19553[(0)] = fluree$db$storage$core$read_block_$_state_machine__2414__auto__);

(statearr_19553[(1)] = (1));

return statearr_19553;
});
var fluree$db$storage$core$read_block_$_state_machine__2414__auto____1 = (function (state_19537){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19537);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19554){var ex__2417__auto__ = e19554;
var statearr_19555_19567 = state_19537;
(statearr_19555_19567[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19537[(4)]))){
var statearr_19556_19568 = state_19537;
(statearr_19556_19568[(1)] = cljs.core.first((state_19537[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19569 = state_19537;
state_19537 = G__19569;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2414__auto__ = function(state_19537){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2414__auto____1.call(this,state_19537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19557 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19557[(6)] = c__2436__auto__);

return statearr_19557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19592){
var state_val_19593 = (state_19592[(1)]);
if((state_val_19593 === (7))){
var inst_19581 = (state_19592[(7)]);
var inst_19583 = fluree.db.storage.core.serde(conn);
var inst_19584 = fluree.db.serde.protocol._deserialize_block(inst_19583,inst_19581);
var state_19592__$1 = state_19592;
var statearr_19594_19613 = state_19592__$1;
(statearr_19594_19613[(2)] = inst_19584);

(statearr_19594_19613[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (1))){
var state_19592__$1 = state_19592;
var statearr_19595_19614 = state_19592__$1;
(statearr_19595_19614[(2)] = null);

(statearr_19595_19614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (4))){
var inst_19570 = (state_19592[(2)]);
var state_19592__$1 = state_19592;
var statearr_19596_19615 = state_19592__$1;
(statearr_19596_19615[(2)] = inst_19570);

(statearr_19596_19615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (6))){
var inst_19581 = (state_19592[(7)]);
var inst_19580 = (state_19592[(2)]);
var inst_19581__$1 = fluree.db.util.async.throw_err(inst_19580);
var state_19592__$1 = (function (){var statearr_19597 = state_19592;
(statearr_19597[(7)] = inst_19581__$1);

return statearr_19597;
})();
if(cljs.core.truth_(inst_19581__$1)){
var statearr_19598_19616 = state_19592__$1;
(statearr_19598_19616[(1)] = (7));

} else {
var statearr_19599_19617 = state_19592__$1;
(statearr_19599_19617[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (3))){
var inst_19590 = (state_19592[(2)]);
var state_19592__$1 = state_19592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19592__$1,inst_19590);
} else {
if((state_val_19593 === (2))){
var _ = (function (){var statearr_19601 = state_19592;
(statearr_19601[(4)] = cljs.core.cons((5),(state_19592[(4)])));

return statearr_19601;
})();
var inst_19576 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_19577 = [inst_19576,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_19578 = fluree.db.storage.core.storage_read(conn,inst_19577);
var state_19592__$1 = state_19592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19592__$1,(6),inst_19578);
} else {
if((state_val_19593 === (9))){
var inst_19587 = (state_19592[(2)]);
var _ = (function (){var statearr_19602 = state_19592;
(statearr_19602[(4)] = cljs.core.rest((state_19592[(4)])));

return statearr_19602;
})();
var state_19592__$1 = state_19592;
var statearr_19603_19618 = state_19592__$1;
(statearr_19603_19618[(2)] = inst_19587);

(statearr_19603_19618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (5))){
var _ = (function (){var statearr_19604 = state_19592;
(statearr_19604[(4)] = cljs.core.rest((state_19592[(4)])));

return statearr_19604;
})();
var state_19592__$1 = state_19592;
var ex19600 = (state_19592__$1[(2)]);
var statearr_19605_19619 = state_19592__$1;
(statearr_19605_19619[(5)] = ex19600);


if((ex19600 instanceof Error)){
var statearr_19606_19620 = state_19592__$1;
(statearr_19606_19620[(1)] = (4));

(statearr_19606_19620[(5)] = null);

} else {
throw ex19600;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19593 === (8))){
var state_19592__$1 = state_19592;
var statearr_19607_19621 = state_19592__$1;
(statearr_19607_19621[(2)] = null);

(statearr_19607_19621[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0 = (function (){
var statearr_19608 = [null,null,null,null,null,null,null,null];
(statearr_19608[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__);

(statearr_19608[(1)] = (1));

return statearr_19608;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1 = (function (state_19592){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19592);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19609){var ex__2417__auto__ = e19609;
var statearr_19610_19622 = state_19592;
(statearr_19610_19622[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19592[(4)]))){
var statearr_19611_19623 = state_19592;
(statearr_19611_19623[(1)] = cljs.core.first((state_19592[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19624 = state_19592;
state_19592 = G__19624;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__ = function(state_19592){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1.call(this,state_19592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19612 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19612[(6)] = c__2436__auto__);

return statearr_19612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19648){
var state_val_19649 = (state_19648[(1)]);
if((state_val_19649 === (1))){
var state_19648__$1 = state_19648;
var statearr_19650_19664 = state_19648__$1;
(statearr_19650_19664[(2)] = null);

(statearr_19650_19664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19649 === (2))){
var _ = (function (){var statearr_19651 = state_19648;
(statearr_19651[(4)] = cljs.core.cons((5),(state_19648[(4)])));

return statearr_19651;
})();
var inst_19631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19632 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_19633 = (new cljs.core.PersistentVector(null,3,(5),inst_19631,inst_19632,null));
var inst_19634 = cljs.core.select_keys(block_data,inst_19633);
var inst_19635 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_19634);
var inst_19636 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_19635);
var inst_19637 = [inst_19636,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_19638 = fluree.db.storage.core.serde(conn);
var inst_19639 = fluree.db.serde.protocol._serialize_block(inst_19638,inst_19634);
var inst_19640 = fluree.db.storage.core.storage_write(conn,inst_19637,inst_19639);
var state_19648__$1 = state_19648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19648__$1,(6),inst_19640);
} else {
if((state_val_19649 === (3))){
var inst_19646 = (state_19648[(2)]);
var state_19648__$1 = state_19648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19648__$1,inst_19646);
} else {
if((state_val_19649 === (4))){
var inst_19625 = (state_19648[(2)]);
var state_19648__$1 = state_19648;
var statearr_19653_19665 = state_19648__$1;
(statearr_19653_19665[(2)] = inst_19625);

(statearr_19653_19665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19649 === (5))){
var _ = (function (){var statearr_19654 = state_19648;
(statearr_19654[(4)] = cljs.core.rest((state_19648[(4)])));

return statearr_19654;
})();
var state_19648__$1 = state_19648;
var ex19652 = (state_19648__$1[(2)]);
var statearr_19655_19666 = state_19648__$1;
(statearr_19655_19666[(5)] = ex19652);


if((ex19652 instanceof Error)){
var statearr_19656_19667 = state_19648__$1;
(statearr_19656_19667[(1)] = (4));

(statearr_19656_19667[(5)] = null);

} else {
throw ex19652;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19649 === (6))){
var inst_19642 = (state_19648[(2)]);
var inst_19643 = fluree.db.util.async.throw_err(inst_19642);
var _ = (function (){var statearr_19657 = state_19648;
(statearr_19657[(4)] = cljs.core.rest((state_19648[(4)])));

return statearr_19657;
})();
var state_19648__$1 = state_19648;
var statearr_19658_19668 = state_19648__$1;
(statearr_19658_19668[(2)] = inst_19643);

(statearr_19658_19668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0 = (function (){
var statearr_19659 = [null,null,null,null,null,null,null];
(statearr_19659[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__);

(statearr_19659[(1)] = (1));

return statearr_19659;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1 = (function (state_19648){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19648);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19660){var ex__2417__auto__ = e19660;
var statearr_19661_19669 = state_19648;
(statearr_19661_19669[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19648[(4)]))){
var statearr_19662_19670 = state_19648;
(statearr_19662_19670[(1)] = cljs.core.first((state_19648[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19671 = state_19648;
state_19648 = G__19671;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__ = function(state_19648){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1.call(this,state_19648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19663 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19663[(6)] = c__2436__auto__);

return statearr_19663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19694){
var state_val_19695 = (state_19694[(1)]);
if((state_val_19695 === (1))){
var state_19694__$1 = state_19694;
var statearr_19696_19710 = state_19694__$1;
(statearr_19696_19710[(2)] = null);

(statearr_19696_19710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (2))){
var _ = (function (){var statearr_19697 = state_19694;
(statearr_19697[(4)] = cljs.core.cons((5),(state_19694[(4)])));

return statearr_19697;
})();
var inst_19678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19679 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_19680 = (new cljs.core.PersistentVector(null,3,(5),inst_19678,inst_19679,null));
var inst_19681 = cljs.core.select_keys(block_data,inst_19680);
var inst_19682 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_19681);
var inst_19683 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_19682);
var inst_19684 = fluree.db.storage.core.serde(conn);
var inst_19685 = fluree.db.serde.protocol._serialize_block(inst_19684,inst_19681);
var inst_19686 = fluree.db.storage.core.storage_write(conn,inst_19683,inst_19685);
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19694__$1,(6),inst_19686);
} else {
if((state_val_19695 === (3))){
var inst_19692 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19694__$1,inst_19692);
} else {
if((state_val_19695 === (4))){
var inst_19672 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19699_19711 = state_19694__$1;
(statearr_19699_19711[(2)] = inst_19672);

(statearr_19699_19711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (5))){
var _ = (function (){var statearr_19700 = state_19694;
(statearr_19700[(4)] = cljs.core.rest((state_19694[(4)])));

return statearr_19700;
})();
var state_19694__$1 = state_19694;
var ex19698 = (state_19694__$1[(2)]);
var statearr_19701_19712 = state_19694__$1;
(statearr_19701_19712[(5)] = ex19698);


if((ex19698 instanceof Error)){
var statearr_19702_19713 = state_19694__$1;
(statearr_19702_19713[(1)] = (4));

(statearr_19702_19713[(5)] = null);

} else {
throw ex19698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (6))){
var inst_19688 = (state_19694[(2)]);
var inst_19689 = fluree.db.util.async.throw_err(inst_19688);
var _ = (function (){var statearr_19703 = state_19694;
(statearr_19703[(4)] = cljs.core.rest((state_19694[(4)])));

return statearr_19703;
})();
var state_19694__$1 = state_19694;
var statearr_19704_19714 = state_19694__$1;
(statearr_19704_19714[(2)] = inst_19689);

(statearr_19704_19714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2414__auto____0 = (function (){
var statearr_19705 = [null,null,null,null,null,null,null];
(statearr_19705[(0)] = fluree$db$storage$core$write_block_$_state_machine__2414__auto__);

(statearr_19705[(1)] = (1));

return statearr_19705;
});
var fluree$db$storage$core$write_block_$_state_machine__2414__auto____1 = (function (state_19694){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19694);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19706){var ex__2417__auto__ = e19706;
var statearr_19707_19715 = state_19694;
(statearr_19707_19715[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19694[(4)]))){
var statearr_19708_19716 = state_19694;
(statearr_19708_19716[(1)] = cljs.core.first((state_19694[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19717 = state_19694;
state_19694 = G__19717;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2414__auto__ = function(state_19694){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2414__auto____1.call(this,state_19694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19709 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19709[(6)] = c__2436__auto__);

return statearr_19709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19737){
var state_val_19738 = (state_19737[(1)]);
if((state_val_19738 === (1))){
var state_19737__$1 = state_19737;
var statearr_19739_19753 = state_19737__$1;
(statearr_19739_19753[(2)] = null);

(statearr_19739_19753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19738 === (2))){
var _ = (function (){var statearr_19740 = state_19737;
(statearr_19740[(4)] = cljs.core.cons((5),(state_19737[(4)])));

return statearr_19740;
})();
var inst_19724 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_19725 = [history,next_his_key];
var inst_19726 = cljs.core.PersistentHashMap.fromArrays(inst_19724,inst_19725);
var inst_19727 = fluree.db.storage.core.serde(conn);
var inst_19728 = fluree.db.serde.protocol._serialize_leaf(inst_19727,inst_19726);
var inst_19729 = fluree.db.storage.core.storage_write(conn,his_key,inst_19728);
var state_19737__$1 = state_19737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19737__$1,(6),inst_19729);
} else {
if((state_val_19738 === (3))){
var inst_19735 = (state_19737[(2)]);
var state_19737__$1 = state_19737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19737__$1,inst_19735);
} else {
if((state_val_19738 === (4))){
var inst_19718 = (state_19737[(2)]);
var state_19737__$1 = state_19737;
var statearr_19742_19754 = state_19737__$1;
(statearr_19742_19754[(2)] = inst_19718);

(statearr_19742_19754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19738 === (5))){
var _ = (function (){var statearr_19743 = state_19737;
(statearr_19743[(4)] = cljs.core.rest((state_19737[(4)])));

return statearr_19743;
})();
var state_19737__$1 = state_19737;
var ex19741 = (state_19737__$1[(2)]);
var statearr_19744_19755 = state_19737__$1;
(statearr_19744_19755[(5)] = ex19741);


if((ex19741 instanceof Error)){
var statearr_19745_19756 = state_19737__$1;
(statearr_19745_19756[(1)] = (4));

(statearr_19745_19756[(5)] = null);

} else {
throw ex19741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19738 === (6))){
var inst_19731 = (state_19737[(2)]);
var inst_19732 = fluree.db.util.async.throw_err(inst_19731);
var _ = (function (){var statearr_19746 = state_19737;
(statearr_19746[(4)] = cljs.core.rest((state_19737[(4)])));

return statearr_19746;
})();
var state_19737__$1 = state_19737;
var statearr_19747_19757 = state_19737__$1;
(statearr_19747_19757[(2)] = inst_19732);

(statearr_19747_19757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2414__auto____0 = (function (){
var statearr_19748 = [null,null,null,null,null,null,null];
(statearr_19748[(0)] = fluree$db$storage$core$write_history_$_state_machine__2414__auto__);

(statearr_19748[(1)] = (1));

return statearr_19748;
});
var fluree$db$storage$core$write_history_$_state_machine__2414__auto____1 = (function (state_19737){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19737);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19749){var ex__2417__auto__ = e19749;
var statearr_19750_19758 = state_19737;
(statearr_19750_19758[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19737[(4)]))){
var statearr_19751_19759 = state_19737;
(statearr_19751_19759[(1)] = cljs.core.first((state_19737[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19760 = state_19737;
state_19737 = G__19760;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2414__auto__ = function(state_19737){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2414__auto____1.call(this,state_19737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19752 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19752[(6)] = c__2436__auto__);

return statearr_19752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19786){
var state_val_19787 = (state_19786[(1)]);
if((state_val_19787 === (1))){
var state_19786__$1 = state_19786;
var statearr_19788_19805 = state_19786__$1;
(statearr_19788_19805[(2)] = null);

(statearr_19788_19805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (2))){
var inst_19767 = (state_19786[(7)]);
var _ = (function (){var statearr_19789 = state_19786;
(statearr_19789[(4)] = cljs.core.cons((5),(state_19786[(4)])));

return statearr_19789;
})();
var inst_19767__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_19768 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19767__$1),"-his"].join('');
var inst_19769 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_19770 = [flakes,inst_19768];
var inst_19771 = cljs.core.PersistentHashMap.fromArrays(inst_19769,inst_19770);
var inst_19772 = fluree.db.storage.core.serde(conn);
var inst_19773 = fluree.db.serde.protocol._serialize_leaf(inst_19772,inst_19771);
var inst_19774 = fluree.db.storage.core.write_history(conn,history,inst_19768,null);
var inst_19775 = fluree.db.storage.core.storage_write(conn,inst_19767__$1,inst_19773);
var state_19786__$1 = (function (){var statearr_19790 = state_19786;
(statearr_19790[(8)] = inst_19775);

(statearr_19790[(7)] = inst_19767__$1);

return statearr_19790;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19786__$1,(6),inst_19774);
} else {
if((state_val_19787 === (3))){
var inst_19784 = (state_19786[(2)]);
var state_19786__$1 = state_19786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19786__$1,inst_19784);
} else {
if((state_val_19787 === (4))){
var inst_19761 = (state_19786[(2)]);
var state_19786__$1 = state_19786;
var statearr_19792_19806 = state_19786__$1;
(statearr_19792_19806[(2)] = inst_19761);

(statearr_19792_19806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (5))){
var _ = (function (){var statearr_19793 = state_19786;
(statearr_19793[(4)] = cljs.core.rest((state_19786[(4)])));

return statearr_19793;
})();
var state_19786__$1 = state_19786;
var ex19791 = (state_19786__$1[(2)]);
var statearr_19794_19807 = state_19786__$1;
(statearr_19794_19807[(5)] = ex19791);


if((ex19791 instanceof Error)){
var statearr_19795_19808 = state_19786__$1;
(statearr_19795_19808[(1)] = (4));

(statearr_19795_19808[(5)] = null);

} else {
throw ex19791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (6))){
var inst_19775 = (state_19786[(8)]);
var inst_19777 = (state_19786[(2)]);
var inst_19778 = fluree.db.util.async.throw_err(inst_19777);
var state_19786__$1 = (function (){var statearr_19796 = state_19786;
(statearr_19796[(9)] = inst_19778);

return statearr_19796;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19786__$1,(7),inst_19775);
} else {
if((state_val_19787 === (7))){
var inst_19767 = (state_19786[(7)]);
var inst_19780 = (state_19786[(2)]);
var inst_19781 = fluree.db.util.async.throw_err(inst_19780);
var _ = (function (){var statearr_19797 = state_19786;
(statearr_19797[(4)] = cljs.core.rest((state_19786[(4)])));

return statearr_19797;
})();
var state_19786__$1 = (function (){var statearr_19798 = state_19786;
(statearr_19798[(10)] = inst_19781);

return statearr_19798;
})();
var statearr_19799_19809 = state_19786__$1;
(statearr_19799_19809[(2)] = inst_19767);

(statearr_19799_19809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_19800 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19800[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__);

(statearr_19800[(1)] = (1));

return statearr_19800;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1 = (function (state_19786){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19786);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19801){var ex__2417__auto__ = e19801;
var statearr_19802_19810 = state_19786;
(statearr_19802_19810[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19786[(4)]))){
var statearr_19803_19811 = state_19786;
(statearr_19803_19811[(1)] = cljs.core.first((state_19786[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19812 = state_19786;
state_19786 = G__19812;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__ = function(state_19786){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1.call(this,state_19786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19804 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19804[(6)] = c__2436__auto__);

return statearr_19804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19829){
var state_val_19830 = (state_19829[(1)]);
if((state_val_19830 === (1))){
var state_19829__$1 = state_19829;
var statearr_19831_19846 = state_19829__$1;
(statearr_19831_19846[(2)] = null);

(statearr_19831_19846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19830 === (2))){
var _ = (function (){var statearr_19832 = state_19829;
(statearr_19832[(4)] = cljs.core.cons((5),(state_19829[(4)])));

return statearr_19832;
})();
var inst_19819 = fluree.db.storage.core.serde(conn);
var inst_19820 = fluree.db.serde.protocol._serialize_branch(inst_19819,data);
var inst_19821 = fluree.db.storage.core.storage_write(conn,key,inst_19820);
var state_19829__$1 = state_19829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19829__$1,(6),inst_19821);
} else {
if((state_val_19830 === (3))){
var inst_19827 = (state_19829[(2)]);
var state_19829__$1 = state_19829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19829__$1,inst_19827);
} else {
if((state_val_19830 === (4))){
var inst_19813 = (state_19829[(2)]);
var state_19829__$1 = state_19829;
var statearr_19834_19847 = state_19829__$1;
(statearr_19834_19847[(2)] = inst_19813);

(statearr_19834_19847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19830 === (5))){
var _ = (function (){var statearr_19835 = state_19829;
(statearr_19835[(4)] = cljs.core.rest((state_19829[(4)])));

return statearr_19835;
})();
var state_19829__$1 = state_19829;
var ex19833 = (state_19829__$1[(2)]);
var statearr_19836_19848 = state_19829__$1;
(statearr_19836_19848[(5)] = ex19833);


if((ex19833 instanceof Error)){
var statearr_19837_19849 = state_19829__$1;
(statearr_19837_19849[(1)] = (4));

(statearr_19837_19849[(5)] = null);

} else {
throw ex19833;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19830 === (6))){
var inst_19823 = (state_19829[(2)]);
var inst_19824 = fluree.db.util.async.throw_err(inst_19823);
var _ = (function (){var statearr_19838 = state_19829;
(statearr_19838[(4)] = cljs.core.rest((state_19829[(4)])));

return statearr_19838;
})();
var state_19829__$1 = (function (){var statearr_19839 = state_19829;
(statearr_19839[(7)] = inst_19824);

return statearr_19839;
})();
var statearr_19840_19850 = state_19829__$1;
(statearr_19840_19850[(2)] = key);

(statearr_19840_19850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0 = (function (){
var statearr_19841 = [null,null,null,null,null,null,null,null];
(statearr_19841[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__);

(statearr_19841[(1)] = (1));

return statearr_19841;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1 = (function (state_19829){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19829);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19842){var ex__2417__auto__ = e19842;
var statearr_19843_19851 = state_19829;
(statearr_19843_19851[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19829[(4)]))){
var statearr_19844_19852 = state_19829;
(statearr_19844_19852[(1)] = cljs.core.first((state_19829[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19853 = state_19829;
state_19829 = G__19853;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__ = function(state_19829){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1.call(this,state_19829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19845 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19845[(6)] = c__2436__auto__);

return statearr_19845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19854_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__19854_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__19855){
var map__19856 = p__19855;
var map__19856__$1 = (((((!((map__19856 == null))))?(((((map__19856.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19856.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19856):map__19856);
var progress = map__19856__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19856__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19905){
var state_val_19906 = (state_19905[(1)]);
if((state_val_19906 === (7))){
var state_19905__$1 = state_19905;
var statearr_19907_19936 = state_19905__$1;
(statearr_19907_19936[(2)] = false);

(statearr_19907_19936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (1))){
var state_19905__$1 = state_19905;
var statearr_19908_19937 = state_19905__$1;
(statearr_19908_19937[(2)] = null);

(statearr_19908_19937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (4))){
var inst_19858 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
var statearr_19909_19938 = state_19905__$1;
(statearr_19909_19938[(2)] = inst_19858);

(statearr_19909_19938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (15))){
var inst_19891 = (state_19905[(7)]);
var inst_19899 = (state_19905[(2)]);
var inst_19900 = fluree.db.util.async.throw_err(inst_19899);
var _ = (function (){var statearr_19910 = state_19905;
(statearr_19910[(4)] = cljs.core.rest((state_19905[(4)])));

return statearr_19910;
})();
var state_19905__$1 = (function (){var statearr_19911 = state_19905;
(statearr_19911[(8)] = inst_19900);

return statearr_19911;
})();
var statearr_19912_19939 = state_19905__$1;
(statearr_19912_19939[(2)] = inst_19891);

(statearr_19912_19939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (13))){
var inst_19865 = (state_19905[(9)]);
var state_19905__$1 = state_19905;
var statearr_19913_19940 = state_19905__$1;
(statearr_19913_19940[(2)] = inst_19865);

(statearr_19913_19940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (6))){
var inst_19865 = (state_19905[(9)]);
var inst_19870 = inst_19865.cljs$lang$protocol_mask$partition0$;
var inst_19871 = (inst_19870 & (64));
var inst_19872 = inst_19865.cljs$core$ISeq$;
var inst_19873 = (cljs.core.PROTOCOL_SENTINEL === inst_19872);
var inst_19874 = ((inst_19871) || (inst_19873));
var state_19905__$1 = state_19905;
if(cljs.core.truth_(inst_19874)){
var statearr_19914_19941 = state_19905__$1;
(statearr_19914_19941[(1)] = (9));

} else {
var statearr_19915_19942 = state_19905__$1;
(statearr_19915_19942[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (3))){
var inst_19903 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19905__$1,inst_19903);
} else {
if((state_val_19906 === (12))){
var inst_19865 = (state_19905[(9)]);
var inst_19883 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19865);
var state_19905__$1 = state_19905;
var statearr_19916_19943 = state_19905__$1;
(statearr_19916_19943[(2)] = inst_19883);

(statearr_19916_19943[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (2))){
var inst_19865 = (state_19905[(9)]);
var _ = (function (){var statearr_19917 = state_19905;
(statearr_19917[(4)] = cljs.core.cons((5),(state_19905[(4)])));

return statearr_19917;
})();
var inst_19865__$1 = db;
var inst_19867 = (inst_19865__$1 == null);
var inst_19868 = cljs.core.not(inst_19867);
var state_19905__$1 = (function (){var statearr_19918 = state_19905;
(statearr_19918[(9)] = inst_19865__$1);

return statearr_19918;
})();
if(inst_19868){
var statearr_19919_19944 = state_19905__$1;
(statearr_19919_19944[(1)] = (6));

} else {
var statearr_19920_19945 = state_19905__$1;
(statearr_19920_19945[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (11))){
var inst_19878 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
var statearr_19922_19946 = state_19905__$1;
(statearr_19922_19946[(2)] = inst_19878);

(statearr_19922_19946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (9))){
var state_19905__$1 = state_19905;
var statearr_19923_19947 = state_19905__$1;
(statearr_19923_19947[(2)] = true);

(statearr_19923_19947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (5))){
var _ = (function (){var statearr_19924 = state_19905;
(statearr_19924[(4)] = cljs.core.rest((state_19905[(4)])));

return statearr_19924;
})();
var state_19905__$1 = state_19905;
var ex19921 = (state_19905__$1[(2)]);
var statearr_19925_19948 = state_19905__$1;
(statearr_19925_19948[(5)] = ex19921);


if((ex19921 instanceof Error)){
var statearr_19926_19949 = state_19905__$1;
(statearr_19926_19949[(1)] = (4));

(statearr_19926_19949[(5)] = null);

} else {
throw ex19921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (14))){
var inst_19891 = (state_19905[(7)]);
var inst_19886 = (state_19905[(2)]);
var inst_19887 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19886,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19888 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19886,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19886,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19886,new cljs.core.Keyword(null,"block","block",664686210));
var inst_19891__$1 = fluree.db.storage.core.ledger_garbage_key(inst_19888,inst_19889,inst_19890);
var inst_19892 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_19893 = [inst_19889,inst_19890,garbage];
var inst_19894 = cljs.core.PersistentHashMap.fromArrays(inst_19892,inst_19893);
var inst_19895 = fluree.db.storage.core.serde(inst_19887);
var inst_19896 = fluree.db.serde.protocol._serialize_garbage(inst_19895,inst_19894);
var inst_19897 = fluree.db.storage.core.storage_write(inst_19887,inst_19891__$1,inst_19896);
var state_19905__$1 = (function (){var statearr_19927 = state_19905;
(statearr_19927[(7)] = inst_19891__$1);

return statearr_19927;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19905__$1,(15),inst_19897);
} else {
if((state_val_19906 === (10))){
var state_19905__$1 = state_19905;
var statearr_19928_19950 = state_19905__$1;
(statearr_19928_19950[(2)] = false);

(statearr_19928_19950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (8))){
var inst_19881 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
if(cljs.core.truth_(inst_19881)){
var statearr_19929_19951 = state_19905__$1;
(statearr_19929_19951[(1)] = (12));

} else {
var statearr_19930_19952 = state_19905__$1;
(statearr_19930_19952[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0 = (function (){
var statearr_19931 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19931[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__);

(statearr_19931[(1)] = (1));

return statearr_19931;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1 = (function (state_19905){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19905);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19932){var ex__2417__auto__ = e19932;
var statearr_19933_19953 = state_19905;
(statearr_19933_19953[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19905[(4)]))){
var statearr_19934_19954 = state_19905;
(statearr_19934_19954[(1)] = cljs.core.first((state_19905[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19955 = state_19905;
state_19905 = G__19955;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__ = function(state_19905){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1.call(this,state_19905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19935 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19935[(6)] = c__2436__auto__);

return statearr_19935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__19957 = arguments.length;
switch (G__19957) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20033){
var state_val_20034 = (state_20033[(1)]);
if((state_val_20034 === (7))){
var state_20033__$1 = state_20033;
var statearr_20035_20074 = state_20033__$1;
(statearr_20035_20074[(2)] = false);

(statearr_20035_20074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (20))){
var inst_19999 = (state_20033[(7)]);
var inst_19991 = (state_20033[(8)]);
var inst_19998 = (state_20033[(9)]);
var inst_19989 = (state_20033[(10)]);
var inst_19990 = (state_20033[(11)]);
var inst_20001 = (state_20033[(12)]);
var inst_20007 = (state_20033[(13)]);
var inst_19992 = (state_20033[(14)]);
var inst_19995 = (state_20033[(15)]);
var inst_20002 = (state_20033[(16)]);
var inst_19988 = (state_20033[(17)]);
var inst_20000 = (state_20033[(18)]);
var inst_19997 = (state_20033[(19)]);
var inst_19993 = (state_20033[(20)]);
var inst_20012 = (state_20033[(2)]);
var inst_20013 = fluree.db.storage.core.child_data(inst_19997);
var inst_20014 = fluree.db.storage.core.child_data(inst_19999);
var inst_20015 = fluree.db.util.core.current_time_millis();
var inst_20016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20017 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_20018 = (new cljs.core.PersistentVector(null,2,(5),inst_20016,inst_20017,null));
var inst_20019 = cljs.core.select_keys(inst_19991,inst_20018);
var inst_20020 = fluree.db.storage.core.child_data(inst_19990);
var inst_20021 = [inst_19993,inst_20002,inst_19995,inst_20007,inst_20012,inst_20013,inst_20014,inst_19988,inst_20015,inst_19989,inst_19998,inst_20019,inst_20020];
var inst_20022 = cljs.core.PersistentHashMap.fromArrays(inst_20001,inst_20021);
var inst_20023 = fluree.db.storage.core.serde(inst_19992);
var inst_20024 = fluree.db.serde.protocol._serialize_db_root(inst_20023,inst_20022);
var inst_20025 = fluree.db.storage.core.storage_write(inst_19992,inst_20000,inst_20024);
var state_20033__$1 = state_20033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20033__$1,(21),inst_20025);
} else {
if((state_val_20034 === (1))){
var state_20033__$1 = state_20033;
var statearr_20036_20075 = state_20033__$1;
(statearr_20036_20075[(2)] = null);

(statearr_20036_20075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (4))){
var inst_19958 = (state_20033[(2)]);
var state_20033__$1 = state_20033;
var statearr_20037_20076 = state_20033__$1;
(statearr_20037_20076[(2)] = inst_19958);

(statearr_20037_20076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (15))){
var inst_20003 = (state_20033[(21)]);
var state_20033__$1 = state_20033;
var statearr_20038_20077 = state_20033__$1;
(statearr_20038_20077[(2)] = inst_20003);

(statearr_20038_20077[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (21))){
var inst_20000 = (state_20033[(18)]);
var inst_20027 = (state_20033[(2)]);
var inst_20028 = fluree.db.util.async.throw_err(inst_20027);
var _ = (function (){var statearr_20039 = state_20033;
(statearr_20039[(4)] = cljs.core.rest((state_20033[(4)])));

return statearr_20039;
})();
var state_20033__$1 = (function (){var statearr_20040 = state_20033;
(statearr_20040[(22)] = inst_20028);

return statearr_20040;
})();
var statearr_20041_20078 = state_20033__$1;
(statearr_20041_20078[(2)] = inst_20000);

(statearr_20041_20078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (13))){
var inst_19965 = (state_20033[(23)]);
var state_20033__$1 = state_20033;
var statearr_20042_20079 = state_20033__$1;
(statearr_20042_20079[(2)] = inst_19965);

(statearr_20042_20079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (6))){
var inst_19965 = (state_20033[(23)]);
var inst_19970 = inst_19965.cljs$lang$protocol_mask$partition0$;
var inst_19971 = (inst_19970 & (64));
var inst_19972 = inst_19965.cljs$core$ISeq$;
var inst_19973 = (cljs.core.PROTOCOL_SENTINEL === inst_19972);
var inst_19974 = ((inst_19971) || (inst_19973));
var state_20033__$1 = state_20033;
if(cljs.core.truth_(inst_19974)){
var statearr_20043_20080 = state_20033__$1;
(statearr_20043_20080[(1)] = (9));

} else {
var statearr_20044_20081 = state_20033__$1;
(statearr_20044_20081[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (17))){
var inst_20008 = (state_20033[(24)]);
var inst_20007 = (state_20033[(2)]);
var inst_20008__$1 = custom_ecount;
var state_20033__$1 = (function (){var statearr_20045 = state_20033;
(statearr_20045[(13)] = inst_20007);

(statearr_20045[(24)] = inst_20008__$1);

return statearr_20045;
})();
if(cljs.core.truth_(inst_20008__$1)){
var statearr_20046_20082 = state_20033__$1;
(statearr_20046_20082[(1)] = (18));

} else {
var statearr_20047_20083 = state_20033__$1;
(statearr_20047_20083[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (3))){
var inst_20031 = (state_20033[(2)]);
var state_20033__$1 = state_20033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20033__$1,inst_20031);
} else {
if((state_val_20034 === (12))){
var inst_19965 = (state_20033[(23)]);
var inst_19983 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19965);
var state_20033__$1 = state_20033;
var statearr_20048_20084 = state_20033__$1;
(statearr_20048_20084[(2)] = inst_19983);

(statearr_20048_20084[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (2))){
var inst_19965 = (state_20033[(23)]);
var _ = (function (){var statearr_20049 = state_20033;
(statearr_20049[(4)] = cljs.core.cons((5),(state_20033[(4)])));

return statearr_20049;
})();
var inst_19965__$1 = db;
var inst_19967 = (inst_19965__$1 == null);
var inst_19968 = cljs.core.not(inst_19967);
var state_20033__$1 = (function (){var statearr_20050 = state_20033;
(statearr_20050[(23)] = inst_19965__$1);

return statearr_20050;
})();
if(inst_19968){
var statearr_20051_20085 = state_20033__$1;
(statearr_20051_20085[(1)] = (6));

} else {
var statearr_20052_20086 = state_20033__$1;
(statearr_20052_20086[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (19))){
var inst_19996 = (state_20033[(25)]);
var state_20033__$1 = state_20033;
var statearr_20053_20087 = state_20033__$1;
(statearr_20053_20087[(2)] = inst_19996);

(statearr_20053_20087[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (11))){
var inst_19978 = (state_20033[(2)]);
var state_20033__$1 = state_20033;
var statearr_20055_20088 = state_20033__$1;
(statearr_20055_20088[(2)] = inst_19978);

(statearr_20055_20088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (9))){
var state_20033__$1 = state_20033;
var statearr_20056_20089 = state_20033__$1;
(statearr_20056_20089[(2)] = true);

(statearr_20056_20089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (5))){
var _ = (function (){var statearr_20057 = state_20033;
(statearr_20057[(4)] = cljs.core.rest((state_20033[(4)])));

return statearr_20057;
})();
var state_20033__$1 = state_20033;
var ex20054 = (state_20033__$1[(2)]);
var statearr_20058_20090 = state_20033__$1;
(statearr_20058_20090[(5)] = ex20054);


if((ex20054 instanceof Error)){
var statearr_20059_20091 = state_20033__$1;
(statearr_20059_20091[(1)] = (4));

(statearr_20059_20091[(5)] = null);

} else {
throw ex20054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (14))){
var inst_19991 = (state_20033[(8)]);
var inst_20003 = (state_20033[(21)]);
var inst_19995 = (state_20033[(15)]);
var inst_19993 = (state_20033[(20)]);
var inst_19986 = (state_20033[(2)]);
var inst_19987 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_19989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_19990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_19991__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_19992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19993__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"block","block",664686210));
var inst_19994 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_19995__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_19997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_19998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_19999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19986,new cljs.core.Keyword(null,"post","post",269697687));
var inst_20000 = fluree.db.storage.core.ledger_root_key(inst_19987,inst_19995__$1,inst_19993__$1);
var inst_20001 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_20002 = fluree.db.storage.core.child_data(inst_19994);
var inst_20003__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_19991__$1);
var state_20033__$1 = (function (){var statearr_20060 = state_20033;
(statearr_20060[(7)] = inst_19999);

(statearr_20060[(8)] = inst_19991__$1);

(statearr_20060[(9)] = inst_19998);

(statearr_20060[(10)] = inst_19989);

(statearr_20060[(11)] = inst_19990);

(statearr_20060[(12)] = inst_20001);

(statearr_20060[(25)] = inst_19996);

(statearr_20060[(14)] = inst_19992);

(statearr_20060[(21)] = inst_20003__$1);

(statearr_20060[(15)] = inst_19995__$1);

(statearr_20060[(16)] = inst_20002);

(statearr_20060[(17)] = inst_19988);

(statearr_20060[(18)] = inst_20000);

(statearr_20060[(19)] = inst_19997);

(statearr_20060[(20)] = inst_19993__$1);

return statearr_20060;
})();
if(cljs.core.truth_(inst_20003__$1)){
var statearr_20061_20092 = state_20033__$1;
(statearr_20061_20092[(1)] = (15));

} else {
var statearr_20062_20093 = state_20033__$1;
(statearr_20062_20093[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (16))){
var state_20033__$1 = state_20033;
var statearr_20063_20094 = state_20033__$1;
(statearr_20063_20094[(2)] = (0));

(statearr_20063_20094[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (10))){
var state_20033__$1 = state_20033;
var statearr_20064_20095 = state_20033__$1;
(statearr_20064_20095[(2)] = false);

(statearr_20064_20095[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (18))){
var inst_20008 = (state_20033[(24)]);
var state_20033__$1 = state_20033;
var statearr_20065_20096 = state_20033__$1;
(statearr_20065_20096[(2)] = inst_20008);

(statearr_20065_20096[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20034 === (8))){
var inst_19981 = (state_20033[(2)]);
var state_20033__$1 = state_20033;
if(cljs.core.truth_(inst_19981)){
var statearr_20066_20097 = state_20033__$1;
(statearr_20066_20097[(1)] = (12));

} else {
var statearr_20067_20098 = state_20033__$1;
(statearr_20067_20098[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2414__auto__ = null;
var fluree$db$storage$core$state_machine__2414__auto____0 = (function (){
var statearr_20068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20068[(0)] = fluree$db$storage$core$state_machine__2414__auto__);

(statearr_20068[(1)] = (1));

return statearr_20068;
});
var fluree$db$storage$core$state_machine__2414__auto____1 = (function (state_20033){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20033);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20069){var ex__2417__auto__ = e20069;
var statearr_20070_20099 = state_20033;
(statearr_20070_20099[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20033[(4)]))){
var statearr_20071_20100 = state_20033;
(statearr_20071_20100[(1)] = cljs.core.first((state_20033[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20101 = state_20033;
state_20033 = G__20101;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2414__auto__ = function(state_20033){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2414__auto____1.call(this,state_20033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2414__auto____0;
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2414__auto____1;
return fluree$db$storage$core$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20072 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20072[(6)] = c__2436__auto__);

return statearr_20072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___20153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20131){
var state_val_20132 = (state_20131[(1)]);
if((state_val_20132 === (7))){
var inst_20118 = cljs.core.async.close_BANG_(return_ch);
var state_20131__$1 = state_20131;
var statearr_20133_20154 = state_20131__$1;
(statearr_20133_20154[(2)] = inst_20118);

(statearr_20133_20154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (1))){
var state_20131__$1 = state_20131;
var statearr_20134_20155 = state_20131__$1;
(statearr_20134_20155[(2)] = null);

(statearr_20134_20155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (4))){
var inst_20102 = (state_20131[(2)]);
var inst_20103 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20104 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20102);
var inst_20105 = cljs.core.async.close_BANG_(return_ch);
var state_20131__$1 = (function (){var statearr_20135 = state_20131;
(statearr_20135[(7)] = inst_20104);

(statearr_20135[(8)] = inst_20103);

return statearr_20135;
})();
var statearr_20136_20156 = state_20131__$1;
(statearr_20136_20156[(2)] = inst_20105);

(statearr_20136_20156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (6))){
var inst_20113 = (state_20131[(9)]);
var inst_20113__$1 = (state_20131[(2)]);
var inst_20114 = (inst_20113__$1 == null);
var inst_20115 = (inst_20113__$1 instanceof Error);
var inst_20116 = ((inst_20114) || (inst_20115));
var state_20131__$1 = (function (){var statearr_20137 = state_20131;
(statearr_20137[(9)] = inst_20113__$1);

return statearr_20137;
})();
if(cljs.core.truth_(inst_20116)){
var statearr_20138_20157 = state_20131__$1;
(statearr_20138_20157[(1)] = (7));

} else {
var statearr_20139_20158 = state_20131__$1;
(statearr_20139_20158[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (3))){
var inst_20129 = (state_20131[(2)]);
var state_20131__$1 = state_20131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20131__$1,inst_20129);
} else {
if((state_val_20132 === (2))){
var _ = (function (){var statearr_20141 = state_20131;
(statearr_20141[(4)] = cljs.core.cons((5),(state_20131[(4)])));

return statearr_20141;
})();
var inst_20111 = fluree.db.storage.core.storage_read(conn,key);
var state_20131__$1 = state_20131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20131__$1,(6),inst_20111);
} else {
if((state_val_20132 === (9))){
var inst_20126 = (state_20131[(2)]);
var _ = (function (){var statearr_20142 = state_20131;
(statearr_20142[(4)] = cljs.core.rest((state_20131[(4)])));

return statearr_20142;
})();
var state_20131__$1 = state_20131;
var statearr_20143_20159 = state_20131__$1;
(statearr_20143_20159[(2)] = inst_20126);

(statearr_20143_20159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (5))){
var _ = (function (){var statearr_20144 = state_20131;
(statearr_20144[(4)] = cljs.core.rest((state_20131[(4)])));

return statearr_20144;
})();
var state_20131__$1 = state_20131;
var ex20140 = (state_20131__$1[(2)]);
var statearr_20145_20160 = state_20131__$1;
(statearr_20145_20160[(5)] = ex20140);


var statearr_20146_20161 = state_20131__$1;
(statearr_20146_20161[(1)] = (4));

(statearr_20146_20161[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (8))){
var inst_20113 = (state_20131[(9)]);
var inst_20120 = fluree.db.storage.core.serde(conn);
var inst_20121 = fluree.db.serde.protocol._deserialize_leaf(inst_20120,inst_20113);
var inst_20122 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20121);
var inst_20123 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_20122);
var inst_20124 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20123);
var state_20131__$1 = state_20131;
var statearr_20147_20162 = state_20131__$1;
(statearr_20147_20162[(2)] = inst_20124);

(statearr_20147_20162[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0 = (function (){
var statearr_20148 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20148[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2414__auto__);

(statearr_20148[(1)] = (1));

return statearr_20148;
});
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1 = (function (state_20131){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20131);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20149){var ex__2417__auto__ = e20149;
var statearr_20150_20163 = state_20131;
(statearr_20150_20163[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20131[(4)]))){
var statearr_20151_20164 = state_20131;
(statearr_20151_20164[(1)] = cljs.core.first((state_20131[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20165 = state_20131;
state_20131 = G__20165;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__ = function(state_20131){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1.call(this,state_20131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20152 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20152[(6)] = c__2436__auto___20153);

return statearr_20152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__20167 = arguments.length;
switch (G__20167) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___20279 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20230){
var state_val_20231 = (state_20230[(1)]);
if((state_val_20231 === (7))){
var state_20230__$1 = state_20230;
var statearr_20232_20280 = state_20230__$1;
(statearr_20232_20280[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_20232_20280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (20))){
var inst_20209 = cljs.core.PersistentVector.EMPTY;
var state_20230__$1 = state_20230;
var statearr_20233_20281 = state_20230__$1;
(statearr_20233_20281[(2)] = inst_20209);

(statearr_20233_20281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (1))){
var state_20230__$1 = state_20230;
var statearr_20234_20282 = state_20230__$1;
(statearr_20234_20282[(2)] = null);

(statearr_20234_20282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (24))){
var state_20230__$1 = state_20230;
var statearr_20235_20283 = state_20230__$1;
(statearr_20235_20283[(2)] = null);

(statearr_20235_20283[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (4))){
var inst_20170 = (state_20230[(2)]);
var inst_20171 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20172 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_20170);
var inst_20173 = cljs.core.async.close_BANG_(result_ch);
var state_20230__$1 = (function (){var statearr_20236 = state_20230;
(statearr_20236[(7)] = inst_20171);

(statearr_20236[(8)] = inst_20172);

return statearr_20236;
})();
var statearr_20237_20284 = state_20230__$1;
(statearr_20237_20284[(2)] = inst_20173);

(statearr_20237_20284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (15))){
var inst_20195 = (state_20230[(2)]);
var state_20230__$1 = state_20230;
var statearr_20238_20285 = state_20230__$1;
(statearr_20238_20285[(2)] = inst_20195);

(statearr_20238_20285[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (21))){
var inst_20182 = (state_20230[(9)]);
var inst_20183 = (state_20230[(10)]);
var inst_20199 = (state_20230[(11)]);
var inst_20212 = (state_20230[(12)]);
var inst_20184 = (state_20230[(13)]);
var inst_20219 = (state_20230[(2)]);
var inst_20220 = (function (){var base_node = inst_20182;
var first_flake = inst_20183;
var node_t = inst_20184;
var source = inst_20199;
var coll = inst_20212;
var conj_QMARK_ = inst_20219;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__20240 = f.p;
var fexpr__20239 = (function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__20239.cljs$core$IFn$_invoke$arity$1 ? fexpr__20239.cljs$core$IFn$_invoke$arity$1(G__20240) : fexpr__20239.call(null,G__20240));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_20221 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20182);
var inst_20222 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20220,inst_20221,inst_20212);
var inst_20223 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_20222);
var inst_20224 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20182,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_20223);
var inst_20225 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_20224);
var _ = (function (){var statearr_20241 = state_20230;
(statearr_20241[(4)] = cljs.core.rest((state_20230[(4)])));

return statearr_20241;
})();
var state_20230__$1 = state_20230;
var statearr_20242_20286 = state_20230__$1;
(statearr_20242_20286[(2)] = inst_20225);

(statearr_20242_20286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (13))){
var state_20230__$1 = state_20230;
var statearr_20243_20287 = state_20230__$1;
(statearr_20243_20287[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_20243_20287[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (22))){
var inst_20182 = (state_20230[(9)]);
var inst_20183 = (state_20230[(10)]);
var inst_20199 = (state_20230[(11)]);
var inst_20212 = (state_20230[(12)]);
var inst_20184 = (state_20230[(13)]);
var inst_20213 = (function (){var base_node = inst_20182;
var first_flake = inst_20183;
var node_t = inst_20184;
var source = inst_20199;
var coll = inst_20212;
return (function (f){
return f.op === true;
});
})();
var state_20230__$1 = state_20230;
var statearr_20244_20288 = state_20230__$1;
(statearr_20244_20288[(2)] = inst_20213);

(statearr_20244_20288[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (6))){
var inst_20182 = (state_20230[(9)]);
var inst_20184 = (state_20230[(13)]);
var inst_20181 = (state_20230[(2)]);
var inst_20182__$1 = fluree.db.util.async.throw_err(inst_20181);
var inst_20183 = fluree.db.dbproto._first_flake(inst_20182__$1);
var inst_20184__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_20182__$1);
var inst_20185 = (inst_20184__$1 > t);
var state_20230__$1 = (function (){var statearr_20245 = state_20230;
(statearr_20245[(9)] = inst_20182__$1);

(statearr_20245[(10)] = inst_20183);

(statearr_20245[(13)] = inst_20184__$1);

return statearr_20245;
})();
if(cljs.core.truth_(inst_20185)){
var statearr_20246_20289 = state_20230__$1;
(statearr_20246_20289[(1)] = (7));

} else {
var statearr_20247_20290 = state_20230__$1;
(statearr_20247_20290[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (17))){
var inst_20183 = (state_20230[(10)]);
var inst_20200 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_20183,rhs,leftmost_QMARK_,t);
var state_20230__$1 = state_20230;
var statearr_20248_20291 = state_20230__$1;
(statearr_20248_20291[(2)] = inst_20200);

(statearr_20248_20291[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (3))){
var inst_20228 = (state_20230[(2)]);
var state_20230__$1 = state_20230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20230__$1,inst_20228);
} else {
if((state_val_20231 === (12))){
var inst_20197 = (state_20230[(2)]);
var state_20230__$1 = state_20230;
var statearr_20249_20292 = state_20230__$1;
(statearr_20249_20292[(2)] = inst_20197);

(statearr_20249_20292[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (2))){
var _ = (function (){var statearr_20250 = state_20230;
(statearr_20250[(4)] = cljs.core.cons((5),(state_20230[(4)])));

return statearr_20250;
})();
var inst_20179 = fluree.db.dbproto._resolve(node);
var state_20230__$1 = state_20230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20230__$1,(6),inst_20179);
} else {
if((state_val_20231 === (23))){
var inst_20182 = (state_20230[(9)]);
var inst_20183 = (state_20230[(10)]);
var inst_20199 = (state_20230[(11)]);
var inst_20212 = (state_20230[(12)]);
var inst_20184 = (state_20230[(13)]);
var inst_20215 = (function (){var base_node = inst_20182;
var first_flake = inst_20183;
var node_t = inst_20184;
var source = inst_20199;
var coll = inst_20212;
return (function (f){
return f.op === false;
});
})();
var state_20230__$1 = state_20230;
var statearr_20251_20293 = state_20230__$1;
(statearr_20251_20293[(2)] = inst_20215);

(statearr_20251_20293[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (19))){
var inst_20202 = (state_20230[(14)]);
var inst_20205 = (state_20230[(2)]);
var inst_20206 = fluree.db.util.async.throw_err(inst_20205);
var inst_20207 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_20202,inst_20206);
var state_20230__$1 = state_20230;
var statearr_20252_20294 = state_20230__$1;
(statearr_20252_20294[(2)] = inst_20207);

(statearr_20252_20294[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (11))){
var inst_20184 = (state_20230[(13)]);
var inst_20191 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20184,t);
var state_20230__$1 = state_20230;
if(inst_20191){
var statearr_20254_20295 = state_20230__$1;
(statearr_20254_20295[(1)] = (13));

} else {
var statearr_20255_20296 = state_20230__$1;
(statearr_20255_20296[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (9))){
var inst_20199 = (state_20230[(11)]);
var inst_20199__$1 = (state_20230[(2)]);
var state_20230__$1 = (function (){var statearr_20256 = state_20230;
(statearr_20256[(11)] = inst_20199__$1);

return statearr_20256;
})();
var G__20257_20297 = inst_20199__$1;
var G__20257_20298__$1 = (((G__20257_20297 instanceof cljs.core.Keyword))?G__20257_20297.fqn:null);
switch (G__20257_20298__$1) {
case "novelty":
var statearr_20258_20300 = state_20230__$1;
(statearr_20258_20300[(1)] = (17));


break;
case "history":
var statearr_20259_20301 = state_20230__$1;
(statearr_20259_20301[(1)] = (18));


break;
case "none":
var statearr_20260_20302 = state_20230__$1;
(statearr_20260_20302[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20257_20298__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (5))){
var _ = (function (){var statearr_20261 = state_20230;
(statearr_20261[(4)] = cljs.core.rest((state_20230[(4)])));

return statearr_20261;
})();
var state_20230__$1 = state_20230;
var ex20253 = (state_20230__$1[(2)]);
var statearr_20262_20303 = state_20230__$1;
(statearr_20262_20303[(5)] = ex20253);


var statearr_20263_20304 = state_20230__$1;
(statearr_20263_20304[(1)] = (4));

(statearr_20263_20304[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (14))){
var state_20230__$1 = state_20230;
var statearr_20264_20305 = state_20230__$1;
(statearr_20264_20305[(2)] = null);

(statearr_20264_20305[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (16))){
var inst_20199 = (state_20230[(11)]);
var inst_20212 = (state_20230[(2)]);
var state_20230__$1 = (function (){var statearr_20265 = state_20230;
(statearr_20265[(12)] = inst_20212);

return statearr_20265;
})();
var G__20266_20306 = inst_20199;
var G__20266_20307__$1 = (((G__20266_20306 instanceof cljs.core.Keyword))?G__20266_20306.fqn:null);
switch (G__20266_20307__$1) {
case "novelty":
var statearr_20267_20309 = state_20230__$1;
(statearr_20267_20309[(1)] = (22));


break;
case "history":
var statearr_20268_20310 = state_20230__$1;
(statearr_20268_20310[(1)] = (23));


break;
case "none":
var statearr_20269_20311 = state_20230__$1;
(statearr_20269_20311[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20266_20307__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (10))){
var state_20230__$1 = state_20230;
var statearr_20270_20312 = state_20230__$1;
(statearr_20270_20312[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_20270_20312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20231 === (18))){
var inst_20182 = (state_20230[(9)]);
var inst_20183 = (state_20230[(10)]);
var inst_20199 = (state_20230[(11)]);
var inst_20184 = (state_20230[(13)]);
var inst_20202 = (function (){var base_node = inst_20182;
var first_flake = inst_20183;
var node_t = inst_20184;
var source = inst_20199;
return (function (p1__20169_SHARP_){
return (p1__20169_SHARP_.t <= t);
});
})();
var inst_20203 = fluree.db.dbproto._resolve_history(node);
var state_20230__$1 = (function (){var statearr_20271 = state_20230;
(statearr_20271[(14)] = inst_20202);

return statearr_20271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20230__$1,(19),inst_20203);
} else {
if((state_val_20231 === (8))){
var inst_20184 = (state_20230[(13)]);
var inst_20188 = (inst_20184 < t);
var state_20230__$1 = state_20230;
if(cljs.core.truth_(inst_20188)){
var statearr_20272_20313 = state_20230__$1;
(statearr_20272_20313[(1)] = (10));

} else {
var statearr_20273_20314 = state_20230__$1;
(statearr_20273_20314[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0 = (function (){
var statearr_20274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20274[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__);

(statearr_20274[(1)] = (1));

return statearr_20274;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1 = (function (state_20230){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20230);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20275){var ex__2417__auto__ = e20275;
var statearr_20276_20315 = state_20230;
(statearr_20276_20315[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20230[(4)]))){
var statearr_20277_20316 = state_20230;
(statearr_20277_20316[(1)] = cljs.core.first((state_20230[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20317 = state_20230;
state_20230 = G__20317;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__ = function(state_20230){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1.call(this,state_20230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20278 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20278[(6)] = c__2436__auto___20279);

return statearr_20278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20374){
var state_val_20375 = (state_20374[(1)]);
if((state_val_20375 === (7))){
var state_20374__$1 = state_20374;
var statearr_20376_20412 = state_20374__$1;
(statearr_20376_20412[(2)] = null);

(statearr_20376_20412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (1))){
var state_20374__$1 = state_20374;
var statearr_20377_20413 = state_20374__$1;
(statearr_20377_20413[(2)] = null);

(statearr_20377_20413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (4))){
var inst_20320 = (state_20374[(2)]);
var inst_20321 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20320], 0));
var inst_20322 = (function(){throw inst_20320})();
var state_20374__$1 = (function (){var statearr_20378 = state_20374;
(statearr_20378[(7)] = inst_20321);

return statearr_20378;
})();
var statearr_20379_20414 = state_20374__$1;
(statearr_20379_20414[(2)] = inst_20322);

(statearr_20379_20414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (15))){
var inst_20350 = (state_20374[(2)]);
var state_20374__$1 = state_20374;
var statearr_20380_20415 = state_20374__$1;
(statearr_20380_20415[(2)] = inst_20350);

(statearr_20380_20415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (13))){
var inst_20328 = (state_20374[(8)]);
var inst_20344 = (state_20374[(9)]);
var inst_20346 = (function (){var node_t = inst_20328;
var G__20333 = inst_20344;
return (function (p1__20319_SHARP_){
return (p1__20319_SHARP_.t <= from_t);
});
})();
var inst_20347 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_20346,inst_20344);
var state_20374__$1 = state_20374;
var statearr_20381_20416 = state_20374__$1;
(statearr_20381_20416[(2)] = inst_20347);

(statearr_20381_20416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (6))){
var inst_20334 = fluree.db.dbproto._resolve_history(node);
var state_20374__$1 = state_20374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20374__$1,(9),inst_20334);
} else {
if((state_val_20375 === (17))){
var inst_20359 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_20360 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20359)].join('');
var inst_20361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20362 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_20363 = cljs.core.PersistentHashMap.fromArrays(inst_20361,inst_20362);
var inst_20364 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20360,inst_20363);
var inst_20365 = (function(){throw inst_20364})();
var state_20374__$1 = state_20374;
var statearr_20382_20417 = state_20374__$1;
(statearr_20382_20417[(2)] = inst_20365);

(statearr_20382_20417[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (3))){
var inst_20372 = (state_20374[(2)]);
var state_20374__$1 = state_20374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20374__$1,inst_20372);
} else {
if((state_val_20375 === (12))){
var inst_20344 = (state_20374[(2)]);
var state_20374__$1 = (function (){var statearr_20383 = state_20374;
(statearr_20383[(9)] = inst_20344);

return statearr_20383;
})();
if(cljs.core.truth_(from_t)){
var statearr_20384_20418 = state_20374__$1;
(statearr_20384_20418[(1)] = (13));

} else {
var statearr_20385_20419 = state_20374__$1;
(statearr_20385_20419[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (2))){
var inst_20328 = (state_20374[(8)]);
var _ = (function (){var statearr_20386 = state_20374;
(statearr_20386[(4)] = cljs.core.cons((5),(state_20374[(4)])));

return statearr_20386;
})();
var inst_20328__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_20329 = (from_t == null);
var inst_20330 = (inst_20328__$1 <= from_t);
var inst_20331 = ((inst_20329) || (inst_20330));
var state_20374__$1 = (function (){var statearr_20387 = state_20374;
(statearr_20387[(8)] = inst_20328__$1);

return statearr_20387;
})();
if(cljs.core.truth_(inst_20331)){
var statearr_20388_20420 = state_20374__$1;
(statearr_20388_20420[(1)] = (6));

} else {
var statearr_20389_20421 = state_20374__$1;
(statearr_20389_20421[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (11))){
var inst_20337 = (state_20374[(10)]);
var state_20374__$1 = state_20374;
var statearr_20391_20422 = state_20374__$1;
(statearr_20391_20422[(2)] = inst_20337);

(statearr_20391_20422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (9))){
var inst_20328 = (state_20374[(8)]);
var inst_20336 = (state_20374[(2)]);
var inst_20337 = fluree.db.util.async.throw_err(inst_20336);
var inst_20338 = (to_t > inst_20328);
var state_20374__$1 = (function (){var statearr_20392 = state_20374;
(statearr_20392[(10)] = inst_20337);

return statearr_20392;
})();
if(cljs.core.truth_(inst_20338)){
var statearr_20393_20423 = state_20374__$1;
(statearr_20393_20423[(1)] = (10));

} else {
var statearr_20394_20424 = state_20374__$1;
(statearr_20394_20424[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (5))){
var _ = (function (){var statearr_20395 = state_20374;
(statearr_20395[(4)] = cljs.core.rest((state_20374[(4)])));

return statearr_20395;
})();
var state_20374__$1 = state_20374;
var ex20390 = (state_20374__$1[(2)]);
var statearr_20396_20425 = state_20374__$1;
(statearr_20396_20425[(5)] = ex20390);


var statearr_20397_20426 = state_20374__$1;
(statearr_20397_20426[(1)] = (4));

(statearr_20397_20426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (14))){
var inst_20344 = (state_20374[(9)]);
var state_20374__$1 = state_20374;
var statearr_20398_20427 = state_20374__$1;
(statearr_20398_20427[(2)] = inst_20344);

(statearr_20398_20427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (16))){
var state_20374__$1 = state_20374;
var statearr_20399_20428 = state_20374__$1;
(statearr_20399_20428[(2)] = null);

(statearr_20399_20428[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (10))){
var inst_20328 = (state_20374[(8)]);
var inst_20337 = (state_20374[(10)]);
var inst_20340 = (function (){var node_t = inst_20328;
var G__20333 = inst_20337;
return (function (p1__20318_SHARP_){
return (p1__20318_SHARP_.t < to_t);
});
})();
var inst_20341 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_20340,inst_20337);
var state_20374__$1 = state_20374;
var statearr_20400_20429 = state_20374__$1;
(statearr_20400_20429[(2)] = inst_20341);

(statearr_20400_20429[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (18))){
var inst_20354 = (state_20374[(11)]);
var inst_20355 = (state_20374[(12)]);
var inst_20353 = (state_20374[(13)]);
var inst_20367 = (state_20374[(2)]);
var inst_20368 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_20354,inst_20355,leftmost_QMARK_,to_t);
var inst_20369 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20368,inst_20353);
var _ = (function (){var statearr_20401 = state_20374;
(statearr_20401[(4)] = cljs.core.rest((state_20374[(4)])));

return statearr_20401;
})();
var state_20374__$1 = (function (){var statearr_20402 = state_20374;
(statearr_20402[(14)] = inst_20367);

return statearr_20402;
})();
var statearr_20403_20430 = state_20374__$1;
(statearr_20403_20430[(2)] = inst_20369);

(statearr_20403_20430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20375 === (8))){
var inst_20353 = (state_20374[(2)]);
var inst_20354 = fluree.db.dbproto._first_flake(node);
var inst_20355 = fluree.db.dbproto._rhs(node);
var inst_20356 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_20374__$1 = (function (){var statearr_20404 = state_20374;
(statearr_20404[(11)] = inst_20354);

(statearr_20404[(12)] = inst_20355);

(statearr_20404[(13)] = inst_20353);

return statearr_20404;
})();
if(cljs.core.truth_(inst_20356)){
var statearr_20405_20431 = state_20374__$1;
(statearr_20405_20431[(1)] = (16));

} else {
var statearr_20406_20432 = state_20374__$1;
(statearr_20406_20432[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0 = (function (){
var statearr_20407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20407[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__);

(statearr_20407[(1)] = (1));

return statearr_20407;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1 = (function (state_20374){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20374);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20408){var ex__2417__auto__ = e20408;
var statearr_20409_20433 = state_20374;
(statearr_20409_20433[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20374[(4)]))){
var statearr_20410_20434 = state_20374;
(statearr_20410_20434[(1)] = cljs.core.first((state_20374[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20435 = state_20374;
state_20374 = G__20435;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__ = function(state_20374){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1.call(this,state_20374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20411 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20411[(6)] = c__2436__auto__);

return statearr_20411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__20436_20446 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20437_20447 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20436_20446,G__20437_20447) : object_cache.call(null,G__20436_20446,G__20437_20447));

var G__20438 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20439 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__20440 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20441 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20440,G__20441) : object_cache.call(null,G__20440,G__20441));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20438,G__20439) : object_cache.call(null,G__20438,G__20439));
} else {
var G__20442 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20443 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__20444 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__20445 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20444,G__20445) : object_cache.call(null,G__20444,G__20445));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20442,G__20443) : object_cache.call(null,G__20442,G__20443));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20468){
var state_val_20469 = (state_20468[(1)]);
if((state_val_20469 === (7))){
var state_20468__$1 = state_20468;
var statearr_20470_20490 = state_20468__$1;
(statearr_20470_20490[(2)] = null);

(statearr_20470_20490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (1))){
var state_20468__$1 = state_20468;
var statearr_20471_20491 = state_20468__$1;
(statearr_20471_20491[(2)] = null);

(statearr_20471_20491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (4))){
var inst_20448 = (state_20468[(2)]);
var state_20468__$1 = state_20468;
var statearr_20472_20492 = state_20468__$1;
(statearr_20472_20492[(2)] = inst_20448);

(statearr_20472_20492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (6))){
var inst_20454 = (state_20468[(7)]);
var inst_20456 = fluree.db.storage.core.serde(conn);
var state_20468__$1 = (function (){var statearr_20473 = state_20468;
(statearr_20473[(8)] = inst_20456);

return statearr_20473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20468__$1,(9),inst_20454);
} else {
if((state_val_20469 === (3))){
var inst_20466 = (state_20468[(2)]);
var state_20468__$1 = state_20468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20468__$1,inst_20466);
} else {
if((state_val_20469 === (2))){
var inst_20454 = (state_20468[(7)]);
var _ = (function (){var statearr_20475 = state_20468;
(statearr_20475[(4)] = cljs.core.cons((5),(state_20468[(4)])));

return statearr_20475;
})();
var inst_20454__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_20468__$1 = (function (){var statearr_20476 = state_20468;
(statearr_20476[(7)] = inst_20454__$1);

return statearr_20476;
})();
if(cljs.core.truth_(inst_20454__$1)){
var statearr_20477_20493 = state_20468__$1;
(statearr_20477_20493[(1)] = (6));

} else {
var statearr_20478_20494 = state_20468__$1;
(statearr_20478_20494[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (9))){
var inst_20456 = (state_20468[(8)]);
var inst_20458 = (state_20468[(2)]);
var inst_20459 = fluree.db.util.async.throw_err(inst_20458);
var inst_20460 = fluree.db.serde.protocol._deserialize_branch(inst_20456,inst_20459);
var state_20468__$1 = state_20468;
var statearr_20479_20495 = state_20468__$1;
(statearr_20479_20495[(2)] = inst_20460);

(statearr_20479_20495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (5))){
var _ = (function (){var statearr_20480 = state_20468;
(statearr_20480[(4)] = cljs.core.rest((state_20468[(4)])));

return statearr_20480;
})();
var state_20468__$1 = state_20468;
var ex20474 = (state_20468__$1[(2)]);
var statearr_20481_20496 = state_20468__$1;
(statearr_20481_20496[(5)] = ex20474);


if((ex20474 instanceof Error)){
var statearr_20482_20497 = state_20468__$1;
(statearr_20482_20497[(1)] = (4));

(statearr_20482_20497[(5)] = null);

} else {
throw ex20474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (8))){
var inst_20463 = (state_20468[(2)]);
var _ = (function (){var statearr_20483 = state_20468;
(statearr_20483[(4)] = cljs.core.rest((state_20468[(4)])));

return statearr_20483;
})();
var state_20468__$1 = state_20468;
var statearr_20484_20498 = state_20468__$1;
(statearr_20484_20498[(2)] = inst_20463);

(statearr_20484_20498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0 = (function (){
var statearr_20485 = [null,null,null,null,null,null,null,null,null];
(statearr_20485[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2414__auto__);

(statearr_20485[(1)] = (1));

return statearr_20485;
});
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1 = (function (state_20468){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20468);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20486){var ex__2417__auto__ = e20486;
var statearr_20487_20499 = state_20468;
(statearr_20487_20499[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20468[(4)]))){
var statearr_20488_20500 = state_20468;
(statearr_20488_20500[(1)] = cljs.core.first((state_20468[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20501 = state_20468;
state_20468 = G__20501;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__ = function(state_20468){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1.call(this,state_20468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20489 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20489[(6)] = c__2436__auto__);

return statearr_20489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___20647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20592){
var state_val_20593 = (state_20592[(1)]);
if((state_val_20593 === (7))){
var inst_20519 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_20520 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20521 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_20522 = cljs.core.PersistentHashMap.fromArrays(inst_20520,inst_20521);
var inst_20523 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20519,inst_20522);
var inst_20524 = (function(){throw inst_20523})();
var state_20592__$1 = state_20592;
var statearr_20594_20648 = state_20592__$1;
(statearr_20594_20648[(2)] = inst_20524);

(statearr_20594_20648[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (20))){
var inst_20516 = (state_20592[(7)]);
var state_20592__$1 = state_20592;
var statearr_20595_20649 = state_20592__$1;
(statearr_20595_20649[(2)] = inst_20516);

(statearr_20595_20649[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (27))){
var inst_20570 = (state_20592[(2)]);
var state_20592__$1 = state_20592;
var statearr_20596_20650 = state_20592__$1;
(statearr_20596_20650[(2)] = inst_20570);

(statearr_20596_20650[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (1))){
var state_20592__$1 = state_20592;
var statearr_20597_20651 = state_20592__$1;
(statearr_20597_20651[(2)] = null);

(statearr_20597_20651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (24))){
var inst_20573 = (state_20592[(2)]);
var state_20592__$1 = state_20592;
if(cljs.core.truth_(inst_20573)){
var statearr_20598_20652 = state_20592__$1;
(statearr_20598_20652[(1)] = (28));

} else {
var statearr_20599_20653 = state_20592__$1;
(statearr_20599_20653[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (4))){
var inst_20502 = (state_20592[(2)]);
var inst_20503 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20504 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20502);
var inst_20505 = cljs.core.async.close_BANG_(return_ch);
var state_20592__$1 = (function (){var statearr_20600 = state_20592;
(statearr_20600[(8)] = inst_20504);

(statearr_20600[(9)] = inst_20503);

return statearr_20600;
})();
var statearr_20601_20654 = state_20592__$1;
(statearr_20601_20654[(2)] = inst_20505);

(statearr_20601_20654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (15))){
var inst_20549 = (state_20592[(2)]);
var state_20592__$1 = state_20592;
if(cljs.core.truth_(inst_20549)){
var statearr_20602_20655 = state_20592__$1;
(statearr_20602_20655[(1)] = (19));

} else {
var statearr_20603_20656 = state_20592__$1;
(statearr_20603_20656[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (21))){
var inst_20554 = (state_20592[(10)]);
var inst_20557 = (state_20592[(11)]);
var inst_20554__$1 = (state_20592[(2)]);
var inst_20555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20554__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_20556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20554__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_20557__$1 = config;
var inst_20559 = (inst_20557__$1 == null);
var inst_20560 = cljs.core.not(inst_20559);
var state_20592__$1 = (function (){var statearr_20604 = state_20592;
(statearr_20604[(10)] = inst_20554__$1);

(statearr_20604[(11)] = inst_20557__$1);

(statearr_20604[(12)] = inst_20556);

(statearr_20604[(13)] = inst_20555);

return statearr_20604;
})();
if(inst_20560){
var statearr_20605_20657 = state_20592__$1;
(statearr_20605_20657[(1)] = (22));

} else {
var statearr_20606_20658 = state_20592__$1;
(statearr_20606_20658[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (13))){
var inst_20516 = (state_20592[(7)]);
var inst_20538 = inst_20516.cljs$lang$protocol_mask$partition0$;
var inst_20539 = (inst_20538 & (64));
var inst_20540 = inst_20516.cljs$core$ISeq$;
var inst_20541 = (cljs.core.PROTOCOL_SENTINEL === inst_20540);
var inst_20542 = ((inst_20539) || (inst_20541));
var state_20592__$1 = state_20592;
if(cljs.core.truth_(inst_20542)){
var statearr_20607_20659 = state_20592__$1;
(statearr_20607_20659[(1)] = (16));

} else {
var statearr_20608_20660 = state_20592__$1;
(statearr_20608_20660[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (22))){
var inst_20557 = (state_20592[(11)]);
var inst_20562 = inst_20557.cljs$lang$protocol_mask$partition0$;
var inst_20563 = (inst_20562 & (64));
var inst_20564 = inst_20557.cljs$core$ISeq$;
var inst_20565 = (cljs.core.PROTOCOL_SENTINEL === inst_20564);
var inst_20566 = ((inst_20563) || (inst_20565));
var state_20592__$1 = state_20592;
if(cljs.core.truth_(inst_20566)){
var statearr_20609_20661 = state_20592__$1;
(statearr_20609_20661[(1)] = (25));

} else {
var statearr_20610_20662 = state_20592__$1;
(statearr_20610_20662[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (29))){
var inst_20557 = (state_20592[(11)]);
var state_20592__$1 = state_20592;
var statearr_20611_20663 = state_20592__$1;
(statearr_20611_20663[(2)] = inst_20557);

(statearr_20611_20663[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (6))){
var inst_20516 = (state_20592[(7)]);
var inst_20515 = (state_20592[(2)]);
var inst_20516__$1 = fluree.db.util.async.throw_err(inst_20515);
var inst_20517 = (inst_20516__$1 == null);
var state_20592__$1 = (function (){var statearr_20612 = state_20592;
(statearr_20612[(7)] = inst_20516__$1);

return statearr_20612;
})();
if(cljs.core.truth_(inst_20517)){
var statearr_20613_20664 = state_20592__$1;
(statearr_20613_20664[(1)] = (7));

} else {
var statearr_20614_20665 = state_20592__$1;
(statearr_20614_20665[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (28))){
var inst_20557 = (state_20592[(11)]);
var inst_20575 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20557);
var state_20592__$1 = state_20592;
var statearr_20615_20666 = state_20592__$1;
(statearr_20615_20666[(2)] = inst_20575);

(statearr_20615_20666[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (25))){
var state_20592__$1 = state_20592;
var statearr_20616_20667 = state_20592__$1;
(statearr_20616_20667[(2)] = true);

(statearr_20616_20667[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (17))){
var state_20592__$1 = state_20592;
var statearr_20617_20668 = state_20592__$1;
(statearr_20617_20668[(2)] = false);

(statearr_20617_20668[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (3))){
var inst_20590 = (state_20592[(2)]);
var state_20592__$1 = state_20592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20592__$1,inst_20590);
} else {
if((state_val_20593 === (12))){
var inst_20516 = (state_20592[(7)]);
var inst_20533 = (state_20592[(2)]);
var inst_20535 = (inst_20516 == null);
var inst_20536 = cljs.core.not(inst_20535);
var state_20592__$1 = (function (){var statearr_20618 = state_20592;
(statearr_20618[(14)] = inst_20533);

return statearr_20618;
})();
if(inst_20536){
var statearr_20619_20669 = state_20592__$1;
(statearr_20619_20669[(1)] = (13));

} else {
var statearr_20620_20670 = state_20592__$1;
(statearr_20620_20670[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (2))){
var _ = (function (){var statearr_20621 = state_20592;
(statearr_20621[(4)] = cljs.core.cons((5),(state_20592[(4)])));

return statearr_20621;
})();
var inst_20513 = fluree.db.storage.core.read_branch(conn,key);
var state_20592__$1 = state_20592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20592__$1,(6),inst_20513);
} else {
if((state_val_20593 === (23))){
var state_20592__$1 = state_20592;
var statearr_20622_20671 = state_20592__$1;
(statearr_20622_20671[(2)] = false);

(statearr_20622_20671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (19))){
var inst_20516 = (state_20592[(7)]);
var inst_20551 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20516);
var state_20592__$1 = state_20592;
var statearr_20623_20672 = state_20592__$1;
(statearr_20623_20672[(2)] = inst_20551);

(statearr_20623_20672[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (11))){
var state_20592__$1 = state_20592;
var statearr_20625_20673 = state_20592__$1;
(statearr_20625_20673[(2)] = null);

(statearr_20625_20673[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (9))){
var inst_20516 = (state_20592[(7)]);
var inst_20527 = (state_20592[(2)]);
var inst_20528 = fluree.db.util.core.exception_QMARK_(inst_20516);
var state_20592__$1 = (function (){var statearr_20626 = state_20592;
(statearr_20626[(15)] = inst_20527);

return statearr_20626;
})();
if(inst_20528){
var statearr_20627_20674 = state_20592__$1;
(statearr_20627_20674[(1)] = (10));

} else {
var statearr_20628_20675 = state_20592__$1;
(statearr_20628_20675[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (5))){
var _ = (function (){var statearr_20629 = state_20592;
(statearr_20629[(4)] = cljs.core.rest((state_20592[(4)])));

return statearr_20629;
})();
var state_20592__$1 = state_20592;
var ex20624 = (state_20592__$1[(2)]);
var statearr_20630_20676 = state_20592__$1;
(statearr_20630_20676[(5)] = ex20624);


var statearr_20631_20677 = state_20592__$1;
(statearr_20631_20677[(1)] = (4));

(statearr_20631_20677[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (14))){
var state_20592__$1 = state_20592;
var statearr_20632_20678 = state_20592__$1;
(statearr_20632_20678[(2)] = false);

(statearr_20632_20678[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (26))){
var state_20592__$1 = state_20592;
var statearr_20633_20679 = state_20592__$1;
(statearr_20633_20679[(2)] = false);

(statearr_20633_20679[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (16))){
var state_20592__$1 = state_20592;
var statearr_20634_20680 = state_20592__$1;
(statearr_20634_20680[(2)] = true);

(statearr_20634_20680[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (30))){
var inst_20533 = (state_20592[(14)]);
var inst_20516 = (state_20592[(7)]);
var inst_20554 = (state_20592[(10)]);
var inst_20556 = (state_20592[(12)]);
var inst_20555 = (state_20592[(13)]);
var inst_20578 = (state_20592[(2)]);
var inst_20579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20578,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_20581 = (function (){var data = inst_20516;
var _ = inst_20533;
var map__20511 = inst_20554;
var children = inst_20555;
var rhs = inst_20556;
var map__20512 = inst_20578;
var comparator = inst_20579;
return (function (idx,p__20580){
var map__20635 = p__20580;
var map__20635__$1 = (((((!((map__20635 == null))))?(((((map__20635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20635):map__20635);
var child = map__20635__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20635__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20635__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20635__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20635__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20635__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_20582 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_20581,inst_20555);
var inst_20583 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_20582);
var inst_20584 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_20583,inst_20582);
var inst_20585 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_20579,inst_20584);
var inst_20586 = fluree.db.index.__GT_IndexNode(block,t,inst_20556,inst_20585,config,leftmost_QMARK_);
var inst_20587 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20586);
var _ = (function (){var statearr_20637 = state_20592;
(statearr_20637[(4)] = cljs.core.rest((state_20592[(4)])));

return statearr_20637;
})();
var state_20592__$1 = state_20592;
var statearr_20638_20681 = state_20592__$1;
(statearr_20638_20681[(2)] = inst_20587);

(statearr_20638_20681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (10))){
var inst_20516 = (state_20592[(7)]);
var inst_20530 = (function(){throw inst_20516})();
var state_20592__$1 = state_20592;
var statearr_20639_20682 = state_20592__$1;
(statearr_20639_20682[(2)] = inst_20530);

(statearr_20639_20682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (18))){
var inst_20546 = (state_20592[(2)]);
var state_20592__$1 = state_20592;
var statearr_20640_20683 = state_20592__$1;
(statearr_20640_20683[(2)] = inst_20546);

(statearr_20640_20683[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20593 === (8))){
var state_20592__$1 = state_20592;
var statearr_20641_20684 = state_20592__$1;
(statearr_20641_20684[(2)] = null);

(statearr_20641_20684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0 = (function (){
var statearr_20642 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20642[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__);

(statearr_20642[(1)] = (1));

return statearr_20642;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1 = (function (state_20592){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20592);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20643){var ex__2417__auto__ = e20643;
var statearr_20644_20685 = state_20592;
(statearr_20644_20685[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20592[(4)]))){
var statearr_20645_20686 = state_20592;
(statearr_20645_20686[(1)] = cljs.core.first((state_20592[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20687 = state_20592;
state_20592 = G__20687;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__ = function(state_20592){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1.call(this,state_20592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20646 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20646[(6)] = c__2436__auto___20647);

return statearr_20646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20708){
var state_val_20709 = (state_20708[(1)]);
if((state_val_20709 === (7))){
var state_20708__$1 = state_20708;
var statearr_20710_20730 = state_20708__$1;
(statearr_20710_20730[(2)] = null);

(statearr_20710_20730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (1))){
var state_20708__$1 = state_20708;
var statearr_20711_20731 = state_20708__$1;
(statearr_20711_20731[(2)] = null);

(statearr_20711_20731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (4))){
var inst_20688 = (state_20708[(2)]);
var state_20708__$1 = state_20708;
var statearr_20712_20732 = state_20708__$1;
(statearr_20712_20732[(2)] = inst_20688);

(statearr_20712_20732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (6))){
var inst_20694 = (state_20708[(7)]);
var inst_20696 = fluree.db.storage.core.serde(conn);
var state_20708__$1 = (function (){var statearr_20713 = state_20708;
(statearr_20713[(8)] = inst_20696);

return statearr_20713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20708__$1,(9),inst_20694);
} else {
if((state_val_20709 === (3))){
var inst_20706 = (state_20708[(2)]);
var state_20708__$1 = state_20708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20708__$1,inst_20706);
} else {
if((state_val_20709 === (2))){
var inst_20694 = (state_20708[(7)]);
var _ = (function (){var statearr_20715 = state_20708;
(statearr_20715[(4)] = cljs.core.cons((5),(state_20708[(4)])));

return statearr_20715;
})();
var inst_20694__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_20708__$1 = (function (){var statearr_20716 = state_20708;
(statearr_20716[(7)] = inst_20694__$1);

return statearr_20716;
})();
if(cljs.core.truth_(inst_20694__$1)){
var statearr_20717_20733 = state_20708__$1;
(statearr_20717_20733[(1)] = (6));

} else {
var statearr_20718_20734 = state_20708__$1;
(statearr_20718_20734[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (9))){
var inst_20696 = (state_20708[(8)]);
var inst_20698 = (state_20708[(2)]);
var inst_20699 = fluree.db.util.async.throw_err(inst_20698);
var inst_20700 = fluree.db.serde.protocol._deserialize_leaf(inst_20696,inst_20699);
var state_20708__$1 = state_20708;
var statearr_20719_20735 = state_20708__$1;
(statearr_20719_20735[(2)] = inst_20700);

(statearr_20719_20735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (5))){
var _ = (function (){var statearr_20720 = state_20708;
(statearr_20720[(4)] = cljs.core.rest((state_20708[(4)])));

return statearr_20720;
})();
var state_20708__$1 = state_20708;
var ex20714 = (state_20708__$1[(2)]);
var statearr_20721_20736 = state_20708__$1;
(statearr_20721_20736[(5)] = ex20714);


if((ex20714 instanceof Error)){
var statearr_20722_20737 = state_20708__$1;
(statearr_20722_20737[(1)] = (4));

(statearr_20722_20737[(5)] = null);

} else {
throw ex20714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (8))){
var inst_20703 = (state_20708[(2)]);
var _ = (function (){var statearr_20723 = state_20708;
(statearr_20723[(4)] = cljs.core.rest((state_20708[(4)])));

return statearr_20723;
})();
var state_20708__$1 = state_20708;
var statearr_20724_20738 = state_20708__$1;
(statearr_20724_20738[(2)] = inst_20703);

(statearr_20724_20738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_20725 = [null,null,null,null,null,null,null,null,null];
(statearr_20725[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__);

(statearr_20725[(1)] = (1));

return statearr_20725;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1 = (function (state_20708){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20708);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20726){var ex__2417__auto__ = e20726;
var statearr_20727_20739 = state_20708;
(statearr_20727_20739[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20708[(4)]))){
var statearr_20728_20740 = state_20708;
(statearr_20728_20740[(1)] = cljs.core.first((state_20708[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20741 = state_20708;
state_20708 = G__20741;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__ = function(state_20708){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1.call(this,state_20708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20729 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20729[(6)] = c__2436__auto__);

return statearr_20729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___20879 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20826){
var state_val_20827 = (state_20826[(1)]);
if((state_val_20827 === (7))){
var inst_20758 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_20759 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20760 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_20761 = cljs.core.PersistentHashMap.fromArrays(inst_20759,inst_20760);
var inst_20762 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20758,inst_20761);
var inst_20763 = (function(){throw inst_20762})();
var state_20826__$1 = state_20826;
var statearr_20828_20880 = state_20826__$1;
(statearr_20828_20880[(2)] = inst_20763);

(statearr_20828_20880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (20))){
var inst_20755 = (state_20826[(7)]);
var state_20826__$1 = state_20826;
var statearr_20829_20881 = state_20826__$1;
(statearr_20829_20881[(2)] = inst_20755);

(statearr_20829_20881[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (27))){
var inst_20809 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20830_20882 = state_20826__$1;
(statearr_20830_20882[(2)] = inst_20809);

(statearr_20830_20882[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (1))){
var state_20826__$1 = state_20826;
var statearr_20831_20883 = state_20826__$1;
(statearr_20831_20883[(2)] = null);

(statearr_20831_20883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (24))){
var inst_20812 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20812)){
var statearr_20832_20884 = state_20826__$1;
(statearr_20832_20884[(1)] = (28));

} else {
var statearr_20833_20885 = state_20826__$1;
(statearr_20833_20885[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (4))){
var inst_20742 = (state_20826[(2)]);
var inst_20743 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20744 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20742);
var inst_20745 = cljs.core.async.close_BANG_(return_ch);
var state_20826__$1 = (function (){var statearr_20834 = state_20826;
(statearr_20834[(8)] = inst_20744);

(statearr_20834[(9)] = inst_20743);

return statearr_20834;
})();
var statearr_20835_20886 = state_20826__$1;
(statearr_20835_20886[(2)] = inst_20745);

(statearr_20835_20886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (15))){
var inst_20788 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20788)){
var statearr_20836_20887 = state_20826__$1;
(statearr_20836_20887[(1)] = (19));

} else {
var statearr_20837_20888 = state_20826__$1;
(statearr_20837_20888[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (21))){
var inst_20796 = (state_20826[(10)]);
var inst_20793 = (state_20826[(2)]);
var inst_20794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20793,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_20795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20793,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_20796__$1 = config;
var inst_20798 = (inst_20796__$1 == null);
var inst_20799 = cljs.core.not(inst_20798);
var state_20826__$1 = (function (){var statearr_20838 = state_20826;
(statearr_20838[(10)] = inst_20796__$1);

(statearr_20838[(11)] = inst_20794);

(statearr_20838[(12)] = inst_20795);

return statearr_20838;
})();
if(inst_20799){
var statearr_20839_20889 = state_20826__$1;
(statearr_20839_20889[(1)] = (22));

} else {
var statearr_20840_20890 = state_20826__$1;
(statearr_20840_20890[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (13))){
var inst_20755 = (state_20826[(7)]);
var inst_20777 = inst_20755.cljs$lang$protocol_mask$partition0$;
var inst_20778 = (inst_20777 & (64));
var inst_20779 = inst_20755.cljs$core$ISeq$;
var inst_20780 = (cljs.core.PROTOCOL_SENTINEL === inst_20779);
var inst_20781 = ((inst_20778) || (inst_20780));
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20781)){
var statearr_20841_20891 = state_20826__$1;
(statearr_20841_20891[(1)] = (16));

} else {
var statearr_20842_20892 = state_20826__$1;
(statearr_20842_20892[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (22))){
var inst_20796 = (state_20826[(10)]);
var inst_20801 = inst_20796.cljs$lang$protocol_mask$partition0$;
var inst_20802 = (inst_20801 & (64));
var inst_20803 = inst_20796.cljs$core$ISeq$;
var inst_20804 = (cljs.core.PROTOCOL_SENTINEL === inst_20803);
var inst_20805 = ((inst_20802) || (inst_20804));
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20805)){
var statearr_20843_20893 = state_20826__$1;
(statearr_20843_20893[(1)] = (25));

} else {
var statearr_20844_20894 = state_20826__$1;
(statearr_20844_20894[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (29))){
var inst_20796 = (state_20826[(10)]);
var state_20826__$1 = state_20826;
var statearr_20845_20895 = state_20826__$1;
(statearr_20845_20895[(2)] = inst_20796);

(statearr_20845_20895[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (6))){
var inst_20755 = (state_20826[(7)]);
var inst_20755__$1 = (state_20826[(2)]);
var inst_20756 = (inst_20755__$1 == null);
var state_20826__$1 = (function (){var statearr_20846 = state_20826;
(statearr_20846[(7)] = inst_20755__$1);

return statearr_20846;
})();
if(cljs.core.truth_(inst_20756)){
var statearr_20847_20896 = state_20826__$1;
(statearr_20847_20896[(1)] = (7));

} else {
var statearr_20848_20897 = state_20826__$1;
(statearr_20848_20897[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (28))){
var inst_20796 = (state_20826[(10)]);
var inst_20814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20796);
var state_20826__$1 = state_20826;
var statearr_20849_20898 = state_20826__$1;
(statearr_20849_20898[(2)] = inst_20814);

(statearr_20849_20898[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (25))){
var state_20826__$1 = state_20826;
var statearr_20850_20899 = state_20826__$1;
(statearr_20850_20899[(2)] = true);

(statearr_20850_20899[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (17))){
var state_20826__$1 = state_20826;
var statearr_20851_20900 = state_20826__$1;
(statearr_20851_20900[(2)] = false);

(statearr_20851_20900[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (3))){
var inst_20824 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20826__$1,inst_20824);
} else {
if((state_val_20827 === (12))){
var inst_20755 = (state_20826[(7)]);
var inst_20772 = (state_20826[(2)]);
var inst_20774 = (inst_20755 == null);
var inst_20775 = cljs.core.not(inst_20774);
var state_20826__$1 = (function (){var statearr_20852 = state_20826;
(statearr_20852[(13)] = inst_20772);

return statearr_20852;
})();
if(inst_20775){
var statearr_20853_20901 = state_20826__$1;
(statearr_20853_20901[(1)] = (13));

} else {
var statearr_20854_20902 = state_20826__$1;
(statearr_20854_20902[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (2))){
var _ = (function (){var statearr_20855 = state_20826;
(statearr_20855[(4)] = cljs.core.cons((5),(state_20826[(4)])));

return statearr_20855;
})();
var inst_20753 = fluree.db.storage.core.read_leaf(conn,key);
var state_20826__$1 = state_20826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20826__$1,(6),inst_20753);
} else {
if((state_val_20827 === (23))){
var state_20826__$1 = state_20826;
var statearr_20856_20903 = state_20826__$1;
(statearr_20856_20903[(2)] = false);

(statearr_20856_20903[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (19))){
var inst_20755 = (state_20826[(7)]);
var inst_20790 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20755);
var state_20826__$1 = state_20826;
var statearr_20857_20904 = state_20826__$1;
(statearr_20857_20904[(2)] = inst_20790);

(statearr_20857_20904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (11))){
var state_20826__$1 = state_20826;
var statearr_20859_20905 = state_20826__$1;
(statearr_20859_20905[(2)] = null);

(statearr_20859_20905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (9))){
var inst_20755 = (state_20826[(7)]);
var inst_20766 = (state_20826[(2)]);
var inst_20767 = fluree.db.util.core.exception_QMARK_(inst_20755);
var state_20826__$1 = (function (){var statearr_20860 = state_20826;
(statearr_20860[(14)] = inst_20766);

return statearr_20860;
})();
if(inst_20767){
var statearr_20861_20906 = state_20826__$1;
(statearr_20861_20906[(1)] = (10));

} else {
var statearr_20862_20907 = state_20826__$1;
(statearr_20862_20907[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (5))){
var _ = (function (){var statearr_20863 = state_20826;
(statearr_20863[(4)] = cljs.core.rest((state_20826[(4)])));

return statearr_20863;
})();
var state_20826__$1 = state_20826;
var ex20858 = (state_20826__$1[(2)]);
var statearr_20864_20908 = state_20826__$1;
(statearr_20864_20908[(5)] = ex20858);


var statearr_20865_20909 = state_20826__$1;
(statearr_20865_20909[(1)] = (4));

(statearr_20865_20909[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (14))){
var state_20826__$1 = state_20826;
var statearr_20866_20910 = state_20826__$1;
(statearr_20866_20910[(2)] = false);

(statearr_20866_20910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (26))){
var state_20826__$1 = state_20826;
var statearr_20867_20911 = state_20826__$1;
(statearr_20867_20911[(2)] = false);

(statearr_20867_20911[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (16))){
var state_20826__$1 = state_20826;
var statearr_20868_20912 = state_20826__$1;
(statearr_20868_20912[(2)] = true);

(statearr_20868_20912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (30))){
var inst_20794 = (state_20826[(11)]);
var inst_20817 = (state_20826[(2)]);
var inst_20818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20817,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_20819 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_20818,inst_20794);
var inst_20820 = fluree.db.index.data_node(block,t,inst_20819,rhs,config);
var inst_20821 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20820);
var _ = (function (){var statearr_20869 = state_20826;
(statearr_20869[(4)] = cljs.core.rest((state_20826[(4)])));

return statearr_20869;
})();
var state_20826__$1 = state_20826;
var statearr_20870_20913 = state_20826__$1;
(statearr_20870_20913[(2)] = inst_20821);

(statearr_20870_20913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (10))){
var inst_20755 = (state_20826[(7)]);
var inst_20769 = (function(){throw inst_20755})();
var state_20826__$1 = state_20826;
var statearr_20871_20914 = state_20826__$1;
(statearr_20871_20914[(2)] = inst_20769);

(statearr_20871_20914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (18))){
var inst_20785 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20872_20915 = state_20826__$1;
(statearr_20872_20915[(2)] = inst_20785);

(statearr_20872_20915[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (8))){
var state_20826__$1 = state_20826;
var statearr_20873_20916 = state_20826__$1;
(statearr_20873_20916[(2)] = null);

(statearr_20873_20916[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_20874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20874[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__);

(statearr_20874[(1)] = (1));

return statearr_20874;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1 = (function (state_20826){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20826);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20875){var ex__2417__auto__ = e20875;
var statearr_20876_20917 = state_20826;
(statearr_20876_20917[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20826[(4)]))){
var statearr_20877_20918 = state_20826;
(statearr_20877_20918[(1)] = cljs.core.first((state_20826[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20919 = state_20826;
state_20826 = G__20919;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__ = function(state_20826){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1.call(this,state_20826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20878 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20878[(6)] = c__2436__auto___20879);

return statearr_20878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k20921,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__20925 = k20921;
var G__20925__$1 = (((G__20925 instanceof cljs.core.Keyword))?G__20925.fqn:null);
switch (G__20925__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k20921,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__20926){
var vec__20927 = p__20926;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20927,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20927,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__20920){
var self__ = this;
var G__20920__$1 = this;
return (new cljs.core.RecordIter((0),G__20920__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__20930 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__20931 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__20932 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__20933 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20932,G__20933) : object_cache.call(null,G__20932,G__20933));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__20934 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__20935 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20934,G__20935) : object_cache.call(null,G__20934,G__20935));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20930,G__20931) : object_cache.call(null,G__20930,G__20931));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__20936 = history_id;
var G__20937 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__20936,G__20937) : object_cache.call(null,G__20936,G__20937));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__20938 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__20938(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this20922,other20923){
var self__ = this;
var this20922__$1 = this;
return (((!((other20923 == null)))) && ((this20922__$1.constructor === other20923.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.conn,other20923.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.config,other20923.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.network,other20923.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.dbid,other20923.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.id,other20923.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.leaf,other20923.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.first,other20923.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.rhs,other20923.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.size,other20923.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.block,other20923.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.t,other20923.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.tt_id,other20923.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.leftmost_QMARK_,other20923.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.tempid,other20923.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this20922__$1.__extmap,other20923.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__20920){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__20939 = cljs.core.keyword_identical_QMARK_;
var expr__20940 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__20942 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__20943 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20942,G__20943) : pred__20939.call(null,G__20942,G__20943));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__20920,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20944 = new cljs.core.Keyword(null,"config","config",994861415);
var G__20945 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20944,G__20945) : pred__20939.call(null,G__20944,G__20945));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__20920,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20946 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__20947 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20946,G__20947) : pred__20939.call(null,G__20946,G__20947));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__20920,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20948 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__20949 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20948,G__20949) : pred__20939.call(null,G__20948,G__20949));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__20920,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20950 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__20951 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20950,G__20951) : pred__20939.call(null,G__20950,G__20951));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__20920,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20952 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__20953 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20952,G__20953) : pred__20939.call(null,G__20952,G__20953));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__20920,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20954 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__20955 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20954,G__20955) : pred__20939.call(null,G__20954,G__20955));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__20920,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20956 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__20957 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20956,G__20957) : pred__20939.call(null,G__20956,G__20957));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__20920,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20958 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__20959 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20958,G__20959) : pred__20939.call(null,G__20958,G__20959));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__20920,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20960 = new cljs.core.Keyword(null,"block","block",664686210);
var G__20961 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20960,G__20961) : pred__20939.call(null,G__20960,G__20961));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__20920,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20962 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__20963 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20962,G__20963) : pred__20939.call(null,G__20962,G__20963));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__20920,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20964 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__20965 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20964,G__20965) : pred__20939.call(null,G__20964,G__20965));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__20920,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20966 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__20967 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20966,G__20967) : pred__20939.call(null,G__20966,G__20967));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__20920,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__20968 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__20969 = expr__20940;
return (pred__20939.cljs$core$IFn$_invoke$arity$2 ? pred__20939.cljs$core$IFn$_invoke$arity$2(G__20968,G__20969) : pred__20939.call(null,G__20968,G__20969));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__20920,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__20920),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__20920){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__20920,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__20924){
var extmap__4419__auto__ = (function (){var G__20970 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__20924,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__20924)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__20970);
} else {
return G__20970;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__20924),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__20924),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__20972 = blank_db;
var map__20972__$1 = (((((!((map__20972 == null))))?(((((map__20972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20972):map__20972);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20972__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20972__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20972__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__20973 = root_data;
var map__20973__$1 = (((((!((map__20973 == null))))?(((((map__20973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20973):map__20973);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20973__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20973__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20973__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20973__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20997){
var state_val_20998 = (state_20997[(1)]);
if((state_val_20998 === (7))){
var state_20997__$1 = state_20997;
var statearr_20999_21019 = state_20997__$1;
(statearr_20999_21019[(2)] = null);

(statearr_20999_21019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (1))){
var state_20997__$1 = state_20997;
var statearr_21000_21020 = state_20997__$1;
(statearr_21000_21020[(2)] = null);

(statearr_21000_21020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (4))){
var inst_20976 = (state_20997[(2)]);
var state_20997__$1 = state_20997;
var statearr_21001_21021 = state_20997__$1;
(statearr_21001_21021[(2)] = inst_20976);

(statearr_21001_21021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (6))){
var inst_20983 = (state_20997[(7)]);
var inst_20985 = fluree.db.storage.core.serde(conn);
var state_20997__$1 = (function (){var statearr_21002 = state_20997;
(statearr_21002[(8)] = inst_20985);

return statearr_21002;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20997__$1,(9),inst_20983);
} else {
if((state_val_20998 === (3))){
var inst_20995 = (state_20997[(2)]);
var state_20997__$1 = state_20997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20997__$1,inst_20995);
} else {
if((state_val_20998 === (2))){
var inst_20983 = (state_20997[(7)]);
var _ = (function (){var statearr_21004 = state_20997;
(statearr_21004[(4)] = cljs.core.cons((5),(state_20997[(4)])));

return statearr_21004;
})();
var inst_20982 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_20983__$1 = fluree.db.storage.core.storage_read(conn,inst_20982);
var state_20997__$1 = (function (){var statearr_21005 = state_20997;
(statearr_21005[(7)] = inst_20983__$1);

return statearr_21005;
})();
if(cljs.core.truth_(inst_20983__$1)){
var statearr_21006_21022 = state_20997__$1;
(statearr_21006_21022[(1)] = (6));

} else {
var statearr_21007_21023 = state_20997__$1;
(statearr_21007_21023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (9))){
var inst_20985 = (state_20997[(8)]);
var inst_20987 = (state_20997[(2)]);
var inst_20988 = fluree.db.util.async.throw_err(inst_20987);
var inst_20989 = fluree.db.serde.protocol._deserialize_garbage(inst_20985,inst_20988);
var state_20997__$1 = state_20997;
var statearr_21008_21024 = state_20997__$1;
(statearr_21008_21024[(2)] = inst_20989);

(statearr_21008_21024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (5))){
var _ = (function (){var statearr_21009 = state_20997;
(statearr_21009[(4)] = cljs.core.rest((state_20997[(4)])));

return statearr_21009;
})();
var state_20997__$1 = state_20997;
var ex21003 = (state_20997__$1[(2)]);
var statearr_21010_21025 = state_20997__$1;
(statearr_21010_21025[(5)] = ex21003);


if((ex21003 instanceof Error)){
var statearr_21011_21026 = state_20997__$1;
(statearr_21011_21026[(1)] = (4));

(statearr_21011_21026[(5)] = null);

} else {
throw ex21003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20998 === (8))){
var inst_20992 = (state_20997[(2)]);
var _ = (function (){var statearr_21012 = state_20997;
(statearr_21012[(4)] = cljs.core.rest((state_20997[(4)])));

return statearr_21012;
})();
var state_20997__$1 = state_20997;
var statearr_21013_21027 = state_20997__$1;
(statearr_21013_21027[(2)] = inst_20992);

(statearr_21013_21027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0 = (function (){
var statearr_21014 = [null,null,null,null,null,null,null,null,null];
(statearr_21014[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__);

(statearr_21014[(1)] = (1));

return statearr_21014;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1 = (function (state_20997){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20997);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21015){var ex__2417__auto__ = e21015;
var statearr_21016_21028 = state_20997;
(statearr_21016_21028[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20997[(4)]))){
var statearr_21017_21029 = state_20997;
(statearr_21017_21029[(1)] = cljs.core.first((state_20997[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21030 = state_20997;
state_20997 = G__21030;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__ = function(state_20997){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1.call(this,state_20997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21018 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21018[(6)] = c__2436__auto__);

return statearr_21018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21052){
var state_val_21053 = (state_21052[(1)]);
if((state_val_21053 === (7))){
var state_21052__$1 = state_21052;
var statearr_21054_21074 = state_21052__$1;
(statearr_21054_21074[(2)] = null);

(statearr_21054_21074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (1))){
var state_21052__$1 = state_21052;
var statearr_21055_21075 = state_21052__$1;
(statearr_21055_21075[(2)] = null);

(statearr_21055_21075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (4))){
var inst_21031 = (state_21052[(2)]);
var state_21052__$1 = state_21052;
var statearr_21056_21076 = state_21052__$1;
(statearr_21056_21076[(2)] = inst_21031);

(statearr_21056_21076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (6))){
var inst_21038 = (state_21052[(7)]);
var inst_21040 = fluree.db.storage.core.serde(conn);
var state_21052__$1 = (function (){var statearr_21057 = state_21052;
(statearr_21057[(8)] = inst_21040);

return statearr_21057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21052__$1,(9),inst_21038);
} else {
if((state_val_21053 === (3))){
var inst_21050 = (state_21052[(2)]);
var state_21052__$1 = state_21052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21052__$1,inst_21050);
} else {
if((state_val_21053 === (2))){
var inst_21038 = (state_21052[(7)]);
var _ = (function (){var statearr_21059 = state_21052;
(statearr_21059[(4)] = cljs.core.cons((5),(state_21052[(4)])));

return statearr_21059;
})();
var inst_21037 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_21038__$1 = fluree.db.storage.core.storage_read(conn,inst_21037);
var state_21052__$1 = (function (){var statearr_21060 = state_21052;
(statearr_21060[(7)] = inst_21038__$1);

return statearr_21060;
})();
if(cljs.core.truth_(inst_21038__$1)){
var statearr_21061_21077 = state_21052__$1;
(statearr_21061_21077[(1)] = (6));

} else {
var statearr_21062_21078 = state_21052__$1;
(statearr_21062_21078[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (9))){
var inst_21040 = (state_21052[(8)]);
var inst_21042 = (state_21052[(2)]);
var inst_21043 = fluree.db.util.async.throw_err(inst_21042);
var inst_21044 = fluree.db.serde.protocol._deserialize_db_root(inst_21040,inst_21043);
var state_21052__$1 = state_21052;
var statearr_21063_21079 = state_21052__$1;
(statearr_21063_21079[(2)] = inst_21044);

(statearr_21063_21079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (5))){
var _ = (function (){var statearr_21064 = state_21052;
(statearr_21064[(4)] = cljs.core.rest((state_21052[(4)])));

return statearr_21064;
})();
var state_21052__$1 = state_21052;
var ex21058 = (state_21052__$1[(2)]);
var statearr_21065_21080 = state_21052__$1;
(statearr_21065_21080[(5)] = ex21058);


if((ex21058 instanceof Error)){
var statearr_21066_21081 = state_21052__$1;
(statearr_21066_21081[(1)] = (4));

(statearr_21066_21081[(5)] = null);

} else {
throw ex21058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21053 === (8))){
var inst_21047 = (state_21052[(2)]);
var _ = (function (){var statearr_21067 = state_21052;
(statearr_21067[(4)] = cljs.core.rest((state_21052[(4)])));

return statearr_21067;
})();
var state_21052__$1 = state_21052;
var statearr_21068_21082 = state_21052__$1;
(statearr_21068_21082[(2)] = inst_21047);

(statearr_21068_21082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0 = (function (){
var statearr_21069 = [null,null,null,null,null,null,null,null,null];
(statearr_21069[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__);

(statearr_21069[(1)] = (1));

return statearr_21069;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1 = (function (state_21052){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21052);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21070){var ex__2417__auto__ = e21070;
var statearr_21071_21083 = state_21052;
(statearr_21071_21083[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21052[(4)]))){
var statearr_21072_21084 = state_21052;
(statearr_21072_21084[(1)] = cljs.core.first((state_21052[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21085 = state_21052;
state_21052 = G__21085;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__ = function(state_21052){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1.call(this,state_21052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21073 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21073[(6)] = c__2436__auto__);

return statearr_21073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21121){
var state_val_21122 = (state_21121[(1)]);
if((state_val_21122 === (7))){
var inst_21095 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_21096 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21097 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_21098 = cljs.core.PersistentHashMap.fromArrays(inst_21096,inst_21097);
var inst_21099 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21095,inst_21098);
var inst_21100 = (function(){throw inst_21099})();
var state_21121__$1 = state_21121;
var statearr_21123_21145 = state_21121__$1;
(statearr_21123_21145[(2)] = inst_21100);

(statearr_21123_21145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (1))){
var state_21121__$1 = state_21121;
var statearr_21124_21146 = state_21121__$1;
(statearr_21124_21146[(2)] = null);

(statearr_21124_21146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (4))){
var inst_21086 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21125_21147 = state_21121__$1;
(statearr_21125_21147[(2)] = inst_21086);

(statearr_21125_21147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (6))){
var state_21121__$1 = state_21121;
var statearr_21126_21148 = state_21121__$1;
(statearr_21126_21148[(2)] = null);

(statearr_21126_21148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (3))){
var inst_21119 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21121__$1,inst_21119);
} else {
if((state_val_21122 === (2))){
var inst_21092 = (state_21121[(7)]);
var _ = (function (){var statearr_21127 = state_21121;
(statearr_21127[(4)] = cljs.core.cons((5),(state_21121[(4)])));

return statearr_21127;
})();
var inst_21092__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_21121__$1 = (function (){var statearr_21128 = state_21121;
(statearr_21128[(7)] = inst_21092__$1);

return statearr_21128;
})();
if(cljs.core.truth_(inst_21092__$1)){
var statearr_21129_21149 = state_21121__$1;
(statearr_21129_21149[(1)] = (6));

} else {
var statearr_21130_21150 = state_21121__$1;
(statearr_21130_21150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (11))){
var inst_21111 = (state_21121[(8)]);
var inst_21114 = (state_21121[(2)]);
var inst_21115 = fluree.db.util.async.throw_err(inst_21114);
var inst_21116 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21111,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_21115);
var _ = (function (){var statearr_21132 = state_21121;
(statearr_21132[(4)] = cljs.core.rest((state_21121[(4)])));

return statearr_21132;
})();
var state_21121__$1 = state_21121;
var statearr_21133_21151 = state_21121__$1;
(statearr_21133_21151[(2)] = inst_21116);

(statearr_21133_21151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (9))){
var inst_21106 = (state_21121[(9)]);
var inst_21104 = (state_21121[(2)]);
var inst_21105 = fluree.db.util.async.throw_err(inst_21104);
var inst_21106__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_21105);
var inst_21107 = fluree.db.query.schema.schema_map(inst_21106__$1);
var state_21121__$1 = (function (){var statearr_21134 = state_21121;
(statearr_21134[(9)] = inst_21106__$1);

return statearr_21134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21121__$1,(10),inst_21107);
} else {
if((state_val_21122 === (5))){
var _ = (function (){var statearr_21135 = state_21121;
(statearr_21135[(4)] = cljs.core.rest((state_21121[(4)])));

return statearr_21135;
})();
var state_21121__$1 = state_21121;
var ex21131 = (state_21121__$1[(2)]);
var statearr_21136_21152 = state_21121__$1;
(statearr_21136_21152[(5)] = ex21131);


if((ex21131 instanceof Error)){
var statearr_21137_21153 = state_21121__$1;
(statearr_21137_21153[(1)] = (4));

(statearr_21137_21153[(5)] = null);

} else {
throw ex21131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (10))){
var inst_21111 = (state_21121[(8)]);
var inst_21106 = (state_21121[(9)]);
var inst_21109 = (state_21121[(2)]);
var inst_21110 = fluree.db.util.async.throw_err(inst_21109);
var inst_21111__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21106,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_21110);
var inst_21112 = fluree.db.query.schema.setting_map(inst_21111__$1);
var state_21121__$1 = (function (){var statearr_21138 = state_21121;
(statearr_21138[(8)] = inst_21111__$1);

return statearr_21138;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21121__$1,(11),inst_21112);
} else {
if((state_val_21122 === (8))){
var inst_21092 = (state_21121[(7)]);
var inst_21102 = (state_21121[(2)]);
var state_21121__$1 = (function (){var statearr_21139 = state_21121;
(statearr_21139[(10)] = inst_21102);

return statearr_21139;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21121__$1,(9),inst_21092);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0 = (function (){
var statearr_21140 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21140[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2414__auto__);

(statearr_21140[(1)] = (1));

return statearr_21140;
});
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1 = (function (state_21121){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21121);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21141){var ex__2417__auto__ = e21141;
var statearr_21142_21154 = state_21121;
(statearr_21142_21154[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21121[(4)]))){
var statearr_21143_21155 = state_21121;
(statearr_21143_21155[(1)] = cljs.core.first((state_21121[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21156 = state_21121;
state_21121 = G__21156;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__ = function(state_21121){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1.call(this,state_21121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21144 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21144[(6)] = c__2436__auto__);

return statearr_21144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__21158 = arguments.length;
switch (G__21158) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21208){
var state_val_21209 = (state_21208[(1)]);
if((state_val_21209 === (7))){
var inst_21168 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_21169 = (new Error(inst_21168));
var inst_21170 = (function(){throw inst_21169})();
var state_21208__$1 = state_21208;
var statearr_21210_21246 = state_21208__$1;
(statearr_21210_21246[(2)] = inst_21170);

(statearr_21210_21246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (20))){
var inst_21197 = (state_21208[(2)]);
var state_21208__$1 = state_21208;
var statearr_21211_21247 = state_21208__$1;
(statearr_21211_21247[(2)] = inst_21197);

(statearr_21211_21247[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (1))){
var state_21208__$1 = state_21208;
var statearr_21212_21248 = state_21208__$1;
(statearr_21212_21248[(2)] = null);

(statearr_21212_21248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (4))){
var inst_21159 = (state_21208[(2)]);
var state_21208__$1 = state_21208;
var statearr_21213_21249 = state_21208__$1;
(statearr_21213_21249[(2)] = inst_21159);

(statearr_21213_21249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (15))){
var inst_21177 = (state_21208[(7)]);
var inst_21181 = (state_21208[(8)]);
var inst_21189 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21177,inst_21181);
var state_21208__$1 = state_21208;
var statearr_21214_21250 = state_21208__$1;
(statearr_21214_21250[(2)] = inst_21189);

(statearr_21214_21250[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (13))){
var inst_21176 = (state_21208[(9)]);
var inst_21187 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21176,end);
var state_21208__$1 = state_21208;
if(inst_21187){
var statearr_21215_21251 = state_21208__$1;
(statearr_21215_21251[(1)] = (15));

} else {
var statearr_21216_21252 = state_21208__$1;
(statearr_21216_21252[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (6))){
var state_21208__$1 = state_21208;
var statearr_21217_21253 = state_21208__$1;
(statearr_21217_21253[(2)] = null);

(statearr_21217_21253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (17))){
var inst_21199 = (state_21208[(2)]);
var state_21208__$1 = state_21208;
var statearr_21218_21254 = state_21208__$1;
(statearr_21218_21254[(2)] = inst_21199);

(statearr_21218_21254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (3))){
var inst_21206 = (state_21208[(2)]);
var state_21208__$1 = state_21208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21208__$1,inst_21206);
} else {
if((state_val_21209 === (12))){
var inst_21177 = (state_21208[(7)]);
var state_21208__$1 = state_21208;
var statearr_21219_21255 = state_21208__$1;
(statearr_21219_21255[(2)] = inst_21177);

(statearr_21219_21255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (2))){
var _ = (function (){var statearr_21220 = state_21208;
(statearr_21220[(4)] = cljs.core.cons((5),(state_21208[(4)])));

return statearr_21220;
})();
var inst_21165 = (end >= start);
var state_21208__$1 = state_21208;
if(cljs.core.truth_(inst_21165)){
var statearr_21221_21256 = state_21208__$1;
(statearr_21221_21256[(1)] = (6));

} else {
var statearr_21222_21257 = state_21208__$1;
(statearr_21222_21257[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (19))){
var state_21208__$1 = state_21208;
var statearr_21223_21258 = state_21208__$1;
(statearr_21223_21258[(2)] = null);

(statearr_21223_21258[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (11))){
var inst_21181 = (state_21208[(8)]);
var inst_21181__$1 = (state_21208[(2)]);
var inst_21182 = (inst_21181__$1 == null);
var inst_21183 = (inst_21181__$1 instanceof Error);
var inst_21184 = ((inst_21182) || (inst_21183));
var state_21208__$1 = (function (){var statearr_21225 = state_21208;
(statearr_21225[(8)] = inst_21181__$1);

return statearr_21225;
})();
if(cljs.core.truth_(inst_21184)){
var statearr_21226_21259 = state_21208__$1;
(statearr_21226_21259[(1)] = (12));

} else {
var statearr_21227_21260 = state_21208__$1;
(statearr_21227_21260[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (9))){
var inst_21176 = (state_21208[(9)]);
var inst_21179 = fluree.db.storage.core.read_block(conn,network,dbid,inst_21176);
var state_21208__$1 = state_21208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21208__$1,(11),inst_21179);
} else {
if((state_val_21209 === (5))){
var _ = (function (){var statearr_21228 = state_21208;
(statearr_21228[(4)] = cljs.core.rest((state_21208[(4)])));

return statearr_21228;
})();
var state_21208__$1 = state_21208;
var ex21224 = (state_21208__$1[(2)]);
var statearr_21229_21261 = state_21208__$1;
(statearr_21229_21261[(5)] = ex21224);


if((ex21224 instanceof Error)){
var statearr_21230_21262 = state_21208__$1;
(statearr_21230_21262[(1)] = (4));

(statearr_21230_21262[(5)] = null);

} else {
throw ex21224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (14))){
var inst_21201 = (state_21208[(2)]);
var state_21208__$1 = state_21208;
var statearr_21231_21263 = state_21208__$1;
(statearr_21231_21263[(2)] = inst_21201);

(statearr_21231_21263[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (16))){
var state_21208__$1 = state_21208;
var statearr_21232_21264 = state_21208__$1;
(statearr_21232_21264[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (10))){
var inst_21203 = (state_21208[(2)]);
var _ = (function (){var statearr_21234 = state_21208;
(statearr_21234[(4)] = cljs.core.rest((state_21208[(4)])));

return statearr_21234;
})();
var state_21208__$1 = state_21208;
var statearr_21235_21265 = state_21208__$1;
(statearr_21235_21265[(2)] = inst_21203);

(statearr_21235_21265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (18))){
var inst_21176 = (state_21208[(9)]);
var inst_21177 = (state_21208[(7)]);
var inst_21181 = (state_21208[(8)]);
var inst_21192 = (inst_21176 + (1));
var inst_21193 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21177,inst_21181);
var inst_21176__$1 = inst_21192;
var inst_21177__$1 = inst_21193;
var state_21208__$1 = (function (){var statearr_21236 = state_21208;
(statearr_21236[(9)] = inst_21176__$1);

(statearr_21236[(7)] = inst_21177__$1);

return statearr_21236;
})();
var statearr_21237_21266 = state_21208__$1;
(statearr_21237_21266[(2)] = null);

(statearr_21237_21266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21209 === (8))){
var inst_21172 = (state_21208[(2)]);
var inst_21173 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21174 = start;
var inst_21175 = cljs.core.PersistentVector.EMPTY;
var inst_21176 = inst_21174;
var inst_21177 = inst_21175;
var state_21208__$1 = (function (){var statearr_21238 = state_21208;
(statearr_21238[(9)] = inst_21176);

(statearr_21238[(7)] = inst_21177);

(statearr_21238[(10)] = inst_21172);

(statearr_21238[(11)] = inst_21173);

return statearr_21238;
})();
var statearr_21239_21267 = state_21208__$1;
(statearr_21239_21267[(2)] = null);

(statearr_21239_21267[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2414__auto__ = null;
var fluree$db$storage$core$state_machine__2414__auto____0 = (function (){
var statearr_21240 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21240[(0)] = fluree$db$storage$core$state_machine__2414__auto__);

(statearr_21240[(1)] = (1));

return statearr_21240;
});
var fluree$db$storage$core$state_machine__2414__auto____1 = (function (state_21208){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21208);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21241){var ex__2417__auto__ = e21241;
var statearr_21242_21268 = state_21208;
(statearr_21242_21268[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21208[(4)]))){
var statearr_21243_21269 = state_21208;
(statearr_21243_21269[(1)] = cljs.core.first((state_21208[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21270 = state_21208;
state_21208 = G__21270;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2414__auto__ = function(state_21208){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2414__auto____1.call(this,state_21208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2414__auto____0;
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2414__auto____1;
return fluree$db$storage$core$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21244 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21244[(6)] = c__2436__auto__);

return statearr_21244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21286){
var state_val_21287 = (state_21286[(1)]);
if((state_val_21287 === (1))){
var state_21286__$1 = state_21286;
var statearr_21288_21302 = state_21286__$1;
(statearr_21288_21302[(2)] = null);

(statearr_21288_21302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21287 === (2))){
var _ = (function (){var statearr_21289 = state_21286;
(statearr_21289[(4)] = cljs.core.cons((5),(state_21286[(4)])));

return statearr_21289;
})();
var inst_21277 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_21286__$1 = state_21286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21286__$1,(6),inst_21277);
} else {
if((state_val_21287 === (3))){
var inst_21284 = (state_21286[(2)]);
var state_21286__$1 = state_21286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21286__$1,inst_21284);
} else {
if((state_val_21287 === (4))){
var inst_21271 = (state_21286[(2)]);
var state_21286__$1 = state_21286;
var statearr_21291_21303 = state_21286__$1;
(statearr_21291_21303[(2)] = inst_21271);

(statearr_21291_21303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21287 === (5))){
var _ = (function (){var statearr_21292 = state_21286;
(statearr_21292[(4)] = cljs.core.rest((state_21286[(4)])));

return statearr_21292;
})();
var state_21286__$1 = state_21286;
var ex21290 = (state_21286__$1[(2)]);
var statearr_21293_21304 = state_21286__$1;
(statearr_21293_21304[(5)] = ex21290);


if((ex21290 instanceof Error)){
var statearr_21294_21305 = state_21286__$1;
(statearr_21294_21305[(1)] = (4));

(statearr_21294_21305[(5)] = null);

} else {
throw ex21290;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21287 === (6))){
var inst_21279 = (state_21286[(2)]);
var inst_21280 = fluree.db.util.async.throw_err(inst_21279);
var inst_21281 = cljs.core.first(inst_21280);
var _ = (function (){var statearr_21295 = state_21286;
(statearr_21295[(4)] = cljs.core.rest((state_21286[(4)])));

return statearr_21295;
})();
var state_21286__$1 = state_21286;
var statearr_21296_21306 = state_21286__$1;
(statearr_21296_21306[(2)] = inst_21281);

(statearr_21296_21306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2414__auto____0 = (function (){
var statearr_21297 = [null,null,null,null,null,null,null];
(statearr_21297[(0)] = fluree$db$storage$core$block_$_state_machine__2414__auto__);

(statearr_21297[(1)] = (1));

return statearr_21297;
});
var fluree$db$storage$core$block_$_state_machine__2414__auto____1 = (function (state_21286){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21286);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21298){var ex__2417__auto__ = e21298;
var statearr_21299_21307 = state_21286;
(statearr_21299_21307[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21286[(4)]))){
var statearr_21300_21308 = state_21286;
(statearr_21300_21308[(1)] = cljs.core.first((state_21286[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21309 = state_21286;
state_21286 = G__21309;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2414__auto__ = function(state_21286){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2414__auto____1.call(this,state_21286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2414__auto____0;
fluree$db$storage$core$block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21301 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21301[(6)] = c__2436__auto__);

return statearr_21301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
