// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25636 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25636,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25636,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25636,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_25733){
var state_val_25734 = (state_25733[(1)]);
if((state_val_25734 === (7))){
var inst_25654 = (state_25733[(7)]);
var inst_25659 = inst_25654.cljs$lang$protocol_mask$partition0$;
var inst_25660 = (inst_25659 & (64));
var inst_25661 = inst_25654.cljs$core$ISeq$;
var inst_25662 = (cljs.core.PROTOCOL_SENTINEL === inst_25661);
var inst_25663 = ((inst_25660) || (inst_25662));
var state_25733__$1 = state_25733;
if(cljs.core.truth_(inst_25663)){
var statearr_25735_25781 = state_25733__$1;
(statearr_25735_25781[(1)] = (10));

} else {
var statearr_25736_25782 = state_25733__$1;
(statearr_25736_25782[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (20))){
var state_25733__$1 = state_25733;
var statearr_25737_25783 = state_25733__$1;
(statearr_25737_25783[(2)] = false);

(statearr_25737_25783[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (27))){
var inst_25653 = (state_25733[(8)]);
var inst_25679 = (state_25733[(9)]);
var inst_25676 = (state_25733[(10)]);
var inst_25717 = (state_25733[(2)]);
var inst_25718 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25676,inst_25653);
var inst_25719 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25720 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25719,cljs.core.empty);
var inst_25721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25722 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25723 = (new cljs.core.PersistentVector(null,2,(5),inst_25721,inst_25722,null));
var inst_25724 = cljs.core.assoc_in(db,inst_25723,inst_25718);
var inst_25725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25726 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25727 = (new cljs.core.PersistentVector(null,2,(5),inst_25725,inst_25726,null));
var inst_25728 = cljs.core.assoc_in(inst_25724,inst_25727,inst_25679);
var _ = (function (){var statearr_25738 = state_25733;
(statearr_25738[(4)] = cljs.core.rest((state_25733[(4)])));

return statearr_25738;
})();
var state_25733__$1 = (function (){var statearr_25739 = state_25733;
(statearr_25739[(11)] = inst_25720);

(statearr_25739[(12)] = inst_25717);

return statearr_25739;
})();
var statearr_25740_25784 = state_25733__$1;
(statearr_25740_25784[(2)] = inst_25728);

(statearr_25740_25784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (1))){
var state_25733__$1 = state_25733;
var statearr_25741_25785 = state_25733__$1;
(statearr_25741_25785[(2)] = null);

(statearr_25741_25785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (24))){
var inst_25679 = (state_25733[(9)]);
var inst_25704 = (state_25733[(2)]);
var inst_25705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25704,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25704,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25707 = (inst_25679 > inst_25706);
var state_25733__$1 = (function (){var statearr_25742 = state_25733;
(statearr_25742[(13)] = inst_25705);

return statearr_25742;
})();
if(cljs.core.truth_(inst_25707)){
var statearr_25743_25786 = state_25733__$1;
(statearr_25743_25786[(1)] = (25));

} else {
var statearr_25744_25787 = state_25733__$1;
(statearr_25744_25787[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (4))){
var inst_25639 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
var statearr_25745_25788 = state_25733__$1;
(statearr_25745_25788[(2)] = inst_25639);

(statearr_25745_25788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (15))){
var inst_25653 = (state_25733[(8)]);
var inst_25683 = (state_25733[(14)]);
var inst_25675 = (state_25733[(2)]);
var inst_25676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25675,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25675,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25678 = fluree.db.flake.size_bytes(inst_25653);
var inst_25679 = (inst_25677 + inst_25678);
var inst_25680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25681 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25682 = (new cljs.core.PersistentVector(null,2,(5),inst_25680,inst_25681,null));
var inst_25683__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25682);
var inst_25685 = (inst_25683__$1 == null);
var inst_25686 = cljs.core.not(inst_25685);
var state_25733__$1 = (function (){var statearr_25746 = state_25733;
(statearr_25746[(9)] = inst_25679);

(statearr_25746[(10)] = inst_25676);

(statearr_25746[(14)] = inst_25683__$1);

return statearr_25746;
})();
if(inst_25686){
var statearr_25747_25789 = state_25733__$1;
(statearr_25747_25789[(1)] = (16));

} else {
var statearr_25748_25790 = state_25733__$1;
(statearr_25748_25790[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (21))){
var inst_25696 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
var statearr_25749_25791 = state_25733__$1;
(statearr_25749_25791[(2)] = inst_25696);

(statearr_25749_25791[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (13))){
var inst_25654 = (state_25733[(7)]);
var inst_25672 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_25654);
var state_25733__$1 = state_25733;
var statearr_25750_25792 = state_25733__$1;
(statearr_25750_25792[(2)] = inst_25672);

(statearr_25750_25792[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (22))){
var inst_25683 = (state_25733[(14)]);
var inst_25701 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_25683);
var state_25733__$1 = state_25733;
var statearr_25751_25793 = state_25733__$1;
(statearr_25751_25793[(2)] = inst_25701);

(statearr_25751_25793[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (6))){
var inst_25654 = (state_25733[(7)]);
var inst_25652 = (state_25733[(2)]);
var inst_25653 = fluree.db.util.async.throw_err(inst_25652);
var inst_25654__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25656 = (inst_25654__$1 == null);
var inst_25657 = cljs.core.not(inst_25656);
var state_25733__$1 = (function (){var statearr_25752 = state_25733;
(statearr_25752[(8)] = inst_25653);

(statearr_25752[(7)] = inst_25654__$1);

return statearr_25752;
})();
if(inst_25657){
var statearr_25753_25794 = state_25733__$1;
(statearr_25753_25794[(1)] = (7));

} else {
var statearr_25754_25795 = state_25733__$1;
(statearr_25754_25795[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (25))){
var inst_25709 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25710 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25711 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25712 = cljs.core.PersistentHashMap.fromArrays(inst_25710,inst_25711);
var inst_25713 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25709,inst_25712);
var inst_25714 = (function(){throw inst_25713})();
var state_25733__$1 = state_25733;
var statearr_25755_25796 = state_25733__$1;
(statearr_25755_25796[(2)] = inst_25714);

(statearr_25755_25796[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (17))){
var state_25733__$1 = state_25733;
var statearr_25756_25797 = state_25733__$1;
(statearr_25756_25797[(2)] = false);

(statearr_25756_25797[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (3))){
var inst_25731 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25733__$1,inst_25731);
} else {
if((state_val_25734 === (12))){
var inst_25667 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
var statearr_25757_25798 = state_25733__$1;
(statearr_25757_25798[(2)] = inst_25667);

(statearr_25757_25798[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (2))){
var _ = (function (){var statearr_25758 = state_25733;
(statearr_25758[(4)] = cljs.core.cons((5),(state_25733[(4)])));

return statearr_25758;
})();
var inst_25647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25648 = [pred_id];
var inst_25649 = (new cljs.core.PersistentVector(null,1,(5),inst_25647,inst_25648,null));
var inst_25650 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25649);
var state_25733__$1 = state_25733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25733__$1,(6),inst_25650);
} else {
if((state_val_25734 === (23))){
var inst_25683 = (state_25733[(14)]);
var state_25733__$1 = state_25733;
var statearr_25759_25799 = state_25733__$1;
(statearr_25759_25799[(2)] = inst_25683);

(statearr_25759_25799[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (19))){
var state_25733__$1 = state_25733;
var statearr_25760_25800 = state_25733__$1;
(statearr_25760_25800[(2)] = true);

(statearr_25760_25800[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (11))){
var state_25733__$1 = state_25733;
var statearr_25762_25801 = state_25733__$1;
(statearr_25762_25801[(2)] = false);

(statearr_25762_25801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (9))){
var inst_25670 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
if(cljs.core.truth_(inst_25670)){
var statearr_25763_25802 = state_25733__$1;
(statearr_25763_25802[(1)] = (13));

} else {
var statearr_25764_25803 = state_25733__$1;
(statearr_25764_25803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (5))){
var _ = (function (){var statearr_25765 = state_25733;
(statearr_25765[(4)] = cljs.core.rest((state_25733[(4)])));

return statearr_25765;
})();
var state_25733__$1 = state_25733;
var ex25761 = (state_25733__$1[(2)]);
var statearr_25766_25804 = state_25733__$1;
(statearr_25766_25804[(5)] = ex25761);


if((ex25761 instanceof Error)){
var statearr_25767_25805 = state_25733__$1;
(statearr_25767_25805[(1)] = (4));

(statearr_25767_25805[(5)] = null);

} else {
throw ex25761;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (14))){
var inst_25654 = (state_25733[(7)]);
var state_25733__$1 = state_25733;
var statearr_25768_25806 = state_25733__$1;
(statearr_25768_25806[(2)] = inst_25654);

(statearr_25768_25806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (26))){
var state_25733__$1 = state_25733;
var statearr_25769_25807 = state_25733__$1;
(statearr_25769_25807[(2)] = null);

(statearr_25769_25807[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (16))){
var inst_25683 = (state_25733[(14)]);
var inst_25688 = inst_25683.cljs$lang$protocol_mask$partition0$;
var inst_25689 = (inst_25688 & (64));
var inst_25690 = inst_25683.cljs$core$ISeq$;
var inst_25691 = (cljs.core.PROTOCOL_SENTINEL === inst_25690);
var inst_25692 = ((inst_25689) || (inst_25691));
var state_25733__$1 = state_25733;
if(cljs.core.truth_(inst_25692)){
var statearr_25770_25808 = state_25733__$1;
(statearr_25770_25808[(1)] = (19));

} else {
var statearr_25771_25809 = state_25733__$1;
(statearr_25771_25809[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (10))){
var state_25733__$1 = state_25733;
var statearr_25772_25810 = state_25733__$1;
(statearr_25772_25810[(2)] = true);

(statearr_25772_25810[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (18))){
var inst_25699 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
if(cljs.core.truth_(inst_25699)){
var statearr_25773_25811 = state_25733__$1;
(statearr_25773_25811[(1)] = (22));

} else {
var statearr_25774_25812 = state_25733__$1;
(statearr_25774_25812[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (8))){
var state_25733__$1 = state_25733;
var statearr_25775_25813 = state_25733__$1;
(statearr_25775_25813[(2)] = false);

(statearr_25775_25813[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0 = (function (){
var statearr_25776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25776[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__);

(statearr_25776[(1)] = (1));

return statearr_25776;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1 = (function (state_25733){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_25733);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e25777){var ex__2417__auto__ = e25777;
var statearr_25778_25814 = state_25733;
(statearr_25778_25814[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_25733[(4)]))){
var statearr_25779_25815 = state_25733;
(statearr_25779_25815[(1)] = cljs.core.first((state_25733[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25816 = state_25733;
state_25733 = G__25816;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__ = function(state_25733){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1.call(this,state_25733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_25780 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_25780[(6)] = c__2436__auto__);

return statearr_25780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26015){
var state_val_26016 = (state_26015[(1)]);
if((state_val_26016 === (7))){
var state_26015__$1 = state_26015;
var statearr_26017_26084 = state_26015__$1;
(statearr_26017_26084[(2)] = null);

(statearr_26017_26084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (20))){
var inst_25941 = (state_26015[(7)]);
var inst_25937 = (state_26015[(8)]);
var inst_25938 = (state_26015[(9)]);
var inst_25908 = (state_26015[(10)]);
var inst_25858 = (state_26015[(11)]);
var inst_25857 = (state_26015[(12)]);
var inst_25940 = (state_26015[(13)]);
var inst_25939 = (state_26015[(14)]);
var inst_25951 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25953 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25954 = (new cljs.core.PersistentVector(null,2,(5),inst_25952,inst_25953,null));
var inst_25955 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25908,inst_25954);
var inst_25956 = (inst_25857 + inst_25955);
var inst_25957 = [inst_25937,inst_25938,inst_25939,inst_25940,inst_25956];
var inst_25958 = cljs.core.PersistentHashMap.fromArrays(inst_25951,inst_25957);
var inst_25959 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_25908,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25941,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25958], 0));
var state_26015__$1 = (function (){var statearr_26018 = state_26015;
(statearr_26018[(15)] = inst_25959);

return statearr_26018;
})();
if(cljs.core.truth_(inst_25858)){
var statearr_26019_26085 = state_26015__$1;
(statearr_26019_26085[(1)] = (23));

} else {
var statearr_26020_26086 = state_26015__$1;
(statearr_26020_26086[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (27))){
var inst_25959 = (state_26015[(15)]);
var state_26015__$1 = state_26015;
var statearr_26021_26087 = state_26015__$1;
(statearr_26021_26087[(2)] = inst_25959);

(statearr_26021_26087[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (1))){
var state_26015__$1 = state_26015;
var statearr_26022_26088 = state_26015__$1;
(statearr_26022_26088[(2)] = null);

(statearr_26022_26088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (24))){
var inst_25959 = (state_26015[(15)]);
var inst_25962 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25959);
var inst_25963 = (inst_25962 == null);
var state_26015__$1 = state_26015;
var statearr_26023_26089 = state_26015__$1;
(statearr_26023_26089[(2)] = inst_25963);

(statearr_26023_26089[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (39))){
var inst_25991 = (state_26015[(16)]);
var inst_25990 = (state_26015[(17)]);
var inst_25989 = (state_26015[(18)]);
var inst_25948 = (state_26015[(19)]);
var inst_25998 = (state_26015[(20)]);
var inst_26005 = (state_26015[(2)]);
var inst_25936 = inst_25948;
var inst_25937 = inst_25990;
var inst_25938 = inst_25991;
var inst_25939 = inst_25998;
var inst_25940 = inst_26005;
var inst_25941 = inst_25989;
var state_26015__$1 = (function (){var statearr_26024 = state_26015;
(statearr_26024[(7)] = inst_25941);

(statearr_26024[(8)] = inst_25937);

(statearr_26024[(9)] = inst_25938);

(statearr_26024[(21)] = inst_25936);

(statearr_26024[(13)] = inst_25940);

(statearr_26024[(14)] = inst_25939);

return statearr_26024;
})();
var statearr_26025_26090 = state_26015__$1;
(statearr_26025_26090[(2)] = null);

(statearr_26025_26090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (4))){
var inst_25820 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
var statearr_26026_26091 = state_26015__$1;
(statearr_26026_26091[(2)] = inst_25820);

(statearr_26026_26091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (15))){
var inst_25880 = (state_26015[(22)]);
var state_26015__$1 = state_26015;
var statearr_26027_26092 = state_26015__$1;
(statearr_26027_26092[(2)] = inst_25880);

(statearr_26027_26092[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (21))){
var inst_25947 = (state_26015[(23)]);
var inst_25941 = (state_26015[(7)]);
var inst_25859 = (state_26015[(24)]);
var inst_25867 = (state_26015[(25)]);
var inst_25937 = (state_26015[(8)]);
var inst_25917 = (state_26015[(26)]);
var inst_25938 = (state_26015[(9)]);
var inst_25908 = (state_26015[(10)]);
var inst_25842 = (state_26015[(27)]);
var inst_25936 = (state_26015[(21)]);
var inst_25858 = (state_26015[(11)]);
var inst_25857 = (state_26015[(12)]);
var inst_25827 = (state_26015[(28)]);
var inst_25940 = (state_26015[(13)]);
var inst_25852 = (state_26015[(29)]);
var inst_25948 = (state_26015[(19)]);
var inst_25939 = (state_26015[(14)]);
var inst_25861 = (state_26015[(30)]);
var inst_25844 = (state_26015[(31)]);
var inst_25848 = (state_26015[(32)]);
var inst_25918 = (state_26015[(33)]);
var inst_25856 = (state_26015[(34)]);
var inst_25986 = inst_25947.s;
var inst_25987 = fluree.db.flake.sid__GT_cid(inst_25986);
var inst_25988 = (function (){var flakes_bytes = inst_25857;
var t = inst_25827;
var spot = inst_25937;
var add_flakes = inst_25844;
var seq__25944 = inst_25948;
var root_setting_change_QMARK_ = inst_25859;
var ref_QMARK__map = inst_25856;
var r = inst_25948;
var vec__25943 = inst_25936;
var psot = inst_25938;
var add_pred_to_idx_QMARK_ = inst_25867;
var _ = inst_25842;
var cid = inst_25987;
var first__25915 = inst_25917;
var ecount = inst_25941;
var pred_ecount = inst_25861;
var seq__25914 = inst_25918;
var db_STAR_ = inst_25908;
var schema_change_QMARK_ = inst_25858;
var first__25945 = inst_25947;
var add_preds = inst_25848;
var opst = inst_25940;
var G__25912 = inst_25936;
var vec__25913 = inst_25844;
var idx_QMARK__map = inst_25852;
var post = inst_25939;
var f = inst_25947;
return (function (p1__25819_SHARP_){
if(cljs.core.truth_(p1__25819_SHARP_)){
var x__4214__auto__ = p1__25819_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_25989 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_25941,inst_25987,inst_25988);
var inst_25990 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25937,inst_25947);
var inst_25991 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25938,inst_25947);
var inst_25992 = inst_25947.p;
var inst_25993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25852,inst_25992);
var state_26015__$1 = (function (){var statearr_26028 = state_26015;
(statearr_26028[(16)] = inst_25991);

(statearr_26028[(17)] = inst_25990);

(statearr_26028[(18)] = inst_25989);

return statearr_26028;
})();
if(cljs.core.truth_(inst_25993)){
var statearr_26029_26093 = state_26015__$1;
(statearr_26029_26093[(1)] = (34));

} else {
var statearr_26030_26094 = state_26015__$1;
(statearr_26030_26094[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (31))){
var inst_25974 = (state_26015[(35)]);
var state_26015__$1 = state_26015;
var statearr_26031_26095 = state_26015__$1;
(statearr_26031_26095[(2)] = inst_25974);

(statearr_26031_26095[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (32))){
var inst_25984 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
var statearr_26032_26096 = state_26015__$1;
(statearr_26032_26096[(2)] = inst_25984);

(statearr_26032_26096[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (33))){
var inst_25974 = (state_26015[(35)]);
var inst_25979 = (state_26015[(2)]);
var inst_25980 = fluree.db.util.async.throw_err(inst_25979);
var inst_25981 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25974,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25980);
var state_26015__$1 = state_26015;
var statearr_26033_26097 = state_26015__$1;
(statearr_26033_26097[(2)] = inst_25981);

(statearr_26033_26097[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (13))){
var inst_25908 = (state_26015[(10)]);
var inst_25857 = (state_26015[(12)]);
var inst_25827 = (state_26015[(28)]);
var inst_25844 = (state_26015[(31)]);
var inst_25898 = (state_26015[(2)]);
var inst_25899 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25898,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25827);
var inst_25900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25901 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25902 = (new cljs.core.PersistentVector(null,2,(5),inst_25900,inst_25901,null));
var inst_25903 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25899,inst_25902,cljs.core._PLUS_,inst_25857);
var inst_25904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25905 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25906 = (new cljs.core.PersistentVector(null,2,(5),inst_25904,inst_25905,null));
var inst_25907 = cljs.core.count(inst_25844);
var inst_25908__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25903,inst_25906,cljs.core._PLUS_,inst_25907);
var inst_25916 = cljs.core.seq(inst_25844);
var inst_25917 = cljs.core.first(inst_25916);
var inst_25918 = cljs.core.next(inst_25916);
var inst_25919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25920 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25921 = (new cljs.core.PersistentVector(null,2,(5),inst_25919,inst_25920,null));
var inst_25922 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25908__$1,inst_25921);
var inst_25923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25924 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25925 = (new cljs.core.PersistentVector(null,2,(5),inst_25923,inst_25924,null));
var inst_25926 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25908__$1,inst_25925);
var inst_25927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25928 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25929 = (new cljs.core.PersistentVector(null,2,(5),inst_25927,inst_25928,null));
var inst_25930 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25908__$1,inst_25929);
var inst_25931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25932 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25933 = (new cljs.core.PersistentVector(null,2,(5),inst_25931,inst_25932,null));
var inst_25934 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25908__$1,inst_25933);
var inst_25935 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25936 = inst_25844;
var inst_25937 = inst_25922;
var inst_25938 = inst_25926;
var inst_25939 = inst_25930;
var inst_25940 = inst_25934;
var inst_25941 = inst_25935;
var state_26015__$1 = (function (){var statearr_26034 = state_26015;
(statearr_26034[(7)] = inst_25941);

(statearr_26034[(8)] = inst_25937);

(statearr_26034[(26)] = inst_25917);

(statearr_26034[(9)] = inst_25938);

(statearr_26034[(10)] = inst_25908__$1);

(statearr_26034[(21)] = inst_25936);

(statearr_26034[(13)] = inst_25940);

(statearr_26034[(14)] = inst_25939);

(statearr_26034[(33)] = inst_25918);

return statearr_26034;
})();
var statearr_26035_26098 = state_26015__$1;
(statearr_26035_26098[(2)] = null);

(statearr_26035_26098[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (22))){
var inst_26008 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
var statearr_26036_26099 = state_26015__$1;
(statearr_26036_26099[(2)] = inst_26008);

(statearr_26036_26099[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (36))){
var inst_25947 = (state_26015[(23)]);
var inst_25856 = (state_26015[(34)]);
var inst_25998 = (state_26015[(2)]);
var inst_25999 = inst_25947.p;
var inst_26000 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25856,inst_25999);
var state_26015__$1 = (function (){var statearr_26037 = state_26015;
(statearr_26037[(20)] = inst_25998);

return statearr_26037;
})();
if(cljs.core.truth_(inst_26000)){
var statearr_26038_26100 = state_26015__$1;
(statearr_26038_26100[(1)] = (37));

} else {
var statearr_26039_26101 = state_26015__$1;
(statearr_26039_26101[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (29))){
var inst_25959 = (state_26015[(15)]);
var inst_25969 = (state_26015[(2)]);
var inst_25970 = fluree.db.util.async.throw_err(inst_25969);
var inst_25971 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25959,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25970);
var state_26015__$1 = state_26015;
var statearr_26040_26102 = state_26015__$1;
(statearr_26040_26102[(2)] = inst_25971);

(statearr_26040_26102[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (6))){
var inst_25827 = (state_26015[(28)]);
var inst_25832 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_25833 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25834 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25832)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25833)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25827),"."].join('');
var inst_25835 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25836 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25837 = cljs.core.PersistentHashMap.fromArrays(inst_25835,inst_25836);
var inst_25838 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25834,inst_25837);
var inst_25839 = (function(){throw inst_25838})();
var state_26015__$1 = state_26015;
var statearr_26041_26103 = state_26015__$1;
(statearr_26041_26103[(2)] = inst_25839);

(statearr_26041_26103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (28))){
var inst_25859 = (state_26015[(24)]);
var inst_25974 = (state_26015[(2)]);
var state_26015__$1 = (function (){var statearr_26042 = state_26015;
(statearr_26042[(35)] = inst_25974);

return statearr_26042;
})();
if(cljs.core.truth_(inst_25859)){
var statearr_26043_26104 = state_26015__$1;
(statearr_26043_26104[(1)] = (30));

} else {
var statearr_26044_26105 = state_26015__$1;
(statearr_26044_26105[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (25))){
var inst_25965 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
if(cljs.core.truth_(inst_25965)){
var statearr_26045_26106 = state_26015__$1;
(statearr_26045_26106[(1)] = (26));

} else {
var statearr_26046_26107 = state_26015__$1;
(statearr_26046_26107[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (34))){
var inst_25947 = (state_26015[(23)]);
var inst_25939 = (state_26015[(14)]);
var inst_25995 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25939,inst_25947);
var state_26015__$1 = state_26015;
var statearr_26047_26108 = state_26015__$1;
(statearr_26047_26108[(2)] = inst_25995);

(statearr_26047_26108[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (17))){
var inst_25887 = (state_26015[(36)]);
var inst_25891 = (state_26015[(2)]);
var inst_25892 = fluree.db.util.async.throw_err(inst_25891);
var inst_25879 = inst_25887;
var inst_25880 = inst_25892;
var state_26015__$1 = (function (){var statearr_26048 = state_26015;
(statearr_26048[(22)] = inst_25880);

(statearr_26048[(37)] = inst_25879);

return statearr_26048;
})();
var statearr_26049_26109 = state_26015__$1;
(statearr_26049_26109[(2)] = null);

(statearr_26049_26109[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (3))){
var inst_26013 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26015__$1,inst_26013);
} else {
if((state_val_26016 === (12))){
var inst_25886 = (state_26015[(38)]);
var inst_25879 = (state_26015[(37)]);
var inst_25885 = cljs.core.seq(inst_25879);
var inst_25886__$1 = cljs.core.first(inst_25885);
var inst_25887 = cljs.core.next(inst_25885);
var state_26015__$1 = (function (){var statearr_26050 = state_26015;
(statearr_26050[(36)] = inst_25887);

(statearr_26050[(38)] = inst_25886__$1);

return statearr_26050;
})();
if(cljs.core.truth_(inst_25886__$1)){
var statearr_26051_26110 = state_26015__$1;
(statearr_26051_26110[(1)] = (14));

} else {
var statearr_26052_26111 = state_26015__$1;
(statearr_26052_26111[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (2))){
var inst_25827 = (state_26015[(28)]);
var _ = (function (){var statearr_26053 = state_26015;
(statearr_26053[(4)] = cljs.core.cons((5),(state_26015[(4)])));

return statearr_26053;
})();
var inst_25826 = cljs.core.first(flakes);
var inst_25827__$1 = inst_25826.t;
var inst_25828 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25829 = (inst_25828 - (1));
var inst_25830 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25827__$1,inst_25829);
var state_26015__$1 = (function (){var statearr_26054 = state_26015;
(statearr_26054[(28)] = inst_25827__$1);

return statearr_26054;
})();
if(inst_25830){
var statearr_26055_26112 = state_26015__$1;
(statearr_26055_26112[(1)] = (6));

} else {
var statearr_26056_26113 = state_26015__$1;
(statearr_26056_26113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (23))){
var inst_25858 = (state_26015[(11)]);
var state_26015__$1 = state_26015;
var statearr_26057_26114 = state_26015__$1;
(statearr_26057_26114[(2)] = inst_25858);

(statearr_26057_26114[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (35))){
var inst_25939 = (state_26015[(14)]);
var state_26015__$1 = state_26015;
var statearr_26058_26115 = state_26015__$1;
(statearr_26058_26115[(2)] = inst_25939);

(statearr_26058_26115[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (19))){
var inst_26010 = (state_26015[(2)]);
var _ = (function (){var statearr_26059 = state_26015;
(statearr_26059[(4)] = cljs.core.rest((state_26015[(4)])));

return statearr_26059;
})();
var state_26015__$1 = state_26015;
var statearr_26060_26116 = state_26015__$1;
(statearr_26060_26116[(2)] = inst_26010);

(statearr_26060_26116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (11))){
var inst_25867 = (state_26015[(25)]);
var inst_25867__$1 = (state_26015[(2)]);
var inst_25875 = cljs.core.seq(inst_25867__$1);
var inst_25876 = cljs.core.first(inst_25875);
var inst_25877 = cljs.core.next(inst_25875);
var inst_25878 = db;
var inst_25879 = inst_25867__$1;
var inst_25880 = inst_25878;
var state_26015__$1 = (function (){var statearr_26062 = state_26015;
(statearr_26062[(25)] = inst_25867__$1);

(statearr_26062[(22)] = inst_25880);

(statearr_26062[(39)] = inst_25876);

(statearr_26062[(40)] = inst_25877);

(statearr_26062[(37)] = inst_25879);

return statearr_26062;
})();
var statearr_26063_26117 = state_26015__$1;
(statearr_26063_26117[(2)] = null);

(statearr_26063_26117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (9))){
var inst_25861 = (state_26015[(30)]);
var inst_25844 = (state_26015[(31)]);
var inst_25863 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_25844,inst_25861);
var state_26015__$1 = state_26015;
var statearr_26064_26118 = state_26015__$1;
(statearr_26064_26118[(2)] = inst_25863);

(statearr_26064_26118[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (5))){
var _ = (function (){var statearr_26065 = state_26015;
(statearr_26065[(4)] = cljs.core.rest((state_26015[(4)])));

return statearr_26065;
})();
var state_26015__$1 = state_26015;
var ex26061 = (state_26015__$1[(2)]);
var statearr_26066_26119 = state_26015__$1;
(statearr_26066_26119[(5)] = ex26061);


if((ex26061 instanceof Error)){
var statearr_26067_26120 = state_26015__$1;
(statearr_26067_26120[(1)] = (4));

(statearr_26067_26120[(5)] = null);

} else {
throw ex26061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (14))){
var inst_25886 = (state_26015[(38)]);
var inst_25880 = (state_26015[(22)]);
var inst_25889 = fluree.db.graphdb.add_predicate_to_idx(inst_25880,inst_25886);
var state_26015__$1 = state_26015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26015__$1,(17),inst_25889);
} else {
if((state_val_26016 === (26))){
var inst_25959 = (state_26015[(15)]);
var inst_25967 = fluree.db.query.schema.schema_map(inst_25959);
var state_26015__$1 = state_26015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26015__$1,(29),inst_25967);
} else {
if((state_val_26016 === (16))){
var inst_25896 = (state_26015[(2)]);
var state_26015__$1 = state_26015;
var statearr_26068_26121 = state_26015__$1;
(statearr_26068_26121[(2)] = inst_25896);

(statearr_26068_26121[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (38))){
var inst_25940 = (state_26015[(13)]);
var state_26015__$1 = state_26015;
var statearr_26069_26122 = state_26015__$1;
(statearr_26069_26122[(2)] = inst_25940);

(statearr_26069_26122[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (30))){
var inst_25974 = (state_26015[(35)]);
var inst_25977 = fluree.db.query.schema.setting_map(inst_25974);
var state_26015__$1 = state_26015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26015__$1,(33),inst_25977);
} else {
if((state_val_26016 === (10))){
var inst_25865 = cljs.core.PersistentVector.EMPTY;
var state_26015__$1 = state_26015;
var statearr_26070_26123 = state_26015__$1;
(statearr_26070_26123[(2)] = inst_25865);

(statearr_26070_26123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (18))){
var inst_25947 = (state_26015[(23)]);
var inst_25936 = (state_26015[(21)]);
var inst_25946 = cljs.core.seq(inst_25936);
var inst_25947__$1 = cljs.core.first(inst_25946);
var inst_25948 = cljs.core.next(inst_25946);
var inst_25949 = cljs.core.not(inst_25947__$1);
var state_26015__$1 = (function (){var statearr_26071 = state_26015;
(statearr_26071[(23)] = inst_25947__$1);

(statearr_26071[(19)] = inst_25948);

return statearr_26071;
})();
if(inst_25949){
var statearr_26072_26124 = state_26015__$1;
(statearr_26072_26124[(1)] = (20));

} else {
var statearr_26073_26125 = state_26015__$1;
(statearr_26073_26125[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (37))){
var inst_25947 = (state_26015[(23)]);
var inst_25940 = (state_26015[(13)]);
var inst_26002 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25940,inst_25947);
var state_26015__$1 = state_26015;
var statearr_26074_26126 = state_26015__$1;
(statearr_26074_26126[(2)] = inst_26002);

(statearr_26074_26126[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26016 === (8))){
var inst_25842 = (state_26015[(27)]);
var inst_25858 = (state_26015[(11)]);
var inst_25827 = (state_26015[(28)]);
var inst_25852 = (state_26015[(29)]);
var inst_25844 = (state_26015[(31)]);
var inst_25848 = (state_26015[(32)]);
var inst_25842__$1 = (state_26015[(2)]);
var inst_25843 = (function (){var t = inst_25827;
var _ = inst_25842__$1;
return (function (p1__25817_SHARP_){
return cljs.core.not((function (){var G__26075 = p1__25817_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26075) : fluree.db.graphdb.exclude_predicates.call(null,G__26075));
})());
});
})();
var inst_25844__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_25843,flakes);
var inst_25845 = cljs.core.PersistentHashSet.EMPTY;
var inst_25846 = (function (){var t = inst_25827;
var _ = inst_25842__$1;
var add_flakes = inst_25844__$1;
return (function (p1__25818_SHARP_){
return p1__25818_SHARP_.p;
});
})();
var inst_25847 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25846,inst_25844__$1);
var inst_25848__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25845,inst_25847);
var inst_25849 = cljs.core.PersistentHashMap.EMPTY;
var inst_25850 = (function (){var t = inst_25827;
var _ = inst_25842__$1;
var add_flakes = inst_25844__$1;
var add_preds = inst_25848__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25851 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25850,inst_25848__$1);
var inst_25852__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25849,inst_25851);
var inst_25853 = cljs.core.PersistentHashMap.EMPTY;
var inst_25854 = (function (){var t = inst_25827;
var _ = inst_25842__$1;
var add_flakes = inst_25844__$1;
var add_preds = inst_25848__$1;
var idx_QMARK__map = inst_25852__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25855 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25854,inst_25848__$1);
var inst_25856 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25853,inst_25855);
var inst_25857 = fluree.db.flake.size_bytes(inst_25844__$1);
var inst_25858__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_25844__$1);
var inst_25859 = fluree.db.util.schema.setting_change_QMARK_(inst_25844__$1);
var inst_25860 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25861 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25860,(0));
var state_26015__$1 = (function (){var statearr_26076 = state_26015;
(statearr_26076[(24)] = inst_25859);

(statearr_26076[(27)] = inst_25842__$1);

(statearr_26076[(11)] = inst_25858__$1);

(statearr_26076[(12)] = inst_25857);

(statearr_26076[(29)] = inst_25852__$1);

(statearr_26076[(30)] = inst_25861);

(statearr_26076[(31)] = inst_25844__$1);

(statearr_26076[(32)] = inst_25848__$1);

(statearr_26076[(34)] = inst_25856);

return statearr_26076;
})();
if(cljs.core.truth_(inst_25858__$1)){
var statearr_26077_26127 = state_26015__$1;
(statearr_26077_26127[(1)] = (9));

} else {
var statearr_26078_26128 = state_26015__$1;
(statearr_26078_26128[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2414__auto____0 = (function (){
var statearr_26079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26079[(0)] = fluree$db$graphdb$with_t_$_state_machine__2414__auto__);

(statearr_26079[(1)] = (1));

return statearr_26079;
});
var fluree$db$graphdb$with_t_$_state_machine__2414__auto____1 = (function (state_26015){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26015);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26080){var ex__2417__auto__ = e26080;
var statearr_26081_26129 = state_26015;
(statearr_26081_26129[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26015[(4)]))){
var statearr_26082_26130 = state_26015;
(statearr_26082_26130[(1)] = cljs.core.first((state_26015[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26131 = state_26015;
state_26015 = G__26131;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2414__auto__ = function(state_26015){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2414__auto____1.call(this,state_26015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2414__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2414__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26083 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26083[(6)] = c__2436__auto__);

return statearr_26083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___26277 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26227){
var state_val_26228 = (state_26227[(1)]);
if((state_val_26228 === (7))){
var state_26227__$1 = state_26227;
var statearr_26229_26278 = state_26227__$1;
(statearr_26229_26278[(2)] = null);

(statearr_26229_26278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (20))){
var inst_26177 = (state_26227[(7)]);
var inst_26176 = (state_26227[(8)]);
var inst_26175 = (state_26227[(9)]);
var inst_26196 = (inst_26175 + (1));
var inst_26197 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26177,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26196);
var inst_26198 = fluree.db.graphdb.with_t(inst_26197,inst_26176);
var state_26227__$1 = state_26227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26227__$1,(23),inst_26198);
} else {
if((state_val_26228 === (1))){
var state_26227__$1 = state_26227;
var statearr_26230_26279 = state_26227__$1;
(statearr_26230_26279[(2)] = null);

(statearr_26230_26279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (24))){
var inst_26201 = (state_26227[(10)]);
var inst_26204 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26201,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26227__$1 = state_26227;
var statearr_26231_26280 = state_26227__$1;
(statearr_26231_26280[(2)] = inst_26204);

(statearr_26231_26280[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (4))){
var inst_26132 = (state_26227[(2)]);
var inst_26133 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26132);
var state_26227__$1 = state_26227;
var statearr_26232_26281 = state_26227__$1;
(statearr_26232_26281[(2)] = inst_26133);

(statearr_26232_26281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (15))){
var inst_26183 = (state_26227[(11)]);
var state_26227__$1 = state_26227;
var statearr_26233_26282 = state_26227__$1;
(statearr_26233_26282[(2)] = inst_26183);

(statearr_26233_26282[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (21))){
var state_26227__$1 = state_26227;
var statearr_26234_26283 = state_26227__$1;
(statearr_26234_26283[(2)] = null);

(statearr_26234_26283[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (13))){
var inst_26219 = (state_26227[(2)]);
var inst_26220 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26219);
var state_26227__$1 = state_26227;
var statearr_26235_26284 = state_26227__$1;
(statearr_26235_26284[(2)] = inst_26220);

(statearr_26235_26284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (22))){
var inst_26215 = (state_26227[(2)]);
var state_26227__$1 = state_26227;
var statearr_26236_26285 = state_26227__$1;
(statearr_26236_26285[(2)] = inst_26215);

(statearr_26236_26285[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (6))){
var inst_26143 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26144 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26145 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26143)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26144)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26146 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26147 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26148 = cljs.core.PersistentHashMap.fromArrays(inst_26146,inst_26147);
var inst_26149 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26145,inst_26148);
var inst_26150 = (function(){throw inst_26149})();
var state_26227__$1 = state_26227;
var statearr_26239_26286 = state_26227__$1;
(statearr_26239_26286[(2)] = inst_26150);

(statearr_26239_26286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (25))){
var inst_26184 = (state_26227[(12)]);
var inst_26183 = (state_26227[(11)]);
var inst_26201 = (state_26227[(10)]);
var inst_26206 = inst_26183.t;
var inst_26207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26208 = [inst_26183];
var inst_26209 = (new cljs.core.PersistentVector(null,1,(5),inst_26207,inst_26208,null));
var inst_26174 = inst_26184;
var inst_26175 = inst_26206;
var inst_26176 = inst_26209;
var inst_26177 = inst_26201;
var state_26227__$1 = (function (){var statearr_26240 = state_26227;
(statearr_26240[(13)] = inst_26174);

(statearr_26240[(7)] = inst_26177);

(statearr_26240[(8)] = inst_26176);

(statearr_26240[(9)] = inst_26175);

return statearr_26240;
})();
var statearr_26241_26287 = state_26227__$1;
(statearr_26241_26287[(2)] = null);

(statearr_26241_26287[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (17))){
var inst_26184 = (state_26227[(12)]);
var inst_26183 = (state_26227[(11)]);
var inst_26177 = (state_26227[(7)]);
var inst_26176 = (state_26227[(8)]);
var inst_26175 = (state_26227[(9)]);
var inst_26192 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26176,inst_26183);
var tmp26237 = inst_26177;
var tmp26238 = inst_26175;
var inst_26174 = inst_26184;
var inst_26175__$1 = tmp26238;
var inst_26176__$1 = inst_26192;
var inst_26177__$1 = tmp26237;
var state_26227__$1 = (function (){var statearr_26242 = state_26227;
(statearr_26242[(13)] = inst_26174);

(statearr_26242[(7)] = inst_26177__$1);

(statearr_26242[(8)] = inst_26176__$1);

(statearr_26242[(9)] = inst_26175__$1);

return statearr_26242;
})();
var statearr_26243_26288 = state_26227__$1;
(statearr_26243_26288[(2)] = null);

(statearr_26243_26288[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (3))){
var inst_26225 = (state_26227[(2)]);
var state_26227__$1 = state_26227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26227__$1,inst_26225);
} else {
if((state_val_26228 === (12))){
var inst_26183 = (state_26227[(11)]);
var inst_26174 = (state_26227[(13)]);
var inst_26182 = cljs.core.seq(inst_26174);
var inst_26183__$1 = cljs.core.first(inst_26182);
var inst_26184 = cljs.core.next(inst_26182);
var state_26227__$1 = (function (){var statearr_26244 = state_26227;
(statearr_26244[(12)] = inst_26184);

(statearr_26244[(11)] = inst_26183__$1);

return statearr_26244;
})();
if(cljs.core.truth_(inst_26183__$1)){
var statearr_26245_26289 = state_26227__$1;
(statearr_26245_26289[(1)] = (14));

} else {
var statearr_26246_26290 = state_26227__$1;
(statearr_26246_26290[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (2))){
var _ = (function (){var statearr_26247 = state_26227;
(statearr_26247[(4)] = cljs.core.cons((5),(state_26227[(4)])));

return statearr_26247;
})();
var inst_26139 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26140 = (inst_26139 + (1));
var inst_26141 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26140);
var state_26227__$1 = state_26227;
if(inst_26141){
var statearr_26248_26291 = state_26227__$1;
(statearr_26248_26291[(1)] = (6));

} else {
var statearr_26249_26292 = state_26227__$1;
(statearr_26249_26292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (23))){
var inst_26183 = (state_26227[(11)]);
var inst_26200 = (state_26227[(2)]);
var inst_26201 = fluree.db.util.async.throw_err(inst_26200);
var inst_26202 = (inst_26183 == null);
var state_26227__$1 = (function (){var statearr_26250 = state_26227;
(statearr_26250[(10)] = inst_26201);

return statearr_26250;
})();
if(cljs.core.truth_(inst_26202)){
var statearr_26251_26293 = state_26227__$1;
(statearr_26251_26293[(1)] = (24));

} else {
var statearr_26252_26294 = state_26227__$1;
(statearr_26252_26294[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (19))){
var inst_26217 = (state_26227[(2)]);
var state_26227__$1 = state_26227;
var statearr_26253_26295 = state_26227__$1;
(statearr_26253_26295[(2)] = inst_26217);

(statearr_26253_26295[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (11))){
var inst_26222 = (state_26227[(2)]);
var _ = (function (){var statearr_26255 = state_26227;
(statearr_26255[(4)] = cljs.core.rest((state_26227[(4)])));

return statearr_26255;
})();
var state_26227__$1 = state_26227;
var statearr_26256_26296 = state_26227__$1;
(statearr_26256_26296[(2)] = inst_26222);

(statearr_26256_26296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (9))){
var inst_26156 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26157 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26156);
var state_26227__$1 = state_26227;
var statearr_26257_26297 = state_26227__$1;
(statearr_26257_26297[(2)] = inst_26157);

(statearr_26257_26297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (5))){
var _ = (function (){var statearr_26258 = state_26227;
(statearr_26258[(4)] = cljs.core.rest((state_26227[(4)])));

return statearr_26258;
})();
var state_26227__$1 = state_26227;
var ex26254 = (state_26227__$1[(2)]);
var statearr_26259_26298 = state_26227__$1;
(statearr_26259_26298[(5)] = ex26254);


var statearr_26260_26299 = state_26227__$1;
(statearr_26260_26299[(1)] = (4));

(statearr_26260_26299[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (14))){
var inst_26183 = (state_26227[(11)]);
var inst_26175 = (state_26227[(9)]);
var inst_26186 = inst_26183.t;
var inst_26187 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26175,inst_26186);
var state_26227__$1 = state_26227;
var statearr_26261_26300 = state_26227__$1;
(statearr_26261_26300[(2)] = inst_26187);

(statearr_26261_26300[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (26))){
var inst_26212 = (state_26227[(2)]);
var state_26227__$1 = state_26227;
var statearr_26262_26301 = state_26227__$1;
(statearr_26262_26301[(2)] = inst_26212);

(statearr_26262_26301[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (16))){
var inst_26190 = (state_26227[(2)]);
var state_26227__$1 = state_26227;
if(cljs.core.truth_(inst_26190)){
var statearr_26263_26302 = state_26227__$1;
(statearr_26263_26302[(1)] = (17));

} else {
var statearr_26264_26303 = state_26227__$1;
(statearr_26264_26303[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (10))){
var inst_26159 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26167 = cljs.core.seq(inst_26159);
var inst_26168 = cljs.core.first(inst_26167);
var inst_26169 = cljs.core.next(inst_26167);
var inst_26170 = cljs.core.first(inst_26159);
var inst_26171 = inst_26170.t;
var inst_26172 = cljs.core.PersistentVector.EMPTY;
var inst_26173 = db;
var inst_26174 = inst_26159;
var inst_26175 = inst_26171;
var inst_26176 = inst_26172;
var inst_26177 = inst_26173;
var state_26227__$1 = (function (){var statearr_26265 = state_26227;
(statearr_26265[(14)] = inst_26168);

(statearr_26265[(13)] = inst_26174);

(statearr_26265[(7)] = inst_26177);

(statearr_26265[(15)] = inst_26169);

(statearr_26265[(8)] = inst_26176);

(statearr_26265[(9)] = inst_26175);

return statearr_26265;
})();
var statearr_26266_26304 = state_26227__$1;
(statearr_26266_26304[(2)] = null);

(statearr_26266_26304[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (18))){
var state_26227__$1 = state_26227;
var statearr_26267_26305 = state_26227__$1;
(statearr_26267_26305[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26228 === (8))){
var inst_26153 = (state_26227[(2)]);
var inst_26154 = cljs.core.empty_QMARK_(flakes);
var state_26227__$1 = (function (){var statearr_26269 = state_26227;
(statearr_26269[(16)] = inst_26153);

return statearr_26269;
})();
if(inst_26154){
var statearr_26270_26306 = state_26227__$1;
(statearr_26270_26306[(1)] = (9));

} else {
var statearr_26271_26307 = state_26227__$1;
(statearr_26271_26307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2414__auto____0 = (function (){
var statearr_26272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26272[(0)] = fluree$db$graphdb$with_$_state_machine__2414__auto__);

(statearr_26272[(1)] = (1));

return statearr_26272;
});
var fluree$db$graphdb$with_$_state_machine__2414__auto____1 = (function (state_26227){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26227);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26273){var ex__2417__auto__ = e26273;
var statearr_26274_26308 = state_26227;
(statearr_26274_26308[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26227[(4)]))){
var statearr_26275_26309 = state_26227;
(statearr_26275_26309[(1)] = cljs.core.first((state_26227[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26310 = state_26227;
state_26227 = G__26310;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2414__auto__ = function(state_26227){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2414__auto____1.call(this,state_26227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2414__auto____0;
fluree$db$graphdb$with_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2414__auto____1;
return fluree$db$graphdb$with_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26276 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26276[(6)] = c__2436__auto___26277);

return statearr_26276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26366){
var state_val_26367 = (state_26366[(1)]);
if((state_val_26367 === (7))){
var state_26366__$1 = state_26366;
var statearr_26368_26395 = state_26366__$1;
(statearr_26368_26395[(2)] = tt_id);

(statearr_26368_26395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (1))){
var state_26366__$1 = state_26366;
var statearr_26369_26396 = state_26366__$1;
(statearr_26369_26396[(2)] = null);

(statearr_26369_26396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (4))){
var inst_26311 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26370_26397 = state_26366__$1;
(statearr_26370_26397[(2)] = inst_26311);

(statearr_26370_26397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (13))){
var inst_26359 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26371_26398 = state_26366__$1;
(statearr_26371_26398[(2)] = inst_26359);

(statearr_26371_26398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (6))){
var inst_26319 = fluree.db.util.core.random_uuid();
var state_26366__$1 = state_26366;
var statearr_26372_26399 = state_26366__$1;
(statearr_26372_26399[(2)] = inst_26319);

(statearr_26372_26399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (3))){
var inst_26364 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26366__$1,inst_26364);
} else {
if((state_val_26367 === (12))){
var inst_26342 = (state_26366[(7)]);
var state_26366__$1 = state_26366;
var statearr_26373_26400 = state_26366__$1;
(statearr_26373_26400[(2)] = inst_26342);

(statearr_26373_26400[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (2))){
var _ = (function (){var statearr_26374 = state_26366;
(statearr_26374[(4)] = cljs.core.cons((5),(state_26366[(4)])));

return statearr_26374;
})();
var inst_26317 = (tt_id == null);
var state_26366__$1 = state_26366;
if(cljs.core.truth_(inst_26317)){
var statearr_26375_26401 = state_26366__$1;
(statearr_26375_26401[(1)] = (6));

} else {
var statearr_26376_26402 = state_26366__$1;
(statearr_26376_26402[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (11))){
var inst_26342 = (state_26366[(7)]);
var inst_26349 = (state_26366[(8)]);
var inst_26352 = fluree.db.graphdb.with_t(inst_26342,inst_26349);
var state_26366__$1 = state_26366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26366__$1,(14),inst_26352);
} else {
if((state_val_26367 === (9))){
var inst_26349 = (state_26366[(8)]);
var inst_26343 = (state_26366[(9)]);
var inst_26348 = cljs.core.seq(inst_26343);
var inst_26349__$1 = cljs.core.first(inst_26348);
var inst_26350 = cljs.core.next(inst_26348);
var state_26366__$1 = (function (){var statearr_26378 = state_26366;
(statearr_26378[(8)] = inst_26349__$1);

(statearr_26378[(10)] = inst_26350);

return statearr_26378;
})();
if(cljs.core.truth_(inst_26349__$1)){
var statearr_26379_26403 = state_26366__$1;
(statearr_26379_26403[(1)] = (11));

} else {
var statearr_26380_26404 = state_26366__$1;
(statearr_26380_26404[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (5))){
var _ = (function (){var statearr_26381 = state_26366;
(statearr_26381[(4)] = cljs.core.rest((state_26366[(4)])));

return statearr_26381;
})();
var state_26366__$1 = state_26366;
var ex26377 = (state_26366__$1[(2)]);
var statearr_26382_26405 = state_26366__$1;
(statearr_26382_26405[(5)] = ex26377);


if((ex26377 instanceof Error)){
var statearr_26383_26406 = state_26366__$1;
(statearr_26383_26406[(1)] = (4));

(statearr_26383_26406[(5)] = null);

} else {
throw ex26377;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (14))){
var inst_26350 = (state_26366[(10)]);
var inst_26354 = (state_26366[(2)]);
var inst_26355 = fluree.db.util.async.throw_err(inst_26354);
var inst_26342 = inst_26355;
var inst_26343 = inst_26350;
var state_26366__$1 = (function (){var statearr_26384 = state_26366;
(statearr_26384[(7)] = inst_26342);

(statearr_26384[(9)] = inst_26343);

return statearr_26384;
})();
var statearr_26385_26407 = state_26366__$1;
(statearr_26385_26407[(2)] = null);

(statearr_26385_26407[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (10))){
var inst_26361 = (state_26366[(2)]);
var _ = (function (){var statearr_26386 = state_26366;
(statearr_26386[(4)] = cljs.core.rest((state_26366[(4)])));

return statearr_26386;
})();
var state_26366__$1 = state_26366;
var statearr_26387_26408 = state_26366__$1;
(statearr_26387_26408[(2)] = inst_26361);

(statearr_26387_26408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26367 === (8))){
var inst_26322 = (state_26366[(2)]);
var inst_26323 = (function (){var tt_id_SINGLEQUOTE_ = inst_26322;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26322);
var inst_26325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26326 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26327 = (new cljs.core.PersistentVector(null,4,(5),inst_26325,inst_26326,null));
var inst_26328 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26323,inst_26324,inst_26327);
var inst_26329 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26330 = cljs.core.reverse(inst_26329);
var inst_26331 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26330);
var inst_26339 = cljs.core.seq(inst_26331);
var inst_26340 = cljs.core.first(inst_26339);
var inst_26341 = cljs.core.next(inst_26339);
var inst_26342 = inst_26328;
var inst_26343 = inst_26331;
var state_26366__$1 = (function (){var statearr_26388 = state_26366;
(statearr_26388[(7)] = inst_26342);

(statearr_26388[(9)] = inst_26343);

(statearr_26388[(11)] = inst_26341);

(statearr_26388[(12)] = inst_26340);

return statearr_26388;
})();
var statearr_26389_26409 = state_26366__$1;
(statearr_26389_26409[(2)] = null);

(statearr_26389_26409[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0 = (function (){
var statearr_26390 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26390[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__);

(statearr_26390[(1)] = (1));

return statearr_26390;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1 = (function (state_26366){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26366);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26391){var ex__2417__auto__ = e26391;
var statearr_26392_26410 = state_26366;
(statearr_26392_26410[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26366[(4)]))){
var statearr_26393_26411 = state_26366;
(statearr_26393_26411[(1)] = cljs.core.first((state_26366[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26412 = state_26366;
state_26366 = G__26412;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__ = function(state_26366){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1.call(this,state_26366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26394 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26394[(6)] = c__2436__auto__);

return statearr_26394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___26590 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26527){
var state_val_26528 = (state_26527[(1)]);
if((state_val_26528 === (7))){
var inst_26440 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_26441 = cljs.core.first(ident);
var inst_26442 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26441);
var inst_26443 = (inst_26442 == null);
var inst_26444 = ((inst_26440) && (inst_26443));
var state_26527__$1 = state_26527;
if(cljs.core.truth_(inst_26444)){
var statearr_26529_26591 = state_26527__$1;
(statearr_26529_26591[(1)] = (13));

} else {
var statearr_26530_26592 = state_26527__$1;
(statearr_26530_26592[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (20))){
var state_26527__$1 = state_26527;
var statearr_26531_26593 = state_26527__$1;
(statearr_26531_26593[(2)] = null);

(statearr_26531_26593[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (27))){
var state_26527__$1 = state_26527;
var statearr_26532_26594 = state_26527__$1;
(statearr_26532_26594[(2)] = null);

(statearr_26532_26594[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (1))){
var state_26527__$1 = state_26527;
var statearr_26533_26595 = state_26527__$1;
(statearr_26533_26595[(2)] = null);

(statearr_26533_26595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (24))){
var inst_26473 = (state_26527[(7)]);
var inst_26477 = inst_26473.s;
var state_26527__$1 = state_26527;
var statearr_26534_26596 = state_26527__$1;
(statearr_26534_26596[(2)] = inst_26477);

(statearr_26534_26596[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (39))){
var state_26527__$1 = state_26527;
var statearr_26535_26597 = state_26527__$1;
(statearr_26535_26597[(2)] = null);

(statearr_26535_26597[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (4))){
var inst_26413 = (state_26527[(2)]);
var inst_26414 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26415 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26416 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26417 = cljs.core.PersistentHashMap.fromArrays(inst_26415,inst_26416);
var inst_26418 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26414,inst_26417,inst_26413);
var inst_26419 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26418);
var state_26527__$1 = state_26527;
var statearr_26536_26598 = state_26527__$1;
(statearr_26536_26598[(2)] = inst_26419);

(statearr_26536_26598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (15))){
var inst_26495 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26537_26599 = state_26527__$1;
(statearr_26537_26599[(2)] = inst_26495);

(statearr_26537_26599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (21))){
var inst_26467 = (state_26527[(8)]);
var inst_26471 = cljs.core.first(inst_26467);
var state_26527__$1 = state_26527;
var statearr_26538_26600 = state_26527__$1;
(statearr_26538_26600[(2)] = inst_26471);

(statearr_26538_26600[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (31))){
var inst_26522 = (state_26527[(2)]);
var _ = (function (){var statearr_26539 = state_26527;
(statearr_26539[(4)] = cljs.core.rest((state_26527[(4)])));

return statearr_26539;
})();
var state_26527__$1 = state_26527;
var statearr_26540_26601 = state_26527__$1;
(statearr_26540_26601[(2)] = inst_26522);

(statearr_26540_26601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (32))){
var state_26527__$1 = state_26527;
var statearr_26541_26602 = state_26527__$1;
(statearr_26541_26602[(2)] = strict_QMARK_);

(statearr_26541_26602[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (40))){
var inst_26518 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26542_26603 = state_26527__$1;
(statearr_26542_26603[(2)] = inst_26518);

(statearr_26542_26603[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (33))){
var state_26527__$1 = state_26527;
var statearr_26543_26604 = state_26527__$1;
(statearr_26543_26604[(2)] = false);

(statearr_26543_26604[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (13))){
var inst_26446 = cljs.core.first(ident);
var inst_26447 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26446], 0));
var inst_26448 = ["Subject ID lookup failed. The predicate ",inst_26447," does not exist."].join('');
var inst_26449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26450 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26451 = cljs.core.PersistentHashMap.fromArrays(inst_26449,inst_26450);
var inst_26452 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26448,inst_26451);
var inst_26453 = (function(){throw inst_26452})();
var state_26527__$1 = state_26527;
var statearr_26544_26605 = state_26527__$1;
(statearr_26544_26605[(2)] = inst_26453);

(statearr_26544_26605[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (22))){
var inst_26473 = (state_26527[(7)]);
var inst_26473__$1 = (state_26527[(2)]);
var inst_26474 = (inst_26473__$1 == null);
var state_26527__$1 = (function (){var statearr_26545 = state_26527;
(statearr_26545[(7)] = inst_26473__$1);

return statearr_26545;
})();
if(cljs.core.truth_(inst_26474)){
var statearr_26546_26606 = state_26527__$1;
(statearr_26546_26606[(1)] = (23));

} else {
var statearr_26547_26607 = state_26527__$1;
(statearr_26547_26607[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (36))){
var state_26527__$1 = state_26527;
var statearr_26548_26608 = state_26527__$1;
(statearr_26548_26608[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (29))){
var inst_26497 = (state_26527[(9)]);
var inst_26499 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26497);
var state_26527__$1 = state_26527;
var statearr_26550_26609 = state_26527__$1;
(statearr_26550_26609[(2)] = inst_26499);

(statearr_26550_26609[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (6))){
var inst_26427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26428 = [ident];
var inst_26429 = (new cljs.core.PersistentVector(null,1,(5),inst_26427,inst_26428,null));
var inst_26430 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26429);
var state_26527__$1 = state_26527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26527__$1,(9),inst_26430);
} else {
if((state_val_26528 === (28))){
var inst_26491 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26551_26610 = state_26527__$1;
(statearr_26551_26610[(2)] = inst_26491);

(statearr_26551_26610[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (25))){
var inst_26479 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26552_26611 = state_26527__$1;
(statearr_26552_26611[(2)] = inst_26479);

(statearr_26552_26611[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (34))){
var inst_26505 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
if(cljs.core.truth_(inst_26505)){
var statearr_26553_26612 = state_26527__$1;
(statearr_26553_26612[(1)] = (35));

} else {
var statearr_26554_26613 = state_26527__$1;
(statearr_26554_26613[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (17))){
var state_26527__$1 = state_26527;
var statearr_26555_26614 = state_26527__$1;
(statearr_26555_26614[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (3))){
var inst_26525 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26527__$1,inst_26525);
} else {
if((state_val_26528 === (12))){
var inst_26438 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26557_26615 = state_26527__$1;
(statearr_26557_26615[(2)] = inst_26438);

(statearr_26557_26615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (2))){
var _ = (function (){var statearr_26558 = state_26527;
(statearr_26558[(4)] = cljs.core.cons((5),(state_26527[(4)])));

return statearr_26558;
})();
var inst_26425 = typeof ident === 'number';
var state_26527__$1 = state_26527;
if(cljs.core.truth_(inst_26425)){
var statearr_26559_26616 = state_26527__$1;
(statearr_26559_26616[(1)] = (6));

} else {
var statearr_26560_26617 = state_26527__$1;
(statearr_26560_26617[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (23))){
var state_26527__$1 = state_26527;
var statearr_26561_26618 = state_26527__$1;
(statearr_26561_26618[(2)] = null);

(statearr_26561_26618[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (35))){
var inst_26507 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26508 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26509 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26510 = cljs.core.PersistentHashMap.fromArrays(inst_26508,inst_26509);
var inst_26511 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26507,inst_26510);
var inst_26512 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26511);
var state_26527__$1 = state_26527;
var statearr_26562_26619 = state_26527__$1;
(statearr_26562_26619[(2)] = inst_26512);

(statearr_26562_26619[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (19))){
var inst_26467 = (state_26527[(8)]);
var inst_26466 = (state_26527[(2)]);
var inst_26467__$1 = fluree.db.util.async.throw_err(inst_26466);
var inst_26468 = (inst_26467__$1 == null);
var state_26527__$1 = (function (){var statearr_26563 = state_26527;
(statearr_26563[(8)] = inst_26467__$1);

return statearr_26563;
})();
if(cljs.core.truth_(inst_26468)){
var statearr_26564_26620 = state_26527__$1;
(statearr_26564_26620[(1)] = (20));

} else {
var statearr_26565_26621 = state_26527__$1;
(statearr_26565_26621[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (11))){
var state_26527__$1 = state_26527;
var statearr_26567_26622 = state_26527__$1;
(statearr_26567_26622[(2)] = null);

(statearr_26567_26622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (9))){
var inst_26432 = (state_26527[(2)]);
var inst_26433 = fluree.db.util.async.throw_err(inst_26432);
var inst_26434 = cljs.core.not_empty(inst_26433);
var state_26527__$1 = state_26527;
if(cljs.core.truth_(inst_26434)){
var statearr_26568_26623 = state_26527__$1;
(statearr_26568_26623[(1)] = (10));

} else {
var statearr_26569_26624 = state_26527__$1;
(statearr_26569_26624[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (5))){
var _ = (function (){var statearr_26570 = state_26527;
(statearr_26570[(4)] = cljs.core.rest((state_26527[(4)])));

return statearr_26570;
})();
var state_26527__$1 = state_26527;
var ex26566 = (state_26527__$1[(2)]);
var statearr_26571_26625 = state_26527__$1;
(statearr_26571_26625[(5)] = ex26566);


var statearr_26572_26626 = state_26527__$1;
(statearr_26572_26626[(1)] = (4));

(statearr_26572_26626[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (14))){
var inst_26455 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26527__$1 = state_26527;
if(inst_26455){
var statearr_26573_26627 = state_26527__$1;
(statearr_26573_26627[(1)] = (16));

} else {
var statearr_26574_26628 = state_26527__$1;
(statearr_26574_26628[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (26))){
var inst_26482 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_26483 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26482].join('');
var inst_26484 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26485 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26486 = cljs.core.PersistentHashMap.fromArrays(inst_26484,inst_26485);
var inst_26487 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26483,inst_26486);
var inst_26488 = (function(){throw inst_26487})();
var state_26527__$1 = state_26527;
var statearr_26575_26629 = state_26527__$1;
(statearr_26575_26629[(2)] = inst_26488);

(statearr_26575_26629[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (16))){
var inst_26458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26459 = cljs.core.first(ident);
var inst_26460 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26459);
var inst_26461 = cljs.core.second(ident);
var inst_26462 = [inst_26460,inst_26461];
var inst_26463 = (new cljs.core.PersistentVector(null,2,(5),inst_26458,inst_26462,null));
var inst_26464 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26463);
var state_26527__$1 = state_26527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26527__$1,(19),inst_26464);
} else {
if((state_val_26528 === (38))){
var inst_26515 = cljs.core.async.close_BANG_(return_chan);
var state_26527__$1 = state_26527;
var statearr_26576_26630 = state_26527__$1;
(statearr_26576_26630[(2)] = inst_26515);

(statearr_26576_26630[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (30))){
var inst_26497 = (state_26527[(9)]);
var inst_26501 = (inst_26497 == null);
var state_26527__$1 = state_26527;
if(cljs.core.truth_(inst_26501)){
var statearr_26577_26631 = state_26527__$1;
(statearr_26577_26631[(1)] = (32));

} else {
var statearr_26578_26632 = state_26527__$1;
(statearr_26578_26632[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (10))){
var state_26527__$1 = state_26527;
var statearr_26579_26633 = state_26527__$1;
(statearr_26579_26633[(2)] = ident);

(statearr_26579_26633[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (18))){
var inst_26493 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26580_26634 = state_26527__$1;
(statearr_26580_26634[(2)] = inst_26493);

(statearr_26580_26634[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (37))){
var inst_26520 = (state_26527[(2)]);
var state_26527__$1 = state_26527;
var statearr_26581_26635 = state_26527__$1;
(statearr_26581_26635[(2)] = inst_26520);

(statearr_26581_26635[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26528 === (8))){
var inst_26497 = (state_26527[(9)]);
var inst_26497__$1 = (state_26527[(2)]);
var state_26527__$1 = (function (){var statearr_26582 = state_26527;
(statearr_26582[(9)] = inst_26497__$1);

return statearr_26582;
})();
if(cljs.core.truth_(inst_26497__$1)){
var statearr_26583_26636 = state_26527__$1;
(statearr_26583_26636[(1)] = (29));

} else {
var statearr_26584_26637 = state_26527__$1;
(statearr_26584_26637[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2414__auto____0 = (function (){
var statearr_26585 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26585[(0)] = fluree$db$graphdb$subid_$_state_machine__2414__auto__);

(statearr_26585[(1)] = (1));

return statearr_26585;
});
var fluree$db$graphdb$subid_$_state_machine__2414__auto____1 = (function (state_26527){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26527);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26586){var ex__2417__auto__ = e26586;
var statearr_26587_26638 = state_26527;
(statearr_26587_26638[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26527[(4)]))){
var statearr_26588_26639 = state_26527;
(statearr_26588_26639[(1)] = cljs.core.first((state_26527[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26640 = state_26527;
state_26527 = G__26640;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2414__auto__ = function(state_26527){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2414__auto____1.call(this,state_26527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2414__auto____0;
fluree$db$graphdb$subid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2414__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26589 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26589[(6)] = c__2436__auto___26590);

return statearr_26589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k26642,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__26646 = k26642;
var G__26646__$1 = (((G__26646 instanceof cljs.core.Keyword))?G__26646.fqn:null);
switch (G__26646__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26642,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__26647){
var vec__26648 = p__26647;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26648,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26648,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26641){
var self__ = this;
var G__26641__$1 = this;
return (new cljs.core.RecordIter((0),G__26641__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__26651 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__26651(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26643,other26644){
var self__ = this;
var this26643__$1 = this;
return (((!((other26644 == null)))) && ((this26643__$1.constructor === other26644.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.conn,other26644.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.network,other26644.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.dbid,other26644.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.block,other26644.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.t,other26644.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.tt_id,other26644.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.stats,other26644.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.spot,other26644.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.psot,other26644.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.post,other26644.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.opst,other26644.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.schema,other26644.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.settings,other26644.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.index_configs,other26644.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.schema_cache,other26644.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.novelty,other26644.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.permissions,other26644.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.fork,other26644.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.fork_block,other26644.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.current_db_fn,other26644.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26643__$1.__extmap,other26644.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__26641){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__26652 = cljs.core.keyword_identical_QMARK_;
var expr__26653 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__26655 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__26656 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26655,G__26656) : pred__26652.call(null,G__26655,G__26656));
})())){
return (new fluree.db.graphdb.GraphDb(G__26641,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26657 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__26658 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26657,G__26658) : pred__26652.call(null,G__26657,G__26658));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26641,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26659 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__26660 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26659,G__26660) : pred__26652.call(null,G__26659,G__26660));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26641,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26661 = new cljs.core.Keyword(null,"block","block",664686210);
var G__26662 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26661,G__26662) : pred__26652.call(null,G__26661,G__26662));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__26641,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26663 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__26664 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26663,G__26664) : pred__26652.call(null,G__26663,G__26664));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__26641,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26665 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__26666 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26665,G__26666) : pred__26652.call(null,G__26665,G__26666));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__26641,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26667 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__26668 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26667,G__26668) : pred__26652.call(null,G__26667,G__26668));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__26641,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26669 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__26670 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26669,G__26670) : pred__26652.call(null,G__26669,G__26670));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__26641,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26671 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__26672 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26671,G__26672) : pred__26652.call(null,G__26671,G__26672));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26641,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26673 = new cljs.core.Keyword(null,"post","post",269697687);
var G__26674 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26673,G__26674) : pred__26652.call(null,G__26673,G__26674));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26641,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26675 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__26676 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26675,G__26676) : pred__26652.call(null,G__26675,G__26676));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26641,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26677 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__26678 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26677,G__26678) : pred__26652.call(null,G__26677,G__26678));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26641,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26679 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__26680 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26679,G__26680) : pred__26652.call(null,G__26679,G__26680));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__26641,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26681 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__26682 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26681,G__26682) : pred__26652.call(null,G__26681,G__26682));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__26641,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26683 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__26684 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26683,G__26684) : pred__26652.call(null,G__26683,G__26684));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__26641,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26685 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__26686 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26685,G__26686) : pred__26652.call(null,G__26685,G__26686));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__26641,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26687 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__26688 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26687,G__26688) : pred__26652.call(null,G__26687,G__26688));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__26641,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26689 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__26690 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26689,G__26690) : pred__26652.call(null,G__26689,G__26690));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__26641,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26691 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__26692 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26691,G__26692) : pred__26652.call(null,G__26691,G__26692));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26641,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26693 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__26694 = expr__26653;
return (pred__26652.cljs$core$IFn$_invoke$arity$2 ? pred__26652.cljs$core$IFn$_invoke$arity$2(G__26693,G__26694) : pred__26652.call(null,G__26693,G__26694));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26641,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__26641),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__26641){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26641,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26710){
var state_val_26711 = (state_26710[(1)]);
if((state_val_26711 === (1))){
var state_26710__$1 = state_26710;
var statearr_26712_26977 = state_26710__$1;
(statearr_26712_26977[(2)] = null);

(statearr_26712_26977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26711 === (2))){
var _ = (function (){var statearr_26713 = state_26710;
(statearr_26713[(4)] = cljs.core.cons((5),(state_26710[(4)])));

return statearr_26713;
})();
var inst_26701 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_26710__$1 = state_26710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26710__$1,(6),inst_26701);
} else {
if((state_val_26711 === (3))){
var inst_26708 = (state_26710[(2)]);
var state_26710__$1 = state_26710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26710__$1,inst_26708);
} else {
if((state_val_26711 === (4))){
var inst_26695 = (state_26710[(2)]);
var state_26710__$1 = state_26710;
var statearr_26715_26978 = state_26710__$1;
(statearr_26715_26978[(2)] = inst_26695);

(statearr_26715_26978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26711 === (5))){
var _ = (function (){var statearr_26716 = state_26710;
(statearr_26716[(4)] = cljs.core.rest((state_26710[(4)])));

return statearr_26716;
})();
var state_26710__$1 = state_26710;
var ex26714 = (state_26710__$1[(2)]);
var statearr_26717_26979 = state_26710__$1;
(statearr_26717_26979[(5)] = ex26714);


if((ex26714 instanceof Error)){
var statearr_26718_26980 = state_26710__$1;
(statearr_26718_26980[(1)] = (4));

(statearr_26718_26980[(5)] = null);

} else {
throw ex26714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26711 === (6))){
var inst_26703 = (state_26710[(2)]);
var inst_26704 = fluree.db.util.async.throw_err(inst_26703);
var inst_26705 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26704,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_26719 = state_26710;
(statearr_26719[(4)] = cljs.core.rest((state_26710[(4)])));

return statearr_26719;
})();
var state_26710__$1 = state_26710;
var statearr_26720_26981 = state_26710__$1;
(statearr_26720_26981[(2)] = inst_26705);

(statearr_26720_26981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_26721 = [null,null,null,null,null,null,null];
(statearr_26721[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_26721[(1)] = (1));

return statearr_26721;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_26710){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26710);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26722){var ex__2417__auto__ = e26722;
var statearr_26723_26982 = state_26710;
(statearr_26723_26982[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26710[(4)]))){
var statearr_26724_26983 = state_26710;
(statearr_26724_26983[(1)] = cljs.core.first((state_26710[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26984 = state_26710;
state_26710 = G__26984;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_26710){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_26710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26725 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26725[(6)] = c__2436__auto__);

return statearr_26725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__26726 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26726.cljs$core$IFn$_invoke$arity$1 ? fexpr__26726.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26726.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__26727 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26727.cljs$core$IFn$_invoke$arity$1 ? fexpr__26727.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26727.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__26728 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__26728);
} else {
return G__26728;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26760){
var state_val_26761 = (state_26760[(1)]);
if((state_val_26761 === (7))){
var state_26760__$1 = state_26760;
var statearr_26762_26985 = state_26760__$1;
(statearr_26762_26985[(2)] = null);

(statearr_26762_26985[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (1))){
var state_26760__$1 = state_26760;
var statearr_26763_26986 = state_26760__$1;
(statearr_26763_26986[(2)] = null);

(statearr_26763_26986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (4))){
var inst_26729 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26764_26987 = state_26760__$1;
(statearr_26764_26987[(2)] = inst_26729);

(statearr_26764_26987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (6))){
var inst_26743 = (state_26760[(7)]);
var inst_26742 = (state_26760[(2)]);
var inst_26743__$1 = fluree.db.util.async.throw_err(inst_26742);
var inst_26744 = (inst_26743__$1 == null);
var state_26760__$1 = (function (){var statearr_26765 = state_26760;
(statearr_26765[(7)] = inst_26743__$1);

return statearr_26765;
})();
if(cljs.core.truth_(inst_26744)){
var statearr_26766_26988 = state_26760__$1;
(statearr_26766_26988[(1)] = (7));

} else {
var statearr_26767_26989 = state_26760__$1;
(statearr_26767_26989[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (3))){
var inst_26758 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26760__$1,inst_26758);
} else {
if((state_val_26761 === (12))){
var inst_26755 = (state_26760[(2)]);
var _ = (function (){var statearr_26768 = state_26760;
(statearr_26768[(4)] = cljs.core.rest((state_26760[(4)])));

return statearr_26768;
})();
var state_26760__$1 = state_26760;
var statearr_26769_26990 = state_26760__$1;
(statearr_26769_26990[(2)] = inst_26755);

(statearr_26769_26990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (2))){
var _ = (function (){var statearr_26770 = state_26760;
(statearr_26770[(4)] = cljs.core.cons((5),(state_26760[(4)])));

return statearr_26770;
})();
var inst_26736 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_26737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26738 = [tag_id,(30)];
var inst_26739 = (new cljs.core.PersistentVector(null,2,(5),inst_26737,inst_26738,null));
var inst_26740 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26736,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26739);
var state_26760__$1 = state_26760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26760__$1,(6),inst_26740);
} else {
if((state_val_26761 === (11))){
var inst_26749 = (state_26760[(8)]);
var inst_26753 = inst_26749.o;
var state_26760__$1 = state_26760;
var statearr_26772_26991 = state_26760__$1;
(statearr_26772_26991[(2)] = inst_26753);

(statearr_26772_26991[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (9))){
var inst_26749 = (state_26760[(8)]);
var inst_26749__$1 = (state_26760[(2)]);
var inst_26750 = (inst_26749__$1 == null);
var state_26760__$1 = (function (){var statearr_26773 = state_26760;
(statearr_26773[(8)] = inst_26749__$1);

return statearr_26773;
})();
if(cljs.core.truth_(inst_26750)){
var statearr_26774_26992 = state_26760__$1;
(statearr_26774_26992[(1)] = (10));

} else {
var statearr_26775_26993 = state_26760__$1;
(statearr_26775_26993[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (5))){
var _ = (function (){var statearr_26776 = state_26760;
(statearr_26776[(4)] = cljs.core.rest((state_26760[(4)])));

return statearr_26776;
})();
var state_26760__$1 = state_26760;
var ex26771 = (state_26760__$1[(2)]);
var statearr_26777_26994 = state_26760__$1;
(statearr_26777_26994[(5)] = ex26771);


if((ex26771 instanceof Error)){
var statearr_26778_26995 = state_26760__$1;
(statearr_26778_26995[(1)] = (4));

(statearr_26778_26995[(5)] = null);

} else {
throw ex26771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (10))){
var state_26760__$1 = state_26760;
var statearr_26779_26996 = state_26760__$1;
(statearr_26779_26996[(2)] = null);

(statearr_26779_26996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (8))){
var inst_26743 = (state_26760[(7)]);
var inst_26747 = cljs.core.first(inst_26743);
var state_26760__$1 = state_26760;
var statearr_26780_26997 = state_26760__$1;
(statearr_26780_26997[(2)] = inst_26747);

(statearr_26780_26997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_26781 = [null,null,null,null,null,null,null,null,null];
(statearr_26781[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_26781[(1)] = (1));

return statearr_26781;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_26760){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26760);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26782){var ex__2417__auto__ = e26782;
var statearr_26783_26998 = state_26760;
(statearr_26783_26998[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26760[(4)]))){
var statearr_26784_26999 = state_26760;
(statearr_26784_26999[(1)] = cljs.core.first((state_26760[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27000 = state_26760;
state_26760 = G__27000;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_26760){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_26760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26785 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26785[(6)] = c__2436__auto__);

return statearr_26785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26821){
var state_val_26822 = (state_26821[(1)]);
if((state_val_26822 === (7))){
var inst_26795 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26821__$1 = state_26821;
var statearr_26823_27001 = state_26821__$1;
(statearr_26823_27001[(2)] = inst_26795);

(statearr_26823_27001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (1))){
var state_26821__$1 = state_26821;
var statearr_26824_27002 = state_26821__$1;
(statearr_26824_27002[(2)] = null);

(statearr_26824_27002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (4))){
var inst_26786 = (state_26821[(2)]);
var state_26821__$1 = state_26821;
var statearr_26825_27003 = state_26821__$1;
(statearr_26825_27003[(2)] = inst_26786);

(statearr_26825_27003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (15))){
var inst_26816 = (state_26821[(2)]);
var _ = (function (){var statearr_26826 = state_26821;
(statearr_26826[(4)] = cljs.core.rest((state_26821[(4)])));

return statearr_26826;
})();
var state_26821__$1 = state_26821;
var statearr_26827_27004 = state_26821__$1;
(statearr_26827_27004[(2)] = inst_26816);

(statearr_26827_27004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (13))){
var inst_26801 = (state_26821[(7)]);
var inst_26807 = clojure.string.includes_QMARK_(inst_26801,":");
var state_26821__$1 = state_26821;
if(inst_26807){
var statearr_26828_27005 = state_26821__$1;
(statearr_26828_27005[(1)] = (16));

} else {
var statearr_26829_27006 = state_26821__$1;
(statearr_26829_27006[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (6))){
var state_26821__$1 = state_26821;
var statearr_26830_27007 = state_26821__$1;
(statearr_26830_27007[(2)] = pred);

(statearr_26830_27007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (17))){
var inst_26801 = (state_26821[(7)]);
var state_26821__$1 = state_26821;
var statearr_26831_27008 = state_26821__$1;
(statearr_26831_27008[(2)] = inst_26801);

(statearr_26831_27008[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (3))){
var inst_26819 = (state_26821[(2)]);
var state_26821__$1 = state_26821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26821__$1,inst_26819);
} else {
if((state_val_26822 === (12))){
var inst_26805 = (state_26821[(2)]);
var state_26821__$1 = state_26821;
if(cljs.core.truth_(inst_26805)){
var statearr_26832_27009 = state_26821__$1;
(statearr_26832_27009[(1)] = (13));

} else {
var statearr_26833_27010 = state_26821__$1;
(statearr_26833_27010[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (2))){
var _ = (function (){var statearr_26834 = state_26821;
(statearr_26834[(4)] = cljs.core.cons((5),(state_26821[(4)])));

return statearr_26834;
})();
var inst_26792 = typeof pred === 'string';
var state_26821__$1 = state_26821;
if(cljs.core.truth_(inst_26792)){
var statearr_26835_27011 = state_26821__$1;
(statearr_26835_27011[(1)] = (6));

} else {
var statearr_26836_27012 = state_26821__$1;
(statearr_26836_27012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (11))){
var inst_26797 = (state_26821[(8)]);
var state_26821__$1 = state_26821;
var statearr_26838_27013 = state_26821__$1;
(statearr_26838_27013[(2)] = inst_26797);

(statearr_26838_27013[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (9))){
var inst_26797 = (state_26821[(8)]);
var inst_26800 = (state_26821[(2)]);
var inst_26801 = fluree.db.util.async.throw_err(inst_26800);
var state_26821__$1 = (function (){var statearr_26839 = state_26821;
(statearr_26839[(7)] = inst_26801);

return statearr_26839;
})();
if(cljs.core.truth_(inst_26797)){
var statearr_26840_27014 = state_26821__$1;
(statearr_26840_27014[(1)] = (10));

} else {
var statearr_26841_27015 = state_26821__$1;
(statearr_26841_27015[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (5))){
var _ = (function (){var statearr_26842 = state_26821;
(statearr_26842[(4)] = cljs.core.rest((state_26821[(4)])));

return statearr_26842;
})();
var state_26821__$1 = state_26821;
var ex26837 = (state_26821__$1[(2)]);
var statearr_26843_27016 = state_26821__$1;
(statearr_26843_27016[(5)] = ex26837);


if((ex26837 instanceof Error)){
var statearr_26844_27017 = state_26821__$1;
(statearr_26844_27017[(1)] = (4));

(statearr_26844_27017[(5)] = null);

} else {
throw ex26837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (14))){
var state_26821__$1 = state_26821;
var statearr_26845_27018 = state_26821__$1;
(statearr_26845_27018[(2)] = null);

(statearr_26845_27018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (16))){
var inst_26801 = (state_26821[(7)]);
var inst_26809 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_26801,/:/);
var inst_26810 = cljs.core.second(inst_26809);
var state_26821__$1 = state_26821;
var statearr_26846_27019 = state_26821__$1;
(statearr_26846_27019[(2)] = inst_26810);

(statearr_26846_27019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (10))){
var inst_26801 = (state_26821[(7)]);
var state_26821__$1 = state_26821;
var statearr_26847_27020 = state_26821__$1;
(statearr_26847_27020[(2)] = inst_26801);

(statearr_26847_27020[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (18))){
var inst_26813 = (state_26821[(2)]);
var state_26821__$1 = state_26821;
var statearr_26848_27021 = state_26821__$1;
(statearr_26848_27021[(2)] = inst_26813);

(statearr_26848_27021[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26822 === (8))){
var inst_26797 = (state_26821[(2)]);
var inst_26798 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_26821__$1 = (function (){var statearr_26849 = state_26821;
(statearr_26849[(8)] = inst_26797);

return statearr_26849;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26821__$1,(9),inst_26798);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_26850 = [null,null,null,null,null,null,null,null,null];
(statearr_26850[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_26850[(1)] = (1));

return statearr_26850;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_26821){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26821);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26851){var ex__2417__auto__ = e26851;
var statearr_26852_27022 = state_26821;
(statearr_26852_27022[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26821[(4)]))){
var statearr_26853_27023 = state_26821;
(statearr_26853_27023[(1)] = cljs.core.first((state_26821[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27024 = state_26821;
state_26821 = G__27024;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_26821){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_26821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26854 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26854[(6)] = c__2436__auto__);

return statearr_26854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26886){
var state_val_26887 = (state_26886[(1)]);
if((state_val_26887 === (7))){
var state_26886__$1 = state_26886;
var statearr_26888_27025 = state_26886__$1;
(statearr_26888_27025[(2)] = null);

(statearr_26888_27025[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (1))){
var state_26886__$1 = state_26886;
var statearr_26889_27026 = state_26886__$1;
(statearr_26889_27026[(2)] = null);

(statearr_26889_27026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (4))){
var inst_26855 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26890_27027 = state_26886__$1;
(statearr_26890_27027[(2)] = inst_26855);

(statearr_26890_27027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (6))){
var inst_26869 = (state_26886[(7)]);
var inst_26868 = (state_26886[(2)]);
var inst_26869__$1 = fluree.db.util.async.throw_err(inst_26868);
var inst_26870 = (inst_26869__$1 == null);
var state_26886__$1 = (function (){var statearr_26891 = state_26886;
(statearr_26891[(7)] = inst_26869__$1);

return statearr_26891;
})();
if(cljs.core.truth_(inst_26870)){
var statearr_26892_27028 = state_26886__$1;
(statearr_26892_27028[(1)] = (7));

} else {
var statearr_26893_27029 = state_26886__$1;
(statearr_26893_27029[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (3))){
var inst_26884 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26886__$1,inst_26884);
} else {
if((state_val_26887 === (12))){
var inst_26881 = (state_26886[(2)]);
var _ = (function (){var statearr_26894 = state_26886;
(statearr_26894[(4)] = cljs.core.rest((state_26886[(4)])));

return statearr_26894;
})();
var state_26886__$1 = state_26886;
var statearr_26895_27030 = state_26886__$1;
(statearr_26895_27030[(2)] = inst_26881);

(statearr_26895_27030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (2))){
var _ = (function (){var statearr_26896 = state_26886;
(statearr_26896[(4)] = cljs.core.cons((5),(state_26886[(4)])));

return statearr_26896;
})();
var inst_26862 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_26863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26864 = [(30),tag_name];
var inst_26865 = (new cljs.core.PersistentVector(null,2,(5),inst_26863,inst_26864,null));
var inst_26866 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26862,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26865);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26886__$1,(6),inst_26866);
} else {
if((state_val_26887 === (11))){
var inst_26875 = (state_26886[(8)]);
var inst_26879 = inst_26875.s;
var state_26886__$1 = state_26886;
var statearr_26898_27031 = state_26886__$1;
(statearr_26898_27031[(2)] = inst_26879);

(statearr_26898_27031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (9))){
var inst_26875 = (state_26886[(8)]);
var inst_26875__$1 = (state_26886[(2)]);
var inst_26876 = (inst_26875__$1 == null);
var state_26886__$1 = (function (){var statearr_26899 = state_26886;
(statearr_26899[(8)] = inst_26875__$1);

return statearr_26899;
})();
if(cljs.core.truth_(inst_26876)){
var statearr_26900_27032 = state_26886__$1;
(statearr_26900_27032[(1)] = (10));

} else {
var statearr_26901_27033 = state_26886__$1;
(statearr_26901_27033[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (5))){
var _ = (function (){var statearr_26902 = state_26886;
(statearr_26902[(4)] = cljs.core.rest((state_26886[(4)])));

return statearr_26902;
})();
var state_26886__$1 = state_26886;
var ex26897 = (state_26886__$1[(2)]);
var statearr_26903_27034 = state_26886__$1;
(statearr_26903_27034[(5)] = ex26897);


if((ex26897 instanceof Error)){
var statearr_26904_27035 = state_26886__$1;
(statearr_26904_27035[(1)] = (4));

(statearr_26904_27035[(5)] = null);

} else {
throw ex26897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (10))){
var state_26886__$1 = state_26886;
var statearr_26905_27036 = state_26886__$1;
(statearr_26905_27036[(2)] = null);

(statearr_26905_27036[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (8))){
var inst_26869 = (state_26886[(7)]);
var inst_26873 = cljs.core.first(inst_26869);
var state_26886__$1 = state_26886;
var statearr_26906_27037 = state_26886__$1;
(statearr_26906_27037[(2)] = inst_26873);

(statearr_26906_27037[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_26907 = [null,null,null,null,null,null,null,null,null];
(statearr_26907[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_26907[(1)] = (1));

return statearr_26907;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_26886){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26886);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26908){var ex__2417__auto__ = e26908;
var statearr_26909_27038 = state_26886;
(statearr_26909_27038[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26886[(4)]))){
var statearr_26910_27039 = state_26886;
(statearr_26910_27039[(1)] = cljs.core.first((state_26886[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27040 = state_26886;
state_26886 = G__27040;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_26886){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_26886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26911 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26911[(6)] = c__2436__auto__);

return statearr_26911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26946){
var state_val_26947 = (state_26946[(1)]);
if((state_val_26947 === (7))){
var inst_26925 = typeof pred === 'string';
var state_26946__$1 = state_26946;
if(cljs.core.truth_(inst_26925)){
var statearr_26948_27041 = state_26946__$1;
(statearr_26948_27041[(1)] = (10));

} else {
var statearr_26949_27042 = state_26946__$1;
(statearr_26949_27042[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (1))){
var state_26946__$1 = state_26946;
var statearr_26950_27043 = state_26946__$1;
(statearr_26950_27043[(2)] = null);

(statearr_26950_27043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (4))){
var inst_26912 = (state_26946[(2)]);
var state_26946__$1 = state_26946;
var statearr_26951_27044 = state_26946__$1;
(statearr_26951_27044[(2)] = inst_26912);

(statearr_26951_27044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (15))){
var inst_26939 = (state_26946[(2)]);
var state_26946__$1 = state_26946;
var statearr_26952_27045 = state_26946__$1;
(statearr_26952_27045[(2)] = inst_26939);

(statearr_26952_27045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (13))){
var inst_26930 = (state_26946[(7)]);
var inst_26932 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26930),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26933 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_26932);
var state_26946__$1 = state_26946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26946__$1,(16),inst_26933);
} else {
if((state_val_26947 === (6))){
var inst_26920 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_26946__$1 = state_26946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26946__$1,(9),inst_26920);
} else {
if((state_val_26947 === (3))){
var inst_26944 = (state_26946[(2)]);
var state_26946__$1 = state_26946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26946__$1,inst_26944);
} else {
if((state_val_26947 === (12))){
var inst_26930 = (state_26946[(7)]);
var inst_26930__$1 = (state_26946[(2)]);
var state_26946__$1 = (function (){var statearr_26953 = state_26946;
(statearr_26953[(7)] = inst_26930__$1);

return statearr_26953;
})();
if(cljs.core.truth_(inst_26930__$1)){
var statearr_26954_27046 = state_26946__$1;
(statearr_26954_27046[(1)] = (13));

} else {
var statearr_26955_27047 = state_26946__$1;
(statearr_26955_27047[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (2))){
var _ = (function (){var statearr_26956 = state_26946;
(statearr_26956[(4)] = cljs.core.cons((5),(state_26946[(4)])));

return statearr_26956;
})();
var inst_26918 = clojure.string.includes_QMARK_(tag_name,"/");
var state_26946__$1 = state_26946;
if(inst_26918){
var statearr_26957_27048 = state_26946__$1;
(statearr_26957_27048[(1)] = (6));

} else {
var statearr_26958_27049 = state_26946__$1;
(statearr_26958_27049[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (11))){
var inst_26928 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26946__$1 = state_26946;
var statearr_26960_27050 = state_26946__$1;
(statearr_26960_27050[(2)] = inst_26928);

(statearr_26960_27050[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (9))){
var inst_26922 = (state_26946[(2)]);
var inst_26923 = fluree.db.util.async.throw_err(inst_26922);
var state_26946__$1 = state_26946;
var statearr_26961_27051 = state_26946__$1;
(statearr_26961_27051[(2)] = inst_26923);

(statearr_26961_27051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (5))){
var _ = (function (){var statearr_26962 = state_26946;
(statearr_26962[(4)] = cljs.core.rest((state_26946[(4)])));

return statearr_26962;
})();
var state_26946__$1 = state_26946;
var ex26959 = (state_26946__$1[(2)]);
var statearr_26963_27052 = state_26946__$1;
(statearr_26963_27052[(5)] = ex26959);


if((ex26959 instanceof Error)){
var statearr_26964_27053 = state_26946__$1;
(statearr_26964_27053[(1)] = (4));

(statearr_26964_27053[(5)] = null);

} else {
throw ex26959;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (14))){
var state_26946__$1 = state_26946;
var statearr_26965_27054 = state_26946__$1;
(statearr_26965_27054[(2)] = null);

(statearr_26965_27054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (16))){
var inst_26935 = (state_26946[(2)]);
var inst_26936 = fluree.db.util.async.throw_err(inst_26935);
var state_26946__$1 = state_26946;
var statearr_26966_27055 = state_26946__$1;
(statearr_26966_27055[(2)] = inst_26936);

(statearr_26966_27055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (10))){
var state_26946__$1 = state_26946;
var statearr_26967_27056 = state_26946__$1;
(statearr_26967_27056[(2)] = pred);

(statearr_26967_27056[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (8))){
var inst_26941 = (state_26946[(2)]);
var _ = (function (){var statearr_26968 = state_26946;
(statearr_26968[(4)] = cljs.core.rest((state_26946[(4)])));

return statearr_26968;
})();
var state_26946__$1 = state_26946;
var statearr_26969_27057 = state_26946__$1;
(statearr_26969_27057[(2)] = inst_26941);

(statearr_26969_27057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_26970 = [null,null,null,null,null,null,null,null];
(statearr_26970[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_26970[(1)] = (1));

return statearr_26970;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_26946){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26946);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26971){var ex__2417__auto__ = e26971;
var statearr_26972_27058 = state_26946;
(statearr_26972_27058[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26946[(4)]))){
var statearr_26973_27059 = state_26946;
(statearr_26973_27059[(1)] = cljs.core.first((state_26946[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27060 = state_26946;
state_26946 = G__27060;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_26946){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_26946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26974 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26974[(6)] = c__2436__auto__);

return statearr_26974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26645){
var extmap__4419__auto__ = (function (){var G__26975 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26645,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__26645)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26975);
} else {
return G__26975;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26645),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26645),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
