// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59495 = arguments.length;
switch (G__59495) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___59676 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_59602){
var state_val_59603 = (state_59602[(1)]);
if((state_val_59603 === (7))){
var inst_59509 = (state_59602[(7)]);
var inst_59514 = inst_59509.cljs$lang$protocol_mask$partition0$;
var inst_59515 = (inst_59514 & (64));
var inst_59516 = inst_59509.cljs$core$ISeq$;
var inst_59517 = (cljs.core.PROTOCOL_SENTINEL === inst_59516);
var inst_59518 = ((inst_59515) || (inst_59517));
var state_59602__$1 = state_59602;
if(cljs.core.truth_(inst_59518)){
var statearr_59604_59677 = state_59602__$1;
(statearr_59604_59677[(1)] = (10));

} else {
var statearr_59605_59678 = state_59602__$1;
(statearr_59605_59678[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (20))){
var state_59602__$1 = state_59602;
var statearr_59606_59679 = state_59602__$1;
(statearr_59606_59679[(2)] = null);

(statearr_59606_59679[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (27))){
var inst_59557 = (state_59602[(8)]);
var state_59602__$1 = state_59602;
if(cljs.core.truth_(inst_59557)){
var statearr_59607_59680 = state_59602__$1;
(statearr_59607_59680[(1)] = (29));

} else {
var statearr_59608_59681 = state_59602__$1;
(statearr_59608_59681[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (1))){
var state_59602__$1 = state_59602;
var statearr_59609_59682 = state_59602__$1;
(statearr_59609_59682[(2)] = null);

(statearr_59609_59682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (24))){
var inst_59533 = (state_59602[(9)]);
var inst_59547 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59533)," unknown."].join('');
var inst_59548 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59549 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59550 = cljs.core.PersistentHashMap.fromArrays(inst_59548,inst_59549);
var inst_59551 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59547,inst_59550);
var inst_59552 = (function(){throw inst_59551})();
var state_59602__$1 = state_59602;
var statearr_59610_59683 = state_59602__$1;
(statearr_59610_59683[(2)] = inst_59552);

(statearr_59610_59683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (39))){
var inst_59579 = (state_59602[(2)]);
var inst_59580 = fluree.db.util.async.throw_err(inst_59579);
var state_59602__$1 = state_59602;
var statearr_59611_59684 = state_59602__$1;
(statearr_59611_59684[(2)] = inst_59580);

(statearr_59611_59684[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (46))){
var inst_59588 = (state_59602[(10)]);
var inst_59591 = (state_59602[(2)]);
var inst_59592 = fluree.db.util.async.throw_err(inst_59591);
var inst_59593 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59588,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59592);
var state_59602__$1 = state_59602;
var statearr_59612_59685 = state_59602__$1;
(statearr_59612_59685[(2)] = inst_59593);

(statearr_59612_59685[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (4))){
var inst_59496 = (state_59602[(2)]);
var inst_59497 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59496);
var inst_59498 = cljs.core.async.close_BANG_(pc);
var state_59602__$1 = (function (){var statearr_59613 = state_59602;
(statearr_59613[(11)] = inst_59497);

return statearr_59613;
})();
var statearr_59614_59686 = state_59602__$1;
(statearr_59614_59686[(2)] = inst_59498);

(statearr_59614_59686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (15))){
var inst_59533 = (state_59602[(9)]);
var inst_59530 = (state_59602[(2)]);
var inst_59531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59530,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59530,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59533__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59530,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59530,new cljs.core.Keyword(null,"block","block",664686210));
var state_59602__$1 = (function (){var statearr_59615 = state_59602;
(statearr_59615[(9)] = inst_59533__$1);

(statearr_59615[(12)] = inst_59532);

(statearr_59615[(13)] = inst_59534);

(statearr_59615[(14)] = inst_59531);

return statearr_59615;
})();
if(cljs.core.truth_(inst_59533__$1)){
var statearr_59616_59687 = state_59602__$1;
(statearr_59616_59687[(1)] = (16));

} else {
var statearr_59617_59688 = state_59602__$1;
(statearr_59617_59688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (21))){
var inst_59531 = (state_59602[(14)]);
var inst_59557 = (state_59602[(2)]);
var state_59602__$1 = (function (){var statearr_59618 = state_59602;
(statearr_59618[(8)] = inst_59557);

return statearr_59618;
})();
if(cljs.core.truth_(inst_59531)){
var statearr_59619_59689 = state_59602__$1;
(statearr_59619_59689[(1)] = (26));

} else {
var statearr_59620_59690 = state_59602__$1;
(statearr_59620_59690[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (31))){
var inst_59567 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
var statearr_59621_59691 = state_59602__$1;
(statearr_59621_59691[(2)] = inst_59567);

(statearr_59621_59691[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (32))){
var inst_59563 = (state_59602[(2)]);
var inst_59564 = fluree.db.util.async.throw_err(inst_59563);
var state_59602__$1 = state_59602;
var statearr_59622_59692 = state_59602__$1;
(statearr_59622_59692[(2)] = inst_59564);

(statearr_59622_59692[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (40))){
var inst_59533 = (state_59602[(9)]);
var inst_59583 = (state_59602[(15)]);
var inst_59585 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59583,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59533);
var state_59602__$1 = state_59602;
var statearr_59623_59693 = state_59602__$1;
(statearr_59623_59693[(2)] = inst_59585);

(statearr_59623_59693[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (33))){
var inst_59508 = (state_59602[(16)]);
var inst_59569 = (state_59602[(17)]);
var inst_59571 = fluree.db.permissions.permission_map(inst_59508,inst_59569,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59602__$1 = state_59602;
var statearr_59624_59694 = state_59602__$1;
(statearr_59624_59694[(2)] = inst_59571);

(statearr_59624_59694[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (13))){
var inst_59509 = (state_59602[(7)]);
var inst_59527 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_59509);
var state_59602__$1 = state_59602;
var statearr_59625_59695 = state_59602__$1;
(statearr_59625_59695[(2)] = inst_59527);

(statearr_59625_59695[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (22))){
var inst_59544 = (state_59602[(18)]);
var inst_59543 = (state_59602[(2)]);
var inst_59544__$1 = fluree.db.util.async.throw_err(inst_59543);
var state_59602__$1 = (function (){var statearr_59626 = state_59602;
(statearr_59626[(18)] = inst_59544__$1);

return statearr_59626;
})();
if(cljs.core.truth_(inst_59544__$1)){
var statearr_59627_59696 = state_59602__$1;
(statearr_59627_59696[(1)] = (23));

} else {
var statearr_59628_59697 = state_59602__$1;
(statearr_59628_59697[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (36))){
var inst_59508 = (state_59602[(16)]);
var inst_59576 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59577 = fluree.db.time_travel.as_of_block(inst_59508,inst_59576);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59602__$1,(39),inst_59577);
} else {
if((state_val_59603 === (41))){
var inst_59583 = (state_59602[(15)]);
var state_59602__$1 = state_59602;
var statearr_59629_59698 = state_59602__$1;
(statearr_59629_59698[(2)] = inst_59583);

(statearr_59629_59698[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (43))){
var inst_59574 = (state_59602[(19)]);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59602__$1,(46),inst_59574);
} else {
if((state_val_59603 === (29))){
var inst_59508 = (state_59602[(16)]);
var inst_59557 = (state_59602[(8)]);
var inst_59561 = fluree.db.auth.roles(inst_59508,inst_59557);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59602__$1,(32),inst_59561);
} else {
if((state_val_59603 === (44))){
var inst_59588 = (state_59602[(10)]);
var state_59602__$1 = state_59602;
var statearr_59630_59699 = state_59602__$1;
(statearr_59630_59699[(2)] = inst_59588);

(statearr_59630_59699[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (6))){
var inst_59509 = (state_59602[(7)]);
var inst_59507 = (state_59602[(2)]);
var inst_59508 = fluree.db.util.async.throw_err(inst_59507);
var inst_59509__$1 = opts;
var inst_59511 = (inst_59509__$1 == null);
var inst_59512 = cljs.core.not(inst_59511);
var state_59602__$1 = (function (){var statearr_59631 = state_59602;
(statearr_59631[(16)] = inst_59508);

(statearr_59631[(7)] = inst_59509__$1);

return statearr_59631;
})();
if(inst_59512){
var statearr_59632_59700 = state_59602__$1;
(statearr_59632_59700[(1)] = (7));

} else {
var statearr_59633_59701 = state_59602__$1;
(statearr_59633_59701[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (28))){
var inst_59569 = (state_59602[(17)]);
var inst_59569__$1 = (state_59602[(2)]);
var state_59602__$1 = (function (){var statearr_59634 = state_59602;
(statearr_59634[(17)] = inst_59569__$1);

return statearr_59634;
})();
if(cljs.core.truth_(inst_59569__$1)){
var statearr_59635_59702 = state_59602__$1;
(statearr_59635_59702[(1)] = (33));

} else {
var statearr_59636_59703 = state_59602__$1;
(statearr_59636_59703[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (25))){
var inst_59554 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
var statearr_59637_59704 = state_59602__$1;
(statearr_59637_59704[(2)] = inst_59554);

(statearr_59637_59704[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (34))){
var state_59602__$1 = state_59602;
var statearr_59638_59705 = state_59602__$1;
(statearr_59638_59705[(2)] = null);

(statearr_59638_59705[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (17))){
var inst_59533 = (state_59602[(9)]);
var state_59602__$1 = state_59602;
var statearr_59639_59706 = state_59602__$1;
(statearr_59639_59706[(2)] = inst_59533);

(statearr_59639_59706[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (3))){
var inst_59600 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59602__$1,inst_59600);
} else {
if((state_val_59603 === (12))){
var inst_59522 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
var statearr_59640_59707 = state_59602__$1;
(statearr_59640_59707[(2)] = inst_59522);

(statearr_59640_59707[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (2))){
var _ = (function (){var statearr_59641 = state_59602;
(statearr_59641[(4)] = cljs.core.cons((5),(state_59602[(4)])));

return statearr_59641;
})();
var inst_59505 = fluree.db.session.db(conn,ledger,null);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59602__$1,(6),inst_59505);
} else {
if((state_val_59603 === (23))){
var inst_59544 = (state_59602[(18)]);
var state_59602__$1 = state_59602;
var statearr_59642_59708 = state_59602__$1;
(statearr_59642_59708[(2)] = inst_59544);

(statearr_59642_59708[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (35))){
var inst_59534 = (state_59602[(13)]);
var inst_59574 = (state_59602[(2)]);
var state_59602__$1 = (function (){var statearr_59643 = state_59602;
(statearr_59643[(19)] = inst_59574);

return statearr_59643;
})();
if(cljs.core.truth_(inst_59534)){
var statearr_59644_59709 = state_59602__$1;
(statearr_59644_59709[(1)] = (36));

} else {
var statearr_59645_59710 = state_59602__$1;
(statearr_59645_59710[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (19))){
var inst_59533 = (state_59602[(9)]);
var inst_59508 = (state_59602[(16)]);
var inst_59541 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_59508,inst_59533);
var state_59602__$1 = state_59602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59602__$1,(22),inst_59541);
} else {
if((state_val_59603 === (11))){
var state_59602__$1 = state_59602;
var statearr_59647_59711 = state_59602__$1;
(statearr_59647_59711[(2)] = false);

(statearr_59647_59711[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (9))){
var inst_59525 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
if(cljs.core.truth_(inst_59525)){
var statearr_59648_59712 = state_59602__$1;
(statearr_59648_59712[(1)] = (13));

} else {
var statearr_59649_59713 = state_59602__$1;
(statearr_59649_59713[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (5))){
var _ = (function (){var statearr_59650 = state_59602;
(statearr_59650[(4)] = cljs.core.rest((state_59602[(4)])));

return statearr_59650;
})();
var state_59602__$1 = state_59602;
var ex59646 = (state_59602__$1[(2)]);
var statearr_59651_59714 = state_59602__$1;
(statearr_59651_59714[(5)] = ex59646);


var statearr_59652_59715 = state_59602__$1;
(statearr_59652_59715[(1)] = (4));

(statearr_59652_59715[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (14))){
var inst_59509 = (state_59602[(7)]);
var state_59602__$1 = state_59602;
var statearr_59653_59716 = state_59602__$1;
(statearr_59653_59716[(2)] = inst_59509);

(statearr_59653_59716[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (45))){
var inst_59596 = (state_59602[(2)]);
var inst_59597 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59596);
var _ = (function (){var statearr_59654 = state_59602;
(statearr_59654[(4)] = cljs.core.rest((state_59602[(4)])));

return statearr_59654;
})();
var state_59602__$1 = state_59602;
var statearr_59655_59717 = state_59602__$1;
(statearr_59655_59717[(2)] = inst_59597);

(statearr_59655_59717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (26))){
var inst_59531 = (state_59602[(14)]);
var state_59602__$1 = state_59602;
var statearr_59656_59718 = state_59602__$1;
(statearr_59656_59718[(2)] = inst_59531);

(statearr_59656_59718[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (16))){
var inst_59533 = (state_59602[(9)]);
var inst_59536 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_59533);
var state_59602__$1 = state_59602;
var statearr_59657_59719 = state_59602__$1;
(statearr_59657_59719[(2)] = inst_59536);

(statearr_59657_59719[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (38))){
var inst_59533 = (state_59602[(9)]);
var inst_59583 = (state_59602[(2)]);
var state_59602__$1 = (function (){var statearr_59658 = state_59602;
(statearr_59658[(15)] = inst_59583);

return statearr_59658;
})();
if(cljs.core.truth_(inst_59533)){
var statearr_59659_59720 = state_59602__$1;
(statearr_59659_59720[(1)] = (40));

} else {
var statearr_59660_59721 = state_59602__$1;
(statearr_59660_59721[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (30))){
var state_59602__$1 = state_59602;
var statearr_59661_59722 = state_59602__$1;
(statearr_59661_59722[(2)] = null);

(statearr_59661_59722[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (10))){
var state_59602__$1 = state_59602;
var statearr_59662_59723 = state_59602__$1;
(statearr_59662_59723[(2)] = true);

(statearr_59662_59723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (18))){
var inst_59539 = (state_59602[(2)]);
var state_59602__$1 = state_59602;
if(cljs.core.truth_(inst_59539)){
var statearr_59663_59724 = state_59602__$1;
(statearr_59663_59724[(1)] = (19));

} else {
var statearr_59664_59725 = state_59602__$1;
(statearr_59664_59725[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (42))){
var inst_59569 = (state_59602[(17)]);
var inst_59588 = (state_59602[(2)]);
var state_59602__$1 = (function (){var statearr_59665 = state_59602;
(statearr_59665[(10)] = inst_59588);

return statearr_59665;
})();
if(cljs.core.truth_(inst_59569)){
var statearr_59666_59726 = state_59602__$1;
(statearr_59666_59726[(1)] = (43));

} else {
var statearr_59667_59727 = state_59602__$1;
(statearr_59667_59727[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (37))){
var inst_59508 = (state_59602[(16)]);
var state_59602__$1 = state_59602;
var statearr_59668_59728 = state_59602__$1;
(statearr_59668_59728[(2)] = inst_59508);

(statearr_59668_59728[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59603 === (8))){
var state_59602__$1 = state_59602;
var statearr_59669_59729 = state_59602__$1;
(statearr_59669_59729[(2)] = false);

(statearr_59669_59729[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2414__auto__ = null;
var fluree$db$api$query$state_machine__2414__auto____0 = (function (){
var statearr_59670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59670[(0)] = fluree$db$api$query$state_machine__2414__auto__);

(statearr_59670[(1)] = (1));

return statearr_59670;
});
var fluree$db$api$query$state_machine__2414__auto____1 = (function (state_59602){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_59602);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e59671){var ex__2417__auto__ = e59671;
var statearr_59672_59730 = state_59602;
(statearr_59672_59730[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_59602[(4)]))){
var statearr_59673_59731 = state_59602;
(statearr_59673_59731[(1)] = cljs.core.first((state_59602[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59732 = state_59602;
state_59602 = G__59732;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2414__auto__ = function(state_59602){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2414__auto____1.call(this,state_59602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2414__auto____0;
fluree$db$api$query$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2414__auto____1;
return fluree$db$api$query$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_59674 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_59674[(6)] = c__2436__auto___59676);

return statearr_59674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_59870){
var state_val_59871 = (state_59870[(1)]);
if((state_val_59871 === (7))){
var inst_59753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59754 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59755 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59756 = [inst_59754,inst_59755];
var inst_59757 = (new cljs.core.PersistentVector(null,2,(5),inst_59753,inst_59756,null));
var state_59870__$1 = state_59870;
var statearr_59872_59938 = state_59870__$1;
(statearr_59872_59938[(2)] = inst_59757);

(statearr_59872_59938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (20))){
var inst_59783 = (state_59870[(7)]);
var state_59870__$1 = state_59870;
var statearr_59873_59939 = state_59870__$1;
(statearr_59873_59939[(2)] = inst_59783);

(statearr_59873_59939[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (27))){
var state_59870__$1 = state_59870;
var statearr_59874_59940 = state_59870__$1;
(statearr_59874_59940[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (1))){
var state_59870__$1 = state_59870;
var statearr_59876_59941 = state_59870__$1;
(statearr_59876_59941[(2)] = null);

(statearr_59876_59941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (24))){
var inst_59782 = (state_59870[(8)]);
var state_59870__$1 = state_59870;
if(cljs.core.truth_(inst_59782)){
var statearr_59877_59942 = state_59870__$1;
(statearr_59877_59942[(1)] = (26));

} else {
var statearr_59878_59943 = state_59870__$1;
(statearr_59878_59943[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (39))){
var inst_59857 = (state_59870[(9)]);
var state_59870__$1 = state_59870;
var statearr_59879_59944 = state_59870__$1;
(statearr_59879_59944[(2)] = inst_59857);

(statearr_59879_59944[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (4))){
var inst_59733 = (state_59870[(2)]);
var state_59870__$1 = state_59870;
var statearr_59880_59945 = state_59870__$1;
(statearr_59880_59945[(2)] = inst_59733);

(statearr_59880_59945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (15))){
var inst_59762 = (state_59870[(10)]);
var inst_59767 = (state_59870[(11)]);
var inst_59776 = (state_59870[(2)]);
var inst_59777 = [inst_59767,inst_59776];
var inst_59778 = (new cljs.core.PersistentVector(null,2,(5),inst_59762,inst_59777,null));
var state_59870__$1 = state_59870;
var statearr_59881_59946 = state_59870__$1;
(statearr_59881_59946[(2)] = inst_59778);

(statearr_59881_59946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (21))){
var inst_59782 = (state_59870[(8)]);
var state_59870__$1 = state_59870;
var statearr_59882_59947 = state_59870__$1;
(statearr_59882_59947[(2)] = inst_59782);

(statearr_59882_59947[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (31))){
var inst_59823 = (state_59870[(2)]);
var state_59870__$1 = state_59870;
var statearr_59883_59948 = state_59870__$1;
(statearr_59883_59948[(2)] = inst_59823);

(statearr_59883_59948[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (32))){
var inst_59759 = (state_59870[(12)]);
var inst_59835 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59759], 0));
var inst_59836 = ["Invalid block range provided: ",inst_59835].join('');
var inst_59837 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59838 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59839 = cljs.core.PersistentHashMap.fromArrays(inst_59837,inst_59838);
var inst_59840 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59836,inst_59839);
var inst_59841 = (function(){throw inst_59840})();
var state_59870__$1 = state_59870;
var statearr_59884_59949 = state_59870__$1;
(statearr_59884_59949[(2)] = inst_59841);

(statearr_59884_59949[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (40))){
var inst_59856 = (state_59870[(13)]);
var inst_59862 = (state_59870[(2)]);
var inst_59863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59864 = [inst_59856,inst_59862];
var inst_59865 = (new cljs.core.PersistentVector(null,2,(5),inst_59863,inst_59864,null));
var _ = (function (){var statearr_59885 = state_59870;
(statearr_59885[(4)] = cljs.core.rest((state_59870[(4)])));

return statearr_59885;
})();
var state_59870__$1 = state_59870;
var statearr_59886_59950 = state_59870__$1;
(statearr_59886_59950[(2)] = inst_59865);

(statearr_59886_59950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (33))){
var state_59870__$1 = state_59870;
var statearr_59887_59951 = state_59870__$1;
(statearr_59887_59951[(2)] = null);

(statearr_59887_59951[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (13))){
var inst_59768 = (state_59870[(14)]);
var inst_59770 = fluree.db.time_travel.block_to_int_format(db,inst_59768);
var state_59870__$1 = state_59870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59870__$1,(16),inst_59770);
} else {
if((state_val_59871 === (22))){
var inst_59801 = (state_59870[(2)]);
var state_59870__$1 = state_59870;
if(cljs.core.truth_(inst_59801)){
var statearr_59888_59952 = state_59870__$1;
(statearr_59888_59952[(1)] = (23));

} else {
var statearr_59889_59953 = state_59870__$1;
(statearr_59889_59953[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (36))){
var inst_59829 = (state_59870[(15)]);
var inst_59828 = (state_59870[(16)]);
var inst_59851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59852 = [inst_59828,inst_59829];
var inst_59853 = (new cljs.core.PersistentVector(null,2,(5),inst_59851,inst_59852,null));
var state_59870__$1 = state_59870;
var statearr_59890_59954 = state_59870__$1;
(statearr_59890_59954[(2)] = inst_59853);

(statearr_59890_59954[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (29))){
var inst_59759 = (state_59870[(12)]);
var inst_59814 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59759], 0));
var inst_59815 = ["Invalid block range provided: ",inst_59814].join('');
var inst_59816 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59817 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59818 = cljs.core.PersistentHashMap.fromArrays(inst_59816,inst_59817);
var inst_59819 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59815,inst_59818);
var inst_59820 = (function(){throw inst_59819})();
var state_59870__$1 = state_59870;
var statearr_59891_59955 = state_59870__$1;
(statearr_59891_59955[(2)] = inst_59820);

(statearr_59891_59955[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (6))){
var inst_59751 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59870__$1 = state_59870;
var statearr_59892_59956 = state_59870__$1;
(statearr_59892_59956[(2)] = inst_59751);

(statearr_59892_59956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (28))){
var inst_59825 = (state_59870[(2)]);
var state_59870__$1 = state_59870;
var statearr_59893_59957 = state_59870__$1;
(statearr_59893_59957[(2)] = inst_59825);

(statearr_59893_59957[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (25))){
var inst_59829 = (state_59870[(15)]);
var inst_59828 = (state_59870[(16)]);
var inst_59827 = (state_59870[(2)]);
var inst_59828__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59827,(0),null);
var inst_59829__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59827,(1),null);
var inst_59830 = cljs.core.pos_int_QMARK_(inst_59828__$1);
var inst_59831 = cljs.core.pos_int_QMARK_(inst_59829__$1);
var inst_59832 = ((inst_59830) && (inst_59831));
var inst_59833 = cljs.core.not(inst_59832);
var state_59870__$1 = (function (){var statearr_59894 = state_59870;
(statearr_59894[(15)] = inst_59829__$1);

(statearr_59894[(16)] = inst_59828__$1);

return statearr_59894;
})();
if(inst_59833){
var statearr_59895_59958 = state_59870__$1;
(statearr_59895_59958[(1)] = (32));

} else {
var statearr_59896_59959 = state_59870__$1;
(statearr_59896_59959[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (34))){
var inst_59829 = (state_59870[(15)]);
var inst_59828 = (state_59870[(16)]);
var inst_59844 = (state_59870[(2)]);
var inst_59845 = (inst_59829 < inst_59828);
var state_59870__$1 = (function (){var statearr_59897 = state_59870;
(statearr_59897[(17)] = inst_59844);

return statearr_59897;
})();
if(cljs.core.truth_(inst_59845)){
var statearr_59898_59960 = state_59870__$1;
(statearr_59898_59960[(1)] = (35));

} else {
var statearr_59899_59961 = state_59870__$1;
(statearr_59899_59961[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (17))){
var inst_59784 = (state_59870[(18)]);
var inst_59782 = (state_59870[(8)]);
var inst_59787 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59782], 0));
var inst_59788 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59784], 0));
var inst_59789 = ["Start block is out of range for this ledger. Start block provided: ",inst_59787,". Database block: ",inst_59788].join('');
var inst_59790 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59791 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59792 = cljs.core.PersistentHashMap.fromArrays(inst_59790,inst_59791);
var inst_59793 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59789,inst_59792);
var inst_59794 = (function(){throw inst_59793})();
var state_59870__$1 = state_59870;
var statearr_59900_59962 = state_59870__$1;
(statearr_59900_59962[(2)] = inst_59794);

(statearr_59900_59962[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (3))){
var inst_59868 = (state_59870[(2)]);
var state_59870__$1 = state_59870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59870__$1,inst_59868);
} else {
if((state_val_59871 === (12))){
var inst_59768 = (state_59870[(14)]);
var inst_59759 = (state_59870[(12)]);
var inst_59766 = (state_59870[(2)]);
var inst_59767 = fluree.db.util.async.throw_err(inst_59766);
var inst_59768__$1 = cljs.core.second(inst_59759);
var state_59870__$1 = (function (){var statearr_59901 = state_59870;
(statearr_59901[(14)] = inst_59768__$1);

(statearr_59901[(11)] = inst_59767);

return statearr_59901;
})();
if(cljs.core.truth_(inst_59768__$1)){
var statearr_59902_59963 = state_59870__$1;
(statearr_59902_59963[(1)] = (13));

} else {
var statearr_59903_59964 = state_59870__$1;
(statearr_59903_59964[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (2))){
var _ = (function (){var statearr_59904 = state_59870;
(statearr_59904[(4)] = cljs.core.cons((5),(state_59870[(4)])));

return statearr_59904;
})();
var inst_59748 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59749 = cljs.core.sequential_QMARK_(inst_59748);
var state_59870__$1 = state_59870;
if(inst_59749){
var statearr_59905_59965 = state_59870__$1;
(statearr_59905_59965[(1)] = (6));

} else {
var statearr_59906_59966 = state_59870__$1;
(statearr_59906_59966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (23))){
var inst_59783 = (state_59870[(7)]);
var inst_59782 = (state_59870[(8)]);
var inst_59803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59804 = [inst_59782,inst_59783];
var inst_59805 = (new cljs.core.PersistentVector(null,2,(5),inst_59803,inst_59804,null));
var state_59870__$1 = state_59870;
var statearr_59907_59967 = state_59870__$1;
(statearr_59907_59967[(2)] = inst_59805);

(statearr_59907_59967[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (35))){
var inst_59829 = (state_59870[(15)]);
var inst_59828 = (state_59870[(16)]);
var inst_59847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59848 = [inst_59829,inst_59828];
var inst_59849 = (new cljs.core.PersistentVector(null,2,(5),inst_59847,inst_59848,null));
var state_59870__$1 = state_59870;
var statearr_59908_59968 = state_59870__$1;
(statearr_59908_59968[(2)] = inst_59849);

(statearr_59908_59968[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (19))){
var inst_59782 = (state_59870[(8)]);
var inst_59797 = (state_59870[(2)]);
var state_59870__$1 = (function (){var statearr_59909 = state_59870;
(statearr_59909[(19)] = inst_59797);

return statearr_59909;
})();
if(cljs.core.truth_(inst_59782)){
var statearr_59910_59969 = state_59870__$1;
(statearr_59910_59969[(1)] = (20));

} else {
var statearr_59911_59970 = state_59870__$1;
(statearr_59911_59970[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (11))){
var inst_59784 = (state_59870[(18)]);
var inst_59782 = (state_59870[(8)]);
var inst_59781 = (state_59870[(2)]);
var inst_59782__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59781,(0),null);
var inst_59783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59781,(1),null);
var inst_59784__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59785 = (inst_59782__$1 > inst_59784__$1);
var state_59870__$1 = (function (){var statearr_59913 = state_59870;
(statearr_59913[(18)] = inst_59784__$1);

(statearr_59913[(7)] = inst_59783);

(statearr_59913[(8)] = inst_59782__$1);

return statearr_59913;
})();
if(cljs.core.truth_(inst_59785)){
var statearr_59914_59971 = state_59870__$1;
(statearr_59914_59971[(1)] = (17));

} else {
var statearr_59915_59972 = state_59870__$1;
(statearr_59915_59972[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (9))){
var inst_59759 = (state_59870[(12)]);
var inst_59762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59763 = cljs.core.first(inst_59759);
var inst_59764 = fluree.db.time_travel.block_to_int_format(db,inst_59763);
var state_59870__$1 = (function (){var statearr_59916 = state_59870;
(statearr_59916[(10)] = inst_59762);

return statearr_59916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59870__$1,(12),inst_59764);
} else {
if((state_val_59871 === (5))){
var _ = (function (){var statearr_59917 = state_59870;
(statearr_59917[(4)] = cljs.core.rest((state_59870[(4)])));

return statearr_59917;
})();
var state_59870__$1 = state_59870;
var ex59912 = (state_59870__$1[(2)]);
var statearr_59918_59973 = state_59870__$1;
(statearr_59918_59973[(5)] = ex59912);


if((ex59912 instanceof Error)){
var statearr_59919_59974 = state_59870__$1;
(statearr_59919_59974[(1)] = (4));

(statearr_59919_59974[(5)] = null);

} else {
throw ex59912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (14))){
var state_59870__$1 = state_59870;
var statearr_59920_59975 = state_59870__$1;
(statearr_59920_59975[(2)] = null);

(statearr_59920_59975[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (26))){
var inst_59782 = (state_59870[(8)]);
var inst_59808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59809 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59810 = [inst_59782,inst_59809];
var inst_59811 = (new cljs.core.PersistentVector(null,2,(5),inst_59808,inst_59810,null));
var state_59870__$1 = state_59870;
var statearr_59921_59976 = state_59870__$1;
(statearr_59921_59976[(2)] = inst_59811);

(statearr_59921_59976[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (16))){
var inst_59772 = (state_59870[(2)]);
var inst_59773 = fluree.db.util.async.throw_err(inst_59772);
var state_59870__$1 = state_59870;
var statearr_59922_59977 = state_59870__$1;
(statearr_59922_59977[(2)] = inst_59773);

(statearr_59922_59977[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (38))){
var inst_59784 = (state_59870[(18)]);
var state_59870__$1 = state_59870;
var statearr_59923_59978 = state_59870__$1;
(statearr_59923_59978[(2)] = inst_59784);

(statearr_59923_59978[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (30))){
var state_59870__$1 = state_59870;
var statearr_59924_59979 = state_59870__$1;
(statearr_59924_59979[(2)] = null);

(statearr_59924_59979[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (10))){
var inst_59759 = (state_59870[(12)]);
var state_59870__$1 = state_59870;
var statearr_59925_59980 = state_59870__$1;
(statearr_59925_59980[(2)] = inst_59759);

(statearr_59925_59980[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (18))){
var state_59870__$1 = state_59870;
var statearr_59926_59981 = state_59870__$1;
(statearr_59926_59981[(2)] = null);

(statearr_59926_59981[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (37))){
var inst_59784 = (state_59870[(18)]);
var inst_59857 = (state_59870[(9)]);
var inst_59855 = (state_59870[(2)]);
var inst_59856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59855,(0),null);
var inst_59857__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59855,(1),null);
var inst_59858 = (inst_59857__$1 > inst_59784);
var state_59870__$1 = (function (){var statearr_59927 = state_59870;
(statearr_59927[(13)] = inst_59856);

(statearr_59927[(9)] = inst_59857__$1);

return statearr_59927;
})();
if(cljs.core.truth_(inst_59858)){
var statearr_59928_59982 = state_59870__$1;
(statearr_59928_59982[(1)] = (38));

} else {
var statearr_59929_59983 = state_59870__$1;
(statearr_59929_59983[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59871 === (8))){
var inst_59759 = (state_59870[(12)]);
var inst_59759__$1 = (state_59870[(2)]);
var inst_59760 = cljs.core.some(cljs.core.string_QMARK_,inst_59759__$1);
var state_59870__$1 = (function (){var statearr_59930 = state_59870;
(statearr_59930[(12)] = inst_59759__$1);

return statearr_59930;
})();
if(cljs.core.truth_(inst_59760)){
var statearr_59931_59984 = state_59870__$1;
(statearr_59931_59984[(1)] = (9));

} else {
var statearr_59932_59985 = state_59870__$1;
(statearr_59932_59985[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0 = (function (){
var statearr_59933 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59933[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__);

(statearr_59933[(1)] = (1));

return statearr_59933;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1 = (function (state_59870){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_59870);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e59934){var ex__2417__auto__ = e59934;
var statearr_59935_59986 = state_59870;
(statearr_59935_59986[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_59870[(4)]))){
var statearr_59936_59987 = state_59870;
(statearr_59936_59987[(1)] = cljs.core.first((state_59870[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59988 = state_59870;
state_59870 = G__59988;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__ = function(state_59870){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1.call(this,state_59870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_59937 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_59937[(6)] = c__2436__auto__);

return statearr_59937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60138){
var state_val_60139 = (state_60138[(1)]);
if((state_val_60139 === (7))){
var inst_60050 = (state_60138[(2)]);
var inst_60051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60050,(0),null);
var inst_60052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60050,(1),null);
var inst_60060 = cljs.core.vals(inst_60052);
var inst_60061 = cljs.core.seq(inst_60060);
var inst_60062 = cljs.core.first(inst_60061);
var inst_60063 = cljs.core.next(inst_60061);
var inst_60064 = cljs.core.PersistentVector.EMPTY;
var inst_60065 = inst_60060;
var inst_60066 = inst_60064;
var state_60138__$1 = (function (){var statearr_60140 = state_60138;
(statearr_60140[(7)] = inst_60051);

(statearr_60140[(8)] = inst_60066);

(statearr_60140[(9)] = inst_60063);

(statearr_60140[(10)] = inst_60065);

(statearr_60140[(11)] = inst_60062);

return statearr_60140;
})();
var statearr_60141_60194 = state_60138__$1;
(statearr_60141_60194[(2)] = null);

(statearr_60141_60194[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (20))){
var inst_60072 = (state_60138[(12)]);
var inst_60077 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60078 = cljs.core.PersistentHashMap.EMPTY;
var inst_60079 = [true,inst_60078];
var inst_60080 = cljs.core.PersistentHashMap.fromArrays(inst_60077,inst_60079);
var inst_60081 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60080,inst_60072);
var state_60138__$1 = state_60138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60138__$1,(22),inst_60081);
} else {
if((state_val_60139 === (27))){
var inst_60126 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
var statearr_60142_60195 = state_60138__$1;
(statearr_60142_60195[(2)] = inst_60126);

(statearr_60142_60195[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (1))){
var state_60138__$1 = state_60138;
var statearr_60143_60196 = state_60138__$1;
(statearr_60143_60196[(2)] = null);

(statearr_60143_60196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (24))){
var inst_60090 = (state_60138[(13)]);
var inst_60128 = (state_60138[(2)]);
var inst_60129 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60130 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60131 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60132 = [inst_60130,inst_60131,inst_60090,inst_60128];
var inst_60133 = cljs.core.PersistentHashMap.fromArrays(inst_60129,inst_60132);
var _ = (function (){var statearr_60145 = state_60138;
(statearr_60145[(4)] = cljs.core.rest((state_60138[(4)])));

return statearr_60145;
})();
var state_60138__$1 = state_60138;
var statearr_60146_60197 = state_60138__$1;
(statearr_60146_60197[(2)] = inst_60133);

(statearr_60146_60197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (4))){
var inst_59991 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
var statearr_60147_60198 = state_60138__$1;
(statearr_60147_60198[(2)] = inst_59991);

(statearr_60147_60198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (15))){
var inst_60036 = (state_60138[(14)]);
var inst_60013 = (state_60138[(15)]);
var inst_60021 = (state_60138[(16)]);
var inst_60010 = (state_60138[(17)]);
var inst_60015 = (state_60138[(18)]);
var inst_60029 = (state_60138[(19)]);
var inst_60014 = (state_60138[(20)]);
var inst_60007 = (state_60138[(21)]);
var inst_60022 = (state_60138[(22)]);
var inst_60031 = (state_60138[(23)]);
var inst_60009 = (state_60138[(24)]);
var inst_60042 = (function (){var G__60003 = inst_60013;
var subject = inst_60029;
var flake = inst_60021;
var first__60019 = inst_60021;
var r = inst_60022;
var asserted_subjects = inst_60014;
var vec__60017 = inst_60013;
var first__60006 = inst_60009;
var flake_SINGLEQUOTE_ = inst_60036;
var retracted_subjects = inst_60015;
var vec__60004 = inst_60007;
var seq__60018 = inst_60022;
var seq__60005 = inst_60010;
var asserted_QMARK_ = inst_60031;
return (function (p1__59990_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59990_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60043 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60015,inst_60029,inst_60042);
var tmp60144 = inst_60014;
var inst_60013__$1 = inst_60022;
var inst_60014__$1 = tmp60144;
var inst_60015__$1 = inst_60043;
var state_60138__$1 = (function (){var statearr_60148 = state_60138;
(statearr_60148[(15)] = inst_60013__$1);

(statearr_60148[(18)] = inst_60015__$1);

(statearr_60148[(20)] = inst_60014__$1);

return statearr_60148;
})();
var statearr_60149_60199 = state_60138__$1;
(statearr_60149_60199[(2)] = null);

(statearr_60149_60199[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (21))){
var inst_60088 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
var statearr_60150_60200 = state_60138__$1;
(statearr_60150_60200[(2)] = inst_60088);

(statearr_60150_60200[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (13))){
var inst_60031 = (state_60138[(23)]);
var inst_60036 = (state_60138[(2)]);
var state_60138__$1 = (function (){var statearr_60151 = state_60138;
(statearr_60151[(14)] = inst_60036);

return statearr_60151;
})();
if(cljs.core.truth_(inst_60031)){
var statearr_60152_60201 = state_60138__$1;
(statearr_60152_60201[(1)] = (14));

} else {
var statearr_60153_60202 = state_60138__$1;
(statearr_60153_60202[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (22))){
var inst_60066 = (state_60138[(8)]);
var inst_60073 = (state_60138[(25)]);
var inst_60083 = (state_60138[(2)]);
var inst_60084 = fluree.db.util.async.throw_err(inst_60083);
var inst_60085 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60066,inst_60084);
var inst_60065 = inst_60073;
var inst_60066__$1 = inst_60085;
var state_60138__$1 = (function (){var statearr_60154 = state_60138;
(statearr_60154[(8)] = inst_60066__$1);

(statearr_60154[(10)] = inst_60065);

return statearr_60154;
})();
var statearr_60155_60203 = state_60138__$1;
(statearr_60155_60203[(2)] = null);

(statearr_60155_60203[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (6))){
var inst_60013 = (state_60138[(15)]);
var inst_60021 = (state_60138[(16)]);
var inst_60020 = cljs.core.seq(inst_60013);
var inst_60021__$1 = cljs.core.first(inst_60020);
var inst_60022 = cljs.core.next(inst_60020);
var inst_60023 = cljs.core.not(inst_60021__$1);
var state_60138__$1 = (function (){var statearr_60156 = state_60138;
(statearr_60156[(16)] = inst_60021__$1);

(statearr_60156[(22)] = inst_60022);

return statearr_60156;
})();
if(inst_60023){
var statearr_60157_60204 = state_60138__$1;
(statearr_60157_60204[(1)] = (8));

} else {
var statearr_60158_60205 = state_60138__$1;
(statearr_60158_60205[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (28))){
var inst_60111 = (state_60138[(26)]);
var inst_60104 = (state_60138[(27)]);
var inst_60121 = (state_60138[(2)]);
var inst_60122 = fluree.db.util.async.throw_err(inst_60121);
var inst_60123 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60104,inst_60122);
var inst_60103 = inst_60111;
var inst_60104__$1 = inst_60123;
var state_60138__$1 = (function (){var statearr_60159 = state_60138;
(statearr_60159[(28)] = inst_60103);

(statearr_60159[(27)] = inst_60104__$1);

return statearr_60159;
})();
var statearr_60160_60206 = state_60138__$1;
(statearr_60160_60206[(2)] = null);

(statearr_60160_60206[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (25))){
var inst_60104 = (state_60138[(27)]);
var state_60138__$1 = state_60138;
var statearr_60161_60207 = state_60138__$1;
(statearr_60161_60207[(2)] = inst_60104);

(statearr_60161_60207[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (17))){
var inst_60072 = (state_60138[(12)]);
var inst_60065 = (state_60138[(10)]);
var inst_60071 = cljs.core.seq(inst_60065);
var inst_60072__$1 = cljs.core.first(inst_60071);
var inst_60073 = cljs.core.next(inst_60071);
var inst_60074 = cljs.core.not(inst_60072__$1);
var state_60138__$1 = (function (){var statearr_60162 = state_60138;
(statearr_60162[(25)] = inst_60073);

(statearr_60162[(12)] = inst_60072__$1);

return statearr_60162;
})();
if(inst_60074){
var statearr_60163_60208 = state_60138__$1;
(statearr_60163_60208[(1)] = (19));

} else {
var statearr_60164_60209 = state_60138__$1;
(statearr_60164_60209[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (3))){
var inst_60136 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60138__$1,inst_60136);
} else {
if((state_val_60139 === (12))){
var inst_60021 = (state_60138[(16)]);
var inst_60034 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60021);
var state_60138__$1 = state_60138;
var statearr_60165_60210 = state_60138__$1;
(statearr_60165_60210[(2)] = inst_60034);

(statearr_60165_60210[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (2))){
var inst_60007 = (state_60138[(21)]);
var _ = (function (){var statearr_60166 = state_60138;
(statearr_60166[(4)] = cljs.core.cons((5),(state_60138[(4)])));

return statearr_60166;
})();
var inst_60007__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60008 = cljs.core.seq(inst_60007__$1);
var inst_60009 = cljs.core.first(inst_60008);
var inst_60010 = cljs.core.next(inst_60008);
var inst_60011 = cljs.core.PersistentHashMap.EMPTY;
var inst_60012 = cljs.core.PersistentHashMap.EMPTY;
var inst_60013 = inst_60007__$1;
var inst_60014 = inst_60011;
var inst_60015 = inst_60012;
var state_60138__$1 = (function (){var statearr_60167 = state_60138;
(statearr_60167[(15)] = inst_60013);

(statearr_60167[(17)] = inst_60010);

(statearr_60167[(18)] = inst_60015);

(statearr_60167[(20)] = inst_60014);

(statearr_60167[(21)] = inst_60007__$1);

(statearr_60167[(24)] = inst_60009);

return statearr_60167;
})();
var statearr_60168_60211 = state_60138__$1;
(statearr_60168_60211[(2)] = null);

(statearr_60168_60211[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (23))){
var inst_60103 = (state_60138[(28)]);
var inst_60110 = (state_60138[(29)]);
var inst_60109 = cljs.core.seq(inst_60103);
var inst_60110__$1 = cljs.core.first(inst_60109);
var inst_60111 = cljs.core.next(inst_60109);
var inst_60112 = cljs.core.not(inst_60110__$1);
var state_60138__$1 = (function (){var statearr_60169 = state_60138;
(statearr_60169[(26)] = inst_60111);

(statearr_60169[(29)] = inst_60110__$1);

return statearr_60169;
})();
if(inst_60112){
var statearr_60170_60212 = state_60138__$1;
(statearr_60170_60212[(1)] = (25));

} else {
var statearr_60171_60213 = state_60138__$1;
(statearr_60171_60213[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (19))){
var inst_60066 = (state_60138[(8)]);
var state_60138__$1 = state_60138;
var statearr_60172_60214 = state_60138__$1;
(statearr_60172_60214[(2)] = inst_60066);

(statearr_60172_60214[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (11))){
var inst_60021 = (state_60138[(16)]);
var state_60138__$1 = state_60138;
var statearr_60174_60215 = state_60138__$1;
(statearr_60174_60215[(2)] = inst_60021);

(statearr_60174_60215[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (9))){
var inst_60021 = (state_60138[(16)]);
var inst_60031 = (state_60138[(23)]);
var inst_60029 = inst_60021.s;
var inst_60030 = inst_60021.op;
var inst_60031__$1 = inst_60030 === true;
var state_60138__$1 = (function (){var statearr_60176 = state_60138;
(statearr_60176[(19)] = inst_60029);

(statearr_60176[(23)] = inst_60031__$1);

return statearr_60176;
})();
if(cljs.core.truth_(inst_60031__$1)){
var statearr_60177_60216 = state_60138__$1;
(statearr_60177_60216[(1)] = (11));

} else {
var statearr_60178_60217 = state_60138__$1;
(statearr_60178_60217[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (5))){
var _ = (function (){var statearr_60179 = state_60138;
(statearr_60179[(4)] = cljs.core.rest((state_60138[(4)])));

return statearr_60179;
})();
var state_60138__$1 = state_60138;
var ex60173 = (state_60138__$1[(2)]);
var statearr_60180_60218 = state_60138__$1;
(statearr_60180_60218[(5)] = ex60173);


if((ex60173 instanceof Error)){
var statearr_60181_60219 = state_60138__$1;
(statearr_60181_60219[(1)] = (4));

(statearr_60181_60219[(5)] = null);

} else {
throw ex60173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (14))){
var inst_60036 = (state_60138[(14)]);
var inst_60013 = (state_60138[(15)]);
var inst_60021 = (state_60138[(16)]);
var inst_60010 = (state_60138[(17)]);
var inst_60015 = (state_60138[(18)]);
var inst_60029 = (state_60138[(19)]);
var inst_60014 = (state_60138[(20)]);
var inst_60007 = (state_60138[(21)]);
var inst_60022 = (state_60138[(22)]);
var inst_60031 = (state_60138[(23)]);
var inst_60009 = (state_60138[(24)]);
var inst_60038 = (function (){var G__60003 = inst_60013;
var subject = inst_60029;
var flake = inst_60021;
var first__60019 = inst_60021;
var r = inst_60022;
var asserted_subjects = inst_60014;
var vec__60017 = inst_60013;
var first__60006 = inst_60009;
var flake_SINGLEQUOTE_ = inst_60036;
var retracted_subjects = inst_60015;
var vec__60004 = inst_60007;
var seq__60018 = inst_60022;
var seq__60005 = inst_60010;
var asserted_QMARK_ = inst_60031;
return (function (p1__59989_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59989_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60039 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60014,inst_60029,inst_60038);
var tmp60175 = inst_60015;
var inst_60013__$1 = inst_60022;
var inst_60014__$1 = inst_60039;
var inst_60015__$1 = tmp60175;
var state_60138__$1 = (function (){var statearr_60182 = state_60138;
(statearr_60182[(15)] = inst_60013__$1);

(statearr_60182[(18)] = inst_60015__$1);

(statearr_60182[(20)] = inst_60014__$1);

return statearr_60182;
})();
var statearr_60183_60220 = state_60138__$1;
(statearr_60183_60220[(2)] = null);

(statearr_60183_60220[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (26))){
var inst_60110 = (state_60138[(29)]);
var inst_60115 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60116 = cljs.core.PersistentHashMap.EMPTY;
var inst_60117 = [true,inst_60116];
var inst_60118 = cljs.core.PersistentHashMap.fromArrays(inst_60115,inst_60117);
var inst_60119 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60118,inst_60110);
var state_60138__$1 = state_60138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60138__$1,(28),inst_60119);
} else {
if((state_val_60139 === (16))){
var inst_60046 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
var statearr_60184_60221 = state_60138__$1;
(statearr_60184_60221[(2)] = inst_60046);

(statearr_60184_60221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (10))){
var inst_60048 = (state_60138[(2)]);
var state_60138__$1 = state_60138;
var statearr_60185_60222 = state_60138__$1;
(statearr_60185_60222[(2)] = inst_60048);

(statearr_60185_60222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (18))){
var inst_60051 = (state_60138[(7)]);
var inst_60090 = (state_60138[(2)]);
var inst_60098 = cljs.core.vals(inst_60051);
var inst_60099 = cljs.core.seq(inst_60098);
var inst_60100 = cljs.core.first(inst_60099);
var inst_60101 = cljs.core.next(inst_60099);
var inst_60102 = cljs.core.PersistentVector.EMPTY;
var inst_60103 = inst_60098;
var inst_60104 = inst_60102;
var state_60138__$1 = (function (){var statearr_60186 = state_60138;
(statearr_60186[(28)] = inst_60103);

(statearr_60186[(30)] = inst_60101);

(statearr_60186[(27)] = inst_60104);

(statearr_60186[(13)] = inst_60090);

(statearr_60186[(31)] = inst_60100);

return statearr_60186;
})();
var statearr_60187_60223 = state_60138__$1;
(statearr_60187_60223[(2)] = null);

(statearr_60187_60223[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60139 === (8))){
var inst_60015 = (state_60138[(18)]);
var inst_60014 = (state_60138[(20)]);
var inst_60025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60026 = [inst_60014,inst_60015];
var inst_60027 = (new cljs.core.PersistentVector(null,2,(5),inst_60025,inst_60026,null));
var state_60138__$1 = state_60138;
var statearr_60188_60224 = state_60138__$1;
(statearr_60188_60224[(2)] = inst_60027);

(statearr_60188_60224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_60189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60189[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__);

(statearr_60189[(1)] = (1));

return statearr_60189;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1 = (function (state_60138){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60138);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60190){var ex__2417__auto__ = e60190;
var statearr_60191_60225 = state_60138;
(statearr_60191_60225[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60138[(4)]))){
var statearr_60192_60226 = state_60138;
(statearr_60192_60226[(1)] = cljs.core.first((state_60138[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60227 = state_60138;
state_60138 = G__60227;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__ = function(state_60138){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1.call(this,state_60138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60193 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60193[(6)] = c__2436__auto__);

return statearr_60193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60259){
var state_val_60260 = (state_60259[(1)]);
if((state_val_60260 === (1))){
var inst_60228 = cljs.core.volatile_BANG_((0));
var inst_60229 = cljs.core.PersistentHashMap.EMPTY;
var inst_60230 = cljs.core.volatile_BANG_(inst_60229);
var inst_60231 = cljs.core.first(resp);
var inst_60232 = cljs.core.rest(resp);
var inst_60233 = cljs.core.PersistentVector.EMPTY;
var inst_60234 = inst_60228;
var inst_60235 = inst_60230;
var inst_60236 = inst_60231;
var inst_60237 = inst_60232;
var inst_60238 = inst_60233;
var state_60259__$1 = (function (){var statearr_60261 = state_60259;
(statearr_60261[(7)] = inst_60237);

(statearr_60261[(8)] = inst_60235);

(statearr_60261[(9)] = inst_60234);

(statearr_60261[(10)] = inst_60236);

(statearr_60261[(11)] = inst_60238);

return statearr_60261;
})();
var statearr_60262_60277 = state_60259__$1;
(statearr_60262_60277[(2)] = null);

(statearr_60262_60277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60260 === (2))){
var inst_60235 = (state_60259[(8)]);
var inst_60234 = (state_60259[(9)]);
var inst_60236 = (state_60259[(10)]);
var inst_60240 = fluree.db.api.query.format_block_resp_pretty(db,inst_60236,inst_60235,inst_60234);
var state_60259__$1 = state_60259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60259__$1,(4),inst_60240);
} else {
if((state_val_60260 === (3))){
var inst_60257 = (state_60259[(2)]);
var state_60259__$1 = state_60259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60259__$1,inst_60257);
} else {
if((state_val_60260 === (4))){
var inst_60237 = (state_60259[(7)]);
var inst_60238 = (state_60259[(11)]);
var inst_60242 = (state_60259[(2)]);
var inst_60243 = fluree.db.util.async.throw_err(inst_60242);
var inst_60244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60245 = [inst_60243];
var inst_60246 = (new cljs.core.PersistentVector(null,1,(5),inst_60244,inst_60245,null));
var inst_60247 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60238,inst_60246);
var inst_60248 = cljs.core.first(inst_60237);
var state_60259__$1 = (function (){var statearr_60265 = state_60259;
(statearr_60265[(12)] = inst_60247);

return statearr_60265;
})();
if(cljs.core.truth_(inst_60248)){
var statearr_60266_60278 = state_60259__$1;
(statearr_60266_60278[(1)] = (5));

} else {
var statearr_60267_60279 = state_60259__$1;
(statearr_60267_60279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60260 === (5))){
var inst_60237 = (state_60259[(7)]);
var inst_60235 = (state_60259[(8)]);
var inst_60247 = (state_60259[(12)]);
var inst_60234 = (state_60259[(9)]);
var inst_60250 = cljs.core.first(inst_60237);
var inst_60251 = cljs.core.rest(inst_60237);
var tmp60263 = inst_60235;
var tmp60264 = inst_60234;
var inst_60234__$1 = tmp60264;
var inst_60235__$1 = tmp60263;
var inst_60236 = inst_60250;
var inst_60237__$1 = inst_60251;
var inst_60238 = inst_60247;
var state_60259__$1 = (function (){var statearr_60268 = state_60259;
(statearr_60268[(7)] = inst_60237__$1);

(statearr_60268[(8)] = inst_60235__$1);

(statearr_60268[(9)] = inst_60234__$1);

(statearr_60268[(10)] = inst_60236);

(statearr_60268[(11)] = inst_60238);

return statearr_60268;
})();
var statearr_60269_60280 = state_60259__$1;
(statearr_60269_60280[(2)] = null);

(statearr_60269_60280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60260 === (6))){
var inst_60247 = (state_60259[(12)]);
var state_60259__$1 = state_60259;
var statearr_60270_60281 = state_60259__$1;
(statearr_60270_60281[(2)] = inst_60247);

(statearr_60270_60281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60260 === (7))){
var inst_60255 = (state_60259[(2)]);
var state_60259__$1 = state_60259;
var statearr_60271_60282 = state_60259__$1;
(statearr_60271_60282[(2)] = inst_60255);

(statearr_60271_60282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_60272 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60272[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__);

(statearr_60272[(1)] = (1));

return statearr_60272;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1 = (function (state_60259){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60259);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60273){var ex__2417__auto__ = e60273;
var statearr_60274_60283 = state_60259;
(statearr_60274_60283[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60259[(4)]))){
var statearr_60275_60284 = state_60259;
(statearr_60275_60284[(1)] = cljs.core.first((state_60259[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60285 = state_60259;
state_60259 = G__60285;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__ = function(state_60259){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1.call(this,state_60259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60276 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60276[(6)] = c__2436__auto__);

return statearr_60276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60288 = arguments.length;
switch (G__60288) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60290){
var map__60291 = p__60290;
var map__60291__$1 = (((((!((map__60291 == null))))?(((((map__60291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60291):map__60291);
var query = map__60291__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60291__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60377){
var state_val_60378 = (state_60377[(1)]);
if((state_val_60378 === (7))){
var inst_60303 = (state_60377[(7)]);
var inst_60307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60308 = ["_auth/id",inst_60303];
var inst_60309 = (new cljs.core.PersistentVector(null,2,(5),inst_60307,inst_60308,null));
var state_60377__$1 = state_60377;
var statearr_60379_60423 = state_60377__$1;
(statearr_60379_60423[(2)] = inst_60309);

(statearr_60379_60423[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (20))){
var inst_60357 = (state_60377[(2)]);
var inst_60358 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60377__$1 = (function (){var statearr_60380 = state_60377;
(statearr_60380[(8)] = inst_60357);

return statearr_60380;
})();
if(cljs.core.truth_(inst_60358)){
var statearr_60381_60424 = state_60377__$1;
(statearr_60381_60424[(1)] = (22));

} else {
var statearr_60382_60425 = state_60377__$1;
(statearr_60382_60425[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (27))){
var inst_60360 = (state_60377[(9)]);
var inst_60304 = (state_60377[(10)]);
var inst_60366 = (state_60377[(2)]);
var inst_60367 = fluree.db.api.query.response_time_formatted(inst_60304);
var inst_60368 = [(200),inst_60366,(100),inst_60367];
var inst_60369 = cljs.core.PersistentHashMap.fromArrays(inst_60360,inst_60368);
var state_60377__$1 = state_60377;
var statearr_60383_60426 = state_60377__$1;
(statearr_60383_60426[(2)] = inst_60369);

(statearr_60383_60426[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (1))){
var state_60377__$1 = state_60377;
var statearr_60384_60427 = state_60377__$1;
(statearr_60384_60427[(2)] = null);

(statearr_60384_60427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (24))){
var inst_60372 = (state_60377[(2)]);
var _ = (function (){var statearr_60385 = state_60377;
(statearr_60385[(4)] = cljs.core.rest((state_60377[(4)])));

return statearr_60385;
})();
var state_60377__$1 = state_60377;
var statearr_60386_60428 = state_60377__$1;
(statearr_60386_60428[(2)] = inst_60372);

(statearr_60386_60428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (4))){
var inst_60293 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60387_60429 = state_60377__$1;
(statearr_60387_60429[(2)] = inst_60293);

(statearr_60387_60429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (15))){
var inst_60344 = (state_60377[(11)]);
var state_60377__$1 = state_60377;
var statearr_60388_60430 = state_60377__$1;
(statearr_60388_60430[(2)] = inst_60344);

(statearr_60388_60430[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (21))){
var inst_60353 = (state_60377[(2)]);
var inst_60354 = fluree.db.util.async.throw_err(inst_60353);
var state_60377__$1 = state_60377;
var statearr_60389_60431 = state_60377__$1;
(statearr_60389_60431[(2)] = inst_60354);

(statearr_60389_60431[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (13))){
var inst_60302 = (state_60377[(12)]);
var inst_60344 = (state_60377[(11)]);
var inst_60343 = (state_60377[(2)]);
var inst_60344__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60302);
var state_60377__$1 = (function (){var statearr_60390 = state_60377;
(statearr_60390[(11)] = inst_60344__$1);

(statearr_60390[(13)] = inst_60343);

return statearr_60390;
})();
if(cljs.core.truth_(inst_60344__$1)){
var statearr_60391_60432 = state_60377__$1;
(statearr_60391_60432[(1)] = (15));

} else {
var statearr_60392_60433 = state_60377__$1;
(statearr_60392_60433[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (22))){
var inst_60357 = (state_60377[(8)]);
var inst_60360 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60361 = cljs.core.sequential_QMARK_(inst_60357);
var state_60377__$1 = (function (){var statearr_60393 = state_60377;
(statearr_60393[(9)] = inst_60360);

return statearr_60393;
})();
if(inst_60361){
var statearr_60394_60434 = state_60377__$1;
(statearr_60394_60434[(1)] = (25));

} else {
var statearr_60395_60435 = state_60377__$1;
(statearr_60395_60435[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (6))){
var inst_60302 = (state_60377[(12)]);
var inst_60318 = (state_60377[(14)]);
var inst_60317 = (state_60377[(2)]);
var inst_60318__$1 = fluree.db.util.async.throw_err(inst_60317);
var inst_60319 = fluree.db.api.query.resolve_block_range(inst_60318__$1,inst_60302);
var state_60377__$1 = (function (){var statearr_60396 = state_60377;
(statearr_60396[(14)] = inst_60318__$1);

return statearr_60396;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60377__$1,(10),inst_60319);
} else {
if((state_val_60378 === (25))){
var inst_60357 = (state_60377[(8)]);
var inst_60363 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60357);
var state_60377__$1 = state_60377;
var statearr_60397_60436 = state_60377__$1;
(statearr_60397_60436[(2)] = inst_60363);

(statearr_60397_60436[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (17))){
var inst_60349 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
if(cljs.core.truth_(inst_60349)){
var statearr_60398_60437 = state_60377__$1;
(statearr_60398_60437[(1)] = (18));

} else {
var statearr_60399_60438 = state_60377__$1;
(statearr_60399_60438[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (3))){
var inst_60375 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60377__$1,inst_60375);
} else {
if((state_val_60378 === (12))){
var inst_60302 = (state_60377[(12)]);
var inst_60335 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60302], 0));
var inst_60336 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60335].join('');
var inst_60337 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60338 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60339 = cljs.core.PersistentHashMap.fromArrays(inst_60337,inst_60338);
var inst_60340 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60336,inst_60339);
var inst_60341 = (function(){throw inst_60340})();
var state_60377__$1 = state_60377;
var statearr_60400_60439 = state_60377__$1;
(statearr_60400_60439[(2)] = inst_60341);

(statearr_60400_60439[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (2))){
var inst_60303 = (state_60377[(7)]);
var _ = (function (){var statearr_60401 = state_60377;
(statearr_60401[(4)] = cljs.core.cons((5),(state_60377[(4)])));

return statearr_60401;
})();
var inst_60302 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60303__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60304 = fluree.db.util.core.current_time_millis();
var inst_60305 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60377__$1 = (function (){var statearr_60402 = state_60377;
(statearr_60402[(12)] = inst_60302);

(statearr_60402[(15)] = inst_60305);

(statearr_60402[(7)] = inst_60303__$1);

(statearr_60402[(10)] = inst_60304);

return statearr_60402;
})();
if(cljs.core.truth_(inst_60303__$1)){
var statearr_60403_60440 = state_60377__$1;
(statearr_60403_60440[(1)] = (7));

} else {
var statearr_60404_60441 = state_60377__$1;
(statearr_60404_60441[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (23))){
var inst_60357 = (state_60377[(8)]);
var state_60377__$1 = state_60377;
var statearr_60405_60442 = state_60377__$1;
(statearr_60405_60442[(2)] = inst_60357);

(statearr_60405_60442[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (19))){
var inst_60343 = (state_60377[(13)]);
var state_60377__$1 = state_60377;
var statearr_60406_60443 = state_60377__$1;
(statearr_60406_60443[(2)] = inst_60343);

(statearr_60406_60443[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (11))){
var inst_60324 = (state_60377[(16)]);
var inst_60323 = (state_60377[(17)]);
var inst_60318 = (state_60377[(14)]);
var inst_60330 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60318,inst_60323,inst_60324,opts);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60377__$1,(14),inst_60330);
} else {
if((state_val_60378 === (9))){
var inst_60305 = (state_60377[(15)]);
var inst_60312 = (state_60377[(2)]);
var inst_60313 = [inst_60312];
var inst_60314 = cljs.core.PersistentHashMap.fromArrays(inst_60305,inst_60313);
var inst_60315 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60314);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60377__$1,(6),inst_60315);
} else {
if((state_val_60378 === (5))){
var _ = (function (){var statearr_60408 = state_60377;
(statearr_60408[(4)] = cljs.core.rest((state_60377[(4)])));

return statearr_60408;
})();
var state_60377__$1 = state_60377;
var ex60407 = (state_60377__$1[(2)]);
var statearr_60409_60444 = state_60377__$1;
(statearr_60409_60444[(5)] = ex60407);


if((ex60407 instanceof Error)){
var statearr_60410_60445 = state_60377__$1;
(statearr_60410_60445[(1)] = (4));

(statearr_60410_60445[(5)] = null);

} else {
throw ex60407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (14))){
var inst_60332 = (state_60377[(2)]);
var inst_60333 = fluree.db.util.async.throw_err(inst_60332);
var state_60377__$1 = state_60377;
var statearr_60411_60446 = state_60377__$1;
(statearr_60411_60446[(2)] = inst_60333);

(statearr_60411_60446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (26))){
var inst_60357 = (state_60377[(8)]);
var state_60377__$1 = state_60377;
var statearr_60412_60447 = state_60377__$1;
(statearr_60412_60447[(2)] = inst_60357);

(statearr_60412_60447[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (16))){
var inst_60302 = (state_60377[(12)]);
var inst_60347 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60302);
var state_60377__$1 = state_60377;
var statearr_60413_60448 = state_60377__$1;
(statearr_60413_60448[(2)] = inst_60347);

(statearr_60413_60448[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (10))){
var inst_60302 = (state_60377[(12)]);
var inst_60321 = (state_60377[(2)]);
var inst_60322 = fluree.db.util.async.throw_err(inst_60321);
var inst_60323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60322,(0),null);
var inst_60324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60322,(1),null);
var inst_60325 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60326 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60302,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60327 = cljs.core.keys(inst_60326);
var inst_60328 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60325,inst_60327);
var state_60377__$1 = (function (){var statearr_60414 = state_60377;
(statearr_60414[(16)] = inst_60324);

(statearr_60414[(17)] = inst_60323);

return statearr_60414;
})();
if(inst_60328){
var statearr_60415_60449 = state_60377__$1;
(statearr_60415_60449[(1)] = (11));

} else {
var statearr_60416_60450 = state_60377__$1;
(statearr_60416_60450[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (18))){
var inst_60343 = (state_60377[(13)]);
var inst_60318 = (state_60377[(14)]);
var inst_60351 = fluree.db.api.query.format_blocks_resp_pretty(inst_60318,inst_60343);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60377__$1,(21),inst_60351);
} else {
if((state_val_60378 === (8))){
var state_60377__$1 = state_60377;
var statearr_60417_60451 = state_60377__$1;
(statearr_60417_60451[(2)] = null);

(statearr_60417_60451[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_60418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60418[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2414__auto__);

(statearr_60418[(1)] = (1));

return statearr_60418;
});
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1 = (function (state_60377){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60377);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60419){var ex__2417__auto__ = e60419;
var statearr_60420_60452 = state_60377;
(statearr_60420_60452[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60377[(4)]))){
var statearr_60421_60453 = state_60377;
(statearr_60421_60453[(1)] = cljs.core.first((state_60377[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60454 = state_60377;
state_60377 = G__60454;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__ = function(state_60377){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1.call(this,state_60377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60422 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60422[(6)] = c__2436__auto__);

return statearr_60422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60455 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60455,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60455,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60455,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60455,(3),null);
var vec__60458 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60458,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60458,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60461 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60461,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60461,(1),null);
var or__4126__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60465 = arguments.length;
var i__4737__auto___60466 = (0);
while(true){
if((i__4737__auto___60466 < len__4736__auto___60465)){
args__4742__auto__.push((arguments[i__4737__auto___60466]));

var G__60467 = (i__4737__auto___60466 + (1));
i__4737__auto___60466 = G__60467;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60464){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq60464));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60683){
var state_val_60684 = (state_60683[(1)]);
if((state_val_60684 === (7))){
var inst_60590 = (state_60683[(7)]);
var inst_60583 = (state_60683[(8)]);
var inst_60589 = cljs.core.seq(inst_60583);
var inst_60590__$1 = cljs.core.first(inst_60589);
var inst_60591 = cljs.core.next(inst_60589);
var state_60683__$1 = (function (){var statearr_60685 = state_60683;
(statearr_60685[(9)] = inst_60591);

(statearr_60685[(7)] = inst_60590__$1);

return statearr_60685;
})();
if(cljs.core.truth_(inst_60590__$1)){
var statearr_60686_60799 = state_60683__$1;
(statearr_60686_60799[(1)] = (9));

} else {
var statearr_60687_60800 = state_60683__$1;
(statearr_60687_60800[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (20))){
var inst_60673 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60688_60801 = state_60683__$1;
(statearr_60688_60801[(2)] = inst_60673);

(statearr_60688_60801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (27))){
var inst_60609 = (state_60683[(10)]);
var inst_60627 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_60609);
var state_60683__$1 = state_60683;
var statearr_60689_60802 = state_60683__$1;
(statearr_60689_60802[(2)] = inst_60627);

(statearr_60689_60802[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (1))){
var state_60683__$1 = state_60683;
var statearr_60690_60803 = state_60683__$1;
(statearr_60690_60803[(2)] = null);

(statearr_60690_60803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (24))){
var state_60683__$1 = state_60683;
var statearr_60691_60804 = state_60683__$1;
(statearr_60691_60804[(2)] = true);

(statearr_60691_60804[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (39))){
var inst_60657 = (state_60683[(11)]);
var inst_60632 = (state_60683[(12)]);
var inst_60631 = (state_60683[(13)]);
var inst_60659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60660 = [inst_60631,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60661 = (new cljs.core.PersistentVector(null,2,(5),inst_60659,inst_60660,null));
var inst_60662 = cljs.core.assoc_in(inst_60657,inst_60661,inst_60632);
var state_60683__$1 = state_60683;
var statearr_60693_60805 = state_60683__$1;
(statearr_60693_60805[(2)] = inst_60662);

(statearr_60693_60805[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (4))){
var inst_60469 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60694_60806 = state_60683__$1;
(statearr_60694_60806[(2)] = inst_60469);

(statearr_60694_60806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (15))){
var inst_60591 = (state_60683[(9)]);
var inst_60584 = (state_60683[(14)]);
var tmp60692 = inst_60584;
var inst_60583 = inst_60591;
var inst_60584__$1 = tmp60692;
var state_60683__$1 = (function (){var statearr_60695 = state_60683;
(statearr_60695[(14)] = inst_60584__$1);

(statearr_60695[(8)] = inst_60583);

return statearr_60695;
})();
var statearr_60696_60807 = state_60683__$1;
(statearr_60696_60807[(2)] = null);

(statearr_60696_60807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (21))){
var inst_60609 = (state_60683[(10)]);
var inst_60614 = inst_60609.cljs$lang$protocol_mask$partition0$;
var inst_60615 = (inst_60614 & (64));
var inst_60616 = inst_60609.cljs$core$ISeq$;
var inst_60617 = (cljs.core.PROTOCOL_SENTINEL === inst_60616);
var inst_60618 = ((inst_60615) || (inst_60617));
var state_60683__$1 = state_60683;
if(cljs.core.truth_(inst_60618)){
var statearr_60697_60808 = state_60683__$1;
(statearr_60697_60808[(1)] = (24));

} else {
var statearr_60698_60809 = state_60683__$1;
(statearr_60698_60809[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (31))){
var inst_60584 = (state_60683[(14)]);
var state_60683__$1 = state_60683;
var statearr_60699_60810 = state_60683__$1;
(statearr_60699_60810[(2)] = inst_60584);

(statearr_60699_60810[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (32))){
var inst_60641 = (state_60683[(2)]);
var state_60683__$1 = (function (){var statearr_60700 = state_60683;
(statearr_60700[(15)] = inst_60641);

return statearr_60700;
})();
var statearr_60701_60811 = state_60683__$1;
(statearr_60701_60811[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (40))){
var inst_60657 = (state_60683[(11)]);
var state_60683__$1 = state_60683;
var statearr_60703_60812 = state_60683__$1;
(statearr_60703_60812[(2)] = inst_60657);

(statearr_60703_60812[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (33))){
var inst_60590 = (state_60683[(7)]);
var inst_60641 = (state_60683[(15)]);
var inst_60631 = (state_60683[(13)]);
var inst_60643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60644 = [inst_60631,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60645 = (new cljs.core.PersistentVector(null,2,(5),inst_60643,inst_60644,null));
var inst_60646 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60641,inst_60645,cljs.core.conj,inst_60590);
var state_60683__$1 = state_60683;
var statearr_60704_60813 = state_60683__$1;
(statearr_60704_60813[(2)] = inst_60646);

(statearr_60704_60813[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (13))){
var inst_60593 = (state_60683[(16)]);
var state_60683__$1 = state_60683;
var statearr_60705_60814 = state_60683__$1;
(statearr_60705_60814[(2)] = inst_60593);

(statearr_60705_60814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (22))){
var state_60683__$1 = state_60683;
var statearr_60706_60815 = state_60683__$1;
(statearr_60706_60815[(2)] = false);

(statearr_60706_60815[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (36))){
var inst_60649 = (state_60683[(17)]);
var inst_60631 = (state_60683[(13)]);
var inst_60608 = (state_60683[(18)]);
var inst_60651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60652 = [inst_60631,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60653 = (new cljs.core.PersistentVector(null,2,(5),inst_60651,inst_60652,null));
var inst_60654 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60649,inst_60653,fluree.db.api.query.min_safe,inst_60608);
var state_60683__$1 = state_60683;
var statearr_60707_60816 = state_60683__$1;
(statearr_60707_60816[(2)] = inst_60654);

(statearr_60707_60816[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (41))){
var inst_60591 = (state_60683[(9)]);
var inst_60665 = (state_60683[(2)]);
var inst_60583 = inst_60591;
var inst_60584 = inst_60665;
var state_60683__$1 = (function (){var statearr_60708 = state_60683;
(statearr_60708[(14)] = inst_60584);

(statearr_60708[(8)] = inst_60583);

return statearr_60708;
})();
var statearr_60709_60817 = state_60683__$1;
(statearr_60709_60817[(2)] = null);

(statearr_60709_60817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (43))){
var state_60683__$1 = state_60683;
var statearr_60710_60818 = state_60683__$1;
(statearr_60710_60818[(2)] = null);

(statearr_60710_60818[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (29))){
var inst_60630 = (state_60683[(2)]);
var inst_60631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60630,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60630,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60683__$1 = (function (){var statearr_60711 = state_60683;
(statearr_60711[(12)] = inst_60632);

(statearr_60711[(13)] = inst_60631);

return statearr_60711;
})();
var statearr_60712_60819 = state_60683__$1;
(statearr_60712_60819[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (44))){
var inst_60671 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60714_60820 = state_60683__$1;
(statearr_60714_60820[(2)] = inst_60671);

(statearr_60714_60820[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (6))){
var inst_60569 = (state_60683[(2)]);
var inst_60570 = fluree.db.util.async.throw_err(inst_60569);
var inst_60578 = resp;
var inst_60579 = cljs.core.seq(inst_60578);
var inst_60580 = cljs.core.first(inst_60579);
var inst_60581 = cljs.core.next(inst_60579);
var inst_60582 = cljs.core.PersistentHashMap.EMPTY;
var inst_60583 = inst_60578;
var inst_60584 = inst_60582;
var state_60683__$1 = (function (){var statearr_60715 = state_60683;
(statearr_60715[(19)] = inst_60570);

(statearr_60715[(20)] = inst_60580);

(statearr_60715[(14)] = inst_60584);

(statearr_60715[(8)] = inst_60583);

(statearr_60715[(21)] = inst_60581);

return statearr_60715;
})();
var statearr_60716_60821 = state_60683__$1;
(statearr_60716_60821[(2)] = null);

(statearr_60716_60821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (28))){
var inst_60609 = (state_60683[(10)]);
var state_60683__$1 = state_60683;
var statearr_60717_60822 = state_60683__$1;
(statearr_60717_60822[(2)] = inst_60609);

(statearr_60717_60822[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (25))){
var state_60683__$1 = state_60683;
var statearr_60718_60823 = state_60683__$1;
(statearr_60718_60823[(2)] = false);

(statearr_60718_60823[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (34))){
var inst_60641 = (state_60683[(15)]);
var state_60683__$1 = state_60683;
var statearr_60719_60824 = state_60683__$1;
(statearr_60719_60824[(2)] = inst_60641);

(statearr_60719_60824[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (17))){
var inst_60675 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60720_60825 = state_60683__$1;
(statearr_60720_60825[(2)] = inst_60675);

(statearr_60720_60825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (3))){
var inst_60681 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60683__$1,inst_60681);
} else {
if((state_val_60684 === (12))){
var inst_60570 = (state_60683[(19)]);
var inst_60590 = (state_60683[(7)]);
var inst_60595 = fluree.db.api.query.auth_match(auth,inst_60570,inst_60590);
var inst_60596 = cljs.core.not(inst_60595);
var state_60683__$1 = state_60683;
var statearr_60721_60826 = state_60683__$1;
(statearr_60721_60826[(2)] = inst_60596);

(statearr_60721_60826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (2))){
var _ = (function (){var statearr_60722 = state_60683;
(statearr_60722[(4)] = cljs.core.cons((5),(state_60683[(4)])));

return statearr_60722;
})();
var inst_60475 = (function (){return (function (p1__60468_SHARP_){
return p1__60468_SHARP_.t;
});
})();
var inst_60476 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60475,resp);
var inst_60477 = cljs.core.set(inst_60476);
var inst_60565 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60566 = (function (){var ts = inst_60477;
var c__2436__auto____$1 = inst_60565;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60563){
var state_val_60564 = (state_60563[(1)]);
if((state_val_60564 === (7))){
var inst_60491 = (state_60563[(7)]);
var inst_60509 = (state_60563[(8)]);
var inst_60503 = (state_60563[(9)]);
var inst_60497 = (state_60563[(10)]);
var inst_60502 = (state_60563[(2)]);
var inst_60503__$1 = fluree.db.util.async.throw_err(inst_60502);
var inst_60505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60506 = [inst_60497,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60507 = (new cljs.core.PersistentVector(null,2,(5),inst_60505,inst_60506,null));
var inst_60508 = cljs.core.assoc_in(inst_60491,inst_60507,inst_60503__$1);
var inst_60509__$1 = auth;
var state_60563__$1 = (function (){var statearr_60723 = state_60563;
(statearr_60723[(11)] = inst_60508);

(statearr_60723[(8)] = inst_60509__$1);

(statearr_60723[(9)] = inst_60503__$1);

return statearr_60723;
})();
if(cljs.core.truth_(inst_60509__$1)){
var statearr_60724_60827 = state_60563__$1;
(statearr_60724_60827[(1)] = (8));

} else {
var statearr_60725_60828 = state_60563__$1;
(statearr_60725_60828[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (1))){
var inst_60485 = (state_60563[(12)]);
var inst_60485__$1 = ts;
var inst_60486 = cljs.core.seq(inst_60485__$1);
var inst_60487 = cljs.core.first(inst_60486);
var inst_60488 = cljs.core.next(inst_60486);
var inst_60489 = cljs.core.PersistentHashMap.EMPTY;
var inst_60490 = inst_60485__$1;
var inst_60491 = inst_60489;
var state_60563__$1 = (function (){var statearr_60726 = state_60563;
(statearr_60726[(13)] = inst_60488);

(statearr_60726[(12)] = inst_60485__$1);

(statearr_60726[(7)] = inst_60491);

(statearr_60726[(14)] = inst_60490);

(statearr_60726[(15)] = inst_60487);

return statearr_60726;
})();
var statearr_60727_60829 = state_60563__$1;
(statearr_60727_60829[(2)] = null);

(statearr_60727_60829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (4))){
var inst_60497 = (state_60563[(10)]);
var inst_60500 = fluree.db.time_travel.non_border_t_to_block(db,inst_60497);
var state_60563__$1 = state_60563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60563__$1,(7),inst_60500);
} else {
if((state_val_60564 === (13))){
var inst_60498 = (state_60563[(16)]);
var inst_60555 = (state_60563[(2)]);
var inst_60490 = inst_60498;
var inst_60491 = inst_60555;
var state_60563__$1 = (function (){var statearr_60728 = state_60563;
(statearr_60728[(7)] = inst_60491);

(statearr_60728[(14)] = inst_60490);

return statearr_60728;
})();
var statearr_60729_60830 = state_60563__$1;
(statearr_60729_60830[(2)] = null);

(statearr_60729_60830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (6))){
var inst_60559 = (state_60563[(2)]);
var state_60563__$1 = state_60563;
var statearr_60730_60831 = state_60563__$1;
(statearr_60730_60831[(2)] = inst_60559);

(statearr_60730_60831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (3))){
var inst_60561 = (state_60563[(2)]);
var state_60563__$1 = state_60563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60563__$1,inst_60561);
} else {
if((state_val_60564 === (12))){
var inst_60508 = (state_60563[(11)]);
var state_60563__$1 = state_60563;
var statearr_60731_60832 = state_60563__$1;
(statearr_60731_60832[(2)] = inst_60508);

(statearr_60731_60832[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (2))){
var inst_60490 = (state_60563[(14)]);
var inst_60497 = (state_60563[(10)]);
var inst_60496 = cljs.core.seq(inst_60490);
var inst_60497__$1 = cljs.core.first(inst_60496);
var inst_60498 = cljs.core.next(inst_60496);
var state_60563__$1 = (function (){var statearr_60732 = state_60563;
(statearr_60732[(16)] = inst_60498);

(statearr_60732[(10)] = inst_60497__$1);

return statearr_60732;
})();
if(cljs.core.truth_(inst_60497__$1)){
var statearr_60733_60833 = state_60563__$1;
(statearr_60733_60833[(1)] = (4));

} else {
var statearr_60734_60834 = state_60563__$1;
(statearr_60734_60834[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (11))){
var inst_60488 = (state_60563[(13)]);
var inst_60485 = (state_60563[(12)]);
var inst_60491 = (state_60563[(7)]);
var inst_60508 = (state_60563[(11)]);
var inst_60490 = (state_60563[(14)]);
var inst_60487 = (state_60563[(15)]);
var inst_60503 = (state_60563[(9)]);
var inst_60498 = (state_60563[(16)]);
var inst_60497 = (state_60563[(10)]);
var inst_60515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60516 = [inst_60497,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60517 = (new cljs.core.PersistentVector(null,2,(5),inst_60515,inst_60516,null));
var inst_60530 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60531 = (function (){var t = inst_60497;
var c__2436__auto____$2 = inst_60530;
var first__60484 = inst_60487;
var seq__60494 = inst_60498;
var block = inst_60503;
var r = inst_60498;
var first__60495 = inst_60497;
var vec__60493 = inst_60490;
var G__60481 = inst_60490;
var seq__60483 = inst_60488;
var acc = inst_60491;
var G__60504 = inst_60508;
var vec__60482 = inst_60485;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60528){
var state_val_60529 = (state_60528[(1)]);
if((state_val_60529 === (1))){
var state_60528__$1 = state_60528;
var statearr_60735_60835 = state_60528__$1;
(statearr_60735_60835[(2)] = null);

(statearr_60735_60835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60529 === (2))){
var ___$1 = (function (){var statearr_60736 = state_60528;
(statearr_60736[(4)] = cljs.core.cons((5),(state_60528[(4)])));

return statearr_60736;
})();
var ___$2 = (function (){var statearr_60737 = state_60528;
(statearr_60737[(4)] = cljs.core.rest((state_60528[(4)])));

return statearr_60737;
})();
var state_60528__$1 = state_60528;
var statearr_60738_60836 = state_60528__$1;
(statearr_60738_60836[(2)] = db);

(statearr_60738_60836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60529 === (3))){
var inst_60526 = (state_60528[(2)]);
var state_60528__$1 = state_60528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60528__$1,inst_60526);
} else {
if((state_val_60529 === (4))){
var inst_60518 = (state_60528[(2)]);
var state_60528__$1 = state_60528;
var statearr_60740_60837 = state_60528__$1;
(statearr_60740_60837[(2)] = inst_60518);

(statearr_60740_60837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60529 === (5))){
var ___$1 = (function (){var statearr_60741 = state_60528;
(statearr_60741[(4)] = cljs.core.rest((state_60528[(4)])));

return statearr_60741;
})();
var state_60528__$1 = state_60528;
var ex60739 = (state_60528__$1[(2)]);
var statearr_60742_60838 = state_60528__$1;
(statearr_60742_60838[(5)] = ex60739);


if((ex60739 instanceof Error)){
var statearr_60743_60839 = state_60528__$1;
(statearr_60743_60839[(1)] = (4));

(statearr_60743_60839[(5)] = null);

} else {
throw ex60739;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_60744 = [null,null,null,null,null,null,null];
(statearr_60744[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_60744[(1)] = (1));

return statearr_60744;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_60528){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60528);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60745){var ex__2417__auto__ = e60745;
var statearr_60746_60840 = state_60528;
(statearr_60746_60840[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60528[(4)]))){
var statearr_60747_60841 = state_60528;
(statearr_60747_60841[(1)] = cljs.core.first((state_60528[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60842 = state_60528;
state_60528 = G__60842;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_60528){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_60528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60748 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60748[(6)] = c__2436__auto____$2);

return statearr_60748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_60532 = cljs.core.async.impl.dispatch.run(inst_60531);
var inst_60533 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60535 = ["?auth","?id"];
var inst_60536 = (new cljs.core.PersistentVector(null,2,(5),inst_60534,inst_60535,null));
var inst_60537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60539 = [inst_60497,"_tx/auth","?auth"];
var inst_60540 = (new cljs.core.PersistentVector(null,3,(5),inst_60538,inst_60539,null));
var inst_60541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60542 = ["?auth","_auth/id","?id"];
var inst_60543 = (new cljs.core.PersistentVector(null,3,(5),inst_60541,inst_60542,null));
var inst_60544 = [inst_60540,inst_60543];
var inst_60545 = (new cljs.core.PersistentVector(null,2,(5),inst_60537,inst_60544,null));
var inst_60546 = [inst_60536,inst_60545];
var inst_60547 = cljs.core.PersistentHashMap.fromArrays(inst_60533,inst_60546);
var inst_60548 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_60530,inst_60547) : fluree.db.api.query.query_async.call(null,inst_60530,inst_60547));
var state_60563__$1 = (function (){var statearr_60749 = state_60563;
(statearr_60749[(17)] = inst_60517);

(statearr_60749[(18)] = inst_60532);

return statearr_60749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60563__$1,(14),inst_60548);
} else {
if((state_val_60564 === (9))){
var state_60563__$1 = state_60563;
var statearr_60750_60843 = state_60563__$1;
(statearr_60750_60843[(2)] = show_auth);

(statearr_60750_60843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (5))){
var inst_60491 = (state_60563[(7)]);
var state_60563__$1 = state_60563;
var statearr_60751_60844 = state_60563__$1;
(statearr_60751_60844[(2)] = inst_60491);

(statearr_60751_60844[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (14))){
var inst_60517 = (state_60563[(17)]);
var inst_60508 = (state_60563[(11)]);
var inst_60550 = (state_60563[(2)]);
var inst_60551 = fluree.db.util.async.throw_err(inst_60550);
var inst_60552 = cljs.core.assoc_in(inst_60508,inst_60517,inst_60551);
var state_60563__$1 = state_60563;
var statearr_60752_60845 = state_60563__$1;
(statearr_60752_60845[(2)] = inst_60552);

(statearr_60752_60845[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (10))){
var inst_60513 = (state_60563[(2)]);
var state_60563__$1 = state_60563;
if(cljs.core.truth_(inst_60513)){
var statearr_60753_60846 = state_60563__$1;
(statearr_60753_60846[(1)] = (11));

} else {
var statearr_60754_60847 = state_60563__$1;
(statearr_60754_60847[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60564 === (8))){
var inst_60509 = (state_60563[(8)]);
var state_60563__$1 = state_60563;
var statearr_60755_60848 = state_60563__$1;
(statearr_60755_60848[(2)] = inst_60509);

(statearr_60755_60848[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_60756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60756[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_60756[(1)] = (1));

return statearr_60756;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_60563){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60563);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60757){var ex__2417__auto__ = e60757;
var statearr_60758_60849 = state_60563;
(statearr_60758_60849[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60563[(4)]))){
var statearr_60759_60850 = state_60563;
(statearr_60759_60850[(1)] = cljs.core.first((state_60563[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60851 = state_60563;
state_60563 = G__60851;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_60563){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_60563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60760 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60760[(6)] = c__2436__auto____$1);

return statearr_60760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_60567 = cljs.core.async.impl.dispatch.run(inst_60566);
var state_60683__$1 = (function (){var statearr_60761 = state_60683;
(statearr_60761[(22)] = inst_60567);

return statearr_60761;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60683__$1,(6),inst_60565);
} else {
if((state_val_60684 === (23))){
var inst_60625 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
if(cljs.core.truth_(inst_60625)){
var statearr_60762_60852 = state_60683__$1;
(statearr_60762_60852[(1)] = (27));

} else {
var statearr_60763_60853 = state_60683__$1;
(statearr_60763_60853[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (35))){
var inst_60649 = (state_60683[(2)]);
var state_60683__$1 = (function (){var statearr_60764 = state_60683;
(statearr_60764[(17)] = inst_60649);

return statearr_60764;
})();
var statearr_60765_60854 = state_60683__$1;
(statearr_60765_60854[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (19))){
var state_60683__$1 = state_60683;
var statearr_60767_60855 = state_60683__$1;
(statearr_60767_60855[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (11))){
var inst_60602 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
if(cljs.core.truth_(inst_60602)){
var statearr_60770_60856 = state_60683__$1;
(statearr_60770_60856[(1)] = (15));

} else {
var statearr_60771_60857 = state_60683__$1;
(statearr_60771_60857[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (9))){
var inst_60593 = (state_60683[(16)]);
var inst_60593__$1 = auth;
var state_60683__$1 = (function (){var statearr_60772 = state_60683;
(statearr_60772[(16)] = inst_60593__$1);

return statearr_60772;
})();
if(cljs.core.truth_(inst_60593__$1)){
var statearr_60773_60858 = state_60683__$1;
(statearr_60773_60858[(1)] = (12));

} else {
var statearr_60774_60859 = state_60683__$1;
(statearr_60774_60859[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (5))){
var _ = (function (){var statearr_60775 = state_60683;
(statearr_60775[(4)] = cljs.core.rest((state_60683[(4)])));

return statearr_60775;
})();
var state_60683__$1 = state_60683;
var ex60769 = (state_60683__$1[(2)]);
var statearr_60776_60860 = state_60683__$1;
(statearr_60776_60860[(5)] = ex60769);


if((ex60769 instanceof Error)){
var statearr_60777_60861 = state_60683__$1;
(statearr_60777_60861[(1)] = (4));

(statearr_60777_60861[(5)] = null);

} else {
throw ex60769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (14))){
var inst_60599 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60778_60862 = state_60683__$1;
(statearr_60778_60862[(2)] = inst_60599);

(statearr_60778_60862[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (26))){
var inst_60622 = (state_60683[(2)]);
var state_60683__$1 = state_60683;
var statearr_60779_60863 = state_60683__$1;
(statearr_60779_60863[(2)] = inst_60622);

(statearr_60779_60863[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (16))){
var inst_60590 = (state_60683[(7)]);
var state_60683__$1 = state_60683;
if(cljs.core.truth_(inst_60590)){
var statearr_60780_60864 = state_60683__$1;
(statearr_60780_60864[(1)] = (18));

} else {
var statearr_60781_60865 = state_60683__$1;
(statearr_60781_60865[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (38))){
var inst_60657 = (state_60683[(2)]);
var state_60683__$1 = (function (){var statearr_60782 = state_60683;
(statearr_60782[(11)] = inst_60657);

return statearr_60782;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60783_60866 = state_60683__$1;
(statearr_60783_60866[(1)] = (39));

} else {
var statearr_60784_60867 = state_60683__$1;
(statearr_60784_60867[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (30))){
var inst_60584 = (state_60683[(14)]);
var inst_60631 = (state_60683[(13)]);
var inst_60635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60636 = [inst_60631,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60637 = (new cljs.core.PersistentVector(null,2,(5),inst_60635,inst_60636,null));
var inst_60638 = cljs.core.assoc_in(inst_60584,inst_60637,inst_60631);
var state_60683__$1 = state_60683;
var statearr_60785_60868 = state_60683__$1;
(statearr_60785_60868[(2)] = inst_60638);

(statearr_60785_60868[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (10))){
var inst_60590 = (state_60683[(7)]);
var state_60683__$1 = state_60683;
var statearr_60786_60869 = state_60683__$1;
(statearr_60786_60869[(2)] = inst_60590);

(statearr_60786_60869[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (18))){
var inst_60570 = (state_60683[(19)]);
var inst_60609 = (state_60683[(10)]);
var inst_60590 = (state_60683[(7)]);
var inst_60608 = (state_60683[(18)]);
var inst_60608__$1 = inst_60590.t;
var inst_60609__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60570,inst_60608__$1);
var inst_60611 = (inst_60609__$1 == null);
var inst_60612 = cljs.core.not(inst_60611);
var state_60683__$1 = (function (){var statearr_60787 = state_60683;
(statearr_60787[(10)] = inst_60609__$1);

(statearr_60787[(18)] = inst_60608__$1);

return statearr_60787;
})();
if(inst_60612){
var statearr_60788_60870 = state_60683__$1;
(statearr_60788_60870[(1)] = (21));

} else {
var statearr_60789_60871 = state_60683__$1;
(statearr_60789_60871[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (42))){
var inst_60584 = (state_60683[(14)]);
var state_60683__$1 = state_60683;
var statearr_60790_60872 = state_60683__$1;
(statearr_60790_60872[(2)] = inst_60584);

(statearr_60790_60872[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (37))){
var inst_60649 = (state_60683[(17)]);
var state_60683__$1 = state_60683;
var statearr_60791_60873 = state_60683__$1;
(statearr_60791_60873[(2)] = inst_60649);

(statearr_60791_60873[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60684 === (8))){
var inst_60677 = (state_60683[(2)]);
var inst_60678 = cljs.core.vals(inst_60677);
var _ = (function (){var statearr_60792 = state_60683;
(statearr_60792[(4)] = cljs.core.rest((state_60683[(4)])));

return statearr_60792;
})();
var state_60683__$1 = state_60683;
var statearr_60793_60874 = state_60683__$1;
(statearr_60793_60874[(2)] = inst_60678);

(statearr_60793_60874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_60794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60794[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_60794[(1)] = (1));

return statearr_60794;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_60683){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60683);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60795){var ex__2417__auto__ = e60795;
var statearr_60796_60875 = state_60683;
(statearr_60796_60875[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60683[(4)]))){
var statearr_60797_60876 = state_60683;
(statearr_60797_60876[(1)] = cljs.core.first((state_60683[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60877 = state_60683;
state_60683 = G__60877;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_60683){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_60683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60798 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60798[(6)] = c__2436__auto__);

return statearr_60798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61023){
var state_val_61024 = (state_61023[(1)]);
if((state_val_61024 === (7))){
var state_61023__$1 = state_61023;
var statearr_61025_61101 = state_61023__$1;
(statearr_61025_61101[(2)] = false);

(statearr_61025_61101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (20))){
var inst_60929 = (state_61023[(7)]);
var inst_60917 = (state_61023[(8)]);
var inst_60939 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60917);
var state_61023__$1 = (function (){var statearr_61026 = state_61023;
(statearr_61026[(9)] = inst_60939);

return statearr_61026;
})();
if(cljs.core.truth_(inst_60929)){
var statearr_61027_61102 = state_61023__$1;
(statearr_61027_61102[(1)] = (23));

} else {
var statearr_61028_61103 = state_61023__$1;
(statearr_61028_61103[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (27))){
var state_61023__$1 = state_61023;
var statearr_61029_61104 = state_61023__$1;
(statearr_61029_61104[(2)] = (-1));

(statearr_61029_61104[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (1))){
var state_61023__$1 = state_61023;
var statearr_61030_61105 = state_61023__$1;
(statearr_61030_61105[(2)] = null);

(statearr_61030_61105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (24))){
var inst_60929 = (state_61023[(7)]);
var state_61023__$1 = state_61023;
var statearr_61031_61106 = state_61023__$1;
(statearr_61031_61106[(2)] = inst_60929);

(statearr_61031_61106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (39))){
var inst_60915 = (state_61023[(10)]);
var state_61023__$1 = state_61023;
var statearr_61032_61107 = state_61023__$1;
(statearr_61032_61107[(2)] = inst_60915);

(statearr_61032_61107[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (46))){
var inst_60988 = (state_61023[(11)]);
var state_61023__$1 = state_61023;
var statearr_61033_61108 = state_61023__$1;
(statearr_61033_61108[(2)] = inst_60988);

(statearr_61033_61108[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (4))){
var inst_60878 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61034_61109 = state_61023__$1;
(statearr_61034_61109[(2)] = inst_60878);

(statearr_61034_61109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (15))){
var inst_60910 = (state_61023[(12)]);
var inst_60919 = (state_61023[(2)]);
var inst_60920 = fluree.db.util.async.throw_err(inst_60919);
var state_61023__$1 = (function (){var statearr_61035 = state_61023;
(statearr_61035[(13)] = inst_60920);

return statearr_61035;
})();
if(cljs.core.truth_(inst_60910)){
var statearr_61036_61110 = state_61023__$1;
(statearr_61036_61110[(1)] = (16));

} else {
var statearr_61037_61111 = state_61023__$1;
(statearr_61037_61111[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (48))){
var inst_60996 = (state_61023[(2)]);
var inst_60997 = fluree.db.util.async.throw_err(inst_60996);
var state_61023__$1 = state_61023;
var statearr_61038_61112 = state_61023__$1;
(statearr_61038_61112[(2)] = inst_60997);

(statearr_61038_61112[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (50))){
var inst_61000 = (state_61023[(14)]);
var state_61023__$1 = state_61023;
var statearr_61039_61113 = state_61023__$1;
(statearr_61039_61113[(2)] = inst_61000);

(statearr_61039_61113[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (21))){
var inst_61010 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61011 = ["History query not properly formatted. Provided ",inst_61010].join('');
var inst_61012 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61013 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61014 = cljs.core.PersistentHashMap.fromArrays(inst_61012,inst_61013);
var inst_61015 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61011,inst_61014);
var inst_61016 = (function(){throw inst_61015})();
var state_61023__$1 = state_61023;
var statearr_61040_61114 = state_61023__$1;
(statearr_61040_61114[(2)] = inst_61016);

(statearr_61040_61114[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (31))){
var inst_60920 = (state_61023[(13)]);
var inst_60963 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60920);
var state_61023__$1 = state_61023;
var statearr_61041_61115 = state_61023__$1;
(statearr_61041_61115[(2)] = inst_60963);

(statearr_61041_61115[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (32))){
var inst_60955 = (state_61023[(15)]);
var inst_60911 = (state_61023[(16)]);
var inst_60920 = (state_61023[(13)]);
var inst_60965 = (state_61023[(2)]);
var inst_60966 = fluree.db.api.query.get_history_pattern(inst_60911);
var inst_60967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60966,(0),null);
var inst_60968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60966,(1),null);
var inst_60969 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60970 = [inst_60955,inst_60965];
var inst_60971 = cljs.core.PersistentHashMap.fromArrays(inst_60969,inst_60970);
var inst_60972 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_60920,inst_60968,cljs.core._EQ_,inst_60967,inst_60971);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(34),inst_60972);
} else {
if((state_val_61024 === (40))){
var inst_60914 = (state_61023[(17)]);
var state_61023__$1 = state_61023;
var statearr_61042_61116 = state_61023__$1;
(statearr_61042_61116[(2)] = inst_60914);

(statearr_61042_61116[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (33))){
var inst_60959 = (state_61023[(2)]);
var inst_60960 = fluree.db.util.async.throw_err(inst_60959);
var inst_60961 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60960);
var state_61023__$1 = state_61023;
var statearr_61043_61117 = state_61023__$1;
(statearr_61043_61117[(2)] = inst_60961);

(statearr_61043_61117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (13))){
var inst_60888 = (state_61023[(18)]);
var state_61023__$1 = state_61023;
var statearr_61044_61118 = state_61023__$1;
(statearr_61044_61118[(2)] = inst_60888);

(statearr_61044_61118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (22))){
var inst_61018 = (state_61023[(2)]);
var _ = (function (){var statearr_61045 = state_61023;
(statearr_61045[(4)] = cljs.core.rest((state_61023[(4)])));

return statearr_61045;
})();
var state_61023__$1 = state_61023;
var statearr_61046_61119 = state_61023__$1;
(statearr_61046_61119[(2)] = inst_61018);

(statearr_61046_61119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (36))){
var state_61023__$1 = state_61023;
var statearr_61047_61120 = state_61023__$1;
(statearr_61047_61120[(2)] = null);

(statearr_61047_61120[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (41))){
var inst_60975 = (state_61023[(19)]);
var inst_60980 = (state_61023[(20)]);
var inst_60920 = (state_61023[(13)]);
var inst_60984 = (state_61023[(2)]);
var inst_60985 = fluree.db.api.query.format_history_resp(inst_60920,inst_60975,inst_60980,inst_60984);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(38),inst_60985);
} else {
if((state_val_61024 === (43))){
var inst_60912 = (state_61023[(21)]);
var state_61023__$1 = state_61023;
var statearr_61048_61121 = state_61023__$1;
(statearr_61048_61121[(2)] = inst_60912);

(statearr_61048_61121[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (29))){
var inst_60949 = (state_61023[(2)]);
var inst_60950 = fluree.db.util.async.throw_err(inst_60949);
var inst_60951 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60950);
var inst_60952 = (inst_60951 - (1));
var state_61023__$1 = state_61023;
var statearr_61049_61122 = state_61023__$1;
(statearr_61049_61122[(2)] = inst_60952);

(statearr_61049_61122[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (44))){
var inst_60992 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60992)){
var statearr_61050_61123 = state_61023__$1;
(statearr_61050_61123[(1)] = (45));

} else {
var statearr_61051_61124 = state_61023__$1;
(statearr_61051_61124[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (6))){
var inst_60888 = (state_61023[(18)]);
var inst_60893 = inst_60888.cljs$lang$protocol_mask$partition0$;
var inst_60894 = (inst_60893 & (64));
var inst_60895 = inst_60888.cljs$core$ISeq$;
var inst_60896 = (cljs.core.PROTOCOL_SENTINEL === inst_60895);
var inst_60897 = ((inst_60894) || (inst_60896));
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60897)){
var statearr_61052_61125 = state_61023__$1;
(statearr_61052_61125[(1)] = (9));

} else {
var statearr_61053_61126 = state_61023__$1;
(statearr_61053_61126[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (28))){
var inst_60930 = (state_61023[(22)]);
var inst_60955 = (state_61023[(2)]);
var state_61023__$1 = (function (){var statearr_61054 = state_61023;
(statearr_61054[(15)] = inst_60955);

return statearr_61054;
})();
if(cljs.core.truth_(inst_60930)){
var statearr_61055_61127 = state_61023__$1;
(statearr_61055_61127[(1)] = (30));

} else {
var statearr_61056_61128 = state_61023__$1;
(statearr_61056_61128[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (51))){
var inst_61008 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61057_61129 = state_61023__$1;
(statearr_61057_61129[(2)] = inst_61008);

(statearr_61057_61129[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (25))){
var inst_60944 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60944)){
var statearr_61058_61130 = state_61023__$1;
(statearr_61058_61130[(1)] = (26));

} else {
var statearr_61059_61131 = state_61023__$1;
(statearr_61059_61131[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (34))){
var inst_60916 = (state_61023[(23)]);
var inst_60974 = (state_61023[(2)]);
var inst_60975 = fluree.db.util.async.throw_err(inst_60974);
var state_61023__$1 = (function (){var statearr_61060 = state_61023;
(statearr_61060[(19)] = inst_60975);

return statearr_61060;
})();
if(cljs.core.truth_(inst_60916)){
var statearr_61061_61132 = state_61023__$1;
(statearr_61061_61132[(1)] = (35));

} else {
var statearr_61062_61133 = state_61023__$1;
(statearr_61062_61133[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (17))){
var state_61023__$1 = state_61023;
var statearr_61063_61134 = state_61023__$1;
(statearr_61063_61134[(2)] = null);

(statearr_61063_61134[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (3))){
var inst_61021 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61023__$1,inst_61021);
} else {
if((state_val_61024 === (12))){
var inst_60888 = (state_61023[(18)]);
var inst_60906 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_60888);
var state_61023__$1 = state_61023;
var statearr_61064_61135 = state_61023__$1;
(statearr_61064_61135[(2)] = inst_60906);

(statearr_61064_61135[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (2))){
var inst_60888 = (state_61023[(18)]);
var _ = (function (){var statearr_61065 = state_61023;
(statearr_61065[(4)] = cljs.core.cons((5),(state_61023[(4)])));

return statearr_61065;
})();
var inst_60888__$1 = query_map;
var inst_60890 = (inst_60888__$1 == null);
var inst_60891 = cljs.core.not(inst_60890);
var state_61023__$1 = (function (){var statearr_61066 = state_61023;
(statearr_61066[(18)] = inst_60888__$1);

return statearr_61066;
})();
if(inst_60891){
var statearr_61067_61136 = state_61023__$1;
(statearr_61067_61136[(1)] = (6));

} else {
var statearr_61068_61137 = state_61023__$1;
(statearr_61068_61137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (23))){
var inst_60929 = (state_61023[(7)]);
var inst_60941 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_60929);
var state_61023__$1 = state_61023;
var statearr_61069_61138 = state_61023__$1;
(statearr_61069_61138[(2)] = inst_60941);

(statearr_61069_61138[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (47))){
var inst_60939 = (state_61023[(9)]);
var inst_61000 = (state_61023[(2)]);
var state_61023__$1 = (function (){var statearr_61070 = state_61023;
(statearr_61070[(14)] = inst_61000);

return statearr_61070;
})();
if(cljs.core.truth_(inst_60939)){
var statearr_61071_61139 = state_61023__$1;
(statearr_61071_61139[(1)] = (49));

} else {
var statearr_61072_61140 = state_61023__$1;
(statearr_61072_61140[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (35))){
var inst_60916 = (state_61023[(23)]);
var inst_60977 = cljs.core.set(inst_60916);
var state_61023__$1 = state_61023;
var statearr_61073_61141 = state_61023__$1;
(statearr_61073_61141[(2)] = inst_60977);

(statearr_61073_61141[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (19))){
var inst_60924 = (state_61023[(2)]);
var inst_60925 = fluree.db.util.async.throw_err(inst_60924);
var state_61023__$1 = state_61023;
var statearr_61074_61142 = state_61023__$1;
(statearr_61074_61142[(2)] = inst_60925);

(statearr_61074_61142[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (11))){
var inst_60901 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
var statearr_61076_61143 = state_61023__$1;
(statearr_61076_61143[(2)] = inst_60901);

(statearr_61076_61143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (9))){
var state_61023__$1 = state_61023;
var statearr_61077_61144 = state_61023__$1;
(statearr_61077_61144[(2)] = true);

(statearr_61077_61144[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (5))){
var _ = (function (){var statearr_61078 = state_61023;
(statearr_61078[(4)] = cljs.core.rest((state_61023[(4)])));

return statearr_61078;
})();
var state_61023__$1 = state_61023;
var ex61075 = (state_61023__$1[(2)]);
var statearr_61079_61145 = state_61023__$1;
(statearr_61079_61145[(5)] = ex61075);


if((ex61075 instanceof Error)){
var statearr_61080_61146 = state_61023__$1;
(statearr_61080_61146[(1)] = (4));

(statearr_61080_61146[(5)] = null);

} else {
throw ex61075;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (14))){
var inst_60909 = (state_61023[(2)]);
var inst_60910 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60909,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61023__$1 = (function (){var statearr_61081 = state_61023;
(statearr_61081[(16)] = inst_60911);

(statearr_61081[(12)] = inst_60910);

(statearr_61081[(17)] = inst_60914);

(statearr_61081[(21)] = inst_60912);

(statearr_61081[(23)] = inst_60916);

(statearr_61081[(8)] = inst_60917);

(statearr_61081[(10)] = inst_60915);

(statearr_61081[(24)] = inst_60913);

return statearr_61081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(15),sources);
} else {
if((state_val_61024 === (45))){
var inst_60988 = (state_61023[(11)]);
var inst_60920 = (state_61023[(13)]);
var inst_60994 = fluree.db.api.query.format_blocks_resp_pretty(inst_60920,inst_60988);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(48),inst_60994);
} else {
if((state_val_61024 === (26))){
var inst_60929 = (state_61023[(7)]);
var inst_60920 = (state_61023[(13)]);
var inst_60946 = (inst_60929 - (1));
var inst_60947 = fluree.db.time_travel.as_of_block(inst_60920,inst_60946);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(29),inst_60947);
} else {
if((state_val_61024 === (16))){
var inst_60920 = (state_61023[(13)]);
var inst_60922 = fluree.db.api.query.resolve_block_range(inst_60920,query_map);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(19),inst_60922);
} else {
if((state_val_61024 === (38))){
var inst_60913 = (state_61023[(24)]);
var inst_60987 = (state_61023[(2)]);
var inst_60988 = fluree.db.util.async.throw_err(inst_60987);
var state_61023__$1 = (function (){var statearr_61082 = state_61023;
(statearr_61082[(11)] = inst_60988);

return statearr_61082;
})();
if(cljs.core.truth_(inst_60913)){
var statearr_61083_61147 = state_61023__$1;
(statearr_61083_61147[(1)] = (42));

} else {
var statearr_61084_61148 = state_61023__$1;
(statearr_61084_61148[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (30))){
var inst_60930 = (state_61023[(22)]);
var inst_60920 = (state_61023[(13)]);
var inst_60957 = fluree.db.time_travel.as_of_block(inst_60920,inst_60930);
var state_61023__$1 = state_61023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61023__$1,(33),inst_60957);
} else {
if((state_val_61024 === (10))){
var state_61023__$1 = state_61023;
var statearr_61085_61149 = state_61023__$1;
(statearr_61085_61149[(2)] = false);

(statearr_61085_61149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (18))){
var inst_60928 = (state_61023[(2)]);
var inst_60929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60928,(0),null);
var inst_60930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60928,(1),null);
var inst_60931 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60932 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_60933 = cljs.core.keys(inst_60932);
var inst_60934 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60931,inst_60933);
var state_61023__$1 = (function (){var statearr_61086 = state_61023;
(statearr_61086[(22)] = inst_60930);

(statearr_61086[(7)] = inst_60929);

return statearr_61086;
})();
if(inst_60934){
var statearr_61087_61150 = state_61023__$1;
(statearr_61087_61150[(1)] = (20));

} else {
var statearr_61088_61151 = state_61023__$1;
(statearr_61088_61151[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (42))){
var inst_60913 = (state_61023[(24)]);
var state_61023__$1 = state_61023;
var statearr_61089_61152 = state_61023__$1;
(statearr_61089_61152[(2)] = inst_60913);

(statearr_61089_61152[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (37))){
var inst_60915 = (state_61023[(10)]);
var inst_60980 = (state_61023[(2)]);
var state_61023__$1 = (function (){var statearr_61090 = state_61023;
(statearr_61090[(20)] = inst_60980);

return statearr_61090;
})();
if(cljs.core.truth_(inst_60915)){
var statearr_61091_61153 = state_61023__$1;
(statearr_61091_61153[(1)] = (39));

} else {
var statearr_61092_61154 = state_61023__$1;
(statearr_61092_61154[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (8))){
var inst_60904 = (state_61023[(2)]);
var state_61023__$1 = state_61023;
if(cljs.core.truth_(inst_60904)){
var statearr_61093_61155 = state_61023__$1;
(statearr_61093_61155[(1)] = (12));

} else {
var statearr_61094_61156 = state_61023__$1;
(statearr_61094_61156[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61024 === (49))){
var inst_60975 = (state_61023[(19)]);
var inst_61000 = (state_61023[(14)]);
var inst_61002 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61003 = cljs.core.count(inst_60975);
var inst_61004 = [inst_61000,inst_61003,(200)];
var inst_61005 = cljs.core.PersistentHashMap.fromArrays(inst_61002,inst_61004);
var state_61023__$1 = state_61023;
var statearr_61095_61157 = state_61023__$1;
(statearr_61095_61157[(2)] = inst_61005);

(statearr_61095_61157[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_61096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61096[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2414__auto__);

(statearr_61096[(1)] = (1));

return statearr_61096;
});
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1 = (function (state_61023){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61023);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61097){var ex__2417__auto__ = e61097;
var statearr_61098_61158 = state_61023;
(statearr_61098_61158[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61023[(4)]))){
var statearr_61099_61159 = state_61023;
(statearr_61099_61159[(1)] = cljs.core.first((state_61023[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61160 = state_61023;
state_61023 = G__61160;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__ = function(state_61023){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1.call(this,state_61023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61100 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61100[(6)] = c__2436__auto__);

return statearr_61100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61313){
var state_val_61314 = (state_61313[(1)]);
if((state_val_61314 === (7))){
var state_61313__$1 = state_61313;
var statearr_61315_61407 = state_61313__$1;
(statearr_61315_61407[(2)] = false);

(statearr_61315_61407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (59))){
var inst_61298 = (state_61313[(7)]);
var state_61313__$1 = state_61313;
var statearr_61316_61408 = state_61313__$1;
(statearr_61316_61408[(2)] = inst_61298);

(statearr_61316_61408[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (20))){
var inst_61195 = (state_61313[(8)]);
var inst_61233 = (state_61313[(2)]);
var state_61313__$1 = (function (){var statearr_61317 = state_61313;
(statearr_61317[(9)] = inst_61233);

return statearr_61317;
})();
if(cljs.core.truth_(inst_61195)){
var statearr_61318_61409 = state_61313__$1;
(statearr_61318_61409[(1)] = (24));

} else {
var statearr_61319_61410 = state_61313__$1;
(statearr_61319_61410[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (58))){
var inst_61298 = (state_61313[(7)]);
var inst_61253 = (state_61313[(10)]);
var inst_61293 = (state_61313[(11)]);
var inst_61233 = (state_61313[(9)]);
var inst_61300 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61301 = cljs.core.deref(inst_61253);
var inst_61302 = fluree.db.api.query.response_time_formatted(inst_61293);
var inst_61303 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61233);
var inst_61304 = [(200),inst_61298,inst_61301,inst_61302,inst_61303];
var inst_61305 = cljs.core.PersistentHashMap.fromArrays(inst_61300,inst_61304);
var state_61313__$1 = state_61313;
var statearr_61320_61411 = state_61313__$1;
(statearr_61320_61411[(2)] = inst_61305);

(statearr_61320_61411[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (60))){
var inst_61308 = (state_61313[(2)]);
var _ = (function (){var statearr_61321 = state_61313;
(statearr_61321[(4)] = cljs.core.rest((state_61313[(4)])));

return statearr_61321;
})();
var state_61313__$1 = state_61313;
var statearr_61322_61412 = state_61313__$1;
(statearr_61322_61412[(2)] = inst_61308);

(statearr_61322_61412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (27))){
var inst_61244 = (state_61313[(12)]);
var state_61313__$1 = state_61313;
var statearr_61323_61413 = state_61313__$1;
(statearr_61323_61413[(2)] = inst_61244);

(statearr_61323_61413[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (1))){
var state_61313__$1 = state_61313;
var statearr_61324_61414 = state_61313__$1;
(statearr_61324_61414[(2)] = null);

(statearr_61324_61414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (24))){
var inst_61195 = (state_61313[(8)]);
var inst_61233 = (state_61313[(9)]);
var inst_61235 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61233);
var inst_61236 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61233);
var inst_61237 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61233);
var inst_61238 = fluree.db.api.query.get_sources(inst_61235,inst_61236,inst_61237,inst_61195);
var state_61313__$1 = state_61313;
var statearr_61325_61415 = state_61313__$1;
(statearr_61325_61415[(2)] = inst_61238);

(statearr_61325_61415[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (55))){
var inst_61286 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61287 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61288 = cljs.core.PersistentHashMap.fromArrays(inst_61286,inst_61287);
var inst_61289 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61288);
var inst_61290 = (function(){throw inst_61289})();
var state_61313__$1 = state_61313;
var statearr_61326_61416 = state_61313__$1;
(statearr_61326_61416[(2)] = inst_61290);

(statearr_61326_61416[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (39))){
var inst_61197 = (state_61313[(13)]);
var state_61313__$1 = state_61313;
var statearr_61327_61417 = state_61313__$1;
(statearr_61327_61417[(2)] = inst_61197);

(statearr_61327_61417[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (46))){
var inst_61191 = (state_61313[(14)]);
var state_61313__$1 = state_61313;
var statearr_61328_61418 = state_61313__$1;
(statearr_61328_61418[(2)] = inst_61191);

(statearr_61328_61418[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (4))){
var inst_61162 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61329_61419 = state_61313__$1;
(statearr_61329_61419[(2)] = inst_61162);

(statearr_61329_61419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (54))){
var state_61313__$1 = state_61313;
var statearr_61330_61420 = state_61313__$1;
(statearr_61330_61420[(2)] = null);

(statearr_61330_61420[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (15))){
var state_61313__$1 = state_61313;
var statearr_61331_61421 = state_61313__$1;
(statearr_61331_61421[(2)] = null);

(statearr_61331_61421[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (48))){
var inst_61198 = (state_61313[(15)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61198)){
var statearr_61332_61422 = state_61313__$1;
(statearr_61332_61422[(1)] = (51));

} else {
var statearr_61333_61423 = state_61313__$1;
(statearr_61333_61423[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (50))){
var inst_61283 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61283)){
var statearr_61334_61424 = state_61313__$1;
(statearr_61334_61424[(1)] = (54));

} else {
var statearr_61335_61425 = state_61313__$1;
(statearr_61335_61425[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (21))){
var inst_61226 = (state_61313[(2)]);
var inst_61227 = fluree.db.util.async.throw_err(inst_61226);
var state_61313__$1 = state_61313;
var statearr_61336_61426 = state_61313__$1;
(statearr_61336_61426[(2)] = inst_61227);

(statearr_61336_61426[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (31))){
var state_61313__$1 = state_61313;
var statearr_61337_61427 = state_61313__$1;
(statearr_61337_61427[(2)] = null);

(statearr_61337_61427[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (32))){
var inst_61254 = (state_61313[(16)]);
var inst_61199 = (state_61313[(17)]);
var inst_61253 = (state_61313[(2)]);
var inst_61254__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61199);
var state_61313__$1 = (function (){var statearr_61338 = state_61313;
(statearr_61338[(16)] = inst_61254__$1);

(statearr_61338[(10)] = inst_61253);

return statearr_61338;
})();
if(cljs.core.truth_(inst_61254__$1)){
var statearr_61339_61428 = state_61313__$1;
(statearr_61339_61428[(1)] = (33));

} else {
var statearr_61340_61429 = state_61313__$1;
(statearr_61340_61429[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (40))){
var inst_61196 = (state_61313[(18)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61196)){
var statearr_61341_61430 = state_61313__$1;
(statearr_61341_61430[(1)] = (42));

} else {
var statearr_61342_61431 = state_61313__$1;
(statearr_61342_61431[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (56))){
var inst_61259 = (state_61313[(19)]);
var inst_61233 = (state_61313[(9)]);
var inst_61292 = (state_61313[(2)]);
var inst_61293 = fluree.db.util.core.current_time_millis();
var inst_61294 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61259);
var inst_61295 = fluree.db.query.fql.query(inst_61233,inst_61294);
var state_61313__$1 = (function (){var statearr_61343 = state_61313;
(statearr_61343[(11)] = inst_61293);

(statearr_61343[(20)] = inst_61292);

return statearr_61343;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61313__$1,(57),inst_61295);
} else {
if((state_val_61314 === (33))){
var inst_61254 = (state_61313[(16)]);
var state_61313__$1 = state_61313;
var statearr_61344_61432 = state_61313__$1;
(statearr_61344_61432[(2)] = inst_61254);

(statearr_61344_61432[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (13))){
var inst_61169 = (state_61313[(21)]);
var state_61313__$1 = state_61313;
var statearr_61345_61433 = state_61313__$1;
(statearr_61345_61433[(2)] = inst_61169);

(statearr_61345_61433[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (22))){
var inst_61193 = (state_61313[(22)]);
var inst_61222 = (state_61313[(2)]);
var inst_61223 = fluree.db.util.async.throw_err(inst_61222);
var inst_61224 = fluree.db.time_travel.as_of_block(inst_61223,inst_61193);
var state_61313__$1 = state_61313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61313__$1,(21),inst_61224);
} else {
if((state_val_61314 === (36))){
var inst_61192 = (state_61313[(23)]);
var state_61313__$1 = state_61313;
var statearr_61346_61434 = state_61313__$1;
(statearr_61346_61434[(2)] = inst_61192);

(statearr_61346_61434[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (41))){
var inst_61273 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61347_61435 = state_61313__$1;
(statearr_61347_61435[(2)] = inst_61273);

(statearr_61347_61435[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (43))){
var inst_61200 = (state_61313[(24)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61200)){
var statearr_61348_61436 = state_61313__$1;
(statearr_61348_61436[(1)] = (45));

} else {
var statearr_61349_61437 = state_61313__$1;
(statearr_61349_61437[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (29))){
var inst_61248 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61248)){
var statearr_61350_61438 = state_61313__$1;
(statearr_61350_61438[(1)] = (30));

} else {
var statearr_61351_61439 = state_61313__$1;
(statearr_61351_61439[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (44))){
var inst_61271 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61352_61440 = state_61313__$1;
(statearr_61352_61440[(2)] = inst_61271);

(statearr_61352_61440[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (6))){
var inst_61169 = (state_61313[(21)]);
var inst_61174 = inst_61169.cljs$lang$protocol_mask$partition0$;
var inst_61175 = (inst_61174 & (64));
var inst_61176 = inst_61169.cljs$core$ISeq$;
var inst_61177 = (cljs.core.PROTOCOL_SENTINEL === inst_61176);
var inst_61178 = ((inst_61175) || (inst_61177));
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61178)){
var statearr_61353_61441 = state_61313__$1;
(statearr_61353_61441[(1)] = (9));

} else {
var statearr_61354_61442 = state_61313__$1;
(statearr_61354_61442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (28))){
var inst_61243 = (state_61313[(25)]);
var state_61313__$1 = state_61313;
var statearr_61355_61443 = state_61313__$1;
(statearr_61355_61443[(2)] = inst_61243);

(statearr_61355_61443[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (51))){
var inst_61198 = (state_61313[(15)]);
var state_61313__$1 = state_61313;
var statearr_61356_61444 = state_61313__$1;
(statearr_61356_61444[(2)] = inst_61198);

(statearr_61356_61444[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (25))){
var inst_61240 = cljs.core.PersistentHashMap.EMPTY;
var state_61313__$1 = state_61313;
var statearr_61357_61445 = state_61313__$1;
(statearr_61357_61445[(2)] = inst_61240);

(statearr_61357_61445[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (34))){
var state_61313__$1 = state_61313;
var statearr_61358_61446 = state_61313__$1;
(statearr_61358_61446[(2)] = (1000000));

(statearr_61358_61446[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (17))){
var inst_61193 = (state_61313[(22)]);
var inst_61218 = (state_61313[(2)]);
var inst_61219 = sources;
var state_61313__$1 = (function (){var statearr_61359 = state_61313;
(statearr_61359[(26)] = inst_61218);

(statearr_61359[(27)] = inst_61219);

return statearr_61359;
})();
if(cljs.core.truth_(inst_61193)){
var statearr_61360_61447 = state_61313__$1;
(statearr_61360_61447[(1)] = (18));

} else {
var statearr_61361_61448 = state_61313__$1;
(statearr_61361_61448[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (3))){
var inst_61311 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61313__$1,inst_61311);
} else {
if((state_val_61314 === (12))){
var inst_61169 = (state_61313[(21)]);
var inst_61187 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61169);
var state_61313__$1 = state_61313;
var statearr_61362_61449 = state_61313__$1;
(statearr_61362_61449[(2)] = inst_61187);

(statearr_61362_61449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (2))){
var inst_61169 = (state_61313[(21)]);
var _ = (function (){var statearr_61363 = state_61313;
(statearr_61363[(4)] = cljs.core.cons((5),(state_61313[(4)])));

return statearr_61363;
})();
var inst_61169__$1 = flureeQL;
var inst_61171 = (inst_61169__$1 == null);
var inst_61172 = cljs.core.not(inst_61171);
var state_61313__$1 = (function (){var statearr_61364 = state_61313;
(statearr_61364[(21)] = inst_61169__$1);

return statearr_61364;
})();
if(inst_61172){
var statearr_61365_61450 = state_61313__$1;
(statearr_61365_61450[(1)] = (6));

} else {
var statearr_61366_61451 = state_61313__$1;
(statearr_61366_61451[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (23))){
var inst_61230 = (state_61313[(2)]);
var inst_61231 = fluree.db.util.async.throw_err(inst_61230);
var state_61313__$1 = state_61313;
var statearr_61367_61452 = state_61313__$1;
(statearr_61367_61452[(2)] = inst_61231);

(statearr_61367_61452[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (47))){
var inst_61269 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61368_61453 = state_61313__$1;
(statearr_61368_61453[(2)] = inst_61269);

(statearr_61368_61453[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (35))){
var inst_61253 = (state_61313[(10)]);
var inst_61192 = (state_61313[(23)]);
var inst_61199 = (state_61313[(17)]);
var inst_61242 = (state_61313[(28)]);
var inst_61258 = (state_61313[(2)]);
var inst_61259 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61199,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61242,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61258,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61253], 0));
var state_61313__$1 = (function (){var statearr_61369 = state_61313;
(statearr_61369[(19)] = inst_61259);

return statearr_61369;
})();
if(cljs.core.truth_(inst_61192)){
var statearr_61370_61454 = state_61313__$1;
(statearr_61370_61454[(1)] = (36));

} else {
var statearr_61371_61455 = state_61313__$1;
(statearr_61371_61455[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (19))){
var inst_61219 = (state_61313[(27)]);
var state_61313__$1 = state_61313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61313__$1,(23),inst_61219);
} else {
if((state_val_61314 === (57))){
var inst_61243 = (state_61313[(25)]);
var inst_61297 = (state_61313[(2)]);
var inst_61298 = fluree.db.util.async.throw_err(inst_61297);
var state_61313__$1 = (function (){var statearr_61372 = state_61313;
(statearr_61372[(7)] = inst_61298);

return statearr_61372;
})();
if(cljs.core.truth_(inst_61243)){
var statearr_61373_61456 = state_61313__$1;
(statearr_61373_61456[(1)] = (58));

} else {
var statearr_61374_61457 = state_61313__$1;
(statearr_61374_61457[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (11))){
var inst_61182 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61376_61458 = state_61313__$1;
(statearr_61376_61458[(2)] = inst_61182);

(statearr_61376_61458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (9))){
var state_61313__$1 = state_61313;
var statearr_61377_61459 = state_61313__$1;
(statearr_61377_61459[(2)] = true);

(statearr_61377_61459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (5))){
var _ = (function (){var statearr_61378 = state_61313;
(statearr_61378[(4)] = cljs.core.rest((state_61313[(4)])));

return statearr_61378;
})();
var state_61313__$1 = state_61313;
var ex61375 = (state_61313__$1[(2)]);
var statearr_61379_61460 = state_61313__$1;
(statearr_61379_61460[(5)] = ex61375);


if((ex61375 instanceof Error)){
var statearr_61380_61461 = state_61313__$1;
(statearr_61380_61461[(1)] = (4));

(statearr_61380_61461[(5)] = null);

} else {
throw ex61375;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (14))){
var inst_61192 = (state_61313[(23)]);
var inst_61200 = (state_61313[(24)]);
var inst_61198 = (state_61313[(15)]);
var inst_61199 = (state_61313[(17)]);
var inst_61191 = (state_61313[(14)]);
var inst_61197 = (state_61313[(13)]);
var inst_61194 = (state_61313[(29)]);
var inst_61196 = (state_61313[(18)]);
var inst_61195 = (state_61313[(8)]);
var inst_61193 = (state_61313[(22)]);
var inst_61190 = (state_61313[(2)]);
var inst_61191__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61192__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61193__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61194__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61195__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61196__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61197__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61198__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61199__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61200__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61190,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61201 = (function (){var construct = inst_61191__$1;
var select = inst_61192__$1;
var block = inst_61193__$1;
var where = inst_61194__$1;
var prefixes = inst_61195__$1;
var map__61168 = inst_61190;
var selectDistinct = inst_61196__$1;
var selectOne = inst_61197__$1;
var from = inst_61198__$1;
var opts = inst_61199__$1;
var selectReduced = inst_61200__$1;
return (function (p1__61161_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61161_SHARP_);
});
})();
var inst_61202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61203 = [inst_61192__$1,inst_61197__$1,inst_61196__$1,inst_61200__$1];
var inst_61204 = (new cljs.core.PersistentVector(null,4,(5),inst_61202,inst_61203,null));
var inst_61205 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61204);
var inst_61206 = cljs.core.count(inst_61205);
var inst_61207 = (inst_61201.cljs$core$IFn$_invoke$arity$1 ? inst_61201.cljs$core$IFn$_invoke$arity$1(inst_61206) : inst_61201.call(null,inst_61206));
var state_61313__$1 = (function (){var statearr_61381 = state_61313;
(statearr_61381[(23)] = inst_61192__$1);

(statearr_61381[(24)] = inst_61200__$1);

(statearr_61381[(15)] = inst_61198__$1);

(statearr_61381[(17)] = inst_61199__$1);

(statearr_61381[(14)] = inst_61191__$1);

(statearr_61381[(13)] = inst_61197__$1);

(statearr_61381[(29)] = inst_61194__$1);

(statearr_61381[(18)] = inst_61196__$1);

(statearr_61381[(8)] = inst_61195__$1);

(statearr_61381[(22)] = inst_61193__$1);

return statearr_61381;
})();
if(cljs.core.truth_(inst_61207)){
var statearr_61382_61462 = state_61313__$1;
(statearr_61382_61462[(1)] = (15));

} else {
var statearr_61383_61463 = state_61313__$1;
(statearr_61383_61463[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (45))){
var inst_61200 = (state_61313[(24)]);
var state_61313__$1 = state_61313;
var statearr_61384_61464 = state_61313__$1;
(statearr_61384_61464[(2)] = inst_61200);

(statearr_61384_61464[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (53))){
var inst_61280 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
var statearr_61385_61465 = state_61313__$1;
(statearr_61385_61465[(2)] = inst_61280);

(statearr_61385_61465[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (26))){
var inst_61199 = (state_61313[(17)]);
var inst_61244 = (state_61313[(12)]);
var inst_61242 = (state_61313[(2)]);
var inst_61243 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61199);
var inst_61244__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61199);
var state_61313__$1 = (function (){var statearr_61386 = state_61313;
(statearr_61386[(25)] = inst_61243);

(statearr_61386[(28)] = inst_61242);

(statearr_61386[(12)] = inst_61244__$1);

return statearr_61386;
})();
if(cljs.core.truth_(inst_61244__$1)){
var statearr_61387_61466 = state_61313__$1;
(statearr_61387_61466[(1)] = (27));

} else {
var statearr_61388_61467 = state_61313__$1;
(statearr_61388_61467[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (16))){
var inst_61210 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61211 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61210].join('');
var inst_61212 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61213 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61214 = cljs.core.PersistentHashMap.fromArrays(inst_61212,inst_61213);
var inst_61215 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61211,inst_61214);
var inst_61216 = (function(){throw inst_61215})();
var state_61313__$1 = state_61313;
var statearr_61389_61468 = state_61313__$1;
(statearr_61389_61468[(2)] = inst_61216);

(statearr_61389_61468[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (38))){
var inst_61275 = (state_61313[(30)]);
var inst_61275__$1 = (state_61313[(2)]);
var state_61313__$1 = (function (){var statearr_61390 = state_61313;
(statearr_61390[(30)] = inst_61275__$1);

return statearr_61390;
})();
if(cljs.core.truth_(inst_61275__$1)){
var statearr_61391_61469 = state_61313__$1;
(statearr_61391_61469[(1)] = (48));

} else {
var statearr_61392_61470 = state_61313__$1;
(statearr_61392_61470[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (30))){
var inst_61250 = cljs.core.volatile_BANG_((0));
var state_61313__$1 = state_61313;
var statearr_61393_61471 = state_61313__$1;
(statearr_61393_61471[(2)] = inst_61250);

(statearr_61393_61471[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (10))){
var state_61313__$1 = state_61313;
var statearr_61394_61472 = state_61313__$1;
(statearr_61394_61472[(2)] = false);

(statearr_61394_61472[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (18))){
var inst_61219 = (state_61313[(27)]);
var state_61313__$1 = state_61313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61313__$1,(22),inst_61219);
} else {
if((state_val_61314 === (52))){
var inst_61194 = (state_61313[(29)]);
var state_61313__$1 = state_61313;
var statearr_61395_61473 = state_61313__$1;
(statearr_61395_61473[(2)] = inst_61194);

(statearr_61395_61473[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (42))){
var inst_61196 = (state_61313[(18)]);
var state_61313__$1 = state_61313;
var statearr_61396_61474 = state_61313__$1;
(statearr_61396_61474[(2)] = inst_61196);

(statearr_61396_61474[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (37))){
var inst_61197 = (state_61313[(13)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61197)){
var statearr_61397_61475 = state_61313__$1;
(statearr_61397_61475[(1)] = (39));

} else {
var statearr_61398_61476 = state_61313__$1;
(statearr_61398_61476[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (8))){
var inst_61185 = (state_61313[(2)]);
var state_61313__$1 = state_61313;
if(cljs.core.truth_(inst_61185)){
var statearr_61399_61477 = state_61313__$1;
(statearr_61399_61477[(1)] = (12));

} else {
var statearr_61400_61478 = state_61313__$1;
(statearr_61400_61478[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61314 === (49))){
var inst_61275 = (state_61313[(30)]);
var state_61313__$1 = state_61313;
var statearr_61401_61479 = state_61313__$1;
(statearr_61401_61479[(2)] = inst_61275);

(statearr_61401_61479[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_61402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61402[(0)] = fluree$db$api$query$query_async_$_state_machine__2414__auto__);

(statearr_61402[(1)] = (1));

return statearr_61402;
});
var fluree$db$api$query$query_async_$_state_machine__2414__auto____1 = (function (state_61313){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61313);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61403){var ex__2417__auto__ = e61403;
var statearr_61404_61480 = state_61313;
(statearr_61404_61480[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61313[(4)]))){
var statearr_61405_61481 = state_61313;
(statearr_61405_61481[(1)] = cljs.core.first((state_61313[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61482 = state_61313;
state_61313 = G__61482;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2414__auto__ = function(state_61313){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2414__auto____1.call(this,state_61313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61406 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61406[(6)] = c__2436__auto__);

return statearr_61406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61636){
var state_val_61637 = (state_61636[(1)]);
if((state_val_61637 === (7))){
var inst_61631 = (state_61636[(2)]);
var _ = (function (){var statearr_61638 = state_61636;
(statearr_61638[(4)] = cljs.core.rest((state_61636[(4)])));

return statearr_61638;
})();
var state_61636__$1 = state_61636;
var statearr_61639_61718 = state_61636__$1;
(statearr_61639_61718[(2)] = inst_61631);

(statearr_61639_61718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (20))){
var inst_61552 = (state_61636[(7)]);
var inst_61570 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61552);
var state_61636__$1 = state_61636;
var statearr_61640_61719 = state_61636__$1;
(statearr_61640_61719[(2)] = inst_61570);

(statearr_61640_61719[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (27))){
var inst_61580 = (state_61636[(8)]);
var state_61636__$1 = state_61636;
var statearr_61641_61720 = state_61636__$1;
(statearr_61641_61720[(2)] = inst_61580);

(statearr_61641_61720[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (1))){
var state_61636__$1 = state_61636;
var statearr_61642_61721 = state_61636__$1;
(statearr_61642_61721[(2)] = null);

(statearr_61642_61721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (24))){
var inst_61522 = (state_61636[(9)]);
var inst_61577 = (state_61636[(10)]);
var inst_61580 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61577);
var inst_61581 = (inst_61522 == null);
var state_61636__$1 = (function (){var statearr_61643 = state_61636;
(statearr_61643[(8)] = inst_61580);

return statearr_61643;
})();
if(cljs.core.truth_(inst_61581)){
var statearr_61644_61722 = state_61636__$1;
(statearr_61644_61722[(1)] = (27));

} else {
var statearr_61645_61723 = state_61636__$1;
(statearr_61645_61723[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (39))){
var inst_61577 = (state_61636[(10)]);
var inst_61523 = (state_61636[(11)]);
var inst_61608 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61577,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61609 = (inst_61523 + inst_61608);
var state_61636__$1 = state_61636;
var statearr_61646_61724 = state_61636__$1;
(statearr_61646_61724[(2)] = inst_61609);

(statearr_61646_61724[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (46))){
var inst_61577 = (state_61636[(10)]);
var state_61636__$1 = state_61636;
var statearr_61647_61725 = state_61636__$1;
(statearr_61647_61725[(2)] = inst_61577);

(statearr_61647_61725[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (4))){
var inst_61483 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61648_61726 = state_61636__$1;
(statearr_61648_61726[(2)] = inst_61483);

(statearr_61648_61726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (15))){
var state_61636__$1 = state_61636;
var statearr_61649_61727 = state_61636__$1;
(statearr_61649_61727[(2)] = false);

(statearr_61649_61727[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (21))){
var inst_61552 = (state_61636[(7)]);
var state_61636__$1 = state_61636;
var statearr_61650_61728 = state_61636__$1;
(statearr_61650_61728[(2)] = inst_61552);

(statearr_61650_61728[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (31))){
var inst_61522 = (state_61636[(9)]);
var inst_61580 = (state_61636[(8)]);
var inst_61587 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61580);
var inst_61588 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61522);
var inst_61589 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_61522);
var inst_61590 = ((inst_61587) || (inst_61588) || (inst_61589));
var state_61636__$1 = state_61636;
if(cljs.core.truth_(inst_61590)){
var statearr_61651_61729 = state_61636__$1;
(statearr_61651_61729[(1)] = (33));

} else {
var statearr_61652_61730 = state_61636__$1;
(statearr_61652_61730[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (32))){
var inst_61601 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61653_61731 = state_61636__$1;
(statearr_61653_61731[(2)] = inst_61601);

(statearr_61653_61731[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (40))){
var state_61636__$1 = state_61636;
var statearr_61654_61732 = state_61636__$1;
(statearr_61654_61732[(2)] = null);

(statearr_61654_61732[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (33))){
var state_61636__$1 = state_61636;
var statearr_61655_61733 = state_61636__$1;
(statearr_61655_61733[(2)] = (207));

(statearr_61655_61733[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (13))){
var inst_61546 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61656_61734 = state_61636__$1;
(statearr_61656_61734[(2)] = inst_61546);

(statearr_61656_61734[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (22))){
var inst_61536 = (state_61636[(12)]);
var inst_61573 = (state_61636[(2)]);
var inst_61574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61573,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61573,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61636__$1 = (function (){var statearr_61657 = state_61636;
(statearr_61657[(13)] = inst_61575);

(statearr_61657[(14)] = inst_61574);

return statearr_61657;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61636__$1,(23),inst_61536);
} else {
if((state_val_61637 === (36))){
var inst_61522 = (state_61636[(9)]);
var inst_61580 = (state_61636[(8)]);
var inst_61594 = ((inst_61580 > inst_61522) ? inst_61580 : inst_61522);
var state_61636__$1 = state_61636;
var statearr_61658_61735 = state_61636__$1;
(statearr_61658_61735[(2)] = inst_61594);

(statearr_61658_61735[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (41))){
var inst_61578 = (state_61636[(15)]);
var inst_61612 = (state_61636[(2)]);
var state_61636__$1 = (function (){var statearr_61659 = state_61636;
(statearr_61659[(16)] = inst_61612);

return statearr_61659;
})();
if(cljs.core.truth_(inst_61578)){
var statearr_61660_61736 = state_61636__$1;
(statearr_61660_61736[(1)] = (42));

} else {
var statearr_61661_61737 = state_61636__$1;
(statearr_61661_61737[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (43))){
var inst_61575 = (state_61636[(13)]);
var state_61636__$1 = state_61636;
if(cljs.core.truth_(inst_61575)){
var statearr_61662_61738 = state_61636__$1;
(statearr_61662_61738[(1)] = (45));

} else {
var statearr_61663_61739 = state_61636__$1;
(statearr_61663_61739[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (29))){
var inst_61603 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61664_61740 = state_61636__$1;
(statearr_61664_61740[(2)] = inst_61603);

(statearr_61664_61740[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (44))){
var inst_61612 = (state_61636[(16)]);
var inst_61534 = (state_61636[(17)]);
var inst_61606 = (state_61636[(18)]);
var inst_61626 = (state_61636[(2)]);
var inst_61521 = inst_61534;
var inst_61522 = inst_61606;
var inst_61523 = inst_61612;
var inst_61524 = inst_61626;
var state_61636__$1 = (function (){var statearr_61665 = state_61636;
(statearr_61665[(9)] = inst_61522);

(statearr_61665[(19)] = inst_61521);

(statearr_61665[(11)] = inst_61523);

(statearr_61665[(20)] = inst_61524);

return statearr_61665;
})();
var statearr_61666_61741 = state_61636__$1;
(statearr_61666_61741[(2)] = null);

(statearr_61666_61741[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (6))){
var inst_61521 = (state_61636[(19)]);
var inst_61536 = (state_61636[(12)]);
var inst_61532 = cljs.core.seq(inst_61521);
var inst_61533 = cljs.core.first(inst_61532);
var inst_61534 = cljs.core.next(inst_61532);
var inst_61535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61533,(0),null);
var inst_61536__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61533,(1),null);
var inst_61537 = (inst_61536__$1 == null);
var state_61636__$1 = (function (){var statearr_61667 = state_61636;
(statearr_61667[(21)] = inst_61535);

(statearr_61667[(17)] = inst_61534);

(statearr_61667[(12)] = inst_61536__$1);

return statearr_61667;
})();
if(cljs.core.truth_(inst_61537)){
var statearr_61668_61742 = state_61636__$1;
(statearr_61668_61742[(1)] = (8));

} else {
var statearr_61669_61743 = state_61636__$1;
(statearr_61669_61743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (28))){
var inst_61522 = (state_61636[(9)]);
var inst_61580 = (state_61636[(8)]);
var inst_61584 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61522,inst_61580);
var state_61636__$1 = state_61636;
if(inst_61584){
var statearr_61670_61744 = state_61636__$1;
(statearr_61670_61744[(1)] = (30));

} else {
var statearr_61671_61745 = state_61636__$1;
(statearr_61671_61745[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (25))){
var state_61636__$1 = state_61636;
var statearr_61672_61746 = state_61636__$1;
(statearr_61672_61746[(2)] = null);

(statearr_61672_61746[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (34))){
var state_61636__$1 = state_61636;
var statearr_61673_61747 = state_61636__$1;
(statearr_61673_61747[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (17))){
var state_61636__$1 = state_61636;
var statearr_61675_61748 = state_61636__$1;
(statearr_61675_61748[(2)] = true);

(statearr_61675_61748[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (3))){
var inst_61634 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61636__$1,inst_61634);
} else {
if((state_val_61637 === (12))){
var inst_61524 = (state_61636[(20)]);
var state_61636__$1 = state_61636;
var statearr_61676_61749 = state_61636__$1;
(statearr_61676_61749[(2)] = inst_61524);

(statearr_61676_61749[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (2))){
var inst_61493 = (state_61636[(22)]);
var inst_61497 = (state_61636[(23)]);
var inst_61498 = (state_61636[(24)]);
var _ = (function (){var statearr_61677 = state_61636;
(statearr_61677[(4)] = cljs.core.cons((5),(state_61636[(4)])));

return statearr_61677;
})();
var inst_61489 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61491 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61492 = (new cljs.core.PersistentVector(null,2,(5),inst_61490,inst_61491,null));
var inst_61493__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61492);
var inst_61494 = (function (){var global_block = inst_61489;
var global_meta_QMARK_ = inst_61493__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61495 = cljs.core.PersistentHashMap.EMPTY;
var inst_61496 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61497__$1 = cljs.core.reduce_kv(inst_61494,inst_61495,inst_61496);
var inst_61498__$1 = fluree.db.util.core.current_time_millis();
var inst_61500 = (function (){var global_block = inst_61489;
var global_meta_QMARK_ = inst_61493__$1;
var queries = inst_61497__$1;
var start_time = inst_61498__$1;
return (function (p__61499){
var vec__61678 = p__61499;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61678,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61678,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_61501 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61500,inst_61497__$1);
var inst_61515 = cljs.core.seq(inst_61501);
var inst_61516 = cljs.core.first(inst_61515);
var inst_61517 = cljs.core.next(inst_61515);
var inst_61518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61516,(0),null);
var inst_61519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61516,(1),null);
var inst_61520 = cljs.core.PersistentHashMap.EMPTY;
var inst_61521 = inst_61501;
var inst_61522 = null;
var inst_61523 = (0);
var inst_61524 = inst_61520;
var state_61636__$1 = (function (){var statearr_61681 = state_61636;
(statearr_61681[(9)] = inst_61522);

(statearr_61681[(22)] = inst_61493__$1);

(statearr_61681[(19)] = inst_61521);

(statearr_61681[(25)] = inst_61517);

(statearr_61681[(23)] = inst_61497__$1);

(statearr_61681[(11)] = inst_61523);

(statearr_61681[(20)] = inst_61524);

(statearr_61681[(24)] = inst_61498__$1);

(statearr_61681[(26)] = inst_61518);

(statearr_61681[(27)] = inst_61519);

return statearr_61681;
})();
var statearr_61682_61750 = state_61636__$1;
(statearr_61682_61750[(2)] = null);

(statearr_61682_61750[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (23))){
var inst_61577 = (state_61636[(10)]);
var inst_61574 = (state_61636[(14)]);
var inst_61577__$1 = (state_61636[(2)]);
var inst_61578 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61577__$1);
var state_61636__$1 = (function (){var statearr_61683 = state_61636;
(statearr_61683[(10)] = inst_61577__$1);

(statearr_61683[(15)] = inst_61578);

return statearr_61683;
})();
if(cljs.core.truth_(inst_61574)){
var statearr_61684_61751 = state_61636__$1;
(statearr_61684_61751[(1)] = (24));

} else {
var statearr_61685_61752 = state_61636__$1;
(statearr_61685_61752[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (47))){
var inst_61535 = (state_61636[(21)]);
var inst_61524 = (state_61636[(20)]);
var inst_61623 = (state_61636[(2)]);
var inst_61624 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_61524,inst_61535,inst_61623);
var state_61636__$1 = state_61636;
var statearr_61686_61753 = state_61636__$1;
(statearr_61686_61753[(2)] = inst_61624);

(statearr_61686_61753[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (35))){
var inst_61599 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61687_61754 = state_61636__$1;
(statearr_61687_61754[(2)] = inst_61599);

(statearr_61687_61754[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (19))){
var inst_61565 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61688_61755 = state_61636__$1;
(statearr_61688_61755[(2)] = inst_61565);

(statearr_61688_61755[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (11))){
var inst_61522 = (state_61636[(9)]);
var inst_61523 = (state_61636[(11)]);
var inst_61524 = (state_61636[(20)]);
var inst_61498 = (state_61636[(24)]);
var inst_61540 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61541 = fluree.db.api.query.response_time_formatted(inst_61498);
var inst_61542 = [inst_61524,inst_61523,inst_61522,inst_61541];
var inst_61543 = cljs.core.PersistentHashMap.fromArrays(inst_61540,inst_61542);
var state_61636__$1 = state_61636;
var statearr_61690_61756 = state_61636__$1;
(statearr_61690_61756[(2)] = inst_61543);

(statearr_61690_61756[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (9))){
var inst_61535 = (state_61636[(21)]);
var inst_61497 = (state_61636[(23)]);
var inst_61552 = (state_61636[(7)]);
var inst_61549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61550 = [inst_61535,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61551 = (new cljs.core.PersistentVector(null,2,(5),inst_61549,inst_61550,null));
var inst_61552__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61497,inst_61551);
var inst_61554 = (inst_61552__$1 == null);
var inst_61555 = cljs.core.not(inst_61554);
var state_61636__$1 = (function (){var statearr_61691 = state_61636;
(statearr_61691[(7)] = inst_61552__$1);

return statearr_61691;
})();
if(inst_61555){
var statearr_61692_61757 = state_61636__$1;
(statearr_61692_61757[(1)] = (14));

} else {
var statearr_61693_61758 = state_61636__$1;
(statearr_61693_61758[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (5))){
var _ = (function (){var statearr_61694 = state_61636;
(statearr_61694[(4)] = cljs.core.rest((state_61636[(4)])));

return statearr_61694;
})();
var state_61636__$1 = state_61636;
var ex61689 = (state_61636__$1[(2)]);
var statearr_61695_61759 = state_61636__$1;
(statearr_61695_61759[(5)] = ex61689);


var statearr_61696_61760 = state_61636__$1;
(statearr_61696_61760[(1)] = (4));

(statearr_61696_61760[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (14))){
var inst_61552 = (state_61636[(7)]);
var inst_61557 = inst_61552.cljs$lang$protocol_mask$partition0$;
var inst_61558 = (inst_61557 & (64));
var inst_61559 = inst_61552.cljs$core$ISeq$;
var inst_61560 = (cljs.core.PROTOCOL_SENTINEL === inst_61559);
var inst_61561 = ((inst_61558) || (inst_61560));
var state_61636__$1 = state_61636;
if(cljs.core.truth_(inst_61561)){
var statearr_61697_61761 = state_61636__$1;
(statearr_61697_61761[(1)] = (17));

} else {
var statearr_61698_61762 = state_61636__$1;
(statearr_61698_61762[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (45))){
var inst_61577 = (state_61636[(10)]);
var inst_61620 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61577);
var state_61636__$1 = state_61636;
var statearr_61699_61763 = state_61636__$1;
(statearr_61699_61763[(2)] = inst_61620);

(statearr_61699_61763[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (26))){
var inst_61574 = (state_61636[(14)]);
var inst_61606 = (state_61636[(2)]);
var state_61636__$1 = (function (){var statearr_61700 = state_61636;
(statearr_61700[(18)] = inst_61606);

return statearr_61700;
})();
if(cljs.core.truth_(inst_61574)){
var statearr_61701_61764 = state_61636__$1;
(statearr_61701_61764[(1)] = (39));

} else {
var statearr_61702_61765 = state_61636__$1;
(statearr_61702_61765[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (16))){
var inst_61568 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
if(cljs.core.truth_(inst_61568)){
var statearr_61703_61766 = state_61636__$1;
(statearr_61703_61766[(1)] = (20));

} else {
var statearr_61704_61767 = state_61636__$1;
(statearr_61704_61767[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (38))){
var inst_61597 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61705_61768 = state_61636__$1;
(statearr_61705_61768[(2)] = inst_61597);

(statearr_61705_61768[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (30))){
var inst_61580 = (state_61636[(8)]);
var state_61636__$1 = state_61636;
var statearr_61706_61769 = state_61636__$1;
(statearr_61706_61769[(2)] = inst_61580);

(statearr_61706_61769[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (10))){
var inst_61629 = (state_61636[(2)]);
var state_61636__$1 = state_61636;
var statearr_61707_61770 = state_61636__$1;
(statearr_61707_61770[(2)] = inst_61629);

(statearr_61707_61770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (18))){
var state_61636__$1 = state_61636;
var statearr_61708_61771 = state_61636__$1;
(statearr_61708_61771[(2)] = false);

(statearr_61708_61771[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (42))){
var inst_61535 = (state_61636[(21)]);
var inst_61577 = (state_61636[(10)]);
var inst_61524 = (state_61636[(20)]);
var inst_61614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61615 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61535];
var inst_61616 = (new cljs.core.PersistentVector(null,2,(5),inst_61614,inst_61615,null));
var inst_61617 = cljs.core.assoc_in(inst_61524,inst_61616,inst_61577);
var state_61636__$1 = state_61636;
var statearr_61709_61772 = state_61636__$1;
(statearr_61709_61772[(2)] = inst_61617);

(statearr_61709_61772[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (37))){
var state_61636__$1 = state_61636;
var statearr_61710_61773 = state_61636__$1;
(statearr_61710_61773[(2)] = null);

(statearr_61710_61773[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61637 === (8))){
var inst_61493 = (state_61636[(22)]);
var state_61636__$1 = state_61636;
if(cljs.core.truth_(inst_61493)){
var statearr_61711_61774 = state_61636__$1;
(statearr_61711_61774[(1)] = (11));

} else {
var statearr_61712_61775 = state_61636__$1;
(statearr_61712_61775[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_61713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61713[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__);

(statearr_61713[(1)] = (1));

return statearr_61713;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1 = (function (state_61636){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61636);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61714){var ex__2417__auto__ = e61714;
var statearr_61715_61776 = state_61636;
(statearr_61715_61776[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61636[(4)]))){
var statearr_61716_61777 = state_61636;
(statearr_61716_61777[(1)] = cljs.core.first((state_61636[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61778 = state_61636;
state_61636 = G__61778;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__ = function(state_61636){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1.call(this,state_61636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61717 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61717[(6)] = c__2436__auto__);

return statearr_61717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__61779 = query_type;
var G__61779__$1 = (((G__61779 instanceof cljs.core.Keyword))?G__61779.fqn:null);
switch (G__61779__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61779__$1)].join('')));

}
});
