// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__32621 = cljs.core._EQ_;
var expr__32622 = e.getLastErrorCode();
if(cljs.core.truth_((pred__32621.cljs$core$IFn$_invoke$arity$2 ? pred__32621.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__32622) : pred__32621.call(null,goog.net.ErrorCode.NO_ERROR,expr__32622)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__32621.cljs$core$IFn$_invoke$arity$2 ? pred__32621.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__32622) : pred__32621.call(null,goog.net.ErrorCode.EXCEPTION,expr__32622)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__32621.cljs$core$IFn$_invoke$arity$2 ? pred__32621.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__32622) : pred__32621.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__32622)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__32621.cljs$core$IFn$_invoke$arity$2 ? pred__32621.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__32622) : pred__32621.call(null,goog.net.ErrorCode.ABORT,expr__32622)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__32621.cljs$core$IFn$_invoke$arity$2 ? pred__32621.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__32622) : pred__32621.call(null,goog.net.ErrorCode.TIMEOUT,expr__32622)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__32624 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32624,cljs.core.cst$kw$status,status);
} else {
return G__32624;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__32625 = opts;
var map__32625__$1 = (((((!((map__32625 == null))))?(((((map__32625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32625):map__32625);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32625__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32625__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32625__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__32627 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__32627__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__32627,headers], 0)):G__32627);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32627__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__32627__$1;
}
})();
try{var G__32629_32635 = url;
var G__32630_32636 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__32631_32637 = "POST";
var G__32632_32638 = fluree.db.util.json.stringify(message);
var G__32633_32639 = cljs.core.clj__GT_js(headers__$1);
var G__32634_32640 = request_timeout;
goog.net.XhrIo.send(G__32629_32635,G__32630_32636,G__32631_32637,G__32632_32638,G__32633_32639,G__32634_32640);
}catch (e32628){var e_32641 = e32628;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_32641);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__32642 = opts;
var map__32642__$1 = (((((!((map__32642 == null))))?(((((map__32642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32642):map__32642);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32642__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32642__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32642__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32642__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32642__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__32644 = cljs.core.PersistentArrayMap.EMPTY;
var G__32644__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__32644,headers], 0)):G__32644);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32644__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__32644__$1;
}
})();
try{var G__32646_32653 = url;
var G__32647_32654 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__32652 = output_format;
var G__32652__$1 = (((G__32652 instanceof cljs.core.Keyword))?G__32652.fqn:null);
switch (G__32652__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__32648_32655 = "GET";
var G__32649_32656 = body;
var G__32650_32657 = cljs.core.clj__GT_js(headers__$1);
var G__32651_32658 = request_timeout;
goog.net.XhrIo.send(G__32646_32653,G__32647_32654,G__32648_32655,G__32649_32656,G__32650_32657,G__32651_32658);
}catch (e32645){var e_32660 = e32645;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_32660);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__32661 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32661,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__32661;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32694){
var state_val_32695 = (state_32694[(1)]);
if((state_val_32695 === (7))){
var inst_32690 = (state_32694[(2)]);
var state_32694__$1 = state_32694;
var statearr_32696_32721 = state_32694__$1;
(statearr_32696_32721[(2)] = inst_32690);

(statearr_32696_32721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (1))){
var state_32694__$1 = state_32694;
var statearr_32697_32722 = state_32694__$1;
(statearr_32697_32722[(2)] = null);

(statearr_32697_32722[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (4))){
var inst_32665 = (state_32694[(7)]);
var inst_32665__$1 = (state_32694[(2)]);
var inst_32666 = (inst_32665__$1 == null);
var state_32694__$1 = (function (){var statearr_32698 = state_32694;
(statearr_32698[(7)] = inst_32665__$1);

return statearr_32698;
})();
if(cljs.core.truth_(inst_32666)){
var statearr_32699_32723 = state_32694__$1;
(statearr_32699_32723[(1)] = (5));

} else {
var statearr_32700_32724 = state_32694__$1;
(statearr_32700_32724[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (6))){
var inst_32665 = (state_32694[(7)]);
var inst_32673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32665,(0),null);
var inst_32674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32665,(1),null);
var state_32694__$1 = (function (){var statearr_32701 = state_32694;
(statearr_32701[(8)] = inst_32674);

(statearr_32701[(9)] = inst_32673);

return statearr_32701;
})();
var statearr_32702_32725 = state_32694__$1;
(statearr_32702_32725[(2)] = null);

(statearr_32702_32725[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (3))){
var inst_32692 = (state_32694[(2)]);
var state_32694__$1 = state_32694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32694__$1,inst_32692);
} else {
if((state_val_32695 === (2))){
var state_32694__$1 = state_32694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32694__$1,(4),pub_chan);
} else {
if((state_val_32695 === (11))){
var _ = (function (){var statearr_32704 = state_32694;
(statearr_32704[(4)] = cljs.core.rest((state_32694[(4)])));

return statearr_32704;
})();
var state_32694__$1 = state_32694;
var ex32703 = (state_32694__$1[(2)]);
var statearr_32705_32726 = state_32694__$1;
(statearr_32705_32726[(5)] = ex32703);


if((ex32703 instanceof Error)){
var statearr_32706_32727 = state_32694__$1;
(statearr_32706_32727[(1)] = (10));

(statearr_32706_32727[(5)] = null);

} else {
throw ex32703;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (9))){
var inst_32687 = (state_32694[(2)]);
var state_32694__$1 = (function (){var statearr_32707 = state_32694;
(statearr_32707[(10)] = inst_32687);

return statearr_32707;
})();
var statearr_32708_32728 = state_32694__$1;
(statearr_32708_32728[(2)] = null);

(statearr_32708_32728[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (5))){
var inst_32668 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_32694__$1 = state_32694;
var statearr_32709_32729 = state_32694__$1;
(statearr_32709_32729[(2)] = inst_32668);

(statearr_32709_32729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (10))){
var inst_32674 = (state_32694[(8)]);
var inst_32675 = (state_32694[(2)]);
var inst_32676 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_32675,"Websocket send message error:",inst_32675], 0));
var inst_32677 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32674,false);
var state_32694__$1 = (function (){var statearr_32710 = state_32694;
(statearr_32710[(11)] = inst_32676);

return statearr_32710;
})();
var statearr_32711_32730 = state_32694__$1;
(statearr_32711_32730[(2)] = inst_32677);

(statearr_32711_32730[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32695 === (8))){
var inst_32674 = (state_32694[(8)]);
var inst_32673 = (state_32694[(9)]);
var _ = (function (){var statearr_32712 = state_32694;
(statearr_32712[(4)] = cljs.core.cons((11),(state_32694[(4)])));

return statearr_32712;
})();
var inst_32683 = ws.send(inst_32673);
var inst_32684 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32674,true);
var ___$1 = (function (){var statearr_32713 = state_32694;
(statearr_32713[(4)] = cljs.core.rest((state_32694[(4)])));

return statearr_32713;
})();
var state_32694__$1 = (function (){var statearr_32714 = state_32694;
(statearr_32714[(12)] = inst_32683);

return statearr_32714;
})();
var statearr_32715_32731 = state_32694__$1;
(statearr_32715_32731[(2)] = inst_32684);

(statearr_32715_32731[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0 = (function (){
var statearr_32716 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32716[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__);

(statearr_32716[(1)] = (1));

return statearr_32716;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1 = (function (state_32694){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32694);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32717){var ex__16304__auto__ = e32717;
var statearr_32718_32732 = state_32694;
(statearr_32718_32732[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32694[(4)]))){
var statearr_32719_32733 = state_32694;
(statearr_32719_32733[(1)] = cljs.core.first((state_32694[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32734 = state_32694;
state_32694 = G__32734;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = function(state_32694){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1.call(this,state_32694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32720 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32720[(6)] = c__16375__auto__);

return statearr_32720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16375__auto___32773 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32760){
var state_val_32761 = (state_32760[(1)]);
if((state_val_32761 === (1))){
var inst_32739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32740 = [open_QMARK_,timeout_chan];
var inst_32741 = (new cljs.core.PersistentVector(null,2,(5),inst_32739,inst_32740,null));
var state_32760__$1 = state_32760;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_32760__$1,(2),inst_32741,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_32761 === (2))){
var inst_32743 = (state_32760[(2)]);
var inst_32744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32743,(0),null);
var inst_32745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32743,(1),null);
var inst_32746 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32745,timeout_chan);
var state_32760__$1 = (function (){var statearr_32762 = state_32760;
(statearr_32762[(7)] = inst_32744);

return statearr_32762;
})();
if(inst_32746){
var statearr_32763_32774 = state_32760__$1;
(statearr_32763_32774[(1)] = (3));

} else {
var statearr_32764_32775 = state_32760__$1;
(statearr_32764_32775[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32761 === (3))){
var inst_32748 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_32749 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32750 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_32751 = cljs.core.PersistentHashMap.fromArrays(inst_32749,inst_32750);
var inst_32752 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32748,inst_32751);
var inst_32753 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_32752);
var inst_32754 = fluree.db.util.xhttp.close_websocket(ws);
var state_32760__$1 = (function (){var statearr_32765 = state_32760;
(statearr_32765[(8)] = inst_32753);

return statearr_32765;
})();
var statearr_32766_32776 = state_32760__$1;
(statearr_32766_32776[(2)] = inst_32754);

(statearr_32766_32776[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32761 === (4))){
var inst_32756 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_32760__$1 = state_32760;
var statearr_32767_32777 = state_32760__$1;
(statearr_32767_32777[(2)] = inst_32756);

(statearr_32767_32777[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32761 === (5))){
var inst_32758 = (state_32760[(2)]);
var state_32760__$1 = state_32760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32760__$1,inst_32758);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0 = (function (){
var statearr_32768 = [null,null,null,null,null,null,null,null,null];
(statearr_32768[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__);

(statearr_32768[(1)] = (1));

return statearr_32768;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1 = (function (state_32760){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32760);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32769){var ex__16304__auto__ = e32769;
var statearr_32770_32778 = state_32760;
(statearr_32770_32778[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32760[(4)]))){
var statearr_32771_32779 = state_32760;
(statearr_32771_32779[(1)] = cljs.core.first((state_32760[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32780 = state_32760;
state_32760 = G__32780;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = function(state_32760){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1.call(this,state_32760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32772 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32772[(6)] = c__16375__auto___32773);

return statearr_32772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
