// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.sql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.sql.template');
goog.require('clojure.string');
goog.require('fluree.db.util.cljs_shim');
goog.require('instaparse.core');
/**
 * SQL grammar in instaparse compatible BNF format loaded at compile time so it's
 *   available to cljs and js artifacts.
 */
fluree.db.query.sql.inline_grammar = "direct-select-statement ::= query-expression [ <space> order-by-clause ]\n\nquery-expression   ::=  non-join-query-expression | joined-table\n\nselect ::= 'select' | 'SELECT'\n\nquery-specification ::=\n                select <space> [set-quantifier <space>] select-list <space> table-expression\n\ndistinct = 'distinct' | 'DISTINCT'\nall = 'all' | 'ALL'\nset-quantifier ::= distinct | all\n\ntable-expression ::= from-clause [ <space> where-clause ] [ <space> group-by-clause ] [ <space> having-clause ]\n\nfrom ::= 'from' | 'FROM'\nfrom-clause ::= from <space> table-reference [ { comma <space> table-reference } ]\n\norder-by ::= 'order by' | 'ORDER BY'\norder-by-clause ::= order-by <space> sort-specification-list\n\nwhere ::= 'where' | 'WHERE'\nwhere-clause ::=  where <space> search-condition\n\ngroup-by ::= 'group by' | 'GROUP BY'\ngroup-by-clause ::=  group-by <space> grouping-column-reference-list\n\ngrouping-column-reference-list ::=\n                grouping-column-reference [ { comma <space> grouping-column-reference } + ]\n\ngrouping-column-reference ::= column-reference [ <space> collate-clause ]\n\nhaving ::= 'having' | 'HAVING'\nhaving-clause ::= having <space> search-condition\n\nselect-list ::= asterisk | select-list-element [ { comma <space> select-list-element } ]\n\nselect-list-element ::= derived-column | (qualifier <period> asterisk)\n\nqualifier ::= table-name / correlation-name\n\ntable-name ::= qualified-name |  qualified-local-table-name\n\nqualified-name ::= [ schema-name <period> ] qualified-identifier { qualified-identifier }\n\nas ::= 'as' | 'AS'\nas-clause ::= [ as <space> ] column-name\n\nderived-column ::= value-expression [ <space> as-clause ]\n\nvalue-expression ::= numeric-value-expression | string-value-expression | datetime-value-expression | interval-value-expression\n\n<value-expression-primary> ::=\n                unsigned-value-specification / column-reference / set-function-specification (* | scalar-subquery | case-expression | left-paren value-expression right-paren | cast-specification *)\n\ncount ::= 'count' | 'COUNT'\navg ::= 'avg' | 'AVG'\nmax ::= 'max' | 'MAX'\nmin ::= 'min' | 'MIN'\nsum ::= 'sum' | 'SUM'\n\nset-function-specification ::=\n                           count [ <space> ] <left-paren> asterisk <right-paren>\n                           | general-set-function\n\ngeneral-set-function ::= set-function-type [ <space> ] <left-paren> [ set-quantifier <space> ] value-expression <right-paren>\n\nset-function-type ::= avg | max | min | sum | count\n\n<datetime-value-expression>   ::=\n                 datetime-term\n        |\t interval-value-expression    plus-sign    datetime-term\n        |\t datetime-value-expression    plus-sign    interval-term\n        |\t datetime-value-expression    minus-sign    interval-term\n\n <datetime-term>   ::=  datetime-factor\n\n <datetime-factor>   ::=  datetime-primary   [  time-zone   ]\n\n <datetime-primary>   ::=  value-expression-primary   |  datetime-value-function\n\n datetime-value-function   ::=\n                 current-date-value-function\n        |\t current-time-value-function\n        |\t current-timestamp-value-function\n\ncurrent-date ::= 'current_date' | 'CURRENT_DATE'\ncurrent-date-value-function   ::= current-date\n\ncurrent-time ::= 'current_time' | 'CURRENT_TIME'\ncurrent-time-value-function   ::=  current-time [  left-paren    time-precision    right-paren   ]\n\ncurrent-timestamp ::= 'current_timestamp' | 'CURRENT_TIMESTAMP'\ncurrent-timestamp-value-function   ::=  current-timestamp [  left-paren    timestamp-precision    right-paren   ]\n\nat ::= 'at' | 'AT'\ntime-zone   ::= at time-zone-specifier\n\nlocal ::= 'local' | 'LOCAL'\ntime-zone ::= 'time zone' | 'TIME ZONE'\ntime-zone-specifier   ::= local | time-zone interval-value-expression\n\n <interval-term>   ::=\n                 interval-factor\n        |\t interval-term-2    asterisk    factor\n        |\t interval-term-2    solidus    factor\n        |\t term    asterisk    interval-factor\n\n <interval-factor>   ::= [  sign   ]  interval-primary\n\n <interval-primary>   ::=  value-expression-primary   [  interval-qualifier   ]\n\n <interval-term-2>   ::=  interval-term\n\n <interval-value-expression>   ::=\n                 interval-term\n        |\t interval-value-expression-1    plus-sign    interval-term-1\n        |\t interval-value-expression-1    minus-sign    interval-term-1\n        |\t left-paren    datetime-value-expression    minus-sign    datetime-term    right-paren    interval-qualifier\n\n <interval-value-expression-1>   ::=  interval-value-expression\n\n <interval-term-1>   ::=  interval-term\n\n <string-value-expression>   ::=  character-value-expression   |  bit-value-expression\n\n <character-value-expression>   ::=  concatenation   |  character-factor\n\n <concatenation>   ::=  character-value-expression    concatenation-operator    character-factor\n\n <character-factor>   ::=  character-primary   [  collate-clause   ]\n\ncollate ::= 'collate' | 'COLLATE'\ncollate-clause ::= collate <space> collation-name\n\n collation-name ::=  qualified-name\n\n <character-primary>   ::=  value-expression-primary   |  string-value-function\n\n string-value-function   ::=  character-value-function   |  bit-value-function\n\n character-value-function   ::=\n             character-substring-function\n        |    fold\n        |    form-of-use-conversion\n        |    character-translation\n        |    trim-function\n\n\ntrim ::= 'trim' | 'TRIM'\ntrim-function   ::= trim left-paren    trim-operands    right-paren\n\n trim-operands   ::= [ [  trim-specification   ] [  trim-character   ] 'FROM' ]  trim-source\n\n\n trim-specification   ::= 'LEADING' | 'TRAILING' | 'BOTH'\n\n trim-character   ::=  character-value-expression\n\n trim-source   ::=  character-value-expression\n\n character-translation   ::=\n                'TRANSLATE'  left-paren    character-value-expression   'USING'  translation-name    right-paren\n\n translation-name   ::=  qualified-name\n\n form-of-use-conversion   ::=\n                'CONVERT'  left-paren    character-value-expression   'USING'  form-of-use-conversion-name    right-paren\n\n form-of-use-conversion-name   ::=  qualified-name\n\n fold   ::= { 'UPPER' | 'LOWER' }  left-paren    character-value-expression    right-paren\n\n character-substring-function   ::=\n                'SUBSTRING'  left-paren    character-value-expression   'FROM'  start-position   [ 'FOR'  string-length   ]  right-paren\n\n start-position   ::=  numeric-value-expression\n\n string-length   ::=  numeric-value-expression\n\n bit-value-function   ::=  bit-substring-function\n\n bit-substring-function   ::=\n                'SUBSTRING'  left-paren    bit-value-expression   'FROM'  start-position   [ 'FOR'  string-length   ]  right-paren\n\n bit-value-expression   ::=  bit-concatenation   |  bit-factor\n\n bit-concatenation   ::=  bit-value-expression    concatenation-operator    bit-factor\n\n bit-factor   ::=  bit-primary\n\n bit-primary   ::=  value-expression-primary   |  string-value-function\n\n<numeric-value-expression> ::=\n                term\n        |    numeric-value-expression    plus-sign    term\n        |    numeric-value-expression    minus-sign    term\n\n<term> ::=\n                factor\n        |   term asterisk factor\n        |   term solidus factor\n\n<factor> ::= [  sign   ] numeric-primary\n\n <sign>   ::=  plus-sign   |  minus-sign\n\n<numeric-primary> ::= value-expression-primary (* |  numeric-value-function   *)\n\ncolumn-reference ::= [ qualifier <period> ] ( column-name | subject-placeholder )\n\ncase-expression   ::=  case-abbreviation   |  case-specification\n\nnullif ::= 'nullif' | 'NULLIF'\ncoalesce ::= 'coalesce' | 'COALESCE'\ncase-abbreviation   ::=  nullif <space> left-paren value-expression comma <space> value-expression right-paren\n                    | coalesce <space> left-paren value-expression { comma <space> value-expression } right-paren\n\ncase-specification   ::=  simple-case   |  searched-case\n\ncase ::= 'case' | 'CASE'\nend ::= 'end' | 'END'\nsimple-case ::= case <space> case-operand\n                        { simple-when-clause  }\n                        [  else-clause   ]\n                        end\n\nwhen ::= 'when' | 'WHEN'\nthen ::= 'then' | 'THEN'\nsimple-when-clause   ::= when <space> when-operand <space> then <space> result\n\n when-operand   ::=  value-expression\n\n case-operand   ::=  value-expression\n\ncase ::= 'case' | 'CASE'\n searched-case   ::=\n                case <space>\n                { searched-when-clause <space> }\n                [ else-clause <space> ]\n                end\n\nelse ::= 'else' | 'ELSE'\nelse-clause   ::= else <space> result\n\nwhen ::= 'when' | 'WHEN'\nthen ::= 'then' | 'THEN'\nsearched-when-clause   ::= when <space> search-condition <space> then <space>  result\n\nor ::= 'or' | 'OR'\nsearch-condition   ::=\n          boolean-term\n          | search-condition <space> or <space> boolean-term\n\nand ::= 'and' | 'AND'\nboolean-term   ::=\n          boolean-factor\n          | boolean-term  <space> and <space> boolean-factor\n\nnot ::= 'not' | 'NOT'\nboolean-factor   ::= [ not <space>]  boolean-test\n\nis ::= 'is' | 'IS'\nboolean-test   ::=  boolean-primary   [ <space> is [ <space> not ] <space> truth-value   ]\n\nboolean-primary   ::=  predicate   |  (left-paren    search-condition    right-paren )\n\npredicate   ::= comparison-predicate | between-predicate | in-predicate | like-predicate | null-predicate | quantified-comparison-predicate | exists-predicate | match-predicate | overlaps-predicate\n\ncomparison-predicate   ::=  row-value-constructor  <space>  comp-op  <space>  row-value-constructor\n\ncomp-op   ::=\n             equals-operator\n        |    not-equals-operator\n        |    less-than-operator\n        |    greater-than-operator\n        |    less-than-or-equals-operator\n        |    greater-than-or-equals-operator\n\nbetween ::= 'between' | 'BETWEEN'\nbetween-predicate ::= row-value-constructor <space> [ not <space> ] between <space> row-value-constructor <space> and <space> row-value-constructor\n\nin ::= 'in' | 'IN'\nin-predicate ::= row-value-constructor <space> [ not <space> ] in <space> in-predicate-value\n\n in-predicate-value ::= table-subquery | left-paren [ <space> ] in-value-list [ <space> ] right-paren\n\n in-value-list ::= value-expression { comma [ <space> ] value-expression }  +\n\n like-predicate ::= match-value [ not ] 'LIKE' pattern [ 'ESCAPE' escape-character ]\n\n match-value ::= character-value-expression\n\n pattern ::= character-value-expression\n\n escape-character ::= character-value-expression\n\nnull ::= 'null' | 'NULL'\nnull-predicate ::= row-value-constructor <space> 'IS' <space> [ not <space> ] null\n\n quantified-comparison-predicate ::= row-value-constructor comp-op quantifier table-subquery\n\n quantifier ::= all | some\n\n some ::= 'some' | 'SOME' | 'any' | 'ANY'\n\nexists ::= 'exists' | 'EXISTS'\nexists-predicate ::= exists <space> table-subquery\n\nunique ::= 'unique' | 'UNIQUE'\nunique-predicate ::= unique <space> table-subquery\n\n match-predicate ::= row-value-constructor 'MATCH' [ 'UNIQUE' ] [ 'PARTIAL' | 'FULL' ] table-subquery\n\n overlaps-predicate ::= row-value-constructor-1 'OVERLAPS' row-value-constructor-2\n\n row-value-constructor-1 ::= row-value-constructor\n\n row-value-constructor-2 ::= row-value-constructor\n\ntrue ::= 'true' | 'TRUE'\nfalse ::= 'false' | 'FALSE'\nunknown ::= 'unknown' | 'UNKNOWN'\ntruth-value   ::= true | false | unknown\n\n row-value-constructor   ::=\n             row-value-constructor-element\n        |    (left-paren    row-value-constructor-list    right-paren)\n        |    row-subquery\n\n row-subquery   ::=  subquery\n\n subquery   ::=  left-paren query-expression right-paren\n\n joined-table   ::=\n             qualified-join\n        |    cross-join\n        |    left-paren joined-table right-paren\n\njoin ::= 'join' | 'JOIN'\nnatural ::= 'natural' | 'NATURAL'\nqualified-join   ::= table-reference <space> [ natural <space> ] [ join-type <space> ] join <space> table-reference [ <space> join-specification ]\n\ncross ::= 'cross' | 'CROSS'\ncross-join ::= table-reference <space> cross <space> join <space> table-reference\n\n table-reference ::= table-name | joined-table | ( derived-table <space> correlation-specification )\n\n derived-table   ::=  table-subquery\n\n table-subquery   ::=  subquery\n\n join-specification ::=  join-condition | named-columns-join\n\non ::= 'on' | 'ON'\njoin-condition ::= on <space> search-condition\n\nusing ::= 'using' | 'USING'\nnamed-columns-join ::= using <space> left-paren join-column-list right-paren\n\njoin-column-list   ::=  column-name-list\n\ncorrelation-specification   ::= [ as <space> ]  correlation-name [ <space> left-paren derived-column-list right-paren ]\n\nderived-column-list   ::=  column-name-list\n\ninner ::= 'inner' | 'INNER'\nunion ::= 'union' | 'UNION'\njoin-type   ::=\n          inner\n        | outer-join-type [ <space> 'OUTER' ]\n        | union\n\nleft ::= 'left' | 'LEFT'\nright ::= 'right' | 'RIGHT'\nfull ::= 'full' | 'FULL'\nouter-join-type ::= left | right | full\n\nexcept ::= 'except' | 'EXCEPT'\nnon-join-query-expression   ::=\n                 non-join-query-term\n                 | query-expression union [ <space> all ] [ <space> corresponding-spec ] <space> query-term\n                 | query-expression except [ <space> all ] [ <space> corresponding-spec ] <space> query-term\n\nintersect ::= 'intersect' | 'INTERSECT'\nnon-join-query-term   ::=\n                 non-join-query-primary\n                 | query-term <space> intersect [ <space> all ] [ <space> corresponding-spec ]  <space> query-primary\n\nquery-primary   ::=  non-join-query-primary   |  joined-table\n\ncorresponding ::= 'corresponding' | 'CORRESPONDING'\ncorresponding-spec ::= corresponding <space> [ 'BY'  left-paren    corresponding-column-list    right-paren   ]\n\n corresponding-column-list   ::=  column-name-list\n\n column-name-list ::= column-name [ { comma <space> column-name }]\n\n non-join-query-primary ::= simple-table |  left-paren non-join-query-expression right-paren\n\n simple-table ::=\n                 query-specification\n        |\t table-value-constructor\n        |\t explicit-table\n\nvalues ::= 'values' | 'VALUES'\ntable-value-constructor ::= values <space> table-value-constructor-list\n\ntable-value-constructor-list ::=  row-value-constructor [ { comma <space> row-value-constructor } ]\n\ntable ::= 'table' | 'TABLE'\nexplicit-table ::= table <space> table-name\n\nquery-term ::= non-join-query-term | joined-table\n\nrow-value-constructor-list   ::=  row-value-constructor-element   [ {  comma <space> row-value-constructor-element   } ]\n\nrow-value-constructor-element   ::=\n             value-expression\n        |    null-specification\n        |    default-specification\n\n sort-specification-list ::= sort-specification [ { comma <space> sort-specification } + ]\n\n sort-specification ::= sort-key [ <space> collate-clause ] [ <space> ordering-specification ]\n\n sort-key ::= column-name (* | unsigned-integer *)\n\nasc ::= 'asc' | 'ASC'\ndesc ::= 'desc' | 'DESC'\nordering-specification ::= asc | desc\n\n result   ::=  result-expression   | null\n\n result-expression   ::=  value-expression\n\n cast-specification   ::= 'CAST'  left-paren    cast-operand   'AS'  cast-target    right-paren\n\n cast-operand   ::=  value-expression   | null\n\n cast-target   ::=  domain-name   |   data-type\n\n data-type   ::=\n     character-string-type   [ 'CHARACTER SET'  character-set-specification   ]\n        |\t national-character-string-type\n        |\t bit-string-type\n        |\t numeric-type\n        |\t datetime-type\n        |\t interval-type\n\n datetime-type   ::=\n                'DATE'\n        |   'TIME' [  left-paren    time-precision    right-paren   ] [ 'WITH TIME ZONE' ]\n        |   'TIMESTAMP' [  left-paren    timestamp-precision    right-paren   ] [ 'WITH TIME ZONE' ]\n\n time-precision   ::=  time-fractional-seconds-precision\n\n time-fractional-seconds-precision   ::=  unsigned-integer\n\n timestamp-precision   ::=  time-fractional-seconds-precision\n\n interval-type   ::= 'INTERVAL'  interval-qualifier\n\n numeric-type   ::=\n                 exact-numeric-type\n        |\t approximate-numeric-type\n\n exact-numeric-type   ::=\n                'NUMERIC' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |       'DECIMAL' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |       'DEC' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |\t'INTEGER'\n        |\t'INT'\n        |\t'SMALLINT'\n\n scale   ::=  unsigned-integer\n\n approximate-numeric-type   ::=\n                'FLOAT' [  left-paren    precision    right-paren   ]\n        |\t'REAL'\n        |\t'DOUBLE PRECISION'\n\n precision   ::=  unsigned-integer\n\n character-string-type   ::=\n                'CHARACTER' [  left-paren    length    right-paren   ]\n        |\t'CHAR' [  left-paren    length    right-paren   ]\n        |\t'CHARACTER VARYING' [  left-paren    length    right-paren   ]\n        |\t'CHAR VARYING' [  left-paren    length    right-paren   ]\n        |\t'VARCHAR' [  left-paren    length    right-paren   ]\n\n\n national-character-string-type   ::=\n                'NATIONAL CHARACTER' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHAR' [  left-paren    length    right-paren   ]\n        |\t'NCHAR' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHARACTER VARYING' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHAR VARYING' [  left-paren    length    right-paren   ]\n        |\t'NCHAR VARYING' [  left-paren    length    right-paren   ]\n\n bit-string-type   ::=\n                'BIT' [  left-paren    length    right-paren   ]\n        |\t'BIT VARYING' [  left-paren    length    right-paren   ]\n\n length   ::=  unsigned-integer\n\n domain-name   ::=  qualified-name\n\nunsigned-value-specification ::= unsigned-literal | general-value-specification\n\nunsigned-literal ::= unsigned-numeric-literal | general-literal\n\n unsigned-numeric-literal   ::=\n                 exact-numeric-literal\n        |\t approximate-numeric-literal\n\n approximate-numeric-literal   ::=\n                 mantissa   'E'  exponent\n\n mantissa   ::=  exact-numeric-literal\n\n exponent   ::=  signed-integer\n\n signed-integer   ::= [  sign   ]  unsigned-integer\n\n exact-numeric-literal   ::=\n                 unsigned-integer   [  period   [  unsigned-integer   ] ]\n        |\t period    unsigned-integer\n\n general-literal   ::=\n                 character-string-literal\n        |\t national-character-string-literal\n        |\t bit-string-literal\n        |\t hex-string-literal\n        |\t datetime-literal\n        |\t interval-literal\n\n character-string-literal  ::=\n        [ introducer character-set-specification ] quote [ { character-representation } ] quote [ { { separator  } quote [ { character-representation } ] quote } ]\n\n national-character-string-literal   ::=\n                'N'  quote   [ { character-representation  } ]  quote   [ { { separator   }  quote   [ { character-representation  } ]  quote   } ]\n\n character-representation   ::=  nonquote-character   |  quote-symbol\n\n quote-symbol ::= quote quote\n\n bit-string-literal   ::=\n                'B'  quote   [ { bit  } ]  quote   [ { { separator  }  quote   [ { bit  } ]  quote   }  ]\n\n bit   ::= '0' | '1'\n\n hex-string-literal   ::=\n                'X'  quote   [ { hexit  } ]  quote   [ { { separator  }  quote   [ { hexit  } ]  quote   } ]\n\n hexit   ::=  digit   | 'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'a' | 'b' | 'c' | 'd' | 'e' | 'f'\n\n separator   ::= {  comment   |  space   |  newline   }\n\n comment   ::=  comment-introducer   [ { comment-character  } ]  newline\n\n comment-introducer   ::=  minus-sign   minus-sign   [{ minus-sign  } ]\n\n comment-character   ::=  nonquote-character   |  quote\n\n nonquote-character   ::= sql-language-character | nonquote-nondoublequote-special-character | double-quote\n\n newline   ::= '!!'\n\n datetime-literal   ::=\n                 date-literal\n        |\t time-literal\n        |\t timestamp-literal\n\n date-literal   ::= 'DATE'  date-string\n\n time-literal   ::= 'TIME'  time-string\n\n timestamp-literal   ::= 'TIMESTAMP'  timestamp-string\n\n time-zone-interval   ::=  sign    hours-value    colon    minutes-value\n\n timestamp-string   ::=  quote    date-value    space    time-value   [  time-zone-interval   ]  quote\n\n date-string   ::=  quote    date-value    quote\n\n date-value   ::=  years-value    minus-sign    months-value    minus-sign    days-value\n\n time-string   ::=  quote    time-value   [  time-zone-interval   ]  quote\n\n time-value   ::=  hours-value    colon    minutes-value    colon    seconds-value\n\n interval-literal   ::= 'INTERVAL' [  sign   ]  interval-string    interval-qualifier\n\n interval-string   ::=  quote   {  year-month-literal   |  day-time-literal   }  quote\n\n year-month-literal   ::=\n                 years-value\n        |\t[  years-value    minus-sign   ]  months-value\n\n months-value   ::=  datetime-value\n\n days-value   ::=  datetime-value\n\n years-value   ::=  datetime-value\n\n datetime-value   ::=  unsigned-integer\n\n day-time-literal   ::=  day-time-interval   |  time-interval\n\n day-time-interval   ::=\n                 days-value   [  space    hours-value   [  colon    minutes-value   [  colon    seconds-value   ] ] ]\n\n time-interval   ::=\n                 hours-value   [  colon    minutes-value   [  colon    seconds-value   ] ]\n        |\t minutes-value   [  colon    seconds-value   ]\n        |\t seconds-value\n\n hours-value   ::=  datetime-value\n\n minutes-value   ::=  datetime-value\n\n seconds-value   ::=  seconds-integer-value   [  period   [  seconds-fraction   ] ]\n\n seconds-integer-value   ::=  unsigned-integer\n\n seconds-fraction   ::=  unsigned-integer\n\n interval-qualifier   ::=\n                 start-field   'TO'  end-field\n        |    single-datetime-field\n\n single-datetime-field   ::=\n                 non-second-datetime-field   [  left-paren    interval-leading-field-precision    right-paren   ]\n        |   'SECOND' [  left-paren    interval-leading-field-precision   [  comma    left-paren    interval-fractional-seconds-precision   ]  right-paren   ]\n\n start-field   ::=\n                 non-second-datetime-field   [  left-paren    interval-leading-field-precision    right-paren   ]\n\n non-second-datetime-field   ::= 'YEAR' | 'MONTH' | 'DAY' | 'HOUR' | 'MINUTE'\n\n interval-leading-field-precision   ::=  unsigned-integer\n\n end-field   ::=\n                 non-second-datetime-field\n        |   'SECOND' [  left-paren    interval-fractional-seconds-precision    right-paren   ]\n\n interval-fractional-seconds-precision   ::=  unsigned-integer\n\n unsigned-integer   ::= digit { digit }\n\n general-value-specification   ::=\n             parameter-specification\n        |    dynamic-parameter-specification\n        |    variable-specification\n        |   'USER'\n        |   'CURRENT_USER'\n        |   'SESSION_USER'\n        |   'SYSTEM_USER'\n        |   'VALUE'\n\n parameter-specification   ::=  parameter-name   [  indicator-parameter   ]\n\n parameter-name   ::=  colon    identifier\n\n indicator-parameter   ::= [ 'INDICATOR' ]  parameter-name\n\n dynamic-parameter-specification   ::=  question-mark\n\n variable-specification   ::=  embedded-variable-name   [  indicator-variable   ]\n\n embedded-variable-name   ::=  colon   host-identifier\n\n host-identifier   ::=\n                 Ada-host-identifier\n        |\t C-host-identifier\n        |\t Cobol-host-identifier\n        |\t Fortran-host-identifier\n        |\t MUMPS-host-identifier\n        |\t Pascal-host-identifier\n        |\t PL-I-host-identifier\n\n Ada-host-identifier   ::= '!!'\n\n C-host-identifier   ::= '!!'\n\n Cobol-host-identifier   ::= '!!'\n\n Fortran-host-identifier   ::= '!!'\n\n MUMPS-host-identifier   ::= '!!'\n\n Pascal-host-identifier   ::= '!!'\n\n PL-I-host-identifier   ::= '!!'\n\n indicator-variable   ::= [ 'INDICATOR' ]  embedded-variable-name\n\n character-set-specification   ::=\n                 standard-character-repertoire-name\n        |\t implementation-defined-character-repertoire-name\n        |\t user-defined-character-repertoire-name\n        |\t standard-universal-character-form-of-use-name\n        |\t implementation-defined-universal-character-form-of-use-name\n\n implementation-defined-character-repertoire-name   ::=  character-set-name\n\n user-defined-character-repertoire-name   ::=  character-set-name\n\n standard-universal-character-form-of-use-name   ::=  character-set-name\n\n implementation-defined-universal-character-form-of-use-name   ::=  character-set-name\n\n standard-character-repertoire-name   ::=  character-set-name\n\n qualified-local-table-name   ::= 'MODULE'  period    local-table-name\n\n local-table-name   ::=  qualified-identifier\n\n character-set-name   ::= [  schema-name    period   ]  sql-language-identifier\n\n column-name   ::=  identifier\n\n correlation-name   ::=  identifier\n\n <qualified-identifier>   ::= identifier\n\n identifier ::= [ introducer character-set-specification ] actual-identifier\n\n <actual-identifier>   ::= regular-identifier | delimited-identifier\n\n <regular-identifier>   ::= identifier-body\n\n<identifier-body> ::= identifier-start [ {  underscore   | identifier-part } ]\n\n<identifier-part> ::= identifier-start |  digit\n\n\n(* An  identifier start   is any character in the Unicode General Category\nclasses \"Lu\", \"Ll\", \"Lt\", \"Lm\", \"Lo\", or \"Nl\".\n\nNOTE 58 \u2014 The Unicode General Category classes \"Lu\", \"Ll\", \"Lt\", \"Lm\", \"Lo\", and\n\"Nl\" are assigned to Unicode characters that are, respectively, upper-case\nletters, lower-case letters, title-case letters, modifier letters, other\nletters, and letter numbers.\n*)\n\n<identifier-start> ::= sql-language-identifier\n\n delimited-identifier ::= double-quote delimited-identifier-body double-quote\n\n delimited-identifier-body   ::= { delimited-identifier-part }\n\n delimited-identifier-part   ::=  nondoublequote-character   |  doublequote-symbol\n\n nondoublequote-character   ::= sql-language-character | nonquote-nondoublequote-special-character | quote\n\n doublequote-symbol   ::=  double-quote   double-quote\n\n schema-name   ::= [  catalog-name    period   ]  unqualified-schema-name\n\n unqualified-schema-name   ::=  identifier\n\n catalog-name   ::=  identifier\n\n introducer   ::=  underscore\n\n sql-language-identifier ::=\n                 sql-language-identifier-start [ { underscore | sql-language-identifier-part } ]\n\n null-specification   ::= null\n\n default-specification   ::= 'DEFAULT'\n\n not-equals-operator   ::= '<>'\n\n greater-than-or-equals-operator   ::= '>='\n\n less-than-or-equals-operator   ::= '<='\n\n concatenation-operator   ::= '||'\n\n double-period   ::= '..'\n\n sql-language-identifier-start   ::=  simple-Latin-letter\n\n sql-language-identifier-part   ::=  simple-Latin-letter   |  digit\n\n<sql-language-character> ::=\n                 simple-Latin-letter\n        |\t digit\n\n<simple-Latin-letter> ::=\n                simple-Latin-upper-case-letter\n        |\t simple-Latin-lower-case-letter\n\n<simple-Latin-upper-case-letter> ::=\n        'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z'\n\n <simple-Latin-lower-case-letter>  ::=\n        'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z'\n\n <digit>   ::=\n        '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'\n\n <nonquote-nondoublequote-special-character> ::=\n                 percent\n        |\t ampersand\n        |\t left-paren\n        |\t right-paren\n        |\t plus-sign\n        |\t comma\n        |\t minus-sign\n        |\t period\n        |\t solidus\n        |\t colon\n        |\t semicolon\n        |\t less-than-operator\n        |\t greater-than-operator\n        |\t equals-operator\n        |\t question-mark\n        |\t underscore\n        |\t vertical-bar\n\n <sql-special-character>   ::=\n                 (* space  | asterisk  | *)\n                 nonquote-nondoublequote-special-character\n        |        double-quote\n        |\t quote\n\n(* space was one of !! See Syntax Rules *)\n <space>   ::= #\"[\\x20\\x09\\x0D\\x0A]*\\#[^\\n]*\\n*[\\x20\\x09\\x0D\\x0A]*|[\\x20\\x09\\x0D\\x0A]\" { #\"[\\x20\\x09\\x0D\\x0A]*\\#[^\\n]*\\n*[\\x20\\x09\\x0D\\x0A]*|[\\x20\\x09\\x0D\\x0A]\"}\n\n double-quote   ::= '\"'\n\n percent   ::= '%'\n\n ampersand   ::= '&'\n\n quote   ::= \"'\"\n\n <left-paren>   ::= <'('>\n\n <right-paren>   ::= <')'>\n\nasterisk ::= '*'\n\n plus-sign   ::= '+'\n\n <comma>   ::= <','>\n\n minus-sign   ::= '-'\n\n period   ::= '.'\n\n solidus   ::= '/'\n\n colon   ::= ':'\n\n semicolon   ::= ';'\n\n less-than-operator   ::= '<'\n\n equals-operator   ::= '='\n\n greater-than-operator   ::= '>'\n\n question-mark   ::= '?'\n\n underscore   ::= '_'\n\n vertical-bar   ::= '|'\n\n sql-embedded-language-character   ::=  left-bracket   |  right-bracket\n\n left-bracket   ::= '['\n\n right-bracket   ::= ']'\n\nsubject-placeholder ::= '$'  { sql-language-character }\n";
fluree.db.query.sql.sql = instaparse.core.parser.cljs$core$IFn$_invoke$arity$variadic(fluree.db.query.sql.inline_grammar,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$ebnf], 0));
fluree.db.query.sql.rule_tag = (function fluree$db$query$sql$rule_tag(r){
return cljs.core.first(r);
});
fluree.db.query.sql.rule_QMARK_ = (function fluree$db$query$sql$rule_QMARK_(elt){
return ((cljs.core.sequential_QMARK_(elt)) && ((fluree.db.query.sql.rule_tag(elt) instanceof cljs.core.Keyword)));
});
/**
 * Keyword rule tags representing the SQL reserved words
 */
fluree.db.query.sql.reserved_words = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 52, [cljs.core.cst$kw$exists,null,cljs.core.cst$kw$unique,null,cljs.core.cst$kw$having,null,cljs.core.cst$kw$current_DASH_time,null,cljs.core.cst$kw$true,null,cljs.core.cst$kw$except,null,cljs.core.cst$kw$where,null,cljs.core.cst$kw$desc,null,cljs.core.cst$kw$full,null,cljs.core.cst$kw$table,null,cljs.core.cst$kw$group_DASH_by,null,cljs.core.cst$kw$else,null,cljs.core.cst$kw$when,null,cljs.core.cst$kw$is,null,cljs.core.cst$kw$unknown,null,cljs.core.cst$kw$current_DASH_timestamp,null,cljs.core.cst$kw$as,null,cljs.core.cst$kw$asc,null,cljs.core.cst$kw$or,null,cljs.core.cst$kw$natural,null,cljs.core.cst$kw$some,null,cljs.core.cst$kw$between,null,cljs.core.cst$kw$not,null,cljs.core.cst$kw$coalesce,null,cljs.core.cst$kw$false,null,cljs.core.cst$kw$corresponding,null,cljs.core.cst$kw$all,null,cljs.core.cst$kw$distinct,null,cljs.core.cst$kw$nullif,null,cljs.core.cst$kw$inner,null,cljs.core.cst$kw$null,null,cljs.core.cst$kw$from,null,cljs.core.cst$kw$case,null,cljs.core.cst$kw$values,null,cljs.core.cst$kw$at,null,cljs.core.cst$kw$order_DASH_by,null,cljs.core.cst$kw$then,null,cljs.core.cst$kw$current_DASH_date,null,cljs.core.cst$kw$and,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$trim,null,cljs.core.cst$kw$intersect,null,cljs.core.cst$kw$on,null,cljs.core.cst$kw$end,null,cljs.core.cst$kw$using,null,cljs.core.cst$kw$local,null,cljs.core.cst$kw$cross,null,cljs.core.cst$kw$collate,null,cljs.core.cst$kw$join,null,cljs.core.cst$kw$select,null,cljs.core.cst$kw$in,null,cljs.core.cst$kw$left,null], null), null);
/**
 * Hierarchy of SQL BNF rule name keywords for parsing equivalence
 */
fluree.db.query.sql.rules = (function (){var derive_all = (function (hier,coll,kw){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (h,elt){
return cljs.core.derive.cljs$core$IFn$_invoke$arity$3(h,elt,kw);
}),hier,coll);
});
return derive_all(cljs.core.derive.cljs$core$IFn$_invoke$arity$3(cljs.core.derive.cljs$core$IFn$_invoke$arity$3(cljs.core.make_hierarchy(),cljs.core.cst$kw$column_DASH_name,cljs.core.cst$kw$fluree$db$query$sql_SLASH_string),cljs.core.cst$kw$character_DASH_string_DASH_literal,cljs.core.cst$kw$fluree$db$query$sql_SLASH_string),fluree.db.query.sql.reserved_words,cljs.core.cst$kw$fluree$db$query$sql_SLASH_reserved);
})();
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.query !== 'undefined') && (typeof fluree.db.query.sql !== 'undefined') && (typeof fluree.db.query.sql.rule_parser !== 'undefined')){
} else {
/**
 * Parse SQL BNF rules depending on their type. Returns a function whose return
 *   chain will eventually contain the parsed rule after repeated execution.
 */
fluree.db.query.sql.rule_parser = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$hierarchy,new cljs.core.Var(function(){return fluree.db.query.sql.rules;},cljs.core.cst$sym$fluree$db$query$sql_SLASH_rules,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$query$sql,cljs.core.cst$sym$rules,"/Volumes/Development/fluree/db/src/fluree/db/query/sql.cljc",11,1,43,43,cljs.core.List.EMPTY,"Hierarchy of SQL BNF rule name keywords for parsing equivalence",(cljs.core.truth_(fluree.db.query.sql.rules)?fluree.db.query.sql.rules.cljs$lang$test:null)]))], null),cljs.core.cst$kw$hierarchy,(function (){var fexpr__43393 = cljs.core.get_global_hierarchy;
return (fexpr__43393.cljs$core$IFn$_invoke$arity$0 ? fexpr__43393.cljs$core$IFn$_invoke$arity$0() : fexpr__43393.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.query.sql","rule-parser"),fluree.db.query.sql.rule_tag,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
/**
 * Uses `trampoline` to allow for mutual recursion without consuming call stack
 *   space when executing the rule parser on deeply nested rule trees.
 */
fluree.db.query.sql.parse_rule = (function fluree$db$query$sql$parse_rule(r){
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((fluree.db.query.sql.rule_parser.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.sql.rule_parser.cljs$core$IFn$_invoke$arity$1(r) : fluree.db.query.sql.rule_parser.call(null,r)));
});
fluree.db.query.sql.parse_element = (function fluree$db$query$sql$parse_element(e){
if(fluree.db.query.sql.rule_QMARK_(e)){
return fluree.db.query.sql.parse_rule(e);
} else {
return e;
}
});
fluree.db.query.sql.parse_all = (function fluree$db$query$sql$parse_all(elts){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.query.sql.parse_element,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([elts], 0));
});
fluree.db.query.sql.parse_into_map = (function fluree$db$query$sql$parse_into_map(elts){
return cljs.core.reduce_kv((function (rules,tag,lst){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(rules,tag,fluree.db.query.sql.parse_all(lst));
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.group_by(fluree.db.query.sql.rule_tag,elts));
});
/**
 * Function to merge parsed (sub) query trees
 */
fluree.db.query.sql.merge_parsed = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.into);
/**
 * Returns a function that, when executed, returns the argument supplied to this
 *   function, `v`, wrapped in a vector if `v` is a rule or scalar, or it returns
 *   `v` itself if `v` is a list of rules or scalars. Used for mutually recursive
 *   parse function's return values in conjunction with `trampoline` to conserve
 *   call-stack space.
 */
fluree.db.query.sql.bounce = (function fluree$db$query$sql$bounce(v){
if(((cljs.core.sequential_QMARK_(v)) && ((!(fluree.db.query.sql.rule_QMARK_(v)))))){
return cljs.core.constantly(v);
} else {
return cljs.core.constantly(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null));
}
});
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__43394){
var vec__43395 = p__43394;
var seq__43396 = cljs.core.seq(vec__43395);
var first__43397 = cljs.core.first(seq__43396);
var seq__43396__$1 = cljs.core.next(seq__43396);
var _ = first__43397;
var rst = seq__43396__$1;
return fluree.db.query.sql.bounce(fluree.db.query.sql.parse_all(rst));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fluree$db$query$sql_SLASH_reserved,(function (p__43398){
var vec__43399 = p__43398;
var seq__43400 = cljs.core.seq(vec__43399);
var first__43401 = cljs.core.first(seq__43400);
var seq__43400__$1 = cljs.core.next(seq__43400);
var _ = first__43401;
var words = seq__43400__$1;
return fluree.db.query.sql.bounce(clojure.string.upper_case(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.parse_element,words)))));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$unsigned_DASH_integer,(function (p__43402){
var vec__43403 = p__43402;
var seq__43404 = cljs.core.seq(vec__43403);
var first__43405 = cljs.core.first(seq__43404);
var seq__43404__$1 = cljs.core.next(seq__43404);
var _ = first__43405;
var rst = seq__43404__$1;
return fluree.db.query.sql.bounce((function (){var G__43406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,fluree.db.query.sql.parse_all(rst));
return Number.parseInt(G__43406);
})());
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$double_DASH_quote,(function (_){
return fluree.db.query.sql.bounce("\"");
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fluree$db$query$sql_SLASH_string,(function (p__43407){
var vec__43408 = p__43407;
var seq__43409 = cljs.core.seq(vec__43408);
var first__43410 = cljs.core.first(seq__43409);
var seq__43409__$1 = cljs.core.next(seq__43409);
var _ = first__43410;
var rst = seq__43409__$1;
return fluree.db.query.sql.bounce(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["'",null], null), null),fluree.db.query.sql.parse_all(rst))));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$qualifier,(function (p__43411){
var vec__43412 = p__43411;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43412,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43412,(1),null);
return fluree.db.query.sql.bounce(cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll.cljs$core$IFn$_invoke$arity$1(cljs.core.first(fluree.db.query.sql.parse_element(q))));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$subject_DASH_placeholder,(function (p__43415){
var vec__43416 = p__43415;
var seq__43417 = cljs.core.seq(vec__43416);
var first__43418 = cljs.core.first(seq__43417);
var seq__43417__$1 = cljs.core.next(seq__43417);
var _ = first__43418;
var first__43418__$1 = cljs.core.first(seq__43417__$1);
var seq__43417__$2 = cljs.core.next(seq__43417__$1);
var ___$1 = first__43418__$1;
var rst = seq__43417__$2;
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,fluree.db.query.sql.template.combine_str(fluree.db.query.sql.template.collection_var,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,fluree.db.query.sql.parse_all(rst)))], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$unsigned_DASH_value_DASH_specification,(function (p__43419){
var vec__43420 = p__43419;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43420,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43420,(1),null);
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,cljs.core.first(fluree.db.query.sql.parse_element(v))], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$column_DASH_reference,(function (p__43423){
var vec__43424 = p__43423;
var seq__43425 = cljs.core.seq(vec__43424);
var first__43426 = cljs.core.first(seq__43425);
var seq__43425__$1 = cljs.core.next(seq__43425);
var _ = first__43426;
var rst = seq__43425__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var pred = (function (){var G__43427 = parse_map;
var G__43427__$1 = (((G__43427 == null))?null:cljs.core.cst$kw$column_DASH_name.cljs$core$IFn$_invoke$arity$1(G__43427));
var G__43427__$2 = (((G__43427__$1 == null))?null:cljs.core.first(G__43427__$1));
if((G__43427__$2 == null)){
return null;
} else {
return fluree.db.query.sql.template.field__GT_predicate_template(G__43427__$2);
}
})();
var subject = (function (){var G__43428 = parse_map;
var G__43428__$1 = (((G__43428 == null))?null:cljs.core.cst$kw$subject_DASH_placeholder.cljs$core$IFn$_invoke$arity$1(G__43428));
if((G__43428__$1 == null)){
return null;
} else {
return cljs.core.first(G__43428__$1);
}
})();
var coll = cljs.core.first(cljs.core.cst$kw$qualifier.cljs$core$IFn$_invoke$arity$1(parse_map));
var G__43429 = (function (){var or__4126__auto__ = subject;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj,fluree.db.query.sql.template.collection_var,cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred,pred], null);
}
})();
var G__43429__$1 = (cljs.core.truth_(coll)?fluree.db.query.sql.template.fill_in_collection(coll,G__43429):G__43429);
return fluree.db.query.sql.bounce(G__43429__$1);

}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_quantifier,(function (p__43430){
var vec__43431 = p__43430;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43431,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43431,(1),null);
var quantifier = cljs.core.first(fluree.db.query.sql.parse_element(q));
var k = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(quantifier,"DISTINCT"))?cljs.core.cst$kw$selectDistinct:cljs.core.cst$kw$select);
return fluree.db.query.sql.bounce(k);
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$asterisk,(function (_){
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_select,cljs.core.PersistentArrayMap.createAsIfByAssoc([fluree.db.query.sql.template.collection_var,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["*"], null)])], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_function_DASH_type,(function (p__43434){
var vec__43435 = p__43434;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43435,(0),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43435,(1),null);
return fluree.db.query.sql.bounce(cljs.core.name(fluree.db.query.sql.rule_tag(t)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$general_DASH_set_DASH_function,(function (p__43438){
var vec__43439 = p__43438;
var seq__43440 = cljs.core.seq(vec__43439);
var first__43441 = cljs.core.first(seq__43440);
var seq__43440__$1 = cljs.core.next(seq__43440);
var _ = first__43441;
var rst = seq__43440__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var func = cljs.core.first(cljs.core.cst$kw$set_DASH_function_DASH_type.cljs$core$IFn$_invoke$arity$1(parse_map));
var val_exp = cljs.core.first(cljs.core.cst$kw$value_DASH_expression.cljs$core$IFn$_invoke$arity$1(parse_map));
var subj = (function (){var or__4126__auto__ = cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj.cljs$core$IFn$_invoke$arity$1(val_exp);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.query.sql.template.collection_var;
}
})();
var pred = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(val_exp);
var val = fluree.db.query.sql.template.build_var(pred);
var distinct_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.cst$kw$set_DASH_quantifier.cljs$core$IFn$_invoke$arity$1(parse_map)),cljs.core.cst$kw$selectDistinct);
var G__43442 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj,subj,cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred,pred,cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,val], null);
var G__43442__$1 = ((distinct_QMARK_)?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__43442,cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.template.build_fn_call,"distinct")):G__43442);
return fluree.db.query.sql.bounce(cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__43442__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.template.build_fn_call,func)));

}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$select_DASH_list_DASH_element,(function (p__43443){
var vec__43444 = p__43443;
var seq__43445 = cljs.core.seq(vec__43444);
var first__43446 = cljs.core.first(seq__43445);
var seq__43445__$1 = cljs.core.next(seq__43445);
var _ = first__43446;
var rst = seq__43445__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var map__43447 = cljs.core.first(cljs.core.cst$kw$derived_DASH_column.cljs$core$IFn$_invoke$arity$1(parse_map));
var map__43447__$1 = (((((!((map__43447 == null))))?(((((map__43447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43447):map__43447);
var subj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43447__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj);
var pred = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43447__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred);
var obj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43447__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj);
var pred_var = (function (){var G__43449 = pred;
if((G__43449 == null)){
return null;
} else {
return fluree.db.query.sql.template.build_var(G__43449);
}
})();
var selected = (function (){var or__4126__auto__ = obj;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return pred_var;
}
})();
var triple = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [subj,pred,pred_var], null);
var G__43450 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_select,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected], null)], null);
var G__43450__$1 = (cljs.core.truth_(fluree.db.query.sql.template.predicate_QMARK_(pred))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43450,cljs.core.cst$kw$fluree$db$query$sql_SLASH_where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [triple], null)):G__43450);
return fluree.db.query.sql.bounce(G__43450__$1);

}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$select_DASH_list,(function (p__43451){
var vec__43452 = p__43451;
var seq__43453 = cljs.core.seq(vec__43452);
var first__43454 = cljs.core.first(seq__43453);
var seq__43453__$1 = cljs.core.next(seq__43453);
var _ = first__43454;
var rst = seq__43453__$1;
return fluree.db.query.sql.bounce(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.merge_parsed,fluree.db.query.sql.parse_all(rst)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$between_DASH_predicate,(function (p__43455){
var vec__43456 = p__43455;
var seq__43457 = cljs.core.seq(vec__43456);
var first__43458 = cljs.core.first(seq__43457);
var seq__43457__$1 = cljs.core.next(seq__43457);
var _ = first__43458;
var rst = seq__43457__$1;
var parsed = fluree.db.query.sql.parse_all(rst);
var vec__43459 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["NOT",null,"AND",null,"BETWEEN",null], null), null)),parsed);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43459,(0),null);
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43459,(1),null);
var u = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43459,(2),null);
var pred = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(col);
var lower = cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(l);
var upper = cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(u);
var field_var = fluree.db.query.sql.template.build_var(pred);
var selector = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null);
var refinement = (cljs.core.truth_(cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["NOT",null], null), null),parsed))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$union,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<",field_var,lower], null))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">",field_var,upper], null))], null)], null)], null)], null):new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=",field_var,lower], null)),fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<=",field_var,upper], null))], null)], null));
return fluree.db.query.sql.bounce(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector,refinement], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$comparison_DASH_predicate,(function (p__43462){
var vec__43463 = p__43462;
var seq__43464 = cljs.core.seq(vec__43463);
var first__43465 = cljs.core.first(seq__43464);
var seq__43464__$1 = cljs.core.next(seq__43464);
var _ = first__43465;
var rst = seq__43464__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var comp = cljs.core.first(cljs.core.cst$kw$comp_DASH_op.cljs$core$IFn$_invoke$arity$1(parse_map));
var vec__43466 = cljs.core.cst$kw$row_DASH_value_DASH_constructor.cljs$core$IFn$_invoke$arity$1(parse_map);
var left = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43466,(0),null);
var right = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43466,(1),null);
return fluree.db.query.sql.bounce((cljs.core.truth_((function (){var fexpr__43469 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["=",null], null), null);
return (fexpr__43469.cljs$core$IFn$_invoke$arity$1 ? fexpr__43469.cljs$core$IFn$_invoke$arity$1(comp) : fexpr__43469.call(null,comp));
})())?(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(right);
}
})())?(function (){var map__43470 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([left,right], 0));
var map__43470__$1 = (((((!((map__43470 == null))))?(((((map__43470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43470):map__43470);
var subj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43470__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj);
var pred = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43470__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred);
var obj = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43470__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [subj,pred,obj], null)], null);
})():(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(right);
} else {
return and__4115__auto__;
}
})())?(function (){var v = fluree.db.query.sql.template.build_var(cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(right));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj.cljs$core$IFn$_invoke$arity$1(right),cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(right),v], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_subj.cljs$core$IFn$_invoke$arity$1(left),cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(left),v], null)], null);
})():null)):(cljs.core.truth_((function (){var fexpr__43472 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["<",null,">",null], null), null);
return (fexpr__43472.cljs$core$IFn$_invoke$arity$1 ? fexpr__43472.cljs$core$IFn$_invoke$arity$1(comp) : fexpr__43472.call(null,comp));
})())?(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(right);
} else {
return and__4115__auto__;
}
})())?(function (){var pred = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(left);
var obj = cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj.cljs$core$IFn$_invoke$arity$1(right);
var field_var = fluree.db.query.sql.template.build_var(pred);
var filter_fn = fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,field_var,obj], null));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [filter_fn], null)], null)], null);
})():null):null)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$in_DASH_predicate,(function (p__43473){
var vec__43474 = p__43473;
var seq__43475 = cljs.core.seq(vec__43474);
var first__43476 = cljs.core.first(seq__43475);
var seq__43475__$1 = cljs.core.next(seq__43475);
var _ = first__43476;
var rst = seq__43475__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var pred = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$row_DASH_value_DASH_constructor.cljs$core$IFn$_invoke$arity$1(parse_map)));
var field_var = fluree.db.query.sql.template.build_var(pred);
var selector = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null);
var not_QMARK_ = cljs.core.contains_QMARK_(parse_map,cljs.core.cst$kw$not);
var filter_pred = ((not_QMARK_)?"not=":"=");
var filter_junc = ((not_QMARK_)?"and":"or");
var filter_clauses = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (v){
return fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [filter_pred,field_var,v], null));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$query$sql_SLASH_obj,cljs.core.cst$kw$in_DASH_predicate_DASH_value.cljs$core$IFn$_invoke$arity$1(parse_map))));
var filter_func = ["(",filter_junc," ",filter_clauses,")"].join('');
return fluree.db.query.sql.bounce(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,filter_func], null)], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$null_DASH_predicate,(function (p__43477){
var vec__43478 = p__43477;
var seq__43479 = cljs.core.seq(vec__43478);
var first__43480 = cljs.core.first(seq__43479);
var seq__43479__$1 = cljs.core.next(seq__43479);
var _ = first__43480;
var rst = seq__43479__$1;
var parsed = fluree.db.query.sql.parse_all(rst);
var pred = cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred.cljs$core$IFn$_invoke$arity$1(cljs.core.first(parsed));
var field_var = fluree.db.query.sql.template.build_var(pred);
if(cljs.core.truth_(cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["NOT",null], null), null),parsed))){
return fluree.db.query.sql.bounce(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null)], null));
} else {
return fluree.db.query.sql.bounce(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,"rdf:type",fluree.db.query.sql.template.collection], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$optional,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$filter,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["nil?",field_var], null))], null)], null)], null));
}
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$boolean_DASH_term,(function (p__43481){
var vec__43482 = p__43481;
var seq__43483 = cljs.core.seq(vec__43482);
var first__43484 = cljs.core.first(seq__43483);
var seq__43483__$1 = cljs.core.next(seq__43483);
var _ = first__43484;
var rst = seq__43483__$1;
return fluree.db.query.sql.bounce(fluree.db.query.sql.parse_all(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (r){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,fluree.db.query.sql.rule_tag(r));
}),rst)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$search_DASH_condition,(function (p__43485){
var vec__43486 = p__43485;
var seq__43487 = cljs.core.seq(vec__43486);
var first__43488 = cljs.core.first(seq__43487);
var seq__43487__$1 = cljs.core.next(seq__43487);
var _ = first__43488;
var rst = seq__43487__$1;
var parsed = fluree.db.query.sql.parse_all(rst);
if(cljs.core.truth_(cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["OR",null], null), null),parsed))){
var vec__43489 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["OR",null], null), null)),parsed);
var front = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43489,(0),null);
var back = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43489,(1),null);
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$union,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vec(front),cljs.core.vec(cljs.core.rest(back))], null)], null));
} else {
return fluree.db.query.sql.bounce(parsed);
}
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$table_DASH_name,(function (p__43492){
var vec__43493 = p__43492;
var seq__43494 = cljs.core.seq(vec__43493);
var first__43495 = cljs.core.first(seq__43494);
var seq__43494__$1 = cljs.core.next(seq__43494);
var _ = first__43495;
var rst = seq__43494__$1;
var parsed_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,fluree.db.query.sql.parse_all(rst));
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parsed_name], null)], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$from_DASH_clause,(function (p__43496){
var vec__43497 = p__43496;
var seq__43498 = cljs.core.seq(vec__43497);
var first__43499 = cljs.core.first(seq__43498);
var seq__43498__$1 = cljs.core.next(seq__43498);
var _ = first__43499;
var first__43499__$1 = cljs.core.first(seq__43498__$1);
var seq__43498__$2 = cljs.core.next(seq__43498__$1);
var ___$1 = first__43499__$1;
var rst = seq__43498__$2;
return fluree.db.query.sql.bounce(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.merge_parsed,fluree.db.query.sql.parse_all(rst)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$where_DASH_clause,(function (p__43500){
var vec__43501 = p__43500;
var seq__43502 = cljs.core.seq(vec__43501);
var first__43503 = cljs.core.first(seq__43502);
var seq__43502__$1 = cljs.core.next(seq__43502);
var _ = first__43503;
var first__43503__$1 = cljs.core.first(seq__43502__$1);
var seq__43502__$2 = cljs.core.next(seq__43502__$1);
var ___$1 = first__43503__$1;
var rst = seq__43502__$2;
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_where,cljs.core.vec(fluree.db.query.sql.parse_all(rst))], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$group_DASH_by_DASH_clause,(function (p__43504){
var vec__43505 = p__43504;
var seq__43506 = cljs.core.seq(vec__43505);
var first__43507 = cljs.core.first(seq__43506);
var seq__43506__$1 = cljs.core.next(seq__43506);
var _ = first__43507;
var first__43507__$1 = cljs.core.first(seq__43506__$1);
var seq__43506__$2 = cljs.core.next(seq__43506__$1);
var ___$1 = first__43507__$1;
var rst = seq__43506__$2;
return fluree.db.query.sql.bounce(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.template.build_var,cljs.core.cst$kw$fluree$db$query$sql_SLASH_pred),fluree.db.query.sql.parse_all(rst)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$table_DASH_expression,(function (p__43508){
var vec__43509 = p__43508;
var seq__43510 = cljs.core.seq(vec__43509);
var first__43511 = cljs.core.first(seq__43510);
var seq__43510__$1 = cljs.core.next(seq__43510);
var _ = first__43511;
var rst = seq__43510__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var from_clause = cljs.core.first(cljs.core.cst$kw$from_DASH_clause.cljs$core$IFn$_invoke$arity$1(parse_map));
var where_clause = (function (){var or__4126__auto__ = (function (){var G__43513 = parse_map;
var G__43513__$1 = (((G__43513 == null))?null:cljs.core.cst$kw$where_DASH_clause.cljs$core$IFn$_invoke$arity$1(G__43513));
if((G__43513__$1 == null)){
return null;
} else {
return cljs.core.first(G__43513__$1);
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,"rdf:type",fluree.db.query.sql.template.collection], null)], null)], null);
}
})();
var grouping = cljs.core.vec(cljs.core.cst$kw$group_DASH_by_DASH_clause.cljs$core$IFn$_invoke$arity$1(parse_map));
var from = cljs.core.first(cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll.cljs$core$IFn$_invoke$arity$1(from_clause));
return fluree.db.query.sql.bounce(fluree.db.query.sql.template.fill_in_collection(from,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((fluree.db.query.sql.merge_parsed.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.sql.merge_parsed.cljs$core$IFn$_invoke$arity$2(from_clause,where_clause) : fluree.db.query.sql.merge_parsed.call(null,from_clause,where_clause)),cljs.core.cst$kw$fluree$db$query$sql_SLASH_group,grouping)));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$query_DASH_specification,(function (p__43514){
var vec__43515 = p__43514;
var seq__43516 = cljs.core.seq(vec__43515);
var first__43517 = cljs.core.first(seq__43516);
var seq__43516__$1 = cljs.core.next(seq__43516);
var _ = first__43517;
var first__43517__$1 = cljs.core.first(seq__43516__$1);
var seq__43516__$2 = cljs.core.next(seq__43516__$1);
var ___$1 = first__43517__$1;
var rst = seq__43516__$2;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var select_key = (function (){var or__4126__auto__ = cljs.core.first(cljs.core.cst$kw$set_DASH_quantifier.cljs$core$IFn$_invoke$arity$1(parse_map));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$select;
}
})();
var table_expr = cljs.core.first(cljs.core.cst$kw$table_DASH_expression.cljs$core$IFn$_invoke$arity$1(parse_map));
var select_list = cljs.core.first(cljs.core.cst$kw$select_DASH_list.cljs$core$IFn$_invoke$arity$1(parse_map));
var map__43518 = (fluree.db.query.sql.merge_parsed.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.sql.merge_parsed.cljs$core$IFn$_invoke$arity$2(table_expr,select_list) : fluree.db.query.sql.merge_parsed.call(null,table_expr,select_list));
var map__43518__$1 = (((((!((map__43518 == null))))?(((((map__43518.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43518.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43518):map__43518);
var coll = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43518__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43518__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_select);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43518__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_where);
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43518__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_group);
var from = cljs.core.first(coll);
var G__43520 = cljs.core.PersistentArrayMap.createAsIfByAssoc([select_key,fluree.db.query.sql.template.fill_in_collection(from,select),cljs.core.cst$kw$where,fluree.db.query.sql.template.fill_in_collection(from,where),cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll,coll]);
var G__43520__$1 = ((cljs.core.seq(group))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43520,cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$groupBy,group], null)):G__43520);
return fluree.db.query.sql.bounce(G__43520__$1);

}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$join_DASH_condition,(function (p__43521){
var vec__43522 = p__43521;
var seq__43523 = cljs.core.seq(vec__43522);
var first__43524 = cljs.core.first(seq__43523);
var seq__43523__$1 = cljs.core.next(seq__43523);
var _ = first__43524;
var first__43524__$1 = cljs.core.first(seq__43523__$1);
var seq__43523__$2 = cljs.core.next(seq__43523__$1);
var ___$1 = first__43524__$1;
var rst = seq__43523__$2;
return fluree.db.query.sql.bounce(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fluree$db$query$sql_SLASH_where,cljs.core.vec(fluree.db.query.sql.parse_all(rst))], null));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$outer_DASH_join_DASH_type,(function (p__43525){
var vec__43526 = p__43525;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43526,(0),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43526,(1),null);
return fluree.db.query.sql.bounce((function (){var G__43529 = t;
switch (G__43529) {
case "LEFT":
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_left;

break;
case "RIGHT":
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_right;

break;
case "FULL":
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_full;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43529)].join('')));

}
})());
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$join_DASH_type,(function (p__43531){
var vec__43532 = p__43531;
var seq__43533 = cljs.core.seq(vec__43532);
var first__43534 = cljs.core.first(seq__43533);
var seq__43533__$1 = cljs.core.next(seq__43533);
var _ = first__43534;
var first__43534__$1 = cljs.core.first(seq__43533__$1);
var seq__43533__$2 = cljs.core.next(seq__43533__$1);
var t = first__43534__$1;
var rst = seq__43533__$2;
return fluree.db.query.sql.bounce((function (){var G__43535 = t;
switch (G__43535) {
case "INNER":
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_inner;

break;
case "UNION":
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_union;

break;
default:
return fluree.db.query.sql.parse_element(t);

}
})());
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$named_DASH_columns_DASH_join,(function (p__43537){
var vec__43538 = p__43537;
var seq__43539 = cljs.core.seq(vec__43538);
var first__43540 = cljs.core.first(seq__43539);
var seq__43539__$1 = cljs.core.next(seq__43539);
var _ = first__43540;
var first__43540__$1 = cljs.core.first(seq__43539__$1);
var seq__43539__$2 = cljs.core.next(seq__43539__$1);
var ___$1 = first__43540__$1;
var rst = seq__43539__$2;
return fluree.db.query.sql.bounce(fluree.db.query.sql.parse_all(rst));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$qualified_DASH_join,(function (p__43541){
var vec__43542 = p__43541;
var seq__43543 = cljs.core.seq(vec__43542);
var first__43544 = cljs.core.first(seq__43543);
var seq__43543__$1 = cljs.core.next(seq__43543);
var _ = first__43544;
var rst = seq__43543__$1;
var parse_map = fluree.db.query.sql.parse_into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.rule_QMARK_,rst));
var spec = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.merge_parsed,cljs.core.cst$kw$join_DASH_specification.cljs$core$IFn$_invoke$arity$1(parse_map));
var join_ref = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.query.sql.merge_parsed,spec,cljs.core.cst$kw$table_DASH_reference.cljs$core$IFn$_invoke$arity$1(parse_map));
var join_type = (function (){var or__4126__auto__ = cljs.core.first(cljs.core.cst$kw$join_DASH_type.cljs$core$IFn$_invoke$arity$1(parse_map));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$fluree$db$query$sql_SLASH_inner;
}
})();
return fluree.db.query.sql.bounce((function (){var G__43545 = join_type;
var G__43545__$1 = (((G__43545 instanceof cljs.core.Keyword))?G__43545.fqn:null);
switch (G__43545__$1) {
case "fluree.db.query.sql/inner":
return join_ref;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43545__$1)].join('')));

}
})());
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$sort_DASH_specification,(function (p__43547){
var vec__43548 = p__43547;
var seq__43549 = cljs.core.seq(vec__43548);
var first__43550 = cljs.core.first(seq__43549);
var seq__43549__$1 = cljs.core.next(seq__43549);
var _ = first__43550;
var rst = seq__43549__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var pred = fluree.db.query.sql.template.field__GT_predicate_template(cljs.core.first(cljs.core.cst$kw$sort_DASH_key.cljs$core$IFn$_invoke$arity$1(parse_map)));
var temp__5733__auto__ = (function (){var G__43551 = parse_map;
var G__43551__$1 = (((G__43551 == null))?null:cljs.core.cst$kw$ordering_DASH_specification.cljs$core$IFn$_invoke$arity$1(G__43551));
if((G__43551__$1 == null)){
return null;
} else {
return cljs.core.first(G__43551__$1);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var order = temp__5733__auto__;
return fluree.db.query.sql.bounce(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [order,pred], null)], null));
} else {
return fluree.db.query.sql.bounce(pred);
}
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$order_DASH_by_DASH_clause,(function (p__43552){
var vec__43553 = p__43552;
var seq__43554 = cljs.core.seq(vec__43553);
var first__43555 = cljs.core.first(seq__43554);
var seq__43554__$1 = cljs.core.next(seq__43554);
var _ = first__43555;
var first__43555__$1 = cljs.core.first(seq__43554__$1);
var seq__43554__$2 = cljs.core.next(seq__43554__$1);
var ___$1 = first__43555__$1;
var rst = seq__43554__$2;
return fluree.db.query.sql.bounce(fluree.db.query.sql.parse_all(rst));
}));
fluree.db.query.sql.rule_parser.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$direct_DASH_select_DASH_statement,(function (p__43556){
var vec__43557 = p__43556;
var seq__43558 = cljs.core.seq(vec__43557);
var first__43559 = cljs.core.first(seq__43558);
var seq__43558__$1 = cljs.core.next(seq__43558);
var _ = first__43559;
var rst = seq__43558__$1;
var parse_map = fluree.db.query.sql.parse_into_map(rst);
var map__43560 = cljs.core.first(cljs.core.cst$kw$query_DASH_expression.cljs$core$IFn$_invoke$arity$1(parse_map));
var map__43560__$1 = (((((!((map__43560 == null))))?(((((map__43560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43560):map__43560);
var query = map__43560__$1;
var coll = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43560__$1,cljs.core.cst$kw$fluree$db$query$sql_SLASH_coll);
var ordering = (function (){var G__43562 = parse_map;
var G__43562__$1 = (((G__43562 == null))?null:cljs.core.cst$kw$order_DASH_by_DASH_clause.cljs$core$IFn$_invoke$arity$1(G__43562));
var G__43562__$2 = (((G__43562__$1 == null))?null:cljs.core.first(G__43562__$1));
if((G__43562__$2 == null)){
return null;
} else {
return fluree.db.query.sql.template.fill_in_collection(cljs.core.first(coll),G__43562__$2);
}
})();
var G__43563 = query;
var G__43563__$1 = (cljs.core.truth_(ordering)?cljs.core.update.cljs$core$IFn$_invoke$arity$5(G__43563,cljs.core.cst$kw$opts,cljs.core.assoc,cljs.core.cst$kw$orderBy,ordering):G__43563);
return fluree.db.query.sql.bounce(G__43563__$1);

}));
fluree.db.query.sql.parse = (function fluree$db$query$sql$parse(q){
return cljs.core.select_keys(cljs.core.first(fluree.db.query.sql.parse_rule((function (){var G__43564 = clojure.string.trim(q);
return (fluree.db.query.sql.sql.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.sql.sql.cljs$core$IFn$_invoke$arity$1(G__43564) : fluree.db.query.sql.sql.call(null,G__43564));
})())),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$selectDistinct,cljs.core.cst$kw$selectOne,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$prefixes,cljs.core.cst$kw$vars,cljs.core.cst$kw$opts], null));
});
