// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__30888 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(5),null);
var G__30891 = idx;
var G__30891__$1 = (((G__30891 instanceof cljs.core.Keyword))?G__30891.fqn:null);
switch (G__30891__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30891__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__30893 = idx;
var G__30893__$1 = (((G__30893 instanceof cljs.core.Keyword))?G__30893.fqn:null);
switch (G__30893__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30893__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__30895 = idx;
var G__30895__$1 = (((G__30895 instanceof cljs.core.Keyword))?G__30895.fqn:null);
switch (G__30895__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30895__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_30935){
var state_val_30936 = (state_30935[(1)]);
if((state_val_30936 === (7))){
var inst_30912 = (state_30935[(7)]);
var inst_30919 = (state_30935[(2)]);
var inst_30920 = fluree.db.util.async.throw_err(inst_30919);
var state_30935__$1 = (function (){var statearr_30937 = state_30935;
(statearr_30937[(8)] = inst_30920);

return statearr_30937;
})();
if(cljs.core.truth_(inst_30912)){
var statearr_30938_30962 = state_30935__$1;
(statearr_30938_30962[(1)] = (8));

} else {
var statearr_30939_30963 = state_30935__$1;
(statearr_30939_30963[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (1))){
var state_30935__$1 = state_30935;
var statearr_30940_30964 = state_30935__$1;
(statearr_30940_30964[(2)] = null);

(statearr_30940_30964[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (4))){
var inst_30897 = (state_30935[(2)]);
var state_30935__$1 = state_30935;
var statearr_30941_30965 = state_30935__$1;
(statearr_30941_30965[(2)] = inst_30897);

(statearr_30941_30965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (13))){
var inst_30927 = (state_30935[(2)]);
var state_30935__$1 = state_30935;
var statearr_30942_30966 = state_30935__$1;
(statearr_30942_30966[(2)] = inst_30927);

(statearr_30942_30966[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (6))){
var inst_30909 = (state_30935[(9)]);
var inst_30915 = (state_30935[(2)]);
var inst_30916 = fluree.db.util.async.throw_err(inst_30915);
var inst_30917 = fluree.db.query.range.resolve_subid(db,inst_30909);
var state_30935__$1 = (function (){var statearr_30943 = state_30935;
(statearr_30943[(10)] = inst_30916);

return statearr_30943;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30935__$1,(7),inst_30917);
} else {
if((state_val_30936 === (3))){
var inst_30933 = (state_30935[(2)]);
var state_30935__$1 = state_30935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30935__$1,inst_30933);
} else {
if((state_val_30936 === (12))){
var state_30935__$1 = state_30935;
var statearr_30944_30967 = state_30935__$1;
(statearr_30944_30967[(2)] = (2147483647));

(statearr_30944_30967[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (2))){
var _ = (function (){var statearr_30945 = state_30935;
(statearr_30945[(4)] = cljs.core.cons((5),(state_30935[(4)])));

return statearr_30945;
})();
var inst_30906 = parts;
var inst_30907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(0),null);
var inst_30908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(1),null);
var inst_30909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(2),null);
var inst_30910 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(3),null);
var inst_30911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(4),null);
var inst_30912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30906,(5),null);
var inst_30913 = fluree.db.query.range.resolve_subid(db,inst_30907);
var state_30935__$1 = (function (){var statearr_30946 = state_30935;
(statearr_30946[(11)] = inst_30908);

(statearr_30946[(12)] = inst_30910);

(statearr_30946[(13)] = inst_30911);

(statearr_30946[(7)] = inst_30912);

(statearr_30946[(9)] = inst_30909);

return statearr_30946;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30935__$1,(6),inst_30913);
} else {
if((state_val_30936 === (11))){
var state_30935__$1 = state_30935;
var statearr_30948_30968 = state_30935__$1;
(statearr_30948_30968[(2)] = fluree.db.util.core.min_integer);

(statearr_30948_30968[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (9))){
var inst_30923 = (cljs.core._GT__EQ_ === test);
var state_30935__$1 = state_30935;
if(cljs.core.truth_(inst_30923)){
var statearr_30949_30969 = state_30935__$1;
(statearr_30949_30969[(1)] = (11));

} else {
var statearr_30950_30970 = state_30935__$1;
(statearr_30950_30970[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (5))){
var _ = (function (){var statearr_30951 = state_30935;
(statearr_30951[(4)] = cljs.core.rest((state_30935[(4)])));

return statearr_30951;
})();
var state_30935__$1 = state_30935;
var ex30947 = (state_30935__$1[(2)]);
var statearr_30952_30971 = state_30935__$1;
(statearr_30952_30971[(5)] = ex30947);


if((ex30947 instanceof Error)){
var statearr_30953_30972 = state_30935__$1;
(statearr_30953_30972[(1)] = (4));

(statearr_30953_30972[(5)] = null);

} else {
throw ex30947;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (10))){
var inst_30920 = (state_30935[(8)]);
var inst_30908 = (state_30935[(11)]);
var inst_30910 = (state_30935[(12)]);
var inst_30911 = (state_30935[(13)]);
var inst_30916 = (state_30935[(10)]);
var inst_30929 = (state_30935[(2)]);
var inst_30930 = fluree.db.flake.__GT_Flake(inst_30916,inst_30908,inst_30920,inst_30910,inst_30911,inst_30929);
var _ = (function (){var statearr_30954 = state_30935;
(statearr_30954[(4)] = cljs.core.rest((state_30935[(4)])));

return statearr_30954;
})();
var state_30935__$1 = state_30935;
var statearr_30955_30973 = state_30935__$1;
(statearr_30955_30973[(2)] = inst_30930);

(statearr_30955_30973[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30936 === (8))){
var inst_30912 = (state_30935[(7)]);
var state_30935__$1 = state_30935;
var statearr_30956_30974 = state_30935__$1;
(statearr_30956_30974[(2)] = inst_30912);

(statearr_30956_30974[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____0 = (function (){
var statearr_30957 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30957[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__);

(statearr_30957[(1)] = (1));

return statearr_30957;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____1 = (function (state_30935){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_30935);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e30958){var ex__16304__auto__ = e30958;
var statearr_30959_30975 = state_30935;
(statearr_30959_30975[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_30935[(4)]))){
var statearr_30960_30976 = state_30935;
(statearr_30960_30976[(1)] = cljs.core.first((state_30935[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__30977 = state_30935;
state_30935 = G__30977;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__ = function(state_30935){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____1.call(this,state_30935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_30961 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_30961[(6)] = c__16375__auto__);

return statearr_30961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns a channel that will eventually contain a stream of index nodes from
 *   index `idx` within the database `db` between `start-flake` and `end-flake`,
 *   inclusive and one-by-one
 */
fluree.db.query.range.index_node_stream = (function fluree$db$query$range$index_node_stream(db,idx,start_flake,end_flake){
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__16375__auto___31038 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31014){
var state_val_31015 = (state_31014[(1)]);
if((state_val_31015 === (7))){
var inst_30992 = (state_31014[(2)]);
var inst_30993 = cljs.core.not(inst_30992);
var state_31014__$1 = state_31014;
if(inst_30993){
var statearr_31016_31039 = state_31014__$1;
(statearr_31016_31039[(1)] = (8));

} else {
var statearr_31017_31040 = state_31014__$1;
(statearr_31017_31040[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (1))){
var inst_30978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_30979 = fluree.db.dbproto._resolve(inst_30978);
var state_31014__$1 = state_31014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31014__$1,(2),inst_30979);
} else {
if((state_val_31015 === (4))){
var inst_31012 = (state_31014[(2)]);
var state_31014__$1 = state_31014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31014__$1,inst_31012);
} else {
if((state_val_31015 === (15))){
var inst_31008 = (state_31014[(2)]);
var state_31014__$1 = state_31014;
var statearr_31018_31041 = state_31014__$1;
(statearr_31018_31041[(2)] = inst_31008);

(statearr_31018_31041[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (13))){
var inst_31000 = (state_31014[(7)]);
var inst_31004 = fluree.db.dbproto._rhs(inst_31000);
var inst_30984 = inst_31004;
var state_31014__$1 = (function (){var statearr_31019 = state_31014;
(statearr_31019[(8)] = inst_30984);

return statearr_31019;
})();
var statearr_31020_31042 = state_31014__$1;
(statearr_31020_31042[(2)] = null);

(statearr_31020_31042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (6))){
var inst_30984 = (state_31014[(8)]);
var state_31014__$1 = state_31014;
var statearr_31021_31043 = state_31014__$1;
(statearr_31021_31043[(2)] = inst_30984);

(statearr_31021_31043[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (3))){
var inst_30984 = (state_31014[(8)]);
var state_31014__$1 = state_31014;
if(cljs.core.truth_(inst_30984)){
var statearr_31022_31044 = state_31014__$1;
(statearr_31022_31044[(1)] = (5));

} else {
var statearr_31023_31045 = state_31014__$1;
(statearr_31023_31045[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (12))){
var inst_31002 = (state_31014[(2)]);
var state_31014__$1 = state_31014;
if(cljs.core.truth_(inst_31002)){
var statearr_31024_31046 = state_31014__$1;
(statearr_31024_31046[(1)] = (13));

} else {
var statearr_31025_31047 = state_31014__$1;
(statearr_31025_31047[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (2))){
var inst_30981 = (state_31014[(2)]);
var inst_30982 = fluree.db.util.async.throw_err(inst_30981);
var inst_30983 = start_flake;
var inst_30984 = inst_30983;
var state_31014__$1 = (function (){var statearr_31026 = state_31014;
(statearr_31026[(9)] = inst_30982);

(statearr_31026[(8)] = inst_30984);

return statearr_31026;
})();
var statearr_31027_31048 = state_31014__$1;
(statearr_31027_31048[(2)] = null);

(statearr_31027_31048[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (11))){
var inst_31000 = (state_31014[(7)]);
var inst_30999 = (state_31014[(2)]);
var inst_31000__$1 = fluree.db.util.async.throw_err(inst_30999);
var state_31014__$1 = (function (){var statearr_31028 = state_31014;
(statearr_31028[(7)] = inst_31000__$1);

return statearr_31028;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31014__$1,(12),out,inst_31000__$1);
} else {
if((state_val_31015 === (9))){
var inst_30982 = (state_31014[(9)]);
var inst_30984 = (state_31014[(8)]);
var inst_30997 = fluree.db.dbproto._lookup_leaf(inst_30982,inst_30984);
var state_31014__$1 = state_31014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31014__$1,(11),inst_30997);
} else {
if((state_val_31015 === (5))){
var inst_30984 = (state_31014[(8)]);
var inst_30987 = (idx_compare.cljs$core$IFn$_invoke$arity$2 ? idx_compare.cljs$core$IFn$_invoke$arity$2(inst_30984,end_flake) : idx_compare.call(null,inst_30984,end_flake));
var inst_30988 = (inst_30987 > (0));
var inst_30989 = cljs.core.not(inst_30988);
var state_31014__$1 = state_31014;
var statearr_31029_31049 = state_31014__$1;
(statearr_31029_31049[(2)] = inst_30989);

(statearr_31029_31049[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (14))){
var state_31014__$1 = state_31014;
var statearr_31030_31050 = state_31014__$1;
(statearr_31030_31050[(2)] = null);

(statearr_31030_31050[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (10))){
var inst_31010 = (state_31014[(2)]);
var state_31014__$1 = state_31014;
var statearr_31031_31051 = state_31014__$1;
(statearr_31031_31051[(2)] = inst_31010);

(statearr_31031_31051[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31015 === (8))){
var inst_30995 = cljs.core.async.close_BANG_(out);
var state_31014__$1 = state_31014;
var statearr_31032_31052 = state_31014__$1;
(statearr_31032_31052[(2)] = inst_30995);

(statearr_31032_31052[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____0 = (function (){
var statearr_31033 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31033[(0)] = fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__);

(statearr_31033[(1)] = (1));

return statearr_31033;
});
var fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____1 = (function (state_31014){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31014);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31034){var ex__16304__auto__ = e31034;
var statearr_31035_31053 = state_31014;
(statearr_31035_31053[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31014[(4)]))){
var statearr_31036_31054 = state_31014;
(statearr_31036_31054[(1)] = cljs.core.first((state_31014[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31055 = state_31014;
state_31014 = G__31055;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__ = function(state_31014){
switch(arguments.length){
case 0:
return fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____1.call(this,state_31014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____0;
fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$index_node_stream_$_state_machine__16301__auto____1;
return fluree$db$query$range$index_node_stream_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31037 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31037[(6)] = c__16375__auto___31038);

return statearr_31037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
});
fluree.db.query.range.flake_subrange_xf = (function fluree$db$query$range$flake_subrange_xf(start_test,start_flake,end_test,end_flake){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (flake_range){
return fluree.db.flake.subrange(flake_range,start_test,start_flake,end_test,end_flake);
}));
});
/**
 * Returns a channel that will eventually contain a stream of flakes between
 *   `start-flake` and `end-flake`, according to `start-test` and `end-test`,
 *   respectively, and also contained within the history range between `from-t` and
 *   `to-t` for some index data node in the `node-stream` channel.
 */
fluree.db.query.range.expand_history_range = (function fluree$db$query$range$expand_history_range(node_stream,from_t,to_t,novelty,start_test,start_flake,end_test,end_flake){
var subrange_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),fluree.db.query.range.flake_subrange_xf(start_test,start_flake,end_test,end_flake));
var c__16375__auto___31099 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31079){
var state_val_31080 = (state_31079[(1)]);
if((state_val_31080 === (7))){
var inst_31075 = (state_31079[(2)]);
var state_31079__$1 = state_31079;
var statearr_31081_31100 = state_31079__$1;
(statearr_31081_31100[(2)] = inst_31075);

(statearr_31081_31100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (1))){
var state_31079__$1 = state_31079;
var statearr_31082_31101 = state_31079__$1;
(statearr_31082_31101[(2)] = null);

(statearr_31082_31101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (4))){
var inst_31058 = (state_31079[(7)]);
var inst_31058__$1 = (state_31079[(2)]);
var state_31079__$1 = (function (){var statearr_31083 = state_31079;
(statearr_31083[(7)] = inst_31058__$1);

return statearr_31083;
})();
if(cljs.core.truth_(inst_31058__$1)){
var statearr_31084_31102 = state_31079__$1;
(statearr_31084_31102[(1)] = (5));

} else {
var statearr_31085_31103 = state_31079__$1;
(statearr_31085_31103[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (6))){
var inst_31073 = cljs.core.async.close_BANG_(subrange_ch);
var state_31079__$1 = state_31079;
var statearr_31086_31104 = state_31079__$1;
(statearr_31086_31104[(2)] = inst_31073);

(statearr_31086_31104[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (3))){
var inst_31077 = (state_31079[(2)]);
var state_31079__$1 = state_31079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31079__$1,inst_31077);
} else {
if((state_val_31080 === (12))){
var inst_31067 = (state_31079[(2)]);
var state_31079__$1 = state_31079;
var statearr_31087_31105 = state_31079__$1;
(statearr_31087_31105[(2)] = inst_31067);

(statearr_31087_31105[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (2))){
var state_31079__$1 = state_31079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31079__$1,(4),node_stream);
} else {
if((state_val_31080 === (11))){
var inst_31070 = (state_31079[(2)]);
var state_31079__$1 = (function (){var statearr_31088 = state_31079;
(statearr_31088[(8)] = inst_31070);

return statearr_31088;
})();
var statearr_31089_31106 = state_31079__$1;
(statearr_31089_31106[(2)] = null);

(statearr_31089_31106[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (9))){
var inst_31063 = (state_31079[(9)]);
var state_31079__$1 = state_31079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31079__$1,(12),subrange_ch,inst_31063);
} else {
if((state_val_31080 === (5))){
var inst_31058 = (state_31079[(7)]);
var inst_31060 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_31058,from_t,to_t,novelty);
var state_31079__$1 = state_31079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31079__$1,(8),inst_31060);
} else {
if((state_val_31080 === (10))){
var state_31079__$1 = state_31079;
var statearr_31090_31107 = state_31079__$1;
(statearr_31090_31107[(2)] = null);

(statearr_31090_31107[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31080 === (8))){
var inst_31063 = (state_31079[(9)]);
var inst_31062 = (state_31079[(2)]);
var inst_31063__$1 = fluree.db.util.async.throw_err(inst_31062);
var inst_31064 = cljs.core.seq(inst_31063__$1);
var state_31079__$1 = (function (){var statearr_31091 = state_31079;
(statearr_31091[(9)] = inst_31063__$1);

return statearr_31091;
})();
if(inst_31064){
var statearr_31092_31108 = state_31079__$1;
(statearr_31092_31108[(1)] = (9));

} else {
var statearr_31093_31109 = state_31079__$1;
(statearr_31093_31109[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____0 = (function (){
var statearr_31094 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31094[(0)] = fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__);

(statearr_31094[(1)] = (1));

return statearr_31094;
});
var fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____1 = (function (state_31079){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31079);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31095){var ex__16304__auto__ = e31095;
var statearr_31096_31110 = state_31079;
(statearr_31096_31110[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31079[(4)]))){
var statearr_31097_31111 = state_31079;
(statearr_31097_31111[(1)] = cljs.core.first((state_31079[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31112 = state_31079;
state_31079 = G__31112;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__ = function(state_31079){
switch(arguments.length){
case 0:
return fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____1.call(this,state_31079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____0;
fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$expand_history_range_$_state_machine__16301__auto____1;
return fluree$db$query$range$expand_history_range_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31098 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31098[(6)] = c__16375__auto___31099);

return statearr_31098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return subrange_ch;
});
/**
 * Returns a channel that will eventually contain only the schema flakes and the
 *   flakes validated by fluree.db.permissions-validate/allow-flake? function for
 *   the database `db` from the `flake-stream` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(flake_stream,p__31113,start,end){
var map__31114 = p__31113;
var map__31114__$1 = (((((!((map__31114 == null))))?(((((map__31114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31114.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31114):map__31114);
var db = map__31114__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31114__$1,cljs.core.cst$kw$permissions);
return flake_stream;
});
fluree.db.query.range.take_only = (function fluree$db$query$range$take_only(flake_chan,limit){
if(cljs.core.truth_(limit)){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2(limit,flake_chan);
} else {
return flake_chan;
}
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__31116 = cljs.core.identical_QMARK_;
var expr__31117 = test;
if(cljs.core.truth_((pred__31116.cljs$core$IFn$_invoke$arity$2 ? pred__31116.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__31117) : pred__31116.call(null,cljs.core._EQ_,expr__31117)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31116.cljs$core$IFn$_invoke$arity$2 ? pred__31116.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__31117) : pred__31116.call(null,cljs.core._LT_,expr__31117)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__31116.cljs$core$IFn$_invoke$arity$2 ? pred__31116.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__31117) : pred__31116.call(null,cljs.core._LT__EQ_,expr__31117)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31116.cljs$core$IFn$_invoke$arity$2 ? pred__31116.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__31117) : pred__31116.call(null,cljs.core._GT_,expr__31117)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__31116.cljs$core$IFn$_invoke$arity$2 ? pred__31116.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__31117) : pred__31116.call(null,cljs.core._GT__EQ_,expr__31117)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31117)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__31120 = arguments.length;
switch (G__31120) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31121 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31121,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31121,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31121,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31121,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__31124,idx,start_test,start_match,end_test,end_match,opts){
var map__31125 = p__31124;
var map__31125__$1 = (((((!((map__31125 == null))))?(((((map__31125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31125):map__31125);
var db = map__31125__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31125__$1,cljs.core.cst$kw$t);
var map__31127 = opts;
var map__31127__$1 = (((((!((map__31127 == null))))?(((((map__31127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31127.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31127):map__31127);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31127__$1,cljs.core.cst$kw$limit);
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31127__$1,cljs.core.cst$kw$from_DASH_t,t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31127__$1,cljs.core.cst$kw$to_DASH_t);
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$novelty,idx], null));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var out_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,idx_compare,flakes);
})));
var c__16375__auto___31154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31145){
var state_val_31146 = (state_31145[(1)]);
if((state_val_31146 === (1))){
var inst_31129 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_31145__$1 = state_31145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31145__$1,(2),inst_31129);
} else {
if((state_val_31146 === (2))){
var inst_31131 = (state_31145[(2)]);
var inst_31132 = fluree.db.util.async.throw_err(inst_31131);
var inst_31133 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_31145__$1 = (function (){var statearr_31147 = state_31145;
(statearr_31147[(7)] = inst_31132);

return statearr_31147;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31145__$1,(3),inst_31133);
} else {
if((state_val_31146 === (3))){
var inst_31132 = (state_31145[(7)]);
var inst_31135 = (state_31145[(2)]);
var inst_31136 = fluree.db.util.async.throw_err(inst_31135);
var inst_31137 = cljs.core.PersistentVector.EMPTY;
var inst_31138 = fluree.db.query.range.index_node_stream(db,idx,inst_31132,inst_31136);
var inst_31139 = fluree.db.query.range.expand_history_range(inst_31138,from_t,to_t,novelty,start_test,inst_31132,end_test,inst_31136);
var inst_31140 = fluree.db.query.range.filter_authorized(inst_31139,db,inst_31132,inst_31136);
var inst_31141 = fluree.db.query.range.take_only(inst_31140,limit);
var inst_31142 = cljs.core.async.into(inst_31137,inst_31141);
var inst_31143 = cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(inst_31142,out_chan);
var state_31145__$1 = state_31145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31145__$1,inst_31143);
} else {
return null;
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31148 = [null,null,null,null,null,null,null,null];
(statearr_31148[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31148[(1)] = (1));

return statearr_31148;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31145){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31145);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31149){var ex__16304__auto__ = e31149;
var statearr_31150_31155 = state_31145;
(statearr_31150_31155[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31145[(4)]))){
var statearr_31151_31156 = state_31145;
(statearr_31151_31156[(1)] = cljs.core.first((state_31145[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31157 = state_31145;
state_31145 = G__31157;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31145){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31152 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31152[(6)] = c__16375__auto___31154);

return statearr_31152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out_chan;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Returns a channel that will eventually contain a stream of index nodes where
 *   each node in the output stream is the result of resolving a node in the input
 *   `node-stream` at specified transaction `t` and index novelty `novelty`
 */
fluree.db.query.range.resolve_nodes_to_t = (function fluree$db$query$range$resolve_nodes_to_t(nodes,novelty,fast_forward_db_QMARK_,t){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__16375__auto___31226 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31193){
var state_val_31194 = (state_31193[(1)]);
if((state_val_31194 === (7))){
var inst_31189 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31195_31227 = state_31193__$1;
(statearr_31195_31227[(2)] = inst_31189);

(statearr_31195_31227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (1))){
var state_31193__$1 = state_31193;
var statearr_31196_31228 = state_31193__$1;
(statearr_31196_31228[(2)] = null);

(statearr_31196_31228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (4))){
var inst_31160 = (state_31193[(7)]);
var inst_31160__$1 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31197 = state_31193;
(statearr_31197[(7)] = inst_31160__$1);

return statearr_31197;
})();
if(cljs.core.truth_(inst_31160__$1)){
var statearr_31198_31229 = state_31193__$1;
(statearr_31198_31229[(1)] = (5));

} else {
var statearr_31199_31230 = state_31193__$1;
(statearr_31199_31230[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (15))){
var inst_31185 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31200_31231 = state_31193__$1;
(statearr_31200_31231[(2)] = inst_31185);

(statearr_31200_31231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (13))){
var inst_31174 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31193__$1,(16),out,inst_31174);
} else {
if((state_val_31194 === (6))){
var inst_31187 = cljs.core.async.close_BANG_(out);
var state_31193__$1 = state_31193;
var statearr_31201_31232 = state_31193__$1;
(statearr_31201_31232[(2)] = inst_31187);

(statearr_31201_31232[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (17))){
var state_31193__$1 = state_31193;
var statearr_31202_31233 = state_31193__$1;
(statearr_31202_31233[(2)] = null);

(statearr_31202_31233[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (3))){
var inst_31191 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31193__$1,inst_31191);
} else {
if((state_val_31194 === (12))){
var inst_31170 = (state_31193[(2)]);
var inst_31171 = fluree.db.util.async.throw_err(inst_31170);
var _ = (function (){var statearr_31203 = state_31193;
(statearr_31203[(4)] = cljs.core.rest((state_31193[(4)])));

return statearr_31203;
})();
var state_31193__$1 = state_31193;
var statearr_31204_31234 = state_31193__$1;
(statearr_31204_31234[(2)] = inst_31171);

(statearr_31204_31234[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (2))){
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(4),nodes);
} else {
if((state_val_31194 === (19))){
var inst_31182 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31206_31235 = state_31193__$1;
(statearr_31206_31235[(2)] = inst_31182);

(statearr_31206_31235[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (11))){
var _ = (function (){var statearr_31207 = state_31193;
(statearr_31207[(4)] = cljs.core.rest((state_31193[(4)])));

return statearr_31207;
})();
var state_31193__$1 = state_31193;
var ex31205 = (state_31193__$1[(2)]);
var statearr_31208_31236 = state_31193__$1;
(statearr_31208_31236[(5)] = ex31205);


var statearr_31209_31237 = state_31193__$1;
(statearr_31209_31237[(1)] = (10));

(statearr_31209_31237[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (9))){
var inst_31174 = (state_31193[(8)]);
var inst_31174__$1 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31210 = state_31193;
(statearr_31210[(8)] = inst_31174__$1);

return statearr_31210;
})();
if(cljs.core.truth_(inst_31174__$1)){
var statearr_31211_31238 = state_31193__$1;
(statearr_31211_31238[(1)] = (13));

} else {
var statearr_31212_31239 = state_31193__$1;
(statearr_31212_31239[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (5))){
var state_31193__$1 = state_31193;
var statearr_31213_31240 = state_31193__$1;
(statearr_31213_31240[(2)] = null);

(statearr_31213_31240[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (14))){
var state_31193__$1 = state_31193;
var statearr_31214_31241 = state_31193__$1;
(statearr_31214_31241[(2)] = null);

(statearr_31214_31241[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (16))){
var inst_31177 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31177)){
var statearr_31215_31242 = state_31193__$1;
(statearr_31215_31242[(1)] = (17));

} else {
var statearr_31216_31243 = state_31193__$1;
(statearr_31216_31243[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (10))){
var inst_31162 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31217 = state_31193;
(statearr_31217[(9)] = inst_31162);

return statearr_31217;
})();
var statearr_31218_31244 = state_31193__$1;
(statearr_31218_31244[(2)] = null);

(statearr_31218_31244[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (18))){
var state_31193__$1 = state_31193;
var statearr_31219_31245 = state_31193__$1;
(statearr_31219_31245[(2)] = null);

(statearr_31219_31245[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (8))){
var inst_31160 = (state_31193[(7)]);
var _ = (function (){var statearr_31220 = state_31193;
(statearr_31220[(4)] = cljs.core.cons((11),(state_31193[(4)])));

return statearr_31220;
})();
var inst_31168 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_31160,t,novelty,fast_forward_db_QMARK_);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(12),inst_31168);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____0 = (function (){
var statearr_31221 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31221[(0)] = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__);

(statearr_31221[(1)] = (1));

return statearr_31221;
});
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____1 = (function (state_31193){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31193);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31222){var ex__16304__auto__ = e31222;
var statearr_31223_31246 = state_31193;
(statearr_31223_31246[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31193[(4)]))){
var statearr_31224_31247 = state_31193;
(statearr_31224_31247[(1)] = cljs.core.first((state_31193[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31248 = state_31193;
state_31193 = G__31248;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__ = function(state_31193){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____1.call(this,state_31193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____0;
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto____1;
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31225 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31225[(6)] = c__16375__auto___31226);

return statearr_31225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
});
/**
 * Returns a transducer that first extracts a flake set under the `:flakes` keys
 *   from it's input stream of index nodes, filters those flakes down to those
 *   between the `start-flake` and `end-flake` options according to the
 *   `start-test` and `end-test` options, respectively, and further filters the
 *   flake stream according to the `subject-fn`, `predicate-fn`, and `object-fn`
 *   options if they are present.
 */
fluree.db.query.range.indexed_flakes_xf = (function fluree$db$query$range$indexed_flakes_xf(p__31249){
var map__31250 = p__31249;
var map__31250__$1 = (((((!((map__31250 == null))))?(((((map__31250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31250):map__31250);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$start_DASH_test);
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$start_DASH_flake);
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$end_DASH_test);
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$end_DASH_flake);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$subject_DASH_fn);
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$predicate_DASH_fn);
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31250__$1,cljs.core.cst$kw$object_DASH_fn);
var flakes_xf = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$flakes);
var subrange_xf = fluree.db.query.range.flake_subrange_xf(start_test,start_flake,end_test,end_flake);
var xforms = (function (){var G__31252 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flakes_xf,subrange_xf], null);
var G__31252__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__31252,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__31253 = f.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__31253) : subject_fn.call(null,G__31253));
}))):G__31252);
var G__31252__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__31252__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__31254 = f.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__31254) : predicate_fn.call(null,G__31254));
}))):G__31252__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__31252__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__31255 = f.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__31255) : object_fn.call(null,G__31255));
})));
} else {
return G__31252__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,xforms);
});
fluree.db.query.range.extract_index_flakes = (function fluree$db$query$range$extract_index_flakes(node_stream,opts){
var index_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),fluree.db.query.range.indexed_flakes_xf(opts));
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(node_stream,index_chan);
});
/**
 * Returns a channel that contains the flakes from `flake-stream`, skipping the
 *   flakes from the first `offset` subjects encountered, including a maximum of
 *   `flake-limit` flakes from a maximum of `subject-limit` subjects.
 */
fluree.db.query.range.select_subject_window = (function fluree$db$query$range$select_subject_window(flake_stream,p__31256){
var map__31257 = p__31256;
var map__31257__$1 = (((((!((map__31257 == null))))?(((((map__31257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31257.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31257):map__31257);
var subject_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31257__$1,cljs.core.cst$kw$subject_DASH_limit);
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31257__$1,cljs.core.cst$kw$flake_DASH_limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31257__$1,cljs.core.cst$kw$offset);
var offset_subject_xf = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((function (f){
return f.s;
})),cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset));
var subject_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),offset_subject_xf);
var flake_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.cat);
return fluree.db.query.range.take_only(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.query.range.take_only(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(flake_stream,subject_ch),subject_limit),flake_ch),flake_limit);
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__31260 = arguments.length;
switch (G__31260) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31261 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31261,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31261,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31261,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31261,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__31264,idx,start_test,start_match,end_test,end_match,opts){
var map__31265 = p__31264;
var map__31265__$1 = (((((!((map__31265 == null))))?(((((map__31265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31265):map__31265);
var db = map__31265__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31265__$1,cljs.core.cst$kw$permissions);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31265__$1,cljs.core.cst$kw$t);
var map__31267 = opts;
var map__31267__$1 = (((((!((map__31267 == null))))?(((((map__31267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31267):map__31267);
var subject_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31267__$1,cljs.core.cst$kw$limit);
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31267__$1,cljs.core.cst$kw$flake_DASH_limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31267__$1,cljs.core.cst$kw$offset,(0));
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31267__$1,cljs.core.cst$kw$subject_DASH_fn);
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31267__$1,cljs.core.cst$kw$predicate_DASH_fn);
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31267__$1,cljs.core.cst$kw$object_DASH_fn);
var fast_forward_db_QMARK_ = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$novelty,idx], null));
var vec__31268 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31268,(5),null);
var vec__31271 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31271,(5),null);
var vec__31274 = (function (){var temp__5737__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5737__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5737__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__31277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31274,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31277,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31277,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31274,(1),null);
var out_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,idx_compare,flakes);
})));
var c__16375__auto___31319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31310){
var state_val_31311 = (state_31310[(1)]);
if((state_val_31311 === (1))){
var inst_31281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31282 = [s1,p1,o1__$1,t1,op1,m1];
var inst_31283 = (new cljs.core.PersistentVector(null,6,(5),inst_31281,inst_31282,null));
var inst_31284 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_31283);
var state_31310__$1 = state_31310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31310__$1,(2),inst_31284);
} else {
if((state_val_31311 === (2))){
var inst_31286 = (state_31310[(2)]);
var inst_31287 = fluree.db.util.async.throw_err(inst_31286);
var inst_31288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31289 = [s2,p2,o2__$1,t2,op2,m2];
var inst_31290 = (new cljs.core.PersistentVector(null,6,(5),inst_31288,inst_31289,null));
var inst_31291 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_31290);
var state_31310__$1 = (function (){var statearr_31312 = state_31310;
(statearr_31312[(7)] = inst_31287);

return statearr_31312;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31310__$1,(3),inst_31291);
} else {
if((state_val_31311 === (3))){
var inst_31287 = (state_31310[(7)]);
var inst_31293 = (state_31310[(2)]);
var inst_31294 = fluree.db.util.async.throw_err(inst_31293);
var inst_31295 = cljs.core.PersistentVector.EMPTY;
var inst_31296 = fluree.db.query.range.index_node_stream(db,idx,inst_31287,inst_31294);
var inst_31297 = fluree.db.query.range.resolve_nodes_to_t(inst_31296,novelty,fast_forward_db_QMARK_,t);
var inst_31298 = [cljs.core.cst$kw$subject_DASH_fn,cljs.core.cst$kw$predicate_DASH_fn,cljs.core.cst$kw$object_DASH_fn,cljs.core.cst$kw$start_DASH_test,cljs.core.cst$kw$start_DASH_flake,cljs.core.cst$kw$end_DASH_test,cljs.core.cst$kw$end_DASH_flake];
var inst_31299 = [subject_fn,predicate_fn,object_fn__$1,start_test,inst_31287,end_test,inst_31294];
var inst_31300 = cljs.core.PersistentHashMap.fromArrays(inst_31298,inst_31299);
var inst_31301 = fluree.db.query.range.extract_index_flakes(inst_31297,inst_31300);
var inst_31302 = fluree.db.query.range.filter_authorized(inst_31301,db,inst_31287,inst_31294);
var inst_31303 = [cljs.core.cst$kw$subject_DASH_limit,cljs.core.cst$kw$flake_DASH_limit,cljs.core.cst$kw$offset];
var inst_31304 = [subject_limit,flake_limit,offset];
var inst_31305 = cljs.core.PersistentHashMap.fromArrays(inst_31303,inst_31304);
var inst_31306 = fluree.db.query.range.select_subject_window(inst_31302,inst_31305);
var inst_31307 = cljs.core.async.into(inst_31295,inst_31306);
var inst_31308 = cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(inst_31307,out_chan);
var state_31310__$1 = state_31310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31310__$1,inst_31308);
} else {
return null;
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31313 = [null,null,null,null,null,null,null,null];
(statearr_31313[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31313[(1)] = (1));

return statearr_31313;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31310){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31310);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31314){var ex__16304__auto__ = e31314;
var statearr_31315_31320 = state_31310;
(statearr_31315_31320[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31310[(4)]))){
var statearr_31316_31321 = state_31310;
(statearr_31316_31321[(1)] = cljs.core.first((state_31310[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31322 = state_31310;
state_31310 = G__31322;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31310){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31317 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31317[(6)] = c__16375__auto___31319);

return statearr_31317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out_chan;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31378){
var state_val_31379 = (state_31378[(1)]);
if((state_val_31379 === (7))){
var inst_31352 = (state_31378[(7)]);
var inst_31342 = (state_31378[(8)]);
var inst_31350 = fluree.db.flake.Flake__GT_parts(inst_31342);
var inst_31351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(0),null);
var inst_31352__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(1),null);
var inst_31353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(2),null);
var inst_31354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(3),null);
var inst_31355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(4),null);
var inst_31356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(5),null);
var inst_31357 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_31353,inst_31352__$1);
var state_31378__$1 = (function (){var statearr_31380 = state_31378;
(statearr_31380[(7)] = inst_31352__$1);

(statearr_31380[(9)] = inst_31355);

(statearr_31380[(10)] = inst_31354);

(statearr_31380[(11)] = inst_31356);

(statearr_31380[(12)] = inst_31351);

return statearr_31380;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31378__$1,(10),inst_31357);
} else {
if((state_val_31379 === (1))){
var inst_31330 = flakes;
var inst_31331 = cljs.core.seq(inst_31330);
var inst_31332 = cljs.core.first(inst_31331);
var inst_31333 = cljs.core.next(inst_31331);
var inst_31334 = cljs.core.PersistentVector.EMPTY;
var inst_31335 = inst_31330;
var inst_31336 = inst_31334;
var state_31378__$1 = (function (){var statearr_31381 = state_31378;
(statearr_31381[(13)] = inst_31332);

(statearr_31381[(14)] = inst_31335);

(statearr_31381[(15)] = inst_31333);

(statearr_31381[(16)] = inst_31336);

return statearr_31381;
})();
var statearr_31382_31400 = state_31378__$1;
(statearr_31382_31400[(2)] = null);

(statearr_31382_31400[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (4))){
var inst_31342 = (state_31378[(8)]);
var inst_31345 = fluree.db.query.range.is_tag_flake_QMARK_(inst_31342);
var state_31378__$1 = state_31378;
if(inst_31345){
var statearr_31383_31401 = state_31378__$1;
(statearr_31383_31401[(1)] = (7));

} else {
var statearr_31384_31402 = state_31378__$1;
(statearr_31384_31402[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (6))){
var inst_31374 = (state_31378[(2)]);
var state_31378__$1 = state_31378;
var statearr_31385_31403 = state_31378__$1;
(statearr_31385_31403[(2)] = inst_31374);

(statearr_31385_31403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (3))){
var inst_31376 = (state_31378[(2)]);
var state_31378__$1 = state_31378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31378__$1,inst_31376);
} else {
if((state_val_31379 === (2))){
var inst_31342 = (state_31378[(8)]);
var inst_31335 = (state_31378[(14)]);
var inst_31341 = cljs.core.seq(inst_31335);
var inst_31342__$1 = cljs.core.first(inst_31341);
var inst_31343 = cljs.core.next(inst_31341);
var state_31378__$1 = (function (){var statearr_31386 = state_31378;
(statearr_31386[(8)] = inst_31342__$1);

(statearr_31386[(17)] = inst_31343);

return statearr_31386;
})();
if(cljs.core.truth_(inst_31342__$1)){
var statearr_31387_31404 = state_31378__$1;
(statearr_31387_31404[(1)] = (4));

} else {
var statearr_31388_31405 = state_31378__$1;
(statearr_31388_31405[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (9))){
var inst_31371 = (state_31378[(2)]);
var state_31378__$1 = state_31378;
var statearr_31389_31406 = state_31378__$1;
(statearr_31389_31406[(2)] = inst_31371);

(statearr_31389_31406[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (5))){
var inst_31336 = (state_31378[(16)]);
var state_31378__$1 = state_31378;
var statearr_31390_31407 = state_31378__$1;
(statearr_31390_31407[(2)] = inst_31336);

(statearr_31390_31407[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (10))){
var inst_31352 = (state_31378[(7)]);
var inst_31355 = (state_31378[(9)]);
var inst_31354 = (state_31378[(10)]);
var inst_31356 = (state_31378[(11)]);
var inst_31343 = (state_31378[(17)]);
var inst_31351 = (state_31378[(12)]);
var inst_31336 = (state_31378[(16)]);
var inst_31359 = (state_31378[(2)]);
var inst_31360 = fluree.db.util.async.throw_err(inst_31359);
var inst_31361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31362 = [inst_31351,inst_31352,inst_31360,inst_31354,inst_31355,inst_31356];
var inst_31363 = (new cljs.core.PersistentVector(null,6,(5),inst_31361,inst_31362,null));
var inst_31364 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_31363);
var inst_31365 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31336,inst_31364);
var inst_31335 = inst_31343;
var inst_31336__$1 = inst_31365;
var state_31378__$1 = (function (){var statearr_31391 = state_31378;
(statearr_31391[(14)] = inst_31335);

(statearr_31391[(16)] = inst_31336__$1);

return statearr_31391;
})();
var statearr_31392_31408 = state_31378__$1;
(statearr_31392_31408[(2)] = null);

(statearr_31392_31408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31379 === (8))){
var inst_31342 = (state_31378[(8)]);
var inst_31343 = (state_31378[(17)]);
var inst_31336 = (state_31378[(16)]);
var inst_31368 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31336,inst_31342);
var inst_31335 = inst_31343;
var inst_31336__$1 = inst_31368;
var state_31378__$1 = (function (){var statearr_31393 = state_31378;
(statearr_31393[(14)] = inst_31335);

(statearr_31393[(16)] = inst_31336__$1);

return statearr_31393;
})();
var statearr_31394_31409 = state_31378__$1;
(statearr_31394_31409[(2)] = null);

(statearr_31394_31409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0 = (function (){
var statearr_31395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31395[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__);

(statearr_31395[(1)] = (1));

return statearr_31395;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1 = (function (state_31378){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31378);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31396){var ex__16304__auto__ = e31396;
var statearr_31397_31410 = state_31378;
(statearr_31397_31410[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31378[(4)]))){
var statearr_31398_31411 = state_31378;
(statearr_31398_31411[(1)] = cljs.core.first((state_31378[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31412 = state_31378;
state_31378 = G__31412;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__ = function(state_31378){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1.call(this,state_31378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31399 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31399[(6)] = c__16375__auto__);

return statearr_31399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__31414 = arguments.length;
switch (G__31414) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31565){
var state_val_31566 = (state_31565[(1)]);
if((state_val_31566 === (62))){
var inst_31552 = (state_31565[(7)]);
var state_31565__$1 = state_31565;
var statearr_31567_31656 = state_31565__$1;
(statearr_31567_31656[(2)] = inst_31552);

(statearr_31567_31656[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (7))){
var state_31565__$1 = state_31565;
var statearr_31568_31657 = state_31565__$1;
(statearr_31568_31657[(2)] = false);

(statearr_31568_31657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (59))){
var inst_31544 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31569_31658 = state_31565__$1;
(statearr_31569_31658[(2)] = inst_31544);

(statearr_31569_31658[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (20))){
var state_31565__$1 = state_31565;
var statearr_31570_31659 = state_31565__$1;
(statearr_31570_31659[(2)] = null);

(statearr_31570_31659[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (58))){
var state_31565__$1 = state_31565;
var statearr_31571_31660 = state_31565__$1;
(statearr_31571_31660[(2)] = null);

(statearr_31571_31660[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (60))){
var inst_31540 = (state_31565[(2)]);
var inst_31541 = fluree.db.util.async.throw_err(inst_31540);
var state_31565__$1 = state_31565;
var statearr_31572_31661 = state_31565__$1;
(statearr_31572_31661[(2)] = inst_31541);

(statearr_31572_31661[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (27))){
var inst_31465 = (state_31565[(8)]);
var inst_31476 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_31465);
var state_31565__$1 = state_31565;
if(inst_31476){
var statearr_31573_31662 = state_31565__$1;
(statearr_31573_31662[(1)] = (30));

} else {
var statearr_31574_31663 = state_31565__$1;
(statearr_31574_31663[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (1))){
var state_31565__$1 = state_31565;
var statearr_31575_31664 = state_31565__$1;
(statearr_31575_31664[(2)] = null);

(statearr_31575_31664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (24))){
var inst_31426 = (state_31565[(9)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31426)){
var statearr_31576_31665 = state_31565__$1;
(statearr_31576_31665[(1)] = (27));

} else {
var statearr_31577_31666 = state_31565__$1;
(statearr_31577_31666[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (55))){
var inst_31546 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31578_31667 = state_31565__$1;
(statearr_31578_31667[(2)] = inst_31546);

(statearr_31578_31667[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (39))){
var inst_31496 = (state_31565[(2)]);
var inst_31497 = fluree.db.util.async.throw_err(inst_31496);
var state_31565__$1 = state_31565;
var statearr_31579_31668 = state_31565__$1;
(statearr_31579_31668[(2)] = inst_31497);

(statearr_31579_31668[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (46))){
var inst_31509 = (state_31565[(10)]);
var inst_31509__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_31565__$1 = (function (){var statearr_31580 = state_31565;
(statearr_31580[(10)] = inst_31509__$1);

return statearr_31580;
})();
if(cljs.core.truth_(inst_31509__$1)){
var statearr_31581_31669 = state_31565__$1;
(statearr_31581_31669[(1)] = (49));

} else {
var statearr_31582_31670 = state_31565__$1;
(statearr_31582_31670[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (4))){
var inst_31415 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31583_31671 = state_31565__$1;
(statearr_31583_31671[(2)] = inst_31415);

(statearr_31583_31671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (54))){
var inst_31465 = (state_31565[(8)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31465)){
var statearr_31584_31672 = state_31565__$1;
(statearr_31584_31672[(1)] = (57));

} else {
var statearr_31585_31673 = state_31565__$1;
(statearr_31585_31673[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (15))){
var inst_31427 = (state_31565[(11)]);
var inst_31446 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31427);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(18),inst_31446);
} else {
if((state_val_31566 === (48))){
var inst_31548 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31586_31674 = state_31565__$1;
(statearr_31586_31674[(2)] = inst_31548);

(statearr_31586_31674[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (50))){
var inst_31435 = (state_31565[(12)]);
var inst_31429 = (state_31565[(13)]);
var inst_31424 = (state_31565[(14)]);
var inst_31440 = (state_31565[(15)]);
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31509 = (state_31565[(10)]);
var inst_31513 = (function (){var t = inst_31428;
var temp__5733__auto__ = inst_31509;
var p = inst_31426;
var idx_predicate_QMARK_ = inst_31429;
var o = inst_31465;
var vec__31421 = inst_31424;
var tag_predicate_QMARK_ = inst_31435;
var s = inst_31425;
var o_coerce_QMARK_ = inst_31440;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_31565__$1 = state_31565;
var statearr_31587_31675 = state_31565__$1;
(statearr_31587_31675[(2)] = inst_31513);

(statearr_31587_31675[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (21))){
var inst_31461 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31588_31676 = state_31565__$1;
(statearr_31588_31676[(2)] = inst_31461);

(statearr_31588_31676[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (31))){
var state_31565__$1 = state_31565;
var statearr_31589_31677 = state_31565__$1;
(statearr_31589_31677[(2)] = false);

(statearr_31589_31677[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (32))){
var inst_31486 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31590_31678 = state_31565__$1;
(statearr_31590_31678[(2)] = inst_31486);

(statearr_31590_31678[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (40))){
var inst_31429 = (state_31565[(13)]);
var inst_31500 = cljs.core.not(inst_31429);
var state_31565__$1 = state_31565;
if(inst_31500){
var statearr_31591_31679 = state_31565__$1;
(statearr_31591_31679[(1)] = (43));

} else {
var statearr_31592_31680 = state_31565__$1;
(statearr_31592_31680[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (56))){
var inst_31531 = (state_31565[(2)]);
var inst_31532 = fluree.db.util.async.throw_err(inst_31531);
var state_31565__$1 = state_31565;
var statearr_31593_31681 = state_31565__$1;
(statearr_31593_31681[(2)] = inst_31532);

(statearr_31593_31681[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (33))){
var inst_31465 = (state_31565[(8)]);
var inst_31479 = cljs.core.fn_QMARK_(inst_31465);
var inst_31480 = (!(inst_31479));
var state_31565__$1 = state_31565;
var statearr_31594_31682 = state_31565__$1;
(statearr_31594_31682[(2)] = inst_31480);

(statearr_31594_31682[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (13))){
var inst_31427 = (state_31565[(11)]);
var inst_31444 = fluree.db.query.range.tag_string_QMARK_(inst_31427);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31444)){
var statearr_31595_31683 = state_31565__$1;
(statearr_31595_31683[(1)] = (15));

} else {
var statearr_31596_31684 = state_31565__$1;
(statearr_31596_31684[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (22))){
var inst_31457 = (state_31565[(2)]);
var inst_31458 = fluree.db.util.async.throw_err(inst_31457);
var state_31565__$1 = state_31565;
var statearr_31597_31685 = state_31565__$1;
(statearr_31597_31685[(2)] = inst_31458);

(statearr_31597_31685[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (36))){
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31492 = [inst_31426,inst_31465,inst_31425,inst_31428];
var inst_31493 = (new cljs.core.PersistentVector(null,4,(5),inst_31491,inst_31492,null));
var inst_31494 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_31493,opts);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(39),inst_31494);
} else {
if((state_val_31566 === (41))){
var inst_31426 = (state_31565[(9)]);
var state_31565__$1 = state_31565;
var statearr_31598_31686 = state_31565__$1;
(statearr_31598_31686[(2)] = inst_31426);

(statearr_31598_31686[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (43))){
var inst_31465 = (state_31565[(8)]);
var state_31565__$1 = state_31565;
var statearr_31599_31687 = state_31565__$1;
(statearr_31599_31687[(2)] = inst_31465);

(statearr_31599_31687[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (61))){
var inst_31552 = (state_31565[(7)]);
var inst_31554 = fluree.db.query.range.coerce_tag_flakes(db,inst_31552);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(64),inst_31554);
} else {
if((state_val_31566 === (29))){
var inst_31489 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31489)){
var statearr_31600_31688 = state_31565__$1;
(statearr_31600_31688[(1)] = (36));

} else {
var statearr_31601_31689 = state_31565__$1;
(statearr_31601_31689[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (44))){
var state_31565__$1 = state_31565;
var statearr_31602_31690 = state_31565__$1;
(statearr_31602_31690[(2)] = false);

(statearr_31602_31690[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (6))){
var inst_31426 = (state_31565[(9)]);
var inst_31431 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_31426);
var inst_31432 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_31431);
var state_31565__$1 = state_31565;
var statearr_31603_31691 = state_31565__$1;
(statearr_31603_31691[(2)] = inst_31432);

(statearr_31603_31691[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (28))){
var inst_31426 = (state_31565[(9)]);
var state_31565__$1 = state_31565;
var statearr_31604_31692 = state_31565__$1;
(statearr_31604_31692[(2)] = inst_31426);

(statearr_31604_31692[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (64))){
var inst_31556 = (state_31565[(2)]);
var inst_31557 = fluree.db.util.async.throw_err(inst_31556);
var state_31565__$1 = state_31565;
var statearr_31605_31693 = state_31565__$1;
(statearr_31605_31693[(2)] = inst_31557);

(statearr_31605_31693[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (51))){
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31515 = (state_31565[(2)]);
var inst_31516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31517 = [inst_31426,inst_31425,null,inst_31428];
var inst_31518 = (new cljs.core.PersistentVector(null,4,(5),inst_31516,inst_31517,null));
var inst_31519 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_31515);
var inst_31520 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31518,inst_31519);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(52),inst_31520);
} else {
if((state_val_31566 === (25))){
var inst_31435 = (state_31565[(12)]);
var inst_31552 = (state_31565[(2)]);
var state_31565__$1 = (function (){var statearr_31606 = state_31565;
(statearr_31606[(7)] = inst_31552);

return statearr_31606;
})();
if(cljs.core.truth_(inst_31435)){
var statearr_31607_31694 = state_31565__$1;
(statearr_31607_31694[(1)] = (61));

} else {
var statearr_31608_31695 = state_31565__$1;
(statearr_31608_31695[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (34))){
var inst_31429 = (state_31565[(13)]);
var state_31565__$1 = state_31565;
var statearr_31609_31696 = state_31565__$1;
(statearr_31609_31696[(2)] = inst_31429);

(statearr_31609_31696[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (17))){
var inst_31463 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31610_31697 = state_31565__$1;
(statearr_31610_31697[(2)] = inst_31463);

(statearr_31610_31697[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (3))){
var inst_31563 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31565__$1,inst_31563);
} else {
if((state_val_31566 === (12))){
var inst_31427 = (state_31565[(11)]);
var state_31565__$1 = state_31565;
var statearr_31611_31698 = state_31565__$1;
(statearr_31611_31698[(2)] = inst_31427);

(statearr_31611_31698[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (2))){
var inst_31424 = (state_31565[(14)]);
var inst_31426 = (state_31565[(9)]);
var _ = (function (){var statearr_31612 = state_31565;
(statearr_31612[(4)] = cljs.core.cons((5),(state_31565[(4)])));

return statearr_31612;
})();
var inst_31424__$1 = fparts;
var inst_31425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31424__$1,(0),null);
var inst_31426__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31424__$1,(1),null);
var inst_31427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31424__$1,(2),null);
var inst_31428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31424__$1,(3),null);
var inst_31429 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_31426__$1);
var state_31565__$1 = (function (){var statearr_31613 = state_31565;
(statearr_31613[(13)] = inst_31429);

(statearr_31613[(14)] = inst_31424__$1);

(statearr_31613[(16)] = inst_31425);

(statearr_31613[(17)] = inst_31428);

(statearr_31613[(9)] = inst_31426__$1);

(statearr_31613[(11)] = inst_31427);

return statearr_31613;
})();
if(cljs.core.truth_(inst_31426__$1)){
var statearr_31614_31699 = state_31565__$1;
(statearr_31614_31699[(1)] = (6));

} else {
var statearr_31615_31700 = state_31565__$1;
(statearr_31615_31700[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (23))){
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31468 = [inst_31425,inst_31426,inst_31465,inst_31428];
var inst_31469 = (new cljs.core.PersistentVector(null,4,(5),inst_31467,inst_31468,null));
var inst_31470 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31469,opts);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(26),inst_31470);
} else {
if((state_val_31566 === (47))){
var inst_31426 = (state_31565[(9)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31426)){
var statearr_31616_31701 = state_31565__$1;
(statearr_31616_31701[(1)] = (53));

} else {
var statearr_31617_31702 = state_31565__$1;
(statearr_31617_31702[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (35))){
var inst_31483 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31618_31703 = state_31565__$1;
(statearr_31618_31703[(2)] = inst_31483);

(statearr_31618_31703[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (19))){
var inst_31426 = (state_31565[(9)]);
var inst_31427 = (state_31565[(11)]);
var inst_31453 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31426);
var inst_31454 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31453),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31427)].join('');
var inst_31455 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31454);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(22),inst_31455);
} else {
if((state_val_31566 === (57))){
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31536 = [inst_31465,inst_31426,inst_31425,inst_31428];
var inst_31537 = (new cljs.core.PersistentVector(null,4,(5),inst_31535,inst_31536,null));
var inst_31538 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_31537,opts);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(60),inst_31538);
} else {
if((state_val_31566 === (11))){
var inst_31440 = (state_31565[(15)]);
var inst_31440__$1 = (state_31565[(2)]);
var inst_31441 = cljs.core.not(inst_31440__$1);
var state_31565__$1 = (function (){var statearr_31620 = state_31565;
(statearr_31620[(15)] = inst_31440__$1);

return statearr_31620;
})();
if(inst_31441){
var statearr_31621_31704 = state_31565__$1;
(statearr_31621_31704[(1)] = (12));

} else {
var statearr_31622_31705 = state_31565__$1;
(statearr_31622_31705[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (9))){
var inst_31427 = (state_31565[(11)]);
var inst_31437 = typeof inst_31427 === 'string';
var state_31565__$1 = state_31565;
var statearr_31623_31706 = state_31565__$1;
(statearr_31623_31706[(2)] = inst_31437);

(statearr_31623_31706[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (5))){
var _ = (function (){var statearr_31624 = state_31565;
(statearr_31624[(4)] = cljs.core.rest((state_31565[(4)])));

return statearr_31624;
})();
var state_31565__$1 = state_31565;
var ex31619 = (state_31565__$1[(2)]);
var statearr_31625_31707 = state_31565__$1;
(statearr_31625_31707[(5)] = ex31619);


if((ex31619 instanceof Error)){
var statearr_31626_31708 = state_31565__$1;
(statearr_31626_31708[(1)] = (4));

(statearr_31626_31708[(5)] = null);

} else {
throw ex31619;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (14))){
var inst_31425 = (state_31565[(16)]);
var inst_31465 = (state_31565[(2)]);
var state_31565__$1 = (function (){var statearr_31627 = state_31565;
(statearr_31627[(8)] = inst_31465);

return statearr_31627;
})();
if(cljs.core.truth_(inst_31425)){
var statearr_31628_31709 = state_31565__$1;
(statearr_31628_31709[(1)] = (23));

} else {
var statearr_31629_31710 = state_31565__$1;
(statearr_31629_31710[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (45))){
var inst_31504 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31630_31711 = state_31565__$1;
(statearr_31630_31711[(2)] = inst_31504);

(statearr_31630_31711[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (53))){
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31527 = [inst_31426,inst_31425,inst_31465,inst_31428];
var inst_31528 = (new cljs.core.PersistentVector(null,4,(5),inst_31526,inst_31527,null));
var inst_31529 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31528,opts);
var state_31565__$1 = state_31565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31565__$1,(56),inst_31529);
} else {
if((state_val_31566 === (26))){
var inst_31472 = (state_31565[(2)]);
var inst_31473 = fluree.db.util.async.throw_err(inst_31472);
var state_31565__$1 = state_31565;
var statearr_31631_31712 = state_31565__$1;
(statearr_31631_31712[(2)] = inst_31473);

(statearr_31631_31712[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (16))){
var inst_31427 = (state_31565[(11)]);
var inst_31451 = typeof inst_31427 === 'string';
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31451)){
var statearr_31632_31713 = state_31565__$1;
(statearr_31632_31713[(1)] = (19));

} else {
var statearr_31633_31714 = state_31565__$1;
(statearr_31633_31714[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (38))){
var inst_31550 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
var statearr_31634_31715 = state_31565__$1;
(statearr_31634_31715[(2)] = inst_31550);

(statearr_31634_31715[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (30))){
var inst_31429 = (state_31565[(13)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31429)){
var statearr_31635_31716 = state_31565__$1;
(statearr_31635_31716[(1)] = (33));

} else {
var statearr_31636_31717 = state_31565__$1;
(statearr_31636_31717[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (10))){
var inst_31435 = (state_31565[(12)]);
var state_31565__$1 = state_31565;
var statearr_31637_31718 = state_31565__$1;
(statearr_31637_31718[(2)] = inst_31435);

(statearr_31637_31718[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (18))){
var inst_31448 = (state_31565[(2)]);
var inst_31449 = fluree.db.util.async.throw_err(inst_31448);
var state_31565__$1 = state_31565;
var statearr_31638_31719 = state_31565__$1;
(statearr_31638_31719[(2)] = inst_31449);

(statearr_31638_31719[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (52))){
var inst_31522 = (state_31565[(2)]);
var inst_31523 = fluree.db.util.async.throw_err(inst_31522);
var state_31565__$1 = state_31565;
var statearr_31639_31720 = state_31565__$1;
(statearr_31639_31720[(2)] = inst_31523);

(statearr_31639_31720[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (42))){
var inst_31507 = (state_31565[(2)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31507)){
var statearr_31640_31721 = state_31565__$1;
(statearr_31640_31721[(1)] = (46));

} else {
var statearr_31641_31722 = state_31565__$1;
(statearr_31641_31722[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (37))){
var inst_31426 = (state_31565[(9)]);
var state_31565__$1 = state_31565;
if(cljs.core.truth_(inst_31426)){
var statearr_31642_31723 = state_31565__$1;
(statearr_31642_31723[(1)] = (40));

} else {
var statearr_31643_31724 = state_31565__$1;
(statearr_31643_31724[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (63))){
var inst_31560 = (state_31565[(2)]);
var _ = (function (){var statearr_31644 = state_31565;
(statearr_31644[(4)] = cljs.core.rest((state_31565[(4)])));

return statearr_31644;
})();
var state_31565__$1 = state_31565;
var statearr_31645_31725 = state_31565__$1;
(statearr_31645_31725[(2)] = inst_31560);

(statearr_31645_31725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (8))){
var inst_31435 = (state_31565[(12)]);
var inst_31435__$1 = (state_31565[(2)]);
var state_31565__$1 = (function (){var statearr_31646 = state_31565;
(statearr_31646[(12)] = inst_31435__$1);

return statearr_31646;
})();
if(cljs.core.truth_(inst_31435__$1)){
var statearr_31647_31726 = state_31565__$1;
(statearr_31647_31726[(1)] = (9));

} else {
var statearr_31648_31727 = state_31565__$1;
(statearr_31648_31727[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31566 === (49))){
var inst_31435 = (state_31565[(12)]);
var inst_31429 = (state_31565[(13)]);
var inst_31424 = (state_31565[(14)]);
var inst_31440 = (state_31565[(15)]);
var inst_31425 = (state_31565[(16)]);
var inst_31428 = (state_31565[(17)]);
var inst_31426 = (state_31565[(9)]);
var inst_31465 = (state_31565[(8)]);
var inst_31509 = (state_31565[(10)]);
var inst_31511 = (function (){var obj_fn = inst_31509;
var t = inst_31428;
var temp__5733__auto__ = inst_31509;
var p = inst_31426;
var idx_predicate_QMARK_ = inst_31429;
var o = inst_31465;
var vec__31421 = inst_31424;
var tag_predicate_QMARK_ = inst_31435;
var s = inst_31425;
var o_coerce_QMARK_ = inst_31440;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_31565__$1 = state_31565;
var statearr_31649_31728 = state_31565__$1;
(statearr_31649_31728[(2)] = inst_31511);

(statearr_31649_31728[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31650 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31650[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31650[(1)] = (1));

return statearr_31650;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31565){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31565);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31651){var ex__16304__auto__ = e31651;
var statearr_31652_31729 = state_31565;
(statearr_31652_31729[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31565[(4)]))){
var statearr_31653_31730 = state_31565;
(statearr_31653_31730[(1)] = cljs.core.first((state_31565[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31731 = state_31565;
state_31565 = G__31731;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31565){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31654 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31654[(6)] = c__16375__auto__);

return statearr_31654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__31733 = arguments.length;
switch (G__31733) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_31768){
var state_val_31769 = (state_31768[(1)]);
if((state_val_31769 === (7))){
var inst_31755 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_31756 = ["Invalid collection name: ",inst_31755].join('');
var inst_31757 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31758 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_31759 = cljs.core.PersistentHashMap.fromArrays(inst_31757,inst_31758);
var inst_31760 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31756,inst_31759);
var inst_31761 = (function(){throw inst_31760})();
var state_31768__$1 = state_31768;
var statearr_31770_31790 = state_31768__$1;
(statearr_31770_31790[(2)] = inst_31761);

(statearr_31770_31790[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (1))){
var state_31768__$1 = state_31768;
var statearr_31771_31791 = state_31768__$1;
(statearr_31771_31791[(2)] = null);

(statearr_31771_31791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (4))){
var inst_31734 = (state_31768[(2)]);
var state_31768__$1 = state_31768;
var statearr_31772_31792 = state_31768__$1;
(statearr_31772_31792[(2)] = inst_31734);

(statearr_31772_31792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (6))){
var inst_31740 = (state_31768[(7)]);
var inst_31742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31743 = fluree.db.flake.max_subject_id(inst_31740);
var inst_31744 = [inst_31743];
var inst_31745 = (new cljs.core.PersistentVector(null,1,(5),inst_31742,inst_31744,null));
var inst_31746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31747 = fluree.db.flake.min_subject_id(inst_31740);
var inst_31748 = [inst_31747];
var inst_31749 = (new cljs.core.PersistentVector(null,1,(5),inst_31746,inst_31748,null));
var inst_31750 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_31745,cljs.core._LT__EQ_,inst_31749,opts);
var state_31768__$1 = state_31768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31768__$1,(9),inst_31750);
} else {
if((state_val_31769 === (3))){
var inst_31766 = (state_31768[(2)]);
var state_31768__$1 = state_31768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31768__$1,inst_31766);
} else {
if((state_val_31769 === (2))){
var inst_31740 = (state_31768[(7)]);
var _ = (function (){var statearr_31774 = state_31768;
(statearr_31774[(4)] = cljs.core.cons((5),(state_31768[(4)])));

return statearr_31774;
})();
var inst_31740__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_31768__$1 = (function (){var statearr_31775 = state_31768;
(statearr_31775[(7)] = inst_31740__$1);

return statearr_31775;
})();
if(cljs.core.truth_(inst_31740__$1)){
var statearr_31776_31793 = state_31768__$1;
(statearr_31776_31793[(1)] = (6));

} else {
var statearr_31777_31794 = state_31768__$1;
(statearr_31777_31794[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (9))){
var inst_31752 = (state_31768[(2)]);
var inst_31753 = fluree.db.util.async.throw_err(inst_31752);
var state_31768__$1 = state_31768;
var statearr_31778_31795 = state_31768__$1;
(statearr_31778_31795[(2)] = inst_31753);

(statearr_31778_31795[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (5))){
var _ = (function (){var statearr_31779 = state_31768;
(statearr_31779[(4)] = cljs.core.rest((state_31768[(4)])));

return statearr_31779;
})();
var state_31768__$1 = state_31768;
var ex31773 = (state_31768__$1[(2)]);
var statearr_31780_31796 = state_31768__$1;
(statearr_31780_31796[(5)] = ex31773);


var statearr_31781_31797 = state_31768__$1;
(statearr_31781_31797[(1)] = (4));

(statearr_31781_31797[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31769 === (8))){
var inst_31763 = (state_31768[(2)]);
var _ = (function (){var statearr_31782 = state_31768;
(statearr_31782[(4)] = cljs.core.rest((state_31768[(4)])));

return statearr_31782;
})();
var state_31768__$1 = state_31768;
var statearr_31783_31798 = state_31768__$1;
(statearr_31783_31798[(2)] = inst_31763);

(statearr_31783_31798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16301__auto__ = null;
var fluree$db$query$range$state_machine__16301__auto____0 = (function (){
var statearr_31784 = [null,null,null,null,null,null,null,null];
(statearr_31784[(0)] = fluree$db$query$range$state_machine__16301__auto__);

(statearr_31784[(1)] = (1));

return statearr_31784;
});
var fluree$db$query$range$state_machine__16301__auto____1 = (function (state_31768){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_31768);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e31785){var ex__16304__auto__ = e31785;
var statearr_31786_31799 = state_31768;
(statearr_31786_31799[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_31768[(4)]))){
var statearr_31787_31800 = state_31768;
(statearr_31787_31800[(1)] = cljs.core.first((state_31768[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__31801 = state_31768;
state_31768 = G__31801;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16301__auto__ = function(state_31768){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16301__auto____1.call(this,state_31768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16301__auto____0;
fluree$db$query$range$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16301__auto____1;
return fluree$db$query$range$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_31788 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_31788[(6)] = c__16375__auto__);

return statearr_31788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__31805 = flakes;
var vec__31806 = G__31805;
var seq__31807 = cljs.core.seq(vec__31806);
var first__31808 = cljs.core.first(seq__31807);
var seq__31807__$1 = cljs.core.next(seq__31807);
var flake_SINGLEQUOTE_ = first__31808;
var r = seq__31807__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31805__$1 = G__31805;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31815 = G__31805__$1;
var seq__31816 = cljs.core.seq(vec__31815);
var first__31817 = cljs.core.first(seq__31816);
var seq__31816__$1 = cljs.core.next(seq__31816);
var flake_SINGLEQUOTE___$1 = first__31817;
var r__$1 = seq__31816__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e31819){var e = e31819;
return null;
}})();
var map__31818 = cmd_map;
var map__31818__$1 = (((((!((map__31818 == null))))?(((((map__31818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31818.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31818):map__31818);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,cljs.core.cst$kw$expire);
var G__31821 = r__$1;
var G__31822 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__31805__$1 = G__31821;
result_STAR___$1 = G__31822;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__31831 = blocks;
var vec__31832 = G__31831;
var seq__31833 = cljs.core.seq(vec__31832);
var first__31834 = cljs.core.first(seq__31833);
var seq__31833__$1 = cljs.core.next(seq__31833);
var block_SINGLEQUOTE_ = first__31834;
var r = seq__31833__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31831__$1 = G__31831;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31840 = G__31831__$1;
var seq__31841 = cljs.core.seq(vec__31840);
var first__31842 = cljs.core.first(seq__31841);
var seq__31841__$1 = cljs.core.next(seq__31841);
var block_SINGLEQUOTE___$1 = first__31842;
var r__$1 = seq__31841__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__31843 = block_SINGLEQUOTE___$1;
var map__31843__$1 = (((((!((map__31843 == null))))?(((((map__31843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31843.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31843):map__31843);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31843__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31843__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31843__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31823_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31823_SHARP_.p,(2))){
return p1__31823_SHARP_.o;
} else {
return null;
}
});})(G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31824_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31824_SHARP_.p,(1))){
return p1__31824_SHARP_.o;
} else {
return null;
}
});})(G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31825_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31825_SHARP_.p,(5))){
return p1__31825_SHARP_.o;
} else {
return null;
}
});})(G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,instant,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31826_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31826_SHARP_.p,(7))){
return p1__31826_SHARP_.o;
} else {
return null;
}
});})(G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,instant,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31827_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31827_SHARP_.p,(106));
});})(G__31831__$1,result_STAR___$1,map__31843,map__31843__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31840,seq__31841,first__31842,seq__31841__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31831,vec__31832,seq__31833,first__31834,seq__31833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__31845 = r__$1;
var G__31846 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__31831__$1 = G__31845;
result_STAR___$1 = G__31846;
continue;
}
break;
}
});
